!!--------- Detect point group via SYVA
!ishow=1: Output prompt =0: Do not print
subroutine detectPG(ishow)
use defvar
implicit real*8 (a-h,o-z)
integer ishow
real*8 tmpmat(3,ncenter)
character PGlabel3*3 !Used for input and output from PG_eqvatm, whose point group label only has three characters

if (PGlabelinit=="?") then !Not directly specified in .ini file
    if (ishow==1) write(*,*) "Detecting point group..."
    tmpmat(1,:)=a%x
    tmpmat(2,:)=a%y
    tmpmat(3,:)=a%z
    !This tolerance is suitable for most systems. 0.01 may be too tight, however if the criterion is loosen, in rare case &
    !The SYVA routine will ceaselessly show "ERROR: Too many symmetry operations. Try a lower tolerance" and doesn't work
    call PG_eqvatm(ncenter,a%index,tmpmat,0.01D0,PGlabel3)
    if (PGlabel3==" ") then
        do i=1,20
            call PG_eqvatm(ncenter,a%index,tmpmat,i*0.005D0,PGlabel3)
            if (PGlabel3/=" ") exit
        end do
    end if
    if (PGlabel3==" ") then
        write(*,*) "Warning: Failed to detect point group, point group will be regarded as C1"
        PGlabel="C1  "
    else
        if (ishow==1) write(*,*) "Point group has been successfully detected"
        PGlabel=" "
        PGlabel(1:3)=PGlabel3
    end if
else
    PGlabel=PGlabelinit
    !write(*,"(' Point group is ',a,' as requested by users')") trim(PGlabel)
end if
call PGlabel2rotsym
end subroutine




!!------- Convert point group label (PGlabel) to rotational symmetry number (rotsym)
!Point group labels that can be returned by SYVA. But current routine is not limited to these
!'C1 ','Cs ','Ci ','C2 ','C3 ','C4 ','C5 ','C6 ','C7 ','C8 ','D2 ',
!'D3 ','D4 ','D5 ','D6 ','D7 ','D8 ','C2v','C3v','C4v','C5v','C6v',
!'C7v','C8v','C2h','C3h','C4h','C5h','C6h','C7h','C8h','D2h','D3h',
!'D4h','D5h','D6h','D7h','D8h','D2d','D3d','D4d','D5d','D6d','D7d',
!'D8d','S4 ','S6 ','S8 ','T  ',F ','Td ','O  ','Oh ','I  ','Ih ',
!'Civ','Dih'
subroutine PGlabel2rotsym
use defvar
integer ie
ie=len_trim(PGlabel)
if (PGlabel=='C1'.or.PGlabel=='Ci'.or.PGlabel=='Cs'.or.PGlabel=='Civ') then
    rotsym=1
else if (PGlabel=='Dih') then
    rotsym=2
else if (PGlabel=='Ih') then
    rotsym=60
else if (PGlabel(1:1)=='S') then
    read(PGlabel(2:),*) rotsym
    rotsym=rotsym/2
else if (PGlabel=='T'.or.PGlabel=='Td'.or.PGlabel=='Th') then !Rotsym of Th is in line with link 717 of Gaussian
    rotsym=12
else if (PGlabel=='Oh') then
    rotsym=24
else if (PGlabel(1:1)=='C') then
    read(PGlabel(2:ie),*,iostat=ierror) rotsym
    if (ierror/=0) read(PGlabel(2:ie-1),*) rotsym !The label is e.g. C2v
else if (PGlabel(1:1)=='D') then
    read(PGlabel(2:ie),*,iostat=ierror) rotsym
    if (ierror/=0) read(PGlabel(2:ie-1),*) rotsym !The label is e.g. D2h
    rotsym=rotsym*2
else !Although SYVA can also identify '  O' and '  I', rotsym is not available
    if (command_argument_count()==0) then !Run in interactive mode
        write(*,"(a)") " Warning: Rotational symmetry number cannot be identified for point group "//trim(PGlabel)
        write(*,*) "Please manually input rotational symmetry number here, e.g. 6"
        read(*,*) rotsym
    else
        write(*,"(a)") " Warning: Cannot identify point group! Assume rotational symmetry number to be 1"
        rotsym=1
    end if
end if
end subroutine




!!------- Get point group by invoking SYVA routines. This is reduced version of that in Multiwfn
!The tolerance affects whether symmetry-equivalence atoms and point group could be successfully recognized, the value
!should not be too large, otherwise the recognition may be completely failed!
!  Input variables:
!natoms: The number of inputted atoms
!nat(1:natoms): Element index of all inputted atoms
!coord(1:3,1:natoms): x,y,z of all inputted atoms in Angstrom
!delta: Representing the distortion of the geometry. 0.01 is aproximately identical to "default" in gview, 0.1 corresponds to loose
!  Returned variables: PGlab (Point group label)
subroutine PG_eqvatm(natoms,nat,coord,delta,PGlab)
implicit real*8 (a-h,o-z)
common /data/ wt(90),symb(90)
common /chartab/ nir(2,55),chtab(14,322),nsymop(14,4,55),nrotharm(3,322),pgsymb(57),irsymb(322)
common /subgroups/ nsgb(2,57),nsgr(406)
character symb*2,PGlab*3,irsymb*4
integer natoms
integer,parameter :: nmax=150 !nmat: maximum number of symmetic operation
real*8 coord(3,natoms),delta,pc(3),symn(3,nmax)
integer nat(natoms),nper(natoms,250),nscl(natoms,natoms),nccl(natoms),nsym(nmax,5)

if (natoms==1) then
    PGlab="C1"
    return
end if

ncr=0
nsr=0
nsg=0
nout=0 !Suppress almost all output of SYVA routines

!Calculation of the COM (centre of mass) of the molecule
call syva_cmass(natoms,nat,wt,coord,wmol,cmx,cmy,cmz)
pc(1)=cmx;pc(2)=cmy;pc(3)=cmz

!Shift the origin of the Cartesian system to COM
call syva_cshift(natoms,coord,pc)

!Find symmetry operations
call sym_elements(natoms,nat,coord,symb,delta,ng,ni,nsg,ncr,nsr,np,symn,nsym,nout,nprm,nper,nseq,nccl,nscl)

!Detemines the equivalence classes defined by the symmetry operations
call symclass(natoms,nprm,nper,nseq,nccl,nscl,nat,symb,nout)

!Determine point group and framework group
call syva_point_group(ng,ni,nsg,ncr,nsr,np,PGlab,nout)

end subroutine