!!--------- Load running parameters from arguments
subroutine loadarguments
use defvar
character c80tmp*80,c200tmp*200

narg=command_argument_count()
call get_command(c200tmp)
write(*,"(' Command of invoking Shermo:',/,1x,a)") trim(c200tmp)
if (narg>1) write(*,*) "Note: One or more running parameters are overridden by arguments"
iarg=2
do while(iarg<=narg)
    call get_command_argument(iarg,c80tmp)
    if (c80tmp=="-E") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) Eexter
    else if (c80tmp=="-prtvib") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) prtvib
    else if (c80tmp=="-T") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*,iostat=ierror) Tlow,Thigh,Tstep
        if (ierror/=0) read(c80tmp,*) T
    else if (c80tmp=="-P") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*,iostat=ierror) Plow,Phigh,Pstep
        if (ierror/=0) read(c80tmp,*) P
    else if (c80tmp=="-sclZPE") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) sclZPE
    else if (c80tmp=="-sclheat") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) sclheat
    else if (c80tmp=="-sclS") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) sclS
    else if (c80tmp=="-sclCV") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) sclCV
    else if (c80tmp=="-ilowfreq") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) ilowfreq
    else if (c80tmp=="-ravib") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) ravib
    else if (c80tmp=="-imode") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) imode
    else if (c80tmp=="-imagreal") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) imagreal
    else if (c80tmp=="-conc") then
        iarg=iarg+1
        call get_command_argument(iarg,concstr)
    else if (c80tmp=="-outshm") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) outshm
    else if (c80tmp=="-defmass") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) defmass
    else if (c80tmp=="-PGlabel") then
        iarg=iarg+1
        call get_command_argument(iarg,c80tmp)
        read(c80tmp,*) PGlabelinit
    else if (c80tmp=="-noset") then
        continue
    else
        write(*,*) "Error: Unable to recognize argument "//trim(c80tmp)
        stop
    end if
    iarg=iarg+1
end do
end subroutine



!!-------- Load settings.ini
subroutine loadsettings
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80,c200tmp*200,settingpath*200
inquire(file="settings.ini",exist=alive)
if (alive) then
    settingpath="settings.ini"
else
    call getenv("Shermopath",c200tmp)
    if (isys==1) then
	    settingpath=trim(c200tmp)//"\settings.ini"
    else if (isys==2) then
	    settingpath=trim(c200tmp)//"/settings.ini"
    end if
end if
inquire(file=settingpath,exist=alive)
if (alive) then
    write(*,*)
    write(*,*) "Loading running parameters from settings.ini..."
    open(10,file=settingpath,status="old")
    
    call get_option_str(10,"E=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) Eexter
    call get_option_str(10,"prtvib=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) prtvib
    call get_option_str(10,"T=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*,iostat=ierror) Tlow,Thigh,Tstep
    if (ierror/=0) read(c80tmp,*) T
    call get_option_str(10,"P=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*,iostat=ierror) Plow,Phigh,Pstep
    if (ierror/=0) read(c80tmp,*) P
    
    call get_option_str(10,"sclZPE=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) sclZPE
    call get_option_str(10,"sclheat=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) sclheat
    call get_option_str(10,"sclS=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) sclS
    call get_option_str(10,"sclCV=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) sclCV
    call get_option_str(10,"ilowfreq=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) ilowfreq
    call get_option_str(10,"ravib=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) ravib
    call get_option_str(10,"intpvib=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) intpvib
    call get_option_str(10,"imagreal=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) imagreal
    call get_option_str(10,"imode=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) imode
    call get_option_str(10,"conc=",concstr)
    call get_option_str(10,"outshm=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) outshm
    call get_option_str(10,"PGlabel=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) PGlabelinit
    call get_option_str(10,"defmass=",c80tmp)
    if (c80tmp/=" ") read(c80tmp,*) defmass
    close(10)
else
    write(*,*)
    write(*,"(a)") " Warning: settings.ini cannot be found in either current folder or the directory defined by Shermopath environment, &
    thus default parameters are used!"
end if
end subroutine



!!--------- Load modification on default atomic masses
subroutine modmass
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80

inquire(file="settings.ini",exist=alive)
if (alive) then
    open(10,file="settings.ini",status="old")
    call loclabel(10,"modmass",ifound)
    if (ifound==1) then
        read(10,*)
        do while(.true.)
            read(10,*,iostat=ierror) iatm,c80tmp
            if (ierror/=0) exit
            ic=index(c80tmp,'.')
            if (ic==0) then !Integer
                read(c80tmp,*) isotmp
                a(iatm)%mass=isomass(a(iatm)%index,isotmp)
                if (a(iatm)%mass==0) then
                    write(*,"(' Error: No isotope',i4,' for atom',i6,'!')") isotmp,iatm
                    write(*,*) "Press ENTER button to exit"
                    read(*,*)
                    stop
                end if
            else
                read(c80tmp,*) a(iatm)%mass
            end if
            write(*,"(' Mass of atom',i6,'(',a,') has been modified to',f12.6,' amu')") iatm,ind2name(a(iatm)%index),a(iatm)%mass
        end do
    end if
    close(10)
end if
end subroutine


    
!!----------- Set mass for all atom, namely filling a%mass. Only for defmass=1 or 2
subroutine setatmmass
use defvar
do iatm=1,ncenter
    idx=a(iatm)%index
    if (defmass==1) then !Element weight
        a(iatm)%mass=elemass(idx)
    else if (defmass==2) then !Mass of most abundant isotope or longest-living one
        imax=maxloc(isowei(idx,:),1)
        a(iatm)%mass=isomass(idx,imax)
    end if
end do
end subroutine



!--------- Determine the present file was output of file of which code
!1=by Gaussian, 2=by ORCA, 3=by GAMESS-US, 4=by NWChem, 5=by CP2K, 6=xtb g98.out, 0=Undetermined
subroutine deterprog(iprog)
use defvar
use util
integer iprog,ifound
open(10,file=inputfile,status="old")

call loclabel(10,"generated by the xtb code",ifound,maxline=200)
if (ifound==1) then
    iprog=6
    return
end if
call loclabel(10,"Gaussian, Inc",ifound,maxline=200)
if (ifound==0) call loclabel(10,"Entering Gaussian System",ifound,maxline=200)
if (ifound==1) then
    iprog=1
    return
end if
call loclabel(10,"O   R   C   A",ifound,maxline=200)
if (ifound==1) then
    iprog=2
    return
end if
call loclabel(10,"GAMESS VERSION =",ifound,maxline=200)
if (ifound==1) then
    iprog=3
    return
end if
call loclabel(10,"Northwest Computational Chemistry Package",ifound,maxline=200)
if (ifound==1) then
    iprog=4
    return
end if
call loclabel(10,"CP2K|",ifound,maxline=200)
if (ifound==1) then
    iprog=5
    return
end if
iprog=0
end subroutine



!!-------- Output data to .shm file
subroutine outshmfile
use defvar
implicit real*8 (a-h,o-z)
character shmpath*200
itmp=index(inputfile,'.',back=.true.)
shmpath=inputfile(1:itmp)//"shm"
write(*,"(a)") " Outputting data to "//trim(shmpath)
open(10,file=shmpath,status="replace")
write(10,"(a)") "*E  //Electronic energy (a.u.)"
write(10,"(f20.10)") E
write(10,"(a)") "*wavenum  //Wavenumbers (cm-1). Negative value means imaginary frequency"
do ifreq=1,nfreq
    write(10,"(f10.4)") wavenum(ifreq)
end do
write(10,"(a)") "*atoms  //Information of all atoms: Name, mass (amu), X, Y, Z (Angstrom)"
do iatm=1,ncenter
    write(10,"(a,4f12.6)") ind2name(a(iatm)%index),a(iatm)%mass,a(iatm)%x,a(iatm)%y,a(iatm)%z
end do
write(10,"(a)") "*elevel  //Energy (eV) and degeneracy of electronic energy levels"
do ie=1,nelevel
    write(10,"(f12.6,i4)") elevel(ie),edegen(ie)
end do
close(10)
write(*,"(1x,a)") trim(shmpath)//" has been successfully generated!"
end subroutine



!!--------  Convert element name to element index
subroutine elename2idx(name,iele)
use defvar
character(len=*) name
integer iele
do iele=1,nelesupp
    if (ind2name(iele)==name) return
end do
end subroutine