!!-------- Load data from .shm file
subroutine loadshm
use defvar
use util
implicit real*8 (a-h,o-z)
character strtmp*20,c80tmp*80

open(10,file=inputfile,status="old")
call loclabel(10,"*E");read(10,*)
read(10,*) E

call loclabel(10,"*wavenum");read(10,*)
nfreq=0
do while(.true.)
    read(10,*,iostat=ierror) tmpval
    if (ierror==0) then
        nfreq=nfreq+1
    else
        exit
    end if
end do
allocate(wavenum(nfreq))
call loclabel(10,"*wavenum");read(10,*)
read(10,*) wavenum

call loclabel(10,"*atoms");read(10,*)
ncenter=0
do while(.true.)
    read(10,*,iostat=ierror) c80tmp
    if (ierror/=0.or.c80tmp==" ".or.index(c80tmp,'*')/=0) then
        exit
    else
        ncenter=ncenter+1
    end if
end do
allocate(a(ncenter))
call loclabel(10,"*atoms");read(10,*)
do iatm=1,ncenter
    read(10,*) strtmp,a(iatm)%mass,a(iatm)%x,a(iatm)%y,a(iatm)%z
    call elename2idx(strtmp,a(iatm)%index)
end do

call loclabel(10,"*elevel");read(10,*)
nelevel=0
do while(.true.)
    read(10,*,iostat=ierror) c80tmp
    if (ierror/=0.or.c80tmp==" ".or.index(c80tmp,'*')/=0) then
        exit
    else
        nelevel=nelevel+1
    end if
end do
allocate(elevel(nelevel),edegen(nelevel))
call loclabel(10,"*elevel");read(10,*)
do ie=1,nelevel
    read(10,"(a)") c80tmp
    read(c80tmp,*,iostat=ierror) elevel(ie),edegen(ie)
    if (ierror/=0) then
        read(c80tmp,*) elevel(ie)
        edegen(ie)=1
    end if
end do
spinmult=0
close(10)
end subroutine


    
!!-------- Load data from output file of Gaussian to obtain data needed by thermochemistry quantity evaluation
subroutine loadgau
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80
real*8 eigvecmat(3,3),eigvalarr(3)

open(10,file=inputfile,status="old")
call loclabel(10,"Sum of electronic and zero-point Energies=",ifound)
call readaftersign(10,'=',tmp1)
call loclabel(10,"Zero-point correction=",ifound)
call readaftersign(10,'=',tmp2)
E=tmp1-tmp2
call loclabel(10,"Multiplicity =",ifound)
if (ifound==0) then
    spinmult=1
    write(*,*) "Note: ""Multiplicity ="" cannot be found, set spin multiplicity to 1"
else
    call readaftersign_int(10,'=',spinmult)
end if
!call loclabel(10,"Rotational symmetry number",ifound) !Use Shermo own code to identify this
!read(10,"(a)") c80tmp
!read(c80tmp(28:30),*) rotsym

!Set atom index,x,y,z
call loadGaugeom(10)

!Set mass
if (defmass==1.or.defmass==2) then
    call setatmmass
else if (defmass==3) then
    call loclabel(10,"has atomic number",ifound)
    if (ifound==0) then
        write(*,*) "Error: Unable to find atomic mass information!"
        write(*,*) "If you have used #T for your freq task, you should use # instead"
        write(*,*) "Press ENTER button to exit program"
        read(*,*)
        stop
    end if
    do iatm=1,ncenter
        call readaftersign(10,"mass",a(iatm)%mass)
    end do
end if

!Load frequencies
call loadGaufreq(10)
close(10)
end subroutine


!!------ Load geometry from Gaussian output file. For opt task, load the final one
!first try to load input orientation, if it is not found, load standard orientation instead
subroutine loadGaugeom(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80,locstr*40
do itime=1,2
    if (itime==1) then 
        locstr="Input orientation:"
    else if (itime==2) then 
        locstr="Standard orientation:"
    end if
    nskip=0
    rewind(ifileid)
    do while(.true.) !Find the final geometry. nskip is the number of labels to be skipped
        call loclabel(ifileid,locstr,ifound,0)
        if (ifound==0) exit
        nskip=nskip+1
        read(ifileid,*)
    end do
    if (nskip>0) then !Found at least once
        call loclabel(ifileid,locstr,ifound)
        call skiplines(ifileid,5)
        ncenter=0
        do while(.true.)
            read(ifileid,"(a)") c80tmp
            if (index(c80tmp,"----")/=0) exit
            ncenter=ncenter+1
        end do
        allocate(a(ncenter))
        rewind(ifileid)
        do iload=1,nskip
            call loclabel(ifileid,locstr,ifound,0)
            read(ifileid,*)
        end do
        call skiplines(ifileid,4)
        do iatm=1,ncenter
            read(ifileid,*) inouse,a(iatm)%index,inouse,a(iatm)%x,a(iatm)%y,a(iatm)%z
        end do
        !if (itime==1) write(*,*) "Geometry (final, input orientation) has been loaded from this file"
        !if (itime==2) write(*,*) "Geometry (final, standard orientation) has been loaded from this file"
        exit
    else
        if (itime==2) then
            write(*,*) "Error: Failed to load geometry from this file!"
            write(*,*) "Press ENTER button to exit"
            read(*,*)
            stop
        end if
    end if
end do
end subroutine


!!-------- Load harmonic frequencies from Gaussian output file
subroutine loadGaufreq(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
integer ifileid
character*20 c1,c2,c3
character*200 c200tmp
!Find how many frequencies in the file
rewind(ifileid)
nfreq=0
do while(.true.)
	call loclabel(ifileid,"Frequencies -- ",ifound,0) !HPmodes is also compatible, because in this manner we locate to the traditional output section
	if (ifound==1) then
		backspace(ifileid);backspace(ifileid)
        read(ifileid,"(a)") c200tmp
		read(c200tmp,*,iostat=ierror) c1,c2,c3
        if (ierror==0) then
            nadd=3
		else
			read(c200tmp,*,iostat=ierror) c1,c2
            if (ierror==0) then
                nadd=2
			else
				nadd=1
			end if
		end if
		read(ifileid,*);read(ifileid,*)
        nfreq=nfreq+nadd
	else
		exit
	end if
end do
rewind(ifileid)
write(*,"(' Number of vibrations to load:',i10)") nfreq

!Load harmonic data
allocate(wavenum(nfreq))
ilackdata=nfreq
inow=1
do while(.true.)
	if (ilackdata>3) then
		iread=3
	else
		iread=ilackdata
	end if
	call loclabel(ifileid,"Frequencies -- ",ifound,0)
	read(ifileid,"(16x)",advance="no")
	if (iread==1) read(ifileid,*) wavenum(inow)
	if (iread==2) read(ifileid,*) wavenum(inow),wavenum(inow+1)
	if (iread==3) read(ifileid,*) wavenum(inow),wavenum(inow+1),wavenum(inow+2)
	if (ilackdata<=3) exit
	ilackdata=ilackdata-3
	inow=inow+3
end do
end subroutine


    
!!-------- Load data from output file of CP2K to obtain data needed by thermochemistry quantity evaluation
subroutine loadCP2K
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80,c200tmp*200
real*8 eigvecmat(3,3),eigvalarr(3)

open(10,file=inputfile,status="old")

call loclabel(10,"DFT| Multiplicity",ifound)
if (ifound==1) then
    read(10,"(a)") c200tmp
    read(c200tmp(20:),*) spinmult
else
    write(*,*) "Note: Unable to find spin multiplicity information, assume to be singlet"
    spinmult=1
end if
call loclabel(10,"Electronic energy (U)",ifound)
if (ifound==1) then
    call readaftersign(10,':',E)
    E=E/2.62549961709828D3 !Use the unit conversion factor printed in CP2K output file to obtain exact energy in Hartree
else !Sometimes unable to find this energy, probably due to atom fixing setting?
    if (Eexter==0) then !Also not specify energy via settings.ini
        write(*,"(a)") " Warning: Unable to find ""Electronic energy (U)"" from the input file, electronic energy is thus set to zero. &
        You should directly specify it via ""E"" parameter in settings.ini"
        write(*,*) "Press ENTER button to continue"
        read(*,*)
    end if
    E=0
end if

call loclabel(10,"- Atoms:",ifound)
call readaftersign_int(10,':',ncenter)
allocate(a(ncenter))
call loclabel(10,"Atom  Kind  Element ",ifound)
if (ifound==0) call loclabel(10,"Atom Kind Element ",ifound) !>=2023.1
if (ifound==0) then
    write(*,"(a)") " Error: Unable to find atom information! Please make sure that PRINT_LEVEL has been set to MEDIUM"
    write(*,*) "Press ENTER button to exit"
    read(*,*)
    stop
end if
read(10,*)
do while(.true.) !CP2K 8.1 has a blank line below title line, while 9.1 doesn't have, so skipping all possible blank lines
    read(10,"(a)") c80tmp
    if (c80tmp/=" ") then
        backspace(10)
        exit
    end if
end do
do iatm=1,ncenter
    read(10,*) inouse,inouse,c80tmp,a(iatm)%index,a(iatm)%x,a(iatm)%y,a(iatm)%z,rnouse,a(iatm)%mass
end do
if (defmass==1.or.defmass==2) call setatmmass !Set mass

!Find how many frequencies in the file
rewind(10)
i1=0
i2=0
i3=0
do while(.true.)
	call loclabel(10,"VIB|Frequency (cm^-1)",ifound,0)
	if (ifound==1) then
		i1=0;i2=0;i3=0
		backspace(10)
        read(10,"(a)") c200tmp
		read(c200tmp(10:),*,iostat=ierror) i1,i2,i3
		if (ierror/=0) then
			read(c200tmp(10:),*,iostat=ierror) i1,i2
			if (ierror/=0) then
				read(c200tmp(10:),*,iostat=ierror) i1
			end if
		end if
		read(10,*);read(10,*)
		if (i1==0.or.i2==0.or.i3==0) exit
	else
		exit
	end if
end do
rewind(10)
nfreq=max(i1,i2,i3)

allocate(wavenum(nfreq))
ilackdata=nfreq
inow=1
do while(.true.)
	if (ilackdata>3) then
		iread=3
	else
		iread=ilackdata
	end if
	call loclabel(10,"VIB|Frequency (cm^-1)",ifound,0)
	read(10,"(22x)",advance="no")
	if (iread==1) read(10,*) wavenum(inow)
	if (iread==2) read(10,*) wavenum(inow),wavenum(inow+1)
	if (iread==3) read(10,*) wavenum(inow),wavenum(inow+1),wavenum(inow+2)
	if (ilackdata<=3) exit
	ilackdata=ilackdata-3
	inow=inow+3
end do

if (PGlabelinit=="?") then
    if (imode==1) then !For imode=0, usually molecule system, Shermo will still try to automatically determine point group
        PGlabelinit="C1"
        write(*,"(a)") " Note: In the case of dealing with CP2K output file with imode=1, point group is not automatically detected but simply set to C1. &
        If you need to use other point group, please manually set ""PGlabel"" in settings.ini"
    end if
end if

close(10)
end subroutine





!!-------- Load data from output file of ORCA to obtain data needed by thermochemistry quantity evaluation
subroutine loadorca
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80,c80tmp2*80
real*8 eigvecmat(3,3),eigvalarr(3)

open(10,file=inputfile,status="old")
call loclabelfinal(10,"FINAL SINGLE POINT ENERGY",ncount)
call readaftersign(10,'   ',E)
call loclabel(10,"Ideal value S",ifound)
if (ifound==0) then
    spinmult=1
else
    call readaftersign(10,'=',tmp)
    spinmult=2*tmp+1
end if

!Set atom index,x,y,z
call loadORCAgeom(10)

!Set mass
if (defmass==1.or.defmass==2) then
    call setatmmass
else if (defmass==3) then
    !call loclabel(10,"CARTESIAN COORDINATES (A.U.)") !Should not use this to locate, because when usesym is used, there will be a line "SYMMETRY-PERFECTED CARTESIAN COORDINATES (A.U.)"
    rewind(10)
    do while(.true.)
        read(10,"(a)") c80tmp
        if (c80tmp=="CARTESIAN COORDINATES (A.U.)") exit
    end do
    call skiplines(10,2)
    do iatm=1,ncenter
        read(10,*) inouse,c80tmp,c80tmp2,inouse,a(iatm)%mass
    end do
end if

!Load frequencies
call loadORCAfreq(10)
close(10)
end subroutine

!!------ Load geometry from ORCA output file. For opt task, load the final one
subroutine loadORCAgeom(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80

call loclabel(ifileid,"Number of atoms")
call readaftersign_int(ifileid,'. ',ncenter)
allocate(a(ncenter))
call loclabelfinal(ifileid,"CARTESIAN COORDINATES (ANGSTROEM)",ncount)
read(ifileid,*);read(ifileid,*)
do iatm=1,ncenter
    read(ifileid,*) c80tmp,a(iatm)%x,a(iatm)%y,a(iatm)%z
    call elename2idx(trim(c80tmp),a(iatm)%index)
end do
end subroutine

!!-------- Load harmonic frequencies from ORCA output file
subroutine loadORCAfreq(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
integer ifileid
character c80tmp*80
call loclabelfinal(ifileid,"Scaling factor for frequencies =",ncount)
if (ncount==0) then
    write(*,"(/,a)") " Error: Unable to load frequencies from this file! Please check keywords in the ORCA input file"
    write(*,*) "Press ENTER button to exit"
    read(*,*)
    stop
else
    read(ifileid,*);read(ifileid,*)
    nfreq=0
    do while(.true.)
        read(ifileid,"(a)") c80tmp
        if (c80tmp==" ") exit
        if (index(c80tmp," 0.00 cm")/=0) cycle
        nfreq=nfreq+1
    end do
    allocate(wavenum(nfreq))
    do ifreq=1,nfreq+1
        backspace(ifileid)
    end do
    !Read all frequencies
    do ifreq=1,nfreq
        read(ifileid,*) c80tmp,wavenum(ifreq)
    end do
end if
end subroutine




!!-------- Load data from output file of GAMESS-US to obtain data needed by thermochemistry quantity evaluation
subroutine loadgms
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80,strtmp*20

open(10,file=inputfile,status="old")
call loclabelfinal(10," FINAL ",ncount)
call readaftersign(10,'IS ',E)
backspace(10)
read(10,"(a)") c80tmp
read(c80tmp(8:),*) strtmp
write(*,"(a)") " Note: "//trim(strtmp)//" energy is loaded. If the theoretical method presently used is other one, &
the finally printed total U, H, G will be misleading"
call loclabel(10,"SPIN MULTIPLICITY",ifound)
call readaftersign_int(10,'=',spinmult)

!Set atom index,x,y,z
call loadgmsgeom(10)

!Set mass
if (defmass==1.or.defmass==2) then
    call setatmmass
else if (defmass==3) then
    call loclabel(10,"ATOMIC WEIGHTS (AMU)")
    call skiplines(10,2)
    do iatm=1,ncenter
        read(10,*) inouse,c80tmp,a(iatm)%mass
    end do
end if

!Load frequencies
call loadgmsfreq(10)
close(10)
end subroutine

!!------ Load geometry from GAMESS-US output file. For opt task, load the final one
subroutine loadgmsgeom(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80
call loclabel(ifileid,"TOTAL NUMBER OF ATOMS")
call readaftersign_int(ifileid,'=',ncenter)
allocate(a(ncenter))
call loclabelfinal(ifileid,"COORDINATES OF ALL ATOMS ARE (ANGS)",ncount)
if (ncount==0) then !This is not an optimization task
    call loclabel(ifileid,"ATOMIC                      COORDINATES (BOHR)")
    read(ifileid,*);read(ifileid,*)
    do iatm=1,ncenter
        read(ifileid,*) c80tmp,a(iatm)%index,a(iatm)%x,a(iatm)%y,a(iatm)%z
    end do
    a%x=a%x*b2a
    a%y=a%y*b2a
    a%z=a%z*b2a
else
    read(ifileid,*);read(ifileid,*);read(ifileid,*)
    do iatm=1,ncenter
        read(ifileid,*) c80tmp,a(iatm)%index,a(iatm)%x,a(iatm)%y,a(iatm)%z
    end do
end if
end subroutine

!!-------- Load harmonic frequencies from GAMESS-US output file
subroutine loadgmsfreq(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
integer ifileid
character c80tmp*80
call loclabel(ifileid,"VIBRATIONAL MODES ARE USED IN THERMOCHEMISTRY",ifound)
if (ifound==0) then
    write(*,"(/,a)") " Error: Unable to load frequencies from this file! Please check keywords in the GAMESS-US input file"
    write(*,*) "Press ENTER button to exit"
    read(*,*)
    stop
else
    read(ifileid,*) istart,c80tmp,iend
    nfreq=iend-istart+1
    allocate(wavenum(nfreq))
    call loclabel(ifileid,"MODE FREQ(CM**-1)",ifound)
    read(ifileid,*)
    ifreq=0
    do idx=1,iend
        read(ifileid,*) inouse,tmpval
        if (idx<istart) cycle
        ifreq=ifreq+1
        wavenum(ifreq)=tmpval
    end do
end if
end subroutine



!!-------- Load data from output file of NWChem to obtain data needed by thermochemistry quantity evaluation
subroutine loadnw
use defvar
use util
implicit real*8 (a-h,o-z)
character strtmp*20

open(10,file=inputfile,status="old")
call loclabelfinal(10,"Total DFT energy =",ncount)
if (ncount>0) then
    strtmp="DFT"
    call readaftersign(10,'=',E)
else !HF or post-HF
    call loclabelfinal(10,"Total SCF energy =",ncount)
    if (ncount>0) then
        call readaftersign(10,'=',E)
        write(*,"(a)") " Note: SCF energy is loaded. If the theoretical method presently used is other one, &
        the finally printed total U, H, G will be misleading"
    else
        write(*,*) "Warning: Unable to load electronic energy, thus it is set to zero"
    end if
end if

call loclabel(10,"Spin multiplicity:",ifound)
call readaftersign_int(10,':',spinmult)

!Set atom index,x,y,z
call loadnwgeom(10)

!Set mass
if (defmass==1.or.defmass==2) then
    call setatmmass
else if (defmass==3) then
    call loclabel(10,"- Atom information -")
    call skiplines(10,3)
    do iatm=1,ncenter
        read(10,*) strtmp,inouse,r1,r2,r3,a(iatm)%mass
    end do
end if

!Load frequencies
call loadnwfreq(10)
close(10)
end subroutine


!!------ Load geometry from NWChem output file. For opt task, load the final one
subroutine loadnwgeom(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
character strtmp*20

call loclabel(ifileid,"No. of atoms")
call readaftersign_int(ifileid,':',ncenter)
allocate(a(ncenter))
call loclabel(ifileid,"- Atom information -")
call skiplines(ifileid,3)
do iatm=1,ncenter
    read(ifileid,*) strtmp,inouse,a(iatm)%x,a(iatm)%y,a(iatm)%z
    call elename2idx(strtmp,a(iatm)%index)
end do
a%x=a%x*b2a
a%y=a%y*b2a
a%z=a%z*b2a
end subroutine


!!-------- Load harmonic frequencies from NWChem output file
subroutine loadnwfreq(ifileid)
use defvar
use util
implicit real*8 (a-h,o-z)
integer ifileid
character c80tmp*80

call loclabel(ifileid,"Projected Derivative Dipole Moments")
call skiplines(ifileid,3)
nzero=0
nfreq=0
do while(.true.)
    read(ifileid,*,iostat=ierror) inouse,tmp
    if (ierror/=0) then
        exit
    else
        if (tmp==0) then
            nzero=nzero+1
        else
            nfreq=nfreq+1
        end if
    end if
end do
allocate(wavenum(nfreq))
call loclabel(ifileid,"Projected Derivative Dipole Moments")
call skiplines(ifileid,3)
ifreq=0
do itmp=1,nfreq+nzero
    read(ifileid,*) inouse,tmp
    if (tmp/=0) then
        ifreq=ifreq+1
        wavenum(ifreq)=tmp
    end if
end do
end subroutine



!!-------- Load data from g98 file produced by xtb to obtain data needed by thermochemistry quantity evaluation
subroutine loadxtb
use defvar
use util
implicit real*8 (a-h,o-z)
character c80tmp*80,c200tmp*200
real*8 eigvecmat(3,3),eigvalarr(3)

open(10,file=inputfile,status="old")

call loclabel(10,"alpha electrons",ifound)
read(10,*) naelec,c80tmp,c80tmp,nbelec
spinmult=naelec-nbelec+1

if (Eexter==0) then
    write(*,"(/,a)") " NOTE: This file does not contain electronic energy, and you also did not explicitly set ""E"" in settings.ini. &
    If you want to let Shermo load electronic energy from a xtb output file, &
    input its path now, e.g. D:\ltwd\xtb.out. If you press ENTER button directly, then electronic energy will simply be set to 0"
    do while(.true.)
	    read(*,"(a)") c200tmp
        if (c200tmp==" ") then
            exit
        else
	        inquire(file=c200tmp,exist=alive)
	        if (alive) then
                open(11,file=c200tmp,status="old")
                call loclabelfinal(11,"total energy",ncount)
                if (ncount==0) then
                    write(*,*) "Error: Unable to locate ""total energy""! Input again"
                    close(11)
                    cycle
                else
                    read(11,"(a)") c200tmp
                    read(c200tmp(37:),*) E
                    write(*,"(' Loaded electronic energy:',f16.10,' Hartree')") E
                    close(11)
                    exit
                end if
            else
                write(*,*) "Cannot find the file, input again!"
            end if
        end if
    end do
end if

call loclabel(10,"Coordinates (Angstroms)",ifound)
call skiplines(10,3)
ncenter=0
do while(.true.)
    read(10,"(a)") c80tmp
    if (index(c80tmp,'--')/=0) exit
    ncenter=ncenter+1
end do
allocate(a(ncenter))
call loclabel(10,"Coordinates (Angstroms)",ifound)
call skiplines(10,3)
do iatm=1,ncenter
    read(10,*) inouse,a(iatm)%index,inouse,a(iatm)%x,a(iatm)%y,a(iatm)%z
end do

if (defmass==3) then
    write(*,"(a)") " Note: defmass=3 is meaningless for present case because input file does not record atomic mass. Now set atomic masses to element mass (defmass=1)"
    defmass=1
end if
call setatmmass

call loadGaufreq(10)

close(10)
end subroutine