!!----------- Load and calculate an ensemble of input files
subroutine ensemble
use defvar
use util
implicit real*8 (a-h,o-z)
character c200tmp*200
character*200,allocatable :: filelist(:)
real*8,allocatable :: Slist(:),Ulist(:),Hlist(:),Glist(:),CVlist(:),wei(:),Elist(:)

open(10,file=inputfile,status="old")
nfile=0
do while(.true.)
    read(10,"(a)",iostat=ierror) c200tmp
    if (c200tmp==" ".or.ierror/=0) exit
    nfile=nfile+1
end do
allocate(filelist(nfile))
allocate(Slist(nfile),Ulist(nfile),Hlist(nfile),Glist(nfile),CVlist(nfile),wei(nfile),Elist(nfile))
rewind(10)
do i=1,nfile
    read(10,"(a)") c200tmp
    itmp=index(c200tmp,';')
    if (itmp==0) then
        filelist(i)=c200tmp
        Elist(i)=0
    else
        read(c200tmp(itmp+1:),*,iostat=ierror) Elist(i)
        filelist(i)=c200tmp(:itmp-1)
    end if
end do
close(10)

!Cycle each file in the ensemble
do ifile=1,nfile
    inputfile=filelist(ifile)
    inquire(file=inputfile,exist=alive)
    if (.not.alive) then
        write(*,"(a)") " Error: Unable to find "//trim(inputfile)
        write(*,*) "Press ENTER button to exit program"
        read(*,*)
        stop
    end if
    write(*,"(a,i5,a,i5,a)") " Processing "//trim(inputfile)//"... (",ifile,"  of",nfile," )"
    if (index(inputfile,'.shm')/=0) then !Load data from .shm file
        call loadshm
    else !Determine which program outputs this file, and then properly load data
        call deterprog(iprog)
        if (iprog==1) then
            call loadgau
        else if (iprog==2) then
            call loadorca
        else if (iprog==3) then
            call loadgms
        else if (iprog==4) then
            call loadnw
        else if (iprog==5) then
            call loadCP2K
        else if (iprog==6) then
            call loadxtb
        end if
        call modmass
        nelevel=1
        allocate(elevel(nelevel),edegen(nelevel))
        elevel=0
        edegen=spinmult
        if (outshm==1) call outshmfile
    end if
    if (Elist(ifile)/=0) then !Electronic energy was directly loaded from list file
        E=Elist(ifile)
    else
        Elist(ifile)=E
    end if

    totmass=sum(a(:)%mass)
    call calcinertia
    if (any(inert<0.001D0)) then
        ilinear=1
    else
        ilinear=0
    end if
    call detectPG(0)
    allocate(freq(nfreq))
    freq=wavenum*wave2freq
    
    call calcthermo(thermU,thermH,thermG,Slist(ifile),CVlist(ifile),CP_tot,QV,Qbot)
    Ulist(ifile)=thermU/au2kJ_mol+E
    Hlist(ifile)=thermH/au2kJ_mol+E
    Glist(ifile)=thermG/au2kJ_mol+E
    deallocate(a,elevel,edegen,freq,wavenum)
end do

write(*,*)
qall=0
Gmin=minval(Glist)
write(*,*) "#System       U               H               G             S          CV"
write(*,*) "             a.u.            a.u.            a.u.        J/mol/K     J/mol/K"
do ifile=1,nfile
    dG=(Glist(ifile)-Gmin)*au2kJ_mol*1000 !Relative free energy in J/mol
    qall=qall+exp(-dG/R/T)
    write(*,"(i5,f16.6,f16.6,f16.6,f12.3,f12.3)") ifile,Ulist(ifile),Hlist(ifile),Glist(ifile),Slist(ifile),CVlist(ifile)
end do

write(*,*)
do ifile=1,nfile
    dG=(Glist(ifile)-Gmin)*au2kJ_mol*1000
    wei(ifile)=exp(-dG/R/T)/qall
    write(*,"(' System',i5,'     Relative G=',f9.3,' kJ/mol     Boltzmann weight=',f8.3,' %')") ifile,(Glist(ifile)-Gmin)*au2kJ_mol,wei(ifile)*100
end do

weiE=sum(wei*Elist)
weiU=sum(wei*Ulist)
weiH=sum(wei*Hlist)
confS=0
do ifile=1,nfile
    confS=confS-R*wei(ifile)*log(wei(ifile))
end do
weiS=sum(wei*Slist)+confS
weiG=weiH-T*weiS/1000/au2kJ_mol
weiCV=sum(wei*CVlist)
write(*,*)
write(*,*) "Conformation weighted data:"
write(*,"(' Electronic energy: ',f16.6,' a.u.')") weiE
write(*,"(' U: ',f16.6,' a.u.')") weiU
write(*,"(' H: ',f16.6,' a.u.')") weiH
write(*,"(' G: ',f16.6,' a.u.')") weiG
write(*,"(' S: ',f13.3,' J/mol/K    Conformation entropy:',f10.3,' J/mol/K')") weiS,confS
write(*,"(' CV:',f13.3,' J/mol/K')") weiCV
write(*,"(' CP:',f13.3,' J/mol/K')") weiCV+R
!Note that it is inappropriate to present weighted q as sum of individual systems, since they employed different energy zero point (i.e., w.r.t. each electronic energy)

if (concstr/="0") then
    call getGconc(concnow,concspec,Gconc)
    write(*,*)
    write(*,"(' Present concentration (estimated by ideal gas model):',f10.6,' mol/L')") concnow
    write(*,"(' Concentration specified by ""conc"" parameter:',f12.6,' mol/L')") concspec
    write(*,"(' delta-G of conc. change:',f11.3,' kJ/mol',f11.3,' kcal/mol',f11.6,' a.u.')") Gconc,Gconc/cal2J,Gconc/au2kJ_mol
    write(*,"(' Weighted Gibbs free energy at specified concentration:', f19.7,' a.u.')") weiG+Gconc/au2kJ_mol
end if
end subroutine
    
    
    
!!----------- Calculate moment of inertia matrix and its eigenvalues in a.u.
subroutine calcinertia
use defvar
use util
implicit real*8 (a-h,o-z)
real*8 eigvecmat(3,3)

cenmassx=sum(a(:)%x*a(:)%mass)/totmass
cenmassy=sum(a(:)%y*a(:)%mass)/totmass
cenmassz=sum(a(:)%z*a(:)%mass)/totmass
inertmat(1,1)=sum( a(:)%mass*( (a(:)%y-cenmassy)**2+(a(:)%z-cenmassz)**2) )
inertmat(2,2)=sum( a(:)%mass*( (a(:)%x-cenmassx)**2+(a(:)%z-cenmassz)**2) )
inertmat(3,3)=sum( a(:)%mass*( (a(:)%x-cenmassx)**2+(a(:)%y-cenmassy)**2) )
inertmat(1,2)=-sum( a(:)%mass*(a(:)%x-cenmassx)*(a(:)%y-cenmassy) )
inertmat(2,1)=inertmat(1,2)
inertmat(1,3)=-sum( a(:)%mass*(a(:)%x-cenmassx)*(a(:)%z-cenmassz) )
inertmat(3,1)=inertmat(1,3)
inertmat(2,3)=-sum( a(:)%mass*(a(:)%y-cenmassy)*(a(:)%z-cenmassz) )
inertmat(3,2)=inertmat(2,3)
inertmat=inertmat/b2a/b2a !The inertmat is orginally amu*Ang^2, now convert to amu*Bohr^2
call diagmat(inertmat,eigvecmat,inert,300,1D-12)
!call showmatgau(eigvecmat,"Principal axes (each column vector)")
end subroutine



!!------------- Directly calculate and return thermodynamic data
!Identical to showthermo, but do not print any information on screen
subroutine calcthermo(thermU,thermH,thermG,S_tot,CV_tot,CP_tot,QV,Qbot)
use defvar
implicit real*8 (a-h,o-z)
real*8 inertkg(3),corrU,corrH,corrG,S,CV,CP,QV,Qbot

!!! Calculating translation contribution
if (imode==0) then
    P_Pa=P*atm2Pa
    q_trans=(2*pi*(totmass*amu2kg)*kb*T/h**2)**(3D0/2D0)*R*T/P_Pa
    CV_trans=3D0/2D0*R
    CP_trans=5D0/2D0*R
    U_trans=3D0/2D0*R*T/1000
    H_trans=5D0/2D0*R*T/1000
    S_trans=R*(log(q_trans/NA)+5D0/2D0)
else if (imode==1) then
    q_trans=1
    CV_trans=0
    CP_trans=0
    U_trans=0
    H_trans=0
    S_trans=0
end if

!!! Calculating rotation contribution
if (imode==0) then
    if (sum(inert)<1E-10) then !Single atom
        q_rot=1
        U_rot=0
        CV_rot=0
        S_rot=0
    else
        inertkg(:)=inert(:)*amu2kg*(b2a*1D-10)**2 !Convert moment of inertia from a.u.(amu*Bohr^2) to kg*m^2
        if (ilinear==1) then !Linear molecule
	        q_rot=8*pi**2*inertkg(3)*kb*T/rotsym/h**2
	        U_rot=R*T/1000
	        CV_rot=R
	        S_rot=R*(log(q_rot)+1)
        else !Non-linear molecule
	        q_rot=8*pi**2/rotsym/h**3*(2*pi*kb*T)**(3D0/2D0)*dsqrt(inertkg(1)*inertkg(2)*inertkg(3))
	        U_rot=3D0*R*T/2D0/1000
	        CV_rot=3D0*R/2D0
	        S_rot=R*(log(q_rot)+3D0/2D0)
        end if
    end if
else if (imode==1) then
    q_rot=1
    U_rot=0
    CV_rot=0
    S_rot=0
end if

!!! Calculating vibration contribution
qvib_v0=1
qvib_bot=1
do i=1,nfreq
	if (freq(i)<=0) cycle
    freqtmp=freq(i)
    if (ilowfreq==1.and.wavenum(i)<ravib) freqtmp=ravib*wave2freq
	tmpv0=1/( 1-exp( -h*freqtmp/(kb*T) ) )
	tmpbot=exp(-h*freqtmp/(kb*2*T)) / (1-exp( -h*freqtmp/(kb*T) ))
	qvib_v0=qvib_v0*tmpv0
	qvib_bot=qvib_bot*tmpbot
end do
U_vib_heat=0
CV_vib=0
S_vib=0
ZPE=0
do i=1,nfreq
    call getvibcontri(i,tmpZPE,tmpheat,tmpCV,tmpS)
    ZPE=ZPE+tmpZPE
	U_vib_heat=U_vib_heat+tmpheat
	CV_vib=CV_vib+tmpCV
	S_vib=S_vib+tmpS
end do
U_vib=U_vib_heat+ZPE

!!! Calculating electron contribution
call elecontri(q_ele,U_ele,CV_ele,S_ele)

!Total values
CV_tot=CV_trans+CV_rot+CV_vib+CV_ele
CP_tot=CP_trans+CV_rot+CV_vib+CV_ele
S_tot=S_trans+S_rot+S_vib+S_ele
thermU=U_trans+U_rot+U_vib+U_ele
thermH=H_trans+U_rot+U_vib+U_ele
if (T==0) then
    thermG=thermH
else
    thermG=thermH-T*S_tot/1000
end if
QV=q_trans*q_rot*qvib_v0*q_ele
Qbot=q_trans*q_rot*qvib_BOT*q_ele
end subroutine



!!-------------- Calculate and print thermodynamic quantities
subroutine showthermo
use defvar
implicit real*8 (a-h,o-z)
real*8 inertkg(3)

!!! Calculating translation contribution
if (imode==0) then
    write(*,"(/,a)") " Note: Only for translation, U is different to H, and CV is different to CP"
    write(*,*)
    write(*,*) "                         ======= Translation ======="
    P_Pa=P*atm2Pa
    q_trans=(2*pi*(totmass*amu2kg)*kb*T/h**2)**(3D0/2D0)*R*T/P_Pa
    CV_trans=3D0/2D0*R
    CP_trans=5D0/2D0*R
    U_trans=3D0/2D0*R*T/1000
    H_trans=5D0/2D0*R*T/1000
    S_trans=R*(log(q_trans/NA)+5D0/2D0)
    write(*,"(' Translational q: ',1PE16.6E3,'     q/NA: ',1PE16.6E3)") q_trans,q_trans/NA
    write(*,"(' Translational U: ',f10.3,' kJ/mol ',f10.3,' kcal/mol')") U_trans,U_trans/cal2J
    write(*,"(' Translational H: ',f10.3,' kJ/mol ',f10.3,' kcal/mol')") H_trans,H_trans/cal2J
    write(*,"(' Translational S: ',f10.3,' J/mol/K',f10.3,' cal/mol/K  -TS:',f8.2,' kcal/mol')") S_trans,S_trans/cal2J,-S_trans/cal2J/1000*T
    write(*,"(' Translational CV:',f10.3,' J/mol/K',f10.3,' cal/mol/K')") CV_trans,CV_trans/cal2J
    write(*,"(' Translational CP:',f10.3,' J/mol/K',f10.3,' cal/mol/K')") CP_trans,CP_trans/cal2J
else if (imode==1) then
    write(*,*)
    write(*,*) "Translation contribution is ignored since imode=1"
    q_trans=1D0
    CV_trans=0
    CP_trans=0
    U_trans=0
    H_trans=0
    S_trans=0
end if

!!! Calculating rotation contribution
if (imode==0) then
    write(*,*)
    write(*,*) "                         ========= Rotation ========"
    if (sum(inert)<1E-10) then !Single atom
        q_rot=1
        U_rot=0
        CV_rot=0
        S_rot=0
    else
        inertkg(:)=inert(:)*amu2kg*(b2a*1D-10)**2 !Convert moment of inertia from a.u.(amu*Bohr^2) to kg*m^2
        if (ilinear==1) then !Linear molecule
	        q_rot=8*pi**2*inertkg(3)*kb*T/rotsym/h**2
	        U_rot=R*T/1000
	        CV_rot=R
	        S_rot=R*(log(q_rot)+1)
        else !Non-linear molecule
	        q_rot=8*pi**2/rotsym/h**3*(2*pi*kb*T)**(3D0/2D0)*dsqrt(inertkg(1)*inertkg(2)*inertkg(3))
	        U_rot=3D0*R*T/2D0/1000
	        CV_rot=3D0*R/2D0
	        S_rot=R*(log(q_rot)+3D0/2D0)
        end if
    end if
    write(*,"(' Rotational q: ',1PE16.6E3)") q_rot
    write(*,"(' Rotational U: ',f10.3,' kJ/mol ',f10.3,' kcal/mol    =H')") U_rot,U_rot/cal2J
    write(*,"(' Rotational S: ',f10.3,' J/mol/K',f10.3,' cal/mol/K   -TS:',f8.3,' kcal/mol')") S_rot,S_rot/cal2J,-S_rot/cal2J/1000*T
    write(*,"(' Rotational CV:',f10.3,' J/mol/K',f10.3,' cal/mol/K   =CP')") CV_rot,CV_rot/cal2J
else if (imode==1) then
    write(*,*)
    write(*,*) "Rotation contribution is ignored since imode=1"
    q_rot=1
    U_rot=0
    CV_rot=0
    S_rot=0
end if

!!! Calculating vibration contribution
if (prtvib==-1) then
    open(10,file="vibcontri.txt",status="replace")
    ivibout=10
else if (prtvib==1) then
    ivibout=6
end if
write(*,*)
write(*,*) "                         ======== Vibration ========"
if (ilowfreq==1) then
    nlow=count(abs(wavenum)<ravib)
    if (nlow>0) then
        write(*,"(a,i4,a,f6.1,a,/)") " Note: ",nlow," low frequencies are raised to",ravib," cm^-1 during calculating S, U(T)-U(0), CV and q"
    end if
else if (ilowfreq==2) then
    write(*,"(a,/)") " Note: Interpolation between harmonic oscillator model and free rotor model is used to evaluate S, other terms are identical to harmonic oscillator model"
else if (ilowfreq==3) then
    write(*,"(a,/)") " Note: Interpolation between harmonic oscillator model and free rotor model is used to evaluate S and U(T). &
    In this case ZPE and U(T)-U(0) cannot be separated and thus not shown. Other terms are identical to harmonic oscillator model"
end if
!Calculate partition function
if (abs(prtvib)==1) then
    if (sclZPE/=1.or.sclheat/=1.or.sclS/=1.or.sclCV/=1) then
        write(ivibout,*) "Note: The wavenumbers shown below are unscaled ones"
        write(ivibout,*)
    end if
	write(ivibout,*) " Mode  Wavenumber    Freq        Vib. Temp.    q(V=0)        q(bot)"
	write(ivibout,*) "         cm^-1        GHz            K"
end if
qvib_v0=1
qvib_bot=1
do i=1,nfreq
	if (freq(i)<=0) cycle
    freqtmp=freq(i)
    if (ilowfreq==1.and.wavenum(i)<ravib) freqtmp=ravib*wave2freq
	tmpv0=1/( 1-exp( -h*freqtmp/(kb*T) ) )
	tmpbot=exp(-h*freqtmp/(kb*2*T)) / (1-exp( -h*freqtmp/(kb*T) ))
	qvib_v0=qvib_v0*tmpv0
	qvib_bot=qvib_bot*tmpbot
	if (abs(prtvib)==1) write(ivibout,"(i5,f11.2,E14.5,f12.2,2f14.8)") i,wavenum(i),freq(i)/1D9,freq(i)*h/kb,tmpv0,tmpbot
end do
!Calculate contribution to thermochemistry quantities
if (abs(prtvib)==1) then
	write(ivibout,*)
	write(ivibout,*) " Mode  Wavenumber     ZPE      U(T)-U(0)    U(T)      CV(T)       S(T)"
	write(ivibout,*) "         cm^-1      kcal/mol   kcal/mol   kcal/mol  cal/mol/K  cal/mol/K"
end if
U_vib_heat=0
CV_vib=0
S_vib=0
ZPE=0
do i=1,nfreq
    call getvibcontri(i,tmpZPE,tmpheat,tmpCV,tmpS)
    ZPE=ZPE+tmpZPE
	U_vib_heat=U_vib_heat+tmpheat
	CV_vib=CV_vib+tmpCV
	S_vib=S_vib+tmpS
	if (abs(prtvib)==1) write(ivibout,"(i5,f11.2,1x,5f11.5)") i,wavenum(i),tmpZPE/cal2J,tmpheat/cal2J,(tmpheat+tmpZPE)/cal2J,tmpCV/cal2J,tmpS/cal2J
end do
U_vib=U_vib_heat+ZPE
if (prtvib==1) then
    write(*,*)
else if (prtvib==-1) then
    close(10)
    write(*,"(a,/)") " Contributions to thermochemistry quantities from every frequency mode have been exported to vibcontri.txt in current folder"
end if
write(*,"(' Vibrational q(V=0): ',1PE16.6E3)") qvib_v0
write(*,"(' Vibrational q(bot): ',1PE16.6E3)") qvib_bot
if (ilowfreq/=3) write(*,"(' Vibrational U(T)-U(0):',f10.3,' kJ/mol',f10.3,' kcal/mol   =H(T)-H(0)')") U_vib_heat,U_vib_heat/cal2J
write(*,"(' Vibrational U: ',f10.3,' kJ/mol ',f10.3,' kcal/mol    =H')") U_vib,U_vib/cal2J
write(*,"(' Vibrational S: ',f10.3,' J/mol/K',f10.3,' cal/mol/K   -TS:',f8.3,' kcal/mol')") S_vib,S_vib/cal2J,-S_vib/cal2J/1000*T
write(*,"(' Vibrational CV:',f10.3,' J/mol/K',f10.3,' cal/mol/K   =CP')") CV_vib,CV_vib/cal2J
if (ilowfreq/=3) write(*,"(' Zero-point energy (ZPE):',f10.2,' kJ/mol,',f10.2,' kcal/mol',f12.6,' a.u.')") ZPE,ZPE/cal2J,ZPE/au2KJ_mol

!!! Calculating electron contribution
write(*,*)
write(*,*) "                    ======== Electron excitation ========"
call elecontri(q_ele,U_ele,CV_ele,S_ele)
write(*,"(' Electronic q: ',1PE16.6E3)") q_ele
write(*,"(' Electronic U: ',f10.3,' kJ/mol ',f10.3,' kcal/mol    =H')") U_ele,U_ele/cal2J
write(*,"(' Electronic S: ',f10.3,' J/mol/K',f10.3,' cal/mol/K   -TS:',f8.3,' kcal/mol')") S_ele,S_ele/cal2J,-S_ele/cal2J/1000*T
write(*,"(' Electronic CV:',f10.3,' J/mol/K',f10.3,' cal/mol/K   =CP')") CV_ele,CV_ele/cal2J

!!! Outputting total result
write(*,*)
write(*,*)
write(*,*) "                          ==========================="
write(*,*) "                          ========== Total =========="
write(*,*) "                          ==========================="
write(*,"(' Total q(V=0):    ',1PE16.6E3)") q_trans*q_rot*qvib_v0*q_ele
write(*,"(' Total q(bot):    ',1PE16.6E3)") q_trans*q_rot*qvib_BOT*q_ele
write(*,"(' Total q(V=0)/NA: ',1PE16.6E3)") q_trans*q_rot*qvib_v0*q_ele/NA
write(*,"(' Total q(bot)/NA: ',1PE16.6E3)") q_trans*q_rot*qvib_BOT*q_ele/NA
CV_tot=CV_trans+CV_rot+CV_vib+CV_ele
CP_tot=CP_trans+CV_rot+CV_vib+CV_ele
S_tot=S_trans+S_rot+S_vib+S_ele
write(*,"(' Total CV:',f12.3,' J/mol/K',f12.3,' cal/mol/K')") CV_tot,CV_tot/cal2J
write(*,"(' Total CP:',f12.3,' J/mol/K',f12.3,' cal/mol/K')") CP_tot,CP_tot/cal2J
write(*,"(' Total S: ',f12.3,' J/mol/K',f12.3,' cal/mol/K    -TS:',f10.3,' kcal/mol')") S_tot,S_tot/cal2J,-S_tot/cal2J/1000*T
if (T==0) then
    thermU=ZPE
    thermH=ZPE
    thermG=ZPE
else
    thermU=U_trans+U_rot+U_vib+U_ele
    thermH=H_trans+U_rot+U_vib+U_ele
    thermG=thermH-T*S_tot/1000
end if
if (ilowfreq/=3) write(*,"(' Zero point energy (ZPE):',f11.3,' kJ/mol',f11.3,' kcal/mol',f11.6,' a.u.')") ZPE,ZPE/cal2J,ZPE/au2kJ_mol
write(*,"(' Thermal correction to U:',f11.3,' kJ/mol',f11.3,' kcal/mol',f11.6,' a.u.')") thermU,thermU/cal2J,thermU/au2kJ_mol
write(*,"(' Thermal correction to H:',f11.3,' kJ/mol',f11.3,' kcal/mol',f11.6,' a.u.')") thermH,thermH/cal2J,thermH/au2kJ_mol
write(*,"(' Thermal correction to G:',f11.3,' kJ/mol',f11.3,' kcal/mol',f11.6,' a.u.')") thermG,thermG/cal2J,thermG/au2kJ_mol
U0=E+ZPE/au2KJ_mol
U_final=E+thermU/au2kJ_mol
H_final=E+thermH/au2kJ_mol
G_final=E+thermG/au2kJ_mol
write(*,"(' Electronic energy:',f19.7,' a.u.')") E
if (ilowfreq/=3) write(*,"(' Sum of electronic energy and ZPE, namely U/H/G at 0 K:',f19.7,' a.u.')") U0
write(*,"(' Sum of electronic energy and thermal correction to U: ', f19.7,' a.u.')") U_final
write(*,"(' Sum of electronic energy and thermal correction to H: ', f19.7,' a.u.')") H_final
write(*,"(' Sum of electronic energy and thermal correction to G: ', f19.7,' a.u.')") G_final

if (concstr/="0") then
    call getGconc(concnow,concspec,Gconc)
    write(*,*)
    write(*,"(' Present concentration (estimated by ideal gas model):',f10.6,' mol/L')") concnow
    write(*,"(' Concentration specified by ""conc"" parameter:',f12.6,' mol/L')") concspec
    write(*,"(' delta-G of conc. change:',f11.3,' kJ/mol',f11.3,' kcal/mol',f11.6,' a.u.')") Gconc,Gconc/cal2J,Gconc/au2kJ_mol
    write(*,"(' Gibbs free energy at specified concentration:', f19.7,' a.u.')") G_final+Gconc/au2kJ_mol
end if
end subroutine



!!--------- Calculate variation of G of concentration change from current one to specified one
!concnow: Returned current concentration (mol/L)
!concspec: Returned specified concentration (mol/L)
!Gconc: Returned delta-G_conc (kJ/mol)
subroutine getGconc(concnow,concspec,Gconc)
use defvar
implicit real*8 (a-h,o-z)
real*8 concnow,concspec,Gconc
character testchar
concnow=P*atm2Pa/(R*T)/1000 !mol/L
do ichar=len_trim(concstr),1,-1
    testchar=concstr(ichar:ichar)
    if (iachar(testchar)>=48.and.iachar(testchar)<=57) exit !Find the last digit
end do
if (index(concstr,'atm')/=0) then !Calculate concentration using ideal gas formula
    read(concstr(1:ichar),*) tmppres
    concspec=tmppres*atm2Pa/(R*T)/1000
else !Directly load concentration in M
    read(concstr(1:ichar),*) concspec
end if
Gconc=R*T*log(concspec/concnow)/1000 !kJ/mol
end subroutine



!!--------- Calculate contribution of electron levels
subroutine elecontri(tmpq,tmpheat,tmpCV,tmpS)
use defvar
implicit real*8 (a-h,o-z)
real*8 tmpq,tmpheat,tmpCV,tmpS
tmpq=0
t1=0
t2=0
do ie=1,nelevel
    exc=elevel(ie)/au2eV*au2J
    ekt=exc/(kb*T)
    qi=edegen(ie)*exp(-ekt)
    tmpq=tmpq+qi
    t1=t1+ekt*qi
    t2=t2+ekt*ekt*qi
end do
tmpS=R*log(tmpq)+R*t1/tmpq
if (T==0) then
    tmpheat=0
else
    tmpheat=R*T*t1/tmpq/1000
end if
tmpCV=R*t2/tmpq-R*(t1/tmpq)**2
end subroutine



!!--------- Get contribution of vibration mode i to ZPE, U(T)-U(0), CV, S. In kJ/mol or kJ/mol/K
!Imaginary frequecies are ignored
subroutine getvibcontri(i,tmpZPE,tmpheat,tmpCV,tmpS)
use defvar
implicit real*8 (a-h,o-z)
integer i
real*8 tmpZPE,tmpheat,tmpCV,tmpS,miu,miup

tmpZPE=0;tmpheat=0;tmpCV=0;tmpS=0
if (freq(i)<=0) return
if (ilowfreq==1) then !Produce truncated frequencies and intermediates used in Truhlar's QRRHO
    freqtrunc=ravib*wave2freq
	prefac_trunc=h*freqtrunc/(kb*T)
	term_trunc=exp(-h*freqtrunc/(kb*T))
end if

!ZPE
tmpZPE=wavenum(i)*sclZPE/2/au2cm_1*au2kJ_mol

!Heating contribution to U, namely U(T)-U(0)
!Truhlar's mode: Use RRHO based on truncated frequencies
!RRHO and Grimme's mode: Use standard RRHO treatment
!Minenkov: Interpolation between RRHO and free rotor
if (T>0) then
    prefac=h*freq(i)*sclheat/(kb*T)
    term=exp(-h*freq(i)*sclheat/(kb*T))
    if (ilowfreq==1.and.wavenum(i)<ravib) then
        prefac=prefac_trunc
        term=term_trunc
    end if
    if (ilowfreq==3) then !Interpolation for vibration contribution to internal energy. ZPE cannot be separated in this case because free-rotor doesn't have ZPE, so set ZPE to 0
        UvRRHO=tmpZPE+R*T*prefac*term/(1-term)/1000 !Harmonic-oscillator result
        tmpZPE=0
        Ufree=R*T/2/1000 !Free-rotor result
        tmpval=1+(intpvib/wavenum(i))**4  !Denominator part of Eq. 6 of DOI: 10.1002/jcc.27129
        tmpheat=(1/tmpval)*UvRRHO + (1-1/tmpval)*Ufree  !Interpolation. See Eq. 6 of DOI: 10.1002/jcc.27129
    else !RRHO
        tmpheat=R*T*prefac*term/(1-term)/1000
    end if
end if

!CV
prefac=h*freq(i)*sclCV/(kb*T)
term=exp(-h*freq(i)*sclCV/(kb*T))
if (ilowfreq==1.and.wavenum(i)<ravib) then
    prefac=prefac_trunc
    term=term_trunc
end if
tmpCV=R*prefac**2 * term/(1-term)**2

!S
prefac=h*freq(i)*sclS/(kb*T)
term=exp(-h*freq(i)*sclS/(kb*T))
if (ilowfreq==1.and.wavenum(i)<ravib) then
    prefac=prefac_trunc
    term=term_trunc
end if
tmpS=R*(prefac*term/(1-term)-log(1-term)) !RRHO
if (ilowfreq==2.or.ilowfreq==3) then !Grimme's entropy interpolation
    miu=h/(8*pi**2*freq(i))
    Bav=1D-44 !kg*m^2
    miup=miu*Bav/(miu+Bav)
    Sfree=R*( 0.5D0+log(dsqrt(8*pi**3*miup*kb*T/h**2)) )
    wei=1/(1+(intpvib/wavenum(i))**4)
    !write(*,"(3f20.10)") wei,tmpS,Sfree
    tmpS=wei*tmpS+(1-wei)*Sfree
end if
end subroutine