module blockhrr
implicit none
contains
    subroutine blockhrr_0_0(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 1; Optimized integrals: 1
        ! (0,0,0|0,0,0): 1
        theta(2) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((0,0,0)|(0,0,0))
    end subroutine
    subroutine blockhrr_1_0(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 3; Optimized integrals: 3
        ! (1,0,0|0,0,0): 1
        theta(6) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((1,0,0)|(0,0,0))
        ! (0,1,0|0,0,0): 1
        theta(7) = dot_product(vrrbuffer(:,2), D(:,2)) ! ((0,1,0)|(0,0,0))
        ! (0,0,1|0,0,0): 1
        theta(8) = dot_product(vrrbuffer(:,3), D(:,3)) ! ((0,0,1)|(0,0,0))
    end subroutine
    subroutine blockhrr_1_1(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 18; Optimized integrals: 18
        ! (1,0,0|1,0,0): 3
        theta(16) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((1,0,0)|(0,0,0))
        theta(19) = dot_product(vrrbuffer(:,4), D(:,1)) ! ((2,0,0)|(0,0,0))
        theta(25) = theta(19)+theta(16)*AB(1) ! ((1,0,0)|(1,0,0)) = ((2,0,0)|(0,0,0))+((1,0,0)|(0,0,0))*AB(1)
        ! (1,0,0|0,1,0): 3
        theta(16) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((1,0,0)|(0,0,0))
        theta(20) = dot_product(vrrbuffer(:,5), D(:,2)) ! ((1,1,0)|(0,0,0))
        theta(26) = theta(20)+theta(16)*AB(2) ! ((1,0,0)|(0,1,0)) = ((1,1,0)|(0,0,0))+((1,0,0)|(0,0,0))*AB(2)
        ! (1,0,0|0,0,1): 3
        theta(16) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((1,0,0)|(0,0,0))
        theta(21) = dot_product(vrrbuffer(:,6), D(:,3)) ! ((1,0,1)|(0,0,0))
        theta(27) = theta(21)+theta(16)*AB(3) ! ((1,0,0)|(0,0,1)) = ((1,0,1)|(0,0,0))+((1,0,0)|(0,0,0))*AB(3)
        ! (0,1,0|1,0,0): 3
        theta(17) = dot_product(vrrbuffer(:,2), D(:,4)) ! ((0,1,0)|(0,0,0))
        theta(20) = dot_product(vrrbuffer(:,5), D(:,4)) ! ((1,1,0)|(0,0,0))
        theta(28) = theta(20)+theta(17)*AB(1) ! ((0,1,0)|(1,0,0)) = ((1,1,0)|(0,0,0))+((0,1,0)|(0,0,0))*AB(1)
        ! (0,1,0|0,1,0): 3
        theta(17) = dot_product(vrrbuffer(:,2), D(:,5)) ! ((0,1,0)|(0,0,0))
        theta(22) = dot_product(vrrbuffer(:,7), D(:,5)) ! ((0,2,0)|(0,0,0))
        theta(29) = theta(22)+theta(17)*AB(2) ! ((0,1,0)|(0,1,0)) = ((0,2,0)|(0,0,0))+((0,1,0)|(0,0,0))*AB(2)
        ! (0,1,0|0,0,1): 3
        theta(17) = dot_product(vrrbuffer(:,2), D(:,6)) ! ((0,1,0)|(0,0,0))
        theta(23) = dot_product(vrrbuffer(:,8), D(:,6)) ! ((0,1,1)|(0,0,0))
        theta(30) = theta(23)+theta(17)*AB(3) ! ((0,1,0)|(0,0,1)) = ((0,1,1)|(0,0,0))+((0,1,0)|(0,0,0))*AB(3)
        ! (0,0,1|1,0,0): 3
        theta(18) = dot_product(vrrbuffer(:,3), D(:,7)) ! ((0,0,1)|(0,0,0))
        theta(21) = dot_product(vrrbuffer(:,6), D(:,7)) ! ((1,0,1)|(0,0,0))
        theta(31) = theta(21)+theta(18)*AB(1) ! ((0,0,1)|(1,0,0)) = ((1,0,1)|(0,0,0))+((0,0,1)|(0,0,0))*AB(1)
        ! (0,0,1|0,1,0): 3
        theta(18) = dot_product(vrrbuffer(:,3), D(:,8)) ! ((0,0,1)|(0,0,0))
        theta(23) = dot_product(vrrbuffer(:,8), D(:,8)) ! ((0,1,1)|(0,0,0))
        theta(32) = theta(23)+theta(18)*AB(2) ! ((0,0,1)|(0,1,0)) = ((0,1,1)|(0,0,0))+((0,0,1)|(0,0,0))*AB(2)
        ! (0,0,1|0,0,1): 3
        theta(18) = dot_product(vrrbuffer(:,3), D(:,9)) ! ((0,0,1)|(0,0,0))
        theta(24) = dot_product(vrrbuffer(:,9), D(:,9)) ! ((0,0,2)|(0,0,0))
        theta(33) = theta(24)+theta(18)*AB(3) ! ((0,0,1)|(0,0,1)) = ((0,0,2)|(0,0,0))+((0,0,1)|(0,0,0))*AB(3)
    end subroutine
    subroutine blockhrr_2_0(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 6; Optimized integrals: 6
        ! (2,0,0|0,0,0): 1
        theta(16) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((2,0,0)|(0,0,0))
        ! (1,1,0|0,0,0): 1
        theta(17) = dot_product(vrrbuffer(:,2), D(:,2)) ! ((1,1,0)|(0,0,0))
        ! (1,0,1|0,0,0): 1
        theta(18) = dot_product(vrrbuffer(:,3), D(:,3)) ! ((1,0,1)|(0,0,0))
        ! (0,2,0|0,0,0): 1
        theta(19) = dot_product(vrrbuffer(:,4), D(:,4)) ! ((0,2,0)|(0,0,0))
        ! (0,1,1|0,0,0): 1
        theta(20) = dot_product(vrrbuffer(:,5), D(:,5)) ! ((0,1,1)|(0,0,0))
        ! (0,0,2|0,0,0): 1
        theta(21) = dot_product(vrrbuffer(:,6), D(:,6)) ! ((0,0,2)|(0,0,0))
    end subroutine
    subroutine blockhrr_2_1(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 34; Optimized integrals: 34
        ! (2,0,0|1,0,0): 3
        theta(36) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((2,0,0)|(0,0,0))
        theta(42) = dot_product(vrrbuffer(:,7), D(:,1)) ! ((3,0,0)|(0,0,0))
        theta(52) = theta(42)+theta(36)*AB(1) ! ((2,0,0)|(1,0,0)) = ((3,0,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(1)
        ! (2,0,0|0,1,0): 3
        theta(36) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((2,0,0)|(0,0,0))
        theta(43) = dot_product(vrrbuffer(:,8), D(:,2)) ! ((2,1,0)|(0,0,0))
        theta(53) = theta(43)+theta(36)*AB(2) ! ((2,0,0)|(0,1,0)) = ((2,1,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(2)
        ! (2,0,0|0,0,1): 3
        theta(36) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((2,0,0)|(0,0,0))
        theta(44) = dot_product(vrrbuffer(:,9), D(:,3)) ! ((2,0,1)|(0,0,0))
        theta(54) = theta(44)+theta(36)*AB(3) ! ((2,0,0)|(0,0,1)) = ((2,0,1)|(0,0,0))+((2,0,0)|(0,0,0))*AB(3)
        ! (1,1,0|1,0,0): 3
        theta(37) = dot_product(vrrbuffer(:,2), D(:,4)) ! ((1,1,0)|(0,0,0))
        theta(43) = dot_product(vrrbuffer(:,8), D(:,4)) ! ((2,1,0)|(0,0,0))
        theta(55) = theta(43)+theta(37)*AB(1) ! ((1,1,0)|(1,0,0)) = ((2,1,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(1)
        ! (1,1,0|0,1,0): 3
        theta(37) = dot_product(vrrbuffer(:,2), D(:,5)) ! ((1,1,0)|(0,0,0))
        theta(45) = dot_product(vrrbuffer(:,10), D(:,5)) ! ((1,2,0)|(0,0,0))
        theta(56) = theta(45)+theta(37)*AB(2) ! ((1,1,0)|(0,1,0)) = ((1,2,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(2)
        ! (1,1,0|0,0,1): 3
        theta(37) = dot_product(vrrbuffer(:,2), D(:,6)) ! ((1,1,0)|(0,0,0))
        theta(46) = dot_product(vrrbuffer(:,11), D(:,6)) ! ((1,1,1)|(0,0,0))
        theta(57) = theta(46)+theta(37)*AB(3) ! ((1,1,0)|(0,0,1)) = ((1,1,1)|(0,0,0))+((1,1,0)|(0,0,0))*AB(3)
        ! (1,0,1|1,0,0): 3
        theta(38) = dot_product(vrrbuffer(:,3), D(:,7)) ! ((1,0,1)|(0,0,0))
        theta(44) = dot_product(vrrbuffer(:,9), D(:,7)) ! ((2,0,1)|(0,0,0))
        theta(58) = theta(44)+theta(38)*AB(1) ! ((1,0,1)|(1,0,0)) = ((2,0,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(1)
        ! (1,0,1|0,1,0): 3
        theta(38) = dot_product(vrrbuffer(:,3), D(:,8)) ! ((1,0,1)|(0,0,0))
        theta(46) = dot_product(vrrbuffer(:,11), D(:,8)) ! ((1,1,1)|(0,0,0))
        theta(59) = theta(46)+theta(38)*AB(2) ! ((1,0,1)|(0,1,0)) = ((1,1,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(2)
        ! (1,0,1|0,0,1): 3
        theta(38) = dot_product(vrrbuffer(:,3), D(:,9)) ! ((1,0,1)|(0,0,0))
        theta(47) = dot_product(vrrbuffer(:,12), D(:,9)) ! ((1,0,2)|(0,0,0))
        theta(60) = theta(47)+theta(38)*AB(3) ! ((1,0,1)|(0,0,1)) = ((1,0,2)|(0,0,0))+((1,0,1)|(0,0,0))*AB(3)
        ! (0,2,0|1,0,0): 3
        theta(39) = dot_product(vrrbuffer(:,4), D(:,10)) ! ((0,2,0)|(0,0,0))
        theta(45) = dot_product(vrrbuffer(:,10), D(:,10)) ! ((1,2,0)|(0,0,0))
        theta(61) = theta(45)+theta(39)*AB(1) ! ((0,2,0)|(1,0,0)) = ((1,2,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(1)
        ! (0,2,0|0,1,0): 3
        theta(39) = dot_product(vrrbuffer(:,4), D(:,11)) ! ((0,2,0)|(0,0,0))
        theta(48) = dot_product(vrrbuffer(:,13), D(:,11)) ! ((0,3,0)|(0,0,0))
        theta(62) = theta(48)+theta(39)*AB(2) ! ((0,2,0)|(0,1,0)) = ((0,3,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(2)
        ! (0,2,0|0,0,1): 3
        theta(39) = dot_product(vrrbuffer(:,4), D(:,12)) ! ((0,2,0)|(0,0,0))
        theta(49) = dot_product(vrrbuffer(:,14), D(:,12)) ! ((0,2,1)|(0,0,0))
        theta(63) = theta(49)+theta(39)*AB(3) ! ((0,2,0)|(0,0,1)) = ((0,2,1)|(0,0,0))+((0,2,0)|(0,0,0))*AB(3)
        ! (0,1,1|1,0,0): 3
        theta(40) = dot_product(vrrbuffer(:,5), D(:,13)) ! ((0,1,1)|(0,0,0))
        theta(46) = dot_product(vrrbuffer(:,11), D(:,13)) ! ((1,1,1)|(0,0,0))
        theta(64) = theta(46)+theta(40)*AB(1) ! ((0,1,1)|(1,0,0)) = ((1,1,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(1)
        ! (0,1,1|0,1,0): 3
        theta(40) = dot_product(vrrbuffer(:,5), D(:,14)) ! ((0,1,1)|(0,0,0))
        theta(49) = dot_product(vrrbuffer(:,14), D(:,14)) ! ((0,2,1)|(0,0,0))
        theta(65) = theta(49)+theta(40)*AB(2) ! ((0,1,1)|(0,1,0)) = ((0,2,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(2)
        ! (0,1,1|0,0,1): 3
        theta(40) = dot_product(vrrbuffer(:,5), D(:,15)) ! ((0,1,1)|(0,0,0))
        theta(50) = dot_product(vrrbuffer(:,15), D(:,15)) ! ((0,1,2)|(0,0,0))
        theta(66) = theta(50)+theta(40)*AB(3) ! ((0,1,1)|(0,0,1)) = ((0,1,2)|(0,0,0))+((0,1,1)|(0,0,0))*AB(3)
        ! (0,0,2|1,0,0): 3
        theta(41) = dot_product(vrrbuffer(:,6), D(:,16)) ! ((0,0,2)|(0,0,0))
        theta(47) = dot_product(vrrbuffer(:,12), D(:,16)) ! ((1,0,2)|(0,0,0))
        theta(67) = theta(47)+theta(41)*AB(1) ! ((0,0,2)|(1,0,0)) = ((1,0,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(1)
        ! (0,0,2|0,1,0): 3
        theta(41) = dot_product(vrrbuffer(:,6), D(:,17)) ! ((0,0,2)|(0,0,0))
        theta(50) = dot_product(vrrbuffer(:,15), D(:,17)) ! ((0,1,2)|(0,0,0))
        theta(68) = theta(50)+theta(41)*AB(2) ! ((0,0,2)|(0,1,0)) = ((0,1,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(2)
        ! (0,0,2|0,0,1): 3
        theta(41) = dot_product(vrrbuffer(:,6), D(:,18)) ! ((0,0,2)|(0,0,0))
        theta(51) = dot_product(vrrbuffer(:,16), D(:,18)) ! ((0,0,3)|(0,0,0))
        theta(69) = theta(51)+theta(41)*AB(3) ! ((0,0,2)|(0,0,1)) = ((0,0,3)|(0,0,0))+((0,0,2)|(0,0,0))*AB(3)
    end subroutine
    subroutine blockhrr_2_2(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 115; Optimized integrals: 110
        ! (2,0,0|2,0,0): 6
        theta(71) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((2,0,0)|(0,0,0))
        theta(77) = dot_product(vrrbuffer(:,7), D(:,1)) ! ((3,0,0)|(0,0,0))
        theta(87) = dot_product(vrrbuffer(:,17), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(102) = theta(77)+theta(71)*AB(1) ! ((2,0,0)|(1,0,0)) = ((3,0,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(1)
        theta(120) = theta(87)+theta(77)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(150) = theta(120)+theta(102)*AB(1) ! ((2,0,0)|(2,0,0)) = ((3,0,0)|(1,0,0))+((2,0,0)|(1,0,0))*AB(1)
        ! (2,0,0|1,1,0): 7
        theta(71) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((2,0,0)|(0,0,0))
        theta(77) = dot_product(vrrbuffer(:,7), D(:,2)) ! ((3,0,0)|(0,0,0))
        theta(78) = dot_product(vrrbuffer(:,8), D(:,2)) ! ((2,1,0)|(0,0,0))
        theta(88) = dot_product(vrrbuffer(:,18), D(:,2)) ! ((3,1,0)|(0,0,0))
        theta(103) = theta(78)+theta(71)*AB(2) ! ((2,0,0)|(0,1,0)) = ((2,1,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(2)
        theta(121) = theta(88)+theta(77)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(151) = theta(121)+theta(103)*AB(1) ! ((2,0,0)|(1,1,0)) = ((3,0,0)|(0,1,0))+((2,0,0)|(0,1,0))*AB(1)
        ! (2,0,0|1,0,1): 7
        theta(71) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((2,0,0)|(0,0,0))
        theta(77) = dot_product(vrrbuffer(:,7), D(:,3)) ! ((3,0,0)|(0,0,0))
        theta(79) = dot_product(vrrbuffer(:,9), D(:,3)) ! ((2,0,1)|(0,0,0))
        theta(89) = dot_product(vrrbuffer(:,19), D(:,3)) ! ((3,0,1)|(0,0,0))
        theta(104) = theta(79)+theta(71)*AB(3) ! ((2,0,0)|(0,0,1)) = ((2,0,1)|(0,0,0))+((2,0,0)|(0,0,0))*AB(3)
        theta(122) = theta(89)+theta(77)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(152) = theta(122)+theta(104)*AB(1) ! ((2,0,0)|(1,0,1)) = ((3,0,0)|(0,0,1))+((2,0,0)|(0,0,1))*AB(1)
        ! (2,0,0|0,2,0): 6
        theta(71) = dot_product(vrrbuffer(:,1), D(:,4)) ! ((2,0,0)|(0,0,0))
        theta(78) = dot_product(vrrbuffer(:,8), D(:,4)) ! ((2,1,0)|(0,0,0))
        theta(90) = dot_product(vrrbuffer(:,20), D(:,4)) ! ((2,2,0)|(0,0,0))
        theta(103) = theta(78)+theta(71)*AB(2) ! ((2,0,0)|(0,1,0)) = ((2,1,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(2)
        theta(124) = theta(90)+theta(78)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(153) = theta(124)+theta(103)*AB(2) ! ((2,0,0)|(0,2,0)) = ((2,1,0)|(0,1,0))+((2,0,0)|(0,1,0))*AB(2)
        ! (2,0,0|0,1,1): 7
        theta(71) = dot_product(vrrbuffer(:,1), D(:,5)) ! ((2,0,0)|(0,0,0))
        theta(78) = dot_product(vrrbuffer(:,8), D(:,5)) ! ((2,1,0)|(0,0,0))
        theta(79) = dot_product(vrrbuffer(:,9), D(:,5)) ! ((2,0,1)|(0,0,0))
        theta(91) = dot_product(vrrbuffer(:,21), D(:,5)) ! ((2,1,1)|(0,0,0))
        theta(104) = theta(79)+theta(71)*AB(3) ! ((2,0,0)|(0,0,1)) = ((2,0,1)|(0,0,0))+((2,0,0)|(0,0,0))*AB(3)
        theta(125) = theta(91)+theta(78)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(154) = theta(125)+theta(104)*AB(2) ! ((2,0,0)|(0,1,1)) = ((2,1,0)|(0,0,1))+((2,0,0)|(0,0,1))*AB(2)
        ! (2,0,0|0,0,2): 6
        theta(71) = dot_product(vrrbuffer(:,1), D(:,6)) ! ((2,0,0)|(0,0,0))
        theta(79) = dot_product(vrrbuffer(:,9), D(:,6)) ! ((2,0,1)|(0,0,0))
        theta(92) = dot_product(vrrbuffer(:,22), D(:,6)) ! ((2,0,2)|(0,0,0))
        theta(104) = theta(79)+theta(71)*AB(3) ! ((2,0,0)|(0,0,1)) = ((2,0,1)|(0,0,0))+((2,0,0)|(0,0,0))*AB(3)
        theta(128) = theta(92)+theta(79)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(155) = theta(128)+theta(104)*AB(3) ! ((2,0,0)|(0,0,2)) = ((2,0,1)|(0,0,1))+((2,0,0)|(0,0,1))*AB(3)
        ! (1,1,0|2,0,0): 6
        theta(72) = dot_product(vrrbuffer(:,2), D(:,7)) ! ((1,1,0)|(0,0,0))
        theta(78) = dot_product(vrrbuffer(:,8), D(:,7)) ! ((2,1,0)|(0,0,0))
        theta(88) = dot_product(vrrbuffer(:,18), D(:,7)) ! ((3,1,0)|(0,0,0))
        theta(105) = theta(78)+theta(72)*AB(1) ! ((1,1,0)|(1,0,0)) = ((2,1,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(1)
        theta(123) = theta(88)+theta(78)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(156) = theta(123)+theta(105)*AB(1) ! ((1,1,0)|(2,0,0)) = ((2,1,0)|(1,0,0))+((1,1,0)|(1,0,0))*AB(1)
        ! (1,1,0|1,1,0): 7
        theta(72) = dot_product(vrrbuffer(:,2), D(:,8)) ! ((1,1,0)|(0,0,0))
        theta(78) = dot_product(vrrbuffer(:,8), D(:,8)) ! ((2,1,0)|(0,0,0))
        theta(80) = dot_product(vrrbuffer(:,10), D(:,8)) ! ((1,2,0)|(0,0,0))
        theta(90) = dot_product(vrrbuffer(:,20), D(:,8)) ! ((2,2,0)|(0,0,0))
        theta(106) = theta(80)+theta(72)*AB(2) ! ((1,1,0)|(0,1,0)) = ((1,2,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(2)
        theta(124) = theta(90)+theta(78)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(157) = theta(124)+theta(106)*AB(1) ! ((1,1,0)|(1,1,0)) = ((2,1,0)|(0,1,0))+((1,1,0)|(0,1,0))*AB(1)
        ! (1,1,0|1,0,1): 7
        theta(72) = dot_product(vrrbuffer(:,2), D(:,9)) ! ((1,1,0)|(0,0,0))
        theta(78) = dot_product(vrrbuffer(:,8), D(:,9)) ! ((2,1,0)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,9)) ! ((1,1,1)|(0,0,0))
        theta(91) = dot_product(vrrbuffer(:,21), D(:,9)) ! ((2,1,1)|(0,0,0))
        theta(107) = theta(81)+theta(72)*AB(3) ! ((1,1,0)|(0,0,1)) = ((1,1,1)|(0,0,0))+((1,1,0)|(0,0,0))*AB(3)
        theta(125) = theta(91)+theta(78)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(158) = theta(125)+theta(107)*AB(1) ! ((1,1,0)|(1,0,1)) = ((2,1,0)|(0,0,1))+((1,1,0)|(0,0,1))*AB(1)
        ! (1,1,0|0,2,0): 6
        theta(72) = dot_product(vrrbuffer(:,2), D(:,10)) ! ((1,1,0)|(0,0,0))
        theta(80) = dot_product(vrrbuffer(:,10), D(:,10)) ! ((1,2,0)|(0,0,0))
        theta(93) = dot_product(vrrbuffer(:,23), D(:,10)) ! ((1,3,0)|(0,0,0))
        theta(106) = theta(80)+theta(72)*AB(2) ! ((1,1,0)|(0,1,0)) = ((1,2,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(2)
        theta(130) = theta(93)+theta(80)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(159) = theta(130)+theta(106)*AB(2) ! ((1,1,0)|(0,2,0)) = ((1,2,0)|(0,1,0))+((1,1,0)|(0,1,0))*AB(2)
        ! (1,1,0|0,1,1): 7
        theta(72) = dot_product(vrrbuffer(:,2), D(:,11)) ! ((1,1,0)|(0,0,0))
        theta(80) = dot_product(vrrbuffer(:,10), D(:,11)) ! ((1,2,0)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,11)) ! ((1,1,1)|(0,0,0))
        theta(94) = dot_product(vrrbuffer(:,24), D(:,11)) ! ((1,2,1)|(0,0,0))
        theta(107) = theta(81)+theta(72)*AB(3) ! ((1,1,0)|(0,0,1)) = ((1,1,1)|(0,0,0))+((1,1,0)|(0,0,0))*AB(3)
        theta(131) = theta(94)+theta(80)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(160) = theta(131)+theta(107)*AB(2) ! ((1,1,0)|(0,1,1)) = ((1,2,0)|(0,0,1))+((1,1,0)|(0,0,1))*AB(2)
        ! (1,1,0|0,0,2): 6
        theta(72) = dot_product(vrrbuffer(:,2), D(:,12)) ! ((1,1,0)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,12)) ! ((1,1,1)|(0,0,0))
        theta(95) = dot_product(vrrbuffer(:,25), D(:,12)) ! ((1,1,2)|(0,0,0))
        theta(107) = theta(81)+theta(72)*AB(3) ! ((1,1,0)|(0,0,1)) = ((1,1,1)|(0,0,0))+((1,1,0)|(0,0,0))*AB(3)
        theta(134) = theta(95)+theta(81)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(161) = theta(134)+theta(107)*AB(3) ! ((1,1,0)|(0,0,2)) = ((1,1,1)|(0,0,1))+((1,1,0)|(0,0,1))*AB(3)
        ! (1,0,1|2,0,0): 6
        theta(73) = dot_product(vrrbuffer(:,3), D(:,13)) ! ((1,0,1)|(0,0,0))
        theta(79) = dot_product(vrrbuffer(:,9), D(:,13)) ! ((2,0,1)|(0,0,0))
        theta(89) = dot_product(vrrbuffer(:,19), D(:,13)) ! ((3,0,1)|(0,0,0))
        theta(108) = theta(79)+theta(73)*AB(1) ! ((1,0,1)|(1,0,0)) = ((2,0,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(1)
        theta(126) = theta(89)+theta(79)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(162) = theta(126)+theta(108)*AB(1) ! ((1,0,1)|(2,0,0)) = ((2,0,1)|(1,0,0))+((1,0,1)|(1,0,0))*AB(1)
        ! (1,0,1|1,1,0): 7
        theta(73) = dot_product(vrrbuffer(:,3), D(:,14)) ! ((1,0,1)|(0,0,0))
        theta(79) = dot_product(vrrbuffer(:,9), D(:,14)) ! ((2,0,1)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,14)) ! ((1,1,1)|(0,0,0))
        theta(91) = dot_product(vrrbuffer(:,21), D(:,14)) ! ((2,1,1)|(0,0,0))
        theta(109) = theta(81)+theta(73)*AB(2) ! ((1,0,1)|(0,1,0)) = ((1,1,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(2)
        theta(127) = theta(91)+theta(79)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(163) = theta(127)+theta(109)*AB(1) ! ((1,0,1)|(1,1,0)) = ((2,0,1)|(0,1,0))+((1,0,1)|(0,1,0))*AB(1)
        ! (1,0,1|1,0,1): 7
        theta(73) = dot_product(vrrbuffer(:,3), D(:,15)) ! ((1,0,1)|(0,0,0))
        theta(79) = dot_product(vrrbuffer(:,9), D(:,15)) ! ((2,0,1)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,15)) ! ((1,0,2)|(0,0,0))
        theta(92) = dot_product(vrrbuffer(:,22), D(:,15)) ! ((2,0,2)|(0,0,0))
        theta(110) = theta(82)+theta(73)*AB(3) ! ((1,0,1)|(0,0,1)) = ((1,0,2)|(0,0,0))+((1,0,1)|(0,0,0))*AB(3)
        theta(128) = theta(92)+theta(79)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(164) = theta(128)+theta(110)*AB(1) ! ((1,0,1)|(1,0,1)) = ((2,0,1)|(0,0,1))+((1,0,1)|(0,0,1))*AB(1)
        ! (1,0,1|0,2,0): 6
        theta(73) = dot_product(vrrbuffer(:,3), D(:,16)) ! ((1,0,1)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,16)) ! ((1,1,1)|(0,0,0))
        theta(94) = dot_product(vrrbuffer(:,24), D(:,16)) ! ((1,2,1)|(0,0,0))
        theta(109) = theta(81)+theta(73)*AB(2) ! ((1,0,1)|(0,1,0)) = ((1,1,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(2)
        theta(133) = theta(94)+theta(81)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(165) = theta(133)+theta(109)*AB(2) ! ((1,0,1)|(0,2,0)) = ((1,1,1)|(0,1,0))+((1,0,1)|(0,1,0))*AB(2)
        ! (1,0,1|0,1,1): 7
        theta(73) = dot_product(vrrbuffer(:,3), D(:,17)) ! ((1,0,1)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,17)) ! ((1,1,1)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,17)) ! ((1,0,2)|(0,0,0))
        theta(95) = dot_product(vrrbuffer(:,25), D(:,17)) ! ((1,1,2)|(0,0,0))
        theta(110) = theta(82)+theta(73)*AB(3) ! ((1,0,1)|(0,0,1)) = ((1,0,2)|(0,0,0))+((1,0,1)|(0,0,0))*AB(3)
        theta(134) = theta(95)+theta(81)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(166) = theta(134)+theta(110)*AB(2) ! ((1,0,1)|(0,1,1)) = ((1,1,1)|(0,0,1))+((1,0,1)|(0,0,1))*AB(2)
        ! (1,0,1|0,0,2): 6
        theta(73) = dot_product(vrrbuffer(:,3), D(:,18)) ! ((1,0,1)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,18)) ! ((1,0,2)|(0,0,0))
        theta(96) = dot_product(vrrbuffer(:,26), D(:,18)) ! ((1,0,3)|(0,0,0))
        theta(110) = theta(82)+theta(73)*AB(3) ! ((1,0,1)|(0,0,1)) = ((1,0,2)|(0,0,0))+((1,0,1)|(0,0,0))*AB(3)
        theta(137) = theta(96)+theta(82)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(167) = theta(137)+theta(110)*AB(3) ! ((1,0,1)|(0,0,2)) = ((1,0,2)|(0,0,1))+((1,0,1)|(0,0,1))*AB(3)
        ! (0,2,0|2,0,0): 6
        theta(74) = dot_product(vrrbuffer(:,4), D(:,19)) ! ((0,2,0)|(0,0,0))
        theta(80) = dot_product(vrrbuffer(:,10), D(:,19)) ! ((1,2,0)|(0,0,0))
        theta(90) = dot_product(vrrbuffer(:,20), D(:,19)) ! ((2,2,0)|(0,0,0))
        theta(111) = theta(80)+theta(74)*AB(1) ! ((0,2,0)|(1,0,0)) = ((1,2,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(1)
        theta(129) = theta(90)+theta(80)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(168) = theta(129)+theta(111)*AB(1) ! ((0,2,0)|(2,0,0)) = ((1,2,0)|(1,0,0))+((0,2,0)|(1,0,0))*AB(1)
        ! (0,2,0|1,1,0): 7
        theta(74) = dot_product(vrrbuffer(:,4), D(:,20)) ! ((0,2,0)|(0,0,0))
        theta(80) = dot_product(vrrbuffer(:,10), D(:,20)) ! ((1,2,0)|(0,0,0))
        theta(83) = dot_product(vrrbuffer(:,13), D(:,20)) ! ((0,3,0)|(0,0,0))
        theta(93) = dot_product(vrrbuffer(:,23), D(:,20)) ! ((1,3,0)|(0,0,0))
        theta(112) = theta(83)+theta(74)*AB(2) ! ((0,2,0)|(0,1,0)) = ((0,3,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(2)
        theta(130) = theta(93)+theta(80)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(169) = theta(130)+theta(112)*AB(1) ! ((0,2,0)|(1,1,0)) = ((1,2,0)|(0,1,0))+((0,2,0)|(0,1,0))*AB(1)
        ! (0,2,0|1,0,1): 7
        theta(74) = dot_product(vrrbuffer(:,4), D(:,21)) ! ((0,2,0)|(0,0,0))
        theta(80) = dot_product(vrrbuffer(:,10), D(:,21)) ! ((1,2,0)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,21)) ! ((0,2,1)|(0,0,0))
        theta(94) = dot_product(vrrbuffer(:,24), D(:,21)) ! ((1,2,1)|(0,0,0))
        theta(113) = theta(84)+theta(74)*AB(3) ! ((0,2,0)|(0,0,1)) = ((0,2,1)|(0,0,0))+((0,2,0)|(0,0,0))*AB(3)
        theta(131) = theta(94)+theta(80)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(170) = theta(131)+theta(113)*AB(1) ! ((0,2,0)|(1,0,1)) = ((1,2,0)|(0,0,1))+((0,2,0)|(0,0,1))*AB(1)
        ! (0,2,0|0,2,0): 6
        theta(74) = dot_product(vrrbuffer(:,4), D(:,22)) ! ((0,2,0)|(0,0,0))
        theta(83) = dot_product(vrrbuffer(:,13), D(:,22)) ! ((0,3,0)|(0,0,0))
        theta(97) = dot_product(vrrbuffer(:,27), D(:,22)) ! ((0,4,0)|(0,0,0))
        theta(112) = theta(83)+theta(74)*AB(2) ! ((0,2,0)|(0,1,0)) = ((0,3,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(2)
        theta(139) = theta(97)+theta(83)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(171) = theta(139)+theta(112)*AB(2) ! ((0,2,0)|(0,2,0)) = ((0,3,0)|(0,1,0))+((0,2,0)|(0,1,0))*AB(2)
        ! (0,2,0|0,1,1): 7
        theta(74) = dot_product(vrrbuffer(:,4), D(:,23)) ! ((0,2,0)|(0,0,0))
        theta(83) = dot_product(vrrbuffer(:,13), D(:,23)) ! ((0,3,0)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,23)) ! ((0,2,1)|(0,0,0))
        theta(98) = dot_product(vrrbuffer(:,28), D(:,23)) ! ((0,3,1)|(0,0,0))
        theta(113) = theta(84)+theta(74)*AB(3) ! ((0,2,0)|(0,0,1)) = ((0,2,1)|(0,0,0))+((0,2,0)|(0,0,0))*AB(3)
        theta(140) = theta(98)+theta(83)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(172) = theta(140)+theta(113)*AB(2) ! ((0,2,0)|(0,1,1)) = ((0,3,0)|(0,0,1))+((0,2,0)|(0,0,1))*AB(2)
        ! (0,2,0|0,0,2): 6
        theta(74) = dot_product(vrrbuffer(:,4), D(:,24)) ! ((0,2,0)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,24)) ! ((0,2,1)|(0,0,0))
        theta(99) = dot_product(vrrbuffer(:,29), D(:,24)) ! ((0,2,2)|(0,0,0))
        theta(113) = theta(84)+theta(74)*AB(3) ! ((0,2,0)|(0,0,1)) = ((0,2,1)|(0,0,0))+((0,2,0)|(0,0,0))*AB(3)
        theta(143) = theta(99)+theta(84)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(173) = theta(143)+theta(113)*AB(3) ! ((0,2,0)|(0,0,2)) = ((0,2,1)|(0,0,1))+((0,2,0)|(0,0,1))*AB(3)
        ! (0,1,1|2,0,0): 6
        theta(75) = dot_product(vrrbuffer(:,5), D(:,25)) ! ((0,1,1)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,25)) ! ((1,1,1)|(0,0,0))
        theta(91) = dot_product(vrrbuffer(:,21), D(:,25)) ! ((2,1,1)|(0,0,0))
        theta(114) = theta(81)+theta(75)*AB(1) ! ((0,1,1)|(1,0,0)) = ((1,1,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(1)
        theta(132) = theta(91)+theta(81)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(174) = theta(132)+theta(114)*AB(1) ! ((0,1,1)|(2,0,0)) = ((1,1,1)|(1,0,0))+((0,1,1)|(1,0,0))*AB(1)
        ! (0,1,1|1,1,0): 7
        theta(75) = dot_product(vrrbuffer(:,5), D(:,26)) ! ((0,1,1)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,26)) ! ((1,1,1)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,26)) ! ((0,2,1)|(0,0,0))
        theta(94) = dot_product(vrrbuffer(:,24), D(:,26)) ! ((1,2,1)|(0,0,0))
        theta(115) = theta(84)+theta(75)*AB(2) ! ((0,1,1)|(0,1,0)) = ((0,2,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(2)
        theta(133) = theta(94)+theta(81)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(175) = theta(133)+theta(115)*AB(1) ! ((0,1,1)|(1,1,0)) = ((1,1,1)|(0,1,0))+((0,1,1)|(0,1,0))*AB(1)
        ! (0,1,1|1,0,1): 7
        theta(75) = dot_product(vrrbuffer(:,5), D(:,27)) ! ((0,1,1)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,27)) ! ((1,1,1)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,27)) ! ((0,1,2)|(0,0,0))
        theta(95) = dot_product(vrrbuffer(:,25), D(:,27)) ! ((1,1,2)|(0,0,0))
        theta(116) = theta(85)+theta(75)*AB(3) ! ((0,1,1)|(0,0,1)) = ((0,1,2)|(0,0,0))+((0,1,1)|(0,0,0))*AB(3)
        theta(134) = theta(95)+theta(81)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(176) = theta(134)+theta(116)*AB(1) ! ((0,1,1)|(1,0,1)) = ((1,1,1)|(0,0,1))+((0,1,1)|(0,0,1))*AB(1)
        ! (0,1,1|0,2,0): 6
        theta(75) = dot_product(vrrbuffer(:,5), D(:,28)) ! ((0,1,1)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,28)) ! ((0,2,1)|(0,0,0))
        theta(98) = dot_product(vrrbuffer(:,28), D(:,28)) ! ((0,3,1)|(0,0,0))
        theta(115) = theta(84)+theta(75)*AB(2) ! ((0,1,1)|(0,1,0)) = ((0,2,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(2)
        theta(142) = theta(98)+theta(84)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(177) = theta(142)+theta(115)*AB(2) ! ((0,1,1)|(0,2,0)) = ((0,2,1)|(0,1,0))+((0,1,1)|(0,1,0))*AB(2)
        ! (0,1,1|0,1,1): 7
        theta(75) = dot_product(vrrbuffer(:,5), D(:,29)) ! ((0,1,1)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,29)) ! ((0,2,1)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,29)) ! ((0,1,2)|(0,0,0))
        theta(99) = dot_product(vrrbuffer(:,29), D(:,29)) ! ((0,2,2)|(0,0,0))
        theta(116) = theta(85)+theta(75)*AB(3) ! ((0,1,1)|(0,0,1)) = ((0,1,2)|(0,0,0))+((0,1,1)|(0,0,0))*AB(3)
        theta(143) = theta(99)+theta(84)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(178) = theta(143)+theta(116)*AB(2) ! ((0,1,1)|(0,1,1)) = ((0,2,1)|(0,0,1))+((0,1,1)|(0,0,1))*AB(2)
        ! (0,1,1|0,0,2): 6
        theta(75) = dot_product(vrrbuffer(:,5), D(:,30)) ! ((0,1,1)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,30)) ! ((0,1,2)|(0,0,0))
        theta(100) = dot_product(vrrbuffer(:,30), D(:,30)) ! ((0,1,3)|(0,0,0))
        theta(116) = theta(85)+theta(75)*AB(3) ! ((0,1,1)|(0,0,1)) = ((0,1,2)|(0,0,0))+((0,1,1)|(0,0,0))*AB(3)
        theta(146) = theta(100)+theta(85)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(179) = theta(146)+theta(116)*AB(3) ! ((0,1,1)|(0,0,2)) = ((0,1,2)|(0,0,1))+((0,1,1)|(0,0,1))*AB(3)
        ! (0,0,2|2,0,0): 6
        theta(76) = dot_product(vrrbuffer(:,6), D(:,31)) ! ((0,0,2)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,31)) ! ((1,0,2)|(0,0,0))
        theta(92) = dot_product(vrrbuffer(:,22), D(:,31)) ! ((2,0,2)|(0,0,0))
        theta(117) = theta(82)+theta(76)*AB(1) ! ((0,0,2)|(1,0,0)) = ((1,0,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(1)
        theta(135) = theta(92)+theta(82)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(180) = theta(135)+theta(117)*AB(1) ! ((0,0,2)|(2,0,0)) = ((1,0,2)|(1,0,0))+((0,0,2)|(1,0,0))*AB(1)
        ! (0,0,2|1,1,0): 7
        theta(76) = dot_product(vrrbuffer(:,6), D(:,32)) ! ((0,0,2)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,32)) ! ((1,0,2)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,32)) ! ((0,1,2)|(0,0,0))
        theta(95) = dot_product(vrrbuffer(:,25), D(:,32)) ! ((1,1,2)|(0,0,0))
        theta(118) = theta(85)+theta(76)*AB(2) ! ((0,0,2)|(0,1,0)) = ((0,1,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(2)
        theta(136) = theta(95)+theta(82)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(181) = theta(136)+theta(118)*AB(1) ! ((0,0,2)|(1,1,0)) = ((1,0,2)|(0,1,0))+((0,0,2)|(0,1,0))*AB(1)
        ! (0,0,2|1,0,1): 7
        theta(76) = dot_product(vrrbuffer(:,6), D(:,33)) ! ((0,0,2)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,33)) ! ((1,0,2)|(0,0,0))
        theta(86) = dot_product(vrrbuffer(:,16), D(:,33)) ! ((0,0,3)|(0,0,0))
        theta(96) = dot_product(vrrbuffer(:,26), D(:,33)) ! ((1,0,3)|(0,0,0))
        theta(119) = theta(86)+theta(76)*AB(3) ! ((0,0,2)|(0,0,1)) = ((0,0,3)|(0,0,0))+((0,0,2)|(0,0,0))*AB(3)
        theta(137) = theta(96)+theta(82)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(182) = theta(137)+theta(119)*AB(1) ! ((0,0,2)|(1,0,1)) = ((1,0,2)|(0,0,1))+((0,0,2)|(0,0,1))*AB(1)
        ! (0,0,2|0,2,0): 6
        theta(76) = dot_product(vrrbuffer(:,6), D(:,34)) ! ((0,0,2)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,34)) ! ((0,1,2)|(0,0,0))
        theta(99) = dot_product(vrrbuffer(:,29), D(:,34)) ! ((0,2,2)|(0,0,0))
        theta(118) = theta(85)+theta(76)*AB(2) ! ((0,0,2)|(0,1,0)) = ((0,1,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(2)
        theta(145) = theta(99)+theta(85)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(183) = theta(145)+theta(118)*AB(2) ! ((0,0,2)|(0,2,0)) = ((0,1,2)|(0,1,0))+((0,0,2)|(0,1,0))*AB(2)
        ! (0,0,2|0,1,1): 7
        theta(76) = dot_product(vrrbuffer(:,6), D(:,35)) ! ((0,0,2)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,35)) ! ((0,1,2)|(0,0,0))
        theta(86) = dot_product(vrrbuffer(:,16), D(:,35)) ! ((0,0,3)|(0,0,0))
        theta(100) = dot_product(vrrbuffer(:,30), D(:,35)) ! ((0,1,3)|(0,0,0))
        theta(119) = theta(86)+theta(76)*AB(3) ! ((0,0,2)|(0,0,1)) = ((0,0,3)|(0,0,0))+((0,0,2)|(0,0,0))*AB(3)
        theta(146) = theta(100)+theta(85)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(184) = theta(146)+theta(119)*AB(2) ! ((0,0,2)|(0,1,1)) = ((0,1,2)|(0,0,1))+((0,0,2)|(0,0,1))*AB(2)
        ! (0,0,2|0,0,2): 6
        theta(76) = dot_product(vrrbuffer(:,6), D(:,36)) ! ((0,0,2)|(0,0,0))
        theta(86) = dot_product(vrrbuffer(:,16), D(:,36)) ! ((0,0,3)|(0,0,0))
        theta(101) = dot_product(vrrbuffer(:,31), D(:,36)) ! ((0,0,4)|(0,0,0))
        theta(119) = theta(86)+theta(76)*AB(3) ! ((0,0,2)|(0,0,1)) = ((0,0,3)|(0,0,0))+((0,0,2)|(0,0,0))*AB(3)
        theta(149) = theta(101)+theta(86)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(185) = theta(149)+theta(119)*AB(3) ! ((0,0,2)|(0,0,2)) = ((0,0,3)|(0,0,1))+((0,0,2)|(0,0,1))*AB(3)
    end subroutine
    subroutine blockhrr_3_0(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 10; Optimized integrals: 10
        ! (3,0,0|0,0,0): 1
        theta(36) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((3,0,0)|(0,0,0))
        ! (2,1,0|0,0,0): 1
        theta(37) = dot_product(vrrbuffer(:,2), D(:,2)) ! ((2,1,0)|(0,0,0))
        ! (2,0,1|0,0,0): 1
        theta(38) = dot_product(vrrbuffer(:,3), D(:,3)) ! ((2,0,1)|(0,0,0))
        ! (1,2,0|0,0,0): 1
        theta(39) = dot_product(vrrbuffer(:,4), D(:,4)) ! ((1,2,0)|(0,0,0))
        ! (1,1,1|0,0,0): 1
        theta(40) = dot_product(vrrbuffer(:,5), D(:,5)) ! ((1,1,1)|(0,0,0))
        ! (1,0,2|0,0,0): 1
        theta(41) = dot_product(vrrbuffer(:,6), D(:,6)) ! ((1,0,2)|(0,0,0))
        ! (0,3,0|0,0,0): 1
        theta(42) = dot_product(vrrbuffer(:,7), D(:,7)) ! ((0,3,0)|(0,0,0))
        ! (0,2,1|0,0,0): 1
        theta(43) = dot_product(vrrbuffer(:,8), D(:,8)) ! ((0,2,1)|(0,0,0))
        ! (0,1,2|0,0,0): 1
        theta(44) = dot_product(vrrbuffer(:,9), D(:,9)) ! ((0,1,2)|(0,0,0))
        ! (0,0,3|0,0,0): 1
        theta(45) = dot_product(vrrbuffer(:,10), D(:,10)) ! ((0,0,3)|(0,0,0))
    end subroutine
    subroutine blockhrr_3_1(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 55; Optimized integrals: 55
        ! (3,0,0|1,0,0): 3
        theta(71) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((3,0,0)|(0,0,0))
        theta(81) = dot_product(vrrbuffer(:,11), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(96) = theta(81)+theta(71)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        ! (3,0,0|0,1,0): 3
        theta(71) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((3,0,0)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,2)) ! ((3,1,0)|(0,0,0))
        theta(97) = theta(82)+theta(71)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        ! (3,0,0|0,0,1): 3
        theta(71) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((3,0,0)|(0,0,0))
        theta(83) = dot_product(vrrbuffer(:,13), D(:,3)) ! ((3,0,1)|(0,0,0))
        theta(98) = theta(83)+theta(71)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        ! (2,1,0|1,0,0): 3
        theta(72) = dot_product(vrrbuffer(:,2), D(:,4)) ! ((2,1,0)|(0,0,0))
        theta(82) = dot_product(vrrbuffer(:,12), D(:,4)) ! ((3,1,0)|(0,0,0))
        theta(99) = theta(82)+theta(72)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        ! (2,1,0|0,1,0): 3
        theta(72) = dot_product(vrrbuffer(:,2), D(:,5)) ! ((2,1,0)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,5)) ! ((2,2,0)|(0,0,0))
        theta(100) = theta(84)+theta(72)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        ! (2,1,0|0,0,1): 3
        theta(72) = dot_product(vrrbuffer(:,2), D(:,6)) ! ((2,1,0)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,6)) ! ((2,1,1)|(0,0,0))
        theta(101) = theta(85)+theta(72)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        ! (2,0,1|1,0,0): 3
        theta(73) = dot_product(vrrbuffer(:,3), D(:,7)) ! ((2,0,1)|(0,0,0))
        theta(83) = dot_product(vrrbuffer(:,13), D(:,7)) ! ((3,0,1)|(0,0,0))
        theta(102) = theta(83)+theta(73)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        ! (2,0,1|0,1,0): 3
        theta(73) = dot_product(vrrbuffer(:,3), D(:,8)) ! ((2,0,1)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,8)) ! ((2,1,1)|(0,0,0))
        theta(103) = theta(85)+theta(73)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        ! (2,0,1|0,0,1): 3
        theta(73) = dot_product(vrrbuffer(:,3), D(:,9)) ! ((2,0,1)|(0,0,0))
        theta(86) = dot_product(vrrbuffer(:,16), D(:,9)) ! ((2,0,2)|(0,0,0))
        theta(104) = theta(86)+theta(73)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        ! (1,2,0|1,0,0): 3
        theta(74) = dot_product(vrrbuffer(:,4), D(:,10)) ! ((1,2,0)|(0,0,0))
        theta(84) = dot_product(vrrbuffer(:,14), D(:,10)) ! ((2,2,0)|(0,0,0))
        theta(105) = theta(84)+theta(74)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        ! (1,2,0|0,1,0): 3
        theta(74) = dot_product(vrrbuffer(:,4), D(:,11)) ! ((1,2,0)|(0,0,0))
        theta(87) = dot_product(vrrbuffer(:,17), D(:,11)) ! ((1,3,0)|(0,0,0))
        theta(106) = theta(87)+theta(74)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        ! (1,2,0|0,0,1): 3
        theta(74) = dot_product(vrrbuffer(:,4), D(:,12)) ! ((1,2,0)|(0,0,0))
        theta(88) = dot_product(vrrbuffer(:,18), D(:,12)) ! ((1,2,1)|(0,0,0))
        theta(107) = theta(88)+theta(74)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        ! (1,1,1|1,0,0): 3
        theta(75) = dot_product(vrrbuffer(:,5), D(:,13)) ! ((1,1,1)|(0,0,0))
        theta(85) = dot_product(vrrbuffer(:,15), D(:,13)) ! ((2,1,1)|(0,0,0))
        theta(108) = theta(85)+theta(75)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        ! (1,1,1|0,1,0): 3
        theta(75) = dot_product(vrrbuffer(:,5), D(:,14)) ! ((1,1,1)|(0,0,0))
        theta(88) = dot_product(vrrbuffer(:,18), D(:,14)) ! ((1,2,1)|(0,0,0))
        theta(109) = theta(88)+theta(75)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        ! (1,1,1|0,0,1): 3
        theta(75) = dot_product(vrrbuffer(:,5), D(:,15)) ! ((1,1,1)|(0,0,0))
        theta(89) = dot_product(vrrbuffer(:,19), D(:,15)) ! ((1,1,2)|(0,0,0))
        theta(110) = theta(89)+theta(75)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        ! (1,0,2|1,0,0): 3
        theta(76) = dot_product(vrrbuffer(:,6), D(:,16)) ! ((1,0,2)|(0,0,0))
        theta(86) = dot_product(vrrbuffer(:,16), D(:,16)) ! ((2,0,2)|(0,0,0))
        theta(111) = theta(86)+theta(76)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        ! (1,0,2|0,1,0): 3
        theta(76) = dot_product(vrrbuffer(:,6), D(:,17)) ! ((1,0,2)|(0,0,0))
        theta(89) = dot_product(vrrbuffer(:,19), D(:,17)) ! ((1,1,2)|(0,0,0))
        theta(112) = theta(89)+theta(76)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        ! (1,0,2|0,0,1): 3
        theta(76) = dot_product(vrrbuffer(:,6), D(:,18)) ! ((1,0,2)|(0,0,0))
        theta(90) = dot_product(vrrbuffer(:,20), D(:,18)) ! ((1,0,3)|(0,0,0))
        theta(113) = theta(90)+theta(76)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        ! (0,3,0|1,0,0): 3
        theta(77) = dot_product(vrrbuffer(:,7), D(:,19)) ! ((0,3,0)|(0,0,0))
        theta(87) = dot_product(vrrbuffer(:,17), D(:,19)) ! ((1,3,0)|(0,0,0))
        theta(114) = theta(87)+theta(77)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        ! (0,3,0|0,1,0): 3
        theta(77) = dot_product(vrrbuffer(:,7), D(:,20)) ! ((0,3,0)|(0,0,0))
        theta(91) = dot_product(vrrbuffer(:,21), D(:,20)) ! ((0,4,0)|(0,0,0))
        theta(115) = theta(91)+theta(77)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        ! (0,3,0|0,0,1): 3
        theta(77) = dot_product(vrrbuffer(:,7), D(:,21)) ! ((0,3,0)|(0,0,0))
        theta(92) = dot_product(vrrbuffer(:,22), D(:,21)) ! ((0,3,1)|(0,0,0))
        theta(116) = theta(92)+theta(77)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        ! (0,2,1|1,0,0): 3
        theta(78) = dot_product(vrrbuffer(:,8), D(:,22)) ! ((0,2,1)|(0,0,0))
        theta(88) = dot_product(vrrbuffer(:,18), D(:,22)) ! ((1,2,1)|(0,0,0))
        theta(117) = theta(88)+theta(78)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        ! (0,2,1|0,1,0): 3
        theta(78) = dot_product(vrrbuffer(:,8), D(:,23)) ! ((0,2,1)|(0,0,0))
        theta(92) = dot_product(vrrbuffer(:,22), D(:,23)) ! ((0,3,1)|(0,0,0))
        theta(118) = theta(92)+theta(78)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        ! (0,2,1|0,0,1): 3
        theta(78) = dot_product(vrrbuffer(:,8), D(:,24)) ! ((0,2,1)|(0,0,0))
        theta(93) = dot_product(vrrbuffer(:,23), D(:,24)) ! ((0,2,2)|(0,0,0))
        theta(119) = theta(93)+theta(78)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        ! (0,1,2|1,0,0): 3
        theta(79) = dot_product(vrrbuffer(:,9), D(:,25)) ! ((0,1,2)|(0,0,0))
        theta(89) = dot_product(vrrbuffer(:,19), D(:,25)) ! ((1,1,2)|(0,0,0))
        theta(120) = theta(89)+theta(79)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        ! (0,1,2|0,1,0): 3
        theta(79) = dot_product(vrrbuffer(:,9), D(:,26)) ! ((0,1,2)|(0,0,0))
        theta(93) = dot_product(vrrbuffer(:,23), D(:,26)) ! ((0,2,2)|(0,0,0))
        theta(121) = theta(93)+theta(79)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        ! (0,1,2|0,0,1): 3
        theta(79) = dot_product(vrrbuffer(:,9), D(:,27)) ! ((0,1,2)|(0,0,0))
        theta(94) = dot_product(vrrbuffer(:,24), D(:,27)) ! ((0,1,3)|(0,0,0))
        theta(122) = theta(94)+theta(79)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        ! (0,0,3|1,0,0): 3
        theta(80) = dot_product(vrrbuffer(:,10), D(:,28)) ! ((0,0,3)|(0,0,0))
        theta(90) = dot_product(vrrbuffer(:,20), D(:,28)) ! ((1,0,3)|(0,0,0))
        theta(123) = theta(90)+theta(80)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        ! (0,0,3|0,1,0): 3
        theta(80) = dot_product(vrrbuffer(:,10), D(:,29)) ! ((0,0,3)|(0,0,0))
        theta(94) = dot_product(vrrbuffer(:,24), D(:,29)) ! ((0,1,3)|(0,0,0))
        theta(124) = theta(94)+theta(80)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        ! (0,0,3|0,0,1): 3
        theta(80) = dot_product(vrrbuffer(:,10), D(:,30)) ! ((0,0,3)|(0,0,0))
        theta(95) = dot_product(vrrbuffer(:,25), D(:,30)) ! ((0,0,4)|(0,0,0))
        theta(125) = theta(95)+theta(80)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
    end subroutine
    subroutine blockhrr_3_2(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 181; Optimized integrals: 175
        ! (3,0,0|2,0,0): 6
        theta(127) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((3,0,0)|(0,0,0))
        theta(137) = dot_product(vrrbuffer(:,11), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(152) = dot_product(vrrbuffer(:,26), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(173) = theta(137)+theta(127)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(203) = theta(152)+theta(137)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(248) = theta(203)+theta(173)*AB(1) ! ((3,0,0)|(2,0,0)) = ((4,0,0)|(1,0,0))+((3,0,0)|(1,0,0))*AB(1)
        ! (3,0,0|1,1,0): 7
        theta(127) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((3,0,0)|(0,0,0))
        theta(137) = dot_product(vrrbuffer(:,11), D(:,2)) ! ((4,0,0)|(0,0,0))
        theta(138) = dot_product(vrrbuffer(:,12), D(:,2)) ! ((3,1,0)|(0,0,0))
        theta(153) = dot_product(vrrbuffer(:,27), D(:,2)) ! ((4,1,0)|(0,0,0))
        theta(174) = theta(138)+theta(127)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(204) = theta(153)+theta(137)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(249) = theta(204)+theta(174)*AB(1) ! ((3,0,0)|(1,1,0)) = ((4,0,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(1)
        ! (3,0,0|1,0,1): 7
        theta(127) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((3,0,0)|(0,0,0))
        theta(137) = dot_product(vrrbuffer(:,11), D(:,3)) ! ((4,0,0)|(0,0,0))
        theta(139) = dot_product(vrrbuffer(:,13), D(:,3)) ! ((3,0,1)|(0,0,0))
        theta(154) = dot_product(vrrbuffer(:,28), D(:,3)) ! ((4,0,1)|(0,0,0))
        theta(175) = theta(139)+theta(127)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(205) = theta(154)+theta(137)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(250) = theta(205)+theta(175)*AB(1) ! ((3,0,0)|(1,0,1)) = ((4,0,0)|(0,0,1))+((3,0,0)|(0,0,1))*AB(1)
        ! (3,0,0|0,2,0): 6
        theta(127) = dot_product(vrrbuffer(:,1), D(:,4)) ! ((3,0,0)|(0,0,0))
        theta(138) = dot_product(vrrbuffer(:,12), D(:,4)) ! ((3,1,0)|(0,0,0))
        theta(155) = dot_product(vrrbuffer(:,29), D(:,4)) ! ((3,2,0)|(0,0,0))
        theta(174) = theta(138)+theta(127)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(207) = theta(155)+theta(138)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(251) = theta(207)+theta(174)*AB(2) ! ((3,0,0)|(0,2,0)) = ((3,1,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(2)
        ! (3,0,0|0,1,1): 7
        theta(127) = dot_product(vrrbuffer(:,1), D(:,5)) ! ((3,0,0)|(0,0,0))
        theta(138) = dot_product(vrrbuffer(:,12), D(:,5)) ! ((3,1,0)|(0,0,0))
        theta(139) = dot_product(vrrbuffer(:,13), D(:,5)) ! ((3,0,1)|(0,0,0))
        theta(156) = dot_product(vrrbuffer(:,30), D(:,5)) ! ((3,1,1)|(0,0,0))
        theta(175) = theta(139)+theta(127)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(208) = theta(156)+theta(138)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(252) = theta(208)+theta(175)*AB(2) ! ((3,0,0)|(0,1,1)) = ((3,1,0)|(0,0,1))+((3,0,0)|(0,0,1))*AB(2)
        ! (3,0,0|0,0,2): 6
        theta(127) = dot_product(vrrbuffer(:,1), D(:,6)) ! ((3,0,0)|(0,0,0))
        theta(139) = dot_product(vrrbuffer(:,13), D(:,6)) ! ((3,0,1)|(0,0,0))
        theta(157) = dot_product(vrrbuffer(:,31), D(:,6)) ! ((3,0,2)|(0,0,0))
        theta(175) = theta(139)+theta(127)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(211) = theta(157)+theta(139)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(253) = theta(211)+theta(175)*AB(3) ! ((3,0,0)|(0,0,2)) = ((3,0,1)|(0,0,1))+((3,0,0)|(0,0,1))*AB(3)
        ! (2,1,0|2,0,0): 6
        theta(128) = dot_product(vrrbuffer(:,2), D(:,7)) ! ((2,1,0)|(0,0,0))
        theta(138) = dot_product(vrrbuffer(:,12), D(:,7)) ! ((3,1,0)|(0,0,0))
        theta(153) = dot_product(vrrbuffer(:,27), D(:,7)) ! ((4,1,0)|(0,0,0))
        theta(176) = theta(138)+theta(128)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(206) = theta(153)+theta(138)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(254) = theta(206)+theta(176)*AB(1) ! ((2,1,0)|(2,0,0)) = ((3,1,0)|(1,0,0))+((2,1,0)|(1,0,0))*AB(1)
        ! (2,1,0|1,1,0): 7
        theta(128) = dot_product(vrrbuffer(:,2), D(:,8)) ! ((2,1,0)|(0,0,0))
        theta(138) = dot_product(vrrbuffer(:,12), D(:,8)) ! ((3,1,0)|(0,0,0))
        theta(140) = dot_product(vrrbuffer(:,14), D(:,8)) ! ((2,2,0)|(0,0,0))
        theta(155) = dot_product(vrrbuffer(:,29), D(:,8)) ! ((3,2,0)|(0,0,0))
        theta(177) = theta(140)+theta(128)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(207) = theta(155)+theta(138)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(255) = theta(207)+theta(177)*AB(1) ! ((2,1,0)|(1,1,0)) = ((3,1,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(1)
        ! (2,1,0|1,0,1): 7
        theta(128) = dot_product(vrrbuffer(:,2), D(:,9)) ! ((2,1,0)|(0,0,0))
        theta(138) = dot_product(vrrbuffer(:,12), D(:,9)) ! ((3,1,0)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,9)) ! ((2,1,1)|(0,0,0))
        theta(156) = dot_product(vrrbuffer(:,30), D(:,9)) ! ((3,1,1)|(0,0,0))
        theta(178) = theta(141)+theta(128)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(208) = theta(156)+theta(138)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(256) = theta(208)+theta(178)*AB(1) ! ((2,1,0)|(1,0,1)) = ((3,1,0)|(0,0,1))+((2,1,0)|(0,0,1))*AB(1)
        ! (2,1,0|0,2,0): 6
        theta(128) = dot_product(vrrbuffer(:,2), D(:,10)) ! ((2,1,0)|(0,0,0))
        theta(140) = dot_product(vrrbuffer(:,14), D(:,10)) ! ((2,2,0)|(0,0,0))
        theta(158) = dot_product(vrrbuffer(:,32), D(:,10)) ! ((2,3,0)|(0,0,0))
        theta(177) = theta(140)+theta(128)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(213) = theta(158)+theta(140)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(257) = theta(213)+theta(177)*AB(2) ! ((2,1,0)|(0,2,0)) = ((2,2,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(2)
        ! (2,1,0|0,1,1): 7
        theta(128) = dot_product(vrrbuffer(:,2), D(:,11)) ! ((2,1,0)|(0,0,0))
        theta(140) = dot_product(vrrbuffer(:,14), D(:,11)) ! ((2,2,0)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,11)) ! ((2,1,1)|(0,0,0))
        theta(159) = dot_product(vrrbuffer(:,33), D(:,11)) ! ((2,2,1)|(0,0,0))
        theta(178) = theta(141)+theta(128)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(214) = theta(159)+theta(140)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(258) = theta(214)+theta(178)*AB(2) ! ((2,1,0)|(0,1,1)) = ((2,2,0)|(0,0,1))+((2,1,0)|(0,0,1))*AB(2)
        ! (2,1,0|0,0,2): 6
        theta(128) = dot_product(vrrbuffer(:,2), D(:,12)) ! ((2,1,0)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,12)) ! ((2,1,1)|(0,0,0))
        theta(160) = dot_product(vrrbuffer(:,34), D(:,12)) ! ((2,1,2)|(0,0,0))
        theta(178) = theta(141)+theta(128)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(217) = theta(160)+theta(141)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(259) = theta(217)+theta(178)*AB(3) ! ((2,1,0)|(0,0,2)) = ((2,1,1)|(0,0,1))+((2,1,0)|(0,0,1))*AB(3)
        ! (2,0,1|2,0,0): 6
        theta(129) = dot_product(vrrbuffer(:,3), D(:,13)) ! ((2,0,1)|(0,0,0))
        theta(139) = dot_product(vrrbuffer(:,13), D(:,13)) ! ((3,0,1)|(0,0,0))
        theta(154) = dot_product(vrrbuffer(:,28), D(:,13)) ! ((4,0,1)|(0,0,0))
        theta(179) = theta(139)+theta(129)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(209) = theta(154)+theta(139)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(260) = theta(209)+theta(179)*AB(1) ! ((2,0,1)|(2,0,0)) = ((3,0,1)|(1,0,0))+((2,0,1)|(1,0,0))*AB(1)
        ! (2,0,1|1,1,0): 7
        theta(129) = dot_product(vrrbuffer(:,3), D(:,14)) ! ((2,0,1)|(0,0,0))
        theta(139) = dot_product(vrrbuffer(:,13), D(:,14)) ! ((3,0,1)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,14)) ! ((2,1,1)|(0,0,0))
        theta(156) = dot_product(vrrbuffer(:,30), D(:,14)) ! ((3,1,1)|(0,0,0))
        theta(180) = theta(141)+theta(129)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(210) = theta(156)+theta(139)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(261) = theta(210)+theta(180)*AB(1) ! ((2,0,1)|(1,1,0)) = ((3,0,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(1)
        ! (2,0,1|1,0,1): 7
        theta(129) = dot_product(vrrbuffer(:,3), D(:,15)) ! ((2,0,1)|(0,0,0))
        theta(139) = dot_product(vrrbuffer(:,13), D(:,15)) ! ((3,0,1)|(0,0,0))
        theta(142) = dot_product(vrrbuffer(:,16), D(:,15)) ! ((2,0,2)|(0,0,0))
        theta(157) = dot_product(vrrbuffer(:,31), D(:,15)) ! ((3,0,2)|(0,0,0))
        theta(181) = theta(142)+theta(129)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(211) = theta(157)+theta(139)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(262) = theta(211)+theta(181)*AB(1) ! ((2,0,1)|(1,0,1)) = ((3,0,1)|(0,0,1))+((2,0,1)|(0,0,1))*AB(1)
        ! (2,0,1|0,2,0): 6
        theta(129) = dot_product(vrrbuffer(:,3), D(:,16)) ! ((2,0,1)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,16)) ! ((2,1,1)|(0,0,0))
        theta(159) = dot_product(vrrbuffer(:,33), D(:,16)) ! ((2,2,1)|(0,0,0))
        theta(180) = theta(141)+theta(129)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(216) = theta(159)+theta(141)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(263) = theta(216)+theta(180)*AB(2) ! ((2,0,1)|(0,2,0)) = ((2,1,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(2)
        ! (2,0,1|0,1,1): 7
        theta(129) = dot_product(vrrbuffer(:,3), D(:,17)) ! ((2,0,1)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,17)) ! ((2,1,1)|(0,0,0))
        theta(142) = dot_product(vrrbuffer(:,16), D(:,17)) ! ((2,0,2)|(0,0,0))
        theta(160) = dot_product(vrrbuffer(:,34), D(:,17)) ! ((2,1,2)|(0,0,0))
        theta(181) = theta(142)+theta(129)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(217) = theta(160)+theta(141)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(264) = theta(217)+theta(181)*AB(2) ! ((2,0,1)|(0,1,1)) = ((2,1,1)|(0,0,1))+((2,0,1)|(0,0,1))*AB(2)
        ! (2,0,1|0,0,2): 6
        theta(129) = dot_product(vrrbuffer(:,3), D(:,18)) ! ((2,0,1)|(0,0,0))
        theta(142) = dot_product(vrrbuffer(:,16), D(:,18)) ! ((2,0,2)|(0,0,0))
        theta(161) = dot_product(vrrbuffer(:,35), D(:,18)) ! ((2,0,3)|(0,0,0))
        theta(181) = theta(142)+theta(129)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(220) = theta(161)+theta(142)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(265) = theta(220)+theta(181)*AB(3) ! ((2,0,1)|(0,0,2)) = ((2,0,2)|(0,0,1))+((2,0,1)|(0,0,1))*AB(3)
        ! (1,2,0|2,0,0): 6
        theta(130) = dot_product(vrrbuffer(:,4), D(:,19)) ! ((1,2,0)|(0,0,0))
        theta(140) = dot_product(vrrbuffer(:,14), D(:,19)) ! ((2,2,0)|(0,0,0))
        theta(155) = dot_product(vrrbuffer(:,29), D(:,19)) ! ((3,2,0)|(0,0,0))
        theta(182) = theta(140)+theta(130)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(212) = theta(155)+theta(140)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(266) = theta(212)+theta(182)*AB(1) ! ((1,2,0)|(2,0,0)) = ((2,2,0)|(1,0,0))+((1,2,0)|(1,0,0))*AB(1)
        ! (1,2,0|1,1,0): 7
        theta(130) = dot_product(vrrbuffer(:,4), D(:,20)) ! ((1,2,0)|(0,0,0))
        theta(140) = dot_product(vrrbuffer(:,14), D(:,20)) ! ((2,2,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,20)) ! ((1,3,0)|(0,0,0))
        theta(158) = dot_product(vrrbuffer(:,32), D(:,20)) ! ((2,3,0)|(0,0,0))
        theta(183) = theta(143)+theta(130)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(213) = theta(158)+theta(140)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(267) = theta(213)+theta(183)*AB(1) ! ((1,2,0)|(1,1,0)) = ((2,2,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(1)
        ! (1,2,0|1,0,1): 7
        theta(130) = dot_product(vrrbuffer(:,4), D(:,21)) ! ((1,2,0)|(0,0,0))
        theta(140) = dot_product(vrrbuffer(:,14), D(:,21)) ! ((2,2,0)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,21)) ! ((1,2,1)|(0,0,0))
        theta(159) = dot_product(vrrbuffer(:,33), D(:,21)) ! ((2,2,1)|(0,0,0))
        theta(184) = theta(144)+theta(130)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(214) = theta(159)+theta(140)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(268) = theta(214)+theta(184)*AB(1) ! ((1,2,0)|(1,0,1)) = ((2,2,0)|(0,0,1))+((1,2,0)|(0,0,1))*AB(1)
        ! (1,2,0|0,2,0): 6
        theta(130) = dot_product(vrrbuffer(:,4), D(:,22)) ! ((1,2,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,22)) ! ((1,3,0)|(0,0,0))
        theta(162) = dot_product(vrrbuffer(:,36), D(:,22)) ! ((1,4,0)|(0,0,0))
        theta(183) = theta(143)+theta(130)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(222) = theta(162)+theta(143)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(269) = theta(222)+theta(183)*AB(2) ! ((1,2,0)|(0,2,0)) = ((1,3,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(2)
        ! (1,2,0|0,1,1): 7
        theta(130) = dot_product(vrrbuffer(:,4), D(:,23)) ! ((1,2,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,23)) ! ((1,3,0)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,23)) ! ((1,2,1)|(0,0,0))
        theta(163) = dot_product(vrrbuffer(:,37), D(:,23)) ! ((1,3,1)|(0,0,0))
        theta(184) = theta(144)+theta(130)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(223) = theta(163)+theta(143)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(270) = theta(223)+theta(184)*AB(2) ! ((1,2,0)|(0,1,1)) = ((1,3,0)|(0,0,1))+((1,2,0)|(0,0,1))*AB(2)
        ! (1,2,0|0,0,2): 6
        theta(130) = dot_product(vrrbuffer(:,4), D(:,24)) ! ((1,2,0)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,24)) ! ((1,2,1)|(0,0,0))
        theta(164) = dot_product(vrrbuffer(:,38), D(:,24)) ! ((1,2,2)|(0,0,0))
        theta(184) = theta(144)+theta(130)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(226) = theta(164)+theta(144)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(271) = theta(226)+theta(184)*AB(3) ! ((1,2,0)|(0,0,2)) = ((1,2,1)|(0,0,1))+((1,2,0)|(0,0,1))*AB(3)
        ! (1,1,1|2,0,0): 6
        theta(131) = dot_product(vrrbuffer(:,5), D(:,25)) ! ((1,1,1)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,25)) ! ((2,1,1)|(0,0,0))
        theta(156) = dot_product(vrrbuffer(:,30), D(:,25)) ! ((3,1,1)|(0,0,0))
        theta(185) = theta(141)+theta(131)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(215) = theta(156)+theta(141)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(272) = theta(215)+theta(185)*AB(1) ! ((1,1,1)|(2,0,0)) = ((2,1,1)|(1,0,0))+((1,1,1)|(1,0,0))*AB(1)
        ! (1,1,1|1,1,0): 7
        theta(131) = dot_product(vrrbuffer(:,5), D(:,26)) ! ((1,1,1)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,26)) ! ((2,1,1)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,26)) ! ((1,2,1)|(0,0,0))
        theta(159) = dot_product(vrrbuffer(:,33), D(:,26)) ! ((2,2,1)|(0,0,0))
        theta(186) = theta(144)+theta(131)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(216) = theta(159)+theta(141)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(273) = theta(216)+theta(186)*AB(1) ! ((1,1,1)|(1,1,0)) = ((2,1,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(1)
        ! (1,1,1|1,0,1): 7
        theta(131) = dot_product(vrrbuffer(:,5), D(:,27)) ! ((1,1,1)|(0,0,0))
        theta(141) = dot_product(vrrbuffer(:,15), D(:,27)) ! ((2,1,1)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,27)) ! ((1,1,2)|(0,0,0))
        theta(160) = dot_product(vrrbuffer(:,34), D(:,27)) ! ((2,1,2)|(0,0,0))
        theta(187) = theta(145)+theta(131)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(217) = theta(160)+theta(141)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(274) = theta(217)+theta(187)*AB(1) ! ((1,1,1)|(1,0,1)) = ((2,1,1)|(0,0,1))+((1,1,1)|(0,0,1))*AB(1)
        ! (1,1,1|0,2,0): 6
        theta(131) = dot_product(vrrbuffer(:,5), D(:,28)) ! ((1,1,1)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,28)) ! ((1,2,1)|(0,0,0))
        theta(163) = dot_product(vrrbuffer(:,37), D(:,28)) ! ((1,3,1)|(0,0,0))
        theta(186) = theta(144)+theta(131)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(225) = theta(163)+theta(144)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(275) = theta(225)+theta(186)*AB(2) ! ((1,1,1)|(0,2,0)) = ((1,2,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(2)
        ! (1,1,1|0,1,1): 7
        theta(131) = dot_product(vrrbuffer(:,5), D(:,29)) ! ((1,1,1)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,29)) ! ((1,2,1)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,29)) ! ((1,1,2)|(0,0,0))
        theta(164) = dot_product(vrrbuffer(:,38), D(:,29)) ! ((1,2,2)|(0,0,0))
        theta(187) = theta(145)+theta(131)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(226) = theta(164)+theta(144)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(276) = theta(226)+theta(187)*AB(2) ! ((1,1,1)|(0,1,1)) = ((1,2,1)|(0,0,1))+((1,1,1)|(0,0,1))*AB(2)
        ! (1,1,1|0,0,2): 6
        theta(131) = dot_product(vrrbuffer(:,5), D(:,30)) ! ((1,1,1)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,30)) ! ((1,1,2)|(0,0,0))
        theta(165) = dot_product(vrrbuffer(:,39), D(:,30)) ! ((1,1,3)|(0,0,0))
        theta(187) = theta(145)+theta(131)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(229) = theta(165)+theta(145)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(277) = theta(229)+theta(187)*AB(3) ! ((1,1,1)|(0,0,2)) = ((1,1,2)|(0,0,1))+((1,1,1)|(0,0,1))*AB(3)
        ! (1,0,2|2,0,0): 6
        theta(132) = dot_product(vrrbuffer(:,6), D(:,31)) ! ((1,0,2)|(0,0,0))
        theta(142) = dot_product(vrrbuffer(:,16), D(:,31)) ! ((2,0,2)|(0,0,0))
        theta(157) = dot_product(vrrbuffer(:,31), D(:,31)) ! ((3,0,2)|(0,0,0))
        theta(188) = theta(142)+theta(132)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(218) = theta(157)+theta(142)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(278) = theta(218)+theta(188)*AB(1) ! ((1,0,2)|(2,0,0)) = ((2,0,2)|(1,0,0))+((1,0,2)|(1,0,0))*AB(1)
        ! (1,0,2|1,1,0): 7
        theta(132) = dot_product(vrrbuffer(:,6), D(:,32)) ! ((1,0,2)|(0,0,0))
        theta(142) = dot_product(vrrbuffer(:,16), D(:,32)) ! ((2,0,2)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,32)) ! ((1,1,2)|(0,0,0))
        theta(160) = dot_product(vrrbuffer(:,34), D(:,32)) ! ((2,1,2)|(0,0,0))
        theta(189) = theta(145)+theta(132)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(219) = theta(160)+theta(142)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(279) = theta(219)+theta(189)*AB(1) ! ((1,0,2)|(1,1,0)) = ((2,0,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(1)
        ! (1,0,2|1,0,1): 7
        theta(132) = dot_product(vrrbuffer(:,6), D(:,33)) ! ((1,0,2)|(0,0,0))
        theta(142) = dot_product(vrrbuffer(:,16), D(:,33)) ! ((2,0,2)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,33)) ! ((1,0,3)|(0,0,0))
        theta(161) = dot_product(vrrbuffer(:,35), D(:,33)) ! ((2,0,3)|(0,0,0))
        theta(190) = theta(146)+theta(132)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(220) = theta(161)+theta(142)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(280) = theta(220)+theta(190)*AB(1) ! ((1,0,2)|(1,0,1)) = ((2,0,2)|(0,0,1))+((1,0,2)|(0,0,1))*AB(1)
        ! (1,0,2|0,2,0): 6
        theta(132) = dot_product(vrrbuffer(:,6), D(:,34)) ! ((1,0,2)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,34)) ! ((1,1,2)|(0,0,0))
        theta(164) = dot_product(vrrbuffer(:,38), D(:,34)) ! ((1,2,2)|(0,0,0))
        theta(189) = theta(145)+theta(132)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(228) = theta(164)+theta(145)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(281) = theta(228)+theta(189)*AB(2) ! ((1,0,2)|(0,2,0)) = ((1,1,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(2)
        ! (1,0,2|0,1,1): 7
        theta(132) = dot_product(vrrbuffer(:,6), D(:,35)) ! ((1,0,2)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,35)) ! ((1,1,2)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,35)) ! ((1,0,3)|(0,0,0))
        theta(165) = dot_product(vrrbuffer(:,39), D(:,35)) ! ((1,1,3)|(0,0,0))
        theta(190) = theta(146)+theta(132)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(229) = theta(165)+theta(145)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(282) = theta(229)+theta(190)*AB(2) ! ((1,0,2)|(0,1,1)) = ((1,1,2)|(0,0,1))+((1,0,2)|(0,0,1))*AB(2)
        ! (1,0,2|0,0,2): 6
        theta(132) = dot_product(vrrbuffer(:,6), D(:,36)) ! ((1,0,2)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,36)) ! ((1,0,3)|(0,0,0))
        theta(166) = dot_product(vrrbuffer(:,40), D(:,36)) ! ((1,0,4)|(0,0,0))
        theta(190) = theta(146)+theta(132)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(232) = theta(166)+theta(146)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(283) = theta(232)+theta(190)*AB(3) ! ((1,0,2)|(0,0,2)) = ((1,0,3)|(0,0,1))+((1,0,2)|(0,0,1))*AB(3)
        ! (0,3,0|2,0,0): 6
        theta(133) = dot_product(vrrbuffer(:,7), D(:,37)) ! ((0,3,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,37)) ! ((1,3,0)|(0,0,0))
        theta(158) = dot_product(vrrbuffer(:,32), D(:,37)) ! ((2,3,0)|(0,0,0))
        theta(191) = theta(143)+theta(133)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(221) = theta(158)+theta(143)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(284) = theta(221)+theta(191)*AB(1) ! ((0,3,0)|(2,0,0)) = ((1,3,0)|(1,0,0))+((0,3,0)|(1,0,0))*AB(1)
        ! (0,3,0|1,1,0): 7
        theta(133) = dot_product(vrrbuffer(:,7), D(:,38)) ! ((0,3,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,38)) ! ((1,3,0)|(0,0,0))
        theta(147) = dot_product(vrrbuffer(:,21), D(:,38)) ! ((0,4,0)|(0,0,0))
        theta(162) = dot_product(vrrbuffer(:,36), D(:,38)) ! ((1,4,0)|(0,0,0))
        theta(192) = theta(147)+theta(133)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(222) = theta(162)+theta(143)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(285) = theta(222)+theta(192)*AB(1) ! ((0,3,0)|(1,1,0)) = ((1,3,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(1)
        ! (0,3,0|1,0,1): 7
        theta(133) = dot_product(vrrbuffer(:,7), D(:,39)) ! ((0,3,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,39)) ! ((1,3,0)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,39)) ! ((0,3,1)|(0,0,0))
        theta(163) = dot_product(vrrbuffer(:,37), D(:,39)) ! ((1,3,1)|(0,0,0))
        theta(193) = theta(148)+theta(133)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(223) = theta(163)+theta(143)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(286) = theta(223)+theta(193)*AB(1) ! ((0,3,0)|(1,0,1)) = ((1,3,0)|(0,0,1))+((0,3,0)|(0,0,1))*AB(1)
        ! (0,3,0|0,2,0): 6
        theta(133) = dot_product(vrrbuffer(:,7), D(:,40)) ! ((0,3,0)|(0,0,0))
        theta(147) = dot_product(vrrbuffer(:,21), D(:,40)) ! ((0,4,0)|(0,0,0))
        theta(167) = dot_product(vrrbuffer(:,41), D(:,40)) ! ((0,5,0)|(0,0,0))
        theta(192) = theta(147)+theta(133)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(234) = theta(167)+theta(147)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(287) = theta(234)+theta(192)*AB(2) ! ((0,3,0)|(0,2,0)) = ((0,4,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(2)
        ! (0,3,0|0,1,1): 7
        theta(133) = dot_product(vrrbuffer(:,7), D(:,41)) ! ((0,3,0)|(0,0,0))
        theta(147) = dot_product(vrrbuffer(:,21), D(:,41)) ! ((0,4,0)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,41)) ! ((0,3,1)|(0,0,0))
        theta(168) = dot_product(vrrbuffer(:,42), D(:,41)) ! ((0,4,1)|(0,0,0))
        theta(193) = theta(148)+theta(133)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(235) = theta(168)+theta(147)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(288) = theta(235)+theta(193)*AB(2) ! ((0,3,0)|(0,1,1)) = ((0,4,0)|(0,0,1))+((0,3,0)|(0,0,1))*AB(2)
        ! (0,3,0|0,0,2): 6
        theta(133) = dot_product(vrrbuffer(:,7), D(:,42)) ! ((0,3,0)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,42)) ! ((0,3,1)|(0,0,0))
        theta(169) = dot_product(vrrbuffer(:,43), D(:,42)) ! ((0,3,2)|(0,0,0))
        theta(193) = theta(148)+theta(133)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(238) = theta(169)+theta(148)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(289) = theta(238)+theta(193)*AB(3) ! ((0,3,0)|(0,0,2)) = ((0,3,1)|(0,0,1))+((0,3,0)|(0,0,1))*AB(3)
        ! (0,2,1|2,0,0): 6
        theta(134) = dot_product(vrrbuffer(:,8), D(:,43)) ! ((0,2,1)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,43)) ! ((1,2,1)|(0,0,0))
        theta(159) = dot_product(vrrbuffer(:,33), D(:,43)) ! ((2,2,1)|(0,0,0))
        theta(194) = theta(144)+theta(134)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        theta(224) = theta(159)+theta(144)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(290) = theta(224)+theta(194)*AB(1) ! ((0,2,1)|(2,0,0)) = ((1,2,1)|(1,0,0))+((0,2,1)|(1,0,0))*AB(1)
        ! (0,2,1|1,1,0): 7
        theta(134) = dot_product(vrrbuffer(:,8), D(:,44)) ! ((0,2,1)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,44)) ! ((1,2,1)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,44)) ! ((0,3,1)|(0,0,0))
        theta(163) = dot_product(vrrbuffer(:,37), D(:,44)) ! ((1,3,1)|(0,0,0))
        theta(195) = theta(148)+theta(134)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(225) = theta(163)+theta(144)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(291) = theta(225)+theta(195)*AB(1) ! ((0,2,1)|(1,1,0)) = ((1,2,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(1)
        ! (0,2,1|1,0,1): 7
        theta(134) = dot_product(vrrbuffer(:,8), D(:,45)) ! ((0,2,1)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,45)) ! ((1,2,1)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,45)) ! ((0,2,2)|(0,0,0))
        theta(164) = dot_product(vrrbuffer(:,38), D(:,45)) ! ((1,2,2)|(0,0,0))
        theta(196) = theta(149)+theta(134)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(226) = theta(164)+theta(144)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(292) = theta(226)+theta(196)*AB(1) ! ((0,2,1)|(1,0,1)) = ((1,2,1)|(0,0,1))+((0,2,1)|(0,0,1))*AB(1)
        ! (0,2,1|0,2,0): 6
        theta(134) = dot_product(vrrbuffer(:,8), D(:,46)) ! ((0,2,1)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,46)) ! ((0,3,1)|(0,0,0))
        theta(168) = dot_product(vrrbuffer(:,42), D(:,46)) ! ((0,4,1)|(0,0,0))
        theta(195) = theta(148)+theta(134)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(237) = theta(168)+theta(148)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(293) = theta(237)+theta(195)*AB(2) ! ((0,2,1)|(0,2,0)) = ((0,3,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(2)
        ! (0,2,1|0,1,1): 7
        theta(134) = dot_product(vrrbuffer(:,8), D(:,47)) ! ((0,2,1)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,47)) ! ((0,3,1)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,47)) ! ((0,2,2)|(0,0,0))
        theta(169) = dot_product(vrrbuffer(:,43), D(:,47)) ! ((0,3,2)|(0,0,0))
        theta(196) = theta(149)+theta(134)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(238) = theta(169)+theta(148)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(294) = theta(238)+theta(196)*AB(2) ! ((0,2,1)|(0,1,1)) = ((0,3,1)|(0,0,1))+((0,2,1)|(0,0,1))*AB(2)
        ! (0,2,1|0,0,2): 6
        theta(134) = dot_product(vrrbuffer(:,8), D(:,48)) ! ((0,2,1)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,48)) ! ((0,2,2)|(0,0,0))
        theta(170) = dot_product(vrrbuffer(:,44), D(:,48)) ! ((0,2,3)|(0,0,0))
        theta(196) = theta(149)+theta(134)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(241) = theta(170)+theta(149)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(295) = theta(241)+theta(196)*AB(3) ! ((0,2,1)|(0,0,2)) = ((0,2,2)|(0,0,1))+((0,2,1)|(0,0,1))*AB(3)
        ! (0,1,2|2,0,0): 6
        theta(135) = dot_product(vrrbuffer(:,9), D(:,49)) ! ((0,1,2)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,49)) ! ((1,1,2)|(0,0,0))
        theta(160) = dot_product(vrrbuffer(:,34), D(:,49)) ! ((2,1,2)|(0,0,0))
        theta(197) = theta(145)+theta(135)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        theta(227) = theta(160)+theta(145)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(296) = theta(227)+theta(197)*AB(1) ! ((0,1,2)|(2,0,0)) = ((1,1,2)|(1,0,0))+((0,1,2)|(1,0,0))*AB(1)
        ! (0,1,2|1,1,0): 7
        theta(135) = dot_product(vrrbuffer(:,9), D(:,50)) ! ((0,1,2)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,50)) ! ((1,1,2)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,50)) ! ((0,2,2)|(0,0,0))
        theta(164) = dot_product(vrrbuffer(:,38), D(:,50)) ! ((1,2,2)|(0,0,0))
        theta(198) = theta(149)+theta(135)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(228) = theta(164)+theta(145)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(297) = theta(228)+theta(198)*AB(1) ! ((0,1,2)|(1,1,0)) = ((1,1,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(1)
        ! (0,1,2|1,0,1): 7
        theta(135) = dot_product(vrrbuffer(:,9), D(:,51)) ! ((0,1,2)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,51)) ! ((1,1,2)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,51)) ! ((0,1,3)|(0,0,0))
        theta(165) = dot_product(vrrbuffer(:,39), D(:,51)) ! ((1,1,3)|(0,0,0))
        theta(199) = theta(150)+theta(135)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(229) = theta(165)+theta(145)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(298) = theta(229)+theta(199)*AB(1) ! ((0,1,2)|(1,0,1)) = ((1,1,2)|(0,0,1))+((0,1,2)|(0,0,1))*AB(1)
        ! (0,1,2|0,2,0): 6
        theta(135) = dot_product(vrrbuffer(:,9), D(:,52)) ! ((0,1,2)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,52)) ! ((0,2,2)|(0,0,0))
        theta(169) = dot_product(vrrbuffer(:,43), D(:,52)) ! ((0,3,2)|(0,0,0))
        theta(198) = theta(149)+theta(135)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(240) = theta(169)+theta(149)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(299) = theta(240)+theta(198)*AB(2) ! ((0,1,2)|(0,2,0)) = ((0,2,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(2)
        ! (0,1,2|0,1,1): 7
        theta(135) = dot_product(vrrbuffer(:,9), D(:,53)) ! ((0,1,2)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,53)) ! ((0,2,2)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,53)) ! ((0,1,3)|(0,0,0))
        theta(170) = dot_product(vrrbuffer(:,44), D(:,53)) ! ((0,2,3)|(0,0,0))
        theta(199) = theta(150)+theta(135)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(241) = theta(170)+theta(149)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(300) = theta(241)+theta(199)*AB(2) ! ((0,1,2)|(0,1,1)) = ((0,2,2)|(0,0,1))+((0,1,2)|(0,0,1))*AB(2)
        ! (0,1,2|0,0,2): 6
        theta(135) = dot_product(vrrbuffer(:,9), D(:,54)) ! ((0,1,2)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,54)) ! ((0,1,3)|(0,0,0))
        theta(171) = dot_product(vrrbuffer(:,45), D(:,54)) ! ((0,1,4)|(0,0,0))
        theta(199) = theta(150)+theta(135)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(244) = theta(171)+theta(150)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(301) = theta(244)+theta(199)*AB(3) ! ((0,1,2)|(0,0,2)) = ((0,1,3)|(0,0,1))+((0,1,2)|(0,0,1))*AB(3)
        ! (0,0,3|2,0,0): 6
        theta(136) = dot_product(vrrbuffer(:,10), D(:,55)) ! ((0,0,3)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,55)) ! ((1,0,3)|(0,0,0))
        theta(161) = dot_product(vrrbuffer(:,35), D(:,55)) ! ((2,0,3)|(0,0,0))
        theta(200) = theta(146)+theta(136)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        theta(230) = theta(161)+theta(146)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(302) = theta(230)+theta(200)*AB(1) ! ((0,0,3)|(2,0,0)) = ((1,0,3)|(1,0,0))+((0,0,3)|(1,0,0))*AB(1)
        ! (0,0,3|1,1,0): 7
        theta(136) = dot_product(vrrbuffer(:,10), D(:,56)) ! ((0,0,3)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,56)) ! ((1,0,3)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,56)) ! ((0,1,3)|(0,0,0))
        theta(165) = dot_product(vrrbuffer(:,39), D(:,56)) ! ((1,1,3)|(0,0,0))
        theta(201) = theta(150)+theta(136)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(231) = theta(165)+theta(146)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(303) = theta(231)+theta(201)*AB(1) ! ((0,0,3)|(1,1,0)) = ((1,0,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(1)
        ! (0,0,3|1,0,1): 7
        theta(136) = dot_product(vrrbuffer(:,10), D(:,57)) ! ((0,0,3)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,57)) ! ((1,0,3)|(0,0,0))
        theta(151) = dot_product(vrrbuffer(:,25), D(:,57)) ! ((0,0,4)|(0,0,0))
        theta(166) = dot_product(vrrbuffer(:,40), D(:,57)) ! ((1,0,4)|(0,0,0))
        theta(202) = theta(151)+theta(136)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(232) = theta(166)+theta(146)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(304) = theta(232)+theta(202)*AB(1) ! ((0,0,3)|(1,0,1)) = ((1,0,3)|(0,0,1))+((0,0,3)|(0,0,1))*AB(1)
        ! (0,0,3|0,2,0): 6
        theta(136) = dot_product(vrrbuffer(:,10), D(:,58)) ! ((0,0,3)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,58)) ! ((0,1,3)|(0,0,0))
        theta(170) = dot_product(vrrbuffer(:,44), D(:,58)) ! ((0,2,3)|(0,0,0))
        theta(201) = theta(150)+theta(136)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(243) = theta(170)+theta(150)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(305) = theta(243)+theta(201)*AB(2) ! ((0,0,3)|(0,2,0)) = ((0,1,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(2)
        ! (0,0,3|0,1,1): 7
        theta(136) = dot_product(vrrbuffer(:,10), D(:,59)) ! ((0,0,3)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,59)) ! ((0,1,3)|(0,0,0))
        theta(151) = dot_product(vrrbuffer(:,25), D(:,59)) ! ((0,0,4)|(0,0,0))
        theta(171) = dot_product(vrrbuffer(:,45), D(:,59)) ! ((0,1,4)|(0,0,0))
        theta(202) = theta(151)+theta(136)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(244) = theta(171)+theta(150)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(306) = theta(244)+theta(202)*AB(2) ! ((0,0,3)|(0,1,1)) = ((0,1,3)|(0,0,1))+((0,0,3)|(0,0,1))*AB(2)
        ! (0,0,3|0,0,2): 6
        theta(136) = dot_product(vrrbuffer(:,10), D(:,60)) ! ((0,0,3)|(0,0,0))
        theta(151) = dot_product(vrrbuffer(:,25), D(:,60)) ! ((0,0,4)|(0,0,0))
        theta(172) = dot_product(vrrbuffer(:,46), D(:,60)) ! ((0,0,5)|(0,0,0))
        theta(202) = theta(151)+theta(136)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(247) = theta(172)+theta(151)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(307) = theta(247)+theta(202)*AB(3) ! ((0,0,3)|(0,0,2)) = ((0,0,4)|(0,0,1))+((0,0,3)|(0,0,1))*AB(3)
    end subroutine
    subroutine blockhrr_3_3(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 462; Optimized integrals: 408
        ! (3,0,0|3,0,0): 10
        theta(211) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((3,0,0)|(0,0,0))
        theta(221) = dot_product(vrrbuffer(:,11), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(257) = dot_product(vrrbuffer(:,47), D(:,1)) ! ((6,0,0)|(0,0,0))
        theta(285) = theta(221)+theta(211)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(315) = theta(236)+theta(221)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(360) = theta(257)+theta(236)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(423) = theta(315)+theta(285)*AB(1) ! ((3,0,0)|(2,0,0)) = ((4,0,0)|(1,0,0))+((3,0,0)|(1,0,0))*AB(1)
        theta(483) = theta(360)+theta(315)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(573) = theta(483)+theta(423)*AB(1) ! ((3,0,0)|(3,0,0)) = ((4,0,0)|(2,0,0))+((3,0,0)|(2,0,0))*AB(1)
        ! (3,0,0|2,1,0): 13
        theta(211) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((3,0,0)|(0,0,0))
        theta(221) = dot_product(vrrbuffer(:,11), D(:,2)) ! ((4,0,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,2)) ! ((3,1,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,2)) ! ((5,0,0)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,2)) ! ((4,1,0)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,2)) ! ((5,1,0)|(0,0,0))
        theta(285) = theta(221)+theta(211)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(315) = theta(236)+theta(221)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(318) = theta(237)+theta(222)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(363) = theta(258)+theta(237)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(423) = theta(315)+theta(285)*AB(1) ! ((3,0,0)|(2,0,0)) = ((4,0,0)|(1,0,0))+((3,0,0)|(1,0,0))*AB(1)
        theta(489) = theta(363)+theta(318)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(574) = theta(489)+theta(423)*AB(2) ! ((3,0,0)|(2,1,0)) = ((3,1,0)|(2,0,0))+((3,0,0)|(2,0,0))*AB(2)
        ! (3,0,0|2,0,1): 13
        theta(211) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((3,0,0)|(0,0,0))
        theta(221) = dot_product(vrrbuffer(:,11), D(:,3)) ! ((4,0,0)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,3)) ! ((3,0,1)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,3)) ! ((5,0,0)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,3)) ! ((4,0,1)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,3)) ! ((5,0,1)|(0,0,0))
        theta(285) = theta(221)+theta(211)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(315) = theta(236)+theta(221)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(321) = theta(238)+theta(223)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(366) = theta(259)+theta(238)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(423) = theta(315)+theta(285)*AB(1) ! ((3,0,0)|(2,0,0)) = ((4,0,0)|(1,0,0))+((3,0,0)|(1,0,0))*AB(1)
        theta(495) = theta(366)+theta(321)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(575) = theta(495)+theta(423)*AB(3) ! ((3,0,0)|(2,0,1)) = ((3,0,1)|(2,0,0))+((3,0,0)|(2,0,0))*AB(3)
        ! (3,0,0|1,2,0): 13
        theta(211) = dot_product(vrrbuffer(:,1), D(:,4)) ! ((3,0,0)|(0,0,0))
        theta(221) = dot_product(vrrbuffer(:,11), D(:,4)) ! ((4,0,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,4)) ! ((3,1,0)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,4)) ! ((4,1,0)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,4)) ! ((3,2,0)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,4)) ! ((4,2,0)|(0,0,0))
        theta(286) = theta(222)+theta(211)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(316) = theta(237)+theta(221)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(319) = theta(239)+theta(222)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(364) = theta(260)+theta(237)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(426) = theta(319)+theta(286)*AB(2) ! ((3,0,0)|(0,2,0)) = ((3,1,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(2)
        theta(486) = theta(364)+theta(316)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(576) = theta(486)+theta(426)*AB(1) ! ((3,0,0)|(1,2,0)) = ((4,0,0)|(0,2,0))+((3,0,0)|(0,2,0))*AB(1)
        ! (3,0,0|1,1,1): 15
        theta(211) = dot_product(vrrbuffer(:,1), D(:,5)) ! ((3,0,0)|(0,0,0))
        theta(221) = dot_product(vrrbuffer(:,11), D(:,5)) ! ((4,0,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,5)) ! ((3,1,0)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,5)) ! ((3,0,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,5)) ! ((4,1,0)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,5)) ! ((4,0,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,5)) ! ((3,1,1)|(0,0,0))
        theta(261) = dot_product(vrrbuffer(:,51), D(:,5)) ! ((4,1,1)|(0,0,0))
        theta(287) = theta(223)+theta(211)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(317) = theta(238)+theta(221)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(320) = theta(240)+theta(222)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(365) = theta(261)+theta(237)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(427) = theta(320)+theta(287)*AB(2) ! ((3,0,0)|(0,1,1)) = ((3,1,0)|(0,0,1))+((3,0,0)|(0,0,1))*AB(2)
        theta(487) = theta(365)+theta(317)*AB(2) ! ((4,0,0)|(0,1,1)) = ((4,1,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(2)
        theta(577) = theta(487)+theta(427)*AB(1) ! ((3,0,0)|(1,1,1)) = ((4,0,0)|(0,1,1))+((3,0,0)|(0,1,1))*AB(1)
        ! (3,0,0|1,0,2): 13
        theta(211) = dot_product(vrrbuffer(:,1), D(:,6)) ! ((3,0,0)|(0,0,0))
        theta(221) = dot_product(vrrbuffer(:,11), D(:,6)) ! ((4,0,0)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,6)) ! ((3,0,1)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,6)) ! ((4,0,1)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,6)) ! ((3,0,2)|(0,0,0))
        theta(262) = dot_product(vrrbuffer(:,52), D(:,6)) ! ((4,0,2)|(0,0,0))
        theta(287) = theta(223)+theta(211)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(317) = theta(238)+theta(221)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(323) = theta(241)+theta(223)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(368) = theta(262)+theta(238)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(428) = theta(323)+theta(287)*AB(3) ! ((3,0,0)|(0,0,2)) = ((3,0,1)|(0,0,1))+((3,0,0)|(0,0,1))*AB(3)
        theta(488) = theta(368)+theta(317)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(578) = theta(488)+theta(428)*AB(1) ! ((3,0,0)|(1,0,2)) = ((4,0,0)|(0,0,2))+((3,0,0)|(0,0,2))*AB(1)
        ! (3,0,0|0,3,0): 10
        theta(211) = dot_product(vrrbuffer(:,1), D(:,7)) ! ((3,0,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,7)) ! ((3,1,0)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,7)) ! ((3,2,0)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,7)) ! ((3,3,0)|(0,0,0))
        theta(286) = theta(222)+theta(211)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(319) = theta(239)+theta(222)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(370) = theta(263)+theta(239)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(426) = theta(319)+theta(286)*AB(2) ! ((3,0,0)|(0,2,0)) = ((3,1,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(2)
        theta(492) = theta(370)+theta(319)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(579) = theta(492)+theta(426)*AB(2) ! ((3,0,0)|(0,3,0)) = ((3,1,0)|(0,2,0))+((3,0,0)|(0,2,0))*AB(2)
        ! (3,0,0|0,2,1): 13
        theta(211) = dot_product(vrrbuffer(:,1), D(:,8)) ! ((3,0,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,8)) ! ((3,1,0)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,8)) ! ((3,0,1)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,8)) ! ((3,2,0)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,8)) ! ((3,1,1)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,8)) ! ((3,2,1)|(0,0,0))
        theta(286) = theta(222)+theta(211)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(319) = theta(239)+theta(222)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(322) = theta(240)+theta(223)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(373) = theta(264)+theta(240)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(426) = theta(319)+theta(286)*AB(2) ! ((3,0,0)|(0,2,0)) = ((3,1,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(2)
        theta(498) = theta(373)+theta(322)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(580) = theta(498)+theta(426)*AB(3) ! ((3,0,0)|(0,2,1)) = ((3,0,1)|(0,2,0))+((3,0,0)|(0,2,0))*AB(3)
        ! (3,0,0|0,1,2): 13
        theta(211) = dot_product(vrrbuffer(:,1), D(:,9)) ! ((3,0,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,9)) ! ((3,1,0)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,9)) ! ((3,0,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,9)) ! ((3,1,1)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,9)) ! ((3,0,2)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,9)) ! ((3,1,2)|(0,0,0))
        theta(287) = theta(223)+theta(211)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(320) = theta(240)+theta(222)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(323) = theta(241)+theta(223)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(374) = theta(265)+theta(240)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(428) = theta(323)+theta(287)*AB(3) ! ((3,0,0)|(0,0,2)) = ((3,0,1)|(0,0,1))+((3,0,0)|(0,0,1))*AB(3)
        theta(494) = theta(374)+theta(320)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(581) = theta(494)+theta(428)*AB(2) ! ((3,0,0)|(0,1,2)) = ((3,1,0)|(0,0,2))+((3,0,0)|(0,0,2))*AB(2)
        ! (3,0,0|0,0,3): 10
        theta(211) = dot_product(vrrbuffer(:,1), D(:,10)) ! ((3,0,0)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,10)) ! ((3,0,1)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,10)) ! ((3,0,2)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,10)) ! ((3,0,3)|(0,0,0))
        theta(287) = theta(223)+theta(211)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(323) = theta(241)+theta(223)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(377) = theta(266)+theta(241)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(428) = theta(323)+theta(287)*AB(3) ! ((3,0,0)|(0,0,2)) = ((3,0,1)|(0,0,1))+((3,0,0)|(0,0,1))*AB(3)
        theta(500) = theta(377)+theta(323)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(582) = theta(500)+theta(428)*AB(3) ! ((3,0,0)|(0,0,3)) = ((3,0,1)|(0,0,2))+((3,0,0)|(0,0,2))*AB(3)
        ! (2,1,0|3,0,0): 10
        theta(212) = dot_product(vrrbuffer(:,2), D(:,11)) ! ((2,1,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,11)) ! ((3,1,0)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,11)) ! ((4,1,0)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,11)) ! ((5,1,0)|(0,0,0))
        theta(288) = theta(222)+theta(212)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(318) = theta(237)+theta(222)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(363) = theta(258)+theta(237)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(429) = theta(318)+theta(288)*AB(1) ! ((2,1,0)|(2,0,0)) = ((3,1,0)|(1,0,0))+((2,1,0)|(1,0,0))*AB(1)
        theta(489) = theta(363)+theta(318)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(583) = theta(489)+theta(429)*AB(1) ! ((2,1,0)|(3,0,0)) = ((3,1,0)|(2,0,0))+((2,1,0)|(2,0,0))*AB(1)
        ! (2,1,0|2,1,0): 13
        theta(212) = dot_product(vrrbuffer(:,2), D(:,12)) ! ((2,1,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,12)) ! ((3,1,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,12)) ! ((2,2,0)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,12)) ! ((4,1,0)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,12)) ! ((3,2,0)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,12)) ! ((4,2,0)|(0,0,0))
        theta(288) = theta(222)+theta(212)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(318) = theta(237)+theta(222)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(324) = theta(239)+theta(224)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(369) = theta(260)+theta(239)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(429) = theta(318)+theta(288)*AB(1) ! ((2,1,0)|(2,0,0)) = ((3,1,0)|(1,0,0))+((2,1,0)|(1,0,0))*AB(1)
        theta(501) = theta(369)+theta(324)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(584) = theta(501)+theta(429)*AB(2) ! ((2,1,0)|(2,1,0)) = ((2,2,0)|(2,0,0))+((2,1,0)|(2,0,0))*AB(2)
        ! (2,1,0|2,0,1): 13
        theta(212) = dot_product(vrrbuffer(:,2), D(:,13)) ! ((2,1,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,13)) ! ((3,1,0)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,13)) ! ((2,1,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,13)) ! ((4,1,0)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,13)) ! ((3,1,1)|(0,0,0))
        theta(261) = dot_product(vrrbuffer(:,51), D(:,13)) ! ((4,1,1)|(0,0,0))
        theta(288) = theta(222)+theta(212)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(318) = theta(237)+theta(222)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(327) = theta(240)+theta(225)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(372) = theta(261)+theta(240)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(429) = theta(318)+theta(288)*AB(1) ! ((2,1,0)|(2,0,0)) = ((3,1,0)|(1,0,0))+((2,1,0)|(1,0,0))*AB(1)
        theta(507) = theta(372)+theta(327)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(585) = theta(507)+theta(429)*AB(3) ! ((2,1,0)|(2,0,1)) = ((2,1,1)|(2,0,0))+((2,1,0)|(2,0,0))*AB(3)
        ! (2,1,0|1,2,0): 13
        theta(212) = dot_product(vrrbuffer(:,2), D(:,14)) ! ((2,1,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,14)) ! ((3,1,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,14)) ! ((2,2,0)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,14)) ! ((3,2,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,14)) ! ((2,3,0)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,14)) ! ((3,3,0)|(0,0,0))
        theta(289) = theta(224)+theta(212)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(319) = theta(239)+theta(222)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(325) = theta(242)+theta(224)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(370) = theta(263)+theta(239)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(432) = theta(325)+theta(289)*AB(2) ! ((2,1,0)|(0,2,0)) = ((2,2,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(2)
        theta(492) = theta(370)+theta(319)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(586) = theta(492)+theta(432)*AB(1) ! ((2,1,0)|(1,2,0)) = ((3,1,0)|(0,2,0))+((2,1,0)|(0,2,0))*AB(1)
        ! (2,1,0|1,1,1): 15
        theta(212) = dot_product(vrrbuffer(:,2), D(:,15)) ! ((2,1,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,15)) ! ((3,1,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,15)) ! ((2,2,0)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,15)) ! ((2,1,1)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,15)) ! ((3,2,0)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,15)) ! ((3,1,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,15)) ! ((2,2,1)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,15)) ! ((3,2,1)|(0,0,0))
        theta(290) = theta(225)+theta(212)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(320) = theta(240)+theta(222)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(326) = theta(243)+theta(224)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(371) = theta(264)+theta(239)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(433) = theta(326)+theta(290)*AB(2) ! ((2,1,0)|(0,1,1)) = ((2,2,0)|(0,0,1))+((2,1,0)|(0,0,1))*AB(2)
        theta(493) = theta(371)+theta(320)*AB(2) ! ((3,1,0)|(0,1,1)) = ((3,2,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(2)
        theta(587) = theta(493)+theta(433)*AB(1) ! ((2,1,0)|(1,1,1)) = ((3,1,0)|(0,1,1))+((2,1,0)|(0,1,1))*AB(1)
        ! (2,1,0|1,0,2): 13
        theta(212) = dot_product(vrrbuffer(:,2), D(:,16)) ! ((2,1,0)|(0,0,0))
        theta(222) = dot_product(vrrbuffer(:,12), D(:,16)) ! ((3,1,0)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,16)) ! ((2,1,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,16)) ! ((3,1,1)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,16)) ! ((2,1,2)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,16)) ! ((3,1,2)|(0,0,0))
        theta(290) = theta(225)+theta(212)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(320) = theta(240)+theta(222)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(374) = theta(265)+theta(240)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(434) = theta(329)+theta(290)*AB(3) ! ((2,1,0)|(0,0,2)) = ((2,1,1)|(0,0,1))+((2,1,0)|(0,0,1))*AB(3)
        theta(494) = theta(374)+theta(320)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(588) = theta(494)+theta(434)*AB(1) ! ((2,1,0)|(1,0,2)) = ((3,1,0)|(0,0,2))+((2,1,0)|(0,0,2))*AB(1)
        ! (2,1,0|0,3,0): 10
        theta(212) = dot_product(vrrbuffer(:,2), D(:,17)) ! ((2,1,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,17)) ! ((2,2,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,17)) ! ((2,3,0)|(0,0,0))
        theta(267) = dot_product(vrrbuffer(:,57), D(:,17)) ! ((2,4,0)|(0,0,0))
        theta(289) = theta(224)+theta(212)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(325) = theta(242)+theta(224)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(379) = theta(267)+theta(242)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(432) = theta(325)+theta(289)*AB(2) ! ((2,1,0)|(0,2,0)) = ((2,2,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(2)
        theta(504) = theta(379)+theta(325)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(589) = theta(504)+theta(432)*AB(2) ! ((2,1,0)|(0,3,0)) = ((2,2,0)|(0,2,0))+((2,1,0)|(0,2,0))*AB(2)
        ! (2,1,0|0,2,1): 13
        theta(212) = dot_product(vrrbuffer(:,2), D(:,18)) ! ((2,1,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,18)) ! ((2,2,0)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,18)) ! ((2,1,1)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,18)) ! ((2,3,0)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,18)) ! ((2,2,1)|(0,0,0))
        theta(268) = dot_product(vrrbuffer(:,58), D(:,18)) ! ((2,3,1)|(0,0,0))
        theta(289) = theta(224)+theta(212)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(325) = theta(242)+theta(224)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(328) = theta(243)+theta(225)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(382) = theta(268)+theta(243)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(432) = theta(325)+theta(289)*AB(2) ! ((2,1,0)|(0,2,0)) = ((2,2,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(2)
        theta(510) = theta(382)+theta(328)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(590) = theta(510)+theta(432)*AB(3) ! ((2,1,0)|(0,2,1)) = ((2,1,1)|(0,2,0))+((2,1,0)|(0,2,0))*AB(3)
        ! (2,1,0|0,1,2): 13
        theta(212) = dot_product(vrrbuffer(:,2), D(:,19)) ! ((2,1,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,19)) ! ((2,2,0)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,19)) ! ((2,1,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,19)) ! ((2,2,1)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,19)) ! ((2,1,2)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,19)) ! ((2,2,2)|(0,0,0))
        theta(290) = theta(225)+theta(212)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(326) = theta(243)+theta(224)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(383) = theta(269)+theta(243)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(434) = theta(329)+theta(290)*AB(3) ! ((2,1,0)|(0,0,2)) = ((2,1,1)|(0,0,1))+((2,1,0)|(0,0,1))*AB(3)
        theta(506) = theta(383)+theta(326)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(591) = theta(506)+theta(434)*AB(2) ! ((2,1,0)|(0,1,2)) = ((2,2,0)|(0,0,2))+((2,1,0)|(0,0,2))*AB(2)
        ! (2,1,0|0,0,3): 10
        theta(212) = dot_product(vrrbuffer(:,2), D(:,20)) ! ((2,1,0)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,20)) ! ((2,1,1)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,20)) ! ((2,1,2)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,20)) ! ((2,1,3)|(0,0,0))
        theta(290) = theta(225)+theta(212)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(386) = theta(270)+theta(244)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(434) = theta(329)+theta(290)*AB(3) ! ((2,1,0)|(0,0,2)) = ((2,1,1)|(0,0,1))+((2,1,0)|(0,0,1))*AB(3)
        theta(512) = theta(386)+theta(329)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(592) = theta(512)+theta(434)*AB(3) ! ((2,1,0)|(0,0,3)) = ((2,1,1)|(0,0,2))+((2,1,0)|(0,0,2))*AB(3)
        ! (2,0,1|3,0,0): 10
        theta(213) = dot_product(vrrbuffer(:,3), D(:,21)) ! ((2,0,1)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,21)) ! ((3,0,1)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,21)) ! ((4,0,1)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,21)) ! ((5,0,1)|(0,0,0))
        theta(291) = theta(223)+theta(213)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(321) = theta(238)+theta(223)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(366) = theta(259)+theta(238)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(435) = theta(321)+theta(291)*AB(1) ! ((2,0,1)|(2,0,0)) = ((3,0,1)|(1,0,0))+((2,0,1)|(1,0,0))*AB(1)
        theta(495) = theta(366)+theta(321)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(593) = theta(495)+theta(435)*AB(1) ! ((2,0,1)|(3,0,0)) = ((3,0,1)|(2,0,0))+((2,0,1)|(2,0,0))*AB(1)
        ! (2,0,1|2,1,0): 12
        theta(213) = dot_product(vrrbuffer(:,3), D(:,22)) ! ((2,0,1)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,22)) ! ((3,0,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,22)) ! ((2,1,1)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,22)) ! ((4,0,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,22)) ! ((3,1,1)|(0,0,0))
        theta(261) = dot_product(vrrbuffer(:,51), D(:,22)) ! ((4,1,1)|(0,0,0))
        theta(292) = theta(225)+theta(213)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(322) = theta(240)+theta(223)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(367) = theta(261)+theta(238)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(436) = theta(322)+theta(292)*AB(1) ! ((2,0,1)|(1,1,0)) = ((3,0,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(1)
        theta(496) = theta(367)+theta(322)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        theta(594) = theta(496)+theta(436)*AB(1) ! ((2,0,1)|(2,1,0)) = ((3,0,1)|(1,1,0))+((2,0,1)|(1,1,0))*AB(1)
        ! (2,0,1|2,0,1): 13
        theta(213) = dot_product(vrrbuffer(:,3), D(:,23)) ! ((2,0,1)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,23)) ! ((3,0,1)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,23)) ! ((2,0,2)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,23)) ! ((4,0,1)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,23)) ! ((3,0,2)|(0,0,0))
        theta(262) = dot_product(vrrbuffer(:,52), D(:,23)) ! ((4,0,2)|(0,0,0))
        theta(291) = theta(223)+theta(213)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(321) = theta(238)+theta(223)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(330) = theta(241)+theta(226)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(375) = theta(262)+theta(241)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(435) = theta(321)+theta(291)*AB(1) ! ((2,0,1)|(2,0,0)) = ((3,0,1)|(1,0,0))+((2,0,1)|(1,0,0))*AB(1)
        theta(513) = theta(375)+theta(330)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(595) = theta(513)+theta(435)*AB(3) ! ((2,0,1)|(2,0,1)) = ((2,0,2)|(2,0,0))+((2,0,1)|(2,0,0))*AB(3)
        ! (2,0,1|1,2,0): 13
        theta(213) = dot_product(vrrbuffer(:,3), D(:,24)) ! ((2,0,1)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,24)) ! ((3,0,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,24)) ! ((2,1,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,24)) ! ((3,1,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,24)) ! ((2,2,1)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,24)) ! ((3,2,1)|(0,0,0))
        theta(292) = theta(225)+theta(213)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(322) = theta(240)+theta(223)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(328) = theta(243)+theta(225)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(373) = theta(264)+theta(240)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(438) = theta(328)+theta(292)*AB(2) ! ((2,0,1)|(0,2,0)) = ((2,1,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(2)
        theta(498) = theta(373)+theta(322)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(596) = theta(498)+theta(438)*AB(1) ! ((2,0,1)|(1,2,0)) = ((3,0,1)|(0,2,0))+((2,0,1)|(0,2,0))*AB(1)
        ! (2,0,1|1,1,1): 15
        theta(213) = dot_product(vrrbuffer(:,3), D(:,25)) ! ((2,0,1)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,25)) ! ((3,0,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,25)) ! ((2,1,1)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,25)) ! ((2,0,2)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,25)) ! ((3,1,1)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,25)) ! ((3,0,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,25)) ! ((2,1,2)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,25)) ! ((3,1,2)|(0,0,0))
        theta(293) = theta(226)+theta(213)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(323) = theta(241)+theta(223)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(374) = theta(265)+theta(240)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(439) = theta(329)+theta(293)*AB(2) ! ((2,0,1)|(0,1,1)) = ((2,1,1)|(0,0,1))+((2,0,1)|(0,0,1))*AB(2)
        theta(499) = theta(374)+theta(323)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        theta(597) = theta(499)+theta(439)*AB(1) ! ((2,0,1)|(1,1,1)) = ((3,0,1)|(0,1,1))+((2,0,1)|(0,1,1))*AB(1)
        ! (2,0,1|1,0,2): 13
        theta(213) = dot_product(vrrbuffer(:,3), D(:,26)) ! ((2,0,1)|(0,0,0))
        theta(223) = dot_product(vrrbuffer(:,13), D(:,26)) ! ((3,0,1)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,26)) ! ((2,0,2)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,26)) ! ((3,0,2)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,26)) ! ((2,0,3)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,26)) ! ((3,0,3)|(0,0,0))
        theta(293) = theta(226)+theta(213)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(323) = theta(241)+theta(223)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(332) = theta(245)+theta(226)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(377) = theta(266)+theta(241)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(440) = theta(332)+theta(293)*AB(3) ! ((2,0,1)|(0,0,2)) = ((2,0,2)|(0,0,1))+((2,0,1)|(0,0,1))*AB(3)
        theta(500) = theta(377)+theta(323)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(598) = theta(500)+theta(440)*AB(1) ! ((2,0,1)|(1,0,2)) = ((3,0,1)|(0,0,2))+((2,0,1)|(0,0,2))*AB(1)
        ! (2,0,1|0,3,0): 10
        theta(213) = dot_product(vrrbuffer(:,3), D(:,27)) ! ((2,0,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,27)) ! ((2,1,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,27)) ! ((2,2,1)|(0,0,0))
        theta(268) = dot_product(vrrbuffer(:,58), D(:,27)) ! ((2,3,1)|(0,0,0))
        theta(292) = theta(225)+theta(213)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(328) = theta(243)+theta(225)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(382) = theta(268)+theta(243)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(438) = theta(328)+theta(292)*AB(2) ! ((2,0,1)|(0,2,0)) = ((2,1,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(2)
        theta(510) = theta(382)+theta(328)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(599) = theta(510)+theta(438)*AB(2) ! ((2,0,1)|(0,3,0)) = ((2,1,1)|(0,2,0))+((2,0,1)|(0,2,0))*AB(2)
        ! (2,0,1|0,2,1): 13
        theta(213) = dot_product(vrrbuffer(:,3), D(:,28)) ! ((2,0,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,28)) ! ((2,1,1)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,28)) ! ((2,0,2)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,28)) ! ((2,2,1)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,28)) ! ((2,1,2)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,28)) ! ((2,2,2)|(0,0,0))
        theta(292) = theta(225)+theta(213)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(328) = theta(243)+theta(225)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(331) = theta(244)+theta(226)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(385) = theta(269)+theta(244)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(438) = theta(328)+theta(292)*AB(2) ! ((2,0,1)|(0,2,0)) = ((2,1,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(2)
        theta(516) = theta(385)+theta(331)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(600) = theta(516)+theta(438)*AB(3) ! ((2,0,1)|(0,2,1)) = ((2,0,2)|(0,2,0))+((2,0,1)|(0,2,0))*AB(3)
        ! (2,0,1|0,1,2): 13
        theta(213) = dot_product(vrrbuffer(:,3), D(:,29)) ! ((2,0,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,29)) ! ((2,1,1)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,29)) ! ((2,0,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,29)) ! ((2,1,2)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,29)) ! ((2,0,3)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,29)) ! ((2,1,3)|(0,0,0))
        theta(293) = theta(226)+theta(213)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(332) = theta(245)+theta(226)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(386) = theta(270)+theta(244)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(440) = theta(332)+theta(293)*AB(3) ! ((2,0,1)|(0,0,2)) = ((2,0,2)|(0,0,1))+((2,0,1)|(0,0,1))*AB(3)
        theta(512) = theta(386)+theta(329)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(601) = theta(512)+theta(440)*AB(2) ! ((2,0,1)|(0,1,2)) = ((2,1,1)|(0,0,2))+((2,0,1)|(0,0,2))*AB(2)
        ! (2,0,1|0,0,3): 10
        theta(213) = dot_product(vrrbuffer(:,3), D(:,30)) ! ((2,0,1)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,30)) ! ((2,0,2)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,30)) ! ((2,0,3)|(0,0,0))
        theta(271) = dot_product(vrrbuffer(:,61), D(:,30)) ! ((2,0,4)|(0,0,0))
        theta(293) = theta(226)+theta(213)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(332) = theta(245)+theta(226)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(389) = theta(271)+theta(245)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(440) = theta(332)+theta(293)*AB(3) ! ((2,0,1)|(0,0,2)) = ((2,0,2)|(0,0,1))+((2,0,1)|(0,0,1))*AB(3)
        theta(518) = theta(389)+theta(332)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(602) = theta(518)+theta(440)*AB(3) ! ((2,0,1)|(0,0,3)) = ((2,0,2)|(0,0,2))+((2,0,1)|(0,0,2))*AB(3)
        ! (1,2,0|3,0,0): 10
        theta(214) = dot_product(vrrbuffer(:,4), D(:,31)) ! ((1,2,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,31)) ! ((2,2,0)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,31)) ! ((3,2,0)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,31)) ! ((4,2,0)|(0,0,0))
        theta(294) = theta(224)+theta(214)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(324) = theta(239)+theta(224)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(369) = theta(260)+theta(239)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(441) = theta(324)+theta(294)*AB(1) ! ((1,2,0)|(2,0,0)) = ((2,2,0)|(1,0,0))+((1,2,0)|(1,0,0))*AB(1)
        theta(501) = theta(369)+theta(324)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(603) = theta(501)+theta(441)*AB(1) ! ((1,2,0)|(3,0,0)) = ((2,2,0)|(2,0,0))+((1,2,0)|(2,0,0))*AB(1)
        ! (1,2,0|2,1,0): 13
        theta(214) = dot_product(vrrbuffer(:,4), D(:,32)) ! ((1,2,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,32)) ! ((2,2,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,32)) ! ((1,3,0)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,32)) ! ((3,2,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,32)) ! ((2,3,0)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,32)) ! ((3,3,0)|(0,0,0))
        theta(294) = theta(224)+theta(214)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(324) = theta(239)+theta(224)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(333) = theta(242)+theta(227)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(378) = theta(263)+theta(242)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(441) = theta(324)+theta(294)*AB(1) ! ((1,2,0)|(2,0,0)) = ((2,2,0)|(1,0,0))+((1,2,0)|(1,0,0))*AB(1)
        theta(519) = theta(378)+theta(333)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(604) = theta(519)+theta(441)*AB(2) ! ((1,2,0)|(2,1,0)) = ((1,3,0)|(2,0,0))+((1,2,0)|(2,0,0))*AB(2)
        ! (1,2,0|2,0,1): 13
        theta(214) = dot_product(vrrbuffer(:,4), D(:,33)) ! ((1,2,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,33)) ! ((2,2,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,33)) ! ((1,2,1)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,33)) ! ((3,2,0)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,33)) ! ((2,2,1)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,33)) ! ((3,2,1)|(0,0,0))
        theta(294) = theta(224)+theta(214)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(324) = theta(239)+theta(224)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(336) = theta(243)+theta(228)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(381) = theta(264)+theta(243)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(441) = theta(324)+theta(294)*AB(1) ! ((1,2,0)|(2,0,0)) = ((2,2,0)|(1,0,0))+((1,2,0)|(1,0,0))*AB(1)
        theta(525) = theta(381)+theta(336)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(605) = theta(525)+theta(441)*AB(3) ! ((1,2,0)|(2,0,1)) = ((1,2,1)|(2,0,0))+((1,2,0)|(2,0,0))*AB(3)
        ! (1,2,0|1,2,0): 13
        theta(214) = dot_product(vrrbuffer(:,4), D(:,34)) ! ((1,2,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,34)) ! ((2,2,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,34)) ! ((1,3,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,34)) ! ((2,3,0)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,34)) ! ((1,4,0)|(0,0,0))
        theta(267) = dot_product(vrrbuffer(:,57), D(:,34)) ! ((2,4,0)|(0,0,0))
        theta(295) = theta(227)+theta(214)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(325) = theta(242)+theta(224)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(334) = theta(246)+theta(227)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(379) = theta(267)+theta(242)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(444) = theta(334)+theta(295)*AB(2) ! ((1,2,0)|(0,2,0)) = ((1,3,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(2)
        theta(504) = theta(379)+theta(325)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(606) = theta(504)+theta(444)*AB(1) ! ((1,2,0)|(1,2,0)) = ((2,2,0)|(0,2,0))+((1,2,0)|(0,2,0))*AB(1)
        ! (1,2,0|1,1,1): 15
        theta(214) = dot_product(vrrbuffer(:,4), D(:,35)) ! ((1,2,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,35)) ! ((2,2,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,35)) ! ((1,3,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,35)) ! ((1,2,1)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,35)) ! ((2,3,0)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,35)) ! ((2,2,1)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,35)) ! ((1,3,1)|(0,0,0))
        theta(268) = dot_product(vrrbuffer(:,58), D(:,35)) ! ((2,3,1)|(0,0,0))
        theta(296) = theta(228)+theta(214)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(326) = theta(243)+theta(224)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(335) = theta(247)+theta(227)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(380) = theta(268)+theta(242)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(445) = theta(335)+theta(296)*AB(2) ! ((1,2,0)|(0,1,1)) = ((1,3,0)|(0,0,1))+((1,2,0)|(0,0,1))*AB(2)
        theta(505) = theta(380)+theta(326)*AB(2) ! ((2,2,0)|(0,1,1)) = ((2,3,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(2)
        theta(607) = theta(505)+theta(445)*AB(1) ! ((1,2,0)|(1,1,1)) = ((2,2,0)|(0,1,1))+((1,2,0)|(0,1,1))*AB(1)
        ! (1,2,0|1,0,2): 13
        theta(214) = dot_product(vrrbuffer(:,4), D(:,36)) ! ((1,2,0)|(0,0,0))
        theta(224) = dot_product(vrrbuffer(:,14), D(:,36)) ! ((2,2,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,36)) ! ((1,2,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,36)) ! ((2,2,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,36)) ! ((1,2,2)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,36)) ! ((2,2,2)|(0,0,0))
        theta(296) = theta(228)+theta(214)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(326) = theta(243)+theta(224)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(383) = theta(269)+theta(243)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(446) = theta(338)+theta(296)*AB(3) ! ((1,2,0)|(0,0,2)) = ((1,2,1)|(0,0,1))+((1,2,0)|(0,0,1))*AB(3)
        theta(506) = theta(383)+theta(326)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(608) = theta(506)+theta(446)*AB(1) ! ((1,2,0)|(1,0,2)) = ((2,2,0)|(0,0,2))+((1,2,0)|(0,0,2))*AB(1)
        ! (1,2,0|0,3,0): 10
        theta(214) = dot_product(vrrbuffer(:,4), D(:,37)) ! ((1,2,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,37)) ! ((1,3,0)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,37)) ! ((1,4,0)|(0,0,0))
        theta(272) = dot_product(vrrbuffer(:,62), D(:,37)) ! ((1,5,0)|(0,0,0))
        theta(295) = theta(227)+theta(214)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(334) = theta(246)+theta(227)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(391) = theta(272)+theta(246)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(444) = theta(334)+theta(295)*AB(2) ! ((1,2,0)|(0,2,0)) = ((1,3,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(2)
        theta(522) = theta(391)+theta(334)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(609) = theta(522)+theta(444)*AB(2) ! ((1,2,0)|(0,3,0)) = ((1,3,0)|(0,2,0))+((1,2,0)|(0,2,0))*AB(2)
        ! (1,2,0|0,2,1): 13
        theta(214) = dot_product(vrrbuffer(:,4), D(:,38)) ! ((1,2,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,38)) ! ((1,3,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,38)) ! ((1,2,1)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,38)) ! ((1,4,0)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,38)) ! ((1,3,1)|(0,0,0))
        theta(273) = dot_product(vrrbuffer(:,63), D(:,38)) ! ((1,4,1)|(0,0,0))
        theta(295) = theta(227)+theta(214)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(334) = theta(246)+theta(227)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(337) = theta(247)+theta(228)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(394) = theta(273)+theta(247)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(444) = theta(334)+theta(295)*AB(2) ! ((1,2,0)|(0,2,0)) = ((1,3,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(2)
        theta(528) = theta(394)+theta(337)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(610) = theta(528)+theta(444)*AB(3) ! ((1,2,0)|(0,2,1)) = ((1,2,1)|(0,2,0))+((1,2,0)|(0,2,0))*AB(3)
        ! (1,2,0|0,1,2): 13
        theta(214) = dot_product(vrrbuffer(:,4), D(:,39)) ! ((1,2,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,39)) ! ((1,3,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,39)) ! ((1,2,1)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,39)) ! ((1,3,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,39)) ! ((1,2,2)|(0,0,0))
        theta(274) = dot_product(vrrbuffer(:,64), D(:,39)) ! ((1,3,2)|(0,0,0))
        theta(296) = theta(228)+theta(214)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(335) = theta(247)+theta(227)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(395) = theta(274)+theta(247)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(446) = theta(338)+theta(296)*AB(3) ! ((1,2,0)|(0,0,2)) = ((1,2,1)|(0,0,1))+((1,2,0)|(0,0,1))*AB(3)
        theta(524) = theta(395)+theta(335)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(611) = theta(524)+theta(446)*AB(2) ! ((1,2,0)|(0,1,2)) = ((1,3,0)|(0,0,2))+((1,2,0)|(0,0,2))*AB(2)
        ! (1,2,0|0,0,3): 10
        theta(214) = dot_product(vrrbuffer(:,4), D(:,40)) ! ((1,2,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,40)) ! ((1,2,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,40)) ! ((1,2,2)|(0,0,0))
        theta(275) = dot_product(vrrbuffer(:,65), D(:,40)) ! ((1,2,3)|(0,0,0))
        theta(296) = theta(228)+theta(214)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(398) = theta(275)+theta(248)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(446) = theta(338)+theta(296)*AB(3) ! ((1,2,0)|(0,0,2)) = ((1,2,1)|(0,0,1))+((1,2,0)|(0,0,1))*AB(3)
        theta(530) = theta(398)+theta(338)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(612) = theta(530)+theta(446)*AB(3) ! ((1,2,0)|(0,0,3)) = ((1,2,1)|(0,0,2))+((1,2,0)|(0,0,2))*AB(3)
        ! (1,1,1|3,0,0): 10
        theta(215) = dot_product(vrrbuffer(:,5), D(:,41)) ! ((1,1,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,41)) ! ((2,1,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,41)) ! ((3,1,1)|(0,0,0))
        theta(261) = dot_product(vrrbuffer(:,51), D(:,41)) ! ((4,1,1)|(0,0,0))
        theta(297) = theta(225)+theta(215)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(327) = theta(240)+theta(225)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(372) = theta(261)+theta(240)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(447) = theta(327)+theta(297)*AB(1) ! ((1,1,1)|(2,0,0)) = ((2,1,1)|(1,0,0))+((1,1,1)|(1,0,0))*AB(1)
        theta(507) = theta(372)+theta(327)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(613) = theta(507)+theta(447)*AB(1) ! ((1,1,1)|(3,0,0)) = ((2,1,1)|(2,0,0))+((1,1,1)|(2,0,0))*AB(1)
        ! (1,1,1|2,1,0): 12
        theta(215) = dot_product(vrrbuffer(:,5), D(:,42)) ! ((1,1,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,42)) ! ((2,1,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,42)) ! ((1,2,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,42)) ! ((3,1,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,42)) ! ((2,2,1)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,42)) ! ((3,2,1)|(0,0,0))
        theta(298) = theta(228)+theta(215)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(328) = theta(243)+theta(225)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(373) = theta(264)+theta(240)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(448) = theta(328)+theta(298)*AB(1) ! ((1,1,1)|(1,1,0)) = ((2,1,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(1)
        theta(508) = theta(373)+theta(328)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        theta(614) = theta(508)+theta(448)*AB(1) ! ((1,1,1)|(2,1,0)) = ((2,1,1)|(1,1,0))+((1,1,1)|(1,1,0))*AB(1)
        ! (1,1,1|2,0,1): 13
        theta(215) = dot_product(vrrbuffer(:,5), D(:,43)) ! ((1,1,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,43)) ! ((2,1,1)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,43)) ! ((1,1,2)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,43)) ! ((3,1,1)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,43)) ! ((2,1,2)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,43)) ! ((3,1,2)|(0,0,0))
        theta(297) = theta(225)+theta(215)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(327) = theta(240)+theta(225)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(339) = theta(244)+theta(229)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(384) = theta(265)+theta(244)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(447) = theta(327)+theta(297)*AB(1) ! ((1,1,1)|(2,0,0)) = ((2,1,1)|(1,0,0))+((1,1,1)|(1,0,0))*AB(1)
        theta(531) = theta(384)+theta(339)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(615) = theta(531)+theta(447)*AB(3) ! ((1,1,1)|(2,0,1)) = ((1,1,2)|(2,0,0))+((1,1,1)|(2,0,0))*AB(3)
        ! (1,1,1|1,2,0): 13
        theta(215) = dot_product(vrrbuffer(:,5), D(:,44)) ! ((1,1,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,44)) ! ((2,1,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,44)) ! ((1,2,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,44)) ! ((2,2,1)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,44)) ! ((1,3,1)|(0,0,0))
        theta(268) = dot_product(vrrbuffer(:,58), D(:,44)) ! ((2,3,1)|(0,0,0))
        theta(298) = theta(228)+theta(215)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(328) = theta(243)+theta(225)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(337) = theta(247)+theta(228)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(382) = theta(268)+theta(243)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(450) = theta(337)+theta(298)*AB(2) ! ((1,1,1)|(0,2,0)) = ((1,2,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(2)
        theta(510) = theta(382)+theta(328)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(616) = theta(510)+theta(450)*AB(1) ! ((1,1,1)|(1,2,0)) = ((2,1,1)|(0,2,0))+((1,1,1)|(0,2,0))*AB(1)
        ! (1,1,1|1,1,1): 15
        theta(215) = dot_product(vrrbuffer(:,5), D(:,45)) ! ((1,1,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,45)) ! ((2,1,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,45)) ! ((1,2,1)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,45)) ! ((1,1,2)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,45)) ! ((2,2,1)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,45)) ! ((2,1,2)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,45)) ! ((1,2,2)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,45)) ! ((2,2,2)|(0,0,0))
        theta(299) = theta(229)+theta(215)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(383) = theta(269)+theta(243)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(451) = theta(338)+theta(299)*AB(2) ! ((1,1,1)|(0,1,1)) = ((1,2,1)|(0,0,1))+((1,1,1)|(0,0,1))*AB(2)
        theta(511) = theta(383)+theta(329)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        theta(617) = theta(511)+theta(451)*AB(1) ! ((1,1,1)|(1,1,1)) = ((2,1,1)|(0,1,1))+((1,1,1)|(0,1,1))*AB(1)
        ! (1,1,1|1,0,2): 13
        theta(215) = dot_product(vrrbuffer(:,5), D(:,46)) ! ((1,1,1)|(0,0,0))
        theta(225) = dot_product(vrrbuffer(:,15), D(:,46)) ! ((2,1,1)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,46)) ! ((1,1,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,46)) ! ((2,1,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,46)) ! ((1,1,3)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,46)) ! ((2,1,3)|(0,0,0))
        theta(299) = theta(229)+theta(215)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(386) = theta(270)+theta(244)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(452) = theta(341)+theta(299)*AB(3) ! ((1,1,1)|(0,0,2)) = ((1,1,2)|(0,0,1))+((1,1,1)|(0,0,1))*AB(3)
        theta(512) = theta(386)+theta(329)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(618) = theta(512)+theta(452)*AB(1) ! ((1,1,1)|(1,0,2)) = ((2,1,1)|(0,0,2))+((1,1,1)|(0,0,2))*AB(1)
        ! (1,1,1|0,3,0): 10
        theta(215) = dot_product(vrrbuffer(:,5), D(:,47)) ! ((1,1,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,47)) ! ((1,2,1)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,47)) ! ((1,3,1)|(0,0,0))
        theta(273) = dot_product(vrrbuffer(:,63), D(:,47)) ! ((1,4,1)|(0,0,0))
        theta(298) = theta(228)+theta(215)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(337) = theta(247)+theta(228)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(394) = theta(273)+theta(247)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(450) = theta(337)+theta(298)*AB(2) ! ((1,1,1)|(0,2,0)) = ((1,2,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(2)
        theta(528) = theta(394)+theta(337)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(619) = theta(528)+theta(450)*AB(2) ! ((1,1,1)|(0,3,0)) = ((1,2,1)|(0,2,0))+((1,1,1)|(0,2,0))*AB(2)
        ! (1,1,1|0,2,1): 13
        theta(215) = dot_product(vrrbuffer(:,5), D(:,48)) ! ((1,1,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,48)) ! ((1,2,1)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,48)) ! ((1,1,2)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,48)) ! ((1,3,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,48)) ! ((1,2,2)|(0,0,0))
        theta(274) = dot_product(vrrbuffer(:,64), D(:,48)) ! ((1,3,2)|(0,0,0))
        theta(298) = theta(228)+theta(215)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(337) = theta(247)+theta(228)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(340) = theta(248)+theta(229)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(397) = theta(274)+theta(248)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(450) = theta(337)+theta(298)*AB(2) ! ((1,1,1)|(0,2,0)) = ((1,2,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(2)
        theta(534) = theta(397)+theta(340)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(620) = theta(534)+theta(450)*AB(3) ! ((1,1,1)|(0,2,1)) = ((1,1,2)|(0,2,0))+((1,1,1)|(0,2,0))*AB(3)
        ! (1,1,1|0,1,2): 13
        theta(215) = dot_product(vrrbuffer(:,5), D(:,49)) ! ((1,1,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,49)) ! ((1,2,1)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,49)) ! ((1,1,2)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,49)) ! ((1,2,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,49)) ! ((1,1,3)|(0,0,0))
        theta(275) = dot_product(vrrbuffer(:,65), D(:,49)) ! ((1,2,3)|(0,0,0))
        theta(299) = theta(229)+theta(215)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(398) = theta(275)+theta(248)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(452) = theta(341)+theta(299)*AB(3) ! ((1,1,1)|(0,0,2)) = ((1,1,2)|(0,0,1))+((1,1,1)|(0,0,1))*AB(3)
        theta(530) = theta(398)+theta(338)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(621) = theta(530)+theta(452)*AB(2) ! ((1,1,1)|(0,1,2)) = ((1,2,1)|(0,0,2))+((1,1,1)|(0,0,2))*AB(2)
        ! (1,1,1|0,0,3): 10
        theta(215) = dot_product(vrrbuffer(:,5), D(:,50)) ! ((1,1,1)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,50)) ! ((1,1,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,50)) ! ((1,1,3)|(0,0,0))
        theta(276) = dot_product(vrrbuffer(:,66), D(:,50)) ! ((1,1,4)|(0,0,0))
        theta(299) = theta(229)+theta(215)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(401) = theta(276)+theta(249)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(452) = theta(341)+theta(299)*AB(3) ! ((1,1,1)|(0,0,2)) = ((1,1,2)|(0,0,1))+((1,1,1)|(0,0,1))*AB(3)
        theta(536) = theta(401)+theta(341)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(622) = theta(536)+theta(452)*AB(3) ! ((1,1,1)|(0,0,3)) = ((1,1,2)|(0,0,2))+((1,1,1)|(0,0,2))*AB(3)
        ! (1,0,2|3,0,0): 10
        theta(216) = dot_product(vrrbuffer(:,6), D(:,51)) ! ((1,0,2)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,51)) ! ((2,0,2)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,51)) ! ((3,0,2)|(0,0,0))
        theta(262) = dot_product(vrrbuffer(:,52), D(:,51)) ! ((4,0,2)|(0,0,0))
        theta(300) = theta(226)+theta(216)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(330) = theta(241)+theta(226)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(375) = theta(262)+theta(241)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(453) = theta(330)+theta(300)*AB(1) ! ((1,0,2)|(2,0,0)) = ((2,0,2)|(1,0,0))+((1,0,2)|(1,0,0))*AB(1)
        theta(513) = theta(375)+theta(330)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(623) = theta(513)+theta(453)*AB(1) ! ((1,0,2)|(3,0,0)) = ((2,0,2)|(2,0,0))+((1,0,2)|(2,0,0))*AB(1)
        ! (1,0,2|2,1,0): 12
        theta(216) = dot_product(vrrbuffer(:,6), D(:,52)) ! ((1,0,2)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,52)) ! ((2,0,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,52)) ! ((1,1,2)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,52)) ! ((3,0,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,52)) ! ((2,1,2)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,52)) ! ((3,1,2)|(0,0,0))
        theta(301) = theta(229)+theta(216)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(331) = theta(244)+theta(226)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(376) = theta(265)+theta(241)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(454) = theta(331)+theta(301)*AB(1) ! ((1,0,2)|(1,1,0)) = ((2,0,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(1)
        theta(514) = theta(376)+theta(331)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        theta(624) = theta(514)+theta(454)*AB(1) ! ((1,0,2)|(2,1,0)) = ((2,0,2)|(1,1,0))+((1,0,2)|(1,1,0))*AB(1)
        ! (1,0,2|2,0,1): 13
        theta(216) = dot_product(vrrbuffer(:,6), D(:,53)) ! ((1,0,2)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,53)) ! ((2,0,2)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,53)) ! ((1,0,3)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,53)) ! ((3,0,2)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,53)) ! ((2,0,3)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,53)) ! ((3,0,3)|(0,0,0))
        theta(300) = theta(226)+theta(216)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(330) = theta(241)+theta(226)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(342) = theta(245)+theta(230)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(387) = theta(266)+theta(245)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(453) = theta(330)+theta(300)*AB(1) ! ((1,0,2)|(2,0,0)) = ((2,0,2)|(1,0,0))+((1,0,2)|(1,0,0))*AB(1)
        theta(537) = theta(387)+theta(342)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(625) = theta(537)+theta(453)*AB(3) ! ((1,0,2)|(2,0,1)) = ((1,0,3)|(2,0,0))+((1,0,2)|(2,0,0))*AB(3)
        ! (1,0,2|1,2,0): 13
        theta(216) = dot_product(vrrbuffer(:,6), D(:,54)) ! ((1,0,2)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,54)) ! ((2,0,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,54)) ! ((1,1,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,54)) ! ((2,1,2)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,54)) ! ((1,2,2)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,54)) ! ((2,2,2)|(0,0,0))
        theta(301) = theta(229)+theta(216)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(331) = theta(244)+theta(226)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(340) = theta(248)+theta(229)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(385) = theta(269)+theta(244)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(456) = theta(340)+theta(301)*AB(2) ! ((1,0,2)|(0,2,0)) = ((1,1,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(2)
        theta(516) = theta(385)+theta(331)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(626) = theta(516)+theta(456)*AB(1) ! ((1,0,2)|(1,2,0)) = ((2,0,2)|(0,2,0))+((1,0,2)|(0,2,0))*AB(1)
        ! (1,0,2|1,1,1): 15
        theta(216) = dot_product(vrrbuffer(:,6), D(:,55)) ! ((1,0,2)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,55)) ! ((2,0,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,55)) ! ((1,1,2)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,55)) ! ((1,0,3)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,55)) ! ((2,1,2)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,55)) ! ((2,0,3)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,55)) ! ((1,1,3)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,55)) ! ((2,1,3)|(0,0,0))
        theta(302) = theta(230)+theta(216)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(332) = theta(245)+theta(226)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(386) = theta(270)+theta(244)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(457) = theta(341)+theta(302)*AB(2) ! ((1,0,2)|(0,1,1)) = ((1,1,2)|(0,0,1))+((1,0,2)|(0,0,1))*AB(2)
        theta(517) = theta(386)+theta(332)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        theta(627) = theta(517)+theta(457)*AB(1) ! ((1,0,2)|(1,1,1)) = ((2,0,2)|(0,1,1))+((1,0,2)|(0,1,1))*AB(1)
        ! (1,0,2|1,0,2): 13
        theta(216) = dot_product(vrrbuffer(:,6), D(:,56)) ! ((1,0,2)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,56)) ! ((2,0,2)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,56)) ! ((1,0,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,56)) ! ((2,0,3)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,56)) ! ((1,0,4)|(0,0,0))
        theta(271) = dot_product(vrrbuffer(:,61), D(:,56)) ! ((2,0,4)|(0,0,0))
        theta(302) = theta(230)+theta(216)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(332) = theta(245)+theta(226)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(344) = theta(250)+theta(230)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(389) = theta(271)+theta(245)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(458) = theta(344)+theta(302)*AB(3) ! ((1,0,2)|(0,0,2)) = ((1,0,3)|(0,0,1))+((1,0,2)|(0,0,1))*AB(3)
        theta(518) = theta(389)+theta(332)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(628) = theta(518)+theta(458)*AB(1) ! ((1,0,2)|(1,0,2)) = ((2,0,2)|(0,0,2))+((1,0,2)|(0,0,2))*AB(1)
        ! (1,0,2|0,3,0): 10
        theta(216) = dot_product(vrrbuffer(:,6), D(:,57)) ! ((1,0,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,57)) ! ((1,1,2)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,57)) ! ((1,2,2)|(0,0,0))
        theta(274) = dot_product(vrrbuffer(:,64), D(:,57)) ! ((1,3,2)|(0,0,0))
        theta(301) = theta(229)+theta(216)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(340) = theta(248)+theta(229)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(397) = theta(274)+theta(248)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(456) = theta(340)+theta(301)*AB(2) ! ((1,0,2)|(0,2,0)) = ((1,1,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(2)
        theta(534) = theta(397)+theta(340)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(629) = theta(534)+theta(456)*AB(2) ! ((1,0,2)|(0,3,0)) = ((1,1,2)|(0,2,0))+((1,0,2)|(0,2,0))*AB(2)
        ! (1,0,2|0,2,1): 13
        theta(216) = dot_product(vrrbuffer(:,6), D(:,58)) ! ((1,0,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,58)) ! ((1,1,2)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,58)) ! ((1,0,3)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,58)) ! ((1,2,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,58)) ! ((1,1,3)|(0,0,0))
        theta(275) = dot_product(vrrbuffer(:,65), D(:,58)) ! ((1,2,3)|(0,0,0))
        theta(301) = theta(229)+theta(216)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(340) = theta(248)+theta(229)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(343) = theta(249)+theta(230)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(400) = theta(275)+theta(249)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(456) = theta(340)+theta(301)*AB(2) ! ((1,0,2)|(0,2,0)) = ((1,1,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(2)
        theta(540) = theta(400)+theta(343)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(630) = theta(540)+theta(456)*AB(3) ! ((1,0,2)|(0,2,1)) = ((1,0,3)|(0,2,0))+((1,0,2)|(0,2,0))*AB(3)
        ! (1,0,2|0,1,2): 13
        theta(216) = dot_product(vrrbuffer(:,6), D(:,59)) ! ((1,0,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,59)) ! ((1,1,2)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,59)) ! ((1,0,3)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,59)) ! ((1,1,3)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,59)) ! ((1,0,4)|(0,0,0))
        theta(276) = dot_product(vrrbuffer(:,66), D(:,59)) ! ((1,1,4)|(0,0,0))
        theta(302) = theta(230)+theta(216)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(344) = theta(250)+theta(230)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(401) = theta(276)+theta(249)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(458) = theta(344)+theta(302)*AB(3) ! ((1,0,2)|(0,0,2)) = ((1,0,3)|(0,0,1))+((1,0,2)|(0,0,1))*AB(3)
        theta(536) = theta(401)+theta(341)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(631) = theta(536)+theta(458)*AB(2) ! ((1,0,2)|(0,1,2)) = ((1,1,2)|(0,0,2))+((1,0,2)|(0,0,2))*AB(2)
        ! (1,0,2|0,0,3): 10
        theta(216) = dot_product(vrrbuffer(:,6), D(:,60)) ! ((1,0,2)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,60)) ! ((1,0,3)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,60)) ! ((1,0,4)|(0,0,0))
        theta(277) = dot_product(vrrbuffer(:,67), D(:,60)) ! ((1,0,5)|(0,0,0))
        theta(302) = theta(230)+theta(216)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(344) = theta(250)+theta(230)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(404) = theta(277)+theta(250)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(458) = theta(344)+theta(302)*AB(3) ! ((1,0,2)|(0,0,2)) = ((1,0,3)|(0,0,1))+((1,0,2)|(0,0,1))*AB(3)
        theta(542) = theta(404)+theta(344)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(632) = theta(542)+theta(458)*AB(3) ! ((1,0,2)|(0,0,3)) = ((1,0,3)|(0,0,2))+((1,0,2)|(0,0,2))*AB(3)
        ! (0,3,0|3,0,0): 10
        theta(217) = dot_product(vrrbuffer(:,7), D(:,61)) ! ((0,3,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,61)) ! ((1,3,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,61)) ! ((2,3,0)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,61)) ! ((3,3,0)|(0,0,0))
        theta(303) = theta(227)+theta(217)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(333) = theta(242)+theta(227)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(378) = theta(263)+theta(242)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(459) = theta(333)+theta(303)*AB(1) ! ((0,3,0)|(2,0,0)) = ((1,3,0)|(1,0,0))+((0,3,0)|(1,0,0))*AB(1)
        theta(519) = theta(378)+theta(333)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(633) = theta(519)+theta(459)*AB(1) ! ((0,3,0)|(3,0,0)) = ((1,3,0)|(2,0,0))+((0,3,0)|(2,0,0))*AB(1)
        ! (0,3,0|2,1,0): 13
        theta(217) = dot_product(vrrbuffer(:,7), D(:,62)) ! ((0,3,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,62)) ! ((1,3,0)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,62)) ! ((0,4,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,62)) ! ((2,3,0)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,62)) ! ((1,4,0)|(0,0,0))
        theta(267) = dot_product(vrrbuffer(:,57), D(:,62)) ! ((2,4,0)|(0,0,0))
        theta(303) = theta(227)+theta(217)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(333) = theta(242)+theta(227)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(345) = theta(246)+theta(231)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(390) = theta(267)+theta(246)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(459) = theta(333)+theta(303)*AB(1) ! ((0,3,0)|(2,0,0)) = ((1,3,0)|(1,0,0))+((0,3,0)|(1,0,0))*AB(1)
        theta(543) = theta(390)+theta(345)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(634) = theta(543)+theta(459)*AB(2) ! ((0,3,0)|(2,1,0)) = ((0,4,0)|(2,0,0))+((0,3,0)|(2,0,0))*AB(2)
        ! (0,3,0|2,0,1): 13
        theta(217) = dot_product(vrrbuffer(:,7), D(:,63)) ! ((0,3,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,63)) ! ((1,3,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,63)) ! ((0,3,1)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,63)) ! ((2,3,0)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,63)) ! ((1,3,1)|(0,0,0))
        theta(268) = dot_product(vrrbuffer(:,58), D(:,63)) ! ((2,3,1)|(0,0,0))
        theta(303) = theta(227)+theta(217)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(333) = theta(242)+theta(227)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(348) = theta(247)+theta(232)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(393) = theta(268)+theta(247)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(459) = theta(333)+theta(303)*AB(1) ! ((0,3,0)|(2,0,0)) = ((1,3,0)|(1,0,0))+((0,3,0)|(1,0,0))*AB(1)
        theta(549) = theta(393)+theta(348)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(635) = theta(549)+theta(459)*AB(3) ! ((0,3,0)|(2,0,1)) = ((0,3,1)|(2,0,0))+((0,3,0)|(2,0,0))*AB(3)
        ! (0,3,0|1,2,0): 13
        theta(217) = dot_product(vrrbuffer(:,7), D(:,64)) ! ((0,3,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,64)) ! ((1,3,0)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,64)) ! ((0,4,0)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,64)) ! ((1,4,0)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,64)) ! ((0,5,0)|(0,0,0))
        theta(272) = dot_product(vrrbuffer(:,62), D(:,64)) ! ((1,5,0)|(0,0,0))
        theta(304) = theta(231)+theta(217)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(334) = theta(246)+theta(227)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(346) = theta(251)+theta(231)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(391) = theta(272)+theta(246)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(462) = theta(346)+theta(304)*AB(2) ! ((0,3,0)|(0,2,0)) = ((0,4,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(2)
        theta(522) = theta(391)+theta(334)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(636) = theta(522)+theta(462)*AB(1) ! ((0,3,0)|(1,2,0)) = ((1,3,0)|(0,2,0))+((0,3,0)|(0,2,0))*AB(1)
        ! (0,3,0|1,1,1): 15
        theta(217) = dot_product(vrrbuffer(:,7), D(:,65)) ! ((0,3,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,65)) ! ((1,3,0)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,65)) ! ((0,4,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,65)) ! ((0,3,1)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,65)) ! ((1,4,0)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,65)) ! ((1,3,1)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,65)) ! ((0,4,1)|(0,0,0))
        theta(273) = dot_product(vrrbuffer(:,63), D(:,65)) ! ((1,4,1)|(0,0,0))
        theta(305) = theta(232)+theta(217)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(335) = theta(247)+theta(227)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(347) = theta(252)+theta(231)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(392) = theta(273)+theta(246)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(463) = theta(347)+theta(305)*AB(2) ! ((0,3,0)|(0,1,1)) = ((0,4,0)|(0,0,1))+((0,3,0)|(0,0,1))*AB(2)
        theta(523) = theta(392)+theta(335)*AB(2) ! ((1,3,0)|(0,1,1)) = ((1,4,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(2)
        theta(637) = theta(523)+theta(463)*AB(1) ! ((0,3,0)|(1,1,1)) = ((1,3,0)|(0,1,1))+((0,3,0)|(0,1,1))*AB(1)
        ! (0,3,0|1,0,2): 13
        theta(217) = dot_product(vrrbuffer(:,7), D(:,66)) ! ((0,3,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,66)) ! ((1,3,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,66)) ! ((0,3,1)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,66)) ! ((1,3,1)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,66)) ! ((0,3,2)|(0,0,0))
        theta(274) = dot_product(vrrbuffer(:,64), D(:,66)) ! ((1,3,2)|(0,0,0))
        theta(305) = theta(232)+theta(217)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(335) = theta(247)+theta(227)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(350) = theta(253)+theta(232)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(395) = theta(274)+theta(247)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(464) = theta(350)+theta(305)*AB(3) ! ((0,3,0)|(0,0,2)) = ((0,3,1)|(0,0,1))+((0,3,0)|(0,0,1))*AB(3)
        theta(524) = theta(395)+theta(335)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(638) = theta(524)+theta(464)*AB(1) ! ((0,3,0)|(1,0,2)) = ((1,3,0)|(0,0,2))+((0,3,0)|(0,0,2))*AB(1)
        ! (0,3,0|0,3,0): 10
        theta(217) = dot_product(vrrbuffer(:,7), D(:,67)) ! ((0,3,0)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,67)) ! ((0,4,0)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,67)) ! ((0,5,0)|(0,0,0))
        theta(278) = dot_product(vrrbuffer(:,68), D(:,67)) ! ((0,6,0)|(0,0,0))
        theta(304) = theta(231)+theta(217)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(346) = theta(251)+theta(231)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(406) = theta(278)+theta(251)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(462) = theta(346)+theta(304)*AB(2) ! ((0,3,0)|(0,2,0)) = ((0,4,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(2)
        theta(546) = theta(406)+theta(346)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(639) = theta(546)+theta(462)*AB(2) ! ((0,3,0)|(0,3,0)) = ((0,4,0)|(0,2,0))+((0,3,0)|(0,2,0))*AB(2)
        ! (0,3,0|0,2,1): 13
        theta(217) = dot_product(vrrbuffer(:,7), D(:,68)) ! ((0,3,0)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,68)) ! ((0,4,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,68)) ! ((0,3,1)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,68)) ! ((0,5,0)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,68)) ! ((0,4,1)|(0,0,0))
        theta(279) = dot_product(vrrbuffer(:,69), D(:,68)) ! ((0,5,1)|(0,0,0))
        theta(304) = theta(231)+theta(217)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(346) = theta(251)+theta(231)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(349) = theta(252)+theta(232)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(409) = theta(279)+theta(252)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(462) = theta(346)+theta(304)*AB(2) ! ((0,3,0)|(0,2,0)) = ((0,4,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(2)
        theta(552) = theta(409)+theta(349)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(640) = theta(552)+theta(462)*AB(3) ! ((0,3,0)|(0,2,1)) = ((0,3,1)|(0,2,0))+((0,3,0)|(0,2,0))*AB(3)
        ! (0,3,0|0,1,2): 13
        theta(217) = dot_product(vrrbuffer(:,7), D(:,69)) ! ((0,3,0)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,69)) ! ((0,4,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,69)) ! ((0,3,1)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,69)) ! ((0,4,1)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,69)) ! ((0,3,2)|(0,0,0))
        theta(280) = dot_product(vrrbuffer(:,70), D(:,69)) ! ((0,4,2)|(0,0,0))
        theta(305) = theta(232)+theta(217)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(347) = theta(252)+theta(231)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(350) = theta(253)+theta(232)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(410) = theta(280)+theta(252)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(464) = theta(350)+theta(305)*AB(3) ! ((0,3,0)|(0,0,2)) = ((0,3,1)|(0,0,1))+((0,3,0)|(0,0,1))*AB(3)
        theta(548) = theta(410)+theta(347)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(641) = theta(548)+theta(464)*AB(2) ! ((0,3,0)|(0,1,2)) = ((0,4,0)|(0,0,2))+((0,3,0)|(0,0,2))*AB(2)
        ! (0,3,0|0,0,3): 10
        theta(217) = dot_product(vrrbuffer(:,7), D(:,70)) ! ((0,3,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,70)) ! ((0,3,1)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,70)) ! ((0,3,2)|(0,0,0))
        theta(281) = dot_product(vrrbuffer(:,71), D(:,70)) ! ((0,3,3)|(0,0,0))
        theta(305) = theta(232)+theta(217)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(350) = theta(253)+theta(232)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(413) = theta(281)+theta(253)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(464) = theta(350)+theta(305)*AB(3) ! ((0,3,0)|(0,0,2)) = ((0,3,1)|(0,0,1))+((0,3,0)|(0,0,1))*AB(3)
        theta(554) = theta(413)+theta(350)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(642) = theta(554)+theta(464)*AB(3) ! ((0,3,0)|(0,0,3)) = ((0,3,1)|(0,0,2))+((0,3,0)|(0,0,2))*AB(3)
        ! (0,2,1|3,0,0): 10
        theta(218) = dot_product(vrrbuffer(:,8), D(:,71)) ! ((0,2,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,71)) ! ((1,2,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,71)) ! ((2,2,1)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,71)) ! ((3,2,1)|(0,0,0))
        theta(306) = theta(228)+theta(218)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        theta(336) = theta(243)+theta(228)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(381) = theta(264)+theta(243)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(465) = theta(336)+theta(306)*AB(1) ! ((0,2,1)|(2,0,0)) = ((1,2,1)|(1,0,0))+((0,2,1)|(1,0,0))*AB(1)
        theta(525) = theta(381)+theta(336)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(643) = theta(525)+theta(465)*AB(1) ! ((0,2,1)|(3,0,0)) = ((1,2,1)|(2,0,0))+((0,2,1)|(2,0,0))*AB(1)
        ! (0,2,1|2,1,0): 12
        theta(218) = dot_product(vrrbuffer(:,8), D(:,72)) ! ((0,2,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,72)) ! ((1,2,1)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,72)) ! ((0,3,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,72)) ! ((2,2,1)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,72)) ! ((1,3,1)|(0,0,0))
        theta(268) = dot_product(vrrbuffer(:,58), D(:,72)) ! ((2,3,1)|(0,0,0))
        theta(307) = theta(232)+theta(218)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(337) = theta(247)+theta(228)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(382) = theta(268)+theta(243)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(466) = theta(337)+theta(307)*AB(1) ! ((0,2,1)|(1,1,0)) = ((1,2,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(1)
        theta(526) = theta(382)+theta(337)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        theta(644) = theta(526)+theta(466)*AB(1) ! ((0,2,1)|(2,1,0)) = ((1,2,1)|(1,1,0))+((0,2,1)|(1,1,0))*AB(1)
        ! (0,2,1|2,0,1): 13
        theta(218) = dot_product(vrrbuffer(:,8), D(:,73)) ! ((0,2,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,73)) ! ((1,2,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,73)) ! ((0,2,2)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,73)) ! ((2,2,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,73)) ! ((1,2,2)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,73)) ! ((2,2,2)|(0,0,0))
        theta(306) = theta(228)+theta(218)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        theta(336) = theta(243)+theta(228)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(351) = theta(248)+theta(233)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(396) = theta(269)+theta(248)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(465) = theta(336)+theta(306)*AB(1) ! ((0,2,1)|(2,0,0)) = ((1,2,1)|(1,0,0))+((0,2,1)|(1,0,0))*AB(1)
        theta(555) = theta(396)+theta(351)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(645) = theta(555)+theta(465)*AB(3) ! ((0,2,1)|(2,0,1)) = ((0,2,2)|(2,0,0))+((0,2,1)|(2,0,0))*AB(3)
        ! (0,2,1|1,2,0): 13
        theta(218) = dot_product(vrrbuffer(:,8), D(:,74)) ! ((0,2,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,74)) ! ((1,2,1)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,74)) ! ((0,3,1)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,74)) ! ((1,3,1)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,74)) ! ((0,4,1)|(0,0,0))
        theta(273) = dot_product(vrrbuffer(:,63), D(:,74)) ! ((1,4,1)|(0,0,0))
        theta(307) = theta(232)+theta(218)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(337) = theta(247)+theta(228)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(349) = theta(252)+theta(232)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(394) = theta(273)+theta(247)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(468) = theta(349)+theta(307)*AB(2) ! ((0,2,1)|(0,2,0)) = ((0,3,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(2)
        theta(528) = theta(394)+theta(337)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(646) = theta(528)+theta(468)*AB(1) ! ((0,2,1)|(1,2,0)) = ((1,2,1)|(0,2,0))+((0,2,1)|(0,2,0))*AB(1)
        ! (0,2,1|1,1,1): 15
        theta(218) = dot_product(vrrbuffer(:,8), D(:,75)) ! ((0,2,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,75)) ! ((1,2,1)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,75)) ! ((0,3,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,75)) ! ((0,2,2)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,75)) ! ((1,3,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,75)) ! ((1,2,2)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,75)) ! ((0,3,2)|(0,0,0))
        theta(274) = dot_product(vrrbuffer(:,64), D(:,75)) ! ((1,3,2)|(0,0,0))
        theta(308) = theta(233)+theta(218)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(350) = theta(253)+theta(232)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(395) = theta(274)+theta(247)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(469) = theta(350)+theta(308)*AB(2) ! ((0,2,1)|(0,1,1)) = ((0,3,1)|(0,0,1))+((0,2,1)|(0,0,1))*AB(2)
        theta(529) = theta(395)+theta(338)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        theta(647) = theta(529)+theta(469)*AB(1) ! ((0,2,1)|(1,1,1)) = ((1,2,1)|(0,1,1))+((0,2,1)|(0,1,1))*AB(1)
        ! (0,2,1|1,0,2): 13
        theta(218) = dot_product(vrrbuffer(:,8), D(:,76)) ! ((0,2,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,76)) ! ((1,2,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,76)) ! ((0,2,2)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,76)) ! ((1,2,2)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,76)) ! ((0,2,3)|(0,0,0))
        theta(275) = dot_product(vrrbuffer(:,65), D(:,76)) ! ((1,2,3)|(0,0,0))
        theta(308) = theta(233)+theta(218)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(353) = theta(254)+theta(233)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(398) = theta(275)+theta(248)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(470) = theta(353)+theta(308)*AB(3) ! ((0,2,1)|(0,0,2)) = ((0,2,2)|(0,0,1))+((0,2,1)|(0,0,1))*AB(3)
        theta(530) = theta(398)+theta(338)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(648) = theta(530)+theta(470)*AB(1) ! ((0,2,1)|(1,0,2)) = ((1,2,1)|(0,0,2))+((0,2,1)|(0,0,2))*AB(1)
        ! (0,2,1|0,3,0): 10
        theta(218) = dot_product(vrrbuffer(:,8), D(:,77)) ! ((0,2,1)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,77)) ! ((0,3,1)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,77)) ! ((0,4,1)|(0,0,0))
        theta(279) = dot_product(vrrbuffer(:,69), D(:,77)) ! ((0,5,1)|(0,0,0))
        theta(307) = theta(232)+theta(218)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(349) = theta(252)+theta(232)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(409) = theta(279)+theta(252)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(468) = theta(349)+theta(307)*AB(2) ! ((0,2,1)|(0,2,0)) = ((0,3,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(2)
        theta(552) = theta(409)+theta(349)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(649) = theta(552)+theta(468)*AB(2) ! ((0,2,1)|(0,3,0)) = ((0,3,1)|(0,2,0))+((0,2,1)|(0,2,0))*AB(2)
        ! (0,2,1|0,2,1): 13
        theta(218) = dot_product(vrrbuffer(:,8), D(:,78)) ! ((0,2,1)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,78)) ! ((0,3,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,78)) ! ((0,2,2)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,78)) ! ((0,4,1)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,78)) ! ((0,3,2)|(0,0,0))
        theta(280) = dot_product(vrrbuffer(:,70), D(:,78)) ! ((0,4,2)|(0,0,0))
        theta(307) = theta(232)+theta(218)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(349) = theta(252)+theta(232)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(352) = theta(253)+theta(233)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(412) = theta(280)+theta(253)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(468) = theta(349)+theta(307)*AB(2) ! ((0,2,1)|(0,2,0)) = ((0,3,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(2)
        theta(558) = theta(412)+theta(352)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(650) = theta(558)+theta(468)*AB(3) ! ((0,2,1)|(0,2,1)) = ((0,2,2)|(0,2,0))+((0,2,1)|(0,2,0))*AB(3)
        ! (0,2,1|0,1,2): 13
        theta(218) = dot_product(vrrbuffer(:,8), D(:,79)) ! ((0,2,1)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,79)) ! ((0,3,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,79)) ! ((0,2,2)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,79)) ! ((0,3,2)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,79)) ! ((0,2,3)|(0,0,0))
        theta(281) = dot_product(vrrbuffer(:,71), D(:,79)) ! ((0,3,3)|(0,0,0))
        theta(308) = theta(233)+theta(218)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(350) = theta(253)+theta(232)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(353) = theta(254)+theta(233)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(413) = theta(281)+theta(253)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(470) = theta(353)+theta(308)*AB(3) ! ((0,2,1)|(0,0,2)) = ((0,2,2)|(0,0,1))+((0,2,1)|(0,0,1))*AB(3)
        theta(554) = theta(413)+theta(350)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(651) = theta(554)+theta(470)*AB(2) ! ((0,2,1)|(0,1,2)) = ((0,3,1)|(0,0,2))+((0,2,1)|(0,0,2))*AB(2)
        ! (0,2,1|0,0,3): 10
        theta(218) = dot_product(vrrbuffer(:,8), D(:,80)) ! ((0,2,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,80)) ! ((0,2,2)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,80)) ! ((0,2,3)|(0,0,0))
        theta(282) = dot_product(vrrbuffer(:,72), D(:,80)) ! ((0,2,4)|(0,0,0))
        theta(308) = theta(233)+theta(218)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(353) = theta(254)+theta(233)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(416) = theta(282)+theta(254)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(470) = theta(353)+theta(308)*AB(3) ! ((0,2,1)|(0,0,2)) = ((0,2,2)|(0,0,1))+((0,2,1)|(0,0,1))*AB(3)
        theta(560) = theta(416)+theta(353)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(652) = theta(560)+theta(470)*AB(3) ! ((0,2,1)|(0,0,3)) = ((0,2,2)|(0,0,2))+((0,2,1)|(0,0,2))*AB(3)
        ! (0,1,2|3,0,0): 10
        theta(219) = dot_product(vrrbuffer(:,9), D(:,81)) ! ((0,1,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,81)) ! ((1,1,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,81)) ! ((2,1,2)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,81)) ! ((3,1,2)|(0,0,0))
        theta(309) = theta(229)+theta(219)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        theta(339) = theta(244)+theta(229)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(384) = theta(265)+theta(244)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(471) = theta(339)+theta(309)*AB(1) ! ((0,1,2)|(2,0,0)) = ((1,1,2)|(1,0,0))+((0,1,2)|(1,0,0))*AB(1)
        theta(531) = theta(384)+theta(339)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(653) = theta(531)+theta(471)*AB(1) ! ((0,1,2)|(3,0,0)) = ((1,1,2)|(2,0,0))+((0,1,2)|(2,0,0))*AB(1)
        ! (0,1,2|2,1,0): 12
        theta(219) = dot_product(vrrbuffer(:,9), D(:,82)) ! ((0,1,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,82)) ! ((1,1,2)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,82)) ! ((0,2,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,82)) ! ((2,1,2)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,82)) ! ((1,2,2)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,82)) ! ((2,2,2)|(0,0,0))
        theta(310) = theta(233)+theta(219)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(340) = theta(248)+theta(229)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(385) = theta(269)+theta(244)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(472) = theta(340)+theta(310)*AB(1) ! ((0,1,2)|(1,1,0)) = ((1,1,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(1)
        theta(532) = theta(385)+theta(340)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        theta(654) = theta(532)+theta(472)*AB(1) ! ((0,1,2)|(2,1,0)) = ((1,1,2)|(1,1,0))+((0,1,2)|(1,1,0))*AB(1)
        ! (0,1,2|2,0,1): 13
        theta(219) = dot_product(vrrbuffer(:,9), D(:,83)) ! ((0,1,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,83)) ! ((1,1,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,83)) ! ((0,1,3)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,83)) ! ((2,1,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,83)) ! ((1,1,3)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,83)) ! ((2,1,3)|(0,0,0))
        theta(309) = theta(229)+theta(219)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        theta(339) = theta(244)+theta(229)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(354) = theta(249)+theta(234)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(399) = theta(270)+theta(249)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(471) = theta(339)+theta(309)*AB(1) ! ((0,1,2)|(2,0,0)) = ((1,1,2)|(1,0,0))+((0,1,2)|(1,0,0))*AB(1)
        theta(561) = theta(399)+theta(354)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(655) = theta(561)+theta(471)*AB(3) ! ((0,1,2)|(2,0,1)) = ((0,1,3)|(2,0,0))+((0,1,2)|(2,0,0))*AB(3)
        ! (0,1,2|1,2,0): 13
        theta(219) = dot_product(vrrbuffer(:,9), D(:,84)) ! ((0,1,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,84)) ! ((1,1,2)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,84)) ! ((0,2,2)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,84)) ! ((1,2,2)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,84)) ! ((0,3,2)|(0,0,0))
        theta(274) = dot_product(vrrbuffer(:,64), D(:,84)) ! ((1,3,2)|(0,0,0))
        theta(310) = theta(233)+theta(219)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(340) = theta(248)+theta(229)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(352) = theta(253)+theta(233)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(397) = theta(274)+theta(248)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(474) = theta(352)+theta(310)*AB(2) ! ((0,1,2)|(0,2,0)) = ((0,2,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(2)
        theta(534) = theta(397)+theta(340)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(656) = theta(534)+theta(474)*AB(1) ! ((0,1,2)|(1,2,0)) = ((1,1,2)|(0,2,0))+((0,1,2)|(0,2,0))*AB(1)
        ! (0,1,2|1,1,1): 15
        theta(219) = dot_product(vrrbuffer(:,9), D(:,85)) ! ((0,1,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,85)) ! ((1,1,2)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,85)) ! ((0,2,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,85)) ! ((0,1,3)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,85)) ! ((1,2,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,85)) ! ((1,1,3)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,85)) ! ((0,2,3)|(0,0,0))
        theta(275) = dot_product(vrrbuffer(:,65), D(:,85)) ! ((1,2,3)|(0,0,0))
        theta(311) = theta(234)+theta(219)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(353) = theta(254)+theta(233)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(398) = theta(275)+theta(248)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(475) = theta(353)+theta(311)*AB(2) ! ((0,1,2)|(0,1,1)) = ((0,2,2)|(0,0,1))+((0,1,2)|(0,0,1))*AB(2)
        theta(535) = theta(398)+theta(341)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        theta(657) = theta(535)+theta(475)*AB(1) ! ((0,1,2)|(1,1,1)) = ((1,1,2)|(0,1,1))+((0,1,2)|(0,1,1))*AB(1)
        ! (0,1,2|1,0,2): 13
        theta(219) = dot_product(vrrbuffer(:,9), D(:,86)) ! ((0,1,2)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,86)) ! ((1,1,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,86)) ! ((0,1,3)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,86)) ! ((1,1,3)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,86)) ! ((0,1,4)|(0,0,0))
        theta(276) = dot_product(vrrbuffer(:,66), D(:,86)) ! ((1,1,4)|(0,0,0))
        theta(311) = theta(234)+theta(219)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(356) = theta(255)+theta(234)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(401) = theta(276)+theta(249)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(476) = theta(356)+theta(311)*AB(3) ! ((0,1,2)|(0,0,2)) = ((0,1,3)|(0,0,1))+((0,1,2)|(0,0,1))*AB(3)
        theta(536) = theta(401)+theta(341)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(658) = theta(536)+theta(476)*AB(1) ! ((0,1,2)|(1,0,2)) = ((1,1,2)|(0,0,2))+((0,1,2)|(0,0,2))*AB(1)
        ! (0,1,2|0,3,0): 10
        theta(219) = dot_product(vrrbuffer(:,9), D(:,87)) ! ((0,1,2)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,87)) ! ((0,2,2)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,87)) ! ((0,3,2)|(0,0,0))
        theta(280) = dot_product(vrrbuffer(:,70), D(:,87)) ! ((0,4,2)|(0,0,0))
        theta(310) = theta(233)+theta(219)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(352) = theta(253)+theta(233)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(412) = theta(280)+theta(253)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(474) = theta(352)+theta(310)*AB(2) ! ((0,1,2)|(0,2,0)) = ((0,2,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(2)
        theta(558) = theta(412)+theta(352)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(659) = theta(558)+theta(474)*AB(2) ! ((0,1,2)|(0,3,0)) = ((0,2,2)|(0,2,0))+((0,1,2)|(0,2,0))*AB(2)
        ! (0,1,2|0,2,1): 13
        theta(219) = dot_product(vrrbuffer(:,9), D(:,88)) ! ((0,1,2)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,88)) ! ((0,2,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,88)) ! ((0,1,3)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,88)) ! ((0,3,2)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,88)) ! ((0,2,3)|(0,0,0))
        theta(281) = dot_product(vrrbuffer(:,71), D(:,88)) ! ((0,3,3)|(0,0,0))
        theta(310) = theta(233)+theta(219)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(352) = theta(253)+theta(233)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(355) = theta(254)+theta(234)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(415) = theta(281)+theta(254)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(474) = theta(352)+theta(310)*AB(2) ! ((0,1,2)|(0,2,0)) = ((0,2,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(2)
        theta(564) = theta(415)+theta(355)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(660) = theta(564)+theta(474)*AB(3) ! ((0,1,2)|(0,2,1)) = ((0,1,3)|(0,2,0))+((0,1,2)|(0,2,0))*AB(3)
        ! (0,1,2|0,1,2): 13
        theta(219) = dot_product(vrrbuffer(:,9), D(:,89)) ! ((0,1,2)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,89)) ! ((0,2,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,89)) ! ((0,1,3)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,89)) ! ((0,2,3)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,89)) ! ((0,1,4)|(0,0,0))
        theta(282) = dot_product(vrrbuffer(:,72), D(:,89)) ! ((0,2,4)|(0,0,0))
        theta(311) = theta(234)+theta(219)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(353) = theta(254)+theta(233)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(356) = theta(255)+theta(234)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(416) = theta(282)+theta(254)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(476) = theta(356)+theta(311)*AB(3) ! ((0,1,2)|(0,0,2)) = ((0,1,3)|(0,0,1))+((0,1,2)|(0,0,1))*AB(3)
        theta(560) = theta(416)+theta(353)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(661) = theta(560)+theta(476)*AB(2) ! ((0,1,2)|(0,1,2)) = ((0,2,2)|(0,0,2))+((0,1,2)|(0,0,2))*AB(2)
        ! (0,1,2|0,0,3): 10
        theta(219) = dot_product(vrrbuffer(:,9), D(:,90)) ! ((0,1,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,90)) ! ((0,1,3)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,90)) ! ((0,1,4)|(0,0,0))
        theta(283) = dot_product(vrrbuffer(:,73), D(:,90)) ! ((0,1,5)|(0,0,0))
        theta(311) = theta(234)+theta(219)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(356) = theta(255)+theta(234)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(419) = theta(283)+theta(255)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(476) = theta(356)+theta(311)*AB(3) ! ((0,1,2)|(0,0,2)) = ((0,1,3)|(0,0,1))+((0,1,2)|(0,0,1))*AB(3)
        theta(566) = theta(419)+theta(356)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(662) = theta(566)+theta(476)*AB(3) ! ((0,1,2)|(0,0,3)) = ((0,1,3)|(0,0,2))+((0,1,2)|(0,0,2))*AB(3)
        ! (0,0,3|3,0,0): 10
        theta(220) = dot_product(vrrbuffer(:,10), D(:,91)) ! ((0,0,3)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,91)) ! ((1,0,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,91)) ! ((2,0,3)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,91)) ! ((3,0,3)|(0,0,0))
        theta(312) = theta(230)+theta(220)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        theta(342) = theta(245)+theta(230)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(387) = theta(266)+theta(245)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(477) = theta(342)+theta(312)*AB(1) ! ((0,0,3)|(2,0,0)) = ((1,0,3)|(1,0,0))+((0,0,3)|(1,0,0))*AB(1)
        theta(537) = theta(387)+theta(342)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(663) = theta(537)+theta(477)*AB(1) ! ((0,0,3)|(3,0,0)) = ((1,0,3)|(2,0,0))+((0,0,3)|(2,0,0))*AB(1)
        ! (0,0,3|2,1,0): 12
        theta(220) = dot_product(vrrbuffer(:,10), D(:,92)) ! ((0,0,3)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,92)) ! ((1,0,3)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,92)) ! ((0,1,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,92)) ! ((2,0,3)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,92)) ! ((1,1,3)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,92)) ! ((2,1,3)|(0,0,0))
        theta(313) = theta(234)+theta(220)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(343) = theta(249)+theta(230)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(388) = theta(270)+theta(245)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(478) = theta(343)+theta(313)*AB(1) ! ((0,0,3)|(1,1,0)) = ((1,0,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(1)
        theta(538) = theta(388)+theta(343)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        theta(664) = theta(538)+theta(478)*AB(1) ! ((0,0,3)|(2,1,0)) = ((1,0,3)|(1,1,0))+((0,0,3)|(1,1,0))*AB(1)
        ! (0,0,3|2,0,1): 13
        theta(220) = dot_product(vrrbuffer(:,10), D(:,93)) ! ((0,0,3)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,93)) ! ((1,0,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,93)) ! ((0,0,4)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,93)) ! ((2,0,3)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,93)) ! ((1,0,4)|(0,0,0))
        theta(271) = dot_product(vrrbuffer(:,61), D(:,93)) ! ((2,0,4)|(0,0,0))
        theta(312) = theta(230)+theta(220)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        theta(342) = theta(245)+theta(230)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(357) = theta(250)+theta(235)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(402) = theta(271)+theta(250)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(477) = theta(342)+theta(312)*AB(1) ! ((0,0,3)|(2,0,0)) = ((1,0,3)|(1,0,0))+((0,0,3)|(1,0,0))*AB(1)
        theta(567) = theta(402)+theta(357)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(665) = theta(567)+theta(477)*AB(3) ! ((0,0,3)|(2,0,1)) = ((0,0,4)|(2,0,0))+((0,0,3)|(2,0,0))*AB(3)
        ! (0,0,3|1,2,0): 13
        theta(220) = dot_product(vrrbuffer(:,10), D(:,94)) ! ((0,0,3)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,94)) ! ((1,0,3)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,94)) ! ((0,1,3)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,94)) ! ((1,1,3)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,94)) ! ((0,2,3)|(0,0,0))
        theta(275) = dot_product(vrrbuffer(:,65), D(:,94)) ! ((1,2,3)|(0,0,0))
        theta(313) = theta(234)+theta(220)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(343) = theta(249)+theta(230)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(355) = theta(254)+theta(234)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(400) = theta(275)+theta(249)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(480) = theta(355)+theta(313)*AB(2) ! ((0,0,3)|(0,2,0)) = ((0,1,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(2)
        theta(540) = theta(400)+theta(343)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(666) = theta(540)+theta(480)*AB(1) ! ((0,0,3)|(1,2,0)) = ((1,0,3)|(0,2,0))+((0,0,3)|(0,2,0))*AB(1)
        ! (0,0,3|1,1,1): 15
        theta(220) = dot_product(vrrbuffer(:,10), D(:,95)) ! ((0,0,3)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,95)) ! ((1,0,3)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,95)) ! ((0,1,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,95)) ! ((0,0,4)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,95)) ! ((1,1,3)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,95)) ! ((1,0,4)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,95)) ! ((0,1,4)|(0,0,0))
        theta(276) = dot_product(vrrbuffer(:,66), D(:,95)) ! ((1,1,4)|(0,0,0))
        theta(314) = theta(235)+theta(220)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(344) = theta(250)+theta(230)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(356) = theta(255)+theta(234)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(401) = theta(276)+theta(249)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(481) = theta(356)+theta(314)*AB(2) ! ((0,0,3)|(0,1,1)) = ((0,1,3)|(0,0,1))+((0,0,3)|(0,0,1))*AB(2)
        theta(541) = theta(401)+theta(344)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        theta(667) = theta(541)+theta(481)*AB(1) ! ((0,0,3)|(1,1,1)) = ((1,0,3)|(0,1,1))+((0,0,3)|(0,1,1))*AB(1)
        ! (0,0,3|1,0,2): 13
        theta(220) = dot_product(vrrbuffer(:,10), D(:,96)) ! ((0,0,3)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,96)) ! ((1,0,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,96)) ! ((0,0,4)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,96)) ! ((1,0,4)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,96)) ! ((0,0,5)|(0,0,0))
        theta(277) = dot_product(vrrbuffer(:,67), D(:,96)) ! ((1,0,5)|(0,0,0))
        theta(314) = theta(235)+theta(220)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(344) = theta(250)+theta(230)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(359) = theta(256)+theta(235)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(404) = theta(277)+theta(250)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(482) = theta(359)+theta(314)*AB(3) ! ((0,0,3)|(0,0,2)) = ((0,0,4)|(0,0,1))+((0,0,3)|(0,0,1))*AB(3)
        theta(542) = theta(404)+theta(344)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(668) = theta(542)+theta(482)*AB(1) ! ((0,0,3)|(1,0,2)) = ((1,0,3)|(0,0,2))+((0,0,3)|(0,0,2))*AB(1)
        ! (0,0,3|0,3,0): 10
        theta(220) = dot_product(vrrbuffer(:,10), D(:,97)) ! ((0,0,3)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,97)) ! ((0,1,3)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,97)) ! ((0,2,3)|(0,0,0))
        theta(281) = dot_product(vrrbuffer(:,71), D(:,97)) ! ((0,3,3)|(0,0,0))
        theta(313) = theta(234)+theta(220)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(355) = theta(254)+theta(234)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(415) = theta(281)+theta(254)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(480) = theta(355)+theta(313)*AB(2) ! ((0,0,3)|(0,2,0)) = ((0,1,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(2)
        theta(564) = theta(415)+theta(355)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(669) = theta(564)+theta(480)*AB(2) ! ((0,0,3)|(0,3,0)) = ((0,1,3)|(0,2,0))+((0,0,3)|(0,2,0))*AB(2)
        ! (0,0,3|0,2,1): 13
        theta(220) = dot_product(vrrbuffer(:,10), D(:,98)) ! ((0,0,3)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,98)) ! ((0,1,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,98)) ! ((0,0,4)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,98)) ! ((0,2,3)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,98)) ! ((0,1,4)|(0,0,0))
        theta(282) = dot_product(vrrbuffer(:,72), D(:,98)) ! ((0,2,4)|(0,0,0))
        theta(313) = theta(234)+theta(220)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(355) = theta(254)+theta(234)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(358) = theta(255)+theta(235)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(418) = theta(282)+theta(255)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(480) = theta(355)+theta(313)*AB(2) ! ((0,0,3)|(0,2,0)) = ((0,1,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(2)
        theta(570) = theta(418)+theta(358)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(670) = theta(570)+theta(480)*AB(3) ! ((0,0,3)|(0,2,1)) = ((0,0,4)|(0,2,0))+((0,0,3)|(0,2,0))*AB(3)
        ! (0,0,3|0,1,2): 13
        theta(220) = dot_product(vrrbuffer(:,10), D(:,99)) ! ((0,0,3)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,99)) ! ((0,1,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,99)) ! ((0,0,4)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,99)) ! ((0,1,4)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,99)) ! ((0,0,5)|(0,0,0))
        theta(283) = dot_product(vrrbuffer(:,73), D(:,99)) ! ((0,1,5)|(0,0,0))
        theta(314) = theta(235)+theta(220)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(356) = theta(255)+theta(234)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(359) = theta(256)+theta(235)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(419) = theta(283)+theta(255)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(482) = theta(359)+theta(314)*AB(3) ! ((0,0,3)|(0,0,2)) = ((0,0,4)|(0,0,1))+((0,0,3)|(0,0,1))*AB(3)
        theta(566) = theta(419)+theta(356)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(671) = theta(566)+theta(482)*AB(2) ! ((0,0,3)|(0,1,2)) = ((0,1,3)|(0,0,2))+((0,0,3)|(0,0,2))*AB(2)
        ! (0,0,3|0,0,3): 10
        theta(220) = dot_product(vrrbuffer(:,10), D(:,100)) ! ((0,0,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,100)) ! ((0,0,4)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,100)) ! ((0,0,5)|(0,0,0))
        theta(284) = dot_product(vrrbuffer(:,74), D(:,100)) ! ((0,0,6)|(0,0,0))
        theta(314) = theta(235)+theta(220)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(359) = theta(256)+theta(235)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(422) = theta(284)+theta(256)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(482) = theta(359)+theta(314)*AB(3) ! ((0,0,3)|(0,0,2)) = ((0,0,4)|(0,0,1))+((0,0,3)|(0,0,1))*AB(3)
        theta(572) = theta(422)+theta(359)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(672) = theta(572)+theta(482)*AB(3) ! ((0,0,3)|(0,0,3)) = ((0,0,4)|(0,0,2))+((0,0,3)|(0,0,2))*AB(3)
    end subroutine
    subroutine blockhrr_4_0(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 15; Optimized integrals: 15
        ! (4,0,0|0,0,0): 1
        theta(71) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((4,0,0)|(0,0,0))
        ! (3,1,0|0,0,0): 1
        theta(72) = dot_product(vrrbuffer(:,2), D(:,2)) ! ((3,1,0)|(0,0,0))
        ! (3,0,1|0,0,0): 1
        theta(73) = dot_product(vrrbuffer(:,3), D(:,3)) ! ((3,0,1)|(0,0,0))
        ! (2,2,0|0,0,0): 1
        theta(74) = dot_product(vrrbuffer(:,4), D(:,4)) ! ((2,2,0)|(0,0,0))
        ! (2,1,1|0,0,0): 1
        theta(75) = dot_product(vrrbuffer(:,5), D(:,5)) ! ((2,1,1)|(0,0,0))
        ! (2,0,2|0,0,0): 1
        theta(76) = dot_product(vrrbuffer(:,6), D(:,6)) ! ((2,0,2)|(0,0,0))
        ! (1,3,0|0,0,0): 1
        theta(77) = dot_product(vrrbuffer(:,7), D(:,7)) ! ((1,3,0)|(0,0,0))
        ! (1,2,1|0,0,0): 1
        theta(78) = dot_product(vrrbuffer(:,8), D(:,8)) ! ((1,2,1)|(0,0,0))
        ! (1,1,2|0,0,0): 1
        theta(79) = dot_product(vrrbuffer(:,9), D(:,9)) ! ((1,1,2)|(0,0,0))
        ! (1,0,3|0,0,0): 1
        theta(80) = dot_product(vrrbuffer(:,10), D(:,10)) ! ((1,0,3)|(0,0,0))
        ! (0,4,0|0,0,0): 1
        theta(81) = dot_product(vrrbuffer(:,11), D(:,11)) ! ((0,4,0)|(0,0,0))
        ! (0,3,1|0,0,0): 1
        theta(82) = dot_product(vrrbuffer(:,12), D(:,12)) ! ((0,3,1)|(0,0,0))
        ! (0,2,2|0,0,0): 1
        theta(83) = dot_product(vrrbuffer(:,13), D(:,13)) ! ((0,2,2)|(0,0,0))
        ! (0,1,3|0,0,0): 1
        theta(84) = dot_product(vrrbuffer(:,14), D(:,14)) ! ((0,1,3)|(0,0,0))
        ! (0,0,4|0,0,0): 1
        theta(85) = dot_product(vrrbuffer(:,15), D(:,15)) ! ((0,0,4)|(0,0,0))
    end subroutine
    subroutine blockhrr_4_1(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 81; Optimized integrals: 81
        ! (4,0,0|1,0,0): 3
        theta(127) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(142) = dot_product(vrrbuffer(:,16), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(163) = theta(142)+theta(127)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        ! (4,0,0|0,1,0): 3
        theta(127) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((4,0,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,2)) ! ((4,1,0)|(0,0,0))
        theta(164) = theta(143)+theta(127)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        ! (4,0,0|0,0,1): 3
        theta(127) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((4,0,0)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,3)) ! ((4,0,1)|(0,0,0))
        theta(165) = theta(144)+theta(127)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        ! (3,1,0|1,0,0): 3
        theta(128) = dot_product(vrrbuffer(:,2), D(:,4)) ! ((3,1,0)|(0,0,0))
        theta(143) = dot_product(vrrbuffer(:,17), D(:,4)) ! ((4,1,0)|(0,0,0))
        theta(166) = theta(143)+theta(128)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        ! (3,1,0|0,1,0): 3
        theta(128) = dot_product(vrrbuffer(:,2), D(:,5)) ! ((3,1,0)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,5)) ! ((3,2,0)|(0,0,0))
        theta(167) = theta(145)+theta(128)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        ! (3,1,0|0,0,1): 3
        theta(128) = dot_product(vrrbuffer(:,2), D(:,6)) ! ((3,1,0)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,6)) ! ((3,1,1)|(0,0,0))
        theta(168) = theta(146)+theta(128)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        ! (3,0,1|1,0,0): 3
        theta(129) = dot_product(vrrbuffer(:,3), D(:,7)) ! ((3,0,1)|(0,0,0))
        theta(144) = dot_product(vrrbuffer(:,18), D(:,7)) ! ((4,0,1)|(0,0,0))
        theta(169) = theta(144)+theta(129)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        ! (3,0,1|0,1,0): 3
        theta(129) = dot_product(vrrbuffer(:,3), D(:,8)) ! ((3,0,1)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,8)) ! ((3,1,1)|(0,0,0))
        theta(170) = theta(146)+theta(129)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        ! (3,0,1|0,0,1): 3
        theta(129) = dot_product(vrrbuffer(:,3), D(:,9)) ! ((3,0,1)|(0,0,0))
        theta(147) = dot_product(vrrbuffer(:,21), D(:,9)) ! ((3,0,2)|(0,0,0))
        theta(171) = theta(147)+theta(129)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        ! (2,2,0|1,0,0): 3
        theta(130) = dot_product(vrrbuffer(:,4), D(:,10)) ! ((2,2,0)|(0,0,0))
        theta(145) = dot_product(vrrbuffer(:,19), D(:,10)) ! ((3,2,0)|(0,0,0))
        theta(172) = theta(145)+theta(130)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        ! (2,2,0|0,1,0): 3
        theta(130) = dot_product(vrrbuffer(:,4), D(:,11)) ! ((2,2,0)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,11)) ! ((2,3,0)|(0,0,0))
        theta(173) = theta(148)+theta(130)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        ! (2,2,0|0,0,1): 3
        theta(130) = dot_product(vrrbuffer(:,4), D(:,12)) ! ((2,2,0)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,12)) ! ((2,2,1)|(0,0,0))
        theta(174) = theta(149)+theta(130)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        ! (2,1,1|1,0,0): 3
        theta(131) = dot_product(vrrbuffer(:,5), D(:,13)) ! ((2,1,1)|(0,0,0))
        theta(146) = dot_product(vrrbuffer(:,20), D(:,13)) ! ((3,1,1)|(0,0,0))
        theta(175) = theta(146)+theta(131)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        ! (2,1,1|0,1,0): 3
        theta(131) = dot_product(vrrbuffer(:,5), D(:,14)) ! ((2,1,1)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,14)) ! ((2,2,1)|(0,0,0))
        theta(176) = theta(149)+theta(131)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        ! (2,1,1|0,0,1): 3
        theta(131) = dot_product(vrrbuffer(:,5), D(:,15)) ! ((2,1,1)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,15)) ! ((2,1,2)|(0,0,0))
        theta(177) = theta(150)+theta(131)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        ! (2,0,2|1,0,0): 3
        theta(132) = dot_product(vrrbuffer(:,6), D(:,16)) ! ((2,0,2)|(0,0,0))
        theta(147) = dot_product(vrrbuffer(:,21), D(:,16)) ! ((3,0,2)|(0,0,0))
        theta(178) = theta(147)+theta(132)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        ! (2,0,2|0,1,0): 3
        theta(132) = dot_product(vrrbuffer(:,6), D(:,17)) ! ((2,0,2)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,17)) ! ((2,1,2)|(0,0,0))
        theta(179) = theta(150)+theta(132)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        ! (2,0,2|0,0,1): 3
        theta(132) = dot_product(vrrbuffer(:,6), D(:,18)) ! ((2,0,2)|(0,0,0))
        theta(151) = dot_product(vrrbuffer(:,25), D(:,18)) ! ((2,0,3)|(0,0,0))
        theta(180) = theta(151)+theta(132)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        ! (1,3,0|1,0,0): 3
        theta(133) = dot_product(vrrbuffer(:,7), D(:,19)) ! ((1,3,0)|(0,0,0))
        theta(148) = dot_product(vrrbuffer(:,22), D(:,19)) ! ((2,3,0)|(0,0,0))
        theta(181) = theta(148)+theta(133)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        ! (1,3,0|0,1,0): 3
        theta(133) = dot_product(vrrbuffer(:,7), D(:,20)) ! ((1,3,0)|(0,0,0))
        theta(152) = dot_product(vrrbuffer(:,26), D(:,20)) ! ((1,4,0)|(0,0,0))
        theta(182) = theta(152)+theta(133)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        ! (1,3,0|0,0,1): 3
        theta(133) = dot_product(vrrbuffer(:,7), D(:,21)) ! ((1,3,0)|(0,0,0))
        theta(153) = dot_product(vrrbuffer(:,27), D(:,21)) ! ((1,3,1)|(0,0,0))
        theta(183) = theta(153)+theta(133)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        ! (1,2,1|1,0,0): 3
        theta(134) = dot_product(vrrbuffer(:,8), D(:,22)) ! ((1,2,1)|(0,0,0))
        theta(149) = dot_product(vrrbuffer(:,23), D(:,22)) ! ((2,2,1)|(0,0,0))
        theta(184) = theta(149)+theta(134)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        ! (1,2,1|0,1,0): 3
        theta(134) = dot_product(vrrbuffer(:,8), D(:,23)) ! ((1,2,1)|(0,0,0))
        theta(153) = dot_product(vrrbuffer(:,27), D(:,23)) ! ((1,3,1)|(0,0,0))
        theta(185) = theta(153)+theta(134)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        ! (1,2,1|0,0,1): 3
        theta(134) = dot_product(vrrbuffer(:,8), D(:,24)) ! ((1,2,1)|(0,0,0))
        theta(154) = dot_product(vrrbuffer(:,28), D(:,24)) ! ((1,2,2)|(0,0,0))
        theta(186) = theta(154)+theta(134)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        ! (1,1,2|1,0,0): 3
        theta(135) = dot_product(vrrbuffer(:,9), D(:,25)) ! ((1,1,2)|(0,0,0))
        theta(150) = dot_product(vrrbuffer(:,24), D(:,25)) ! ((2,1,2)|(0,0,0))
        theta(187) = theta(150)+theta(135)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        ! (1,1,2|0,1,0): 3
        theta(135) = dot_product(vrrbuffer(:,9), D(:,26)) ! ((1,1,2)|(0,0,0))
        theta(154) = dot_product(vrrbuffer(:,28), D(:,26)) ! ((1,2,2)|(0,0,0))
        theta(188) = theta(154)+theta(135)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        ! (1,1,2|0,0,1): 3
        theta(135) = dot_product(vrrbuffer(:,9), D(:,27)) ! ((1,1,2)|(0,0,0))
        theta(155) = dot_product(vrrbuffer(:,29), D(:,27)) ! ((1,1,3)|(0,0,0))
        theta(189) = theta(155)+theta(135)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        ! (1,0,3|1,0,0): 3
        theta(136) = dot_product(vrrbuffer(:,10), D(:,28)) ! ((1,0,3)|(0,0,0))
        theta(151) = dot_product(vrrbuffer(:,25), D(:,28)) ! ((2,0,3)|(0,0,0))
        theta(190) = theta(151)+theta(136)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        ! (1,0,3|0,1,0): 3
        theta(136) = dot_product(vrrbuffer(:,10), D(:,29)) ! ((1,0,3)|(0,0,0))
        theta(155) = dot_product(vrrbuffer(:,29), D(:,29)) ! ((1,1,3)|(0,0,0))
        theta(191) = theta(155)+theta(136)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        ! (1,0,3|0,0,1): 3
        theta(136) = dot_product(vrrbuffer(:,10), D(:,30)) ! ((1,0,3)|(0,0,0))
        theta(156) = dot_product(vrrbuffer(:,30), D(:,30)) ! ((1,0,4)|(0,0,0))
        theta(192) = theta(156)+theta(136)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        ! (0,4,0|1,0,0): 3
        theta(137) = dot_product(vrrbuffer(:,11), D(:,31)) ! ((0,4,0)|(0,0,0))
        theta(152) = dot_product(vrrbuffer(:,26), D(:,31)) ! ((1,4,0)|(0,0,0))
        theta(193) = theta(152)+theta(137)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        ! (0,4,0|0,1,0): 3
        theta(137) = dot_product(vrrbuffer(:,11), D(:,32)) ! ((0,4,0)|(0,0,0))
        theta(157) = dot_product(vrrbuffer(:,31), D(:,32)) ! ((0,5,0)|(0,0,0))
        theta(194) = theta(157)+theta(137)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        ! (0,4,0|0,0,1): 3
        theta(137) = dot_product(vrrbuffer(:,11), D(:,33)) ! ((0,4,0)|(0,0,0))
        theta(158) = dot_product(vrrbuffer(:,32), D(:,33)) ! ((0,4,1)|(0,0,0))
        theta(195) = theta(158)+theta(137)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        ! (0,3,1|1,0,0): 3
        theta(138) = dot_product(vrrbuffer(:,12), D(:,34)) ! ((0,3,1)|(0,0,0))
        theta(153) = dot_product(vrrbuffer(:,27), D(:,34)) ! ((1,3,1)|(0,0,0))
        theta(196) = theta(153)+theta(138)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        ! (0,3,1|0,1,0): 3
        theta(138) = dot_product(vrrbuffer(:,12), D(:,35)) ! ((0,3,1)|(0,0,0))
        theta(158) = dot_product(vrrbuffer(:,32), D(:,35)) ! ((0,4,1)|(0,0,0))
        theta(197) = theta(158)+theta(138)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        ! (0,3,1|0,0,1): 3
        theta(138) = dot_product(vrrbuffer(:,12), D(:,36)) ! ((0,3,1)|(0,0,0))
        theta(159) = dot_product(vrrbuffer(:,33), D(:,36)) ! ((0,3,2)|(0,0,0))
        theta(198) = theta(159)+theta(138)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        ! (0,2,2|1,0,0): 3
        theta(139) = dot_product(vrrbuffer(:,13), D(:,37)) ! ((0,2,2)|(0,0,0))
        theta(154) = dot_product(vrrbuffer(:,28), D(:,37)) ! ((1,2,2)|(0,0,0))
        theta(199) = theta(154)+theta(139)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        ! (0,2,2|0,1,0): 3
        theta(139) = dot_product(vrrbuffer(:,13), D(:,38)) ! ((0,2,2)|(0,0,0))
        theta(159) = dot_product(vrrbuffer(:,33), D(:,38)) ! ((0,3,2)|(0,0,0))
        theta(200) = theta(159)+theta(139)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        ! (0,2,2|0,0,1): 3
        theta(139) = dot_product(vrrbuffer(:,13), D(:,39)) ! ((0,2,2)|(0,0,0))
        theta(160) = dot_product(vrrbuffer(:,34), D(:,39)) ! ((0,2,3)|(0,0,0))
        theta(201) = theta(160)+theta(139)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        ! (0,1,3|1,0,0): 3
        theta(140) = dot_product(vrrbuffer(:,14), D(:,40)) ! ((0,1,3)|(0,0,0))
        theta(155) = dot_product(vrrbuffer(:,29), D(:,40)) ! ((1,1,3)|(0,0,0))
        theta(202) = theta(155)+theta(140)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        ! (0,1,3|0,1,0): 3
        theta(140) = dot_product(vrrbuffer(:,14), D(:,41)) ! ((0,1,3)|(0,0,0))
        theta(160) = dot_product(vrrbuffer(:,34), D(:,41)) ! ((0,2,3)|(0,0,0))
        theta(203) = theta(160)+theta(140)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        ! (0,1,3|0,0,1): 3
        theta(140) = dot_product(vrrbuffer(:,14), D(:,42)) ! ((0,1,3)|(0,0,0))
        theta(161) = dot_product(vrrbuffer(:,35), D(:,42)) ! ((0,1,4)|(0,0,0))
        theta(204) = theta(161)+theta(140)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        ! (0,0,4|1,0,0): 3
        theta(141) = dot_product(vrrbuffer(:,15), D(:,43)) ! ((0,0,4)|(0,0,0))
        theta(156) = dot_product(vrrbuffer(:,30), D(:,43)) ! ((1,0,4)|(0,0,0))
        theta(205) = theta(156)+theta(141)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        ! (0,0,4|0,1,0): 3
        theta(141) = dot_product(vrrbuffer(:,15), D(:,44)) ! ((0,0,4)|(0,0,0))
        theta(161) = dot_product(vrrbuffer(:,35), D(:,44)) ! ((0,1,4)|(0,0,0))
        theta(206) = theta(161)+theta(141)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        ! (0,0,4|0,0,1): 3
        theta(141) = dot_product(vrrbuffer(:,15), D(:,45)) ! ((0,0,4)|(0,0,0))
        theta(162) = dot_product(vrrbuffer(:,36), D(:,45)) ! ((0,0,5)|(0,0,0))
        theta(207) = theta(162)+theta(141)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
    end subroutine
    subroutine blockhrr_4_2(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 262; Optimized integrals: 255
        ! (4,0,0|2,0,0): 6
        theta(211) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,1)) ! ((6,0,0)|(0,0,0))
        theta(275) = theta(226)+theta(211)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(320) = theta(247)+theta(226)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(383) = theta(320)+theta(275)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        ! (4,0,0|1,1,0): 7
        theta(211) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((4,0,0)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,2)) ! ((5,0,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,2)) ! ((4,1,0)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,2)) ! ((5,1,0)|(0,0,0))
        theta(276) = theta(227)+theta(211)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(321) = theta(248)+theta(226)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(384) = theta(321)+theta(276)*AB(1) ! ((4,0,0)|(1,1,0)) = ((5,0,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(1)
        ! (4,0,0|1,0,1): 7
        theta(211) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((4,0,0)|(0,0,0))
        theta(226) = dot_product(vrrbuffer(:,16), D(:,3)) ! ((5,0,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,3)) ! ((4,0,1)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,3)) ! ((5,0,1)|(0,0,0))
        theta(277) = theta(228)+theta(211)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(322) = theta(249)+theta(226)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(385) = theta(322)+theta(277)*AB(1) ! ((4,0,0)|(1,0,1)) = ((5,0,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(1)
        ! (4,0,0|0,2,0): 6
        theta(211) = dot_product(vrrbuffer(:,1), D(:,4)) ! ((4,0,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,4)) ! ((4,1,0)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,4)) ! ((4,2,0)|(0,0,0))
        theta(276) = theta(227)+theta(211)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(324) = theta(250)+theta(227)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(386) = theta(324)+theta(276)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        ! (4,0,0|0,1,1): 7
        theta(211) = dot_product(vrrbuffer(:,1), D(:,5)) ! ((4,0,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,5)) ! ((4,1,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,5)) ! ((4,0,1)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,5)) ! ((4,1,1)|(0,0,0))
        theta(277) = theta(228)+theta(211)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(325) = theta(251)+theta(227)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(387) = theta(325)+theta(277)*AB(2) ! ((4,0,0)|(0,1,1)) = ((4,1,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(2)
        ! (4,0,0|0,0,2): 6
        theta(211) = dot_product(vrrbuffer(:,1), D(:,6)) ! ((4,0,0)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,6)) ! ((4,0,1)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,6)) ! ((4,0,2)|(0,0,0))
        theta(277) = theta(228)+theta(211)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(328) = theta(252)+theta(228)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(388) = theta(328)+theta(277)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        ! (3,1,0|2,0,0): 6
        theta(212) = dot_product(vrrbuffer(:,2), D(:,7)) ! ((3,1,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,7)) ! ((4,1,0)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,7)) ! ((5,1,0)|(0,0,0))
        theta(278) = theta(227)+theta(212)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(323) = theta(248)+theta(227)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(389) = theta(323)+theta(278)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        ! (3,1,0|1,1,0): 7
        theta(212) = dot_product(vrrbuffer(:,2), D(:,8)) ! ((3,1,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,8)) ! ((4,1,0)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,8)) ! ((3,2,0)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,8)) ! ((4,2,0)|(0,0,0))
        theta(279) = theta(229)+theta(212)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(324) = theta(250)+theta(227)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(390) = theta(324)+theta(279)*AB(1) ! ((3,1,0)|(1,1,0)) = ((4,1,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(1)
        ! (3,1,0|1,0,1): 7
        theta(212) = dot_product(vrrbuffer(:,2), D(:,9)) ! ((3,1,0)|(0,0,0))
        theta(227) = dot_product(vrrbuffer(:,17), D(:,9)) ! ((4,1,0)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,9)) ! ((3,1,1)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,9)) ! ((4,1,1)|(0,0,0))
        theta(280) = theta(230)+theta(212)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(325) = theta(251)+theta(227)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(391) = theta(325)+theta(280)*AB(1) ! ((3,1,0)|(1,0,1)) = ((4,1,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(1)
        ! (3,1,0|0,2,0): 6
        theta(212) = dot_product(vrrbuffer(:,2), D(:,10)) ! ((3,1,0)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,10)) ! ((3,2,0)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,10)) ! ((3,3,0)|(0,0,0))
        theta(279) = theta(229)+theta(212)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(330) = theta(253)+theta(229)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(392) = theta(330)+theta(279)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        ! (3,1,0|0,1,1): 7
        theta(212) = dot_product(vrrbuffer(:,2), D(:,11)) ! ((3,1,0)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,11)) ! ((3,2,0)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,11)) ! ((3,1,1)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,11)) ! ((3,2,1)|(0,0,0))
        theta(280) = theta(230)+theta(212)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(331) = theta(254)+theta(229)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(393) = theta(331)+theta(280)*AB(2) ! ((3,1,0)|(0,1,1)) = ((3,2,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(2)
        ! (3,1,0|0,0,2): 6
        theta(212) = dot_product(vrrbuffer(:,2), D(:,12)) ! ((3,1,0)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,12)) ! ((3,1,1)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,12)) ! ((3,1,2)|(0,0,0))
        theta(280) = theta(230)+theta(212)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(334) = theta(255)+theta(230)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(394) = theta(334)+theta(280)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        ! (3,0,1|2,0,0): 6
        theta(213) = dot_product(vrrbuffer(:,3), D(:,13)) ! ((3,0,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,13)) ! ((4,0,1)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,13)) ! ((5,0,1)|(0,0,0))
        theta(281) = theta(228)+theta(213)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(326) = theta(249)+theta(228)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(395) = theta(326)+theta(281)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        ! (3,0,1|1,1,0): 7
        theta(213) = dot_product(vrrbuffer(:,3), D(:,14)) ! ((3,0,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,14)) ! ((4,0,1)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,14)) ! ((3,1,1)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,14)) ! ((4,1,1)|(0,0,0))
        theta(282) = theta(230)+theta(213)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(327) = theta(251)+theta(228)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(396) = theta(327)+theta(282)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        ! (3,0,1|1,0,1): 7
        theta(213) = dot_product(vrrbuffer(:,3), D(:,15)) ! ((3,0,1)|(0,0,0))
        theta(228) = dot_product(vrrbuffer(:,18), D(:,15)) ! ((4,0,1)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,15)) ! ((3,0,2)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,15)) ! ((4,0,2)|(0,0,0))
        theta(283) = theta(231)+theta(213)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(328) = theta(252)+theta(228)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(397) = theta(328)+theta(283)*AB(1) ! ((3,0,1)|(1,0,1)) = ((4,0,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(1)
        ! (3,0,1|0,2,0): 6
        theta(213) = dot_product(vrrbuffer(:,3), D(:,16)) ! ((3,0,1)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,16)) ! ((3,1,1)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,16)) ! ((3,2,1)|(0,0,0))
        theta(282) = theta(230)+theta(213)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(333) = theta(254)+theta(230)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(398) = theta(333)+theta(282)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        ! (3,0,1|0,1,1): 7
        theta(213) = dot_product(vrrbuffer(:,3), D(:,17)) ! ((3,0,1)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,17)) ! ((3,1,1)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,17)) ! ((3,0,2)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,17)) ! ((3,1,2)|(0,0,0))
        theta(283) = theta(231)+theta(213)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(334) = theta(255)+theta(230)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(399) = theta(334)+theta(283)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        ! (3,0,1|0,0,2): 6
        theta(213) = dot_product(vrrbuffer(:,3), D(:,18)) ! ((3,0,1)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,18)) ! ((3,0,2)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,18)) ! ((3,0,3)|(0,0,0))
        theta(283) = theta(231)+theta(213)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(337) = theta(256)+theta(231)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(400) = theta(337)+theta(283)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        ! (2,2,0|2,0,0): 6
        theta(214) = dot_product(vrrbuffer(:,4), D(:,19)) ! ((2,2,0)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,19)) ! ((3,2,0)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,19)) ! ((4,2,0)|(0,0,0))
        theta(284) = theta(229)+theta(214)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(329) = theta(250)+theta(229)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(401) = theta(329)+theta(284)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        ! (2,2,0|1,1,0): 7
        theta(214) = dot_product(vrrbuffer(:,4), D(:,20)) ! ((2,2,0)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,20)) ! ((3,2,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,20)) ! ((2,3,0)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,20)) ! ((3,3,0)|(0,0,0))
        theta(285) = theta(232)+theta(214)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(330) = theta(253)+theta(229)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(402) = theta(330)+theta(285)*AB(1) ! ((2,2,0)|(1,1,0)) = ((3,2,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(1)
        ! (2,2,0|1,0,1): 7
        theta(214) = dot_product(vrrbuffer(:,4), D(:,21)) ! ((2,2,0)|(0,0,0))
        theta(229) = dot_product(vrrbuffer(:,19), D(:,21)) ! ((3,2,0)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,21)) ! ((2,2,1)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,21)) ! ((3,2,1)|(0,0,0))
        theta(286) = theta(233)+theta(214)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(331) = theta(254)+theta(229)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(403) = theta(331)+theta(286)*AB(1) ! ((2,2,0)|(1,0,1)) = ((3,2,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(1)
        ! (2,2,0|0,2,0): 6
        theta(214) = dot_product(vrrbuffer(:,4), D(:,22)) ! ((2,2,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,22)) ! ((2,3,0)|(0,0,0))
        theta(257) = dot_product(vrrbuffer(:,47), D(:,22)) ! ((2,4,0)|(0,0,0))
        theta(285) = theta(232)+theta(214)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(339) = theta(257)+theta(232)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(404) = theta(339)+theta(285)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        ! (2,2,0|0,1,1): 7
        theta(214) = dot_product(vrrbuffer(:,4), D(:,23)) ! ((2,2,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,23)) ! ((2,3,0)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,23)) ! ((2,2,1)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,23)) ! ((2,3,1)|(0,0,0))
        theta(286) = theta(233)+theta(214)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(340) = theta(258)+theta(232)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(405) = theta(340)+theta(286)*AB(2) ! ((2,2,0)|(0,1,1)) = ((2,3,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(2)
        ! (2,2,0|0,0,2): 6
        theta(214) = dot_product(vrrbuffer(:,4), D(:,24)) ! ((2,2,0)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,24)) ! ((2,2,1)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,24)) ! ((2,2,2)|(0,0,0))
        theta(286) = theta(233)+theta(214)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(343) = theta(259)+theta(233)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(406) = theta(343)+theta(286)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        ! (2,1,1|2,0,0): 6
        theta(215) = dot_product(vrrbuffer(:,5), D(:,25)) ! ((2,1,1)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,25)) ! ((3,1,1)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,25)) ! ((4,1,1)|(0,0,0))
        theta(287) = theta(230)+theta(215)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(332) = theta(251)+theta(230)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(407) = theta(332)+theta(287)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        ! (2,1,1|1,1,0): 7
        theta(215) = dot_product(vrrbuffer(:,5), D(:,26)) ! ((2,1,1)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,26)) ! ((3,1,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,26)) ! ((2,2,1)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,26)) ! ((3,2,1)|(0,0,0))
        theta(288) = theta(233)+theta(215)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(333) = theta(254)+theta(230)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(408) = theta(333)+theta(288)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        ! (2,1,1|1,0,1): 7
        theta(215) = dot_product(vrrbuffer(:,5), D(:,27)) ! ((2,1,1)|(0,0,0))
        theta(230) = dot_product(vrrbuffer(:,20), D(:,27)) ! ((3,1,1)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,27)) ! ((2,1,2)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,27)) ! ((3,1,2)|(0,0,0))
        theta(289) = theta(234)+theta(215)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(334) = theta(255)+theta(230)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(409) = theta(334)+theta(289)*AB(1) ! ((2,1,1)|(1,0,1)) = ((3,1,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(1)
        ! (2,1,1|0,2,0): 6
        theta(215) = dot_product(vrrbuffer(:,5), D(:,28)) ! ((2,1,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,28)) ! ((2,2,1)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,28)) ! ((2,3,1)|(0,0,0))
        theta(288) = theta(233)+theta(215)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(342) = theta(258)+theta(233)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(410) = theta(342)+theta(288)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        ! (2,1,1|0,1,1): 7
        theta(215) = dot_product(vrrbuffer(:,5), D(:,29)) ! ((2,1,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,29)) ! ((2,2,1)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,29)) ! ((2,1,2)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,29)) ! ((2,2,2)|(0,0,0))
        theta(289) = theta(234)+theta(215)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(343) = theta(259)+theta(233)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(411) = theta(343)+theta(289)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        ! (2,1,1|0,0,2): 6
        theta(215) = dot_product(vrrbuffer(:,5), D(:,30)) ! ((2,1,1)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,30)) ! ((2,1,2)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,30)) ! ((2,1,3)|(0,0,0))
        theta(289) = theta(234)+theta(215)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(346) = theta(260)+theta(234)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(412) = theta(346)+theta(289)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        ! (2,0,2|2,0,0): 6
        theta(216) = dot_product(vrrbuffer(:,6), D(:,31)) ! ((2,0,2)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,31)) ! ((3,0,2)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,31)) ! ((4,0,2)|(0,0,0))
        theta(290) = theta(231)+theta(216)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(335) = theta(252)+theta(231)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(413) = theta(335)+theta(290)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        ! (2,0,2|1,1,0): 7
        theta(216) = dot_product(vrrbuffer(:,6), D(:,32)) ! ((2,0,2)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,32)) ! ((3,0,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,32)) ! ((2,1,2)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,32)) ! ((3,1,2)|(0,0,0))
        theta(291) = theta(234)+theta(216)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(336) = theta(255)+theta(231)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(414) = theta(336)+theta(291)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        ! (2,0,2|1,0,1): 7
        theta(216) = dot_product(vrrbuffer(:,6), D(:,33)) ! ((2,0,2)|(0,0,0))
        theta(231) = dot_product(vrrbuffer(:,21), D(:,33)) ! ((3,0,2)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,33)) ! ((2,0,3)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,33)) ! ((3,0,3)|(0,0,0))
        theta(292) = theta(235)+theta(216)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(337) = theta(256)+theta(231)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(415) = theta(337)+theta(292)*AB(1) ! ((2,0,2)|(1,0,1)) = ((3,0,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(1)
        ! (2,0,2|0,2,0): 6
        theta(216) = dot_product(vrrbuffer(:,6), D(:,34)) ! ((2,0,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,34)) ! ((2,1,2)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,34)) ! ((2,2,2)|(0,0,0))
        theta(291) = theta(234)+theta(216)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(345) = theta(259)+theta(234)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(416) = theta(345)+theta(291)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        ! (2,0,2|0,1,1): 7
        theta(216) = dot_product(vrrbuffer(:,6), D(:,35)) ! ((2,0,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,35)) ! ((2,1,2)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,35)) ! ((2,0,3)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,35)) ! ((2,1,3)|(0,0,0))
        theta(292) = theta(235)+theta(216)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(346) = theta(260)+theta(234)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(417) = theta(346)+theta(292)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        ! (2,0,2|0,0,2): 6
        theta(216) = dot_product(vrrbuffer(:,6), D(:,36)) ! ((2,0,2)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,36)) ! ((2,0,3)|(0,0,0))
        theta(261) = dot_product(vrrbuffer(:,51), D(:,36)) ! ((2,0,4)|(0,0,0))
        theta(292) = theta(235)+theta(216)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(349) = theta(261)+theta(235)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(418) = theta(349)+theta(292)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        ! (1,3,0|2,0,0): 6
        theta(217) = dot_product(vrrbuffer(:,7), D(:,37)) ! ((1,3,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,37)) ! ((2,3,0)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,37)) ! ((3,3,0)|(0,0,0))
        theta(293) = theta(232)+theta(217)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(338) = theta(253)+theta(232)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(419) = theta(338)+theta(293)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        ! (1,3,0|1,1,0): 7
        theta(217) = dot_product(vrrbuffer(:,7), D(:,38)) ! ((1,3,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,38)) ! ((2,3,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,38)) ! ((1,4,0)|(0,0,0))
        theta(257) = dot_product(vrrbuffer(:,47), D(:,38)) ! ((2,4,0)|(0,0,0))
        theta(294) = theta(236)+theta(217)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(339) = theta(257)+theta(232)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(420) = theta(339)+theta(294)*AB(1) ! ((1,3,0)|(1,1,0)) = ((2,3,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(1)
        ! (1,3,0|1,0,1): 7
        theta(217) = dot_product(vrrbuffer(:,7), D(:,39)) ! ((1,3,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,39)) ! ((2,3,0)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,39)) ! ((1,3,1)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,39)) ! ((2,3,1)|(0,0,0))
        theta(295) = theta(237)+theta(217)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(340) = theta(258)+theta(232)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(421) = theta(340)+theta(295)*AB(1) ! ((1,3,0)|(1,0,1)) = ((2,3,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(1)
        ! (1,3,0|0,2,0): 6
        theta(217) = dot_product(vrrbuffer(:,7), D(:,40)) ! ((1,3,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,40)) ! ((1,4,0)|(0,0,0))
        theta(262) = dot_product(vrrbuffer(:,52), D(:,40)) ! ((1,5,0)|(0,0,0))
        theta(294) = theta(236)+theta(217)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(351) = theta(262)+theta(236)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(422) = theta(351)+theta(294)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        ! (1,3,0|0,1,1): 7
        theta(217) = dot_product(vrrbuffer(:,7), D(:,41)) ! ((1,3,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,41)) ! ((1,4,0)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,41)) ! ((1,3,1)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,41)) ! ((1,4,1)|(0,0,0))
        theta(295) = theta(237)+theta(217)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(352) = theta(263)+theta(236)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(423) = theta(352)+theta(295)*AB(2) ! ((1,3,0)|(0,1,1)) = ((1,4,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(2)
        ! (1,3,0|0,0,2): 6
        theta(217) = dot_product(vrrbuffer(:,7), D(:,42)) ! ((1,3,0)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,42)) ! ((1,3,1)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,42)) ! ((1,3,2)|(0,0,0))
        theta(295) = theta(237)+theta(217)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(355) = theta(264)+theta(237)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(424) = theta(355)+theta(295)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        ! (1,2,1|2,0,0): 6
        theta(218) = dot_product(vrrbuffer(:,8), D(:,43)) ! ((1,2,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,43)) ! ((2,2,1)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,43)) ! ((3,2,1)|(0,0,0))
        theta(296) = theta(233)+theta(218)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(341) = theta(254)+theta(233)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(425) = theta(341)+theta(296)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        ! (1,2,1|1,1,0): 7
        theta(218) = dot_product(vrrbuffer(:,8), D(:,44)) ! ((1,2,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,44)) ! ((2,2,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,44)) ! ((1,3,1)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,44)) ! ((2,3,1)|(0,0,0))
        theta(297) = theta(237)+theta(218)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(342) = theta(258)+theta(233)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(426) = theta(342)+theta(297)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        ! (1,2,1|1,0,1): 7
        theta(218) = dot_product(vrrbuffer(:,8), D(:,45)) ! ((1,2,1)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,45)) ! ((2,2,1)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,45)) ! ((1,2,2)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,45)) ! ((2,2,2)|(0,0,0))
        theta(298) = theta(238)+theta(218)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(343) = theta(259)+theta(233)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(427) = theta(343)+theta(298)*AB(1) ! ((1,2,1)|(1,0,1)) = ((2,2,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(1)
        ! (1,2,1|0,2,0): 6
        theta(218) = dot_product(vrrbuffer(:,8), D(:,46)) ! ((1,2,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,46)) ! ((1,3,1)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,46)) ! ((1,4,1)|(0,0,0))
        theta(297) = theta(237)+theta(218)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(354) = theta(263)+theta(237)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(428) = theta(354)+theta(297)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        ! (1,2,1|0,1,1): 7
        theta(218) = dot_product(vrrbuffer(:,8), D(:,47)) ! ((1,2,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,47)) ! ((1,3,1)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,47)) ! ((1,2,2)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,47)) ! ((1,3,2)|(0,0,0))
        theta(298) = theta(238)+theta(218)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(355) = theta(264)+theta(237)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(429) = theta(355)+theta(298)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        ! (1,2,1|0,0,2): 6
        theta(218) = dot_product(vrrbuffer(:,8), D(:,48)) ! ((1,2,1)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,48)) ! ((1,2,2)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,48)) ! ((1,2,3)|(0,0,0))
        theta(298) = theta(238)+theta(218)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(358) = theta(265)+theta(238)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(430) = theta(358)+theta(298)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        ! (1,1,2|2,0,0): 6
        theta(219) = dot_product(vrrbuffer(:,9), D(:,49)) ! ((1,1,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,49)) ! ((2,1,2)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,49)) ! ((3,1,2)|(0,0,0))
        theta(299) = theta(234)+theta(219)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(344) = theta(255)+theta(234)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(431) = theta(344)+theta(299)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        ! (1,1,2|1,1,0): 7
        theta(219) = dot_product(vrrbuffer(:,9), D(:,50)) ! ((1,1,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,50)) ! ((2,1,2)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,50)) ! ((1,2,2)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,50)) ! ((2,2,2)|(0,0,0))
        theta(300) = theta(238)+theta(219)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(345) = theta(259)+theta(234)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(432) = theta(345)+theta(300)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        ! (1,1,2|1,0,1): 7
        theta(219) = dot_product(vrrbuffer(:,9), D(:,51)) ! ((1,1,2)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,51)) ! ((2,1,2)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,51)) ! ((1,1,3)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,51)) ! ((2,1,3)|(0,0,0))
        theta(301) = theta(239)+theta(219)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(346) = theta(260)+theta(234)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(433) = theta(346)+theta(301)*AB(1) ! ((1,1,2)|(1,0,1)) = ((2,1,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(1)
        ! (1,1,2|0,2,0): 6
        theta(219) = dot_product(vrrbuffer(:,9), D(:,52)) ! ((1,1,2)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,52)) ! ((1,2,2)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,52)) ! ((1,3,2)|(0,0,0))
        theta(300) = theta(238)+theta(219)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(357) = theta(264)+theta(238)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(434) = theta(357)+theta(300)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        ! (1,1,2|0,1,1): 7
        theta(219) = dot_product(vrrbuffer(:,9), D(:,53)) ! ((1,1,2)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,53)) ! ((1,2,2)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,53)) ! ((1,1,3)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,53)) ! ((1,2,3)|(0,0,0))
        theta(301) = theta(239)+theta(219)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(358) = theta(265)+theta(238)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(435) = theta(358)+theta(301)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        ! (1,1,2|0,0,2): 6
        theta(219) = dot_product(vrrbuffer(:,9), D(:,54)) ! ((1,1,2)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,54)) ! ((1,1,3)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,54)) ! ((1,1,4)|(0,0,0))
        theta(301) = theta(239)+theta(219)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(361) = theta(266)+theta(239)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(436) = theta(361)+theta(301)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        ! (1,0,3|2,0,0): 6
        theta(220) = dot_product(vrrbuffer(:,10), D(:,55)) ! ((1,0,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,55)) ! ((2,0,3)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,55)) ! ((3,0,3)|(0,0,0))
        theta(302) = theta(235)+theta(220)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(347) = theta(256)+theta(235)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(437) = theta(347)+theta(302)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        ! (1,0,3|1,1,0): 7
        theta(220) = dot_product(vrrbuffer(:,10), D(:,56)) ! ((1,0,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,56)) ! ((2,0,3)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,56)) ! ((1,1,3)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,56)) ! ((2,1,3)|(0,0,0))
        theta(303) = theta(239)+theta(220)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(348) = theta(260)+theta(235)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(438) = theta(348)+theta(303)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        ! (1,0,3|1,0,1): 7
        theta(220) = dot_product(vrrbuffer(:,10), D(:,57)) ! ((1,0,3)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,57)) ! ((2,0,3)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,57)) ! ((1,0,4)|(0,0,0))
        theta(261) = dot_product(vrrbuffer(:,51), D(:,57)) ! ((2,0,4)|(0,0,0))
        theta(304) = theta(240)+theta(220)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(349) = theta(261)+theta(235)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(439) = theta(349)+theta(304)*AB(1) ! ((1,0,3)|(1,0,1)) = ((2,0,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(1)
        ! (1,0,3|0,2,0): 6
        theta(220) = dot_product(vrrbuffer(:,10), D(:,58)) ! ((1,0,3)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,58)) ! ((1,1,3)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,58)) ! ((1,2,3)|(0,0,0))
        theta(303) = theta(239)+theta(220)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(360) = theta(265)+theta(239)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(440) = theta(360)+theta(303)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        ! (1,0,3|0,1,1): 7
        theta(220) = dot_product(vrrbuffer(:,10), D(:,59)) ! ((1,0,3)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,59)) ! ((1,1,3)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,59)) ! ((1,0,4)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,59)) ! ((1,1,4)|(0,0,0))
        theta(304) = theta(240)+theta(220)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(361) = theta(266)+theta(239)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(441) = theta(361)+theta(304)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        ! (1,0,3|0,0,2): 6
        theta(220) = dot_product(vrrbuffer(:,10), D(:,60)) ! ((1,0,3)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,60)) ! ((1,0,4)|(0,0,0))
        theta(267) = dot_product(vrrbuffer(:,57), D(:,60)) ! ((1,0,5)|(0,0,0))
        theta(304) = theta(240)+theta(220)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(364) = theta(267)+theta(240)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(442) = theta(364)+theta(304)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        ! (0,4,0|2,0,0): 6
        theta(221) = dot_product(vrrbuffer(:,11), D(:,61)) ! ((0,4,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,61)) ! ((1,4,0)|(0,0,0))
        theta(257) = dot_product(vrrbuffer(:,47), D(:,61)) ! ((2,4,0)|(0,0,0))
        theta(305) = theta(236)+theta(221)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(350) = theta(257)+theta(236)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(443) = theta(350)+theta(305)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        ! (0,4,0|1,1,0): 7
        theta(221) = dot_product(vrrbuffer(:,11), D(:,62)) ! ((0,4,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,62)) ! ((1,4,0)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,62)) ! ((0,5,0)|(0,0,0))
        theta(262) = dot_product(vrrbuffer(:,52), D(:,62)) ! ((1,5,0)|(0,0,0))
        theta(306) = theta(241)+theta(221)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(351) = theta(262)+theta(236)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(444) = theta(351)+theta(306)*AB(1) ! ((0,4,0)|(1,1,0)) = ((1,4,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(1)
        ! (0,4,0|1,0,1): 7
        theta(221) = dot_product(vrrbuffer(:,11), D(:,63)) ! ((0,4,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,63)) ! ((1,4,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,63)) ! ((0,4,1)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,63)) ! ((1,4,1)|(0,0,0))
        theta(307) = theta(242)+theta(221)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(352) = theta(263)+theta(236)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(445) = theta(352)+theta(307)*AB(1) ! ((0,4,0)|(1,0,1)) = ((1,4,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(1)
        ! (0,4,0|0,2,0): 6
        theta(221) = dot_product(vrrbuffer(:,11), D(:,64)) ! ((0,4,0)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,64)) ! ((0,5,0)|(0,0,0))
        theta(268) = dot_product(vrrbuffer(:,58), D(:,64)) ! ((0,6,0)|(0,0,0))
        theta(306) = theta(241)+theta(221)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(366) = theta(268)+theta(241)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(446) = theta(366)+theta(306)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        ! (0,4,0|0,1,1): 7
        theta(221) = dot_product(vrrbuffer(:,11), D(:,65)) ! ((0,4,0)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,65)) ! ((0,5,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,65)) ! ((0,4,1)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,65)) ! ((0,5,1)|(0,0,0))
        theta(307) = theta(242)+theta(221)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(367) = theta(269)+theta(241)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(447) = theta(367)+theta(307)*AB(2) ! ((0,4,0)|(0,1,1)) = ((0,5,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(2)
        ! (0,4,0|0,0,2): 6
        theta(221) = dot_product(vrrbuffer(:,11), D(:,66)) ! ((0,4,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,66)) ! ((0,4,1)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,66)) ! ((0,4,2)|(0,0,0))
        theta(307) = theta(242)+theta(221)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(370) = theta(270)+theta(242)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(448) = theta(370)+theta(307)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        ! (0,3,1|2,0,0): 6
        theta(222) = dot_product(vrrbuffer(:,12), D(:,67)) ! ((0,3,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,67)) ! ((1,3,1)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,67)) ! ((2,3,1)|(0,0,0))
        theta(308) = theta(237)+theta(222)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(353) = theta(258)+theta(237)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(449) = theta(353)+theta(308)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        ! (0,3,1|1,1,0): 7
        theta(222) = dot_product(vrrbuffer(:,12), D(:,68)) ! ((0,3,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,68)) ! ((1,3,1)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,68)) ! ((0,4,1)|(0,0,0))
        theta(263) = dot_product(vrrbuffer(:,53), D(:,68)) ! ((1,4,1)|(0,0,0))
        theta(309) = theta(242)+theta(222)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(354) = theta(263)+theta(237)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(450) = theta(354)+theta(309)*AB(1) ! ((0,3,1)|(1,1,0)) = ((1,3,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(1)
        ! (0,3,1|1,0,1): 7
        theta(222) = dot_product(vrrbuffer(:,12), D(:,69)) ! ((0,3,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,69)) ! ((1,3,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,69)) ! ((0,3,2)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,69)) ! ((1,3,2)|(0,0,0))
        theta(310) = theta(243)+theta(222)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(355) = theta(264)+theta(237)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(451) = theta(355)+theta(310)*AB(1) ! ((0,3,1)|(1,0,1)) = ((1,3,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(1)
        ! (0,3,1|0,2,0): 6
        theta(222) = dot_product(vrrbuffer(:,12), D(:,70)) ! ((0,3,1)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,70)) ! ((0,4,1)|(0,0,0))
        theta(269) = dot_product(vrrbuffer(:,59), D(:,70)) ! ((0,5,1)|(0,0,0))
        theta(309) = theta(242)+theta(222)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(369) = theta(269)+theta(242)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(452) = theta(369)+theta(309)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        ! (0,3,1|0,1,1): 7
        theta(222) = dot_product(vrrbuffer(:,12), D(:,71)) ! ((0,3,1)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,71)) ! ((0,4,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,71)) ! ((0,3,2)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,71)) ! ((0,4,2)|(0,0,0))
        theta(310) = theta(243)+theta(222)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(370) = theta(270)+theta(242)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(453) = theta(370)+theta(310)*AB(2) ! ((0,3,1)|(0,1,1)) = ((0,4,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(2)
        ! (0,3,1|0,0,2): 6
        theta(222) = dot_product(vrrbuffer(:,12), D(:,72)) ! ((0,3,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,72)) ! ((0,3,2)|(0,0,0))
        theta(271) = dot_product(vrrbuffer(:,61), D(:,72)) ! ((0,3,3)|(0,0,0))
        theta(310) = theta(243)+theta(222)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(373) = theta(271)+theta(243)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(454) = theta(373)+theta(310)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        ! (0,2,2|2,0,0): 6
        theta(223) = dot_product(vrrbuffer(:,13), D(:,73)) ! ((0,2,2)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,73)) ! ((1,2,2)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,73)) ! ((2,2,2)|(0,0,0))
        theta(311) = theta(238)+theta(223)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(356) = theta(259)+theta(238)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(455) = theta(356)+theta(311)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        ! (0,2,2|1,1,0): 7
        theta(223) = dot_product(vrrbuffer(:,13), D(:,74)) ! ((0,2,2)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,74)) ! ((1,2,2)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,74)) ! ((0,3,2)|(0,0,0))
        theta(264) = dot_product(vrrbuffer(:,54), D(:,74)) ! ((1,3,2)|(0,0,0))
        theta(312) = theta(243)+theta(223)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(357) = theta(264)+theta(238)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(456) = theta(357)+theta(312)*AB(1) ! ((0,2,2)|(1,1,0)) = ((1,2,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(1)
        ! (0,2,2|1,0,1): 7
        theta(223) = dot_product(vrrbuffer(:,13), D(:,75)) ! ((0,2,2)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,75)) ! ((1,2,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,75)) ! ((0,2,3)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,75)) ! ((1,2,3)|(0,0,0))
        theta(313) = theta(244)+theta(223)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(358) = theta(265)+theta(238)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(457) = theta(358)+theta(313)*AB(1) ! ((0,2,2)|(1,0,1)) = ((1,2,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(1)
        ! (0,2,2|0,2,0): 6
        theta(223) = dot_product(vrrbuffer(:,13), D(:,76)) ! ((0,2,2)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,76)) ! ((0,3,2)|(0,0,0))
        theta(270) = dot_product(vrrbuffer(:,60), D(:,76)) ! ((0,4,2)|(0,0,0))
        theta(312) = theta(243)+theta(223)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(372) = theta(270)+theta(243)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(458) = theta(372)+theta(312)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        ! (0,2,2|0,1,1): 7
        theta(223) = dot_product(vrrbuffer(:,13), D(:,77)) ! ((0,2,2)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,77)) ! ((0,3,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,77)) ! ((0,2,3)|(0,0,0))
        theta(271) = dot_product(vrrbuffer(:,61), D(:,77)) ! ((0,3,3)|(0,0,0))
        theta(313) = theta(244)+theta(223)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(373) = theta(271)+theta(243)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(459) = theta(373)+theta(313)*AB(2) ! ((0,2,2)|(0,1,1)) = ((0,3,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(2)
        ! (0,2,2|0,0,2): 6
        theta(223) = dot_product(vrrbuffer(:,13), D(:,78)) ! ((0,2,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,78)) ! ((0,2,3)|(0,0,0))
        theta(272) = dot_product(vrrbuffer(:,62), D(:,78)) ! ((0,2,4)|(0,0,0))
        theta(313) = theta(244)+theta(223)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(376) = theta(272)+theta(244)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(460) = theta(376)+theta(313)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        ! (0,1,3|2,0,0): 6
        theta(224) = dot_product(vrrbuffer(:,14), D(:,79)) ! ((0,1,3)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,79)) ! ((1,1,3)|(0,0,0))
        theta(260) = dot_product(vrrbuffer(:,50), D(:,79)) ! ((2,1,3)|(0,0,0))
        theta(314) = theta(239)+theta(224)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(359) = theta(260)+theta(239)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(461) = theta(359)+theta(314)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        ! (0,1,3|1,1,0): 7
        theta(224) = dot_product(vrrbuffer(:,14), D(:,80)) ! ((0,1,3)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,80)) ! ((1,1,3)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,80)) ! ((0,2,3)|(0,0,0))
        theta(265) = dot_product(vrrbuffer(:,55), D(:,80)) ! ((1,2,3)|(0,0,0))
        theta(315) = theta(244)+theta(224)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(360) = theta(265)+theta(239)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(462) = theta(360)+theta(315)*AB(1) ! ((0,1,3)|(1,1,0)) = ((1,1,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(1)
        ! (0,1,3|1,0,1): 7
        theta(224) = dot_product(vrrbuffer(:,14), D(:,81)) ! ((0,1,3)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,81)) ! ((1,1,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,81)) ! ((0,1,4)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,81)) ! ((1,1,4)|(0,0,0))
        theta(316) = theta(245)+theta(224)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(361) = theta(266)+theta(239)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(463) = theta(361)+theta(316)*AB(1) ! ((0,1,3)|(1,0,1)) = ((1,1,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(1)
        ! (0,1,3|0,2,0): 6
        theta(224) = dot_product(vrrbuffer(:,14), D(:,82)) ! ((0,1,3)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,82)) ! ((0,2,3)|(0,0,0))
        theta(271) = dot_product(vrrbuffer(:,61), D(:,82)) ! ((0,3,3)|(0,0,0))
        theta(315) = theta(244)+theta(224)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(375) = theta(271)+theta(244)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(464) = theta(375)+theta(315)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        ! (0,1,3|0,1,1): 7
        theta(224) = dot_product(vrrbuffer(:,14), D(:,83)) ! ((0,1,3)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,83)) ! ((0,2,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,83)) ! ((0,1,4)|(0,0,0))
        theta(272) = dot_product(vrrbuffer(:,62), D(:,83)) ! ((0,2,4)|(0,0,0))
        theta(316) = theta(245)+theta(224)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(376) = theta(272)+theta(244)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(465) = theta(376)+theta(316)*AB(2) ! ((0,1,3)|(0,1,1)) = ((0,2,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(2)
        ! (0,1,3|0,0,2): 6
        theta(224) = dot_product(vrrbuffer(:,14), D(:,84)) ! ((0,1,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,84)) ! ((0,1,4)|(0,0,0))
        theta(273) = dot_product(vrrbuffer(:,63), D(:,84)) ! ((0,1,5)|(0,0,0))
        theta(316) = theta(245)+theta(224)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(379) = theta(273)+theta(245)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(466) = theta(379)+theta(316)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        ! (0,0,4|2,0,0): 6
        theta(225) = dot_product(vrrbuffer(:,15), D(:,85)) ! ((0,0,4)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,85)) ! ((1,0,4)|(0,0,0))
        theta(261) = dot_product(vrrbuffer(:,51), D(:,85)) ! ((2,0,4)|(0,0,0))
        theta(317) = theta(240)+theta(225)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(362) = theta(261)+theta(240)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(467) = theta(362)+theta(317)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        ! (0,0,4|1,1,0): 7
        theta(225) = dot_product(vrrbuffer(:,15), D(:,86)) ! ((0,0,4)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,86)) ! ((1,0,4)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,86)) ! ((0,1,4)|(0,0,0))
        theta(266) = dot_product(vrrbuffer(:,56), D(:,86)) ! ((1,1,4)|(0,0,0))
        theta(318) = theta(245)+theta(225)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(363) = theta(266)+theta(240)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(468) = theta(363)+theta(318)*AB(1) ! ((0,0,4)|(1,1,0)) = ((1,0,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(1)
        ! (0,0,4|1,0,1): 7
        theta(225) = dot_product(vrrbuffer(:,15), D(:,87)) ! ((0,0,4)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,87)) ! ((1,0,4)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,87)) ! ((0,0,5)|(0,0,0))
        theta(267) = dot_product(vrrbuffer(:,57), D(:,87)) ! ((1,0,5)|(0,0,0))
        theta(319) = theta(246)+theta(225)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(364) = theta(267)+theta(240)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(469) = theta(364)+theta(319)*AB(1) ! ((0,0,4)|(1,0,1)) = ((1,0,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(1)
        ! (0,0,4|0,2,0): 6
        theta(225) = dot_product(vrrbuffer(:,15), D(:,88)) ! ((0,0,4)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,88)) ! ((0,1,4)|(0,0,0))
        theta(272) = dot_product(vrrbuffer(:,62), D(:,88)) ! ((0,2,4)|(0,0,0))
        theta(318) = theta(245)+theta(225)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(378) = theta(272)+theta(245)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(470) = theta(378)+theta(318)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        ! (0,0,4|0,1,1): 7
        theta(225) = dot_product(vrrbuffer(:,15), D(:,89)) ! ((0,0,4)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,89)) ! ((0,1,4)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,89)) ! ((0,0,5)|(0,0,0))
        theta(273) = dot_product(vrrbuffer(:,63), D(:,89)) ! ((0,1,5)|(0,0,0))
        theta(319) = theta(246)+theta(225)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(379) = theta(273)+theta(245)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(471) = theta(379)+theta(319)*AB(2) ! ((0,0,4)|(0,1,1)) = ((0,1,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(2)
        ! (0,0,4|0,0,2): 6
        theta(225) = dot_product(vrrbuffer(:,15), D(:,90)) ! ((0,0,4)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,90)) ! ((0,0,5)|(0,0,0))
        theta(274) = dot_product(vrrbuffer(:,64), D(:,90)) ! ((0,0,6)|(0,0,0))
        theta(319) = theta(246)+theta(225)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(382) = theta(274)+theta(246)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(472) = theta(382)+theta(319)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
    end subroutine
    subroutine blockhrr_4_3(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 658; Optimized integrals: 588
        ! (4,0,0|3,0,0): 10
        theta(331) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(346) = dot_product(vrrbuffer(:,16), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(367) = dot_product(vrrbuffer(:,37), D(:,1)) ! ((6,0,0)|(0,0,0))
        theta(395) = dot_product(vrrbuffer(:,65), D(:,1)) ! ((7,0,0)|(0,0,0))
        theta(431) = theta(346)+theta(331)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(476) = theta(367)+theta(346)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(539) = theta(395)+theta(367)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(623) = theta(476)+theta(431)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(713) = theta(539)+theta(476)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        theta(839) = theta(713)+theta(623)*AB(1) ! ((4,0,0)|(3,0,0)) = ((5,0,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(1)
        ! (4,0,0|2,1,0): 13
        theta(331) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((4,0,0)|(0,0,0))
        theta(346) = dot_product(vrrbuffer(:,16), D(:,2)) ! ((5,0,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,2)) ! ((4,1,0)|(0,0,0))
        theta(367) = dot_product(vrrbuffer(:,37), D(:,2)) ! ((6,0,0)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,2)) ! ((5,1,0)|(0,0,0))
        theta(396) = dot_product(vrrbuffer(:,66), D(:,2)) ! ((6,1,0)|(0,0,0))
        theta(431) = theta(346)+theta(331)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(476) = theta(367)+theta(346)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(479) = theta(368)+theta(347)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(542) = theta(396)+theta(368)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(623) = theta(476)+theta(431)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(719) = theta(542)+theta(479)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(840) = theta(719)+theta(623)*AB(2) ! ((4,0,0)|(2,1,0)) = ((4,1,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(2)
        ! (4,0,0|2,0,1): 13
        theta(331) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((4,0,0)|(0,0,0))
        theta(346) = dot_product(vrrbuffer(:,16), D(:,3)) ! ((5,0,0)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,3)) ! ((4,0,1)|(0,0,0))
        theta(367) = dot_product(vrrbuffer(:,37), D(:,3)) ! ((6,0,0)|(0,0,0))
        theta(369) = dot_product(vrrbuffer(:,39), D(:,3)) ! ((5,0,1)|(0,0,0))
        theta(397) = dot_product(vrrbuffer(:,67), D(:,3)) ! ((6,0,1)|(0,0,0))
        theta(431) = theta(346)+theta(331)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(476) = theta(367)+theta(346)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(482) = theta(369)+theta(348)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(545) = theta(397)+theta(369)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(623) = theta(476)+theta(431)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(725) = theta(545)+theta(482)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(841) = theta(725)+theta(623)*AB(3) ! ((4,0,0)|(2,0,1)) = ((4,0,1)|(2,0,0))+((4,0,0)|(2,0,0))*AB(3)
        ! (4,0,0|1,2,0): 13
        theta(331) = dot_product(vrrbuffer(:,1), D(:,4)) ! ((4,0,0)|(0,0,0))
        theta(346) = dot_product(vrrbuffer(:,16), D(:,4)) ! ((5,0,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,4)) ! ((4,1,0)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,4)) ! ((5,1,0)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,4)) ! ((4,2,0)|(0,0,0))
        theta(398) = dot_product(vrrbuffer(:,68), D(:,4)) ! ((5,2,0)|(0,0,0))
        theta(432) = theta(347)+theta(331)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(477) = theta(368)+theta(346)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(480) = theta(370)+theta(347)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(543) = theta(398)+theta(368)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(626) = theta(480)+theta(432)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(716) = theta(543)+theta(477)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        theta(842) = theta(716)+theta(626)*AB(1) ! ((4,0,0)|(1,2,0)) = ((5,0,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(1)
        ! (4,0,0|1,1,1): 15
        theta(331) = dot_product(vrrbuffer(:,1), D(:,5)) ! ((4,0,0)|(0,0,0))
        theta(346) = dot_product(vrrbuffer(:,16), D(:,5)) ! ((5,0,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,5)) ! ((4,1,0)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,5)) ! ((4,0,1)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,5)) ! ((5,1,0)|(0,0,0))
        theta(369) = dot_product(vrrbuffer(:,39), D(:,5)) ! ((5,0,1)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,5)) ! ((4,1,1)|(0,0,0))
        theta(399) = dot_product(vrrbuffer(:,69), D(:,5)) ! ((5,1,1)|(0,0,0))
        theta(433) = theta(348)+theta(331)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(478) = theta(369)+theta(346)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(481) = theta(371)+theta(347)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(544) = theta(399)+theta(368)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(627) = theta(481)+theta(433)*AB(2) ! ((4,0,0)|(0,1,1)) = ((4,1,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(2)
        theta(717) = theta(544)+theta(478)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        theta(843) = theta(717)+theta(627)*AB(1) ! ((4,0,0)|(1,1,1)) = ((5,0,0)|(0,1,1))+((4,0,0)|(0,1,1))*AB(1)
        ! (4,0,0|1,0,2): 13
        theta(331) = dot_product(vrrbuffer(:,1), D(:,6)) ! ((4,0,0)|(0,0,0))
        theta(346) = dot_product(vrrbuffer(:,16), D(:,6)) ! ((5,0,0)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,6)) ! ((4,0,1)|(0,0,0))
        theta(369) = dot_product(vrrbuffer(:,39), D(:,6)) ! ((5,0,1)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,6)) ! ((4,0,2)|(0,0,0))
        theta(400) = dot_product(vrrbuffer(:,70), D(:,6)) ! ((5,0,2)|(0,0,0))
        theta(433) = theta(348)+theta(331)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(478) = theta(369)+theta(346)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(484) = theta(372)+theta(348)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(547) = theta(400)+theta(369)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(628) = theta(484)+theta(433)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(718) = theta(547)+theta(478)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(844) = theta(718)+theta(628)*AB(1) ! ((4,0,0)|(1,0,2)) = ((5,0,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(1)
        ! (4,0,0|0,3,0): 10
        theta(331) = dot_product(vrrbuffer(:,1), D(:,7)) ! ((4,0,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,7)) ! ((4,1,0)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,7)) ! ((4,2,0)|(0,0,0))
        theta(401) = dot_product(vrrbuffer(:,71), D(:,7)) ! ((4,3,0)|(0,0,0))
        theta(432) = theta(347)+theta(331)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(480) = theta(370)+theta(347)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(549) = theta(401)+theta(370)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(626) = theta(480)+theta(432)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(722) = theta(549)+theta(480)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(845) = theta(722)+theta(626)*AB(2) ! ((4,0,0)|(0,3,0)) = ((4,1,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(2)
        ! (4,0,0|0,2,1): 13
        theta(331) = dot_product(vrrbuffer(:,1), D(:,8)) ! ((4,0,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,8)) ! ((4,1,0)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,8)) ! ((4,0,1)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,8)) ! ((4,2,0)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,8)) ! ((4,1,1)|(0,0,0))
        theta(402) = dot_product(vrrbuffer(:,72), D(:,8)) ! ((4,2,1)|(0,0,0))
        theta(432) = theta(347)+theta(331)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(480) = theta(370)+theta(347)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(483) = theta(371)+theta(348)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(552) = theta(402)+theta(371)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(626) = theta(480)+theta(432)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(728) = theta(552)+theta(483)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(846) = theta(728)+theta(626)*AB(3) ! ((4,0,0)|(0,2,1)) = ((4,0,1)|(0,2,0))+((4,0,0)|(0,2,0))*AB(3)
        ! (4,0,0|0,1,2): 13
        theta(331) = dot_product(vrrbuffer(:,1), D(:,9)) ! ((4,0,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,9)) ! ((4,1,0)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,9)) ! ((4,0,1)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,9)) ! ((4,1,1)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,9)) ! ((4,0,2)|(0,0,0))
        theta(403) = dot_product(vrrbuffer(:,73), D(:,9)) ! ((4,1,2)|(0,0,0))
        theta(433) = theta(348)+theta(331)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(481) = theta(371)+theta(347)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(484) = theta(372)+theta(348)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(553) = theta(403)+theta(371)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(628) = theta(484)+theta(433)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(724) = theta(553)+theta(481)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(847) = theta(724)+theta(628)*AB(2) ! ((4,0,0)|(0,1,2)) = ((4,1,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(2)
        ! (4,0,0|0,0,3): 10
        theta(331) = dot_product(vrrbuffer(:,1), D(:,10)) ! ((4,0,0)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,10)) ! ((4,0,1)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,10)) ! ((4,0,2)|(0,0,0))
        theta(404) = dot_product(vrrbuffer(:,74), D(:,10)) ! ((4,0,3)|(0,0,0))
        theta(433) = theta(348)+theta(331)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(484) = theta(372)+theta(348)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(556) = theta(404)+theta(372)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(628) = theta(484)+theta(433)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(730) = theta(556)+theta(484)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(848) = theta(730)+theta(628)*AB(3) ! ((4,0,0)|(0,0,3)) = ((4,0,1)|(0,0,2))+((4,0,0)|(0,0,2))*AB(3)
        ! (3,1,0|3,0,0): 10
        theta(332) = dot_product(vrrbuffer(:,2), D(:,11)) ! ((3,1,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,11)) ! ((4,1,0)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,11)) ! ((5,1,0)|(0,0,0))
        theta(396) = dot_product(vrrbuffer(:,66), D(:,11)) ! ((6,1,0)|(0,0,0))
        theta(434) = theta(347)+theta(332)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(479) = theta(368)+theta(347)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(542) = theta(396)+theta(368)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(629) = theta(479)+theta(434)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(719) = theta(542)+theta(479)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(849) = theta(719)+theta(629)*AB(1) ! ((3,1,0)|(3,0,0)) = ((4,1,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(1)
        ! (3,1,0|2,1,0): 13
        theta(332) = dot_product(vrrbuffer(:,2), D(:,12)) ! ((3,1,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,12)) ! ((4,1,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,12)) ! ((3,2,0)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,12)) ! ((5,1,0)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,12)) ! ((4,2,0)|(0,0,0))
        theta(398) = dot_product(vrrbuffer(:,68), D(:,12)) ! ((5,2,0)|(0,0,0))
        theta(434) = theta(347)+theta(332)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(479) = theta(368)+theta(347)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(485) = theta(370)+theta(349)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(548) = theta(398)+theta(370)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(629) = theta(479)+theta(434)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(731) = theta(548)+theta(485)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(850) = theta(731)+theta(629)*AB(2) ! ((3,1,0)|(2,1,0)) = ((3,2,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(2)
        ! (3,1,0|2,0,1): 13
        theta(332) = dot_product(vrrbuffer(:,2), D(:,13)) ! ((3,1,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,13)) ! ((4,1,0)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,13)) ! ((3,1,1)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,13)) ! ((5,1,0)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,13)) ! ((4,1,1)|(0,0,0))
        theta(399) = dot_product(vrrbuffer(:,69), D(:,13)) ! ((5,1,1)|(0,0,0))
        theta(434) = theta(347)+theta(332)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(479) = theta(368)+theta(347)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(488) = theta(371)+theta(350)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(551) = theta(399)+theta(371)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(629) = theta(479)+theta(434)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(737) = theta(551)+theta(488)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(851) = theta(737)+theta(629)*AB(3) ! ((3,1,0)|(2,0,1)) = ((3,1,1)|(2,0,0))+((3,1,0)|(2,0,0))*AB(3)
        ! (3,1,0|1,2,0): 13
        theta(332) = dot_product(vrrbuffer(:,2), D(:,14)) ! ((3,1,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,14)) ! ((4,1,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,14)) ! ((3,2,0)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,14)) ! ((4,2,0)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,14)) ! ((3,3,0)|(0,0,0))
        theta(401) = dot_product(vrrbuffer(:,71), D(:,14)) ! ((4,3,0)|(0,0,0))
        theta(435) = theta(349)+theta(332)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(480) = theta(370)+theta(347)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(486) = theta(373)+theta(349)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(549) = theta(401)+theta(370)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(632) = theta(486)+theta(435)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(722) = theta(549)+theta(480)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(852) = theta(722)+theta(632)*AB(1) ! ((3,1,0)|(1,2,0)) = ((4,1,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(1)
        ! (3,1,0|1,1,1): 15
        theta(332) = dot_product(vrrbuffer(:,2), D(:,15)) ! ((3,1,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,15)) ! ((4,1,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,15)) ! ((3,2,0)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,15)) ! ((3,1,1)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,15)) ! ((4,2,0)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,15)) ! ((4,1,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,15)) ! ((3,2,1)|(0,0,0))
        theta(402) = dot_product(vrrbuffer(:,72), D(:,15)) ! ((4,2,1)|(0,0,0))
        theta(436) = theta(350)+theta(332)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(481) = theta(371)+theta(347)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(487) = theta(374)+theta(349)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(550) = theta(402)+theta(370)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(633) = theta(487)+theta(436)*AB(2) ! ((3,1,0)|(0,1,1)) = ((3,2,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(2)
        theta(723) = theta(550)+theta(481)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        theta(853) = theta(723)+theta(633)*AB(1) ! ((3,1,0)|(1,1,1)) = ((4,1,0)|(0,1,1))+((3,1,0)|(0,1,1))*AB(1)
        ! (3,1,0|1,0,2): 13
        theta(332) = dot_product(vrrbuffer(:,2), D(:,16)) ! ((3,1,0)|(0,0,0))
        theta(347) = dot_product(vrrbuffer(:,17), D(:,16)) ! ((4,1,0)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,16)) ! ((3,1,1)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,16)) ! ((4,1,1)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,16)) ! ((3,1,2)|(0,0,0))
        theta(403) = dot_product(vrrbuffer(:,73), D(:,16)) ! ((4,1,2)|(0,0,0))
        theta(436) = theta(350)+theta(332)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(481) = theta(371)+theta(347)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(553) = theta(403)+theta(371)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(634) = theta(490)+theta(436)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(724) = theta(553)+theta(481)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(854) = theta(724)+theta(634)*AB(1) ! ((3,1,0)|(1,0,2)) = ((4,1,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(1)
        ! (3,1,0|0,3,0): 10
        theta(332) = dot_product(vrrbuffer(:,2), D(:,17)) ! ((3,1,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,17)) ! ((3,2,0)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,17)) ! ((3,3,0)|(0,0,0))
        theta(405) = dot_product(vrrbuffer(:,75), D(:,17)) ! ((3,4,0)|(0,0,0))
        theta(435) = theta(349)+theta(332)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(486) = theta(373)+theta(349)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(558) = theta(405)+theta(373)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(632) = theta(486)+theta(435)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(734) = theta(558)+theta(486)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(855) = theta(734)+theta(632)*AB(2) ! ((3,1,0)|(0,3,0)) = ((3,2,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(2)
        ! (3,1,0|0,2,1): 13
        theta(332) = dot_product(vrrbuffer(:,2), D(:,18)) ! ((3,1,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,18)) ! ((3,2,0)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,18)) ! ((3,1,1)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,18)) ! ((3,3,0)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,18)) ! ((3,2,1)|(0,0,0))
        theta(406) = dot_product(vrrbuffer(:,76), D(:,18)) ! ((3,3,1)|(0,0,0))
        theta(435) = theta(349)+theta(332)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(486) = theta(373)+theta(349)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(489) = theta(374)+theta(350)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(561) = theta(406)+theta(374)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(632) = theta(486)+theta(435)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(740) = theta(561)+theta(489)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(856) = theta(740)+theta(632)*AB(3) ! ((3,1,0)|(0,2,1)) = ((3,1,1)|(0,2,0))+((3,1,0)|(0,2,0))*AB(3)
        ! (3,1,0|0,1,2): 13
        theta(332) = dot_product(vrrbuffer(:,2), D(:,19)) ! ((3,1,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,19)) ! ((3,2,0)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,19)) ! ((3,1,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,19)) ! ((3,2,1)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,19)) ! ((3,1,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,19)) ! ((3,2,2)|(0,0,0))
        theta(436) = theta(350)+theta(332)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(487) = theta(374)+theta(349)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(562) = theta(407)+theta(374)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(634) = theta(490)+theta(436)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(736) = theta(562)+theta(487)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(857) = theta(736)+theta(634)*AB(2) ! ((3,1,0)|(0,1,2)) = ((3,2,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(2)
        ! (3,1,0|0,0,3): 10
        theta(332) = dot_product(vrrbuffer(:,2), D(:,20)) ! ((3,1,0)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,20)) ! ((3,1,1)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,20)) ! ((3,1,2)|(0,0,0))
        theta(408) = dot_product(vrrbuffer(:,78), D(:,20)) ! ((3,1,3)|(0,0,0))
        theta(436) = theta(350)+theta(332)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(565) = theta(408)+theta(375)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(634) = theta(490)+theta(436)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(742) = theta(565)+theta(490)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(858) = theta(742)+theta(634)*AB(3) ! ((3,1,0)|(0,0,3)) = ((3,1,1)|(0,0,2))+((3,1,0)|(0,0,2))*AB(3)
        ! (3,0,1|3,0,0): 10
        theta(333) = dot_product(vrrbuffer(:,3), D(:,21)) ! ((3,0,1)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,21)) ! ((4,0,1)|(0,0,0))
        theta(369) = dot_product(vrrbuffer(:,39), D(:,21)) ! ((5,0,1)|(0,0,0))
        theta(397) = dot_product(vrrbuffer(:,67), D(:,21)) ! ((6,0,1)|(0,0,0))
        theta(437) = theta(348)+theta(333)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(482) = theta(369)+theta(348)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(545) = theta(397)+theta(369)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(635) = theta(482)+theta(437)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(725) = theta(545)+theta(482)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(859) = theta(725)+theta(635)*AB(1) ! ((3,0,1)|(3,0,0)) = ((4,0,1)|(2,0,0))+((3,0,1)|(2,0,0))*AB(1)
        ! (3,0,1|2,1,0): 12
        theta(333) = dot_product(vrrbuffer(:,3), D(:,22)) ! ((3,0,1)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,22)) ! ((4,0,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,22)) ! ((3,1,1)|(0,0,0))
        theta(369) = dot_product(vrrbuffer(:,39), D(:,22)) ! ((5,0,1)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,22)) ! ((4,1,1)|(0,0,0))
        theta(399) = dot_product(vrrbuffer(:,69), D(:,22)) ! ((5,1,1)|(0,0,0))
        theta(438) = theta(350)+theta(333)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(483) = theta(371)+theta(348)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(546) = theta(399)+theta(369)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(636) = theta(483)+theta(438)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        theta(726) = theta(546)+theta(483)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        theta(860) = theta(726)+theta(636)*AB(1) ! ((3,0,1)|(2,1,0)) = ((4,0,1)|(1,1,0))+((3,0,1)|(1,1,0))*AB(1)
        ! (3,0,1|2,0,1): 13
        theta(333) = dot_product(vrrbuffer(:,3), D(:,23)) ! ((3,0,1)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,23)) ! ((4,0,1)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,23)) ! ((3,0,2)|(0,0,0))
        theta(369) = dot_product(vrrbuffer(:,39), D(:,23)) ! ((5,0,1)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,23)) ! ((4,0,2)|(0,0,0))
        theta(400) = dot_product(vrrbuffer(:,70), D(:,23)) ! ((5,0,2)|(0,0,0))
        theta(437) = theta(348)+theta(333)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(482) = theta(369)+theta(348)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(491) = theta(372)+theta(351)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(554) = theta(400)+theta(372)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(635) = theta(482)+theta(437)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(743) = theta(554)+theta(491)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(861) = theta(743)+theta(635)*AB(3) ! ((3,0,1)|(2,0,1)) = ((3,0,2)|(2,0,0))+((3,0,1)|(2,0,0))*AB(3)
        ! (3,0,1|1,2,0): 13
        theta(333) = dot_product(vrrbuffer(:,3), D(:,24)) ! ((3,0,1)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,24)) ! ((4,0,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,24)) ! ((3,1,1)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,24)) ! ((4,1,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,24)) ! ((3,2,1)|(0,0,0))
        theta(402) = dot_product(vrrbuffer(:,72), D(:,24)) ! ((4,2,1)|(0,0,0))
        theta(438) = theta(350)+theta(333)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(483) = theta(371)+theta(348)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(489) = theta(374)+theta(350)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(552) = theta(402)+theta(371)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(638) = theta(489)+theta(438)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(728) = theta(552)+theta(483)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(862) = theta(728)+theta(638)*AB(1) ! ((3,0,1)|(1,2,0)) = ((4,0,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(1)
        ! (3,0,1|1,1,1): 15
        theta(333) = dot_product(vrrbuffer(:,3), D(:,25)) ! ((3,0,1)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,25)) ! ((4,0,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,25)) ! ((3,1,1)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,25)) ! ((3,0,2)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,25)) ! ((4,1,1)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,25)) ! ((4,0,2)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,25)) ! ((3,1,2)|(0,0,0))
        theta(403) = dot_product(vrrbuffer(:,73), D(:,25)) ! ((4,1,2)|(0,0,0))
        theta(439) = theta(351)+theta(333)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(484) = theta(372)+theta(348)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(553) = theta(403)+theta(371)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(639) = theta(490)+theta(439)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        theta(729) = theta(553)+theta(484)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(863) = theta(729)+theta(639)*AB(1) ! ((3,0,1)|(1,1,1)) = ((4,0,1)|(0,1,1))+((3,0,1)|(0,1,1))*AB(1)
        ! (3,0,1|1,0,2): 13
        theta(333) = dot_product(vrrbuffer(:,3), D(:,26)) ! ((3,0,1)|(0,0,0))
        theta(348) = dot_product(vrrbuffer(:,18), D(:,26)) ! ((4,0,1)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,26)) ! ((3,0,2)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,26)) ! ((4,0,2)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,26)) ! ((3,0,3)|(0,0,0))
        theta(404) = dot_product(vrrbuffer(:,74), D(:,26)) ! ((4,0,3)|(0,0,0))
        theta(439) = theta(351)+theta(333)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(484) = theta(372)+theta(348)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(493) = theta(376)+theta(351)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(556) = theta(404)+theta(372)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(640) = theta(493)+theta(439)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(730) = theta(556)+theta(484)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(864) = theta(730)+theta(640)*AB(1) ! ((3,0,1)|(1,0,2)) = ((4,0,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(1)
        ! (3,0,1|0,3,0): 10
        theta(333) = dot_product(vrrbuffer(:,3), D(:,27)) ! ((3,0,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,27)) ! ((3,1,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,27)) ! ((3,2,1)|(0,0,0))
        theta(406) = dot_product(vrrbuffer(:,76), D(:,27)) ! ((3,3,1)|(0,0,0))
        theta(438) = theta(350)+theta(333)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(489) = theta(374)+theta(350)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(561) = theta(406)+theta(374)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(638) = theta(489)+theta(438)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(740) = theta(561)+theta(489)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(865) = theta(740)+theta(638)*AB(2) ! ((3,0,1)|(0,3,0)) = ((3,1,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(2)
        ! (3,0,1|0,2,1): 13
        theta(333) = dot_product(vrrbuffer(:,3), D(:,28)) ! ((3,0,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,28)) ! ((3,1,1)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,28)) ! ((3,0,2)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,28)) ! ((3,2,1)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,28)) ! ((3,1,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,28)) ! ((3,2,2)|(0,0,0))
        theta(438) = theta(350)+theta(333)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(489) = theta(374)+theta(350)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(492) = theta(375)+theta(351)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(564) = theta(407)+theta(375)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(638) = theta(489)+theta(438)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(746) = theta(564)+theta(492)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(866) = theta(746)+theta(638)*AB(3) ! ((3,0,1)|(0,2,1)) = ((3,0,2)|(0,2,0))+((3,0,1)|(0,2,0))*AB(3)
        ! (3,0,1|0,1,2): 13
        theta(333) = dot_product(vrrbuffer(:,3), D(:,29)) ! ((3,0,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,29)) ! ((3,1,1)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,29)) ! ((3,0,2)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,29)) ! ((3,1,2)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,29)) ! ((3,0,3)|(0,0,0))
        theta(408) = dot_product(vrrbuffer(:,78), D(:,29)) ! ((3,1,3)|(0,0,0))
        theta(439) = theta(351)+theta(333)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(493) = theta(376)+theta(351)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(565) = theta(408)+theta(375)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(640) = theta(493)+theta(439)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(742) = theta(565)+theta(490)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(867) = theta(742)+theta(640)*AB(2) ! ((3,0,1)|(0,1,2)) = ((3,1,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(2)
        ! (3,0,1|0,0,3): 10
        theta(333) = dot_product(vrrbuffer(:,3), D(:,30)) ! ((3,0,1)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,30)) ! ((3,0,2)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,30)) ! ((3,0,3)|(0,0,0))
        theta(409) = dot_product(vrrbuffer(:,79), D(:,30)) ! ((3,0,4)|(0,0,0))
        theta(439) = theta(351)+theta(333)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(493) = theta(376)+theta(351)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(568) = theta(409)+theta(376)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(640) = theta(493)+theta(439)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(748) = theta(568)+theta(493)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(868) = theta(748)+theta(640)*AB(3) ! ((3,0,1)|(0,0,3)) = ((3,0,2)|(0,0,2))+((3,0,1)|(0,0,2))*AB(3)
        ! (2,2,0|3,0,0): 10
        theta(334) = dot_product(vrrbuffer(:,4), D(:,31)) ! ((2,2,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,31)) ! ((3,2,0)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,31)) ! ((4,2,0)|(0,0,0))
        theta(398) = dot_product(vrrbuffer(:,68), D(:,31)) ! ((5,2,0)|(0,0,0))
        theta(440) = theta(349)+theta(334)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(485) = theta(370)+theta(349)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(548) = theta(398)+theta(370)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(641) = theta(485)+theta(440)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(731) = theta(548)+theta(485)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(869) = theta(731)+theta(641)*AB(1) ! ((2,2,0)|(3,0,0)) = ((3,2,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(1)
        ! (2,2,0|2,1,0): 13
        theta(334) = dot_product(vrrbuffer(:,4), D(:,32)) ! ((2,2,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,32)) ! ((3,2,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,32)) ! ((2,3,0)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,32)) ! ((4,2,0)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,32)) ! ((3,3,0)|(0,0,0))
        theta(401) = dot_product(vrrbuffer(:,71), D(:,32)) ! ((4,3,0)|(0,0,0))
        theta(440) = theta(349)+theta(334)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(485) = theta(370)+theta(349)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(494) = theta(373)+theta(352)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(557) = theta(401)+theta(373)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(641) = theta(485)+theta(440)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(749) = theta(557)+theta(494)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(870) = theta(749)+theta(641)*AB(2) ! ((2,2,0)|(2,1,0)) = ((2,3,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(2)
        ! (2,2,0|2,0,1): 13
        theta(334) = dot_product(vrrbuffer(:,4), D(:,33)) ! ((2,2,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,33)) ! ((3,2,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,33)) ! ((2,2,1)|(0,0,0))
        theta(370) = dot_product(vrrbuffer(:,40), D(:,33)) ! ((4,2,0)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,33)) ! ((3,2,1)|(0,0,0))
        theta(402) = dot_product(vrrbuffer(:,72), D(:,33)) ! ((4,2,1)|(0,0,0))
        theta(440) = theta(349)+theta(334)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(485) = theta(370)+theta(349)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(497) = theta(374)+theta(353)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(560) = theta(402)+theta(374)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(641) = theta(485)+theta(440)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(755) = theta(560)+theta(497)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(871) = theta(755)+theta(641)*AB(3) ! ((2,2,0)|(2,0,1)) = ((2,2,1)|(2,0,0))+((2,2,0)|(2,0,0))*AB(3)
        ! (2,2,0|1,2,0): 13
        theta(334) = dot_product(vrrbuffer(:,4), D(:,34)) ! ((2,2,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,34)) ! ((3,2,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,34)) ! ((2,3,0)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,34)) ! ((3,3,0)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,34)) ! ((2,4,0)|(0,0,0))
        theta(405) = dot_product(vrrbuffer(:,75), D(:,34)) ! ((3,4,0)|(0,0,0))
        theta(441) = theta(352)+theta(334)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(486) = theta(373)+theta(349)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(495) = theta(377)+theta(352)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(558) = theta(405)+theta(373)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(644) = theta(495)+theta(441)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(734) = theta(558)+theta(486)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(872) = theta(734)+theta(644)*AB(1) ! ((2,2,0)|(1,2,0)) = ((3,2,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(1)
        ! (2,2,0|1,1,1): 15
        theta(334) = dot_product(vrrbuffer(:,4), D(:,35)) ! ((2,2,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,35)) ! ((3,2,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,35)) ! ((2,3,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,35)) ! ((2,2,1)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,35)) ! ((3,3,0)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,35)) ! ((3,2,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,35)) ! ((2,3,1)|(0,0,0))
        theta(406) = dot_product(vrrbuffer(:,76), D(:,35)) ! ((3,3,1)|(0,0,0))
        theta(442) = theta(353)+theta(334)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(487) = theta(374)+theta(349)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(496) = theta(378)+theta(352)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(559) = theta(406)+theta(373)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(645) = theta(496)+theta(442)*AB(2) ! ((2,2,0)|(0,1,1)) = ((2,3,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(2)
        theta(735) = theta(559)+theta(487)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        theta(873) = theta(735)+theta(645)*AB(1) ! ((2,2,0)|(1,1,1)) = ((3,2,0)|(0,1,1))+((2,2,0)|(0,1,1))*AB(1)
        ! (2,2,0|1,0,2): 13
        theta(334) = dot_product(vrrbuffer(:,4), D(:,36)) ! ((2,2,0)|(0,0,0))
        theta(349) = dot_product(vrrbuffer(:,19), D(:,36)) ! ((3,2,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,36)) ! ((2,2,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,36)) ! ((3,2,1)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,36)) ! ((2,2,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,36)) ! ((3,2,2)|(0,0,0))
        theta(442) = theta(353)+theta(334)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(487) = theta(374)+theta(349)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(562) = theta(407)+theta(374)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(646) = theta(499)+theta(442)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(736) = theta(562)+theta(487)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(874) = theta(736)+theta(646)*AB(1) ! ((2,2,0)|(1,0,2)) = ((3,2,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(1)
        ! (2,2,0|0,3,0): 10
        theta(334) = dot_product(vrrbuffer(:,4), D(:,37)) ! ((2,2,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,37)) ! ((2,3,0)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,37)) ! ((2,4,0)|(0,0,0))
        theta(410) = dot_product(vrrbuffer(:,80), D(:,37)) ! ((2,5,0)|(0,0,0))
        theta(441) = theta(352)+theta(334)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(495) = theta(377)+theta(352)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(570) = theta(410)+theta(377)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(644) = theta(495)+theta(441)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(752) = theta(570)+theta(495)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(875) = theta(752)+theta(644)*AB(2) ! ((2,2,0)|(0,3,0)) = ((2,3,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(2)
        ! (2,2,0|0,2,1): 13
        theta(334) = dot_product(vrrbuffer(:,4), D(:,38)) ! ((2,2,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,38)) ! ((2,3,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,38)) ! ((2,2,1)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,38)) ! ((2,4,0)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,38)) ! ((2,3,1)|(0,0,0))
        theta(411) = dot_product(vrrbuffer(:,81), D(:,38)) ! ((2,4,1)|(0,0,0))
        theta(441) = theta(352)+theta(334)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(495) = theta(377)+theta(352)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(498) = theta(378)+theta(353)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(573) = theta(411)+theta(378)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(644) = theta(495)+theta(441)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(758) = theta(573)+theta(498)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(876) = theta(758)+theta(644)*AB(3) ! ((2,2,0)|(0,2,1)) = ((2,2,1)|(0,2,0))+((2,2,0)|(0,2,0))*AB(3)
        ! (2,2,0|0,1,2): 13
        theta(334) = dot_product(vrrbuffer(:,4), D(:,39)) ! ((2,2,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,39)) ! ((2,3,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,39)) ! ((2,2,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,39)) ! ((2,3,1)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,39)) ! ((2,2,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,39)) ! ((2,3,2)|(0,0,0))
        theta(442) = theta(353)+theta(334)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(496) = theta(378)+theta(352)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(574) = theta(412)+theta(378)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(646) = theta(499)+theta(442)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(754) = theta(574)+theta(496)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(877) = theta(754)+theta(646)*AB(2) ! ((2,2,0)|(0,1,2)) = ((2,3,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(2)
        ! (2,2,0|0,0,3): 10
        theta(334) = dot_product(vrrbuffer(:,4), D(:,40)) ! ((2,2,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,40)) ! ((2,2,1)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,40)) ! ((2,2,2)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,40)) ! ((2,2,3)|(0,0,0))
        theta(442) = theta(353)+theta(334)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(577) = theta(413)+theta(379)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(646) = theta(499)+theta(442)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(760) = theta(577)+theta(499)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(878) = theta(760)+theta(646)*AB(3) ! ((2,2,0)|(0,0,3)) = ((2,2,1)|(0,0,2))+((2,2,0)|(0,0,2))*AB(3)
        ! (2,1,1|3,0,0): 10
        theta(335) = dot_product(vrrbuffer(:,5), D(:,41)) ! ((2,1,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,41)) ! ((3,1,1)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,41)) ! ((4,1,1)|(0,0,0))
        theta(399) = dot_product(vrrbuffer(:,69), D(:,41)) ! ((5,1,1)|(0,0,0))
        theta(443) = theta(350)+theta(335)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(488) = theta(371)+theta(350)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(551) = theta(399)+theta(371)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(647) = theta(488)+theta(443)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(737) = theta(551)+theta(488)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(879) = theta(737)+theta(647)*AB(1) ! ((2,1,1)|(3,0,0)) = ((3,1,1)|(2,0,0))+((2,1,1)|(2,0,0))*AB(1)
        ! (2,1,1|2,1,0): 12
        theta(335) = dot_product(vrrbuffer(:,5), D(:,42)) ! ((2,1,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,42)) ! ((3,1,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,42)) ! ((2,2,1)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,42)) ! ((4,1,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,42)) ! ((3,2,1)|(0,0,0))
        theta(402) = dot_product(vrrbuffer(:,72), D(:,42)) ! ((4,2,1)|(0,0,0))
        theta(444) = theta(353)+theta(335)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(489) = theta(374)+theta(350)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(552) = theta(402)+theta(371)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(648) = theta(489)+theta(444)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        theta(738) = theta(552)+theta(489)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        theta(880) = theta(738)+theta(648)*AB(1) ! ((2,1,1)|(2,1,0)) = ((3,1,1)|(1,1,0))+((2,1,1)|(1,1,0))*AB(1)
        ! (2,1,1|2,0,1): 13
        theta(335) = dot_product(vrrbuffer(:,5), D(:,43)) ! ((2,1,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,43)) ! ((3,1,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,43)) ! ((2,1,2)|(0,0,0))
        theta(371) = dot_product(vrrbuffer(:,41), D(:,43)) ! ((4,1,1)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,43)) ! ((3,1,2)|(0,0,0))
        theta(403) = dot_product(vrrbuffer(:,73), D(:,43)) ! ((4,1,2)|(0,0,0))
        theta(443) = theta(350)+theta(335)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(488) = theta(371)+theta(350)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(500) = theta(375)+theta(354)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(563) = theta(403)+theta(375)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(647) = theta(488)+theta(443)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(761) = theta(563)+theta(500)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(881) = theta(761)+theta(647)*AB(3) ! ((2,1,1)|(2,0,1)) = ((2,1,2)|(2,0,0))+((2,1,1)|(2,0,0))*AB(3)
        ! (2,1,1|1,2,0): 13
        theta(335) = dot_product(vrrbuffer(:,5), D(:,44)) ! ((2,1,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,44)) ! ((3,1,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,44)) ! ((2,2,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,44)) ! ((3,2,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,44)) ! ((2,3,1)|(0,0,0))
        theta(406) = dot_product(vrrbuffer(:,76), D(:,44)) ! ((3,3,1)|(0,0,0))
        theta(444) = theta(353)+theta(335)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(489) = theta(374)+theta(350)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(498) = theta(378)+theta(353)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(561) = theta(406)+theta(374)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(650) = theta(498)+theta(444)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(740) = theta(561)+theta(489)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(882) = theta(740)+theta(650)*AB(1) ! ((2,1,1)|(1,2,0)) = ((3,1,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(1)
        ! (2,1,1|1,1,1): 15
        theta(335) = dot_product(vrrbuffer(:,5), D(:,45)) ! ((2,1,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,45)) ! ((3,1,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,45)) ! ((2,2,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,45)) ! ((2,1,2)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,45)) ! ((3,2,1)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,45)) ! ((3,1,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,45)) ! ((2,2,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,45)) ! ((3,2,2)|(0,0,0))
        theta(445) = theta(354)+theta(335)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(562) = theta(407)+theta(374)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(651) = theta(499)+theta(445)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        theta(741) = theta(562)+theta(490)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(883) = theta(741)+theta(651)*AB(1) ! ((2,1,1)|(1,1,1)) = ((3,1,1)|(0,1,1))+((2,1,1)|(0,1,1))*AB(1)
        ! (2,1,1|1,0,2): 13
        theta(335) = dot_product(vrrbuffer(:,5), D(:,46)) ! ((2,1,1)|(0,0,0))
        theta(350) = dot_product(vrrbuffer(:,20), D(:,46)) ! ((3,1,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,46)) ! ((2,1,2)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,46)) ! ((3,1,2)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,46)) ! ((2,1,3)|(0,0,0))
        theta(408) = dot_product(vrrbuffer(:,78), D(:,46)) ! ((3,1,3)|(0,0,0))
        theta(445) = theta(354)+theta(335)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(565) = theta(408)+theta(375)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(652) = theta(502)+theta(445)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(742) = theta(565)+theta(490)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(884) = theta(742)+theta(652)*AB(1) ! ((2,1,1)|(1,0,2)) = ((3,1,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(1)
        ! (2,1,1|0,3,0): 10
        theta(335) = dot_product(vrrbuffer(:,5), D(:,47)) ! ((2,1,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,47)) ! ((2,2,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,47)) ! ((2,3,1)|(0,0,0))
        theta(411) = dot_product(vrrbuffer(:,81), D(:,47)) ! ((2,4,1)|(0,0,0))
        theta(444) = theta(353)+theta(335)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(498) = theta(378)+theta(353)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(573) = theta(411)+theta(378)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(650) = theta(498)+theta(444)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(758) = theta(573)+theta(498)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(885) = theta(758)+theta(650)*AB(2) ! ((2,1,1)|(0,3,0)) = ((2,2,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(2)
        ! (2,1,1|0,2,1): 13
        theta(335) = dot_product(vrrbuffer(:,5), D(:,48)) ! ((2,1,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,48)) ! ((2,2,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,48)) ! ((2,1,2)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,48)) ! ((2,3,1)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,48)) ! ((2,2,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,48)) ! ((2,3,2)|(0,0,0))
        theta(444) = theta(353)+theta(335)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(498) = theta(378)+theta(353)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(501) = theta(379)+theta(354)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(576) = theta(412)+theta(379)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(650) = theta(498)+theta(444)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(764) = theta(576)+theta(501)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(886) = theta(764)+theta(650)*AB(3) ! ((2,1,1)|(0,2,1)) = ((2,1,2)|(0,2,0))+((2,1,1)|(0,2,0))*AB(3)
        ! (2,1,1|0,1,2): 13
        theta(335) = dot_product(vrrbuffer(:,5), D(:,49)) ! ((2,1,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,49)) ! ((2,2,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,49)) ! ((2,1,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,49)) ! ((2,2,2)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,49)) ! ((2,1,3)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,49)) ! ((2,2,3)|(0,0,0))
        theta(445) = theta(354)+theta(335)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(577) = theta(413)+theta(379)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(652) = theta(502)+theta(445)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(760) = theta(577)+theta(499)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(887) = theta(760)+theta(652)*AB(2) ! ((2,1,1)|(0,1,2)) = ((2,2,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(2)
        ! (2,1,1|0,0,3): 10
        theta(335) = dot_product(vrrbuffer(:,5), D(:,50)) ! ((2,1,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,50)) ! ((2,1,2)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,50)) ! ((2,1,3)|(0,0,0))
        theta(414) = dot_product(vrrbuffer(:,84), D(:,50)) ! ((2,1,4)|(0,0,0))
        theta(445) = theta(354)+theta(335)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(580) = theta(414)+theta(380)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(652) = theta(502)+theta(445)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(766) = theta(580)+theta(502)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(888) = theta(766)+theta(652)*AB(3) ! ((2,1,1)|(0,0,3)) = ((2,1,2)|(0,0,2))+((2,1,1)|(0,0,2))*AB(3)
        ! (2,0,2|3,0,0): 10
        theta(336) = dot_product(vrrbuffer(:,6), D(:,51)) ! ((2,0,2)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,51)) ! ((3,0,2)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,51)) ! ((4,0,2)|(0,0,0))
        theta(400) = dot_product(vrrbuffer(:,70), D(:,51)) ! ((5,0,2)|(0,0,0))
        theta(446) = theta(351)+theta(336)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(491) = theta(372)+theta(351)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(554) = theta(400)+theta(372)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(653) = theta(491)+theta(446)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(743) = theta(554)+theta(491)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(889) = theta(743)+theta(653)*AB(1) ! ((2,0,2)|(3,0,0)) = ((3,0,2)|(2,0,0))+((2,0,2)|(2,0,0))*AB(1)
        ! (2,0,2|2,1,0): 12
        theta(336) = dot_product(vrrbuffer(:,6), D(:,52)) ! ((2,0,2)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,52)) ! ((3,0,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,52)) ! ((2,1,2)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,52)) ! ((4,0,2)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,52)) ! ((3,1,2)|(0,0,0))
        theta(403) = dot_product(vrrbuffer(:,73), D(:,52)) ! ((4,1,2)|(0,0,0))
        theta(447) = theta(354)+theta(336)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(492) = theta(375)+theta(351)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(555) = theta(403)+theta(372)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(654) = theta(492)+theta(447)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        theta(744) = theta(555)+theta(492)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        theta(890) = theta(744)+theta(654)*AB(1) ! ((2,0,2)|(2,1,0)) = ((3,0,2)|(1,1,0))+((2,0,2)|(1,1,0))*AB(1)
        ! (2,0,2|2,0,1): 13
        theta(336) = dot_product(vrrbuffer(:,6), D(:,53)) ! ((2,0,2)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,53)) ! ((3,0,2)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,53)) ! ((2,0,3)|(0,0,0))
        theta(372) = dot_product(vrrbuffer(:,42), D(:,53)) ! ((4,0,2)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,53)) ! ((3,0,3)|(0,0,0))
        theta(404) = dot_product(vrrbuffer(:,74), D(:,53)) ! ((4,0,3)|(0,0,0))
        theta(446) = theta(351)+theta(336)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(491) = theta(372)+theta(351)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(503) = theta(376)+theta(355)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(566) = theta(404)+theta(376)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(653) = theta(491)+theta(446)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(767) = theta(566)+theta(503)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(891) = theta(767)+theta(653)*AB(3) ! ((2,0,2)|(2,0,1)) = ((2,0,3)|(2,0,0))+((2,0,2)|(2,0,0))*AB(3)
        ! (2,0,2|1,2,0): 13
        theta(336) = dot_product(vrrbuffer(:,6), D(:,54)) ! ((2,0,2)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,54)) ! ((3,0,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,54)) ! ((2,1,2)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,54)) ! ((3,1,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,54)) ! ((2,2,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,54)) ! ((3,2,2)|(0,0,0))
        theta(447) = theta(354)+theta(336)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(492) = theta(375)+theta(351)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(501) = theta(379)+theta(354)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(564) = theta(407)+theta(375)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(656) = theta(501)+theta(447)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(746) = theta(564)+theta(492)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(892) = theta(746)+theta(656)*AB(1) ! ((2,0,2)|(1,2,0)) = ((3,0,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(1)
        ! (2,0,2|1,1,1): 15
        theta(336) = dot_product(vrrbuffer(:,6), D(:,55)) ! ((2,0,2)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,55)) ! ((3,0,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,55)) ! ((2,1,2)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,55)) ! ((2,0,3)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,55)) ! ((3,1,2)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,55)) ! ((3,0,3)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,55)) ! ((2,1,3)|(0,0,0))
        theta(408) = dot_product(vrrbuffer(:,78), D(:,55)) ! ((3,1,3)|(0,0,0))
        theta(448) = theta(355)+theta(336)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(493) = theta(376)+theta(351)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(565) = theta(408)+theta(375)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(657) = theta(502)+theta(448)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        theta(747) = theta(565)+theta(493)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(893) = theta(747)+theta(657)*AB(1) ! ((2,0,2)|(1,1,1)) = ((3,0,2)|(0,1,1))+((2,0,2)|(0,1,1))*AB(1)
        ! (2,0,2|1,0,2): 13
        theta(336) = dot_product(vrrbuffer(:,6), D(:,56)) ! ((2,0,2)|(0,0,0))
        theta(351) = dot_product(vrrbuffer(:,21), D(:,56)) ! ((3,0,2)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,56)) ! ((2,0,3)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,56)) ! ((3,0,3)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,56)) ! ((2,0,4)|(0,0,0))
        theta(409) = dot_product(vrrbuffer(:,79), D(:,56)) ! ((3,0,4)|(0,0,0))
        theta(448) = theta(355)+theta(336)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(493) = theta(376)+theta(351)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(505) = theta(381)+theta(355)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(568) = theta(409)+theta(376)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(658) = theta(505)+theta(448)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(748) = theta(568)+theta(493)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(894) = theta(748)+theta(658)*AB(1) ! ((2,0,2)|(1,0,2)) = ((3,0,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(1)
        ! (2,0,2|0,3,0): 10
        theta(336) = dot_product(vrrbuffer(:,6), D(:,57)) ! ((2,0,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,57)) ! ((2,1,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,57)) ! ((2,2,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,57)) ! ((2,3,2)|(0,0,0))
        theta(447) = theta(354)+theta(336)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(501) = theta(379)+theta(354)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(576) = theta(412)+theta(379)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(656) = theta(501)+theta(447)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(764) = theta(576)+theta(501)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(895) = theta(764)+theta(656)*AB(2) ! ((2,0,2)|(0,3,0)) = ((2,1,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(2)
        ! (2,0,2|0,2,1): 13
        theta(336) = dot_product(vrrbuffer(:,6), D(:,58)) ! ((2,0,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,58)) ! ((2,1,2)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,58)) ! ((2,0,3)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,58)) ! ((2,2,2)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,58)) ! ((2,1,3)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,58)) ! ((2,2,3)|(0,0,0))
        theta(447) = theta(354)+theta(336)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(501) = theta(379)+theta(354)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(504) = theta(380)+theta(355)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(579) = theta(413)+theta(380)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(656) = theta(501)+theta(447)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(770) = theta(579)+theta(504)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(896) = theta(770)+theta(656)*AB(3) ! ((2,0,2)|(0,2,1)) = ((2,0,3)|(0,2,0))+((2,0,2)|(0,2,0))*AB(3)
        ! (2,0,2|0,1,2): 13
        theta(336) = dot_product(vrrbuffer(:,6), D(:,59)) ! ((2,0,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,59)) ! ((2,1,2)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,59)) ! ((2,0,3)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,59)) ! ((2,1,3)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,59)) ! ((2,0,4)|(0,0,0))
        theta(414) = dot_product(vrrbuffer(:,84), D(:,59)) ! ((2,1,4)|(0,0,0))
        theta(448) = theta(355)+theta(336)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(505) = theta(381)+theta(355)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(580) = theta(414)+theta(380)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(658) = theta(505)+theta(448)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(766) = theta(580)+theta(502)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(897) = theta(766)+theta(658)*AB(2) ! ((2,0,2)|(0,1,2)) = ((2,1,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(2)
        ! (2,0,2|0,0,3): 10
        theta(336) = dot_product(vrrbuffer(:,6), D(:,60)) ! ((2,0,2)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,60)) ! ((2,0,3)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,60)) ! ((2,0,4)|(0,0,0))
        theta(415) = dot_product(vrrbuffer(:,85), D(:,60)) ! ((2,0,5)|(0,0,0))
        theta(448) = theta(355)+theta(336)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(505) = theta(381)+theta(355)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(583) = theta(415)+theta(381)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(658) = theta(505)+theta(448)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(772) = theta(583)+theta(505)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(898) = theta(772)+theta(658)*AB(3) ! ((2,0,2)|(0,0,3)) = ((2,0,3)|(0,0,2))+((2,0,2)|(0,0,2))*AB(3)
        ! (1,3,0|3,0,0): 10
        theta(337) = dot_product(vrrbuffer(:,7), D(:,61)) ! ((1,3,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,61)) ! ((2,3,0)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,61)) ! ((3,3,0)|(0,0,0))
        theta(401) = dot_product(vrrbuffer(:,71), D(:,61)) ! ((4,3,0)|(0,0,0))
        theta(449) = theta(352)+theta(337)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(494) = theta(373)+theta(352)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(557) = theta(401)+theta(373)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(659) = theta(494)+theta(449)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(749) = theta(557)+theta(494)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(899) = theta(749)+theta(659)*AB(1) ! ((1,3,0)|(3,0,0)) = ((2,3,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(1)
        ! (1,3,0|2,1,0): 13
        theta(337) = dot_product(vrrbuffer(:,7), D(:,62)) ! ((1,3,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,62)) ! ((2,3,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,62)) ! ((1,4,0)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,62)) ! ((3,3,0)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,62)) ! ((2,4,0)|(0,0,0))
        theta(405) = dot_product(vrrbuffer(:,75), D(:,62)) ! ((3,4,0)|(0,0,0))
        theta(449) = theta(352)+theta(337)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(494) = theta(373)+theta(352)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(506) = theta(377)+theta(356)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(569) = theta(405)+theta(377)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(659) = theta(494)+theta(449)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(773) = theta(569)+theta(506)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(900) = theta(773)+theta(659)*AB(2) ! ((1,3,0)|(2,1,0)) = ((1,4,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(2)
        ! (1,3,0|2,0,1): 13
        theta(337) = dot_product(vrrbuffer(:,7), D(:,63)) ! ((1,3,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,63)) ! ((2,3,0)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,63)) ! ((1,3,1)|(0,0,0))
        theta(373) = dot_product(vrrbuffer(:,43), D(:,63)) ! ((3,3,0)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,63)) ! ((2,3,1)|(0,0,0))
        theta(406) = dot_product(vrrbuffer(:,76), D(:,63)) ! ((3,3,1)|(0,0,0))
        theta(449) = theta(352)+theta(337)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(494) = theta(373)+theta(352)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(509) = theta(378)+theta(357)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(572) = theta(406)+theta(378)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(659) = theta(494)+theta(449)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(779) = theta(572)+theta(509)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(901) = theta(779)+theta(659)*AB(3) ! ((1,3,0)|(2,0,1)) = ((1,3,1)|(2,0,0))+((1,3,0)|(2,0,0))*AB(3)
        ! (1,3,0|1,2,0): 13
        theta(337) = dot_product(vrrbuffer(:,7), D(:,64)) ! ((1,3,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,64)) ! ((2,3,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,64)) ! ((1,4,0)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,64)) ! ((2,4,0)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,64)) ! ((1,5,0)|(0,0,0))
        theta(410) = dot_product(vrrbuffer(:,80), D(:,64)) ! ((2,5,0)|(0,0,0))
        theta(450) = theta(356)+theta(337)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(495) = theta(377)+theta(352)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(507) = theta(382)+theta(356)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(570) = theta(410)+theta(377)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(662) = theta(507)+theta(450)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(752) = theta(570)+theta(495)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(902) = theta(752)+theta(662)*AB(1) ! ((1,3,0)|(1,2,0)) = ((2,3,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(1)
        ! (1,3,0|1,1,1): 15
        theta(337) = dot_product(vrrbuffer(:,7), D(:,65)) ! ((1,3,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,65)) ! ((2,3,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,65)) ! ((1,4,0)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,65)) ! ((1,3,1)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,65)) ! ((2,4,0)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,65)) ! ((2,3,1)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,65)) ! ((1,4,1)|(0,0,0))
        theta(411) = dot_product(vrrbuffer(:,81), D(:,65)) ! ((2,4,1)|(0,0,0))
        theta(451) = theta(357)+theta(337)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(496) = theta(378)+theta(352)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(508) = theta(383)+theta(356)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(571) = theta(411)+theta(377)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(663) = theta(508)+theta(451)*AB(2) ! ((1,3,0)|(0,1,1)) = ((1,4,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(2)
        theta(753) = theta(571)+theta(496)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        theta(903) = theta(753)+theta(663)*AB(1) ! ((1,3,0)|(1,1,1)) = ((2,3,0)|(0,1,1))+((1,3,0)|(0,1,1))*AB(1)
        ! (1,3,0|1,0,2): 13
        theta(337) = dot_product(vrrbuffer(:,7), D(:,66)) ! ((1,3,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,66)) ! ((2,3,0)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,66)) ! ((1,3,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,66)) ! ((2,3,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,66)) ! ((1,3,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,66)) ! ((2,3,2)|(0,0,0))
        theta(451) = theta(357)+theta(337)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(496) = theta(378)+theta(352)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(574) = theta(412)+theta(378)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(664) = theta(511)+theta(451)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(754) = theta(574)+theta(496)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(904) = theta(754)+theta(664)*AB(1) ! ((1,3,0)|(1,0,2)) = ((2,3,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(1)
        ! (1,3,0|0,3,0): 10
        theta(337) = dot_product(vrrbuffer(:,7), D(:,67)) ! ((1,3,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,67)) ! ((1,4,0)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,67)) ! ((1,5,0)|(0,0,0))
        theta(416) = dot_product(vrrbuffer(:,86), D(:,67)) ! ((1,6,0)|(0,0,0))
        theta(450) = theta(356)+theta(337)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(507) = theta(382)+theta(356)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(585) = theta(416)+theta(382)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(662) = theta(507)+theta(450)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(776) = theta(585)+theta(507)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(905) = theta(776)+theta(662)*AB(2) ! ((1,3,0)|(0,3,0)) = ((1,4,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(2)
        ! (1,3,0|0,2,1): 13
        theta(337) = dot_product(vrrbuffer(:,7), D(:,68)) ! ((1,3,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,68)) ! ((1,4,0)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,68)) ! ((1,3,1)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,68)) ! ((1,5,0)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,68)) ! ((1,4,1)|(0,0,0))
        theta(417) = dot_product(vrrbuffer(:,87), D(:,68)) ! ((1,5,1)|(0,0,0))
        theta(450) = theta(356)+theta(337)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(507) = theta(382)+theta(356)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(510) = theta(383)+theta(357)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(588) = theta(417)+theta(383)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(662) = theta(507)+theta(450)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(782) = theta(588)+theta(510)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(906) = theta(782)+theta(662)*AB(3) ! ((1,3,0)|(0,2,1)) = ((1,3,1)|(0,2,0))+((1,3,0)|(0,2,0))*AB(3)
        ! (1,3,0|0,1,2): 13
        theta(337) = dot_product(vrrbuffer(:,7), D(:,69)) ! ((1,3,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,69)) ! ((1,4,0)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,69)) ! ((1,3,1)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,69)) ! ((1,4,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,69)) ! ((1,3,2)|(0,0,0))
        theta(418) = dot_product(vrrbuffer(:,88), D(:,69)) ! ((1,4,2)|(0,0,0))
        theta(451) = theta(357)+theta(337)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(508) = theta(383)+theta(356)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(589) = theta(418)+theta(383)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(664) = theta(511)+theta(451)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(778) = theta(589)+theta(508)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(907) = theta(778)+theta(664)*AB(2) ! ((1,3,0)|(0,1,2)) = ((1,4,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(2)
        ! (1,3,0|0,0,3): 10
        theta(337) = dot_product(vrrbuffer(:,7), D(:,70)) ! ((1,3,0)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,70)) ! ((1,3,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,70)) ! ((1,3,2)|(0,0,0))
        theta(419) = dot_product(vrrbuffer(:,89), D(:,70)) ! ((1,3,3)|(0,0,0))
        theta(451) = theta(357)+theta(337)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(592) = theta(419)+theta(384)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(664) = theta(511)+theta(451)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(784) = theta(592)+theta(511)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(908) = theta(784)+theta(664)*AB(3) ! ((1,3,0)|(0,0,3)) = ((1,3,1)|(0,0,2))+((1,3,0)|(0,0,2))*AB(3)
        ! (1,2,1|3,0,0): 10
        theta(338) = dot_product(vrrbuffer(:,8), D(:,71)) ! ((1,2,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,71)) ! ((2,2,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,71)) ! ((3,2,1)|(0,0,0))
        theta(402) = dot_product(vrrbuffer(:,72), D(:,71)) ! ((4,2,1)|(0,0,0))
        theta(452) = theta(353)+theta(338)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(497) = theta(374)+theta(353)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(560) = theta(402)+theta(374)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(665) = theta(497)+theta(452)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(755) = theta(560)+theta(497)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(909) = theta(755)+theta(665)*AB(1) ! ((1,2,1)|(3,0,0)) = ((2,2,1)|(2,0,0))+((1,2,1)|(2,0,0))*AB(1)
        ! (1,2,1|2,1,0): 12
        theta(338) = dot_product(vrrbuffer(:,8), D(:,72)) ! ((1,2,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,72)) ! ((2,2,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,72)) ! ((1,3,1)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,72)) ! ((3,2,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,72)) ! ((2,3,1)|(0,0,0))
        theta(406) = dot_product(vrrbuffer(:,76), D(:,72)) ! ((3,3,1)|(0,0,0))
        theta(453) = theta(357)+theta(338)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(498) = theta(378)+theta(353)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(561) = theta(406)+theta(374)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(666) = theta(498)+theta(453)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        theta(756) = theta(561)+theta(498)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        theta(910) = theta(756)+theta(666)*AB(1) ! ((1,2,1)|(2,1,0)) = ((2,2,1)|(1,1,0))+((1,2,1)|(1,1,0))*AB(1)
        ! (1,2,1|2,0,1): 13
        theta(338) = dot_product(vrrbuffer(:,8), D(:,73)) ! ((1,2,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,73)) ! ((2,2,1)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,73)) ! ((1,2,2)|(0,0,0))
        theta(374) = dot_product(vrrbuffer(:,44), D(:,73)) ! ((3,2,1)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,73)) ! ((2,2,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,73)) ! ((3,2,2)|(0,0,0))
        theta(452) = theta(353)+theta(338)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(497) = theta(374)+theta(353)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(512) = theta(379)+theta(358)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(575) = theta(407)+theta(379)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(665) = theta(497)+theta(452)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(785) = theta(575)+theta(512)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(911) = theta(785)+theta(665)*AB(3) ! ((1,2,1)|(2,0,1)) = ((1,2,2)|(2,0,0))+((1,2,1)|(2,0,0))*AB(3)
        ! (1,2,1|1,2,0): 13
        theta(338) = dot_product(vrrbuffer(:,8), D(:,74)) ! ((1,2,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,74)) ! ((2,2,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,74)) ! ((1,3,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,74)) ! ((2,3,1)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,74)) ! ((1,4,1)|(0,0,0))
        theta(411) = dot_product(vrrbuffer(:,81), D(:,74)) ! ((2,4,1)|(0,0,0))
        theta(453) = theta(357)+theta(338)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(498) = theta(378)+theta(353)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(510) = theta(383)+theta(357)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(573) = theta(411)+theta(378)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(668) = theta(510)+theta(453)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(758) = theta(573)+theta(498)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(912) = theta(758)+theta(668)*AB(1) ! ((1,2,1)|(1,2,0)) = ((2,2,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(1)
        ! (1,2,1|1,1,1): 15
        theta(338) = dot_product(vrrbuffer(:,8), D(:,75)) ! ((1,2,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,75)) ! ((2,2,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,75)) ! ((1,3,1)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,75)) ! ((1,2,2)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,75)) ! ((2,3,1)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,75)) ! ((2,2,2)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,75)) ! ((1,3,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,75)) ! ((2,3,2)|(0,0,0))
        theta(454) = theta(358)+theta(338)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(574) = theta(412)+theta(378)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(669) = theta(511)+theta(454)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        theta(759) = theta(574)+theta(499)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(913) = theta(759)+theta(669)*AB(1) ! ((1,2,1)|(1,1,1)) = ((2,2,1)|(0,1,1))+((1,2,1)|(0,1,1))*AB(1)
        ! (1,2,1|1,0,2): 13
        theta(338) = dot_product(vrrbuffer(:,8), D(:,76)) ! ((1,2,1)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,76)) ! ((2,2,1)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,76)) ! ((1,2,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,76)) ! ((2,2,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,76)) ! ((1,2,3)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,76)) ! ((2,2,3)|(0,0,0))
        theta(454) = theta(358)+theta(338)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(577) = theta(413)+theta(379)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(670) = theta(514)+theta(454)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(760) = theta(577)+theta(499)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(914) = theta(760)+theta(670)*AB(1) ! ((1,2,1)|(1,0,2)) = ((2,2,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(1)
        ! (1,2,1|0,3,0): 10
        theta(338) = dot_product(vrrbuffer(:,8), D(:,77)) ! ((1,2,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,77)) ! ((1,3,1)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,77)) ! ((1,4,1)|(0,0,0))
        theta(417) = dot_product(vrrbuffer(:,87), D(:,77)) ! ((1,5,1)|(0,0,0))
        theta(453) = theta(357)+theta(338)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(510) = theta(383)+theta(357)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(588) = theta(417)+theta(383)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(668) = theta(510)+theta(453)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(782) = theta(588)+theta(510)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(915) = theta(782)+theta(668)*AB(2) ! ((1,2,1)|(0,3,0)) = ((1,3,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(2)
        ! (1,2,1|0,2,1): 13
        theta(338) = dot_product(vrrbuffer(:,8), D(:,78)) ! ((1,2,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,78)) ! ((1,3,1)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,78)) ! ((1,2,2)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,78)) ! ((1,4,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,78)) ! ((1,3,2)|(0,0,0))
        theta(418) = dot_product(vrrbuffer(:,88), D(:,78)) ! ((1,4,2)|(0,0,0))
        theta(453) = theta(357)+theta(338)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(510) = theta(383)+theta(357)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(513) = theta(384)+theta(358)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(591) = theta(418)+theta(384)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(668) = theta(510)+theta(453)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(788) = theta(591)+theta(513)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(916) = theta(788)+theta(668)*AB(3) ! ((1,2,1)|(0,2,1)) = ((1,2,2)|(0,2,0))+((1,2,1)|(0,2,0))*AB(3)
        ! (1,2,1|0,1,2): 13
        theta(338) = dot_product(vrrbuffer(:,8), D(:,79)) ! ((1,2,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,79)) ! ((1,3,1)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,79)) ! ((1,2,2)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,79)) ! ((1,3,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,79)) ! ((1,2,3)|(0,0,0))
        theta(419) = dot_product(vrrbuffer(:,89), D(:,79)) ! ((1,3,3)|(0,0,0))
        theta(454) = theta(358)+theta(338)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(592) = theta(419)+theta(384)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(670) = theta(514)+theta(454)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(784) = theta(592)+theta(511)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(917) = theta(784)+theta(670)*AB(2) ! ((1,2,1)|(0,1,2)) = ((1,3,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(2)
        ! (1,2,1|0,0,3): 10
        theta(338) = dot_product(vrrbuffer(:,8), D(:,80)) ! ((1,2,1)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,80)) ! ((1,2,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,80)) ! ((1,2,3)|(0,0,0))
        theta(420) = dot_product(vrrbuffer(:,90), D(:,80)) ! ((1,2,4)|(0,0,0))
        theta(454) = theta(358)+theta(338)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(595) = theta(420)+theta(385)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(670) = theta(514)+theta(454)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(790) = theta(595)+theta(514)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(918) = theta(790)+theta(670)*AB(3) ! ((1,2,1)|(0,0,3)) = ((1,2,2)|(0,0,2))+((1,2,1)|(0,0,2))*AB(3)
        ! (1,1,2|3,0,0): 10
        theta(339) = dot_product(vrrbuffer(:,9), D(:,81)) ! ((1,1,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,81)) ! ((2,1,2)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,81)) ! ((3,1,2)|(0,0,0))
        theta(403) = dot_product(vrrbuffer(:,73), D(:,81)) ! ((4,1,2)|(0,0,0))
        theta(455) = theta(354)+theta(339)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(500) = theta(375)+theta(354)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(563) = theta(403)+theta(375)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(671) = theta(500)+theta(455)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(761) = theta(563)+theta(500)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(919) = theta(761)+theta(671)*AB(1) ! ((1,1,2)|(3,0,0)) = ((2,1,2)|(2,0,0))+((1,1,2)|(2,0,0))*AB(1)
        ! (1,1,2|2,1,0): 12
        theta(339) = dot_product(vrrbuffer(:,9), D(:,82)) ! ((1,1,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,82)) ! ((2,1,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,82)) ! ((1,2,2)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,82)) ! ((3,1,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,82)) ! ((2,2,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,82)) ! ((3,2,2)|(0,0,0))
        theta(456) = theta(358)+theta(339)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(501) = theta(379)+theta(354)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(564) = theta(407)+theta(375)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(672) = theta(501)+theta(456)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        theta(762) = theta(564)+theta(501)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        theta(920) = theta(762)+theta(672)*AB(1) ! ((1,1,2)|(2,1,0)) = ((2,1,2)|(1,1,0))+((1,1,2)|(1,1,0))*AB(1)
        ! (1,1,2|2,0,1): 13
        theta(339) = dot_product(vrrbuffer(:,9), D(:,83)) ! ((1,1,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,83)) ! ((2,1,2)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,83)) ! ((1,1,3)|(0,0,0))
        theta(375) = dot_product(vrrbuffer(:,45), D(:,83)) ! ((3,1,2)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,83)) ! ((2,1,3)|(0,0,0))
        theta(408) = dot_product(vrrbuffer(:,78), D(:,83)) ! ((3,1,3)|(0,0,0))
        theta(455) = theta(354)+theta(339)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(500) = theta(375)+theta(354)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(515) = theta(380)+theta(359)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(578) = theta(408)+theta(380)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(671) = theta(500)+theta(455)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(791) = theta(578)+theta(515)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(921) = theta(791)+theta(671)*AB(3) ! ((1,1,2)|(2,0,1)) = ((1,1,3)|(2,0,0))+((1,1,2)|(2,0,0))*AB(3)
        ! (1,1,2|1,2,0): 13
        theta(339) = dot_product(vrrbuffer(:,9), D(:,84)) ! ((1,1,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,84)) ! ((2,1,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,84)) ! ((1,2,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,84)) ! ((2,2,2)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,84)) ! ((1,3,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,84)) ! ((2,3,2)|(0,0,0))
        theta(456) = theta(358)+theta(339)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(501) = theta(379)+theta(354)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(513) = theta(384)+theta(358)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(576) = theta(412)+theta(379)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(674) = theta(513)+theta(456)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(764) = theta(576)+theta(501)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(922) = theta(764)+theta(674)*AB(1) ! ((1,1,2)|(1,2,0)) = ((2,1,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(1)
        ! (1,1,2|1,1,1): 15
        theta(339) = dot_product(vrrbuffer(:,9), D(:,85)) ! ((1,1,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,85)) ! ((2,1,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,85)) ! ((1,2,2)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,85)) ! ((1,1,3)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,85)) ! ((2,2,2)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,85)) ! ((2,1,3)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,85)) ! ((1,2,3)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,85)) ! ((2,2,3)|(0,0,0))
        theta(457) = theta(359)+theta(339)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(577) = theta(413)+theta(379)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(675) = theta(514)+theta(457)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        theta(765) = theta(577)+theta(502)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(923) = theta(765)+theta(675)*AB(1) ! ((1,1,2)|(1,1,1)) = ((2,1,2)|(0,1,1))+((1,1,2)|(0,1,1))*AB(1)
        ! (1,1,2|1,0,2): 13
        theta(339) = dot_product(vrrbuffer(:,9), D(:,86)) ! ((1,1,2)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,86)) ! ((2,1,2)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,86)) ! ((1,1,3)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,86)) ! ((2,1,3)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,86)) ! ((1,1,4)|(0,0,0))
        theta(414) = dot_product(vrrbuffer(:,84), D(:,86)) ! ((2,1,4)|(0,0,0))
        theta(457) = theta(359)+theta(339)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(580) = theta(414)+theta(380)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(676) = theta(517)+theta(457)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(766) = theta(580)+theta(502)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(924) = theta(766)+theta(676)*AB(1) ! ((1,1,2)|(1,0,2)) = ((2,1,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(1)
        ! (1,1,2|0,3,0): 10
        theta(339) = dot_product(vrrbuffer(:,9), D(:,87)) ! ((1,1,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,87)) ! ((1,2,2)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,87)) ! ((1,3,2)|(0,0,0))
        theta(418) = dot_product(vrrbuffer(:,88), D(:,87)) ! ((1,4,2)|(0,0,0))
        theta(456) = theta(358)+theta(339)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(513) = theta(384)+theta(358)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(591) = theta(418)+theta(384)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(674) = theta(513)+theta(456)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(788) = theta(591)+theta(513)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(925) = theta(788)+theta(674)*AB(2) ! ((1,1,2)|(0,3,0)) = ((1,2,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(2)
        ! (1,1,2|0,2,1): 13
        theta(339) = dot_product(vrrbuffer(:,9), D(:,88)) ! ((1,1,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,88)) ! ((1,2,2)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,88)) ! ((1,1,3)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,88)) ! ((1,3,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,88)) ! ((1,2,3)|(0,0,0))
        theta(419) = dot_product(vrrbuffer(:,89), D(:,88)) ! ((1,3,3)|(0,0,0))
        theta(456) = theta(358)+theta(339)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(513) = theta(384)+theta(358)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(516) = theta(385)+theta(359)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(594) = theta(419)+theta(385)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(674) = theta(513)+theta(456)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(794) = theta(594)+theta(516)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(926) = theta(794)+theta(674)*AB(3) ! ((1,1,2)|(0,2,1)) = ((1,1,3)|(0,2,0))+((1,1,2)|(0,2,0))*AB(3)
        ! (1,1,2|0,1,2): 13
        theta(339) = dot_product(vrrbuffer(:,9), D(:,89)) ! ((1,1,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,89)) ! ((1,2,2)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,89)) ! ((1,1,3)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,89)) ! ((1,2,3)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,89)) ! ((1,1,4)|(0,0,0))
        theta(420) = dot_product(vrrbuffer(:,90), D(:,89)) ! ((1,2,4)|(0,0,0))
        theta(457) = theta(359)+theta(339)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(595) = theta(420)+theta(385)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(676) = theta(517)+theta(457)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(790) = theta(595)+theta(514)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(927) = theta(790)+theta(676)*AB(2) ! ((1,1,2)|(0,1,2)) = ((1,2,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(2)
        ! (1,1,2|0,0,3): 10
        theta(339) = dot_product(vrrbuffer(:,9), D(:,90)) ! ((1,1,2)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,90)) ! ((1,1,3)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,90)) ! ((1,1,4)|(0,0,0))
        theta(421) = dot_product(vrrbuffer(:,91), D(:,90)) ! ((1,1,5)|(0,0,0))
        theta(457) = theta(359)+theta(339)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(598) = theta(421)+theta(386)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(676) = theta(517)+theta(457)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(796) = theta(598)+theta(517)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(928) = theta(796)+theta(676)*AB(3) ! ((1,1,2)|(0,0,3)) = ((1,1,3)|(0,0,2))+((1,1,2)|(0,0,2))*AB(3)
        ! (1,0,3|3,0,0): 10
        theta(340) = dot_product(vrrbuffer(:,10), D(:,91)) ! ((1,0,3)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,91)) ! ((2,0,3)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,91)) ! ((3,0,3)|(0,0,0))
        theta(404) = dot_product(vrrbuffer(:,74), D(:,91)) ! ((4,0,3)|(0,0,0))
        theta(458) = theta(355)+theta(340)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(503) = theta(376)+theta(355)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(566) = theta(404)+theta(376)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(677) = theta(503)+theta(458)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(767) = theta(566)+theta(503)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(929) = theta(767)+theta(677)*AB(1) ! ((1,0,3)|(3,0,0)) = ((2,0,3)|(2,0,0))+((1,0,3)|(2,0,0))*AB(1)
        ! (1,0,3|2,1,0): 12
        theta(340) = dot_product(vrrbuffer(:,10), D(:,92)) ! ((1,0,3)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,92)) ! ((2,0,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,92)) ! ((1,1,3)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,92)) ! ((3,0,3)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,92)) ! ((2,1,3)|(0,0,0))
        theta(408) = dot_product(vrrbuffer(:,78), D(:,92)) ! ((3,1,3)|(0,0,0))
        theta(459) = theta(359)+theta(340)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(504) = theta(380)+theta(355)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(567) = theta(408)+theta(376)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(678) = theta(504)+theta(459)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        theta(768) = theta(567)+theta(504)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        theta(930) = theta(768)+theta(678)*AB(1) ! ((1,0,3)|(2,1,0)) = ((2,0,3)|(1,1,0))+((1,0,3)|(1,1,0))*AB(1)
        ! (1,0,3|2,0,1): 13
        theta(340) = dot_product(vrrbuffer(:,10), D(:,93)) ! ((1,0,3)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,93)) ! ((2,0,3)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,93)) ! ((1,0,4)|(0,0,0))
        theta(376) = dot_product(vrrbuffer(:,46), D(:,93)) ! ((3,0,3)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,93)) ! ((2,0,4)|(0,0,0))
        theta(409) = dot_product(vrrbuffer(:,79), D(:,93)) ! ((3,0,4)|(0,0,0))
        theta(458) = theta(355)+theta(340)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(503) = theta(376)+theta(355)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(518) = theta(381)+theta(360)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(581) = theta(409)+theta(381)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(677) = theta(503)+theta(458)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(797) = theta(581)+theta(518)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(931) = theta(797)+theta(677)*AB(3) ! ((1,0,3)|(2,0,1)) = ((1,0,4)|(2,0,0))+((1,0,3)|(2,0,0))*AB(3)
        ! (1,0,3|1,2,0): 13
        theta(340) = dot_product(vrrbuffer(:,10), D(:,94)) ! ((1,0,3)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,94)) ! ((2,0,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,94)) ! ((1,1,3)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,94)) ! ((2,1,3)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,94)) ! ((1,2,3)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,94)) ! ((2,2,3)|(0,0,0))
        theta(459) = theta(359)+theta(340)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(504) = theta(380)+theta(355)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(516) = theta(385)+theta(359)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(579) = theta(413)+theta(380)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(680) = theta(516)+theta(459)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(770) = theta(579)+theta(504)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(932) = theta(770)+theta(680)*AB(1) ! ((1,0,3)|(1,2,0)) = ((2,0,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(1)
        ! (1,0,3|1,1,1): 15
        theta(340) = dot_product(vrrbuffer(:,10), D(:,95)) ! ((1,0,3)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,95)) ! ((2,0,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,95)) ! ((1,1,3)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,95)) ! ((1,0,4)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,95)) ! ((2,1,3)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,95)) ! ((2,0,4)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,95)) ! ((1,1,4)|(0,0,0))
        theta(414) = dot_product(vrrbuffer(:,84), D(:,95)) ! ((2,1,4)|(0,0,0))
        theta(460) = theta(360)+theta(340)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(505) = theta(381)+theta(355)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(580) = theta(414)+theta(380)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(681) = theta(517)+theta(460)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        theta(771) = theta(580)+theta(505)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(933) = theta(771)+theta(681)*AB(1) ! ((1,0,3)|(1,1,1)) = ((2,0,3)|(0,1,1))+((1,0,3)|(0,1,1))*AB(1)
        ! (1,0,3|1,0,2): 13
        theta(340) = dot_product(vrrbuffer(:,10), D(:,96)) ! ((1,0,3)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,96)) ! ((2,0,3)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,96)) ! ((1,0,4)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,96)) ! ((2,0,4)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,96)) ! ((1,0,5)|(0,0,0))
        theta(415) = dot_product(vrrbuffer(:,85), D(:,96)) ! ((2,0,5)|(0,0,0))
        theta(460) = theta(360)+theta(340)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(505) = theta(381)+theta(355)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(520) = theta(387)+theta(360)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(583) = theta(415)+theta(381)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(682) = theta(520)+theta(460)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(772) = theta(583)+theta(505)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(934) = theta(772)+theta(682)*AB(1) ! ((1,0,3)|(1,0,2)) = ((2,0,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(1)
        ! (1,0,3|0,3,0): 10
        theta(340) = dot_product(vrrbuffer(:,10), D(:,97)) ! ((1,0,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,97)) ! ((1,1,3)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,97)) ! ((1,2,3)|(0,0,0))
        theta(419) = dot_product(vrrbuffer(:,89), D(:,97)) ! ((1,3,3)|(0,0,0))
        theta(459) = theta(359)+theta(340)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(516) = theta(385)+theta(359)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(594) = theta(419)+theta(385)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(680) = theta(516)+theta(459)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(794) = theta(594)+theta(516)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(935) = theta(794)+theta(680)*AB(2) ! ((1,0,3)|(0,3,0)) = ((1,1,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(2)
        ! (1,0,3|0,2,1): 13
        theta(340) = dot_product(vrrbuffer(:,10), D(:,98)) ! ((1,0,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,98)) ! ((1,1,3)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,98)) ! ((1,0,4)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,98)) ! ((1,2,3)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,98)) ! ((1,1,4)|(0,0,0))
        theta(420) = dot_product(vrrbuffer(:,90), D(:,98)) ! ((1,2,4)|(0,0,0))
        theta(459) = theta(359)+theta(340)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(516) = theta(385)+theta(359)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(519) = theta(386)+theta(360)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(597) = theta(420)+theta(386)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(680) = theta(516)+theta(459)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(800) = theta(597)+theta(519)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(936) = theta(800)+theta(680)*AB(3) ! ((1,0,3)|(0,2,1)) = ((1,0,4)|(0,2,0))+((1,0,3)|(0,2,0))*AB(3)
        ! (1,0,3|0,1,2): 13
        theta(340) = dot_product(vrrbuffer(:,10), D(:,99)) ! ((1,0,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,99)) ! ((1,1,3)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,99)) ! ((1,0,4)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,99)) ! ((1,1,4)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,99)) ! ((1,0,5)|(0,0,0))
        theta(421) = dot_product(vrrbuffer(:,91), D(:,99)) ! ((1,1,5)|(0,0,0))
        theta(460) = theta(360)+theta(340)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(520) = theta(387)+theta(360)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(598) = theta(421)+theta(386)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(682) = theta(520)+theta(460)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(796) = theta(598)+theta(517)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(937) = theta(796)+theta(682)*AB(2) ! ((1,0,3)|(0,1,2)) = ((1,1,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(2)
        ! (1,0,3|0,0,3): 10
        theta(340) = dot_product(vrrbuffer(:,10), D(:,100)) ! ((1,0,3)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,100)) ! ((1,0,4)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,100)) ! ((1,0,5)|(0,0,0))
        theta(422) = dot_product(vrrbuffer(:,92), D(:,100)) ! ((1,0,6)|(0,0,0))
        theta(460) = theta(360)+theta(340)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(520) = theta(387)+theta(360)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(601) = theta(422)+theta(387)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(682) = theta(520)+theta(460)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(802) = theta(601)+theta(520)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(938) = theta(802)+theta(682)*AB(3) ! ((1,0,3)|(0,0,3)) = ((1,0,4)|(0,0,2))+((1,0,3)|(0,0,2))*AB(3)
        ! (0,4,0|3,0,0): 10
        theta(341) = dot_product(vrrbuffer(:,11), D(:,101)) ! ((0,4,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,101)) ! ((1,4,0)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,101)) ! ((2,4,0)|(0,0,0))
        theta(405) = dot_product(vrrbuffer(:,75), D(:,101)) ! ((3,4,0)|(0,0,0))
        theta(461) = theta(356)+theta(341)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(506) = theta(377)+theta(356)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(569) = theta(405)+theta(377)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(683) = theta(506)+theta(461)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(773) = theta(569)+theta(506)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(939) = theta(773)+theta(683)*AB(1) ! ((0,4,0)|(3,0,0)) = ((1,4,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(1)
        ! (0,4,0|2,1,0): 13
        theta(341) = dot_product(vrrbuffer(:,11), D(:,102)) ! ((0,4,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,102)) ! ((1,4,0)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,102)) ! ((0,5,0)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,102)) ! ((2,4,0)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,102)) ! ((1,5,0)|(0,0,0))
        theta(410) = dot_product(vrrbuffer(:,80), D(:,102)) ! ((2,5,0)|(0,0,0))
        theta(461) = theta(356)+theta(341)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(506) = theta(377)+theta(356)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(521) = theta(382)+theta(361)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(584) = theta(410)+theta(382)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(683) = theta(506)+theta(461)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(803) = theta(584)+theta(521)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        theta(940) = theta(803)+theta(683)*AB(2) ! ((0,4,0)|(2,1,0)) = ((0,5,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(2)
        ! (0,4,0|2,0,1): 13
        theta(341) = dot_product(vrrbuffer(:,11), D(:,103)) ! ((0,4,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,103)) ! ((1,4,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,103)) ! ((0,4,1)|(0,0,0))
        theta(377) = dot_product(vrrbuffer(:,47), D(:,103)) ! ((2,4,0)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,103)) ! ((1,4,1)|(0,0,0))
        theta(411) = dot_product(vrrbuffer(:,81), D(:,103)) ! ((2,4,1)|(0,0,0))
        theta(461) = theta(356)+theta(341)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(506) = theta(377)+theta(356)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(524) = theta(383)+theta(362)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(587) = theta(411)+theta(383)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(683) = theta(506)+theta(461)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(809) = theta(587)+theta(524)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        theta(941) = theta(809)+theta(683)*AB(3) ! ((0,4,0)|(2,0,1)) = ((0,4,1)|(2,0,0))+((0,4,0)|(2,0,0))*AB(3)
        ! (0,4,0|1,2,0): 13
        theta(341) = dot_product(vrrbuffer(:,11), D(:,104)) ! ((0,4,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,104)) ! ((1,4,0)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,104)) ! ((0,5,0)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,104)) ! ((1,5,0)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,104)) ! ((0,6,0)|(0,0,0))
        theta(416) = dot_product(vrrbuffer(:,86), D(:,104)) ! ((1,6,0)|(0,0,0))
        theta(462) = theta(361)+theta(341)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(507) = theta(382)+theta(356)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(522) = theta(388)+theta(361)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(585) = theta(416)+theta(382)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(686) = theta(522)+theta(462)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(776) = theta(585)+theta(507)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(942) = theta(776)+theta(686)*AB(1) ! ((0,4,0)|(1,2,0)) = ((1,4,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(1)
        ! (0,4,0|1,1,1): 15
        theta(341) = dot_product(vrrbuffer(:,11), D(:,105)) ! ((0,4,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,105)) ! ((1,4,0)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,105)) ! ((0,5,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,105)) ! ((0,4,1)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,105)) ! ((1,5,0)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,105)) ! ((1,4,1)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,105)) ! ((0,5,1)|(0,0,0))
        theta(417) = dot_product(vrrbuffer(:,87), D(:,105)) ! ((1,5,1)|(0,0,0))
        theta(463) = theta(362)+theta(341)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(508) = theta(383)+theta(356)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(523) = theta(389)+theta(361)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(586) = theta(417)+theta(382)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(687) = theta(523)+theta(463)*AB(2) ! ((0,4,0)|(0,1,1)) = ((0,5,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(2)
        theta(777) = theta(586)+theta(508)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        theta(943) = theta(777)+theta(687)*AB(1) ! ((0,4,0)|(1,1,1)) = ((1,4,0)|(0,1,1))+((0,4,0)|(0,1,1))*AB(1)
        ! (0,4,0|1,0,2): 13
        theta(341) = dot_product(vrrbuffer(:,11), D(:,106)) ! ((0,4,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,106)) ! ((1,4,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,106)) ! ((0,4,1)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,106)) ! ((1,4,1)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,106)) ! ((0,4,2)|(0,0,0))
        theta(418) = dot_product(vrrbuffer(:,88), D(:,106)) ! ((1,4,2)|(0,0,0))
        theta(463) = theta(362)+theta(341)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(508) = theta(383)+theta(356)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(526) = theta(390)+theta(362)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(589) = theta(418)+theta(383)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(688) = theta(526)+theta(463)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(778) = theta(589)+theta(508)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(944) = theta(778)+theta(688)*AB(1) ! ((0,4,0)|(1,0,2)) = ((1,4,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(1)
        ! (0,4,0|0,3,0): 10
        theta(341) = dot_product(vrrbuffer(:,11), D(:,107)) ! ((0,4,0)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,107)) ! ((0,5,0)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,107)) ! ((0,6,0)|(0,0,0))
        theta(423) = dot_product(vrrbuffer(:,93), D(:,107)) ! ((0,7,0)|(0,0,0))
        theta(462) = theta(361)+theta(341)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(522) = theta(388)+theta(361)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(603) = theta(423)+theta(388)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(686) = theta(522)+theta(462)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(806) = theta(603)+theta(522)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        theta(945) = theta(806)+theta(686)*AB(2) ! ((0,4,0)|(0,3,0)) = ((0,5,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(2)
        ! (0,4,0|0,2,1): 13
        theta(341) = dot_product(vrrbuffer(:,11), D(:,108)) ! ((0,4,0)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,108)) ! ((0,5,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,108)) ! ((0,4,1)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,108)) ! ((0,6,0)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,108)) ! ((0,5,1)|(0,0,0))
        theta(424) = dot_product(vrrbuffer(:,94), D(:,108)) ! ((0,6,1)|(0,0,0))
        theta(462) = theta(361)+theta(341)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(522) = theta(388)+theta(361)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(525) = theta(389)+theta(362)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(606) = theta(424)+theta(389)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(686) = theta(522)+theta(462)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(812) = theta(606)+theta(525)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(946) = theta(812)+theta(686)*AB(3) ! ((0,4,0)|(0,2,1)) = ((0,4,1)|(0,2,0))+((0,4,0)|(0,2,0))*AB(3)
        ! (0,4,0|0,1,2): 13
        theta(341) = dot_product(vrrbuffer(:,11), D(:,109)) ! ((0,4,0)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,109)) ! ((0,5,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,109)) ! ((0,4,1)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,109)) ! ((0,5,1)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,109)) ! ((0,4,2)|(0,0,0))
        theta(425) = dot_product(vrrbuffer(:,95), D(:,109)) ! ((0,5,2)|(0,0,0))
        theta(463) = theta(362)+theta(341)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(523) = theta(389)+theta(361)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(526) = theta(390)+theta(362)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(607) = theta(425)+theta(389)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(688) = theta(526)+theta(463)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(808) = theta(607)+theta(523)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(947) = theta(808)+theta(688)*AB(2) ! ((0,4,0)|(0,1,2)) = ((0,5,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(2)
        ! (0,4,0|0,0,3): 10
        theta(341) = dot_product(vrrbuffer(:,11), D(:,110)) ! ((0,4,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,110)) ! ((0,4,1)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,110)) ! ((0,4,2)|(0,0,0))
        theta(426) = dot_product(vrrbuffer(:,96), D(:,110)) ! ((0,4,3)|(0,0,0))
        theta(463) = theta(362)+theta(341)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(526) = theta(390)+theta(362)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(610) = theta(426)+theta(390)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(688) = theta(526)+theta(463)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(814) = theta(610)+theta(526)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(948) = theta(814)+theta(688)*AB(3) ! ((0,4,0)|(0,0,3)) = ((0,4,1)|(0,0,2))+((0,4,0)|(0,0,2))*AB(3)
        ! (0,3,1|3,0,0): 10
        theta(342) = dot_product(vrrbuffer(:,12), D(:,111)) ! ((0,3,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,111)) ! ((1,3,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,111)) ! ((2,3,1)|(0,0,0))
        theta(406) = dot_product(vrrbuffer(:,76), D(:,111)) ! ((3,3,1)|(0,0,0))
        theta(464) = theta(357)+theta(342)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(509) = theta(378)+theta(357)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(572) = theta(406)+theta(378)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(689) = theta(509)+theta(464)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(779) = theta(572)+theta(509)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(949) = theta(779)+theta(689)*AB(1) ! ((0,3,1)|(3,0,0)) = ((1,3,1)|(2,0,0))+((0,3,1)|(2,0,0))*AB(1)
        ! (0,3,1|2,1,0): 12
        theta(342) = dot_product(vrrbuffer(:,12), D(:,112)) ! ((0,3,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,112)) ! ((1,3,1)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,112)) ! ((0,4,1)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,112)) ! ((2,3,1)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,112)) ! ((1,4,1)|(0,0,0))
        theta(411) = dot_product(vrrbuffer(:,81), D(:,112)) ! ((2,4,1)|(0,0,0))
        theta(465) = theta(362)+theta(342)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(510) = theta(383)+theta(357)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(573) = theta(411)+theta(378)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(690) = theta(510)+theta(465)*AB(1) ! ((0,3,1)|(1,1,0)) = ((1,3,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(1)
        theta(780) = theta(573)+theta(510)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        theta(950) = theta(780)+theta(690)*AB(1) ! ((0,3,1)|(2,1,0)) = ((1,3,1)|(1,1,0))+((0,3,1)|(1,1,0))*AB(1)
        ! (0,3,1|2,0,1): 13
        theta(342) = dot_product(vrrbuffer(:,12), D(:,113)) ! ((0,3,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,113)) ! ((1,3,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,113)) ! ((0,3,2)|(0,0,0))
        theta(378) = dot_product(vrrbuffer(:,48), D(:,113)) ! ((2,3,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,113)) ! ((1,3,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,113)) ! ((2,3,2)|(0,0,0))
        theta(464) = theta(357)+theta(342)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(509) = theta(378)+theta(357)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(527) = theta(384)+theta(363)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(590) = theta(412)+theta(384)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(689) = theta(509)+theta(464)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(815) = theta(590)+theta(527)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        theta(951) = theta(815)+theta(689)*AB(3) ! ((0,3,1)|(2,0,1)) = ((0,3,2)|(2,0,0))+((0,3,1)|(2,0,0))*AB(3)
        ! (0,3,1|1,2,0): 13
        theta(342) = dot_product(vrrbuffer(:,12), D(:,114)) ! ((0,3,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,114)) ! ((1,3,1)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,114)) ! ((0,4,1)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,114)) ! ((1,4,1)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,114)) ! ((0,5,1)|(0,0,0))
        theta(417) = dot_product(vrrbuffer(:,87), D(:,114)) ! ((1,5,1)|(0,0,0))
        theta(465) = theta(362)+theta(342)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(510) = theta(383)+theta(357)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(525) = theta(389)+theta(362)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(588) = theta(417)+theta(383)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(692) = theta(525)+theta(465)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(782) = theta(588)+theta(510)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(952) = theta(782)+theta(692)*AB(1) ! ((0,3,1)|(1,2,0)) = ((1,3,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(1)
        ! (0,3,1|1,1,1): 15
        theta(342) = dot_product(vrrbuffer(:,12), D(:,115)) ! ((0,3,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,115)) ! ((1,3,1)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,115)) ! ((0,4,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,115)) ! ((0,3,2)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,115)) ! ((1,4,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,115)) ! ((1,3,2)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,115)) ! ((0,4,2)|(0,0,0))
        theta(418) = dot_product(vrrbuffer(:,88), D(:,115)) ! ((1,4,2)|(0,0,0))
        theta(466) = theta(363)+theta(342)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(526) = theta(390)+theta(362)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(589) = theta(418)+theta(383)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(693) = theta(526)+theta(466)*AB(2) ! ((0,3,1)|(0,1,1)) = ((0,4,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(2)
        theta(783) = theta(589)+theta(511)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(953) = theta(783)+theta(693)*AB(1) ! ((0,3,1)|(1,1,1)) = ((1,3,1)|(0,1,1))+((0,3,1)|(0,1,1))*AB(1)
        ! (0,3,1|1,0,2): 13
        theta(342) = dot_product(vrrbuffer(:,12), D(:,116)) ! ((0,3,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,116)) ! ((1,3,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,116)) ! ((0,3,2)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,116)) ! ((1,3,2)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,116)) ! ((0,3,3)|(0,0,0))
        theta(419) = dot_product(vrrbuffer(:,89), D(:,116)) ! ((1,3,3)|(0,0,0))
        theta(466) = theta(363)+theta(342)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(529) = theta(391)+theta(363)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(592) = theta(419)+theta(384)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(694) = theta(529)+theta(466)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(784) = theta(592)+theta(511)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(954) = theta(784)+theta(694)*AB(1) ! ((0,3,1)|(1,0,2)) = ((1,3,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(1)
        ! (0,3,1|0,3,0): 10
        theta(342) = dot_product(vrrbuffer(:,12), D(:,117)) ! ((0,3,1)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,117)) ! ((0,4,1)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,117)) ! ((0,5,1)|(0,0,0))
        theta(424) = dot_product(vrrbuffer(:,94), D(:,117)) ! ((0,6,1)|(0,0,0))
        theta(465) = theta(362)+theta(342)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(525) = theta(389)+theta(362)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(606) = theta(424)+theta(389)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(692) = theta(525)+theta(465)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(812) = theta(606)+theta(525)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(955) = theta(812)+theta(692)*AB(2) ! ((0,3,1)|(0,3,0)) = ((0,4,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(2)
        ! (0,3,1|0,2,1): 13
        theta(342) = dot_product(vrrbuffer(:,12), D(:,118)) ! ((0,3,1)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,118)) ! ((0,4,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,118)) ! ((0,3,2)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,118)) ! ((0,5,1)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,118)) ! ((0,4,2)|(0,0,0))
        theta(425) = dot_product(vrrbuffer(:,95), D(:,118)) ! ((0,5,2)|(0,0,0))
        theta(465) = theta(362)+theta(342)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(525) = theta(389)+theta(362)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(528) = theta(390)+theta(363)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(609) = theta(425)+theta(390)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(692) = theta(525)+theta(465)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(818) = theta(609)+theta(528)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(956) = theta(818)+theta(692)*AB(3) ! ((0,3,1)|(0,2,1)) = ((0,3,2)|(0,2,0))+((0,3,1)|(0,2,0))*AB(3)
        ! (0,3,1|0,1,2): 13
        theta(342) = dot_product(vrrbuffer(:,12), D(:,119)) ! ((0,3,1)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,119)) ! ((0,4,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,119)) ! ((0,3,2)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,119)) ! ((0,4,2)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,119)) ! ((0,3,3)|(0,0,0))
        theta(426) = dot_product(vrrbuffer(:,96), D(:,119)) ! ((0,4,3)|(0,0,0))
        theta(466) = theta(363)+theta(342)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(526) = theta(390)+theta(362)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(529) = theta(391)+theta(363)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(610) = theta(426)+theta(390)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(694) = theta(529)+theta(466)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(814) = theta(610)+theta(526)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(957) = theta(814)+theta(694)*AB(2) ! ((0,3,1)|(0,1,2)) = ((0,4,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(2)
        ! (0,3,1|0,0,3): 10
        theta(342) = dot_product(vrrbuffer(:,12), D(:,120)) ! ((0,3,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,120)) ! ((0,3,2)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,120)) ! ((0,3,3)|(0,0,0))
        theta(427) = dot_product(vrrbuffer(:,97), D(:,120)) ! ((0,3,4)|(0,0,0))
        theta(466) = theta(363)+theta(342)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(529) = theta(391)+theta(363)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(613) = theta(427)+theta(391)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(694) = theta(529)+theta(466)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(820) = theta(613)+theta(529)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(958) = theta(820)+theta(694)*AB(3) ! ((0,3,1)|(0,0,3)) = ((0,3,2)|(0,0,2))+((0,3,1)|(0,0,2))*AB(3)
        ! (0,2,2|3,0,0): 10
        theta(343) = dot_product(vrrbuffer(:,13), D(:,121)) ! ((0,2,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,121)) ! ((1,2,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,121)) ! ((2,2,2)|(0,0,0))
        theta(407) = dot_product(vrrbuffer(:,77), D(:,121)) ! ((3,2,2)|(0,0,0))
        theta(467) = theta(358)+theta(343)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(512) = theta(379)+theta(358)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(575) = theta(407)+theta(379)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(695) = theta(512)+theta(467)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(785) = theta(575)+theta(512)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(959) = theta(785)+theta(695)*AB(1) ! ((0,2,2)|(3,0,0)) = ((1,2,2)|(2,0,0))+((0,2,2)|(2,0,0))*AB(1)
        ! (0,2,2|2,1,0): 12
        theta(343) = dot_product(vrrbuffer(:,13), D(:,122)) ! ((0,2,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,122)) ! ((1,2,2)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,122)) ! ((0,3,2)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,122)) ! ((2,2,2)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,122)) ! ((1,3,2)|(0,0,0))
        theta(412) = dot_product(vrrbuffer(:,82), D(:,122)) ! ((2,3,2)|(0,0,0))
        theta(468) = theta(363)+theta(343)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(513) = theta(384)+theta(358)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(576) = theta(412)+theta(379)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(696) = theta(513)+theta(468)*AB(1) ! ((0,2,2)|(1,1,0)) = ((1,2,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(1)
        theta(786) = theta(576)+theta(513)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        theta(960) = theta(786)+theta(696)*AB(1) ! ((0,2,2)|(2,1,0)) = ((1,2,2)|(1,1,0))+((0,2,2)|(1,1,0))*AB(1)
        ! (0,2,2|2,0,1): 13
        theta(343) = dot_product(vrrbuffer(:,13), D(:,123)) ! ((0,2,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,123)) ! ((1,2,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,123)) ! ((0,2,3)|(0,0,0))
        theta(379) = dot_product(vrrbuffer(:,49), D(:,123)) ! ((2,2,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,123)) ! ((1,2,3)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,123)) ! ((2,2,3)|(0,0,0))
        theta(467) = theta(358)+theta(343)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(512) = theta(379)+theta(358)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(530) = theta(385)+theta(364)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(593) = theta(413)+theta(385)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(695) = theta(512)+theta(467)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(821) = theta(593)+theta(530)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        theta(961) = theta(821)+theta(695)*AB(3) ! ((0,2,2)|(2,0,1)) = ((0,2,3)|(2,0,0))+((0,2,2)|(2,0,0))*AB(3)
        ! (0,2,2|1,2,0): 13
        theta(343) = dot_product(vrrbuffer(:,13), D(:,124)) ! ((0,2,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,124)) ! ((1,2,2)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,124)) ! ((0,3,2)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,124)) ! ((1,3,2)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,124)) ! ((0,4,2)|(0,0,0))
        theta(418) = dot_product(vrrbuffer(:,88), D(:,124)) ! ((1,4,2)|(0,0,0))
        theta(468) = theta(363)+theta(343)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(513) = theta(384)+theta(358)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(528) = theta(390)+theta(363)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(591) = theta(418)+theta(384)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(698) = theta(528)+theta(468)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(788) = theta(591)+theta(513)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(962) = theta(788)+theta(698)*AB(1) ! ((0,2,2)|(1,2,0)) = ((1,2,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(1)
        ! (0,2,2|1,1,1): 15
        theta(343) = dot_product(vrrbuffer(:,13), D(:,125)) ! ((0,2,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,125)) ! ((1,2,2)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,125)) ! ((0,3,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,125)) ! ((0,2,3)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,125)) ! ((1,3,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,125)) ! ((1,2,3)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,125)) ! ((0,3,3)|(0,0,0))
        theta(419) = dot_product(vrrbuffer(:,89), D(:,125)) ! ((1,3,3)|(0,0,0))
        theta(469) = theta(364)+theta(343)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(529) = theta(391)+theta(363)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(592) = theta(419)+theta(384)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(699) = theta(529)+theta(469)*AB(2) ! ((0,2,2)|(0,1,1)) = ((0,3,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(2)
        theta(789) = theta(592)+theta(514)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(963) = theta(789)+theta(699)*AB(1) ! ((0,2,2)|(1,1,1)) = ((1,2,2)|(0,1,1))+((0,2,2)|(0,1,1))*AB(1)
        ! (0,2,2|1,0,2): 13
        theta(343) = dot_product(vrrbuffer(:,13), D(:,126)) ! ((0,2,2)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,126)) ! ((1,2,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,126)) ! ((0,2,3)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,126)) ! ((1,2,3)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,126)) ! ((0,2,4)|(0,0,0))
        theta(420) = dot_product(vrrbuffer(:,90), D(:,126)) ! ((1,2,4)|(0,0,0))
        theta(469) = theta(364)+theta(343)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(532) = theta(392)+theta(364)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(595) = theta(420)+theta(385)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(700) = theta(532)+theta(469)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(790) = theta(595)+theta(514)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(964) = theta(790)+theta(700)*AB(1) ! ((0,2,2)|(1,0,2)) = ((1,2,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(1)
        ! (0,2,2|0,3,0): 10
        theta(343) = dot_product(vrrbuffer(:,13), D(:,127)) ! ((0,2,2)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,127)) ! ((0,3,2)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,127)) ! ((0,4,2)|(0,0,0))
        theta(425) = dot_product(vrrbuffer(:,95), D(:,127)) ! ((0,5,2)|(0,0,0))
        theta(468) = theta(363)+theta(343)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(528) = theta(390)+theta(363)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(609) = theta(425)+theta(390)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(698) = theta(528)+theta(468)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(818) = theta(609)+theta(528)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(965) = theta(818)+theta(698)*AB(2) ! ((0,2,2)|(0,3,0)) = ((0,3,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(2)
        ! (0,2,2|0,2,1): 13
        theta(343) = dot_product(vrrbuffer(:,13), D(:,128)) ! ((0,2,2)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,128)) ! ((0,3,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,128)) ! ((0,2,3)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,128)) ! ((0,4,2)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,128)) ! ((0,3,3)|(0,0,0))
        theta(426) = dot_product(vrrbuffer(:,96), D(:,128)) ! ((0,4,3)|(0,0,0))
        theta(468) = theta(363)+theta(343)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(528) = theta(390)+theta(363)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(531) = theta(391)+theta(364)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(612) = theta(426)+theta(391)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(698) = theta(528)+theta(468)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(824) = theta(612)+theta(531)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(966) = theta(824)+theta(698)*AB(3) ! ((0,2,2)|(0,2,1)) = ((0,2,3)|(0,2,0))+((0,2,2)|(0,2,0))*AB(3)
        ! (0,2,2|0,1,2): 13
        theta(343) = dot_product(vrrbuffer(:,13), D(:,129)) ! ((0,2,2)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,129)) ! ((0,3,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,129)) ! ((0,2,3)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,129)) ! ((0,3,3)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,129)) ! ((0,2,4)|(0,0,0))
        theta(427) = dot_product(vrrbuffer(:,97), D(:,129)) ! ((0,3,4)|(0,0,0))
        theta(469) = theta(364)+theta(343)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(529) = theta(391)+theta(363)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(532) = theta(392)+theta(364)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(613) = theta(427)+theta(391)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(700) = theta(532)+theta(469)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(820) = theta(613)+theta(529)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(967) = theta(820)+theta(700)*AB(2) ! ((0,2,2)|(0,1,2)) = ((0,3,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(2)
        ! (0,2,2|0,0,3): 10
        theta(343) = dot_product(vrrbuffer(:,13), D(:,130)) ! ((0,2,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,130)) ! ((0,2,3)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,130)) ! ((0,2,4)|(0,0,0))
        theta(428) = dot_product(vrrbuffer(:,98), D(:,130)) ! ((0,2,5)|(0,0,0))
        theta(469) = theta(364)+theta(343)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(532) = theta(392)+theta(364)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(616) = theta(428)+theta(392)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(700) = theta(532)+theta(469)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(826) = theta(616)+theta(532)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(968) = theta(826)+theta(700)*AB(3) ! ((0,2,2)|(0,0,3)) = ((0,2,3)|(0,0,2))+((0,2,2)|(0,0,2))*AB(3)
        ! (0,1,3|3,0,0): 10
        theta(344) = dot_product(vrrbuffer(:,14), D(:,131)) ! ((0,1,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,131)) ! ((1,1,3)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,131)) ! ((2,1,3)|(0,0,0))
        theta(408) = dot_product(vrrbuffer(:,78), D(:,131)) ! ((3,1,3)|(0,0,0))
        theta(470) = theta(359)+theta(344)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(515) = theta(380)+theta(359)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(578) = theta(408)+theta(380)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(701) = theta(515)+theta(470)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(791) = theta(578)+theta(515)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(969) = theta(791)+theta(701)*AB(1) ! ((0,1,3)|(3,0,0)) = ((1,1,3)|(2,0,0))+((0,1,3)|(2,0,0))*AB(1)
        ! (0,1,3|2,1,0): 12
        theta(344) = dot_product(vrrbuffer(:,14), D(:,132)) ! ((0,1,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,132)) ! ((1,1,3)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,132)) ! ((0,2,3)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,132)) ! ((2,1,3)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,132)) ! ((1,2,3)|(0,0,0))
        theta(413) = dot_product(vrrbuffer(:,83), D(:,132)) ! ((2,2,3)|(0,0,0))
        theta(471) = theta(364)+theta(344)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(516) = theta(385)+theta(359)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(579) = theta(413)+theta(380)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(702) = theta(516)+theta(471)*AB(1) ! ((0,1,3)|(1,1,0)) = ((1,1,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(1)
        theta(792) = theta(579)+theta(516)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        theta(970) = theta(792)+theta(702)*AB(1) ! ((0,1,3)|(2,1,0)) = ((1,1,3)|(1,1,0))+((0,1,3)|(1,1,0))*AB(1)
        ! (0,1,3|2,0,1): 13
        theta(344) = dot_product(vrrbuffer(:,14), D(:,133)) ! ((0,1,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,133)) ! ((1,1,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,133)) ! ((0,1,4)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,133)) ! ((2,1,3)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,133)) ! ((1,1,4)|(0,0,0))
        theta(414) = dot_product(vrrbuffer(:,84), D(:,133)) ! ((2,1,4)|(0,0,0))
        theta(470) = theta(359)+theta(344)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(515) = theta(380)+theta(359)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(533) = theta(386)+theta(365)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(596) = theta(414)+theta(386)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(701) = theta(515)+theta(470)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(827) = theta(596)+theta(533)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        theta(971) = theta(827)+theta(701)*AB(3) ! ((0,1,3)|(2,0,1)) = ((0,1,4)|(2,0,0))+((0,1,3)|(2,0,0))*AB(3)
        ! (0,1,3|1,2,0): 13
        theta(344) = dot_product(vrrbuffer(:,14), D(:,134)) ! ((0,1,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,134)) ! ((1,1,3)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,134)) ! ((0,2,3)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,134)) ! ((1,2,3)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,134)) ! ((0,3,3)|(0,0,0))
        theta(419) = dot_product(vrrbuffer(:,89), D(:,134)) ! ((1,3,3)|(0,0,0))
        theta(471) = theta(364)+theta(344)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(516) = theta(385)+theta(359)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(531) = theta(391)+theta(364)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(594) = theta(419)+theta(385)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(704) = theta(531)+theta(471)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(794) = theta(594)+theta(516)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(972) = theta(794)+theta(704)*AB(1) ! ((0,1,3)|(1,2,0)) = ((1,1,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(1)
        ! (0,1,3|1,1,1): 15
        theta(344) = dot_product(vrrbuffer(:,14), D(:,135)) ! ((0,1,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,135)) ! ((1,1,3)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,135)) ! ((0,2,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,135)) ! ((0,1,4)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,135)) ! ((1,2,3)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,135)) ! ((1,1,4)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,135)) ! ((0,2,4)|(0,0,0))
        theta(420) = dot_product(vrrbuffer(:,90), D(:,135)) ! ((1,2,4)|(0,0,0))
        theta(472) = theta(365)+theta(344)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(532) = theta(392)+theta(364)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(595) = theta(420)+theta(385)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(705) = theta(532)+theta(472)*AB(2) ! ((0,1,3)|(0,1,1)) = ((0,2,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(2)
        theta(795) = theta(595)+theta(517)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(973) = theta(795)+theta(705)*AB(1) ! ((0,1,3)|(1,1,1)) = ((1,1,3)|(0,1,1))+((0,1,3)|(0,1,1))*AB(1)
        ! (0,1,3|1,0,2): 13
        theta(344) = dot_product(vrrbuffer(:,14), D(:,136)) ! ((0,1,3)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,136)) ! ((1,1,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,136)) ! ((0,1,4)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,136)) ! ((1,1,4)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,136)) ! ((0,1,5)|(0,0,0))
        theta(421) = dot_product(vrrbuffer(:,91), D(:,136)) ! ((1,1,5)|(0,0,0))
        theta(472) = theta(365)+theta(344)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(535) = theta(393)+theta(365)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(598) = theta(421)+theta(386)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(706) = theta(535)+theta(472)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(796) = theta(598)+theta(517)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(974) = theta(796)+theta(706)*AB(1) ! ((0,1,3)|(1,0,2)) = ((1,1,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(1)
        ! (0,1,3|0,3,0): 10
        theta(344) = dot_product(vrrbuffer(:,14), D(:,137)) ! ((0,1,3)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,137)) ! ((0,2,3)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,137)) ! ((0,3,3)|(0,0,0))
        theta(426) = dot_product(vrrbuffer(:,96), D(:,137)) ! ((0,4,3)|(0,0,0))
        theta(471) = theta(364)+theta(344)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(531) = theta(391)+theta(364)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(612) = theta(426)+theta(391)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(704) = theta(531)+theta(471)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(824) = theta(612)+theta(531)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(975) = theta(824)+theta(704)*AB(2) ! ((0,1,3)|(0,3,0)) = ((0,2,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(2)
        ! (0,1,3|0,2,1): 13
        theta(344) = dot_product(vrrbuffer(:,14), D(:,138)) ! ((0,1,3)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,138)) ! ((0,2,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,138)) ! ((0,1,4)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,138)) ! ((0,3,3)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,138)) ! ((0,2,4)|(0,0,0))
        theta(427) = dot_product(vrrbuffer(:,97), D(:,138)) ! ((0,3,4)|(0,0,0))
        theta(471) = theta(364)+theta(344)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(531) = theta(391)+theta(364)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(534) = theta(392)+theta(365)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(615) = theta(427)+theta(392)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(704) = theta(531)+theta(471)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(830) = theta(615)+theta(534)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(976) = theta(830)+theta(704)*AB(3) ! ((0,1,3)|(0,2,1)) = ((0,1,4)|(0,2,0))+((0,1,3)|(0,2,0))*AB(3)
        ! (0,1,3|0,1,2): 13
        theta(344) = dot_product(vrrbuffer(:,14), D(:,139)) ! ((0,1,3)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,139)) ! ((0,2,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,139)) ! ((0,1,4)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,139)) ! ((0,2,4)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,139)) ! ((0,1,5)|(0,0,0))
        theta(428) = dot_product(vrrbuffer(:,98), D(:,139)) ! ((0,2,5)|(0,0,0))
        theta(472) = theta(365)+theta(344)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(532) = theta(392)+theta(364)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(535) = theta(393)+theta(365)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(616) = theta(428)+theta(392)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(706) = theta(535)+theta(472)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(826) = theta(616)+theta(532)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(977) = theta(826)+theta(706)*AB(2) ! ((0,1,3)|(0,1,2)) = ((0,2,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(2)
        ! (0,1,3|0,0,3): 10
        theta(344) = dot_product(vrrbuffer(:,14), D(:,140)) ! ((0,1,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,140)) ! ((0,1,4)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,140)) ! ((0,1,5)|(0,0,0))
        theta(429) = dot_product(vrrbuffer(:,99), D(:,140)) ! ((0,1,6)|(0,0,0))
        theta(472) = theta(365)+theta(344)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(535) = theta(393)+theta(365)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(619) = theta(429)+theta(393)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(706) = theta(535)+theta(472)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(832) = theta(619)+theta(535)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(978) = theta(832)+theta(706)*AB(3) ! ((0,1,3)|(0,0,3)) = ((0,1,4)|(0,0,2))+((0,1,3)|(0,0,2))*AB(3)
        ! (0,0,4|3,0,0): 10
        theta(345) = dot_product(vrrbuffer(:,15), D(:,141)) ! ((0,0,4)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,141)) ! ((1,0,4)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,141)) ! ((2,0,4)|(0,0,0))
        theta(409) = dot_product(vrrbuffer(:,79), D(:,141)) ! ((3,0,4)|(0,0,0))
        theta(473) = theta(360)+theta(345)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(518) = theta(381)+theta(360)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(581) = theta(409)+theta(381)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(707) = theta(518)+theta(473)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(797) = theta(581)+theta(518)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(979) = theta(797)+theta(707)*AB(1) ! ((0,0,4)|(3,0,0)) = ((1,0,4)|(2,0,0))+((0,0,4)|(2,0,0))*AB(1)
        ! (0,0,4|2,1,0): 12
        theta(345) = dot_product(vrrbuffer(:,15), D(:,142)) ! ((0,0,4)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,142)) ! ((1,0,4)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,142)) ! ((0,1,4)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,142)) ! ((2,0,4)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,142)) ! ((1,1,4)|(0,0,0))
        theta(414) = dot_product(vrrbuffer(:,84), D(:,142)) ! ((2,1,4)|(0,0,0))
        theta(474) = theta(365)+theta(345)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(519) = theta(386)+theta(360)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(582) = theta(414)+theta(381)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(708) = theta(519)+theta(474)*AB(1) ! ((0,0,4)|(1,1,0)) = ((1,0,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(1)
        theta(798) = theta(582)+theta(519)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        theta(980) = theta(798)+theta(708)*AB(1) ! ((0,0,4)|(2,1,0)) = ((1,0,4)|(1,1,0))+((0,0,4)|(1,1,0))*AB(1)
        ! (0,0,4|2,0,1): 13
        theta(345) = dot_product(vrrbuffer(:,15), D(:,143)) ! ((0,0,4)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,143)) ! ((1,0,4)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,143)) ! ((0,0,5)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,143)) ! ((2,0,4)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,143)) ! ((1,0,5)|(0,0,0))
        theta(415) = dot_product(vrrbuffer(:,85), D(:,143)) ! ((2,0,5)|(0,0,0))
        theta(473) = theta(360)+theta(345)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(518) = theta(381)+theta(360)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(536) = theta(387)+theta(366)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(599) = theta(415)+theta(387)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        theta(707) = theta(518)+theta(473)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(833) = theta(599)+theta(536)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        theta(981) = theta(833)+theta(707)*AB(3) ! ((0,0,4)|(2,0,1)) = ((0,0,5)|(2,0,0))+((0,0,4)|(2,0,0))*AB(3)
        ! (0,0,4|1,2,0): 13
        theta(345) = dot_product(vrrbuffer(:,15), D(:,144)) ! ((0,0,4)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,144)) ! ((1,0,4)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,144)) ! ((0,1,4)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,144)) ! ((1,1,4)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,144)) ! ((0,2,4)|(0,0,0))
        theta(420) = dot_product(vrrbuffer(:,90), D(:,144)) ! ((1,2,4)|(0,0,0))
        theta(474) = theta(365)+theta(345)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(519) = theta(386)+theta(360)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(534) = theta(392)+theta(365)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(597) = theta(420)+theta(386)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(710) = theta(534)+theta(474)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(800) = theta(597)+theta(519)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(982) = theta(800)+theta(710)*AB(1) ! ((0,0,4)|(1,2,0)) = ((1,0,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(1)
        ! (0,0,4|1,1,1): 15
        theta(345) = dot_product(vrrbuffer(:,15), D(:,145)) ! ((0,0,4)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,145)) ! ((1,0,4)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,145)) ! ((0,1,4)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,145)) ! ((0,0,5)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,145)) ! ((1,1,4)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,145)) ! ((1,0,5)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,145)) ! ((0,1,5)|(0,0,0))
        theta(421) = dot_product(vrrbuffer(:,91), D(:,145)) ! ((1,1,5)|(0,0,0))
        theta(475) = theta(366)+theta(345)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(520) = theta(387)+theta(360)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(535) = theta(393)+theta(365)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(598) = theta(421)+theta(386)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(711) = theta(535)+theta(475)*AB(2) ! ((0,0,4)|(0,1,1)) = ((0,1,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(2)
        theta(801) = theta(598)+theta(520)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(983) = theta(801)+theta(711)*AB(1) ! ((0,0,4)|(1,1,1)) = ((1,0,4)|(0,1,1))+((0,0,4)|(0,1,1))*AB(1)
        ! (0,0,4|1,0,2): 13
        theta(345) = dot_product(vrrbuffer(:,15), D(:,146)) ! ((0,0,4)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,146)) ! ((1,0,4)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,146)) ! ((0,0,5)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,146)) ! ((1,0,5)|(0,0,0))
        theta(394) = dot_product(vrrbuffer(:,64), D(:,146)) ! ((0,0,6)|(0,0,0))
        theta(422) = dot_product(vrrbuffer(:,92), D(:,146)) ! ((1,0,6)|(0,0,0))
        theta(475) = theta(366)+theta(345)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(520) = theta(387)+theta(360)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(538) = theta(394)+theta(366)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(601) = theta(422)+theta(387)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(712) = theta(538)+theta(475)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(802) = theta(601)+theta(520)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(984) = theta(802)+theta(712)*AB(1) ! ((0,0,4)|(1,0,2)) = ((1,0,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(1)
        ! (0,0,4|0,3,0): 10
        theta(345) = dot_product(vrrbuffer(:,15), D(:,147)) ! ((0,0,4)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,147)) ! ((0,1,4)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,147)) ! ((0,2,4)|(0,0,0))
        theta(427) = dot_product(vrrbuffer(:,97), D(:,147)) ! ((0,3,4)|(0,0,0))
        theta(474) = theta(365)+theta(345)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(534) = theta(392)+theta(365)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(615) = theta(427)+theta(392)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(710) = theta(534)+theta(474)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(830) = theta(615)+theta(534)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(985) = theta(830)+theta(710)*AB(2) ! ((0,0,4)|(0,3,0)) = ((0,1,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(2)
        ! (0,0,4|0,2,1): 13
        theta(345) = dot_product(vrrbuffer(:,15), D(:,148)) ! ((0,0,4)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,148)) ! ((0,1,4)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,148)) ! ((0,0,5)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,148)) ! ((0,2,4)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,148)) ! ((0,1,5)|(0,0,0))
        theta(428) = dot_product(vrrbuffer(:,98), D(:,148)) ! ((0,2,5)|(0,0,0))
        theta(474) = theta(365)+theta(345)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(534) = theta(392)+theta(365)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(537) = theta(393)+theta(366)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(618) = theta(428)+theta(393)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(710) = theta(534)+theta(474)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(836) = theta(618)+theta(537)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        theta(986) = theta(836)+theta(710)*AB(3) ! ((0,0,4)|(0,2,1)) = ((0,0,5)|(0,2,0))+((0,0,4)|(0,2,0))*AB(3)
        ! (0,0,4|0,1,2): 13
        theta(345) = dot_product(vrrbuffer(:,15), D(:,149)) ! ((0,0,4)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,149)) ! ((0,1,4)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,149)) ! ((0,0,5)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,149)) ! ((0,1,5)|(0,0,0))
        theta(394) = dot_product(vrrbuffer(:,64), D(:,149)) ! ((0,0,6)|(0,0,0))
        theta(429) = dot_product(vrrbuffer(:,99), D(:,149)) ! ((0,1,6)|(0,0,0))
        theta(475) = theta(366)+theta(345)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(535) = theta(393)+theta(365)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(538) = theta(394)+theta(366)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(619) = theta(429)+theta(393)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(712) = theta(538)+theta(475)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(832) = theta(619)+theta(535)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(987) = theta(832)+theta(712)*AB(2) ! ((0,0,4)|(0,1,2)) = ((0,1,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(2)
        ! (0,0,4|0,0,3): 10
        theta(345) = dot_product(vrrbuffer(:,15), D(:,150)) ! ((0,0,4)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,150)) ! ((0,0,5)|(0,0,0))
        theta(394) = dot_product(vrrbuffer(:,64), D(:,150)) ! ((0,0,6)|(0,0,0))
        theta(430) = dot_product(vrrbuffer(:,100), D(:,150)) ! ((0,0,7)|(0,0,0))
        theta(475) = theta(366)+theta(345)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(538) = theta(394)+theta(366)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(622) = theta(430)+theta(394)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(712) = theta(538)+theta(475)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(838) = theta(622)+theta(538)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(988) = theta(838)+theta(712)*AB(3) ! ((0,0,4)|(0,0,3)) = ((0,0,5)|(0,0,2))+((0,0,4)|(0,0,2))*AB(3)
    end subroutine
    subroutine blockhrr_4_4(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 1414; Optimized integrals: 1164
        ! (4,0,0|4,0,0): 15
        theta(496) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(532) = dot_product(vrrbuffer(:,37), D(:,1)) ! ((6,0,0)|(0,0,0))
        theta(560) = dot_product(vrrbuffer(:,65), D(:,1)) ! ((7,0,0)|(0,0,0))
        theta(596) = dot_product(vrrbuffer(:,101), D(:,1)) ! ((8,0,0)|(0,0,0))
        theta(641) = theta(511)+theta(496)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(686) = theta(532)+theta(511)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(749) = theta(560)+theta(532)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(833) = theta(596)+theta(560)*AB(1) ! ((7,0,0)|(1,0,0)) = ((8,0,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(1)
        theta(941) = theta(686)+theta(641)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(1031) = theta(749)+theta(686)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        theta(1157) = theta(833)+theta(749)*AB(1) ! ((6,0,0)|(2,0,0)) = ((7,0,0)|(1,0,0))+((6,0,0)|(1,0,0))*AB(1)
        theta(1325) = theta(1031)+theta(941)*AB(1) ! ((4,0,0)|(3,0,0)) = ((5,0,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(1)
        theta(1475) = theta(1157)+theta(1031)*AB(1) ! ((5,0,0)|(3,0,0)) = ((6,0,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(1)
        theta(1685) = theta(1475)+theta(1325)*AB(1) ! ((4,0,0)|(4,0,0)) = ((5,0,0)|(3,0,0))+((4,0,0)|(3,0,0))*AB(1)
        ! (4,0,0|3,1,0): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,2)) ! ((5,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,2)) ! ((4,1,0)|(0,0,0))
        theta(532) = dot_product(vrrbuffer(:,37), D(:,2)) ! ((6,0,0)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,2)) ! ((5,1,0)|(0,0,0))
        theta(560) = dot_product(vrrbuffer(:,65), D(:,2)) ! ((7,0,0)|(0,0,0))
        theta(561) = dot_product(vrrbuffer(:,66), D(:,2)) ! ((6,1,0)|(0,0,0))
        theta(597) = dot_product(vrrbuffer(:,102), D(:,2)) ! ((7,1,0)|(0,0,0))
        theta(641) = theta(511)+theta(496)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(686) = theta(532)+theta(511)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(689) = theta(533)+theta(512)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(749) = theta(560)+theta(532)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(752) = theta(561)+theta(533)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(836) = theta(597)+theta(561)*AB(1) ! ((6,1,0)|(1,0,0)) = ((7,1,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(1)
        theta(941) = theta(686)+theta(641)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(1031) = theta(749)+theta(686)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        theta(1037) = theta(752)+theta(689)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(1163) = theta(836)+theta(752)*AB(1) ! ((5,1,0)|(2,0,0)) = ((6,1,0)|(1,0,0))+((5,1,0)|(1,0,0))*AB(1)
        theta(1325) = theta(1031)+theta(941)*AB(1) ! ((4,0,0)|(3,0,0)) = ((5,0,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(1)
        theta(1485) = theta(1163)+theta(1037)*AB(1) ! ((4,1,0)|(3,0,0)) = ((5,1,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(1)
        theta(1686) = theta(1485)+theta(1325)*AB(2) ! ((4,0,0)|(3,1,0)) = ((4,1,0)|(3,0,0))+((4,0,0)|(3,0,0))*AB(2)
        ! (4,0,0|3,0,1): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,3)) ! ((5,0,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,3)) ! ((4,0,1)|(0,0,0))
        theta(532) = dot_product(vrrbuffer(:,37), D(:,3)) ! ((6,0,0)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,3)) ! ((5,0,1)|(0,0,0))
        theta(560) = dot_product(vrrbuffer(:,65), D(:,3)) ! ((7,0,0)|(0,0,0))
        theta(562) = dot_product(vrrbuffer(:,67), D(:,3)) ! ((6,0,1)|(0,0,0))
        theta(598) = dot_product(vrrbuffer(:,103), D(:,3)) ! ((7,0,1)|(0,0,0))
        theta(641) = theta(511)+theta(496)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(686) = theta(532)+theta(511)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(692) = theta(534)+theta(513)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(749) = theta(560)+theta(532)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(755) = theta(562)+theta(534)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(839) = theta(598)+theta(562)*AB(1) ! ((6,0,1)|(1,0,0)) = ((7,0,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(1)
        theta(941) = theta(686)+theta(641)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(1031) = theta(749)+theta(686)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        theta(1043) = theta(755)+theta(692)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(1169) = theta(839)+theta(755)*AB(1) ! ((5,0,1)|(2,0,0)) = ((6,0,1)|(1,0,0))+((5,0,1)|(1,0,0))*AB(1)
        theta(1325) = theta(1031)+theta(941)*AB(1) ! ((4,0,0)|(3,0,0)) = ((5,0,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(1)
        theta(1495) = theta(1169)+theta(1043)*AB(1) ! ((4,0,1)|(3,0,0)) = ((5,0,1)|(2,0,0))+((4,0,1)|(2,0,0))*AB(1)
        theta(1687) = theta(1495)+theta(1325)*AB(3) ! ((4,0,0)|(3,0,1)) = ((4,0,1)|(3,0,0))+((4,0,0)|(3,0,0))*AB(3)
        ! (4,0,0|2,2,0): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,4)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,4)) ! ((5,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,4)) ! ((4,1,0)|(0,0,0))
        theta(532) = dot_product(vrrbuffer(:,37), D(:,4)) ! ((6,0,0)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,4)) ! ((5,1,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,4)) ! ((4,2,0)|(0,0,0))
        theta(561) = dot_product(vrrbuffer(:,66), D(:,4)) ! ((6,1,0)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,4)) ! ((5,2,0)|(0,0,0))
        theta(599) = dot_product(vrrbuffer(:,104), D(:,4)) ! ((6,2,0)|(0,0,0))
        theta(642) = theta(512)+theta(496)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(687) = theta(533)+theta(511)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(750) = theta(561)+theta(532)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        theta(753) = theta(563)+theta(533)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(837) = theta(599)+theta(561)*AB(2) ! ((6,1,0)|(0,1,0)) = ((6,2,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(2)
        theta(944) = theta(690)+theta(642)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(1034) = theta(753)+theta(687)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        theta(1160) = theta(837)+theta(750)*AB(2) ! ((6,0,0)|(0,2,0)) = ((6,1,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(2)
        theta(1328) = theta(1034)+theta(944)*AB(1) ! ((4,0,0)|(1,2,0)) = ((5,0,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(1)
        theta(1478) = theta(1160)+theta(1034)*AB(1) ! ((5,0,0)|(1,2,0)) = ((6,0,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(1)
        theta(1688) = theta(1478)+theta(1328)*AB(1) ! ((4,0,0)|(2,2,0)) = ((5,0,0)|(1,2,0))+((4,0,0)|(1,2,0))*AB(1)
        ! (4,0,0|2,1,1): 27
        theta(496) = dot_product(vrrbuffer(:,1), D(:,5)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,5)) ! ((5,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,5)) ! ((4,1,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,5)) ! ((4,0,1)|(0,0,0))
        theta(532) = dot_product(vrrbuffer(:,37), D(:,5)) ! ((6,0,0)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,5)) ! ((5,1,0)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,5)) ! ((5,0,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,5)) ! ((4,1,1)|(0,0,0))
        theta(561) = dot_product(vrrbuffer(:,66), D(:,5)) ! ((6,1,0)|(0,0,0))
        theta(562) = dot_product(vrrbuffer(:,67), D(:,5)) ! ((6,0,1)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,5)) ! ((5,1,1)|(0,0,0))
        theta(600) = dot_product(vrrbuffer(:,105), D(:,5)) ! ((6,1,1)|(0,0,0))
        theta(641) = theta(511)+theta(496)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(686) = theta(532)+theta(511)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(689) = theta(533)+theta(512)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(692) = theta(534)+theta(513)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(752) = theta(561)+theta(533)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(755) = theta(562)+theta(534)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(761) = theta(564)+theta(536)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(845) = theta(600)+theta(564)*AB(1) ! ((5,1,1)|(1,0,0)) = ((6,1,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(1)
        theta(941) = theta(686)+theta(641)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(1037) = theta(752)+theta(689)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(1043) = theta(755)+theta(692)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(1181) = theta(845)+theta(761)*AB(1) ! ((4,1,1)|(2,0,0)) = ((5,1,1)|(1,0,0))+((4,1,1)|(1,0,0))*AB(1)
        theta(1327) = theta(1043)+theta(941)*AB(3) ! ((4,0,0)|(2,0,1)) = ((4,0,1)|(2,0,0))+((4,0,0)|(2,0,0))*AB(3)
        theta(1487) = theta(1181)+theta(1037)*AB(3) ! ((4,1,0)|(2,0,1)) = ((4,1,1)|(2,0,0))+((4,1,0)|(2,0,0))*AB(3)
        theta(1689) = theta(1487)+theta(1327)*AB(2) ! ((4,0,0)|(2,1,1)) = ((4,1,0)|(2,0,1))+((4,0,0)|(2,0,1))*AB(2)
        ! (4,0,0|2,0,2): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,6)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,6)) ! ((5,0,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,6)) ! ((4,0,1)|(0,0,0))
        theta(532) = dot_product(vrrbuffer(:,37), D(:,6)) ! ((6,0,0)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,6)) ! ((5,0,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,6)) ! ((4,0,2)|(0,0,0))
        theta(562) = dot_product(vrrbuffer(:,67), D(:,6)) ! ((6,0,1)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,6)) ! ((5,0,2)|(0,0,0))
        theta(601) = dot_product(vrrbuffer(:,106), D(:,6)) ! ((6,0,2)|(0,0,0))
        theta(643) = theta(513)+theta(496)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(688) = theta(534)+theta(511)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(751) = theta(562)+theta(532)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(757) = theta(565)+theta(534)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(841) = theta(601)+theta(562)*AB(3) ! ((6,0,1)|(0,0,1)) = ((6,0,2)|(0,0,0))+((6,0,1)|(0,0,0))*AB(3)
        theta(946) = theta(694)+theta(643)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(1036) = theta(757)+theta(688)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(1162) = theta(841)+theta(751)*AB(3) ! ((6,0,0)|(0,0,2)) = ((6,0,1)|(0,0,1))+((6,0,0)|(0,0,1))*AB(3)
        theta(1330) = theta(1036)+theta(946)*AB(1) ! ((4,0,0)|(1,0,2)) = ((5,0,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(1)
        theta(1480) = theta(1162)+theta(1036)*AB(1) ! ((5,0,0)|(1,0,2)) = ((6,0,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(1)
        theta(1690) = theta(1480)+theta(1330)*AB(1) ! ((4,0,0)|(2,0,2)) = ((5,0,0)|(1,0,2))+((4,0,0)|(1,0,2))*AB(1)
        ! (4,0,0|1,3,0): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,7)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,7)) ! ((5,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,7)) ! ((4,1,0)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,7)) ! ((5,1,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,7)) ! ((4,2,0)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,7)) ! ((5,2,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,7)) ! ((4,3,0)|(0,0,0))
        theta(602) = dot_product(vrrbuffer(:,107), D(:,7)) ! ((5,3,0)|(0,0,0))
        theta(642) = theta(512)+theta(496)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(687) = theta(533)+theta(511)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(753) = theta(563)+theta(533)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(843) = theta(602)+theta(563)*AB(2) ! ((5,2,0)|(0,1,0)) = ((5,3,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(2)
        theta(944) = theta(690)+theta(642)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(1034) = theta(753)+theta(687)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        theta(1040) = theta(759)+theta(690)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(1166) = theta(843)+theta(753)*AB(2) ! ((5,1,0)|(0,2,0)) = ((5,2,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(2)
        theta(1331) = theta(1040)+theta(944)*AB(2) ! ((4,0,0)|(0,3,0)) = ((4,1,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(2)
        theta(1481) = theta(1166)+theta(1034)*AB(2) ! ((5,0,0)|(0,3,0)) = ((5,1,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(2)
        theta(1691) = theta(1481)+theta(1331)*AB(1) ! ((4,0,0)|(1,3,0)) = ((5,0,0)|(0,3,0))+((4,0,0)|(0,3,0))*AB(1)
        ! (4,0,0|1,2,1): 27
        theta(496) = dot_product(vrrbuffer(:,1), D(:,8)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,8)) ! ((5,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,8)) ! ((4,1,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,8)) ! ((4,0,1)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,8)) ! ((5,1,0)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,8)) ! ((5,0,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,8)) ! ((4,2,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,8)) ! ((4,1,1)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,8)) ! ((5,2,0)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,8)) ! ((5,1,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,8)) ! ((4,2,1)|(0,0,0))
        theta(603) = dot_product(vrrbuffer(:,108), D(:,8)) ! ((5,2,1)|(0,0,0))
        theta(642) = theta(512)+theta(496)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(687) = theta(533)+theta(511)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(693) = theta(536)+theta(513)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(753) = theta(563)+theta(533)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(756) = theta(564)+theta(534)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(846) = theta(603)+theta(564)*AB(2) ! ((5,1,1)|(0,1,0)) = ((5,2,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(2)
        theta(944) = theta(690)+theta(642)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(1034) = theta(753)+theta(687)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        theta(1046) = theta(762)+theta(693)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1172) = theta(846)+theta(756)*AB(2) ! ((5,0,1)|(0,2,0)) = ((5,1,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(2)
        theta(1332) = theta(1046)+theta(944)*AB(3) ! ((4,0,0)|(0,2,1)) = ((4,0,1)|(0,2,0))+((4,0,0)|(0,2,0))*AB(3)
        theta(1482) = theta(1172)+theta(1034)*AB(3) ! ((5,0,0)|(0,2,1)) = ((5,0,1)|(0,2,0))+((5,0,0)|(0,2,0))*AB(3)
        theta(1692) = theta(1482)+theta(1332)*AB(1) ! ((4,0,0)|(1,2,1)) = ((5,0,0)|(0,2,1))+((4,0,0)|(0,2,1))*AB(1)
        ! (4,0,0|1,1,2): 27
        theta(496) = dot_product(vrrbuffer(:,1), D(:,9)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,9)) ! ((5,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,9)) ! ((4,1,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,9)) ! ((4,0,1)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,9)) ! ((5,1,0)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,9)) ! ((5,0,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,9)) ! ((4,1,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,9)) ! ((4,0,2)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,9)) ! ((5,1,1)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,9)) ! ((5,0,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,9)) ! ((4,1,2)|(0,0,0))
        theta(604) = dot_product(vrrbuffer(:,109), D(:,9)) ! ((5,1,2)|(0,0,0))
        theta(643) = theta(513)+theta(496)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(688) = theta(534)+theta(511)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(691) = theta(536)+theta(512)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(754) = theta(564)+theta(533)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(757) = theta(565)+theta(534)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(847) = theta(604)+theta(564)*AB(3) ! ((5,1,1)|(0,0,1)) = ((5,1,2)|(0,0,0))+((5,1,1)|(0,0,0))*AB(3)
        theta(946) = theta(694)+theta(643)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(1036) = theta(757)+theta(688)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(1042) = theta(763)+theta(691)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1168) = theta(847)+theta(754)*AB(3) ! ((5,1,0)|(0,0,2)) = ((5,1,1)|(0,0,1))+((5,1,0)|(0,0,1))*AB(3)
        theta(1333) = theta(1042)+theta(946)*AB(2) ! ((4,0,0)|(0,1,2)) = ((4,1,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(2)
        theta(1483) = theta(1168)+theta(1036)*AB(2) ! ((5,0,0)|(0,1,2)) = ((5,1,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(2)
        theta(1693) = theta(1483)+theta(1333)*AB(1) ! ((4,0,0)|(1,1,2)) = ((5,0,0)|(0,1,2))+((4,0,0)|(0,1,2))*AB(1)
        ! (4,0,0|1,0,3): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,10)) ! ((4,0,0)|(0,0,0))
        theta(511) = dot_product(vrrbuffer(:,16), D(:,10)) ! ((5,0,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,10)) ! ((4,0,1)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,10)) ! ((5,0,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,10)) ! ((4,0,2)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,10)) ! ((5,0,2)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,10)) ! ((4,0,3)|(0,0,0))
        theta(605) = dot_product(vrrbuffer(:,110), D(:,10)) ! ((5,0,3)|(0,0,0))
        theta(643) = theta(513)+theta(496)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(688) = theta(534)+theta(511)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(757) = theta(565)+theta(534)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(850) = theta(605)+theta(565)*AB(3) ! ((5,0,2)|(0,0,1)) = ((5,0,3)|(0,0,0))+((5,0,2)|(0,0,0))*AB(3)
        theta(946) = theta(694)+theta(643)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(1036) = theta(757)+theta(688)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(1048) = theta(766)+theta(694)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1174) = theta(850)+theta(757)*AB(3) ! ((5,0,1)|(0,0,2)) = ((5,0,2)|(0,0,1))+((5,0,1)|(0,0,1))*AB(3)
        theta(1334) = theta(1048)+theta(946)*AB(3) ! ((4,0,0)|(0,0,3)) = ((4,0,1)|(0,0,2))+((4,0,0)|(0,0,2))*AB(3)
        theta(1484) = theta(1174)+theta(1036)*AB(3) ! ((5,0,0)|(0,0,3)) = ((5,0,1)|(0,0,2))+((5,0,0)|(0,0,2))*AB(3)
        theta(1694) = theta(1484)+theta(1334)*AB(1) ! ((4,0,0)|(1,0,3)) = ((5,0,0)|(0,0,3))+((4,0,0)|(0,0,3))*AB(1)
        ! (4,0,0|0,4,0): 15
        theta(496) = dot_product(vrrbuffer(:,1), D(:,11)) ! ((4,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,11)) ! ((4,1,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,11)) ! ((4,2,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,11)) ! ((4,3,0)|(0,0,0))
        theta(606) = dot_product(vrrbuffer(:,111), D(:,11)) ! ((4,4,0)|(0,0,0))
        theta(642) = theta(512)+theta(496)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(852) = theta(606)+theta(566)*AB(2) ! ((4,3,0)|(0,1,0)) = ((4,4,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(2)
        theta(944) = theta(690)+theta(642)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(1040) = theta(759)+theta(690)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(1178) = theta(852)+theta(759)*AB(2) ! ((4,2,0)|(0,2,0)) = ((4,3,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(2)
        theta(1331) = theta(1040)+theta(944)*AB(2) ! ((4,0,0)|(0,3,0)) = ((4,1,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(2)
        theta(1491) = theta(1178)+theta(1040)*AB(2) ! ((4,1,0)|(0,3,0)) = ((4,2,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(2)
        theta(1695) = theta(1491)+theta(1331)*AB(2) ! ((4,0,0)|(0,4,0)) = ((4,1,0)|(0,3,0))+((4,0,0)|(0,3,0))*AB(2)
        ! (4,0,0|0,3,1): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,12)) ! ((4,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,12)) ! ((4,1,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,12)) ! ((4,0,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,12)) ! ((4,2,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,12)) ! ((4,1,1)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,12)) ! ((4,3,0)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,12)) ! ((4,2,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,12)) ! ((4,3,1)|(0,0,0))
        theta(642) = theta(512)+theta(496)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(693) = theta(536)+theta(513)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(855) = theta(607)+theta(567)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(944) = theta(690)+theta(642)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(1040) = theta(759)+theta(690)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(1046) = theta(762)+theta(693)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1184) = theta(855)+theta(762)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1331) = theta(1040)+theta(944)*AB(2) ! ((4,0,0)|(0,3,0)) = ((4,1,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(2)
        theta(1501) = theta(1184)+theta(1046)*AB(2) ! ((4,0,1)|(0,3,0)) = ((4,1,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(2)
        theta(1696) = theta(1501)+theta(1331)*AB(3) ! ((4,0,0)|(0,3,1)) = ((4,0,1)|(0,3,0))+((4,0,0)|(0,3,0))*AB(3)
        ! (4,0,0|0,2,2): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,13)) ! ((4,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,13)) ! ((4,1,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,13)) ! ((4,0,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,13)) ! ((4,2,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,13)) ! ((4,1,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,13)) ! ((4,0,2)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,13)) ! ((4,2,1)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,13)) ! ((4,1,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,13)) ! ((4,2,2)|(0,0,0))
        theta(643) = theta(513)+theta(496)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(691) = theta(536)+theta(512)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(760) = theta(567)+theta(535)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(856) = theta(608)+theta(567)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(946) = theta(694)+theta(643)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(1042) = theta(763)+theta(691)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1180) = theta(856)+theta(760)*AB(3) ! ((4,2,0)|(0,0,2)) = ((4,2,1)|(0,0,1))+((4,2,0)|(0,0,1))*AB(3)
        theta(1333) = theta(1042)+theta(946)*AB(2) ! ((4,0,0)|(0,1,2)) = ((4,1,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(2)
        theta(1493) = theta(1180)+theta(1042)*AB(2) ! ((4,1,0)|(0,1,2)) = ((4,2,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(2)
        theta(1697) = theta(1493)+theta(1333)*AB(2) ! ((4,0,0)|(0,2,2)) = ((4,1,0)|(0,1,2))+((4,0,0)|(0,1,2))*AB(2)
        ! (4,0,0|0,1,3): 21
        theta(496) = dot_product(vrrbuffer(:,1), D(:,14)) ! ((4,0,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,14)) ! ((4,1,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,14)) ! ((4,0,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,14)) ! ((4,1,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,14)) ! ((4,0,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,14)) ! ((4,1,2)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,14)) ! ((4,0,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,14)) ! ((4,1,3)|(0,0,0))
        theta(643) = theta(513)+theta(496)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(691) = theta(536)+theta(512)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(859) = theta(609)+theta(568)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(946) = theta(694)+theta(643)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(1042) = theta(763)+theta(691)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1048) = theta(766)+theta(694)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1186) = theta(859)+theta(763)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1334) = theta(1048)+theta(946)*AB(3) ! ((4,0,0)|(0,0,3)) = ((4,0,1)|(0,0,2))+((4,0,0)|(0,0,2))*AB(3)
        theta(1494) = theta(1186)+theta(1042)*AB(3) ! ((4,1,0)|(0,0,3)) = ((4,1,1)|(0,0,2))+((4,1,0)|(0,0,2))*AB(3)
        theta(1698) = theta(1494)+theta(1334)*AB(2) ! ((4,0,0)|(0,1,3)) = ((4,1,0)|(0,0,3))+((4,0,0)|(0,0,3))*AB(2)
        ! (4,0,0|0,0,4): 15
        theta(496) = dot_product(vrrbuffer(:,1), D(:,15)) ! ((4,0,0)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,15)) ! ((4,0,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,15)) ! ((4,0,2)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,15)) ! ((4,0,3)|(0,0,0))
        theta(610) = dot_product(vrrbuffer(:,115), D(:,15)) ! ((4,0,4)|(0,0,0))
        theta(643) = theta(513)+theta(496)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(862) = theta(610)+theta(569)*AB(3) ! ((4,0,3)|(0,0,1)) = ((4,0,4)|(0,0,0))+((4,0,3)|(0,0,0))*AB(3)
        theta(946) = theta(694)+theta(643)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(1048) = theta(766)+theta(694)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1192) = theta(862)+theta(766)*AB(3) ! ((4,0,2)|(0,0,2)) = ((4,0,3)|(0,0,1))+((4,0,2)|(0,0,1))*AB(3)
        theta(1334) = theta(1048)+theta(946)*AB(3) ! ((4,0,0)|(0,0,3)) = ((4,0,1)|(0,0,2))+((4,0,0)|(0,0,2))*AB(3)
        theta(1504) = theta(1192)+theta(1048)*AB(3) ! ((4,0,1)|(0,0,3)) = ((4,0,2)|(0,0,2))+((4,0,1)|(0,0,2))*AB(3)
        theta(1699) = theta(1504)+theta(1334)*AB(3) ! ((4,0,0)|(0,0,4)) = ((4,0,1)|(0,0,3))+((4,0,0)|(0,0,3))*AB(3)
        ! (3,1,0|4,0,0): 15
        theta(497) = dot_product(vrrbuffer(:,2), D(:,16)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,16)) ! ((4,1,0)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,16)) ! ((5,1,0)|(0,0,0))
        theta(561) = dot_product(vrrbuffer(:,66), D(:,16)) ! ((6,1,0)|(0,0,0))
        theta(597) = dot_product(vrrbuffer(:,102), D(:,16)) ! ((7,1,0)|(0,0,0))
        theta(644) = theta(512)+theta(497)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(689) = theta(533)+theta(512)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(752) = theta(561)+theta(533)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(836) = theta(597)+theta(561)*AB(1) ! ((6,1,0)|(1,0,0)) = ((7,1,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(1)
        theta(947) = theta(689)+theta(644)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(1037) = theta(752)+theta(689)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(1163) = theta(836)+theta(752)*AB(1) ! ((5,1,0)|(2,0,0)) = ((6,1,0)|(1,0,0))+((5,1,0)|(1,0,0))*AB(1)
        theta(1335) = theta(1037)+theta(947)*AB(1) ! ((3,1,0)|(3,0,0)) = ((4,1,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(1)
        theta(1485) = theta(1163)+theta(1037)*AB(1) ! ((4,1,0)|(3,0,0)) = ((5,1,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(1)
        theta(1700) = theta(1485)+theta(1335)*AB(1) ! ((3,1,0)|(4,0,0)) = ((4,1,0)|(3,0,0))+((3,1,0)|(3,0,0))*AB(1)
        ! (3,1,0|3,1,0): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,17)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,17)) ! ((4,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,17)) ! ((3,2,0)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,17)) ! ((5,1,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,17)) ! ((4,2,0)|(0,0,0))
        theta(561) = dot_product(vrrbuffer(:,66), D(:,17)) ! ((6,1,0)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,17)) ! ((5,2,0)|(0,0,0))
        theta(599) = dot_product(vrrbuffer(:,104), D(:,17)) ! ((6,2,0)|(0,0,0))
        theta(644) = theta(512)+theta(497)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(689) = theta(533)+theta(512)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(695) = theta(535)+theta(514)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(752) = theta(561)+theta(533)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(758) = theta(563)+theta(535)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(842) = theta(599)+theta(563)*AB(1) ! ((5,2,0)|(1,0,0)) = ((6,2,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(1)
        theta(947) = theta(689)+theta(644)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(1037) = theta(752)+theta(689)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(1049) = theta(758)+theta(695)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(1175) = theta(842)+theta(758)*AB(1) ! ((4,2,0)|(2,0,0)) = ((5,2,0)|(1,0,0))+((4,2,0)|(1,0,0))*AB(1)
        theta(1335) = theta(1037)+theta(947)*AB(1) ! ((3,1,0)|(3,0,0)) = ((4,1,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(1)
        theta(1505) = theta(1175)+theta(1049)*AB(1) ! ((3,2,0)|(3,0,0)) = ((4,2,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(1)
        theta(1701) = theta(1505)+theta(1335)*AB(2) ! ((3,1,0)|(3,1,0)) = ((3,2,0)|(3,0,0))+((3,1,0)|(3,0,0))*AB(2)
        ! (3,1,0|3,0,1): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,18)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,18)) ! ((4,1,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,18)) ! ((3,1,1)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,18)) ! ((5,1,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,18)) ! ((4,1,1)|(0,0,0))
        theta(561) = dot_product(vrrbuffer(:,66), D(:,18)) ! ((6,1,0)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,18)) ! ((5,1,1)|(0,0,0))
        theta(600) = dot_product(vrrbuffer(:,105), D(:,18)) ! ((6,1,1)|(0,0,0))
        theta(644) = theta(512)+theta(497)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(689) = theta(533)+theta(512)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(698) = theta(536)+theta(515)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(752) = theta(561)+theta(533)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(761) = theta(564)+theta(536)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(845) = theta(600)+theta(564)*AB(1) ! ((5,1,1)|(1,0,0)) = ((6,1,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(1)
        theta(947) = theta(689)+theta(644)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(1037) = theta(752)+theta(689)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(1055) = theta(761)+theta(698)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(1181) = theta(845)+theta(761)*AB(1) ! ((4,1,1)|(2,0,0)) = ((5,1,1)|(1,0,0))+((4,1,1)|(1,0,0))*AB(1)
        theta(1335) = theta(1037)+theta(947)*AB(1) ! ((3,1,0)|(3,0,0)) = ((4,1,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(1)
        theta(1515) = theta(1181)+theta(1055)*AB(1) ! ((3,1,1)|(3,0,0)) = ((4,1,1)|(2,0,0))+((3,1,1)|(2,0,0))*AB(1)
        theta(1702) = theta(1515)+theta(1335)*AB(3) ! ((3,1,0)|(3,0,1)) = ((3,1,1)|(3,0,0))+((3,1,0)|(3,0,0))*AB(3)
        ! (3,1,0|2,2,0): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,19)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,19)) ! ((4,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,19)) ! ((3,2,0)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,19)) ! ((5,1,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,19)) ! ((4,2,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,19)) ! ((3,3,0)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,19)) ! ((5,2,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,19)) ! ((4,3,0)|(0,0,0))
        theta(602) = dot_product(vrrbuffer(:,107), D(:,19)) ! ((5,3,0)|(0,0,0))
        theta(645) = theta(514)+theta(497)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(753) = theta(563)+theta(533)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(843) = theta(602)+theta(563)*AB(2) ! ((5,2,0)|(0,1,0)) = ((5,3,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(2)
        theta(950) = theta(696)+theta(645)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(1040) = theta(759)+theta(690)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(1166) = theta(843)+theta(753)*AB(2) ! ((5,1,0)|(0,2,0)) = ((5,2,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(2)
        theta(1338) = theta(1040)+theta(950)*AB(1) ! ((3,1,0)|(1,2,0)) = ((4,1,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(1)
        theta(1488) = theta(1166)+theta(1040)*AB(1) ! ((4,1,0)|(1,2,0)) = ((5,1,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(1)
        theta(1703) = theta(1488)+theta(1338)*AB(1) ! ((3,1,0)|(2,2,0)) = ((4,1,0)|(1,2,0))+((3,1,0)|(1,2,0))*AB(1)
        ! (3,1,0|2,1,1): 27
        theta(497) = dot_product(vrrbuffer(:,2), D(:,20)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,20)) ! ((4,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,20)) ! ((3,2,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,20)) ! ((3,1,1)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,20)) ! ((5,1,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,20)) ! ((4,2,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,20)) ! ((4,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,20)) ! ((3,2,1)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,20)) ! ((5,2,0)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,20)) ! ((5,1,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,20)) ! ((4,2,1)|(0,0,0))
        theta(603) = dot_product(vrrbuffer(:,108), D(:,20)) ! ((5,2,1)|(0,0,0))
        theta(644) = theta(512)+theta(497)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(689) = theta(533)+theta(512)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(695) = theta(535)+theta(514)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(698) = theta(536)+theta(515)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(758) = theta(563)+theta(535)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(761) = theta(564)+theta(536)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(770) = theta(567)+theta(539)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(854) = theta(603)+theta(567)*AB(1) ! ((4,2,1)|(1,0,0)) = ((5,2,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(1)
        theta(947) = theta(689)+theta(644)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(1049) = theta(758)+theta(695)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(1055) = theta(761)+theta(698)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(1199) = theta(854)+theta(770)*AB(1) ! ((3,2,1)|(2,0,0)) = ((4,2,1)|(1,0,0))+((3,2,1)|(1,0,0))*AB(1)
        theta(1337) = theta(1055)+theta(947)*AB(3) ! ((3,1,0)|(2,0,1)) = ((3,1,1)|(2,0,0))+((3,1,0)|(2,0,0))*AB(3)
        theta(1507) = theta(1199)+theta(1049)*AB(3) ! ((3,2,0)|(2,0,1)) = ((3,2,1)|(2,0,0))+((3,2,0)|(2,0,0))*AB(3)
        theta(1704) = theta(1507)+theta(1337)*AB(2) ! ((3,1,0)|(2,1,1)) = ((3,2,0)|(2,0,1))+((3,1,0)|(2,0,1))*AB(2)
        ! (3,1,0|2,0,2): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,21)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,21)) ! ((4,1,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,21)) ! ((3,1,1)|(0,0,0))
        theta(533) = dot_product(vrrbuffer(:,38), D(:,21)) ! ((5,1,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,21)) ! ((4,1,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,21)) ! ((3,1,2)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,21)) ! ((5,1,1)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,21)) ! ((4,1,2)|(0,0,0))
        theta(604) = dot_product(vrrbuffer(:,109), D(:,21)) ! ((5,1,2)|(0,0,0))
        theta(646) = theta(515)+theta(497)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(691) = theta(536)+theta(512)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(754) = theta(564)+theta(533)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(847) = theta(604)+theta(564)*AB(3) ! ((5,1,1)|(0,0,1)) = ((5,1,2)|(0,0,0))+((5,1,1)|(0,0,0))*AB(3)
        theta(952) = theta(700)+theta(646)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(1042) = theta(763)+theta(691)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1168) = theta(847)+theta(754)*AB(3) ! ((5,1,0)|(0,0,2)) = ((5,1,1)|(0,0,1))+((5,1,0)|(0,0,1))*AB(3)
        theta(1340) = theta(1042)+theta(952)*AB(1) ! ((3,1,0)|(1,0,2)) = ((4,1,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(1)
        theta(1490) = theta(1168)+theta(1042)*AB(1) ! ((4,1,0)|(1,0,2)) = ((5,1,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(1)
        theta(1705) = theta(1490)+theta(1340)*AB(1) ! ((3,1,0)|(2,0,2)) = ((4,1,0)|(1,0,2))+((3,1,0)|(1,0,2))*AB(1)
        ! (3,1,0|1,3,0): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,22)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,22)) ! ((4,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,22)) ! ((3,2,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,22)) ! ((4,2,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,22)) ! ((3,3,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,22)) ! ((4,3,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,22)) ! ((3,4,0)|(0,0,0))
        theta(606) = dot_product(vrrbuffer(:,111), D(:,22)) ! ((4,4,0)|(0,0,0))
        theta(645) = theta(514)+theta(497)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(852) = theta(606)+theta(566)*AB(2) ! ((4,3,0)|(0,1,0)) = ((4,4,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(2)
        theta(950) = theta(696)+theta(645)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(1040) = theta(759)+theta(690)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(1052) = theta(768)+theta(696)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(1178) = theta(852)+theta(759)*AB(2) ! ((4,2,0)|(0,2,0)) = ((4,3,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(2)
        theta(1341) = theta(1052)+theta(950)*AB(2) ! ((3,1,0)|(0,3,0)) = ((3,2,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(2)
        theta(1491) = theta(1178)+theta(1040)*AB(2) ! ((4,1,0)|(0,3,0)) = ((4,2,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(2)
        theta(1706) = theta(1491)+theta(1341)*AB(1) ! ((3,1,0)|(1,3,0)) = ((4,1,0)|(0,3,0))+((3,1,0)|(0,3,0))*AB(1)
        ! (3,1,0|1,2,1): 27
        theta(497) = dot_product(vrrbuffer(:,2), D(:,23)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,23)) ! ((4,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,23)) ! ((3,2,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,23)) ! ((3,1,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,23)) ! ((4,2,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,23)) ! ((4,1,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,23)) ! ((3,3,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,23)) ! ((3,2,1)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,23)) ! ((4,3,0)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,23)) ! ((4,2,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,23)) ! ((3,3,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,23)) ! ((4,3,1)|(0,0,0))
        theta(645) = theta(514)+theta(497)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(855) = theta(607)+theta(567)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(950) = theta(696)+theta(645)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(1040) = theta(759)+theta(690)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1184) = theta(855)+theta(762)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1342) = theta(1058)+theta(950)*AB(3) ! ((3,1,0)|(0,2,1)) = ((3,1,1)|(0,2,0))+((3,1,0)|(0,2,0))*AB(3)
        theta(1492) = theta(1184)+theta(1040)*AB(3) ! ((4,1,0)|(0,2,1)) = ((4,1,1)|(0,2,0))+((4,1,0)|(0,2,0))*AB(3)
        theta(1707) = theta(1492)+theta(1342)*AB(1) ! ((3,1,0)|(1,2,1)) = ((4,1,0)|(0,2,1))+((3,1,0)|(0,2,1))*AB(1)
        ! (3,1,0|1,1,2): 27
        theta(497) = dot_product(vrrbuffer(:,2), D(:,24)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,24)) ! ((4,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,24)) ! ((3,2,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,24)) ! ((3,1,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,24)) ! ((4,2,0)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,24)) ! ((4,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,24)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,24)) ! ((3,1,2)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,24)) ! ((4,2,1)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,24)) ! ((4,1,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,24)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,24)) ! ((4,2,2)|(0,0,0))
        theta(646) = theta(515)+theta(497)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(691) = theta(536)+theta(512)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(697) = theta(539)+theta(514)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(760) = theta(567)+theta(535)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(856) = theta(608)+theta(567)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(952) = theta(700)+theta(646)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(1042) = theta(763)+theta(691)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1054) = theta(772)+theta(697)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1180) = theta(856)+theta(760)*AB(3) ! ((4,2,0)|(0,0,2)) = ((4,2,1)|(0,0,1))+((4,2,0)|(0,0,1))*AB(3)
        theta(1343) = theta(1054)+theta(952)*AB(2) ! ((3,1,0)|(0,1,2)) = ((3,2,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(2)
        theta(1493) = theta(1180)+theta(1042)*AB(2) ! ((4,1,0)|(0,1,2)) = ((4,2,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(2)
        theta(1708) = theta(1493)+theta(1343)*AB(1) ! ((3,1,0)|(1,1,2)) = ((4,1,0)|(0,1,2))+((3,1,0)|(0,1,2))*AB(1)
        ! (3,1,0|1,0,3): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,25)) ! ((3,1,0)|(0,0,0))
        theta(512) = dot_product(vrrbuffer(:,17), D(:,25)) ! ((4,1,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,25)) ! ((3,1,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,25)) ! ((4,1,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,25)) ! ((3,1,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,25)) ! ((4,1,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,25)) ! ((3,1,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,25)) ! ((4,1,3)|(0,0,0))
        theta(646) = theta(515)+theta(497)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(691) = theta(536)+theta(512)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(859) = theta(609)+theta(568)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(952) = theta(700)+theta(646)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(1042) = theta(763)+theta(691)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1186) = theta(859)+theta(763)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1344) = theta(1060)+theta(952)*AB(3) ! ((3,1,0)|(0,0,3)) = ((3,1,1)|(0,0,2))+((3,1,0)|(0,0,2))*AB(3)
        theta(1494) = theta(1186)+theta(1042)*AB(3) ! ((4,1,0)|(0,0,3)) = ((4,1,1)|(0,0,2))+((4,1,0)|(0,0,2))*AB(3)
        theta(1709) = theta(1494)+theta(1344)*AB(1) ! ((3,1,0)|(1,0,3)) = ((4,1,0)|(0,0,3))+((3,1,0)|(0,0,3))*AB(1)
        ! (3,1,0|0,4,0): 15
        theta(497) = dot_product(vrrbuffer(:,2), D(:,26)) ! ((3,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,26)) ! ((3,2,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,26)) ! ((3,3,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,26)) ! ((3,4,0)|(0,0,0))
        theta(611) = dot_product(vrrbuffer(:,116), D(:,26)) ! ((3,5,0)|(0,0,0))
        theta(645) = theta(514)+theta(497)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(864) = theta(611)+theta(570)*AB(2) ! ((3,4,0)|(0,1,0)) = ((3,5,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(2)
        theta(950) = theta(696)+theta(645)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(1052) = theta(768)+theta(696)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(1196) = theta(864)+theta(768)*AB(2) ! ((3,3,0)|(0,2,0)) = ((3,4,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(2)
        theta(1341) = theta(1052)+theta(950)*AB(2) ! ((3,1,0)|(0,3,0)) = ((3,2,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(2)
        theta(1511) = theta(1196)+theta(1052)*AB(2) ! ((3,2,0)|(0,3,0)) = ((3,3,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(2)
        theta(1710) = theta(1511)+theta(1341)*AB(2) ! ((3,1,0)|(0,4,0)) = ((3,2,0)|(0,3,0))+((3,1,0)|(0,3,0))*AB(2)
        ! (3,1,0|0,3,1): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,27)) ! ((3,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,27)) ! ((3,2,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,27)) ! ((3,1,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,27)) ! ((3,3,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,27)) ! ((3,2,1)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,27)) ! ((3,4,0)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,27)) ! ((3,3,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,27)) ! ((3,4,1)|(0,0,0))
        theta(645) = theta(514)+theta(497)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(867) = theta(612)+theta(571)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(950) = theta(696)+theta(645)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(1052) = theta(768)+theta(696)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1202) = theta(867)+theta(771)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1341) = theta(1052)+theta(950)*AB(2) ! ((3,1,0)|(0,3,0)) = ((3,2,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(2)
        theta(1521) = theta(1202)+theta(1058)*AB(2) ! ((3,1,1)|(0,3,0)) = ((3,2,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(2)
        theta(1711) = theta(1521)+theta(1341)*AB(3) ! ((3,1,0)|(0,3,1)) = ((3,1,1)|(0,3,0))+((3,1,0)|(0,3,0))*AB(3)
        ! (3,1,0|0,2,2): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,28)) ! ((3,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,28)) ! ((3,2,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,28)) ! ((3,1,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,28)) ! ((3,3,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,28)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,28)) ! ((3,1,2)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,28)) ! ((3,3,1)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,28)) ! ((3,2,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,28)) ! ((3,3,2)|(0,0,0))
        theta(646) = theta(515)+theta(497)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(697) = theta(539)+theta(514)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(769) = theta(571)+theta(538)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(868) = theta(613)+theta(571)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(952) = theta(700)+theta(646)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(1054) = theta(772)+theta(697)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1198) = theta(868)+theta(769)*AB(3) ! ((3,3,0)|(0,0,2)) = ((3,3,1)|(0,0,1))+((3,3,0)|(0,0,1))*AB(3)
        theta(1343) = theta(1054)+theta(952)*AB(2) ! ((3,1,0)|(0,1,2)) = ((3,2,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(2)
        theta(1513) = theta(1198)+theta(1054)*AB(2) ! ((3,2,0)|(0,1,2)) = ((3,3,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(2)
        theta(1712) = theta(1513)+theta(1343)*AB(2) ! ((3,1,0)|(0,2,2)) = ((3,2,0)|(0,1,2))+((3,1,0)|(0,1,2))*AB(2)
        ! (3,1,0|0,1,3): 21
        theta(497) = dot_product(vrrbuffer(:,2), D(:,29)) ! ((3,1,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,29)) ! ((3,2,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,29)) ! ((3,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,29)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,29)) ! ((3,1,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,29)) ! ((3,2,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,29)) ! ((3,1,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,29)) ! ((3,2,3)|(0,0,0))
        theta(646) = theta(515)+theta(497)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(697) = theta(539)+theta(514)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(871) = theta(614)+theta(572)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(952) = theta(700)+theta(646)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(1054) = theta(772)+theta(697)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1204) = theta(871)+theta(772)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1344) = theta(1060)+theta(952)*AB(3) ! ((3,1,0)|(0,0,3)) = ((3,1,1)|(0,0,2))+((3,1,0)|(0,0,2))*AB(3)
        theta(1514) = theta(1204)+theta(1054)*AB(3) ! ((3,2,0)|(0,0,3)) = ((3,2,1)|(0,0,2))+((3,2,0)|(0,0,2))*AB(3)
        theta(1713) = theta(1514)+theta(1344)*AB(2) ! ((3,1,0)|(0,1,3)) = ((3,2,0)|(0,0,3))+((3,1,0)|(0,0,3))*AB(2)
        ! (3,1,0|0,0,4): 15
        theta(497) = dot_product(vrrbuffer(:,2), D(:,30)) ! ((3,1,0)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,30)) ! ((3,1,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,30)) ! ((3,1,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,30)) ! ((3,1,3)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,30)) ! ((3,1,4)|(0,0,0))
        theta(646) = theta(515)+theta(497)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(874) = theta(615)+theta(573)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(952) = theta(700)+theta(646)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1210) = theta(874)+theta(775)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1344) = theta(1060)+theta(952)*AB(3) ! ((3,1,0)|(0,0,3)) = ((3,1,1)|(0,0,2))+((3,1,0)|(0,0,2))*AB(3)
        theta(1524) = theta(1210)+theta(1060)*AB(3) ! ((3,1,1)|(0,0,3)) = ((3,1,2)|(0,0,2))+((3,1,1)|(0,0,2))*AB(3)
        theta(1714) = theta(1524)+theta(1344)*AB(3) ! ((3,1,0)|(0,0,4)) = ((3,1,1)|(0,0,3))+((3,1,0)|(0,0,3))*AB(3)
        ! (3,0,1|4,0,0): 15
        theta(498) = dot_product(vrrbuffer(:,3), D(:,31)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,31)) ! ((4,0,1)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,31)) ! ((5,0,1)|(0,0,0))
        theta(562) = dot_product(vrrbuffer(:,67), D(:,31)) ! ((6,0,1)|(0,0,0))
        theta(598) = dot_product(vrrbuffer(:,103), D(:,31)) ! ((7,0,1)|(0,0,0))
        theta(647) = theta(513)+theta(498)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(692) = theta(534)+theta(513)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(755) = theta(562)+theta(534)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(839) = theta(598)+theta(562)*AB(1) ! ((6,0,1)|(1,0,0)) = ((7,0,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(1)
        theta(953) = theta(692)+theta(647)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(1043) = theta(755)+theta(692)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(1169) = theta(839)+theta(755)*AB(1) ! ((5,0,1)|(2,0,0)) = ((6,0,1)|(1,0,0))+((5,0,1)|(1,0,0))*AB(1)
        theta(1345) = theta(1043)+theta(953)*AB(1) ! ((3,0,1)|(3,0,0)) = ((4,0,1)|(2,0,0))+((3,0,1)|(2,0,0))*AB(1)
        theta(1495) = theta(1169)+theta(1043)*AB(1) ! ((4,0,1)|(3,0,0)) = ((5,0,1)|(2,0,0))+((4,0,1)|(2,0,0))*AB(1)
        theta(1715) = theta(1495)+theta(1345)*AB(1) ! ((3,0,1)|(4,0,0)) = ((4,0,1)|(3,0,0))+((3,0,1)|(3,0,0))*AB(1)
        ! (3,0,1|3,1,0): 18
        theta(498) = dot_product(vrrbuffer(:,3), D(:,32)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,32)) ! ((4,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,32)) ! ((3,1,1)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,32)) ! ((5,0,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,32)) ! ((4,1,1)|(0,0,0))
        theta(562) = dot_product(vrrbuffer(:,67), D(:,32)) ! ((6,0,1)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,32)) ! ((5,1,1)|(0,0,0))
        theta(600) = dot_product(vrrbuffer(:,105), D(:,32)) ! ((6,1,1)|(0,0,0))
        theta(648) = theta(515)+theta(498)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(693) = theta(536)+theta(513)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(756) = theta(564)+theta(534)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(840) = theta(600)+theta(562)*AB(2) ! ((6,0,1)|(0,1,0)) = ((6,1,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(2)
        theta(954) = theta(693)+theta(648)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        theta(1044) = theta(756)+theta(693)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        theta(1170) = theta(840)+theta(756)*AB(1) ! ((5,0,1)|(1,1,0)) = ((6,0,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(1)
        theta(1346) = theta(1044)+theta(954)*AB(1) ! ((3,0,1)|(2,1,0)) = ((4,0,1)|(1,1,0))+((3,0,1)|(1,1,0))*AB(1)
        theta(1496) = theta(1170)+theta(1044)*AB(1) ! ((4,0,1)|(2,1,0)) = ((5,0,1)|(1,1,0))+((4,0,1)|(1,1,0))*AB(1)
        theta(1716) = theta(1496)+theta(1346)*AB(1) ! ((3,0,1)|(3,1,0)) = ((4,0,1)|(2,1,0))+((3,0,1)|(2,1,0))*AB(1)
        ! (3,0,1|3,0,1): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,33)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,33)) ! ((4,0,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,33)) ! ((3,0,2)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,33)) ! ((5,0,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,33)) ! ((4,0,2)|(0,0,0))
        theta(562) = dot_product(vrrbuffer(:,67), D(:,33)) ! ((6,0,1)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,33)) ! ((5,0,2)|(0,0,0))
        theta(601) = dot_product(vrrbuffer(:,106), D(:,33)) ! ((6,0,2)|(0,0,0))
        theta(647) = theta(513)+theta(498)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(692) = theta(534)+theta(513)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(701) = theta(537)+theta(516)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(755) = theta(562)+theta(534)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(764) = theta(565)+theta(537)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(848) = theta(601)+theta(565)*AB(1) ! ((5,0,2)|(1,0,0)) = ((6,0,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(1)
        theta(953) = theta(692)+theta(647)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(1043) = theta(755)+theta(692)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(1061) = theta(764)+theta(701)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(1187) = theta(848)+theta(764)*AB(1) ! ((4,0,2)|(2,0,0)) = ((5,0,2)|(1,0,0))+((4,0,2)|(1,0,0))*AB(1)
        theta(1345) = theta(1043)+theta(953)*AB(1) ! ((3,0,1)|(3,0,0)) = ((4,0,1)|(2,0,0))+((3,0,1)|(2,0,0))*AB(1)
        theta(1525) = theta(1187)+theta(1061)*AB(1) ! ((3,0,2)|(3,0,0)) = ((4,0,2)|(2,0,0))+((3,0,2)|(2,0,0))*AB(1)
        theta(1717) = theta(1525)+theta(1345)*AB(3) ! ((3,0,1)|(3,0,1)) = ((3,0,2)|(3,0,0))+((3,0,1)|(3,0,0))*AB(3)
        ! (3,0,1|2,2,0): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,34)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,34)) ! ((4,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,34)) ! ((3,1,1)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,34)) ! ((5,0,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,34)) ! ((4,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,34)) ! ((3,2,1)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,34)) ! ((5,1,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,34)) ! ((4,2,1)|(0,0,0))
        theta(603) = dot_product(vrrbuffer(:,108), D(:,34)) ! ((5,2,1)|(0,0,0))
        theta(648) = theta(515)+theta(498)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(693) = theta(536)+theta(513)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(756) = theta(564)+theta(534)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(846) = theta(603)+theta(564)*AB(2) ! ((5,1,1)|(0,1,0)) = ((5,2,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(2)
        theta(956) = theta(699)+theta(648)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(1046) = theta(762)+theta(693)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1172) = theta(846)+theta(756)*AB(2) ! ((5,0,1)|(0,2,0)) = ((5,1,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(2)
        theta(1348) = theta(1046)+theta(956)*AB(1) ! ((3,0,1)|(1,2,0)) = ((4,0,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(1)
        theta(1498) = theta(1172)+theta(1046)*AB(1) ! ((4,0,1)|(1,2,0)) = ((5,0,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(1)
        theta(1718) = theta(1498)+theta(1348)*AB(1) ! ((3,0,1)|(2,2,0)) = ((4,0,1)|(1,2,0))+((3,0,1)|(1,2,0))*AB(1)
        ! (3,0,1|2,1,1): 24
        theta(498) = dot_product(vrrbuffer(:,3), D(:,35)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,35)) ! ((4,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,35)) ! ((3,1,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,35)) ! ((3,0,2)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,35)) ! ((5,0,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,35)) ! ((4,1,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,35)) ! ((4,0,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,35)) ! ((3,1,2)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,35)) ! ((5,1,1)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,35)) ! ((5,0,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,35)) ! ((4,1,2)|(0,0,0))
        theta(604) = dot_product(vrrbuffer(:,109), D(:,35)) ! ((5,1,2)|(0,0,0))
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(757) = theta(565)+theta(534)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(847) = theta(604)+theta(564)*AB(3) ! ((5,1,1)|(0,0,1)) = ((5,1,2)|(0,0,0))+((5,1,1)|(0,0,0))*AB(3)
        theta(957) = theta(700)+theta(649)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        theta(1047) = theta(763)+theta(694)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(1173) = theta(847)+theta(757)*AB(2) ! ((5,0,1)|(0,1,1)) = ((5,1,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(2)
        theta(1349) = theta(1047)+theta(957)*AB(1) ! ((3,0,1)|(1,1,1)) = ((4,0,1)|(0,1,1))+((3,0,1)|(0,1,1))*AB(1)
        theta(1499) = theta(1173)+theta(1047)*AB(1) ! ((4,0,1)|(1,1,1)) = ((5,0,1)|(0,1,1))+((4,0,1)|(0,1,1))*AB(1)
        theta(1719) = theta(1499)+theta(1349)*AB(1) ! ((3,0,1)|(2,1,1)) = ((4,0,1)|(1,1,1))+((3,0,1)|(1,1,1))*AB(1)
        ! (3,0,1|2,0,2): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,36)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,36)) ! ((4,0,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,36)) ! ((3,0,2)|(0,0,0))
        theta(534) = dot_product(vrrbuffer(:,39), D(:,36)) ! ((5,0,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,36)) ! ((4,0,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,36)) ! ((3,0,3)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,36)) ! ((5,0,2)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,36)) ! ((4,0,3)|(0,0,0))
        theta(605) = dot_product(vrrbuffer(:,110), D(:,36)) ! ((5,0,3)|(0,0,0))
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(757) = theta(565)+theta(534)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(850) = theta(605)+theta(565)*AB(3) ! ((5,0,2)|(0,0,1)) = ((5,0,3)|(0,0,0))+((5,0,2)|(0,0,0))*AB(3)
        theta(958) = theta(703)+theta(649)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(1048) = theta(766)+theta(694)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1174) = theta(850)+theta(757)*AB(3) ! ((5,0,1)|(0,0,2)) = ((5,0,2)|(0,0,1))+((5,0,1)|(0,0,1))*AB(3)
        theta(1350) = theta(1048)+theta(958)*AB(1) ! ((3,0,1)|(1,0,2)) = ((4,0,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(1)
        theta(1500) = theta(1174)+theta(1048)*AB(1) ! ((4,0,1)|(1,0,2)) = ((5,0,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(1)
        theta(1720) = theta(1500)+theta(1350)*AB(1) ! ((3,0,1)|(2,0,2)) = ((4,0,1)|(1,0,2))+((3,0,1)|(1,0,2))*AB(1)
        ! (3,0,1|1,3,0): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,37)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,37)) ! ((4,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,37)) ! ((3,1,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,37)) ! ((4,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,37)) ! ((3,2,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,37)) ! ((4,2,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,37)) ! ((3,3,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,37)) ! ((4,3,1)|(0,0,0))
        theta(648) = theta(515)+theta(498)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(693) = theta(536)+theta(513)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(855) = theta(607)+theta(567)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(956) = theta(699)+theta(648)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(1046) = theta(762)+theta(693)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1184) = theta(855)+theta(762)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1351) = theta(1058)+theta(956)*AB(2) ! ((3,0,1)|(0,3,0)) = ((3,1,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(2)
        theta(1501) = theta(1184)+theta(1046)*AB(2) ! ((4,0,1)|(0,3,0)) = ((4,1,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(2)
        theta(1721) = theta(1501)+theta(1351)*AB(1) ! ((3,0,1)|(1,3,0)) = ((4,0,1)|(0,3,0))+((3,0,1)|(0,3,0))*AB(1)
        ! (3,0,1|1,2,1): 27
        theta(498) = dot_product(vrrbuffer(:,3), D(:,38)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,38)) ! ((4,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,38)) ! ((3,1,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,38)) ! ((3,0,2)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,38)) ! ((4,1,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,38)) ! ((4,0,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,38)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,38)) ! ((3,1,2)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,38)) ! ((4,2,1)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,38)) ! ((4,1,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,38)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,38)) ! ((4,2,2)|(0,0,0))
        theta(648) = theta(515)+theta(498)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(693) = theta(536)+theta(513)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(702) = theta(540)+theta(516)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(765) = theta(568)+theta(537)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(858) = theta(608)+theta(568)*AB(2) ! ((4,1,2)|(0,1,0)) = ((4,2,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(2)
        theta(956) = theta(699)+theta(648)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(1046) = theta(762)+theta(693)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1064) = theta(774)+theta(702)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1190) = theta(858)+theta(765)*AB(2) ! ((4,0,2)|(0,2,0)) = ((4,1,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(2)
        theta(1352) = theta(1064)+theta(956)*AB(3) ! ((3,0,1)|(0,2,1)) = ((3,0,2)|(0,2,0))+((3,0,1)|(0,2,0))*AB(3)
        theta(1502) = theta(1190)+theta(1046)*AB(3) ! ((4,0,1)|(0,2,1)) = ((4,0,2)|(0,2,0))+((4,0,1)|(0,2,0))*AB(3)
        theta(1722) = theta(1502)+theta(1352)*AB(1) ! ((3,0,1)|(1,2,1)) = ((4,0,1)|(0,2,1))+((3,0,1)|(0,2,1))*AB(1)
        ! (3,0,1|1,1,2): 27
        theta(498) = dot_product(vrrbuffer(:,3), D(:,39)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,39)) ! ((4,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,39)) ! ((3,1,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,39)) ! ((3,0,2)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,39)) ! ((4,1,1)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,39)) ! ((4,0,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,39)) ! ((3,1,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,39)) ! ((3,0,3)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,39)) ! ((4,1,2)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,39)) ! ((4,0,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,39)) ! ((3,1,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,39)) ! ((4,1,3)|(0,0,0))
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(859) = theta(609)+theta(568)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(958) = theta(703)+theta(649)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(1048) = theta(766)+theta(694)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1186) = theta(859)+theta(763)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1353) = theta(1060)+theta(958)*AB(2) ! ((3,0,1)|(0,1,2)) = ((3,1,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(2)
        theta(1503) = theta(1186)+theta(1048)*AB(2) ! ((4,0,1)|(0,1,2)) = ((4,1,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(2)
        theta(1723) = theta(1503)+theta(1353)*AB(1) ! ((3,0,1)|(1,1,2)) = ((4,0,1)|(0,1,2))+((3,0,1)|(0,1,2))*AB(1)
        ! (3,0,1|1,0,3): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,40)) ! ((3,0,1)|(0,0,0))
        theta(513) = dot_product(vrrbuffer(:,18), D(:,40)) ! ((4,0,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,40)) ! ((3,0,2)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,40)) ! ((4,0,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,40)) ! ((3,0,3)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,40)) ! ((4,0,3)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,40)) ! ((3,0,4)|(0,0,0))
        theta(610) = dot_product(vrrbuffer(:,115), D(:,40)) ! ((4,0,4)|(0,0,0))
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(862) = theta(610)+theta(569)*AB(3) ! ((4,0,3)|(0,0,1)) = ((4,0,4)|(0,0,0))+((4,0,3)|(0,0,0))*AB(3)
        theta(958) = theta(703)+theta(649)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(1048) = theta(766)+theta(694)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1066) = theta(778)+theta(703)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1192) = theta(862)+theta(766)*AB(3) ! ((4,0,2)|(0,0,2)) = ((4,0,3)|(0,0,1))+((4,0,2)|(0,0,1))*AB(3)
        theta(1354) = theta(1066)+theta(958)*AB(3) ! ((3,0,1)|(0,0,3)) = ((3,0,2)|(0,0,2))+((3,0,1)|(0,0,2))*AB(3)
        theta(1504) = theta(1192)+theta(1048)*AB(3) ! ((4,0,1)|(0,0,3)) = ((4,0,2)|(0,0,2))+((4,0,1)|(0,0,2))*AB(3)
        theta(1724) = theta(1504)+theta(1354)*AB(1) ! ((3,0,1)|(1,0,3)) = ((4,0,1)|(0,0,3))+((3,0,1)|(0,0,3))*AB(1)
        ! (3,0,1|0,4,0): 15
        theta(498) = dot_product(vrrbuffer(:,3), D(:,41)) ! ((3,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,41)) ! ((3,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,41)) ! ((3,2,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,41)) ! ((3,3,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,41)) ! ((3,4,1)|(0,0,0))
        theta(648) = theta(515)+theta(498)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(867) = theta(612)+theta(571)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(956) = theta(699)+theta(648)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1202) = theta(867)+theta(771)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1351) = theta(1058)+theta(956)*AB(2) ! ((3,0,1)|(0,3,0)) = ((3,1,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(2)
        theta(1521) = theta(1202)+theta(1058)*AB(2) ! ((3,1,1)|(0,3,0)) = ((3,2,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(2)
        theta(1725) = theta(1521)+theta(1351)*AB(2) ! ((3,0,1)|(0,4,0)) = ((3,1,1)|(0,3,0))+((3,0,1)|(0,3,0))*AB(2)
        ! (3,0,1|0,3,1): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,42)) ! ((3,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,42)) ! ((3,1,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,42)) ! ((3,0,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,42)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,42)) ! ((3,1,2)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,42)) ! ((3,3,1)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,42)) ! ((3,2,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,42)) ! ((3,3,2)|(0,0,0))
        theta(648) = theta(515)+theta(498)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(702) = theta(540)+theta(516)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(870) = theta(613)+theta(572)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(956) = theta(699)+theta(648)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1064) = theta(774)+theta(702)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1208) = theta(870)+theta(774)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1351) = theta(1058)+theta(956)*AB(2) ! ((3,0,1)|(0,3,0)) = ((3,1,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(2)
        theta(1531) = theta(1208)+theta(1064)*AB(2) ! ((3,0,2)|(0,3,0)) = ((3,1,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(2)
        theta(1726) = theta(1531)+theta(1351)*AB(3) ! ((3,0,1)|(0,3,1)) = ((3,0,2)|(0,3,0))+((3,0,1)|(0,3,0))*AB(3)
        ! (3,0,1|0,2,2): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,43)) ! ((3,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,43)) ! ((3,1,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,43)) ! ((3,0,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,43)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,43)) ! ((3,1,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,43)) ! ((3,0,3)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,43)) ! ((3,2,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,43)) ! ((3,1,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,43)) ! ((3,2,3)|(0,0,0))
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(871) = theta(614)+theta(572)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(958) = theta(703)+theta(649)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1204) = theta(871)+theta(772)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1353) = theta(1060)+theta(958)*AB(2) ! ((3,0,1)|(0,1,2)) = ((3,1,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(2)
        theta(1523) = theta(1204)+theta(1060)*AB(2) ! ((3,1,1)|(0,1,2)) = ((3,2,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(2)
        theta(1727) = theta(1523)+theta(1353)*AB(2) ! ((3,0,1)|(0,2,2)) = ((3,1,1)|(0,1,2))+((3,0,1)|(0,1,2))*AB(2)
        ! (3,0,1|0,1,3): 21
        theta(498) = dot_product(vrrbuffer(:,3), D(:,44)) ! ((3,0,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,44)) ! ((3,1,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,44)) ! ((3,0,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,44)) ! ((3,1,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,44)) ! ((3,0,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,44)) ! ((3,1,3)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,44)) ! ((3,0,4)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,44)) ! ((3,1,4)|(0,0,0))
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(874) = theta(615)+theta(573)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(958) = theta(703)+theta(649)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1066) = theta(778)+theta(703)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1210) = theta(874)+theta(775)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1354) = theta(1066)+theta(958)*AB(3) ! ((3,0,1)|(0,0,3)) = ((3,0,2)|(0,0,2))+((3,0,1)|(0,0,2))*AB(3)
        theta(1524) = theta(1210)+theta(1060)*AB(3) ! ((3,1,1)|(0,0,3)) = ((3,1,2)|(0,0,2))+((3,1,1)|(0,0,2))*AB(3)
        theta(1728) = theta(1524)+theta(1354)*AB(2) ! ((3,0,1)|(0,1,3)) = ((3,1,1)|(0,0,3))+((3,0,1)|(0,0,3))*AB(2)
        ! (3,0,1|0,0,4): 15
        theta(498) = dot_product(vrrbuffer(:,3), D(:,45)) ! ((3,0,1)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,45)) ! ((3,0,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,45)) ! ((3,0,3)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,45)) ! ((3,0,4)|(0,0,0))
        theta(616) = dot_product(vrrbuffer(:,121), D(:,45)) ! ((3,0,5)|(0,0,0))
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(877) = theta(616)+theta(574)*AB(3) ! ((3,0,4)|(0,0,1)) = ((3,0,5)|(0,0,0))+((3,0,4)|(0,0,0))*AB(3)
        theta(958) = theta(703)+theta(649)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(1066) = theta(778)+theta(703)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1216) = theta(877)+theta(778)*AB(3) ! ((3,0,3)|(0,0,2)) = ((3,0,4)|(0,0,1))+((3,0,3)|(0,0,1))*AB(3)
        theta(1354) = theta(1066)+theta(958)*AB(3) ! ((3,0,1)|(0,0,3)) = ((3,0,2)|(0,0,2))+((3,0,1)|(0,0,2))*AB(3)
        theta(1534) = theta(1216)+theta(1066)*AB(3) ! ((3,0,2)|(0,0,3)) = ((3,0,3)|(0,0,2))+((3,0,2)|(0,0,2))*AB(3)
        theta(1729) = theta(1534)+theta(1354)*AB(3) ! ((3,0,1)|(0,0,4)) = ((3,0,2)|(0,0,3))+((3,0,1)|(0,0,3))*AB(3)
        ! (2,2,0|4,0,0): 15
        theta(499) = dot_product(vrrbuffer(:,4), D(:,46)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,46)) ! ((3,2,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,46)) ! ((4,2,0)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,46)) ! ((5,2,0)|(0,0,0))
        theta(599) = dot_product(vrrbuffer(:,104), D(:,46)) ! ((6,2,0)|(0,0,0))
        theta(650) = theta(514)+theta(499)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(695) = theta(535)+theta(514)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(758) = theta(563)+theta(535)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(842) = theta(599)+theta(563)*AB(1) ! ((5,2,0)|(1,0,0)) = ((6,2,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(1)
        theta(959) = theta(695)+theta(650)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(1049) = theta(758)+theta(695)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(1175) = theta(842)+theta(758)*AB(1) ! ((4,2,0)|(2,0,0)) = ((5,2,0)|(1,0,0))+((4,2,0)|(1,0,0))*AB(1)
        theta(1355) = theta(1049)+theta(959)*AB(1) ! ((2,2,0)|(3,0,0)) = ((3,2,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(1)
        theta(1505) = theta(1175)+theta(1049)*AB(1) ! ((3,2,0)|(3,0,0)) = ((4,2,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(1)
        theta(1730) = theta(1505)+theta(1355)*AB(1) ! ((2,2,0)|(4,0,0)) = ((3,2,0)|(3,0,0))+((2,2,0)|(3,0,0))*AB(1)
        ! (2,2,0|3,1,0): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,47)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,47)) ! ((3,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,47)) ! ((2,3,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,47)) ! ((4,2,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,47)) ! ((3,3,0)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,47)) ! ((5,2,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,47)) ! ((4,3,0)|(0,0,0))
        theta(602) = dot_product(vrrbuffer(:,107), D(:,47)) ! ((5,3,0)|(0,0,0))
        theta(650) = theta(514)+theta(499)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(695) = theta(535)+theta(514)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(704) = theta(538)+theta(517)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(758) = theta(563)+theta(535)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(767) = theta(566)+theta(538)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(851) = theta(602)+theta(566)*AB(1) ! ((4,3,0)|(1,0,0)) = ((5,3,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(1)
        theta(959) = theta(695)+theta(650)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(1049) = theta(758)+theta(695)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(1067) = theta(767)+theta(704)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(1193) = theta(851)+theta(767)*AB(1) ! ((3,3,0)|(2,0,0)) = ((4,3,0)|(1,0,0))+((3,3,0)|(1,0,0))*AB(1)
        theta(1355) = theta(1049)+theta(959)*AB(1) ! ((2,2,0)|(3,0,0)) = ((3,2,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(1)
        theta(1535) = theta(1193)+theta(1067)*AB(1) ! ((2,3,0)|(3,0,0)) = ((3,3,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(1)
        theta(1731) = theta(1535)+theta(1355)*AB(2) ! ((2,2,0)|(3,1,0)) = ((2,3,0)|(3,0,0))+((2,2,0)|(3,0,0))*AB(2)
        ! (2,2,0|3,0,1): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,48)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,48)) ! ((3,2,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,48)) ! ((2,2,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,48)) ! ((4,2,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,48)) ! ((3,2,1)|(0,0,0))
        theta(563) = dot_product(vrrbuffer(:,68), D(:,48)) ! ((5,2,0)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,48)) ! ((4,2,1)|(0,0,0))
        theta(603) = dot_product(vrrbuffer(:,108), D(:,48)) ! ((5,2,1)|(0,0,0))
        theta(650) = theta(514)+theta(499)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(695) = theta(535)+theta(514)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(707) = theta(539)+theta(518)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(758) = theta(563)+theta(535)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(770) = theta(567)+theta(539)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(854) = theta(603)+theta(567)*AB(1) ! ((4,2,1)|(1,0,0)) = ((5,2,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(1)
        theta(959) = theta(695)+theta(650)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(1049) = theta(758)+theta(695)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(1073) = theta(770)+theta(707)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(1199) = theta(854)+theta(770)*AB(1) ! ((3,2,1)|(2,0,0)) = ((4,2,1)|(1,0,0))+((3,2,1)|(1,0,0))*AB(1)
        theta(1355) = theta(1049)+theta(959)*AB(1) ! ((2,2,0)|(3,0,0)) = ((3,2,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(1)
        theta(1545) = theta(1199)+theta(1073)*AB(1) ! ((2,2,1)|(3,0,0)) = ((3,2,1)|(2,0,0))+((2,2,1)|(2,0,0))*AB(1)
        theta(1732) = theta(1545)+theta(1355)*AB(3) ! ((2,2,0)|(3,0,1)) = ((2,2,1)|(3,0,0))+((2,2,0)|(3,0,0))*AB(3)
        ! (2,2,0|2,2,0): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,49)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,49)) ! ((3,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,49)) ! ((2,3,0)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,49)) ! ((4,2,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,49)) ! ((3,3,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,49)) ! ((2,4,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,49)) ! ((4,3,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,49)) ! ((3,4,0)|(0,0,0))
        theta(606) = dot_product(vrrbuffer(:,111), D(:,49)) ! ((4,4,0)|(0,0,0))
        theta(651) = theta(517)+theta(499)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(852) = theta(606)+theta(566)*AB(2) ! ((4,3,0)|(0,1,0)) = ((4,4,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(2)
        theta(962) = theta(705)+theta(651)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(1052) = theta(768)+theta(696)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(1178) = theta(852)+theta(759)*AB(2) ! ((4,2,0)|(0,2,0)) = ((4,3,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(2)
        theta(1358) = theta(1052)+theta(962)*AB(1) ! ((2,2,0)|(1,2,0)) = ((3,2,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(1)
        theta(1508) = theta(1178)+theta(1052)*AB(1) ! ((3,2,0)|(1,2,0)) = ((4,2,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(1)
        theta(1733) = theta(1508)+theta(1358)*AB(1) ! ((2,2,0)|(2,2,0)) = ((3,2,0)|(1,2,0))+((2,2,0)|(1,2,0))*AB(1)
        ! (2,2,0|2,1,1): 27
        theta(499) = dot_product(vrrbuffer(:,4), D(:,50)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,50)) ! ((3,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,50)) ! ((2,3,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,50)) ! ((2,2,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,50)) ! ((4,2,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,50)) ! ((3,3,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,50)) ! ((3,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,50)) ! ((2,3,1)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,50)) ! ((4,3,0)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,50)) ! ((4,2,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,50)) ! ((3,3,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,50)) ! ((4,3,1)|(0,0,0))
        theta(650) = theta(514)+theta(499)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(695) = theta(535)+theta(514)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(704) = theta(538)+theta(517)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(707) = theta(539)+theta(518)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(767) = theta(566)+theta(538)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(770) = theta(567)+theta(539)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(782) = theta(571)+theta(543)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(866) = theta(607)+theta(571)*AB(1) ! ((3,3,1)|(1,0,0)) = ((4,3,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(1)
        theta(959) = theta(695)+theta(650)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(1067) = theta(767)+theta(704)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(1073) = theta(770)+theta(707)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(1223) = theta(866)+theta(782)*AB(1) ! ((2,3,1)|(2,0,0)) = ((3,3,1)|(1,0,0))+((2,3,1)|(1,0,0))*AB(1)
        theta(1357) = theta(1073)+theta(959)*AB(3) ! ((2,2,0)|(2,0,1)) = ((2,2,1)|(2,0,0))+((2,2,0)|(2,0,0))*AB(3)
        theta(1537) = theta(1223)+theta(1067)*AB(3) ! ((2,3,0)|(2,0,1)) = ((2,3,1)|(2,0,0))+((2,3,0)|(2,0,0))*AB(3)
        theta(1734) = theta(1537)+theta(1357)*AB(2) ! ((2,2,0)|(2,1,1)) = ((2,3,0)|(2,0,1))+((2,2,0)|(2,0,1))*AB(2)
        ! (2,2,0|2,0,2): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,51)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,51)) ! ((3,2,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,51)) ! ((2,2,1)|(0,0,0))
        theta(535) = dot_product(vrrbuffer(:,40), D(:,51)) ! ((4,2,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,51)) ! ((3,2,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,51)) ! ((2,2,2)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,51)) ! ((4,2,1)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,51)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,51)) ! ((4,2,2)|(0,0,0))
        theta(652) = theta(518)+theta(499)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(697) = theta(539)+theta(514)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(760) = theta(567)+theta(535)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(856) = theta(608)+theta(567)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(964) = theta(709)+theta(652)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(1054) = theta(772)+theta(697)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1180) = theta(856)+theta(760)*AB(3) ! ((4,2,0)|(0,0,2)) = ((4,2,1)|(0,0,1))+((4,2,0)|(0,0,1))*AB(3)
        theta(1360) = theta(1054)+theta(964)*AB(1) ! ((2,2,0)|(1,0,2)) = ((3,2,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(1)
        theta(1510) = theta(1180)+theta(1054)*AB(1) ! ((3,2,0)|(1,0,2)) = ((4,2,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(1)
        theta(1735) = theta(1510)+theta(1360)*AB(1) ! ((2,2,0)|(2,0,2)) = ((3,2,0)|(1,0,2))+((2,2,0)|(1,0,2))*AB(1)
        ! (2,2,0|1,3,0): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,52)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,52)) ! ((3,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,52)) ! ((2,3,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,52)) ! ((3,3,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,52)) ! ((2,4,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,52)) ! ((3,4,0)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,52)) ! ((2,5,0)|(0,0,0))
        theta(611) = dot_product(vrrbuffer(:,116), D(:,52)) ! ((3,5,0)|(0,0,0))
        theta(651) = theta(517)+theta(499)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(864) = theta(611)+theta(570)*AB(2) ! ((3,4,0)|(0,1,0)) = ((3,5,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(2)
        theta(962) = theta(705)+theta(651)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(1052) = theta(768)+theta(696)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(1070) = theta(780)+theta(705)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(1196) = theta(864)+theta(768)*AB(2) ! ((3,3,0)|(0,2,0)) = ((3,4,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(2)
        theta(1361) = theta(1070)+theta(962)*AB(2) ! ((2,2,0)|(0,3,0)) = ((2,3,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(2)
        theta(1511) = theta(1196)+theta(1052)*AB(2) ! ((3,2,0)|(0,3,0)) = ((3,3,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(2)
        theta(1736) = theta(1511)+theta(1361)*AB(1) ! ((2,2,0)|(1,3,0)) = ((3,2,0)|(0,3,0))+((2,2,0)|(0,3,0))*AB(1)
        ! (2,2,0|1,2,1): 27
        theta(499) = dot_product(vrrbuffer(:,4), D(:,53)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,53)) ! ((3,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,53)) ! ((2,3,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,53)) ! ((2,2,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,53)) ! ((3,3,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,53)) ! ((3,2,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,53)) ! ((2,4,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,53)) ! ((2,3,1)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,53)) ! ((3,4,0)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,53)) ! ((3,3,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,53)) ! ((2,4,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,53)) ! ((3,4,1)|(0,0,0))
        theta(651) = theta(517)+theta(499)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(867) = theta(612)+theta(571)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(962) = theta(705)+theta(651)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(1052) = theta(768)+theta(696)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1202) = theta(867)+theta(771)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1362) = theta(1076)+theta(962)*AB(3) ! ((2,2,0)|(0,2,1)) = ((2,2,1)|(0,2,0))+((2,2,0)|(0,2,0))*AB(3)
        theta(1512) = theta(1202)+theta(1052)*AB(3) ! ((3,2,0)|(0,2,1)) = ((3,2,1)|(0,2,0))+((3,2,0)|(0,2,0))*AB(3)
        theta(1737) = theta(1512)+theta(1362)*AB(1) ! ((2,2,0)|(1,2,1)) = ((3,2,0)|(0,2,1))+((2,2,0)|(0,2,1))*AB(1)
        ! (2,2,0|1,1,2): 27
        theta(499) = dot_product(vrrbuffer(:,4), D(:,54)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,54)) ! ((3,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,54)) ! ((2,3,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,54)) ! ((2,2,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,54)) ! ((3,3,0)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,54)) ! ((3,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,54)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,54)) ! ((2,2,2)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,54)) ! ((3,3,1)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,54)) ! ((3,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,54)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,54)) ! ((3,3,2)|(0,0,0))
        theta(652) = theta(518)+theta(499)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(697) = theta(539)+theta(514)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(706) = theta(543)+theta(517)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(769) = theta(571)+theta(538)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(868) = theta(613)+theta(571)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(964) = theta(709)+theta(652)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(1054) = theta(772)+theta(697)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1072) = theta(784)+theta(706)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1198) = theta(868)+theta(769)*AB(3) ! ((3,3,0)|(0,0,2)) = ((3,3,1)|(0,0,1))+((3,3,0)|(0,0,1))*AB(3)
        theta(1363) = theta(1072)+theta(964)*AB(2) ! ((2,2,0)|(0,1,2)) = ((2,3,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(2)
        theta(1513) = theta(1198)+theta(1054)*AB(2) ! ((3,2,0)|(0,1,2)) = ((3,3,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(2)
        theta(1738) = theta(1513)+theta(1363)*AB(1) ! ((2,2,0)|(1,1,2)) = ((3,2,0)|(0,1,2))+((2,2,0)|(0,1,2))*AB(1)
        ! (2,2,0|1,0,3): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,55)) ! ((2,2,0)|(0,0,0))
        theta(514) = dot_product(vrrbuffer(:,19), D(:,55)) ! ((3,2,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,55)) ! ((2,2,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,55)) ! ((3,2,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,55)) ! ((2,2,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,55)) ! ((3,2,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,55)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,55)) ! ((3,2,3)|(0,0,0))
        theta(652) = theta(518)+theta(499)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(697) = theta(539)+theta(514)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(871) = theta(614)+theta(572)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(964) = theta(709)+theta(652)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(1054) = theta(772)+theta(697)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1204) = theta(871)+theta(772)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1364) = theta(1078)+theta(964)*AB(3) ! ((2,2,0)|(0,0,3)) = ((2,2,1)|(0,0,2))+((2,2,0)|(0,0,2))*AB(3)
        theta(1514) = theta(1204)+theta(1054)*AB(3) ! ((3,2,0)|(0,0,3)) = ((3,2,1)|(0,0,2))+((3,2,0)|(0,0,2))*AB(3)
        theta(1739) = theta(1514)+theta(1364)*AB(1) ! ((2,2,0)|(1,0,3)) = ((3,2,0)|(0,0,3))+((2,2,0)|(0,0,3))*AB(1)
        ! (2,2,0|0,4,0): 15
        theta(499) = dot_product(vrrbuffer(:,4), D(:,56)) ! ((2,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,56)) ! ((2,3,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,56)) ! ((2,4,0)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,56)) ! ((2,5,0)|(0,0,0))
        theta(617) = dot_product(vrrbuffer(:,122), D(:,56)) ! ((2,6,0)|(0,0,0))
        theta(651) = theta(517)+theta(499)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(879) = theta(617)+theta(575)*AB(2) ! ((2,5,0)|(0,1,0)) = ((2,6,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(2)
        theta(962) = theta(705)+theta(651)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(1070) = theta(780)+theta(705)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(1220) = theta(879)+theta(780)*AB(2) ! ((2,4,0)|(0,2,0)) = ((2,5,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(2)
        theta(1361) = theta(1070)+theta(962)*AB(2) ! ((2,2,0)|(0,3,0)) = ((2,3,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(2)
        theta(1541) = theta(1220)+theta(1070)*AB(2) ! ((2,3,0)|(0,3,0)) = ((2,4,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(2)
        theta(1740) = theta(1541)+theta(1361)*AB(2) ! ((2,2,0)|(0,4,0)) = ((2,3,0)|(0,3,0))+((2,2,0)|(0,3,0))*AB(2)
        ! (2,2,0|0,3,1): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,57)) ! ((2,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,57)) ! ((2,3,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,57)) ! ((2,2,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,57)) ! ((2,4,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,57)) ! ((2,3,1)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,57)) ! ((2,5,0)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,57)) ! ((2,4,1)|(0,0,0))
        theta(618) = dot_product(vrrbuffer(:,123), D(:,57)) ! ((2,5,1)|(0,0,0))
        theta(651) = theta(517)+theta(499)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(882) = theta(618)+theta(576)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(962) = theta(705)+theta(651)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(1070) = theta(780)+theta(705)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1226) = theta(882)+theta(783)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1361) = theta(1070)+theta(962)*AB(2) ! ((2,2,0)|(0,3,0)) = ((2,3,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(2)
        theta(1551) = theta(1226)+theta(1076)*AB(2) ! ((2,2,1)|(0,3,0)) = ((2,3,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(2)
        theta(1741) = theta(1551)+theta(1361)*AB(3) ! ((2,2,0)|(0,3,1)) = ((2,2,1)|(0,3,0))+((2,2,0)|(0,3,0))*AB(3)
        ! (2,2,0|0,2,2): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,58)) ! ((2,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,58)) ! ((2,3,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,58)) ! ((2,2,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,58)) ! ((2,4,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,58)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,58)) ! ((2,2,2)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,58)) ! ((2,4,1)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,58)) ! ((2,3,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,58)) ! ((2,4,2)|(0,0,0))
        theta(652) = theta(518)+theta(499)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(706) = theta(543)+theta(517)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(781) = theta(576)+theta(542)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(883) = theta(619)+theta(576)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(964) = theta(709)+theta(652)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(1072) = theta(784)+theta(706)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1222) = theta(883)+theta(781)*AB(3) ! ((2,4,0)|(0,0,2)) = ((2,4,1)|(0,0,1))+((2,4,0)|(0,0,1))*AB(3)
        theta(1363) = theta(1072)+theta(964)*AB(2) ! ((2,2,0)|(0,1,2)) = ((2,3,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(2)
        theta(1543) = theta(1222)+theta(1072)*AB(2) ! ((2,3,0)|(0,1,2)) = ((2,4,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(2)
        theta(1742) = theta(1543)+theta(1363)*AB(2) ! ((2,2,0)|(0,2,2)) = ((2,3,0)|(0,1,2))+((2,2,0)|(0,1,2))*AB(2)
        ! (2,2,0|0,1,3): 21
        theta(499) = dot_product(vrrbuffer(:,4), D(:,59)) ! ((2,2,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,59)) ! ((2,3,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,59)) ! ((2,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,59)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,59)) ! ((2,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,59)) ! ((2,3,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,59)) ! ((2,2,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,59)) ! ((2,3,3)|(0,0,0))
        theta(652) = theta(518)+theta(499)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(706) = theta(543)+theta(517)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(886) = theta(620)+theta(577)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(964) = theta(709)+theta(652)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(1072) = theta(784)+theta(706)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1228) = theta(886)+theta(784)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1364) = theta(1078)+theta(964)*AB(3) ! ((2,2,0)|(0,0,3)) = ((2,2,1)|(0,0,2))+((2,2,0)|(0,0,2))*AB(3)
        theta(1544) = theta(1228)+theta(1072)*AB(3) ! ((2,3,0)|(0,0,3)) = ((2,3,1)|(0,0,2))+((2,3,0)|(0,0,2))*AB(3)
        theta(1743) = theta(1544)+theta(1364)*AB(2) ! ((2,2,0)|(0,1,3)) = ((2,3,0)|(0,0,3))+((2,2,0)|(0,0,3))*AB(2)
        ! (2,2,0|0,0,4): 15
        theta(499) = dot_product(vrrbuffer(:,4), D(:,60)) ! ((2,2,0)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,60)) ! ((2,2,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,60)) ! ((2,2,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,60)) ! ((2,2,3)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,60)) ! ((2,2,4)|(0,0,0))
        theta(652) = theta(518)+theta(499)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(964) = theta(709)+theta(652)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1234) = theta(889)+theta(787)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1364) = theta(1078)+theta(964)*AB(3) ! ((2,2,0)|(0,0,3)) = ((2,2,1)|(0,0,2))+((2,2,0)|(0,0,2))*AB(3)
        theta(1554) = theta(1234)+theta(1078)*AB(3) ! ((2,2,1)|(0,0,3)) = ((2,2,2)|(0,0,2))+((2,2,1)|(0,0,2))*AB(3)
        theta(1744) = theta(1554)+theta(1364)*AB(3) ! ((2,2,0)|(0,0,4)) = ((2,2,1)|(0,0,3))+((2,2,0)|(0,0,3))*AB(3)
        ! (2,1,1|4,0,0): 15
        theta(500) = dot_product(vrrbuffer(:,5), D(:,61)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,61)) ! ((3,1,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,61)) ! ((4,1,1)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,61)) ! ((5,1,1)|(0,0,0))
        theta(600) = dot_product(vrrbuffer(:,105), D(:,61)) ! ((6,1,1)|(0,0,0))
        theta(653) = theta(515)+theta(500)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(698) = theta(536)+theta(515)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(761) = theta(564)+theta(536)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(845) = theta(600)+theta(564)*AB(1) ! ((5,1,1)|(1,0,0)) = ((6,1,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(1)
        theta(965) = theta(698)+theta(653)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(1055) = theta(761)+theta(698)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(1181) = theta(845)+theta(761)*AB(1) ! ((4,1,1)|(2,0,0)) = ((5,1,1)|(1,0,0))+((4,1,1)|(1,0,0))*AB(1)
        theta(1365) = theta(1055)+theta(965)*AB(1) ! ((2,1,1)|(3,0,0)) = ((3,1,1)|(2,0,0))+((2,1,1)|(2,0,0))*AB(1)
        theta(1515) = theta(1181)+theta(1055)*AB(1) ! ((3,1,1)|(3,0,0)) = ((4,1,1)|(2,0,0))+((3,1,1)|(2,0,0))*AB(1)
        theta(1745) = theta(1515)+theta(1365)*AB(1) ! ((2,1,1)|(4,0,0)) = ((3,1,1)|(3,0,0))+((2,1,1)|(3,0,0))*AB(1)
        ! (2,1,1|3,1,0): 18
        theta(500) = dot_product(vrrbuffer(:,5), D(:,62)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,62)) ! ((3,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,62)) ! ((2,2,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,62)) ! ((4,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,62)) ! ((3,2,1)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,62)) ! ((5,1,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,62)) ! ((4,2,1)|(0,0,0))
        theta(603) = dot_product(vrrbuffer(:,108), D(:,62)) ! ((5,2,1)|(0,0,0))
        theta(654) = theta(518)+theta(500)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(846) = theta(603)+theta(564)*AB(2) ! ((5,1,1)|(0,1,0)) = ((5,2,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(2)
        theta(966) = theta(699)+theta(654)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        theta(1056) = theta(762)+theta(699)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        theta(1182) = theta(846)+theta(762)*AB(1) ! ((4,1,1)|(1,1,0)) = ((5,1,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(1)
        theta(1366) = theta(1056)+theta(966)*AB(1) ! ((2,1,1)|(2,1,0)) = ((3,1,1)|(1,1,0))+((2,1,1)|(1,1,0))*AB(1)
        theta(1516) = theta(1182)+theta(1056)*AB(1) ! ((3,1,1)|(2,1,0)) = ((4,1,1)|(1,1,0))+((3,1,1)|(1,1,0))*AB(1)
        theta(1746) = theta(1516)+theta(1366)*AB(1) ! ((2,1,1)|(3,1,0)) = ((3,1,1)|(2,1,0))+((2,1,1)|(2,1,0))*AB(1)
        ! (2,1,1|3,0,1): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,63)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,63)) ! ((3,1,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,63)) ! ((2,1,2)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,63)) ! ((4,1,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,63)) ! ((3,1,2)|(0,0,0))
        theta(564) = dot_product(vrrbuffer(:,69), D(:,63)) ! ((5,1,1)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,63)) ! ((4,1,2)|(0,0,0))
        theta(604) = dot_product(vrrbuffer(:,109), D(:,63)) ! ((5,1,2)|(0,0,0))
        theta(653) = theta(515)+theta(500)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(698) = theta(536)+theta(515)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(710) = theta(540)+theta(519)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(761) = theta(564)+theta(536)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(773) = theta(568)+theta(540)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(857) = theta(604)+theta(568)*AB(1) ! ((4,1,2)|(1,0,0)) = ((5,1,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(1)
        theta(965) = theta(698)+theta(653)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(1055) = theta(761)+theta(698)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(1079) = theta(773)+theta(710)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(1205) = theta(857)+theta(773)*AB(1) ! ((3,1,2)|(2,0,0)) = ((4,1,2)|(1,0,0))+((3,1,2)|(1,0,0))*AB(1)
        theta(1365) = theta(1055)+theta(965)*AB(1) ! ((2,1,1)|(3,0,0)) = ((3,1,1)|(2,0,0))+((2,1,1)|(2,0,0))*AB(1)
        theta(1555) = theta(1205)+theta(1079)*AB(1) ! ((2,1,2)|(3,0,0)) = ((3,1,2)|(2,0,0))+((2,1,2)|(2,0,0))*AB(1)
        theta(1747) = theta(1555)+theta(1365)*AB(3) ! ((2,1,1)|(3,0,1)) = ((2,1,2)|(3,0,0))+((2,1,1)|(3,0,0))*AB(3)
        ! (2,1,1|2,2,0): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,64)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,64)) ! ((3,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,64)) ! ((2,2,1)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,64)) ! ((4,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,64)) ! ((3,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,64)) ! ((2,3,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,64)) ! ((4,2,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,64)) ! ((3,3,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,64)) ! ((4,3,1)|(0,0,0))
        theta(654) = theta(518)+theta(500)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(855) = theta(607)+theta(567)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(968) = theta(708)+theta(654)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1184) = theta(855)+theta(762)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1368) = theta(1058)+theta(968)*AB(1) ! ((2,1,1)|(1,2,0)) = ((3,1,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(1)
        theta(1518) = theta(1184)+theta(1058)*AB(1) ! ((3,1,1)|(1,2,0)) = ((4,1,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(1)
        theta(1748) = theta(1518)+theta(1368)*AB(1) ! ((2,1,1)|(2,2,0)) = ((3,1,1)|(1,2,0))+((2,1,1)|(1,2,0))*AB(1)
        ! (2,1,1|2,1,1): 24
        theta(500) = dot_product(vrrbuffer(:,5), D(:,65)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,65)) ! ((3,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,65)) ! ((2,2,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,65)) ! ((2,1,2)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,65)) ! ((4,1,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,65)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,65)) ! ((3,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,65)) ! ((2,2,2)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,65)) ! ((4,2,1)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,65)) ! ((4,1,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,65)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,65)) ! ((4,2,2)|(0,0,0))
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(856) = theta(608)+theta(567)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(969) = theta(709)+theta(655)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        theta(1059) = theta(772)+theta(700)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(1185) = theta(856)+theta(763)*AB(2) ! ((4,1,1)|(0,1,1)) = ((4,2,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(2)
        theta(1369) = theta(1059)+theta(969)*AB(1) ! ((2,1,1)|(1,1,1)) = ((3,1,1)|(0,1,1))+((2,1,1)|(0,1,1))*AB(1)
        theta(1519) = theta(1185)+theta(1059)*AB(1) ! ((3,1,1)|(1,1,1)) = ((4,1,1)|(0,1,1))+((3,1,1)|(0,1,1))*AB(1)
        theta(1749) = theta(1519)+theta(1369)*AB(1) ! ((2,1,1)|(2,1,1)) = ((3,1,1)|(1,1,1))+((2,1,1)|(1,1,1))*AB(1)
        ! (2,1,1|2,0,2): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,66)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,66)) ! ((3,1,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,66)) ! ((2,1,2)|(0,0,0))
        theta(536) = dot_product(vrrbuffer(:,41), D(:,66)) ! ((4,1,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,66)) ! ((3,1,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,66)) ! ((2,1,3)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,66)) ! ((4,1,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,66)) ! ((3,1,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,66)) ! ((4,1,3)|(0,0,0))
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(859) = theta(609)+theta(568)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(970) = theta(712)+theta(655)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1186) = theta(859)+theta(763)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1370) = theta(1060)+theta(970)*AB(1) ! ((2,1,1)|(1,0,2)) = ((3,1,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(1)
        theta(1520) = theta(1186)+theta(1060)*AB(1) ! ((3,1,1)|(1,0,2)) = ((4,1,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(1)
        theta(1750) = theta(1520)+theta(1370)*AB(1) ! ((2,1,1)|(2,0,2)) = ((3,1,1)|(1,0,2))+((2,1,1)|(1,0,2))*AB(1)
        ! (2,1,1|1,3,0): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,67)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,67)) ! ((3,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,67)) ! ((2,2,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,67)) ! ((3,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,67)) ! ((2,3,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,67)) ! ((3,3,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,67)) ! ((2,4,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,67)) ! ((3,4,1)|(0,0,0))
        theta(654) = theta(518)+theta(500)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(867) = theta(612)+theta(571)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(968) = theta(708)+theta(654)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1202) = theta(867)+theta(771)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1371) = theta(1076)+theta(968)*AB(2) ! ((2,1,1)|(0,3,0)) = ((2,2,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(2)
        theta(1521) = theta(1202)+theta(1058)*AB(2) ! ((3,1,1)|(0,3,0)) = ((3,2,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(2)
        theta(1751) = theta(1521)+theta(1371)*AB(1) ! ((2,1,1)|(1,3,0)) = ((3,1,1)|(0,3,0))+((2,1,1)|(0,3,0))*AB(1)
        ! (2,1,1|1,2,1): 27
        theta(500) = dot_product(vrrbuffer(:,5), D(:,68)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,68)) ! ((3,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,68)) ! ((2,2,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,68)) ! ((2,1,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,68)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,68)) ! ((3,1,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,68)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,68)) ! ((2,2,2)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,68)) ! ((3,3,1)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,68)) ! ((3,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,68)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,68)) ! ((3,3,2)|(0,0,0))
        theta(654) = theta(518)+theta(500)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(870) = theta(613)+theta(572)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(968) = theta(708)+theta(654)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1208) = theta(870)+theta(774)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1372) = theta(1082)+theta(968)*AB(3) ! ((2,1,1)|(0,2,1)) = ((2,1,2)|(0,2,0))+((2,1,1)|(0,2,0))*AB(3)
        theta(1522) = theta(1208)+theta(1058)*AB(3) ! ((3,1,1)|(0,2,1)) = ((3,1,2)|(0,2,0))+((3,1,1)|(0,2,0))*AB(3)
        theta(1752) = theta(1522)+theta(1372)*AB(1) ! ((2,1,1)|(1,2,1)) = ((3,1,1)|(0,2,1))+((2,1,1)|(0,2,1))*AB(1)
        ! (2,1,1|1,1,2): 27
        theta(500) = dot_product(vrrbuffer(:,5), D(:,69)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,69)) ! ((3,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,69)) ! ((2,2,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,69)) ! ((2,1,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,69)) ! ((3,2,1)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,69)) ! ((3,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,69)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,69)) ! ((2,1,3)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,69)) ! ((3,2,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,69)) ! ((3,1,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,69)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,69)) ! ((3,2,3)|(0,0,0))
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(871) = theta(614)+theta(572)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(970) = theta(712)+theta(655)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1204) = theta(871)+theta(772)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1373) = theta(1078)+theta(970)*AB(2) ! ((2,1,1)|(0,1,2)) = ((2,2,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(2)
        theta(1523) = theta(1204)+theta(1060)*AB(2) ! ((3,1,1)|(0,1,2)) = ((3,2,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(2)
        theta(1753) = theta(1523)+theta(1373)*AB(1) ! ((2,1,1)|(1,1,2)) = ((3,1,1)|(0,1,2))+((2,1,1)|(0,1,2))*AB(1)
        ! (2,1,1|1,0,3): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,70)) ! ((2,1,1)|(0,0,0))
        theta(515) = dot_product(vrrbuffer(:,20), D(:,70)) ! ((3,1,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,70)) ! ((2,1,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,70)) ! ((3,1,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,70)) ! ((2,1,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,70)) ! ((3,1,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,70)) ! ((2,1,4)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,70)) ! ((3,1,4)|(0,0,0))
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(874) = theta(615)+theta(573)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(970) = theta(712)+theta(655)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1210) = theta(874)+theta(775)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1374) = theta(1084)+theta(970)*AB(3) ! ((2,1,1)|(0,0,3)) = ((2,1,2)|(0,0,2))+((2,1,1)|(0,0,2))*AB(3)
        theta(1524) = theta(1210)+theta(1060)*AB(3) ! ((3,1,1)|(0,0,3)) = ((3,1,2)|(0,0,2))+((3,1,1)|(0,0,2))*AB(3)
        theta(1754) = theta(1524)+theta(1374)*AB(1) ! ((2,1,1)|(1,0,3)) = ((3,1,1)|(0,0,3))+((2,1,1)|(0,0,3))*AB(1)
        ! (2,1,1|0,4,0): 15
        theta(500) = dot_product(vrrbuffer(:,5), D(:,71)) ! ((2,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,71)) ! ((2,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,71)) ! ((2,3,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,71)) ! ((2,4,1)|(0,0,0))
        theta(618) = dot_product(vrrbuffer(:,123), D(:,71)) ! ((2,5,1)|(0,0,0))
        theta(654) = theta(518)+theta(500)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(882) = theta(618)+theta(576)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(968) = theta(708)+theta(654)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1226) = theta(882)+theta(783)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1371) = theta(1076)+theta(968)*AB(2) ! ((2,1,1)|(0,3,0)) = ((2,2,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(2)
        theta(1551) = theta(1226)+theta(1076)*AB(2) ! ((2,2,1)|(0,3,0)) = ((2,3,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(2)
        theta(1755) = theta(1551)+theta(1371)*AB(2) ! ((2,1,1)|(0,4,0)) = ((2,2,1)|(0,3,0))+((2,1,1)|(0,3,0))*AB(2)
        ! (2,1,1|0,3,1): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,72)) ! ((2,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,72)) ! ((2,2,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,72)) ! ((2,1,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,72)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,72)) ! ((2,2,2)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,72)) ! ((2,4,1)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,72)) ! ((2,3,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,72)) ! ((2,4,2)|(0,0,0))
        theta(654) = theta(518)+theta(500)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(885) = theta(619)+theta(577)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(968) = theta(708)+theta(654)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1232) = theta(885)+theta(786)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1371) = theta(1076)+theta(968)*AB(2) ! ((2,1,1)|(0,3,0)) = ((2,2,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(2)
        theta(1561) = theta(1232)+theta(1082)*AB(2) ! ((2,1,2)|(0,3,0)) = ((2,2,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(2)
        theta(1756) = theta(1561)+theta(1371)*AB(3) ! ((2,1,1)|(0,3,1)) = ((2,1,2)|(0,3,0))+((2,1,1)|(0,3,0))*AB(3)
        ! (2,1,1|0,2,2): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,73)) ! ((2,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,73)) ! ((2,2,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,73)) ! ((2,1,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,73)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,73)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,73)) ! ((2,1,3)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,73)) ! ((2,3,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,73)) ! ((2,2,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,73)) ! ((2,3,3)|(0,0,0))
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(886) = theta(620)+theta(577)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(970) = theta(712)+theta(655)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1228) = theta(886)+theta(784)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1373) = theta(1078)+theta(970)*AB(2) ! ((2,1,1)|(0,1,2)) = ((2,2,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(2)
        theta(1553) = theta(1228)+theta(1078)*AB(2) ! ((2,2,1)|(0,1,2)) = ((2,3,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(2)
        theta(1757) = theta(1553)+theta(1373)*AB(2) ! ((2,1,1)|(0,2,2)) = ((2,2,1)|(0,1,2))+((2,1,1)|(0,1,2))*AB(2)
        ! (2,1,1|0,1,3): 21
        theta(500) = dot_product(vrrbuffer(:,5), D(:,74)) ! ((2,1,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,74)) ! ((2,2,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,74)) ! ((2,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,74)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,74)) ! ((2,1,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,74)) ! ((2,2,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,74)) ! ((2,1,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,74)) ! ((2,2,4)|(0,0,0))
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(970) = theta(712)+theta(655)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1234) = theta(889)+theta(787)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1374) = theta(1084)+theta(970)*AB(3) ! ((2,1,1)|(0,0,3)) = ((2,1,2)|(0,0,2))+((2,1,1)|(0,0,2))*AB(3)
        theta(1554) = theta(1234)+theta(1078)*AB(3) ! ((2,2,1)|(0,0,3)) = ((2,2,2)|(0,0,2))+((2,2,1)|(0,0,2))*AB(3)
        theta(1758) = theta(1554)+theta(1374)*AB(2) ! ((2,1,1)|(0,1,3)) = ((2,2,1)|(0,0,3))+((2,1,1)|(0,0,3))*AB(2)
        ! (2,1,1|0,0,4): 15
        theta(500) = dot_product(vrrbuffer(:,5), D(:,75)) ! ((2,1,1)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,75)) ! ((2,1,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,75)) ! ((2,1,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,75)) ! ((2,1,4)|(0,0,0))
        theta(622) = dot_product(vrrbuffer(:,127), D(:,75)) ! ((2,1,5)|(0,0,0))
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(892) = theta(622)+theta(579)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(970) = theta(712)+theta(655)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1240) = theta(892)+theta(790)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1374) = theta(1084)+theta(970)*AB(3) ! ((2,1,1)|(0,0,3)) = ((2,1,2)|(0,0,2))+((2,1,1)|(0,0,2))*AB(3)
        theta(1564) = theta(1240)+theta(1084)*AB(3) ! ((2,1,2)|(0,0,3)) = ((2,1,3)|(0,0,2))+((2,1,2)|(0,0,2))*AB(3)
        theta(1759) = theta(1564)+theta(1374)*AB(3) ! ((2,1,1)|(0,0,4)) = ((2,1,2)|(0,0,3))+((2,1,1)|(0,0,3))*AB(3)
        ! (2,0,2|4,0,0): 15
        theta(501) = dot_product(vrrbuffer(:,6), D(:,76)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,76)) ! ((3,0,2)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,76)) ! ((4,0,2)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,76)) ! ((5,0,2)|(0,0,0))
        theta(601) = dot_product(vrrbuffer(:,106), D(:,76)) ! ((6,0,2)|(0,0,0))
        theta(656) = theta(516)+theta(501)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(701) = theta(537)+theta(516)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(764) = theta(565)+theta(537)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(848) = theta(601)+theta(565)*AB(1) ! ((5,0,2)|(1,0,0)) = ((6,0,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(1)
        theta(971) = theta(701)+theta(656)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(1061) = theta(764)+theta(701)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(1187) = theta(848)+theta(764)*AB(1) ! ((4,0,2)|(2,0,0)) = ((5,0,2)|(1,0,0))+((4,0,2)|(1,0,0))*AB(1)
        theta(1375) = theta(1061)+theta(971)*AB(1) ! ((2,0,2)|(3,0,0)) = ((3,0,2)|(2,0,0))+((2,0,2)|(2,0,0))*AB(1)
        theta(1525) = theta(1187)+theta(1061)*AB(1) ! ((3,0,2)|(3,0,0)) = ((4,0,2)|(2,0,0))+((3,0,2)|(2,0,0))*AB(1)
        theta(1760) = theta(1525)+theta(1375)*AB(1) ! ((2,0,2)|(4,0,0)) = ((3,0,2)|(3,0,0))+((2,0,2)|(3,0,0))*AB(1)
        ! (2,0,2|3,1,0): 18
        theta(501) = dot_product(vrrbuffer(:,6), D(:,77)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,77)) ! ((3,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,77)) ! ((2,1,2)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,77)) ! ((4,0,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,77)) ! ((3,1,2)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,77)) ! ((5,0,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,77)) ! ((4,1,2)|(0,0,0))
        theta(604) = dot_product(vrrbuffer(:,109), D(:,77)) ! ((5,1,2)|(0,0,0))
        theta(657) = theta(519)+theta(501)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(702) = theta(540)+theta(516)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(765) = theta(568)+theta(537)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(849) = theta(604)+theta(565)*AB(2) ! ((5,0,2)|(0,1,0)) = ((5,1,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(2)
        theta(972) = theta(702)+theta(657)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        theta(1062) = theta(765)+theta(702)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        theta(1188) = theta(849)+theta(765)*AB(1) ! ((4,0,2)|(1,1,0)) = ((5,0,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(1)
        theta(1376) = theta(1062)+theta(972)*AB(1) ! ((2,0,2)|(2,1,0)) = ((3,0,2)|(1,1,0))+((2,0,2)|(1,1,0))*AB(1)
        theta(1526) = theta(1188)+theta(1062)*AB(1) ! ((3,0,2)|(2,1,0)) = ((4,0,2)|(1,1,0))+((3,0,2)|(1,1,0))*AB(1)
        theta(1761) = theta(1526)+theta(1376)*AB(1) ! ((2,0,2)|(3,1,0)) = ((3,0,2)|(2,1,0))+((2,0,2)|(2,1,0))*AB(1)
        ! (2,0,2|3,0,1): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,78)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,78)) ! ((3,0,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,78)) ! ((2,0,3)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,78)) ! ((4,0,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,78)) ! ((3,0,3)|(0,0,0))
        theta(565) = dot_product(vrrbuffer(:,70), D(:,78)) ! ((5,0,2)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,78)) ! ((4,0,3)|(0,0,0))
        theta(605) = dot_product(vrrbuffer(:,110), D(:,78)) ! ((5,0,3)|(0,0,0))
        theta(656) = theta(516)+theta(501)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(701) = theta(537)+theta(516)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(713) = theta(541)+theta(520)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(764) = theta(565)+theta(537)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(776) = theta(569)+theta(541)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(860) = theta(605)+theta(569)*AB(1) ! ((4,0,3)|(1,0,0)) = ((5,0,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(1)
        theta(971) = theta(701)+theta(656)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(1061) = theta(764)+theta(701)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(1085) = theta(776)+theta(713)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(1211) = theta(860)+theta(776)*AB(1) ! ((3,0,3)|(2,0,0)) = ((4,0,3)|(1,0,0))+((3,0,3)|(1,0,0))*AB(1)
        theta(1375) = theta(1061)+theta(971)*AB(1) ! ((2,0,2)|(3,0,0)) = ((3,0,2)|(2,0,0))+((2,0,2)|(2,0,0))*AB(1)
        theta(1565) = theta(1211)+theta(1085)*AB(1) ! ((2,0,3)|(3,0,0)) = ((3,0,3)|(2,0,0))+((2,0,3)|(2,0,0))*AB(1)
        theta(1762) = theta(1565)+theta(1375)*AB(3) ! ((2,0,2)|(3,0,1)) = ((2,0,3)|(3,0,0))+((2,0,2)|(3,0,0))*AB(3)
        ! (2,0,2|2,2,0): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,79)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,79)) ! ((3,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,79)) ! ((2,1,2)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,79)) ! ((4,0,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,79)) ! ((3,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,79)) ! ((2,2,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,79)) ! ((4,1,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,79)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,79)) ! ((4,2,2)|(0,0,0))
        theta(657) = theta(519)+theta(501)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(702) = theta(540)+theta(516)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(765) = theta(568)+theta(537)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(858) = theta(608)+theta(568)*AB(2) ! ((4,1,2)|(0,1,0)) = ((4,2,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(2)
        theta(974) = theta(711)+theta(657)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(1064) = theta(774)+theta(702)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1190) = theta(858)+theta(765)*AB(2) ! ((4,0,2)|(0,2,0)) = ((4,1,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(2)
        theta(1378) = theta(1064)+theta(974)*AB(1) ! ((2,0,2)|(1,2,0)) = ((3,0,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(1)
        theta(1528) = theta(1190)+theta(1064)*AB(1) ! ((3,0,2)|(1,2,0)) = ((4,0,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(1)
        theta(1763) = theta(1528)+theta(1378)*AB(1) ! ((2,0,2)|(2,2,0)) = ((3,0,2)|(1,2,0))+((2,0,2)|(1,2,0))*AB(1)
        ! (2,0,2|2,1,1): 24
        theta(501) = dot_product(vrrbuffer(:,6), D(:,80)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,80)) ! ((3,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,80)) ! ((2,1,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,80)) ! ((2,0,3)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,80)) ! ((4,0,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,80)) ! ((3,1,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,80)) ! ((3,0,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,80)) ! ((2,1,3)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,80)) ! ((4,1,2)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,80)) ! ((4,0,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,80)) ! ((3,1,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,80)) ! ((4,1,3)|(0,0,0))
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(859) = theta(609)+theta(568)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(975) = theta(712)+theta(658)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        theta(1065) = theta(775)+theta(703)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(1191) = theta(859)+theta(766)*AB(2) ! ((4,0,2)|(0,1,1)) = ((4,1,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(2)
        theta(1379) = theta(1065)+theta(975)*AB(1) ! ((2,0,2)|(1,1,1)) = ((3,0,2)|(0,1,1))+((2,0,2)|(0,1,1))*AB(1)
        theta(1529) = theta(1191)+theta(1065)*AB(1) ! ((3,0,2)|(1,1,1)) = ((4,0,2)|(0,1,1))+((3,0,2)|(0,1,1))*AB(1)
        theta(1764) = theta(1529)+theta(1379)*AB(1) ! ((2,0,2)|(2,1,1)) = ((3,0,2)|(1,1,1))+((2,0,2)|(1,1,1))*AB(1)
        ! (2,0,2|2,0,2): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,81)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,81)) ! ((3,0,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,81)) ! ((2,0,3)|(0,0,0))
        theta(537) = dot_product(vrrbuffer(:,42), D(:,81)) ! ((4,0,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,81)) ! ((3,0,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,81)) ! ((2,0,4)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,81)) ! ((4,0,3)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,81)) ! ((3,0,4)|(0,0,0))
        theta(610) = dot_product(vrrbuffer(:,115), D(:,81)) ! ((4,0,4)|(0,0,0))
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(862) = theta(610)+theta(569)*AB(3) ! ((4,0,3)|(0,0,1)) = ((4,0,4)|(0,0,0))+((4,0,3)|(0,0,0))*AB(3)
        theta(976) = theta(715)+theta(658)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(1066) = theta(778)+theta(703)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1192) = theta(862)+theta(766)*AB(3) ! ((4,0,2)|(0,0,2)) = ((4,0,3)|(0,0,1))+((4,0,2)|(0,0,1))*AB(3)
        theta(1380) = theta(1066)+theta(976)*AB(1) ! ((2,0,2)|(1,0,2)) = ((3,0,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(1)
        theta(1530) = theta(1192)+theta(1066)*AB(1) ! ((3,0,2)|(1,0,2)) = ((4,0,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(1)
        theta(1765) = theta(1530)+theta(1380)*AB(1) ! ((2,0,2)|(2,0,2)) = ((3,0,2)|(1,0,2))+((2,0,2)|(1,0,2))*AB(1)
        ! (2,0,2|1,3,0): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,82)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,82)) ! ((3,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,82)) ! ((2,1,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,82)) ! ((3,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,82)) ! ((2,2,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,82)) ! ((3,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,82)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,82)) ! ((3,3,2)|(0,0,0))
        theta(657) = theta(519)+theta(501)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(702) = theta(540)+theta(516)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(870) = theta(613)+theta(572)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(974) = theta(711)+theta(657)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(1064) = theta(774)+theta(702)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1208) = theta(870)+theta(774)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1381) = theta(1082)+theta(974)*AB(2) ! ((2,0,2)|(0,3,0)) = ((2,1,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(2)
        theta(1531) = theta(1208)+theta(1064)*AB(2) ! ((3,0,2)|(0,3,0)) = ((3,1,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(2)
        theta(1766) = theta(1531)+theta(1381)*AB(1) ! ((2,0,2)|(1,3,0)) = ((3,0,2)|(0,3,0))+((2,0,2)|(0,3,0))*AB(1)
        ! (2,0,2|1,2,1): 27
        theta(501) = dot_product(vrrbuffer(:,6), D(:,83)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,83)) ! ((3,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,83)) ! ((2,1,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,83)) ! ((2,0,3)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,83)) ! ((3,1,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,83)) ! ((3,0,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,83)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,83)) ! ((2,1,3)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,83)) ! ((3,2,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,83)) ! ((3,1,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,83)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,83)) ! ((3,2,3)|(0,0,0))
        theta(657) = theta(519)+theta(501)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(702) = theta(540)+theta(516)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(714) = theta(545)+theta(520)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(777) = theta(573)+theta(541)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(873) = theta(614)+theta(573)*AB(2) ! ((3,1,3)|(0,1,0)) = ((3,2,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(2)
        theta(974) = theta(711)+theta(657)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(1064) = theta(774)+theta(702)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1088) = theta(789)+theta(714)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1214) = theta(873)+theta(777)*AB(2) ! ((3,0,3)|(0,2,0)) = ((3,1,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(2)
        theta(1382) = theta(1088)+theta(974)*AB(3) ! ((2,0,2)|(0,2,1)) = ((2,0,3)|(0,2,0))+((2,0,2)|(0,2,0))*AB(3)
        theta(1532) = theta(1214)+theta(1064)*AB(3) ! ((3,0,2)|(0,2,1)) = ((3,0,3)|(0,2,0))+((3,0,2)|(0,2,0))*AB(3)
        theta(1767) = theta(1532)+theta(1382)*AB(1) ! ((2,0,2)|(1,2,1)) = ((3,0,2)|(0,2,1))+((2,0,2)|(0,2,1))*AB(1)
        ! (2,0,2|1,1,2): 27
        theta(501) = dot_product(vrrbuffer(:,6), D(:,84)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,84)) ! ((3,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,84)) ! ((2,1,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,84)) ! ((2,0,3)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,84)) ! ((3,1,2)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,84)) ! ((3,0,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,84)) ! ((2,1,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,84)) ! ((2,0,4)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,84)) ! ((3,1,3)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,84)) ! ((3,0,4)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,84)) ! ((2,1,4)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,84)) ! ((3,1,4)|(0,0,0))
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(874) = theta(615)+theta(573)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(976) = theta(715)+theta(658)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(1066) = theta(778)+theta(703)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1210) = theta(874)+theta(775)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1383) = theta(1084)+theta(976)*AB(2) ! ((2,0,2)|(0,1,2)) = ((2,1,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(2)
        theta(1533) = theta(1210)+theta(1066)*AB(2) ! ((3,0,2)|(0,1,2)) = ((3,1,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(2)
        theta(1768) = theta(1533)+theta(1383)*AB(1) ! ((2,0,2)|(1,1,2)) = ((3,0,2)|(0,1,2))+((2,0,2)|(0,1,2))*AB(1)
        ! (2,0,2|1,0,3): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,85)) ! ((2,0,2)|(0,0,0))
        theta(516) = dot_product(vrrbuffer(:,21), D(:,85)) ! ((3,0,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,85)) ! ((2,0,3)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,85)) ! ((3,0,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,85)) ! ((2,0,4)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,85)) ! ((3,0,4)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,85)) ! ((2,0,5)|(0,0,0))
        theta(616) = dot_product(vrrbuffer(:,121), D(:,85)) ! ((3,0,5)|(0,0,0))
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(877) = theta(616)+theta(574)*AB(3) ! ((3,0,4)|(0,0,1)) = ((3,0,5)|(0,0,0))+((3,0,4)|(0,0,0))*AB(3)
        theta(976) = theta(715)+theta(658)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(1066) = theta(778)+theta(703)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1090) = theta(793)+theta(715)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1216) = theta(877)+theta(778)*AB(3) ! ((3,0,3)|(0,0,2)) = ((3,0,4)|(0,0,1))+((3,0,3)|(0,0,1))*AB(3)
        theta(1384) = theta(1090)+theta(976)*AB(3) ! ((2,0,2)|(0,0,3)) = ((2,0,3)|(0,0,2))+((2,0,2)|(0,0,2))*AB(3)
        theta(1534) = theta(1216)+theta(1066)*AB(3) ! ((3,0,2)|(0,0,3)) = ((3,0,3)|(0,0,2))+((3,0,2)|(0,0,2))*AB(3)
        theta(1769) = theta(1534)+theta(1384)*AB(1) ! ((2,0,2)|(1,0,3)) = ((3,0,2)|(0,0,3))+((2,0,2)|(0,0,3))*AB(1)
        ! (2,0,2|0,4,0): 15
        theta(501) = dot_product(vrrbuffer(:,6), D(:,86)) ! ((2,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,86)) ! ((2,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,86)) ! ((2,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,86)) ! ((2,3,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,86)) ! ((2,4,2)|(0,0,0))
        theta(657) = theta(519)+theta(501)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(885) = theta(619)+theta(577)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(974) = theta(711)+theta(657)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1232) = theta(885)+theta(786)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1381) = theta(1082)+theta(974)*AB(2) ! ((2,0,2)|(0,3,0)) = ((2,1,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(2)
        theta(1561) = theta(1232)+theta(1082)*AB(2) ! ((2,1,2)|(0,3,0)) = ((2,2,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(2)
        theta(1770) = theta(1561)+theta(1381)*AB(2) ! ((2,0,2)|(0,4,0)) = ((2,1,2)|(0,3,0))+((2,0,2)|(0,3,0))*AB(2)
        ! (2,0,2|0,3,1): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,87)) ! ((2,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,87)) ! ((2,1,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,87)) ! ((2,0,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,87)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,87)) ! ((2,1,3)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,87)) ! ((2,3,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,87)) ! ((2,2,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,87)) ! ((2,3,3)|(0,0,0))
        theta(657) = theta(519)+theta(501)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(714) = theta(545)+theta(520)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(888) = theta(620)+theta(578)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(974) = theta(711)+theta(657)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1088) = theta(789)+theta(714)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1238) = theta(888)+theta(789)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(1381) = theta(1082)+theta(974)*AB(2) ! ((2,0,2)|(0,3,0)) = ((2,1,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(2)
        theta(1571) = theta(1238)+theta(1088)*AB(2) ! ((2,0,3)|(0,3,0)) = ((2,1,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(2)
        theta(1771) = theta(1571)+theta(1381)*AB(3) ! ((2,0,2)|(0,3,1)) = ((2,0,3)|(0,3,0))+((2,0,2)|(0,3,0))*AB(3)
        ! (2,0,2|0,2,2): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,88)) ! ((2,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,88)) ! ((2,1,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,88)) ! ((2,0,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,88)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,88)) ! ((2,1,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,88)) ! ((2,0,4)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,88)) ! ((2,2,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,88)) ! ((2,1,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,88)) ! ((2,2,4)|(0,0,0))
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(976) = theta(715)+theta(658)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1234) = theta(889)+theta(787)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1383) = theta(1084)+theta(976)*AB(2) ! ((2,0,2)|(0,1,2)) = ((2,1,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(2)
        theta(1563) = theta(1234)+theta(1084)*AB(2) ! ((2,1,2)|(0,1,2)) = ((2,2,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(2)
        theta(1772) = theta(1563)+theta(1383)*AB(2) ! ((2,0,2)|(0,2,2)) = ((2,1,2)|(0,1,2))+((2,0,2)|(0,1,2))*AB(2)
        ! (2,0,2|0,1,3): 21
        theta(501) = dot_product(vrrbuffer(:,6), D(:,89)) ! ((2,0,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,89)) ! ((2,1,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,89)) ! ((2,0,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,89)) ! ((2,1,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,89)) ! ((2,0,4)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,89)) ! ((2,1,4)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,89)) ! ((2,0,5)|(0,0,0))
        theta(622) = dot_product(vrrbuffer(:,127), D(:,89)) ! ((2,1,5)|(0,0,0))
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(892) = theta(622)+theta(579)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(976) = theta(715)+theta(658)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1090) = theta(793)+theta(715)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1240) = theta(892)+theta(790)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1384) = theta(1090)+theta(976)*AB(3) ! ((2,0,2)|(0,0,3)) = ((2,0,3)|(0,0,2))+((2,0,2)|(0,0,2))*AB(3)
        theta(1564) = theta(1240)+theta(1084)*AB(3) ! ((2,1,2)|(0,0,3)) = ((2,1,3)|(0,0,2))+((2,1,2)|(0,0,2))*AB(3)
        theta(1773) = theta(1564)+theta(1384)*AB(2) ! ((2,0,2)|(0,1,3)) = ((2,1,2)|(0,0,3))+((2,0,2)|(0,0,3))*AB(2)
        ! (2,0,2|0,0,4): 15
        theta(501) = dot_product(vrrbuffer(:,6), D(:,90)) ! ((2,0,2)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,90)) ! ((2,0,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,90)) ! ((2,0,4)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,90)) ! ((2,0,5)|(0,0,0))
        theta(623) = dot_product(vrrbuffer(:,128), D(:,90)) ! ((2,0,6)|(0,0,0))
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(895) = theta(623)+theta(580)*AB(3) ! ((2,0,5)|(0,0,1)) = ((2,0,6)|(0,0,0))+((2,0,5)|(0,0,0))*AB(3)
        theta(976) = theta(715)+theta(658)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(1090) = theta(793)+theta(715)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1246) = theta(895)+theta(793)*AB(3) ! ((2,0,4)|(0,0,2)) = ((2,0,5)|(0,0,1))+((2,0,4)|(0,0,1))*AB(3)
        theta(1384) = theta(1090)+theta(976)*AB(3) ! ((2,0,2)|(0,0,3)) = ((2,0,3)|(0,0,2))+((2,0,2)|(0,0,2))*AB(3)
        theta(1574) = theta(1246)+theta(1090)*AB(3) ! ((2,0,3)|(0,0,3)) = ((2,0,4)|(0,0,2))+((2,0,3)|(0,0,2))*AB(3)
        theta(1774) = theta(1574)+theta(1384)*AB(3) ! ((2,0,2)|(0,0,4)) = ((2,0,3)|(0,0,3))+((2,0,2)|(0,0,3))*AB(3)
        ! (1,3,0|4,0,0): 15
        theta(502) = dot_product(vrrbuffer(:,7), D(:,91)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,91)) ! ((2,3,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,91)) ! ((3,3,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,91)) ! ((4,3,0)|(0,0,0))
        theta(602) = dot_product(vrrbuffer(:,107), D(:,91)) ! ((5,3,0)|(0,0,0))
        theta(659) = theta(517)+theta(502)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(704) = theta(538)+theta(517)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(767) = theta(566)+theta(538)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(851) = theta(602)+theta(566)*AB(1) ! ((4,3,0)|(1,0,0)) = ((5,3,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(1)
        theta(977) = theta(704)+theta(659)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(1067) = theta(767)+theta(704)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(1193) = theta(851)+theta(767)*AB(1) ! ((3,3,0)|(2,0,0)) = ((4,3,0)|(1,0,0))+((3,3,0)|(1,0,0))*AB(1)
        theta(1385) = theta(1067)+theta(977)*AB(1) ! ((1,3,0)|(3,0,0)) = ((2,3,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(1)
        theta(1535) = theta(1193)+theta(1067)*AB(1) ! ((2,3,0)|(3,0,0)) = ((3,3,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(1)
        theta(1775) = theta(1535)+theta(1385)*AB(1) ! ((1,3,0)|(4,0,0)) = ((2,3,0)|(3,0,0))+((1,3,0)|(3,0,0))*AB(1)
        ! (1,3,0|3,1,0): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,92)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,92)) ! ((2,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,92)) ! ((1,4,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,92)) ! ((3,3,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,92)) ! ((2,4,0)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,92)) ! ((4,3,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,92)) ! ((3,4,0)|(0,0,0))
        theta(606) = dot_product(vrrbuffer(:,111), D(:,92)) ! ((4,4,0)|(0,0,0))
        theta(659) = theta(517)+theta(502)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(704) = theta(538)+theta(517)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(716) = theta(542)+theta(521)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(767) = theta(566)+theta(538)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(779) = theta(570)+theta(542)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(863) = theta(606)+theta(570)*AB(1) ! ((3,4,0)|(1,0,0)) = ((4,4,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(1)
        theta(977) = theta(704)+theta(659)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(1067) = theta(767)+theta(704)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(1091) = theta(779)+theta(716)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(1217) = theta(863)+theta(779)*AB(1) ! ((2,4,0)|(2,0,0)) = ((3,4,0)|(1,0,0))+((2,4,0)|(1,0,0))*AB(1)
        theta(1385) = theta(1067)+theta(977)*AB(1) ! ((1,3,0)|(3,0,0)) = ((2,3,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(1)
        theta(1575) = theta(1217)+theta(1091)*AB(1) ! ((1,4,0)|(3,0,0)) = ((2,4,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(1)
        theta(1776) = theta(1575)+theta(1385)*AB(2) ! ((1,3,0)|(3,1,0)) = ((1,4,0)|(3,0,0))+((1,3,0)|(3,0,0))*AB(2)
        ! (1,3,0|3,0,1): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,93)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,93)) ! ((2,3,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,93)) ! ((1,3,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,93)) ! ((3,3,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,93)) ! ((2,3,1)|(0,0,0))
        theta(566) = dot_product(vrrbuffer(:,71), D(:,93)) ! ((4,3,0)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,93)) ! ((3,3,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,93)) ! ((4,3,1)|(0,0,0))
        theta(659) = theta(517)+theta(502)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(704) = theta(538)+theta(517)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(719) = theta(543)+theta(522)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(767) = theta(566)+theta(538)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(782) = theta(571)+theta(543)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(866) = theta(607)+theta(571)*AB(1) ! ((3,3,1)|(1,0,0)) = ((4,3,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(1)
        theta(977) = theta(704)+theta(659)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(1067) = theta(767)+theta(704)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(1097) = theta(782)+theta(719)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(1223) = theta(866)+theta(782)*AB(1) ! ((2,3,1)|(2,0,0)) = ((3,3,1)|(1,0,0))+((2,3,1)|(1,0,0))*AB(1)
        theta(1385) = theta(1067)+theta(977)*AB(1) ! ((1,3,0)|(3,0,0)) = ((2,3,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(1)
        theta(1585) = theta(1223)+theta(1097)*AB(1) ! ((1,3,1)|(3,0,0)) = ((2,3,1)|(2,0,0))+((1,3,1)|(2,0,0))*AB(1)
        theta(1777) = theta(1585)+theta(1385)*AB(3) ! ((1,3,0)|(3,0,1)) = ((1,3,1)|(3,0,0))+((1,3,0)|(3,0,0))*AB(3)
        ! (1,3,0|2,2,0): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,94)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,94)) ! ((2,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,94)) ! ((1,4,0)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,94)) ! ((3,3,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,94)) ! ((2,4,0)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,94)) ! ((1,5,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,94)) ! ((3,4,0)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,94)) ! ((2,5,0)|(0,0,0))
        theta(611) = dot_product(vrrbuffer(:,116), D(:,94)) ! ((3,5,0)|(0,0,0))
        theta(660) = theta(521)+theta(502)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(864) = theta(611)+theta(570)*AB(2) ! ((3,4,0)|(0,1,0)) = ((3,5,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(2)
        theta(980) = theta(717)+theta(660)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(1070) = theta(780)+theta(705)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(1196) = theta(864)+theta(768)*AB(2) ! ((3,3,0)|(0,2,0)) = ((3,4,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(2)
        theta(1388) = theta(1070)+theta(980)*AB(1) ! ((1,3,0)|(1,2,0)) = ((2,3,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(1)
        theta(1538) = theta(1196)+theta(1070)*AB(1) ! ((2,3,0)|(1,2,0)) = ((3,3,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(1)
        theta(1778) = theta(1538)+theta(1388)*AB(1) ! ((1,3,0)|(2,2,0)) = ((2,3,0)|(1,2,0))+((1,3,0)|(1,2,0))*AB(1)
        ! (1,3,0|2,1,1): 27
        theta(502) = dot_product(vrrbuffer(:,7), D(:,95)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,95)) ! ((2,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,95)) ! ((1,4,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,95)) ! ((1,3,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,95)) ! ((3,3,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,95)) ! ((2,4,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,95)) ! ((2,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,95)) ! ((1,4,1)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,95)) ! ((3,4,0)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,95)) ! ((3,3,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,95)) ! ((2,4,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,95)) ! ((3,4,1)|(0,0,0))
        theta(659) = theta(517)+theta(502)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(704) = theta(538)+theta(517)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(716) = theta(542)+theta(521)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(719) = theta(543)+theta(522)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(779) = theta(570)+theta(542)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(782) = theta(571)+theta(543)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(797) = theta(576)+theta(548)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(881) = theta(612)+theta(576)*AB(1) ! ((2,4,1)|(1,0,0)) = ((3,4,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(1)
        theta(977) = theta(704)+theta(659)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(1091) = theta(779)+theta(716)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(1097) = theta(782)+theta(719)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(1253) = theta(881)+theta(797)*AB(1) ! ((1,4,1)|(2,0,0)) = ((2,4,1)|(1,0,0))+((1,4,1)|(1,0,0))*AB(1)
        theta(1387) = theta(1097)+theta(977)*AB(3) ! ((1,3,0)|(2,0,1)) = ((1,3,1)|(2,0,0))+((1,3,0)|(2,0,0))*AB(3)
        theta(1577) = theta(1253)+theta(1091)*AB(3) ! ((1,4,0)|(2,0,1)) = ((1,4,1)|(2,0,0))+((1,4,0)|(2,0,0))*AB(3)
        theta(1779) = theta(1577)+theta(1387)*AB(2) ! ((1,3,0)|(2,1,1)) = ((1,4,0)|(2,0,1))+((1,3,0)|(2,0,1))*AB(2)
        ! (1,3,0|2,0,2): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,96)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,96)) ! ((2,3,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,96)) ! ((1,3,1)|(0,0,0))
        theta(538) = dot_product(vrrbuffer(:,43), D(:,96)) ! ((3,3,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,96)) ! ((2,3,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,96)) ! ((1,3,2)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,96)) ! ((3,3,1)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,96)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,96)) ! ((3,3,2)|(0,0,0))
        theta(661) = theta(522)+theta(502)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(706) = theta(543)+theta(517)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(769) = theta(571)+theta(538)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(868) = theta(613)+theta(571)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(982) = theta(721)+theta(661)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(1072) = theta(784)+theta(706)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1198) = theta(868)+theta(769)*AB(3) ! ((3,3,0)|(0,0,2)) = ((3,3,1)|(0,0,1))+((3,3,0)|(0,0,1))*AB(3)
        theta(1390) = theta(1072)+theta(982)*AB(1) ! ((1,3,0)|(1,0,2)) = ((2,3,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(1)
        theta(1540) = theta(1198)+theta(1072)*AB(1) ! ((2,3,0)|(1,0,2)) = ((3,3,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(1)
        theta(1780) = theta(1540)+theta(1390)*AB(1) ! ((1,3,0)|(2,0,2)) = ((2,3,0)|(1,0,2))+((1,3,0)|(1,0,2))*AB(1)
        ! (1,3,0|1,3,0): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,97)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,97)) ! ((2,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,97)) ! ((1,4,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,97)) ! ((2,4,0)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,97)) ! ((1,5,0)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,97)) ! ((2,5,0)|(0,0,0))
        theta(581) = dot_product(vrrbuffer(:,86), D(:,97)) ! ((1,6,0)|(0,0,0))
        theta(617) = dot_product(vrrbuffer(:,122), D(:,97)) ! ((2,6,0)|(0,0,0))
        theta(660) = theta(521)+theta(502)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(795) = theta(581)+theta(547)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(879) = theta(617)+theta(575)*AB(2) ! ((2,5,0)|(0,1,0)) = ((2,6,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(2)
        theta(980) = theta(717)+theta(660)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(1070) = theta(780)+theta(705)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(1094) = theta(795)+theta(717)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(1220) = theta(879)+theta(780)*AB(2) ! ((2,4,0)|(0,2,0)) = ((2,5,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(2)
        theta(1391) = theta(1094)+theta(980)*AB(2) ! ((1,3,0)|(0,3,0)) = ((1,4,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(2)
        theta(1541) = theta(1220)+theta(1070)*AB(2) ! ((2,3,0)|(0,3,0)) = ((2,4,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(2)
        theta(1781) = theta(1541)+theta(1391)*AB(1) ! ((1,3,0)|(1,3,0)) = ((2,3,0)|(0,3,0))+((1,3,0)|(0,3,0))*AB(1)
        ! (1,3,0|1,2,1): 27
        theta(502) = dot_product(vrrbuffer(:,7), D(:,98)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,98)) ! ((2,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,98)) ! ((1,4,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,98)) ! ((1,3,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,98)) ! ((2,4,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,98)) ! ((2,3,1)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,98)) ! ((1,5,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,98)) ! ((1,4,1)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,98)) ! ((2,5,0)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,98)) ! ((2,4,1)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,98)) ! ((1,5,1)|(0,0,0))
        theta(618) = dot_product(vrrbuffer(:,123), D(:,98)) ! ((2,5,1)|(0,0,0))
        theta(660) = theta(521)+theta(502)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(882) = theta(618)+theta(576)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(980) = theta(717)+theta(660)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(1070) = theta(780)+theta(705)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1226) = theta(882)+theta(783)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1392) = theta(1100)+theta(980)*AB(3) ! ((1,3,0)|(0,2,1)) = ((1,3,1)|(0,2,0))+((1,3,0)|(0,2,0))*AB(3)
        theta(1542) = theta(1226)+theta(1070)*AB(3) ! ((2,3,0)|(0,2,1)) = ((2,3,1)|(0,2,0))+((2,3,0)|(0,2,0))*AB(3)
        theta(1782) = theta(1542)+theta(1392)*AB(1) ! ((1,3,0)|(1,2,1)) = ((2,3,0)|(0,2,1))+((1,3,0)|(0,2,1))*AB(1)
        ! (1,3,0|1,1,2): 27
        theta(502) = dot_product(vrrbuffer(:,7), D(:,99)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,99)) ! ((2,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,99)) ! ((1,4,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,99)) ! ((1,3,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,99)) ! ((2,4,0)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,99)) ! ((2,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,99)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,99)) ! ((1,3,2)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,99)) ! ((2,4,1)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,99)) ! ((2,3,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,99)) ! ((1,4,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,99)) ! ((2,4,2)|(0,0,0))
        theta(661) = theta(522)+theta(502)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(706) = theta(543)+theta(517)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(718) = theta(548)+theta(521)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(781) = theta(576)+theta(542)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(883) = theta(619)+theta(576)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(982) = theta(721)+theta(661)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(1072) = theta(784)+theta(706)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1096) = theta(799)+theta(718)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1222) = theta(883)+theta(781)*AB(3) ! ((2,4,0)|(0,0,2)) = ((2,4,1)|(0,0,1))+((2,4,0)|(0,0,1))*AB(3)
        theta(1393) = theta(1096)+theta(982)*AB(2) ! ((1,3,0)|(0,1,2)) = ((1,4,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(2)
        theta(1543) = theta(1222)+theta(1072)*AB(2) ! ((2,3,0)|(0,1,2)) = ((2,4,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(2)
        theta(1783) = theta(1543)+theta(1393)*AB(1) ! ((1,3,0)|(1,1,2)) = ((2,3,0)|(0,1,2))+((1,3,0)|(0,1,2))*AB(1)
        ! (1,3,0|1,0,3): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,100)) ! ((1,3,0)|(0,0,0))
        theta(517) = dot_product(vrrbuffer(:,22), D(:,100)) ! ((2,3,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,100)) ! ((1,3,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,100)) ! ((2,3,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,100)) ! ((1,3,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,100)) ! ((2,3,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,100)) ! ((1,3,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,100)) ! ((2,3,3)|(0,0,0))
        theta(661) = theta(522)+theta(502)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(706) = theta(543)+theta(517)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(886) = theta(620)+theta(577)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(982) = theta(721)+theta(661)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(1072) = theta(784)+theta(706)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1228) = theta(886)+theta(784)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1394) = theta(1102)+theta(982)*AB(3) ! ((1,3,0)|(0,0,3)) = ((1,3,1)|(0,0,2))+((1,3,0)|(0,0,2))*AB(3)
        theta(1544) = theta(1228)+theta(1072)*AB(3) ! ((2,3,0)|(0,0,3)) = ((2,3,1)|(0,0,2))+((2,3,0)|(0,0,2))*AB(3)
        theta(1784) = theta(1544)+theta(1394)*AB(1) ! ((1,3,0)|(1,0,3)) = ((2,3,0)|(0,0,3))+((1,3,0)|(0,0,3))*AB(1)
        ! (1,3,0|0,4,0): 15
        theta(502) = dot_product(vrrbuffer(:,7), D(:,101)) ! ((1,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,101)) ! ((1,4,0)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,101)) ! ((1,5,0)|(0,0,0))
        theta(581) = dot_product(vrrbuffer(:,86), D(:,101)) ! ((1,6,0)|(0,0,0))
        theta(624) = dot_product(vrrbuffer(:,129), D(:,101)) ! ((1,7,0)|(0,0,0))
        theta(660) = theta(521)+theta(502)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(795) = theta(581)+theta(547)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(897) = theta(624)+theta(581)*AB(2) ! ((1,6,0)|(0,1,0)) = ((1,7,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(2)
        theta(980) = theta(717)+theta(660)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(1094) = theta(795)+theta(717)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(1250) = theta(897)+theta(795)*AB(2) ! ((1,5,0)|(0,2,0)) = ((1,6,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(2)
        theta(1391) = theta(1094)+theta(980)*AB(2) ! ((1,3,0)|(0,3,0)) = ((1,4,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(2)
        theta(1581) = theta(1250)+theta(1094)*AB(2) ! ((1,4,0)|(0,3,0)) = ((1,5,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(2)
        theta(1785) = theta(1581)+theta(1391)*AB(2) ! ((1,3,0)|(0,4,0)) = ((1,4,0)|(0,3,0))+((1,3,0)|(0,3,0))*AB(2)
        ! (1,3,0|0,3,1): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,102)) ! ((1,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,102)) ! ((1,4,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,102)) ! ((1,3,1)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,102)) ! ((1,5,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,102)) ! ((1,4,1)|(0,0,0))
        theta(581) = dot_product(vrrbuffer(:,86), D(:,102)) ! ((1,6,0)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,102)) ! ((1,5,1)|(0,0,0))
        theta(625) = dot_product(vrrbuffer(:,130), D(:,102)) ! ((1,6,1)|(0,0,0))
        theta(660) = theta(521)+theta(502)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(795) = theta(581)+theta(547)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(900) = theta(625)+theta(582)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(980) = theta(717)+theta(660)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(1094) = theta(795)+theta(717)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1256) = theta(900)+theta(798)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        theta(1391) = theta(1094)+theta(980)*AB(2) ! ((1,3,0)|(0,3,0)) = ((1,4,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(2)
        theta(1591) = theta(1256)+theta(1100)*AB(2) ! ((1,3,1)|(0,3,0)) = ((1,4,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(2)
        theta(1786) = theta(1591)+theta(1391)*AB(3) ! ((1,3,0)|(0,3,1)) = ((1,3,1)|(0,3,0))+((1,3,0)|(0,3,0))*AB(3)
        ! (1,3,0|0,2,2): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,103)) ! ((1,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,103)) ! ((1,4,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,103)) ! ((1,3,1)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,103)) ! ((1,5,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,103)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,103)) ! ((1,3,2)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,103)) ! ((1,5,1)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,103)) ! ((1,4,2)|(0,0,0))
        theta(626) = dot_product(vrrbuffer(:,131), D(:,103)) ! ((1,5,2)|(0,0,0))
        theta(661) = theta(522)+theta(502)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(718) = theta(548)+theta(521)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(796) = theta(582)+theta(547)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(901) = theta(626)+theta(582)*AB(3) ! ((1,5,1)|(0,0,1)) = ((1,5,2)|(0,0,0))+((1,5,1)|(0,0,0))*AB(3)
        theta(982) = theta(721)+theta(661)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(1096) = theta(799)+theta(718)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1252) = theta(901)+theta(796)*AB(3) ! ((1,5,0)|(0,0,2)) = ((1,5,1)|(0,0,1))+((1,5,0)|(0,0,1))*AB(3)
        theta(1393) = theta(1096)+theta(982)*AB(2) ! ((1,3,0)|(0,1,2)) = ((1,4,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(2)
        theta(1583) = theta(1252)+theta(1096)*AB(2) ! ((1,4,0)|(0,1,2)) = ((1,5,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(2)
        theta(1787) = theta(1583)+theta(1393)*AB(2) ! ((1,3,0)|(0,2,2)) = ((1,4,0)|(0,1,2))+((1,3,0)|(0,1,2))*AB(2)
        ! (1,3,0|0,1,3): 21
        theta(502) = dot_product(vrrbuffer(:,7), D(:,104)) ! ((1,3,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,104)) ! ((1,4,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,104)) ! ((1,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,104)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,104)) ! ((1,3,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,104)) ! ((1,4,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,104)) ! ((1,3,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,104)) ! ((1,4,3)|(0,0,0))
        theta(661) = theta(522)+theta(502)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(718) = theta(548)+theta(521)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(904) = theta(627)+theta(583)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        theta(982) = theta(721)+theta(661)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(1096) = theta(799)+theta(718)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1258) = theta(904)+theta(799)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(1394) = theta(1102)+theta(982)*AB(3) ! ((1,3,0)|(0,0,3)) = ((1,3,1)|(0,0,2))+((1,3,0)|(0,0,2))*AB(3)
        theta(1584) = theta(1258)+theta(1096)*AB(3) ! ((1,4,0)|(0,0,3)) = ((1,4,1)|(0,0,2))+((1,4,0)|(0,0,2))*AB(3)
        theta(1788) = theta(1584)+theta(1394)*AB(2) ! ((1,3,0)|(0,1,3)) = ((1,4,0)|(0,0,3))+((1,3,0)|(0,0,3))*AB(2)
        ! (1,3,0|0,0,4): 15
        theta(502) = dot_product(vrrbuffer(:,7), D(:,105)) ! ((1,3,0)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,105)) ! ((1,3,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,105)) ! ((1,3,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,105)) ! ((1,3,3)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,105)) ! ((1,3,4)|(0,0,0))
        theta(661) = theta(522)+theta(502)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(907) = theta(628)+theta(584)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(982) = theta(721)+theta(661)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1264) = theta(907)+theta(802)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1394) = theta(1102)+theta(982)*AB(3) ! ((1,3,0)|(0,0,3)) = ((1,3,1)|(0,0,2))+((1,3,0)|(0,0,2))*AB(3)
        theta(1594) = theta(1264)+theta(1102)*AB(3) ! ((1,3,1)|(0,0,3)) = ((1,3,2)|(0,0,2))+((1,3,1)|(0,0,2))*AB(3)
        theta(1789) = theta(1594)+theta(1394)*AB(3) ! ((1,3,0)|(0,0,4)) = ((1,3,1)|(0,0,3))+((1,3,0)|(0,0,3))*AB(3)
        ! (1,2,1|4,0,0): 15
        theta(503) = dot_product(vrrbuffer(:,8), D(:,106)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,106)) ! ((2,2,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,106)) ! ((3,2,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,106)) ! ((4,2,1)|(0,0,0))
        theta(603) = dot_product(vrrbuffer(:,108), D(:,106)) ! ((5,2,1)|(0,0,0))
        theta(662) = theta(518)+theta(503)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(707) = theta(539)+theta(518)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(770) = theta(567)+theta(539)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(854) = theta(603)+theta(567)*AB(1) ! ((4,2,1)|(1,0,0)) = ((5,2,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(1)
        theta(983) = theta(707)+theta(662)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(1073) = theta(770)+theta(707)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(1199) = theta(854)+theta(770)*AB(1) ! ((3,2,1)|(2,0,0)) = ((4,2,1)|(1,0,0))+((3,2,1)|(1,0,0))*AB(1)
        theta(1395) = theta(1073)+theta(983)*AB(1) ! ((1,2,1)|(3,0,0)) = ((2,2,1)|(2,0,0))+((1,2,1)|(2,0,0))*AB(1)
        theta(1545) = theta(1199)+theta(1073)*AB(1) ! ((2,2,1)|(3,0,0)) = ((3,2,1)|(2,0,0))+((2,2,1)|(2,0,0))*AB(1)
        theta(1790) = theta(1545)+theta(1395)*AB(1) ! ((1,2,1)|(4,0,0)) = ((2,2,1)|(3,0,0))+((1,2,1)|(3,0,0))*AB(1)
        ! (1,2,1|3,1,0): 18
        theta(503) = dot_product(vrrbuffer(:,8), D(:,107)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,107)) ! ((2,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,107)) ! ((1,3,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,107)) ! ((3,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,107)) ! ((2,3,1)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,107)) ! ((4,2,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,107)) ! ((3,3,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,107)) ! ((4,3,1)|(0,0,0))
        theta(663) = theta(522)+theta(503)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(855) = theta(607)+theta(567)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(984) = theta(708)+theta(663)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        theta(1074) = theta(771)+theta(708)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        theta(1200) = theta(855)+theta(771)*AB(1) ! ((3,2,1)|(1,1,0)) = ((4,2,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(1)
        theta(1396) = theta(1074)+theta(984)*AB(1) ! ((1,2,1)|(2,1,0)) = ((2,2,1)|(1,1,0))+((1,2,1)|(1,1,0))*AB(1)
        theta(1546) = theta(1200)+theta(1074)*AB(1) ! ((2,2,1)|(2,1,0)) = ((3,2,1)|(1,1,0))+((2,2,1)|(1,1,0))*AB(1)
        theta(1791) = theta(1546)+theta(1396)*AB(1) ! ((1,2,1)|(3,1,0)) = ((2,2,1)|(2,1,0))+((1,2,1)|(2,1,0))*AB(1)
        ! (1,2,1|3,0,1): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,108)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,108)) ! ((2,2,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,108)) ! ((1,2,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,108)) ! ((3,2,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,108)) ! ((2,2,2)|(0,0,0))
        theta(567) = dot_product(vrrbuffer(:,72), D(:,108)) ! ((4,2,1)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,108)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,108)) ! ((4,2,2)|(0,0,0))
        theta(662) = theta(518)+theta(503)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(707) = theta(539)+theta(518)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(722) = theta(544)+theta(523)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(770) = theta(567)+theta(539)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(785) = theta(572)+theta(544)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(869) = theta(608)+theta(572)*AB(1) ! ((3,2,2)|(1,0,0)) = ((4,2,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(1)
        theta(983) = theta(707)+theta(662)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(1073) = theta(770)+theta(707)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(1103) = theta(785)+theta(722)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(1229) = theta(869)+theta(785)*AB(1) ! ((2,2,2)|(2,0,0)) = ((3,2,2)|(1,0,0))+((2,2,2)|(1,0,0))*AB(1)
        theta(1395) = theta(1073)+theta(983)*AB(1) ! ((1,2,1)|(3,0,0)) = ((2,2,1)|(2,0,0))+((1,2,1)|(2,0,0))*AB(1)
        theta(1595) = theta(1229)+theta(1103)*AB(1) ! ((1,2,2)|(3,0,0)) = ((2,2,2)|(2,0,0))+((1,2,2)|(2,0,0))*AB(1)
        theta(1792) = theta(1595)+theta(1395)*AB(3) ! ((1,2,1)|(3,0,1)) = ((1,2,2)|(3,0,0))+((1,2,1)|(3,0,0))*AB(3)
        ! (1,2,1|2,2,0): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,109)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,109)) ! ((2,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,109)) ! ((1,3,1)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,109)) ! ((3,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,109)) ! ((2,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,109)) ! ((1,4,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,109)) ! ((3,3,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,109)) ! ((2,4,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,109)) ! ((3,4,1)|(0,0,0))
        theta(663) = theta(522)+theta(503)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(867) = theta(612)+theta(571)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(986) = theta(720)+theta(663)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1202) = theta(867)+theta(771)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1398) = theta(1076)+theta(986)*AB(1) ! ((1,2,1)|(1,2,0)) = ((2,2,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(1)
        theta(1548) = theta(1202)+theta(1076)*AB(1) ! ((2,2,1)|(1,2,0)) = ((3,2,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(1)
        theta(1793) = theta(1548)+theta(1398)*AB(1) ! ((1,2,1)|(2,2,0)) = ((2,2,1)|(1,2,0))+((1,2,1)|(1,2,0))*AB(1)
        ! (1,2,1|2,1,1): 24
        theta(503) = dot_product(vrrbuffer(:,8), D(:,110)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,110)) ! ((2,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,110)) ! ((1,3,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,110)) ! ((1,2,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,110)) ! ((3,2,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,110)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,110)) ! ((2,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,110)) ! ((1,3,2)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,110)) ! ((3,3,1)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,110)) ! ((3,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,110)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,110)) ! ((3,3,2)|(0,0,0))
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(868) = theta(613)+theta(571)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(987) = theta(721)+theta(664)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        theta(1077) = theta(784)+theta(709)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(1203) = theta(868)+theta(772)*AB(2) ! ((3,2,1)|(0,1,1)) = ((3,3,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(2)
        theta(1399) = theta(1077)+theta(987)*AB(1) ! ((1,2,1)|(1,1,1)) = ((2,2,1)|(0,1,1))+((1,2,1)|(0,1,1))*AB(1)
        theta(1549) = theta(1203)+theta(1077)*AB(1) ! ((2,2,1)|(1,1,1)) = ((3,2,1)|(0,1,1))+((2,2,1)|(0,1,1))*AB(1)
        theta(1794) = theta(1549)+theta(1399)*AB(1) ! ((1,2,1)|(2,1,1)) = ((2,2,1)|(1,1,1))+((1,2,1)|(1,1,1))*AB(1)
        ! (1,2,1|2,0,2): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,111)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,111)) ! ((2,2,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,111)) ! ((1,2,2)|(0,0,0))
        theta(539) = dot_product(vrrbuffer(:,44), D(:,111)) ! ((3,2,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,111)) ! ((2,2,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,111)) ! ((1,2,3)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,111)) ! ((3,2,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,111)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,111)) ! ((3,2,3)|(0,0,0))
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(871) = theta(614)+theta(572)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(988) = theta(724)+theta(664)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1204) = theta(871)+theta(772)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1400) = theta(1078)+theta(988)*AB(1) ! ((1,2,1)|(1,0,2)) = ((2,2,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(1)
        theta(1550) = theta(1204)+theta(1078)*AB(1) ! ((2,2,1)|(1,0,2)) = ((3,2,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(1)
        theta(1795) = theta(1550)+theta(1400)*AB(1) ! ((1,2,1)|(2,0,2)) = ((2,2,1)|(1,0,2))+((1,2,1)|(1,0,2))*AB(1)
        ! (1,2,1|1,3,0): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,112)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,112)) ! ((2,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,112)) ! ((1,3,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,112)) ! ((2,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,112)) ! ((1,4,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,112)) ! ((2,4,1)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,112)) ! ((1,5,1)|(0,0,0))
        theta(618) = dot_product(vrrbuffer(:,123), D(:,112)) ! ((2,5,1)|(0,0,0))
        theta(663) = theta(522)+theta(503)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(882) = theta(618)+theta(576)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(986) = theta(720)+theta(663)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1226) = theta(882)+theta(783)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1401) = theta(1100)+theta(986)*AB(2) ! ((1,2,1)|(0,3,0)) = ((1,3,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(2)
        theta(1551) = theta(1226)+theta(1076)*AB(2) ! ((2,2,1)|(0,3,0)) = ((2,3,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(2)
        theta(1796) = theta(1551)+theta(1401)*AB(1) ! ((1,2,1)|(1,3,0)) = ((2,2,1)|(0,3,0))+((1,2,1)|(0,3,0))*AB(1)
        ! (1,2,1|1,2,1): 27
        theta(503) = dot_product(vrrbuffer(:,8), D(:,113)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,113)) ! ((2,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,113)) ! ((1,3,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,113)) ! ((1,2,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,113)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,113)) ! ((2,2,2)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,113)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,113)) ! ((1,3,2)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,113)) ! ((2,4,1)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,113)) ! ((2,3,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,113)) ! ((1,4,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,113)) ! ((2,4,2)|(0,0,0))
        theta(663) = theta(522)+theta(503)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(885) = theta(619)+theta(577)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(986) = theta(720)+theta(663)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1232) = theta(885)+theta(786)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1402) = theta(1106)+theta(986)*AB(3) ! ((1,2,1)|(0,2,1)) = ((1,2,2)|(0,2,0))+((1,2,1)|(0,2,0))*AB(3)
        theta(1552) = theta(1232)+theta(1076)*AB(3) ! ((2,2,1)|(0,2,1)) = ((2,2,2)|(0,2,0))+((2,2,1)|(0,2,0))*AB(3)
        theta(1797) = theta(1552)+theta(1402)*AB(1) ! ((1,2,1)|(1,2,1)) = ((2,2,1)|(0,2,1))+((1,2,1)|(0,2,1))*AB(1)
        ! (1,2,1|1,1,2): 27
        theta(503) = dot_product(vrrbuffer(:,8), D(:,114)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,114)) ! ((2,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,114)) ! ((1,3,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,114)) ! ((1,2,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,114)) ! ((2,3,1)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,114)) ! ((2,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,114)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,114)) ! ((1,2,3)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,114)) ! ((2,3,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,114)) ! ((2,2,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,114)) ! ((1,3,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,114)) ! ((2,3,3)|(0,0,0))
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(886) = theta(620)+theta(577)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(988) = theta(724)+theta(664)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1228) = theta(886)+theta(784)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1403) = theta(1102)+theta(988)*AB(2) ! ((1,2,1)|(0,1,2)) = ((1,3,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(2)
        theta(1553) = theta(1228)+theta(1078)*AB(2) ! ((2,2,1)|(0,1,2)) = ((2,3,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(2)
        theta(1798) = theta(1553)+theta(1403)*AB(1) ! ((1,2,1)|(1,1,2)) = ((2,2,1)|(0,1,2))+((1,2,1)|(0,1,2))*AB(1)
        ! (1,2,1|1,0,3): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,115)) ! ((1,2,1)|(0,0,0))
        theta(518) = dot_product(vrrbuffer(:,23), D(:,115)) ! ((2,2,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,115)) ! ((1,2,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,115)) ! ((2,2,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,115)) ! ((1,2,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,115)) ! ((2,2,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,115)) ! ((1,2,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,115)) ! ((2,2,4)|(0,0,0))
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(988) = theta(724)+theta(664)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1234) = theta(889)+theta(787)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1404) = theta(1108)+theta(988)*AB(3) ! ((1,2,1)|(0,0,3)) = ((1,2,2)|(0,0,2))+((1,2,1)|(0,0,2))*AB(3)
        theta(1554) = theta(1234)+theta(1078)*AB(3) ! ((2,2,1)|(0,0,3)) = ((2,2,2)|(0,0,2))+((2,2,1)|(0,0,2))*AB(3)
        theta(1799) = theta(1554)+theta(1404)*AB(1) ! ((1,2,1)|(1,0,3)) = ((2,2,1)|(0,0,3))+((1,2,1)|(0,0,3))*AB(1)
        ! (1,2,1|0,4,0): 15
        theta(503) = dot_product(vrrbuffer(:,8), D(:,116)) ! ((1,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,116)) ! ((1,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,116)) ! ((1,4,1)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,116)) ! ((1,5,1)|(0,0,0))
        theta(625) = dot_product(vrrbuffer(:,130), D(:,116)) ! ((1,6,1)|(0,0,0))
        theta(663) = theta(522)+theta(503)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(900) = theta(625)+theta(582)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(986) = theta(720)+theta(663)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1256) = theta(900)+theta(798)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        theta(1401) = theta(1100)+theta(986)*AB(2) ! ((1,2,1)|(0,3,0)) = ((1,3,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(2)
        theta(1591) = theta(1256)+theta(1100)*AB(2) ! ((1,3,1)|(0,3,0)) = ((1,4,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(2)
        theta(1800) = theta(1591)+theta(1401)*AB(2) ! ((1,2,1)|(0,4,0)) = ((1,3,1)|(0,3,0))+((1,2,1)|(0,3,0))*AB(2)
        ! (1,2,1|0,3,1): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,117)) ! ((1,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,117)) ! ((1,3,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,117)) ! ((1,2,2)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,117)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,117)) ! ((1,3,2)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,117)) ! ((1,5,1)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,117)) ! ((1,4,2)|(0,0,0))
        theta(626) = dot_product(vrrbuffer(:,131), D(:,117)) ! ((1,5,2)|(0,0,0))
        theta(663) = theta(522)+theta(503)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(903) = theta(626)+theta(583)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(986) = theta(720)+theta(663)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1262) = theta(903)+theta(801)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        theta(1401) = theta(1100)+theta(986)*AB(2) ! ((1,2,1)|(0,3,0)) = ((1,3,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(2)
        theta(1601) = theta(1262)+theta(1106)*AB(2) ! ((1,2,2)|(0,3,0)) = ((1,3,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(2)
        theta(1801) = theta(1601)+theta(1401)*AB(3) ! ((1,2,1)|(0,3,1)) = ((1,2,2)|(0,3,0))+((1,2,1)|(0,3,0))*AB(3)
        ! (1,2,1|0,2,2): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,118)) ! ((1,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,118)) ! ((1,3,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,118)) ! ((1,2,2)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,118)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,118)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,118)) ! ((1,2,3)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,118)) ! ((1,4,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,118)) ! ((1,3,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,118)) ! ((1,4,3)|(0,0,0))
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(904) = theta(627)+theta(583)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        theta(988) = theta(724)+theta(664)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1258) = theta(904)+theta(799)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(1403) = theta(1102)+theta(988)*AB(2) ! ((1,2,1)|(0,1,2)) = ((1,3,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(2)
        theta(1593) = theta(1258)+theta(1102)*AB(2) ! ((1,3,1)|(0,1,2)) = ((1,4,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(2)
        theta(1802) = theta(1593)+theta(1403)*AB(2) ! ((1,2,1)|(0,2,2)) = ((1,3,1)|(0,1,2))+((1,2,1)|(0,1,2))*AB(2)
        ! (1,2,1|0,1,3): 21
        theta(503) = dot_product(vrrbuffer(:,8), D(:,119)) ! ((1,2,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,119)) ! ((1,3,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,119)) ! ((1,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,119)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,119)) ! ((1,2,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,119)) ! ((1,3,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,119)) ! ((1,2,4)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,119)) ! ((1,3,4)|(0,0,0))
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(907) = theta(628)+theta(584)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(988) = theta(724)+theta(664)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1264) = theta(907)+theta(802)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1404) = theta(1108)+theta(988)*AB(3) ! ((1,2,1)|(0,0,3)) = ((1,2,2)|(0,0,2))+((1,2,1)|(0,0,2))*AB(3)
        theta(1594) = theta(1264)+theta(1102)*AB(3) ! ((1,3,1)|(0,0,3)) = ((1,3,2)|(0,0,2))+((1,3,1)|(0,0,2))*AB(3)
        theta(1803) = theta(1594)+theta(1404)*AB(2) ! ((1,2,1)|(0,1,3)) = ((1,3,1)|(0,0,3))+((1,2,1)|(0,0,3))*AB(2)
        ! (1,2,1|0,0,4): 15
        theta(503) = dot_product(vrrbuffer(:,8), D(:,120)) ! ((1,2,1)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,120)) ! ((1,2,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,120)) ! ((1,2,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,120)) ! ((1,2,4)|(0,0,0))
        theta(629) = dot_product(vrrbuffer(:,134), D(:,120)) ! ((1,2,5)|(0,0,0))
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(910) = theta(629)+theta(585)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(988) = theta(724)+theta(664)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1270) = theta(910)+theta(805)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1404) = theta(1108)+theta(988)*AB(3) ! ((1,2,1)|(0,0,3)) = ((1,2,2)|(0,0,2))+((1,2,1)|(0,0,2))*AB(3)
        theta(1604) = theta(1270)+theta(1108)*AB(3) ! ((1,2,2)|(0,0,3)) = ((1,2,3)|(0,0,2))+((1,2,2)|(0,0,2))*AB(3)
        theta(1804) = theta(1604)+theta(1404)*AB(3) ! ((1,2,1)|(0,0,4)) = ((1,2,2)|(0,0,3))+((1,2,1)|(0,0,3))*AB(3)
        ! (1,1,2|4,0,0): 15
        theta(504) = dot_product(vrrbuffer(:,9), D(:,121)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,121)) ! ((2,1,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,121)) ! ((3,1,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,121)) ! ((4,1,2)|(0,0,0))
        theta(604) = dot_product(vrrbuffer(:,109), D(:,121)) ! ((5,1,2)|(0,0,0))
        theta(665) = theta(519)+theta(504)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(710) = theta(540)+theta(519)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(773) = theta(568)+theta(540)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(857) = theta(604)+theta(568)*AB(1) ! ((4,1,2)|(1,0,0)) = ((5,1,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(1)
        theta(989) = theta(710)+theta(665)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(1079) = theta(773)+theta(710)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(1205) = theta(857)+theta(773)*AB(1) ! ((3,1,2)|(2,0,0)) = ((4,1,2)|(1,0,0))+((3,1,2)|(1,0,0))*AB(1)
        theta(1405) = theta(1079)+theta(989)*AB(1) ! ((1,1,2)|(3,0,0)) = ((2,1,2)|(2,0,0))+((1,1,2)|(2,0,0))*AB(1)
        theta(1555) = theta(1205)+theta(1079)*AB(1) ! ((2,1,2)|(3,0,0)) = ((3,1,2)|(2,0,0))+((2,1,2)|(2,0,0))*AB(1)
        theta(1805) = theta(1555)+theta(1405)*AB(1) ! ((1,1,2)|(4,0,0)) = ((2,1,2)|(3,0,0))+((1,1,2)|(3,0,0))*AB(1)
        ! (1,1,2|3,1,0): 18
        theta(504) = dot_product(vrrbuffer(:,9), D(:,122)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,122)) ! ((2,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,122)) ! ((1,2,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,122)) ! ((3,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,122)) ! ((2,2,2)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,122)) ! ((4,1,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,122)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,122)) ! ((4,2,2)|(0,0,0))
        theta(666) = theta(523)+theta(504)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(858) = theta(608)+theta(568)*AB(2) ! ((4,1,2)|(0,1,0)) = ((4,2,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(2)
        theta(990) = theta(711)+theta(666)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        theta(1080) = theta(774)+theta(711)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        theta(1206) = theta(858)+theta(774)*AB(1) ! ((3,1,2)|(1,1,0)) = ((4,1,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(1)
        theta(1406) = theta(1080)+theta(990)*AB(1) ! ((1,1,2)|(2,1,0)) = ((2,1,2)|(1,1,0))+((1,1,2)|(1,1,0))*AB(1)
        theta(1556) = theta(1206)+theta(1080)*AB(1) ! ((2,1,2)|(2,1,0)) = ((3,1,2)|(1,1,0))+((2,1,2)|(1,1,0))*AB(1)
        theta(1806) = theta(1556)+theta(1406)*AB(1) ! ((1,1,2)|(3,1,0)) = ((2,1,2)|(2,1,0))+((1,1,2)|(2,1,0))*AB(1)
        ! (1,1,2|3,0,1): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,123)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,123)) ! ((2,1,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,123)) ! ((1,1,3)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,123)) ! ((3,1,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,123)) ! ((2,1,3)|(0,0,0))
        theta(568) = dot_product(vrrbuffer(:,73), D(:,123)) ! ((4,1,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,123)) ! ((3,1,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,123)) ! ((4,1,3)|(0,0,0))
        theta(665) = theta(519)+theta(504)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(710) = theta(540)+theta(519)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(725) = theta(545)+theta(524)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(773) = theta(568)+theta(540)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(788) = theta(573)+theta(545)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(872) = theta(609)+theta(573)*AB(1) ! ((3,1,3)|(1,0,0)) = ((4,1,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(1)
        theta(989) = theta(710)+theta(665)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(1079) = theta(773)+theta(710)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(1109) = theta(788)+theta(725)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(1235) = theta(872)+theta(788)*AB(1) ! ((2,1,3)|(2,0,0)) = ((3,1,3)|(1,0,0))+((2,1,3)|(1,0,0))*AB(1)
        theta(1405) = theta(1079)+theta(989)*AB(1) ! ((1,1,2)|(3,0,0)) = ((2,1,2)|(2,0,0))+((1,1,2)|(2,0,0))*AB(1)
        theta(1605) = theta(1235)+theta(1109)*AB(1) ! ((1,1,3)|(3,0,0)) = ((2,1,3)|(2,0,0))+((1,1,3)|(2,0,0))*AB(1)
        theta(1807) = theta(1605)+theta(1405)*AB(3) ! ((1,1,2)|(3,0,1)) = ((1,1,3)|(3,0,0))+((1,1,2)|(3,0,0))*AB(3)
        ! (1,1,2|2,2,0): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,124)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,124)) ! ((2,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,124)) ! ((1,2,2)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,124)) ! ((3,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,124)) ! ((2,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,124)) ! ((1,3,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,124)) ! ((3,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,124)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,124)) ! ((3,3,2)|(0,0,0))
        theta(666) = theta(523)+theta(504)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(870) = theta(613)+theta(572)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(992) = theta(723)+theta(666)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1208) = theta(870)+theta(774)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1408) = theta(1082)+theta(992)*AB(1) ! ((1,1,2)|(1,2,0)) = ((2,1,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(1)
        theta(1558) = theta(1208)+theta(1082)*AB(1) ! ((2,1,2)|(1,2,0)) = ((3,1,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(1)
        theta(1808) = theta(1558)+theta(1408)*AB(1) ! ((1,1,2)|(2,2,0)) = ((2,1,2)|(1,2,0))+((1,1,2)|(1,2,0))*AB(1)
        ! (1,1,2|2,1,1): 24
        theta(504) = dot_product(vrrbuffer(:,9), D(:,125)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,125)) ! ((2,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,125)) ! ((1,2,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,125)) ! ((1,1,3)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,125)) ! ((3,1,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,125)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,125)) ! ((2,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,125)) ! ((1,2,3)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,125)) ! ((3,2,2)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,125)) ! ((3,1,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,125)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,125)) ! ((3,2,3)|(0,0,0))
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(871) = theta(614)+theta(572)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(993) = theta(724)+theta(667)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        theta(1083) = theta(787)+theta(712)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(1209) = theta(871)+theta(775)*AB(2) ! ((3,1,2)|(0,1,1)) = ((3,2,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(2)
        theta(1409) = theta(1083)+theta(993)*AB(1) ! ((1,1,2)|(1,1,1)) = ((2,1,2)|(0,1,1))+((1,1,2)|(0,1,1))*AB(1)
        theta(1559) = theta(1209)+theta(1083)*AB(1) ! ((2,1,2)|(1,1,1)) = ((3,1,2)|(0,1,1))+((2,1,2)|(0,1,1))*AB(1)
        theta(1809) = theta(1559)+theta(1409)*AB(1) ! ((1,1,2)|(2,1,1)) = ((2,1,2)|(1,1,1))+((1,1,2)|(1,1,1))*AB(1)
        ! (1,1,2|2,0,2): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,126)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,126)) ! ((2,1,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,126)) ! ((1,1,3)|(0,0,0))
        theta(540) = dot_product(vrrbuffer(:,45), D(:,126)) ! ((3,1,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,126)) ! ((2,1,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,126)) ! ((1,1,4)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,126)) ! ((3,1,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,126)) ! ((2,1,4)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,126)) ! ((3,1,4)|(0,0,0))
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(874) = theta(615)+theta(573)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(994) = theta(727)+theta(667)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1210) = theta(874)+theta(775)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1410) = theta(1084)+theta(994)*AB(1) ! ((1,1,2)|(1,0,2)) = ((2,1,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(1)
        theta(1560) = theta(1210)+theta(1084)*AB(1) ! ((2,1,2)|(1,0,2)) = ((3,1,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(1)
        theta(1810) = theta(1560)+theta(1410)*AB(1) ! ((1,1,2)|(2,0,2)) = ((2,1,2)|(1,0,2))+((1,1,2)|(1,0,2))*AB(1)
        ! (1,1,2|1,3,0): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,127)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,127)) ! ((2,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,127)) ! ((1,2,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,127)) ! ((2,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,127)) ! ((1,3,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,127)) ! ((2,3,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,127)) ! ((1,4,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,127)) ! ((2,4,2)|(0,0,0))
        theta(666) = theta(523)+theta(504)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(885) = theta(619)+theta(577)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(992) = theta(723)+theta(666)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1232) = theta(885)+theta(786)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1411) = theta(1106)+theta(992)*AB(2) ! ((1,1,2)|(0,3,0)) = ((1,2,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(2)
        theta(1561) = theta(1232)+theta(1082)*AB(2) ! ((2,1,2)|(0,3,0)) = ((2,2,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(2)
        theta(1811) = theta(1561)+theta(1411)*AB(1) ! ((1,1,2)|(1,3,0)) = ((2,1,2)|(0,3,0))+((1,1,2)|(0,3,0))*AB(1)
        ! (1,1,2|1,2,1): 27
        theta(504) = dot_product(vrrbuffer(:,9), D(:,128)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,128)) ! ((2,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,128)) ! ((1,2,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,128)) ! ((1,1,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,128)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,128)) ! ((2,1,3)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,128)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,128)) ! ((1,2,3)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,128)) ! ((2,3,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,128)) ! ((2,2,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,128)) ! ((1,3,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,128)) ! ((2,3,3)|(0,0,0))
        theta(666) = theta(523)+theta(504)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(888) = theta(620)+theta(578)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(992) = theta(723)+theta(666)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1238) = theta(888)+theta(789)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(1412) = theta(1112)+theta(992)*AB(3) ! ((1,1,2)|(0,2,1)) = ((1,1,3)|(0,2,0))+((1,1,2)|(0,2,0))*AB(3)
        theta(1562) = theta(1238)+theta(1082)*AB(3) ! ((2,1,2)|(0,2,1)) = ((2,1,3)|(0,2,0))+((2,1,2)|(0,2,0))*AB(3)
        theta(1812) = theta(1562)+theta(1412)*AB(1) ! ((1,1,2)|(1,2,1)) = ((2,1,2)|(0,2,1))+((1,1,2)|(0,2,1))*AB(1)
        ! (1,1,2|1,1,2): 27
        theta(504) = dot_product(vrrbuffer(:,9), D(:,129)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,129)) ! ((2,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,129)) ! ((1,2,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,129)) ! ((1,1,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,129)) ! ((2,2,2)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,129)) ! ((2,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,129)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,129)) ! ((1,1,4)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,129)) ! ((2,2,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,129)) ! ((2,1,4)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,129)) ! ((1,2,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,129)) ! ((2,2,4)|(0,0,0))
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(994) = theta(727)+theta(667)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1234) = theta(889)+theta(787)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1413) = theta(1108)+theta(994)*AB(2) ! ((1,1,2)|(0,1,2)) = ((1,2,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(2)
        theta(1563) = theta(1234)+theta(1084)*AB(2) ! ((2,1,2)|(0,1,2)) = ((2,2,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(2)
        theta(1813) = theta(1563)+theta(1413)*AB(1) ! ((1,1,2)|(1,1,2)) = ((2,1,2)|(0,1,2))+((1,1,2)|(0,1,2))*AB(1)
        ! (1,1,2|1,0,3): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,130)) ! ((1,1,2)|(0,0,0))
        theta(519) = dot_product(vrrbuffer(:,24), D(:,130)) ! ((2,1,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,130)) ! ((1,1,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,130)) ! ((2,1,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,130)) ! ((1,1,4)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,130)) ! ((2,1,4)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,130)) ! ((1,1,5)|(0,0,0))
        theta(622) = dot_product(vrrbuffer(:,127), D(:,130)) ! ((2,1,5)|(0,0,0))
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(892) = theta(622)+theta(579)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(994) = theta(727)+theta(667)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1240) = theta(892)+theta(790)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1414) = theta(1114)+theta(994)*AB(3) ! ((1,1,2)|(0,0,3)) = ((1,1,3)|(0,0,2))+((1,1,2)|(0,0,2))*AB(3)
        theta(1564) = theta(1240)+theta(1084)*AB(3) ! ((2,1,2)|(0,0,3)) = ((2,1,3)|(0,0,2))+((2,1,2)|(0,0,2))*AB(3)
        theta(1814) = theta(1564)+theta(1414)*AB(1) ! ((1,1,2)|(1,0,3)) = ((2,1,2)|(0,0,3))+((1,1,2)|(0,0,3))*AB(1)
        ! (1,1,2|0,4,0): 15
        theta(504) = dot_product(vrrbuffer(:,9), D(:,131)) ! ((1,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,131)) ! ((1,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,131)) ! ((1,3,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,131)) ! ((1,4,2)|(0,0,0))
        theta(626) = dot_product(vrrbuffer(:,131), D(:,131)) ! ((1,5,2)|(0,0,0))
        theta(666) = theta(523)+theta(504)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(903) = theta(626)+theta(583)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(992) = theta(723)+theta(666)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1262) = theta(903)+theta(801)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        theta(1411) = theta(1106)+theta(992)*AB(2) ! ((1,1,2)|(0,3,0)) = ((1,2,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(2)
        theta(1601) = theta(1262)+theta(1106)*AB(2) ! ((1,2,2)|(0,3,0)) = ((1,3,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(2)
        theta(1815) = theta(1601)+theta(1411)*AB(2) ! ((1,1,2)|(0,4,0)) = ((1,2,2)|(0,3,0))+((1,1,2)|(0,3,0))*AB(2)
        ! (1,1,2|0,3,1): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,132)) ! ((1,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,132)) ! ((1,2,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,132)) ! ((1,1,3)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,132)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,132)) ! ((1,2,3)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,132)) ! ((1,4,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,132)) ! ((1,3,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,132)) ! ((1,4,3)|(0,0,0))
        theta(666) = theta(523)+theta(504)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(906) = theta(627)+theta(584)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(992) = theta(723)+theta(666)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1268) = theta(906)+theta(804)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        theta(1411) = theta(1106)+theta(992)*AB(2) ! ((1,1,2)|(0,3,0)) = ((1,2,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(2)
        theta(1611) = theta(1268)+theta(1112)*AB(2) ! ((1,1,3)|(0,3,0)) = ((1,2,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(2)
        theta(1816) = theta(1611)+theta(1411)*AB(3) ! ((1,1,2)|(0,3,1)) = ((1,1,3)|(0,3,0))+((1,1,2)|(0,3,0))*AB(3)
        ! (1,1,2|0,2,2): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,133)) ! ((1,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,133)) ! ((1,2,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,133)) ! ((1,1,3)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,133)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,133)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,133)) ! ((1,1,4)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,133)) ! ((1,3,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,133)) ! ((1,2,4)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,133)) ! ((1,3,4)|(0,0,0))
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(907) = theta(628)+theta(584)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(994) = theta(727)+theta(667)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1264) = theta(907)+theta(802)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1413) = theta(1108)+theta(994)*AB(2) ! ((1,1,2)|(0,1,2)) = ((1,2,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(2)
        theta(1603) = theta(1264)+theta(1108)*AB(2) ! ((1,2,2)|(0,1,2)) = ((1,3,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(2)
        theta(1817) = theta(1603)+theta(1413)*AB(2) ! ((1,1,2)|(0,2,2)) = ((1,2,2)|(0,1,2))+((1,1,2)|(0,1,2))*AB(2)
        ! (1,1,2|0,1,3): 21
        theta(504) = dot_product(vrrbuffer(:,9), D(:,134)) ! ((1,1,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,134)) ! ((1,2,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,134)) ! ((1,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,134)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,134)) ! ((1,1,4)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,134)) ! ((1,2,4)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,134)) ! ((1,1,5)|(0,0,0))
        theta(629) = dot_product(vrrbuffer(:,134), D(:,134)) ! ((1,2,5)|(0,0,0))
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(910) = theta(629)+theta(585)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(994) = theta(727)+theta(667)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1270) = theta(910)+theta(805)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1414) = theta(1114)+theta(994)*AB(3) ! ((1,1,2)|(0,0,3)) = ((1,1,3)|(0,0,2))+((1,1,2)|(0,0,2))*AB(3)
        theta(1604) = theta(1270)+theta(1108)*AB(3) ! ((1,2,2)|(0,0,3)) = ((1,2,3)|(0,0,2))+((1,2,2)|(0,0,2))*AB(3)
        theta(1818) = theta(1604)+theta(1414)*AB(2) ! ((1,1,2)|(0,1,3)) = ((1,2,2)|(0,0,3))+((1,1,2)|(0,0,3))*AB(2)
        ! (1,1,2|0,0,4): 15
        theta(504) = dot_product(vrrbuffer(:,9), D(:,135)) ! ((1,1,2)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,135)) ! ((1,1,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,135)) ! ((1,1,4)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,135)) ! ((1,1,5)|(0,0,0))
        theta(630) = dot_product(vrrbuffer(:,135), D(:,135)) ! ((1,1,6)|(0,0,0))
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(913) = theta(630)+theta(586)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        theta(994) = theta(727)+theta(667)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1276) = theta(913)+theta(808)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(1414) = theta(1114)+theta(994)*AB(3) ! ((1,1,2)|(0,0,3)) = ((1,1,3)|(0,0,2))+((1,1,2)|(0,0,2))*AB(3)
        theta(1614) = theta(1276)+theta(1114)*AB(3) ! ((1,1,3)|(0,0,3)) = ((1,1,4)|(0,0,2))+((1,1,3)|(0,0,2))*AB(3)
        theta(1819) = theta(1614)+theta(1414)*AB(3) ! ((1,1,2)|(0,0,4)) = ((1,1,3)|(0,0,3))+((1,1,2)|(0,0,3))*AB(3)
        ! (1,0,3|4,0,0): 15
        theta(505) = dot_product(vrrbuffer(:,10), D(:,136)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,136)) ! ((2,0,3)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,136)) ! ((3,0,3)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,136)) ! ((4,0,3)|(0,0,0))
        theta(605) = dot_product(vrrbuffer(:,110), D(:,136)) ! ((5,0,3)|(0,0,0))
        theta(668) = theta(520)+theta(505)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(713) = theta(541)+theta(520)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(776) = theta(569)+theta(541)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(860) = theta(605)+theta(569)*AB(1) ! ((4,0,3)|(1,0,0)) = ((5,0,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(1)
        theta(995) = theta(713)+theta(668)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(1085) = theta(776)+theta(713)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(1211) = theta(860)+theta(776)*AB(1) ! ((3,0,3)|(2,0,0)) = ((4,0,3)|(1,0,0))+((3,0,3)|(1,0,0))*AB(1)
        theta(1415) = theta(1085)+theta(995)*AB(1) ! ((1,0,3)|(3,0,0)) = ((2,0,3)|(2,0,0))+((1,0,3)|(2,0,0))*AB(1)
        theta(1565) = theta(1211)+theta(1085)*AB(1) ! ((2,0,3)|(3,0,0)) = ((3,0,3)|(2,0,0))+((2,0,3)|(2,0,0))*AB(1)
        theta(1820) = theta(1565)+theta(1415)*AB(1) ! ((1,0,3)|(4,0,0)) = ((2,0,3)|(3,0,0))+((1,0,3)|(3,0,0))*AB(1)
        ! (1,0,3|3,1,0): 18
        theta(505) = dot_product(vrrbuffer(:,10), D(:,137)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,137)) ! ((2,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,137)) ! ((1,1,3)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,137)) ! ((3,0,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,137)) ! ((2,1,3)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,137)) ! ((4,0,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,137)) ! ((3,1,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,137)) ! ((4,1,3)|(0,0,0))
        theta(669) = theta(524)+theta(505)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(714) = theta(545)+theta(520)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(777) = theta(573)+theta(541)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(861) = theta(609)+theta(569)*AB(2) ! ((4,0,3)|(0,1,0)) = ((4,1,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(2)
        theta(996) = theta(714)+theta(669)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        theta(1086) = theta(777)+theta(714)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        theta(1212) = theta(861)+theta(777)*AB(1) ! ((3,0,3)|(1,1,0)) = ((4,0,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(1)
        theta(1416) = theta(1086)+theta(996)*AB(1) ! ((1,0,3)|(2,1,0)) = ((2,0,3)|(1,1,0))+((1,0,3)|(1,1,0))*AB(1)
        theta(1566) = theta(1212)+theta(1086)*AB(1) ! ((2,0,3)|(2,1,0)) = ((3,0,3)|(1,1,0))+((2,0,3)|(1,1,0))*AB(1)
        theta(1821) = theta(1566)+theta(1416)*AB(1) ! ((1,0,3)|(3,1,0)) = ((2,0,3)|(2,1,0))+((1,0,3)|(2,1,0))*AB(1)
        ! (1,0,3|3,0,1): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,138)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,138)) ! ((2,0,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,138)) ! ((1,0,4)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,138)) ! ((3,0,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,138)) ! ((2,0,4)|(0,0,0))
        theta(569) = dot_product(vrrbuffer(:,74), D(:,138)) ! ((4,0,3)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,138)) ! ((3,0,4)|(0,0,0))
        theta(610) = dot_product(vrrbuffer(:,115), D(:,138)) ! ((4,0,4)|(0,0,0))
        theta(668) = theta(520)+theta(505)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(713) = theta(541)+theta(520)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(728) = theta(546)+theta(525)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(776) = theta(569)+theta(541)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(791) = theta(574)+theta(546)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(875) = theta(610)+theta(574)*AB(1) ! ((3,0,4)|(1,0,0)) = ((4,0,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(1)
        theta(995) = theta(713)+theta(668)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(1085) = theta(776)+theta(713)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(1115) = theta(791)+theta(728)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(1241) = theta(875)+theta(791)*AB(1) ! ((2,0,4)|(2,0,0)) = ((3,0,4)|(1,0,0))+((2,0,4)|(1,0,0))*AB(1)
        theta(1415) = theta(1085)+theta(995)*AB(1) ! ((1,0,3)|(3,0,0)) = ((2,0,3)|(2,0,0))+((1,0,3)|(2,0,0))*AB(1)
        theta(1615) = theta(1241)+theta(1115)*AB(1) ! ((1,0,4)|(3,0,0)) = ((2,0,4)|(2,0,0))+((1,0,4)|(2,0,0))*AB(1)
        theta(1822) = theta(1615)+theta(1415)*AB(3) ! ((1,0,3)|(3,0,1)) = ((1,0,4)|(3,0,0))+((1,0,3)|(3,0,0))*AB(3)
        ! (1,0,3|2,2,0): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,139)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,139)) ! ((2,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,139)) ! ((1,1,3)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,139)) ! ((3,0,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,139)) ! ((2,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,139)) ! ((1,2,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,139)) ! ((3,1,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,139)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,139)) ! ((3,2,3)|(0,0,0))
        theta(669) = theta(524)+theta(505)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(714) = theta(545)+theta(520)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(777) = theta(573)+theta(541)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(873) = theta(614)+theta(573)*AB(2) ! ((3,1,3)|(0,1,0)) = ((3,2,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(2)
        theta(998) = theta(726)+theta(669)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(1088) = theta(789)+theta(714)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1214) = theta(873)+theta(777)*AB(2) ! ((3,0,3)|(0,2,0)) = ((3,1,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(2)
        theta(1418) = theta(1088)+theta(998)*AB(1) ! ((1,0,3)|(1,2,0)) = ((2,0,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(1)
        theta(1568) = theta(1214)+theta(1088)*AB(1) ! ((2,0,3)|(1,2,0)) = ((3,0,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(1)
        theta(1823) = theta(1568)+theta(1418)*AB(1) ! ((1,0,3)|(2,2,0)) = ((2,0,3)|(1,2,0))+((1,0,3)|(1,2,0))*AB(1)
        ! (1,0,3|2,1,1): 24
        theta(505) = dot_product(vrrbuffer(:,10), D(:,140)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,140)) ! ((2,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,140)) ! ((1,1,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,140)) ! ((1,0,4)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,140)) ! ((3,0,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,140)) ! ((2,1,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,140)) ! ((2,0,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,140)) ! ((1,1,4)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,140)) ! ((3,1,3)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,140)) ! ((3,0,4)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,140)) ! ((2,1,4)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,140)) ! ((3,1,4)|(0,0,0))
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(874) = theta(615)+theta(573)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(999) = theta(727)+theta(670)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        theta(1089) = theta(790)+theta(715)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(1215) = theta(874)+theta(778)*AB(2) ! ((3,0,3)|(0,1,1)) = ((3,1,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(2)
        theta(1419) = theta(1089)+theta(999)*AB(1) ! ((1,0,3)|(1,1,1)) = ((2,0,3)|(0,1,1))+((1,0,3)|(0,1,1))*AB(1)
        theta(1569) = theta(1215)+theta(1089)*AB(1) ! ((2,0,3)|(1,1,1)) = ((3,0,3)|(0,1,1))+((2,0,3)|(0,1,1))*AB(1)
        theta(1824) = theta(1569)+theta(1419)*AB(1) ! ((1,0,3)|(2,1,1)) = ((2,0,3)|(1,1,1))+((1,0,3)|(1,1,1))*AB(1)
        ! (1,0,3|2,0,2): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,141)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,141)) ! ((2,0,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,141)) ! ((1,0,4)|(0,0,0))
        theta(541) = dot_product(vrrbuffer(:,46), D(:,141)) ! ((3,0,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,141)) ! ((2,0,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,141)) ! ((1,0,5)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,141)) ! ((3,0,4)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,141)) ! ((2,0,5)|(0,0,0))
        theta(616) = dot_product(vrrbuffer(:,121), D(:,141)) ! ((3,0,5)|(0,0,0))
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(877) = theta(616)+theta(574)*AB(3) ! ((3,0,4)|(0,0,1)) = ((3,0,5)|(0,0,0))+((3,0,4)|(0,0,0))*AB(3)
        theta(1000) = theta(730)+theta(670)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(1090) = theta(793)+theta(715)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1216) = theta(877)+theta(778)*AB(3) ! ((3,0,3)|(0,0,2)) = ((3,0,4)|(0,0,1))+((3,0,3)|(0,0,1))*AB(3)
        theta(1420) = theta(1090)+theta(1000)*AB(1) ! ((1,0,3)|(1,0,2)) = ((2,0,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(1)
        theta(1570) = theta(1216)+theta(1090)*AB(1) ! ((2,0,3)|(1,0,2)) = ((3,0,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(1)
        theta(1825) = theta(1570)+theta(1420)*AB(1) ! ((1,0,3)|(2,0,2)) = ((2,0,3)|(1,0,2))+((1,0,3)|(1,0,2))*AB(1)
        ! (1,0,3|1,3,0): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,142)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,142)) ! ((2,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,142)) ! ((1,1,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,142)) ! ((2,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,142)) ! ((1,2,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,142)) ! ((2,2,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,142)) ! ((1,3,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,142)) ! ((2,3,3)|(0,0,0))
        theta(669) = theta(524)+theta(505)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(714) = theta(545)+theta(520)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(888) = theta(620)+theta(578)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(998) = theta(726)+theta(669)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(1088) = theta(789)+theta(714)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1238) = theta(888)+theta(789)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(1421) = theta(1112)+theta(998)*AB(2) ! ((1,0,3)|(0,3,0)) = ((1,1,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(2)
        theta(1571) = theta(1238)+theta(1088)*AB(2) ! ((2,0,3)|(0,3,0)) = ((2,1,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(2)
        theta(1826) = theta(1571)+theta(1421)*AB(1) ! ((1,0,3)|(1,3,0)) = ((2,0,3)|(0,3,0))+((1,0,3)|(0,3,0))*AB(1)
        ! (1,0,3|1,2,1): 27
        theta(505) = dot_product(vrrbuffer(:,10), D(:,143)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,143)) ! ((2,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,143)) ! ((1,1,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,143)) ! ((1,0,4)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,143)) ! ((2,1,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,143)) ! ((2,0,4)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,143)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,143)) ! ((1,1,4)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,143)) ! ((2,2,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,143)) ! ((2,1,4)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,143)) ! ((1,2,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,143)) ! ((2,2,4)|(0,0,0))
        theta(669) = theta(524)+theta(505)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(714) = theta(545)+theta(520)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(729) = theta(551)+theta(525)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(792) = theta(579)+theta(546)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(807) = theta(585)+theta(551)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(891) = theta(621)+theta(579)*AB(2) ! ((2,1,4)|(0,1,0)) = ((2,2,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(2)
        theta(998) = theta(726)+theta(669)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(1088) = theta(789)+theta(714)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1118) = theta(807)+theta(729)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1244) = theta(891)+theta(792)*AB(2) ! ((2,0,4)|(0,2,0)) = ((2,1,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(2)
        theta(1422) = theta(1118)+theta(998)*AB(3) ! ((1,0,3)|(0,2,1)) = ((1,0,4)|(0,2,0))+((1,0,3)|(0,2,0))*AB(3)
        theta(1572) = theta(1244)+theta(1088)*AB(3) ! ((2,0,3)|(0,2,1)) = ((2,0,4)|(0,2,0))+((2,0,3)|(0,2,0))*AB(3)
        theta(1827) = theta(1572)+theta(1422)*AB(1) ! ((1,0,3)|(1,2,1)) = ((2,0,3)|(0,2,1))+((1,0,3)|(0,2,1))*AB(1)
        ! (1,0,3|1,1,2): 27
        theta(505) = dot_product(vrrbuffer(:,10), D(:,144)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,144)) ! ((2,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,144)) ! ((1,1,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,144)) ! ((1,0,4)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,144)) ! ((2,1,3)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,144)) ! ((2,0,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,144)) ! ((1,1,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,144)) ! ((1,0,5)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,144)) ! ((2,1,4)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,144)) ! ((2,0,5)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,144)) ! ((1,1,5)|(0,0,0))
        theta(622) = dot_product(vrrbuffer(:,127), D(:,144)) ! ((2,1,5)|(0,0,0))
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(892) = theta(622)+theta(579)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(1000) = theta(730)+theta(670)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(1090) = theta(793)+theta(715)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1240) = theta(892)+theta(790)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1423) = theta(1114)+theta(1000)*AB(2) ! ((1,0,3)|(0,1,2)) = ((1,1,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(2)
        theta(1573) = theta(1240)+theta(1090)*AB(2) ! ((2,0,3)|(0,1,2)) = ((2,1,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(2)
        theta(1828) = theta(1573)+theta(1423)*AB(1) ! ((1,0,3)|(1,1,2)) = ((2,0,3)|(0,1,2))+((1,0,3)|(0,1,2))*AB(1)
        ! (1,0,3|1,0,3): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,145)) ! ((1,0,3)|(0,0,0))
        theta(520) = dot_product(vrrbuffer(:,25), D(:,145)) ! ((2,0,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,145)) ! ((1,0,4)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,145)) ! ((2,0,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,145)) ! ((1,0,5)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,145)) ! ((2,0,5)|(0,0,0))
        theta(587) = dot_product(vrrbuffer(:,92), D(:,145)) ! ((1,0,6)|(0,0,0))
        theta(623) = dot_product(vrrbuffer(:,128), D(:,145)) ! ((2,0,6)|(0,0,0))
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(811) = theta(587)+theta(552)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(895) = theta(623)+theta(580)*AB(3) ! ((2,0,5)|(0,0,1)) = ((2,0,6)|(0,0,0))+((2,0,5)|(0,0,0))*AB(3)
        theta(1000) = theta(730)+theta(670)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(1090) = theta(793)+theta(715)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1120) = theta(811)+theta(730)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1246) = theta(895)+theta(793)*AB(3) ! ((2,0,4)|(0,0,2)) = ((2,0,5)|(0,0,1))+((2,0,4)|(0,0,1))*AB(3)
        theta(1424) = theta(1120)+theta(1000)*AB(3) ! ((1,0,3)|(0,0,3)) = ((1,0,4)|(0,0,2))+((1,0,3)|(0,0,2))*AB(3)
        theta(1574) = theta(1246)+theta(1090)*AB(3) ! ((2,0,3)|(0,0,3)) = ((2,0,4)|(0,0,2))+((2,0,3)|(0,0,2))*AB(3)
        theta(1829) = theta(1574)+theta(1424)*AB(1) ! ((1,0,3)|(1,0,3)) = ((2,0,3)|(0,0,3))+((1,0,3)|(0,0,3))*AB(1)
        ! (1,0,3|0,4,0): 15
        theta(505) = dot_product(vrrbuffer(:,10), D(:,146)) ! ((1,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,146)) ! ((1,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,146)) ! ((1,2,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,146)) ! ((1,3,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,146)) ! ((1,4,3)|(0,0,0))
        theta(669) = theta(524)+theta(505)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(906) = theta(627)+theta(584)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(998) = theta(726)+theta(669)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1268) = theta(906)+theta(804)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        theta(1421) = theta(1112)+theta(998)*AB(2) ! ((1,0,3)|(0,3,0)) = ((1,1,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(2)
        theta(1611) = theta(1268)+theta(1112)*AB(2) ! ((1,1,3)|(0,3,0)) = ((1,2,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(2)
        theta(1830) = theta(1611)+theta(1421)*AB(2) ! ((1,0,3)|(0,4,0)) = ((1,1,3)|(0,3,0))+((1,0,3)|(0,3,0))*AB(2)
        ! (1,0,3|0,3,1): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,147)) ! ((1,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,147)) ! ((1,1,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,147)) ! ((1,0,4)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,147)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,147)) ! ((1,1,4)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,147)) ! ((1,3,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,147)) ! ((1,2,4)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,147)) ! ((1,3,4)|(0,0,0))
        theta(669) = theta(524)+theta(505)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(729) = theta(551)+theta(525)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(807) = theta(585)+theta(551)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(909) = theta(628)+theta(585)*AB(2) ! ((1,2,4)|(0,1,0)) = ((1,3,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(2)
        theta(998) = theta(726)+theta(669)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1118) = theta(807)+theta(729)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1274) = theta(909)+theta(807)*AB(2) ! ((1,1,4)|(0,2,0)) = ((1,2,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(2)
        theta(1421) = theta(1112)+theta(998)*AB(2) ! ((1,0,3)|(0,3,0)) = ((1,1,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(2)
        theta(1621) = theta(1274)+theta(1118)*AB(2) ! ((1,0,4)|(0,3,0)) = ((1,1,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(2)
        theta(1831) = theta(1621)+theta(1421)*AB(3) ! ((1,0,3)|(0,3,1)) = ((1,0,4)|(0,3,0))+((1,0,3)|(0,3,0))*AB(3)
        ! (1,0,3|0,2,2): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,148)) ! ((1,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,148)) ! ((1,1,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,148)) ! ((1,0,4)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,148)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,148)) ! ((1,1,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,148)) ! ((1,0,5)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,148)) ! ((1,2,4)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,148)) ! ((1,1,5)|(0,0,0))
        theta(629) = dot_product(vrrbuffer(:,134), D(:,148)) ! ((1,2,5)|(0,0,0))
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(910) = theta(629)+theta(585)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(1000) = theta(730)+theta(670)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1270) = theta(910)+theta(805)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1423) = theta(1114)+theta(1000)*AB(2) ! ((1,0,3)|(0,1,2)) = ((1,1,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(2)
        theta(1613) = theta(1270)+theta(1114)*AB(2) ! ((1,1,3)|(0,1,2)) = ((1,2,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(2)
        theta(1832) = theta(1613)+theta(1423)*AB(2) ! ((1,0,3)|(0,2,2)) = ((1,1,3)|(0,1,2))+((1,0,3)|(0,1,2))*AB(2)
        ! (1,0,3|0,1,3): 21
        theta(505) = dot_product(vrrbuffer(:,10), D(:,149)) ! ((1,0,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,149)) ! ((1,1,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,149)) ! ((1,0,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,149)) ! ((1,1,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,149)) ! ((1,0,5)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,149)) ! ((1,1,5)|(0,0,0))
        theta(587) = dot_product(vrrbuffer(:,92), D(:,149)) ! ((1,0,6)|(0,0,0))
        theta(630) = dot_product(vrrbuffer(:,135), D(:,149)) ! ((1,1,6)|(0,0,0))
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(811) = theta(587)+theta(552)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(913) = theta(630)+theta(586)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        theta(1000) = theta(730)+theta(670)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1120) = theta(811)+theta(730)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1276) = theta(913)+theta(808)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(1424) = theta(1120)+theta(1000)*AB(3) ! ((1,0,3)|(0,0,3)) = ((1,0,4)|(0,0,2))+((1,0,3)|(0,0,2))*AB(3)
        theta(1614) = theta(1276)+theta(1114)*AB(3) ! ((1,1,3)|(0,0,3)) = ((1,1,4)|(0,0,2))+((1,1,3)|(0,0,2))*AB(3)
        theta(1833) = theta(1614)+theta(1424)*AB(2) ! ((1,0,3)|(0,1,3)) = ((1,1,3)|(0,0,3))+((1,0,3)|(0,0,3))*AB(2)
        ! (1,0,3|0,0,4): 15
        theta(505) = dot_product(vrrbuffer(:,10), D(:,150)) ! ((1,0,3)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,150)) ! ((1,0,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,150)) ! ((1,0,5)|(0,0,0))
        theta(587) = dot_product(vrrbuffer(:,92), D(:,150)) ! ((1,0,6)|(0,0,0))
        theta(631) = dot_product(vrrbuffer(:,136), D(:,150)) ! ((1,0,7)|(0,0,0))
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(811) = theta(587)+theta(552)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(916) = theta(631)+theta(587)*AB(3) ! ((1,0,6)|(0,0,1)) = ((1,0,7)|(0,0,0))+((1,0,6)|(0,0,0))*AB(3)
        theta(1000) = theta(730)+theta(670)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(1120) = theta(811)+theta(730)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1282) = theta(916)+theta(811)*AB(3) ! ((1,0,5)|(0,0,2)) = ((1,0,6)|(0,0,1))+((1,0,5)|(0,0,1))*AB(3)
        theta(1424) = theta(1120)+theta(1000)*AB(3) ! ((1,0,3)|(0,0,3)) = ((1,0,4)|(0,0,2))+((1,0,3)|(0,0,2))*AB(3)
        theta(1624) = theta(1282)+theta(1120)*AB(3) ! ((1,0,4)|(0,0,3)) = ((1,0,5)|(0,0,2))+((1,0,4)|(0,0,2))*AB(3)
        theta(1834) = theta(1624)+theta(1424)*AB(3) ! ((1,0,3)|(0,0,4)) = ((1,0,4)|(0,0,3))+((1,0,3)|(0,0,3))*AB(3)
        ! (0,4,0|4,0,0): 15
        theta(506) = dot_product(vrrbuffer(:,11), D(:,151)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,151)) ! ((1,4,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,151)) ! ((2,4,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,151)) ! ((3,4,0)|(0,0,0))
        theta(606) = dot_product(vrrbuffer(:,111), D(:,151)) ! ((4,4,0)|(0,0,0))
        theta(671) = theta(521)+theta(506)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(716) = theta(542)+theta(521)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(779) = theta(570)+theta(542)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(863) = theta(606)+theta(570)*AB(1) ! ((3,4,0)|(1,0,0)) = ((4,4,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(1)
        theta(1001) = theta(716)+theta(671)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(1091) = theta(779)+theta(716)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(1217) = theta(863)+theta(779)*AB(1) ! ((2,4,0)|(2,0,0)) = ((3,4,0)|(1,0,0))+((2,4,0)|(1,0,0))*AB(1)
        theta(1425) = theta(1091)+theta(1001)*AB(1) ! ((0,4,0)|(3,0,0)) = ((1,4,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(1)
        theta(1575) = theta(1217)+theta(1091)*AB(1) ! ((1,4,0)|(3,0,0)) = ((2,4,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(1)
        theta(1835) = theta(1575)+theta(1425)*AB(1) ! ((0,4,0)|(4,0,0)) = ((1,4,0)|(3,0,0))+((0,4,0)|(3,0,0))*AB(1)
        ! (0,4,0|3,1,0): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,152)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,152)) ! ((1,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,152)) ! ((0,5,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,152)) ! ((2,4,0)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,152)) ! ((1,5,0)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,152)) ! ((3,4,0)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,152)) ! ((2,5,0)|(0,0,0))
        theta(611) = dot_product(vrrbuffer(:,116), D(:,152)) ! ((3,5,0)|(0,0,0))
        theta(671) = theta(521)+theta(506)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(716) = theta(542)+theta(521)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(731) = theta(547)+theta(526)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(779) = theta(570)+theta(542)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(794) = theta(575)+theta(547)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(878) = theta(611)+theta(575)*AB(1) ! ((2,5,0)|(1,0,0)) = ((3,5,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(1)
        theta(1001) = theta(716)+theta(671)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(1091) = theta(779)+theta(716)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(1121) = theta(794)+theta(731)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        theta(1247) = theta(878)+theta(794)*AB(1) ! ((1,5,0)|(2,0,0)) = ((2,5,0)|(1,0,0))+((1,5,0)|(1,0,0))*AB(1)
        theta(1425) = theta(1091)+theta(1001)*AB(1) ! ((0,4,0)|(3,0,0)) = ((1,4,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(1)
        theta(1625) = theta(1247)+theta(1121)*AB(1) ! ((0,5,0)|(3,0,0)) = ((1,5,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(1)
        theta(1836) = theta(1625)+theta(1425)*AB(2) ! ((0,4,0)|(3,1,0)) = ((0,5,0)|(3,0,0))+((0,4,0)|(3,0,0))*AB(2)
        ! (0,4,0|3,0,1): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,153)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,153)) ! ((1,4,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,153)) ! ((0,4,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,153)) ! ((2,4,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,153)) ! ((1,4,1)|(0,0,0))
        theta(570) = dot_product(vrrbuffer(:,75), D(:,153)) ! ((3,4,0)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,153)) ! ((2,4,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,153)) ! ((3,4,1)|(0,0,0))
        theta(671) = theta(521)+theta(506)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(716) = theta(542)+theta(521)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(734) = theta(548)+theta(527)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(779) = theta(570)+theta(542)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(797) = theta(576)+theta(548)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(881) = theta(612)+theta(576)*AB(1) ! ((2,4,1)|(1,0,0)) = ((3,4,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(1)
        theta(1001) = theta(716)+theta(671)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(1091) = theta(779)+theta(716)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(1127) = theta(797)+theta(734)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        theta(1253) = theta(881)+theta(797)*AB(1) ! ((1,4,1)|(2,0,0)) = ((2,4,1)|(1,0,0))+((1,4,1)|(1,0,0))*AB(1)
        theta(1425) = theta(1091)+theta(1001)*AB(1) ! ((0,4,0)|(3,0,0)) = ((1,4,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(1)
        theta(1635) = theta(1253)+theta(1127)*AB(1) ! ((0,4,1)|(3,0,0)) = ((1,4,1)|(2,0,0))+((0,4,1)|(2,0,0))*AB(1)
        theta(1837) = theta(1635)+theta(1425)*AB(3) ! ((0,4,0)|(3,0,1)) = ((0,4,1)|(3,0,0))+((0,4,0)|(3,0,0))*AB(3)
        ! (0,4,0|2,2,0): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,154)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,154)) ! ((1,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,154)) ! ((0,5,0)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,154)) ! ((2,4,0)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,154)) ! ((1,5,0)|(0,0,0))
        theta(553) = dot_product(vrrbuffer(:,58), D(:,154)) ! ((0,6,0)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,154)) ! ((2,5,0)|(0,0,0))
        theta(581) = dot_product(vrrbuffer(:,86), D(:,154)) ! ((1,6,0)|(0,0,0))
        theta(617) = dot_product(vrrbuffer(:,122), D(:,154)) ! ((2,6,0)|(0,0,0))
        theta(672) = theta(526)+theta(506)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(732) = theta(553)+theta(526)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(795) = theta(581)+theta(547)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(879) = theta(617)+theta(575)*AB(2) ! ((2,5,0)|(0,1,0)) = ((2,6,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(2)
        theta(1004) = theta(732)+theta(672)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(1094) = theta(795)+theta(717)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(1220) = theta(879)+theta(780)*AB(2) ! ((2,4,0)|(0,2,0)) = ((2,5,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(2)
        theta(1428) = theta(1094)+theta(1004)*AB(1) ! ((0,4,0)|(1,2,0)) = ((1,4,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(1)
        theta(1578) = theta(1220)+theta(1094)*AB(1) ! ((1,4,0)|(1,2,0)) = ((2,4,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(1)
        theta(1838) = theta(1578)+theta(1428)*AB(1) ! ((0,4,0)|(2,2,0)) = ((1,4,0)|(1,2,0))+((0,4,0)|(1,2,0))*AB(1)
        ! (0,4,0|2,1,1): 27
        theta(506) = dot_product(vrrbuffer(:,11), D(:,155)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,155)) ! ((1,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,155)) ! ((0,5,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,155)) ! ((0,4,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,155)) ! ((2,4,0)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,155)) ! ((1,5,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,155)) ! ((1,4,1)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,155)) ! ((0,5,1)|(0,0,0))
        theta(575) = dot_product(vrrbuffer(:,80), D(:,155)) ! ((2,5,0)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,155)) ! ((2,4,1)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,155)) ! ((1,5,1)|(0,0,0))
        theta(618) = dot_product(vrrbuffer(:,123), D(:,155)) ! ((2,5,1)|(0,0,0))
        theta(671) = theta(521)+theta(506)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(716) = theta(542)+theta(521)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(731) = theta(547)+theta(526)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(734) = theta(548)+theta(527)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(794) = theta(575)+theta(547)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(797) = theta(576)+theta(548)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(815) = theta(582)+theta(554)*AB(1) ! ((0,5,1)|(1,0,0)) = ((1,5,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(1)
        theta(899) = theta(618)+theta(582)*AB(1) ! ((1,5,1)|(1,0,0)) = ((2,5,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(1)
        theta(1001) = theta(716)+theta(671)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(1121) = theta(794)+theta(731)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        theta(1127) = theta(797)+theta(734)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        theta(1289) = theta(899)+theta(815)*AB(1) ! ((0,5,1)|(2,0,0)) = ((1,5,1)|(1,0,0))+((0,5,1)|(1,0,0))*AB(1)
        theta(1427) = theta(1127)+theta(1001)*AB(3) ! ((0,4,0)|(2,0,1)) = ((0,4,1)|(2,0,0))+((0,4,0)|(2,0,0))*AB(3)
        theta(1627) = theta(1289)+theta(1121)*AB(3) ! ((0,5,0)|(2,0,1)) = ((0,5,1)|(2,0,0))+((0,5,0)|(2,0,0))*AB(3)
        theta(1839) = theta(1627)+theta(1427)*AB(2) ! ((0,4,0)|(2,1,1)) = ((0,5,0)|(2,0,1))+((0,4,0)|(2,0,1))*AB(2)
        ! (0,4,0|2,0,2): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,156)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,156)) ! ((1,4,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,156)) ! ((0,4,1)|(0,0,0))
        theta(542) = dot_product(vrrbuffer(:,47), D(:,156)) ! ((2,4,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,156)) ! ((1,4,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,156)) ! ((0,4,2)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,156)) ! ((2,4,1)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,156)) ! ((1,4,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,156)) ! ((2,4,2)|(0,0,0))
        theta(673) = theta(527)+theta(506)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(718) = theta(548)+theta(521)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(781) = theta(576)+theta(542)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(883) = theta(619)+theta(576)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(1006) = theta(736)+theta(673)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(1096) = theta(799)+theta(718)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1222) = theta(883)+theta(781)*AB(3) ! ((2,4,0)|(0,0,2)) = ((2,4,1)|(0,0,1))+((2,4,0)|(0,0,1))*AB(3)
        theta(1430) = theta(1096)+theta(1006)*AB(1) ! ((0,4,0)|(1,0,2)) = ((1,4,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(1)
        theta(1580) = theta(1222)+theta(1096)*AB(1) ! ((1,4,0)|(1,0,2)) = ((2,4,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(1)
        theta(1840) = theta(1580)+theta(1430)*AB(1) ! ((0,4,0)|(2,0,2)) = ((1,4,0)|(1,0,2))+((0,4,0)|(1,0,2))*AB(1)
        ! (0,4,0|1,3,0): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,157)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,157)) ! ((1,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,157)) ! ((0,5,0)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,157)) ! ((1,5,0)|(0,0,0))
        theta(553) = dot_product(vrrbuffer(:,58), D(:,157)) ! ((0,6,0)|(0,0,0))
        theta(581) = dot_product(vrrbuffer(:,86), D(:,157)) ! ((1,6,0)|(0,0,0))
        theta(588) = dot_product(vrrbuffer(:,93), D(:,157)) ! ((0,7,0)|(0,0,0))
        theta(624) = dot_product(vrrbuffer(:,129), D(:,157)) ! ((1,7,0)|(0,0,0))
        theta(672) = theta(526)+theta(506)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(732) = theta(553)+theta(526)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(795) = theta(581)+theta(547)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(813) = theta(588)+theta(553)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(897) = theta(624)+theta(581)*AB(2) ! ((1,6,0)|(0,1,0)) = ((1,7,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(2)
        theta(1004) = theta(732)+theta(672)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(1094) = theta(795)+theta(717)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(1124) = theta(813)+theta(732)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        theta(1250) = theta(897)+theta(795)*AB(2) ! ((1,5,0)|(0,2,0)) = ((1,6,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(2)
        theta(1431) = theta(1124)+theta(1004)*AB(2) ! ((0,4,0)|(0,3,0)) = ((0,5,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(2)
        theta(1581) = theta(1250)+theta(1094)*AB(2) ! ((1,4,0)|(0,3,0)) = ((1,5,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(2)
        theta(1841) = theta(1581)+theta(1431)*AB(1) ! ((0,4,0)|(1,3,0)) = ((1,4,0)|(0,3,0))+((0,4,0)|(0,3,0))*AB(1)
        ! (0,4,0|1,2,1): 27
        theta(506) = dot_product(vrrbuffer(:,11), D(:,158)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,158)) ! ((1,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,158)) ! ((0,5,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,158)) ! ((0,4,1)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,158)) ! ((1,5,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,158)) ! ((1,4,1)|(0,0,0))
        theta(553) = dot_product(vrrbuffer(:,58), D(:,158)) ! ((0,6,0)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,158)) ! ((0,5,1)|(0,0,0))
        theta(581) = dot_product(vrrbuffer(:,86), D(:,158)) ! ((1,6,0)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,158)) ! ((1,5,1)|(0,0,0))
        theta(589) = dot_product(vrrbuffer(:,94), D(:,158)) ! ((0,6,1)|(0,0,0))
        theta(625) = dot_product(vrrbuffer(:,130), D(:,158)) ! ((1,6,1)|(0,0,0))
        theta(672) = theta(526)+theta(506)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(732) = theta(553)+theta(526)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(795) = theta(581)+theta(547)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(816) = theta(589)+theta(554)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(900) = theta(625)+theta(582)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(1004) = theta(732)+theta(672)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(1094) = theta(795)+theta(717)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(1130) = theta(816)+theta(735)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(1256) = theta(900)+theta(798)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        theta(1432) = theta(1130)+theta(1004)*AB(3) ! ((0,4,0)|(0,2,1)) = ((0,4,1)|(0,2,0))+((0,4,0)|(0,2,0))*AB(3)
        theta(1582) = theta(1256)+theta(1094)*AB(3) ! ((1,4,0)|(0,2,1)) = ((1,4,1)|(0,2,0))+((1,4,0)|(0,2,0))*AB(3)
        theta(1842) = theta(1582)+theta(1432)*AB(1) ! ((0,4,0)|(1,2,1)) = ((1,4,0)|(0,2,1))+((0,4,0)|(0,2,1))*AB(1)
        ! (0,4,0|1,1,2): 27
        theta(506) = dot_product(vrrbuffer(:,11), D(:,159)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,159)) ! ((1,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,159)) ! ((0,5,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,159)) ! ((0,4,1)|(0,0,0))
        theta(547) = dot_product(vrrbuffer(:,52), D(:,159)) ! ((1,5,0)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,159)) ! ((1,4,1)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,159)) ! ((0,5,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,159)) ! ((0,4,2)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,159)) ! ((1,5,1)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,159)) ! ((1,4,2)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,159)) ! ((0,5,2)|(0,0,0))
        theta(626) = dot_product(vrrbuffer(:,131), D(:,159)) ! ((1,5,2)|(0,0,0))
        theta(673) = theta(527)+theta(506)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(718) = theta(548)+theta(521)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(733) = theta(554)+theta(526)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(796) = theta(582)+theta(547)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(817) = theta(590)+theta(554)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(901) = theta(626)+theta(582)*AB(3) ! ((1,5,1)|(0,0,1)) = ((1,5,2)|(0,0,0))+((1,5,1)|(0,0,0))*AB(3)
        theta(1006) = theta(736)+theta(673)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(1096) = theta(799)+theta(718)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1126) = theta(817)+theta(733)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(1252) = theta(901)+theta(796)*AB(3) ! ((1,5,0)|(0,0,2)) = ((1,5,1)|(0,0,1))+((1,5,0)|(0,0,1))*AB(3)
        theta(1433) = theta(1126)+theta(1006)*AB(2) ! ((0,4,0)|(0,1,2)) = ((0,5,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(2)
        theta(1583) = theta(1252)+theta(1096)*AB(2) ! ((1,4,0)|(0,1,2)) = ((1,5,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(2)
        theta(1843) = theta(1583)+theta(1433)*AB(1) ! ((0,4,0)|(1,1,2)) = ((1,4,0)|(0,1,2))+((0,4,0)|(0,1,2))*AB(1)
        ! (0,4,0|1,0,3): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,160)) ! ((0,4,0)|(0,0,0))
        theta(521) = dot_product(vrrbuffer(:,26), D(:,160)) ! ((1,4,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,160)) ! ((0,4,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,160)) ! ((1,4,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,160)) ! ((0,4,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,160)) ! ((1,4,2)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,160)) ! ((0,4,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,160)) ! ((1,4,3)|(0,0,0))
        theta(673) = theta(527)+theta(506)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(718) = theta(548)+theta(521)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(904) = theta(627)+theta(583)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        theta(1006) = theta(736)+theta(673)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(1096) = theta(799)+theta(718)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1132) = theta(820)+theta(736)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1258) = theta(904)+theta(799)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(1434) = theta(1132)+theta(1006)*AB(3) ! ((0,4,0)|(0,0,3)) = ((0,4,1)|(0,0,2))+((0,4,0)|(0,0,2))*AB(3)
        theta(1584) = theta(1258)+theta(1096)*AB(3) ! ((1,4,0)|(0,0,3)) = ((1,4,1)|(0,0,2))+((1,4,0)|(0,0,2))*AB(3)
        theta(1844) = theta(1584)+theta(1434)*AB(1) ! ((0,4,0)|(1,0,3)) = ((1,4,0)|(0,0,3))+((0,4,0)|(0,0,3))*AB(1)
        ! (0,4,0|0,4,0): 15
        theta(506) = dot_product(vrrbuffer(:,11), D(:,161)) ! ((0,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,161)) ! ((0,5,0)|(0,0,0))
        theta(553) = dot_product(vrrbuffer(:,58), D(:,161)) ! ((0,6,0)|(0,0,0))
        theta(588) = dot_product(vrrbuffer(:,93), D(:,161)) ! ((0,7,0)|(0,0,0))
        theta(632) = dot_product(vrrbuffer(:,137), D(:,161)) ! ((0,8,0)|(0,0,0))
        theta(672) = theta(526)+theta(506)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(732) = theta(553)+theta(526)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(813) = theta(588)+theta(553)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(918) = theta(632)+theta(588)*AB(2) ! ((0,7,0)|(0,1,0)) = ((0,8,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(2)
        theta(1004) = theta(732)+theta(672)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(1124) = theta(813)+theta(732)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        theta(1286) = theta(918)+theta(813)*AB(2) ! ((0,6,0)|(0,2,0)) = ((0,7,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(2)
        theta(1431) = theta(1124)+theta(1004)*AB(2) ! ((0,4,0)|(0,3,0)) = ((0,5,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(2)
        theta(1631) = theta(1286)+theta(1124)*AB(2) ! ((0,5,0)|(0,3,0)) = ((0,6,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(2)
        theta(1845) = theta(1631)+theta(1431)*AB(2) ! ((0,4,0)|(0,4,0)) = ((0,5,0)|(0,3,0))+((0,4,0)|(0,3,0))*AB(2)
        ! (0,4,0|0,3,1): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,162)) ! ((0,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,162)) ! ((0,5,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,162)) ! ((0,4,1)|(0,0,0))
        theta(553) = dot_product(vrrbuffer(:,58), D(:,162)) ! ((0,6,0)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,162)) ! ((0,5,1)|(0,0,0))
        theta(588) = dot_product(vrrbuffer(:,93), D(:,162)) ! ((0,7,0)|(0,0,0))
        theta(589) = dot_product(vrrbuffer(:,94), D(:,162)) ! ((0,6,1)|(0,0,0))
        theta(633) = dot_product(vrrbuffer(:,138), D(:,162)) ! ((0,7,1)|(0,0,0))
        theta(672) = theta(526)+theta(506)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(732) = theta(553)+theta(526)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(813) = theta(588)+theta(553)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(816) = theta(589)+theta(554)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(921) = theta(633)+theta(589)*AB(2) ! ((0,6,1)|(0,1,0)) = ((0,7,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(2)
        theta(1004) = theta(732)+theta(672)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(1124) = theta(813)+theta(732)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        theta(1130) = theta(816)+theta(735)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(1292) = theta(921)+theta(816)*AB(2) ! ((0,5,1)|(0,2,0)) = ((0,6,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(2)
        theta(1431) = theta(1124)+theta(1004)*AB(2) ! ((0,4,0)|(0,3,0)) = ((0,5,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(2)
        theta(1641) = theta(1292)+theta(1130)*AB(2) ! ((0,4,1)|(0,3,0)) = ((0,5,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(2)
        theta(1846) = theta(1641)+theta(1431)*AB(3) ! ((0,4,0)|(0,3,1)) = ((0,4,1)|(0,3,0))+((0,4,0)|(0,3,0))*AB(3)
        ! (0,4,0|0,2,2): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,163)) ! ((0,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,163)) ! ((0,5,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,163)) ! ((0,4,1)|(0,0,0))
        theta(553) = dot_product(vrrbuffer(:,58), D(:,163)) ! ((0,6,0)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,163)) ! ((0,5,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,163)) ! ((0,4,2)|(0,0,0))
        theta(589) = dot_product(vrrbuffer(:,94), D(:,163)) ! ((0,6,1)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,163)) ! ((0,5,2)|(0,0,0))
        theta(634) = dot_product(vrrbuffer(:,139), D(:,163)) ! ((0,6,2)|(0,0,0))
        theta(673) = theta(527)+theta(506)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(733) = theta(554)+theta(526)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(814) = theta(589)+theta(553)*AB(3) ! ((0,6,0)|(0,0,1)) = ((0,6,1)|(0,0,0))+((0,6,0)|(0,0,0))*AB(3)
        theta(817) = theta(590)+theta(554)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(922) = theta(634)+theta(589)*AB(3) ! ((0,6,1)|(0,0,1)) = ((0,6,2)|(0,0,0))+((0,6,1)|(0,0,0))*AB(3)
        theta(1006) = theta(736)+theta(673)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(1126) = theta(817)+theta(733)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(1288) = theta(922)+theta(814)*AB(3) ! ((0,6,0)|(0,0,2)) = ((0,6,1)|(0,0,1))+((0,6,0)|(0,0,1))*AB(3)
        theta(1433) = theta(1126)+theta(1006)*AB(2) ! ((0,4,0)|(0,1,2)) = ((0,5,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(2)
        theta(1633) = theta(1288)+theta(1126)*AB(2) ! ((0,5,0)|(0,1,2)) = ((0,6,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(2)
        theta(1847) = theta(1633)+theta(1433)*AB(2) ! ((0,4,0)|(0,2,2)) = ((0,5,0)|(0,1,2))+((0,4,0)|(0,1,2))*AB(2)
        ! (0,4,0|0,1,3): 21
        theta(506) = dot_product(vrrbuffer(:,11), D(:,164)) ! ((0,4,0)|(0,0,0))
        theta(526) = dot_product(vrrbuffer(:,31), D(:,164)) ! ((0,5,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,164)) ! ((0,4,1)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,164)) ! ((0,5,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,164)) ! ((0,4,2)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,164)) ! ((0,5,2)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,164)) ! ((0,4,3)|(0,0,0))
        theta(635) = dot_product(vrrbuffer(:,140), D(:,164)) ! ((0,5,3)|(0,0,0))
        theta(673) = theta(527)+theta(506)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(733) = theta(554)+theta(526)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(817) = theta(590)+theta(554)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(925) = theta(635)+theta(590)*AB(3) ! ((0,5,2)|(0,0,1)) = ((0,5,3)|(0,0,0))+((0,5,2)|(0,0,0))*AB(3)
        theta(1006) = theta(736)+theta(673)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(1126) = theta(817)+theta(733)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(1132) = theta(820)+theta(736)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1294) = theta(925)+theta(817)*AB(3) ! ((0,5,1)|(0,0,2)) = ((0,5,2)|(0,0,1))+((0,5,1)|(0,0,1))*AB(3)
        theta(1434) = theta(1132)+theta(1006)*AB(3) ! ((0,4,0)|(0,0,3)) = ((0,4,1)|(0,0,2))+((0,4,0)|(0,0,2))*AB(3)
        theta(1634) = theta(1294)+theta(1126)*AB(3) ! ((0,5,0)|(0,0,3)) = ((0,5,1)|(0,0,2))+((0,5,0)|(0,0,2))*AB(3)
        theta(1848) = theta(1634)+theta(1434)*AB(2) ! ((0,4,0)|(0,1,3)) = ((0,5,0)|(0,0,3))+((0,4,0)|(0,0,3))*AB(2)
        ! (0,4,0|0,0,4): 15
        theta(506) = dot_product(vrrbuffer(:,11), D(:,165)) ! ((0,4,0)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,165)) ! ((0,4,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,165)) ! ((0,4,2)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,165)) ! ((0,4,3)|(0,0,0))
        theta(636) = dot_product(vrrbuffer(:,141), D(:,165)) ! ((0,4,4)|(0,0,0))
        theta(673) = theta(527)+theta(506)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(928) = theta(636)+theta(591)*AB(3) ! ((0,4,3)|(0,0,1)) = ((0,4,4)|(0,0,0))+((0,4,3)|(0,0,0))*AB(3)
        theta(1006) = theta(736)+theta(673)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(1132) = theta(820)+theta(736)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1300) = theta(928)+theta(820)*AB(3) ! ((0,4,2)|(0,0,2)) = ((0,4,3)|(0,0,1))+((0,4,2)|(0,0,1))*AB(3)
        theta(1434) = theta(1132)+theta(1006)*AB(3) ! ((0,4,0)|(0,0,3)) = ((0,4,1)|(0,0,2))+((0,4,0)|(0,0,2))*AB(3)
        theta(1644) = theta(1300)+theta(1132)*AB(3) ! ((0,4,1)|(0,0,3)) = ((0,4,2)|(0,0,2))+((0,4,1)|(0,0,2))*AB(3)
        theta(1849) = theta(1644)+theta(1434)*AB(3) ! ((0,4,0)|(0,0,4)) = ((0,4,1)|(0,0,3))+((0,4,0)|(0,0,3))*AB(3)
        ! (0,3,1|4,0,0): 15
        theta(507) = dot_product(vrrbuffer(:,12), D(:,166)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,166)) ! ((1,3,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,166)) ! ((2,3,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,166)) ! ((3,3,1)|(0,0,0))
        theta(607) = dot_product(vrrbuffer(:,112), D(:,166)) ! ((4,3,1)|(0,0,0))
        theta(674) = theta(522)+theta(507)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(719) = theta(543)+theta(522)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(782) = theta(571)+theta(543)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(866) = theta(607)+theta(571)*AB(1) ! ((3,3,1)|(1,0,0)) = ((4,3,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(1)
        theta(1007) = theta(719)+theta(674)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(1097) = theta(782)+theta(719)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(1223) = theta(866)+theta(782)*AB(1) ! ((2,3,1)|(2,0,0)) = ((3,3,1)|(1,0,0))+((2,3,1)|(1,0,0))*AB(1)
        theta(1435) = theta(1097)+theta(1007)*AB(1) ! ((0,3,1)|(3,0,0)) = ((1,3,1)|(2,0,0))+((0,3,1)|(2,0,0))*AB(1)
        theta(1585) = theta(1223)+theta(1097)*AB(1) ! ((1,3,1)|(3,0,0)) = ((2,3,1)|(2,0,0))+((1,3,1)|(2,0,0))*AB(1)
        theta(1850) = theta(1585)+theta(1435)*AB(1) ! ((0,3,1)|(4,0,0)) = ((1,3,1)|(3,0,0))+((0,3,1)|(3,0,0))*AB(1)
        ! (0,3,1|3,1,0): 18
        theta(507) = dot_product(vrrbuffer(:,12), D(:,167)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,167)) ! ((1,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,167)) ! ((0,4,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,167)) ! ((2,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,167)) ! ((1,4,1)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,167)) ! ((3,3,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,167)) ! ((2,4,1)|(0,0,0))
        theta(612) = dot_product(vrrbuffer(:,117), D(:,167)) ! ((3,4,1)|(0,0,0))
        theta(675) = theta(527)+theta(507)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(867) = theta(612)+theta(571)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(1008) = theta(720)+theta(675)*AB(1) ! ((0,3,1)|(1,1,0)) = ((1,3,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(1)
        theta(1098) = theta(783)+theta(720)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        theta(1224) = theta(867)+theta(783)*AB(1) ! ((2,3,1)|(1,1,0)) = ((3,3,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(1)
        theta(1436) = theta(1098)+theta(1008)*AB(1) ! ((0,3,1)|(2,1,0)) = ((1,3,1)|(1,1,0))+((0,3,1)|(1,1,0))*AB(1)
        theta(1586) = theta(1224)+theta(1098)*AB(1) ! ((1,3,1)|(2,1,0)) = ((2,3,1)|(1,1,0))+((1,3,1)|(1,1,0))*AB(1)
        theta(1851) = theta(1586)+theta(1436)*AB(1) ! ((0,3,1)|(3,1,0)) = ((1,3,1)|(2,1,0))+((0,3,1)|(2,1,0))*AB(1)
        ! (0,3,1|3,0,1): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,168)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,168)) ! ((1,3,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,168)) ! ((0,3,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,168)) ! ((2,3,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,168)) ! ((1,3,2)|(0,0,0))
        theta(571) = dot_product(vrrbuffer(:,76), D(:,168)) ! ((3,3,1)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,168)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,168)) ! ((3,3,2)|(0,0,0))
        theta(674) = theta(522)+theta(507)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(719) = theta(543)+theta(522)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(737) = theta(549)+theta(528)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(782) = theta(571)+theta(543)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(800) = theta(577)+theta(549)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(884) = theta(613)+theta(577)*AB(1) ! ((2,3,2)|(1,0,0)) = ((3,3,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(1)
        theta(1007) = theta(719)+theta(674)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(1097) = theta(782)+theta(719)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(1133) = theta(800)+theta(737)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        theta(1259) = theta(884)+theta(800)*AB(1) ! ((1,3,2)|(2,0,0)) = ((2,3,2)|(1,0,0))+((1,3,2)|(1,0,0))*AB(1)
        theta(1435) = theta(1097)+theta(1007)*AB(1) ! ((0,3,1)|(3,0,0)) = ((1,3,1)|(2,0,0))+((0,3,1)|(2,0,0))*AB(1)
        theta(1645) = theta(1259)+theta(1133)*AB(1) ! ((0,3,2)|(3,0,0)) = ((1,3,2)|(2,0,0))+((0,3,2)|(2,0,0))*AB(1)
        theta(1852) = theta(1645)+theta(1435)*AB(3) ! ((0,3,1)|(3,0,1)) = ((0,3,2)|(3,0,0))+((0,3,1)|(3,0,0))*AB(3)
        ! (0,3,1|2,2,0): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,169)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,169)) ! ((1,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,169)) ! ((0,4,1)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,169)) ! ((2,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,169)) ! ((1,4,1)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,169)) ! ((0,5,1)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,169)) ! ((2,4,1)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,169)) ! ((1,5,1)|(0,0,0))
        theta(618) = dot_product(vrrbuffer(:,123), D(:,169)) ! ((2,5,1)|(0,0,0))
        theta(675) = theta(527)+theta(507)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(882) = theta(618)+theta(576)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(1010) = theta(735)+theta(675)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1226) = theta(882)+theta(783)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1438) = theta(1100)+theta(1010)*AB(1) ! ((0,3,1)|(1,2,0)) = ((1,3,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(1)
        theta(1588) = theta(1226)+theta(1100)*AB(1) ! ((1,3,1)|(1,2,0)) = ((2,3,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(1)
        theta(1853) = theta(1588)+theta(1438)*AB(1) ! ((0,3,1)|(2,2,0)) = ((1,3,1)|(1,2,0))+((0,3,1)|(1,2,0))*AB(1)
        ! (0,3,1|2,1,1): 24
        theta(507) = dot_product(vrrbuffer(:,12), D(:,170)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,170)) ! ((1,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,170)) ! ((0,4,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,170)) ! ((0,3,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,170)) ! ((2,3,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,170)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,170)) ! ((1,3,2)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,170)) ! ((0,4,2)|(0,0,0))
        theta(576) = dot_product(vrrbuffer(:,81), D(:,170)) ! ((2,4,1)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,170)) ! ((2,3,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,170)) ! ((1,4,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,170)) ! ((2,4,2)|(0,0,0))
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(883) = theta(619)+theta(576)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(1011) = theta(736)+theta(676)*AB(2) ! ((0,3,1)|(0,1,1)) = ((0,4,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(2)
        theta(1101) = theta(799)+theta(721)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(1227) = theta(883)+theta(784)*AB(2) ! ((2,3,1)|(0,1,1)) = ((2,4,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(2)
        theta(1439) = theta(1101)+theta(1011)*AB(1) ! ((0,3,1)|(1,1,1)) = ((1,3,1)|(0,1,1))+((0,3,1)|(0,1,1))*AB(1)
        theta(1589) = theta(1227)+theta(1101)*AB(1) ! ((1,3,1)|(1,1,1)) = ((2,3,1)|(0,1,1))+((1,3,1)|(0,1,1))*AB(1)
        theta(1854) = theta(1589)+theta(1439)*AB(1) ! ((0,3,1)|(2,1,1)) = ((1,3,1)|(1,1,1))+((0,3,1)|(1,1,1))*AB(1)
        ! (0,3,1|2,0,2): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,171)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,171)) ! ((1,3,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,171)) ! ((0,3,2)|(0,0,0))
        theta(543) = dot_product(vrrbuffer(:,48), D(:,171)) ! ((2,3,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,171)) ! ((1,3,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,171)) ! ((0,3,3)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,171)) ! ((2,3,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,171)) ! ((1,3,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,171)) ! ((2,3,3)|(0,0,0))
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(886) = theta(620)+theta(577)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(1012) = theta(739)+theta(676)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1228) = theta(886)+theta(784)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1440) = theta(1102)+theta(1012)*AB(1) ! ((0,3,1)|(1,0,2)) = ((1,3,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(1)
        theta(1590) = theta(1228)+theta(1102)*AB(1) ! ((1,3,1)|(1,0,2)) = ((2,3,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(1)
        theta(1855) = theta(1590)+theta(1440)*AB(1) ! ((0,3,1)|(2,0,2)) = ((1,3,1)|(1,0,2))+((0,3,1)|(1,0,2))*AB(1)
        ! (0,3,1|1,3,0): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,172)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,172)) ! ((1,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,172)) ! ((0,4,1)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,172)) ! ((1,4,1)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,172)) ! ((0,5,1)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,172)) ! ((1,5,1)|(0,0,0))
        theta(589) = dot_product(vrrbuffer(:,94), D(:,172)) ! ((0,6,1)|(0,0,0))
        theta(625) = dot_product(vrrbuffer(:,130), D(:,172)) ! ((1,6,1)|(0,0,0))
        theta(675) = theta(527)+theta(507)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(816) = theta(589)+theta(554)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(900) = theta(625)+theta(582)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(1010) = theta(735)+theta(675)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1130) = theta(816)+theta(735)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(1256) = theta(900)+theta(798)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        theta(1441) = theta(1130)+theta(1010)*AB(2) ! ((0,3,1)|(0,3,0)) = ((0,4,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(2)
        theta(1591) = theta(1256)+theta(1100)*AB(2) ! ((1,3,1)|(0,3,0)) = ((1,4,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(2)
        theta(1856) = theta(1591)+theta(1441)*AB(1) ! ((0,3,1)|(1,3,0)) = ((1,3,1)|(0,3,0))+((0,3,1)|(0,3,0))*AB(1)
        ! (0,3,1|1,2,1): 27
        theta(507) = dot_product(vrrbuffer(:,12), D(:,173)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,173)) ! ((1,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,173)) ! ((0,4,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,173)) ! ((0,3,2)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,173)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,173)) ! ((1,3,2)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,173)) ! ((0,5,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,173)) ! ((0,4,2)|(0,0,0))
        theta(582) = dot_product(vrrbuffer(:,87), D(:,173)) ! ((1,5,1)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,173)) ! ((1,4,2)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,173)) ! ((0,5,2)|(0,0,0))
        theta(626) = dot_product(vrrbuffer(:,131), D(:,173)) ! ((1,5,2)|(0,0,0))
        theta(675) = theta(527)+theta(507)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(819) = theta(590)+theta(555)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(903) = theta(626)+theta(583)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(1010) = theta(735)+theta(675)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1136) = theta(819)+theta(738)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(1262) = theta(903)+theta(801)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        theta(1442) = theta(1136)+theta(1010)*AB(3) ! ((0,3,1)|(0,2,1)) = ((0,3,2)|(0,2,0))+((0,3,1)|(0,2,0))*AB(3)
        theta(1592) = theta(1262)+theta(1100)*AB(3) ! ((1,3,1)|(0,2,1)) = ((1,3,2)|(0,2,0))+((1,3,1)|(0,2,0))*AB(3)
        theta(1857) = theta(1592)+theta(1442)*AB(1) ! ((0,3,1)|(1,2,1)) = ((1,3,1)|(0,2,1))+((0,3,1)|(0,2,1))*AB(1)
        ! (0,3,1|1,1,2): 27
        theta(507) = dot_product(vrrbuffer(:,12), D(:,174)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,174)) ! ((1,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,174)) ! ((0,4,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,174)) ! ((0,3,2)|(0,0,0))
        theta(548) = dot_product(vrrbuffer(:,53), D(:,174)) ! ((1,4,1)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,174)) ! ((1,3,2)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,174)) ! ((0,4,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,174)) ! ((0,3,3)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,174)) ! ((1,4,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,174)) ! ((1,3,3)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,174)) ! ((0,4,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,174)) ! ((1,4,3)|(0,0,0))
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(904) = theta(627)+theta(583)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        theta(1012) = theta(739)+theta(676)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1132) = theta(820)+theta(736)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1258) = theta(904)+theta(799)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(1443) = theta(1132)+theta(1012)*AB(2) ! ((0,3,1)|(0,1,2)) = ((0,4,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(2)
        theta(1593) = theta(1258)+theta(1102)*AB(2) ! ((1,3,1)|(0,1,2)) = ((1,4,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(2)
        theta(1858) = theta(1593)+theta(1443)*AB(1) ! ((0,3,1)|(1,1,2)) = ((1,3,1)|(0,1,2))+((0,3,1)|(0,1,2))*AB(1)
        ! (0,3,1|1,0,3): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,175)) ! ((0,3,1)|(0,0,0))
        theta(522) = dot_product(vrrbuffer(:,27), D(:,175)) ! ((1,3,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,175)) ! ((0,3,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,175)) ! ((1,3,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,175)) ! ((0,3,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,175)) ! ((1,3,3)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,175)) ! ((0,3,4)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,175)) ! ((1,3,4)|(0,0,0))
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(907) = theta(628)+theta(584)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(1012) = theta(739)+theta(676)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1138) = theta(823)+theta(739)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1264) = theta(907)+theta(802)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1444) = theta(1138)+theta(1012)*AB(3) ! ((0,3,1)|(0,0,3)) = ((0,3,2)|(0,0,2))+((0,3,1)|(0,0,2))*AB(3)
        theta(1594) = theta(1264)+theta(1102)*AB(3) ! ((1,3,1)|(0,0,3)) = ((1,3,2)|(0,0,2))+((1,3,1)|(0,0,2))*AB(3)
        theta(1859) = theta(1594)+theta(1444)*AB(1) ! ((0,3,1)|(1,0,3)) = ((1,3,1)|(0,0,3))+((0,3,1)|(0,0,3))*AB(1)
        ! (0,3,1|0,4,0): 15
        theta(507) = dot_product(vrrbuffer(:,12), D(:,176)) ! ((0,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,176)) ! ((0,4,1)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,176)) ! ((0,5,1)|(0,0,0))
        theta(589) = dot_product(vrrbuffer(:,94), D(:,176)) ! ((0,6,1)|(0,0,0))
        theta(633) = dot_product(vrrbuffer(:,138), D(:,176)) ! ((0,7,1)|(0,0,0))
        theta(675) = theta(527)+theta(507)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(816) = theta(589)+theta(554)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(921) = theta(633)+theta(589)*AB(2) ! ((0,6,1)|(0,1,0)) = ((0,7,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(2)
        theta(1010) = theta(735)+theta(675)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(1130) = theta(816)+theta(735)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(1292) = theta(921)+theta(816)*AB(2) ! ((0,5,1)|(0,2,0)) = ((0,6,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(2)
        theta(1441) = theta(1130)+theta(1010)*AB(2) ! ((0,3,1)|(0,3,0)) = ((0,4,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(2)
        theta(1641) = theta(1292)+theta(1130)*AB(2) ! ((0,4,1)|(0,3,0)) = ((0,5,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(2)
        theta(1860) = theta(1641)+theta(1441)*AB(2) ! ((0,3,1)|(0,4,0)) = ((0,4,1)|(0,3,0))+((0,3,1)|(0,3,0))*AB(2)
        ! (0,3,1|0,3,1): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,177)) ! ((0,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,177)) ! ((0,4,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,177)) ! ((0,3,2)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,177)) ! ((0,5,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,177)) ! ((0,4,2)|(0,0,0))
        theta(589) = dot_product(vrrbuffer(:,94), D(:,177)) ! ((0,6,1)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,177)) ! ((0,5,2)|(0,0,0))
        theta(634) = dot_product(vrrbuffer(:,139), D(:,177)) ! ((0,6,2)|(0,0,0))
        theta(675) = theta(527)+theta(507)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(816) = theta(589)+theta(554)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(819) = theta(590)+theta(555)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(924) = theta(634)+theta(590)*AB(2) ! ((0,5,2)|(0,1,0)) = ((0,6,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(2)
        theta(1010) = theta(735)+theta(675)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(1130) = theta(816)+theta(735)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(1136) = theta(819)+theta(738)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(1298) = theta(924)+theta(819)*AB(2) ! ((0,4,2)|(0,2,0)) = ((0,5,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(2)
        theta(1441) = theta(1130)+theta(1010)*AB(2) ! ((0,3,1)|(0,3,0)) = ((0,4,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(2)
        theta(1651) = theta(1298)+theta(1136)*AB(2) ! ((0,3,2)|(0,3,0)) = ((0,4,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(2)
        theta(1861) = theta(1651)+theta(1441)*AB(3) ! ((0,3,1)|(0,3,1)) = ((0,3,2)|(0,3,0))+((0,3,1)|(0,3,0))*AB(3)
        ! (0,3,1|0,2,2): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,178)) ! ((0,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,178)) ! ((0,4,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,178)) ! ((0,3,2)|(0,0,0))
        theta(554) = dot_product(vrrbuffer(:,59), D(:,178)) ! ((0,5,1)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,178)) ! ((0,4,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,178)) ! ((0,3,3)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,178)) ! ((0,5,2)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,178)) ! ((0,4,3)|(0,0,0))
        theta(635) = dot_product(vrrbuffer(:,140), D(:,178)) ! ((0,5,3)|(0,0,0))
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(817) = theta(590)+theta(554)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(925) = theta(635)+theta(590)*AB(3) ! ((0,5,2)|(0,0,1)) = ((0,5,3)|(0,0,0))+((0,5,2)|(0,0,0))*AB(3)
        theta(1012) = theta(739)+theta(676)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(1132) = theta(820)+theta(736)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1294) = theta(925)+theta(817)*AB(3) ! ((0,5,1)|(0,0,2)) = ((0,5,2)|(0,0,1))+((0,5,1)|(0,0,1))*AB(3)
        theta(1443) = theta(1132)+theta(1012)*AB(2) ! ((0,3,1)|(0,1,2)) = ((0,4,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(2)
        theta(1643) = theta(1294)+theta(1132)*AB(2) ! ((0,4,1)|(0,1,2)) = ((0,5,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(2)
        theta(1862) = theta(1643)+theta(1443)*AB(2) ! ((0,3,1)|(0,2,2)) = ((0,4,1)|(0,1,2))+((0,3,1)|(0,1,2))*AB(2)
        ! (0,3,1|0,1,3): 21
        theta(507) = dot_product(vrrbuffer(:,12), D(:,179)) ! ((0,3,1)|(0,0,0))
        theta(527) = dot_product(vrrbuffer(:,32), D(:,179)) ! ((0,4,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,179)) ! ((0,3,2)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,179)) ! ((0,4,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,179)) ! ((0,3,3)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,179)) ! ((0,4,3)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,179)) ! ((0,3,4)|(0,0,0))
        theta(636) = dot_product(vrrbuffer(:,141), D(:,179)) ! ((0,4,4)|(0,0,0))
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(928) = theta(636)+theta(591)*AB(3) ! ((0,4,3)|(0,0,1)) = ((0,4,4)|(0,0,0))+((0,4,3)|(0,0,0))*AB(3)
        theta(1012) = theta(739)+theta(676)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(1132) = theta(820)+theta(736)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1138) = theta(823)+theta(739)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1300) = theta(928)+theta(820)*AB(3) ! ((0,4,2)|(0,0,2)) = ((0,4,3)|(0,0,1))+((0,4,2)|(0,0,1))*AB(3)
        theta(1444) = theta(1138)+theta(1012)*AB(3) ! ((0,3,1)|(0,0,3)) = ((0,3,2)|(0,0,2))+((0,3,1)|(0,0,2))*AB(3)
        theta(1644) = theta(1300)+theta(1132)*AB(3) ! ((0,4,1)|(0,0,3)) = ((0,4,2)|(0,0,2))+((0,4,1)|(0,0,2))*AB(3)
        theta(1863) = theta(1644)+theta(1444)*AB(2) ! ((0,3,1)|(0,1,3)) = ((0,4,1)|(0,0,3))+((0,3,1)|(0,0,3))*AB(2)
        ! (0,3,1|0,0,4): 15
        theta(507) = dot_product(vrrbuffer(:,12), D(:,180)) ! ((0,3,1)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,180)) ! ((0,3,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,180)) ! ((0,3,3)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,180)) ! ((0,3,4)|(0,0,0))
        theta(637) = dot_product(vrrbuffer(:,142), D(:,180)) ! ((0,3,5)|(0,0,0))
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(931) = theta(637)+theta(592)*AB(3) ! ((0,3,4)|(0,0,1)) = ((0,3,5)|(0,0,0))+((0,3,4)|(0,0,0))*AB(3)
        theta(1012) = theta(739)+theta(676)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(1138) = theta(823)+theta(739)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1306) = theta(931)+theta(823)*AB(3) ! ((0,3,3)|(0,0,2)) = ((0,3,4)|(0,0,1))+((0,3,3)|(0,0,1))*AB(3)
        theta(1444) = theta(1138)+theta(1012)*AB(3) ! ((0,3,1)|(0,0,3)) = ((0,3,2)|(0,0,2))+((0,3,1)|(0,0,2))*AB(3)
        theta(1654) = theta(1306)+theta(1138)*AB(3) ! ((0,3,2)|(0,0,3)) = ((0,3,3)|(0,0,2))+((0,3,2)|(0,0,2))*AB(3)
        theta(1864) = theta(1654)+theta(1444)*AB(3) ! ((0,3,1)|(0,0,4)) = ((0,3,2)|(0,0,3))+((0,3,1)|(0,0,3))*AB(3)
        ! (0,2,2|4,0,0): 15
        theta(508) = dot_product(vrrbuffer(:,13), D(:,181)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,181)) ! ((1,2,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,181)) ! ((2,2,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,181)) ! ((3,2,2)|(0,0,0))
        theta(608) = dot_product(vrrbuffer(:,113), D(:,181)) ! ((4,2,2)|(0,0,0))
        theta(677) = theta(523)+theta(508)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(722) = theta(544)+theta(523)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(785) = theta(572)+theta(544)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(869) = theta(608)+theta(572)*AB(1) ! ((3,2,2)|(1,0,0)) = ((4,2,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(1)
        theta(1013) = theta(722)+theta(677)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(1103) = theta(785)+theta(722)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(1229) = theta(869)+theta(785)*AB(1) ! ((2,2,2)|(2,0,0)) = ((3,2,2)|(1,0,0))+((2,2,2)|(1,0,0))*AB(1)
        theta(1445) = theta(1103)+theta(1013)*AB(1) ! ((0,2,2)|(3,0,0)) = ((1,2,2)|(2,0,0))+((0,2,2)|(2,0,0))*AB(1)
        theta(1595) = theta(1229)+theta(1103)*AB(1) ! ((1,2,2)|(3,0,0)) = ((2,2,2)|(2,0,0))+((1,2,2)|(2,0,0))*AB(1)
        theta(1865) = theta(1595)+theta(1445)*AB(1) ! ((0,2,2)|(4,0,0)) = ((1,2,2)|(3,0,0))+((0,2,2)|(3,0,0))*AB(1)
        ! (0,2,2|3,1,0): 18
        theta(508) = dot_product(vrrbuffer(:,13), D(:,182)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,182)) ! ((1,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,182)) ! ((0,3,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,182)) ! ((2,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,182)) ! ((1,3,2)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,182)) ! ((3,2,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,182)) ! ((2,3,2)|(0,0,0))
        theta(613) = dot_product(vrrbuffer(:,118), D(:,182)) ! ((3,3,2)|(0,0,0))
        theta(678) = theta(528)+theta(508)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(870) = theta(613)+theta(572)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(1014) = theta(723)+theta(678)*AB(1) ! ((0,2,2)|(1,1,0)) = ((1,2,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(1)
        theta(1104) = theta(786)+theta(723)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        theta(1230) = theta(870)+theta(786)*AB(1) ! ((2,2,2)|(1,1,0)) = ((3,2,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(1)
        theta(1446) = theta(1104)+theta(1014)*AB(1) ! ((0,2,2)|(2,1,0)) = ((1,2,2)|(1,1,0))+((0,2,2)|(1,1,0))*AB(1)
        theta(1596) = theta(1230)+theta(1104)*AB(1) ! ((1,2,2)|(2,1,0)) = ((2,2,2)|(1,1,0))+((1,2,2)|(1,1,0))*AB(1)
        theta(1866) = theta(1596)+theta(1446)*AB(1) ! ((0,2,2)|(3,1,0)) = ((1,2,2)|(2,1,0))+((0,2,2)|(2,1,0))*AB(1)
        ! (0,2,2|3,0,1): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,183)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,183)) ! ((1,2,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,183)) ! ((0,2,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,183)) ! ((2,2,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,183)) ! ((1,2,3)|(0,0,0))
        theta(572) = dot_product(vrrbuffer(:,77), D(:,183)) ! ((3,2,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,183)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,183)) ! ((3,2,3)|(0,0,0))
        theta(677) = theta(523)+theta(508)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(722) = theta(544)+theta(523)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(740) = theta(550)+theta(529)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(785) = theta(572)+theta(544)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(803) = theta(578)+theta(550)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(887) = theta(614)+theta(578)*AB(1) ! ((2,2,3)|(1,0,0)) = ((3,2,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(1)
        theta(1013) = theta(722)+theta(677)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(1103) = theta(785)+theta(722)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(1139) = theta(803)+theta(740)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        theta(1265) = theta(887)+theta(803)*AB(1) ! ((1,2,3)|(2,0,0)) = ((2,2,3)|(1,0,0))+((1,2,3)|(1,0,0))*AB(1)
        theta(1445) = theta(1103)+theta(1013)*AB(1) ! ((0,2,2)|(3,0,0)) = ((1,2,2)|(2,0,0))+((0,2,2)|(2,0,0))*AB(1)
        theta(1655) = theta(1265)+theta(1139)*AB(1) ! ((0,2,3)|(3,0,0)) = ((1,2,3)|(2,0,0))+((0,2,3)|(2,0,0))*AB(1)
        theta(1867) = theta(1655)+theta(1445)*AB(3) ! ((0,2,2)|(3,0,1)) = ((0,2,3)|(3,0,0))+((0,2,2)|(3,0,0))*AB(3)
        ! (0,2,2|2,2,0): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,184)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,184)) ! ((1,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,184)) ! ((0,3,2)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,184)) ! ((2,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,184)) ! ((1,3,2)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,184)) ! ((0,4,2)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,184)) ! ((2,3,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,184)) ! ((1,4,2)|(0,0,0))
        theta(619) = dot_product(vrrbuffer(:,124), D(:,184)) ! ((2,4,2)|(0,0,0))
        theta(678) = theta(528)+theta(508)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(885) = theta(619)+theta(577)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(1016) = theta(738)+theta(678)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1232) = theta(885)+theta(786)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1448) = theta(1106)+theta(1016)*AB(1) ! ((0,2,2)|(1,2,0)) = ((1,2,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(1)
        theta(1598) = theta(1232)+theta(1106)*AB(1) ! ((1,2,2)|(1,2,0)) = ((2,2,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(1)
        theta(1868) = theta(1598)+theta(1448)*AB(1) ! ((0,2,2)|(2,2,0)) = ((1,2,2)|(1,2,0))+((0,2,2)|(1,2,0))*AB(1)
        ! (0,2,2|2,1,1): 24
        theta(508) = dot_product(vrrbuffer(:,13), D(:,185)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,185)) ! ((1,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,185)) ! ((0,3,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,185)) ! ((0,2,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,185)) ! ((2,2,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,185)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,185)) ! ((1,2,3)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,185)) ! ((0,3,3)|(0,0,0))
        theta(577) = dot_product(vrrbuffer(:,82), D(:,185)) ! ((2,3,2)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,185)) ! ((2,2,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,185)) ! ((1,3,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,185)) ! ((2,3,3)|(0,0,0))
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(886) = theta(620)+theta(577)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(1017) = theta(739)+theta(679)*AB(2) ! ((0,2,2)|(0,1,1)) = ((0,3,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(2)
        theta(1107) = theta(802)+theta(724)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(1233) = theta(886)+theta(787)*AB(2) ! ((2,2,2)|(0,1,1)) = ((2,3,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(2)
        theta(1449) = theta(1107)+theta(1017)*AB(1) ! ((0,2,2)|(1,1,1)) = ((1,2,2)|(0,1,1))+((0,2,2)|(0,1,1))*AB(1)
        theta(1599) = theta(1233)+theta(1107)*AB(1) ! ((1,2,2)|(1,1,1)) = ((2,2,2)|(0,1,1))+((1,2,2)|(0,1,1))*AB(1)
        theta(1869) = theta(1599)+theta(1449)*AB(1) ! ((0,2,2)|(2,1,1)) = ((1,2,2)|(1,1,1))+((0,2,2)|(1,1,1))*AB(1)
        ! (0,2,2|2,0,2): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,186)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,186)) ! ((1,2,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,186)) ! ((0,2,3)|(0,0,0))
        theta(544) = dot_product(vrrbuffer(:,49), D(:,186)) ! ((2,2,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,186)) ! ((1,2,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,186)) ! ((0,2,4)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,186)) ! ((2,2,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,186)) ! ((1,2,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,186)) ! ((2,2,4)|(0,0,0))
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(1018) = theta(742)+theta(679)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1234) = theta(889)+theta(787)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1450) = theta(1108)+theta(1018)*AB(1) ! ((0,2,2)|(1,0,2)) = ((1,2,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(1)
        theta(1600) = theta(1234)+theta(1108)*AB(1) ! ((1,2,2)|(1,0,2)) = ((2,2,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(1)
        theta(1870) = theta(1600)+theta(1450)*AB(1) ! ((0,2,2)|(2,0,2)) = ((1,2,2)|(1,0,2))+((0,2,2)|(1,0,2))*AB(1)
        ! (0,2,2|1,3,0): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,187)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,187)) ! ((1,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,187)) ! ((0,3,2)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,187)) ! ((1,3,2)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,187)) ! ((0,4,2)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,187)) ! ((1,4,2)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,187)) ! ((0,5,2)|(0,0,0))
        theta(626) = dot_product(vrrbuffer(:,131), D(:,187)) ! ((1,5,2)|(0,0,0))
        theta(678) = theta(528)+theta(508)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(819) = theta(590)+theta(555)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(903) = theta(626)+theta(583)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(1016) = theta(738)+theta(678)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1136) = theta(819)+theta(738)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(1262) = theta(903)+theta(801)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        theta(1451) = theta(1136)+theta(1016)*AB(2) ! ((0,2,2)|(0,3,0)) = ((0,3,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(2)
        theta(1601) = theta(1262)+theta(1106)*AB(2) ! ((1,2,2)|(0,3,0)) = ((1,3,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(2)
        theta(1871) = theta(1601)+theta(1451)*AB(1) ! ((0,2,2)|(1,3,0)) = ((1,2,2)|(0,3,0))+((0,2,2)|(0,3,0))*AB(1)
        ! (0,2,2|1,2,1): 27
        theta(508) = dot_product(vrrbuffer(:,13), D(:,188)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,188)) ! ((1,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,188)) ! ((0,3,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,188)) ! ((0,2,3)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,188)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,188)) ! ((1,2,3)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,188)) ! ((0,4,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,188)) ! ((0,3,3)|(0,0,0))
        theta(583) = dot_product(vrrbuffer(:,88), D(:,188)) ! ((1,4,2)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,188)) ! ((1,3,3)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,188)) ! ((0,4,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,188)) ! ((1,4,3)|(0,0,0))
        theta(678) = theta(528)+theta(508)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(822) = theta(591)+theta(556)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(906) = theta(627)+theta(584)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(1016) = theta(738)+theta(678)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1142) = theta(822)+theta(741)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(1268) = theta(906)+theta(804)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        theta(1452) = theta(1142)+theta(1016)*AB(3) ! ((0,2,2)|(0,2,1)) = ((0,2,3)|(0,2,0))+((0,2,2)|(0,2,0))*AB(3)
        theta(1602) = theta(1268)+theta(1106)*AB(3) ! ((1,2,2)|(0,2,1)) = ((1,2,3)|(0,2,0))+((1,2,2)|(0,2,0))*AB(3)
        theta(1872) = theta(1602)+theta(1452)*AB(1) ! ((0,2,2)|(1,2,1)) = ((1,2,2)|(0,2,1))+((0,2,2)|(0,2,1))*AB(1)
        ! (0,2,2|1,1,2): 27
        theta(508) = dot_product(vrrbuffer(:,13), D(:,189)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,189)) ! ((1,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,189)) ! ((0,3,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,189)) ! ((0,2,3)|(0,0,0))
        theta(549) = dot_product(vrrbuffer(:,54), D(:,189)) ! ((1,3,2)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,189)) ! ((1,2,3)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,189)) ! ((0,3,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,189)) ! ((0,2,4)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,189)) ! ((1,3,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,189)) ! ((1,2,4)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,189)) ! ((0,3,4)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,189)) ! ((1,3,4)|(0,0,0))
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(907) = theta(628)+theta(584)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(1018) = theta(742)+theta(679)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1138) = theta(823)+theta(739)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1264) = theta(907)+theta(802)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1453) = theta(1138)+theta(1018)*AB(2) ! ((0,2,2)|(0,1,2)) = ((0,3,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(2)
        theta(1603) = theta(1264)+theta(1108)*AB(2) ! ((1,2,2)|(0,1,2)) = ((1,3,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(2)
        theta(1873) = theta(1603)+theta(1453)*AB(1) ! ((0,2,2)|(1,1,2)) = ((1,2,2)|(0,1,2))+((0,2,2)|(0,1,2))*AB(1)
        ! (0,2,2|1,0,3): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,190)) ! ((0,2,2)|(0,0,0))
        theta(523) = dot_product(vrrbuffer(:,28), D(:,190)) ! ((1,2,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,190)) ! ((0,2,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,190)) ! ((1,2,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,190)) ! ((0,2,4)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,190)) ! ((1,2,4)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,190)) ! ((0,2,5)|(0,0,0))
        theta(629) = dot_product(vrrbuffer(:,134), D(:,190)) ! ((1,2,5)|(0,0,0))
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(910) = theta(629)+theta(585)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(1018) = theta(742)+theta(679)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1144) = theta(826)+theta(742)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1270) = theta(910)+theta(805)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1454) = theta(1144)+theta(1018)*AB(3) ! ((0,2,2)|(0,0,3)) = ((0,2,3)|(0,0,2))+((0,2,2)|(0,0,2))*AB(3)
        theta(1604) = theta(1270)+theta(1108)*AB(3) ! ((1,2,2)|(0,0,3)) = ((1,2,3)|(0,0,2))+((1,2,2)|(0,0,2))*AB(3)
        theta(1874) = theta(1604)+theta(1454)*AB(1) ! ((0,2,2)|(1,0,3)) = ((1,2,2)|(0,0,3))+((0,2,2)|(0,0,3))*AB(1)
        ! (0,2,2|0,4,0): 15
        theta(508) = dot_product(vrrbuffer(:,13), D(:,191)) ! ((0,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,191)) ! ((0,3,2)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,191)) ! ((0,4,2)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,191)) ! ((0,5,2)|(0,0,0))
        theta(634) = dot_product(vrrbuffer(:,139), D(:,191)) ! ((0,6,2)|(0,0,0))
        theta(678) = theta(528)+theta(508)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(819) = theta(590)+theta(555)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(924) = theta(634)+theta(590)*AB(2) ! ((0,5,2)|(0,1,0)) = ((0,6,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(2)
        theta(1016) = theta(738)+theta(678)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(1136) = theta(819)+theta(738)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(1298) = theta(924)+theta(819)*AB(2) ! ((0,4,2)|(0,2,0)) = ((0,5,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(2)
        theta(1451) = theta(1136)+theta(1016)*AB(2) ! ((0,2,2)|(0,3,0)) = ((0,3,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(2)
        theta(1651) = theta(1298)+theta(1136)*AB(2) ! ((0,3,2)|(0,3,0)) = ((0,4,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(2)
        theta(1875) = theta(1651)+theta(1451)*AB(2) ! ((0,2,2)|(0,4,0)) = ((0,3,2)|(0,3,0))+((0,2,2)|(0,3,0))*AB(2)
        ! (0,2,2|0,3,1): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,192)) ! ((0,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,192)) ! ((0,3,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,192)) ! ((0,2,3)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,192)) ! ((0,4,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,192)) ! ((0,3,3)|(0,0,0))
        theta(590) = dot_product(vrrbuffer(:,95), D(:,192)) ! ((0,5,2)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,192)) ! ((0,4,3)|(0,0,0))
        theta(635) = dot_product(vrrbuffer(:,140), D(:,192)) ! ((0,5,3)|(0,0,0))
        theta(678) = theta(528)+theta(508)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(819) = theta(590)+theta(555)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(822) = theta(591)+theta(556)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(927) = theta(635)+theta(591)*AB(2) ! ((0,4,3)|(0,1,0)) = ((0,5,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(2)
        theta(1016) = theta(738)+theta(678)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(1136) = theta(819)+theta(738)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(1142) = theta(822)+theta(741)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(1304) = theta(927)+theta(822)*AB(2) ! ((0,3,3)|(0,2,0)) = ((0,4,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(2)
        theta(1451) = theta(1136)+theta(1016)*AB(2) ! ((0,2,2)|(0,3,0)) = ((0,3,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(2)
        theta(1661) = theta(1304)+theta(1142)*AB(2) ! ((0,2,3)|(0,3,0)) = ((0,3,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(2)
        theta(1876) = theta(1661)+theta(1451)*AB(3) ! ((0,2,2)|(0,3,1)) = ((0,2,3)|(0,3,0))+((0,2,2)|(0,3,0))*AB(3)
        ! (0,2,2|0,2,2): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,193)) ! ((0,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,193)) ! ((0,3,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,193)) ! ((0,2,3)|(0,0,0))
        theta(555) = dot_product(vrrbuffer(:,60), D(:,193)) ! ((0,4,2)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,193)) ! ((0,3,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,193)) ! ((0,2,4)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,193)) ! ((0,4,3)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,193)) ! ((0,3,4)|(0,0,0))
        theta(636) = dot_product(vrrbuffer(:,141), D(:,193)) ! ((0,4,4)|(0,0,0))
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(928) = theta(636)+theta(591)*AB(3) ! ((0,4,3)|(0,0,1)) = ((0,4,4)|(0,0,0))+((0,4,3)|(0,0,0))*AB(3)
        theta(1018) = theta(742)+theta(679)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(1138) = theta(823)+theta(739)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1300) = theta(928)+theta(820)*AB(3) ! ((0,4,2)|(0,0,2)) = ((0,4,3)|(0,0,1))+((0,4,2)|(0,0,1))*AB(3)
        theta(1453) = theta(1138)+theta(1018)*AB(2) ! ((0,2,2)|(0,1,2)) = ((0,3,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(2)
        theta(1653) = theta(1300)+theta(1138)*AB(2) ! ((0,3,2)|(0,1,2)) = ((0,4,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(2)
        theta(1877) = theta(1653)+theta(1453)*AB(2) ! ((0,2,2)|(0,2,2)) = ((0,3,2)|(0,1,2))+((0,2,2)|(0,1,2))*AB(2)
        ! (0,2,2|0,1,3): 21
        theta(508) = dot_product(vrrbuffer(:,13), D(:,194)) ! ((0,2,2)|(0,0,0))
        theta(528) = dot_product(vrrbuffer(:,33), D(:,194)) ! ((0,3,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,194)) ! ((0,2,3)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,194)) ! ((0,3,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,194)) ! ((0,2,4)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,194)) ! ((0,3,4)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,194)) ! ((0,2,5)|(0,0,0))
        theta(637) = dot_product(vrrbuffer(:,142), D(:,194)) ! ((0,3,5)|(0,0,0))
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(931) = theta(637)+theta(592)*AB(3) ! ((0,3,4)|(0,0,1)) = ((0,3,5)|(0,0,0))+((0,3,4)|(0,0,0))*AB(3)
        theta(1018) = theta(742)+theta(679)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(1138) = theta(823)+theta(739)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1144) = theta(826)+theta(742)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1306) = theta(931)+theta(823)*AB(3) ! ((0,3,3)|(0,0,2)) = ((0,3,4)|(0,0,1))+((0,3,3)|(0,0,1))*AB(3)
        theta(1454) = theta(1144)+theta(1018)*AB(3) ! ((0,2,2)|(0,0,3)) = ((0,2,3)|(0,0,2))+((0,2,2)|(0,0,2))*AB(3)
        theta(1654) = theta(1306)+theta(1138)*AB(3) ! ((0,3,2)|(0,0,3)) = ((0,3,3)|(0,0,2))+((0,3,2)|(0,0,2))*AB(3)
        theta(1878) = theta(1654)+theta(1454)*AB(2) ! ((0,2,2)|(0,1,3)) = ((0,3,2)|(0,0,3))+((0,2,2)|(0,0,3))*AB(2)
        ! (0,2,2|0,0,4): 15
        theta(508) = dot_product(vrrbuffer(:,13), D(:,195)) ! ((0,2,2)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,195)) ! ((0,2,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,195)) ! ((0,2,4)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,195)) ! ((0,2,5)|(0,0,0))
        theta(638) = dot_product(vrrbuffer(:,143), D(:,195)) ! ((0,2,6)|(0,0,0))
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(934) = theta(638)+theta(593)*AB(3) ! ((0,2,5)|(0,0,1)) = ((0,2,6)|(0,0,0))+((0,2,5)|(0,0,0))*AB(3)
        theta(1018) = theta(742)+theta(679)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(1144) = theta(826)+theta(742)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1312) = theta(934)+theta(826)*AB(3) ! ((0,2,4)|(0,0,2)) = ((0,2,5)|(0,0,1))+((0,2,4)|(0,0,1))*AB(3)
        theta(1454) = theta(1144)+theta(1018)*AB(3) ! ((0,2,2)|(0,0,3)) = ((0,2,3)|(0,0,2))+((0,2,2)|(0,0,2))*AB(3)
        theta(1664) = theta(1312)+theta(1144)*AB(3) ! ((0,2,3)|(0,0,3)) = ((0,2,4)|(0,0,2))+((0,2,3)|(0,0,2))*AB(3)
        theta(1879) = theta(1664)+theta(1454)*AB(3) ! ((0,2,2)|(0,0,4)) = ((0,2,3)|(0,0,3))+((0,2,2)|(0,0,3))*AB(3)
        ! (0,1,3|4,0,0): 15
        theta(509) = dot_product(vrrbuffer(:,14), D(:,196)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,196)) ! ((1,1,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,196)) ! ((2,1,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,196)) ! ((3,1,3)|(0,0,0))
        theta(609) = dot_product(vrrbuffer(:,114), D(:,196)) ! ((4,1,3)|(0,0,0))
        theta(680) = theta(524)+theta(509)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(725) = theta(545)+theta(524)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(788) = theta(573)+theta(545)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(872) = theta(609)+theta(573)*AB(1) ! ((3,1,3)|(1,0,0)) = ((4,1,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(1)
        theta(1019) = theta(725)+theta(680)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(1109) = theta(788)+theta(725)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(1235) = theta(872)+theta(788)*AB(1) ! ((2,1,3)|(2,0,0)) = ((3,1,3)|(1,0,0))+((2,1,3)|(1,0,0))*AB(1)
        theta(1455) = theta(1109)+theta(1019)*AB(1) ! ((0,1,3)|(3,0,0)) = ((1,1,3)|(2,0,0))+((0,1,3)|(2,0,0))*AB(1)
        theta(1605) = theta(1235)+theta(1109)*AB(1) ! ((1,1,3)|(3,0,0)) = ((2,1,3)|(2,0,0))+((1,1,3)|(2,0,0))*AB(1)
        theta(1880) = theta(1605)+theta(1455)*AB(1) ! ((0,1,3)|(4,0,0)) = ((1,1,3)|(3,0,0))+((0,1,3)|(3,0,0))*AB(1)
        ! (0,1,3|3,1,0): 18
        theta(509) = dot_product(vrrbuffer(:,14), D(:,197)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,197)) ! ((1,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,197)) ! ((0,2,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,197)) ! ((2,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,197)) ! ((1,2,3)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,197)) ! ((3,1,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,197)) ! ((2,2,3)|(0,0,0))
        theta(614) = dot_product(vrrbuffer(:,119), D(:,197)) ! ((3,2,3)|(0,0,0))
        theta(681) = theta(529)+theta(509)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(873) = theta(614)+theta(573)*AB(2) ! ((3,1,3)|(0,1,0)) = ((3,2,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(2)
        theta(1020) = theta(726)+theta(681)*AB(1) ! ((0,1,3)|(1,1,0)) = ((1,1,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(1)
        theta(1110) = theta(789)+theta(726)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        theta(1236) = theta(873)+theta(789)*AB(1) ! ((2,1,3)|(1,1,0)) = ((3,1,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(1)
        theta(1456) = theta(1110)+theta(1020)*AB(1) ! ((0,1,3)|(2,1,0)) = ((1,1,3)|(1,1,0))+((0,1,3)|(1,1,0))*AB(1)
        theta(1606) = theta(1236)+theta(1110)*AB(1) ! ((1,1,3)|(2,1,0)) = ((2,1,3)|(1,1,0))+((1,1,3)|(1,1,0))*AB(1)
        theta(1881) = theta(1606)+theta(1456)*AB(1) ! ((0,1,3)|(3,1,0)) = ((1,1,3)|(2,1,0))+((0,1,3)|(2,1,0))*AB(1)
        ! (0,1,3|3,0,1): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,198)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,198)) ! ((1,1,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,198)) ! ((0,1,4)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,198)) ! ((2,1,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,198)) ! ((1,1,4)|(0,0,0))
        theta(573) = dot_product(vrrbuffer(:,78), D(:,198)) ! ((3,1,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,198)) ! ((2,1,4)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,198)) ! ((3,1,4)|(0,0,0))
        theta(680) = theta(524)+theta(509)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(725) = theta(545)+theta(524)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(743) = theta(551)+theta(530)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(788) = theta(573)+theta(545)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(806) = theta(579)+theta(551)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(890) = theta(615)+theta(579)*AB(1) ! ((2,1,4)|(1,0,0)) = ((3,1,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(1)
        theta(1019) = theta(725)+theta(680)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(1109) = theta(788)+theta(725)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(1145) = theta(806)+theta(743)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        theta(1271) = theta(890)+theta(806)*AB(1) ! ((1,1,4)|(2,0,0)) = ((2,1,4)|(1,0,0))+((1,1,4)|(1,0,0))*AB(1)
        theta(1455) = theta(1109)+theta(1019)*AB(1) ! ((0,1,3)|(3,0,0)) = ((1,1,3)|(2,0,0))+((0,1,3)|(2,0,0))*AB(1)
        theta(1665) = theta(1271)+theta(1145)*AB(1) ! ((0,1,4)|(3,0,0)) = ((1,1,4)|(2,0,0))+((0,1,4)|(2,0,0))*AB(1)
        theta(1882) = theta(1665)+theta(1455)*AB(3) ! ((0,1,3)|(3,0,1)) = ((0,1,4)|(3,0,0))+((0,1,3)|(3,0,0))*AB(3)
        ! (0,1,3|2,2,0): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,199)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,199)) ! ((1,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,199)) ! ((0,2,3)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,199)) ! ((2,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,199)) ! ((1,2,3)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,199)) ! ((0,3,3)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,199)) ! ((2,2,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,199)) ! ((1,3,3)|(0,0,0))
        theta(620) = dot_product(vrrbuffer(:,125), D(:,199)) ! ((2,3,3)|(0,0,0))
        theta(681) = theta(529)+theta(509)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(888) = theta(620)+theta(578)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(1022) = theta(741)+theta(681)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1238) = theta(888)+theta(789)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(1458) = theta(1112)+theta(1022)*AB(1) ! ((0,1,3)|(1,2,0)) = ((1,1,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(1)
        theta(1608) = theta(1238)+theta(1112)*AB(1) ! ((1,1,3)|(1,2,0)) = ((2,1,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(1)
        theta(1883) = theta(1608)+theta(1458)*AB(1) ! ((0,1,3)|(2,2,0)) = ((1,1,3)|(1,2,0))+((0,1,3)|(1,2,0))*AB(1)
        ! (0,1,3|2,1,1): 24
        theta(509) = dot_product(vrrbuffer(:,14), D(:,200)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,200)) ! ((1,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,200)) ! ((0,2,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,200)) ! ((0,1,4)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,200)) ! ((2,1,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,200)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,200)) ! ((1,1,4)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,200)) ! ((0,2,4)|(0,0,0))
        theta(578) = dot_product(vrrbuffer(:,83), D(:,200)) ! ((2,2,3)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,200)) ! ((2,1,4)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,200)) ! ((1,2,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,200)) ! ((2,2,4)|(0,0,0))
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(1023) = theta(742)+theta(682)*AB(2) ! ((0,1,3)|(0,1,1)) = ((0,2,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(2)
        theta(1113) = theta(805)+theta(727)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(1239) = theta(889)+theta(790)*AB(2) ! ((2,1,3)|(0,1,1)) = ((2,2,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(2)
        theta(1459) = theta(1113)+theta(1023)*AB(1) ! ((0,1,3)|(1,1,1)) = ((1,1,3)|(0,1,1))+((0,1,3)|(0,1,1))*AB(1)
        theta(1609) = theta(1239)+theta(1113)*AB(1) ! ((1,1,3)|(1,1,1)) = ((2,1,3)|(0,1,1))+((1,1,3)|(0,1,1))*AB(1)
        theta(1884) = theta(1609)+theta(1459)*AB(1) ! ((0,1,3)|(2,1,1)) = ((1,1,3)|(1,1,1))+((0,1,3)|(1,1,1))*AB(1)
        ! (0,1,3|2,0,2): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,201)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,201)) ! ((1,1,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,201)) ! ((0,1,4)|(0,0,0))
        theta(545) = dot_product(vrrbuffer(:,50), D(:,201)) ! ((2,1,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,201)) ! ((1,1,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,201)) ! ((0,1,5)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,201)) ! ((2,1,4)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,201)) ! ((1,1,5)|(0,0,0))
        theta(622) = dot_product(vrrbuffer(:,127), D(:,201)) ! ((2,1,5)|(0,0,0))
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(892) = theta(622)+theta(579)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(1024) = theta(745)+theta(682)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1240) = theta(892)+theta(790)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1460) = theta(1114)+theta(1024)*AB(1) ! ((0,1,3)|(1,0,2)) = ((1,1,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(1)
        theta(1610) = theta(1240)+theta(1114)*AB(1) ! ((1,1,3)|(1,0,2)) = ((2,1,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(1)
        theta(1885) = theta(1610)+theta(1460)*AB(1) ! ((0,1,3)|(2,0,2)) = ((1,1,3)|(1,0,2))+((0,1,3)|(1,0,2))*AB(1)
        ! (0,1,3|1,3,0): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,202)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,202)) ! ((1,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,202)) ! ((0,2,3)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,202)) ! ((1,2,3)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,202)) ! ((0,3,3)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,202)) ! ((1,3,3)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,202)) ! ((0,4,3)|(0,0,0))
        theta(627) = dot_product(vrrbuffer(:,132), D(:,202)) ! ((1,4,3)|(0,0,0))
        theta(681) = theta(529)+theta(509)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(822) = theta(591)+theta(556)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(906) = theta(627)+theta(584)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(1022) = theta(741)+theta(681)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1142) = theta(822)+theta(741)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(1268) = theta(906)+theta(804)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        theta(1461) = theta(1142)+theta(1022)*AB(2) ! ((0,1,3)|(0,3,0)) = ((0,2,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(2)
        theta(1611) = theta(1268)+theta(1112)*AB(2) ! ((1,1,3)|(0,3,0)) = ((1,2,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(2)
        theta(1886) = theta(1611)+theta(1461)*AB(1) ! ((0,1,3)|(1,3,0)) = ((1,1,3)|(0,3,0))+((0,1,3)|(0,3,0))*AB(1)
        ! (0,1,3|1,2,1): 27
        theta(509) = dot_product(vrrbuffer(:,14), D(:,203)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,203)) ! ((1,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,203)) ! ((0,2,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,203)) ! ((0,1,4)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,203)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,203)) ! ((1,1,4)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,203)) ! ((0,3,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,203)) ! ((0,2,4)|(0,0,0))
        theta(584) = dot_product(vrrbuffer(:,89), D(:,203)) ! ((1,3,3)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,203)) ! ((1,2,4)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,203)) ! ((0,3,4)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,203)) ! ((1,3,4)|(0,0,0))
        theta(681) = theta(529)+theta(509)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(807) = theta(585)+theta(551)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(825) = theta(592)+theta(557)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(909) = theta(628)+theta(585)*AB(2) ! ((1,2,4)|(0,1,0)) = ((1,3,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(2)
        theta(1022) = theta(741)+theta(681)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1148) = theta(825)+theta(744)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(1274) = theta(909)+theta(807)*AB(2) ! ((1,1,4)|(0,2,0)) = ((1,2,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(2)
        theta(1462) = theta(1148)+theta(1022)*AB(3) ! ((0,1,3)|(0,2,1)) = ((0,1,4)|(0,2,0))+((0,1,3)|(0,2,0))*AB(3)
        theta(1612) = theta(1274)+theta(1112)*AB(3) ! ((1,1,3)|(0,2,1)) = ((1,1,4)|(0,2,0))+((1,1,3)|(0,2,0))*AB(3)
        theta(1887) = theta(1612)+theta(1462)*AB(1) ! ((0,1,3)|(1,2,1)) = ((1,1,3)|(0,2,1))+((0,1,3)|(0,2,1))*AB(1)
        ! (0,1,3|1,1,2): 27
        theta(509) = dot_product(vrrbuffer(:,14), D(:,204)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,204)) ! ((1,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,204)) ! ((0,2,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,204)) ! ((0,1,4)|(0,0,0))
        theta(550) = dot_product(vrrbuffer(:,55), D(:,204)) ! ((1,2,3)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,204)) ! ((1,1,4)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,204)) ! ((0,2,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,204)) ! ((0,1,5)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,204)) ! ((1,2,4)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,204)) ! ((1,1,5)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,204)) ! ((0,2,5)|(0,0,0))
        theta(629) = dot_product(vrrbuffer(:,134), D(:,204)) ! ((1,2,5)|(0,0,0))
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(910) = theta(629)+theta(585)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(1024) = theta(745)+theta(682)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1144) = theta(826)+theta(742)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1270) = theta(910)+theta(805)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1463) = theta(1144)+theta(1024)*AB(2) ! ((0,1,3)|(0,1,2)) = ((0,2,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(2)
        theta(1613) = theta(1270)+theta(1114)*AB(2) ! ((1,1,3)|(0,1,2)) = ((1,2,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(2)
        theta(1888) = theta(1613)+theta(1463)*AB(1) ! ((0,1,3)|(1,1,2)) = ((1,1,3)|(0,1,2))+((0,1,3)|(0,1,2))*AB(1)
        ! (0,1,3|1,0,3): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,205)) ! ((0,1,3)|(0,0,0))
        theta(524) = dot_product(vrrbuffer(:,29), D(:,205)) ! ((1,1,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,205)) ! ((0,1,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,205)) ! ((1,1,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,205)) ! ((0,1,5)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,205)) ! ((1,1,5)|(0,0,0))
        theta(594) = dot_product(vrrbuffer(:,99), D(:,205)) ! ((0,1,6)|(0,0,0))
        theta(630) = dot_product(vrrbuffer(:,135), D(:,205)) ! ((1,1,6)|(0,0,0))
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(829) = theta(594)+theta(558)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(913) = theta(630)+theta(586)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        theta(1024) = theta(745)+theta(682)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1150) = theta(829)+theta(745)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1276) = theta(913)+theta(808)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(1464) = theta(1150)+theta(1024)*AB(3) ! ((0,1,3)|(0,0,3)) = ((0,1,4)|(0,0,2))+((0,1,3)|(0,0,2))*AB(3)
        theta(1614) = theta(1276)+theta(1114)*AB(3) ! ((1,1,3)|(0,0,3)) = ((1,1,4)|(0,0,2))+((1,1,3)|(0,0,2))*AB(3)
        theta(1889) = theta(1614)+theta(1464)*AB(1) ! ((0,1,3)|(1,0,3)) = ((1,1,3)|(0,0,3))+((0,1,3)|(0,0,3))*AB(1)
        ! (0,1,3|0,4,0): 15
        theta(509) = dot_product(vrrbuffer(:,14), D(:,206)) ! ((0,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,206)) ! ((0,2,3)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,206)) ! ((0,3,3)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,206)) ! ((0,4,3)|(0,0,0))
        theta(635) = dot_product(vrrbuffer(:,140), D(:,206)) ! ((0,5,3)|(0,0,0))
        theta(681) = theta(529)+theta(509)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(822) = theta(591)+theta(556)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(927) = theta(635)+theta(591)*AB(2) ! ((0,4,3)|(0,1,0)) = ((0,5,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(2)
        theta(1022) = theta(741)+theta(681)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(1142) = theta(822)+theta(741)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(1304) = theta(927)+theta(822)*AB(2) ! ((0,3,3)|(0,2,0)) = ((0,4,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(2)
        theta(1461) = theta(1142)+theta(1022)*AB(2) ! ((0,1,3)|(0,3,0)) = ((0,2,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(2)
        theta(1661) = theta(1304)+theta(1142)*AB(2) ! ((0,2,3)|(0,3,0)) = ((0,3,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(2)
        theta(1890) = theta(1661)+theta(1461)*AB(2) ! ((0,1,3)|(0,4,0)) = ((0,2,3)|(0,3,0))+((0,1,3)|(0,3,0))*AB(2)
        ! (0,1,3|0,3,1): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,207)) ! ((0,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,207)) ! ((0,2,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,207)) ! ((0,1,4)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,207)) ! ((0,3,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,207)) ! ((0,2,4)|(0,0,0))
        theta(591) = dot_product(vrrbuffer(:,96), D(:,207)) ! ((0,4,3)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,207)) ! ((0,3,4)|(0,0,0))
        theta(636) = dot_product(vrrbuffer(:,141), D(:,207)) ! ((0,4,4)|(0,0,0))
        theta(681) = theta(529)+theta(509)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(822) = theta(591)+theta(556)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(825) = theta(592)+theta(557)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(930) = theta(636)+theta(592)*AB(2) ! ((0,3,4)|(0,1,0)) = ((0,4,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(2)
        theta(1022) = theta(741)+theta(681)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(1142) = theta(822)+theta(741)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(1148) = theta(825)+theta(744)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(1310) = theta(930)+theta(825)*AB(2) ! ((0,2,4)|(0,2,0)) = ((0,3,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(2)
        theta(1461) = theta(1142)+theta(1022)*AB(2) ! ((0,1,3)|(0,3,0)) = ((0,2,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(2)
        theta(1671) = theta(1310)+theta(1148)*AB(2) ! ((0,1,4)|(0,3,0)) = ((0,2,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(2)
        theta(1891) = theta(1671)+theta(1461)*AB(3) ! ((0,1,3)|(0,3,1)) = ((0,1,4)|(0,3,0))+((0,1,3)|(0,3,0))*AB(3)
        ! (0,1,3|0,2,2): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,208)) ! ((0,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,208)) ! ((0,2,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,208)) ! ((0,1,4)|(0,0,0))
        theta(556) = dot_product(vrrbuffer(:,61), D(:,208)) ! ((0,3,3)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,208)) ! ((0,2,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,208)) ! ((0,1,5)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,208)) ! ((0,3,4)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,208)) ! ((0,2,5)|(0,0,0))
        theta(637) = dot_product(vrrbuffer(:,142), D(:,208)) ! ((0,3,5)|(0,0,0))
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(931) = theta(637)+theta(592)*AB(3) ! ((0,3,4)|(0,0,1)) = ((0,3,5)|(0,0,0))+((0,3,4)|(0,0,0))*AB(3)
        theta(1024) = theta(745)+theta(682)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(1144) = theta(826)+theta(742)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1306) = theta(931)+theta(823)*AB(3) ! ((0,3,3)|(0,0,2)) = ((0,3,4)|(0,0,1))+((0,3,3)|(0,0,1))*AB(3)
        theta(1463) = theta(1144)+theta(1024)*AB(2) ! ((0,1,3)|(0,1,2)) = ((0,2,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(2)
        theta(1663) = theta(1306)+theta(1144)*AB(2) ! ((0,2,3)|(0,1,2)) = ((0,3,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(2)
        theta(1892) = theta(1663)+theta(1463)*AB(2) ! ((0,1,3)|(0,2,2)) = ((0,2,3)|(0,1,2))+((0,1,3)|(0,1,2))*AB(2)
        ! (0,1,3|0,1,3): 21
        theta(509) = dot_product(vrrbuffer(:,14), D(:,209)) ! ((0,1,3)|(0,0,0))
        theta(529) = dot_product(vrrbuffer(:,34), D(:,209)) ! ((0,2,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,209)) ! ((0,1,4)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,209)) ! ((0,2,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,209)) ! ((0,1,5)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,209)) ! ((0,2,5)|(0,0,0))
        theta(594) = dot_product(vrrbuffer(:,99), D(:,209)) ! ((0,1,6)|(0,0,0))
        theta(638) = dot_product(vrrbuffer(:,143), D(:,209)) ! ((0,2,6)|(0,0,0))
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(829) = theta(594)+theta(558)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(934) = theta(638)+theta(593)*AB(3) ! ((0,2,5)|(0,0,1)) = ((0,2,6)|(0,0,0))+((0,2,5)|(0,0,0))*AB(3)
        theta(1024) = theta(745)+theta(682)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(1144) = theta(826)+theta(742)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1150) = theta(829)+theta(745)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1312) = theta(934)+theta(826)*AB(3) ! ((0,2,4)|(0,0,2)) = ((0,2,5)|(0,0,1))+((0,2,4)|(0,0,1))*AB(3)
        theta(1464) = theta(1150)+theta(1024)*AB(3) ! ((0,1,3)|(0,0,3)) = ((0,1,4)|(0,0,2))+((0,1,3)|(0,0,2))*AB(3)
        theta(1664) = theta(1312)+theta(1144)*AB(3) ! ((0,2,3)|(0,0,3)) = ((0,2,4)|(0,0,2))+((0,2,3)|(0,0,2))*AB(3)
        theta(1893) = theta(1664)+theta(1464)*AB(2) ! ((0,1,3)|(0,1,3)) = ((0,2,3)|(0,0,3))+((0,1,3)|(0,0,3))*AB(2)
        ! (0,1,3|0,0,4): 15
        theta(509) = dot_product(vrrbuffer(:,14), D(:,210)) ! ((0,1,3)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,210)) ! ((0,1,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,210)) ! ((0,1,5)|(0,0,0))
        theta(594) = dot_product(vrrbuffer(:,99), D(:,210)) ! ((0,1,6)|(0,0,0))
        theta(639) = dot_product(vrrbuffer(:,144), D(:,210)) ! ((0,1,7)|(0,0,0))
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(829) = theta(594)+theta(558)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(937) = theta(639)+theta(594)*AB(3) ! ((0,1,6)|(0,0,1)) = ((0,1,7)|(0,0,0))+((0,1,6)|(0,0,0))*AB(3)
        theta(1024) = theta(745)+theta(682)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(1150) = theta(829)+theta(745)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1318) = theta(937)+theta(829)*AB(3) ! ((0,1,5)|(0,0,2)) = ((0,1,6)|(0,0,1))+((0,1,5)|(0,0,1))*AB(3)
        theta(1464) = theta(1150)+theta(1024)*AB(3) ! ((0,1,3)|(0,0,3)) = ((0,1,4)|(0,0,2))+((0,1,3)|(0,0,2))*AB(3)
        theta(1674) = theta(1318)+theta(1150)*AB(3) ! ((0,1,4)|(0,0,3)) = ((0,1,5)|(0,0,2))+((0,1,4)|(0,0,2))*AB(3)
        theta(1894) = theta(1674)+theta(1464)*AB(3) ! ((0,1,3)|(0,0,4)) = ((0,1,4)|(0,0,3))+((0,1,3)|(0,0,3))*AB(3)
        ! (0,0,4|4,0,0): 15
        theta(510) = dot_product(vrrbuffer(:,15), D(:,211)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,211)) ! ((1,0,4)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,211)) ! ((2,0,4)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,211)) ! ((3,0,4)|(0,0,0))
        theta(610) = dot_product(vrrbuffer(:,115), D(:,211)) ! ((4,0,4)|(0,0,0))
        theta(683) = theta(525)+theta(510)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(728) = theta(546)+theta(525)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(791) = theta(574)+theta(546)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(875) = theta(610)+theta(574)*AB(1) ! ((3,0,4)|(1,0,0)) = ((4,0,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(1)
        theta(1025) = theta(728)+theta(683)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(1115) = theta(791)+theta(728)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(1241) = theta(875)+theta(791)*AB(1) ! ((2,0,4)|(2,0,0)) = ((3,0,4)|(1,0,0))+((2,0,4)|(1,0,0))*AB(1)
        theta(1465) = theta(1115)+theta(1025)*AB(1) ! ((0,0,4)|(3,0,0)) = ((1,0,4)|(2,0,0))+((0,0,4)|(2,0,0))*AB(1)
        theta(1615) = theta(1241)+theta(1115)*AB(1) ! ((1,0,4)|(3,0,0)) = ((2,0,4)|(2,0,0))+((1,0,4)|(2,0,0))*AB(1)
        theta(1895) = theta(1615)+theta(1465)*AB(1) ! ((0,0,4)|(4,0,0)) = ((1,0,4)|(3,0,0))+((0,0,4)|(3,0,0))*AB(1)
        ! (0,0,4|3,1,0): 18
        theta(510) = dot_product(vrrbuffer(:,15), D(:,212)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,212)) ! ((1,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,212)) ! ((0,1,4)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,212)) ! ((2,0,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,212)) ! ((1,1,4)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,212)) ! ((3,0,4)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,212)) ! ((2,1,4)|(0,0,0))
        theta(615) = dot_product(vrrbuffer(:,120), D(:,212)) ! ((3,1,4)|(0,0,0))
        theta(684) = theta(530)+theta(510)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(729) = theta(551)+theta(525)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(792) = theta(579)+theta(546)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(876) = theta(615)+theta(574)*AB(2) ! ((3,0,4)|(0,1,0)) = ((3,1,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(2)
        theta(1026) = theta(729)+theta(684)*AB(1) ! ((0,0,4)|(1,1,0)) = ((1,0,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(1)
        theta(1116) = theta(792)+theta(729)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        theta(1242) = theta(876)+theta(792)*AB(1) ! ((2,0,4)|(1,1,0)) = ((3,0,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(1)
        theta(1466) = theta(1116)+theta(1026)*AB(1) ! ((0,0,4)|(2,1,0)) = ((1,0,4)|(1,1,0))+((0,0,4)|(1,1,0))*AB(1)
        theta(1616) = theta(1242)+theta(1116)*AB(1) ! ((1,0,4)|(2,1,0)) = ((2,0,4)|(1,1,0))+((1,0,4)|(1,1,0))*AB(1)
        theta(1896) = theta(1616)+theta(1466)*AB(1) ! ((0,0,4)|(3,1,0)) = ((1,0,4)|(2,1,0))+((0,0,4)|(2,1,0))*AB(1)
        ! (0,0,4|3,0,1): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,213)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,213)) ! ((1,0,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,213)) ! ((0,0,5)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,213)) ! ((2,0,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,213)) ! ((1,0,5)|(0,0,0))
        theta(574) = dot_product(vrrbuffer(:,79), D(:,213)) ! ((3,0,4)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,213)) ! ((2,0,5)|(0,0,0))
        theta(616) = dot_product(vrrbuffer(:,121), D(:,213)) ! ((3,0,5)|(0,0,0))
        theta(683) = theta(525)+theta(510)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(728) = theta(546)+theta(525)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(746) = theta(552)+theta(531)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(791) = theta(574)+theta(546)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(809) = theta(580)+theta(552)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        theta(893) = theta(616)+theta(580)*AB(1) ! ((2,0,5)|(1,0,0)) = ((3,0,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(1)
        theta(1025) = theta(728)+theta(683)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(1115) = theta(791)+theta(728)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(1151) = theta(809)+theta(746)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        theta(1277) = theta(893)+theta(809)*AB(1) ! ((1,0,5)|(2,0,0)) = ((2,0,5)|(1,0,0))+((1,0,5)|(1,0,0))*AB(1)
        theta(1465) = theta(1115)+theta(1025)*AB(1) ! ((0,0,4)|(3,0,0)) = ((1,0,4)|(2,0,0))+((0,0,4)|(2,0,0))*AB(1)
        theta(1675) = theta(1277)+theta(1151)*AB(1) ! ((0,0,5)|(3,0,0)) = ((1,0,5)|(2,0,0))+((0,0,5)|(2,0,0))*AB(1)
        theta(1897) = theta(1675)+theta(1465)*AB(3) ! ((0,0,4)|(3,0,1)) = ((0,0,5)|(3,0,0))+((0,0,4)|(3,0,0))*AB(3)
        ! (0,0,4|2,2,0): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,214)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,214)) ! ((1,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,214)) ! ((0,1,4)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,214)) ! ((2,0,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,214)) ! ((1,1,4)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,214)) ! ((0,2,4)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,214)) ! ((2,1,4)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,214)) ! ((1,2,4)|(0,0,0))
        theta(621) = dot_product(vrrbuffer(:,126), D(:,214)) ! ((2,2,4)|(0,0,0))
        theta(684) = theta(530)+theta(510)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(729) = theta(551)+theta(525)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(792) = theta(579)+theta(546)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(807) = theta(585)+theta(551)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(891) = theta(621)+theta(579)*AB(2) ! ((2,1,4)|(0,1,0)) = ((2,2,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(2)
        theta(1028) = theta(744)+theta(684)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(1118) = theta(807)+theta(729)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1244) = theta(891)+theta(792)*AB(2) ! ((2,0,4)|(0,2,0)) = ((2,1,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(2)
        theta(1468) = theta(1118)+theta(1028)*AB(1) ! ((0,0,4)|(1,2,0)) = ((1,0,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(1)
        theta(1618) = theta(1244)+theta(1118)*AB(1) ! ((1,0,4)|(1,2,0)) = ((2,0,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(1)
        theta(1898) = theta(1618)+theta(1468)*AB(1) ! ((0,0,4)|(2,2,0)) = ((1,0,4)|(1,2,0))+((0,0,4)|(1,2,0))*AB(1)
        ! (0,0,4|2,1,1): 24
        theta(510) = dot_product(vrrbuffer(:,15), D(:,215)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,215)) ! ((1,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,215)) ! ((0,1,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,215)) ! ((0,0,5)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,215)) ! ((2,0,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,215)) ! ((1,1,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,215)) ! ((1,0,5)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,215)) ! ((0,1,5)|(0,0,0))
        theta(579) = dot_product(vrrbuffer(:,84), D(:,215)) ! ((2,1,4)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,215)) ! ((2,0,5)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,215)) ! ((1,1,5)|(0,0,0))
        theta(622) = dot_product(vrrbuffer(:,127), D(:,215)) ! ((2,1,5)|(0,0,0))
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(892) = theta(622)+theta(579)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(1029) = theta(745)+theta(685)*AB(2) ! ((0,0,4)|(0,1,1)) = ((0,1,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(2)
        theta(1119) = theta(808)+theta(730)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(1245) = theta(892)+theta(793)*AB(2) ! ((2,0,4)|(0,1,1)) = ((2,1,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(2)
        theta(1469) = theta(1119)+theta(1029)*AB(1) ! ((0,0,4)|(1,1,1)) = ((1,0,4)|(0,1,1))+((0,0,4)|(0,1,1))*AB(1)
        theta(1619) = theta(1245)+theta(1119)*AB(1) ! ((1,0,4)|(1,1,1)) = ((2,0,4)|(0,1,1))+((1,0,4)|(0,1,1))*AB(1)
        theta(1899) = theta(1619)+theta(1469)*AB(1) ! ((0,0,4)|(2,1,1)) = ((1,0,4)|(1,1,1))+((0,0,4)|(1,1,1))*AB(1)
        ! (0,0,4|2,0,2): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,216)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,216)) ! ((1,0,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,216)) ! ((0,0,5)|(0,0,0))
        theta(546) = dot_product(vrrbuffer(:,51), D(:,216)) ! ((2,0,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,216)) ! ((1,0,5)|(0,0,0))
        theta(559) = dot_product(vrrbuffer(:,64), D(:,216)) ! ((0,0,6)|(0,0,0))
        theta(580) = dot_product(vrrbuffer(:,85), D(:,216)) ! ((2,0,5)|(0,0,0))
        theta(587) = dot_product(vrrbuffer(:,92), D(:,216)) ! ((1,0,6)|(0,0,0))
        theta(623) = dot_product(vrrbuffer(:,128), D(:,216)) ! ((2,0,6)|(0,0,0))
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(748) = theta(559)+theta(531)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(811) = theta(587)+theta(552)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(895) = theta(623)+theta(580)*AB(3) ! ((2,0,5)|(0,0,1)) = ((2,0,6)|(0,0,0))+((2,0,5)|(0,0,0))*AB(3)
        theta(1030) = theta(748)+theta(685)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(1120) = theta(811)+theta(730)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1246) = theta(895)+theta(793)*AB(3) ! ((2,0,4)|(0,0,2)) = ((2,0,5)|(0,0,1))+((2,0,4)|(0,0,1))*AB(3)
        theta(1470) = theta(1120)+theta(1030)*AB(1) ! ((0,0,4)|(1,0,2)) = ((1,0,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(1)
        theta(1620) = theta(1246)+theta(1120)*AB(1) ! ((1,0,4)|(1,0,2)) = ((2,0,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(1)
        theta(1900) = theta(1620)+theta(1470)*AB(1) ! ((0,0,4)|(2,0,2)) = ((1,0,4)|(1,0,2))+((0,0,4)|(1,0,2))*AB(1)
        ! (0,0,4|1,3,0): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,217)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,217)) ! ((1,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,217)) ! ((0,1,4)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,217)) ! ((1,1,4)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,217)) ! ((0,2,4)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,217)) ! ((1,2,4)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,217)) ! ((0,3,4)|(0,0,0))
        theta(628) = dot_product(vrrbuffer(:,133), D(:,217)) ! ((1,3,4)|(0,0,0))
        theta(684) = theta(530)+theta(510)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(729) = theta(551)+theta(525)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(807) = theta(585)+theta(551)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(825) = theta(592)+theta(557)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(909) = theta(628)+theta(585)*AB(2) ! ((1,2,4)|(0,1,0)) = ((1,3,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(2)
        theta(1028) = theta(744)+theta(684)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(1118) = theta(807)+theta(729)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1148) = theta(825)+theta(744)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(1274) = theta(909)+theta(807)*AB(2) ! ((1,1,4)|(0,2,0)) = ((1,2,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(2)
        theta(1471) = theta(1148)+theta(1028)*AB(2) ! ((0,0,4)|(0,3,0)) = ((0,1,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(2)
        theta(1621) = theta(1274)+theta(1118)*AB(2) ! ((1,0,4)|(0,3,0)) = ((1,1,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(2)
        theta(1901) = theta(1621)+theta(1471)*AB(1) ! ((0,0,4)|(1,3,0)) = ((1,0,4)|(0,3,0))+((0,0,4)|(0,3,0))*AB(1)
        ! (0,0,4|1,2,1): 27
        theta(510) = dot_product(vrrbuffer(:,15), D(:,218)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,218)) ! ((1,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,218)) ! ((0,1,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,218)) ! ((0,0,5)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,218)) ! ((1,1,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,218)) ! ((1,0,5)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,218)) ! ((0,2,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,218)) ! ((0,1,5)|(0,0,0))
        theta(585) = dot_product(vrrbuffer(:,90), D(:,218)) ! ((1,2,4)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,218)) ! ((1,1,5)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,218)) ! ((0,2,5)|(0,0,0))
        theta(629) = dot_product(vrrbuffer(:,134), D(:,218)) ! ((1,2,5)|(0,0,0))
        theta(684) = theta(530)+theta(510)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(729) = theta(551)+theta(525)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(747) = theta(558)+theta(531)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(807) = theta(585)+theta(551)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(810) = theta(586)+theta(552)*AB(2) ! ((1,0,5)|(0,1,0)) = ((1,1,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(2)
        theta(828) = theta(593)+theta(558)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(912) = theta(629)+theta(586)*AB(2) ! ((1,1,5)|(0,1,0)) = ((1,2,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(2)
        theta(1028) = theta(744)+theta(684)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(1118) = theta(807)+theta(729)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1154) = theta(828)+theta(747)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        theta(1280) = theta(912)+theta(810)*AB(2) ! ((1,0,5)|(0,2,0)) = ((1,1,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(2)
        theta(1472) = theta(1154)+theta(1028)*AB(3) ! ((0,0,4)|(0,2,1)) = ((0,0,5)|(0,2,0))+((0,0,4)|(0,2,0))*AB(3)
        theta(1622) = theta(1280)+theta(1118)*AB(3) ! ((1,0,4)|(0,2,1)) = ((1,0,5)|(0,2,0))+((1,0,4)|(0,2,0))*AB(3)
        theta(1902) = theta(1622)+theta(1472)*AB(1) ! ((0,0,4)|(1,2,1)) = ((1,0,4)|(0,2,1))+((0,0,4)|(0,2,1))*AB(1)
        ! (0,0,4|1,1,2): 27
        theta(510) = dot_product(vrrbuffer(:,15), D(:,219)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,219)) ! ((1,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,219)) ! ((0,1,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,219)) ! ((0,0,5)|(0,0,0))
        theta(551) = dot_product(vrrbuffer(:,56), D(:,219)) ! ((1,1,4)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,219)) ! ((1,0,5)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,219)) ! ((0,1,5)|(0,0,0))
        theta(559) = dot_product(vrrbuffer(:,64), D(:,219)) ! ((0,0,6)|(0,0,0))
        theta(586) = dot_product(vrrbuffer(:,91), D(:,219)) ! ((1,1,5)|(0,0,0))
        theta(587) = dot_product(vrrbuffer(:,92), D(:,219)) ! ((1,0,6)|(0,0,0))
        theta(594) = dot_product(vrrbuffer(:,99), D(:,219)) ! ((0,1,6)|(0,0,0))
        theta(630) = dot_product(vrrbuffer(:,135), D(:,219)) ! ((1,1,6)|(0,0,0))
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(748) = theta(559)+theta(531)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(811) = theta(587)+theta(552)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(829) = theta(594)+theta(558)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(913) = theta(630)+theta(586)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        theta(1030) = theta(748)+theta(685)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(1120) = theta(811)+theta(730)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1150) = theta(829)+theta(745)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1276) = theta(913)+theta(808)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(1473) = theta(1150)+theta(1030)*AB(2) ! ((0,0,4)|(0,1,2)) = ((0,1,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(2)
        theta(1623) = theta(1276)+theta(1120)*AB(2) ! ((1,0,4)|(0,1,2)) = ((1,1,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(2)
        theta(1903) = theta(1623)+theta(1473)*AB(1) ! ((0,0,4)|(1,1,2)) = ((1,0,4)|(0,1,2))+((0,0,4)|(0,1,2))*AB(1)
        ! (0,0,4|1,0,3): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,220)) ! ((0,0,4)|(0,0,0))
        theta(525) = dot_product(vrrbuffer(:,30), D(:,220)) ! ((1,0,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,220)) ! ((0,0,5)|(0,0,0))
        theta(552) = dot_product(vrrbuffer(:,57), D(:,220)) ! ((1,0,5)|(0,0,0))
        theta(559) = dot_product(vrrbuffer(:,64), D(:,220)) ! ((0,0,6)|(0,0,0))
        theta(587) = dot_product(vrrbuffer(:,92), D(:,220)) ! ((1,0,6)|(0,0,0))
        theta(595) = dot_product(vrrbuffer(:,100), D(:,220)) ! ((0,0,7)|(0,0,0))
        theta(631) = dot_product(vrrbuffer(:,136), D(:,220)) ! ((1,0,7)|(0,0,0))
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(748) = theta(559)+theta(531)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(811) = theta(587)+theta(552)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(832) = theta(595)+theta(559)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(916) = theta(631)+theta(587)*AB(3) ! ((1,0,6)|(0,0,1)) = ((1,0,7)|(0,0,0))+((1,0,6)|(0,0,0))*AB(3)
        theta(1030) = theta(748)+theta(685)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(1120) = theta(811)+theta(730)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1156) = theta(832)+theta(748)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(1282) = theta(916)+theta(811)*AB(3) ! ((1,0,5)|(0,0,2)) = ((1,0,6)|(0,0,1))+((1,0,5)|(0,0,1))*AB(3)
        theta(1474) = theta(1156)+theta(1030)*AB(3) ! ((0,0,4)|(0,0,3)) = ((0,0,5)|(0,0,2))+((0,0,4)|(0,0,2))*AB(3)
        theta(1624) = theta(1282)+theta(1120)*AB(3) ! ((1,0,4)|(0,0,3)) = ((1,0,5)|(0,0,2))+((1,0,4)|(0,0,2))*AB(3)
        theta(1904) = theta(1624)+theta(1474)*AB(1) ! ((0,0,4)|(1,0,3)) = ((1,0,4)|(0,0,3))+((0,0,4)|(0,0,3))*AB(1)
        ! (0,0,4|0,4,0): 15
        theta(510) = dot_product(vrrbuffer(:,15), D(:,221)) ! ((0,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,221)) ! ((0,1,4)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,221)) ! ((0,2,4)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,221)) ! ((0,3,4)|(0,0,0))
        theta(636) = dot_product(vrrbuffer(:,141), D(:,221)) ! ((0,4,4)|(0,0,0))
        theta(684) = theta(530)+theta(510)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(825) = theta(592)+theta(557)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(930) = theta(636)+theta(592)*AB(2) ! ((0,3,4)|(0,1,0)) = ((0,4,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(2)
        theta(1028) = theta(744)+theta(684)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(1148) = theta(825)+theta(744)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(1310) = theta(930)+theta(825)*AB(2) ! ((0,2,4)|(0,2,0)) = ((0,3,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(2)
        theta(1471) = theta(1148)+theta(1028)*AB(2) ! ((0,0,4)|(0,3,0)) = ((0,1,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(2)
        theta(1671) = theta(1310)+theta(1148)*AB(2) ! ((0,1,4)|(0,3,0)) = ((0,2,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(2)
        theta(1905) = theta(1671)+theta(1471)*AB(2) ! ((0,0,4)|(0,4,0)) = ((0,1,4)|(0,3,0))+((0,0,4)|(0,3,0))*AB(2)
        ! (0,0,4|0,3,1): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,222)) ! ((0,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,222)) ! ((0,1,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,222)) ! ((0,0,5)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,222)) ! ((0,2,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,222)) ! ((0,1,5)|(0,0,0))
        theta(592) = dot_product(vrrbuffer(:,97), D(:,222)) ! ((0,3,4)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,222)) ! ((0,2,5)|(0,0,0))
        theta(637) = dot_product(vrrbuffer(:,142), D(:,222)) ! ((0,3,5)|(0,0,0))
        theta(684) = theta(530)+theta(510)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(747) = theta(558)+theta(531)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(825) = theta(592)+theta(557)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(828) = theta(593)+theta(558)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(933) = theta(637)+theta(593)*AB(2) ! ((0,2,5)|(0,1,0)) = ((0,3,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(2)
        theta(1028) = theta(744)+theta(684)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(1148) = theta(825)+theta(744)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(1154) = theta(828)+theta(747)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        theta(1316) = theta(933)+theta(828)*AB(2) ! ((0,1,5)|(0,2,0)) = ((0,2,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(2)
        theta(1471) = theta(1148)+theta(1028)*AB(2) ! ((0,0,4)|(0,3,0)) = ((0,1,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(2)
        theta(1681) = theta(1316)+theta(1154)*AB(2) ! ((0,0,5)|(0,3,0)) = ((0,1,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(2)
        theta(1906) = theta(1681)+theta(1471)*AB(3) ! ((0,0,4)|(0,3,1)) = ((0,0,5)|(0,3,0))+((0,0,4)|(0,3,0))*AB(3)
        ! (0,0,4|0,2,2): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,223)) ! ((0,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,223)) ! ((0,1,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,223)) ! ((0,0,5)|(0,0,0))
        theta(557) = dot_product(vrrbuffer(:,62), D(:,223)) ! ((0,2,4)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,223)) ! ((0,1,5)|(0,0,0))
        theta(559) = dot_product(vrrbuffer(:,64), D(:,223)) ! ((0,0,6)|(0,0,0))
        theta(593) = dot_product(vrrbuffer(:,98), D(:,223)) ! ((0,2,5)|(0,0,0))
        theta(594) = dot_product(vrrbuffer(:,99), D(:,223)) ! ((0,1,6)|(0,0,0))
        theta(638) = dot_product(vrrbuffer(:,143), D(:,223)) ! ((0,2,6)|(0,0,0))
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(748) = theta(559)+theta(531)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(829) = theta(594)+theta(558)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(934) = theta(638)+theta(593)*AB(3) ! ((0,2,5)|(0,0,1)) = ((0,2,6)|(0,0,0))+((0,2,5)|(0,0,0))*AB(3)
        theta(1030) = theta(748)+theta(685)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(1150) = theta(829)+theta(745)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1312) = theta(934)+theta(826)*AB(3) ! ((0,2,4)|(0,0,2)) = ((0,2,5)|(0,0,1))+((0,2,4)|(0,0,1))*AB(3)
        theta(1473) = theta(1150)+theta(1030)*AB(2) ! ((0,0,4)|(0,1,2)) = ((0,1,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(2)
        theta(1673) = theta(1312)+theta(1150)*AB(2) ! ((0,1,4)|(0,1,2)) = ((0,2,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(2)
        theta(1907) = theta(1673)+theta(1473)*AB(2) ! ((0,0,4)|(0,2,2)) = ((0,1,4)|(0,1,2))+((0,0,4)|(0,1,2))*AB(2)
        ! (0,0,4|0,1,3): 21
        theta(510) = dot_product(vrrbuffer(:,15), D(:,224)) ! ((0,0,4)|(0,0,0))
        theta(530) = dot_product(vrrbuffer(:,35), D(:,224)) ! ((0,1,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,224)) ! ((0,0,5)|(0,0,0))
        theta(558) = dot_product(vrrbuffer(:,63), D(:,224)) ! ((0,1,5)|(0,0,0))
        theta(559) = dot_product(vrrbuffer(:,64), D(:,224)) ! ((0,0,6)|(0,0,0))
        theta(594) = dot_product(vrrbuffer(:,99), D(:,224)) ! ((0,1,6)|(0,0,0))
        theta(595) = dot_product(vrrbuffer(:,100), D(:,224)) ! ((0,0,7)|(0,0,0))
        theta(639) = dot_product(vrrbuffer(:,144), D(:,224)) ! ((0,1,7)|(0,0,0))
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(748) = theta(559)+theta(531)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(829) = theta(594)+theta(558)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(832) = theta(595)+theta(559)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(937) = theta(639)+theta(594)*AB(3) ! ((0,1,6)|(0,0,1)) = ((0,1,7)|(0,0,0))+((0,1,6)|(0,0,0))*AB(3)
        theta(1030) = theta(748)+theta(685)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(1150) = theta(829)+theta(745)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1156) = theta(832)+theta(748)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(1318) = theta(937)+theta(829)*AB(3) ! ((0,1,5)|(0,0,2)) = ((0,1,6)|(0,0,1))+((0,1,5)|(0,0,1))*AB(3)
        theta(1474) = theta(1156)+theta(1030)*AB(3) ! ((0,0,4)|(0,0,3)) = ((0,0,5)|(0,0,2))+((0,0,4)|(0,0,2))*AB(3)
        theta(1674) = theta(1318)+theta(1150)*AB(3) ! ((0,1,4)|(0,0,3)) = ((0,1,5)|(0,0,2))+((0,1,4)|(0,0,2))*AB(3)
        theta(1908) = theta(1674)+theta(1474)*AB(2) ! ((0,0,4)|(0,1,3)) = ((0,1,4)|(0,0,3))+((0,0,4)|(0,0,3))*AB(2)
        ! (0,0,4|0,0,4): 15
        theta(510) = dot_product(vrrbuffer(:,15), D(:,225)) ! ((0,0,4)|(0,0,0))
        theta(531) = dot_product(vrrbuffer(:,36), D(:,225)) ! ((0,0,5)|(0,0,0))
        theta(559) = dot_product(vrrbuffer(:,64), D(:,225)) ! ((0,0,6)|(0,0,0))
        theta(595) = dot_product(vrrbuffer(:,100), D(:,225)) ! ((0,0,7)|(0,0,0))
        theta(640) = dot_product(vrrbuffer(:,145), D(:,225)) ! ((0,0,8)|(0,0,0))
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(748) = theta(559)+theta(531)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(832) = theta(595)+theta(559)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(940) = theta(640)+theta(595)*AB(3) ! ((0,0,7)|(0,0,1)) = ((0,0,8)|(0,0,0))+((0,0,7)|(0,0,0))*AB(3)
        theta(1030) = theta(748)+theta(685)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(1156) = theta(832)+theta(748)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(1324) = theta(940)+theta(832)*AB(3) ! ((0,0,6)|(0,0,2)) = ((0,0,7)|(0,0,1))+((0,0,6)|(0,0,1))*AB(3)
        theta(1474) = theta(1156)+theta(1030)*AB(3) ! ((0,0,4)|(0,0,3)) = ((0,0,5)|(0,0,2))+((0,0,4)|(0,0,2))*AB(3)
        theta(1684) = theta(1324)+theta(1156)*AB(3) ! ((0,0,5)|(0,0,3)) = ((0,0,6)|(0,0,2))+((0,0,5)|(0,0,2))*AB(3)
        theta(1909) = theta(1684)+theta(1474)*AB(3) ! ((0,0,4)|(0,0,4)) = ((0,0,5)|(0,0,3))+((0,0,4)|(0,0,3))*AB(3)
    end subroutine
    subroutine blockhrr_5_0(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 21; Optimized integrals: 21
        ! (5,0,0|0,0,0): 1
        theta(127) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((5,0,0)|(0,0,0))
        ! (4,1,0|0,0,0): 1
        theta(128) = dot_product(vrrbuffer(:,2), D(:,2)) ! ((4,1,0)|(0,0,0))
        ! (4,0,1|0,0,0): 1
        theta(129) = dot_product(vrrbuffer(:,3), D(:,3)) ! ((4,0,1)|(0,0,0))
        ! (3,2,0|0,0,0): 1
        theta(130) = dot_product(vrrbuffer(:,4), D(:,4)) ! ((3,2,0)|(0,0,0))
        ! (3,1,1|0,0,0): 1
        theta(131) = dot_product(vrrbuffer(:,5), D(:,5)) ! ((3,1,1)|(0,0,0))
        ! (3,0,2|0,0,0): 1
        theta(132) = dot_product(vrrbuffer(:,6), D(:,6)) ! ((3,0,2)|(0,0,0))
        ! (2,3,0|0,0,0): 1
        theta(133) = dot_product(vrrbuffer(:,7), D(:,7)) ! ((2,3,0)|(0,0,0))
        ! (2,2,1|0,0,0): 1
        theta(134) = dot_product(vrrbuffer(:,8), D(:,8)) ! ((2,2,1)|(0,0,0))
        ! (2,1,2|0,0,0): 1
        theta(135) = dot_product(vrrbuffer(:,9), D(:,9)) ! ((2,1,2)|(0,0,0))
        ! (2,0,3|0,0,0): 1
        theta(136) = dot_product(vrrbuffer(:,10), D(:,10)) ! ((2,0,3)|(0,0,0))
        ! (1,4,0|0,0,0): 1
        theta(137) = dot_product(vrrbuffer(:,11), D(:,11)) ! ((1,4,0)|(0,0,0))
        ! (1,3,1|0,0,0): 1
        theta(138) = dot_product(vrrbuffer(:,12), D(:,12)) ! ((1,3,1)|(0,0,0))
        ! (1,2,2|0,0,0): 1
        theta(139) = dot_product(vrrbuffer(:,13), D(:,13)) ! ((1,2,2)|(0,0,0))
        ! (1,1,3|0,0,0): 1
        theta(140) = dot_product(vrrbuffer(:,14), D(:,14)) ! ((1,1,3)|(0,0,0))
        ! (1,0,4|0,0,0): 1
        theta(141) = dot_product(vrrbuffer(:,15), D(:,15)) ! ((1,0,4)|(0,0,0))
        ! (0,5,0|0,0,0): 1
        theta(142) = dot_product(vrrbuffer(:,16), D(:,16)) ! ((0,5,0)|(0,0,0))
        ! (0,4,1|0,0,0): 1
        theta(143) = dot_product(vrrbuffer(:,17), D(:,17)) ! ((0,4,1)|(0,0,0))
        ! (0,3,2|0,0,0): 1
        theta(144) = dot_product(vrrbuffer(:,18), D(:,18)) ! ((0,3,2)|(0,0,0))
        ! (0,2,3|0,0,0): 1
        theta(145) = dot_product(vrrbuffer(:,19), D(:,19)) ! ((0,2,3)|(0,0,0))
        ! (0,1,4|0,0,0): 1
        theta(146) = dot_product(vrrbuffer(:,20), D(:,20)) ! ((0,1,4)|(0,0,0))
        ! (0,0,5|0,0,0): 1
        theta(147) = dot_product(vrrbuffer(:,21), D(:,21)) ! ((0,0,5)|(0,0,0))
    end subroutine
    subroutine blockhrr_5_1(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 112; Optimized integrals: 112
        ! (5,0,0|1,0,0): 3
        theta(211) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(232) = dot_product(vrrbuffer(:,22), D(:,1)) ! ((6,0,0)|(0,0,0))
        theta(260) = theta(232)+theta(211)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        ! (5,0,0|0,1,0): 3
        theta(211) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((5,0,0)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,2)) ! ((5,1,0)|(0,0,0))
        theta(261) = theta(233)+theta(211)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        ! (5,0,0|0,0,1): 3
        theta(211) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((5,0,0)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,3)) ! ((5,0,1)|(0,0,0))
        theta(262) = theta(234)+theta(211)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        ! (4,1,0|1,0,0): 3
        theta(212) = dot_product(vrrbuffer(:,2), D(:,4)) ! ((4,1,0)|(0,0,0))
        theta(233) = dot_product(vrrbuffer(:,23), D(:,4)) ! ((5,1,0)|(0,0,0))
        theta(263) = theta(233)+theta(212)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        ! (4,1,0|0,1,0): 3
        theta(212) = dot_product(vrrbuffer(:,2), D(:,5)) ! ((4,1,0)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,5)) ! ((4,2,0)|(0,0,0))
        theta(264) = theta(235)+theta(212)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        ! (4,1,0|0,0,1): 3
        theta(212) = dot_product(vrrbuffer(:,2), D(:,6)) ! ((4,1,0)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,6)) ! ((4,1,1)|(0,0,0))
        theta(265) = theta(236)+theta(212)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        ! (4,0,1|1,0,0): 3
        theta(213) = dot_product(vrrbuffer(:,3), D(:,7)) ! ((4,0,1)|(0,0,0))
        theta(234) = dot_product(vrrbuffer(:,24), D(:,7)) ! ((5,0,1)|(0,0,0))
        theta(266) = theta(234)+theta(213)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        ! (4,0,1|0,1,0): 3
        theta(213) = dot_product(vrrbuffer(:,3), D(:,8)) ! ((4,0,1)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,8)) ! ((4,1,1)|(0,0,0))
        theta(267) = theta(236)+theta(213)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        ! (4,0,1|0,0,1): 3
        theta(213) = dot_product(vrrbuffer(:,3), D(:,9)) ! ((4,0,1)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,9)) ! ((4,0,2)|(0,0,0))
        theta(268) = theta(237)+theta(213)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        ! (3,2,0|1,0,0): 3
        theta(214) = dot_product(vrrbuffer(:,4), D(:,10)) ! ((3,2,0)|(0,0,0))
        theta(235) = dot_product(vrrbuffer(:,25), D(:,10)) ! ((4,2,0)|(0,0,0))
        theta(269) = theta(235)+theta(214)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        ! (3,2,0|0,1,0): 3
        theta(214) = dot_product(vrrbuffer(:,4), D(:,11)) ! ((3,2,0)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,11)) ! ((3,3,0)|(0,0,0))
        theta(270) = theta(238)+theta(214)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        ! (3,2,0|0,0,1): 3
        theta(214) = dot_product(vrrbuffer(:,4), D(:,12)) ! ((3,2,0)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,12)) ! ((3,2,1)|(0,0,0))
        theta(271) = theta(239)+theta(214)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        ! (3,1,1|1,0,0): 3
        theta(215) = dot_product(vrrbuffer(:,5), D(:,13)) ! ((3,1,1)|(0,0,0))
        theta(236) = dot_product(vrrbuffer(:,26), D(:,13)) ! ((4,1,1)|(0,0,0))
        theta(272) = theta(236)+theta(215)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        ! (3,1,1|0,1,0): 3
        theta(215) = dot_product(vrrbuffer(:,5), D(:,14)) ! ((3,1,1)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,14)) ! ((3,2,1)|(0,0,0))
        theta(273) = theta(239)+theta(215)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        ! (3,1,1|0,0,1): 3
        theta(215) = dot_product(vrrbuffer(:,5), D(:,15)) ! ((3,1,1)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,15)) ! ((3,1,2)|(0,0,0))
        theta(274) = theta(240)+theta(215)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        ! (3,0,2|1,0,0): 3
        theta(216) = dot_product(vrrbuffer(:,6), D(:,16)) ! ((3,0,2)|(0,0,0))
        theta(237) = dot_product(vrrbuffer(:,27), D(:,16)) ! ((4,0,2)|(0,0,0))
        theta(275) = theta(237)+theta(216)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        ! (3,0,2|0,1,0): 3
        theta(216) = dot_product(vrrbuffer(:,6), D(:,17)) ! ((3,0,2)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,17)) ! ((3,1,2)|(0,0,0))
        theta(276) = theta(240)+theta(216)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        ! (3,0,2|0,0,1): 3
        theta(216) = dot_product(vrrbuffer(:,6), D(:,18)) ! ((3,0,2)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,18)) ! ((3,0,3)|(0,0,0))
        theta(277) = theta(241)+theta(216)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        ! (2,3,0|1,0,0): 3
        theta(217) = dot_product(vrrbuffer(:,7), D(:,19)) ! ((2,3,0)|(0,0,0))
        theta(238) = dot_product(vrrbuffer(:,28), D(:,19)) ! ((3,3,0)|(0,0,0))
        theta(278) = theta(238)+theta(217)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        ! (2,3,0|0,1,0): 3
        theta(217) = dot_product(vrrbuffer(:,7), D(:,20)) ! ((2,3,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,20)) ! ((2,4,0)|(0,0,0))
        theta(279) = theta(242)+theta(217)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        ! (2,3,0|0,0,1): 3
        theta(217) = dot_product(vrrbuffer(:,7), D(:,21)) ! ((2,3,0)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,21)) ! ((2,3,1)|(0,0,0))
        theta(280) = theta(243)+theta(217)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        ! (2,2,1|1,0,0): 3
        theta(218) = dot_product(vrrbuffer(:,8), D(:,22)) ! ((2,2,1)|(0,0,0))
        theta(239) = dot_product(vrrbuffer(:,29), D(:,22)) ! ((3,2,1)|(0,0,0))
        theta(281) = theta(239)+theta(218)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        ! (2,2,1|0,1,0): 3
        theta(218) = dot_product(vrrbuffer(:,8), D(:,23)) ! ((2,2,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,23)) ! ((2,3,1)|(0,0,0))
        theta(282) = theta(243)+theta(218)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        ! (2,2,1|0,0,1): 3
        theta(218) = dot_product(vrrbuffer(:,8), D(:,24)) ! ((2,2,1)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,24)) ! ((2,2,2)|(0,0,0))
        theta(283) = theta(244)+theta(218)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        ! (2,1,2|1,0,0): 3
        theta(219) = dot_product(vrrbuffer(:,9), D(:,25)) ! ((2,1,2)|(0,0,0))
        theta(240) = dot_product(vrrbuffer(:,30), D(:,25)) ! ((3,1,2)|(0,0,0))
        theta(284) = theta(240)+theta(219)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        ! (2,1,2|0,1,0): 3
        theta(219) = dot_product(vrrbuffer(:,9), D(:,26)) ! ((2,1,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,26)) ! ((2,2,2)|(0,0,0))
        theta(285) = theta(244)+theta(219)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        ! (2,1,2|0,0,1): 3
        theta(219) = dot_product(vrrbuffer(:,9), D(:,27)) ! ((2,1,2)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,27)) ! ((2,1,3)|(0,0,0))
        theta(286) = theta(245)+theta(219)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        ! (2,0,3|1,0,0): 3
        theta(220) = dot_product(vrrbuffer(:,10), D(:,28)) ! ((2,0,3)|(0,0,0))
        theta(241) = dot_product(vrrbuffer(:,31), D(:,28)) ! ((3,0,3)|(0,0,0))
        theta(287) = theta(241)+theta(220)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        ! (2,0,3|0,1,0): 3
        theta(220) = dot_product(vrrbuffer(:,10), D(:,29)) ! ((2,0,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,29)) ! ((2,1,3)|(0,0,0))
        theta(288) = theta(245)+theta(220)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        ! (2,0,3|0,0,1): 3
        theta(220) = dot_product(vrrbuffer(:,10), D(:,30)) ! ((2,0,3)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,30)) ! ((2,0,4)|(0,0,0))
        theta(289) = theta(246)+theta(220)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        ! (1,4,0|1,0,0): 3
        theta(221) = dot_product(vrrbuffer(:,11), D(:,31)) ! ((1,4,0)|(0,0,0))
        theta(242) = dot_product(vrrbuffer(:,32), D(:,31)) ! ((2,4,0)|(0,0,0))
        theta(290) = theta(242)+theta(221)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        ! (1,4,0|0,1,0): 3
        theta(221) = dot_product(vrrbuffer(:,11), D(:,32)) ! ((1,4,0)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,32)) ! ((1,5,0)|(0,0,0))
        theta(291) = theta(247)+theta(221)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        ! (1,4,0|0,0,1): 3
        theta(221) = dot_product(vrrbuffer(:,11), D(:,33)) ! ((1,4,0)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,33)) ! ((1,4,1)|(0,0,0))
        theta(292) = theta(248)+theta(221)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        ! (1,3,1|1,0,0): 3
        theta(222) = dot_product(vrrbuffer(:,12), D(:,34)) ! ((1,3,1)|(0,0,0))
        theta(243) = dot_product(vrrbuffer(:,33), D(:,34)) ! ((2,3,1)|(0,0,0))
        theta(293) = theta(243)+theta(222)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        ! (1,3,1|0,1,0): 3
        theta(222) = dot_product(vrrbuffer(:,12), D(:,35)) ! ((1,3,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,35)) ! ((1,4,1)|(0,0,0))
        theta(294) = theta(248)+theta(222)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        ! (1,3,1|0,0,1): 3
        theta(222) = dot_product(vrrbuffer(:,12), D(:,36)) ! ((1,3,1)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,36)) ! ((1,3,2)|(0,0,0))
        theta(295) = theta(249)+theta(222)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        ! (1,2,2|1,0,0): 3
        theta(223) = dot_product(vrrbuffer(:,13), D(:,37)) ! ((1,2,2)|(0,0,0))
        theta(244) = dot_product(vrrbuffer(:,34), D(:,37)) ! ((2,2,2)|(0,0,0))
        theta(296) = theta(244)+theta(223)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        ! (1,2,2|0,1,0): 3
        theta(223) = dot_product(vrrbuffer(:,13), D(:,38)) ! ((1,2,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,38)) ! ((1,3,2)|(0,0,0))
        theta(297) = theta(249)+theta(223)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        ! (1,2,2|0,0,1): 3
        theta(223) = dot_product(vrrbuffer(:,13), D(:,39)) ! ((1,2,2)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,39)) ! ((1,2,3)|(0,0,0))
        theta(298) = theta(250)+theta(223)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        ! (1,1,3|1,0,0): 3
        theta(224) = dot_product(vrrbuffer(:,14), D(:,40)) ! ((1,1,3)|(0,0,0))
        theta(245) = dot_product(vrrbuffer(:,35), D(:,40)) ! ((2,1,3)|(0,0,0))
        theta(299) = theta(245)+theta(224)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        ! (1,1,3|0,1,0): 3
        theta(224) = dot_product(vrrbuffer(:,14), D(:,41)) ! ((1,1,3)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,41)) ! ((1,2,3)|(0,0,0))
        theta(300) = theta(250)+theta(224)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        ! (1,1,3|0,0,1): 3
        theta(224) = dot_product(vrrbuffer(:,14), D(:,42)) ! ((1,1,3)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,42)) ! ((1,1,4)|(0,0,0))
        theta(301) = theta(251)+theta(224)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        ! (1,0,4|1,0,0): 3
        theta(225) = dot_product(vrrbuffer(:,15), D(:,43)) ! ((1,0,4)|(0,0,0))
        theta(246) = dot_product(vrrbuffer(:,36), D(:,43)) ! ((2,0,4)|(0,0,0))
        theta(302) = theta(246)+theta(225)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        ! (1,0,4|0,1,0): 3
        theta(225) = dot_product(vrrbuffer(:,15), D(:,44)) ! ((1,0,4)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,44)) ! ((1,1,4)|(0,0,0))
        theta(303) = theta(251)+theta(225)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        ! (1,0,4|0,0,1): 3
        theta(225) = dot_product(vrrbuffer(:,15), D(:,45)) ! ((1,0,4)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,45)) ! ((1,0,5)|(0,0,0))
        theta(304) = theta(252)+theta(225)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        ! (0,5,0|1,0,0): 3
        theta(226) = dot_product(vrrbuffer(:,16), D(:,46)) ! ((0,5,0)|(0,0,0))
        theta(247) = dot_product(vrrbuffer(:,37), D(:,46)) ! ((1,5,0)|(0,0,0))
        theta(305) = theta(247)+theta(226)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        ! (0,5,0|0,1,0): 3
        theta(226) = dot_product(vrrbuffer(:,16), D(:,47)) ! ((0,5,0)|(0,0,0))
        theta(253) = dot_product(vrrbuffer(:,43), D(:,47)) ! ((0,6,0)|(0,0,0))
        theta(306) = theta(253)+theta(226)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        ! (0,5,0|0,0,1): 3
        theta(226) = dot_product(vrrbuffer(:,16), D(:,48)) ! ((0,5,0)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,48)) ! ((0,5,1)|(0,0,0))
        theta(307) = theta(254)+theta(226)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        ! (0,4,1|1,0,0): 3
        theta(227) = dot_product(vrrbuffer(:,17), D(:,49)) ! ((0,4,1)|(0,0,0))
        theta(248) = dot_product(vrrbuffer(:,38), D(:,49)) ! ((1,4,1)|(0,0,0))
        theta(308) = theta(248)+theta(227)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        ! (0,4,1|0,1,0): 3
        theta(227) = dot_product(vrrbuffer(:,17), D(:,50)) ! ((0,4,1)|(0,0,0))
        theta(254) = dot_product(vrrbuffer(:,44), D(:,50)) ! ((0,5,1)|(0,0,0))
        theta(309) = theta(254)+theta(227)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        ! (0,4,1|0,0,1): 3
        theta(227) = dot_product(vrrbuffer(:,17), D(:,51)) ! ((0,4,1)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,51)) ! ((0,4,2)|(0,0,0))
        theta(310) = theta(255)+theta(227)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        ! (0,3,2|1,0,0): 3
        theta(228) = dot_product(vrrbuffer(:,18), D(:,52)) ! ((0,3,2)|(0,0,0))
        theta(249) = dot_product(vrrbuffer(:,39), D(:,52)) ! ((1,3,2)|(0,0,0))
        theta(311) = theta(249)+theta(228)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        ! (0,3,2|0,1,0): 3
        theta(228) = dot_product(vrrbuffer(:,18), D(:,53)) ! ((0,3,2)|(0,0,0))
        theta(255) = dot_product(vrrbuffer(:,45), D(:,53)) ! ((0,4,2)|(0,0,0))
        theta(312) = theta(255)+theta(228)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        ! (0,3,2|0,0,1): 3
        theta(228) = dot_product(vrrbuffer(:,18), D(:,54)) ! ((0,3,2)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,54)) ! ((0,3,3)|(0,0,0))
        theta(313) = theta(256)+theta(228)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        ! (0,2,3|1,0,0): 3
        theta(229) = dot_product(vrrbuffer(:,19), D(:,55)) ! ((0,2,3)|(0,0,0))
        theta(250) = dot_product(vrrbuffer(:,40), D(:,55)) ! ((1,2,3)|(0,0,0))
        theta(314) = theta(250)+theta(229)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        ! (0,2,3|0,1,0): 3
        theta(229) = dot_product(vrrbuffer(:,19), D(:,56)) ! ((0,2,3)|(0,0,0))
        theta(256) = dot_product(vrrbuffer(:,46), D(:,56)) ! ((0,3,3)|(0,0,0))
        theta(315) = theta(256)+theta(229)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        ! (0,2,3|0,0,1): 3
        theta(229) = dot_product(vrrbuffer(:,19), D(:,57)) ! ((0,2,3)|(0,0,0))
        theta(257) = dot_product(vrrbuffer(:,47), D(:,57)) ! ((0,2,4)|(0,0,0))
        theta(316) = theta(257)+theta(229)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        ! (0,1,4|1,0,0): 3
        theta(230) = dot_product(vrrbuffer(:,20), D(:,58)) ! ((0,1,4)|(0,0,0))
        theta(251) = dot_product(vrrbuffer(:,41), D(:,58)) ! ((1,1,4)|(0,0,0))
        theta(317) = theta(251)+theta(230)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        ! (0,1,4|0,1,0): 3
        theta(230) = dot_product(vrrbuffer(:,20), D(:,59)) ! ((0,1,4)|(0,0,0))
        theta(257) = dot_product(vrrbuffer(:,47), D(:,59)) ! ((0,2,4)|(0,0,0))
        theta(318) = theta(257)+theta(230)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        ! (0,1,4|0,0,1): 3
        theta(230) = dot_product(vrrbuffer(:,20), D(:,60)) ! ((0,1,4)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,60)) ! ((0,1,5)|(0,0,0))
        theta(319) = theta(258)+theta(230)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        ! (0,0,5|1,0,0): 3
        theta(231) = dot_product(vrrbuffer(:,21), D(:,61)) ! ((0,0,5)|(0,0,0))
        theta(252) = dot_product(vrrbuffer(:,42), D(:,61)) ! ((1,0,5)|(0,0,0))
        theta(320) = theta(252)+theta(231)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        ! (0,0,5|0,1,0): 3
        theta(231) = dot_product(vrrbuffer(:,21), D(:,62)) ! ((0,0,5)|(0,0,0))
        theta(258) = dot_product(vrrbuffer(:,48), D(:,62)) ! ((0,1,5)|(0,0,0))
        theta(321) = theta(258)+theta(231)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        ! (0,0,5|0,0,1): 3
        theta(231) = dot_product(vrrbuffer(:,21), D(:,63)) ! ((0,0,5)|(0,0,0))
        theta(259) = dot_product(vrrbuffer(:,49), D(:,63)) ! ((0,0,6)|(0,0,0))
        theta(322) = theta(259)+theta(231)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
    end subroutine
    subroutine blockhrr_5_2(AB, vrrbuffer, D, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(in) :: vrrbuffer(:,:)
        real*8,intent(in) :: D(:,:)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 358; Optimized integrals: 350
        ! (5,0,0|2,0,0): 6
        theta(331) = dot_product(vrrbuffer(:,1), D(:,1)) ! ((5,0,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,1)) ! ((6,0,0)|(0,0,0))
        theta(380) = dot_product(vrrbuffer(:,50), D(:,1)) ! ((7,0,0)|(0,0,0))
        theta(416) = theta(352)+theta(331)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(479) = theta(380)+theta(352)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(563) = theta(479)+theta(416)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        ! (5,0,0|1,1,0): 7
        theta(331) = dot_product(vrrbuffer(:,1), D(:,2)) ! ((5,0,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,2)) ! ((6,0,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,2)) ! ((5,1,0)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,2)) ! ((6,1,0)|(0,0,0))
        theta(417) = theta(353)+theta(331)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(480) = theta(381)+theta(352)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        theta(564) = theta(480)+theta(417)*AB(1) ! ((5,0,0)|(1,1,0)) = ((6,0,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(1)
        ! (5,0,0|1,0,1): 7
        theta(331) = dot_product(vrrbuffer(:,1), D(:,3)) ! ((5,0,0)|(0,0,0))
        theta(352) = dot_product(vrrbuffer(:,22), D(:,3)) ! ((6,0,0)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,3)) ! ((5,0,1)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,3)) ! ((6,0,1)|(0,0,0))
        theta(418) = theta(354)+theta(331)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(481) = theta(382)+theta(352)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(565) = theta(481)+theta(418)*AB(1) ! ((5,0,0)|(1,0,1)) = ((6,0,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(1)
        ! (5,0,0|0,2,0): 6
        theta(331) = dot_product(vrrbuffer(:,1), D(:,4)) ! ((5,0,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,4)) ! ((5,1,0)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,4)) ! ((5,2,0)|(0,0,0))
        theta(417) = theta(353)+theta(331)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(483) = theta(383)+theta(353)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(566) = theta(483)+theta(417)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        ! (5,0,0|0,1,1): 7
        theta(331) = dot_product(vrrbuffer(:,1), D(:,5)) ! ((5,0,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,5)) ! ((5,1,0)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,5)) ! ((5,0,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,5)) ! ((5,1,1)|(0,0,0))
        theta(418) = theta(354)+theta(331)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(484) = theta(384)+theta(353)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(567) = theta(484)+theta(418)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        ! (5,0,0|0,0,2): 6
        theta(331) = dot_product(vrrbuffer(:,1), D(:,6)) ! ((5,0,0)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,6)) ! ((5,0,1)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,6)) ! ((5,0,2)|(0,0,0))
        theta(418) = theta(354)+theta(331)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(487) = theta(385)+theta(354)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(568) = theta(487)+theta(418)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        ! (4,1,0|2,0,0): 6
        theta(332) = dot_product(vrrbuffer(:,2), D(:,7)) ! ((4,1,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,7)) ! ((5,1,0)|(0,0,0))
        theta(381) = dot_product(vrrbuffer(:,51), D(:,7)) ! ((6,1,0)|(0,0,0))
        theta(419) = theta(353)+theta(332)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(482) = theta(381)+theta(353)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(569) = theta(482)+theta(419)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        ! (4,1,0|1,1,0): 7
        theta(332) = dot_product(vrrbuffer(:,2), D(:,8)) ! ((4,1,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,8)) ! ((5,1,0)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,8)) ! ((4,2,0)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,8)) ! ((5,2,0)|(0,0,0))
        theta(420) = theta(355)+theta(332)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(483) = theta(383)+theta(353)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(570) = theta(483)+theta(420)*AB(1) ! ((4,1,0)|(1,1,0)) = ((5,1,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(1)
        ! (4,1,0|1,0,1): 7
        theta(332) = dot_product(vrrbuffer(:,2), D(:,9)) ! ((4,1,0)|(0,0,0))
        theta(353) = dot_product(vrrbuffer(:,23), D(:,9)) ! ((5,1,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,9)) ! ((4,1,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,9)) ! ((5,1,1)|(0,0,0))
        theta(421) = theta(356)+theta(332)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(484) = theta(384)+theta(353)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(571) = theta(484)+theta(421)*AB(1) ! ((4,1,0)|(1,0,1)) = ((5,1,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(1)
        ! (4,1,0|0,2,0): 6
        theta(332) = dot_product(vrrbuffer(:,2), D(:,10)) ! ((4,1,0)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,10)) ! ((4,2,0)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,10)) ! ((4,3,0)|(0,0,0))
        theta(420) = theta(355)+theta(332)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(489) = theta(386)+theta(355)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(572) = theta(489)+theta(420)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        ! (4,1,0|0,1,1): 7
        theta(332) = dot_product(vrrbuffer(:,2), D(:,11)) ! ((4,1,0)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,11)) ! ((4,2,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,11)) ! ((4,1,1)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,11)) ! ((4,2,1)|(0,0,0))
        theta(421) = theta(356)+theta(332)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(490) = theta(387)+theta(355)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(573) = theta(490)+theta(421)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        ! (4,1,0|0,0,2): 6
        theta(332) = dot_product(vrrbuffer(:,2), D(:,12)) ! ((4,1,0)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,12)) ! ((4,1,1)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,12)) ! ((4,1,2)|(0,0,0))
        theta(421) = theta(356)+theta(332)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(493) = theta(388)+theta(356)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(574) = theta(493)+theta(421)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        ! (4,0,1|2,0,0): 6
        theta(333) = dot_product(vrrbuffer(:,3), D(:,13)) ! ((4,0,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,13)) ! ((5,0,1)|(0,0,0))
        theta(382) = dot_product(vrrbuffer(:,52), D(:,13)) ! ((6,0,1)|(0,0,0))
        theta(422) = theta(354)+theta(333)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(485) = theta(382)+theta(354)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(575) = theta(485)+theta(422)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        ! (4,0,1|1,1,0): 7
        theta(333) = dot_product(vrrbuffer(:,3), D(:,14)) ! ((4,0,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,14)) ! ((5,0,1)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,14)) ! ((4,1,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,14)) ! ((5,1,1)|(0,0,0))
        theta(423) = theta(356)+theta(333)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(486) = theta(384)+theta(354)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(576) = theta(486)+theta(423)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        ! (4,0,1|1,0,1): 7
        theta(333) = dot_product(vrrbuffer(:,3), D(:,15)) ! ((4,0,1)|(0,0,0))
        theta(354) = dot_product(vrrbuffer(:,24), D(:,15)) ! ((5,0,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,15)) ! ((4,0,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,15)) ! ((5,0,2)|(0,0,0))
        theta(424) = theta(357)+theta(333)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(487) = theta(385)+theta(354)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(577) = theta(487)+theta(424)*AB(1) ! ((4,0,1)|(1,0,1)) = ((5,0,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(1)
        ! (4,0,1|0,2,0): 6
        theta(333) = dot_product(vrrbuffer(:,3), D(:,16)) ! ((4,0,1)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,16)) ! ((4,1,1)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,16)) ! ((4,2,1)|(0,0,0))
        theta(423) = theta(356)+theta(333)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(492) = theta(387)+theta(356)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(578) = theta(492)+theta(423)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        ! (4,0,1|0,1,1): 7
        theta(333) = dot_product(vrrbuffer(:,3), D(:,17)) ! ((4,0,1)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,17)) ! ((4,1,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,17)) ! ((4,0,2)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,17)) ! ((4,1,2)|(0,0,0))
        theta(424) = theta(357)+theta(333)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(493) = theta(388)+theta(356)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(579) = theta(493)+theta(424)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        ! (4,0,1|0,0,2): 6
        theta(333) = dot_product(vrrbuffer(:,3), D(:,18)) ! ((4,0,1)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,18)) ! ((4,0,2)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,18)) ! ((4,0,3)|(0,0,0))
        theta(424) = theta(357)+theta(333)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(496) = theta(389)+theta(357)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(580) = theta(496)+theta(424)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        ! (3,2,0|2,0,0): 6
        theta(334) = dot_product(vrrbuffer(:,4), D(:,19)) ! ((3,2,0)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,19)) ! ((4,2,0)|(0,0,0))
        theta(383) = dot_product(vrrbuffer(:,53), D(:,19)) ! ((5,2,0)|(0,0,0))
        theta(425) = theta(355)+theta(334)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(488) = theta(383)+theta(355)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(581) = theta(488)+theta(425)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        ! (3,2,0|1,1,0): 7
        theta(334) = dot_product(vrrbuffer(:,4), D(:,20)) ! ((3,2,0)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,20)) ! ((4,2,0)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,20)) ! ((3,3,0)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,20)) ! ((4,3,0)|(0,0,0))
        theta(426) = theta(358)+theta(334)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(489) = theta(386)+theta(355)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(582) = theta(489)+theta(426)*AB(1) ! ((3,2,0)|(1,1,0)) = ((4,2,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(1)
        ! (3,2,0|1,0,1): 7
        theta(334) = dot_product(vrrbuffer(:,4), D(:,21)) ! ((3,2,0)|(0,0,0))
        theta(355) = dot_product(vrrbuffer(:,25), D(:,21)) ! ((4,2,0)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,21)) ! ((3,2,1)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,21)) ! ((4,2,1)|(0,0,0))
        theta(427) = theta(359)+theta(334)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(490) = theta(387)+theta(355)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(583) = theta(490)+theta(427)*AB(1) ! ((3,2,0)|(1,0,1)) = ((4,2,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(1)
        ! (3,2,0|0,2,0): 6
        theta(334) = dot_product(vrrbuffer(:,4), D(:,22)) ! ((3,2,0)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,22)) ! ((3,3,0)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,22)) ! ((3,4,0)|(0,0,0))
        theta(426) = theta(358)+theta(334)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(498) = theta(390)+theta(358)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(584) = theta(498)+theta(426)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        ! (3,2,0|0,1,1): 7
        theta(334) = dot_product(vrrbuffer(:,4), D(:,23)) ! ((3,2,0)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,23)) ! ((3,3,0)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,23)) ! ((3,2,1)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,23)) ! ((3,3,1)|(0,0,0))
        theta(427) = theta(359)+theta(334)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(499) = theta(391)+theta(358)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(585) = theta(499)+theta(427)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        ! (3,2,0|0,0,2): 6
        theta(334) = dot_product(vrrbuffer(:,4), D(:,24)) ! ((3,2,0)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,24)) ! ((3,2,1)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,24)) ! ((3,2,2)|(0,0,0))
        theta(427) = theta(359)+theta(334)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(502) = theta(392)+theta(359)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(586) = theta(502)+theta(427)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        ! (3,1,1|2,0,0): 6
        theta(335) = dot_product(vrrbuffer(:,5), D(:,25)) ! ((3,1,1)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,25)) ! ((4,1,1)|(0,0,0))
        theta(384) = dot_product(vrrbuffer(:,54), D(:,25)) ! ((5,1,1)|(0,0,0))
        theta(428) = theta(356)+theta(335)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(491) = theta(384)+theta(356)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(587) = theta(491)+theta(428)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        ! (3,1,1|1,1,0): 7
        theta(335) = dot_product(vrrbuffer(:,5), D(:,26)) ! ((3,1,1)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,26)) ! ((4,1,1)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,26)) ! ((3,2,1)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,26)) ! ((4,2,1)|(0,0,0))
        theta(429) = theta(359)+theta(335)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(492) = theta(387)+theta(356)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(588) = theta(492)+theta(429)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        ! (3,1,1|1,0,1): 7
        theta(335) = dot_product(vrrbuffer(:,5), D(:,27)) ! ((3,1,1)|(0,0,0))
        theta(356) = dot_product(vrrbuffer(:,26), D(:,27)) ! ((4,1,1)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,27)) ! ((3,1,2)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,27)) ! ((4,1,2)|(0,0,0))
        theta(430) = theta(360)+theta(335)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(493) = theta(388)+theta(356)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(589) = theta(493)+theta(430)*AB(1) ! ((3,1,1)|(1,0,1)) = ((4,1,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(1)
        ! (3,1,1|0,2,0): 6
        theta(335) = dot_product(vrrbuffer(:,5), D(:,28)) ! ((3,1,1)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,28)) ! ((3,2,1)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,28)) ! ((3,3,1)|(0,0,0))
        theta(429) = theta(359)+theta(335)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(501) = theta(391)+theta(359)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(590) = theta(501)+theta(429)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        ! (3,1,1|0,1,1): 7
        theta(335) = dot_product(vrrbuffer(:,5), D(:,29)) ! ((3,1,1)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,29)) ! ((3,2,1)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,29)) ! ((3,1,2)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,29)) ! ((3,2,2)|(0,0,0))
        theta(430) = theta(360)+theta(335)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(502) = theta(392)+theta(359)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(591) = theta(502)+theta(430)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        ! (3,1,1|0,0,2): 6
        theta(335) = dot_product(vrrbuffer(:,5), D(:,30)) ! ((3,1,1)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,30)) ! ((3,1,2)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,30)) ! ((3,1,3)|(0,0,0))
        theta(430) = theta(360)+theta(335)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(505) = theta(393)+theta(360)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(592) = theta(505)+theta(430)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        ! (3,0,2|2,0,0): 6
        theta(336) = dot_product(vrrbuffer(:,6), D(:,31)) ! ((3,0,2)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,31)) ! ((4,0,2)|(0,0,0))
        theta(385) = dot_product(vrrbuffer(:,55), D(:,31)) ! ((5,0,2)|(0,0,0))
        theta(431) = theta(357)+theta(336)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(494) = theta(385)+theta(357)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(593) = theta(494)+theta(431)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        ! (3,0,2|1,1,0): 7
        theta(336) = dot_product(vrrbuffer(:,6), D(:,32)) ! ((3,0,2)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,32)) ! ((4,0,2)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,32)) ! ((3,1,2)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,32)) ! ((4,1,2)|(0,0,0))
        theta(432) = theta(360)+theta(336)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(495) = theta(388)+theta(357)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(594) = theta(495)+theta(432)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        ! (3,0,2|1,0,1): 7
        theta(336) = dot_product(vrrbuffer(:,6), D(:,33)) ! ((3,0,2)|(0,0,0))
        theta(357) = dot_product(vrrbuffer(:,27), D(:,33)) ! ((4,0,2)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,33)) ! ((3,0,3)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,33)) ! ((4,0,3)|(0,0,0))
        theta(433) = theta(361)+theta(336)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(496) = theta(389)+theta(357)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(595) = theta(496)+theta(433)*AB(1) ! ((3,0,2)|(1,0,1)) = ((4,0,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(1)
        ! (3,0,2|0,2,0): 6
        theta(336) = dot_product(vrrbuffer(:,6), D(:,34)) ! ((3,0,2)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,34)) ! ((3,1,2)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,34)) ! ((3,2,2)|(0,0,0))
        theta(432) = theta(360)+theta(336)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(504) = theta(392)+theta(360)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(596) = theta(504)+theta(432)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        ! (3,0,2|0,1,1): 7
        theta(336) = dot_product(vrrbuffer(:,6), D(:,35)) ! ((3,0,2)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,35)) ! ((3,1,2)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,35)) ! ((3,0,3)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,35)) ! ((3,1,3)|(0,0,0))
        theta(433) = theta(361)+theta(336)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(505) = theta(393)+theta(360)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(597) = theta(505)+theta(433)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        ! (3,0,2|0,0,2): 6
        theta(336) = dot_product(vrrbuffer(:,6), D(:,36)) ! ((3,0,2)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,36)) ! ((3,0,3)|(0,0,0))
        theta(394) = dot_product(vrrbuffer(:,64), D(:,36)) ! ((3,0,4)|(0,0,0))
        theta(433) = theta(361)+theta(336)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(508) = theta(394)+theta(361)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(598) = theta(508)+theta(433)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        ! (2,3,0|2,0,0): 6
        theta(337) = dot_product(vrrbuffer(:,7), D(:,37)) ! ((2,3,0)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,37)) ! ((3,3,0)|(0,0,0))
        theta(386) = dot_product(vrrbuffer(:,56), D(:,37)) ! ((4,3,0)|(0,0,0))
        theta(434) = theta(358)+theta(337)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(497) = theta(386)+theta(358)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(599) = theta(497)+theta(434)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        ! (2,3,0|1,1,0): 7
        theta(337) = dot_product(vrrbuffer(:,7), D(:,38)) ! ((2,3,0)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,38)) ! ((3,3,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,38)) ! ((2,4,0)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,38)) ! ((3,4,0)|(0,0,0))
        theta(435) = theta(362)+theta(337)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(498) = theta(390)+theta(358)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(600) = theta(498)+theta(435)*AB(1) ! ((2,3,0)|(1,1,0)) = ((3,3,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(1)
        ! (2,3,0|1,0,1): 7
        theta(337) = dot_product(vrrbuffer(:,7), D(:,39)) ! ((2,3,0)|(0,0,0))
        theta(358) = dot_product(vrrbuffer(:,28), D(:,39)) ! ((3,3,0)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,39)) ! ((2,3,1)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,39)) ! ((3,3,1)|(0,0,0))
        theta(436) = theta(363)+theta(337)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(499) = theta(391)+theta(358)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(601) = theta(499)+theta(436)*AB(1) ! ((2,3,0)|(1,0,1)) = ((3,3,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(1)
        ! (2,3,0|0,2,0): 6
        theta(337) = dot_product(vrrbuffer(:,7), D(:,40)) ! ((2,3,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,40)) ! ((2,4,0)|(0,0,0))
        theta(395) = dot_product(vrrbuffer(:,65), D(:,40)) ! ((2,5,0)|(0,0,0))
        theta(435) = theta(362)+theta(337)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(510) = theta(395)+theta(362)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(602) = theta(510)+theta(435)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        ! (2,3,0|0,1,1): 7
        theta(337) = dot_product(vrrbuffer(:,7), D(:,41)) ! ((2,3,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,41)) ! ((2,4,0)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,41)) ! ((2,3,1)|(0,0,0))
        theta(396) = dot_product(vrrbuffer(:,66), D(:,41)) ! ((2,4,1)|(0,0,0))
        theta(436) = theta(363)+theta(337)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(511) = theta(396)+theta(362)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(603) = theta(511)+theta(436)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        ! (2,3,0|0,0,2): 6
        theta(337) = dot_product(vrrbuffer(:,7), D(:,42)) ! ((2,3,0)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,42)) ! ((2,3,1)|(0,0,0))
        theta(397) = dot_product(vrrbuffer(:,67), D(:,42)) ! ((2,3,2)|(0,0,0))
        theta(436) = theta(363)+theta(337)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(514) = theta(397)+theta(363)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(604) = theta(514)+theta(436)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        ! (2,2,1|2,0,0): 6
        theta(338) = dot_product(vrrbuffer(:,8), D(:,43)) ! ((2,2,1)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,43)) ! ((3,2,1)|(0,0,0))
        theta(387) = dot_product(vrrbuffer(:,57), D(:,43)) ! ((4,2,1)|(0,0,0))
        theta(437) = theta(359)+theta(338)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(500) = theta(387)+theta(359)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(605) = theta(500)+theta(437)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        ! (2,2,1|1,1,0): 7
        theta(338) = dot_product(vrrbuffer(:,8), D(:,44)) ! ((2,2,1)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,44)) ! ((3,2,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,44)) ! ((2,3,1)|(0,0,0))
        theta(391) = dot_product(vrrbuffer(:,61), D(:,44)) ! ((3,3,1)|(0,0,0))
        theta(438) = theta(363)+theta(338)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(501) = theta(391)+theta(359)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(606) = theta(501)+theta(438)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        ! (2,2,1|1,0,1): 7
        theta(338) = dot_product(vrrbuffer(:,8), D(:,45)) ! ((2,2,1)|(0,0,0))
        theta(359) = dot_product(vrrbuffer(:,29), D(:,45)) ! ((3,2,1)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,45)) ! ((2,2,2)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,45)) ! ((3,2,2)|(0,0,0))
        theta(439) = theta(364)+theta(338)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(502) = theta(392)+theta(359)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(607) = theta(502)+theta(439)*AB(1) ! ((2,2,1)|(1,0,1)) = ((3,2,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(1)
        ! (2,2,1|0,2,0): 6
        theta(338) = dot_product(vrrbuffer(:,8), D(:,46)) ! ((2,2,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,46)) ! ((2,3,1)|(0,0,0))
        theta(396) = dot_product(vrrbuffer(:,66), D(:,46)) ! ((2,4,1)|(0,0,0))
        theta(438) = theta(363)+theta(338)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(513) = theta(396)+theta(363)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(608) = theta(513)+theta(438)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        ! (2,2,1|0,1,1): 7
        theta(338) = dot_product(vrrbuffer(:,8), D(:,47)) ! ((2,2,1)|(0,0,0))
        theta(363) = dot_product(vrrbuffer(:,33), D(:,47)) ! ((2,3,1)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,47)) ! ((2,2,2)|(0,0,0))
        theta(397) = dot_product(vrrbuffer(:,67), D(:,47)) ! ((2,3,2)|(0,0,0))
        theta(439) = theta(364)+theta(338)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(514) = theta(397)+theta(363)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(609) = theta(514)+theta(439)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        ! (2,2,1|0,0,2): 6
        theta(338) = dot_product(vrrbuffer(:,8), D(:,48)) ! ((2,2,1)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,48)) ! ((2,2,2)|(0,0,0))
        theta(398) = dot_product(vrrbuffer(:,68), D(:,48)) ! ((2,2,3)|(0,0,0))
        theta(439) = theta(364)+theta(338)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(517) = theta(398)+theta(364)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(610) = theta(517)+theta(439)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        ! (2,1,2|2,0,0): 6
        theta(339) = dot_product(vrrbuffer(:,9), D(:,49)) ! ((2,1,2)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,49)) ! ((3,1,2)|(0,0,0))
        theta(388) = dot_product(vrrbuffer(:,58), D(:,49)) ! ((4,1,2)|(0,0,0))
        theta(440) = theta(360)+theta(339)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(503) = theta(388)+theta(360)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(611) = theta(503)+theta(440)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        ! (2,1,2|1,1,0): 7
        theta(339) = dot_product(vrrbuffer(:,9), D(:,50)) ! ((2,1,2)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,50)) ! ((3,1,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,50)) ! ((2,2,2)|(0,0,0))
        theta(392) = dot_product(vrrbuffer(:,62), D(:,50)) ! ((3,2,2)|(0,0,0))
        theta(441) = theta(364)+theta(339)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(504) = theta(392)+theta(360)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(612) = theta(504)+theta(441)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        ! (2,1,2|1,0,1): 7
        theta(339) = dot_product(vrrbuffer(:,9), D(:,51)) ! ((2,1,2)|(0,0,0))
        theta(360) = dot_product(vrrbuffer(:,30), D(:,51)) ! ((3,1,2)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,51)) ! ((2,1,3)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,51)) ! ((3,1,3)|(0,0,0))
        theta(442) = theta(365)+theta(339)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(505) = theta(393)+theta(360)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(613) = theta(505)+theta(442)*AB(1) ! ((2,1,2)|(1,0,1)) = ((3,1,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(1)
        ! (2,1,2|0,2,0): 6
        theta(339) = dot_product(vrrbuffer(:,9), D(:,52)) ! ((2,1,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,52)) ! ((2,2,2)|(0,0,0))
        theta(397) = dot_product(vrrbuffer(:,67), D(:,52)) ! ((2,3,2)|(0,0,0))
        theta(441) = theta(364)+theta(339)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(516) = theta(397)+theta(364)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(614) = theta(516)+theta(441)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        ! (2,1,2|0,1,1): 7
        theta(339) = dot_product(vrrbuffer(:,9), D(:,53)) ! ((2,1,2)|(0,0,0))
        theta(364) = dot_product(vrrbuffer(:,34), D(:,53)) ! ((2,2,2)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,53)) ! ((2,1,3)|(0,0,0))
        theta(398) = dot_product(vrrbuffer(:,68), D(:,53)) ! ((2,2,3)|(0,0,0))
        theta(442) = theta(365)+theta(339)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(517) = theta(398)+theta(364)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(615) = theta(517)+theta(442)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        ! (2,1,2|0,0,2): 6
        theta(339) = dot_product(vrrbuffer(:,9), D(:,54)) ! ((2,1,2)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,54)) ! ((2,1,3)|(0,0,0))
        theta(399) = dot_product(vrrbuffer(:,69), D(:,54)) ! ((2,1,4)|(0,0,0))
        theta(442) = theta(365)+theta(339)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(520) = theta(399)+theta(365)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(616) = theta(520)+theta(442)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        ! (2,0,3|2,0,0): 6
        theta(340) = dot_product(vrrbuffer(:,10), D(:,55)) ! ((2,0,3)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,55)) ! ((3,0,3)|(0,0,0))
        theta(389) = dot_product(vrrbuffer(:,59), D(:,55)) ! ((4,0,3)|(0,0,0))
        theta(443) = theta(361)+theta(340)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(506) = theta(389)+theta(361)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(617) = theta(506)+theta(443)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        ! (2,0,3|1,1,0): 7
        theta(340) = dot_product(vrrbuffer(:,10), D(:,56)) ! ((2,0,3)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,56)) ! ((3,0,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,56)) ! ((2,1,3)|(0,0,0))
        theta(393) = dot_product(vrrbuffer(:,63), D(:,56)) ! ((3,1,3)|(0,0,0))
        theta(444) = theta(365)+theta(340)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(507) = theta(393)+theta(361)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(618) = theta(507)+theta(444)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        ! (2,0,3|1,0,1): 7
        theta(340) = dot_product(vrrbuffer(:,10), D(:,57)) ! ((2,0,3)|(0,0,0))
        theta(361) = dot_product(vrrbuffer(:,31), D(:,57)) ! ((3,0,3)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,57)) ! ((2,0,4)|(0,0,0))
        theta(394) = dot_product(vrrbuffer(:,64), D(:,57)) ! ((3,0,4)|(0,0,0))
        theta(445) = theta(366)+theta(340)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(508) = theta(394)+theta(361)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(619) = theta(508)+theta(445)*AB(1) ! ((2,0,3)|(1,0,1)) = ((3,0,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(1)
        ! (2,0,3|0,2,0): 6
        theta(340) = dot_product(vrrbuffer(:,10), D(:,58)) ! ((2,0,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,58)) ! ((2,1,3)|(0,0,0))
        theta(398) = dot_product(vrrbuffer(:,68), D(:,58)) ! ((2,2,3)|(0,0,0))
        theta(444) = theta(365)+theta(340)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(519) = theta(398)+theta(365)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(620) = theta(519)+theta(444)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        ! (2,0,3|0,1,1): 7
        theta(340) = dot_product(vrrbuffer(:,10), D(:,59)) ! ((2,0,3)|(0,0,0))
        theta(365) = dot_product(vrrbuffer(:,35), D(:,59)) ! ((2,1,3)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,59)) ! ((2,0,4)|(0,0,0))
        theta(399) = dot_product(vrrbuffer(:,69), D(:,59)) ! ((2,1,4)|(0,0,0))
        theta(445) = theta(366)+theta(340)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(520) = theta(399)+theta(365)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(621) = theta(520)+theta(445)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        ! (2,0,3|0,0,2): 6
        theta(340) = dot_product(vrrbuffer(:,10), D(:,60)) ! ((2,0,3)|(0,0,0))
        theta(366) = dot_product(vrrbuffer(:,36), D(:,60)) ! ((2,0,4)|(0,0,0))
        theta(400) = dot_product(vrrbuffer(:,70), D(:,60)) ! ((2,0,5)|(0,0,0))
        theta(445) = theta(366)+theta(340)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(523) = theta(400)+theta(366)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(622) = theta(523)+theta(445)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        ! (1,4,0|2,0,0): 6
        theta(341) = dot_product(vrrbuffer(:,11), D(:,61)) ! ((1,4,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,61)) ! ((2,4,0)|(0,0,0))
        theta(390) = dot_product(vrrbuffer(:,60), D(:,61)) ! ((3,4,0)|(0,0,0))
        theta(446) = theta(362)+theta(341)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(509) = theta(390)+theta(362)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(623) = theta(509)+theta(446)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        ! (1,4,0|1,1,0): 7
        theta(341) = dot_product(vrrbuffer(:,11), D(:,62)) ! ((1,4,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,62)) ! ((2,4,0)|(0,0,0))
        theta(367) = dot_product(vrrbuffer(:,37), D(:,62)) ! ((1,5,0)|(0,0,0))
        theta(395) = dot_product(vrrbuffer(:,65), D(:,62)) ! ((2,5,0)|(0,0,0))
        theta(447) = theta(367)+theta(341)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(510) = theta(395)+theta(362)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(624) = theta(510)+theta(447)*AB(1) ! ((1,4,0)|(1,1,0)) = ((2,4,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(1)
        ! (1,4,0|1,0,1): 7
        theta(341) = dot_product(vrrbuffer(:,11), D(:,63)) ! ((1,4,0)|(0,0,0))
        theta(362) = dot_product(vrrbuffer(:,32), D(:,63)) ! ((2,4,0)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,63)) ! ((1,4,1)|(0,0,0))
        theta(396) = dot_product(vrrbuffer(:,66), D(:,63)) ! ((2,4,1)|(0,0,0))
        theta(448) = theta(368)+theta(341)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(511) = theta(396)+theta(362)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(625) = theta(511)+theta(448)*AB(1) ! ((1,4,0)|(1,0,1)) = ((2,4,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(1)
        ! (1,4,0|0,2,0): 6
        theta(341) = dot_product(vrrbuffer(:,11), D(:,64)) ! ((1,4,0)|(0,0,0))
        theta(367) = dot_product(vrrbuffer(:,37), D(:,64)) ! ((1,5,0)|(0,0,0))
        theta(401) = dot_product(vrrbuffer(:,71), D(:,64)) ! ((1,6,0)|(0,0,0))
        theta(447) = theta(367)+theta(341)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(525) = theta(401)+theta(367)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(626) = theta(525)+theta(447)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        ! (1,4,0|0,1,1): 7
        theta(341) = dot_product(vrrbuffer(:,11), D(:,65)) ! ((1,4,0)|(0,0,0))
        theta(367) = dot_product(vrrbuffer(:,37), D(:,65)) ! ((1,5,0)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,65)) ! ((1,4,1)|(0,0,0))
        theta(402) = dot_product(vrrbuffer(:,72), D(:,65)) ! ((1,5,1)|(0,0,0))
        theta(448) = theta(368)+theta(341)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(526) = theta(402)+theta(367)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(627) = theta(526)+theta(448)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        ! (1,4,0|0,0,2): 6
        theta(341) = dot_product(vrrbuffer(:,11), D(:,66)) ! ((1,4,0)|(0,0,0))
        theta(368) = dot_product(vrrbuffer(:,38), D(:,66)) ! ((1,4,1)|(0,0,0))
        theta(403) = dot_product(vrrbuffer(:,73), D(:,66)) ! ((1,4,2)|(0,0,0))
        theta(448) = theta(368)+theta(341)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(529) = theta(403)+theta(368)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(628) = theta(529)+theta(448)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        ! (1,3,1|2,0,0): 6
     