c   Adapted by Tian Lu based on original code of SYVA
c   The line "if((nsym(i,5).gt.nsym(nm,5))) nm=i" has bug, this part has been modified to fix the problem
c
c   Copyright (C) 2016 Laszlo Gyevi-Nagy, Gyula Tasi
c
c   This file is part of SYVA.
c
c   SYVA is free software; you can redistribute it and/or
c   modify it under the terms of the GNU Lesser General Public
c   License as published by the Free Software Foundation; either
c   version 2.1 of the License, or (at your option) any later version.
c
c   SYVA is distributed in the hope that it will be useful,
c   but WITHOUT ANY WARRANTY; without even the implied warranty of
c   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
c   Lesser General Public License for more details.
c
c   You should have received a copy of the GNU Lesser General Public
c   License along with SYVA; if not, write to the Free Software
c   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

************************************************************************
*                                                                      *
*   Program SYMMETRY determines all the symmetry elements & symmetry   *
*                    operations of rigid molecules.                    *
*           (C) G. Tasi, L. Gyevi-Nagy, R. Tobias, T.S. Tasi           *
*               J. Math. Chem., 51, 2187-2195 (2013)                   *
*         Department of Applied and Environmental Chemistry            *
*                     University of Szeged                             *
*                       Rerrich B. ter 1.                              *
*                         H-6720 Szeged                                *
*                            Hungary                                   *
*                                                                      *
************************************************************************
      
      
************************************************************************
      subroutine syva_check(natoms,delta,nat,coord,c,nc,ntrans,delta3)
************************************************************************
c
c Subroutine syva_check counts the number of atoms unchanged by an operation
c and generates the permutation describing it
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension coord(3,natoms),c(3,natoms)
      dimension nat(natoms),ntrans(natoms),diff(3)
      nc=0
      delta3=0.d0
      outer: do i=1,natoms
         do j=1,natoms
c find closest atom
            if(nat(i).ne.nat(j)) cycle
            diff(1)=coord(1,i)-c(1,j)
            diff(2)=coord(2,i)-c(2,j)
            diff(3)=coord(3,i)-c(3,j)
            vn=dsqrt(syva_dot(diff,diff,3))
            if(vn.le.delta) then
               nc=nc+1
c permutation
               ntrans(i)=j
               if(vn.gt.delta3) delta3=vn
               cycle outer
            end if
         end do
         return
      end do outer
      end
************************************************************************
      subroutine add_perm(natoms,ntrans,nprm,nper)
************************************************************************
c
c Subroutine add_perm stores new permutations
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension ntrans(natoms),nper(natoms,250)
c syva_check already stored permutations
      outer: do i=1,nprm
         do j=1,natoms
            if(ntrans(j).ne.nper(j,i)) cycle outer
         end do
         return
      end do outer
c add a new permutation
      nprm=nprm+1
      if(nprm.gt.250) then
         write(*,'(a)') ' ERROR: You need to enlarge the second
     & dimension of "nper" array and recompile the code'
         write(*,'(a)') ' Press ENTER button to exit'
         read(*,*)
         stop
      end if
      do i=1,natoms
         nper(i,nprm)=ntrans(i)
      end do
      end
************************************************************************
      subroutine add_SG(nsg,sigman,v,p,delta)
************************************************************************
c
c Subroutine add_SG stores new reflection planes
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      parameter(nmax=200)
      dimension sigman(nmax,3)
      dimension v(3),p(3)
c syva_check found planes
      do k=1,nsg
         p(1)=sigman(k,1)
         p(2)=sigman(k,2)
         p(3)=sigman(k,3)
         vk=syva_dot(v,p,3)
         if(dabs(vk).gt.(1.d0-delta).and.
     &      dabs(vk).lt.(1.d0+delta)) return
      end do
c add a new plane
      nsg=nsg+1
      if(nsg.gt.nmax) then
         write(*,'(a)')
     &    'ERROR: Too many symmetry operations. Try a lower tolerance.'
         !stop
      end if
      sigman(nsg,1)=v(1)
      sigman(nsg,2)=v(2)
      sigman(nsg,3)=v(3)
      end
************************************************************************
      subroutine add_Cn(nrot,rotn,rota,v,p,alpha,delta)
************************************************************************
c
c Subroutine add_Cn stores new rotation axes
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      parameter(nmax=200)
      dimension rotn(nmax,3),rota(nmax)
      dimension v(3),p(3)
c syva_check found axes
      do k=1,nrot
         p(1)=rotn(k,1)
         p(2)=rotn(k,2)
         p(3)=rotn(k,3)
         vk=syva_dot(v,p,3)
         if(dabs(vk).gt.(1.d0-delta).and.
     &      dabs(vk).lt.(1.d0+delta)) then 
            if(rota(k).gt.alpha) rota(k)=alpha
            return
         endif
      end do
c add a new axis
      nrot=nrot+1
      if(nrot.gt.nmax) then
         write(*,'(a)')
     &    'ERROR: Too many symmetry operations. Try a lower tolerance.'
         !stop
      end if
      rotn(nrot,1)=v(1)
      rotn(nrot,2)=v(2)
      rotn(nrot,3)=v(3)
      rota(nrot)=alpha
      end
      
      
************************************************************************
      block data
************************************************************************
      implicit double precision (a-h,o-z)
      implicit integer(i-n)
      character symb*2,pgsymb*3,irsymb*4
      common/data/ wt(90),symb(90)
      common/chartab/ nir(2,55),chtab(14,322),
     &   nsymop(14,4,55),nrotharm(3,322),pgsymb(57),irsymb(322)
      common/subgroups/ nsgb(2,57),nsgr(406)
c
c Atomic weights of the most stable isotopes of the elements
c
      data  wt/     1.00783d0,  4.00260d0,  6.94000d0,  9.01218d0,
     $ 10.81000d0, 12.00000d0, 14.00307d0, 15.99491d0, 18.99840d0,
     $ 20.17900d0, 22.98977d0, 24.30500d0, 26.98154d0, 28.08550d0,
     $ 30.97376d0, 32.06000d0, 35.45300d0, 39.94800d0, 39.09830d0,
     $ 40.08000d0, 44.95590d0, 47.90000d0, 50.94150d0, 51.99600d0,
     $ 54.93800d0, 55.84700d0, 58.93320d0, 58.71000d0, 63.54600d0,
     $ 65.38000d0, 69.73500d0, 72.59000d0, 74.92160d0, 78.96000d0,
     $ 79.90400d0, 83.80000d0, 85.46780d0, 87.62000d0, 88.90590d0,
     $ 91.22000d0, 92.90640d0, 95.94000d0, 98.90620d0, 101.0700d0,
     $ 102.9055d0, 106.4000d0, 107.8680d0, 112.4100d0, 114.8200d0,
     $ 118.6900d0, 121.7500d0, 127.6000d0, 126.9045d0, 131.3000d0,
     $ 132.9054d0, 137.3300d0, 15*0.000d0, 178.4900d0, 180.9479d0,
     $ 183.8500d0, 186.2070d0, 190.2000d0, 192.2200d0, 194.9648d0,
     $ 196.9665d0, 200.5900d0, 204.3700d0, 207.2000d0, 208.9804d0,
     $ 7*0.000d0/
c
c Symbols of the elements
c
      data symb/
     $  ' H', 'He', 'Li', 'Be', ' B', ' C', ' N', ' O', ' F', 'Ne',
     $  'Na', 'Mg', 'Al', 'Si', ' P', ' S', 'Cl', 'Ar', ' K', 'Ca',
     $  'Sc', 'Ti', ' V', 'Cr', 'Mn', 'Fe', 'Co', 'Ni', 'Cu', 'Zn',
     $  'Ga', 'Ge', 'As', 'Se', 'Br', 'Kr', 'Rb', 'Sr', ' Y', 'Zr',
     $  'Nb', 'Mo', 'Tc', 'Ru', 'Rh', 'Pd', 'Ag', 'Cd', 'In', 'Sn',
     $  'Sb', 'Te', ' I', 'Xe', 'Cs', 'Ba', 'La', 'Ce', 'Pr', 'Nd',
     $  'Pm', 'Sm', 'Eu', 'Gd', 'Tb', 'Dy', 'Ho', 'Er', 'Tm', 'Yb',
     $  'Lu', 'Hf', 'Ta', ' W', 'Re', 'Os', 'Ir', 'Pt', 'Au', 'Hg',
     $  'Tl', 'Pb', 'Bi', 'Po', 'At', 'Rn', 'Fr', 'Ra', 'Ac', '  '/
c
c Symbols of the point groups
c
      data pgsymb/
     &' C1',' Cs',' Ci',' C2',' C3',' C4',' C5',' C6',' C7',' C8',' D2',
     &' D3',' D4',' D5',' D6',' D7',' D8','C2v','C3v','C4v','C5v','C6v',
     &'C7v','C8v','C2h','C3h','C4h','C5h','C6h','C7h','C8h','D2h','D3h',
     &'D4h','D5h','D6h','D7h','D8h','D2d','D3d','D4d','D5d','D6d','D7d',
     &'D8d',' S4',' S6',' S8','  T',' Th',' Td','  O',' Oh','  I',' Ih',
     &'Civ','Dih'/
c
      data nir/
     &       1,  1,       2,  2,       4,  2,       6,  2,       8,  2,
     &      10,  3,      13,  3,      16,  4,      20,  4,      24,  5,
     &      29,  4,      33,  3,      36,  5,      41,  4,      45,  6,
     &      51,  5,      56,  7,      63,  4,      67,  3,      70,  5,
     &      75,  4,      79,  6,      85,  5,      90,  7,      97,  4,
     &     101,  4,     105,  6,     111,  6,     117,  8,     125,  8,
     &     133, 10,     143,  8,     151,  6,     157, 10,     167,  8,
     &     175, 12,     187, 10,     197, 14,     211,  5,     216,  6,
     &     222,  7,     229,  8,     237,  9,     246, 10,     256, 11,
     &     267,  3,     270,  4,     274,  5,     279,  3,     282,  6,
     &     288,  5,     293,  5,     298, 10,     308,  5,     313, 10/
c
      data nsymop/
c Symmetry operations of the point groups

c
c C1 (#1)
c        E
     &   4,   13*0,
     &   0,   13*0,
     &   0,   13*0,
     &   1,   13*0,
c
c Cs (#2)
c        E  SGH
     &   4,  1,   12*0,
     &   0,  1,   12*0,
     &   0,  0,   12*0,
     &   1,  1,   12*0,
c
c Ci (#3)
c        E   i  
     &   4,  0,   12*0,
     &   0,  0,   12*0,
     &   0,  0,   12*0,
     &   1,  1,   12*0,
c
c C2 (#4)
c        E  C2 
     &   4,  2,   12*0,
     &   0,  2,   12*0,
     &   0,  1,   12*0,
     &   1,  1,   12*0,
c
c C3 (#5)
c        E  C3 
     &   4,  2,  12*0,
     &   0,  3,  12*0,
     &   0,  1,  12*0,
     &   1,  2,  12*0,
c
c C4 (#6)
c        E  C4  C2 
     &   4,  2,  2,  11*0,
     &   0,  4,  2,  11*0,
     &   0,  1,  0,  11*0,
     &   1,  2,  1,  11*0,
c
c C5 (#7)
c        E   C5   C5^2
     &   4,   2,   2,   11*0,
     &   0,   5,   5,   11*0,
     &   0,   1,   2,   11*0,
     &   1,   2,   2,   11*0,
c
c C6 (#8)
c        E   C6   C3  C2
     &   4,  2,   2,  2,  10*0,
     &   0,  6,   3,  2,  10*0,
     &   0,  1,   1,  0,  10*0,
     &   1,  2,   2,  1,  10*0,
c
c C7 (#9)
c        E   C7  C7^2  C7^3
     &   4,  2,   2,    2,   10*0,
     &   0,  7,   7,    7,   10*0,
     &   0,  1,   2,    3,   10*0,
     &   1,  2,   2,    2,   10*0,
c
c C8  (#10)
c        E   C8  C4  C8^3  C2
     &   4,  2,  2,   2,   2,   9*0,
     &   0,  8,  4,   8,   2,   9*0,
     &   0,  1,  1,   3,   0,   9*0,
     &   1,  2,  2,   2,   1,   9*0,
c
c D2  (#11)
c        E  C2   C2'  C2"
     &   4,  2,   2,   2,   10*0,
     &   0,  2,   2,   2,   10*0,
     &   0,  1,   2,   3,   10*0,
     &   1,  1,   1,   1,   10*0,
c
c D3  (#12)
c        E  C3  C2' 
     &   4, 2,   2,   11*0,
     &   0, 3,   2,   11*0,
     &   0, 1,   2,   11*0,
     &   1, 2,   3,   11*0,
c
c D4  (#13)
c        E  C4  C2  C2'  C2"
     &   4, 2,  2,   2,   2,    9*0,
     &   0, 4,  2,   2,   2,    9*0,
     &   0, 1,  0,   2,   3,    9*0,
     &   1, 2,  1,   2,   2,    9*0,
c
c D5  (#14)
c        E  C5  C5^2  C2'
     &   4, 2,   2,    2,   10*0,
     &   0, 5,   5,    2,   10*0,
     &   0, 1,   2,    2,   10*0,
     &   1, 2,   2,    5,   10*0,
c
c D6  (#15)
c        E  C6  C3  C2  C2'  C2"
     &   4, 2,  2,  2,   2,   2,    8*0,
     &   0, 6,  3,  2,   2,   2,    8*0,
     &   0, 1,  1,  0,   2,   3,    8*0,
     &   1, 2,  2,  1,   3,   3,    8*0,
c
c D7  (#16)
c        E  C7 C7^2  C7^3  C2'
     &   4, 2,  2,    2,    2,   9*0,
     &   0, 7,  7,    7,    2,   9*0,
     &   0, 1,  2,    3,    2,   9*0,
     &   1, 2,  2,    2,    7,   9*0,
c
c D8  (#17)
c        E  C8  C4   C8^3  C2  C2'  C2"
     &   4, 2,  2,    2,    2,  2,   2,    7*0,
     &   0, 8,  4,    8,    2,  2,   2,    7*0,
     &   0, 1,  1,    3,    0,  2,   3,    7*0,
     &   1, 2,  2,    2,    1,  4,   4,    7*0,
c
c C2v (#18)
c        E  C2  SGV  SHD
     &   4, 2,   1,   1,   10*0,
     &   0, 2,   2,   3,   10*0,
     &   0, 1,   0,   0,   10*0,
     &   1, 1,   1,   1,   10*0,
c
c C3v (#19)
c        E  C3  SGV 
     &   4, 2,   1,   11*0,
     &   0, 3,   2,   11*0,
     &   0, 1,   0,   11*0,
     &   1, 2,   3,   11*0,
c
c C4v (#20)
c        E  C4  C2  SGV  SGD
     &   4, 2,  2,   1,   1,    9*0,
     &   0, 4,  2,   2,   3,    9*0,
     &   0, 1,  0,   0,   0,    9*0,
     &   1, 2,  1,   2,   2,    9*0,
c
c C5v (#21)
c        E  C5  C5^2  SGV
     &   4, 2,   2,    1,   10*0,
     &   0, 5,   5,    2,   10*0,
     &   0, 1,   2,    0,   10*0,
     &   1, 2,   2,    5,   10*0,
c
c C6v (#22)
c        E  C6  C3  C2  SGV  SGD
     &   4, 2,  2,  2,   1,   1,    8*0,
     &   0, 6,  3,  2,   2,   3,    8*0,
     &   0, 1,  1,  0,   0,   0,    8*0,
     &   1, 2,  2,  1,   3,   3,    8*0,
c
c C7v (#23)
c        E   C7  C7^2  C7^3  SGV
     &   4,  2,   2,    2,    1,    9*0,
     &   0,  7,   7,    7,    2,    9*0,
     &   0,  1,   2,    3,    0,    9*0,
     &   1,  2,   2,    2,    7,    9*0,
c
c C8v (#24)
c        E   C8  C4  C8^3  C2  SGV  SGD
     &   4,  2,  2,   2,   2,   1,   1,     7*0,
     &   0,  8,  4,   8,   2,   2,   3,     7*0,
     &   0,  1,  1,   3,   0,   0,   0,     7*0,
     &   1,  2,  2,   2,   1,   4,   4,     7*0,
c
c C2h (#25)
c        E  C2  i  SGH
     &   4, 2,  0,  1,   10*0,
     &   0, 2,  1,  1,   10*0,
     &   0, 1,  0,  0,   10*0,
     &   1, 1,  1,  1,   10*0,
c
c C3h (#26)
c        E  C3  SGH  S3
     &   4, 2,   1,  3,    10*0,
     &   0, 3,   1,  3,    10*0,
     &   0, 1,   0,  1,    10*0,
     &   1, 2,   1,  2,    10*0,
c
c C4h (#27)
c        E  C4  C2  i   S4 SGH 
     &   4, 2,  2,  0,  3,   1,   8*0,
     &   0, 4,  2,  1,  4,   1,   8*0,
     &   0, 1,  0,  0,  1,   0,   8*0,
     &   1, 2,  1,  1,  2,   1,   8*0,
c
c C5h (#28)
c        E  C5  C5^2  SGH  S5  S5^3
     &   4, 2,   2,    1,  3,   3,     8*0,
     &   0, 5,   5,    1,  5,   5,     8*0,
     &   0, 1,   2,    0,  1,   3,     8*0,
     &   1, 2,   2,    1,  2,   2,     8*0,
c
c C6h (#29)
c        E  C6  C3  C2  i   S6  S3 SGH 
     &   4, 2,  2,  2,  0,  3,  3,  1,      6*0,
     &   0, 6,  3,  2,  1,  6,  3,  1,      6*0,
     &   0, 1,  1,  0,  0,  1,  1,  0,      6*0,
     &   1, 2,  2,  1,  1,  2,  2,  1,      6*0,
c
c C7h (#30)
c        E   C7  C7^2  C7^3  SGH   S7  S7^3  S7^5
     &   4,  2,   2,    2,    1,   3,   3,    3,     6*0,
     &   0,  7,   7,    7,    1,   7,   7,    7,     6*0,
     &   0,  1,   2,    3,    0,   1,   3,    5,     6*0,
     &   1,  2,   2,    2,    1,   2,   2,    2,     6*0,
c
c C8h (#31)
c        E   C8  C4  C8^3  C2  i    S8  S4  S8^3  SGH
     &   4,  2,  2,   2,   2,  0,   3,  3,    3,   1,     4*0,
     &   0,  8,  4,   8,   2,  1,   8,  4,    8,   1,     4*0,
     &   0,  1,  1,   3,   0,  0,   1,  1,    3,   0,     4*0,
     &   1,  2,  2,   2,   1,  1,   2,  2,    2,   1,     4*0,
c
c D2h (#32)
c        E  C2  C2'  C2"  i  SGH  SGV  SGD
     &   4,  2,  2,   2,  0,  1,   1,   1,    6*0,
     &   0,  2,  2,   2,  1,  1,   2,   3,    6*0,
     &   0,  1,  2,   3,  0,  0,   0,   0,    6*0,
     &   1,  1,  1,   1,  1,  1,   1,   1,    6*0,
c
c D3h (#33)
c        E  C3  C2'  SGH  S3  SGV
     &   4, 2,  2,    1,  3,   1,    8*0,
     &   0, 3,  2,    1,  3,   2,    8*0,
     &   0, 1,  2,    0,  1,   0,    8*0,
     &   1, 2,  3,    1,  2,   3,    8*0,
c
c D4h (#34)
c        E  C4  C2  C2'  C2"   i   S4 SGH  SGV  SGD
     &   4, 2,  2,  2,    2,   0,  3,  1,   1,   1,      4*0,
     &   0, 4,  2,  2,    2,   1,  4,  1,   2,   3,      4*0,
     &   0, 1,  0,  2,    3,   0,  1,  0,   0,   0,      4*0,
     &   1, 2,  1,  2,    2,   1,  2,  1,   2,   2,      4*0,
c
c D5h (#35)
c        E  C5  C5^2  C2'  SGH   S5  S5^3 SGV
     &   4, 2,   2,   2,    1,   3,   3,   1,   6*0,
     &   0, 5,   5,   2,    1,   5,   5,   2,   6*0,
     &   0, 1,   2,   2,    0,   1,   3,   0,   6*0,
     &   1, 2,   2,   5,    1,   2,   2,   5,   6*0,
c
c D6h (#36)
c        E  C6  C3  C2  C2'  C2"   i   S6  S3 SGH  SGV  SGD
     &   4, 2,  2,  2,   2,   2,   0,  3,  3,  1,   1,   1,      2*0,
     &   0, 6,  3,  2,   2,   2,   1,  6,  3,  1,   2,   3,      2*0,
     &   0, 1,  1,  0,   2,   3,   0,  1,  1,  0,   0,   0,      2*0,
     &   1, 2,  2,  1,   3,   3,   1,  2,  2,  1,   3,   3,      2*0,
c
c D7h (#37)
c        E  C7 C7^2  C7^3  C2'  SGH   S7  S7^3  S7^5  SGV
     &   4, 2,  2,    2,    2,   1,   3,   3,    3,    1,    4*0,
     &   0, 7,  7,    7,    2,   1,   7,   7,    7,    2,    4*0,
     &   0, 1,  2,    3,    2,   0,   1,   3,    5,    0,    4*0,
     &   1, 2,  2,    2,    7,   1,   2,   2,    2,    7,    4*0,
c
c D8h (#38)
c        E  C8  C4   C8^3  C2  C2'  C2"  i   S8  S4  S8^3  SGH  SGV  SGD
     &   4, 2,  2,    2,    2,  2,   2,  0,  3,  3,    3,   1,   1,   1,
     &   0, 8,  4,    8,    2,  2,   2,  1,  8,  4,    8,   1,   2,   3,
     &   0, 1,  1,    3,    0,  2,   3,  0,  1,  1,    3,   0,   0,   0,
     &   1, 2,  2,    2,    1,  4,   4,  1,  2,  2,    2,   1,   4,   4,
c
c D2d (#39)
c        E  S4  C2  C2'  SGD
     &   4, 3,  2,  2,    1,    9*0,
     &   0, 4,  2,  2,    3,    9*0,
     &   0, 1,  1,  2,    0,    9*0,
     &   1, 2,  1,  2,    2,    9*0,
c
c D3d (#40)
c        E  C3  C2'  i  S6  SGD
     &   4, 2,  2,   0, 3,   1,    8*0,
     &   0, 3,  2,   1, 6,   3,    8*0,
     &   0, 1,  2,   0, 1,   0,    8*0,
     &   1, 2,  3,   1, 2,   3,    8*0,
c
c D4d (#41)
c        E  S8  C4  S8^3  C2  C2'  SGD
     &   4, 3,  2,   3,   2,  2,    1,    7*0,
     &   0, 8,  4,   8,   2,  2,    3,    7*0,
     &   0, 1,  1,   3,   0,  2,    0,    7*0,
     &   1, 2,  2,   2,   1,  4,    4,    7*0,
c
c D5d (#42)
c        E  C5  C5^2  C2'  i   S10  S10^3 SGD
     &   4, 2,   2,   2,   0,   3,    3,   1,   6*0,
     &   0, 5,   5,   2,   1,  10,   10,   3,   6*0,
     &   0, 1,   2,   2,   0,   1,    3,   0,   6*0,
     &   1, 2,   2,   5,   1,   2,    2,   5,   6*0,
c
c D6d (#43)
c        E  S12  C6  S4  C3  S12^5  C2  C2'  SGD  
     &   4,  3,  2,  3,  2,    3,   2,  2,    1,    5*0,
     &   0, 12,  6,  4,  3,   12,   2,  2,    3,    5*0,
     &   0,  1,  1,  1,  1,    5,   0,  2,    0,    5*0,
     &   1,  2,  2,  2,  2,    2,   1,  6,    6,    5*0,
c
c D7d (#44)
c        E  C7 C7^2  C7^3  C2'  i   S14  S14^3 S14^5  SGD
     &   4, 2,  2,    2,    2,  0,    3,   3,    3,    1,    4*0,
     &   0, 7,  7,    7,    2,  1,   14,  14,   14,    3,    4*0,
     &   0, 1,  2,    3,    2,  0,    1,   3,    5,    0,    4*0,
     &   1, 2,  2,    2,    7,  1,    2,   2,    2,    7,    4*0,
c
c D8d (#45)
c        E  S16  C8  S16^3  C4  S16^5 C8^3 S16^7  C2  C2' SGD
     &   4,  3,  2,    3,    2,   3,    2,   3,   2,   2,   1,    3*0,
     &   0, 16,  8,   16,    4,  16,    8,  16,   2,   2,   3,    3*0,
     &   0,  1,  1,    3,    1,   5,    3,   7,   0,   2,   0,    3*0,
     &   1,  2,  2,    2,    2,   2,    2,   2,   1,   8,   8,    3*0,
c
c S4  (#46)
c        E  S4  C2
     &   4, 3,  2,  11*0,
     &   0, 4,  2,  11*0,
     &   0, 1,  1,  11*0,
     &   1, 2,  1,  11*0,
c
c S6  (#47)
c        E   C3  i  S6
     &   4,  2,  0, 3,   10*0,
     &   0,  3,  1, 6,   10*0,
     &   0,  1,  0, 1,   10*0,
     &   1,  2,  1, 2,   10*0,
c
c S8  (#48)
c        E  S8  C4  S8^3  C2
     &   4, 3,  2,   3,   2,   9*0,
     &   0, 8,  4,   8,   2,   9*0,
     &   0, 1,  1,   3,   0,   9*0,
     &   1, 2,  2,   2,   1,   9*0,
c
c T   (#49)
c        E  C3  C2
     &   4, 2,  2,  11*0,
     &   0, 3,  2,  11*0,
     &   0, 1,  0,  11*0,
     &   1, 8,  3,  11*0,
c
c Th  (#50)
c        E  C3  C2  i  S6  SGH
     &   4, 2,  2,  0, 3,   1,   8*0,
     &   0, 3,  2,  1, 6,   1,   8*0,
     &   0, 1,  0,  0, 1,   0,   8*0,
     &   1, 8,  3,  1, 8,   3,   8*0,
c
c Td  (#51)
c        E  C3  C2 S4  SGD
     &   4, 2,  2, 3,   1,   9*0,
     &   0, 3,  2, 4,   3,   9*0,
     &   0, 1,  0, 1,   0,   9*0,
     &   1, 8,  3, 6,   6,   9*0,
c
c O   (#52)
c        E  C3  C2  C4  C2'
     &   4, 2,  2,  2,   2,   9*0,
     &   0, 3,  2,  4,   2,   9*0,
     &   0, 1,  0,  1,   2,   9*0,
     &   1, 8,  3,  6,   6,   9*0,
c
c Oh  (#53)
c        E  C3  C2  C4  C2'  i   S6  SGH  S4  SGD
     &   4, 2,  2,  2,   2,  0,  3,   1,  3,   1,   4*0,
     &   0, 3,  2,  4,   2,  1,  6,   1,  4,   3,   4*0,
     &   0, 1,  0,  1,   2,  0,  1,   0,  1,   0,   4*0,
     &   1, 8,  3,  6,   6,  1,  8,   3,  6,   6,   4*0,
c
c I   (#54)
c        E   C5  C5^2 C3  C2 
     &   4,  2,   2,   2,  2,      9*0,
     &   0,  5,   5,   3,  2,      9*0,
     &   0,  1,   2,   1,  0,      9*0,
     &   1, 12,  12,  20, 15,      9*0,
c
c Ih  (#55)
c        E   C5  C5^2  C3  C2   i   S10  S10^3  S6   SGH 
     &   4,  2,   2,    2,  2,  0,   3,    3,    3,   1,      4*0,
     &   0,  5,   5,    3,  2,  1,  10,   10,    6,   1,      4*0,
     &   0,  1,   2,    1,  0,  0,   1,    3,    1,   0,      4*0,
     &   1, 12,  12,   20, 15,  1,  12,   12,   20,  15,      4*0/
c
      data irsymb/
c
c Symbols of the irreducible representations
c
     & '   A', ' A''', '  A"', '  Ag', '  Au', '   A', '   B', '   A',
     & '   E', '   A', '   B', '   E', '   A', '  E1', '  E2', '   A',
     & '   B', '  E1', '  E2', '   A', '  E1', '  E2', '  E3', '   A',
     & '   B', '  E1', '  E2', '  E3', '   A', '  B1', '  B2', '  B3',
     & '  A1', '  A2', '   E', '  A1', '  A2', '  B1', '  B2', '   E',
     & '  A1', '  A2', '  E1', '  E2', '  A1', '  A2', '  B1', '  B2',
     & '  E1', '  E2', '  A1', '  A2', '  E1', '  E2', '  E3', '  A1',
     & '  A2', '  B1', '  B2', '  E1', '  E2', '  E3', '  A1', '  A2',
     & '  B1', '  B2', '  A1', '  A2', '   E', '  A1', '  A2', '  B1',
     & '  B2', '   E', '  A1', '  A2', '  E1', '  E2', '  A1', '  A2',
     & '  B1', '  B2', '  E1', '  E2', '  A1', '  A2', '  E1', '  E2',
     & '  E3', '  A1', '  A2', '  B1', '  B2', '  E1', '  E2', '  E3',
     & '  Ag', '  Bg', '  Au', '  Bu', ' A''', '  A"', ' E''', '  E"',
     & '  Ag', '  Bg', '  Eg', '  Au', '  Bu', '  Eu', ' A''', '  A"',
     & 'E1''', ' E1"', 'E2''', ' E2"', '  Ag', '  Bg', ' E1g', ' E2g',
     & '  Au', '  Bu', ' E1u', ' E2u', ' A''', '  A"', 'E1''', ' E1"',
     & 'E2''', ' E2"', 'E3''', ' E3"', '  Ag', '  Bg', ' E1g', ' E2g',
     & ' E3g', '  Au', '  Bu', ' E1u', ' E2u', ' E3u', '  Ag', ' B1g',
     & ' B2g', ' B3g', '  Au', ' B1u', ' B2u', ' B3u', 'A1''', ' A1"',
     & 'A2''', ' A2"', ' E''', '  E"', ' A1g', ' A2g', ' B1g', ' B2g',
     & '  Eg', ' A1u', ' A2u', ' B1u', ' B2u', '  Eu', 'A1''', ' A1"',
     & 'A2''', ' A2"', 'E1''', ' E1"', 'E2''', ' E2"', ' A1g', ' A2g',
     & ' B1g', ' B2g', ' E1g', ' E2g', ' A1u', ' A2u', ' B1u', ' B2u',
     & ' E1u', ' E2u', 'A1''', ' A1"', 'A2''', ' A2"', 'E1''', ' E1"',
     & 'E2''', ' E2"', 'E3''', ' E3"', ' A1g', ' A2g', ' B1g', ' B2g',
     & ' E1g', ' E2g', ' E3g', ' A1u', ' A2u', ' B1u', ' B2u', ' E1u',
     & ' E2u', ' E3u', '  A1', '  A2', '  B1', '  B2', '   E', ' A1g',
     & ' A2g', '  Eg', ' A1u', ' A2u', '  Eu', '  A1', '  A2', '  B1',
     & '  B2', '  E1', '  E2', '  E3', ' A1g', ' A2g', ' E1g', ' E2g',
     & ' A1u', ' A2u', ' E1u', ' E2u', '  A1', '  A2', '  B1', '  B2',
     & '  E1', '  E2', '  E3', '  E4', '  E5', ' A1g', ' A2g', ' E1g',
     & ' E2g', ' E3g', ' A1u', ' A2u', ' E1u', ' E2u', ' E3u', '  A1',
     & '  A2', '  B1', '  B2', '  E1', '  E2', '  E3', '  E4', '  E5',
     & '  E6', '  E7', '   A', '   B', '   E', '  Ag', '  Eg', '  Au',
     & '  Eu', '   A', '   B', '  E1', '  E2', '  E3', '   A', '   E',
     & '   T', '  Ag', '  Eg', '  Tg', '  Au', '  Eu', '  Tu', '  A1',
     & '  A2', '   E', '  T1', '  T2', '  A1', '  A2', '   E', '  T1',
     & '  T2', ' A1g', ' A2g', '  Eg', ' T1g', ' T2g', ' A1u', ' A2u',
     & '  Eu', ' T1u', ' T2u', '   A', '  T1', '  T2', '   G', '   H',
     & '  Ag', ' T1g', ' T2g', '  Gg', '  Hg', '  Au', ' T1u', ' T2u',
     & '  Gu', '  Hu'/
c
c Character tables
c
      data chtab(:,1:96)/
c
c C1
c  A
     &  1.000d0,
     &     13*0.d0,
c
c Cs
c  A'
     &  1.000d0, 1.000d0,
     &     12*0.d0,
c  A"
     &  1.000d0,-1.000d0,
     &     12*0.d0,
c
c Ci
c  Ag
     &  1.000d0, 1.000d0,
     &     12*0.d0,
c  Au
     &  1.000d0,-1.000d0,
     &     12*0.d0,
c
c C2
c  A
     &  1.000d0, 1.000d0,
     &     12*0.d0,
c  B
     &  1.000d0,-1.000d0,
     &     12*0.d0,
c
c C3
c  A
     &  1.000d0, 1.000d0,
     &     12*0.d0,
c  E
     &  2.000d0,-1.000d0,
     &     12*0.d0,
c
c C4
c  A
     &  1.000d0, 1.000d0, 1.000d0,
     &     11*0.d0,
c  B
     &  1.000d0,-1.000d0, 1.000d0,
     &     11*0.d0,
c  E
     &  2.000d0, 0.000d0,-2.000d0,
     &     11*0.d0,
c
c C5
c  A
     &  1.000d0, 1.000d0, 1.000d0,
     &     11*0.d0,
c  E1
     &  2.000d0, 0.618d0,-1.618d0,
     &     11*0.d0,
c  E2
     &  2.000d0,-1.618d0, 0.618d0,
     &     11*0.d0,
c
c C6
c  A
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  B
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &     10*0.d0,
c  E1
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0,
     &     10*0.d0,
c  E2
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0,
     &     10*0.d0,
c
c C7
c  A
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  E1
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0,
     &     10*0.d0,
c  E2
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0,
     &     10*0.d0,
c  E3
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0,
     &     10*0.d0,
c
c C8
c  A
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  B
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c  E1
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0,
     &      9*0.d0,
c  E2
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0,
     &      9*0.d0,
c  E3
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0,
     &      9*0.d0,
c
c D2
c  A
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  B1
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &     10*0.d0,
c  B2
     &  1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &     10*0.d0,
c  B3
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &     10*0.d0,
c
c D3
c  A1
     &  1.000d0, 1.000d0, 1.000d0,
     &     11*0.d0,
c  A2
     &  1.000d0, 1.000d0,-1.000d0,
     &     11*0.d0,
c  E
     &  2.000d0,-1.000d0, 0.000d0,
     &     11*0.d0,
c
c D4
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      9*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      9*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c  E
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 0.000d0,
     &      9*0.d0,
c
c D5
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &     10*0.d0,
c  E1
     &  2.000d0, 0.618d0,-1.618d0, 0.000d0,
     &     10*0.d0,
c  E2
     &  2.000d0,-1.618d0, 0.618d0, 0.000d0,
     &     10*0.d0,
c
c D6
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      8*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      8*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &      8*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &      8*0.d0,
c  E1
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0, 0.000d0, 0.000d0,
     &      8*0.d0,
c  E2
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      8*0.d0,
c
c D7
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      9*0.d0,
c  E1
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0, 0.000d0,
     &      9*0.d0,
c  E2
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0, 0.000d0,
     &      9*0.d0,
c  E3
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0, 0.000d0,
     &      9*0.d0,
c
c D8
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      7*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      7*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      7*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      7*0.d0,
c  E1
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c  E2
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c  E3
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c
c C2v
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  A2
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &     10*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &     10*0.d0,
c  B2
     &  1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &     10*0.d0,
c
c C3v
c  A1
     &  1.000d0, 1.000d0, 1.000d0,
     &     11*0.d0,
c  A2
     &  1.000d0, 1.000d0,-1.000d0,
     &     11*0.d0,
c  E
     &  2.000d0,-1.000d0, 0.000d0,
     &     11*0.d0,
c
c C4v
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      9*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      9*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c  E
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 0.000d0,
     &      9*0.d0,
c
c C5v
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &     10*0.d0,
c  E1
     &  2.000d0, 0.618d0,-1.618d0, 0.000d0,
     &     10*0.d0,
c  E2
     &  2.000d0,-1.618d0, 0.618d0, 0.000d0,
     &     10*0.d0,
c
c C6v
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      8*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      8*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &      8*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &      8*0.d0,
c  E1
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0, 0.000d0, 0.000d0,
     &      8*0.d0,
c  E2
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      8*0.d0,
c
c C7v
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      9*0.d0,
c  E1
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0, 0.000d0,
     &      9*0.d0,
c  E2
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0, 0.000d0,
     &      9*0.d0,
c  E3
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0, 0.000d0,
     &      9*0.d0,
c
c C8v
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      7*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      7*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      7*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      7*0.d0,
c  E1
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c  E2
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c  E3
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0/
      data chtab(:,97:142) /
c
c C2h
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  Bg
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &     10*0.d0,
c  Au
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &     10*0.d0,
c  Bu
     &  1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &     10*0.d0,
c
c C3h
c  A'
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  A"
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &     10*0.d0,
c  E'
     &  2.000d0,-1.000d0, 2.000d0,-1.000d0,
     &     10*0.d0,
c  E"
     &  2.000d0,-1.000d0,-2.000d0, 1.000d0,
     &     10*0.d0,
c
c C4h
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      8*0.d0,
c  Bg
     &  1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      8*0.d0,
c  Eg
     &  2.000d0, 0.000d0,-2.000d0, 2.000d0, 0.000d0,-2.000d0,
     &      8*0.d0,
c  Au
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &      8*0.d0,
c  Bu
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &      8*0.d0,
c  Eu
     &  2.000d0, 0.000d0,-2.000d0,-2.000d0, 0.000d0, 2.000d0,
     &      8*0.d0,
c
c C5h
c  A'
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      8*0.d0,
c  A"
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &      8*0.d0,
c  E1'
     &  2.000d0, 0.618d0,-1.618d0, 2.000d0, 0.618d0,-1.618d0,
     &      8*0.d0,
c  E1"
     &  2.000d0, 0.618d0,-1.618d0,-2.000d0,-0.618d0, 1.618d0,
     &      8*0.d0,
c  E2'
     &  2.000d0,-1.618d0, 0.618d0, 2.000d0,-1.618d0, 0.618d0,
     &      8*0.d0,
c  E2"
     &  2.000d0,-1.618d0, 0.618d0,-2.000d0, 1.618d0,-0.618d0,
     &      8*0.d0,
c
c C6h
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  Bg
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  E1g
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0, 2.000d0,-1.000d0, 1.000d0,
     & -2.000d0,
     &      6*0.d0,
c  E2g
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0, 2.000d0,-1.000d0,-1.000d0,
     &  2.000d0,
     &      6*0.d0,
c  Au
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  Bu
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  E1u
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0,-2.000d0, 1.000d0,-1.000d0,
     &  2.000d0,
     &      6*0.d0,
c  E2u
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0,-2.000d0, 1.000d0, 1.000d0,
     & -2.000d0,
     &      6*0.d0,
c
c C7h
c  A'
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  A"
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  E1'
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0, 2.000d0, 1.247d0,-1.802d0,
     & -0.445d0,
     &      6*0.d0,
c  E1"
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0,-2.000d0,-1.247d0, 1.802d0,
     &  0.445d0,
     &      6*0.d0,
c  E2'
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0, 2.000d0,-0.445d0, 1.247d0,
     & -1.802d0,
     &      6*0.d0,
c  E2"
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0,-2.000d0, 0.445d0,-1.247d0,
     &  1.802d0,
     &      6*0.d0,
c  E3'
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0, 2.000d0,-1.802d0,-0.445d0,
     &  1.247d0,
     &      6*0.d0,
c  E3"
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0,-2.000d0, 1.802d0, 0.445d0,
     & -1.247d0,
     &      6*0.d0,
c
c C8h
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  Bg
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &  1.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  E1g
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0, 2.000d0,-1.414d0,
     &  0.000d0, 1.414d0,-2.000d0,
     &      4*0.d0,
c  E2g
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 2.000d0, 0.000d0,
     & -2.000d0, 0.000d0, 2.000d0,
     &      4*0.d0,
c  E3g
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 2.000d0, 1.414d0,
     &  0.000d0,-1.414d0,-2.000d0,
     &      4*0.d0,
c  Au
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  Bu
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     & -1.000d0, 1.000d0,-1.000d0,
     &      4*0.d0,
c  E1u
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0,-2.000d0, 1.414d0,
     &  0.000d0,-1.414d0, 2.000d0,
     &      4*0.d0,
c  E2u
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0,-2.000d0, 0.000d0,
     &  2.000d0, 0.000d0,-2.000d0,
     &      4*0.d0,
c  E3u
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0,-2.000d0,-1.414d0,
     &  0.000d0, 1.414d0, 2.000d0,
     &      4*0.d0/
      data chtab(:,143:210) /
c
c D2h
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  B1g
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  B2g
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  B3g
     &  1.000d0,-1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  Au
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  B1u
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  B2u
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  B3u
     &  1.000d0,-1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,
     & -1.000d0,
     &      6*0.d0,
c
c D3h
c  A1'
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      8*0.d0,
c  A1"
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &      8*0.d0,
c  A2'
     &  1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      8*0.d0,
c  A2"
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &      8*0.d0,
c  E'
     &  2.000d0,-1.000d0, 0.000d0, 2.000d0,-1.000d0, 0.000d0,
     &      8*0.d0,
c  E"
     &  2.000d0,-1.000d0, 0.000d0,-2.000d0, 1.000d0, 0.000d0,
     &      8*0.d0,
c
c D4h
c  A1g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  A2g
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  B1g
     &  1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &  1.000d0, 1.000d0,-1.000d0,
     &      4*0.d0,
c  B2g
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &  1.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  Eg
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 0.000d0, 2.000d0, 0.000d0,
     & -2.000d0, 0.000d0, 0.000d0,
     &      4*0.d0,
c  A1u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  A2u
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  B1u
     &  1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0,
     & -1.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  B2u
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     & -1.000d0, 1.000d0,-1.000d0,
     &      4*0.d0,
c  Eu
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 0.000d0,-2.000d0, 0.000d0,
     &  2.000d0, 0.000d0, 0.000d0,
     &      4*0.d0,
c
c D5h
c  A1'
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  A1"
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  A2'
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0, 1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  A2"
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  E1'
     &  2.000d0, 0.618d0,-1.618d0, 0.000d0, 2.000d0, 0.618d0,-1.618d0,
     &  0.000d0,
     &      6*0.d0,
c  E1"
     &  2.000d0, 0.618d0,-1.618d0, 0.000d0,-2.000d0,-0.618d0, 1.618d0,
     &  0.000d0,
     &      6*0.d0,
c  E2'
     &  2.000d0,-1.618d0, 0.618d0, 0.000d0, 2.000d0,-1.618d0, 0.618d0,
     &  0.000d0,
     &      6*0.d0,
c  E2"
     &  2.000d0,-1.618d0, 0.618d0, 0.000d0,-2.000d0, 1.618d0,-0.618d0,
     &  0.000d0,
     &      6*0.d0,
c
c D6h
c  A1g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      2*0.d0,
c  A2g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      2*0.d0,
c  B1g
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &  1.000d0,-1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &      2*0.d0,
c  B2g
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,-1.000d0,-1.000d0, 1.000d0,-1.000d0,
     &      2*0.d0,
c  E1g
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0, 0.000d0, 0.000d0, 2.000d0,
     & -1.000d0, 1.000d0,-2.000d0, 0.000d0, 0.000d0,
     &      2*0.d0,
c  E2g
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0, 2.000d0,
     & -1.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      2*0.d0,
c  A1u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &      2*0.d0,
c  A2u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0, 1.000d0, 1.000d0,
     &      2*0.d0,
c  B1u
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      2*0.d0,
c  B2u
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0,-1.000d0,
     & -1.000d0, 1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      2*0.d0,
c  E1u
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0, 0.000d0, 0.000d0,-2.000d0,
     &  1.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      2*0.d0,
c  E2u
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,-2.000d0,
     &  1.000d0, 1.000d0,-2.000d0, 0.000d0, 0.000d0,
     &      2*0.d0,
c
c D7h
c  A1'
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  A1"
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  A2'
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0,-1.000d0,
     &      4*0.d0,
c  A2"
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  E1'
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0, 0.000d0, 2.000d0, 1.247d0,
     & -1.802d0,-0.445d0, 0.000d0,
     &      4*0.d0,
c  E1"
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0, 0.000d0,-2.000d0,-1.247d0,
     &  1.802d0, 0.445d0, 0.000d0,
     &      4*0.d0,
c  E2'
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0, 0.000d0, 2.000d0,-0.445d0,
     &  1.247d0,-1.802d0, 0.000d0,
     &      4*0.d0,
c  E2"
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0, 0.000d0,-2.000d0, 0.445d0,
     & -1.247d0, 1.802d0, 0.000d0,
     &      4*0.d0,
c  E3'
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0, 0.000d0, 2.000d0,-1.802d0,
     & -0.445d0, 1.247d0, 0.000d0,
     &      4*0.d0,
c  E3"
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0, 0.000d0,-2.000d0, 1.802d0,
     &  0.445d0,-1.247d0, 0.000d0,
     &      4*0.d0,
c
c D8h
c  A1g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,

c  A2g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,

c  B1g
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,

c  B2g
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,

c  E1g
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 0.000d0, 0.000d0,

c  E2g
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0, 0.000d0,
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0, 0.000d0,

c  E3g
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0, 0.000d0, 0.000d0,

c  A1u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,

c  A2u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0, 1.000d0, 1.000d0,

c  B1u
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     & -1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0,

c  B2u
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     & -1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0,

c  E1u
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0, 0.000d0, 0.000d0,
     & -2.000d0, 1.414d0, 0.000d0,-1.414d0, 2.000d0, 0.000d0, 0.000d0,

c  E2u
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0, 0.000d0,
     & -2.000d0, 0.000d0, 2.000d0, 0.000d0,-2.000d0, 0.000d0, 0.000d0,

c  E3u
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 0.000d0, 0.000d0,
     & -2.000d0,-1.414d0, 0.000d0, 1.414d0, 2.000d0, 0.000d0, 0.000d0/
c
      data chtab(:,211:307) /
c
c D2d
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      9*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      9*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c  E
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 0.000d0,
     &      9*0.d0,
c
c D3d
c  A1g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      8*0.d0,
c  A2g
     &  1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      8*0.d0,
c  Eg
     &  2.000d0,-1.000d0, 0.000d0, 2.000d0,-1.000d0, 0.000d0,
     &      8*0.d0,
c  A1u
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &      8*0.d0,
c  A2u
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0, 1.000d0,
     &      8*0.d0,
c  Eu
     &  2.000d0,-1.000d0, 0.000d0,-2.000d0, 1.000d0, 0.000d0,
     &      8*0.d0,
c
c D4d
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      7*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      7*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      7*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      7*0.d0,
c  E1
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c  E2
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c  E3
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 0.000d0, 0.000d0,
     &      7*0.d0,
c
c D5d
c  A1g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  A2g
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0, 1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  E1g
     &  2.000d0, 0.618d0,-1.618d0, 0.000d0, 2.000d0,-1.618d0, 0.618d0,
     &  0.000d0,
     &      6*0.d0,
c  E2g
     &  2.000d0,-1.618d0, 0.618d0, 0.000d0, 2.000d0, 0.618d0,-1.618d0,
     &  0.000d0,
     &      6*0.d0,
c  A1u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,
     &      6*0.d0,
c  A2u
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &  1.000d0,
     &      6*0.d0,
c  E1u
     &  2.000d0, 0.618d0,-1.618d0, 0.000d0,-2.000d0, 1.618d0,-0.618d0,
     &  0.000d0,
     &      6*0.d0,
c  E2u
     &  2.000d0,-1.618d0, 0.618d0, 0.000d0,-2.000d0,-0.618d0, 1.618d0,
     &  0.000d0,
     &      6*0.d0,
c
c D6d
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0,
     &      5*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     & -1.000d0,-1.000d0,
     &      5*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &  1.000d0,-1.000d0,
     &      5*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     & -1.000d0, 1.000d0,
     &      5*0.d0,
c  E1
     &  2.000d0, 1.732d0, 1.000d0, 0.000d0,-1.000d0,-1.732d0,-2.000d0,
     &  0.000d0, 0.000d0,
     &      5*0.d0,
c  E2
     &  2.000d0, 1.000d0,-1.000d0,-2.000d0,-1.000d0, 1.000d0, 2.000d0,
     &  0.000d0, 0.000d0,
     &      5*0.d0,
c  E3
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0,-2.000d0,
     &  0.000d0, 0.000d0,
     &      5*0.d0,
c  E4
     &  2.000d0,-1.000d0,-1.000d0, 2.000d0,-1.000d0,-1.000d0, 2.000d0,
     &  0.000d0, 0.000d0,
     &      5*0.d0,
c  E5
     &  2.000d0,-1.732d0, 1.000d0, 0.000d0,-1.000d0, 1.732d0,-2.000d0,
     &  0.000d0, 0.000d0,
     &      5*0.d0,
c
c D7d
c  A1g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  A2g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0,-1.000d0,
     &      4*0.d0,
c  E1g
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0, 0.000d0, 2.000d0,-1.802d0,
     & -0.445d0, 1.247d0, 0.000d0,
     &      4*0.d0,
c  E2g
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0, 0.000d0, 2.000d0, 1.247d0,
     & -1.802d0,-0.445d0, 0.000d0,
     &      4*0.d0,
c  E3g
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0, 0.000d0, 2.000d0,-0.445d0,
     &  1.247d0,-1.802d0, 0.000d0,
     &      4*0.d0,
c  A1u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  A2u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  E1u
     &  2.000d0, 1.247d0,-0.445d0,-1.802d0, 0.000d0,-2.000d0, 1.802d0,
     &  0.445d0,-1.247d0, 0.000d0,
     &      4*0.d0,
c  E2u
     &  2.000d0,-0.445d0,-1.802d0, 1.247d0, 0.000d0,-2.000d0,-1.247d0,
     &  1.802d0, 0.445d0, 0.000d0,
     &      4*0.d0,
c  E3u
     &  2.000d0,-1.802d0, 1.247d0,-0.445d0, 0.000d0,-2.000d0, 0.445d0,
     & -1.247d0, 1.802d0, 0.000d0,
     &      4*0.d0,
c
c D8d
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      3*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      3*0.d0,
c  B1
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     & -1.000d0, 1.000d0, 1.000d0,-1.000d0,
     &      3*0.d0,
c  B2
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     & -1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      3*0.d0,
c  E1
     &  2.000d0, 1.848d0, 1.414d0, 0.765d0, 0.000d0,-0.765d0,-1.414d0,
     & -1.848d0,-2.000d0, 0.000d0, 0.000d0,
     &      3*0.d0,
c  E2
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0,-1.414d0, 0.000d0,
     &  1.414d0, 2.000d0, 0.000d0, 0.000d0,
     &      3*0.d0,
c  E3
     &  2.000d0, 0.765d0,-1.414d0,-1.848d0, 0.000d0, 1.848d0, 1.414d0,
     & -0.765d0,-2.000d0, 0.000d0, 0.000d0,
     &      3*0.d0,
c  E4
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0, 0.000d0,-2.000d0,
     &  0.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      3*0.d0,
c  E5
     &  2.000d0,-0.765d0,-1.414d0, 1.848d0, 0.000d0,-1.848d0, 1.414d0,
     &  0.765d0,-2.000d0, 0.000d0, 0.000d0,
     &      3*0.d0,
c  E6
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0, 1.414d0, 0.000d0,
     & -1.414d0, 2.000d0, 0.000d0, 0.000d0,
     &      3*0.d0,
c  E7
     &  2.000d0,-1.848d0, 1.414d0,-0.765d0, 0.000d0, 0.765d0,-1.414d0,
     &  1.848d0,-2.000d0, 0.000d0, 0.000d0,
     &      3*0.d0,
c
c S4
c  A
     &  1.000d0, 1.000d0, 1.000d0,
     &     11*0.d0,
c  B
     &  1.000d0,-1.000d0, 1.000d0,
     &     11*0.d0,
c  E
     &  2.000d0, 0.000d0,-2.000d0,
     &     11*0.d0,
c
c S6
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &     10*0.d0,
c  Eg
     &  2.000d0,-1.000d0, 2.000d0,-1.000d0,
     &     10*0.d0,
c  Au
     &  1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &     10*0.d0,
c  Eu
     &  2.000d0,-1.000d0,-2.000d0, 1.000d0,
     &     10*0.d0,
c
c S8
c  A
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  B
     &  1.000d0,-1.000d0, 1.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c  E1
     &  2.000d0, 1.414d0, 0.000d0,-1.414d0,-2.000d0,
     &      9*0.d0,
c  E2
     &  2.000d0, 0.000d0,-2.000d0, 0.000d0, 2.000d0,
     &      9*0.d0,
c  E3
     &  2.000d0,-1.414d0, 0.000d0, 1.414d0,-2.000d0,
     &      9*0.d0,
c
c T
c  A
     &  1.000d0, 1.000d0, 1.000d0,
     &     11*0.d0,
c  E
     &  2.000d0,-1.000d0, 2.000d0,
     &     11*0.d0,
c  T
     &  3.000d0, 0.000d0,-1.000d0,
     &     11*0.d0,
c
c Th
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      8*0.d0,
c  Eg
     &  2.000d0,-1.000d0, 2.000d0, 2.000d0,-1.000d0, 2.000d0,
     &      8*0.d0,
c  Tg
     &  3.000d0, 0.000d0,-1.000d0, 3.000d0, 0.000d0,-1.000d0,
     &      8*0.d0,
c  Au
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,
     &      8*0.d0,
c  Eu
     &  2.000d0,-1.000d0, 2.000d0,-2.000d0, 1.000d0,-2.000d0,
     &      8*0.d0,
c  Tu
     &  3.000d0, 0.000d0,-1.000d0,-3.000d0, 0.000d0, 1.000d0,
     &      8*0.d0,
c
c Td
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      9*0.d0,
c  E
     &  2.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      9*0.d0,
c  T1
     &  3.000d0, 0.000d0,-1.000d0, 1.000d0,-1.000d0,
     &      9*0.d0,
c  T2
     &  3.000d0, 0.000d0,-1.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c
c O
c  A1
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  A2
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     &      9*0.d0,
c  E
     &  2.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,
     &      9*0.d0,
c  T1
     &  3.000d0, 0.000d0,-1.000d0, 1.000d0,-1.000d0,
     &      9*0.d0,
c  T2
     &  3.000d0, 0.000d0,-1.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c
c Oh
c  A1g
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  A2g
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0, 1.000d0, 1.000d0,
     &  1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  Eg
     &  2.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0, 2.000d0,-1.000d0,
     &  2.000d0, 0.000d0, 0.000d0,
     &      4*0.d0,
c  T1g
     &  3.000d0, 0.000d0,-1.000d0, 1.000d0,-1.000d0, 3.000d0, 0.000d0,
     & -1.000d0, 1.000d0,-1.000d0,
     &      4*0.d0,
c  T2g
     &  3.000d0, 0.000d0,-1.000d0,-1.000d0, 1.000d0, 3.000d0, 0.000d0,
     & -1.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  A1u
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  A2u
     &  1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,-1.000d0,-1.000d0,
     & -1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  Eu
     &  2.000d0,-1.000d0, 2.000d0, 0.000d0, 0.000d0,-2.000d0, 1.000d0,
     & -2.000d0, 0.000d0, 0.000d0,
     &      4*0.d0,
c  T1u
     &  3.000d0, 0.000d0,-1.000d0, 1.000d0,-1.000d0,-3.000d0, 0.000d0,
     &  1.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  T2u
     &  3.000d0, 0.000d0,-1.000d0,-1.000d0, 1.000d0,-3.000d0, 0.000d0,
     &  1.000d0, 1.000d0,-1.000d0,
     &      4*0.d0/
c
      data chtab(:,308:) /
c
c I
c  A
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &      9*0.d0,
c  T1
     &  3.000d0, 1.618d0,-0.618d0, 0.000d0,-1.000d0,
     &      9*0.d0,
c  T2
     &  3.000d0,-0.618d0, 1.618d0, 0.000d0,-1.000d0,
     &      9*0.d0,
c  G
     &  4.000d0,-1.000d0,-1.000d0, 1.000d0, 0.000d0,
     &      9*0.d0,
c  H
     &  5.000d0, 0.000d0, 0.000d0,-1.000d0, 1.000d0,
     &      9*0.d0,
c
c Ih
c  Ag
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,
     &  1.000d0, 1.000d0, 1.000d0,
     &      4*0.d0,
c  T1g
     &  3.000d0, 1.618d0,-0.618d0, 0.000d0,-1.000d0, 3.000d0,-0.618d0,
     &  1.618d0, 0.000d0,-1.000d0,
     &      4*0.d0,
c  T2g
     &  3.000d0,-0.618d0, 1.618d0, 0.000d0,-1.000d0, 3.000d0, 1.618d0,
     & -0.618d0, 0.000d0,-1.000d0,
     &      4*0.d0,
c  Gg
     &  4.000d0,-1.000d0,-1.000d0, 1.000d0, 0.000d0, 4.000d0,-1.000d0,
     & -1.000d0, 1.000d0, 0.000d0,
     &      4*0.d0,
c  Hg
     &  5.000d0, 0.000d0, 0.000d0,-1.000d0, 1.000d0, 5.000d0, 0.000d0,
     &  0.000d0,-1.000d0, 1.000d0,
     &      4*0.d0,
c  Au
     &  1.000d0, 1.000d0, 1.000d0, 1.000d0, 1.000d0,-1.000d0,-1.000d0,
     & -1.000d0,-1.000d0,-1.000d0,
     &      4*0.d0,
c  T1u
     &  3.000d0, 1.618d0,-0.618d0, 0.000d0,-1.000d0,-3.000d0, 0.618d0,
     & -1.618d0, 0.000d0, 1.000d0,
     &      4*0.d0,
c  T2u
     &  3.000d0,-0.618d0, 1.618d0, 0.000d0,-1.000d0,-3.000d0,-1.618d0,
     &  0.618d0, 0.000d0, 1.000d0,
     &      4*0.d0,
c  Gu
     &  4.000d0,-1.000d0,-1.000d0, 1.000d0, 0.000d0,-4.000d0, 1.000d0,
     &  1.000d0,-1.000d0, 0.000d0,
     &      4*0.d0,
c  Hu
     &  5.000d0, 0.000d0, 0.000d0,-1.000d0, 1.000d0,-5.000d0, 0.000d0,
     &  0.000d0, 1.000d0,-1.000d0,
     &      4*0.d0/
c
      data nrotharm/
     &   3, 3, 5,   1, 2, 3,   2, 1, 2,   3, 0, 5,   0, 3, 0,   1, 1, 3,
     &   2, 2, 2,   1, 1, 1,   2, 2, 4,   1, 1, 1,   0, 0, 2,   2, 2, 2,
     &   1, 1, 1,   2, 2, 2,   0, 0, 2,   1, 1, 1,   0, 0, 0,   2, 2, 2,
     &   0, 0, 2,   1, 1, 1,   2, 2, 2,   0, 0, 2,   0, 0, 0,   1, 1, 1,
     &   0, 0, 0,   2, 2, 2,   0, 0, 2,   0, 0, 0,   0, 0, 2,   1, 1, 1,
     &   1, 1, 1,   1, 1, 1,   0, 0, 1,   1, 1, 0,   2, 2, 4,   0, 0, 1,
     &   1, 1, 0,   0, 0, 1,   0, 0, 1,   2, 2, 2,   0, 0, 1,   1, 1, 0,
     &   2, 2, 2,   0, 0, 2,   0, 0, 1,   1, 1, 0,   0, 0, 0,   0, 0, 0,
     &   2, 2, 2,   0, 0, 2,   0, 0, 1,   1, 1, 0,   2, 2, 2,   0, 0, 2,
     &   0, 0, 0,   0, 0, 1,   1, 1, 0,   0, 0, 0,   0, 0, 0,   2, 2, 2,
     &   0, 0, 2,   0, 0, 0,   0, 1, 2,   1, 0, 1,   1, 1, 1,   1, 1, 1,
     &   0, 1, 1,   1, 0, 0,   2, 2, 4,   0, 1, 1,   1, 0, 0,   0, 0, 1,
     &   0, 0, 1,   2, 2, 2,   0, 1, 1,   1, 0, 0,   2, 2, 2,   0, 0, 2,
     &   0, 1, 1,   1, 0, 0,   0, 0, 0,   0, 0, 0,   2, 2, 2,   0, 0, 2,
     &   0, 1, 1,   1, 0, 0,   2, 2, 2,   0, 0, 2,   0, 0, 0,   0, 1, 1,
     &   1, 0, 0,   0, 0, 0,   0, 0, 0,   2, 2, 2,   0, 0, 2,   0, 0, 0,
     &   1, 0, 3,   2, 0, 2,   0, 1, 0,   0, 2, 0,   1, 0, 1,   0, 1, 0,
     &   0, 2, 2,   2, 0, 2,   1, 0, 1,   0, 0, 2,   2, 0, 2,   0, 1, 0,
     &   0, 0, 0,   0, 2, 0,   1, 0, 1,   0, 1, 0,   0, 2, 0,   2, 0, 2,
     &   0, 0, 2,   0, 0, 0,   1, 0, 1,   0, 0, 0,   2, 0, 2,   0, 0, 2,
     &   0, 1, 0,   0, 0, 0,   0, 2, 0,   0, 0, 0,   1, 0, 1,   0, 1, 0,
     &   0, 2, 0,   2, 0, 2,   0, 0, 2,   0, 0, 0,   0, 0, 0,   0, 0, 0,
     &   1, 0, 1,   0, 0, 0,   2, 0, 2,   0, 0, 2,   0, 0, 0,   0, 1, 0,
     &   0, 0, 0,   0, 2, 0,   0, 0, 0,   0, 0, 0,   0, 0, 2,   1, 0, 1,
     &   1, 0, 1,   1, 0, 1,   0, 0, 0,   0, 1, 0,   0, 1, 0,   0, 1, 0,
     &   0, 0, 1,   0, 0, 0,   1, 0, 0,   0, 1, 0,   0, 2, 2,   2, 0, 2,
     &   0, 0, 1,   1, 0, 0,   0, 0, 1,   0, 0, 1,   2, 0, 2,   0, 0, 0,
     &   0, 1, 0,   0, 0, 0,   0, 0, 0,   0, 2, 0,   0, 0, 1,   0, 0, 0,
     &   1, 0, 0,   0, 1, 0,   0, 2, 0,   2, 0, 2,   0, 0, 2,   0, 0, 0,
     &   0, 0, 1,   1, 0, 0,   0, 0, 0,   0, 0, 0,   2, 0, 2,   0, 0, 2,
     &   0, 0, 0,   0, 1, 0,   0, 0, 0,   0, 0, 0,   0, 2, 0,   0, 0, 0,
     &   0, 0, 1,   0, 0, 0,   1, 0, 0,   0, 1, 0,   0, 2, 0,   2, 0, 2,
     &   0, 0, 2,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 1,   1, 0, 0,
     &   0, 0, 0,   0, 0, 0,   2, 0, 2,   0, 0, 2,   0, 0, 0,   0, 0, 0,
     &   0, 1, 0,   0, 0, 0,   0, 0, 0,   0, 2, 0,   0, 0, 0,   0, 0, 0,
     &   0, 0, 1,   1, 0, 0,   0, 0, 1,   0, 1, 1,   2, 2, 2,   0, 0, 1,
     &   1, 0, 0,   2, 0, 4,   0, 0, 0,   0, 1, 0,   0, 2, 0,   0, 0, 1,
     &   1, 0, 0,   0, 0, 0,   0, 1, 0,   0, 2, 0,   0, 0, 2,   2, 0, 2,
     &   0, 0, 1,   1, 0, 0,   2, 0, 2,   0, 0, 2,   0, 0, 0,   0, 1, 0,
     &   0, 2, 0,   0, 0, 0,   0, 0, 1,   1, 0, 0,   0, 0, 0,   0, 1, 0,
     &   0, 2, 0,   0, 0, 2,   0, 0, 0,   0, 0, 0,   2, 0, 2,   0, 0, 1,
     &   1, 0, 0,   2, 0, 2,   0, 0, 2,   0, 0, 0,   0, 0, 0,   0, 1, 0,
     &   0, 2, 0,   0, 0, 0,   0, 0, 0,   0, 0, 1,   1, 0, 0,   0, 0, 0,
     &   0, 1, 0,   0, 2, 0,   0, 0, 2,   0, 0, 0,   0, 0, 0,   0, 0, 0,
     &   0, 0, 0,   2, 0, 2,   1, 0, 1,   0, 1, 2,   2, 2, 2,   1, 0, 1,
     &   2, 0, 4,   0, 1, 0,   0, 2, 0,   1, 0, 1,   0, 1, 0,   0, 2, 0,
     &   0, 0, 2,   2, 0, 2,   0, 0, 0,   0, 0, 2,   3, 3, 3,   0, 0, 0,
     &   0, 0, 2,   3, 0, 3,   0, 0, 0,   0, 0, 0,   0, 3, 0,   0, 0, 0,
     &   0, 0, 0,   0, 0, 2,   3, 0, 0,   0, 3, 3,   0, 0, 0,   0, 0, 0,
     &   0, 0, 2,   3, 3, 0,   0, 0, 3,   0, 0, 0,   0, 0, 0,   0, 0, 2,
     &   3, 0, 0,   0, 0, 3,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 3, 0,
     &   0, 0, 0,   0, 0, 0,   3, 3, 0,   0, 0, 0,   0, 0, 0,   0, 0, 5,
     &   0, 0, 0,   3, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 5,   0, 0, 0,
     &   0, 3, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0/
c subgroups
      data nsgr/
     &  1,  1,  2,  1,  3,  1,  4,  1,  5,  1,  4,  6,  1,  7,  1,
     &  4,  5,  8,  1,  9,  1,  4,  6, 10,  1,  4, 11,  1,  4,  5,
     & 12,  1,  4,  6, 11, 13,  1,  4,  7, 14,  1,  4,  5,  8, 11,
     & 12, 15,  1,  4,  9, 16,  1,  4,  6, 10, 11, 13, 17,  1,  2,
     &  4, 18,  1,  2,  5, 19,  1,  2,  4,  6, 18, 20,  1,  2,  7,
     & 21,  1,  2,  4,  5,  8, 18, 19, 22,  1,  2,  9, 23,  1,  2,
     &  4,  6, 10, 18, 20, 24,  1,  2,  3,  4, 25,  1,  2,  5, 26,
     &  1,  2,  3,  4,  6, 25, 46, 27,  1,  2,  7, 28,  1,  2,  3,
     &  4,  5,  8, 25, 26, 47, 29,  1,  2,  9, 30,  1,  2,  3,  4,
     &  6, 10, 25, 27, 48, 31,  1,  2,  3,  4, 18, 25, 32,  1,  2,
     &  4,  5, 12, 18, 19, 26, 33,  1,  2,  3,  4,  6, 11, 13, 18,
     & 20, 25, 27, 32, 39, 46, 34,  1,  2,  4,  7, 14, 18, 21, 28,
     & 35,  1,  2,  3,  4,  5,  8, 11, 12, 15, 18, 19, 22, 25, 26,
     & 29, 32, 33, 40, 47, 36,  1,  2,  4,  9, 16, 18, 23, 30, 37,
     &  1,  2,  3,  4,  6, 10, 11, 13, 17, 18, 20, 24, 25, 27, 31,
     & 32, 34, 39, 41, 46, 48, 38,  1,  2,  4, 11, 18, 46, 39,  1,
     &  2,  3,  4,  5, 12, 19, 47, 40,  1,  2,  4,  6, 11, 13, 18,
     & 20, 48, 41,  1,  2,  3,  4,  7, 14, 21, 42,  1,  2,  4,  5,
     &  8, 11, 12, 15, 18, 19, 22, 46, 43,  1,  2,  3,  4,  9, 16,
     & 23, 44,  1,  2,  4,  6, 10, 11, 13, 17, 18, 20, 24, 45,  1,
     &  4, 46,  1,  3,  5, 47,  1,  4,  6, 48,  1,  4,  5, 11, 49,
     &  1,  2,  3,  4,  5, 11, 18, 25, 32, 47, 49, 50,  1,  2,  4,
     &  5, 11, 18, 19, 39, 46, 49, 51,  1,  4,  5,  6, 11, 12, 13,
     & 49, 52,  1,  2,  3,  4,  5,  6, 11, 12, 13, 18, 19, 20, 25,
     & 27, 32, 34, 39, 40, 46, 47, 49, 50, 51, 52, 53,  1,  4,  5,
     &  7, 11, 12, 14, 49, 54,  1,  2,  3,  4,  5,  7, 11, 12, 14,
     & 18, 19, 21, 25, 32, 40, 42, 47, 49, 50, 54, 55,  1, 56,  1,
     & 57/

      data nsgb/
     &   1,   1,     2,   2,     4,   2,     6,   2,     8,   2,
     &  10,   3,    13,   2,    15,   4,    19,   2,    21,   4,
     &  25,   3,    28,   4,    32,   5,    37,   4,    41,   7,
     &  48,   4,    52,   7,    59,   4,    63,   4,    67,   6,
     &  73,   4,    77,   8,    85,   4,    89,   8,    97,   5,
     & 102,   4,   106,   8,   114,   4,   118,  10,   128,   4,
     & 132,  10,   142,   7,   149,   9,   158,  15,   173,   9,
     & 182,  20,   202,   9,   211,  22,   233,   7,   240,   9,
     & 249,  10,   259,   8,   267,  13,   280,   8,   288,  12,
     & 300,   3,   303,   4,   307,   4,   311,   5,   316,  12,
     & 328,  11,   339,   9,   348,  25,   373,   9,   382,  21,
     & 403,   2,   405,   2/

      end
      
      
************************************************************************
      subroutine syva_cmass(natoms,nat,wt,coord,wmol,cmx,cmy,cmz)
************************************************************************
* Subroutine syva_cmass calculates the centre of mass of a molecule         *
************************************************************************
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension wt(90),coord(3,natoms),nat(natoms)
      sumwx=0.d0
      sumwy=0.d0
      sumwz=0.d0
      wmol=0.d0
      do i=1,natoms
         nati=nat(i)
         wmol=wmol+wt(nati)
         sumwx=sumwx+wt(nati)*coord(1,i)
         sumwy=sumwy+wt(nati)*coord(2,i)
         sumwz=sumwz+wt(nati)*coord(3,i)
      end do
      cmx=sumwx/wmol
      cmy=sumwy/wmol
      cmz=sumwz/wmol
      return
      end
************************************************************************
      subroutine syva_cshift(natoms,coord,pc)
************************************************************************
* Subroutine cshift shifts the centre of mass of a molecule into the
* origin
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension coord(3,natoms),pc(3)
      do i=1,natoms
         coord(1,i)=coord(1,i)-pc(1)
         coord(2,i)=coord(2,i)-pc(2)
         coord(3,i)=coord(3,i)-pc(3)
      end do
      return
      end

      
************************************************************************
      integer function syva_igcd(i1,i2)
************************************************************************
c
c Calculation of the greatest common divisor of two integers
c
      integer i1,i2,i,j,k
      i=i1
      j=i2
      do
         k=j
         j=mod(i,k)
         i=k
         if(j.eq.0) then
            syva_igcd=i
            return
         end if
      end do
      end
************************************************************************
      double precision function syva_dot(x,y,n)                         
************************************************************************
c
c Scalar (dot or inner) product of two vectors: <x|y>=x.y
c
      implicit double precision(a-h,o-z)                               
      implicit integer(i-n)
      dimension x(*),y(*)                                         
      syva_dot=0.d0                                                          
      do i=1,n                                                          
         syva_dot=syva_dot+x(i)*y(i)                                              
      end do                                                            
      return                                                            
      end                                                               
************************************************************************
      subroutine syva_crossp(x,y,z)
************************************************************************
c
c Vector (cross or outer) product of two vectors: z=[x,y] 
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension x(3),y(3),z(3)
      z(1)=x(2)*y(3)-x(3)*y(2)
      z(2)=-x(1)*y(3)+x(3)*y(1)
      z(3)=x(1)*y(2)-x(2)*y(1)
      return
      end

************************************************************************
      logical function issubgroup(pg1, pg2)
************************************************************************
      implicit none
      character pg1*3, pg2*3

      integer nir, nsymop, nrotharm
      double precision chtab
      character pgsymb*3, irsymb*4
      common/chartab/ nir(2,55),chtab(14,322),
     &   nsymop(14,4,55),nrotharm(3,322),pgsymb(57),irsymb(322)
      integer nsgb, nsgr
      common/subgroups/ nsgb(2,57),nsgr(406)

      integer i, npg

      do npg=1,57
         if(adjustl(pg2).eq.adjustl(pgsymb(npg))) exit
      end do
      do i=nsgb(1,npg),nsgb(1,npg)+nsgb(2,npg)-1
        if(adjustl(pgsymb(nsgr(i))).eq.adjustl(pg1)) then
          issubgroup=.true.
          return
        end if
      end do
      issubgroup=.false.
      end function issubgroup
      
      
************************************************************************
      subroutine syva_inversion(natoms,nat,coord,delta,nc,ntrans,delta3)
************************************************************************
c
c Performs an inversion to the origin
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension nat(natoms),coord(3,natoms)
      dimension cord(3,natoms),ntrans(natoms)
      do i=1,3
         do j=1,natoms
            cord(i,j)=-coord(i,j)
         end do
      end do
      call syva_check(natoms,delta,nat,coord,cord,nc,ntrans,delta3)
      if(nc.ne.natoms) then
         do i=1,natoms
            ntrans(i)=i
         end do
      end if
      return
      end
************************************************************************
      subroutine syva_rotate(natoms,nat,coord,v1,sina,cosa,delta,
     &   nc,ntrans,delta3)
************************************************************************
c
c Performs a rotation around axis v1
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension nat(natoms),coord(3,natoms)
      dimension cord(3,natoms),ntrans(natoms)
      dimension v1(3),v2(3),v3(3),p0(3),p(3)
      do j=1,natoms
         p0(1)=coord(1,j)
         p0(2)=coord(2,j)
         p0(3)=coord(3,j)
         call syva_crossp(v1,p0,v2)
         call syva_crossp(v1,v2,v3)
         p=p0+sina*v2+(1.d0-cosa)*v3
         cord(1,j)=p(1)
         cord(2,j)=p(2)
         cord(3,j)=p(3)
      end do
      call syva_check(natoms,delta,nat,coord,cord,nc,ntrans,delta3)
      return
      end
************************************************************************
      subroutine syva_reflect(natoms,nat,coord,v,p0,delta,nc,
     & ntrans,delta3)
************************************************************************
c
c Performs a reflection to the plane v
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension nat(natoms),coord(3,natoms)
      dimension cord(3,natoms),ntrans(natoms)
      dimension v(3),p0(3),p(3)
      do i=1,natoms
         p(1)=coord(1,i)
         p(2)=coord(2,i)
         p(3)=coord(3,i)
         vk=-syva_dot(v,p-p0,3)
         cord(1,i)=coord(1,i)+2.d0*vk*v(1)
         cord(2,i)=coord(2,i)+2.d0*vk*v(2)
         cord(3,i)=coord(3,i)+2.d0*vk*v(3)
      end do
      call syva_check(natoms,delta,nat,coord,cord,nc,ntrans,delta3)
      return
      end
************************************************************************
      subroutine syva_srotate(natoms,nat,coord,v1,sina,cosa,delta,
     &   nc,ntrans,delta3)
************************************************************************
c
c Improper rotation around axis v1
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      dimension nat(natoms),coord(3,natoms)
      dimension cord(3,natoms),cc(3,natoms),ntrans(natoms)
      dimension v1(3),v2(3),v3(3),p0(3),p(3)
      do l=1,natoms
         p0(1)=coord(1,l)
         p0(2)=coord(2,l)
         p0(3)=coord(3,l)
         call syva_crossp(v1,p0,v2)
         call syva_crossp(v1,v2,v3)
         p=p0+sina*v2+(1.d0-cosa)*v3
         cord(1,l)=p(1)
         cord(2,l)=p(2)
         cord(3,l)=p(3)
      end do
      do j=1,natoms
         p0(1)=cord(1,j)
         p0(2)=cord(2,j)
         p0(3)=cord(3,j)
         vk=-syva_dot(v1,p0,3)
         cc(1,j)=cord(1,j)+2.d0*vk*v1(1)
         cc(2,j)=cord(2,j)+2.d0*vk*v1(2)
         cc(3,j)=cord(3,j)+2.d0*vk*v1(3)
      end do
      call syva_check(natoms,delta,nat,coord,cc,nc,ntrans,delta3)
      return
      end


************************************************************************
      subroutine syva_point_group(ngp,ni,nsg,ncr,nsr,np,pgrp,nout)
************************************************************************
c
c Data for 55 Point Groups
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      character sg*3,cg*56,pgrp*3
      logical yesno
      dimension sg(57),ng(57,6),cg(57)
      pgrp='   '
c
c C1 (#1)
      sg(1)  = 'C1 '
c      order           i         SG          Cn              Sn
      ng(1,1)=  1; ng(1,2)=0; ng(1,3)=  0; ng(1,4)=   0; ng(1,5)=  0
      cg(1)  = '{(E)}                                                  '
c Cs (#2)
      sg(2)  = 'Cs '
c      order           i         SG          Cn              Sn
      ng(2,1)=  2; ng(2,2)=0; ng(2,3)=  1; ng(2,4)=   0; ng(2,5)=  0
      cg(2)  = '{(E) (SG)}                                             '
c Ci (#3)
      sg(3)  = 'Ci '
c      order           i         SG          Cn              Sn
      ng(3,1)=  2; ng(3,2)=1; ng(3,3)=  0; ng(3,4)=   0; ng(3,5)=  0
      cg(3)  = '{(E) (i)}                                              '
c C2 (#4)
      sg(4)  = 'C2 '
c      order           i         SG          Cn              Sn
      ng(4,1)=  2; ng(4,2)=0; ng(4,3)=  0; ng(4,4)=   1; ng(4,5)=  0
      cg(4)  = '{(E) (C2)}                                             '
c C3 (#5)
      sg(5)  = 'C3 '
c      order           i         SG          Cn              Sn
      ng(5,1)=  3; ng(5,2)=0; ng(5,3)=  0; ng(5,4)=   2; ng(5,5)=  0
      cg(5)  = '{(E) (C3)}                                             '
c C4 (#6)
      sg(6)  = 'C4 '
c      order           i         SG          Cn              Sn
      ng(6,1)=  4; ng(6,2)=0; ng(6,3)=  0; ng(6,4)=   3; ng(6,5)=  0
      cg(6)  = '{(E) (C4) (C2)}                                        '
c C5 (#7)
      sg(7)  = 'C5 '
c      order           i         SG          Cn              Sn
      ng(7,1)=  5; ng(7,2)=0; ng(7,3)=  0; ng(7,4)=   4; ng(7,5)=  0
      cg(7)  = '{(E) (C5)}                                             '
c C6 (#8)
      sg(8)  = 'C6 '
c      order           i         SG          Cn              Sn
      ng(8,1)=  6; ng(8,2)=0; ng(8,3)=  0; ng(8,4)=   5; ng(8,5)=  0
      cg(8)  = '{(E) (C6) (C3) (C2)}                                   '
c C7 (#9)
      sg(9)  = 'C7 '
c      order           i         SG          Cn              Sn
      ng(9,1)=  7; ng(9,2)=0; ng(9,3)=  0; ng(9,4)=   6; ng(9,5)=  0
      cg(9)  = '{(E) (C7)}                                             '
c C8  (#10)
      sg(10)  = 'C8 '
c      order           i         SG          Cn              Sn
      ng(10,1)=  8;ng(10,2)=0;ng(10,3)=  0;ng(10,4)=   7;ng(10,5)=  0
      cg(10)=  '{(E) (C8) (C4) (C2)}                                   '
c D2  (#11)
      sg(11)  = 'D2 '
c      order           i         SG          Cn              Sn
      ng(11,1)=  4;ng(11,2)=0;ng(11,3)=  0;ng(11,4)=   3;ng(11,5)=  0
      cg(11)=  '{(E)  3*(C2)}                                          '
c D3  (#12)
      sg(12)  = 'D3 '
c      order           i         SG          Cn              Sn
      ng(12,1)=  6;ng(12,2)=0;ng(12,3)=  0;ng(12,4)=   5;ng(12,5)=  0
      cg(12)=  '{(E) (C3) 3*(C2)}                                      '
c D4  (#13)
      sg(13)  = 'D4 '
c      order           i         SG          Cn              Sn
      ng(13,1)=  8;ng(13,2)=0;ng(13,3)=  0;ng(13,4)=   7;ng(13,5)=  0
      cg(13)=  '{(E) (C4) 5*(C2)}                                      '
c D5  (#14)
      sg(14)  = 'D5 '
c      order           i         SG          Cn              Sn
      ng(14,1)= 10;ng(14,2)=0;ng(14,3)=  0;ng(14,4)=   9;ng(14,5)=  0
      cg(14)=  '{(E) (C5) 5*(C2)}                                      '
c D6  (#15)
      sg(15)  = 'D6 '
c      order           i         SG          Cn              Sn
      ng(15,1)= 12;ng(15,2)=0;ng(15,3)=  0;ng(15,4)=  11;ng(15,5)=  0
      cg(15)=  '{(E) (C6) (C3) 7*(C2)}                                 '
c D7  (#16)
      sg(16)  = 'D7 '
c      order           i         SG          Cn              Sn
      ng(16,1)= 14;ng(16,2)=0;ng(16,3)=  0;ng(16,4)=  13;ng(16,5)=  0
      cg(16)=  '{(E) (C7) 7*(C2)}                                      '
c D8  (#17)
      sg(17)  = 'D8 '
c      order           i         SG          Cn              Sn
      ng(17,1)= 16;ng(17,2)=0;ng(17,3)=  0;ng(17,4)=  15;ng(17,5)=  0
      cg(17)=  '{(E) (C8) (C4) 9*(C2)}                                 '
c C2v (#18)
      sg(18)  = 'C2v'
c      order           i         SG          Cn              Sn
      ng(18,1)=  4;ng(18,2)=0;ng(18,3)=  2;ng(18,4)=   1;ng(18,5)=  0
      cg(18)=  '{(E) (C2) 2*(SG)}                                      '
c C3v (#19)
      sg(19)  = 'C3v'
c      order           i         SG          Cn              Sn
      ng(19,1)=  6;ng(19,2)=0;ng(19,3)=  3;ng(19,4)=   2;ng(19,5)=  0
      cg(19)=  '{(E) (C3) 3*(SG)}                                      '
c C4v (#20)
      sg(20)  = 'C4v'
c      order           i         SG          Cn              Sn
      ng(20,1)=  8;ng(20,2)=0;ng(20,3)=  4;ng(20,4)=   3;ng(20,5)=  0
      cg(20)=  '{(E) (C4) (C2) 4*(SG)}                                 '
c C5v (#21)
      sg(21)  = 'C5v'
c      order           i         SG          Cn              Sn
      ng(21,1)= 10;ng(21,2)=0;ng(21,3)=  5;ng(21,4)=   4;ng(21,5)=  0
      cg(21)=  '{(E) (C5) 5*(SG)}                                      '
c C6v (#22)
      sg(22)  = 'C6v'
c      order           i         SG          Cn              Sn
      ng(22,1)= 12;ng(22,2)=0;ng(22,3)=  6;ng(22,4)=   5;ng(22,5)=  0
      cg(22)=  '{(E) (C6) (C3) (C2) 6*(SG)}                            '
c C7v (#23)
      sg(23)  = 'C7v'
c      order           i         SG          Cn              Sn
      ng(23,1)= 14;ng(23,2)=0;ng(23,3)=  7;ng(23,4)=   6;ng(23,5)=  0
      cg(23)=  '{(E) (C7) 7*(SG)}                                      '
c C8v (#24)
      sg(24)  = 'C8v'
c      order           i         SG          Cn              Sn
      ng(24,1)= 16;ng(24,2)=0;ng(24,3)=  8;ng(24,4)=   7;ng(24,5)=  0
      cg(24)=  '{(E) (C8) (C4) (C2) 8*(SG)}                            '
c C2h (#25)
      sg(25)  = 'C2h'
c      order           i         SG          Cn              Sn
      ng(25,1)=  4;ng(25,2)=1;ng(25,3)=  1;ng(25,4)=   1;ng(25,5)=  0
      cg(25)=  '{(E) (C2) (i) (SG)}                                    '
c C3h (#26)
      sg(26)  = 'C3h'
c      order           i         SG          Cn              Sn
      ng(26,1)=  6;ng(26,2)=0;ng(26,3)=  1;ng(26,4)=   2;ng(26,5)=  2
      cg(26)=  '{(E) (C3) (S3) (SG)}                                   '
c C4h (#27)
      sg(27)  = 'C4h'
c      order           i         SG          Cn              Sn
      ng(27,1)=  8;ng(27,2)=1;ng(27,3)=  1;ng(27,4)=   3;ng(27,5)=  2
      cg(27)=  '{(E) (i) (C4) (C2) (S4) (SG)}                          '
c C5h (#28)
      sg(28)  = 'C5h'
c      order           i         SG          Cn              Sn
      ng(28,1)= 10;ng(28,2)=0;ng(28,3)=  1;ng(28,4)=   4;ng(28,5)=  4
      cg(28)=  '{(E) (C5) (S5) (SG)}                                   '
c C6h (#29)
      sg(29)  = 'C6h'
c      order           i         SG          Cn              Sn
      ng(29,1)= 12;ng(29,2)=1;ng(29,3)=  1;ng(29,4)=   5;ng(29,5)=  4
      cg(29)=  '{(E) (i) (C6) (C3) (C2) (S6) (S3) (SG)}                '
c C7h (#30)
      sg(30)  = 'C7h'
c      order           i         SG          Cn              Sn
      ng(30,1)= 14;ng(30,2)=0;ng(30,3)=  1;ng(30,4)=   6;ng(30,5)=  6
      cg(30)=  '{(E) (C7) (S7) (SG)}                                   '
c C8h (#31)
      sg(31)  = 'C8h'
c      order           i         SG          Cn              Sn
      ng(31,1)= 16;ng(31,2)=1;ng(31,3)=  1;ng(31,4)=   7;ng(31,5)=  6
      cg(31)=  '{(E) (i) (C8) (C4) (C2) (S8) (S4) (SG)}                '
c D2h (#32)
      sg(32)  = 'D2h'
c      order           i         SG          Cn              Sn
      ng(32,1)=  8;ng(32,2)=1;ng(32,3)=  3;ng(32,4)=   3;ng(32,5)=  0
      cg(32)=  '{(E) (i) 3*(C2) 3*(SG)}                                '
c D3h (#33)
      sg(33)  = 'D3h'
c      order           i         SG          Cn              Sn
      ng(33,1)= 12;ng(33,2)=0;ng(33,3)=  4;ng(33,4)=   5;ng(33,5)=  2
      cg(33)=  '{(E) (C3) 3*(C2) (S3) 4*(SG)}                          '
c D4h (#34)
      sg(34)  = 'D4h'
c      order           i         SG          Cn              Sn
      ng(34,1)= 16;ng(34,2)=1;ng(34,3)=  5;ng(34,4)=   7;ng(34,5)=  2
      cg(34)=  '{(E) (i) (C4) 5*(C2) (S4) 5*(SG)}                      '
c D5h (#35)
      sg(35)  = 'D5h'
c      order           i         SG          Cn              Sn
      ng(35,1)= 20;ng(35,2)=0;ng(35,3)=  6;ng(35,4)=   9;ng(35,5)=  4
      cg(35)=  '{(E) (C5) 5*(C2) (S5) 6*(SG)}                          '
c D6h (#36)
      sg(36)  = 'D6h'
c      order           i         SG          Cn              Sn
      ng(36,1)= 24;ng(36,2)=1;ng(36,3)=  7;ng(36,4)=  11;ng(36,5)=  4
      cg(36)=  '{(E) (i) (C6) (C3) 7*(C2) (S6) (S3) 7*(SG)}            '
c D7h (#37)
      sg(37)  = 'D7h'
c      order           i         SG          Cn              Sn
      ng(37,1)= 28;ng(37,2)=0;ng(37,3)=  8;ng(37,4)=  13;ng(37,5)=  6
      cg(37)=  '{(E) (C7) 7*(C2) (S7) 8*(SG)}                          '
c D8h (#38)
      sg(38)  = 'D8h'
c      order           i         SG          Cn              Sn
      ng(38,1)= 32;ng(38,2)=1;ng(38,3)=  9;ng(38,4)=  15;ng(38,5)=  6
      cg(38)=  '{(E) (i) (C8) (C4) 9*(C2) (S8) (S4) 9*(SG)}            '
c D2d (#39)
      sg(39)  = 'D2d'
c      order           i         SG          Cn              Sn
      ng(39,1)=  8;ng(39,2)=0;ng(39,3)=  2;ng(39,4)=   3;ng(39,5)=  2
      cg(39)=  '{(E) 3*(C2) (S4) 2*(SG)}                               '
c D3d (#40)
      sg(40)  = 'D3d'
c      order           i         SG          Cn              Sn
      ng(40,1)= 12;ng(40,2)=1;ng(40,3)=  3;ng(40,4)=   5;ng(40,5)=  2
      cg(40)=  '{(E) (i) (C3) 3*(C2) (S6) 3*(SG)}                      '
c D4d (#41)
      sg(41)  = 'D4d'
c      order           i         SG          Cn              Sn
      ng(41,1)= 16;ng(41,2)=0;ng(41,3)=  4;ng(41,4)=   7;ng(41,5)=  4
      cg(41)=  '{(E) (C4) 5*(C2) (S8) 4*(SG)}                          '
c D5d (#42)
      sg(42)  = 'D5d'
c      order           i         SG          Cn              Sn
      ng(42,1)= 20;ng(42,2)=1;ng(42,3)=  5;ng(42,4)=   9;ng(42,5)=  4
      cg(42)=  '{(E) (i) (C5) 5*(C2) (S10) 5*(SG)}                     '
c D6d (#43)
      sg(43)  = 'D6d'
c      order           i         SG          Cn              Sn
      ng(43,1)= 24;ng(43,2)=0;ng(43,3)=  6;ng(43,4)=  11;ng(43,5)=  6
      cg(43)=  '{(E) (C6) (C3) 7*(C2) (S12) (S4) 6*(SG)}               '
c D7d (#44)
      sg(44)  = 'D7d'
c      order           i         SG          Cn              Sn
      ng(44,1)= 28;ng(44,2)=1;ng(44,3)=  7;ng(44,4)=  13;ng(44,5)=  6
      cg(44)=  '{(E) (i) (C7) 7*(C2) (S14) 7*(SG)}                     '
c D8d (#45)
      sg(45)  = 'D8d'
c      order           i         SG          Cn              Sn
      ng(45,1)= 32;ng(45,2)=0;ng(45,3)=  8;ng(45,4)=  15;ng(45,5)=  8
      cg(45)=  '{(E) (C8) (C4) 9*(C2) (S16) 8*(SG)}                    '
c S4  (#46)
      sg(46)  = 'S4 '
c      order           i         SG          Cn              Sn
      ng(46,1)=  4;ng(46,2)=0;ng(46,3)=  0;ng(46,4)=   1;ng(46,5)=  2
      cg(46)=  '{(E) (C2) (S4)}                                        '
c S6  (#47)
      sg(47)  = 'S6 '
c      order           i         SG          Cn              Sn
      ng(47,1)=  6;ng(47,2)=1;ng(47,3)=  0;ng(47,4)=   2;ng(47,5)=  2
      cg(47)=  '{(E) (i) (C3) (S6)}                                    '
c S8  (#48)
      sg(48)  = 'S8 '
c      order           i         SG          Cn              Sn
      ng(48,1)=  8;ng(48,2)=0;ng(48,3)=  0;ng(48,4)=   3;ng(48,5)=  4
      cg(48)=  '{(E) (C4) (C2) (S8)}                                   '
c T   (#49)
      sg(49)  = 'T  '
c      order           i         SG          Cn              Sn
      ng(49,1)= 12;ng(49,2)=0;ng(49,3)=  0;ng(49,4)=  11;ng(49,5)=  0
      cg(49)=  '{(E) 4*(C3) 3*(C2)}                                    '
c Th  (#50)
      sg(50)  = 'Th '
c      order           i         SG          Cn              Sn
      ng(50,1)= 24;ng(50,2)=1;ng(50,3)=  3;ng(50,4)=  11;ng(50,5)=  8
      cg(50)=  '{(E) (i) 4*(C3) 3*(C2) 4*(S6) 3*(SG)}                  '
c Td  (#51)
      sg(51)  = 'Td '
c      order           i         SG          Cn              Sn
      ng(51,1)= 24;ng(51,2)=0;ng(51,3)=  6;ng(51,4)=  11;ng(51,5)=  6
      cg(51)=  '{(E) 4*(C3) 3*(C2) 3*(S4) 6*(SG)}                      '
c O   (#52)
      sg(52)  = 'O  '
c      order           i         SG          Cn              Sn
      ng(52,1)= 24;ng(52,2)=0;ng(52,3)=  0;ng(52,4)=  23;ng(52,5)=  0
      cg(52)=  '{(E) 3*(C4) 4*(C3) 9*(C2)}                             '
c Oh  (#53)
      sg(53)  = 'Oh '
c      order           i         SG          Cn              Sn
      ng(53,1)= 48;ng(53,2)=1;ng(53,3)=  9;ng(53,4)=  23;ng(53,5)= 14
      cg(53)=  '{(E) (i) 3*(C4) 4*(C3) 9*(C2) 4*(S6) 3*(S4) 9*(SG)}    '
c I   (#54)
      sg(54)  = 'I  '
c      order           i         SG          Cn              Sn
      ng(54,1)= 60;ng(54,2)=0;ng(54,3)=  0;ng(54,4)=  59;ng(54,5)=  0
      cg(54)=  '{(E) 6*(C5) 10*(C3) 15*(C2)}                           '
c Ih  (#55)
      sg(55)  = 'Ih '
c      order           i         SG          Cn              Sn
      ng(55,1)=120;ng(55,2)=1;ng(55,3)= 15;ng(55,4)=  59;ng(55,5)= 44
      cg(55)='{(E) (i) 6*(C5) 10*(C3) 15*(C2) 6*(S10) 10*(S6) 15*(SG)}'
c Civ (#56)
      sg(56)  = 'Civ'
c      order           i         SG          Cn              Sn
      ng(56,1)= -1;ng(56,2)=0;ng(56,3)=  1;ng(56,4)=   1;ng(56,5)=  0
      cg(56)='{(E) 2*(Cinf) ... inf*(SG)}                             '
c Dih (#57)
      sg(57)  = 'Dih'
c      order           i         SG          Cn              Sn
      ng(57,1)= -1;ng(57,2)=1;ng(57,3)=  1;ng(57,4)=   2;ng(57,5)=  1
      cg(57)='{(E) (i) 2*(Cinf) ... inf*(C2) 2*(Sinf) ... inf*(SG)}   '
c
c Cn
c
      do i=1,57
         if(sg(i).eq.'Civ'.or.sg(i).eq.'Dih') then
            ng(i, 6) = -1
         elseif((sg(i)(1:1).eq.'C').or.(sg(i)(1:1).eq.'D')) then
            read(sg(i)(2:2),'(i1)',err=10) iord
            ng(i,6)=iord
            cycle
 10         ng(i,6)=0
c            if(ichar(sg(i)(2:2)).gt.56) then
c               ng(i,6)=0
c            else
c               ng(i,6)=ichar(sg(i)(2:2))-48
c            endif
         elseif(sg(i)(1:1).eq.'S') then
            read(sg(i)(2:2),'(i1)') iord
            ng(i,6)=iord/2
c            ng(i,6)=(ichar(sg(i)(2:2))-48)/2
         elseif(sg(i)(1:1).eq.'T') then
            ng(i,6)=3
         elseif(sg(i)(1:1).eq.'O') then
            ng(i,6)=4
         elseif(sg(i)(1:1).eq.'I') then
            ng(i,6)=5
         endif
      end do
c
      
      if(nout.ge.1) write(*,'(/a)') '-- POINT GROUP --'
      yesno=.false.
      nf=0
      do i=1,57
        if(ngp.eq.ng(i,1)) then
          if(ni.eq.ng(i,2)) then
            if(nsg.eq.ng(i,3)) then
              if(ncr.eq.ng(i,4)) then
                if(nsr.eq.ng(i,5)) then
                  if(np.eq.ng(i,6)) then
                    nf=nf+1
                    yesno=.true.
                    pgrp=sg(i)
                    if(nout.ge.1) then
                      write(*,'(/a,a3,a)')
     &                '-- The structure should belong to the ',sg(i),
     &                ' point group.'
                      write(*,'(/3x,a3,a3,a56)') sg(i),' = ',cg(i)
                      write(*,'(/5x,a)')
     &               '       g       E       i      SG      Cn      Sn'
                      write(*,'(8x,a)')
     &             '---------------------------------------------------'
                      if(ng(i,1).eq.-1) then
                        write(*,'(10x,a3,2(5x,i3),2(5x,a3))',
     &                     advance='no')
     &                      'inf',1,ng(i,2),'inf','inf'
                         if(ng(i,5).eq.-1) then
                            write(*,'(5x,a3)') 'inf'
                         else
                            write(*,'(5x,i3)') ng(i,5)
                         end if
                      else
                         write(*,'(10x,i3,5x,i3,4(5x,i3))')
     &                      ng(i,1),1,(ng(i,j),j=2,5)
                      end if
                      if((i.ge.4.and.i.le.17).or.i.eq.49.or.i.eq.52
     &                  .or.i.eq.54) then
                        if(i.ge.4.and.i.le.10) then
                          write(*,'(/,5x,a)')
     &                       'The molecule is polar and chiral.'
                        else
                          write(*,'(/,5x,a)')
     &                       'The molecule is not polar and chiral.'
                        end if
                      elseif(i.eq.2.or.(i.ge.18.and.i.le.24)
     &                  .or.i.eq.56) then
                         write(*,'(/,5x,a)')
     &                       'The molecule is polar and not chiral.'
                      else
                         write(*,'(/,5x,a)')
     &                       'The molecule is not polar and not chiral.'
                      end if
                    end if
                  endif
                endif
              endif
            endif
          endif
        endif
      end do
      if(.not.yesno) then
         if(ngp.eq.1) then
            pgrp='C1'
            if(nout.ge.1) then
               write(*,'(/a,a3,a)')
     &           '-- The structure should belong to the ','C1 ',
     &           ' point group.'
               write(*,'(/,5x,a)') 'The molecule is polar and chiral.'
            end if
            return
         endif
         if(nout.ge.1) write(*,'(/a)')
     &'-- The program failed to determine the particular point group.'
         return
      endif
      if(nf.gt.1) then
         if(nout.ge.1) then
            write(*,'(/a)')
     &   '-- There are several point groups with the same pattern.'
            write(*,'(a)')
     &   '   syva_check the detailed list of the symmetry operations,'
            write(*,'(a)')
     &   '   and choose the right one.'
         end if
         return
      endif
c
      return
      do i=1,19
         write(*,'(/5x,a3,a3,a55)') sg(i),' = ',cg(i)
         write(*,'(5x,a)')
     &   '       g       E       i       SG      Cn      Sn'
         write(*,'(8x,a)')
     &   '---------------------------------------------------'
         write(*,'(10x,i3,5x,i3,4(5x,i3))') ng(i,1),1,(ng(i,j),j=2,5)
      end do
      return
      end
 
      
************************************************************************
      subroutine symclass(natoms,nprm,nper,nseq,nccl,nscl,nat,symb,nout)
************************************************************************
c
c Subroutine symclass detemines the equivalence classes defined by the
c symmetry operations
c
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      character symb*2
      dimension nper(natoms,250),nscl(natoms,natoms)
      dimension nccl(natoms),nat(natoms),symb(90)
      nseq=0
      outer: do i=1,natoms
         do j=1,nseq
            do k=1,nccl(j)
               if(nscl(k,j).eq.i) cycle outer
            end do
         end do
         nseq=nseq+1
         nccl(nseq)=0
         inner: do j=1,nprm
            do k=1,nccl(nseq)
               if(nper(i,j).eq.nscl(k,nseq)) cycle inner
            end do
            nccl(nseq)=nccl(nseq)+1
            nscl(nccl(nseq),nseq)=nper(i,j)
         end do inner
      end do outer
      do i=1,nseq
         do j=1,nccl(i)-1
            ii=j
            do k=j+1,nccl(i)
               if(nscl(k,i).lt.nscl(ii,i)) ii=k
            end do
            if(ii.ne.j) then
               itemp=nscl(j,i)
               nscl(j,i)=nscl(ii,i)
               nscl(ii,i)=itemp
            end if
         end do
      end do
      end
      
      
************************************************************************
      subroutine sym_elements(natoms,nat,coord,symb,delta,norder,ni,nsg,
     &   ncr,nsr,np,symn,nsym,nout,nprm,nper,nseq,nccl,nscl)
************************************************************************
      implicit double precision(a-h,o-z)
      implicit integer(i-n)
      character symb*2,symel*3
      logical symcen,linear,planar
      parameter(nmax=200)
      dimension coord(3,natoms),nat(natoms),symb(90),ntrans(natoms)
      dimension meq(natoms),ieq(10,natoms),sigman(nmax,3)
      dimension p0(3),p1(3),p2(3),p3(3)
      dimension v1(3),v2(3),v3(3),v0(3)
      dimension rotn(nmax,3),rota(nmax)
      dimension a(3),b(3),c(3)
      dimension symn(3,nmax),nsym(nmax,5)
      dimension nper(natoms,250),nscl(natoms,natoms),nccl(natoms)
      integer,external :: syva_igcd
c
      delta2=0.d0
      delta3=0.d0
c
c Identical permutation (E operation)
c
      nprm=1
      do i=1,natoms
         nper(i,1)=i
      end do
c
c Generating the value of PI
c
      pi=4.d0*datan(1.d0)
c
c Partitioning the set of atoms into classes based on their 
c atomic numbers	
c
      neq=1
      meq(neq)=1
      ieq(neq,1)=1
      do i=2,natoms
         nati=nat(i)
         do j=1,neq
            natj=nat(ieq(j,1))
            if(nati.eq.natj) then
               meq(j)=meq(j)+1
               ieq(j,meq(j))=i
               goto 10
            endif
         end do
         neq=neq+1
         meq(neq)=1
         ieq(neq,1)=i
 10      continue
      end do
      if(nout.eq.2) then
         write(*,'(/a,i3)') '-- Equivalence classes of atoms: ',neq
         do i=1,neq
            write(*,'(/5x,a,i3,a7,a2,a1)') '#',i,
     &           ' (atom ',symb(nat(ieq(i,1))),')'
            write(*,'(5x,15i4)') (ieq(i,j),j=1,meq(i))
         end do
      end if
c
      symcen=.false.
      linear=.false.
      planar=.false.
      nsg=0
      nrot=0
c
c Centre of symmetry
c
      call syva_inversion(natoms,nat,coord,delta,nc,nper(1,2),del)
      if(nc.eq.natoms) then
         symcen=.true.
         if(del.gt.delta3) delta3=del
         nprm=2
      end if
      icent=0
c
      symn(:,1)=0.d0
      nsym(1,:)=0
c
      if(symcen) then
         if(nout.ge.1) write(*,'(/a)') '-- CENTRE OF SYMMETRY: {i}'
         nsym(1,2)=1
      endif
      do i=1,natoms
         p0(1)=coord(1,i)
         p0(2)=coord(2,i)
         p0(3)=coord(3,i)
         sp=dsqrt(syva_dot(p0,p0,3))
         if(sp.le.delta) then
            icent=i
            if(sp.gt.delta3) delta3=sp
         end if
      end do
      if(icent.ne.0.and.nout.eq.2) write(*,'(/a,a2,a,i3,a,a)') 
     &     '-- Atom ',symb(nat(icent)),' (',icent,')',
     &     ' in the COM'
      nsym(1,3)=icent
      if(icent.gt.0) nsym(1,5)=1
c
      do i=1,natoms-1
         if(i.eq.icent) cycle
         p1(1)=coord(1,i)
         p1(2)=coord(2,i)
         p1(3)=coord(3,i)
         do j=i+1,natoms
            if(j.eq.icent) cycle
            p2(1)=coord(1,j)
            p2(2)=coord(2,j)         
            p2(3)=coord(3,j)
            call syva_crossp(p1,p2,p0)
            vn=dsqrt(syva_dot(p0,p0,3))
            if(vn.gt.delta) goto 20
            if(vn.gt.delta3) delta3=vn
         end do
      end do
      linear=.true.
c
      if(nout.ge.1) write(*,'(/a)') '-- LINEAR MOLECULE'
c
      if(symcen) then
         if(nout.ge.1) write(*,'(/a,a6,a)') 
     &       '-- The structure should belong to the ','Dinf_h',
     &       ' point group.'
         if(nout.ge.1) write(*,'(/a)') '-- PLANES OF SYMMETRY --'
         nsg = 1
         nsym(2, 1) = 1
         nsym(2, 2) = 0
         nsym(2, 3) = 0
         nsym(2, 4) = 2
         nsym(2, 5) = natoms
         symn(:, 2) = 0.d0
         if(nout.ge.1) write(*,'(/a)') '-- Infinite planes' 
         if(nout.eq.2) write(*,'(5x,a)') 'All atoms included.'
         if(nout.ge.1) write(*,'(/a)')
     &      '-- Distinct PROPER ROTATIONAL AXES --'
         ncr = 2
         nsym(3, 1) = 2
         nsym(3, 2) = 0
         nsym(3, 3) = 1
         nsym(3, 4) = 1
         nsym(3, 5) = natoms
         if(icent.ne.1) then
            symn(:, 3) = coord(:, 1)
         else
            symn(:, 3) = coord(:, 2)
         end if
         symn(:, 3) = symn(:, 3)/dsqrt(syva_dot(symn(:,3),symn(:,3),3))
         nsym(4, 1) = 2
         nsym(4, 2) = 2
         nsym(4, 3) = 1
         nsym(4, 4) = 2
         nsym(4, 5) = 0
         symn(:, 4) = 0.d0
         if(nout.ge.1)
     &      write(*,'(/a,i3,a,f8.2,a)') '-- Axis #',1,': C(',0.d0,')'
         if(nout.eq.2) then
            write(*,'(2x,a,3f12.5)') ' d: ',(symn(k, 3),k=1,3)
            write(*,'(5x,a)') 'All atoms included.'
         end if
         if(nout.ge.1)
     &      write(*,'(/a,i3,a,f8.2,a)') '-- Axis #',2,': C(',180.d0,')'
         if(nout.eq.2) then
            write(*,'(2x,a,3f12.5)') ' d: ',(symn(k, 4),k=1,3)
            write(*,'(5x,a)') 'Atoms included: '
            if(icent.ne.0) write(*,'(10x,2a2,i3,a2)') 
     &      symb(nat(nsym(1,3))),' (',nsym(1,3),')'
         end if
         nsr = 1
         nsym(5, 1) = 3
         nsym(5, 2) = 0
         nsym(5, 3) = 1
         nsym(5, 4) = 0
         nsym(5, 5) = 1
         if(icent.ne.1) then
            symn(:, 5) = coord(:, 1)
         else
            symn(:, 5) = coord(:, 2)
         end if
         symn(:, 5) = symn(:,5)/dsqrt(syva_dot(symn(:,5),symn(:,5),3))
         ni = 1
         norder = -1
         np = -1
         if(nout.ge.1) write(*,'(/a)') 
     &      '-- Number of symmetry operations = infinite' 
      else
         if(nout.ge.1) write(*,'(/a,a6,a)') 
     &       '-- The structure should belong to the ','Cinf_v',
     &       ' point group.'
         if(nout.ge.1) write(*,'(/a)') '-- PLANES OF SYMMETRY --'
         nsg = 1
         nsym(2, 1) = 1
         nsym(2, 2) = 0
         nsym(2, 3) = 0
         nsym(2, 4) = 2
         nsym(2, 5) = natoms
         symn(:, 2) = 0.d0
         if(nout.ge.1) write(*,'(/a)') '-- Infinite planes' 
         if(nout.eq.2) write(*,'(5x,a)') 'All atoms included.'
         if(nout.ge.1) write(*,'(/a)')
     &      '-- Distinct PROPER ROTATIONAL AXES --'
         ncr = 1
         nsym(3, 1) = 2
         nsym(3, 2) = 0
         nsym(3, 3) = 1
         nsym(3, 4) = 1
         nsym(3, 5) = natoms
         if(icent.ne.1) then
            symn(:, 3) = coord(:, 1)
         else
            symn(:, 3) = coord(:, 2)
         end if
         symn(:, 3) = symn(:,3)/dsqrt(syva_dot(symn(:,3),symn(:,3),3))
         if(nout.ge.1)
     &      write(*,'(/a,i3,a,f8.2,a)') '-- Axis #',1,': C(',0.d0,')'
         if(nout.eq.2) then
            write(*,'(2x,a,3f12.5)') ' d: ',(symn(k, 3),k=1,3)
            write(*,'(5x,a)') 'All atoms included.'
         end if
         nsr = 0
         norder = -1
         ni = 0
         np = -1
         if(nout.ge.1) write(*,'(/a)') 
     &      '-- Number of symmetry operations = infinite' 
      endif
      goto 100
 20   continue
      v1=p0/vn
      do i=1,natoms
         p3(1)=coord(1,i)
         p3(2)=coord(2,i)
         p3(3)=coord(3,i)
         sp=syva_dot(v1,p3,3)
         if(dabs(sp).gt.delta) goto 30
         if(dabs(sp).gt.delta3) delta3=dabs(sp)
      end do
      planar=.true.
      nsg=nsg+1
      sigman(nsg,1)=v1(1)
      sigman(nsg,2)=v1(2)
      sigman(nsg,3)=v1(3)
      if(nout.ge.1) write(*,'(/a)') '-- PLANAR MOLECULE'
      if(nout.eq.2) write(*,'(2x,a,3f12.5)') ' n: ',(v1(k),k=1,3)
      if(symcen.and.planar) then
         do i=12,2,-1
            alpha=2.d0*pi/dble(i)
            sp=alpha*180.d0/pi
            sina=dsin(alpha)
            cosa=dcos(alpha)
      call syva_rotate(natoms,nat,coord,v1,sina,cosa,delta,nc,ntrans,
     &         del)
            if(nc.eq.natoms) then
               call add_Cn(nrot,rotn,rota,v1,p3,sp,delta)
               call add_perm(natoms,ntrans,nprm,nper)
               if(del.gt.delta3) delta3=del
            end if
         end do
      endif         
 30   continue
c
c Planes of symmetry
c
      do i=1,neq
         meqi=meq(i)
         if(meqi.eq.1) cycle
         do j1=1,meqi-1
            i1=ieq(i,j1)
            p1(1)=coord(1,i1)
            p1(2)=coord(2,i1)
            p1(3)=coord(3,i1)
            do j2=j1+1,meqi
               i2=ieq(i,j2)
               p2(1)=coord(1,i2)
               p2(2)=coord(2,i2)
               p2(3)=coord(3,i2)
               p0=(p1+p2)/2.d0
               v1=p2-p0
               vn=dsqrt(syva_dot(v1,v1,3))
               if(vn.gt.delta) then
                  v1=v1/vn
                  sp=syva_dot(v1,-p0,3)
                  if(dabs(sp).lt.delta) then
              call syva_reflect(natoms,nat,coord,v1,p0,delta,nc,ntrans,
     &                  del)
                     if(nc.eq.natoms) then
                        if(del.gt.delta3) delta3=del
                        call add_SG(nsg,sigman,v1,p3,delta)
                        call add_perm(natoms,ntrans,nprm,nper)
                     end if
                  endif
               endif
               call syva_crossp(p1,p2,v2)
               vn=dsqrt(syva_dot(v2,v2,3))
               if(vn.gt.delta) then
                  v2=v2/vn
                  sp=syva_dot(v2,-p0,3)
                  if(dabs(sp).lt.delta) then
              call syva_reflect(natoms,nat,coord,v2,p0,delta,nc,ntrans,
     &                  del)
                     if(nc.eq.natoms) then
                        if(del.gt.delta3) delta3=del
                        call add_SG(nsg,sigman,v2,p3,delta)
                        call add_perm(natoms,ntrans,nprm,nper)
                     end if
                  endif
               endif
               call syva_crossp(v1,v2,v3)
               if(vn.gt.delta) then
                  v3=v3/vn
                  sp=syva_dot(v3,-p0,3)
                  if(dabs(sp).lt.delta) then
              call syva_reflect(natoms,nat,coord,v3,p0,delta,nc,ntrans,
     &                  del)
                     if(nc.eq.natoms) then
                        if(del.gt.delta3) delta3=del
                        call add_SG(nsg,sigman,v3,p3,delta)
                        call add_perm(natoms,ntrans,nprm,nper)
                     end if
                  endif
               endif
            end do 
         end do
      end do
c
      if(nout.ge.1) write(*,'(/a)') '-- PLANES OF SYMMETRY --'
c
      do i=1,nsg
         if(nout.ge.1) write(*,'(/a,i3)') '-- Plane #',i
         v1(1)=sigman(i,1)
         v1(2)=sigman(i,2)
         v1(3)=sigman(i,3)
         if(nout.eq.2) then
            write(*,'(2x,a,3f12.5)') ' n: ',(v1(k),k=1,3)
            write(*,'(5x,a)') 'Atoms included: '
         end if
         m=0
         do j=1,natoms
            p3(1)=coord(1,j)
            p3(2)=coord(2,j)
            p3(3)=coord(3,j)
            sp=syva_dot(v1,p3,3)
            if(dabs(sp).le.delta) then
               if(nout.eq.2)
     &            write(*,'(10x,2a2,i3,a2)') symb(nat(j)),' (',j,')'
               m=m+1
               if(dabs(sp).gt.delta3) delta3=dabs(sp)
            endif         
         end do
c Vector n
         symn(:,i+1)=v1
c SG
         nsym(i+1,1)=1
c Not used
         nsym(i+1,2)=0
         nsym(i+1,3)=0
c SGH=1, SGV=2, SGD=3 
         nsym(i+1,4)=0
c Number of atoms included 
         nsym(i+1,5)=m
      end do
c
      if(nout.ge.1) write(*,'(/a)') 
     &'-- Proper rotations due to the centre and planes of symmetry --'
c
      do i=1,nsg-1
         v1(1)=sigman(i,1)
         v1(2)=sigman(i,2)
         v1(3)=sigman(i,3)
         do j=i+1,nsg
            v2(1)=sigman(j,1)
            v2(2)=sigman(j,2)
            v2(3)=sigman(j,3)
            call syva_crossp(v1,v2,v3)
            vn=dsqrt(syva_dot(v3,v3,3))
            v3=v3/vn
            sp=syva_dot(v1,v2,3)
            sp=dacos(sp)*180.d0/pi
            if(sp.gt.90.d0) sp=180.d0-sp
            sp=2.d0*sp
            call add_Cn(nrot,rotn,rota,v3,p3,sp,delta)
         end do
      end do
c
      do i=1,nrot
         m=0
         sp=rota(i)
         if(nout.ge.1) write(*,'(/a,i3,a,f8.2,a)')
     &      '-- Rotation #',i,': C(',sp,')'
         v1(1)=rotn(i,1)
         v1(2)=rotn(i,2)
         v1(3)=rotn(i,3)
         if(nout.eq.2) then
            write(*,'(2x,a,3f12.5)') ' d: ',(v1(k),k=1,3)
            write(*,'(5x,a)') 'Atoms included: '
         end if
         do j=1,natoms
            p3(1)=coord(1,j)
            p3(2)=coord(2,j)
            p3(3)=coord(3,j)                                  
            v2=p0+v1
            call syva_crossp(v2,p3,v0)
            vn=dsqrt(syva_dot(v0,v0,3))
            if(dabs(vn).le.delta) then
               if(nout.eq.2)
     &            write(*,'(10x,2a2,i3,a2)') symb(nat(j)),' (',j,')'
               m=m+1
               if(dabs(vn).gt.delta3) delta3=dabs(vn)
            end if
         end do
      end do
c
c
c Proper rotational axes
c
      if(nout.ge.1) write(*,'(/a)')
     &   '-- Distinct PROPER ROTATIONAL AXES --'
c
c Cn (for each atom)
c
      do i=1,neq
         meqi=meq(i)
         do j=1,meqi
            i1=ieq(i,j)
            p0(1)=coord(1,i1)
            p0(2)=coord(2,i1)
            p0(3)=coord(3,i1)
            vn=dsqrt(syva_dot(p0,p0,3))
            if(vn.lt.delta) cycle
            v1=p0/vn
            do k=12,2,-1
               alpha=2.d0*pi/dble(k)
               sp=alpha*180.d0/pi
               sina=dsin(alpha)
               cosa=dcos(alpha)
c
      call syva_rotate(natoms,nat,coord,v1,sina,cosa,delta,nc,ntrans,
     &         del)
               if(nc.eq.natoms)  then
                  call add_Cn(nrot,rotn,rota,v1,p3,sp,delta)
                  call add_perm(natoms,ntrans,nprm,nper)
                  if(del.gt.delta3) delta3=del
               end if
            end do
         end do
      end do
c
c Cn (for each pair of atoms)
c
      do i=1,neq
         meqi=meq(i)
         if(meqi.lt.2) cycle
         do j1=1,meqi-1
            i1=ieq(i,j1)
            p1(1)=coord(1,i1)
            p1(2)=coord(2,i1)
            p1(3)=coord(3,i1)
            do j2=j1+1,meqi
               i2=ieq(i,j2)
               p2(1)=coord(1,i2)
               p2(2)=coord(2,i2)
               p2(3)=coord(3,i2)
               p0=(p1+p2)/2.d0
               vn=dsqrt(syva_dot(p0,p0,3))
               if(vn.lt.delta) cycle
               v1=p0/vn
               alpha=pi
               sp=180.d0
               sina=dsin(alpha)
               cosa=dcos(alpha)
      call syva_rotate(natoms,nat,coord,v1,sina,cosa,delta,nc,ntrans,
     &            del)
               if(nc.eq.natoms) then
                  call add_Cn(nrot,rotn,rota,v1,p3,sp,delta)
                  call add_perm(natoms,ntrans,nprm,nper)
                  if(del.gt.delta3) delta3=del
               end if
            end do
         end do
      end do
c
c Cn (n > 2)
c
      do i=1,neq
         meqi=meq(i)
         if(meqi.lt.3) cycle
         do j1=1,meqi-2
            i1=ieq(i,j1)
            a(1)=coord(1,i1)
            a(2)=coord(2,i1)
            a(3)=coord(3,i1)
            do j2=j1+1,meqi-1
               i2=ieq(i,j2)
               b(1)=coord(1,i2)
               b(2)=coord(2,i2)
               b(3)=coord(3,i2)
               p1=(a+b)/2.d0
               p3=b-p1
               vn=dsqrt(syva_dot(p3,p3,3))
               v1=p3/vn
               do j3=j2+1,meqi
                  i3=ieq(i,j3)
                  c(1)=coord(1,i3)
                  c(2)=coord(2,i3)
                  c(3)=coord(3,i3)
                  p2=(b+c)/2.d0
                  p3=c-p2
                  vn=dsqrt(syva_dot(p3,p3,3))
                  v2=p3/vn
                  call syva_crossp(v1,v2,v3)
                  vn=dsqrt(syva_dot(v3,v3,3))
                  if(vn.lt.delta) cycle
                  v3=v3/vn
                  sp=dacos(syva_dot(v1,v2,3))
                  if(dabs(sp).lt.delta) cycle 
                  m=idint(2.d0*pi/sp+delta)
                  if((m*sp).lt.(2.d0*pi-delta)) cycle 
                  if((m.lt.3).or.(m.gt.meqi)) cycle
                  alpha=sp
                  sp=alpha*180.d0/pi
                  sina=dsin(alpha)
                  cosa=dcos(alpha)
      call syva_rotate(natoms,nat,coord,v3,sina,cosa,delta,nc,
     &               ntrans,del)
                  if(nc.eq.natoms) then
                     call add_Cn(nrot,rotn,rota,v3,p3,sp,delta)
                     call add_perm(natoms,ntrans,nprm,nper)
                     if(del.gt.delta3) delta3=del
                  end if
               end do
            end do
         end do
      end do
c
      do i=1,nrot
         m=0
         sp=rota(i)
         if(nout.ge.1)
     &      write(*,'(/a,i3,a,f8.2,a)') '-- Axis #',i,': C(',sp,')'
         v1(1)=rotn(i,1)
         v1(2)=rotn(i,2)
         v1(3)=rotn(i,3)
         if(nout.eq.2) then
            write(*,'(2x,a,3f12.5)') ' d: ',(v1(k),k=1,3)
            write(*,'(5x,a)') 'Atoms included: '
         end if
         do j=1,natoms
            p3(1)=coord(1,j)
            p3(2)=coord(2,j)
            p3(3)=coord(3,j)                                  
            call syva_crossp(v1,p3,v0)
            vn=dsqrt(syva_dot(v0,v0,3))
            if(dabs(vn).le.delta) then
               if(nout.eq.2)
     &            write(*,'(10x,2a2,i3,a2)') symb(nat(j)),' (',j,')'
               m=m+1
               if(dabs(vn).gt.delta3) delta3=dabs(vn)
            end if
         end do
      end do
c
      if(nout.ge.1)
     &   write(*,'(/a/)') '-- PROPER ROTATIONAL AXES & ROTATIONS --'
c
      nsgi=nsg+1
      ii=0
      do i=1,nrot
         v1(1)=rotn(i,1)
         v1(2)=rotn(i,2)
         v1(3)=rotn(i,3)
         do k=12,2,-1
            alpha=2.d0*pi/dble(k)
            sina=dsin(alpha)
            cosa=dcos(alpha)
      call syva_rotate(natoms,nat,coord,v1,sina,cosa,delta,nc,ntrans,
     &         del)
            if(nc.eq.natoms) then
               if(del.gt.delta3) delta3=del
               call add_perm(natoms,ntrans,nprm,nper)
               ii=ii+1
               m=0
               do j=1,natoms
                  p3(1)=coord(1,j)
                  p3(2)=coord(2,j)
                  p3(3)=coord(3,j)                                  
                  call syva_crossp(v1,p3,v0)
                  vn=dsqrt(syva_dot(v0,v0,3))
                  if(dabs(vn).le.delta) then
                     m=m+1 
                     if(dabs(vn).gt.delta3) delta3=dabs(vn)
                  end if
               end do
c Vector n
               symn(:,nsgi+ii)=v1
c Cn
               nsym(nsgi+ii,1)=2
c n-fold (n ^ 1) 
               nsym(nsgi+ii,2)=k
               nsym(nsgi+ii,3)=1
c Principal axis
               nsym(nsgi+ii,4)=0
c Number of atoms included (unmoved atoms) 
               nsym(nsgi+ii,5)=m
c
               if(nout.ge.1) write(*,'(a,i3,a,i3,a,i2,a)')
     &              '-- #',i,'-',ii,': C(',k,')'
               if(k.gt.2) then
                  do kk=2,k-1
                     alpha2=dble(kk)*alpha
                     sina2=dsin(alpha2)
                     cosa2=dcos(alpha2)
      call syva_rotate(natoms,nat,coord,v1,sina2,cosa2,delta,
     &                  nc2,ntrans,del)
                     if(nc2.eq.natoms) then
                        if(del.gt.delta3) delta3=del
                        call add_perm(natoms,ntrans,nprm,nper)
                        ii=ii+1
c Vector n
                        symn(:,nsgi+ii)=v1
c Cn
                        nsym(nsgi+ii,1)=2
c Principal axis
                        nsym(nsgi+ii,4)=0
c Number of atoms included 
                        nsym(nsgi+ii,5)=m
c
                        ngcd=syva_igcd(k,kk)
                        nsym(nsgi+ii,2)=k/ngcd
                        nsym(nsgi+ii,3)=kk/ngcd
                        if(nout.ge.1) write(*,'(a,i3,a,i3,a,i2,a,i2,a)') 
     &                    '-- #',i,'-',ii,': C(',k,' ^',kk,')'
                     endif
                  end do
                  exit
               endif
            endif
         end do
      end do
      ncr=ii
c
      if(nout.ge.1)
     &   write(*,'(/a/)') '-- IMPROPER ROTATIONAL AXES & ROTATIONS --'
c
      nsgicn=nsgi+ncr
      ii=0
      do i=1,nrot
         v1(1)=rotn(i,1)
         v1(2)=rotn(i,2)
         v1(3)=rotn(i,3)
         do k=24,2,-1
            alpha=2.d0*pi/dble(k)
            sina=dsin(alpha)
            cosa=dcos(alpha)
            call syva_srotate(natoms,nat,coord,v1,sina,cosa,delta,
     &         nc,ntrans,del)
            if(nc.eq.natoms.and.k.gt.2) then
               if(del.gt.delta3) delta3=del
               call add_perm(natoms,ntrans,nprm,nper)
               ii=ii+1
               m=0
               if(icent.gt.0) m=1
c Vector n
               symn(:,nsgicn+ii)=v1
c Sn
               nsym(nsgicn+ii,1)=3
c n-fold (n ^ 1) 
               nsym(nsgicn+ii,2)=k
               nsym(nsgicn+ii,3)=1
c
               nsym(nsgicn+ii,4)=0
c Number of atoms included 
               nsym(nsgicn+ii,5)=m
c
               if(nout.ge.1) write(*,'(a,i3,a,i3,a,i2,a)') 
     &                 '-- #',i,'-',ii,': S(',k,')'
               kv=k-1
               if(mod(k,2).ne.0) kv=2*k-1
               do kk=2,kv
                  alpha2=dble(kk)*alpha
                  sina2=dsin(alpha2)
                  cosa2=dcos(alpha2)
                  call syva_srotate(natoms,nat,coord,v1,sina2,cosa2,
     &               delta,nc2,ntrans,del)
                  if((nc2.eq.natoms).and.(mod(kk,2).ne.0).and.
     &               (kk.ne.k).and.(syva_igcd(k,kk).eq.1)) then
                     if(del.gt.delta3) delta3=del
                     call add_perm(natoms,ntrans,nprm,nper)
                     ii=ii+1
                     symn(:,nsgicn+ii)=v1
                     nsym(nsgicn+ii,1)=3
                     nsym(nsgicn+ii,5)=m
                     nsym(nsgicn+ii,2)=k
                     nsym(nsgicn+ii,3)=kk
                     if(nout.ge.1) write(*,'(a,i3,a,i3,a,i2,a,i2,a)') 
     &                   '-- #',i,'-',ii,': S(',k,'^',kk,')'
                  endif
               end do
            endif
         end do
      end do
      nsr=ii
      ni=0
      if(symcen) ni=1 
      norder=1+ni+nsg+ncr+nsr 
      if(nout.ge.1) write(*,'(/a,i5)') 
     &'-- Number of symmetry operations (including E) = ',norder 
c
c Determination of the principal axis
c
      np=0
      do i=nsg+2,nsg+ncr+1 
         if((nsym(i,2).gt.np).and.(nsym(i,3).eq.1)) then
            np=nsym(i,2)
         end if
      end do
      do i=nsg+2,nsg+ncr+1 
          if((nsym(i,2).eq.np).and.(nsym(i,3).eq.1)) nsym(i,4)=1
      end do
c
c Rotation axes: principal axes & orthogonal C2 axes
c
      nnp=0
      do i=nsg+2,nsg+ncr+1 
         if((nsym(i,4).eq.1)) nnp=nnp+1
      end do
      if(nnp.eq.3.and.np.eq.2) then
         do i=nsg+2,nsg+ncr+1 
            nsym(i,4)=2
         end do
c D2, D2d, D2h
         if(nsg.eq.3) then
c D2h
            nm=2 !Original line is nm=0, this leads to utilizing out-of-range variable nsym(0,5)
            do i=2,nsg+1 
               if((nsym(i,5).gt.nsym(nm,5))) nm=i
            end do
            nsym(nm,4)=1
            v2=symn(:,nm)        
            do i=nsg+2,nsg+ncr+1 
               v1=symn(:,i)
               vk=syva_dot(v1,v2,3)
               if(dabs(dabs(vk)-1.d0).le.delta) then
                  nsym(i,4)=1
                  if(dabs(dabs(vk)-1.d0).gt.delta2)
     &               delta2=dabs(dabs(vk)-1.d0)
               end if
            end do
         elseif(nsg.eq.2) then
c D2d
            do i=nsg+2,nsg+ncr+1 
               v1=symn(:,i)
               do j=nsg+ncr+2,nsg+ncr+nsr+1 
                  v2=symn(:,j)           
                  vk=syva_dot(v1,v2,3)
               if(dabs(dabs(vk)-1.d0).le.delta) then
                  nsym(i,4)=1
                  if(dabs(dabs(vk)-1.d0).gt.delta2)
     &               delta2=dabs(dabs(vk)-1.d0)
               end if
               end do
            end do
         endif
      endif
c
      do i=nsg+2,nsg+ncr+1 
         if(nsym(i,4).ne.1) cycle
         v1=symn(:,i)
         do j=nsg+2,nsg+ncr+1 
            if((nsym(j,2).eq.2).and.(nsym(j,3).eq.1)) then
               v2=symn(:,j)           
               vk=syva_dot(v1,v2,3)
               if(dabs(vk).lt.delta) then
                  nsym(j,4)=2
                  if(dabs(vk).gt.delta2) delta2=dabs(vk)
               end if
            endif
         end do
      end do
c
c Perpendicular C2 axes
c
      maxcn=0
      if(ncr.gt.0) then
         do i=nsg+2,nsg+ncr+1 
            if(nsym(i,4).ne.2) cycle
            if(nsym(i,5).gt.maxcn) maxcn=nsym(i,5)
         end do
         do i=nsg+2,nsg+ncr+1 
            if(nsym(i,4).ne.2) cycle
            if(nsym(i,5).lt.maxcn) nsym(i,4)=3
         end do
      endif
c
c Planes of symmetry: SGH, SGV, SGD
c
      if(nsg.gt.0) then
c SGH
         do i=nsg+2,nsg+ncr+1 
            if(nsym(i,4).ne.1) cycle
            v1=symn(:,i)
            do j=2,nsg+1
               v2=symn(:,j)           
               vk=syva_dot(v1,v2,3)
               if(dabs(dabs(vk)-1.d0).le.delta) then
                  nsym(j,4)=1
                  if(dabs(dabs(vk)-1.d0).gt.delta2)
     &               delta2=dabs(dabs(vk)-1.d0)
               end if
            end do
         end do
c SGV
         do i=2,nsg+1 
            if(nsym(i,4).eq.1) cycle
            v1=symn(:,i)
            do j=nsg+2,nsg+ncr+1 
               if(nsym(j,4).ne.1) cycle
               v2=symn(:,j)           
               vk=syva_dot(v1,v2,3)
               if(dabs(vk).lt.delta) then
                  nsym(i,4)=2
                  if(dabs(vk).gt.delta2) delta2=dabs(vk)
               end if
            end do
         end do
         maxsg=0
         do i=2,nsg+1
            if(nsym(i,4).ne.2) cycle
            if(nsym(i,5).gt.maxsg) maxsg=nsym(i,5)
         end do
         do i=2,nsg+1
            if(nsym(i,4).ne.2) cycle
            if(nsym(i,5).lt.maxsg) nsym(i,4)=3
         end do
      endif
 100  continue
c
      if(nout.ge.1) write(*,'(/a/)') '-- SYMMETRY OPERATIONS --'
c
c COM and Inversion Center
c
      if(nout.eq.2) then
         if(nsym(1,2).eq.0) then
            if(nsym(1,3).gt.0) then
               write(*,'(15x,a,i3,a,a2,a,i3,a)') 
     &              '#',1,': COM    -- with atom ',symb(nat(nsym(1,3))),
     &              ' (#',nsym(1,3),')'
            else
               write(*,'(15x,a,i3,a)') 
     &              '#',1,': COM'
            endif
         elseif(nsym(1,2).eq.1) then     
            if(nsym(1,3).gt.0) then
               write(*,'(15x,a,i3,a,a2,a,i3,a)') 
     &              '#',1,': INVERSION CENTER  -- with atom ',
     &              symb(nat(nsym(1,3))),' (#',nsym(1,3),')'
            else
               write(*,'(15x,a,i3,a)') 
     &              '#',1,': INVERSION CENTER '
            endif
         endif
c
c SG
c
         do k=2,nsg+1
            if(nsym(k,1).eq.1.and.nsym(k,4).eq.0) then
               symel='SG '
            elseif(nsym(k,1).eq.1.and.nsym(k,4).eq.1) then
               symel='SGH'
            elseif(nsym(k,1).eq.1.and.nsym(k,4).eq.2) then
               symel='SGV'
            elseif(nsym(k,1).eq.1.and.nsym(k,4).eq.3) then
               symel='SGD'
            endif
            if(nsym(k,5).eq.0) then
               write(*,'(15x,a,i3,a,a3)') 
     &              '#',k,': ',symel
            else
               write(*,'(15x,a,i3,a,a3,a,i3,a)') 
     &       '#',k,': ',symel,'     -- with ',nsym(k,5),' unmoved atoms'
      
            endif
         end do
c
c C(n^k)
c 
         do k=nsg+2,nsg+ncr+1
            if(nsym(k,3).gt.1) then
               write(*,'(15x,a,i3,a,i2,a,i2,a)') 
     &              '#',k,': C(',nsym(k,2),'^',
     &              nsym(k,3),')'
            else
               if(nsym(k,5).gt.0) then
                  if(nsym(k,4).eq.2) then
                     write(*,'(15x,a,i3,a,i2,a,a,i3,a)') 
     &                    '#',k,': C''(',nsym(k,2),')',
     &                    '  -- with ',nsym(k,5),' unmoved atoms'
                  elseif(nsym(k,4).eq.3) then
                     write(*,'(15x,a,i3,a,i2,a,a,i3,a)') 
     &                    '#',k,': C"(',nsym(k,2),')',
     &                    '  -- with ',nsym(k,5),' unmoved atoms'
                  else
                     write(*,'(15x,a,i3,a,i2,a,a,i3,a)') 
     &                    '#',k,': C(',nsym(k,2),')',
     &                    '   -- with ',nsym(k,5),' unmoved atoms'
                  endif
               else
                  if(nsym(k,4).eq.2) then
                     write(*,'(15x,a,i3,a,i2,a)') 
     &                    '#',k,': C''(',nsym(k,2),')'
                  elseif(nsym(k,4).eq.3) then
                     write(*,'(15x,a,i3,a,i2,a,a,i3,a)') 
     &                    '#',k,': C"(',nsym(k,2),')'
                  else
                     write(*,'(15x,a,i3,a,i2,a)') 
     &                    '#',k,': C(',nsym(k,2),')'
                  endif
               endif
            endif
         end do
c
c S(n^k)
c 
         do k=nsg+ncr+2,nsg+ncr+nsr+1
            if(nsym(k,3).gt.1) then
               write(*,'(15x,a,i3,a,i2,a,i2,a)') 
     &              '#',k,': S(',nsym(k,2),'^',
     &              nsym(k,3),')'
            else
               if(nsym(k,5).gt.0) then
                  write(*,'(15x,a,i3,a,i2,a,a,i3,a)') 
     &                 '#',k,': S(',nsym(k,2),')',
     &                 '   -- with ',nsym(k,5),' unmoved atoms'
               else
                  write(*,'(15x,a,i3,a,i2,a)') 
     &                 '#',k,': S(',nsym(k,2),')'
               endif
            endif
         end do
      end if
      end