module hrr
implicit none
contains
    subroutine hrr_0_0(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 1; Optimized integrals: 1
    end subroutine
    subroutine hrr_1_0(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 3; Optimized integrals: 3
    end subroutine
    subroutine hrr_1_1(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 18; Optimized integrals: 18
        theta(25) = theta(19)+theta(16)*AB(1) ! ((1,0,0)|(1,0,0)) = ((2,0,0)|(0,0,0))+((1,0,0)|(0,0,0))*AB(1)
        theta(26) = theta(20)+theta(16)*AB(2) ! ((1,0,0)|(0,1,0)) = ((1,1,0)|(0,0,0))+((1,0,0)|(0,0,0))*AB(2)
        theta(27) = theta(21)+theta(16)*AB(3) ! ((1,0,0)|(0,0,1)) = ((1,0,1)|(0,0,0))+((1,0,0)|(0,0,0))*AB(3)
        theta(28) = theta(20)+theta(17)*AB(1) ! ((0,1,0)|(1,0,0)) = ((1,1,0)|(0,0,0))+((0,1,0)|(0,0,0))*AB(1)
        theta(29) = theta(22)+theta(17)*AB(2) ! ((0,1,0)|(0,1,0)) = ((0,2,0)|(0,0,0))+((0,1,0)|(0,0,0))*AB(2)
        theta(30) = theta(23)+theta(17)*AB(3) ! ((0,1,0)|(0,0,1)) = ((0,1,1)|(0,0,0))+((0,1,0)|(0,0,0))*AB(3)
        theta(31) = theta(21)+theta(18)*AB(1) ! ((0,0,1)|(1,0,0)) = ((1,0,1)|(0,0,0))+((0,0,1)|(0,0,0))*AB(1)
        theta(32) = theta(23)+theta(18)*AB(2) ! ((0,0,1)|(0,1,0)) = ((0,1,1)|(0,0,0))+((0,0,1)|(0,0,0))*AB(2)
        theta(33) = theta(24)+theta(18)*AB(3) ! ((0,0,1)|(0,0,1)) = ((0,0,2)|(0,0,0))+((0,0,1)|(0,0,0))*AB(3)
    end subroutine
    subroutine hrr_2_0(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 6; Optimized integrals: 6
    end subroutine
    subroutine hrr_2_1(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 34; Optimized integrals: 34
        theta(52) = theta(42)+theta(36)*AB(1) ! ((2,0,0)|(1,0,0)) = ((3,0,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(1)
        theta(53) = theta(43)+theta(36)*AB(2) ! ((2,0,0)|(0,1,0)) = ((2,1,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(2)
        theta(54) = theta(44)+theta(36)*AB(3) ! ((2,0,0)|(0,0,1)) = ((2,0,1)|(0,0,0))+((2,0,0)|(0,0,0))*AB(3)
        theta(55) = theta(43)+theta(37)*AB(1) ! ((1,1,0)|(1,0,0)) = ((2,1,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(1)
        theta(56) = theta(45)+theta(37)*AB(2) ! ((1,1,0)|(0,1,0)) = ((1,2,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(2)
        theta(57) = theta(46)+theta(37)*AB(3) ! ((1,1,0)|(0,0,1)) = ((1,1,1)|(0,0,0))+((1,1,0)|(0,0,0))*AB(3)
        theta(58) = theta(44)+theta(38)*AB(1) ! ((1,0,1)|(1,0,0)) = ((2,0,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(1)
        theta(59) = theta(46)+theta(38)*AB(2) ! ((1,0,1)|(0,1,0)) = ((1,1,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(2)
        theta(60) = theta(47)+theta(38)*AB(3) ! ((1,0,1)|(0,0,1)) = ((1,0,2)|(0,0,0))+((1,0,1)|(0,0,0))*AB(3)
        theta(61) = theta(45)+theta(39)*AB(1) ! ((0,2,0)|(1,0,0)) = ((1,2,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(1)
        theta(62) = theta(48)+theta(39)*AB(2) ! ((0,2,0)|(0,1,0)) = ((0,3,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(2)
        theta(63) = theta(49)+theta(39)*AB(3) ! ((0,2,0)|(0,0,1)) = ((0,2,1)|(0,0,0))+((0,2,0)|(0,0,0))*AB(3)
        theta(64) = theta(46)+theta(40)*AB(1) ! ((0,1,1)|(1,0,0)) = ((1,1,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(1)
        theta(65) = theta(49)+theta(40)*AB(2) ! ((0,1,1)|(0,1,0)) = ((0,2,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(2)
        theta(66) = theta(50)+theta(40)*AB(3) ! ((0,1,1)|(0,0,1)) = ((0,1,2)|(0,0,0))+((0,1,1)|(0,0,0))*AB(3)
        theta(67) = theta(47)+theta(41)*AB(1) ! ((0,0,2)|(1,0,0)) = ((1,0,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(1)
        theta(68) = theta(50)+theta(41)*AB(2) ! ((0,0,2)|(0,1,0)) = ((0,1,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(2)
        theta(69) = theta(51)+theta(41)*AB(3) ! ((0,0,2)|(0,0,1)) = ((0,0,3)|(0,0,0))+((0,0,2)|(0,0,0))*AB(3)
    end subroutine
    subroutine hrr_2_2(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 115; Optimized integrals: 110
        theta(102) = theta(77)+theta(71)*AB(1) ! ((2,0,0)|(1,0,0)) = ((3,0,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(1)
        theta(103) = theta(78)+theta(71)*AB(2) ! ((2,0,0)|(0,1,0)) = ((2,1,0)|(0,0,0))+((2,0,0)|(0,0,0))*AB(2)
        theta(104) = theta(79)+theta(71)*AB(3) ! ((2,0,0)|(0,0,1)) = ((2,0,1)|(0,0,0))+((2,0,0)|(0,0,0))*AB(3)
        theta(105) = theta(78)+theta(72)*AB(1) ! ((1,1,0)|(1,0,0)) = ((2,1,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(1)
        theta(106) = theta(80)+theta(72)*AB(2) ! ((1,1,0)|(0,1,0)) = ((1,2,0)|(0,0,0))+((1,1,0)|(0,0,0))*AB(2)
        theta(107) = theta(81)+theta(72)*AB(3) ! ((1,1,0)|(0,0,1)) = ((1,1,1)|(0,0,0))+((1,1,0)|(0,0,0))*AB(3)
        theta(108) = theta(79)+theta(73)*AB(1) ! ((1,0,1)|(1,0,0)) = ((2,0,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(1)
        theta(109) = theta(81)+theta(73)*AB(2) ! ((1,0,1)|(0,1,0)) = ((1,1,1)|(0,0,0))+((1,0,1)|(0,0,0))*AB(2)
        theta(110) = theta(82)+theta(73)*AB(3) ! ((1,0,1)|(0,0,1)) = ((1,0,2)|(0,0,0))+((1,0,1)|(0,0,0))*AB(3)
        theta(111) = theta(80)+theta(74)*AB(1) ! ((0,2,0)|(1,0,0)) = ((1,2,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(1)
        theta(112) = theta(83)+theta(74)*AB(2) ! ((0,2,0)|(0,1,0)) = ((0,3,0)|(0,0,0))+((0,2,0)|(0,0,0))*AB(2)
        theta(113) = theta(84)+theta(74)*AB(3) ! ((0,2,0)|(0,0,1)) = ((0,2,1)|(0,0,0))+((0,2,0)|(0,0,0))*AB(3)
        theta(114) = theta(81)+theta(75)*AB(1) ! ((0,1,1)|(1,0,0)) = ((1,1,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(1)
        theta(115) = theta(84)+theta(75)*AB(2) ! ((0,1,1)|(0,1,0)) = ((0,2,1)|(0,0,0))+((0,1,1)|(0,0,0))*AB(2)
        theta(116) = theta(85)+theta(75)*AB(3) ! ((0,1,1)|(0,0,1)) = ((0,1,2)|(0,0,0))+((0,1,1)|(0,0,0))*AB(3)
        theta(117) = theta(82)+theta(76)*AB(1) ! ((0,0,2)|(1,0,0)) = ((1,0,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(1)
        theta(118) = theta(85)+theta(76)*AB(2) ! ((0,0,2)|(0,1,0)) = ((0,1,2)|(0,0,0))+((0,0,2)|(0,0,0))*AB(2)
        theta(119) = theta(86)+theta(76)*AB(3) ! ((0,0,2)|(0,0,1)) = ((0,0,3)|(0,0,0))+((0,0,2)|(0,0,0))*AB(3)
        theta(120) = theta(87)+theta(77)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(121) = theta(88)+theta(77)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(122) = theta(89)+theta(77)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(123) = theta(88)+theta(78)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(124) = theta(90)+theta(78)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(125) = theta(91)+theta(78)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(126) = theta(89)+theta(79)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(127) = theta(91)+theta(79)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(128) = theta(92)+theta(79)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(129) = theta(90)+theta(80)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(130) = theta(93)+theta(80)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(131) = theta(94)+theta(80)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(132) = theta(91)+theta(81)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(133) = theta(94)+theta(81)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(134) = theta(95)+theta(81)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(135) = theta(92)+theta(82)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(136) = theta(95)+theta(82)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(137) = theta(96)+theta(82)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        ! theta(138) = theta(93)+theta(83)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(139) = theta(97)+theta(83)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(140) = theta(98)+theta(83)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        ! theta(141) = theta(94)+theta(84)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        theta(142) = theta(98)+theta(84)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(143) = theta(99)+theta(84)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        ! theta(144) = theta(95)+theta(85)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        theta(145) = theta(99)+theta(85)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(146) = theta(100)+theta(85)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        ! theta(147) = theta(96)+theta(86)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        ! theta(148) = theta(100)+theta(86)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(149) = theta(101)+theta(86)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(150) = theta(120)+theta(102)*AB(1) ! ((2,0,0)|(2,0,0)) = ((3,0,0)|(1,0,0))+((2,0,0)|(1,0,0))*AB(1)
        theta(151) = theta(121)+theta(103)*AB(1) ! ((2,0,0)|(1,1,0)) = ((3,0,0)|(0,1,0))+((2,0,0)|(0,1,0))*AB(1)
        theta(152) = theta(122)+theta(104)*AB(1) ! ((2,0,0)|(1,0,1)) = ((3,0,0)|(0,0,1))+((2,0,0)|(0,0,1))*AB(1)
        theta(153) = theta(124)+theta(103)*AB(2) ! ((2,0,0)|(0,2,0)) = ((2,1,0)|(0,1,0))+((2,0,0)|(0,1,0))*AB(2)
        theta(154) = theta(125)+theta(104)*AB(2) ! ((2,0,0)|(0,1,1)) = ((2,1,0)|(0,0,1))+((2,0,0)|(0,0,1))*AB(2)
        theta(155) = theta(128)+theta(104)*AB(3) ! ((2,0,0)|(0,0,2)) = ((2,0,1)|(0,0,1))+((2,0,0)|(0,0,1))*AB(3)
        theta(156) = theta(123)+theta(105)*AB(1) ! ((1,1,0)|(2,0,0)) = ((2,1,0)|(1,0,0))+((1,1,0)|(1,0,0))*AB(1)
        theta(157) = theta(124)+theta(106)*AB(1) ! ((1,1,0)|(1,1,0)) = ((2,1,0)|(0,1,0))+((1,1,0)|(0,1,0))*AB(1)
        theta(158) = theta(125)+theta(107)*AB(1) ! ((1,1,0)|(1,0,1)) = ((2,1,0)|(0,0,1))+((1,1,0)|(0,0,1))*AB(1)
        theta(159) = theta(130)+theta(106)*AB(2) ! ((1,1,0)|(0,2,0)) = ((1,2,0)|(0,1,0))+((1,1,0)|(0,1,0))*AB(2)
        theta(160) = theta(131)+theta(107)*AB(2) ! ((1,1,0)|(0,1,1)) = ((1,2,0)|(0,0,1))+((1,1,0)|(0,0,1))*AB(2)
        theta(161) = theta(134)+theta(107)*AB(3) ! ((1,1,0)|(0,0,2)) = ((1,1,1)|(0,0,1))+((1,1,0)|(0,0,1))*AB(3)
        theta(162) = theta(126)+theta(108)*AB(1) ! ((1,0,1)|(2,0,0)) = ((2,0,1)|(1,0,0))+((1,0,1)|(1,0,0))*AB(1)
        theta(163) = theta(127)+theta(109)*AB(1) ! ((1,0,1)|(1,1,0)) = ((2,0,1)|(0,1,0))+((1,0,1)|(0,1,0))*AB(1)
        theta(164) = theta(128)+theta(110)*AB(1) ! ((1,0,1)|(1,0,1)) = ((2,0,1)|(0,0,1))+((1,0,1)|(0,0,1))*AB(1)
        theta(165) = theta(133)+theta(109)*AB(2) ! ((1,0,1)|(0,2,0)) = ((1,1,1)|(0,1,0))+((1,0,1)|(0,1,0))*AB(2)
        theta(166) = theta(134)+theta(110)*AB(2) ! ((1,0,1)|(0,1,1)) = ((1,1,1)|(0,0,1))+((1,0,1)|(0,0,1))*AB(2)
        theta(167) = theta(137)+theta(110)*AB(3) ! ((1,0,1)|(0,0,2)) = ((1,0,2)|(0,0,1))+((1,0,1)|(0,0,1))*AB(3)
        theta(168) = theta(129)+theta(111)*AB(1) ! ((0,2,0)|(2,0,0)) = ((1,2,0)|(1,0,0))+((0,2,0)|(1,0,0))*AB(1)
        theta(169) = theta(130)+theta(112)*AB(1) ! ((0,2,0)|(1,1,0)) = ((1,2,0)|(0,1,0))+((0,2,0)|(0,1,0))*AB(1)
        theta(170) = theta(131)+theta(113)*AB(1) ! ((0,2,0)|(1,0,1)) = ((1,2,0)|(0,0,1))+((0,2,0)|(0,0,1))*AB(1)
        theta(171) = theta(139)+theta(112)*AB(2) ! ((0,2,0)|(0,2,0)) = ((0,3,0)|(0,1,0))+((0,2,0)|(0,1,0))*AB(2)
        theta(172) = theta(140)+theta(113)*AB(2) ! ((0,2,0)|(0,1,1)) = ((0,3,0)|(0,0,1))+((0,2,0)|(0,0,1))*AB(2)
        theta(173) = theta(143)+theta(113)*AB(3) ! ((0,2,0)|(0,0,2)) = ((0,2,1)|(0,0,1))+((0,2,0)|(0,0,1))*AB(3)
        theta(174) = theta(132)+theta(114)*AB(1) ! ((0,1,1)|(2,0,0)) = ((1,1,1)|(1,0,0))+((0,1,1)|(1,0,0))*AB(1)
        theta(175) = theta(133)+theta(115)*AB(1) ! ((0,1,1)|(1,1,0)) = ((1,1,1)|(0,1,0))+((0,1,1)|(0,1,0))*AB(1)
        theta(176) = theta(134)+theta(116)*AB(1) ! ((0,1,1)|(1,0,1)) = ((1,1,1)|(0,0,1))+((0,1,1)|(0,0,1))*AB(1)
        theta(177) = theta(142)+theta(115)*AB(2) ! ((0,1,1)|(0,2,0)) = ((0,2,1)|(0,1,0))+((0,1,1)|(0,1,0))*AB(2)
        theta(178) = theta(143)+theta(116)*AB(2) ! ((0,1,1)|(0,1,1)) = ((0,2,1)|(0,0,1))+((0,1,1)|(0,0,1))*AB(2)
        theta(179) = theta(146)+theta(116)*AB(3) ! ((0,1,1)|(0,0,2)) = ((0,1,2)|(0,0,1))+((0,1,1)|(0,0,1))*AB(3)
        theta(180) = theta(135)+theta(117)*AB(1) ! ((0,0,2)|(2,0,0)) = ((1,0,2)|(1,0,0))+((0,0,2)|(1,0,0))*AB(1)
        theta(181) = theta(136)+theta(118)*AB(1) ! ((0,0,2)|(1,1,0)) = ((1,0,2)|(0,1,0))+((0,0,2)|(0,1,0))*AB(1)
        theta(182) = theta(137)+theta(119)*AB(1) ! ((0,0,2)|(1,0,1)) = ((1,0,2)|(0,0,1))+((0,0,2)|(0,0,1))*AB(1)
        theta(183) = theta(145)+theta(118)*AB(2) ! ((0,0,2)|(0,2,0)) = ((0,1,2)|(0,1,0))+((0,0,2)|(0,1,0))*AB(2)
        theta(184) = theta(146)+theta(119)*AB(2) ! ((0,0,2)|(0,1,1)) = ((0,1,2)|(0,0,1))+((0,0,2)|(0,0,1))*AB(2)
        theta(185) = theta(149)+theta(119)*AB(3) ! ((0,0,2)|(0,0,2)) = ((0,0,3)|(0,0,1))+((0,0,2)|(0,0,1))*AB(3)
    end subroutine
    subroutine hrr_3_0(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 10; Optimized integrals: 10
    end subroutine
    subroutine hrr_3_1(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 55; Optimized integrals: 55
        theta(96) = theta(81)+theta(71)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(97) = theta(82)+theta(71)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(98) = theta(83)+theta(71)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(99) = theta(82)+theta(72)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(100) = theta(84)+theta(72)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(101) = theta(85)+theta(72)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(102) = theta(83)+theta(73)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(103) = theta(85)+theta(73)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(104) = theta(86)+theta(73)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(105) = theta(84)+theta(74)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(106) = theta(87)+theta(74)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(107) = theta(88)+theta(74)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(108) = theta(85)+theta(75)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(109) = theta(88)+theta(75)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(110) = theta(89)+theta(75)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(111) = theta(86)+theta(76)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(112) = theta(89)+theta(76)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(113) = theta(90)+theta(76)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(114) = theta(87)+theta(77)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(115) = theta(91)+theta(77)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(116) = theta(92)+theta(77)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(117) = theta(88)+theta(78)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        theta(118) = theta(92)+theta(78)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(119) = theta(93)+theta(78)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(120) = theta(89)+theta(79)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        theta(121) = theta(93)+theta(79)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(122) = theta(94)+theta(79)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(123) = theta(90)+theta(80)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        theta(124) = theta(94)+theta(80)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(125) = theta(95)+theta(80)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
    end subroutine
    subroutine hrr_3_2(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 181; Optimized integrals: 175
        theta(173) = theta(137)+theta(127)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(174) = theta(138)+theta(127)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(175) = theta(139)+theta(127)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(176) = theta(138)+theta(128)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(177) = theta(140)+theta(128)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(178) = theta(141)+theta(128)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(179) = theta(139)+theta(129)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(180) = theta(141)+theta(129)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(181) = theta(142)+theta(129)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(182) = theta(140)+theta(130)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(183) = theta(143)+theta(130)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(184) = theta(144)+theta(130)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(185) = theta(141)+theta(131)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(186) = theta(144)+theta(131)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(187) = theta(145)+theta(131)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(188) = theta(142)+theta(132)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(189) = theta(145)+theta(132)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(190) = theta(146)+theta(132)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(191) = theta(143)+theta(133)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(192) = theta(147)+theta(133)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(193) = theta(148)+theta(133)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(194) = theta(144)+theta(134)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        theta(195) = theta(148)+theta(134)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(196) = theta(149)+theta(134)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(197) = theta(145)+theta(135)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        theta(198) = theta(149)+theta(135)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(199) = theta(150)+theta(135)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(200) = theta(146)+theta(136)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        theta(201) = theta(150)+theta(136)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(202) = theta(151)+theta(136)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(203) = theta(152)+theta(137)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(204) = theta(153)+theta(137)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(205) = theta(154)+theta(137)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(206) = theta(153)+theta(138)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(207) = theta(155)+theta(138)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(208) = theta(156)+theta(138)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(209) = theta(154)+theta(139)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(210) = theta(156)+theta(139)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(211) = theta(157)+theta(139)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(212) = theta(155)+theta(140)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(213) = theta(158)+theta(140)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(214) = theta(159)+theta(140)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(215) = theta(156)+theta(141)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(216) = theta(159)+theta(141)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(217) = theta(160)+theta(141)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(218) = theta(157)+theta(142)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(219) = theta(160)+theta(142)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(220) = theta(161)+theta(142)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(221) = theta(158)+theta(143)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(222) = theta(162)+theta(143)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(223) = theta(163)+theta(143)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(224) = theta(159)+theta(144)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(225) = theta(163)+theta(144)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(226) = theta(164)+theta(144)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(227) = theta(160)+theta(145)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(228) = theta(164)+theta(145)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(229) = theta(165)+theta(145)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(230) = theta(161)+theta(146)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(231) = theta(165)+theta(146)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(232) = theta(166)+theta(146)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        ! theta(233) = theta(162)+theta(147)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(234) = theta(167)+theta(147)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(235) = theta(168)+theta(147)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        ! theta(236) = theta(163)+theta(148)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(237) = theta(168)+theta(148)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(238) = theta(169)+theta(148)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        ! theta(239) = theta(164)+theta(149)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(240) = theta(169)+theta(149)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(241) = theta(170)+theta(149)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        ! theta(242) = theta(165)+theta(150)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(243) = theta(170)+theta(150)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(244) = theta(171)+theta(150)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        ! theta(245) = theta(166)+theta(151)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        ! theta(246) = theta(171)+theta(151)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(247) = theta(172)+theta(151)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(248) = theta(203)+theta(173)*AB(1) ! ((3,0,0)|(2,0,0)) = ((4,0,0)|(1,0,0))+((3,0,0)|(1,0,0))*AB(1)
        theta(249) = theta(204)+theta(174)*AB(1) ! ((3,0,0)|(1,1,0)) = ((4,0,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(1)
        theta(250) = theta(205)+theta(175)*AB(1) ! ((3,0,0)|(1,0,1)) = ((4,0,0)|(0,0,1))+((3,0,0)|(0,0,1))*AB(1)
        theta(251) = theta(207)+theta(174)*AB(2) ! ((3,0,0)|(0,2,0)) = ((3,1,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(2)
        theta(252) = theta(208)+theta(175)*AB(2) ! ((3,0,0)|(0,1,1)) = ((3,1,0)|(0,0,1))+((3,0,0)|(0,0,1))*AB(2)
        theta(253) = theta(211)+theta(175)*AB(3) ! ((3,0,0)|(0,0,2)) = ((3,0,1)|(0,0,1))+((3,0,0)|(0,0,1))*AB(3)
        theta(254) = theta(206)+theta(176)*AB(1) ! ((2,1,0)|(2,0,0)) = ((3,1,0)|(1,0,0))+((2,1,0)|(1,0,0))*AB(1)
        theta(255) = theta(207)+theta(177)*AB(1) ! ((2,1,0)|(1,1,0)) = ((3,1,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(1)
        theta(256) = theta(208)+theta(178)*AB(1) ! ((2,1,0)|(1,0,1)) = ((3,1,0)|(0,0,1))+((2,1,0)|(0,0,1))*AB(1)
        theta(257) = theta(213)+theta(177)*AB(2) ! ((2,1,0)|(0,2,0)) = ((2,2,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(2)
        theta(258) = theta(214)+theta(178)*AB(2) ! ((2,1,0)|(0,1,1)) = ((2,2,0)|(0,0,1))+((2,1,0)|(0,0,1))*AB(2)
        theta(259) = theta(217)+theta(178)*AB(3) ! ((2,1,0)|(0,0,2)) = ((2,1,1)|(0,0,1))+((2,1,0)|(0,0,1))*AB(3)
        theta(260) = theta(209)+theta(179)*AB(1) ! ((2,0,1)|(2,0,0)) = ((3,0,1)|(1,0,0))+((2,0,1)|(1,0,0))*AB(1)
        theta(261) = theta(210)+theta(180)*AB(1) ! ((2,0,1)|(1,1,0)) = ((3,0,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(1)
        theta(262) = theta(211)+theta(181)*AB(1) ! ((2,0,1)|(1,0,1)) = ((3,0,1)|(0,0,1))+((2,0,1)|(0,0,1))*AB(1)
        theta(263) = theta(216)+theta(180)*AB(2) ! ((2,0,1)|(0,2,0)) = ((2,1,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(2)
        theta(264) = theta(217)+theta(181)*AB(2) ! ((2,0,1)|(0,1,1)) = ((2,1,1)|(0,0,1))+((2,0,1)|(0,0,1))*AB(2)
        theta(265) = theta(220)+theta(181)*AB(3) ! ((2,0,1)|(0,0,2)) = ((2,0,2)|(0,0,1))+((2,0,1)|(0,0,1))*AB(3)
        theta(266) = theta(212)+theta(182)*AB(1) ! ((1,2,0)|(2,0,0)) = ((2,2,0)|(1,0,0))+((1,2,0)|(1,0,0))*AB(1)
        theta(267) = theta(213)+theta(183)*AB(1) ! ((1,2,0)|(1,1,0)) = ((2,2,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(1)
        theta(268) = theta(214)+theta(184)*AB(1) ! ((1,2,0)|(1,0,1)) = ((2,2,0)|(0,0,1))+((1,2,0)|(0,0,1))*AB(1)
        theta(269) = theta(222)+theta(183)*AB(2) ! ((1,2,0)|(0,2,0)) = ((1,3,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(2)
        theta(270) = theta(223)+theta(184)*AB(2) ! ((1,2,0)|(0,1,1)) = ((1,3,0)|(0,0,1))+((1,2,0)|(0,0,1))*AB(2)
        theta(271) = theta(226)+theta(184)*AB(3) ! ((1,2,0)|(0,0,2)) = ((1,2,1)|(0,0,1))+((1,2,0)|(0,0,1))*AB(3)
        theta(272) = theta(215)+theta(185)*AB(1) ! ((1,1,1)|(2,0,0)) = ((2,1,1)|(1,0,0))+((1,1,1)|(1,0,0))*AB(1)
        theta(273) = theta(216)+theta(186)*AB(1) ! ((1,1,1)|(1,1,0)) = ((2,1,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(1)
        theta(274) = theta(217)+theta(187)*AB(1) ! ((1,1,1)|(1,0,1)) = ((2,1,1)|(0,0,1))+((1,1,1)|(0,0,1))*AB(1)
        theta(275) = theta(225)+theta(186)*AB(2) ! ((1,1,1)|(0,2,0)) = ((1,2,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(2)
        theta(276) = theta(226)+theta(187)*AB(2) ! ((1,1,1)|(0,1,1)) = ((1,2,1)|(0,0,1))+((1,1,1)|(0,0,1))*AB(2)
        theta(277) = theta(229)+theta(187)*AB(3) ! ((1,1,1)|(0,0,2)) = ((1,1,2)|(0,0,1))+((1,1,1)|(0,0,1))*AB(3)
        theta(278) = theta(218)+theta(188)*AB(1) ! ((1,0,2)|(2,0,0)) = ((2,0,2)|(1,0,0))+((1,0,2)|(1,0,0))*AB(1)
        theta(279) = theta(219)+theta(189)*AB(1) ! ((1,0,2)|(1,1,0)) = ((2,0,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(1)
        theta(280) = theta(220)+theta(190)*AB(1) ! ((1,0,2)|(1,0,1)) = ((2,0,2)|(0,0,1))+((1,0,2)|(0,0,1))*AB(1)
        theta(281) = theta(228)+theta(189)*AB(2) ! ((1,0,2)|(0,2,0)) = ((1,1,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(2)
        theta(282) = theta(229)+theta(190)*AB(2) ! ((1,0,2)|(0,1,1)) = ((1,1,2)|(0,0,1))+((1,0,2)|(0,0,1))*AB(2)
        theta(283) = theta(232)+theta(190)*AB(3) ! ((1,0,2)|(0,0,2)) = ((1,0,3)|(0,0,1))+((1,0,2)|(0,0,1))*AB(3)
        theta(284) = theta(221)+theta(191)*AB(1) ! ((0,3,0)|(2,0,0)) = ((1,3,0)|(1,0,0))+((0,3,0)|(1,0,0))*AB(1)
        theta(285) = theta(222)+theta(192)*AB(1) ! ((0,3,0)|(1,1,0)) = ((1,3,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(1)
        theta(286) = theta(223)+theta(193)*AB(1) ! ((0,3,0)|(1,0,1)) = ((1,3,0)|(0,0,1))+((0,3,0)|(0,0,1))*AB(1)
        theta(287) = theta(234)+theta(192)*AB(2) ! ((0,3,0)|(0,2,0)) = ((0,4,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(2)
        theta(288) = theta(235)+theta(193)*AB(2) ! ((0,3,0)|(0,1,1)) = ((0,4,0)|(0,0,1))+((0,3,0)|(0,0,1))*AB(2)
        theta(289) = theta(238)+theta(193)*AB(3) ! ((0,3,0)|(0,0,2)) = ((0,3,1)|(0,0,1))+((0,3,0)|(0,0,1))*AB(3)
        theta(290) = theta(224)+theta(194)*AB(1) ! ((0,2,1)|(2,0,0)) = ((1,2,1)|(1,0,0))+((0,2,1)|(1,0,0))*AB(1)
        theta(291) = theta(225)+theta(195)*AB(1) ! ((0,2,1)|(1,1,0)) = ((1,2,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(1)
        theta(292) = theta(226)+theta(196)*AB(1) ! ((0,2,1)|(1,0,1)) = ((1,2,1)|(0,0,1))+((0,2,1)|(0,0,1))*AB(1)
        theta(293) = theta(237)+theta(195)*AB(2) ! ((0,2,1)|(0,2,0)) = ((0,3,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(2)
        theta(294) = theta(238)+theta(196)*AB(2) ! ((0,2,1)|(0,1,1)) = ((0,3,1)|(0,0,1))+((0,2,1)|(0,0,1))*AB(2)
        theta(295) = theta(241)+theta(196)*AB(3) ! ((0,2,1)|(0,0,2)) = ((0,2,2)|(0,0,1))+((0,2,1)|(0,0,1))*AB(3)
        theta(296) = theta(227)+theta(197)*AB(1) ! ((0,1,2)|(2,0,0)) = ((1,1,2)|(1,0,0))+((0,1,2)|(1,0,0))*AB(1)
        theta(297) = theta(228)+theta(198)*AB(1) ! ((0,1,2)|(1,1,0)) = ((1,1,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(1)
        theta(298) = theta(229)+theta(199)*AB(1) ! ((0,1,2)|(1,0,1)) = ((1,1,2)|(0,0,1))+((0,1,2)|(0,0,1))*AB(1)
        theta(299) = theta(240)+theta(198)*AB(2) ! ((0,1,2)|(0,2,0)) = ((0,2,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(2)
        theta(300) = theta(241)+theta(199)*AB(2) ! ((0,1,2)|(0,1,1)) = ((0,2,2)|(0,0,1))+((0,1,2)|(0,0,1))*AB(2)
        theta(301) = theta(244)+theta(199)*AB(3) ! ((0,1,2)|(0,0,2)) = ((0,1,3)|(0,0,1))+((0,1,2)|(0,0,1))*AB(3)
        theta(302) = theta(230)+theta(200)*AB(1) ! ((0,0,3)|(2,0,0)) = ((1,0,3)|(1,0,0))+((0,0,3)|(1,0,0))*AB(1)
        theta(303) = theta(231)+theta(201)*AB(1) ! ((0,0,3)|(1,1,0)) = ((1,0,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(1)
        theta(304) = theta(232)+theta(202)*AB(1) ! ((0,0,3)|(1,0,1)) = ((1,0,3)|(0,0,1))+((0,0,3)|(0,0,1))*AB(1)
        theta(305) = theta(243)+theta(201)*AB(2) ! ((0,0,3)|(0,2,0)) = ((0,1,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(2)
        theta(306) = theta(244)+theta(202)*AB(2) ! ((0,0,3)|(0,1,1)) = ((0,1,3)|(0,0,1))+((0,0,3)|(0,0,1))*AB(2)
        theta(307) = theta(247)+theta(202)*AB(3) ! ((0,0,3)|(0,0,2)) = ((0,0,4)|(0,0,1))+((0,0,3)|(0,0,1))*AB(3)
    end subroutine
    subroutine hrr_3_3(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 462; Optimized integrals: 408
        theta(285) = theta(221)+theta(211)*AB(1) ! ((3,0,0)|(1,0,0)) = ((4,0,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(1)
        theta(286) = theta(222)+theta(211)*AB(2) ! ((3,0,0)|(0,1,0)) = ((3,1,0)|(0,0,0))+((3,0,0)|(0,0,0))*AB(2)
        theta(287) = theta(223)+theta(211)*AB(3) ! ((3,0,0)|(0,0,1)) = ((3,0,1)|(0,0,0))+((3,0,0)|(0,0,0))*AB(3)
        theta(288) = theta(222)+theta(212)*AB(1) ! ((2,1,0)|(1,0,0)) = ((3,1,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(1)
        theta(289) = theta(224)+theta(212)*AB(2) ! ((2,1,0)|(0,1,0)) = ((2,2,0)|(0,0,0))+((2,1,0)|(0,0,0))*AB(2)
        theta(290) = theta(225)+theta(212)*AB(3) ! ((2,1,0)|(0,0,1)) = ((2,1,1)|(0,0,0))+((2,1,0)|(0,0,0))*AB(3)
        theta(291) = theta(223)+theta(213)*AB(1) ! ((2,0,1)|(1,0,0)) = ((3,0,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(1)
        theta(292) = theta(225)+theta(213)*AB(2) ! ((2,0,1)|(0,1,0)) = ((2,1,1)|(0,0,0))+((2,0,1)|(0,0,0))*AB(2)
        theta(293) = theta(226)+theta(213)*AB(3) ! ((2,0,1)|(0,0,1)) = ((2,0,2)|(0,0,0))+((2,0,1)|(0,0,0))*AB(3)
        theta(294) = theta(224)+theta(214)*AB(1) ! ((1,2,0)|(1,0,0)) = ((2,2,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(1)
        theta(295) = theta(227)+theta(214)*AB(2) ! ((1,2,0)|(0,1,0)) = ((1,3,0)|(0,0,0))+((1,2,0)|(0,0,0))*AB(2)
        theta(296) = theta(228)+theta(214)*AB(3) ! ((1,2,0)|(0,0,1)) = ((1,2,1)|(0,0,0))+((1,2,0)|(0,0,0))*AB(3)
        theta(297) = theta(225)+theta(215)*AB(1) ! ((1,1,1)|(1,0,0)) = ((2,1,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(1)
        theta(298) = theta(228)+theta(215)*AB(2) ! ((1,1,1)|(0,1,0)) = ((1,2,1)|(0,0,0))+((1,1,1)|(0,0,0))*AB(2)
        theta(299) = theta(229)+theta(215)*AB(3) ! ((1,1,1)|(0,0,1)) = ((1,1,2)|(0,0,0))+((1,1,1)|(0,0,0))*AB(3)
        theta(300) = theta(226)+theta(216)*AB(1) ! ((1,0,2)|(1,0,0)) = ((2,0,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(1)
        theta(301) = theta(229)+theta(216)*AB(2) ! ((1,0,2)|(0,1,0)) = ((1,1,2)|(0,0,0))+((1,0,2)|(0,0,0))*AB(2)
        theta(302) = theta(230)+theta(216)*AB(3) ! ((1,0,2)|(0,0,1)) = ((1,0,3)|(0,0,0))+((1,0,2)|(0,0,0))*AB(3)
        theta(303) = theta(227)+theta(217)*AB(1) ! ((0,3,0)|(1,0,0)) = ((1,3,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(1)
        theta(304) = theta(231)+theta(217)*AB(2) ! ((0,3,0)|(0,1,0)) = ((0,4,0)|(0,0,0))+((0,3,0)|(0,0,0))*AB(2)
        theta(305) = theta(232)+theta(217)*AB(3) ! ((0,3,0)|(0,0,1)) = ((0,3,1)|(0,0,0))+((0,3,0)|(0,0,0))*AB(3)
        theta(306) = theta(228)+theta(218)*AB(1) ! ((0,2,1)|(1,0,0)) = ((1,2,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(1)
        theta(307) = theta(232)+theta(218)*AB(2) ! ((0,2,1)|(0,1,0)) = ((0,3,1)|(0,0,0))+((0,2,1)|(0,0,0))*AB(2)
        theta(308) = theta(233)+theta(218)*AB(3) ! ((0,2,1)|(0,0,1)) = ((0,2,2)|(0,0,0))+((0,2,1)|(0,0,0))*AB(3)
        theta(309) = theta(229)+theta(219)*AB(1) ! ((0,1,2)|(1,0,0)) = ((1,1,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(1)
        theta(310) = theta(233)+theta(219)*AB(2) ! ((0,1,2)|(0,1,0)) = ((0,2,2)|(0,0,0))+((0,1,2)|(0,0,0))*AB(2)
        theta(311) = theta(234)+theta(219)*AB(3) ! ((0,1,2)|(0,0,1)) = ((0,1,3)|(0,0,0))+((0,1,2)|(0,0,0))*AB(3)
        theta(312) = theta(230)+theta(220)*AB(1) ! ((0,0,3)|(1,0,0)) = ((1,0,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(1)
        theta(313) = theta(234)+theta(220)*AB(2) ! ((0,0,3)|(0,1,0)) = ((0,1,3)|(0,0,0))+((0,0,3)|(0,0,0))*AB(2)
        theta(314) = theta(235)+theta(220)*AB(3) ! ((0,0,3)|(0,0,1)) = ((0,0,4)|(0,0,0))+((0,0,3)|(0,0,0))*AB(3)
        theta(315) = theta(236)+theta(221)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(316) = theta(237)+theta(221)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(317) = theta(238)+theta(221)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(318) = theta(237)+theta(222)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(319) = theta(239)+theta(222)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(320) = theta(240)+theta(222)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(321) = theta(238)+theta(223)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(322) = theta(240)+theta(223)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(323) = theta(241)+theta(223)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(324) = theta(239)+theta(224)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(325) = theta(242)+theta(224)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(326) = theta(243)+theta(224)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(327) = theta(240)+theta(225)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(328) = theta(243)+theta(225)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(329) = theta(244)+theta(225)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(330) = theta(241)+theta(226)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(331) = theta(244)+theta(226)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(332) = theta(245)+theta(226)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(333) = theta(242)+theta(227)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(334) = theta(246)+theta(227)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(335) = theta(247)+theta(227)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(336) = theta(243)+theta(228)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(337) = theta(247)+theta(228)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(338) = theta(248)+theta(228)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(339) = theta(244)+theta(229)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(340) = theta(248)+theta(229)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(341) = theta(249)+theta(229)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(342) = theta(245)+theta(230)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(343) = theta(249)+theta(230)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(344) = theta(250)+theta(230)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(345) = theta(246)+theta(231)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(346) = theta(251)+theta(231)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(347) = theta(252)+theta(231)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(348) = theta(247)+theta(232)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(349) = theta(252)+theta(232)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(350) = theta(253)+theta(232)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(351) = theta(248)+theta(233)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(352) = theta(253)+theta(233)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(353) = theta(254)+theta(233)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(354) = theta(249)+theta(234)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(355) = theta(254)+theta(234)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(356) = theta(255)+theta(234)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(357) = theta(250)+theta(235)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(358) = theta(255)+theta(235)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(359) = theta(256)+theta(235)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(360) = theta(257)+theta(236)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        ! theta(361) = theta(258)+theta(236)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        ! theta(362) = theta(259)+theta(236)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(363) = theta(258)+theta(237)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(364) = theta(260)+theta(237)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(365) = theta(261)+theta(237)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(366) = theta(259)+theta(238)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(367) = theta(261)+theta(238)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(368) = theta(262)+theta(238)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(369) = theta(260)+theta(239)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(370) = theta(263)+theta(239)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(371) = theta(264)+theta(239)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(372) = theta(261)+theta(240)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(373) = theta(264)+theta(240)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(374) = theta(265)+theta(240)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(375) = theta(262)+theta(241)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(376) = theta(265)+theta(241)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(377) = theta(266)+theta(241)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(378) = theta(263)+theta(242)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(379) = theta(267)+theta(242)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(380) = theta(268)+theta(242)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(381) = theta(264)+theta(243)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(382) = theta(268)+theta(243)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(383) = theta(269)+theta(243)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(384) = theta(265)+theta(244)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(385) = theta(269)+theta(244)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(386) = theta(270)+theta(244)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(387) = theta(266)+theta(245)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(388) = theta(270)+theta(245)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(389) = theta(271)+theta(245)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(390) = theta(267)+theta(246)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(391) = theta(272)+theta(246)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(392) = theta(273)+theta(246)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(393) = theta(268)+theta(247)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(394) = theta(273)+theta(247)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(395) = theta(274)+theta(247)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(396) = theta(269)+theta(248)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(397) = theta(274)+theta(248)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(398) = theta(275)+theta(248)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(399) = theta(270)+theta(249)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(400) = theta(275)+theta(249)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(401) = theta(276)+theta(249)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(402) = theta(271)+theta(250)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        ! theta(403) = theta(276)+theta(250)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(404) = theta(277)+theta(250)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        ! theta(405) = theta(272)+theta(251)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(406) = theta(278)+theta(251)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        ! theta(407) = theta(279)+theta(251)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        ! theta(408) = theta(273)+theta(252)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(409) = theta(279)+theta(252)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(410) = theta(280)+theta(252)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        ! theta(411) = theta(274)+theta(253)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(412) = theta(280)+theta(253)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(413) = theta(281)+theta(253)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        ! theta(414) = theta(275)+theta(254)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(415) = theta(281)+theta(254)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(416) = theta(282)+theta(254)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        ! theta(417) = theta(276)+theta(255)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(418) = theta(282)+theta(255)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(419) = theta(283)+theta(255)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        ! theta(420) = theta(277)+theta(256)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        ! theta(421) = theta(283)+theta(256)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(422) = theta(284)+theta(256)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(423) = theta(315)+theta(285)*AB(1) ! ((3,0,0)|(2,0,0)) = ((4,0,0)|(1,0,0))+((3,0,0)|(1,0,0))*AB(1)
        ! theta(424) = theta(316)+theta(286)*AB(1) ! ((3,0,0)|(1,1,0)) = ((4,0,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(1)
        ! theta(425) = theta(317)+theta(287)*AB(1) ! ((3,0,0)|(1,0,1)) = ((4,0,0)|(0,0,1))+((3,0,0)|(0,0,1))*AB(1)
        theta(426) = theta(319)+theta(286)*AB(2) ! ((3,0,0)|(0,2,0)) = ((3,1,0)|(0,1,0))+((3,0,0)|(0,1,0))*AB(2)
        theta(427) = theta(320)+theta(287)*AB(2) ! ((3,0,0)|(0,1,1)) = ((3,1,0)|(0,0,1))+((3,0,0)|(0,0,1))*AB(2)
        theta(428) = theta(323)+theta(287)*AB(3) ! ((3,0,0)|(0,0,2)) = ((3,0,1)|(0,0,1))+((3,0,0)|(0,0,1))*AB(3)
        theta(429) = theta(318)+theta(288)*AB(1) ! ((2,1,0)|(2,0,0)) = ((3,1,0)|(1,0,0))+((2,1,0)|(1,0,0))*AB(1)
        ! theta(430) = theta(319)+theta(289)*AB(1) ! ((2,1,0)|(1,1,0)) = ((3,1,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(1)
        ! theta(431) = theta(320)+theta(290)*AB(1) ! ((2,1,0)|(1,0,1)) = ((3,1,0)|(0,0,1))+((2,1,0)|(0,0,1))*AB(1)
        theta(432) = theta(325)+theta(289)*AB(2) ! ((2,1,0)|(0,2,0)) = ((2,2,0)|(0,1,0))+((2,1,0)|(0,1,0))*AB(2)
        theta(433) = theta(326)+theta(290)*AB(2) ! ((2,1,0)|(0,1,1)) = ((2,2,0)|(0,0,1))+((2,1,0)|(0,0,1))*AB(2)
        theta(434) = theta(329)+theta(290)*AB(3) ! ((2,1,0)|(0,0,2)) = ((2,1,1)|(0,0,1))+((2,1,0)|(0,0,1))*AB(3)
        theta(435) = theta(321)+theta(291)*AB(1) ! ((2,0,1)|(2,0,0)) = ((3,0,1)|(1,0,0))+((2,0,1)|(1,0,0))*AB(1)
        theta(436) = theta(322)+theta(292)*AB(1) ! ((2,0,1)|(1,1,0)) = ((3,0,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(1)
        ! theta(437) = theta(323)+theta(293)*AB(1) ! ((2,0,1)|(1,0,1)) = ((3,0,1)|(0,0,1))+((2,0,1)|(0,0,1))*AB(1)
        theta(438) = theta(328)+theta(292)*AB(2) ! ((2,0,1)|(0,2,0)) = ((2,1,1)|(0,1,0))+((2,0,1)|(0,1,0))*AB(2)
        theta(439) = theta(329)+theta(293)*AB(2) ! ((2,0,1)|(0,1,1)) = ((2,1,1)|(0,0,1))+((2,0,1)|(0,0,1))*AB(2)
        theta(440) = theta(332)+theta(293)*AB(3) ! ((2,0,1)|(0,0,2)) = ((2,0,2)|(0,0,1))+((2,0,1)|(0,0,1))*AB(3)
        theta(441) = theta(324)+theta(294)*AB(1) ! ((1,2,0)|(2,0,0)) = ((2,2,0)|(1,0,0))+((1,2,0)|(1,0,0))*AB(1)
        ! theta(442) = theta(325)+theta(295)*AB(1) ! ((1,2,0)|(1,1,0)) = ((2,2,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(1)
        ! theta(443) = theta(326)+theta(296)*AB(1) ! ((1,2,0)|(1,0,1)) = ((2,2,0)|(0,0,1))+((1,2,0)|(0,0,1))*AB(1)
        theta(444) = theta(334)+theta(295)*AB(2) ! ((1,2,0)|(0,2,0)) = ((1,3,0)|(0,1,0))+((1,2,0)|(0,1,0))*AB(2)
        theta(445) = theta(335)+theta(296)*AB(2) ! ((1,2,0)|(0,1,1)) = ((1,3,0)|(0,0,1))+((1,2,0)|(0,0,1))*AB(2)
        theta(446) = theta(338)+theta(296)*AB(3) ! ((1,2,0)|(0,0,2)) = ((1,2,1)|(0,0,1))+((1,2,0)|(0,0,1))*AB(3)
        theta(447) = theta(327)+theta(297)*AB(1) ! ((1,1,1)|(2,0,0)) = ((2,1,1)|(1,0,0))+((1,1,1)|(1,0,0))*AB(1)
        theta(448) = theta(328)+theta(298)*AB(1) ! ((1,1,1)|(1,1,0)) = ((2,1,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(1)
        ! theta(449) = theta(329)+theta(299)*AB(1) ! ((1,1,1)|(1,0,1)) = ((2,1,1)|(0,0,1))+((1,1,1)|(0,0,1))*AB(1)
        theta(450) = theta(337)+theta(298)*AB(2) ! ((1,1,1)|(0,2,0)) = ((1,2,1)|(0,1,0))+((1,1,1)|(0,1,0))*AB(2)
        theta(451) = theta(338)+theta(299)*AB(2) ! ((1,1,1)|(0,1,1)) = ((1,2,1)|(0,0,1))+((1,1,1)|(0,0,1))*AB(2)
        theta(452) = theta(341)+theta(299)*AB(3) ! ((1,1,1)|(0,0,2)) = ((1,1,2)|(0,0,1))+((1,1,1)|(0,0,1))*AB(3)
        theta(453) = theta(330)+theta(300)*AB(1) ! ((1,0,2)|(2,0,0)) = ((2,0,2)|(1,0,0))+((1,0,2)|(1,0,0))*AB(1)
        theta(454) = theta(331)+theta(301)*AB(1) ! ((1,0,2)|(1,1,0)) = ((2,0,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(1)
        ! theta(455) = theta(332)+theta(302)*AB(1) ! ((1,0,2)|(1,0,1)) = ((2,0,2)|(0,0,1))+((1,0,2)|(0,0,1))*AB(1)
        theta(456) = theta(340)+theta(301)*AB(2) ! ((1,0,2)|(0,2,0)) = ((1,1,2)|(0,1,0))+((1,0,2)|(0,1,0))*AB(2)
        theta(457) = theta(341)+theta(302)*AB(2) ! ((1,0,2)|(0,1,1)) = ((1,1,2)|(0,0,1))+((1,0,2)|(0,0,1))*AB(2)
        theta(458) = theta(344)+theta(302)*AB(3) ! ((1,0,2)|(0,0,2)) = ((1,0,3)|(0,0,1))+((1,0,2)|(0,0,1))*AB(3)
        theta(459) = theta(333)+theta(303)*AB(1) ! ((0,3,0)|(2,0,0)) = ((1,3,0)|(1,0,0))+((0,3,0)|(1,0,0))*AB(1)
        ! theta(460) = theta(334)+theta(304)*AB(1) ! ((0,3,0)|(1,1,0)) = ((1,3,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(1)
        ! theta(461) = theta(335)+theta(305)*AB(1) ! ((0,3,0)|(1,0,1)) = ((1,3,0)|(0,0,1))+((0,3,0)|(0,0,1))*AB(1)
        theta(462) = theta(346)+theta(304)*AB(2) ! ((0,3,0)|(0,2,0)) = ((0,4,0)|(0,1,0))+((0,3,0)|(0,1,0))*AB(2)
        theta(463) = theta(347)+theta(305)*AB(2) ! ((0,3,0)|(0,1,1)) = ((0,4,0)|(0,0,1))+((0,3,0)|(0,0,1))*AB(2)
        theta(464) = theta(350)+theta(305)*AB(3) ! ((0,3,0)|(0,0,2)) = ((0,3,1)|(0,0,1))+((0,3,0)|(0,0,1))*AB(3)
        theta(465) = theta(336)+theta(306)*AB(1) ! ((0,2,1)|(2,0,0)) = ((1,2,1)|(1,0,0))+((0,2,1)|(1,0,0))*AB(1)
        theta(466) = theta(337)+theta(307)*AB(1) ! ((0,2,1)|(1,1,0)) = ((1,2,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(1)
        ! theta(467) = theta(338)+theta(308)*AB(1) ! ((0,2,1)|(1,0,1)) = ((1,2,1)|(0,0,1))+((0,2,1)|(0,0,1))*AB(1)
        theta(468) = theta(349)+theta(307)*AB(2) ! ((0,2,1)|(0,2,0)) = ((0,3,1)|(0,1,0))+((0,2,1)|(0,1,0))*AB(2)
        theta(469) = theta(350)+theta(308)*AB(2) ! ((0,2,1)|(0,1,1)) = ((0,3,1)|(0,0,1))+((0,2,1)|(0,0,1))*AB(2)
        theta(470) = theta(353)+theta(308)*AB(3) ! ((0,2,1)|(0,0,2)) = ((0,2,2)|(0,0,1))+((0,2,1)|(0,0,1))*AB(3)
        theta(471) = theta(339)+theta(309)*AB(1) ! ((0,1,2)|(2,0,0)) = ((1,1,2)|(1,0,0))+((0,1,2)|(1,0,0))*AB(1)
        theta(472) = theta(340)+theta(310)*AB(1) ! ((0,1,2)|(1,1,0)) = ((1,1,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(1)
        ! theta(473) = theta(341)+theta(311)*AB(1) ! ((0,1,2)|(1,0,1)) = ((1,1,2)|(0,0,1))+((0,1,2)|(0,0,1))*AB(1)
        theta(474) = theta(352)+theta(310)*AB(2) ! ((0,1,2)|(0,2,0)) = ((0,2,2)|(0,1,0))+((0,1,2)|(0,1,0))*AB(2)
        theta(475) = theta(353)+theta(311)*AB(2) ! ((0,1,2)|(0,1,1)) = ((0,2,2)|(0,0,1))+((0,1,2)|(0,0,1))*AB(2)
        theta(476) = theta(356)+theta(311)*AB(3) ! ((0,1,2)|(0,0,2)) = ((0,1,3)|(0,0,1))+((0,1,2)|(0,0,1))*AB(3)
        theta(477) = theta(342)+theta(312)*AB(1) ! ((0,0,3)|(2,0,0)) = ((1,0,3)|(1,0,0))+((0,0,3)|(1,0,0))*AB(1)
        theta(478) = theta(343)+theta(313)*AB(1) ! ((0,0,3)|(1,1,0)) = ((1,0,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(1)
        ! theta(479) = theta(344)+theta(314)*AB(1) ! ((0,0,3)|(1,0,1)) = ((1,0,3)|(0,0,1))+((0,0,3)|(0,0,1))*AB(1)
        theta(480) = theta(355)+theta(313)*AB(2) ! ((0,0,3)|(0,2,0)) = ((0,1,3)|(0,1,0))+((0,0,3)|(0,1,0))*AB(2)
        theta(481) = theta(356)+theta(314)*AB(2) ! ((0,0,3)|(0,1,1)) = ((0,1,3)|(0,0,1))+((0,0,3)|(0,0,1))*AB(2)
        theta(482) = theta(359)+theta(314)*AB(3) ! ((0,0,3)|(0,0,2)) = ((0,0,4)|(0,0,1))+((0,0,3)|(0,0,1))*AB(3)
        theta(483) = theta(360)+theta(315)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        ! theta(484) = theta(361)+theta(316)*AB(1) ! ((4,0,0)|(1,1,0)) = ((5,0,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(1)
        ! theta(485) = theta(362)+theta(317)*AB(1) ! ((4,0,0)|(1,0,1)) = ((5,0,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(1)
        theta(486) = theta(364)+theta(316)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(487) = theta(365)+theta(317)*AB(2) ! ((4,0,0)|(0,1,1)) = ((4,1,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(2)
        theta(488) = theta(368)+theta(317)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(489) = theta(363)+theta(318)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        ! theta(490) = theta(364)+theta(319)*AB(1) ! ((3,1,0)|(1,1,0)) = ((4,1,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(1)
        ! theta(491) = theta(365)+theta(320)*AB(1) ! ((3,1,0)|(1,0,1)) = ((4,1,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(1)
        theta(492) = theta(370)+theta(319)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(493) = theta(371)+theta(320)*AB(2) ! ((3,1,0)|(0,1,1)) = ((3,2,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(2)
        theta(494) = theta(374)+theta(320)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(495) = theta(366)+theta(321)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(496) = theta(367)+theta(322)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        ! theta(497) = theta(368)+theta(323)*AB(1) ! ((3,0,1)|(1,0,1)) = ((4,0,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(1)
        theta(498) = theta(373)+theta(322)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(499) = theta(374)+theta(323)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        theta(500) = theta(377)+theta(323)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(501) = theta(369)+theta(324)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        ! theta(502) = theta(370)+theta(325)*AB(1) ! ((2,2,0)|(1,1,0)) = ((3,2,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(1)
        ! theta(503) = theta(371)+theta(326)*AB(1) ! ((2,2,0)|(1,0,1)) = ((3,2,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(1)
        theta(504) = theta(379)+theta(325)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(505) = theta(380)+theta(326)*AB(2) ! ((2,2,0)|(0,1,1)) = ((2,3,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(2)
        theta(506) = theta(383)+theta(326)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(507) = theta(372)+theta(327)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(508) = theta(373)+theta(328)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        ! theta(509) = theta(374)+theta(329)*AB(1) ! ((2,1,1)|(1,0,1)) = ((3,1,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(1)
        theta(510) = theta(382)+theta(328)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(511) = theta(383)+theta(329)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        theta(512) = theta(386)+theta(329)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(513) = theta(375)+theta(330)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(514) = theta(376)+theta(331)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        ! theta(515) = theta(377)+theta(332)*AB(1) ! ((2,0,2)|(1,0,1)) = ((3,0,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(1)
        theta(516) = theta(385)+theta(331)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(517) = theta(386)+theta(332)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        theta(518) = theta(389)+theta(332)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(519) = theta(378)+theta(333)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        ! theta(520) = theta(379)+theta(334)*AB(1) ! ((1,3,0)|(1,1,0)) = ((2,3,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(1)
        ! theta(521) = theta(380)+theta(335)*AB(1) ! ((1,3,0)|(1,0,1)) = ((2,3,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(1)
        theta(522) = theta(391)+theta(334)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(523) = theta(392)+theta(335)*AB(2) ! ((1,3,0)|(0,1,1)) = ((1,4,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(2)
        theta(524) = theta(395)+theta(335)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(525) = theta(381)+theta(336)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(526) = theta(382)+theta(337)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        ! theta(527) = theta(383)+theta(338)*AB(1) ! ((1,2,1)|(1,0,1)) = ((2,2,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(1)
        theta(528) = theta(394)+theta(337)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(529) = theta(395)+theta(338)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        theta(530) = theta(398)+theta(338)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(531) = theta(384)+theta(339)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(532) = theta(385)+theta(340)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        ! theta(533) = theta(386)+theta(341)*AB(1) ! ((1,1,2)|(1,0,1)) = ((2,1,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(1)
        theta(534) = theta(397)+theta(340)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(535) = theta(398)+theta(341)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        theta(536) = theta(401)+theta(341)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(537) = theta(387)+theta(342)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(538) = theta(388)+theta(343)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        ! theta(539) = theta(389)+theta(344)*AB(1) ! ((1,0,3)|(1,0,1)) = ((2,0,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(1)
        theta(540) = theta(400)+theta(343)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(541) = theta(401)+theta(344)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        theta(542) = theta(404)+theta(344)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(543) = theta(390)+theta(345)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        ! theta(544) = theta(391)+theta(346)*AB(1) ! ((0,4,0)|(1,1,0)) = ((1,4,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(1)
        ! theta(545) = theta(392)+theta(347)*AB(1) ! ((0,4,0)|(1,0,1)) = ((1,4,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(1)
        theta(546) = theta(406)+theta(346)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        ! theta(547) = theta(407)+theta(347)*AB(2) ! ((0,4,0)|(0,1,1)) = ((0,5,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(2)
        theta(548) = theta(410)+theta(347)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(549) = theta(393)+theta(348)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        ! theta(550) = theta(394)+theta(349)*AB(1) ! ((0,3,1)|(1,1,0)) = ((1,3,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(1)
        ! theta(551) = theta(395)+theta(350)*AB(1) ! ((0,3,1)|(1,0,1)) = ((1,3,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(1)
        theta(552) = theta(409)+theta(349)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        ! theta(553) = theta(410)+theta(350)*AB(2) ! ((0,3,1)|(0,1,1)) = ((0,4,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(2)
        theta(554) = theta(413)+theta(350)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(555) = theta(396)+theta(351)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        ! theta(556) = theta(397)+theta(352)*AB(1) ! ((0,2,2)|(1,1,0)) = ((1,2,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(1)
        ! theta(557) = theta(398)+theta(353)*AB(1) ! ((0,2,2)|(1,0,1)) = ((1,2,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(1)
        theta(558) = theta(412)+theta(352)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        ! theta(559) = theta(413)+theta(353)*AB(2) ! ((0,2,2)|(0,1,1)) = ((0,3,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(2)
        theta(560) = theta(416)+theta(353)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(561) = theta(399)+theta(354)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        ! theta(562) = theta(400)+theta(355)*AB(1) ! ((0,1,3)|(1,1,0)) = ((1,1,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(1)
        ! theta(563) = theta(401)+theta(356)*AB(1) ! ((0,1,3)|(1,0,1)) = ((1,1,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(1)
        theta(564) = theta(415)+theta(355)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        ! theta(565) = theta(416)+theta(356)*AB(2) ! ((0,1,3)|(0,1,1)) = ((0,2,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(2)
        theta(566) = theta(419)+theta(356)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(567) = theta(402)+theta(357)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        ! theta(568) = theta(403)+theta(358)*AB(1) ! ((0,0,4)|(1,1,0)) = ((1,0,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(1)
        ! theta(569) = theta(404)+theta(359)*AB(1) ! ((0,0,4)|(1,0,1)) = ((1,0,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(1)
        theta(570) = theta(418)+theta(358)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        ! theta(571) = theta(419)+theta(359)*AB(2) ! ((0,0,4)|(0,1,1)) = ((0,1,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(2)
        theta(572) = theta(422)+theta(359)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(573) = theta(483)+theta(423)*AB(1) ! ((3,0,0)|(3,0,0)) = ((4,0,0)|(2,0,0))+((3,0,0)|(2,0,0))*AB(1)
        theta(574) = theta(489)+theta(423)*AB(2) ! ((3,0,0)|(2,1,0)) = ((3,1,0)|(2,0,0))+((3,0,0)|(2,0,0))*AB(2)
        theta(575) = theta(495)+theta(423)*AB(3) ! ((3,0,0)|(2,0,1)) = ((3,0,1)|(2,0,0))+((3,0,0)|(2,0,0))*AB(3)
        theta(576) = theta(486)+theta(426)*AB(1) ! ((3,0,0)|(1,2,0)) = ((4,0,0)|(0,2,0))+((3,0,0)|(0,2,0))*AB(1)
        theta(577) = theta(487)+theta(427)*AB(1) ! ((3,0,0)|(1,1,1)) = ((4,0,0)|(0,1,1))+((3,0,0)|(0,1,1))*AB(1)
        theta(578) = theta(488)+theta(428)*AB(1) ! ((3,0,0)|(1,0,2)) = ((4,0,0)|(0,0,2))+((3,0,0)|(0,0,2))*AB(1)
        theta(579) = theta(492)+theta(426)*AB(2) ! ((3,0,0)|(0,3,0)) = ((3,1,0)|(0,2,0))+((3,0,0)|(0,2,0))*AB(2)
        theta(580) = theta(498)+theta(426)*AB(3) ! ((3,0,0)|(0,2,1)) = ((3,0,1)|(0,2,0))+((3,0,0)|(0,2,0))*AB(3)
        theta(581) = theta(494)+theta(428)*AB(2) ! ((3,0,0)|(0,1,2)) = ((3,1,0)|(0,0,2))+((3,0,0)|(0,0,2))*AB(2)
        theta(582) = theta(500)+theta(428)*AB(3) ! ((3,0,0)|(0,0,3)) = ((3,0,1)|(0,0,2))+((3,0,0)|(0,0,2))*AB(3)
        theta(583) = theta(489)+theta(429)*AB(1) ! ((2,1,0)|(3,0,0)) = ((3,1,0)|(2,0,0))+((2,1,0)|(2,0,0))*AB(1)
        theta(584) = theta(501)+theta(429)*AB(2) ! ((2,1,0)|(2,1,0)) = ((2,2,0)|(2,0,0))+((2,1,0)|(2,0,0))*AB(2)
        theta(585) = theta(507)+theta(429)*AB(3) ! ((2,1,0)|(2,0,1)) = ((2,1,1)|(2,0,0))+((2,1,0)|(2,0,0))*AB(3)
        theta(586) = theta(492)+theta(432)*AB(1) ! ((2,1,0)|(1,2,0)) = ((3,1,0)|(0,2,0))+((2,1,0)|(0,2,0))*AB(1)
        theta(587) = theta(493)+theta(433)*AB(1) ! ((2,1,0)|(1,1,1)) = ((3,1,0)|(0,1,1))+((2,1,0)|(0,1,1))*AB(1)
        theta(588) = theta(494)+theta(434)*AB(1) ! ((2,1,0)|(1,0,2)) = ((3,1,0)|(0,0,2))+((2,1,0)|(0,0,2))*AB(1)
        theta(589) = theta(504)+theta(432)*AB(2) ! ((2,1,0)|(0,3,0)) = ((2,2,0)|(0,2,0))+((2,1,0)|(0,2,0))*AB(2)
        theta(590) = theta(510)+theta(432)*AB(3) ! ((2,1,0)|(0,2,1)) = ((2,1,1)|(0,2,0))+((2,1,0)|(0,2,0))*AB(3)
        theta(591) = theta(506)+theta(434)*AB(2) ! ((2,1,0)|(0,1,2)) = ((2,2,0)|(0,0,2))+((2,1,0)|(0,0,2))*AB(2)
        theta(592) = theta(512)+theta(434)*AB(3) ! ((2,1,0)|(0,0,3)) = ((2,1,1)|(0,0,2))+((2,1,0)|(0,0,2))*AB(3)
        theta(593) = theta(495)+theta(435)*AB(1) ! ((2,0,1)|(3,0,0)) = ((3,0,1)|(2,0,0))+((2,0,1)|(2,0,0))*AB(1)
        theta(594) = theta(496)+theta(436)*AB(1) ! ((2,0,1)|(2,1,0)) = ((3,0,1)|(1,1,0))+((2,0,1)|(1,1,0))*AB(1)
        theta(595) = theta(513)+theta(435)*AB(3) ! ((2,0,1)|(2,0,1)) = ((2,0,2)|(2,0,0))+((2,0,1)|(2,0,0))*AB(3)
        theta(596) = theta(498)+theta(438)*AB(1) ! ((2,0,1)|(1,2,0)) = ((3,0,1)|(0,2,0))+((2,0,1)|(0,2,0))*AB(1)
        theta(597) = theta(499)+theta(439)*AB(1) ! ((2,0,1)|(1,1,1)) = ((3,0,1)|(0,1,1))+((2,0,1)|(0,1,1))*AB(1)
        theta(598) = theta(500)+theta(440)*AB(1) ! ((2,0,1)|(1,0,2)) = ((3,0,1)|(0,0,2))+((2,0,1)|(0,0,2))*AB(1)
        theta(599) = theta(510)+theta(438)*AB(2) ! ((2,0,1)|(0,3,0)) = ((2,1,1)|(0,2,0))+((2,0,1)|(0,2,0))*AB(2)
        theta(600) = theta(516)+theta(438)*AB(3) ! ((2,0,1)|(0,2,1)) = ((2,0,2)|(0,2,0))+((2,0,1)|(0,2,0))*AB(3)
        theta(601) = theta(512)+theta(440)*AB(2) ! ((2,0,1)|(0,1,2)) = ((2,1,1)|(0,0,2))+((2,0,1)|(0,0,2))*AB(2)
        theta(602) = theta(518)+theta(440)*AB(3) ! ((2,0,1)|(0,0,3)) = ((2,0,2)|(0,0,2))+((2,0,1)|(0,0,2))*AB(3)
        theta(603) = theta(501)+theta(441)*AB(1) ! ((1,2,0)|(3,0,0)) = ((2,2,0)|(2,0,0))+((1,2,0)|(2,0,0))*AB(1)
        theta(604) = theta(519)+theta(441)*AB(2) ! ((1,2,0)|(2,1,0)) = ((1,3,0)|(2,0,0))+((1,2,0)|(2,0,0))*AB(2)
        theta(605) = theta(525)+theta(441)*AB(3) ! ((1,2,0)|(2,0,1)) = ((1,2,1)|(2,0,0))+((1,2,0)|(2,0,0))*AB(3)
        theta(606) = theta(504)+theta(444)*AB(1) ! ((1,2,0)|(1,2,0)) = ((2,2,0)|(0,2,0))+((1,2,0)|(0,2,0))*AB(1)
        theta(607) = theta(505)+theta(445)*AB(1) ! ((1,2,0)|(1,1,1)) = ((2,2,0)|(0,1,1))+((1,2,0)|(0,1,1))*AB(1)
        theta(608) = theta(506)+theta(446)*AB(1) ! ((1,2,0)|(1,0,2)) = ((2,2,0)|(0,0,2))+((1,2,0)|(0,0,2))*AB(1)
        theta(609) = theta(522)+theta(444)*AB(2) ! ((1,2,0)|(0,3,0)) = ((1,3,0)|(0,2,0))+((1,2,0)|(0,2,0))*AB(2)
        theta(610) = theta(528)+theta(444)*AB(3) ! ((1,2,0)|(0,2,1)) = ((1,2,1)|(0,2,0))+((1,2,0)|(0,2,0))*AB(3)
        theta(611) = theta(524)+theta(446)*AB(2) ! ((1,2,0)|(0,1,2)) = ((1,3,0)|(0,0,2))+((1,2,0)|(0,0,2))*AB(2)
        theta(612) = theta(530)+theta(446)*AB(3) ! ((1,2,0)|(0,0,3)) = ((1,2,1)|(0,0,2))+((1,2,0)|(0,0,2))*AB(3)
        theta(613) = theta(507)+theta(447)*AB(1) ! ((1,1,1)|(3,0,0)) = ((2,1,1)|(2,0,0))+((1,1,1)|(2,0,0))*AB(1)
        theta(614) = theta(508)+theta(448)*AB(1) ! ((1,1,1)|(2,1,0)) = ((2,1,1)|(1,1,0))+((1,1,1)|(1,1,0))*AB(1)
        theta(615) = theta(531)+theta(447)*AB(3) ! ((1,1,1)|(2,0,1)) = ((1,1,2)|(2,0,0))+((1,1,1)|(2,0,0))*AB(3)
        theta(616) = theta(510)+theta(450)*AB(1) ! ((1,1,1)|(1,2,0)) = ((2,1,1)|(0,2,0))+((1,1,1)|(0,2,0))*AB(1)
        theta(617) = theta(511)+theta(451)*AB(1) ! ((1,1,1)|(1,1,1)) = ((2,1,1)|(0,1,1))+((1,1,1)|(0,1,1))*AB(1)
        theta(618) = theta(512)+theta(452)*AB(1) ! ((1,1,1)|(1,0,2)) = ((2,1,1)|(0,0,2))+((1,1,1)|(0,0,2))*AB(1)
        theta(619) = theta(528)+theta(450)*AB(2) ! ((1,1,1)|(0,3,0)) = ((1,2,1)|(0,2,0))+((1,1,1)|(0,2,0))*AB(2)
        theta(620) = theta(534)+theta(450)*AB(3) ! ((1,1,1)|(0,2,1)) = ((1,1,2)|(0,2,0))+((1,1,1)|(0,2,0))*AB(3)
        theta(621) = theta(530)+theta(452)*AB(2) ! ((1,1,1)|(0,1,2)) = ((1,2,1)|(0,0,2))+((1,1,1)|(0,0,2))*AB(2)
        theta(622) = theta(536)+theta(452)*AB(3) ! ((1,1,1)|(0,0,3)) = ((1,1,2)|(0,0,2))+((1,1,1)|(0,0,2))*AB(3)
        theta(623) = theta(513)+theta(453)*AB(1) ! ((1,0,2)|(3,0,0)) = ((2,0,2)|(2,0,0))+((1,0,2)|(2,0,0))*AB(1)
        theta(624) = theta(514)+theta(454)*AB(1) ! ((1,0,2)|(2,1,0)) = ((2,0,2)|(1,1,0))+((1,0,2)|(1,1,0))*AB(1)
        theta(625) = theta(537)+theta(453)*AB(3) ! ((1,0,2)|(2,0,1)) = ((1,0,3)|(2,0,0))+((1,0,2)|(2,0,0))*AB(3)
        theta(626) = theta(516)+theta(456)*AB(1) ! ((1,0,2)|(1,2,0)) = ((2,0,2)|(0,2,0))+((1,0,2)|(0,2,0))*AB(1)
        theta(627) = theta(517)+theta(457)*AB(1) ! ((1,0,2)|(1,1,1)) = ((2,0,2)|(0,1,1))+((1,0,2)|(0,1,1))*AB(1)
        theta(628) = theta(518)+theta(458)*AB(1) ! ((1,0,2)|(1,0,2)) = ((2,0,2)|(0,0,2))+((1,0,2)|(0,0,2))*AB(1)
        theta(629) = theta(534)+theta(456)*AB(2) ! ((1,0,2)|(0,3,0)) = ((1,1,2)|(0,2,0))+((1,0,2)|(0,2,0))*AB(2)
        theta(630) = theta(540)+theta(456)*AB(3) ! ((1,0,2)|(0,2,1)) = ((1,0,3)|(0,2,0))+((1,0,2)|(0,2,0))*AB(3)
        theta(631) = theta(536)+theta(458)*AB(2) ! ((1,0,2)|(0,1,2)) = ((1,1,2)|(0,0,2))+((1,0,2)|(0,0,2))*AB(2)
        theta(632) = theta(542)+theta(458)*AB(3) ! ((1,0,2)|(0,0,3)) = ((1,0,3)|(0,0,2))+((1,0,2)|(0,0,2))*AB(3)
        theta(633) = theta(519)+theta(459)*AB(1) ! ((0,3,0)|(3,0,0)) = ((1,3,0)|(2,0,0))+((0,3,0)|(2,0,0))*AB(1)
        theta(634) = theta(543)+theta(459)*AB(2) ! ((0,3,0)|(2,1,0)) = ((0,4,0)|(2,0,0))+((0,3,0)|(2,0,0))*AB(2)
        theta(635) = theta(549)+theta(459)*AB(3) ! ((0,3,0)|(2,0,1)) = ((0,3,1)|(2,0,0))+((0,3,0)|(2,0,0))*AB(3)
        theta(636) = theta(522)+theta(462)*AB(1) ! ((0,3,0)|(1,2,0)) = ((1,3,0)|(0,2,0))+((0,3,0)|(0,2,0))*AB(1)
        theta(637) = theta(523)+theta(463)*AB(1) ! ((0,3,0)|(1,1,1)) = ((1,3,0)|(0,1,1))+((0,3,0)|(0,1,1))*AB(1)
        theta(638) = theta(524)+theta(464)*AB(1) ! ((0,3,0)|(1,0,2)) = ((1,3,0)|(0,0,2))+((0,3,0)|(0,0,2))*AB(1)
        theta(639) = theta(546)+theta(462)*AB(2) ! ((0,3,0)|(0,3,0)) = ((0,4,0)|(0,2,0))+((0,3,0)|(0,2,0))*AB(2)
        theta(640) = theta(552)+theta(462)*AB(3) ! ((0,3,0)|(0,2,1)) = ((0,3,1)|(0,2,0))+((0,3,0)|(0,2,0))*AB(3)
        theta(641) = theta(548)+theta(464)*AB(2) ! ((0,3,0)|(0,1,2)) = ((0,4,0)|(0,0,2))+((0,3,0)|(0,0,2))*AB(2)
        theta(642) = theta(554)+theta(464)*AB(3) ! ((0,3,0)|(0,0,3)) = ((0,3,1)|(0,0,2))+((0,3,0)|(0,0,2))*AB(3)
        theta(643) = theta(525)+theta(465)*AB(1) ! ((0,2,1)|(3,0,0)) = ((1,2,1)|(2,0,0))+((0,2,1)|(2,0,0))*AB(1)
        theta(644) = theta(526)+theta(466)*AB(1) ! ((0,2,1)|(2,1,0)) = ((1,2,1)|(1,1,0))+((0,2,1)|(1,1,0))*AB(1)
        theta(645) = theta(555)+theta(465)*AB(3) ! ((0,2,1)|(2,0,1)) = ((0,2,2)|(2,0,0))+((0,2,1)|(2,0,0))*AB(3)
        theta(646) = theta(528)+theta(468)*AB(1) ! ((0,2,1)|(1,2,0)) = ((1,2,1)|(0,2,0))+((0,2,1)|(0,2,0))*AB(1)
        theta(647) = theta(529)+theta(469)*AB(1) ! ((0,2,1)|(1,1,1)) = ((1,2,1)|(0,1,1))+((0,2,1)|(0,1,1))*AB(1)
        theta(648) = theta(530)+theta(470)*AB(1) ! ((0,2,1)|(1,0,2)) = ((1,2,1)|(0,0,2))+((0,2,1)|(0,0,2))*AB(1)
        theta(649) = theta(552)+theta(468)*AB(2) ! ((0,2,1)|(0,3,0)) = ((0,3,1)|(0,2,0))+((0,2,1)|(0,2,0))*AB(2)
        theta(650) = theta(558)+theta(468)*AB(3) ! ((0,2,1)|(0,2,1)) = ((0,2,2)|(0,2,0))+((0,2,1)|(0,2,0))*AB(3)
        theta(651) = theta(554)+theta(470)*AB(2) ! ((0,2,1)|(0,1,2)) = ((0,3,1)|(0,0,2))+((0,2,1)|(0,0,2))*AB(2)
        theta(652) = theta(560)+theta(470)*AB(3) ! ((0,2,1)|(0,0,3)) = ((0,2,2)|(0,0,2))+((0,2,1)|(0,0,2))*AB(3)
        theta(653) = theta(531)+theta(471)*AB(1) ! ((0,1,2)|(3,0,0)) = ((1,1,2)|(2,0,0))+((0,1,2)|(2,0,0))*AB(1)
        theta(654) = theta(532)+theta(472)*AB(1) ! ((0,1,2)|(2,1,0)) = ((1,1,2)|(1,1,0))+((0,1,2)|(1,1,0))*AB(1)
        theta(655) = theta(561)+theta(471)*AB(3) ! ((0,1,2)|(2,0,1)) = ((0,1,3)|(2,0,0))+((0,1,2)|(2,0,0))*AB(3)
        theta(656) = theta(534)+theta(474)*AB(1) ! ((0,1,2)|(1,2,0)) = ((1,1,2)|(0,2,0))+((0,1,2)|(0,2,0))*AB(1)
        theta(657) = theta(535)+theta(475)*AB(1) ! ((0,1,2)|(1,1,1)) = ((1,1,2)|(0,1,1))+((0,1,2)|(0,1,1))*AB(1)
        theta(658) = theta(536)+theta(476)*AB(1) ! ((0,1,2)|(1,0,2)) = ((1,1,2)|(0,0,2))+((0,1,2)|(0,0,2))*AB(1)
        theta(659) = theta(558)+theta(474)*AB(2) ! ((0,1,2)|(0,3,0)) = ((0,2,2)|(0,2,0))+((0,1,2)|(0,2,0))*AB(2)
        theta(660) = theta(564)+theta(474)*AB(3) ! ((0,1,2)|(0,2,1)) = ((0,1,3)|(0,2,0))+((0,1,2)|(0,2,0))*AB(3)
        theta(661) = theta(560)+theta(476)*AB(2) ! ((0,1,2)|(0,1,2)) = ((0,2,2)|(0,0,2))+((0,1,2)|(0,0,2))*AB(2)
        theta(662) = theta(566)+theta(476)*AB(3) ! ((0,1,2)|(0,0,3)) = ((0,1,3)|(0,0,2))+((0,1,2)|(0,0,2))*AB(3)
        theta(663) = theta(537)+theta(477)*AB(1) ! ((0,0,3)|(3,0,0)) = ((1,0,3)|(2,0,0))+((0,0,3)|(2,0,0))*AB(1)
        theta(664) = theta(538)+theta(478)*AB(1) ! ((0,0,3)|(2,1,0)) = ((1,0,3)|(1,1,0))+((0,0,3)|(1,1,0))*AB(1)
        theta(665) = theta(567)+theta(477)*AB(3) ! ((0,0,3)|(2,0,1)) = ((0,0,4)|(2,0,0))+((0,0,3)|(2,0,0))*AB(3)
        theta(666) = theta(540)+theta(480)*AB(1) ! ((0,0,3)|(1,2,0)) = ((1,0,3)|(0,2,0))+((0,0,3)|(0,2,0))*AB(1)
        theta(667) = theta(541)+theta(481)*AB(1) ! ((0,0,3)|(1,1,1)) = ((1,0,3)|(0,1,1))+((0,0,3)|(0,1,1))*AB(1)
        theta(668) = theta(542)+theta(482)*AB(1) ! ((0,0,3)|(1,0,2)) = ((1,0,3)|(0,0,2))+((0,0,3)|(0,0,2))*AB(1)
        theta(669) = theta(564)+theta(480)*AB(2) ! ((0,0,3)|(0,3,0)) = ((0,1,3)|(0,2,0))+((0,0,3)|(0,2,0))*AB(2)
        theta(670) = theta(570)+theta(480)*AB(3) ! ((0,0,3)|(0,2,1)) = ((0,0,4)|(0,2,0))+((0,0,3)|(0,2,0))*AB(3)
        theta(671) = theta(566)+theta(482)*AB(2) ! ((0,0,3)|(0,1,2)) = ((0,1,3)|(0,0,2))+((0,0,3)|(0,0,2))*AB(2)
        theta(672) = theta(572)+theta(482)*AB(3) ! ((0,0,3)|(0,0,3)) = ((0,0,4)|(0,0,2))+((0,0,3)|(0,0,2))*AB(3)
    end subroutine
    subroutine hrr_4_0(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 15; Optimized integrals: 15
    end subroutine
    subroutine hrr_4_1(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 81; Optimized integrals: 81
        theta(163) = theta(142)+theta(127)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(164) = theta(143)+theta(127)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(165) = theta(144)+theta(127)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(166) = theta(143)+theta(128)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(167) = theta(145)+theta(128)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(168) = theta(146)+theta(128)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(169) = theta(144)+theta(129)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(170) = theta(146)+theta(129)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(171) = theta(147)+theta(129)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(172) = theta(145)+theta(130)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(173) = theta(148)+theta(130)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(174) = theta(149)+theta(130)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(175) = theta(146)+theta(131)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(176) = theta(149)+theta(131)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(177) = theta(150)+theta(131)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(178) = theta(147)+theta(132)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(179) = theta(150)+theta(132)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(180) = theta(151)+theta(132)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(181) = theta(148)+theta(133)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(182) = theta(152)+theta(133)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(183) = theta(153)+theta(133)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(184) = theta(149)+theta(134)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(185) = theta(153)+theta(134)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(186) = theta(154)+theta(134)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(187) = theta(150)+theta(135)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(188) = theta(154)+theta(135)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(189) = theta(155)+theta(135)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(190) = theta(151)+theta(136)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(191) = theta(155)+theta(136)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(192) = theta(156)+theta(136)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(193) = theta(152)+theta(137)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(194) = theta(157)+theta(137)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(195) = theta(158)+theta(137)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(196) = theta(153)+theta(138)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(197) = theta(158)+theta(138)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(198) = theta(159)+theta(138)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(199) = theta(154)+theta(139)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(200) = theta(159)+theta(139)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(201) = theta(160)+theta(139)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(202) = theta(155)+theta(140)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(203) = theta(160)+theta(140)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(204) = theta(161)+theta(140)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(205) = theta(156)+theta(141)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(206) = theta(161)+theta(141)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(207) = theta(162)+theta(141)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
    end subroutine
    subroutine hrr_4_2(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 262; Optimized integrals: 255
        theta(275) = theta(226)+theta(211)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(276) = theta(227)+theta(211)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(277) = theta(228)+theta(211)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(278) = theta(227)+theta(212)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(279) = theta(229)+theta(212)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(280) = theta(230)+theta(212)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(281) = theta(228)+theta(213)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(282) = theta(230)+theta(213)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(283) = theta(231)+theta(213)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(284) = theta(229)+theta(214)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(285) = theta(232)+theta(214)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(286) = theta(233)+theta(214)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(287) = theta(230)+theta(215)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(288) = theta(233)+theta(215)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(289) = theta(234)+theta(215)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(290) = theta(231)+theta(216)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(291) = theta(234)+theta(216)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(292) = theta(235)+theta(216)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(293) = theta(232)+theta(217)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(294) = theta(236)+theta(217)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(295) = theta(237)+theta(217)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(296) = theta(233)+theta(218)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(297) = theta(237)+theta(218)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(298) = theta(238)+theta(218)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(299) = theta(234)+theta(219)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(300) = theta(238)+theta(219)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(301) = theta(239)+theta(219)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(302) = theta(235)+theta(220)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(303) = theta(239)+theta(220)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(304) = theta(240)+theta(220)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(305) = theta(236)+theta(221)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(306) = theta(241)+theta(221)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(307) = theta(242)+theta(221)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(308) = theta(237)+theta(222)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(309) = theta(242)+theta(222)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(310) = theta(243)+theta(222)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(311) = theta(238)+theta(223)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(312) = theta(243)+theta(223)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(313) = theta(244)+theta(223)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(314) = theta(239)+theta(224)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(315) = theta(244)+theta(224)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(316) = theta(245)+theta(224)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(317) = theta(240)+theta(225)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(318) = theta(245)+theta(225)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(319) = theta(246)+theta(225)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(320) = theta(247)+theta(226)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(321) = theta(248)+theta(226)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(322) = theta(249)+theta(226)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(323) = theta(248)+theta(227)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(324) = theta(250)+theta(227)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(325) = theta(251)+theta(227)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(326) = theta(249)+theta(228)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(327) = theta(251)+theta(228)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(328) = theta(252)+theta(228)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(329) = theta(250)+theta(229)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(330) = theta(253)+theta(229)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(331) = theta(254)+theta(229)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(332) = theta(251)+theta(230)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(333) = theta(254)+theta(230)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(334) = theta(255)+theta(230)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(335) = theta(252)+theta(231)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(336) = theta(255)+theta(231)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(337) = theta(256)+theta(231)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(338) = theta(253)+theta(232)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(339) = theta(257)+theta(232)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(340) = theta(258)+theta(232)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(341) = theta(254)+theta(233)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(342) = theta(258)+theta(233)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(343) = theta(259)+theta(233)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(344) = theta(255)+theta(234)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(345) = theta(259)+theta(234)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(346) = theta(260)+theta(234)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(347) = theta(256)+theta(235)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(348) = theta(260)+theta(235)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(349) = theta(261)+theta(235)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(350) = theta(257)+theta(236)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(351) = theta(262)+theta(236)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(352) = theta(263)+theta(236)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(353) = theta(258)+theta(237)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(354) = theta(263)+theta(237)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(355) = theta(264)+theta(237)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(356) = theta(259)+theta(238)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(357) = theta(264)+theta(238)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(358) = theta(265)+theta(238)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(359) = theta(260)+theta(239)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(360) = theta(265)+theta(239)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(361) = theta(266)+theta(239)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(362) = theta(261)+theta(240)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(363) = theta(266)+theta(240)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(364) = theta(267)+theta(240)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        ! theta(365) = theta(262)+theta(241)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(366) = theta(268)+theta(241)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(367) = theta(269)+theta(241)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        ! theta(368) = theta(263)+theta(242)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(369) = theta(269)+theta(242)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(370) = theta(270)+theta(242)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        ! theta(371) = theta(264)+theta(243)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(372) = theta(270)+theta(243)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(373) = theta(271)+theta(243)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        ! theta(374) = theta(265)+theta(244)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(375) = theta(271)+theta(244)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(376) = theta(272)+theta(244)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        ! theta(377) = theta(266)+theta(245)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(378) = theta(272)+theta(245)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(379) = theta(273)+theta(245)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        ! theta(380) = theta(267)+theta(246)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        ! theta(381) = theta(273)+theta(246)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(382) = theta(274)+theta(246)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(383) = theta(320)+theta(275)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        theta(384) = theta(321)+theta(276)*AB(1) ! ((4,0,0)|(1,1,0)) = ((5,0,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(1)
        theta(385) = theta(322)+theta(277)*AB(1) ! ((4,0,0)|(1,0,1)) = ((5,0,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(1)
        theta(386) = theta(324)+theta(276)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(387) = theta(325)+theta(277)*AB(2) ! ((4,0,0)|(0,1,1)) = ((4,1,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(2)
        theta(388) = theta(328)+theta(277)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(389) = theta(323)+theta(278)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        theta(390) = theta(324)+theta(279)*AB(1) ! ((3,1,0)|(1,1,0)) = ((4,1,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(1)
        theta(391) = theta(325)+theta(280)*AB(1) ! ((3,1,0)|(1,0,1)) = ((4,1,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(1)
        theta(392) = theta(330)+theta(279)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(393) = theta(331)+theta(280)*AB(2) ! ((3,1,0)|(0,1,1)) = ((3,2,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(2)
        theta(394) = theta(334)+theta(280)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(395) = theta(326)+theta(281)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(396) = theta(327)+theta(282)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        theta(397) = theta(328)+theta(283)*AB(1) ! ((3,0,1)|(1,0,1)) = ((4,0,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(1)
        theta(398) = theta(333)+theta(282)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(399) = theta(334)+theta(283)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        theta(400) = theta(337)+theta(283)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(401) = theta(329)+theta(284)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        theta(402) = theta(330)+theta(285)*AB(1) ! ((2,2,0)|(1,1,0)) = ((3,2,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(1)
        theta(403) = theta(331)+theta(286)*AB(1) ! ((2,2,0)|(1,0,1)) = ((3,2,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(1)
        theta(404) = theta(339)+theta(285)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(405) = theta(340)+theta(286)*AB(2) ! ((2,2,0)|(0,1,1)) = ((2,3,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(2)
        theta(406) = theta(343)+theta(286)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(407) = theta(332)+theta(287)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(408) = theta(333)+theta(288)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        theta(409) = theta(334)+theta(289)*AB(1) ! ((2,1,1)|(1,0,1)) = ((3,1,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(1)
        theta(410) = theta(342)+theta(288)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(411) = theta(343)+theta(289)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        theta(412) = theta(346)+theta(289)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(413) = theta(335)+theta(290)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(414) = theta(336)+theta(291)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        theta(415) = theta(337)+theta(292)*AB(1) ! ((2,0,2)|(1,0,1)) = ((3,0,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(1)
        theta(416) = theta(345)+theta(291)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(417) = theta(346)+theta(292)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        theta(418) = theta(349)+theta(292)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(419) = theta(338)+theta(293)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        theta(420) = theta(339)+theta(294)*AB(1) ! ((1,3,0)|(1,1,0)) = ((2,3,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(1)
        theta(421) = theta(340)+theta(295)*AB(1) ! ((1,3,0)|(1,0,1)) = ((2,3,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(1)
        theta(422) = theta(351)+theta(294)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(423) = theta(352)+theta(295)*AB(2) ! ((1,3,0)|(0,1,1)) = ((1,4,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(2)
        theta(424) = theta(355)+theta(295)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(425) = theta(341)+theta(296)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(426) = theta(342)+theta(297)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        theta(427) = theta(343)+theta(298)*AB(1) ! ((1,2,1)|(1,0,1)) = ((2,2,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(1)
        theta(428) = theta(354)+theta(297)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(429) = theta(355)+theta(298)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        theta(430) = theta(358)+theta(298)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(431) = theta(344)+theta(299)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(432) = theta(345)+theta(300)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        theta(433) = theta(346)+theta(301)*AB(1) ! ((1,1,2)|(1,0,1)) = ((2,1,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(1)
        theta(434) = theta(357)+theta(300)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(435) = theta(358)+theta(301)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        theta(436) = theta(361)+theta(301)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(437) = theta(347)+theta(302)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(438) = theta(348)+theta(303)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        theta(439) = theta(349)+theta(304)*AB(1) ! ((1,0,3)|(1,0,1)) = ((2,0,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(1)
        theta(440) = theta(360)+theta(303)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(441) = theta(361)+theta(304)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        theta(442) = theta(364)+theta(304)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(443) = theta(350)+theta(305)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        theta(444) = theta(351)+theta(306)*AB(1) ! ((0,4,0)|(1,1,0)) = ((1,4,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(1)
        theta(445) = theta(352)+theta(307)*AB(1) ! ((0,4,0)|(1,0,1)) = ((1,4,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(1)
        theta(446) = theta(366)+theta(306)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(447) = theta(367)+theta(307)*AB(2) ! ((0,4,0)|(0,1,1)) = ((0,5,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(2)
        theta(448) = theta(370)+theta(307)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(449) = theta(353)+theta(308)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(450) = theta(354)+theta(309)*AB(1) ! ((0,3,1)|(1,1,0)) = ((1,3,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(1)
        theta(451) = theta(355)+theta(310)*AB(1) ! ((0,3,1)|(1,0,1)) = ((1,3,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(1)
        theta(452) = theta(369)+theta(309)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(453) = theta(370)+theta(310)*AB(2) ! ((0,3,1)|(0,1,1)) = ((0,4,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(2)
        theta(454) = theta(373)+theta(310)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(455) = theta(356)+theta(311)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(456) = theta(357)+theta(312)*AB(1) ! ((0,2,2)|(1,1,0)) = ((1,2,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(1)
        theta(457) = theta(358)+theta(313)*AB(1) ! ((0,2,2)|(1,0,1)) = ((1,2,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(1)
        theta(458) = theta(372)+theta(312)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(459) = theta(373)+theta(313)*AB(2) ! ((0,2,2)|(0,1,1)) = ((0,3,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(2)
        theta(460) = theta(376)+theta(313)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(461) = theta(359)+theta(314)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(462) = theta(360)+theta(315)*AB(1) ! ((0,1,3)|(1,1,0)) = ((1,1,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(1)
        theta(463) = theta(361)+theta(316)*AB(1) ! ((0,1,3)|(1,0,1)) = ((1,1,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(1)
        theta(464) = theta(375)+theta(315)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(465) = theta(376)+theta(316)*AB(2) ! ((0,1,3)|(0,1,1)) = ((0,2,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(2)
        theta(466) = theta(379)+theta(316)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(467) = theta(362)+theta(317)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(468) = theta(363)+theta(318)*AB(1) ! ((0,0,4)|(1,1,0)) = ((1,0,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(1)
        theta(469) = theta(364)+theta(319)*AB(1) ! ((0,0,4)|(1,0,1)) = ((1,0,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(1)
        theta(470) = theta(378)+theta(318)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(471) = theta(379)+theta(319)*AB(2) ! ((0,0,4)|(0,1,1)) = ((0,1,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(2)
        theta(472) = theta(382)+theta(319)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
    end subroutine
    subroutine hrr_4_3(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 658; Optimized integrals: 588
        theta(431) = theta(346)+theta(331)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(432) = theta(347)+theta(331)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(433) = theta(348)+theta(331)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(434) = theta(347)+theta(332)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(435) = theta(349)+theta(332)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(436) = theta(350)+theta(332)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(437) = theta(348)+theta(333)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(438) = theta(350)+theta(333)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(439) = theta(351)+theta(333)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(440) = theta(349)+theta(334)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(441) = theta(352)+theta(334)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(442) = theta(353)+theta(334)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(443) = theta(350)+theta(335)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(444) = theta(353)+theta(335)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(445) = theta(354)+theta(335)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(446) = theta(351)+theta(336)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(447) = theta(354)+theta(336)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(448) = theta(355)+theta(336)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(449) = theta(352)+theta(337)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(450) = theta(356)+theta(337)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(451) = theta(357)+theta(337)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(452) = theta(353)+theta(338)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(453) = theta(357)+theta(338)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(454) = theta(358)+theta(338)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(455) = theta(354)+theta(339)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(456) = theta(358)+theta(339)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(457) = theta(359)+theta(339)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(458) = theta(355)+theta(340)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(459) = theta(359)+theta(340)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(460) = theta(360)+theta(340)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(461) = theta(356)+theta(341)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(462) = theta(361)+theta(341)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(463) = theta(362)+theta(341)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(464) = theta(357)+theta(342)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(465) = theta(362)+theta(342)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(466) = theta(363)+theta(342)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(467) = theta(358)+theta(343)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(468) = theta(363)+theta(343)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(469) = theta(364)+theta(343)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(470) = theta(359)+theta(344)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(471) = theta(364)+theta(344)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(472) = theta(365)+theta(344)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(473) = theta(360)+theta(345)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(474) = theta(365)+theta(345)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(475) = theta(366)+theta(345)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(476) = theta(367)+theta(346)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(477) = theta(368)+theta(346)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(478) = theta(369)+theta(346)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(479) = theta(368)+theta(347)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(480) = theta(370)+theta(347)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(481) = theta(371)+theta(347)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(482) = theta(369)+theta(348)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(483) = theta(371)+theta(348)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(484) = theta(372)+theta(348)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(485) = theta(370)+theta(349)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(486) = theta(373)+theta(349)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(487) = theta(374)+theta(349)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(488) = theta(371)+theta(350)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(489) = theta(374)+theta(350)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(490) = theta(375)+theta(350)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(491) = theta(372)+theta(351)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(492) = theta(375)+theta(351)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(493) = theta(376)+theta(351)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(494) = theta(373)+theta(352)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(495) = theta(377)+theta(352)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(496) = theta(378)+theta(352)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(497) = theta(374)+theta(353)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(498) = theta(378)+theta(353)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(499) = theta(379)+theta(353)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(500) = theta(375)+theta(354)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(501) = theta(379)+theta(354)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(502) = theta(380)+theta(354)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(503) = theta(376)+theta(355)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(504) = theta(380)+theta(355)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(505) = theta(381)+theta(355)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(506) = theta(377)+theta(356)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(507) = theta(382)+theta(356)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(508) = theta(383)+theta(356)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(509) = theta(378)+theta(357)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(510) = theta(383)+theta(357)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(511) = theta(384)+theta(357)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(512) = theta(379)+theta(358)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(513) = theta(384)+theta(358)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(514) = theta(385)+theta(358)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(515) = theta(380)+theta(359)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(516) = theta(385)+theta(359)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(517) = theta(386)+theta(359)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(518) = theta(381)+theta(360)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(519) = theta(386)+theta(360)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(520) = theta(387)+theta(360)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(521) = theta(382)+theta(361)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(522) = theta(388)+theta(361)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(523) = theta(389)+theta(361)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(524) = theta(383)+theta(362)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(525) = theta(389)+theta(362)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(526) = theta(390)+theta(362)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(527) = theta(384)+theta(363)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(528) = theta(390)+theta(363)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(529) = theta(391)+theta(363)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(530) = theta(385)+theta(364)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(531) = theta(391)+theta(364)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(532) = theta(392)+theta(364)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(533) = theta(386)+theta(365)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(534) = theta(392)+theta(365)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(535) = theta(393)+theta(365)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(536) = theta(387)+theta(366)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(537) = theta(393)+theta(366)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(538) = theta(394)+theta(366)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(539) = theta(395)+theta(367)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        ! theta(540) = theta(396)+theta(367)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        ! theta(541) = theta(397)+theta(367)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(542) = theta(396)+theta(368)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(543) = theta(398)+theta(368)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(544) = theta(399)+theta(368)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(545) = theta(397)+theta(369)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(546) = theta(399)+theta(369)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(547) = theta(400)+theta(369)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(548) = theta(398)+theta(370)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(549) = theta(401)+theta(370)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(550) = theta(402)+theta(370)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(551) = theta(399)+theta(371)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(552) = theta(402)+theta(371)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(553) = theta(403)+theta(371)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(554) = theta(400)+theta(372)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(555) = theta(403)+theta(372)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(556) = theta(404)+theta(372)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(557) = theta(401)+theta(373)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(558) = theta(405)+theta(373)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(559) = theta(406)+theta(373)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(560) = theta(402)+theta(374)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(561) = theta(406)+theta(374)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(562) = theta(407)+theta(374)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(563) = theta(403)+theta(375)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(564) = theta(407)+theta(375)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(565) = theta(408)+theta(375)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(566) = theta(404)+theta(376)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(567) = theta(408)+theta(376)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(568) = theta(409)+theta(376)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(569) = theta(405)+theta(377)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(570) = theta(410)+theta(377)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(571) = theta(411)+theta(377)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(572) = theta(406)+theta(378)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(573) = theta(411)+theta(378)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(574) = theta(412)+theta(378)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(575) = theta(407)+theta(379)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(576) = theta(412)+theta(379)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(577) = theta(413)+theta(379)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(578) = theta(408)+theta(380)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(579) = theta(413)+theta(380)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(580) = theta(414)+theta(380)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(581) = theta(409)+theta(381)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(582) = theta(414)+theta(381)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(583) = theta(415)+theta(381)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(584) = theta(410)+theta(382)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(585) = theta(416)+theta(382)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(586) = theta(417)+theta(382)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(587) = theta(411)+theta(383)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(588) = theta(417)+theta(383)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(589) = theta(418)+theta(383)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(590) = theta(412)+theta(384)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(591) = theta(418)+theta(384)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(592) = theta(419)+theta(384)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(593) = theta(413)+theta(385)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(594) = theta(419)+theta(385)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(595) = theta(420)+theta(385)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(596) = theta(414)+theta(386)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(597) = theta(420)+theta(386)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(598) = theta(421)+theta(386)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(599) = theta(415)+theta(387)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        ! theta(600) = theta(421)+theta(387)*AB(2) ! ((1,0,5)|(0,1,0)) = ((1,1,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(2)
        theta(601) = theta(422)+theta(387)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        ! theta(602) = theta(416)+theta(388)*AB(1) ! ((0,6,0)|(1,0,0)) = ((1,6,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(1)
        theta(603) = theta(423)+theta(388)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        ! theta(604) = theta(424)+theta(388)*AB(3) ! ((0,6,0)|(0,0,1)) = ((0,6,1)|(0,0,0))+((0,6,0)|(0,0,0))*AB(3)
        ! theta(605) = theta(417)+theta(389)*AB(1) ! ((0,5,1)|(1,0,0)) = ((1,5,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(1)
        theta(606) = theta(424)+theta(389)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(607) = theta(425)+theta(389)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        ! theta(608) = theta(418)+theta(390)*AB(1) ! ((0,4,2)|(1,0,0)) = ((1,4,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(1)
        theta(609) = theta(425)+theta(390)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(610) = theta(426)+theta(390)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        ! theta(611) = theta(419)+theta(391)*AB(1) ! ((0,3,3)|(1,0,0)) = ((1,3,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(1)
        theta(612) = theta(426)+theta(391)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(613) = theta(427)+theta(391)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        ! theta(614) = theta(420)+theta(392)*AB(1) ! ((0,2,4)|(1,0,0)) = ((1,2,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(1)
        theta(615) = theta(427)+theta(392)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(616) = theta(428)+theta(392)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        ! theta(617) = theta(421)+theta(393)*AB(1) ! ((0,1,5)|(1,0,0)) = ((1,1,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(1)
        theta(618) = theta(428)+theta(393)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(619) = theta(429)+theta(393)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        ! theta(620) = theta(422)+theta(394)*AB(1) ! ((0,0,6)|(1,0,0)) = ((1,0,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(1)
        ! theta(621) = theta(429)+theta(394)*AB(2) ! ((0,0,6)|(0,1,0)) = ((0,1,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(2)
        theta(622) = theta(430)+theta(394)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(623) = theta(476)+theta(431)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        ! theta(624) = theta(477)+theta(432)*AB(1) ! ((4,0,0)|(1,1,0)) = ((5,0,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(1)
        ! theta(625) = theta(478)+theta(433)*AB(1) ! ((4,0,0)|(1,0,1)) = ((5,0,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(1)
        theta(626) = theta(480)+theta(432)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        theta(627) = theta(481)+theta(433)*AB(2) ! ((4,0,0)|(0,1,1)) = ((4,1,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(2)
        theta(628) = theta(484)+theta(433)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(629) = theta(479)+theta(434)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        ! theta(630) = theta(480)+theta(435)*AB(1) ! ((3,1,0)|(1,1,0)) = ((4,1,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(1)
        ! theta(631) = theta(481)+theta(436)*AB(1) ! ((3,1,0)|(1,0,1)) = ((4,1,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(1)
        theta(632) = theta(486)+theta(435)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        theta(633) = theta(487)+theta(436)*AB(2) ! ((3,1,0)|(0,1,1)) = ((3,2,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(2)
        theta(634) = theta(490)+theta(436)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(635) = theta(482)+theta(437)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(636) = theta(483)+theta(438)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        ! theta(637) = theta(484)+theta(439)*AB(1) ! ((3,0,1)|(1,0,1)) = ((4,0,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(1)
        theta(638) = theta(489)+theta(438)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(639) = theta(490)+theta(439)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        theta(640) = theta(493)+theta(439)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(641) = theta(485)+theta(440)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        ! theta(642) = theta(486)+theta(441)*AB(1) ! ((2,2,0)|(1,1,0)) = ((3,2,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(1)
        ! theta(643) = theta(487)+theta(442)*AB(1) ! ((2,2,0)|(1,0,1)) = ((3,2,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(1)
        theta(644) = theta(495)+theta(441)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        theta(645) = theta(496)+theta(442)*AB(2) ! ((2,2,0)|(0,1,1)) = ((2,3,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(2)
        theta(646) = theta(499)+theta(442)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(647) = theta(488)+theta(443)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(648) = theta(489)+theta(444)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        ! theta(649) = theta(490)+theta(445)*AB(1) ! ((2,1,1)|(1,0,1)) = ((3,1,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(1)
        theta(650) = theta(498)+theta(444)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(651) = theta(499)+theta(445)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        theta(652) = theta(502)+theta(445)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(653) = theta(491)+theta(446)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(654) = theta(492)+theta(447)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        ! theta(655) = theta(493)+theta(448)*AB(1) ! ((2,0,2)|(1,0,1)) = ((3,0,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(1)
        theta(656) = theta(501)+theta(447)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(657) = theta(502)+theta(448)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        theta(658) = theta(505)+theta(448)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(659) = theta(494)+theta(449)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        ! theta(660) = theta(495)+theta(450)*AB(1) ! ((1,3,0)|(1,1,0)) = ((2,3,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(1)
        ! theta(661) = theta(496)+theta(451)*AB(1) ! ((1,3,0)|(1,0,1)) = ((2,3,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(1)
        theta(662) = theta(507)+theta(450)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        theta(663) = theta(508)+theta(451)*AB(2) ! ((1,3,0)|(0,1,1)) = ((1,4,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(2)
        theta(664) = theta(511)+theta(451)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(665) = theta(497)+theta(452)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(666) = theta(498)+theta(453)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        ! theta(667) = theta(499)+theta(454)*AB(1) ! ((1,2,1)|(1,0,1)) = ((2,2,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(1)
        theta(668) = theta(510)+theta(453)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(669) = theta(511)+theta(454)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        theta(670) = theta(514)+theta(454)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(671) = theta(500)+theta(455)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(672) = theta(501)+theta(456)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        ! theta(673) = theta(502)+theta(457)*AB(1) ! ((1,1,2)|(1,0,1)) = ((2,1,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(1)
        theta(674) = theta(513)+theta(456)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(675) = theta(514)+theta(457)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        theta(676) = theta(517)+theta(457)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(677) = theta(503)+theta(458)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(678) = theta(504)+theta(459)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        ! theta(679) = theta(505)+theta(460)*AB(1) ! ((1,0,3)|(1,0,1)) = ((2,0,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(1)
        theta(680) = theta(516)+theta(459)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(681) = theta(517)+theta(460)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        theta(682) = theta(520)+theta(460)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(683) = theta(506)+theta(461)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        ! theta(684) = theta(507)+theta(462)*AB(1) ! ((0,4,0)|(1,1,0)) = ((1,4,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(1)
        ! theta(685) = theta(508)+theta(463)*AB(1) ! ((0,4,0)|(1,0,1)) = ((1,4,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(1)
        theta(686) = theta(522)+theta(462)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        theta(687) = theta(523)+theta(463)*AB(2) ! ((0,4,0)|(0,1,1)) = ((0,5,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(2)
        theta(688) = theta(526)+theta(463)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(689) = theta(509)+theta(464)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(690) = theta(510)+theta(465)*AB(1) ! ((0,3,1)|(1,1,0)) = ((1,3,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(1)
        ! theta(691) = theta(511)+theta(466)*AB(1) ! ((0,3,1)|(1,0,1)) = ((1,3,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(1)
        theta(692) = theta(525)+theta(465)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(693) = theta(526)+theta(466)*AB(2) ! ((0,3,1)|(0,1,1)) = ((0,4,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(2)
        theta(694) = theta(529)+theta(466)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(695) = theta(512)+theta(467)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(696) = theta(513)+theta(468)*AB(1) ! ((0,2,2)|(1,1,0)) = ((1,2,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(1)
        ! theta(697) = theta(514)+theta(469)*AB(1) ! ((0,2,2)|(1,0,1)) = ((1,2,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(1)
        theta(698) = theta(528)+theta(468)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(699) = theta(529)+theta(469)*AB(2) ! ((0,2,2)|(0,1,1)) = ((0,3,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(2)
        theta(700) = theta(532)+theta(469)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(701) = theta(515)+theta(470)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(702) = theta(516)+theta(471)*AB(1) ! ((0,1,3)|(1,1,0)) = ((1,1,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(1)
        ! theta(703) = theta(517)+theta(472)*AB(1) ! ((0,1,3)|(1,0,1)) = ((1,1,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(1)
        theta(704) = theta(531)+theta(471)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(705) = theta(532)+theta(472)*AB(2) ! ((0,1,3)|(0,1,1)) = ((0,2,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(2)
        theta(706) = theta(535)+theta(472)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(707) = theta(518)+theta(473)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(708) = theta(519)+theta(474)*AB(1) ! ((0,0,4)|(1,1,0)) = ((1,0,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(1)
        ! theta(709) = theta(520)+theta(475)*AB(1) ! ((0,0,4)|(1,0,1)) = ((1,0,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(1)
        theta(710) = theta(534)+theta(474)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(711) = theta(535)+theta(475)*AB(2) ! ((0,0,4)|(0,1,1)) = ((0,1,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(2)
        theta(712) = theta(538)+theta(475)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(713) = theta(539)+theta(476)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        ! theta(714) = theta(540)+theta(477)*AB(1) ! ((5,0,0)|(1,1,0)) = ((6,0,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(1)
        ! theta(715) = theta(541)+theta(478)*AB(1) ! ((5,0,0)|(1,0,1)) = ((6,0,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(1)
        theta(716) = theta(543)+theta(477)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        theta(717) = theta(544)+theta(478)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        theta(718) = theta(547)+theta(478)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(719) = theta(542)+theta(479)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        ! theta(720) = theta(543)+theta(480)*AB(1) ! ((4,1,0)|(1,1,0)) = ((5,1,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(1)
        ! theta(721) = theta(544)+theta(481)*AB(1) ! ((4,1,0)|(1,0,1)) = ((5,1,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(1)
        theta(722) = theta(549)+theta(480)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(723) = theta(550)+theta(481)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        theta(724) = theta(553)+theta(481)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(725) = theta(545)+theta(482)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(726) = theta(546)+theta(483)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        ! theta(727) = theta(547)+theta(484)*AB(1) ! ((4,0,1)|(1,0,1)) = ((5,0,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(1)
        theta(728) = theta(552)+theta(483)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(729) = theta(553)+theta(484)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(730) = theta(556)+theta(484)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(731) = theta(548)+theta(485)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        ! theta(732) = theta(549)+theta(486)*AB(1) ! ((3,2,0)|(1,1,0)) = ((4,2,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(1)
        ! theta(733) = theta(550)+theta(487)*AB(1) ! ((3,2,0)|(1,0,1)) = ((4,2,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(1)
        theta(734) = theta(558)+theta(486)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(735) = theta(559)+theta(487)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        theta(736) = theta(562)+theta(487)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(737) = theta(551)+theta(488)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(738) = theta(552)+theta(489)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        ! theta(739) = theta(553)+theta(490)*AB(1) ! ((3,1,1)|(1,0,1)) = ((4,1,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(1)
        theta(740) = theta(561)+theta(489)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(741) = theta(562)+theta(490)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(742) = theta(565)+theta(490)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(743) = theta(554)+theta(491)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(744) = theta(555)+theta(492)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        ! theta(745) = theta(556)+theta(493)*AB(1) ! ((3,0,2)|(1,0,1)) = ((4,0,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(1)
        theta(746) = theta(564)+theta(492)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(747) = theta(565)+theta(493)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(748) = theta(568)+theta(493)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(749) = theta(557)+theta(494)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        ! theta(750) = theta(558)+theta(495)*AB(1) ! ((2,3,0)|(1,1,0)) = ((3,3,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(1)
        ! theta(751) = theta(559)+theta(496)*AB(1) ! ((2,3,0)|(1,0,1)) = ((3,3,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(1)
        theta(752) = theta(570)+theta(495)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(753) = theta(571)+theta(496)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        theta(754) = theta(574)+theta(496)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(755) = theta(560)+theta(497)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(756) = theta(561)+theta(498)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        ! theta(757) = theta(562)+theta(499)*AB(1) ! ((2,2,1)|(1,0,1)) = ((3,2,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(1)
        theta(758) = theta(573)+theta(498)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(759) = theta(574)+theta(499)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(760) = theta(577)+theta(499)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(761) = theta(563)+theta(500)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(762) = theta(564)+theta(501)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        ! theta(763) = theta(565)+theta(502)*AB(1) ! ((2,1,2)|(1,0,1)) = ((3,1,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(1)
        theta(764) = theta(576)+theta(501)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(765) = theta(577)+theta(502)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(766) = theta(580)+theta(502)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(767) = theta(566)+theta(503)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(768) = theta(567)+theta(504)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        ! theta(769) = theta(568)+theta(505)*AB(1) ! ((2,0,3)|(1,0,1)) = ((3,0,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(1)
        theta(770) = theta(579)+theta(504)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(771) = theta(580)+theta(505)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(772) = theta(583)+theta(505)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(773) = theta(569)+theta(506)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        ! theta(774) = theta(570)+theta(507)*AB(1) ! ((1,4,0)|(1,1,0)) = ((2,4,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(1)
        ! theta(775) = theta(571)+theta(508)*AB(1) ! ((1,4,0)|(1,0,1)) = ((2,4,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(1)
        theta(776) = theta(585)+theta(507)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(777) = theta(586)+theta(508)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        theta(778) = theta(589)+theta(508)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(779) = theta(572)+theta(509)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(780) = theta(573)+theta(510)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        ! theta(781) = theta(574)+theta(511)*AB(1) ! ((1,3,1)|(1,0,1)) = ((2,3,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(1)
        theta(782) = theta(588)+theta(510)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(783) = theta(589)+theta(511)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(784) = theta(592)+theta(511)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(785) = theta(575)+theta(512)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(786) = theta(576)+theta(513)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        ! theta(787) = theta(577)+theta(514)*AB(1) ! ((1,2,2)|(1,0,1)) = ((2,2,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(1)
        theta(788) = theta(591)+theta(513)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(789) = theta(592)+theta(514)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(790) = theta(595)+theta(514)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(791) = theta(578)+theta(515)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(792) = theta(579)+theta(516)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        ! theta(793) = theta(580)+theta(517)*AB(1) ! ((1,1,3)|(1,0,1)) = ((2,1,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(1)
        theta(794) = theta(594)+theta(516)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(795) = theta(595)+theta(517)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(796) = theta(598)+theta(517)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(797) = theta(581)+theta(518)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(798) = theta(582)+theta(519)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        ! theta(799) = theta(583)+theta(520)*AB(1) ! ((1,0,4)|(1,0,1)) = ((2,0,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(1)
        theta(800) = theta(597)+theta(519)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(801) = theta(598)+theta(520)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(802) = theta(601)+theta(520)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(803) = theta(584)+theta(521)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        ! theta(804) = theta(585)+theta(522)*AB(1) ! ((0,5,0)|(1,1,0)) = ((1,5,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(1)
        ! theta(805) = theta(586)+theta(523)*AB(1) ! ((0,5,0)|(1,0,1)) = ((1,5,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(1)
        theta(806) = theta(603)+theta(522)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        ! theta(807) = theta(604)+theta(523)*AB(2) ! ((0,5,0)|(0,1,1)) = ((0,6,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(2)
        theta(808) = theta(607)+theta(523)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(809) = theta(587)+theta(524)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        ! theta(810) = theta(588)+theta(525)*AB(1) ! ((0,4,1)|(1,1,0)) = ((1,4,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(1)
        ! theta(811) = theta(589)+theta(526)*AB(1) ! ((0,4,1)|(1,0,1)) = ((1,4,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(1)
        theta(812) = theta(606)+theta(525)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        ! theta(813) = theta(607)+theta(526)*AB(2) ! ((0,4,1)|(0,1,1)) = ((0,5,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(2)
        theta(814) = theta(610)+theta(526)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(815) = theta(590)+theta(527)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        ! theta(816) = theta(591)+theta(528)*AB(1) ! ((0,3,2)|(1,1,0)) = ((1,3,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(1)
        ! theta(817) = theta(592)+theta(529)*AB(1) ! ((0,3,2)|(1,0,1)) = ((1,3,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(1)
        theta(818) = theta(609)+theta(528)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        ! theta(819) = theta(610)+theta(529)*AB(2) ! ((0,3,2)|(0,1,1)) = ((0,4,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(2)
        theta(820) = theta(613)+theta(529)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(821) = theta(593)+theta(530)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        ! theta(822) = theta(594)+theta(531)*AB(1) ! ((0,2,3)|(1,1,0)) = ((1,2,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(1)
        ! theta(823) = theta(595)+theta(532)*AB(1) ! ((0,2,3)|(1,0,1)) = ((1,2,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(1)
        theta(824) = theta(612)+theta(531)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        ! theta(825) = theta(613)+theta(532)*AB(2) ! ((0,2,3)|(0,1,1)) = ((0,3,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(2)
        theta(826) = theta(616)+theta(532)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(827) = theta(596)+theta(533)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        ! theta(828) = theta(597)+theta(534)*AB(1) ! ((0,1,4)|(1,1,0)) = ((1,1,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(1)
        ! theta(829) = theta(598)+theta(535)*AB(1) ! ((0,1,4)|(1,0,1)) = ((1,1,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(1)
        theta(830) = theta(615)+theta(534)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        ! theta(831) = theta(616)+theta(535)*AB(2) ! ((0,1,4)|(0,1,1)) = ((0,2,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(2)
        theta(832) = theta(619)+theta(535)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(833) = theta(599)+theta(536)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        ! theta(834) = theta(600)+theta(537)*AB(1) ! ((0,0,5)|(1,1,0)) = ((1,0,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(1)
        ! theta(835) = theta(601)+theta(538)*AB(1) ! ((0,0,5)|(1,0,1)) = ((1,0,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(1)
        theta(836) = theta(618)+theta(537)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        ! theta(837) = theta(619)+theta(538)*AB(2) ! ((0,0,5)|(0,1,1)) = ((0,1,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(2)
        theta(838) = theta(622)+theta(538)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(839) = theta(713)+theta(623)*AB(1) ! ((4,0,0)|(3,0,0)) = ((5,0,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(1)
        theta(840) = theta(719)+theta(623)*AB(2) ! ((4,0,0)|(2,1,0)) = ((4,1,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(2)
        theta(841) = theta(725)+theta(623)*AB(3) ! ((4,0,0)|(2,0,1)) = ((4,0,1)|(2,0,0))+((4,0,0)|(2,0,0))*AB(3)
        theta(842) = theta(716)+theta(626)*AB(1) ! ((4,0,0)|(1,2,0)) = ((5,0,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(1)
        theta(843) = theta(717)+theta(627)*AB(1) ! ((4,0,0)|(1,1,1)) = ((5,0,0)|(0,1,1))+((4,0,0)|(0,1,1))*AB(1)
        theta(844) = theta(718)+theta(628)*AB(1) ! ((4,0,0)|(1,0,2)) = ((5,0,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(1)
        theta(845) = theta(722)+theta(626)*AB(2) ! ((4,0,0)|(0,3,0)) = ((4,1,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(2)
        theta(846) = theta(728)+theta(626)*AB(3) ! ((4,0,0)|(0,2,1)) = ((4,0,1)|(0,2,0))+((4,0,0)|(0,2,0))*AB(3)
        theta(847) = theta(724)+theta(628)*AB(2) ! ((4,0,0)|(0,1,2)) = ((4,1,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(2)
        theta(848) = theta(730)+theta(628)*AB(3) ! ((4,0,0)|(0,0,3)) = ((4,0,1)|(0,0,2))+((4,0,0)|(0,0,2))*AB(3)
        theta(849) = theta(719)+theta(629)*AB(1) ! ((3,1,0)|(3,0,0)) = ((4,1,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(1)
        theta(850) = theta(731)+theta(629)*AB(2) ! ((3,1,0)|(2,1,0)) = ((3,2,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(2)
        theta(851) = theta(737)+theta(629)*AB(3) ! ((3,1,0)|(2,0,1)) = ((3,1,1)|(2,0,0))+((3,1,0)|(2,0,0))*AB(3)
        theta(852) = theta(722)+theta(632)*AB(1) ! ((3,1,0)|(1,2,0)) = ((4,1,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(1)
        theta(853) = theta(723)+theta(633)*AB(1) ! ((3,1,0)|(1,1,1)) = ((4,1,0)|(0,1,1))+((3,1,0)|(0,1,1))*AB(1)
        theta(854) = theta(724)+theta(634)*AB(1) ! ((3,1,0)|(1,0,2)) = ((4,1,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(1)
        theta(855) = theta(734)+theta(632)*AB(2) ! ((3,1,0)|(0,3,0)) = ((3,2,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(2)
        theta(856) = theta(740)+theta(632)*AB(3) ! ((3,1,0)|(0,2,1)) = ((3,1,1)|(0,2,0))+((3,1,0)|(0,2,0))*AB(3)
        theta(857) = theta(736)+theta(634)*AB(2) ! ((3,1,0)|(0,1,2)) = ((3,2,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(2)
        theta(858) = theta(742)+theta(634)*AB(3) ! ((3,1,0)|(0,0,3)) = ((3,1,1)|(0,0,2))+((3,1,0)|(0,0,2))*AB(3)
        theta(859) = theta(725)+theta(635)*AB(1) ! ((3,0,1)|(3,0,0)) = ((4,0,1)|(2,0,0))+((3,0,1)|(2,0,0))*AB(1)
        theta(860) = theta(726)+theta(636)*AB(1) ! ((3,0,1)|(2,1,0)) = ((4,0,1)|(1,1,0))+((3,0,1)|(1,1,0))*AB(1)
        theta(861) = theta(743)+theta(635)*AB(3) ! ((3,0,1)|(2,0,1)) = ((3,0,2)|(2,0,0))+((3,0,1)|(2,0,0))*AB(3)
        theta(862) = theta(728)+theta(638)*AB(1) ! ((3,0,1)|(1,2,0)) = ((4,0,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(1)
        theta(863) = theta(729)+theta(639)*AB(1) ! ((3,0,1)|(1,1,1)) = ((4,0,1)|(0,1,1))+((3,0,1)|(0,1,1))*AB(1)
        theta(864) = theta(730)+theta(640)*AB(1) ! ((3,0,1)|(1,0,2)) = ((4,0,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(1)
        theta(865) = theta(740)+theta(638)*AB(2) ! ((3,0,1)|(0,3,0)) = ((3,1,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(2)
        theta(866) = theta(746)+theta(638)*AB(3) ! ((3,0,1)|(0,2,1)) = ((3,0,2)|(0,2,0))+((3,0,1)|(0,2,0))*AB(3)
        theta(867) = theta(742)+theta(640)*AB(2) ! ((3,0,1)|(0,1,2)) = ((3,1,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(2)
        theta(868) = theta(748)+theta(640)*AB(3) ! ((3,0,1)|(0,0,3)) = ((3,0,2)|(0,0,2))+((3,0,1)|(0,0,2))*AB(3)
        theta(869) = theta(731)+theta(641)*AB(1) ! ((2,2,0)|(3,0,0)) = ((3,2,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(1)
        theta(870) = theta(749)+theta(641)*AB(2) ! ((2,2,0)|(2,1,0)) = ((2,3,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(2)
        theta(871) = theta(755)+theta(641)*AB(3) ! ((2,2,0)|(2,0,1)) = ((2,2,1)|(2,0,0))+((2,2,0)|(2,0,0))*AB(3)
        theta(872) = theta(734)+theta(644)*AB(1) ! ((2,2,0)|(1,2,0)) = ((3,2,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(1)
        theta(873) = theta(735)+theta(645)*AB(1) ! ((2,2,0)|(1,1,1)) = ((3,2,0)|(0,1,1))+((2,2,0)|(0,1,1))*AB(1)
        theta(874) = theta(736)+theta(646)*AB(1) ! ((2,2,0)|(1,0,2)) = ((3,2,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(1)
        theta(875) = theta(752)+theta(644)*AB(2) ! ((2,2,0)|(0,3,0)) = ((2,3,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(2)
        theta(876) = theta(758)+theta(644)*AB(3) ! ((2,2,0)|(0,2,1)) = ((2,2,1)|(0,2,0))+((2,2,0)|(0,2,0))*AB(3)
        theta(877) = theta(754)+theta(646)*AB(2) ! ((2,2,0)|(0,1,2)) = ((2,3,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(2)
        theta(878) = theta(760)+theta(646)*AB(3) ! ((2,2,0)|(0,0,3)) = ((2,2,1)|(0,0,2))+((2,2,0)|(0,0,2))*AB(3)
        theta(879) = theta(737)+theta(647)*AB(1) ! ((2,1,1)|(3,0,0)) = ((3,1,1)|(2,0,0))+((2,1,1)|(2,0,0))*AB(1)
        theta(880) = theta(738)+theta(648)*AB(1) ! ((2,1,1)|(2,1,0)) = ((3,1,1)|(1,1,0))+((2,1,1)|(1,1,0))*AB(1)
        theta(881) = theta(761)+theta(647)*AB(3) ! ((2,1,1)|(2,0,1)) = ((2,1,2)|(2,0,0))+((2,1,1)|(2,0,0))*AB(3)
        theta(882) = theta(740)+theta(650)*AB(1) ! ((2,1,1)|(1,2,0)) = ((3,1,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(1)
        theta(883) = theta(741)+theta(651)*AB(1) ! ((2,1,1)|(1,1,1)) = ((3,1,1)|(0,1,1))+((2,1,1)|(0,1,1))*AB(1)
        theta(884) = theta(742)+theta(652)*AB(1) ! ((2,1,1)|(1,0,2)) = ((3,1,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(1)
        theta(885) = theta(758)+theta(650)*AB(2) ! ((2,1,1)|(0,3,0)) = ((2,2,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(2)
        theta(886) = theta(764)+theta(650)*AB(3) ! ((2,1,1)|(0,2,1)) = ((2,1,2)|(0,2,0))+((2,1,1)|(0,2,0))*AB(3)
        theta(887) = theta(760)+theta(652)*AB(2) ! ((2,1,1)|(0,1,2)) = ((2,2,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(2)
        theta(888) = theta(766)+theta(652)*AB(3) ! ((2,1,1)|(0,0,3)) = ((2,1,2)|(0,0,2))+((2,1,1)|(0,0,2))*AB(3)
        theta(889) = theta(743)+theta(653)*AB(1) ! ((2,0,2)|(3,0,0)) = ((3,0,2)|(2,0,0))+((2,0,2)|(2,0,0))*AB(1)
        theta(890) = theta(744)+theta(654)*AB(1) ! ((2,0,2)|(2,1,0)) = ((3,0,2)|(1,1,0))+((2,0,2)|(1,1,0))*AB(1)
        theta(891) = theta(767)+theta(653)*AB(3) ! ((2,0,2)|(2,0,1)) = ((2,0,3)|(2,0,0))+((2,0,2)|(2,0,0))*AB(3)
        theta(892) = theta(746)+theta(656)*AB(1) ! ((2,0,2)|(1,2,0)) = ((3,0,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(1)
        theta(893) = theta(747)+theta(657)*AB(1) ! ((2,0,2)|(1,1,1)) = ((3,0,2)|(0,1,1))+((2,0,2)|(0,1,1))*AB(1)
        theta(894) = theta(748)+theta(658)*AB(1) ! ((2,0,2)|(1,0,2)) = ((3,0,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(1)
        theta(895) = theta(764)+theta(656)*AB(2) ! ((2,0,2)|(0,3,0)) = ((2,1,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(2)
        theta(896) = theta(770)+theta(656)*AB(3) ! ((2,0,2)|(0,2,1)) = ((2,0,3)|(0,2,0))+((2,0,2)|(0,2,0))*AB(3)
        theta(897) = theta(766)+theta(658)*AB(2) ! ((2,0,2)|(0,1,2)) = ((2,1,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(2)
        theta(898) = theta(772)+theta(658)*AB(3) ! ((2,0,2)|(0,0,3)) = ((2,0,3)|(0,0,2))+((2,0,2)|(0,0,2))*AB(3)
        theta(899) = theta(749)+theta(659)*AB(1) ! ((1,3,0)|(3,0,0)) = ((2,3,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(1)
        theta(900) = theta(773)+theta(659)*AB(2) ! ((1,3,0)|(2,1,0)) = ((1,4,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(2)
        theta(901) = theta(779)+theta(659)*AB(3) ! ((1,3,0)|(2,0,1)) = ((1,3,1)|(2,0,0))+((1,3,0)|(2,0,0))*AB(3)
        theta(902) = theta(752)+theta(662)*AB(1) ! ((1,3,0)|(1,2,0)) = ((2,3,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(1)
        theta(903) = theta(753)+theta(663)*AB(1) ! ((1,3,0)|(1,1,1)) = ((2,3,0)|(0,1,1))+((1,3,0)|(0,1,1))*AB(1)
        theta(904) = theta(754)+theta(664)*AB(1) ! ((1,3,0)|(1,0,2)) = ((2,3,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(1)
        theta(905) = theta(776)+theta(662)*AB(2) ! ((1,3,0)|(0,3,0)) = ((1,4,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(2)
        theta(906) = theta(782)+theta(662)*AB(3) ! ((1,3,0)|(0,2,1)) = ((1,3,1)|(0,2,0))+((1,3,0)|(0,2,0))*AB(3)
        theta(907) = theta(778)+theta(664)*AB(2) ! ((1,3,0)|(0,1,2)) = ((1,4,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(2)
        theta(908) = theta(784)+theta(664)*AB(3) ! ((1,3,0)|(0,0,3)) = ((1,3,1)|(0,0,2))+((1,3,0)|(0,0,2))*AB(3)
        theta(909) = theta(755)+theta(665)*AB(1) ! ((1,2,1)|(3,0,0)) = ((2,2,1)|(2,0,0))+((1,2,1)|(2,0,0))*AB(1)
        theta(910) = theta(756)+theta(666)*AB(1) ! ((1,2,1)|(2,1,0)) = ((2,2,1)|(1,1,0))+((1,2,1)|(1,1,0))*AB(1)
        theta(911) = theta(785)+theta(665)*AB(3) ! ((1,2,1)|(2,0,1)) = ((1,2,2)|(2,0,0))+((1,2,1)|(2,0,0))*AB(3)
        theta(912) = theta(758)+theta(668)*AB(1) ! ((1,2,1)|(1,2,0)) = ((2,2,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(1)
        theta(913) = theta(759)+theta(669)*AB(1) ! ((1,2,1)|(1,1,1)) = ((2,2,1)|(0,1,1))+((1,2,1)|(0,1,1))*AB(1)
        theta(914) = theta(760)+theta(670)*AB(1) ! ((1,2,1)|(1,0,2)) = ((2,2,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(1)
        theta(915) = theta(782)+theta(668)*AB(2) ! ((1,2,1)|(0,3,0)) = ((1,3,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(2)
        theta(916) = theta(788)+theta(668)*AB(3) ! ((1,2,1)|(0,2,1)) = ((1,2,2)|(0,2,0))+((1,2,1)|(0,2,0))*AB(3)
        theta(917) = theta(784)+theta(670)*AB(2) ! ((1,2,1)|(0,1,2)) = ((1,3,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(2)
        theta(918) = theta(790)+theta(670)*AB(3) ! ((1,2,1)|(0,0,3)) = ((1,2,2)|(0,0,2))+((1,2,1)|(0,0,2))*AB(3)
        theta(919) = theta(761)+theta(671)*AB(1) ! ((1,1,2)|(3,0,0)) = ((2,1,2)|(2,0,0))+((1,1,2)|(2,0,0))*AB(1)
        theta(920) = theta(762)+theta(672)*AB(1) ! ((1,1,2)|(2,1,0)) = ((2,1,2)|(1,1,0))+((1,1,2)|(1,1,0))*AB(1)
        theta(921) = theta(791)+theta(671)*AB(3) ! ((1,1,2)|(2,0,1)) = ((1,1,3)|(2,0,0))+((1,1,2)|(2,0,0))*AB(3)
        theta(922) = theta(764)+theta(674)*AB(1) ! ((1,1,2)|(1,2,0)) = ((2,1,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(1)
        theta(923) = theta(765)+theta(675)*AB(1) ! ((1,1,2)|(1,1,1)) = ((2,1,2)|(0,1,1))+((1,1,2)|(0,1,1))*AB(1)
        theta(924) = theta(766)+theta(676)*AB(1) ! ((1,1,2)|(1,0,2)) = ((2,1,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(1)
        theta(925) = theta(788)+theta(674)*AB(2) ! ((1,1,2)|(0,3,0)) = ((1,2,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(2)
        theta(926) = theta(794)+theta(674)*AB(3) ! ((1,1,2)|(0,2,1)) = ((1,1,3)|(0,2,0))+((1,1,2)|(0,2,0))*AB(3)
        theta(927) = theta(790)+theta(676)*AB(2) ! ((1,1,2)|(0,1,2)) = ((1,2,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(2)
        theta(928) = theta(796)+theta(676)*AB(3) ! ((1,1,2)|(0,0,3)) = ((1,1,3)|(0,0,2))+((1,1,2)|(0,0,2))*AB(3)
        theta(929) = theta(767)+theta(677)*AB(1) ! ((1,0,3)|(3,0,0)) = ((2,0,3)|(2,0,0))+((1,0,3)|(2,0,0))*AB(1)
        theta(930) = theta(768)+theta(678)*AB(1) ! ((1,0,3)|(2,1,0)) = ((2,0,3)|(1,1,0))+((1,0,3)|(1,1,0))*AB(1)
        theta(931) = theta(797)+theta(677)*AB(3) ! ((1,0,3)|(2,0,1)) = ((1,0,4)|(2,0,0))+((1,0,3)|(2,0,0))*AB(3)
        theta(932) = theta(770)+theta(680)*AB(1) ! ((1,0,3)|(1,2,0)) = ((2,0,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(1)
        theta(933) = theta(771)+theta(681)*AB(1) ! ((1,0,3)|(1,1,1)) = ((2,0,3)|(0,1,1))+((1,0,3)|(0,1,1))*AB(1)
        theta(934) = theta(772)+theta(682)*AB(1) ! ((1,0,3)|(1,0,2)) = ((2,0,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(1)
        theta(935) = theta(794)+theta(680)*AB(2) ! ((1,0,3)|(0,3,0)) = ((1,1,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(2)
        theta(936) = theta(800)+theta(680)*AB(3) ! ((1,0,3)|(0,2,1)) = ((1,0,4)|(0,2,0))+((1,0,3)|(0,2,0))*AB(3)
        theta(937) = theta(796)+theta(682)*AB(2) ! ((1,0,3)|(0,1,2)) = ((1,1,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(2)
        theta(938) = theta(802)+theta(682)*AB(3) ! ((1,0,3)|(0,0,3)) = ((1,0,4)|(0,0,2))+((1,0,3)|(0,0,2))*AB(3)
        theta(939) = theta(773)+theta(683)*AB(1) ! ((0,4,0)|(3,0,0)) = ((1,4,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(1)
        theta(940) = theta(803)+theta(683)*AB(2) ! ((0,4,0)|(2,1,0)) = ((0,5,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(2)
        theta(941) = theta(809)+theta(683)*AB(3) ! ((0,4,0)|(2,0,1)) = ((0,4,1)|(2,0,0))+((0,4,0)|(2,0,0))*AB(3)
        theta(942) = theta(776)+theta(686)*AB(1) ! ((0,4,0)|(1,2,0)) = ((1,4,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(1)
        theta(943) = theta(777)+theta(687)*AB(1) ! ((0,4,0)|(1,1,1)) = ((1,4,0)|(0,1,1))+((0,4,0)|(0,1,1))*AB(1)
        theta(944) = theta(778)+theta(688)*AB(1) ! ((0,4,0)|(1,0,2)) = ((1,4,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(1)
        theta(945) = theta(806)+theta(686)*AB(2) ! ((0,4,0)|(0,3,0)) = ((0,5,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(2)
        theta(946) = theta(812)+theta(686)*AB(3) ! ((0,4,0)|(0,2,1)) = ((0,4,1)|(0,2,0))+((0,4,0)|(0,2,0))*AB(3)
        theta(947) = theta(808)+theta(688)*AB(2) ! ((0,4,0)|(0,1,2)) = ((0,5,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(2)
        theta(948) = theta(814)+theta(688)*AB(3) ! ((0,4,0)|(0,0,3)) = ((0,4,1)|(0,0,2))+((0,4,0)|(0,0,2))*AB(3)
        theta(949) = theta(779)+theta(689)*AB(1) ! ((0,3,1)|(3,0,0)) = ((1,3,1)|(2,0,0))+((0,3,1)|(2,0,0))*AB(1)
        theta(950) = theta(780)+theta(690)*AB(1) ! ((0,3,1)|(2,1,0)) = ((1,3,1)|(1,1,0))+((0,3,1)|(1,1,0))*AB(1)
        theta(951) = theta(815)+theta(689)*AB(3) ! ((0,3,1)|(2,0,1)) = ((0,3,2)|(2,0,0))+((0,3,1)|(2,0,0))*AB(3)
        theta(952) = theta(782)+theta(692)*AB(1) ! ((0,3,1)|(1,2,0)) = ((1,3,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(1)
        theta(953) = theta(783)+theta(693)*AB(1) ! ((0,3,1)|(1,1,1)) = ((1,3,1)|(0,1,1))+((0,3,1)|(0,1,1))*AB(1)
        theta(954) = theta(784)+theta(694)*AB(1) ! ((0,3,1)|(1,0,2)) = ((1,3,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(1)
        theta(955) = theta(812)+theta(692)*AB(2) ! ((0,3,1)|(0,3,0)) = ((0,4,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(2)
        theta(956) = theta(818)+theta(692)*AB(3) ! ((0,3,1)|(0,2,1)) = ((0,3,2)|(0,2,0))+((0,3,1)|(0,2,0))*AB(3)
        theta(957) = theta(814)+theta(694)*AB(2) ! ((0,3,1)|(0,1,2)) = ((0,4,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(2)
        theta(958) = theta(820)+theta(694)*AB(3) ! ((0,3,1)|(0,0,3)) = ((0,3,2)|(0,0,2))+((0,3,1)|(0,0,2))*AB(3)
        theta(959) = theta(785)+theta(695)*AB(1) ! ((0,2,2)|(3,0,0)) = ((1,2,2)|(2,0,0))+((0,2,2)|(2,0,0))*AB(1)
        theta(960) = theta(786)+theta(696)*AB(1) ! ((0,2,2)|(2,1,0)) = ((1,2,2)|(1,1,0))+((0,2,2)|(1,1,0))*AB(1)
        theta(961) = theta(821)+theta(695)*AB(3) ! ((0,2,2)|(2,0,1)) = ((0,2,3)|(2,0,0))+((0,2,2)|(2,0,0))*AB(3)
        theta(962) = theta(788)+theta(698)*AB(1) ! ((0,2,2)|(1,2,0)) = ((1,2,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(1)
        theta(963) = theta(789)+theta(699)*AB(1) ! ((0,2,2)|(1,1,1)) = ((1,2,2)|(0,1,1))+((0,2,2)|(0,1,1))*AB(1)
        theta(964) = theta(790)+theta(700)*AB(1) ! ((0,2,2)|(1,0,2)) = ((1,2,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(1)
        theta(965) = theta(818)+theta(698)*AB(2) ! ((0,2,2)|(0,3,0)) = ((0,3,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(2)
        theta(966) = theta(824)+theta(698)*AB(3) ! ((0,2,2)|(0,2,1)) = ((0,2,3)|(0,2,0))+((0,2,2)|(0,2,0))*AB(3)
        theta(967) = theta(820)+theta(700)*AB(2) ! ((0,2,2)|(0,1,2)) = ((0,3,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(2)
        theta(968) = theta(826)+theta(700)*AB(3) ! ((0,2,2)|(0,0,3)) = ((0,2,3)|(0,0,2))+((0,2,2)|(0,0,2))*AB(3)
        theta(969) = theta(791)+theta(701)*AB(1) ! ((0,1,3)|(3,0,0)) = ((1,1,3)|(2,0,0))+((0,1,3)|(2,0,0))*AB(1)
        theta(970) = theta(792)+theta(702)*AB(1) ! ((0,1,3)|(2,1,0)) = ((1,1,3)|(1,1,0))+((0,1,3)|(1,1,0))*AB(1)
        theta(971) = theta(827)+theta(701)*AB(3) ! ((0,1,3)|(2,0,1)) = ((0,1,4)|(2,0,0))+((0,1,3)|(2,0,0))*AB(3)
        theta(972) = theta(794)+theta(704)*AB(1) ! ((0,1,3)|(1,2,0)) = ((1,1,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(1)
        theta(973) = theta(795)+theta(705)*AB(1) ! ((0,1,3)|(1,1,1)) = ((1,1,3)|(0,1,1))+((0,1,3)|(0,1,1))*AB(1)
        theta(974) = theta(796)+theta(706)*AB(1) ! ((0,1,3)|(1,0,2)) = ((1,1,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(1)
        theta(975) = theta(824)+theta(704)*AB(2) ! ((0,1,3)|(0,3,0)) = ((0,2,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(2)
        theta(976) = theta(830)+theta(704)*AB(3) ! ((0,1,3)|(0,2,1)) = ((0,1,4)|(0,2,0))+((0,1,3)|(0,2,0))*AB(3)
        theta(977) = theta(826)+theta(706)*AB(2) ! ((0,1,3)|(0,1,2)) = ((0,2,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(2)
        theta(978) = theta(832)+theta(706)*AB(3) ! ((0,1,3)|(0,0,3)) = ((0,1,4)|(0,0,2))+((0,1,3)|(0,0,2))*AB(3)
        theta(979) = theta(797)+theta(707)*AB(1) ! ((0,0,4)|(3,0,0)) = ((1,0,4)|(2,0,0))+((0,0,4)|(2,0,0))*AB(1)
        theta(980) = theta(798)+theta(708)*AB(1) ! ((0,0,4)|(2,1,0)) = ((1,0,4)|(1,1,0))+((0,0,4)|(1,1,0))*AB(1)
        theta(981) = theta(833)+theta(707)*AB(3) ! ((0,0,4)|(2,0,1)) = ((0,0,5)|(2,0,0))+((0,0,4)|(2,0,0))*AB(3)
        theta(982) = theta(800)+theta(710)*AB(1) ! ((0,0,4)|(1,2,0)) = ((1,0,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(1)
        theta(983) = theta(801)+theta(711)*AB(1) ! ((0,0,4)|(1,1,1)) = ((1,0,4)|(0,1,1))+((0,0,4)|(0,1,1))*AB(1)
        theta(984) = theta(802)+theta(712)*AB(1) ! ((0,0,4)|(1,0,2)) = ((1,0,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(1)
        theta(985) = theta(830)+theta(710)*AB(2) ! ((0,0,4)|(0,3,0)) = ((0,1,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(2)
        theta(986) = theta(836)+theta(710)*AB(3) ! ((0,0,4)|(0,2,1)) = ((0,0,5)|(0,2,0))+((0,0,4)|(0,2,0))*AB(3)
        theta(987) = theta(832)+theta(712)*AB(2) ! ((0,0,4)|(0,1,2)) = ((0,1,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(2)
        theta(988) = theta(838)+theta(712)*AB(3) ! ((0,0,4)|(0,0,3)) = ((0,0,5)|(0,0,2))+((0,0,4)|(0,0,2))*AB(3)
    end subroutine
    subroutine hrr_4_4(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 1414; Optimized integrals: 1164
        theta(641) = theta(511)+theta(496)*AB(1) ! ((4,0,0)|(1,0,0)) = ((5,0,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(1)
        theta(642) = theta(512)+theta(496)*AB(2) ! ((4,0,0)|(0,1,0)) = ((4,1,0)|(0,0,0))+((4,0,0)|(0,0,0))*AB(2)
        theta(643) = theta(513)+theta(496)*AB(3) ! ((4,0,0)|(0,0,1)) = ((4,0,1)|(0,0,0))+((4,0,0)|(0,0,0))*AB(3)
        theta(644) = theta(512)+theta(497)*AB(1) ! ((3,1,0)|(1,0,0)) = ((4,1,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(1)
        theta(645) = theta(514)+theta(497)*AB(2) ! ((3,1,0)|(0,1,0)) = ((3,2,0)|(0,0,0))+((3,1,0)|(0,0,0))*AB(2)
        theta(646) = theta(515)+theta(497)*AB(3) ! ((3,1,0)|(0,0,1)) = ((3,1,1)|(0,0,0))+((3,1,0)|(0,0,0))*AB(3)
        theta(647) = theta(513)+theta(498)*AB(1) ! ((3,0,1)|(1,0,0)) = ((4,0,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(1)
        theta(648) = theta(515)+theta(498)*AB(2) ! ((3,0,1)|(0,1,0)) = ((3,1,1)|(0,0,0))+((3,0,1)|(0,0,0))*AB(2)
        theta(649) = theta(516)+theta(498)*AB(3) ! ((3,0,1)|(0,0,1)) = ((3,0,2)|(0,0,0))+((3,0,1)|(0,0,0))*AB(3)
        theta(650) = theta(514)+theta(499)*AB(1) ! ((2,2,0)|(1,0,0)) = ((3,2,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(1)
        theta(651) = theta(517)+theta(499)*AB(2) ! ((2,2,0)|(0,1,0)) = ((2,3,0)|(0,0,0))+((2,2,0)|(0,0,0))*AB(2)
        theta(652) = theta(518)+theta(499)*AB(3) ! ((2,2,0)|(0,0,1)) = ((2,2,1)|(0,0,0))+((2,2,0)|(0,0,0))*AB(3)
        theta(653) = theta(515)+theta(500)*AB(1) ! ((2,1,1)|(1,0,0)) = ((3,1,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(1)
        theta(654) = theta(518)+theta(500)*AB(2) ! ((2,1,1)|(0,1,0)) = ((2,2,1)|(0,0,0))+((2,1,1)|(0,0,0))*AB(2)
        theta(655) = theta(519)+theta(500)*AB(3) ! ((2,1,1)|(0,0,1)) = ((2,1,2)|(0,0,0))+((2,1,1)|(0,0,0))*AB(3)
        theta(656) = theta(516)+theta(501)*AB(1) ! ((2,0,2)|(1,0,0)) = ((3,0,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(1)
        theta(657) = theta(519)+theta(501)*AB(2) ! ((2,0,2)|(0,1,0)) = ((2,1,2)|(0,0,0))+((2,0,2)|(0,0,0))*AB(2)
        theta(658) = theta(520)+theta(501)*AB(3) ! ((2,0,2)|(0,0,1)) = ((2,0,3)|(0,0,0))+((2,0,2)|(0,0,0))*AB(3)
        theta(659) = theta(517)+theta(502)*AB(1) ! ((1,3,0)|(1,0,0)) = ((2,3,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(1)
        theta(660) = theta(521)+theta(502)*AB(2) ! ((1,3,0)|(0,1,0)) = ((1,4,0)|(0,0,0))+((1,3,0)|(0,0,0))*AB(2)
        theta(661) = theta(522)+theta(502)*AB(3) ! ((1,3,0)|(0,0,1)) = ((1,3,1)|(0,0,0))+((1,3,0)|(0,0,0))*AB(3)
        theta(662) = theta(518)+theta(503)*AB(1) ! ((1,2,1)|(1,0,0)) = ((2,2,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(1)
        theta(663) = theta(522)+theta(503)*AB(2) ! ((1,2,1)|(0,1,0)) = ((1,3,1)|(0,0,0))+((1,2,1)|(0,0,0))*AB(2)
        theta(664) = theta(523)+theta(503)*AB(3) ! ((1,2,1)|(0,0,1)) = ((1,2,2)|(0,0,0))+((1,2,1)|(0,0,0))*AB(3)
        theta(665) = theta(519)+theta(504)*AB(1) ! ((1,1,2)|(1,0,0)) = ((2,1,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(1)
        theta(666) = theta(523)+theta(504)*AB(2) ! ((1,1,2)|(0,1,0)) = ((1,2,2)|(0,0,0))+((1,1,2)|(0,0,0))*AB(2)
        theta(667) = theta(524)+theta(504)*AB(3) ! ((1,1,2)|(0,0,1)) = ((1,1,3)|(0,0,0))+((1,1,2)|(0,0,0))*AB(3)
        theta(668) = theta(520)+theta(505)*AB(1) ! ((1,0,3)|(1,0,0)) = ((2,0,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(1)
        theta(669) = theta(524)+theta(505)*AB(2) ! ((1,0,3)|(0,1,0)) = ((1,1,3)|(0,0,0))+((1,0,3)|(0,0,0))*AB(2)
        theta(670) = theta(525)+theta(505)*AB(3) ! ((1,0,3)|(0,0,1)) = ((1,0,4)|(0,0,0))+((1,0,3)|(0,0,0))*AB(3)
        theta(671) = theta(521)+theta(506)*AB(1) ! ((0,4,0)|(1,0,0)) = ((1,4,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(1)
        theta(672) = theta(526)+theta(506)*AB(2) ! ((0,4,0)|(0,1,0)) = ((0,5,0)|(0,0,0))+((0,4,0)|(0,0,0))*AB(2)
        theta(673) = theta(527)+theta(506)*AB(3) ! ((0,4,0)|(0,0,1)) = ((0,4,1)|(0,0,0))+((0,4,0)|(0,0,0))*AB(3)
        theta(674) = theta(522)+theta(507)*AB(1) ! ((0,3,1)|(1,0,0)) = ((1,3,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(1)
        theta(675) = theta(527)+theta(507)*AB(2) ! ((0,3,1)|(0,1,0)) = ((0,4,1)|(0,0,0))+((0,3,1)|(0,0,0))*AB(2)
        theta(676) = theta(528)+theta(507)*AB(3) ! ((0,3,1)|(0,0,1)) = ((0,3,2)|(0,0,0))+((0,3,1)|(0,0,0))*AB(3)
        theta(677) = theta(523)+theta(508)*AB(1) ! ((0,2,2)|(1,0,0)) = ((1,2,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(1)
        theta(678) = theta(528)+theta(508)*AB(2) ! ((0,2,2)|(0,1,0)) = ((0,3,2)|(0,0,0))+((0,2,2)|(0,0,0))*AB(2)
        theta(679) = theta(529)+theta(508)*AB(3) ! ((0,2,2)|(0,0,1)) = ((0,2,3)|(0,0,0))+((0,2,2)|(0,0,0))*AB(3)
        theta(680) = theta(524)+theta(509)*AB(1) ! ((0,1,3)|(1,0,0)) = ((1,1,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(1)
        theta(681) = theta(529)+theta(509)*AB(2) ! ((0,1,3)|(0,1,0)) = ((0,2,3)|(0,0,0))+((0,1,3)|(0,0,0))*AB(2)
        theta(682) = theta(530)+theta(509)*AB(3) ! ((0,1,3)|(0,0,1)) = ((0,1,4)|(0,0,0))+((0,1,3)|(0,0,0))*AB(3)
        theta(683) = theta(525)+theta(510)*AB(1) ! ((0,0,4)|(1,0,0)) = ((1,0,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(1)
        theta(684) = theta(530)+theta(510)*AB(2) ! ((0,0,4)|(0,1,0)) = ((0,1,4)|(0,0,0))+((0,0,4)|(0,0,0))*AB(2)
        theta(685) = theta(531)+theta(510)*AB(3) ! ((0,0,4)|(0,0,1)) = ((0,0,5)|(0,0,0))+((0,0,4)|(0,0,0))*AB(3)
        theta(686) = theta(532)+theta(511)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(687) = theta(533)+theta(511)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(688) = theta(534)+theta(511)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(689) = theta(533)+theta(512)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(690) = theta(535)+theta(512)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(691) = theta(536)+theta(512)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(692) = theta(534)+theta(513)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(693) = theta(536)+theta(513)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(694) = theta(537)+theta(513)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(695) = theta(535)+theta(514)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(696) = theta(538)+theta(514)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(697) = theta(539)+theta(514)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(698) = theta(536)+theta(515)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(699) = theta(539)+theta(515)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(700) = theta(540)+theta(515)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(701) = theta(537)+theta(516)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(702) = theta(540)+theta(516)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(703) = theta(541)+theta(516)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(704) = theta(538)+theta(517)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(705) = theta(542)+theta(517)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(706) = theta(543)+theta(517)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(707) = theta(539)+theta(518)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(708) = theta(543)+theta(518)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(709) = theta(544)+theta(518)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(710) = theta(540)+theta(519)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(711) = theta(544)+theta(519)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(712) = theta(545)+theta(519)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(713) = theta(541)+theta(520)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(714) = theta(545)+theta(520)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(715) = theta(546)+theta(520)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(716) = theta(542)+theta(521)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(717) = theta(547)+theta(521)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(718) = theta(548)+theta(521)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(719) = theta(543)+theta(522)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(720) = theta(548)+theta(522)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(721) = theta(549)+theta(522)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(722) = theta(544)+theta(523)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(723) = theta(549)+theta(523)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(724) = theta(550)+theta(523)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(725) = theta(545)+theta(524)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(726) = theta(550)+theta(524)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(727) = theta(551)+theta(524)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(728) = theta(546)+theta(525)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(729) = theta(551)+theta(525)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(730) = theta(552)+theta(525)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(731) = theta(547)+theta(526)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(732) = theta(553)+theta(526)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(733) = theta(554)+theta(526)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(734) = theta(548)+theta(527)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(735) = theta(554)+theta(527)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(736) = theta(555)+theta(527)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(737) = theta(549)+theta(528)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(738) = theta(555)+theta(528)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(739) = theta(556)+theta(528)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(740) = theta(550)+theta(529)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(741) = theta(556)+theta(529)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(742) = theta(557)+theta(529)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(743) = theta(551)+theta(530)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(744) = theta(557)+theta(530)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(745) = theta(558)+theta(530)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(746) = theta(552)+theta(531)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(747) = theta(558)+theta(531)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(748) = theta(559)+theta(531)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(749) = theta(560)+theta(532)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(750) = theta(561)+theta(532)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        theta(751) = theta(562)+theta(532)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(752) = theta(561)+theta(533)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(753) = theta(563)+theta(533)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(754) = theta(564)+theta(533)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(755) = theta(562)+theta(534)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(756) = theta(564)+theta(534)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(757) = theta(565)+theta(534)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(758) = theta(563)+theta(535)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(759) = theta(566)+theta(535)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(760) = theta(567)+theta(535)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(761) = theta(564)+theta(536)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(762) = theta(567)+theta(536)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(763) = theta(568)+theta(536)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(764) = theta(565)+theta(537)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(765) = theta(568)+theta(537)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(766) = theta(569)+theta(537)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(767) = theta(566)+theta(538)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(768) = theta(570)+theta(538)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(769) = theta(571)+theta(538)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(770) = theta(567)+theta(539)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(771) = theta(571)+theta(539)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(772) = theta(572)+theta(539)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(773) = theta(568)+theta(540)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(774) = theta(572)+theta(540)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(775) = theta(573)+theta(540)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(776) = theta(569)+theta(541)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(777) = theta(573)+theta(541)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(778) = theta(574)+theta(541)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(779) = theta(570)+theta(542)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(780) = theta(575)+theta(542)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(781) = theta(576)+theta(542)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(782) = theta(571)+theta(543)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(783) = theta(576)+theta(543)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(784) = theta(577)+theta(543)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(785) = theta(572)+theta(544)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(786) = theta(577)+theta(544)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(787) = theta(578)+theta(544)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(788) = theta(573)+theta(545)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(789) = theta(578)+theta(545)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(790) = theta(579)+theta(545)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(791) = theta(574)+theta(546)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(792) = theta(579)+theta(546)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(793) = theta(580)+theta(546)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(794) = theta(575)+theta(547)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(795) = theta(581)+theta(547)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(796) = theta(582)+theta(547)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(797) = theta(576)+theta(548)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(798) = theta(582)+theta(548)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(799) = theta(583)+theta(548)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(800) = theta(577)+theta(549)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(801) = theta(583)+theta(549)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(802) = theta(584)+theta(549)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(803) = theta(578)+theta(550)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(804) = theta(584)+theta(550)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(805) = theta(585)+theta(550)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(806) = theta(579)+theta(551)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(807) = theta(585)+theta(551)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(808) = theta(586)+theta(551)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(809) = theta(580)+theta(552)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        theta(810) = theta(586)+theta(552)*AB(2) ! ((1,0,5)|(0,1,0)) = ((1,1,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(2)
        theta(811) = theta(587)+theta(552)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        ! theta(812) = theta(581)+theta(553)*AB(1) ! ((0,6,0)|(1,0,0)) = ((1,6,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(1)
        theta(813) = theta(588)+theta(553)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(814) = theta(589)+theta(553)*AB(3) ! ((0,6,0)|(0,0,1)) = ((0,6,1)|(0,0,0))+((0,6,0)|(0,0,0))*AB(3)
        theta(815) = theta(582)+theta(554)*AB(1) ! ((0,5,1)|(1,0,0)) = ((1,5,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(1)
        theta(816) = theta(589)+theta(554)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(817) = theta(590)+theta(554)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        ! theta(818) = theta(583)+theta(555)*AB(1) ! ((0,4,2)|(1,0,0)) = ((1,4,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(1)
        theta(819) = theta(590)+theta(555)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(820) = theta(591)+theta(555)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        ! theta(821) = theta(584)+theta(556)*AB(1) ! ((0,3,3)|(1,0,0)) = ((1,3,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(1)
        theta(822) = theta(591)+theta(556)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(823) = theta(592)+theta(556)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        ! theta(824) = theta(585)+theta(557)*AB(1) ! ((0,2,4)|(1,0,0)) = ((1,2,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(1)
        theta(825) = theta(592)+theta(557)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(826) = theta(593)+theta(557)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        ! theta(827) = theta(586)+theta(558)*AB(1) ! ((0,1,5)|(1,0,0)) = ((1,1,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(1)
        theta(828) = theta(593)+theta(558)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(829) = theta(594)+theta(558)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        ! theta(830) = theta(587)+theta(559)*AB(1) ! ((0,0,6)|(1,0,0)) = ((1,0,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(1)
        ! theta(831) = theta(594)+theta(559)*AB(2) ! ((0,0,6)|(0,1,0)) = ((0,1,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(2)
        theta(832) = theta(595)+theta(559)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(833) = theta(596)+theta(560)*AB(1) ! ((7,0,0)|(1,0,0)) = ((8,0,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(1)
        ! theta(834) = theta(597)+theta(560)*AB(2) ! ((7,0,0)|(0,1,0)) = ((7,1,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(2)
        ! theta(835) = theta(598)+theta(560)*AB(3) ! ((7,0,0)|(0,0,1)) = ((7,0,1)|(0,0,0))+((7,0,0)|(0,0,0))*AB(3)
        theta(836) = theta(597)+theta(561)*AB(1) ! ((6,1,0)|(1,0,0)) = ((7,1,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(1)
        theta(837) = theta(599)+theta(561)*AB(2) ! ((6,1,0)|(0,1,0)) = ((6,2,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(2)
        ! theta(838) = theta(600)+theta(561)*AB(3) ! ((6,1,0)|(0,0,1)) = ((6,1,1)|(0,0,0))+((6,1,0)|(0,0,0))*AB(3)
        theta(839) = theta(598)+theta(562)*AB(1) ! ((6,0,1)|(1,0,0)) = ((7,0,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(1)
        theta(840) = theta(600)+theta(562)*AB(2) ! ((6,0,1)|(0,1,0)) = ((6,1,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(2)
        theta(841) = theta(601)+theta(562)*AB(3) ! ((6,0,1)|(0,0,1)) = ((6,0,2)|(0,0,0))+((6,0,1)|(0,0,0))*AB(3)
        theta(842) = theta(599)+theta(563)*AB(1) ! ((5,2,0)|(1,0,0)) = ((6,2,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(1)
        theta(843) = theta(602)+theta(563)*AB(2) ! ((5,2,0)|(0,1,0)) = ((5,3,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(2)
        ! theta(844) = theta(603)+theta(563)*AB(3) ! ((5,2,0)|(0,0,1)) = ((5,2,1)|(0,0,0))+((5,2,0)|(0,0,0))*AB(3)
        theta(845) = theta(600)+theta(564)*AB(1) ! ((5,1,1)|(1,0,0)) = ((6,1,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(1)
        theta(846) = theta(603)+theta(564)*AB(2) ! ((5,1,1)|(0,1,0)) = ((5,2,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(2)
        theta(847) = theta(604)+theta(564)*AB(3) ! ((5,1,1)|(0,0,1)) = ((5,1,2)|(0,0,0))+((5,1,1)|(0,0,0))*AB(3)
        theta(848) = theta(601)+theta(565)*AB(1) ! ((5,0,2)|(1,0,0)) = ((6,0,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(1)
        theta(849) = theta(604)+theta(565)*AB(2) ! ((5,0,2)|(0,1,0)) = ((5,1,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(2)
        theta(850) = theta(605)+theta(565)*AB(3) ! ((5,0,2)|(0,0,1)) = ((5,0,3)|(0,0,0))+((5,0,2)|(0,0,0))*AB(3)
        theta(851) = theta(602)+theta(566)*AB(1) ! ((4,3,0)|(1,0,0)) = ((5,3,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(1)
        theta(852) = theta(606)+theta(566)*AB(2) ! ((4,3,0)|(0,1,0)) = ((4,4,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(2)
        ! theta(853) = theta(607)+theta(566)*AB(3) ! ((4,3,0)|(0,0,1)) = ((4,3,1)|(0,0,0))+((4,3,0)|(0,0,0))*AB(3)
        theta(854) = theta(603)+theta(567)*AB(1) ! ((4,2,1)|(1,0,0)) = ((5,2,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(1)
        theta(855) = theta(607)+theta(567)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(856) = theta(608)+theta(567)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(857) = theta(604)+theta(568)*AB(1) ! ((4,1,2)|(1,0,0)) = ((5,1,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(1)
        theta(858) = theta(608)+theta(568)*AB(2) ! ((4,1,2)|(0,1,0)) = ((4,2,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(2)
        theta(859) = theta(609)+theta(568)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(860) = theta(605)+theta(569)*AB(1) ! ((4,0,3)|(1,0,0)) = ((5,0,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(1)
        theta(861) = theta(609)+theta(569)*AB(2) ! ((4,0,3)|(0,1,0)) = ((4,1,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(2)
        theta(862) = theta(610)+theta(569)*AB(3) ! ((4,0,3)|(0,0,1)) = ((4,0,4)|(0,0,0))+((4,0,3)|(0,0,0))*AB(3)
        theta(863) = theta(606)+theta(570)*AB(1) ! ((3,4,0)|(1,0,0)) = ((4,4,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(1)
        theta(864) = theta(611)+theta(570)*AB(2) ! ((3,4,0)|(0,1,0)) = ((3,5,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(2)
        ! theta(865) = theta(612)+theta(570)*AB(3) ! ((3,4,0)|(0,0,1)) = ((3,4,1)|(0,0,0))+((3,4,0)|(0,0,0))*AB(3)
        theta(866) = theta(607)+theta(571)*AB(1) ! ((3,3,1)|(1,0,0)) = ((4,3,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(1)
        theta(867) = theta(612)+theta(571)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(868) = theta(613)+theta(571)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(869) = theta(608)+theta(572)*AB(1) ! ((3,2,2)|(1,0,0)) = ((4,2,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(1)
        theta(870) = theta(613)+theta(572)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(871) = theta(614)+theta(572)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(872) = theta(609)+theta(573)*AB(1) ! ((3,1,3)|(1,0,0)) = ((4,1,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(1)
        theta(873) = theta(614)+theta(573)*AB(2) ! ((3,1,3)|(0,1,0)) = ((3,2,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(2)
        theta(874) = theta(615)+theta(573)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(875) = theta(610)+theta(574)*AB(1) ! ((3,0,4)|(1,0,0)) = ((4,0,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(1)
        theta(876) = theta(615)+theta(574)*AB(2) ! ((3,0,4)|(0,1,0)) = ((3,1,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(2)
        theta(877) = theta(616)+theta(574)*AB(3) ! ((3,0,4)|(0,0,1)) = ((3,0,5)|(0,0,0))+((3,0,4)|(0,0,0))*AB(3)
        theta(878) = theta(611)+theta(575)*AB(1) ! ((2,5,0)|(1,0,0)) = ((3,5,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(1)
        theta(879) = theta(617)+theta(575)*AB(2) ! ((2,5,0)|(0,1,0)) = ((2,6,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(2)
        ! theta(880) = theta(618)+theta(575)*AB(3) ! ((2,5,0)|(0,0,1)) = ((2,5,1)|(0,0,0))+((2,5,0)|(0,0,0))*AB(3)
        theta(881) = theta(612)+theta(576)*AB(1) ! ((2,4,1)|(1,0,0)) = ((3,4,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(1)
        theta(882) = theta(618)+theta(576)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(883) = theta(619)+theta(576)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(884) = theta(613)+theta(577)*AB(1) ! ((2,3,2)|(1,0,0)) = ((3,3,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(1)
        theta(885) = theta(619)+theta(577)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(886) = theta(620)+theta(577)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(887) = theta(614)+theta(578)*AB(1) ! ((2,2,3)|(1,0,0)) = ((3,2,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(1)
        theta(888) = theta(620)+theta(578)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(889) = theta(621)+theta(578)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(890) = theta(615)+theta(579)*AB(1) ! ((2,1,4)|(1,0,0)) = ((3,1,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(1)
        theta(891) = theta(621)+theta(579)*AB(2) ! ((2,1,4)|(0,1,0)) = ((2,2,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(2)
        theta(892) = theta(622)+theta(579)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(893) = theta(616)+theta(580)*AB(1) ! ((2,0,5)|(1,0,0)) = ((3,0,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(1)
        ! theta(894) = theta(622)+theta(580)*AB(2) ! ((2,0,5)|(0,1,0)) = ((2,1,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(2)
        theta(895) = theta(623)+theta(580)*AB(3) ! ((2,0,5)|(0,0,1)) = ((2,0,6)|(0,0,0))+((2,0,5)|(0,0,0))*AB(3)
        ! theta(896) = theta(617)+theta(581)*AB(1) ! ((1,6,0)|(1,0,0)) = ((2,6,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(1)
        theta(897) = theta(624)+theta(581)*AB(2) ! ((1,6,0)|(0,1,0)) = ((1,7,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(2)
        ! theta(898) = theta(625)+theta(581)*AB(3) ! ((1,6,0)|(0,0,1)) = ((1,6,1)|(0,0,0))+((1,6,0)|(0,0,0))*AB(3)
        theta(899) = theta(618)+theta(582)*AB(1) ! ((1,5,1)|(1,0,0)) = ((2,5,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(1)
        theta(900) = theta(625)+theta(582)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(901) = theta(626)+theta(582)*AB(3) ! ((1,5,1)|(0,0,1)) = ((1,5,2)|(0,0,0))+((1,5,1)|(0,0,0))*AB(3)
        ! theta(902) = theta(619)+theta(583)*AB(1) ! ((1,4,2)|(1,0,0)) = ((2,4,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(1)
        theta(903) = theta(626)+theta(583)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(904) = theta(627)+theta(583)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        ! theta(905) = theta(620)+theta(584)*AB(1) ! ((1,3,3)|(1,0,0)) = ((2,3,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(1)
        theta(906) = theta(627)+theta(584)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(907) = theta(628)+theta(584)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        ! theta(908) = theta(621)+theta(585)*AB(1) ! ((1,2,4)|(1,0,0)) = ((2,2,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(1)
        theta(909) = theta(628)+theta(585)*AB(2) ! ((1,2,4)|(0,1,0)) = ((1,3,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(2)
        theta(910) = theta(629)+theta(585)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        ! theta(911) = theta(622)+theta(586)*AB(1) ! ((1,1,5)|(1,0,0)) = ((2,1,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(1)
        theta(912) = theta(629)+theta(586)*AB(2) ! ((1,1,5)|(0,1,0)) = ((1,2,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(2)
        theta(913) = theta(630)+theta(586)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        ! theta(914) = theta(623)+theta(587)*AB(1) ! ((1,0,6)|(1,0,0)) = ((2,0,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(1)
        ! theta(915) = theta(630)+theta(587)*AB(2) ! ((1,0,6)|(0,1,0)) = ((1,1,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(2)
        theta(916) = theta(631)+theta(587)*AB(3) ! ((1,0,6)|(0,0,1)) = ((1,0,7)|(0,0,0))+((1,0,6)|(0,0,0))*AB(3)
        ! theta(917) = theta(624)+theta(588)*AB(1) ! ((0,7,0)|(1,0,0)) = ((1,7,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(1)
        theta(918) = theta(632)+theta(588)*AB(2) ! ((0,7,0)|(0,1,0)) = ((0,8,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(2)
        ! theta(919) = theta(633)+theta(588)*AB(3) ! ((0,7,0)|(0,0,1)) = ((0,7,1)|(0,0,0))+((0,7,0)|(0,0,0))*AB(3)
        ! theta(920) = theta(625)+theta(589)*AB(1) ! ((0,6,1)|(1,0,0)) = ((1,6,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(1)
        theta(921) = theta(633)+theta(589)*AB(2) ! ((0,6,1)|(0,1,0)) = ((0,7,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(2)
        theta(922) = theta(634)+theta(589)*AB(3) ! ((0,6,1)|(0,0,1)) = ((0,6,2)|(0,0,0))+((0,6,1)|(0,0,0))*AB(3)
        ! theta(923) = theta(626)+theta(590)*AB(1) ! ((0,5,2)|(1,0,0)) = ((1,5,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(1)
        theta(924) = theta(634)+theta(590)*AB(2) ! ((0,5,2)|(0,1,0)) = ((0,6,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(2)
        theta(925) = theta(635)+theta(590)*AB(3) ! ((0,5,2)|(0,0,1)) = ((0,5,3)|(0,0,0))+((0,5,2)|(0,0,0))*AB(3)
        ! theta(926) = theta(627)+theta(591)*AB(1) ! ((0,4,3)|(1,0,0)) = ((1,4,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(1)
        theta(927) = theta(635)+theta(591)*AB(2) ! ((0,4,3)|(0,1,0)) = ((0,5,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(2)
        theta(928) = theta(636)+theta(591)*AB(3) ! ((0,4,3)|(0,0,1)) = ((0,4,4)|(0,0,0))+((0,4,3)|(0,0,0))*AB(3)
        ! theta(929) = theta(628)+theta(592)*AB(1) ! ((0,3,4)|(1,0,0)) = ((1,3,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(1)
        theta(930) = theta(636)+theta(592)*AB(2) ! ((0,3,4)|(0,1,0)) = ((0,4,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(2)
        theta(931) = theta(637)+theta(592)*AB(3) ! ((0,3,4)|(0,0,1)) = ((0,3,5)|(0,0,0))+((0,3,4)|(0,0,0))*AB(3)
        ! theta(932) = theta(629)+theta(593)*AB(1) ! ((0,2,5)|(1,0,0)) = ((1,2,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(1)
        theta(933) = theta(637)+theta(593)*AB(2) ! ((0,2,5)|(0,1,0)) = ((0,3,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(2)
        theta(934) = theta(638)+theta(593)*AB(3) ! ((0,2,5)|(0,0,1)) = ((0,2,6)|(0,0,0))+((0,2,5)|(0,0,0))*AB(3)
        ! theta(935) = theta(630)+theta(594)*AB(1) ! ((0,1,6)|(1,0,0)) = ((1,1,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(1)
        ! theta(936) = theta(638)+theta(594)*AB(2) ! ((0,1,6)|(0,1,0)) = ((0,2,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(2)
        theta(937) = theta(639)+theta(594)*AB(3) ! ((0,1,6)|(0,0,1)) = ((0,1,7)|(0,0,0))+((0,1,6)|(0,0,0))*AB(3)
        ! theta(938) = theta(631)+theta(595)*AB(1) ! ((0,0,7)|(1,0,0)) = ((1,0,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(1)
        ! theta(939) = theta(639)+theta(595)*AB(2) ! ((0,0,7)|(0,1,0)) = ((0,1,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(2)
        theta(940) = theta(640)+theta(595)*AB(3) ! ((0,0,7)|(0,0,1)) = ((0,0,8)|(0,0,0))+((0,0,7)|(0,0,0))*AB(3)
        theta(941) = theta(686)+theta(641)*AB(1) ! ((4,0,0)|(2,0,0)) = ((5,0,0)|(1,0,0))+((4,0,0)|(1,0,0))*AB(1)
        ! theta(942) = theta(687)+theta(642)*AB(1) ! ((4,0,0)|(1,1,0)) = ((5,0,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(1)
        ! theta(943) = theta(688)+theta(643)*AB(1) ! ((4,0,0)|(1,0,1)) = ((5,0,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(1)
        theta(944) = theta(690)+theta(642)*AB(2) ! ((4,0,0)|(0,2,0)) = ((4,1,0)|(0,1,0))+((4,0,0)|(0,1,0))*AB(2)
        ! theta(945) = theta(691)+theta(643)*AB(2) ! ((4,0,0)|(0,1,1)) = ((4,1,0)|(0,0,1))+((4,0,0)|(0,0,1))*AB(2)
        theta(946) = theta(694)+theta(643)*AB(3) ! ((4,0,0)|(0,0,2)) = ((4,0,1)|(0,0,1))+((4,0,0)|(0,0,1))*AB(3)
        theta(947) = theta(689)+theta(644)*AB(1) ! ((3,1,0)|(2,0,0)) = ((4,1,0)|(1,0,0))+((3,1,0)|(1,0,0))*AB(1)
        ! theta(948) = theta(690)+theta(645)*AB(1) ! ((3,1,0)|(1,1,0)) = ((4,1,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(1)
        ! theta(949) = theta(691)+theta(646)*AB(1) ! ((3,1,0)|(1,0,1)) = ((4,1,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(1)
        theta(950) = theta(696)+theta(645)*AB(2) ! ((3,1,0)|(0,2,0)) = ((3,2,0)|(0,1,0))+((3,1,0)|(0,1,0))*AB(2)
        ! theta(951) = theta(697)+theta(646)*AB(2) ! ((3,1,0)|(0,1,1)) = ((3,2,0)|(0,0,1))+((3,1,0)|(0,0,1))*AB(2)
        theta(952) = theta(700)+theta(646)*AB(3) ! ((3,1,0)|(0,0,2)) = ((3,1,1)|(0,0,1))+((3,1,0)|(0,0,1))*AB(3)
        theta(953) = theta(692)+theta(647)*AB(1) ! ((3,0,1)|(2,0,0)) = ((4,0,1)|(1,0,0))+((3,0,1)|(1,0,0))*AB(1)
        theta(954) = theta(693)+theta(648)*AB(1) ! ((3,0,1)|(1,1,0)) = ((4,0,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(1)
        ! theta(955) = theta(694)+theta(649)*AB(1) ! ((3,0,1)|(1,0,1)) = ((4,0,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(1)
        theta(956) = theta(699)+theta(648)*AB(2) ! ((3,0,1)|(0,2,0)) = ((3,1,1)|(0,1,0))+((3,0,1)|(0,1,0))*AB(2)
        theta(957) = theta(700)+theta(649)*AB(2) ! ((3,0,1)|(0,1,1)) = ((3,1,1)|(0,0,1))+((3,0,1)|(0,0,1))*AB(2)
        theta(958) = theta(703)+theta(649)*AB(3) ! ((3,0,1)|(0,0,2)) = ((3,0,2)|(0,0,1))+((3,0,1)|(0,0,1))*AB(3)
        theta(959) = theta(695)+theta(650)*AB(1) ! ((2,2,0)|(2,0,0)) = ((3,2,0)|(1,0,0))+((2,2,0)|(1,0,0))*AB(1)
        ! theta(960) = theta(696)+theta(651)*AB(1) ! ((2,2,0)|(1,1,0)) = ((3,2,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(1)
        ! theta(961) = theta(697)+theta(652)*AB(1) ! ((2,2,0)|(1,0,1)) = ((3,2,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(1)
        theta(962) = theta(705)+theta(651)*AB(2) ! ((2,2,0)|(0,2,0)) = ((2,3,0)|(0,1,0))+((2,2,0)|(0,1,0))*AB(2)
        ! theta(963) = theta(706)+theta(652)*AB(2) ! ((2,2,0)|(0,1,1)) = ((2,3,0)|(0,0,1))+((2,2,0)|(0,0,1))*AB(2)
        theta(964) = theta(709)+theta(652)*AB(3) ! ((2,2,0)|(0,0,2)) = ((2,2,1)|(0,0,1))+((2,2,0)|(0,0,1))*AB(3)
        theta(965) = theta(698)+theta(653)*AB(1) ! ((2,1,1)|(2,0,0)) = ((3,1,1)|(1,0,0))+((2,1,1)|(1,0,0))*AB(1)
        theta(966) = theta(699)+theta(654)*AB(1) ! ((2,1,1)|(1,1,0)) = ((3,1,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(1)
        ! theta(967) = theta(700)+theta(655)*AB(1) ! ((2,1,1)|(1,0,1)) = ((3,1,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(1)
        theta(968) = theta(708)+theta(654)*AB(2) ! ((2,1,1)|(0,2,0)) = ((2,2,1)|(0,1,0))+((2,1,1)|(0,1,0))*AB(2)
        theta(969) = theta(709)+theta(655)*AB(2) ! ((2,1,1)|(0,1,1)) = ((2,2,1)|(0,0,1))+((2,1,1)|(0,0,1))*AB(2)
        theta(970) = theta(712)+theta(655)*AB(3) ! ((2,1,1)|(0,0,2)) = ((2,1,2)|(0,0,1))+((2,1,1)|(0,0,1))*AB(3)
        theta(971) = theta(701)+theta(656)*AB(1) ! ((2,0,2)|(2,0,0)) = ((3,0,2)|(1,0,0))+((2,0,2)|(1,0,0))*AB(1)
        theta(972) = theta(702)+theta(657)*AB(1) ! ((2,0,2)|(1,1,0)) = ((3,0,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(1)
        ! theta(973) = theta(703)+theta(658)*AB(1) ! ((2,0,2)|(1,0,1)) = ((3,0,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(1)
        theta(974) = theta(711)+theta(657)*AB(2) ! ((2,0,2)|(0,2,0)) = ((2,1,2)|(0,1,0))+((2,0,2)|(0,1,0))*AB(2)
        theta(975) = theta(712)+theta(658)*AB(2) ! ((2,0,2)|(0,1,1)) = ((2,1,2)|(0,0,1))+((2,0,2)|(0,0,1))*AB(2)
        theta(976) = theta(715)+theta(658)*AB(3) ! ((2,0,2)|(0,0,2)) = ((2,0,3)|(0,0,1))+((2,0,2)|(0,0,1))*AB(3)
        theta(977) = theta(704)+theta(659)*AB(1) ! ((1,3,0)|(2,0,0)) = ((2,3,0)|(1,0,0))+((1,3,0)|(1,0,0))*AB(1)
        ! theta(978) = theta(705)+theta(660)*AB(1) ! ((1,3,0)|(1,1,0)) = ((2,3,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(1)
        ! theta(979) = theta(706)+theta(661)*AB(1) ! ((1,3,0)|(1,0,1)) = ((2,3,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(1)
        theta(980) = theta(717)+theta(660)*AB(2) ! ((1,3,0)|(0,2,0)) = ((1,4,0)|(0,1,0))+((1,3,0)|(0,1,0))*AB(2)
        ! theta(981) = theta(718)+theta(661)*AB(2) ! ((1,3,0)|(0,1,1)) = ((1,4,0)|(0,0,1))+((1,3,0)|(0,0,1))*AB(2)
        theta(982) = theta(721)+theta(661)*AB(3) ! ((1,3,0)|(0,0,2)) = ((1,3,1)|(0,0,1))+((1,3,0)|(0,0,1))*AB(3)
        theta(983) = theta(707)+theta(662)*AB(1) ! ((1,2,1)|(2,0,0)) = ((2,2,1)|(1,0,0))+((1,2,1)|(1,0,0))*AB(1)
        theta(984) = theta(708)+theta(663)*AB(1) ! ((1,2,1)|(1,1,0)) = ((2,2,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(1)
        ! theta(985) = theta(709)+theta(664)*AB(1) ! ((1,2,1)|(1,0,1)) = ((2,2,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(1)
        theta(986) = theta(720)+theta(663)*AB(2) ! ((1,2,1)|(0,2,0)) = ((1,3,1)|(0,1,0))+((1,2,1)|(0,1,0))*AB(2)
        theta(987) = theta(721)+theta(664)*AB(2) ! ((1,2,1)|(0,1,1)) = ((1,3,1)|(0,0,1))+((1,2,1)|(0,0,1))*AB(2)
        theta(988) = theta(724)+theta(664)*AB(3) ! ((1,2,1)|(0,0,2)) = ((1,2,2)|(0,0,1))+((1,2,1)|(0,0,1))*AB(3)
        theta(989) = theta(710)+theta(665)*AB(1) ! ((1,1,2)|(2,0,0)) = ((2,1,2)|(1,0,0))+((1,1,2)|(1,0,0))*AB(1)
        theta(990) = theta(711)+theta(666)*AB(1) ! ((1,1,2)|(1,1,0)) = ((2,1,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(1)
        ! theta(991) = theta(712)+theta(667)*AB(1) ! ((1,1,2)|(1,0,1)) = ((2,1,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(1)
        theta(992) = theta(723)+theta(666)*AB(2) ! ((1,1,2)|(0,2,0)) = ((1,2,2)|(0,1,0))+((1,1,2)|(0,1,0))*AB(2)
        theta(993) = theta(724)+theta(667)*AB(2) ! ((1,1,2)|(0,1,1)) = ((1,2,2)|(0,0,1))+((1,1,2)|(0,0,1))*AB(2)
        theta(994) = theta(727)+theta(667)*AB(3) ! ((1,1,2)|(0,0,2)) = ((1,1,3)|(0,0,1))+((1,1,2)|(0,0,1))*AB(3)
        theta(995) = theta(713)+theta(668)*AB(1) ! ((1,0,3)|(2,0,0)) = ((2,0,3)|(1,0,0))+((1,0,3)|(1,0,0))*AB(1)
        theta(996) = theta(714)+theta(669)*AB(1) ! ((1,0,3)|(1,1,0)) = ((2,0,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(1)
        ! theta(997) = theta(715)+theta(670)*AB(1) ! ((1,0,3)|(1,0,1)) = ((2,0,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(1)
        theta(998) = theta(726)+theta(669)*AB(2) ! ((1,0,3)|(0,2,0)) = ((1,1,3)|(0,1,0))+((1,0,3)|(0,1,0))*AB(2)
        theta(999) = theta(727)+theta(670)*AB(2) ! ((1,0,3)|(0,1,1)) = ((1,1,3)|(0,0,1))+((1,0,3)|(0,0,1))*AB(2)
        theta(1000) = theta(730)+theta(670)*AB(3) ! ((1,0,3)|(0,0,2)) = ((1,0,4)|(0,0,1))+((1,0,3)|(0,0,1))*AB(3)
        theta(1001) = theta(716)+theta(671)*AB(1) ! ((0,4,0)|(2,0,0)) = ((1,4,0)|(1,0,0))+((0,4,0)|(1,0,0))*AB(1)
        ! theta(1002) = theta(717)+theta(672)*AB(1) ! ((0,4,0)|(1,1,0)) = ((1,4,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(1)
        ! theta(1003) = theta(718)+theta(673)*AB(1) ! ((0,4,0)|(1,0,1)) = ((1,4,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(1)
        theta(1004) = theta(732)+theta(672)*AB(2) ! ((0,4,0)|(0,2,0)) = ((0,5,0)|(0,1,0))+((0,4,0)|(0,1,0))*AB(2)
        ! theta(1005) = theta(733)+theta(673)*AB(2) ! ((0,4,0)|(0,1,1)) = ((0,5,0)|(0,0,1))+((0,4,0)|(0,0,1))*AB(2)
        theta(1006) = theta(736)+theta(673)*AB(3) ! ((0,4,0)|(0,0,2)) = ((0,4,1)|(0,0,1))+((0,4,0)|(0,0,1))*AB(3)
        theta(1007) = theta(719)+theta(674)*AB(1) ! ((0,3,1)|(2,0,0)) = ((1,3,1)|(1,0,0))+((0,3,1)|(1,0,0))*AB(1)
        theta(1008) = theta(720)+theta(675)*AB(1) ! ((0,3,1)|(1,1,0)) = ((1,3,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(1)
        ! theta(1009) = theta(721)+theta(676)*AB(1) ! ((0,3,1)|(1,0,1)) = ((1,3,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(1)
        theta(1010) = theta(735)+theta(675)*AB(2) ! ((0,3,1)|(0,2,0)) = ((0,4,1)|(0,1,0))+((0,3,1)|(0,1,0))*AB(2)
        theta(1011) = theta(736)+theta(676)*AB(2) ! ((0,3,1)|(0,1,1)) = ((0,4,1)|(0,0,1))+((0,3,1)|(0,0,1))*AB(2)
        theta(1012) = theta(739)+theta(676)*AB(3) ! ((0,3,1)|(0,0,2)) = ((0,3,2)|(0,0,1))+((0,3,1)|(0,0,1))*AB(3)
        theta(1013) = theta(722)+theta(677)*AB(1) ! ((0,2,2)|(2,0,0)) = ((1,2,2)|(1,0,0))+((0,2,2)|(1,0,0))*AB(1)
        theta(1014) = theta(723)+theta(678)*AB(1) ! ((0,2,2)|(1,1,0)) = ((1,2,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(1)
        ! theta(1015) = theta(724)+theta(679)*AB(1) ! ((0,2,2)|(1,0,1)) = ((1,2,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(1)
        theta(1016) = theta(738)+theta(678)*AB(2) ! ((0,2,2)|(0,2,0)) = ((0,3,2)|(0,1,0))+((0,2,2)|(0,1,0))*AB(2)
        theta(1017) = theta(739)+theta(679)*AB(2) ! ((0,2,2)|(0,1,1)) = ((0,3,2)|(0,0,1))+((0,2,2)|(0,0,1))*AB(2)
        theta(1018) = theta(742)+theta(679)*AB(3) ! ((0,2,2)|(0,0,2)) = ((0,2,3)|(0,0,1))+((0,2,2)|(0,0,1))*AB(3)
        theta(1019) = theta(725)+theta(680)*AB(1) ! ((0,1,3)|(2,0,0)) = ((1,1,3)|(1,0,0))+((0,1,3)|(1,0,0))*AB(1)
        theta(1020) = theta(726)+theta(681)*AB(1) ! ((0,1,3)|(1,1,0)) = ((1,1,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(1)
        ! theta(1021) = theta(727)+theta(682)*AB(1) ! ((0,1,3)|(1,0,1)) = ((1,1,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(1)
        theta(1022) = theta(741)+theta(681)*AB(2) ! ((0,1,3)|(0,2,0)) = ((0,2,3)|(0,1,0))+((0,1,3)|(0,1,0))*AB(2)
        theta(1023) = theta(742)+theta(682)*AB(2) ! ((0,1,3)|(0,1,1)) = ((0,2,3)|(0,0,1))+((0,1,3)|(0,0,1))*AB(2)
        theta(1024) = theta(745)+theta(682)*AB(3) ! ((0,1,3)|(0,0,2)) = ((0,1,4)|(0,0,1))+((0,1,3)|(0,0,1))*AB(3)
        theta(1025) = theta(728)+theta(683)*AB(1) ! ((0,0,4)|(2,0,0)) = ((1,0,4)|(1,0,0))+((0,0,4)|(1,0,0))*AB(1)
        theta(1026) = theta(729)+theta(684)*AB(1) ! ((0,0,4)|(1,1,0)) = ((1,0,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(1)
        ! theta(1027) = theta(730)+theta(685)*AB(1) ! ((0,0,4)|(1,0,1)) = ((1,0,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(1)
        theta(1028) = theta(744)+theta(684)*AB(2) ! ((0,0,4)|(0,2,0)) = ((0,1,4)|(0,1,0))+((0,0,4)|(0,1,0))*AB(2)
        theta(1029) = theta(745)+theta(685)*AB(2) ! ((0,0,4)|(0,1,1)) = ((0,1,4)|(0,0,1))+((0,0,4)|(0,0,1))*AB(2)
        theta(1030) = theta(748)+theta(685)*AB(3) ! ((0,0,4)|(0,0,2)) = ((0,0,5)|(0,0,1))+((0,0,4)|(0,0,1))*AB(3)
        theta(1031) = theta(749)+theta(686)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        ! theta(1032) = theta(750)+theta(687)*AB(1) ! ((5,0,0)|(1,1,0)) = ((6,0,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(1)
        ! theta(1033) = theta(751)+theta(688)*AB(1) ! ((5,0,0)|(1,0,1)) = ((6,0,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(1)
        theta(1034) = theta(753)+theta(687)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        ! theta(1035) = theta(754)+theta(688)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        theta(1036) = theta(757)+theta(688)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(1037) = theta(752)+theta(689)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        ! theta(1038) = theta(753)+theta(690)*AB(1) ! ((4,1,0)|(1,1,0)) = ((5,1,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(1)
        ! theta(1039) = theta(754)+theta(691)*AB(1) ! ((4,1,0)|(1,0,1)) = ((5,1,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(1)
        theta(1040) = theta(759)+theta(690)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        ! theta(1041) = theta(760)+theta(691)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        theta(1042) = theta(763)+theta(691)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1043) = theta(755)+theta(692)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(1044) = theta(756)+theta(693)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        ! theta(1045) = theta(757)+theta(694)*AB(1) ! ((4,0,1)|(1,0,1)) = ((5,0,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(1)
        theta(1046) = theta(762)+theta(693)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1047) = theta(763)+theta(694)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(1048) = theta(766)+theta(694)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1049) = theta(758)+theta(695)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        ! theta(1050) = theta(759)+theta(696)*AB(1) ! ((3,2,0)|(1,1,0)) = ((4,2,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(1)
        ! theta(1051) = theta(760)+theta(697)*AB(1) ! ((3,2,0)|(1,0,1)) = ((4,2,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(1)
        theta(1052) = theta(768)+theta(696)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        ! theta(1053) = theta(769)+theta(697)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        theta(1054) = theta(772)+theta(697)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1055) = theta(761)+theta(698)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(1056) = theta(762)+theta(699)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        ! theta(1057) = theta(763)+theta(700)*AB(1) ! ((3,1,1)|(1,0,1)) = ((4,1,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(1)
        theta(1058) = theta(771)+theta(699)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1059) = theta(772)+theta(700)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(1060) = theta(775)+theta(700)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1061) = theta(764)+theta(701)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(1062) = theta(765)+theta(702)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        ! theta(1063) = theta(766)+theta(703)*AB(1) ! ((3,0,2)|(1,0,1)) = ((4,0,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(1)
        theta(1064) = theta(774)+theta(702)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1065) = theta(775)+theta(703)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(1066) = theta(778)+theta(703)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1067) = theta(767)+theta(704)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        ! theta(1068) = theta(768)+theta(705)*AB(1) ! ((2,3,0)|(1,1,0)) = ((3,3,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(1)
        ! theta(1069) = theta(769)+theta(706)*AB(1) ! ((2,3,0)|(1,0,1)) = ((3,3,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(1)
        theta(1070) = theta(780)+theta(705)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        ! theta(1071) = theta(781)+theta(706)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        theta(1072) = theta(784)+theta(706)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1073) = theta(770)+theta(707)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(1074) = theta(771)+theta(708)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        ! theta(1075) = theta(772)+theta(709)*AB(1) ! ((2,2,1)|(1,0,1)) = ((3,2,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(1)
        theta(1076) = theta(783)+theta(708)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1077) = theta(784)+theta(709)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(1078) = theta(787)+theta(709)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1079) = theta(773)+theta(710)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(1080) = theta(774)+theta(711)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        ! theta(1081) = theta(775)+theta(712)*AB(1) ! ((2,1,2)|(1,0,1)) = ((3,1,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(1)
        theta(1082) = theta(786)+theta(711)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1083) = theta(787)+theta(712)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(1084) = theta(790)+theta(712)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1085) = theta(776)+theta(713)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(1086) = theta(777)+theta(714)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        ! theta(1087) = theta(778)+theta(715)*AB(1) ! ((2,0,3)|(1,0,1)) = ((3,0,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(1)
        theta(1088) = theta(789)+theta(714)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1089) = theta(790)+theta(715)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(1090) = theta(793)+theta(715)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1091) = theta(779)+theta(716)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        ! theta(1092) = theta(780)+theta(717)*AB(1) ! ((1,4,0)|(1,1,0)) = ((2,4,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(1)
        ! theta(1093) = theta(781)+theta(718)*AB(1) ! ((1,4,0)|(1,0,1)) = ((2,4,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(1)
        theta(1094) = theta(795)+theta(717)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        ! theta(1095) = theta(796)+theta(718)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        theta(1096) = theta(799)+theta(718)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1097) = theta(782)+theta(719)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(1098) = theta(783)+theta(720)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        ! theta(1099) = theta(784)+theta(721)*AB(1) ! ((1,3,1)|(1,0,1)) = ((2,3,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(1)
        theta(1100) = theta(798)+theta(720)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1101) = theta(799)+theta(721)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(1102) = theta(802)+theta(721)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1103) = theta(785)+theta(722)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(1104) = theta(786)+theta(723)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        ! theta(1105) = theta(787)+theta(724)*AB(1) ! ((1,2,2)|(1,0,1)) = ((2,2,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(1)
        theta(1106) = theta(801)+theta(723)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1107) = theta(802)+theta(724)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(1108) = theta(805)+theta(724)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1109) = theta(788)+theta(725)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(1110) = theta(789)+theta(726)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        ! theta(1111) = theta(790)+theta(727)*AB(1) ! ((1,1,3)|(1,0,1)) = ((2,1,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(1)
        theta(1112) = theta(804)+theta(726)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1113) = theta(805)+theta(727)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(1114) = theta(808)+theta(727)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1115) = theta(791)+theta(728)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(1116) = theta(792)+theta(729)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        ! theta(1117) = theta(793)+theta(730)*AB(1) ! ((1,0,4)|(1,0,1)) = ((2,0,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(1)
        theta(1118) = theta(807)+theta(729)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1119) = theta(808)+theta(730)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(1120) = theta(811)+theta(730)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1121) = theta(794)+theta(731)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        ! theta(1122) = theta(795)+theta(732)*AB(1) ! ((0,5,0)|(1,1,0)) = ((1,5,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(1)
        ! theta(1123) = theta(796)+theta(733)*AB(1) ! ((0,5,0)|(1,0,1)) = ((1,5,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(1)
        theta(1124) = theta(813)+theta(732)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        ! theta(1125) = theta(814)+theta(733)*AB(2) ! ((0,5,0)|(0,1,1)) = ((0,6,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(2)
        theta(1126) = theta(817)+theta(733)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(1127) = theta(797)+theta(734)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        ! theta(1128) = theta(798)+theta(735)*AB(1) ! ((0,4,1)|(1,1,0)) = ((1,4,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(1)
        ! theta(1129) = theta(799)+theta(736)*AB(1) ! ((0,4,1)|(1,0,1)) = ((1,4,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(1)
        theta(1130) = theta(816)+theta(735)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        ! theta(1131) = theta(817)+theta(736)*AB(2) ! ((0,4,1)|(0,1,1)) = ((0,5,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(2)
        theta(1132) = theta(820)+theta(736)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1133) = theta(800)+theta(737)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        ! theta(1134) = theta(801)+theta(738)*AB(1) ! ((0,3,2)|(1,1,0)) = ((1,3,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(1)
        ! theta(1135) = theta(802)+theta(739)*AB(1) ! ((0,3,2)|(1,0,1)) = ((1,3,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(1)
        theta(1136) = theta(819)+theta(738)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        ! theta(1137) = theta(820)+theta(739)*AB(2) ! ((0,3,2)|(0,1,1)) = ((0,4,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(2)
        theta(1138) = theta(823)+theta(739)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1139) = theta(803)+theta(740)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        ! theta(1140) = theta(804)+theta(741)*AB(1) ! ((0,2,3)|(1,1,0)) = ((1,2,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(1)
        ! theta(1141) = theta(805)+theta(742)*AB(1) ! ((0,2,3)|(1,0,1)) = ((1,2,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(1)
        theta(1142) = theta(822)+theta(741)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        ! theta(1143) = theta(823)+theta(742)*AB(2) ! ((0,2,3)|(0,1,1)) = ((0,3,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(2)
        theta(1144) = theta(826)+theta(742)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1145) = theta(806)+theta(743)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        ! theta(1146) = theta(807)+theta(744)*AB(1) ! ((0,1,4)|(1,1,0)) = ((1,1,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(1)
        ! theta(1147) = theta(808)+theta(745)*AB(1) ! ((0,1,4)|(1,0,1)) = ((1,1,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(1)
        theta(1148) = theta(825)+theta(744)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        ! theta(1149) = theta(826)+theta(745)*AB(2) ! ((0,1,4)|(0,1,1)) = ((0,2,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(2)
        theta(1150) = theta(829)+theta(745)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1151) = theta(809)+theta(746)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        ! theta(1152) = theta(810)+theta(747)*AB(1) ! ((0,0,5)|(1,1,0)) = ((1,0,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(1)
        ! theta(1153) = theta(811)+theta(748)*AB(1) ! ((0,0,5)|(1,0,1)) = ((1,0,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(1)
        theta(1154) = theta(828)+theta(747)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        ! theta(1155) = theta(829)+theta(748)*AB(2) ! ((0,0,5)|(0,1,1)) = ((0,1,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(2)
        theta(1156) = theta(832)+theta(748)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(1157) = theta(833)+theta(749)*AB(1) ! ((6,0,0)|(2,0,0)) = ((7,0,0)|(1,0,0))+((6,0,0)|(1,0,0))*AB(1)
        ! theta(1158) = theta(834)+theta(750)*AB(1) ! ((6,0,0)|(1,1,0)) = ((7,0,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(1)
        ! theta(1159) = theta(835)+theta(751)*AB(1) ! ((6,0,0)|(1,0,1)) = ((7,0,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(1)
        theta(1160) = theta(837)+theta(750)*AB(2) ! ((6,0,0)|(0,2,0)) = ((6,1,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(2)
        ! theta(1161) = theta(838)+theta(751)*AB(2) ! ((6,0,0)|(0,1,1)) = ((6,1,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(2)
        theta(1162) = theta(841)+theta(751)*AB(3) ! ((6,0,0)|(0,0,2)) = ((6,0,1)|(0,0,1))+((6,0,0)|(0,0,1))*AB(3)
        theta(1163) = theta(836)+theta(752)*AB(1) ! ((5,1,0)|(2,0,0)) = ((6,1,0)|(1,0,0))+((5,1,0)|(1,0,0))*AB(1)
        ! theta(1164) = theta(837)+theta(753)*AB(1) ! ((5,1,0)|(1,1,0)) = ((6,1,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(1)
        ! theta(1165) = theta(838)+theta(754)*AB(1) ! ((5,1,0)|(1,0,1)) = ((6,1,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(1)
        theta(1166) = theta(843)+theta(753)*AB(2) ! ((5,1,0)|(0,2,0)) = ((5,2,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(2)
        ! theta(1167) = theta(844)+theta(754)*AB(2) ! ((5,1,0)|(0,1,1)) = ((5,2,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(2)
        theta(1168) = theta(847)+theta(754)*AB(3) ! ((5,1,0)|(0,0,2)) = ((5,1,1)|(0,0,1))+((5,1,0)|(0,0,1))*AB(3)
        theta(1169) = theta(839)+theta(755)*AB(1) ! ((5,0,1)|(2,0,0)) = ((6,0,1)|(1,0,0))+((5,0,1)|(1,0,0))*AB(1)
        theta(1170) = theta(840)+theta(756)*AB(1) ! ((5,0,1)|(1,1,0)) = ((6,0,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(1)
        ! theta(1171) = theta(841)+theta(757)*AB(1) ! ((5,0,1)|(1,0,1)) = ((6,0,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(1)
        theta(1172) = theta(846)+theta(756)*AB(2) ! ((5,0,1)|(0,2,0)) = ((5,1,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(2)
        theta(1173) = theta(847)+theta(757)*AB(2) ! ((5,0,1)|(0,1,1)) = ((5,1,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(2)
        theta(1174) = theta(850)+theta(757)*AB(3) ! ((5,0,1)|(0,0,2)) = ((5,0,2)|(0,0,1))+((5,0,1)|(0,0,1))*AB(3)
        theta(1175) = theta(842)+theta(758)*AB(1) ! ((4,2,0)|(2,0,0)) = ((5,2,0)|(1,0,0))+((4,2,0)|(1,0,0))*AB(1)
        ! theta(1176) = theta(843)+theta(759)*AB(1) ! ((4,2,0)|(1,1,0)) = ((5,2,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(1)
        ! theta(1177) = theta(844)+theta(760)*AB(1) ! ((4,2,0)|(1,0,1)) = ((5,2,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(1)
        theta(1178) = theta(852)+theta(759)*AB(2) ! ((4,2,0)|(0,2,0)) = ((4,3,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(2)
        ! theta(1179) = theta(853)+theta(760)*AB(2) ! ((4,2,0)|(0,1,1)) = ((4,3,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(2)
        theta(1180) = theta(856)+theta(760)*AB(3) ! ((4,2,0)|(0,0,2)) = ((4,2,1)|(0,0,1))+((4,2,0)|(0,0,1))*AB(3)
        theta(1181) = theta(845)+theta(761)*AB(1) ! ((4,1,1)|(2,0,0)) = ((5,1,1)|(1,0,0))+((4,1,1)|(1,0,0))*AB(1)
        theta(1182) = theta(846)+theta(762)*AB(1) ! ((4,1,1)|(1,1,0)) = ((5,1,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(1)
        ! theta(1183) = theta(847)+theta(763)*AB(1) ! ((4,1,1)|(1,0,1)) = ((5,1,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(1)
        theta(1184) = theta(855)+theta(762)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1185) = theta(856)+theta(763)*AB(2) ! ((4,1,1)|(0,1,1)) = ((4,2,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(2)
        theta(1186) = theta(859)+theta(763)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1187) = theta(848)+theta(764)*AB(1) ! ((4,0,2)|(2,0,0)) = ((5,0,2)|(1,0,0))+((4,0,2)|(1,0,0))*AB(1)
        theta(1188) = theta(849)+theta(765)*AB(1) ! ((4,0,2)|(1,1,0)) = ((5,0,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(1)
        ! theta(1189) = theta(850)+theta(766)*AB(1) ! ((4,0,2)|(1,0,1)) = ((5,0,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(1)
        theta(1190) = theta(858)+theta(765)*AB(2) ! ((4,0,2)|(0,2,0)) = ((4,1,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(2)
        theta(1191) = theta(859)+theta(766)*AB(2) ! ((4,0,2)|(0,1,1)) = ((4,1,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(2)
        theta(1192) = theta(862)+theta(766)*AB(3) ! ((4,0,2)|(0,0,2)) = ((4,0,3)|(0,0,1))+((4,0,2)|(0,0,1))*AB(3)
        theta(1193) = theta(851)+theta(767)*AB(1) ! ((3,3,0)|(2,0,0)) = ((4,3,0)|(1,0,0))+((3,3,0)|(1,0,0))*AB(1)
        ! theta(1194) = theta(852)+theta(768)*AB(1) ! ((3,3,0)|(1,1,0)) = ((4,3,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(1)
        ! theta(1195) = theta(853)+theta(769)*AB(1) ! ((3,3,0)|(1,0,1)) = ((4,3,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(1)
        theta(1196) = theta(864)+theta(768)*AB(2) ! ((3,3,0)|(0,2,0)) = ((3,4,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(2)
        ! theta(1197) = theta(865)+theta(769)*AB(2) ! ((3,3,0)|(0,1,1)) = ((3,4,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(2)
        theta(1198) = theta(868)+theta(769)*AB(3) ! ((3,3,0)|(0,0,2)) = ((3,3,1)|(0,0,1))+((3,3,0)|(0,0,1))*AB(3)
        theta(1199) = theta(854)+theta(770)*AB(1) ! ((3,2,1)|(2,0,0)) = ((4,2,1)|(1,0,0))+((3,2,1)|(1,0,0))*AB(1)
        theta(1200) = theta(855)+theta(771)*AB(1) ! ((3,2,1)|(1,1,0)) = ((4,2,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(1)
        ! theta(1201) = theta(856)+theta(772)*AB(1) ! ((3,2,1)|(1,0,1)) = ((4,2,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(1)
        theta(1202) = theta(867)+theta(771)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1203) = theta(868)+theta(772)*AB(2) ! ((3,2,1)|(0,1,1)) = ((3,3,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(2)
        theta(1204) = theta(871)+theta(772)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1205) = theta(857)+theta(773)*AB(1) ! ((3,1,2)|(2,0,0)) = ((4,1,2)|(1,0,0))+((3,1,2)|(1,0,0))*AB(1)
        theta(1206) = theta(858)+theta(774)*AB(1) ! ((3,1,2)|(1,1,0)) = ((4,1,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(1)
        ! theta(1207) = theta(859)+theta(775)*AB(1) ! ((3,1,2)|(1,0,1)) = ((4,1,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(1)
        theta(1208) = theta(870)+theta(774)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1209) = theta(871)+theta(775)*AB(2) ! ((3,1,2)|(0,1,1)) = ((3,2,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(2)
        theta(1210) = theta(874)+theta(775)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1211) = theta(860)+theta(776)*AB(1) ! ((3,0,3)|(2,0,0)) = ((4,0,3)|(1,0,0))+((3,0,3)|(1,0,0))*AB(1)
        theta(1212) = theta(861)+theta(777)*AB(1) ! ((3,0,3)|(1,1,0)) = ((4,0,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(1)
        ! theta(1213) = theta(862)+theta(778)*AB(1) ! ((3,0,3)|(1,0,1)) = ((4,0,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(1)
        theta(1214) = theta(873)+theta(777)*AB(2) ! ((3,0,3)|(0,2,0)) = ((3,1,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(2)
        theta(1215) = theta(874)+theta(778)*AB(2) ! ((3,0,3)|(0,1,1)) = ((3,1,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(2)
        theta(1216) = theta(877)+theta(778)*AB(3) ! ((3,0,3)|(0,0,2)) = ((3,0,4)|(0,0,1))+((3,0,3)|(0,0,1))*AB(3)
        theta(1217) = theta(863)+theta(779)*AB(1) ! ((2,4,0)|(2,0,0)) = ((3,4,0)|(1,0,0))+((2,4,0)|(1,0,0))*AB(1)
        ! theta(1218) = theta(864)+theta(780)*AB(1) ! ((2,4,0)|(1,1,0)) = ((3,4,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(1)
        ! theta(1219) = theta(865)+theta(781)*AB(1) ! ((2,4,0)|(1,0,1)) = ((3,4,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(1)
        theta(1220) = theta(879)+theta(780)*AB(2) ! ((2,4,0)|(0,2,0)) = ((2,5,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(2)
        ! theta(1221) = theta(880)+theta(781)*AB(2) ! ((2,4,0)|(0,1,1)) = ((2,5,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(2)
        theta(1222) = theta(883)+theta(781)*AB(3) ! ((2,4,0)|(0,0,2)) = ((2,4,1)|(0,0,1))+((2,4,0)|(0,0,1))*AB(3)
        theta(1223) = theta(866)+theta(782)*AB(1) ! ((2,3,1)|(2,0,0)) = ((3,3,1)|(1,0,0))+((2,3,1)|(1,0,0))*AB(1)
        theta(1224) = theta(867)+theta(783)*AB(1) ! ((2,3,1)|(1,1,0)) = ((3,3,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(1)
        ! theta(1225) = theta(868)+theta(784)*AB(1) ! ((2,3,1)|(1,0,1)) = ((3,3,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(1)
        theta(1226) = theta(882)+theta(783)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1227) = theta(883)+theta(784)*AB(2) ! ((2,3,1)|(0,1,1)) = ((2,4,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(2)
        theta(1228) = theta(886)+theta(784)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1229) = theta(869)+theta(785)*AB(1) ! ((2,2,2)|(2,0,0)) = ((3,2,2)|(1,0,0))+((2,2,2)|(1,0,0))*AB(1)
        theta(1230) = theta(870)+theta(786)*AB(1) ! ((2,2,2)|(1,1,0)) = ((3,2,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(1)
        ! theta(1231) = theta(871)+theta(787)*AB(1) ! ((2,2,2)|(1,0,1)) = ((3,2,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(1)
        theta(1232) = theta(885)+theta(786)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1233) = theta(886)+theta(787)*AB(2) ! ((2,2,2)|(0,1,1)) = ((2,3,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(2)
        theta(1234) = theta(889)+theta(787)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1235) = theta(872)+theta(788)*AB(1) ! ((2,1,3)|(2,0,0)) = ((3,1,3)|(1,0,0))+((2,1,3)|(1,0,0))*AB(1)
        theta(1236) = theta(873)+theta(789)*AB(1) ! ((2,1,3)|(1,1,0)) = ((3,1,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(1)
        ! theta(1237) = theta(874)+theta(790)*AB(1) ! ((2,1,3)|(1,0,1)) = ((3,1,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(1)
        theta(1238) = theta(888)+theta(789)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(1239) = theta(889)+theta(790)*AB(2) ! ((2,1,3)|(0,1,1)) = ((2,2,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(2)
        theta(1240) = theta(892)+theta(790)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1241) = theta(875)+theta(791)*AB(1) ! ((2,0,4)|(2,0,0)) = ((3,0,4)|(1,0,0))+((2,0,4)|(1,0,0))*AB(1)
        theta(1242) = theta(876)+theta(792)*AB(1) ! ((2,0,4)|(1,1,0)) = ((3,0,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(1)
        ! theta(1243) = theta(877)+theta(793)*AB(1) ! ((2,0,4)|(1,0,1)) = ((3,0,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(1)
        theta(1244) = theta(891)+theta(792)*AB(2) ! ((2,0,4)|(0,2,0)) = ((2,1,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(2)
        theta(1245) = theta(892)+theta(793)*AB(2) ! ((2,0,4)|(0,1,1)) = ((2,1,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(2)
        theta(1246) = theta(895)+theta(793)*AB(3) ! ((2,0,4)|(0,0,2)) = ((2,0,5)|(0,0,1))+((2,0,4)|(0,0,1))*AB(3)
        theta(1247) = theta(878)+theta(794)*AB(1) ! ((1,5,0)|(2,0,0)) = ((2,5,0)|(1,0,0))+((1,5,0)|(1,0,0))*AB(1)
        ! theta(1248) = theta(879)+theta(795)*AB(1) ! ((1,5,0)|(1,1,0)) = ((2,5,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(1)
        ! theta(1249) = theta(880)+theta(796)*AB(1) ! ((1,5,0)|(1,0,1)) = ((2,5,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(1)
        theta(1250) = theta(897)+theta(795)*AB(2) ! ((1,5,0)|(0,2,0)) = ((1,6,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(2)
        ! theta(1251) = theta(898)+theta(796)*AB(2) ! ((1,5,0)|(0,1,1)) = ((1,6,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(2)
        theta(1252) = theta(901)+theta(796)*AB(3) ! ((1,5,0)|(0,0,2)) = ((1,5,1)|(0,0,1))+((1,5,0)|(0,0,1))*AB(3)
        theta(1253) = theta(881)+theta(797)*AB(1) ! ((1,4,1)|(2,0,0)) = ((2,4,1)|(1,0,0))+((1,4,1)|(1,0,0))*AB(1)
        ! theta(1254) = theta(882)+theta(798)*AB(1) ! ((1,4,1)|(1,1,0)) = ((2,4,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(1)
        ! theta(1255) = theta(883)+theta(799)*AB(1) ! ((1,4,1)|(1,0,1)) = ((2,4,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(1)
        theta(1256) = theta(900)+theta(798)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        ! theta(1257) = theta(901)+theta(799)*AB(2) ! ((1,4,1)|(0,1,1)) = ((1,5,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(2)
        theta(1258) = theta(904)+theta(799)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(1259) = theta(884)+theta(800)*AB(1) ! ((1,3,2)|(2,0,0)) = ((2,3,2)|(1,0,0))+((1,3,2)|(1,0,0))*AB(1)
        ! theta(1260) = theta(885)+theta(801)*AB(1) ! ((1,3,2)|(1,1,0)) = ((2,3,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(1)
        ! theta(1261) = theta(886)+theta(802)*AB(1) ! ((1,3,2)|(1,0,1)) = ((2,3,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(1)
        theta(1262) = theta(903)+theta(801)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        ! theta(1263) = theta(904)+theta(802)*AB(2) ! ((1,3,2)|(0,1,1)) = ((1,4,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(2)
        theta(1264) = theta(907)+theta(802)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1265) = theta(887)+theta(803)*AB(1) ! ((1,2,3)|(2,0,0)) = ((2,2,3)|(1,0,0))+((1,2,3)|(1,0,0))*AB(1)
        ! theta(1266) = theta(888)+theta(804)*AB(1) ! ((1,2,3)|(1,1,0)) = ((2,2,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(1)
        ! theta(1267) = theta(889)+theta(805)*AB(1) ! ((1,2,3)|(1,0,1)) = ((2,2,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(1)
        theta(1268) = theta(906)+theta(804)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        ! theta(1269) = theta(907)+theta(805)*AB(2) ! ((1,2,3)|(0,1,1)) = ((1,3,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(2)
        theta(1270) = theta(910)+theta(805)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1271) = theta(890)+theta(806)*AB(1) ! ((1,1,4)|(2,0,0)) = ((2,1,4)|(1,0,0))+((1,1,4)|(1,0,0))*AB(1)
        ! theta(1272) = theta(891)+theta(807)*AB(1) ! ((1,1,4)|(1,1,0)) = ((2,1,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(1)
        ! theta(1273) = theta(892)+theta(808)*AB(1) ! ((1,1,4)|(1,0,1)) = ((2,1,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(1)
        theta(1274) = theta(909)+theta(807)*AB(2) ! ((1,1,4)|(0,2,0)) = ((1,2,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(2)
        ! theta(1275) = theta(910)+theta(808)*AB(2) ! ((1,1,4)|(0,1,1)) = ((1,2,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(2)
        theta(1276) = theta(913)+theta(808)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(1277) = theta(893)+theta(809)*AB(1) ! ((1,0,5)|(2,0,0)) = ((2,0,5)|(1,0,0))+((1,0,5)|(1,0,0))*AB(1)
        ! theta(1278) = theta(894)+theta(810)*AB(1) ! ((1,0,5)|(1,1,0)) = ((2,0,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(1)
        ! theta(1279) = theta(895)+theta(811)*AB(1) ! ((1,0,5)|(1,0,1)) = ((2,0,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(1)
        theta(1280) = theta(912)+theta(810)*AB(2) ! ((1,0,5)|(0,2,0)) = ((1,1,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(2)
        ! theta(1281) = theta(913)+theta(811)*AB(2) ! ((1,0,5)|(0,1,1)) = ((1,1,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(2)
        theta(1282) = theta(916)+theta(811)*AB(3) ! ((1,0,5)|(0,0,2)) = ((1,0,6)|(0,0,1))+((1,0,5)|(0,0,1))*AB(3)
        ! theta(1283) = theta(896)+theta(812)*AB(1) ! ((0,6,0)|(2,0,0)) = ((1,6,0)|(1,0,0))+((0,6,0)|(1,0,0))*AB(1)
        ! theta(1284) = theta(897)+theta(813)*AB(1) ! ((0,6,0)|(1,1,0)) = ((1,6,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(1)
        ! theta(1285) = theta(898)+theta(814)*AB(1) ! ((0,6,0)|(1,0,1)) = ((1,6,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(1)
        theta(1286) = theta(918)+theta(813)*AB(2) ! ((0,6,0)|(0,2,0)) = ((0,7,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(2)
        ! theta(1287) = theta(919)+theta(814)*AB(2) ! ((0,6,0)|(0,1,1)) = ((0,7,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(2)
        theta(1288) = theta(922)+theta(814)*AB(3) ! ((0,6,0)|(0,0,2)) = ((0,6,1)|(0,0,1))+((0,6,0)|(0,0,1))*AB(3)
        theta(1289) = theta(899)+theta(815)*AB(1) ! ((0,5,1)|(2,0,0)) = ((1,5,1)|(1,0,0))+((0,5,1)|(1,0,0))*AB(1)
        ! theta(1290) = theta(900)+theta(816)*AB(1) ! ((0,5,1)|(1,1,0)) = ((1,5,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(1)
        ! theta(1291) = theta(901)+theta(817)*AB(1) ! ((0,5,1)|(1,0,1)) = ((1,5,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(1)
        theta(1292) = theta(921)+theta(816)*AB(2) ! ((0,5,1)|(0,2,0)) = ((0,6,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(2)
        ! theta(1293) = theta(922)+theta(817)*AB(2) ! ((0,5,1)|(0,1,1)) = ((0,6,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(2)
        theta(1294) = theta(925)+theta(817)*AB(3) ! ((0,5,1)|(0,0,2)) = ((0,5,2)|(0,0,1))+((0,5,1)|(0,0,1))*AB(3)
        ! theta(1295) = theta(902)+theta(818)*AB(1) ! ((0,4,2)|(2,0,0)) = ((1,4,2)|(1,0,0))+((0,4,2)|(1,0,0))*AB(1)
        ! theta(1296) = theta(903)+theta(819)*AB(1) ! ((0,4,2)|(1,1,0)) = ((1,4,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(1)
        ! theta(1297) = theta(904)+theta(820)*AB(1) ! ((0,4,2)|(1,0,1)) = ((1,4,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(1)
        theta(1298) = theta(924)+theta(819)*AB(2) ! ((0,4,2)|(0,2,0)) = ((0,5,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(2)
        ! theta(1299) = theta(925)+theta(820)*AB(2) ! ((0,4,2)|(0,1,1)) = ((0,5,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(2)
        theta(1300) = theta(928)+theta(820)*AB(3) ! ((0,4,2)|(0,0,2)) = ((0,4,3)|(0,0,1))+((0,4,2)|(0,0,1))*AB(3)
        ! theta(1301) = theta(905)+theta(821)*AB(1) ! ((0,3,3)|(2,0,0)) = ((1,3,3)|(1,0,0))+((0,3,3)|(1,0,0))*AB(1)
        ! theta(1302) = theta(906)+theta(822)*AB(1) ! ((0,3,3)|(1,1,0)) = ((1,3,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(1)
        ! theta(1303) = theta(907)+theta(823)*AB(1) ! ((0,3,3)|(1,0,1)) = ((1,3,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(1)
        theta(1304) = theta(927)+theta(822)*AB(2) ! ((0,3,3)|(0,2,0)) = ((0,4,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(2)
        ! theta(1305) = theta(928)+theta(823)*AB(2) ! ((0,3,3)|(0,1,1)) = ((0,4,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(2)
        theta(1306) = theta(931)+theta(823)*AB(3) ! ((0,3,3)|(0,0,2)) = ((0,3,4)|(0,0,1))+((0,3,3)|(0,0,1))*AB(3)
        ! theta(1307) = theta(908)+theta(824)*AB(1) ! ((0,2,4)|(2,0,0)) = ((1,2,4)|(1,0,0))+((0,2,4)|(1,0,0))*AB(1)
        ! theta(1308) = theta(909)+theta(825)*AB(1) ! ((0,2,4)|(1,1,0)) = ((1,2,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(1)
        ! theta(1309) = theta(910)+theta(826)*AB(1) ! ((0,2,4)|(1,0,1)) = ((1,2,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(1)
        theta(1310) = theta(930)+theta(825)*AB(2) ! ((0,2,4)|(0,2,0)) = ((0,3,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(2)
        ! theta(1311) = theta(931)+theta(826)*AB(2) ! ((0,2,4)|(0,1,1)) = ((0,3,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(2)
        theta(1312) = theta(934)+theta(826)*AB(3) ! ((0,2,4)|(0,0,2)) = ((0,2,5)|(0,0,1))+((0,2,4)|(0,0,1))*AB(3)
        ! theta(1313) = theta(911)+theta(827)*AB(1) ! ((0,1,5)|(2,0,0)) = ((1,1,5)|(1,0,0))+((0,1,5)|(1,0,0))*AB(1)
        ! theta(1314) = theta(912)+theta(828)*AB(1) ! ((0,1,5)|(1,1,0)) = ((1,1,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(1)
        ! theta(1315) = theta(913)+theta(829)*AB(1) ! ((0,1,5)|(1,0,1)) = ((1,1,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(1)
        theta(1316) = theta(933)+theta(828)*AB(2) ! ((0,1,5)|(0,2,0)) = ((0,2,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(2)
        ! theta(1317) = theta(934)+theta(829)*AB(2) ! ((0,1,5)|(0,1,1)) = ((0,2,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(2)
        theta(1318) = theta(937)+theta(829)*AB(3) ! ((0,1,5)|(0,0,2)) = ((0,1,6)|(0,0,1))+((0,1,5)|(0,0,1))*AB(3)
        ! theta(1319) = theta(914)+theta(830)*AB(1) ! ((0,0,6)|(2,0,0)) = ((1,0,6)|(1,0,0))+((0,0,6)|(1,0,0))*AB(1)
        ! theta(1320) = theta(915)+theta(831)*AB(1) ! ((0,0,6)|(1,1,0)) = ((1,0,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(1)
        ! theta(1321) = theta(916)+theta(832)*AB(1) ! ((0,0,6)|(1,0,1)) = ((1,0,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(1)
        ! theta(1322) = theta(936)+theta(831)*AB(2) ! ((0,0,6)|(0,2,0)) = ((0,1,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(2)
        ! theta(1323) = theta(937)+theta(832)*AB(2) ! ((0,0,6)|(0,1,1)) = ((0,1,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(2)
        theta(1324) = theta(940)+theta(832)*AB(3) ! ((0,0,6)|(0,0,2)) = ((0,0,7)|(0,0,1))+((0,0,6)|(0,0,1))*AB(3)
        theta(1325) = theta(1031)+theta(941)*AB(1) ! ((4,0,0)|(3,0,0)) = ((5,0,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(1)
        ! theta(1326) = theta(1037)+theta(941)*AB(2) ! ((4,0,0)|(2,1,0)) = ((4,1,0)|(2,0,0))+((4,0,0)|(2,0,0))*AB(2)
        theta(1327) = theta(1043)+theta(941)*AB(3) ! ((4,0,0)|(2,0,1)) = ((4,0,1)|(2,0,0))+((4,0,0)|(2,0,0))*AB(3)
        theta(1328) = theta(1034)+theta(944)*AB(1) ! ((4,0,0)|(1,2,0)) = ((5,0,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(1)
        ! theta(1329) = theta(1035)+theta(945)*AB(1) ! ((4,0,0)|(1,1,1)) = ((5,0,0)|(0,1,1))+((4,0,0)|(0,1,1))*AB(1)
        theta(1330) = theta(1036)+theta(946)*AB(1) ! ((4,0,0)|(1,0,2)) = ((5,0,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(1)
        theta(1331) = theta(1040)+theta(944)*AB(2) ! ((4,0,0)|(0,3,0)) = ((4,1,0)|(0,2,0))+((4,0,0)|(0,2,0))*AB(2)
        theta(1332) = theta(1046)+theta(944)*AB(3) ! ((4,0,0)|(0,2,1)) = ((4,0,1)|(0,2,0))+((4,0,0)|(0,2,0))*AB(3)
        theta(1333) = theta(1042)+theta(946)*AB(2) ! ((4,0,0)|(0,1,2)) = ((4,1,0)|(0,0,2))+((4,0,0)|(0,0,2))*AB(2)
        theta(1334) = theta(1048)+theta(946)*AB(3) ! ((4,0,0)|(0,0,3)) = ((4,0,1)|(0,0,2))+((4,0,0)|(0,0,2))*AB(3)
        theta(1335) = theta(1037)+theta(947)*AB(1) ! ((3,1,0)|(3,0,0)) = ((4,1,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(1)
        ! theta(1336) = theta(1049)+theta(947)*AB(2) ! ((3,1,0)|(2,1,0)) = ((3,2,0)|(2,0,0))+((3,1,0)|(2,0,0))*AB(2)
        theta(1337) = theta(1055)+theta(947)*AB(3) ! ((3,1,0)|(2,0,1)) = ((3,1,1)|(2,0,0))+((3,1,0)|(2,0,0))*AB(3)
        theta(1338) = theta(1040)+theta(950)*AB(1) ! ((3,1,0)|(1,2,0)) = ((4,1,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(1)
        ! theta(1339) = theta(1041)+theta(951)*AB(1) ! ((3,1,0)|(1,1,1)) = ((4,1,0)|(0,1,1))+((3,1,0)|(0,1,1))*AB(1)
        theta(1340) = theta(1042)+theta(952)*AB(1) ! ((3,1,0)|(1,0,2)) = ((4,1,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(1)
        theta(1341) = theta(1052)+theta(950)*AB(2) ! ((3,1,0)|(0,3,0)) = ((3,2,0)|(0,2,0))+((3,1,0)|(0,2,0))*AB(2)
        theta(1342) = theta(1058)+theta(950)*AB(3) ! ((3,1,0)|(0,2,1)) = ((3,1,1)|(0,2,0))+((3,1,0)|(0,2,0))*AB(3)
        theta(1343) = theta(1054)+theta(952)*AB(2) ! ((3,1,0)|(0,1,2)) = ((3,2,0)|(0,0,2))+((3,1,0)|(0,0,2))*AB(2)
        theta(1344) = theta(1060)+theta(952)*AB(3) ! ((3,1,0)|(0,0,3)) = ((3,1,1)|(0,0,2))+((3,1,0)|(0,0,2))*AB(3)
        theta(1345) = theta(1043)+theta(953)*AB(1) ! ((3,0,1)|(3,0,0)) = ((4,0,1)|(2,0,0))+((3,0,1)|(2,0,0))*AB(1)
        theta(1346) = theta(1044)+theta(954)*AB(1) ! ((3,0,1)|(2,1,0)) = ((4,0,1)|(1,1,0))+((3,0,1)|(1,1,0))*AB(1)
        ! theta(1347) = theta(1061)+theta(953)*AB(3) ! ((3,0,1)|(2,0,1)) = ((3,0,2)|(2,0,0))+((3,0,1)|(2,0,0))*AB(3)
        theta(1348) = theta(1046)+theta(956)*AB(1) ! ((3,0,1)|(1,2,0)) = ((4,0,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(1)
        theta(1349) = theta(1047)+theta(957)*AB(1) ! ((3,0,1)|(1,1,1)) = ((4,0,1)|(0,1,1))+((3,0,1)|(0,1,1))*AB(1)
        theta(1350) = theta(1048)+theta(958)*AB(1) ! ((3,0,1)|(1,0,2)) = ((4,0,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(1)
        theta(1351) = theta(1058)+theta(956)*AB(2) ! ((3,0,1)|(0,3,0)) = ((3,1,1)|(0,2,0))+((3,0,1)|(0,2,0))*AB(2)
        theta(1352) = theta(1064)+theta(956)*AB(3) ! ((3,0,1)|(0,2,1)) = ((3,0,2)|(0,2,0))+((3,0,1)|(0,2,0))*AB(3)
        theta(1353) = theta(1060)+theta(958)*AB(2) ! ((3,0,1)|(0,1,2)) = ((3,1,1)|(0,0,2))+((3,0,1)|(0,0,2))*AB(2)
        theta(1354) = theta(1066)+theta(958)*AB(3) ! ((3,0,1)|(0,0,3)) = ((3,0,2)|(0,0,2))+((3,0,1)|(0,0,2))*AB(3)
        theta(1355) = theta(1049)+theta(959)*AB(1) ! ((2,2,0)|(3,0,0)) = ((3,2,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(1)
        ! theta(1356) = theta(1067)+theta(959)*AB(2) ! ((2,2,0)|(2,1,0)) = ((2,3,0)|(2,0,0))+((2,2,0)|(2,0,0))*AB(2)
        theta(1357) = theta(1073)+theta(959)*AB(3) ! ((2,2,0)|(2,0,1)) = ((2,2,1)|(2,0,0))+((2,2,0)|(2,0,0))*AB(3)
        theta(1358) = theta(1052)+theta(962)*AB(1) ! ((2,2,0)|(1,2,0)) = ((3,2,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(1)
        ! theta(1359) = theta(1053)+theta(963)*AB(1) ! ((2,2,0)|(1,1,1)) = ((3,2,0)|(0,1,1))+((2,2,0)|(0,1,1))*AB(1)
        theta(1360) = theta(1054)+theta(964)*AB(1) ! ((2,2,0)|(1,0,2)) = ((3,2,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(1)
        theta(1361) = theta(1070)+theta(962)*AB(2) ! ((2,2,0)|(0,3,0)) = ((2,3,0)|(0,2,0))+((2,2,0)|(0,2,0))*AB(2)
        theta(1362) = theta(1076)+theta(962)*AB(3) ! ((2,2,0)|(0,2,1)) = ((2,2,1)|(0,2,0))+((2,2,0)|(0,2,0))*AB(3)
        theta(1363) = theta(1072)+theta(964)*AB(2) ! ((2,2,0)|(0,1,2)) = ((2,3,0)|(0,0,2))+((2,2,0)|(0,0,2))*AB(2)
        theta(1364) = theta(1078)+theta(964)*AB(3) ! ((2,2,0)|(0,0,3)) = ((2,2,1)|(0,0,2))+((2,2,0)|(0,0,2))*AB(3)
        theta(1365) = theta(1055)+theta(965)*AB(1) ! ((2,1,1)|(3,0,0)) = ((3,1,1)|(2,0,0))+((2,1,1)|(2,0,0))*AB(1)
        theta(1366) = theta(1056)+theta(966)*AB(1) ! ((2,1,1)|(2,1,0)) = ((3,1,1)|(1,1,0))+((2,1,1)|(1,1,0))*AB(1)
        ! theta(1367) = theta(1079)+theta(965)*AB(3) ! ((2,1,1)|(2,0,1)) = ((2,1,2)|(2,0,0))+((2,1,1)|(2,0,0))*AB(3)
        theta(1368) = theta(1058)+theta(968)*AB(1) ! ((2,1,1)|(1,2,0)) = ((3,1,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(1)
        theta(1369) = theta(1059)+theta(969)*AB(1) ! ((2,1,1)|(1,1,1)) = ((3,1,1)|(0,1,1))+((2,1,1)|(0,1,1))*AB(1)
        theta(1370) = theta(1060)+theta(970)*AB(1) ! ((2,1,1)|(1,0,2)) = ((3,1,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(1)
        theta(1371) = theta(1076)+theta(968)*AB(2) ! ((2,1,1)|(0,3,0)) = ((2,2,1)|(0,2,0))+((2,1,1)|(0,2,0))*AB(2)
        theta(1372) = theta(1082)+theta(968)*AB(3) ! ((2,1,1)|(0,2,1)) = ((2,1,2)|(0,2,0))+((2,1,1)|(0,2,0))*AB(3)
        theta(1373) = theta(1078)+theta(970)*AB(2) ! ((2,1,1)|(0,1,2)) = ((2,2,1)|(0,0,2))+((2,1,1)|(0,0,2))*AB(2)
        theta(1374) = theta(1084)+theta(970)*AB(3) ! ((2,1,1)|(0,0,3)) = ((2,1,2)|(0,0,2))+((2,1,1)|(0,0,2))*AB(3)
        theta(1375) = theta(1061)+theta(971)*AB(1) ! ((2,0,2)|(3,0,0)) = ((3,0,2)|(2,0,0))+((2,0,2)|(2,0,0))*AB(1)
        theta(1376) = theta(1062)+theta(972)*AB(1) ! ((2,0,2)|(2,1,0)) = ((3,0,2)|(1,1,0))+((2,0,2)|(1,1,0))*AB(1)
        ! theta(1377) = theta(1085)+theta(971)*AB(3) ! ((2,0,2)|(2,0,1)) = ((2,0,3)|(2,0,0))+((2,0,2)|(2,0,0))*AB(3)
        theta(1378) = theta(1064)+theta(974)*AB(1) ! ((2,0,2)|(1,2,0)) = ((3,0,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(1)
        theta(1379) = theta(1065)+theta(975)*AB(1) ! ((2,0,2)|(1,1,1)) = ((3,0,2)|(0,1,1))+((2,0,2)|(0,1,1))*AB(1)
        theta(1380) = theta(1066)+theta(976)*AB(1) ! ((2,0,2)|(1,0,2)) = ((3,0,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(1)
        theta(1381) = theta(1082)+theta(974)*AB(2) ! ((2,0,2)|(0,3,0)) = ((2,1,2)|(0,2,0))+((2,0,2)|(0,2,0))*AB(2)
        theta(1382) = theta(1088)+theta(974)*AB(3) ! ((2,0,2)|(0,2,1)) = ((2,0,3)|(0,2,0))+((2,0,2)|(0,2,0))*AB(3)
        theta(1383) = theta(1084)+theta(976)*AB(2) ! ((2,0,2)|(0,1,2)) = ((2,1,2)|(0,0,2))+((2,0,2)|(0,0,2))*AB(2)
        theta(1384) = theta(1090)+theta(976)*AB(3) ! ((2,0,2)|(0,0,3)) = ((2,0,3)|(0,0,2))+((2,0,2)|(0,0,2))*AB(3)
        theta(1385) = theta(1067)+theta(977)*AB(1) ! ((1,3,0)|(3,0,0)) = ((2,3,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(1)
        ! theta(1386) = theta(1091)+theta(977)*AB(2) ! ((1,3,0)|(2,1,0)) = ((1,4,0)|(2,0,0))+((1,3,0)|(2,0,0))*AB(2)
        theta(1387) = theta(1097)+theta(977)*AB(3) ! ((1,3,0)|(2,0,1)) = ((1,3,1)|(2,0,0))+((1,3,0)|(2,0,0))*AB(3)
        theta(1388) = theta(1070)+theta(980)*AB(1) ! ((1,3,0)|(1,2,0)) = ((2,3,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(1)
        ! theta(1389) = theta(1071)+theta(981)*AB(1) ! ((1,3,0)|(1,1,1)) = ((2,3,0)|(0,1,1))+((1,3,0)|(0,1,1))*AB(1)
        theta(1390) = theta(1072)+theta(982)*AB(1) ! ((1,3,0)|(1,0,2)) = ((2,3,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(1)
        theta(1391) = theta(1094)+theta(980)*AB(2) ! ((1,3,0)|(0,3,0)) = ((1,4,0)|(0,2,0))+((1,3,0)|(0,2,0))*AB(2)
        theta(1392) = theta(1100)+theta(980)*AB(3) ! ((1,3,0)|(0,2,1)) = ((1,3,1)|(0,2,0))+((1,3,0)|(0,2,0))*AB(3)
        theta(1393) = theta(1096)+theta(982)*AB(2) ! ((1,3,0)|(0,1,2)) = ((1,4,0)|(0,0,2))+((1,3,0)|(0,0,2))*AB(2)
        theta(1394) = theta(1102)+theta(982)*AB(3) ! ((1,3,0)|(0,0,3)) = ((1,3,1)|(0,0,2))+((1,3,0)|(0,0,2))*AB(3)
        theta(1395) = theta(1073)+theta(983)*AB(1) ! ((1,2,1)|(3,0,0)) = ((2,2,1)|(2,0,0))+((1,2,1)|(2,0,0))*AB(1)
        theta(1396) = theta(1074)+theta(984)*AB(1) ! ((1,2,1)|(2,1,0)) = ((2,2,1)|(1,1,0))+((1,2,1)|(1,1,0))*AB(1)
        ! theta(1397) = theta(1103)+theta(983)*AB(3) ! ((1,2,1)|(2,0,1)) = ((1,2,2)|(2,0,0))+((1,2,1)|(2,0,0))*AB(3)
        theta(1398) = theta(1076)+theta(986)*AB(1) ! ((1,2,1)|(1,2,0)) = ((2,2,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(1)
        theta(1399) = theta(1077)+theta(987)*AB(1) ! ((1,2,1)|(1,1,1)) = ((2,2,1)|(0,1,1))+((1,2,1)|(0,1,1))*AB(1)
        theta(1400) = theta(1078)+theta(988)*AB(1) ! ((1,2,1)|(1,0,2)) = ((2,2,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(1)
        theta(1401) = theta(1100)+theta(986)*AB(2) ! ((1,2,1)|(0,3,0)) = ((1,3,1)|(0,2,0))+((1,2,1)|(0,2,0))*AB(2)
        theta(1402) = theta(1106)+theta(986)*AB(3) ! ((1,2,1)|(0,2,1)) = ((1,2,2)|(0,2,0))+((1,2,1)|(0,2,0))*AB(3)
        theta(1403) = theta(1102)+theta(988)*AB(2) ! ((1,2,1)|(0,1,2)) = ((1,3,1)|(0,0,2))+((1,2,1)|(0,0,2))*AB(2)
        theta(1404) = theta(1108)+theta(988)*AB(3) ! ((1,2,1)|(0,0,3)) = ((1,2,2)|(0,0,2))+((1,2,1)|(0,0,2))*AB(3)
        theta(1405) = theta(1079)+theta(989)*AB(1) ! ((1,1,2)|(3,0,0)) = ((2,1,2)|(2,0,0))+((1,1,2)|(2,0,0))*AB(1)
        theta(1406) = theta(1080)+theta(990)*AB(1) ! ((1,1,2)|(2,1,0)) = ((2,1,2)|(1,1,0))+((1,1,2)|(1,1,0))*AB(1)
        ! theta(1407) = theta(1109)+theta(989)*AB(3) ! ((1,1,2)|(2,0,1)) = ((1,1,3)|(2,0,0))+((1,1,2)|(2,0,0))*AB(3)
        theta(1408) = theta(1082)+theta(992)*AB(1) ! ((1,1,2)|(1,2,0)) = ((2,1,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(1)
        theta(1409) = theta(1083)+theta(993)*AB(1) ! ((1,1,2)|(1,1,1)) = ((2,1,2)|(0,1,1))+((1,1,2)|(0,1,1))*AB(1)
        theta(1410) = theta(1084)+theta(994)*AB(1) ! ((1,1,2)|(1,0,2)) = ((2,1,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(1)
        theta(1411) = theta(1106)+theta(992)*AB(2) ! ((1,1,2)|(0,3,0)) = ((1,2,2)|(0,2,0))+((1,1,2)|(0,2,0))*AB(2)
        theta(1412) = theta(1112)+theta(992)*AB(3) ! ((1,1,2)|(0,2,1)) = ((1,1,3)|(0,2,0))+((1,1,2)|(0,2,0))*AB(3)
        theta(1413) = theta(1108)+theta(994)*AB(2) ! ((1,1,2)|(0,1,2)) = ((1,2,2)|(0,0,2))+((1,1,2)|(0,0,2))*AB(2)
        theta(1414) = theta(1114)+theta(994)*AB(3) ! ((1,1,2)|(0,0,3)) = ((1,1,3)|(0,0,2))+((1,1,2)|(0,0,2))*AB(3)
        theta(1415) = theta(1085)+theta(995)*AB(1) ! ((1,0,3)|(3,0,0)) = ((2,0,3)|(2,0,0))+((1,0,3)|(2,0,0))*AB(1)
        theta(1416) = theta(1086)+theta(996)*AB(1) ! ((1,0,3)|(2,1,0)) = ((2,0,3)|(1,1,0))+((1,0,3)|(1,1,0))*AB(1)
        ! theta(1417) = theta(1115)+theta(995)*AB(3) ! ((1,0,3)|(2,0,1)) = ((1,0,4)|(2,0,0))+((1,0,3)|(2,0,0))*AB(3)
        theta(1418) = theta(1088)+theta(998)*AB(1) ! ((1,0,3)|(1,2,0)) = ((2,0,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(1)
        theta(1419) = theta(1089)+theta(999)*AB(1) ! ((1,0,3)|(1,1,1)) = ((2,0,3)|(0,1,1))+((1,0,3)|(0,1,1))*AB(1)
        theta(1420) = theta(1090)+theta(1000)*AB(1) ! ((1,0,3)|(1,0,2)) = ((2,0,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(1)
        theta(1421) = theta(1112)+theta(998)*AB(2) ! ((1,0,3)|(0,3,0)) = ((1,1,3)|(0,2,0))+((1,0,3)|(0,2,0))*AB(2)
        theta(1422) = theta(1118)+theta(998)*AB(3) ! ((1,0,3)|(0,2,1)) = ((1,0,4)|(0,2,0))+((1,0,3)|(0,2,0))*AB(3)
        theta(1423) = theta(1114)+theta(1000)*AB(2) ! ((1,0,3)|(0,1,2)) = ((1,1,3)|(0,0,2))+((1,0,3)|(0,0,2))*AB(2)
        theta(1424) = theta(1120)+theta(1000)*AB(3) ! ((1,0,3)|(0,0,3)) = ((1,0,4)|(0,0,2))+((1,0,3)|(0,0,2))*AB(3)
        theta(1425) = theta(1091)+theta(1001)*AB(1) ! ((0,4,0)|(3,0,0)) = ((1,4,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(1)
        ! theta(1426) = theta(1121)+theta(1001)*AB(2) ! ((0,4,0)|(2,1,0)) = ((0,5,0)|(2,0,0))+((0,4,0)|(2,0,0))*AB(2)
        theta(1427) = theta(1127)+theta(1001)*AB(3) ! ((0,4,0)|(2,0,1)) = ((0,4,1)|(2,0,0))+((0,4,0)|(2,0,0))*AB(3)
        theta(1428) = theta(1094)+theta(1004)*AB(1) ! ((0,4,0)|(1,2,0)) = ((1,4,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(1)
        ! theta(1429) = theta(1095)+theta(1005)*AB(1) ! ((0,4,0)|(1,1,1)) = ((1,4,0)|(0,1,1))+((0,4,0)|(0,1,1))*AB(1)
        theta(1430) = theta(1096)+theta(1006)*AB(1) ! ((0,4,0)|(1,0,2)) = ((1,4,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(1)
        theta(1431) = theta(1124)+theta(1004)*AB(2) ! ((0,4,0)|(0,3,0)) = ((0,5,0)|(0,2,0))+((0,4,0)|(0,2,0))*AB(2)
        theta(1432) = theta(1130)+theta(1004)*AB(3) ! ((0,4,0)|(0,2,1)) = ((0,4,1)|(0,2,0))+((0,4,0)|(0,2,0))*AB(3)
        theta(1433) = theta(1126)+theta(1006)*AB(2) ! ((0,4,0)|(0,1,2)) = ((0,5,0)|(0,0,2))+((0,4,0)|(0,0,2))*AB(2)
        theta(1434) = theta(1132)+theta(1006)*AB(3) ! ((0,4,0)|(0,0,3)) = ((0,4,1)|(0,0,2))+((0,4,0)|(0,0,2))*AB(3)
        theta(1435) = theta(1097)+theta(1007)*AB(1) ! ((0,3,1)|(3,0,0)) = ((1,3,1)|(2,0,0))+((0,3,1)|(2,0,0))*AB(1)
        theta(1436) = theta(1098)+theta(1008)*AB(1) ! ((0,3,1)|(2,1,0)) = ((1,3,1)|(1,1,0))+((0,3,1)|(1,1,0))*AB(1)
        ! theta(1437) = theta(1133)+theta(1007)*AB(3) ! ((0,3,1)|(2,0,1)) = ((0,3,2)|(2,0,0))+((0,3,1)|(2,0,0))*AB(3)
        theta(1438) = theta(1100)+theta(1010)*AB(1) ! ((0,3,1)|(1,2,0)) = ((1,3,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(1)
        theta(1439) = theta(1101)+theta(1011)*AB(1) ! ((0,3,1)|(1,1,1)) = ((1,3,1)|(0,1,1))+((0,3,1)|(0,1,1))*AB(1)
        theta(1440) = theta(1102)+theta(1012)*AB(1) ! ((0,3,1)|(1,0,2)) = ((1,3,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(1)
        theta(1441) = theta(1130)+theta(1010)*AB(2) ! ((0,3,1)|(0,3,0)) = ((0,4,1)|(0,2,0))+((0,3,1)|(0,2,0))*AB(2)
        theta(1442) = theta(1136)+theta(1010)*AB(3) ! ((0,3,1)|(0,2,1)) = ((0,3,2)|(0,2,0))+((0,3,1)|(0,2,0))*AB(3)
        theta(1443) = theta(1132)+theta(1012)*AB(2) ! ((0,3,1)|(0,1,2)) = ((0,4,1)|(0,0,2))+((0,3,1)|(0,0,2))*AB(2)
        theta(1444) = theta(1138)+theta(1012)*AB(3) ! ((0,3,1)|(0,0,3)) = ((0,3,2)|(0,0,2))+((0,3,1)|(0,0,2))*AB(3)
        theta(1445) = theta(1103)+theta(1013)*AB(1) ! ((0,2,2)|(3,0,0)) = ((1,2,2)|(2,0,0))+((0,2,2)|(2,0,0))*AB(1)
        theta(1446) = theta(1104)+theta(1014)*AB(1) ! ((0,2,2)|(2,1,0)) = ((1,2,2)|(1,1,0))+((0,2,2)|(1,1,0))*AB(1)
        ! theta(1447) = theta(1139)+theta(1013)*AB(3) ! ((0,2,2)|(2,0,1)) = ((0,2,3)|(2,0,0))+((0,2,2)|(2,0,0))*AB(3)
        theta(1448) = theta(1106)+theta(1016)*AB(1) ! ((0,2,2)|(1,2,0)) = ((1,2,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(1)
        theta(1449) = theta(1107)+theta(1017)*AB(1) ! ((0,2,2)|(1,1,1)) = ((1,2,2)|(0,1,1))+((0,2,2)|(0,1,1))*AB(1)
        theta(1450) = theta(1108)+theta(1018)*AB(1) ! ((0,2,2)|(1,0,2)) = ((1,2,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(1)
        theta(1451) = theta(1136)+theta(1016)*AB(2) ! ((0,2,2)|(0,3,0)) = ((0,3,2)|(0,2,0))+((0,2,2)|(0,2,0))*AB(2)
        theta(1452) = theta(1142)+theta(1016)*AB(3) ! ((0,2,2)|(0,2,1)) = ((0,2,3)|(0,2,0))+((0,2,2)|(0,2,0))*AB(3)
        theta(1453) = theta(1138)+theta(1018)*AB(2) ! ((0,2,2)|(0,1,2)) = ((0,3,2)|(0,0,2))+((0,2,2)|(0,0,2))*AB(2)
        theta(1454) = theta(1144)+theta(1018)*AB(3) ! ((0,2,2)|(0,0,3)) = ((0,2,3)|(0,0,2))+((0,2,2)|(0,0,2))*AB(3)
        theta(1455) = theta(1109)+theta(1019)*AB(1) ! ((0,1,3)|(3,0,0)) = ((1,1,3)|(2,0,0))+((0,1,3)|(2,0,0))*AB(1)
        theta(1456) = theta(1110)+theta(1020)*AB(1) ! ((0,1,3)|(2,1,0)) = ((1,1,3)|(1,1,0))+((0,1,3)|(1,1,0))*AB(1)
        ! theta(1457) = theta(1145)+theta(1019)*AB(3) ! ((0,1,3)|(2,0,1)) = ((0,1,4)|(2,0,0))+((0,1,3)|(2,0,0))*AB(3)
        theta(1458) = theta(1112)+theta(1022)*AB(1) ! ((0,1,3)|(1,2,0)) = ((1,1,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(1)
        theta(1459) = theta(1113)+theta(1023)*AB(1) ! ((0,1,3)|(1,1,1)) = ((1,1,3)|(0,1,1))+((0,1,3)|(0,1,1))*AB(1)
        theta(1460) = theta(1114)+theta(1024)*AB(1) ! ((0,1,3)|(1,0,2)) = ((1,1,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(1)
        theta(1461) = theta(1142)+theta(1022)*AB(2) ! ((0,1,3)|(0,3,0)) = ((0,2,3)|(0,2,0))+((0,1,3)|(0,2,0))*AB(2)
        theta(1462) = theta(1148)+theta(1022)*AB(3) ! ((0,1,3)|(0,2,1)) = ((0,1,4)|(0,2,0))+((0,1,3)|(0,2,0))*AB(3)
        theta(1463) = theta(1144)+theta(1024)*AB(2) ! ((0,1,3)|(0,1,2)) = ((0,2,3)|(0,0,2))+((0,1,3)|(0,0,2))*AB(2)
        theta(1464) = theta(1150)+theta(1024)*AB(3) ! ((0,1,3)|(0,0,3)) = ((0,1,4)|(0,0,2))+((0,1,3)|(0,0,2))*AB(3)
        theta(1465) = theta(1115)+theta(1025)*AB(1) ! ((0,0,4)|(3,0,0)) = ((1,0,4)|(2,0,0))+((0,0,4)|(2,0,0))*AB(1)
        theta(1466) = theta(1116)+theta(1026)*AB(1) ! ((0,0,4)|(2,1,0)) = ((1,0,4)|(1,1,0))+((0,0,4)|(1,1,0))*AB(1)
        ! theta(1467) = theta(1151)+theta(1025)*AB(3) ! ((0,0,4)|(2,0,1)) = ((0,0,5)|(2,0,0))+((0,0,4)|(2,0,0))*AB(3)
        theta(1468) = theta(1118)+theta(1028)*AB(1) ! ((0,0,4)|(1,2,0)) = ((1,0,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(1)
        theta(1469) = theta(1119)+theta(1029)*AB(1) ! ((0,0,4)|(1,1,1)) = ((1,0,4)|(0,1,1))+((0,0,4)|(0,1,1))*AB(1)
        theta(1470) = theta(1120)+theta(1030)*AB(1) ! ((0,0,4)|(1,0,2)) = ((1,0,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(1)
        theta(1471) = theta(1148)+theta(1028)*AB(2) ! ((0,0,4)|(0,3,0)) = ((0,1,4)|(0,2,0))+((0,0,4)|(0,2,0))*AB(2)
        theta(1472) = theta(1154)+theta(1028)*AB(3) ! ((0,0,4)|(0,2,1)) = ((0,0,5)|(0,2,0))+((0,0,4)|(0,2,0))*AB(3)
        theta(1473) = theta(1150)+theta(1030)*AB(2) ! ((0,0,4)|(0,1,2)) = ((0,1,4)|(0,0,2))+((0,0,4)|(0,0,2))*AB(2)
        theta(1474) = theta(1156)+theta(1030)*AB(3) ! ((0,0,4)|(0,0,3)) = ((0,0,5)|(0,0,2))+((0,0,4)|(0,0,2))*AB(3)
        theta(1475) = theta(1157)+theta(1031)*AB(1) ! ((5,0,0)|(3,0,0)) = ((6,0,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(1)
        ! theta(1476) = theta(1163)+theta(1031)*AB(2) ! ((5,0,0)|(2,1,0)) = ((5,1,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(2)
        ! theta(1477) = theta(1169)+theta(1031)*AB(3) ! ((5,0,0)|(2,0,1)) = ((5,0,1)|(2,0,0))+((5,0,0)|(2,0,0))*AB(3)
        theta(1478) = theta(1160)+theta(1034)*AB(1) ! ((5,0,0)|(1,2,0)) = ((6,0,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(1)
        ! theta(1479) = theta(1161)+theta(1035)*AB(1) ! ((5,0,0)|(1,1,1)) = ((6,0,0)|(0,1,1))+((5,0,0)|(0,1,1))*AB(1)
        theta(1480) = theta(1162)+theta(1036)*AB(1) ! ((5,0,0)|(1,0,2)) = ((6,0,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(1)
        theta(1481) = theta(1166)+theta(1034)*AB(2) ! ((5,0,0)|(0,3,0)) = ((5,1,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(2)
        theta(1482) = theta(1172)+theta(1034)*AB(3) ! ((5,0,0)|(0,2,1)) = ((5,0,1)|(0,2,0))+((5,0,0)|(0,2,0))*AB(3)
        theta(1483) = theta(1168)+theta(1036)*AB(2) ! ((5,0,0)|(0,1,2)) = ((5,1,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(2)
        theta(1484) = theta(1174)+theta(1036)*AB(3) ! ((5,0,0)|(0,0,3)) = ((5,0,1)|(0,0,2))+((5,0,0)|(0,0,2))*AB(3)
        theta(1485) = theta(1163)+theta(1037)*AB(1) ! ((4,1,0)|(3,0,0)) = ((5,1,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(1)
        ! theta(1486) = theta(1175)+theta(1037)*AB(2) ! ((4,1,0)|(2,1,0)) = ((4,2,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(2)
        theta(1487) = theta(1181)+theta(1037)*AB(3) ! ((4,1,0)|(2,0,1)) = ((4,1,1)|(2,0,0))+((4,1,0)|(2,0,0))*AB(3)
        theta(1488) = theta(1166)+theta(1040)*AB(1) ! ((4,1,0)|(1,2,0)) = ((5,1,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(1)
        ! theta(1489) = theta(1167)+theta(1041)*AB(1) ! ((4,1,0)|(1,1,1)) = ((5,1,0)|(0,1,1))+((4,1,0)|(0,1,1))*AB(1)
        theta(1490) = theta(1168)+theta(1042)*AB(1) ! ((4,1,0)|(1,0,2)) = ((5,1,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(1)
        theta(1491) = theta(1178)+theta(1040)*AB(2) ! ((4,1,0)|(0,3,0)) = ((4,2,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(2)
        theta(1492) = theta(1184)+theta(1040)*AB(3) ! ((4,1,0)|(0,2,1)) = ((4,1,1)|(0,2,0))+((4,1,0)|(0,2,0))*AB(3)
        theta(1493) = theta(1180)+theta(1042)*AB(2) ! ((4,1,0)|(0,1,2)) = ((4,2,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(2)
        theta(1494) = theta(1186)+theta(1042)*AB(3) ! ((4,1,0)|(0,0,3)) = ((4,1,1)|(0,0,2))+((4,1,0)|(0,0,2))*AB(3)
        theta(1495) = theta(1169)+theta(1043)*AB(1) ! ((4,0,1)|(3,0,0)) = ((5,0,1)|(2,0,0))+((4,0,1)|(2,0,0))*AB(1)
        theta(1496) = theta(1170)+theta(1044)*AB(1) ! ((4,0,1)|(2,1,0)) = ((5,0,1)|(1,1,0))+((4,0,1)|(1,1,0))*AB(1)
        ! theta(1497) = theta(1187)+theta(1043)*AB(3) ! ((4,0,1)|(2,0,1)) = ((4,0,2)|(2,0,0))+((4,0,1)|(2,0,0))*AB(3)
        theta(1498) = theta(1172)+theta(1046)*AB(1) ! ((4,0,1)|(1,2,0)) = ((5,0,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(1)
        theta(1499) = theta(1173)+theta(1047)*AB(1) ! ((4,0,1)|(1,1,1)) = ((5,0,1)|(0,1,1))+((4,0,1)|(0,1,1))*AB(1)
        theta(1500) = theta(1174)+theta(1048)*AB(1) ! ((4,0,1)|(1,0,2)) = ((5,0,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(1)
        theta(1501) = theta(1184)+theta(1046)*AB(2) ! ((4,0,1)|(0,3,0)) = ((4,1,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(2)
        theta(1502) = theta(1190)+theta(1046)*AB(3) ! ((4,0,1)|(0,2,1)) = ((4,0,2)|(0,2,0))+((4,0,1)|(0,2,0))*AB(3)
        theta(1503) = theta(1186)+theta(1048)*AB(2) ! ((4,0,1)|(0,1,2)) = ((4,1,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(2)
        theta(1504) = theta(1192)+theta(1048)*AB(3) ! ((4,0,1)|(0,0,3)) = ((4,0,2)|(0,0,2))+((4,0,1)|(0,0,2))*AB(3)
        theta(1505) = theta(1175)+theta(1049)*AB(1) ! ((3,2,0)|(3,0,0)) = ((4,2,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(1)
        ! theta(1506) = theta(1193)+theta(1049)*AB(2) ! ((3,2,0)|(2,1,0)) = ((3,3,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(2)
        theta(1507) = theta(1199)+theta(1049)*AB(3) ! ((3,2,0)|(2,0,1)) = ((3,2,1)|(2,0,0))+((3,2,0)|(2,0,0))*AB(3)
        theta(1508) = theta(1178)+theta(1052)*AB(1) ! ((3,2,0)|(1,2,0)) = ((4,2,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(1)
        ! theta(1509) = theta(1179)+theta(1053)*AB(1) ! ((3,2,0)|(1,1,1)) = ((4,2,0)|(0,1,1))+((3,2,0)|(0,1,1))*AB(1)
        theta(1510) = theta(1180)+theta(1054)*AB(1) ! ((3,2,0)|(1,0,2)) = ((4,2,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(1)
        theta(1511) = theta(1196)+theta(1052)*AB(2) ! ((3,2,0)|(0,3,0)) = ((3,3,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(2)
        theta(1512) = theta(1202)+theta(1052)*AB(3) ! ((3,2,0)|(0,2,1)) = ((3,2,1)|(0,2,0))+((3,2,0)|(0,2,0))*AB(3)
        theta(1513) = theta(1198)+theta(1054)*AB(2) ! ((3,2,0)|(0,1,2)) = ((3,3,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(2)
        theta(1514) = theta(1204)+theta(1054)*AB(3) ! ((3,2,0)|(0,0,3)) = ((3,2,1)|(0,0,2))+((3,2,0)|(0,0,2))*AB(3)
        theta(1515) = theta(1181)+theta(1055)*AB(1) ! ((3,1,1)|(3,0,0)) = ((4,1,1)|(2,0,0))+((3,1,1)|(2,0,0))*AB(1)
        theta(1516) = theta(1182)+theta(1056)*AB(1) ! ((3,1,1)|(2,1,0)) = ((4,1,1)|(1,1,0))+((3,1,1)|(1,1,0))*AB(1)
        ! theta(1517) = theta(1205)+theta(1055)*AB(3) ! ((3,1,1)|(2,0,1)) = ((3,1,2)|(2,0,0))+((3,1,1)|(2,0,0))*AB(3)
        theta(1518) = theta(1184)+theta(1058)*AB(1) ! ((3,1,1)|(1,2,0)) = ((4,1,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(1)
        theta(1519) = theta(1185)+theta(1059)*AB(1) ! ((3,1,1)|(1,1,1)) = ((4,1,1)|(0,1,1))+((3,1,1)|(0,1,1))*AB(1)
        theta(1520) = theta(1186)+theta(1060)*AB(1) ! ((3,1,1)|(1,0,2)) = ((4,1,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(1)
        theta(1521) = theta(1202)+theta(1058)*AB(2) ! ((3,1,1)|(0,3,0)) = ((3,2,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(2)
        theta(1522) = theta(1208)+theta(1058)*AB(3) ! ((3,1,1)|(0,2,1)) = ((3,1,2)|(0,2,0))+((3,1,1)|(0,2,0))*AB(3)
        theta(1523) = theta(1204)+theta(1060)*AB(2) ! ((3,1,1)|(0,1,2)) = ((3,2,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(2)
        theta(1524) = theta(1210)+theta(1060)*AB(3) ! ((3,1,1)|(0,0,3)) = ((3,1,2)|(0,0,2))+((3,1,1)|(0,0,2))*AB(3)
        theta(1525) = theta(1187)+theta(1061)*AB(1) ! ((3,0,2)|(3,0,0)) = ((4,0,2)|(2,0,0))+((3,0,2)|(2,0,0))*AB(1)
        theta(1526) = theta(1188)+theta(1062)*AB(1) ! ((3,0,2)|(2,1,0)) = ((4,0,2)|(1,1,0))+((3,0,2)|(1,1,0))*AB(1)
        ! theta(1527) = theta(1211)+theta(1061)*AB(3) ! ((3,0,2)|(2,0,1)) = ((3,0,3)|(2,0,0))+((3,0,2)|(2,0,0))*AB(3)
        theta(1528) = theta(1190)+theta(1064)*AB(1) ! ((3,0,2)|(1,2,0)) = ((4,0,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(1)
        theta(1529) = theta(1191)+theta(1065)*AB(1) ! ((3,0,2)|(1,1,1)) = ((4,0,2)|(0,1,1))+((3,0,2)|(0,1,1))*AB(1)
        theta(1530) = theta(1192)+theta(1066)*AB(1) ! ((3,0,2)|(1,0,2)) = ((4,0,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(1)
        theta(1531) = theta(1208)+theta(1064)*AB(2) ! ((3,0,2)|(0,3,0)) = ((3,1,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(2)
        theta(1532) = theta(1214)+theta(1064)*AB(3) ! ((3,0,2)|(0,2,1)) = ((3,0,3)|(0,2,0))+((3,0,2)|(0,2,0))*AB(3)
        theta(1533) = theta(1210)+theta(1066)*AB(2) ! ((3,0,2)|(0,1,2)) = ((3,1,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(2)
        theta(1534) = theta(1216)+theta(1066)*AB(3) ! ((3,0,2)|(0,0,3)) = ((3,0,3)|(0,0,2))+((3,0,2)|(0,0,2))*AB(3)
        theta(1535) = theta(1193)+theta(1067)*AB(1) ! ((2,3,0)|(3,0,0)) = ((3,3,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(1)
        ! theta(1536) = theta(1217)+theta(1067)*AB(2) ! ((2,3,0)|(2,1,0)) = ((2,4,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(2)
        theta(1537) = theta(1223)+theta(1067)*AB(3) ! ((2,3,0)|(2,0,1)) = ((2,3,1)|(2,0,0))+((2,3,0)|(2,0,0))*AB(3)
        theta(1538) = theta(1196)+theta(1070)*AB(1) ! ((2,3,0)|(1,2,0)) = ((3,3,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(1)
        ! theta(1539) = theta(1197)+theta(1071)*AB(1) ! ((2,3,0)|(1,1,1)) = ((3,3,0)|(0,1,1))+((2,3,0)|(0,1,1))*AB(1)
        theta(1540) = theta(1198)+theta(1072)*AB(1) ! ((2,3,0)|(1,0,2)) = ((3,3,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(1)
        theta(1541) = theta(1220)+theta(1070)*AB(2) ! ((2,3,0)|(0,3,0)) = ((2,4,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(2)
        theta(1542) = theta(1226)+theta(1070)*AB(3) ! ((2,3,0)|(0,2,1)) = ((2,3,1)|(0,2,0))+((2,3,0)|(0,2,0))*AB(3)
        theta(1543) = theta(1222)+theta(1072)*AB(2) ! ((2,3,0)|(0,1,2)) = ((2,4,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(2)
        theta(1544) = theta(1228)+theta(1072)*AB(3) ! ((2,3,0)|(0,0,3)) = ((2,3,1)|(0,0,2))+((2,3,0)|(0,0,2))*AB(3)
        theta(1545) = theta(1199)+theta(1073)*AB(1) ! ((2,2,1)|(3,0,0)) = ((3,2,1)|(2,0,0))+((2,2,1)|(2,0,0))*AB(1)
        theta(1546) = theta(1200)+theta(1074)*AB(1) ! ((2,2,1)|(2,1,0)) = ((3,2,1)|(1,1,0))+((2,2,1)|(1,1,0))*AB(1)
        ! theta(1547) = theta(1229)+theta(1073)*AB(3) ! ((2,2,1)|(2,0,1)) = ((2,2,2)|(2,0,0))+((2,2,1)|(2,0,0))*AB(3)
        theta(1548) = theta(1202)+theta(1076)*AB(1) ! ((2,2,1)|(1,2,0)) = ((3,2,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(1)
        theta(1549) = theta(1203)+theta(1077)*AB(1) ! ((2,2,1)|(1,1,1)) = ((3,2,1)|(0,1,1))+((2,2,1)|(0,1,1))*AB(1)
        theta(1550) = theta(1204)+theta(1078)*AB(1) ! ((2,2,1)|(1,0,2)) = ((3,2,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(1)
        theta(1551) = theta(1226)+theta(1076)*AB(2) ! ((2,2,1)|(0,3,0)) = ((2,3,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(2)
        theta(1552) = theta(1232)+theta(1076)*AB(3) ! ((2,2,1)|(0,2,1)) = ((2,2,2)|(0,2,0))+((2,2,1)|(0,2,0))*AB(3)
        theta(1553) = theta(1228)+theta(1078)*AB(2) ! ((2,2,1)|(0,1,2)) = ((2,3,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(2)
        theta(1554) = theta(1234)+theta(1078)*AB(3) ! ((2,2,1)|(0,0,3)) = ((2,2,2)|(0,0,2))+((2,2,1)|(0,0,2))*AB(3)
        theta(1555) = theta(1205)+theta(1079)*AB(1) ! ((2,1,2)|(3,0,0)) = ((3,1,2)|(2,0,0))+((2,1,2)|(2,0,0))*AB(1)
        theta(1556) = theta(1206)+theta(1080)*AB(1) ! ((2,1,2)|(2,1,0)) = ((3,1,2)|(1,1,0))+((2,1,2)|(1,1,0))*AB(1)
        ! theta(1557) = theta(1235)+theta(1079)*AB(3) ! ((2,1,2)|(2,0,1)) = ((2,1,3)|(2,0,0))+((2,1,2)|(2,0,0))*AB(3)
        theta(1558) = theta(1208)+theta(1082)*AB(1) ! ((2,1,2)|(1,2,0)) = ((3,1,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(1)
        theta(1559) = theta(1209)+theta(1083)*AB(1) ! ((2,1,2)|(1,1,1)) = ((3,1,2)|(0,1,1))+((2,1,2)|(0,1,1))*AB(1)
        theta(1560) = theta(1210)+theta(1084)*AB(1) ! ((2,1,2)|(1,0,2)) = ((3,1,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(1)
        theta(1561) = theta(1232)+theta(1082)*AB(2) ! ((2,1,2)|(0,3,0)) = ((2,2,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(2)
        theta(1562) = theta(1238)+theta(1082)*AB(3) ! ((2,1,2)|(0,2,1)) = ((2,1,3)|(0,2,0))+((2,1,2)|(0,2,0))*AB(3)
        theta(1563) = theta(1234)+theta(1084)*AB(2) ! ((2,1,2)|(0,1,2)) = ((2,2,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(2)
        theta(1564) = theta(1240)+theta(1084)*AB(3) ! ((2,1,2)|(0,0,3)) = ((2,1,3)|(0,0,2))+((2,1,2)|(0,0,2))*AB(3)
        theta(1565) = theta(1211)+theta(1085)*AB(1) ! ((2,0,3)|(3,0,0)) = ((3,0,3)|(2,0,0))+((2,0,3)|(2,0,0))*AB(1)
        theta(1566) = theta(1212)+theta(1086)*AB(1) ! ((2,0,3)|(2,1,0)) = ((3,0,3)|(1,1,0))+((2,0,3)|(1,1,0))*AB(1)
        ! theta(1567) = theta(1241)+theta(1085)*AB(3) ! ((2,0,3)|(2,0,1)) = ((2,0,4)|(2,0,0))+((2,0,3)|(2,0,0))*AB(3)
        theta(1568) = theta(1214)+theta(1088)*AB(1) ! ((2,0,3)|(1,2,0)) = ((3,0,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(1)
        theta(1569) = theta(1215)+theta(1089)*AB(1) ! ((2,0,3)|(1,1,1)) = ((3,0,3)|(0,1,1))+((2,0,3)|(0,1,1))*AB(1)
        theta(1570) = theta(1216)+theta(1090)*AB(1) ! ((2,0,3)|(1,0,2)) = ((3,0,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(1)
        theta(1571) = theta(1238)+theta(1088)*AB(2) ! ((2,0,3)|(0,3,0)) = ((2,1,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(2)
        theta(1572) = theta(1244)+theta(1088)*AB(3) ! ((2,0,3)|(0,2,1)) = ((2,0,4)|(0,2,0))+((2,0,3)|(0,2,0))*AB(3)
        theta(1573) = theta(1240)+theta(1090)*AB(2) ! ((2,0,3)|(0,1,2)) = ((2,1,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(2)
        theta(1574) = theta(1246)+theta(1090)*AB(3) ! ((2,0,3)|(0,0,3)) = ((2,0,4)|(0,0,2))+((2,0,3)|(0,0,2))*AB(3)
        theta(1575) = theta(1217)+theta(1091)*AB(1) ! ((1,4,0)|(3,0,0)) = ((2,4,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(1)
        ! theta(1576) = theta(1247)+theta(1091)*AB(2) ! ((1,4,0)|(2,1,0)) = ((1,5,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(2)
        theta(1577) = theta(1253)+theta(1091)*AB(3) ! ((1,4,0)|(2,0,1)) = ((1,4,1)|(2,0,0))+((1,4,0)|(2,0,0))*AB(3)
        theta(1578) = theta(1220)+theta(1094)*AB(1) ! ((1,4,0)|(1,2,0)) = ((2,4,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(1)
        ! theta(1579) = theta(1221)+theta(1095)*AB(1) ! ((1,4,0)|(1,1,1)) = ((2,4,0)|(0,1,1))+((1,4,0)|(0,1,1))*AB(1)
        theta(1580) = theta(1222)+theta(1096)*AB(1) ! ((1,4,0)|(1,0,2)) = ((2,4,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(1)
        theta(1581) = theta(1250)+theta(1094)*AB(2) ! ((1,4,0)|(0,3,0)) = ((1,5,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(2)
        theta(1582) = theta(1256)+theta(1094)*AB(3) ! ((1,4,0)|(0,2,1)) = ((1,4,1)|(0,2,0))+((1,4,0)|(0,2,0))*AB(3)
        theta(1583) = theta(1252)+theta(1096)*AB(2) ! ((1,4,0)|(0,1,2)) = ((1,5,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(2)
        theta(1584) = theta(1258)+theta(1096)*AB(3) ! ((1,4,0)|(0,0,3)) = ((1,4,1)|(0,0,2))+((1,4,0)|(0,0,2))*AB(3)
        theta(1585) = theta(1223)+theta(1097)*AB(1) ! ((1,3,1)|(3,0,0)) = ((2,3,1)|(2,0,0))+((1,3,1)|(2,0,0))*AB(1)
        theta(1586) = theta(1224)+theta(1098)*AB(1) ! ((1,3,1)|(2,1,0)) = ((2,3,1)|(1,1,0))+((1,3,1)|(1,1,0))*AB(1)
        ! theta(1587) = theta(1259)+theta(1097)*AB(3) ! ((1,3,1)|(2,0,1)) = ((1,3,2)|(2,0,0))+((1,3,1)|(2,0,0))*AB(3)
        theta(1588) = theta(1226)+theta(1100)*AB(1) ! ((1,3,1)|(1,2,0)) = ((2,3,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(1)
        theta(1589) = theta(1227)+theta(1101)*AB(1) ! ((1,3,1)|(1,1,1)) = ((2,3,1)|(0,1,1))+((1,3,1)|(0,1,1))*AB(1)
        theta(1590) = theta(1228)+theta(1102)*AB(1) ! ((1,3,1)|(1,0,2)) = ((2,3,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(1)
        theta(1591) = theta(1256)+theta(1100)*AB(2) ! ((1,3,1)|(0,3,0)) = ((1,4,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(2)
        theta(1592) = theta(1262)+theta(1100)*AB(3) ! ((1,3,1)|(0,2,1)) = ((1,3,2)|(0,2,0))+((1,3,1)|(0,2,0))*AB(3)
        theta(1593) = theta(1258)+theta(1102)*AB(2) ! ((1,3,1)|(0,1,2)) = ((1,4,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(2)
        theta(1594) = theta(1264)+theta(1102)*AB(3) ! ((1,3,1)|(0,0,3)) = ((1,3,2)|(0,0,2))+((1,3,1)|(0,0,2))*AB(3)
        theta(1595) = theta(1229)+theta(1103)*AB(1) ! ((1,2,2)|(3,0,0)) = ((2,2,2)|(2,0,0))+((1,2,2)|(2,0,0))*AB(1)
        theta(1596) = theta(1230)+theta(1104)*AB(1) ! ((1,2,2)|(2,1,0)) = ((2,2,2)|(1,1,0))+((1,2,2)|(1,1,0))*AB(1)
        ! theta(1597) = theta(1265)+theta(1103)*AB(3) ! ((1,2,2)|(2,0,1)) = ((1,2,3)|(2,0,0))+((1,2,2)|(2,0,0))*AB(3)
        theta(1598) = theta(1232)+theta(1106)*AB(1) ! ((1,2,2)|(1,2,0)) = ((2,2,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(1)
        theta(1599) = theta(1233)+theta(1107)*AB(1) ! ((1,2,2)|(1,1,1)) = ((2,2,2)|(0,1,1))+((1,2,2)|(0,1,1))*AB(1)
        theta(1600) = theta(1234)+theta(1108)*AB(1) ! ((1,2,2)|(1,0,2)) = ((2,2,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(1)
        theta(1601) = theta(1262)+theta(1106)*AB(2) ! ((1,2,2)|(0,3,0)) = ((1,3,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(2)
        theta(1602) = theta(1268)+theta(1106)*AB(3) ! ((1,2,2)|(0,2,1)) = ((1,2,3)|(0,2,0))+((1,2,2)|(0,2,0))*AB(3)
        theta(1603) = theta(1264)+theta(1108)*AB(2) ! ((1,2,2)|(0,1,2)) = ((1,3,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(2)
        theta(1604) = theta(1270)+theta(1108)*AB(3) ! ((1,2,2)|(0,0,3)) = ((1,2,3)|(0,0,2))+((1,2,2)|(0,0,2))*AB(3)
        theta(1605) = theta(1235)+theta(1109)*AB(1) ! ((1,1,3)|(3,0,0)) = ((2,1,3)|(2,0,0))+((1,1,3)|(2,0,0))*AB(1)
        theta(1606) = theta(1236)+theta(1110)*AB(1) ! ((1,1,3)|(2,1,0)) = ((2,1,3)|(1,1,0))+((1,1,3)|(1,1,0))*AB(1)
        ! theta(1607) = theta(1271)+theta(1109)*AB(3) ! ((1,1,3)|(2,0,1)) = ((1,1,4)|(2,0,0))+((1,1,3)|(2,0,0))*AB(3)
        theta(1608) = theta(1238)+theta(1112)*AB(1) ! ((1,1,3)|(1,2,0)) = ((2,1,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(1)
        theta(1609) = theta(1239)+theta(1113)*AB(1) ! ((1,1,3)|(1,1,1)) = ((2,1,3)|(0,1,1))+((1,1,3)|(0,1,1))*AB(1)
        theta(1610) = theta(1240)+theta(1114)*AB(1) ! ((1,1,3)|(1,0,2)) = ((2,1,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(1)
        theta(1611) = theta(1268)+theta(1112)*AB(2) ! ((1,1,3)|(0,3,0)) = ((1,2,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(2)
        theta(1612) = theta(1274)+theta(1112)*AB(3) ! ((1,1,3)|(0,2,1)) = ((1,1,4)|(0,2,0))+((1,1,3)|(0,2,0))*AB(3)
        theta(1613) = theta(1270)+theta(1114)*AB(2) ! ((1,1,3)|(0,1,2)) = ((1,2,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(2)
        theta(1614) = theta(1276)+theta(1114)*AB(3) ! ((1,1,3)|(0,0,3)) = ((1,1,4)|(0,0,2))+((1,1,3)|(0,0,2))*AB(3)
        theta(1615) = theta(1241)+theta(1115)*AB(1) ! ((1,0,4)|(3,0,0)) = ((2,0,4)|(2,0,0))+((1,0,4)|(2,0,0))*AB(1)
        theta(1616) = theta(1242)+theta(1116)*AB(1) ! ((1,0,4)|(2,1,0)) = ((2,0,4)|(1,1,0))+((1,0,4)|(1,1,0))*AB(1)
        ! theta(1617) = theta(1277)+theta(1115)*AB(3) ! ((1,0,4)|(2,0,1)) = ((1,0,5)|(2,0,0))+((1,0,4)|(2,0,0))*AB(3)
        theta(1618) = theta(1244)+theta(1118)*AB(1) ! ((1,0,4)|(1,2,0)) = ((2,0,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(1)
        theta(1619) = theta(1245)+theta(1119)*AB(1) ! ((1,0,4)|(1,1,1)) = ((2,0,4)|(0,1,1))+((1,0,4)|(0,1,1))*AB(1)
        theta(1620) = theta(1246)+theta(1120)*AB(1) ! ((1,0,4)|(1,0,2)) = ((2,0,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(1)
        theta(1621) = theta(1274)+theta(1118)*AB(2) ! ((1,0,4)|(0,3,0)) = ((1,1,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(2)
        theta(1622) = theta(1280)+theta(1118)*AB(3) ! ((1,0,4)|(0,2,1)) = ((1,0,5)|(0,2,0))+((1,0,4)|(0,2,0))*AB(3)
        theta(1623) = theta(1276)+theta(1120)*AB(2) ! ((1,0,4)|(0,1,2)) = ((1,1,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(2)
        theta(1624) = theta(1282)+theta(1120)*AB(3) ! ((1,0,4)|(0,0,3)) = ((1,0,5)|(0,0,2))+((1,0,4)|(0,0,2))*AB(3)
        theta(1625) = theta(1247)+theta(1121)*AB(1) ! ((0,5,0)|(3,0,0)) = ((1,5,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(1)
        ! theta(1626) = theta(1283)+theta(1121)*AB(2) ! ((0,5,0)|(2,1,0)) = ((0,6,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(2)
        theta(1627) = theta(1289)+theta(1121)*AB(3) ! ((0,5,0)|(2,0,1)) = ((0,5,1)|(2,0,0))+((0,5,0)|(2,0,0))*AB(3)
        ! theta(1628) = theta(1250)+theta(1124)*AB(1) ! ((0,5,0)|(1,2,0)) = ((1,5,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(1)
        ! theta(1629) = theta(1251)+theta(1125)*AB(1) ! ((0,5,0)|(1,1,1)) = ((1,5,0)|(0,1,1))+((0,5,0)|(0,1,1))*AB(1)
        ! theta(1630) = theta(1252)+theta(1126)*AB(1) ! ((0,5,0)|(1,0,2)) = ((1,5,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(1)
        theta(1631) = theta(1286)+theta(1124)*AB(2) ! ((0,5,0)|(0,3,0)) = ((0,6,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(2)
        ! theta(1632) = theta(1292)+theta(1124)*AB(3) ! ((0,5,0)|(0,2,1)) = ((0,5,1)|(0,2,0))+((0,5,0)|(0,2,0))*AB(3)
        theta(1633) = theta(1288)+theta(1126)*AB(2) ! ((0,5,0)|(0,1,2)) = ((0,6,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(2)
        theta(1634) = theta(1294)+theta(1126)*AB(3) ! ((0,5,0)|(0,0,3)) = ((0,5,1)|(0,0,2))+((0,5,0)|(0,0,2))*AB(3)
        theta(1635) = theta(1253)+theta(1127)*AB(1) ! ((0,4,1)|(3,0,0)) = ((1,4,1)|(2,0,0))+((0,4,1)|(2,0,0))*AB(1)
        ! theta(1636) = theta(1254)+theta(1128)*AB(1) ! ((0,4,1)|(2,1,0)) = ((1,4,1)|(1,1,0))+((0,4,1)|(1,1,0))*AB(1)
        ! theta(1637) = theta(1295)+theta(1127)*AB(3) ! ((0,4,1)|(2,0,1)) = ((0,4,2)|(2,0,0))+((0,4,1)|(2,0,0))*AB(3)
        ! theta(1638) = theta(1256)+theta(1130)*AB(1) ! ((0,4,1)|(1,2,0)) = ((1,4,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(1)
        ! theta(1639) = theta(1257)+theta(1131)*AB(1) ! ((0,4,1)|(1,1,1)) = ((1,4,1)|(0,1,1))+((0,4,1)|(0,1,1))*AB(1)
        ! theta(1640) = theta(1258)+theta(1132)*AB(1) ! ((0,4,1)|(1,0,2)) = ((1,4,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(1)
        theta(1641) = theta(1292)+theta(1130)*AB(2) ! ((0,4,1)|(0,3,0)) = ((0,5,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(2)
        ! theta(1642) = theta(1298)+theta(1130)*AB(3) ! ((0,4,1)|(0,2,1)) = ((0,4,2)|(0,2,0))+((0,4,1)|(0,2,0))*AB(3)
        theta(1643) = theta(1294)+theta(1132)*AB(2) ! ((0,4,1)|(0,1,2)) = ((0,5,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(2)
        theta(1644) = theta(1300)+theta(1132)*AB(3) ! ((0,4,1)|(0,0,3)) = ((0,4,2)|(0,0,2))+((0,4,1)|(0,0,2))*AB(3)
        theta(1645) = theta(1259)+theta(1133)*AB(1) ! ((0,3,2)|(3,0,0)) = ((1,3,2)|(2,0,0))+((0,3,2)|(2,0,0))*AB(1)
        ! theta(1646) = theta(1260)+theta(1134)*AB(1) ! ((0,3,2)|(2,1,0)) = ((1,3,2)|(1,1,0))+((0,3,2)|(1,1,0))*AB(1)
        ! theta(1647) = theta(1301)+theta(1133)*AB(3) ! ((0,3,2)|(2,0,1)) = ((0,3,3)|(2,0,0))+((0,3,2)|(2,0,0))*AB(3)
        ! theta(1648) = theta(1262)+theta(1136)*AB(1) ! ((0,3,2)|(1,2,0)) = ((1,3,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(1)
        ! theta(1649) = theta(1263)+theta(1137)*AB(1) ! ((0,3,2)|(1,1,1)) = ((1,3,2)|(0,1,1))+((0,3,2)|(0,1,1))*AB(1)
        ! theta(1650) = theta(1264)+theta(1138)*AB(1) ! ((0,3,2)|(1,0,2)) = ((1,3,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(1)
        theta(1651) = theta(1298)+theta(1136)*AB(2) ! ((0,3,2)|(0,3,0)) = ((0,4,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(2)
        ! theta(1652) = theta(1304)+theta(1136)*AB(3) ! ((0,3,2)|(0,2,1)) = ((0,3,3)|(0,2,0))+((0,3,2)|(0,2,0))*AB(3)
        theta(1653) = theta(1300)+theta(1138)*AB(2) ! ((0,3,2)|(0,1,2)) = ((0,4,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(2)
        theta(1654) = theta(1306)+theta(1138)*AB(3) ! ((0,3,2)|(0,0,3)) = ((0,3,3)|(0,0,2))+((0,3,2)|(0,0,2))*AB(3)
        theta(1655) = theta(1265)+theta(1139)*AB(1) ! ((0,2,3)|(3,0,0)) = ((1,2,3)|(2,0,0))+((0,2,3)|(2,0,0))*AB(1)
        ! theta(1656) = theta(1266)+theta(1140)*AB(1) ! ((0,2,3)|(2,1,0)) = ((1,2,3)|(1,1,0))+((0,2,3)|(1,1,0))*AB(1)
        ! theta(1657) = theta(1307)+theta(1139)*AB(3) ! ((0,2,3)|(2,0,1)) = ((0,2,4)|(2,0,0))+((0,2,3)|(2,0,0))*AB(3)
        ! theta(1658) = theta(1268)+theta(1142)*AB(1) ! ((0,2,3)|(1,2,0)) = ((1,2,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(1)
        ! theta(1659) = theta(1269)+theta(1143)*AB(1) ! ((0,2,3)|(1,1,1)) = ((1,2,3)|(0,1,1))+((0,2,3)|(0,1,1))*AB(1)
        ! theta(1660) = theta(1270)+theta(1144)*AB(1) ! ((0,2,3)|(1,0,2)) = ((1,2,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(1)
        theta(1661) = theta(1304)+theta(1142)*AB(2) ! ((0,2,3)|(0,3,0)) = ((0,3,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(2)
        ! theta(1662) = theta(1310)+theta(1142)*AB(3) ! ((0,2,3)|(0,2,1)) = ((0,2,4)|(0,2,0))+((0,2,3)|(0,2,0))*AB(3)
        theta(1663) = theta(1306)+theta(1144)*AB(2) ! ((0,2,3)|(0,1,2)) = ((0,3,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(2)
        theta(1664) = theta(1312)+theta(1144)*AB(3) ! ((0,2,3)|(0,0,3)) = ((0,2,4)|(0,0,2))+((0,2,3)|(0,0,2))*AB(3)
        theta(1665) = theta(1271)+theta(1145)*AB(1) ! ((0,1,4)|(3,0,0)) = ((1,1,4)|(2,0,0))+((0,1,4)|(2,0,0))*AB(1)
        ! theta(1666) = theta(1272)+theta(1146)*AB(1) ! ((0,1,4)|(2,1,0)) = ((1,1,4)|(1,1,0))+((0,1,4)|(1,1,0))*AB(1)
        ! theta(1667) = theta(1313)+theta(1145)*AB(3) ! ((0,1,4)|(2,0,1)) = ((0,1,5)|(2,0,0))+((0,1,4)|(2,0,0))*AB(3)
        ! theta(1668) = theta(1274)+theta(1148)*AB(1) ! ((0,1,4)|(1,2,0)) = ((1,1,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(1)
        ! theta(1669) = theta(1275)+theta(1149)*AB(1) ! ((0,1,4)|(1,1,1)) = ((1,1,4)|(0,1,1))+((0,1,4)|(0,1,1))*AB(1)
        ! theta(1670) = theta(1276)+theta(1150)*AB(1) ! ((0,1,4)|(1,0,2)) = ((1,1,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(1)
        theta(1671) = theta(1310)+theta(1148)*AB(2) ! ((0,1,4)|(0,3,0)) = ((0,2,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(2)
        ! theta(1672) = theta(1316)+theta(1148)*AB(3) ! ((0,1,4)|(0,2,1)) = ((0,1,5)|(0,2,0))+((0,1,4)|(0,2,0))*AB(3)
        theta(1673) = theta(1312)+theta(1150)*AB(2) ! ((0,1,4)|(0,1,2)) = ((0,2,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(2)
        theta(1674) = theta(1318)+theta(1150)*AB(3) ! ((0,1,4)|(0,0,3)) = ((0,1,5)|(0,0,2))+((0,1,4)|(0,0,2))*AB(3)
        theta(1675) = theta(1277)+theta(1151)*AB(1) ! ((0,0,5)|(3,0,0)) = ((1,0,5)|(2,0,0))+((0,0,5)|(2,0,0))*AB(1)
        ! theta(1676) = theta(1278)+theta(1152)*AB(1) ! ((0,0,5)|(2,1,0)) = ((1,0,5)|(1,1,0))+((0,0,5)|(1,1,0))*AB(1)
        ! theta(1677) = theta(1319)+theta(1151)*AB(3) ! ((0,0,5)|(2,0,1)) = ((0,0,6)|(2,0,0))+((0,0,5)|(2,0,0))*AB(3)
        ! theta(1678) = theta(1280)+theta(1154)*AB(1) ! ((0,0,5)|(1,2,0)) = ((1,0,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(1)
        ! theta(1679) = theta(1281)+theta(1155)*AB(1) ! ((0,0,5)|(1,1,1)) = ((1,0,5)|(0,1,1))+((0,0,5)|(0,1,1))*AB(1)
        ! theta(1680) = theta(1282)+theta(1156)*AB(1) ! ((0,0,5)|(1,0,2)) = ((1,0,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(1)
        theta(1681) = theta(1316)+theta(1154)*AB(2) ! ((0,0,5)|(0,3,0)) = ((0,1,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(2)
        ! theta(1682) = theta(1322)+theta(1154)*AB(3) ! ((0,0,5)|(0,2,1)) = ((0,0,6)|(0,2,0))+((0,0,5)|(0,2,0))*AB(3)
        ! theta(1683) = theta(1318)+theta(1156)*AB(2) ! ((0,0,5)|(0,1,2)) = ((0,1,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(2)
        theta(1684) = theta(1324)+theta(1156)*AB(3) ! ((0,0,5)|(0,0,3)) = ((0,0,6)|(0,0,2))+((0,0,5)|(0,0,2))*AB(3)
        theta(1685) = theta(1475)+theta(1325)*AB(1) ! ((4,0,0)|(4,0,0)) = ((5,0,0)|(3,0,0))+((4,0,0)|(3,0,0))*AB(1)
        theta(1686) = theta(1485)+theta(1325)*AB(2) ! ((4,0,0)|(3,1,0)) = ((4,1,0)|(3,0,0))+((4,0,0)|(3,0,0))*AB(2)
        theta(1687) = theta(1495)+theta(1325)*AB(3) ! ((4,0,0)|(3,0,1)) = ((4,0,1)|(3,0,0))+((4,0,0)|(3,0,0))*AB(3)
        theta(1688) = theta(1478)+theta(1328)*AB(1) ! ((4,0,0)|(2,2,0)) = ((5,0,0)|(1,2,0))+((4,0,0)|(1,2,0))*AB(1)
        theta(1689) = theta(1487)+theta(1327)*AB(2) ! ((4,0,0)|(2,1,1)) = ((4,1,0)|(2,0,1))+((4,0,0)|(2,0,1))*AB(2)
        theta(1690) = theta(1480)+theta(1330)*AB(1) ! ((4,0,0)|(2,0,2)) = ((5,0,0)|(1,0,2))+((4,0,0)|(1,0,2))*AB(1)
        theta(1691) = theta(1481)+theta(1331)*AB(1) ! ((4,0,0)|(1,3,0)) = ((5,0,0)|(0,3,0))+((4,0,0)|(0,3,0))*AB(1)
        theta(1692) = theta(1482)+theta(1332)*AB(1) ! ((4,0,0)|(1,2,1)) = ((5,0,0)|(0,2,1))+((4,0,0)|(0,2,1))*AB(1)
        theta(1693) = theta(1483)+theta(1333)*AB(1) ! ((4,0,0)|(1,1,2)) = ((5,0,0)|(0,1,2))+((4,0,0)|(0,1,2))*AB(1)
        theta(1694) = theta(1484)+theta(1334)*AB(1) ! ((4,0,0)|(1,0,3)) = ((5,0,0)|(0,0,3))+((4,0,0)|(0,0,3))*AB(1)
        theta(1695) = theta(1491)+theta(1331)*AB(2) ! ((4,0,0)|(0,4,0)) = ((4,1,0)|(0,3,0))+((4,0,0)|(0,3,0))*AB(2)
        theta(1696) = theta(1501)+theta(1331)*AB(3) ! ((4,0,0)|(0,3,1)) = ((4,0,1)|(0,3,0))+((4,0,0)|(0,3,0))*AB(3)
        theta(1697) = theta(1493)+theta(1333)*AB(2) ! ((4,0,0)|(0,2,2)) = ((4,1,0)|(0,1,2))+((4,0,0)|(0,1,2))*AB(2)
        theta(1698) = theta(1494)+theta(1334)*AB(2) ! ((4,0,0)|(0,1,3)) = ((4,1,0)|(0,0,3))+((4,0,0)|(0,0,3))*AB(2)
        theta(1699) = theta(1504)+theta(1334)*AB(3) ! ((4,0,0)|(0,0,4)) = ((4,0,1)|(0,0,3))+((4,0,0)|(0,0,3))*AB(3)
        theta(1700) = theta(1485)+theta(1335)*AB(1) ! ((3,1,0)|(4,0,0)) = ((4,1,0)|(3,0,0))+((3,1,0)|(3,0,0))*AB(1)
        theta(1701) = theta(1505)+theta(1335)*AB(2) ! ((3,1,0)|(3,1,0)) = ((3,2,0)|(3,0,0))+((3,1,0)|(3,0,0))*AB(2)
        theta(1702) = theta(1515)+theta(1335)*AB(3) ! ((3,1,0)|(3,0,1)) = ((3,1,1)|(3,0,0))+((3,1,0)|(3,0,0))*AB(3)
        theta(1703) = theta(1488)+theta(1338)*AB(1) ! ((3,1,0)|(2,2,0)) = ((4,1,0)|(1,2,0))+((3,1,0)|(1,2,0))*AB(1)
        theta(1704) = theta(1507)+theta(1337)*AB(2) ! ((3,1,0)|(2,1,1)) = ((3,2,0)|(2,0,1))+((3,1,0)|(2,0,1))*AB(2)
        theta(1705) = theta(1490)+theta(1340)*AB(1) ! ((3,1,0)|(2,0,2)) = ((4,1,0)|(1,0,2))+((3,1,0)|(1,0,2))*AB(1)
        theta(1706) = theta(1491)+theta(1341)*AB(1) ! ((3,1,0)|(1,3,0)) = ((4,1,0)|(0,3,0))+((3,1,0)|(0,3,0))*AB(1)
        theta(1707) = theta(1492)+theta(1342)*AB(1) ! ((3,1,0)|(1,2,1)) = ((4,1,0)|(0,2,1))+((3,1,0)|(0,2,1))*AB(1)
        theta(1708) = theta(1493)+theta(1343)*AB(1) ! ((3,1,0)|(1,1,2)) = ((4,1,0)|(0,1,2))+((3,1,0)|(0,1,2))*AB(1)
        theta(1709) = theta(1494)+theta(1344)*AB(1) ! ((3,1,0)|(1,0,3)) = ((4,1,0)|(0,0,3))+((3,1,0)|(0,0,3))*AB(1)
        theta(1710) = theta(1511)+theta(1341)*AB(2) ! ((3,1,0)|(0,4,0)) = ((3,2,0)|(0,3,0))+((3,1,0)|(0,3,0))*AB(2)
        theta(1711) = theta(1521)+theta(1341)*AB(3) ! ((3,1,0)|(0,3,1)) = ((3,1,1)|(0,3,0))+((3,1,0)|(0,3,0))*AB(3)
        theta(1712) = theta(1513)+theta(1343)*AB(2) ! ((3,1,0)|(0,2,2)) = ((3,2,0)|(0,1,2))+((3,1,0)|(0,1,2))*AB(2)
        theta(1713) = theta(1514)+theta(1344)*AB(2) ! ((3,1,0)|(0,1,3)) = ((3,2,0)|(0,0,3))+((3,1,0)|(0,0,3))*AB(2)
        theta(1714) = theta(1524)+theta(1344)*AB(3) ! ((3,1,0)|(0,0,4)) = ((3,1,1)|(0,0,3))+((3,1,0)|(0,0,3))*AB(3)
        theta(1715) = theta(1495)+theta(1345)*AB(1) ! ((3,0,1)|(4,0,0)) = ((4,0,1)|(3,0,0))+((3,0,1)|(3,0,0))*AB(1)
        theta(1716) = theta(1496)+theta(1346)*AB(1) ! ((3,0,1)|(3,1,0)) = ((4,0,1)|(2,1,0))+((3,0,1)|(2,1,0))*AB(1)
        theta(1717) = theta(1525)+theta(1345)*AB(3) ! ((3,0,1)|(3,0,1)) = ((3,0,2)|(3,0,0))+((3,0,1)|(3,0,0))*AB(3)
        theta(1718) = theta(1498)+theta(1348)*AB(1) ! ((3,0,1)|(2,2,0)) = ((4,0,1)|(1,2,0))+((3,0,1)|(1,2,0))*AB(1)
        theta(1719) = theta(1499)+theta(1349)*AB(1) ! ((3,0,1)|(2,1,1)) = ((4,0,1)|(1,1,1))+((3,0,1)|(1,1,1))*AB(1)
        theta(1720) = theta(1500)+theta(1350)*AB(1) ! ((3,0,1)|(2,0,2)) = ((4,0,1)|(1,0,2))+((3,0,1)|(1,0,2))*AB(1)
        theta(1721) = theta(1501)+theta(1351)*AB(1) ! ((3,0,1)|(1,3,0)) = ((4,0,1)|(0,3,0))+((3,0,1)|(0,3,0))*AB(1)
        theta(1722) = theta(1502)+theta(1352)*AB(1) ! ((3,0,1)|(1,2,1)) = ((4,0,1)|(0,2,1))+((3,0,1)|(0,2,1))*AB(1)
        theta(1723) = theta(1503)+theta(1353)*AB(1) ! ((3,0,1)|(1,1,2)) = ((4,0,1)|(0,1,2))+((3,0,1)|(0,1,2))*AB(1)
        theta(1724) = theta(1504)+theta(1354)*AB(1) ! ((3,0,1)|(1,0,3)) = ((4,0,1)|(0,0,3))+((3,0,1)|(0,0,3))*AB(1)
        theta(1725) = theta(1521)+theta(1351)*AB(2) ! ((3,0,1)|(0,4,0)) = ((3,1,1)|(0,3,0))+((3,0,1)|(0,3,0))*AB(2)
        theta(1726) = theta(1531)+theta(1351)*AB(3) ! ((3,0,1)|(0,3,1)) = ((3,0,2)|(0,3,0))+((3,0,1)|(0,3,0))*AB(3)
        theta(1727) = theta(1523)+theta(1353)*AB(2) ! ((3,0,1)|(0,2,2)) = ((3,1,1)|(0,1,2))+((3,0,1)|(0,1,2))*AB(2)
        theta(1728) = theta(1524)+theta(1354)*AB(2) ! ((3,0,1)|(0,1,3)) = ((3,1,1)|(0,0,3))+((3,0,1)|(0,0,3))*AB(2)
        theta(1729) = theta(1534)+theta(1354)*AB(3) ! ((3,0,1)|(0,0,4)) = ((3,0,2)|(0,0,3))+((3,0,1)|(0,0,3))*AB(3)
        theta(1730) = theta(1505)+theta(1355)*AB(1) ! ((2,2,0)|(4,0,0)) = ((3,2,0)|(3,0,0))+((2,2,0)|(3,0,0))*AB(1)
        theta(1731) = theta(1535)+theta(1355)*AB(2) ! ((2,2,0)|(3,1,0)) = ((2,3,0)|(3,0,0))+((2,2,0)|(3,0,0))*AB(2)
        theta(1732) = theta(1545)+theta(1355)*AB(3) ! ((2,2,0)|(3,0,1)) = ((2,2,1)|(3,0,0))+((2,2,0)|(3,0,0))*AB(3)
        theta(1733) = theta(1508)+theta(1358)*AB(1) ! ((2,2,0)|(2,2,0)) = ((3,2,0)|(1,2,0))+((2,2,0)|(1,2,0))*AB(1)
        theta(1734) = theta(1537)+theta(1357)*AB(2) ! ((2,2,0)|(2,1,1)) = ((2,3,0)|(2,0,1))+((2,2,0)|(2,0,1))*AB(2)
        theta(1735) = theta(1510)+theta(1360)*AB(1) ! ((2,2,0)|(2,0,2)) = ((3,2,0)|(1,0,2))+((2,2,0)|(1,0,2))*AB(1)
        theta(1736) = theta(1511)+theta(1361)*AB(1) ! ((2,2,0)|(1,3,0)) = ((3,2,0)|(0,3,0))+((2,2,0)|(0,3,0))*AB(1)
        theta(1737) = theta(1512)+theta(1362)*AB(1) ! ((2,2,0)|(1,2,1)) = ((3,2,0)|(0,2,1))+((2,2,0)|(0,2,1))*AB(1)
        theta(1738) = theta(1513)+theta(1363)*AB(1) ! ((2,2,0)|(1,1,2)) = ((3,2,0)|(0,1,2))+((2,2,0)|(0,1,2))*AB(1)
        theta(1739) = theta(1514)+theta(1364)*AB(1) ! ((2,2,0)|(1,0,3)) = ((3,2,0)|(0,0,3))+((2,2,0)|(0,0,3))*AB(1)
        theta(1740) = theta(1541)+theta(1361)*AB(2) ! ((2,2,0)|(0,4,0)) = ((2,3,0)|(0,3,0))+((2,2,0)|(0,3,0))*AB(2)
        theta(1741) = theta(1551)+theta(1361)*AB(3) ! ((2,2,0)|(0,3,1)) = ((2,2,1)|(0,3,0))+((2,2,0)|(0,3,0))*AB(3)
        theta(1742) = theta(1543)+theta(1363)*AB(2) ! ((2,2,0)|(0,2,2)) = ((2,3,0)|(0,1,2))+((2,2,0)|(0,1,2))*AB(2)
        theta(1743) = theta(1544)+theta(1364)*AB(2) ! ((2,2,0)|(0,1,3)) = ((2,3,0)|(0,0,3))+((2,2,0)|(0,0,3))*AB(2)
        theta(1744) = theta(1554)+theta(1364)*AB(3) ! ((2,2,0)|(0,0,4)) = ((2,2,1)|(0,0,3))+((2,2,0)|(0,0,3))*AB(3)
        theta(1745) = theta(1515)+theta(1365)*AB(1) ! ((2,1,1)|(4,0,0)) = ((3,1,1)|(3,0,0))+((2,1,1)|(3,0,0))*AB(1)
        theta(1746) = theta(1516)+theta(1366)*AB(1) ! ((2,1,1)|(3,1,0)) = ((3,1,1)|(2,1,0))+((2,1,1)|(2,1,0))*AB(1)
        theta(1747) = theta(1555)+theta(1365)*AB(3) ! ((2,1,1)|(3,0,1)) = ((2,1,2)|(3,0,0))+((2,1,1)|(3,0,0))*AB(3)
        theta(1748) = theta(1518)+theta(1368)*AB(1) ! ((2,1,1)|(2,2,0)) = ((3,1,1)|(1,2,0))+((2,1,1)|(1,2,0))*AB(1)
        theta(1749) = theta(1519)+theta(1369)*AB(1) ! ((2,1,1)|(2,1,1)) = ((3,1,1)|(1,1,1))+((2,1,1)|(1,1,1))*AB(1)
        theta(1750) = theta(1520)+theta(1370)*AB(1) ! ((2,1,1)|(2,0,2)) = ((3,1,1)|(1,0,2))+((2,1,1)|(1,0,2))*AB(1)
        theta(1751) = theta(1521)+theta(1371)*AB(1) ! ((2,1,1)|(1,3,0)) = ((3,1,1)|(0,3,0))+((2,1,1)|(0,3,0))*AB(1)
        theta(1752) = theta(1522)+theta(1372)*AB(1) ! ((2,1,1)|(1,2,1)) = ((3,1,1)|(0,2,1))+((2,1,1)|(0,2,1))*AB(1)
        theta(1753) = theta(1523)+theta(1373)*AB(1) ! ((2,1,1)|(1,1,2)) = ((3,1,1)|(0,1,2))+((2,1,1)|(0,1,2))*AB(1)
        theta(1754) = theta(1524)+theta(1374)*AB(1) ! ((2,1,1)|(1,0,3)) = ((3,1,1)|(0,0,3))+((2,1,1)|(0,0,3))*AB(1)
        theta(1755) = theta(1551)+theta(1371)*AB(2) ! ((2,1,1)|(0,4,0)) = ((2,2,1)|(0,3,0))+((2,1,1)|(0,3,0))*AB(2)
        theta(1756) = theta(1561)+theta(1371)*AB(3) ! ((2,1,1)|(0,3,1)) = ((2,1,2)|(0,3,0))+((2,1,1)|(0,3,0))*AB(3)
        theta(1757) = theta(1553)+theta(1373)*AB(2) ! ((2,1,1)|(0,2,2)) = ((2,2,1)|(0,1,2))+((2,1,1)|(0,1,2))*AB(2)
        theta(1758) = theta(1554)+theta(1374)*AB(2) ! ((2,1,1)|(0,1,3)) = ((2,2,1)|(0,0,3))+((2,1,1)|(0,0,3))*AB(2)
        theta(1759) = theta(1564)+theta(1374)*AB(3) ! ((2,1,1)|(0,0,4)) = ((2,1,2)|(0,0,3))+((2,1,1)|(0,0,3))*AB(3)
        theta(1760) = theta(1525)+theta(1375)*AB(1) ! ((2,0,2)|(4,0,0)) = ((3,0,2)|(3,0,0))+((2,0,2)|(3,0,0))*AB(1)
        theta(1761) = theta(1526)+theta(1376)*AB(1) ! ((2,0,2)|(3,1,0)) = ((3,0,2)|(2,1,0))+((2,0,2)|(2,1,0))*AB(1)
        theta(1762) = theta(1565)+theta(1375)*AB(3) ! ((2,0,2)|(3,0,1)) = ((2,0,3)|(3,0,0))+((2,0,2)|(3,0,0))*AB(3)
        theta(1763) = theta(1528)+theta(1378)*AB(1) ! ((2,0,2)|(2,2,0)) = ((3,0,2)|(1,2,0))+((2,0,2)|(1,2,0))*AB(1)
        theta(1764) = theta(1529)+theta(1379)*AB(1) ! ((2,0,2)|(2,1,1)) = ((3,0,2)|(1,1,1))+((2,0,2)|(1,1,1))*AB(1)
        theta(1765) = theta(1530)+theta(1380)*AB(1) ! ((2,0,2)|(2,0,2)) = ((3,0,2)|(1,0,2))+((2,0,2)|(1,0,2))*AB(1)
        theta(1766) = theta(1531)+theta(1381)*AB(1) ! ((2,0,2)|(1,3,0)) = ((3,0,2)|(0,3,0))+((2,0,2)|(0,3,0))*AB(1)
        theta(1767) = theta(1532)+theta(1382)*AB(1) ! ((2,0,2)|(1,2,1)) = ((3,0,2)|(0,2,1))+((2,0,2)|(0,2,1))*AB(1)
        theta(1768) = theta(1533)+theta(1383)*AB(1) ! ((2,0,2)|(1,1,2)) = ((3,0,2)|(0,1,2))+((2,0,2)|(0,1,2))*AB(1)
        theta(1769) = theta(1534)+theta(1384)*AB(1) ! ((2,0,2)|(1,0,3)) = ((3,0,2)|(0,0,3))+((2,0,2)|(0,0,3))*AB(1)
        theta(1770) = theta(1561)+theta(1381)*AB(2) ! ((2,0,2)|(0,4,0)) = ((2,1,2)|(0,3,0))+((2,0,2)|(0,3,0))*AB(2)
        theta(1771) = theta(1571)+theta(1381)*AB(3) ! ((2,0,2)|(0,3,1)) = ((2,0,3)|(0,3,0))+((2,0,2)|(0,3,0))*AB(3)
        theta(1772) = theta(1563)+theta(1383)*AB(2) ! ((2,0,2)|(0,2,2)) = ((2,1,2)|(0,1,2))+((2,0,2)|(0,1,2))*AB(2)
        theta(1773) = theta(1564)+theta(1384)*AB(2) ! ((2,0,2)|(0,1,3)) = ((2,1,2)|(0,0,3))+((2,0,2)|(0,0,3))*AB(2)
        theta(1774) = theta(1574)+theta(1384)*AB(3) ! ((2,0,2)|(0,0,4)) = ((2,0,3)|(0,0,3))+((2,0,2)|(0,0,3))*AB(3)
        theta(1775) = theta(1535)+theta(1385)*AB(1) ! ((1,3,0)|(4,0,0)) = ((2,3,0)|(3,0,0))+((1,3,0)|(3,0,0))*AB(1)
        theta(1776) = theta(1575)+theta(1385)*AB(2) ! ((1,3,0)|(3,1,0)) = ((1,4,0)|(3,0,0))+((1,3,0)|(3,0,0))*AB(2)
        theta(1777) = theta(1585)+theta(1385)*AB(3) ! ((1,3,0)|(3,0,1)) = ((1,3,1)|(3,0,0))+((1,3,0)|(3,0,0))*AB(3)
        theta(1778) = theta(1538)+theta(1388)*AB(1) ! ((1,3,0)|(2,2,0)) = ((2,3,0)|(1,2,0))+((1,3,0)|(1,2,0))*AB(1)
        theta(1779) = theta(1577)+theta(1387)*AB(2) ! ((1,3,0)|(2,1,1)) = ((1,4,0)|(2,0,1))+((1,3,0)|(2,0,1))*AB(2)
        theta(1780) = theta(1540)+theta(1390)*AB(1) ! ((1,3,0)|(2,0,2)) = ((2,3,0)|(1,0,2))+((1,3,0)|(1,0,2))*AB(1)
        theta(1781) = theta(1541)+theta(1391)*AB(1) ! ((1,3,0)|(1,3,0)) = ((2,3,0)|(0,3,0))+((1,3,0)|(0,3,0))*AB(1)
        theta(1782) = theta(1542)+theta(1392)*AB(1) ! ((1,3,0)|(1,2,1)) = ((2,3,0)|(0,2,1))+((1,3,0)|(0,2,1))*AB(1)
        theta(1783) = theta(1543)+theta(1393)*AB(1) ! ((1,3,0)|(1,1,2)) = ((2,3,0)|(0,1,2))+((1,3,0)|(0,1,2))*AB(1)
        theta(1784) = theta(1544)+theta(1394)*AB(1) ! ((1,3,0)|(1,0,3)) = ((2,3,0)|(0,0,3))+((1,3,0)|(0,0,3))*AB(1)
        theta(1785) = theta(1581)+theta(1391)*AB(2) ! ((1,3,0)|(0,4,0)) = ((1,4,0)|(0,3,0))+((1,3,0)|(0,3,0))*AB(2)
        theta(1786) = theta(1591)+theta(1391)*AB(3) ! ((1,3,0)|(0,3,1)) = ((1,3,1)|(0,3,0))+((1,3,0)|(0,3,0))*AB(3)
        theta(1787) = theta(1583)+theta(1393)*AB(2) ! ((1,3,0)|(0,2,2)) = ((1,4,0)|(0,1,2))+((1,3,0)|(0,1,2))*AB(2)
        theta(1788) = theta(1584)+theta(1394)*AB(2) ! ((1,3,0)|(0,1,3)) = ((1,4,0)|(0,0,3))+((1,3,0)|(0,0,3))*AB(2)
        theta(1789) = theta(1594)+theta(1394)*AB(3) ! ((1,3,0)|(0,0,4)) = ((1,3,1)|(0,0,3))+((1,3,0)|(0,0,3))*AB(3)
        theta(1790) = theta(1545)+theta(1395)*AB(1) ! ((1,2,1)|(4,0,0)) = ((2,2,1)|(3,0,0))+((1,2,1)|(3,0,0))*AB(1)
        theta(1791) = theta(1546)+theta(1396)*AB(1) ! ((1,2,1)|(3,1,0)) = ((2,2,1)|(2,1,0))+((1,2,1)|(2,1,0))*AB(1)
        theta(1792) = theta(1595)+theta(1395)*AB(3) ! ((1,2,1)|(3,0,1)) = ((1,2,2)|(3,0,0))+((1,2,1)|(3,0,0))*AB(3)
        theta(1793) = theta(1548)+theta(1398)*AB(1) ! ((1,2,1)|(2,2,0)) = ((2,2,1)|(1,2,0))+((1,2,1)|(1,2,0))*AB(1)
        theta(1794) = theta(1549)+theta(1399)*AB(1) ! ((1,2,1)|(2,1,1)) = ((2,2,1)|(1,1,1))+((1,2,1)|(1,1,1))*AB(1)
        theta(1795) = theta(1550)+theta(1400)*AB(1) ! ((1,2,1)|(2,0,2)) = ((2,2,1)|(1,0,2))+((1,2,1)|(1,0,2))*AB(1)
        theta(1796) = theta(1551)+theta(1401)*AB(1) ! ((1,2,1)|(1,3,0)) = ((2,2,1)|(0,3,0))+((1,2,1)|(0,3,0))*AB(1)
        theta(1797) = theta(1552)+theta(1402)*AB(1) ! ((1,2,1)|(1,2,1)) = ((2,2,1)|(0,2,1))+((1,2,1)|(0,2,1))*AB(1)
        theta(1798) = theta(1553)+theta(1403)*AB(1) ! ((1,2,1)|(1,1,2)) = ((2,2,1)|(0,1,2))+((1,2,1)|(0,1,2))*AB(1)
        theta(1799) = theta(1554)+theta(1404)*AB(1) ! ((1,2,1)|(1,0,3)) = ((2,2,1)|(0,0,3))+((1,2,1)|(0,0,3))*AB(1)
        theta(1800) = theta(1591)+theta(1401)*AB(2) ! ((1,2,1)|(0,4,0)) = ((1,3,1)|(0,3,0))+((1,2,1)|(0,3,0))*AB(2)
        theta(1801) = theta(1601)+theta(1401)*AB(3) ! ((1,2,1)|(0,3,1)) = ((1,2,2)|(0,3,0))+((1,2,1)|(0,3,0))*AB(3)
        theta(1802) = theta(1593)+theta(1403)*AB(2) ! ((1,2,1)|(0,2,2)) = ((1,3,1)|(0,1,2))+((1,2,1)|(0,1,2))*AB(2)
        theta(1803) = theta(1594)+theta(1404)*AB(2) ! ((1,2,1)|(0,1,3)) = ((1,3,1)|(0,0,3))+((1,2,1)|(0,0,3))*AB(2)
        theta(1804) = theta(1604)+theta(1404)*AB(3) ! ((1,2,1)|(0,0,4)) = ((1,2,2)|(0,0,3))+((1,2,1)|(0,0,3))*AB(3)
        theta(1805) = theta(1555)+theta(1405)*AB(1) ! ((1,1,2)|(4,0,0)) = ((2,1,2)|(3,0,0))+((1,1,2)|(3,0,0))*AB(1)
        theta(1806) = theta(1556)+theta(1406)*AB(1) ! ((1,1,2)|(3,1,0)) = ((2,1,2)|(2,1,0))+((1,1,2)|(2,1,0))*AB(1)
        theta(1807) = theta(1605)+theta(1405)*AB(3) ! ((1,1,2)|(3,0,1)) = ((1,1,3)|(3,0,0))+((1,1,2)|(3,0,0))*AB(3)
        theta(1808) = theta(1558)+theta(1408)*AB(1) ! ((1,1,2)|(2,2,0)) = ((2,1,2)|(1,2,0))+((1,1,2)|(1,2,0))*AB(1)
        theta(1809) = theta(1559)+theta(1409)*AB(1) ! ((1,1,2)|(2,1,1)) = ((2,1,2)|(1,1,1))+((1,1,2)|(1,1,1))*AB(1)
        theta(1810) = theta(1560)+theta(1410)*AB(1) ! ((1,1,2)|(2,0,2)) = ((2,1,2)|(1,0,2))+((1,1,2)|(1,0,2))*AB(1)
        theta(1811) = theta(1561)+theta(1411)*AB(1) ! ((1,1,2)|(1,3,0)) = ((2,1,2)|(0,3,0))+((1,1,2)|(0,3,0))*AB(1)
        theta(1812) = theta(1562)+theta(1412)*AB(1) ! ((1,1,2)|(1,2,1)) = ((2,1,2)|(0,2,1))+((1,1,2)|(0,2,1))*AB(1)
        theta(1813) = theta(1563)+theta(1413)*AB(1) ! ((1,1,2)|(1,1,2)) = ((2,1,2)|(0,1,2))+((1,1,2)|(0,1,2))*AB(1)
        theta(1814) = theta(1564)+theta(1414)*AB(1) ! ((1,1,2)|(1,0,3)) = ((2,1,2)|(0,0,3))+((1,1,2)|(0,0,3))*AB(1)
        theta(1815) = theta(1601)+theta(1411)*AB(2) ! ((1,1,2)|(0,4,0)) = ((1,2,2)|(0,3,0))+((1,1,2)|(0,3,0))*AB(2)
        theta(1816) = theta(1611)+theta(1411)*AB(3) ! ((1,1,2)|(0,3,1)) = ((1,1,3)|(0,3,0))+((1,1,2)|(0,3,0))*AB(3)
        theta(1817) = theta(1603)+theta(1413)*AB(2) ! ((1,1,2)|(0,2,2)) = ((1,2,2)|(0,1,2))+((1,1,2)|(0,1,2))*AB(2)
        theta(1818) = theta(1604)+theta(1414)*AB(2) ! ((1,1,2)|(0,1,3)) = ((1,2,2)|(0,0,3))+((1,1,2)|(0,0,3))*AB(2)
        theta(1819) = theta(1614)+theta(1414)*AB(3) ! ((1,1,2)|(0,0,4)) = ((1,1,3)|(0,0,3))+((1,1,2)|(0,0,3))*AB(3)
        theta(1820) = theta(1565)+theta(1415)*AB(1) ! ((1,0,3)|(4,0,0)) = ((2,0,3)|(3,0,0))+((1,0,3)|(3,0,0))*AB(1)
        theta(1821) = theta(1566)+theta(1416)*AB(1) ! ((1,0,3)|(3,1,0)) = ((2,0,3)|(2,1,0))+((1,0,3)|(2,1,0))*AB(1)
        theta(1822) = theta(1615)+theta(1415)*AB(3) ! ((1,0,3)|(3,0,1)) = ((1,0,4)|(3,0,0))+((1,0,3)|(3,0,0))*AB(3)
        theta(1823) = theta(1568)+theta(1418)*AB(1) ! ((1,0,3)|(2,2,0)) = ((2,0,3)|(1,2,0))+((1,0,3)|(1,2,0))*AB(1)
        theta(1824) = theta(1569)+theta(1419)*AB(1) ! ((1,0,3)|(2,1,1)) = ((2,0,3)|(1,1,1))+((1,0,3)|(1,1,1))*AB(1)
        theta(1825) = theta(1570)+theta(1420)*AB(1) ! ((1,0,3)|(2,0,2)) = ((2,0,3)|(1,0,2))+((1,0,3)|(1,0,2))*AB(1)
        theta(1826) = theta(1571)+theta(1421)*AB(1) ! ((1,0,3)|(1,3,0)) = ((2,0,3)|(0,3,0))+((1,0,3)|(0,3,0))*AB(1)
        theta(1827) = theta(1572)+theta(1422)*AB(1) ! ((1,0,3)|(1,2,1)) = ((2,0,3)|(0,2,1))+((1,0,3)|(0,2,1))*AB(1)
        theta(1828) = theta(1573)+theta(1423)*AB(1) ! ((1,0,3)|(1,1,2)) = ((2,0,3)|(0,1,2))+((1,0,3)|(0,1,2))*AB(1)
        theta(1829) = theta(1574)+theta(1424)*AB(1) ! ((1,0,3)|(1,0,3)) = ((2,0,3)|(0,0,3))+((1,0,3)|(0,0,3))*AB(1)
        theta(1830) = theta(1611)+theta(1421)*AB(2) ! ((1,0,3)|(0,4,0)) = ((1,1,3)|(0,3,0))+((1,0,3)|(0,3,0))*AB(2)
        theta(1831) = theta(1621)+theta(1421)*AB(3) ! ((1,0,3)|(0,3,1)) = ((1,0,4)|(0,3,0))+((1,0,3)|(0,3,0))*AB(3)
        theta(1832) = theta(1613)+theta(1423)*AB(2) ! ((1,0,3)|(0,2,2)) = ((1,1,3)|(0,1,2))+((1,0,3)|(0,1,2))*AB(2)
        theta(1833) = theta(1614)+theta(1424)*AB(2) ! ((1,0,3)|(0,1,3)) = ((1,1,3)|(0,0,3))+((1,0,3)|(0,0,3))*AB(2)
        theta(1834) = theta(1624)+theta(1424)*AB(3) ! ((1,0,3)|(0,0,4)) = ((1,0,4)|(0,0,3))+((1,0,3)|(0,0,3))*AB(3)
        theta(1835) = theta(1575)+theta(1425)*AB(1) ! ((0,4,0)|(4,0,0)) = ((1,4,0)|(3,0,0))+((0,4,0)|(3,0,0))*AB(1)
        theta(1836) = theta(1625)+theta(1425)*AB(2) ! ((0,4,0)|(3,1,0)) = ((0,5,0)|(3,0,0))+((0,4,0)|(3,0,0))*AB(2)
        theta(1837) = theta(1635)+theta(1425)*AB(3) ! ((0,4,0)|(3,0,1)) = ((0,4,1)|(3,0,0))+((0,4,0)|(3,0,0))*AB(3)
        theta(1838) = theta(1578)+theta(1428)*AB(1) ! ((0,4,0)|(2,2,0)) = ((1,4,0)|(1,2,0))+((0,4,0)|(1,2,0))*AB(1)
        theta(1839) = theta(1627)+theta(1427)*AB(2) ! ((0,4,0)|(2,1,1)) = ((0,5,0)|(2,0,1))+((0,4,0)|(2,0,1))*AB(2)
        theta(1840) = theta(1580)+theta(1430)*AB(1) ! ((0,4,0)|(2,0,2)) = ((1,4,0)|(1,0,2))+((0,4,0)|(1,0,2))*AB(1)
        theta(1841) = theta(1581)+theta(1431)*AB(1) ! ((0,4,0)|(1,3,0)) = ((1,4,0)|(0,3,0))+((0,4,0)|(0,3,0))*AB(1)
        theta(1842) = theta(1582)+theta(1432)*AB(1) ! ((0,4,0)|(1,2,1)) = ((1,4,0)|(0,2,1))+((0,4,0)|(0,2,1))*AB(1)
        theta(1843) = theta(1583)+theta(1433)*AB(1) ! ((0,4,0)|(1,1,2)) = ((1,4,0)|(0,1,2))+((0,4,0)|(0,1,2))*AB(1)
        theta(1844) = theta(1584)+theta(1434)*AB(1) ! ((0,4,0)|(1,0,3)) = ((1,4,0)|(0,0,3))+((0,4,0)|(0,0,3))*AB(1)
        theta(1845) = theta(1631)+theta(1431)*AB(2) ! ((0,4,0)|(0,4,0)) = ((0,5,0)|(0,3,0))+((0,4,0)|(0,3,0))*AB(2)
        theta(1846) = theta(1641)+theta(1431)*AB(3) ! ((0,4,0)|(0,3,1)) = ((0,4,1)|(0,3,0))+((0,4,0)|(0,3,0))*AB(3)
        theta(1847) = theta(1633)+theta(1433)*AB(2) ! ((0,4,0)|(0,2,2)) = ((0,5,0)|(0,1,2))+((0,4,0)|(0,1,2))*AB(2)
        theta(1848) = theta(1634)+theta(1434)*AB(2) ! ((0,4,0)|(0,1,3)) = ((0,5,0)|(0,0,3))+((0,4,0)|(0,0,3))*AB(2)
        theta(1849) = theta(1644)+theta(1434)*AB(3) ! ((0,4,0)|(0,0,4)) = ((0,4,1)|(0,0,3))+((0,4,0)|(0,0,3))*AB(3)
        theta(1850) = theta(1585)+theta(1435)*AB(1) ! ((0,3,1)|(4,0,0)) = ((1,3,1)|(3,0,0))+((0,3,1)|(3,0,0))*AB(1)
        theta(1851) = theta(1586)+theta(1436)*AB(1) ! ((0,3,1)|(3,1,0)) = ((1,3,1)|(2,1,0))+((0,3,1)|(2,1,0))*AB(1)
        theta(1852) = theta(1645)+theta(1435)*AB(3) ! ((0,3,1)|(3,0,1)) = ((0,3,2)|(3,0,0))+((0,3,1)|(3,0,0))*AB(3)
        theta(1853) = theta(1588)+theta(1438)*AB(1) ! ((0,3,1)|(2,2,0)) = ((1,3,1)|(1,2,0))+((0,3,1)|(1,2,0))*AB(1)
        theta(1854) = theta(1589)+theta(1439)*AB(1) ! ((0,3,1)|(2,1,1)) = ((1,3,1)|(1,1,1))+((0,3,1)|(1,1,1))*AB(1)
        theta(1855) = theta(1590)+theta(1440)*AB(1) ! ((0,3,1)|(2,0,2)) = ((1,3,1)|(1,0,2))+((0,3,1)|(1,0,2))*AB(1)
        theta(1856) = theta(1591)+theta(1441)*AB(1) ! ((0,3,1)|(1,3,0)) = ((1,3,1)|(0,3,0))+((0,3,1)|(0,3,0))*AB(1)
        theta(1857) = theta(1592)+theta(1442)*AB(1) ! ((0,3,1)|(1,2,1)) = ((1,3,1)|(0,2,1))+((0,3,1)|(0,2,1))*AB(1)
        theta(1858) = theta(1593)+theta(1443)*AB(1) ! ((0,3,1)|(1,1,2)) = ((1,3,1)|(0,1,2))+((0,3,1)|(0,1,2))*AB(1)
        theta(1859) = theta(1594)+theta(1444)*AB(1) ! ((0,3,1)|(1,0,3)) = ((1,3,1)|(0,0,3))+((0,3,1)|(0,0,3))*AB(1)
        theta(1860) = theta(1641)+theta(1441)*AB(2) ! ((0,3,1)|(0,4,0)) = ((0,4,1)|(0,3,0))+((0,3,1)|(0,3,0))*AB(2)
        theta(1861) = theta(1651)+theta(1441)*AB(3) ! ((0,3,1)|(0,3,1)) = ((0,3,2)|(0,3,0))+((0,3,1)|(0,3,0))*AB(3)
        theta(1862) = theta(1643)+theta(1443)*AB(2) ! ((0,3,1)|(0,2,2)) = ((0,4,1)|(0,1,2))+((0,3,1)|(0,1,2))*AB(2)
        theta(1863) = theta(1644)+theta(1444)*AB(2) ! ((0,3,1)|(0,1,3)) = ((0,4,1)|(0,0,3))+((0,3,1)|(0,0,3))*AB(2)
        theta(1864) = theta(1654)+theta(1444)*AB(3) ! ((0,3,1)|(0,0,4)) = ((0,3,2)|(0,0,3))+((0,3,1)|(0,0,3))*AB(3)
        theta(1865) = theta(1595)+theta(1445)*AB(1) ! ((0,2,2)|(4,0,0)) = ((1,2,2)|(3,0,0))+((0,2,2)|(3,0,0))*AB(1)
        theta(1866) = theta(1596)+theta(1446)*AB(1) ! ((0,2,2)|(3,1,0)) = ((1,2,2)|(2,1,0))+((0,2,2)|(2,1,0))*AB(1)
        theta(1867) = theta(1655)+theta(1445)*AB(3) ! ((0,2,2)|(3,0,1)) = ((0,2,3)|(3,0,0))+((0,2,2)|(3,0,0))*AB(3)
        theta(1868) = theta(1598)+theta(1448)*AB(1) ! ((0,2,2)|(2,2,0)) = ((1,2,2)|(1,2,0))+((0,2,2)|(1,2,0))*AB(1)
        theta(1869) = theta(1599)+theta(1449)*AB(1) ! ((0,2,2)|(2,1,1)) = ((1,2,2)|(1,1,1))+((0,2,2)|(1,1,1))*AB(1)
        theta(1870) = theta(1600)+theta(1450)*AB(1) ! ((0,2,2)|(2,0,2)) = ((1,2,2)|(1,0,2))+((0,2,2)|(1,0,2))*AB(1)
        theta(1871) = theta(1601)+theta(1451)*AB(1) ! ((0,2,2)|(1,3,0)) = ((1,2,2)|(0,3,0))+((0,2,2)|(0,3,0))*AB(1)
        theta(1872) = theta(1602)+theta(1452)*AB(1) ! ((0,2,2)|(1,2,1)) = ((1,2,2)|(0,2,1))+((0,2,2)|(0,2,1))*AB(1)
        theta(1873) = theta(1603)+theta(1453)*AB(1) ! ((0,2,2)|(1,1,2)) = ((1,2,2)|(0,1,2))+((0,2,2)|(0,1,2))*AB(1)
        theta(1874) = theta(1604)+theta(1454)*AB(1) ! ((0,2,2)|(1,0,3)) = ((1,2,2)|(0,0,3))+((0,2,2)|(0,0,3))*AB(1)
        theta(1875) = theta(1651)+theta(1451)*AB(2) ! ((0,2,2)|(0,4,0)) = ((0,3,2)|(0,3,0))+((0,2,2)|(0,3,0))*AB(2)
        theta(1876) = theta(1661)+theta(1451)*AB(3) ! ((0,2,2)|(0,3,1)) = ((0,2,3)|(0,3,0))+((0,2,2)|(0,3,0))*AB(3)
        theta(1877) = theta(1653)+theta(1453)*AB(2) ! ((0,2,2)|(0,2,2)) = ((0,3,2)|(0,1,2))+((0,2,2)|(0,1,2))*AB(2)
        theta(1878) = theta(1654)+theta(1454)*AB(2) ! ((0,2,2)|(0,1,3)) = ((0,3,2)|(0,0,3))+((0,2,2)|(0,0,3))*AB(2)
        theta(1879) = theta(1664)+theta(1454)*AB(3) ! ((0,2,2)|(0,0,4)) = ((0,2,3)|(0,0,3))+((0,2,2)|(0,0,3))*AB(3)
        theta(1880) = theta(1605)+theta(1455)*AB(1) ! ((0,1,3)|(4,0,0)) = ((1,1,3)|(3,0,0))+((0,1,3)|(3,0,0))*AB(1)
        theta(1881) = theta(1606)+theta(1456)*AB(1) ! ((0,1,3)|(3,1,0)) = ((1,1,3)|(2,1,0))+((0,1,3)|(2,1,0))*AB(1)
        theta(1882) = theta(1665)+theta(1455)*AB(3) ! ((0,1,3)|(3,0,1)) = ((0,1,4)|(3,0,0))+((0,1,3)|(3,0,0))*AB(3)
        theta(1883) = theta(1608)+theta(1458)*AB(1) ! ((0,1,3)|(2,2,0)) = ((1,1,3)|(1,2,0))+((0,1,3)|(1,2,0))*AB(1)
        theta(1884) = theta(1609)+theta(1459)*AB(1) ! ((0,1,3)|(2,1,1)) = ((1,1,3)|(1,1,1))+((0,1,3)|(1,1,1))*AB(1)
        theta(1885) = theta(1610)+theta(1460)*AB(1) ! ((0,1,3)|(2,0,2)) = ((1,1,3)|(1,0,2))+((0,1,3)|(1,0,2))*AB(1)
        theta(1886) = theta(1611)+theta(1461)*AB(1) ! ((0,1,3)|(1,3,0)) = ((1,1,3)|(0,3,0))+((0,1,3)|(0,3,0))*AB(1)
        theta(1887) = theta(1612)+theta(1462)*AB(1) ! ((0,1,3)|(1,2,1)) = ((1,1,3)|(0,2,1))+((0,1,3)|(0,2,1))*AB(1)
        theta(1888) = theta(1613)+theta(1463)*AB(1) ! ((0,1,3)|(1,1,2)) = ((1,1,3)|(0,1,2))+((0,1,3)|(0,1,2))*AB(1)
        theta(1889) = theta(1614)+theta(1464)*AB(1) ! ((0,1,3)|(1,0,3)) = ((1,1,3)|(0,0,3))+((0,1,3)|(0,0,3))*AB(1)
        theta(1890) = theta(1661)+theta(1461)*AB(2) ! ((0,1,3)|(0,4,0)) = ((0,2,3)|(0,3,0))+((0,1,3)|(0,3,0))*AB(2)
        theta(1891) = theta(1671)+theta(1461)*AB(3) ! ((0,1,3)|(0,3,1)) = ((0,1,4)|(0,3,0))+((0,1,3)|(0,3,0))*AB(3)
        theta(1892) = theta(1663)+theta(1463)*AB(2) ! ((0,1,3)|(0,2,2)) = ((0,2,3)|(0,1,2))+((0,1,3)|(0,1,2))*AB(2)
        theta(1893) = theta(1664)+theta(1464)*AB(2) ! ((0,1,3)|(0,1,3)) = ((0,2,3)|(0,0,3))+((0,1,3)|(0,0,3))*AB(2)
        theta(1894) = theta(1674)+theta(1464)*AB(3) ! ((0,1,3)|(0,0,4)) = ((0,1,4)|(0,0,3))+((0,1,3)|(0,0,3))*AB(3)
        theta(1895) = theta(1615)+theta(1465)*AB(1) ! ((0,0,4)|(4,0,0)) = ((1,0,4)|(3,0,0))+((0,0,4)|(3,0,0))*AB(1)
        theta(1896) = theta(1616)+theta(1466)*AB(1) ! ((0,0,4)|(3,1,0)) = ((1,0,4)|(2,1,0))+((0,0,4)|(2,1,0))*AB(1)
        theta(1897) = theta(1675)+theta(1465)*AB(3) ! ((0,0,4)|(3,0,1)) = ((0,0,5)|(3,0,0))+((0,0,4)|(3,0,0))*AB(3)
        theta(1898) = theta(1618)+theta(1468)*AB(1) ! ((0,0,4)|(2,2,0)) = ((1,0,4)|(1,2,0))+((0,0,4)|(1,2,0))*AB(1)
        theta(1899) = theta(1619)+theta(1469)*AB(1) ! ((0,0,4)|(2,1,1)) = ((1,0,4)|(1,1,1))+((0,0,4)|(1,1,1))*AB(1)
        theta(1900) = theta(1620)+theta(1470)*AB(1) ! ((0,0,4)|(2,0,2)) = ((1,0,4)|(1,0,2))+((0,0,4)|(1,0,2))*AB(1)
        theta(1901) = theta(1621)+theta(1471)*AB(1) ! ((0,0,4)|(1,3,0)) = ((1,0,4)|(0,3,0))+((0,0,4)|(0,3,0))*AB(1)
        theta(1902) = theta(1622)+theta(1472)*AB(1) ! ((0,0,4)|(1,2,1)) = ((1,0,4)|(0,2,1))+((0,0,4)|(0,2,1))*AB(1)
        theta(1903) = theta(1623)+theta(1473)*AB(1) ! ((0,0,4)|(1,1,2)) = ((1,0,4)|(0,1,2))+((0,0,4)|(0,1,2))*AB(1)
        theta(1904) = theta(1624)+theta(1474)*AB(1) ! ((0,0,4)|(1,0,3)) = ((1,0,4)|(0,0,3))+((0,0,4)|(0,0,3))*AB(1)
        theta(1905) = theta(1671)+theta(1471)*AB(2) ! ((0,0,4)|(0,4,0)) = ((0,1,4)|(0,3,0))+((0,0,4)|(0,3,0))*AB(2)
        theta(1906) = theta(1681)+theta(1471)*AB(3) ! ((0,0,4)|(0,3,1)) = ((0,0,5)|(0,3,0))+((0,0,4)|(0,3,0))*AB(3)
        theta(1907) = theta(1673)+theta(1473)*AB(2) ! ((0,0,4)|(0,2,2)) = ((0,1,4)|(0,1,2))+((0,0,4)|(0,1,2))*AB(2)
        theta(1908) = theta(1674)+theta(1474)*AB(2) ! ((0,0,4)|(0,1,3)) = ((0,1,4)|(0,0,3))+((0,0,4)|(0,0,3))*AB(2)
        theta(1909) = theta(1684)+theta(1474)*AB(3) ! ((0,0,4)|(0,0,4)) = ((0,0,5)|(0,0,3))+((0,0,4)|(0,0,3))*AB(3)
    end subroutine
    subroutine hrr_5_0(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 21; Optimized integrals: 21
    end subroutine
    subroutine hrr_5_1(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 112; Optimized integrals: 112
        theta(260) = theta(232)+theta(211)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(261) = theta(233)+theta(211)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(262) = theta(234)+theta(211)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(263) = theta(233)+theta(212)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(264) = theta(235)+theta(212)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(265) = theta(236)+theta(212)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(266) = theta(234)+theta(213)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(267) = theta(236)+theta(213)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(268) = theta(237)+theta(213)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(269) = theta(235)+theta(214)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(270) = theta(238)+theta(214)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(271) = theta(239)+theta(214)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(272) = theta(236)+theta(215)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(273) = theta(239)+theta(215)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(274) = theta(240)+theta(215)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(275) = theta(237)+theta(216)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(276) = theta(240)+theta(216)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(277) = theta(241)+theta(216)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(278) = theta(238)+theta(217)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(279) = theta(242)+theta(217)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(280) = theta(243)+theta(217)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(281) = theta(239)+theta(218)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(282) = theta(243)+theta(218)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(283) = theta(244)+theta(218)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(284) = theta(240)+theta(219)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(285) = theta(244)+theta(219)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(286) = theta(245)+theta(219)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(287) = theta(241)+theta(220)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(288) = theta(245)+theta(220)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(289) = theta(246)+theta(220)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(290) = theta(242)+theta(221)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(291) = theta(247)+theta(221)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(292) = theta(248)+theta(221)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(293) = theta(243)+theta(222)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(294) = theta(248)+theta(222)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(295) = theta(249)+theta(222)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(296) = theta(244)+theta(223)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(297) = theta(249)+theta(223)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(298) = theta(250)+theta(223)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(299) = theta(245)+theta(224)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(300) = theta(250)+theta(224)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(301) = theta(251)+theta(224)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(302) = theta(246)+theta(225)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(303) = theta(251)+theta(225)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(304) = theta(252)+theta(225)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(305) = theta(247)+theta(226)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(306) = theta(253)+theta(226)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(307) = theta(254)+theta(226)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(308) = theta(248)+theta(227)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(309) = theta(254)+theta(227)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(310) = theta(255)+theta(227)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(311) = theta(249)+theta(228)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(312) = theta(255)+theta(228)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(313) = theta(256)+theta(228)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(314) = theta(250)+theta(229)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(315) = theta(256)+theta(229)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(316) = theta(257)+theta(229)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(317) = theta(251)+theta(230)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(318) = theta(257)+theta(230)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(319) = theta(258)+theta(230)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(320) = theta(252)+theta(231)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(321) = theta(258)+theta(231)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(322) = theta(259)+theta(231)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
    end subroutine
    subroutine hrr_5_2(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 358; Optimized integrals: 350
        theta(416) = theta(352)+theta(331)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(417) = theta(353)+theta(331)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(418) = theta(354)+theta(331)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(419) = theta(353)+theta(332)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(420) = theta(355)+theta(332)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(421) = theta(356)+theta(332)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(422) = theta(354)+theta(333)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(423) = theta(356)+theta(333)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(424) = theta(357)+theta(333)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(425) = theta(355)+theta(334)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(426) = theta(358)+theta(334)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(427) = theta(359)+theta(334)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(428) = theta(356)+theta(335)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(429) = theta(359)+theta(335)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(430) = theta(360)+theta(335)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(431) = theta(357)+theta(336)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(432) = theta(360)+theta(336)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(433) = theta(361)+theta(336)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(434) = theta(358)+theta(337)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(435) = theta(362)+theta(337)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(436) = theta(363)+theta(337)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(437) = theta(359)+theta(338)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(438) = theta(363)+theta(338)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(439) = theta(364)+theta(338)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(440) = theta(360)+theta(339)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(441) = theta(364)+theta(339)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(442) = theta(365)+theta(339)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(443) = theta(361)+theta(340)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(444) = theta(365)+theta(340)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(445) = theta(366)+theta(340)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(446) = theta(362)+theta(341)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(447) = theta(367)+theta(341)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(448) = theta(368)+theta(341)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(449) = theta(363)+theta(342)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(450) = theta(368)+theta(342)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(451) = theta(369)+theta(342)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(452) = theta(364)+theta(343)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(453) = theta(369)+theta(343)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(454) = theta(370)+theta(343)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(455) = theta(365)+theta(344)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(456) = theta(370)+theta(344)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(457) = theta(371)+theta(344)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(458) = theta(366)+theta(345)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(459) = theta(371)+theta(345)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(460) = theta(372)+theta(345)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(461) = theta(367)+theta(346)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(462) = theta(373)+theta(346)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(463) = theta(374)+theta(346)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(464) = theta(368)+theta(347)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(465) = theta(374)+theta(347)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(466) = theta(375)+theta(347)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(467) = theta(369)+theta(348)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(468) = theta(375)+theta(348)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(469) = theta(376)+theta(348)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(470) = theta(370)+theta(349)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(471) = theta(376)+theta(349)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(472) = theta(377)+theta(349)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(473) = theta(371)+theta(350)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(474) = theta(377)+theta(350)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(475) = theta(378)+theta(350)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(476) = theta(372)+theta(351)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(477) = theta(378)+theta(351)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(478) = theta(379)+theta(351)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(479) = theta(380)+theta(352)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(480) = theta(381)+theta(352)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        theta(481) = theta(382)+theta(352)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(482) = theta(381)+theta(353)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(483) = theta(383)+theta(353)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(484) = theta(384)+theta(353)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(485) = theta(382)+theta(354)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(486) = theta(384)+theta(354)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(487) = theta(385)+theta(354)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(488) = theta(383)+theta(355)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(489) = theta(386)+theta(355)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(490) = theta(387)+theta(355)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(491) = theta(384)+theta(356)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(492) = theta(387)+theta(356)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(493) = theta(388)+theta(356)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(494) = theta(385)+theta(357)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(495) = theta(388)+theta(357)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(496) = theta(389)+theta(357)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(497) = theta(386)+theta(358)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(498) = theta(390)+theta(358)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(499) = theta(391)+theta(358)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(500) = theta(387)+theta(359)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(501) = theta(391)+theta(359)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(502) = theta(392)+theta(359)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(503) = theta(388)+theta(360)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(504) = theta(392)+theta(360)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(505) = theta(393)+theta(360)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(506) = theta(389)+theta(361)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(507) = theta(393)+theta(361)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(508) = theta(394)+theta(361)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(509) = theta(390)+theta(362)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(510) = theta(395)+theta(362)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(511) = theta(396)+theta(362)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(512) = theta(391)+theta(363)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(513) = theta(396)+theta(363)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(514) = theta(397)+theta(363)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(515) = theta(392)+theta(364)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(516) = theta(397)+theta(364)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(517) = theta(398)+theta(364)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(518) = theta(393)+theta(365)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(519) = theta(398)+theta(365)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(520) = theta(399)+theta(365)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(521) = theta(394)+theta(366)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(522) = theta(399)+theta(366)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(523) = theta(400)+theta(366)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(524) = theta(395)+theta(367)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(525) = theta(401)+theta(367)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(526) = theta(402)+theta(367)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(527) = theta(396)+theta(368)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(528) = theta(402)+theta(368)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(529) = theta(403)+theta(368)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(530) = theta(397)+theta(369)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(531) = theta(403)+theta(369)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(532) = theta(404)+theta(369)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(533) = theta(398)+theta(370)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(534) = theta(404)+theta(370)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(535) = theta(405)+theta(370)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(536) = theta(399)+theta(371)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(537) = theta(405)+theta(371)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(538) = theta(406)+theta(371)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(539) = theta(400)+theta(372)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        theta(540) = theta(406)+theta(372)*AB(2) ! ((1,0,5)|(0,1,0)) = ((1,1,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(2)
        theta(541) = theta(407)+theta(372)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        ! theta(542) = theta(401)+theta(373)*AB(1) ! ((0,6,0)|(1,0,0)) = ((1,6,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(1)
        theta(543) = theta(408)+theta(373)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(544) = theta(409)+theta(373)*AB(3) ! ((0,6,0)|(0,0,1)) = ((0,6,1)|(0,0,0))+((0,6,0)|(0,0,0))*AB(3)
        ! theta(545) = theta(402)+theta(374)*AB(1) ! ((0,5,1)|(1,0,0)) = ((1,5,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(1)
        theta(546) = theta(409)+theta(374)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(547) = theta(410)+theta(374)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        ! theta(548) = theta(403)+theta(375)*AB(1) ! ((0,4,2)|(1,0,0)) = ((1,4,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(1)
        theta(549) = theta(410)+theta(375)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(550) = theta(411)+theta(375)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        ! theta(551) = theta(404)+theta(376)*AB(1) ! ((0,3,3)|(1,0,0)) = ((1,3,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(1)
        theta(552) = theta(411)+theta(376)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(553) = theta(412)+theta(376)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        ! theta(554) = theta(405)+theta(377)*AB(1) ! ((0,2,4)|(1,0,0)) = ((1,2,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(1)
        theta(555) = theta(412)+theta(377)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(556) = theta(413)+theta(377)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        ! theta(557) = theta(406)+theta(378)*AB(1) ! ((0,1,5)|(1,0,0)) = ((1,1,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(1)
        theta(558) = theta(413)+theta(378)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(559) = theta(414)+theta(378)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        ! theta(560) = theta(407)+theta(379)*AB(1) ! ((0,0,6)|(1,0,0)) = ((1,0,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(1)
        ! theta(561) = theta(414)+theta(379)*AB(2) ! ((0,0,6)|(0,1,0)) = ((0,1,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(2)
        theta(562) = theta(415)+theta(379)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(563) = theta(479)+theta(416)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        theta(564) = theta(480)+theta(417)*AB(1) ! ((5,0,0)|(1,1,0)) = ((6,0,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(1)
        theta(565) = theta(481)+theta(418)*AB(1) ! ((5,0,0)|(1,0,1)) = ((6,0,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(1)
        theta(566) = theta(483)+theta(417)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        theta(567) = theta(484)+theta(418)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        theta(568) = theta(487)+theta(418)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(569) = theta(482)+theta(419)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        theta(570) = theta(483)+theta(420)*AB(1) ! ((4,1,0)|(1,1,0)) = ((5,1,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(1)
        theta(571) = theta(484)+theta(421)*AB(1) ! ((4,1,0)|(1,0,1)) = ((5,1,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(1)
        theta(572) = theta(489)+theta(420)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(573) = theta(490)+theta(421)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        theta(574) = theta(493)+theta(421)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(575) = theta(485)+theta(422)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(576) = theta(486)+theta(423)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        theta(577) = theta(487)+theta(424)*AB(1) ! ((4,0,1)|(1,0,1)) = ((5,0,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(1)
        theta(578) = theta(492)+theta(423)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(579) = theta(493)+theta(424)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(580) = theta(496)+theta(424)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(581) = theta(488)+theta(425)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        theta(582) = theta(489)+theta(426)*AB(1) ! ((3,2,0)|(1,1,0)) = ((4,2,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(1)
        theta(583) = theta(490)+theta(427)*AB(1) ! ((3,2,0)|(1,0,1)) = ((4,2,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(1)
        theta(584) = theta(498)+theta(426)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(585) = theta(499)+theta(427)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        theta(586) = theta(502)+theta(427)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(587) = theta(491)+theta(428)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(588) = theta(492)+theta(429)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        theta(589) = theta(493)+theta(430)*AB(1) ! ((3,1,1)|(1,0,1)) = ((4,1,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(1)
        theta(590) = theta(501)+theta(429)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(591) = theta(502)+theta(430)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(592) = theta(505)+theta(430)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(593) = theta(494)+theta(431)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(594) = theta(495)+theta(432)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        theta(595) = theta(496)+theta(433)*AB(1) ! ((3,0,2)|(1,0,1)) = ((4,0,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(1)
        theta(596) = theta(504)+theta(432)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(597) = theta(505)+theta(433)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(598) = theta(508)+theta(433)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(599) = theta(497)+theta(434)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        theta(600) = theta(498)+theta(435)*AB(1) ! ((2,3,0)|(1,1,0)) = ((3,3,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(1)
        theta(601) = theta(499)+theta(436)*AB(1) ! ((2,3,0)|(1,0,1)) = ((3,3,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(1)
        theta(602) = theta(510)+theta(435)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(603) = theta(511)+theta(436)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        theta(604) = theta(514)+theta(436)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(605) = theta(500)+theta(437)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(606) = theta(501)+theta(438)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        theta(607) = theta(502)+theta(439)*AB(1) ! ((2,2,1)|(1,0,1)) = ((3,2,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(1)
        theta(608) = theta(513)+theta(438)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(609) = theta(514)+theta(439)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(610) = theta(517)+theta(439)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(611) = theta(503)+theta(440)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(612) = theta(504)+theta(441)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        theta(613) = theta(505)+theta(442)*AB(1) ! ((2,1,2)|(1,0,1)) = ((3,1,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(1)
        theta(614) = theta(516)+theta(441)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(615) = theta(517)+theta(442)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(616) = theta(520)+theta(442)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(617) = theta(506)+theta(443)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(618) = theta(507)+theta(444)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        theta(619) = theta(508)+theta(445)*AB(1) ! ((2,0,3)|(1,0,1)) = ((3,0,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(1)
        theta(620) = theta(519)+theta(444)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(621) = theta(520)+theta(445)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(622) = theta(523)+theta(445)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(623) = theta(509)+theta(446)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        theta(624) = theta(510)+theta(447)*AB(1) ! ((1,4,0)|(1,1,0)) = ((2,4,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(1)
        theta(625) = theta(511)+theta(448)*AB(1) ! ((1,4,0)|(1,0,1)) = ((2,4,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(1)
        theta(626) = theta(525)+theta(447)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(627) = theta(526)+theta(448)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        theta(628) = theta(529)+theta(448)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(629) = theta(512)+theta(449)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(630) = theta(513)+theta(450)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        theta(631) = theta(514)+theta(451)*AB(1) ! ((1,3,1)|(1,0,1)) = ((2,3,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(1)
        theta(632) = theta(528)+theta(450)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(633) = theta(529)+theta(451)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(634) = theta(532)+theta(451)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(635) = theta(515)+theta(452)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(636) = theta(516)+theta(453)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        theta(637) = theta(517)+theta(454)*AB(1) ! ((1,2,2)|(1,0,1)) = ((2,2,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(1)
        theta(638) = theta(531)+theta(453)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(639) = theta(532)+theta(454)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(640) = theta(535)+theta(454)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(641) = theta(518)+theta(455)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(642) = theta(519)+theta(456)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        theta(643) = theta(520)+theta(457)*AB(1) ! ((1,1,3)|(1,0,1)) = ((2,1,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(1)
        theta(644) = theta(534)+theta(456)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(645) = theta(535)+theta(457)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(646) = theta(538)+theta(457)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(647) = theta(521)+theta(458)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(648) = theta(522)+theta(459)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        theta(649) = theta(523)+theta(460)*AB(1) ! ((1,0,4)|(1,0,1)) = ((2,0,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(1)
        theta(650) = theta(537)+theta(459)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(651) = theta(538)+theta(460)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(652) = theta(541)+theta(460)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(653) = theta(524)+theta(461)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        theta(654) = theta(525)+theta(462)*AB(1) ! ((0,5,0)|(1,1,0)) = ((1,5,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(1)
        theta(655) = theta(526)+theta(463)*AB(1) ! ((0,5,0)|(1,0,1)) = ((1,5,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(1)
        theta(656) = theta(543)+theta(462)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        theta(657) = theta(544)+theta(463)*AB(2) ! ((0,5,0)|(0,1,1)) = ((0,6,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(2)
        theta(658) = theta(547)+theta(463)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(659) = theta(527)+theta(464)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        theta(660) = theta(528)+theta(465)*AB(1) ! ((0,4,1)|(1,1,0)) = ((1,4,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(1)
        theta(661) = theta(529)+theta(466)*AB(1) ! ((0,4,1)|(1,0,1)) = ((1,4,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(1)
        theta(662) = theta(546)+theta(465)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(663) = theta(547)+theta(466)*AB(2) ! ((0,4,1)|(0,1,1)) = ((0,5,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(2)
        theta(664) = theta(550)+theta(466)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(665) = theta(530)+theta(467)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        theta(666) = theta(531)+theta(468)*AB(1) ! ((0,3,2)|(1,1,0)) = ((1,3,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(1)
        theta(667) = theta(532)+theta(469)*AB(1) ! ((0,3,2)|(1,0,1)) = ((1,3,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(1)
        theta(668) = theta(549)+theta(468)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(669) = theta(550)+theta(469)*AB(2) ! ((0,3,2)|(0,1,1)) = ((0,4,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(2)
        theta(670) = theta(553)+theta(469)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(671) = theta(533)+theta(470)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        theta(672) = theta(534)+theta(471)*AB(1) ! ((0,2,3)|(1,1,0)) = ((1,2,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(1)
        theta(673) = theta(535)+theta(472)*AB(1) ! ((0,2,3)|(1,0,1)) = ((1,2,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(1)
        theta(674) = theta(552)+theta(471)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(675) = theta(553)+theta(472)*AB(2) ! ((0,2,3)|(0,1,1)) = ((0,3,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(2)
        theta(676) = theta(556)+theta(472)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(677) = theta(536)+theta(473)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        theta(678) = theta(537)+theta(474)*AB(1) ! ((0,1,4)|(1,1,0)) = ((1,1,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(1)
        theta(679) = theta(538)+theta(475)*AB(1) ! ((0,1,4)|(1,0,1)) = ((1,1,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(1)
        theta(680) = theta(555)+theta(474)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(681) = theta(556)+theta(475)*AB(2) ! ((0,1,4)|(0,1,1)) = ((0,2,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(2)
        theta(682) = theta(559)+theta(475)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(683) = theta(539)+theta(476)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        theta(684) = theta(540)+theta(477)*AB(1) ! ((0,0,5)|(1,1,0)) = ((1,0,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(1)
        theta(685) = theta(541)+theta(478)*AB(1) ! ((0,0,5)|(1,0,1)) = ((1,0,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(1)
        theta(686) = theta(558)+theta(477)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        theta(687) = theta(559)+theta(478)*AB(2) ! ((0,0,5)|(0,1,1)) = ((0,1,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(2)
        theta(688) = theta(562)+theta(478)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
    end subroutine
    subroutine hrr_5_3(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 889; Optimized integrals: 801
        theta(626) = theta(517)+theta(496)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(627) = theta(518)+theta(496)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(628) = theta(519)+theta(496)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(629) = theta(518)+theta(497)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(630) = theta(520)+theta(497)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(631) = theta(521)+theta(497)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(632) = theta(519)+theta(498)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(633) = theta(521)+theta(498)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(634) = theta(522)+theta(498)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(635) = theta(520)+theta(499)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(636) = theta(523)+theta(499)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(637) = theta(524)+theta(499)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(638) = theta(521)+theta(500)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(639) = theta(524)+theta(500)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(640) = theta(525)+theta(500)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(641) = theta(522)+theta(501)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(642) = theta(525)+theta(501)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(643) = theta(526)+theta(501)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(644) = theta(523)+theta(502)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(645) = theta(527)+theta(502)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(646) = theta(528)+theta(502)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(647) = theta(524)+theta(503)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(648) = theta(528)+theta(503)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(649) = theta(529)+theta(503)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(650) = theta(525)+theta(504)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(651) = theta(529)+theta(504)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(652) = theta(530)+theta(504)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(653) = theta(526)+theta(505)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(654) = theta(530)+theta(505)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(655) = theta(531)+theta(505)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(656) = theta(527)+theta(506)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(657) = theta(532)+theta(506)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(658) = theta(533)+theta(506)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(659) = theta(528)+theta(507)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(660) = theta(533)+theta(507)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(661) = theta(534)+theta(507)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(662) = theta(529)+theta(508)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(663) = theta(534)+theta(508)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(664) = theta(535)+theta(508)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(665) = theta(530)+theta(509)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(666) = theta(535)+theta(509)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(667) = theta(536)+theta(509)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(668) = theta(531)+theta(510)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(669) = theta(536)+theta(510)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(670) = theta(537)+theta(510)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(671) = theta(532)+theta(511)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(672) = theta(538)+theta(511)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(673) = theta(539)+theta(511)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(674) = theta(533)+theta(512)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(675) = theta(539)+theta(512)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(676) = theta(540)+theta(512)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(677) = theta(534)+theta(513)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(678) = theta(540)+theta(513)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(679) = theta(541)+theta(513)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(680) = theta(535)+theta(514)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(681) = theta(541)+theta(514)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(682) = theta(542)+theta(514)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(683) = theta(536)+theta(515)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(684) = theta(542)+theta(515)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(685) = theta(543)+theta(515)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(686) = theta(537)+theta(516)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(687) = theta(543)+theta(516)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(688) = theta(544)+theta(516)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(689) = theta(545)+theta(517)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(690) = theta(546)+theta(517)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        theta(691) = theta(547)+theta(517)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(692) = theta(546)+theta(518)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(693) = theta(548)+theta(518)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(694) = theta(549)+theta(518)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(695) = theta(547)+theta(519)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(696) = theta(549)+theta(519)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(697) = theta(550)+theta(519)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(698) = theta(548)+theta(520)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(699) = theta(551)+theta(520)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(700) = theta(552)+theta(520)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(701) = theta(549)+theta(521)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(702) = theta(552)+theta(521)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(703) = theta(553)+theta(521)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(704) = theta(550)+theta(522)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(705) = theta(553)+theta(522)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(706) = theta(554)+theta(522)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(707) = theta(551)+theta(523)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(708) = theta(555)+theta(523)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(709) = theta(556)+theta(523)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(710) = theta(552)+theta(524)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(711) = theta(556)+theta(524)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(712) = theta(557)+theta(524)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(713) = theta(553)+theta(525)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(714) = theta(557)+theta(525)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(715) = theta(558)+theta(525)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(716) = theta(554)+theta(526)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(717) = theta(558)+theta(526)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(718) = theta(559)+theta(526)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(719) = theta(555)+theta(527)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(720) = theta(560)+theta(527)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(721) = theta(561)+theta(527)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(722) = theta(556)+theta(528)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(723) = theta(561)+theta(528)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(724) = theta(562)+theta(528)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(725) = theta(557)+theta(529)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(726) = theta(562)+theta(529)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(727) = theta(563)+theta(529)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(728) = theta(558)+theta(530)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(729) = theta(563)+theta(530)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(730) = theta(564)+theta(530)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(731) = theta(559)+theta(531)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(732) = theta(564)+theta(531)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(733) = theta(565)+theta(531)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(734) = theta(560)+theta(532)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(735) = theta(566)+theta(532)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(736) = theta(567)+theta(532)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(737) = theta(561)+theta(533)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(738) = theta(567)+theta(533)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(739) = theta(568)+theta(533)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(740) = theta(562)+theta(534)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(741) = theta(568)+theta(534)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(742) = theta(569)+theta(534)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(743) = theta(563)+theta(535)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(744) = theta(569)+theta(535)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(745) = theta(570)+theta(535)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(746) = theta(564)+theta(536)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(747) = theta(570)+theta(536)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(748) = theta(571)+theta(536)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(749) = theta(565)+theta(537)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        theta(750) = theta(571)+theta(537)*AB(2) ! ((1,0,5)|(0,1,0)) = ((1,1,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(2)
        theta(751) = theta(572)+theta(537)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(752) = theta(566)+theta(538)*AB(1) ! ((0,6,0)|(1,0,0)) = ((1,6,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(1)
        theta(753) = theta(573)+theta(538)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(754) = theta(574)+theta(538)*AB(3) ! ((0,6,0)|(0,0,1)) = ((0,6,1)|(0,0,0))+((0,6,0)|(0,0,0))*AB(3)
        theta(755) = theta(567)+theta(539)*AB(1) ! ((0,5,1)|(1,0,0)) = ((1,5,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(1)
        theta(756) = theta(574)+theta(539)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(757) = theta(575)+theta(539)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(758) = theta(568)+theta(540)*AB(1) ! ((0,4,2)|(1,0,0)) = ((1,4,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(1)
        theta(759) = theta(575)+theta(540)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(760) = theta(576)+theta(540)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(761) = theta(569)+theta(541)*AB(1) ! ((0,3,3)|(1,0,0)) = ((1,3,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(1)
        theta(762) = theta(576)+theta(541)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(763) = theta(577)+theta(541)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(764) = theta(570)+theta(542)*AB(1) ! ((0,2,4)|(1,0,0)) = ((1,2,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(1)
        theta(765) = theta(577)+theta(542)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(766) = theta(578)+theta(542)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(767) = theta(571)+theta(543)*AB(1) ! ((0,1,5)|(1,0,0)) = ((1,1,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(1)
        theta(768) = theta(578)+theta(543)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(769) = theta(579)+theta(543)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(770) = theta(572)+theta(544)*AB(1) ! ((0,0,6)|(1,0,0)) = ((1,0,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(1)
        theta(771) = theta(579)+theta(544)*AB(2) ! ((0,0,6)|(0,1,0)) = ((0,1,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(2)
        theta(772) = theta(580)+theta(544)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(773) = theta(581)+theta(545)*AB(1) ! ((7,0,0)|(1,0,0)) = ((8,0,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(1)
        ! theta(774) = theta(582)+theta(545)*AB(2) ! ((7,0,0)|(0,1,0)) = ((7,1,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(2)
        ! theta(775) = theta(583)+theta(545)*AB(3) ! ((7,0,0)|(0,0,1)) = ((7,0,1)|(0,0,0))+((7,0,0)|(0,0,0))*AB(3)
        theta(776) = theta(582)+theta(546)*AB(1) ! ((6,1,0)|(1,0,0)) = ((7,1,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(1)
        theta(777) = theta(584)+theta(546)*AB(2) ! ((6,1,0)|(0,1,0)) = ((6,2,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(2)
        theta(778) = theta(585)+theta(546)*AB(3) ! ((6,1,0)|(0,0,1)) = ((6,1,1)|(0,0,0))+((6,1,0)|(0,0,0))*AB(3)
        theta(779) = theta(583)+theta(547)*AB(1) ! ((6,0,1)|(1,0,0)) = ((7,0,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(1)
        theta(780) = theta(585)+theta(547)*AB(2) ! ((6,0,1)|(0,1,0)) = ((6,1,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(2)
        theta(781) = theta(586)+theta(547)*AB(3) ! ((6,0,1)|(0,0,1)) = ((6,0,2)|(0,0,0))+((6,0,1)|(0,0,0))*AB(3)
        theta(782) = theta(584)+theta(548)*AB(1) ! ((5,2,0)|(1,0,0)) = ((6,2,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(1)
        theta(783) = theta(587)+theta(548)*AB(2) ! ((5,2,0)|(0,1,0)) = ((5,3,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(2)
        theta(784) = theta(588)+theta(548)*AB(3) ! ((5,2,0)|(0,0,1)) = ((5,2,1)|(0,0,0))+((5,2,0)|(0,0,0))*AB(3)
        theta(785) = theta(585)+theta(549)*AB(1) ! ((5,1,1)|(1,0,0)) = ((6,1,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(1)
        theta(786) = theta(588)+theta(549)*AB(2) ! ((5,1,1)|(0,1,0)) = ((5,2,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(2)
        theta(787) = theta(589)+theta(549)*AB(3) ! ((5,1,1)|(0,0,1)) = ((5,1,2)|(0,0,0))+((5,1,1)|(0,0,0))*AB(3)
        theta(788) = theta(586)+theta(550)*AB(1) ! ((5,0,2)|(1,0,0)) = ((6,0,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(1)
        theta(789) = theta(589)+theta(550)*AB(2) ! ((5,0,2)|(0,1,0)) = ((5,1,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(2)
        theta(790) = theta(590)+theta(550)*AB(3) ! ((5,0,2)|(0,0,1)) = ((5,0,3)|(0,0,0))+((5,0,2)|(0,0,0))*AB(3)
        theta(791) = theta(587)+theta(551)*AB(1) ! ((4,3,0)|(1,0,0)) = ((5,3,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(1)
        theta(792) = theta(591)+theta(551)*AB(2) ! ((4,3,0)|(0,1,0)) = ((4,4,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(2)
        theta(793) = theta(592)+theta(551)*AB(3) ! ((4,3,0)|(0,0,1)) = ((4,3,1)|(0,0,0))+((4,3,0)|(0,0,0))*AB(3)
        theta(794) = theta(588)+theta(552)*AB(1) ! ((4,2,1)|(1,0,0)) = ((5,2,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(1)
        theta(795) = theta(592)+theta(552)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(796) = theta(593)+theta(552)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(797) = theta(589)+theta(553)*AB(1) ! ((4,1,2)|(1,0,0)) = ((5,1,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(1)
        theta(798) = theta(593)+theta(553)*AB(2) ! ((4,1,2)|(0,1,0)) = ((4,2,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(2)
        theta(799) = theta(594)+theta(553)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(800) = theta(590)+theta(554)*AB(1) ! ((4,0,3)|(1,0,0)) = ((5,0,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(1)
        theta(801) = theta(594)+theta(554)*AB(2) ! ((4,0,3)|(0,1,0)) = ((4,1,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(2)
        theta(802) = theta(595)+theta(554)*AB(3) ! ((4,0,3)|(0,0,1)) = ((4,0,4)|(0,0,0))+((4,0,3)|(0,0,0))*AB(3)
        theta(803) = theta(591)+theta(555)*AB(1) ! ((3,4,0)|(1,0,0)) = ((4,4,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(1)
        theta(804) = theta(596)+theta(555)*AB(2) ! ((3,4,0)|(0,1,0)) = ((3,5,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(2)
        theta(805) = theta(597)+theta(555)*AB(3) ! ((3,4,0)|(0,0,1)) = ((3,4,1)|(0,0,0))+((3,4,0)|(0,0,0))*AB(3)
        theta(806) = theta(592)+theta(556)*AB(1) ! ((3,3,1)|(1,0,0)) = ((4,3,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(1)
        theta(807) = theta(597)+theta(556)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(808) = theta(598)+theta(556)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(809) = theta(593)+theta(557)*AB(1) ! ((3,2,2)|(1,0,0)) = ((4,2,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(1)
        theta(810) = theta(598)+theta(557)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(811) = theta(599)+theta(557)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(812) = theta(594)+theta(558)*AB(1) ! ((3,1,3)|(1,0,0)) = ((4,1,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(1)
        theta(813) = theta(599)+theta(558)*AB(2) ! ((3,1,3)|(0,1,0)) = ((3,2,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(2)
        theta(814) = theta(600)+theta(558)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(815) = theta(595)+theta(559)*AB(1) ! ((3,0,4)|(1,0,0)) = ((4,0,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(1)
        theta(816) = theta(600)+theta(559)*AB(2) ! ((3,0,4)|(0,1,0)) = ((3,1,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(2)
        theta(817) = theta(601)+theta(559)*AB(3) ! ((3,0,4)|(0,0,1)) = ((3,0,5)|(0,0,0))+((3,0,4)|(0,0,0))*AB(3)
        theta(818) = theta(596)+theta(560)*AB(1) ! ((2,5,0)|(1,0,0)) = ((3,5,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(1)
        theta(819) = theta(602)+theta(560)*AB(2) ! ((2,5,0)|(0,1,0)) = ((2,6,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(2)
        theta(820) = theta(603)+theta(560)*AB(3) ! ((2,5,0)|(0,0,1)) = ((2,5,1)|(0,0,0))+((2,5,0)|(0,0,0))*AB(3)
        theta(821) = theta(597)+theta(561)*AB(1) ! ((2,4,1)|(1,0,0)) = ((3,4,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(1)
        theta(822) = theta(603)+theta(561)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(823) = theta(604)+theta(561)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(824) = theta(598)+theta(562)*AB(1) ! ((2,3,2)|(1,0,0)) = ((3,3,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(1)
        theta(825) = theta(604)+theta(562)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(826) = theta(605)+theta(562)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(827) = theta(599)+theta(563)*AB(1) ! ((2,2,3)|(1,0,0)) = ((3,2,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(1)
        theta(828) = theta(605)+theta(563)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(829) = theta(606)+theta(563)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(830) = theta(600)+theta(564)*AB(1) ! ((2,1,4)|(1,0,0)) = ((3,1,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(1)
        theta(831) = theta(606)+theta(564)*AB(2) ! ((2,1,4)|(0,1,0)) = ((2,2,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(2)
        theta(832) = theta(607)+theta(564)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(833) = theta(601)+theta(565)*AB(1) ! ((2,0,5)|(1,0,0)) = ((3,0,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(1)
        theta(834) = theta(607)+theta(565)*AB(2) ! ((2,0,5)|(0,1,0)) = ((2,1,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(2)
        theta(835) = theta(608)+theta(565)*AB(3) ! ((2,0,5)|(0,0,1)) = ((2,0,6)|(0,0,0))+((2,0,5)|(0,0,0))*AB(3)
        theta(836) = theta(602)+theta(566)*AB(1) ! ((1,6,0)|(1,0,0)) = ((2,6,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(1)
        theta(837) = theta(609)+theta(566)*AB(2) ! ((1,6,0)|(0,1,0)) = ((1,7,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(2)
        theta(838) = theta(610)+theta(566)*AB(3) ! ((1,6,0)|(0,0,1)) = ((1,6,1)|(0,0,0))+((1,6,0)|(0,0,0))*AB(3)
        theta(839) = theta(603)+theta(567)*AB(1) ! ((1,5,1)|(1,0,0)) = ((2,5,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(1)
        theta(840) = theta(610)+theta(567)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(841) = theta(611)+theta(567)*AB(3) ! ((1,5,1)|(0,0,1)) = ((1,5,2)|(0,0,0))+((1,5,1)|(0,0,0))*AB(3)
        theta(842) = theta(604)+theta(568)*AB(1) ! ((1,4,2)|(1,0,0)) = ((2,4,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(1)
        theta(843) = theta(611)+theta(568)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(844) = theta(612)+theta(568)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        theta(845) = theta(605)+theta(569)*AB(1) ! ((1,3,3)|(1,0,0)) = ((2,3,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(1)
        theta(846) = theta(612)+theta(569)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(847) = theta(613)+theta(569)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(848) = theta(606)+theta(570)*AB(1) ! ((1,2,4)|(1,0,0)) = ((2,2,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(1)
        theta(849) = theta(613)+theta(570)*AB(2) ! ((1,2,4)|(0,1,0)) = ((1,3,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(2)
        theta(850) = theta(614)+theta(570)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(851) = theta(607)+theta(571)*AB(1) ! ((1,1,5)|(1,0,0)) = ((2,1,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(1)
        theta(852) = theta(614)+theta(571)*AB(2) ! ((1,1,5)|(0,1,0)) = ((1,2,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(2)
        theta(853) = theta(615)+theta(571)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        theta(854) = theta(608)+theta(572)*AB(1) ! ((1,0,6)|(1,0,0)) = ((2,0,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(1)
        ! theta(855) = theta(615)+theta(572)*AB(2) ! ((1,0,6)|(0,1,0)) = ((1,1,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(2)
        theta(856) = theta(616)+theta(572)*AB(3) ! ((1,0,6)|(0,0,1)) = ((1,0,7)|(0,0,0))+((1,0,6)|(0,0,0))*AB(3)
        ! theta(857) = theta(609)+theta(573)*AB(1) ! ((0,7,0)|(1,0,0)) = ((1,7,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(1)
        theta(858) = theta(617)+theta(573)*AB(2) ! ((0,7,0)|(0,1,0)) = ((0,8,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(2)
        ! theta(859) = theta(618)+theta(573)*AB(3) ! ((0,7,0)|(0,0,1)) = ((0,7,1)|(0,0,0))+((0,7,0)|(0,0,0))*AB(3)
        ! theta(860) = theta(610)+theta(574)*AB(1) ! ((0,6,1)|(1,0,0)) = ((1,6,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(1)
        theta(861) = theta(618)+theta(574)*AB(2) ! ((0,6,1)|(0,1,0)) = ((0,7,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(2)
        theta(862) = theta(619)+theta(574)*AB(3) ! ((0,6,1)|(0,0,1)) = ((0,6,2)|(0,0,0))+((0,6,1)|(0,0,0))*AB(3)
        ! theta(863) = theta(611)+theta(575)*AB(1) ! ((0,5,2)|(1,0,0)) = ((1,5,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(1)
        theta(864) = theta(619)+theta(575)*AB(2) ! ((0,5,2)|(0,1,0)) = ((0,6,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(2)
        theta(865) = theta(620)+theta(575)*AB(3) ! ((0,5,2)|(0,0,1)) = ((0,5,3)|(0,0,0))+((0,5,2)|(0,0,0))*AB(3)
        ! theta(866) = theta(612)+theta(576)*AB(1) ! ((0,4,3)|(1,0,0)) = ((1,4,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(1)
        theta(867) = theta(620)+theta(576)*AB(2) ! ((0,4,3)|(0,1,0)) = ((0,5,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(2)
        theta(868) = theta(621)+theta(576)*AB(3) ! ((0,4,3)|(0,0,1)) = ((0,4,4)|(0,0,0))+((0,4,3)|(0,0,0))*AB(3)
        ! theta(869) = theta(613)+theta(577)*AB(1) ! ((0,3,4)|(1,0,0)) = ((1,3,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(1)
        theta(870) = theta(621)+theta(577)*AB(2) ! ((0,3,4)|(0,1,0)) = ((0,4,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(2)
        theta(871) = theta(622)+theta(577)*AB(3) ! ((0,3,4)|(0,0,1)) = ((0,3,5)|(0,0,0))+((0,3,4)|(0,0,0))*AB(3)
        ! theta(872) = theta(614)+theta(578)*AB(1) ! ((0,2,5)|(1,0,0)) = ((1,2,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(1)
        theta(873) = theta(622)+theta(578)*AB(2) ! ((0,2,5)|(0,1,0)) = ((0,3,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(2)
        theta(874) = theta(623)+theta(578)*AB(3) ! ((0,2,5)|(0,0,1)) = ((0,2,6)|(0,0,0))+((0,2,5)|(0,0,0))*AB(3)
        ! theta(875) = theta(615)+theta(579)*AB(1) ! ((0,1,6)|(1,0,0)) = ((1,1,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(1)
        theta(876) = theta(623)+theta(579)*AB(2) ! ((0,1,6)|(0,1,0)) = ((0,2,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(2)
        theta(877) = theta(624)+theta(579)*AB(3) ! ((0,1,6)|(0,0,1)) = ((0,1,7)|(0,0,0))+((0,1,6)|(0,0,0))*AB(3)
        ! theta(878) = theta(616)+theta(580)*AB(1) ! ((0,0,7)|(1,0,0)) = ((1,0,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(1)
        ! theta(879) = theta(624)+theta(580)*AB(2) ! ((0,0,7)|(0,1,0)) = ((0,1,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(2)
        theta(880) = theta(625)+theta(580)*AB(3) ! ((0,0,7)|(0,0,1)) = ((0,0,8)|(0,0,0))+((0,0,7)|(0,0,0))*AB(3)
        theta(881) = theta(689)+theta(626)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        ! theta(882) = theta(690)+theta(627)*AB(1) ! ((5,0,0)|(1,1,0)) = ((6,0,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(1)
        ! theta(883) = theta(691)+theta(628)*AB(1) ! ((5,0,0)|(1,0,1)) = ((6,0,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(1)
        theta(884) = theta(693)+theta(627)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        theta(885) = theta(694)+theta(628)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        theta(886) = theta(697)+theta(628)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(887) = theta(692)+theta(629)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        ! theta(888) = theta(693)+theta(630)*AB(1) ! ((4,1,0)|(1,1,0)) = ((5,1,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(1)
        ! theta(889) = theta(694)+theta(631)*AB(1) ! ((4,1,0)|(1,0,1)) = ((5,1,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(1)
        theta(890) = theta(699)+theta(630)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        theta(891) = theta(700)+theta(631)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        theta(892) = theta(703)+theta(631)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(893) = theta(695)+theta(632)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(894) = theta(696)+theta(633)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        ! theta(895) = theta(697)+theta(634)*AB(1) ! ((4,0,1)|(1,0,1)) = ((5,0,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(1)
        theta(896) = theta(702)+theta(633)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(897) = theta(703)+theta(634)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(898) = theta(706)+theta(634)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(899) = theta(698)+theta(635)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        ! theta(900) = theta(699)+theta(636)*AB(1) ! ((3,2,0)|(1,1,0)) = ((4,2,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(1)
        ! theta(901) = theta(700)+theta(637)*AB(1) ! ((3,2,0)|(1,0,1)) = ((4,2,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(1)
        theta(902) = theta(708)+theta(636)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        theta(903) = theta(709)+theta(637)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        theta(904) = theta(712)+theta(637)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(905) = theta(701)+theta(638)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(906) = theta(702)+theta(639)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        ! theta(907) = theta(703)+theta(640)*AB(1) ! ((3,1,1)|(1,0,1)) = ((4,1,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(1)
        theta(908) = theta(711)+theta(639)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(909) = theta(712)+theta(640)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(910) = theta(715)+theta(640)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(911) = theta(704)+theta(641)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(912) = theta(705)+theta(642)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        ! theta(913) = theta(706)+theta(643)*AB(1) ! ((3,0,2)|(1,0,1)) = ((4,0,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(1)
        theta(914) = theta(714)+theta(642)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(915) = theta(715)+theta(643)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(916) = theta(718)+theta(643)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(917) = theta(707)+theta(644)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        ! theta(918) = theta(708)+theta(645)*AB(1) ! ((2,3,0)|(1,1,0)) = ((3,3,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(1)
        ! theta(919) = theta(709)+theta(646)*AB(1) ! ((2,3,0)|(1,0,1)) = ((3,3,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(1)
        theta(920) = theta(720)+theta(645)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        theta(921) = theta(721)+theta(646)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        theta(922) = theta(724)+theta(646)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(923) = theta(710)+theta(647)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(924) = theta(711)+theta(648)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        ! theta(925) = theta(712)+theta(649)*AB(1) ! ((2,2,1)|(1,0,1)) = ((3,2,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(1)
        theta(926) = theta(723)+theta(648)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(927) = theta(724)+theta(649)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(928) = theta(727)+theta(649)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(929) = theta(713)+theta(650)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(930) = theta(714)+theta(651)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        ! theta(931) = theta(715)+theta(652)*AB(1) ! ((2,1,2)|(1,0,1)) = ((3,1,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(1)
        theta(932) = theta(726)+theta(651)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(933) = theta(727)+theta(652)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(934) = theta(730)+theta(652)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(935) = theta(716)+theta(653)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(936) = theta(717)+theta(654)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        ! theta(937) = theta(718)+theta(655)*AB(1) ! ((2,0,3)|(1,0,1)) = ((3,0,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(1)
        theta(938) = theta(729)+theta(654)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(939) = theta(730)+theta(655)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(940) = theta(733)+theta(655)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(941) = theta(719)+theta(656)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        ! theta(942) = theta(720)+theta(657)*AB(1) ! ((1,4,0)|(1,1,0)) = ((2,4,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(1)
        ! theta(943) = theta(721)+theta(658)*AB(1) ! ((1,4,0)|(1,0,1)) = ((2,4,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(1)
        theta(944) = theta(735)+theta(657)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        theta(945) = theta(736)+theta(658)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        theta(946) = theta(739)+theta(658)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(947) = theta(722)+theta(659)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(948) = theta(723)+theta(660)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        ! theta(949) = theta(724)+theta(661)*AB(1) ! ((1,3,1)|(1,0,1)) = ((2,3,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(1)
        theta(950) = theta(738)+theta(660)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(951) = theta(739)+theta(661)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(952) = theta(742)+theta(661)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(953) = theta(725)+theta(662)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(954) = theta(726)+theta(663)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        ! theta(955) = theta(727)+theta(664)*AB(1) ! ((1,2,2)|(1,0,1)) = ((2,2,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(1)
        theta(956) = theta(741)+theta(663)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(957) = theta(742)+theta(664)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(958) = theta(745)+theta(664)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(959) = theta(728)+theta(665)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(960) = theta(729)+theta(666)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        ! theta(961) = theta(730)+theta(667)*AB(1) ! ((1,1,3)|(1,0,1)) = ((2,1,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(1)
        theta(962) = theta(744)+theta(666)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(963) = theta(745)+theta(667)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(964) = theta(748)+theta(667)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(965) = theta(731)+theta(668)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(966) = theta(732)+theta(669)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        ! theta(967) = theta(733)+theta(670)*AB(1) ! ((1,0,4)|(1,0,1)) = ((2,0,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(1)
        theta(968) = theta(747)+theta(669)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(969) = theta(748)+theta(670)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(970) = theta(751)+theta(670)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(971) = theta(734)+theta(671)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        ! theta(972) = theta(735)+theta(672)*AB(1) ! ((0,5,0)|(1,1,0)) = ((1,5,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(1)
        ! theta(973) = theta(736)+theta(673)*AB(1) ! ((0,5,0)|(1,0,1)) = ((1,5,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(1)
        theta(974) = theta(753)+theta(672)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        theta(975) = theta(754)+theta(673)*AB(2) ! ((0,5,0)|(0,1,1)) = ((0,6,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(2)
        theta(976) = theta(757)+theta(673)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(977) = theta(737)+theta(674)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        theta(978) = theta(738)+theta(675)*AB(1) ! ((0,4,1)|(1,1,0)) = ((1,4,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(1)
        ! theta(979) = theta(739)+theta(676)*AB(1) ! ((0,4,1)|(1,0,1)) = ((1,4,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(1)
        theta(980) = theta(756)+theta(675)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(981) = theta(757)+theta(676)*AB(2) ! ((0,4,1)|(0,1,1)) = ((0,5,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(2)
        theta(982) = theta(760)+theta(676)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(983) = theta(740)+theta(677)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        theta(984) = theta(741)+theta(678)*AB(1) ! ((0,3,2)|(1,1,0)) = ((1,3,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(1)
        ! theta(985) = theta(742)+theta(679)*AB(1) ! ((0,3,2)|(1,0,1)) = ((1,3,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(1)
        theta(986) = theta(759)+theta(678)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(987) = theta(760)+theta(679)*AB(2) ! ((0,3,2)|(0,1,1)) = ((0,4,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(2)
        theta(988) = theta(763)+theta(679)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(989) = theta(743)+theta(680)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        theta(990) = theta(744)+theta(681)*AB(1) ! ((0,2,3)|(1,1,0)) = ((1,2,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(1)
        ! theta(991) = theta(745)+theta(682)*AB(1) ! ((0,2,3)|(1,0,1)) = ((1,2,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(1)
        theta(992) = theta(762)+theta(681)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(993) = theta(763)+theta(682)*AB(2) ! ((0,2,3)|(0,1,1)) = ((0,3,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(2)
        theta(994) = theta(766)+theta(682)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(995) = theta(746)+theta(683)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        theta(996) = theta(747)+theta(684)*AB(1) ! ((0,1,4)|(1,1,0)) = ((1,1,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(1)
        ! theta(997) = theta(748)+theta(685)*AB(1) ! ((0,1,4)|(1,0,1)) = ((1,1,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(1)
        theta(998) = theta(765)+theta(684)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(999) = theta(766)+theta(685)*AB(2) ! ((0,1,4)|(0,1,1)) = ((0,2,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(2)
        theta(1000) = theta(769)+theta(685)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1001) = theta(749)+theta(686)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        theta(1002) = theta(750)+theta(687)*AB(1) ! ((0,0,5)|(1,1,0)) = ((1,0,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(1)
        ! theta(1003) = theta(751)+theta(688)*AB(1) ! ((0,0,5)|(1,0,1)) = ((1,0,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(1)
        theta(1004) = theta(768)+theta(687)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        theta(1005) = theta(769)+theta(688)*AB(2) ! ((0,0,5)|(0,1,1)) = ((0,1,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(2)
        theta(1006) = theta(772)+theta(688)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(1007) = theta(773)+theta(689)*AB(1) ! ((6,0,0)|(2,0,0)) = ((7,0,0)|(1,0,0))+((6,0,0)|(1,0,0))*AB(1)
        ! theta(1008) = theta(774)+theta(690)*AB(1) ! ((6,0,0)|(1,1,0)) = ((7,0,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(1)
        ! theta(1009) = theta(775)+theta(691)*AB(1) ! ((6,0,0)|(1,0,1)) = ((7,0,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(1)
        theta(1010) = theta(777)+theta(690)*AB(2) ! ((6,0,0)|(0,2,0)) = ((6,1,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(2)
        theta(1011) = theta(778)+theta(691)*AB(2) ! ((6,0,0)|(0,1,1)) = ((6,1,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(2)
        theta(1012) = theta(781)+theta(691)*AB(3) ! ((6,0,0)|(0,0,2)) = ((6,0,1)|(0,0,1))+((6,0,0)|(0,0,1))*AB(3)
        theta(1013) = theta(776)+theta(692)*AB(1) ! ((5,1,0)|(2,0,0)) = ((6,1,0)|(1,0,0))+((5,1,0)|(1,0,0))*AB(1)
        ! theta(1014) = theta(777)+theta(693)*AB(1) ! ((5,1,0)|(1,1,0)) = ((6,1,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(1)
        ! theta(1015) = theta(778)+theta(694)*AB(1) ! ((5,1,0)|(1,0,1)) = ((6,1,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(1)
        theta(1016) = theta(783)+theta(693)*AB(2) ! ((5,1,0)|(0,2,0)) = ((5,2,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(2)
        theta(1017) = theta(784)+theta(694)*AB(2) ! ((5,1,0)|(0,1,1)) = ((5,2,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(2)
        theta(1018) = theta(787)+theta(694)*AB(3) ! ((5,1,0)|(0,0,2)) = ((5,1,1)|(0,0,1))+((5,1,0)|(0,0,1))*AB(3)
        theta(1019) = theta(779)+theta(695)*AB(1) ! ((5,0,1)|(2,0,0)) = ((6,0,1)|(1,0,0))+((5,0,1)|(1,0,0))*AB(1)
        theta(1020) = theta(780)+theta(696)*AB(1) ! ((5,0,1)|(1,1,0)) = ((6,0,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(1)
        ! theta(1021) = theta(781)+theta(697)*AB(1) ! ((5,0,1)|(1,0,1)) = ((6,0,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(1)
        theta(1022) = theta(786)+theta(696)*AB(2) ! ((5,0,1)|(0,2,0)) = ((5,1,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(2)
        theta(1023) = theta(787)+theta(697)*AB(2) ! ((5,0,1)|(0,1,1)) = ((5,1,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(2)
        theta(1024) = theta(790)+theta(697)*AB(3) ! ((5,0,1)|(0,0,2)) = ((5,0,2)|(0,0,1))+((5,0,1)|(0,0,1))*AB(3)
        theta(1025) = theta(782)+theta(698)*AB(1) ! ((4,2,0)|(2,0,0)) = ((5,2,0)|(1,0,0))+((4,2,0)|(1,0,0))*AB(1)
        ! theta(1026) = theta(783)+theta(699)*AB(1) ! ((4,2,0)|(1,1,0)) = ((5,2,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(1)
        ! theta(1027) = theta(784)+theta(700)*AB(1) ! ((4,2,0)|(1,0,1)) = ((5,2,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(1)
        theta(1028) = theta(792)+theta(699)*AB(2) ! ((4,2,0)|(0,2,0)) = ((4,3,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(2)
        theta(1029) = theta(793)+theta(700)*AB(2) ! ((4,2,0)|(0,1,1)) = ((4,3,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(2)
        theta(1030) = theta(796)+theta(700)*AB(3) ! ((4,2,0)|(0,0,2)) = ((4,2,1)|(0,0,1))+((4,2,0)|(0,0,1))*AB(3)
        theta(1031) = theta(785)+theta(701)*AB(1) ! ((4,1,1)|(2,0,0)) = ((5,1,1)|(1,0,0))+((4,1,1)|(1,0,0))*AB(1)
        theta(1032) = theta(786)+theta(702)*AB(1) ! ((4,1,1)|(1,1,0)) = ((5,1,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(1)
        ! theta(1033) = theta(787)+theta(703)*AB(1) ! ((4,1,1)|(1,0,1)) = ((5,1,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(1)
        theta(1034) = theta(795)+theta(702)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1035) = theta(796)+theta(703)*AB(2) ! ((4,1,1)|(0,1,1)) = ((4,2,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(2)
        theta(1036) = theta(799)+theta(703)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1037) = theta(788)+theta(704)*AB(1) ! ((4,0,2)|(2,0,0)) = ((5,0,2)|(1,0,0))+((4,0,2)|(1,0,0))*AB(1)
        theta(1038) = theta(789)+theta(705)*AB(1) ! ((4,0,2)|(1,1,0)) = ((5,0,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(1)
        ! theta(1039) = theta(790)+theta(706)*AB(1) ! ((4,0,2)|(1,0,1)) = ((5,0,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(1)
        theta(1040) = theta(798)+theta(705)*AB(2) ! ((4,0,2)|(0,2,0)) = ((4,1,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(2)
        theta(1041) = theta(799)+theta(706)*AB(2) ! ((4,0,2)|(0,1,1)) = ((4,1,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(2)
        theta(1042) = theta(802)+theta(706)*AB(3) ! ((4,0,2)|(0,0,2)) = ((4,0,3)|(0,0,1))+((4,0,2)|(0,0,1))*AB(3)
        theta(1043) = theta(791)+theta(707)*AB(1) ! ((3,3,0)|(2,0,0)) = ((4,3,0)|(1,0,0))+((3,3,0)|(1,0,0))*AB(1)
        ! theta(1044) = theta(792)+theta(708)*AB(1) ! ((3,3,0)|(1,1,0)) = ((4,3,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(1)
        ! theta(1045) = theta(793)+theta(709)*AB(1) ! ((3,3,0)|(1,0,1)) = ((4,3,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(1)
        theta(1046) = theta(804)+theta(708)*AB(2) ! ((3,3,0)|(0,2,0)) = ((3,4,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(2)
        theta(1047) = theta(805)+theta(709)*AB(2) ! ((3,3,0)|(0,1,1)) = ((3,4,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(2)
        theta(1048) = theta(808)+theta(709)*AB(3) ! ((3,3,0)|(0,0,2)) = ((3,3,1)|(0,0,1))+((3,3,0)|(0,0,1))*AB(3)
        theta(1049) = theta(794)+theta(710)*AB(1) ! ((3,2,1)|(2,0,0)) = ((4,2,1)|(1,0,0))+((3,2,1)|(1,0,0))*AB(1)
        theta(1050) = theta(795)+theta(711)*AB(1) ! ((3,2,1)|(1,1,0)) = ((4,2,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(1)
        ! theta(1051) = theta(796)+theta(712)*AB(1) ! ((3,2,1)|(1,0,1)) = ((4,2,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(1)
        theta(1052) = theta(807)+theta(711)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1053) = theta(808)+theta(712)*AB(2) ! ((3,2,1)|(0,1,1)) = ((3,3,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(2)
        theta(1054) = theta(811)+theta(712)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1055) = theta(797)+theta(713)*AB(1) ! ((3,1,2)|(2,0,0)) = ((4,1,2)|(1,0,0))+((3,1,2)|(1,0,0))*AB(1)
        theta(1056) = theta(798)+theta(714)*AB(1) ! ((3,1,2)|(1,1,0)) = ((4,1,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(1)
        ! theta(1057) = theta(799)+theta(715)*AB(1) ! ((3,1,2)|(1,0,1)) = ((4,1,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(1)
        theta(1058) = theta(810)+theta(714)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1059) = theta(811)+theta(715)*AB(2) ! ((3,1,2)|(0,1,1)) = ((3,2,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(2)
        theta(1060) = theta(814)+theta(715)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1061) = theta(800)+theta(716)*AB(1) ! ((3,0,3)|(2,0,0)) = ((4,0,3)|(1,0,0))+((3,0,3)|(1,0,0))*AB(1)
        theta(1062) = theta(801)+theta(717)*AB(1) ! ((3,0,3)|(1,1,0)) = ((4,0,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(1)
        ! theta(1063) = theta(802)+theta(718)*AB(1) ! ((3,0,3)|(1,0,1)) = ((4,0,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(1)
        theta(1064) = theta(813)+theta(717)*AB(2) ! ((3,0,3)|(0,2,0)) = ((3,1,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(2)
        theta(1065) = theta(814)+theta(718)*AB(2) ! ((3,0,3)|(0,1,1)) = ((3,1,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(2)
        theta(1066) = theta(817)+theta(718)*AB(3) ! ((3,0,3)|(0,0,2)) = ((3,0,4)|(0,0,1))+((3,0,3)|(0,0,1))*AB(3)
        theta(1067) = theta(803)+theta(719)*AB(1) ! ((2,4,0)|(2,0,0)) = ((3,4,0)|(1,0,0))+((2,4,0)|(1,0,0))*AB(1)
        ! theta(1068) = theta(804)+theta(720)*AB(1) ! ((2,4,0)|(1,1,0)) = ((3,4,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(1)
        ! theta(1069) = theta(805)+theta(721)*AB(1) ! ((2,4,0)|(1,0,1)) = ((3,4,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(1)
        theta(1070) = theta(819)+theta(720)*AB(2) ! ((2,4,0)|(0,2,0)) = ((2,5,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(2)
        theta(1071) = theta(820)+theta(721)*AB(2) ! ((2,4,0)|(0,1,1)) = ((2,5,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(2)
        theta(1072) = theta(823)+theta(721)*AB(3) ! ((2,4,0)|(0,0,2)) = ((2,4,1)|(0,0,1))+((2,4,0)|(0,0,1))*AB(3)
        theta(1073) = theta(806)+theta(722)*AB(1) ! ((2,3,1)|(2,0,0)) = ((3,3,1)|(1,0,0))+((2,3,1)|(1,0,0))*AB(1)
        theta(1074) = theta(807)+theta(723)*AB(1) ! ((2,3,1)|(1,1,0)) = ((3,3,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(1)
        ! theta(1075) = theta(808)+theta(724)*AB(1) ! ((2,3,1)|(1,0,1)) = ((3,3,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(1)
        theta(1076) = theta(822)+theta(723)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1077) = theta(823)+theta(724)*AB(2) ! ((2,3,1)|(0,1,1)) = ((2,4,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(2)
        theta(1078) = theta(826)+theta(724)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1079) = theta(809)+theta(725)*AB(1) ! ((2,2,2)|(2,0,0)) = ((3,2,2)|(1,0,0))+((2,2,2)|(1,0,0))*AB(1)
        theta(1080) = theta(810)+theta(726)*AB(1) ! ((2,2,2)|(1,1,0)) = ((3,2,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(1)
        ! theta(1081) = theta(811)+theta(727)*AB(1) ! ((2,2,2)|(1,0,1)) = ((3,2,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(1)
        theta(1082) = theta(825)+theta(726)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1083) = theta(826)+theta(727)*AB(2) ! ((2,2,2)|(0,1,1)) = ((2,3,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(2)
        theta(1084) = theta(829)+theta(727)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1085) = theta(812)+theta(728)*AB(1) ! ((2,1,3)|(2,0,0)) = ((3,1,3)|(1,0,0))+((2,1,3)|(1,0,0))*AB(1)
        theta(1086) = theta(813)+theta(729)*AB(1) ! ((2,1,3)|(1,1,0)) = ((3,1,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(1)
        ! theta(1087) = theta(814)+theta(730)*AB(1) ! ((2,1,3)|(1,0,1)) = ((3,1,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(1)
        theta(1088) = theta(828)+theta(729)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(1089) = theta(829)+theta(730)*AB(2) ! ((2,1,3)|(0,1,1)) = ((2,2,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(2)
        theta(1090) = theta(832)+theta(730)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1091) = theta(815)+theta(731)*AB(1) ! ((2,0,4)|(2,0,0)) = ((3,0,4)|(1,0,0))+((2,0,4)|(1,0,0))*AB(1)
        theta(1092) = theta(816)+theta(732)*AB(1) ! ((2,0,4)|(1,1,0)) = ((3,0,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(1)
        ! theta(1093) = theta(817)+theta(733)*AB(1) ! ((2,0,4)|(1,0,1)) = ((3,0,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(1)
        theta(1094) = theta(831)+theta(732)*AB(2) ! ((2,0,4)|(0,2,0)) = ((2,1,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(2)
        theta(1095) = theta(832)+theta(733)*AB(2) ! ((2,0,4)|(0,1,1)) = ((2,1,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(2)
        theta(1096) = theta(835)+theta(733)*AB(3) ! ((2,0,4)|(0,0,2)) = ((2,0,5)|(0,0,1))+((2,0,4)|(0,0,1))*AB(3)
        theta(1097) = theta(818)+theta(734)*AB(1) ! ((1,5,0)|(2,0,0)) = ((2,5,0)|(1,0,0))+((1,5,0)|(1,0,0))*AB(1)
        ! theta(1098) = theta(819)+theta(735)*AB(1) ! ((1,5,0)|(1,1,0)) = ((2,5,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(1)
        ! theta(1099) = theta(820)+theta(736)*AB(1) ! ((1,5,0)|(1,0,1)) = ((2,5,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(1)
        theta(1100) = theta(837)+theta(735)*AB(2) ! ((1,5,0)|(0,2,0)) = ((1,6,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(2)
        theta(1101) = theta(838)+theta(736)*AB(2) ! ((1,5,0)|(0,1,1)) = ((1,6,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(2)
        theta(1102) = theta(841)+theta(736)*AB(3) ! ((1,5,0)|(0,0,2)) = ((1,5,1)|(0,0,1))+((1,5,0)|(0,0,1))*AB(3)
        theta(1103) = theta(821)+theta(737)*AB(1) ! ((1,4,1)|(2,0,0)) = ((2,4,1)|(1,0,0))+((1,4,1)|(1,0,0))*AB(1)
        theta(1104) = theta(822)+theta(738)*AB(1) ! ((1,4,1)|(1,1,0)) = ((2,4,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(1)
        ! theta(1105) = theta(823)+theta(739)*AB(1) ! ((1,4,1)|(1,0,1)) = ((2,4,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(1)
        theta(1106) = theta(840)+theta(738)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        theta(1107) = theta(841)+theta(739)*AB(2) ! ((1,4,1)|(0,1,1)) = ((1,5,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(2)
        theta(1108) = theta(844)+theta(739)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(1109) = theta(824)+theta(740)*AB(1) ! ((1,3,2)|(2,0,0)) = ((2,3,2)|(1,0,0))+((1,3,2)|(1,0,0))*AB(1)
        theta(1110) = theta(825)+theta(741)*AB(1) ! ((1,3,2)|(1,1,0)) = ((2,3,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(1)
        ! theta(1111) = theta(826)+theta(742)*AB(1) ! ((1,3,2)|(1,0,1)) = ((2,3,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(1)
        theta(1112) = theta(843)+theta(741)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        theta(1113) = theta(844)+theta(742)*AB(2) ! ((1,3,2)|(0,1,1)) = ((1,4,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(2)
        theta(1114) = theta(847)+theta(742)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1115) = theta(827)+theta(743)*AB(1) ! ((1,2,3)|(2,0,0)) = ((2,2,3)|(1,0,0))+((1,2,3)|(1,0,0))*AB(1)
        theta(1116) = theta(828)+theta(744)*AB(1) ! ((1,2,3)|(1,1,0)) = ((2,2,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(1)
        ! theta(1117) = theta(829)+theta(745)*AB(1) ! ((1,2,3)|(1,0,1)) = ((2,2,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(1)
        theta(1118) = theta(846)+theta(744)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        theta(1119) = theta(847)+theta(745)*AB(2) ! ((1,2,3)|(0,1,1)) = ((1,3,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(2)
        theta(1120) = theta(850)+theta(745)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1121) = theta(830)+theta(746)*AB(1) ! ((1,1,4)|(2,0,0)) = ((2,1,4)|(1,0,0))+((1,1,4)|(1,0,0))*AB(1)
        theta(1122) = theta(831)+theta(747)*AB(1) ! ((1,1,4)|(1,1,0)) = ((2,1,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(1)
        ! theta(1123) = theta(832)+theta(748)*AB(1) ! ((1,1,4)|(1,0,1)) = ((2,1,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(1)
        theta(1124) = theta(849)+theta(747)*AB(2) ! ((1,1,4)|(0,2,0)) = ((1,2,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(2)
        theta(1125) = theta(850)+theta(748)*AB(2) ! ((1,1,4)|(0,1,1)) = ((1,2,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(2)
        theta(1126) = theta(853)+theta(748)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(1127) = theta(833)+theta(749)*AB(1) ! ((1,0,5)|(2,0,0)) = ((2,0,5)|(1,0,0))+((1,0,5)|(1,0,0))*AB(1)
        theta(1128) = theta(834)+theta(750)*AB(1) ! ((1,0,5)|(1,1,0)) = ((2,0,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(1)
        ! theta(1129) = theta(835)+theta(751)*AB(1) ! ((1,0,5)|(1,0,1)) = ((2,0,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(1)
        theta(1130) = theta(852)+theta(750)*AB(2) ! ((1,0,5)|(0,2,0)) = ((1,1,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(2)
        theta(1131) = theta(853)+theta(751)*AB(2) ! ((1,0,5)|(0,1,1)) = ((1,1,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(2)
        theta(1132) = theta(856)+theta(751)*AB(3) ! ((1,0,5)|(0,0,2)) = ((1,0,6)|(0,0,1))+((1,0,5)|(0,0,1))*AB(3)
        theta(1133) = theta(836)+theta(752)*AB(1) ! ((0,6,0)|(2,0,0)) = ((1,6,0)|(1,0,0))+((0,6,0)|(1,0,0))*AB(1)
        ! theta(1134) = theta(837)+theta(753)*AB(1) ! ((0,6,0)|(1,1,0)) = ((1,6,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(1)
        ! theta(1135) = theta(838)+theta(754)*AB(1) ! ((0,6,0)|(1,0,1)) = ((1,6,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(1)
        theta(1136) = theta(858)+theta(753)*AB(2) ! ((0,6,0)|(0,2,0)) = ((0,7,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(2)
        ! theta(1137) = theta(859)+theta(754)*AB(2) ! ((0,6,0)|(0,1,1)) = ((0,7,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(2)
        theta(1138) = theta(862)+theta(754)*AB(3) ! ((0,6,0)|(0,0,2)) = ((0,6,1)|(0,0,1))+((0,6,0)|(0,0,1))*AB(3)
        theta(1139) = theta(839)+theta(755)*AB(1) ! ((0,5,1)|(2,0,0)) = ((1,5,1)|(1,0,0))+((0,5,1)|(1,0,0))*AB(1)
        ! theta(1140) = theta(840)+theta(756)*AB(1) ! ((0,5,1)|(1,1,0)) = ((1,5,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(1)
        ! theta(1141) = theta(841)+theta(757)*AB(1) ! ((0,5,1)|(1,0,1)) = ((1,5,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(1)
        theta(1142) = theta(861)+theta(756)*AB(2) ! ((0,5,1)|(0,2,0)) = ((0,6,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(2)
        ! theta(1143) = theta(862)+theta(757)*AB(2) ! ((0,5,1)|(0,1,1)) = ((0,6,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(2)
        theta(1144) = theta(865)+theta(757)*AB(3) ! ((0,5,1)|(0,0,2)) = ((0,5,2)|(0,0,1))+((0,5,1)|(0,0,1))*AB(3)
        theta(1145) = theta(842)+theta(758)*AB(1) ! ((0,4,2)|(2,0,0)) = ((1,4,2)|(1,0,0))+((0,4,2)|(1,0,0))*AB(1)
        ! theta(1146) = theta(843)+theta(759)*AB(1) ! ((0,4,2)|(1,1,0)) = ((1,4,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(1)
        ! theta(1147) = theta(844)+theta(760)*AB(1) ! ((0,4,2)|(1,0,1)) = ((1,4,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(1)
        theta(1148) = theta(864)+theta(759)*AB(2) ! ((0,4,2)|(0,2,0)) = ((0,5,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(2)
        ! theta(1149) = theta(865)+theta(760)*AB(2) ! ((0,4,2)|(0,1,1)) = ((0,5,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(2)
        theta(1150) = theta(868)+theta(760)*AB(3) ! ((0,4,2)|(0,0,2)) = ((0,4,3)|(0,0,1))+((0,4,2)|(0,0,1))*AB(3)
        theta(1151) = theta(845)+theta(761)*AB(1) ! ((0,3,3)|(2,0,0)) = ((1,3,3)|(1,0,0))+((0,3,3)|(1,0,0))*AB(1)
        ! theta(1152) = theta(846)+theta(762)*AB(1) ! ((0,3,3)|(1,1,0)) = ((1,3,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(1)
        ! theta(1153) = theta(847)+theta(763)*AB(1) ! ((0,3,3)|(1,0,1)) = ((1,3,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(1)
        theta(1154) = theta(867)+theta(762)*AB(2) ! ((0,3,3)|(0,2,0)) = ((0,4,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(2)
        ! theta(1155) = theta(868)+theta(763)*AB(2) ! ((0,3,3)|(0,1,1)) = ((0,4,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(2)
        theta(1156) = theta(871)+theta(763)*AB(3) ! ((0,3,3)|(0,0,2)) = ((0,3,4)|(0,0,1))+((0,3,3)|(0,0,1))*AB(3)
        theta(1157) = theta(848)+theta(764)*AB(1) ! ((0,2,4)|(2,0,0)) = ((1,2,4)|(1,0,0))+((0,2,4)|(1,0,0))*AB(1)
        ! theta(1158) = theta(849)+theta(765)*AB(1) ! ((0,2,4)|(1,1,0)) = ((1,2,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(1)
        ! theta(1159) = theta(850)+theta(766)*AB(1) ! ((0,2,4)|(1,0,1)) = ((1,2,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(1)
        theta(1160) = theta(870)+theta(765)*AB(2) ! ((0,2,4)|(0,2,0)) = ((0,3,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(2)
        ! theta(1161) = theta(871)+theta(766)*AB(2) ! ((0,2,4)|(0,1,1)) = ((0,3,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(2)
        theta(1162) = theta(874)+theta(766)*AB(3) ! ((0,2,4)|(0,0,2)) = ((0,2,5)|(0,0,1))+((0,2,4)|(0,0,1))*AB(3)
        theta(1163) = theta(851)+theta(767)*AB(1) ! ((0,1,5)|(2,0,0)) = ((1,1,5)|(1,0,0))+((0,1,5)|(1,0,0))*AB(1)
        ! theta(1164) = theta(852)+theta(768)*AB(1) ! ((0,1,5)|(1,1,0)) = ((1,1,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(1)
        ! theta(1165) = theta(853)+theta(769)*AB(1) ! ((0,1,5)|(1,0,1)) = ((1,1,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(1)
        theta(1166) = theta(873)+theta(768)*AB(2) ! ((0,1,5)|(0,2,0)) = ((0,2,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(2)
        ! theta(1167) = theta(874)+theta(769)*AB(2) ! ((0,1,5)|(0,1,1)) = ((0,2,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(2)
        theta(1168) = theta(877)+theta(769)*AB(3) ! ((0,1,5)|(0,0,2)) = ((0,1,6)|(0,0,1))+((0,1,5)|(0,0,1))*AB(3)
        theta(1169) = theta(854)+theta(770)*AB(1) ! ((0,0,6)|(2,0,0)) = ((1,0,6)|(1,0,0))+((0,0,6)|(1,0,0))*AB(1)
        ! theta(1170) = theta(855)+theta(771)*AB(1) ! ((0,0,6)|(1,1,0)) = ((1,0,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(1)
        ! theta(1171) = theta(856)+theta(772)*AB(1) ! ((0,0,6)|(1,0,1)) = ((1,0,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(1)
        theta(1172) = theta(876)+theta(771)*AB(2) ! ((0,0,6)|(0,2,0)) = ((0,1,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(2)
        ! theta(1173) = theta(877)+theta(772)*AB(2) ! ((0,0,6)|(0,1,1)) = ((0,1,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(2)
        theta(1174) = theta(880)+theta(772)*AB(3) ! ((0,0,6)|(0,0,2)) = ((0,0,7)|(0,0,1))+((0,0,6)|(0,0,1))*AB(3)
        theta(1175) = theta(1007)+theta(881)*AB(1) ! ((5,0,0)|(3,0,0)) = ((6,0,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(1)
        theta(1176) = theta(1013)+theta(881)*AB(2) ! ((5,0,0)|(2,1,0)) = ((5,1,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(2)
        theta(1177) = theta(1019)+theta(881)*AB(3) ! ((5,0,0)|(2,0,1)) = ((5,0,1)|(2,0,0))+((5,0,0)|(2,0,0))*AB(3)
        theta(1178) = theta(1010)+theta(884)*AB(1) ! ((5,0,0)|(1,2,0)) = ((6,0,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(1)
        theta(1179) = theta(1011)+theta(885)*AB(1) ! ((5,0,0)|(1,1,1)) = ((6,0,0)|(0,1,1))+((5,0,0)|(0,1,1))*AB(1)
        theta(1180) = theta(1012)+theta(886)*AB(1) ! ((5,0,0)|(1,0,2)) = ((6,0,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(1)
        theta(1181) = theta(1016)+theta(884)*AB(2) ! ((5,0,0)|(0,3,0)) = ((5,1,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(2)
        theta(1182) = theta(1022)+theta(884)*AB(3) ! ((5,0,0)|(0,2,1)) = ((5,0,1)|(0,2,0))+((5,0,0)|(0,2,0))*AB(3)
        theta(1183) = theta(1018)+theta(886)*AB(2) ! ((5,0,0)|(0,1,2)) = ((5,1,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(2)
        theta(1184) = theta(1024)+theta(886)*AB(3) ! ((5,0,0)|(0,0,3)) = ((5,0,1)|(0,0,2))+((5,0,0)|(0,0,2))*AB(3)
        theta(1185) = theta(1013)+theta(887)*AB(1) ! ((4,1,0)|(3,0,0)) = ((5,1,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(1)
        theta(1186) = theta(1025)+theta(887)*AB(2) ! ((4,1,0)|(2,1,0)) = ((4,2,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(2)
        theta(1187) = theta(1031)+theta(887)*AB(3) ! ((4,1,0)|(2,0,1)) = ((4,1,1)|(2,0,0))+((4,1,0)|(2,0,0))*AB(3)
        theta(1188) = theta(1016)+theta(890)*AB(1) ! ((4,1,0)|(1,2,0)) = ((5,1,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(1)
        theta(1189) = theta(1017)+theta(891)*AB(1) ! ((4,1,0)|(1,1,1)) = ((5,1,0)|(0,1,1))+((4,1,0)|(0,1,1))*AB(1)
        theta(1190) = theta(1018)+theta(892)*AB(1) ! ((4,1,0)|(1,0,2)) = ((5,1,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(1)
        theta(1191) = theta(1028)+theta(890)*AB(2) ! ((4,1,0)|(0,3,0)) = ((4,2,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(2)
        theta(1192) = theta(1034)+theta(890)*AB(3) ! ((4,1,0)|(0,2,1)) = ((4,1,1)|(0,2,0))+((4,1,0)|(0,2,0))*AB(3)
        theta(1193) = theta(1030)+theta(892)*AB(2) ! ((4,1,0)|(0,1,2)) = ((4,2,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(2)
        theta(1194) = theta(1036)+theta(892)*AB(3) ! ((4,1,0)|(0,0,3)) = ((4,1,1)|(0,0,2))+((4,1,0)|(0,0,2))*AB(3)
        theta(1195) = theta(1019)+theta(893)*AB(1) ! ((4,0,1)|(3,0,0)) = ((5,0,1)|(2,0,0))+((4,0,1)|(2,0,0))*AB(1)
        theta(1196) = theta(1020)+theta(894)*AB(1) ! ((4,0,1)|(2,1,0)) = ((5,0,1)|(1,1,0))+((4,0,1)|(1,1,0))*AB(1)
        theta(1197) = theta(1037)+theta(893)*AB(3) ! ((4,0,1)|(2,0,1)) = ((4,0,2)|(2,0,0))+((4,0,1)|(2,0,0))*AB(3)
        theta(1198) = theta(1022)+theta(896)*AB(1) ! ((4,0,1)|(1,2,0)) = ((5,0,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(1)
        theta(1199) = theta(1023)+theta(897)*AB(1) ! ((4,0,1)|(1,1,1)) = ((5,0,1)|(0,1,1))+((4,0,1)|(0,1,1))*AB(1)
        theta(1200) = theta(1024)+theta(898)*AB(1) ! ((4,0,1)|(1,0,2)) = ((5,0,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(1)
        theta(1201) = theta(1034)+theta(896)*AB(2) ! ((4,0,1)|(0,3,0)) = ((4,1,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(2)
        theta(1202) = theta(1040)+theta(896)*AB(3) ! ((4,0,1)|(0,2,1)) = ((4,0,2)|(0,2,0))+((4,0,1)|(0,2,0))*AB(3)
        theta(1203) = theta(1036)+theta(898)*AB(2) ! ((4,0,1)|(0,1,2)) = ((4,1,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(2)
        theta(1204) = theta(1042)+theta(898)*AB(3) ! ((4,0,1)|(0,0,3)) = ((4,0,2)|(0,0,2))+((4,0,1)|(0,0,2))*AB(3)
        theta(1205) = theta(1025)+theta(899)*AB(1) ! ((3,2,0)|(3,0,0)) = ((4,2,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(1)
        theta(1206) = theta(1043)+theta(899)*AB(2) ! ((3,2,0)|(2,1,0)) = ((3,3,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(2)
        theta(1207) = theta(1049)+theta(899)*AB(3) ! ((3,2,0)|(2,0,1)) = ((3,2,1)|(2,0,0))+((3,2,0)|(2,0,0))*AB(3)
        theta(1208) = theta(1028)+theta(902)*AB(1) ! ((3,2,0)|(1,2,0)) = ((4,2,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(1)
        theta(1209) = theta(1029)+theta(903)*AB(1) ! ((3,2,0)|(1,1,1)) = ((4,2,0)|(0,1,1))+((3,2,0)|(0,1,1))*AB(1)
        theta(1210) = theta(1030)+theta(904)*AB(1) ! ((3,2,0)|(1,0,2)) = ((4,2,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(1)
        theta(1211) = theta(1046)+theta(902)*AB(2) ! ((3,2,0)|(0,3,0)) = ((3,3,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(2)
        theta(1212) = theta(1052)+theta(902)*AB(3) ! ((3,2,0)|(0,2,1)) = ((3,2,1)|(0,2,0))+((3,2,0)|(0,2,0))*AB(3)
        theta(1213) = theta(1048)+theta(904)*AB(2) ! ((3,2,0)|(0,1,2)) = ((3,3,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(2)
        theta(1214) = theta(1054)+theta(904)*AB(3) ! ((3,2,0)|(0,0,3)) = ((3,2,1)|(0,0,2))+((3,2,0)|(0,0,2))*AB(3)
        theta(1215) = theta(1031)+theta(905)*AB(1) ! ((3,1,1)|(3,0,0)) = ((4,1,1)|(2,0,0))+((3,1,1)|(2,0,0))*AB(1)
        theta(1216) = theta(1032)+theta(906)*AB(1) ! ((3,1,1)|(2,1,0)) = ((4,1,1)|(1,1,0))+((3,1,1)|(1,1,0))*AB(1)
        theta(1217) = theta(1055)+theta(905)*AB(3) ! ((3,1,1)|(2,0,1)) = ((3,1,2)|(2,0,0))+((3,1,1)|(2,0,0))*AB(3)
        theta(1218) = theta(1034)+theta(908)*AB(1) ! ((3,1,1)|(1,2,0)) = ((4,1,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(1)
        theta(1219) = theta(1035)+theta(909)*AB(1) ! ((3,1,1)|(1,1,1)) = ((4,1,1)|(0,1,1))+((3,1,1)|(0,1,1))*AB(1)
        theta(1220) = theta(1036)+theta(910)*AB(1) ! ((3,1,1)|(1,0,2)) = ((4,1,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(1)
        theta(1221) = theta(1052)+theta(908)*AB(2) ! ((3,1,1)|(0,3,0)) = ((3,2,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(2)
        theta(1222) = theta(1058)+theta(908)*AB(3) ! ((3,1,1)|(0,2,1)) = ((3,1,2)|(0,2,0))+((3,1,1)|(0,2,0))*AB(3)
        theta(1223) = theta(1054)+theta(910)*AB(2) ! ((3,1,1)|(0,1,2)) = ((3,2,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(2)
        theta(1224) = theta(1060)+theta(910)*AB(3) ! ((3,1,1)|(0,0,3)) = ((3,1,2)|(0,0,2))+((3,1,1)|(0,0,2))*AB(3)
        theta(1225) = theta(1037)+theta(911)*AB(1) ! ((3,0,2)|(3,0,0)) = ((4,0,2)|(2,0,0))+((3,0,2)|(2,0,0))*AB(1)
        theta(1226) = theta(1038)+theta(912)*AB(1) ! ((3,0,2)|(2,1,0)) = ((4,0,2)|(1,1,0))+((3,0,2)|(1,1,0))*AB(1)
        theta(1227) = theta(1061)+theta(911)*AB(3) ! ((3,0,2)|(2,0,1)) = ((3,0,3)|(2,0,0))+((3,0,2)|(2,0,0))*AB(3)
        theta(1228) = theta(1040)+theta(914)*AB(1) ! ((3,0,2)|(1,2,0)) = ((4,0,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(1)
        theta(1229) = theta(1041)+theta(915)*AB(1) ! ((3,0,2)|(1,1,1)) = ((4,0,2)|(0,1,1))+((3,0,2)|(0,1,1))*AB(1)
        theta(1230) = theta(1042)+theta(916)*AB(1) ! ((3,0,2)|(1,0,2)) = ((4,0,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(1)
        theta(1231) = theta(1058)+theta(914)*AB(2) ! ((3,0,2)|(0,3,0)) = ((3,1,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(2)
        theta(1232) = theta(1064)+theta(914)*AB(3) ! ((3,0,2)|(0,2,1)) = ((3,0,3)|(0,2,0))+((3,0,2)|(0,2,0))*AB(3)
        theta(1233) = theta(1060)+theta(916)*AB(2) ! ((3,0,2)|(0,1,2)) = ((3,1,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(2)
        theta(1234) = theta(1066)+theta(916)*AB(3) ! ((3,0,2)|(0,0,3)) = ((3,0,3)|(0,0,2))+((3,0,2)|(0,0,2))*AB(3)
        theta(1235) = theta(1043)+theta(917)*AB(1) ! ((2,3,0)|(3,0,0)) = ((3,3,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(1)
        theta(1236) = theta(1067)+theta(917)*AB(2) ! ((2,3,0)|(2,1,0)) = ((2,4,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(2)
        theta(1237) = theta(1073)+theta(917)*AB(3) ! ((2,3,0)|(2,0,1)) = ((2,3,1)|(2,0,0))+((2,3,0)|(2,0,0))*AB(3)
        theta(1238) = theta(1046)+theta(920)*AB(1) ! ((2,3,0)|(1,2,0)) = ((3,3,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(1)
        theta(1239) = theta(1047)+theta(921)*AB(1) ! ((2,3,0)|(1,1,1)) = ((3,3,0)|(0,1,1))+((2,3,0)|(0,1,1))*AB(1)
        theta(1240) = theta(1048)+theta(922)*AB(1) ! ((2,3,0)|(1,0,2)) = ((3,3,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(1)
        theta(1241) = theta(1070)+theta(920)*AB(2) ! ((2,3,0)|(0,3,0)) = ((2,4,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(2)
        theta(1242) = theta(1076)+theta(920)*AB(3) ! ((2,3,0)|(0,2,1)) = ((2,3,1)|(0,2,0))+((2,3,0)|(0,2,0))*AB(3)
        theta(1243) = theta(1072)+theta(922)*AB(2) ! ((2,3,0)|(0,1,2)) = ((2,4,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(2)
        theta(1244) = theta(1078)+theta(922)*AB(3) ! ((2,3,0)|(0,0,3)) = ((2,3,1)|(0,0,2))+((2,3,0)|(0,0,2))*AB(3)
        theta(1245) = theta(1049)+theta(923)*AB(1) ! ((2,2,1)|(3,0,0)) = ((3,2,1)|(2,0,0))+((2,2,1)|(2,0,0))*AB(1)
        theta(1246) = theta(1050)+theta(924)*AB(1) ! ((2,2,1)|(2,1,0)) = ((3,2,1)|(1,1,0))+((2,2,1)|(1,1,0))*AB(1)
        theta(1247) = theta(1079)+theta(923)*AB(3) ! ((2,2,1)|(2,0,1)) = ((2,2,2)|(2,0,0))+((2,2,1)|(2,0,0))*AB(3)
        theta(1248) = theta(1052)+theta(926)*AB(1) ! ((2,2,1)|(1,2,0)) = ((3,2,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(1)
        theta(1249) = theta(1053)+theta(927)*AB(1) ! ((2,2,1)|(1,1,1)) = ((3,2,1)|(0,1,1))+((2,2,1)|(0,1,1))*AB(1)
        theta(1250) = theta(1054)+theta(928)*AB(1) ! ((2,2,1)|(1,0,2)) = ((3,2,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(1)
        theta(1251) = theta(1076)+theta(926)*AB(2) ! ((2,2,1)|(0,3,0)) = ((2,3,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(2)
        theta(1252) = theta(1082)+theta(926)*AB(3) ! ((2,2,1)|(0,2,1)) = ((2,2,2)|(0,2,0))+((2,2,1)|(0,2,0))*AB(3)
        theta(1253) = theta(1078)+theta(928)*AB(2) ! ((2,2,1)|(0,1,2)) = ((2,3,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(2)
        theta(1254) = theta(1084)+theta(928)*AB(3) ! ((2,2,1)|(0,0,3)) = ((2,2,2)|(0,0,2))+((2,2,1)|(0,0,2))*AB(3)
        theta(1255) = theta(1055)+theta(929)*AB(1) ! ((2,1,2)|(3,0,0)) = ((3,1,2)|(2,0,0))+((2,1,2)|(2,0,0))*AB(1)
        theta(1256) = theta(1056)+theta(930)*AB(1) ! ((2,1,2)|(2,1,0)) = ((3,1,2)|(1,1,0))+((2,1,2)|(1,1,0))*AB(1)
        theta(1257) = theta(1085)+theta(929)*AB(3) ! ((2,1,2)|(2,0,1)) = ((2,1,3)|(2,0,0))+((2,1,2)|(2,0,0))*AB(3)
        theta(1258) = theta(1058)+theta(932)*AB(1) ! ((2,1,2)|(1,2,0)) = ((3,1,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(1)
        theta(1259) = theta(1059)+theta(933)*AB(1) ! ((2,1,2)|(1,1,1)) = ((3,1,2)|(0,1,1))+((2,1,2)|(0,1,1))*AB(1)
        theta(1260) = theta(1060)+theta(934)*AB(1) ! ((2,1,2)|(1,0,2)) = ((3,1,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(1)
        theta(1261) = theta(1082)+theta(932)*AB(2) ! ((2,1,2)|(0,3,0)) = ((2,2,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(2)
        theta(1262) = theta(1088)+theta(932)*AB(3) ! ((2,1,2)|(0,2,1)) = ((2,1,3)|(0,2,0))+((2,1,2)|(0,2,0))*AB(3)
        theta(1263) = theta(1084)+theta(934)*AB(2) ! ((2,1,2)|(0,1,2)) = ((2,2,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(2)
        theta(1264) = theta(1090)+theta(934)*AB(3) ! ((2,1,2)|(0,0,3)) = ((2,1,3)|(0,0,2))+((2,1,2)|(0,0,2))*AB(3)
        theta(1265) = theta(1061)+theta(935)*AB(1) ! ((2,0,3)|(3,0,0)) = ((3,0,3)|(2,0,0))+((2,0,3)|(2,0,0))*AB(1)
        theta(1266) = theta(1062)+theta(936)*AB(1) ! ((2,0,3)|(2,1,0)) = ((3,0,3)|(1,1,0))+((2,0,3)|(1,1,0))*AB(1)
        theta(1267) = theta(1091)+theta(935)*AB(3) ! ((2,0,3)|(2,0,1)) = ((2,0,4)|(2,0,0))+((2,0,3)|(2,0,0))*AB(3)
        theta(1268) = theta(1064)+theta(938)*AB(1) ! ((2,0,3)|(1,2,0)) = ((3,0,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(1)
        theta(1269) = theta(1065)+theta(939)*AB(1) ! ((2,0,3)|(1,1,1)) = ((3,0,3)|(0,1,1))+((2,0,3)|(0,1,1))*AB(1)
        theta(1270) = theta(1066)+theta(940)*AB(1) ! ((2,0,3)|(1,0,2)) = ((3,0,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(1)
        theta(1271) = theta(1088)+theta(938)*AB(2) ! ((2,0,3)|(0,3,0)) = ((2,1,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(2)
        theta(1272) = theta(1094)+theta(938)*AB(3) ! ((2,0,3)|(0,2,1)) = ((2,0,4)|(0,2,0))+((2,0,3)|(0,2,0))*AB(3)
        theta(1273) = theta(1090)+theta(940)*AB(2) ! ((2,0,3)|(0,1,2)) = ((2,1,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(2)
        theta(1274) = theta(1096)+theta(940)*AB(3) ! ((2,0,3)|(0,0,3)) = ((2,0,4)|(0,0,2))+((2,0,3)|(0,0,2))*AB(3)
        theta(1275) = theta(1067)+theta(941)*AB(1) ! ((1,4,0)|(3,0,0)) = ((2,4,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(1)
        theta(1276) = theta(1097)+theta(941)*AB(2) ! ((1,4,0)|(2,1,0)) = ((1,5,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(2)
        theta(1277) = theta(1103)+theta(941)*AB(3) ! ((1,4,0)|(2,0,1)) = ((1,4,1)|(2,0,0))+((1,4,0)|(2,0,0))*AB(3)
        theta(1278) = theta(1070)+theta(944)*AB(1) ! ((1,4,0)|(1,2,0)) = ((2,4,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(1)
        theta(1279) = theta(1071)+theta(945)*AB(1) ! ((1,4,0)|(1,1,1)) = ((2,4,0)|(0,1,1))+((1,4,0)|(0,1,1))*AB(1)
        theta(1280) = theta(1072)+theta(946)*AB(1) ! ((1,4,0)|(1,0,2)) = ((2,4,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(1)
        theta(1281) = theta(1100)+theta(944)*AB(2) ! ((1,4,0)|(0,3,0)) = ((1,5,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(2)
        theta(1282) = theta(1106)+theta(944)*AB(3) ! ((1,4,0)|(0,2,1)) = ((1,4,1)|(0,2,0))+((1,4,0)|(0,2,0))*AB(3)
        theta(1283) = theta(1102)+theta(946)*AB(2) ! ((1,4,0)|(0,1,2)) = ((1,5,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(2)
        theta(1284) = theta(1108)+theta(946)*AB(3) ! ((1,4,0)|(0,0,3)) = ((1,4,1)|(0,0,2))+((1,4,0)|(0,0,2))*AB(3)
        theta(1285) = theta(1073)+theta(947)*AB(1) ! ((1,3,1)|(3,0,0)) = ((2,3,1)|(2,0,0))+((1,3,1)|(2,0,0))*AB(1)
        theta(1286) = theta(1074)+theta(948)*AB(1) ! ((1,3,1)|(2,1,0)) = ((2,3,1)|(1,1,0))+((1,3,1)|(1,1,0))*AB(1)
        theta(1287) = theta(1109)+theta(947)*AB(3) ! ((1,3,1)|(2,0,1)) = ((1,3,2)|(2,0,0))+((1,3,1)|(2,0,0))*AB(3)
        theta(1288) = theta(1076)+theta(950)*AB(1) ! ((1,3,1)|(1,2,0)) = ((2,3,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(1)
        theta(1289) = theta(1077)+theta(951)*AB(1) ! ((1,3,1)|(1,1,1)) = ((2,3,1)|(0,1,1))+((1,3,1)|(0,1,1))*AB(1)
        theta(1290) = theta(1078)+theta(952)*AB(1) ! ((1,3,1)|(1,0,2)) = ((2,3,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(1)
        theta(1291) = theta(1106)+theta(950)*AB(2) ! ((1,3,1)|(0,3,0)) = ((1,4,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(2)
        theta(1292) = theta(1112)+theta(950)*AB(3) ! ((1,3,1)|(0,2,1)) = ((1,3,2)|(0,2,0))+((1,3,1)|(0,2,0))*AB(3)
        theta(1293) = theta(1108)+theta(952)*AB(2) ! ((1,3,1)|(0,1,2)) = ((1,4,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(2)
        theta(1294) = theta(1114)+theta(952)*AB(3) ! ((1,3,1)|(0,0,3)) = ((1,3,2)|(0,0,2))+((1,3,1)|(0,0,2))*AB(3)
        theta(1295) = theta(1079)+theta(953)*AB(1) ! ((1,2,2)|(3,0,0)) = ((2,2,2)|(2,0,0))+((1,2,2)|(2,0,0))*AB(1)
        theta(1296) = theta(1080)+theta(954)*AB(1) ! ((1,2,2)|(2,1,0)) = ((2,2,2)|(1,1,0))+((1,2,2)|(1,1,0))*AB(1)
        theta(1297) = theta(1115)+theta(953)*AB(3) ! ((1,2,2)|(2,0,1)) = ((1,2,3)|(2,0,0))+((1,2,2)|(2,0,0))*AB(3)
        theta(1298) = theta(1082)+theta(956)*AB(1) ! ((1,2,2)|(1,2,0)) = ((2,2,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(1)
        theta(1299) = theta(1083)+theta(957)*AB(1) ! ((1,2,2)|(1,1,1)) = ((2,2,2)|(0,1,1))+((1,2,2)|(0,1,1))*AB(1)
        theta(1300) = theta(1084)+theta(958)*AB(1) ! ((1,2,2)|(1,0,2)) = ((2,2,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(1)
        theta(1301) = theta(1112)+theta(956)*AB(2) ! ((1,2,2)|(0,3,0)) = ((1,3,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(2)
        theta(1302) = theta(1118)+theta(956)*AB(3) ! ((1,2,2)|(0,2,1)) = ((1,2,3)|(0,2,0))+((1,2,2)|(0,2,0))*AB(3)
        theta(1303) = theta(1114)+theta(958)*AB(2) ! ((1,2,2)|(0,1,2)) = ((1,3,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(2)
        theta(1304) = theta(1120)+theta(958)*AB(3) ! ((1,2,2)|(0,0,3)) = ((1,2,3)|(0,0,2))+((1,2,2)|(0,0,2))*AB(3)
        theta(1305) = theta(1085)+theta(959)*AB(1) ! ((1,1,3)|(3,0,0)) = ((2,1,3)|(2,0,0))+((1,1,3)|(2,0,0))*AB(1)
        theta(1306) = theta(1086)+theta(960)*AB(1) ! ((1,1,3)|(2,1,0)) = ((2,1,3)|(1,1,0))+((1,1,3)|(1,1,0))*AB(1)
        theta(1307) = theta(1121)+theta(959)*AB(3) ! ((1,1,3)|(2,0,1)) = ((1,1,4)|(2,0,0))+((1,1,3)|(2,0,0))*AB(3)
        theta(1308) = theta(1088)+theta(962)*AB(1) ! ((1,1,3)|(1,2,0)) = ((2,1,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(1)
        theta(1309) = theta(1089)+theta(963)*AB(1) ! ((1,1,3)|(1,1,1)) = ((2,1,3)|(0,1,1))+((1,1,3)|(0,1,1))*AB(1)
        theta(1310) = theta(1090)+theta(964)*AB(1) ! ((1,1,3)|(1,0,2)) = ((2,1,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(1)
        theta(1311) = theta(1118)+theta(962)*AB(2) ! ((1,1,3)|(0,3,0)) = ((1,2,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(2)
        theta(1312) = theta(1124)+theta(962)*AB(3) ! ((1,1,3)|(0,2,1)) = ((1,1,4)|(0,2,0))+((1,1,3)|(0,2,0))*AB(3)
        theta(1313) = theta(1120)+theta(964)*AB(2) ! ((1,1,3)|(0,1,2)) = ((1,2,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(2)
        theta(1314) = theta(1126)+theta(964)*AB(3) ! ((1,1,3)|(0,0,3)) = ((1,1,4)|(0,0,2))+((1,1,3)|(0,0,2))*AB(3)
        theta(1315) = theta(1091)+theta(965)*AB(1) ! ((1,0,4)|(3,0,0)) = ((2,0,4)|(2,0,0))+((1,0,4)|(2,0,0))*AB(1)
        theta(1316) = theta(1092)+theta(966)*AB(1) ! ((1,0,4)|(2,1,0)) = ((2,0,4)|(1,1,0))+((1,0,4)|(1,1,0))*AB(1)
        theta(1317) = theta(1127)+theta(965)*AB(3) ! ((1,0,4)|(2,0,1)) = ((1,0,5)|(2,0,0))+((1,0,4)|(2,0,0))*AB(3)
        theta(1318) = theta(1094)+theta(968)*AB(1) ! ((1,0,4)|(1,2,0)) = ((2,0,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(1)
        theta(1319) = theta(1095)+theta(969)*AB(1) ! ((1,0,4)|(1,1,1)) = ((2,0,4)|(0,1,1))+((1,0,4)|(0,1,1))*AB(1)
        theta(1320) = theta(1096)+theta(970)*AB(1) ! ((1,0,4)|(1,0,2)) = ((2,0,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(1)
        theta(1321) = theta(1124)+theta(968)*AB(2) ! ((1,0,4)|(0,3,0)) = ((1,1,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(2)
        theta(1322) = theta(1130)+theta(968)*AB(3) ! ((1,0,4)|(0,2,1)) = ((1,0,5)|(0,2,0))+((1,0,4)|(0,2,0))*AB(3)
        theta(1323) = theta(1126)+theta(970)*AB(2) ! ((1,0,4)|(0,1,2)) = ((1,1,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(2)
        theta(1324) = theta(1132)+theta(970)*AB(3) ! ((1,0,4)|(0,0,3)) = ((1,0,5)|(0,0,2))+((1,0,4)|(0,0,2))*AB(3)
        theta(1325) = theta(1097)+theta(971)*AB(1) ! ((0,5,0)|(3,0,0)) = ((1,5,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(1)
        theta(1326) = theta(1133)+theta(971)*AB(2) ! ((0,5,0)|(2,1,0)) = ((0,6,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(2)
        theta(1327) = theta(1139)+theta(971)*AB(3) ! ((0,5,0)|(2,0,1)) = ((0,5,1)|(2,0,0))+((0,5,0)|(2,0,0))*AB(3)
        theta(1328) = theta(1100)+theta(974)*AB(1) ! ((0,5,0)|(1,2,0)) = ((1,5,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(1)
        theta(1329) = theta(1101)+theta(975)*AB(1) ! ((0,5,0)|(1,1,1)) = ((1,5,0)|(0,1,1))+((0,5,0)|(0,1,1))*AB(1)
        theta(1330) = theta(1102)+theta(976)*AB(1) ! ((0,5,0)|(1,0,2)) = ((1,5,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(1)
        theta(1331) = theta(1136)+theta(974)*AB(2) ! ((0,5,0)|(0,3,0)) = ((0,6,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(2)
        theta(1332) = theta(1142)+theta(974)*AB(3) ! ((0,5,0)|(0,2,1)) = ((0,5,1)|(0,2,0))+((0,5,0)|(0,2,0))*AB(3)
        theta(1333) = theta(1138)+theta(976)*AB(2) ! ((0,5,0)|(0,1,2)) = ((0,6,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(2)
        theta(1334) = theta(1144)+theta(976)*AB(3) ! ((0,5,0)|(0,0,3)) = ((0,5,1)|(0,0,2))+((0,5,0)|(0,0,2))*AB(3)
        theta(1335) = theta(1103)+theta(977)*AB(1) ! ((0,4,1)|(3,0,0)) = ((1,4,1)|(2,0,0))+((0,4,1)|(2,0,0))*AB(1)
        theta(1336) = theta(1104)+theta(978)*AB(1) ! ((0,4,1)|(2,1,0)) = ((1,4,1)|(1,1,0))+((0,4,1)|(1,1,0))*AB(1)
        theta(1337) = theta(1145)+theta(977)*AB(3) ! ((0,4,1)|(2,0,1)) = ((0,4,2)|(2,0,0))+((0,4,1)|(2,0,0))*AB(3)
        theta(1338) = theta(1106)+theta(980)*AB(1) ! ((0,4,1)|(1,2,0)) = ((1,4,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(1)
        theta(1339) = theta(1107)+theta(981)*AB(1) ! ((0,4,1)|(1,1,1)) = ((1,4,1)|(0,1,1))+((0,4,1)|(0,1,1))*AB(1)
        theta(1340) = theta(1108)+theta(982)*AB(1) ! ((0,4,1)|(1,0,2)) = ((1,4,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(1)
        theta(1341) = theta(1142)+theta(980)*AB(2) ! ((0,4,1)|(0,3,0)) = ((0,5,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(2)
        theta(1342) = theta(1148)+theta(980)*AB(3) ! ((0,4,1)|(0,2,1)) = ((0,4,2)|(0,2,0))+((0,4,1)|(0,2,0))*AB(3)
        theta(1343) = theta(1144)+theta(982)*AB(2) ! ((0,4,1)|(0,1,2)) = ((0,5,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(2)
        theta(1344) = theta(1150)+theta(982)*AB(3) ! ((0,4,1)|(0,0,3)) = ((0,4,2)|(0,0,2))+((0,4,1)|(0,0,2))*AB(3)
        theta(1345) = theta(1109)+theta(983)*AB(1) ! ((0,3,2)|(3,0,0)) = ((1,3,2)|(2,0,0))+((0,3,2)|(2,0,0))*AB(1)
        theta(1346) = theta(1110)+theta(984)*AB(1) ! ((0,3,2)|(2,1,0)) = ((1,3,2)|(1,1,0))+((0,3,2)|(1,1,0))*AB(1)
        theta(1347) = theta(1151)+theta(983)*AB(3) ! ((0,3,2)|(2,0,1)) = ((0,3,3)|(2,0,0))+((0,3,2)|(2,0,0))*AB(3)
        theta(1348) = theta(1112)+theta(986)*AB(1) ! ((0,3,2)|(1,2,0)) = ((1,3,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(1)
        theta(1349) = theta(1113)+theta(987)*AB(1) ! ((0,3,2)|(1,1,1)) = ((1,3,2)|(0,1,1))+((0,3,2)|(0,1,1))*AB(1)
        theta(1350) = theta(1114)+theta(988)*AB(1) ! ((0,3,2)|(1,0,2)) = ((1,3,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(1)
        theta(1351) = theta(1148)+theta(986)*AB(2) ! ((0,3,2)|(0,3,0)) = ((0,4,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(2)
        theta(1352) = theta(1154)+theta(986)*AB(3) ! ((0,3,2)|(0,2,1)) = ((0,3,3)|(0,2,0))+((0,3,2)|(0,2,0))*AB(3)
        theta(1353) = theta(1150)+theta(988)*AB(2) ! ((0,3,2)|(0,1,2)) = ((0,4,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(2)
        theta(1354) = theta(1156)+theta(988)*AB(3) ! ((0,3,2)|(0,0,3)) = ((0,3,3)|(0,0,2))+((0,3,2)|(0,0,2))*AB(3)
        theta(1355) = theta(1115)+theta(989)*AB(1) ! ((0,2,3)|(3,0,0)) = ((1,2,3)|(2,0,0))+((0,2,3)|(2,0,0))*AB(1)
        theta(1356) = theta(1116)+theta(990)*AB(1) ! ((0,2,3)|(2,1,0)) = ((1,2,3)|(1,1,0))+((0,2,3)|(1,1,0))*AB(1)
        theta(1357) = theta(1157)+theta(989)*AB(3) ! ((0,2,3)|(2,0,1)) = ((0,2,4)|(2,0,0))+((0,2,3)|(2,0,0))*AB(3)
        theta(1358) = theta(1118)+theta(992)*AB(1) ! ((0,2,3)|(1,2,0)) = ((1,2,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(1)
        theta(1359) = theta(1119)+theta(993)*AB(1) ! ((0,2,3)|(1,1,1)) = ((1,2,3)|(0,1,1))+((0,2,3)|(0,1,1))*AB(1)
        theta(1360) = theta(1120)+theta(994)*AB(1) ! ((0,2,3)|(1,0,2)) = ((1,2,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(1)
        theta(1361) = theta(1154)+theta(992)*AB(2) ! ((0,2,3)|(0,3,0)) = ((0,3,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(2)
        theta(1362) = theta(1160)+theta(992)*AB(3) ! ((0,2,3)|(0,2,1)) = ((0,2,4)|(0,2,0))+((0,2,3)|(0,2,0))*AB(3)
        theta(1363) = theta(1156)+theta(994)*AB(2) ! ((0,2,3)|(0,1,2)) = ((0,3,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(2)
        theta(1364) = theta(1162)+theta(994)*AB(3) ! ((0,2,3)|(0,0,3)) = ((0,2,4)|(0,0,2))+((0,2,3)|(0,0,2))*AB(3)
        theta(1365) = theta(1121)+theta(995)*AB(1) ! ((0,1,4)|(3,0,0)) = ((1,1,4)|(2,0,0))+((0,1,4)|(2,0,0))*AB(1)
        theta(1366) = theta(1122)+theta(996)*AB(1) ! ((0,1,4)|(2,1,0)) = ((1,1,4)|(1,1,0))+((0,1,4)|(1,1,0))*AB(1)
        theta(1367) = theta(1163)+theta(995)*AB(3) ! ((0,1,4)|(2,0,1)) = ((0,1,5)|(2,0,0))+((0,1,4)|(2,0,0))*AB(3)
        theta(1368) = theta(1124)+theta(998)*AB(1) ! ((0,1,4)|(1,2,0)) = ((1,1,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(1)
        theta(1369) = theta(1125)+theta(999)*AB(1) ! ((0,1,4)|(1,1,1)) = ((1,1,4)|(0,1,1))+((0,1,4)|(0,1,1))*AB(1)
        theta(1370) = theta(1126)+theta(1000)*AB(1) ! ((0,1,4)|(1,0,2)) = ((1,1,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(1)
        theta(1371) = theta(1160)+theta(998)*AB(2) ! ((0,1,4)|(0,3,0)) = ((0,2,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(2)
        theta(1372) = theta(1166)+theta(998)*AB(3) ! ((0,1,4)|(0,2,1)) = ((0,1,5)|(0,2,0))+((0,1,4)|(0,2,0))*AB(3)
        theta(1373) = theta(1162)+theta(1000)*AB(2) ! ((0,1,4)|(0,1,2)) = ((0,2,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(2)
        theta(1374) = theta(1168)+theta(1000)*AB(3) ! ((0,1,4)|(0,0,3)) = ((0,1,5)|(0,0,2))+((0,1,4)|(0,0,2))*AB(3)
        theta(1375) = theta(1127)+theta(1001)*AB(1) ! ((0,0,5)|(3,0,0)) = ((1,0,5)|(2,0,0))+((0,0,5)|(2,0,0))*AB(1)
        theta(1376) = theta(1128)+theta(1002)*AB(1) ! ((0,0,5)|(2,1,0)) = ((1,0,5)|(1,1,0))+((0,0,5)|(1,1,0))*AB(1)
        theta(1377) = theta(1169)+theta(1001)*AB(3) ! ((0,0,5)|(2,0,1)) = ((0,0,6)|(2,0,0))+((0,0,5)|(2,0,0))*AB(3)
        theta(1378) = theta(1130)+theta(1004)*AB(1) ! ((0,0,5)|(1,2,0)) = ((1,0,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(1)
        theta(1379) = theta(1131)+theta(1005)*AB(1) ! ((0,0,5)|(1,1,1)) = ((1,0,5)|(0,1,1))+((0,0,5)|(0,1,1))*AB(1)
        theta(1380) = theta(1132)+theta(1006)*AB(1) ! ((0,0,5)|(1,0,2)) = ((1,0,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(1)
        theta(1381) = theta(1166)+theta(1004)*AB(2) ! ((0,0,5)|(0,3,0)) = ((0,1,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(2)
        theta(1382) = theta(1172)+theta(1004)*AB(3) ! ((0,0,5)|(0,2,1)) = ((0,0,6)|(0,2,0))+((0,0,5)|(0,2,0))*AB(3)
        theta(1383) = theta(1168)+theta(1006)*AB(2) ! ((0,0,5)|(0,1,2)) = ((0,1,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(2)
        theta(1384) = theta(1174)+theta(1006)*AB(3) ! ((0,0,5)|(0,0,3)) = ((0,0,6)|(0,0,2))+((0,0,5)|(0,0,2))*AB(3)
    end subroutine
    subroutine hrr_5_4(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 1890; Optimized integrals: 1582
        theta(901) = theta(737)+theta(716)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(902) = theta(738)+theta(716)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(903) = theta(739)+theta(716)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(904) = theta(738)+theta(717)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(905) = theta(740)+theta(717)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(906) = theta(741)+theta(717)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(907) = theta(739)+theta(718)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(908) = theta(741)+theta(718)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(909) = theta(742)+theta(718)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(910) = theta(740)+theta(719)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(911) = theta(743)+theta(719)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(912) = theta(744)+theta(719)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(913) = theta(741)+theta(720)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(914) = theta(744)+theta(720)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(915) = theta(745)+theta(720)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(916) = theta(742)+theta(721)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(917) = theta(745)+theta(721)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(918) = theta(746)+theta(721)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(919) = theta(743)+theta(722)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(920) = theta(747)+theta(722)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(921) = theta(748)+theta(722)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(922) = theta(744)+theta(723)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(923) = theta(748)+theta(723)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(924) = theta(749)+theta(723)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(925) = theta(745)+theta(724)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(926) = theta(749)+theta(724)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(927) = theta(750)+theta(724)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(928) = theta(746)+theta(725)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(929) = theta(750)+theta(725)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(930) = theta(751)+theta(725)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(931) = theta(747)+theta(726)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(932) = theta(752)+theta(726)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(933) = theta(753)+theta(726)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(934) = theta(748)+theta(727)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(935) = theta(753)+theta(727)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(936) = theta(754)+theta(727)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(937) = theta(749)+theta(728)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(938) = theta(754)+theta(728)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(939) = theta(755)+theta(728)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(940) = theta(750)+theta(729)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(941) = theta(755)+theta(729)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(942) = theta(756)+theta(729)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(943) = theta(751)+theta(730)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(944) = theta(756)+theta(730)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(945) = theta(757)+theta(730)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(946) = theta(752)+theta(731)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(947) = theta(758)+theta(731)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(948) = theta(759)+theta(731)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(949) = theta(753)+theta(732)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(950) = theta(759)+theta(732)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(951) = theta(760)+theta(732)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(952) = theta(754)+theta(733)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(953) = theta(760)+theta(733)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(954) = theta(761)+theta(733)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(955) = theta(755)+theta(734)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(956) = theta(761)+theta(734)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(957) = theta(762)+theta(734)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(958) = theta(756)+theta(735)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(959) = theta(762)+theta(735)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(960) = theta(763)+theta(735)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(961) = theta(757)+theta(736)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(962) = theta(763)+theta(736)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(963) = theta(764)+theta(736)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(964) = theta(765)+theta(737)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(965) = theta(766)+theta(737)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        theta(966) = theta(767)+theta(737)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(967) = theta(766)+theta(738)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(968) = theta(768)+theta(738)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(969) = theta(769)+theta(738)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(970) = theta(767)+theta(739)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(971) = theta(769)+theta(739)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(972) = theta(770)+theta(739)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(973) = theta(768)+theta(740)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(974) = theta(771)+theta(740)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(975) = theta(772)+theta(740)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(976) = theta(769)+theta(741)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(977) = theta(772)+theta(741)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(978) = theta(773)+theta(741)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(979) = theta(770)+theta(742)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(980) = theta(773)+theta(742)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(981) = theta(774)+theta(742)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(982) = theta(771)+theta(743)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(983) = theta(775)+theta(743)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(984) = theta(776)+theta(743)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(985) = theta(772)+theta(744)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(986) = theta(776)+theta(744)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(987) = theta(777)+theta(744)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(988) = theta(773)+theta(745)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(989) = theta(777)+theta(745)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(990) = theta(778)+theta(745)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(991) = theta(774)+theta(746)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(992) = theta(778)+theta(746)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(993) = theta(779)+theta(746)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(994) = theta(775)+theta(747)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(995) = theta(780)+theta(747)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(996) = theta(781)+theta(747)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(997) = theta(776)+theta(748)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(998) = theta(781)+theta(748)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(999) = theta(782)+theta(748)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(1000) = theta(777)+theta(749)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(1001) = theta(782)+theta(749)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(1002) = theta(783)+theta(749)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(1003) = theta(778)+theta(750)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(1004) = theta(783)+theta(750)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(1005) = theta(784)+theta(750)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(1006) = theta(779)+theta(751)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(1007) = theta(784)+theta(751)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(1008) = theta(785)+theta(751)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(1009) = theta(780)+theta(752)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(1010) = theta(786)+theta(752)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(1011) = theta(787)+theta(752)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(1012) = theta(781)+theta(753)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(1013) = theta(787)+theta(753)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(1014) = theta(788)+theta(753)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(1015) = theta(782)+theta(754)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(1016) = theta(788)+theta(754)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(1017) = theta(789)+theta(754)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(1018) = theta(783)+theta(755)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(1019) = theta(789)+theta(755)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(1020) = theta(790)+theta(755)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(1021) = theta(784)+theta(756)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(1022) = theta(790)+theta(756)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(1023) = theta(791)+theta(756)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(1024) = theta(785)+theta(757)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        theta(1025) = theta(791)+theta(757)*AB(2) ! ((1,0,5)|(0,1,0)) = ((1,1,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(2)
        theta(1026) = theta(792)+theta(757)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(1027) = theta(786)+theta(758)*AB(1) ! ((0,6,0)|(1,0,0)) = ((1,6,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(1)
        theta(1028) = theta(793)+theta(758)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(1029) = theta(794)+theta(758)*AB(3) ! ((0,6,0)|(0,0,1)) = ((0,6,1)|(0,0,0))+((0,6,0)|(0,0,0))*AB(3)
        theta(1030) = theta(787)+theta(759)*AB(1) ! ((0,5,1)|(1,0,0)) = ((1,5,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(1)
        theta(1031) = theta(794)+theta(759)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(1032) = theta(795)+theta(759)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(1033) = theta(788)+theta(760)*AB(1) ! ((0,4,2)|(1,0,0)) = ((1,4,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(1)
        theta(1034) = theta(795)+theta(760)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(1035) = theta(796)+theta(760)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(1036) = theta(789)+theta(761)*AB(1) ! ((0,3,3)|(1,0,0)) = ((1,3,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(1)
        theta(1037) = theta(796)+theta(761)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(1038) = theta(797)+theta(761)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(1039) = theta(790)+theta(762)*AB(1) ! ((0,2,4)|(1,0,0)) = ((1,2,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(1)
        theta(1040) = theta(797)+theta(762)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(1041) = theta(798)+theta(762)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(1042) = theta(791)+theta(763)*AB(1) ! ((0,1,5)|(1,0,0)) = ((1,1,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(1)
        theta(1043) = theta(798)+theta(763)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(1044) = theta(799)+theta(763)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(1045) = theta(792)+theta(764)*AB(1) ! ((0,0,6)|(1,0,0)) = ((1,0,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(1)
        theta(1046) = theta(799)+theta(764)*AB(2) ! ((0,0,6)|(0,1,0)) = ((0,1,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(2)
        theta(1047) = theta(800)+theta(764)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(1048) = theta(801)+theta(765)*AB(1) ! ((7,0,0)|(1,0,0)) = ((8,0,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(1)
        theta(1049) = theta(802)+theta(765)*AB(2) ! ((7,0,0)|(0,1,0)) = ((7,1,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(2)
        theta(1050) = theta(803)+theta(765)*AB(3) ! ((7,0,0)|(0,0,1)) = ((7,0,1)|(0,0,0))+((7,0,0)|(0,0,0))*AB(3)
        theta(1051) = theta(802)+theta(766)*AB(1) ! ((6,1,0)|(1,0,0)) = ((7,1,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(1)
        theta(1052) = theta(804)+theta(766)*AB(2) ! ((6,1,0)|(0,1,0)) = ((6,2,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(2)
        theta(1053) = theta(805)+theta(766)*AB(3) ! ((6,1,0)|(0,0,1)) = ((6,1,1)|(0,0,0))+((6,1,0)|(0,0,0))*AB(3)
        theta(1054) = theta(803)+theta(767)*AB(1) ! ((6,0,1)|(1,0,0)) = ((7,0,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(1)
        theta(1055) = theta(805)+theta(767)*AB(2) ! ((6,0,1)|(0,1,0)) = ((6,1,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(2)
        theta(1056) = theta(806)+theta(767)*AB(3) ! ((6,0,1)|(0,0,1)) = ((6,0,2)|(0,0,0))+((6,0,1)|(0,0,0))*AB(3)
        theta(1057) = theta(804)+theta(768)*AB(1) ! ((5,2,0)|(1,0,0)) = ((6,2,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(1)
        theta(1058) = theta(807)+theta(768)*AB(2) ! ((5,2,0)|(0,1,0)) = ((5,3,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(2)
        theta(1059) = theta(808)+theta(768)*AB(3) ! ((5,2,0)|(0,0,1)) = ((5,2,1)|(0,0,0))+((5,2,0)|(0,0,0))*AB(3)
        theta(1060) = theta(805)+theta(769)*AB(1) ! ((5,1,1)|(1,0,0)) = ((6,1,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(1)
        theta(1061) = theta(808)+theta(769)*AB(2) ! ((5,1,1)|(0,1,0)) = ((5,2,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(2)
        theta(1062) = theta(809)+theta(769)*AB(3) ! ((5,1,1)|(0,0,1)) = ((5,1,2)|(0,0,0))+((5,1,1)|(0,0,0))*AB(3)
        theta(1063) = theta(806)+theta(770)*AB(1) ! ((5,0,2)|(1,0,0)) = ((6,0,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(1)
        theta(1064) = theta(809)+theta(770)*AB(2) ! ((5,0,2)|(0,1,0)) = ((5,1,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(2)
        theta(1065) = theta(810)+theta(770)*AB(3) ! ((5,0,2)|(0,0,1)) = ((5,0,3)|(0,0,0))+((5,0,2)|(0,0,0))*AB(3)
        theta(1066) = theta(807)+theta(771)*AB(1) ! ((4,3,0)|(1,0,0)) = ((5,3,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(1)
        theta(1067) = theta(811)+theta(771)*AB(2) ! ((4,3,0)|(0,1,0)) = ((4,4,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(2)
        theta(1068) = theta(812)+theta(771)*AB(3) ! ((4,3,0)|(0,0,1)) = ((4,3,1)|(0,0,0))+((4,3,0)|(0,0,0))*AB(3)
        theta(1069) = theta(808)+theta(772)*AB(1) ! ((4,2,1)|(1,0,0)) = ((5,2,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(1)
        theta(1070) = theta(812)+theta(772)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(1071) = theta(813)+theta(772)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(1072) = theta(809)+theta(773)*AB(1) ! ((4,1,2)|(1,0,0)) = ((5,1,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(1)
        theta(1073) = theta(813)+theta(773)*AB(2) ! ((4,1,2)|(0,1,0)) = ((4,2,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(2)
        theta(1074) = theta(814)+theta(773)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(1075) = theta(810)+theta(774)*AB(1) ! ((4,0,3)|(1,0,0)) = ((5,0,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(1)
        theta(1076) = theta(814)+theta(774)*AB(2) ! ((4,0,3)|(0,1,0)) = ((4,1,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(2)
        theta(1077) = theta(815)+theta(774)*AB(3) ! ((4,0,3)|(0,0,1)) = ((4,0,4)|(0,0,0))+((4,0,3)|(0,0,0))*AB(3)
        theta(1078) = theta(811)+theta(775)*AB(1) ! ((3,4,0)|(1,0,0)) = ((4,4,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(1)
        theta(1079) = theta(816)+theta(775)*AB(2) ! ((3,4,0)|(0,1,0)) = ((3,5,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(2)
        theta(1080) = theta(817)+theta(775)*AB(3) ! ((3,4,0)|(0,0,1)) = ((3,4,1)|(0,0,0))+((3,4,0)|(0,0,0))*AB(3)
        theta(1081) = theta(812)+theta(776)*AB(1) ! ((3,3,1)|(1,0,0)) = ((4,3,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(1)
        theta(1082) = theta(817)+theta(776)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(1083) = theta(818)+theta(776)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(1084) = theta(813)+theta(777)*AB(1) ! ((3,2,2)|(1,0,0)) = ((4,2,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(1)
        theta(1085) = theta(818)+theta(777)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(1086) = theta(819)+theta(777)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(1087) = theta(814)+theta(778)*AB(1) ! ((3,1,3)|(1,0,0)) = ((4,1,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(1)
        theta(1088) = theta(819)+theta(778)*AB(2) ! ((3,1,3)|(0,1,0)) = ((3,2,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(2)
        theta(1089) = theta(820)+theta(778)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(1090) = theta(815)+theta(779)*AB(1) ! ((3,0,4)|(1,0,0)) = ((4,0,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(1)
        theta(1091) = theta(820)+theta(779)*AB(2) ! ((3,0,4)|(0,1,0)) = ((3,1,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(2)
        theta(1092) = theta(821)+theta(779)*AB(3) ! ((3,0,4)|(0,0,1)) = ((3,0,5)|(0,0,0))+((3,0,4)|(0,0,0))*AB(3)
        theta(1093) = theta(816)+theta(780)*AB(1) ! ((2,5,0)|(1,0,0)) = ((3,5,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(1)
        theta(1094) = theta(822)+theta(780)*AB(2) ! ((2,5,0)|(0,1,0)) = ((2,6,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(2)
        theta(1095) = theta(823)+theta(780)*AB(3) ! ((2,5,0)|(0,0,1)) = ((2,5,1)|(0,0,0))+((2,5,0)|(0,0,0))*AB(3)
        theta(1096) = theta(817)+theta(781)*AB(1) ! ((2,4,1)|(1,0,0)) = ((3,4,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(1)
        theta(1097) = theta(823)+theta(781)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(1098) = theta(824)+theta(781)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(1099) = theta(818)+theta(782)*AB(1) ! ((2,3,2)|(1,0,0)) = ((3,3,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(1)
        theta(1100) = theta(824)+theta(782)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(1101) = theta(825)+theta(782)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(1102) = theta(819)+theta(783)*AB(1) ! ((2,2,3)|(1,0,0)) = ((3,2,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(1)
        theta(1103) = theta(825)+theta(783)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(1104) = theta(826)+theta(783)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(1105) = theta(820)+theta(784)*AB(1) ! ((2,1,4)|(1,0,0)) = ((3,1,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(1)
        theta(1106) = theta(826)+theta(784)*AB(2) ! ((2,1,4)|(0,1,0)) = ((2,2,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(2)
        theta(1107) = theta(827)+theta(784)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(1108) = theta(821)+theta(785)*AB(1) ! ((2,0,5)|(1,0,0)) = ((3,0,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(1)
        theta(1109) = theta(827)+theta(785)*AB(2) ! ((2,0,5)|(0,1,0)) = ((2,1,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(2)
        theta(1110) = theta(828)+theta(785)*AB(3) ! ((2,0,5)|(0,0,1)) = ((2,0,6)|(0,0,0))+((2,0,5)|(0,0,0))*AB(3)
        theta(1111) = theta(822)+theta(786)*AB(1) ! ((1,6,0)|(1,0,0)) = ((2,6,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(1)
        theta(1112) = theta(829)+theta(786)*AB(2) ! ((1,6,0)|(0,1,0)) = ((1,7,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(2)
        theta(1113) = theta(830)+theta(786)*AB(3) ! ((1,6,0)|(0,0,1)) = ((1,6,1)|(0,0,0))+((1,6,0)|(0,0,0))*AB(3)
        theta(1114) = theta(823)+theta(787)*AB(1) ! ((1,5,1)|(1,0,0)) = ((2,5,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(1)
        theta(1115) = theta(830)+theta(787)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(1116) = theta(831)+theta(787)*AB(3) ! ((1,5,1)|(0,0,1)) = ((1,5,2)|(0,0,0))+((1,5,1)|(0,0,0))*AB(3)
        theta(1117) = theta(824)+theta(788)*AB(1) ! ((1,4,2)|(1,0,0)) = ((2,4,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(1)
        theta(1118) = theta(831)+theta(788)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(1119) = theta(832)+theta(788)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        theta(1120) = theta(825)+theta(789)*AB(1) ! ((1,3,3)|(1,0,0)) = ((2,3,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(1)
        theta(1121) = theta(832)+theta(789)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(1122) = theta(833)+theta(789)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(1123) = theta(826)+theta(790)*AB(1) ! ((1,2,4)|(1,0,0)) = ((2,2,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(1)
        theta(1124) = theta(833)+theta(790)*AB(2) ! ((1,2,4)|(0,1,0)) = ((1,3,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(2)
        theta(1125) = theta(834)+theta(790)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(1126) = theta(827)+theta(791)*AB(1) ! ((1,1,5)|(1,0,0)) = ((2,1,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(1)
        theta(1127) = theta(834)+theta(791)*AB(2) ! ((1,1,5)|(0,1,0)) = ((1,2,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(2)
        theta(1128) = theta(835)+theta(791)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        theta(1129) = theta(828)+theta(792)*AB(1) ! ((1,0,6)|(1,0,0)) = ((2,0,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(1)
        theta(1130) = theta(835)+theta(792)*AB(2) ! ((1,0,6)|(0,1,0)) = ((1,1,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(2)
        theta(1131) = theta(836)+theta(792)*AB(3) ! ((1,0,6)|(0,0,1)) = ((1,0,7)|(0,0,0))+((1,0,6)|(0,0,0))*AB(3)
        ! theta(1132) = theta(829)+theta(793)*AB(1) ! ((0,7,0)|(1,0,0)) = ((1,7,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(1)
        theta(1133) = theta(837)+theta(793)*AB(2) ! ((0,7,0)|(0,1,0)) = ((0,8,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(2)
        theta(1134) = theta(838)+theta(793)*AB(3) ! ((0,7,0)|(0,0,1)) = ((0,7,1)|(0,0,0))+((0,7,0)|(0,0,0))*AB(3)
        theta(1135) = theta(830)+theta(794)*AB(1) ! ((0,6,1)|(1,0,0)) = ((1,6,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(1)
        theta(1136) = theta(838)+theta(794)*AB(2) ! ((0,6,1)|(0,1,0)) = ((0,7,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(2)
        theta(1137) = theta(839)+theta(794)*AB(3) ! ((0,6,1)|(0,0,1)) = ((0,6,2)|(0,0,0))+((0,6,1)|(0,0,0))*AB(3)
        ! theta(1138) = theta(831)+theta(795)*AB(1) ! ((0,5,2)|(1,0,0)) = ((1,5,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(1)
        theta(1139) = theta(839)+theta(795)*AB(2) ! ((0,5,2)|(0,1,0)) = ((0,6,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(2)
        theta(1140) = theta(840)+theta(795)*AB(3) ! ((0,5,2)|(0,0,1)) = ((0,5,3)|(0,0,0))+((0,5,2)|(0,0,0))*AB(3)
        ! theta(1141) = theta(832)+theta(796)*AB(1) ! ((0,4,3)|(1,0,0)) = ((1,4,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(1)
        theta(1142) = theta(840)+theta(796)*AB(2) ! ((0,4,3)|(0,1,0)) = ((0,5,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(2)
        theta(1143) = theta(841)+theta(796)*AB(3) ! ((0,4,3)|(0,0,1)) = ((0,4,4)|(0,0,0))+((0,4,3)|(0,0,0))*AB(3)
        ! theta(1144) = theta(833)+theta(797)*AB(1) ! ((0,3,4)|(1,0,0)) = ((1,3,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(1)
        theta(1145) = theta(841)+theta(797)*AB(2) ! ((0,3,4)|(0,1,0)) = ((0,4,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(2)
        theta(1146) = theta(842)+theta(797)*AB(3) ! ((0,3,4)|(0,0,1)) = ((0,3,5)|(0,0,0))+((0,3,4)|(0,0,0))*AB(3)
        ! theta(1147) = theta(834)+theta(798)*AB(1) ! ((0,2,5)|(1,0,0)) = ((1,2,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(1)
        theta(1148) = theta(842)+theta(798)*AB(2) ! ((0,2,5)|(0,1,0)) = ((0,3,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(2)
        theta(1149) = theta(843)+theta(798)*AB(3) ! ((0,2,5)|(0,0,1)) = ((0,2,6)|(0,0,0))+((0,2,5)|(0,0,0))*AB(3)
        ! theta(1150) = theta(835)+theta(799)*AB(1) ! ((0,1,6)|(1,0,0)) = ((1,1,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(1)
        theta(1151) = theta(843)+theta(799)*AB(2) ! ((0,1,6)|(0,1,0)) = ((0,2,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(2)
        theta(1152) = theta(844)+theta(799)*AB(3) ! ((0,1,6)|(0,0,1)) = ((0,1,7)|(0,0,0))+((0,1,6)|(0,0,0))*AB(3)
        ! theta(1153) = theta(836)+theta(800)*AB(1) ! ((0,0,7)|(1,0,0)) = ((1,0,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(1)
        ! theta(1154) = theta(844)+theta(800)*AB(2) ! ((0,0,7)|(0,1,0)) = ((0,1,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(2)
        theta(1155) = theta(845)+theta(800)*AB(3) ! ((0,0,7)|(0,0,1)) = ((0,0,8)|(0,0,0))+((0,0,7)|(0,0,0))*AB(3)
        theta(1156) = theta(846)+theta(801)*AB(1) ! ((8,0,0)|(1,0,0)) = ((9,0,0)|(0,0,0))+((8,0,0)|(0,0,0))*AB(1)
        ! theta(1157) = theta(847)+theta(801)*AB(2) ! ((8,0,0)|(0,1,0)) = ((8,1,0)|(0,0,0))+((8,0,0)|(0,0,0))*AB(2)
        ! theta(1158) = theta(848)+theta(801)*AB(3) ! ((8,0,0)|(0,0,1)) = ((8,0,1)|(0,0,0))+((8,0,0)|(0,0,0))*AB(3)
        theta(1159) = theta(847)+theta(802)*AB(1) ! ((7,1,0)|(1,0,0)) = ((8,1,0)|(0,0,0))+((7,1,0)|(0,0,0))*AB(1)
        theta(1160) = theta(849)+theta(802)*AB(2) ! ((7,1,0)|(0,1,0)) = ((7,2,0)|(0,0,0))+((7,1,0)|(0,0,0))*AB(2)
        ! theta(1161) = theta(850)+theta(802)*AB(3) ! ((7,1,0)|(0,0,1)) = ((7,1,1)|(0,0,0))+((7,1,0)|(0,0,0))*AB(3)
        theta(1162) = theta(848)+theta(803)*AB(1) ! ((7,0,1)|(1,0,0)) = ((8,0,1)|(0,0,0))+((7,0,1)|(0,0,0))*AB(1)
        theta(1163) = theta(850)+theta(803)*AB(2) ! ((7,0,1)|(0,1,0)) = ((7,1,1)|(0,0,0))+((7,0,1)|(0,0,0))*AB(2)
        theta(1164) = theta(851)+theta(803)*AB(3) ! ((7,0,1)|(0,0,1)) = ((7,0,2)|(0,0,0))+((7,0,1)|(0,0,0))*AB(3)
        theta(1165) = theta(849)+theta(804)*AB(1) ! ((6,2,0)|(1,0,0)) = ((7,2,0)|(0,0,0))+((6,2,0)|(0,0,0))*AB(1)
        theta(1166) = theta(852)+theta(804)*AB(2) ! ((6,2,0)|(0,1,0)) = ((6,3,0)|(0,0,0))+((6,2,0)|(0,0,0))*AB(2)
        ! theta(1167) = theta(853)+theta(804)*AB(3) ! ((6,2,0)|(0,0,1)) = ((6,2,1)|(0,0,0))+((6,2,0)|(0,0,0))*AB(3)
        theta(1168) = theta(850)+theta(805)*AB(1) ! ((6,1,1)|(1,0,0)) = ((7,1,1)|(0,0,0))+((6,1,1)|(0,0,0))*AB(1)
        theta(1169) = theta(853)+theta(805)*AB(2) ! ((6,1,1)|(0,1,0)) = ((6,2,1)|(0,0,0))+((6,1,1)|(0,0,0))*AB(2)
        theta(1170) = theta(854)+theta(805)*AB(3) ! ((6,1,1)|(0,0,1)) = ((6,1,2)|(0,0,0))+((6,1,1)|(0,0,0))*AB(3)
        theta(1171) = theta(851)+theta(806)*AB(1) ! ((6,0,2)|(1,0,0)) = ((7,0,2)|(0,0,0))+((6,0,2)|(0,0,0))*AB(1)
        theta(1172) = theta(854)+theta(806)*AB(2) ! ((6,0,2)|(0,1,0)) = ((6,1,2)|(0,0,0))+((6,0,2)|(0,0,0))*AB(2)
        theta(1173) = theta(855)+theta(806)*AB(3) ! ((6,0,2)|(0,0,1)) = ((6,0,3)|(0,0,0))+((6,0,2)|(0,0,0))*AB(3)
        theta(1174) = theta(852)+theta(807)*AB(1) ! ((5,3,0)|(1,0,0)) = ((6,3,0)|(0,0,0))+((5,3,0)|(0,0,0))*AB(1)
        theta(1175) = theta(856)+theta(807)*AB(2) ! ((5,3,0)|(0,1,0)) = ((5,4,0)|(0,0,0))+((5,3,0)|(0,0,0))*AB(2)
        ! theta(1176) = theta(857)+theta(807)*AB(3) ! ((5,3,0)|(0,0,1)) = ((5,3,1)|(0,0,0))+((5,3,0)|(0,0,0))*AB(3)
        theta(1177) = theta(853)+theta(808)*AB(1) ! ((5,2,1)|(1,0,0)) = ((6,2,1)|(0,0,0))+((5,2,1)|(0,0,0))*AB(1)
        theta(1178) = theta(857)+theta(808)*AB(2) ! ((5,2,1)|(0,1,0)) = ((5,3,1)|(0,0,0))+((5,2,1)|(0,0,0))*AB(2)
        theta(1179) = theta(858)+theta(808)*AB(3) ! ((5,2,1)|(0,0,1)) = ((5,2,2)|(0,0,0))+((5,2,1)|(0,0,0))*AB(3)
        theta(1180) = theta(854)+theta(809)*AB(1) ! ((5,1,2)|(1,0,0)) = ((6,1,2)|(0,0,0))+((5,1,2)|(0,0,0))*AB(1)
        theta(1181) = theta(858)+theta(809)*AB(2) ! ((5,1,2)|(0,1,0)) = ((5,2,2)|(0,0,0))+((5,1,2)|(0,0,0))*AB(2)
        theta(1182) = theta(859)+theta(809)*AB(3) ! ((5,1,2)|(0,0,1)) = ((5,1,3)|(0,0,0))+((5,1,2)|(0,0,0))*AB(3)
        theta(1183) = theta(855)+theta(810)*AB(1) ! ((5,0,3)|(1,0,0)) = ((6,0,3)|(0,0,0))+((5,0,3)|(0,0,0))*AB(1)
        theta(1184) = theta(859)+theta(810)*AB(2) ! ((5,0,3)|(0,1,0)) = ((5,1,3)|(0,0,0))+((5,0,3)|(0,0,0))*AB(2)
        theta(1185) = theta(860)+theta(810)*AB(3) ! ((5,0,3)|(0,0,1)) = ((5,0,4)|(0,0,0))+((5,0,3)|(0,0,0))*AB(3)
        theta(1186) = theta(856)+theta(811)*AB(1) ! ((4,4,0)|(1,0,0)) = ((5,4,0)|(0,0,0))+((4,4,0)|(0,0,0))*AB(1)
        theta(1187) = theta(861)+theta(811)*AB(2) ! ((4,4,0)|(0,1,0)) = ((4,5,0)|(0,0,0))+((4,4,0)|(0,0,0))*AB(2)
        ! theta(1188) = theta(862)+theta(811)*AB(3) ! ((4,4,0)|(0,0,1)) = ((4,4,1)|(0,0,0))+((4,4,0)|(0,0,0))*AB(3)
        theta(1189) = theta(857)+theta(812)*AB(1) ! ((4,3,1)|(1,0,0)) = ((5,3,1)|(0,0,0))+((4,3,1)|(0,0,0))*AB(1)
        theta(1190) = theta(862)+theta(812)*AB(2) ! ((4,3,1)|(0,1,0)) = ((4,4,1)|(0,0,0))+((4,3,1)|(0,0,0))*AB(2)
        theta(1191) = theta(863)+theta(812)*AB(3) ! ((4,3,1)|(0,0,1)) = ((4,3,2)|(0,0,0))+((4,3,1)|(0,0,0))*AB(3)
        theta(1192) = theta(858)+theta(813)*AB(1) ! ((4,2,2)|(1,0,0)) = ((5,2,2)|(0,0,0))+((4,2,2)|(0,0,0))*AB(1)
        theta(1193) = theta(863)+theta(813)*AB(2) ! ((4,2,2)|(0,1,0)) = ((4,3,2)|(0,0,0))+((4,2,2)|(0,0,0))*AB(2)
        theta(1194) = theta(864)+theta(813)*AB(3) ! ((4,2,2)|(0,0,1)) = ((4,2,3)|(0,0,0))+((4,2,2)|(0,0,0))*AB(3)
        theta(1195) = theta(859)+theta(814)*AB(1) ! ((4,1,3)|(1,0,0)) = ((5,1,3)|(0,0,0))+((4,1,3)|(0,0,0))*AB(1)
        theta(1196) = theta(864)+theta(814)*AB(2) ! ((4,1,3)|(0,1,0)) = ((4,2,3)|(0,0,0))+((4,1,3)|(0,0,0))*AB(2)
        theta(1197) = theta(865)+theta(814)*AB(3) ! ((4,1,3)|(0,0,1)) = ((4,1,4)|(0,0,0))+((4,1,3)|(0,0,0))*AB(3)
        theta(1198) = theta(860)+theta(815)*AB(1) ! ((4,0,4)|(1,0,0)) = ((5,0,4)|(0,0,0))+((4,0,4)|(0,0,0))*AB(1)
        theta(1199) = theta(865)+theta(815)*AB(2) ! ((4,0,4)|(0,1,0)) = ((4,1,4)|(0,0,0))+((4,0,4)|(0,0,0))*AB(2)
        theta(1200) = theta(866)+theta(815)*AB(3) ! ((4,0,4)|(0,0,1)) = ((4,0,5)|(0,0,0))+((4,0,4)|(0,0,0))*AB(3)
        theta(1201) = theta(861)+theta(816)*AB(1) ! ((3,5,0)|(1,0,0)) = ((4,5,0)|(0,0,0))+((3,5,0)|(0,0,0))*AB(1)
        theta(1202) = theta(867)+theta(816)*AB(2) ! ((3,5,0)|(0,1,0)) = ((3,6,0)|(0,0,0))+((3,5,0)|(0,0,0))*AB(2)
        ! theta(1203) = theta(868)+theta(816)*AB(3) ! ((3,5,0)|(0,0,1)) = ((3,5,1)|(0,0,0))+((3,5,0)|(0,0,0))*AB(3)
        theta(1204) = theta(862)+theta(817)*AB(1) ! ((3,4,1)|(1,0,0)) = ((4,4,1)|(0,0,0))+((3,4,1)|(0,0,0))*AB(1)
        theta(1205) = theta(868)+theta(817)*AB(2) ! ((3,4,1)|(0,1,0)) = ((3,5,1)|(0,0,0))+((3,4,1)|(0,0,0))*AB(2)
        theta(1206) = theta(869)+theta(817)*AB(3) ! ((3,4,1)|(0,0,1)) = ((3,4,2)|(0,0,0))+((3,4,1)|(0,0,0))*AB(3)
        theta(1207) = theta(863)+theta(818)*AB(1) ! ((3,3,2)|(1,0,0)) = ((4,3,2)|(0,0,0))+((3,3,2)|(0,0,0))*AB(1)
        theta(1208) = theta(869)+theta(818)*AB(2) ! ((3,3,2)|(0,1,0)) = ((3,4,2)|(0,0,0))+((3,3,2)|(0,0,0))*AB(2)
        theta(1209) = theta(870)+theta(818)*AB(3) ! ((3,3,2)|(0,0,1)) = ((3,3,3)|(0,0,0))+((3,3,2)|(0,0,0))*AB(3)
        theta(1210) = theta(864)+theta(819)*AB(1) ! ((3,2,3)|(1,0,0)) = ((4,2,3)|(0,0,0))+((3,2,3)|(0,0,0))*AB(1)
        theta(1211) = theta(870)+theta(819)*AB(2) ! ((3,2,3)|(0,1,0)) = ((3,3,3)|(0,0,0))+((3,2,3)|(0,0,0))*AB(2)
        theta(1212) = theta(871)+theta(819)*AB(3) ! ((3,2,3)|(0,0,1)) = ((3,2,4)|(0,0,0))+((3,2,3)|(0,0,0))*AB(3)
        theta(1213) = theta(865)+theta(820)*AB(1) ! ((3,1,4)|(1,0,0)) = ((4,1,4)|(0,0,0))+((3,1,4)|(0,0,0))*AB(1)
        theta(1214) = theta(871)+theta(820)*AB(2) ! ((3,1,4)|(0,1,0)) = ((3,2,4)|(0,0,0))+((3,1,4)|(0,0,0))*AB(2)
        theta(1215) = theta(872)+theta(820)*AB(3) ! ((3,1,4)|(0,0,1)) = ((3,1,5)|(0,0,0))+((3,1,4)|(0,0,0))*AB(3)
        theta(1216) = theta(866)+theta(821)*AB(1) ! ((3,0,5)|(1,0,0)) = ((4,0,5)|(0,0,0))+((3,0,5)|(0,0,0))*AB(1)
        theta(1217) = theta(872)+theta(821)*AB(2) ! ((3,0,5)|(0,1,0)) = ((3,1,5)|(0,0,0))+((3,0,5)|(0,0,0))*AB(2)
        theta(1218) = theta(873)+theta(821)*AB(3) ! ((3,0,5)|(0,0,1)) = ((3,0,6)|(0,0,0))+((3,0,5)|(0,0,0))*AB(3)
        theta(1219) = theta(867)+theta(822)*AB(1) ! ((2,6,0)|(1,0,0)) = ((3,6,0)|(0,0,0))+((2,6,0)|(0,0,0))*AB(1)
        theta(1220) = theta(874)+theta(822)*AB(2) ! ((2,6,0)|(0,1,0)) = ((2,7,0)|(0,0,0))+((2,6,0)|(0,0,0))*AB(2)
        ! theta(1221) = theta(875)+theta(822)*AB(3) ! ((2,6,0)|(0,0,1)) = ((2,6,1)|(0,0,0))+((2,6,0)|(0,0,0))*AB(3)
        theta(1222) = theta(868)+theta(823)*AB(1) ! ((2,5,1)|(1,0,0)) = ((3,5,1)|(0,0,0))+((2,5,1)|(0,0,0))*AB(1)
        theta(1223) = theta(875)+theta(823)*AB(2) ! ((2,5,1)|(0,1,0)) = ((2,6,1)|(0,0,0))+((2,5,1)|(0,0,0))*AB(2)
        theta(1224) = theta(876)+theta(823)*AB(3) ! ((2,5,1)|(0,0,1)) = ((2,5,2)|(0,0,0))+((2,5,1)|(0,0,0))*AB(3)
        theta(1225) = theta(869)+theta(824)*AB(1) ! ((2,4,2)|(1,0,0)) = ((3,4,2)|(0,0,0))+((2,4,2)|(0,0,0))*AB(1)
        theta(1226) = theta(876)+theta(824)*AB(2) ! ((2,4,2)|(0,1,0)) = ((2,5,2)|(0,0,0))+((2,4,2)|(0,0,0))*AB(2)
        theta(1227) = theta(877)+theta(824)*AB(3) ! ((2,4,2)|(0,0,1)) = ((2,4,3)|(0,0,0))+((2,4,2)|(0,0,0))*AB(3)
        theta(1228) = theta(870)+theta(825)*AB(1) ! ((2,3,3)|(1,0,0)) = ((3,3,3)|(0,0,0))+((2,3,3)|(0,0,0))*AB(1)
        theta(1229) = theta(877)+theta(825)*AB(2) ! ((2,3,3)|(0,1,0)) = ((2,4,3)|(0,0,0))+((2,3,3)|(0,0,0))*AB(2)
        theta(1230) = theta(878)+theta(825)*AB(3) ! ((2,3,3)|(0,0,1)) = ((2,3,4)|(0,0,0))+((2,3,3)|(0,0,0))*AB(3)
        theta(1231) = theta(871)+theta(826)*AB(1) ! ((2,2,4)|(1,0,0)) = ((3,2,4)|(0,0,0))+((2,2,4)|(0,0,0))*AB(1)
        theta(1232) = theta(878)+theta(826)*AB(2) ! ((2,2,4)|(0,1,0)) = ((2,3,4)|(0,0,0))+((2,2,4)|(0,0,0))*AB(2)
        theta(1233) = theta(879)+theta(826)*AB(3) ! ((2,2,4)|(0,0,1)) = ((2,2,5)|(0,0,0))+((2,2,4)|(0,0,0))*AB(3)
        theta(1234) = theta(872)+theta(827)*AB(1) ! ((2,1,5)|(1,0,0)) = ((3,1,5)|(0,0,0))+((2,1,5)|(0,0,0))*AB(1)
        theta(1235) = theta(879)+theta(827)*AB(2) ! ((2,1,5)|(0,1,0)) = ((2,2,5)|(0,0,0))+((2,1,5)|(0,0,0))*AB(2)
        theta(1236) = theta(880)+theta(827)*AB(3) ! ((2,1,5)|(0,0,1)) = ((2,1,6)|(0,0,0))+((2,1,5)|(0,0,0))*AB(3)
        theta(1237) = theta(873)+theta(828)*AB(1) ! ((2,0,6)|(1,0,0)) = ((3,0,6)|(0,0,0))+((2,0,6)|(0,0,0))*AB(1)
        ! theta(1238) = theta(880)+theta(828)*AB(2) ! ((2,0,6)|(0,1,0)) = ((2,1,6)|(0,0,0))+((2,0,6)|(0,0,0))*AB(2)
        theta(1239) = theta(881)+theta(828)*AB(3) ! ((2,0,6)|(0,0,1)) = ((2,0,7)|(0,0,0))+((2,0,6)|(0,0,0))*AB(3)
        ! theta(1240) = theta(874)+theta(829)*AB(1) ! ((1,7,0)|(1,0,0)) = ((2,7,0)|(0,0,0))+((1,7,0)|(0,0,0))*AB(1)
        theta(1241) = theta(882)+theta(829)*AB(2) ! ((1,7,0)|(0,1,0)) = ((1,8,0)|(0,0,0))+((1,7,0)|(0,0,0))*AB(2)
        ! theta(1242) = theta(883)+theta(829)*AB(3) ! ((1,7,0)|(0,0,1)) = ((1,7,1)|(0,0,0))+((1,7,0)|(0,0,0))*AB(3)
        theta(1243) = theta(875)+theta(830)*AB(1) ! ((1,6,1)|(1,0,0)) = ((2,6,1)|(0,0,0))+((1,6,1)|(0,0,0))*AB(1)
        theta(1244) = theta(883)+theta(830)*AB(2) ! ((1,6,1)|(0,1,0)) = ((1,7,1)|(0,0,0))+((1,6,1)|(0,0,0))*AB(2)
        theta(1245) = theta(884)+theta(830)*AB(3) ! ((1,6,1)|(0,0,1)) = ((1,6,2)|(0,0,0))+((1,6,1)|(0,0,0))*AB(3)
        ! theta(1246) = theta(876)+theta(831)*AB(1) ! ((1,5,2)|(1,0,0)) = ((2,5,2)|(0,0,0))+((1,5,2)|(0,0,0))*AB(1)
        theta(1247) = theta(884)+theta(831)*AB(2) ! ((1,5,2)|(0,1,0)) = ((1,6,2)|(0,0,0))+((1,5,2)|(0,0,0))*AB(2)
        theta(1248) = theta(885)+theta(831)*AB(3) ! ((1,5,2)|(0,0,1)) = ((1,5,3)|(0,0,0))+((1,5,2)|(0,0,0))*AB(3)
        ! theta(1249) = theta(877)+theta(832)*AB(1) ! ((1,4,3)|(1,0,0)) = ((2,4,3)|(0,0,0))+((1,4,3)|(0,0,0))*AB(1)
        theta(1250) = theta(885)+theta(832)*AB(2) ! ((1,4,3)|(0,1,0)) = ((1,5,3)|(0,0,0))+((1,4,3)|(0,0,0))*AB(2)
        theta(1251) = theta(886)+theta(832)*AB(3) ! ((1,4,3)|(0,0,1)) = ((1,4,4)|(0,0,0))+((1,4,3)|(0,0,0))*AB(3)
        ! theta(1252) = theta(878)+theta(833)*AB(1) ! ((1,3,4)|(1,0,0)) = ((2,3,4)|(0,0,0))+((1,3,4)|(0,0,0))*AB(1)
        theta(1253) = theta(886)+theta(833)*AB(2) ! ((1,3,4)|(0,1,0)) = ((1,4,4)|(0,0,0))+((1,3,4)|(0,0,0))*AB(2)
        theta(1254) = theta(887)+theta(833)*AB(3) ! ((1,3,4)|(0,0,1)) = ((1,3,5)|(0,0,0))+((1,3,4)|(0,0,0))*AB(3)
        ! theta(1255) = theta(879)+theta(834)*AB(1) ! ((1,2,5)|(1,0,0)) = ((2,2,5)|(0,0,0))+((1,2,5)|(0,0,0))*AB(1)
        theta(1256) = theta(887)+theta(834)*AB(2) ! ((1,2,5)|(0,1,0)) = ((1,3,5)|(0,0,0))+((1,2,5)|(0,0,0))*AB(2)
        theta(1257) = theta(888)+theta(834)*AB(3) ! ((1,2,5)|(0,0,1)) = ((1,2,6)|(0,0,0))+((1,2,5)|(0,0,0))*AB(3)
        ! theta(1258) = theta(880)+theta(835)*AB(1) ! ((1,1,6)|(1,0,0)) = ((2,1,6)|(0,0,0))+((1,1,6)|(0,0,0))*AB(1)
        theta(1259) = theta(888)+theta(835)*AB(2) ! ((1,1,6)|(0,1,0)) = ((1,2,6)|(0,0,0))+((1,1,6)|(0,0,0))*AB(2)
        theta(1260) = theta(889)+theta(835)*AB(3) ! ((1,1,6)|(0,0,1)) = ((1,1,7)|(0,0,0))+((1,1,6)|(0,0,0))*AB(3)
        ! theta(1261) = theta(881)+theta(836)*AB(1) ! ((1,0,7)|(1,0,0)) = ((2,0,7)|(0,0,0))+((1,0,7)|(0,0,0))*AB(1)
        ! theta(1262) = theta(889)+theta(836)*AB(2) ! ((1,0,7)|(0,1,0)) = ((1,1,7)|(0,0,0))+((1,0,7)|(0,0,0))*AB(2)
        theta(1263) = theta(890)+theta(836)*AB(3) ! ((1,0,7)|(0,0,1)) = ((1,0,8)|(0,0,0))+((1,0,7)|(0,0,0))*AB(3)
        ! theta(1264) = theta(882)+theta(837)*AB(1) ! ((0,8,0)|(1,0,0)) = ((1,8,0)|(0,0,0))+((0,8,0)|(0,0,0))*AB(1)
        theta(1265) = theta(891)+theta(837)*AB(2) ! ((0,8,0)|(0,1,0)) = ((0,9,0)|(0,0,0))+((0,8,0)|(0,0,0))*AB(2)
        ! theta(1266) = theta(892)+theta(837)*AB(3) ! ((0,8,0)|(0,0,1)) = ((0,8,1)|(0,0,0))+((0,8,0)|(0,0,0))*AB(3)
        ! theta(1267) = theta(883)+theta(838)*AB(1) ! ((0,7,1)|(1,0,0)) = ((1,7,1)|(0,0,0))+((0,7,1)|(0,0,0))*AB(1)
        theta(1268) = theta(892)+theta(838)*AB(2) ! ((0,7,1)|(0,1,0)) = ((0,8,1)|(0,0,0))+((0,7,1)|(0,0,0))*AB(2)
        theta(1269) = theta(893)+theta(838)*AB(3) ! ((0,7,1)|(0,0,1)) = ((0,7,2)|(0,0,0))+((0,7,1)|(0,0,0))*AB(3)
        ! theta(1270) = theta(884)+theta(839)*AB(1) ! ((0,6,2)|(1,0,0)) = ((1,6,2)|(0,0,0))+((0,6,2)|(0,0,0))*AB(1)
        theta(1271) = theta(893)+theta(839)*AB(2) ! ((0,6,2)|(0,1,0)) = ((0,7,2)|(0,0,0))+((0,6,2)|(0,0,0))*AB(2)
        theta(1272) = theta(894)+theta(839)*AB(3) ! ((0,6,2)|(0,0,1)) = ((0,6,3)|(0,0,0))+((0,6,2)|(0,0,0))*AB(3)
        ! theta(1273) = theta(885)+theta(840)*AB(1) ! ((0,5,3)|(1,0,0)) = ((1,5,3)|(0,0,0))+((0,5,3)|(0,0,0))*AB(1)
        theta(1274) = theta(894)+theta(840)*AB(2) ! ((0,5,3)|(0,1,0)) = ((0,6,3)|(0,0,0))+((0,5,3)|(0,0,0))*AB(2)
        theta(1275) = theta(895)+theta(840)*AB(3) ! ((0,5,3)|(0,0,1)) = ((0,5,4)|(0,0,0))+((0,5,3)|(0,0,0))*AB(3)
        ! theta(1276) = theta(886)+theta(841)*AB(1) ! ((0,4,4)|(1,0,0)) = ((1,4,4)|(0,0,0))+((0,4,4)|(0,0,0))*AB(1)
        theta(1277) = theta(895)+theta(841)*AB(2) ! ((0,4,4)|(0,1,0)) = ((0,5,4)|(0,0,0))+((0,4,4)|(0,0,0))*AB(2)
        theta(1278) = theta(896)+theta(841)*AB(3) ! ((0,4,4)|(0,0,1)) = ((0,4,5)|(0,0,0))+((0,4,4)|(0,0,0))*AB(3)
        ! theta(1279) = theta(887)+theta(842)*AB(1) ! ((0,3,5)|(1,0,0)) = ((1,3,5)|(0,0,0))+((0,3,5)|(0,0,0))*AB(1)
        theta(1280) = theta(896)+theta(842)*AB(2) ! ((0,3,5)|(0,1,0)) = ((0,4,5)|(0,0,0))+((0,3,5)|(0,0,0))*AB(2)
        theta(1281) = theta(897)+theta(842)*AB(3) ! ((0,3,5)|(0,0,1)) = ((0,3,6)|(0,0,0))+((0,3,5)|(0,0,0))*AB(3)
        ! theta(1282) = theta(888)+theta(843)*AB(1) ! ((0,2,6)|(1,0,0)) = ((1,2,6)|(0,0,0))+((0,2,6)|(0,0,0))*AB(1)
        theta(1283) = theta(897)+theta(843)*AB(2) ! ((0,2,6)|(0,1,0)) = ((0,3,6)|(0,0,0))+((0,2,6)|(0,0,0))*AB(2)
        theta(1284) = theta(898)+theta(843)*AB(3) ! ((0,2,6)|(0,0,1)) = ((0,2,7)|(0,0,0))+((0,2,6)|(0,0,0))*AB(3)
        ! theta(1285) = theta(889)+theta(844)*AB(1) ! ((0,1,7)|(1,0,0)) = ((1,1,7)|(0,0,0))+((0,1,7)|(0,0,0))*AB(1)
        ! theta(1286) = theta(898)+theta(844)*AB(2) ! ((0,1,7)|(0,1,0)) = ((0,2,7)|(0,0,0))+((0,1,7)|(0,0,0))*AB(2)
        theta(1287) = theta(899)+theta(844)*AB(3) ! ((0,1,7)|(0,0,1)) = ((0,1,8)|(0,0,0))+((0,1,7)|(0,0,0))*AB(3)
        ! theta(1288) = theta(890)+theta(845)*AB(1) ! ((0,0,8)|(1,0,0)) = ((1,0,8)|(0,0,0))+((0,0,8)|(0,0,0))*AB(1)
        ! theta(1289) = theta(899)+theta(845)*AB(2) ! ((0,0,8)|(0,1,0)) = ((0,1,8)|(0,0,0))+((0,0,8)|(0,0,0))*AB(2)
        theta(1290) = theta(900)+theta(845)*AB(3) ! ((0,0,8)|(0,0,1)) = ((0,0,9)|(0,0,0))+((0,0,8)|(0,0,0))*AB(3)
        theta(1291) = theta(964)+theta(901)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        ! theta(1292) = theta(965)+theta(902)*AB(1) ! ((5,0,0)|(1,1,0)) = ((6,0,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(1)
        ! theta(1293) = theta(966)+theta(903)*AB(1) ! ((5,0,0)|(1,0,1)) = ((6,0,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(1)
        theta(1294) = theta(968)+theta(902)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        ! theta(1295) = theta(969)+theta(903)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        theta(1296) = theta(972)+theta(903)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(1297) = theta(967)+theta(904)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        ! theta(1298) = theta(968)+theta(905)*AB(1) ! ((4,1,0)|(1,1,0)) = ((5,1,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(1)
        ! theta(1299) = theta(969)+theta(906)*AB(1) ! ((4,1,0)|(1,0,1)) = ((5,1,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(1)
        theta(1300) = theta(974)+theta(905)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        ! theta(1301) = theta(975)+theta(906)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        theta(1302) = theta(978)+theta(906)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1303) = theta(970)+theta(907)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(1304) = theta(971)+theta(908)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        ! theta(1305) = theta(972)+theta(909)*AB(1) ! ((4,0,1)|(1,0,1)) = ((5,0,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(1)
        theta(1306) = theta(977)+theta(908)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1307) = theta(978)+theta(909)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(1308) = theta(981)+theta(909)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1309) = theta(973)+theta(910)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        ! theta(1310) = theta(974)+theta(911)*AB(1) ! ((3,2,0)|(1,1,0)) = ((4,2,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(1)
        ! theta(1311) = theta(975)+theta(912)*AB(1) ! ((3,2,0)|(1,0,1)) = ((4,2,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(1)
        theta(1312) = theta(983)+theta(911)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        ! theta(1313) = theta(984)+theta(912)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        theta(1314) = theta(987)+theta(912)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1315) = theta(976)+theta(913)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(1316) = theta(977)+theta(914)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        ! theta(1317) = theta(978)+theta(915)*AB(1) ! ((3,1,1)|(1,0,1)) = ((4,1,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(1)
        theta(1318) = theta(986)+theta(914)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1319) = theta(987)+theta(915)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(1320) = theta(990)+theta(915)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1321) = theta(979)+theta(916)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(1322) = theta(980)+theta(917)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        ! theta(1323) = theta(981)+theta(918)*AB(1) ! ((3,0,2)|(1,0,1)) = ((4,0,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(1)
        theta(1324) = theta(989)+theta(917)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1325) = theta(990)+theta(918)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(1326) = theta(993)+theta(918)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1327) = theta(982)+theta(919)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        ! theta(1328) = theta(983)+theta(920)*AB(1) ! ((2,3,0)|(1,1,0)) = ((3,3,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(1)
        ! theta(1329) = theta(984)+theta(921)*AB(1) ! ((2,3,0)|(1,0,1)) = ((3,3,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(1)
        theta(1330) = theta(995)+theta(920)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        ! theta(1331) = theta(996)+theta(921)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        theta(1332) = theta(999)+theta(921)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1333) = theta(985)+theta(922)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(1334) = theta(986)+theta(923)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        ! theta(1335) = theta(987)+theta(924)*AB(1) ! ((2,2,1)|(1,0,1)) = ((3,2,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(1)
        theta(1336) = theta(998)+theta(923)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1337) = theta(999)+theta(924)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(1338) = theta(1002)+theta(924)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1339) = theta(988)+theta(925)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(1340) = theta(989)+theta(926)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        ! theta(1341) = theta(990)+theta(927)*AB(1) ! ((2,1,2)|(1,0,1)) = ((3,1,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(1)
        theta(1342) = theta(1001)+theta(926)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1343) = theta(1002)+theta(927)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(1344) = theta(1005)+theta(927)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1345) = theta(991)+theta(928)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(1346) = theta(992)+theta(929)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        ! theta(1347) = theta(993)+theta(930)*AB(1) ! ((2,0,3)|(1,0,1)) = ((3,0,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(1)
        theta(1348) = theta(1004)+theta(929)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1349) = theta(1005)+theta(930)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(1350) = theta(1008)+theta(930)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1351) = theta(994)+theta(931)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        ! theta(1352) = theta(995)+theta(932)*AB(1) ! ((1,4,0)|(1,1,0)) = ((2,4,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(1)
        ! theta(1353) = theta(996)+theta(933)*AB(1) ! ((1,4,0)|(1,0,1)) = ((2,4,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(1)
        theta(1354) = theta(1010)+theta(932)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        ! theta(1355) = theta(1011)+theta(933)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        theta(1356) = theta(1014)+theta(933)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1357) = theta(997)+theta(934)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(1358) = theta(998)+theta(935)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        ! theta(1359) = theta(999)+theta(936)*AB(1) ! ((1,3,1)|(1,0,1)) = ((2,3,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(1)
        theta(1360) = theta(1013)+theta(935)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1361) = theta(1014)+theta(936)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(1362) = theta(1017)+theta(936)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1363) = theta(1000)+theta(937)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(1364) = theta(1001)+theta(938)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        ! theta(1365) = theta(1002)+theta(939)*AB(1) ! ((1,2,2)|(1,0,1)) = ((2,2,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(1)
        theta(1366) = theta(1016)+theta(938)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1367) = theta(1017)+theta(939)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(1368) = theta(1020)+theta(939)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1369) = theta(1003)+theta(940)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(1370) = theta(1004)+theta(941)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        ! theta(1371) = theta(1005)+theta(942)*AB(1) ! ((1,1,3)|(1,0,1)) = ((2,1,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(1)
        theta(1372) = theta(1019)+theta(941)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1373) = theta(1020)+theta(942)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(1374) = theta(1023)+theta(942)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1375) = theta(1006)+theta(943)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(1376) = theta(1007)+theta(944)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        ! theta(1377) = theta(1008)+theta(945)*AB(1) ! ((1,0,4)|(1,0,1)) = ((2,0,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(1)
        theta(1378) = theta(1022)+theta(944)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1379) = theta(1023)+theta(945)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(1380) = theta(1026)+theta(945)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1381) = theta(1009)+theta(946)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        ! theta(1382) = theta(1010)+theta(947)*AB(1) ! ((0,5,0)|(1,1,0)) = ((1,5,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(1)
        ! theta(1383) = theta(1011)+theta(948)*AB(1) ! ((0,5,0)|(1,0,1)) = ((1,5,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(1)
        theta(1384) = theta(1028)+theta(947)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        ! theta(1385) = theta(1029)+theta(948)*AB(2) ! ((0,5,0)|(0,1,1)) = ((0,6,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(2)
        theta(1386) = theta(1032)+theta(948)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(1387) = theta(1012)+theta(949)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        theta(1388) = theta(1013)+theta(950)*AB(1) ! ((0,4,1)|(1,1,0)) = ((1,4,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(1)
        ! theta(1389) = theta(1014)+theta(951)*AB(1) ! ((0,4,1)|(1,0,1)) = ((1,4,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(1)
        theta(1390) = theta(1031)+theta(950)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(1391) = theta(1032)+theta(951)*AB(2) ! ((0,4,1)|(0,1,1)) = ((0,5,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(2)
        theta(1392) = theta(1035)+theta(951)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1393) = theta(1015)+theta(952)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        theta(1394) = theta(1016)+theta(953)*AB(1) ! ((0,3,2)|(1,1,0)) = ((1,3,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(1)
        ! theta(1395) = theta(1017)+theta(954)*AB(1) ! ((0,3,2)|(1,0,1)) = ((1,3,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(1)
        theta(1396) = theta(1034)+theta(953)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(1397) = theta(1035)+theta(954)*AB(2) ! ((0,3,2)|(0,1,1)) = ((0,4,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(2)
        theta(1398) = theta(1038)+theta(954)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1399) = theta(1018)+theta(955)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        theta(1400) = theta(1019)+theta(956)*AB(1) ! ((0,2,3)|(1,1,0)) = ((1,2,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(1)
        ! theta(1401) = theta(1020)+theta(957)*AB(1) ! ((0,2,3)|(1,0,1)) = ((1,2,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(1)
        theta(1402) = theta(1037)+theta(956)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(1403) = theta(1038)+theta(957)*AB(2) ! ((0,2,3)|(0,1,1)) = ((0,3,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(2)
        theta(1404) = theta(1041)+theta(957)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1405) = theta(1021)+theta(958)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        theta(1406) = theta(1022)+theta(959)*AB(1) ! ((0,1,4)|(1,1,0)) = ((1,1,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(1)
        ! theta(1407) = theta(1023)+theta(960)*AB(1) ! ((0,1,4)|(1,0,1)) = ((1,1,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(1)
        theta(1408) = theta(1040)+theta(959)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(1409) = theta(1041)+theta(960)*AB(2) ! ((0,1,4)|(0,1,1)) = ((0,2,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(2)
        theta(1410) = theta(1044)+theta(960)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1411) = theta(1024)+theta(961)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        theta(1412) = theta(1025)+theta(962)*AB(1) ! ((0,0,5)|(1,1,0)) = ((1,0,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(1)
        ! theta(1413) = theta(1026)+theta(963)*AB(1) ! ((0,0,5)|(1,0,1)) = ((1,0,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(1)
        theta(1414) = theta(1043)+theta(962)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        theta(1415) = theta(1044)+theta(963)*AB(2) ! ((0,0,5)|(0,1,1)) = ((0,1,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(2)
        theta(1416) = theta(1047)+theta(963)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(1417) = theta(1048)+theta(964)*AB(1) ! ((6,0,0)|(2,0,0)) = ((7,0,0)|(1,0,0))+((6,0,0)|(1,0,0))*AB(1)
        ! theta(1418) = theta(1049)+theta(965)*AB(1) ! ((6,0,0)|(1,1,0)) = ((7,0,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(1)
        ! theta(1419) = theta(1050)+theta(966)*AB(1) ! ((6,0,0)|(1,0,1)) = ((7,0,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(1)
        theta(1420) = theta(1052)+theta(965)*AB(2) ! ((6,0,0)|(0,2,0)) = ((6,1,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(2)
        ! theta(1421) = theta(1053)+theta(966)*AB(2) ! ((6,0,0)|(0,1,1)) = ((6,1,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(2)
        theta(1422) = theta(1056)+theta(966)*AB(3) ! ((6,0,0)|(0,0,2)) = ((6,0,1)|(0,0,1))+((6,0,0)|(0,0,1))*AB(3)
        theta(1423) = theta(1051)+theta(967)*AB(1) ! ((5,1,0)|(2,0,0)) = ((6,1,0)|(1,0,0))+((5,1,0)|(1,0,0))*AB(1)
        ! theta(1424) = theta(1052)+theta(968)*AB(1) ! ((5,1,0)|(1,1,0)) = ((6,1,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(1)
        ! theta(1425) = theta(1053)+theta(969)*AB(1) ! ((5,1,0)|(1,0,1)) = ((6,1,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(1)
        theta(1426) = theta(1058)+theta(968)*AB(2) ! ((5,1,0)|(0,2,0)) = ((5,2,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(2)
        ! theta(1427) = theta(1059)+theta(969)*AB(2) ! ((5,1,0)|(0,1,1)) = ((5,2,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(2)
        theta(1428) = theta(1062)+theta(969)*AB(3) ! ((5,1,0)|(0,0,2)) = ((5,1,1)|(0,0,1))+((5,1,0)|(0,0,1))*AB(3)
        theta(1429) = theta(1054)+theta(970)*AB(1) ! ((5,0,1)|(2,0,0)) = ((6,0,1)|(1,0,0))+((5,0,1)|(1,0,0))*AB(1)
        theta(1430) = theta(1055)+theta(971)*AB(1) ! ((5,0,1)|(1,1,0)) = ((6,0,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(1)
        ! theta(1431) = theta(1056)+theta(972)*AB(1) ! ((5,0,1)|(1,0,1)) = ((6,0,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(1)
        theta(1432) = theta(1061)+theta(971)*AB(2) ! ((5,0,1)|(0,2,0)) = ((5,1,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(2)
        theta(1433) = theta(1062)+theta(972)*AB(2) ! ((5,0,1)|(0,1,1)) = ((5,1,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(2)
        theta(1434) = theta(1065)+theta(972)*AB(3) ! ((5,0,1)|(0,0,2)) = ((5,0,2)|(0,0,1))+((5,0,1)|(0,0,1))*AB(3)
        theta(1435) = theta(1057)+theta(973)*AB(1) ! ((4,2,0)|(2,0,0)) = ((5,2,0)|(1,0,0))+((4,2,0)|(1,0,0))*AB(1)
        ! theta(1436) = theta(1058)+theta(974)*AB(1) ! ((4,2,0)|(1,1,0)) = ((5,2,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(1)
        ! theta(1437) = theta(1059)+theta(975)*AB(1) ! ((4,2,0)|(1,0,1)) = ((5,2,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(1)
        theta(1438) = theta(1067)+theta(974)*AB(2) ! ((4,2,0)|(0,2,0)) = ((4,3,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(2)
        ! theta(1439) = theta(1068)+theta(975)*AB(2) ! ((4,2,0)|(0,1,1)) = ((4,3,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(2)
        theta(1440) = theta(1071)+theta(975)*AB(3) ! ((4,2,0)|(0,0,2)) = ((4,2,1)|(0,0,1))+((4,2,0)|(0,0,1))*AB(3)
        theta(1441) = theta(1060)+theta(976)*AB(1) ! ((4,1,1)|(2,0,0)) = ((5,1,1)|(1,0,0))+((4,1,1)|(1,0,0))*AB(1)
        theta(1442) = theta(1061)+theta(977)*AB(1) ! ((4,1,1)|(1,1,0)) = ((5,1,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(1)
        ! theta(1443) = theta(1062)+theta(978)*AB(1) ! ((4,1,1)|(1,0,1)) = ((5,1,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(1)
        theta(1444) = theta(1070)+theta(977)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1445) = theta(1071)+theta(978)*AB(2) ! ((4,1,1)|(0,1,1)) = ((4,2,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(2)
        theta(1446) = theta(1074)+theta(978)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1447) = theta(1063)+theta(979)*AB(1) ! ((4,0,2)|(2,0,0)) = ((5,0,2)|(1,0,0))+((4,0,2)|(1,0,0))*AB(1)
        theta(1448) = theta(1064)+theta(980)*AB(1) ! ((4,0,2)|(1,1,0)) = ((5,0,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(1)
        ! theta(1449) = theta(1065)+theta(981)*AB(1) ! ((4,0,2)|(1,0,1)) = ((5,0,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(1)
        theta(1450) = theta(1073)+theta(980)*AB(2) ! ((4,0,2)|(0,2,0)) = ((4,1,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(2)
        theta(1451) = theta(1074)+theta(981)*AB(2) ! ((4,0,2)|(0,1,1)) = ((4,1,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(2)
        theta(1452) = theta(1077)+theta(981)*AB(3) ! ((4,0,2)|(0,0,2)) = ((4,0,3)|(0,0,1))+((4,0,2)|(0,0,1))*AB(3)
        theta(1453) = theta(1066)+theta(982)*AB(1) ! ((3,3,0)|(2,0,0)) = ((4,3,0)|(1,0,0))+((3,3,0)|(1,0,0))*AB(1)
        ! theta(1454) = theta(1067)+theta(983)*AB(1) ! ((3,3,0)|(1,1,0)) = ((4,3,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(1)
        ! theta(1455) = theta(1068)+theta(984)*AB(1) ! ((3,3,0)|(1,0,1)) = ((4,3,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(1)
        theta(1456) = theta(1079)+theta(983)*AB(2) ! ((3,3,0)|(0,2,0)) = ((3,4,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(2)
        ! theta(1457) = theta(1080)+theta(984)*AB(2) ! ((3,3,0)|(0,1,1)) = ((3,4,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(2)
        theta(1458) = theta(1083)+theta(984)*AB(3) ! ((3,3,0)|(0,0,2)) = ((3,3,1)|(0,0,1))+((3,3,0)|(0,0,1))*AB(3)
        theta(1459) = theta(1069)+theta(985)*AB(1) ! ((3,2,1)|(2,0,0)) = ((4,2,1)|(1,0,0))+((3,2,1)|(1,0,0))*AB(1)
        theta(1460) = theta(1070)+theta(986)*AB(1) ! ((3,2,1)|(1,1,0)) = ((4,2,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(1)
        ! theta(1461) = theta(1071)+theta(987)*AB(1) ! ((3,2,1)|(1,0,1)) = ((4,2,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(1)
        theta(1462) = theta(1082)+theta(986)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1463) = theta(1083)+theta(987)*AB(2) ! ((3,2,1)|(0,1,1)) = ((3,3,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(2)
        theta(1464) = theta(1086)+theta(987)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1465) = theta(1072)+theta(988)*AB(1) ! ((3,1,2)|(2,0,0)) = ((4,1,2)|(1,0,0))+((3,1,2)|(1,0,0))*AB(1)
        theta(1466) = theta(1073)+theta(989)*AB(1) ! ((3,1,2)|(1,1,0)) = ((4,1,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(1)
        ! theta(1467) = theta(1074)+theta(990)*AB(1) ! ((3,1,2)|(1,0,1)) = ((4,1,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(1)
        theta(1468) = theta(1085)+theta(989)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1469) = theta(1086)+theta(990)*AB(2) ! ((3,1,2)|(0,1,1)) = ((3,2,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(2)
        theta(1470) = theta(1089)+theta(990)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1471) = theta(1075)+theta(991)*AB(1) ! ((3,0,3)|(2,0,0)) = ((4,0,3)|(1,0,0))+((3,0,3)|(1,0,0))*AB(1)
        theta(1472) = theta(1076)+theta(992)*AB(1) ! ((3,0,3)|(1,1,0)) = ((4,0,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(1)
        ! theta(1473) = theta(1077)+theta(993)*AB(1) ! ((3,0,3)|(1,0,1)) = ((4,0,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(1)
        theta(1474) = theta(1088)+theta(992)*AB(2) ! ((3,0,3)|(0,2,0)) = ((3,1,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(2)
        theta(1475) = theta(1089)+theta(993)*AB(2) ! ((3,0,3)|(0,1,1)) = ((3,1,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(2)
        theta(1476) = theta(1092)+theta(993)*AB(3) ! ((3,0,3)|(0,0,2)) = ((3,0,4)|(0,0,1))+((3,0,3)|(0,0,1))*AB(3)
        theta(1477) = theta(1078)+theta(994)*AB(1) ! ((2,4,0)|(2,0,0)) = ((3,4,0)|(1,0,0))+((2,4,0)|(1,0,0))*AB(1)
        ! theta(1478) = theta(1079)+theta(995)*AB(1) ! ((2,4,0)|(1,1,0)) = ((3,4,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(1)
        ! theta(1479) = theta(1080)+theta(996)*AB(1) ! ((2,4,0)|(1,0,1)) = ((3,4,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(1)
        theta(1480) = theta(1094)+theta(995)*AB(2) ! ((2,4,0)|(0,2,0)) = ((2,5,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(2)
        ! theta(1481) = theta(1095)+theta(996)*AB(2) ! ((2,4,0)|(0,1,1)) = ((2,5,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(2)
        theta(1482) = theta(1098)+theta(996)*AB(3) ! ((2,4,0)|(0,0,2)) = ((2,4,1)|(0,0,1))+((2,4,0)|(0,0,1))*AB(3)
        theta(1483) = theta(1081)+theta(997)*AB(1) ! ((2,3,1)|(2,0,0)) = ((3,3,1)|(1,0,0))+((2,3,1)|(1,0,0))*AB(1)
        theta(1484) = theta(1082)+theta(998)*AB(1) ! ((2,3,1)|(1,1,0)) = ((3,3,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(1)
        ! theta(1485) = theta(1083)+theta(999)*AB(1) ! ((2,3,1)|(1,0,1)) = ((3,3,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(1)
        theta(1486) = theta(1097)+theta(998)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(1487) = theta(1098)+theta(999)*AB(2) ! ((2,3,1)|(0,1,1)) = ((2,4,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(2)
        theta(1488) = theta(1101)+theta(999)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(1489) = theta(1084)+theta(1000)*AB(1) ! ((2,2,2)|(2,0,0)) = ((3,2,2)|(1,0,0))+((2,2,2)|(1,0,0))*AB(1)
        theta(1490) = theta(1085)+theta(1001)*AB(1) ! ((2,2,2)|(1,1,0)) = ((3,2,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(1)
        ! theta(1491) = theta(1086)+theta(1002)*AB(1) ! ((2,2,2)|(1,0,1)) = ((3,2,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(1)
        theta(1492) = theta(1100)+theta(1001)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(1493) = theta(1101)+theta(1002)*AB(2) ! ((2,2,2)|(0,1,1)) = ((2,3,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(2)
        theta(1494) = theta(1104)+theta(1002)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(1495) = theta(1087)+theta(1003)*AB(1) ! ((2,1,3)|(2,0,0)) = ((3,1,3)|(1,0,0))+((2,1,3)|(1,0,0))*AB(1)
        theta(1496) = theta(1088)+theta(1004)*AB(1) ! ((2,1,3)|(1,1,0)) = ((3,1,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(1)
        ! theta(1497) = theta(1089)+theta(1005)*AB(1) ! ((2,1,3)|(1,0,1)) = ((3,1,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(1)
        theta(1498) = theta(1103)+theta(1004)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(1499) = theta(1104)+theta(1005)*AB(2) ! ((2,1,3)|(0,1,1)) = ((2,2,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(2)
        theta(1500) = theta(1107)+theta(1005)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(1501) = theta(1090)+theta(1006)*AB(1) ! ((2,0,4)|(2,0,0)) = ((3,0,4)|(1,0,0))+((2,0,4)|(1,0,0))*AB(1)
        theta(1502) = theta(1091)+theta(1007)*AB(1) ! ((2,0,4)|(1,1,0)) = ((3,0,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(1)
        ! theta(1503) = theta(1092)+theta(1008)*AB(1) ! ((2,0,4)|(1,0,1)) = ((3,0,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(1)
        theta(1504) = theta(1106)+theta(1007)*AB(2) ! ((2,0,4)|(0,2,0)) = ((2,1,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(2)
        theta(1505) = theta(1107)+theta(1008)*AB(2) ! ((2,0,4)|(0,1,1)) = ((2,1,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(2)
        theta(1506) = theta(1110)+theta(1008)*AB(3) ! ((2,0,4)|(0,0,2)) = ((2,0,5)|(0,0,1))+((2,0,4)|(0,0,1))*AB(3)
        theta(1507) = theta(1093)+theta(1009)*AB(1) ! ((1,5,0)|(2,0,0)) = ((2,5,0)|(1,0,0))+((1,5,0)|(1,0,0))*AB(1)
        ! theta(1508) = theta(1094)+theta(1010)*AB(1) ! ((1,5,0)|(1,1,0)) = ((2,5,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(1)
        ! theta(1509) = theta(1095)+theta(1011)*AB(1) ! ((1,5,0)|(1,0,1)) = ((2,5,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(1)
        theta(1510) = theta(1112)+theta(1010)*AB(2) ! ((1,5,0)|(0,2,0)) = ((1,6,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(2)
        ! theta(1511) = theta(1113)+theta(1011)*AB(2) ! ((1,5,0)|(0,1,1)) = ((1,6,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(2)
        theta(1512) = theta(1116)+theta(1011)*AB(3) ! ((1,5,0)|(0,0,2)) = ((1,5,1)|(0,0,1))+((1,5,0)|(0,0,1))*AB(3)
        theta(1513) = theta(1096)+theta(1012)*AB(1) ! ((1,4,1)|(2,0,0)) = ((2,4,1)|(1,0,0))+((1,4,1)|(1,0,0))*AB(1)
        theta(1514) = theta(1097)+theta(1013)*AB(1) ! ((1,4,1)|(1,1,0)) = ((2,4,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(1)
        ! theta(1515) = theta(1098)+theta(1014)*AB(1) ! ((1,4,1)|(1,0,1)) = ((2,4,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(1)
        theta(1516) = theta(1115)+theta(1013)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        theta(1517) = theta(1116)+theta(1014)*AB(2) ! ((1,4,1)|(0,1,1)) = ((1,5,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(2)
        theta(1518) = theta(1119)+theta(1014)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(1519) = theta(1099)+theta(1015)*AB(1) ! ((1,3,2)|(2,0,0)) = ((2,3,2)|(1,0,0))+((1,3,2)|(1,0,0))*AB(1)
        theta(1520) = theta(1100)+theta(1016)*AB(1) ! ((1,3,2)|(1,1,0)) = ((2,3,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(1)
        ! theta(1521) = theta(1101)+theta(1017)*AB(1) ! ((1,3,2)|(1,0,1)) = ((2,3,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(1)
        theta(1522) = theta(1118)+theta(1016)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        theta(1523) = theta(1119)+theta(1017)*AB(2) ! ((1,3,2)|(0,1,1)) = ((1,4,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(2)
        theta(1524) = theta(1122)+theta(1017)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(1525) = theta(1102)+theta(1018)*AB(1) ! ((1,2,3)|(2,0,0)) = ((2,2,3)|(1,0,0))+((1,2,3)|(1,0,0))*AB(1)
        theta(1526) = theta(1103)+theta(1019)*AB(1) ! ((1,2,3)|(1,1,0)) = ((2,2,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(1)
        ! theta(1527) = theta(1104)+theta(1020)*AB(1) ! ((1,2,3)|(1,0,1)) = ((2,2,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(1)
        theta(1528) = theta(1121)+theta(1019)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        theta(1529) = theta(1122)+theta(1020)*AB(2) ! ((1,2,3)|(0,1,1)) = ((1,3,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(2)
        theta(1530) = theta(1125)+theta(1020)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(1531) = theta(1105)+theta(1021)*AB(1) ! ((1,1,4)|(2,0,0)) = ((2,1,4)|(1,0,0))+((1,1,4)|(1,0,0))*AB(1)
        theta(1532) = theta(1106)+theta(1022)*AB(1) ! ((1,1,4)|(1,1,0)) = ((2,1,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(1)
        ! theta(1533) = theta(1107)+theta(1023)*AB(1) ! ((1,1,4)|(1,0,1)) = ((2,1,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(1)
        theta(1534) = theta(1124)+theta(1022)*AB(2) ! ((1,1,4)|(0,2,0)) = ((1,2,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(2)
        theta(1535) = theta(1125)+theta(1023)*AB(2) ! ((1,1,4)|(0,1,1)) = ((1,2,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(2)
        theta(1536) = theta(1128)+theta(1023)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(1537) = theta(1108)+theta(1024)*AB(1) ! ((1,0,5)|(2,0,0)) = ((2,0,5)|(1,0,0))+((1,0,5)|(1,0,0))*AB(1)
        theta(1538) = theta(1109)+theta(1025)*AB(1) ! ((1,0,5)|(1,1,0)) = ((2,0,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(1)
        ! theta(1539) = theta(1110)+theta(1026)*AB(1) ! ((1,0,5)|(1,0,1)) = ((2,0,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(1)
        theta(1540) = theta(1127)+theta(1025)*AB(2) ! ((1,0,5)|(0,2,0)) = ((1,1,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(2)
        theta(1541) = theta(1128)+theta(1026)*AB(2) ! ((1,0,5)|(0,1,1)) = ((1,1,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(2)
        theta(1542) = theta(1131)+theta(1026)*AB(3) ! ((1,0,5)|(0,0,2)) = ((1,0,6)|(0,0,1))+((1,0,5)|(0,0,1))*AB(3)
        theta(1543) = theta(1111)+theta(1027)*AB(1) ! ((0,6,0)|(2,0,0)) = ((1,6,0)|(1,0,0))+((0,6,0)|(1,0,0))*AB(1)
        ! theta(1544) = theta(1112)+theta(1028)*AB(1) ! ((0,6,0)|(1,1,0)) = ((1,6,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(1)
        ! theta(1545) = theta(1113)+theta(1029)*AB(1) ! ((0,6,0)|(1,0,1)) = ((1,6,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(1)
        theta(1546) = theta(1133)+theta(1028)*AB(2) ! ((0,6,0)|(0,2,0)) = ((0,7,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(2)
        ! theta(1547) = theta(1134)+theta(1029)*AB(2) ! ((0,6,0)|(0,1,1)) = ((0,7,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(2)
        theta(1548) = theta(1137)+theta(1029)*AB(3) ! ((0,6,0)|(0,0,2)) = ((0,6,1)|(0,0,1))+((0,6,0)|(0,0,1))*AB(3)
        theta(1549) = theta(1114)+theta(1030)*AB(1) ! ((0,5,1)|(2,0,0)) = ((1,5,1)|(1,0,0))+((0,5,1)|(1,0,0))*AB(1)
        ! theta(1550) = theta(1115)+theta(1031)*AB(1) ! ((0,5,1)|(1,1,0)) = ((1,5,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(1)
        ! theta(1551) = theta(1116)+theta(1032)*AB(1) ! ((0,5,1)|(1,0,1)) = ((1,5,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(1)
        theta(1552) = theta(1136)+theta(1031)*AB(2) ! ((0,5,1)|(0,2,0)) = ((0,6,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(2)
        ! theta(1553) = theta(1137)+theta(1032)*AB(2) ! ((0,5,1)|(0,1,1)) = ((0,6,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(2)
        theta(1554) = theta(1140)+theta(1032)*AB(3) ! ((0,5,1)|(0,0,2)) = ((0,5,2)|(0,0,1))+((0,5,1)|(0,0,1))*AB(3)
        theta(1555) = theta(1117)+theta(1033)*AB(1) ! ((0,4,2)|(2,0,0)) = ((1,4,2)|(1,0,0))+((0,4,2)|(1,0,0))*AB(1)
        ! theta(1556) = theta(1118)+theta(1034)*AB(1) ! ((0,4,2)|(1,1,0)) = ((1,4,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(1)
        ! theta(1557) = theta(1119)+theta(1035)*AB(1) ! ((0,4,2)|(1,0,1)) = ((1,4,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(1)
        theta(1558) = theta(1139)+theta(1034)*AB(2) ! ((0,4,2)|(0,2,0)) = ((0,5,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(2)
        ! theta(1559) = theta(1140)+theta(1035)*AB(2) ! ((0,4,2)|(0,1,1)) = ((0,5,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(2)
        theta(1560) = theta(1143)+theta(1035)*AB(3) ! ((0,4,2)|(0,0,2)) = ((0,4,3)|(0,0,1))+((0,4,2)|(0,0,1))*AB(3)
        theta(1561) = theta(1120)+theta(1036)*AB(1) ! ((0,3,3)|(2,0,0)) = ((1,3,3)|(1,0,0))+((0,3,3)|(1,0,0))*AB(1)
        ! theta(1562) = theta(1121)+theta(1037)*AB(1) ! ((0,3,3)|(1,1,0)) = ((1,3,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(1)
        ! theta(1563) = theta(1122)+theta(1038)*AB(1) ! ((0,3,3)|(1,0,1)) = ((1,3,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(1)
        theta(1564) = theta(1142)+theta(1037)*AB(2) ! ((0,3,3)|(0,2,0)) = ((0,4,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(2)
        ! theta(1565) = theta(1143)+theta(1038)*AB(2) ! ((0,3,3)|(0,1,1)) = ((0,4,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(2)
        theta(1566) = theta(1146)+theta(1038)*AB(3) ! ((0,3,3)|(0,0,2)) = ((0,3,4)|(0,0,1))+((0,3,3)|(0,0,1))*AB(3)
        theta(1567) = theta(1123)+theta(1039)*AB(1) ! ((0,2,4)|(2,0,0)) = ((1,2,4)|(1,0,0))+((0,2,4)|(1,0,0))*AB(1)
        ! theta(1568) = theta(1124)+theta(1040)*AB(1) ! ((0,2,4)|(1,1,0)) = ((1,2,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(1)
        ! theta(1569) = theta(1125)+theta(1041)*AB(1) ! ((0,2,4)|(1,0,1)) = ((1,2,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(1)
        theta(1570) = theta(1145)+theta(1040)*AB(2) ! ((0,2,4)|(0,2,0)) = ((0,3,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(2)
        ! theta(1571) = theta(1146)+theta(1041)*AB(2) ! ((0,2,4)|(0,1,1)) = ((0,3,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(2)
        theta(1572) = theta(1149)+theta(1041)*AB(3) ! ((0,2,4)|(0,0,2)) = ((0,2,5)|(0,0,1))+((0,2,4)|(0,0,1))*AB(3)
        theta(1573) = theta(1126)+theta(1042)*AB(1) ! ((0,1,5)|(2,0,0)) = ((1,1,5)|(1,0,0))+((0,1,5)|(1,0,0))*AB(1)
        ! theta(1574) = theta(1127)+theta(1043)*AB(1) ! ((0,1,5)|(1,1,0)) = ((1,1,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(1)
        ! theta(1575) = theta(1128)+theta(1044)*AB(1) ! ((0,1,5)|(1,0,1)) = ((1,1,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(1)
        theta(1576) = theta(1148)+theta(1043)*AB(2) ! ((0,1,5)|(0,2,0)) = ((0,2,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(2)
        ! theta(1577) = theta(1149)+theta(1044)*AB(2) ! ((0,1,5)|(0,1,1)) = ((0,2,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(2)
        theta(1578) = theta(1152)+theta(1044)*AB(3) ! ((0,1,5)|(0,0,2)) = ((0,1,6)|(0,0,1))+((0,1,5)|(0,0,1))*AB(3)
        theta(1579) = theta(1129)+theta(1045)*AB(1) ! ((0,0,6)|(2,0,0)) = ((1,0,6)|(1,0,0))+((0,0,6)|(1,0,0))*AB(1)
        ! theta(1580) = theta(1130)+theta(1046)*AB(1) ! ((0,0,6)|(1,1,0)) = ((1,0,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(1)
        ! theta(1581) = theta(1131)+theta(1047)*AB(1) ! ((0,0,6)|(1,0,1)) = ((1,0,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(1)
        theta(1582) = theta(1151)+theta(1046)*AB(2) ! ((0,0,6)|(0,2,0)) = ((0,1,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(2)
        ! theta(1583) = theta(1152)+theta(1047)*AB(2) ! ((0,0,6)|(0,1,1)) = ((0,1,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(2)
        theta(1584) = theta(1155)+theta(1047)*AB(3) ! ((0,0,6)|(0,0,2)) = ((0,0,7)|(0,0,1))+((0,0,6)|(0,0,1))*AB(3)
        theta(1585) = theta(1156)+theta(1048)*AB(1) ! ((7,0,0)|(2,0,0)) = ((8,0,0)|(1,0,0))+((7,0,0)|(1,0,0))*AB(1)
        ! theta(1586) = theta(1157)+theta(1049)*AB(1) ! ((7,0,0)|(1,1,0)) = ((8,0,0)|(0,1,0))+((7,0,0)|(0,1,0))*AB(1)
        ! theta(1587) = theta(1158)+theta(1050)*AB(1) ! ((7,0,0)|(1,0,1)) = ((8,0,0)|(0,0,1))+((7,0,0)|(0,0,1))*AB(1)
        theta(1588) = theta(1160)+theta(1049)*AB(2) ! ((7,0,0)|(0,2,0)) = ((7,1,0)|(0,1,0))+((7,0,0)|(0,1,0))*AB(2)
        ! theta(1589) = theta(1161)+theta(1050)*AB(2) ! ((7,0,0)|(0,1,1)) = ((7,1,0)|(0,0,1))+((7,0,0)|(0,0,1))*AB(2)
        theta(1590) = theta(1164)+theta(1050)*AB(3) ! ((7,0,0)|(0,0,2)) = ((7,0,1)|(0,0,1))+((7,0,0)|(0,0,1))*AB(3)
        theta(1591) = theta(1159)+theta(1051)*AB(1) ! ((6,1,0)|(2,0,0)) = ((7,1,0)|(1,0,0))+((6,1,0)|(1,0,0))*AB(1)
        ! theta(1592) = theta(1160)+theta(1052)*AB(1) ! ((6,1,0)|(1,1,0)) = ((7,1,0)|(0,1,0))+((6,1,0)|(0,1,0))*AB(1)
        ! theta(1593) = theta(1161)+theta(1053)*AB(1) ! ((6,1,0)|(1,0,1)) = ((7,1,0)|(0,0,1))+((6,1,0)|(0,0,1))*AB(1)
        theta(1594) = theta(1166)+theta(1052)*AB(2) ! ((6,1,0)|(0,2,0)) = ((6,2,0)|(0,1,0))+((6,1,0)|(0,1,0))*AB(2)
        ! theta(1595) = theta(1167)+theta(1053)*AB(2) ! ((6,1,0)|(0,1,1)) = ((6,2,0)|(0,0,1))+((6,1,0)|(0,0,1))*AB(2)
        theta(1596) = theta(1170)+theta(1053)*AB(3) ! ((6,1,0)|(0,0,2)) = ((6,1,1)|(0,0,1))+((6,1,0)|(0,0,1))*AB(3)
        theta(1597) = theta(1162)+theta(1054)*AB(1) ! ((6,0,1)|(2,0,0)) = ((7,0,1)|(1,0,0))+((6,0,1)|(1,0,0))*AB(1)
        theta(1598) = theta(1163)+theta(1055)*AB(1) ! ((6,0,1)|(1,1,0)) = ((7,0,1)|(0,1,0))+((6,0,1)|(0,1,0))*AB(1)
        ! theta(1599) = theta(1164)+theta(1056)*AB(1) ! ((6,0,1)|(1,0,1)) = ((7,0,1)|(0,0,1))+((6,0,1)|(0,0,1))*AB(1)
        theta(1600) = theta(1169)+theta(1055)*AB(2) ! ((6,0,1)|(0,2,0)) = ((6,1,1)|(0,1,0))+((6,0,1)|(0,1,0))*AB(2)
        theta(1601) = theta(1170)+theta(1056)*AB(2) ! ((6,0,1)|(0,1,1)) = ((6,1,1)|(0,0,1))+((6,0,1)|(0,0,1))*AB(2)
        theta(1602) = theta(1173)+theta(1056)*AB(3) ! ((6,0,1)|(0,0,2)) = ((6,0,2)|(0,0,1))+((6,0,1)|(0,0,1))*AB(3)
        theta(1603) = theta(1165)+theta(1057)*AB(1) ! ((5,2,0)|(2,0,0)) = ((6,2,0)|(1,0,0))+((5,2,0)|(1,0,0))*AB(1)
        ! theta(1604) = theta(1166)+theta(1058)*AB(1) ! ((5,2,0)|(1,1,0)) = ((6,2,0)|(0,1,0))+((5,2,0)|(0,1,0))*AB(1)
        ! theta(1605) = theta(1167)+theta(1059)*AB(1) ! ((5,2,0)|(1,0,1)) = ((6,2,0)|(0,0,1))+((5,2,0)|(0,0,1))*AB(1)
        theta(1606) = theta(1175)+theta(1058)*AB(2) ! ((5,2,0)|(0,2,0)) = ((5,3,0)|(0,1,0))+((5,2,0)|(0,1,0))*AB(2)
        ! theta(1607) = theta(1176)+theta(1059)*AB(2) ! ((5,2,0)|(0,1,1)) = ((5,3,0)|(0,0,1))+((5,2,0)|(0,0,1))*AB(2)
        theta(1608) = theta(1179)+theta(1059)*AB(3) ! ((5,2,0)|(0,0,2)) = ((5,2,1)|(0,0,1))+((5,2,0)|(0,0,1))*AB(3)
        theta(1609) = theta(1168)+theta(1060)*AB(1) ! ((5,1,1)|(2,0,0)) = ((6,1,1)|(1,0,0))+((5,1,1)|(1,0,0))*AB(1)
        theta(1610) = theta(1169)+theta(1061)*AB(1) ! ((5,1,1)|(1,1,0)) = ((6,1,1)|(0,1,0))+((5,1,1)|(0,1,0))*AB(1)
        ! theta(1611) = theta(1170)+theta(1062)*AB(1) ! ((5,1,1)|(1,0,1)) = ((6,1,1)|(0,0,1))+((5,1,1)|(0,0,1))*AB(1)
        theta(1612) = theta(1178)+theta(1061)*AB(2) ! ((5,1,1)|(0,2,0)) = ((5,2,1)|(0,1,0))+((5,1,1)|(0,1,0))*AB(2)
        theta(1613) = theta(1179)+theta(1062)*AB(2) ! ((5,1,1)|(0,1,1)) = ((5,2,1)|(0,0,1))+((5,1,1)|(0,0,1))*AB(2)
        theta(1614) = theta(1182)+theta(1062)*AB(3) ! ((5,1,1)|(0,0,2)) = ((5,1,2)|(0,0,1))+((5,1,1)|(0,0,1))*AB(3)
        theta(1615) = theta(1171)+theta(1063)*AB(1) ! ((5,0,2)|(2,0,0)) = ((6,0,2)|(1,0,0))+((5,0,2)|(1,0,0))*AB(1)
        theta(1616) = theta(1172)+theta(1064)*AB(1) ! ((5,0,2)|(1,1,0)) = ((6,0,2)|(0,1,0))+((5,0,2)|(0,1,0))*AB(1)
        ! theta(1617) = theta(1173)+theta(1065)*AB(1) ! ((5,0,2)|(1,0,1)) = ((6,0,2)|(0,0,1))+((5,0,2)|(0,0,1))*AB(1)
        theta(1618) = theta(1181)+theta(1064)*AB(2) ! ((5,0,2)|(0,2,0)) = ((5,1,2)|(0,1,0))+((5,0,2)|(0,1,0))*AB(2)
        theta(1619) = theta(1182)+theta(1065)*AB(2) ! ((5,0,2)|(0,1,1)) = ((5,1,2)|(0,0,1))+((5,0,2)|(0,0,1))*AB(2)
        theta(1620) = theta(1185)+theta(1065)*AB(3) ! ((5,0,2)|(0,0,2)) = ((5,0,3)|(0,0,1))+((5,0,2)|(0,0,1))*AB(3)
        theta(1621) = theta(1174)+theta(1066)*AB(1) ! ((4,3,0)|(2,0,0)) = ((5,3,0)|(1,0,0))+((4,3,0)|(1,0,0))*AB(1)
        ! theta(1622) = theta(1175)+theta(1067)*AB(1) ! ((4,3,0)|(1,1,0)) = ((5,3,0)|(0,1,0))+((4,3,0)|(0,1,0))*AB(1)
        ! theta(1623) = theta(1176)+theta(1068)*AB(1) ! ((4,3,0)|(1,0,1)) = ((5,3,0)|(0,0,1))+((4,3,0)|(0,0,1))*AB(1)
        theta(1624) = theta(1187)+theta(1067)*AB(2) ! ((4,3,0)|(0,2,0)) = ((4,4,0)|(0,1,0))+((4,3,0)|(0,1,0))*AB(2)
        ! theta(1625) = theta(1188)+theta(1068)*AB(2) ! ((4,3,0)|(0,1,1)) = ((4,4,0)|(0,0,1))+((4,3,0)|(0,0,1))*AB(2)
        theta(1626) = theta(1191)+theta(1068)*AB(3) ! ((4,3,0)|(0,0,2)) = ((4,3,1)|(0,0,1))+((4,3,0)|(0,0,1))*AB(3)
        theta(1627) = theta(1177)+theta(1069)*AB(1) ! ((4,2,1)|(2,0,0)) = ((5,2,1)|(1,0,0))+((4,2,1)|(1,0,0))*AB(1)
        theta(1628) = theta(1178)+theta(1070)*AB(1) ! ((4,2,1)|(1,1,0)) = ((5,2,1)|(0,1,0))+((4,2,1)|(0,1,0))*AB(1)
        ! theta(1629) = theta(1179)+theta(1071)*AB(1) ! ((4,2,1)|(1,0,1)) = ((5,2,1)|(0,0,1))+((4,2,1)|(0,0,1))*AB(1)
        theta(1630) = theta(1190)+theta(1070)*AB(2) ! ((4,2,1)|(0,2,0)) = ((4,3,1)|(0,1,0))+((4,2,1)|(0,1,0))*AB(2)
        theta(1631) = theta(1191)+theta(1071)*AB(2) ! ((4,2,1)|(0,1,1)) = ((4,3,1)|(0,0,1))+((4,2,1)|(0,0,1))*AB(2)
        theta(1632) = theta(1194)+theta(1071)*AB(3) ! ((4,2,1)|(0,0,2)) = ((4,2,2)|(0,0,1))+((4,2,1)|(0,0,1))*AB(3)
        theta(1633) = theta(1180)+theta(1072)*AB(1) ! ((4,1,2)|(2,0,0)) = ((5,1,2)|(1,0,0))+((4,1,2)|(1,0,0))*AB(1)
        theta(1634) = theta(1181)+theta(1073)*AB(1) ! ((4,1,2)|(1,1,0)) = ((5,1,2)|(0,1,0))+((4,1,2)|(0,1,0))*AB(1)
        ! theta(1635) = theta(1182)+theta(1074)*AB(1) ! ((4,1,2)|(1,0,1)) = ((5,1,2)|(0,0,1))+((4,1,2)|(0,0,1))*AB(1)
        theta(1636) = theta(1193)+theta(1073)*AB(2) ! ((4,1,2)|(0,2,0)) = ((4,2,2)|(0,1,0))+((4,1,2)|(0,1,0))*AB(2)
        theta(1637) = theta(1194)+theta(1074)*AB(2) ! ((4,1,2)|(0,1,1)) = ((4,2,2)|(0,0,1))+((4,1,2)|(0,0,1))*AB(2)
        theta(1638) = theta(1197)+theta(1074)*AB(3) ! ((4,1,2)|(0,0,2)) = ((4,1,3)|(0,0,1))+((4,1,2)|(0,0,1))*AB(3)
        theta(1639) = theta(1183)+theta(1075)*AB(1) ! ((4,0,3)|(2,0,0)) = ((5,0,3)|(1,0,0))+((4,0,3)|(1,0,0))*AB(1)
        theta(1640) = theta(1184)+theta(1076)*AB(1) ! ((4,0,3)|(1,1,0)) = ((5,0,3)|(0,1,0))+((4,0,3)|(0,1,0))*AB(1)
        ! theta(1641) = theta(1185)+theta(1077)*AB(1) ! ((4,0,3)|(1,0,1)) = ((5,0,3)|(0,0,1))+((4,0,3)|(0,0,1))*AB(1)
        theta(1642) = theta(1196)+theta(1076)*AB(2) ! ((4,0,3)|(0,2,0)) = ((4,1,3)|(0,1,0))+((4,0,3)|(0,1,0))*AB(2)
        theta(1643) = theta(1197)+theta(1077)*AB(2) ! ((4,0,3)|(0,1,1)) = ((4,1,3)|(0,0,1))+((4,0,3)|(0,0,1))*AB(2)
        theta(1644) = theta(1200)+theta(1077)*AB(3) ! ((4,0,3)|(0,0,2)) = ((4,0,4)|(0,0,1))+((4,0,3)|(0,0,1))*AB(3)
        theta(1645) = theta(1186)+theta(1078)*AB(1) ! ((3,4,0)|(2,0,0)) = ((4,4,0)|(1,0,0))+((3,4,0)|(1,0,0))*AB(1)
        ! theta(1646) = theta(1187)+theta(1079)*AB(1) ! ((3,4,0)|(1,1,0)) = ((4,4,0)|(0,1,0))+((3,4,0)|(0,1,0))*AB(1)
        ! theta(1647) = theta(1188)+theta(1080)*AB(1) ! ((3,4,0)|(1,0,1)) = ((4,4,0)|(0,0,1))+((3,4,0)|(0,0,1))*AB(1)
        theta(1648) = theta(1202)+theta(1079)*AB(2) ! ((3,4,0)|(0,2,0)) = ((3,5,0)|(0,1,0))+((3,4,0)|(0,1,0))*AB(2)
        ! theta(1649) = theta(1203)+theta(1080)*AB(2) ! ((3,4,0)|(0,1,1)) = ((3,5,0)|(0,0,1))+((3,4,0)|(0,0,1))*AB(2)
        theta(1650) = theta(1206)+theta(1080)*AB(3) ! ((3,4,0)|(0,0,2)) = ((3,4,1)|(0,0,1))+((3,4,0)|(0,0,1))*AB(3)
        theta(1651) = theta(1189)+theta(1081)*AB(1) ! ((3,3,1)|(2,0,0)) = ((4,3,1)|(1,0,0))+((3,3,1)|(1,0,0))*AB(1)
        theta(1652) = theta(1190)+theta(1082)*AB(1) ! ((3,3,1)|(1,1,0)) = ((4,3,1)|(0,1,0))+((3,3,1)|(0,1,0))*AB(1)
        ! theta(1653) = theta(1191)+theta(1083)*AB(1) ! ((3,3,1)|(1,0,1)) = ((4,3,1)|(0,0,1))+((3,3,1)|(0,0,1))*AB(1)
        theta(1654) = theta(1205)+theta(1082)*AB(2) ! ((3,3,1)|(0,2,0)) = ((3,4,1)|(0,1,0))+((3,3,1)|(0,1,0))*AB(2)
        theta(1655) = theta(1206)+theta(1083)*AB(2) ! ((3,3,1)|(0,1,1)) = ((3,4,1)|(0,0,1))+((3,3,1)|(0,0,1))*AB(2)
        theta(1656) = theta(1209)+theta(1083)*AB(3) ! ((3,3,1)|(0,0,2)) = ((3,3,2)|(0,0,1))+((3,3,1)|(0,0,1))*AB(3)
        theta(1657) = theta(1192)+theta(1084)*AB(1) ! ((3,2,2)|(2,0,0)) = ((4,2,2)|(1,0,0))+((3,2,2)|(1,0,0))*AB(1)
        theta(1658) = theta(1193)+theta(1085)*AB(1) ! ((3,2,2)|(1,1,0)) = ((4,2,2)|(0,1,0))+((3,2,2)|(0,1,0))*AB(1)
        ! theta(1659) = theta(1194)+theta(1086)*AB(1) ! ((3,2,2)|(1,0,1)) = ((4,2,2)|(0,0,1))+((3,2,2)|(0,0,1))*AB(1)
        theta(1660) = theta(1208)+theta(1085)*AB(2) ! ((3,2,2)|(0,2,0)) = ((3,3,2)|(0,1,0))+((3,2,2)|(0,1,0))*AB(2)
        theta(1661) = theta(1209)+theta(1086)*AB(2) ! ((3,2,2)|(0,1,1)) = ((3,3,2)|(0,0,1))+((3,2,2)|(0,0,1))*AB(2)
        theta(1662) = theta(1212)+theta(1086)*AB(3) ! ((3,2,2)|(0,0,2)) = ((3,2,3)|(0,0,1))+((3,2,2)|(0,0,1))*AB(3)
        theta(1663) = theta(1195)+theta(1087)*AB(1) ! ((3,1,3)|(2,0,0)) = ((4,1,3)|(1,0,0))+((3,1,3)|(1,0,0))*AB(1)
        theta(1664) = theta(1196)+theta(1088)*AB(1) ! ((3,1,3)|(1,1,0)) = ((4,1,3)|(0,1,0))+((3,1,3)|(0,1,0))*AB(1)
        ! theta(1665) = theta(1197)+theta(1089)*AB(1) ! ((3,1,3)|(1,0,1)) = ((4,1,3)|(0,0,1))+((3,1,3)|(0,0,1))*AB(1)
        theta(1666) = theta(1211)+theta(1088)*AB(2) ! ((3,1,3)|(0,2,0)) = ((3,2,3)|(0,1,0))+((3,1,3)|(0,1,0))*AB(2)
        theta(1667) = theta(1212)+theta(1089)*AB(2) ! ((3,1,3)|(0,1,1)) = ((3,2,3)|(0,0,1))+((3,1,3)|(0,0,1))*AB(2)
        theta(1668) = theta(1215)+theta(1089)*AB(3) ! ((3,1,3)|(0,0,2)) = ((3,1,4)|(0,0,1))+((3,1,3)|(0,0,1))*AB(3)
        theta(1669) = theta(1198)+theta(1090)*AB(1) ! ((3,0,4)|(2,0,0)) = ((4,0,4)|(1,0,0))+((3,0,4)|(1,0,0))*AB(1)
        theta(1670) = theta(1199)+theta(1091)*AB(1) ! ((3,0,4)|(1,1,0)) = ((4,0,4)|(0,1,0))+((3,0,4)|(0,1,0))*AB(1)
        ! theta(1671) = theta(1200)+theta(1092)*AB(1) ! ((3,0,4)|(1,0,1)) = ((4,0,4)|(0,0,1))+((3,0,4)|(0,0,1))*AB(1)
        theta(1672) = theta(1214)+theta(1091)*AB(2) ! ((3,0,4)|(0,2,0)) = ((3,1,4)|(0,1,0))+((3,0,4)|(0,1,0))*AB(2)
        theta(1673) = theta(1215)+theta(1092)*AB(2) ! ((3,0,4)|(0,1,1)) = ((3,1,4)|(0,0,1))+((3,0,4)|(0,0,1))*AB(2)
        theta(1674) = theta(1218)+theta(1092)*AB(3) ! ((3,0,4)|(0,0,2)) = ((3,0,5)|(0,0,1))+((3,0,4)|(0,0,1))*AB(3)
        theta(1675) = theta(1201)+theta(1093)*AB(1) ! ((2,5,0)|(2,0,0)) = ((3,5,0)|(1,0,0))+((2,5,0)|(1,0,0))*AB(1)
        ! theta(1676) = theta(1202)+theta(1094)*AB(1) ! ((2,5,0)|(1,1,0)) = ((3,5,0)|(0,1,0))+((2,5,0)|(0,1,0))*AB(1)
        ! theta(1677) = theta(1203)+theta(1095)*AB(1) ! ((2,5,0)|(1,0,1)) = ((3,5,0)|(0,0,1))+((2,5,0)|(0,0,1))*AB(1)
        theta(1678) = theta(1220)+theta(1094)*AB(2) ! ((2,5,0)|(0,2,0)) = ((2,6,0)|(0,1,0))+((2,5,0)|(0,1,0))*AB(2)
        ! theta(1679) = theta(1221)+theta(1095)*AB(2) ! ((2,5,0)|(0,1,1)) = ((2,6,0)|(0,0,1))+((2,5,0)|(0,0,1))*AB(2)
        theta(1680) = theta(1224)+theta(1095)*AB(3) ! ((2,5,0)|(0,0,2)) = ((2,5,1)|(0,0,1))+((2,5,0)|(0,0,1))*AB(3)
        theta(1681) = theta(1204)+theta(1096)*AB(1) ! ((2,4,1)|(2,0,0)) = ((3,4,1)|(1,0,0))+((2,4,1)|(1,0,0))*AB(1)
        theta(1682) = theta(1205)+theta(1097)*AB(1) ! ((2,4,1)|(1,1,0)) = ((3,4,1)|(0,1,0))+((2,4,1)|(0,1,0))*AB(1)
        ! theta(1683) = theta(1206)+theta(1098)*AB(1) ! ((2,4,1)|(1,0,1)) = ((3,4,1)|(0,0,1))+((2,4,1)|(0,0,1))*AB(1)
        theta(1684) = theta(1223)+theta(1097)*AB(2) ! ((2,4,1)|(0,2,0)) = ((2,5,1)|(0,1,0))+((2,4,1)|(0,1,0))*AB(2)
        theta(1685) = theta(1224)+theta(1098)*AB(2) ! ((2,4,1)|(0,1,1)) = ((2,5,1)|(0,0,1))+((2,4,1)|(0,0,1))*AB(2)
        theta(1686) = theta(1227)+theta(1098)*AB(3) ! ((2,4,1)|(0,0,2)) = ((2,4,2)|(0,0,1))+((2,4,1)|(0,0,1))*AB(3)
        theta(1687) = theta(1207)+theta(1099)*AB(1) ! ((2,3,2)|(2,0,0)) = ((3,3,2)|(1,0,0))+((2,3,2)|(1,0,0))*AB(1)
        theta(1688) = theta(1208)+theta(1100)*AB(1) ! ((2,3,2)|(1,1,0)) = ((3,3,2)|(0,1,0))+((2,3,2)|(0,1,0))*AB(1)
        ! theta(1689) = theta(1209)+theta(1101)*AB(1) ! ((2,3,2)|(1,0,1)) = ((3,3,2)|(0,0,1))+((2,3,2)|(0,0,1))*AB(1)
        theta(1690) = theta(1226)+theta(1100)*AB(2) ! ((2,3,2)|(0,2,0)) = ((2,4,2)|(0,1,0))+((2,3,2)|(0,1,0))*AB(2)
        theta(1691) = theta(1227)+theta(1101)*AB(2) ! ((2,3,2)|(0,1,1)) = ((2,4,2)|(0,0,1))+((2,3,2)|(0,0,1))*AB(2)
        theta(1692) = theta(1230)+theta(1101)*AB(3) ! ((2,3,2)|(0,0,2)) = ((2,3,3)|(0,0,1))+((2,3,2)|(0,0,1))*AB(3)
        theta(1693) = theta(1210)+theta(1102)*AB(1) ! ((2,2,3)|(2,0,0)) = ((3,2,3)|(1,0,0))+((2,2,3)|(1,0,0))*AB(1)
        theta(1694) = theta(1211)+theta(1103)*AB(1) ! ((2,2,3)|(1,1,0)) = ((3,2,3)|(0,1,0))+((2,2,3)|(0,1,0))*AB(1)
        ! theta(1695) = theta(1212)+theta(1104)*AB(1) ! ((2,2,3)|(1,0,1)) = ((3,2,3)|(0,0,1))+((2,2,3)|(0,0,1))*AB(1)
        theta(1696) = theta(1229)+theta(1103)*AB(2) ! ((2,2,3)|(0,2,0)) = ((2,3,3)|(0,1,0))+((2,2,3)|(0,1,0))*AB(2)
        theta(1697) = theta(1230)+theta(1104)*AB(2) ! ((2,2,3)|(0,1,1)) = ((2,3,3)|(0,0,1))+((2,2,3)|(0,0,1))*AB(2)
        theta(1698) = theta(1233)+theta(1104)*AB(3) ! ((2,2,3)|(0,0,2)) = ((2,2,4)|(0,0,1))+((2,2,3)|(0,0,1))*AB(3)
        theta(1699) = theta(1213)+theta(1105)*AB(1) ! ((2,1,4)|(2,0,0)) = ((3,1,4)|(1,0,0))+((2,1,4)|(1,0,0))*AB(1)
        theta(1700) = theta(1214)+theta(1106)*AB(1) ! ((2,1,4)|(1,1,0)) = ((3,1,4)|(0,1,0))+((2,1,4)|(0,1,0))*AB(1)
        ! theta(1701) = theta(1215)+theta(1107)*AB(1) ! ((2,1,4)|(1,0,1)) = ((3,1,4)|(0,0,1))+((2,1,4)|(0,0,1))*AB(1)
        theta(1702) = theta(1232)+theta(1106)*AB(2) ! ((2,1,4)|(0,2,0)) = ((2,2,4)|(0,1,0))+((2,1,4)|(0,1,0))*AB(2)
        theta(1703) = theta(1233)+theta(1107)*AB(2) ! ((2,1,4)|(0,1,1)) = ((2,2,4)|(0,0,1))+((2,1,4)|(0,0,1))*AB(2)
        theta(1704) = theta(1236)+theta(1107)*AB(3) ! ((2,1,4)|(0,0,2)) = ((2,1,5)|(0,0,1))+((2,1,4)|(0,0,1))*AB(3)
        theta(1705) = theta(1216)+theta(1108)*AB(1) ! ((2,0,5)|(2,0,0)) = ((3,0,5)|(1,0,0))+((2,0,5)|(1,0,0))*AB(1)
        theta(1706) = theta(1217)+theta(1109)*AB(1) ! ((2,0,5)|(1,1,0)) = ((3,0,5)|(0,1,0))+((2,0,5)|(0,1,0))*AB(1)
        ! theta(1707) = theta(1218)+theta(1110)*AB(1) ! ((2,0,5)|(1,0,1)) = ((3,0,5)|(0,0,1))+((2,0,5)|(0,0,1))*AB(1)
        theta(1708) = theta(1235)+theta(1109)*AB(2) ! ((2,0,5)|(0,2,0)) = ((2,1,5)|(0,1,0))+((2,0,5)|(0,1,0))*AB(2)
        theta(1709) = theta(1236)+theta(1110)*AB(2) ! ((2,0,5)|(0,1,1)) = ((2,1,5)|(0,0,1))+((2,0,5)|(0,0,1))*AB(2)
        theta(1710) = theta(1239)+theta(1110)*AB(3) ! ((2,0,5)|(0,0,2)) = ((2,0,6)|(0,0,1))+((2,0,5)|(0,0,1))*AB(3)
        theta(1711) = theta(1219)+theta(1111)*AB(1) ! ((1,6,0)|(2,0,0)) = ((2,6,0)|(1,0,0))+((1,6,0)|(1,0,0))*AB(1)
        ! theta(1712) = theta(1220)+theta(1112)*AB(1) ! ((1,6,0)|(1,1,0)) = ((2,6,0)|(0,1,0))+((1,6,0)|(0,1,0))*AB(1)
        ! theta(1713) = theta(1221)+theta(1113)*AB(1) ! ((1,6,0)|(1,0,1)) = ((2,6,0)|(0,0,1))+((1,6,0)|(0,0,1))*AB(1)
        theta(1714) = theta(1241)+theta(1112)*AB(2) ! ((1,6,0)|(0,2,0)) = ((1,7,0)|(0,1,0))+((1,6,0)|(0,1,0))*AB(2)
        ! theta(1715) = theta(1242)+theta(1113)*AB(2) ! ((1,6,0)|(0,1,1)) = ((1,7,0)|(0,0,1))+((1,6,0)|(0,0,1))*AB(2)
        theta(1716) = theta(1245)+theta(1113)*AB(3) ! ((1,6,0)|(0,0,2)) = ((1,6,1)|(0,0,1))+((1,6,0)|(0,0,1))*AB(3)
        theta(1717) = theta(1222)+theta(1114)*AB(1) ! ((1,5,1)|(2,0,0)) = ((2,5,1)|(1,0,0))+((1,5,1)|(1,0,0))*AB(1)
        ! theta(1718) = theta(1223)+theta(1115)*AB(1) ! ((1,5,1)|(1,1,0)) = ((2,5,1)|(0,1,0))+((1,5,1)|(0,1,0))*AB(1)
        ! theta(1719) = theta(1224)+theta(1116)*AB(1) ! ((1,5,1)|(1,0,1)) = ((2,5,1)|(0,0,1))+((1,5,1)|(0,0,1))*AB(1)
        theta(1720) = theta(1244)+theta(1115)*AB(2) ! ((1,5,1)|(0,2,0)) = ((1,6,1)|(0,1,0))+((1,5,1)|(0,1,0))*AB(2)
        ! theta(1721) = theta(1245)+theta(1116)*AB(2) ! ((1,5,1)|(0,1,1)) = ((1,6,1)|(0,0,1))+((1,5,1)|(0,0,1))*AB(2)
        theta(1722) = theta(1248)+theta(1116)*AB(3) ! ((1,5,1)|(0,0,2)) = ((1,5,2)|(0,0,1))+((1,5,1)|(0,0,1))*AB(3)
        theta(1723) = theta(1225)+theta(1117)*AB(1) ! ((1,4,2)|(2,0,0)) = ((2,4,2)|(1,0,0))+((1,4,2)|(1,0,0))*AB(1)
        ! theta(1724) = theta(1226)+theta(1118)*AB(1) ! ((1,4,2)|(1,1,0)) = ((2,4,2)|(0,1,0))+((1,4,2)|(0,1,0))*AB(1)
        ! theta(1725) = theta(1227)+theta(1119)*AB(1) ! ((1,4,2)|(1,0,1)) = ((2,4,2)|(0,0,1))+((1,4,2)|(0,0,1))*AB(1)
        theta(1726) = theta(1247)+theta(1118)*AB(2) ! ((1,4,2)|(0,2,0)) = ((1,5,2)|(0,1,0))+((1,4,2)|(0,1,0))*AB(2)
        ! theta(1727) = theta(1248)+theta(1119)*AB(2) ! ((1,4,2)|(0,1,1)) = ((1,5,2)|(0,0,1))+((1,4,2)|(0,0,1))*AB(2)
        theta(1728) = theta(1251)+theta(1119)*AB(3) ! ((1,4,2)|(0,0,2)) = ((1,4,3)|(0,0,1))+((1,4,2)|(0,0,1))*AB(3)
        theta(1729) = theta(1228)+theta(1120)*AB(1) ! ((1,3,3)|(2,0,0)) = ((2,3,3)|(1,0,0))+((1,3,3)|(1,0,0))*AB(1)
        ! theta(1730) = theta(1229)+theta(1121)*AB(1) ! ((1,3,3)|(1,1,0)) = ((2,3,3)|(0,1,0))+((1,3,3)|(0,1,0))*AB(1)
        ! theta(1731) = theta(1230)+theta(1122)*AB(1) ! ((1,3,3)|(1,0,1)) = ((2,3,3)|(0,0,1))+((1,3,3)|(0,0,1))*AB(1)
        theta(1732) = theta(1250)+theta(1121)*AB(2) ! ((1,3,3)|(0,2,0)) = ((1,4,3)|(0,1,0))+((1,3,3)|(0,1,0))*AB(2)
        ! theta(1733) = theta(1251)+theta(1122)*AB(2) ! ((1,3,3)|(0,1,1)) = ((1,4,3)|(0,0,1))+((1,3,3)|(0,0,1))*AB(2)
        theta(1734) = theta(1254)+theta(1122)*AB(3) ! ((1,3,3)|(0,0,2)) = ((1,3,4)|(0,0,1))+((1,3,3)|(0,0,1))*AB(3)
        theta(1735) = theta(1231)+theta(1123)*AB(1) ! ((1,2,4)|(2,0,0)) = ((2,2,4)|(1,0,0))+((1,2,4)|(1,0,0))*AB(1)
        ! theta(1736) = theta(1232)+theta(1124)*AB(1) ! ((1,2,4)|(1,1,0)) = ((2,2,4)|(0,1,0))+((1,2,4)|(0,1,0))*AB(1)
        ! theta(1737) = theta(1233)+theta(1125)*AB(1) ! ((1,2,4)|(1,0,1)) = ((2,2,4)|(0,0,1))+((1,2,4)|(0,0,1))*AB(1)
        theta(1738) = theta(1253)+theta(1124)*AB(2) ! ((1,2,4)|(0,2,0)) = ((1,3,4)|(0,1,0))+((1,2,4)|(0,1,0))*AB(2)
        ! theta(1739) = theta(1254)+theta(1125)*AB(2) ! ((1,2,4)|(0,1,1)) = ((1,3,4)|(0,0,1))+((1,2,4)|(0,0,1))*AB(2)
        theta(1740) = theta(1257)+theta(1125)*AB(3) ! ((1,2,4)|(0,0,2)) = ((1,2,5)|(0,0,1))+((1,2,4)|(0,0,1))*AB(3)
        theta(1741) = theta(1234)+theta(1126)*AB(1) ! ((1,1,5)|(2,0,0)) = ((2,1,5)|(1,0,0))+((1,1,5)|(1,0,0))*AB(1)
        ! theta(1742) = theta(1235)+theta(1127)*AB(1) ! ((1,1,5)|(1,1,0)) = ((2,1,5)|(0,1,0))+((1,1,5)|(0,1,0))*AB(1)
        ! theta(1743) = theta(1236)+theta(1128)*AB(1) ! ((1,1,5)|(1,0,1)) = ((2,1,5)|(0,0,1))+((1,1,5)|(0,0,1))*AB(1)
        theta(1744) = theta(1256)+theta(1127)*AB(2) ! ((1,1,5)|(0,2,0)) = ((1,2,5)|(0,1,0))+((1,1,5)|(0,1,0))*AB(2)
        ! theta(1745) = theta(1257)+theta(1128)*AB(2) ! ((1,1,5)|(0,1,1)) = ((1,2,5)|(0,0,1))+((1,1,5)|(0,0,1))*AB(2)
        theta(1746) = theta(1260)+theta(1128)*AB(3) ! ((1,1,5)|(0,0,2)) = ((1,1,6)|(0,0,1))+((1,1,5)|(0,0,1))*AB(3)
        theta(1747) = theta(1237)+theta(1129)*AB(1) ! ((1,0,6)|(2,0,0)) = ((2,0,6)|(1,0,0))+((1,0,6)|(1,0,0))*AB(1)
        ! theta(1748) = theta(1238)+theta(1130)*AB(1) ! ((1,0,6)|(1,1,0)) = ((2,0,6)|(0,1,0))+((1,0,6)|(0,1,0))*AB(1)
        ! theta(1749) = theta(1239)+theta(1131)*AB(1) ! ((1,0,6)|(1,0,1)) = ((2,0,6)|(0,0,1))+((1,0,6)|(0,0,1))*AB(1)
        theta(1750) = theta(1259)+theta(1130)*AB(2) ! ((1,0,6)|(0,2,0)) = ((1,1,6)|(0,1,0))+((1,0,6)|(0,1,0))*AB(2)
        ! theta(1751) = theta(1260)+theta(1131)*AB(2) ! ((1,0,6)|(0,1,1)) = ((1,1,6)|(0,0,1))+((1,0,6)|(0,0,1))*AB(2)
        theta(1752) = theta(1263)+theta(1131)*AB(3) ! ((1,0,6)|(0,0,2)) = ((1,0,7)|(0,0,1))+((1,0,6)|(0,0,1))*AB(3)
        ! theta(1753) = theta(1240)+theta(1132)*AB(1) ! ((0,7,0)|(2,0,0)) = ((1,7,0)|(1,0,0))+((0,7,0)|(1,0,0))*AB(1)
        ! theta(1754) = theta(1241)+theta(1133)*AB(1) ! ((0,7,0)|(1,1,0)) = ((1,7,0)|(0,1,0))+((0,7,0)|(0,1,0))*AB(1)
        ! theta(1755) = theta(1242)+theta(1134)*AB(1) ! ((0,7,0)|(1,0,1)) = ((1,7,0)|(0,0,1))+((0,7,0)|(0,0,1))*AB(1)
        theta(1756) = theta(1265)+theta(1133)*AB(2) ! ((0,7,0)|(0,2,0)) = ((0,8,0)|(0,1,0))+((0,7,0)|(0,1,0))*AB(2)
        ! theta(1757) = theta(1266)+theta(1134)*AB(2) ! ((0,7,0)|(0,1,1)) = ((0,8,0)|(0,0,1))+((0,7,0)|(0,0,1))*AB(2)
        theta(1758) = theta(1269)+theta(1134)*AB(3) ! ((0,7,0)|(0,0,2)) = ((0,7,1)|(0,0,1))+((0,7,0)|(0,0,1))*AB(3)
        theta(1759) = theta(1243)+theta(1135)*AB(1) ! ((0,6,1)|(2,0,0)) = ((1,6,1)|(1,0,0))+((0,6,1)|(1,0,0))*AB(1)
        ! theta(1760) = theta(1244)+theta(1136)*AB(1) ! ((0,6,1)|(1,1,0)) = ((1,6,1)|(0,1,0))+((0,6,1)|(0,1,0))*AB(1)
        ! theta(1761) = theta(1245)+theta(1137)*AB(1) ! ((0,6,1)|(1,0,1)) = ((1,6,1)|(0,0,1))+((0,6,1)|(0,0,1))*AB(1)
        theta(1762) = theta(1268)+theta(1136)*AB(2) ! ((0,6,1)|(0,2,0)) = ((0,7,1)|(0,1,0))+((0,6,1)|(0,1,0))*AB(2)
        ! theta(1763) = theta(1269)+theta(1137)*AB(2) ! ((0,6,1)|(0,1,1)) = ((0,7,1)|(0,0,1))+((0,6,1)|(0,0,1))*AB(2)
        theta(1764) = theta(1272)+theta(1137)*AB(3) ! ((0,6,1)|(0,0,2)) = ((0,6,2)|(0,0,1))+((0,6,1)|(0,0,1))*AB(3)
        ! theta(1765) = theta(1246)+theta(1138)*AB(1) ! ((0,5,2)|(2,0,0)) = ((1,5,2)|(1,0,0))+((0,5,2)|(1,0,0))*AB(1)
        ! theta(1766) = theta(1247)+theta(1139)*AB(1) ! ((0,5,2)|(1,1,0)) = ((1,5,2)|(0,1,0))+((0,5,2)|(0,1,0))*AB(1)
        ! theta(1767) = theta(1248)+theta(1140)*AB(1) ! ((0,5,2)|(1,0,1)) = ((1,5,2)|(0,0,1))+((0,5,2)|(0,0,1))*AB(1)
        theta(1768) = theta(1271)+theta(1139)*AB(2) ! ((0,5,2)|(0,2,0)) = ((0,6,2)|(0,1,0))+((0,5,2)|(0,1,0))*AB(2)
        ! theta(1769) = theta(1272)+theta(1140)*AB(2) ! ((0,5,2)|(0,1,1)) = ((0,6,2)|(0,0,1))+((0,5,2)|(0,0,1))*AB(2)
        theta(1770) = theta(1275)+theta(1140)*AB(3) ! ((0,5,2)|(0,0,2)) = ((0,5,3)|(0,0,1))+((0,5,2)|(0,0,1))*AB(3)
        ! theta(1771) = theta(1249)+theta(1141)*AB(1) ! ((0,4,3)|(2,0,0)) = ((1,4,3)|(1,0,0))+((0,4,3)|(1,0,0))*AB(1)
        ! theta(1772) = theta(1250)+theta(1142)*AB(1) ! ((0,4,3)|(1,1,0)) = ((1,4,3)|(0,1,0))+((0,4,3)|(0,1,0))*AB(1)
        ! theta(1773) = theta(1251)+theta(1143)*AB(1) ! ((0,4,3)|(1,0,1)) = ((1,4,3)|(0,0,1))+((0,4,3)|(0,0,1))*AB(1)
        theta(1774) = theta(1274)+theta(1142)*AB(2) ! ((0,4,3)|(0,2,0)) = ((0,5,3)|(0,1,0))+((0,4,3)|(0,1,0))*AB(2)
        ! theta(1775) = theta(1275)+theta(1143)*AB(2) ! ((0,4,3)|(0,1,1)) = ((0,5,3)|(0,0,1))+((0,4,3)|(0,0,1))*AB(2)
        theta(1776) = theta(1278)+theta(1143)*AB(3) ! ((0,4,3)|(0,0,2)) = ((0,4,4)|(0,0,1))+((0,4,3)|(0,0,1))*AB(3)
        ! theta(1777) = theta(1252)+theta(1144)*AB(1) ! ((0,3,4)|(2,0,0)) = ((1,3,4)|(1,0,0))+((0,3,4)|(1,0,0))*AB(1)
        ! theta(1778) = theta(1253)+theta(1145)*AB(1) ! ((0,3,4)|(1,1,0)) = ((1,3,4)|(0,1,0))+((0,3,4)|(0,1,0))*AB(1)
        ! theta(1779) = theta(1254)+theta(1146)*AB(1) ! ((0,3,4)|(1,0,1)) = ((1,3,4)|(0,0,1))+((0,3,4)|(0,0,1))*AB(1)
        theta(1780) = theta(1277)+theta(1145)*AB(2) ! ((0,3,4)|(0,2,0)) = ((0,4,4)|(0,1,0))+((0,3,4)|(0,1,0))*AB(2)
        ! theta(1781) = theta(1278)+theta(1146)*AB(2) ! ((0,3,4)|(0,1,1)) = ((0,4,4)|(0,0,1))+((0,3,4)|(0,0,1))*AB(2)
        theta(1782) = theta(1281)+theta(1146)*AB(3) ! ((0,3,4)|(0,0,2)) = ((0,3,5)|(0,0,1))+((0,3,4)|(0,0,1))*AB(3)
        ! theta(1783) = theta(1255)+theta(1147)*AB(1) ! ((0,2,5)|(2,0,0)) = ((1,2,5)|(1,0,0))+((0,2,5)|(1,0,0))*AB(1)
        ! theta(1784) = theta(1256)+theta(1148)*AB(1) ! ((0,2,5)|(1,1,0)) = ((1,2,5)|(0,1,0))+((0,2,5)|(0,1,0))*AB(1)
        ! theta(1785) = theta(1257)+theta(1149)*AB(1) ! ((0,2,5)|(1,0,1)) = ((1,2,5)|(0,0,1))+((0,2,5)|(0,0,1))*AB(1)
        theta(1786) = theta(1280)+theta(1148)*AB(2) ! ((0,2,5)|(0,2,0)) = ((0,3,5)|(0,1,0))+((0,2,5)|(0,1,0))*AB(2)
        ! theta(1787) = theta(1281)+theta(1149)*AB(2) ! ((0,2,5)|(0,1,1)) = ((0,3,5)|(0,0,1))+((0,2,5)|(0,0,1))*AB(2)
        theta(1788) = theta(1284)+theta(1149)*AB(3) ! ((0,2,5)|(0,0,2)) = ((0,2,6)|(0,0,1))+((0,2,5)|(0,0,1))*AB(3)
        ! theta(1789) = theta(1258)+theta(1150)*AB(1) ! ((0,1,6)|(2,0,0)) = ((1,1,6)|(1,0,0))+((0,1,6)|(1,0,0))*AB(1)
        ! theta(1790) = theta(1259)+theta(1151)*AB(1) ! ((0,1,6)|(1,1,0)) = ((1,1,6)|(0,1,0))+((0,1,6)|(0,1,0))*AB(1)
        ! theta(1791) = theta(1260)+theta(1152)*AB(1) ! ((0,1,6)|(1,0,1)) = ((1,1,6)|(0,0,1))+((0,1,6)|(0,0,1))*AB(1)
        theta(1792) = theta(1283)+theta(1151)*AB(2) ! ((0,1,6)|(0,2,0)) = ((0,2,6)|(0,1,0))+((0,1,6)|(0,1,0))*AB(2)
        ! theta(1793) = theta(1284)+theta(1152)*AB(2) ! ((0,1,6)|(0,1,1)) = ((0,2,6)|(0,0,1))+((0,1,6)|(0,0,1))*AB(2)
        theta(1794) = theta(1287)+theta(1152)*AB(3) ! ((0,1,6)|(0,0,2)) = ((0,1,7)|(0,0,1))+((0,1,6)|(0,0,1))*AB(3)
        ! theta(1795) = theta(1261)+theta(1153)*AB(1) ! ((0,0,7)|(2,0,0)) = ((1,0,7)|(1,0,0))+((0,0,7)|(1,0,0))*AB(1)
        ! theta(1796) = theta(1262)+theta(1154)*AB(1) ! ((0,0,7)|(1,1,0)) = ((1,0,7)|(0,1,0))+((0,0,7)|(0,1,0))*AB(1)
        ! theta(1797) = theta(1263)+theta(1155)*AB(1) ! ((0,0,7)|(1,0,1)) = ((1,0,7)|(0,0,1))+((0,0,7)|(0,0,1))*AB(1)
        ! theta(1798) = theta(1286)+theta(1154)*AB(2) ! ((0,0,7)|(0,2,0)) = ((0,1,7)|(0,1,0))+((0,0,7)|(0,1,0))*AB(2)
        ! theta(1799) = theta(1287)+theta(1155)*AB(2) ! ((0,0,7)|(0,1,1)) = ((0,1,7)|(0,0,1))+((0,0,7)|(0,0,1))*AB(2)
        theta(1800) = theta(1290)+theta(1155)*AB(3) ! ((0,0,7)|(0,0,2)) = ((0,0,8)|(0,0,1))+((0,0,7)|(0,0,1))*AB(3)
        theta(1801) = theta(1417)+theta(1291)*AB(1) ! ((5,0,0)|(3,0,0)) = ((6,0,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(1)
        ! theta(1802) = theta(1423)+theta(1291)*AB(2) ! ((5,0,0)|(2,1,0)) = ((5,1,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(2)
        theta(1803) = theta(1429)+theta(1291)*AB(3) ! ((5,0,0)|(2,0,1)) = ((5,0,1)|(2,0,0))+((5,0,0)|(2,0,0))*AB(3)
        theta(1804) = theta(1420)+theta(1294)*AB(1) ! ((5,0,0)|(1,2,0)) = ((6,0,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(1)
        ! theta(1805) = theta(1421)+theta(1295)*AB(1) ! ((5,0,0)|(1,1,1)) = ((6,0,0)|(0,1,1))+((5,0,0)|(0,1,1))*AB(1)
        theta(1806) = theta(1422)+theta(1296)*AB(1) ! ((5,0,0)|(1,0,2)) = ((6,0,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(1)
        theta(1807) = theta(1426)+theta(1294)*AB(2) ! ((5,0,0)|(0,3,0)) = ((5,1,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(2)
        theta(1808) = theta(1432)+theta(1294)*AB(3) ! ((5,0,0)|(0,2,1)) = ((5,0,1)|(0,2,0))+((5,0,0)|(0,2,0))*AB(3)
        theta(1809) = theta(1428)+theta(1296)*AB(2) ! ((5,0,0)|(0,1,2)) = ((5,1,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(2)
        theta(1810) = theta(1434)+theta(1296)*AB(3) ! ((5,0,0)|(0,0,3)) = ((5,0,1)|(0,0,2))+((5,0,0)|(0,0,2))*AB(3)
        theta(1811) = theta(1423)+theta(1297)*AB(1) ! ((4,1,0)|(3,0,0)) = ((5,1,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(1)
        ! theta(1812) = theta(1435)+theta(1297)*AB(2) ! ((4,1,0)|(2,1,0)) = ((4,2,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(2)
        theta(1813) = theta(1441)+theta(1297)*AB(3) ! ((4,1,0)|(2,0,1)) = ((4,1,1)|(2,0,0))+((4,1,0)|(2,0,0))*AB(3)
        theta(1814) = theta(1426)+theta(1300)*AB(1) ! ((4,1,0)|(1,2,0)) = ((5,1,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(1)
        ! theta(1815) = theta(1427)+theta(1301)*AB(1) ! ((4,1,0)|(1,1,1)) = ((5,1,0)|(0,1,1))+((4,1,0)|(0,1,1))*AB(1)
        theta(1816) = theta(1428)+theta(1302)*AB(1) ! ((4,1,0)|(1,0,2)) = ((5,1,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(1)
        theta(1817) = theta(1438)+theta(1300)*AB(2) ! ((4,1,0)|(0,3,0)) = ((4,2,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(2)
        theta(1818) = theta(1444)+theta(1300)*AB(3) ! ((4,1,0)|(0,2,1)) = ((4,1,1)|(0,2,0))+((4,1,0)|(0,2,0))*AB(3)
        theta(1819) = theta(1440)+theta(1302)*AB(2) ! ((4,1,0)|(0,1,2)) = ((4,2,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(2)
        theta(1820) = theta(1446)+theta(1302)*AB(3) ! ((4,1,0)|(0,0,3)) = ((4,1,1)|(0,0,2))+((4,1,0)|(0,0,2))*AB(3)
        theta(1821) = theta(1429)+theta(1303)*AB(1) ! ((4,0,1)|(3,0,0)) = ((5,0,1)|(2,0,0))+((4,0,1)|(2,0,0))*AB(1)
        theta(1822) = theta(1430)+theta(1304)*AB(1) ! ((4,0,1)|(2,1,0)) = ((5,0,1)|(1,1,0))+((4,0,1)|(1,1,0))*AB(1)
        ! theta(1823) = theta(1447)+theta(1303)*AB(3) ! ((4,0,1)|(2,0,1)) = ((4,0,2)|(2,0,0))+((4,0,1)|(2,0,0))*AB(3)
        theta(1824) = theta(1432)+theta(1306)*AB(1) ! ((4,0,1)|(1,2,0)) = ((5,0,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(1)
        theta(1825) = theta(1433)+theta(1307)*AB(1) ! ((4,0,1)|(1,1,1)) = ((5,0,1)|(0,1,1))+((4,0,1)|(0,1,1))*AB(1)
        theta(1826) = theta(1434)+theta(1308)*AB(1) ! ((4,0,1)|(1,0,2)) = ((5,0,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(1)
        theta(1827) = theta(1444)+theta(1306)*AB(2) ! ((4,0,1)|(0,3,0)) = ((4,1,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(2)
        theta(1828) = theta(1450)+theta(1306)*AB(3) ! ((4,0,1)|(0,2,1)) = ((4,0,2)|(0,2,0))+((4,0,1)|(0,2,0))*AB(3)
        theta(1829) = theta(1446)+theta(1308)*AB(2) ! ((4,0,1)|(0,1,2)) = ((4,1,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(2)
        theta(1830) = theta(1452)+theta(1308)*AB(3) ! ((4,0,1)|(0,0,3)) = ((4,0,2)|(0,0,2))+((4,0,1)|(0,0,2))*AB(3)
        theta(1831) = theta(1435)+theta(1309)*AB(1) ! ((3,2,0)|(3,0,0)) = ((4,2,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(1)
        ! theta(1832) = theta(1453)+theta(1309)*AB(2) ! ((3,2,0)|(2,1,0)) = ((3,3,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(2)
        theta(1833) = theta(1459)+theta(1309)*AB(3) ! ((3,2,0)|(2,0,1)) = ((3,2,1)|(2,0,0))+((3,2,0)|(2,0,0))*AB(3)
        theta(1834) = theta(1438)+theta(1312)*AB(1) ! ((3,2,0)|(1,2,0)) = ((4,2,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(1)
        ! theta(1835) = theta(1439)+theta(1313)*AB(1) ! ((3,2,0)|(1,1,1)) = ((4,2,0)|(0,1,1))+((3,2,0)|(0,1,1))*AB(1)
        theta(1836) = theta(1440)+theta(1314)*AB(1) ! ((3,2,0)|(1,0,2)) = ((4,2,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(1)
        theta(1837) = theta(1456)+theta(1312)*AB(2) ! ((3,2,0)|(0,3,0)) = ((3,3,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(2)
        theta(1838) = theta(1462)+theta(1312)*AB(3) ! ((3,2,0)|(0,2,1)) = ((3,2,1)|(0,2,0))+((3,2,0)|(0,2,0))*AB(3)
        theta(1839) = theta(1458)+theta(1314)*AB(2) ! ((3,2,0)|(0,1,2)) = ((3,3,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(2)
        theta(1840) = theta(1464)+theta(1314)*AB(3) ! ((3,2,0)|(0,0,3)) = ((3,2,1)|(0,0,2))+((3,2,0)|(0,0,2))*AB(3)
        theta(1841) = theta(1441)+theta(1315)*AB(1) ! ((3,1,1)|(3,0,0)) = ((4,1,1)|(2,0,0))+((3,1,1)|(2,0,0))*AB(1)
        theta(1842) = theta(1442)+theta(1316)*AB(1) ! ((3,1,1)|(2,1,0)) = ((4,1,1)|(1,1,0))+((3,1,1)|(1,1,0))*AB(1)
        ! theta(1843) = theta(1465)+theta(1315)*AB(3) ! ((3,1,1)|(2,0,1)) = ((3,1,2)|(2,0,0))+((3,1,1)|(2,0,0))*AB(3)
        theta(1844) = theta(1444)+theta(1318)*AB(1) ! ((3,1,1)|(1,2,0)) = ((4,1,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(1)
        theta(1845) = theta(1445)+theta(1319)*AB(1) ! ((3,1,1)|(1,1,1)) = ((4,1,1)|(0,1,1))+((3,1,1)|(0,1,1))*AB(1)
        theta(1846) = theta(1446)+theta(1320)*AB(1) ! ((3,1,1)|(1,0,2)) = ((4,1,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(1)
        theta(1847) = theta(1462)+theta(1318)*AB(2) ! ((3,1,1)|(0,3,0)) = ((3,2,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(2)
        theta(1848) = theta(1468)+theta(1318)*AB(3) ! ((3,1,1)|(0,2,1)) = ((3,1,2)|(0,2,0))+((3,1,1)|(0,2,0))*AB(3)
        theta(1849) = theta(1464)+theta(1320)*AB(2) ! ((3,1,1)|(0,1,2)) = ((3,2,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(2)
        theta(1850) = theta(1470)+theta(1320)*AB(3) ! ((3,1,1)|(0,0,3)) = ((3,1,2)|(0,0,2))+((3,1,1)|(0,0,2))*AB(3)
        theta(1851) = theta(1447)+theta(1321)*AB(1) ! ((3,0,2)|(3,0,0)) = ((4,0,2)|(2,0,0))+((3,0,2)|(2,0,0))*AB(1)
        theta(1852) = theta(1448)+theta(1322)*AB(1) ! ((3,0,2)|(2,1,0)) = ((4,0,2)|(1,1,0))+((3,0,2)|(1,1,0))*AB(1)
        ! theta(1853) = theta(1471)+theta(1321)*AB(3) ! ((3,0,2)|(2,0,1)) = ((3,0,3)|(2,0,0))+((3,0,2)|(2,0,0))*AB(3)
        theta(1854) = theta(1450)+theta(1324)*AB(1) ! ((3,0,2)|(1,2,0)) = ((4,0,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(1)
        theta(1855) = theta(1451)+theta(1325)*AB(1) ! ((3,0,2)|(1,1,1)) = ((4,0,2)|(0,1,1))+((3,0,2)|(0,1,1))*AB(1)
        theta(1856) = theta(1452)+theta(1326)*AB(1) ! ((3,0,2)|(1,0,2)) = ((4,0,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(1)
        theta(1857) = theta(1468)+theta(1324)*AB(2) ! ((3,0,2)|(0,3,0)) = ((3,1,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(2)
        theta(1858) = theta(1474)+theta(1324)*AB(3) ! ((3,0,2)|(0,2,1)) = ((3,0,3)|(0,2,0))+((3,0,2)|(0,2,0))*AB(3)
        theta(1859) = theta(1470)+theta(1326)*AB(2) ! ((3,0,2)|(0,1,2)) = ((3,1,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(2)
        theta(1860) = theta(1476)+theta(1326)*AB(3) ! ((3,0,2)|(0,0,3)) = ((3,0,3)|(0,0,2))+((3,0,2)|(0,0,2))*AB(3)
        theta(1861) = theta(1453)+theta(1327)*AB(1) ! ((2,3,0)|(3,0,0)) = ((3,3,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(1)
        ! theta(1862) = theta(1477)+theta(1327)*AB(2) ! ((2,3,0)|(2,1,0)) = ((2,4,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(2)
        theta(1863) = theta(1483)+theta(1327)*AB(3) ! ((2,3,0)|(2,0,1)) = ((2,3,1)|(2,0,0))+((2,3,0)|(2,0,0))*AB(3)
        theta(1864) = theta(1456)+theta(1330)*AB(1) ! ((2,3,0)|(1,2,0)) = ((3,3,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(1)
        ! theta(1865) = theta(1457)+theta(1331)*AB(1) ! ((2,3,0)|(1,1,1)) = ((3,3,0)|(0,1,1))+((2,3,0)|(0,1,1))*AB(1)
        theta(1866) = theta(1458)+theta(1332)*AB(1) ! ((2,3,0)|(1,0,2)) = ((3,3,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(1)
        theta(1867) = theta(1480)+theta(1330)*AB(2) ! ((2,3,0)|(0,3,0)) = ((2,4,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(2)
        theta(1868) = theta(1486)+theta(1330)*AB(3) ! ((2,3,0)|(0,2,1)) = ((2,3,1)|(0,2,0))+((2,3,0)|(0,2,0))*AB(3)
        theta(1869) = theta(1482)+theta(1332)*AB(2) ! ((2,3,0)|(0,1,2)) = ((2,4,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(2)
        theta(1870) = theta(1488)+theta(1332)*AB(3) ! ((2,3,0)|(0,0,3)) = ((2,3,1)|(0,0,2))+((2,3,0)|(0,0,2))*AB(3)
        theta(1871) = theta(1459)+theta(1333)*AB(1) ! ((2,2,1)|(3,0,0)) = ((3,2,1)|(2,0,0))+((2,2,1)|(2,0,0))*AB(1)
        theta(1872) = theta(1460)+theta(1334)*AB(1) ! ((2,2,1)|(2,1,0)) = ((3,2,1)|(1,1,0))+((2,2,1)|(1,1,0))*AB(1)
        ! theta(1873) = theta(1489)+theta(1333)*AB(3) ! ((2,2,1)|(2,0,1)) = ((2,2,2)|(2,0,0))+((2,2,1)|(2,0,0))*AB(3)
        theta(1874) = theta(1462)+theta(1336)*AB(1) ! ((2,2,1)|(1,2,0)) = ((3,2,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(1)
        theta(1875) = theta(1463)+theta(1337)*AB(1) ! ((2,2,1)|(1,1,1)) = ((3,2,1)|(0,1,1))+((2,2,1)|(0,1,1))*AB(1)
        theta(1876) = theta(1464)+theta(1338)*AB(1) ! ((2,2,1)|(1,0,2)) = ((3,2,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(1)
        theta(1877) = theta(1486)+theta(1336)*AB(2) ! ((2,2,1)|(0,3,0)) = ((2,3,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(2)
        theta(1878) = theta(1492)+theta(1336)*AB(3) ! ((2,2,1)|(0,2,1)) = ((2,2,2)|(0,2,0))+((2,2,1)|(0,2,0))*AB(3)
        theta(1879) = theta(1488)+theta(1338)*AB(2) ! ((2,2,1)|(0,1,2)) = ((2,3,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(2)
        theta(1880) = theta(1494)+theta(1338)*AB(3) ! ((2,2,1)|(0,0,3)) = ((2,2,2)|(0,0,2))+((2,2,1)|(0,0,2))*AB(3)
        theta(1881) = theta(1465)+theta(1339)*AB(1) ! ((2,1,2)|(3,0,0)) = ((3,1,2)|(2,0,0))+((2,1,2)|(2,0,0))*AB(1)
        theta(1882) = theta(1466)+theta(1340)*AB(1) ! ((2,1,2)|(2,1,0)) = ((3,1,2)|(1,1,0))+((2,1,2)|(1,1,0))*AB(1)
        ! theta(1883) = theta(1495)+theta(1339)*AB(3) ! ((2,1,2)|(2,0,1)) = ((2,1,3)|(2,0,0))+((2,1,2)|(2,0,0))*AB(3)
        theta(1884) = theta(1468)+theta(1342)*AB(1) ! ((2,1,2)|(1,2,0)) = ((3,1,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(1)
        theta(1885) = theta(1469)+theta(1343)*AB(1) ! ((2,1,2)|(1,1,1)) = ((3,1,2)|(0,1,1))+((2,1,2)|(0,1,1))*AB(1)
        theta(1886) = theta(1470)+theta(1344)*AB(1) ! ((2,1,2)|(1,0,2)) = ((3,1,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(1)
        theta(1887) = theta(1492)+theta(1342)*AB(2) ! ((2,1,2)|(0,3,0)) = ((2,2,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(2)
        theta(1888) = theta(1498)+theta(1342)*AB(3) ! ((2,1,2)|(0,2,1)) = ((2,1,3)|(0,2,0))+((2,1,2)|(0,2,0))*AB(3)
        theta(1889) = theta(1494)+theta(1344)*AB(2) ! ((2,1,2)|(0,1,2)) = ((2,2,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(2)
        theta(1890) = theta(1500)+theta(1344)*AB(3) ! ((2,1,2)|(0,0,3)) = ((2,1,3)|(0,0,2))+((2,1,2)|(0,0,2))*AB(3)
        theta(1891) = theta(1471)+theta(1345)*AB(1) ! ((2,0,3)|(3,0,0)) = ((3,0,3)|(2,0,0))+((2,0,3)|(2,0,0))*AB(1)
        theta(1892) = theta(1472)+theta(1346)*AB(1) ! ((2,0,3)|(2,1,0)) = ((3,0,3)|(1,1,0))+((2,0,3)|(1,1,0))*AB(1)
        ! theta(1893) = theta(1501)+theta(1345)*AB(3) ! ((2,0,3)|(2,0,1)) = ((2,0,4)|(2,0,0))+((2,0,3)|(2,0,0))*AB(3)
        theta(1894) = theta(1474)+theta(1348)*AB(1) ! ((2,0,3)|(1,2,0)) = ((3,0,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(1)
        theta(1895) = theta(1475)+theta(1349)*AB(1) ! ((2,0,3)|(1,1,1)) = ((3,0,3)|(0,1,1))+((2,0,3)|(0,1,1))*AB(1)
        theta(1896) = theta(1476)+theta(1350)*AB(1) ! ((2,0,3)|(1,0,2)) = ((3,0,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(1)
        theta(1897) = theta(1498)+theta(1348)*AB(2) ! ((2,0,3)|(0,3,0)) = ((2,1,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(2)
        theta(1898) = theta(1504)+theta(1348)*AB(3) ! ((2,0,3)|(0,2,1)) = ((2,0,4)|(0,2,0))+((2,0,3)|(0,2,0))*AB(3)
        theta(1899) = theta(1500)+theta(1350)*AB(2) ! ((2,0,3)|(0,1,2)) = ((2,1,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(2)
        theta(1900) = theta(1506)+theta(1350)*AB(3) ! ((2,0,3)|(0,0,3)) = ((2,0,4)|(0,0,2))+((2,0,3)|(0,0,2))*AB(3)
        theta(1901) = theta(1477)+theta(1351)*AB(1) ! ((1,4,0)|(3,0,0)) = ((2,4,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(1)
        ! theta(1902) = theta(1507)+theta(1351)*AB(2) ! ((1,4,0)|(2,1,0)) = ((1,5,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(2)
        theta(1903) = theta(1513)+theta(1351)*AB(3) ! ((1,4,0)|(2,0,1)) = ((1,4,1)|(2,0,0))+((1,4,0)|(2,0,0))*AB(3)
        theta(1904) = theta(1480)+theta(1354)*AB(1) ! ((1,4,0)|(1,2,0)) = ((2,4,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(1)
        ! theta(1905) = theta(1481)+theta(1355)*AB(1) ! ((1,4,0)|(1,1,1)) = ((2,4,0)|(0,1,1))+((1,4,0)|(0,1,1))*AB(1)
        theta(1906) = theta(1482)+theta(1356)*AB(1) ! ((1,4,0)|(1,0,2)) = ((2,4,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(1)
        theta(1907) = theta(1510)+theta(1354)*AB(2) ! ((1,4,0)|(0,3,0)) = ((1,5,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(2)
        theta(1908) = theta(1516)+theta(1354)*AB(3) ! ((1,4,0)|(0,2,1)) = ((1,4,1)|(0,2,0))+((1,4,0)|(0,2,0))*AB(3)
        theta(1909) = theta(1512)+theta(1356)*AB(2) ! ((1,4,0)|(0,1,2)) = ((1,5,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(2)
        theta(1910) = theta(1518)+theta(1356)*AB(3) ! ((1,4,0)|(0,0,3)) = ((1,4,1)|(0,0,2))+((1,4,0)|(0,0,2))*AB(3)
        theta(1911) = theta(1483)+theta(1357)*AB(1) ! ((1,3,1)|(3,0,0)) = ((2,3,1)|(2,0,0))+((1,3,1)|(2,0,0))*AB(1)
        theta(1912) = theta(1484)+theta(1358)*AB(1) ! ((1,3,1)|(2,1,0)) = ((2,3,1)|(1,1,0))+((1,3,1)|(1,1,0))*AB(1)
        ! theta(1913) = theta(1519)+theta(1357)*AB(3) ! ((1,3,1)|(2,0,1)) = ((1,3,2)|(2,0,0))+((1,3,1)|(2,0,0))*AB(3)
        theta(1914) = theta(1486)+theta(1360)*AB(1) ! ((1,3,1)|(1,2,0)) = ((2,3,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(1)
        theta(1915) = theta(1487)+theta(1361)*AB(1) ! ((1,3,1)|(1,1,1)) = ((2,3,1)|(0,1,1))+((1,3,1)|(0,1,1))*AB(1)
        theta(1916) = theta(1488)+theta(1362)*AB(1) ! ((1,3,1)|(1,0,2)) = ((2,3,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(1)
        theta(1917) = theta(1516)+theta(1360)*AB(2) ! ((1,3,1)|(0,3,0)) = ((1,4,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(2)
        theta(1918) = theta(1522)+theta(1360)*AB(3) ! ((1,3,1)|(0,2,1)) = ((1,3,2)|(0,2,0))+((1,3,1)|(0,2,0))*AB(3)
        theta(1919) = theta(1518)+theta(1362)*AB(2) ! ((1,3,1)|(0,1,2)) = ((1,4,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(2)
        theta(1920) = theta(1524)+theta(1362)*AB(3) ! ((1,3,1)|(0,0,3)) = ((1,3,2)|(0,0,2))+((1,3,1)|(0,0,2))*AB(3)
        theta(1921) = theta(1489)+theta(1363)*AB(1) ! ((1,2,2)|(3,0,0)) = ((2,2,2)|(2,0,0))+((1,2,2)|(2,0,0))*AB(1)
        theta(1922) = theta(1490)+theta(1364)*AB(1) ! ((1,2,2)|(2,1,0)) = ((2,2,2)|(1,1,0))+((1,2,2)|(1,1,0))*AB(1)
        ! theta(1923) = theta(1525)+theta(1363)*AB(3) ! ((1,2,2)|(2,0,1)) = ((1,2,3)|(2,0,0))+((1,2,2)|(2,0,0))*AB(3)
        theta(1924) = theta(1492)+theta(1366)*AB(1) ! ((1,2,2)|(1,2,0)) = ((2,2,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(1)
        theta(1925) = theta(1493)+theta(1367)*AB(1) ! ((1,2,2)|(1,1,1)) = ((2,2,2)|(0,1,1))+((1,2,2)|(0,1,1))*AB(1)
        theta(1926) = theta(1494)+theta(1368)*AB(1) ! ((1,2,2)|(1,0,2)) = ((2,2,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(1)
        theta(1927) = theta(1522)+theta(1366)*AB(2) ! ((1,2,2)|(0,3,0)) = ((1,3,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(2)
        theta(1928) = theta(1528)+theta(1366)*AB(3) ! ((1,2,2)|(0,2,1)) = ((1,2,3)|(0,2,0))+((1,2,2)|(0,2,0))*AB(3)
        theta(1929) = theta(1524)+theta(1368)*AB(2) ! ((1,2,2)|(0,1,2)) = ((1,3,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(2)
        theta(1930) = theta(1530)+theta(1368)*AB(3) ! ((1,2,2)|(0,0,3)) = ((1,2,3)|(0,0,2))+((1,2,2)|(0,0,2))*AB(3)
        theta(1931) = theta(1495)+theta(1369)*AB(1) ! ((1,1,3)|(3,0,0)) = ((2,1,3)|(2,0,0))+((1,1,3)|(2,0,0))*AB(1)
        theta(1932) = theta(1496)+theta(1370)*AB(1) ! ((1,1,3)|(2,1,0)) = ((2,1,3)|(1,1,0))+((1,1,3)|(1,1,0))*AB(1)
        ! theta(1933) = theta(1531)+theta(1369)*AB(3) ! ((1,1,3)|(2,0,1)) = ((1,1,4)|(2,0,0))+((1,1,3)|(2,0,0))*AB(3)
        theta(1934) = theta(1498)+theta(1372)*AB(1) ! ((1,1,3)|(1,2,0)) = ((2,1,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(1)
        theta(1935) = theta(1499)+theta(1373)*AB(1) ! ((1,1,3)|(1,1,1)) = ((2,1,3)|(0,1,1))+((1,1,3)|(0,1,1))*AB(1)
        theta(1936) = theta(1500)+theta(1374)*AB(1) ! ((1,1,3)|(1,0,2)) = ((2,1,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(1)
        theta(1937) = theta(1528)+theta(1372)*AB(2) ! ((1,1,3)|(0,3,0)) = ((1,2,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(2)
        theta(1938) = theta(1534)+theta(1372)*AB(3) ! ((1,1,3)|(0,2,1)) = ((1,1,4)|(0,2,0))+((1,1,3)|(0,2,0))*AB(3)
        theta(1939) = theta(1530)+theta(1374)*AB(2) ! ((1,1,3)|(0,1,2)) = ((1,2,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(2)
        theta(1940) = theta(1536)+theta(1374)*AB(3) ! ((1,1,3)|(0,0,3)) = ((1,1,4)|(0,0,2))+((1,1,3)|(0,0,2))*AB(3)
        theta(1941) = theta(1501)+theta(1375)*AB(1) ! ((1,0,4)|(3,0,0)) = ((2,0,4)|(2,0,0))+((1,0,4)|(2,0,0))*AB(1)
        theta(1942) = theta(1502)+theta(1376)*AB(1) ! ((1,0,4)|(2,1,0)) = ((2,0,4)|(1,1,0))+((1,0,4)|(1,1,0))*AB(1)
        ! theta(1943) = theta(1537)+theta(1375)*AB(3) ! ((1,0,4)|(2,0,1)) = ((1,0,5)|(2,0,0))+((1,0,4)|(2,0,0))*AB(3)
        theta(1944) = theta(1504)+theta(1378)*AB(1) ! ((1,0,4)|(1,2,0)) = ((2,0,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(1)
        theta(1945) = theta(1505)+theta(1379)*AB(1) ! ((1,0,4)|(1,1,1)) = ((2,0,4)|(0,1,1))+((1,0,4)|(0,1,1))*AB(1)
        theta(1946) = theta(1506)+theta(1380)*AB(1) ! ((1,0,4)|(1,0,2)) = ((2,0,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(1)
        theta(1947) = theta(1534)+theta(1378)*AB(2) ! ((1,0,4)|(0,3,0)) = ((1,1,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(2)
        theta(1948) = theta(1540)+theta(1378)*AB(3) ! ((1,0,4)|(0,2,1)) = ((1,0,5)|(0,2,0))+((1,0,4)|(0,2,0))*AB(3)
        theta(1949) = theta(1536)+theta(1380)*AB(2) ! ((1,0,4)|(0,1,2)) = ((1,1,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(2)
        theta(1950) = theta(1542)+theta(1380)*AB(3) ! ((1,0,4)|(0,0,3)) = ((1,0,5)|(0,0,2))+((1,0,4)|(0,0,2))*AB(3)
        theta(1951) = theta(1507)+theta(1381)*AB(1) ! ((0,5,0)|(3,0,0)) = ((1,5,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(1)
        ! theta(1952) = theta(1543)+theta(1381)*AB(2) ! ((0,5,0)|(2,1,0)) = ((0,6,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(2)
        theta(1953) = theta(1549)+theta(1381)*AB(3) ! ((0,5,0)|(2,0,1)) = ((0,5,1)|(2,0,0))+((0,5,0)|(2,0,0))*AB(3)
        theta(1954) = theta(1510)+theta(1384)*AB(1) ! ((0,5,0)|(1,2,0)) = ((1,5,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(1)
        ! theta(1955) = theta(1511)+theta(1385)*AB(1) ! ((0,5,0)|(1,1,1)) = ((1,5,0)|(0,1,1))+((0,5,0)|(0,1,1))*AB(1)
        theta(1956) = theta(1512)+theta(1386)*AB(1) ! ((0,5,0)|(1,0,2)) = ((1,5,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(1)
        theta(1957) = theta(1546)+theta(1384)*AB(2) ! ((0,5,0)|(0,3,0)) = ((0,6,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(2)
        theta(1958) = theta(1552)+theta(1384)*AB(3) ! ((0,5,0)|(0,2,1)) = ((0,5,1)|(0,2,0))+((0,5,0)|(0,2,0))*AB(3)
        theta(1959) = theta(1548)+theta(1386)*AB(2) ! ((0,5,0)|(0,1,2)) = ((0,6,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(2)
        theta(1960) = theta(1554)+theta(1386)*AB(3) ! ((0,5,0)|(0,0,3)) = ((0,5,1)|(0,0,2))+((0,5,0)|(0,0,2))*AB(3)
        theta(1961) = theta(1513)+theta(1387)*AB(1) ! ((0,4,1)|(3,0,0)) = ((1,4,1)|(2,0,0))+((0,4,1)|(2,0,0))*AB(1)
        theta(1962) = theta(1514)+theta(1388)*AB(1) ! ((0,4,1)|(2,1,0)) = ((1,4,1)|(1,1,0))+((0,4,1)|(1,1,0))*AB(1)
        ! theta(1963) = theta(1555)+theta(1387)*AB(3) ! ((0,4,1)|(2,0,1)) = ((0,4,2)|(2,0,0))+((0,4,1)|(2,0,0))*AB(3)
        theta(1964) = theta(1516)+theta(1390)*AB(1) ! ((0,4,1)|(1,2,0)) = ((1,4,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(1)
        theta(1965) = theta(1517)+theta(1391)*AB(1) ! ((0,4,1)|(1,1,1)) = ((1,4,1)|(0,1,1))+((0,4,1)|(0,1,1))*AB(1)
        theta(1966) = theta(1518)+theta(1392)*AB(1) ! ((0,4,1)|(1,0,2)) = ((1,4,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(1)
        theta(1967) = theta(1552)+theta(1390)*AB(2) ! ((0,4,1)|(0,3,0)) = ((0,5,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(2)
        theta(1968) = theta(1558)+theta(1390)*AB(3) ! ((0,4,1)|(0,2,1)) = ((0,4,2)|(0,2,0))+((0,4,1)|(0,2,0))*AB(3)
        theta(1969) = theta(1554)+theta(1392)*AB(2) ! ((0,4,1)|(0,1,2)) = ((0,5,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(2)
        theta(1970) = theta(1560)+theta(1392)*AB(3) ! ((0,4,1)|(0,0,3)) = ((0,4,2)|(0,0,2))+((0,4,1)|(0,0,2))*AB(3)
        theta(1971) = theta(1519)+theta(1393)*AB(1) ! ((0,3,2)|(3,0,0)) = ((1,3,2)|(2,0,0))+((0,3,2)|(2,0,0))*AB(1)
        theta(1972) = theta(1520)+theta(1394)*AB(1) ! ((0,3,2)|(2,1,0)) = ((1,3,2)|(1,1,0))+((0,3,2)|(1,1,0))*AB(1)
        ! theta(1973) = theta(1561)+theta(1393)*AB(3) ! ((0,3,2)|(2,0,1)) = ((0,3,3)|(2,0,0))+((0,3,2)|(2,0,0))*AB(3)
        theta(1974) = theta(1522)+theta(1396)*AB(1) ! ((0,3,2)|(1,2,0)) = ((1,3,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(1)
        theta(1975) = theta(1523)+theta(1397)*AB(1) ! ((0,3,2)|(1,1,1)) = ((1,3,2)|(0,1,1))+((0,3,2)|(0,1,1))*AB(1)
        theta(1976) = theta(1524)+theta(1398)*AB(1) ! ((0,3,2)|(1,0,2)) = ((1,3,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(1)
        theta(1977) = theta(1558)+theta(1396)*AB(2) ! ((0,3,2)|(0,3,0)) = ((0,4,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(2)
        theta(1978) = theta(1564)+theta(1396)*AB(3) ! ((0,3,2)|(0,2,1)) = ((0,3,3)|(0,2,0))+((0,3,2)|(0,2,0))*AB(3)
        theta(1979) = theta(1560)+theta(1398)*AB(2) ! ((0,3,2)|(0,1,2)) = ((0,4,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(2)
        theta(1980) = theta(1566)+theta(1398)*AB(3) ! ((0,3,2)|(0,0,3)) = ((0,3,3)|(0,0,2))+((0,3,2)|(0,0,2))*AB(3)
        theta(1981) = theta(1525)+theta(1399)*AB(1) ! ((0,2,3)|(3,0,0)) = ((1,2,3)|(2,0,0))+((0,2,3)|(2,0,0))*AB(1)
        theta(1982) = theta(1526)+theta(1400)*AB(1) ! ((0,2,3)|(2,1,0)) = ((1,2,3)|(1,1,0))+((0,2,3)|(1,1,0))*AB(1)
        ! theta(1983) = theta(1567)+theta(1399)*AB(3) ! ((0,2,3)|(2,0,1)) = ((0,2,4)|(2,0,0))+((0,2,3)|(2,0,0))*AB(3)
        theta(1984) = theta(1528)+theta(1402)*AB(1) ! ((0,2,3)|(1,2,0)) = ((1,2,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(1)
        theta(1985) = theta(1529)+theta(1403)*AB(1) ! ((0,2,3)|(1,1,1)) = ((1,2,3)|(0,1,1))+((0,2,3)|(0,1,1))*AB(1)
        theta(1986) = theta(1530)+theta(1404)*AB(1) ! ((0,2,3)|(1,0,2)) = ((1,2,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(1)
        theta(1987) = theta(1564)+theta(1402)*AB(2) ! ((0,2,3)|(0,3,0)) = ((0,3,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(2)
        theta(1988) = theta(1570)+theta(1402)*AB(3) ! ((0,2,3)|(0,2,1)) = ((0,2,4)|(0,2,0))+((0,2,3)|(0,2,0))*AB(3)
        theta(1989) = theta(1566)+theta(1404)*AB(2) ! ((0,2,3)|(0,1,2)) = ((0,3,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(2)
        theta(1990) = theta(1572)+theta(1404)*AB(3) ! ((0,2,3)|(0,0,3)) = ((0,2,4)|(0,0,2))+((0,2,3)|(0,0,2))*AB(3)
        theta(1991) = theta(1531)+theta(1405)*AB(1) ! ((0,1,4)|(3,0,0)) = ((1,1,4)|(2,0,0))+((0,1,4)|(2,0,0))*AB(1)
        theta(1992) = theta(1532)+theta(1406)*AB(1) ! ((0,1,4)|(2,1,0)) = ((1,1,4)|(1,1,0))+((0,1,4)|(1,1,0))*AB(1)
        ! theta(1993) = theta(1573)+theta(1405)*AB(3) ! ((0,1,4)|(2,0,1)) = ((0,1,5)|(2,0,0))+((0,1,4)|(2,0,0))*AB(3)
        theta(1994) = theta(1534)+theta(1408)*AB(1) ! ((0,1,4)|(1,2,0)) = ((1,1,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(1)
        theta(1995) = theta(1535)+theta(1409)*AB(1) ! ((0,1,4)|(1,1,1)) = ((1,1,4)|(0,1,1))+((0,1,4)|(0,1,1))*AB(1)
        theta(1996) = theta(1536)+theta(1410)*AB(1) ! ((0,1,4)|(1,0,2)) = ((1,1,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(1)
        theta(1997) = theta(1570)+theta(1408)*AB(2) ! ((0,1,4)|(0,3,0)) = ((0,2,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(2)
        theta(1998) = theta(1576)+theta(1408)*AB(3) ! ((0,1,4)|(0,2,1)) = ((0,1,5)|(0,2,0))+((0,1,4)|(0,2,0))*AB(3)
        theta(1999) = theta(1572)+theta(1410)*AB(2) ! ((0,1,4)|(0,1,2)) = ((0,2,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(2)
        theta(2000) = theta(1578)+theta(1410)*AB(3) ! ((0,1,4)|(0,0,3)) = ((0,1,5)|(0,0,2))+((0,1,4)|(0,0,2))*AB(3)
        theta(2001) = theta(1537)+theta(1411)*AB(1) ! ((0,0,5)|(3,0,0)) = ((1,0,5)|(2,0,0))+((0,0,5)|(2,0,0))*AB(1)
        theta(2002) = theta(1538)+theta(1412)*AB(1) ! ((0,0,5)|(2,1,0)) = ((1,0,5)|(1,1,0))+((0,0,5)|(1,1,0))*AB(1)
        ! theta(2003) = theta(1579)+theta(1411)*AB(3) ! ((0,0,5)|(2,0,1)) = ((0,0,6)|(2,0,0))+((0,0,5)|(2,0,0))*AB(3)
        theta(2004) = theta(1540)+theta(1414)*AB(1) ! ((0,0,5)|(1,2,0)) = ((1,0,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(1)
        theta(2005) = theta(1541)+theta(1415)*AB(1) ! ((0,0,5)|(1,1,1)) = ((1,0,5)|(0,1,1))+((0,0,5)|(0,1,1))*AB(1)
        theta(2006) = theta(1542)+theta(1416)*AB(1) ! ((0,0,5)|(1,0,2)) = ((1,0,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(1)
        theta(2007) = theta(1576)+theta(1414)*AB(2) ! ((0,0,5)|(0,3,0)) = ((0,1,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(2)
        theta(2008) = theta(1582)+theta(1414)*AB(3) ! ((0,0,5)|(0,2,1)) = ((0,0,6)|(0,2,0))+((0,0,5)|(0,2,0))*AB(3)
        theta(2009) = theta(1578)+theta(1416)*AB(2) ! ((0,0,5)|(0,1,2)) = ((0,1,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(2)
        theta(2010) = theta(1584)+theta(1416)*AB(3) ! ((0,0,5)|(0,0,3)) = ((0,0,6)|(0,0,2))+((0,0,5)|(0,0,2))*AB(3)
        theta(2011) = theta(1585)+theta(1417)*AB(1) ! ((6,0,0)|(3,0,0)) = ((7,0,0)|(2,0,0))+((6,0,0)|(2,0,0))*AB(1)
        ! theta(2012) = theta(1591)+theta(1417)*AB(2) ! ((6,0,0)|(2,1,0)) = ((6,1,0)|(2,0,0))+((6,0,0)|(2,0,0))*AB(2)
        ! theta(2013) = theta(1597)+theta(1417)*AB(3) ! ((6,0,0)|(2,0,1)) = ((6,0,1)|(2,0,0))+((6,0,0)|(2,0,0))*AB(3)
        theta(2014) = theta(1588)+theta(1420)*AB(1) ! ((6,0,0)|(1,2,0)) = ((7,0,0)|(0,2,0))+((6,0,0)|(0,2,0))*AB(1)
        ! theta(2015) = theta(1589)+theta(1421)*AB(1) ! ((6,0,0)|(1,1,1)) = ((7,0,0)|(0,1,1))+((6,0,0)|(0,1,1))*AB(1)
        theta(2016) = theta(1590)+theta(1422)*AB(1) ! ((6,0,0)|(1,0,2)) = ((7,0,0)|(0,0,2))+((6,0,0)|(0,0,2))*AB(1)
        theta(2017) = theta(1594)+theta(1420)*AB(2) ! ((6,0,0)|(0,3,0)) = ((6,1,0)|(0,2,0))+((6,0,0)|(0,2,0))*AB(2)
        theta(2018) = theta(1600)+theta(1420)*AB(3) ! ((6,0,0)|(0,2,1)) = ((6,0,1)|(0,2,0))+((6,0,0)|(0,2,0))*AB(3)
        theta(2019) = theta(1596)+theta(1422)*AB(2) ! ((6,0,0)|(0,1,2)) = ((6,1,0)|(0,0,2))+((6,0,0)|(0,0,2))*AB(2)
        theta(2020) = theta(1602)+theta(1422)*AB(3) ! ((6,0,0)|(0,0,3)) = ((6,0,1)|(0,0,2))+((6,0,0)|(0,0,2))*AB(3)
        theta(2021) = theta(1591)+theta(1423)*AB(1) ! ((5,1,0)|(3,0,0)) = ((6,1,0)|(2,0,0))+((5,1,0)|(2,0,0))*AB(1)
        ! theta(2022) = theta(1603)+theta(1423)*AB(2) ! ((5,1,0)|(2,1,0)) = ((5,2,0)|(2,0,0))+((5,1,0)|(2,0,0))*AB(2)
        theta(2023) = theta(1609)+theta(1423)*AB(3) ! ((5,1,0)|(2,0,1)) = ((5,1,1)|(2,0,0))+((5,1,0)|(2,0,0))*AB(3)
        theta(2024) = theta(1594)+theta(1426)*AB(1) ! ((5,1,0)|(1,2,0)) = ((6,1,0)|(0,2,0))+((5,1,0)|(0,2,0))*AB(1)
        ! theta(2025) = theta(1595)+theta(1427)*AB(1) ! ((5,1,0)|(1,1,1)) = ((6,1,0)|(0,1,1))+((5,1,0)|(0,1,1))*AB(1)
        theta(2026) = theta(1596)+theta(1428)*AB(1) ! ((5,1,0)|(1,0,2)) = ((6,1,0)|(0,0,2))+((5,1,0)|(0,0,2))*AB(1)
        theta(2027) = theta(1606)+theta(1426)*AB(2) ! ((5,1,0)|(0,3,0)) = ((5,2,0)|(0,2,0))+((5,1,0)|(0,2,0))*AB(2)
        theta(2028) = theta(1612)+theta(1426)*AB(3) ! ((5,1,0)|(0,2,1)) = ((5,1,1)|(0,2,0))+((5,1,0)|(0,2,0))*AB(3)
        theta(2029) = theta(1608)+theta(1428)*AB(2) ! ((5,1,0)|(0,1,2)) = ((5,2,0)|(0,0,2))+((5,1,0)|(0,0,2))*AB(2)
        theta(2030) = theta(1614)+theta(1428)*AB(3) ! ((5,1,0)|(0,0,3)) = ((5,1,1)|(0,0,2))+((5,1,0)|(0,0,2))*AB(3)
        theta(2031) = theta(1597)+theta(1429)*AB(1) ! ((5,0,1)|(3,0,0)) = ((6,0,1)|(2,0,0))+((5,0,1)|(2,0,0))*AB(1)
        theta(2032) = theta(1598)+theta(1430)*AB(1) ! ((5,0,1)|(2,1,0)) = ((6,0,1)|(1,1,0))+((5,0,1)|(1,1,0))*AB(1)
        ! theta(2033) = theta(1615)+theta(1429)*AB(3) ! ((5,0,1)|(2,0,1)) = ((5,0,2)|(2,0,0))+((5,0,1)|(2,0,0))*AB(3)
        theta(2034) = theta(1600)+theta(1432)*AB(1) ! ((5,0,1)|(1,2,0)) = ((6,0,1)|(0,2,0))+((5,0,1)|(0,2,0))*AB(1)
        theta(2035) = theta(1601)+theta(1433)*AB(1) ! ((5,0,1)|(1,1,1)) = ((6,0,1)|(0,1,1))+((5,0,1)|(0,1,1))*AB(1)
        theta(2036) = theta(1602)+theta(1434)*AB(1) ! ((5,0,1)|(1,0,2)) = ((6,0,1)|(0,0,2))+((5,0,1)|(0,0,2))*AB(1)
        theta(2037) = theta(1612)+theta(1432)*AB(2) ! ((5,0,1)|(0,3,0)) = ((5,1,1)|(0,2,0))+((5,0,1)|(0,2,0))*AB(2)
        theta(2038) = theta(1618)+theta(1432)*AB(3) ! ((5,0,1)|(0,2,1)) = ((5,0,2)|(0,2,0))+((5,0,1)|(0,2,0))*AB(3)
        theta(2039) = theta(1614)+theta(1434)*AB(2) ! ((5,0,1)|(0,1,2)) = ((5,1,1)|(0,0,2))+((5,0,1)|(0,0,2))*AB(2)
        theta(2040) = theta(1620)+theta(1434)*AB(3) ! ((5,0,1)|(0,0,3)) = ((5,0,2)|(0,0,2))+((5,0,1)|(0,0,2))*AB(3)
        theta(2041) = theta(1603)+theta(1435)*AB(1) ! ((4,2,0)|(3,0,0)) = ((5,2,0)|(2,0,0))+((4,2,0)|(2,0,0))*AB(1)
        ! theta(2042) = theta(1621)+theta(1435)*AB(2) ! ((4,2,0)|(2,1,0)) = ((4,3,0)|(2,0,0))+((4,2,0)|(2,0,0))*AB(2)
        theta(2043) = theta(1627)+theta(1435)*AB(3) ! ((4,2,0)|(2,0,1)) = ((4,2,1)|(2,0,0))+((4,2,0)|(2,0,0))*AB(3)
        theta(2044) = theta(1606)+theta(1438)*AB(1) ! ((4,2,0)|(1,2,0)) = ((5,2,0)|(0,2,0))+((4,2,0)|(0,2,0))*AB(1)
        ! theta(2045) = theta(1607)+theta(1439)*AB(1) ! ((4,2,0)|(1,1,1)) = ((5,2,0)|(0,1,1))+((4,2,0)|(0,1,1))*AB(1)
        theta(2046) = theta(1608)+theta(1440)*AB(1) ! ((4,2,0)|(1,0,2)) = ((5,2,0)|(0,0,2))+((4,2,0)|(0,0,2))*AB(1)
        theta(2047) = theta(1624)+theta(1438)*AB(2) ! ((4,2,0)|(0,3,0)) = ((4,3,0)|(0,2,0))+((4,2,0)|(0,2,0))*AB(2)
        theta(2048) = theta(1630)+theta(1438)*AB(3) ! ((4,2,0)|(0,2,1)) = ((4,2,1)|(0,2,0))+((4,2,0)|(0,2,0))*AB(3)
        theta(2049) = theta(1626)+theta(1440)*AB(2) ! ((4,2,0)|(0,1,2)) = ((4,3,0)|(0,0,2))+((4,2,0)|(0,0,2))*AB(2)
        theta(2050) = theta(1632)+theta(1440)*AB(3) ! ((4,2,0)|(0,0,3)) = ((4,2,1)|(0,0,2))+((4,2,0)|(0,0,2))*AB(3)
        theta(2051) = theta(1609)+theta(1441)*AB(1) ! ((4,1,1)|(3,0,0)) = ((5,1,1)|(2,0,0))+((4,1,1)|(2,0,0))*AB(1)
        theta(2052) = theta(1610)+theta(1442)*AB(1) ! ((4,1,1)|(2,1,0)) = ((5,1,1)|(1,1,0))+((4,1,1)|(1,1,0))*AB(1)
        ! theta(2053) = theta(1633)+theta(1441)*AB(3) ! ((4,1,1)|(2,0,1)) = ((4,1,2)|(2,0,0))+((4,1,1)|(2,0,0))*AB(3)
        theta(2054) = theta(1612)+theta(1444)*AB(1) ! ((4,1,1)|(1,2,0)) = ((5,1,1)|(0,2,0))+((4,1,1)|(0,2,0))*AB(1)
        theta(2055) = theta(1613)+theta(1445)*AB(1) ! ((4,1,1)|(1,1,1)) = ((5,1,1)|(0,1,1))+((4,1,1)|(0,1,1))*AB(1)
        theta(2056) = theta(1614)+theta(1446)*AB(1) ! ((4,1,1)|(1,0,2)) = ((5,1,1)|(0,0,2))+((4,1,1)|(0,0,2))*AB(1)
        theta(2057) = theta(1630)+theta(1444)*AB(2) ! ((4,1,1)|(0,3,0)) = ((4,2,1)|(0,2,0))+((4,1,1)|(0,2,0))*AB(2)
        theta(2058) = theta(1636)+theta(1444)*AB(3) ! ((4,1,1)|(0,2,1)) = ((4,1,2)|(0,2,0))+((4,1,1)|(0,2,0))*AB(3)
        theta(2059) = theta(1632)+theta(1446)*AB(2) ! ((4,1,1)|(0,1,2)) = ((4,2,1)|(0,0,2))+((4,1,1)|(0,0,2))*AB(2)
        theta(2060) = theta(1638)+theta(1446)*AB(3) ! ((4,1,1)|(0,0,3)) = ((4,1,2)|(0,0,2))+((4,1,1)|(0,0,2))*AB(3)
        theta(2061) = theta(1615)+theta(1447)*AB(1) ! ((4,0,2)|(3,0,0)) = ((5,0,2)|(2,0,0))+((4,0,2)|(2,0,0))*AB(1)
        theta(2062) = theta(1616)+theta(1448)*AB(1) ! ((4,0,2)|(2,1,0)) = ((5,0,2)|(1,1,0))+((4,0,2)|(1,1,0))*AB(1)
        ! theta(2063) = theta(1639)+theta(1447)*AB(3) ! ((4,0,2)|(2,0,1)) = ((4,0,3)|(2,0,0))+((4,0,2)|(2,0,0))*AB(3)
        theta(2064) = theta(1618)+theta(1450)*AB(1) ! ((4,0,2)|(1,2,0)) = ((5,0,2)|(0,2,0))+((4,0,2)|(0,2,0))*AB(1)
        theta(2065) = theta(1619)+theta(1451)*AB(1) ! ((4,0,2)|(1,1,1)) = ((5,0,2)|(0,1,1))+((4,0,2)|(0,1,1))*AB(1)
        theta(2066) = theta(1620)+theta(1452)*AB(1) ! ((4,0,2)|(1,0,2)) = ((5,0,2)|(0,0,2))+((4,0,2)|(0,0,2))*AB(1)
        theta(2067) = theta(1636)+theta(1450)*AB(2) ! ((4,0,2)|(0,3,0)) = ((4,1,2)|(0,2,0))+((4,0,2)|(0,2,0))*AB(2)
        theta(2068) = theta(1642)+theta(1450)*AB(3) ! ((4,0,2)|(0,2,1)) = ((4,0,3)|(0,2,0))+((4,0,2)|(0,2,0))*AB(3)
        theta(2069) = theta(1638)+theta(1452)*AB(2) ! ((4,0,2)|(0,1,2)) = ((4,1,2)|(0,0,2))+((4,0,2)|(0,0,2))*AB(2)
        theta(2070) = theta(1644)+theta(1452)*AB(3) ! ((4,0,2)|(0,0,3)) = ((4,0,3)|(0,0,2))+((4,0,2)|(0,0,2))*AB(3)
        theta(2071) = theta(1621)+theta(1453)*AB(1) ! ((3,3,0)|(3,0,0)) = ((4,3,0)|(2,0,0))+((3,3,0)|(2,0,0))*AB(1)
        ! theta(2072) = theta(1645)+theta(1453)*AB(2) ! ((3,3,0)|(2,1,0)) = ((3,4,0)|(2,0,0))+((3,3,0)|(2,0,0))*AB(2)
        theta(2073) = theta(1651)+theta(1453)*AB(3) ! ((3,3,0)|(2,0,1)) = ((3,3,1)|(2,0,0))+((3,3,0)|(2,0,0))*AB(3)
        theta(2074) = theta(1624)+theta(1456)*AB(1) ! ((3,3,0)|(1,2,0)) = ((4,3,0)|(0,2,0))+((3,3,0)|(0,2,0))*AB(1)
        ! theta(2075) = theta(1625)+theta(1457)*AB(1) ! ((3,3,0)|(1,1,1)) = ((4,3,0)|(0,1,1))+((3,3,0)|(0,1,1))*AB(1)
        theta(2076) = theta(1626)+theta(1458)*AB(1) ! ((3,3,0)|(1,0,2)) = ((4,3,0)|(0,0,2))+((3,3,0)|(0,0,2))*AB(1)
        theta(2077) = theta(1648)+theta(1456)*AB(2) ! ((3,3,0)|(0,3,0)) = ((3,4,0)|(0,2,0))+((3,3,0)|(0,2,0))*AB(2)
        theta(2078) = theta(1654)+theta(1456)*AB(3) ! ((3,3,0)|(0,2,1)) = ((3,3,1)|(0,2,0))+((3,3,0)|(0,2,0))*AB(3)
        theta(2079) = theta(1650)+theta(1458)*AB(2) ! ((3,3,0)|(0,1,2)) = ((3,4,0)|(0,0,2))+((3,3,0)|(0,0,2))*AB(2)
        theta(2080) = theta(1656)+theta(1458)*AB(3) ! ((3,3,0)|(0,0,3)) = ((3,3,1)|(0,0,2))+((3,3,0)|(0,0,2))*AB(3)
        theta(2081) = theta(1627)+theta(1459)*AB(1) ! ((3,2,1)|(3,0,0)) = ((4,2,1)|(2,0,0))+((3,2,1)|(2,0,0))*AB(1)
        theta(2082) = theta(1628)+theta(1460)*AB(1) ! ((3,2,1)|(2,1,0)) = ((4,2,1)|(1,1,0))+((3,2,1)|(1,1,0))*AB(1)
        ! theta(2083) = theta(1657)+theta(1459)*AB(3) ! ((3,2,1)|(2,0,1)) = ((3,2,2)|(2,0,0))+((3,2,1)|(2,0,0))*AB(3)
        theta(2084) = theta(1630)+theta(1462)*AB(1) ! ((3,2,1)|(1,2,0)) = ((4,2,1)|(0,2,0))+((3,2,1)|(0,2,0))*AB(1)
        theta(2085) = theta(1631)+theta(1463)*AB(1) ! ((3,2,1)|(1,1,1)) = ((4,2,1)|(0,1,1))+((3,2,1)|(0,1,1))*AB(1)
        theta(2086) = theta(1632)+theta(1464)*AB(1) ! ((3,2,1)|(1,0,2)) = ((4,2,1)|(0,0,2))+((3,2,1)|(0,0,2))*AB(1)
        theta(2087) = theta(1654)+theta(1462)*AB(2) ! ((3,2,1)|(0,3,0)) = ((3,3,1)|(0,2,0))+((3,2,1)|(0,2,0))*AB(2)
        theta(2088) = theta(1660)+theta(1462)*AB(3) ! ((3,2,1)|(0,2,1)) = ((3,2,2)|(0,2,0))+((3,2,1)|(0,2,0))*AB(3)
        theta(2089) = theta(1656)+theta(1464)*AB(2) ! ((3,2,1)|(0,1,2)) = ((3,3,1)|(0,0,2))+((3,2,1)|(0,0,2))*AB(2)
        theta(2090) = theta(1662)+theta(1464)*AB(3) ! ((3,2,1)|(0,0,3)) = ((3,2,2)|(0,0,2))+((3,2,1)|(0,0,2))*AB(3)
        theta(2091) = theta(1633)+theta(1465)*AB(1) ! ((3,1,2)|(3,0,0)) = ((4,1,2)|(2,0,0))+((3,1,2)|(2,0,0))*AB(1)
        theta(2092) = theta(1634)+theta(1466)*AB(1) ! ((3,1,2)|(2,1,0)) = ((4,1,2)|(1,1,0))+((3,1,2)|(1,1,0))*AB(1)
        ! theta(2093) = theta(1663)+theta(1465)*AB(3) ! ((3,1,2)|(2,0,1)) = ((3,1,3)|(2,0,0))+((3,1,2)|(2,0,0))*AB(3)
        theta(2094) = theta(1636)+theta(1468)*AB(1) ! ((3,1,2)|(1,2,0)) = ((4,1,2)|(0,2,0))+((3,1,2)|(0,2,0))*AB(1)
        theta(2095) = theta(1637)+theta(1469)*AB(1) ! ((3,1,2)|(1,1,1)) = ((4,1,2)|(0,1,1))+((3,1,2)|(0,1,1))*AB(1)
        theta(2096) = theta(1638)+theta(1470)*AB(1) ! ((3,1,2)|(1,0,2)) = ((4,1,2)|(0,0,2))+((3,1,2)|(0,0,2))*AB(1)
        theta(2097) = theta(1660)+theta(1468)*AB(2) ! ((3,1,2)|(0,3,0)) = ((3,2,2)|(0,2,0))+((3,1,2)|(0,2,0))*AB(2)
        theta(2098) = theta(1666)+theta(1468)*AB(3) ! ((3,1,2)|(0,2,1)) = ((3,1,3)|(0,2,0))+((3,1,2)|(0,2,0))*AB(3)
        theta(2099) = theta(1662)+theta(1470)*AB(2) ! ((3,1,2)|(0,1,2)) = ((3,2,2)|(0,0,2))+((3,1,2)|(0,0,2))*AB(2)
        theta(2100) = theta(1668)+theta(1470)*AB(3) ! ((3,1,2)|(0,0,3)) = ((3,1,3)|(0,0,2))+((3,1,2)|(0,0,2))*AB(3)
        theta(2101) = theta(1639)+theta(1471)*AB(1) ! ((3,0,3)|(3,0,0)) = ((4,0,3)|(2,0,0))+((3,0,3)|(2,0,0))*AB(1)
        theta(2102) = theta(1640)+theta(1472)*AB(1) ! ((3,0,3)|(2,1,0)) = ((4,0,3)|(1,1,0))+((3,0,3)|(1,1,0))*AB(1)
        ! theta(2103) = theta(1669)+theta(1471)*AB(3) ! ((3,0,3)|(2,0,1)) = ((3,0,4)|(2,0,0))+((3,0,3)|(2,0,0))*AB(3)
        theta(2104) = theta(1642)+theta(1474)*AB(1) ! ((3,0,3)|(1,2,0)) = ((4,0,3)|(0,2,0))+((3,0,3)|(0,2,0))*AB(1)
        theta(2105) = theta(1643)+theta(1475)*AB(1) ! ((3,0,3)|(1,1,1)) = ((4,0,3)|(0,1,1))+((3,0,3)|(0,1,1))*AB(1)
        theta(2106) = theta(1644)+theta(1476)*AB(1) ! ((3,0,3)|(1,0,2)) = ((4,0,3)|(0,0,2))+((3,0,3)|(0,0,2))*AB(1)
        theta(2107) = theta(1666)+theta(1474)*AB(2) ! ((3,0,3)|(0,3,0)) = ((3,1,3)|(0,2,0))+((3,0,3)|(0,2,0))*AB(2)
        theta(2108) = theta(1672)+theta(1474)*AB(3) ! ((3,0,3)|(0,2,1)) = ((3,0,4)|(0,2,0))+((3,0,3)|(0,2,0))*AB(3)
        theta(2109) = theta(1668)+theta(1476)*AB(2) ! ((3,0,3)|(0,1,2)) = ((3,1,3)|(0,0,2))+((3,0,3)|(0,0,2))*AB(2)
        theta(2110) = theta(1674)+theta(1476)*AB(3) ! ((3,0,3)|(0,0,3)) = ((3,0,4)|(0,0,2))+((3,0,3)|(0,0,2))*AB(3)
        theta(2111) = theta(1645)+theta(1477)*AB(1) ! ((2,4,0)|(3,0,0)) = ((3,4,0)|(2,0,0))+((2,4,0)|(2,0,0))*AB(1)
        ! theta(2112) = theta(1675)+theta(1477)*AB(2) ! ((2,4,0)|(2,1,0)) = ((2,5,0)|(2,0,0))+((2,4,0)|(2,0,0))*AB(2)
        theta(2113) = theta(1681)+theta(1477)*AB(3) ! ((2,4,0)|(2,0,1)) = ((2,4,1)|(2,0,0))+((2,4,0)|(2,0,0))*AB(3)
        theta(2114) = theta(1648)+theta(1480)*AB(1) ! ((2,4,0)|(1,2,0)) = ((3,4,0)|(0,2,0))+((2,4,0)|(0,2,0))*AB(1)
        ! theta(2115) = theta(1649)+theta(1481)*AB(1) ! ((2,4,0)|(1,1,1)) = ((3,4,0)|(0,1,1))+((2,4,0)|(0,1,1))*AB(1)
        theta(2116) = theta(1650)+theta(1482)*AB(1) ! ((2,4,0)|(1,0,2)) = ((3,4,0)|(0,0,2))+((2,4,0)|(0,0,2))*AB(1)
        theta(2117) = theta(1678)+theta(1480)*AB(2) ! ((2,4,0)|(0,3,0)) = ((2,5,0)|(0,2,0))+((2,4,0)|(0,2,0))*AB(2)
        theta(2118) = theta(1684)+theta(1480)*AB(3) ! ((2,4,0)|(0,2,1)) = ((2,4,1)|(0,2,0))+((2,4,0)|(0,2,0))*AB(3)
        theta(2119) = theta(1680)+theta(1482)*AB(2) ! ((2,4,0)|(0,1,2)) = ((2,5,0)|(0,0,2))+((2,4,0)|(0,0,2))*AB(2)
        theta(2120) = theta(1686)+theta(1482)*AB(3) ! ((2,4,0)|(0,0,3)) = ((2,4,1)|(0,0,2))+((2,4,0)|(0,0,2))*AB(3)
        theta(2121) = theta(1651)+theta(1483)*AB(1) ! ((2,3,1)|(3,0,0)) = ((3,3,1)|(2,0,0))+((2,3,1)|(2,0,0))*AB(1)
        theta(2122) = theta(1652)+theta(1484)*AB(1) ! ((2,3,1)|(2,1,0)) = ((3,3,1)|(1,1,0))+((2,3,1)|(1,1,0))*AB(1)
        ! theta(2123) = theta(1687)+theta(1483)*AB(3) ! ((2,3,1)|(2,0,1)) = ((2,3,2)|(2,0,0))+((2,3,1)|(2,0,0))*AB(3)
        theta(2124) = theta(1654)+theta(1486)*AB(1) ! ((2,3,1)|(1,2,0)) = ((3,3,1)|(0,2,0))+((2,3,1)|(0,2,0))*AB(1)
        theta(2125) = theta(1655)+theta(1487)*AB(1) ! ((2,3,1)|(1,1,1)) = ((3,3,1)|(0,1,1))+((2,3,1)|(0,1,1))*AB(1)
        theta(2126) = theta(1656)+theta(1488)*AB(1) ! ((2,3,1)|(1,0,2)) = ((3,3,1)|(0,0,2))+((2,3,1)|(0,0,2))*AB(1)
        theta(2127) = theta(1684)+theta(1486)*AB(2) ! ((2,3,1)|(0,3,0)) = ((2,4,1)|(0,2,0))+((2,3,1)|(0,2,0))*AB(2)
        theta(2128) = theta(1690)+theta(1486)*AB(3) ! ((2,3,1)|(0,2,1)) = ((2,3,2)|(0,2,0))+((2,3,1)|(0,2,0))*AB(3)
        theta(2129) = theta(1686)+theta(1488)*AB(2) ! ((2,3,1)|(0,1,2)) = ((2,4,1)|(0,0,2))+((2,3,1)|(0,0,2))*AB(2)
        theta(2130) = theta(1692)+theta(1488)*AB(3) ! ((2,3,1)|(0,0,3)) = ((2,3,2)|(0,0,2))+((2,3,1)|(0,0,2))*AB(3)
        theta(2131) = theta(1657)+theta(1489)*AB(1) ! ((2,2,2)|(3,0,0)) = ((3,2,2)|(2,0,0))+((2,2,2)|(2,0,0))*AB(1)
        theta(2132) = theta(1658)+theta(1490)*AB(1) ! ((2,2,2)|(2,1,0)) = ((3,2,2)|(1,1,0))+((2,2,2)|(1,1,0))*AB(1)
        ! theta(2133) = theta(1693)+theta(1489)*AB(3) ! ((2,2,2)|(2,0,1)) = ((2,2,3)|(2,0,0))+((2,2,2)|(2,0,0))*AB(3)
        theta(2134) = theta(1660)+theta(1492)*AB(1) ! ((2,2,2)|(1,2,0)) = ((3,2,2)|(0,2,0))+((2,2,2)|(0,2,0))*AB(1)
        theta(2135) = theta(1661)+theta(1493)*AB(1) ! ((2,2,2)|(1,1,1)) = ((3,2,2)|(0,1,1))+((2,2,2)|(0,1,1))*AB(1)
        theta(2136) = theta(1662)+theta(1494)*AB(1) ! ((2,2,2)|(1,0,2)) = ((3,2,2)|(0,0,2))+((2,2,2)|(0,0,2))*AB(1)
        theta(2137) = theta(1690)+theta(1492)*AB(2) ! ((2,2,2)|(0,3,0)) = ((2,3,2)|(0,2,0))+((2,2,2)|(0,2,0))*AB(2)
        theta(2138) = theta(1696)+theta(1492)*AB(3) ! ((2,2,2)|(0,2,1)) = ((2,2,3)|(0,2,0))+((2,2,2)|(0,2,0))*AB(3)
        theta(2139) = theta(1692)+theta(1494)*AB(2) ! ((2,2,2)|(0,1,2)) = ((2,3,2)|(0,0,2))+((2,2,2)|(0,0,2))*AB(2)
        theta(2140) = theta(1698)+theta(1494)*AB(3) ! ((2,2,2)|(0,0,3)) = ((2,2,3)|(0,0,2))+((2,2,2)|(0,0,2))*AB(3)
        theta(2141) = theta(1663)+theta(1495)*AB(1) ! ((2,1,3)|(3,0,0)) = ((3,1,3)|(2,0,0))+((2,1,3)|(2,0,0))*AB(1)
        theta(2142) = theta(1664)+theta(1496)*AB(1) ! ((2,1,3)|(2,1,0)) = ((3,1,3)|(1,1,0))+((2,1,3)|(1,1,0))*AB(1)
        ! theta(2143) = theta(1699)+theta(1495)*AB(3) ! ((2,1,3)|(2,0,1)) = ((2,1,4)|(2,0,0))+((2,1,3)|(2,0,0))*AB(3)
        theta(2144) = theta(1666)+theta(1498)*AB(1) ! ((2,1,3)|(1,2,0)) = ((3,1,3)|(0,2,0))+((2,1,3)|(0,2,0))*AB(1)
        theta(2145) = theta(1667)+theta(1499)*AB(1) ! ((2,1,3)|(1,1,1)) = ((3,1,3)|(0,1,1))+((2,1,3)|(0,1,1))*AB(1)
        theta(2146) = theta(1668)+theta(1500)*AB(1) ! ((2,1,3)|(1,0,2)) = ((3,1,3)|(0,0,2))+((2,1,3)|(0,0,2))*AB(1)
        theta(2147) = theta(1696)+theta(1498)*AB(2) ! ((2,1,3)|(0,3,0)) = ((2,2,3)|(0,2,0))+((2,1,3)|(0,2,0))*AB(2)
        theta(2148) = theta(1702)+theta(1498)*AB(3) ! ((2,1,3)|(0,2,1)) = ((2,1,4)|(0,2,0))+((2,1,3)|(0,2,0))*AB(3)
        theta(2149) = theta(1698)+theta(1500)*AB(2) ! ((2,1,3)|(0,1,2)) = ((2,2,3)|(0,0,2))+((2,1,3)|(0,0,2))*AB(2)
        theta(2150) = theta(1704)+theta(1500)*AB(3) ! ((2,1,3)|(0,0,3)) = ((2,1,4)|(0,0,2))+((2,1,3)|(0,0,2))*AB(3)
        theta(2151) = theta(1669)+theta(1501)*AB(1) ! ((2,0,4)|(3,0,0)) = ((3,0,4)|(2,0,0))+((2,0,4)|(2,0,0))*AB(1)
        theta(2152) = theta(1670)+theta(1502)*AB(1) ! ((2,0,4)|(2,1,0)) = ((3,0,4)|(1,1,0))+((2,0,4)|(1,1,0))*AB(1)
        ! theta(2153) = theta(1705)+theta(1501)*AB(3) ! ((2,0,4)|(2,0,1)) = ((2,0,5)|(2,0,0))+((2,0,4)|(2,0,0))*AB(3)
        theta(2154) = theta(1672)+theta(1504)*AB(1) ! ((2,0,4)|(1,2,0)) = ((3,0,4)|(0,2,0))+((2,0,4)|(0,2,0))*AB(1)
        theta(2155) = theta(1673)+theta(1505)*AB(1) ! ((2,0,4)|(1,1,1)) = ((3,0,4)|(0,1,1))+((2,0,4)|(0,1,1))*AB(1)
        theta(2156) = theta(1674)+theta(1506)*AB(1) ! ((2,0,4)|(1,0,2)) = ((3,0,4)|(0,0,2))+((2,0,4)|(0,0,2))*AB(1)
        theta(2157) = theta(1702)+theta(1504)*AB(2) ! ((2,0,4)|(0,3,0)) = ((2,1,4)|(0,2,0))+((2,0,4)|(0,2,0))*AB(2)
        theta(2158) = theta(1708)+theta(1504)*AB(3) ! ((2,0,4)|(0,2,1)) = ((2,0,5)|(0,2,0))+((2,0,4)|(0,2,0))*AB(3)
        theta(2159) = theta(1704)+theta(1506)*AB(2) ! ((2,0,4)|(0,1,2)) = ((2,1,4)|(0,0,2))+((2,0,4)|(0,0,2))*AB(2)
        theta(2160) = theta(1710)+theta(1506)*AB(3) ! ((2,0,4)|(0,0,3)) = ((2,0,5)|(0,0,2))+((2,0,4)|(0,0,2))*AB(3)
        theta(2161) = theta(1675)+theta(1507)*AB(1) ! ((1,5,0)|(3,0,0)) = ((2,5,0)|(2,0,0))+((1,5,0)|(2,0,0))*AB(1)
        ! theta(2162) = theta(1711)+theta(1507)*AB(2) ! ((1,5,0)|(2,1,0)) = ((1,6,0)|(2,0,0))+((1,5,0)|(2,0,0))*AB(2)
        theta(2163) = theta(1717)+theta(1507)*AB(3) ! ((1,5,0)|(2,0,1)) = ((1,5,1)|(2,0,0))+((1,5,0)|(2,0,0))*AB(3)
        theta(2164) = theta(1678)+theta(1510)*AB(1) ! ((1,5,0)|(1,2,0)) = ((2,5,0)|(0,2,0))+((1,5,0)|(0,2,0))*AB(1)
        ! theta(2165) = theta(1679)+theta(1511)*AB(1) ! ((1,5,0)|(1,1,1)) = ((2,5,0)|(0,1,1))+((1,5,0)|(0,1,1))*AB(1)
        theta(2166) = theta(1680)+theta(1512)*AB(1) ! ((1,5,0)|(1,0,2)) = ((2,5,0)|(0,0,2))+((1,5,0)|(0,0,2))*AB(1)
        theta(2167) = theta(1714)+theta(1510)*AB(2) ! ((1,5,0)|(0,3,0)) = ((1,6,0)|(0,2,0))+((1,5,0)|(0,2,0))*AB(2)
        theta(2168) = theta(1720)+theta(1510)*AB(3) ! ((1,5,0)|(0,2,1)) = ((1,5,1)|(0,2,0))+((1,5,0)|(0,2,0))*AB(3)
        theta(2169) = theta(1716)+theta(1512)*AB(2) ! ((1,5,0)|(0,1,2)) = ((1,6,0)|(0,0,2))+((1,5,0)|(0,0,2))*AB(2)
        theta(2170) = theta(1722)+theta(1512)*AB(3) ! ((1,5,0)|(0,0,3)) = ((1,5,1)|(0,0,2))+((1,5,0)|(0,0,2))*AB(3)
        theta(2171) = theta(1681)+theta(1513)*AB(1) ! ((1,4,1)|(3,0,0)) = ((2,4,1)|(2,0,0))+((1,4,1)|(2,0,0))*AB(1)
        theta(2172) = theta(1682)+theta(1514)*AB(1) ! ((1,4,1)|(2,1,0)) = ((2,4,1)|(1,1,0))+((1,4,1)|(1,1,0))*AB(1)
        ! theta(2173) = theta(1723)+theta(1513)*AB(3) ! ((1,4,1)|(2,0,1)) = ((1,4,2)|(2,0,0))+((1,4,1)|(2,0,0))*AB(3)
        theta(2174) = theta(1684)+theta(1516)*AB(1) ! ((1,4,1)|(1,2,0)) = ((2,4,1)|(0,2,0))+((1,4,1)|(0,2,0))*AB(1)
        theta(2175) = theta(1685)+theta(1517)*AB(1) ! ((1,4,1)|(1,1,1)) = ((2,4,1)|(0,1,1))+((1,4,1)|(0,1,1))*AB(1)
        theta(2176) = theta(1686)+theta(1518)*AB(1) ! ((1,4,1)|(1,0,2)) = ((2,4,1)|(0,0,2))+((1,4,1)|(0,0,2))*AB(1)
        theta(2177) = theta(1720)+theta(1516)*AB(2) ! ((1,4,1)|(0,3,0)) = ((1,5,1)|(0,2,0))+((1,4,1)|(0,2,0))*AB(2)
        theta(2178) = theta(1726)+theta(1516)*AB(3) ! ((1,4,1)|(0,2,1)) = ((1,4,2)|(0,2,0))+((1,4,1)|(0,2,0))*AB(3)
        theta(2179) = theta(1722)+theta(1518)*AB(2) ! ((1,4,1)|(0,1,2)) = ((1,5,1)|(0,0,2))+((1,4,1)|(0,0,2))*AB(2)
        theta(2180) = theta(1728)+theta(1518)*AB(3) ! ((1,4,1)|(0,0,3)) = ((1,4,2)|(0,0,2))+((1,4,1)|(0,0,2))*AB(3)
        theta(2181) = theta(1687)+theta(1519)*AB(1) ! ((1,3,2)|(3,0,0)) = ((2,3,2)|(2,0,0))+((1,3,2)|(2,0,0))*AB(1)
        theta(2182) = theta(1688)+theta(1520)*AB(1) ! ((1,3,2)|(2,1,0)) = ((2,3,2)|(1,1,0))+((1,3,2)|(1,1,0))*AB(1)
        ! theta(2183) = theta(1729)+theta(1519)*AB(3) ! ((1,3,2)|(2,0,1)) = ((1,3,3)|(2,0,0))+((1,3,2)|(2,0,0))*AB(3)
        theta(2184) = theta(1690)+theta(1522)*AB(1) ! ((1,3,2)|(1,2,0)) = ((2,3,2)|(0,2,0))+((1,3,2)|(0,2,0))*AB(1)
        theta(2185) = theta(1691)+theta(1523)*AB(1) ! ((1,3,2)|(1,1,1)) = ((2,3,2)|(0,1,1))+((1,3,2)|(0,1,1))*AB(1)
        theta(2186) = theta(1692)+theta(1524)*AB(1) ! ((1,3,2)|(1,0,2)) = ((2,3,2)|(0,0,2))+((1,3,2)|(0,0,2))*AB(1)
        theta(2187) = theta(1726)+theta(1522)*AB(2) ! ((1,3,2)|(0,3,0)) = ((1,4,2)|(0,2,0))+((1,3,2)|(0,2,0))*AB(2)
        theta(2188) = theta(1732)+theta(1522)*AB(3) ! ((1,3,2)|(0,2,1)) = ((1,3,3)|(0,2,0))+((1,3,2)|(0,2,0))*AB(3)
        theta(2189) = theta(1728)+theta(1524)*AB(2) ! ((1,3,2)|(0,1,2)) = ((1,4,2)|(0,0,2))+((1,3,2)|(0,0,2))*AB(2)
        theta(2190) = theta(1734)+theta(1524)*AB(3) ! ((1,3,2)|(0,0,3)) = ((1,3,3)|(0,0,2))+((1,3,2)|(0,0,2))*AB(3)
        theta(2191) = theta(1693)+theta(1525)*AB(1) ! ((1,2,3)|(3,0,0)) = ((2,2,3)|(2,0,0))+((1,2,3)|(2,0,0))*AB(1)
        theta(2192) = theta(1694)+theta(1526)*AB(1) ! ((1,2,3)|(2,1,0)) = ((2,2,3)|(1,1,0))+((1,2,3)|(1,1,0))*AB(1)
        ! theta(2193) = theta(1735)+theta(1525)*AB(3) ! ((1,2,3)|(2,0,1)) = ((1,2,4)|(2,0,0))+((1,2,3)|(2,0,0))*AB(3)
        theta(2194) = theta(1696)+theta(1528)*AB(1) ! ((1,2,3)|(1,2,0)) = ((2,2,3)|(0,2,0))+((1,2,3)|(0,2,0))*AB(1)
        theta(2195) = theta(1697)+theta(1529)*AB(1) ! ((1,2,3)|(1,1,1)) = ((2,2,3)|(0,1,1))+((1,2,3)|(0,1,1))*AB(1)
        theta(2196) = theta(1698)+theta(1530)*AB(1) ! ((1,2,3)|(1,0,2)) = ((2,2,3)|(0,0,2))+((1,2,3)|(0,0,2))*AB(1)
        theta(2197) = theta(1732)+theta(1528)*AB(2) ! ((1,2,3)|(0,3,0)) = ((1,3,3)|(0,2,0))+((1,2,3)|(0,2,0))*AB(2)
        theta(2198) = theta(1738)+theta(1528)*AB(3) ! ((1,2,3)|(0,2,1)) = ((1,2,4)|(0,2,0))+((1,2,3)|(0,2,0))*AB(3)
        theta(2199) = theta(1734)+theta(1530)*AB(2) ! ((1,2,3)|(0,1,2)) = ((1,3,3)|(0,0,2))+((1,2,3)|(0,0,2))*AB(2)
        theta(2200) = theta(1740)+theta(1530)*AB(3) ! ((1,2,3)|(0,0,3)) = ((1,2,4)|(0,0,2))+((1,2,3)|(0,0,2))*AB(3)
        theta(2201) = theta(1699)+theta(1531)*AB(1) ! ((1,1,4)|(3,0,0)) = ((2,1,4)|(2,0,0))+((1,1,4)|(2,0,0))*AB(1)
        theta(2202) = theta(1700)+theta(1532)*AB(1) ! ((1,1,4)|(2,1,0)) = ((2,1,4)|(1,1,0))+((1,1,4)|(1,1,0))*AB(1)
        ! theta(2203) = theta(1741)+theta(1531)*AB(3) ! ((1,1,4)|(2,0,1)) = ((1,1,5)|(2,0,0))+((1,1,4)|(2,0,0))*AB(3)
        theta(2204) = theta(1702)+theta(1534)*AB(1) ! ((1,1,4)|(1,2,0)) = ((2,1,4)|(0,2,0))+((1,1,4)|(0,2,0))*AB(1)
        theta(2205) = theta(1703)+theta(1535)*AB(1) ! ((1,1,4)|(1,1,1)) = ((2,1,4)|(0,1,1))+((1,1,4)|(0,1,1))*AB(1)
        theta(2206) = theta(1704)+theta(1536)*AB(1) ! ((1,1,4)|(1,0,2)) = ((2,1,4)|(0,0,2))+((1,1,4)|(0,0,2))*AB(1)
        theta(2207) = theta(1738)+theta(1534)*AB(2) ! ((1,1,4)|(0,3,0)) = ((1,2,4)|(0,2,0))+((1,1,4)|(0,2,0))*AB(2)
        theta(2208) = theta(1744)+theta(1534)*AB(3) ! ((1,1,4)|(0,2,1)) = ((1,1,5)|(0,2,0))+((1,1,4)|(0,2,0))*AB(3)
        theta(2209) = theta(1740)+theta(1536)*AB(2) ! ((1,1,4)|(0,1,2)) = ((1,2,4)|(0,0,2))+((1,1,4)|(0,0,2))*AB(2)
        theta(2210) = theta(1746)+theta(1536)*AB(3) ! ((1,1,4)|(0,0,3)) = ((1,1,5)|(0,0,2))+((1,1,4)|(0,0,2))*AB(3)
        theta(2211) = theta(1705)+theta(1537)*AB(1) ! ((1,0,5)|(3,0,0)) = ((2,0,5)|(2,0,0))+((1,0,5)|(2,0,0))*AB(1)
        theta(2212) = theta(1706)+theta(1538)*AB(1) ! ((1,0,5)|(2,1,0)) = ((2,0,5)|(1,1,0))+((1,0,5)|(1,1,0))*AB(1)
        ! theta(2213) = theta(1747)+theta(1537)*AB(3) ! ((1,0,5)|(2,0,1)) = ((1,0,6)|(2,0,0))+((1,0,5)|(2,0,0))*AB(3)
        theta(2214) = theta(1708)+theta(1540)*AB(1) ! ((1,0,5)|(1,2,0)) = ((2,0,5)|(0,2,0))+((1,0,5)|(0,2,0))*AB(1)
        theta(2215) = theta(1709)+theta(1541)*AB(1) ! ((1,0,5)|(1,1,1)) = ((2,0,5)|(0,1,1))+((1,0,5)|(0,1,1))*AB(1)
        theta(2216) = theta(1710)+theta(1542)*AB(1) ! ((1,0,5)|(1,0,2)) = ((2,0,5)|(0,0,2))+((1,0,5)|(0,0,2))*AB(1)
        theta(2217) = theta(1744)+theta(1540)*AB(2) ! ((1,0,5)|(0,3,0)) = ((1,1,5)|(0,2,0))+((1,0,5)|(0,2,0))*AB(2)
        theta(2218) = theta(1750)+theta(1540)*AB(3) ! ((1,0,5)|(0,2,1)) = ((1,0,6)|(0,2,0))+((1,0,5)|(0,2,0))*AB(3)
        theta(2219) = theta(1746)+theta(1542)*AB(2) ! ((1,0,5)|(0,1,2)) = ((1,1,5)|(0,0,2))+((1,0,5)|(0,0,2))*AB(2)
        theta(2220) = theta(1752)+theta(1542)*AB(3) ! ((1,0,5)|(0,0,3)) = ((1,0,6)|(0,0,2))+((1,0,5)|(0,0,2))*AB(3)
        theta(2221) = theta(1711)+theta(1543)*AB(1) ! ((0,6,0)|(3,0,0)) = ((1,6,0)|(2,0,0))+((0,6,0)|(2,0,0))*AB(1)
        ! theta(2222) = theta(1753)+theta(1543)*AB(2) ! ((0,6,0)|(2,1,0)) = ((0,7,0)|(2,0,0))+((0,6,0)|(2,0,0))*AB(2)
        theta(2223) = theta(1759)+theta(1543)*AB(3) ! ((0,6,0)|(2,0,1)) = ((0,6,1)|(2,0,0))+((0,6,0)|(2,0,0))*AB(3)
        ! theta(2224) = theta(1714)+theta(1546)*AB(1) ! ((0,6,0)|(1,2,0)) = ((1,6,0)|(0,2,0))+((0,6,0)|(0,2,0))*AB(1)
        ! theta(2225) = theta(1715)+theta(1547)*AB(1) ! ((0,6,0)|(1,1,1)) = ((1,6,0)|(0,1,1))+((0,6,0)|(0,1,1))*AB(1)
        ! theta(2226) = theta(1716)+theta(1548)*AB(1) ! ((0,6,0)|(1,0,2)) = ((1,6,0)|(0,0,2))+((0,6,0)|(0,0,2))*AB(1)
        theta(2227) = theta(1756)+theta(1546)*AB(2) ! ((0,6,0)|(0,3,0)) = ((0,7,0)|(0,2,0))+((0,6,0)|(0,2,0))*AB(2)
        ! theta(2228) = theta(1762)+theta(1546)*AB(3) ! ((0,6,0)|(0,2,1)) = ((0,6,1)|(0,2,0))+((0,6,0)|(0,2,0))*AB(3)
        theta(2229) = theta(1758)+theta(1548)*AB(2) ! ((0,6,0)|(0,1,2)) = ((0,7,0)|(0,0,2))+((0,6,0)|(0,0,2))*AB(2)
        theta(2230) = theta(1764)+theta(1548)*AB(3) ! ((0,6,0)|(0,0,3)) = ((0,6,1)|(0,0,2))+((0,6,0)|(0,0,2))*AB(3)
        theta(2231) = theta(1717)+theta(1549)*AB(1) ! ((0,5,1)|(3,0,0)) = ((1,5,1)|(2,0,0))+((0,5,1)|(2,0,0))*AB(1)
        ! theta(2232) = theta(1718)+theta(1550)*AB(1) ! ((0,5,1)|(2,1,0)) = ((1,5,1)|(1,1,0))+((0,5,1)|(1,1,0))*AB(1)
        ! theta(2233) = theta(1765)+theta(1549)*AB(3) ! ((0,5,1)|(2,0,1)) = ((0,5,2)|(2,0,0))+((0,5,1)|(2,0,0))*AB(3)
        ! theta(2234) = theta(1720)+theta(1552)*AB(1) ! ((0,5,1)|(1,2,0)) = ((1,5,1)|(0,2,0))+((0,5,1)|(0,2,0))*AB(1)
        ! theta(2235) = theta(1721)+theta(1553)*AB(1) ! ((0,5,1)|(1,1,1)) = ((1,5,1)|(0,1,1))+((0,5,1)|(0,1,1))*AB(1)
        ! theta(2236) = theta(1722)+theta(1554)*AB(1) ! ((0,5,1)|(1,0,2)) = ((1,5,1)|(0,0,2))+((0,5,1)|(0,0,2))*AB(1)
        theta(2237) = theta(1762)+theta(1552)*AB(2) ! ((0,5,1)|(0,3,0)) = ((0,6,1)|(0,2,0))+((0,5,1)|(0,2,0))*AB(2)
        ! theta(2238) = theta(1768)+theta(1552)*AB(3) ! ((0,5,1)|(0,2,1)) = ((0,5,2)|(0,2,0))+((0,5,1)|(0,2,0))*AB(3)
        theta(2239) = theta(1764)+theta(1554)*AB(2) ! ((0,5,1)|(0,1,2)) = ((0,6,1)|(0,0,2))+((0,5,1)|(0,0,2))*AB(2)
        theta(2240) = theta(1770)+theta(1554)*AB(3) ! ((0,5,1)|(0,0,3)) = ((0,5,2)|(0,0,2))+((0,5,1)|(0,0,2))*AB(3)
        theta(2241) = theta(1723)+theta(1555)*AB(1) ! ((0,4,2)|(3,0,0)) = ((1,4,2)|(2,0,0))+((0,4,2)|(2,0,0))*AB(1)
        ! theta(2242) = theta(1724)+theta(1556)*AB(1) ! ((0,4,2)|(2,1,0)) = ((1,4,2)|(1,1,0))+((0,4,2)|(1,1,0))*AB(1)
        ! theta(2243) = theta(1771)+theta(1555)*AB(3) ! ((0,4,2)|(2,0,1)) = ((0,4,3)|(2,0,0))+((0,4,2)|(2,0,0))*AB(3)
        ! theta(2244) = theta(1726)+theta(1558)*AB(1) ! ((0,4,2)|(1,2,0)) = ((1,4,2)|(0,2,0))+((0,4,2)|(0,2,0))*AB(1)
        ! theta(2245) = theta(1727)+theta(1559)*AB(1) ! ((0,4,2)|(1,1,1)) = ((1,4,2)|(0,1,1))+((0,4,2)|(0,1,1))*AB(1)
        ! theta(2246) = theta(1728)+theta(1560)*AB(1) ! ((0,4,2)|(1,0,2)) = ((1,4,2)|(0,0,2))+((0,4,2)|(0,0,2))*AB(1)
        theta(2247) = theta(1768)+theta(1558)*AB(2) ! ((0,4,2)|(0,3,0)) = ((0,5,2)|(0,2,0))+((0,4,2)|(0,2,0))*AB(2)
        ! theta(2248) = theta(1774)+theta(1558)*AB(3) ! ((0,4,2)|(0,2,1)) = ((0,4,3)|(0,2,0))+((0,4,2)|(0,2,0))*AB(3)
        theta(2249) = theta(1770)+theta(1560)*AB(2) ! ((0,4,2)|(0,1,2)) = ((0,5,2)|(0,0,2))+((0,4,2)|(0,0,2))*AB(2)
        theta(2250) = theta(1776)+theta(1560)*AB(3) ! ((0,4,2)|(0,0,3)) = ((0,4,3)|(0,0,2))+((0,4,2)|(0,0,2))*AB(3)
        theta(2251) = theta(1729)+theta(1561)*AB(1) ! ((0,3,3)|(3,0,0)) = ((1,3,3)|(2,0,0))+((0,3,3)|(2,0,0))*AB(1)
        ! theta(2252) = theta(1730)+theta(1562)*AB(1) ! ((0,3,3)|(2,1,0)) = ((1,3,3)|(1,1,0))+((0,3,3)|(1,1,0))*AB(1)
        ! theta(2253) = theta(1777)+theta(1561)*AB(3) ! ((0,3,3)|(2,0,1)) = ((0,3,4)|(2,0,0))+((0,3,3)|(2,0,0))*AB(3)
        ! theta(2254) = theta(1732)+theta(1564)*AB(1) ! ((0,3,3)|(1,2,0)) = ((1,3,3)|(0,2,0))+((0,3,3)|(0,2,0))*AB(1)
        ! theta(2255) = theta(1733)+theta(1565)*AB(1) ! ((0,3,3)|(1,1,1)) = ((1,3,3)|(0,1,1))+((0,3,3)|(0,1,1))*AB(1)
        ! theta(2256) = theta(1734)+theta(1566)*AB(1) ! ((0,3,3)|(1,0,2)) = ((1,3,3)|(0,0,2))+((0,3,3)|(0,0,2))*AB(1)
        theta(2257) = theta(1774)+theta(1564)*AB(2) ! ((0,3,3)|(0,3,0)) = ((0,4,3)|(0,2,0))+((0,3,3)|(0,2,0))*AB(2)
        ! theta(2258) = theta(1780)+theta(1564)*AB(3) ! ((0,3,3)|(0,2,1)) = ((0,3,4)|(0,2,0))+((0,3,3)|(0,2,0))*AB(3)
        theta(2259) = theta(1776)+theta(1566)*AB(2) ! ((0,3,3)|(0,1,2)) = ((0,4,3)|(0,0,2))+((0,3,3)|(0,0,2))*AB(2)
        theta(2260) = theta(1782)+theta(1566)*AB(3) ! ((0,3,3)|(0,0,3)) = ((0,3,4)|(0,0,2))+((0,3,3)|(0,0,2))*AB(3)
        theta(2261) = theta(1735)+theta(1567)*AB(1) ! ((0,2,4)|(3,0,0)) = ((1,2,4)|(2,0,0))+((0,2,4)|(2,0,0))*AB(1)
        ! theta(2262) = theta(1736)+theta(1568)*AB(1) ! ((0,2,4)|(2,1,0)) = ((1,2,4)|(1,1,0))+((0,2,4)|(1,1,0))*AB(1)
        ! theta(2263) = theta(1783)+theta(1567)*AB(3) ! ((0,2,4)|(2,0,1)) = ((0,2,5)|(2,0,0))+((0,2,4)|(2,0,0))*AB(3)
        ! theta(2264) = theta(1738)+theta(1570)*AB(1) ! ((0,2,4)|(1,2,0)) = ((1,2,4)|(0,2,0))+((0,2,4)|(0,2,0))*AB(1)
        ! theta(2265) = theta(1739)+theta(1571)*AB(1) ! ((0,2,4)|(1,1,1)) = ((1,2,4)|(0,1,1))+((0,2,4)|(0,1,1))*AB(1)
        ! theta(2266) = theta(1740)+theta(1572)*AB(1) ! ((0,2,4)|(1,0,2)) = ((1,2,4)|(0,0,2))+((0,2,4)|(0,0,2))*AB(1)
        theta(2267) = theta(1780)+theta(1570)*AB(2) ! ((0,2,4)|(0,3,0)) = ((0,3,4)|(0,2,0))+((0,2,4)|(0,2,0))*AB(2)
        ! theta(2268) = theta(1786)+theta(1570)*AB(3) ! ((0,2,4)|(0,2,1)) = ((0,2,5)|(0,2,0))+((0,2,4)|(0,2,0))*AB(3)
        theta(2269) = theta(1782)+theta(1572)*AB(2) ! ((0,2,4)|(0,1,2)) = ((0,3,4)|(0,0,2))+((0,2,4)|(0,0,2))*AB(2)
        theta(2270) = theta(1788)+theta(1572)*AB(3) ! ((0,2,4)|(0,0,3)) = ((0,2,5)|(0,0,2))+((0,2,4)|(0,0,2))*AB(3)
        theta(2271) = theta(1741)+theta(1573)*AB(1) ! ((0,1,5)|(3,0,0)) = ((1,1,5)|(2,0,0))+((0,1,5)|(2,0,0))*AB(1)
        ! theta(2272) = theta(1742)+theta(1574)*AB(1) ! ((0,1,5)|(2,1,0)) = ((1,1,5)|(1,1,0))+((0,1,5)|(1,1,0))*AB(1)
        ! theta(2273) = theta(1789)+theta(1573)*AB(3) ! ((0,1,5)|(2,0,1)) = ((0,1,6)|(2,0,0))+((0,1,5)|(2,0,0))*AB(3)
        ! theta(2274) = theta(1744)+theta(1576)*AB(1) ! ((0,1,5)|(1,2,0)) = ((1,1,5)|(0,2,0))+((0,1,5)|(0,2,0))*AB(1)
        ! theta(2275) = theta(1745)+theta(1577)*AB(1) ! ((0,1,5)|(1,1,1)) = ((1,1,5)|(0,1,1))+((0,1,5)|(0,1,1))*AB(1)
        ! theta(2276) = theta(1746)+theta(1578)*AB(1) ! ((0,1,5)|(1,0,2)) = ((1,1,5)|(0,0,2))+((0,1,5)|(0,0,2))*AB(1)
        theta(2277) = theta(1786)+theta(1576)*AB(2) ! ((0,1,5)|(0,3,0)) = ((0,2,5)|(0,2,0))+((0,1,5)|(0,2,0))*AB(2)
        ! theta(2278) = theta(1792)+theta(1576)*AB(3) ! ((0,1,5)|(0,2,1)) = ((0,1,6)|(0,2,0))+((0,1,5)|(0,2,0))*AB(3)
        theta(2279) = theta(1788)+theta(1578)*AB(2) ! ((0,1,5)|(0,1,2)) = ((0,2,5)|(0,0,2))+((0,1,5)|(0,0,2))*AB(2)
        theta(2280) = theta(1794)+theta(1578)*AB(3) ! ((0,1,5)|(0,0,3)) = ((0,1,6)|(0,0,2))+((0,1,5)|(0,0,2))*AB(3)
        theta(2281) = theta(1747)+theta(1579)*AB(1) ! ((0,0,6)|(3,0,0)) = ((1,0,6)|(2,0,0))+((0,0,6)|(2,0,0))*AB(1)
        ! theta(2282) = theta(1748)+theta(1580)*AB(1) ! ((0,0,6)|(2,1,0)) = ((1,0,6)|(1,1,0))+((0,0,6)|(1,1,0))*AB(1)
        ! theta(2283) = theta(1795)+theta(1579)*AB(3) ! ((0,0,6)|(2,0,1)) = ((0,0,7)|(2,0,0))+((0,0,6)|(2,0,0))*AB(3)
        ! theta(2284) = theta(1750)+theta(1582)*AB(1) ! ((0,0,6)|(1,2,0)) = ((1,0,6)|(0,2,0))+((0,0,6)|(0,2,0))*AB(1)
        ! theta(2285) = theta(1751)+theta(1583)*AB(1) ! ((0,0,6)|(1,1,1)) = ((1,0,6)|(0,1,1))+((0,0,6)|(0,1,1))*AB(1)
        ! theta(2286) = theta(1752)+theta(1584)*AB(1) ! ((0,0,6)|(1,0,2)) = ((1,0,6)|(0,0,2))+((0,0,6)|(0,0,2))*AB(1)
        theta(2287) = theta(1792)+theta(1582)*AB(2) ! ((0,0,6)|(0,3,0)) = ((0,1,6)|(0,2,0))+((0,0,6)|(0,2,0))*AB(2)
        ! theta(2288) = theta(1798)+theta(1582)*AB(3) ! ((0,0,6)|(0,2,1)) = ((0,0,7)|(0,2,0))+((0,0,6)|(0,2,0))*AB(3)
        ! theta(2289) = theta(1794)+theta(1584)*AB(2) ! ((0,0,6)|(0,1,2)) = ((0,1,6)|(0,0,2))+((0,0,6)|(0,0,2))*AB(2)
        theta(2290) = theta(1800)+theta(1584)*AB(3) ! ((0,0,6)|(0,0,3)) = ((0,0,7)|(0,0,2))+((0,0,6)|(0,0,2))*AB(3)
        theta(2291) = theta(2011)+theta(1801)*AB(1) ! ((5,0,0)|(4,0,0)) = ((6,0,0)|(3,0,0))+((5,0,0)|(3,0,0))*AB(1)
        theta(2292) = theta(2021)+theta(1801)*AB(2) ! ((5,0,0)|(3,1,0)) = ((5,1,0)|(3,0,0))+((5,0,0)|(3,0,0))*AB(2)
        theta(2293) = theta(2031)+theta(1801)*AB(3) ! ((5,0,0)|(3,0,1)) = ((5,0,1)|(3,0,0))+((5,0,0)|(3,0,0))*AB(3)
        theta(2294) = theta(2014)+theta(1804)*AB(1) ! ((5,0,0)|(2,2,0)) = ((6,0,0)|(1,2,0))+((5,0,0)|(1,2,0))*AB(1)
        theta(2295) = theta(2023)+theta(1803)*AB(2) ! ((5,0,0)|(2,1,1)) = ((5,1,0)|(2,0,1))+((5,0,0)|(2,0,1))*AB(2)
        theta(2296) = theta(2016)+theta(1806)*AB(1) ! ((5,0,0)|(2,0,2)) = ((6,0,0)|(1,0,2))+((5,0,0)|(1,0,2))*AB(1)
        theta(2297) = theta(2017)+theta(1807)*AB(1) ! ((5,0,0)|(1,3,0)) = ((6,0,0)|(0,3,0))+((5,0,0)|(0,3,0))*AB(1)
        theta(2298) = theta(2018)+theta(1808)*AB(1) ! ((5,0,0)|(1,2,1)) = ((6,0,0)|(0,2,1))+((5,0,0)|(0,2,1))*AB(1)
        theta(2299) = theta(2019)+theta(1809)*AB(1) ! ((5,0,0)|(1,1,2)) = ((6,0,0)|(0,1,2))+((5,0,0)|(0,1,2))*AB(1)
        theta(2300) = theta(2020)+theta(1810)*AB(1) ! ((5,0,0)|(1,0,3)) = ((6,0,0)|(0,0,3))+((5,0,0)|(0,0,3))*AB(1)
        theta(2301) = theta(2027)+theta(1807)*AB(2) ! ((5,0,0)|(0,4,0)) = ((5,1,0)|(0,3,0))+((5,0,0)|(0,3,0))*AB(2)
        theta(2302) = theta(2037)+theta(1807)*AB(3) ! ((5,0,0)|(0,3,1)) = ((5,0,1)|(0,3,0))+((5,0,0)|(0,3,0))*AB(3)
        theta(2303) = theta(2029)+theta(1809)*AB(2) ! ((5,0,0)|(0,2,2)) = ((5,1,0)|(0,1,2))+((5,0,0)|(0,1,2))*AB(2)
        theta(2304) = theta(2030)+theta(1810)*AB(2) ! ((5,0,0)|(0,1,3)) = ((5,1,0)|(0,0,3))+((5,0,0)|(0,0,3))*AB(2)
        theta(2305) = theta(2040)+theta(1810)*AB(3) ! ((5,0,0)|(0,0,4)) = ((5,0,1)|(0,0,3))+((5,0,0)|(0,0,3))*AB(3)
        theta(2306) = theta(2021)+theta(1811)*AB(1) ! ((4,1,0)|(4,0,0)) = ((5,1,0)|(3,0,0))+((4,1,0)|(3,0,0))*AB(1)
        theta(2307) = theta(2041)+theta(1811)*AB(2) ! ((4,1,0)|(3,1,0)) = ((4,2,0)|(3,0,0))+((4,1,0)|(3,0,0))*AB(2)
        theta(2308) = theta(2051)+theta(1811)*AB(3) ! ((4,1,0)|(3,0,1)) = ((4,1,1)|(3,0,0))+((4,1,0)|(3,0,0))*AB(3)
        theta(2309) = theta(2024)+theta(1814)*AB(1) ! ((4,1,0)|(2,2,0)) = ((5,1,0)|(1,2,0))+((4,1,0)|(1,2,0))*AB(1)
        theta(2310) = theta(2043)+theta(1813)*AB(2) ! ((4,1,0)|(2,1,1)) = ((4,2,0)|(2,0,1))+((4,1,0)|(2,0,1))*AB(2)
        theta(2311) = theta(2026)+theta(1816)*AB(1) ! ((4,1,0)|(2,0,2)) = ((5,1,0)|(1,0,2))+((4,1,0)|(1,0,2))*AB(1)
        theta(2312) = theta(2027)+theta(1817)*AB(1) ! ((4,1,0)|(1,3,0)) = ((5,1,0)|(0,3,0))+((4,1,0)|(0,3,0))*AB(1)
        theta(2313) = theta(2028)+theta(1818)*AB(1) ! ((4,1,0)|(1,2,1)) = ((5,1,0)|(0,2,1))+((4,1,0)|(0,2,1))*AB(1)
        theta(2314) = theta(2029)+theta(1819)*AB(1) ! ((4,1,0)|(1,1,2)) = ((5,1,0)|(0,1,2))+((4,1,0)|(0,1,2))*AB(1)
        theta(2315) = theta(2030)+theta(1820)*AB(1) ! ((4,1,0)|(1,0,3)) = ((5,1,0)|(0,0,3))+((4,1,0)|(0,0,3))*AB(1)
        theta(2316) = theta(2047)+theta(1817)*AB(2) ! ((4,1,0)|(0,4,0)) = ((4,2,0)|(0,3,0))+((4,1,0)|(0,3,0))*AB(2)
        theta(2317) = theta(2057)+theta(1817)*AB(3) ! ((4,1,0)|(0,3,1)) = ((4,1,1)|(0,3,0))+((4,1,0)|(0,3,0))*AB(3)
        theta(2318) = theta(2049)+theta(1819)*AB(2) ! ((4,1,0)|(0,2,2)) = ((4,2,0)|(0,1,2))+((4,1,0)|(0,1,2))*AB(2)
        theta(2319) = theta(2050)+theta(1820)*AB(2) ! ((4,1,0)|(0,1,3)) = ((4,2,0)|(0,0,3))+((4,1,0)|(0,0,3))*AB(2)
        theta(2320) = theta(2060)+theta(1820)*AB(3) ! ((4,1,0)|(0,0,4)) = ((4,1,1)|(0,0,3))+((4,1,0)|(0,0,3))*AB(3)
        theta(2321) = theta(2031)+theta(1821)*AB(1) ! ((4,0,1)|(4,0,0)) = ((5,0,1)|(3,0,0))+((4,0,1)|(3,0,0))*AB(1)
        theta(2322) = theta(2032)+theta(1822)*AB(1) ! ((4,0,1)|(3,1,0)) = ((5,0,1)|(2,1,0))+((4,0,1)|(2,1,0))*AB(1)
        theta(2323) = theta(2061)+theta(1821)*AB(3) ! ((4,0,1)|(3,0,1)) = ((4,0,2)|(3,0,0))+((4,0,1)|(3,0,0))*AB(3)
        theta(2324) = theta(2034)+theta(1824)*AB(1) ! ((4,0,1)|(2,2,0)) = ((5,0,1)|(1,2,0))+((4,0,1)|(1,2,0))*AB(1)
        theta(2325) = theta(2035)+theta(1825)*AB(1) ! ((4,0,1)|(2,1,1)) = ((5,0,1)|(1,1,1))+((4,0,1)|(1,1,1))*AB(1)
        theta(2326) = theta(2036)+theta(1826)*AB(1) ! ((4,0,1)|(2,0,2)) = ((5,0,1)|(1,0,2))+((4,0,1)|(1,0,2))*AB(1)
        theta(2327) = theta(2037)+theta(1827)*AB(1) ! ((4,0,1)|(1,3,0)) = ((5,0,1)|(0,3,0))+((4,0,1)|(0,3,0))*AB(1)
        theta(2328) = theta(2038)+theta(1828)*AB(1) ! ((4,0,1)|(1,2,1)) = ((5,0,1)|(0,2,1))+((4,0,1)|(0,2,1))*AB(1)
        theta(2329) = theta(2039)+theta(1829)*AB(1) ! ((4,0,1)|(1,1,2)) = ((5,0,1)|(0,1,2))+((4,0,1)|(0,1,2))*AB(1)
        theta(2330) = theta(2040)+theta(1830)*AB(1) ! ((4,0,1)|(1,0,3)) = ((5,0,1)|(0,0,3))+((4,0,1)|(0,0,3))*AB(1)
        theta(2331) = theta(2057)+theta(1827)*AB(2) ! ((4,0,1)|(0,4,0)) = ((4,1,1)|(0,3,0))+((4,0,1)|(0,3,0))*AB(2)
        theta(2332) = theta(2067)+theta(1827)*AB(3) ! ((4,0,1)|(0,3,1)) = ((4,0,2)|(0,3,0))+((4,0,1)|(0,3,0))*AB(3)
        theta(2333) = theta(2059)+theta(1829)*AB(2) ! ((4,0,1)|(0,2,2)) = ((4,1,1)|(0,1,2))+((4,0,1)|(0,1,2))*AB(2)
        theta(2334) = theta(2060)+theta(1830)*AB(2) ! ((4,0,1)|(0,1,3)) = ((4,1,1)|(0,0,3))+((4,0,1)|(0,0,3))*AB(2)
        theta(2335) = theta(2070)+theta(1830)*AB(3) ! ((4,0,1)|(0,0,4)) = ((4,0,2)|(0,0,3))+((4,0,1)|(0,0,3))*AB(3)
        theta(2336) = theta(2041)+theta(1831)*AB(1) ! ((3,2,0)|(4,0,0)) = ((4,2,0)|(3,0,0))+((3,2,0)|(3,0,0))*AB(1)
        theta(2337) = theta(2071)+theta(1831)*AB(2) ! ((3,2,0)|(3,1,0)) = ((3,3,0)|(3,0,0))+((3,2,0)|(3,0,0))*AB(2)
        theta(2338) = theta(2081)+theta(1831)*AB(3) ! ((3,2,0)|(3,0,1)) = ((3,2,1)|(3,0,0))+((3,2,0)|(3,0,0))*AB(3)
        theta(2339) = theta(2044)+theta(1834)*AB(1) ! ((3,2,0)|(2,2,0)) = ((4,2,0)|(1,2,0))+((3,2,0)|(1,2,0))*AB(1)
        theta(2340) = theta(2073)+theta(1833)*AB(2) ! ((3,2,0)|(2,1,1)) = ((3,3,0)|(2,0,1))+((3,2,0)|(2,0,1))*AB(2)
        theta(2341) = theta(2046)+theta(1836)*AB(1) ! ((3,2,0)|(2,0,2)) = ((4,2,0)|(1,0,2))+((3,2,0)|(1,0,2))*AB(1)
        theta(2342) = theta(2047)+theta(1837)*AB(1) ! ((3,2,0)|(1,3,0)) = ((4,2,0)|(0,3,0))+((3,2,0)|(0,3,0))*AB(1)
        theta(2343) = theta(2048)+theta(1838)*AB(1) ! ((3,2,0)|(1,2,1)) = ((4,2,0)|(0,2,1))+((3,2,0)|(0,2,1))*AB(1)
        theta(2344) = theta(2049)+theta(1839)*AB(1) ! ((3,2,0)|(1,1,2)) = ((4,2,0)|(0,1,2))+((3,2,0)|(0,1,2))*AB(1)
        theta(2345) = theta(2050)+theta(1840)*AB(1) ! ((3,2,0)|(1,0,3)) = ((4,2,0)|(0,0,3))+((3,2,0)|(0,0,3))*AB(1)
        theta(2346) = theta(2077)+theta(1837)*AB(2) ! ((3,2,0)|(0,4,0)) = ((3,3,0)|(0,3,0))+((3,2,0)|(0,3,0))*AB(2)
        theta(2347) = theta(2087)+theta(1837)*AB(3) ! ((3,2,0)|(0,3,1)) = ((3,2,1)|(0,3,0))+((3,2,0)|(0,3,0))*AB(3)
        theta(2348) = theta(2079)+theta(1839)*AB(2) ! ((3,2,0)|(0,2,2)) = ((3,3,0)|(0,1,2))+((3,2,0)|(0,1,2))*AB(2)
        theta(2349) = theta(2080)+theta(1840)*AB(2) ! ((3,2,0)|(0,1,3)) = ((3,3,0)|(0,0,3))+((3,2,0)|(0,0,3))*AB(2)
        theta(2350) = theta(2090)+theta(1840)*AB(3) ! ((3,2,0)|(0,0,4)) = ((3,2,1)|(0,0,3))+((3,2,0)|(0,0,3))*AB(3)
        theta(2351) = theta(2051)+theta(1841)*AB(1) ! ((3,1,1)|(4,0,0)) = ((4,1,1)|(3,0,0))+((3,1,1)|(3,0,0))*AB(1)
        theta(2352) = theta(2052)+theta(1842)*AB(1) ! ((3,1,1)|(3,1,0)) = ((4,1,1)|(2,1,0))+((3,1,1)|(2,1,0))*AB(1)
        theta(2353) = theta(2091)+theta(1841)*AB(3) ! ((3,1,1)|(3,0,1)) = ((3,1,2)|(3,0,0))+((3,1,1)|(3,0,0))*AB(3)
        theta(2354) = theta(2054)+theta(1844)*AB(1) ! ((3,1,1)|(2,2,0)) = ((4,1,1)|(1,2,0))+((3,1,1)|(1,2,0))*AB(1)
        theta(2355) = theta(2055)+theta(1845)*AB(1) ! ((3,1,1)|(2,1,1)) = ((4,1,1)|(1,1,1))+((3,1,1)|(1,1,1))*AB(1)
        theta(2356) = theta(2056)+theta(1846)*AB(1) ! ((3,1,1)|(2,0,2)) = ((4,1,1)|(1,0,2))+((3,1,1)|(1,0,2))*AB(1)
        theta(2357) = theta(2057)+theta(1847)*AB(1) ! ((3,1,1)|(1,3,0)) = ((4,1,1)|(0,3,0))+((3,1,1)|(0,3,0))*AB(1)
        theta(2358) = theta(2058)+theta(1848)*AB(1) ! ((3,1,1)|(1,2,1)) = ((4,1,1)|(0,2,1))+((3,1,1)|(0,2,1))*AB(1)
        theta(2359) = theta(2059)+theta(1849)*AB(1) ! ((3,1,1)|(1,1,2)) = ((4,1,1)|(0,1,2))+((3,1,1)|(0,1,2))*AB(1)
        theta(2360) = theta(2060)+theta(1850)*AB(1) ! ((3,1,1)|(1,0,3)) = ((4,1,1)|(0,0,3))+((3,1,1)|(0,0,3))*AB(1)
        theta(2361) = theta(2087)+theta(1847)*AB(2) ! ((3,1,1)|(0,4,0)) = ((3,2,1)|(0,3,0))+((3,1,1)|(0,3,0))*AB(2)
        theta(2362) = theta(2097)+theta(1847)*AB(3) ! ((3,1,1)|(0,3,1)) = ((3,1,2)|(0,3,0))+((3,1,1)|(0,3,0))*AB(3)
        theta(2363) = theta(2089)+theta(1849)*AB(2) ! ((3,1,1)|(0,2,2)) = ((3,2,1)|(0,1,2))+((3,1,1)|(0,1,2))*AB(2)
        theta(2364) = theta(2090)+theta(1850)*AB(2) ! ((3,1,1)|(0,1,3)) = ((3,2,1)|(0,0,3))+((3,1,1)|(0,0,3))*AB(2)
        theta(2365) = theta(2100)+theta(1850)*AB(3) ! ((3,1,1)|(0,0,4)) = ((3,1,2)|(0,0,3))+((3,1,1)|(0,0,3))*AB(3)
        theta(2366) = theta(2061)+theta(1851)*AB(1) ! ((3,0,2)|(4,0,0)) = ((4,0,2)|(3,0,0))+((3,0,2)|(3,0,0))*AB(1)
        theta(2367) = theta(2062)+theta(1852)*AB(1) ! ((3,0,2)|(3,1,0)) = ((4,0,2)|(2,1,0))+((3,0,2)|(2,1,0))*AB(1)
        theta(2368) = theta(2101)+theta(1851)*AB(3) ! ((3,0,2)|(3,0,1)) = ((3,0,3)|(3,0,0))+((3,0,2)|(3,0,0))*AB(3)
        theta(2369) = theta(2064)+theta(1854)*AB(1) ! ((3,0,2)|(2,2,0)) = ((4,0,2)|(1,2,0))+((3,0,2)|(1,2,0))*AB(1)
        theta(2370) = theta(2065)+theta(1855)*AB(1) ! ((3,0,2)|(2,1,1)) = ((4,0,2)|(1,1,1))+((3,0,2)|(1,1,1))*AB(1)
        theta(2371) = theta(2066)+theta(1856)*AB(1) ! ((3,0,2)|(2,0,2)) = ((4,0,2)|(1,0,2))+((3,0,2)|(1,0,2))*AB(1)
        theta(2372) = theta(2067)+theta(1857)*AB(1) ! ((3,0,2)|(1,3,0)) = ((4,0,2)|(0,3,0))+((3,0,2)|(0,3,0))*AB(1)
        theta(2373) = theta(2068)+theta(1858)*AB(1) ! ((3,0,2)|(1,2,1)) = ((4,0,2)|(0,2,1))+((3,0,2)|(0,2,1))*AB(1)
        theta(2374) = theta(2069)+theta(1859)*AB(1) ! ((3,0,2)|(1,1,2)) = ((4,0,2)|(0,1,2))+((3,0,2)|(0,1,2))*AB(1)
        theta(2375) = theta(2070)+theta(1860)*AB(1) ! ((3,0,2)|(1,0,3)) = ((4,0,2)|(0,0,3))+((3,0,2)|(0,0,3))*AB(1)
        theta(2376) = theta(2097)+theta(1857)*AB(2) ! ((3,0,2)|(0,4,0)) = ((3,1,2)|(0,3,0))+((3,0,2)|(0,3,0))*AB(2)
        theta(2377) = theta(2107)+theta(1857)*AB(3) ! ((3,0,2)|(0,3,1)) = ((3,0,3)|(0,3,0))+((3,0,2)|(0,3,0))*AB(3)
        theta(2378) = theta(2099)+theta(1859)*AB(2) ! ((3,0,2)|(0,2,2)) = ((3,1,2)|(0,1,2))+((3,0,2)|(0,1,2))*AB(2)
        theta(2379) = theta(2100)+theta(1860)*AB(2) ! ((3,0,2)|(0,1,3)) = ((3,1,2)|(0,0,3))+((3,0,2)|(0,0,3))*AB(2)
        theta(2380) = theta(2110)+theta(1860)*AB(3) ! ((3,0,2)|(0,0,4)) = ((3,0,3)|(0,0,3))+((3,0,2)|(0,0,3))*AB(3)
        theta(2381) = theta(2071)+theta(1861)*AB(1) ! ((2,3,0)|(4,0,0)) = ((3,3,0)|(3,0,0))+((2,3,0)|(3,0,0))*AB(1)
        theta(2382) = theta(2111)+theta(1861)*AB(2) ! ((2,3,0)|(3,1,0)) = ((2,4,0)|(3,0,0))+((2,3,0)|(3,0,0))*AB(2)
        theta(2383) = theta(2121)+theta(1861)*AB(3) ! ((2,3,0)|(3,0,1)) = ((2,3,1)|(3,0,0))+((2,3,0)|(3,0,0))*AB(3)
        theta(2384) = theta(2074)+theta(1864)*AB(1) ! ((2,3,0)|(2,2,0)) = ((3,3,0)|(1,2,0))+((2,3,0)|(1,2,0))*AB(1)
        theta(2385) = theta(2113)+theta(1863)*AB(2) ! ((2,3,0)|(2,1,1)) = ((2,4,0)|(2,0,1))+((2,3,0)|(2,0,1))*AB(2)
        theta(2386) = theta(2076)+theta(1866)*AB(1) ! ((2,3,0)|(2,0,2)) = ((3,3,0)|(1,0,2))+((2,3,0)|(1,0,2))*AB(1)
        theta(2387) = theta(2077)+theta(1867)*AB(1) ! ((2,3,0)|(1,3,0)) = ((3,3,0)|(0,3,0))+((2,3,0)|(0,3,0))*AB(1)
        theta(2388) = theta(2078)+theta(1868)*AB(1) ! ((2,3,0)|(1,2,1)) = ((3,3,0)|(0,2,1))+((2,3,0)|(0,2,1))*AB(1)
        theta(2389) = theta(2079)+theta(1869)*AB(1) ! ((2,3,0)|(1,1,2)) = ((3,3,0)|(0,1,2))+((2,3,0)|(0,1,2))*AB(1)
        theta(2390) = theta(2080)+theta(1870)*AB(1) ! ((2,3,0)|(1,0,3)) = ((3,3,0)|(0,0,3))+((2,3,0)|(0,0,3))*AB(1)
        theta(2391) = theta(2117)+theta(1867)*AB(2) ! ((2,3,0)|(0,4,0)) = ((2,4,0)|(0,3,0))+((2,3,0)|(0,3,0))*AB(2)
        theta(2392) = theta(2127)+theta(1867)*AB(3) ! ((2,3,0)|(0,3,1)) = ((2,3,1)|(0,3,0))+((2,3,0)|(0,3,0))*AB(3)
        theta(2393) = theta(2119)+theta(1869)*AB(2) ! ((2,3,0)|(0,2,2)) = ((2,4,0)|(0,1,2))+((2,3,0)|(0,1,2))*AB(2)
        theta(2394) = theta(2120)+theta(1870)*AB(2) ! ((2,3,0)|(0,1,3)) = ((2,4,0)|(0,0,3))+((2,3,0)|(0,0,3))*AB(2)
        theta(2395) = theta(2130)+theta(1870)*AB(3) ! ((2,3,0)|(0,0,4)) = ((2,3,1)|(0,0,3))+((2,3,0)|(0,0,3))*AB(3)
        theta(2396) = theta(2081)+theta(1871)*AB(1) ! ((2,2,1)|(4,0,0)) = ((3,2,1)|(3,0,0))+((2,2,1)|(3,0,0))*AB(1)
        theta(2397) = theta(2082)+theta(1872)*AB(1) ! ((2,2,1)|(3,1,0)) = ((3,2,1)|(2,1,0))+((2,2,1)|(2,1,0))*AB(1)
        theta(2398) = theta(2131)+theta(1871)*AB(3) ! ((2,2,1)|(3,0,1)) = ((2,2,2)|(3,0,0))+((2,2,1)|(3,0,0))*AB(3)
        theta(2399) = theta(2084)+theta(1874)*AB(1) ! ((2,2,1)|(2,2,0)) = ((3,2,1)|(1,2,0))+((2,2,1)|(1,2,0))*AB(1)
        theta(2400) = theta(2085)+theta(1875)*AB(1) ! ((2,2,1)|(2,1,1)) = ((3,2,1)|(1,1,1))+((2,2,1)|(1,1,1))*AB(1)
        theta(2401) = theta(2086)+theta(1876)*AB(1) ! ((2,2,1)|(2,0,2)) = ((3,2,1)|(1,0,2))+((2,2,1)|(1,0,2))*AB(1)
        theta(2402) = theta(2087)+theta(1877)*AB(1) ! ((2,2,1)|(1,3,0)) = ((3,2,1)|(0,3,0))+((2,2,1)|(0,3,0))*AB(1)
        theta(2403) = theta(2088)+theta(1878)*AB(1) ! ((2,2,1)|(1,2,1)) = ((3,2,1)|(0,2,1))+((2,2,1)|(0,2,1))*AB(1)
        theta(2404) = theta(2089)+theta(1879)*AB(1) ! ((2,2,1)|(1,1,2)) = ((3,2,1)|(0,1,2))+((2,2,1)|(0,1,2))*AB(1)
        theta(2405) = theta(2090)+theta(1880)*AB(1) ! ((2,2,1)|(1,0,3)) = ((3,2,1)|(0,0,3))+((2,2,1)|(0,0,3))*AB(1)
        theta(2406) = theta(2127)+theta(1877)*AB(2) ! ((2,2,1)|(0,4,0)) = ((2,3,1)|(0,3,0))+((2,2,1)|(0,3,0))*AB(2)
        theta(2407) = theta(2137)+theta(1877)*AB(3) ! ((2,2,1)|(0,3,1)) = ((2,2,2)|(0,3,0))+((2,2,1)|(0,3,0))*AB(3)
        theta(2408) = theta(2129)+theta(1879)*AB(2) ! ((2,2,1)|(0,2,2)) = ((2,3,1)|(0,1,2))+((2,2,1)|(0,1,2))*AB(2)
        theta(2409) = theta(2130)+theta(1880)*AB(2) ! ((2,2,1)|(0,1,3)) = ((2,3,1)|(0,0,3))+((2,2,1)|(0,0,3))*AB(2)
        theta(2410) = theta(2140)+theta(1880)*AB(3) ! ((2,2,1)|(0,0,4)) = ((2,2,2)|(0,0,3))+((2,2,1)|(0,0,3))*AB(3)
        theta(2411) = theta(2091)+theta(1881)*AB(1) ! ((2,1,2)|(4,0,0)) = ((3,1,2)|(3,0,0))+((2,1,2)|(3,0,0))*AB(1)
        theta(2412) = theta(2092)+theta(1882)*AB(1) ! ((2,1,2)|(3,1,0)) = ((3,1,2)|(2,1,0))+((2,1,2)|(2,1,0))*AB(1)
        theta(2413) = theta(2141)+theta(1881)*AB(3) ! ((2,1,2)|(3,0,1)) = ((2,1,3)|(3,0,0))+((2,1,2)|(3,0,0))*AB(3)
        theta(2414) = theta(2094)+theta(1884)*AB(1) ! ((2,1,2)|(2,2,0)) = ((3,1,2)|(1,2,0))+((2,1,2)|(1,2,0))*AB(1)
        theta(2415) = theta(2095)+theta(1885)*AB(1) ! ((2,1,2)|(2,1,1)) = ((3,1,2)|(1,1,1))+((2,1,2)|(1,1,1))*AB(1)
        theta(2416) = theta(2096)+theta(1886)*AB(1) ! ((2,1,2)|(2,0,2)) = ((3,1,2)|(1,0,2))+((2,1,2)|(1,0,2))*AB(1)
        theta(2417) = theta(2097)+theta(1887)*AB(1) ! ((2,1,2)|(1,3,0)) = ((3,1,2)|(0,3,0))+((2,1,2)|(0,3,0))*AB(1)
        theta(2418) = theta(2098)+theta(1888)*AB(1) ! ((2,1,2)|(1,2,1)) = ((3,1,2)|(0,2,1))+((2,1,2)|(0,2,1))*AB(1)
        theta(2419) = theta(2099)+theta(1889)*AB(1) ! ((2,1,2)|(1,1,2)) = ((3,1,2)|(0,1,2))+((2,1,2)|(0,1,2))*AB(1)
        theta(2420) = theta(2100)+theta(1890)*AB(1) ! ((2,1,2)|(1,0,3)) = ((3,1,2)|(0,0,3))+((2,1,2)|(0,0,3))*AB(1)
        theta(2421) = theta(2137)+theta(1887)*AB(2) ! ((2,1,2)|(0,4,0)) = ((2,2,2)|(0,3,0))+((2,1,2)|(0,3,0))*AB(2)
        theta(2422) = theta(2147)+theta(1887)*AB(3) ! ((2,1,2)|(0,3,1)) = ((2,1,3)|(0,3,0))+((2,1,2)|(0,3,0))*AB(3)
        theta(2423) = theta(2139)+theta(1889)*AB(2) ! ((2,1,2)|(0,2,2)) = ((2,2,2)|(0,1,2))+((2,1,2)|(0,1,2))*AB(2)
        theta(2424) = theta(2140)+theta(1890)*AB(2) ! ((2,1,2)|(0,1,3)) = ((2,2,2)|(0,0,3))+((2,1,2)|(0,0,3))*AB(2)
        theta(2425) = theta(2150)+theta(1890)*AB(3) ! ((2,1,2)|(0,0,4)) = ((2,1,3)|(0,0,3))+((2,1,2)|(0,0,3))*AB(3)
        theta(2426) = theta(2101)+theta(1891)*AB(1) ! ((2,0,3)|(4,0,0)) = ((3,0,3)|(3,0,0))+((2,0,3)|(3,0,0))*AB(1)
        theta(2427) = theta(2102)+theta(1892)*AB(1) ! ((2,0,3)|(3,1,0)) = ((3,0,3)|(2,1,0))+((2,0,3)|(2,1,0))*AB(1)
        theta(2428) = theta(2151)+theta(1891)*AB(3) ! ((2,0,3)|(3,0,1)) = ((2,0,4)|(3,0,0))+((2,0,3)|(3,0,0))*AB(3)
        theta(2429) = theta(2104)+theta(1894)*AB(1) ! ((2,0,3)|(2,2,0)) = ((3,0,3)|(1,2,0))+((2,0,3)|(1,2,0))*AB(1)
        theta(2430) = theta(2105)+theta(1895)*AB(1) ! ((2,0,3)|(2,1,1)) = ((3,0,3)|(1,1,1))+((2,0,3)|(1,1,1))*AB(1)
        theta(2431) = theta(2106)+theta(1896)*AB(1) ! ((2,0,3)|(2,0,2)) = ((3,0,3)|(1,0,2))+((2,0,3)|(1,0,2))*AB(1)
        theta(2432) = theta(2107)+theta(1897)*AB(1) ! ((2,0,3)|(1,3,0)) = ((3,0,3)|(0,3,0))+((2,0,3)|(0,3,0))*AB(1)
        theta(2433) = theta(2108)+theta(1898)*AB(1) ! ((2,0,3)|(1,2,1)) = ((3,0,3)|(0,2,1))+((2,0,3)|(0,2,1))*AB(1)
        theta(2434) = theta(2109)+theta(1899)*AB(1) ! ((2,0,3)|(1,1,2)) = ((3,0,3)|(0,1,2))+((2,0,3)|(0,1,2))*AB(1)
        theta(2435) = theta(2110)+theta(1900)*AB(1) ! ((2,0,3)|(1,0,3)) = ((3,0,3)|(0,0,3))+((2,0,3)|(0,0,3))*AB(1)
        theta(2436) = theta(2147)+theta(1897)*AB(2) ! ((2,0,3)|(0,4,0)) = ((2,1,3)|(0,3,0))+((2,0,3)|(0,3,0))*AB(2)
        theta(2437) = theta(2157)+theta(1897)*AB(3) ! ((2,0,3)|(0,3,1)) = ((2,0,4)|(0,3,0))+((2,0,3)|(0,3,0))*AB(3)
        theta(2438) = theta(2149)+theta(1899)*AB(2) ! ((2,0,3)|(0,2,2)) = ((2,1,3)|(0,1,2))+((2,0,3)|(0,1,2))*AB(2)
        theta(2439) = theta(2150)+theta(1900)*AB(2) ! ((2,0,3)|(0,1,3)) = ((2,1,3)|(0,0,3))+((2,0,3)|(0,0,3))*AB(2)
        theta(2440) = theta(2160)+theta(1900)*AB(3) ! ((2,0,3)|(0,0,4)) = ((2,0,4)|(0,0,3))+((2,0,3)|(0,0,3))*AB(3)
        theta(2441) = theta(2111)+theta(1901)*AB(1) ! ((1,4,0)|(4,0,0)) = ((2,4,0)|(3,0,0))+((1,4,0)|(3,0,0))*AB(1)
        theta(2442) = theta(2161)+theta(1901)*AB(2) ! ((1,4,0)|(3,1,0)) = ((1,5,0)|(3,0,0))+((1,4,0)|(3,0,0))*AB(2)
        theta(2443) = theta(2171)+theta(1901)*AB(3) ! ((1,4,0)|(3,0,1)) = ((1,4,1)|(3,0,0))+((1,4,0)|(3,0,0))*AB(3)
        theta(2444) = theta(2114)+theta(1904)*AB(1) ! ((1,4,0)|(2,2,0)) = ((2,4,0)|(1,2,0))+((1,4,0)|(1,2,0))*AB(1)
        theta(2445) = theta(2163)+theta(1903)*AB(2) ! ((1,4,0)|(2,1,1)) = ((1,5,0)|(2,0,1))+((1,4,0)|(2,0,1))*AB(2)
        theta(2446) = theta(2116)+theta(1906)*AB(1) ! ((1,4,0)|(2,0,2)) = ((2,4,0)|(1,0,2))+((1,4,0)|(1,0,2))*AB(1)
        theta(2447) = theta(2117)+theta(1907)*AB(1) ! ((1,4,0)|(1,3,0)) = ((2,4,0)|(0,3,0))+((1,4,0)|(0,3,0))*AB(1)
        theta(2448) = theta(2118)+theta(1908)*AB(1) ! ((1,4,0)|(1,2,1)) = ((2,4,0)|(0,2,1))+((1,4,0)|(0,2,1))*AB(1)
        theta(2449) = theta(2119)+theta(1909)*AB(1) ! ((1,4,0)|(1,1,2)) = ((2,4,0)|(0,1,2))+((1,4,0)|(0,1,2))*AB(1)
        theta(2450) = theta(2120)+theta(1910)*AB(1) ! ((1,4,0)|(1,0,3)) = ((2,4,0)|(0,0,3))+((1,4,0)|(0,0,3))*AB(1)
        theta(2451) = theta(2167)+theta(1907)*AB(2) ! ((1,4,0)|(0,4,0)) = ((1,5,0)|(0,3,0))+((1,4,0)|(0,3,0))*AB(2)
        theta(2452) = theta(2177)+theta(1907)*AB(3) ! ((1,4,0)|(0,3,1)) = ((1,4,1)|(0,3,0))+((1,4,0)|(0,3,0))*AB(3)
        theta(2453) = theta(2169)+theta(1909)*AB(2) ! ((1,4,0)|(0,2,2)) = ((1,5,0)|(0,1,2))+((1,4,0)|(0,1,2))*AB(2)
        theta(2454) = theta(2170)+theta(1910)*AB(2) ! ((1,4,0)|(0,1,3)) = ((1,5,0)|(0,0,3))+((1,4,0)|(0,0,3))*AB(2)
        theta(2455) = theta(2180)+theta(1910)*AB(3) ! ((1,4,0)|(0,0,4)) = ((1,4,1)|(0,0,3))+((1,4,0)|(0,0,3))*AB(3)
        theta(2456) = theta(2121)+theta(1911)*AB(1) ! ((1,3,1)|(4,0,0)) = ((2,3,1)|(3,0,0))+((1,3,1)|(3,0,0))*AB(1)
        theta(2457) = theta(2122)+theta(1912)*AB(1) ! ((1,3,1)|(3,1,0)) = ((2,3,1)|(2,1,0))+((1,3,1)|(2,1,0))*AB(1)
        theta(2458) = theta(2181)+theta(1911)*AB(3) ! ((1,3,1)|(3,0,1)) = ((1,3,2)|(3,0,0))+((1,3,1)|(3,0,0))*AB(3)
        theta(2459) = theta(2124)+theta(1914)*AB(1) ! ((1,3,1)|(2,2,0)) = ((2,3,1)|(1,2,0))+((1,3,1)|(1,2,0))*AB(1)
        theta(2460) = theta(2125)+theta(1915)*AB(1) ! ((1,3,1)|(2,1,1)) = ((2,3,1)|(1,1,1))+((1,3,1)|(1,1,1))*AB(1)
        theta(2461) = theta(2126)+theta(1916)*AB(1) ! ((1,3,1)|(2,0,2)) = ((2,3,1)|(1,0,2))+((1,3,1)|(1,0,2))*AB(1)
        theta(2462) = theta(2127)+theta(1917)*AB(1) ! ((1,3,1)|(1,3,0)) = ((2,3,1)|(0,3,0))+((1,3,1)|(0,3,0))*AB(1)
        theta(2463) = theta(2128)+theta(1918)*AB(1) ! ((1,3,1)|(1,2,1)) = ((2,3,1)|(0,2,1))+((1,3,1)|(0,2,1))*AB(1)
        theta(2464) = theta(2129)+theta(1919)*AB(1) ! ((1,3,1)|(1,1,2)) = ((2,3,1)|(0,1,2))+((1,3,1)|(0,1,2))*AB(1)
        theta(2465) = theta(2130)+theta(1920)*AB(1) ! ((1,3,1)|(1,0,3)) = ((2,3,1)|(0,0,3))+((1,3,1)|(0,0,3))*AB(1)
        theta(2466) = theta(2177)+theta(1917)*AB(2) ! ((1,3,1)|(0,4,0)) = ((1,4,1)|(0,3,0))+((1,3,1)|(0,3,0))*AB(2)
        theta(2467) = theta(2187)+theta(1917)*AB(3) ! ((1,3,1)|(0,3,1)) = ((1,3,2)|(0,3,0))+((1,3,1)|(0,3,0))*AB(3)
        theta(2468) = theta(2179)+theta(1919)*AB(2) ! ((1,3,1)|(0,2,2)) = ((1,4,1)|(0,1,2))+((1,3,1)|(0,1,2))*AB(2)
        theta(2469) = theta(2180)+theta(1920)*AB(2) ! ((1,3,1)|(0,1,3)) = ((1,4,1)|(0,0,3))+((1,3,1)|(0,0,3))*AB(2)
        theta(2470) = theta(2190)+theta(1920)*AB(3) ! ((1,3,1)|(0,0,4)) = ((1,3,2)|(0,0,3))+((1,3,1)|(0,0,3))*AB(3)
        theta(2471) = theta(2131)+theta(1921)*AB(1) ! ((1,2,2)|(4,0,0)) = ((2,2,2)|(3,0,0))+((1,2,2)|(3,0,0))*AB(1)
        theta(2472) = theta(2132)+theta(1922)*AB(1) ! ((1,2,2)|(3,1,0)) = ((2,2,2)|(2,1,0))+((1,2,2)|(2,1,0))*AB(1)
        theta(2473) = theta(2191)+theta(1921)*AB(3) ! ((1,2,2)|(3,0,1)) = ((1,2,3)|(3,0,0))+((1,2,2)|(3,0,0))*AB(3)
        theta(2474) = theta(2134)+theta(1924)*AB(1) ! ((1,2,2)|(2,2,0)) = ((2,2,2)|(1,2,0))+((1,2,2)|(1,2,0))*AB(1)
        theta(2475) = theta(2135)+theta(1925)*AB(1) ! ((1,2,2)|(2,1,1)) = ((2,2,2)|(1,1,1))+((1,2,2)|(1,1,1))*AB(1)
        theta(2476) = theta(2136)+theta(1926)*AB(1) ! ((1,2,2)|(2,0,2)) = ((2,2,2)|(1,0,2))+((1,2,2)|(1,0,2))*AB(1)
        theta(2477) = theta(2137)+theta(1927)*AB(1) ! ((1,2,2)|(1,3,0)) = ((2,2,2)|(0,3,0))+((1,2,2)|(0,3,0))*AB(1)
        theta(2478) = theta(2138)+theta(1928)*AB(1) ! ((1,2,2)|(1,2,1)) = ((2,2,2)|(0,2,1))+((1,2,2)|(0,2,1))*AB(1)
        theta(2479) = theta(2139)+theta(1929)*AB(1) ! ((1,2,2)|(1,1,2)) = ((2,2,2)|(0,1,2))+((1,2,2)|(0,1,2))*AB(1)
        theta(2480) = theta(2140)+theta(1930)*AB(1) ! ((1,2,2)|(1,0,3)) = ((2,2,2)|(0,0,3))+((1,2,2)|(0,0,3))*AB(1)
        theta(2481) = theta(2187)+theta(1927)*AB(2) ! ((1,2,2)|(0,4,0)) = ((1,3,2)|(0,3,0))+((1,2,2)|(0,3,0))*AB(2)
        theta(2482) = theta(2197)+theta(1927)*AB(3) ! ((1,2,2)|(0,3,1)) = ((1,2,3)|(0,3,0))+((1,2,2)|(0,3,0))*AB(3)
        theta(2483) = theta(2189)+theta(1929)*AB(2) ! ((1,2,2)|(0,2,2)) = ((1,3,2)|(0,1,2))+((1,2,2)|(0,1,2))*AB(2)
        theta(2484) = theta(2190)+theta(1930)*AB(2) ! ((1,2,2)|(0,1,3)) = ((1,3,2)|(0,0,3))+((1,2,2)|(0,0,3))*AB(2)
        theta(2485) = theta(2200)+theta(1930)*AB(3) ! ((1,2,2)|(0,0,4)) = ((1,2,3)|(0,0,3))+((1,2,2)|(0,0,3))*AB(3)
        theta(2486) = theta(2141)+theta(1931)*AB(1) ! ((1,1,3)|(4,0,0)) = ((2,1,3)|(3,0,0))+((1,1,3)|(3,0,0))*AB(1)
        theta(2487) = theta(2142)+theta(1932)*AB(1) ! ((1,1,3)|(3,1,0)) = ((2,1,3)|(2,1,0))+((1,1,3)|(2,1,0))*AB(1)
        theta(2488) = theta(2201)+theta(1931)*AB(3) ! ((1,1,3)|(3,0,1)) = ((1,1,4)|(3,0,0))+((1,1,3)|(3,0,0))*AB(3)
        theta(2489) = theta(2144)+theta(1934)*AB(1) ! ((1,1,3)|(2,2,0)) = ((2,1,3)|(1,2,0))+((1,1,3)|(1,2,0))*AB(1)
        theta(2490) = theta(2145)+theta(1935)*AB(1) ! ((1,1,3)|(2,1,1)) = ((2,1,3)|(1,1,1))+((1,1,3)|(1,1,1))*AB(1)
        theta(2491) = theta(2146)+theta(1936)*AB(1) ! ((1,1,3)|(2,0,2)) = ((2,1,3)|(1,0,2))+((1,1,3)|(1,0,2))*AB(1)
        theta(2492) = theta(2147)+theta(1937)*AB(1) ! ((1,1,3)|(1,3,0)) = ((2,1,3)|(0,3,0))+((1,1,3)|(0,3,0))*AB(1)
        theta(2493) = theta(2148)+theta(1938)*AB(1) ! ((1,1,3)|(1,2,1)) = ((2,1,3)|(0,2,1))+((1,1,3)|(0,2,1))*AB(1)
        theta(2494) = theta(2149)+theta(1939)*AB(1) ! ((1,1,3)|(1,1,2)) = ((2,1,3)|(0,1,2))+((1,1,3)|(0,1,2))*AB(1)
        theta(2495) = theta(2150)+theta(1940)*AB(1) ! ((1,1,3)|(1,0,3)) = ((2,1,3)|(0,0,3))+((1,1,3)|(0,0,3))*AB(1)
        theta(2496) = theta(2197)+theta(1937)*AB(2) ! ((1,1,3)|(0,4,0)) = ((1,2,3)|(0,3,0))+((1,1,3)|(0,3,0))*AB(2)
        theta(2497) = theta(2207)+theta(1937)*AB(3) ! ((1,1,3)|(0,3,1)) = ((1,1,4)|(0,3,0))+((1,1,3)|(0,3,0))*AB(3)
        theta(2498) = theta(2199)+theta(1939)*AB(2) ! ((1,1,3)|(0,2,2)) = ((1,2,3)|(0,1,2))+((1,1,3)|(0,1,2))*AB(2)
        theta(2499) = theta(2200)+theta(1940)*AB(2) ! ((1,1,3)|(0,1,3)) = ((1,2,3)|(0,0,3))+((1,1,3)|(0,0,3))*AB(2)
        theta(2500) = theta(2210)+theta(1940)*AB(3) ! ((1,1,3)|(0,0,4)) = ((1,1,4)|(0,0,3))+((1,1,3)|(0,0,3))*AB(3)
        theta(2501) = theta(2151)+theta(1941)*AB(1) ! ((1,0,4)|(4,0,0)) = ((2,0,4)|(3,0,0))+((1,0,4)|(3,0,0))*AB(1)
        theta(2502) = theta(2152)+theta(1942)*AB(1) ! ((1,0,4)|(3,1,0)) = ((2,0,4)|(2,1,0))+((1,0,4)|(2,1,0))*AB(1)
        theta(2503) = theta(2211)+theta(1941)*AB(3) ! ((1,0,4)|(3,0,1)) = ((1,0,5)|(3,0,0))+((1,0,4)|(3,0,0))*AB(3)
        theta(2504) = theta(2154)+theta(1944)*AB(1) ! ((1,0,4)|(2,2,0)) = ((2,0,4)|(1,2,0))+((1,0,4)|(1,2,0))*AB(1)
        theta(2505) = theta(2155)+theta(1945)*AB(1) ! ((1,0,4)|(2,1,1)) = ((2,0,4)|(1,1,1))+((1,0,4)|(1,1,1))*AB(1)
        theta(2506) = theta(2156)+theta(1946)*AB(1) ! ((1,0,4)|(2,0,2)) = ((2,0,4)|(1,0,2))+((1,0,4)|(1,0,2))*AB(1)
        theta(2507) = theta(2157)+theta(1947)*AB(1) ! ((1,0,4)|(1,3,0)) = ((2,0,4)|(0,3,0))+((1,0,4)|(0,3,0))*AB(1)
        theta(2508) = theta(2158)+theta(1948)*AB(1) ! ((1,0,4)|(1,2,1)) = ((2,0,4)|(0,2,1))+((1,0,4)|(0,2,1))*AB(1)
        theta(2509) = theta(2159)+theta(1949)*AB(1) ! ((1,0,4)|(1,1,2)) = ((2,0,4)|(0,1,2))+((1,0,4)|(0,1,2))*AB(1)
        theta(2510) = theta(2160)+theta(1950)*AB(1) ! ((1,0,4)|(1,0,3)) = ((2,0,4)|(0,0,3))+((1,0,4)|(0,0,3))*AB(1)
        theta(2511) = theta(2207)+theta(1947)*AB(2) ! ((1,0,4)|(0,4,0)) = ((1,1,4)|(0,3,0))+((1,0,4)|(0,3,0))*AB(2)
        theta(2512) = theta(2217)+theta(1947)*AB(3) ! ((1,0,4)|(0,3,1)) = ((1,0,5)|(0,3,0))+((1,0,4)|(0,3,0))*AB(3)
        theta(2513) = theta(2209)+theta(1949)*AB(2) ! ((1,0,4)|(0,2,2)) = ((1,1,4)|(0,1,2))+((1,0,4)|(0,1,2))*AB(2)
        theta(2514) = theta(2210)+theta(1950)*AB(2) ! ((1,0,4)|(0,1,3)) = ((1,1,4)|(0,0,3))+((1,0,4)|(0,0,3))*AB(2)
        theta(2515) = theta(2220)+theta(1950)*AB(3) ! ((1,0,4)|(0,0,4)) = ((1,0,5)|(0,0,3))+((1,0,4)|(0,0,3))*AB(3)
        theta(2516) = theta(2161)+theta(1951)*AB(1) ! ((0,5,0)|(4,0,0)) = ((1,5,0)|(3,0,0))+((0,5,0)|(3,0,0))*AB(1)
        theta(2517) = theta(2221)+theta(1951)*AB(2) ! ((0,5,0)|(3,1,0)) = ((0,6,0)|(3,0,0))+((0,5,0)|(3,0,0))*AB(2)
        theta(2518) = theta(2231)+theta(1951)*AB(3) ! ((0,5,0)|(3,0,1)) = ((0,5,1)|(3,0,0))+((0,5,0)|(3,0,0))*AB(3)
        theta(2519) = theta(2164)+theta(1954)*AB(1) ! ((0,5,0)|(2,2,0)) = ((1,5,0)|(1,2,0))+((0,5,0)|(1,2,0))*AB(1)
        theta(2520) = theta(2223)+theta(1953)*AB(2) ! ((0,5,0)|(2,1,1)) = ((0,6,0)|(2,0,1))+((0,5,0)|(2,0,1))*AB(2)
        theta(2521) = theta(2166)+theta(1956)*AB(1) ! ((0,5,0)|(2,0,2)) = ((1,5,0)|(1,0,2))+((0,5,0)|(1,0,2))*AB(1)
        theta(2522) = theta(2167)+theta(1957)*AB(1) ! ((0,5,0)|(1,3,0)) = ((1,5,0)|(0,3,0))+((0,5,0)|(0,3,0))*AB(1)
        theta(2523) = theta(2168)+theta(1958)*AB(1) ! ((0,5,0)|(1,2,1)) = ((1,5,0)|(0,2,1))+((0,5,0)|(0,2,1))*AB(1)
        theta(2524) = theta(2169)+theta(1959)*AB(1) ! ((0,5,0)|(1,1,2)) = ((1,5,0)|(0,1,2))+((0,5,0)|(0,1,2))*AB(1)
        theta(2525) = theta(2170)+theta(1960)*AB(1) ! ((0,5,0)|(1,0,3)) = ((1,5,0)|(0,0,3))+((0,5,0)|(0,0,3))*AB(1)
        theta(2526) = theta(2227)+theta(1957)*AB(2) ! ((0,5,0)|(0,4,0)) = ((0,6,0)|(0,3,0))+((0,5,0)|(0,3,0))*AB(2)
        theta(2527) = theta(2237)+theta(1957)*AB(3) ! ((0,5,0)|(0,3,1)) = ((0,5,1)|(0,3,0))+((0,5,0)|(0,3,0))*AB(3)
        theta(2528) = theta(2229)+theta(1959)*AB(2) ! ((0,5,0)|(0,2,2)) = ((0,6,0)|(0,1,2))+((0,5,0)|(0,1,2))*AB(2)
        theta(2529) = theta(2230)+theta(1960)*AB(2) ! ((0,5,0)|(0,1,3)) = ((0,6,0)|(0,0,3))+((0,5,0)|(0,0,3))*AB(2)
        theta(2530) = theta(2240)+theta(1960)*AB(3) ! ((0,5,0)|(0,0,4)) = ((0,5,1)|(0,0,3))+((0,5,0)|(0,0,3))*AB(3)
        theta(2531) = theta(2171)+theta(1961)*AB(1) ! ((0,4,1)|(4,0,0)) = ((1,4,1)|(3,0,0))+((0,4,1)|(3,0,0))*AB(1)
        theta(2532) = theta(2172)+theta(1962)*AB(1) ! ((0,4,1)|(3,1,0)) = ((1,4,1)|(2,1,0))+((0,4,1)|(2,1,0))*AB(1)
        theta(2533) = theta(2241)+theta(1961)*AB(3) ! ((0,4,1)|(3,0,1)) = ((0,4,2)|(3,0,0))+((0,4,1)|(3,0,0))*AB(3)
        theta(2534) = theta(2174)+theta(1964)*AB(1) ! ((0,4,1)|(2,2,0)) = ((1,4,1)|(1,2,0))+((0,4,1)|(1,2,0))*AB(1)
        theta(2535) = theta(2175)+theta(1965)*AB(1) ! ((0,4,1)|(2,1,1)) = ((1,4,1)|(1,1,1))+((0,4,1)|(1,1,1))*AB(1)
        theta(2536) = theta(2176)+theta(1966)*AB(1) ! ((0,4,1)|(2,0,2)) = ((1,4,1)|(1,0,2))+((0,4,1)|(1,0,2))*AB(1)
        theta(2537) = theta(2177)+theta(1967)*AB(1) ! ((0,4,1)|(1,3,0)) = ((1,4,1)|(0,3,0))+((0,4,1)|(0,3,0))*AB(1)
        theta(2538) = theta(2178)+theta(1968)*AB(1) ! ((0,4,1)|(1,2,1)) = ((1,4,1)|(0,2,1))+((0,4,1)|(0,2,1))*AB(1)
        theta(2539) = theta(2179)+theta(1969)*AB(1) ! ((0,4,1)|(1,1,2)) = ((1,4,1)|(0,1,2))+((0,4,1)|(0,1,2))*AB(1)
        theta(2540) = theta(2180)+theta(1970)*AB(1) ! ((0,4,1)|(1,0,3)) = ((1,4,1)|(0,0,3))+((0,4,1)|(0,0,3))*AB(1)
        theta(2541) = theta(2237)+theta(1967)*AB(2) ! ((0,4,1)|(0,4,0)) = ((0,5,1)|(0,3,0))+((0,4,1)|(0,3,0))*AB(2)
        theta(2542) = theta(2247)+theta(1967)*AB(3) ! ((0,4,1)|(0,3,1)) = ((0,4,2)|(0,3,0))+((0,4,1)|(0,3,0))*AB(3)
        theta(2543) = theta(2239)+theta(1969)*AB(2) ! ((0,4,1)|(0,2,2)) = ((0,5,1)|(0,1,2))+((0,4,1)|(0,1,2))*AB(2)
        theta(2544) = theta(2240)+theta(1970)*AB(2) ! ((0,4,1)|(0,1,3)) = ((0,5,1)|(0,0,3))+((0,4,1)|(0,0,3))*AB(2)
        theta(2545) = theta(2250)+theta(1970)*AB(3) ! ((0,4,1)|(0,0,4)) = ((0,4,2)|(0,0,3))+((0,4,1)|(0,0,3))*AB(3)
        theta(2546) = theta(2181)+theta(1971)*AB(1) ! ((0,3,2)|(4,0,0)) = ((1,3,2)|(3,0,0))+((0,3,2)|(3,0,0))*AB(1)
        theta(2547) = theta(2182)+theta(1972)*AB(1) ! ((0,3,2)|(3,1,0)) = ((1,3,2)|(2,1,0))+((0,3,2)|(2,1,0))*AB(1)
        theta(2548) = theta(2251)+theta(1971)*AB(3) ! ((0,3,2)|(3,0,1)) = ((0,3,3)|(3,0,0))+((0,3,2)|(3,0,0))*AB(3)
        theta(2549) = theta(2184)+theta(1974)*AB(1) ! ((0,3,2)|(2,2,0)) = ((1,3,2)|(1,2,0))+((0,3,2)|(1,2,0))*AB(1)
        theta(2550) = theta(2185)+theta(1975)*AB(1) ! ((0,3,2)|(2,1,1)) = ((1,3,2)|(1,1,1))+((0,3,2)|(1,1,1))*AB(1)
        theta(2551) = theta(2186)+theta(1976)*AB(1) ! ((0,3,2)|(2,0,2)) = ((1,3,2)|(1,0,2))+((0,3,2)|(1,0,2))*AB(1)
        theta(2552) = theta(2187)+theta(1977)*AB(1) ! ((0,3,2)|(1,3,0)) = ((1,3,2)|(0,3,0))+((0,3,2)|(0,3,0))*AB(1)
        theta(2553) = theta(2188)+theta(1978)*AB(1) ! ((0,3,2)|(1,2,1)) = ((1,3,2)|(0,2,1))+((0,3,2)|(0,2,1))*AB(1)
        theta(2554) = theta(2189)+theta(1979)*AB(1) ! ((0,3,2)|(1,1,2)) = ((1,3,2)|(0,1,2))+((0,3,2)|(0,1,2))*AB(1)
        theta(2555) = theta(2190)+theta(1980)*AB(1) ! ((0,3,2)|(1,0,3)) = ((1,3,2)|(0,0,3))+((0,3,2)|(0,0,3))*AB(1)
        theta(2556) = theta(2247)+theta(1977)*AB(2) ! ((0,3,2)|(0,4,0)) = ((0,4,2)|(0,3,0))+((0,3,2)|(0,3,0))*AB(2)
        theta(2557) = theta(2257)+theta(1977)*AB(3) ! ((0,3,2)|(0,3,1)) = ((0,3,3)|(0,3,0))+((0,3,2)|(0,3,0))*AB(3)
        theta(2558) = theta(2249)+theta(1979)*AB(2) ! ((0,3,2)|(0,2,2)) = ((0,4,2)|(0,1,2))+((0,3,2)|(0,1,2))*AB(2)
        theta(2559) = theta(2250)+theta(1980)*AB(2) ! ((0,3,2)|(0,1,3)) = ((0,4,2)|(0,0,3))+((0,3,2)|(0,0,3))*AB(2)
        theta(2560) = theta(2260)+theta(1980)*AB(3) ! ((0,3,2)|(0,0,4)) = ((0,3,3)|(0,0,3))+((0,3,2)|(0,0,3))*AB(3)
        theta(2561) = theta(2191)+theta(1981)*AB(1) ! ((0,2,3)|(4,0,0)) = ((1,2,3)|(3,0,0))+((0,2,3)|(3,0,0))*AB(1)
        theta(2562) = theta(2192)+theta(1982)*AB(1) ! ((0,2,3)|(3,1,0)) = ((1,2,3)|(2,1,0))+((0,2,3)|(2,1,0))*AB(1)
        theta(2563) = theta(2261)+theta(1981)*AB(3) ! ((0,2,3)|(3,0,1)) = ((0,2,4)|(3,0,0))+((0,2,3)|(3,0,0))*AB(3)
        theta(2564) = theta(2194)+theta(1984)*AB(1) ! ((0,2,3)|(2,2,0)) = ((1,2,3)|(1,2,0))+((0,2,3)|(1,2,0))*AB(1)
        theta(2565) = theta(2195)+theta(1985)*AB(1) ! ((0,2,3)|(2,1,1)) = ((1,2,3)|(1,1,1))+((0,2,3)|(1,1,1))*AB(1)
        theta(2566) = theta(2196)+theta(1986)*AB(1) ! ((0,2,3)|(2,0,2)) = ((1,2,3)|(1,0,2))+((0,2,3)|(1,0,2))*AB(1)
        theta(2567) = theta(2197)+theta(1987)*AB(1) ! ((0,2,3)|(1,3,0)) = ((1,2,3)|(0,3,0))+((0,2,3)|(0,3,0))*AB(1)
        theta(2568) = theta(2198)+theta(1988)*AB(1) ! ((0,2,3)|(1,2,1)) = ((1,2,3)|(0,2,1))+((0,2,3)|(0,2,1))*AB(1)
        theta(2569) = theta(2199)+theta(1989)*AB(1) ! ((0,2,3)|(1,1,2)) = ((1,2,3)|(0,1,2))+((0,2,3)|(0,1,2))*AB(1)
        theta(2570) = theta(2200)+theta(1990)*AB(1) ! ((0,2,3)|(1,0,3)) = ((1,2,3)|(0,0,3))+((0,2,3)|(0,0,3))*AB(1)
        theta(2571) = theta(2257)+theta(1987)*AB(2) ! ((0,2,3)|(0,4,0)) = ((0,3,3)|(0,3,0))+((0,2,3)|(0,3,0))*AB(2)
        theta(2572) = theta(2267)+theta(1987)*AB(3) ! ((0,2,3)|(0,3,1)) = ((0,2,4)|(0,3,0))+((0,2,3)|(0,3,0))*AB(3)
        theta(2573) = theta(2259)+theta(1989)*AB(2) ! ((0,2,3)|(0,2,2)) = ((0,3,3)|(0,1,2))+((0,2,3)|(0,1,2))*AB(2)
        theta(2574) = theta(2260)+theta(1990)*AB(2) ! ((0,2,3)|(0,1,3)) = ((0,3,3)|(0,0,3))+((0,2,3)|(0,0,3))*AB(2)
        theta(2575) = theta(2270)+theta(1990)*AB(3) ! ((0,2,3)|(0,0,4)) = ((0,2,4)|(0,0,3))+((0,2,3)|(0,0,3))*AB(3)
        theta(2576) = theta(2201)+theta(1991)*AB(1) ! ((0,1,4)|(4,0,0)) = ((1,1,4)|(3,0,0))+((0,1,4)|(3,0,0))*AB(1)
        theta(2577) = theta(2202)+theta(1992)*AB(1) ! ((0,1,4)|(3,1,0)) = ((1,1,4)|(2,1,0))+((0,1,4)|(2,1,0))*AB(1)
        theta(2578) = theta(2271)+theta(1991)*AB(3) ! ((0,1,4)|(3,0,1)) = ((0,1,5)|(3,0,0))+((0,1,4)|(3,0,0))*AB(3)
        theta(2579) = theta(2204)+theta(1994)*AB(1) ! ((0,1,4)|(2,2,0)) = ((1,1,4)|(1,2,0))+((0,1,4)|(1,2,0))*AB(1)
        theta(2580) = theta(2205)+theta(1995)*AB(1) ! ((0,1,4)|(2,1,1)) = ((1,1,4)|(1,1,1))+((0,1,4)|(1,1,1))*AB(1)
        theta(2581) = theta(2206)+theta(1996)*AB(1) ! ((0,1,4)|(2,0,2)) = ((1,1,4)|(1,0,2))+((0,1,4)|(1,0,2))*AB(1)
        theta(2582) = theta(2207)+theta(1997)*AB(1) ! ((0,1,4)|(1,3,0)) = ((1,1,4)|(0,3,0))+((0,1,4)|(0,3,0))*AB(1)
        theta(2583) = theta(2208)+theta(1998)*AB(1) ! ((0,1,4)|(1,2,1)) = ((1,1,4)|(0,2,1))+((0,1,4)|(0,2,1))*AB(1)
        theta(2584) = theta(2209)+theta(1999)*AB(1) ! ((0,1,4)|(1,1,2)) = ((1,1,4)|(0,1,2))+((0,1,4)|(0,1,2))*AB(1)
        theta(2585) = theta(2210)+theta(2000)*AB(1) ! ((0,1,4)|(1,0,3)) = ((1,1,4)|(0,0,3))+((0,1,4)|(0,0,3))*AB(1)
        theta(2586) = theta(2267)+theta(1997)*AB(2) ! ((0,1,4)|(0,4,0)) = ((0,2,4)|(0,3,0))+((0,1,4)|(0,3,0))*AB(2)
        theta(2587) = theta(2277)+theta(1997)*AB(3) ! ((0,1,4)|(0,3,1)) = ((0,1,5)|(0,3,0))+((0,1,4)|(0,3,0))*AB(3)
        theta(2588) = theta(2269)+theta(1999)*AB(2) ! ((0,1,4)|(0,2,2)) = ((0,2,4)|(0,1,2))+((0,1,4)|(0,1,2))*AB(2)
        theta(2589) = theta(2270)+theta(2000)*AB(2) ! ((0,1,4)|(0,1,3)) = ((0,2,4)|(0,0,3))+((0,1,4)|(0,0,3))*AB(2)
        theta(2590) = theta(2280)+theta(2000)*AB(3) ! ((0,1,4)|(0,0,4)) = ((0,1,5)|(0,0,3))+((0,1,4)|(0,0,3))*AB(3)
        theta(2591) = theta(2211)+theta(2001)*AB(1) ! ((0,0,5)|(4,0,0)) = ((1,0,5)|(3,0,0))+((0,0,5)|(3,0,0))*AB(1)
        theta(2592) = theta(2212)+theta(2002)*AB(1) ! ((0,0,5)|(3,1,0)) = ((1,0,5)|(2,1,0))+((0,0,5)|(2,1,0))*AB(1)
        theta(2593) = theta(2281)+theta(2001)*AB(3) ! ((0,0,5)|(3,0,1)) = ((0,0,6)|(3,0,0))+((0,0,5)|(3,0,0))*AB(3)
        theta(2594) = theta(2214)+theta(2004)*AB(1) ! ((0,0,5)|(2,2,0)) = ((1,0,5)|(1,2,0))+((0,0,5)|(1,2,0))*AB(1)
        theta(2595) = theta(2215)+theta(2005)*AB(1) ! ((0,0,5)|(2,1,1)) = ((1,0,5)|(1,1,1))+((0,0,5)|(1,1,1))*AB(1)
        theta(2596) = theta(2216)+theta(2006)*AB(1) ! ((0,0,5)|(2,0,2)) = ((1,0,5)|(1,0,2))+((0,0,5)|(1,0,2))*AB(1)
        theta(2597) = theta(2217)+theta(2007)*AB(1) ! ((0,0,5)|(1,3,0)) = ((1,0,5)|(0,3,0))+((0,0,5)|(0,3,0))*AB(1)
        theta(2598) = theta(2218)+theta(2008)*AB(1) ! ((0,0,5)|(1,2,1)) = ((1,0,5)|(0,2,1))+((0,0,5)|(0,2,1))*AB(1)
        theta(2599) = theta(2219)+theta(2009)*AB(1) ! ((0,0,5)|(1,1,2)) = ((1,0,5)|(0,1,2))+((0,0,5)|(0,1,2))*AB(1)
        theta(2600) = theta(2220)+theta(2010)*AB(1) ! ((0,0,5)|(1,0,3)) = ((1,0,5)|(0,0,3))+((0,0,5)|(0,0,3))*AB(1)
        theta(2601) = theta(2277)+theta(2007)*AB(2) ! ((0,0,5)|(0,4,0)) = ((0,1,5)|(0,3,0))+((0,0,5)|(0,3,0))*AB(2)
        theta(2602) = theta(2287)+theta(2007)*AB(3) ! ((0,0,5)|(0,3,1)) = ((0,0,6)|(0,3,0))+((0,0,5)|(0,3,0))*AB(3)
        theta(2603) = theta(2279)+theta(2009)*AB(2) ! ((0,0,5)|(0,2,2)) = ((0,1,5)|(0,1,2))+((0,0,5)|(0,1,2))*AB(2)
        theta(2604) = theta(2280)+theta(2010)*AB(2) ! ((0,0,5)|(0,1,3)) = ((0,1,5)|(0,0,3))+((0,0,5)|(0,0,3))*AB(2)
        theta(2605) = theta(2290)+theta(2010)*AB(3) ! ((0,0,5)|(0,0,4)) = ((0,0,6)|(0,0,3))+((0,0,5)|(0,0,3))*AB(3)
    end subroutine
    subroutine hrr_5_5(AB, theta)
        real*8,intent(in) :: AB(3)
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 3612; Optimized integrals: 2839
        theta(1253) = theta(1023)+theta(1002)*AB(1) ! ((5,0,0)|(1,0,0)) = ((6,0,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(1)
        theta(1254) = theta(1024)+theta(1002)*AB(2) ! ((5,0,0)|(0,1,0)) = ((5,1,0)|(0,0,0))+((5,0,0)|(0,0,0))*AB(2)
        theta(1255) = theta(1025)+theta(1002)*AB(3) ! ((5,0,0)|(0,0,1)) = ((5,0,1)|(0,0,0))+((5,0,0)|(0,0,0))*AB(3)
        theta(1256) = theta(1024)+theta(1003)*AB(1) ! ((4,1,0)|(1,0,0)) = ((5,1,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(1)
        theta(1257) = theta(1026)+theta(1003)*AB(2) ! ((4,1,0)|(0,1,0)) = ((4,2,0)|(0,0,0))+((4,1,0)|(0,0,0))*AB(2)
        theta(1258) = theta(1027)+theta(1003)*AB(3) ! ((4,1,0)|(0,0,1)) = ((4,1,1)|(0,0,0))+((4,1,0)|(0,0,0))*AB(3)
        theta(1259) = theta(1025)+theta(1004)*AB(1) ! ((4,0,1)|(1,0,0)) = ((5,0,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(1)
        theta(1260) = theta(1027)+theta(1004)*AB(2) ! ((4,0,1)|(0,1,0)) = ((4,1,1)|(0,0,0))+((4,0,1)|(0,0,0))*AB(2)
        theta(1261) = theta(1028)+theta(1004)*AB(3) ! ((4,0,1)|(0,0,1)) = ((4,0,2)|(0,0,0))+((4,0,1)|(0,0,0))*AB(3)
        theta(1262) = theta(1026)+theta(1005)*AB(1) ! ((3,2,0)|(1,0,0)) = ((4,2,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(1)
        theta(1263) = theta(1029)+theta(1005)*AB(2) ! ((3,2,0)|(0,1,0)) = ((3,3,0)|(0,0,0))+((3,2,0)|(0,0,0))*AB(2)
        theta(1264) = theta(1030)+theta(1005)*AB(3) ! ((3,2,0)|(0,0,1)) = ((3,2,1)|(0,0,0))+((3,2,0)|(0,0,0))*AB(3)
        theta(1265) = theta(1027)+theta(1006)*AB(1) ! ((3,1,1)|(1,0,0)) = ((4,1,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(1)
        theta(1266) = theta(1030)+theta(1006)*AB(2) ! ((3,1,1)|(0,1,0)) = ((3,2,1)|(0,0,0))+((3,1,1)|(0,0,0))*AB(2)
        theta(1267) = theta(1031)+theta(1006)*AB(3) ! ((3,1,1)|(0,0,1)) = ((3,1,2)|(0,0,0))+((3,1,1)|(0,0,0))*AB(3)
        theta(1268) = theta(1028)+theta(1007)*AB(1) ! ((3,0,2)|(1,0,0)) = ((4,0,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(1)
        theta(1269) = theta(1031)+theta(1007)*AB(2) ! ((3,0,2)|(0,1,0)) = ((3,1,2)|(0,0,0))+((3,0,2)|(0,0,0))*AB(2)
        theta(1270) = theta(1032)+theta(1007)*AB(3) ! ((3,0,2)|(0,0,1)) = ((3,0,3)|(0,0,0))+((3,0,2)|(0,0,0))*AB(3)
        theta(1271) = theta(1029)+theta(1008)*AB(1) ! ((2,3,0)|(1,0,0)) = ((3,3,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(1)
        theta(1272) = theta(1033)+theta(1008)*AB(2) ! ((2,3,0)|(0,1,0)) = ((2,4,0)|(0,0,0))+((2,3,0)|(0,0,0))*AB(2)
        theta(1273) = theta(1034)+theta(1008)*AB(3) ! ((2,3,0)|(0,0,1)) = ((2,3,1)|(0,0,0))+((2,3,0)|(0,0,0))*AB(3)
        theta(1274) = theta(1030)+theta(1009)*AB(1) ! ((2,2,1)|(1,0,0)) = ((3,2,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(1)
        theta(1275) = theta(1034)+theta(1009)*AB(2) ! ((2,2,1)|(0,1,0)) = ((2,3,1)|(0,0,0))+((2,2,1)|(0,0,0))*AB(2)
        theta(1276) = theta(1035)+theta(1009)*AB(3) ! ((2,2,1)|(0,0,1)) = ((2,2,2)|(0,0,0))+((2,2,1)|(0,0,0))*AB(3)
        theta(1277) = theta(1031)+theta(1010)*AB(1) ! ((2,1,2)|(1,0,0)) = ((3,1,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(1)
        theta(1278) = theta(1035)+theta(1010)*AB(2) ! ((2,1,2)|(0,1,0)) = ((2,2,2)|(0,0,0))+((2,1,2)|(0,0,0))*AB(2)
        theta(1279) = theta(1036)+theta(1010)*AB(3) ! ((2,1,2)|(0,0,1)) = ((2,1,3)|(0,0,0))+((2,1,2)|(0,0,0))*AB(3)
        theta(1280) = theta(1032)+theta(1011)*AB(1) ! ((2,0,3)|(1,0,0)) = ((3,0,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(1)
        theta(1281) = theta(1036)+theta(1011)*AB(2) ! ((2,0,3)|(0,1,0)) = ((2,1,3)|(0,0,0))+((2,0,3)|(0,0,0))*AB(2)
        theta(1282) = theta(1037)+theta(1011)*AB(3) ! ((2,0,3)|(0,0,1)) = ((2,0,4)|(0,0,0))+((2,0,3)|(0,0,0))*AB(3)
        theta(1283) = theta(1033)+theta(1012)*AB(1) ! ((1,4,0)|(1,0,0)) = ((2,4,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(1)
        theta(1284) = theta(1038)+theta(1012)*AB(2) ! ((1,4,0)|(0,1,0)) = ((1,5,0)|(0,0,0))+((1,4,0)|(0,0,0))*AB(2)
        theta(1285) = theta(1039)+theta(1012)*AB(3) ! ((1,4,0)|(0,0,1)) = ((1,4,1)|(0,0,0))+((1,4,0)|(0,0,0))*AB(3)
        theta(1286) = theta(1034)+theta(1013)*AB(1) ! ((1,3,1)|(1,0,0)) = ((2,3,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(1)
        theta(1287) = theta(1039)+theta(1013)*AB(2) ! ((1,3,1)|(0,1,0)) = ((1,4,1)|(0,0,0))+((1,3,1)|(0,0,0))*AB(2)
        theta(1288) = theta(1040)+theta(1013)*AB(3) ! ((1,3,1)|(0,0,1)) = ((1,3,2)|(0,0,0))+((1,3,1)|(0,0,0))*AB(3)
        theta(1289) = theta(1035)+theta(1014)*AB(1) ! ((1,2,2)|(1,0,0)) = ((2,2,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(1)
        theta(1290) = theta(1040)+theta(1014)*AB(2) ! ((1,2,2)|(0,1,0)) = ((1,3,2)|(0,0,0))+((1,2,2)|(0,0,0))*AB(2)
        theta(1291) = theta(1041)+theta(1014)*AB(3) ! ((1,2,2)|(0,0,1)) = ((1,2,3)|(0,0,0))+((1,2,2)|(0,0,0))*AB(3)
        theta(1292) = theta(1036)+theta(1015)*AB(1) ! ((1,1,3)|(1,0,0)) = ((2,1,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(1)
        theta(1293) = theta(1041)+theta(1015)*AB(2) ! ((1,1,3)|(0,1,0)) = ((1,2,3)|(0,0,0))+((1,1,3)|(0,0,0))*AB(2)
        theta(1294) = theta(1042)+theta(1015)*AB(3) ! ((1,1,3)|(0,0,1)) = ((1,1,4)|(0,0,0))+((1,1,3)|(0,0,0))*AB(3)
        theta(1295) = theta(1037)+theta(1016)*AB(1) ! ((1,0,4)|(1,0,0)) = ((2,0,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(1)
        theta(1296) = theta(1042)+theta(1016)*AB(2) ! ((1,0,4)|(0,1,0)) = ((1,1,4)|(0,0,0))+((1,0,4)|(0,0,0))*AB(2)
        theta(1297) = theta(1043)+theta(1016)*AB(3) ! ((1,0,4)|(0,0,1)) = ((1,0,5)|(0,0,0))+((1,0,4)|(0,0,0))*AB(3)
        theta(1298) = theta(1038)+theta(1017)*AB(1) ! ((0,5,0)|(1,0,0)) = ((1,5,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(1)
        theta(1299) = theta(1044)+theta(1017)*AB(2) ! ((0,5,0)|(0,1,0)) = ((0,6,0)|(0,0,0))+((0,5,0)|(0,0,0))*AB(2)
        theta(1300) = theta(1045)+theta(1017)*AB(3) ! ((0,5,0)|(0,0,1)) = ((0,5,1)|(0,0,0))+((0,5,0)|(0,0,0))*AB(3)
        theta(1301) = theta(1039)+theta(1018)*AB(1) ! ((0,4,1)|(1,0,0)) = ((1,4,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(1)
        theta(1302) = theta(1045)+theta(1018)*AB(2) ! ((0,4,1)|(0,1,0)) = ((0,5,1)|(0,0,0))+((0,4,1)|(0,0,0))*AB(2)
        theta(1303) = theta(1046)+theta(1018)*AB(3) ! ((0,4,1)|(0,0,1)) = ((0,4,2)|(0,0,0))+((0,4,1)|(0,0,0))*AB(3)
        theta(1304) = theta(1040)+theta(1019)*AB(1) ! ((0,3,2)|(1,0,0)) = ((1,3,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(1)
        theta(1305) = theta(1046)+theta(1019)*AB(2) ! ((0,3,2)|(0,1,0)) = ((0,4,2)|(0,0,0))+((0,3,2)|(0,0,0))*AB(2)
        theta(1306) = theta(1047)+theta(1019)*AB(3) ! ((0,3,2)|(0,0,1)) = ((0,3,3)|(0,0,0))+((0,3,2)|(0,0,0))*AB(3)
        theta(1307) = theta(1041)+theta(1020)*AB(1) ! ((0,2,3)|(1,0,0)) = ((1,2,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(1)
        theta(1308) = theta(1047)+theta(1020)*AB(2) ! ((0,2,3)|(0,1,0)) = ((0,3,3)|(0,0,0))+((0,2,3)|(0,0,0))*AB(2)
        theta(1309) = theta(1048)+theta(1020)*AB(3) ! ((0,2,3)|(0,0,1)) = ((0,2,4)|(0,0,0))+((0,2,3)|(0,0,0))*AB(3)
        theta(1310) = theta(1042)+theta(1021)*AB(1) ! ((0,1,4)|(1,0,0)) = ((1,1,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(1)
        theta(1311) = theta(1048)+theta(1021)*AB(2) ! ((0,1,4)|(0,1,0)) = ((0,2,4)|(0,0,0))+((0,1,4)|(0,0,0))*AB(2)
        theta(1312) = theta(1049)+theta(1021)*AB(3) ! ((0,1,4)|(0,0,1)) = ((0,1,5)|(0,0,0))+((0,1,4)|(0,0,0))*AB(3)
        theta(1313) = theta(1043)+theta(1022)*AB(1) ! ((0,0,5)|(1,0,0)) = ((1,0,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(1)
        theta(1314) = theta(1049)+theta(1022)*AB(2) ! ((0,0,5)|(0,1,0)) = ((0,1,5)|(0,0,0))+((0,0,5)|(0,0,0))*AB(2)
        theta(1315) = theta(1050)+theta(1022)*AB(3) ! ((0,0,5)|(0,0,1)) = ((0,0,6)|(0,0,0))+((0,0,5)|(0,0,0))*AB(3)
        theta(1316) = theta(1051)+theta(1023)*AB(1) ! ((6,0,0)|(1,0,0)) = ((7,0,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(1)
        theta(1317) = theta(1052)+theta(1023)*AB(2) ! ((6,0,0)|(0,1,0)) = ((6,1,0)|(0,0,0))+((6,0,0)|(0,0,0))*AB(2)
        theta(1318) = theta(1053)+theta(1023)*AB(3) ! ((6,0,0)|(0,0,1)) = ((6,0,1)|(0,0,0))+((6,0,0)|(0,0,0))*AB(3)
        theta(1319) = theta(1052)+theta(1024)*AB(1) ! ((5,1,0)|(1,0,0)) = ((6,1,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(1)
        theta(1320) = theta(1054)+theta(1024)*AB(2) ! ((5,1,0)|(0,1,0)) = ((5,2,0)|(0,0,0))+((5,1,0)|(0,0,0))*AB(2)
        theta(1321) = theta(1055)+theta(1024)*AB(3) ! ((5,1,0)|(0,0,1)) = ((5,1,1)|(0,0,0))+((5,1,0)|(0,0,0))*AB(3)
        theta(1322) = theta(1053)+theta(1025)*AB(1) ! ((5,0,1)|(1,0,0)) = ((6,0,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(1)
        theta(1323) = theta(1055)+theta(1025)*AB(2) ! ((5,0,1)|(0,1,0)) = ((5,1,1)|(0,0,0))+((5,0,1)|(0,0,0))*AB(2)
        theta(1324) = theta(1056)+theta(1025)*AB(3) ! ((5,0,1)|(0,0,1)) = ((5,0,2)|(0,0,0))+((5,0,1)|(0,0,0))*AB(3)
        theta(1325) = theta(1054)+theta(1026)*AB(1) ! ((4,2,0)|(1,0,0)) = ((5,2,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(1)
        theta(1326) = theta(1057)+theta(1026)*AB(2) ! ((4,2,0)|(0,1,0)) = ((4,3,0)|(0,0,0))+((4,2,0)|(0,0,0))*AB(2)
        theta(1327) = theta(1058)+theta(1026)*AB(3) ! ((4,2,0)|(0,0,1)) = ((4,2,1)|(0,0,0))+((4,2,0)|(0,0,0))*AB(3)
        theta(1328) = theta(1055)+theta(1027)*AB(1) ! ((4,1,1)|(1,0,0)) = ((5,1,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(1)
        theta(1329) = theta(1058)+theta(1027)*AB(2) ! ((4,1,1)|(0,1,0)) = ((4,2,1)|(0,0,0))+((4,1,1)|(0,0,0))*AB(2)
        theta(1330) = theta(1059)+theta(1027)*AB(3) ! ((4,1,1)|(0,0,1)) = ((4,1,2)|(0,0,0))+((4,1,1)|(0,0,0))*AB(3)
        theta(1331) = theta(1056)+theta(1028)*AB(1) ! ((4,0,2)|(1,0,0)) = ((5,0,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(1)
        theta(1332) = theta(1059)+theta(1028)*AB(2) ! ((4,0,2)|(0,1,0)) = ((4,1,2)|(0,0,0))+((4,0,2)|(0,0,0))*AB(2)
        theta(1333) = theta(1060)+theta(1028)*AB(3) ! ((4,0,2)|(0,0,1)) = ((4,0,3)|(0,0,0))+((4,0,2)|(0,0,0))*AB(3)
        theta(1334) = theta(1057)+theta(1029)*AB(1) ! ((3,3,0)|(1,0,0)) = ((4,3,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(1)
        theta(1335) = theta(1061)+theta(1029)*AB(2) ! ((3,3,0)|(0,1,0)) = ((3,4,0)|(0,0,0))+((3,3,0)|(0,0,0))*AB(2)
        theta(1336) = theta(1062)+theta(1029)*AB(3) ! ((3,3,0)|(0,0,1)) = ((3,3,1)|(0,0,0))+((3,3,0)|(0,0,0))*AB(3)
        theta(1337) = theta(1058)+theta(1030)*AB(1) ! ((3,2,1)|(1,0,0)) = ((4,2,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(1)
        theta(1338) = theta(1062)+theta(1030)*AB(2) ! ((3,2,1)|(0,1,0)) = ((3,3,1)|(0,0,0))+((3,2,1)|(0,0,0))*AB(2)
        theta(1339) = theta(1063)+theta(1030)*AB(3) ! ((3,2,1)|(0,0,1)) = ((3,2,2)|(0,0,0))+((3,2,1)|(0,0,0))*AB(3)
        theta(1340) = theta(1059)+theta(1031)*AB(1) ! ((3,1,2)|(1,0,0)) = ((4,1,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(1)
        theta(1341) = theta(1063)+theta(1031)*AB(2) ! ((3,1,2)|(0,1,0)) = ((3,2,2)|(0,0,0))+((3,1,2)|(0,0,0))*AB(2)
        theta(1342) = theta(1064)+theta(1031)*AB(3) ! ((3,1,2)|(0,0,1)) = ((3,1,3)|(0,0,0))+((3,1,2)|(0,0,0))*AB(3)
        theta(1343) = theta(1060)+theta(1032)*AB(1) ! ((3,0,3)|(1,0,0)) = ((4,0,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(1)
        theta(1344) = theta(1064)+theta(1032)*AB(2) ! ((3,0,3)|(0,1,0)) = ((3,1,3)|(0,0,0))+((3,0,3)|(0,0,0))*AB(2)
        theta(1345) = theta(1065)+theta(1032)*AB(3) ! ((3,0,3)|(0,0,1)) = ((3,0,4)|(0,0,0))+((3,0,3)|(0,0,0))*AB(3)
        theta(1346) = theta(1061)+theta(1033)*AB(1) ! ((2,4,0)|(1,0,0)) = ((3,4,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(1)
        theta(1347) = theta(1066)+theta(1033)*AB(2) ! ((2,4,0)|(0,1,0)) = ((2,5,0)|(0,0,0))+((2,4,0)|(0,0,0))*AB(2)
        theta(1348) = theta(1067)+theta(1033)*AB(3) ! ((2,4,0)|(0,0,1)) = ((2,4,1)|(0,0,0))+((2,4,0)|(0,0,0))*AB(3)
        theta(1349) = theta(1062)+theta(1034)*AB(1) ! ((2,3,1)|(1,0,0)) = ((3,3,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(1)
        theta(1350) = theta(1067)+theta(1034)*AB(2) ! ((2,3,1)|(0,1,0)) = ((2,4,1)|(0,0,0))+((2,3,1)|(0,0,0))*AB(2)
        theta(1351) = theta(1068)+theta(1034)*AB(3) ! ((2,3,1)|(0,0,1)) = ((2,3,2)|(0,0,0))+((2,3,1)|(0,0,0))*AB(3)
        theta(1352) = theta(1063)+theta(1035)*AB(1) ! ((2,2,2)|(1,0,0)) = ((3,2,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(1)
        theta(1353) = theta(1068)+theta(1035)*AB(2) ! ((2,2,2)|(0,1,0)) = ((2,3,2)|(0,0,0))+((2,2,2)|(0,0,0))*AB(2)
        theta(1354) = theta(1069)+theta(1035)*AB(3) ! ((2,2,2)|(0,0,1)) = ((2,2,3)|(0,0,0))+((2,2,2)|(0,0,0))*AB(3)
        theta(1355) = theta(1064)+theta(1036)*AB(1) ! ((2,1,3)|(1,0,0)) = ((3,1,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(1)
        theta(1356) = theta(1069)+theta(1036)*AB(2) ! ((2,1,3)|(0,1,0)) = ((2,2,3)|(0,0,0))+((2,1,3)|(0,0,0))*AB(2)
        theta(1357) = theta(1070)+theta(1036)*AB(3) ! ((2,1,3)|(0,0,1)) = ((2,1,4)|(0,0,0))+((2,1,3)|(0,0,0))*AB(3)
        theta(1358) = theta(1065)+theta(1037)*AB(1) ! ((2,0,4)|(1,0,0)) = ((3,0,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(1)
        theta(1359) = theta(1070)+theta(1037)*AB(2) ! ((2,0,4)|(0,1,0)) = ((2,1,4)|(0,0,0))+((2,0,4)|(0,0,0))*AB(2)
        theta(1360) = theta(1071)+theta(1037)*AB(3) ! ((2,0,4)|(0,0,1)) = ((2,0,5)|(0,0,0))+((2,0,4)|(0,0,0))*AB(3)
        theta(1361) = theta(1066)+theta(1038)*AB(1) ! ((1,5,0)|(1,0,0)) = ((2,5,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(1)
        theta(1362) = theta(1072)+theta(1038)*AB(2) ! ((1,5,0)|(0,1,0)) = ((1,6,0)|(0,0,0))+((1,5,0)|(0,0,0))*AB(2)
        theta(1363) = theta(1073)+theta(1038)*AB(3) ! ((1,5,0)|(0,0,1)) = ((1,5,1)|(0,0,0))+((1,5,0)|(0,0,0))*AB(3)
        theta(1364) = theta(1067)+theta(1039)*AB(1) ! ((1,4,1)|(1,0,0)) = ((2,4,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(1)
        theta(1365) = theta(1073)+theta(1039)*AB(2) ! ((1,4,1)|(0,1,0)) = ((1,5,1)|(0,0,0))+((1,4,1)|(0,0,0))*AB(2)
        theta(1366) = theta(1074)+theta(1039)*AB(3) ! ((1,4,1)|(0,0,1)) = ((1,4,2)|(0,0,0))+((1,4,1)|(0,0,0))*AB(3)
        theta(1367) = theta(1068)+theta(1040)*AB(1) ! ((1,3,2)|(1,0,0)) = ((2,3,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(1)
        theta(1368) = theta(1074)+theta(1040)*AB(2) ! ((1,3,2)|(0,1,0)) = ((1,4,2)|(0,0,0))+((1,3,2)|(0,0,0))*AB(2)
        theta(1369) = theta(1075)+theta(1040)*AB(3) ! ((1,3,2)|(0,0,1)) = ((1,3,3)|(0,0,0))+((1,3,2)|(0,0,0))*AB(3)
        theta(1370) = theta(1069)+theta(1041)*AB(1) ! ((1,2,3)|(1,0,0)) = ((2,2,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(1)
        theta(1371) = theta(1075)+theta(1041)*AB(2) ! ((1,2,3)|(0,1,0)) = ((1,3,3)|(0,0,0))+((1,2,3)|(0,0,0))*AB(2)
        theta(1372) = theta(1076)+theta(1041)*AB(3) ! ((1,2,3)|(0,0,1)) = ((1,2,4)|(0,0,0))+((1,2,3)|(0,0,0))*AB(3)
        theta(1373) = theta(1070)+theta(1042)*AB(1) ! ((1,1,4)|(1,0,0)) = ((2,1,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(1)
        theta(1374) = theta(1076)+theta(1042)*AB(2) ! ((1,1,4)|(0,1,0)) = ((1,2,4)|(0,0,0))+((1,1,4)|(0,0,0))*AB(2)
        theta(1375) = theta(1077)+theta(1042)*AB(3) ! ((1,1,4)|(0,0,1)) = ((1,1,5)|(0,0,0))+((1,1,4)|(0,0,0))*AB(3)
        theta(1376) = theta(1071)+theta(1043)*AB(1) ! ((1,0,5)|(1,0,0)) = ((2,0,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(1)
        theta(1377) = theta(1077)+theta(1043)*AB(2) ! ((1,0,5)|(0,1,0)) = ((1,1,5)|(0,0,0))+((1,0,5)|(0,0,0))*AB(2)
        theta(1378) = theta(1078)+theta(1043)*AB(3) ! ((1,0,5)|(0,0,1)) = ((1,0,6)|(0,0,0))+((1,0,5)|(0,0,0))*AB(3)
        theta(1379) = theta(1072)+theta(1044)*AB(1) ! ((0,6,0)|(1,0,0)) = ((1,6,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(1)
        theta(1380) = theta(1079)+theta(1044)*AB(2) ! ((0,6,0)|(0,1,0)) = ((0,7,0)|(0,0,0))+((0,6,0)|(0,0,0))*AB(2)
        theta(1381) = theta(1080)+theta(1044)*AB(3) ! ((0,6,0)|(0,0,1)) = ((0,6,1)|(0,0,0))+((0,6,0)|(0,0,0))*AB(3)
        theta(1382) = theta(1073)+theta(1045)*AB(1) ! ((0,5,1)|(1,0,0)) = ((1,5,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(1)
        theta(1383) = theta(1080)+theta(1045)*AB(2) ! ((0,5,1)|(0,1,0)) = ((0,6,1)|(0,0,0))+((0,5,1)|(0,0,0))*AB(2)
        theta(1384) = theta(1081)+theta(1045)*AB(3) ! ((0,5,1)|(0,0,1)) = ((0,5,2)|(0,0,0))+((0,5,1)|(0,0,0))*AB(3)
        theta(1385) = theta(1074)+theta(1046)*AB(1) ! ((0,4,2)|(1,0,0)) = ((1,4,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(1)
        theta(1386) = theta(1081)+theta(1046)*AB(2) ! ((0,4,2)|(0,1,0)) = ((0,5,2)|(0,0,0))+((0,4,2)|(0,0,0))*AB(2)
        theta(1387) = theta(1082)+theta(1046)*AB(3) ! ((0,4,2)|(0,0,1)) = ((0,4,3)|(0,0,0))+((0,4,2)|(0,0,0))*AB(3)
        theta(1388) = theta(1075)+theta(1047)*AB(1) ! ((0,3,3)|(1,0,0)) = ((1,3,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(1)
        theta(1389) = theta(1082)+theta(1047)*AB(2) ! ((0,3,3)|(0,1,0)) = ((0,4,3)|(0,0,0))+((0,3,3)|(0,0,0))*AB(2)
        theta(1390) = theta(1083)+theta(1047)*AB(3) ! ((0,3,3)|(0,0,1)) = ((0,3,4)|(0,0,0))+((0,3,3)|(0,0,0))*AB(3)
        theta(1391) = theta(1076)+theta(1048)*AB(1) ! ((0,2,4)|(1,0,0)) = ((1,2,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(1)
        theta(1392) = theta(1083)+theta(1048)*AB(2) ! ((0,2,4)|(0,1,0)) = ((0,3,4)|(0,0,0))+((0,2,4)|(0,0,0))*AB(2)
        theta(1393) = theta(1084)+theta(1048)*AB(3) ! ((0,2,4)|(0,0,1)) = ((0,2,5)|(0,0,0))+((0,2,4)|(0,0,0))*AB(3)
        theta(1394) = theta(1077)+theta(1049)*AB(1) ! ((0,1,5)|(1,0,0)) = ((1,1,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(1)
        theta(1395) = theta(1084)+theta(1049)*AB(2) ! ((0,1,5)|(0,1,0)) = ((0,2,5)|(0,0,0))+((0,1,5)|(0,0,0))*AB(2)
        theta(1396) = theta(1085)+theta(1049)*AB(3) ! ((0,1,5)|(0,0,1)) = ((0,1,6)|(0,0,0))+((0,1,5)|(0,0,0))*AB(3)
        theta(1397) = theta(1078)+theta(1050)*AB(1) ! ((0,0,6)|(1,0,0)) = ((1,0,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(1)
        theta(1398) = theta(1085)+theta(1050)*AB(2) ! ((0,0,6)|(0,1,0)) = ((0,1,6)|(0,0,0))+((0,0,6)|(0,0,0))*AB(2)
        theta(1399) = theta(1086)+theta(1050)*AB(3) ! ((0,0,6)|(0,0,1)) = ((0,0,7)|(0,0,0))+((0,0,6)|(0,0,0))*AB(3)
        theta(1400) = theta(1087)+theta(1051)*AB(1) ! ((7,0,0)|(1,0,0)) = ((8,0,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(1)
        theta(1401) = theta(1088)+theta(1051)*AB(2) ! ((7,0,0)|(0,1,0)) = ((7,1,0)|(0,0,0))+((7,0,0)|(0,0,0))*AB(2)
        theta(1402) = theta(1089)+theta(1051)*AB(3) ! ((7,0,0)|(0,0,1)) = ((7,0,1)|(0,0,0))+((7,0,0)|(0,0,0))*AB(3)
        theta(1403) = theta(1088)+theta(1052)*AB(1) ! ((6,1,0)|(1,0,0)) = ((7,1,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(1)
        theta(1404) = theta(1090)+theta(1052)*AB(2) ! ((6,1,0)|(0,1,0)) = ((6,2,0)|(0,0,0))+((6,1,0)|(0,0,0))*AB(2)
        theta(1405) = theta(1091)+theta(1052)*AB(3) ! ((6,1,0)|(0,0,1)) = ((6,1,1)|(0,0,0))+((6,1,0)|(0,0,0))*AB(3)
        theta(1406) = theta(1089)+theta(1053)*AB(1) ! ((6,0,1)|(1,0,0)) = ((7,0,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(1)
        theta(1407) = theta(1091)+theta(1053)*AB(2) ! ((6,0,1)|(0,1,0)) = ((6,1,1)|(0,0,0))+((6,0,1)|(0,0,0))*AB(2)
        theta(1408) = theta(1092)+theta(1053)*AB(3) ! ((6,0,1)|(0,0,1)) = ((6,0,2)|(0,0,0))+((6,0,1)|(0,0,0))*AB(3)
        theta(1409) = theta(1090)+theta(1054)*AB(1) ! ((5,2,0)|(1,0,0)) = ((6,2,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(1)
        theta(1410) = theta(1093)+theta(1054)*AB(2) ! ((5,2,0)|(0,1,0)) = ((5,3,0)|(0,0,0))+((5,2,0)|(0,0,0))*AB(2)
        theta(1411) = theta(1094)+theta(1054)*AB(3) ! ((5,2,0)|(0,0,1)) = ((5,2,1)|(0,0,0))+((5,2,0)|(0,0,0))*AB(3)
        theta(1412) = theta(1091)+theta(1055)*AB(1) ! ((5,1,1)|(1,0,0)) = ((6,1,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(1)
        theta(1413) = theta(1094)+theta(1055)*AB(2) ! ((5,1,1)|(0,1,0)) = ((5,2,1)|(0,0,0))+((5,1,1)|(0,0,0))*AB(2)
        theta(1414) = theta(1095)+theta(1055)*AB(3) ! ((5,1,1)|(0,0,1)) = ((5,1,2)|(0,0,0))+((5,1,1)|(0,0,0))*AB(3)
        theta(1415) = theta(1092)+theta(1056)*AB(1) ! ((5,0,2)|(1,0,0)) = ((6,0,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(1)
        theta(1416) = theta(1095)+theta(1056)*AB(2) ! ((5,0,2)|(0,1,0)) = ((5,1,2)|(0,0,0))+((5,0,2)|(0,0,0))*AB(2)
        theta(1417) = theta(1096)+theta(1056)*AB(3) ! ((5,0,2)|(0,0,1)) = ((5,0,3)|(0,0,0))+((5,0,2)|(0,0,0))*AB(3)
        theta(1418) = theta(1093)+theta(1057)*AB(1) ! ((4,3,0)|(1,0,0)) = ((5,3,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(1)
        theta(1419) = theta(1097)+theta(1057)*AB(2) ! ((4,3,0)|(0,1,0)) = ((4,4,0)|(0,0,0))+((4,3,0)|(0,0,0))*AB(2)
        theta(1420) = theta(1098)+theta(1057)*AB(3) ! ((4,3,0)|(0,0,1)) = ((4,3,1)|(0,0,0))+((4,3,0)|(0,0,0))*AB(3)
        theta(1421) = theta(1094)+theta(1058)*AB(1) ! ((4,2,1)|(1,0,0)) = ((5,2,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(1)
        theta(1422) = theta(1098)+theta(1058)*AB(2) ! ((4,2,1)|(0,1,0)) = ((4,3,1)|(0,0,0))+((4,2,1)|(0,0,0))*AB(2)
        theta(1423) = theta(1099)+theta(1058)*AB(3) ! ((4,2,1)|(0,0,1)) = ((4,2,2)|(0,0,0))+((4,2,1)|(0,0,0))*AB(3)
        theta(1424) = theta(1095)+theta(1059)*AB(1) ! ((4,1,2)|(1,0,0)) = ((5,1,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(1)
        theta(1425) = theta(1099)+theta(1059)*AB(2) ! ((4,1,2)|(0,1,0)) = ((4,2,2)|(0,0,0))+((4,1,2)|(0,0,0))*AB(2)
        theta(1426) = theta(1100)+theta(1059)*AB(3) ! ((4,1,2)|(0,0,1)) = ((4,1,3)|(0,0,0))+((4,1,2)|(0,0,0))*AB(3)
        theta(1427) = theta(1096)+theta(1060)*AB(1) ! ((4,0,3)|(1,0,0)) = ((5,0,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(1)
        theta(1428) = theta(1100)+theta(1060)*AB(2) ! ((4,0,3)|(0,1,0)) = ((4,1,3)|(0,0,0))+((4,0,3)|(0,0,0))*AB(2)
        theta(1429) = theta(1101)+theta(1060)*AB(3) ! ((4,0,3)|(0,0,1)) = ((4,0,4)|(0,0,0))+((4,0,3)|(0,0,0))*AB(3)
        theta(1430) = theta(1097)+theta(1061)*AB(1) ! ((3,4,0)|(1,0,0)) = ((4,4,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(1)
        theta(1431) = theta(1102)+theta(1061)*AB(2) ! ((3,4,0)|(0,1,0)) = ((3,5,0)|(0,0,0))+((3,4,0)|(0,0,0))*AB(2)
        theta(1432) = theta(1103)+theta(1061)*AB(3) ! ((3,4,0)|(0,0,1)) = ((3,4,1)|(0,0,0))+((3,4,0)|(0,0,0))*AB(3)
        theta(1433) = theta(1098)+theta(1062)*AB(1) ! ((3,3,1)|(1,0,0)) = ((4,3,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(1)
        theta(1434) = theta(1103)+theta(1062)*AB(2) ! ((3,3,1)|(0,1,0)) = ((3,4,1)|(0,0,0))+((3,3,1)|(0,0,0))*AB(2)
        theta(1435) = theta(1104)+theta(1062)*AB(3) ! ((3,3,1)|(0,0,1)) = ((3,3,2)|(0,0,0))+((3,3,1)|(0,0,0))*AB(3)
        theta(1436) = theta(1099)+theta(1063)*AB(1) ! ((3,2,2)|(1,0,0)) = ((4,2,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(1)
        theta(1437) = theta(1104)+theta(1063)*AB(2) ! ((3,2,2)|(0,1,0)) = ((3,3,2)|(0,0,0))+((3,2,2)|(0,0,0))*AB(2)
        theta(1438) = theta(1105)+theta(1063)*AB(3) ! ((3,2,2)|(0,0,1)) = ((3,2,3)|(0,0,0))+((3,2,2)|(0,0,0))*AB(3)
        theta(1439) = theta(1100)+theta(1064)*AB(1) ! ((3,1,3)|(1,0,0)) = ((4,1,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(1)
        theta(1440) = theta(1105)+theta(1064)*AB(2) ! ((3,1,3)|(0,1,0)) = ((3,2,3)|(0,0,0))+((3,1,3)|(0,0,0))*AB(2)
        theta(1441) = theta(1106)+theta(1064)*AB(3) ! ((3,1,3)|(0,0,1)) = ((3,1,4)|(0,0,0))+((3,1,3)|(0,0,0))*AB(3)
        theta(1442) = theta(1101)+theta(1065)*AB(1) ! ((3,0,4)|(1,0,0)) = ((4,0,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(1)
        theta(1443) = theta(1106)+theta(1065)*AB(2) ! ((3,0,4)|(0,1,0)) = ((3,1,4)|(0,0,0))+((3,0,4)|(0,0,0))*AB(2)
        theta(1444) = theta(1107)+theta(1065)*AB(3) ! ((3,0,4)|(0,0,1)) = ((3,0,5)|(0,0,0))+((3,0,4)|(0,0,0))*AB(3)
        theta(1445) = theta(1102)+theta(1066)*AB(1) ! ((2,5,0)|(1,0,0)) = ((3,5,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(1)
        theta(1446) = theta(1108)+theta(1066)*AB(2) ! ((2,5,0)|(0,1,0)) = ((2,6,0)|(0,0,0))+((2,5,0)|(0,0,0))*AB(2)
        theta(1447) = theta(1109)+theta(1066)*AB(3) ! ((2,5,0)|(0,0,1)) = ((2,5,1)|(0,0,0))+((2,5,0)|(0,0,0))*AB(3)
        theta(1448) = theta(1103)+theta(1067)*AB(1) ! ((2,4,1)|(1,0,0)) = ((3,4,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(1)
        theta(1449) = theta(1109)+theta(1067)*AB(2) ! ((2,4,1)|(0,1,0)) = ((2,5,1)|(0,0,0))+((2,4,1)|(0,0,0))*AB(2)
        theta(1450) = theta(1110)+theta(1067)*AB(3) ! ((2,4,1)|(0,0,1)) = ((2,4,2)|(0,0,0))+((2,4,1)|(0,0,0))*AB(3)
        theta(1451) = theta(1104)+theta(1068)*AB(1) ! ((2,3,2)|(1,0,0)) = ((3,3,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(1)
        theta(1452) = theta(1110)+theta(1068)*AB(2) ! ((2,3,2)|(0,1,0)) = ((2,4,2)|(0,0,0))+((2,3,2)|(0,0,0))*AB(2)
        theta(1453) = theta(1111)+theta(1068)*AB(3) ! ((2,3,2)|(0,0,1)) = ((2,3,3)|(0,0,0))+((2,3,2)|(0,0,0))*AB(3)
        theta(1454) = theta(1105)+theta(1069)*AB(1) ! ((2,2,3)|(1,0,0)) = ((3,2,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(1)
        theta(1455) = theta(1111)+theta(1069)*AB(2) ! ((2,2,3)|(0,1,0)) = ((2,3,3)|(0,0,0))+((2,2,3)|(0,0,0))*AB(2)
        theta(1456) = theta(1112)+theta(1069)*AB(3) ! ((2,2,3)|(0,0,1)) = ((2,2,4)|(0,0,0))+((2,2,3)|(0,0,0))*AB(3)
        theta(1457) = theta(1106)+theta(1070)*AB(1) ! ((2,1,4)|(1,0,0)) = ((3,1,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(1)
        theta(1458) = theta(1112)+theta(1070)*AB(2) ! ((2,1,4)|(0,1,0)) = ((2,2,4)|(0,0,0))+((2,1,4)|(0,0,0))*AB(2)
        theta(1459) = theta(1113)+theta(1070)*AB(3) ! ((2,1,4)|(0,0,1)) = ((2,1,5)|(0,0,0))+((2,1,4)|(0,0,0))*AB(3)
        theta(1460) = theta(1107)+theta(1071)*AB(1) ! ((2,0,5)|(1,0,0)) = ((3,0,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(1)
        theta(1461) = theta(1113)+theta(1071)*AB(2) ! ((2,0,5)|(0,1,0)) = ((2,1,5)|(0,0,0))+((2,0,5)|(0,0,0))*AB(2)
        theta(1462) = theta(1114)+theta(1071)*AB(3) ! ((2,0,5)|(0,0,1)) = ((2,0,6)|(0,0,0))+((2,0,5)|(0,0,0))*AB(3)
        theta(1463) = theta(1108)+theta(1072)*AB(1) ! ((1,6,0)|(1,0,0)) = ((2,6,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(1)
        theta(1464) = theta(1115)+theta(1072)*AB(2) ! ((1,6,0)|(0,1,0)) = ((1,7,0)|(0,0,0))+((1,6,0)|(0,0,0))*AB(2)
        theta(1465) = theta(1116)+theta(1072)*AB(3) ! ((1,6,0)|(0,0,1)) = ((1,6,1)|(0,0,0))+((1,6,0)|(0,0,0))*AB(3)
        theta(1466) = theta(1109)+theta(1073)*AB(1) ! ((1,5,1)|(1,0,0)) = ((2,5,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(1)
        theta(1467) = theta(1116)+theta(1073)*AB(2) ! ((1,5,1)|(0,1,0)) = ((1,6,1)|(0,0,0))+((1,5,1)|(0,0,0))*AB(2)
        theta(1468) = theta(1117)+theta(1073)*AB(3) ! ((1,5,1)|(0,0,1)) = ((1,5,2)|(0,0,0))+((1,5,1)|(0,0,0))*AB(3)
        theta(1469) = theta(1110)+theta(1074)*AB(1) ! ((1,4,2)|(1,0,0)) = ((2,4,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(1)
        theta(1470) = theta(1117)+theta(1074)*AB(2) ! ((1,4,2)|(0,1,0)) = ((1,5,2)|(0,0,0))+((1,4,2)|(0,0,0))*AB(2)
        theta(1471) = theta(1118)+theta(1074)*AB(3) ! ((1,4,2)|(0,0,1)) = ((1,4,3)|(0,0,0))+((1,4,2)|(0,0,0))*AB(3)
        theta(1472) = theta(1111)+theta(1075)*AB(1) ! ((1,3,3)|(1,0,0)) = ((2,3,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(1)
        theta(1473) = theta(1118)+theta(1075)*AB(2) ! ((1,3,3)|(0,1,0)) = ((1,4,3)|(0,0,0))+((1,3,3)|(0,0,0))*AB(2)
        theta(1474) = theta(1119)+theta(1075)*AB(3) ! ((1,3,3)|(0,0,1)) = ((1,3,4)|(0,0,0))+((1,3,3)|(0,0,0))*AB(3)
        theta(1475) = theta(1112)+theta(1076)*AB(1) ! ((1,2,4)|(1,0,0)) = ((2,2,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(1)
        theta(1476) = theta(1119)+theta(1076)*AB(2) ! ((1,2,4)|(0,1,0)) = ((1,3,4)|(0,0,0))+((1,2,4)|(0,0,0))*AB(2)
        theta(1477) = theta(1120)+theta(1076)*AB(3) ! ((1,2,4)|(0,0,1)) = ((1,2,5)|(0,0,0))+((1,2,4)|(0,0,0))*AB(3)
        theta(1478) = theta(1113)+theta(1077)*AB(1) ! ((1,1,5)|(1,0,0)) = ((2,1,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(1)
        theta(1479) = theta(1120)+theta(1077)*AB(2) ! ((1,1,5)|(0,1,0)) = ((1,2,5)|(0,0,0))+((1,1,5)|(0,0,0))*AB(2)
        theta(1480) = theta(1121)+theta(1077)*AB(3) ! ((1,1,5)|(0,0,1)) = ((1,1,6)|(0,0,0))+((1,1,5)|(0,0,0))*AB(3)
        theta(1481) = theta(1114)+theta(1078)*AB(1) ! ((1,0,6)|(1,0,0)) = ((2,0,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(1)
        theta(1482) = theta(1121)+theta(1078)*AB(2) ! ((1,0,6)|(0,1,0)) = ((1,1,6)|(0,0,0))+((1,0,6)|(0,0,0))*AB(2)
        theta(1483) = theta(1122)+theta(1078)*AB(3) ! ((1,0,6)|(0,0,1)) = ((1,0,7)|(0,0,0))+((1,0,6)|(0,0,0))*AB(3)
        theta(1484) = theta(1115)+theta(1079)*AB(1) ! ((0,7,0)|(1,0,0)) = ((1,7,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(1)
        theta(1485) = theta(1123)+theta(1079)*AB(2) ! ((0,7,0)|(0,1,0)) = ((0,8,0)|(0,0,0))+((0,7,0)|(0,0,0))*AB(2)
        theta(1486) = theta(1124)+theta(1079)*AB(3) ! ((0,7,0)|(0,0,1)) = ((0,7,1)|(0,0,0))+((0,7,0)|(0,0,0))*AB(3)
        theta(1487) = theta(1116)+theta(1080)*AB(1) ! ((0,6,1)|(1,0,0)) = ((1,6,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(1)
        theta(1488) = theta(1124)+theta(1080)*AB(2) ! ((0,6,1)|(0,1,0)) = ((0,7,1)|(0,0,0))+((0,6,1)|(0,0,0))*AB(2)
        theta(1489) = theta(1125)+theta(1080)*AB(3) ! ((0,6,1)|(0,0,1)) = ((0,6,2)|(0,0,0))+((0,6,1)|(0,0,0))*AB(3)
        theta(1490) = theta(1117)+theta(1081)*AB(1) ! ((0,5,2)|(1,0,0)) = ((1,5,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(1)
        theta(1491) = theta(1125)+theta(1081)*AB(2) ! ((0,5,2)|(0,1,0)) = ((0,6,2)|(0,0,0))+((0,5,2)|(0,0,0))*AB(2)
        theta(1492) = theta(1126)+theta(1081)*AB(3) ! ((0,5,2)|(0,0,1)) = ((0,5,3)|(0,0,0))+((0,5,2)|(0,0,0))*AB(3)
        theta(1493) = theta(1118)+theta(1082)*AB(1) ! ((0,4,3)|(1,0,0)) = ((1,4,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(1)
        theta(1494) = theta(1126)+theta(1082)*AB(2) ! ((0,4,3)|(0,1,0)) = ((0,5,3)|(0,0,0))+((0,4,3)|(0,0,0))*AB(2)
        theta(1495) = theta(1127)+theta(1082)*AB(3) ! ((0,4,3)|(0,0,1)) = ((0,4,4)|(0,0,0))+((0,4,3)|(0,0,0))*AB(3)
        theta(1496) = theta(1119)+theta(1083)*AB(1) ! ((0,3,4)|(1,0,0)) = ((1,3,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(1)
        theta(1497) = theta(1127)+theta(1083)*AB(2) ! ((0,3,4)|(0,1,0)) = ((0,4,4)|(0,0,0))+((0,3,4)|(0,0,0))*AB(2)
        theta(1498) = theta(1128)+theta(1083)*AB(3) ! ((0,3,4)|(0,0,1)) = ((0,3,5)|(0,0,0))+((0,3,4)|(0,0,0))*AB(3)
        theta(1499) = theta(1120)+theta(1084)*AB(1) ! ((0,2,5)|(1,0,0)) = ((1,2,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(1)
        theta(1500) = theta(1128)+theta(1084)*AB(2) ! ((0,2,5)|(0,1,0)) = ((0,3,5)|(0,0,0))+((0,2,5)|(0,0,0))*AB(2)
        theta(1501) = theta(1129)+theta(1084)*AB(3) ! ((0,2,5)|(0,0,1)) = ((0,2,6)|(0,0,0))+((0,2,5)|(0,0,0))*AB(3)
        theta(1502) = theta(1121)+theta(1085)*AB(1) ! ((0,1,6)|(1,0,0)) = ((1,1,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(1)
        theta(1503) = theta(1129)+theta(1085)*AB(2) ! ((0,1,6)|(0,1,0)) = ((0,2,6)|(0,0,0))+((0,1,6)|(0,0,0))*AB(2)
        theta(1504) = theta(1130)+theta(1085)*AB(3) ! ((0,1,6)|(0,0,1)) = ((0,1,7)|(0,0,0))+((0,1,6)|(0,0,0))*AB(3)
        theta(1505) = theta(1122)+theta(1086)*AB(1) ! ((0,0,7)|(1,0,0)) = ((1,0,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(1)
        theta(1506) = theta(1130)+theta(1086)*AB(2) ! ((0,0,7)|(0,1,0)) = ((0,1,7)|(0,0,0))+((0,0,7)|(0,0,0))*AB(2)
        theta(1507) = theta(1131)+theta(1086)*AB(3) ! ((0,0,7)|(0,0,1)) = ((0,0,8)|(0,0,0))+((0,0,7)|(0,0,0))*AB(3)
        theta(1508) = theta(1132)+theta(1087)*AB(1) ! ((8,0,0)|(1,0,0)) = ((9,0,0)|(0,0,0))+((8,0,0)|(0,0,0))*AB(1)
        ! theta(1509) = theta(1133)+theta(1087)*AB(2) ! ((8,0,0)|(0,1,0)) = ((8,1,0)|(0,0,0))+((8,0,0)|(0,0,0))*AB(2)
        ! theta(1510) = theta(1134)+theta(1087)*AB(3) ! ((8,0,0)|(0,0,1)) = ((8,0,1)|(0,0,0))+((8,0,0)|(0,0,0))*AB(3)
        theta(1511) = theta(1133)+theta(1088)*AB(1) ! ((7,1,0)|(1,0,0)) = ((8,1,0)|(0,0,0))+((7,1,0)|(0,0,0))*AB(1)
        theta(1512) = theta(1135)+theta(1088)*AB(2) ! ((7,1,0)|(0,1,0)) = ((7,2,0)|(0,0,0))+((7,1,0)|(0,0,0))*AB(2)
        theta(1513) = theta(1136)+theta(1088)*AB(3) ! ((7,1,0)|(0,0,1)) = ((7,1,1)|(0,0,0))+((7,1,0)|(0,0,0))*AB(3)
        theta(1514) = theta(1134)+theta(1089)*AB(1) ! ((7,0,1)|(1,0,0)) = ((8,0,1)|(0,0,0))+((7,0,1)|(0,0,0))*AB(1)
        theta(1515) = theta(1136)+theta(1089)*AB(2) ! ((7,0,1)|(0,1,0)) = ((7,1,1)|(0,0,0))+((7,0,1)|(0,0,0))*AB(2)
        theta(1516) = theta(1137)+theta(1089)*AB(3) ! ((7,0,1)|(0,0,1)) = ((7,0,2)|(0,0,0))+((7,0,1)|(0,0,0))*AB(3)
        theta(1517) = theta(1135)+theta(1090)*AB(1) ! ((6,2,0)|(1,0,0)) = ((7,2,0)|(0,0,0))+((6,2,0)|(0,0,0))*AB(1)
        theta(1518) = theta(1138)+theta(1090)*AB(2) ! ((6,2,0)|(0,1,0)) = ((6,3,0)|(0,0,0))+((6,2,0)|(0,0,0))*AB(2)
        theta(1519) = theta(1139)+theta(1090)*AB(3) ! ((6,2,0)|(0,0,1)) = ((6,2,1)|(0,0,0))+((6,2,0)|(0,0,0))*AB(3)
        theta(1520) = theta(1136)+theta(1091)*AB(1) ! ((6,1,1)|(1,0,0)) = ((7,1,1)|(0,0,0))+((6,1,1)|(0,0,0))*AB(1)
        theta(1521) = theta(1139)+theta(1091)*AB(2) ! ((6,1,1)|(0,1,0)) = ((6,2,1)|(0,0,0))+((6,1,1)|(0,0,0))*AB(2)
        theta(1522) = theta(1140)+theta(1091)*AB(3) ! ((6,1,1)|(0,0,1)) = ((6,1,2)|(0,0,0))+((6,1,1)|(0,0,0))*AB(3)
        theta(1523) = theta(1137)+theta(1092)*AB(1) ! ((6,0,2)|(1,0,0)) = ((7,0,2)|(0,0,0))+((6,0,2)|(0,0,0))*AB(1)
        theta(1524) = theta(1140)+theta(1092)*AB(2) ! ((6,0,2)|(0,1,0)) = ((6,1,2)|(0,0,0))+((6,0,2)|(0,0,0))*AB(2)
        theta(1525) = theta(1141)+theta(1092)*AB(3) ! ((6,0,2)|(0,0,1)) = ((6,0,3)|(0,0,0))+((6,0,2)|(0,0,0))*AB(3)
        theta(1526) = theta(1138)+theta(1093)*AB(1) ! ((5,3,0)|(1,0,0)) = ((6,3,0)|(0,0,0))+((5,3,0)|(0,0,0))*AB(1)
        theta(1527) = theta(1142)+theta(1093)*AB(2) ! ((5,3,0)|(0,1,0)) = ((5,4,0)|(0,0,0))+((5,3,0)|(0,0,0))*AB(2)
        theta(1528) = theta(1143)+theta(1093)*AB(3) ! ((5,3,0)|(0,0,1)) = ((5,3,1)|(0,0,0))+((5,3,0)|(0,0,0))*AB(3)
        theta(1529) = theta(1139)+theta(1094)*AB(1) ! ((5,2,1)|(1,0,0)) = ((6,2,1)|(0,0,0))+((5,2,1)|(0,0,0))*AB(1)
        theta(1530) = theta(1143)+theta(1094)*AB(2) ! ((5,2,1)|(0,1,0)) = ((5,3,1)|(0,0,0))+((5,2,1)|(0,0,0))*AB(2)
        theta(1531) = theta(1144)+theta(1094)*AB(3) ! ((5,2,1)|(0,0,1)) = ((5,2,2)|(0,0,0))+((5,2,1)|(0,0,0))*AB(3)
        theta(1532) = theta(1140)+theta(1095)*AB(1) ! ((5,1,2)|(1,0,0)) = ((6,1,2)|(0,0,0))+((5,1,2)|(0,0,0))*AB(1)
        theta(1533) = theta(1144)+theta(1095)*AB(2) ! ((5,1,2)|(0,1,0)) = ((5,2,2)|(0,0,0))+((5,1,2)|(0,0,0))*AB(2)
        theta(1534) = theta(1145)+theta(1095)*AB(3) ! ((5,1,2)|(0,0,1)) = ((5,1,3)|(0,0,0))+((5,1,2)|(0,0,0))*AB(3)
        theta(1535) = theta(1141)+theta(1096)*AB(1) ! ((5,0,3)|(1,0,0)) = ((6,0,3)|(0,0,0))+((5,0,3)|(0,0,0))*AB(1)
        theta(1536) = theta(1145)+theta(1096)*AB(2) ! ((5,0,3)|(0,1,0)) = ((5,1,3)|(0,0,0))+((5,0,3)|(0,0,0))*AB(2)
        theta(1537) = theta(1146)+theta(1096)*AB(3) ! ((5,0,3)|(0,0,1)) = ((5,0,4)|(0,0,0))+((5,0,3)|(0,0,0))*AB(3)
        theta(1538) = theta(1142)+theta(1097)*AB(1) ! ((4,4,0)|(1,0,0)) = ((5,4,0)|(0,0,0))+((4,4,0)|(0,0,0))*AB(1)
        theta(1539) = theta(1147)+theta(1097)*AB(2) ! ((4,4,0)|(0,1,0)) = ((4,5,0)|(0,0,0))+((4,4,0)|(0,0,0))*AB(2)
        theta(1540) = theta(1148)+theta(1097)*AB(3) ! ((4,4,0)|(0,0,1)) = ((4,4,1)|(0,0,0))+((4,4,0)|(0,0,0))*AB(3)
        theta(1541) = theta(1143)+theta(1098)*AB(1) ! ((4,3,1)|(1,0,0)) = ((5,3,1)|(0,0,0))+((4,3,1)|(0,0,0))*AB(1)
        theta(1542) = theta(1148)+theta(1098)*AB(2) ! ((4,3,1)|(0,1,0)) = ((4,4,1)|(0,0,0))+((4,3,1)|(0,0,0))*AB(2)
        theta(1543) = theta(1149)+theta(1098)*AB(3) ! ((4,3,1)|(0,0,1)) = ((4,3,2)|(0,0,0))+((4,3,1)|(0,0,0))*AB(3)
        theta(1544) = theta(1144)+theta(1099)*AB(1) ! ((4,2,2)|(1,0,0)) = ((5,2,2)|(0,0,0))+((4,2,2)|(0,0,0))*AB(1)
        theta(1545) = theta(1149)+theta(1099)*AB(2) ! ((4,2,2)|(0,1,0)) = ((4,3,2)|(0,0,0))+((4,2,2)|(0,0,0))*AB(2)
        theta(1546) = theta(1150)+theta(1099)*AB(3) ! ((4,2,2)|(0,0,1)) = ((4,2,3)|(0,0,0))+((4,2,2)|(0,0,0))*AB(3)
        theta(1547) = theta(1145)+theta(1100)*AB(1) ! ((4,1,3)|(1,0,0)) = ((5,1,3)|(0,0,0))+((4,1,3)|(0,0,0))*AB(1)
        theta(1548) = theta(1150)+theta(1100)*AB(2) ! ((4,1,3)|(0,1,0)) = ((4,2,3)|(0,0,0))+((4,1,3)|(0,0,0))*AB(2)
        theta(1549) = theta(1151)+theta(1100)*AB(3) ! ((4,1,3)|(0,0,1)) = ((4,1,4)|(0,0,0))+((4,1,3)|(0,0,0))*AB(3)
        theta(1550) = theta(1146)+theta(1101)*AB(1) ! ((4,0,4)|(1,0,0)) = ((5,0,4)|(0,0,0))+((4,0,4)|(0,0,0))*AB(1)
        theta(1551) = theta(1151)+theta(1101)*AB(2) ! ((4,0,4)|(0,1,0)) = ((4,1,4)|(0,0,0))+((4,0,4)|(0,0,0))*AB(2)
        theta(1552) = theta(1152)+theta(1101)*AB(3) ! ((4,0,4)|(0,0,1)) = ((4,0,5)|(0,0,0))+((4,0,4)|(0,0,0))*AB(3)
        theta(1553) = theta(1147)+theta(1102)*AB(1) ! ((3,5,0)|(1,0,0)) = ((4,5,0)|(0,0,0))+((3,5,0)|(0,0,0))*AB(1)
        theta(1554) = theta(1153)+theta(1102)*AB(2) ! ((3,5,0)|(0,1,0)) = ((3,6,0)|(0,0,0))+((3,5,0)|(0,0,0))*AB(2)
        theta(1555) = theta(1154)+theta(1102)*AB(3) ! ((3,5,0)|(0,0,1)) = ((3,5,1)|(0,0,0))+((3,5,0)|(0,0,0))*AB(3)
        theta(1556) = theta(1148)+theta(1103)*AB(1) ! ((3,4,1)|(1,0,0)) = ((4,4,1)|(0,0,0))+((3,4,1)|(0,0,0))*AB(1)
        theta(1557) = theta(1154)+theta(1103)*AB(2) ! ((3,4,1)|(0,1,0)) = ((3,5,1)|(0,0,0))+((3,4,1)|(0,0,0))*AB(2)
        theta(1558) = theta(1155)+theta(1103)*AB(3) ! ((3,4,1)|(0,0,1)) = ((3,4,2)|(0,0,0))+((3,4,1)|(0,0,0))*AB(3)
        theta(1559) = theta(1149)+theta(1104)*AB(1) ! ((3,3,2)|(1,0,0)) = ((4,3,2)|(0,0,0))+((3,3,2)|(0,0,0))*AB(1)
        theta(1560) = theta(1155)+theta(1104)*AB(2) ! ((3,3,2)|(0,1,0)) = ((3,4,2)|(0,0,0))+((3,3,2)|(0,0,0))*AB(2)
        theta(1561) = theta(1156)+theta(1104)*AB(3) ! ((3,3,2)|(0,0,1)) = ((3,3,3)|(0,0,0))+((3,3,2)|(0,0,0))*AB(3)
        theta(1562) = theta(1150)+theta(1105)*AB(1) ! ((3,2,3)|(1,0,0)) = ((4,2,3)|(0,0,0))+((3,2,3)|(0,0,0))*AB(1)
        theta(1563) = theta(1156)+theta(1105)*AB(2) ! ((3,2,3)|(0,1,0)) = ((3,3,3)|(0,0,0))+((3,2,3)|(0,0,0))*AB(2)
        theta(1564) = theta(1157)+theta(1105)*AB(3) ! ((3,2,3)|(0,0,1)) = ((3,2,4)|(0,0,0))+((3,2,3)|(0,0,0))*AB(3)
        theta(1565) = theta(1151)+theta(1106)*AB(1) ! ((3,1,4)|(1,0,0)) = ((4,1,4)|(0,0,0))+((3,1,4)|(0,0,0))*AB(1)
        theta(1566) = theta(1157)+theta(1106)*AB(2) ! ((3,1,4)|(0,1,0)) = ((3,2,4)|(0,0,0))+((3,1,4)|(0,0,0))*AB(2)
        theta(1567) = theta(1158)+theta(1106)*AB(3) ! ((3,1,4)|(0,0,1)) = ((3,1,5)|(0,0,0))+((3,1,4)|(0,0,0))*AB(3)
        theta(1568) = theta(1152)+theta(1107)*AB(1) ! ((3,0,5)|(1,0,0)) = ((4,0,5)|(0,0,0))+((3,0,5)|(0,0,0))*AB(1)
        theta(1569) = theta(1158)+theta(1107)*AB(2) ! ((3,0,5)|(0,1,0)) = ((3,1,5)|(0,0,0))+((3,0,5)|(0,0,0))*AB(2)
        theta(1570) = theta(1159)+theta(1107)*AB(3) ! ((3,0,5)|(0,0,1)) = ((3,0,6)|(0,0,0))+((3,0,5)|(0,0,0))*AB(3)
        theta(1571) = theta(1153)+theta(1108)*AB(1) ! ((2,6,0)|(1,0,0)) = ((3,6,0)|(0,0,0))+((2,6,0)|(0,0,0))*AB(1)
        theta(1572) = theta(1160)+theta(1108)*AB(2) ! ((2,6,0)|(0,1,0)) = ((2,7,0)|(0,0,0))+((2,6,0)|(0,0,0))*AB(2)
        theta(1573) = theta(1161)+theta(1108)*AB(3) ! ((2,6,0)|(0,0,1)) = ((2,6,1)|(0,0,0))+((2,6,0)|(0,0,0))*AB(3)
        theta(1574) = theta(1154)+theta(1109)*AB(1) ! ((2,5,1)|(1,0,0)) = ((3,5,1)|(0,0,0))+((2,5,1)|(0,0,0))*AB(1)
        theta(1575) = theta(1161)+theta(1109)*AB(2) ! ((2,5,1)|(0,1,0)) = ((2,6,1)|(0,0,0))+((2,5,1)|(0,0,0))*AB(2)
        theta(1576) = theta(1162)+theta(1109)*AB(3) ! ((2,5,1)|(0,0,1)) = ((2,5,2)|(0,0,0))+((2,5,1)|(0,0,0))*AB(3)
        theta(1577) = theta(1155)+theta(1110)*AB(1) ! ((2,4,2)|(1,0,0)) = ((3,4,2)|(0,0,0))+((2,4,2)|(0,0,0))*AB(1)
        theta(1578) = theta(1162)+theta(1110)*AB(2) ! ((2,4,2)|(0,1,0)) = ((2,5,2)|(0,0,0))+((2,4,2)|(0,0,0))*AB(2)
        theta(1579) = theta(1163)+theta(1110)*AB(3) ! ((2,4,2)|(0,0,1)) = ((2,4,3)|(0,0,0))+((2,4,2)|(0,0,0))*AB(3)
        theta(1580) = theta(1156)+theta(1111)*AB(1) ! ((2,3,3)|(1,0,0)) = ((3,3,3)|(0,0,0))+((2,3,3)|(0,0,0))*AB(1)
        theta(1581) = theta(1163)+theta(1111)*AB(2) ! ((2,3,3)|(0,1,0)) = ((2,4,3)|(0,0,0))+((2,3,3)|(0,0,0))*AB(2)
        theta(1582) = theta(1164)+theta(1111)*AB(3) ! ((2,3,3)|(0,0,1)) = ((2,3,4)|(0,0,0))+((2,3,3)|(0,0,0))*AB(3)
        theta(1583) = theta(1157)+theta(1112)*AB(1) ! ((2,2,4)|(1,0,0)) = ((3,2,4)|(0,0,0))+((2,2,4)|(0,0,0))*AB(1)
        theta(1584) = theta(1164)+theta(1112)*AB(2) ! ((2,2,4)|(0,1,0)) = ((2,3,4)|(0,0,0))+((2,2,4)|(0,0,0))*AB(2)
        theta(1585) = theta(1165)+theta(1112)*AB(3) ! ((2,2,4)|(0,0,1)) = ((2,2,5)|(0,0,0))+((2,2,4)|(0,0,0))*AB(3)
        theta(1586) = theta(1158)+theta(1113)*AB(1) ! ((2,1,5)|(1,0,0)) = ((3,1,5)|(0,0,0))+((2,1,5)|(0,0,0))*AB(1)
        theta(1587) = theta(1165)+theta(1113)*AB(2) ! ((2,1,5)|(0,1,0)) = ((2,2,5)|(0,0,0))+((2,1,5)|(0,0,0))*AB(2)
        theta(1588) = theta(1166)+theta(1113)*AB(3) ! ((2,1,5)|(0,0,1)) = ((2,1,6)|(0,0,0))+((2,1,5)|(0,0,0))*AB(3)
        theta(1589) = theta(1159)+theta(1114)*AB(1) ! ((2,0,6)|(1,0,0)) = ((3,0,6)|(0,0,0))+((2,0,6)|(0,0,0))*AB(1)
        theta(1590) = theta(1166)+theta(1114)*AB(2) ! ((2,0,6)|(0,1,0)) = ((2,1,6)|(0,0,0))+((2,0,6)|(0,0,0))*AB(2)
        theta(1591) = theta(1167)+theta(1114)*AB(3) ! ((2,0,6)|(0,0,1)) = ((2,0,7)|(0,0,0))+((2,0,6)|(0,0,0))*AB(3)
        theta(1592) = theta(1160)+theta(1115)*AB(1) ! ((1,7,0)|(1,0,0)) = ((2,7,0)|(0,0,0))+((1,7,0)|(0,0,0))*AB(1)
        theta(1593) = theta(1168)+theta(1115)*AB(2) ! ((1,7,0)|(0,1,0)) = ((1,8,0)|(0,0,0))+((1,7,0)|(0,0,0))*AB(2)
        theta(1594) = theta(1169)+theta(1115)*AB(3) ! ((1,7,0)|(0,0,1)) = ((1,7,1)|(0,0,0))+((1,7,0)|(0,0,0))*AB(3)
        theta(1595) = theta(1161)+theta(1116)*AB(1) ! ((1,6,1)|(1,0,0)) = ((2,6,1)|(0,0,0))+((1,6,1)|(0,0,0))*AB(1)
        theta(1596) = theta(1169)+theta(1116)*AB(2) ! ((1,6,1)|(0,1,0)) = ((1,7,1)|(0,0,0))+((1,6,1)|(0,0,0))*AB(2)
        theta(1597) = theta(1170)+theta(1116)*AB(3) ! ((1,6,1)|(0,0,1)) = ((1,6,2)|(0,0,0))+((1,6,1)|(0,0,0))*AB(3)
        theta(1598) = theta(1162)+theta(1117)*AB(1) ! ((1,5,2)|(1,0,0)) = ((2,5,2)|(0,0,0))+((1,5,2)|(0,0,0))*AB(1)
        theta(1599) = theta(1170)+theta(1117)*AB(2) ! ((1,5,2)|(0,1,0)) = ((1,6,2)|(0,0,0))+((1,5,2)|(0,0,0))*AB(2)
        theta(1600) = theta(1171)+theta(1117)*AB(3) ! ((1,5,2)|(0,0,1)) = ((1,5,3)|(0,0,0))+((1,5,2)|(0,0,0))*AB(3)
        theta(1601) = theta(1163)+theta(1118)*AB(1) ! ((1,4,3)|(1,0,0)) = ((2,4,3)|(0,0,0))+((1,4,3)|(0,0,0))*AB(1)
        theta(1602) = theta(1171)+theta(1118)*AB(2) ! ((1,4,3)|(0,1,0)) = ((1,5,3)|(0,0,0))+((1,4,3)|(0,0,0))*AB(2)
        theta(1603) = theta(1172)+theta(1118)*AB(3) ! ((1,4,3)|(0,0,1)) = ((1,4,4)|(0,0,0))+((1,4,3)|(0,0,0))*AB(3)
        theta(1604) = theta(1164)+theta(1119)*AB(1) ! ((1,3,4)|(1,0,0)) = ((2,3,4)|(0,0,0))+((1,3,4)|(0,0,0))*AB(1)
        theta(1605) = theta(1172)+theta(1119)*AB(2) ! ((1,3,4)|(0,1,0)) = ((1,4,4)|(0,0,0))+((1,3,4)|(0,0,0))*AB(2)
        theta(1606) = theta(1173)+theta(1119)*AB(3) ! ((1,3,4)|(0,0,1)) = ((1,3,5)|(0,0,0))+((1,3,4)|(0,0,0))*AB(3)
        theta(1607) = theta(1165)+theta(1120)*AB(1) ! ((1,2,5)|(1,0,0)) = ((2,2,5)|(0,0,0))+((1,2,5)|(0,0,0))*AB(1)
        theta(1608) = theta(1173)+theta(1120)*AB(2) ! ((1,2,5)|(0,1,0)) = ((1,3,5)|(0,0,0))+((1,2,5)|(0,0,0))*AB(2)
        theta(1609) = theta(1174)+theta(1120)*AB(3) ! ((1,2,5)|(0,0,1)) = ((1,2,6)|(0,0,0))+((1,2,5)|(0,0,0))*AB(3)
        theta(1610) = theta(1166)+theta(1121)*AB(1) ! ((1,1,6)|(1,0,0)) = ((2,1,6)|(0,0,0))+((1,1,6)|(0,0,0))*AB(1)
        theta(1611) = theta(1174)+theta(1121)*AB(2) ! ((1,1,6)|(0,1,0)) = ((1,2,6)|(0,0,0))+((1,1,6)|(0,0,0))*AB(2)
        theta(1612) = theta(1175)+theta(1121)*AB(3) ! ((1,1,6)|(0,0,1)) = ((1,1,7)|(0,0,0))+((1,1,6)|(0,0,0))*AB(3)
        theta(1613) = theta(1167)+theta(1122)*AB(1) ! ((1,0,7)|(1,0,0)) = ((2,0,7)|(0,0,0))+((1,0,7)|(0,0,0))*AB(1)
        ! theta(1614) = theta(1175)+theta(1122)*AB(2) ! ((1,0,7)|(0,1,0)) = ((1,1,7)|(0,0,0))+((1,0,7)|(0,0,0))*AB(2)
        theta(1615) = theta(1176)+theta(1122)*AB(3) ! ((1,0,7)|(0,0,1)) = ((1,0,8)|(0,0,0))+((1,0,7)|(0,0,0))*AB(3)
        ! theta(1616) = theta(1168)+theta(1123)*AB(1) ! ((0,8,0)|(1,0,0)) = ((1,8,0)|(0,0,0))+((0,8,0)|(0,0,0))*AB(1)
        theta(1617) = theta(1177)+theta(1123)*AB(2) ! ((0,8,0)|(0,1,0)) = ((0,9,0)|(0,0,0))+((0,8,0)|(0,0,0))*AB(2)
        ! theta(1618) = theta(1178)+theta(1123)*AB(3) ! ((0,8,0)|(0,0,1)) = ((0,8,1)|(0,0,0))+((0,8,0)|(0,0,0))*AB(3)
        ! theta(1619) = theta(1169)+theta(1124)*AB(1) ! ((0,7,1)|(1,0,0)) = ((1,7,1)|(0,0,0))+((0,7,1)|(0,0,0))*AB(1)
        theta(1620) = theta(1178)+theta(1124)*AB(2) ! ((0,7,1)|(0,1,0)) = ((0,8,1)|(0,0,0))+((0,7,1)|(0,0,0))*AB(2)
        theta(1621) = theta(1179)+theta(1124)*AB(3) ! ((0,7,1)|(0,0,1)) = ((0,7,2)|(0,0,0))+((0,7,1)|(0,0,0))*AB(3)
        ! theta(1622) = theta(1170)+theta(1125)*AB(1) ! ((0,6,2)|(1,0,0)) = ((1,6,2)|(0,0,0))+((0,6,2)|(0,0,0))*AB(1)
        theta(1623) = theta(1179)+theta(1125)*AB(2) ! ((0,6,2)|(0,1,0)) = ((0,7,2)|(0,0,0))+((0,6,2)|(0,0,0))*AB(2)
        theta(1624) = theta(1180)+theta(1125)*AB(3) ! ((0,6,2)|(0,0,1)) = ((0,6,3)|(0,0,0))+((0,6,2)|(0,0,0))*AB(3)
        ! theta(1625) = theta(1171)+theta(1126)*AB(1) ! ((0,5,3)|(1,0,0)) = ((1,5,3)|(0,0,0))+((0,5,3)|(0,0,0))*AB(1)
        theta(1626) = theta(1180)+theta(1126)*AB(2) ! ((0,5,3)|(0,1,0)) = ((0,6,3)|(0,0,0))+((0,5,3)|(0,0,0))*AB(2)
        theta(1627) = theta(1181)+theta(1126)*AB(3) ! ((0,5,3)|(0,0,1)) = ((0,5,4)|(0,0,0))+((0,5,3)|(0,0,0))*AB(3)
        ! theta(1628) = theta(1172)+theta(1127)*AB(1) ! ((0,4,4)|(1,0,0)) = ((1,4,4)|(0,0,0))+((0,4,4)|(0,0,0))*AB(1)
        theta(1629) = theta(1181)+theta(1127)*AB(2) ! ((0,4,4)|(0,1,0)) = ((0,5,4)|(0,0,0))+((0,4,4)|(0,0,0))*AB(2)
        theta(1630) = theta(1182)+theta(1127)*AB(3) ! ((0,4,4)|(0,0,1)) = ((0,4,5)|(0,0,0))+((0,4,4)|(0,0,0))*AB(3)
        ! theta(1631) = theta(1173)+theta(1128)*AB(1) ! ((0,3,5)|(1,0,0)) = ((1,3,5)|(0,0,0))+((0,3,5)|(0,0,0))*AB(1)
        theta(1632) = theta(1182)+theta(1128)*AB(2) ! ((0,3,5)|(0,1,0)) = ((0,4,5)|(0,0,0))+((0,3,5)|(0,0,0))*AB(2)
        theta(1633) = theta(1183)+theta(1128)*AB(3) ! ((0,3,5)|(0,0,1)) = ((0,3,6)|(0,0,0))+((0,3,5)|(0,0,0))*AB(3)
        ! theta(1634) = theta(1174)+theta(1129)*AB(1) ! ((0,2,6)|(1,0,0)) = ((1,2,6)|(0,0,0))+((0,2,6)|(0,0,0))*AB(1)
        theta(1635) = theta(1183)+theta(1129)*AB(2) ! ((0,2,6)|(0,1,0)) = ((0,3,6)|(0,0,0))+((0,2,6)|(0,0,0))*AB(2)
        theta(1636) = theta(1184)+theta(1129)*AB(3) ! ((0,2,6)|(0,0,1)) = ((0,2,7)|(0,0,0))+((0,2,6)|(0,0,0))*AB(3)
        ! theta(1637) = theta(1175)+theta(1130)*AB(1) ! ((0,1,7)|(1,0,0)) = ((1,1,7)|(0,0,0))+((0,1,7)|(0,0,0))*AB(1)
        theta(1638) = theta(1184)+theta(1130)*AB(2) ! ((0,1,7)|(0,1,0)) = ((0,2,7)|(0,0,0))+((0,1,7)|(0,0,0))*AB(2)
        theta(1639) = theta(1185)+theta(1130)*AB(3) ! ((0,1,7)|(0,0,1)) = ((0,1,8)|(0,0,0))+((0,1,7)|(0,0,0))*AB(3)
        ! theta(1640) = theta(1176)+theta(1131)*AB(1) ! ((0,0,8)|(1,0,0)) = ((1,0,8)|(0,0,0))+((0,0,8)|(0,0,0))*AB(1)
        ! theta(1641) = theta(1185)+theta(1131)*AB(2) ! ((0,0,8)|(0,1,0)) = ((0,1,8)|(0,0,0))+((0,0,8)|(0,0,0))*AB(2)
        theta(1642) = theta(1186)+theta(1131)*AB(3) ! ((0,0,8)|(0,0,1)) = ((0,0,9)|(0,0,0))+((0,0,8)|(0,0,0))*AB(3)
        theta(1643) = theta(1187)+theta(1132)*AB(1) ! ((9,0,0)|(1,0,0)) = ((10,0,0)|(0,0,0))+((9,0,0)|(0,0,0))*AB(1)
        ! theta(1644) = theta(1188)+theta(1132)*AB(2) ! ((9,0,0)|(0,1,0)) = ((9,1,0)|(0,0,0))+((9,0,0)|(0,0,0))*AB(2)
        ! theta(1645) = theta(1189)+theta(1132)*AB(3) ! ((9,0,0)|(0,0,1)) = ((9,0,1)|(0,0,0))+((9,0,0)|(0,0,0))*AB(3)
        theta(1646) = theta(1188)+theta(1133)*AB(1) ! ((8,1,0)|(1,0,0)) = ((9,1,0)|(0,0,0))+((8,1,0)|(0,0,0))*AB(1)
        ! theta(1647) = theta(1190)+theta(1133)*AB(2) ! ((8,1,0)|(0,1,0)) = ((8,2,0)|(0,0,0))+((8,1,0)|(0,0,0))*AB(2)
        ! theta(1648) = theta(1191)+theta(1133)*AB(3) ! ((8,1,0)|(0,0,1)) = ((8,1,1)|(0,0,0))+((8,1,0)|(0,0,0))*AB(3)
        theta(1649) = theta(1189)+theta(1134)*AB(1) ! ((8,0,1)|(1,0,0)) = ((9,0,1)|(0,0,0))+((8,0,1)|(0,0,0))*AB(1)
        theta(1650) = theta(1191)+theta(1134)*AB(2) ! ((8,0,1)|(0,1,0)) = ((8,1,1)|(0,0,0))+((8,0,1)|(0,0,0))*AB(2)
        ! theta(1651) = theta(1192)+theta(1134)*AB(3) ! ((8,0,1)|(0,0,1)) = ((8,0,2)|(0,0,0))+((8,0,1)|(0,0,0))*AB(3)
        theta(1652) = theta(1190)+theta(1135)*AB(1) ! ((7,2,0)|(1,0,0)) = ((8,2,0)|(0,0,0))+((7,2,0)|(0,0,0))*AB(1)
        theta(1653) = theta(1193)+theta(1135)*AB(2) ! ((7,2,0)|(0,1,0)) = ((7,3,0)|(0,0,0))+((7,2,0)|(0,0,0))*AB(2)
        ! theta(1654) = theta(1194)+theta(1135)*AB(3) ! ((7,2,0)|(0,0,1)) = ((7,2,1)|(0,0,0))+((7,2,0)|(0,0,0))*AB(3)
        theta(1655) = theta(1191)+theta(1136)*AB(1) ! ((7,1,1)|(1,0,0)) = ((8,1,1)|(0,0,0))+((7,1,1)|(0,0,0))*AB(1)
        theta(1656) = theta(1194)+theta(1136)*AB(2) ! ((7,1,1)|(0,1,0)) = ((7,2,1)|(0,0,0))+((7,1,1)|(0,0,0))*AB(2)
        theta(1657) = theta(1195)+theta(1136)*AB(3) ! ((7,1,1)|(0,0,1)) = ((7,1,2)|(0,0,0))+((7,1,1)|(0,0,0))*AB(3)
        theta(1658) = theta(1192)+theta(1137)*AB(1) ! ((7,0,2)|(1,0,0)) = ((8,0,2)|(0,0,0))+((7,0,2)|(0,0,0))*AB(1)
        theta(1659) = theta(1195)+theta(1137)*AB(2) ! ((7,0,2)|(0,1,0)) = ((7,1,2)|(0,0,0))+((7,0,2)|(0,0,0))*AB(2)
        theta(1660) = theta(1196)+theta(1137)*AB(3) ! ((7,0,2)|(0,0,1)) = ((7,0,3)|(0,0,0))+((7,0,2)|(0,0,0))*AB(3)
        theta(1661) = theta(1193)+theta(1138)*AB(1) ! ((6,3,0)|(1,0,0)) = ((7,3,0)|(0,0,0))+((6,3,0)|(0,0,0))*AB(1)
        theta(1662) = theta(1197)+theta(1138)*AB(2) ! ((6,3,0)|(0,1,0)) = ((6,4,0)|(0,0,0))+((6,3,0)|(0,0,0))*AB(2)
        ! theta(1663) = theta(1198)+theta(1138)*AB(3) ! ((6,3,0)|(0,0,1)) = ((6,3,1)|(0,0,0))+((6,3,0)|(0,0,0))*AB(3)
        theta(1664) = theta(1194)+theta(1139)*AB(1) ! ((6,2,1)|(1,0,0)) = ((7,2,1)|(0,0,0))+((6,2,1)|(0,0,0))*AB(1)
        theta(1665) = theta(1198)+theta(1139)*AB(2) ! ((6,2,1)|(0,1,0)) = ((6,3,1)|(0,0,0))+((6,2,1)|(0,0,0))*AB(2)
        theta(1666) = theta(1199)+theta(1139)*AB(3) ! ((6,2,1)|(0,0,1)) = ((6,2,2)|(0,0,0))+((6,2,1)|(0,0,0))*AB(3)
        theta(1667) = theta(1195)+theta(1140)*AB(1) ! ((6,1,2)|(1,0,0)) = ((7,1,2)|(0,0,0))+((6,1,2)|(0,0,0))*AB(1)
        theta(1668) = theta(1199)+theta(1140)*AB(2) ! ((6,1,2)|(0,1,0)) = ((6,2,2)|(0,0,0))+((6,1,2)|(0,0,0))*AB(2)
        theta(1669) = theta(1200)+theta(1140)*AB(3) ! ((6,1,2)|(0,0,1)) = ((6,1,3)|(0,0,0))+((6,1,2)|(0,0,0))*AB(3)
        theta(1670) = theta(1196)+theta(1141)*AB(1) ! ((6,0,3)|(1,0,0)) = ((7,0,3)|(0,0,0))+((6,0,3)|(0,0,0))*AB(1)
        theta(1671) = theta(1200)+theta(1141)*AB(2) ! ((6,0,3)|(0,1,0)) = ((6,1,3)|(0,0,0))+((6,0,3)|(0,0,0))*AB(2)
        theta(1672) = theta(1201)+theta(1141)*AB(3) ! ((6,0,3)|(0,0,1)) = ((6,0,4)|(0,0,0))+((6,0,3)|(0,0,0))*AB(3)
        theta(1673) = theta(1197)+theta(1142)*AB(1) ! ((5,4,0)|(1,0,0)) = ((6,4,0)|(0,0,0))+((5,4,0)|(0,0,0))*AB(1)
        theta(1674) = theta(1202)+theta(1142)*AB(2) ! ((5,4,0)|(0,1,0)) = ((5,5,0)|(0,0,0))+((5,4,0)|(0,0,0))*AB(2)
        ! theta(1675) = theta(1203)+theta(1142)*AB(3) ! ((5,4,0)|(0,0,1)) = ((5,4,1)|(0,0,0))+((5,4,0)|(0,0,0))*AB(3)
        theta(1676) = theta(1198)+theta(1143)*AB(1) ! ((5,3,1)|(1,0,0)) = ((6,3,1)|(0,0,0))+((5,3,1)|(0,0,0))*AB(1)
        theta(1677) = theta(1203)+theta(1143)*AB(2) ! ((5,3,1)|(0,1,0)) = ((5,4,1)|(0,0,0))+((5,3,1)|(0,0,0))*AB(2)
        theta(1678) = theta(1204)+theta(1143)*AB(3) ! ((5,3,1)|(0,0,1)) = ((5,3,2)|(0,0,0))+((5,3,1)|(0,0,0))*AB(3)
        theta(1679) = theta(1199)+theta(1144)*AB(1) ! ((5,2,2)|(1,0,0)) = ((6,2,2)|(0,0,0))+((5,2,2)|(0,0,0))*AB(1)
        theta(1680) = theta(1204)+theta(1144)*AB(2) ! ((5,2,2)|(0,1,0)) = ((5,3,2)|(0,0,0))+((5,2,2)|(0,0,0))*AB(2)
        theta(1681) = theta(1205)+theta(1144)*AB(3) ! ((5,2,2)|(0,0,1)) = ((5,2,3)|(0,0,0))+((5,2,2)|(0,0,0))*AB(3)
        theta(1682) = theta(1200)+theta(1145)*AB(1) ! ((5,1,3)|(1,0,0)) = ((6,1,3)|(0,0,0))+((5,1,3)|(0,0,0))*AB(1)
        theta(1683) = theta(1205)+theta(1145)*AB(2) ! ((5,1,3)|(0,1,0)) = ((5,2,3)|(0,0,0))+((5,1,3)|(0,0,0))*AB(2)
        theta(1684) = theta(1206)+theta(1145)*AB(3) ! ((5,1,3)|(0,0,1)) = ((5,1,4)|(0,0,0))+((5,1,3)|(0,0,0))*AB(3)
        theta(1685) = theta(1201)+theta(1146)*AB(1) ! ((5,0,4)|(1,0,0)) = ((6,0,4)|(0,0,0))+((5,0,4)|(0,0,0))*AB(1)
        theta(1686) = theta(1206)+theta(1146)*AB(2) ! ((5,0,4)|(0,1,0)) = ((5,1,4)|(0,0,0))+((5,0,4)|(0,0,0))*AB(2)
        theta(1687) = theta(1207)+theta(1146)*AB(3) ! ((5,0,4)|(0,0,1)) = ((5,0,5)|(0,0,0))+((5,0,4)|(0,0,0))*AB(3)
        theta(1688) = theta(1202)+theta(1147)*AB(1) ! ((4,5,0)|(1,0,0)) = ((5,5,0)|(0,0,0))+((4,5,0)|(0,0,0))*AB(1)
        theta(1689) = theta(1208)+theta(1147)*AB(2) ! ((4,5,0)|(0,1,0)) = ((4,6,0)|(0,0,0))+((4,5,0)|(0,0,0))*AB(2)
        ! theta(1690) = theta(1209)+theta(1147)*AB(3) ! ((4,5,0)|(0,0,1)) = ((4,5,1)|(0,0,0))+((4,5,0)|(0,0,0))*AB(3)
        theta(1691) = theta(1203)+theta(1148)*AB(1) ! ((4,4,1)|(1,0,0)) = ((5,4,1)|(0,0,0))+((4,4,1)|(0,0,0))*AB(1)
        theta(1692) = theta(1209)+theta(1148)*AB(2) ! ((4,4,1)|(0,1,0)) = ((4,5,1)|(0,0,0))+((4,4,1)|(0,0,0))*AB(2)
        theta(1693) = theta(1210)+theta(1148)*AB(3) ! ((4,4,1)|(0,0,1)) = ((4,4,2)|(0,0,0))+((4,4,1)|(0,0,0))*AB(3)
        theta(1694) = theta(1204)+theta(1149)*AB(1) ! ((4,3,2)|(1,0,0)) = ((5,3,2)|(0,0,0))+((4,3,2)|(0,0,0))*AB(1)
        theta(1695) = theta(1210)+theta(1149)*AB(2) ! ((4,3,2)|(0,1,0)) = ((4,4,2)|(0,0,0))+((4,3,2)|(0,0,0))*AB(2)
        theta(1696) = theta(1211)+theta(1149)*AB(3) ! ((4,3,2)|(0,0,1)) = ((4,3,3)|(0,0,0))+((4,3,2)|(0,0,0))*AB(3)
        theta(1697) = theta(1205)+theta(1150)*AB(1) ! ((4,2,3)|(1,0,0)) = ((5,2,3)|(0,0,0))+((4,2,3)|(0,0,0))*AB(1)
        theta(1698) = theta(1211)+theta(1150)*AB(2) ! ((4,2,3)|(0,1,0)) = ((4,3,3)|(0,0,0))+((4,2,3)|(0,0,0))*AB(2)
        theta(1699) = theta(1212)+theta(1150)*AB(3) ! ((4,2,3)|(0,0,1)) = ((4,2,4)|(0,0,0))+((4,2,3)|(0,0,0))*AB(3)
        theta(1700) = theta(1206)+theta(1151)*AB(1) ! ((4,1,4)|(1,0,0)) = ((5,1,4)|(0,0,0))+((4,1,4)|(0,0,0))*AB(1)
        theta(1701) = theta(1212)+theta(1151)*AB(2) ! ((4,1,4)|(0,1,0)) = ((4,2,4)|(0,0,0))+((4,1,4)|(0,0,0))*AB(2)
        theta(1702) = theta(1213)+theta(1151)*AB(3) ! ((4,1,4)|(0,0,1)) = ((4,1,5)|(0,0,0))+((4,1,4)|(0,0,0))*AB(3)
        theta(1703) = theta(1207)+theta(1152)*AB(1) ! ((4,0,5)|(1,0,0)) = ((5,0,5)|(0,0,0))+((4,0,5)|(0,0,0))*AB(1)
        theta(1704) = theta(1213)+theta(1152)*AB(2) ! ((4,0,5)|(0,1,0)) = ((4,1,5)|(0,0,0))+((4,0,5)|(0,0,0))*AB(2)
        theta(1705) = theta(1214)+theta(1152)*AB(3) ! ((4,0,5)|(0,0,1)) = ((4,0,6)|(0,0,0))+((4,0,5)|(0,0,0))*AB(3)
        theta(1706) = theta(1208)+theta(1153)*AB(1) ! ((3,6,0)|(1,0,0)) = ((4,6,0)|(0,0,0))+((3,6,0)|(0,0,0))*AB(1)
        theta(1707) = theta(1215)+theta(1153)*AB(2) ! ((3,6,0)|(0,1,0)) = ((3,7,0)|(0,0,0))+((3,6,0)|(0,0,0))*AB(2)
        ! theta(1708) = theta(1216)+theta(1153)*AB(3) ! ((3,6,0)|(0,0,1)) = ((3,6,1)|(0,0,0))+((3,6,0)|(0,0,0))*AB(3)
        theta(1709) = theta(1209)+theta(1154)*AB(1) ! ((3,5,1)|(1,0,0)) = ((4,5,1)|(0,0,0))+((3,5,1)|(0,0,0))*AB(1)
        theta(1710) = theta(1216)+theta(1154)*AB(2) ! ((3,5,1)|(0,1,0)) = ((3,6,1)|(0,0,0))+((3,5,1)|(0,0,0))*AB(2)
        theta(1711) = theta(1217)+theta(1154)*AB(3) ! ((3,5,1)|(0,0,1)) = ((3,5,2)|(0,0,0))+((3,5,1)|(0,0,0))*AB(3)
        theta(1712) = theta(1210)+theta(1155)*AB(1) ! ((3,4,2)|(1,0,0)) = ((4,4,2)|(0,0,0))+((3,4,2)|(0,0,0))*AB(1)
        theta(1713) = theta(1217)+theta(1155)*AB(2) ! ((3,4,2)|(0,1,0)) = ((3,5,2)|(0,0,0))+((3,4,2)|(0,0,0))*AB(2)
        theta(1714) = theta(1218)+theta(1155)*AB(3) ! ((3,4,2)|(0,0,1)) = ((3,4,3)|(0,0,0))+((3,4,2)|(0,0,0))*AB(3)
        theta(1715) = theta(1211)+theta(1156)*AB(1) ! ((3,3,3)|(1,0,0)) = ((4,3,3)|(0,0,0))+((3,3,3)|(0,0,0))*AB(1)
        theta(1716) = theta(1218)+theta(1156)*AB(2) ! ((3,3,3)|(0,1,0)) = ((3,4,3)|(0,0,0))+((3,3,3)|(0,0,0))*AB(2)
        theta(1717) = theta(1219)+theta(1156)*AB(3) ! ((3,3,3)|(0,0,1)) = ((3,3,4)|(0,0,0))+((3,3,3)|(0,0,0))*AB(3)
        theta(1718) = theta(1212)+theta(1157)*AB(1) ! ((3,2,4)|(1,0,0)) = ((4,2,4)|(0,0,0))+((3,2,4)|(0,0,0))*AB(1)
        theta(1719) = theta(1219)+theta(1157)*AB(2) ! ((3,2,4)|(0,1,0)) = ((3,3,4)|(0,0,0))+((3,2,4)|(0,0,0))*AB(2)
        theta(1720) = theta(1220)+theta(1157)*AB(3) ! ((3,2,4)|(0,0,1)) = ((3,2,5)|(0,0,0))+((3,2,4)|(0,0,0))*AB(3)
        theta(1721) = theta(1213)+theta(1158)*AB(1) ! ((3,1,5)|(1,0,0)) = ((4,1,5)|(0,0,0))+((3,1,5)|(0,0,0))*AB(1)
        theta(1722) = theta(1220)+theta(1158)*AB(2) ! ((3,1,5)|(0,1,0)) = ((3,2,5)|(0,0,0))+((3,1,5)|(0,0,0))*AB(2)
        theta(1723) = theta(1221)+theta(1158)*AB(3) ! ((3,1,5)|(0,0,1)) = ((3,1,6)|(0,0,0))+((3,1,5)|(0,0,0))*AB(3)
        theta(1724) = theta(1214)+theta(1159)*AB(1) ! ((3,0,6)|(1,0,0)) = ((4,0,6)|(0,0,0))+((3,0,6)|(0,0,0))*AB(1)
        ! theta(1725) = theta(1221)+theta(1159)*AB(2) ! ((3,0,6)|(0,1,0)) = ((3,1,6)|(0,0,0))+((3,0,6)|(0,0,0))*AB(2)
        theta(1726) = theta(1222)+theta(1159)*AB(3) ! ((3,0,6)|(0,0,1)) = ((3,0,7)|(0,0,0))+((3,0,6)|(0,0,0))*AB(3)
        theta(1727) = theta(1215)+theta(1160)*AB(1) ! ((2,7,0)|(1,0,0)) = ((3,7,0)|(0,0,0))+((2,7,0)|(0,0,0))*AB(1)
        theta(1728) = theta(1223)+theta(1160)*AB(2) ! ((2,7,0)|(0,1,0)) = ((2,8,0)|(0,0,0))+((2,7,0)|(0,0,0))*AB(2)
        ! theta(1729) = theta(1224)+theta(1160)*AB(3) ! ((2,7,0)|(0,0,1)) = ((2,7,1)|(0,0,0))+((2,7,0)|(0,0,0))*AB(3)
        theta(1730) = theta(1216)+theta(1161)*AB(1) ! ((2,6,1)|(1,0,0)) = ((3,6,1)|(0,0,0))+((2,6,1)|(0,0,0))*AB(1)
        theta(1731) = theta(1224)+theta(1161)*AB(2) ! ((2,6,1)|(0,1,0)) = ((2,7,1)|(0,0,0))+((2,6,1)|(0,0,0))*AB(2)
        theta(1732) = theta(1225)+theta(1161)*AB(3) ! ((2,6,1)|(0,0,1)) = ((2,6,2)|(0,0,0))+((2,6,1)|(0,0,0))*AB(3)
        theta(1733) = theta(1217)+theta(1162)*AB(1) ! ((2,5,2)|(1,0,0)) = ((3,5,2)|(0,0,0))+((2,5,2)|(0,0,0))*AB(1)
        theta(1734) = theta(1225)+theta(1162)*AB(2) ! ((2,5,2)|(0,1,0)) = ((2,6,2)|(0,0,0))+((2,5,2)|(0,0,0))*AB(2)
        theta(1735) = theta(1226)+theta(1162)*AB(3) ! ((2,5,2)|(0,0,1)) = ((2,5,3)|(0,0,0))+((2,5,2)|(0,0,0))*AB(3)
        theta(1736) = theta(1218)+theta(1163)*AB(1) ! ((2,4,3)|(1,0,0)) = ((3,4,3)|(0,0,0))+((2,4,3)|(0,0,0))*AB(1)
        theta(1737) = theta(1226)+theta(1163)*AB(2) ! ((2,4,3)|(0,1,0)) = ((2,5,3)|(0,0,0))+((2,4,3)|(0,0,0))*AB(2)
        theta(1738) = theta(1227)+theta(1163)*AB(3) ! ((2,4,3)|(0,0,1)) = ((2,4,4)|(0,0,0))+((2,4,3)|(0,0,0))*AB(3)
        theta(1739) = theta(1219)+theta(1164)*AB(1) ! ((2,3,4)|(1,0,0)) = ((3,3,4)|(0,0,0))+((2,3,4)|(0,0,0))*AB(1)
        theta(1740) = theta(1227)+theta(1164)*AB(2) ! ((2,3,4)|(0,1,0)) = ((2,4,4)|(0,0,0))+((2,3,4)|(0,0,0))*AB(2)
        theta(1741) = theta(1228)+theta(1164)*AB(3) ! ((2,3,4)|(0,0,1)) = ((2,3,5)|(0,0,0))+((2,3,4)|(0,0,0))*AB(3)
        theta(1742) = theta(1220)+theta(1165)*AB(1) ! ((2,2,5)|(1,0,0)) = ((3,2,5)|(0,0,0))+((2,2,5)|(0,0,0))*AB(1)
        theta(1743) = theta(1228)+theta(1165)*AB(2) ! ((2,2,5)|(0,1,0)) = ((2,3,5)|(0,0,0))+((2,2,5)|(0,0,0))*AB(2)
        theta(1744) = theta(1229)+theta(1165)*AB(3) ! ((2,2,5)|(0,0,1)) = ((2,2,6)|(0,0,0))+((2,2,5)|(0,0,0))*AB(3)
        theta(1745) = theta(1221)+theta(1166)*AB(1) ! ((2,1,6)|(1,0,0)) = ((3,1,6)|(0,0,0))+((2,1,6)|(0,0,0))*AB(1)
        theta(1746) = theta(1229)+theta(1166)*AB(2) ! ((2,1,6)|(0,1,0)) = ((2,2,6)|(0,0,0))+((2,1,6)|(0,0,0))*AB(2)
        theta(1747) = theta(1230)+theta(1166)*AB(3) ! ((2,1,6)|(0,0,1)) = ((2,1,7)|(0,0,0))+((2,1,6)|(0,0,0))*AB(3)
        theta(1748) = theta(1222)+theta(1167)*AB(1) ! ((2,0,7)|(1,0,0)) = ((3,0,7)|(0,0,0))+((2,0,7)|(0,0,0))*AB(1)
        ! theta(1749) = theta(1230)+theta(1167)*AB(2) ! ((2,0,7)|(0,1,0)) = ((2,1,7)|(0,0,0))+((2,0,7)|(0,0,0))*AB(2)
        theta(1750) = theta(1231)+theta(1167)*AB(3) ! ((2,0,7)|(0,0,1)) = ((2,0,8)|(0,0,0))+((2,0,7)|(0,0,0))*AB(3)
        ! theta(1751) = theta(1223)+theta(1168)*AB(1) ! ((1,8,0)|(1,0,0)) = ((2,8,0)|(0,0,0))+((1,8,0)|(0,0,0))*AB(1)
        theta(1752) = theta(1232)+theta(1168)*AB(2) ! ((1,8,0)|(0,1,0)) = ((1,9,0)|(0,0,0))+((1,8,0)|(0,0,0))*AB(2)
        ! theta(1753) = theta(1233)+theta(1168)*AB(3) ! ((1,8,0)|(0,0,1)) = ((1,8,1)|(0,0,0))+((1,8,0)|(0,0,0))*AB(3)
        ! theta(1754) = theta(1224)+theta(1169)*AB(1) ! ((1,7,1)|(1,0,0)) = ((2,7,1)|(0,0,0))+((1,7,1)|(0,0,0))*AB(1)
        theta(1755) = theta(1233)+theta(1169)*AB(2) ! ((1,7,1)|(0,1,0)) = ((1,8,1)|(0,0,0))+((1,7,1)|(0,0,0))*AB(2)
        theta(1756) = theta(1234)+theta(1169)*AB(3) ! ((1,7,1)|(0,0,1)) = ((1,7,2)|(0,0,0))+((1,7,1)|(0,0,0))*AB(3)
        ! theta(1757) = theta(1225)+theta(1170)*AB(1) ! ((1,6,2)|(1,0,0)) = ((2,6,2)|(0,0,0))+((1,6,2)|(0,0,0))*AB(1)
        theta(1758) = theta(1234)+theta(1170)*AB(2) ! ((1,6,2)|(0,1,0)) = ((1,7,2)|(0,0,0))+((1,6,2)|(0,0,0))*AB(2)
        theta(1759) = theta(1235)+theta(1170)*AB(3) ! ((1,6,2)|(0,0,1)) = ((1,6,3)|(0,0,0))+((1,6,2)|(0,0,0))*AB(3)
        ! theta(1760) = theta(1226)+theta(1171)*AB(1) ! ((1,5,3)|(1,0,0)) = ((2,5,3)|(0,0,0))+((1,5,3)|(0,0,0))*AB(1)
        theta(1761) = theta(1235)+theta(1171)*AB(2) ! ((1,5,3)|(0,1,0)) = ((1,6,3)|(0,0,0))+((1,5,3)|(0,0,0))*AB(2)
        theta(1762) = theta(1236)+theta(1171)*AB(3) ! ((1,5,3)|(0,0,1)) = ((1,5,4)|(0,0,0))+((1,5,3)|(0,0,0))*AB(3)
        ! theta(1763) = theta(1227)+theta(1172)*AB(1) ! ((1,4,4)|(1,0,0)) = ((2,4,4)|(0,0,0))+((1,4,4)|(0,0,0))*AB(1)
        theta(1764) = theta(1236)+theta(1172)*AB(2) ! ((1,4,4)|(0,1,0)) = ((1,5,4)|(0,0,0))+((1,4,4)|(0,0,0))*AB(2)
        theta(1765) = theta(1237)+theta(1172)*AB(3) ! ((1,4,4)|(0,0,1)) = ((1,4,5)|(0,0,0))+((1,4,4)|(0,0,0))*AB(3)
        ! theta(1766) = theta(1228)+theta(1173)*AB(1) ! ((1,3,5)|(1,0,0)) = ((2,3,5)|(0,0,0))+((1,3,5)|(0,0,0))*AB(1)
        theta(1767) = theta(1237)+theta(1173)*AB(2) ! ((1,3,5)|(0,1,0)) = ((1,4,5)|(0,0,0))+((1,3,5)|(0,0,0))*AB(2)
        theta(1768) = theta(1238)+theta(1173)*AB(3) ! ((1,3,5)|(0,0,1)) = ((1,3,6)|(0,0,0))+((1,3,5)|(0,0,0))*AB(3)
        ! theta(1769) = theta(1229)+theta(1174)*AB(1) ! ((1,2,6)|(1,0,0)) = ((2,2,6)|(0,0,0))+((1,2,6)|(0,0,0))*AB(1)
        theta(1770) = theta(1238)+theta(1174)*AB(2) ! ((1,2,6)|(0,1,0)) = ((1,3,6)|(0,0,0))+((1,2,6)|(0,0,0))*AB(2)
        theta(1771) = theta(1239)+theta(1174)*AB(3) ! ((1,2,6)|(0,0,1)) = ((1,2,7)|(0,0,0))+((1,2,6)|(0,0,0))*AB(3)
        ! theta(1772) = theta(1230)+theta(1175)*AB(1) ! ((1,1,7)|(1,0,0)) = ((2,1,7)|(0,0,0))+((1,1,7)|(0,0,0))*AB(1)
        ! theta(1773) = theta(1239)+theta(1175)*AB(2) ! ((1,1,7)|(0,1,0)) = ((1,2,7)|(0,0,0))+((1,1,7)|(0,0,0))*AB(2)
        theta(1774) = theta(1240)+theta(1175)*AB(3) ! ((1,1,7)|(0,0,1)) = ((1,1,8)|(0,0,0))+((1,1,7)|(0,0,0))*AB(3)
        ! theta(1775) = theta(1231)+theta(1176)*AB(1) ! ((1,0,8)|(1,0,0)) = ((2,0,8)|(0,0,0))+((1,0,8)|(0,0,0))*AB(1)
        ! theta(1776) = theta(1240)+theta(1176)*AB(2) ! ((1,0,8)|(0,1,0)) = ((1,1,8)|(0,0,0))+((1,0,8)|(0,0,0))*AB(2)
        theta(1777) = theta(1241)+theta(1176)*AB(3) ! ((1,0,8)|(0,0,1)) = ((1,0,9)|(0,0,0))+((1,0,8)|(0,0,0))*AB(3)
        ! theta(1778) = theta(1232)+theta(1177)*AB(1) ! ((0,9,0)|(1,0,0)) = ((1,9,0)|(0,0,0))+((0,9,0)|(0,0,0))*AB(1)
        theta(1779) = theta(1242)+theta(1177)*AB(2) ! ((0,9,0)|(0,1,0)) = ((0,10,0)|(0,0,0))+((0,9,0)|(0,0,0))*AB(2)
        ! theta(1780) = theta(1243)+theta(1177)*AB(3) ! ((0,9,0)|(0,0,1)) = ((0,9,1)|(0,0,0))+((0,9,0)|(0,0,0))*AB(3)
        ! theta(1781) = theta(1233)+theta(1178)*AB(1) ! ((0,8,1)|(1,0,0)) = ((1,8,1)|(0,0,0))+((0,8,1)|(0,0,0))*AB(1)
        theta(1782) = theta(1243)+theta(1178)*AB(2) ! ((0,8,1)|(0,1,0)) = ((0,9,1)|(0,0,0))+((0,8,1)|(0,0,0))*AB(2)
        ! theta(1783) = theta(1244)+theta(1178)*AB(3) ! ((0,8,1)|(0,0,1)) = ((0,8,2)|(0,0,0))+((0,8,1)|(0,0,0))*AB(3)
        ! theta(1784) = theta(1234)+theta(1179)*AB(1) ! ((0,7,2)|(1,0,0)) = ((1,7,2)|(0,0,0))+((0,7,2)|(0,0,0))*AB(1)
        theta(1785) = theta(1244)+theta(1179)*AB(2) ! ((0,7,2)|(0,1,0)) = ((0,8,2)|(0,0,0))+((0,7,2)|(0,0,0))*AB(2)
        theta(1786) = theta(1245)+theta(1179)*AB(3) ! ((0,7,2)|(0,0,1)) = ((0,7,3)|(0,0,0))+((0,7,2)|(0,0,0))*AB(3)
        ! theta(1787) = theta(1235)+theta(1180)*AB(1) ! ((0,6,3)|(1,0,0)) = ((1,6,3)|(0,0,0))+((0,6,3)|(0,0,0))*AB(1)
        theta(1788) = theta(1245)+theta(1180)*AB(2) ! ((0,6,3)|(0,1,0)) = ((0,7,3)|(0,0,0))+((0,6,3)|(0,0,0))*AB(2)
        theta(1789) = theta(1246)+theta(1180)*AB(3) ! ((0,6,3)|(0,0,1)) = ((0,6,4)|(0,0,0))+((0,6,3)|(0,0,0))*AB(3)
        ! theta(1790) = theta(1236)+theta(1181)*AB(1) ! ((0,5,4)|(1,0,0)) = ((1,5,4)|(0,0,0))+((0,5,4)|(0,0,0))*AB(1)
        theta(1791) = theta(1246)+theta(1181)*AB(2) ! ((0,5,4)|(0,1,0)) = ((0,6,4)|(0,0,0))+((0,5,4)|(0,0,0))*AB(2)
        theta(1792) = theta(1247)+theta(1181)*AB(3) ! ((0,5,4)|(0,0,1)) = ((0,5,5)|(0,0,0))+((0,5,4)|(0,0,0))*AB(3)
        ! theta(1793) = theta(1237)+theta(1182)*AB(1) ! ((0,4,5)|(1,0,0)) = ((1,4,5)|(0,0,0))+((0,4,5)|(0,0,0))*AB(1)
        theta(1794) = theta(1247)+theta(1182)*AB(2) ! ((0,4,5)|(0,1,0)) = ((0,5,5)|(0,0,0))+((0,4,5)|(0,0,0))*AB(2)
        theta(1795) = theta(1248)+theta(1182)*AB(3) ! ((0,4,5)|(0,0,1)) = ((0,4,6)|(0,0,0))+((0,4,5)|(0,0,0))*AB(3)
        ! theta(1796) = theta(1238)+theta(1183)*AB(1) ! ((0,3,6)|(1,0,0)) = ((1,3,6)|(0,0,0))+((0,3,6)|(0,0,0))*AB(1)
        theta(1797) = theta(1248)+theta(1183)*AB(2) ! ((0,3,6)|(0,1,0)) = ((0,4,6)|(0,0,0))+((0,3,6)|(0,0,0))*AB(2)
        theta(1798) = theta(1249)+theta(1183)*AB(3) ! ((0,3,6)|(0,0,1)) = ((0,3,7)|(0,0,0))+((0,3,6)|(0,0,0))*AB(3)
        ! theta(1799) = theta(1239)+theta(1184)*AB(1) ! ((0,2,7)|(1,0,0)) = ((1,2,7)|(0,0,0))+((0,2,7)|(0,0,0))*AB(1)
        theta(1800) = theta(1249)+theta(1184)*AB(2) ! ((0,2,7)|(0,1,0)) = ((0,3,7)|(0,0,0))+((0,2,7)|(0,0,0))*AB(2)
        theta(1801) = theta(1250)+theta(1184)*AB(3) ! ((0,2,7)|(0,0,1)) = ((0,2,8)|(0,0,0))+((0,2,7)|(0,0,0))*AB(3)
        ! theta(1802) = theta(1240)+theta(1185)*AB(1) ! ((0,1,8)|(1,0,0)) = ((1,1,8)|(0,0,0))+((0,1,8)|(0,0,0))*AB(1)
        ! theta(1803) = theta(1250)+theta(1185)*AB(2) ! ((0,1,8)|(0,1,0)) = ((0,2,8)|(0,0,0))+((0,1,8)|(0,0,0))*AB(2)
        theta(1804) = theta(1251)+theta(1185)*AB(3) ! ((0,1,8)|(0,0,1)) = ((0,1,9)|(0,0,0))+((0,1,8)|(0,0,0))*AB(3)
        ! theta(1805) = theta(1241)+theta(1186)*AB(1) ! ((0,0,9)|(1,0,0)) = ((1,0,9)|(0,0,0))+((0,0,9)|(0,0,0))*AB(1)
        ! theta(1806) = theta(1251)+theta(1186)*AB(2) ! ((0,0,9)|(0,1,0)) = ((0,1,9)|(0,0,0))+((0,0,9)|(0,0,0))*AB(2)
        theta(1807) = theta(1252)+theta(1186)*AB(3) ! ((0,0,9)|(0,0,1)) = ((0,0,10)|(0,0,0))+((0,0,9)|(0,0,0))*AB(3)
        theta(1808) = theta(1316)+theta(1253)*AB(1) ! ((5,0,0)|(2,0,0)) = ((6,0,0)|(1,0,0))+((5,0,0)|(1,0,0))*AB(1)
        ! theta(1809) = theta(1317)+theta(1254)*AB(1) ! ((5,0,0)|(1,1,0)) = ((6,0,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(1)
        ! theta(1810) = theta(1318)+theta(1255)*AB(1) ! ((5,0,0)|(1,0,1)) = ((6,0,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(1)
        theta(1811) = theta(1320)+theta(1254)*AB(2) ! ((5,0,0)|(0,2,0)) = ((5,1,0)|(0,1,0))+((5,0,0)|(0,1,0))*AB(2)
        ! theta(1812) = theta(1321)+theta(1255)*AB(2) ! ((5,0,0)|(0,1,1)) = ((5,1,0)|(0,0,1))+((5,0,0)|(0,0,1))*AB(2)
        theta(1813) = theta(1324)+theta(1255)*AB(3) ! ((5,0,0)|(0,0,2)) = ((5,0,1)|(0,0,1))+((5,0,0)|(0,0,1))*AB(3)
        theta(1814) = theta(1319)+theta(1256)*AB(1) ! ((4,1,0)|(2,0,0)) = ((5,1,0)|(1,0,0))+((4,1,0)|(1,0,0))*AB(1)
        ! theta(1815) = theta(1320)+theta(1257)*AB(1) ! ((4,1,0)|(1,1,0)) = ((5,1,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(1)
        ! theta(1816) = theta(1321)+theta(1258)*AB(1) ! ((4,1,0)|(1,0,1)) = ((5,1,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(1)
        theta(1817) = theta(1326)+theta(1257)*AB(2) ! ((4,1,0)|(0,2,0)) = ((4,2,0)|(0,1,0))+((4,1,0)|(0,1,0))*AB(2)
        ! theta(1818) = theta(1327)+theta(1258)*AB(2) ! ((4,1,0)|(0,1,1)) = ((4,2,0)|(0,0,1))+((4,1,0)|(0,0,1))*AB(2)
        theta(1819) = theta(1330)+theta(1258)*AB(3) ! ((4,1,0)|(0,0,2)) = ((4,1,1)|(0,0,1))+((4,1,0)|(0,0,1))*AB(3)
        theta(1820) = theta(1322)+theta(1259)*AB(1) ! ((4,0,1)|(2,0,0)) = ((5,0,1)|(1,0,0))+((4,0,1)|(1,0,0))*AB(1)
        theta(1821) = theta(1323)+theta(1260)*AB(1) ! ((4,0,1)|(1,1,0)) = ((5,0,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(1)
        ! theta(1822) = theta(1324)+theta(1261)*AB(1) ! ((4,0,1)|(1,0,1)) = ((5,0,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(1)
        theta(1823) = theta(1329)+theta(1260)*AB(2) ! ((4,0,1)|(0,2,0)) = ((4,1,1)|(0,1,0))+((4,0,1)|(0,1,0))*AB(2)
        theta(1824) = theta(1330)+theta(1261)*AB(2) ! ((4,0,1)|(0,1,1)) = ((4,1,1)|(0,0,1))+((4,0,1)|(0,0,1))*AB(2)
        theta(1825) = theta(1333)+theta(1261)*AB(3) ! ((4,0,1)|(0,0,2)) = ((4,0,2)|(0,0,1))+((4,0,1)|(0,0,1))*AB(3)
        theta(1826) = theta(1325)+theta(1262)*AB(1) ! ((3,2,0)|(2,0,0)) = ((4,2,0)|(1,0,0))+((3,2,0)|(1,0,0))*AB(1)
        ! theta(1827) = theta(1326)+theta(1263)*AB(1) ! ((3,2,0)|(1,1,0)) = ((4,2,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(1)
        ! theta(1828) = theta(1327)+theta(1264)*AB(1) ! ((3,2,0)|(1,0,1)) = ((4,2,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(1)
        theta(1829) = theta(1335)+theta(1263)*AB(2) ! ((3,2,0)|(0,2,0)) = ((3,3,0)|(0,1,0))+((3,2,0)|(0,1,0))*AB(2)
        ! theta(1830) = theta(1336)+theta(1264)*AB(2) ! ((3,2,0)|(0,1,1)) = ((3,3,0)|(0,0,1))+((3,2,0)|(0,0,1))*AB(2)
        theta(1831) = theta(1339)+theta(1264)*AB(3) ! ((3,2,0)|(0,0,2)) = ((3,2,1)|(0,0,1))+((3,2,0)|(0,0,1))*AB(3)
        theta(1832) = theta(1328)+theta(1265)*AB(1) ! ((3,1,1)|(2,0,0)) = ((4,1,1)|(1,0,0))+((3,1,1)|(1,0,0))*AB(1)
        theta(1833) = theta(1329)+theta(1266)*AB(1) ! ((3,1,1)|(1,1,0)) = ((4,1,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(1)
        ! theta(1834) = theta(1330)+theta(1267)*AB(1) ! ((3,1,1)|(1,0,1)) = ((4,1,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(1)
        theta(1835) = theta(1338)+theta(1266)*AB(2) ! ((3,1,1)|(0,2,0)) = ((3,2,1)|(0,1,0))+((3,1,1)|(0,1,0))*AB(2)
        theta(1836) = theta(1339)+theta(1267)*AB(2) ! ((3,1,1)|(0,1,1)) = ((3,2,1)|(0,0,1))+((3,1,1)|(0,0,1))*AB(2)
        theta(1837) = theta(1342)+theta(1267)*AB(3) ! ((3,1,1)|(0,0,2)) = ((3,1,2)|(0,0,1))+((3,1,1)|(0,0,1))*AB(3)
        theta(1838) = theta(1331)+theta(1268)*AB(1) ! ((3,0,2)|(2,0,0)) = ((4,0,2)|(1,0,0))+((3,0,2)|(1,0,0))*AB(1)
        theta(1839) = theta(1332)+theta(1269)*AB(1) ! ((3,0,2)|(1,1,0)) = ((4,0,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(1)
        ! theta(1840) = theta(1333)+theta(1270)*AB(1) ! ((3,0,2)|(1,0,1)) = ((4,0,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(1)
        theta(1841) = theta(1341)+theta(1269)*AB(2) ! ((3,0,2)|(0,2,0)) = ((3,1,2)|(0,1,0))+((3,0,2)|(0,1,0))*AB(2)
        theta(1842) = theta(1342)+theta(1270)*AB(2) ! ((3,0,2)|(0,1,1)) = ((3,1,2)|(0,0,1))+((3,0,2)|(0,0,1))*AB(2)
        theta(1843) = theta(1345)+theta(1270)*AB(3) ! ((3,0,2)|(0,0,2)) = ((3,0,3)|(0,0,1))+((3,0,2)|(0,0,1))*AB(3)
        theta(1844) = theta(1334)+theta(1271)*AB(1) ! ((2,3,0)|(2,0,0)) = ((3,3,0)|(1,0,0))+((2,3,0)|(1,0,0))*AB(1)
        ! theta(1845) = theta(1335)+theta(1272)*AB(1) ! ((2,3,0)|(1,1,0)) = ((3,3,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(1)
        ! theta(1846) = theta(1336)+theta(1273)*AB(1) ! ((2,3,0)|(1,0,1)) = ((3,3,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(1)
        theta(1847) = theta(1347)+theta(1272)*AB(2) ! ((2,3,0)|(0,2,0)) = ((2,4,0)|(0,1,0))+((2,3,0)|(0,1,0))*AB(2)
        ! theta(1848) = theta(1348)+theta(1273)*AB(2) ! ((2,3,0)|(0,1,1)) = ((2,4,0)|(0,0,1))+((2,3,0)|(0,0,1))*AB(2)
        theta(1849) = theta(1351)+theta(1273)*AB(3) ! ((2,3,0)|(0,0,2)) = ((2,3,1)|(0,0,1))+((2,3,0)|(0,0,1))*AB(3)
        theta(1850) = theta(1337)+theta(1274)*AB(1) ! ((2,2,1)|(2,0,0)) = ((3,2,1)|(1,0,0))+((2,2,1)|(1,0,0))*AB(1)
        theta(1851) = theta(1338)+theta(1275)*AB(1) ! ((2,2,1)|(1,1,0)) = ((3,2,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(1)
        ! theta(1852) = theta(1339)+theta(1276)*AB(1) ! ((2,2,1)|(1,0,1)) = ((3,2,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(1)
        theta(1853) = theta(1350)+theta(1275)*AB(2) ! ((2,2,1)|(0,2,0)) = ((2,3,1)|(0,1,0))+((2,2,1)|(0,1,0))*AB(2)
        theta(1854) = theta(1351)+theta(1276)*AB(2) ! ((2,2,1)|(0,1,1)) = ((2,3,1)|(0,0,1))+((2,2,1)|(0,0,1))*AB(2)
        theta(1855) = theta(1354)+theta(1276)*AB(3) ! ((2,2,1)|(0,0,2)) = ((2,2,2)|(0,0,1))+((2,2,1)|(0,0,1))*AB(3)
        theta(1856) = theta(1340)+theta(1277)*AB(1) ! ((2,1,2)|(2,0,0)) = ((3,1,2)|(1,0,0))+((2,1,2)|(1,0,0))*AB(1)
        theta(1857) = theta(1341)+theta(1278)*AB(1) ! ((2,1,2)|(1,1,0)) = ((3,1,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(1)
        ! theta(1858) = theta(1342)+theta(1279)*AB(1) ! ((2,1,2)|(1,0,1)) = ((3,1,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(1)
        theta(1859) = theta(1353)+theta(1278)*AB(2) ! ((2,1,2)|(0,2,0)) = ((2,2,2)|(0,1,0))+((2,1,2)|(0,1,0))*AB(2)
        theta(1860) = theta(1354)+theta(1279)*AB(2) ! ((2,1,2)|(0,1,1)) = ((2,2,2)|(0,0,1))+((2,1,2)|(0,0,1))*AB(2)
        theta(1861) = theta(1357)+theta(1279)*AB(3) ! ((2,1,2)|(0,0,2)) = ((2,1,3)|(0,0,1))+((2,1,2)|(0,0,1))*AB(3)
        theta(1862) = theta(1343)+theta(1280)*AB(1) ! ((2,0,3)|(2,0,0)) = ((3,0,3)|(1,0,0))+((2,0,3)|(1,0,0))*AB(1)
        theta(1863) = theta(1344)+theta(1281)*AB(1) ! ((2,0,3)|(1,1,0)) = ((3,0,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(1)
        ! theta(1864) = theta(1345)+theta(1282)*AB(1) ! ((2,0,3)|(1,0,1)) = ((3,0,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(1)
        theta(1865) = theta(1356)+theta(1281)*AB(2) ! ((2,0,3)|(0,2,0)) = ((2,1,3)|(0,1,0))+((2,0,3)|(0,1,0))*AB(2)
        theta(1866) = theta(1357)+theta(1282)*AB(2) ! ((2,0,3)|(0,1,1)) = ((2,1,3)|(0,0,1))+((2,0,3)|(0,0,1))*AB(2)
        theta(1867) = theta(1360)+theta(1282)*AB(3) ! ((2,0,3)|(0,0,2)) = ((2,0,4)|(0,0,1))+((2,0,3)|(0,0,1))*AB(3)
        theta(1868) = theta(1346)+theta(1283)*AB(1) ! ((1,4,0)|(2,0,0)) = ((2,4,0)|(1,0,0))+((1,4,0)|(1,0,0))*AB(1)
        ! theta(1869) = theta(1347)+theta(1284)*AB(1) ! ((1,4,0)|(1,1,0)) = ((2,4,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(1)
        ! theta(1870) = theta(1348)+theta(1285)*AB(1) ! ((1,4,0)|(1,0,1)) = ((2,4,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(1)
        theta(1871) = theta(1362)+theta(1284)*AB(2) ! ((1,4,0)|(0,2,0)) = ((1,5,0)|(0,1,0))+((1,4,0)|(0,1,0))*AB(2)
        ! theta(1872) = theta(1363)+theta(1285)*AB(2) ! ((1,4,0)|(0,1,1)) = ((1,5,0)|(0,0,1))+((1,4,0)|(0,0,1))*AB(2)
        theta(1873) = theta(1366)+theta(1285)*AB(3) ! ((1,4,0)|(0,0,2)) = ((1,4,1)|(0,0,1))+((1,4,0)|(0,0,1))*AB(3)
        theta(1874) = theta(1349)+theta(1286)*AB(1) ! ((1,3,1)|(2,0,0)) = ((2,3,1)|(1,0,0))+((1,3,1)|(1,0,0))*AB(1)
        theta(1875) = theta(1350)+theta(1287)*AB(1) ! ((1,3,1)|(1,1,0)) = ((2,3,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(1)
        ! theta(1876) = theta(1351)+theta(1288)*AB(1) ! ((1,3,1)|(1,0,1)) = ((2,3,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(1)
        theta(1877) = theta(1365)+theta(1287)*AB(2) ! ((1,3,1)|(0,2,0)) = ((1,4,1)|(0,1,0))+((1,3,1)|(0,1,0))*AB(2)
        theta(1878) = theta(1366)+theta(1288)*AB(2) ! ((1,3,1)|(0,1,1)) = ((1,4,1)|(0,0,1))+((1,3,1)|(0,0,1))*AB(2)
        theta(1879) = theta(1369)+theta(1288)*AB(3) ! ((1,3,1)|(0,0,2)) = ((1,3,2)|(0,0,1))+((1,3,1)|(0,0,1))*AB(3)
        theta(1880) = theta(1352)+theta(1289)*AB(1) ! ((1,2,2)|(2,0,0)) = ((2,2,2)|(1,0,0))+((1,2,2)|(1,0,0))*AB(1)
        theta(1881) = theta(1353)+theta(1290)*AB(1) ! ((1,2,2)|(1,1,0)) = ((2,2,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(1)
        ! theta(1882) = theta(1354)+theta(1291)*AB(1) ! ((1,2,2)|(1,0,1)) = ((2,2,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(1)
        theta(1883) = theta(1368)+theta(1290)*AB(2) ! ((1,2,2)|(0,2,0)) = ((1,3,2)|(0,1,0))+((1,2,2)|(0,1,0))*AB(2)
        theta(1884) = theta(1369)+theta(1291)*AB(2) ! ((1,2,2)|(0,1,1)) = ((1,3,2)|(0,0,1))+((1,2,2)|(0,0,1))*AB(2)
        theta(1885) = theta(1372)+theta(1291)*AB(3) ! ((1,2,2)|(0,0,2)) = ((1,2,3)|(0,0,1))+((1,2,2)|(0,0,1))*AB(3)
        theta(1886) = theta(1355)+theta(1292)*AB(1) ! ((1,1,3)|(2,0,0)) = ((2,1,3)|(1,0,0))+((1,1,3)|(1,0,0))*AB(1)
        theta(1887) = theta(1356)+theta(1293)*AB(1) ! ((1,1,3)|(1,1,0)) = ((2,1,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(1)
        ! theta(1888) = theta(1357)+theta(1294)*AB(1) ! ((1,1,3)|(1,0,1)) = ((2,1,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(1)
        theta(1889) = theta(1371)+theta(1293)*AB(2) ! ((1,1,3)|(0,2,0)) = ((1,2,3)|(0,1,0))+((1,1,3)|(0,1,0))*AB(2)
        theta(1890) = theta(1372)+theta(1294)*AB(2) ! ((1,1,3)|(0,1,1)) = ((1,2,3)|(0,0,1))+((1,1,3)|(0,0,1))*AB(2)
        theta(1891) = theta(1375)+theta(1294)*AB(3) ! ((1,1,3)|(0,0,2)) = ((1,1,4)|(0,0,1))+((1,1,3)|(0,0,1))*AB(3)
        theta(1892) = theta(1358)+theta(1295)*AB(1) ! ((1,0,4)|(2,0,0)) = ((2,0,4)|(1,0,0))+((1,0,4)|(1,0,0))*AB(1)
        theta(1893) = theta(1359)+theta(1296)*AB(1) ! ((1,0,4)|(1,1,0)) = ((2,0,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(1)
        ! theta(1894) = theta(1360)+theta(1297)*AB(1) ! ((1,0,4)|(1,0,1)) = ((2,0,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(1)
        theta(1895) = theta(1374)+theta(1296)*AB(2) ! ((1,0,4)|(0,2,0)) = ((1,1,4)|(0,1,0))+((1,0,4)|(0,1,0))*AB(2)
        theta(1896) = theta(1375)+theta(1297)*AB(2) ! ((1,0,4)|(0,1,1)) = ((1,1,4)|(0,0,1))+((1,0,4)|(0,0,1))*AB(2)
        theta(1897) = theta(1378)+theta(1297)*AB(3) ! ((1,0,4)|(0,0,2)) = ((1,0,5)|(0,0,1))+((1,0,4)|(0,0,1))*AB(3)
        theta(1898) = theta(1361)+theta(1298)*AB(1) ! ((0,5,0)|(2,0,0)) = ((1,5,0)|(1,0,0))+((0,5,0)|(1,0,0))*AB(1)
        ! theta(1899) = theta(1362)+theta(1299)*AB(1) ! ((0,5,0)|(1,1,0)) = ((1,5,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(1)
        ! theta(1900) = theta(1363)+theta(1300)*AB(1) ! ((0,5,0)|(1,0,1)) = ((1,5,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(1)
        theta(1901) = theta(1380)+theta(1299)*AB(2) ! ((0,5,0)|(0,2,0)) = ((0,6,0)|(0,1,0))+((0,5,0)|(0,1,0))*AB(2)
        ! theta(1902) = theta(1381)+theta(1300)*AB(2) ! ((0,5,0)|(0,1,1)) = ((0,6,0)|(0,0,1))+((0,5,0)|(0,0,1))*AB(2)
        theta(1903) = theta(1384)+theta(1300)*AB(3) ! ((0,5,0)|(0,0,2)) = ((0,5,1)|(0,0,1))+((0,5,0)|(0,0,1))*AB(3)
        theta(1904) = theta(1364)+theta(1301)*AB(1) ! ((0,4,1)|(2,0,0)) = ((1,4,1)|(1,0,0))+((0,4,1)|(1,0,0))*AB(1)
        theta(1905) = theta(1365)+theta(1302)*AB(1) ! ((0,4,1)|(1,1,0)) = ((1,4,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(1)
        ! theta(1906) = theta(1366)+theta(1303)*AB(1) ! ((0,4,1)|(1,0,1)) = ((1,4,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(1)
        theta(1907) = theta(1383)+theta(1302)*AB(2) ! ((0,4,1)|(0,2,0)) = ((0,5,1)|(0,1,0))+((0,4,1)|(0,1,0))*AB(2)
        theta(1908) = theta(1384)+theta(1303)*AB(2) ! ((0,4,1)|(0,1,1)) = ((0,5,1)|(0,0,1))+((0,4,1)|(0,0,1))*AB(2)
        theta(1909) = theta(1387)+theta(1303)*AB(3) ! ((0,4,1)|(0,0,2)) = ((0,4,2)|(0,0,1))+((0,4,1)|(0,0,1))*AB(3)
        theta(1910) = theta(1367)+theta(1304)*AB(1) ! ((0,3,2)|(2,0,0)) = ((1,3,2)|(1,0,0))+((0,3,2)|(1,0,0))*AB(1)
        theta(1911) = theta(1368)+theta(1305)*AB(1) ! ((0,3,2)|(1,1,0)) = ((1,3,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(1)
        ! theta(1912) = theta(1369)+theta(1306)*AB(1) ! ((0,3,2)|(1,0,1)) = ((1,3,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(1)
        theta(1913) = theta(1386)+theta(1305)*AB(2) ! ((0,3,2)|(0,2,0)) = ((0,4,2)|(0,1,0))+((0,3,2)|(0,1,0))*AB(2)
        theta(1914) = theta(1387)+theta(1306)*AB(2) ! ((0,3,2)|(0,1,1)) = ((0,4,2)|(0,0,1))+((0,3,2)|(0,0,1))*AB(2)
        theta(1915) = theta(1390)+theta(1306)*AB(3) ! ((0,3,2)|(0,0,2)) = ((0,3,3)|(0,0,1))+((0,3,2)|(0,0,1))*AB(3)
        theta(1916) = theta(1370)+theta(1307)*AB(1) ! ((0,2,3)|(2,0,0)) = ((1,2,3)|(1,0,0))+((0,2,3)|(1,0,0))*AB(1)
        theta(1917) = theta(1371)+theta(1308)*AB(1) ! ((0,2,3)|(1,1,0)) = ((1,2,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(1)
        ! theta(1918) = theta(1372)+theta(1309)*AB(1) ! ((0,2,3)|(1,0,1)) = ((1,2,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(1)
        theta(1919) = theta(1389)+theta(1308)*AB(2) ! ((0,2,3)|(0,2,0)) = ((0,3,3)|(0,1,0))+((0,2,3)|(0,1,0))*AB(2)
        theta(1920) = theta(1390)+theta(1309)*AB(2) ! ((0,2,3)|(0,1,1)) = ((0,3,3)|(0,0,1))+((0,2,3)|(0,0,1))*AB(2)
        theta(1921) = theta(1393)+theta(1309)*AB(3) ! ((0,2,3)|(0,0,2)) = ((0,2,4)|(0,0,1))+((0,2,3)|(0,0,1))*AB(3)
        theta(1922) = theta(1373)+theta(1310)*AB(1) ! ((0,1,4)|(2,0,0)) = ((1,1,4)|(1,0,0))+((0,1,4)|(1,0,0))*AB(1)
        theta(1923) = theta(1374)+theta(1311)*AB(1) ! ((0,1,4)|(1,1,0)) = ((1,1,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(1)
        ! theta(1924) = theta(1375)+theta(1312)*AB(1) ! ((0,1,4)|(1,0,1)) = ((1,1,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(1)
        theta(1925) = theta(1392)+theta(1311)*AB(2) ! ((0,1,4)|(0,2,0)) = ((0,2,4)|(0,1,0))+((0,1,4)|(0,1,0))*AB(2)
        theta(1926) = theta(1393)+theta(1312)*AB(2) ! ((0,1,4)|(0,1,1)) = ((0,2,4)|(0,0,1))+((0,1,4)|(0,0,1))*AB(2)
        theta(1927) = theta(1396)+theta(1312)*AB(3) ! ((0,1,4)|(0,0,2)) = ((0,1,5)|(0,0,1))+((0,1,4)|(0,0,1))*AB(3)
        theta(1928) = theta(1376)+theta(1313)*AB(1) ! ((0,0,5)|(2,0,0)) = ((1,0,5)|(1,0,0))+((0,0,5)|(1,0,0))*AB(1)
        theta(1929) = theta(1377)+theta(1314)*AB(1) ! ((0,0,5)|(1,1,0)) = ((1,0,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(1)
        ! theta(1930) = theta(1378)+theta(1315)*AB(1) ! ((0,0,5)|(1,0,1)) = ((1,0,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(1)
        theta(1931) = theta(1395)+theta(1314)*AB(2) ! ((0,0,5)|(0,2,0)) = ((0,1,5)|(0,1,0))+((0,0,5)|(0,1,0))*AB(2)
        theta(1932) = theta(1396)+theta(1315)*AB(2) ! ((0,0,5)|(0,1,1)) = ((0,1,5)|(0,0,1))+((0,0,5)|(0,0,1))*AB(2)
        theta(1933) = theta(1399)+theta(1315)*AB(3) ! ((0,0,5)|(0,0,2)) = ((0,0,6)|(0,0,1))+((0,0,5)|(0,0,1))*AB(3)
        theta(1934) = theta(1400)+theta(1316)*AB(1) ! ((6,0,0)|(2,0,0)) = ((7,0,0)|(1,0,0))+((6,0,0)|(1,0,0))*AB(1)
        ! theta(1935) = theta(1401)+theta(1317)*AB(1) ! ((6,0,0)|(1,1,0)) = ((7,0,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(1)
        ! theta(1936) = theta(1402)+theta(1318)*AB(1) ! ((6,0,0)|(1,0,1)) = ((7,0,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(1)
        theta(1937) = theta(1404)+theta(1317)*AB(2) ! ((6,0,0)|(0,2,0)) = ((6,1,0)|(0,1,0))+((6,0,0)|(0,1,0))*AB(2)
        ! theta(1938) = theta(1405)+theta(1318)*AB(2) ! ((6,0,0)|(0,1,1)) = ((6,1,0)|(0,0,1))+((6,0,0)|(0,0,1))*AB(2)
        theta(1939) = theta(1408)+theta(1318)*AB(3) ! ((6,0,0)|(0,0,2)) = ((6,0,1)|(0,0,1))+((6,0,0)|(0,0,1))*AB(3)
        theta(1940) = theta(1403)+theta(1319)*AB(1) ! ((5,1,0)|(2,0,0)) = ((6,1,0)|(1,0,0))+((5,1,0)|(1,0,0))*AB(1)
        ! theta(1941) = theta(1404)+theta(1320)*AB(1) ! ((5,1,0)|(1,1,0)) = ((6,1,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(1)
        ! theta(1942) = theta(1405)+theta(1321)*AB(1) ! ((5,1,0)|(1,0,1)) = ((6,1,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(1)
        theta(1943) = theta(1410)+theta(1320)*AB(2) ! ((5,1,0)|(0,2,0)) = ((5,2,0)|(0,1,0))+((5,1,0)|(0,1,0))*AB(2)
        ! theta(1944) = theta(1411)+theta(1321)*AB(2) ! ((5,1,0)|(0,1,1)) = ((5,2,0)|(0,0,1))+((5,1,0)|(0,0,1))*AB(2)
        theta(1945) = theta(1414)+theta(1321)*AB(3) ! ((5,1,0)|(0,0,2)) = ((5,1,1)|(0,0,1))+((5,1,0)|(0,0,1))*AB(3)
        theta(1946) = theta(1406)+theta(1322)*AB(1) ! ((5,0,1)|(2,0,0)) = ((6,0,1)|(1,0,0))+((5,0,1)|(1,0,0))*AB(1)
        theta(1947) = theta(1407)+theta(1323)*AB(1) ! ((5,0,1)|(1,1,0)) = ((6,0,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(1)
        ! theta(1948) = theta(1408)+theta(1324)*AB(1) ! ((5,0,1)|(1,0,1)) = ((6,0,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(1)
        theta(1949) = theta(1413)+theta(1323)*AB(2) ! ((5,0,1)|(0,2,0)) = ((5,1,1)|(0,1,0))+((5,0,1)|(0,1,0))*AB(2)
        theta(1950) = theta(1414)+theta(1324)*AB(2) ! ((5,0,1)|(0,1,1)) = ((5,1,1)|(0,0,1))+((5,0,1)|(0,0,1))*AB(2)
        theta(1951) = theta(1417)+theta(1324)*AB(3) ! ((5,0,1)|(0,0,2)) = ((5,0,2)|(0,0,1))+((5,0,1)|(0,0,1))*AB(3)
        theta(1952) = theta(1409)+theta(1325)*AB(1) ! ((4,2,0)|(2,0,0)) = ((5,2,0)|(1,0,0))+((4,2,0)|(1,0,0))*AB(1)
        ! theta(1953) = theta(1410)+theta(1326)*AB(1) ! ((4,2,0)|(1,1,0)) = ((5,2,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(1)
        ! theta(1954) = theta(1411)+theta(1327)*AB(1) ! ((4,2,0)|(1,0,1)) = ((5,2,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(1)
        theta(1955) = theta(1419)+theta(1326)*AB(2) ! ((4,2,0)|(0,2,0)) = ((4,3,0)|(0,1,0))+((4,2,0)|(0,1,0))*AB(2)
        ! theta(1956) = theta(1420)+theta(1327)*AB(2) ! ((4,2,0)|(0,1,1)) = ((4,3,0)|(0,0,1))+((4,2,0)|(0,0,1))*AB(2)
        theta(1957) = theta(1423)+theta(1327)*AB(3) ! ((4,2,0)|(0,0,2)) = ((4,2,1)|(0,0,1))+((4,2,0)|(0,0,1))*AB(3)
        theta(1958) = theta(1412)+theta(1328)*AB(1) ! ((4,1,1)|(2,0,0)) = ((5,1,1)|(1,0,0))+((4,1,1)|(1,0,0))*AB(1)
        theta(1959) = theta(1413)+theta(1329)*AB(1) ! ((4,1,1)|(1,1,0)) = ((5,1,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(1)
        ! theta(1960) = theta(1414)+theta(1330)*AB(1) ! ((4,1,1)|(1,0,1)) = ((5,1,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(1)
        theta(1961) = theta(1422)+theta(1329)*AB(2) ! ((4,1,1)|(0,2,0)) = ((4,2,1)|(0,1,0))+((4,1,1)|(0,1,0))*AB(2)
        theta(1962) = theta(1423)+theta(1330)*AB(2) ! ((4,1,1)|(0,1,1)) = ((4,2,1)|(0,0,1))+((4,1,1)|(0,0,1))*AB(2)
        theta(1963) = theta(1426)+theta(1330)*AB(3) ! ((4,1,1)|(0,0,2)) = ((4,1,2)|(0,0,1))+((4,1,1)|(0,0,1))*AB(3)
        theta(1964) = theta(1415)+theta(1331)*AB(1) ! ((4,0,2)|(2,0,0)) = ((5,0,2)|(1,0,0))+((4,0,2)|(1,0,0))*AB(1)
        theta(1965) = theta(1416)+theta(1332)*AB(1) ! ((4,0,2)|(1,1,0)) = ((5,0,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(1)
        ! theta(1966) = theta(1417)+theta(1333)*AB(1) ! ((4,0,2)|(1,0,1)) = ((5,0,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(1)
        theta(1967) = theta(1425)+theta(1332)*AB(2) ! ((4,0,2)|(0,2,0)) = ((4,1,2)|(0,1,0))+((4,0,2)|(0,1,0))*AB(2)
        theta(1968) = theta(1426)+theta(1333)*AB(2) ! ((4,0,2)|(0,1,1)) = ((4,1,2)|(0,0,1))+((4,0,2)|(0,0,1))*AB(2)
        theta(1969) = theta(1429)+theta(1333)*AB(3) ! ((4,0,2)|(0,0,2)) = ((4,0,3)|(0,0,1))+((4,0,2)|(0,0,1))*AB(3)
        theta(1970) = theta(1418)+theta(1334)*AB(1) ! ((3,3,0)|(2,0,0)) = ((4,3,0)|(1,0,0))+((3,3,0)|(1,0,0))*AB(1)
        ! theta(1971) = theta(1419)+theta(1335)*AB(1) ! ((3,3,0)|(1,1,0)) = ((4,3,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(1)
        ! theta(1972) = theta(1420)+theta(1336)*AB(1) ! ((3,3,0)|(1,0,1)) = ((4,3,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(1)
        theta(1973) = theta(1431)+theta(1335)*AB(2) ! ((3,3,0)|(0,2,0)) = ((3,4,0)|(0,1,0))+((3,3,0)|(0,1,0))*AB(2)
        ! theta(1974) = theta(1432)+theta(1336)*AB(2) ! ((3,3,0)|(0,1,1)) = ((3,4,0)|(0,0,1))+((3,3,0)|(0,0,1))*AB(2)
        theta(1975) = theta(1435)+theta(1336)*AB(3) ! ((3,3,0)|(0,0,2)) = ((3,3,1)|(0,0,1))+((3,3,0)|(0,0,1))*AB(3)
        theta(1976) = theta(1421)+theta(1337)*AB(1) ! ((3,2,1)|(2,0,0)) = ((4,2,1)|(1,0,0))+((3,2,1)|(1,0,0))*AB(1)
        theta(1977) = theta(1422)+theta(1338)*AB(1) ! ((3,2,1)|(1,1,0)) = ((4,2,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(1)
        ! theta(1978) = theta(1423)+theta(1339)*AB(1) ! ((3,2,1)|(1,0,1)) = ((4,2,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(1)
        theta(1979) = theta(1434)+theta(1338)*AB(2) ! ((3,2,1)|(0,2,0)) = ((3,3,1)|(0,1,0))+((3,2,1)|(0,1,0))*AB(2)
        theta(1980) = theta(1435)+theta(1339)*AB(2) ! ((3,2,1)|(0,1,1)) = ((3,3,1)|(0,0,1))+((3,2,1)|(0,0,1))*AB(2)
        theta(1981) = theta(1438)+theta(1339)*AB(3) ! ((3,2,1)|(0,0,2)) = ((3,2,2)|(0,0,1))+((3,2,1)|(0,0,1))*AB(3)
        theta(1982) = theta(1424)+theta(1340)*AB(1) ! ((3,1,2)|(2,0,0)) = ((4,1,2)|(1,0,0))+((3,1,2)|(1,0,0))*AB(1)
        theta(1983) = theta(1425)+theta(1341)*AB(1) ! ((3,1,2)|(1,1,0)) = ((4,1,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(1)
        ! theta(1984) = theta(1426)+theta(1342)*AB(1) ! ((3,1,2)|(1,0,1)) = ((4,1,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(1)
        theta(1985) = theta(1437)+theta(1341)*AB(2) ! ((3,1,2)|(0,2,0)) = ((3,2,2)|(0,1,0))+((3,1,2)|(0,1,0))*AB(2)
        theta(1986) = theta(1438)+theta(1342)*AB(2) ! ((3,1,2)|(0,1,1)) = ((3,2,2)|(0,0,1))+((3,1,2)|(0,0,1))*AB(2)
        theta(1987) = theta(1441)+theta(1342)*AB(3) ! ((3,1,2)|(0,0,2)) = ((3,1,3)|(0,0,1))+((3,1,2)|(0,0,1))*AB(3)
        theta(1988) = theta(1427)+theta(1343)*AB(1) ! ((3,0,3)|(2,0,0)) = ((4,0,3)|(1,0,0))+((3,0,3)|(1,0,0))*AB(1)
        theta(1989) = theta(1428)+theta(1344)*AB(1) ! ((3,0,3)|(1,1,0)) = ((4,0,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(1)
        ! theta(1990) = theta(1429)+theta(1345)*AB(1) ! ((3,0,3)|(1,0,1)) = ((4,0,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(1)
        theta(1991) = theta(1440)+theta(1344)*AB(2) ! ((3,0,3)|(0,2,0)) = ((3,1,3)|(0,1,0))+((3,0,3)|(0,1,0))*AB(2)
        theta(1992) = theta(1441)+theta(1345)*AB(2) ! ((3,0,3)|(0,1,1)) = ((3,1,3)|(0,0,1))+((3,0,3)|(0,0,1))*AB(2)
        theta(1993) = theta(1444)+theta(1345)*AB(3) ! ((3,0,3)|(0,0,2)) = ((3,0,4)|(0,0,1))+((3,0,3)|(0,0,1))*AB(3)
        theta(1994) = theta(1430)+theta(1346)*AB(1) ! ((2,4,0)|(2,0,0)) = ((3,4,0)|(1,0,0))+((2,4,0)|(1,0,0))*AB(1)
        ! theta(1995) = theta(1431)+theta(1347)*AB(1) ! ((2,4,0)|(1,1,0)) = ((3,4,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(1)
        ! theta(1996) = theta(1432)+theta(1348)*AB(1) ! ((2,4,0)|(1,0,1)) = ((3,4,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(1)
        theta(1997) = theta(1446)+theta(1347)*AB(2) ! ((2,4,0)|(0,2,0)) = ((2,5,0)|(0,1,0))+((2,4,0)|(0,1,0))*AB(2)
        ! theta(1998) = theta(1447)+theta(1348)*AB(2) ! ((2,4,0)|(0,1,1)) = ((2,5,0)|(0,0,1))+((2,4,0)|(0,0,1))*AB(2)
        theta(1999) = theta(1450)+theta(1348)*AB(3) ! ((2,4,0)|(0,0,2)) = ((2,4,1)|(0,0,1))+((2,4,0)|(0,0,1))*AB(3)
        theta(2000) = theta(1433)+theta(1349)*AB(1) ! ((2,3,1)|(2,0,0)) = ((3,3,1)|(1,0,0))+((2,3,1)|(1,0,0))*AB(1)
        theta(2001) = theta(1434)+theta(1350)*AB(1) ! ((2,3,1)|(1,1,0)) = ((3,3,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(1)
        ! theta(2002) = theta(1435)+theta(1351)*AB(1) ! ((2,3,1)|(1,0,1)) = ((3,3,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(1)
        theta(2003) = theta(1449)+theta(1350)*AB(2) ! ((2,3,1)|(0,2,0)) = ((2,4,1)|(0,1,0))+((2,3,1)|(0,1,0))*AB(2)
        theta(2004) = theta(1450)+theta(1351)*AB(2) ! ((2,3,1)|(0,1,1)) = ((2,4,1)|(0,0,1))+((2,3,1)|(0,0,1))*AB(2)
        theta(2005) = theta(1453)+theta(1351)*AB(3) ! ((2,3,1)|(0,0,2)) = ((2,3,2)|(0,0,1))+((2,3,1)|(0,0,1))*AB(3)
        theta(2006) = theta(1436)+theta(1352)*AB(1) ! ((2,2,2)|(2,0,0)) = ((3,2,2)|(1,0,0))+((2,2,2)|(1,0,0))*AB(1)
        theta(2007) = theta(1437)+theta(1353)*AB(1) ! ((2,2,2)|(1,1,0)) = ((3,2,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(1)
        ! theta(2008) = theta(1438)+theta(1354)*AB(1) ! ((2,2,2)|(1,0,1)) = ((3,2,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(1)
        theta(2009) = theta(1452)+theta(1353)*AB(2) ! ((2,2,2)|(0,2,0)) = ((2,3,2)|(0,1,0))+((2,2,2)|(0,1,0))*AB(2)
        theta(2010) = theta(1453)+theta(1354)*AB(2) ! ((2,2,2)|(0,1,1)) = ((2,3,2)|(0,0,1))+((2,2,2)|(0,0,1))*AB(2)
        theta(2011) = theta(1456)+theta(1354)*AB(3) ! ((2,2,2)|(0,0,2)) = ((2,2,3)|(0,0,1))+((2,2,2)|(0,0,1))*AB(3)
        theta(2012) = theta(1439)+theta(1355)*AB(1) ! ((2,1,3)|(2,0,0)) = ((3,1,3)|(1,0,0))+((2,1,3)|(1,0,0))*AB(1)
        theta(2013) = theta(1440)+theta(1356)*AB(1) ! ((2,1,3)|(1,1,0)) = ((3,1,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(1)
        ! theta(2014) = theta(1441)+theta(1357)*AB(1) ! ((2,1,3)|(1,0,1)) = ((3,1,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(1)
        theta(2015) = theta(1455)+theta(1356)*AB(2) ! ((2,1,3)|(0,2,0)) = ((2,2,3)|(0,1,0))+((2,1,3)|(0,1,0))*AB(2)
        theta(2016) = theta(1456)+theta(1357)*AB(2) ! ((2,1,3)|(0,1,1)) = ((2,2,3)|(0,0,1))+((2,1,3)|(0,0,1))*AB(2)
        theta(2017) = theta(1459)+theta(1357)*AB(3) ! ((2,1,3)|(0,0,2)) = ((2,1,4)|(0,0,1))+((2,1,3)|(0,0,1))*AB(3)
        theta(2018) = theta(1442)+theta(1358)*AB(1) ! ((2,0,4)|(2,0,0)) = ((3,0,4)|(1,0,0))+((2,0,4)|(1,0,0))*AB(1)
        theta(2019) = theta(1443)+theta(1359)*AB(1) ! ((2,0,4)|(1,1,0)) = ((3,0,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(1)
        ! theta(2020) = theta(1444)+theta(1360)*AB(1) ! ((2,0,4)|(1,0,1)) = ((3,0,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(1)
        theta(2021) = theta(1458)+theta(1359)*AB(2) ! ((2,0,4)|(0,2,0)) = ((2,1,4)|(0,1,0))+((2,0,4)|(0,1,0))*AB(2)
        theta(2022) = theta(1459)+theta(1360)*AB(2) ! ((2,0,4)|(0,1,1)) = ((2,1,4)|(0,0,1))+((2,0,4)|(0,0,1))*AB(2)
        theta(2023) = theta(1462)+theta(1360)*AB(3) ! ((2,0,4)|(0,0,2)) = ((2,0,5)|(0,0,1))+((2,0,4)|(0,0,1))*AB(3)
        theta(2024) = theta(1445)+theta(1361)*AB(1) ! ((1,5,0)|(2,0,0)) = ((2,5,0)|(1,0,0))+((1,5,0)|(1,0,0))*AB(1)
        ! theta(2025) = theta(1446)+theta(1362)*AB(1) ! ((1,5,0)|(1,1,0)) = ((2,5,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(1)
        ! theta(2026) = theta(1447)+theta(1363)*AB(1) ! ((1,5,0)|(1,0,1)) = ((2,5,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(1)
        theta(2027) = theta(1464)+theta(1362)*AB(2) ! ((1,5,0)|(0,2,0)) = ((1,6,0)|(0,1,0))+((1,5,0)|(0,1,0))*AB(2)
        ! theta(2028) = theta(1465)+theta(1363)*AB(2) ! ((1,5,0)|(0,1,1)) = ((1,6,0)|(0,0,1))+((1,5,0)|(0,0,1))*AB(2)
        theta(2029) = theta(1468)+theta(1363)*AB(3) ! ((1,5,0)|(0,0,2)) = ((1,5,1)|(0,0,1))+((1,5,0)|(0,0,1))*AB(3)
        theta(2030) = theta(1448)+theta(1364)*AB(1) ! ((1,4,1)|(2,0,0)) = ((2,4,1)|(1,0,0))+((1,4,1)|(1,0,0))*AB(1)
        theta(2031) = theta(1449)+theta(1365)*AB(1) ! ((1,4,1)|(1,1,0)) = ((2,4,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(1)
        ! theta(2032) = theta(1450)+theta(1366)*AB(1) ! ((1,4,1)|(1,0,1)) = ((2,4,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(1)
        theta(2033) = theta(1467)+theta(1365)*AB(2) ! ((1,4,1)|(0,2,0)) = ((1,5,1)|(0,1,0))+((1,4,1)|(0,1,0))*AB(2)
        theta(2034) = theta(1468)+theta(1366)*AB(2) ! ((1,4,1)|(0,1,1)) = ((1,5,1)|(0,0,1))+((1,4,1)|(0,0,1))*AB(2)
        theta(2035) = theta(1471)+theta(1366)*AB(3) ! ((1,4,1)|(0,0,2)) = ((1,4,2)|(0,0,1))+((1,4,1)|(0,0,1))*AB(3)
        theta(2036) = theta(1451)+theta(1367)*AB(1) ! ((1,3,2)|(2,0,0)) = ((2,3,2)|(1,0,0))+((1,3,2)|(1,0,0))*AB(1)
        theta(2037) = theta(1452)+theta(1368)*AB(1) ! ((1,3,2)|(1,1,0)) = ((2,3,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(1)
        ! theta(2038) = theta(1453)+theta(1369)*AB(1) ! ((1,3,2)|(1,0,1)) = ((2,3,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(1)
        theta(2039) = theta(1470)+theta(1368)*AB(2) ! ((1,3,2)|(0,2,0)) = ((1,4,2)|(0,1,0))+((1,3,2)|(0,1,0))*AB(2)
        theta(2040) = theta(1471)+theta(1369)*AB(2) ! ((1,3,2)|(0,1,1)) = ((1,4,2)|(0,0,1))+((1,3,2)|(0,0,1))*AB(2)
        theta(2041) = theta(1474)+theta(1369)*AB(3) ! ((1,3,2)|(0,0,2)) = ((1,3,3)|(0,0,1))+((1,3,2)|(0,0,1))*AB(3)
        theta(2042) = theta(1454)+theta(1370)*AB(1) ! ((1,2,3)|(2,0,0)) = ((2,2,3)|(1,0,0))+((1,2,3)|(1,0,0))*AB(1)
        theta(2043) = theta(1455)+theta(1371)*AB(1) ! ((1,2,3)|(1,1,0)) = ((2,2,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(1)
        ! theta(2044) = theta(1456)+theta(1372)*AB(1) ! ((1,2,3)|(1,0,1)) = ((2,2,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(1)
        theta(2045) = theta(1473)+theta(1371)*AB(2) ! ((1,2,3)|(0,2,0)) = ((1,3,3)|(0,1,0))+((1,2,3)|(0,1,0))*AB(2)
        theta(2046) = theta(1474)+theta(1372)*AB(2) ! ((1,2,3)|(0,1,1)) = ((1,3,3)|(0,0,1))+((1,2,3)|(0,0,1))*AB(2)
        theta(2047) = theta(1477)+theta(1372)*AB(3) ! ((1,2,3)|(0,0,2)) = ((1,2,4)|(0,0,1))+((1,2,3)|(0,0,1))*AB(3)
        theta(2048) = theta(1457)+theta(1373)*AB(1) ! ((1,1,4)|(2,0,0)) = ((2,1,4)|(1,0,0))+((1,1,4)|(1,0,0))*AB(1)
        theta(2049) = theta(1458)+theta(1374)*AB(1) ! ((1,1,4)|(1,1,0)) = ((2,1,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(1)
        ! theta(2050) = theta(1459)+theta(1375)*AB(1) ! ((1,1,4)|(1,0,1)) = ((2,1,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(1)
        theta(2051) = theta(1476)+theta(1374)*AB(2) ! ((1,1,4)|(0,2,0)) = ((1,2,4)|(0,1,0))+((1,1,4)|(0,1,0))*AB(2)
        theta(2052) = theta(1477)+theta(1375)*AB(2) ! ((1,1,4)|(0,1,1)) = ((1,2,4)|(0,0,1))+((1,1,4)|(0,0,1))*AB(2)
        theta(2053) = theta(1480)+theta(1375)*AB(3) ! ((1,1,4)|(0,0,2)) = ((1,1,5)|(0,0,1))+((1,1,4)|(0,0,1))*AB(3)
        theta(2054) = theta(1460)+theta(1376)*AB(1) ! ((1,0,5)|(2,0,0)) = ((2,0,5)|(1,0,0))+((1,0,5)|(1,0,0))*AB(1)
        theta(2055) = theta(1461)+theta(1377)*AB(1) ! ((1,0,5)|(1,1,0)) = ((2,0,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(1)
        ! theta(2056) = theta(1462)+theta(1378)*AB(1) ! ((1,0,5)|(1,0,1)) = ((2,0,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(1)
        theta(2057) = theta(1479)+theta(1377)*AB(2) ! ((1,0,5)|(0,2,0)) = ((1,1,5)|(0,1,0))+((1,0,5)|(0,1,0))*AB(2)
        theta(2058) = theta(1480)+theta(1378)*AB(2) ! ((1,0,5)|(0,1,1)) = ((1,1,5)|(0,0,1))+((1,0,5)|(0,0,1))*AB(2)
        theta(2059) = theta(1483)+theta(1378)*AB(3) ! ((1,0,5)|(0,0,2)) = ((1,0,6)|(0,0,1))+((1,0,5)|(0,0,1))*AB(3)
        theta(2060) = theta(1463)+theta(1379)*AB(1) ! ((0,6,0)|(2,0,0)) = ((1,6,0)|(1,0,0))+((0,6,0)|(1,0,0))*AB(1)
        ! theta(2061) = theta(1464)+theta(1380)*AB(1) ! ((0,6,0)|(1,1,0)) = ((1,6,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(1)
        ! theta(2062) = theta(1465)+theta(1381)*AB(1) ! ((0,6,0)|(1,0,1)) = ((1,6,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(1)
        theta(2063) = theta(1485)+theta(1380)*AB(2) ! ((0,6,0)|(0,2,0)) = ((0,7,0)|(0,1,0))+((0,6,0)|(0,1,0))*AB(2)
        ! theta(2064) = theta(1486)+theta(1381)*AB(2) ! ((0,6,0)|(0,1,1)) = ((0,7,0)|(0,0,1))+((0,6,0)|(0,0,1))*AB(2)
        theta(2065) = theta(1489)+theta(1381)*AB(3) ! ((0,6,0)|(0,0,2)) = ((0,6,1)|(0,0,1))+((0,6,0)|(0,0,1))*AB(3)
        theta(2066) = theta(1466)+theta(1382)*AB(1) ! ((0,5,1)|(2,0,0)) = ((1,5,1)|(1,0,0))+((0,5,1)|(1,0,0))*AB(1)
        ! theta(2067) = theta(1467)+theta(1383)*AB(1) ! ((0,5,1)|(1,1,0)) = ((1,5,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(1)
        ! theta(2068) = theta(1468)+theta(1384)*AB(1) ! ((0,5,1)|(1,0,1)) = ((1,5,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(1)
        theta(2069) = theta(1488)+theta(1383)*AB(2) ! ((0,5,1)|(0,2,0)) = ((0,6,1)|(0,1,0))+((0,5,1)|(0,1,0))*AB(2)
        ! theta(2070) = theta(1489)+theta(1384)*AB(2) ! ((0,5,1)|(0,1,1)) = ((0,6,1)|(0,0,1))+((0,5,1)|(0,0,1))*AB(2)
        theta(2071) = theta(1492)+theta(1384)*AB(3) ! ((0,5,1)|(0,0,2)) = ((0,5,2)|(0,0,1))+((0,5,1)|(0,0,1))*AB(3)
        theta(2072) = theta(1469)+theta(1385)*AB(1) ! ((0,4,2)|(2,0,0)) = ((1,4,2)|(1,0,0))+((0,4,2)|(1,0,0))*AB(1)
        ! theta(2073) = theta(1470)+theta(1386)*AB(1) ! ((0,4,2)|(1,1,0)) = ((1,4,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(1)
        ! theta(2074) = theta(1471)+theta(1387)*AB(1) ! ((0,4,2)|(1,0,1)) = ((1,4,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(1)
        theta(2075) = theta(1491)+theta(1386)*AB(2) ! ((0,4,2)|(0,2,0)) = ((0,5,2)|(0,1,0))+((0,4,2)|(0,1,0))*AB(2)
        ! theta(2076) = theta(1492)+theta(1387)*AB(2) ! ((0,4,2)|(0,1,1)) = ((0,5,2)|(0,0,1))+((0,4,2)|(0,0,1))*AB(2)
        theta(2077) = theta(1495)+theta(1387)*AB(3) ! ((0,4,2)|(0,0,2)) = ((0,4,3)|(0,0,1))+((0,4,2)|(0,0,1))*AB(3)
        theta(2078) = theta(1472)+theta(1388)*AB(1) ! ((0,3,3)|(2,0,0)) = ((1,3,3)|(1,0,0))+((0,3,3)|(1,0,0))*AB(1)
        ! theta(2079) = theta(1473)+theta(1389)*AB(1) ! ((0,3,3)|(1,1,0)) = ((1,3,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(1)
        ! theta(2080) = theta(1474)+theta(1390)*AB(1) ! ((0,3,3)|(1,0,1)) = ((1,3,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(1)
        theta(2081) = theta(1494)+theta(1389)*AB(2) ! ((0,3,3)|(0,2,0)) = ((0,4,3)|(0,1,0))+((0,3,3)|(0,1,0))*AB(2)
        ! theta(2082) = theta(1495)+theta(1390)*AB(2) ! ((0,3,3)|(0,1,1)) = ((0,4,3)|(0,0,1))+((0,3,3)|(0,0,1))*AB(2)
        theta(2083) = theta(1498)+theta(1390)*AB(3) ! ((0,3,3)|(0,0,2)) = ((0,3,4)|(0,0,1))+((0,3,3)|(0,0,1))*AB(3)
        theta(2084) = theta(1475)+theta(1391)*AB(1) ! ((0,2,4)|(2,0,0)) = ((1,2,4)|(1,0,0))+((0,2,4)|(1,0,0))*AB(1)
        ! theta(2085) = theta(1476)+theta(1392)*AB(1) ! ((0,2,4)|(1,1,0)) = ((1,2,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(1)
        ! theta(2086) = theta(1477)+theta(1393)*AB(1) ! ((0,2,4)|(1,0,1)) = ((1,2,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(1)
        theta(2087) = theta(1497)+theta(1392)*AB(2) ! ((0,2,4)|(0,2,0)) = ((0,3,4)|(0,1,0))+((0,2,4)|(0,1,0))*AB(2)
        ! theta(2088) = theta(1498)+theta(1393)*AB(2) ! ((0,2,4)|(0,1,1)) = ((0,3,4)|(0,0,1))+((0,2,4)|(0,0,1))*AB(2)
        theta(2089) = theta(1501)+theta(1393)*AB(3) ! ((0,2,4)|(0,0,2)) = ((0,2,5)|(0,0,1))+((0,2,4)|(0,0,1))*AB(3)
        theta(2090) = theta(1478)+theta(1394)*AB(1) ! ((0,1,5)|(2,0,0)) = ((1,1,5)|(1,0,0))+((0,1,5)|(1,0,0))*AB(1)
        ! theta(2091) = theta(1479)+theta(1395)*AB(1) ! ((0,1,5)|(1,1,0)) = ((1,1,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(1)
        ! theta(2092) = theta(1480)+theta(1396)*AB(1) ! ((0,1,5)|(1,0,1)) = ((1,1,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(1)
        theta(2093) = theta(1500)+theta(1395)*AB(2) ! ((0,1,5)|(0,2,0)) = ((0,2,5)|(0,1,0))+((0,1,5)|(0,1,0))*AB(2)
        ! theta(2094) = theta(1501)+theta(1396)*AB(2) ! ((0,1,5)|(0,1,1)) = ((0,2,5)|(0,0,1))+((0,1,5)|(0,0,1))*AB(2)
        theta(2095) = theta(1504)+theta(1396)*AB(3) ! ((0,1,5)|(0,0,2)) = ((0,1,6)|(0,0,1))+((0,1,5)|(0,0,1))*AB(3)
        theta(2096) = theta(1481)+theta(1397)*AB(1) ! ((0,0,6)|(2,0,0)) = ((1,0,6)|(1,0,0))+((0,0,6)|(1,0,0))*AB(1)
        ! theta(2097) = theta(1482)+theta(1398)*AB(1) ! ((0,0,6)|(1,1,0)) = ((1,0,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(1)
        ! theta(2098) = theta(1483)+theta(1399)*AB(1) ! ((0,0,6)|(1,0,1)) = ((1,0,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(1)
        theta(2099) = theta(1503)+theta(1398)*AB(2) ! ((0,0,6)|(0,2,0)) = ((0,1,6)|(0,1,0))+((0,0,6)|(0,1,0))*AB(2)
        ! theta(2100) = theta(1504)+theta(1399)*AB(2) ! ((0,0,6)|(0,1,1)) = ((0,1,6)|(0,0,1))+((0,0,6)|(0,0,1))*AB(2)
        theta(2101) = theta(1507)+theta(1399)*AB(3) ! ((0,0,6)|(0,0,2)) = ((0,0,7)|(0,0,1))+((0,0,6)|(0,0,1))*AB(3)
        theta(2102) = theta(1508)+theta(1400)*AB(1) ! ((7,0,0)|(2,0,0)) = ((8,0,0)|(1,0,0))+((7,0,0)|(1,0,0))*AB(1)
        ! theta(2103) = theta(1509)+theta(1401)*AB(1) ! ((7,0,0)|(1,1,0)) = ((8,0,0)|(0,1,0))+((7,0,0)|(0,1,0))*AB(1)
        ! theta(2104) = theta(1510)+theta(1402)*AB(1) ! ((7,0,0)|(1,0,1)) = ((8,0,0)|(0,0,1))+((7,0,0)|(0,0,1))*AB(1)
        theta(2105) = theta(1512)+theta(1401)*AB(2) ! ((7,0,0)|(0,2,0)) = ((7,1,0)|(0,1,0))+((7,0,0)|(0,1,0))*AB(2)
        ! theta(2106) = theta(1513)+theta(1402)*AB(2) ! ((7,0,0)|(0,1,1)) = ((7,1,0)|(0,0,1))+((7,0,0)|(0,0,1))*AB(2)
        theta(2107) = theta(1516)+theta(1402)*AB(3) ! ((7,0,0)|(0,0,2)) = ((7,0,1)|(0,0,1))+((7,0,0)|(0,0,1))*AB(3)
        theta(2108) = theta(1511)+theta(1403)*AB(1) ! ((6,1,0)|(2,0,0)) = ((7,1,0)|(1,0,0))+((6,1,0)|(1,0,0))*AB(1)
        ! theta(2109) = theta(1512)+theta(1404)*AB(1) ! ((6,1,0)|(1,1,0)) = ((7,1,0)|(0,1,0))+((6,1,0)|(0,1,0))*AB(1)
        ! theta(2110) = theta(1513)+theta(1405)*AB(1) ! ((6,1,0)|(1,0,1)) = ((7,1,0)|(0,0,1))+((6,1,0)|(0,0,1))*AB(1)
        theta(2111) = theta(1518)+theta(1404)*AB(2) ! ((6,1,0)|(0,2,0)) = ((6,2,0)|(0,1,0))+((6,1,0)|(0,1,0))*AB(2)
        ! theta(2112) = theta(1519)+theta(1405)*AB(2) ! ((6,1,0)|(0,1,1)) = ((6,2,0)|(0,0,1))+((6,1,0)|(0,0,1))*AB(2)
        theta(2113) = theta(1522)+theta(1405)*AB(3) ! ((6,1,0)|(0,0,2)) = ((6,1,1)|(0,0,1))+((6,1,0)|(0,0,1))*AB(3)
        theta(2114) = theta(1514)+theta(1406)*AB(1) ! ((6,0,1)|(2,0,0)) = ((7,0,1)|(1,0,0))+((6,0,1)|(1,0,0))*AB(1)
        theta(2115) = theta(1515)+theta(1407)*AB(1) ! ((6,0,1)|(1,1,0)) = ((7,0,1)|(0,1,0))+((6,0,1)|(0,1,0))*AB(1)
        ! theta(2116) = theta(1516)+theta(1408)*AB(1) ! ((6,0,1)|(1,0,1)) = ((7,0,1)|(0,0,1))+((6,0,1)|(0,0,1))*AB(1)
        theta(2117) = theta(1521)+theta(1407)*AB(2) ! ((6,0,1)|(0,2,0)) = ((6,1,1)|(0,1,0))+((6,0,1)|(0,1,0))*AB(2)
        theta(2118) = theta(1522)+theta(1408)*AB(2) ! ((6,0,1)|(0,1,1)) = ((6,1,1)|(0,0,1))+((6,0,1)|(0,0,1))*AB(2)
        theta(2119) = theta(1525)+theta(1408)*AB(3) ! ((6,0,1)|(0,0,2)) = ((6,0,2)|(0,0,1))+((6,0,1)|(0,0,1))*AB(3)
        theta(2120) = theta(1517)+theta(1409)*AB(1) ! ((5,2,0)|(2,0,0)) = ((6,2,0)|(1,0,0))+((5,2,0)|(1,0,0))*AB(1)
        ! theta(2121) = theta(1518)+theta(1410)*AB(1) ! ((5,2,0)|(1,1,0)) = ((6,2,0)|(0,1,0))+((5,2,0)|(0,1,0))*AB(1)
        ! theta(2122) = theta(1519)+theta(1411)*AB(1) ! ((5,2,0)|(1,0,1)) = ((6,2,0)|(0,0,1))+((5,2,0)|(0,0,1))*AB(1)
        theta(2123) = theta(1527)+theta(1410)*AB(2) ! ((5,2,0)|(0,2,0)) = ((5,3,0)|(0,1,0))+((5,2,0)|(0,1,0))*AB(2)
        ! theta(2124) = theta(1528)+theta(1411)*AB(2) ! ((5,2,0)|(0,1,1)) = ((5,3,0)|(0,0,1))+((5,2,0)|(0,0,1))*AB(2)
        theta(2125) = theta(1531)+theta(1411)*AB(3) ! ((5,2,0)|(0,0,2)) = ((5,2,1)|(0,0,1))+((5,2,0)|(0,0,1))*AB(3)
        theta(2126) = theta(1520)+theta(1412)*AB(1) ! ((5,1,1)|(2,0,0)) = ((6,1,1)|(1,0,0))+((5,1,1)|(1,0,0))*AB(1)
        theta(2127) = theta(1521)+theta(1413)*AB(1) ! ((5,1,1)|(1,1,0)) = ((6,1,1)|(0,1,0))+((5,1,1)|(0,1,0))*AB(1)
        ! theta(2128) = theta(1522)+theta(1414)*AB(1) ! ((5,1,1)|(1,0,1)) = ((6,1,1)|(0,0,1))+((5,1,1)|(0,0,1))*AB(1)
        theta(2129) = theta(1530)+theta(1413)*AB(2) ! ((5,1,1)|(0,2,0)) = ((5,2,1)|(0,1,0))+((5,1,1)|(0,1,0))*AB(2)
        theta(2130) = theta(1531)+theta(1414)*AB(2) ! ((5,1,1)|(0,1,1)) = ((5,2,1)|(0,0,1))+((5,1,1)|(0,0,1))*AB(2)
        theta(2131) = theta(1534)+theta(1414)*AB(3) ! ((5,1,1)|(0,0,2)) = ((5,1,2)|(0,0,1))+((5,1,1)|(0,0,1))*AB(3)
        theta(2132) = theta(1523)+theta(1415)*AB(1) ! ((5,0,2)|(2,0,0)) = ((6,0,2)|(1,0,0))+((5,0,2)|(1,0,0))*AB(1)
        theta(2133) = theta(1524)+theta(1416)*AB(1) ! ((5,0,2)|(1,1,0)) = ((6,0,2)|(0,1,0))+((5,0,2)|(0,1,0))*AB(1)
        ! theta(2134) = theta(1525)+theta(1417)*AB(1) ! ((5,0,2)|(1,0,1)) = ((6,0,2)|(0,0,1))+((5,0,2)|(0,0,1))*AB(1)
        theta(2135) = theta(1533)+theta(1416)*AB(2) ! ((5,0,2)|(0,2,0)) = ((5,1,2)|(0,1,0))+((5,0,2)|(0,1,0))*AB(2)
        theta(2136) = theta(1534)+theta(1417)*AB(2) ! ((5,0,2)|(0,1,1)) = ((5,1,2)|(0,0,1))+((5,0,2)|(0,0,1))*AB(2)
        theta(2137) = theta(1537)+theta(1417)*AB(3) ! ((5,0,2)|(0,0,2)) = ((5,0,3)|(0,0,1))+((5,0,2)|(0,0,1))*AB(3)
        theta(2138) = theta(1526)+theta(1418)*AB(1) ! ((4,3,0)|(2,0,0)) = ((5,3,0)|(1,0,0))+((4,3,0)|(1,0,0))*AB(1)
        ! theta(2139) = theta(1527)+theta(1419)*AB(1) ! ((4,3,0)|(1,1,0)) = ((5,3,0)|(0,1,0))+((4,3,0)|(0,1,0))*AB(1)
        ! theta(2140) = theta(1528)+theta(1420)*AB(1) ! ((4,3,0)|(1,0,1)) = ((5,3,0)|(0,0,1))+((4,3,0)|(0,0,1))*AB(1)
        theta(2141) = theta(1539)+theta(1419)*AB(2) ! ((4,3,0)|(0,2,0)) = ((4,4,0)|(0,1,0))+((4,3,0)|(0,1,0))*AB(2)
        ! theta(2142) = theta(1540)+theta(1420)*AB(2) ! ((4,3,0)|(0,1,1)) = ((4,4,0)|(0,0,1))+((4,3,0)|(0,0,1))*AB(2)
        theta(2143) = theta(1543)+theta(1420)*AB(3) ! ((4,3,0)|(0,0,2)) = ((4,3,1)|(0,0,1))+((4,3,0)|(0,0,1))*AB(3)
        theta(2144) = theta(1529)+theta(1421)*AB(1) ! ((4,2,1)|(2,0,0)) = ((5,2,1)|(1,0,0))+((4,2,1)|(1,0,0))*AB(1)
        theta(2145) = theta(1530)+theta(1422)*AB(1) ! ((4,2,1)|(1,1,0)) = ((5,2,1)|(0,1,0))+((4,2,1)|(0,1,0))*AB(1)
        ! theta(2146) = theta(1531)+theta(1423)*AB(1) ! ((4,2,1)|(1,0,1)) = ((5,2,1)|(0,0,1))+((4,2,1)|(0,0,1))*AB(1)
        theta(2147) = theta(1542)+theta(1422)*AB(2) ! ((4,2,1)|(0,2,0)) = ((4,3,1)|(0,1,0))+((4,2,1)|(0,1,0))*AB(2)
        theta(2148) = theta(1543)+theta(1423)*AB(2) ! ((4,2,1)|(0,1,1)) = ((4,3,1)|(0,0,1))+((4,2,1)|(0,0,1))*AB(2)
        theta(2149) = theta(1546)+theta(1423)*AB(3) ! ((4,2,1)|(0,0,2)) = ((4,2,2)|(0,0,1))+((4,2,1)|(0,0,1))*AB(3)
        theta(2150) = theta(1532)+theta(1424)*AB(1) ! ((4,1,2)|(2,0,0)) = ((5,1,2)|(1,0,0))+((4,1,2)|(1,0,0))*AB(1)
        theta(2151) = theta(1533)+theta(1425)*AB(1) ! ((4,1,2)|(1,1,0)) = ((5,1,2)|(0,1,0))+((4,1,2)|(0,1,0))*AB(1)
        ! theta(2152) = theta(1534)+theta(1426)*AB(1) ! ((4,1,2)|(1,0,1)) = ((5,1,2)|(0,0,1))+((4,1,2)|(0,0,1))*AB(1)
        theta(2153) = theta(1545)+theta(1425)*AB(2) ! ((4,1,2)|(0,2,0)) = ((4,2,2)|(0,1,0))+((4,1,2)|(0,1,0))*AB(2)
        theta(2154) = theta(1546)+theta(1426)*AB(2) ! ((4,1,2)|(0,1,1)) = ((4,2,2)|(0,0,1))+((4,1,2)|(0,0,1))*AB(2)
        theta(2155) = theta(1549)+theta(1426)*AB(3) ! ((4,1,2)|(0,0,2)) = ((4,1,3)|(0,0,1))+((4,1,2)|(0,0,1))*AB(3)
        theta(2156) = theta(1535)+theta(1427)*AB(1) ! ((4,0,3)|(2,0,0)) = ((5,0,3)|(1,0,0))+((4,0,3)|(1,0,0))*AB(1)
        theta(2157) = theta(1536)+theta(1428)*AB(1) ! ((4,0,3)|(1,1,0)) = ((5,0,3)|(0,1,0))+((4,0,3)|(0,1,0))*AB(1)
        ! theta(2158) = theta(1537)+theta(1429)*AB(1) ! ((4,0,3)|(1,0,1)) = ((5,0,3)|(0,0,1))+((4,0,3)|(0,0,1))*AB(1)
        theta(2159) = theta(1548)+theta(1428)*AB(2) ! ((4,0,3)|(0,2,0)) = ((4,1,3)|(0,1,0))+((4,0,3)|(0,1,0))*AB(2)
        theta(2160) = theta(1549)+theta(1429)*AB(2) ! ((4,0,3)|(0,1,1)) = ((4,1,3)|(0,0,1))+((4,0,3)|(0,0,1))*AB(2)
        theta(2161) = theta(1552)+theta(1429)*AB(3) ! ((4,0,3)|(0,0,2)) = ((4,0,4)|(0,0,1))+((4,0,3)|(0,0,1))*AB(3)
        theta(2162) = theta(1538)+theta(1430)*AB(1) ! ((3,4,0)|(2,0,0)) = ((4,4,0)|(1,0,0))+((3,4,0)|(1,0,0))*AB(1)
        ! theta(2163) = theta(1539)+theta(1431)*AB(1) ! ((3,4,0)|(1,1,0)) = ((4,4,0)|(0,1,0))+((3,4,0)|(0,1,0))*AB(1)
        ! theta(2164) = theta(1540)+theta(1432)*AB(1) ! ((3,4,0)|(1,0,1)) = ((4,4,0)|(0,0,1))+((3,4,0)|(0,0,1))*AB(1)
        theta(2165) = theta(1554)+theta(1431)*AB(2) ! ((3,4,0)|(0,2,0)) = ((3,5,0)|(0,1,0))+((3,4,0)|(0,1,0))*AB(2)
        ! theta(2166) = theta(1555)+theta(1432)*AB(2) ! ((3,4,0)|(0,1,1)) = ((3,5,0)|(0,0,1))+((3,4,0)|(0,0,1))*AB(2)
        theta(2167) = theta(1558)+theta(1432)*AB(3) ! ((3,4,0)|(0,0,2)) = ((3,4,1)|(0,0,1))+((3,4,0)|(0,0,1))*AB(3)
        theta(2168) = theta(1541)+theta(1433)*AB(1) ! ((3,3,1)|(2,0,0)) = ((4,3,1)|(1,0,0))+((3,3,1)|(1,0,0))*AB(1)
        theta(2169) = theta(1542)+theta(1434)*AB(1) ! ((3,3,1)|(1,1,0)) = ((4,3,1)|(0,1,0))+((3,3,1)|(0,1,0))*AB(1)
        ! theta(2170) = theta(1543)+theta(1435)*AB(1) ! ((3,3,1)|(1,0,1)) = ((4,3,1)|(0,0,1))+((3,3,1)|(0,0,1))*AB(1)
        theta(2171) = theta(1557)+theta(1434)*AB(2) ! ((3,3,1)|(0,2,0)) = ((3,4,1)|(0,1,0))+((3,3,1)|(0,1,0))*AB(2)
        theta(2172) = theta(1558)+theta(1435)*AB(2) ! ((3,3,1)|(0,1,1)) = ((3,4,1)|(0,0,1))+((3,3,1)|(0,0,1))*AB(2)
        theta(2173) = theta(1561)+theta(1435)*AB(3) ! ((3,3,1)|(0,0,2)) = ((3,3,2)|(0,0,1))+((3,3,1)|(0,0,1))*AB(3)
        theta(2174) = theta(1544)+theta(1436)*AB(1) ! ((3,2,2)|(2,0,0)) = ((4,2,2)|(1,0,0))+((3,2,2)|(1,0,0))*AB(1)
        theta(2175) = theta(1545)+theta(1437)*AB(1) ! ((3,2,2)|(1,1,0)) = ((4,2,2)|(0,1,0))+((3,2,2)|(0,1,0))*AB(1)
        ! theta(2176) = theta(1546)+theta(1438)*AB(1) ! ((3,2,2)|(1,0,1)) = ((4,2,2)|(0,0,1))+((3,2,2)|(0,0,1))*AB(1)
        theta(2177) = theta(1560)+theta(1437)*AB(2) ! ((3,2,2)|(0,2,0)) = ((3,3,2)|(0,1,0))+((3,2,2)|(0,1,0))*AB(2)
        theta(2178) = theta(1561)+theta(1438)*AB(2) ! ((3,2,2)|(0,1,1)) = ((3,3,2)|(0,0,1))+((3,2,2)|(0,0,1))*AB(2)
        theta(2179) = theta(1564)+theta(1438)*AB(3) ! ((3,2,2)|(0,0,2)) = ((3,2,3)|(0,0,1))+((3,2,2)|(0,0,1))*AB(3)
        theta(2180) = theta(1547)+theta(1439)*AB(1) ! ((3,1,3)|(2,0,0)) = ((4,1,3)|(1,0,0))+((3,1,3)|(1,0,0))*AB(1)
        theta(2181) = theta(1548)+theta(1440)*AB(1) ! ((3,1,3)|(1,1,0)) = ((4,1,3)|(0,1,0))+((3,1,3)|(0,1,0))*AB(1)
        ! theta(2182) = theta(1549)+theta(1441)*AB(1) ! ((3,1,3)|(1,0,1)) = ((4,1,3)|(0,0,1))+((3,1,3)|(0,0,1))*AB(1)
        theta(2183) = theta(1563)+theta(1440)*AB(2) ! ((3,1,3)|(0,2,0)) = ((3,2,3)|(0,1,0))+((3,1,3)|(0,1,0))*AB(2)
        theta(2184) = theta(1564)+theta(1441)*AB(2) ! ((3,1,3)|(0,1,1)) = ((3,2,3)|(0,0,1))+((3,1,3)|(0,0,1))*AB(2)
        theta(2185) = theta(1567)+theta(1441)*AB(3) ! ((3,1,3)|(0,0,2)) = ((3,1,4)|(0,0,1))+((3,1,3)|(0,0,1))*AB(3)
        theta(2186) = theta(1550)+theta(1442)*AB(1) ! ((3,0,4)|(2,0,0)) = ((4,0,4)|(1,0,0))+((3,0,4)|(1,0,0))*AB(1)
        theta(2187) = theta(1551)+theta(1443)*AB(1) ! ((3,0,4)|(1,1,0)) = ((4,0,4)|(0,1,0))+((3,0,4)|(0,1,0))*AB(1)
        ! theta(2188) = theta(1552)+theta(1444)*AB(1) ! ((3,0,4)|(1,0,1)) = ((4,0,4)|(0,0,1))+((3,0,4)|(0,0,1))*AB(1)
        theta(2189) = theta(1566)+theta(1443)*AB(2) ! ((3,0,4)|(0,2,0)) = ((3,1,4)|(0,1,0))+((3,0,4)|(0,1,0))*AB(2)
        theta(2190) = theta(1567)+theta(1444)*AB(2) ! ((3,0,4)|(0,1,1)) = ((3,1,4)|(0,0,1))+((3,0,4)|(0,0,1))*AB(2)
        theta(2191) = theta(1570)+theta(1444)*AB(3) ! ((3,0,4)|(0,0,2)) = ((3,0,5)|(0,0,1))+((3,0,4)|(0,0,1))*AB(3)
        theta(2192) = theta(1553)+theta(1445)*AB(1) ! ((2,5,0)|(2,0,0)) = ((3,5,0)|(1,0,0))+((2,5,0)|(1,0,0))*AB(1)
        ! theta(2193) = theta(1554)+theta(1446)*AB(1) ! ((2,5,0)|(1,1,0)) = ((3,5,0)|(0,1,0))+((2,5,0)|(0,1,0))*AB(1)
        ! theta(2194) = theta(1555)+theta(1447)*AB(1) ! ((2,5,0)|(1,0,1)) = ((3,5,0)|(0,0,1))+((2,5,0)|(0,0,1))*AB(1)
        theta(2195) = theta(1572)+theta(1446)*AB(2) ! ((2,5,0)|(0,2,0)) = ((2,6,0)|(0,1,0))+((2,5,0)|(0,1,0))*AB(2)
        ! theta(2196) = theta(1573)+theta(1447)*AB(2) ! ((2,5,0)|(0,1,1)) = ((2,6,0)|(0,0,1))+((2,5,0)|(0,0,1))*AB(2)
        theta(2197) = theta(1576)+theta(1447)*AB(3) ! ((2,5,0)|(0,0,2)) = ((2,5,1)|(0,0,1))+((2,5,0)|(0,0,1))*AB(3)
        theta(2198) = theta(1556)+theta(1448)*AB(1) ! ((2,4,1)|(2,0,0)) = ((3,4,1)|(1,0,0))+((2,4,1)|(1,0,0))*AB(1)
        theta(2199) = theta(1557)+theta(1449)*AB(1) ! ((2,4,1)|(1,1,0)) = ((3,4,1)|(0,1,0))+((2,4,1)|(0,1,0))*AB(1)
        ! theta(2200) = theta(1558)+theta(1450)*AB(1) ! ((2,4,1)|(1,0,1)) = ((3,4,1)|(0,0,1))+((2,4,1)|(0,0,1))*AB(1)
        theta(2201) = theta(1575)+theta(1449)*AB(2) ! ((2,4,1)|(0,2,0)) = ((2,5,1)|(0,1,0))+((2,4,1)|(0,1,0))*AB(2)
        theta(2202) = theta(1576)+theta(1450)*AB(2) ! ((2,4,1)|(0,1,1)) = ((2,5,1)|(0,0,1))+((2,4,1)|(0,0,1))*AB(2)
        theta(2203) = theta(1579)+theta(1450)*AB(3) ! ((2,4,1)|(0,0,2)) = ((2,4,2)|(0,0,1))+((2,4,1)|(0,0,1))*AB(3)
        theta(2204) = theta(1559)+theta(1451)*AB(1) ! ((2,3,2)|(2,0,0)) = ((3,3,2)|(1,0,0))+((2,3,2)|(1,0,0))*AB(1)
        theta(2205) = theta(1560)+theta(1452)*AB(1) ! ((2,3,2)|(1,1,0)) = ((3,3,2)|(0,1,0))+((2,3,2)|(0,1,0))*AB(1)
        ! theta(2206) = theta(1561)+theta(1453)*AB(1) ! ((2,3,2)|(1,0,1)) = ((3,3,2)|(0,0,1))+((2,3,2)|(0,0,1))*AB(1)
        theta(2207) = theta(1578)+theta(1452)*AB(2) ! ((2,3,2)|(0,2,0)) = ((2,4,2)|(0,1,0))+((2,3,2)|(0,1,0))*AB(2)
        theta(2208) = theta(1579)+theta(1453)*AB(2) ! ((2,3,2)|(0,1,1)) = ((2,4,2)|(0,0,1))+((2,3,2)|(0,0,1))*AB(2)
        theta(2209) = theta(1582)+theta(1453)*AB(3) ! ((2,3,2)|(0,0,2)) = ((2,3,3)|(0,0,1))+((2,3,2)|(0,0,1))*AB(3)
        theta(2210) = theta(1562)+theta(1454)*AB(1) ! ((2,2,3)|(2,0,0)) = ((3,2,3)|(1,0,0))+((2,2,3)|(1,0,0))*AB(1)
        theta(2211) = theta(1563)+theta(1455)*AB(1) ! ((2,2,3)|(1,1,0)) = ((3,2,3)|(0,1,0))+((2,2,3)|(0,1,0))*AB(1)
        ! theta(2212) = theta(1564)+theta(1456)*AB(1) ! ((2,2,3)|(1,0,1)) = ((3,2,3)|(0,0,1))+((2,2,3)|(0,0,1))*AB(1)
        theta(2213) = theta(1581)+theta(1455)*AB(2) ! ((2,2,3)|(0,2,0)) = ((2,3,3)|(0,1,0))+((2,2,3)|(0,1,0))*AB(2)
        theta(2214) = theta(1582)+theta(1456)*AB(2) ! ((2,2,3)|(0,1,1)) = ((2,3,3)|(0,0,1))+((2,2,3)|(0,0,1))*AB(2)
        theta(2215) = theta(1585)+theta(1456)*AB(3) ! ((2,2,3)|(0,0,2)) = ((2,2,4)|(0,0,1))+((2,2,3)|(0,0,1))*AB(3)
        theta(2216) = theta(1565)+theta(1457)*AB(1) ! ((2,1,4)|(2,0,0)) = ((3,1,4)|(1,0,0))+((2,1,4)|(1,0,0))*AB(1)
        theta(2217) = theta(1566)+theta(1458)*AB(1) ! ((2,1,4)|(1,1,0)) = ((3,1,4)|(0,1,0))+((2,1,4)|(0,1,0))*AB(1)
        ! theta(2218) = theta(1567)+theta(1459)*AB(1) ! ((2,1,4)|(1,0,1)) = ((3,1,4)|(0,0,1))+((2,1,4)|(0,0,1))*AB(1)
        theta(2219) = theta(1584)+theta(1458)*AB(2) ! ((2,1,4)|(0,2,0)) = ((2,2,4)|(0,1,0))+((2,1,4)|(0,1,0))*AB(2)
        theta(2220) = theta(1585)+theta(1459)*AB(2) ! ((2,1,4)|(0,1,1)) = ((2,2,4)|(0,0,1))+((2,1,4)|(0,0,1))*AB(2)
        theta(2221) = theta(1588)+theta(1459)*AB(3) ! ((2,1,4)|(0,0,2)) = ((2,1,5)|(0,0,1))+((2,1,4)|(0,0,1))*AB(3)
        theta(2222) = theta(1568)+theta(1460)*AB(1) ! ((2,0,5)|(2,0,0)) = ((3,0,5)|(1,0,0))+((2,0,5)|(1,0,0))*AB(1)
        theta(2223) = theta(1569)+theta(1461)*AB(1) ! ((2,0,5)|(1,1,0)) = ((3,0,5)|(0,1,0))+((2,0,5)|(0,1,0))*AB(1)
        ! theta(2224) = theta(1570)+theta(1462)*AB(1) ! ((2,0,5)|(1,0,1)) = ((3,0,5)|(0,0,1))+((2,0,5)|(0,0,1))*AB(1)
        theta(2225) = theta(1587)+theta(1461)*AB(2) ! ((2,0,5)|(0,2,0)) = ((2,1,5)|(0,1,0))+((2,0,5)|(0,1,0))*AB(2)
        theta(2226) = theta(1588)+theta(1462)*AB(2) ! ((2,0,5)|(0,1,1)) = ((2,1,5)|(0,0,1))+((2,0,5)|(0,0,1))*AB(2)
        theta(2227) = theta(1591)+theta(1462)*AB(3) ! ((2,0,5)|(0,0,2)) = ((2,0,6)|(0,0,1))+((2,0,5)|(0,0,1))*AB(3)
        theta(2228) = theta(1571)+theta(1463)*AB(1) ! ((1,6,0)|(2,0,0)) = ((2,6,0)|(1,0,0))+((1,6,0)|(1,0,0))*AB(1)
        ! theta(2229) = theta(1572)+theta(1464)*AB(1) ! ((1,6,0)|(1,1,0)) = ((2,6,0)|(0,1,0))+((1,6,0)|(0,1,0))*AB(1)
        ! theta(2230) = theta(1573)+theta(1465)*AB(1) ! ((1,6,0)|(1,0,1)) = ((2,6,0)|(0,0,1))+((1,6,0)|(0,0,1))*AB(1)
        theta(2231) = theta(1593)+theta(1464)*AB(2) ! ((1,6,0)|(0,2,0)) = ((1,7,0)|(0,1,0))+((1,6,0)|(0,1,0))*AB(2)
        ! theta(2232) = theta(1594)+theta(1465)*AB(2) ! ((1,6,0)|(0,1,1)) = ((1,7,0)|(0,0,1))+((1,6,0)|(0,0,1))*AB(2)
        theta(2233) = theta(1597)+theta(1465)*AB(3) ! ((1,6,0)|(0,0,2)) = ((1,6,1)|(0,0,1))+((1,6,0)|(0,0,1))*AB(3)
        theta(2234) = theta(1574)+theta(1466)*AB(1) ! ((1,5,1)|(2,0,0)) = ((2,5,1)|(1,0,0))+((1,5,1)|(1,0,0))*AB(1)
        ! theta(2235) = theta(1575)+theta(1467)*AB(1) ! ((1,5,1)|(1,1,0)) = ((2,5,1)|(0,1,0))+((1,5,1)|(0,1,0))*AB(1)
        ! theta(2236) = theta(1576)+theta(1468)*AB(1) ! ((1,5,1)|(1,0,1)) = ((2,5,1)|(0,0,1))+((1,5,1)|(0,0,1))*AB(1)
        theta(2237) = theta(1596)+theta(1467)*AB(2) ! ((1,5,1)|(0,2,0)) = ((1,6,1)|(0,1,0))+((1,5,1)|(0,1,0))*AB(2)
        ! theta(2238) = theta(1597)+theta(1468)*AB(2) ! ((1,5,1)|(0,1,1)) = ((1,6,1)|(0,0,1))+((1,5,1)|(0,0,1))*AB(2)
        theta(2239) = theta(1600)+theta(1468)*AB(3) ! ((1,5,1)|(0,0,2)) = ((1,5,2)|(0,0,1))+((1,5,1)|(0,0,1))*AB(3)
        theta(2240) = theta(1577)+theta(1469)*AB(1) ! ((1,4,2)|(2,0,0)) = ((2,4,2)|(1,0,0))+((1,4,2)|(1,0,0))*AB(1)
        ! theta(2241) = theta(1578)+theta(1470)*AB(1) ! ((1,4,2)|(1,1,0)) = ((2,4,2)|(0,1,0))+((1,4,2)|(0,1,0))*AB(1)
        ! theta(2242) = theta(1579)+theta(1471)*AB(1) ! ((1,4,2)|(1,0,1)) = ((2,4,2)|(0,0,1))+((1,4,2)|(0,0,1))*AB(1)
        theta(2243) = theta(1599)+theta(1470)*AB(2) ! ((1,4,2)|(0,2,0)) = ((1,5,2)|(0,1,0))+((1,4,2)|(0,1,0))*AB(2)
        ! theta(2244) = theta(1600)+theta(1471)*AB(2) ! ((1,4,2)|(0,1,1)) = ((1,5,2)|(0,0,1))+((1,4,2)|(0,0,1))*AB(2)
        theta(2245) = theta(1603)+theta(1471)*AB(3) ! ((1,4,2)|(0,0,2)) = ((1,4,3)|(0,0,1))+((1,4,2)|(0,0,1))*AB(3)
        theta(2246) = theta(1580)+theta(1472)*AB(1) ! ((1,3,3)|(2,0,0)) = ((2,3,3)|(1,0,0))+((1,3,3)|(1,0,0))*AB(1)
        ! theta(2247) = theta(1581)+theta(1473)*AB(1) ! ((1,3,3)|(1,1,0)) = ((2,3,3)|(0,1,0))+((1,3,3)|(0,1,0))*AB(1)
        ! theta(2248) = theta(1582)+theta(1474)*AB(1) ! ((1,3,3)|(1,0,1)) = ((2,3,3)|(0,0,1))+((1,3,3)|(0,0,1))*AB(1)
        theta(2249) = theta(1602)+theta(1473)*AB(2) ! ((1,3,3)|(0,2,0)) = ((1,4,3)|(0,1,0))+((1,3,3)|(0,1,0))*AB(2)
        ! theta(2250) = theta(1603)+theta(1474)*AB(2) ! ((1,3,3)|(0,1,1)) = ((1,4,3)|(0,0,1))+((1,3,3)|(0,0,1))*AB(2)
        theta(2251) = theta(1606)+theta(1474)*AB(3) ! ((1,3,3)|(0,0,2)) = ((1,3,4)|(0,0,1))+((1,3,3)|(0,0,1))*AB(3)
        theta(2252) = theta(1583)+theta(1475)*AB(1) ! ((1,2,4)|(2,0,0)) = ((2,2,4)|(1,0,0))+((1,2,4)|(1,0,0))*AB(1)
        ! theta(2253) = theta(1584)+theta(1476)*AB(1) ! ((1,2,4)|(1,1,0)) = ((2,2,4)|(0,1,0))+((1,2,4)|(0,1,0))*AB(1)
        ! theta(2254) = theta(1585)+theta(1477)*AB(1) ! ((1,2,4)|(1,0,1)) = ((2,2,4)|(0,0,1))+((1,2,4)|(0,0,1))*AB(1)
        theta(2255) = theta(1605)+theta(1476)*AB(2) ! ((1,2,4)|(0,2,0)) = ((1,3,4)|(0,1,0))+((1,2,4)|(0,1,0))*AB(2)
        ! theta(2256) = theta(1606)+theta(1477)*AB(2) ! ((1,2,4)|(0,1,1)) = ((1,3,4)|(0,0,1))+((1,2,4)|(0,0,1))*AB(2)
        theta(2257) = theta(1609)+theta(1477)*AB(3) ! ((1,2,4)|(0,0,2)) = ((1,2,5)|(0,0,1))+((1,2,4)|(0,0,1))*AB(3)
        theta(2258) = theta(1586)+theta(1478)*AB(1) ! ((1,1,5)|(2,0,0)) = ((2,1,5)|(1,0,0))+((1,1,5)|(1,0,0))*AB(1)
        ! theta(2259) = theta(1587)+theta(1479)*AB(1) ! ((1,1,5)|(1,1,0)) = ((2,1,5)|(0,1,0))+((1,1,5)|(0,1,0))*AB(1)
        ! theta(2260) = theta(1588)+theta(1480)*AB(1) ! ((1,1,5)|(1,0,1)) = ((2,1,5)|(0,0,1))+((1,1,5)|(0,0,1))*AB(1)
        theta(2261) = theta(1608)+theta(1479)*AB(2) ! ((1,1,5)|(0,2,0)) = ((1,2,5)|(0,1,0))+((1,1,5)|(0,1,0))*AB(2)
        ! theta(2262) = theta(1609)+theta(1480)*AB(2) ! ((1,1,5)|(0,1,1)) = ((1,2,5)|(0,0,1))+((1,1,5)|(0,0,1))*AB(2)
        theta(2263) = theta(1612)+theta(1480)*AB(3) ! ((1,1,5)|(0,0,2)) = ((1,1,6)|(0,0,1))+((1,1,5)|(0,0,1))*AB(3)
        theta(2264) = theta(1589)+theta(1481)*AB(1) ! ((1,0,6)|(2,0,0)) = ((2,0,6)|(1,0,0))+((1,0,6)|(1,0,0))*AB(1)
        ! theta(2265) = theta(1590)+theta(1482)*AB(1) ! ((1,0,6)|(1,1,0)) = ((2,0,6)|(0,1,0))+((1,0,6)|(0,1,0))*AB(1)
        ! theta(2266) = theta(1591)+theta(1483)*AB(1) ! ((1,0,6)|(1,0,1)) = ((2,0,6)|(0,0,1))+((1,0,6)|(0,0,1))*AB(1)
        theta(2267) = theta(1611)+theta(1482)*AB(2) ! ((1,0,6)|(0,2,0)) = ((1,1,6)|(0,1,0))+((1,0,6)|(0,1,0))*AB(2)
        ! theta(2268) = theta(1612)+theta(1483)*AB(2) ! ((1,0,6)|(0,1,1)) = ((1,1,6)|(0,0,1))+((1,0,6)|(0,0,1))*AB(2)
        theta(2269) = theta(1615)+theta(1483)*AB(3) ! ((1,0,6)|(0,0,2)) = ((1,0,7)|(0,0,1))+((1,0,6)|(0,0,1))*AB(3)
        theta(2270) = theta(1592)+theta(1484)*AB(1) ! ((0,7,0)|(2,0,0)) = ((1,7,0)|(1,0,0))+((0,7,0)|(1,0,0))*AB(1)
        ! theta(2271) = theta(1593)+theta(1485)*AB(1) ! ((0,7,0)|(1,1,0)) = ((1,7,0)|(0,1,0))+((0,7,0)|(0,1,0))*AB(1)
        ! theta(2272) = theta(1594)+theta(1486)*AB(1) ! ((0,7,0)|(1,0,1)) = ((1,7,0)|(0,0,1))+((0,7,0)|(0,0,1))*AB(1)
        theta(2273) = theta(1617)+theta(1485)*AB(2) ! ((0,7,0)|(0,2,0)) = ((0,8,0)|(0,1,0))+((0,7,0)|(0,1,0))*AB(2)
        ! theta(2274) = theta(1618)+theta(1486)*AB(2) ! ((0,7,0)|(0,1,1)) = ((0,8,0)|(0,0,1))+((0,7,0)|(0,0,1))*AB(2)
        theta(2275) = theta(1621)+theta(1486)*AB(3) ! ((0,7,0)|(0,0,2)) = ((0,7,1)|(0,0,1))+((0,7,0)|(0,0,1))*AB(3)
        theta(2276) = theta(1595)+theta(1487)*AB(1) ! ((0,6,1)|(2,0,0)) = ((1,6,1)|(1,0,0))+((0,6,1)|(1,0,0))*AB(1)
        ! theta(2277) = theta(1596)+theta(1488)*AB(1) ! ((0,6,1)|(1,1,0)) = ((1,6,1)|(0,1,0))+((0,6,1)|(0,1,0))*AB(1)
        ! theta(2278) = theta(1597)+theta(1489)*AB(1) ! ((0,6,1)|(1,0,1)) = ((1,6,1)|(0,0,1))+((0,6,1)|(0,0,1))*AB(1)
        theta(2279) = theta(1620)+theta(1488)*AB(2) ! ((0,6,1)|(0,2,0)) = ((0,7,1)|(0,1,0))+((0,6,1)|(0,1,0))*AB(2)
        ! theta(2280) = theta(1621)+theta(1489)*AB(2) ! ((0,6,1)|(0,1,1)) = ((0,7,1)|(0,0,1))+((0,6,1)|(0,0,1))*AB(2)
        theta(2281) = theta(1624)+theta(1489)*AB(3) ! ((0,6,1)|(0,0,2)) = ((0,6,2)|(0,0,1))+((0,6,1)|(0,0,1))*AB(3)
        theta(2282) = theta(1598)+theta(1490)*AB(1) ! ((0,5,2)|(2,0,0)) = ((1,5,2)|(1,0,0))+((0,5,2)|(1,0,0))*AB(1)
        ! theta(2283) = theta(1599)+theta(1491)*AB(1) ! ((0,5,2)|(1,1,0)) = ((1,5,2)|(0,1,0))+((0,5,2)|(0,1,0))*AB(1)
        ! theta(2284) = theta(1600)+theta(1492)*AB(1) ! ((0,5,2)|(1,0,1)) = ((1,5,2)|(0,0,1))+((0,5,2)|(0,0,1))*AB(1)
        theta(2285) = theta(1623)+theta(1491)*AB(2) ! ((0,5,2)|(0,2,0)) = ((0,6,2)|(0,1,0))+((0,5,2)|(0,1,0))*AB(2)
        ! theta(2286) = theta(1624)+theta(1492)*AB(2) ! ((0,5,2)|(0,1,1)) = ((0,6,2)|(0,0,1))+((0,5,2)|(0,0,1))*AB(2)
        theta(2287) = theta(1627)+theta(1492)*AB(3) ! ((0,5,2)|(0,0,2)) = ((0,5,3)|(0,0,1))+((0,5,2)|(0,0,1))*AB(3)
        theta(2288) = theta(1601)+theta(1493)*AB(1) ! ((0,4,3)|(2,0,0)) = ((1,4,3)|(1,0,0))+((0,4,3)|(1,0,0))*AB(1)
        ! theta(2289) = theta(1602)+theta(1494)*AB(1) ! ((0,4,3)|(1,1,0)) = ((1,4,3)|(0,1,0))+((0,4,3)|(0,1,0))*AB(1)
        ! theta(2290) = theta(1603)+theta(1495)*AB(1) ! ((0,4,3)|(1,0,1)) = ((1,4,3)|(0,0,1))+((0,4,3)|(0,0,1))*AB(1)
        theta(2291) = theta(1626)+theta(1494)*AB(2) ! ((0,4,3)|(0,2,0)) = ((0,5,3)|(0,1,0))+((0,4,3)|(0,1,0))*AB(2)
        ! theta(2292) = theta(1627)+theta(1495)*AB(2) ! ((0,4,3)|(0,1,1)) = ((0,5,3)|(0,0,1))+((0,4,3)|(0,0,1))*AB(2)
        theta(2293) = theta(1630)+theta(1495)*AB(3) ! ((0,4,3)|(0,0,2)) = ((0,4,4)|(0,0,1))+((0,4,3)|(0,0,1))*AB(3)
        theta(2294) = theta(1604)+theta(1496)*AB(1) ! ((0,3,4)|(2,0,0)) = ((1,3,4)|(1,0,0))+((0,3,4)|(1,0,0))*AB(1)
        ! theta(2295) = theta(1605)+theta(1497)*AB(1) ! ((0,3,4)|(1,1,0)) = ((1,3,4)|(0,1,0))+((0,3,4)|(0,1,0))*AB(1)
        ! theta(2296) = theta(1606)+theta(1498)*AB(1) ! ((0,3,4)|(1,0,1)) = ((1,3,4)|(0,0,1))+((0,3,4)|(0,0,1))*AB(1)
        theta(2297) = theta(1629)+theta(1497)*AB(2) ! ((0,3,4)|(0,2,0)) = ((0,4,4)|(0,1,0))+((0,3,4)|(0,1,0))*AB(2)
        ! theta(2298) = theta(1630)+theta(1498)*AB(2) ! ((0,3,4)|(0,1,1)) = ((0,4,4)|(0,0,1))+((0,3,4)|(0,0,1))*AB(2)
        theta(2299) = theta(1633)+theta(1498)*AB(3) ! ((0,3,4)|(0,0,2)) = ((0,3,5)|(0,0,1))+((0,3,4)|(0,0,1))*AB(3)
        theta(2300) = theta(1607)+theta(1499)*AB(1) ! ((0,2,5)|(2,0,0)) = ((1,2,5)|(1,0,0))+((0,2,5)|(1,0,0))*AB(1)
        ! theta(2301) = theta(1608)+theta(1500)*AB(1) ! ((0,2,5)|(1,1,0)) = ((1,2,5)|(0,1,0))+((0,2,5)|(0,1,0))*AB(1)
        ! theta(2302) = theta(1609)+theta(1501)*AB(1) ! ((0,2,5)|(1,0,1)) = ((1,2,5)|(0,0,1))+((0,2,5)|(0,0,1))*AB(1)
        theta(2303) = theta(1632)+theta(1500)*AB(2) ! ((0,2,5)|(0,2,0)) = ((0,3,5)|(0,1,0))+((0,2,5)|(0,1,0))*AB(2)
        ! theta(2304) = theta(1633)+theta(1501)*AB(2) ! ((0,2,5)|(0,1,1)) = ((0,3,5)|(0,0,1))+((0,2,5)|(0,0,1))*AB(2)
        theta(2305) = theta(1636)+theta(1501)*AB(3) ! ((0,2,5)|(0,0,2)) = ((0,2,6)|(0,0,1))+((0,2,5)|(0,0,1))*AB(3)
        theta(2306) = theta(1610)+theta(1502)*AB(1) ! ((0,1,6)|(2,0,0)) = ((1,1,6)|(1,0,0))+((0,1,6)|(1,0,0))*AB(1)
        ! theta(2307) = theta(1611)+theta(1503)*AB(1) ! ((0,1,6)|(1,1,0)) = ((1,1,6)|(0,1,0))+((0,1,6)|(0,1,0))*AB(1)
        ! theta(2308) = theta(1612)+theta(1504)*AB(1) ! ((0,1,6)|(1,0,1)) = ((1,1,6)|(0,0,1))+((0,1,6)|(0,0,1))*AB(1)
        theta(2309) = theta(1635)+theta(1503)*AB(2) ! ((0,1,6)|(0,2,0)) = ((0,2,6)|(0,1,0))+((0,1,6)|(0,1,0))*AB(2)
        ! theta(2310) = theta(1636)+theta(1504)*AB(2) ! ((0,1,6)|(0,1,1)) = ((0,2,6)|(0,0,1))+((0,1,6)|(0,0,1))*AB(2)
        theta(2311) = theta(1639)+theta(1504)*AB(3) ! ((0,1,6)|(0,0,2)) = ((0,1,7)|(0,0,1))+((0,1,6)|(0,0,1))*AB(3)
        theta(2312) = theta(1613)+theta(1505)*AB(1) ! ((0,0,7)|(2,0,0)) = ((1,0,7)|(1,0,0))+((0,0,7)|(1,0,0))*AB(1)
        ! theta(2313) = theta(1614)+theta(1506)*AB(1) ! ((0,0,7)|(1,1,0)) = ((1,0,7)|(0,1,0))+((0,0,7)|(0,1,0))*AB(1)
        ! theta(2314) = theta(1615)+theta(1507)*AB(1) ! ((0,0,7)|(1,0,1)) = ((1,0,7)|(0,0,1))+((0,0,7)|(0,0,1))*AB(1)
        theta(2315) = theta(1638)+theta(1506)*AB(2) ! ((0,0,7)|(0,2,0)) = ((0,1,7)|(0,1,0))+((0,0,7)|(0,1,0))*AB(2)
        ! theta(2316) = theta(1639)+theta(1507)*AB(2) ! ((0,0,7)|(0,1,1)) = ((0,1,7)|(0,0,1))+((0,0,7)|(0,0,1))*AB(2)
        theta(2317) = theta(1642)+theta(1507)*AB(3) ! ((0,0,7)|(0,0,2)) = ((0,0,8)|(0,0,1))+((0,0,7)|(0,0,1))*AB(3)
        theta(2318) = theta(1643)+theta(1508)*AB(1) ! ((8,0,0)|(2,0,0)) = ((9,0,0)|(1,0,0))+((8,0,0)|(1,0,0))*AB(1)
        ! theta(2319) = theta(1644)+theta(1509)*AB(1) ! ((8,0,0)|(1,1,0)) = ((9,0,0)|(0,1,0))+((8,0,0)|(0,1,0))*AB(1)
        ! theta(2320) = theta(1645)+theta(1510)*AB(1) ! ((8,0,0)|(1,0,1)) = ((9,0,0)|(0,0,1))+((8,0,0)|(0,0,1))*AB(1)
        ! theta(2321) = theta(1647)+theta(1509)*AB(2) ! ((8,0,0)|(0,2,0)) = ((8,1,0)|(0,1,0))+((8,0,0)|(0,1,0))*AB(2)
        ! theta(2322) = theta(1648)+theta(1510)*AB(2) ! ((8,0,0)|(0,1,1)) = ((8,1,0)|(0,0,1))+((8,0,0)|(0,0,1))*AB(2)
        ! theta(2323) = theta(1651)+theta(1510)*AB(3) ! ((8,0,0)|(0,0,2)) = ((8,0,1)|(0,0,1))+((8,0,0)|(0,0,1))*AB(3)
        theta(2324) = theta(1646)+theta(1511)*AB(1) ! ((7,1,0)|(2,0,0)) = ((8,1,0)|(1,0,0))+((7,1,0)|(1,0,0))*AB(1)
        ! theta(2325) = theta(1647)+theta(1512)*AB(1) ! ((7,1,0)|(1,1,0)) = ((8,1,0)|(0,1,0))+((7,1,0)|(0,1,0))*AB(1)
        ! theta(2326) = theta(1648)+theta(1513)*AB(1) ! ((7,1,0)|(1,0,1)) = ((8,1,0)|(0,0,1))+((7,1,0)|(0,0,1))*AB(1)
        theta(2327) = theta(1653)+theta(1512)*AB(2) ! ((7,1,0)|(0,2,0)) = ((7,2,0)|(0,1,0))+((7,1,0)|(0,1,0))*AB(2)
        ! theta(2328) = theta(1654)+theta(1513)*AB(2) ! ((7,1,0)|(0,1,1)) = ((7,2,0)|(0,0,1))+((7,1,0)|(0,0,1))*AB(2)
        theta(2329) = theta(1657)+theta(1513)*AB(3) ! ((7,1,0)|(0,0,2)) = ((7,1,1)|(0,0,1))+((7,1,0)|(0,0,1))*AB(3)
        theta(2330) = theta(1649)+theta(1514)*AB(1) ! ((7,0,1)|(2,0,0)) = ((8,0,1)|(1,0,0))+((7,0,1)|(1,0,0))*AB(1)
        theta(2331) = theta(1650)+theta(1515)*AB(1) ! ((7,0,1)|(1,1,0)) = ((8,0,1)|(0,1,0))+((7,0,1)|(0,1,0))*AB(1)
        ! theta(2332) = theta(1651)+theta(1516)*AB(1) ! ((7,0,1)|(1,0,1)) = ((8,0,1)|(0,0,1))+((7,0,1)|(0,0,1))*AB(1)
        theta(2333) = theta(1656)+theta(1515)*AB(2) ! ((7,0,1)|(0,2,0)) = ((7,1,1)|(0,1,0))+((7,0,1)|(0,1,0))*AB(2)
        theta(2334) = theta(1657)+theta(1516)*AB(2) ! ((7,0,1)|(0,1,1)) = ((7,1,1)|(0,0,1))+((7,0,1)|(0,0,1))*AB(2)
        theta(2335) = theta(1660)+theta(1516)*AB(3) ! ((7,0,1)|(0,0,2)) = ((7,0,2)|(0,0,1))+((7,0,1)|(0,0,1))*AB(3)
        theta(2336) = theta(1652)+theta(1517)*AB(1) ! ((6,2,0)|(2,0,0)) = ((7,2,0)|(1,0,0))+((6,2,0)|(1,0,0))*AB(1)
        ! theta(2337) = theta(1653)+theta(1518)*AB(1) ! ((6,2,0)|(1,1,0)) = ((7,2,0)|(0,1,0))+((6,2,0)|(0,1,0))*AB(1)
        ! theta(2338) = theta(1654)+theta(1519)*AB(1) ! ((6,2,0)|(1,0,1)) = ((7,2,0)|(0,0,1))+((6,2,0)|(0,0,1))*AB(1)
        theta(2339) = theta(1662)+theta(1518)*AB(2) ! ((6,2,0)|(0,2,0)) = ((6,3,0)|(0,1,0))+((6,2,0)|(0,1,0))*AB(2)
        ! theta(2340) = theta(1663)+theta(1519)*AB(2) ! ((6,2,0)|(0,1,1)) = ((6,3,0)|(0,0,1))+((6,2,0)|(0,0,1))*AB(2)
        theta(2341) = theta(1666)+theta(1519)*AB(3) ! ((6,2,0)|(0,0,2)) = ((6,2,1)|(0,0,1))+((6,2,0)|(0,0,1))*AB(3)
        theta(2342) = theta(1655)+theta(1520)*AB(1) ! ((6,1,1)|(2,0,0)) = ((7,1,1)|(1,0,0))+((6,1,1)|(1,0,0))*AB(1)
        theta(2343) = theta(1656)+theta(1521)*AB(1) ! ((6,1,1)|(1,1,0)) = ((7,1,1)|(0,1,0))+((6,1,1)|(0,1,0))*AB(1)
        ! theta(2344) = theta(1657)+theta(1522)*AB(1) ! ((6,1,1)|(1,0,1)) = ((7,1,1)|(0,0,1))+((6,1,1)|(0,0,1))*AB(1)
        theta(2345) = theta(1665)+theta(1521)*AB(2) ! ((6,1,1)|(0,2,0)) = ((6,2,1)|(0,1,0))+((6,1,1)|(0,1,0))*AB(2)
        theta(2346) = theta(1666)+theta(1522)*AB(2) ! ((6,1,1)|(0,1,1)) = ((6,2,1)|(0,0,1))+((6,1,1)|(0,0,1))*AB(2)
        theta(2347) = theta(1669)+theta(1522)*AB(3) ! ((6,1,1)|(0,0,2)) = ((6,1,2)|(0,0,1))+((6,1,1)|(0,0,1))*AB(3)
        theta(2348) = theta(1658)+theta(1523)*AB(1) ! ((6,0,2)|(2,0,0)) = ((7,0,2)|(1,0,0))+((6,0,2)|(1,0,0))*AB(1)
        theta(2349) = theta(1659)+theta(1524)*AB(1) ! ((6,0,2)|(1,1,0)) = ((7,0,2)|(0,1,0))+((6,0,2)|(0,1,0))*AB(1)
        ! theta(2350) = theta(1660)+theta(1525)*AB(1) ! ((6,0,2)|(1,0,1)) = ((7,0,2)|(0,0,1))+((6,0,2)|(0,0,1))*AB(1)
        theta(2351) = theta(1668)+theta(1524)*AB(2) ! ((6,0,2)|(0,2,0)) = ((6,1,2)|(0,1,0))+((6,0,2)|(0,1,0))*AB(2)
        theta(2352) = theta(1669)+theta(1525)*AB(2) ! ((6,0,2)|(0,1,1)) = ((6,1,2)|(0,0,1))+((6,0,2)|(0,0,1))*AB(2)
        theta(2353) = theta(1672)+theta(1525)*AB(3) ! ((6,0,2)|(0,0,2)) = ((6,0,3)|(0,0,1))+((6,0,2)|(0,0,1))*AB(3)
        theta(2354) = theta(1661)+theta(1526)*AB(1) ! ((5,3,0)|(2,0,0)) = ((6,3,0)|(1,0,0))+((5,3,0)|(1,0,0))*AB(1)
        ! theta(2355) = theta(1662)+theta(1527)*AB(1) ! ((5,3,0)|(1,1,0)) = ((6,3,0)|(0,1,0))+((5,3,0)|(0,1,0))*AB(1)
        ! theta(2356) = theta(1663)+theta(1528)*AB(1) ! ((5,3,0)|(1,0,1)) = ((6,3,0)|(0,0,1))+((5,3,0)|(0,0,1))*AB(1)
        theta(2357) = theta(1674)+theta(1527)*AB(2) ! ((5,3,0)|(0,2,0)) = ((5,4,0)|(0,1,0))+((5,3,0)|(0,1,0))*AB(2)
        ! theta(2358) = theta(1675)+theta(1528)*AB(2) ! ((5,3,0)|(0,1,1)) = ((5,4,0)|(0,0,1))+((5,3,0)|(0,0,1))*AB(2)
        theta(2359) = theta(1678)+theta(1528)*AB(3) ! ((5,3,0)|(0,0,2)) = ((5,3,1)|(0,0,1))+((5,3,0)|(0,0,1))*AB(3)
        theta(2360) = theta(1664)+theta(1529)*AB(1) ! ((5,2,1)|(2,0,0)) = ((6,2,1)|(1,0,0))+((5,2,1)|(1,0,0))*AB(1)
        theta(2361) = theta(1665)+theta(1530)*AB(1) ! ((5,2,1)|(1,1,0)) = ((6,2,1)|(0,1,0))+((5,2,1)|(0,1,0))*AB(1)
        ! theta(2362) = theta(1666)+theta(1531)*AB(1) ! ((5,2,1)|(1,0,1)) = ((6,2,1)|(0,0,1))+((5,2,1)|(0,0,1))*AB(1)
        theta(2363) = theta(1677)+theta(1530)*AB(2) ! ((5,2,1)|(0,2,0)) = ((5,3,1)|(0,1,0))+((5,2,1)|(0,1,0))*AB(2)
        theta(2364) = theta(1678)+theta(1531)*AB(2) ! ((5,2,1)|(0,1,1)) = ((5,3,1)|(0,0,1))+((5,2,1)|(0,0,1))*AB(2)
        theta(2365) = theta(1681)+theta(1531)*AB(3) ! ((5,2,1)|(0,0,2)) = ((5,2,2)|(0,0,1))+((5,2,1)|(0,0,1))*AB(3)
        theta(2366) = theta(1667)+theta(1532)*AB(1) ! ((5,1,2)|(2,0,0)) = ((6,1,2)|(1,0,0))+((5,1,2)|(1,0,0))*AB(1)
        theta(2367) = theta(1668)+theta(1533)*AB(1) ! ((5,1,2)|(1,1,0)) = ((6,1,2)|(0,1,0))+((5,1,2)|(0,1,0))*AB(1)
        ! theta(2368) = theta(1669)+theta(1534)*AB(1) ! ((5,1,2)|(1,0,1)) = ((6,1,2)|(0,0,1))+((5,1,2)|(0,0,1))*AB(1)
        theta(2369) = theta(1680)+theta(1533)*AB(2) ! ((5,1,2)|(0,2,0)) = ((5,2,2)|(0,1,0))+((5,1,2)|(0,1,0))*AB(2)
        theta(2370) = theta(1681)+theta(1534)*AB(2) ! ((5,1,2)|(0,1,1)) = ((5,2,2)|(0,0,1))+((5,1,2)|(0,0,1))*AB(2)
        theta(2371) = theta(1684)+theta(1534)*AB(3) ! ((5,1,2)|(0,0,2)) = ((5,1,3)|(0,0,1))+((5,1,2)|(0,0,1))*AB(3)
        theta(2372) = theta(1670)+theta(1535)*AB(1) ! ((5,0,3)|(2,0,0)) = ((6,0,3)|(1,0,0))+((5,0,3)|(1,0,0))*AB(1)
        theta(2373) = theta(1671)+theta(1536)*AB(1) ! ((5,0,3)|(1,1,0)) = ((6,0,3)|(0,1,0))+((5,0,3)|(0,1,0))*AB(1)
        ! theta(2374) = theta(1672)+theta(1537)*AB(1) ! ((5,0,3)|(1,0,1)) = ((6,0,3)|(0,0,1))+((5,0,3)|(0,0,1))*AB(1)
        theta(2375) = theta(1683)+theta(1536)*AB(2) ! ((5,0,3)|(0,2,0)) = ((5,1,3)|(0,1,0))+((5,0,3)|(0,1,0))*AB(2)
        theta(2376) = theta(1684)+theta(1537)*AB(2) ! ((5,0,3)|(0,1,1)) = ((5,1,3)|(0,0,1))+((5,0,3)|(0,0,1))*AB(2)
        theta(2377) = theta(1687)+theta(1537)*AB(3) ! ((5,0,3)|(0,0,2)) = ((5,0,4)|(0,0,1))+((5,0,3)|(0,0,1))*AB(3)
        theta(2378) = theta(1673)+theta(1538)*AB(1) ! ((4,4,0)|(2,0,0)) = ((5,4,0)|(1,0,0))+((4,4,0)|(1,0,0))*AB(1)
        ! theta(2379) = theta(1674)+theta(1539)*AB(1) ! ((4,4,0)|(1,1,0)) = ((5,4,0)|(0,1,0))+((4,4,0)|(0,1,0))*AB(1)
        ! theta(2380) = theta(1675)+theta(1540)*AB(1) ! ((4,4,0)|(1,0,1)) = ((5,4,0)|(0,0,1))+((4,4,0)|(0,0,1))*AB(1)
        theta(2381) = theta(1689)+theta(1539)*AB(2) ! ((4,4,0)|(0,2,0)) = ((4,5,0)|(0,1,0))+((4,4,0)|(0,1,0))*AB(2)
        ! theta(2382) = theta(1690)+theta(1540)*AB(2) ! ((4,4,0)|(0,1,1)) = ((4,5,0)|(0,0,1))+((4,4,0)|(0,0,1))*AB(2)
        theta(2383) = theta(1693)+theta(1540)*AB(3) ! ((4,4,0)|(0,0,2)) = ((4,4,1)|(0,0,1))+((4,4,0)|(0,0,1))*AB(3)
        theta(2384) = theta(1676)+theta(1541)*AB(1) ! ((4,3,1)|(2,0,0)) = ((5,3,1)|(1,0,0))+((4,3,1)|(1,0,0))*AB(1)
        theta(2385) = theta(1677)+theta(1542)*AB(1) ! ((4,3,1)|(1,1,0)) = ((5,3,1)|(0,1,0))+((4,3,1)|(0,1,0))*AB(1)
        ! theta(2386) = theta(1678)+theta(1543)*AB(1) ! ((4,3,1)|(1,0,1)) = ((5,3,1)|(0,0,1))+((4,3,1)|(0,0,1))*AB(1)
        theta(2387) = theta(1692)+theta(1542)*AB(2) ! ((4,3,1)|(0,2,0)) = ((4,4,1)|(0,1,0))+((4,3,1)|(0,1,0))*AB(2)
        theta(2388) = theta(1693)+theta(1543)*AB(2) ! ((4,3,1)|(0,1,1)) = ((4,4,1)|(0,0,1))+((4,3,1)|(0,0,1))*AB(2)
        theta(2389) = theta(1696)+theta(1543)*AB(3) ! ((4,3,1)|(0,0,2)) = ((4,3,2)|(0,0,1))+((4,3,1)|(0,0,1))*AB(3)
        theta(2390) = theta(1679)+theta(1544)*AB(1) ! ((4,2,2)|(2,0,0)) = ((5,2,2)|(1,0,0))+((4,2,2)|(1,0,0))*AB(1)
        theta(2391) = theta(1680)+theta(1545)*AB(1) ! ((4,2,2)|(1,1,0)) = ((5,2,2)|(0,1,0))+((4,2,2)|(0,1,0))*AB(1)
        ! theta(2392) = theta(1681)+theta(1546)*AB(1) ! ((4,2,2)|(1,0,1)) = ((5,2,2)|(0,0,1))+((4,2,2)|(0,0,1))*AB(1)
        theta(2393) = theta(1695)+theta(1545)*AB(2) ! ((4,2,2)|(0,2,0)) = ((4,3,2)|(0,1,0))+((4,2,2)|(0,1,0))*AB(2)
        theta(2394) = theta(1696)+theta(1546)*AB(2) ! ((4,2,2)|(0,1,1)) = ((4,3,2)|(0,0,1))+((4,2,2)|(0,0,1))*AB(2)
        theta(2395) = theta(1699)+theta(1546)*AB(3) ! ((4,2,2)|(0,0,2)) = ((4,2,3)|(0,0,1))+((4,2,2)|(0,0,1))*AB(3)
        theta(2396) = theta(1682)+theta(1547)*AB(1) ! ((4,1,3)|(2,0,0)) = ((5,1,3)|(1,0,0))+((4,1,3)|(1,0,0))*AB(1)
        theta(2397) = theta(1683)+theta(1548)*AB(1) ! ((4,1,3)|(1,1,0)) = ((5,1,3)|(0,1,0))+((4,1,3)|(0,1,0))*AB(1)
        ! theta(2398) = theta(1684)+theta(1549)*AB(1) ! ((4,1,3)|(1,0,1)) = ((5,1,3)|(0,0,1))+((4,1,3)|(0,0,1))*AB(1)
        theta(2399) = theta(1698)+theta(1548)*AB(2) ! ((4,1,3)|(0,2,0)) = ((4,2,3)|(0,1,0))+((4,1,3)|(0,1,0))*AB(2)
        theta(2400) = theta(1699)+theta(1549)*AB(2) ! ((4,1,3)|(0,1,1)) = ((4,2,3)|(0,0,1))+((4,1,3)|(0,0,1))*AB(2)
        theta(2401) = theta(1702)+theta(1549)*AB(3) ! ((4,1,3)|(0,0,2)) = ((4,1,4)|(0,0,1))+((4,1,3)|(0,0,1))*AB(3)
        theta(2402) = theta(1685)+theta(1550)*AB(1) ! ((4,0,4)|(2,0,0)) = ((5,0,4)|(1,0,0))+((4,0,4)|(1,0,0))*AB(1)
        theta(2403) = theta(1686)+theta(1551)*AB(1) ! ((4,0,4)|(1,1,0)) = ((5,0,4)|(0,1,0))+((4,0,4)|(0,1,0))*AB(1)
        ! theta(2404) = theta(1687)+theta(1552)*AB(1) ! ((4,0,4)|(1,0,1)) = ((5,0,4)|(0,0,1))+((4,0,4)|(0,0,1))*AB(1)
        theta(2405) = theta(1701)+theta(1551)*AB(2) ! ((4,0,4)|(0,2,0)) = ((4,1,4)|(0,1,0))+((4,0,4)|(0,1,0))*AB(2)
        theta(2406) = theta(1702)+theta(1552)*AB(2) ! ((4,0,4)|(0,1,1)) = ((4,1,4)|(0,0,1))+((4,0,4)|(0,0,1))*AB(2)
        theta(2407) = theta(1705)+theta(1552)*AB(3) ! ((4,0,4)|(0,0,2)) = ((4,0,5)|(0,0,1))+((4,0,4)|(0,0,1))*AB(3)
        theta(2408) = theta(1688)+theta(1553)*AB(1) ! ((3,5,0)|(2,0,0)) = ((4,5,0)|(1,0,0))+((3,5,0)|(1,0,0))*AB(1)
        ! theta(2409) = theta(1689)+theta(1554)*AB(1) ! ((3,5,0)|(1,1,0)) = ((4,5,0)|(0,1,0))+((3,5,0)|(0,1,0))*AB(1)
        ! theta(2410) = theta(1690)+theta(1555)*AB(1) ! ((3,5,0)|(1,0,1)) = ((4,5,0)|(0,0,1))+((3,5,0)|(0,0,1))*AB(1)
        theta(2411) = theta(1707)+theta(1554)*AB(2) ! ((3,5,0)|(0,2,0)) = ((3,6,0)|(0,1,0))+((3,5,0)|(0,1,0))*AB(2)
        ! theta(2412) = theta(1708)+theta(1555)*AB(2) ! ((3,5,0)|(0,1,1)) = ((3,6,0)|(0,0,1))+((3,5,0)|(0,0,1))*AB(2)
        theta(2413) = theta(1711)+theta(1555)*AB(3) ! ((3,5,0)|(0,0,2)) = ((3,5,1)|(0,0,1))+((3,5,0)|(0,0,1))*AB(3)
        theta(2414) = theta(1691)+theta(1556)*AB(1) ! ((3,4,1)|(2,0,0)) = ((4,4,1)|(1,0,0))+((3,4,1)|(1,0,0))*AB(1)
        theta(2415) = theta(1692)+theta(1557)*AB(1) ! ((3,4,1)|(1,1,0)) = ((4,4,1)|(0,1,0))+((3,4,1)|(0,1,0))*AB(1)
        ! theta(2416) = theta(1693)+theta(1558)*AB(1) ! ((3,4,1)|(1,0,1)) = ((4,4,1)|(0,0,1))+((3,4,1)|(0,0,1))*AB(1)
        theta(2417) = theta(1710)+theta(1557)*AB(2) ! ((3,4,1)|(0,2,0)) = ((3,5,1)|(0,1,0))+((3,4,1)|(0,1,0))*AB(2)
        theta(2418) = theta(1711)+theta(1558)*AB(2) ! ((3,4,1)|(0,1,1)) = ((3,5,1)|(0,0,1))+((3,4,1)|(0,0,1))*AB(2)
        theta(2419) = theta(1714)+theta(1558)*AB(3) ! ((3,4,1)|(0,0,2)) = ((3,4,2)|(0,0,1))+((3,4,1)|(0,0,1))*AB(3)
        theta(2420) = theta(1694)+theta(1559)*AB(1) ! ((3,3,2)|(2,0,0)) = ((4,3,2)|(1,0,0))+((3,3,2)|(1,0,0))*AB(1)
        theta(2421) = theta(1695)+theta(1560)*AB(1) ! ((3,3,2)|(1,1,0)) = ((4,3,2)|(0,1,0))+((3,3,2)|(0,1,0))*AB(1)
        ! theta(2422) = theta(1696)+theta(1561)*AB(1) ! ((3,3,2)|(1,0,1)) = ((4,3,2)|(0,0,1))+((3,3,2)|(0,0,1))*AB(1)
        theta(2423) = theta(1713)+theta(1560)*AB(2) ! ((3,3,2)|(0,2,0)) = ((3,4,2)|(0,1,0))+((3,3,2)|(0,1,0))*AB(2)
        theta(2424) = theta(1714)+theta(1561)*AB(2) ! ((3,3,2)|(0,1,1)) = ((3,4,2)|(0,0,1))+((3,3,2)|(0,0,1))*AB(2)
        theta(2425) = theta(1717)+theta(1561)*AB(3) ! ((3,3,2)|(0,0,2)) = ((3,3,3)|(0,0,1))+((3,3,2)|(0,0,1))*AB(3)
        theta(2426) = theta(1697)+theta(1562)*AB(1) ! ((3,2,3)|(2,0,0)) = ((4,2,3)|(1,0,0))+((3,2,3)|(1,0,0))*AB(1)
        theta(2427) = theta(1698)+theta(1563)*AB(1) ! ((3,2,3)|(1,1,0)) = ((4,2,3)|(0,1,0))+((3,2,3)|(0,1,0))*AB(1)
        ! theta(2428) = theta(1699)+theta(1564)*AB(1) ! ((3,2,3)|(1,0,1)) = ((4,2,3)|(0,0,1))+((3,2,3)|(0,0,1))*AB(1)
        theta(2429) = theta(1716)+theta(1563)*AB(2) ! ((3,2,3)|(0,2,0)) = ((3,3,3)|(0,1,0))+((3,2,3)|(0,1,0))*AB(2)
        theta(2430) = theta(1717)+theta(1564)*AB(2) ! ((3,2,3)|(0,1,1)) = ((3,3,3)|(0,0,1))+((3,2,3)|(0,0,1))*AB(2)
        theta(2431) = theta(1720)+theta(1564)*AB(3) ! ((3,2,3)|(0,0,2)) = ((3,2,4)|(0,0,1))+((3,2,3)|(0,0,1))*AB(3)
        theta(2432) = theta(1700)+theta(1565)*AB(1) ! ((3,1,4)|(2,0,0)) = ((4,1,4)|(1,0,0))+((3,1,4)|(1,0,0))*AB(1)
        theta(2433) = theta(1701)+theta(1566)*AB(1) ! ((3,1,4)|(1,1,0)) = ((4,1,4)|(0,1,0))+((3,1,4)|(0,1,0))*AB(1)
        ! theta(2434) = theta(1702)+theta(1567)*AB(1) ! ((3,1,4)|(1,0,1)) = ((4,1,4)|(0,0,1))+((3,1,4)|(0,0,1))*AB(1)
        theta(2435) = theta(1719)+theta(1566)*AB(2) ! ((3,1,4)|(0,2,0)) = ((3,2,4)|(0,1,0))+((3,1,4)|(0,1,0))*AB(2)
        theta(2436) = theta(1720)+theta(1567)*AB(2) ! ((3,1,4)|(0,1,1)) = ((3,2,4)|(0,0,1))+((3,1,4)|(0,0,1))*AB(2)
        theta(2437) = theta(1723)+theta(1567)*AB(3) ! ((3,1,4)|(0,0,2)) = ((3,1,5)|(0,0,1))+((3,1,4)|(0,0,1))*AB(3)
        theta(2438) = theta(1703)+theta(1568)*AB(1) ! ((3,0,5)|(2,0,0)) = ((4,0,5)|(1,0,0))+((3,0,5)|(1,0,0))*AB(1)
        theta(2439) = theta(1704)+theta(1569)*AB(1) ! ((3,0,5)|(1,1,0)) = ((4,0,5)|(0,1,0))+((3,0,5)|(0,1,0))*AB(1)
        ! theta(2440) = theta(1705)+theta(1570)*AB(1) ! ((3,0,5)|(1,0,1)) = ((4,0,5)|(0,0,1))+((3,0,5)|(0,0,1))*AB(1)
        theta(2441) = theta(1722)+theta(1569)*AB(2) ! ((3,0,5)|(0,2,0)) = ((3,1,5)|(0,1,0))+((3,0,5)|(0,1,0))*AB(2)
        theta(2442) = theta(1723)+theta(1570)*AB(2) ! ((3,0,5)|(0,1,1)) = ((3,1,5)|(0,0,1))+((3,0,5)|(0,0,1))*AB(2)
        theta(2443) = theta(1726)+theta(1570)*AB(3) ! ((3,0,5)|(0,0,2)) = ((3,0,6)|(0,0,1))+((3,0,5)|(0,0,1))*AB(3)
        theta(2444) = theta(1706)+theta(1571)*AB(1) ! ((2,6,0)|(2,0,0)) = ((3,6,0)|(1,0,0))+((2,6,0)|(1,0,0))*AB(1)
        ! theta(2445) = theta(1707)+theta(1572)*AB(1) ! ((2,6,0)|(1,1,0)) = ((3,6,0)|(0,1,0))+((2,6,0)|(0,1,0))*AB(1)
        ! theta(2446) = theta(1708)+theta(1573)*AB(1) ! ((2,6,0)|(1,0,1)) = ((3,6,0)|(0,0,1))+((2,6,0)|(0,0,1))*AB(1)
        theta(2447) = theta(1728)+theta(1572)*AB(2) ! ((2,6,0)|(0,2,0)) = ((2,7,0)|(0,1,0))+((2,6,0)|(0,1,0))*AB(2)
        ! theta(2448) = theta(1729)+theta(1573)*AB(2) ! ((2,6,0)|(0,1,1)) = ((2,7,0)|(0,0,1))+((2,6,0)|(0,0,1))*AB(2)
        theta(2449) = theta(1732)+theta(1573)*AB(3) ! ((2,6,0)|(0,0,2)) = ((2,6,1)|(0,0,1))+((2,6,0)|(0,0,1))*AB(3)
        theta(2450) = theta(1709)+theta(1574)*AB(1) ! ((2,5,1)|(2,0,0)) = ((3,5,1)|(1,0,0))+((2,5,1)|(1,0,0))*AB(1)
        ! theta(2451) = theta(1710)+theta(1575)*AB(1) ! ((2,5,1)|(1,1,0)) = ((3,5,1)|(0,1,0))+((2,5,1)|(0,1,0))*AB(1)
        ! theta(2452) = theta(1711)+theta(1576)*AB(1) ! ((2,5,1)|(1,0,1)) = ((3,5,1)|(0,0,1))+((2,5,1)|(0,0,1))*AB(1)
        theta(2453) = theta(1731)+theta(1575)*AB(2) ! ((2,5,1)|(0,2,0)) = ((2,6,1)|(0,1,0))+((2,5,1)|(0,1,0))*AB(2)
        ! theta(2454) = theta(1732)+theta(1576)*AB(2) ! ((2,5,1)|(0,1,1)) = ((2,6,1)|(0,0,1))+((2,5,1)|(0,0,1))*AB(2)
        theta(2455) = theta(1735)+theta(1576)*AB(3) ! ((2,5,1)|(0,0,2)) = ((2,5,2)|(0,0,1))+((2,5,1)|(0,0,1))*AB(3)
        theta(2456) = theta(1712)+theta(1577)*AB(1) ! ((2,4,2)|(2,0,0)) = ((3,4,2)|(1,0,0))+((2,4,2)|(1,0,0))*AB(1)
        ! theta(2457) = theta(1713)+theta(1578)*AB(1) ! ((2,4,2)|(1,1,0)) = ((3,4,2)|(0,1,0))+((2,4,2)|(0,1,0))*AB(1)
        ! theta(2458) = theta(1714)+theta(1579)*AB(1) ! ((2,4,2)|(1,0,1)) = ((3,4,2)|(0,0,1))+((2,4,2)|(0,0,1))*AB(1)
        theta(2459) = theta(1734)+theta(1578)*AB(2) ! ((2,4,2)|(0,2,0)) = ((2,5,2)|(0,1,0))+((2,4,2)|(0,1,0))*AB(2)
        ! theta(2460) = theta(1735)+theta(1579)*AB(2) ! ((2,4,2)|(0,1,1)) = ((2,5,2)|(0,0,1))+((2,4,2)|(0,0,1))*AB(2)
        theta(2461) = theta(1738)+theta(1579)*AB(3) ! ((2,4,2)|(0,0,2)) = ((2,4,3)|(0,0,1))+((2,4,2)|(0,0,1))*AB(3)
        theta(2462) = theta(1715)+theta(1580)*AB(1) ! ((2,3,3)|(2,0,0)) = ((3,3,3)|(1,0,0))+((2,3,3)|(1,0,0))*AB(1)
        ! theta(2463) = theta(1716)+theta(1581)*AB(1) ! ((2,3,3)|(1,1,0)) = ((3,3,3)|(0,1,0))+((2,3,3)|(0,1,0))*AB(1)
        ! theta(2464) = theta(1717)+theta(1582)*AB(1) ! ((2,3,3)|(1,0,1)) = ((3,3,3)|(0,0,1))+((2,3,3)|(0,0,1))*AB(1)
        theta(2465) = theta(1737)+theta(1581)*AB(2) ! ((2,3,3)|(0,2,0)) = ((2,4,3)|(0,1,0))+((2,3,3)|(0,1,0))*AB(2)
        ! theta(2466) = theta(1738)+theta(1582)*AB(2) ! ((2,3,3)|(0,1,1)) = ((2,4,3)|(0,0,1))+((2,3,3)|(0,0,1))*AB(2)
        theta(2467) = theta(1741)+theta(1582)*AB(3) ! ((2,3,3)|(0,0,2)) = ((2,3,4)|(0,0,1))+((2,3,3)|(0,0,1))*AB(3)
        theta(2468) = theta(1718)+theta(1583)*AB(1) ! ((2,2,4)|(2,0,0)) = ((3,2,4)|(1,0,0))+((2,2,4)|(1,0,0))*AB(1)
        ! theta(2469) = theta(1719)+theta(1584)*AB(1) ! ((2,2,4)|(1,1,0)) = ((3,2,4)|(0,1,0))+((2,2,4)|(0,1,0))*AB(1)
        ! theta(2470) = theta(1720)+theta(1585)*AB(1) ! ((2,2,4)|(1,0,1)) = ((3,2,4)|(0,0,1))+((2,2,4)|(0,0,1))*AB(1)
        theta(2471) = theta(1740)+theta(1584)*AB(2) ! ((2,2,4)|(0,2,0)) = ((2,3,4)|(0,1,0))+((2,2,4)|(0,1,0))*AB(2)
        ! theta(2472) = theta(1741)+theta(1585)*AB(2) ! ((2,2,4)|(0,1,1)) = ((2,3,4)|(0,0,1))+((2,2,4)|(0,0,1))*AB(2)
        theta(2473) = theta(1744)+theta(1585)*AB(3) ! ((2,2,4)|(0,0,2)) = ((2,2,5)|(0,0,1))+((2,2,4)|(0,0,1))*AB(3)
        theta(2474) = theta(1721)+theta(1586)*AB(1) ! ((2,1,5)|(2,0,0)) = ((3,1,5)|(1,0,0))+((2,1,5)|(1,0,0))*AB(1)
        ! theta(2475) = theta(1722)+theta(1587)*AB(1) ! ((2,1,5)|(1,1,0)) = ((3,1,5)|(0,1,0))+((2,1,5)|(0,1,0))*AB(1)
        ! theta(2476) = theta(1723)+theta(1588)*AB(1) ! ((2,1,5)|(1,0,1)) = ((3,1,5)|(0,0,1))+((2,1,5)|(0,0,1))*AB(1)
        theta(2477) = theta(1743)+theta(1587)*AB(2) ! ((2,1,5)|(0,2,0)) = ((2,2,5)|(0,1,0))+((2,1,5)|(0,1,0))*AB(2)
        ! theta(2478) = theta(1744)+theta(1588)*AB(2) ! ((2,1,5)|(0,1,1)) = ((2,2,5)|(0,0,1))+((2,1,5)|(0,0,1))*AB(2)
        theta(2479) = theta(1747)+theta(1588)*AB(3) ! ((2,1,5)|(0,0,2)) = ((2,1,6)|(0,0,1))+((2,1,5)|(0,0,1))*AB(3)
        theta(2480) = theta(1724)+theta(1589)*AB(1) ! ((2,0,6)|(2,0,0)) = ((3,0,6)|(1,0,0))+((2,0,6)|(1,0,0))*AB(1)
        ! theta(2481) = theta(1725)+theta(1590)*AB(1) ! ((2,0,6)|(1,1,0)) = ((3,0,6)|(0,1,0))+((2,0,6)|(0,1,0))*AB(1)
        ! theta(2482) = theta(1726)+theta(1591)*AB(1) ! ((2,0,6)|(1,0,1)) = ((3,0,6)|(0,0,1))+((2,0,6)|(0,0,1))*AB(1)
        theta(2483) = theta(1746)+theta(1590)*AB(2) ! ((2,0,6)|(0,2,0)) = ((2,1,6)|(0,1,0))+((2,0,6)|(0,1,0))*AB(2)
        ! theta(2484) = theta(1747)+theta(1591)*AB(2) ! ((2,0,6)|(0,1,1)) = ((2,1,6)|(0,0,1))+((2,0,6)|(0,0,1))*AB(2)
        theta(2485) = theta(1750)+theta(1591)*AB(3) ! ((2,0,6)|(0,0,2)) = ((2,0,7)|(0,0,1))+((2,0,6)|(0,0,1))*AB(3)
        theta(2486) = theta(1727)+theta(1592)*AB(1) ! ((1,7,0)|(2,0,0)) = ((2,7,0)|(1,0,0))+((1,7,0)|(1,0,0))*AB(1)
        ! theta(2487) = theta(1728)+theta(1593)*AB(1) ! ((1,7,0)|(1,1,0)) = ((2,7,0)|(0,1,0))+((1,7,0)|(0,1,0))*AB(1)
        ! theta(2488) = theta(1729)+theta(1594)*AB(1) ! ((1,7,0)|(1,0,1)) = ((2,7,0)|(0,0,1))+((1,7,0)|(0,0,1))*AB(1)
        theta(2489) = theta(1752)+theta(1593)*AB(2) ! ((1,7,0)|(0,2,0)) = ((1,8,0)|(0,1,0))+((1,7,0)|(0,1,0))*AB(2)
        ! theta(2490) = theta(1753)+theta(1594)*AB(2) ! ((1,7,0)|(0,1,1)) = ((1,8,0)|(0,0,1))+((1,7,0)|(0,0,1))*AB(2)
        theta(2491) = theta(1756)+theta(1594)*AB(3) ! ((1,7,0)|(0,0,2)) = ((1,7,1)|(0,0,1))+((1,7,0)|(0,0,1))*AB(3)
        theta(2492) = theta(1730)+theta(1595)*AB(1) ! ((1,6,1)|(2,0,0)) = ((2,6,1)|(1,0,0))+((1,6,1)|(1,0,0))*AB(1)
        ! theta(2493) = theta(1731)+theta(1596)*AB(1) ! ((1,6,1)|(1,1,0)) = ((2,6,1)|(0,1,0))+((1,6,1)|(0,1,0))*AB(1)
        ! theta(2494) = theta(1732)+theta(1597)*AB(1) ! ((1,6,1)|(1,0,1)) = ((2,6,1)|(0,0,1))+((1,6,1)|(0,0,1))*AB(1)
        theta(2495) = theta(1755)+theta(1596)*AB(2) ! ((1,6,1)|(0,2,0)) = ((1,7,1)|(0,1,0))+((1,6,1)|(0,1,0))*AB(2)
        ! theta(2496) = theta(1756)+theta(1597)*AB(2) ! ((1,6,1)|(0,1,1)) = ((1,7,1)|(0,0,1))+((1,6,1)|(0,0,1))*AB(2)
        theta(2497) = theta(1759)+theta(1597)*AB(3) ! ((1,6,1)|(0,0,2)) = ((1,6,2)|(0,0,1))+((1,6,1)|(0,0,1))*AB(3)
        theta(2498) = theta(1733)+theta(1598)*AB(1) ! ((1,5,2)|(2,0,0)) = ((2,5,2)|(1,0,0))+((1,5,2)|(1,0,0))*AB(1)
        ! theta(2499) = theta(1734)+theta(1599)*AB(1) ! ((1,5,2)|(1,1,0)) = ((2,5,2)|(0,1,0))+((1,5,2)|(0,1,0))*AB(1)
        ! theta(2500) = theta(1735)+theta(1600)*AB(1) ! ((1,5,2)|(1,0,1)) = ((2,5,2)|(0,0,1))+((1,5,2)|(0,0,1))*AB(1)
        theta(2501) = theta(1758)+theta(1599)*AB(2) ! ((1,5,2)|(0,2,0)) = ((1,6,2)|(0,1,0))+((1,5,2)|(0,1,0))*AB(2)
        ! theta(2502) = theta(1759)+theta(1600)*AB(2) ! ((1,5,2)|(0,1,1)) = ((1,6,2)|(0,0,1))+((1,5,2)|(0,0,1))*AB(2)
        theta(2503) = theta(1762)+theta(1600)*AB(3) ! ((1,5,2)|(0,0,2)) = ((1,5,3)|(0,0,1))+((1,5,2)|(0,0,1))*AB(3)
        theta(2504) = theta(1736)+theta(1601)*AB(1) ! ((1,4,3)|(2,0,0)) = ((2,4,3)|(1,0,0))+((1,4,3)|(1,0,0))*AB(1)
        ! theta(2505) = theta(1737)+theta(1602)*AB(1) ! ((1,4,3)|(1,1,0)) = ((2,4,3)|(0,1,0))+((1,4,3)|(0,1,0))*AB(1)
        ! theta(2506) = theta(1738)+theta(1603)*AB(1) ! ((1,4,3)|(1,0,1)) = ((2,4,3)|(0,0,1))+((1,4,3)|(0,0,1))*AB(1)
        theta(2507) = theta(1761)+theta(1602)*AB(2) ! ((1,4,3)|(0,2,0)) = ((1,5,3)|(0,1,0))+((1,4,3)|(0,1,0))*AB(2)
        ! theta(2508) = theta(1762)+theta(1603)*AB(2) ! ((1,4,3)|(0,1,1)) = ((1,5,3)|(0,0,1))+((1,4,3)|(0,0,1))*AB(2)
        theta(2509) = theta(1765)+theta(1603)*AB(3) ! ((1,4,3)|(0,0,2)) = ((1,4,4)|(0,0,1))+((1,4,3)|(0,0,1))*AB(3)
        theta(2510) = theta(1739)+theta(1604)*AB(1) ! ((1,3,4)|(2,0,0)) = ((2,3,4)|(1,0,0))+((1,3,4)|(1,0,0))*AB(1)
        ! theta(2511) = theta(1740)+theta(1605)*AB(1) ! ((1,3,4)|(1,1,0)) = ((2,3,4)|(0,1,0))+((1,3,4)|(0,1,0))*AB(1)
        ! theta(2512) = theta(1741)+theta(1606)*AB(1) ! ((1,3,4)|(1,0,1)) = ((2,3,4)|(0,0,1))+((1,3,4)|(0,0,1))*AB(1)
        theta(2513) = theta(1764)+theta(1605)*AB(2) ! ((1,3,4)|(0,2,0)) = ((1,4,4)|(0,1,0))+((1,3,4)|(0,1,0))*AB(2)
        ! theta(2514) = theta(1765)+theta(1606)*AB(2) ! ((1,3,4)|(0,1,1)) = ((1,4,4)|(0,0,1))+((1,3,4)|(0,0,1))*AB(2)
        theta(2515) = theta(1768)+theta(1606)*AB(3) ! ((1,3,4)|(0,0,2)) = ((1,3,5)|(0,0,1))+((1,3,4)|(0,0,1))*AB(3)
        theta(2516) = theta(1742)+theta(1607)*AB(1) ! ((1,2,5)|(2,0,0)) = ((2,2,5)|(1,0,0))+((1,2,5)|(1,0,0))*AB(1)
        ! theta(2517) = theta(1743)+theta(1608)*AB(1) ! ((1,2,5)|(1,1,0)) = ((2,2,5)|(0,1,0))+((1,2,5)|(0,1,0))*AB(1)
        ! theta(2518) = theta(1744)+theta(1609)*AB(1) ! ((1,2,5)|(1,0,1)) = ((2,2,5)|(0,0,1))+((1,2,5)|(0,0,1))*AB(1)
        theta(2519) = theta(1767)+theta(1608)*AB(2) ! ((1,2,5)|(0,2,0)) = ((1,3,5)|(0,1,0))+((1,2,5)|(0,1,0))*AB(2)
        ! theta(2520) = theta(1768)+theta(1609)*AB(2) ! ((1,2,5)|(0,1,1)) = ((1,3,5)|(0,0,1))+((1,2,5)|(0,0,1))*AB(2)
        theta(2521) = theta(1771)+theta(1609)*AB(3) ! ((1,2,5)|(0,0,2)) = ((1,2,6)|(0,0,1))+((1,2,5)|(0,0,1))*AB(3)
        theta(2522) = theta(1745)+theta(1610)*AB(1) ! ((1,1,6)|(2,0,0)) = ((2,1,6)|(1,0,0))+((1,1,6)|(1,0,0))*AB(1)
        ! theta(2523) = theta(1746)+theta(1611)*AB(1) ! ((1,1,6)|(1,1,0)) = ((2,1,6)|(0,1,0))+((1,1,6)|(0,1,0))*AB(1)
        ! theta(2524) = theta(1747)+theta(1612)*AB(1) ! ((1,1,6)|(1,0,1)) = ((2,1,6)|(0,0,1))+((1,1,6)|(0,0,1))*AB(1)
        theta(2525) = theta(1770)+theta(1611)*AB(2) ! ((1,1,6)|(0,2,0)) = ((1,2,6)|(0,1,0))+((1,1,6)|(0,1,0))*AB(2)
        ! theta(2526) = theta(1771)+theta(1612)*AB(2) ! ((1,1,6)|(0,1,1)) = ((1,2,6)|(0,0,1))+((1,1,6)|(0,0,1))*AB(2)
        theta(2527) = theta(1774)+theta(1612)*AB(3) ! ((1,1,6)|(0,0,2)) = ((1,1,7)|(0,0,1))+((1,1,6)|(0,0,1))*AB(3)
        theta(2528) = theta(1748)+theta(1613)*AB(1) ! ((1,0,7)|(2,0,0)) = ((2,0,7)|(1,0,0))+((1,0,7)|(1,0,0))*AB(1)
        ! theta(2529) = theta(1749)+theta(1614)*AB(1) ! ((1,0,7)|(1,1,0)) = ((2,0,7)|(0,1,0))+((1,0,7)|(0,1,0))*AB(1)
        ! theta(2530) = theta(1750)+theta(1615)*AB(1) ! ((1,0,7)|(1,0,1)) = ((2,0,7)|(0,0,1))+((1,0,7)|(0,0,1))*AB(1)
        ! theta(2531) = theta(1773)+theta(1614)*AB(2) ! ((1,0,7)|(0,2,0)) = ((1,1,7)|(0,1,0))+((1,0,7)|(0,1,0))*AB(2)
        ! theta(2532) = theta(1774)+theta(1615)*AB(2) ! ((1,0,7)|(0,1,1)) = ((1,1,7)|(0,0,1))+((1,0,7)|(0,0,1))*AB(2)
        theta(2533) = theta(1777)+theta(1615)*AB(3) ! ((1,0,7)|(0,0,2)) = ((1,0,8)|(0,0,1))+((1,0,7)|(0,0,1))*AB(3)
        ! theta(2534) = theta(1751)+theta(1616)*AB(1) ! ((0,8,0)|(2,0,0)) = ((1,8,0)|(1,0,0))+((0,8,0)|(1,0,0))*AB(1)
        ! theta(2535) = theta(1752)+theta(1617)*AB(1) ! ((0,8,0)|(1,1,0)) = ((1,8,0)|(0,1,0))+((0,8,0)|(0,1,0))*AB(1)
        ! theta(2536) = theta(1753)+theta(1618)*AB(1) ! ((0,8,0)|(1,0,1)) = ((1,8,0)|(0,0,1))+((0,8,0)|(0,0,1))*AB(1)
        theta(2537) = theta(1779)+theta(1617)*AB(2) ! ((0,8,0)|(0,2,0)) = ((0,9,0)|(0,1,0))+((0,8,0)|(0,1,0))*AB(2)
        ! theta(2538) = theta(1780)+theta(1618)*AB(2) ! ((0,8,0)|(0,1,1)) = ((0,9,0)|(0,0,1))+((0,8,0)|(0,0,1))*AB(2)
        ! theta(2539) = theta(1783)+theta(1618)*AB(3) ! ((0,8,0)|(0,0,2)) = ((0,8,1)|(0,0,1))+((0,8,0)|(0,0,1))*AB(3)
        ! theta(2540) = theta(1754)+theta(1619)*AB(1) ! ((0,7,1)|(2,0,0)) = ((1,7,1)|(1,0,0))+((0,7,1)|(1,0,0))*AB(1)
        ! theta(2541) = theta(1755)+theta(1620)*AB(1) ! ((0,7,1)|(1,1,0)) = ((1,7,1)|(0,1,0))+((0,7,1)|(0,1,0))*AB(1)
        ! theta(2542) = theta(1756)+theta(1621)*AB(1) ! ((0,7,1)|(1,0,1)) = ((1,7,1)|(0,0,1))+((0,7,1)|(0,0,1))*AB(1)
        theta(2543) = theta(1782)+theta(1620)*AB(2) ! ((0,7,1)|(0,2,0)) = ((0,8,1)|(0,1,0))+((0,7,1)|(0,1,0))*AB(2)
        ! theta(2544) = theta(1783)+theta(1621)*AB(2) ! ((0,7,1)|(0,1,1)) = ((0,8,1)|(0,0,1))+((0,7,1)|(0,0,1))*AB(2)
        theta(2545) = theta(1786)+theta(1621)*AB(3) ! ((0,7,1)|(0,0,2)) = ((0,7,2)|(0,0,1))+((0,7,1)|(0,0,1))*AB(3)
        ! theta(2546) = theta(1757)+theta(1622)*AB(1) ! ((0,6,2)|(2,0,0)) = ((1,6,2)|(1,0,0))+((0,6,2)|(1,0,0))*AB(1)
        ! theta(2547) = theta(1758)+theta(1623)*AB(1) ! ((0,6,2)|(1,1,0)) = ((1,6,2)|(0,1,0))+((0,6,2)|(0,1,0))*AB(1)
        ! theta(2548) = theta(1759)+theta(1624)*AB(1) ! ((0,6,2)|(1,0,1)) = ((1,6,2)|(0,0,1))+((0,6,2)|(0,0,1))*AB(1)
        theta(2549) = theta(1785)+theta(1623)*AB(2) ! ((0,6,2)|(0,2,0)) = ((0,7,2)|(0,1,0))+((0,6,2)|(0,1,0))*AB(2)
        ! theta(2550) = theta(1786)+theta(1624)*AB(2) ! ((0,6,2)|(0,1,1)) = ((0,7,2)|(0,0,1))+((0,6,2)|(0,0,1))*AB(2)
        theta(2551) = theta(1789)+theta(1624)*AB(3) ! ((0,6,2)|(0,0,2)) = ((0,6,3)|(0,0,1))+((0,6,2)|(0,0,1))*AB(3)
        ! theta(2552) = theta(1760)+theta(1625)*AB(1) ! ((0,5,3)|(2,0,0)) = ((1,5,3)|(1,0,0))+((0,5,3)|(1,0,0))*AB(1)
        ! theta(2553) = theta(1761)+theta(1626)*AB(1) ! ((0,5,3)|(1,1,0)) = ((1,5,3)|(0,1,0))+((0,5,3)|(0,1,0))*AB(1)
        ! theta(2554) = theta(1762)+theta(1627)*AB(1) ! ((0,5,3)|(1,0,1)) = ((1,5,3)|(0,0,1))+((0,5,3)|(0,0,1))*AB(1)
        theta(2555) = theta(1788)+theta(1626)*AB(2) ! ((0,5,3)|(0,2,0)) = ((0,6,3)|(0,1,0))+((0,5,3)|(0,1,0))*AB(2)
        ! theta(2556) = theta(1789)+theta(1627)*AB(2) ! ((0,5,3)|(0,1,1)) = ((0,6,3)|(0,0,1))+((0,5,3)|(0,0,1))*AB(2)
        theta(2557) = theta(1792)+theta(1627)*AB(3) ! ((0,5,3)|(0,0,2)) = ((0,5,4)|(0,0,1))+((0,5,3)|(0,0,1))*AB(3)
        ! theta(2558) = theta(1763)+theta(1628)*AB(1) ! ((0,4,4)|(2,0,0)) = ((1,4,4)|(1,0,0))+((0,4,4)|(1,0,0))*AB(1)
        ! theta(2559) = theta(1764)+theta(1629)*AB(1) ! ((0,4,4)|(1,1,0)) = ((1,4,4)|(0,1,0))+((0,4,4)|(0,1,0))*AB(1)
        ! theta(2560) = theta(1765)+theta(1630)*AB(1) ! ((0,4,4)|(1,0,1)) = ((1,4,4)|(0,0,1))+((0,4,4)|(0,0,1))*AB(1)
        theta(2561) = theta(1791)+theta(1629)*AB(2) ! ((0,4,4)|(0,2,0)) = ((0,5,4)|(0,1,0))+((0,4,4)|(0,1,0))*AB(2)
        ! theta(2562) = theta(1792)+theta(1630)*AB(2) ! ((0,4,4)|(0,1,1)) = ((0,5,4)|(0,0,1))+((0,4,4)|(0,0,1))*AB(2)
        theta(2563) = theta(1795)+theta(1630)*AB(3) ! ((0,4,4)|(0,0,2)) = ((0,4,5)|(0,0,1))+((0,4,4)|(0,0,1))*AB(3)
        ! theta(2564) = theta(1766)+theta(1631)*AB(1) ! ((0,3,5)|(2,0,0)) = ((1,3,5)|(1,0,0))+((0,3,5)|(1,0,0))*AB(1)
        ! theta(2565) = theta(1767)+theta(1632)*AB(1) ! ((0,3,5)|(1,1,0)) = ((1,3,5)|(0,1,0))+((0,3,5)|(0,1,0))*AB(1)
        ! theta(2566) = theta(1768)+theta(1633)*AB(1) ! ((0,3,5)|(1,0,1)) = ((1,3,5)|(0,0,1))+((0,3,5)|(0,0,1))*AB(1)
        theta(2567) = theta(1794)+theta(1632)*AB(2) ! ((0,3,5)|(0,2,0)) = ((0,4,5)|(0,1,0))+((0,3,5)|(0,1,0))*AB(2)
        ! theta(2568) = theta(1795)+theta(1633)*AB(2) ! ((0,3,5)|(0,1,1)) = ((0,4,5)|(0,0,1))+((0,3,5)|(0,0,1))*AB(2)
        theta(2569) = theta(1798)+theta(1633)*AB(3) ! ((0,3,5)|(0,0,2)) = ((0,3,6)|(0,0,1))+((0,3,5)|(0,0,1))*AB(3)
        ! theta(2570) = theta(1769)+theta(1634)*AB(1) ! ((0,2,6)|(2,0,0)) = ((1,2,6)|(1,0,0))+((0,2,6)|(1,0,0))*AB(1)
        ! theta(2571) = theta(1770)+theta(1635)*AB(1) ! ((0,2,6)|(1,1,0)) = ((1,2,6)|(0,1,0))+((0,2,6)|(0,1,0))*AB(1)
        ! theta(2572) = theta(1771)+theta(1636)*AB(1) ! ((0,2,6)|(1,0,1)) = ((1,2,6)|(0,0,1))+((0,2,6)|(0,0,1))*AB(1)
        theta(2573) = theta(1797)+theta(1635)*AB(2) ! ((0,2,6)|(0,2,0)) = ((0,3,6)|(0,1,0))+((0,2,6)|(0,1,0))*AB(2)
        ! theta(2574) = theta(1798)+theta(1636)*AB(2) ! ((0,2,6)|(0,1,1)) = ((0,3,6)|(0,0,1))+((0,2,6)|(0,0,1))*AB(2)
        theta(2575) = theta(1801)+theta(1636)*AB(3) ! ((0,2,6)|(0,0,2)) = ((0,2,7)|(0,0,1))+((0,2,6)|(0,0,1))*AB(3)
        ! theta(2576) = theta(1772)+theta(1637)*AB(1) ! ((0,1,7)|(2,0,0)) = ((1,1,7)|(1,0,0))+((0,1,7)|(1,0,0))*AB(1)
        ! theta(2577) = theta(1773)+theta(1638)*AB(1) ! ((0,1,7)|(1,1,0)) = ((1,1,7)|(0,1,0))+((0,1,7)|(0,1,0))*AB(1)
        ! theta(2578) = theta(1774)+theta(1639)*AB(1) ! ((0,1,7)|(1,0,1)) = ((1,1,7)|(0,0,1))+((0,1,7)|(0,0,1))*AB(1)
        theta(2579) = theta(1800)+theta(1638)*AB(2) ! ((0,1,7)|(0,2,0)) = ((0,2,7)|(0,1,0))+((0,1,7)|(0,1,0))*AB(2)
        ! theta(2580) = theta(1801)+theta(1639)*AB(2) ! ((0,1,7)|(0,1,1)) = ((0,2,7)|(0,0,1))+((0,1,7)|(0,0,1))*AB(2)
        theta(2581) = theta(1804)+theta(1639)*AB(3) ! ((0,1,7)|(0,0,2)) = ((0,1,8)|(0,0,1))+((0,1,7)|(0,0,1))*AB(3)
        ! theta(2582) = theta(1775)+theta(1640)*AB(1) ! ((0,0,8)|(2,0,0)) = ((1,0,8)|(1,0,0))+((0,0,8)|(1,0,0))*AB(1)
        ! theta(2583) = theta(1776)+theta(1641)*AB(1) ! ((0,0,8)|(1,1,0)) = ((1,0,8)|(0,1,0))+((0,0,8)|(0,1,0))*AB(1)
        ! theta(2584) = theta(1777)+theta(1642)*AB(1) ! ((0,0,8)|(1,0,1)) = ((1,0,8)|(0,0,1))+((0,0,8)|(0,0,1))*AB(1)
        ! theta(2585) = theta(1803)+theta(1641)*AB(2) ! ((0,0,8)|(0,2,0)) = ((0,1,8)|(0,1,0))+((0,0,8)|(0,1,0))*AB(2)
        ! theta(2586) = theta(1804)+theta(1642)*AB(2) ! ((0,0,8)|(0,1,1)) = ((0,1,8)|(0,0,1))+((0,0,8)|(0,0,1))*AB(2)
        theta(2587) = theta(1807)+theta(1642)*AB(3) ! ((0,0,8)|(0,0,2)) = ((0,0,9)|(0,0,1))+((0,0,8)|(0,0,1))*AB(3)
        theta(2588) = theta(1934)+theta(1808)*AB(1) ! ((5,0,0)|(3,0,0)) = ((6,0,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(1)
        ! theta(2589) = theta(1940)+theta(1808)*AB(2) ! ((5,0,0)|(2,1,0)) = ((5,1,0)|(2,0,0))+((5,0,0)|(2,0,0))*AB(2)
        ! theta(2590) = theta(1946)+theta(1808)*AB(3) ! ((5,0,0)|(2,0,1)) = ((5,0,1)|(2,0,0))+((5,0,0)|(2,0,0))*AB(3)
        ! theta(2591) = theta(1937)+theta(1811)*AB(1) ! ((5,0,0)|(1,2,0)) = ((6,0,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(1)
        ! theta(2592) = theta(1938)+theta(1812)*AB(1) ! ((5,0,0)|(1,1,1)) = ((6,0,0)|(0,1,1))+((5,0,0)|(0,1,1))*AB(1)
        theta(2593) = theta(1939)+theta(1813)*AB(1) ! ((5,0,0)|(1,0,2)) = ((6,0,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(1)
        theta(2594) = theta(1943)+theta(1811)*AB(2) ! ((5,0,0)|(0,3,0)) = ((5,1,0)|(0,2,0))+((5,0,0)|(0,2,0))*AB(2)
        theta(2595) = theta(1949)+theta(1811)*AB(3) ! ((5,0,0)|(0,2,1)) = ((5,0,1)|(0,2,0))+((5,0,0)|(0,2,0))*AB(3)
        theta(2596) = theta(1945)+theta(1813)*AB(2) ! ((5,0,0)|(0,1,2)) = ((5,1,0)|(0,0,2))+((5,0,0)|(0,0,2))*AB(2)
        theta(2597) = theta(1951)+theta(1813)*AB(3) ! ((5,0,0)|(0,0,3)) = ((5,0,1)|(0,0,2))+((5,0,0)|(0,0,2))*AB(3)
        theta(2598) = theta(1940)+theta(1814)*AB(1) ! ((4,1,0)|(3,0,0)) = ((5,1,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(1)
        ! theta(2599) = theta(1952)+theta(1814)*AB(2) ! ((4,1,0)|(2,1,0)) = ((4,2,0)|(2,0,0))+((4,1,0)|(2,0,0))*AB(2)
        ! theta(2600) = theta(1958)+theta(1814)*AB(3) ! ((4,1,0)|(2,0,1)) = ((4,1,1)|(2,0,0))+((4,1,0)|(2,0,0))*AB(3)
        ! theta(2601) = theta(1943)+theta(1817)*AB(1) ! ((4,1,0)|(1,2,0)) = ((5,1,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(1)
        ! theta(2602) = theta(1944)+theta(1818)*AB(1) ! ((4,1,0)|(1,1,1)) = ((5,1,0)|(0,1,1))+((4,1,0)|(0,1,1))*AB(1)
        theta(2603) = theta(1945)+theta(1819)*AB(1) ! ((4,1,0)|(1,0,2)) = ((5,1,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(1)
        theta(2604) = theta(1955)+theta(1817)*AB(2) ! ((4,1,0)|(0,3,0)) = ((4,2,0)|(0,2,0))+((4,1,0)|(0,2,0))*AB(2)
        theta(2605) = theta(1961)+theta(1817)*AB(3) ! ((4,1,0)|(0,2,1)) = ((4,1,1)|(0,2,0))+((4,1,0)|(0,2,0))*AB(3)
        theta(2606) = theta(1957)+theta(1819)*AB(2) ! ((4,1,0)|(0,1,2)) = ((4,2,0)|(0,0,2))+((4,1,0)|(0,0,2))*AB(2)
        theta(2607) = theta(1963)+theta(1819)*AB(3) ! ((4,1,0)|(0,0,3)) = ((4,1,1)|(0,0,2))+((4,1,0)|(0,0,2))*AB(3)
        theta(2608) = theta(1946)+theta(1820)*AB(1) ! ((4,0,1)|(3,0,0)) = ((5,0,1)|(2,0,0))+((4,0,1)|(2,0,0))*AB(1)
        theta(2609) = theta(1947)+theta(1821)*AB(1) ! ((4,0,1)|(2,1,0)) = ((5,0,1)|(1,1,0))+((4,0,1)|(1,1,0))*AB(1)
        ! theta(2610) = theta(1964)+theta(1820)*AB(3) ! ((4,0,1)|(2,0,1)) = ((4,0,2)|(2,0,0))+((4,0,1)|(2,0,0))*AB(3)
        theta(2611) = theta(1949)+theta(1823)*AB(1) ! ((4,0,1)|(1,2,0)) = ((5,0,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(1)
        theta(2612) = theta(1950)+theta(1824)*AB(1) ! ((4,0,1)|(1,1,1)) = ((5,0,1)|(0,1,1))+((4,0,1)|(0,1,1))*AB(1)
        ! theta(2613) = theta(1951)+theta(1825)*AB(1) ! ((4,0,1)|(1,0,2)) = ((5,0,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(1)
        theta(2614) = theta(1961)+theta(1823)*AB(2) ! ((4,0,1)|(0,3,0)) = ((4,1,1)|(0,2,0))+((4,0,1)|(0,2,0))*AB(2)
        theta(2615) = theta(1967)+theta(1823)*AB(3) ! ((4,0,1)|(0,2,1)) = ((4,0,2)|(0,2,0))+((4,0,1)|(0,2,0))*AB(3)
        theta(2616) = theta(1963)+theta(1825)*AB(2) ! ((4,0,1)|(0,1,2)) = ((4,1,1)|(0,0,2))+((4,0,1)|(0,0,2))*AB(2)
        theta(2617) = theta(1969)+theta(1825)*AB(3) ! ((4,0,1)|(0,0,3)) = ((4,0,2)|(0,0,2))+((4,0,1)|(0,0,2))*AB(3)
        theta(2618) = theta(1952)+theta(1826)*AB(1) ! ((3,2,0)|(3,0,0)) = ((4,2,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(1)
        ! theta(2619) = theta(1970)+theta(1826)*AB(2) ! ((3,2,0)|(2,1,0)) = ((3,3,0)|(2,0,0))+((3,2,0)|(2,0,0))*AB(2)
        ! theta(2620) = theta(1976)+theta(1826)*AB(3) ! ((3,2,0)|(2,0,1)) = ((3,2,1)|(2,0,0))+((3,2,0)|(2,0,0))*AB(3)
        ! theta(2621) = theta(1955)+theta(1829)*AB(1) ! ((3,2,0)|(1,2,0)) = ((4,2,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(1)
        ! theta(2622) = theta(1956)+theta(1830)*AB(1) ! ((3,2,0)|(1,1,1)) = ((4,2,0)|(0,1,1))+((3,2,0)|(0,1,1))*AB(1)
        theta(2623) = theta(1957)+theta(1831)*AB(1) ! ((3,2,0)|(1,0,2)) = ((4,2,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(1)
        theta(2624) = theta(1973)+theta(1829)*AB(2) ! ((3,2,0)|(0,3,0)) = ((3,3,0)|(0,2,0))+((3,2,0)|(0,2,0))*AB(2)
        theta(2625) = theta(1979)+theta(1829)*AB(3) ! ((3,2,0)|(0,2,1)) = ((3,2,1)|(0,2,0))+((3,2,0)|(0,2,0))*AB(3)
        theta(2626) = theta(1975)+theta(1831)*AB(2) ! ((3,2,0)|(0,1,2)) = ((3,3,0)|(0,0,2))+((3,2,0)|(0,0,2))*AB(2)
        theta(2627) = theta(1981)+theta(1831)*AB(3) ! ((3,2,0)|(0,0,3)) = ((3,2,1)|(0,0,2))+((3,2,0)|(0,0,2))*AB(3)
        theta(2628) = theta(1958)+theta(1832)*AB(1) ! ((3,1,1)|(3,0,0)) = ((4,1,1)|(2,0,0))+((3,1,1)|(2,0,0))*AB(1)
        theta(2629) = theta(1959)+theta(1833)*AB(1) ! ((3,1,1)|(2,1,0)) = ((4,1,1)|(1,1,0))+((3,1,1)|(1,1,0))*AB(1)
        ! theta(2630) = theta(1982)+theta(1832)*AB(3) ! ((3,1,1)|(2,0,1)) = ((3,1,2)|(2,0,0))+((3,1,1)|(2,0,0))*AB(3)
        theta(2631) = theta(1961)+theta(1835)*AB(1) ! ((3,1,1)|(1,2,0)) = ((4,1,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(1)
        theta(2632) = theta(1962)+theta(1836)*AB(1) ! ((3,1,1)|(1,1,1)) = ((4,1,1)|(0,1,1))+((3,1,1)|(0,1,1))*AB(1)
        ! theta(2633) = theta(1963)+theta(1837)*AB(1) ! ((3,1,1)|(1,0,2)) = ((4,1,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(1)
        theta(2634) = theta(1979)+theta(1835)*AB(2) ! ((3,1,1)|(0,3,0)) = ((3,2,1)|(0,2,0))+((3,1,1)|(0,2,0))*AB(2)
        theta(2635) = theta(1985)+theta(1835)*AB(3) ! ((3,1,1)|(0,2,1)) = ((3,1,2)|(0,2,0))+((3,1,1)|(0,2,0))*AB(3)
        theta(2636) = theta(1981)+theta(1837)*AB(2) ! ((3,1,1)|(0,1,2)) = ((3,2,1)|(0,0,2))+((3,1,1)|(0,0,2))*AB(2)
        theta(2637) = theta(1987)+theta(1837)*AB(3) ! ((3,1,1)|(0,0,3)) = ((3,1,2)|(0,0,2))+((3,1,1)|(0,0,2))*AB(3)
        theta(2638) = theta(1964)+theta(1838)*AB(1) ! ((3,0,2)|(3,0,0)) = ((4,0,2)|(2,0,0))+((3,0,2)|(2,0,0))*AB(1)
        theta(2639) = theta(1965)+theta(1839)*AB(1) ! ((3,0,2)|(2,1,0)) = ((4,0,2)|(1,1,0))+((3,0,2)|(1,1,0))*AB(1)
        ! theta(2640) = theta(1988)+theta(1838)*AB(3) ! ((3,0,2)|(2,0,1)) = ((3,0,3)|(2,0,0))+((3,0,2)|(2,0,0))*AB(3)
        theta(2641) = theta(1967)+theta(1841)*AB(1) ! ((3,0,2)|(1,2,0)) = ((4,0,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(1)
        theta(2642) = theta(1968)+theta(1842)*AB(1) ! ((3,0,2)|(1,1,1)) = ((4,0,2)|(0,1,1))+((3,0,2)|(0,1,1))*AB(1)
        ! theta(2643) = theta(1969)+theta(1843)*AB(1) ! ((3,0,2)|(1,0,2)) = ((4,0,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(1)
        theta(2644) = theta(1985)+theta(1841)*AB(2) ! ((3,0,2)|(0,3,0)) = ((3,1,2)|(0,2,0))+((3,0,2)|(0,2,0))*AB(2)
        theta(2645) = theta(1991)+theta(1841)*AB(3) ! ((3,0,2)|(0,2,1)) = ((3,0,3)|(0,2,0))+((3,0,2)|(0,2,0))*AB(3)
        theta(2646) = theta(1987)+theta(1843)*AB(2) ! ((3,0,2)|(0,1,2)) = ((3,1,2)|(0,0,2))+((3,0,2)|(0,0,2))*AB(2)
        theta(2647) = theta(1993)+theta(1843)*AB(3) ! ((3,0,2)|(0,0,3)) = ((3,0,3)|(0,0,2))+((3,0,2)|(0,0,2))*AB(3)
        theta(2648) = theta(1970)+theta(1844)*AB(1) ! ((2,3,0)|(3,0,0)) = ((3,3,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(1)
        ! theta(2649) = theta(1994)+theta(1844)*AB(2) ! ((2,3,0)|(2,1,0)) = ((2,4,0)|(2,0,0))+((2,3,0)|(2,0,0))*AB(2)
        ! theta(2650) = theta(2000)+theta(1844)*AB(3) ! ((2,3,0)|(2,0,1)) = ((2,3,1)|(2,0,0))+((2,3,0)|(2,0,0))*AB(3)
        ! theta(2651) = theta(1973)+theta(1847)*AB(1) ! ((2,3,0)|(1,2,0)) = ((3,3,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(1)
        ! theta(2652) = theta(1974)+theta(1848)*AB(1) ! ((2,3,0)|(1,1,1)) = ((3,3,0)|(0,1,1))+((2,3,0)|(0,1,1))*AB(1)
        theta(2653) = theta(1975)+theta(1849)*AB(1) ! ((2,3,0)|(1,0,2)) = ((3,3,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(1)
        theta(2654) = theta(1997)+theta(1847)*AB(2) ! ((2,3,0)|(0,3,0)) = ((2,4,0)|(0,2,0))+((2,3,0)|(0,2,0))*AB(2)
        theta(2655) = theta(2003)+theta(1847)*AB(3) ! ((2,3,0)|(0,2,1)) = ((2,3,1)|(0,2,0))+((2,3,0)|(0,2,0))*AB(3)
        theta(2656) = theta(1999)+theta(1849)*AB(2) ! ((2,3,0)|(0,1,2)) = ((2,4,0)|(0,0,2))+((2,3,0)|(0,0,2))*AB(2)
        theta(2657) = theta(2005)+theta(1849)*AB(3) ! ((2,3,0)|(0,0,3)) = ((2,3,1)|(0,0,2))+((2,3,0)|(0,0,2))*AB(3)
        theta(2658) = theta(1976)+theta(1850)*AB(1) ! ((2,2,1)|(3,0,0)) = ((3,2,1)|(2,0,0))+((2,2,1)|(2,0,0))*AB(1)
        theta(2659) = theta(1977)+theta(1851)*AB(1) ! ((2,2,1)|(2,1,0)) = ((3,2,1)|(1,1,0))+((2,2,1)|(1,1,0))*AB(1)
        ! theta(2660) = theta(2006)+theta(1850)*AB(3) ! ((2,2,1)|(2,0,1)) = ((2,2,2)|(2,0,0))+((2,2,1)|(2,0,0))*AB(3)
        theta(2661) = theta(1979)+theta(1853)*AB(1) ! ((2,2,1)|(1,2,0)) = ((3,2,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(1)
        theta(2662) = theta(1980)+theta(1854)*AB(1) ! ((2,2,1)|(1,1,1)) = ((3,2,1)|(0,1,1))+((2,2,1)|(0,1,1))*AB(1)
        ! theta(2663) = theta(1981)+theta(1855)*AB(1) ! ((2,2,1)|(1,0,2)) = ((3,2,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(1)
        theta(2664) = theta(2003)+theta(1853)*AB(2) ! ((2,2,1)|(0,3,0)) = ((2,3,1)|(0,2,0))+((2,2,1)|(0,2,0))*AB(2)
        theta(2665) = theta(2009)+theta(1853)*AB(3) ! ((2,2,1)|(0,2,1)) = ((2,2,2)|(0,2,0))+((2,2,1)|(0,2,0))*AB(3)
        theta(2666) = theta(2005)+theta(1855)*AB(2) ! ((2,2,1)|(0,1,2)) = ((2,3,1)|(0,0,2))+((2,2,1)|(0,0,2))*AB(2)
        theta(2667) = theta(2011)+theta(1855)*AB(3) ! ((2,2,1)|(0,0,3)) = ((2,2,2)|(0,0,2))+((2,2,1)|(0,0,2))*AB(3)
        theta(2668) = theta(1982)+theta(1856)*AB(1) ! ((2,1,2)|(3,0,0)) = ((3,1,2)|(2,0,0))+((2,1,2)|(2,0,0))*AB(1)
        theta(2669) = theta(1983)+theta(1857)*AB(1) ! ((2,1,2)|(2,1,0)) = ((3,1,2)|(1,1,0))+((2,1,2)|(1,1,0))*AB(1)
        ! theta(2670) = theta(2012)+theta(1856)*AB(3) ! ((2,1,2)|(2,0,1)) = ((2,1,3)|(2,0,0))+((2,1,2)|(2,0,0))*AB(3)
        theta(2671) = theta(1985)+theta(1859)*AB(1) ! ((2,1,2)|(1,2,0)) = ((3,1,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(1)
        theta(2672) = theta(1986)+theta(1860)*AB(1) ! ((2,1,2)|(1,1,1)) = ((3,1,2)|(0,1,1))+((2,1,2)|(0,1,1))*AB(1)
        ! theta(2673) = theta(1987)+theta(1861)*AB(1) ! ((2,1,2)|(1,0,2)) = ((3,1,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(1)
        theta(2674) = theta(2009)+theta(1859)*AB(2) ! ((2,1,2)|(0,3,0)) = ((2,2,2)|(0,2,0))+((2,1,2)|(0,2,0))*AB(2)
        theta(2675) = theta(2015)+theta(1859)*AB(3) ! ((2,1,2)|(0,2,1)) = ((2,1,3)|(0,2,0))+((2,1,2)|(0,2,0))*AB(3)
        theta(2676) = theta(2011)+theta(1861)*AB(2) ! ((2,1,2)|(0,1,2)) = ((2,2,2)|(0,0,2))+((2,1,2)|(0,0,2))*AB(2)
        theta(2677) = theta(2017)+theta(1861)*AB(3) ! ((2,1,2)|(0,0,3)) = ((2,1,3)|(0,0,2))+((2,1,2)|(0,0,2))*AB(3)
        theta(2678) = theta(1988)+theta(1862)*AB(1) ! ((2,0,3)|(3,0,0)) = ((3,0,3)|(2,0,0))+((2,0,3)|(2,0,0))*AB(1)
        theta(2679) = theta(1989)+theta(1863)*AB(1) ! ((2,0,3)|(2,1,0)) = ((3,0,3)|(1,1,0))+((2,0,3)|(1,1,0))*AB(1)
        ! theta(2680) = theta(2018)+theta(1862)*AB(3) ! ((2,0,3)|(2,0,1)) = ((2,0,4)|(2,0,0))+((2,0,3)|(2,0,0))*AB(3)
        theta(2681) = theta(1991)+theta(1865)*AB(1) ! ((2,0,3)|(1,2,0)) = ((3,0,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(1)
        theta(2682) = theta(1992)+theta(1866)*AB(1) ! ((2,0,3)|(1,1,1)) = ((3,0,3)|(0,1,1))+((2,0,3)|(0,1,1))*AB(1)
        ! theta(2683) = theta(1993)+theta(1867)*AB(1) ! ((2,0,3)|(1,0,2)) = ((3,0,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(1)
        theta(2684) = theta(2015)+theta(1865)*AB(2) ! ((2,0,3)|(0,3,0)) = ((2,1,3)|(0,2,0))+((2,0,3)|(0,2,0))*AB(2)
        theta(2685) = theta(2021)+theta(1865)*AB(3) ! ((2,0,3)|(0,2,1)) = ((2,0,4)|(0,2,0))+((2,0,3)|(0,2,0))*AB(3)
        theta(2686) = theta(2017)+theta(1867)*AB(2) ! ((2,0,3)|(0,1,2)) = ((2,1,3)|(0,0,2))+((2,0,3)|(0,0,2))*AB(2)
        theta(2687) = theta(2023)+theta(1867)*AB(3) ! ((2,0,3)|(0,0,3)) = ((2,0,4)|(0,0,2))+((2,0,3)|(0,0,2))*AB(3)
        theta(2688) = theta(1994)+theta(1868)*AB(1) ! ((1,4,0)|(3,0,0)) = ((2,4,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(1)
        ! theta(2689) = theta(2024)+theta(1868)*AB(2) ! ((1,4,0)|(2,1,0)) = ((1,5,0)|(2,0,0))+((1,4,0)|(2,0,0))*AB(2)
        ! theta(2690) = theta(2030)+theta(1868)*AB(3) ! ((1,4,0)|(2,0,1)) = ((1,4,1)|(2,0,0))+((1,4,0)|(2,0,0))*AB(3)
        ! theta(2691) = theta(1997)+theta(1871)*AB(1) ! ((1,4,0)|(1,2,0)) = ((2,4,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(1)
        ! theta(2692) = theta(1998)+theta(1872)*AB(1) ! ((1,4,0)|(1,1,1)) = ((2,4,0)|(0,1,1))+((1,4,0)|(0,1,1))*AB(1)
        theta(2693) = theta(1999)+theta(1873)*AB(1) ! ((1,4,0)|(1,0,2)) = ((2,4,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(1)
        theta(2694) = theta(2027)+theta(1871)*AB(2) ! ((1,4,0)|(0,3,0)) = ((1,5,0)|(0,2,0))+((1,4,0)|(0,2,0))*AB(2)
        theta(2695) = theta(2033)+theta(1871)*AB(3) ! ((1,4,0)|(0,2,1)) = ((1,4,1)|(0,2,0))+((1,4,0)|(0,2,0))*AB(3)
        theta(2696) = theta(2029)+theta(1873)*AB(2) ! ((1,4,0)|(0,1,2)) = ((1,5,0)|(0,0,2))+((1,4,0)|(0,0,2))*AB(2)
        theta(2697) = theta(2035)+theta(1873)*AB(3) ! ((1,4,0)|(0,0,3)) = ((1,4,1)|(0,0,2))+((1,4,0)|(0,0,2))*AB(3)
        theta(2698) = theta(2000)+theta(1874)*AB(1) ! ((1,3,1)|(3,0,0)) = ((2,3,1)|(2,0,0))+((1,3,1)|(2,0,0))*AB(1)
        theta(2699) = theta(2001)+theta(1875)*AB(1) ! ((1,3,1)|(2,1,0)) = ((2,3,1)|(1,1,0))+((1,3,1)|(1,1,0))*AB(1)
        ! theta(2700) = theta(2036)+theta(1874)*AB(3) ! ((1,3,1)|(2,0,1)) = ((1,3,2)|(2,0,0))+((1,3,1)|(2,0,0))*AB(3)
        theta(2701) = theta(2003)+theta(1877)*AB(1) ! ((1,3,1)|(1,2,0)) = ((2,3,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(1)
        theta(2702) = theta(2004)+theta(1878)*AB(1) ! ((1,3,1)|(1,1,1)) = ((2,3,1)|(0,1,1))+((1,3,1)|(0,1,1))*AB(1)
        ! theta(2703) = theta(2005)+theta(1879)*AB(1) ! ((1,3,1)|(1,0,2)) = ((2,3,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(1)
        theta(2704) = theta(2033)+theta(1877)*AB(2) ! ((1,3,1)|(0,3,0)) = ((1,4,1)|(0,2,0))+((1,3,1)|(0,2,0))*AB(2)
        theta(2705) = theta(2039)+theta(1877)*AB(3) ! ((1,3,1)|(0,2,1)) = ((1,3,2)|(0,2,0))+((1,3,1)|(0,2,0))*AB(3)
        theta(2706) = theta(2035)+theta(1879)*AB(2) ! ((1,3,1)|(0,1,2)) = ((1,4,1)|(0,0,2))+((1,3,1)|(0,0,2))*AB(2)
        theta(2707) = theta(2041)+theta(1879)*AB(3) ! ((1,3,1)|(0,0,3)) = ((1,3,2)|(0,0,2))+((1,3,1)|(0,0,2))*AB(3)
        theta(2708) = theta(2006)+theta(1880)*AB(1) ! ((1,2,2)|(3,0,0)) = ((2,2,2)|(2,0,0))+((1,2,2)|(2,0,0))*AB(1)
        theta(2709) = theta(2007)+theta(1881)*AB(1) ! ((1,2,2)|(2,1,0)) = ((2,2,2)|(1,1,0))+((1,2,2)|(1,1,0))*AB(1)
        ! theta(2710) = theta(2042)+theta(1880)*AB(3) ! ((1,2,2)|(2,0,1)) = ((1,2,3)|(2,0,0))+((1,2,2)|(2,0,0))*AB(3)
        theta(2711) = theta(2009)+theta(1883)*AB(1) ! ((1,2,2)|(1,2,0)) = ((2,2,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(1)
        theta(2712) = theta(2010)+theta(1884)*AB(1) ! ((1,2,2)|(1,1,1)) = ((2,2,2)|(0,1,1))+((1,2,2)|(0,1,1))*AB(1)
        ! theta(2713) = theta(2011)+theta(1885)*AB(1) ! ((1,2,2)|(1,0,2)) = ((2,2,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(1)
        theta(2714) = theta(2039)+theta(1883)*AB(2) ! ((1,2,2)|(0,3,0)) = ((1,3,2)|(0,2,0))+((1,2,2)|(0,2,0))*AB(2)
        theta(2715) = theta(2045)+theta(1883)*AB(3) ! ((1,2,2)|(0,2,1)) = ((1,2,3)|(0,2,0))+((1,2,2)|(0,2,0))*AB(3)
        theta(2716) = theta(2041)+theta(1885)*AB(2) ! ((1,2,2)|(0,1,2)) = ((1,3,2)|(0,0,2))+((1,2,2)|(0,0,2))*AB(2)
        theta(2717) = theta(2047)+theta(1885)*AB(3) ! ((1,2,2)|(0,0,3)) = ((1,2,3)|(0,0,2))+((1,2,2)|(0,0,2))*AB(3)
        theta(2718) = theta(2012)+theta(1886)*AB(1) ! ((1,1,3)|(3,0,0)) = ((2,1,3)|(2,0,0))+((1,1,3)|(2,0,0))*AB(1)
        theta(2719) = theta(2013)+theta(1887)*AB(1) ! ((1,1,3)|(2,1,0)) = ((2,1,3)|(1,1,0))+((1,1,3)|(1,1,0))*AB(1)
        ! theta(2720) = theta(2048)+theta(1886)*AB(3) ! ((1,1,3)|(2,0,1)) = ((1,1,4)|(2,0,0))+((1,1,3)|(2,0,0))*AB(3)
        theta(2721) = theta(2015)+theta(1889)*AB(1) ! ((1,1,3)|(1,2,0)) = ((2,1,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(1)
        theta(2722) = theta(2016)+theta(1890)*AB(1) ! ((1,1,3)|(1,1,1)) = ((2,1,3)|(0,1,1))+((1,1,3)|(0,1,1))*AB(1)
        ! theta(2723) = theta(2017)+theta(1891)*AB(1) ! ((1,1,3)|(1,0,2)) = ((2,1,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(1)
        theta(2724) = theta(2045)+theta(1889)*AB(2) ! ((1,1,3)|(0,3,0)) = ((1,2,3)|(0,2,0))+((1,1,3)|(0,2,0))*AB(2)
        theta(2725) = theta(2051)+theta(1889)*AB(3) ! ((1,1,3)|(0,2,1)) = ((1,1,4)|(0,2,0))+((1,1,3)|(0,2,0))*AB(3)
        theta(2726) = theta(2047)+theta(1891)*AB(2) ! ((1,1,3)|(0,1,2)) = ((1,2,3)|(0,0,2))+((1,1,3)|(0,0,2))*AB(2)
        theta(2727) = theta(2053)+theta(1891)*AB(3) ! ((1,1,3)|(0,0,3)) = ((1,1,4)|(0,0,2))+((1,1,3)|(0,0,2))*AB(3)
        theta(2728) = theta(2018)+theta(1892)*AB(1) ! ((1,0,4)|(3,0,0)) = ((2,0,4)|(2,0,0))+((1,0,4)|(2,0,0))*AB(1)
        theta(2729) = theta(2019)+theta(1893)*AB(1) ! ((1,0,4)|(2,1,0)) = ((2,0,4)|(1,1,0))+((1,0,4)|(1,1,0))*AB(1)
        ! theta(2730) = theta(2054)+theta(1892)*AB(3) ! ((1,0,4)|(2,0,1)) = ((1,0,5)|(2,0,0))+((1,0,4)|(2,0,0))*AB(3)
        theta(2731) = theta(2021)+theta(1895)*AB(1) ! ((1,0,4)|(1,2,0)) = ((2,0,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(1)
        theta(2732) = theta(2022)+theta(1896)*AB(1) ! ((1,0,4)|(1,1,1)) = ((2,0,4)|(0,1,1))+((1,0,4)|(0,1,1))*AB(1)
        ! theta(2733) = theta(2023)+theta(1897)*AB(1) ! ((1,0,4)|(1,0,2)) = ((2,0,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(1)
        theta(2734) = theta(2051)+theta(1895)*AB(2) ! ((1,0,4)|(0,3,0)) = ((1,1,4)|(0,2,0))+((1,0,4)|(0,2,0))*AB(2)
        theta(2735) = theta(2057)+theta(1895)*AB(3) ! ((1,0,4)|(0,2,1)) = ((1,0,5)|(0,2,0))+((1,0,4)|(0,2,0))*AB(3)
        theta(2736) = theta(2053)+theta(1897)*AB(2) ! ((1,0,4)|(0,1,2)) = ((1,1,4)|(0,0,2))+((1,0,4)|(0,0,2))*AB(2)
        theta(2737) = theta(2059)+theta(1897)*AB(3) ! ((1,0,4)|(0,0,3)) = ((1,0,5)|(0,0,2))+((1,0,4)|(0,0,2))*AB(3)
        theta(2738) = theta(2024)+theta(1898)*AB(1) ! ((0,5,0)|(3,0,0)) = ((1,5,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(1)
        ! theta(2739) = theta(2060)+theta(1898)*AB(2) ! ((0,5,0)|(2,1,0)) = ((0,6,0)|(2,0,0))+((0,5,0)|(2,0,0))*AB(2)
        ! theta(2740) = theta(2066)+theta(1898)*AB(3) ! ((0,5,0)|(2,0,1)) = ((0,5,1)|(2,0,0))+((0,5,0)|(2,0,0))*AB(3)
        ! theta(2741) = theta(2027)+theta(1901)*AB(1) ! ((0,5,0)|(1,2,0)) = ((1,5,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(1)
        ! theta(2742) = theta(2028)+theta(1902)*AB(1) ! ((0,5,0)|(1,1,1)) = ((1,5,0)|(0,1,1))+((0,5,0)|(0,1,1))*AB(1)
        theta(2743) = theta(2029)+theta(1903)*AB(1) ! ((0,5,0)|(1,0,2)) = ((1,5,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(1)
        theta(2744) = theta(2063)+theta(1901)*AB(2) ! ((0,5,0)|(0,3,0)) = ((0,6,0)|(0,2,0))+((0,5,0)|(0,2,0))*AB(2)
        theta(2745) = theta(2069)+theta(1901)*AB(3) ! ((0,5,0)|(0,2,1)) = ((0,5,1)|(0,2,0))+((0,5,0)|(0,2,0))*AB(3)
        theta(2746) = theta(2065)+theta(1903)*AB(2) ! ((0,5,0)|(0,1,2)) = ((0,6,0)|(0,0,2))+((0,5,0)|(0,0,2))*AB(2)
        theta(2747) = theta(2071)+theta(1903)*AB(3) ! ((0,5,0)|(0,0,3)) = ((0,5,1)|(0,0,2))+((0,5,0)|(0,0,2))*AB(3)
        theta(2748) = theta(2030)+theta(1904)*AB(1) ! ((0,4,1)|(3,0,0)) = ((1,4,1)|(2,0,0))+((0,4,1)|(2,0,0))*AB(1)
        theta(2749) = theta(2031)+theta(1905)*AB(1) ! ((0,4,1)|(2,1,0)) = ((1,4,1)|(1,1,0))+((0,4,1)|(1,1,0))*AB(1)
        ! theta(2750) = theta(2072)+theta(1904)*AB(3) ! ((0,4,1)|(2,0,1)) = ((0,4,2)|(2,0,0))+((0,4,1)|(2,0,0))*AB(3)
        theta(2751) = theta(2033)+theta(1907)*AB(1) ! ((0,4,1)|(1,2,0)) = ((1,4,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(1)
        theta(2752) = theta(2034)+theta(1908)*AB(1) ! ((0,4,1)|(1,1,1)) = ((1,4,1)|(0,1,1))+((0,4,1)|(0,1,1))*AB(1)
        ! theta(2753) = theta(2035)+theta(1909)*AB(1) ! ((0,4,1)|(1,0,2)) = ((1,4,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(1)
        theta(2754) = theta(2069)+theta(1907)*AB(2) ! ((0,4,1)|(0,3,0)) = ((0,5,1)|(0,2,0))+((0,4,1)|(0,2,0))*AB(2)
        theta(2755) = theta(2075)+theta(1907)*AB(3) ! ((0,4,1)|(0,2,1)) = ((0,4,2)|(0,2,0))+((0,4,1)|(0,2,0))*AB(3)
        theta(2756) = theta(2071)+theta(1909)*AB(2) ! ((0,4,1)|(0,1,2)) = ((0,5,1)|(0,0,2))+((0,4,1)|(0,0,2))*AB(2)
        theta(2757) = theta(2077)+theta(1909)*AB(3) ! ((0,4,1)|(0,0,3)) = ((0,4,2)|(0,0,2))+((0,4,1)|(0,0,2))*AB(3)
        theta(2758) = theta(2036)+theta(1910)*AB(1) ! ((0,3,2)|(3,0,0)) = ((1,3,2)|(2,0,0))+((0,3,2)|(2,0,0))*AB(1)
        theta(2759) = theta(2037)+theta(1911)*AB(1) ! ((0,3,2)|(2,1,0)) = ((1,3,2)|(1,1,0))+((0,3,2)|(1,1,0))*AB(1)
        ! theta(2760) = theta(2078)+theta(1910)*AB(3) ! ((0,3,2)|(2,0,1)) = ((0,3,3)|(2,0,0))+((0,3,2)|(2,0,0))*AB(3)
        theta(2761) = theta(2039)+theta(1913)*AB(1) ! ((0,3,2)|(1,2,0)) = ((1,3,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(1)
        theta(2762) = theta(2040)+theta(1914)*AB(1) ! ((0,3,2)|(1,1,1)) = ((1,3,2)|(0,1,1))+((0,3,2)|(0,1,1))*AB(1)
        ! theta(2763) = theta(2041)+theta(1915)*AB(1) ! ((0,3,2)|(1,0,2)) = ((1,3,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(1)
        theta(2764) = theta(2075)+theta(1913)*AB(2) ! ((0,3,2)|(0,3,0)) = ((0,4,2)|(0,2,0))+((0,3,2)|(0,2,0))*AB(2)
        theta(2765) = theta(2081)+theta(1913)*AB(3) ! ((0,3,2)|(0,2,1)) = ((0,3,3)|(0,2,0))+((0,3,2)|(0,2,0))*AB(3)
        theta(2766) = theta(2077)+theta(1915)*AB(2) ! ((0,3,2)|(0,1,2)) = ((0,4,2)|(0,0,2))+((0,3,2)|(0,0,2))*AB(2)
        theta(2767) = theta(2083)+theta(1915)*AB(3) ! ((0,3,2)|(0,0,3)) = ((0,3,3)|(0,0,2))+((0,3,2)|(0,0,2))*AB(3)
        theta(2768) = theta(2042)+theta(1916)*AB(1) ! ((0,2,3)|(3,0,0)) = ((1,2,3)|(2,0,0))+((0,2,3)|(2,0,0))*AB(1)
        theta(2769) = theta(2043)+theta(1917)*AB(1) ! ((0,2,3)|(2,1,0)) = ((1,2,3)|(1,1,0))+((0,2,3)|(1,1,0))*AB(1)
        ! theta(2770) = theta(2084)+theta(1916)*AB(3) ! ((0,2,3)|(2,0,1)) = ((0,2,4)|(2,0,0))+((0,2,3)|(2,0,0))*AB(3)
        theta(2771) = theta(2045)+theta(1919)*AB(1) ! ((0,2,3)|(1,2,0)) = ((1,2,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(1)
        theta(2772) = theta(2046)+theta(1920)*AB(1) ! ((0,2,3)|(1,1,1)) = ((1,2,3)|(0,1,1))+((0,2,3)|(0,1,1))*AB(1)
        ! theta(2773) = theta(2047)+theta(1921)*AB(1) ! ((0,2,3)|(1,0,2)) = ((1,2,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(1)
        theta(2774) = theta(2081)+theta(1919)*AB(2) ! ((0,2,3)|(0,3,0)) = ((0,3,3)|(0,2,0))+((0,2,3)|(0,2,0))*AB(2)
        theta(2775) = theta(2087)+theta(1919)*AB(3) ! ((0,2,3)|(0,2,1)) = ((0,2,4)|(0,2,0))+((0,2,3)|(0,2,0))*AB(3)
        theta(2776) = theta(2083)+theta(1921)*AB(2) ! ((0,2,3)|(0,1,2)) = ((0,3,3)|(0,0,2))+((0,2,3)|(0,0,2))*AB(2)
        theta(2777) = theta(2089)+theta(1921)*AB(3) ! ((0,2,3)|(0,0,3)) = ((0,2,4)|(0,0,2))+((0,2,3)|(0,0,2))*AB(3)
        theta(2778) = theta(2048)+theta(1922)*AB(1) ! ((0,1,4)|(3,0,0)) = ((1,1,4)|(2,0,0))+((0,1,4)|(2,0,0))*AB(1)
        theta(2779) = theta(2049)+theta(1923)*AB(1) ! ((0,1,4)|(2,1,0)) = ((1,1,4)|(1,1,0))+((0,1,4)|(1,1,0))*AB(1)
        ! theta(2780) = theta(2090)+theta(1922)*AB(3) ! ((0,1,4)|(2,0,1)) = ((0,1,5)|(2,0,0))+((0,1,4)|(2,0,0))*AB(3)
        theta(2781) = theta(2051)+theta(1925)*AB(1) ! ((0,1,4)|(1,2,0)) = ((1,1,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(1)
        theta(2782) = theta(2052)+theta(1926)*AB(1) ! ((0,1,4)|(1,1,1)) = ((1,1,4)|(0,1,1))+((0,1,4)|(0,1,1))*AB(1)
        ! theta(2783) = theta(2053)+theta(1927)*AB(1) ! ((0,1,4)|(1,0,2)) = ((1,1,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(1)
        theta(2784) = theta(2087)+theta(1925)*AB(2) ! ((0,1,4)|(0,3,0)) = ((0,2,4)|(0,2,0))+((0,1,4)|(0,2,0))*AB(2)
        theta(2785) = theta(2093)+theta(1925)*AB(3) ! ((0,1,4)|(0,2,1)) = ((0,1,5)|(0,2,0))+((0,1,4)|(0,2,0))*AB(3)
        theta(2786) = theta(2089)+theta(1927)*AB(2) ! ((0,1,4)|(0,1,2)) = ((0,2,4)|(0,0,2))+((0,1,4)|(0,0,2))*AB(2)
        theta(2787) = theta(2095)+theta(1927)*AB(3) ! ((0,1,4)|(0,0,3)) = ((0,1,5)|(0,0,2))+((0,1,4)|(0,0,2))*AB(3)
        theta(2788) = theta(2054)+theta(1928)*AB(1) ! ((0,0,5)|(3,0,0)) = ((1,0,5)|(2,0,0))+((0,0,5)|(2,0,0))*AB(1)
        theta(2789) = theta(2055)+theta(1929)*AB(1) ! ((0,0,5)|(2,1,0)) = ((1,0,5)|(1,1,0))+((0,0,5)|(1,1,0))*AB(1)
        ! theta(2790) = theta(2096)+theta(1928)*AB(3) ! ((0,0,5)|(2,0,1)) = ((0,0,6)|(2,0,0))+((0,0,5)|(2,0,0))*AB(3)
        theta(2791) = theta(2057)+theta(1931)*AB(1) ! ((0,0,5)|(1,2,0)) = ((1,0,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(1)
        theta(2792) = theta(2058)+theta(1932)*AB(1) ! ((0,0,5)|(1,1,1)) = ((1,0,5)|(0,1,1))+((0,0,5)|(0,1,1))*AB(1)
        ! theta(2793) = theta(2059)+theta(1933)*AB(1) ! ((0,0,5)|(1,0,2)) = ((1,0,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(1)
        theta(2794) = theta(2093)+theta(1931)*AB(2) ! ((0,0,5)|(0,3,0)) = ((0,1,5)|(0,2,0))+((0,0,5)|(0,2,0))*AB(2)
        theta(2795) = theta(2099)+theta(1931)*AB(3) ! ((0,0,5)|(0,2,1)) = ((0,0,6)|(0,2,0))+((0,0,5)|(0,2,0))*AB(3)
        theta(2796) = theta(2095)+theta(1933)*AB(2) ! ((0,0,5)|(0,1,2)) = ((0,1,5)|(0,0,2))+((0,0,5)|(0,0,2))*AB(2)
        theta(2797) = theta(2101)+theta(1933)*AB(3) ! ((0,0,5)|(0,0,3)) = ((0,0,6)|(0,0,2))+((0,0,5)|(0,0,2))*AB(3)
        theta(2798) = theta(2102)+theta(1934)*AB(1) ! ((6,0,0)|(3,0,0)) = ((7,0,0)|(2,0,0))+((6,0,0)|(2,0,0))*AB(1)
        ! theta(2799) = theta(2108)+theta(1934)*AB(2) ! ((6,0,0)|(2,1,0)) = ((6,1,0)|(2,0,0))+((6,0,0)|(2,0,0))*AB(2)
        ! theta(2800) = theta(2114)+theta(1934)*AB(3) ! ((6,0,0)|(2,0,1)) = ((6,0,1)|(2,0,0))+((6,0,0)|(2,0,0))*AB(3)
        ! theta(2801) = theta(2105)+theta(1937)*AB(1) ! ((6,0,0)|(1,2,0)) = ((7,0,0)|(0,2,0))+((6,0,0)|(0,2,0))*AB(1)
        ! theta(2802) = theta(2106)+theta(1938)*AB(1) ! ((6,0,0)|(1,1,1)) = ((7,0,0)|(0,1,1))+((6,0,0)|(0,1,1))*AB(1)
        theta(2803) = theta(2107)+theta(1939)*AB(1) ! ((6,0,0)|(1,0,2)) = ((7,0,0)|(0,0,2))+((6,0,0)|(0,0,2))*AB(1)
        theta(2804) = theta(2111)+theta(1937)*AB(2) ! ((6,0,0)|(0,3,0)) = ((6,1,0)|(0,2,0))+((6,0,0)|(0,2,0))*AB(2)
        theta(2805) = theta(2117)+theta(1937)*AB(3) ! ((6,0,0)|(0,2,1)) = ((6,0,1)|(0,2,0))+((6,0,0)|(0,2,0))*AB(3)
        theta(2806) = theta(2113)+theta(1939)*AB(2) ! ((6,0,0)|(0,1,2)) = ((6,1,0)|(0,0,2))+((6,0,0)|(0,0,2))*AB(2)
        theta(2807) = theta(2119)+theta(1939)*AB(3) ! ((6,0,0)|(0,0,3)) = ((6,0,1)|(0,0,2))+((6,0,0)|(0,0,2))*AB(3)
        theta(2808) = theta(2108)+theta(1940)*AB(1) ! ((5,1,0)|(3,0,0)) = ((6,1,0)|(2,0,0))+((5,1,0)|(2,0,0))*AB(1)
        ! theta(2809) = theta(2120)+theta(1940)*AB(2) ! ((5,1,0)|(2,1,0)) = ((5,2,0)|(2,0,0))+((5,1,0)|(2,0,0))*AB(2)
        ! theta(2810) = theta(2126)+theta(1940)*AB(3) ! ((5,1,0)|(2,0,1)) = ((5,1,1)|(2,0,0))+((5,1,0)|(2,0,0))*AB(3)
        ! theta(2811) = theta(2111)+theta(1943)*AB(1) ! ((5,1,0)|(1,2,0)) = ((6,1,0)|(0,2,0))+((5,1,0)|(0,2,0))*AB(1)
        ! theta(2812) = theta(2112)+theta(1944)*AB(1) ! ((5,1,0)|(1,1,1)) = ((6,1,0)|(0,1,1))+((5,1,0)|(0,1,1))*AB(1)
        theta(2813) = theta(2113)+theta(1945)*AB(1) ! ((5,1,0)|(1,0,2)) = ((6,1,0)|(0,0,2))+((5,1,0)|(0,0,2))*AB(1)
        theta(2814) = theta(2123)+theta(1943)*AB(2) ! ((5,1,0)|(0,3,0)) = ((5,2,0)|(0,2,0))+((5,1,0)|(0,2,0))*AB(2)
        theta(2815) = theta(2129)+theta(1943)*AB(3) ! ((5,1,0)|(0,2,1)) = ((5,1,1)|(0,2,0))+((5,1,0)|(0,2,0))*AB(3)
        theta(2816) = theta(2125)+theta(1945)*AB(2) ! ((5,1,0)|(0,1,2)) = ((5,2,0)|(0,0,2))+((5,1,0)|(0,0,2))*AB(2)
        theta(2817) = theta(2131)+theta(1945)*AB(3) ! ((5,1,0)|(0,0,3)) = ((5,1,1)|(0,0,2))+((5,1,0)|(0,0,2))*AB(3)
        theta(2818) = theta(2114)+theta(1946)*AB(1) ! ((5,0,1)|(3,0,0)) = ((6,0,1)|(2,0,0))+((5,0,1)|(2,0,0))*AB(1)
        theta(2819) = theta(2115)+theta(1947)*AB(1) ! ((5,0,1)|(2,1,0)) = ((6,0,1)|(1,1,0))+((5,0,1)|(1,1,0))*AB(1)
        ! theta(2820) = theta(2132)+theta(1946)*AB(3) ! ((5,0,1)|(2,0,1)) = ((5,0,2)|(2,0,0))+((5,0,1)|(2,0,0))*AB(3)
        theta(2821) = theta(2117)+theta(1949)*AB(1) ! ((5,0,1)|(1,2,0)) = ((6,0,1)|(0,2,0))+((5,0,1)|(0,2,0))*AB(1)
        theta(2822) = theta(2118)+theta(1950)*AB(1) ! ((5,0,1)|(1,1,1)) = ((6,0,1)|(0,1,1))+((5,0,1)|(0,1,1))*AB(1)
        ! theta(2823) = theta(2119)+theta(1951)*AB(1) ! ((5,0,1)|(1,0,2)) = ((6,0,1)|(0,0,2))+((5,0,1)|(0,0,2))*AB(1)
        theta(2824) = theta(2129)+theta(1949)*AB(2) ! ((5,0,1)|(0,3,0)) = ((5,1,1)|(0,2,0))+((5,0,1)|(0,2,0))*AB(2)
        theta(2825) = theta(2135)+theta(1949)*AB(3) ! ((5,0,1)|(0,2,1)) = ((5,0,2)|(0,2,0))+((5,0,1)|(0,2,0))*AB(3)
        theta(2826) = theta(2131)+theta(1951)*AB(2) ! ((5,0,1)|(0,1,2)) = ((5,1,1)|(0,0,2))+((5,0,1)|(0,0,2))*AB(2)
        theta(2827) = theta(2137)+theta(1951)*AB(3) ! ((5,0,1)|(0,0,3)) = ((5,0,2)|(0,0,2))+((5,0,1)|(0,0,2))*AB(3)
        theta(2828) = theta(2120)+theta(1952)*AB(1) ! ((4,2,0)|(3,0,0)) = ((5,2,0)|(2,0,0))+((4,2,0)|(2,0,0))*AB(1)
        ! theta(2829) = theta(2138)+theta(1952)*AB(2) ! ((4,2,0)|(2,1,0)) = ((4,3,0)|(2,0,0))+((4,2,0)|(2,0,0))*AB(2)
        ! theta(2830) = theta(2144)+theta(1952)*AB(3) ! ((4,2,0)|(2,0,1)) = ((4,2,1)|(2,0,0))+((4,2,0)|(2,0,0))*AB(3)
        ! theta(2831) = theta(2123)+theta(1955)*AB(1) ! ((4,2,0)|(1,2,0)) = ((5,2,0)|(0,2,0))+((4,2,0)|(0,2,0))*AB(1)
        ! theta(2832) = theta(2124)+theta(1956)*AB(1) ! ((4,2,0)|(1,1,1)) = ((5,2,0)|(0,1,1))+((4,2,0)|(0,1,1))*AB(1)
        theta(2833) = theta(2125)+theta(1957)*AB(1) ! ((4,2,0)|(1,0,2)) = ((5,2,0)|(0,0,2))+((4,2,0)|(0,0,2))*AB(1)
        theta(2834) = theta(2141)+theta(1955)*AB(2) ! ((4,2,0)|(0,3,0)) = ((4,3,0)|(0,2,0))+((4,2,0)|(0,2,0))*AB(2)
        theta(2835) = theta(2147)+theta(1955)*AB(3) ! ((4,2,0)|(0,2,1)) = ((4,2,1)|(0,2,0))+((4,2,0)|(0,2,0))*AB(3)
        theta(2836) = theta(2143)+theta(1957)*AB(2) ! ((4,2,0)|(0,1,2)) = ((4,3,0)|(0,0,2))+((4,2,0)|(0,0,2))*AB(2)
        theta(2837) = theta(2149)+theta(1957)*AB(3) ! ((4,2,0)|(0,0,3)) = ((4,2,1)|(0,0,2))+((4,2,0)|(0,0,2))*AB(3)
        theta(2838) = theta(2126)+theta(1958)*AB(1) ! ((4,1,1)|(3,0,0)) = ((5,1,1)|(2,0,0))+((4,1,1)|(2,0,0))*AB(1)
        theta(2839) = theta(2127)+theta(1959)*AB(1) ! ((4,1,1)|(2,1,0)) = ((5,1,1)|(1,1,0))+((4,1,1)|(1,1,0))*AB(1)
        ! theta(2840) = theta(2150)+theta(1958)*AB(3) ! ((4,1,1)|(2,0,1)) = ((4,1,2)|(2,0,0))+((4,1,1)|(2,0,0))*AB(3)
        theta(2841) = theta(2129)+theta(1961)*AB(1) ! ((4,1,1)|(1,2,0)) = ((5,1,1)|(0,2,0))+((4,1,1)|(0,2,0))*AB(1)
        theta(2842) = theta(2130)+theta(1962)*AB(1) ! ((4,1,1)|(1,1,1)) = ((5,1,1)|(0,1,1))+((4,1,1)|(0,1,1))*AB(1)
        ! theta(2843) = theta(2131)+theta(1963)*AB(1) ! ((4,1,1)|(1,0,2)) = ((5,1,1)|(0,0,2))+((4,1,1)|(0,0,2))*AB(1)
        theta(2844) = theta(2147)+theta(1961)*AB(2) ! ((4,1,1)|(0,3,0)) = ((4,2,1)|(0,2,0))+((4,1,1)|(0,2,0))*AB(2)
        theta(2845) = theta(2153)+theta(1961)*AB(3) ! ((4,1,1)|(0,2,1)) = ((4,1,2)|(0,2,0))+((4,1,1)|(0,2,0))*AB(3)
        theta(2846) = theta(2149)+theta(1963)*AB(2) ! ((4,1,1)|(0,1,2)) = ((4,2,1)|(0,0,2))+((4,1,1)|(0,0,2))*AB(2)
        theta(2847) = theta(2155)+theta(1963)*AB(3) ! ((4,1,1)|(0,0,3)) = ((4,1,2)|(0,0,2))+((4,1,1)|(0,0,2))*AB(3)
        theta(2848) = theta(2132)+theta(1964)*AB(1) ! ((4,0,2)|(3,0,0)) = ((5,0,2)|(2,0,0))+((4,0,2)|(2,0,0))*AB(1)
        theta(2849) = theta(2133)+theta(1965)*AB(1) ! ((4,0,2)|(2,1,0)) = ((5,0,2)|(1,1,0))+((4,0,2)|(1,1,0))*AB(1)
        ! theta(2850) = theta(2156)+theta(1964)*AB(3) ! ((4,0,2)|(2,0,1)) = ((4,0,3)|(2,0,0))+((4,0,2)|(2,0,0))*AB(3)
        theta(2851) = theta(2135)+theta(1967)*AB(1) ! ((4,0,2)|(1,2,0)) = ((5,0,2)|(0,2,0))+((4,0,2)|(0,2,0))*AB(1)
        theta(2852) = theta(2136)+theta(1968)*AB(1) ! ((4,0,2)|(1,1,1)) = ((5,0,2)|(0,1,1))+((4,0,2)|(0,1,1))*AB(1)
        ! theta(2853) = theta(2137)+theta(1969)*AB(1) ! ((4,0,2)|(1,0,2)) = ((5,0,2)|(0,0,2))+((4,0,2)|(0,0,2))*AB(1)
        theta(2854) = theta(2153)+theta(1967)*AB(2) ! ((4,0,2)|(0,3,0)) = ((4,1,2)|(0,2,0))+((4,0,2)|(0,2,0))*AB(2)
        theta(2855) = theta(2159)+theta(1967)*AB(3) ! ((4,0,2)|(0,2,1)) = ((4,0,3)|(0,2,0))+((4,0,2)|(0,2,0))*AB(3)
        theta(2856) = theta(2155)+theta(1969)*AB(2) ! ((4,0,2)|(0,1,2)) = ((4,1,2)|(0,0,2))+((4,0,2)|(0,0,2))*AB(2)
        theta(2857) = theta(2161)+theta(1969)*AB(3) ! ((4,0,2)|(0,0,3)) = ((4,0,3)|(0,0,2))+((4,0,2)|(0,0,2))*AB(3)
        theta(2858) = theta(2138)+theta(1970)*AB(1) ! ((3,3,0)|(3,0,0)) = ((4,3,0)|(2,0,0))+((3,3,0)|(2,0,0))*AB(1)
        ! theta(2859) = theta(2162)+theta(1970)*AB(2) ! ((3,3,0)|(2,1,0)) = ((3,4,0)|(2,0,0))+((3,3,0)|(2,0,0))*AB(2)
        ! theta(2860) = theta(2168)+theta(1970)*AB(3) ! ((3,3,0)|(2,0,1)) = ((3,3,1)|(2,0,0))+((3,3,0)|(2,0,0))*AB(3)
        ! theta(2861) = theta(2141)+theta(1973)*AB(1) ! ((3,3,0)|(1,2,0)) = ((4,3,0)|(0,2,0))+((3,3,0)|(0,2,0))*AB(1)
        ! theta(2862) = theta(2142)+theta(1974)*AB(1) ! ((3,3,0)|(1,1,1)) = ((4,3,0)|(0,1,1))+((3,3,0)|(0,1,1))*AB(1)
        theta(2863) = theta(2143)+theta(1975)*AB(1) ! ((3,3,0)|(1,0,2)) = ((4,3,0)|(0,0,2))+((3,3,0)|(0,0,2))*AB(1)
        theta(2864) = theta(2165)+theta(1973)*AB(2) ! ((3,3,0)|(0,3,0)) = ((3,4,0)|(0,2,0))+((3,3,0)|(0,2,0))*AB(2)
        theta(2865) = theta(2171)+theta(1973)*AB(3) ! ((3,3,0)|(0,2,1)) = ((3,3,1)|(0,2,0))+((3,3,0)|(0,2,0))*AB(3)
        theta(2866) = theta(2167)+theta(1975)*AB(2) ! ((3,3,0)|(0,1,2)) = ((3,4,0)|(0,0,2))+((3,3,0)|(0,0,2))*AB(2)
        theta(2867) = theta(2173)+theta(1975)*AB(3) ! ((3,3,0)|(0,0,3)) = ((3,3,1)|(0,0,2))+((3,3,0)|(0,0,2))*AB(3)
        theta(2868) = theta(2144)+theta(1976)*AB(1) ! ((3,2,1)|(3,0,0)) = ((4,2,1)|(2,0,0))+((3,2,1)|(2,0,0))*AB(1)
        theta(2869) = theta(2145)+theta(1977)*AB(1) ! ((3,2,1)|(2,1,0)) = ((4,2,1)|(1,1,0))+((3,2,1)|(1,1,0))*AB(1)
        ! theta(2870) = theta(2174)+theta(1976)*AB(3) ! ((3,2,1)|(2,0,1)) = ((3,2,2)|(2,0,0))+((3,2,1)|(2,0,0))*AB(3)
        theta(2871) = theta(2147)+theta(1979)*AB(1) ! ((3,2,1)|(1,2,0)) = ((4,2,1)|(0,2,0))+((3,2,1)|(0,2,0))*AB(1)
        theta(2872) = theta(2148)+theta(1980)*AB(1) ! ((3,2,1)|(1,1,1)) = ((4,2,1)|(0,1,1))+((3,2,1)|(0,1,1))*AB(1)
        ! theta(2873) = theta(2149)+theta(1981)*AB(1) ! ((3,2,1)|(1,0,2)) = ((4,2,1)|(0,0,2))+((3,2,1)|(0,0,2))*AB(1)
        theta(2874) = theta(2171)+theta(1979)*AB(2) ! ((3,2,1)|(0,3,0)) = ((3,3,1)|(0,2,0))+((3,2,1)|(0,2,0))*AB(2)
        theta(2875) = theta(2177)+theta(1979)*AB(3) ! ((3,2,1)|(0,2,1)) = ((3,2,2)|(0,2,0))+((3,2,1)|(0,2,0))*AB(3)
        theta(2876) = theta(2173)+theta(1981)*AB(2) ! ((3,2,1)|(0,1,2)) = ((3,3,1)|(0,0,2))+((3,2,1)|(0,0,2))*AB(2)
        theta(2877) = theta(2179)+theta(1981)*AB(3) ! ((3,2,1)|(0,0,3)) = ((3,2,2)|(0,0,2))+((3,2,1)|(0,0,2))*AB(3)
        theta(2878) = theta(2150)+theta(1982)*AB(1) ! ((3,1,2)|(3,0,0)) = ((4,1,2)|(2,0,0))+((3,1,2)|(2,0,0))*AB(1)
        theta(2879) = theta(2151)+theta(1983)*AB(1) ! ((3,1,2)|(2,1,0)) = ((4,1,2)|(1,1,0))+((3,1,2)|(1,1,0))*AB(1)
        ! theta(2880) = theta(2180)+theta(1982)*AB(3) ! ((3,1,2)|(2,0,1)) = ((3,1,3)|(2,0,0))+((3,1,2)|(2,0,0))*AB(3)
        theta(2881) = theta(2153)+theta(1985)*AB(1) ! ((3,1,2)|(1,2,0)) = ((4,1,2)|(0,2,0))+((3,1,2)|(0,2,0))*AB(1)
        theta(2882) = theta(2154)+theta(1986)*AB(1) ! ((3,1,2)|(1,1,1)) = ((4,1,2)|(0,1,1))+((3,1,2)|(0,1,1))*AB(1)
        ! theta(2883) = theta(2155)+theta(1987)*AB(1) ! ((3,1,2)|(1,0,2)) = ((4,1,2)|(0,0,2))+((3,1,2)|(0,0,2))*AB(1)
        theta(2884) = theta(2177)+theta(1985)*AB(2) ! ((3,1,2)|(0,3,0)) = ((3,2,2)|(0,2,0))+((3,1,2)|(0,2,0))*AB(2)
        theta(2885) = theta(2183)+theta(1985)*AB(3) ! ((3,1,2)|(0,2,1)) = ((3,1,3)|(0,2,0))+((3,1,2)|(0,2,0))*AB(3)
        theta(2886) = theta(2179)+theta(1987)*AB(2) ! ((3,1,2)|(0,1,2)) = ((3,2,2)|(0,0,2))+((3,1,2)|(0,0,2))*AB(2)
        theta(2887) = theta(2185)+theta(1987)*AB(3) ! ((3,1,2)|(0,0,3)) = ((3,1,3)|(0,0,2))+((3,1,2)|(0,0,2))*AB(3)
        theta(2888) = theta(2156)+theta(1988)*AB(1) ! ((3,0,3)|(3,0,0)) = ((4,0,3)|(2,0,0))+((3,0,3)|(2,0,0))*AB(1)
        theta(2889) = theta(2157)+theta(1989)*AB(1) ! ((3,0,3)|(2,1,0)) = ((4,0,3)|(1,1,0))+((3,0,3)|(1,1,0))*AB(1)
        ! theta(2890) = theta(2186)+theta(1988)*AB(3) ! ((3,0,3)|(2,0,1)) = ((3,0,4)|(2,0,0))+((3,0,3)|(2,0,0))*AB(3)
        theta(2891) = theta(2159)+theta(1991)*AB(1) ! ((3,0,3)|(1,2,0)) = ((4,0,3)|(0,2,0))+((3,0,3)|(0,2,0))*AB(1)
        theta(2892) = theta(2160)+theta(1992)*AB(1) ! ((3,0,3)|(1,1,1)) = ((4,0,3)|(0,1,1))+((3,0,3)|(0,1,1))*AB(1)
        ! theta(2893) = theta(2161)+theta(1993)*AB(1) ! ((3,0,3)|(1,0,2)) = ((4,0,3)|(0,0,2))+((3,0,3)|(0,0,2))*AB(1)
        theta(2894) = theta(2183)+theta(1991)*AB(2) ! ((3,0,3)|(0,3,0)) = ((3,1,3)|(0,2,0))+((3,0,3)|(0,2,0))*AB(2)
        theta(2895) = theta(2189)+theta(1991)*AB(3) ! ((3,0,3)|(0,2,1)) = ((3,0,4)|(0,2,0))+((3,0,3)|(0,2,0))*AB(3)
        theta(2896) = theta(2185)+theta(1993)*AB(2) ! ((3,0,3)|(0,1,2)) = ((3,1,3)|(0,0,2))+((3,0,3)|(0,0,2))*AB(2)
        theta(2897) = theta(2191)+theta(1993)*AB(3) ! ((3,0,3)|(0,0,3)) = ((3,0,4)|(0,0,2))+((3,0,3)|(0,0,2))*AB(3)
        theta(2898) = theta(2162)+theta(1994)*AB(1) ! ((2,4,0)|(3,0,0)) = ((3,4,0)|(2,0,0))+((2,4,0)|(2,0,0))*AB(1)
        ! theta(2899) = theta(2192)+theta(1994)*AB(2) ! ((2,4,0)|(2,1,0)) = ((2,5,0)|(2,0,0))+((2,4,0)|(2,0,0))*AB(2)
        ! theta(2900) = theta(2198)+theta(1994)*AB(3) ! ((2,4,0)|(2,0,1)) = ((2,4,1)|(2,0,0))+((2,4,0)|(2,0,0))*AB(3)
        ! theta(2901) = theta(2165)+theta(1997)*AB(1) ! ((2,4,0)|(1,2,0)) = ((3,4,0)|(0,2,0))+((2,4,0)|(0,2,0))*AB(1)
        ! theta(2902) = theta(2166)+theta(1998)*AB(1) ! ((2,4,0)|(1,1,1)) = ((3,4,0)|(0,1,1))+((2,4,0)|(0,1,1))*AB(1)
        theta(2903) = theta(2167)+theta(1999)*AB(1) ! ((2,4,0)|(1,0,2)) = ((3,4,0)|(0,0,2))+((2,4,0)|(0,0,2))*AB(1)
        theta(2904) = theta(2195)+theta(1997)*AB(2) ! ((2,4,0)|(0,3,0)) = ((2,5,0)|(0,2,0))+((2,4,0)|(0,2,0))*AB(2)
        theta(2905) = theta(2201)+theta(1997)*AB(3) ! ((2,4,0)|(0,2,1)) = ((2,4,1)|(0,2,0))+((2,4,0)|(0,2,0))*AB(3)
        theta(2906) = theta(2197)+theta(1999)*AB(2) ! ((2,4,0)|(0,1,2)) = ((2,5,0)|(0,0,2))+((2,4,0)|(0,0,2))*AB(2)
        theta(2907) = theta(2203)+theta(1999)*AB(3) ! ((2,4,0)|(0,0,3)) = ((2,4,1)|(0,0,2))+((2,4,0)|(0,0,2))*AB(3)
        theta(2908) = theta(2168)+theta(2000)*AB(1) ! ((2,3,1)|(3,0,0)) = ((3,3,1)|(2,0,0))+((2,3,1)|(2,0,0))*AB(1)
        theta(2909) = theta(2169)+theta(2001)*AB(1) ! ((2,3,1)|(2,1,0)) = ((3,3,1)|(1,1,0))+((2,3,1)|(1,1,0))*AB(1)
        ! theta(2910) = theta(2204)+theta(2000)*AB(3) ! ((2,3,1)|(2,0,1)) = ((2,3,2)|(2,0,0))+((2,3,1)|(2,0,0))*AB(3)
        theta(2911) = theta(2171)+theta(2003)*AB(1) ! ((2,3,1)|(1,2,0)) = ((3,3,1)|(0,2,0))+((2,3,1)|(0,2,0))*AB(1)
        theta(2912) = theta(2172)+theta(2004)*AB(1) ! ((2,3,1)|(1,1,1)) = ((3,3,1)|(0,1,1))+((2,3,1)|(0,1,1))*AB(1)
        ! theta(2913) = theta(2173)+theta(2005)*AB(1) ! ((2,3,1)|(1,0,2)) = ((3,3,1)|(0,0,2))+((2,3,1)|(0,0,2))*AB(1)
        theta(2914) = theta(2201)+theta(2003)*AB(2) ! ((2,3,1)|(0,3,0)) = ((2,4,1)|(0,2,0))+((2,3,1)|(0,2,0))*AB(2)
        theta(2915) = theta(2207)+theta(2003)*AB(3) ! ((2,3,1)|(0,2,1)) = ((2,3,2)|(0,2,0))+((2,3,1)|(0,2,0))*AB(3)
        theta(2916) = theta(2203)+theta(2005)*AB(2) ! ((2,3,1)|(0,1,2)) = ((2,4,1)|(0,0,2))+((2,3,1)|(0,0,2))*AB(2)
        theta(2917) = theta(2209)+theta(2005)*AB(3) ! ((2,3,1)|(0,0,3)) = ((2,3,2)|(0,0,2))+((2,3,1)|(0,0,2))*AB(3)
        theta(2918) = theta(2174)+theta(2006)*AB(1) ! ((2,2,2)|(3,0,0)) = ((3,2,2)|(2,0,0))+((2,2,2)|(2,0,0))*AB(1)
        theta(2919) = theta(2175)+theta(2007)*AB(1) ! ((2,2,2)|(2,1,0)) = ((3,2,2)|(1,1,0))+((2,2,2)|(1,1,0))*AB(1)
        ! theta(2920) = theta(2210)+theta(2006)*AB(3) ! ((2,2,2)|(2,0,1)) = ((2,2,3)|(2,0,0))+((2,2,2)|(2,0,0))*AB(3)
        theta(2921) = theta(2177)+theta(2009)*AB(1) ! ((2,2,2)|(1,2,0)) = ((3,2,2)|(0,2,0))+((2,2,2)|(0,2,0))*AB(1)
        theta(2922) = theta(2178)+theta(2010)*AB(1) ! ((2,2,2)|(1,1,1)) = ((3,2,2)|(0,1,1))+((2,2,2)|(0,1,1))*AB(1)
        ! theta(2923) = theta(2179)+theta(2011)*AB(1) ! ((2,2,2)|(1,0,2)) = ((3,2,2)|(0,0,2))+((2,2,2)|(0,0,2))*AB(1)
        theta(2924) = theta(2207)+theta(2009)*AB(2) ! ((2,2,2)|(0,3,0)) = ((2,3,2)|(0,2,0))+((2,2,2)|(0,2,0))*AB(2)
        theta(2925) = theta(2213)+theta(2009)*AB(3) ! ((2,2,2)|(0,2,1)) = ((2,2,3)|(0,2,0))+((2,2,2)|(0,2,0))*AB(3)
        theta(2926) = theta(2209)+theta(2011)*AB(2) ! ((2,2,2)|(0,1,2)) = ((2,3,2)|(0,0,2))+((2,2,2)|(0,0,2))*AB(2)
        theta(2927) = theta(2215)+theta(2011)*AB(3) ! ((2,2,2)|(0,0,3)) = ((2,2,3)|(0,0,2))+((2,2,2)|(0,0,2))*AB(3)
        theta(2928) = theta(2180)+theta(2012)*AB(1) ! ((2,1,3)|(3,0,0)) = ((3,1,3)|(2,0,0))+((2,1,3)|(2,0,0))*AB(1)
        theta(2929) = theta(2181)+theta(2013)*AB(1) ! ((2,1,3)|(2,1,0)) = ((3,1,3)|(1,1,0))+((2,1,3)|(1,1,0))*AB(1)
        ! theta(2930) = theta(2216)+theta(2012)*AB(3) ! ((2,1,3)|(2,0,1)) = ((2,1,4)|(2,0,0))+((2,1,3)|(2,0,0))*AB(3)
        theta(2931) = theta(2183)+theta(2015)*AB(1) ! ((2,1,3)|(1,2,0)) = ((3,1,3)|(0,2,0))+((2,1,3)|(0,2,0))*AB(1)
        theta(2932) = theta(2184)+theta(2016)*AB(1) ! ((2,1,3)|(1,1,1)) = ((3,1,3)|(0,1,1))+((2,1,3)|(0,1,1))*AB(1)
        ! theta(2933) = theta(2185)+theta(2017)*AB(1) ! ((2,1,3)|(1,0,2)) = ((3,1,3)|(0,0,2))+((2,1,3)|(0,0,2))*AB(1)
        theta(2934) = theta(2213)+theta(2015)*AB(2) ! ((2,1,3)|(0,3,0)) = ((2,2,3)|(0,2,0))+((2,1,3)|(0,2,0))*AB(2)
        theta(2935) = theta(2219)+theta(2015)*AB(3) ! ((2,1,3)|(0,2,1)) = ((2,1,4)|(0,2,0))+((2,1,3)|(0,2,0))*AB(3)
        theta(2936) = theta(2215)+theta(2017)*AB(2) ! ((2,1,3)|(0,1,2)) = ((2,2,3)|(0,0,2))+((2,1,3)|(0,0,2))*AB(2)
        theta(2937) = theta(2221)+theta(2017)*AB(3) ! ((2,1,3)|(0,0,3)) = ((2,1,4)|(0,0,2))+((2,1,3)|(0,0,2))*AB(3)
        theta(2938) = theta(2186)+theta(2018)*AB(1) ! ((2,0,4)|(3,0,0)) = ((3,0,4)|(2,0,0))+((2,0,4)|(2,0,0))*AB(1)
        theta(2939) = theta(2187)+theta(2019)*AB(1) ! ((2,0,4)|(2,1,0)) = ((3,0,4)|(1,1,0))+((2,0,4)|(1,1,0))*AB(1)
        ! theta(2940) = theta(2222)+theta(2018)*AB(3) ! ((2,0,4)|(2,0,1)) = ((2,0,5)|(2,0,0))+((2,0,4)|(2,0,0))*AB(3)
        theta(2941) = theta(2189)+theta(2021)*AB(1) ! ((2,0,4)|(1,2,0)) = ((3,0,4)|(0,2,0))+((2,0,4)|(0,2,0))*AB(1)
        theta(2942) = theta(2190)+theta(2022)*AB(1) ! ((2,0,4)|(1,1,1)) = ((3,0,4)|(0,1,1))+((2,0,4)|(0,1,1))*AB(1)
        ! theta(2943) = theta(2191)+theta(2023)*AB(1) ! ((2,0,4)|(1,0,2)) = ((3,0,4)|(0,0,2))+((2,0,4)|(0,0,2))*AB(1)
        theta(2944) = theta(2219)+theta(2021)*AB(2) ! ((2,0,4)|(0,3,0)) = ((2,1,4)|(0,2,0))+((2,0,4)|(0,2,0))*AB(2)
        theta(2945) = theta(2225)+theta(2021)*AB(3) ! ((2,0,4)|(0,2,1)) = ((2,0,5)|(0,2,0))+((2,0,4)|(0,2,0))*AB(3)
        theta(2946) = theta(2221)+theta(2023)*AB(2) ! ((2,0,4)|(0,1,2)) = ((2,1,4)|(0,0,2))+((2,0,4)|(0,0,2))*AB(2)
        theta(2947) = theta(2227)+theta(2023)*AB(3) ! ((2,0,4)|(0,0,3)) = ((2,0,5)|(0,0,2))+((2,0,4)|(0,0,2))*AB(3)
        theta(2948) = theta(2192)+theta(2024)*AB(1) ! ((1,5,0)|(3,0,0)) = ((2,5,0)|(2,0,0))+((1,5,0)|(2,0,0))*AB(1)
        ! theta(2949) = theta(2228)+theta(2024)*AB(2) ! ((1,5,0)|(2,1,0)) = ((1,6,0)|(2,0,0))+((1,5,0)|(2,0,0))*AB(2)
        ! theta(2950) = theta(2234)+theta(2024)*AB(3) ! ((1,5,0)|(2,0,1)) = ((1,5,1)|(2,0,0))+((1,5,0)|(2,0,0))*AB(3)
        ! theta(2951) = theta(2195)+theta(2027)*AB(1) ! ((1,5,0)|(1,2,0)) = ((2,5,0)|(0,2,0))+((1,5,0)|(0,2,0))*AB(1)
        ! theta(2952) = theta(2196)+theta(2028)*AB(1) ! ((1,5,0)|(1,1,1)) = ((2,5,0)|(0,1,1))+((1,5,0)|(0,1,1))*AB(1)
        theta(2953) = theta(2197)+theta(2029)*AB(1) ! ((1,5,0)|(1,0,2)) = ((2,5,0)|(0,0,2))+((1,5,0)|(0,0,2))*AB(1)
        theta(2954) = theta(2231)+theta(2027)*AB(2) ! ((1,5,0)|(0,3,0)) = ((1,6,0)|(0,2,0))+((1,5,0)|(0,2,0))*AB(2)
        theta(2955) = theta(2237)+theta(2027)*AB(3) ! ((1,5,0)|(0,2,1)) = ((1,5,1)|(0,2,0))+((1,5,0)|(0,2,0))*AB(3)
        theta(2956) = theta(2233)+theta(2029)*AB(2) ! ((1,5,0)|(0,1,2)) = ((1,6,0)|(0,0,2))+((1,5,0)|(0,0,2))*AB(2)
        theta(2957) = theta(2239)+theta(2029)*AB(3) ! ((1,5,0)|(0,0,3)) = ((1,5,1)|(0,0,2))+((1,5,0)|(0,0,2))*AB(3)
        theta(2958) = theta(2198)+theta(2030)*AB(1) ! ((1,4,1)|(3,0,0)) = ((2,4,1)|(2,0,0))+((1,4,1)|(2,0,0))*AB(1)
        theta(2959) = theta(2199)+theta(2031)*AB(1) ! ((1,4,1)|(2,1,0)) = ((2,4,1)|(1,1,0))+((1,4,1)|(1,1,0))*AB(1)
        ! theta(2960) = theta(2240)+theta(2030)*AB(3) ! ((1,4,1)|(2,0,1)) = ((1,4,2)|(2,0,0))+((1,4,1)|(2,0,0))*AB(3)
        theta(2961) = theta(2201)+theta(2033)*AB(1) ! ((1,4,1)|(1,2,0)) = ((2,4,1)|(0,2,0))+((1,4,1)|(0,2,0))*AB(1)
        theta(2962) = theta(2202)+theta(2034)*AB(1) ! ((1,4,1)|(1,1,1)) = ((2,4,1)|(0,1,1))+((1,4,1)|(0,1,1))*AB(1)
        ! theta(2963) = theta(2203)+theta(2035)*AB(1) ! ((1,4,1)|(1,0,2)) = ((2,4,1)|(0,0,2))+((1,4,1)|(0,0,2))*AB(1)
        theta(2964) = theta(2237)+theta(2033)*AB(2) ! ((1,4,1)|(0,3,0)) = ((1,5,1)|(0,2,0))+((1,4,1)|(0,2,0))*AB(2)
        theta(2965) = theta(2243)+theta(2033)*AB(3) ! ((1,4,1)|(0,2,1)) = ((1,4,2)|(0,2,0))+((1,4,1)|(0,2,0))*AB(3)
        theta(2966) = theta(2239)+theta(2035)*AB(2) ! ((1,4,1)|(0,1,2)) = ((1,5,1)|(0,0,2))+((1,4,1)|(0,0,2))*AB(2)
        theta(2967) = theta(2245)+theta(2035)*AB(3) ! ((1,4,1)|(0,0,3)) = ((1,4,2)|(0,0,2))+((1,4,1)|(0,0,2))*AB(3)
        theta(2968) = theta(2204)+theta(2036)*AB(1) ! ((1,3,2)|(3,0,0)) = ((2,3,2)|(2,0,0))+((1,3,2)|(2,0,0))*AB(1)
        theta(2969) = theta(2205)+theta(2037)*AB(1) ! ((1,3,2)|(2,1,0)) = ((2,3,2)|(1,1,0))+((1,3,2)|(1,1,0))*AB(1)
        ! theta(2970) = theta(2246)+theta(2036)*AB(3) ! ((1,3,2)|(2,0,1)) = ((1,3,3)|(2,0,0))+((1,3,2)|(2,0,0))*AB(3)
        theta(2971) = theta(2207)+theta(2039)*AB(1) ! ((1,3,2)|(1,2,0)) = ((2,3,2)|(0,2,0))+((1,3,2)|(0,2,0))*AB(1)
        theta(2972) = theta(2208)+theta(2040)*AB(1) ! ((1,3,2)|(1,1,1)) = ((2,3,2)|(0,1,1))+((1,3,2)|(0,1,1))*AB(1)
        ! theta(2973) = theta(2209)+theta(2041)*AB(1) ! ((1,3,2)|(1,0,2)) = ((2,3,2)|(0,0,2))+((1,3,2)|(0,0,2))*AB(1)
        theta(2974) = theta(2243)+theta(2039)*AB(2) ! ((1,3,2)|(0,3,0)) = ((1,4,2)|(0,2,0))+((1,3,2)|(0,2,0))*AB(2)
        theta(2975) = theta(2249)+theta(2039)*AB(3) ! ((1,3,2)|(0,2,1)) = ((1,3,3)|(0,2,0))+((1,3,2)|(0,2,0))*AB(3)
        theta(2976) = theta(2245)+theta(2041)*AB(2) ! ((1,3,2)|(0,1,2)) = ((1,4,2)|(0,0,2))+((1,3,2)|(0,0,2))*AB(2)
        theta(2977) = theta(2251)+theta(2041)*AB(3) ! ((1,3,2)|(0,0,3)) = ((1,3,3)|(0,0,2))+((1,3,2)|(0,0,2))*AB(3)
        theta(2978) = theta(2210)+theta(2042)*AB(1) ! ((1,2,3)|(3,0,0)) = ((2,2,3)|(2,0,0))+((1,2,3)|(2,0,0))*AB(1)
        theta(2979) = theta(2211)+theta(2043)*AB(1) ! ((1,2,3)|(2,1,0)) = ((2,2,3)|(1,1,0))+((1,2,3)|(1,1,0))*AB(1)
        ! theta(2980) = theta(2252)+theta(2042)*AB(3) ! ((1,2,3)|(2,0,1)) = ((1,2,4)|(2,0,0))+((1,2,3)|(2,0,0))*AB(3)
        theta(2981) = theta(2213)+theta(2045)*AB(1) ! ((1,2,3)|(1,2,0)) = ((2,2,3)|(0,2,0))+((1,2,3)|(0,2,0))*AB(1)
        theta(2982) = theta(2214)+theta(2046)*AB(1) ! ((1,2,3)|(1,1,1)) = ((2,2,3)|(0,1,1))+((1,2,3)|(0,1,1))*AB(1)
        ! theta(2983) = theta(2215)+theta(2047)*AB(1) ! ((1,2,3)|(1,0,2)) = ((2,2,3)|(0,0,2))+((1,2,3)|(0,0,2))*AB(1)
        theta(2984) = theta(2249)+theta(2045)*AB(2) ! ((1,2,3)|(0,3,0)) = ((1,3,3)|(0,2,0))+((1,2,3)|(0,2,0))*AB(2)
        theta(2985) = theta(2255)+theta(2045)*AB(3) ! ((1,2,3)|(0,2,1)) = ((1,2,4)|(0,2,0))+((1,2,3)|(0,2,0))*AB(3)
        theta(2986) = theta(2251)+theta(2047)*AB(2) ! ((1,2,3)|(0,1,2)) = ((1,3,3)|(0,0,2))+((1,2,3)|(0,0,2))*AB(2)
        theta(2987) = theta(2257)+theta(2047)*AB(3) ! ((1,2,3)|(0,0,3)) = ((1,2,4)|(0,0,2))+((1,2,3)|(0,0,2))*AB(3)
        theta(2988) = theta(2216)+theta(2048)*AB(1) ! ((1,1,4)|(3,0,0)) = ((2,1,4)|(2,0,0))+((1,1,4)|(2,0,0))*AB(1)
        theta(2989) = theta(2217)+theta(2049)*AB(1) ! ((1,1,4)|(2,1,0)) = ((2,1,4)|(1,1,0))+((1,1,4)|(1,1,0))*AB(1)
        ! theta(2990) = theta(2258)+theta(2048)*AB(3) ! ((1,1,4)|(2,0,1)) = ((1,1,5)|(2,0,0))+((1,1,4)|(2,0,0))*AB(3)
        theta(2991) = theta(2219)+theta(2051)*AB(1) ! ((1,1,4)|(1,2,0)) = ((2,1,4)|(0,2,0))+((1,1,4)|(0,2,0))*AB(1)
        theta(2992) = theta(2220)+theta(2052)*AB(1) ! ((1,1,4)|(1,1,1)) = ((2,1,4)|(0,1,1))+((1,1,4)|(0,1,1))*AB(1)
        ! theta(2993) = theta(2221)+theta(2053)*AB(1) ! ((1,1,4)|(1,0,2)) = ((2,1,4)|(0,0,2))+((1,1,4)|(0,0,2))*AB(1)
        theta(2994) = theta(2255)+theta(2051)*AB(2) ! ((1,1,4)|(0,3,0)) = ((1,2,4)|(0,2,0))+((1,1,4)|(0,2,0))*AB(2)
        theta(2995) = theta(2261)+theta(2051)*AB(3) ! ((1,1,4)|(0,2,1)) = ((1,1,5)|(0,2,0))+((1,1,4)|(0,2,0))*AB(3)
        theta(2996) = theta(2257)+theta(2053)*AB(2) ! ((1,1,4)|(0,1,2)) = ((1,2,4)|(0,0,2))+((1,1,4)|(0,0,2))*AB(2)
        theta(2997) = theta(2263)+theta(2053)*AB(3) ! ((1,1,4)|(0,0,3)) = ((1,1,5)|(0,0,2))+((1,1,4)|(0,0,2))*AB(3)
        theta(2998) = theta(2222)+theta(2054)*AB(1) ! ((1,0,5)|(3,0,0)) = ((2,0,5)|(2,0,0))+((1,0,5)|(2,0,0))*AB(1)
        theta(2999) = theta(2223)+theta(2055)*AB(1) ! ((1,0,5)|(2,1,0)) = ((2,0,5)|(1,1,0))+((1,0,5)|(1,1,0))*AB(1)
        ! theta(3000) = theta(2264)+theta(2054)*AB(3) ! ((1,0,5)|(2,0,1)) = ((1,0,6)|(2,0,0))+((1,0,5)|(2,0,0))*AB(3)
        theta(3001) = theta(2225)+theta(2057)*AB(1) ! ((1,0,5)|(1,2,0)) = ((2,0,5)|(0,2,0))+((1,0,5)|(0,2,0))*AB(1)
        theta(3002) = theta(2226)+theta(2058)*AB(1) ! ((1,0,5)|(1,1,1)) = ((2,0,5)|(0,1,1))+((1,0,5)|(0,1,1))*AB(1)
        ! theta(3003) = theta(2227)+theta(2059)*AB(1) ! ((1,0,5)|(1,0,2)) = ((2,0,5)|(0,0,2))+((1,0,5)|(0,0,2))*AB(1)
        theta(3004) = theta(2261)+theta(2057)*AB(2) ! ((1,0,5)|(0,3,0)) = ((1,1,5)|(0,2,0))+((1,0,5)|(0,2,0))*AB(2)
        theta(3005) = theta(2267)+theta(2057)*AB(3) ! ((1,0,5)|(0,2,1)) = ((1,0,6)|(0,2,0))+((1,0,5)|(0,2,0))*AB(3)
        theta(3006) = theta(2263)+theta(2059)*AB(2) ! ((1,0,5)|(0,1,2)) = ((1,1,5)|(0,0,2))+((1,0,5)|(0,0,2))*AB(2)
        theta(3007) = theta(2269)+theta(2059)*AB(3) ! ((1,0,5)|(0,0,3)) = ((1,0,6)|(0,0,2))+((1,0,5)|(0,0,2))*AB(3)
        theta(3008) = theta(2228)+theta(2060)*AB(1) ! ((0,6,0)|(3,0,0)) = ((1,6,0)|(2,0,0))+((0,6,0)|(2,0,0))*AB(1)
        ! theta(3009) = theta(2270)+theta(2060)*AB(2) ! ((0,6,0)|(2,1,0)) = ((0,7,0)|(2,0,0))+((0,6,0)|(2,0,0))*AB(2)
        ! theta(3010) = theta(2276)+theta(2060)*AB(3) ! ((0,6,0)|(2,0,1)) = ((0,6,1)|(2,0,0))+((0,6,0)|(2,0,0))*AB(3)
        ! theta(3011) = theta(2231)+theta(2063)*AB(1) ! ((0,6,0)|(1,2,0)) = ((1,6,0)|(0,2,0))+((0,6,0)|(0,2,0))*AB(1)
        ! theta(3012) = theta(2232)+theta(2064)*AB(1) ! ((0,6,0)|(1,1,1)) = ((1,6,0)|(0,1,1))+((0,6,0)|(0,1,1))*AB(1)
        theta(3013) = theta(2233)+theta(2065)*AB(1) ! ((0,6,0)|(1,0,2)) = ((1,6,0)|(0,0,2))+((0,6,0)|(0,0,2))*AB(1)
        theta(3014) = theta(2273)+theta(2063)*AB(2) ! ((0,6,0)|(0,3,0)) = ((0,7,0)|(0,2,0))+((0,6,0)|(0,2,0))*AB(2)
        ! theta(3015) = theta(2279)+theta(2063)*AB(3) ! ((0,6,0)|(0,2,1)) = ((0,6,1)|(0,2,0))+((0,6,0)|(0,2,0))*AB(3)
        theta(3016) = theta(2275)+theta(2065)*AB(2) ! ((0,6,0)|(0,1,2)) = ((0,7,0)|(0,0,2))+((0,6,0)|(0,0,2))*AB(2)
        theta(3017) = theta(2281)+theta(2065)*AB(3) ! ((0,6,0)|(0,0,3)) = ((0,6,1)|(0,0,2))+((0,6,0)|(0,0,2))*AB(3)
        theta(3018) = theta(2234)+theta(2066)*AB(1) ! ((0,5,1)|(3,0,0)) = ((1,5,1)|(2,0,0))+((0,5,1)|(2,0,0))*AB(1)
        ! theta(3019) = theta(2235)+theta(2067)*AB(1) ! ((0,5,1)|(2,1,0)) = ((1,5,1)|(1,1,0))+((0,5,1)|(1,1,0))*AB(1)
        ! theta(3020) = theta(2282)+theta(2066)*AB(3) ! ((0,5,1)|(2,0,1)) = ((0,5,2)|(2,0,0))+((0,5,1)|(2,0,0))*AB(3)
        ! theta(3021) = theta(2237)+theta(2069)*AB(1) ! ((0,5,1)|(1,2,0)) = ((1,5,1)|(0,2,0))+((0,5,1)|(0,2,0))*AB(1)
        ! theta(3022) = theta(2238)+theta(2070)*AB(1) ! ((0,5,1)|(1,1,1)) = ((1,5,1)|(0,1,1))+((0,5,1)|(0,1,1))*AB(1)
        ! theta(3023) = theta(2239)+theta(2071)*AB(1) ! ((0,5,1)|(1,0,2)) = ((1,5,1)|(0,0,2))+((0,5,1)|(0,0,2))*AB(1)
        theta(3024) = theta(2279)+theta(2069)*AB(2) ! ((0,5,1)|(0,3,0)) = ((0,6,1)|(0,2,0))+((0,5,1)|(0,2,0))*AB(2)
        ! theta(3025) = theta(2285)+theta(2069)*AB(3) ! ((0,5,1)|(0,2,1)) = ((0,5,2)|(0,2,0))+((0,5,1)|(0,2,0))*AB(3)
        theta(3026) = theta(2281)+theta(2071)*AB(2) ! ((0,5,1)|(0,1,2)) = ((0,6,1)|(0,0,2))+((0,5,1)|(0,0,2))*AB(2)
        theta(3027) = theta(2287)+theta(2071)*AB(3) ! ((0,5,1)|(0,0,3)) = ((0,5,2)|(0,0,2))+((0,5,1)|(0,0,2))*AB(3)
        theta(3028) = theta(2240)+theta(2072)*AB(1) ! ((0,4,2)|(3,0,0)) = ((1,4,2)|(2,0,0))+((0,4,2)|(2,0,0))*AB(1)
        ! theta(3029) = theta(2241)+theta(2073)*AB(1) ! ((0,4,2)|(2,1,0)) = ((1,4,2)|(1,1,0))+((0,4,2)|(1,1,0))*AB(1)
        ! theta(3030) = theta(2288)+theta(2072)*AB(3) ! ((0,4,2)|(2,0,1)) = ((0,4,3)|(2,0,0))+((0,4,2)|(2,0,0))*AB(3)
        ! theta(3031) = theta(2243)+theta(2075)*AB(1) ! ((0,4,2)|(1,2,0)) = ((1,4,2)|(0,2,0))+((0,4,2)|(0,2,0))*AB(1)
        ! theta(3032) = theta(2244)+theta(2076)*AB(1) ! ((0,4,2)|(1,1,1)) = ((1,4,2)|(0,1,1))+((0,4,2)|(0,1,1))*AB(1)
        ! theta(3033) = theta(2245)+theta(2077)*AB(1) ! ((0,4,2)|(1,0,2)) = ((1,4,2)|(0,0,2))+((0,4,2)|(0,0,2))*AB(1)
        theta(3034) = theta(2285)+theta(2075)*AB(2) ! ((0,4,2)|(0,3,0)) = ((0,5,2)|(0,2,0))+((0,4,2)|(0,2,0))*AB(2)
        ! theta(3035) = theta(2291)+theta(2075)*AB(3) ! ((0,4,2)|(0,2,1)) = ((0,4,3)|(0,2,0))+((0,4,2)|(0,2,0))*AB(3)
        theta(3036) = theta(2287)+theta(2077)*AB(2) ! ((0,4,2)|(0,1,2)) = ((0,5,2)|(0,0,2))+((0,4,2)|(0,0,2))*AB(2)
        theta(3037) = theta(2293)+theta(2077)*AB(3) ! ((0,4,2)|(0,0,3)) = ((0,4,3)|(0,0,2))+((0,4,2)|(0,0,2))*AB(3)
        theta(3038) = theta(2246)+theta(2078)*AB(1) ! ((0,3,3)|(3,0,0)) = ((1,3,3)|(2,0,0))+((0,3,3)|(2,0,0))*AB(1)
        ! theta(3039) = theta(2247)+theta(2079)*AB(1) ! ((0,3,3)|(2,1,0)) = ((1,3,3)|(1,1,0))+((0,3,3)|(1,1,0))*AB(1)
        ! theta(3040) = theta(2294)+theta(2078)*AB(3) ! ((0,3,3)|(2,0,1)) = ((0,3,4)|(2,0,0))+((0,3,3)|(2,0,0))*AB(3)
        ! theta(3041) = theta(2249)+theta(2081)*AB(1) ! ((0,3,3)|(1,2,0)) = ((1,3,3)|(0,2,0))+((0,3,3)|(0,2,0))*AB(1)
        ! theta(3042) = theta(2250)+theta(2082)*AB(1) ! ((0,3,3)|(1,1,1)) = ((1,3,3)|(0,1,1))+((0,3,3)|(0,1,1))*AB(1)
        ! theta(3043) = theta(2251)+theta(2083)*AB(1) ! ((0,3,3)|(1,0,2)) = ((1,3,3)|(0,0,2))+((0,3,3)|(0,0,2))*AB(1)
        theta(3044) = theta(2291)+theta(2081)*AB(2) ! ((0,3,3)|(0,3,0)) = ((0,4,3)|(0,2,0))+((0,3,3)|(0,2,0))*AB(2)
        ! theta(3045) = theta(2297)+theta(2081)*AB(3) ! ((0,3,3)|(0,2,1)) = ((0,3,4)|(0,2,0))+((0,3,3)|(0,2,0))*AB(3)
        theta(3046) = theta(2293)+theta(2083)*AB(2) ! ((0,3,3)|(0,1,2)) = ((0,4,3)|(0,0,2))+((0,3,3)|(0,0,2))*AB(2)
        theta(3047) = theta(2299)+theta(2083)*AB(3) ! ((0,3,3)|(0,0,3)) = ((0,3,4)|(0,0,2))+((0,3,3)|(0,0,2))*AB(3)
        theta(3048) = theta(2252)+theta(2084)*AB(1) ! ((0,2,4)|(3,0,0)) = ((1,2,4)|(2,0,0))+((0,2,4)|(2,0,0))*AB(1)
        ! theta(3049) = theta(2253)+theta(2085)*AB(1) ! ((0,2,4)|(2,1,0)) = ((1,2,4)|(1,1,0))+((0,2,4)|(1,1,0))*AB(1)
        ! theta(3050) = theta(2300)+theta(2084)*AB(3) ! ((0,2,4)|(2,0,1)) = ((0,2,5)|(2,0,0))+((0,2,4)|(2,0,0))*AB(3)
        ! theta(3051) = theta(2255)+theta(2087)*AB(1) ! ((0,2,4)|(1,2,0)) = ((1,2,4)|(0,2,0))+((0,2,4)|(0,2,0))*AB(1)
        ! theta(3052) = theta(2256)+theta(2088)*AB(1) ! ((0,2,4)|(1,1,1)) = ((1,2,4)|(0,1,1))+((0,2,4)|(0,1,1))*AB(1)
        ! theta(3053) = theta(2257)+theta(2089)*AB(1) ! ((0,2,4)|(1,0,2)) = ((1,2,4)|(0,0,2))+((0,2,4)|(0,0,2))*AB(1)
        theta(3054) = theta(2297)+theta(2087)*AB(2) ! ((0,2,4)|(0,3,0)) = ((0,3,4)|(0,2,0))+((0,2,4)|(0,2,0))*AB(2)
        ! theta(3055) = theta(2303)+theta(2087)*AB(3) ! ((0,2,4)|(0,2,1)) = ((0,2,5)|(0,2,0))+((0,2,4)|(0,2,0))*AB(3)
        theta(3056) = theta(2299)+theta(2089)*AB(2) ! ((0,2,4)|(0,1,2)) = ((0,3,4)|(0,0,2))+((0,2,4)|(0,0,2))*AB(2)
        theta(3057) = theta(2305)+theta(2089)*AB(3) ! ((0,2,4)|(0,0,3)) = ((0,2,5)|(0,0,2))+((0,2,4)|(0,0,2))*AB(3)
        theta(3058) = theta(2258)+theta(2090)*AB(1) ! ((0,1,5)|(3,0,0)) = ((1,1,5)|(2,0,0))+((0,1,5)|(2,0,0))*AB(1)
        ! theta(3059) = theta(2259)+theta(2091)*AB(1) ! ((0,1,5)|(2,1,0)) = ((1,1,5)|(1,1,0))+((0,1,5)|(1,1,0))*AB(1)
        ! theta(3060) = theta(2306)+theta(2090)*AB(3) ! ((0,1,5)|(2,0,1)) = ((0,1,6)|(2,0,0))+((0,1,5)|(2,0,0))*AB(3)
        ! theta(3061) = theta(2261)+theta(2093)*AB(1) ! ((0,1,5)|(1,2,0)) = ((1,1,5)|(0,2,0))+((0,1,5)|(0,2,0))*AB(1)
        ! theta(3062) = theta(2262)+theta(2094)*AB(1) ! ((0,1,5)|(1,1,1)) = ((1,1,5)|(0,1,1))+((0,1,5)|(0,1,1))*AB(1)
        ! theta(3063) = theta(2263)+theta(2095)*AB(1) ! ((0,1,5)|(1,0,2)) = ((1,1,5)|(0,0,2))+((0,1,5)|(0,0,2))*AB(1)
        theta(3064) = theta(2303)+theta(2093)*AB(2) ! ((0,1,5)|(0,3,0)) = ((0,2,5)|(0,2,0))+((0,1,5)|(0,2,0))*AB(2)
        ! theta(3065) = theta(2309)+theta(2093)*AB(3) ! ((0,1,5)|(0,2,1)) = ((0,1,6)|(0,2,0))+((0,1,5)|(0,2,0))*AB(3)
        theta(3066) = theta(2305)+theta(2095)*AB(2) ! ((0,1,5)|(0,1,2)) = ((0,2,5)|(0,0,2))+((0,1,5)|(0,0,2))*AB(2)
        theta(3067) = theta(2311)+theta(2095)*AB(3) ! ((0,1,5)|(0,0,3)) = ((0,1,6)|(0,0,2))+((0,1,5)|(0,0,2))*AB(3)
        theta(3068) = theta(2264)+theta(2096)*AB(1) ! ((0,0,6)|(3,0,0)) = ((1,0,6)|(2,0,0))+((0,0,6)|(2,0,0))*AB(1)
        ! theta(3069) = theta(2265)+theta(2097)*AB(1) ! ((0,0,6)|(2,1,0)) = ((1,0,6)|(1,1,0))+((0,0,6)|(1,1,0))*AB(1)
        ! theta(3070) = theta(2312)+theta(2096)*AB(3) ! ((0,0,6)|(2,0,1)) = ((0,0,7)|(2,0,0))+((0,0,6)|(2,0,0))*AB(3)
        ! theta(3071) = theta(2267)+theta(2099)*AB(1) ! ((0,0,6)|(1,2,0)) = ((1,0,6)|(0,2,0))+((0,0,6)|(0,2,0))*AB(1)
        ! theta(3072) = theta(2268)+theta(2100)*AB(1) ! ((0,0,6)|(1,1,1)) = ((1,0,6)|(0,1,1))+((0,0,6)|(0,1,1))*AB(1)
        ! theta(3073) = theta(2269)+theta(2101)*AB(1) ! ((0,0,6)|(1,0,2)) = ((1,0,6)|(0,0,2))+((0,0,6)|(0,0,2))*AB(1)
        theta(3074) = theta(2309)+theta(2099)*AB(2) ! ((0,0,6)|(0,3,0)) = ((0,1,6)|(0,2,0))+((0,0,6)|(0,2,0))*AB(2)
        ! theta(3075) = theta(2315)+theta(2099)*AB(3) ! ((0,0,6)|(0,2,1)) = ((0,0,7)|(0,2,0))+((0,0,6)|(0,2,0))*AB(3)
        ! theta(3076) = theta(2311)+theta(2101)*AB(2) ! ((0,0,6)|(0,1,2)) = ((0,1,6)|(0,0,2))+((0,0,6)|(0,0,2))*AB(2)
        theta(3077) = theta(2317)+theta(2101)*AB(3) ! ((0,0,6)|(0,0,3)) = ((0,0,7)|(0,0,2))+((0,0,6)|(0,0,2))*AB(3)
        theta(3078) = theta(2318)+theta(2102)*AB(1) ! ((7,0,0)|(3,0,0)) = ((8,0,0)|(2,0,0))+((7,0,0)|(2,0,0))*AB(1)
        ! theta(3079) = theta(2324)+theta(2102)*AB(2) ! ((7,0,0)|(2,1,0)) = ((7,1,0)|(2,0,0))+((7,0,0)|(2,0,0))*AB(2)
        ! theta(3080) = theta(2330)+theta(2102)*AB(3) ! ((7,0,0)|(2,0,1)) = ((7,0,1)|(2,0,0))+((7,0,0)|(2,0,0))*AB(3)
        ! theta(3081) = theta(2321)+theta(2105)*AB(1) ! ((7,0,0)|(1,2,0)) = ((8,0,0)|(0,2,0))+((7,0,0)|(0,2,0))*AB(1)
        ! theta(3082) = theta(2322)+theta(2106)*AB(1) ! ((7,0,0)|(1,1,1)) = ((8,0,0)|(0,1,1))+((7,0,0)|(0,1,1))*AB(1)
        ! theta(3083) = theta(2323)+theta(2107)*AB(1) ! ((7,0,0)|(1,0,2)) = ((8,0,0)|(0,0,2))+((7,0,0)|(0,0,2))*AB(1)
        theta(3084) = theta(2327)+theta(2105)*AB(2) ! ((7,0,0)|(0,3,0)) = ((7,1,0)|(0,2,0))+((7,0,0)|(0,2,0))*AB(2)
        theta(3085) = theta(2333)+theta(2105)*AB(3) ! ((7,0,0)|(0,2,1)) = ((7,0,1)|(0,2,0))+((7,0,0)|(0,2,0))*AB(3)
        ! theta(3086) = theta(2329)+theta(2107)*AB(2) ! ((7,0,0)|(0,1,2)) = ((7,1,0)|(0,0,2))+((7,0,0)|(0,0,2))*AB(2)
        theta(3087) = theta(2335)+theta(2107)*AB(3) ! ((7,0,0)|(0,0,3)) = ((7,0,1)|(0,0,2))+((7,0,0)|(0,0,2))*AB(3)
        theta(3088) = theta(2324)+theta(2108)*AB(1) ! ((6,1,0)|(3,0,0)) = ((7,1,0)|(2,0,0))+((6,1,0)|(2,0,0))*AB(1)
        ! theta(3089) = theta(2336)+theta(2108)*AB(2) ! ((6,1,0)|(2,1,0)) = ((6,2,0)|(2,0,0))+((6,1,0)|(2,0,0))*AB(2)
        ! theta(3090) = theta(2342)+theta(2108)*AB(3) ! ((6,1,0)|(2,0,1)) = ((6,1,1)|(2,0,0))+((6,1,0)|(2,0,0))*AB(3)
        ! theta(3091) = theta(2327)+theta(2111)*AB(1) ! ((6,1,0)|(1,2,0)) = ((7,1,0)|(0,2,0))+((6,1,0)|(0,2,0))*AB(1)
        ! theta(3092) = theta(2328)+theta(2112)*AB(1) ! ((6,1,0)|(1,1,1)) = ((7,1,0)|(0,1,1))+((6,1,0)|(0,1,1))*AB(1)
        theta(3093) = theta(2329)+theta(2113)*AB(1) ! ((6,1,0)|(1,0,2)) = ((7,1,0)|(0,0,2))+((6,1,0)|(0,0,2))*AB(1)
        theta(3094) = theta(2339)+theta(2111)*AB(2) ! ((6,1,0)|(0,3,0)) = ((6,2,0)|(0,2,0))+((6,1,0)|(0,2,0))*AB(2)
        theta(3095) = theta(2345)+theta(2111)*AB(3) ! ((6,1,0)|(0,2,1)) = ((6,1,1)|(0,2,0))+((6,1,0)|(0,2,0))*AB(3)
        theta(3096) = theta(2341)+theta(2113)*AB(2) ! ((6,1,0)|(0,1,2)) = ((6,2,0)|(0,0,2))+((6,1,0)|(0,0,2))*AB(2)
        theta(3097) = theta(2347)+theta(2113)*AB(3) ! ((6,1,0)|(0,0,3)) = ((6,1,1)|(0,0,2))+((6,1,0)|(0,0,2))*AB(3)
        theta(3098) = theta(2330)+theta(2114)*AB(1) ! ((6,0,1)|(3,0,0)) = ((7,0,1)|(2,0,0))+((6,0,1)|(2,0,0))*AB(1)
        theta(3099) = theta(2331)+theta(2115)*AB(1) ! ((6,0,1)|(2,1,0)) = ((7,0,1)|(1,1,0))+((6,0,1)|(1,1,0))*AB(1)
        ! theta(3100) = theta(2348)+theta(2114)*AB(3) ! ((6,0,1)|(2,0,1)) = ((6,0,2)|(2,0,0))+((6,0,1)|(2,0,0))*AB(3)
        theta(3101) = theta(2333)+theta(2117)*AB(1) ! ((6,0,1)|(1,2,0)) = ((7,0,1)|(0,2,0))+((6,0,1)|(0,2,0))*AB(1)
        theta(3102) = theta(2334)+theta(2118)*AB(1) ! ((6,0,1)|(1,1,1)) = ((7,0,1)|(0,1,1))+((6,0,1)|(0,1,1))*AB(1)
        ! theta(3103) = theta(2335)+theta(2119)*AB(1) ! ((6,0,1)|(1,0,2)) = ((7,0,1)|(0,0,2))+((6,0,1)|(0,0,2))*AB(1)
        theta(3104) = theta(2345)+theta(2117)*AB(2) ! ((6,0,1)|(0,3,0)) = ((6,1,1)|(0,2,0))+((6,0,1)|(0,2,0))*AB(2)
        theta(3105) = theta(2351)+theta(2117)*AB(3) ! ((6,0,1)|(0,2,1)) = ((6,0,2)|(0,2,0))+((6,0,1)|(0,2,0))*AB(3)
        theta(3106) = theta(2347)+theta(2119)*AB(2) ! ((6,0,1)|(0,1,2)) = ((6,1,1)|(0,0,2))+((6,0,1)|(0,0,2))*AB(2)
        theta(3107) = theta(2353)+theta(2119)*AB(3) ! ((6,0,1)|(0,0,3)) = ((6,0,2)|(0,0,2))+((6,0,1)|(0,0,2))*AB(3)
        theta(3108) = theta(2336)+theta(2120)*AB(1) ! ((5,2,0)|(3,0,0)) = ((6,2,0)|(2,0,0))+((5,2,0)|(2,0,0))*AB(1)
        ! theta(3109) = theta(2354)+theta(2120)*AB(2) ! ((5,2,0)|(2,1,0)) = ((5,3,0)|(2,0,0))+((5,2,0)|(2,0,0))*AB(2)
        ! theta(3110) = theta(2360)+theta(2120)*AB(3) ! ((5,2,0)|(2,0,1)) = ((5,2,1)|(2,0,0))+((5,2,0)|(2,0,0))*AB(3)
        ! theta(3111) = theta(2339)+theta(2123)*AB(1) ! ((5,2,0)|(1,2,0)) = ((6,2,0)|(0,2,0))+((5,2,0)|(0,2,0))*AB(1)
        ! theta(3112) = theta(2340)+theta(2124)*AB(1) ! ((5,2,0)|(1,1,1)) = ((6,2,0)|(0,1,1))+((5,2,0)|(0,1,1))*AB(1)
        theta(3113) = theta(2341)+theta(2125)*AB(1) ! ((5,2,0)|(1,0,2)) = ((6,2,0)|(0,0,2))+((5,2,0)|(0,0,2))*AB(1)
        theta(3114) = theta(2357)+theta(2123)*AB(2) ! ((5,2,0)|(0,3,0)) = ((5,3,0)|(0,2,0))+((5,2,0)|(0,2,0))*AB(2)
        theta(3115) = theta(2363)+theta(2123)*AB(3) ! ((5,2,0)|(0,2,1)) = ((5,2,1)|(0,2,0))+((5,2,0)|(0,2,0))*AB(3)
        theta(3116) = theta(2359)+theta(2125)*AB(2) ! ((5,2,0)|(0,1,2)) = ((5,3,0)|(0,0,2))+((5,2,0)|(0,0,2))*AB(2)
        theta(3117) = theta(2365)+theta(2125)*AB(3) ! ((5,2,0)|(0,0,3)) = ((5,2,1)|(0,0,2))+((5,2,0)|(0,0,2))*AB(3)
        theta(3118) = theta(2342)+theta(2126)*AB(1) ! ((5,1,1)|(3,0,0)) = ((6,1,1)|(2,0,0))+((5,1,1)|(2,0,0))*AB(1)
        theta(3119) = theta(2343)+theta(2127)*AB(1) ! ((5,1,1)|(2,1,0)) = ((6,1,1)|(1,1,0))+((5,1,1)|(1,1,0))*AB(1)
        ! theta(3120) = theta(2366)+theta(2126)*AB(3) ! ((5,1,1)|(2,0,1)) = ((5,1,2)|(2,0,0))+((5,1,1)|(2,0,0))*AB(3)
        theta(3121) = theta(2345)+theta(2129)*AB(1) ! ((5,1,1)|(1,2,0)) = ((6,1,1)|(0,2,0))+((5,1,1)|(0,2,0))*AB(1)
        theta(3122) = theta(2346)+theta(2130)*AB(1) ! ((5,1,1)|(1,1,1)) = ((6,1,1)|(0,1,1))+((5,1,1)|(0,1,1))*AB(1)
        ! theta(3123) = theta(2347)+theta(2131)*AB(1) ! ((5,1,1)|(1,0,2)) = ((6,1,1)|(0,0,2))+((5,1,1)|(0,0,2))*AB(1)
        theta(3124) = theta(2363)+theta(2129)*AB(2) ! ((5,1,1)|(0,3,0)) = ((5,2,1)|(0,2,0))+((5,1,1)|(0,2,0))*AB(2)
        theta(3125) = theta(2369)+theta(2129)*AB(3) ! ((5,1,1)|(0,2,1)) = ((5,1,2)|(0,2,0))+((5,1,1)|(0,2,0))*AB(3)
        theta(3126) = theta(2365)+theta(2131)*AB(2) ! ((5,1,1)|(0,1,2)) = ((5,2,1)|(0,0,2))+((5,1,1)|(0,0,2))*AB(2)
        theta(3127) = theta(2371)+theta(2131)*AB(3) ! ((5,1,1)|(0,0,3)) = ((5,1,2)|(0,0,2))+((5,1,1)|(0,0,2))*AB(3)
        theta(3128) = theta(2348)+theta(2132)*AB(1) ! ((5,0,2)|(3,0,0)) = ((6,0,2)|(2,0,0))+((5,0,2)|(2,0,0))*AB(1)
        theta(3129) = theta(2349)+theta(2133)*AB(1) ! ((5,0,2)|(2,1,0)) = ((6,0,2)|(1,1,0))+((5,0,2)|(1,1,0))*AB(1)
        ! theta(3130) = theta(2372)+theta(2132)*AB(3) ! ((5,0,2)|(2,0,1)) = ((5,0,3)|(2,0,0))+((5,0,2)|(2,0,0))*AB(3)
        theta(3131) = theta(2351)+theta(2135)*AB(1) ! ((5,0,2)|(1,2,0)) = ((6,0,2)|(0,2,0))+((5,0,2)|(0,2,0))*AB(1)
        theta(3132) = theta(2352)+theta(2136)*AB(1) ! ((5,0,2)|(1,1,1)) = ((6,0,2)|(0,1,1))+((5,0,2)|(0,1,1))*AB(1)
        ! theta(3133) = theta(2353)+theta(2137)*AB(1) ! ((5,0,2)|(1,0,2)) = ((6,0,2)|(0,0,2))+((5,0,2)|(0,0,2))*AB(1)
        theta(3134) = theta(2369)+theta(2135)*AB(2) ! ((5,0,2)|(0,3,0)) = ((5,1,2)|(0,2,0))+((5,0,2)|(0,2,0))*AB(2)
        theta(3135) = theta(2375)+theta(2135)*AB(3) ! ((5,0,2)|(0,2,1)) = ((5,0,3)|(0,2,0))+((5,0,2)|(0,2,0))*AB(3)
        theta(3136) = theta(2371)+theta(2137)*AB(2) ! ((5,0,2)|(0,1,2)) = ((5,1,2)|(0,0,2))+((5,0,2)|(0,0,2))*AB(2)
        theta(3137) = theta(2377)+theta(2137)*AB(3) ! ((5,0,2)|(0,0,3)) = ((5,0,3)|(0,0,2))+((5,0,2)|(0,0,2))*AB(3)
        theta(3138) = theta(2354)+theta(2138)*AB(1) ! ((4,3,0)|(3,0,0)) = ((5,3,0)|(2,0,0))+((4,3,0)|(2,0,0))*AB(1)
        ! theta(3139) = theta(2378)+theta(2138)*AB(2) ! ((4,3,0)|(2,1,0)) = ((4,4,0)|(2,0,0))+((4,3,0)|(2,0,0))*AB(2)
        ! theta(3140) = theta(2384)+theta(2138)*AB(3) ! ((4,3,0)|(2,0,1)) = ((4,3,1)|(2,0,0))+((4,3,0)|(2,0,0))*AB(3)
        ! theta(3141) = theta(2357)+theta(2141)*AB(1) ! ((4,3,0)|(1,2,0)) = ((5,3,0)|(0,2,0))+((4,3,0)|(0,2,0))*AB(1)
        ! theta(3142) = theta(2358)+theta(2142)*AB(1) ! ((4,3,0)|(1,1,1)) = ((5,3,0)|(0,1,1))+((4,3,0)|(0,1,1))*AB(1)
        theta(3143) = theta(2359)+theta(2143)*AB(1) ! ((4,3,0)|(1,0,2)) = ((5,3,0)|(0,0,2))+((4,3,0)|(0,0,2))*AB(1)
        theta(3144) = theta(2381)+theta(2141)*AB(2) ! ((4,3,0)|(0,3,0)) = ((4,4,0)|(0,2,0))+((4,3,0)|(0,2,0))*AB(2)
        theta(3145) = theta(2387)+theta(2141)*AB(3) ! ((4,3,0)|(0,2,1)) = ((4,3,1)|(0,2,0))+((4,3,0)|(0,2,0))*AB(3)
        theta(3146) = theta(2383)+theta(2143)*AB(2) ! ((4,3,0)|(0,1,2)) = ((4,4,0)|(0,0,2))+((4,3,0)|(0,0,2))*AB(2)
        theta(3147) = theta(2389)+theta(2143)*AB(3) ! ((4,3,0)|(0,0,3)) = ((4,3,1)|(0,0,2))+((4,3,0)|(0,0,2))*AB(3)
        theta(3148) = theta(2360)+theta(2144)*AB(1) ! ((4,2,1)|(3,0,0)) = ((5,2,1)|(2,0,0))+((4,2,1)|(2,0,0))*AB(1)
        theta(3149) = theta(2361)+theta(2145)*AB(1) ! ((4,2,1)|(2,1,0)) = ((5,2,1)|(1,1,0))+((4,2,1)|(1,1,0))*AB(1)
        ! theta(3150) = theta(2390)+theta(2144)*AB(3) ! ((4,2,1)|(2,0,1)) = ((4,2,2)|(2,0,0))+((4,2,1)|(2,0,0))*AB(3)
        theta(3151) = theta(2363)+theta(2147)*AB(1) ! ((4,2,1)|(1,2,0)) = ((5,2,1)|(0,2,0))+((4,2,1)|(0,2,0))*AB(1)
        theta(3152) = theta(2364)+theta(2148)*AB(1) ! ((4,2,1)|(1,1,1)) = ((5,2,1)|(0,1,1))+((4,2,1)|(0,1,1))*AB(1)
        ! theta(3153) = theta(2365)+theta(2149)*AB(1) ! ((4,2,1)|(1,0,2)) = ((5,2,1)|(0,0,2))+((4,2,1)|(0,0,2))*AB(1)
        theta(3154) = theta(2387)+theta(2147)*AB(2) ! ((4,2,1)|(0,3,0)) = ((4,3,1)|(0,2,0))+((4,2,1)|(0,2,0))*AB(2)
        theta(3155) = theta(2393)+theta(2147)*AB(3) ! ((4,2,1)|(0,2,1)) = ((4,2,2)|(0,2,0))+((4,2,1)|(0,2,0))*AB(3)
        theta(3156) = theta(2389)+theta(2149)*AB(2) ! ((4,2,1)|(0,1,2)) = ((4,3,1)|(0,0,2))+((4,2,1)|(0,0,2))*AB(2)
        theta(3157) = theta(2395)+theta(2149)*AB(3) ! ((4,2,1)|(0,0,3)) = ((4,2,2)|(0,0,2))+((4,2,1)|(0,0,2))*AB(3)
        theta(3158) = theta(2366)+theta(2150)*AB(1) ! ((4,1,2)|(3,0,0)) = ((5,1,2)|(2,0,0))+((4,1,2)|(2,0,0))*AB(1)
        theta(3159) = theta(2367)+theta(2151)*AB(1) ! ((4,1,2)|(2,1,0)) = ((5,1,2)|(1,1,0))+((4,1,2)|(1,1,0))*AB(1)
        ! theta(3160) = theta(2396)+theta(2150)*AB(3) ! ((4,1,2)|(2,0,1)) = ((4,1,3)|(2,0,0))+((4,1,2)|(2,0,0))*AB(3)
        theta(3161) = theta(2369)+theta(2153)*AB(1) ! ((4,1,2)|(1,2,0)) = ((5,1,2)|(0,2,0))+((4,1,2)|(0,2,0))*AB(1)
        theta(3162) = theta(2370)+theta(2154)*AB(1) ! ((4,1,2)|(1,1,1)) = ((5,1,2)|(0,1,1))+((4,1,2)|(0,1,1))*AB(1)
        ! theta(3163) = theta(2371)+theta(2155)*AB(1) ! ((4,1,2)|(1,0,2)) = ((5,1,2)|(0,0,2))+((4,1,2)|(0,0,2))*AB(1)
        theta(3164) = theta(2393)+theta(2153)*AB(2) ! ((4,1,2)|(0,3,0)) = ((4,2,2)|(0,2,0))+((4,1,2)|(0,2,0))*AB(2)
        theta(3165) = theta(2399)+theta(2153)*AB(3) ! ((4,1,2)|(0,2,1)) = ((4,1,3)|(0,2,0))+((4,1,2)|(0,2,0))*AB(3)
        theta(3166) = theta(2395)+theta(2155)*AB(2) ! ((4,1,2)|(0,1,2)) = ((4,2,2)|(0,0,2))+((4,1,2)|(0,0,2))*AB(2)
        theta(3167) = theta(2401)+theta(2155)*AB(3) ! ((4,1,2)|(0,0,3)) = ((4,1,3)|(0,0,2))+((4,1,2)|(0,0,2))*AB(3)
        theta(3168) = theta(2372)+theta(2156)*AB(1) ! ((4,0,3)|(3,0,0)) = ((5,0,3)|(2,0,0))+((4,0,3)|(2,0,0))*AB(1)
        theta(3169) = theta(2373)+theta(2157)*AB(1) ! ((4,0,3)|(2,1,0)) = ((5,0,3)|(1,1,0))+((4,0,3)|(1,1,0))*AB(1)
        ! theta(3170) = theta(2402)+theta(2156)*AB(3) ! ((4,0,3)|(2,0,1)) = ((4,0,4)|(2,0,0))+((4,0,3)|(2,0,0))*AB(3)
        theta(3171) = theta(2375)+theta(2159)*AB(1) ! ((4,0,3)|(1,2,0)) = ((5,0,3)|(0,2,0))+((4,0,3)|(0,2,0))*AB(1)
        theta(3172) = theta(2376)+theta(2160)*AB(1) ! ((4,0,3)|(1,1,1)) = ((5,0,3)|(0,1,1))+((4,0,3)|(0,1,1))*AB(1)
        ! theta(3173) = theta(2377)+theta(2161)*AB(1) ! ((4,0,3)|(1,0,2)) = ((5,0,3)|(0,0,2))+((4,0,3)|(0,0,2))*AB(1)
        theta(3174) = theta(2399)+theta(2159)*AB(2) ! ((4,0,3)|(0,3,0)) = ((4,1,3)|(0,2,0))+((4,0,3)|(0,2,0))*AB(2)
        theta(3175) = theta(2405)+theta(2159)*AB(3) ! ((4,0,3)|(0,2,1)) = ((4,0,4)|(0,2,0))+((4,0,3)|(0,2,0))*AB(3)
        theta(3176) = theta(2401)+theta(2161)*AB(2) ! ((4,0,3)|(0,1,2)) = ((4,1,3)|(0,0,2))+((4,0,3)|(0,0,2))*AB(2)
        theta(3177) = theta(2407)+theta(2161)*AB(3) ! ((4,0,3)|(0,0,3)) = ((4,0,4)|(0,0,2))+((4,0,3)|(0,0,2))*AB(3)
        theta(3178) = theta(2378)+theta(2162)*AB(1) ! ((3,4,0)|(3,0,0)) = ((4,4,0)|(2,0,0))+((3,4,0)|(2,0,0))*AB(1)
        ! theta(3179) = theta(2408)+theta(2162)*AB(2) ! ((3,4,0)|(2,1,0)) = ((3,5,0)|(2,0,0))+((3,4,0)|(2,0,0))*AB(2)
        ! theta(3180) = theta(2414)+theta(2162)*AB(3) ! ((3,4,0)|(2,0,1)) = ((3,4,1)|(2,0,0))+((3,4,0)|(2,0,0))*AB(3)
        ! theta(3181) = theta(2381)+theta(2165)*AB(1) ! ((3,4,0)|(1,2,0)) = ((4,4,0)|(0,2,0))+((3,4,0)|(0,2,0))*AB(1)
        ! theta(3182) = theta(2382)+theta(2166)*AB(1) ! ((3,4,0)|(1,1,1)) = ((4,4,0)|(0,1,1))+((3,4,0)|(0,1,1))*AB(1)
        theta(3183) = theta(2383)+theta(2167)*AB(1) ! ((3,4,0)|(1,0,2)) = ((4,4,0)|(0,0,2))+((3,4,0)|(0,0,2))*AB(1)
        theta(3184) = theta(2411)+theta(2165)*AB(2) ! ((3,4,0)|(0,3,0)) = ((3,5,0)|(0,2,0))+((3,4,0)|(0,2,0))*AB(2)
        theta(3185) = theta(2417)+theta(2165)*AB(3) ! ((3,4,0)|(0,2,1)) = ((3,4,1)|(0,2,0))+((3,4,0)|(0,2,0))*AB(3)
        theta(3186) = theta(2413)+theta(2167)*AB(2) ! ((3,4,0)|(0,1,2)) = ((3,5,0)|(0,0,2))+((3,4,0)|(0,0,2))*AB(2)
        theta(3187) = theta(2419)+theta(2167)*AB(3) ! ((3,4,0)|(0,0,3)) = ((3,4,1)|(0,0,2))+((3,4,0)|(0,0,2))*AB(3)
        theta(3188) = theta(2384)+theta(2168)*AB(1) ! ((3,3,1)|(3,0,0)) = ((4,3,1)|(2,0,0))+((3,3,1)|(2,0,0))*AB(1)
        theta(3189) = theta(2385)+theta(2169)*AB(1) ! ((3,3,1)|(2,1,0)) = ((4,3,1)|(1,1,0))+((3,3,1)|(1,1,0))*AB(1)
        ! theta(3190) = theta(2420)+theta(2168)*AB(3) ! ((3,3,1)|(2,0,1)) = ((3,3,2)|(2,0,0))+((3,3,1)|(2,0,0))*AB(3)
        theta(3191) = theta(2387)+theta(2171)*AB(1) ! ((3,3,1)|(1,2,0)) = ((4,3,1)|(0,2,0))+((3,3,1)|(0,2,0))*AB(1)
        theta(3192) = theta(2388)+theta(2172)*AB(1) ! ((3,3,1)|(1,1,1)) = ((4,3,1)|(0,1,1))+((3,3,1)|(0,1,1))*AB(1)
        ! theta(3193) = theta(2389)+theta(2173)*AB(1) ! ((3,3,1)|(1,0,2)) = ((4,3,1)|(0,0,2))+((3,3,1)|(0,0,2))*AB(1)
        theta(3194) = theta(2417)+theta(2171)*AB(2) ! ((3,3,1)|(0,3,0)) = ((3,4,1)|(0,2,0))+((3,3,1)|(0,2,0))*AB(2)
        theta(3195) = theta(2423)+theta(2171)*AB(3) ! ((3,3,1)|(0,2,1)) = ((3,3,2)|(0,2,0))+((3,3,1)|(0,2,0))*AB(3)
        theta(3196) = theta(2419)+theta(2173)*AB(2) ! ((3,3,1)|(0,1,2)) = ((3,4,1)|(0,0,2))+((3,3,1)|(0,0,2))*AB(2)
        theta(3197) = theta(2425)+theta(2173)*AB(3) ! ((3,3,1)|(0,0,3)) = ((3,3,2)|(0,0,2))+((3,3,1)|(0,0,2))*AB(3)
        theta(3198) = theta(2390)+theta(2174)*AB(1) ! ((3,2,2)|(3,0,0)) = ((4,2,2)|(2,0,0))+((3,2,2)|(2,0,0))*AB(1)
        theta(3199) = theta(2391)+theta(2175)*AB(1) ! ((3,2,2)|(2,1,0)) = ((4,2,2)|(1,1,0))+((3,2,2)|(1,1,0))*AB(1)
        ! theta(3200) = theta(2426)+theta(2174)*AB(3) ! ((3,2,2)|(2,0,1)) = ((3,2,3)|(2,0,0))+((3,2,2)|(2,0,0))*AB(3)
        theta(3201) = theta(2393)+theta(2177)*AB(1) ! ((3,2,2)|(1,2,0)) = ((4,2,2)|(0,2,0))+((3,2,2)|(0,2,0))*AB(1)
        theta(3202) = theta(2394)+theta(2178)*AB(1) ! ((3,2,2)|(1,1,1)) = ((4,2,2)|(0,1,1))+((3,2,2)|(0,1,1))*AB(1)
        ! theta(3203) = theta(2395)+theta(2179)*AB(1) ! ((3,2,2)|(1,0,2)) = ((4,2,2)|(0,0,2))+((3,2,2)|(0,0,2))*AB(1)
        theta(3204) = theta(2423)+theta(2177)*AB(2) ! ((3,2,2)|(0,3,0)) = ((3,3,2)|(0,2,0))+((3,2,2)|(0,2,0))*AB(2)
        theta(3205) = theta(2429)+theta(2177)*AB(3) ! ((3,2,2)|(0,2,1)) = ((3,2,3)|(0,2,0))+((3,2,2)|(0,2,0))*AB(3)
        theta(3206) = theta(2425)+theta(2179)*AB(2) ! ((3,2,2)|(0,1,2)) = ((3,3,2)|(0,0,2))+((3,2,2)|(0,0,2))*AB(2)
        theta(3207) = theta(2431)+theta(2179)*AB(3) ! ((3,2,2)|(0,0,3)) = ((3,2,3)|(0,0,2))+((3,2,2)|(0,0,2))*AB(3)
        theta(3208) = theta(2396)+theta(2180)*AB(1) ! ((3,1,3)|(3,0,0)) = ((4,1,3)|(2,0,0))+((3,1,3)|(2,0,0))*AB(1)
        theta(3209) = theta(2397)+theta(2181)*AB(1) ! ((3,1,3)|(2,1,0)) = ((4,1,3)|(1,1,0))+((3,1,3)|(1,1,0))*AB(1)
        ! theta(3210) = theta(2432)+theta(2180)*AB(3) ! ((3,1,3)|(2,0,1)) = ((3,1,4)|(2,0,0))+((3,1,3)|(2,0,0))*AB(3)
        theta(3211) = theta(2399)+theta(2183)*AB(1) ! ((3,1,3)|(1,2,0)) = ((4,1,3)|(0,2,0))+((3,1,3)|(0,2,0))*AB(1)
        theta(3212) = theta(2400)+theta(2184)*AB(1) ! ((3,1,3)|(1,1,1)) = ((4,1,3)|(0,1,1))+((3,1,3)|(0,1,1))*AB(1)
        ! theta(3213) = theta(2401)+theta(2185)*AB(1) ! ((3,1,3)|(1,0,2)) = ((4,1,3)|(0,0,2))+((3,1,3)|(0,0,2))*AB(1)
        theta(3214) = theta(2429)+theta(2183)*AB(2) ! ((3,1,3)|(0,3,0)) = ((3,2,3)|(0,2,0))+((3,1,3)|(0,2,0))*AB(2)
        theta(3215) = theta(2435)+theta(2183)*AB(3) ! ((3,1,3)|(0,2,1)) = ((3,1,4)|(0,2,0))+((3,1,3)|(0,2,0))*AB(3)
        theta(3216) = theta(2431)+theta(2185)*AB(2) ! ((3,1,3)|(0,1,2)) = ((3,2,3)|(0,0,2))+((3,1,3)|(0,0,2))*AB(2)
        theta(3217) = theta(2437)+theta(2185)*AB(3) ! ((3,1,3)|(0,0,3)) = ((3,1,4)|(0,0,2))+((3,1,3)|(0,0,2))*AB(3)
        theta(3218) = theta(2402)+theta(2186)*AB(1) ! ((3,0,4)|(3,0,0)) = ((4,0,4)|(2,0,0))+((3,0,4)|(2,0,0))*AB(1)
        theta(3219) = theta(2403)+theta(2187)*AB(1) ! ((3,0,4)|(2,1,0)) = ((4,0,4)|(1,1,0))+((3,0,4)|(1,1,0))*AB(1)
        ! theta(3220) = theta(2438)+theta(2186)*AB(3) ! ((3,0,4)|(2,0,1)) = ((3,0,5)|(2,0,0))+((3,0,4)|(2,0,0))*AB(3)
        theta(3221) = theta(2405)+theta(2189)*AB(1) ! ((3,0,4)|(1,2,0)) = ((4,0,4)|(0,2,0))+((3,0,4)|(0,2,0))*AB(1)
        theta(3222) = theta(2406)+theta(2190)*AB(1) ! ((3,0,4)|(1,1,1)) = ((4,0,4)|(0,1,1))+((3,0,4)|(0,1,1))*AB(1)
        ! theta(3223) = theta(2407)+theta(2191)*AB(1) ! ((3,0,4)|(1,0,2)) = ((4,0,4)|(0,0,2))+((3,0,4)|(0,0,2))*AB(1)
        theta(3224) = theta(2435)+theta(2189)*AB(2) ! ((3,0,4)|(0,3,0)) = ((3,1,4)|(0,2,0))+((3,0,4)|(0,2,0))*AB(2)
        theta(3225) = theta(2441)+theta(2189)*AB(3) ! ((3,0,4)|(0,2,1)) = ((3,0,5)|(0,2,0))+((3,0,4)|(0,2,0))*AB(3)
        theta(3226) = theta(2437)+theta(2191)*AB(2) ! ((3,0,4)|(0,1,2)) = ((3,1,4)|(0,0,2))+((3,0,4)|(0,0,2))*AB(2)
        theta(3227) = theta(2443)+theta(2191)*AB(3) ! ((3,0,4)|(0,0,3)) = ((3,0,5)|(0,0,2))+((3,0,4)|(0,0,2))*AB(3)
        theta(3228) = theta(2408)+theta(2192)*AB(1) ! ((2,5,0)|(3,0,0)) = ((3,5,0)|(2,0,0))+((2,5,0)|(2,0,0))*AB(1)
        ! theta(3229) = theta(2444)+theta(2192)*AB(2) ! ((2,5,0)|(2,1,0)) = ((2,6,0)|(2,0,0))+((2,5,0)|(2,0,0))*AB(2)
        ! theta(3230) = theta(2450)+theta(2192)*AB(3) ! ((2,5,0)|(2,0,1)) = ((2,5,1)|(2,0,0))+((2,5,0)|(2,0,0))*AB(3)
        ! theta(3231) = theta(2411)+theta(2195)*AB(1) ! ((2,5,0)|(1,2,0)) = ((3,5,0)|(0,2,0))+((2,5,0)|(0,2,0))*AB(1)
        ! theta(3232) = theta(2412)+theta(2196)*AB(1) ! ((2,5,0)|(1,1,1)) = ((3,5,0)|(0,1,1))+((2,5,0)|(0,1,1))*AB(1)
        theta(3233) = theta(2413)+theta(2197)*AB(1) ! ((2,5,0)|(1,0,2)) = ((3,5,0)|(0,0,2))+((2,5,0)|(0,0,2))*AB(1)
        theta(3234) = theta(2447)+theta(2195)*AB(2) ! ((2,5,0)|(0,3,0)) = ((2,6,0)|(0,2,0))+((2,5,0)|(0,2,0))*AB(2)
        theta(3235) = theta(2453)+theta(2195)*AB(3) ! ((2,5,0)|(0,2,1)) = ((2,5,1)|(0,2,0))+((2,5,0)|(0,2,0))*AB(3)
        theta(3236) = theta(2449)+theta(2197)*AB(2) ! ((2,5,0)|(0,1,2)) = ((2,6,0)|(0,0,2))+((2,5,0)|(0,0,2))*AB(2)
        theta(3237) = theta(2455)+theta(2197)*AB(3) ! ((2,5,0)|(0,0,3)) = ((2,5,1)|(0,0,2))+((2,5,0)|(0,0,2))*AB(3)
        theta(3238) = theta(2414)+theta(2198)*AB(1) ! ((2,4,1)|(3,0,0)) = ((3,4,1)|(2,0,0))+((2,4,1)|(2,0,0))*AB(1)
        theta(3239) = theta(2415)+theta(2199)*AB(1) ! ((2,4,1)|(2,1,0)) = ((3,4,1)|(1,1,0))+((2,4,1)|(1,1,0))*AB(1)
        ! theta(3240) = theta(2456)+theta(2198)*AB(3) ! ((2,4,1)|(2,0,1)) = ((2,4,2)|(2,0,0))+((2,4,1)|(2,0,0))*AB(3)
        theta(3241) = theta(2417)+theta(2201)*AB(1) ! ((2,4,1)|(1,2,0)) = ((3,4,1)|(0,2,0))+((2,4,1)|(0,2,0))*AB(1)
        theta(3242) = theta(2418)+theta(2202)*AB(1) ! ((2,4,1)|(1,1,1)) = ((3,4,1)|(0,1,1))+((2,4,1)|(0,1,1))*AB(1)
        ! theta(3243) = theta(2419)+theta(2203)*AB(1) ! ((2,4,1)|(1,0,2)) = ((3,4,1)|(0,0,2))+((2,4,1)|(0,0,2))*AB(1)
        theta(3244) = theta(2453)+theta(2201)*AB(2) ! ((2,4,1)|(0,3,0)) = ((2,5,1)|(0,2,0))+((2,4,1)|(0,2,0))*AB(2)
        theta(3245) = theta(2459)+theta(2201)*AB(3) ! ((2,4,1)|(0,2,1)) = ((2,4,2)|(0,2,0))+((2,4,1)|(0,2,0))*AB(3)
        theta(3246) = theta(2455)+theta(2203)*AB(2) ! ((2,4,1)|(0,1,2)) = ((2,5,1)|(0,0,2))+((2,4,1)|(0,0,2))*AB(2)
        theta(3247) = theta(2461)+theta(2203)*AB(3) ! ((2,4,1)|(0,0,3)) = ((2,4,2)|(0,0,2))+((2,4,1)|(0,0,2))*AB(3)
        theta(3248) = theta(2420)+theta(2204)*AB(1) ! ((2,3,2)|(3,0,0)) = ((3,3,2)|(2,0,0))+((2,3,2)|(2,0,0))*AB(1)
        theta(3249) = theta(2421)+theta(2205)*AB(1) ! ((2,3,2)|(2,1,0)) = ((3,3,2)|(1,1,0))+((2,3,2)|(1,1,0))*AB(1)
        ! theta(3250) = theta(2462)+theta(2204)*AB(3) ! ((2,3,2)|(2,0,1)) = ((2,3,3)|(2,0,0))+((2,3,2)|(2,0,0))*AB(3)
        theta(3251) = theta(2423)+theta(2207)*AB(1) ! ((2,3,2)|(1,2,0)) = ((3,3,2)|(0,2,0))+((2,3,2)|(0,2,0))*AB(1)
        theta(3252) = theta(2424)+theta(2208)*AB(1) ! ((2,3,2)|(1,1,1)) = ((3,3,2)|(0,1,1))+((2,3,2)|(0,1,1))*AB(1)
        ! theta(3253) = theta(2425)+theta(2209)*AB(1) ! ((2,3,2)|(1,0,2)) = ((3,3,2)|(0,0,2))+((2,3,2)|(0,0,2))*AB(1)
        theta(3254) = theta(2459)+theta(2207)*AB(2) ! ((2,3,2)|(0,3,0)) = ((2,4,2)|(0,2,0))+((2,3,2)|(0,2,0))*AB(2)
        theta(3255) = theta(2465)+theta(2207)*AB(3) ! ((2,3,2)|(0,2,1)) = ((2,3,3)|(0,2,0))+((2,3,2)|(0,2,0))*AB(3)
        theta(3256) = theta(2461)+theta(2209)*AB(2) ! ((2,3,2)|(0,1,2)) = ((2,4,2)|(0,0,2))+((2,3,2)|(0,0,2))*AB(2)
        theta(3257) = theta(2467)+theta(2209)*AB(3) ! ((2,3,2)|(0,0,3)) = ((2,3,3)|(0,0,2))+((2,3,2)|(0,0,2))*AB(3)
        theta(3258) = theta(2426)+theta(2210)*AB(1) ! ((2,2,3)|(3,0,0)) = ((3,2,3)|(2,0,0))+((2,2,3)|(2,0,0))*AB(1)
        theta(3259) = theta(2427)+theta(2211)*AB(1) ! ((2,2,3)|(2,1,0)) = ((3,2,3)|(1,1,0))+((2,2,3)|(1,1,0))*AB(1)
        ! theta(3260) = theta(2468)+theta(2210)*AB(3) ! ((2,2,3)|(2,0,1)) = ((2,2,4)|(2,0,0))+((2,2,3)|(2,0,0))*AB(3)
        theta(3261) = theta(2429)+theta(2213)*AB(1) ! ((2,2,3)|(1,2,0)) = ((3,2,3)|(0,2,0))+((2,2,3)|(0,2,0))*AB(1)
        theta(3262) = theta(2430)+theta(2214)*AB(1) ! ((2,2,3)|(1,1,1)) = ((3,2,3)|(0,1,1))+((2,2,3)|(0,1,1))*AB(1)
        ! theta(3263) = theta(2431)+theta(2215)*AB(1) ! ((2,2,3)|(1,0,2)) = ((3,2,3)|(0,0,2))+((2,2,3)|(0,0,2))*AB(1)
        theta(3264) = theta(2465)+theta(2213)*AB(2) ! ((2,2,3)|(0,3,0)) = ((2,3,3)|(0,2,0))+((2,2,3)|(0,2,0))*AB(2)
        theta(3265) = theta(2471)+theta(2213)*AB(3) ! ((2,2,3)|(0,2,1)) = ((2,2,4)|(0,2,0))+((2,2,3)|(0,2,0))*AB(3)
        theta(3266) = theta(2467)+theta(2215)*AB(2) ! ((2,2,3)|(0,1,2)) = ((2,3,3)|(0,0,2))+((2,2,3)|(0,0,2))*AB(2)
        theta(3267) = theta(2473)+theta(2215)*AB(3) ! ((2,2,3)|(0,0,3)) = ((2,2,4)|(0,0,2))+((2,2,3)|(0,0,2))*AB(3)
        theta(3268) = theta(2432)+theta(2216)*AB(1) ! ((2,1,4)|(3,0,0)) = ((3,1,4)|(2,0,0))+((2,1,4)|(2,0,0))*AB(1)
        theta(3269) = theta(2433)+theta(2217)*AB(1) ! ((2,1,4)|(2,1,0)) = ((3,1,4)|(1,1,0))+((2,1,4)|(1,1,0))*AB(1)
        ! theta(3270) = theta(2474)+theta(2216)*AB(3) ! ((2,1,4)|(2,0,1)) = ((2,1,5)|(2,0,0))+((2,1,4)|(2,0,0))*AB(3)
        theta(3271) = theta(2435)+theta(2219)*AB(1) ! ((2,1,4)|(1,2,0)) = ((3,1,4)|(0,2,0))+((2,1,4)|(0,2,0))*AB(1)
        theta(3272) = theta(2436)+theta(2220)*AB(1) ! ((2,1,4)|(1,1,1)) = ((3,1,4)|(0,1,1))+((2,1,4)|(0,1,1))*AB(1)
        ! theta(3273) = theta(2437)+theta(2221)*AB(1) ! ((2,1,4)|(1,0,2)) = ((3,1,4)|(0,0,2))+((2,1,4)|(0,0,2))*AB(1)
        theta(3274) = theta(2471)+theta(2219)*AB(2) ! ((2,1,4)|(0,3,0)) = ((2,2,4)|(0,2,0))+((2,1,4)|(0,2,0))*AB(2)
        theta(3275) = theta(2477)+theta(2219)*AB(3) ! ((2,1,4)|(0,2,1)) = ((2,1,5)|(0,2,0))+((2,1,4)|(0,2,0))*AB(3)
        theta(3276) = theta(2473)+theta(2221)*AB(2) ! ((2,1,4)|(0,1,2)) = ((2,2,4)|(0,0,2))+((2,1,4)|(0,0,2))*AB(2)
        theta(3277) = theta(2479)+theta(2221)*AB(3) ! ((2,1,4)|(0,0,3)) = ((2,1,5)|(0,0,2))+((2,1,4)|(0,0,2))*AB(3)
        theta(3278) = theta(2438)+theta(2222)*AB(1) ! ((2,0,5)|(3,0,0)) = ((3,0,5)|(2,0,0))+((2,0,5)|(2,0,0))*AB(1)
        theta(3279) = theta(2439)+theta(2223)*AB(1) ! ((2,0,5)|(2,1,0)) = ((3,0,5)|(1,1,0))+((2,0,5)|(1,1,0))*AB(1)
        ! theta(3280) = theta(2480)+theta(2222)*AB(3) ! ((2,0,5)|(2,0,1)) = ((2,0,6)|(2,0,0))+((2,0,5)|(2,0,0))*AB(3)
        theta(3281) = theta(2441)+theta(2225)*AB(1) ! ((2,0,5)|(1,2,0)) = ((3,0,5)|(0,2,0))+((2,0,5)|(0,2,0))*AB(1)
        theta(3282) = theta(2442)+theta(2226)*AB(1) ! ((2,0,5)|(1,1,1)) = ((3,0,5)|(0,1,1))+((2,0,5)|(0,1,1))*AB(1)
        ! theta(3283) = theta(2443)+theta(2227)*AB(1) ! ((2,0,5)|(1,0,2)) = ((3,0,5)|(0,0,2))+((2,0,5)|(0,0,2))*AB(1)
        theta(3284) = theta(2477)+theta(2225)*AB(2) ! ((2,0,5)|(0,3,0)) = ((2,1,5)|(0,2,0))+((2,0,5)|(0,2,0))*AB(2)
        theta(3285) = theta(2483)+theta(2225)*AB(3) ! ((2,0,5)|(0,2,1)) = ((2,0,6)|(0,2,0))+((2,0,5)|(0,2,0))*AB(3)
        theta(3286) = theta(2479)+theta(2227)*AB(2) ! ((2,0,5)|(0,1,2)) = ((2,1,5)|(0,0,2))+((2,0,5)|(0,0,2))*AB(2)
        theta(3287) = theta(2485)+theta(2227)*AB(3) ! ((2,0,5)|(0,0,3)) = ((2,0,6)|(0,0,2))+((2,0,5)|(0,0,2))*AB(3)
        theta(3288) = theta(2444)+theta(2228)*AB(1) ! ((1,6,0)|(3,0,0)) = ((2,6,0)|(2,0,0))+((1,6,0)|(2,0,0))*AB(1)
        ! theta(3289) = theta(2486)+theta(2228)*AB(2) ! ((1,6,0)|(2,1,0)) = ((1,7,0)|(2,0,0))+((1,6,0)|(2,0,0))*AB(2)
        ! theta(3290) = theta(2492)+theta(2228)*AB(3) ! ((1,6,0)|(2,0,1)) = ((1,6,1)|(2,0,0))+((1,6,0)|(2,0,0))*AB(3)
        ! theta(3291) = theta(2447)+theta(2231)*AB(1) ! ((1,6,0)|(1,2,0)) = ((2,6,0)|(0,2,0))+((1,6,0)|(0,2,0))*AB(1)
        ! theta(3292) = theta(2448)+theta(2232)*AB(1) ! ((1,6,0)|(1,1,1)) = ((2,6,0)|(0,1,1))+((1,6,0)|(0,1,1))*AB(1)
        theta(3293) = theta(2449)+theta(2233)*AB(1) ! ((1,6,0)|(1,0,2)) = ((2,6,0)|(0,0,2))+((1,6,0)|(0,0,2))*AB(1)
        theta(3294) = theta(2489)+theta(2231)*AB(2) ! ((1,6,0)|(0,3,0)) = ((1,7,0)|(0,2,0))+((1,6,0)|(0,2,0))*AB(2)
        ! theta(3295) = theta(2495)+theta(2231)*AB(3) ! ((1,6,0)|(0,2,1)) = ((1,6,1)|(0,2,0))+((1,6,0)|(0,2,0))*AB(3)
        theta(3296) = theta(2491)+theta(2233)*AB(2) ! ((1,6,0)|(0,1,2)) = ((1,7,0)|(0,0,2))+((1,6,0)|(0,0,2))*AB(2)
        theta(3297) = theta(2497)+theta(2233)*AB(3) ! ((1,6,0)|(0,0,3)) = ((1,6,1)|(0,0,2))+((1,6,0)|(0,0,2))*AB(3)
        theta(3298) = theta(2450)+theta(2234)*AB(1) ! ((1,5,1)|(3,0,0)) = ((2,5,1)|(2,0,0))+((1,5,1)|(2,0,0))*AB(1)
        ! theta(3299) = theta(2451)+theta(2235)*AB(1) ! ((1,5,1)|(2,1,0)) = ((2,5,1)|(1,1,0))+((1,5,1)|(1,1,0))*AB(1)
        ! theta(3300) = theta(2498)+theta(2234)*AB(3) ! ((1,5,1)|(2,0,1)) = ((1,5,2)|(2,0,0))+((1,5,1)|(2,0,0))*AB(3)
        ! theta(3301) = theta(2453)+theta(2237)*AB(1) ! ((1,5,1)|(1,2,0)) = ((2,5,1)|(0,2,0))+((1,5,1)|(0,2,0))*AB(1)
        ! theta(3302) = theta(2454)+theta(2238)*AB(1) ! ((1,5,1)|(1,1,1)) = ((2,5,1)|(0,1,1))+((1,5,1)|(0,1,1))*AB(1)
        ! theta(3303) = theta(2455)+theta(2239)*AB(1) ! ((1,5,1)|(1,0,2)) = ((2,5,1)|(0,0,2))+((1,5,1)|(0,0,2))*AB(1)
        theta(3304) = theta(2495)+theta(2237)*AB(2) ! ((1,5,1)|(0,3,0)) = ((1,6,1)|(0,2,0))+((1,5,1)|(0,2,0))*AB(2)
        ! theta(3305) = theta(2501)+theta(2237)*AB(3) ! ((1,5,1)|(0,2,1)) = ((1,5,2)|(0,2,0))+((1,5,1)|(0,2,0))*AB(3)
        theta(3306) = theta(2497)+theta(2239)*AB(2) ! ((1,5,1)|(0,1,2)) = ((1,6,1)|(0,0,2))+((1,5,1)|(0,0,2))*AB(2)
        theta(3307) = theta(2503)+theta(2239)*AB(3) ! ((1,5,1)|(0,0,3)) = ((1,5,2)|(0,0,2))+((1,5,1)|(0,0,2))*AB(3)
        theta(3308) = theta(2456)+theta(2240)*AB(1) ! ((1,4,2)|(3,0,0)) = ((2,4,2)|(2,0,0))+((1,4,2)|(2,0,0))*AB(1)
        ! theta(3309) = theta(2457)+theta(2241)*AB(1) ! ((1,4,2)|(2,1,0)) = ((2,4,2)|(1,1,0))+((1,4,2)|(1,1,0))*AB(1)
        ! theta(3310) = theta(2504)+theta(2240)*AB(3) ! ((1,4,2)|(2,0,1)) = ((1,4,3)|(2,0,0))+((1,4,2)|(2,0,0))*AB(3)
        ! theta(3311) = theta(2459)+theta(2243)*AB(1) ! ((1,4,2)|(1,2,0)) = ((2,4,2)|(0,2,0))+((1,4,2)|(0,2,0))*AB(1)
        ! theta(3312) = theta(2460)+theta(2244)*AB(1) ! ((1,4,2)|(1,1,1)) = ((2,4,2)|(0,1,1))+((1,4,2)|(0,1,1))*AB(1)
        ! theta(3313) = theta(2461)+theta(2245)*AB(1) ! ((1,4,2)|(1,0,2)) = ((2,4,2)|(0,0,2))+((1,4,2)|(0,0,2))*AB(1)
        theta(3314) = theta(2501)+theta(2243)*AB(2) ! ((1,4,2)|(0,3,0)) = ((1,5,2)|(0,2,0))+((1,4,2)|(0,2,0))*AB(2)
        ! theta(3315) = theta(2507)+theta(2243)*AB(3) ! ((1,4,2)|(0,2,1)) = ((1,4,3)|(0,2,0))+((1,4,2)|(0,2,0))*AB(3)
        theta(3316) = theta(2503)+theta(2245)*AB(2) ! ((1,4,2)|(0,1,2)) = ((1,5,2)|(0,0,2))+((1,4,2)|(0,0,2))*AB(2)
        theta(3317) = theta(2509)+theta(2245)*AB(3) ! ((1,4,2)|(0,0,3)) = ((1,4,3)|(0,0,2))+((1,4,2)|(0,0,2))*AB(3)
        theta(3318) = theta(2462)+theta(2246)*AB(1) ! ((1,3,3)|(3,0,0)) = ((2,3,3)|(2,0,0))+((1,3,3)|(2,0,0))*AB(1)
        ! theta(3319) = theta(2463)+theta(2247)*AB(1) ! ((1,3,3)|(2,1,0)) = ((2,3,3)|(1,1,0))+((1,3,3)|(1,1,0))*AB(1)
        ! theta(3320) = theta(2510)+theta(2246)*AB(3) ! ((1,3,3)|(2,0,1)) = ((1,3,4)|(2,0,0))+((1,3,3)|(2,0,0))*AB(3)
        ! theta(3321) = theta(2465)+theta(2249)*AB(1) ! ((1,3,3)|(1,2,0)) = ((2,3,3)|(0,2,0))+((1,3,3)|(0,2,0))*AB(1)
        ! theta(3322) = theta(2466)+theta(2250)*AB(1) ! ((1,3,3)|(1,1,1)) = ((2,3,3)|(0,1,1))+((1,3,3)|(0,1,1))*AB(1)
        ! theta(3323) = theta(2467)+theta(2251)*AB(1) ! ((1,3,3)|(1,0,2)) = ((2,3,3)|(0,0,2))+((1,3,3)|(0,0,2))*AB(1)
        theta(3324) = theta(2507)+theta(2249)*AB(2) ! ((1,3,3)|(0,3,0)) = ((1,4,3)|(0,2,0))+((1,3,3)|(0,2,0))*AB(2)
        ! theta(3325) = theta(2513)+theta(2249)*AB(3) ! ((1,3,3)|(0,2,1)) = ((1,3,4)|(0,2,0))+((1,3,3)|(0,2,0))*AB(3)
        theta(3326) = theta(2509)+theta(2251)*AB(2) ! ((1,3,3)|(0,1,2)) = ((1,4,3)|(0,0,2))+((1,3,3)|(0,0,2))*AB(2)
        theta(3327) = theta(2515)+theta(2251)*AB(3) ! ((1,3,3)|(0,0,3)) = ((1,3,4)|(0,0,2))+((1,3,3)|(0,0,2))*AB(3)
        theta(3328) = theta(2468)+theta(2252)*AB(1) ! ((1,2,4)|(3,0,0)) = ((2,2,4)|(2,0,0))+((1,2,4)|(2,0,0))*AB(1)
        ! theta(3329) = theta(2469)+theta(2253)*AB(1) ! ((1,2,4)|(2,1,0)) = ((2,2,4)|(1,1,0))+((1,2,4)|(1,1,0))*AB(1)
        ! theta(3330) = theta(2516)+theta(2252)*AB(3) ! ((1,2,4)|(2,0,1)) = ((1,2,5)|(2,0,0))+((1,2,4)|(2,0,0))*AB(3)
        ! theta(3331) = theta(2471)+theta(2255)*AB(1) ! ((1,2,4)|(1,2,0)) = ((2,2,4)|(0,2,0))+((1,2,4)|(0,2,0))*AB(1)
        ! theta(3332) = theta(2472)+theta(2256)*AB(1) ! ((1,2,4)|(1,1,1)) = ((2,2,4)|(0,1,1))+((1,2,4)|(0,1,1))*AB(1)
        ! theta(3333) = theta(2473)+theta(2257)*AB(1) ! ((1,2,4)|(1,0,2)) = ((2,2,4)|(0,0,2))+((1,2,4)|(0,0,2))*AB(1)
        theta(3334) = theta(2513)+theta(2255)*AB(2) ! ((1,2,4)|(0,3,0)) = ((1,3,4)|(0,2,0))+((1,2,4)|(0,2,0))*AB(2)
        ! theta(3335) = theta(2519)+theta(2255)*AB(3) ! ((1,2,4)|(0,2,1)) = ((1,2,5)|(0,2,0))+((1,2,4)|(0,2,0))*AB(3)
        theta(3336) = theta(2515)+theta(2257)*AB(2) ! ((1,2,4)|(0,1,2)) = ((1,3,4)|(0,0,2))+((1,2,4)|(0,0,2))*AB(2)
        theta(3337) = theta(2521)+theta(2257)*AB(3) ! ((1,2,4)|(0,0,3)) = ((1,2,5)|(0,0,2))+((1,2,4)|(0,0,2))*AB(3)
        theta(3338) = theta(2474)+theta(2258)*AB(1) ! ((1,1,5)|(3,0,0)) = ((2,1,5)|(2,0,0))+((1,1,5)|(2,0,0))*AB(1)
        ! theta(3339) = theta(2475)+theta(2259)*AB(1) ! ((1,1,5)|(2,1,0)) = ((2,1,5)|(1,1,0))+((1,1,5)|(1,1,0))*AB(1)
        ! theta(3340) = theta(2522)+theta(2258)*AB(3) ! ((1,1,5)|(2,0,1)) = ((1,1,6)|(2,0,0))+((1,1,5)|(2,0,0))*AB(3)
        ! theta(3341) = theta(2477)+theta(2261)*AB(1) ! ((1,1,5)|(1,2,0)) = ((2,1,5)|(0,2,0))+((1,1,5)|(0,2,0))*AB(1)
        ! theta(3342) = theta(2478)+theta(2262)*AB(1) ! ((1,1,5)|(1,1,1)) = ((2,1,5)|(0,1,1))+((1,1,5)|(0,1,1))*AB(1)
        ! theta(3343) = theta(2479)+theta(2263)*AB(1) ! ((1,1,5)|(1,0,2)) = ((2,1,5)|(0,0,2))+((1,1,5)|(0,0,2))*AB(1)
        theta(3344) = theta(2519)+theta(2261)*AB(2) ! ((1,1,5)|(0,3,0)) = ((1,2,5)|(0,2,0))+((1,1,5)|(0,2,0))*AB(2)
        ! theta(3345) = theta(2525)+theta(2261)*AB(3) ! ((1,1,5)|(0,2,1)) = ((1,1,6)|(0,2,0))+((1,1,5)|(0,2,0))*AB(3)
        theta(3346) = theta(2521)+theta(2263)*AB(2) ! ((1,1,5)|(0,1,2)) = ((1,2,5)|(0,0,2))+((1,1,5)|(0,0,2))*AB(2)
        theta(3347) = theta(2527)+theta(2263)*AB(3) ! ((1,1,5)|(0,0,3)) = ((1,1,6)|(0,0,2))+((1,1,5)|(0,0,2))*AB(3)
        theta(3348) = theta(2480)+theta(2264)*AB(1) ! ((1,0,6)|(3,0,0)) = ((2,0,6)|(2,0,0))+((1,0,6)|(2,0,0))*AB(1)
        ! theta(3349) = theta(2481)+theta(2265)*AB(1) ! ((1,0,6)|(2,1,0)) = ((2,0,6)|(1,1,0))+((1,0,6)|(1,1,0))*AB(1)
        ! theta(3350) = theta(2528)+theta(2264)*AB(3) ! ((1,0,6)|(2,0,1)) = ((1,0,7)|(2,0,0))+((1,0,6)|(2,0,0))*AB(3)
        ! theta(3351) = theta(2483)+theta(2267)*AB(1) ! ((1,0,6)|(1,2,0)) = ((2,0,6)|(0,2,0))+((1,0,6)|(0,2,0))*AB(1)
        ! theta(3352) = theta(2484)+theta(2268)*AB(1) ! ((1,0,6)|(1,1,1)) = ((2,0,6)|(0,1,1))+((1,0,6)|(0,1,1))*AB(1)
        ! theta(3353) = theta(2485)+theta(2269)*AB(1) ! ((1,0,6)|(1,0,2)) = ((2,0,6)|(0,0,2))+((1,0,6)|(0,0,2))*AB(1)
        theta(3354) = theta(2525)+theta(2267)*AB(2) ! ((1,0,6)|(0,3,0)) = ((1,1,6)|(0,2,0))+((1,0,6)|(0,2,0))*AB(2)
        ! theta(3355) = theta(2531)+theta(2267)*AB(3) ! ((1,0,6)|(0,2,1)) = ((1,0,7)|(0,2,0))+((1,0,6)|(0,2,0))*AB(3)
        ! theta(3356) = theta(2527)+theta(2269)*AB(2) ! ((1,0,6)|(0,1,2)) = ((1,1,6)|(0,0,2))+((1,0,6)|(0,0,2))*AB(2)
        theta(3357) = theta(2533)+theta(2269)*AB(3) ! ((1,0,6)|(0,0,3)) = ((1,0,7)|(0,0,2))+((1,0,6)|(0,0,2))*AB(3)
        theta(3358) = theta(2486)+theta(2270)*AB(1) ! ((0,7,0)|(3,0,0)) = ((1,7,0)|(2,0,0))+((0,7,0)|(2,0,0))*AB(1)
        ! theta(3359) = theta(2534)+theta(2270)*AB(2) ! ((0,7,0)|(2,1,0)) = ((0,8,0)|(2,0,0))+((0,7,0)|(2,0,0))*AB(2)
        ! theta(3360) = theta(2540)+theta(2270)*AB(3) ! ((0,7,0)|(2,0,1)) = ((0,7,1)|(2,0,0))+((0,7,0)|(2,0,0))*AB(3)
        ! theta(3361) = theta(2489)+theta(2273)*AB(1) ! ((0,7,0)|(1,2,0)) = ((1,7,0)|(0,2,0))+((0,7,0)|(0,2,0))*AB(1)
        ! theta(3362) = theta(2490)+theta(2274)*AB(1) ! ((0,7,0)|(1,1,1)) = ((1,7,0)|(0,1,1))+((0,7,0)|(0,1,1))*AB(1)
        ! theta(3363) = theta(2491)+theta(2275)*AB(1) ! ((0,7,0)|(1,0,2)) = ((1,7,0)|(0,0,2))+((0,7,0)|(0,0,2))*AB(1)
        theta(3364) = theta(2537)+theta(2273)*AB(2) ! ((0,7,0)|(0,3,0)) = ((0,8,0)|(0,2,0))+((0,7,0)|(0,2,0))*AB(2)
        ! theta(3365) = theta(2543)+theta(2273)*AB(3) ! ((0,7,0)|(0,2,1)) = ((0,7,1)|(0,2,0))+((0,7,0)|(0,2,0))*AB(3)
        ! theta(3366) = theta(2539)+theta(2275)*AB(2) ! ((0,7,0)|(0,1,2)) = ((0,8,0)|(0,0,2))+((0,7,0)|(0,0,2))*AB(2)
        theta(3367) = theta(2545)+theta(2275)*AB(3) ! ((0,7,0)|(0,0,3)) = ((0,7,1)|(0,0,2))+((0,7,0)|(0,0,2))*AB(3)
        theta(3368) = theta(2492)+theta(2276)*AB(1) ! ((0,6,1)|(3,0,0)) = ((1,6,1)|(2,0,0))+((0,6,1)|(2,0,0))*AB(1)
        ! theta(3369) = theta(2493)+theta(2277)*AB(1) ! ((0,6,1)|(2,1,0)) = ((1,6,1)|(1,1,0))+((0,6,1)|(1,1,0))*AB(1)
        ! theta(3370) = theta(2546)+theta(2276)*AB(3) ! ((0,6,1)|(2,0,1)) = ((0,6,2)|(2,0,0))+((0,6,1)|(2,0,0))*AB(3)
        ! theta(3371) = theta(2495)+theta(2279)*AB(1) ! ((0,6,1)|(1,2,0)) = ((1,6,1)|(0,2,0))+((0,6,1)|(0,2,0))*AB(1)
        ! theta(3372) = theta(2496)+theta(2280)*AB(1) ! ((0,6,1)|(1,1,1)) = ((1,6,1)|(0,1,1))+((0,6,1)|(0,1,1))*AB(1)
        ! theta(3373) = theta(2497)+theta(2281)*AB(1) ! ((0,6,1)|(1,0,2)) = ((1,6,1)|(0,0,2))+((0,6,1)|(0,0,2))*AB(1)
        theta(3374) = theta(2543)+theta(2279)*AB(2) ! ((0,6,1)|(0,3,0)) = ((0,7,1)|(0,2,0))+((0,6,1)|(0,2,0))*AB(2)
        ! theta(3375) = theta(2549)+theta(2279)*AB(3) ! ((0,6,1)|(0,2,1)) = ((0,6,2)|(0,2,0))+((0,6,1)|(0,2,0))*AB(3)
        ! theta(3376) = theta(2545)+theta(2281)*AB(2) ! ((0,6,1)|(0,1,2)) = ((0,7,1)|(0,0,2))+((0,6,1)|(0,0,2))*AB(2)
        theta(3377) = theta(2551)+theta(2281)*AB(3) ! ((0,6,1)|(0,0,3)) = ((0,6,2)|(0,0,2))+((0,6,1)|(0,0,2))*AB(3)
        theta(3378) = theta(2498)+theta(2282)*AB(1) ! ((0,5,2)|(3,0,0)) = ((1,5,2)|(2,0,0))+((0,5,2)|(2,0,0))*AB(1)
        ! theta(3379) = theta(2499)+theta(2283)*AB(1) ! ((0,5,2)|(2,1,0)) = ((1,5,2)|(1,1,0))+((0,5,2)|(1,1,0))*AB(1)
        ! theta(3380) = theta(2552)+theta(2282)*AB(3) ! ((0,5,2)|(2,0,1)) = ((0,5,3)|(2,0,0))+((0,5,2)|(2,0,0))*AB(3)
        ! theta(3381) = theta(2501)+theta(2285)*AB(1) ! ((0,5,2)|(1,2,0)) = ((1,5,2)|(0,2,0))+((0,5,2)|(0,2,0))*AB(1)
        ! theta(3382) = theta(2502)+theta(2286)*AB(1) ! ((0,5,2)|(1,1,1)) = ((1,5,2)|(0,1,1))+((0,5,2)|(0,1,1))*AB(1)
        ! theta(3383) = theta(2503)+theta(2287)*AB(1) ! ((0,5,2)|(1,0,2)) = ((1,5,2)|(0,0,2))+((0,5,2)|(0,0,2))*AB(1)
        theta(3384) = theta(2549)+theta(2285)*AB(2) ! ((0,5,2)|(0,3,0)) = ((0,6,2)|(0,2,0))+((0,5,2)|(0,2,0))*AB(2)
        ! theta(3385) = theta(2555)+theta(2285)*AB(3) ! ((0,5,2)|(0,2,1)) = ((0,5,3)|(0,2,0))+((0,5,2)|(0,2,0))*AB(3)
        ! theta(3386) = theta(2551)+theta(2287)*AB(2) ! ((0,5,2)|(0,1,2)) = ((0,6,2)|(0,0,2))+((0,5,2)|(0,0,2))*AB(2)
        theta(3387) = theta(2557)+theta(2287)*AB(3) ! ((0,5,2)|(0,0,3)) = ((0,5,3)|(0,0,2))+((0,5,2)|(0,0,2))*AB(3)
        theta(3388) = theta(2504)+theta(2288)*AB(1) ! ((0,4,3)|(3,0,0)) = ((1,4,3)|(2,0,0))+((0,4,3)|(2,0,0))*AB(1)
        ! theta(3389) = theta(2505)+theta(2289)*AB(1) ! ((0,4,3)|(2,1,0)) = ((1,4,3)|(1,1,0))+((0,4,3)|(1,1,0))*AB(1)
        ! theta(3390) = theta(2558)+theta(2288)*AB(3) ! ((0,4,3)|(2,0,1)) = ((0,4,4)|(2,0,0))+((0,4,3)|(2,0,0))*AB(3)
        ! theta(3391) = theta(2507)+theta(2291)*AB(1) ! ((0,4,3)|(1,2,0)) = ((1,4,3)|(0,2,0))+((0,4,3)|(0,2,0))*AB(1)
        ! theta(3392) = theta(2508)+theta(2292)*AB(1) ! ((0,4,3)|(1,1,1)) = ((1,4,3)|(0,1,1))+((0,4,3)|(0,1,1))*AB(1)
        ! theta(3393) = theta(2509)+theta(2293)*AB(1) ! ((0,4,3)|(1,0,2)) = ((1,4,3)|(0,0,2))+((0,4,3)|(0,0,2))*AB(1)
        theta(3394) = theta(2555)+theta(2291)*AB(2) ! ((0,4,3)|(0,3,0)) = ((0,5,3)|(0,2,0))+((0,4,3)|(0,2,0))*AB(2)
        ! theta(3395) = theta(2561)+theta(2291)*AB(3) ! ((0,4,3)|(0,2,1)) = ((0,4,4)|(0,2,0))+((0,4,3)|(0,2,0))*AB(3)
        ! theta(3396) = theta(2557)+theta(2293)*AB(2) ! ((0,4,3)|(0,1,2)) = ((0,5,3)|(0,0,2))+((0,4,3)|(0,0,2))*AB(2)
        theta(3397) = theta(2563)+theta(2293)*AB(3) ! ((0,4,3)|(0,0,3)) = ((0,4,4)|(0,0,2))+((0,4,3)|(0,0,2))*AB(3)
        theta(3398) = theta(2510)+theta(2294)*AB(1) ! ((0,3,4)|(3,0,0)) = ((1,3,4)|(2,0,0))+((0,3,4)|(2,0,0))*AB(1)
        ! theta(3399) = theta(2511)+theta(2295)*AB(1) ! ((0,3,4)|(2,1,0)) = ((1,3,4)|(1,1,0))+((0,3,4)|(1,1,0))*AB(1)
        ! theta(3400) = theta(2564)+theta(2294)*AB(3) ! ((0,3,4)|(2,0,1)) = ((0,3,5)|(2,0,0))+((0,3,4)|(2,0,0))*AB(3)
        ! theta(3401) = theta(2513)+theta(2297)*AB(1) ! ((0,3,4)|(1,2,0)) = ((1,3,4)|(0,2,0))+((0,3,4)|(0,2,0))*AB(1)
        ! theta(3402) = theta(2514)+theta(2298)*AB(1) ! ((0,3,4)|(1,1,1)) = ((1,3,4)|(0,1,1))+((0,3,4)|(0,1,1))*AB(1)
        ! theta(3403) = theta(2515)+theta(2299)*AB(1) ! ((0,3,4)|(1,0,2)) = ((1,3,4)|(0,0,2))+((0,3,4)|(0,0,2))*AB(1)
        theta(3404) = theta(2561)+theta(2297)*AB(2) ! ((0,3,4)|(0,3,0)) = ((0,4,4)|(0,2,0))+((0,3,4)|(0,2,0))*AB(2)
        ! theta(3405) = theta(2567)+theta(2297)*AB(3) ! ((0,3,4)|(0,2,1)) = ((0,3,5)|(0,2,0))+((0,3,4)|(0,2,0))*AB(3)
        ! theta(3406) = theta(2563)+theta(2299)*AB(2) ! ((0,3,4)|(0,1,2)) = ((0,4,4)|(0,0,2))+((0,3,4)|(0,0,2))*AB(2)
        theta(3407) = theta(2569)+theta(2299)*AB(3) ! ((0,3,4)|(0,0,3)) = ((0,3,5)|(0,0,2))+((0,3,4)|(0,0,2))*AB(3)
        theta(3408) = theta(2516)+theta(2300)*AB(1) ! ((0,2,5)|(3,0,0)) = ((1,2,5)|(2,0,0))+((0,2,5)|(2,0,0))*AB(1)
        ! theta(3409) = theta(2517)+theta(2301)*AB(1) ! ((0,2,5)|(2,1,0)) = ((1,2,5)|(1,1,0))+((0,2,5)|(1,1,0))*AB(1)
        ! theta(3410) = theta(2570)+theta(2300)*AB(3) ! ((0,2,5)|(2,0,1)) = ((0,2,6)|(2,0,0))+((0,2,5)|(2,0,0))*AB(3)
        ! theta(3411) = theta(2519)+theta(2303)*AB(1) ! ((0,2,5)|(1,2,0)) = ((1,2,5)|(0,2,0))+((0,2,5)|(0,2,0))*AB(1)
        ! theta(3412) = theta(2520)+theta(2304)*AB(1) ! ((0,2,5)|(1,1,1)) = ((1,2,5)|(0,1,1))+((0,2,5)|(0,1,1))*AB(1)
        ! theta(3413) = theta(2521)+theta(2305)*AB(1) ! ((0,2,5)|(1,0,2)) = ((1,2,5)|(0,0,2))+((0,2,5)|(0,0,2))*AB(1)
        theta(3414) = theta(2567)+theta(2303)*AB(2) ! ((0,2,5)|(0,3,0)) = ((0,3,5)|(0,2,0))+((0,2,5)|(0,2,0))*AB(2)
        ! theta(3415) = theta(2573)+theta(2303)*AB(3) ! ((0,2,5)|(0,2,1)) = ((0,2,6)|(0,2,0))+((0,2,5)|(0,2,0))*AB(3)
        ! theta(3416) = theta(2569)+theta(2305)*AB(2) ! ((0,2,5)|(0,1,2)) = ((0,3,5)|(0,0,2))+((0,2,5)|(0,0,2))*AB(2)
        theta(3417) = theta(2575)+theta(2305)*AB(3) ! ((0,2,5)|(0,0,3)) = ((0,2,6)|(0,0,2))+((0,2,5)|(0,0,2))*AB(3)
        theta(3418) = theta(2522)+theta(2306)*AB(1) ! ((0,1,6)|(3,0,0)) = ((1,1,6)|(2,0,0))+((0,1,6)|(2,0,0))*AB(1)
        ! theta(3419) = theta(2523)+theta(2307)*AB(1) ! ((0,1,6)|(2,1,0)) = ((1,1,6)|(1,1,0))+((0,1,6)|(1,1,0))*AB(1)
        ! theta(3420) = theta(2576)+theta(2306)*AB(3) ! ((0,1,6)|(2,0,1)) = ((0,1,7)|(2,0,0))+((0,1,6)|(2,0,0))*AB(3)
        ! theta(3421) = theta(2525)+theta(2309)*AB(1) ! ((0,1,6)|(1,2,0)) = ((1,1,6)|(0,2,0))+((0,1,6)|(0,2,0))*AB(1)
        ! theta(3422) = theta(2526)+theta(2310)*AB(1) ! ((0,1,6)|(1,1,1)) = ((1,1,6)|(0,1,1))+((0,1,6)|(0,1,1))*AB(1)
        ! theta(3423) = theta(2527)+theta(2311)*AB(1) ! ((0,1,6)|(1,0,2)) = ((1,1,6)|(0,0,2))+((0,1,6)|(0,0,2))*AB(1)
        theta(3424) = theta(2573)+theta(2309)*AB(2) ! ((0,1,6)|(0,3,0)) = ((0,2,6)|(0,2,0))+((0,1,6)|(0,2,0))*AB(2)
        ! theta(3425) = theta(2579)+theta(2309)*AB(3) ! ((0,1,6)|(0,2,1)) = ((0,1,7)|(0,2,0))+((0,1,6)|(0,2,0))*AB(3)
        ! theta(3426) = theta(2575)+theta(2311)*AB(2) ! ((0,1,6)|(0,1,2)) = ((0,2,6)|(0,0,2))+((0,1,6)|(0,0,2))*AB(2)
        theta(3427) = theta(2581)+theta(2311)*AB(3) ! ((0,1,6)|(0,0,3)) = ((0,1,7)|(0,0,2))+((0,1,6)|(0,0,2))*AB(3)
        theta(3428) = theta(2528)+theta(2312)*AB(1) ! ((0,0,7)|(3,0,0)) = ((1,0,7)|(2,0,0))+((0,0,7)|(2,0,0))*AB(1)
        ! theta(3429) = theta(2529)+theta(2313)*AB(1) ! ((0,0,7)|(2,1,0)) = ((1,0,7)|(1,1,0))+((0,0,7)|(1,1,0))*AB(1)
        ! theta(3430) = theta(2582)+theta(2312)*AB(3) ! ((0,0,7)|(2,0,1)) = ((0,0,8)|(2,0,0))+((0,0,7)|(2,0,0))*AB(3)
        ! theta(3431) = theta(2531)+theta(2315)*AB(1) ! ((0,0,7)|(1,2,0)) = ((1,0,7)|(0,2,0))+((0,0,7)|(0,2,0))*AB(1)
        ! theta(3432) = theta(2532)+theta(2316)*AB(1) ! ((0,0,7)|(1,1,1)) = ((1,0,7)|(0,1,1))+((0,0,7)|(0,1,1))*AB(1)
        ! theta(3433) = theta(2533)+theta(2317)*AB(1) ! ((0,0,7)|(1,0,2)) = ((1,0,7)|(0,0,2))+((0,0,7)|(0,0,2))*AB(1)
        theta(3434) = theta(2579)+theta(2315)*AB(2) ! ((0,0,7)|(0,3,0)) = ((0,1,7)|(0,2,0))+((0,0,7)|(0,2,0))*AB(2)
        ! theta(3435) = theta(2585)+theta(2315)*AB(3) ! ((0,0,7)|(0,2,1)) = ((0,0,8)|(0,2,0))+((0,0,7)|(0,2,0))*AB(3)
        ! theta(3436) = theta(2581)+theta(2317)*AB(2) ! ((0,0,7)|(0,1,2)) = ((0,1,7)|(0,0,2))+((0,0,7)|(0,0,2))*AB(2)
        theta(3437) = theta(2587)+theta(2317)*AB(3) ! ((0,0,7)|(0,0,3)) = ((0,0,8)|(0,0,2))+((0,0,7)|(0,0,2))*AB(3)
        theta(3438) = theta(2798)+theta(2588)*AB(1) ! ((5,0,0)|(4,0,0)) = ((6,0,0)|(3,0,0))+((5,0,0)|(3,0,0))*AB(1)
        theta(3439) = theta(2808)+theta(2588)*AB(2) ! ((5,0,0)|(3,1,0)) = ((5,1,0)|(3,0,0))+((5,0,0)|(3,0,0))*AB(2)
        theta(3440) = theta(2818)+theta(2588)*AB(3) ! ((5,0,0)|(3,0,1)) = ((5,0,1)|(3,0,0))+((5,0,0)|(3,0,0))*AB(3)
        ! theta(3441) = theta(2801)+theta(2591)*AB(1) ! ((5,0,0)|(2,2,0)) = ((6,0,0)|(1,2,0))+((5,0,0)|(1,2,0))*AB(1)
        ! theta(3442) = theta(2810)+theta(2590)*AB(2) ! ((5,0,0)|(2,1,1)) = ((5,1,0)|(2,0,1))+((5,0,0)|(2,0,1))*AB(2)
        theta(3443) = theta(2803)+theta(2593)*AB(1) ! ((5,0,0)|(2,0,2)) = ((6,0,0)|(1,0,2))+((5,0,0)|(1,0,2))*AB(1)
        theta(3444) = theta(2804)+theta(2594)*AB(1) ! ((5,0,0)|(1,3,0)) = ((6,0,0)|(0,3,0))+((5,0,0)|(0,3,0))*AB(1)
        theta(3445) = theta(2805)+theta(2595)*AB(1) ! ((5,0,0)|(1,2,1)) = ((6,0,0)|(0,2,1))+((5,0,0)|(0,2,1))*AB(1)
        ! theta(3446) = theta(2806)+theta(2596)*AB(1) ! ((5,0,0)|(1,1,2)) = ((6,0,0)|(0,1,2))+((5,0,0)|(0,1,2))*AB(1)
        theta(3447) = theta(2807)+theta(2597)*AB(1) ! ((5,0,0)|(1,0,3)) = ((6,0,0)|(0,0,3))+((5,0,0)|(0,0,3))*AB(1)
        theta(3448) = theta(2814)+theta(2594)*AB(2) ! ((5,0,0)|(0,4,0)) = ((5,1,0)|(0,3,0))+((5,0,0)|(0,3,0))*AB(2)
        theta(3449) = theta(2824)+theta(2594)*AB(3) ! ((5,0,0)|(0,3,1)) = ((5,0,1)|(0,3,0))+((5,0,0)|(0,3,0))*AB(3)
        theta(3450) = theta(2816)+theta(2596)*AB(2) ! ((5,0,0)|(0,2,2)) = ((5,1,0)|(0,1,2))+((5,0,0)|(0,1,2))*AB(2)
        theta(3451) = theta(2817)+theta(2597)*AB(2) ! ((5,0,0)|(0,1,3)) = ((5,1,0)|(0,0,3))+((5,0,0)|(0,0,3))*AB(2)
        theta(3452) = theta(2827)+theta(2597)*AB(3) ! ((5,0,0)|(0,0,4)) = ((5,0,1)|(0,0,3))+((5,0,0)|(0,0,3))*AB(3)
        theta(3453) = theta(2808)+theta(2598)*AB(1) ! ((4,1,0)|(4,0,0)) = ((5,1,0)|(3,0,0))+((4,1,0)|(3,0,0))*AB(1)
        theta(3454) = theta(2828)+theta(2598)*AB(2) ! ((4,1,0)|(3,1,0)) = ((4,2,0)|(3,0,0))+((4,1,0)|(3,0,0))*AB(2)
        theta(3455) = theta(2838)+theta(2598)*AB(3) ! ((4,1,0)|(3,0,1)) = ((4,1,1)|(3,0,0))+((4,1,0)|(3,0,0))*AB(3)
        ! theta(3456) = theta(2811)+theta(2601)*AB(1) ! ((4,1,0)|(2,2,0)) = ((5,1,0)|(1,2,0))+((4,1,0)|(1,2,0))*AB(1)
        ! theta(3457) = theta(2830)+theta(2600)*AB(2) ! ((4,1,0)|(2,1,1)) = ((4,2,0)|(2,0,1))+((4,1,0)|(2,0,1))*AB(2)
        theta(3458) = theta(2813)+theta(2603)*AB(1) ! ((4,1,0)|(2,0,2)) = ((5,1,0)|(1,0,2))+((4,1,0)|(1,0,2))*AB(1)
        theta(3459) = theta(2814)+theta(2604)*AB(1) ! ((4,1,0)|(1,3,0)) = ((5,1,0)|(0,3,0))+((4,1,0)|(0,3,0))*AB(1)
        theta(3460) = theta(2815)+theta(2605)*AB(1) ! ((4,1,0)|(1,2,1)) = ((5,1,0)|(0,2,1))+((4,1,0)|(0,2,1))*AB(1)
        ! theta(3461) = theta(2816)+theta(2606)*AB(1) ! ((4,1,0)|(1,1,2)) = ((5,1,0)|(0,1,2))+((4,1,0)|(0,1,2))*AB(1)
        theta(3462) = theta(2817)+theta(2607)*AB(1) ! ((4,1,0)|(1,0,3)) = ((5,1,0)|(0,0,3))+((4,1,0)|(0,0,3))*AB(1)
        theta(3463) = theta(2834)+theta(2604)*AB(2) ! ((4,1,0)|(0,4,0)) = ((4,2,0)|(0,3,0))+((4,1,0)|(0,3,0))*AB(2)
        theta(3464) = theta(2844)+theta(2604)*AB(3) ! ((4,1,0)|(0,3,1)) = ((4,1,1)|(0,3,0))+((4,1,0)|(0,3,0))*AB(3)
        theta(3465) = theta(2836)+theta(2606)*AB(2) ! ((4,1,0)|(0,2,2)) = ((4,2,0)|(0,1,2))+((4,1,0)|(0,1,2))*AB(2)
        theta(3466) = theta(2837)+theta(2607)*AB(2) ! ((4,1,0)|(0,1,3)) = ((4,2,0)|(0,0,3))+((4,1,0)|(0,0,3))*AB(2)
        theta(3467) = theta(2847)+theta(2607)*AB(3) ! ((4,1,0)|(0,0,4)) = ((4,1,1)|(0,0,3))+((4,1,0)|(0,0,3))*AB(3)
        theta(3468) = theta(2818)+theta(2608)*AB(1) ! ((4,0,1)|(4,0,0)) = ((5,0,1)|(3,0,0))+((4,0,1)|(3,0,0))*AB(1)
        theta(3469) = theta(2819)+theta(2609)*AB(1) ! ((4,0,1)|(3,1,0)) = ((5,0,1)|(2,1,0))+((4,0,1)|(2,1,0))*AB(1)
        theta(3470) = theta(2848)+theta(2608)*AB(3) ! ((4,0,1)|(3,0,1)) = ((4,0,2)|(3,0,0))+((4,0,1)|(3,0,0))*AB(3)
        theta(3471) = theta(2821)+theta(2611)*AB(1) ! ((4,0,1)|(2,2,0)) = ((5,0,1)|(1,2,0))+((4,0,1)|(1,2,0))*AB(1)
        theta(3472) = theta(2822)+theta(2612)*AB(1) ! ((4,0,1)|(2,1,1)) = ((5,0,1)|(1,1,1))+((4,0,1)|(1,1,1))*AB(1)
        ! theta(3473) = theta(2823)+theta(2613)*AB(1) ! ((4,0,1)|(2,0,2)) = ((5,0,1)|(1,0,2))+((4,0,1)|(1,0,2))*AB(1)
        theta(3474) = theta(2824)+theta(2614)*AB(1) ! ((4,0,1)|(1,3,0)) = ((5,0,1)|(0,3,0))+((4,0,1)|(0,3,0))*AB(1)
        theta(3475) = theta(2825)+theta(2615)*AB(1) ! ((4,0,1)|(1,2,1)) = ((5,0,1)|(0,2,1))+((4,0,1)|(0,2,1))*AB(1)
        theta(3476) = theta(2826)+theta(2616)*AB(1) ! ((4,0,1)|(1,1,2)) = ((5,0,1)|(0,1,2))+((4,0,1)|(0,1,2))*AB(1)
        theta(3477) = theta(2827)+theta(2617)*AB(1) ! ((4,0,1)|(1,0,3)) = ((5,0,1)|(0,0,3))+((4,0,1)|(0,0,3))*AB(1)
        theta(3478) = theta(2844)+theta(2614)*AB(2) ! ((4,0,1)|(0,4,0)) = ((4,1,1)|(0,3,0))+((4,0,1)|(0,3,0))*AB(2)
        theta(3479) = theta(2854)+theta(2614)*AB(3) ! ((4,0,1)|(0,3,1)) = ((4,0,2)|(0,3,0))+((4,0,1)|(0,3,0))*AB(3)
        theta(3480) = theta(2846)+theta(2616)*AB(2) ! ((4,0,1)|(0,2,2)) = ((4,1,1)|(0,1,2))+((4,0,1)|(0,1,2))*AB(2)
        theta(3481) = theta(2847)+theta(2617)*AB(2) ! ((4,0,1)|(0,1,3)) = ((4,1,1)|(0,0,3))+((4,0,1)|(0,0,3))*AB(2)
        theta(3482) = theta(2857)+theta(2617)*AB(3) ! ((4,0,1)|(0,0,4)) = ((4,0,2)|(0,0,3))+((4,0,1)|(0,0,3))*AB(3)
        theta(3483) = theta(2828)+theta(2618)*AB(1) ! ((3,2,0)|(4,0,0)) = ((4,2,0)|(3,0,0))+((3,2,0)|(3,0,0))*AB(1)
        theta(3484) = theta(2858)+theta(2618)*AB(2) ! ((3,2,0)|(3,1,0)) = ((3,3,0)|(3,0,0))+((3,2,0)|(3,0,0))*AB(2)
        theta(3485) = theta(2868)+theta(2618)*AB(3) ! ((3,2,0)|(3,0,1)) = ((3,2,1)|(3,0,0))+((3,2,0)|(3,0,0))*AB(3)
        ! theta(3486) = theta(2831)+theta(2621)*AB(1) ! ((3,2,0)|(2,2,0)) = ((4,2,0)|(1,2,0))+((3,2,0)|(1,2,0))*AB(1)
        ! theta(3487) = theta(2860)+theta(2620)*AB(2) ! ((3,2,0)|(2,1,1)) = ((3,3,0)|(2,0,1))+((3,2,0)|(2,0,1))*AB(2)
        theta(3488) = theta(2833)+theta(2623)*AB(1) ! ((3,2,0)|(2,0,2)) = ((4,2,0)|(1,0,2))+((3,2,0)|(1,0,2))*AB(1)
        theta(3489) = theta(2834)+theta(2624)*AB(1) ! ((3,2,0)|(1,3,0)) = ((4,2,0)|(0,3,0))+((3,2,0)|(0,3,0))*AB(1)
        theta(3490) = theta(2835)+theta(2625)*AB(1) ! ((3,2,0)|(1,2,1)) = ((4,2,0)|(0,2,1))+((3,2,0)|(0,2,1))*AB(1)
        ! theta(3491) = theta(2836)+theta(2626)*AB(1) ! ((3,2,0)|(1,1,2)) = ((4,2,0)|(0,1,2))+((3,2,0)|(0,1,2))*AB(1)
        theta(3492) = theta(2837)+theta(2627)*AB(1) ! ((3,2,0)|(1,0,3)) = ((4,2,0)|(0,0,3))+((3,2,0)|(0,0,3))*AB(1)
        theta(3493) = theta(2864)+theta(2624)*AB(2) ! ((3,2,0)|(0,4,0)) = ((3,3,0)|(0,3,0))+((3,2,0)|(0,3,0))*AB(2)
        theta(3494) = theta(2874)+theta(2624)*AB(3) ! ((3,2,0)|(0,3,1)) = ((3,2,1)|(0,3,0))+((3,2,0)|(0,3,0))*AB(3)
        theta(3495) = theta(2866)+theta(2626)*AB(2) ! ((3,2,0)|(0,2,2)) = ((3,3,0)|(0,1,2))+((3,2,0)|(0,1,2))*AB(2)
        theta(3496) = theta(2867)+theta(2627)*AB(2) ! ((3,2,0)|(0,1,3)) = ((3,3,0)|(0,0,3))+((3,2,0)|(0,0,3))*AB(2)
        theta(3497) = theta(2877)+theta(2627)*AB(3) ! ((3,2,0)|(0,0,4)) = ((3,2,1)|(0,0,3))+((3,2,0)|(0,0,3))*AB(3)
        theta(3498) = theta(2838)+theta(2628)*AB(1) ! ((3,1,1)|(4,0,0)) = ((4,1,1)|(3,0,0))+((3,1,1)|(3,0,0))*AB(1)
        theta(3499) = theta(2839)+theta(2629)*AB(1) ! ((3,1,1)|(3,1,0)) = ((4,1,1)|(2,1,0))+((3,1,1)|(2,1,0))*AB(1)
        theta(3500) = theta(2878)+theta(2628)*AB(3) ! ((3,1,1)|(3,0,1)) = ((3,1,2)|(3,0,0))+((3,1,1)|(3,0,0))*AB(3)
        theta(3501) = theta(2841)+theta(2631)*AB(1) ! ((3,1,1)|(2,2,0)) = ((4,1,1)|(1,2,0))+((3,1,1)|(1,2,0))*AB(1)
        theta(3502) = theta(2842)+theta(2632)*AB(1) ! ((3,1,1)|(2,1,1)) = ((4,1,1)|(1,1,1))+((3,1,1)|(1,1,1))*AB(1)
        ! theta(3503) = theta(2843)+theta(2633)*AB(1) ! ((3,1,1)|(2,0,2)) = ((4,1,1)|(1,0,2))+((3,1,1)|(1,0,2))*AB(1)
        theta(3504) = theta(2844)+theta(2634)*AB(1) ! ((3,1,1)|(1,3,0)) = ((4,1,1)|(0,3,0))+((3,1,1)|(0,3,0))*AB(1)
        theta(3505) = theta(2845)+theta(2635)*AB(1) ! ((3,1,1)|(1,2,1)) = ((4,1,1)|(0,2,1))+((3,1,1)|(0,2,1))*AB(1)
        theta(3506) = theta(2846)+theta(2636)*AB(1) ! ((3,1,1)|(1,1,2)) = ((4,1,1)|(0,1,2))+((3,1,1)|(0,1,2))*AB(1)
        theta(3507) = theta(2847)+theta(2637)*AB(1) ! ((3,1,1)|(1,0,3)) = ((4,1,1)|(0,0,3))+((3,1,1)|(0,0,3))*AB(1)
        theta(3508) = theta(2874)+theta(2634)*AB(2) ! ((3,1,1)|(0,4,0)) = ((3,2,1)|(0,3,0))+((3,1,1)|(0,3,0))*AB(2)
        theta(3509) = theta(2884)+theta(2634)*AB(3) ! ((3,1,1)|(0,3,1)) = ((3,1,2)|(0,3,0))+((3,1,1)|(0,3,0))*AB(3)
        theta(3510) = theta(2876)+theta(2636)*AB(2) ! ((3,1,1)|(0,2,2)) = ((3,2,1)|(0,1,2))+((3,1,1)|(0,1,2))*AB(2)
        theta(3511) = theta(2877)+theta(2637)*AB(2) ! ((3,1,1)|(0,1,3)) = ((3,2,1)|(0,0,3))+((3,1,1)|(0,0,3))*AB(2)
        theta(3512) = theta(2887)+theta(2637)*AB(3) ! ((3,1,1)|(0,0,4)) = ((3,1,2)|(0,0,3))+((3,1,1)|(0,0,3))*AB(3)
        theta(3513) = theta(2848)+theta(2638)*AB(1) ! ((3,0,2)|(4,0,0)) = ((4,0,2)|(3,0,0))+((3,0,2)|(3,0,0))*AB(1)
        theta(3514) = theta(2849)+theta(2639)*AB(1) ! ((3,0,2)|(3,1,0)) = ((4,0,2)|(2,1,0))+((3,0,2)|(2,1,0))*AB(1)
        theta(3515) = theta(2888)+theta(2638)*AB(3) ! ((3,0,2)|(3,0,1)) = ((3,0,3)|(3,0,0))+((3,0,2)|(3,0,0))*AB(3)
        theta(3516) = theta(2851)+theta(2641)*AB(1) ! ((3,0,2)|(2,2,0)) = ((4,0,2)|(1,2,0))+((3,0,2)|(1,2,0))*AB(1)
        theta(3517) = theta(2852)+theta(2642)*AB(1) ! ((3,0,2)|(2,1,1)) = ((4,0,2)|(1,1,1))+((3,0,2)|(1,1,1))*AB(1)
        ! theta(3518) = theta(2853)+theta(2643)*AB(1) ! ((3,0,2)|(2,0,2)) = ((4,0,2)|(1,0,2))+((3,0,2)|(1,0,2))*AB(1)
        theta(3519) = theta(2854)+theta(2644)*AB(1) ! ((3,0,2)|(1,3,0)) = ((4,0,2)|(0,3,0))+((3,0,2)|(0,3,0))*AB(1)
        theta(3520) = theta(2855)+theta(2645)*AB(1) ! ((3,0,2)|(1,2,1)) = ((4,0,2)|(0,2,1))+((3,0,2)|(0,2,1))*AB(1)
        theta(3521) = theta(2856)+theta(2646)*AB(1) ! ((3,0,2)|(1,1,2)) = ((4,0,2)|(0,1,2))+((3,0,2)|(0,1,2))*AB(1)
        theta(3522) = theta(2857)+theta(2647)*AB(1) ! ((3,0,2)|(1,0,3)) = ((4,0,2)|(0,0,3))+((3,0,2)|(0,0,3))*AB(1)
        theta(3523) = theta(2884)+theta(2644)*AB(2) ! ((3,0,2)|(0,4,0)) = ((3,1,2)|(0,3,0))+((3,0,2)|(0,3,0))*AB(2)
        theta(3524) = theta(2894)+theta(2644)*AB(3) ! ((3,0,2)|(0,3,1)) = ((3,0,3)|(0,3,0))+((3,0,2)|(0,3,0))*AB(3)
        theta(3525) = theta(2886)+theta(2646)*AB(2) ! ((3,0,2)|(0,2,2)) = ((3,1,2)|(0,1,2))+((3,0,2)|(0,1,2))*AB(2)
        theta(3526) = theta(2887)+theta(2647)*AB(2) ! ((3,0,2)|(0,1,3)) = ((3,1,2)|(0,0,3))+((3,0,2)|(0,0,3))*AB(2)
        theta(3527) = theta(2897)+theta(2647)*AB(3) ! ((3,0,2)|(0,0,4)) = ((3,0,3)|(0,0,3))+((3,0,2)|(0,0,3))*AB(3)
        theta(3528) = theta(2858)+theta(2648)*AB(1) ! ((2,3,0)|(4,0,0)) = ((3,3,0)|(3,0,0))+((2,3,0)|(3,0,0))*AB(1)
        theta(3529) = theta(2898)+theta(2648)*AB(2) ! ((2,3,0)|(3,1,0)) = ((2,4,0)|(3,0,0))+((2,3,0)|(3,0,0))*AB(2)
        theta(3530) = theta(2908)+theta(2648)*AB(3) ! ((2,3,0)|(3,0,1)) = ((2,3,1)|(3,0,0))+((2,3,0)|(3,0,0))*AB(3)
        ! theta(3531) = theta(2861)+theta(2651)*AB(1) ! ((2,3,0)|(2,2,0)) = ((3,3,0)|(1,2,0))+((2,3,0)|(1,2,0))*AB(1)
        ! theta(3532) = theta(2900)+theta(2650)*AB(2) ! ((2,3,0)|(2,1,1)) = ((2,4,0)|(2,0,1))+((2,3,0)|(2,0,1))*AB(2)
        theta(3533) = theta(2863)+theta(2653)*AB(1) ! ((2,3,0)|(2,0,2)) = ((3,3,0)|(1,0,2))+((2,3,0)|(1,0,2))*AB(1)
        theta(3534) = theta(2864)+theta(2654)*AB(1) ! ((2,3,0)|(1,3,0)) = ((3,3,0)|(0,3,0))+((2,3,0)|(0,3,0))*AB(1)
        theta(3535) = theta(2865)+theta(2655)*AB(1) ! ((2,3,0)|(1,2,1)) = ((3,3,0)|(0,2,1))+((2,3,0)|(0,2,1))*AB(1)
        ! theta(3536) = theta(2866)+theta(2656)*AB(1) ! ((2,3,0)|(1,1,2)) = ((3,3,0)|(0,1,2))+((2,3,0)|(0,1,2))*AB(1)
        theta(3537) = theta(2867)+theta(2657)*AB(1) ! ((2,3,0)|(1,0,3)) = ((3,3,0)|(0,0,3))+((2,3,0)|(0,0,3))*AB(1)
        theta(3538) = theta(2904)+theta(2654)*AB(2) ! ((2,3,0)|(0,4,0)) = ((2,4,0)|(0,3,0))+((2,3,0)|(0,3,0))*AB(2)
        theta(3539) = theta(2914)+theta(2654)*AB(3) ! ((2,3,0)|(0,3,1)) = ((2,3,1)|(0,3,0))+((2,3,0)|(0,3,0))*AB(3)
        theta(3540) = theta(2906)+theta(2656)*AB(2) ! ((2,3,0)|(0,2,2)) = ((2,4,0)|(0,1,2))+((2,3,0)|(0,1,2))*AB(2)
        theta(3541) = theta(2907)+theta(2657)*AB(2) ! ((2,3,0)|(0,1,3)) = ((2,4,0)|(0,0,3))+((2,3,0)|(0,0,3))*AB(2)
        theta(3542) = theta(2917)+theta(2657)*AB(3) ! ((2,3,0)|(0,0,4)) = ((2,3,1)|(0,0,3))+((2,3,0)|(0,0,3))*AB(3)
        theta(3543) = theta(2868)+theta(2658)*AB(1) ! ((2,2,1)|(4,0,0)) = ((3,2,1)|(3,0,0))+((2,2,1)|(3,0,0))*AB(1)
        theta(3544) = theta(2869)+theta(2659)*AB(1) ! ((2,2,1)|(3,1,0)) = ((3,2,1)|(2,1,0))+((2,2,1)|(2,1,0))*AB(1)
        theta(3545) = theta(2918)+theta(2658)*AB(3) ! ((2,2,1)|(3,0,1)) = ((2,2,2)|(3,0,0))+((2,2,1)|(3,0,0))*AB(3)
        theta(3546) = theta(2871)+theta(2661)*AB(1) ! ((2,2,1)|(2,2,0)) = ((3,2,1)|(1,2,0))+((2,2,1)|(1,2,0))*AB(1)
        theta(3547) = theta(2872)+theta(2662)*AB(1) ! ((2,2,1)|(2,1,1)) = ((3,2,1)|(1,1,1))+((2,2,1)|(1,1,1))*AB(1)
        ! theta(3548) = theta(2873)+theta(2663)*AB(1) ! ((2,2,1)|(2,0,2)) = ((3,2,1)|(1,0,2))+((2,2,1)|(1,0,2))*AB(1)
        theta(3549) = theta(2874)+theta(2664)*AB(1) ! ((2,2,1)|(1,3,0)) = ((3,2,1)|(0,3,0))+((2,2,1)|(0,3,0))*AB(1)
        theta(3550) = theta(2875)+theta(2665)*AB(1) ! ((2,2,1)|(1,2,1)) = ((3,2,1)|(0,2,1))+((2,2,1)|(0,2,1))*AB(1)
        theta(3551) = theta(2876)+theta(2666)*AB(1) ! ((2,2,1)|(1,1,2)) = ((3,2,1)|(0,1,2))+((2,2,1)|(0,1,2))*AB(1)
        theta(3552) = theta(2877)+theta(2667)*AB(1) ! ((2,2,1)|(1,0,3)) = ((3,2,1)|(0,0,3))+((2,2,1)|(0,0,3))*AB(1)
        theta(3553) = theta(2914)+theta(2664)*AB(2) ! ((2,2,1)|(0,4,0)) = ((2,3,1)|(0,3,0))+((2,2,1)|(0,3,0))*AB(2)
        theta(3554) = theta(2924)+theta(2664)*AB(3) ! ((2,2,1)|(0,3,1)) = ((2,2,2)|(0,3,0))+((2,2,1)|(0,3,0))*AB(3)
        theta(3555) = theta(2916)+theta(2666)*AB(2) ! ((2,2,1)|(0,2,2)) = ((2,3,1)|(0,1,2))+((2,2,1)|(0,1,2))*AB(2)
        theta(3556) = theta(2917)+theta(2667)*AB(2) ! ((2,2,1)|(0,1,3)) = ((2,3,1)|(0,0,3))+((2,2,1)|(0,0,3))*AB(2)
        theta(3557) = theta(2927)+theta(2667)*AB(3) ! ((2,2,1)|(0,0,4)) = ((2,2,2)|(0,0,3))+((2,2,1)|(0,0,3))*AB(3)
        theta(3558) = theta(2878)+theta(2668)*AB(1) ! ((2,1,2)|(4,0,0)) = ((3,1,2)|(3,0,0))+((2,1,2)|(3,0,0))*AB(1)
        theta(3559) = theta(2879)+theta(2669)*AB(1) ! ((2,1,2)|(3,1,0)) = ((3,1,2)|(2,1,0))+((2,1,2)|(2,1,0))*AB(1)
        theta(3560) = theta(2928)+theta(2668)*AB(3) ! ((2,1,2)|(3,0,1)) = ((2,1,3)|(3,0,0))+((2,1,2)|(3,0,0))*AB(3)
        theta(3561) = theta(2881)+theta(2671)*AB(1) ! ((2,1,2)|(2,2,0)) = ((3,1,2)|(1,2,0))+((2,1,2)|(1,2,0))*AB(1)
        theta(3562) = theta(2882)+theta(2672)*AB(1) ! ((2,1,2)|(2,1,1)) = ((3,1,2)|(1,1,1))+((2,1,2)|(1,1,1))*AB(1)
        ! theta(3563) = theta(2883)+theta(2673)*AB(1) ! ((2,1,2)|(2,0,2)) = ((3,1,2)|(1,0,2))+((2,1,2)|(1,0,2))*AB(1)
        theta(3564) = theta(2884)+theta(2674)*AB(1) ! ((2,1,2)|(1,3,0)) = ((3,1,2)|(0,3,0))+((2,1,2)|(0,3,0))*AB(1)
        theta(3565) = theta(2885)+theta(2675)*AB(1) ! ((2,1,2)|(1,2,1)) = ((3,1,2)|(0,2,1))+((2,1,2)|(0,2,1))*AB(1)
        theta(3566) = theta(2886)+theta(2676)*AB(1) ! ((2,1,2)|(1,1,2)) = ((3,1,2)|(0,1,2))+((2,1,2)|(0,1,2))*AB(1)
        theta(3567) = theta(2887)+theta(2677)*AB(1) ! ((2,1,2)|(1,0,3)) = ((3,1,2)|(0,0,3))+((2,1,2)|(0,0,3))*AB(1)
        theta(3568) = theta(2924)+theta(2674)*AB(2) ! ((2,1,2)|(0,4,0)) = ((2,2,2)|(0,3,0))+((2,1,2)|(0,3,0))*AB(2)
        theta(3569) = theta(2934)+theta(2674)*AB(3) ! ((2,1,2)|(0,3,1)) = ((2,1,3)|(0,3,0))+((2,1,2)|(0,3,0))*AB(3)
        theta(3570) = theta(2926)+theta(2676)*AB(2) ! ((2,1,2)|(0,2,2)) = ((2,2,2)|(0,1,2))+((2,1,2)|(0,1,2))*AB(2)
        theta(3571) = theta(2927)+theta(2677)*AB(2) ! ((2,1,2)|(0,1,3)) = ((2,2,2)|(0,0,3))+((2,1,2)|(0,0,3))*AB(2)
        theta(3572) = theta(2937)+theta(2677)*AB(3) ! ((2,1,2)|(0,0,4)) = ((2,1,3)|(0,0,3))+((2,1,2)|(0,0,3))*AB(3)
        theta(3573) = theta(2888)+theta(2678)*AB(1) ! ((2,0,3)|(4,0,0)) = ((3,0,3)|(3,0,0))+((2,0,3)|(3,0,0))*AB(1)
        theta(3574) = theta(2889)+theta(2679)*AB(1) ! ((2,0,3)|(3,1,0)) = ((3,0,3)|(2,1,0))+((2,0,3)|(2,1,0))*AB(1)
        theta(3575) = theta(2938)+theta(2678)*AB(3) ! ((2,0,3)|(3,0,1)) = ((2,0,4)|(3,0,0))+((2,0,3)|(3,0,0))*AB(3)
        theta(3576) = theta(2891)+theta(2681)*AB(1) ! ((2,0,3)|(2,2,0)) = ((3,0,3)|(1,2,0))+((2,0,3)|(1,2,0))*AB(1)
        theta(3577) = theta(2892)+theta(2682)*AB(1) ! ((2,0,3)|(2,1,1)) = ((3,0,3)|(1,1,1))+((2,0,3)|(1,1,1))*AB(1)
        ! theta(3578) = theta(2893)+theta(2683)*AB(1) ! ((2,0,3)|(2,0,2)) = ((3,0,3)|(1,0,2))+((2,0,3)|(1,0,2))*AB(1)
        theta(3579) = theta(2894)+theta(2684)*AB(1) ! ((2,0,3)|(1,3,0)) = ((3,0,3)|(0,3,0))+((2,0,3)|(0,3,0))*AB(1)
        theta(3580) = theta(2895)+theta(2685)*AB(1) ! ((2,0,3)|(1,2,1)) = ((3,0,3)|(0,2,1))+((2,0,3)|(0,2,1))*AB(1)
        theta(3581) = theta(2896)+theta(2686)*AB(1) ! ((2,0,3)|(1,1,2)) = ((3,0,3)|(0,1,2))+((2,0,3)|(0,1,2))*AB(1)
        theta(3582) = theta(2897)+theta(2687)*AB(1) ! ((2,0,3)|(1,0,3)) = ((3,0,3)|(0,0,3))+((2,0,3)|(0,0,3))*AB(1)
        theta(3583) = theta(2934)+theta(2684)*AB(2) ! ((2,0,3)|(0,4,0)) = ((2,1,3)|(0,3,0))+((2,0,3)|(0,3,0))*AB(2)
        theta(3584) = theta(2944)+theta(2684)*AB(3) ! ((2,0,3)|(0,3,1)) = ((2,0,4)|(0,3,0))+((2,0,3)|(0,3,0))*AB(3)
        theta(3585) = theta(2936)+theta(2686)*AB(2) ! ((2,0,3)|(0,2,2)) = ((2,1,3)|(0,1,2))+((2,0,3)|(0,1,2))*AB(2)
        theta(3586) = theta(2937)+theta(2687)*AB(2) ! ((2,0,3)|(0,1,3)) = ((2,1,3)|(0,0,3))+((2,0,3)|(0,0,3))*AB(2)
        theta(3587) = theta(2947)+theta(2687)*AB(3) ! ((2,0,3)|(0,0,4)) = ((2,0,4)|(0,0,3))+((2,0,3)|(0,0,3))*AB(3)
        theta(3588) = theta(2898)+theta(2688)*AB(1) ! ((1,4,0)|(4,0,0)) = ((2,4,0)|(3,0,0))+((1,4,0)|(3,0,0))*AB(1)
        theta(3589) = theta(2948)+theta(2688)*AB(2) ! ((1,4,0)|(3,1,0)) = ((1,5,0)|(3,0,0))+((1,4,0)|(3,0,0))*AB(2)
        theta(3590) = theta(2958)+theta(2688)*AB(3) ! ((1,4,0)|(3,0,1)) = ((1,4,1)|(3,0,0))+((1,4,0)|(3,0,0))*AB(3)
        ! theta(3591) = theta(2901)+theta(2691)*AB(1) ! ((1,4,0)|(2,2,0)) = ((2,4,0)|(1,2,0))+((1,4,0)|(1,2,0))*AB(1)
        ! theta(3592) = theta(2950)+theta(2690)*AB(2) ! ((1,4,0)|(2,1,1)) = ((1,5,0)|(2,0,1))+((1,4,0)|(2,0,1))*AB(2)
        theta(3593) = theta(2903)+theta(2693)*AB(1) ! ((1,4,0)|(2,0,2)) = ((2,4,0)|(1,0,2))+((1,4,0)|(1,0,2))*AB(1)
        theta(3594) = theta(2904)+theta(2694)*AB(1) ! ((1,4,0)|(1,3,0)) = ((2,4,0)|(0,3,0))+((1,4,0)|(0,3,0))*AB(1)
        theta(3595) = theta(2905)+theta(2695)*AB(1) ! ((1,4,0)|(1,2,1)) = ((2,4,0)|(0,2,1))+((1,4,0)|(0,2,1))*AB(1)
        ! theta(3596) = theta(2906)+theta(2696)*AB(1) ! ((1,4,0)|(1,1,2)) = ((2,4,0)|(0,1,2))+((1,4,0)|(0,1,2))*AB(1)
        theta(3597) = theta(2907)+theta(2697)*AB(1) ! ((1,4,0)|(1,0,3)) = ((2,4,0)|(0,0,3))+((1,4,0)|(0,0,3))*AB(1)
        theta(3598) = theta(2954)+theta(2694)*AB(2) ! ((1,4,0)|(0,4,0)) = ((1,5,0)|(0,3,0))+((1,4,0)|(0,3,0))*AB(2)
        theta(3599) = theta(2964)+theta(2694)*AB(3) ! ((1,4,0)|(0,3,1)) = ((1,4,1)|(0,3,0))+((1,4,0)|(0,3,0))*AB(3)
        theta(3600) = theta(2956)+theta(2696)*AB(2) ! ((1,4,0)|(0,2,2)) = ((1,5,0)|(0,1,2))+((1,4,0)|(0,1,2))*AB(2)
        theta(3601) = theta(2957)+theta(2697)*AB(2) ! ((1,4,0)|(0,1,3)) = ((1,5,0)|(0,0,3))+((1,4,0)|(0,0,3))*AB(2)
        theta(3602) = theta(2967)+theta(2697)*AB(3) ! ((1,4,0)|(0,0,4)) = ((1,4,1)|(0,0,3))+((1,4,0)|(0,0,3))*AB(3)
        theta(3603) = theta(2908)+theta(2698)*AB(1) ! ((1,3,1)|(4,0,0)) = ((2,3,1)|(3,0,0))+((1,3,1)|(3,0,0))*AB(1)
        theta(3604) = theta(2909)+theta(2699)*AB(1) ! ((1,3,1)|(3,1,0)) = ((2,3,1)|(2,1,0))+((1,3,1)|(2,1,0))*AB(1)
        theta(3605) = theta(2968)+theta(2698)*AB(3) ! ((1,3,1)|(3,0,1)) = ((1,3,2)|(3,0,0))+((1,3,1)|(3,0,0))*AB(3)
        theta(3606) = theta(2911)+theta(2701)*AB(1) ! ((1,3,1)|(2,2,0)) = ((2,3,1)|(1,2,0))+((1,3,1)|(1,2,0))*AB(1)
        theta(3607) = theta(2912)+theta(2702)*AB(1) ! ((1,3,1)|(2,1,1)) = ((2,3,1)|(1,1,1))+((1,3,1)|(1,1,1))*AB(1)
        ! theta(3608) = theta(2913)+theta(2703)*AB(1) ! ((1,3,1)|(2,0,2)) = ((2,3,1)|(1,0,2))+((1,3,1)|(1,0,2))*AB(1)
        theta(3609) = theta(2914)+theta(2704)*AB(1) ! ((1,3,1)|(1,3,0)) = ((2,3,1)|(0,3,0))+((1,3,1)|(0,3,0))*AB(1)
        theta(3610) = theta(2915)+theta(2705)*AB(1) ! ((1,3,1)|(1,2,1)) = ((2,3,1)|(0,2,1))+((1,3,1)|(0,2,1))*AB(1)
        theta(3611) = theta(2916)+theta(2706)*AB(1) ! ((1,3,1)|(1,1,2)) = ((2,3,1)|(0,1,2))+((1,3,1)|(0,1,2))*AB(1)
        theta(3612) = theta(2917)+theta(2707)*AB(1) ! ((1,3,1)|(1,0,3)) = ((2,3,1)|(0,0,3))+((1,3,1)|(0,0,3))*AB(1)
        theta(3613) = theta(2964)+theta(2704)*AB(2) ! ((1,3,1)|(0,4,0)) = ((1,4,1)|(0,3,0))+((1,3,1)|(0,3,0))*AB(2)
        theta(3614) = theta(2974)+theta(2704)*AB(3) ! ((1,3,1)|(0,3,1)) = ((1,3,2)|(0,3,0))+((1,3,1)|(0,3,0))*AB(3)
        theta(3615) = theta(2966)+theta(2706)*AB(2) ! ((1,3,1)|(0,2,2)) = ((1,4,1)|(0,1,2))+((1,3,1)|(0,1,2))*AB(2)
        theta(3616) = theta(2967)+theta(2707)*AB(2) ! ((1,3,1)|(0,1,3)) = ((1,4,1)|(0,0,3))+((1,3,1)|(0,0,3))*AB(2)
        theta(3617) = theta(2977)+theta(2707)*AB(3) ! ((1,3,1)|(0,0,4)) = ((1,3,2)|(0,0,3))+((1,3,1)|(0,0,3))*AB(3)
        theta(3618) = theta(2918)+theta(2708)*AB(1) ! ((1,2,2)|(4,0,0)) = ((2,2,2)|(3,0,0))+((1,2,2)|(3,0,0))*AB(1)
        theta(3619) = theta(2919)+theta(2709)*AB(1) ! ((1,2,2)|(3,1,0)) = ((2,2,2)|(2,1,0))+((1,2,2)|(2,1,0))*AB(1)
        theta(3620) = theta(2978)+theta(2708)*AB(3) ! ((1,2,2)|(3,0,1)) = ((1,2,3)|(3,0,0))+((1,2,2)|(3,0,0))*AB(3)
        theta(3621) = theta(2921)+theta(2711)*AB(1) ! ((1,2,2)|(2,2,0)) = ((2,2,2)|(1,2,0))+((1,2,2)|(1,2,0))*AB(1)
        theta(3622) = theta(2922)+theta(2712)*AB(1) ! ((1,2,2)|(2,1,1)) = ((2,2,2)|(1,1,1))+((1,2,2)|(1,1,1))*AB(1)
        ! theta(3623) = theta(2923)+theta(2713)*AB(1) ! ((1,2,2)|(2,0,2)) = ((2,2,2)|(1,0,2))+((1,2,2)|(1,0,2))*AB(1)
        theta(3624) = theta(2924)+theta(2714)*AB(1) ! ((1,2,2)|(1,3,0)) = ((2,2,2)|(0,3,0))+((1,2,2)|(0,3,0))*AB(1)
        theta(3625) = theta(2925)+theta(2715)*AB(1) ! ((1,2,2)|(1,2,1)) = ((2,2,2)|(0,2,1))+((1,2,2)|(0,2,1))*AB(1)
        theta(3626) = theta(2926)+theta(2716)*AB(1) ! ((1,2,2)|(1,1,2)) = ((2,2,2)|(0,1,2))+((1,2,2)|(0,1,2))*AB(1)
        theta(3627) = theta(2927)+theta(2717)*AB(1) ! ((1,2,2)|(1,0,3)) = ((2,2,2)|(0,0,3))+((1,2,2)|(0,0,3))*AB(1)
        theta(3628) = theta(2974)+theta(2714)*AB(2) ! ((1,2,2)|(0,4,0)) = ((1,3,2)|(0,3,0))+((1,2,2)|(0,3,0))*AB(2)
        theta(3629) = theta(2984)+theta(2714)*AB(3) ! ((1,2,2)|(0,3,1)) = ((1,2,3)|(0,3,0))+((1,2,2)|(0,3,0))*AB(3)
        theta(3630) = theta(2976)+theta(2716)*AB(2) ! ((1,2,2)|(0,2,2)) = ((1,3,2)|(0,1,2))+((1,2,2)|(0,1,2))*AB(2)
        theta(3631) = theta(2977)+theta(2717)*AB(2) ! ((1,2,2)|(0,1,3)) = ((1,3,2)|(0,0,3))+((1,2,2)|(0,0,3))*AB(2)
        theta(3632) = theta(2987)+theta(2717)*AB(3) ! ((1,2,2)|(0,0,4)) = ((1,2,3)|(0,0,3))+((1,2,2)|(0,0,3))*AB(3)
        theta(3633) = theta(2928)+theta(2718)*AB(1) ! ((1,1,3)|(4,0,0)) = ((2,1,3)|(3,0,0))+((1,1,3)|(3,0,0))*AB(1)
        theta(3634) = theta(2929)+theta(2719)*AB(1) ! ((1,1,3)|(3,1,0)) = ((2,1,3)|(2,1,0))+((1,1,3)|(2,1,0))*AB(1)
        theta(3635) = theta(2988)+theta(2718)*AB(3) ! ((1,1,3)|(3,0,1)) = ((1,1,4)|(3,0,0))+((1,1,3)|(3,0,0))*AB(3)
        theta(3636) = theta(2931)+theta(2721)*AB(1) ! ((1,1,3)|(2,2,0)) = ((2,1,3)|(1,2,0))+((1,1,3)|(1,2,0))*AB(1)
        theta(3637) = theta(2932)+theta(2722)*AB(1) ! ((1,1,3)|(2,1,1)) = ((2,1,3)|(1,1,1))+((1,1,3)|(1,1,1))*AB(1)
        ! theta(3638) = theta(2933)+theta(2723)*AB(1) ! ((1,1,3)|(2,0,2)) = ((2,1,3)|(1,0,2))+((1,1,3)|(1,0,2))*AB(1)
        theta(3639) = theta(2934)+theta(2724)*AB(1) ! ((1,1,3)|(1,3,0)) = ((2,1,3)|(0,3,0))+((1,1,3)|(0,3,0))*AB(1)
        theta(3640) = theta(2935)+theta(2725)*AB(1) ! ((1,1,3)|(1,2,1)) = ((2,1,3)|(0,2,1))+((1,1,3)|(0,2,1))*AB(1)
        theta(3641) = theta(2936)+theta(2726)*AB(1) ! ((1,1,3)|(1,1,2)) = ((2,1,3)|(0,1,2))+((1,1,3)|(0,1,2))*AB(1)
        theta(3642) = theta(2937)+theta(2727)*AB(1) ! ((1,1,3)|(1,0,3)) = ((2,1,3)|(0,0,3))+((1,1,3)|(0,0,3))*AB(1)
        theta(3643) = theta(2984)+theta(2724)*AB(2) ! ((1,1,3)|(0,4,0)) = ((1,2,3)|(0,3,0))+((1,1,3)|(0,3,0))*AB(2)
        theta(3644) = theta(2994)+theta(2724)*AB(3) ! ((1,1,3)|(0,3,1)) = ((1,1,4)|(0,3,0))+((1,1,3)|(0,3,0))*AB(3)
        theta(3645) = theta(2986)+theta(2726)*AB(2) ! ((1,1,3)|(0,2,2)) = ((1,2,3)|(0,1,2))+((1,1,3)|(0,1,2))*AB(2)
        theta(3646) = theta(2987)+theta(2727)*AB(2) ! ((1,1,3)|(0,1,3)) = ((1,2,3)|(0,0,3))+((1,1,3)|(0,0,3))*AB(2)
        theta(3647) = theta(2997)+theta(2727)*AB(3) ! ((1,1,3)|(0,0,4)) = ((1,1,4)|(0,0,3))+((1,1,3)|(0,0,3))*AB(3)
        theta(3648) = theta(2938)+theta(2728)*AB(1) ! ((1,0,4)|(4,0,0)) = ((2,0,4)|(3,0,0))+((1,0,4)|(3,0,0))*AB(1)
        theta(3649) = theta(2939)+theta(2729)*AB(1) ! ((1,0,4)|(3,1,0)) = ((2,0,4)|(2,1,0))+((1,0,4)|(2,1,0))*AB(1)
        theta(3650) = theta(2998)+theta(2728)*AB(3) ! ((1,0,4)|(3,0,1)) = ((1,0,5)|(3,0,0))+((1,0,4)|(3,0,0))*AB(3)
        theta(3651) = theta(2941)+theta(2731)*AB(1) ! ((1,0,4)|(2,2,0)) = ((2,0,4)|(1,2,0))+((1,0,4)|(1,2,0))*AB(1)
        theta(3652) = theta(2942)+theta(2732)*AB(1) ! ((1,0,4)|(2,1,1)) = ((2,0,4)|(1,1,1))+((1,0,4)|(1,1,1))*AB(1)
        ! theta(3653) = theta(2943)+theta(2733)*AB(1) ! ((1,0,4)|(2,0,2)) = ((2,0,4)|(1,0,2))+((1,0,4)|(1,0,2))*AB(1)
        theta(3654) = theta(2944)+theta(2734)*AB(1) ! ((1,0,4)|(1,3,0)) = ((2,0,4)|(0,3,0))+((1,0,4)|(0,3,0))*AB(1)
        theta(3655) = theta(2945)+theta(2735)*AB(1) ! ((1,0,4)|(1,2,1)) = ((2,0,4)|(0,2,1))+((1,0,4)|(0,2,1))*AB(1)
        theta(3656) = theta(2946)+theta(2736)*AB(1) ! ((1,0,4)|(1,1,2)) = ((2,0,4)|(0,1,2))+((1,0,4)|(0,1,2))*AB(1)
        theta(3657) = theta(2947)+theta(2737)*AB(1) ! ((1,0,4)|(1,0,3)) = ((2,0,4)|(0,0,3))+((1,0,4)|(0,0,3))*AB(1)
        theta(3658) = theta(2994)+theta(2734)*AB(2) ! ((1,0,4)|(0,4,0)) = ((1,1,4)|(0,3,0))+((1,0,4)|(0,3,0))*AB(2)
        theta(3659) = theta(3004)+theta(2734)*AB(3) ! ((1,0,4)|(0,3,1)) = ((1,0,5)|(0,3,0))+((1,0,4)|(0,3,0))*AB(3)
        theta(3660) = theta(2996)+theta(2736)*AB(2) ! ((1,0,4)|(0,2,2)) = ((1,1,4)|(0,1,2))+((1,0,4)|(0,1,2))*AB(2)
        theta(3661) = theta(2997)+theta(2737)*AB(2) ! ((1,0,4)|(0,1,3)) = ((1,1,4)|(0,0,3))+((1,0,4)|(0,0,3))*AB(2)
        theta(3662) = theta(3007)+theta(2737)*AB(3) ! ((1,0,4)|(0,0,4)) = ((1,0,5)|(0,0,3))+((1,0,4)|(0,0,3))*AB(3)
        theta(3663) = theta(2948)+theta(2738)*AB(1) ! ((0,5,0)|(4,0,0)) = ((1,5,0)|(3,0,0))+((0,5,0)|(3,0,0))*AB(1)
        theta(3664) = theta(3008)+theta(2738)*AB(2) ! ((0,5,0)|(3,1,0)) = ((0,6,0)|(3,0,0))+((0,5,0)|(3,0,0))*AB(2)
        theta(3665) = theta(3018)+theta(2738)*AB(3) ! ((0,5,0)|(3,0,1)) = ((0,5,1)|(3,0,0))+((0,5,0)|(3,0,0))*AB(3)
        ! theta(3666) = theta(2951)+theta(2741)*AB(1) ! ((0,5,0)|(2,2,0)) = ((1,5,0)|(1,2,0))+((0,5,0)|(1,2,0))*AB(1)
        ! theta(3667) = theta(3010)+theta(2740)*AB(2) ! ((0,5,0)|(2,1,1)) = ((0,6,0)|(2,0,1))+((0,5,0)|(2,0,1))*AB(2)
        theta(3668) = theta(2953)+theta(2743)*AB(1) ! ((0,5,0)|(2,0,2)) = ((1,5,0)|(1,0,2))+((0,5,0)|(1,0,2))*AB(1)
        theta(3669) = theta(2954)+theta(2744)*AB(1) ! ((0,5,0)|(1,3,0)) = ((1,5,0)|(0,3,0))+((0,5,0)|(0,3,0))*AB(1)
        theta(3670) = theta(2955)+theta(2745)*AB(1) ! ((0,5,0)|(1,2,1)) = ((1,5,0)|(0,2,1))+((0,5,0)|(0,2,1))*AB(1)
        ! theta(3671) = theta(2956)+theta(2746)*AB(1) ! ((0,5,0)|(1,1,2)) = ((1,5,0)|(0,1,2))+((0,5,0)|(0,1,2))*AB(1)
        theta(3672) = theta(2957)+theta(2747)*AB(1) ! ((0,5,0)|(1,0,3)) = ((1,5,0)|(0,0,3))+((0,5,0)|(0,0,3))*AB(1)
        theta(3673) = theta(3014)+theta(2744)*AB(2) ! ((0,5,0)|(0,4,0)) = ((0,6,0)|(0,3,0))+((0,5,0)|(0,3,0))*AB(2)
        theta(3674) = theta(3024)+theta(2744)*AB(3) ! ((0,5,0)|(0,3,1)) = ((0,5,1)|(0,3,0))+((0,5,0)|(0,3,0))*AB(3)
        theta(3675) = theta(3016)+theta(2746)*AB(2) ! ((0,5,0)|(0,2,2)) = ((0,6,0)|(0,1,2))+((0,5,0)|(0,1,2))*AB(2)
        theta(3676) = theta(3017)+theta(2747)*AB(2) ! ((0,5,0)|(0,1,3)) = ((0,6,0)|(0,0,3))+((0,5,0)|(0,0,3))*AB(2)
        theta(3677) = theta(3027)+theta(2747)*AB(3) ! ((0,5,0)|(0,0,4)) = ((0,5,1)|(0,0,3))+((0,5,0)|(0,0,3))*AB(3)
        theta(3678) = theta(2958)+theta(2748)*AB(1) ! ((0,4,1)|(4,0,0)) = ((1,4,1)|(3,0,0))+((0,4,1)|(3,0,0))*AB(1)
        theta(3679) = theta(2959)+theta(2749)*AB(1) ! ((0,4,1)|(3,1,0)) = ((1,4,1)|(2,1,0))+((0,4,1)|(2,1,0))*AB(1)
        theta(3680) = theta(3028)+theta(2748)*AB(3) ! ((0,4,1)|(3,0,1)) = ((0,4,2)|(3,0,0))+((0,4,1)|(3,0,0))*AB(3)
        theta(3681) = theta(2961)+theta(2751)*AB(1) ! ((0,4,1)|(2,2,0)) = ((1,4,1)|(1,2,0))+((0,4,1)|(1,2,0))*AB(1)
        theta(3682) = theta(2962)+theta(2752)*AB(1) ! ((0,4,1)|(2,1,1)) = ((1,4,1)|(1,1,1))+((0,4,1)|(1,1,1))*AB(1)
        ! theta(3683) = theta(2963)+theta(2753)*AB(1) ! ((0,4,1)|(2,0,2)) = ((1,4,1)|(1,0,2))+((0,4,1)|(1,0,2))*AB(1)
        theta(3684) = theta(2964)+theta(2754)*AB(1) ! ((0,4,1)|(1,3,0)) = ((1,4,1)|(0,3,0))+((0,4,1)|(0,3,0))*AB(1)
        theta(3685) = theta(2965)+theta(2755)*AB(1) ! ((0,4,1)|(1,2,1)) = ((1,4,1)|(0,2,1))+((0,4,1)|(0,2,1))*AB(1)
        theta(3686) = theta(2966)+theta(2756)*AB(1) ! ((0,4,1)|(1,1,2)) = ((1,4,1)|(0,1,2))+((0,4,1)|(0,1,2))*AB(1)
        theta(3687) = theta(2967)+theta(2757)*AB(1) ! ((0,4,1)|(1,0,3)) = ((1,4,1)|(0,0,3))+((0,4,1)|(0,0,3))*AB(1)
        theta(3688) = theta(3024)+theta(2754)*AB(2) ! ((0,4,1)|(0,4,0)) = ((0,5,1)|(0,3,0))+((0,4,1)|(0,3,0))*AB(2)
        theta(3689) = theta(3034)+theta(2754)*AB(3) ! ((0,4,1)|(0,3,1)) = ((0,4,2)|(0,3,0))+((0,4,1)|(0,3,0))*AB(3)
        theta(3690) = theta(3026)+theta(2756)*AB(2) ! ((0,4,1)|(0,2,2)) = ((0,5,1)|(0,1,2))+((0,4,1)|(0,1,2))*AB(2)
        theta(3691) = theta(3027)+theta(2757)*AB(2) ! ((0,4,1)|(0,1,3)) = ((0,5,1)|(0,0,3))+((0,4,1)|(0,0,3))*AB(2)
        theta(3692) = theta(3037)+theta(2757)*AB(3) ! ((0,4,1)|(0,0,4)) = ((0,4,2)|(0,0,3))+((0,4,1)|(0,0,3))*AB(3)
        theta(3693) = theta(2968)+theta(2758)*AB(1) ! ((0,3,2)|(4,0,0)) = ((1,3,2)|(3,0,0))+((0,3,2)|(3,0,0))*AB(1)
        theta(3694) = theta(2969)+theta(2759)*AB(1) ! ((0,3,2)|(3,1,0)) = ((1,3,2)|(2,1,0))+((0,3,2)|(2,1,0))*AB(1)
        theta(3695) = theta(3038)+theta(2758)*AB(3) ! ((0,3,2)|(3,0,1)) = ((0,3,3)|(3,0,0))+((0,3,2)|(3,0,0))*AB(3)
        theta(3696) = theta(2971)+theta(2761)*AB(1) ! ((0,3,2)|(2,2,0)) = ((1,3,2)|(1,2,0))+((0,3,2)|(1,2,0))*AB(1)
        theta(3697) = theta(2972)+theta(2762)*AB(1) ! ((0,3,2)|(2,1,1)) = ((1,3,2)|(1,1,1))+((0,3,2)|(1,1,1))*AB(1)
        ! theta(3698) = theta(2973)+theta(2763)*AB(1) ! ((0,3,2)|(2,0,2)) = ((1,3,2)|(1,0,2))+((0,3,2)|(1,0,2))*AB(1)
        theta(3699) = theta(2974)+theta(2764)*AB(1) ! ((0,3,2)|(1,3,0)) = ((1,3,2)|(0,3,0))+((0,3,2)|(0,3,0))*AB(1)
        theta(3700) = theta(2975)+theta(2765)*AB(1) ! ((0,3,2)|(1,2,1)) = ((1,3,2)|(0,2,1))+((0,3,2)|(0,2,1))*AB(1)
        theta(3701) = theta(2976)+theta(2766)*AB(1) ! ((0,3,2)|(1,1,2)) = ((1,3,2)|(0,1,2))+((0,3,2)|(0,1,2))*AB(1)
        theta(3702) = theta(2977)+theta(2767)*AB(1) ! ((0,3,2)|(1,0,3)) = ((1,3,2)|(0,0,3))+((0,3,2)|(0,0,3))*AB(1)
        theta(3703) = theta(3034)+theta(2764)*AB(2) ! ((0,3,2)|(0,4,0)) = ((0,4,2)|(0,3,0))+((0,3,2)|(0,3,0))*AB(2)
        theta(3704) = theta(3044)+theta(2764)*AB(3) ! ((0,3,2)|(0,3,1)) = ((0,3,3)|(0,3,0))+((0,3,2)|(0,3,0))*AB(3)
        theta(3705) = theta(3036)+theta(2766)*AB(2) ! ((0,3,2)|(0,2,2)) = ((0,4,2)|(0,1,2))+((0,3,2)|(0,1,2))*AB(2)
        theta(3706) = theta(3037)+theta(2767)*AB(2) ! ((0,3,2)|(0,1,3)) = ((0,4,2)|(0,0,3))+((0,3,2)|(0,0,3))*AB(2)
        theta(3707) = theta(3047)+theta(2767)*AB(3) ! ((0,3,2)|(0,0,4)) = ((0,3,3)|(0,0,3))+((0,3,2)|(0,0,3))*AB(3)
        theta(3708) = theta(2978)+theta(2768)*AB(1) ! ((0,2,3)|(4,0,0)) = ((1,2,3)|(3,0,0))+((0,2,3)|(3,0,0))*AB(1)
        theta(3709) = theta(2979)+theta(2769)*AB(1) ! ((0,2,3)|(3,1,0)) = ((1,2,3)|(2,1,0))+((0,2,3)|(2,1,0))*AB(1)
        theta(3710) = theta(3048)+theta(2768)*AB(3) ! ((0,2,3)|(3,0,1)) = ((0,2,4)|(3,0,0))+((0,2,3)|(3,0,0))*AB(3)
        theta(3711) = theta(2981)+theta(2771)*AB(1) ! ((0,2,3)|(2,2,0)) = ((1,2,3)|(1,2,0))+((0,2,3)|(1,2,0))*AB(1)
        theta(3712) = theta(2982)+theta(2772)*AB(1) ! ((0,2,3)|(2,1,1)) = ((1,2,3)|(1,1,1))+((0,2,3)|(1,1,1))*AB(1)
        ! theta(3713) = theta(2983)+theta(2773)*AB(1) ! ((0,2,3)|(2,0,2)) = ((1,2,3)|(1,0,2))+((0,2,3)|(1,0,2))*AB(1)
        theta(3714) = theta(2984)+theta(2774)*AB(1) ! ((0,2,3)|(1,3,0)) = ((1,2,3)|(0,3,0))+((0,2,3)|(0,3,0))*AB(1)
        theta(3715) = theta(2985)+theta(2775)*AB(1) ! ((0,2,3)|(1,2,1)) = ((1,2,3)|(0,2,1))+((0,2,3)|(0,2,1))*AB(1)
        theta(3716) = theta(2986)+theta(2776)*AB(1) ! ((0,2,3)|(1,1,2)) = ((1,2,3)|(0,1,2))+((0,2,3)|(0,1,2))*AB(1)
        theta(3717) = theta(2987)+theta(2777)*AB(1) ! ((0,2,3)|(1,0,3)) = ((1,2,3)|(0,0,3))+((0,2,3)|(0,0,3))*AB(1)
        theta(3718) = theta(3044)+theta(2774)*AB(2) ! ((0,2,3)|(0,4,0)) = ((0,3,3)|(0,3,0))+((0,2,3)|(0,3,0))*AB(2)
        theta(3719) = theta(3054)+theta(2774)*AB(3) ! ((0,2,3)|(0,3,1)) = ((0,2,4)|(0,3,0))+((0,2,3)|(0,3,0))*AB(3)
        theta(3720) = theta(3046)+theta(2776)*AB(2) ! ((0,2,3)|(0,2,2)) = ((0,3,3)|(0,1,2))+((0,2,3)|(0,1,2))*AB(2)
        theta(3721) = theta(3047)+theta(2777)*AB(2) ! ((0,2,3)|(0,1,3)) = ((0,3,3)|(0,0,3))+((0,2,3)|(0,0,3))*AB(2)
        theta(3722) = theta(3057)+theta(2777)*AB(3) ! ((0,2,3)|(0,0,4)) = ((0,2,4)|(0,0,3))+((0,2,3)|(0,0,3))*AB(3)
        theta(3723) = theta(2988)+theta(2778)*AB(1) ! ((0,1,4)|(4,0,0)) = ((1,1,4)|(3,0,0))+((0,1,4)|(3,0,0))*AB(1)
        theta(3724) = theta(2989)+theta(2779)*AB(1) ! ((0,1,4)|(3,1,0)) = ((1,1,4)|(2,1,0))+((0,1,4)|(2,1,0))*AB(1)
        theta(3725) = theta(3058)+theta(2778)*AB(3) ! ((0,1,4)|(3,0,1)) = ((0,1,5)|(3,0,0))+((0,1,4)|(3,0,0))*AB(3)
        theta(3726) = theta(2991)+theta(2781)*AB(1) ! ((0,1,4)|(2,2,0)) = ((1,1,4)|(1,2,0))+((0,1,4)|(1,2,0))*AB(1)
        theta(3727) = theta(2992)+theta(2782)*AB(1) ! ((0,1,4)|(2,1,1)) = ((1,1,4)|(1,1,1))+((0,1,4)|(1,1,1))*AB(1)
        ! theta(3728) = theta(2993)+theta(2783)*AB(1) ! ((0,1,4)|(2,0,2)) = ((1,1,4)|(1,0,2))+((0,1,4)|(1,0,2))*AB(1)
        theta(3729) = theta(2994)+theta(2784)*AB(1) ! ((0,1,4)|(1,3,0)) = ((1,1,4)|(0,3,0))+((0,1,4)|(0,3,0))*AB(1)
        theta(3730) = theta(2995)+theta(2785)*AB(1) ! ((0,1,4)|(1,2,1)) = ((1,1,4)|(0,2,1))+((0,1,4)|(0,2,1))*AB(1)
        theta(3731) = theta(2996)+theta(2786)*AB(1) ! ((0,1,4)|(1,1,2)) = ((1,1,4)|(0,1,2))+((0,1,4)|(0,1,2))*AB(1)
        theta(3732) = theta(2997)+theta(2787)*AB(1) ! ((0,1,4)|(1,0,3)) = ((1,1,4)|(0,0,3))+((0,1,4)|(0,0,3))*AB(1)
        theta(3733) = theta(3054)+theta(2784)*AB(2) ! ((0,1,4)|(0,4,0)) = ((0,2,4)|(0,3,0))+((0,1,4)|(0,3,0))*AB(2)
        theta(3734) = theta(3064)+theta(2784)*AB(3) ! ((0,1,4)|(0,3,1)) = ((0,1,5)|(0,3,0))+((0,1,4)|(0,3,0))*AB(3)
        theta(3735) = theta(3056)+theta(2786)*AB(2) ! ((0,1,4)|(0,2,2)) = ((0,2,4)|(0,1,2))+((0,1,4)|(0,1,2))*AB(2)
        theta(3736) = theta(3057)+theta(2787)*AB(2) ! ((0,1,4)|(0,1,3)) = ((0,2,4)|(0,0,3))+((0,1,4)|(0,0,3))*AB(2)
        theta(3737) = theta(3067)+theta(2787)*AB(3) ! ((0,1,4)|(0,0,4)) = ((0,1,5)|(0,0,3))+((0,1,4)|(0,0,3))*AB(3)
        theta(3738) = theta(2998)+theta(2788)*AB(1) ! ((0,0,5)|(4,0,0)) = ((1,0,5)|(3,0,0))+((0,0,5)|(3,0,0))*AB(1)
        theta(3739) = theta(2999)+theta(2789)*AB(1) ! ((0,0,5)|(3,1,0)) = ((1,0,5)|(2,1,0))+((0,0,5)|(2,1,0))*AB(1)
        theta(3740) = theta(3068)+theta(2788)*AB(3) ! ((0,0,5)|(3,0,1)) = ((0,0,6)|(3,0,0))+((0,0,5)|(3,0,0))*AB(3)
        theta(3741) = theta(3001)+theta(2791)*AB(1) ! ((0,0,5)|(2,2,0)) = ((1,0,5)|(1,2,0))+((0,0,5)|(1,2,0))*AB(1)
        theta(3742) = theta(3002)+theta(2792)*AB(1) ! ((0,0,5)|(2,1,1)) = ((1,0,5)|(1,1,1))+((0,0,5)|(1,1,1))*AB(1)
        ! theta(3743) = theta(3003)+theta(2793)*AB(1) ! ((0,0,5)|(2,0,2)) = ((1,0,5)|(1,0,2))+((0,0,5)|(1,0,2))*AB(1)
        theta(3744) = theta(3004)+theta(2794)*AB(1) ! ((0,0,5)|(1,3,0)) = ((1,0,5)|(0,3,0))+((0,0,5)|(0,3,0))*AB(1)
        theta(3745) = theta(3005)+theta(2795)*AB(1) ! ((0,0,5)|(1,2,1)) = ((1,0,5)|(0,2,1))+((0,0,5)|(0,2,1))*AB(1)
        theta(3746) = theta(3006)+theta(2796)*AB(1) ! ((0,0,5)|(1,1,2)) = ((1,0,5)|(0,1,2))+((0,0,5)|(0,1,2))*AB(1)
        theta(3747) = theta(3007)+theta(2797)*AB(1) ! ((0,0,5)|(1,0,3)) = ((1,0,5)|(0,0,3))+((0,0,5)|(0,0,3))*AB(1)
        theta(3748) = theta(3064)+theta(2794)*AB(2) ! ((0,0,5)|(0,4,0)) = ((0,1,5)|(0,3,0))+((0,0,5)|(0,3,0))*AB(2)
        theta(3749) = theta(3074)+theta(2794)*AB(3) ! ((0,0,5)|(0,3,1)) = ((0,0,6)|(0,3,0))+((0,0,5)|(0,3,0))*AB(3)
        theta(3750) = theta(3066)+theta(2796)*AB(2) ! ((0,0,5)|(0,2,2)) = ((0,1,5)|(0,1,2))+((0,0,5)|(0,1,2))*AB(2)
        theta(3751) = theta(3067)+theta(2797)*AB(2) ! ((0,0,5)|(0,1,3)) = ((0,1,5)|(0,0,3))+((0,0,5)|(0,0,3))*AB(2)
        theta(3752) = theta(3077)+theta(2797)*AB(3) ! ((0,0,5)|(0,0,4)) = ((0,0,6)|(0,0,3))+((0,0,5)|(0,0,3))*AB(3)
        theta(3753) = theta(3078)+theta(2798)*AB(1) ! ((6,0,0)|(4,0,0)) = ((7,0,0)|(3,0,0))+((6,0,0)|(3,0,0))*AB(1)
        ! theta(3754) = theta(3088)+theta(2798)*AB(2) ! ((6,0,0)|(3,1,0)) = ((6,1,0)|(3,0,0))+((6,0,0)|(3,0,0))*AB(2)
        ! theta(3755) = theta(3098)+theta(2798)*AB(3) ! ((6,0,0)|(3,0,1)) = ((6,0,1)|(3,0,0))+((6,0,0)|(3,0,0))*AB(3)
        ! theta(3756) = theta(3081)+theta(2801)*AB(1) ! ((6,0,0)|(2,2,0)) = ((7,0,0)|(1,2,0))+((6,0,0)|(1,2,0))*AB(1)
        ! theta(3757) = theta(3090)+theta(2800)*AB(2) ! ((6,0,0)|(2,1,1)) = ((6,1,0)|(2,0,1))+((6,0,0)|(2,0,1))*AB(2)
        ! theta(3758) = theta(3083)+theta(2803)*AB(1) ! ((6,0,0)|(2,0,2)) = ((7,0,0)|(1,0,2))+((6,0,0)|(1,0,2))*AB(1)
        theta(3759) = theta(3084)+theta(2804)*AB(1) ! ((6,0,0)|(1,3,0)) = ((7,0,0)|(0,3,0))+((6,0,0)|(0,3,0))*AB(1)
        theta(3760) = theta(3085)+theta(2805)*AB(1) ! ((6,0,0)|(1,2,1)) = ((7,0,0)|(0,2,1))+((6,0,0)|(0,2,1))*AB(1)
        ! theta(3761) = theta(3086)+theta(2806)*AB(1) ! ((6,0,0)|(1,1,2)) = ((7,0,0)|(0,1,2))+((6,0,0)|(0,1,2))*AB(1)
        theta(3762) = theta(3087)+theta(2807)*AB(1) ! ((6,0,0)|(1,0,3)) = ((7,0,0)|(0,0,3))+((6,0,0)|(0,0,3))*AB(1)
        theta(3763) = theta(3094)+theta(2804)*AB(2) ! ((6,0,0)|(0,4,0)) = ((6,1,0)|(0,3,0))+((6,0,0)|(0,3,0))*AB(2)
        theta(3764) = theta(3104)+theta(2804)*AB(3) ! ((6,0,0)|(0,3,1)) = ((6,0,1)|(0,3,0))+((6,0,0)|(0,3,0))*AB(3)
        theta(3765) = theta(3096)+theta(2806)*AB(2) ! ((6,0,0)|(0,2,2)) = ((6,1,0)|(0,1,2))+((6,0,0)|(0,1,2))*AB(2)
        theta(3766) = theta(3097)+theta(2807)*AB(2) ! ((6,0,0)|(0,1,3)) = ((6,1,0)|(0,0,3))+((6,0,0)|(0,0,3))*AB(2)
        theta(3767) = theta(3107)+theta(2807)*AB(3) ! ((6,0,0)|(0,0,4)) = ((6,0,1)|(0,0,3))+((6,0,0)|(0,0,3))*AB(3)
        theta(3768) = theta(3088)+theta(2808)*AB(1) ! ((5,1,0)|(4,0,0)) = ((6,1,0)|(3,0,0))+((5,1,0)|(3,0,0))*AB(1)
        theta(3769) = theta(3108)+theta(2808)*AB(2) ! ((5,1,0)|(3,1,0)) = ((5,2,0)|(3,0,0))+((5,1,0)|(3,0,0))*AB(2)
        theta(3770) = theta(3118)+theta(2808)*AB(3) ! ((5,1,0)|(3,0,1)) = ((5,1,1)|(3,0,0))+((5,1,0)|(3,0,0))*AB(3)
        ! theta(3771) = theta(3091)+theta(2811)*AB(1) ! ((5,1,0)|(2,2,0)) = ((6,1,0)|(1,2,0))+((5,1,0)|(1,2,0))*AB(1)
        ! theta(3772) = theta(3110)+theta(2810)*AB(2) ! ((5,1,0)|(2,1,1)) = ((5,2,0)|(2,0,1))+((5,1,0)|(2,0,1))*AB(2)
        theta(3773) = theta(3093)+theta(2813)*AB(1) ! ((5,1,0)|(2,0,2)) = ((6,1,0)|(1,0,2))+((5,1,0)|(1,0,2))*AB(1)
        theta(3774) = theta(3094)+theta(2814)*AB(1) ! ((5,1,0)|(1,3,0)) = ((6,1,0)|(0,3,0))+((5,1,0)|(0,3,0))*AB(1)
        theta(3775) = theta(3095)+theta(2815)*AB(1) ! ((5,1,0)|(1,2,1)) = ((6,1,0)|(0,2,1))+((5,1,0)|(0,2,1))*AB(1)
        ! theta(3776) = theta(3096)+theta(2816)*AB(1) ! ((5,1,0)|(1,1,2)) = ((6,1,0)|(0,1,2))+((5,1,0)|(0,1,2))*AB(1)
        theta(3777) = theta(3097)+theta(2817)*AB(1) ! ((5,1,0)|(1,0,3)) = ((6,1,0)|(0,0,3))+((5,1,0)|(0,0,3))*AB(1)
        theta(3778) = theta(3114)+theta(2814)*AB(2) ! ((5,1,0)|(0,4,0)) = ((5,2,0)|(0,3,0))+((5,1,0)|(0,3,0))*AB(2)
        theta(3779) = theta(3124)+theta(2814)*AB(3) ! ((5,1,0)|(0,3,1)) = ((5,1,1)|(0,3,0))+((5,1,0)|(0,3,0))*AB(3)
        theta(3780) = theta(3116)+theta(2816)*AB(2) ! ((5,1,0)|(0,2,2)) = ((5,2,0)|(0,1,2))+((5,1,0)|(0,1,2))*AB(2)
        theta(3781) = theta(3117)+theta(2817)*AB(2) ! ((5,1,0)|(0,1,3)) = ((5,2,0)|(0,0,3))+((5,1,0)|(0,0,3))*AB(2)
        theta(3782) = theta(3127)+theta(2817)*AB(3) ! ((5,1,0)|(0,0,4)) = ((5,1,1)|(0,0,3))+((5,1,0)|(0,0,3))*AB(3)
        theta(3783) = theta(3098)+theta(2818)*AB(1) ! ((5,0,1)|(4,0,0)) = ((6,0,1)|(3,0,0))+((5,0,1)|(3,0,0))*AB(1)
        theta(3784) = theta(3099)+theta(2819)*AB(1) ! ((5,0,1)|(3,1,0)) = ((6,0,1)|(2,1,0))+((5,0,1)|(2,1,0))*AB(1)
        theta(3785) = theta(3128)+theta(2818)*AB(3) ! ((5,0,1)|(3,0,1)) = ((5,0,2)|(3,0,0))+((5,0,1)|(3,0,0))*AB(3)
        theta(3786) = theta(3101)+theta(2821)*AB(1) ! ((5,0,1)|(2,2,0)) = ((6,0,1)|(1,2,0))+((5,0,1)|(1,2,0))*AB(1)
        theta(3787) = theta(3102)+theta(2822)*AB(1) ! ((5,0,1)|(2,1,1)) = ((6,0,1)|(1,1,1))+((5,0,1)|(1,1,1))*AB(1)
        ! theta(3788) = theta(3103)+theta(2823)*AB(1) ! ((5,0,1)|(2,0,2)) = ((6,0,1)|(1,0,2))+((5,0,1)|(1,0,2))*AB(1)
        theta(3789) = theta(3104)+theta(2824)*AB(1) ! ((5,0,1)|(1,3,0)) = ((6,0,1)|(0,3,0))+((5,0,1)|(0,3,0))*AB(1)
        theta(3790) = theta(3105)+theta(2825)*AB(1) ! ((5,0,1)|(1,2,1)) = ((6,0,1)|(0,2,1))+((5,0,1)|(0,2,1))*AB(1)
        theta(3791) = theta(3106)+theta(2826)*AB(1) ! ((5,0,1)|(1,1,2)) = ((6,0,1)|(0,1,2))+((5,0,1)|(0,1,2))*AB(1)
        theta(3792) = theta(3107)+theta(2827)*AB(1) ! ((5,0,1)|(1,0,3)) = ((6,0,1)|(0,0,3))+((5,0,1)|(0,0,3))*AB(1)
        theta(3793) = theta(3124)+theta(2824)*AB(2) ! ((5,0,1)|(0,4,0)) = ((5,1,1)|(0,3,0))+((5,0,1)|(0,3,0))*AB(2)
        theta(3794) = theta(3134)+theta(2824)*AB(3) ! ((5,0,1)|(0,3,1)) = ((5,0,2)|(0,3,0))+((5,0,1)|(0,3,0))*AB(3)
        theta(3795) = theta(3126)+theta(2826)*AB(2) ! ((5,0,1)|(0,2,2)) = ((5,1,1)|(0,1,2))+((5,0,1)|(0,1,2))*AB(2)
        theta(3796) = theta(3127)+theta(2827)*AB(2) ! ((5,0,1)|(0,1,3)) = ((5,1,1)|(0,0,3))+((5,0,1)|(0,0,3))*AB(2)
        theta(3797) = theta(3137)+theta(2827)*AB(3) ! ((5,0,1)|(0,0,4)) = ((5,0,2)|(0,0,3))+((5,0,1)|(0,0,3))*AB(3)
        theta(3798) = theta(3108)+theta(2828)*AB(1) ! ((4,2,0)|(4,0,0)) = ((5,2,0)|(3,0,0))+((4,2,0)|(3,0,0))*AB(1)
        theta(3799) = theta(3138)+theta(2828)*AB(2) ! ((4,2,0)|(3,1,0)) = ((4,3,0)|(3,0,0))+((4,2,0)|(3,0,0))*AB(2)
        theta(3800) = theta(3148)+theta(2828)*AB(3) ! ((4,2,0)|(3,0,1)) = ((4,2,1)|(3,0,0))+((4,2,0)|(3,0,0))*AB(3)
        ! theta(3801) = theta(3111)+theta(2831)*AB(1) ! ((4,2,0)|(2,2,0)) = ((5,2,0)|(1,2,0))+((4,2,0)|(1,2,0))*AB(1)
        ! theta(3802) = theta(3140)+theta(2830)*AB(2) ! ((4,2,0)|(2,1,1)) = ((4,3,0)|(2,0,1))+((4,2,0)|(2,0,1))*AB(2)
        theta(3803) = theta(3113)+theta(2833)*AB(1) ! ((4,2,0)|(2,0,2)) = ((5,2,0)|(1,0,2))+((4,2,0)|(1,0,2))*AB(1)
        theta(3804) = theta(3114)+theta(2834)*AB(1) ! ((4,2,0)|(1,3,0)) = ((5,2,0)|(0,3,0))+((4,2,0)|(0,3,0))*AB(1)
        theta(3805) = theta(3115)+theta(2835)*AB(1) ! ((4,2,0)|(1,2,1)) = ((5,2,0)|(0,2,1))+((4,2,0)|(0,2,1))*AB(1)
        ! theta(3806) = theta(3116)+theta(2836)*AB(1) ! ((4,2,0)|(1,1,2)) = ((5,2,0)|(0,1,2))+((4,2,0)|(0,1,2))*AB(1)
        theta(3807) = theta(3117)+theta(2837)*AB(1) ! ((4,2,0)|(1,0,3)) = ((5,2,0)|(0,0,3))+((4,2,0)|(0,0,3))*AB(1)
        theta(3808) = theta(3144)+theta(2834)*AB(2) ! ((4,2,0)|(0,4,0)) = ((4,3,0)|(0,3,0))+((4,2,0)|(0,3,0))*AB(2)
        theta(3809) = theta(3154)+theta(2834)*AB(3) ! ((4,2,0)|(0,3,1)) = ((4,2,1)|(0,3,0))+((4,2,0)|(0,3,0))*AB(3)
        theta(3810) = theta(3146)+theta(2836)*AB(2) ! ((4,2,0)|(0,2,2)) = ((4,3,0)|(0,1,2))+((4,2,0)|(0,1,2))*AB(2)
        theta(3811) = theta(3147)+theta(2837)*AB(2) ! ((4,2,0)|(0,1,3)) = ((4,3,0)|(0,0,3))+((4,2,0)|(0,0,3))*AB(2)
        theta(3812) = theta(3157)+theta(2837)*AB(3) ! ((4,2,0)|(0,0,4)) = ((4,2,1)|(0,0,3))+((4,2,0)|(0,0,3))*AB(3)
        theta(3813) = theta(3118)+theta(2838)*AB(1) ! ((4,1,1)|(4,0,0)) = ((5,1,1)|(3,0,0))+((4,1,1)|(3,0,0))*AB(1)
        theta(3814) = theta(3119)+theta(2839)*AB(1) ! ((4,1,1)|(3,1,0)) = ((5,1,1)|(2,1,0))+((4,1,1)|(2,1,0))*AB(1)
        theta(3815) = theta(3158)+theta(2838)*AB(3) ! ((4,1,1)|(3,0,1)) = ((4,1,2)|(3,0,0))+((4,1,1)|(3,0,0))*AB(3)
        theta(3816) = theta(3121)+theta(2841)*AB(1) ! ((4,1,1)|(2,2,0)) = ((5,1,1)|(1,2,0))+((4,1,1)|(1,2,0))*AB(1)
        theta(3817) = theta(3122)+theta(2842)*AB(1) ! ((4,1,1)|(2,1,1)) = ((5,1,1)|(1,1,1))+((4,1,1)|(1,1,1))*AB(1)
        ! theta(3818) = theta(3123)+theta(2843)*AB(1) ! ((4,1,1)|(2,0,2)) = ((5,1,1)|(1,0,2))+((4,1,1)|(1,0,2))*AB(1)
        theta(3819) = theta(3124)+theta(2844)*AB(1) ! ((4,1,1)|(1,3,0)) = ((5,1,1)|(0,3,0))+((4,1,1)|(0,3,0))*AB(1)
        theta(3820) = theta(3125)+theta(2845)*AB(1) ! ((4,1,1)|(1,2,1)) = ((5,1,1)|(0,2,1))+((4,1,1)|(0,2,1))*AB(1)
        theta(3821) = theta(3126)+theta(2846)*AB(1) ! ((4,1,1)|(1,1,2)) = ((5,1,1)|(0,1,2))+((4,1,1)|(0,1,2))*AB(1)
        theta(3822) = theta(3127)+theta(2847)*AB(1) ! ((4,1,1)|(1,0,3)) = ((5,1,1)|(0,0,3))+((4,1,1)|(0,0,3))*AB(1)
        theta(3823) = theta(3154)+theta(2844)*AB(2) ! ((4,1,1)|(0,4,0)) = ((4,2,1)|(0,3,0))+((4,1,1)|(0,3,0))*AB(2)
        theta(3824) = theta(3164)+theta(2844)*AB(3) ! ((4,1,1)|(0,3,1)) = ((4,1,2)|(0,3,0))+((4,1,1)|(0,3,0))*AB(3)
        theta(3825) = theta(3156)+theta(2846)*AB(2) ! ((4,1,1)|(0,2,2)) = ((4,2,1)|(0,1,2))+((4,1,1)|(0,1,2))*AB(2)
        theta(3826) = theta(3157)+theta(2847)*AB(2) ! ((4,1,1)|(0,1,3)) = ((4,2,1)|(0,0,3))+((4,1,1)|(0,0,3))*AB(2)
        theta(3827) = theta(3167)+theta(2847)*AB(3) ! ((4,1,1)|(0,0,4)) = ((4,1,2)|(0,0,3))+((4,1,1)|(0,0,3))*AB(3)
        theta(3828) = theta(3128)+theta(2848)*AB(1) ! ((4,0,2)|(4,0,0)) = ((5,0,2)|(3,0,0))+((4,0,2)|(3,0,0))*AB(1)
        theta(3829) = theta(3129)+theta(2849)*AB(1) ! ((4,0,2)|(3,1,0)) = ((5,0,2)|(2,1,0))+((4,0,2)|(2,1,0))*AB(1)
        theta(3830) = theta(3168)+theta(2848)*AB(3) ! ((4,0,2)|(3,0,1)) = ((4,0,3)|(3,0,0))+((4,0,2)|(3,0,0))*AB(3)
        theta(3831) = theta(3131)+theta(2851)*AB(1) ! ((4,0,2)|(2,2,0)) = ((5,0,2)|(1,2,0))+((4,0,2)|(1,2,0))*AB(1)
        theta(3832) = theta(3132)+theta(2852)*AB(1) ! ((4,0,2)|(2,1,1)) = ((5,0,2)|(1,1,1))+((4,0,2)|(1,1,1))*AB(1)
        ! theta(3833) = theta(3133)+theta(2853)*AB(1) ! ((4,0,2)|(2,0,2)) = ((5,0,2)|(1,0,2))+((4,0,2)|(1,0,2))*AB(1)
        theta(3834) = theta(3134)+theta(2854)*AB(1) ! ((4,0,2)|(1,3,0)) = ((5,0,2)|(0,3,0))+((4,0,2)|(0,3,0))*AB(1)
        theta(3835) = theta(3135)+theta(2855)*AB(1) ! ((4,0,2)|(1,2,1)) = ((5,0,2)|(0,2,1))+((4,0,2)|(0,2,1))*AB(1)
        theta(3836) = theta(3136)+theta(2856)*AB(1) ! ((4,0,2)|(1,1,2)) = ((5,0,2)|(0,1,2))+((4,0,2)|(0,1,2))*AB(1)
        theta(3837) = theta(3137)+theta(2857)*AB(1) ! ((4,0,2)|(1,0,3)) = ((5,0,2)|(0,0,3))+((4,0,2)|(0,0,3))*AB(1)
        theta(3838) = theta(3164)+theta(2854)*AB(2) ! ((4,0,2)|(0,4,0)) = ((4,1,2)|(0,3,0))+((4,0,2)|(0,3,0))*AB(2)
        theta(3839) = theta(3174)+theta(2854)*AB(3) ! ((4,0,2)|(0,3,1)) = ((4,0,3)|(0,3,0))+((4,0,2)|(0,3,0))*AB(3)
        theta(3840) = theta(3166)+theta(2856)*AB(2) ! ((4,0,2)|(0,2,2)) = ((4,1,2)|(0,1,2))+((4,0,2)|(0,1,2))*AB(2)
        theta(3841) = theta(3167)+theta(2857)*AB(2) ! ((4,0,2)|(0,1,3)) = ((4,1,2)|(0,0,3))+((4,0,2)|(0,0,3))*AB(2)
        theta(3842) = theta(3177)+theta(2857)*AB(3) ! ((4,0,2)|(0,0,4)) = ((4,0,3)|(0,0,3))+((4,0,2)|(0,0,3))*AB(3)
        theta(3843) = theta(3138)+theta(2858)*AB(1) ! ((3,3,0)|(4,0,0)) = ((4,3,0)|(3,0,0))+((3,3,0)|(3,0,0))*AB(1)
        theta(3844) = theta(3178)+theta(2858)*AB(2) ! ((3,3,0)|(3,1,0)) = ((3,4,0)|(3,0,0))+((3,3,0)|(3,0,0))*AB(2)
        theta(3845) = theta(3188)+theta(2858)*AB(3) ! ((3,3,0)|(3,0,1)) = ((3,3,1)|(3,0,0))+((3,3,0)|(3,0,0))*AB(3)
        ! theta(3846) = theta(3141)+theta(2861)*AB(1) ! ((3,3,0)|(2,2,0)) = ((4,3,0)|(1,2,0))+((3,3,0)|(1,2,0))*AB(1)
        ! theta(3847) = theta(3180)+theta(2860)*AB(2) ! ((3,3,0)|(2,1,1)) = ((3,4,0)|(2,0,1))+((3,3,0)|(2,0,1))*AB(2)
        theta(3848) = theta(3143)+theta(2863)*AB(1) ! ((3,3,0)|(2,0,2)) = ((4,3,0)|(1,0,2))+((3,3,0)|(1,0,2))*AB(1)
        theta(3849) = theta(3144)+theta(2864)*AB(1) ! ((3,3,0)|(1,3,0)) = ((4,3,0)|(0,3,0))+((3,3,0)|(0,3,0))*AB(1)
        theta(3850) = theta(3145)+theta(2865)*AB(1) ! ((3,3,0)|(1,2,1)) = ((4,3,0)|(0,2,1))+((3,3,0)|(0,2,1))*AB(1)
        ! theta(3851) = theta(3146)+theta(2866)*AB(1) ! ((3,3,0)|(1,1,2)) = ((4,3,0)|(0,1,2))+((3,3,0)|(0,1,2))*AB(1)
        theta(3852) = theta(3147)+theta(2867)*AB(1) ! ((3,3,0)|(1,0,3)) = ((4,3,0)|(0,0,3))+((3,3,0)|(0,0,3))*AB(1)
        theta(3853) = theta(3184)+theta(2864)*AB(2) ! ((3,3,0)|(0,4,0)) = ((3,4,0)|(0,3,0))+((3,3,0)|(0,3,0))*AB(2)
        theta(3854) = theta(3194)+theta(2864)*AB(3) ! ((3,3,0)|(0,3,1)) = ((3,3,1)|(0,3,0))+((3,3,0)|(0,3,0))*AB(3)
        theta(3855) = theta(3186)+theta(2866)*AB(2) ! ((3,3,0)|(0,2,2)) = ((3,4,0)|(0,1,2))+((3,3,0)|(0,1,2))*AB(2)
        theta(3856) = theta(3187)+theta(2867)*AB(2) ! ((3,3,0)|(0,1,3)) = ((3,4,0)|(0,0,3))+((3,3,0)|(0,0,3))*AB(2)
        theta(3857) = theta(3197)+theta(2867)*AB(3) ! ((3,3,0)|(0,0,4)) = ((3,3,1)|(0,0,3))+((3,3,0)|(0,0,3))*AB(3)
        theta(3858) = theta(3148)+theta(2868)*AB(1) ! ((3,2,1)|(4,0,0)) = ((4,2,1)|(3,0,0))+((3,2,1)|(3,0,0))*AB(1)
        theta(3859) = theta(3149)+theta(2869)*AB(1) ! ((3,2,1)|(3,1,0)) = ((4,2,1)|(2,1,0))+((3,2,1)|(2,1,0))*AB(1)
        theta(3860) = theta(3198)+theta(2868)*AB(3) ! ((3,2,1)|(3,0,1)) = ((3,2,2)|(3,0,0))+((3,2,1)|(3,0,0))*AB(3)
        theta(3861) = theta(3151)+theta(2871)*AB(1) ! ((3,2,1)|(2,2,0)) = ((4,2,1)|(1,2,0))+((3,2,1)|(1,2,0))*AB(1)
        theta(3862) = theta(3152)+theta(2872)*AB(1) ! ((3,2,1)|(2,1,1)) = ((4,2,1)|(1,1,1))+((3,2,1)|(1,1,1))*AB(1)
        ! theta(3863) = theta(3153)+theta(2873)*AB(1) ! ((3,2,1)|(2,0,2)) = ((4,2,1)|(1,0,2))+((3,2,1)|(1,0,2))*AB(1)
        theta(3864) = theta(3154)+theta(2874)*AB(1) ! ((3,2,1)|(1,3,0)) = ((4,2,1)|(0,3,0))+((3,2,1)|(0,3,0))*AB(1)
        theta(3865) = theta(3155)+theta(2875)*AB(1) ! ((3,2,1)|(1,2,1)) = ((4,2,1)|(0,2,1))+((3,2,1)|(0,2,1))*AB(1)
        theta(3866) = theta(3156)+theta(2876)*AB(1) ! ((3,2,1)|(1,1,2)) = ((4,2,1)|(0,1,2))+((3,2,1)|(0,1,2))*AB(1)
        theta(3867) = theta(3157)+theta(2877)*AB(1) ! ((3,2,1)|(1,0,3)) = ((4,2,1)|(0,0,3))+((3,2,1)|(0,0,3))*AB(1)
        theta(3868) = theta(3194)+theta(2874)*AB(2) ! ((3,2,1)|(0,4,0)) = ((3,3,1)|(0,3,0))+((3,2,1)|(0,3,0))*AB(2)
        theta(3869) = theta(3204)+theta(2874)*AB(3) ! ((3,2,1)|(0,3,1)) = ((3,2,2)|(0,3,0))+((3,2,1)|(0,3,0))*AB(3)
        theta(3870) = theta(3196)+theta(2876)*AB(2) ! ((3,2,1)|(0,2,2)) = ((3,3,1)|(0,1,2))+((3,2,1)|(0,1,2))*AB(2)
        theta(3871) = theta(3197)+theta(2877)*AB(2) ! ((3,2,1)|(0,1,3)) = ((3,3,1)|(0,0,3))+((3,2,1)|(0,0,3))*AB(2)
        theta(3872) = theta(3207)+theta(2877)*AB(3) ! ((3,2,1)|(0,0,4)) = ((3,2,2)|(0,0,3))+((3,2,1)|(0,0,3))*AB(3)
        theta(3873) = theta(3158)+theta(2878)*AB(1) ! ((3,1,2)|(4,0,0)) = ((4,1,2)|(3,0,0))+((3,1,2)|(3,0,0))*AB(1)
        theta(3874) = theta(3159)+theta(2879)*AB(1) ! ((3,1,2)|(3,1,0)) = ((4,1,2)|(2,1,0))+((3,1,2)|(2,1,0))*AB(1)
        theta(3875) = theta(3208)+theta(2878)*AB(3) ! ((3,1,2)|(3,0,1)) = ((3,1,3)|(3,0,0))+((3,1,2)|(3,0,0))*AB(3)
        theta(3876) = theta(3161)+theta(2881)*AB(1) ! ((3,1,2)|(2,2,0)) = ((4,1,2)|(1,2,0))+((3,1,2)|(1,2,0))*AB(1)
        theta(3877) = theta(3162)+theta(2882)*AB(1) ! ((3,1,2)|(2,1,1)) = ((4,1,2)|(1,1,1))+((3,1,2)|(1,1,1))*AB(1)
        ! theta(3878) = theta(3163)+theta(2883)*AB(1) ! ((3,1,2)|(2,0,2)) = ((4,1,2)|(1,0,2))+((3,1,2)|(1,0,2))*AB(1)
        theta(3879) = theta(3164)+theta(2884)*AB(1) ! ((3,1,2)|(1,3,0)) = ((4,1,2)|(0,3,0))+((3,1,2)|(0,3,0))*AB(1)
        theta(3880) = theta(3165)+theta(2885)*AB(1) ! ((3,1,2)|(1,2,1)) = ((4,1,2)|(0,2,1))+((3,1,2)|(0,2,1))*AB(1)
        theta(3881) = theta(3166)+theta(2886)*AB(1) ! ((3,1,2)|(1,1,2)) = ((4,1,2)|(0,1,2))+((3,1,2)|(0,1,2))*AB(1)
        theta(3882) = theta(3167)+theta(2887)*AB(1) ! ((3,1,2)|(1,0,3)) = ((4,1,2)|(0,0,3))+((3,1,2)|(0,0,3))*AB(1)
        theta(3883) = theta(3204)+theta(2884)*AB(2) ! ((3,1,2)|(0,4,0)) = ((3,2,2)|(0,3,0))+((3,1,2)|(0,3,0))*AB(2)
        theta(3884) = theta(3214)+theta(2884)*AB(3) ! ((3,1,2)|(0,3,1)) = ((3,1,3)|(0,3,0))+((3,1,2)|(0,3,0))*AB(3)
        theta(3885) = theta(3206)+theta(2886)*AB(2) ! ((3,1,2)|(0,2,2)) = ((3,2,2)|(0,1,2))+((3,1,2)|(0,1,2))*AB(2)
        theta(3886) = theta(3207)+theta(2887)*AB(2) ! ((3,1,2)|(0,1,3)) = ((3,2,2)|(0,0,3))+((3,1,2)|(0,0,3))*AB(2)
        theta(3887) = theta(3217)+theta(2887)*AB(3) ! ((3,1,2)|(0,0,4)) = ((3,1,3)|(0,0,3))+((3,1,2)|(0,0,3))*AB(3)
        theta(3888) = theta(3168)+theta(2888)*AB(1) ! ((3,0,3)|(4,0,0)) = ((4,0,3)|(3,0,0))+((3,0,3)|(3,0,0))*AB(1)
        theta(3889) = theta(3169)+theta(2889)*AB(1) ! ((3,0,3)|(3,1,0)) = ((4,0,3)|(2,1,0))+((3,0,3)|(2,1,0))*AB(1)
        theta(3890) = theta(3218)+theta(2888)*AB(3) ! ((3,0,3)|(3,0,1)) = ((3,0,4)|(3,0,0))+((3,0,3)|(3,0,0))*AB(3)
        theta(3891) = theta(3171)+theta(2891)*AB(1) ! ((3,0,3)|(2,2,0)) = ((4,0,3)|(1,2,0))+((3,0,3)|(1,2,0))*AB(1)
        theta(3892) = theta(3172)+theta(2892)*AB(1) ! ((3,0,3)|(2,1,1)) = ((4,0,3)|(1,1,1))+((3,0,3)|(1,1,1))*AB(1)
        ! theta(3893) = theta(3173)+theta(2893)*AB(1) ! ((3,0,3)|(2,0,2)) = ((4,0,3)|(1,0,2))+((3,0,3)|(1,0,2))*AB(1)
        theta(3894) = theta(3174)+theta(2894)*AB(1) ! ((3,0,3)|(1,3,0)) = ((4,0,3)|(0,3,0))+((3,0,3)|(0,3,0))*AB(1)
        theta(3895) = theta(3175)+theta(2895)*AB(1) ! ((3,0,3)|(1,2,1)) = ((4,0,3)|(0,2,1))+((3,0,3)|(0,2,1))*AB(1)
        theta(3896) = theta(3176)+theta(2896)*AB(1) ! ((3,0,3)|(1,1,2)) = ((4,0,3)|(0,1,2))+((3,0,3)|(0,1,2))*AB(1)
        theta(3897) = theta(3177)+theta(2897)*AB(1) ! ((3,0,3)|(1,0,3)) = ((4,0,3)|(0,0,3))+((3,0,3)|(0,0,3))*AB(1)
        theta(3898) = theta(3214)+theta(2894)*AB(2) ! ((3,0,3)|(0,4,0)) = ((3,1,3)|(0,3,0))+((3,0,3)|(0,3,0))*AB(2)
        theta(3899) = theta(3224)+theta(2894)*AB(3) ! ((3,0,3)|(0,3,1)) = ((3,0,4)|(0,3,0))+((3,0,3)|(0,3,0))*AB(3)
        theta(3900) = theta(3216)+theta(2896)*AB(2) ! ((3,0,3)|(0,2,2)) = ((3,1,3)|(0,1,2))+((3,0,3)|(0,1,2))*AB(2)
        theta(3901) = theta(3217)+theta(2897)*AB(2) ! ((3,0,3)|(0,1,3)) = ((3,1,3)|(0,0,3))+((3,0,3)|(0,0,3))*AB(2)
        theta(3902) = theta(3227)+theta(2897)*AB(3) ! ((3,0,3)|(0,0,4)) = ((3,0,4)|(0,0,3))+((3,0,3)|(0,0,3))*AB(3)
        theta(3903) = theta(3178)+theta(2898)*AB(1) ! ((2,4,0)|(4,0,0)) = ((3,4,0)|(3,0,0))+((2,4,0)|(3,0,0))*AB(1)
        theta(3904) = theta(3228)+theta(2898)*AB(2) ! ((2,4,0)|(3,1,0)) = ((2,5,0)|(3,0,0))+((2,4,0)|(3,0,0))*AB(2)
        theta(3905) = theta(3238)+theta(2898)*AB(3) ! ((2,4,0)|(3,0,1)) = ((2,4,1)|(3,0,0))+((2,4,0)|(3,0,0))*AB(3)
        ! theta(3906) = theta(3181)+theta(2901)*AB(1) ! ((2,4,0)|(2,2,0)) = ((3,4,0)|(1,2,0))+((2,4,0)|(1,2,0))*AB(1)
        ! theta(3907) = theta(3230)+theta(2900)*AB(2) ! ((2,4,0)|(2,1,1)) = ((2,5,0)|(2,0,1))+((2,4,0)|(2,0,1))*AB(2)
        theta(3908) = theta(3183)+theta(2903)*AB(1) ! ((2,4,0)|(2,0,2)) = ((3,4,0)|(1,0,2))+((2,4,0)|(1,0,2))*AB(1)
        theta(3909) = theta(3184)+theta(2904)*AB(1) ! ((2,4,0)|(1,3,0)) = ((3,4,0)|(0,3,0))+((2,4,0)|(0,3,0))*AB(1)
        theta(3910) = theta(3185)+theta(2905)*AB(1) ! ((2,4,0)|(1,2,1)) = ((3,4,0)|(0,2,1))+((2,4,0)|(0,2,1))*AB(1)
        ! theta(3911) = theta(3186)+theta(2906)*AB(1) ! ((2,4,0)|(1,1,2)) = ((3,4,0)|(0,1,2))+((2,4,0)|(0,1,2))*AB(1)
        theta(3912) = theta(3187)+theta(2907)*AB(1) ! ((2,4,0)|(1,0,3)) = ((3,4,0)|(0,0,3))+((2,4,0)|(0,0,3))*AB(1)
        theta(3913) = theta(3234)+theta(2904)*AB(2) ! ((2,4,0)|(0,4,0)) = ((2,5,0)|(0,3,0))+((2,4,0)|(0,3,0))*AB(2)
        theta(3914) = theta(3244)+theta(2904)*AB(3) ! ((2,4,0)|(0,3,1)) = ((2,4,1)|(0,3,0))+((2,4,0)|(0,3,0))*AB(3)
        theta(3915) = theta(3236)+theta(2906)*AB(2) ! ((2,4,0)|(0,2,2)) = ((2,5,0)|(0,1,2))+((2,4,0)|(0,1,2))*AB(2)
        theta(3916) = theta(3237)+theta(2907)*AB(2) ! ((2,4,0)|(0,1,3)) = ((2,5,0)|(0,0,3))+((2,4,0)|(0,0,3))*AB(2)
        theta(3917) = theta(3247)+theta(2907)*AB(3) ! ((2,4,0)|(0,0,4)) = ((2,4,1)|(0,0,3))+((2,4,0)|(0,0,3))*AB(3)
        theta(3918) = theta(3188)+theta(2908)*AB(1) ! ((2,3,1)|(4,0,0)) = ((3,3,1)|(3,0,0))+((2,3,1)|(3,0,0))*AB(1)
        theta(3919) = theta(3189)+theta(2909)*AB(1) ! ((2,3,1)|(3,1,0)) = ((3,3,1)|(2,1,0))+((2,3,1)|(2,1,0))*AB(1)
        theta(3920) = theta(3248)+theta(2908)*AB(3) ! ((2,3,1)|(3,0,1)) = ((2,3,2)|(3,0,0))+((2,3,1)|(3,0,0))*AB(3)
        theta(3921) = theta(3191)+theta(2911)*AB(1) ! ((2,3,1)|(2,2,0)) = ((3,3,1)|(1,2,0))+((2,3,1)|(1,2,0))*AB(1)
        theta(3922) = theta(3192)+theta(2912)*AB(1) ! ((2,3,1)|(2,1,1)) = ((3,3,1)|(1,1,1))+((2,3,1)|(1,1,1))*AB(1)
        ! theta(3923) = theta(3193)+theta(2913)*AB(1) ! ((2,3,1)|(2,0,2)) = ((3,3,1)|(1,0,2))+((2,3,1)|(1,0,2))*AB(1)
        theta(3924) = theta(3194)+theta(2914)*AB(1) ! ((2,3,1)|(1,3,0)) = ((3,3,1)|(0,3,0))+((2,3,1)|(0,3,0))*AB(1)
        theta(3925) = theta(3195)+theta(2915)*AB(1) ! ((2,3,1)|(1,2,1)) = ((3,3,1)|(0,2,1))+((2,3,1)|(0,2,1))*AB(1)
        theta(3926) = theta(3196)+theta(2916)*AB(1) ! ((2,3,1)|(1,1,2)) = ((3,3,1)|(0,1,2))+((2,3,1)|(0,1,2))*AB(1)
        theta(3927) = theta(3197)+theta(2917)*AB(1) ! ((2,3,1)|(1,0,3)) = ((3,3,1)|(0,0,3))+((2,3,1)|(0,0,3))*AB(1)
        theta(3928) = theta(3244)+theta(2914)*AB(2) ! ((2,3,1)|(0,4,0)) = ((2,4,1)|(0,3,0))+((2,3,1)|(0,3,0))*AB(2)
        theta(3929) = theta(3254)+theta(2914)*AB(3) ! ((2,3,1)|(0,3,1)) = ((2,3,2)|(0,3,0))+((2,3,1)|(0,3,0))*AB(3)
        theta(3930) = theta(3246)+theta(2916)*AB(2) ! ((2,3,1)|(0,2,2)) = ((2,4,1)|(0,1,2))+((2,3,1)|(0,1,2))*AB(2)
        theta(3931) = theta(3247)+theta(2917)*AB(2) ! ((2,3,1)|(0,1,3)) = ((2,4,1)|(0,0,3))+((2,3,1)|(0,0,3))*AB(2)
        theta(3932) = theta(3257)+theta(2917)*AB(3) ! ((2,3,1)|(0,0,4)) = ((2,3,2)|(0,0,3))+((2,3,1)|(0,0,3))*AB(3)
        theta(3933) = theta(3198)+theta(2918)*AB(1) ! ((2,2,2)|(4,0,0)) = ((3,2,2)|(3,0,0))+((2,2,2)|(3,0,0))*AB(1)
        theta(3934) = theta(3199)+theta(2919)*AB(1) ! ((2,2,2)|(3,1,0)) = ((3,2,2)|(2,1,0))+((2,2,2)|(2,1,0))*AB(1)
        theta(3935) = theta(3258)+theta(2918)*AB(3) ! ((2,2,2)|(3,0,1)) = ((2,2,3)|(3,0,0))+((2,2,2)|(3,0,0))*AB(3)
        theta(3936) = theta(3201)+theta(2921)*AB(1) ! ((2,2,2)|(2,2,0)) = ((3,2,2)|(1,2,0))+((2,2,2)|(1,2,0))*AB(1)
        theta(3937) = theta(3202)+theta(2922)*AB(1) ! ((2,2,2)|(2,1,1)) = ((3,2,2)|(1,1,1))+((2,2,2)|(1,1,1))*AB(1)
        ! theta(3938) = theta(3203)+theta(2923)*AB(1) ! ((2,2,2)|(2,0,2)) = ((3,2,2)|(1,0,2))+((2,2,2)|(1,0,2))*AB(1)
        theta(3939) = theta(3204)+theta(2924)*AB(1) ! ((2,2,2)|(1,3,0)) = ((3,2,2)|(0,3,0))+((2,2,2)|(0,3,0))*AB(1)
        theta(3940) = theta(3205)+theta(2925)*AB(1) ! ((2,2,2)|(1,2,1)) = ((3,2,2)|(0,2,1))+((2,2,2)|(0,2,1))*AB(1)
        theta(3941) = theta(3206)+theta(2926)*AB(1) ! ((2,2,2)|(1,1,2)) = ((3,2,2)|(0,1,2))+((2,2,2)|(0,1,2))*AB(1)
        theta(3942) = theta(3207)+theta(2927)*AB(1) ! ((2,2,2)|(1,0,3)) = ((3,2,2)|(0,0,3))+((2,2,2)|(0,0,3))*AB(1)
        theta(3943) = theta(3254)+theta(2924)*AB(2) ! ((2,2,2)|(0,4,0)) = ((2,3,2)|(0,3,0))+((2,2,2)|(0,3,0))*AB(2)
        theta(3944) = theta(3264)+theta(2924)*AB(3) ! ((2,2,2)|(0,3,1)) = ((2,2,3)|(0,3,0))+((2,2,2)|(0,3,0))*AB(3)
        theta(3945) = theta(3256)+theta(2926)*AB(2) ! ((2,2,2)|(0,2,2)) = ((2,3,2)|(0,1,2))+((2,2,2)|(0,1,2))*AB(2)
        theta(3946) = theta(3257)+theta(2927)*AB(2) ! ((2,2,2)|(0,1,3)) = ((2,3,2)|(0,0,3))+((2,2,2)|(0,0,3))*AB(2)
        theta(3947) = theta(3267)+theta(2927)*AB(3) ! ((2,2,2)|(0,0,4)) = ((2,2,3)|(0,0,3))+((2,2,2)|(0,0,3))*AB(3)
        theta(3948) = theta(3208)+theta(2928)*AB(1) ! ((2,1,3)|(4,0,0)) = ((3,1,3)|(3,0,0))+((2,1,3)|(3,0,0))*AB(1)
        theta(3949) = theta(3209)+theta(2929)*AB(1) ! ((2,1,3)|(3,1,0)) = ((3,1,3)|(2,1,0))+((2,1,3)|(2,1,0))*AB(1)
        theta(3950) = theta(3268)+theta(2928)*AB(3) ! ((2,1,3)|(3,0,1)) = ((2,1,4)|(3,0,0))+((2,1,3)|(3,0,0))*AB(3)
        theta(3951) = theta(3211)+theta(2931)*AB(1) ! ((2,1,3)|(2,2,0)) = ((3,1,3)|(1,2,0))+((2,1,3)|(1,2,0))*AB(1)
        theta(3952) = theta(3212)+theta(2932)*AB(1) ! ((2,1,3)|(2,1,1)) = ((3,1,3)|(1,1,1))+((2,1,3)|(1,1,1))*AB(1)
        ! theta(3953) = theta(3213)+theta(2933)*AB(1) ! ((2,1,3)|(2,0,2)) = ((3,1,3)|(1,0,2))+((2,1,3)|(1,0,2))*AB(1)
        theta(3954) = theta(3214)+theta(2934)*AB(1) ! ((2,1,3)|(1,3,0)) = ((3,1,3)|(0,3,0))+((2,1,3)|(0,3,0))*AB(1)
        theta(3955) = theta(3215)+theta(2935)*AB(1) ! ((2,1,3)|(1,2,1)) = ((3,1,3)|(0,2,1))+((2,1,3)|(0,2,1))*AB(1)
        theta(3956) = theta(3216)+theta(2936)*AB(1) ! ((2,1,3)|(1,1,2)) = ((3,1,3)|(0,1,2))+((2,1,3)|(0,1,2))*AB(1)
        theta(3957) = theta(3217)+theta(2937)*AB(1) ! ((2,1,3)|(1,0,3)) = ((3,1,3)|(0,0,3))+((2,1,3)|(0,0,3))*AB(1)
        theta(3958) = theta(3264)+theta(2934)*AB(2) ! ((2,1,3)|(0,4,0)) = ((2,2,3)|(0,3,0))+((2,1,3)|(0,3,0))*AB(2)
        theta(3959) = theta(3274)+theta(2934)*AB(3) ! ((2,1,3)|(0,3,1)) = ((2,1,4)|(0,3,0))+((2,1,3)|(0,3,0))*AB(3)
        theta(3960) = theta(3266)+theta(2936)*AB(2) ! ((2,1,3)|(0,2,2)) = ((2,2,3)|(0,1,2))+((2,1,3)|(0,1,2))*AB(2)
        theta(3961) = theta(3267)+theta(2937)*AB(2) ! ((2,1,3)|(0,1,3)) = ((2,2,3)|(0,0,3))+((2,1,3)|(0,0,3))*AB(2)
        theta(3962) = theta(3277)+theta(2937)*AB(3) ! ((2,1,3)|(0,0,4)) = ((2,1,4)|(0,0,3))+((2,1,3)|(0,0,3))*AB(3)
        theta(3963) = theta(3218)+theta(2938)*AB(1) ! ((2,0,4)|(4,0,0)) = ((3,0,4)|(3,0,0))+((2,0,4)|(3,0,0))*AB(1)
        theta(3964) = theta(3219)+theta(2939)*AB(1) ! ((2,0,4)|(3,1,0)) = ((3,0,4)|(2,1,0))+((2,0,4)|(2,1,0))*AB(1)
        theta(3965) = theta(3278)+theta(2938)*AB(3) ! ((2,0,4)|(3,0,1)) = ((2,0,5)|(3,0,0))+((2,0,4)|(3,0,0))*AB(3)
        theta(3966) = theta(3221)+theta(2941)*AB(1) ! ((2,0,4)|(2,2,0)) = ((3,0,4)|(1,2,0))+((2,0,4)|(1,2,0))*AB(1)
        theta(3967) = theta(3222)+theta(2942)*AB(1) ! ((2,0,4)|(2,1,1)) = ((3,0,4)|(1,1,1))+((2,0,4)|(1,1,1))*AB(1)
        ! theta(3968) = theta(3223)+theta(2943)*AB(1) ! ((2,0,4)|(2,0,2)) = ((3,0,4)|(1,0,2))+((2,0,4)|(1,0,2))*AB(1)
        theta(3969) = theta(3224)+theta(2944)*AB(1) ! ((2,0,4)|(1,3,0)) = ((3,0,4)|(0,3,0))+((2,0,4)|(0,3,0))*AB(1)
        theta(3970) = theta(3225)+theta(2945)*AB(1) ! ((2,0,4)|(1,2,1)) = ((3,0,4)|(0,2,1))+((2,0,4)|(0,2,1))*AB(1)
        theta(3971) = theta(3226)+theta(2946)*AB(1) ! ((2,0,4)|(1,1,2)) = ((3,0,4)|(0,1,2))+((2,0,4)|(0,1,2))*AB(1)
        theta(3972) = theta(3227)+theta(2947)*AB(1) ! ((2,0,4)|(1,0,3)) = ((3,0,4)|(0,0,3))+((2,0,4)|(0,0,3))*AB(1)
        theta(3973) = theta(3274)+theta(2944)*AB(2) ! ((2,0,4)|(0,4,0)) = ((2,1,4)|(0,3,0))+((2,0,4)|(0,3,0))*AB(2)
        theta(3974) = theta(3284)+theta(2944)*AB(3) ! ((2,0,4)|(0,3,1)) = ((2,0,5)|(0,3,0))+((2,0,4)|(0,3,0))*AB(3)
        theta(3975) = theta(3276)+theta(2946)*AB(2) ! ((2,0,4)|(0,2,2)) = ((2,1,4)|(0,1,2))+((2,0,4)|(0,1,2))*AB(2)
        theta(3976) = theta(3277)+theta(2947)*AB(2) ! ((2,0,4)|(0,1,3)) = ((2,1,4)|(0,0,3))+((2,0,4)|(0,0,3))*AB(2)
        theta(3977) = theta(3287)+theta(2947)*AB(3) ! ((2,0,4)|(0,0,4)) = ((2,0,5)|(0,0,3))+((2,0,4)|(0,0,3))*AB(3)
        theta(3978) = theta(3228)+theta(2948)*AB(1) ! ((1,5,0)|(4,0,0)) = ((2,5,0)|(3,0,0))+((1,5,0)|(3,0,0))*AB(1)
        theta(3979) = theta(3288)+theta(2948)*AB(2) ! ((1,5,0)|(3,1,0)) = ((1,6,0)|(3,0,0))+((1,5,0)|(3,0,0))*AB(2)
        theta(3980) = theta(3298)+theta(2948)*AB(3) ! ((1,5,0)|(3,0,1)) = ((1,5,1)|(3,0,0))+((1,5,0)|(3,0,0))*AB(3)
        ! theta(3981) = theta(3231)+theta(2951)*AB(1) ! ((1,5,0)|(2,2,0)) = ((2,5,0)|(1,2,0))+((1,5,0)|(1,2,0))*AB(1)
        ! theta(3982) = theta(3290)+theta(2950)*AB(2) ! ((1,5,0)|(2,1,1)) = ((1,6,0)|(2,0,1))+((1,5,0)|(2,0,1))*AB(2)
        theta(3983) = theta(3233)+theta(2953)*AB(1) ! ((1,5,0)|(2,0,2)) = ((2,5,0)|(1,0,2))+((1,5,0)|(1,0,2))*AB(1)
        theta(3984) = theta(3234)+theta(2954)*AB(1) ! ((1,5,0)|(1,3,0)) = ((2,5,0)|(0,3,0))+((1,5,0)|(0,3,0))*AB(1)
        theta(3985) = theta(3235)+theta(2955)*AB(1) ! ((1,5,0)|(1,2,1)) = ((2,5,0)|(0,2,1))+((1,5,0)|(0,2,1))*AB(1)
        ! theta(3986) = theta(3236)+theta(2956)*AB(1) ! ((1,5,0)|(1,1,2)) = ((2,5,0)|(0,1,2))+((1,5,0)|(0,1,2))*AB(1)
        theta(3987) = theta(3237)+theta(2957)*AB(1) ! ((1,5,0)|(1,0,3)) = ((2,5,0)|(0,0,3))+((1,5,0)|(0,0,3))*AB(1)
        theta(3988) = theta(3294)+theta(2954)*AB(2) ! ((1,5,0)|(0,4,0)) = ((1,6,0)|(0,3,0))+((1,5,0)|(0,3,0))*AB(2)
        theta(3989) = theta(3304)+theta(2954)*AB(3) ! ((1,5,0)|(0,3,1)) = ((1,5,1)|(0,3,0))+((1,5,0)|(0,3,0))*AB(3)
        theta(3990) = theta(3296)+theta(2956)*AB(2) ! ((1,5,0)|(0,2,2)) = ((1,6,0)|(0,1,2))+((1,5,0)|(0,1,2))*AB(2)
        theta(3991) = theta(3297)+theta(2957)*AB(2) ! ((1,5,0)|(0,1,3)) = ((1,6,0)|(0,0,3))+((1,5,0)|(0,0,3))*AB(2)
        theta(3992) = theta(3307)+theta(2957)*AB(3) ! ((1,5,0)|(0,0,4)) = ((1,5,1)|(0,0,3))+((1,5,0)|(0,0,3))*AB(3)
        theta(3993) = theta(3238)+theta(2958)*AB(1) ! ((1,4,1)|(4,0,0)) = ((2,4,1)|(3,0,0))+((1,4,1)|(3,0,0))*AB(1)
        theta(3994) = theta(3239)+theta(2959)*AB(1) ! ((1,4,1)|(3,1,0)) = ((2,4,1)|(2,1,0))+((1,4,1)|(2,1,0))*AB(1)
        theta(3995) = theta(3308)+theta(2958)*AB(3) ! ((1,4,1)|(3,0,1)) = ((1,4,2)|(3,0,0))+((1,4,1)|(3,0,0))*AB(3)
        theta(3996) = theta(3241)+theta(2961)*AB(1) ! ((1,4,1)|(2,2,0)) = ((2,4,1)|(1,2,0))+((1,4,1)|(1,2,0))*AB(1)
        theta(3997) = theta(3242)+theta(2962)*AB(1) ! ((1,4,1)|(2,1,1)) = ((2,4,1)|(1,1,1))+((1,4,1)|(1,1,1))*AB(1)
        ! theta(3998) = theta(3243)+theta(2963)*AB(1) ! ((1,4,1)|(2,0,2)) = ((2,4,1)|(1,0,2))+((1,4,1)|(1,0,2))*AB(1)
        theta(3999) = theta(3244)+theta(2964)*AB(1) ! ((1,4,1)|(1,3,0)) = ((2,4,1)|(0,3,0))+((1,4,1)|(0,3,0))*AB(1)
        theta(4000) = theta(3245)+theta(2965)*AB(1) ! ((1,4,1)|(1,2,1)) = ((2,4,1)|(0,2,1))+((1,4,1)|(0,2,1))*AB(1)
        theta(4001) = theta(3246)+theta(2966)*AB(1) ! ((1,4,1)|(1,1,2)) = ((2,4,1)|(0,1,2))+((1,4,1)|(0,1,2))*AB(1)
        theta(4002) = theta(3247)+theta(2967)*AB(1) ! ((1,4,1)|(1,0,3)) = ((2,4,1)|(0,0,3))+((1,4,1)|(0,0,3))*AB(1)
        theta(4003) = theta(3304)+theta(2964)*AB(2) ! ((1,4,1)|(0,4,0)) = ((1,5,1)|(0,3,0))+((1,4,1)|(0,3,0))*AB(2)
        theta(4004) = theta(3314)+theta(2964)*AB(3) ! ((1,4,1)|(0,3,1)) = ((1,4,2)|(0,3,0))+((1,4,1)|(0,3,0))*AB(3)
        theta(4005) = theta(3306)+theta(2966)*AB(2) ! ((1,4,1)|(0,2,2)) = ((1,5,1)|(0,1,2))+((1,4,1)|(0,1,2))*AB(2)
        theta(4006) = theta(3307)+theta(2967)*AB(2) ! ((1,4,1)|(0,1,3)) = ((1,5,1)|(0,0,3))+((1,4,1)|(0,0,3))*AB(2)
        theta(4007) = theta(3317)+theta(2967)*AB(3) ! ((1,4,1)|(0,0,4)) = ((1,4,2)|(0,0,3))+((1,4,1)|(0,0,3))*AB(3)
        theta(4008) = theta(3248)+theta(2968)*AB(1) ! ((1,3,2)|(4,0,0)) = ((2,3,2)|(3,0,0))+((1,3,2)|(3,0,0))*AB(1)
        theta(4009) = theta(3249)+theta(2969)*AB(1) ! ((1,3,2)|(3,1,0)) = ((2,3,2)|(2,1,0))+((1,3,2)|(2,1,0))*AB(1)
        theta(4010) = theta(3318)+theta(2968)*AB(3) ! ((1,3,2)|(3,0,1)) = ((1,3,3)|(3,0,0))+((1,3,2)|(3,0,0))*AB(3)
        theta(4011) = theta(3251)+theta(2971)*AB(1) ! ((1,3,2)|(2,2,0)) = ((2,3,2)|(1,2,0))+((1,3,2)|(1,2,0))*AB(1)
        theta(4012) = theta(3252)+theta(2972)*AB(1) ! ((1,3,2)|(2,1,1)) = ((2,3,2)|(1,1,1))+((1,3,2)|(1,1,1))*AB(1)
        ! theta(4013) = theta(3253)+theta(2973)*AB(1) ! ((1,3,2)|(2,0,2)) = ((2,3,2)|(1,0,2))+((1,3,2)|(1,0,2))*AB(1)
        theta(4014) = theta(3254)+theta(2974)*AB(1) ! ((1,3,2)|(1,3,0)) = ((2,3,2)|(0,3,0))+((1,3,2)|(0,3,0))*AB(1)
        theta(4015) = theta(3255)+theta(2975)*AB(1) ! ((1,3,2)|(1,2,1)) = ((2,3,2)|(0,2,1))+((1,3,2)|(0,2,1))*AB(1)
        theta(4016) = theta(3256)+theta(2976)*AB(1) ! ((1,3,2)|(1,1,2)) = ((2,3,2)|(0,1,2))+((1,3,2)|(0,1,2))*AB(1)
        theta(4017) = theta(3257)+theta(2977)*AB(1) ! ((1,3,2)|(1,0,3)) = ((2,3,2)|(0,0,3))+((1,3,2)|(0,0,3))*AB(1)
        theta(4018) = theta(3314)+theta(2974)*AB(2) ! ((1,3,2)|(0,4,0)) = ((1,4,2)|(0,3,0))+((1,3,2)|(0,3,0))*AB(2)
        theta(4019) = theta(3324)+theta(2974)*AB(3) ! ((1,3,2)|(0,3,1)) = ((1,3,3)|(0,3,0))+((1,3,2)|(0,3,0))*AB(3)
        theta(4020) = theta(3316)+theta(2976)*AB(2) ! ((1,3,2)|(0,2,2)) = ((1,4,2)|(0,1,2))+((1,3,2)|(0,1,2))*AB(2)
        theta(4021) = theta(3317)+theta(2977)*AB(2) ! ((1,3,2)|(0,1,3)) = ((1,4,2)|(0,0,3))+((1,3,2)|(0,0,3))*AB(2)
        theta(4022) = theta(3327)+theta(2977)*AB(3) ! ((1,3,2)|(0,0,4)) = ((1,3,3)|(0,0,3))+((1,3,2)|(0,0,3))*AB(3)
        theta(4023) = theta(3258)+theta(2978)*AB(1) ! ((1,2,3)|(4,0,0)) = ((2,2,3)|(3,0,0))+((1,2,3)|(3,0,0))*AB(1)
        theta(4024) = theta(3259)+theta(2979)*AB(1) ! ((1,2,3)|(3,1,0)) = ((2,2,3)|(2,1,0))+((1,2,3)|(2,1,0))*AB(1)
        theta(4025) = theta(3328)+theta(2978)*AB(3) ! ((1,2,3)|(3,0,1)) = ((1,2,4)|(3,0,0))+((1,2,3)|(3,0,0))*AB(3)
        theta(4026) = theta(3261)+theta(2981)*AB(1) ! ((1,2,3)|(2,2,0)) = ((2,2,3)|(1,2,0))+((1,2,3)|(1,2,0))*AB(1)
        theta(4027) = theta(3262)+theta(2982)*AB(1) ! ((1,2,3)|(2,1,1)) = ((2,2,3)|(1,1,1))+((1,2,3)|(1,1,1))*AB(1)
        ! theta(4028) = theta(3263)+theta(2983)*AB(1) ! ((1,2,3)|(2,0,2)) = ((2,2,3)|(1,0,2))+((1,2,3)|(1,0,2))*AB(1)
        theta(4029) = theta(3264)+theta(2984)*AB(1) ! ((1,2,3)|(1,3,0)) = ((2,2,3)|(0,3,0))+((1,2,3)|(0,3,0))*AB(1)
        theta(4030) = theta(3265)+theta(2985)*AB(1) ! ((1,2,3)|(1,2,1)) = ((2,2,3)|(0,2,1))+((1,2,3)|(0,2,1))*AB(1)
        theta(4031) = theta(3266)+theta(2986)*AB(1) ! ((1,2,3)|(1,1,2)) = ((2,2,3)|(0,1,2))+((1,2,3)|(0,1,2))*AB(1)
        theta(4032) = theta(3267)+theta(2987)*AB(1) ! ((1,2,3)|(1,0,3)) = ((2,2,3)|(0,0,3))+((1,2,3)|(0,0,3))*AB(1)
        theta(4033) = theta(3324)+theta(2984)*AB(2) ! ((1,2,3)|(0,4,0)) = ((1,3,3)|(0,3,0))+((1,2,3)|(0,3,0))*AB(2)
        theta(4034) = theta(3334)+theta(2984)*AB(3) ! ((1,2,3)|(0,3,1)) = ((1,2,4)|(0,3,0))+((1,2,3)|(0,3,0))*AB(3)
        theta(4035) = theta(3326)+theta(2986)*AB(2) ! ((1,2,3)|(0,2,2)) = ((1,3,3)|(0,1,2))+((1,2,3)|(0,1,2))*AB(2)
        theta(4036) = theta(3327)+theta(2987)*AB(2) ! ((1,2,3)|(0,1,3)) = ((1,3,3)|(0,0,3))+((1,2,3)|(0,0,3))*AB(2)
        theta(4037) = theta(3337)+theta(2987)*AB(3) ! ((1,2,3)|(0,0,4)) = ((1,2,4)|(0,0,3))+((1,2,3)|(0,0,3))*AB(3)
        theta(4038) = theta(3268)+theta(2988)*AB(1) ! ((1,1,4)|(4,0,0)) = ((2,1,4)|(3,0,0))+((1,1,4)|(3,0,0))*AB(1)
        theta(4039) = theta(3269)+theta(2989)*AB(1) ! ((1,1,4)|(3,1,0)) = ((2,1,4)|(2,1,0))+((1,1,4)|(2,1,0))*AB(1)
        theta(4040) = theta(3338)+theta(2988)*AB(3) ! ((1,1,4)|(3,0,1)) = ((1,1,5)|(3,0,0))+((1,1,4)|(3,0,0))*AB(3)
        theta(4041) = theta(3271)+theta(2991)*AB(1) ! ((1,1,4)|(2,2,0)) = ((2,1,4)|(1,2,0))+((1,1,4)|(1,2,0))*AB(1)
        theta(4042) = theta(3272)+theta(2992)*AB(1) ! ((1,1,4)|(2,1,1)) = ((2,1,4)|(1,1,1))+((1,1,4)|(1,1,1))*AB(1)
        ! theta(4043) = theta(3273)+theta(2993)*AB(1) ! ((1,1,4)|(2,0,2)) = ((2,1,4)|(1,0,2))+((1,1,4)|(1,0,2))*AB(1)
        theta(4044) = theta(3274)+theta(2994)*AB(1) ! ((1,1,4)|(1,3,0)) = ((2,1,4)|(0,3,0))+((1,1,4)|(0,3,0))*AB(1)
        theta(4045) = theta(3275)+theta(2995)*AB(1) ! ((1,1,4)|(1,2,1)) = ((2,1,4)|(0,2,1))+((1,1,4)|(0,2,1))*AB(1)
        theta(4046) = theta(3276)+theta(2996)*AB(1) ! ((1,1,4)|(1,1,2)) = ((2,1,4)|(0,1,2))+((1,1,4)|(0,1,2))*AB(1)
        theta(4047) = theta(3277)+theta(2997)*AB(1) ! ((1,1,4)|(1,0,3)) = ((2,1,4)|(0,0,3))+((1,1,4)|(0,0,3))*AB(1)
        theta(4048) = theta(3334)+theta(2994)*AB(2) ! ((1,1,4)|(0,4,0)) = ((1,2,4)|(0,3,0))+((1,1,4)|(0,3,0))*AB(2)
        theta(4049) = theta(3344)+theta(2994)*AB(3) ! ((1,1,4)|(0,3,1)) = ((1,1,5)|(0,3,0))+((1,1,4)|(0,3,0))*AB(3)
        theta(4050) = theta(3336)+theta(2996)*AB(2) ! ((1,1,4)|(0,2,2)) = ((1,2,4)|(0,1,2))+((1,1,4)|(0,1,2))*AB(2)
        theta(4051) = theta(3337)+theta(2997)*AB(2) ! ((1,1,4)|(0,1,3)) = ((1,2,4)|(0,0,3))+((1,1,4)|(0,0,3))*AB(2)
        theta(4052) = theta(3347)+theta(2997)*AB(3) ! ((1,1,4)|(0,0,4)) = ((1,1,5)|(0,0,3))+((1,1,4)|(0,0,3))*AB(3)
        theta(4053) = theta(3278)+theta(2998)*AB(1) ! ((1,0,5)|(4,0,0)) = ((2,0,5)|(3,0,0))+((1,0,5)|(3,0,0))*AB(1)
        theta(4054) = theta(3279)+theta(2999)*AB(1) ! ((1,0,5)|(3,1,0)) = ((2,0,5)|(2,1,0))+((1,0,5)|(2,1,0))*AB(1)
        theta(4055) = theta(3348)+theta(2998)*AB(3) ! ((1,0,5)|(3,0,1)) = ((1,0,6)|(3,0,0))+((1,0,5)|(3,0,0))*AB(3)
        theta(4056) = theta(3281)+theta(3001)*AB(1) ! ((1,0,5)|(2,2,0)) = ((2,0,5)|(1,2,0))+((1,0,5)|(1,2,0))*AB(1)
        theta(4057) = theta(3282)+theta(3002)*AB(1) ! ((1,0,5)|(2,1,1)) = ((2,0,5)|(1,1,1))+((1,0,5)|(1,1,1))*AB(1)
        ! theta(4058) = theta(3283)+theta(3003)*AB(1) ! ((1,0,5)|(2,0,2)) = ((2,0,5)|(1,0,2))+((1,0,5)|(1,0,2))*AB(1)
        theta(4059) = theta(3284)+theta(3004)*AB(1) ! ((1,0,5)|(1,3,0)) = ((2,0,5)|(0,3,0))+((1,0,5)|(0,3,0))*AB(1)
        theta(4060) = theta(3285)+theta(3005)*AB(1) ! ((1,0,5)|(1,2,1)) = ((2,0,5)|(0,2,1))+((1,0,5)|(0,2,1))*AB(1)
        theta(4061) = theta(3286)+theta(3006)*AB(1) ! ((1,0,5)|(1,1,2)) = ((2,0,5)|(0,1,2))+((1,0,5)|(0,1,2))*AB(1)
        theta(4062) = theta(3287)+theta(3007)*AB(1) ! ((1,0,5)|(1,0,3)) = ((2,0,5)|(0,0,3))+((1,0,5)|(0,0,3))*AB(1)
        theta(4063) = theta(3344)+theta(3004)*AB(2) ! ((1,0,5)|(0,4,0)) = ((1,1,5)|(0,3,0))+((1,0,5)|(0,3,0))*AB(2)
        theta(4064) = theta(3354)+theta(3004)*AB(3) ! ((1,0,5)|(0,3,1)) = ((1,0,6)|(0,3,0))+((1,0,5)|(0,3,0))*AB(3)
        theta(4065) = theta(3346)+theta(3006)*AB(2) ! ((1,0,5)|(0,2,2)) = ((1,1,5)|(0,1,2))+((1,0,5)|(0,1,2))*AB(2)
        theta(4066) = theta(3347)+theta(3007)*AB(2) ! ((1,0,5)|(0,1,3)) = ((1,1,5)|(0,0,3))+((1,0,5)|(0,0,3))*AB(2)
        theta(4067) = theta(3357)+theta(3007)*AB(3) ! ((1,0,5)|(0,0,4)) = ((1,0,6)|(0,0,3))+((1,0,5)|(0,0,3))*AB(3)
        theta(4068) = theta(3288)+theta(3008)*AB(1) ! ((0,6,0)|(4,0,0)) = ((1,6,0)|(3,0,0))+((0,6,0)|(3,0,0))*AB(1)
        theta(4069) = theta(3358)+theta(3008)*AB(2) ! ((0,6,0)|(3,1,0)) = ((0,7,0)|(3,0,0))+((0,6,0)|(3,0,0))*AB(2)
        theta(4070) = theta(3368)+theta(3008)*AB(3) ! ((0,6,0)|(3,0,1)) = ((0,6,1)|(3,0,0))+((0,6,0)|(3,0,0))*AB(3)
        ! theta(4071) = theta(3291)+theta(3011)*AB(1) ! ((0,6,0)|(2,2,0)) = ((1,6,0)|(1,2,0))+((0,6,0)|(1,2,0))*AB(1)
        ! theta(4072) = theta(3360)+theta(3010)*AB(2) ! ((0,6,0)|(2,1,1)) = ((0,7,0)|(2,0,1))+((0,6,0)|(2,0,1))*AB(2)
        theta(4073) = theta(3293)+theta(3013)*AB(1) ! ((0,6,0)|(2,0,2)) = ((1,6,0)|(1,0,2))+((0,6,0)|(1,0,2))*AB(1)
        ! theta(4074) = theta(3294)+theta(3014)*AB(1) ! ((0,6,0)|(1,3,0)) = ((1,6,0)|(0,3,0))+((0,6,0)|(0,3,0))*AB(1)
        ! theta(4075) = theta(3295)+theta(3015)*AB(1) ! ((0,6,0)|(1,2,1)) = ((1,6,0)|(0,2,1))+((0,6,0)|(0,2,1))*AB(1)
        ! theta(4076) = theta(3296)+theta(3016)*AB(1) ! ((0,6,0)|(1,1,2)) = ((1,6,0)|(0,1,2))+((0,6,0)|(0,1,2))*AB(1)
        ! theta(4077) = theta(3297)+theta(3017)*AB(1) ! ((0,6,0)|(1,0,3)) = ((1,6,0)|(0,0,3))+((0,6,0)|(0,0,3))*AB(1)
        theta(4078) = theta(3364)+theta(3014)*AB(2) ! ((0,6,0)|(0,4,0)) = ((0,7,0)|(0,3,0))+((0,6,0)|(0,3,0))*AB(2)
        ! theta(4079) = theta(3374)+theta(3014)*AB(3) ! ((0,6,0)|(0,3,1)) = ((0,6,1)|(0,3,0))+((0,6,0)|(0,3,0))*AB(3)
        ! theta(4080) = theta(3366)+theta(3016)*AB(2) ! ((0,6,0)|(0,2,2)) = ((0,7,0)|(0,1,2))+((0,6,0)|(0,1,2))*AB(2)
        theta(4081) = theta(3367)+theta(3017)*AB(2) ! ((0,6,0)|(0,1,3)) = ((0,7,0)|(0,0,3))+((0,6,0)|(0,0,3))*AB(2)
        theta(4082) = theta(3377)+theta(3017)*AB(3) ! ((0,6,0)|(0,0,4)) = ((0,6,1)|(0,0,3))+((0,6,0)|(0,0,3))*AB(3)
        theta(4083) = theta(3298)+theta(3018)*AB(1) ! ((0,5,1)|(4,0,0)) = ((1,5,1)|(3,0,0))+((0,5,1)|(3,0,0))*AB(1)
        ! theta(4084) = theta(3299)+theta(3019)*AB(1) ! ((0,5,1)|(3,1,0)) = ((1,5,1)|(2,1,0))+((0,5,1)|(2,1,0))*AB(1)
        theta(4085) = theta(3378)+theta(3018)*AB(3) ! ((0,5,1)|(3,0,1)) = ((0,5,2)|(3,0,0))+((0,5,1)|(3,0,0))*AB(3)
        ! theta(4086) = theta(3301)+theta(3021)*AB(1) ! ((0,5,1)|(2,2,0)) = ((1,5,1)|(1,2,0))+((0,5,1)|(1,2,0))*AB(1)
        ! theta(4087) = theta(3302)+theta(3022)*AB(1) ! ((0,5,1)|(2,1,1)) = ((1,5,1)|(1,1,1))+((0,5,1)|(1,1,1))*AB(1)
        ! theta(4088) = theta(3303)+theta(3023)*AB(1) ! ((0,5,1)|(2,0,2)) = ((1,5,1)|(1,0,2))+((0,5,1)|(1,0,2))*AB(1)
        ! theta(4089) = theta(3304)+theta(3024)*AB(1) ! ((0,5,1)|(1,3,0)) = ((1,5,1)|(0,3,0))+((0,5,1)|(0,3,0))*AB(1)
        ! theta(4090) = theta(3305)+theta(3025)*AB(1) ! ((0,5,1)|(1,2,1)) = ((1,5,1)|(0,2,1))+((0,5,1)|(0,2,1))*AB(1)
        ! theta(4091) = theta(3306)+theta(3026)*AB(1) ! ((0,5,1)|(1,1,2)) = ((1,5,1)|(0,1,2))+((0,5,1)|(0,1,2))*AB(1)
        ! theta(4092) = theta(3307)+theta(3027)*AB(1) ! ((0,5,1)|(1,0,3)) = ((1,5,1)|(0,0,3))+((0,5,1)|(0,0,3))*AB(1)
        theta(4093) = theta(3374)+theta(3024)*AB(2) ! ((0,5,1)|(0,4,0)) = ((0,6,1)|(0,3,0))+((0,5,1)|(0,3,0))*AB(2)
        theta(4094) = theta(3384)+theta(3024)*AB(3) ! ((0,5,1)|(0,3,1)) = ((0,5,2)|(0,3,0))+((0,5,1)|(0,3,0))*AB(3)
        ! theta(4095) = theta(3376)+theta(3026)*AB(2) ! ((0,5,1)|(0,2,2)) = ((0,6,1)|(0,1,2))+((0,5,1)|(0,1,2))*AB(2)
        theta(4096) = theta(3377)+theta(3027)*AB(2) ! ((0,5,1)|(0,1,3)) = ((0,6,1)|(0,0,3))+((0,5,1)|(0,0,3))*AB(2)
        theta(4097) = theta(3387)+theta(3027)*AB(3) ! ((0,5,1)|(0,0,4)) = ((0,5,2)|(0,0,3))+((0,5,1)|(0,0,3))*AB(3)
        theta(4098) = theta(3308)+theta(3028)*AB(1) ! ((0,4,2)|(4,0,0)) = ((1,4,2)|(3,0,0))+((0,4,2)|(3,0,0))*AB(1)
        ! theta(4099) = theta(3309)+theta(3029)*AB(1) ! ((0,4,2)|(3,1,0)) = ((1,4,2)|(2,1,0))+((0,4,2)|(2,1,0))*AB(1)
        theta(4100) = theta(3388)+theta(3028)*AB(3) ! ((0,4,2)|(3,0,1)) = ((0,4,3)|(3,0,0))+((0,4,2)|(3,0,0))*AB(3)
        ! theta(4101) = theta(3311)+theta(3031)*AB(1) ! ((0,4,2)|(2,2,0)) = ((1,4,2)|(1,2,0))+((0,4,2)|(1,2,0))*AB(1)
        ! theta(4102) = theta(3312)+theta(3032)*AB(1) ! ((0,4,2)|(2,1,1)) = ((1,4,2)|(1,1,1))+((0,4,2)|(1,1,1))*AB(1)
        ! theta(4103) = theta(3313)+theta(3033)*AB(1) ! ((0,4,2)|(2,0,2)) = ((1,4,2)|(1,0,2))+((0,4,2)|(1,0,2))*AB(1)
        ! theta(4104) = theta(3314)+theta(3034)*AB(1) ! ((0,4,2)|(1,3,0)) = ((1,4,2)|(0,3,0))+((0,4,2)|(0,3,0))*AB(1)
        ! theta(4105) = theta(3315)+theta(3035)*AB(1) ! ((0,4,2)|(1,2,1)) = ((1,4,2)|(0,2,1))+((0,4,2)|(0,2,1))*AB(1)
        ! theta(4106) = theta(3316)+theta(3036)*AB(1) ! ((0,4,2)|(1,1,2)) = ((1,4,2)|(0,1,2))+((0,4,2)|(0,1,2))*AB(1)
        ! theta(4107) = theta(3317)+theta(3037)*AB(1) ! ((0,4,2)|(1,0,3)) = ((1,4,2)|(0,0,3))+((0,4,2)|(0,0,3))*AB(1)
        theta(4108) = theta(3384)+theta(3034)*AB(2) ! ((0,4,2)|(0,4,0)) = ((0,5,2)|(0,3,0))+((0,4,2)|(0,3,0))*AB(2)
        theta(4109) = theta(3394)+theta(3034)*AB(3) ! ((0,4,2)|(0,3,1)) = ((0,4,3)|(0,3,0))+((0,4,2)|(0,3,0))*AB(3)
        ! theta(4110) = theta(3386)+theta(3036)*AB(2) ! ((0,4,2)|(0,2,2)) = ((0,5,2)|(0,1,2))+((0,4,2)|(0,1,2))*AB(2)
        theta(4111) = theta(3387)+theta(3037)*AB(2) ! ((0,4,2)|(0,1,3)) = ((0,5,2)|(0,0,3))+((0,4,2)|(0,0,3))*AB(2)
        theta(4112) = theta(3397)+theta(3037)*AB(3) ! ((0,4,2)|(0,0,4)) = ((0,4,3)|(0,0,3))+((0,4,2)|(0,0,3))*AB(3)
        theta(4113) = theta(3318)+theta(3038)*AB(1) ! ((0,3,3)|(4,0,0)) = ((1,3,3)|(3,0,0))+((0,3,3)|(3,0,0))*AB(1)
        ! theta(4114) = theta(3319)+theta(3039)*AB(1) ! ((0,3,3)|(3,1,0)) = ((1,3,3)|(2,1,0))+((0,3,3)|(2,1,0))*AB(1)
        theta(4115) = theta(3398)+theta(3038)*AB(3) ! ((0,3,3)|(3,0,1)) = ((0,3,4)|(3,0,0))+((0,3,3)|(3,0,0))*AB(3)
        ! theta(4116) = theta(3321)+theta(3041)*AB(1) ! ((0,3,3)|(2,2,0)) = ((1,3,3)|(1,2,0))+((0,3,3)|(1,2,0))*AB(1)
        ! theta(4117) = theta(3322)+theta(3042)*AB(1) ! ((0,3,3)|(2,1,1)) = ((1,3,3)|(1,1,1))+((0,3,3)|(1,1,1))*AB(1)
        ! theta(4118) = theta(3323)+theta(3043)*AB(1) ! ((0,3,3)|(2,0,2)) = ((1,3,3)|(1,0,2))+((0,3,3)|(1,0,2))*AB(1)
        ! theta(4119) = theta(3324)+theta(3044)*AB(1) ! ((0,3,3)|(1,3,0)) = ((1,3,3)|(0,3,0))+((0,3,3)|(0,3,0))*AB(1)
        ! theta(4120) = theta(3325)+theta(3045)*AB(1) ! ((0,3,3)|(1,2,1)) = ((1,3,3)|(0,2,1))+((0,3,3)|(0,2,1))*AB(1)
        ! theta(4121) = theta(3326)+theta(3046)*AB(1) ! ((0,3,3)|(1,1,2)) = ((1,3,3)|(0,1,2))+((0,3,3)|(0,1,2))*AB(1)
        ! theta(4122) = theta(3327)+theta(3047)*AB(1) ! ((0,3,3)|(1,0,3)) = ((1,3,3)|(0,0,3))+((0,3,3)|(0,0,3))*AB(1)
        theta(4123) = theta(3394)+theta(3044)*AB(2) ! ((0,3,3)|(0,4,0)) = ((0,4,3)|(0,3,0))+((0,3,3)|(0,3,0))*AB(2)
        theta(4124) = theta(3404)+theta(3044)*AB(3) ! ((0,3,3)|(0,3,1)) = ((0,3,4)|(0,3,0))+((0,3,3)|(0,3,0))*AB(3)
        ! theta(4125) = theta(3396)+theta(3046)*AB(2) ! ((0,3,3)|(0,2,2)) = ((0,4,3)|(0,1,2))+((0,3,3)|(0,1,2))*AB(2)
        theta(4126) = theta(3397)+theta(3047)*AB(2) ! ((0,3,3)|(0,1,3)) = ((0,4,3)|(0,0,3))+((0,3,3)|(0,0,3))*AB(2)
        theta(4127) = theta(3407)+theta(3047)*AB(3) ! ((0,3,3)|(0,0,4)) = ((0,3,4)|(0,0,3))+((0,3,3)|(0,0,3))*AB(3)
        theta(4128) = theta(3328)+theta(3048)*AB(1) ! ((0,2,4)|(4,0,0)) = ((1,2,4)|(3,0,0))+((0,2,4)|(3,0,0))*AB(1)
        ! theta(4129) = theta(3329)+theta(3049)*AB(1) ! ((0,2,4)|(3,1,0)) = ((1,2,4)|(2,1,0))+((0,2,4)|(2,1,0))*AB(1)
        theta(4130) = theta(3408)+theta(3048)*AB(3) ! ((0,2,4)|(3,0,1)) = ((0,2,5)|(3,0,0))+((0,2,4)|(3,0,0))*AB(3)
        ! theta(4131) = theta(3331)+theta(3051)*AB(1) ! ((0,2,4)|(2,2,0)) = ((1,2,4)|(1,2,0))+((0,2,4)|(1,2,0))*AB(1)
        ! theta(4132) = theta(3332)+theta(3052)*AB(1) ! ((0,2,4)|(2,1,1)) = ((1,2,4)|(1,1,1))+((0,2,4)|(1,1,1))*AB(1)
        ! theta(4133) = theta(3333)+theta(3053)*AB(1) ! ((0,2,4)|(2,0,2)) = ((1,2,4)|(1,0,2))+((0,2,4)|(1,0,2))*AB(1)
        ! theta(4134) = theta(3334)+theta(3054)*AB(1) ! ((0,2,4)|(1,3,0)) = ((1,2,4)|(0,3,0))+((0,2,4)|(0,3,0))*AB(1)
        ! theta(4135) = theta(3335)+theta(3055)*AB(1) ! ((0,2,4)|(1,2,1)) = ((1,2,4)|(0,2,1))+((0,2,4)|(0,2,1))*AB(1)
        ! theta(4136) = theta(3336)+theta(3056)*AB(1) ! ((0,2,4)|(1,1,2)) = ((1,2,4)|(0,1,2))+((0,2,4)|(0,1,2))*AB(1)
        ! theta(4137) = theta(3337)+theta(3057)*AB(1) ! ((0,2,4)|(1,0,3)) = ((1,2,4)|(0,0,3))+((0,2,4)|(0,0,3))*AB(1)
        theta(4138) = theta(3404)+theta(3054)*AB(2) ! ((0,2,4)|(0,4,0)) = ((0,3,4)|(0,3,0))+((0,2,4)|(0,3,0))*AB(2)
        theta(4139) = theta(3414)+theta(3054)*AB(3) ! ((0,2,4)|(0,3,1)) = ((0,2,5)|(0,3,0))+((0,2,4)|(0,3,0))*AB(3)
        ! theta(4140) = theta(3406)+theta(3056)*AB(2) ! ((0,2,4)|(0,2,2)) = ((0,3,4)|(0,1,2))+((0,2,4)|(0,1,2))*AB(2)
        theta(4141) = theta(3407)+theta(3057)*AB(2) ! ((0,2,4)|(0,1,3)) = ((0,3,4)|(0,0,3))+((0,2,4)|(0,0,3))*AB(2)
        theta(4142) = theta(3417)+theta(3057)*AB(3) ! ((0,2,4)|(0,0,4)) = ((0,2,5)|(0,0,3))+((0,2,4)|(0,0,3))*AB(3)
        theta(4143) = theta(3338)+theta(3058)*AB(1) ! ((0,1,5)|(4,0,0)) = ((1,1,5)|(3,0,0))+((0,1,5)|(3,0,0))*AB(1)
        ! theta(4144) = theta(3339)+theta(3059)*AB(1) ! ((0,1,5)|(3,1,0)) = ((1,1,5)|(2,1,0))+((0,1,5)|(2,1,0))*AB(1)
        theta(4145) = theta(3418)+theta(3058)*AB(3) ! ((0,1,5)|(3,0,1)) = ((0,1,6)|(3,0,0))+((0,1,5)|(3,0,0))*AB(3)
        ! theta(4146) = theta(3341)+theta(3061)*AB(1) ! ((0,1,5)|(2,2,0)) = ((1,1,5)|(1,2,0))+((0,1,5)|(1,2,0))*AB(1)
        ! theta(4147) = theta(3342)+theta(3062)*AB(1) ! ((0,1,5)|(2,1,1)) = ((1,1,5)|(1,1,1))+((0,1,5)|(1,1,1))*AB(1)
        ! theta(4148) = theta(3343)+theta(3063)*AB(1) ! ((0,1,5)|(2,0,2)) = ((1,1,5)|(1,0,2))+((0,1,5)|(1,0,2))*AB(1)
        ! theta(4149) = theta(3344)+theta(3064)*AB(1) ! ((0,1,5)|(1,3,0)) = ((1,1,5)|(0,3,0))+((0,1,5)|(0,3,0))*AB(1)
        ! theta(4150) = theta(3345)+theta(3065)*AB(1) ! ((0,1,5)|(1,2,1)) = ((1,1,5)|(0,2,1))+((0,1,5)|(0,2,1))*AB(1)
        ! theta(4151) = theta(3346)+theta(3066)*AB(1) ! ((0,1,5)|(1,1,2)) = ((1,1,5)|(0,1,2))+((0,1,5)|(0,1,2))*AB(1)
        ! theta(4152) = theta(3347)+theta(3067)*AB(1) ! ((0,1,5)|(1,0,3)) = ((1,1,5)|(0,0,3))+((0,1,5)|(0,0,3))*AB(1)
        theta(4153) = theta(3414)+theta(3064)*AB(2) ! ((0,1,5)|(0,4,0)) = ((0,2,5)|(0,3,0))+((0,1,5)|(0,3,0))*AB(2)
        theta(4154) = theta(3424)+theta(3064)*AB(3) ! ((0,1,5)|(0,3,1)) = ((0,1,6)|(0,3,0))+((0,1,5)|(0,3,0))*AB(3)
        ! theta(4155) = theta(3416)+theta(3066)*AB(2) ! ((0,1,5)|(0,2,2)) = ((0,2,5)|(0,1,2))+((0,1,5)|(0,1,2))*AB(2)
        theta(4156) = theta(3417)+theta(3067)*AB(2) ! ((0,1,5)|(0,1,3)) = ((0,2,5)|(0,0,3))+((0,1,5)|(0,0,3))*AB(2)
        theta(4157) = theta(3427)+theta(3067)*AB(3) ! ((0,1,5)|(0,0,4)) = ((0,1,6)|(0,0,3))+((0,1,5)|(0,0,3))*AB(3)
        theta(4158) = theta(3348)+theta(3068)*AB(1) ! ((0,0,6)|(4,0,0)) = ((1,0,6)|(3,0,0))+((0,0,6)|(3,0,0))*AB(1)
        ! theta(4159) = theta(3349)+theta(3069)*AB(1) ! ((0,0,6)|(3,1,0)) = ((1,0,6)|(2,1,0))+((0,0,6)|(2,1,0))*AB(1)
        theta(4160) = theta(3428)+theta(3068)*AB(3) ! ((0,0,6)|(3,0,1)) = ((0,0,7)|(3,0,0))+((0,0,6)|(3,0,0))*AB(3)
        ! theta(4161) = theta(3351)+theta(3071)*AB(1) ! ((0,0,6)|(2,2,0)) = ((1,0,6)|(1,2,0))+((0,0,6)|(1,2,0))*AB(1)
        ! theta(4162) = theta(3352)+theta(3072)*AB(1) ! ((0,0,6)|(2,1,1)) = ((1,0,6)|(1,1,1))+((0,0,6)|(1,1,1))*AB(1)
        ! theta(4163) = theta(3353)+theta(3073)*AB(1) ! ((0,0,6)|(2,0,2)) = ((1,0,6)|(1,0,2))+((0,0,6)|(1,0,2))*AB(1)
        ! theta(4164) = theta(3354)+theta(3074)*AB(1) ! ((0,0,6)|(1,3,0)) = ((1,0,6)|(0,3,0))+((0,0,6)|(0,3,0))*AB(1)
        ! theta(4165) = theta(3355)+theta(3075)*AB(1) ! ((0,0,6)|(1,2,1)) = ((1,0,6)|(0,2,1))+((0,0,6)|(0,2,1))*AB(1)
        ! theta(4166) = theta(3356)+theta(3076)*AB(1) ! ((0,0,6)|(1,1,2)) = ((1,0,6)|(0,1,2))+((0,0,6)|(0,1,2))*AB(1)
        ! theta(4167) = theta(3357)+theta(3077)*AB(1) ! ((0,0,6)|(1,0,3)) = ((1,0,6)|(0,0,3))+((0,0,6)|(0,0,3))*AB(1)
        theta(4168) = theta(3424)+theta(3074)*AB(2) ! ((0,0,6)|(0,4,0)) = ((0,1,6)|(0,3,0))+((0,0,6)|(0,3,0))*AB(2)
        theta(4169) = theta(3434)+theta(3074)*AB(3) ! ((0,0,6)|(0,3,1)) = ((0,0,7)|(0,3,0))+((0,0,6)|(0,3,0))*AB(3)
        ! theta(4170) = theta(3426)+theta(3076)*AB(2) ! ((0,0,6)|(0,2,2)) = ((0,1,6)|(0,1,2))+((0,0,6)|(0,1,2))*AB(2)
        ! theta(4171) = theta(3427)+theta(3077)*AB(2) ! ((0,0,6)|(0,1,3)) = ((0,1,6)|(0,0,3))+((0,0,6)|(0,0,3))*AB(2)
        theta(4172) = theta(3437)+theta(3077)*AB(3) ! ((0,0,6)|(0,0,4)) = ((0,0,7)|(0,0,3))+((0,0,6)|(0,0,3))*AB(3)
        theta(4173) = theta(3753)+theta(3438)*AB(1) ! ((5,0,0)|(5,0,0)) = ((6,0,0)|(4,0,0))+((5,0,0)|(4,0,0))*AB(1)
        theta(4174) = theta(3768)+theta(3438)*AB(2) ! ((5,0,0)|(4,1,0)) = ((5,1,0)|(4,0,0))+((5,0,0)|(4,0,0))*AB(2)
        theta(4175) = theta(3783)+theta(3438)*AB(3) ! ((5,0,0)|(4,0,1)) = ((5,0,1)|(4,0,0))+((5,0,0)|(4,0,0))*AB(3)
        theta(4176) = theta(3769)+theta(3439)*AB(2) ! ((5,0,0)|(3,2,0)) = ((5,1,0)|(3,1,0))+((5,0,0)|(3,1,0))*AB(2)
        theta(4177) = theta(3770)+theta(3440)*AB(2) ! ((5,0,0)|(3,1,1)) = ((5,1,0)|(3,0,1))+((5,0,0)|(3,0,1))*AB(2)
        theta(4178) = theta(3785)+theta(3440)*AB(3) ! ((5,0,0)|(3,0,2)) = ((5,0,1)|(3,0,1))+((5,0,0)|(3,0,1))*AB(3)
        theta(4179) = theta(3759)+theta(3444)*AB(1) ! ((5,0,0)|(2,3,0)) = ((6,0,0)|(1,3,0))+((5,0,0)|(1,3,0))*AB(1)
        theta(4180) = theta(3760)+theta(3445)*AB(1) ! ((5,0,0)|(2,2,1)) = ((6,0,0)|(1,2,1))+((5,0,0)|(1,2,1))*AB(1)
        theta(4181) = theta(3773)+theta(3443)*AB(2) ! ((5,0,0)|(2,1,2)) = ((5,1,0)|(2,0,2))+((5,0,0)|(2,0,2))*AB(2)
        theta(4182) = theta(3762)+theta(3447)*AB(1) ! ((5,0,0)|(2,0,3)) = ((6,0,0)|(1,0,3))+((5,0,0)|(1,0,3))*AB(1)
        theta(4183) = theta(3763)+theta(3448)*AB(1) ! ((5,0,0)|(1,4,0)) = ((6,0,0)|(0,4,0))+((5,0,0)|(0,4,0))*AB(1)
        theta(4184) = theta(3764)+theta(3449)*AB(1) ! ((5,0,0)|(1,3,1)) = ((6,0,0)|(0,3,1))+((5,0,0)|(0,3,1))*AB(1)
        theta(4185) = theta(3765)+theta(3450)*AB(1) ! ((5,0,0)|(1,2,2)) = ((6,0,0)|(0,2,2))+((5,0,0)|(0,2,2))*AB(1)
        theta(4186) = theta(3766)+theta(3451)*AB(1) ! ((5,0,0)|(1,1,3)) = ((6,0,0)|(0,1,3))+((5,0,0)|(0,1,3))*AB(1)
        theta(4187) = theta(3767)+theta(3452)*AB(1) ! ((5,0,0)|(1,0,4)) = ((6,0,0)|(0,0,4))+((5,0,0)|(0,0,4))*AB(1)
        theta(4188) = theta(3778)+theta(3448)*AB(2) ! ((5,0,0)|(0,5,0)) = ((5,1,0)|(0,4,0))+((5,0,0)|(0,4,0))*AB(2)
        theta(4189) = theta(3793)+theta(3448)*AB(3) ! ((5,0,0)|(0,4,1)) = ((5,0,1)|(0,4,0))+((5,0,0)|(0,4,0))*AB(3)
        theta(4190) = theta(3794)+theta(3449)*AB(3) ! ((5,0,0)|(0,3,2)) = ((5,0,1)|(0,3,1))+((5,0,0)|(0,3,1))*AB(3)
        theta(4191) = theta(3781)+theta(3451)*AB(2) ! ((5,0,0)|(0,2,3)) = ((5,1,0)|(0,1,3))+((5,0,0)|(0,1,3))*AB(2)
        theta(4192) = theta(3782)+theta(3452)*AB(2) ! ((5,0,0)|(0,1,4)) = ((5,1,0)|(0,0,4))+((5,0,0)|(0,0,4))*AB(2)
        theta(4193) = theta(3797)+theta(3452)*AB(3) ! ((5,0,0)|(0,0,5)) = ((5,0,1)|(0,0,4))+((5,0,0)|(0,0,4))*AB(3)
        theta(4194) = theta(3768)+theta(3453)*AB(1) ! ((4,1,0)|(5,0,0)) = ((5,1,0)|(4,0,0))+((4,1,0)|(4,0,0))*AB(1)
        theta(4195) = theta(3798)+theta(3453)*AB(2) ! ((4,1,0)|(4,1,0)) = ((4,2,0)|(4,0,0))+((4,1,0)|(4,0,0))*AB(2)
        theta(4196) = theta(3813)+theta(3453)*AB(3) ! ((4,1,0)|(4,0,1)) = ((4,1,1)|(4,0,0))+((4,1,0)|(4,0,0))*AB(3)
        theta(4197) = theta(3799)+theta(3454)*AB(2) ! ((4,1,0)|(3,2,0)) = ((4,2,0)|(3,1,0))+((4,1,0)|(3,1,0))*AB(2)
        theta(4198) = theta(3800)+theta(3455)*AB(2) ! ((4,1,0)|(3,1,1)) = ((4,2,0)|(3,0,1))+((4,1,0)|(3,0,1))*AB(2)
        theta(4199) = theta(3815)+theta(3455)*AB(3) ! ((4,1,0)|(3,0,2)) = ((4,1,1)|(3,0,1))+((4,1,0)|(3,0,1))*AB(3)
        theta(4200) = theta(3774)+theta(3459)*AB(1) ! ((4,1,0)|(2,3,0)) = ((5,1,0)|(1,3,0))+((4,1,0)|(1,3,0))*AB(1)
        theta(4201) = theta(3775)+theta(3460)*AB(1) ! ((4,1,0)|(2,2,1)) = ((5,1,0)|(1,2,1))+((4,1,0)|(1,2,1))*AB(1)
        theta(4202) = theta(3803)+theta(3458)*AB(2) ! ((4,1,0)|(2,1,2)) = ((4,2,0)|(2,0,2))+((4,1,0)|(2,0,2))*AB(2)
        theta(4203) = theta(3777)+theta(3462)*AB(1) ! ((4,1,0)|(2,0,3)) = ((5,1,0)|(1,0,3))+((4,1,0)|(1,0,3))*AB(1)
        theta(4204) = theta(3778)+theta(3463)*AB(1) ! ((4,1,0)|(1,4,0)) = ((5,1,0)|(0,4,0))+((4,1,0)|(0,4,0))*AB(1)
        theta(4205) = theta(3779)+theta(3464)*AB(1) ! ((4,1,0)|(1,3,1)) = ((5,1,0)|(0,3,1))+((4,1,0)|(0,3,1))*AB(1)
        theta(4206) = theta(3780)+theta(3465)*AB(1) ! ((4,1,0)|(1,2,2)) = ((5,1,0)|(0,2,2))+((4,1,0)|(0,2,2))*AB(1)
        theta(4207) = theta(3781)+theta(3466)*AB(1) ! ((4,1,0)|(1,1,3)) = ((5,1,0)|(0,1,3))+((4,1,0)|(0,1,3))*AB(1)
        theta(4208) = theta(3782)+theta(3467)*AB(1) ! ((4,1,0)|(1,0,4)) = ((5,1,0)|(0,0,4))+((4,1,0)|(0,0,4))*AB(1)
        theta(4209) = theta(3808)+theta(3463)*AB(2) ! ((4,1,0)|(0,5,0)) = ((4,2,0)|(0,4,0))+((4,1,0)|(0,4,0))*AB(2)
        theta(4210) = theta(3823)+theta(3463)*AB(3) ! ((4,1,0)|(0,4,1)) = ((4,1,1)|(0,4,0))+((4,1,0)|(0,4,0))*AB(3)
        theta(4211) = theta(3824)+theta(3464)*AB(3) ! ((4,1,0)|(0,3,2)) = ((4,1,1)|(0,3,1))+((4,1,0)|(0,3,1))*AB(3)
        theta(4212) = theta(3811)+theta(3466)*AB(2) ! ((4,1,0)|(0,2,3)) = ((4,2,0)|(0,1,3))+((4,1,0)|(0,1,3))*AB(2)
        theta(4213) = theta(3812)+theta(3467)*AB(2) ! ((4,1,0)|(0,1,4)) = ((4,2,0)|(0,0,4))+((4,1,0)|(0,0,4))*AB(2)
        theta(4214) = theta(3827)+theta(3467)*AB(3) ! ((4,1,0)|(0,0,5)) = ((4,1,1)|(0,0,4))+((4,1,0)|(0,0,4))*AB(3)
        theta(4215) = theta(3783)+theta(3468)*AB(1) ! ((4,0,1)|(5,0,0)) = ((5,0,1)|(4,0,0))+((4,0,1)|(4,0,0))*AB(1)
        theta(4216) = theta(3784)+theta(3469)*AB(1) ! ((4,0,1)|(4,1,0)) = ((5,0,1)|(3,1,0))+((4,0,1)|(3,1,0))*AB(1)
        theta(4217) = theta(3828)+theta(3468)*AB(3) ! ((4,0,1)|(4,0,1)) = ((4,0,2)|(4,0,0))+((4,0,1)|(4,0,0))*AB(3)
        theta(4218) = theta(3786)+theta(3471)*AB(1) ! ((4,0,1)|(3,2,0)) = ((5,0,1)|(2,2,0))+((4,0,1)|(2,2,0))*AB(1)
        theta(4219) = theta(3787)+theta(3472)*AB(1) ! ((4,0,1)|(3,1,1)) = ((5,0,1)|(2,1,1))+((4,0,1)|(2,1,1))*AB(1)
        theta(4220) = theta(3830)+theta(3470)*AB(3) ! ((4,0,1)|(3,0,2)) = ((4,0,2)|(3,0,1))+((4,0,1)|(3,0,1))*AB(3)
        theta(4221) = theta(3789)+theta(3474)*AB(1) ! ((4,0,1)|(2,3,0)) = ((5,0,1)|(1,3,0))+((4,0,1)|(1,3,0))*AB(1)
        theta(4222) = theta(3790)+theta(3475)*AB(1) ! ((4,0,1)|(2,2,1)) = ((5,0,1)|(1,2,1))+((4,0,1)|(1,2,1))*AB(1)
        theta(4223) = theta(3791)+theta(3476)*AB(1) ! ((4,0,1)|(2,1,2)) = ((5,0,1)|(1,1,2))+((4,0,1)|(1,1,2))*AB(1)
        theta(4224) = theta(3792)+theta(3477)*AB(1) ! ((4,0,1)|(2,0,3)) = ((5,0,1)|(1,0,3))+((4,0,1)|(1,0,3))*AB(1)
        theta(4225) = theta(3793)+theta(3478)*AB(1) ! ((4,0,1)|(1,4,0)) = ((5,0,1)|(0,4,0))+((4,0,1)|(0,4,0))*AB(1)
        theta(4226) = theta(3794)+theta(3479)*AB(1) ! ((4,0,1)|(1,3,1)) = ((5,0,1)|(0,3,1))+((4,0,1)|(0,3,1))*AB(1)
        theta(4227) = theta(3795)+theta(3480)*AB(1) ! ((4,0,1)|(1,2,2)) = ((5,0,1)|(0,2,2))+((4,0,1)|(0,2,2))*AB(1)
        theta(4228) = theta(3796)+theta(3481)*AB(1) ! ((4,0,1)|(1,1,3)) = ((5,0,1)|(0,1,3))+((4,0,1)|(0,1,3))*AB(1)
        theta(4229) = theta(3797)+theta(3482)*AB(1) ! ((4,0,1)|(1,0,4)) = ((5,0,1)|(0,0,4))+((4,0,1)|(0,0,4))*AB(1)
        theta(4230) = theta(3823)+theta(3478)*AB(2) ! ((4,0,1)|(0,5,0)) = ((4,1,1)|(0,4,0))+((4,0,1)|(0,4,0))*AB(2)
        theta(4231) = theta(3838)+theta(3478)*AB(3) ! ((4,0,1)|(0,4,1)) = ((4,0,2)|(0,4,0))+((4,0,1)|(0,4,0))*AB(3)
        theta(4232) = theta(3839)+theta(3479)*AB(3) ! ((4,0,1)|(0,3,2)) = ((4,0,2)|(0,3,1))+((4,0,1)|(0,3,1))*AB(3)
        theta(4233) = theta(3826)+theta(3481)*AB(2) ! ((4,0,1)|(0,2,3)) = ((4,1,1)|(0,1,3))+((4,0,1)|(0,1,3))*AB(2)
        theta(4234) = theta(3827)+theta(3482)*AB(2) ! ((4,0,1)|(0,1,4)) = ((4,1,1)|(0,0,4))+((4,0,1)|(0,0,4))*AB(2)
        theta(4235) = theta(3842)+theta(3482)*AB(3) ! ((4,0,1)|(0,0,5)) = ((4,0,2)|(0,0,4))+((4,0,1)|(0,0,4))*AB(3)
        theta(4236) = theta(3798)+theta(3483)*AB(1) ! ((3,2,0)|(5,0,0)) = ((4,2,0)|(4,0,0))+((3,2,0)|(4,0,0))*AB(1)
        theta(4237) = theta(3843)+theta(3483)*AB(2) ! ((3,2,0)|(4,1,0)) = ((3,3,0)|(4,0,0))+((3,2,0)|(4,0,0))*AB(2)
        theta(4238) = theta(3858)+theta(3483)*AB(3) ! ((3,2,0)|(4,0,1)) = ((3,2,1)|(4,0,0))+((3,2,0)|(4,0,0))*AB(3)
        theta(4239) = theta(3844)+theta(3484)*AB(2) ! ((3,2,0)|(3,2,0)) = ((3,3,0)|(3,1,0))+((3,2,0)|(3,1,0))*AB(2)
        theta(4240) = theta(3845)+theta(3485)*AB(2) ! ((3,2,0)|(3,1,1)) = ((3,3,0)|(3,0,1))+((3,2,0)|(3,0,1))*AB(2)
        theta(4241) = theta(3860)+theta(3485)*AB(3) ! ((3,2,0)|(3,0,2)) = ((3,2,1)|(3,0,1))+((3,2,0)|(3,0,1))*AB(3)
        theta(4242) = theta(3804)+theta(3489)*AB(1) ! ((3,2,0)|(2,3,0)) = ((4,2,0)|(1,3,0))+((3,2,0)|(1,3,0))*AB(1)
        theta(4243) = theta(3805)+theta(3490)*AB(1) ! ((3,2,0)|(2,2,1)) = ((4,2,0)|(1,2,1))+((3,2,0)|(1,2,1))*AB(1)
        theta(4244) = theta(3848)+theta(3488)*AB(2) ! ((3,2,0)|(2,1,2)) = ((3,3,0)|(2,0,2))+((3,2,0)|(2,0,2))*AB(2)
        theta(4245) = theta(3807)+theta(3492)*AB(1) ! ((3,2,0)|(2,0,3)) = ((4,2,0)|(1,0,3))+((3,2,0)|(1,0,3))*AB(1)
        theta(4246) = theta(3808)+theta(3493)*AB(1) ! ((3,2,0)|(1,4,0)) = ((4,2,0)|(0,4,0))+((3,2,0)|(0,4,0))*AB(1)
        theta(4247) = theta(3809)+theta(3494)*AB(1) ! ((3,2,0)|(1,3,1)) = ((4,2,0)|(0,3,1))+((3,2,0)|(0,3,1))*AB(1)
        theta(4248) = theta(3810)+theta(3495)*AB(1) ! ((3,2,0)|(1,2,2)) = ((4,2,0)|(0,2,2))+((3,2,0)|(0,2,2))*AB(1)
        theta(4249) = theta(3811)+theta(3496)*AB(1) ! ((3,2,0)|(1,1,3)) = ((4,2,0)|(0,1,3))+((3,2,0)|(0,1,3))*AB(1)
        theta(4250) = theta(3812)+theta(3497)*AB(1) ! ((3,2,0)|(1,0,4)) = ((4,2,0)|(0,0,4))+((3,2,0)|(0,0,4))*AB(1)
        theta(4251) = theta(3853)+theta(3493)*AB(2) ! ((3,2,0)|(0,5,0)) = ((3,3,0)|(0,4,0))+((3,2,0)|(0,4,0))*AB(2)
        theta(4252) = theta(3868)+theta(3493)*AB(3) ! ((3,2,0)|(0,4,1)) = ((3,2,1)|(0,4,0))+((3,2,0)|(0,4,0))*AB(3)
        theta(4253) = theta(3869)+theta(3494)*AB(3) ! ((3,2,0)|(0,3,2)) = ((3,2,1)|(0,3,1))+((3,2,0)|(0,3,1))*AB(3)
        theta(4254) = theta(3856)+theta(3496)*AB(2) ! ((3,2,0)|(0,2,3)) = ((3,3,0)|(0,1,3))+((3,2,0)|(0,1,3))*AB(2)
        theta(4255) = theta(3857)+theta(3497)*AB(2) ! ((3,2,0)|(0,1,4)) = ((3,3,0)|(0,0,4))+((3,2,0)|(0,0,4))*AB(2)
        theta(4256) = theta(3872)+theta(3497)*AB(3) ! ((3,2,0)|(0,0,5)) = ((3,2,1)|(0,0,4))+((3,2,0)|(0,0,4))*AB(3)
        theta(4257) = theta(3813)+theta(3498)*AB(1) ! ((3,1,1)|(5,0,0)) = ((4,1,1)|(4,0,0))+((3,1,1)|(4,0,0))*AB(1)
        theta(4258) = theta(3814)+theta(3499)*AB(1) ! ((3,1,1)|(4,1,0)) = ((4,1,1)|(3,1,0))+((3,1,1)|(3,1,0))*AB(1)
        theta(4259) = theta(3873)+theta(3498)*AB(3) ! ((3,1,1)|(4,0,1)) = ((3,1,2)|(4,0,0))+((3,1,1)|(4,0,0))*AB(3)
        theta(4260) = theta(3816)+theta(3501)*AB(1) ! ((3,1,1)|(3,2,0)) = ((4,1,1)|(2,2,0))+((3,1,1)|(2,2,0))*AB(1)
        theta(4261) = theta(3817)+theta(3502)*AB(1) ! ((3,1,1)|(3,1,1)) = ((4,1,1)|(2,1,1))+((3,1,1)|(2,1,1))*AB(1)
        theta(4262) = theta(3875)+theta(3500)*AB(3) ! ((3,1,1)|(3,0,2)) = ((3,1,2)|(3,0,1))+((3,1,1)|(3,0,1))*AB(3)
        theta(4263) = theta(3819)+theta(3504)*AB(1) ! ((3,1,1)|(2,3,0)) = ((4,1,1)|(1,3,0))+((3,1,1)|(1,3,0))*AB(1)
        theta(4264) = theta(3820)+theta(3505)*AB(1) ! ((3,1,1)|(2,2,1)) = ((4,1,1)|(1,2,1))+((3,1,1)|(1,2,1))*AB(1)
        theta(4265) = theta(3821)+theta(3506)*AB(1) ! ((3,1,1)|(2,1,2)) = ((4,1,1)|(1,1,2))+((3,1,1)|(1,1,2))*AB(1)
        theta(4266) = theta(3822)+theta(3507)*AB(1) ! ((3,1,1)|(2,0,3)) = ((4,1,1)|(1,0,3))+((3,1,1)|(1,0,3))*AB(1)
        theta(4267) = theta(3823)+theta(3508)*AB(1) ! ((3,1,1)|(1,4,0)) = ((4,1,1)|(0,4,0))+((3,1,1)|(0,4,0))*AB(1)
        theta(4268) = theta(3824)+theta(3509)*AB(1) ! ((3,1,1)|(1,3,1)) = ((4,1,1)|(0,3,1))+((3,1,1)|(0,3,1))*AB(1)
        theta(4269) = theta(3825)+theta(3510)*AB(1) ! ((3,1,1)|(1,2,2)) = ((4,1,1)|(0,2,2))+((3,1,1)|(0,2,2))*AB(1)
        theta(4270) = theta(3826)+theta(3511)*AB(1) ! ((3,1,1)|(1,1,3)) = ((4,1,1)|(0,1,3))+((3,1,1)|(0,1,3))*AB(1)
        theta(4271) = theta(3827)+theta(3512)*AB(1) ! ((3,1,1)|(1,0,4)) = ((4,1,1)|(0,0,4))+((3,1,1)|(0,0,4))*AB(1)
        theta(4272) = theta(3868)+theta(3508)*AB(2) ! ((3,1,1)|(0,5,0)) = ((3,2,1)|(0,4,0))+((3,1,1)|(0,4,0))*AB(2)
        theta(4273) = theta(3883)+theta(3508)*AB(3) ! ((3,1,1)|(0,4,1)) = ((3,1,2)|(0,4,0))+((3,1,1)|(0,4,0))*AB(3)
        theta(4274) = theta(3884)+theta(3509)*AB(3) ! ((3,1,1)|(0,3,2)) = ((3,1,2)|(0,3,1))+((3,1,1)|(0,3,1))*AB(3)
        theta(4275) = theta(3871)+theta(3511)*AB(2) ! ((3,1,1)|(0,2,3)) = ((3,2,1)|(0,1,3))+((3,1,1)|(0,1,3))*AB(2)
        theta(4276) = theta(3872)+theta(3512)*AB(2) ! ((3,1,1)|(0,1,4)) = ((3,2,1)|(0,0,4))+((3,1,1)|(0,0,4))*AB(2)
        theta(4277) = theta(3887)+theta(3512)*AB(3) ! ((3,1,1)|(0,0,5)) = ((3,1,2)|(0,0,4))+((3,1,1)|(0,0,4))*AB(3)
        theta(4278) = theta(3828)+theta(3513)*AB(1) ! ((3,0,2)|(5,0,0)) = ((4,0,2)|(4,0,0))+((3,0,2)|(4,0,0))*AB(1)
        theta(4279) = theta(3829)+theta(3514)*AB(1) ! ((3,0,2)|(4,1,0)) = ((4,0,2)|(3,1,0))+((3,0,2)|(3,1,0))*AB(1)
        theta(4280) = theta(3888)+theta(3513)*AB(3) ! ((3,0,2)|(4,0,1)) = ((3,0,3)|(4,0,0))+((3,0,2)|(4,0,0))*AB(3)
        theta(4281) = theta(3831)+theta(3516)*AB(1) ! ((3,0,2)|(3,2,0)) = ((4,0,2)|(2,2,0))+((3,0,2)|(2,2,0))*AB(1)
        theta(4282) = theta(3832)+theta(3517)*AB(1) ! ((3,0,2)|(3,1,1)) = ((4,0,2)|(2,1,1))+((3,0,2)|(2,1,1))*AB(1)
        theta(4283) = theta(3890)+theta(3515)*AB(3) ! ((3,0,2)|(3,0,2)) = ((3,0,3)|(3,0,1))+((3,0,2)|(3,0,1))*AB(3)
        theta(4284) = theta(3834)+theta(3519)*AB(1) ! ((3,0,2)|(2,3,0)) = ((4,0,2)|(1,3,0))+((3,0,2)|(1,3,0))*AB(1)
        theta(4285) = theta(3835)+theta(3520)*AB(1) ! ((3,0,2)|(2,2,1)) = ((4,0,2)|(1,2,1))+((3,0,2)|(1,2,1))*AB(1)
        theta(4286) = theta(3836)+theta(3521)*AB(1) ! ((3,0,2)|(2,1,2)) = ((4,0,2)|(1,1,2))+((3,0,2)|(1,1,2))*AB(1)
        theta(4287) = theta(3837)+theta(3522)*AB(1) ! ((3,0,2)|(2,0,3)) = ((4,0,2)|(1,0,3))+((3,0,2)|(1,0,3))*AB(1)
        theta(4288) = theta(3838)+theta(3523)*AB(1) ! ((3,0,2)|(1,4,0)) = ((4,0,2)|(0,4,0))+((3,0,2)|(0,4,0))*AB(1)
        theta(4289) = theta(3839)+theta(3524)*AB(1) ! ((3,0,2)|(1,3,1)) = ((4,0,2)|(0,3,1))+((3,0,2)|(0,3,1))*AB(1)
        theta(4290) = theta(3840)+theta(3525)*AB(1) ! ((3,0,2)|(1,2,2)) = ((4,0,2)|(0,2,2))+((3,0,2)|(0,2,2))*AB(1)
        theta(4291) = theta(3841)+theta(3526)*AB(1) ! ((3,0,2)|(1,1,3)) = ((4,0,2)|(0,1,3))+((3,0,2)|(0,1,3))*AB(1)
        theta(4292) = theta(3842)+theta(3527)*AB(1) ! ((3,0,2)|(1,0,4)) = ((4,0,2)|(0,0,4))+((3,0,2)|(0,0,4))*AB(1)
        theta(4293) = theta(3883)+theta(3523)*AB(2) ! ((3,0,2)|(0,5,0)) = ((3,1,2)|(0,4,0))+((3,0,2)|(0,4,0))*AB(2)
        theta(4294) = theta(3898)+theta(3523)*AB(3) ! ((3,0,2)|(0,4,1)) = ((3,0,3)|(0,4,0))+((3,0,2)|(0,4,0))*AB(3)
        theta(4295) = theta(3899)+theta(3524)*AB(3) ! ((3,0,2)|(0,3,2)) = ((3,0,3)|(0,3,1))+((3,0,2)|(0,3,1))*AB(3)
        theta(4296) = theta(3886)+theta(3526)*AB(2) ! ((3,0,2)|(0,2,3)) = ((3,1,2)|(0,1,3))+((3,0,2)|(0,1,3))*AB(2)
        theta(4297) = theta(3887)+theta(3527)*AB(2) ! ((3,0,2)|(0,1,4)) = ((3,1,2)|(0,0,4))+((3,0,2)|(0,0,4))*AB(2)
        theta(4298) = theta(3902)+theta(3527)*AB(3) ! ((3,0,2)|(0,0,5)) = ((3,0,3)|(0,0,4))+((3,0,2)|(0,0,4))*AB(3)
        theta(4299) = theta(3843)+theta(3528)*AB(1) ! ((2,3,0)|(5,0,0)) = ((3,3,0)|(4,0,0))+((2,3,0)|(4,0,0))*AB(1)
        theta(4300) = theta(3903)+theta(3528)*AB(2) ! ((2,3,0)|(4,1,0)) = ((2,4,0)|(4,0,0))+((2,3,0)|(4,0,0))*AB(2)
        theta(4301) = theta(3918)+theta(3528)*AB(3) ! ((2,3,0)|(4,0,1)) = ((2,3,1)|(4,0,0))+((2,3,0)|(4,0,0))*AB(3)
        theta(4302) = theta(3904)+theta(3529)*AB(2) ! ((2,3,0)|(3,2,0)) = ((2,4,0)|(3,1,0))+((2,3,0)|(3,1,0))*AB(2)
        theta(4303) = theta(3905)+theta(3530)*AB(2) ! ((2,3,0)|(3,1,1)) = ((2,4,0)|(3,0,1))+((2,3,0)|(3,0,1))*AB(2)
        theta(4304) = theta(3920)+theta(3530)*AB(3) ! ((2,3,0)|(3,0,2)) = ((2,3,1)|(3,0,1))+((2,3,0)|(3,0,1))*AB(3)
        theta(4305) = theta(3849)+theta(3534)*AB(1) ! ((2,3,0)|(2,3,0)) = ((3,3,0)|(1,3,0))+((2,3,0)|(1,3,0))*AB(1)
        theta(4306) = theta(3850)+theta(3535)*AB(1) ! ((2,3,0)|(2,2,1)) = ((3,3,0)|(1,2,1))+((2,3,0)|(1,2,1))*AB(1)
        theta(4307) = theta(3908)+theta(3533)*AB(2) ! ((2,3,0)|(2,1,2)) = ((2,4,0)|(2,0,2))+((2,3,0)|(2,0,2))*AB(2)
        theta(4308) = theta(3852)+theta(3537)*AB(1) ! ((2,3,0)|(2,0,3)) = ((3,3,0)|(1,0,3))+((2,3,0)|(1,0,3))*AB(1)
        theta(4309) = theta(3853)+theta(3538)*AB(1) ! ((2,3,0)|(1,4,0)) = ((3,3,0)|(0,4,0))+((2,3,0)|(0,4,0))*AB(1)
        theta(4310) = theta(3854)+theta(3539)*AB(1) ! ((2,3,0)|(1,3,1)) = ((3,3,0)|(0,3,1))+((2,3,0)|(0,3,1))*AB(1)
        theta(4311) = theta(3855)+theta(3540)*AB(1) ! ((2,3,0)|(1,2,2)) = ((3,3,0)|(0,2,2))+((2,3,0)|(0,2,2))*AB(1)
        theta(4312) = theta(3856)+theta(3541)*AB(1) ! ((2,3,0)|(1,1,3)) = ((3,3,0)|(0,1,3))+((2,3,0)|(0,1,3))*AB(1)
        theta(4313) = theta(3857)+theta(3542)*AB(1) ! ((2,3,0)|(1,0,4)) = ((3,3,0)|(0,0,4))+((2,3,0)|(0,0,4))*AB(1)
        theta(4314) = theta(3913)+theta(3538)*AB(2) ! ((2,3,0)|(0,5,0)) = ((2,4,0)|(0,4,0))+((2,3,0)|(0,4,0))*AB(2)
        theta(4315) = theta(3928)+theta(3538)*AB(3) ! ((2,3,0)|(0,4,1)) = ((2,3,1)|(0,4,0))+((2,3,0)|(0,4,0))*AB(3)
        theta(4316) = theta(3929)+theta(3539)*AB(3) ! ((2,3,0)|(0,3,2)) = ((2,3,1)|(0,3,1))+((2,3,0)|(0,3,1))*AB(3)
        theta(4317) = theta(3916)+theta(3541)*AB(2) ! ((2,3,0)|(0,2,3)) = ((2,4,0)|(0,1,3))+((2,3,0)|(0,1,3))*AB(2)
        theta(4318) = theta(3917)+theta(3542)*AB(2) ! ((2,3,0)|(0,1,4)) = ((2,4,0)|(0,0,4))+((2,3,0)|(0,0,4))*AB(2)
        theta(4319) = theta(3932)+theta(3542)*AB(3) ! ((2,3,0)|(0,0,5)) = ((2,3,1)|(0,0,4))+((2,3,0)|(0,0,4))*AB(3)
        theta(4320) = theta(3858)+theta(3543)*AB(1) ! ((2,2,1)|(5,0,0)) = ((3,2,1)|(4,0,0))+((2,2,1)|(4,0,0))*AB(1)
        theta(4321) = theta(3859)+theta(3544)*AB(1) ! ((2,2,1)|(4,1,0)) = ((3,2,1)|(3,1,0))+((2,2,1)|(3,1,0))*AB(1)
        theta(4322) = theta(3933)+theta(3543)*AB(3) ! ((2,2,1)|(4,0,1)) = ((2,2,2)|(4,0,0))+((2,2,1)|(4,0,0))*AB(3)
        theta(4323) = theta(3861)+theta(3546)*AB(1) ! ((2,2,1)|(3,2,0)) = ((3,2,1)|(2,2,0))+((2,2,1)|(2,2,0))*AB(1)
        theta(4324) = theta(3862)+theta(3547)*AB(1) ! ((2,2,1)|(3,1,1)) = ((3,2,1)|(2,1,1))+((2,2,1)|(2,1,1))*AB(1)
        theta(4325) = theta(3935)+theta(3545)*AB(3) ! ((2,2,1)|(3,0,2)) = ((2,2,2)|(3,0,1))+((2,2,1)|(3,0,1))*AB(3)
        theta(4326) = theta(3864)+theta(3549)*AB(1) ! ((2,2,1)|(2,3,0)) = ((3,2,1)|(1,3,0))+((2,2,1)|(1,3,0))*AB(1)
        theta(4327) = theta(3865)+theta(3550)*AB(1) ! ((2,2,1)|(2,2,1)) = ((3,2,1)|(1,2,1))+((2,2,1)|(1,2,1))*AB(1)
        theta(4328) = theta(3866)+theta(3551)*AB(1) ! ((2,2,1)|(2,1,2)) = ((3,2,1)|(1,1,2))+((2,2,1)|(1,1,2))*AB(1)
        theta(4329) = theta(3867)+theta(3552)*AB(1) ! ((2,2,1)|(2,0,3)) = ((3,2,1)|(1,0,3))+((2,2,1)|(1,0,3))*AB(1)
        theta(4330) = theta(3868)+theta(3553)*AB(1) ! ((2,2,1)|(1,4,0)) = ((3,2,1)|(0,4,0))+((2,2,1)|(0,4,0))*AB(1)
        theta(4331) = theta(3869)+theta(3554)*AB(1) ! ((2,2,1)|(1,3,1)) = ((3,2,1)|(0,3,1))+((2,2,1)|(0,3,1))*AB(1)
        theta(4332) = theta(3870)+theta(3555)*AB(1) ! ((2,2,1)|(1,2,2)) = ((3,2,1)|(0,2,2))+((2,2,1)|(0,2,2))*AB(1)
        theta(4333) = theta(3871)+theta(3556)*AB(1) ! ((2,2,1)|(1,1,3)) = ((3,2,1)|(0,1,3))+((2,2,1)|(0,1,3))*AB(1)
        theta(4334) = theta(3872)+theta(3557)*AB(1) ! ((2,2,1)|(1,0,4)) = ((3,2,1)|(0,0,4))+((2,2,1)|(0,0,4))*AB(1)
        theta(4335) = theta(3928)+theta(3553)*AB(2) ! ((2,2,1)|(0,5,0)) = ((2,3,1)|(0,4,0))+((2,2,1)|(0,4,0))*AB(2)
        theta(4336) = theta(3943)+theta(3553)*AB(3) ! ((2,2,1)|(0,4,1)) = ((2,2,2)|(0,4,0))+((2,2,1)|(0,4,0))*AB(3)
        theta(4337) = theta(3944)+theta(3554)*AB(3) ! ((2,2,1)|(0,3,2)) = ((2,2,2)|(0,3,1))+((2,2,1)|(0,3,1))*AB(3)
        theta(4338) = theta(3931)+theta(3556)*AB(2) ! ((2,2,1)|(0,2,3)) = ((2,3,1)|(0,1,3))+((2,2,1)|(0,1,3))*AB(2)
        theta(4339) = theta(3932)+theta(3557)*AB(2) ! ((2,2,1)|(0,1,4)) = ((2,3,1)|(0,0,4))+((2,2,1)|(0,0,4))*AB(2)
        theta(4340) = theta(3947)+theta(3557)*AB(3) ! ((2,2,1)|(0,0,5)) = ((2,2,2)|(0,0,4))+((2,2,1)|(0,0,4))*AB(3)
        theta(4341) = theta(3873)+theta(3558)*AB(1) ! ((2,1,2)|(5,0,0)) = ((3,1,2)|(4,0,0))+((2,1,2)|(4,0,0))*AB(1)
        theta(4342) = theta(3874)+theta(3559)*AB(1) ! ((2,1,2)|(4,1,0)) = ((3,1,2)|(3,1,0))+((2,1,2)|(3,1,0))*AB(1)
        theta(4343) = theta(3948)+theta(3558)*AB(3) ! ((2,1,2)|(4,0,1)) = ((2,1,3)|(4,0,0))+((2,1,2)|(4,0,0))*AB(3)
        theta(4344) = theta(3876)+theta(3561)*AB(1) ! ((2,1,2)|(3,2,0)) = ((3,1,2)|(2,2,0))+((2,1,2)|(2,2,0))*AB(1)
        theta(4345) = theta(3877)+theta(3562)*AB(1) ! ((2,1,2)|(3,1,1)) = ((3,1,2)|(2,1,1))+((2,1,2)|(2,1,1))*AB(1)
        theta(4346) = theta(3950)+theta(3560)*AB(3) ! ((2,1,2)|(3,0,2)) = ((2,1,3)|(3,0,1))+((2,1,2)|(3,0,1))*AB(3)
        theta(4347) = theta(3879)+theta(3564)*AB(1) ! ((2,1,2)|(2,3,0)) = ((3,1,2)|(1,3,0))+((2,1,2)|(1,3,0))*AB(1)
        theta(4348) = theta(3880)+theta(3565)*AB(1) ! ((2,1,2)|(2,2,1)) = ((3,1,2)|(1,2,1))+((2,1,2)|(1,2,1))*AB(1)
        theta(4349) = theta(3881)+theta(3566)*AB(1) ! ((2,1,2)|(2,1,2)) = ((3,1,2)|(1,1,2))+((2,1,2)|(1,1,2))*AB(1)
        theta(4350) = theta(3882)+theta(3567)*AB(1) ! ((2,1,2)|(2,0,3)) = ((3,1,2)|(1,0,3))+((2,1,2)|(1,0,3))*AB(1)
        theta(4351) = theta(3883)+theta(3568)*AB(1) ! ((2,1,2)|(1,4,0)) = ((3,1,2)|(0,4,0))+((2,1,2)|(0,4,0))*AB(1)
        theta(4352) = theta(3884)+theta(3569)*AB(1) ! ((2,1,2)|(1,3,1)) = ((3,1,2)|(0,3,1))+((2,1,2)|(0,3,1))*AB(1)
        theta(4353) = theta(3885)+theta(3570)*AB(1) ! ((2,1,2)|(1,2,2)) = ((3,1,2)|(0,2,2))+((2,1,2)|(0,2,2))*AB(1)
        theta(4354) = theta(3886)+theta(3571)*AB(1) ! ((2,1,2)|(1,1,3)) = ((3,1,2)|(0,1,3))+((2,1,2)|(0,1,3))*AB(1)
        theta(4355) = theta(3887)+theta(3572)*AB(1) ! ((2,1,2)|(1,0,4)) = ((3,1,2)|(0,0