!!------ Given element index, return spherically averaged atomic density in radial
!The values are generated by sphatmraddens subroutine (main function 98, which is hidden in the main menu)
!H-Lr are available. <=18 were calculated at B3LYP/cc-pVQZ; transition metals at HF/UGBS
!!Lanthanides and Actinides at B3LYP/SARC-DKH; except for U and Np, for which ROHF/SARC-DKH was used because DFT cannot reproduce their correct ground state configurations
!Other >18 main group elements were calculated by B3LYP/ANO-RCC (except for Ca, UGBS is used since the ANO-RCC of Ca in EMSL is wrong)
!DKH2 was used for all elements >18
!All elements were calculated in their ground states
!
!Beware that the densities are truncated at 1D-8. This criterion cannot be further tighten, e.g. 1D-100, because if the value is very small, Lagrangian interpolation gives frantic result!
!Currently the largest distance actually used is atmradpos(171)= 17.53 Bohr = 9.28 Angstrom
!Largest distance of each element in this library is given in "atmrhocut" array in define.f90, obtained by following code:
!do iele=1,103
!	call genatmraddens(iele,rhoarr,npt)
!	write(*,"(i5,f12.2)") iele,atmradpos(npt)
!end do
    
!  The code used to generate global variable "atmradcut_1En5":
!subroutine determine_atmradcut_1En5
!use defvar
!use functions
!implicit real*8 (a-h,o-z)
!character c1000tmp*1000
!do iele=1,103
!    r=0
!    do while(.true.)
!        r=r+0.001D0
!        if (eleraddens(iele,r,0)<1E-5) then
!            !write(*,*) iele,r*b2a,atmrhocut(iele)*b2a
!            write(*,"(f6.3,'D0,')",advance="no") r
!            exit
!        end if
!    end do
!end do
!end subroutine
    
!----- Generate radial position array (shared by all elements) using Becke transform
subroutine genatmradpos(posarr)
real*8 posarr(200)
! itmp=0
! do irad=nptupper,1,-1
! 	itmp=itmp+1
! 	radx=cos(irad*pi/(nptupper+1))
! 	posarr(itmp)=(1+radx)/(1-radx)
! 	write(10,"('posarr(',i3,')=',D20.10)") itmp,posarr(itmp)
! end do
!Below array was generated by above code
posarr(  1)=    0.6107525963D-04
posarr(  2)=    0.2443308828D-03
posarr(  3)=    0.5498564331D-03
posarr(  4)=    0.9778012868D-03
posarr(  5)=    0.1528374788D-02
posarr(  6)=    0.2201846466D-02
posarr(  7)=    0.2998546315D-02
posarr(  8)=    0.3918865143D-02
posarr(  9)=    0.4963254972D-02
posarr( 10)=    0.6132229517D-02
posarr( 11)=    0.7426364720D-02
posarr( 12)=    0.8846299360D-02
posarr( 13)=    0.1039273572D-01
posarr( 14)=    0.1206644033D-01
posarr( 15)=    0.1386824478D-01
posarr( 16)=    0.1579904660D-01
posarr( 17)=    0.1785981023D-01
posarr( 18)=    0.2005156803D-01
posarr( 19)=    0.2237542139D-01
posarr( 20)=    0.2483254195D-01
posarr( 21)=    0.2742417283D-01
posarr( 22)=    0.3015162999D-01
posarr( 23)=    0.3301630371D-01
posarr( 24)=    0.3601966004D-01
posarr( 25)=    0.3916324250D-01
posarr( 26)=    0.4244867374D-01
posarr( 27)=    0.4587765737D-01
posarr( 28)=    0.4945197989D-01
posarr( 29)=    0.5317351268D-01
posarr( 30)=    0.5704421416D-01
posarr( 31)=    0.6106613201D-01
posarr( 32)=    0.6524140553D-01
posarr( 33)=    0.6957226817D-01
posarr( 34)=    0.7406105007D-01
posarr( 35)=    0.7871018088D-01
posarr( 36)=    0.8352219259D-01
posarr( 37)=    0.8849972259D-01
posarr( 38)=    0.9364551686D-01
posarr( 39)=    0.9896243328D-01
posarr( 40)=    0.1044534452D+00
posarr( 41)=    0.1101216450D+00
posarr( 42)=    0.1159702481D+00
posarr( 43)=    0.1220025969D+00
posarr( 44)=    0.1282221651D+00
posarr( 45)=    0.1346325622D+00
posarr( 46)=    0.1412375380D+00
posarr( 47)=    0.1480409878D+00
posarr( 48)=    0.1550469571D+00
posarr( 49)=    0.1622596477D+00
posarr( 50)=    0.1696834225D+00
posarr( 51)=    0.1773228122D+00
posarr( 52)=    0.1851825213D+00
posarr( 53)=    0.1932674344D+00
posarr( 54)=    0.2015826236D+00
posarr( 55)=    0.2101333552D+00
posarr( 56)=    0.2189250977D+00
posarr( 57)=    0.2279635294D+00
posarr( 58)=    0.2372545472D+00
posarr( 59)=    0.2468042753D+00
posarr( 60)=    0.2566190741D+00
posarr( 61)=    0.2667055505D+00
posarr( 62)=    0.2770705675D+00
posarr( 63)=    0.2877212557D+00
posarr( 64)=    0.2986650240D+00
posarr( 65)=    0.3099095719D+00
posarr( 66)=    0.3214629021D+00
posarr( 67)=    0.3333333333D+00
posarr( 68)=    0.3455295148D+00
posarr( 69)=    0.3580604404D+00
posarr( 70)=    0.3709354649D+00
posarr( 71)=    0.3841643193D+00
posarr( 72)=    0.3977571289D+00
posarr( 73)=    0.4117244313D+00
posarr( 74)=    0.4260771954D+00
posarr( 75)=    0.4408268416D+00
posarr( 76)=    0.4559852639D+00
posarr( 77)=    0.4715648518D+00
posarr( 78)=    0.4875785145D+00
posarr( 79)=    0.5040397067D+00
posarr( 80)=    0.5209624546D+00
posarr( 81)=    0.5383613852D+00
posarr( 82)=    0.5562517557D+00
posarr( 83)=    0.5746494858D+00
posarr( 84)=    0.5935711914D+00
posarr( 85)=    0.6130342205D+00
posarr( 86)=    0.6330566911D+00
posarr( 87)=    0.6536575320D+00
posarr( 88)=    0.6748565255D+00
posarr( 89)=    0.6966743530D+00
posarr( 90)=    0.7191326440D+00
posarr( 91)=    0.7422540271D+00
posarr( 92)=    0.7660621855D+00
posarr( 93)=    0.7905819155D+00
posarr( 94)=    0.8158391890D+00
posarr( 95)=    0.8418612197D+00
posarr( 96)=    0.8686765348D+00
posarr( 97)=    0.8963150504D+00
posarr( 98)=    0.9248081530D+00
posarr( 99)=    0.9541887856D+00
posarr(100)=    0.9844915408D+00
posarr(101)=    0.1015752760D+01
posarr(102)=    0.1048010640D+01
posarr(103)=    0.1081305346D+01
posarr(104)=    0.1115679135D+01
posarr(105)=    0.1151176485D+01
posarr(106)=    0.1187844239D+01
posarr(107)=    0.1225731754D+01
posarr(108)=    0.1264891064D+01
posarr(109)=    0.1305377055D+01
posarr(110)=    0.1347247658D+01
posarr(111)=    0.1390564047D+01
posarr(112)=    0.1435390862D+01
posarr(113)=    0.1481796445D+01
posarr(114)=    0.1529853098D+01
posarr(115)=    0.1579637360D+01
posarr(116)=    0.1631230308D+01
posarr(117)=    0.1684717881D+01
posarr(118)=    0.1740191238D+01
posarr(119)=    0.1797747135D+01
posarr(120)=    0.1857488348D+01
posarr(121)=    0.1919524125D+01
posarr(122)=    0.1983970681D+01
posarr(123)=    0.2050951734D+01
posarr(124)=    0.2120599099D+01
posarr(125)=    0.2193053327D+01
posarr(126)=    0.2268464407D+01
posarr(127)=    0.2346992542D+01
posarr(128)=    0.2428808990D+01
posarr(129)=    0.2514096989D+01
posarr(130)=    0.2603052782D+01
posarr(131)=    0.2695886737D+01
posarr(132)=    0.2792824582D+01
posarr(133)=    0.2894108773D+01
posarr(134)=    0.3000000000D+01
posarr(135)=    0.3110778860D+01
posarr(136)=    0.3226747705D+01
posarr(137)=    0.3348232701D+01
posarr(138)=    0.3475586111D+01
posarr(139)=    0.3609188840D+01
posarr(140)=    0.3749453276D+01
posarr(141)=    0.3896826467D+01
posarr(142)=    0.4051793668D+01
posarr(143)=    0.4214882335D+01
posarr(144)=    0.4386666599D+01
posarr(145)=    0.4567772315D+01
posarr(146)=    0.4758882753D+01
posarr(147)=    0.4960745039D+01
posarr(148)=    0.5174177444D+01
posarr(149)=    0.5400077680D+01
posarr(150)=    0.5639432330D+01
posarr(151)=    0.5893327618D+01
posarr(152)=    0.6162961737D+01
posarr(153)=    0.6449658983D+01
posarr(154)=    0.6754886028D+01
posarr(155)=    0.7080270684D+01
posarr(156)=    0.7427623627D+01
posarr(157)=    0.7798963613D+01
posarr(158)=    0.8196546842D+01
posarr(159)=    0.8622901277D+01
posarr(160)=    0.9080866894D+01
posarr(161)=    0.9573643056D+01
posarr(162)=    0.1010484450D+02
posarr(163)=    0.1067856779D+02
posarr(164)=    0.1129947045D+02
posarr(165)=    0.1197286576D+02
posarr(166)=    0.1270483677D+02
posarr(167)=    0.1350237404D+02
posarr(168)=    0.1437354317D+02
posarr(169)=    0.1532768940D+02
posarr(170)=    0.1637568923D+02
posarr(171)=    0.1753026165D+02
posarr(172)=    0.1880635583D+02
posarr(173)=    0.2022163728D+02
posarr(174)=    0.2179710250D+02
posarr(175)=    0.2355786205D+02
posarr(176)=    0.2553414723D+02
posarr(177)=    0.2776261627D+02
posarr(178)=    0.3028806643D+02
posarr(179)=    0.3316570282D+02
posarr(180)=    0.3646418093D+02
posarr(181)=    0.4026973968D+02
posarr(182)=    0.4469189574D+02
posarr(183)=    0.4987141148D+02
posarr(184)=    0.5599163636D+02
posarr(185)=    0.6329495855D+02
posarr(186)=    0.7210717837D+02
posarr(187)=    0.8287448267D+02
posarr(188)=    0.9622105546D+02
posarr(189)=    0.1130416188D+03
posarr(190)=    0.1346553849D+03
posarr(191)=    0.1630728265D+03
posarr(192)=    0.2014806827D+03
posarr(193)=    0.2551759153D+03
posarr(194)=    0.3334949321D+03
posarr(195)=    0.4541642733D+03
posarr(196)=    0.6542897776D+03
posarr(197)=    0.1022702684D+04
posarr(198)=    0.1818656543D+04
posarr(199)=    0.4092810490D+04
posarr(200)=    0.1637324190D+05
end subroutine


!----- Fill rhoarr by atomic radial density of specific element
!iele: element index
!rhoarr: Returned array containing radial densities
!npt: Returned actual number of points for which density is available
subroutine genatmraddens(iele,rhoarr,npt)
implicit real*8 (a-h,o-z)
integer iele,npt
real*8 rhoarr(200)

rhoarr=0

if (iele== 1) then  !H, 0 2, b3lyp/cc-pVQZ
	npt=  157
	rhoarr(  1)=        0.30987459D0
	rhoarr(  2)=        0.30987429D0
	rhoarr(  3)=        0.30987297D0
	rhoarr(  4)=        0.30986941D0
	rhoarr(  5)=        0.30986191D0
	rhoarr(  6)=        0.30984826D0
	rhoarr(  7)=        0.30982574D0
	rhoarr(  8)=        0.30979115D0
	rhoarr(  9)=        0.30974078D0
	rhoarr( 10)=        0.30967040D0
	rhoarr( 11)=        0.30957529D0
	rhoarr( 12)=        0.30945023D0
	rhoarr( 13)=        0.30928949D0
	rhoarr( 14)=        0.30908688D0
	rhoarr( 15)=        0.30883573D0
	rhoarr( 16)=        0.30852898D0
	rhoarr( 17)=        0.30815915D0
	rhoarr( 18)=        0.30771843D0
	rhoarr( 19)=        0.30719875D0
	rhoarr( 20)=        0.30659182D0
	rhoarr( 21)=        0.30588927D0
	rhoarr( 22)=        0.30508272D0
	rhoarr( 23)=        0.30416391D0
	rhoarr( 24)=        0.30312486D0
	rhoarr( 25)=        0.30195801D0
	rhoarr( 26)=        0.30065635D0
	rhoarr( 27)=        0.29921368D0
	rhoarr( 28)=        0.29762470D0
	rhoarr( 29)=        0.29588525D0
	rhoarr( 30)=        0.29399245D0
	rhoarr( 31)=        0.29194488D0
	rhoarr( 32)=        0.28974271D0
	rhoarr( 33)=        0.28738777D0
	rhoarr( 34)=        0.28488369D0
	rhoarr( 35)=        0.28223585D0
	rhoarr( 36)=        0.27945133D0
	rhoarr( 37)=        0.27653887D0
	rhoarr( 38)=        0.27350860D0
	rhoarr( 39)=        0.27037187D0
	rhoarr( 40)=        0.26714091D0
	rhoarr( 41)=        0.26382845D0
	rhoarr( 42)=        0.26044734D0
	rhoarr( 43)=        0.25701010D0
	rhoarr( 44)=        0.25352843D0
	rhoarr( 45)=        0.25001286D0
	rhoarr( 46)=        0.24647231D0
	rhoarr( 47)=        0.24291378D0
	rhoarr( 48)=        0.23934217D0
	rhoarr( 49)=        0.23576011D0
	rhoarr( 50)=        0.23216803D0
	rhoarr( 51)=        0.22856426D0
	rhoarr( 52)=        0.22494536D0
	rhoarr( 53)=        0.22130647D0
	rhoarr( 54)=        0.21764178D0
	rhoarr( 55)=        0.21394507D0
	rhoarr( 56)=        0.21021022D0
	rhoarr( 57)=        0.20643176D0
	rhoarr( 58)=        0.20260531D0
	rhoarr( 59)=        0.19872787D0
	rhoarr( 60)=        0.19479814D0
	rhoarr( 61)=        0.19081656D0
	rhoarr( 62)=        0.18678532D0
	rhoarr( 63)=        0.18270822D0
	rhoarr( 64)=        0.17859043D0
	rhoarr( 65)=        0.17443821D0
	rhoarr( 66)=        0.17025861D0
	rhoarr( 67)=        0.16605914D0
	rhoarr( 68)=        0.16184741D0
	rhoarr( 69)=        0.15763094D0
	rhoarr( 70)=        0.15341682D0
	rhoarr( 71)=        0.14921163D0
	rhoarr( 72)=        0.14502119D0
	rhoarr( 73)=        0.14085054D0
	rhoarr( 74)=        0.13670389D0
	rhoarr( 75)=        0.13258459D0
	rhoarr( 76)=        0.12849519D0
	rhoarr( 77)=        0.12443752D0
	rhoarr( 78)=        0.12041279D0
	rhoarr( 79)=        0.11642175D0
	rhoarr( 80)=        0.11246484D0
	rhoarr( 81)=        0.10854237D0
	rhoarr( 82)=        0.10465471D0
	rhoarr( 83)=        0.10080240D0
	rhoarr( 84)=        0.09698640D0
	rhoarr( 85)=        0.09320812D0
	rhoarr( 86)=        0.08946956D0
	rhoarr( 87)=        0.08577334D0
	rhoarr( 88)=        0.08212271D0
	rhoarr( 89)=        0.07852149D0
	rhoarr( 90)=        0.07497398D0
	rhoarr( 91)=        0.07148486D0
	rhoarr( 92)=        0.06805903D0
	rhoarr( 93)=        0.06470145D0
	rhoarr( 94)=        0.06141696D0
	rhoarr( 95)=        0.05821016D0
	rhoarr( 96)=        0.05508524D0
	rhoarr( 97)=        0.05204588D0
	rhoarr( 98)=        0.04909519D0
	rhoarr( 99)=        0.04623564D0
	rhoarr(100)=        0.04346907D0
	rhoarr(101)=        0.04079671D0
	rhoarr(102)=        0.03821926D0
	rhoarr(103)=        0.03573693D0
	rhoarr(104)=        0.03334956D0
	rhoarr(105)=        0.03105671D0
	rhoarr(106)=        0.02885778D0
	rhoarr(107)=        0.02675208D0
	rhoarr(108)=        0.02473894D0
	rhoarr(109)=        0.02281774D0
	rhoarr(110)=        0.02098794D0
	rhoarr(111)=        0.01924911D0
	rhoarr(112)=        0.01760090D0
	rhoarr(113)=        0.01604294D0
	rhoarr(114)=        0.01457484D0
	rhoarr(115)=        0.01319605D0
	rhoarr(116)=        0.01190577D0
	rhoarr(117)=        0.01070290D0
	rhoarr(118)=        0.00958596D0
	rhoarr(119)=        0.00855299D0
	rhoarr(120)=        0.00760162D0
	rhoarr(121)=        0.00672899D0
	rhoarr(122)=        0.00593185D0
	rhoarr(123)=        0.00520661D0
	rhoarr(124)=        0.00454939D0
	rhoarr(125)=        0.00395617D0
	rhoarr(126)=        0.00342282D0
	rhoarr(127)=        0.00294526D0
	rhoarr(128)=        0.00251945D0
	rhoarr(129)=        0.00214154D0
	rhoarr(130)=        0.00180781D0
	rhoarr(131)=        0.00151476D0
	rhoarr(132)=        0.00125906D0
	rhoarr(133)=        0.00103755D0
	rhoarr(134)=        0.00084720D0
	rhoarr(135)=        0.00068508D0
	rhoarr(136)=        0.00054836D0
	rhoarr(137)=        0.00043426D0
	rhoarr(138)=        0.00034011D0
	rhoarr(139)=        0.00026332D0
	rhoarr(140)=        0.00020143D0
	rhoarr(141)=        0.00015216D0
	rhoarr(142)=        0.00011341D0
	rhoarr(143)=        0.00008331D0
	rhoarr(144)=        0.00006022D0
	rhoarr(145)=        0.00004274D0
	rhoarr(146)=        0.00002971D0
	rhoarr(147)=        0.00002015D0
	rhoarr(148)=        0.00001328D0
	rhoarr(149)=        0.00000846D0
	rhoarr(150)=        0.00000518D0
	rhoarr(151)=        0.00000302D0
	rhoarr(152)=        0.00000167D0
	rhoarr(153)=        0.00000087D0
	rhoarr(154)=        0.00000042D0
	rhoarr(155)=        0.00000019D0
	rhoarr(156)=        0.00000008D0
	rhoarr(157)=        0.00000003D0
	
else if (iele== 2) then  !He, 0 1, b3lyp/cc-pVQZ
	npt=  151
	rhoarr(  1)=        3.51778956D0
	rhoarr(  2)=        3.51777235D0
	rhoarr(  3)=        3.51769778D0
	rhoarr(  4)=        3.51749690D0
	rhoarr(  5)=        3.51707309D0
	rhoarr(  6)=        3.51630213D0
	rhoarr(  7)=        3.51503246D0
	rhoarr(  8)=        3.51308591D0
	rhoarr(  9)=        3.51025899D0
	rhoarr( 10)=        3.50632508D0
	rhoarr( 11)=        3.50103764D0
	rhoarr( 12)=        3.49413476D0
	rhoarr( 13)=        3.48534529D0
	rhoarr( 14)=        3.47439663D0
	rhoarr( 15)=        3.46102424D0
	rhoarr( 16)=        3.44498273D0
	rhoarr( 17)=        3.42605826D0
	rhoarr( 18)=        3.40408157D0
	rhoarr( 19)=        3.37894086D0
	rhoarr( 20)=        3.35059332D0
	rhoarr( 21)=        3.31907407D0
	rhoarr( 22)=        3.28450098D0
	rhoarr( 23)=        3.24707423D0
	rhoarr( 24)=        3.20706937D0
	rhoarr( 25)=        3.16482367D0
	rhoarr( 26)=        3.12071593D0
	rhoarr( 27)=        3.07514096D0
	rhoarr( 28)=        3.02848112D0
	rhoarr( 29)=        2.98107761D0
	rhoarr( 30)=        2.93320520D0
	rhoarr( 31)=        2.88505365D0
	rhoarr( 32)=        2.83671855D0
	rhoarr( 33)=        2.78820344D0
	rhoarr( 34)=        2.73943281D0
	rhoarr( 35)=        2.69027455D0
	rhoarr( 36)=        2.64056817D0
	rhoarr( 37)=        2.59015465D0
	rhoarr( 38)=        2.53890328D0
	rhoarr( 39)=        2.48673170D0
	rhoarr( 40)=        2.43361703D0
	rhoarr( 41)=        2.37959741D0
	rhoarr( 42)=        2.32476545D0
	rhoarr( 43)=        2.26925593D0
	rhoarr( 44)=        2.21323065D0
	rhoarr( 45)=        2.15686306D0
	rhoarr( 46)=        2.10032463D0
	rhoarr( 47)=        2.04377403D0
	rhoarr( 48)=        1.98734956D0
	rhoarr( 49)=        1.93116464D0
	rhoarr( 50)=        1.87530617D0
	rhoarr( 51)=        1.81983520D0
	rhoarr( 52)=        1.76478963D0
	rhoarr( 53)=        1.71018835D0
	rhoarr( 54)=        1.65603658D0
	rhoarr( 55)=        1.60233163D0
	rhoarr( 56)=        1.54906887D0
	rhoarr( 57)=        1.49624718D0
	rhoarr( 58)=        1.44387351D0
	rhoarr( 59)=        1.39196616D0
	rhoarr( 60)=        1.34055654D0
	rhoarr( 61)=        1.28968940D0
	rhoarr( 62)=        1.23942156D0
	rhoarr( 63)=        1.18981940D0
	rhoarr( 64)=        1.14095555D0
	rhoarr( 65)=        1.09290507D0
	rhoarr( 66)=        1.04574164D0
	rhoarr( 67)=        0.99953413D0
	rhoarr( 68)=        0.95434373D0
	rhoarr( 69)=        0.91022198D0
	rhoarr( 70)=        0.86720969D0
	rhoarr( 71)=        0.82533670D0
	rhoarr( 72)=        0.78462249D0
	rhoarr( 73)=        0.74507738D0
	rhoarr( 74)=        0.70670415D0
	rhoarr( 75)=        0.66950003D0
	rhoarr( 76)=        0.63345866D0
	rhoarr( 77)=        0.59857198D0
	rhoarr( 78)=        0.56483191D0
	rhoarr( 79)=        0.53223162D0
	rhoarr( 80)=        0.50076638D0
	rhoarr( 81)=        0.47043392D0
	rhoarr( 82)=        0.44123432D0
	rhoarr( 83)=        0.41316951D0
	rhoarr( 84)=        0.38624231D0
	rhoarr( 85)=        0.36045541D0
	rhoarr( 86)=        0.33581008D0
	rhoarr( 87)=        0.31230505D0
	rhoarr( 88)=        0.28993542D0
	rhoarr( 89)=        0.26869189D0
	rhoarr( 90)=        0.24856031D0
	rhoarr( 91)=        0.22952147D0
	rhoarr( 92)=        0.21155138D0
	rhoarr( 93)=        0.19462165D0
	rhoarr( 94)=        0.17870031D0
	rhoarr( 95)=        0.16375257D0
	rhoarr( 96)=        0.14974186D0
	rhoarr( 97)=        0.13663066D0
	rhoarr( 98)=        0.12438137D0
	rhoarr( 99)=        0.11295698D0
	rhoarr(100)=        0.10232157D0
	rhoarr(101)=        0.09244058D0
	rhoarr(102)=        0.08328089D0
	rhoarr(103)=        0.07481075D0
	rhoarr(104)=        0.06699946D0
	rhoarr(105)=        0.05981709D0
	rhoarr(106)=        0.05323408D0
	rhoarr(107)=        0.04722085D0
	rhoarr(108)=        0.04174758D0
	rhoarr(109)=        0.03678393D0
	rhoarr(110)=        0.03229911D0
	rhoarr(111)=        0.02826187D0
	rhoarr(112)=        0.02464075D0
	rhoarr(113)=        0.02140441D0
	rhoarr(114)=        0.01852195D0
	rhoarr(115)=        0.01596336D0
	rhoarr(116)=        0.01369978D0
	rhoarr(117)=        0.01170393D0
	rhoarr(118)=        0.00995022D0
	rhoarr(119)=        0.00841495D0
	rhoarr(120)=        0.00707633D0
	rhoarr(121)=        0.00591441D0
	rhoarr(122)=        0.00491099D0
	rhoarr(123)=        0.00404938D0
	rhoarr(124)=        0.00331431D0
	rhoarr(125)=        0.00269166D0
	rhoarr(126)=        0.00216834D0
	rhoarr(127)=        0.00173220D0
	rhoarr(128)=        0.00137194D0
	rhoarr(129)=        0.00107707D0
	rhoarr(130)=        0.00083799D0
	rhoarr(131)=        0.00064594D0
	rhoarr(132)=        0.00049310D0
	rhoarr(133)=        0.00037258D0
	rhoarr(134)=        0.00027839D0
	rhoarr(135)=        0.00020546D0
	rhoarr(136)=        0.00014954D0
	rhoarr(137)=        0.00010710D0
	rhoarr(138)=        0.00007529D0
	rhoarr(139)=        0.00005179D0
	rhoarr(140)=        0.00003473D0
	rhoarr(141)=        0.00002261D0
	rhoarr(142)=        0.00001423D0
	rhoarr(143)=        0.00000861D0
	rhoarr(144)=        0.00000498D0
	rhoarr(145)=        0.00000274D0
	rhoarr(146)=        0.00000142D0
	rhoarr(147)=        0.00000069D0
	rhoarr(148)=        0.00000031D0
	rhoarr(149)=        0.00000013D0
	rhoarr(150)=        0.00000005D0
	rhoarr(151)=        0.00000002D0
	
else if (iele== 3) then  !Li, 0 2, b3lyp/cc-pVQZ
	npt=  168
	rhoarr(  1)=       13.48170040D0
	rhoarr(  2)=       13.48135064D0
	rhoarr(  3)=       13.47983542D0
	rhoarr(  4)=       13.47576194D0
	rhoarr(  5)=       13.46720701D0
	rhoarr(  6)=       13.45177874D0
	rhoarr(  7)=       13.42674220D0
	rhoarr(  8)=       13.38923361D0
	rhoarr(  9)=       13.33657507D0
	rhoarr( 10)=       13.26667425D0
	rhoarr( 11)=       13.17844900D0
	rhoarr( 12)=       13.07216761D0
	rhoarr( 13)=       12.94956310D0
	rhoarr( 14)=       12.81359870D0
	rhoarr( 15)=       12.66785371D0
	rhoarr( 16)=       12.51565554D0
	rhoarr( 17)=       12.35923810D0
	rhoarr( 18)=       12.19926298D0
	rhoarr( 19)=       12.03492136D0
	rhoarr( 20)=       11.86457145D0
	rhoarr( 21)=       11.68660105D0
	rhoarr( 22)=       11.50011477D0
	rhoarr( 23)=       11.30519109D0
	rhoarr( 24)=       11.10271754D0
	rhoarr( 25)=       10.89400259D0
	rhoarr( 26)=       10.68038311D0
	rhoarr( 27)=       10.46295240D0
	rhoarr( 28)=       10.24243432D0
	rhoarr( 29)=       10.01917899D0
	rhoarr( 30)=        9.79324388D0
	rhoarr( 31)=        9.56452414D0
	rhoarr( 32)=        9.33289592D0
	rhoarr( 33)=        9.09833920D0
	rhoarr( 34)=        8.86101465D0
	rhoarr( 35)=        8.62128407D0
	rhoarr( 36)=        8.37967917D0
	rhoarr( 37)=        8.13683593D0
	rhoarr( 38)=        7.89341717D0
	rhoarr( 39)=        7.65004353D0
	rhoarr( 40)=        7.40724661D0
	rhoarr( 41)=        7.16544889D0
	rhoarr( 42)=        6.92496842D0
	rhoarr( 43)=        6.68604135D0
	rhoarr( 44)=        6.44885432D0
	rhoarr( 45)=        6.21357836D0
	rhoarr( 46)=        5.98039820D0
	rhoarr( 47)=        5.74953231D0
	rhoarr( 48)=        5.52124182D0
	rhoarr( 49)=        5.29582820D0
	rhoarr( 50)=        5.07362203D0
	rhoarr( 51)=        4.85496586D0
	rhoarr( 52)=        4.64019519D0
	rhoarr( 53)=        4.42962107D0
	rhoarr( 54)=        4.22351701D0
	rhoarr( 55)=        4.02211176D0
	rhoarr( 56)=        3.82558812D0
	rhoarr( 57)=        3.63408694D0
	rhoarr( 58)=        3.44771489D0
	rhoarr( 59)=        3.26655384D0
	rhoarr( 60)=        3.09067041D0
	rhoarr( 61)=        2.92012393D0
	rhoarr( 62)=        2.75497195D0
	rhoarr( 63)=        2.59527278D0
	rhoarr( 64)=        2.44108521D0
	rhoarr( 65)=        2.29246579D0
	rhoarr( 66)=        2.14946450D0
	rhoarr( 67)=        2.01211974D0
	rhoarr( 68)=        1.88045354D0
	rhoarr( 69)=        1.75446764D0
	rhoarr( 70)=        1.63414119D0
	rhoarr( 71)=        1.51943007D0
	rhoarr( 72)=        1.41026789D0
	rhoarr( 73)=        1.30656837D0
	rhoarr( 74)=        1.20822867D0
	rhoarr( 75)=        1.11513305D0
	rhoarr( 76)=        1.02715649D0
	rhoarr( 77)=        0.94416782D0
	rhoarr( 78)=        0.86603200D0
	rhoarr( 79)=        0.79261151D0
	rhoarr( 80)=        0.72376692D0
	rhoarr( 81)=        0.65935664D0
	rhoarr( 82)=        0.59923626D0
	rhoarr( 83)=        0.54325762D0
	rhoarr( 84)=        0.49126799D0
	rhoarr( 85)=        0.44310952D0
	rhoarr( 86)=        0.39861913D0
	rhoarr( 87)=        0.35762893D0
	rhoarr( 88)=        0.31996714D0
	rhoarr( 89)=        0.28545940D0
	rhoarr( 90)=        0.25393035D0
	rhoarr( 91)=        0.22520526D0
	rhoarr( 92)=        0.19911166D0
	rhoarr( 93)=        0.17548066D0
	rhoarr( 94)=        0.15414805D0
	rhoarr( 95)=        0.13495500D0
	rhoarr( 96)=        0.11774843D0
	rhoarr( 97)=        0.10238117D0
	rhoarr( 98)=        0.08871186D0
	rhoarr( 99)=        0.07660480D0
	rhoarr(100)=        0.06592974D0
	rhoarr(101)=        0.05656186D0
	rhoarr(102)=        0.04838168D0
	rhoarr(103)=        0.04127528D0
	rhoarr(104)=        0.03513450D0
	rhoarr(105)=        0.02985722D0
	rhoarr(106)=        0.02534771D0
	rhoarr(107)=        0.02151686D0
	rhoarr(108)=        0.01828237D0
	rhoarr(109)=        0.01556880D0
	rhoarr(110)=        0.01330745D0
	rhoarr(111)=        0.01143621D0
	rhoarr(112)=        0.00989919D0
	rhoarr(113)=        0.00864637D0
	rhoarr(114)=        0.00763317D0
	rhoarr(115)=        0.00682001D0
	rhoarr(116)=        0.00617194D0
	rhoarr(117)=        0.00565827D0
	rhoarr(118)=        0.00525221D0
	rhoarr(119)=        0.00493062D0
	rhoarr(120)=        0.00467373D0
	rhoarr(121)=        0.00446482D0
	rhoarr(122)=        0.00429006D0
	rhoarr(123)=        0.00413811D0
	rhoarr(124)=        0.00399995D0
	rhoarr(125)=        0.00386852D0
	rhoarr(126)=        0.00373847D0
	rhoarr(127)=        0.00360593D0
	rhoarr(128)=        0.00346822D0
	rhoarr(129)=        0.00332368D0
	rhoarr(130)=        0.00317150D0
	rhoarr(131)=        0.00301156D0
	rhoarr(132)=        0.00284430D0
	rhoarr(133)=        0.00267062D0
	rhoarr(134)=        0.00249182D0
	rhoarr(135)=        0.00230943D0
	rhoarr(136)=        0.00212522D0
	rhoarr(137)=        0.00194103D0
	rhoarr(138)=        0.00175877D0
	rhoarr(139)=        0.00158031D0
	rhoarr(140)=        0.00140740D0
	rhoarr(141)=        0.00124168D0
	rhoarr(142)=        0.00108461D0
	rhoarr(143)=        0.00093741D0
	rhoarr(144)=        0.00080109D0
	rhoarr(145)=        0.00067641D0
	rhoarr(146)=        0.00056385D0
	rhoarr(147)=        0.00046363D0
	rhoarr(148)=        0.00037570D0
	rhoarr(149)=        0.00029974D0
	rhoarr(150)=        0.00023520D0
	rhoarr(151)=        0.00018132D0
	rhoarr(152)=        0.00013716D0
	rhoarr(153)=        0.00010168D0
	rhoarr(154)=        0.00007375D0
	rhoarr(155)=        0.00005226D0
	rhoarr(156)=        0.00003611D0
	rhoarr(157)=        0.00002427D0
	rhoarr(158)=        0.00001583D0
	rhoarr(159)=        0.00000999D0
	rhoarr(160)=        0.00000608D0
	rhoarr(161)=        0.00000355D0
	rhoarr(162)=        0.00000198D0
	rhoarr(163)=        0.00000105D0
	rhoarr(164)=        0.00000052D0
	rhoarr(165)=        0.00000024D0
	rhoarr(166)=        0.00000010D0
	rhoarr(167)=        0.00000004D0
	rhoarr(168)=        0.00000001D0

else if (iele== 4) then  !Be, 0 1, b3lyp/cc-pVQZ
	npt=  164
	rhoarr(  1)=       34.68056513D0
	rhoarr(  2)=       34.67878693D0
	rhoarr(  3)=       34.67109002D0
	rhoarr(  4)=       34.65045212D0
	rhoarr(  5)=       34.60736547D0
	rhoarr(  6)=       34.53052943D0
	rhoarr(  7)=       34.40817522D0
	rhoarr(  8)=       34.23011049D0
	rhoarr(  9)=       33.99024193D0
	rhoarr( 10)=       33.68883785D0
	rhoarr( 11)=       33.33336821D0
	rhoarr( 12)=       32.93685472D0
	rhoarr( 13)=       32.51364802D0
	rhoarr( 14)=       32.07419205D0
	rhoarr( 15)=       31.62152977D0
	rhoarr( 16)=       31.15171498D0
	rhoarr( 17)=       30.65782650D0
	rhoarr( 18)=       30.13479718D0
	rhoarr( 19)=       29.58204841D0
	rhoarr( 20)=       29.00305043D0
	rhoarr( 21)=       28.40313441D0
	rhoarr( 22)=       27.78733115D0
	rhoarr( 23)=       27.15912868D0
	rhoarr( 24)=       26.52018454D0
	rhoarr( 25)=       25.87071240D0
	rhoarr( 26)=       25.21022913D0
	rhoarr( 27)=       24.53835811D0
	rhoarr( 28)=       23.85542699D0
	rhoarr( 29)=       23.16270637D0
	rhoarr( 30)=       22.46228580D0
	rhoarr( 31)=       21.75670994D0
	rhoarr( 32)=       21.04855123D0
	rhoarr( 33)=       20.34006980D0
	rhoarr( 34)=       19.63303875D0
	rhoarr( 35)=       18.92873862D0
	rhoarr( 36)=       18.22807565D0
	rhoarr( 37)=       17.53176010D0
	rhoarr( 38)=       16.84048550D0
	rhoarr( 39)=       16.15506473D0
	rhoarr( 40)=       15.47649952D0
	rhoarr( 41)=       14.80597949D0
	rhoarr( 42)=       14.14482400D0
	rhoarr( 43)=       13.49439081D0
	rhoarr( 44)=       12.85597861D0
	rhoarr( 45)=       12.23074671D0
	rhoarr( 46)=       11.61966654D0
	rhoarr( 47)=       11.02350900D0
	rhoarr( 48)=       10.44286318D0
	rhoarr( 49)=        9.87817586D0
	rhoarr( 50)=        9.32979942D0
	rhoarr( 51)=        8.79803677D0
	rhoarr( 52)=        8.28317495D0
	rhoarr( 53)=        7.78550305D0
	rhoarr( 54)=        7.30531395D0
	rhoarr( 55)=        6.84289261D0
	rhoarr( 56)=        6.39849550D0
	rhoarr( 57)=        5.97232702D0
	rhoarr( 58)=        5.56451787D0
	rhoarr( 59)=        5.17510967D0
	rhoarr( 60)=        4.80404789D0
	rhoarr( 61)=        4.45118354D0
	rhoarr( 62)=        4.11628230D0
	rhoarr( 63)=        3.79903881D0
	rhoarr( 64)=        3.49909309D0
	rhoarr( 65)=        3.21604661D0
	rhoarr( 66)=        2.94947561D0
	rhoarr( 67)=        2.69894056D0
	rhoarr( 68)=        2.46399123D0
	rhoarr( 69)=        2.24416784D0
	rhoarr( 70)=        2.03899924D0
	rhoarr( 71)=        1.84799946D0
	rhoarr( 72)=        1.67066406D0
	rhoarr( 73)=        1.50646735D0
	rhoarr( 74)=        1.35486151D0
	rhoarr( 75)=        1.21527782D0
	rhoarr( 76)=        1.08713009D0
	rhoarr( 77)=        0.96981985D0
	rhoarr( 78)=        0.86274263D0
	rhoarr( 79)=        0.76529457D0
	rhoarr( 80)=        0.67687867D0
	rhoarr( 81)=        0.59691008D0
	rhoarr( 82)=        0.52482015D0
	rhoarr( 83)=        0.46005904D0
	rhoarr( 84)=        0.40209701D0
	rhoarr( 85)=        0.35042479D0
	rhoarr( 86)=        0.30455316D0
	rhoarr( 87)=        0.26401237D0
	rhoarr( 88)=        0.22835155D0
	rhoarr( 89)=        0.19713849D0
	rhoarr( 90)=        0.16995976D0
	rhoarr( 91)=        0.14642136D0
	rhoarr( 92)=        0.12614963D0
	rhoarr( 93)=        0.10879233D0
	rhoarr( 94)=        0.09401971D0
	rhoarr( 95)=        0.08152531D0
	rhoarr( 96)=        0.07102645D0
	rhoarr( 97)=        0.06226422D0
	rhoarr( 98)=        0.05500306D0
	rhoarr( 99)=        0.04902997D0
	rhoarr(100)=        0.04415329D0
	rhoarr(101)=        0.04020145D0
	rhoarr(102)=        0.03702150D0
	rhoarr(103)=        0.03447776D0
	rhoarr(104)=        0.03245046D0
	rhoarr(105)=        0.03083461D0
	rhoarr(106)=        0.02953890D0
	rhoarr(107)=        0.02848472D0
	rhoarr(108)=        0.02760525D0
	rhoarr(109)=        0.02684454D0
	rhoarr(110)=        0.02615658D0
	rhoarr(111)=        0.02550437D0
	rhoarr(112)=        0.02485892D0
	rhoarr(113)=        0.02419829D0
	rhoarr(114)=        0.02350663D0
	rhoarr(115)=        0.02277325D0
	rhoarr(116)=        0.02199185D0
	rhoarr(117)=        0.02115973D0
	rhoarr(118)=        0.02027724D0
	rhoarr(119)=        0.01934716D0
	rhoarr(120)=        0.01837433D0
	rhoarr(121)=        0.01736517D0
	rhoarr(122)=        0.01632741D0
	rhoarr(123)=        0.01526970D0
	rhoarr(124)=        0.01420130D0
	rhoarr(125)=        0.01313176D0
	rhoarr(126)=        0.01207065D0
	rhoarr(127)=        0.01102721D0
	rhoarr(128)=        0.01001018D0
	rhoarr(129)=        0.00902750D0
	rhoarr(130)=        0.00808622D0
	rhoarr(131)=        0.00719234D0
	rhoarr(132)=        0.00635076D0
	rhoarr(133)=        0.00556525D0
	rhoarr(134)=        0.00483845D0
	rhoarr(135)=        0.00417190D0
	rhoarr(136)=        0.00356611D0
	rhoarr(137)=        0.00302063D0
	rhoarr(138)=        0.00253414D0
	rhoarr(139)=        0.00210454D0
	rhoarr(140)=        0.00172906D0
	rhoarr(141)=        0.00140442D0
	rhoarr(142)=        0.00112691D0
	rhoarr(143)=        0.00089251D0
	rhoarr(144)=        0.00069705D0
	rhoarr(145)=        0.00053629D0
	rhoarr(146)=        0.00040603D0
	rhoarr(147)=        0.00030215D0
	rhoarr(148)=        0.00022075D0
	rhoarr(149)=        0.00015815D0
	rhoarr(150)=        0.00011098D0
	rhoarr(151)=        0.00007619D0
	rhoarr(152)=        0.00005111D0
	rhoarr(153)=        0.00003345D0
	rhoarr(154)=        0.00002132D0
	rhoarr(155)=        0.00001319D0
	rhoarr(156)=        0.00000790D0
	rhoarr(157)=        0.00000455D0
	rhoarr(158)=        0.00000250D0
	rhoarr(159)=        0.00000130D0
	rhoarr(160)=        0.00000063D0
	rhoarr(161)=        0.00000028D0
	rhoarr(162)=        0.00000011D0
	rhoarr(163)=        0.00000004D0
	rhoarr(164)=        0.00000001D0

else if (iele== 5) then  !B, 0 2, b3lyp/cc-pVQZ
	npt=  162
	rhoarr(  1)=       70.49262452D0
	rhoarr(  2)=       70.48688090D0
	rhoarr(  3)=       70.46204465D0
	rhoarr(  4)=       70.39565062D0
	rhoarr(  5)=       70.25797090D0
	rhoarr(  6)=       70.01554996D0
	rhoarr(  7)=       69.63756554D0
	rhoarr(  8)=       69.10455707D0
	rhoarr(  9)=       68.41677270D0
	rhoarr( 10)=       67.59713721D0
	rhoarr( 11)=       66.68422313D0
	rhoarr( 12)=       65.71581933D0
	rhoarr( 13)=       64.71172564D0
	rhoarr( 14)=       63.66779863D0
	rhoarr( 15)=       62.56583664D0
	rhoarr( 16)=       61.39066593D0
	rhoarr( 17)=       60.14071194D0
	rhoarr( 18)=       58.82670745D0
	rhoarr( 19)=       57.46390649D0
	rhoarr( 20)=       56.06514426D0
	rhoarr( 21)=       54.63773406D0
	rhoarr( 22)=       53.18373194D0
	rhoarr( 23)=       51.70218777D0
	rhoarr( 24)=       50.19198967D0
	rhoarr( 25)=       48.65408074D0
	rhoarr( 26)=       47.09231186D0
	rhoarr( 27)=       45.51290941D0
	rhoarr( 28)=       43.92312634D0
	rhoarr( 29)=       42.32983061D0
	rhoarr( 30)=       40.73858089D0
	rhoarr( 31)=       39.15337035D0
	rhoarr( 32)=       37.57691889D0
	rhoarr( 33)=       36.01125537D0
	rhoarr( 34)=       34.45832985D0
	rhoarr( 35)=       32.92046607D0
	rhoarr( 36)=       31.40055982D0
	rhoarr( 37)=       29.90202175D0
	rhoarr( 38)=       28.42853422D0
	rhoarr( 39)=       26.98372944D0
	rhoarr( 40)=       25.57089422D0
	rhoarr( 41)=       24.19277561D0
	rhoarr( 42)=       22.85151604D0
	rhoarr( 43)=       21.54870516D0
	rhoarr( 44)=       20.28550809D0
	rhoarr( 45)=       19.06282111D0
	rhoarr( 46)=       17.88141123D0
	rhoarr( 47)=       16.74201078D0
	rhoarr( 48)=       15.64535538D0
	rhoarr( 49)=       14.59216900D0
	rhoarr( 50)=       13.58311110D0
	rhoarr( 51)=       12.61870601D0
	rhoarr( 52)=       11.69927505D0
	rhoarr( 53)=       10.82488721D0
	rhoarr( 54)=        9.99533725D0
	rhoarr( 55)=        9.21015270D0
	rhoarr( 56)=        8.46862472D0
	rhoarr( 57)=        7.76985402D0
	rhoarr( 58)=        7.11280173D0
	rhoarr( 59)=        6.49633597D0
	rhoarr( 60)=        5.91926802D0
	rhoarr( 61)=        5.38037495D0
	rhoarr( 62)=        4.87840885D0
	rhoarr( 63)=        4.41209557D0
	rhoarr( 64)=        3.98012697D0
	rhoarr( 65)=        3.58115141D0
	rhoarr( 66)=        3.21376633D0
	rhoarr( 67)=        2.87651600D0
	rhoarr( 68)=        2.56789556D0
	rhoarr( 69)=        2.28636124D0
	rhoarr( 70)=        2.03034541D0
	rhoarr( 71)=        1.79827439D0
	rhoarr( 72)=        1.58858663D0
	rhoarr( 73)=        1.39974928D0
	rhoarr( 74)=        1.23027166D0
	rhoarr( 75)=        1.07871483D0
	rhoarr( 76)=        0.94369725D0
	rhoarr( 77)=        0.82389712D0
	rhoarr( 78)=        0.71805236D0
	rhoarr( 79)=        0.62495916D0
	rhoarr( 80)=        0.54347039D0
	rhoarr( 81)=        0.47249429D0
	rhoarr( 82)=        0.41099425D0
	rhoarr( 83)=        0.35798939D0
	rhoarr( 84)=        0.31255613D0
	rhoarr( 85)=        0.27382997D0
	rhoarr( 86)=        0.24100732D0
	rhoarr( 87)=        0.21334673D0
	rhoarr( 88)=        0.19016922D0
	rhoarr( 89)=        0.17085762D0
	rhoarr( 90)=        0.15485472D0
	rhoarr( 91)=        0.14166066D0
	rhoarr( 92)=        0.13082942D0
	rhoarr( 93)=        0.12196514D0
	rhoarr( 94)=        0.11471813D0
	rhoarr( 95)=        0.10878112D0
	rhoarr( 96)=        0.10388572D0
	rhoarr( 97)=        0.09979923D0
	rhoarr( 98)=        0.09632183D0
	rhoarr( 99)=        0.09328393D0
	rhoarr(100)=        0.09054381D0
	rhoarr(101)=        0.08798525D0
	rhoarr(102)=        0.08551521D0
	rhoarr(103)=        0.08306148D0
	rhoarr(104)=        0.08057029D0
	rhoarr(105)=        0.07800390D0
	rhoarr(106)=        0.07533827D0
	rhoarr(107)=        0.07256086D0
	rhoarr(108)=        0.06966855D0
	rhoarr(109)=        0.06666575D0
	rhoarr(110)=        0.06356284D0
	rhoarr(111)=        0.06037469D0
	rhoarr(112)=        0.05711950D0
	rhoarr(113)=        0.05381773D0
	rhoarr(114)=        0.05049128D0
	rhoarr(115)=        0.04716273D0
	rhoarr(116)=        0.04385465D0
	rhoarr(117)=        0.04058911D0
	rhoarr(118)=        0.03738719D0
	rhoarr(119)=        0.03426855D0
	rhoarr(120)=        0.03125117D0
	rhoarr(121)=        0.02835108D0
	rhoarr(122)=        0.02558222D0
	rhoarr(123)=        0.02295629D0
	rhoarr(124)=        0.02048274D0
	rhoarr(125)=        0.01816870D0
	rhoarr(126)=        0.01601898D0
	rhoarr(127)=        0.01403612D0
	rhoarr(128)=        0.01222040D0
	rhoarr(129)=        0.01056995D0
	rhoarr(130)=        0.00908091D0
	rhoarr(131)=        0.00774756D0
	rhoarr(132)=        0.00656262D0
	rhoarr(133)=        0.00551756D0
	rhoarr(134)=        0.00460287D0
	rhoarr(135)=        0.00380845D0
	rhoarr(136)=        0.00312391D0
	rhoarr(137)=        0.00253885D0
	rhoarr(138)=        0.00204311D0
	rhoarr(139)=        0.00162693D0
	rhoarr(140)=        0.00128104D0
	rhoarr(141)=        0.00099671D0
	rhoarr(142)=        0.00076580D0
	rhoarr(143)=        0.00058070D0
	rhoarr(144)=        0.00043440D0
	rhoarr(145)=        0.00032046D0
	rhoarr(146)=        0.00023306D0
	rhoarr(147)=        0.00016704D0
	rhoarr(148)=        0.00011789D0
	rhoarr(149)=        0.00008185D0
	rhoarr(150)=        0.00005579D0
	rhoarr(151)=        0.00003722D0
	rhoarr(152)=        0.00002420D0
	rhoarr(153)=        0.00001525D0
	rhoarr(154)=        0.00000924D0
	rhoarr(155)=        0.00000534D0
	rhoarr(156)=        0.00000292D0
	rhoarr(157)=        0.00000149D0
	rhoarr(158)=        0.00000070D0
	rhoarr(159)=        0.00000030D0
	rhoarr(160)=        0.00000011D0
	rhoarr(161)=        0.00000004D0
	rhoarr(162)=        0.00000001D0

else if (iele== 6) then  !C, 0 3, b3lyp/cc-pVQZ
	npt=  158
	rhoarr(  1)=      125.08791885D0
	rhoarr(  2)=      125.07304162D0
	rhoarr(  3)=      125.00878352D0
	rhoarr(  4)=      124.83758647D0
	rhoarr(  5)=      124.48526844D0
	rhoarr(  6)=      123.87365870D0
	rhoarr(  7)=      122.94185840D0
	rhoarr(  8)=      121.67146200D0
	rhoarr(  9)=      120.10223647D0
	rhoarr( 10)=      118.32124429D0
	rhoarr( 11)=      116.42122942D0
	rhoarr( 12)=      114.45148089D0
	rhoarr( 13)=      112.40005911D0
	rhoarr( 14)=      110.22282907D0
	rhoarr( 15)=      107.88978679D0
	rhoarr( 16)=      105.40687714D0
	rhoarr( 17)=      102.80490792D0
	rhoarr( 18)=      100.11753026D0
	rhoarr( 19)=       97.36715849D0
	rhoarr( 20)=       94.56219428D0
	rhoarr( 21)=       91.70173582D0
	rhoarr( 22)=       88.78314451D0
	rhoarr( 23)=       85.80837279D0
	rhoarr( 24)=       82.78647350D0
	rhoarr( 25)=       79.73210917D0
	rhoarr( 26)=       76.66186548D0
	rhoarr( 27)=       73.59068651D0
	rhoarr( 28)=       70.52992303D0
	rhoarr( 29)=       67.48725167D0
	rhoarr( 30)=       64.46787824D0
	rhoarr( 31)=       61.47618262D0
	rhoarr( 32)=       58.51710315D0
	rhoarr( 33)=       55.59686009D0
	rhoarr( 34)=       52.72293831D0
	rhoarr( 35)=       49.90350654D0
	rhoarr( 36)=       47.14659018D0
	rhoarr( 37)=       44.45931729D0
	rhoarr( 38)=       41.84745469D0
	rhoarr( 39)=       39.31530367D0
	rhoarr( 40)=       36.86589668D0
	rhoarr( 41)=       34.50136357D0
	rhoarr( 42)=       32.22332420D0
	rhoarr( 43)=       30.03319616D0
	rhoarr( 44)=       27.93235854D0
	rhoarr( 45)=       25.92216519D0
	rhoarr( 46)=       24.00384119D0
	rhoarr( 47)=       22.17831801D0
	rhoarr( 48)=       20.44606651D0
	rhoarr( 49)=       18.80697465D0
	rhoarr( 50)=       17.26029633D0
	rhoarr( 51)=       15.80467513D0
	rhoarr( 52)=       14.43822787D0
	rhoarr( 53)=       13.15866277D0
	rhoarr( 54)=       11.96340441D0
	rhoarr( 55)=       10.84970245D0
	rhoarr( 56)=        9.81470978D0
	rhoarr( 57)=        8.85552570D0
	rhoarr( 58)=        7.96920788D0
	rhoarr( 59)=        7.15276274D0
	rhoarr( 60)=        6.40312612D0
	rhoarr( 61)=        5.71714554D0
	rhoarr( 62)=        5.09157259D0
	rhoarr( 63)=        4.52306967D0
	rhoarr( 64)=        4.00823160D0
	rhoarr( 65)=        3.54361902D0
	rhoarr( 66)=        3.12579853D0
	rhoarr( 67)=        2.75138385D0
	rhoarr( 68)=        2.41707304D0
	rhoarr( 69)=        2.11967820D0
	rhoarr( 70)=        1.85614605D0
	rhoarr( 71)=        1.62356941D0
	rhoarr( 72)=        1.41919124D0
	rhoarr( 73)=        1.24040345D0
	rhoarr( 74)=        1.08474296D0
	rhoarr( 75)=        0.94988727D0
	rhoarr( 76)=        0.83365098D0
	rhoarr( 77)=        0.73398409D0
	rhoarr( 78)=        0.64897187D0
	rhoarr( 79)=        0.57683594D0
	rhoarr( 80)=        0.51593546D0
	rhoarr( 81)=        0.46476764D0
	rhoarr( 82)=        0.42196670D0
	rhoarr( 83)=        0.38630091D0
	rhoarr( 84)=        0.35666757D0
	rhoarr( 85)=        0.33208628D0
	rhoarr( 86)=        0.31169077D0
	rhoarr( 87)=        0.29472016D0
	rhoarr( 88)=        0.28050998D0
	rhoarr( 89)=        0.26848360D0
	rhoarr( 90)=        0.25814429D0
	rhoarr( 91)=        0.24906813D0
	rhoarr( 92)=        0.24089762D0
	rhoarr( 93)=        0.23333600D0
	rhoarr( 94)=        0.22614194D0
	rhoarr( 95)=        0.21912442D0
	rhoarr( 96)=        0.21213767D0
	rhoarr( 97)=        0.20507609D0
	rhoarr( 98)=        0.19786899D0
	rhoarr( 99)=        0.19047541D0
	rhoarr(100)=        0.18287904D0
	rhoarr(101)=        0.17508336D0
	rhoarr(102)=        0.16710714D0
	rhoarr(103)=        0.15898046D0
	rhoarr(104)=        0.15074126D0
	rhoarr(105)=        0.14243244D0
	rhoarr(106)=        0.13409955D0
	rhoarr(107)=        0.12578902D0
	rhoarr(108)=        0.11754671D0
	rhoarr(109)=        0.10941696D0
	rhoarr(110)=        0.10144186D0
	rhoarr(111)=        0.09366073D0
	rhoarr(112)=        0.08610976D0
	rhoarr(113)=        0.07882181D0
	rhoarr(114)=        0.07182617D0
	rhoarr(115)=        0.06514848D0
	rhoarr(116)=        0.05881053D0
	rhoarr(117)=        0.05283011D0
	rhoarr(118)=        0.04722088D0
	rhoarr(119)=        0.04199216D0
	rhoarr(120)=        0.03714879D0
	rhoarr(121)=        0.03269107D0
	rhoarr(122)=        0.02861479D0
	rhoarr(123)=        0.02491138D0
	rhoarr(124)=        0.02156826D0
	rhoarr(125)=        0.01856936D0
	rhoarr(126)=        0.01589576D0
	rhoarr(127)=        0.01352642D0
	rhoarr(128)=        0.01143900D0
	rhoarr(129)=        0.00961057D0
	rhoarr(130)=        0.00801834D0
	rhoarr(131)=        0.00664017D0
	rhoarr(132)=        0.00545496D0
	rhoarr(133)=        0.00444288D0
	rhoarr(134)=        0.00358540D0
	rhoarr(135)=        0.00286526D0
	rhoarr(136)=        0.00226638D0
	rhoarr(137)=        0.00177366D0
	rhoarr(138)=        0.00137297D0
	rhoarr(139)=        0.00105107D0
	rhoarr(140)=        0.00079567D0
	rhoarr(141)=        0.00059553D0
	rhoarr(142)=        0.00044055D0
	rhoarr(143)=        0.00032191D0
	rhoarr(144)=        0.00023204D0
	rhoarr(145)=        0.00016468D0
	rhoarr(146)=        0.00011474D0
	rhoarr(147)=        0.00007817D0
	rhoarr(148)=        0.00005181D0
	rhoarr(149)=        0.00003321D0
	rhoarr(150)=        0.00002044D0
	rhoarr(151)=        0.00001198D0
	rhoarr(152)=        0.00000663D0
	rhoarr(153)=        0.00000343D0
	rhoarr(154)=        0.00000164D0
	rhoarr(155)=        0.00000072D0
	rhoarr(156)=        0.00000028D0
	rhoarr(157)=        0.00000010D0
	rhoarr(158)=        0.00000003D0

else if (iele== 7) then  !N, 0 4, b3lyp/cc-pVQZ
	npt=  155
	rhoarr(  1)=      202.02420056D0
	rhoarr(  2)=      201.99188604D0
	rhoarr(  3)=      201.85249237D0
	rhoarr(  4)=      201.48254271D0
	rhoarr(  5)=      200.72768470D0
	rhoarr(  6)=      199.43779030D0
	rhoarr(  7)=      197.52144337D0
	rhoarr(  8)=      194.99878201D0
	rhoarr(  9)=      192.00983960D0
	rhoarr( 10)=      188.74591018D0
	rhoarr( 11)=      185.33467266D0
	rhoarr( 12)=      181.77462407D0
	rhoarr( 13)=      177.98273456D0
	rhoarr( 14)=      173.89906471D0
	rhoarr( 15)=      169.53919780D0
	rhoarr( 16)=      164.96796043D0
	rhoarr( 17)=      160.25021645D0
	rhoarr( 18)=      155.42358356D0
	rhoarr( 19)=      150.49749036D0
	rhoarr( 20)=      145.46731897D0
	rhoarr( 21)=      140.33153129D0
	rhoarr( 22)=      135.10226429D0
	rhoarr( 23)=      129.80563776D0
	rhoarr( 24)=      124.47458489D0
	rhoarr( 25)=      119.14021797D0
	rhoarr( 26)=      113.82645625D0
	rhoarr( 27)=      108.54926494D0
	rhoarr( 28)=      103.31921518D0
	rhoarr( 29)=       98.14518474D0
	rhoarr( 30)=       93.03737931D0
	rhoarr( 31)=       88.00870671D0
	rhoarr( 32)=       83.07441812D0
	rhoarr( 33)=       78.25058255D0
	rhoarr( 34)=       73.55224007D0
	rhoarr( 35)=       68.99197285D0
	rhoarr( 36)=       64.57928273D0
	rhoarr( 37)=       60.32077245D0
	rhoarr( 38)=       56.22085786D0
	rhoarr( 39)=       52.28264620D0
	rhoarr( 40)=       48.50867203D0
	rhoarr( 41)=       44.90131421D0
	rhoarr( 42)=       41.46286079D0
	rhoarr( 43)=       38.19529891D0
	rhoarr( 44)=       35.09996633D0
	rhoarr( 45)=       32.17720768D0
	rhoarr( 46)=       29.42614408D0
	rhoarr( 47)=       26.84460915D0
	rhoarr( 48)=       24.42924725D0
	rhoarr( 49)=       22.17572842D0
	rhoarr( 50)=       20.07901472D0
	rhoarr( 51)=       18.13361604D0
	rhoarr( 52)=       16.33379030D0
	rhoarr( 53)=       14.67366806D0
	rhoarr( 54)=       13.14730350D0
	rhoarr( 55)=       11.74867090D0
	rhoarr( 56)=       10.47163311D0
	rhoarr( 57)=        9.30990870D0
	rhoarr( 58)=        8.25705771D0
	rhoarr( 59)=        7.30649722D0
	rhoarr( 60)=        6.45154728D0
	rhoarr( 61)=        5.68550074D0
	rhoarr( 62)=        5.00170542D0
	rhoarr( 63)=        4.39364647D0
	rhoarr( 64)=        3.85501830D0
	rhoarr( 65)=        3.37977954D0
	rhoarr( 66)=        2.96218857D0
	rhoarr( 67)=        2.59682094D0
	rhoarr( 68)=        2.27857277D0
	rhoarr( 69)=        2.00265509D0
	rhoarr( 70)=        1.76458428D0
	rhoarr( 71)=        1.56017243D0
	rhoarr( 72)=        1.38551990D0
	rhoarr( 73)=        1.23701069D0
	rhoarr( 74)=        1.11130999D0
	rhoarr( 75)=        1.00536234D0
	rhoarr( 76)=        0.91638874D0
	rhoarr( 77)=        0.84188123D0
	rhoarr( 78)=        0.77959419D0
	rhoarr( 79)=        0.72753206D0
	rhoarr( 80)=        0.68393417D0
	rhoarr( 81)=        0.64725744D0
	rhoarr( 82)=        0.61615825D0
	rhoarr( 83)=        0.58947438D0
	rhoarr( 84)=        0.56620812D0
	rhoarr( 85)=        0.54551079D0
	rhoarr( 86)=        0.52666905D0
	rhoarr( 87)=        0.50909261D0
	rhoarr( 88)=        0.49230319D0
	rhoarr( 89)=        0.47592406D0
	rhoarr( 90)=        0.45966987D0
	rhoarr( 91)=        0.44333639D0
	rhoarr( 92)=        0.42679005D0
	rhoarr( 93)=        0.40995737D0
	rhoarr( 94)=        0.39281437D0
	rhoarr( 95)=        0.37537632D0
	rhoarr( 96)=        0.35768818D0
	rhoarr( 97)=        0.33981596D0
	rhoarr( 98)=        0.32183919D0
	rhoarr( 99)=        0.30384476D0
	rhoarr(100)=        0.28592206D0
	rhoarr(101)=        0.26815934D0
	rhoarr(102)=        0.25064124D0
	rhoarr(103)=        0.23344717D0
	rhoarr(104)=        0.21665052D0
	rhoarr(105)=        0.20031826D0
	rhoarr(106)=        0.18451096D0
	rhoarr(107)=        0.16928291D0
	rhoarr(108)=        0.15468229D0
	rhoarr(109)=        0.14075123D0
	rhoarr(110)=        0.12752579D0
	rhoarr(111)=        0.11503566D0
	rhoarr(112)=        0.10330379D0
	rhoarr(113)=        0.09234593D0
	rhoarr(114)=        0.08217006D0
	rhoarr(115)=        0.07277603D0
	rhoarr(116)=        0.06415533D0
	rhoarr(117)=        0.05629120D0
	rhoarr(118)=        0.04915911D0
	rhoarr(119)=        0.04272759D0
	rhoarr(120)=        0.03695942D0
	rhoarr(121)=        0.03181306D0
	rhoarr(122)=        0.02724416D0
	rhoarr(123)=        0.02320719D0
	rhoarr(124)=        0.01965676D0
	rhoarr(125)=        0.01654885D0
	rhoarr(126)=        0.01384164D0
	rhoarr(127)=        0.01149604D0
	rhoarr(128)=        0.00947585D0
	rhoarr(129)=        0.00774767D0
	rhoarr(130)=        0.00628063D0
	rhoarr(131)=        0.00504597D0
	rhoarr(132)=        0.00401675D0
	rhoarr(133)=        0.00316755D0
	rhoarr(134)=        0.00247436D0
	rhoarr(135)=        0.00191467D0
	rhoarr(136)=        0.00146760D0
	rhoarr(137)=        0.00111413D0
	rhoarr(138)=        0.00083732D0
	rhoarr(139)=        0.00062245D0
	rhoarr(140)=        0.00045702D0
	rhoarr(141)=        0.00033071D0
	rhoarr(142)=        0.00023516D0
	rhoarr(143)=        0.00016368D0
	rhoarr(144)=        0.00011101D0
	rhoarr(145)=        0.00007297D0
	rhoarr(146)=        0.00004620D0
	rhoarr(147)=        0.00002798D0
	rhoarr(148)=        0.00001610D0
	rhoarr(149)=        0.00000872D0
	rhoarr(150)=        0.00000441D0
	rhoarr(151)=        0.00000207D0
	rhoarr(152)=        0.00000088D0
	rhoarr(153)=        0.00000034D0
	rhoarr(154)=        0.00000012D0
	rhoarr(155)=        0.00000004D0

else if (iele== 8) then  !O, 0 3, b3lyp/cc-pVQZ
	npt=  154
	rhoarr(  1)=      305.87538123D0
	rhoarr(  2)=      305.81026254D0
	rhoarr(  3)=      305.52984710D0
	rhoarr(  4)=      304.78943005D0
	rhoarr(  5)=      303.29569435D0
	rhoarr(  6)=      300.79538139D0
	rhoarr(  7)=      297.19820527D0
	rhoarr(  8)=      292.66007267D0
	rhoarr(  9)=      287.52030392D0
	rhoarr( 10)=      282.08116137D0
	rhoarr( 11)=      276.40895220D0
	rhoarr( 12)=      270.36701320D0
	rhoarr( 13)=      263.82874022D0
	rhoarr( 14)=      256.81220845D0
	rhoarr( 15)=      249.43554985D0
	rhoarr( 16)=      241.81452840D0
	rhoarr( 17)=      234.00947526D0
	rhoarr( 18)=      226.02947278D0
	rhoarr( 19)=      217.86539414D0
	rhoarr( 20)=      209.52316280D0
	rhoarr( 21)=      201.03791287D0
	rhoarr( 22)=      192.46635635D0
	rhoarr( 23)=      183.86873846D0
	rhoarr( 24)=      175.29410798D0
	rhoarr( 25)=      166.77554207D0
	rhoarr( 26)=      158.33401982D0
	rhoarr( 27)=      149.98599260D0
	rhoarr( 28)=      141.75000952D0
	rhoarr( 29)=      133.64981321D0
	rhoarr( 30)=      125.71358562D0
	rhoarr( 31)=      117.97068877D0
	rhoarr( 32)=      110.44789560D0
	rhoarr( 33)=      103.16674878D0
	rhoarr( 34)=       96.14275721D0
	rhoarr( 35)=       89.38621355D0
	rhoarr( 36)=       82.90388056D0
	rhoarr( 37)=       76.70072039D0
	rhoarr( 38)=       70.78108477D0
	rhoarr( 39)=       65.14913995D0
	rhoarr( 40)=       59.80861447D0
	rhoarr( 41)=       54.76215051D0
	rhoarr( 42)=       50.01059190D0
	rhoarr( 43)=       45.55247830D0
	rhoarr( 44)=       41.38388621D0
	rhoarr( 45)=       37.49861896D0
	rhoarr( 46)=       33.88864521D0
	rhoarr( 47)=       30.54464007D0
	rhoarr( 48)=       27.45649135D0
	rhoarr( 49)=       24.61367858D0
	rhoarr( 50)=       22.00548934D0
	rhoarr( 51)=       19.62108859D0
	rhoarr( 52)=       17.44948959D0
	rhoarr( 53)=       15.47948657D0
	rhoarr( 54)=       13.69960287D0
	rhoarr( 55)=       12.09808997D0
	rhoarr( 56)=       10.66299004D0
	rhoarr( 57)=        9.38225450D0
	rhoarr( 58)=        8.24389761D0
	rhoarr( 59)=        7.23615884D0
	rhoarr( 60)=        6.34765031D0
	rhoarr( 61)=        5.56747271D0
	rhoarr( 62)=        4.88529268D0
	rhoarr( 63)=        4.29138294D0
	rhoarr( 64)=        3.77663272D0
	rhoarr( 65)=        3.33253864D0
	rhoarr( 66)=        2.95118641D0
	rhoarr( 67)=        2.62523119D0
	rhoarr( 68)=        2.34788123D0
	rhoarr( 69)=        2.11288598D0
	rhoarr( 70)=        1.91452738D0
	rhoarr( 71)=        1.74761148D0
	rhoarr( 72)=        1.60745731D0
	rhoarr( 73)=        1.48988061D0
	rhoarr( 74)=        1.39117134D0
	rhoarr( 75)=        1.30806532D0
	rhoarr( 76)=        1.23771120D0
	rhoarr( 77)=        1.17763498D0
	rhoarr( 78)=        1.12570426D0
	rhoarr( 79)=        1.08009417D0
	rhoarr( 80)=        1.03925623D0
	rhoarr( 81)=        1.00189095D0
	rhoarr( 82)=        0.96692381D0
	rhoarr( 83)=        0.93348422D0
	rhoarr( 84)=        0.90088641D0
	rhoarr( 85)=        0.86861132D0
	rhoarr( 86)=        0.83628869D0
	rhoarr( 87)=        0.80367874D0
	rhoarr( 88)=        0.77065346D0
	rhoarr( 89)=        0.73717753D0
	rhoarr( 90)=        0.70328943D0
	rhoarr( 91)=        0.66908326D0
	rhoarr( 92)=        0.63469198D0
	rhoarr( 93)=        0.60027249D0
	rhoarr( 94)=        0.56599306D0
	rhoarr( 95)=        0.53202328D0
	rhoarr( 96)=        0.49852655D0
	rhoarr( 97)=        0.46565492D0
	rhoarr( 98)=        0.43354605D0
	rhoarr( 99)=        0.40232185D0
	rhoarr(100)=        0.37208844D0
	rhoarr(101)=        0.34293695D0
	rhoarr(102)=        0.31494485D0
	rhoarr(103)=        0.28817742D0
	rhoarr(104)=        0.26268907D0
	rhoarr(105)=        0.23852434D0
	rhoarr(106)=        0.21571846D0
	rhoarr(107)=        0.19429734D0
	rhoarr(108)=        0.17427722D0
	rhoarr(109)=        0.15566391D0
	rhoarr(110)=        0.13845190D0
	rhoarr(111)=        0.12262367D0
	rhoarr(112)=        0.10814926D0
	rhoarr(113)=        0.09498641D0
	rhoarr(114)=        0.08308130D0
	rhoarr(115)=        0.07236999D0
	rhoarr(116)=        0.06278038D0
	rhoarr(117)=        0.05423461D0
	rhoarr(118)=        0.04665164D0
	rhoarr(119)=        0.03994978D0
	rhoarr(120)=        0.03404902D0
	rhoarr(121)=        0.02887289D0
	rhoarr(122)=        0.02434980D0
	rhoarr(123)=        0.02041379D0
	rhoarr(124)=        0.01700475D0
	rhoarr(125)=        0.01406813D0
	rhoarr(126)=        0.01155432D0
	rhoarr(127)=        0.00941788D0
	rhoarr(128)=        0.00761675D0
	rhoarr(129)=        0.00611160D0
	rhoarr(130)=        0.00486545D0
	rhoarr(131)=        0.00384346D0
	rhoarr(132)=        0.00301312D0
	rhoarr(133)=        0.00234444D0
	rhoarr(134)=        0.00181028D0
	rhoarr(135)=        0.00138660D0
	rhoarr(136)=        0.00105264D0
	rhoarr(137)=        0.00079086D0
	rhoarr(138)=        0.00058681D0
	rhoarr(139)=        0.00042879D0
	rhoarr(140)=        0.00030748D0
	rhoarr(141)=        0.00021548D0
	rhoarr(142)=        0.00014687D0
	rhoarr(143)=        0.00009684D0
	rhoarr(144)=        0.00006142D0
	rhoarr(145)=        0.00003723D0
	rhoarr(146)=        0.00002143D0
	rhoarr(147)=        0.00001162D0
	rhoarr(148)=        0.00000589D0
	rhoarr(149)=        0.00000277D0
	rhoarr(150)=        0.00000119D0
	rhoarr(151)=        0.00000047D0
	rhoarr(152)=        0.00000016D0
	rhoarr(153)=        0.00000005D0
	rhoarr(154)=        0.00000001D0

else if (iele== 9) then  !F, 0 2, b3lyp/cc-pVQZ
	npt=  152
	rhoarr(  1)=      439.49314565D0
	rhoarr(  2)=      439.37871737D0
	rhoarr(  3)=      438.88665385D0
	rhoarr(  4)=      437.59277045D0
	rhoarr(  5)=      435.00610239D0
	rhoarr(  6)=      430.74624119D0
	rhoarr(  7)=      424.76516096D0
	rhoarr(  8)=      417.44036808D0
	rhoarr(  9)=      409.35526391D0
	rhoarr( 10)=      400.86721146D0
	rhoarr( 11)=      391.90029495D0
	rhoarr( 12)=      382.20063676D0
	rhoarr( 13)=      371.69565896D0
	rhoarr( 14)=      360.54339773D0
	rhoarr( 15)=      348.95691077D0
	rhoarr( 16)=      337.06875689D0
	rhoarr( 17)=      324.91256042D0
	rhoarr( 18)=      312.47579133D0
	rhoarr( 19)=      299.76391558D0
	rhoarr( 20)=      286.83230673D0
	rhoarr( 21)=      273.77557974D0
	rhoarr( 22)=      260.69510655D0
	rhoarr( 23)=      247.67224189D0
	rhoarr( 24)=      234.76050499D0
	rhoarr( 25)=      221.99363115D0
	rhoarr( 26)=      209.39945322D0
	rhoarr( 27)=      197.01085442D0
	rhoarr( 28)=      184.86957997D0
	rhoarr( 29)=      173.02324623D0
	rhoarr( 30)=      161.51880425D0
	rhoarr( 31)=      150.39632735D0
	rhoarr( 32)=      139.68568933D0
	rhoarr( 33)=      129.40666868D0
	rhoarr( 34)=      119.57143154D0
	rhoarr( 35)=      110.18775111D0
	rhoarr( 36)=      101.26158398D0
	rhoarr( 37)=       92.79830588D0
	rhoarr( 38)=       84.80260330D0
	rhoarr( 39)=       77.27748745D0
	rhoarr( 40)=       70.22306849D0
	rhoarr( 41)=       63.63563815D0
	rhoarr( 42)=       57.50736273D0
	rhoarr( 43)=       51.82661071D0
	rhoarr( 44)=       46.57873055D0
	rhoarr( 45)=       41.74700355D0
	rhoarr( 46)=       37.31351739D0
	rhoarr( 47)=       33.25979767D0
	rhoarr( 48)=       29.56714728D0
	rhoarr( 49)=       26.21673734D0
	rhoarr( 50)=       23.18954825D0
	rhoarr( 51)=       20.46627124D0
	rhoarr( 52)=       18.02725954D0
	rhoarr( 53)=       15.85257866D0
	rhoarr( 54)=       13.92216267D0
	rhoarr( 55)=       12.21605021D0
	rhoarr( 56)=       10.71465611D0
	rhoarr( 57)=        9.39903297D0
	rhoarr( 58)=        8.25108694D0
	rhoarr( 59)=        7.25372893D0
	rhoarr( 60)=        6.39095851D0
	rhoarr( 61)=        5.64789090D0
	rhoarr( 62)=        5.01074407D0
	rhoarr( 63)=        4.46680413D0
	rhoarr( 64)=        4.00438368D0
	rhoarr( 65)=        3.61278242D0
	rhoarr( 66)=        3.28225324D0
	rhoarr( 67)=        3.00397247D0
	rhoarr( 68)=        2.77001043D0
	rhoarr( 69)=        2.57329787D0
	rhoarr( 70)=        2.40758508D0
	rhoarr( 71)=        2.26739257D0
	rhoarr( 72)=        2.14795417D0
	rhoarr( 73)=        2.04515540D0
	rhoarr( 74)=        1.95547036D0
	rhoarr( 75)=        1.87590074D0
	rhoarr( 76)=        1.80391962D0
	rhoarr( 77)=        1.73742148D0
	rhoarr( 78)=        1.67467886D0
	rhoarr( 79)=        1.61430476D0
	rhoarr( 80)=        1.55521926D0
	rhoarr( 81)=        1.49661854D0
	rhoarr( 82)=        1.43794478D0
	rhoarr( 83)=        1.37885552D0
	rhoarr( 84)=        1.31919223D0
	rhoarr( 85)=        1.25894794D0
	rhoarr( 86)=        1.19823488D0
	rhoarr( 87)=        1.13725293D0
	rhoarr( 88)=        1.07626037D0
	rhoarr( 89)=        1.01554764D0
	rhoarr( 90)=        0.95541544D0
	rhoarr( 91)=        0.89615730D0
	rhoarr( 92)=        0.83804691D0
	rhoarr( 93)=        0.78133000D0
	rhoarr( 94)=        0.72622017D0
	rhoarr( 95)=        0.67289800D0
	rhoarr( 96)=        0.62151249D0
	rhoarr( 97)=        0.57218422D0
	rhoarr( 98)=        0.52500918D0
	rhoarr( 99)=        0.48006277D0
	rhoarr(100)=        0.43740332D0
	rhoarr(101)=        0.39707480D0
	rhoarr(102)=        0.35910839D0
	rhoarr(103)=        0.32352297D0
	rhoarr(104)=        0.29032454D0
	rhoarr(105)=        0.25950497D0
	rhoarr(106)=        0.23104034D0
	rhoarr(107)=        0.20488942D0
	rhoarr(108)=        0.18099261D0
	rhoarr(109)=        0.15927188D0
	rhoarr(110)=        0.13963163D0
	rhoarr(111)=        0.12196081D0
	rhoarr(112)=        0.10613596D0
	rhoarr(113)=        0.09202495D0
	rhoarr(114)=        0.07949114D0
	rhoarr(115)=        0.06839750D0
	rhoarr(116)=        0.05861037D0
	rhoarr(117)=        0.05000252D0
	rhoarr(118)=        0.04245542D0
	rhoarr(119)=        0.03586050D0
	rhoarr(120)=        0.03011954D0
	rhoarr(121)=        0.02514422D0
	rhoarr(122)=        0.02085513D0
	rhoarr(123)=        0.01718036D0
	rhoarr(124)=        0.01405403D0
	rhoarr(125)=        0.01141507D0
	rhoarr(126)=        0.00920618D0
	rhoarr(127)=        0.00737338D0
	rhoarr(128)=        0.00586586D0
	rhoarr(129)=        0.00463625D0
	rhoarr(130)=        0.00364100D0
	rhoarr(131)=        0.00284087D0
	rhoarr(132)=        0.00220126D0
	rhoarr(133)=        0.00169239D0
	rhoarr(134)=        0.00128919D0
	rhoarr(135)=        0.00097104D0
	rhoarr(136)=        0.00072128D0
	rhoarr(137)=        0.00052662D0
	rhoarr(138)=        0.00037649D0
	rhoarr(139)=        0.00026242D0
	rhoarr(140)=        0.00017749D0
	rhoarr(141)=        0.00011588D0
	rhoarr(142)=        0.00007264D0
	rhoarr(143)=        0.00004346D0
	rhoarr(144)=        0.00002466D0
	rhoarr(145)=        0.00001318D0
	rhoarr(146)=        0.00000659D0
	rhoarr(147)=        0.00000305D0
	rhoarr(148)=        0.00000130D0
	rhoarr(149)=        0.00000050D0
	rhoarr(150)=        0.00000017D0
	rhoarr(151)=        0.00000005D0
	rhoarr(152)=        0.00000001D0

else if (iele==10) then  !Ne, 0 1, b3lyp/cc-pVQZ
	npt=  150
	rhoarr(  1)=      608.51802686D0
	rhoarr(  2)=      608.31236434D0
	rhoarr(  3)=      607.43044177D0
	rhoarr(  4)=      605.13044226D0
	rhoarr(  5)=      600.61414216D0
	rhoarr(  6)=      593.40735672D0
	rhoarr(  7)=      583.73847470D0
	rhoarr(  8)=      572.48170752D0
	rhoarr(  9)=      560.47062982D0
	rhoarr( 10)=      547.82558757D0
	rhoarr( 11)=      534.14135125D0
	rhoarr( 12)=      519.20079337D0
	rhoarr( 13)=      503.21549817D0
	rhoarr( 14)=      486.53225496D0
	rhoarr( 15)=      469.36474450D0
	rhoarr( 16)=      451.75723204D0
	rhoarr( 17)=      433.68759099D0
	rhoarr( 18)=      415.18130244D0
	rhoarr( 19)=      396.35223486D0
	rhoarr( 20)=      377.36546708D0
	rhoarr( 21)=      358.37592381D0
	rhoarr( 22)=      339.49303156D0
	rhoarr( 23)=      320.78311656D0
	rhoarr( 24)=      302.29307214D0
	rhoarr( 25)=      284.07413588D0
	rhoarr( 26)=      266.19306782D0
	rhoarr( 27)=      248.72889298D0
	rhoarr( 28)=      231.76115598D0
	rhoarr( 29)=      215.35798609D0
	rhoarr( 30)=      199.56973455D0
	rhoarr( 31)=      184.42940564D0
	rhoarr( 32)=      169.95757902D0
	rhoarr( 33)=      156.16835321D0
	rhoarr( 34)=      143.07361463D0
	rhoarr( 35)=      130.68452453D0
	rhoarr( 36)=      119.01056658D0
	rhoarr( 37)=      108.05733335D0
	rhoarr( 38)=       97.82436738D0
	rhoarr( 39)=       88.30398635D0
	rhoarr( 40)=       79.48140874D0
	rhoarr( 41)=       71.33594851D0
	rhoarr( 42)=       63.84274309D0
	rhoarr( 43)=       56.97445113D0
	rhoarr( 44)=       50.70252553D0
	rhoarr( 45)=       44.99791124D0
	rhoarr( 46)=       39.83123410D0
	rhoarr( 47)=       35.17267688D0
	rhoarr( 48)=       30.99177179D0
	rhoarr( 49)=       27.25729428D0
	rhoarr( 50)=       23.93735682D0
	rhoarr( 51)=       20.99971117D0
	rhoarr( 52)=       18.41219924D0
	rhoarr( 53)=       16.14326029D0
	rhoarr( 54)=       14.16240425D0
	rhoarr( 55)=       12.44058682D0
	rhoarr( 56)=       10.95045762D0
	rhoarr( 57)=        9.66648561D0
	rhoarr( 58)=        8.56498811D0
	rhoarr( 59)=        7.62409896D0
	rhoarr( 60)=        6.82370884D0
	rhoarr( 61)=        6.14540155D0
	rhoarr( 62)=        5.57239759D0
	rhoarr( 63)=        5.08950589D0
	rhoarr( 64)=        4.68307738D0
	rhoarr( 65)=        4.34095215D0
	rhoarr( 66)=        4.05239280D0
	rhoarr( 67)=        3.80800097D0
	rhoarr( 68)=        3.59961809D0
	rhoarr( 69)=        3.42021516D0
	rhoarr( 70)=        3.26377842D0
	rhoarr( 71)=        3.12519798D0
	rhoarr( 72)=        3.00016520D0
	rhoarr( 73)=        2.88508235D0
	rhoarr( 74)=        2.77698566D0
	rhoarr( 75)=        2.67348042D0
	rhoarr( 76)=        2.57268531D0
	rhoarr( 77)=        2.47318236D0
	rhoarr( 78)=        2.37396921D0
	rhoarr( 79)=        2.27441074D0
	rhoarr( 80)=        2.17418883D0
	rhoarr( 81)=        2.07324983D0
	rhoarr( 82)=        1.97175078D0
	rhoarr( 83)=        1.87000601D0
	rhoarr( 84)=        1.76843630D0
	rhoarr( 85)=        1.66752274D0
	rhoarr( 86)=        1.56776698D0
	rhoarr( 87)=        1.46965928D0
	rhoarr( 88)=        1.37365472D0
	rhoarr( 89)=        1.28015752D0
	rhoarr( 90)=        1.18951273D0
	rhoarr( 91)=        1.10200412D0
	rhoarr( 92)=        1.01785683D0
	rhoarr( 93)=        0.93724338D0
	rhoarr( 94)=        0.86029139D0
	rhoarr( 95)=        0.78709190D0
	rhoarr( 96)=        0.71770700D0
	rhoarr( 97)=        0.65217613D0
	rhoarr( 98)=        0.59052039D0
	rhoarr( 99)=        0.53274467D0
	rhoarr(100)=        0.47883774D0
	rhoarr(101)=        0.42877074D0
	rhoarr(102)=        0.38249452D0
	rhoarr(103)=        0.33993688D0
	rhoarr(104)=        0.30100011D0
	rhoarr(105)=        0.26555993D0
	rhoarr(106)=        0.23346586D0
	rhoarr(107)=        0.20454356D0
	rhoarr(108)=        0.17859876D0
	rhoarr(109)=        0.15542264D0
	rhoarr(110)=        0.13479801D0
	rhoarr(111)=        0.11650567D0
	rhoarr(112)=        0.10033053D0
	rhoarr(113)=        0.08606677D0
	rhoarr(114)=        0.07352178D0
	rhoarr(115)=        0.06251877D0
	rhoarr(116)=        0.05289781D0
	rhoarr(117)=        0.04451562D0
	rhoarr(118)=        0.03724424D0
	rhoarr(119)=        0.03096897D0
	rhoarr(120)=        0.02558605D0
	rhoarr(121)=        0.02100030D0
	rhoarr(122)=        0.01712320D0
	rhoarr(123)=        0.01387161D0
	rhoarr(124)=        0.01116708D0
	rhoarr(125)=        0.00893580D0
	rhoarr(126)=        0.00710904D0
	rhoarr(127)=        0.00562375D0
	rhoarr(128)=        0.00442323D0
	rhoarr(129)=        0.00345756D0
	rhoarr(130)=        0.00268380D0
	rhoarr(131)=        0.00206581D0
	rhoarr(132)=        0.00157386D0
	rhoarr(133)=        0.00118387D0
	rhoarr(134)=        0.00087660D0
	rhoarr(135)=        0.00063672D0
	rhoarr(136)=        0.00045190D0
	rhoarr(137)=        0.00031206D0
	rhoarr(138)=        0.00020872D0
	rhoarr(139)=        0.00013455D0
	rhoarr(140)=        0.00008317D0
	rhoarr(141)=        0.00004902D0
	rhoarr(142)=        0.00002739D0
	rhoarr(143)=        0.00001441D0
	rhoarr(144)=        0.00000709D0
	rhoarr(145)=        0.00000324D0
	rhoarr(146)=        0.00000136D0
	rhoarr(147)=        0.00000052D0
	rhoarr(148)=        0.00000018D0
	rhoarr(149)=        0.00000005D0
	rhoarr(150)=        0.00000001D0

else if (iele==11) then  !Na, 0 2, b3lyp/cc-pVQZ
	npt=  169
	rhoarr(  1)=      828.50308168D0
	rhoarr(  2)=      827.45115183D0
	rhoarr(  3)=      823.41633505D0
	rhoarr(  4)=      815.53785640D0
	rhoarr(  5)=      805.55801224D0
	rhoarr(  6)=      793.96076710D0
	rhoarr(  7)=      780.05707014D0
	rhoarr(  8)=      764.36837359D0
	rhoarr(  9)=      747.12111860D0
	rhoarr( 10)=      728.17228957D0
	rhoarr( 11)=      707.69068158D0
	rhoarr( 12)=      685.96567285D0
	rhoarr( 13)=      663.11499448D0
	rhoarr( 14)=      639.20617240D0
	rhoarr( 15)=      614.40357298D0
	rhoarr( 16)=      588.92363824D0
	rhoarr( 17)=      562.94159571D0
	rhoarr( 18)=      536.58550901D0
	rhoarr( 19)=      509.98485413D0
	rhoarr( 20)=      483.29507354D0
	rhoarr( 21)=      456.68092322D0
	rhoarr( 22)=      430.29021550D0
	rhoarr( 23)=      404.24560067D0
	rhoarr( 24)=      378.65420237D0
	rhoarr( 25)=      353.61937376D0
	rhoarr( 26)=      329.24349383D0
	rhoarr( 27)=      305.62237439D0
	rhoarr( 28)=      282.83816853D0
	rhoarr( 29)=      260.95633134D0
	rhoarr( 30)=      240.02739658D0
	rhoarr( 31)=      220.09083890D0
	rhoarr( 32)=      201.17794323D0
	rhoarr( 33)=      183.31237852D0
	rhoarr( 34)=      166.50909979D0
	rhoarr( 35)=      150.77304338D0
	rhoarr( 36)=      136.09876325D0
	rhoarr( 37)=      122.47129776D0
	rhoarr( 38)=      109.86782845D0
	rhoarr( 39)=       98.25943841D0
	rhoarr( 40)=       87.61246167D0
	rhoarr( 41)=       77.88928808D0
	rhoarr( 42)=       69.04879615D0
	rhoarr( 43)=       61.04670163D0
	rhoarr( 44)=       53.83604536D0
	rhoarr( 45)=       47.36789201D0
	rhoarr( 46)=       41.59217141D0
	rhoarr( 47)=       36.45852668D0
	rhoarr( 48)=       31.91704385D0
	rhoarr( 49)=       27.91879877D0
	rhoarr( 50)=       24.41622694D0
	rhoarr( 51)=       21.36336964D0
	rhoarr( 52)=       18.71606283D0
	rhoarr( 53)=       16.43211949D0
	rhoarr( 54)=       14.47152619D0
	rhoarr( 55)=       12.79664591D0
	rhoarr( 56)=       11.37240242D0
	rhoarr( 57)=       10.16641870D0
	rhoarr( 58)=        9.14908997D0
	rhoarr( 59)=        8.29358558D0
	rhoarr( 60)=        7.57578628D0
	rhoarr( 61)=        6.97417154D0
	rhoarr( 62)=        6.46967431D0
	rhoarr( 63)=        6.04551844D0
	rhoarr( 64)=        5.68704986D0
	rhoarr( 65)=        5.38156828D0
	rhoarr( 66)=        5.11816231D0
	rhoarr( 67)=        4.88754947D0
	rhoarr( 68)=        4.68192189D0
	rhoarr( 69)=        4.49479829D0
	rhoarr( 70)=        4.32088360D0
	rhoarr( 71)=        4.15593681D0
	rhoarr( 72)=        3.99664748D0
	rhoarr( 73)=        3.84052049D0
	rhoarr( 74)=        3.68576798D0
	rhoarr( 75)=        3.53120729D0
	rhoarr( 76)=        3.37616367D0
	rhoarr( 77)=        3.22037766D0
	rhoarr( 78)=        3.06391732D0
	rhoarr( 79)=        2.90709674D0
	rhoarr( 80)=        2.75040245D0
	rhoarr( 81)=        2.59442964D0
	rhoarr( 82)=        2.43982943D0
	rhoarr( 83)=        2.28726776D0
	rhoarr( 84)=        2.13739574D0
	rhoarr( 85)=        1.99082994D0
	rhoarr( 86)=        1.84814088D0
	rhoarr( 87)=        1.70984739D0
	rhoarr( 88)=        1.57641439D0
	rhoarr( 89)=        1.44825231D0
	rhoarr( 90)=        1.32571651D0
	rhoarr( 91)=        1.20910600D0
	rhoarr( 92)=        1.09866114D0
	rhoarr( 93)=        0.99456084D0
	rhoarr( 94)=        0.89691977D0
	rhoarr( 95)=        0.80578657D0
	rhoarr( 96)=        0.72114373D0
	rhoarr( 97)=        0.64290966D0
	rhoarr( 98)=        0.57094324D0
	rhoarr( 99)=        0.50505061D0
	rhoarr(100)=        0.44499370D0
	rhoarr(101)=        0.39049983D0
	rhoarr(102)=        0.34127156D0
	rhoarr(103)=        0.29699589D0
	rhoarr(104)=        0.25735235D0
	rhoarr(105)=        0.22201939D0
	rhoarr(106)=        0.19067913D0
	rhoarr(107)=        0.16302033D0
	rhoarr(108)=        0.13874016D0
	rhoarr(109)=        0.11754506D0
	rhoarr(110)=        0.09915111D0
	rhoarr(111)=        0.08328460D0
	rhoarr(112)=        0.06968265D0
	rhoarr(113)=        0.05809443D0
	rhoarr(114)=        0.04828260D0
	rhoarr(115)=        0.04002494D0
	rhoarr(116)=        0.03311598D0
	rhoarr(117)=        0.02736817D0
	rhoarr(118)=        0.02261262D0
	rhoarr(119)=        0.01869917D0
	rhoarr(120)=        0.01549586D0
	rhoarr(121)=        0.01288776D0
	rhoarr(122)=        0.01077554D0
	rhoarr(123)=        0.00907372D0
	rhoarr(124)=        0.00770897D0
	rhoarr(125)=        0.00661854D0
	rhoarr(126)=        0.00574883D0
	rhoarr(127)=        0.00505434D0
	rhoarr(128)=        0.00449676D0
	rhoarr(129)=        0.00404423D0
	rhoarr(130)=        0.00367069D0
	rhoarr(131)=        0.00335532D0
	rhoarr(132)=        0.00308188D0
	rhoarr(133)=        0.00283811D0
	rhoarr(134)=        0.00261507D0
	rhoarr(135)=        0.00240654D0
	rhoarr(136)=        0.00220841D0
	rhoarr(137)=        0.00201821D0
	rhoarr(138)=        0.00183464D0
	rhoarr(139)=        0.00165723D0
	rhoarr(140)=        0.00148610D0
	rhoarr(141)=        0.00132171D0
	rhoarr(142)=        0.00116479D0
	rhoarr(143)=        0.00101616D0
	rhoarr(144)=        0.00087672D0
	rhoarr(145)=        0.00074732D0
	rhoarr(146)=        0.00062871D0
	rhoarr(147)=        0.00052149D0
	rhoarr(148)=        0.00042604D0
	rhoarr(149)=        0.00034245D0
	rhoarr(150)=        0.00027055D0
	rhoarr(151)=        0.00020988D0
	rhoarr(152)=        0.00015971D0
	rhoarr(153)=        0.00011912D0
	rhoarr(154)=        0.00008700D0
	rhoarr(155)=        0.00006217D0
	rhoarr(156)=        0.00004343D0
	rhoarr(157)=        0.00002963D0
	rhoarr(158)=        0.00001971D0
	rhoarr(159)=        0.00001277D0
	rhoarr(160)=        0.00000803D0
	rhoarr(161)=        0.00000489D0
	rhoarr(162)=        0.00000287D0
	rhoarr(163)=        0.00000161D0
	rhoarr(164)=        0.00000087D0
	rhoarr(165)=        0.00000044D0
	rhoarr(166)=        0.00000021D0
	rhoarr(167)=        0.00000009D0
	rhoarr(168)=        0.00000004D0
	rhoarr(169)=        0.00000001D0

else if (iele==12) then  !Mg, 0 1, b3lyp/cc-pVQZ
	npt=  166
	rhoarr(  1)=     1080.30165890D0
	rhoarr(  2)=     1079.51463725D0
	rhoarr(  3)=     1076.21925169D0
	rhoarr(  4)=     1068.19382674D0
	rhoarr(  5)=     1054.48371614D0
	rhoarr(  6)=     1036.69183997D0
	rhoarr(  7)=     1017.01958103D0
	rhoarr(  8)=      995.36610476D0
	rhoarr(  9)=      970.77331035D0
	rhoarr( 10)=      943.61396368D0
	rhoarr( 11)=      914.70333171D0
	rhoarr( 12)=      884.29291358D0
	rhoarr( 13)=      852.28121732D0
	rhoarr( 14)=      818.74738468D0
	rhoarr( 15)=      784.06193441D0
	rhoarr( 16)=      748.63224578D0
	rhoarr( 17)=      712.71468950D0
	rhoarr( 18)=      676.44811200D0
	rhoarr( 19)=      639.97560895D0
	rhoarr( 20)=      603.51016869D0
	rhoarr( 21)=      567.31077047D0
	rhoarr( 22)=      531.62058060D0
	rhoarr( 23)=      496.62825274D0
	rhoarr( 24)=      462.47165254D0
	rhoarr( 25)=      429.26482372D0
	rhoarr( 26)=      397.12099235D0
	rhoarr( 27)=      366.15796003D0
	rhoarr( 28)=      336.48847165D0
	rhoarr( 29)=      308.20628121D0
	rhoarr( 30)=      281.37748341D0
	rhoarr( 31)=      256.04049852D0
	rhoarr( 32)=      232.21225822D0
	rhoarr( 33)=      209.89575942D0
	rhoarr( 34)=      189.08518615D0
	rhoarr( 35)=      169.76736549D0
	rhoarr( 36)=      151.92054670D0
	rhoarr( 37)=      135.51245290D0
	rhoarr( 38)=      120.49928801D0
	rhoarr( 39)=      106.82644472D0
	rhoarr( 40)=       94.43069210D0
	rhoarr( 41)=       83.24304938D0
	rhoarr( 42)=       73.19148738D0
	rhoarr( 43)=       64.20289903D0
	rhoarr( 44)=       56.20420261D0
	rhoarr( 45)=       49.12277874D0
	rhoarr( 46)=       42.88659529D0
	rhoarr( 47)=       37.42434851D0
	rhoarr( 48)=       32.66581261D0
	rhoarr( 49)=       28.54242978D0
	rhoarr( 50)=       24.98805052D0
	rhoarr( 51)=       21.93968183D0
	rhoarr( 52)=       19.33811260D0
	rhoarr( 53)=       17.12833727D0
	rhoarr( 54)=       15.25976133D0
	rhoarr( 55)=       13.68622071D0
	rhoarr( 56)=       12.36587261D0
	rhoarr( 57)=       11.26101612D0
	rhoarr( 58)=       10.33788676D0
	rhoarr( 59)=        9.56644862D0
	rhoarr( 60)=        8.92018976D0
	rhoarr( 61)=        8.37591624D0
	rhoarr( 62)=        7.91353729D0
	rhoarr( 63)=        7.51583684D0
	rhoarr( 64)=        7.16823264D0
	rhoarr( 65)=        6.85852841D0
	rhoarr( 66)=        6.57666761D0
	rhoarr( 67)=        6.31449635D0
	rhoarr( 68)=        6.06554115D0
	rhoarr( 69)=        5.82480324D0
	rhoarr( 70)=        5.58856837D0
	rhoarr( 71)=        5.35422928D0
	rhoarr( 72)=        5.12011751D0
	rhoarr( 73)=        4.88534277D0
	rhoarr( 74)=        4.64963964D0
	rhoarr( 75)=        4.41322368D0
	rhoarr( 76)=        4.17666002D0
	rhoarr( 77)=        3.94074823D0
	rhoarr( 78)=        3.70642626D0
	rhoarr( 79)=        3.47469493D0
	rhoarr( 80)=        3.24656262D0
	rhoarr( 81)=        3.02300784D0
	rhoarr( 82)=        2.80495619D0
	rhoarr( 83)=        2.59326747D0
	rhoarr( 84)=        2.38872863D0
	rhoarr( 85)=        2.19204922D0
	rhoarr( 86)=        2.00385660D0
	rhoarr( 87)=        1.82468992D0
	rhoarr( 88)=        1.65499273D0
	rhoarr( 89)=        1.49510515D0
	rhoarr( 90)=        1.34525700D0
	rhoarr( 91)=        1.20556348D0
	rhoarr( 92)=        1.07602461D0
	rhoarr( 93)=        0.95652928D0
	rhoarr( 94)=        0.84686383D0
	rhoarr( 95)=        0.74672465D0
	rhoarr( 96)=        0.65573363D0
	rhoarr( 97)=        0.57345504D0
	rhoarr( 98)=        0.49941236D0
	rhoarr( 99)=        0.43310365D0
	rhoarr(100)=        0.37401468D0
	rhoarr(101)=        0.32162907D0
	rhoarr(102)=        0.27543560D0
	rhoarr(103)=        0.23493290D0
	rhoarr(104)=        0.19963225D0
	rhoarr(105)=        0.16905915D0
	rhoarr(106)=        0.14275451D0
	rhoarr(107)=        0.12027592D0
	rhoarr(108)=        0.10119944D0
	rhoarr(109)=        0.08512193D0
	rhoarr(110)=        0.07166373D0
	rhoarr(111)=        0.06047143D0
	rhoarr(112)=        0.05122032D0
	rhoarr(113)=        0.04361616D0
	rhoarr(114)=        0.03739604D0
	rhoarr(115)=        0.03232817D0
	rhoarr(116)=        0.02821073D0
	rhoarr(117)=        0.02486992D0
	rhoarr(118)=        0.02215738D0
	rhoarr(119)=        0.01994745D0
	rhoarr(120)=        0.01813436D0
	rhoarr(121)=        0.01662968D0
	rhoarr(122)=        0.01536007D0
	rhoarr(123)=        0.01426543D0
	rhoarr(124)=        0.01329733D0
	rhoarr(125)=        0.01241768D0
	rhoarr(126)=        0.01159755D0
	rhoarr(127)=        0.01081603D0
	rhoarr(128)=        0.01005903D0
	rhoarr(129)=        0.00931818D0
	rhoarr(130)=        0.00858963D0
	rhoarr(131)=        0.00787299D0
	rhoarr(132)=        0.00717028D0
	rhoarr(133)=        0.00648504D0
	rhoarr(134)=        0.00582165D0
	rhoarr(135)=        0.00518474D0
	rhoarr(136)=        0.00457872D0
	rhoarr(137)=        0.00400760D0
	rhoarr(138)=        0.00347473D0
	rhoarr(139)=        0.00298274D0
	rhoarr(140)=        0.00253344D0
	rhoarr(141)=        0.00212785D0
	rhoarr(142)=        0.00176614D0
	rhoarr(143)=        0.00144768D0
	rhoarr(144)=        0.00117106D0
	rhoarr(145)=        0.00093418D0
	rhoarr(146)=        0.00073433D0
	rhoarr(147)=        0.00056834D0
	rhoarr(148)=        0.00043271D0
	rhoarr(149)=        0.00032376D0
	rhoarr(150)=        0.00023779D0
	rhoarr(151)=        0.00017123D0
	rhoarr(152)=        0.00012071D0
	rhoarr(153)=        0.00008316D0
	rhoarr(154)=        0.00005589D0
	rhoarr(155)=        0.00003657D0
	rhoarr(156)=        0.00002323D0
	rhoarr(157)=        0.00001429D0
	rhoarr(158)=        0.00000849D0
	rhoarr(159)=        0.00000485D0
	rhoarr(160)=        0.00000265D0
	rhoarr(161)=        0.00000138D0
	rhoarr(162)=        0.00000067D0
	rhoarr(163)=        0.00000031D0
	rhoarr(164)=        0.00000013D0
	rhoarr(165)=        0.00000005D0
	rhoarr(166)=        0.00000002D0

else if (iele==13) then  !Al, 0 2, b3lyp/cc-pVQZ
	npt=  166
	rhoarr(  1)=     1386.48869887D0
	rhoarr(  2)=     1385.25230980D0
	rhoarr(  3)=     1380.12442057D0
	rhoarr(  4)=     1367.96167977D0
	rhoarr(  5)=     1348.17084388D0
	rhoarr(  6)=     1323.82004407D0
	rhoarr(  7)=     1297.15072714D0
	rhoarr(  8)=     1266.97751488D0
	rhoarr(  9)=     1232.73579088D0
	rhoarr( 10)=     1195.57103041D0
	rhoarr( 11)=     1156.21836312D0
	rhoarr( 12)=     1114.61210069D0
	rhoarr( 13)=     1070.74408353D0
	rhoarr( 14)=     1025.08060327D0
	rhoarr( 15)=      978.22772226D0
	rhoarr( 16)=      930.57889377D0
	rhoarr( 17)=      882.33884456D0
	rhoarr( 18)=      833.72009996D0
	rhoarr( 19)=      785.04531260D0
	rhoarr( 20)=      736.69848446D0
	rhoarr( 21)=      689.02501558D0
	rhoarr( 22)=      642.28330947D0
	rhoarr( 23)=      596.66556314D0
	rhoarr( 24)=      552.34373756D0
	rhoarr( 25)=      509.49676510D0
	rhoarr( 26)=      468.30640270D0
	rhoarr( 27)=      428.93527861D0
	rhoarr( 28)=      391.50737267D0
	rhoarr( 29)=      356.10250536D0
	rhoarr( 30)=      322.76387365D0
	rhoarr( 31)=      291.51046810D0
	rhoarr( 32)=      262.34651303D0
	rhoarr( 33)=      235.26464246D0
	rhoarr( 34)=      210.24409551D0
	rhoarr( 35)=      187.24739629D0
	rhoarr( 36)=      166.21862169D0
	rhoarr( 37)=      147.08459286D0
	rhoarr( 38)=      129.75850772D0
	rhoarr( 39)=      114.14453700D0
	rhoarr( 40)=      100.14190777D0
	rhoarr( 41)=       87.64764785D0
	rhoarr( 42)=       76.55794807D0
	rhoarr( 43)=       66.76863668D0
	rhoarr( 44)=       58.17541543D0
	rhoarr( 45)=       50.67435044D0
	rhoarr( 46)=       44.16280964D0
	rhoarr( 47)=       38.54075725D0
	rhoarr( 48)=       33.71215301D0
	rhoarr( 49)=       29.58618304D0
	rhoarr( 50)=       26.07813287D0
	rhoarr( 51)=       23.10983986D0
	rhoarr( 52)=       20.60977479D0
	rhoarr( 53)=       18.51286851D0
	rhoarr( 54)=       16.76021213D0
	rhoarr( 55)=       15.29873228D0
	rhoarr( 56)=       14.08089741D0
	rhoarr( 57)=       13.06446680D0
	rhoarr( 58)=       12.21226472D0
	rhoarr( 59)=       11.49195052D0
	rhoarr( 60)=       10.87575893D0
	rhoarr( 61)=       10.34019733D0
	rhoarr( 62)=        9.86570000D0
	rhoarr( 63)=        9.43625005D0
	rhoarr( 64)=        9.03898494D0
	rhoarr( 65)=        8.66380145D0
	rhoarr( 66)=        8.30297374D0
	rhoarr( 67)=        7.95079380D0
	rhoarr( 68)=        7.60323984D0
	rhoarr( 69)=        7.25767615D0
	rhoarr( 70)=        6.91258563D0
	rhoarr( 71)=        6.56733589D0
	rhoarr( 72)=        6.22197860D0
	rhoarr( 73)=        5.87708101D0
	rhoarr( 74)=        5.53358710D0
	rhoarr( 75)=        5.19270483D0
	rhoarr( 76)=        4.85581469D0
	rhoarr( 77)=        4.52439483D0
	rhoarr( 78)=        4.19995794D0
	rhoarr( 79)=        3.88399656D0
	rhoarr( 80)=        3.57793448D0
	rhoarr( 81)=        3.28308372D0
	rhoarr( 82)=        3.00060766D0
	rhoarr( 83)=        2.73149167D0
	rhoarr( 84)=        2.47652263D0
	rhoarr( 85)=        2.23627849D0
	rhoarr( 86)=        2.01112787D0
	rhoarr( 87)=        1.80123884D0
	rhoarr( 88)=        1.60659524D0
	rhoarr( 89)=        1.42701785D0
	rhoarr( 90)=        1.26218812D0
	rhoarr( 91)=        1.11167178D0
	rhoarr( 92)=        0.97494069D0
	rhoarr( 93)=        0.85139182D0
	rhoarr( 94)=        0.74036302D0
	rhoarr( 95)=        0.64114601D0
	rhoarr( 96)=        0.55299728D0
	rhoarr( 97)=        0.47514799D0
	rhoarr( 98)=        0.40681345D0
	rhoarr( 99)=        0.34720289D0
	rhoarr(100)=        0.29552951D0
	rhoarr(101)=        0.25102067D0
	rhoarr(102)=        0.21292767D0
	rhoarr(103)=        0.18053465D0
	rhoarr(104)=        0.15316586D0
	rhoarr(105)=        0.13019116D0
	rhoarr(106)=        0.11102942D0
	rhoarr(107)=        0.09514998D0
	rhoarr(108)=        0.08207245D0
	rhoarr(109)=        0.07136527D0
	rhoarr(110)=        0.06264350D0
	rhoarr(111)=        0.05556613D0
	rhoarr(112)=        0.04983335D0
	rhoarr(113)=        0.04518394D0
	rhoarr(114)=        0.04139261D0
	rhoarr(115)=        0.03826761D0
	rhoarr(116)=        0.03564817D0
	rhoarr(117)=        0.03340191D0
	rhoarr(118)=        0.03142217D0
	rhoarr(119)=        0.02962513D0
	rhoarr(120)=        0.02794698D0
	rhoarr(121)=        0.02634101D0
	rhoarr(122)=        0.02477492D0
	rhoarr(123)=        0.02322828D0
	rhoarr(124)=        0.02169019D0
	rhoarr(125)=        0.02015727D0
	rhoarr(126)=        0.01863184D0
	rhoarr(127)=        0.01712037D0
	rhoarr(128)=        0.01563212D0
	rhoarr(129)=        0.01417790D0
	rhoarr(130)=        0.01276911D0
	rhoarr(131)=        0.01141690D0
	rhoarr(132)=        0.01013143D0
	rhoarr(133)=        0.00892143D0
	rhoarr(134)=        0.00779384D0
	rhoarr(135)=        0.00675363D0
	rhoarr(136)=        0.00580372D0
	rhoarr(137)=        0.00494508D0
	rhoarr(138)=        0.00417681D0
	rhoarr(139)=        0.00349638D0
	rhoarr(140)=        0.00289986D0
	rhoarr(141)=        0.00238221D0
	rhoarr(142)=        0.00193757D0
	rhoarr(143)=        0.00155956D0
	rhoarr(144)=        0.00124157D0
	rhoarr(145)=        0.00097697D0
	rhoarr(146)=        0.00075931D0
	rhoarr(147)=        0.00058245D0
	rhoarr(148)=        0.00044064D0
	rhoarr(149)=        0.00032855D0
	rhoarr(150)=        0.00024131D0
	rhoarr(151)=        0.00017450D0
	rhoarr(152)=        0.00012419D0
	rhoarr(153)=        0.00008692D0
	rhoarr(154)=        0.00005977D0
	rhoarr(155)=        0.00004029D0
	rhoarr(156)=        0.00002653D0
	rhoarr(157)=        0.00001698D0
	rhoarr(158)=        0.00001048D0
	rhoarr(159)=        0.00000618D0
	rhoarr(160)=        0.00000344D0
	rhoarr(161)=        0.00000178D0
	rhoarr(162)=        0.00000084D0
	rhoarr(163)=        0.00000036D0
	rhoarr(164)=        0.00000013D0
	rhoarr(165)=        0.00000004D0
	rhoarr(166)=        0.00000001D0

else if (iele==14) then  !Si, 0 3, b3lyp/cc-pVQZ
	npt=  163
	rhoarr(  1)=     1745.79062422D0
	rhoarr(  2)=     1743.94041029D0
	rhoarr(  3)=     1736.33992344D0
	rhoarr(  4)=     1718.77567042D0
	rhoarr(  5)=     1691.45226223D0
	rhoarr(  6)=     1659.11281949D0
	rhoarr(  7)=     1623.39990197D0
	rhoarr(  8)=     1582.29240541D0
	rhoarr(  9)=     1536.17396057D0
	rhoarr( 10)=     1486.66837473D0
	rhoarr( 11)=     1434.16260259D0
	rhoarr( 12)=     1378.46436456D0
	rhoarr( 13)=     1319.96384842D0
	rhoarr( 14)=     1259.51741181D0
	rhoarr( 15)=     1197.79354659D0
	rhoarr( 16)=     1135.12776643D0
	rhoarr( 17)=     1071.79952886D0
	rhoarr( 18)=     1008.24053495D0
	rhoarr( 19)=      944.99274731D0
	rhoarr( 20)=      882.55450095D0
	rhoarr( 21)=      821.29783678D0
	rhoarr( 22)=      761.49842381D0
	rhoarr( 23)=      703.40615506D0
	rhoarr( 24)=      647.28343220D0
	rhoarr( 25)=      593.39364766D0
	rhoarr( 26)=      541.96570030D0
	rhoarr( 27)=      493.16751727D0
	rhoarr( 28)=      447.10347542D0
	rhoarr( 29)=      403.82976352D0
	rhoarr( 30)=      363.37292105D0
	rhoarr( 31)=      325.74061309D0
	rhoarr( 32)=      290.92246625D0
	rhoarr( 33)=      258.88531657D0
	rhoarr( 34)=      229.56883364D0
	rhoarr( 35)=      202.88529607D0
	rhoarr( 36)=      178.72389939D0
	rhoarr( 37)=      156.95755781D0
	rhoarr( 38)=      137.44957264D0
	rhoarr( 39)=      120.05840783D0
	rhoarr( 40)=      104.64019147D0
	rhoarr( 41)=       91.04962973D0
	rhoarr( 42)=       79.14041166D0
	rhoarr( 43)=       68.76597382D0
	rhoarr( 44)=       59.78098325D0
	rhoarr( 45)=       52.04340089D0
	rhoarr( 46)=       45.41670192D0
	rhoarr( 47)=       39.77179866D0
	rhoarr( 48)=       34.98836582D0
	rhoarr( 49)=       30.95548955D0
	rhoarr( 50)=       27.57174887D0
	rhoarr( 51)=       24.74493551D0
	rhoarr( 52)=       22.39162203D0
	rhoarr( 53)=       20.43672836D0
	rhoarr( 54)=       18.81315395D0
	rhoarr( 55)=       17.46147223D0
	rhoarr( 56)=       16.32964337D0
	rhoarr( 57)=       15.37269304D0
	rhoarr( 58)=       14.55232017D0
	rhoarr( 59)=       13.83642104D0
	rhoarr( 60)=       13.19854070D0
	rhoarr( 61)=       12.61727686D0
	rhoarr( 62)=       12.07566680D0
	rhoarr( 63)=       11.56058494D0
	rhoarr( 64)=       11.06217159D0
	rhoarr( 65)=       10.57330637D0
	rhoarr( 66)=       10.08913271D0
	rhoarr( 67)=        9.60663630D0
	rhoarr( 68)=        9.12427702D0
	rhoarr( 69)=        8.64167258D0
	rhoarr( 70)=        8.15933077D0
	rhoarr( 71)=        7.67842541D0
	rhoarr( 72)=        7.20061047D0
	rhoarr( 73)=        6.72786536D0
	rhoarr( 74)=        6.26236491D0
	rhoarr( 75)=        5.80636800D0
	rhoarr( 76)=        5.36212064D0
	rhoarr( 77)=        4.93177140D0
	rhoarr( 78)=        4.51729855D0
	rhoarr( 79)=        4.12045042D0
	rhoarr( 80)=        3.74270036D0
	rhoarr( 81)=        3.38521794D0
	rhoarr( 82)=        3.04885672D0
	rhoarr( 83)=        2.73415774D0
	rhoarr( 84)=        2.44136620D0
	rhoarr( 85)=        2.17045806D0
	rhoarr( 86)=        1.92117237D0
	rhoarr( 87)=        1.69304557D0
	rhoarr( 88)=        1.48544466D0
	rhoarr( 89)=        1.29759693D0
	rhoarr( 90)=        1.12861568D0
	rhoarr( 91)=        0.97752185D0
	rhoarr( 92)=        0.84326261D0
	rhoarr( 93)=        0.72472822D0
	rhoarr( 94)=        0.62076823D0
	rhoarr( 95)=        0.53020792D0
	rhoarr( 96)=        0.45186525D0
	rhoarr( 97)=        0.38456796D0
	rhoarr( 98)=        0.32717021D0
	rhoarr( 99)=        0.27856782D0
	rhoarr(100)=        0.23771128D0
	rhoarr(101)=        0.20361596D0
	rhoarr(102)=        0.17536905D0
	rhoarr(103)=        0.15213355D0
	rhoarr(104)=        0.13314949D0
	rhoarr(105)=        0.11773306D0
	rhoarr(106)=        0.10527428D0
	rhoarr(107)=        0.09523372D0
	rhoarr(108)=        0.08713887D0
	rhoarr(109)=        0.08058027D0
	rhoarr(110)=        0.07520758D0
	rhoarr(111)=        0.07072558D0
	rhoarr(112)=        0.06688996D0
	rhoarr(113)=        0.06350287D0
	rhoarr(114)=        0.06040826D0
	rhoarr(115)=        0.05748699D0
	rhoarr(116)=        0.05465190D0
	rhoarr(117)=        0.05184298D0
	rhoarr(118)=        0.04902272D0
	rhoarr(119)=        0.04617188D0
	rhoarr(120)=        0.04328565D0
	rhoarr(121)=        0.04037027D0
	rhoarr(122)=        0.03744012D0
	rhoarr(123)=        0.03451515D0
	rhoarr(124)=        0.03161875D0
	rhoarr(125)=        0.02877585D0
	rhoarr(126)=        0.02601138D0
	rhoarr(127)=        0.02334890D0
	rhoarr(128)=        0.02080964D0
	rhoarr(129)=        0.01841163D0
	rhoarr(130)=        0.01616923D0
	rhoarr(131)=        0.01409283D0
	rhoarr(132)=        0.01218879D0
	rhoarr(133)=        0.01045957D0
	rhoarr(134)=        0.00890403D0
	rhoarr(135)=        0.00751785D0
	rhoarr(136)=        0.00629401D0
	rhoarr(137)=        0.00522340D0
	rhoarr(138)=        0.00429539D0
	rhoarr(139)=        0.00349837D0
	rhoarr(140)=        0.00282025D0
	rhoarr(141)=        0.00224895D0
	rhoarr(142)=        0.00177261D0
	rhoarr(143)=        0.00137992D0
	rhoarr(144)=        0.00106012D0
	rhoarr(145)=        0.00080317D0
	rhoarr(146)=        0.00059971D0
	rhoarr(147)=        0.00044109D0
	rhoarr(148)=        0.00031943D0
	rhoarr(149)=        0.00022763D0
	rhoarr(150)=        0.00015951D0
	rhoarr(151)=        0.00010976D0
	rhoarr(152)=        0.00007399D0
	rhoarr(153)=        0.00004869D0
	rhoarr(154)=        0.00003112D0
	rhoarr(155)=        0.00001918D0
	rhoarr(156)=        0.00001129D0
	rhoarr(157)=        0.00000629D0
	rhoarr(158)=        0.00000327D0
	rhoarr(159)=        0.00000156D0
	rhoarr(160)=        0.00000068D0
	rhoarr(161)=        0.00000026D0
	rhoarr(162)=        0.00000009D0
	rhoarr(163)=        0.00000002D0

else if (iele==15) then  !P, 0 4, b3lyp/cc-pVQZ
	npt=  161
	rhoarr(  1)=     2162.61637858D0
	rhoarr(  2)=     2159.93237852D0
	rhoarr(  3)=     2149.02087472D0
	rhoarr(  4)=     2124.49149280D0
	rhoarr(  5)=     2087.98467641D0
	rhoarr(  6)=     2045.95884336D0
	rhoarr(  7)=     1998.74345233D0
	rhoarr(  8)=     1944.05803863D0
	rhoarr(  9)=     1883.55617887D0
	rhoarr( 10)=     1818.92259163D0
	rhoarr( 11)=     1750.10260695D0
	rhoarr( 12)=     1677.12059824D0
	rhoarr( 13)=     1600.95813548D0
	rhoarr( 14)=     1522.71953967D0
	rhoarr( 15)=     1443.01424012D0
	rhoarr( 16)=     1362.20890829D0
	rhoarr( 17)=     1280.83077375D0
	rhoarr( 18)=     1199.60942885D0
	rhoarr( 19)=     1119.26129344D0
	rhoarr( 20)=     1040.33213011D0
	rhoarr( 21)=      963.21880401D0
	rhoarr( 22)=      888.27352329D0
	rhoarr( 23)=      815.86607013D0
	rhoarr( 24)=      746.36838566D0
	rhoarr( 25)=      680.10154560D0
	rhoarr( 26)=      617.29800673D0
	rhoarr( 27)=      558.10109129D0
	rhoarr( 28)=      502.58973878D0
	rhoarr( 29)=      450.80463779D0
	rhoarr( 30)=      402.76053537D0
	rhoarr( 31)=      358.44418449D0
	rhoarr( 32)=      317.80641737D0
	rhoarr( 33)=      280.75732931D0
	rhoarr( 34)=      247.16873219D0
	rhoarr( 35)=      216.88264303D0
	rhoarr( 36)=      189.72175181D0
	rhoarr( 37)=      165.49809464D0
	rhoarr( 38)=      144.01823311D0
	rhoarr( 39)=      125.08539349D0
	rhoarr( 40)=      108.50017943D0
	rhoarr( 41)=       94.06146648D0
	rhoarr( 42)=       81.56834679D0
	rhoarr( 43)=       70.82310950D0
	rhoarr( 44)=       61.63465017D0
	rhoarr( 45)=       53.82155432D0
	rhoarr( 46)=       47.21430899D0
	rhoarr( 47)=       41.65646110D0
	rhoarr( 48)=       37.00486810D0
	rhoarr( 49)=       33.12936523D0
	rhoarr( 50)=       29.91218936D0
	rhoarr( 51)=       27.24740107D0
	rhoarr( 52)=       25.04040951D0
	rhoarr( 53)=       23.20758732D0
	rhoarr( 54)=       21.67589969D0
	rhoarr( 55)=       20.38246280D0
	rhoarr( 56)=       19.27397562D0
	rhoarr( 57)=       18.30601219D0
	rhoarr( 58)=       17.44219825D0
	rhoarr( 59)=       16.65331834D0
	rhoarr( 60)=       15.91640420D0
	rhoarr( 61)=       15.21384839D0
	rhoarr( 62)=       14.53257426D0
	rhoarr( 63)=       13.86328031D0
	rhoarr( 64)=       13.19976666D0
	rhoarr( 65)=       12.53834449D0
	rhoarr( 66)=       11.87732550D0
	rhoarr( 67)=       11.21658570D0
	rhoarr( 68)=       10.55719660D0
	rhoarr( 69)=        9.90111501D0
	rhoarr( 70)=        9.25092211D0
	rhoarr( 71)=        8.60960233D0
	rhoarr( 72)=        7.98035360D0
	rhoarr( 73)=        7.36642290D0
	rhoarr( 74)=        6.77096366D0
	rhoarr( 75)=        6.19691425D0
	rhoarr( 76)=        5.64689874D0
	rhoarr( 77)=        5.12315216D0
	rhoarr( 78)=        4.62747171D0
	rhoarr( 79)=        4.16119420D0
	rhoarr( 80)=        3.72519787D0
	rhoarr( 81)=        3.31992452D0
	rhoarr( 82)=        2.94541667D0
	rhoarr( 83)=        2.60136356D0
	rhoarr( 84)=        2.28715025D0
	rhoarr( 85)=        2.00190517D0
	rhoarr( 86)=        1.74454326D0
	rhoarr( 87)=        1.51380346D0
	rhoarr( 88)=        1.30828087D0
	rhoarr( 89)=        1.12645520D0
	rhoarr( 90)=        0.96671697D0
	rhoarr( 91)=        0.82739331D0
	rhoarr( 92)=        0.70677417D0
	rhoarr( 93)=        0.60313905D0
	rhoarr( 94)=        0.51478369D0
	rhoarr( 95)=        0.44004559D0
	rhoarr( 96)=        0.37732692D0
	rhoarr( 97)=        0.32511378D0
	rhoarr( 98)=        0.28199088D0
	rhoarr( 99)=        0.24665157D0
	rhoarr(100)=        0.21790313D0
	rhoarr(101)=        0.19466841D0
	rhoarr(102)=        0.17598431D0
	rhoarr(103)=        0.16099824D0
	rhoarr(104)=        0.14896327D0
	rhoarr(105)=        0.13923260D0
	rhoarr(106)=        0.13125356D0
	rhoarr(107)=        0.12456141D0
	rhoarr(108)=        0.11877276D0
	rhoarr(109)=        0.11357864D0
	rhoarr(110)=        0.10873717D0
	rhoarr(111)=        0.10406587D0
	rhoarr(112)=        0.09943390D0
	rhoarr(113)=        0.09475423D0
	rhoarr(114)=        0.08997620D0
	rhoarr(115)=        0.08507856D0
	rhoarr(116)=        0.08006316D0
	rhoarr(117)=        0.07494938D0
	rhoarr(118)=        0.06976931D0
	rhoarr(119)=        0.06456361D0
	rhoarr(120)=        0.05937802D0
	rhoarr(121)=        0.05426035D0
	rhoarr(122)=        0.04925801D0
	rhoarr(123)=        0.04441584D0
	rhoarr(124)=        0.03977450D0
	rhoarr(125)=        0.03536907D0
	rhoarr(126)=        0.03122818D0
	rhoarr(127)=        0.02737343D0
	rhoarr(128)=        0.02381921D0
	rhoarr(129)=        0.02057284D0
	rhoarr(130)=        0.01763502D0
	rhoarr(131)=        0.01500051D0
	rhoarr(132)=        0.01265901D0
	rhoarr(133)=        0.01059612D0
	rhoarr(134)=        0.00879438D0
	rhoarr(135)=        0.00723429D0
	rhoarr(136)=        0.00589523D0
	rhoarr(137)=        0.00475621D0
	rhoarr(138)=        0.00379651D0
	rhoarr(139)=        0.00299610D0
	rhoarr(140)=        0.00233590D0
	rhoarr(141)=        0.00179792D0
	rhoarr(142)=        0.00136530D0
	rhoarr(143)=        0.00102232D0
	rhoarr(144)=        0.00075450D0
	rhoarr(145)=        0.00054861D0
	rhoarr(146)=        0.00039283D0
	rhoarr(147)=        0.00027678D0
	rhoarr(148)=        0.00019166D0
	rhoarr(149)=        0.00013015D0
	rhoarr(150)=        0.00008640D0
	rhoarr(151)=        0.00005580D0
	rhoarr(152)=        0.00003486D0
	rhoarr(153)=        0.00002089D0
	rhoarr(154)=        0.00001190D0
	rhoarr(155)=        0.00000638D0
	rhoarr(156)=        0.00000317D0
	rhoarr(157)=        0.00000145D0
	rhoarr(158)=        0.00000060D0
	rhoarr(159)=        0.00000022D0
	rhoarr(160)=        0.00000007D0
	rhoarr(161)=        0.00000002D0

else if (iele==16) then  !S, 0 3, b3lyp/cc-pVQZ
	npt=  160
	rhoarr(  1)=     2641.31917255D0
	rhoarr(  2)=     2637.52549129D0
	rhoarr(  3)=     2622.27650344D0
	rhoarr(  4)=     2588.98594811D0
	rhoarr(  5)=     2541.52029439D0
	rhoarr(  6)=     2487.76799361D0
	rhoarr(  7)=     2426.17569232D0
	rhoarr(  8)=     2355.06228561D0
	rhoarr(  9)=     2277.32761780D0
	rhoarr( 10)=     2194.27614507D0
	rhoarr( 11)=     2105.57128345D0
	rhoarr( 12)=     2011.85647723D0
	rhoarr( 13)=     1914.70134974D0
	rhoarr( 14)=     1815.25374087D0
	rhoarr( 15)=     1714.07156104D0
	rhoarr( 16)=     1611.74764073D0
	rhoarr( 17)=     1509.19773916D0
	rhoarr( 18)=     1407.42849567D0
	rhoarr( 19)=     1307.24811874D0
	rhoarr( 20)=     1209.23366195D0
	rhoarr( 21)=     1113.87230448D0
	rhoarr( 22)=     1021.66980669D0
	rhoarr( 23)=      933.14178959D0
	rhoarr( 24)=      848.73866061D0
	rhoarr( 25)=      768.78839657D0
	rhoarr( 26)=      693.49492721D0
	rhoarr( 27)=      622.97424471D0
	rhoarr( 28)=      557.29109033D0
	rhoarr( 29)=      496.47395032D0
	rhoarr( 30)=      440.50959281D0
	rhoarr( 31)=      389.33131272D0
	rhoarr( 32)=      342.81395816D0
	rhoarr( 33)=      300.78020094D0
	rhoarr( 34)=      263.01445265D0
	rhoarr( 35)=      229.27773270D0
	rhoarr( 36)=      199.31848396D0
	rhoarr( 37)=      172.87803633D0
	rhoarr( 38)=      149.69241154D0
	rhoarr( 39)=      129.49320276D0
	rhoarr( 40)=      112.00958729D0
	rhoarr( 41)=       96.97210437D0
	rhoarr( 42)=       84.11758969D0
	rhoarr( 43)=       73.19409948D0
	rhoarr( 44)=       63.96478989D0
	rhoarr( 45)=       56.21024769D0
	rhoarr( 46)=       49.72933985D0
	rhoarr( 47)=       44.33902036D0
	rhoarr( 48)=       39.87362893D0
	rhoarr( 49)=       36.18410030D0
	rhoarr( 50)=       33.13729254D0
	rhoarr( 51)=       30.61544942D0
	rhoarr( 52)=       28.51569701D0
	rhoarr( 53)=       26.74944936D0
	rhoarr( 54)=       25.24163630D0
	rhoarr( 55)=       23.92972964D0
	rhoarr( 56)=       22.76260031D0
	rhoarr( 57)=       21.69927103D0
	rhoarr( 58)=       20.70763636D0
	rhoarr( 59)=       19.76321096D0
	rhoarr( 60)=       18.84794869D0
	rhoarr( 61)=       17.94915819D0
	rhoarr( 62)=       17.05852749D0
	rhoarr( 63)=       16.17126277D0
	rhoarr( 64)=       15.28534147D0
	rhoarr( 65)=       14.40087623D0
	rhoarr( 66)=       13.51958223D0
	rhoarr( 67)=       12.64433629D0
	rhoarr( 68)=       11.77881326D0
	rhoarr( 69)=       10.92718356D0
	rhoarr( 70)=       10.09385738D0
	rhoarr( 71)=        9.28326432D0
	rhoarr( 72)=        8.49966210D0
	rhoarr( 73)=        7.74697287D0
	rhoarr( 74)=        7.02864923D0
	rhoarr( 75)=        6.34757369D0
	rhoarr( 76)=        5.70599481D0
	rhoarr( 77)=        5.10550092D0
	rhoarr( 78)=        4.54702893D0
	rhoarr( 79)=        4.03090247D0
	rhoarr( 80)=        3.55689122D0
	rhoarr( 81)=        3.12428227D0
	rhoarr( 82)=        2.73195488D0
	rhoarr( 83)=        2.37845183D0
	rhoarr( 84)=        2.06204327D0
	rhoarr( 85)=        1.78078144D0
	rhoarr( 86)=        1.53254714D0
	rhoarr( 87)=        1.31509007D0
	rhoarr( 88)=        1.12606579D0
	rhoarr( 89)=        0.96307156D0
	rhoarr( 90)=        0.82368245D0
	rhoarr( 91)=        0.70548781D0
	rhoarr( 92)=        0.60612720D0
	rhoarr( 93)=        0.52332420D0
	rhoarr( 94)=        0.45491626D0
	rhoarr( 95)=        0.39887890D0
	rhoarr( 96)=        0.35334347D0
	rhoarr( 97)=        0.31660811D0
	rhoarr( 98)=        0.28714235D0
	rhoarr( 99)=        0.26358638D0
	rhoarr(100)=        0.24474628D0
	rhoarr(101)=        0.22958645D0
	rhoarr(102)=        0.21722032D0
	rhoarr(103)=        0.20690023D0
	rhoarr(104)=        0.19800689D0
	rhoarr(105)=        0.19003850D0
	rhoarr(106)=        0.18259980D0
	rhoarr(107)=        0.17539069D0
	rhoarr(108)=        0.16819470D0
	rhoarr(109)=        0.16086737D0
	rhoarr(110)=        0.15332465D0
	rhoarr(111)=        0.14553177D0
	rhoarr(112)=        0.13749279D0
	rhoarr(113)=        0.12924114D0
	rhoarr(114)=        0.12083129D0
	rhoarr(115)=        0.11233157D0
	rhoarr(116)=        0.10381830D0
	rhoarr(117)=        0.09537086D0
	rhoarr(118)=        0.08706785D0
	rhoarr(119)=        0.07898400D0
	rhoarr(120)=        0.07118772D0
	rhoarr(121)=        0.06373934D0
	rhoarr(122)=        0.05668971D0
	rhoarr(123)=        0.05007930D0
	rhoarr(124)=        0.04393775D0
	rhoarr(125)=        0.03828376D0
	rhoarr(126)=        0.03312547D0
	rhoarr(127)=        0.02846108D0
	rhoarr(128)=        0.02427992D0
	rhoarr(129)=        0.02056375D0
	rhoarr(130)=        0.01728818D0
	rhoarr(131)=        0.01442428D0
	rhoarr(132)=        0.01194015D0
	rhoarr(133)=        0.00980234D0
	rhoarr(134)=        0.00797713D0
	rhoarr(135)=        0.00643155D0
	rhoarr(136)=        0.00513405D0
	rhoarr(137)=        0.00405497D0
	rhoarr(138)=        0.00316670D0
	rhoarr(139)=        0.00244372D0
	rhoarr(140)=        0.00186249D0
	rhoarr(141)=        0.00140139D0
	rhoarr(142)=        0.00104069D0
	rhoarr(143)=        0.00076258D0
	rhoarr(144)=        0.00055120D0
	rhoarr(145)=        0.00039279D0
	rhoarr(146)=        0.00027565D0
	rhoarr(147)=        0.00019015D0
	rhoarr(148)=        0.00012856D0
	rhoarr(149)=        0.00008483D0
	rhoarr(150)=        0.00005432D0
	rhoarr(151)=        0.00003352D0
	rhoarr(152)=        0.00001977D0
	rhoarr(153)=        0.00001103D0
	rhoarr(154)=        0.00000576D0
	rhoarr(155)=        0.00000278D0
	rhoarr(156)=        0.00000123D0
	rhoarr(157)=        0.00000049D0
	rhoarr(158)=        0.00000017D0
	rhoarr(159)=        0.00000005D0
	rhoarr(160)=        0.00000001D0

else if (iele==17) then  !Cl, 0 2, b3lyp/cc-pVQZ
	npt=  158
	rhoarr(  1)=     3185.82381273D0
	rhoarr(  2)=     3180.62751367D0
	rhoarr(  3)=     3159.96300276D0
	rhoarr(  4)=     3116.04841259D0
	rhoarr(  5)=     3055.63121855D0
	rhoarr(  6)=     2987.61037590D0
	rhoarr(  7)=     2908.50002189D0
	rhoarr(  8)=     2817.88271457D0
	rhoarr(  9)=     2719.57832394D0
	rhoarr( 10)=     2614.32925661D0
	rhoarr( 11)=     2501.87689351D0
	rhoarr( 12)=     2383.70426832D0
	rhoarr( 13)=     2261.80938844D0
	rhoarr( 14)=     2137.30073740D0
	rhoarr( 15)=     2010.84380098D0
	rhoarr( 16)=     1883.44090411D0
	rhoarr( 17)=     1756.42451154D0
	rhoarr( 18)=     1631.00610140D0
	rhoarr( 19)=     1508.05853614D0
	rhoarr( 20)=     1388.24937950D0
	rhoarr( 21)=     1272.23553800D0
	rhoarr( 22)=     1160.70644195D0
	rhoarr( 23)=     1054.29485965D0
	rhoarr( 24)=      953.48097679D0
	rhoarr( 25)=      858.57073281D0
	rhoarr( 26)=      769.73898879D0
	rhoarr( 27)=      687.08369339D0
	rhoarr( 28)=      610.65197150D0
	rhoarr( 29)=      540.43516030D0
	rhoarr( 30)=      476.35251102D0
	rhoarr( 31)=      418.24358183D0
	rhoarr( 32)=      365.87669235D0
	rhoarr( 33)=      318.96837277D0
	rhoarr( 34)=      277.20396281D0
	rhoarr( 35)=      240.25218228D0
	rhoarr( 36)=      207.77212975D0
	rhoarr( 37)=      179.41548078D0
	rhoarr( 38)=      154.82788326D0
	rhoarr( 39)=      133.65226702D0
	rhoarr( 40)=      115.53460105D0
	rhoarr( 41)=      100.13094348D0
	rhoarr( 42)=       87.11405319D0
	rhoarr( 43)=       76.17823501D0
	rhoarr( 44)=       67.04194468D0
	rhoarr( 45)=       59.44845916D0
	rhoarr( 46)=       53.16532786D0
	rhoarr( 47)=       47.98333209D0
	rhoarr( 48)=       43.71543824D0
	rhoarr( 49)=       40.19592209D0
	rhoarr( 50)=       37.27960847D0
	rhoarr( 51)=       34.84106826D0
	rhoarr( 52)=       32.77362860D0
	rhoarr( 53)=       30.98812797D0
	rhoarr( 54)=       29.41143160D0
	rhoarr( 55)=       27.98477936D0
	rhoarr( 56)=       26.66205795D0
	rhoarr( 57)=       25.40808047D0
	rhoarr( 58)=       24.19693463D0
	rhoarr( 59)=       23.01043877D0
	rhoarr( 60)=       21.83672949D0
	rhoarr( 61)=       20.66899613D0
	rhoarr( 62)=       19.50437202D0
	rhoarr( 63)=       18.34298724D0
	rhoarr( 64)=       17.18717974D0
	rhoarr( 65)=       16.04085294D0
	rhoarr( 66)=       14.90895948D0
	rhoarr( 67)=       13.79708552D0
	rhoarr( 68)=       12.71110983D0
	rhoarr( 69)=       11.65691588D0
	rhoarr( 70)=       10.64014292D0
	rhoarr( 71)=        9.66597026D0
	rhoarr( 72)=        8.73893663D0
	rhoarr( 73)=        7.86280010D0
	rhoarr( 74)=        7.04044534D0
	rhoarr( 75)=        6.27384164D0
	rhoarr( 76)=        5.56405082D0
	rhoarr( 77)=        4.91127862D0
	rhoarr( 78)=        4.31495886D0
	rhoarr( 79)=        3.77385760D0
	rhoarr( 80)=        3.28618427D0
	rhoarr( 81)=        2.84969917D0
	rhoarr( 82)=        2.46181027D0
	rhoarr( 83)=        2.11965597D0
	rhoarr( 84)=        1.82017434D0
	rhoarr( 85)=        1.56016156D0
	rhoarr( 86)=        1.33632331D0
	rhoarr( 87)=        1.14532284D0
	rhoarr( 88)=        0.98382804D0
	rhoarr( 89)=        0.84855835D0
	rhoarr( 90)=        0.73633069D0
	rhoarr( 91)=        0.64410256D0
	rhoarr( 92)=        0.56900980D0
	rhoarr( 93)=        0.50839711D0
	rhoarr( 94)=        0.45983965D0
	rhoarr( 95)=        0.42115540D0
	rhoarr( 96)=        0.39040880D0
	rhoarr( 97)=        0.36590692D0
	rhoarr( 98)=        0.34618989D0
	rhoarr( 99)=        0.33001747D0
	rhoarr(100)=        0.31635330D0
	rhoarr(101)=        0.30434808D0
	rhoarr(102)=        0.29332244D0
	rhoarr(103)=        0.28274982D0
	rhoarr(104)=        0.27223945D0
	rhoarr(105)=        0.26151943D0
	rhoarr(106)=        0.25041984D0
	rhoarr(107)=        0.23885614D0
	rhoarr(108)=        0.22681292D0
	rhoarr(109)=        0.21432856D0
	rhoarr(110)=        0.20148108D0
	rhoarr(111)=        0.18837551D0
	rhoarr(112)=        0.17513309D0
	rhoarr(113)=        0.16188230D0
	rhoarr(114)=        0.14875175D0
	rhoarr(115)=        0.13586477D0
	rhoarr(116)=        0.12333542D0
	rhoarr(117)=        0.11126570D0
	rhoarr(118)=        0.09974373D0
	rhoarr(119)=        0.08884258D0
	rhoarr(120)=        0.07861970D0
	rhoarr(121)=        0.06911674D0
	rhoarr(122)=        0.06035980D0
	rhoarr(123)=        0.05236001D0
	rhoarr(124)=        0.04511448D0
	rhoarr(125)=        0.03860760D0
	rhoarr(126)=        0.03281267D0
	rhoarr(127)=        0.02769382D0
	rhoarr(128)=        0.02320808D0
	rhoarr(129)=        0.01930758D0
	rhoarr(130)=        0.01594164D0
	rhoarr(131)=        0.01305870D0
	rhoarr(132)=        0.01060800D0
	rhoarr(133)=        0.00854080D0
	rhoarr(134)=        0.00681130D0
	rhoarr(135)=        0.00537703D0
	rhoarr(136)=        0.00419906D0
	rhoarr(137)=        0.00324188D0
	rhoarr(138)=        0.00247316D0
	rhoarr(139)=        0.00186360D0
	rhoarr(140)=        0.00138669D0
	rhoarr(141)=        0.00101871D0
	rhoarr(142)=        0.00073871D0
	rhoarr(143)=        0.00052852D0
	rhoarr(144)=        0.00037277D0
	rhoarr(145)=        0.00025879D0
	rhoarr(146)=        0.00017639D0
	rhoarr(147)=        0.00011761D0
	rhoarr(148)=        0.00007633D0
	rhoarr(149)=        0.00004792D0
	rhoarr(150)=        0.00002888D0
	rhoarr(151)=        0.00001656D0
	rhoarr(152)=        0.00000895D0
	rhoarr(153)=        0.00000451D0
	rhoarr(154)=        0.00000209D0
	rhoarr(155)=        0.00000088D0
	rhoarr(156)=        0.00000033D0
	rhoarr(157)=        0.00000011D0
	rhoarr(158)=        0.00000003D0

else if (iele==18) then  !Ar, 0 1, b3lyp/cc-pVQZ
	npt=  157
	rhoarr(  1)=     3800.56179429D0
	rhoarr(  2)=     3793.57625280D0
	rhoarr(  3)=     3766.11200311D0
	rhoarr(  4)=     3709.35457086D0
	rhoarr(  5)=     3633.80631434D0
	rhoarr(  6)=     3548.63393153D0
	rhoarr(  7)=     3448.50003154D0
	rhoarr(  8)=     3334.95966622D0
	rhoarr(  9)=     3212.32430023D0
	rhoarr( 10)=     3080.66537594D0
	rhoarr( 11)=     2940.25168843D0
	rhoarr( 12)=     2793.54239113D0
	rhoarr( 13)=     2642.76497013D0
	rhoarr( 14)=     2488.98220994D0
	rhoarr( 15)=     2333.18385917D0
	rhoarr( 16)=     2176.93449250D0
	rhoarr( 17)=     2021.95504018D0
	rhoarr( 18)=     1869.58938999D0
	rhoarr( 19)=     1720.79220478D0
	rhoarr( 20)=     1576.40961012D0
	rhoarr( 21)=     1437.33501045D0
	rhoarr( 22)=     1304.43759099D0
	rhoarr( 23)=     1178.41639266D0
	rhoarr( 24)=     1059.73539264D0
	rhoarr( 25)=      948.66411379D0
	rhoarr( 26)=      845.35442721D0
	rhoarr( 27)=      749.88636803D0
	rhoarr( 28)=      662.26763352D0
	rhoarr( 29)=      582.41162478D0
	rhoarr( 30)=      510.12464982D0
	rhoarr( 31)=      445.11558868D0
	rhoarr( 32)=      387.02202523D0
	rhoarr( 33)=      335.43868519D0
	rhoarr( 34)=      289.93753590D0
	rhoarr( 35)=      250.07724901D0
	rhoarr( 36)=      215.40610693D0
	rhoarr( 37)=      185.46409271D0
	rhoarr( 38)=      159.78784907D0
	rhoarr( 39)=      137.91896280D0
	rhoarr( 40)=      119.41371550D0
	rhoarr( 41)=      103.85184019D0
	rhoarr( 42)=       90.84258960D0
	rhoarr( 43)=       80.02770160D0
	rhoarr( 44)=       71.08188108D0
	rhoarr( 45)=       63.71185793D0
	rhoarr( 46)=       57.65496991D0
	rhoarr( 47)=       52.67781827D0
	rhoarr( 48)=       48.57512456D0
	rhoarr( 49)=       45.16865044D0
	rhoarr( 50)=       42.30596705D0
	rhoarr( 51)=       39.85892403D0
	rhoarr( 52)=       37.72178405D0
	rhoarr( 53)=       35.80908789D0
	rhoarr( 54)=       34.05336437D0
	rhoarr( 55)=       32.40280154D0
	rhoarr( 56)=       30.81897046D0
	rhoarr( 57)=       29.27466283D0
	rhoarr( 58)=       27.75188183D0
	rhoarr( 59)=       26.24001455D0
	rhoarr( 60)=       24.73420912D0
	rhoarr( 61)=       23.23397389D0
	rhoarr( 62)=       21.74200525D0
	rhoarr( 63)=       20.26323601D0
	rhoarr( 64)=       18.80408031D0
	rhoarr( 65)=       17.37183928D0
	rhoarr( 66)=       15.97422735D0
	rhoarr( 67)=       14.61898249D0
	rhoarr( 68)=       13.31353392D0
	rhoarr( 69)=       12.06471388D0
	rhoarr( 70)=       10.87851234D0
	rhoarr( 71)=        9.75988173D0
	rhoarr( 72)=        8.71260188D0
	rhoarr( 73)=        7.73921263D0
	rhoarr( 74)=        6.84101533D0
	rhoarr( 75)=        6.01813679D0
	rhoarr( 76)=        5.26964225D0
	rhoarr( 77)=        4.59367979D0
	rhoarr( 78)=        3.98763785D0
	rhoarr( 79)=        3.44829990D0
	rhoarr( 80)=        2.97198508D0
	rhoarr( 81)=        2.55466914D0
	rhoarr( 82)=        2.19208521D0
	rhoarr( 83)=        1.87980767D0
	rhoarr( 84)=        1.61332427D0
	rhoarr( 85)=        1.38810163D0
	rhoarr( 86)=        1.19964795D0
	rhoarr( 87)=        1.04357425D0
	rhoarr( 88)=        0.91565378D0
	rhoarr( 89)=        0.81187708D0
	rhoarr( 90)=        0.72849983D0
	rhoarr( 91)=        0.66208058D0
	rhoarr( 92)=        0.60950657D0
	rhoarr( 93)=        0.56800689D0
	rhoarr( 94)=        0.53515385D0
	rhoarr( 95)=        0.50885421D0
	rhoarr( 96)=        0.48733290D0
	rhoarr( 97)=        0.46911147D0
	rhoarr( 98)=        0.45298377D0
	rhoarr( 99)=        0.43799046D0
	rhoarr(100)=        0.42339342D0
	rhoarr(101)=        0.40865055D0
	rhoarr(102)=        0.39339118D0
	rhoarr(103)=        0.37739185D0
	rhoarr(104)=        0.36055263D0
	rhoarr(105)=        0.34287400D0
	rhoarr(106)=        0.32443466D0
	rhoarr(107)=        0.30537072D0
	rhoarr(108)=        0.28585688D0
	rhoarr(109)=        0.26608989D0
	rhoarr(110)=        0.24627474D0
	rhoarr(111)=        0.22661373D0
	rhoarr(112)=        0.20729811D0
	rhoarr(113)=        0.18850231D0
	rhoarr(114)=        0.17038016D0
	rhoarr(115)=        0.15306277D0
	rhoarr(116)=        0.13665770D0
	rhoarr(117)=        0.12124888D0
	rhoarr(118)=        0.10689715D0
	rhoarr(119)=        0.09364123D0
	rhoarr(120)=        0.08149882D0
	rhoarr(121)=        0.07046818D0
	rhoarr(122)=        0.06052980D0
	rhoarr(123)=        0.05164846D0
	rhoarr(124)=        0.04377557D0
	rhoarr(125)=        0.03685177D0
	rhoarr(126)=        0.03080970D0
	rhoarr(127)=        0.02557680D0
	rhoarr(128)=        0.02107810D0
	rhoarr(129)=        0.01723862D0
	rhoarr(130)=        0.01398552D0
	rhoarr(131)=        0.01124965D0
	rhoarr(132)=        0.00896665D0
	rhoarr(133)=        0.00707743D0
	rhoarr(134)=        0.00552836D0
	rhoarr(135)=        0.00427096D0
	rhoarr(136)=        0.00326164D0
	rhoarr(137)=        0.00246120D0
	rhoarr(138)=        0.00183457D0
	rhoarr(139)=        0.00135056D0
	rhoarr(140)=        0.00098174D0
	rhoarr(141)=        0.00070444D0
	rhoarr(142)=        0.00049861D0
	rhoarr(143)=        0.00034769D0
	rhoarr(144)=        0.00023837D0
	rhoarr(145)=        0.00016015D0
	rhoarr(146)=        0.00010500D0
	rhoarr(147)=        0.00006681D0
	rhoarr(148)=        0.00004097D0
	rhoarr(149)=        0.00002402D0
	rhoarr(150)=        0.00001335D0
	rhoarr(151)=        0.00000696D0
	rhoarr(152)=        0.00000337D0
	rhoarr(153)=        0.00000150D0
	rhoarr(154)=        0.00000060D0
	rhoarr(155)=        0.00000022D0
	rhoarr(156)=        0.00000007D0
	rhoarr(157)=        0.00000002D0

else if (iele==19) then  !K, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=170
	rhoarr(  1)=  7465.29000797D0
	rhoarr(  2)=  7080.48471610D0
	rhoarr(  3)=  6324.07701584D0
	rhoarr(  4)=  5845.81849493D0
	rhoarr(  5)=  5444.35608356D0
	rhoarr(  6)=  5105.75028458D0
	rhoarr(  7)=  4808.50363250D0
	rhoarr(  8)=  4525.84927673D0
	rhoarr(  9)=  4261.95442319D0
	rhoarr( 10)=  4009.45518110D0
	rhoarr( 11)=  3762.40356116D0
	rhoarr( 12)=  3521.70028871D0
	rhoarr( 13)=  3287.57891468D0
	rhoarr( 14)=  3058.74542850D0
	rhoarr( 15)=  2835.05980038D0
	rhoarr( 16)=  2617.63424564D0
	rhoarr( 17)=  2407.48858717D0
	rhoarr( 18)=  2205.13216145D0
	rhoarr( 19)=  2011.00970416D0
	rhoarr( 20)=  1825.79675382D0
	rhoarr( 21)=  1650.25165740D0
	rhoarr( 22)=  1484.95529734D0
	rhoarr( 23)=  1330.22716022D0
	rhoarr( 24)=  1186.20694424D0
	rhoarr( 25)=  1052.95006430D0
	rhoarr( 26)=   930.44835398D0
	rhoarr( 27)=   818.59436014D0
	rhoarr( 28)=   717.14789742D0
	rhoarr( 29)=   625.73853071D0
	rhoarr( 30)=   543.89779691D0
	rhoarr( 31)=   471.09660583D0
	rhoarr( 32)=   406.76987862D0
	rhoarr( 33)=   350.32634347D0
	rhoarr( 34)=   301.15174439D0
	rhoarr( 35)=   258.61424219D0
	rhoarr( 36)=   222.07542651D0
	rhoarr( 37)=   190.90490786D0
	rhoarr( 38)=   164.49424339D0
	rhoarr( 39)=   142.26699427D0
	rhoarr( 40)=   123.68416813D0
	rhoarr( 41)=   108.24628207D0
	rhoarr( 42)=    95.49392188D0
	rhoarr( 43)=    85.00816118D0
	rhoarr( 44)=    76.41124600D0
	rhoarr( 45)=    69.36719494D0
	rhoarr( 46)=    63.58170867D0
	rhoarr( 47)=    58.80096704D0
	rhoarr( 48)=    54.80927388D0
	rhoarr( 49)=    51.42584528D0
	rhoarr( 50)=    48.50118900D0
	rhoarr( 51)=    45.91348404D0
	rhoarr( 52)=    43.56521304D0
	rhoarr( 53)=    41.38012418D0
	rhoarr( 54)=    39.30047441D0
	rhoarr( 55)=    37.28445898D0
	rhoarr( 56)=    35.30375247D0
	rhoarr( 57)=    33.34113890D0
	rhoarr( 58)=    31.38826118D0
	rhoarr( 59)=    29.44355041D0
	rhoarr( 60)=    27.51039624D0
	rhoarr( 61)=    25.59559893D0
	rhoarr( 62)=    23.70811149D0
	rhoarr( 63)=    21.85805046D0
	rhoarr( 64)=    20.05593389D0
	rhoarr( 65)=    18.31209799D0
	rhoarr( 66)=    16.63624827D0
	rhoarr( 67)=    15.03711281D0
	rhoarr( 68)=    13.52217839D0
	rhoarr( 69)=    12.09750158D0
	rhoarr( 70)=    10.76759275D0
	rhoarr( 71)=     9.53537248D0
	rhoarr( 72)=     8.40219654D0
	rhoarr( 73)=     7.36794109D0
	rhoarr( 74)=     6.43113512D0
	rhoarr( 75)=     5.58912447D0
	rhoarr( 76)=     4.83825135D0
	rhoarr( 77)=     4.17403593D0
	rhoarr( 78)=     3.59135014D0
	rhoarr( 79)=     3.08457844D0
	rhoarr( 80)=     2.64776401D0
	rhoarr( 81)=     2.27474161D0
	rhoarr( 82)=     1.95925923D0
	rhoarr( 83)=     1.69509011D0
	rhoarr( 84)=     1.47613589D0
	rhoarr( 85)=     1.29651961D0
	rhoarr( 86)=     1.15066674D0
	rhoarr( 87)=     1.03337166D0
	rhoarr( 88)=     0.93984774D0
	rhoarr( 89)=     0.86576012D0
	rhoarr( 90)=     0.80724163D0
	rhoarr( 91)=     0.76089377D0
	rhoarr( 92)=     0.72377539D0
	rhoarr( 93)=     0.69338215D0
	rhoarr( 94)=     0.66761981D0
	rhoarr( 95)=     0.64477376D0
	rhoarr( 96)=     0.62347645D0
	rhoarr( 97)=     0.60267390D0
	rhoarr( 98)=     0.58159166D0
	rhoarr( 99)=     0.55970063D0
	rhoarr(100)=     0.53668282D0
	rhoarr(101)=     0.51239758D0
	rhoarr(102)=     0.48684865D0
	rhoarr(103)=     0.46015281D0
	rhoarr(104)=     0.43251086D0
	rhoarr(105)=     0.40418140D0
	rhoarr(106)=     0.37545789D0
	rhoarr(107)=     0.34664926D0
	rhoarr(108)=     0.31806390D0
	rhoarr(109)=     0.28999685D0
	rhoarr(110)=     0.26271998D0
	rhoarr(111)=     0.23647471D0
	rhoarr(112)=     0.21146700D0
	rhoarr(113)=     0.18786430D0
	rhoarr(114)=     0.16579434D0
	rhoarr(115)=     0.14534537D0
	rhoarr(116)=     0.12656784D0
	rhoarr(117)=     0.10947712D0
	rhoarr(118)=     0.09405719D0
	rhoarr(119)=     0.08026484D0
	rhoarr(120)=     0.06803430D0
	rhoarr(121)=     0.05728189D0
	rhoarr(122)=     0.04791057D0
	rhoarr(123)=     0.03981412D0
	rhoarr(124)=     0.03288094D0
	rhoarr(125)=     0.02699722D0
	rhoarr(126)=     0.02204975D0
	rhoarr(127)=     0.01792812D0
	rhoarr(128)=     0.01452656D0
	rhoarr(129)=     0.01174542D0
	rhoarr(130)=     0.00949228D0
	rhoarr(131)=     0.00768284D0
	rhoarr(132)=     0.00624140D0
	rhoarr(133)=     0.00510118D0
	rhoarr(134)=     0.00420420D0
	rhoarr(135)=     0.00350099D0
	rhoarr(136)=     0.00294998D0
	rhoarr(137)=     0.00251681D0
	rhoarr(138)=     0.00217346D0
	rhoarr(139)=     0.00189748D0
	rhoarr(140)=     0.00167116D0
	rhoarr(141)=     0.00148084D0
	rhoarr(142)=     0.00131628D0
	rhoarr(143)=     0.00117012D0
	rhoarr(144)=     0.00103731D0
	rhoarr(145)=     0.00091466D0
	rhoarr(146)=     0.00080037D0
	rhoarr(147)=     0.00069366D0
	rhoarr(148)=     0.00059435D0
	rhoarr(149)=     0.00050266D0
	rhoarr(150)=     0.00041893D0
	rhoarr(151)=     0.00034353D0
	rhoarr(152)=     0.00027671D0
	rhoarr(153)=     0.00021857D0
	rhoarr(154)=     0.00016900D0
	rhoarr(155)=     0.00012769D0
	rhoarr(156)=     0.00009412D0
	rhoarr(157)=     0.00006755D0
	rhoarr(158)=     0.00004714D0
	rhoarr(159)=     0.00003192D0
	rhoarr(160)=     0.00002095D0
	rhoarr(161)=     0.00001330D0
	rhoarr(162)=     0.00000814D0
	rhoarr(163)=     0.00000478D0
	rhoarr(164)=     0.00000268D0
	rhoarr(165)=     0.00000142D0
	rhoarr(166)=     0.00000070D0
	rhoarr(167)=     0.00000032D0
	rhoarr(168)=     0.00000013D0
	rhoarr(169)=     0.00000005D0
	rhoarr(170)=     0.00000001D0
	
else if (iele==20) then  !Ca, 0 1, b3lyp/UGBS int(grid=500974,dkh2). Using UGBS is because ANO-RCC for Ca in EMSL is buggy
	npt=  168
	rhoarr(  1)=     8663.06174498D0
	rhoarr(  2)=     8396.72792889D0
	rhoarr(  3)=     7651.30629931D0
	rhoarr(  4)=     6955.83978623D0
	rhoarr(  5)=     6483.95515317D0
	rhoarr(  6)=     6048.61462388D0
	rhoarr(  7)=     5676.60233880D0
	rhoarr(  8)=     5325.92769588D0
	rhoarr(  9)=     4997.60740302D0
	rhoarr( 10)=     4683.90747346D0
	rhoarr( 11)=     4379.69451008D0
	rhoarr( 12)=     4084.51979358D0
	rhoarr( 13)=     3797.64025453D0
	rhoarr( 14)=     3518.50119153D0
	rhoarr( 15)=     3247.42524885D0
	rhoarr( 16)=     2985.19333265D0
	rhoarr( 17)=     2732.64098354D0
	rhoarr( 18)=     2490.56862859D0
	rhoarr( 19)=     2259.74995304D0
	rhoarr( 20)=     2040.91644035D0
	rhoarr( 21)=     1834.70323664D0
	rhoarr( 22)=     1641.59881386D0
	rhoarr( 23)=     1461.92252872D0
	rhoarr( 24)=     1295.81986743D0
	rhoarr( 25)=     1143.26713287D0
	rhoarr( 26)=     1004.08398158D0
	rhoarr( 27)=      877.94906222D0
	rhoarr( 28)=      764.41513213D0
	rhoarr( 29)=      662.92510043D0
	rhoarr( 30)=      572.83088254D0
	rhoarr( 31)=      493.41390728D0
	rhoarr( 32)=      423.90507320D0
	rhoarr( 33)=      363.50336669D0
	rhoarr( 34)=      311.39340185D0
	rhoarr( 35)=      266.76176658D0
	rhoarr( 36)=      228.81143067D0
	rhoarr( 37)=      196.77359539D0
	rhoarr( 38)=      169.91699020D0
	rhoarr( 39)=      147.55503247D0
	rhoarr( 40)=      129.05120880D0
	rhoarr( 41)=      113.82278446D0
	rhoarr( 42)=      101.34283175D0
	rhoarr( 43)=       91.14066018D0
	rhoarr( 44)=       82.80088850D0
	rhoarr( 45)=       75.96147498D0
	rhoarr( 46)=       70.31098664D0
	rhoarr( 47)=       65.58530321D0
	rhoarr( 48)=       61.56388958D0
	rhoarr( 49)=       58.06575629D0
	rhoarr( 50)=       54.94524206D0
	rhoarr( 51)=       52.08776325D0
	rhoarr( 52)=       49.40566331D0
	rhoarr( 53)=       46.83426426D0
	rhoarr( 54)=       44.32818454D0
	rhoarr( 55)=       41.85795669D0
	rhoarr( 56)=       39.40695902D0
	rhoarr( 57)=       36.96866648D0
	rhoarr( 58)=       34.54422151D0
	rhoarr( 59)=       32.14032234D0
	rhoarr( 60)=       29.76742164D0
	rhoarr( 61)=       27.43822162D0
	rhoarr( 62)=       25.16644584D0
	rhoarr( 63)=       22.96586224D0
	rhoarr( 64)=       20.84952887D0
	rhoarr( 65)=       18.82923295D0
	rhoarr( 66)=       16.91509512D0
	rhoarr( 67)=       15.11531385D0
	rhoarr( 68)=       13.43602789D0
	rhoarr( 69)=       11.88127811D0
	rhoarr( 70)=       10.45305155D0
	rhoarr( 71)=        9.15139199D0
	rhoarr( 72)=        7.97456164D0
	rhoarr( 73)=        6.91923875D0
	rhoarr( 74)=        5.98073741D0
	rhoarr( 75)=        5.15323715D0
	rhoarr( 76)=        4.43001267D0
	rhoarr( 77)=        3.80365658D0
	rhoarr( 78)=        3.26629050D0
	rhoarr( 79)=        2.80976165D0
	rhoarr( 80)=        2.42582292D0
	rhoarr( 81)=        2.10629491D0
	rhoarr( 82)=        1.84320826D0
	rhoarr( 83)=        1.62892491D0
	rhoarr( 84)=        1.45623719D0
	rhoarr( 85)=        1.31844438D0
	rhoarr( 86)=        1.20940738D0
	rhoarr( 87)=        1.12358313D0
	rhoarr( 88)=        1.05604104D0
	rhoarr( 89)=        1.00246404D0
	rhoarr( 90)=        0.95913687D0
	rhoarr( 91)=        0.92292396D0
	rhoarr( 92)=        0.89123864D0
	rhoarr( 93)=        0.86200541D0
	rhoarr( 94)=        0.83361659D0
	rhoarr( 95)=        0.80488475D0
	rhoarr( 96)=        0.77499244D0
	rhoarr( 97)=        0.74344068D0
	rhoarr( 98)=        0.70999793D0
	rhoarr( 99)=        0.67465077D0
	rhoarr(100)=        0.63755762D0
	rhoarr(101)=        0.59900608D0
	rhoarr(102)=        0.55937453D0
	rhoarr(103)=        0.51909821D0
	rhoarr(104)=        0.47863959D0
	rhoarr(105)=        0.43846329D0
	rhoarr(106)=        0.39901524D0
	rhoarr(107)=        0.36070615D0
	rhoarr(108)=        0.32389911D0
	rhoarr(109)=        0.28890120D0
	rhoarr(110)=        0.25595879D0
	rhoarr(111)=        0.22525615D0
	rhoarr(112)=        0.19691674D0
	rhoarr(113)=        0.17100674D0
	rhoarr(114)=        0.14754008D0
	rhoarr(115)=        0.12648455D0
	rhoarr(116)=        0.10776838D0
	rhoarr(117)=        0.09128703D0
	rhoarr(118)=        0.07690988D0
	rhoarr(119)=        0.06448671D0
	rhoarr(120)=        0.05385381D0
	rhoarr(121)=        0.04483955D0
	rhoarr(122)=        0.03726959D0
	rhoarr(123)=        0.03097139D0
	rhoarr(124)=        0.02577813D0
	rhoarr(125)=        0.02153187D0
	rhoarr(126)=        0.01808604D0
	rhoarr(127)=        0.01530717D0
	rhoarr(128)=        0.01307584D0
	rhoarr(129)=        0.01128709D0
	rhoarr(130)=        0.00985025D0
	rhoarr(131)=        0.00868836D0
	rhoarr(132)=        0.00773732D0
	rhoarr(133)=        0.00694482D0
	rhoarr(134)=        0.00626916D0
	rhoarr(135)=        0.00567802D0
	rhoarr(136)=        0.00514724D0
	rhoarr(137)=        0.00465954D0
	rhoarr(138)=        0.00420332D0
	rhoarr(139)=        0.00377150D0
	rhoarr(140)=        0.00336047D0
	rhoarr(141)=        0.00296914D0
	rhoarr(142)=        0.00259808D0
	rhoarr(143)=        0.00224889D0
	rhoarr(144)=        0.00192357D0
	rhoarr(145)=        0.00162416D0
	rhoarr(146)=        0.00135235D0
	rhoarr(147)=        0.00110928D0
	rhoarr(148)=        0.00089542D0
	rhoarr(149)=        0.00071049D0
	rhoarr(150)=        0.00055350D0
	rhoarr(151)=        0.00042282D0
	rhoarr(152)=        0.00031627D0
	rhoarr(153)=        0.00023130D0
	rhoarr(154)=        0.00016512D0
	rhoarr(155)=        0.00011486D0
	rhoarr(156)=        0.00007769D0
	rhoarr(157)=        0.00005099D0
	rhoarr(158)=        0.00003238D0
	rhoarr(159)=        0.00001983D0
	rhoarr(160)=        0.00001168D0
	rhoarr(161)=        0.00000658D0
	rhoarr(162)=        0.00000353D0
	rhoarr(163)=        0.00000179D0
	rhoarr(164)=        0.00000086D0
	rhoarr(165)=        0.00000038D0
	rhoarr(166)=        0.00000016D0
	rhoarr(167)=        0.00000006D0
	rhoarr(168)=        0.00000002D0

else if (iele==21) then  !Sc, 3d1 4s2, 0 2, HF/UGBS int=dkh2
	npt=  168
	rhoarr(  1)=    10729.64948464D0
	rhoarr(  2)=    10141.64421859D0
	rhoarr(  3)=     8972.25430475D0
	rhoarr(  4)=     8221.64629596D0
	rhoarr(  5)=     7592.86485944D0
	rhoarr(  6)=     7079.94012072D0
	rhoarr(  7)=     6613.80662073D0
	rhoarr(  8)=     6189.54080800D0
	rhoarr(  9)=     5789.38062152D0
	rhoarr( 10)=     5407.13615494D0
	rhoarr( 11)=     5039.68911270D0
	rhoarr( 12)=     4683.96461459D0
	rhoarr( 13)=     4338.92869397D0
	rhoarr( 14)=     4004.68313957D0
	rhoarr( 15)=     3681.63713798D0
	rhoarr( 16)=     3370.42178725D0
	rhoarr( 17)=     3071.89501395D0
	rhoarr( 18)=     2787.02018231D0
	rhoarr( 19)=     2516.71762541D0
	rhoarr( 20)=     2261.78079271D0
	rhoarr( 21)=     2022.83330169D0
	rhoarr( 22)=     1800.30830787D0
	rhoarr( 23)=     1594.44281976D0
	rhoarr( 24)=     1405.27420473D0
	rhoarr( 25)=     1232.64067352D0
	rhoarr( 26)=     1076.19260041D0
	rhoarr( 27)=      935.41175638D0
	rhoarr( 28)=      809.63308792D0
	rhoarr( 29)=      698.06859977D0
	rhoarr( 30)=      599.83389024D0
	rhoarr( 31)=      513.97523718D0
	rhoarr( 32)=      439.49464979D0
	rhoarr( 33)=      375.37230241D0
	rhoarr( 34)=      320.58702133D0
	rhoarr( 35)=      274.13496065D0
	rhoarr( 36)=      235.04576632D0
	rhoarr( 37)=      202.39558764D0
	rhoarr( 38)=      175.31696232D0
	rhoarr( 39)=      153.00604753D0
	rhoarr( 40)=      134.72760940D0
	rhoarr( 41)=      119.81792041D0
	rhoarr( 42)=      107.68560880D0
	rhoarr( 43)=       97.81062136D0
	rhoarr( 44)=       89.74163790D0
	rhoarr( 45)=       83.09235139D0
	rhoarr( 46)=       77.53697687D0
	rhoarr( 47)=       72.80524637D0
	rhoarr( 48)=       68.67706737D0
	rhoarr( 49)=       64.97699552D0
	rhoarr( 50)=       61.56867677D0
	rhoarr( 51)=       58.34941634D0
	rhoarr( 52)=       55.24501241D0
	rhoarr( 53)=       52.20495468D0
	rhoarr( 54)=       49.19804526D0
	rhoarr( 55)=       46.20846476D0
	rhoarr( 56)=       43.23228465D0
	rhoarr( 57)=       40.27441647D0
	rhoarr( 58)=       37.34598355D0
	rhoarr( 59)=       34.46209778D0
	rhoarr( 60)=       31.64001995D0
	rhoarr( 61)=       28.89767685D0
	rhoarr( 62)=       26.25250280D0
	rhoarr( 63)=       23.72056895D0
	rhoarr( 64)=       21.31596123D0
	rhoarr( 65)=       19.05036790D0
	rhoarr( 66)=       16.93284091D0
	rhoarr( 67)=       14.96969915D0
	rhoarr( 68)=       13.16454706D0
	rhoarr( 69)=       11.51838606D0
	rhoarr( 70)=       10.02979961D0
	rhoarr( 71)=        8.69519400D0
	rhoarr( 72)=        7.50907801D0
	rhoarr( 73)=        6.46436540D0
	rhoarr( 74)=        5.55268522D0
	rhoarr( 75)=        4.76468765D0
	rhoarr( 76)=        4.09033566D0
	rhoarr( 77)=        3.51917617D0
	rhoarr( 78)=        3.04058703D0
	rhoarr( 79)=        2.64399804D0
	rhoarr( 80)=        2.31908502D0
	rhoarr( 81)=        2.05593651D0
	rhoarr( 82)=        1.84519216D0
	rhoarr( 83)=        1.67815254D0
	rhoarr( 84)=        1.54685987D0
	rhoarr( 85)=        1.44415077D0
	rhoarr( 86)=        1.36368258D0
	rhoarr( 87)=        1.29993610D0
	rhoarr( 88)=        1.24819842D0
	rhoarr( 89)=        1.20452934D0
	rhoarr( 90)=        1.16571521D0
	rhoarr( 91)=        1.12921327D0
	rhoarr( 92)=        1.09308911D0
	rhoarr( 93)=        1.05594972D0
	rhoarr( 94)=        1.01687384D0
	rhoarr( 95)=        0.97534182D0
	rhoarr( 96)=        0.93116650D0
	rhoarr( 97)=        0.88442720D0
	rhoarr( 98)=        0.83540802D0
	rhoarr( 99)=        0.78454192D0
	rhoarr(100)=        0.73236127D0
	rhoarr(101)=        0.67945513D0
	rhoarr(102)=        0.62643328D0
	rhoarr(103)=        0.57389665D0
	rhoarr(104)=        0.52241364D0
	rhoarr(105)=        0.47250176D0
	rhoarr(106)=        0.42461430D0
	rhoarr(107)=        0.37913134D0
	rhoarr(108)=        0.33635494D0
	rhoarr(109)=        0.29650792D0
	rhoarr(110)=        0.25973588D0
	rhoarr(111)=        0.22611181D0
	rhoarr(112)=        0.19564270D0
	rhoarr(113)=        0.16827764D0
	rhoarr(114)=        0.14391658D0
	rhoarr(115)=        0.12241945D0
	rhoarr(116)=        0.10361503D0
	rhoarr(117)=        0.08730942D0
	rhoarr(118)=        0.07329365D0
	rhoarr(119)=        0.06135065D0
	rhoarr(120)=        0.05126125D0
	rhoarr(121)=        0.04280937D0
	rhoarr(122)=        0.03578636D0
	rhoarr(123)=        0.02999457D0
	rhoarr(124)=        0.02525012D0
	rhoarr(125)=        0.02138490D0
	rhoarr(126)=        0.01824789D0
	rhoarr(127)=        0.01570573D0
	rhoarr(128)=        0.01364273D0
	rhoarr(129)=        0.01196024D0
	rhoarr(130)=        0.01057570D0
	rhoarr(131)=        0.00942124D0
	rhoarr(132)=        0.00844222D0
	rhoarr(133)=        0.00759558D0
	rhoarr(134)=        0.00684823D0
	rhoarr(135)=        0.00617548D0
	rhoarr(136)=        0.00555963D0
	rhoarr(137)=        0.00498857D0
	rhoarr(138)=        0.00445460D0
	rhoarr(139)=        0.00395333D0
	rhoarr(140)=        0.00348278D0
	rhoarr(141)=        0.00304251D0
	rhoarr(142)=        0.00263305D0
	rhoarr(143)=        0.00225532D0
	rhoarr(144)=        0.00191024D0
	rhoarr(145)=        0.00159850D0
	rhoarr(146)=        0.00132032D0
	rhoarr(147)=        0.00107540D0
	rhoarr(148)=        0.00086284D0
	rhoarr(149)=        0.00068120D0
	rhoarr(150)=        0.00052853D0
	rhoarr(151)=        0.00040248D0
	rhoarr(152)=        0.00030036D0
	rhoarr(153)=        0.00021932D0
	rhoarr(154)=        0.00015642D0
	rhoarr(155)=        0.00010874D0
	rhoarr(156)=        0.00007352D0
	rhoarr(157)=        0.00004823D0
	rhoarr(158)=        0.00003061D0
	rhoarr(159)=        0.00001873D0
	rhoarr(160)=        0.00001101D0
	rhoarr(161)=        0.00000619D0
	rhoarr(162)=        0.00000331D0
	rhoarr(163)=        0.00000168D0
	rhoarr(164)=        0.00000080D0
	rhoarr(165)=        0.00000036D0
	rhoarr(166)=        0.00000015D0
	rhoarr(167)=        0.00000006D0
	rhoarr(168)=        0.00000002D0

else if (iele==22) then  !Ti, 3d2 4s2, 0 3, HF/UGBS int=dkh2
	npt=  168
	rhoarr(  1)=    12731.66534275D0
	rhoarr(  2)=    12003.74937151D0
	rhoarr(  3)=    10559.04202599D0
	rhoarr(  4)=     9634.53326019D0
	rhoarr(  5)=     8862.70031344D0
	rhoarr(  6)=     8235.16040901D0
	rhoarr(  7)=     7666.65438407D0
	rhoarr(  8)=     7150.94081077D0
	rhoarr(  9)=     6666.14612517D0
	rhoarr( 10)=     6204.66795087D0
	rhoarr( 11)=     5762.66873667D0
	rhoarr( 12)=     5336.37552189D0
	rhoarr( 13)=     4924.50968186D0
	rhoarr( 14)=     4527.16088609D0
	rhoarr( 15)=     4144.77038866D0
	rhoarr( 16)=     3778.02793148D0
	rhoarr( 17)=     3427.87804086D0
	rhoarr( 18)=     3095.37198192D0
	rhoarr( 19)=     2781.48818616D0
	rhoarr( 20)=     2487.03295578D0
	rhoarr( 21)=     2212.59248864D0
	rhoarr( 22)=     1958.51274786D0
	rhoarr( 23)=     1724.89742964D0
	rhoarr( 24)=     1511.60852698D0
	rhoarr( 25)=     1318.27157233D0
	rhoarr( 26)=     1144.29357510D0
	rhoarr( 27)=      988.89003989D0
	rhoarr( 28)=      851.11458161D0
	rhoarr( 29)=      729.89043838D0
	rhoarr( 30)=      624.04435770D0
	rhoarr( 31)=      532.34032293D0
	rhoarr( 32)=      453.51012722D0
	rhoarr( 33)=      386.28017162D0
	rhoarr( 34)=      329.39531691D0
	rhoarr( 35)=      281.64000825D0
	rhoarr( 36)=      241.85595487D0
	rhoarr( 37)=      208.95573914D0
	rhoarr( 38)=      181.93249347D0
	rhoarr( 39)=      159.86628235D0
	rhoarr( 40)=      141.92775196D0
	rhoarr( 41)=      127.37931105D0
	rhoarr( 42)=      115.57398559D0
	rhoarr( 43)=      105.95220970D0
	rhoarr( 44)=       98.03699514D0
	rhoarr( 45)=       91.42798686D0
	rhoarr( 46)=       85.79484035D0
	rhoarr( 47)=       80.87022766D0
	rhoarr( 48)=       76.44268227D0
	rhoarr( 49)=       72.34945296D0
	rhoarr( 50)=       68.46953327D0
	rhoarr( 51)=       64.71702706D0
	rhoarr( 52)=       61.03498506D0
	rhoarr( 53)=       57.38980311D0
	rhoarr( 54)=       53.76622550D0
	rhoarr( 55)=       50.16295831D0
	rhoarr( 56)=       46.58887366D0
	rhoarr( 57)=       43.05977404D0
	rhoarr( 58)=       39.59568161D0
	rhoarr( 59)=       36.21861597D0
	rhoarr( 60)=       32.95082146D0
	rhoarr( 61)=       29.81340259D0
	rhoarr( 62)=       26.82532185D0
	rhoarr( 63)=       24.00271145D0
	rhoarr( 64)=       21.35844914D0
	rhoarr( 65)=       18.90195013D0
	rhoarr( 66)=       16.63913147D0
	rhoarr( 67)=       14.57251149D0
	rhoarr( 68)=       12.70141383D0
	rhoarr( 69)=       11.02225078D0
	rhoarr( 70)=        9.52886497D0
	rhoarr( 71)=        8.21291039D0
	rhoarr( 72)=        7.06425447D0
	rhoarr( 73)=        6.07138439D0
	rhoarr( 74)=        5.22180215D0
	rhoarr( 75)=        4.50239597D0
	rhoarr( 76)=        3.89977899D0
	rhoarr( 77)=        3.40059013D0
	rhoarr( 78)=        2.99175503D0
	rhoarr( 79)=        2.66070691D0
	rhoarr( 80)=        2.39556858D0
	rhoarr( 81)=        2.18529657D0
	rhoarr( 82)=        2.01978866D0
	rhoarr( 83)=        1.88995598D0
	rhoarr( 84)=        1.78776141D0
	rhoarr( 85)=        1.70622680D0
	rhoarr( 86)=        1.63941271D0
	rhoarr( 87)=        1.58237496D0
	rhoarr( 88)=        1.53110306D0
	rhoarr( 89)=        1.48244528D0
	rhoarr( 90)=        1.43402477D0
	rhoarr( 91)=        1.38415061D0
	rhoarr( 92)=        1.33172655D0
	rhoarr( 93)=        1.27616008D0
	rhoarr( 94)=        1.21727374D0
	rhoarr( 95)=        1.15522047D0
	rhoarr( 96)=        1.09040466D0
	rhoarr( 97)=        1.02341035D0
	rhoarr( 98)=        0.95493758D0
	rhoarr( 99)=        0.88574782D0
	rhoarr(100)=        0.81661837D0
	rhoarr(101)=        0.74830574D0
	rhoarr(102)=        0.68151728D0
	rhoarr(103)=        0.61689017D0
	rhoarr(104)=        0.55497684D0
	rhoarr(105)=        0.49623602D0
	rhoarr(106)=        0.44102836D0
	rhoarr(107)=        0.38961622D0
	rhoarr(108)=        0.34216674D0
	rhoarr(109)=        0.29875779D0
	rhoarr(110)=        0.25938614D0
	rhoarr(111)=        0.22397723D0
	rhoarr(112)=        0.19239610D0
	rhoarr(113)=        0.16445868D0
	rhoarr(114)=        0.13994314D0
	rhoarr(115)=        0.11860064D0
	rhoarr(116)=        0.10016527D0
	rhoarr(117)=        0.08436289D0
	rhoarr(118)=        0.07091870D0
	rhoarr(119)=        0.05956357D0
	rhoarr(120)=        0.05003902D0
	rhoarr(121)=        0.04210117D0
	rhoarr(122)=        0.03552350D0
	rhoarr(123)=        0.03009885D0
	rhoarr(124)=        0.02564051D0
	rhoarr(125)=        0.02198269D0
	rhoarr(126)=        0.01898043D0
	rhoarr(127)=        0.01650893D0
	rhoarr(128)=        0.01446251D0
	rhoarr(129)=        0.01275315D0
	rhoarr(130)=        0.01130883D0
	rhoarr(131)=        0.01007165D0
	rhoarr(132)=        0.00899594D0
	rhoarr(133)=        0.00804638D0
	rhoarr(134)=        0.00719625D0
	rhoarr(135)=        0.00642582D0
	rhoarr(136)=        0.00572096D0
	rhoarr(137)=        0.00507191D0
	rhoarr(138)=        0.00447224D0
	rhoarr(139)=        0.00391796D0
	rhoarr(140)=        0.00340674D0
	rhoarr(141)=        0.00293736D0
	rhoarr(142)=        0.00250915D0
	rhoarr(143)=        0.00212162D0
	rhoarr(144)=        0.00177419D0
	rhoarr(145)=        0.00146602D0
	rhoarr(146)=        0.00119584D0
	rhoarr(147)=        0.00096200D0
	rhoarr(148)=        0.00076239D0
	rhoarr(149)=        0.00059452D0
	rhoarr(150)=        0.00045563D0
	rhoarr(151)=        0.00034268D0
	rhoarr(152)=        0.00025255D0
	rhoarr(153)=        0.00018208D0
	rhoarr(154)=        0.00012818D0
	rhoarr(155)=        0.00008793D0
	rhoarr(156)=        0.00005864D0
	rhoarr(157)=        0.00003792D0
	rhoarr(158)=        0.00002371D0
	rhoarr(159)=        0.00001429D0
	rhoarr(160)=        0.00000826D0
	rhoarr(161)=        0.00000457D0
	rhoarr(162)=        0.00000240D0
	rhoarr(163)=        0.00000119D0
	rhoarr(164)=        0.00000056D0
	rhoarr(165)=        0.00000024D0
	rhoarr(166)=        0.00000010D0
	rhoarr(167)=        0.00000004D0
	rhoarr(168)=        0.00000001D0

else if (iele==23) then  !V, 3d3 4s2, 0 4, HF/UGBS int=dkh2
	npt=  167
	rhoarr(  1)=    15011.46305755D0
	rhoarr(  2)=    14117.79313421D0
	rhoarr(  3)=    12347.72534701D0
	rhoarr(  4)=    11218.51778624D0
	rhoarr(  5)=    10279.00825817D0
	rhoarr(  6)=     9517.68830485D0
	rhoarr(  7)=     8830.16481815D0
	rhoarr(  8)=     8208.58843851D0
	rhoarr(  9)=     7626.23418412D0
	rhoarr( 10)=     7073.82971448D0
	rhoarr( 11)=     6546.67874721D0
	rhoarr( 12)=     6040.17659104D0
	rhoarr( 13)=     5552.74102927D0
	rhoarr( 14)=     5084.42426127D0
	rhoarr( 15)=     4635.67592010D0
	rhoarr( 16)=     4207.22012976D0
	rhoarr( 17)=     3800.06404255D0
	rhoarr( 18)=     3415.31949673D0
	rhoarr( 19)=     3053.98823807D0
	rhoarr( 20)=     2716.84580863D0
	rhoarr( 21)=     2404.38909832D0
	rhoarr( 22)=     2116.81824993D0
	rhoarr( 23)=     1854.04022175D0
	rhoarr( 24)=     1615.67527292D0
	rhoarr( 25)=     1401.06873517D0
	rhoarr( 26)=     1209.31735451D0
	rhoarr( 27)=     1039.30580051D0
	rhoarr( 28)=      889.74560858D0
	rhoarr( 29)=      759.21555573D0
	rhoarr( 30)=      646.20385086D0
	rhoarr( 31)=      549.14913813D0
	rhoarr( 32)=      466.47690036D0
	rhoarr( 33)=      396.63063168D0
	rhoarr( 34)=      338.09881896D0
	rhoarr( 35)=      289.43808152D0
	rhoarr( 36)=      249.29177812D0
	rhoarr( 37)=      216.40351569D0
	rhoarr( 38)=      189.62585691D0
	rhoarr( 39)=      167.92507089D0
	rhoarr( 40)=      150.38267369D0
	rhoarr( 41)=      136.19416487D0
	rhoarr( 42)=      124.66522187D0
	rhoarr( 43)=      115.20573135D0
	rhoarr( 44)=      107.32221194D0
	rhoarr( 45)=      100.60923284D0
	rhoarr( 46)=       94.74033480D0
	rhoarr( 47)=       89.45880627D0
	rhoarr( 48)=       84.56854976D0
	rhoarr( 49)=       79.92521998D0
	rhoarr( 50)=       75.42780088D0
	rhoarr( 51)=       71.01077545D0
	rhoarr( 52)=       66.63700976D0
	rhoarr( 53)=       62.29142383D0
	rhoarr( 54)=       57.97547040D0
	rhoarr( 55)=       53.70240153D0
	rhoarr( 56)=       49.49327737D0
	rhoarr( 57)=       45.37365981D0
	rhoarr( 58)=       41.37093091D0
	rhoarr( 59)=       37.51217715D0
	rhoarr( 60)=       33.82258191D0
	rhoarr( 61)=       30.32426809D0
	rhoarr( 62)=       27.03553143D0
	rhoarr( 63)=       23.97040355D0
	rhoarr( 64)=       21.13848415D0
	rhoarr( 65)=       18.54498517D0
	rhoarr( 66)=       16.19093600D0
	rhoarr( 67)=       14.07350724D0
	rhoarr( 68)=       12.18641902D0
	rhoarr( 69)=       10.52040702D0
	rhoarr( 70)=        9.06372395D0
	rhoarr( 71)=        7.80265695D0
	rhoarr( 72)=        6.72204234D0
	rhoarr( 73)=        5.80576069D0
	rhoarr( 74)=        5.03719730D0
	rhoarr( 75)=        4.39965623D0
	rhoarr( 76)=        3.87672102D0
	rhoarr( 77)=        3.45255854D0
	rhoarr( 78)=        3.11216681D0
	rhoarr( 79)=        2.84156916D0
	rhoarr( 80)=        2.62795838D0
	rhoarr( 81)=        2.45979473D0
	rhoarr( 82)=        2.32686109D0
	rhoarr( 83)=        2.22027892D0
	rhoarr( 84)=        2.13248879D0
	rhoarr( 85)=        2.05720024D0
	rhoarr( 86)=        1.98931616D0
	rhoarr( 87)=        1.92483790D0
	rhoarr( 88)=        1.86075702D0
	rhoarr( 89)=        1.79493939D0
	rhoarr( 90)=        1.72600652D0
	rhoarr( 91)=        1.65321789D0
	rhoarr( 92)=        1.57635718D0
	rhoarr( 93)=        1.49562468D0
	rhoarr( 94)=        1.41153726D0
	rhoarr( 95)=        1.32483757D0
	rhoarr( 96)=        1.23641314D0
	rhoarr( 97)=        1.14722663D0
	rhoarr( 98)=        1.05825728D0
	rhoarr( 99)=        0.97045382D0
	rhoarr(100)=        0.88469835D0
	rhoarr(101)=        0.80178019D0
	rhoarr(102)=        0.72237858D0
	rhoarr(103)=        0.64705300D0
	rhoarr(104)=        0.57623952D0
	rhoarr(105)=        0.51025227D0
	rhoarr(106)=        0.44928856D0
	rhoarr(107)=        0.39343719D0
	rhoarr(108)=        0.34268880D0
	rhoarr(109)=        0.29694784D0
	rhoarr(110)=        0.25604552D0
	rhoarr(111)=        0.21975317D0
	rhoarr(112)=        0.18779562D0
	rhoarr(113)=        0.15986408D0
	rhoarr(114)=        0.13562818D0
	rhoarr(115)=        0.11474692D0
	rhoarr(116)=        0.09687820D0
	rhoarr(117)=        0.08168687D0
	rhoarr(118)=        0.06885118D0
	rhoarr(119)=        0.05806774D0
	rhoarr(120)=        0.04905492D0
	rhoarr(121)=        0.04155511D0
	rhoarr(122)=        0.03533577D0
	rhoarr(123)=        0.03018970D0
	rhoarr(124)=        0.02593454D0
	rhoarr(125)=        0.02241192D0
	rhoarr(126)=        0.01948605D0
	rhoarr(127)=        0.01704220D0
	rhoarr(128)=        0.01498482D0
	rhoarr(129)=        0.01323563D0
	rhoarr(130)=        0.01173149D0
	rhoarr(131)=        0.01042235D0
	rhoarr(132)=        0.00926917D0
	rhoarr(133)=        0.00824200D0
	rhoarr(134)=        0.00731825D0
	rhoarr(135)=        0.00648117D0
	rhoarr(136)=        0.00571853D0
	rhoarr(137)=        0.00502160D0
	rhoarr(138)=        0.00438421D0
	rhoarr(139)=        0.00380208D0
	rhoarr(140)=        0.00327220D0
	rhoarr(141)=        0.00279233D0
	rhoarr(142)=        0.00236064D0
	rhoarr(143)=        0.00197542D0
	rhoarr(144)=        0.00163485D0
	rhoarr(145)=        0.00133688D0
	rhoarr(146)=        0.00107917D0
	rhoarr(147)=        0.00085906D0
	rhoarr(148)=        0.00067362D0
	rhoarr(149)=        0.00051969D0
	rhoarr(150)=        0.00039396D0
	rhoarr(151)=        0.00029303D0
	rhoarr(152)=        0.00021352D0
	rhoarr(153)=        0.00015216D0
	rhoarr(154)=        0.00010584D0
	rhoarr(155)=        0.00007171D0
	rhoarr(156)=        0.00004722D0
	rhoarr(157)=        0.00003014D0
	rhoarr(158)=        0.00001859D0
	rhoarr(159)=        0.00001104D0
	rhoarr(160)=        0.00000629D0
	rhoarr(161)=        0.00000343D0
	rhoarr(162)=        0.00000177D0
	rhoarr(163)=        0.00000087D0
	rhoarr(164)=        0.00000040D0
	rhoarr(165)=        0.00000017D0
	rhoarr(166)=        0.00000007D0
	rhoarr(167)=        0.00000002D0

else if (iele==24) then  !Cr, 3d5 4s1, 0 7, HF/UGBS int=dkh2
	npt=  167
	rhoarr(  1)=    17591.49744063D0
	rhoarr(  2)=    16502.14929451D0
	rhoarr(  3)=    14349.52959463D0
	rhoarr(  4)=    12981.43375517D0
	rhoarr(  5)=    11846.98840021D0
	rhoarr(  6)=    10930.89811220D0
	rhoarr(  7)=    10106.20386932D0
	rhoarr(  8)=     9363.14730366D0
	rhoarr(  9)=     8669.30133107D0
	rhoarr( 10)=     8013.45506516D0
	rhoarr( 11)=     7389.92484889D0
	rhoarr( 12)=     6793.12334094D0
	rhoarr( 13)=     6221.06371446D0
	rhoarr( 14)=     5673.69366072D0
	rhoarr( 15)=     5151.43644214D0
	rhoarr( 16)=     4655.03993320D0
	rhoarr( 17)=     4185.55676047D0
	rhoarr( 18)=     3744.11576880D0
	rhoarr( 19)=     3331.67789699D0
	rhoarr( 20)=     2948.91912377D0
	rhoarr( 21)=     2596.18151731D0
	rhoarr( 22)=     2273.45508811D0
	rhoarr( 23)=     1980.38185811D0
	rhoarr( 24)=     1716.26604509D0
	rhoarr( 25)=     1480.09438841D0
	rhoarr( 26)=     1270.57535036D0
	rhoarr( 27)=     1086.18947506D0
	rhoarr( 28)=      925.24045097D0
	rhoarr( 29)=      785.90544752D0
	rhoarr( 30)=      666.28558854D0
	rhoarr( 31)=      564.45373922D0
	rhoarr( 32)=      478.49619883D0
	rhoarr( 33)=      406.54782118D0
	rhoarr( 34)=      346.82177837D0
	rhoarr( 35)=      297.63433025D0
	rhoarr( 36)=      257.42383205D0
	rhoarr( 37)=      224.76343575D0
	rhoarr( 38)=      198.36796718D0
	rhoarr( 39)=      177.09609635D0
	rhoarr( 40)=      159.94881115D0
	rhoarr( 41)=      146.06481237D0
	rhoarr( 42)=      134.71326177D0
	rhoarr( 43)=      125.28440525D0
	rhoarr( 44)=      117.27874408D0
	rhoarr( 45)=      110.29544640D0
	rhoarr( 46)=      104.02056012D0
	rhoarr( 47)=       98.21540622D0
	rhoarr( 48)=       92.70539370D0
	rhoarr( 49)=       87.36943135D0
	rhoarr( 50)=       82.13008983D0
	rhoarr( 51)=       76.94464867D0
	rhoarr( 52)=       71.79712725D0
	rhoarr( 53)=       66.69134606D0
	rhoarr( 54)=       61.64501128D0
	rhoarr( 55)=       56.68477148D0
	rhoarr( 56)=       51.84216945D0
	rhoarr( 57)=       47.15040033D0
	rhoarr( 58)=       42.64178761D0
	rhoarr( 59)=       38.34589263D0
	rhoarr( 60)=       34.28817907D0
	rhoarr( 61)=       30.48915680D0
	rhoarr( 62)=       26.96393094D0
	rhoarr( 63)=       23.72208243D0
	rhoarr( 64)=       20.76780891D0
	rhoarr( 65)=       18.10025953D0
	rhoarr( 66)=       15.71400661D0
	rhoarr( 67)=       13.59960726D0
	rhoarr( 68)=       11.74421887D0
	rhoarr( 69)=       10.13224098D0
	rhoarr( 70)=        8.74596168D0
	rhoarr( 71)=        7.56618951D0
	rhoarr( 72)=        6.57285355D0
	rhoarr( 73)=        5.74555572D0
	rhoarr( 74)=        5.06406205D0
	rhoarr( 75)=        4.50872374D0
	rhoarr( 76)=        4.06082354D0
	rhoarr( 77)=        3.70284764D0
	rhoarr( 78)=        3.41868716D0
	rhoarr( 79)=        3.19377529D0
	rhoarr( 80)=        3.01516700D0
	rhoarr( 81)=        2.87156811D0
	rhoarr( 82)=        2.75331990D0
	rhoarr( 83)=        2.65234522D0
	rhoarr( 84)=        2.56206223D0
	rhoarr( 85)=        2.47727202D0
	rhoarr( 86)=        2.39402721D0
	rhoarr( 87)=        2.30948833D0
	rhoarr( 88)=        2.22177480D0
	rhoarr( 89)=        2.12981621D0
	rhoarr( 90)=        2.03320862D0
	rhoarr( 91)=        1.93207918D0
	rhoarr( 92)=        1.82696143D0
	rhoarr( 93)=        1.71868258D0
	rhoarr( 94)=        1.60826356D0
	rhoarr( 95)=        1.49683249D0
	rhoarr( 96)=        1.38555150D0
	rhoarr( 97)=        1.27555710D0
	rhoarr( 98)=        1.16791358D0
	rhoarr( 99)=        1.06357882D0
	rhoarr(100)=        0.96338130D0
	rhoarr(101)=        0.86800694D0
	rhoarr(102)=        0.77799427D0
	rhoarr(103)=        0.69373616D0
	rhoarr(104)=        0.61548668D0
	rhoarr(105)=        0.54337160D0
	rhoarr(106)=        0.47740139D0
	rhoarr(107)=        0.41748575D0
	rhoarr(108)=        0.36344885D0
	rhoarr(109)=        0.31504465D0
	rhoarr(110)=        0.27197191D0
	rhoarr(111)=        0.23388839D0
	rhoarr(112)=        0.20042404D0
	rhoarr(113)=        0.17119303D0
	rhoarr(114)=        0.14580439D0
	rhoarr(115)=        0.12387124D0
	rhoarr(116)=        0.10501847D0
	rhoarr(117)=        0.08888895D0
	rhoarr(118)=        0.07514807D0
	rhoarr(119)=        0.06348693D0
	rhoarr(120)=        0.05362404D0
	rhoarr(121)=        0.04530588D0
	rhoarr(122)=        0.03830653D0
	rhoarr(123)=        0.03242651D0
	rhoarr(124)=        0.02749127D0
	rhoarr(125)=        0.02334933D0
	rhoarr(126)=        0.01987037D0
	rhoarr(127)=        0.01694333D0
	rhoarr(128)=        0.01447439D0
	rhoarr(129)=        0.01238515D0
	rhoarr(130)=        0.01061064D0
	rhoarr(131)=        0.00909750D0
	rhoarr(132)=        0.00780217D0
	rhoarr(133)=        0.00668919D0
	rhoarr(134)=        0.00572970D0
	rhoarr(135)=        0.00490018D0
	rhoarr(136)=        0.00418137D0
	rhoarr(137)=        0.00355743D0
	rhoarr(138)=        0.00301532D0
	rhoarr(139)=        0.00254426D0
	rhoarr(140)=        0.00213529D0
	rhoarr(141)=        0.00178095D0
	rhoarr(142)=        0.00147491D0
	rhoarr(143)=        0.00121171D0
	rhoarr(144)=        0.00098661D0
	rhoarr(145)=        0.00079535D0
	rhoarr(146)=        0.00063410D0
	rhoarr(147)=        0.00049936D0
	rhoarr(148)=        0.00038794D0
	rhoarr(149)=        0.00029689D0
	rhoarr(150)=        0.00022349D0
	rhoarr(151)=        0.00016522D0
	rhoarr(152)=        0.00011975D0
	rhoarr(153)=        0.00008495D0
	rhoarr(154)=        0.00005886D0
	rhoarr(155)=        0.00003976D0
	rhoarr(156)=        0.00002611D0
	rhoarr(157)=        0.00001663D0
	rhoarr(158)=        0.00001024D0
	rhoarr(159)=        0.00000608D0
	rhoarr(160)=        0.00000347D0
	rhoarr(161)=        0.00000189D0
	rhoarr(162)=        0.00000098D0
	rhoarr(163)=        0.00000048D0
	rhoarr(164)=        0.00000022D0
	rhoarr(165)=        0.00000009D0
	rhoarr(166)=        0.00000004D0
	rhoarr(167)=        0.00000001D0

else if (iele==25) then  !Mn, 3d5 4s2, 0 6, HF/UGBS int=dkh2
	npt=  167
	rhoarr(  1)=    20521.75576905D0
	rhoarr(  2)=    19203.01933142D0
	rhoarr(  3)=    16602.48489969D0
	rhoarr(  4)=    14954.99666340D0
	rhoarr(  5)=    13593.61136511D0
	rhoarr(  6)=    12498.01086539D0
	rhoarr(  7)=    11514.87689825D0
	rhoarr(  8)=    10632.09717535D0
	rhoarr(  9)=     9810.57550875D0
	rhoarr( 10)=     9036.79676737D0
	rhoarr( 11)=     8303.87204090D0
	rhoarr( 12)=     7605.04241817D0
	rhoarr( 13)=     6937.84461310D0
	rhoarr( 14)=     6302.09369515D0
	rhoarr( 15)=     5698.13877001D0
	rhoarr( 16)=     5126.68494082D0
	rhoarr( 17)=     4588.76818963D0
	rhoarr( 18)=     4085.48404720D0
	rhoarr( 19)=     3617.70292164D0
	rhoarr( 20)=     3185.93910045D0
	rhoarr( 21)=     2790.30140006D0
	rhoarr( 22)=     2430.47999819D0
	rhoarr( 23)=     2105.75895164D0
	rhoarr( 24)=     1815.03578588D0
	rhoarr( 25)=     1556.85271060D0
	rhoarr( 26)=     1329.44905837D0
	rhoarr( 27)=     1130.82552950D0
	rhoarr( 28)=      958.80792470D0
	rhoarr( 29)=      811.10858133D0
	rhoarr( 30)=      685.38645135D0
	rhoarr( 31)=      579.30267446D0
	rhoarr( 32)=      490.56794080D0
	rhoarr( 33)=      416.98128415D0
	rhoarr( 34)=      356.46184279D0
	rhoarr( 35)=      307.07416642D0
	rhoarr( 36)=      267.04641145D0
	rhoarr( 37)=      234.78103650D0
	rhoarr( 38)=      208.85874382D0
	rhoarr( 39)=      188.03708799D0
	rhoarr( 40)=      171.24502559D0
	rhoarr( 41)=      157.57422529D0
	rhoarr( 42)=      146.26772851D0
	rhoarr( 43)=      136.70661900D0
	rhoarr( 44)=      128.39549027D0
	rhoarr( 45)=      120.94749029D0
	rhoarr( 46)=      114.06955872D0
	rhoarr( 47)=      107.54825902D0
	rhoarr( 48)=      101.23644666D0
	rhoarr( 49)=       95.04093247D0
	rhoarr( 50)=       88.91126755D0
	rhoarr( 51)=       82.82975142D0
	rhoarr( 52)=       76.80272579D0
	rhoarr( 53)=       70.85316223D0
	rhoarr( 54)=       65.01449736D0
	rhoarr( 55)=       59.32562578D0
	rhoarr( 56)=       53.82693517D0
	rhoarr( 57)=       48.55725959D0
	rhoarr( 58)=       43.55163102D0
	rhoarr( 59)=       38.83971877D0
	rhoarr( 60)=       34.44485690D0
	rhoarr( 61)=       30.38356727D0
	rhoarr( 62)=       26.66548959D0
	rhoarr( 63)=       23.29363297D0
	rhoarr( 64)=       20.26486707D0
	rhoarr( 65)=       17.57057862D0
	rhoarr( 66)=       15.19742986D0
	rhoarr( 67)=       13.12816880D0
	rhoarr( 68)=       11.34245388D0
	rhoarr( 69)=        9.81766585D0
	rhoarr( 70)=        8.52968617D0
	rhoarr( 71)=        7.45362500D0
	rhoarr( 72)=        6.56448316D0
	rhoarr( 73)=        5.83773490D0
	rhoarr( 74)=        5.24982120D0
	rhoarr( 75)=        4.77854787D0
	rhoarr( 76)=        4.40338821D0
	rhoarr( 77)=        4.10569488D0
	rhoarr( 78)=        3.86882929D0
	rhoarr( 79)=        3.67821878D0
	rhoarr( 80)=        3.52135222D0
	rhoarr( 81)=        3.38772401D0
	rhoarr( 82)=        3.26873550D0
	rhoarr( 83)=        3.15756219D0
	rhoarr( 84)=        3.04899458D0
	rhoarr( 85)=        2.93926089D0
	rhoarr( 86)=        2.82583938D0
	rhoarr( 87)=        2.70726806D0
	rhoarr( 88)=        2.58295846D0
	rhoarr( 89)=        2.45301900D0
	rhoarr( 90)=        2.31809196D0
	rhoarr( 91)=        2.17920657D0
	rhoarr( 92)=        2.03764943D0
	rhoarr( 93)=        1.89485272D0
	rhoarr( 94)=        1.75229986D0
	rhoarr( 95)=        1.61144820D0
	rhoarr( 96)=        1.47366786D0
	rhoarr( 97)=        1.34019597D0
	rhoarr( 98)=        1.21210494D0
	rhoarr( 99)=        1.09028338D0
	rhoarr(100)=        0.97542815D0
	rhoarr(101)=        0.86804543D0
	rhoarr(102)=        0.76845909D0
	rhoarr(103)=        0.67682448D0
	rhoarr(104)=        0.59314591D0
	rhoarr(105)=        0.51729634D0
	rhoarr(106)=        0.44903809D0
	rhoarr(107)=        0.38804352D0
	rhoarr(108)=        0.33391498D0
	rhoarr(109)=        0.28620344D0
	rhoarr(110)=        0.24442546D0
	rhoarr(111)=        0.20807830D0
	rhoarr(112)=        0.17665313D0
	rhoarr(113)=        0.14964639D0
	rhoarr(114)=        0.12656921D0
	rhoarr(115)=        0.10695519D0
	rhoarr(116)=        0.09036640D0
	rhoarr(117)=        0.07639775D0
	rhoarr(118)=        0.06467981D0
	rhoarr(119)=        0.05488009D0
	rhoarr(120)=        0.04670305D0
	rhoarr(121)=        0.03988892D0
	rhoarr(122)=        0.03421179D0
	rhoarr(123)=        0.02947705D0
	rhoarr(124)=        0.02551858D0
	rhoarr(125)=        0.02219592D0
	rhoarr(126)=        0.01939140D0
	rhoarr(127)=        0.01700751D0
	rhoarr(128)=        0.01496440D0
	rhoarr(129)=        0.01319748D0
	rhoarr(130)=        0.01165523D0
	rhoarr(131)=        0.01029704D0
	rhoarr(132)=        0.00909132D0
	rhoarr(133)=        0.00801372D0
	rhoarr(134)=        0.00704557D0
	rhoarr(135)=        0.00617264D0
	rhoarr(136)=        0.00538403D0
	rhoarr(137)=        0.00467138D0
	rhoarr(138)=        0.00402821D0
	rhoarr(139)=        0.00344938D0
	rhoarr(140)=        0.00293067D0
	rhoarr(141)=        0.00246847D0
	rhoarr(142)=        0.00205950D0
	rhoarr(143)=        0.00170059D0
	rhoarr(144)=        0.00138853D0
	rhoarr(145)=        0.00112004D0
	rhoarr(146)=        0.00089167D0
	rhoarr(147)=        0.00069988D0
	rhoarr(148)=        0.00054099D0
	rhoarr(149)=        0.00041132D0
	rhoarr(150)=        0.00030719D0
	rhoarr(151)=        0.00022503D0
	rhoarr(152)=        0.00016143D0
	rhoarr(153)=        0.00011321D0
	rhoarr(154)=        0.00007747D0
	rhoarr(155)=        0.00005161D0
	rhoarr(156)=        0.00003340D0
	rhoarr(157)=        0.00002094D0
	rhoarr(158)=        0.00001268D0
	rhoarr(159)=        0.00000739D0
	rhoarr(160)=        0.00000413D0
	rhoarr(161)=        0.00000220D0
	rhoarr(162)=        0.00000112D0
	rhoarr(163)=        0.00000053D0
	rhoarr(164)=        0.00000024D0
	rhoarr(165)=        0.00000010D0
	rhoarr(166)=        0.00000004D0
	rhoarr(167)=        0.00000001D0

else if (iele==26) then  !Fe, 3d6 4s2, 0 5, HF/UGBS int=dkh2
	npt=  166
	rhoarr(  1)=    24893.18430069D0
	rhoarr(  2)=    22301.41107168D0
	rhoarr(  3)=    19120.12118273D0
	rhoarr(  4)=    17103.89790039D0
	rhoarr(  5)=    15533.94219879D0
	rhoarr(  6)=    14205.53868338D0
	rhoarr(  7)=    13053.92891346D0
	rhoarr(  8)=    12007.65201965D0
	rhoarr(  9)=    11041.88931005D0
	rhoarr( 10)=    10136.88426167D0
	rhoarr( 11)=     9280.48965843D0
	rhoarr( 12)=     8467.60335975D0
	rhoarr( 13)=     7695.29548903D0
	rhoarr( 14)=     6962.24058347D0
	rhoarr( 15)=     6268.60270863D0
	rhoarr( 16)=     5615.29124253D0
	rhoarr( 17)=     5003.36015619D0
	rhoarr( 18)=     4433.72120600D0
	rhoarr( 19)=     3906.99698307D0
	rhoarr( 20)=     3423.44031184D0
	rhoarr( 21)=     2982.85708305D0
	rhoarr( 22)=     2584.56133043D0
	rhoarr( 23)=     2227.38471753D0
	rhoarr( 24)=     1909.71321484D0
	rhoarr( 25)=     1629.54113738D0
	rhoarr( 26)=     1384.54470111D0
	rhoarr( 27)=     1172.16287071D0
	rhoarr( 28)=      989.67346277D0
	rhoarr( 29)=      834.26462060D0
	rhoarr( 30)=      703.10378189D0
	rhoarr( 31)=      593.40076172D0
	rhoarr( 32)=      502.46061525D0
	rhoarr( 33)=      427.72572640D0
	rhoarr( 34)=      366.80883996D0
	rhoarr( 35)=      317.51785262D0
	rhoarr( 36)=      277.87192702D0
	rhoarr( 37)=      246.10883588D0
	rhoarr( 38)=      220.68466239D0
	rhoarr( 39)=      200.26765966D0
	rhoarr( 40)=      183.72784596D0
	rhoarr( 41)=      170.12336922D0
	rhoarr( 42)=      158.68438685D0
	rhoarr( 43)=      148.79524464D0
	rhoarr( 44)=      139.97584497D0
	rhoarr( 45)=      131.86305596D0
	rhoarr( 46)=      124.19281597D0
	rhoarr( 47)=      116.78334438D0
	rhoarr( 48)=      109.51968430D0
	rhoarr( 49)=      102.33970357D0
	rhoarr( 50)=       95.22163737D0
	rhoarr( 51)=       88.17322567D0
	rhoarr( 52)=       81.22245782D0
	rhoarr( 53)=       74.40988320D0
	rhoarr( 54)=       67.78239336D0
	rhoarr( 55)=       61.38833960D0
	rhoarr( 56)=       55.27382656D0
	rhoarr( 57)=       49.48001884D0
	rhoarr( 58)=       44.04130685D0
	rhoarr( 59)=       38.98419476D0
	rhoarr( 60)=       34.32678951D0
	rhoarr( 61)=       30.07878212D0
	rhoarr( 62)=       26.24181940D0
	rhoarr( 63)=       22.81016940D0
	rhoarr( 64)=       19.77158936D0
	rhoarr( 65)=       17.10831488D0
	rhoarr( 66)=       14.79810245D0
	rhoarr( 67)=       12.81527328D0
	rhoarr( 68)=       11.13172170D0
	rhoarr( 69)=        9.71786308D0
	rhoarr( 70)=        8.54350385D0
	rhoarr( 71)=        7.57862037D0
	rhoarr( 72)=        6.79403518D0
	rhoarr( 73)=        6.16198186D0
	rhoarr( 74)=        5.65655292D0
	rhoarr( 75)=        5.25403030D0
	rhoarr( 76)=        4.93310373D0
	rhoarr( 77)=        4.67498685D0
	rhoarr( 78)=        4.46344459D0
	rhoarr( 79)=        4.28474656D0
	rhoarr( 80)=        4.12756087D0
	rhoarr( 81)=        3.98280152D0
	rhoarr( 82)=        3.84344064D0
	rhoarr( 83)=        3.70429601D0
	rhoarr( 84)=        3.56180298D0
	rhoarr( 85)=        3.41377962D0
	rhoarr( 86)=        3.25919331D0
	rhoarr( 87)=        3.09793620D0
	rhoarr( 88)=        2.93061548D0
	rhoarr( 89)=        2.75836303D0
	rhoarr( 90)=        2.58266725D0
	rhoarr( 91)=        2.40522808D0
	rhoarr( 92)=        2.22783520D0
	rhoarr( 93)=        2.05226846D0
	rhoarr( 94)=        1.88021900D0
	rhoarr( 95)=        1.71322950D0
	rhoarr( 96)=        1.55265169D0
	rhoarr( 97)=        1.39961926D0
	rhoarr( 98)=        1.25503442D0
	rhoarr( 99)=        1.11956577D0
	rhoarr(100)=        0.99365584D0
	rhoarr(101)=        0.87753578D0
	rhoarr(102)=        0.77124556D0
	rhoarr(103)=        0.67465764D0
	rhoarr(104)=        0.58750263D0
	rhoarr(105)=        0.50939541D0
	rhoarr(106)=        0.43986064D0
	rhoarr(107)=        0.37835685D0
	rhoarr(108)=        0.32429828D0
	rhoarr(109)=        0.27707417D0
	rhoarr(110)=        0.23606531D0
	rhoarr(111)=        0.20065783D0
	rhoarr(112)=        0.17025446D0
	rhoarr(113)=        0.14428340D0
	rhoarr(114)=        0.12220526D0
	rhoarr(115)=        0.10351814D0
	rhoarr(116)=        0.08776114D0
	rhoarr(117)=        0.07451643D0
	rhoarr(118)=        0.06340996D0
	rhoarr(119)=        0.05411085D0
	rhoarr(120)=        0.04632977D0
	rhoarr(121)=        0.03981637D0
	rhoarr(122)=        0.03435610D0
	rhoarr(123)=        0.02976661D0
	rhoarr(124)=        0.02589419D0
	rhoarr(125)=        0.02261024D0
	rhoarr(126)=        0.01980800D0
	rhoarr(127)=        0.01739964D0
	rhoarr(128)=        0.01531363D0
	rhoarr(129)=        0.01349234D0
	rhoarr(130)=        0.01188989D0
	rhoarr(131)=        0.01047014D0
	rhoarr(132)=        0.00920486D0
	rhoarr(133)=        0.00807217D0
	rhoarr(134)=        0.00705508D0
	rhoarr(135)=        0.00614035D0
	rhoarr(136)=        0.00531754D0
	rhoarr(137)=        0.00457834D0
	rhoarr(138)=        0.00391594D0
	rhoarr(139)=        0.00332463D0
	rhoarr(140)=        0.00279949D0
	rhoarr(141)=        0.00233607D0
	rhoarr(142)=        0.00193017D0
	rhoarr(143)=        0.00157774D0
	rhoarr(144)=        0.00127471D0
	rhoarr(145)=        0.00101698D0
	rhoarr(146)=        0.00080038D0
	rhoarr(147)=        0.00062071D0
	rhoarr(148)=        0.00047377D0
	rhoarr(149)=        0.00035546D0
	rhoarr(150)=        0.00026178D0
	rhoarr(151)=        0.00018895D0
	rhoarr(152)=        0.00013344D0
	rhoarr(153)=        0.00009204D0
	rhoarr(154)=        0.00006187D0
	rhoarr(155)=        0.00004044D0
	rhoarr(156)=        0.00002565D0
	rhoarr(157)=        0.00001573D0
	rhoarr(158)=        0.00000931D0
	rhoarr(159)=        0.00000529D0
	rhoarr(160)=        0.00000288D0
	rhoarr(161)=        0.00000149D0
	rhoarr(162)=        0.00000073D0
	rhoarr(163)=        0.00000034D0
	rhoarr(164)=        0.00000015D0
	rhoarr(165)=        0.00000006D0
	rhoarr(166)=        0.00000002D0

else if (iele==27) then  !Co, 3d7 4s2, 0 4, HF/UGBS int=dkh2
	npt=  166
	rhoarr(  1)=    28802.03785713D0
	rhoarr(  2)=    25703.57726571D0
	rhoarr(  3)=    21907.94877619D0
	rhoarr(  4)=    19510.71061803D0
	rhoarr(  5)=    17650.72306447D0
	rhoarr(  6)=    16082.19804048D0
	rhoarr(  7)=    14727.04673534D0
	rhoarr(  8)=    13499.98660541D0
	rhoarr(  9)=    12371.32128031D0
	rhoarr( 10)=    11317.46213423D0
	rhoarr( 11)=    10323.91033812D0
	rhoarr( 12)=     9384.49158949D0
	rhoarr( 13)=     8495.56435668D0
	rhoarr( 14)=     7655.34739054D0
	rhoarr( 15)=     6863.77862282D0
	rhoarr( 16)=     6121.63266437D0
	rhoarr( 17)=     5429.81376271D0
	rhoarr( 18)=     4789.02539197D0
	rhoarr( 19)=     4199.60851539D0
	rhoarr( 20)=     3661.45834534D0
	rhoarr( 21)=     3173.94540902D0
	rhoarr( 22)=     2735.87420773D0
	rhoarr( 23)=     2345.50479370D0
	rhoarr( 24)=     2000.60546373D0
	rhoarr( 25)=     1698.52448856D0
	rhoarr( 26)=     1436.28249250D0
	rhoarr( 27)=     1210.67108088D0
	rhoarr( 28)=     1018.34395902D0
	rhoarr( 29)=      855.90071745D0
	rhoarr( 30)=      719.96575477D0
	rhoarr( 31)=      607.25870967D0
	rhoarr( 32)=      514.65180838D0
	rhoarr( 33)=      439.21380297D0
	rhoarr( 34)=      378.24269972D0
	rhoarr( 35)=      329.28848302D0
	rhoarr( 36)=      290.16567812D0
	rhoarr( 37)=      258.95597276D0
	rhoarr( 38)=      234.00241537D0
	rhoarr( 39)=      213.89738701D0
	rhoarr( 40)=      197.46624395D0
	rhoarr( 41)=      183.74789371D0
	rhoarr( 42)=      171.97321601D0
	rhoarr( 43)=      161.54223826D0
	rhoarr( 44)=      152.00104854D0
	rhoarr( 45)=      143.01935452D0
	rhoarr( 46)=      134.36936281D0
	rhoarr( 47)=      125.90637709D0
	rhoarr( 48)=      117.55130377D0
	rhoarr( 49)=      109.27513755D0
	rhoarr( 50)=      101.08544790D0
	rhoarr( 51)=       93.01485447D0
	rhoarr( 52)=       85.11144056D0
	rhoarr( 53)=       77.43100375D0
	rhoarr( 54)=       70.03099320D0
	rhoarr( 55)=       62.96594521D0
	rhoarr( 56)=       56.28421013D0
	rhoarr( 57)=       50.02576516D0
	rhoarr( 58)=       44.22092491D0
	rhoarr( 59)=       38.88978521D0
	rhoarr( 60)=       34.04225901D0
	rhoarr( 61)=       29.67858003D0
	rhoarr( 62)=       25.79016067D0
	rhoarr( 63)=       22.36069720D0
	rhoarr( 64)=       19.36742375D0
	rhoarr( 65)=       16.78242814D0
	rhoarr( 66)=       14.57395921D0
	rhoarr( 67)=       12.70767417D0
	rhoarr( 68)=       11.14779175D0
	rhoarr( 69)=        9.85813077D0
	rhoarr( 70)=        8.80302229D0
	rhoarr( 71)=        7.94808784D0
	rhoarr( 72)=        7.26087851D0
	rhoarr( 73)=        6.71137236D0
	rhoarr( 74)=        6.27233111D0
	rhoarr( 75)=        5.91952215D0
	rhoarr( 76)=        5.63181764D0
	rhoarr( 77)=        5.39118653D0
	rhoarr( 78)=        5.18259833D0
	rhoarr( 79)=        4.99385778D0
	rhoarr( 80)=        4.81538823D0
	rhoarr( 81)=        4.63997935D0
	rhoarr( 82)=        4.46251249D0
	rhoarr( 83)=        4.27967460D0
	rhoarr( 84)=        4.08967082D0
	rhoarr( 85)=        3.89194409D0
	rhoarr( 86)=        3.68690944D0
	rhoarr( 87)=        3.47570931D0
	rhoarr( 88)=        3.25999453D0
	rhoarr( 89)=        3.04173375D0
	rhoarr( 90)=        2.82305258D0
	rhoarr( 91)=        2.60610168D0
	rhoarr( 92)=        2.39295244D0
	rhoarr( 93)=        2.18551760D0
	rhoarr( 94)=        1.98549437D0
	rhoarr( 95)=        1.79432700D0
	rhoarr( 96)=        1.61318627D0
	rhoarr( 97)=        1.44296315D0
	rhoarr( 98)=        1.28427416D0
	rhoarr( 99)=        1.13747592D0
	rhoarr(100)=        1.00268682D0
	rhoarr(101)=        0.87981351D0
	rhoarr(102)=        0.76858052D0
	rhoarr(103)=        0.66856128D0
	rhoarr(104)=        0.57920926D0
	rhoarr(105)=        0.49988794D0
	rhoarr(106)=        0.42989878D0
	rhoarr(107)=        0.36850634D0
	rhoarr(108)=        0.31496016D0
	rhoarr(109)=        0.26851303D0
	rhoarr(110)=        0.22843571D0
	rhoarr(111)=        0.19402826D0
	rhoarr(112)=        0.16462850D0
	rhoarr(113)=        0.13961781D0
	rhoarr(114)=        0.11842512D0
	rhoarr(115)=        0.10052907D0
	rhoarr(116)=        0.08545903D0
	rhoarr(117)=        0.07279485D0
	rhoarr(118)=        0.06216567D0
	rhoarr(119)=        0.05324769D0
	rhoarr(120)=        0.04576122D0
	rhoarr(121)=        0.03946697D0
	rhoarr(122)=        0.03416199D0
	rhoarr(123)=        0.02967543D0
	rhoarr(124)=        0.02586439D0
	rhoarr(125)=        0.02261002D0
	rhoarr(126)=        0.01981412D0
	rhoarr(127)=        0.01739610D0
	rhoarr(128)=        0.01529031D0
	rhoarr(129)=        0.01344383D0
	rhoarr(130)=        0.01181436D0
	rhoarr(131)=        0.01036839D0
	rhoarr(132)=        0.00907958D0
	rhoarr(133)=        0.00792721D0
	rhoarr(134)=        0.00689497D0
	rhoarr(135)=        0.00596988D0
	rhoarr(136)=        0.00514147D0
	rhoarr(137)=        0.00440112D0
	rhoarr(138)=        0.00374158D0
	rhoarr(139)=        0.00315658D0
	rhoarr(140)=        0.00264058D0
	rhoarr(141)=        0.00218846D0
	rhoarr(142)=        0.00179543D0
	rhoarr(143)=        0.00145682D0
	rhoarr(144)=        0.00116801D0
	rhoarr(145)=        0.00092441D0
	rhoarr(146)=        0.00072145D0
	rhoarr(147)=        0.00055460D0
	rhoarr(148)=        0.00041943D0
	rhoarr(149)=        0.00031164D0
	rhoarr(150)=        0.00022717D0
	rhoarr(151)=        0.00016220D0
	rhoarr(152)=        0.00011324D0
	rhoarr(153)=        0.00007716D0
	rhoarr(154)=        0.00005120D0
	rhoarr(155)=        0.00003301D0
	rhoarr(156)=        0.00002062D0
	rhoarr(157)=        0.00001245D0
	rhoarr(158)=        0.00000724D0
	rhoarr(159)=        0.00000404D0
	rhoarr(160)=        0.00000216D0
	rhoarr(161)=        0.00000109D0
	rhoarr(162)=        0.00000052D0
	rhoarr(163)=        0.00000024D0
	rhoarr(164)=        0.00000010D0
	rhoarr(165)=        0.00000004D0
	rhoarr(166)=        0.00000001D0

else if (iele==28) then  !Ni, 3d8 4s2, 0 3, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=    33204.53221796D0
	rhoarr(  2)=    29508.99327603D0
	rhoarr(  3)=    24999.24400309D0
	rhoarr(  4)=    22164.21110647D0
	rhoarr(  5)=    19972.67391075D0
	rhoarr(  6)=    18130.67342052D0
	rhoarr(  7)=    16544.83916656D0
	rhoarr(  8)=    15113.72737543D0
	rhoarr(  9)=    13802.03534169D0
	rhoarr( 10)=    12581.71542805D0
	rhoarr( 11)=    11435.51777503D0
	rhoarr( 12)=    10355.99753958D0
	rhoarr( 13)=     9338.63904620D0
	rhoarr( 14)=     8381.07037236D0
	rhoarr( 15)=     7482.89812569D0
	rhoarr( 16)=     6644.66595129D0
	rhoarr( 17)=     5867.02610424D0
	rhoarr( 18)=     5150.36207186D0
	rhoarr( 19)=     4494.61358124D0
	rhoarr( 20)=     3899.19324734D0
	rhoarr( 21)=     3362.90792958D0
	rhoarr( 22)=     2883.92334663D0
	rhoarr( 23)=     2459.80085035D0
	rhoarr( 24)=     2087.56939316D0
	rhoarr( 25)=     1763.81792659D0
	rhoarr( 26)=     1484.80909045D0
	rhoarr( 27)=     1246.59739820D0
	rhoarr( 28)=     1045.13636968D0
	rhoarr( 29)=      876.37494135D0
	rhoarr( 30)=      736.34609231D0
	rhoarr( 31)=      621.24388567D0
	rhoarr( 32)=      527.48415858D0
	rhoarr( 33)=      451.74887537D0
	rhoarr( 34)=      391.01694104D0
	rhoarr( 35)=      342.58317424D0
	rhoarr( 36)=      304.06565319D0
	rhoarr( 37)=      273.40204288D0
	rhoarr( 38)=      248.83686925D0
	rhoarr( 39)=      228.90236886D0
	rhoarr( 40)=      212.39514893D0
	rhoarr( 41)=      198.35015466D0
	rhoarr( 42)=      186.01301406D0
	rhoarr( 43)=      174.81177998D0
	rhoarr( 44)=      164.32912374D0
	rhoarr( 45)=      154.27592164D0
	rhoarr( 46)=      144.46690428D0
	rhoarr( 47)=      134.79873101D0
	rhoarr( 48)=      125.23061741D0
	rhoarr( 49)=      115.76751316D0
	rhoarr( 50)=      106.44576892D0
	rhoarr( 51)=       97.32119919D0
	rhoarr( 52)=       88.45941381D0
	rhoarr( 53)=       79.92824830D0
	rhoarr( 54)=       71.79207928D0
	rhoarr( 55)=       64.10777949D0
	rhoarr( 56)=       56.92205414D0
	rhoarr( 57)=       50.26990950D0
	rhoarr( 58)=       44.17403017D0
	rhoarr( 59)=       38.64487442D0
	rhoarr( 60)=       33.68132715D0
	rhoarr( 61)=       29.27177296D0
	rhoarr( 62)=       25.39546539D0
	rhoarr( 63)=       22.02407803D0
	rhoarr( 64)=       19.12333318D0
	rhoarr( 65)=       16.65461829D0
	rhoarr( 66)=       14.57652008D0
	rhoarr( 67)=       12.84622782D0
	rhoarr( 68)=       11.42077723D0
	rhoarr( 69)=       10.25812202D0
	rhoarr( 70)=        9.31802898D0
	rhoarr( 71)=        8.56279761D0
	rhoarr( 72)=        7.95780722D0
	rhoarr( 73)=        7.47189692D0
	rhoarr( 74)=        7.07758743D0
	rhoarr( 75)=        6.75115828D0
	rhoarr( 76)=        6.47259897D0
	rhoarr( 77)=        6.22545613D0
	rhoarr( 78)=        5.99660049D0
	rhoarr( 79)=        5.77593651D0
	rhoarr( 80)=        5.55607516D0
	rhoarr( 81)=        5.33198716D0
	rhoarr( 82)=        5.10065044D0
	rhoarr( 83)=        4.86070316D0
	rhoarr( 84)=        4.61211127D0
	rhoarr( 85)=        4.35585837D0
	rhoarr( 86)=        4.09366364D0
	rhoarr( 87)=        3.82773250D0
	rhoarr( 88)=        3.56054268D0
	rhoarr( 89)=        3.29466638D0
	rhoarr( 90)=        3.03262787D0
	rhoarr( 91)=        2.77679403D0
	rhoarr( 92)=        2.52929494D0
	rhoarr( 93)=        2.29197047D0
	rhoarr( 94)=        2.06633936D0
	rhoarr( 95)=        1.85358678D0
	rhoarr( 96)=        1.65456696D0
	rhoarr( 97)=        1.46981763D0
	rhoarr( 98)=        1.29958327D0
	rhoarr( 99)=        1.14384465D0
	rhoarr(100)=        1.00235235D0
	rhoarr(101)=        0.87466244D0
	rhoarr(102)=        0.76017266D0
	rhoarr(103)=        0.65815805D0
	rhoarr(104)=        0.56780481D0
	rhoarr(105)=        0.48824168D0
	rhoarr(106)=        0.41856805D0
	rhoarr(107)=        0.35787836D0
	rhoarr(108)=        0.30528233D0
	rhoarr(109)=        0.25992101D0
	rhoarr(110)=        0.22097870D0
	rhoarr(111)=        0.18769119D0
	rhoarr(112)=        0.15935087D0
	rhoarr(113)=        0.13530937D0
	rhoarr(114)=        0.11497832D0
	rhoarr(115)=        0.09782886D0
	rhoarr(116)=        0.08339010D0
	rhoarr(117)=        0.07124689D0
	rhoarr(118)=        0.06103691D0
	rhoarr(119)=        0.05244710D0
	rhoarr(120)=        0.04520964D0
	rhoarr(121)=        0.03909745D0
	rhoarr(122)=        0.03391944D0
	rhoarr(123)=        0.02951587D0
	rhoarr(124)=        0.02575381D0
	rhoarr(125)=        0.02252315D0
	rhoarr(126)=        0.01973306D0
	rhoarr(127)=        0.01730894D0
	rhoarr(128)=        0.01518995D0
	rhoarr(129)=        0.01332678D0
	rhoarr(130)=        0.01167981D0
	rhoarr(131)=        0.01021745D0
	rhoarr(132)=        0.00891458D0
	rhoarr(133)=        0.00775128D0
	rhoarr(134)=        0.00671162D0
	rhoarr(135)=        0.00578276D0
	rhoarr(136)=        0.00495415D0
	rhoarr(137)=        0.00421697D0
	rhoarr(138)=        0.00356365D0
	rhoarr(139)=        0.00298755D0
	rhoarr(140)=        0.00248266D0
	rhoarr(141)=        0.00204341D0
	rhoarr(142)=        0.00166448D0
	rhoarr(143)=        0.00134066D0
	rhoarr(144)=        0.00106686D0
	rhoarr(145)=        0.00083799D0
	rhoarr(146)=        0.00064906D0
	rhoarr(147)=        0.00049518D0
	rhoarr(148)=        0.00037167D0
	rhoarr(149)=        0.00027407D0
	rhoarr(150)=        0.00019822D0
	rhoarr(151)=        0.00014037D0
	rhoarr(152)=        0.00009710D0
	rhoarr(153)=        0.00006545D0
	rhoarr(154)=        0.00004285D0
	rhoarr(155)=        0.00002716D0
	rhoarr(156)=        0.00001659D0
	rhoarr(157)=        0.00000972D0
	rhoarr(158)=        0.00000543D0
	rhoarr(159)=        0.00000287D0
	rhoarr(160)=        0.00000143D0
	rhoarr(161)=        0.00000066D0
	rhoarr(162)=        0.00000028D0
	rhoarr(163)=        0.00000011D0
	rhoarr(164)=        0.00000004D0
	rhoarr(165)=        0.00000001D0

else if (iele==29) then  !Cu, 3d10 4s1, 0 2, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=    38087.11358712D0
	rhoarr(  2)=    33723.13932348D0
	rhoarr(  3)=    28403.90153650D0
	rhoarr(  4)=    25070.02507448D0
	rhoarr(  5)=    22502.11424885D0
	rhoarr(  6)=    20351.23496118D0
	rhoarr(  7)=    18505.81749862D0
	rhoarr(  8)=    16846.16248308D0
	rhoarr(  9)=    15330.39852443D0
	rhoarr( 10)=    13925.35285896D0
	rhoarr( 11)=    12610.61120519D0
	rhoarr( 12)=    11377.20748808D0
	rhoarr( 13)=    10219.55995704D0
	rhoarr( 14)=     9134.55107477D0
	rhoarr( 15)=     8121.32631751D0
	rhoarr( 16)=     7180.07576156D0
	rhoarr( 17)=     6311.07271719D0
	rhoarr( 18)=     5514.24608095D0
	rhoarr( 19)=     4788.99301843D0
	rhoarr( 20)=     4134.09827662D0
	rhoarr( 21)=     3547.65864869D0
	rhoarr( 22)=     3027.05657907D0
	rhoarr( 23)=     2569.01558182D0
	rhoarr( 24)=     2169.69481745D0
	rhoarr( 25)=     1824.80506118D0
	rhoarr( 26)=     1529.74600680D0
	rhoarr( 27)=     1279.74551551D0
	rhoarr( 28)=     1069.98340033D0
	rhoarr( 29)=      895.70034067D0
	rhoarr( 30)=      752.29547355D0
	rhoarr( 31)=      635.40880692D0
	rhoarr( 32)=      540.98363710D0
	rhoarr( 33)=      465.30946027D0
	rhoarr( 34)=      405.04890345D0
	rhoarr( 35)=      357.25098023D0
	rhoarr( 36)=      319.35134630D0
	rhoarr( 37)=      289.16062360D0
	rhoarr( 38)=      264.84325657D0
	rhoarr( 39)=      244.88998770D0
	rhoarr( 40)=      228.08653550D0
	rhoarr( 41)=      213.48020138D0
	rhoarr( 42)=      200.34561848D0
	rhoarr( 43)=      188.15074735D0
	rhoarr( 44)=      176.52421386D0
	rhoarr( 45)=      165.22493190D0
	rhoarr( 46)=      154.11464553D0
	rhoarr( 47)=      143.13368769D0
	rhoarr( 48)=      132.27999623D0
	rhoarr( 49)=      121.59128488D0
	rhoarr( 50)=      111.13020487D0
	rhoarr( 51)=      100.97230664D0
	rhoarr( 52)=       91.19658615D0
	rhoarr( 53)=       81.87836815D0
	rhoarr( 54)=       73.08424419D0
	rhoarr( 55)=       64.86875852D0
	rhoarr( 56)=       57.27253058D0
	rhoarr( 57)=       50.32152026D0
	rhoarr( 58)=       44.02717824D0
	rhoarr( 59)=       38.38726586D0
	rhoarr( 60)=       33.38716811D0
	rhoarr( 61)=       29.00155140D0
	rhoarr( 62)=       25.19623560D0
	rhoarr( 63)=       21.93016164D0
	rhoarr( 64)=       19.15734829D0
	rhoarr( 65)=       16.82874923D0
	rhoarr( 66)=       14.89394427D0
	rhoarr( 67)=       13.30262298D0
	rhoarr( 68)=       12.00584155D0
	rhoarr( 69)=       10.95705017D0
	rhoarr( 70)=       10.11289799D0
	rhoarr( 71)=        9.43382719D0
	rhoarr( 72)=        8.88446927D0
	rhoarr( 73)=        8.43385853D0
	rhoarr( 74)=        8.05548022D0
	rhoarr( 75)=        7.72717481D0
	rhoarr( 76)=        7.43092351D0
	rhoarr( 77)=        7.15254254D0
	rhoarr( 78)=        6.88131364D0
	rhoarr( 79)=        6.60957638D0
	rhoarr( 80)=        6.33230388D0
	rhoarr( 81)=        6.04667937D0
	rhoarr( 82)=        5.75168689D0
	rhoarr( 83)=        5.44772584D0
	rhoarr( 84)=        5.13625691D0
	rhoarr( 85)=        4.81948453D0
	rhoarr( 86)=        4.50007955D0
	rhoarr( 87)=        4.18094408D0
	rhoarr( 88)=        3.86501868D0
	rhoarr( 89)=        3.55513046D0
	rhoarr( 90)=        3.25387939D0
	rhoarr( 91)=        2.96355879D0
	rhoarr( 92)=        2.68610573D0
	rhoarr( 93)=        2.42307637D0
	rhoarr( 94)=        2.17564185D0
	rhoarr( 95)=        1.94460006D0
	rhoarr( 96)=        1.73039947D0
	rhoarr( 97)=        1.53317122D0
	rhoarr( 98)=        1.35276651D0
	rhoarr( 99)=        1.18879660D0
	rhoarr(100)=        1.04067364D0
	rhoarr(101)=        0.90765058D0
	rhoarr(102)=        0.78885942D0
	rhoarr(103)=        0.68334689D0
	rhoarr(104)=        0.59010720D0
	rhoarr(105)=        0.50811133D0
	rhoarr(106)=        0.43633256D0
	rhoarr(107)=        0.37376775D0
	rhoarr(108)=        0.31945435D0
	rhoarr(109)=        0.27248297D0
	rhoarr(110)=        0.23200566D0
	rhoarr(111)=        0.19724066D0
	rhoarr(112)=        0.16747402D0
	rhoarr(113)=        0.14205901D0
	rhoarr(114)=        0.12041405D0
	rhoarr(115)=        0.10201979D0
	rhoarr(116)=        0.08641573D0
	rhoarr(117)=        0.07319661D0
	rhoarr(118)=        0.06200853D0
	rhoarr(119)=        0.05254494D0
	rhoarr(120)=        0.04454228D0
	rhoarr(121)=        0.03777543D0
	rhoarr(122)=        0.03205304D0
	rhoarr(123)=        0.02721292D0
	rhoarr(124)=        0.02311773D0
	rhoarr(125)=        0.01965117D0
	rhoarr(126)=        0.01671469D0
	rhoarr(127)=        0.01422476D0
	rhoarr(128)=        0.01211075D0
	rhoarr(129)=        0.01031310D0
	rhoarr(130)=        0.00878183D0
	rhoarr(131)=        0.00747514D0
	rhoarr(132)=        0.00635820D0
	rhoarr(133)=        0.00540201D0
	rhoarr(134)=        0.00458236D0
	rhoarr(135)=        0.00387901D0
	rhoarr(136)=        0.00327498D0
	rhoarr(137)=        0.00275598D0
	rhoarr(138)=        0.00231004D0
	rhoarr(139)=        0.00192709D0
	rhoarr(140)=        0.00159872D0
	rhoarr(141)=        0.00131785D0
	rhoarr(142)=        0.00107848D0
	rhoarr(143)=        0.00087546D0
	rhoarr(144)=        0.00070428D0
	rhoarr(145)=        0.00056096D0
	rhoarr(146)=        0.00044192D0
	rhoarr(147)=        0.00034392D0
	rhoarr(148)=        0.00026406D0
	rhoarr(149)=        0.00019971D0
	rhoarr(150)=        0.00014851D0
	rhoarr(151)=        0.00010835D0
	rhoarr(152)=        0.00007737D0
	rhoarr(153)=        0.00005392D0
	rhoarr(154)=        0.00003654D0
	rhoarr(155)=        0.00002398D0
	rhoarr(156)=        0.00001516D0
	rhoarr(157)=        0.00000919D0
	rhoarr(158)=        0.00000530D0
	rhoarr(159)=        0.00000289D0
	rhoarr(160)=        0.00000147D0
	rhoarr(161)=        0.00000069D0
	rhoarr(162)=        0.00000030D0
	rhoarr(163)=        0.00000011D0
	rhoarr(164)=        0.00000004D0
	rhoarr(165)=        0.00000001D0

else if (iele==30) then  !Zn, 3d10 4s2, 0 1, HF/UGBS int=dkh2
	npt=  164
	rhoarr(  1)=    43595.33385152D0
	rhoarr(  2)=    38445.69927225D0
	rhoarr(  3)=    32187.48737399D0
	rhoarr(  4)=    28281.48426090D0
	rhoarr(  5)=    25284.10726411D0
	rhoarr(  6)=    22782.04962295D0
	rhoarr(  7)=    20642.82702509D0
	rhoarr(  8)=    18725.45389796D0
	rhoarr(  9)=    16980.63599805D0
	rhoarr( 10)=    15369.33071075D0
	rhoarr( 11)=    13867.32323321D0
	rhoarr( 12)=    12463.69252263D0
	rhoarr( 13)=    11151.57357711D0
	rhoarr( 14)=     9927.03341600D0
	rhoarr( 15)=     8788.64459261D0
	rhoarr( 16)=     7736.03865489D0
	rhoarr( 17)=     6768.89790928D0
	rhoarr( 18)=     5886.53642357D0
	rhoarr( 19)=     5087.68096102D0
	rhoarr( 20)=     4370.35077190D0
	rhoarr( 21)=     3731.76839606D0
	rhoarr( 22)=     3168.35436966D0
	rhoarr( 23)=     2675.82238371D0
	rhoarr( 24)=     2249.31017962D0
	rhoarr( 25)=     1883.52202040D0
	rhoarr( 26)=     1572.88633752D0
	rhoarr( 27)=     1311.71190542D0
	rhoarr( 28)=     1094.32607152D0
	rhoarr( 29)=      915.19609126D0
	rhoarr( 30)=      769.03653200D0
	rhoarr( 31)=      650.89752975D0
	rhoarr( 32)=      556.22831711D0
	rhoarr( 33)=      480.91695659D0
	rhoarr( 34)=      421.31091754D0
	rhoarr( 35)=      374.22190437D0
	rhoarr( 36)=      336.91648218D0
	rhoarr( 37)=      307.09427164D0
	rhoarr( 38)=      282.85675342D0
	rhoarr( 39)=      262.67019404D0
	rhoarr( 40)=      245.32553556D0
	rhoarr( 41)=      229.89710911D0
	rhoarr( 42)=      215.70144806D0
	rhoarr( 43)=      202.25733552D0
	rhoarr( 44)=      189.24818916D0
	rhoarr( 45)=      176.48770864D0
	rhoarr( 46)=      163.88937499D0
	rhoarr( 47)=      151.44002477D0
	rhoarr( 48)=      139.17744174D0
	rhoarr( 49)=      127.17174947D0
	rhoarr( 50)=      115.51032225D0
	rhoarr( 51)=      104.28591011D0
	rhoarr( 52)=       93.58766056D0
	rhoarr( 53)=       83.49470052D0
	rhoarr( 54)=       74.07191898D0
	rhoarr( 55)=       65.36757712D0
	rhoarr( 56)=       57.41237769D0
	rhoarr( 57)=       50.21965503D0
	rhoarr( 58)=       43.78639416D0
	rhoarr( 59)=       38.09484147D0
	rhoarr( 60)=       33.11451712D0
	rhoarr( 61)=       28.80447386D0
	rhoarr( 62)=       25.11566797D0
	rhoarr( 63)=       21.99332276D0
	rhoarr( 64)=       19.37917959D0
	rhoarr( 65)=       17.21355161D0
	rhoarr( 66)=       15.43712103D0
	rhoarr( 67)=       13.99244838D0
	rhoarr( 68)=       12.82518643D0
	rhoarr( 69)=       11.88500883D0
	rhoarr( 70)=       11.12627350D0
	rhoarr( 71)=       10.50844438D0
	rhoarr( 72)=        9.99629618D0
	rhoarr( 73)=        9.55992694D0
	rhoarr( 74)=        9.17460531D0
	rhoarr( 75)=        8.82048160D0
	rhoarr( 76)=        8.48219412D0
	rhoarr( 77)=        8.14840286D0
	rhoarr( 78)=        7.81128127D0
	rhoarr( 79)=        7.46599306D0
	rhoarr( 80)=        7.11017600D0
	rhoarr( 81)=        6.74344919D0
	rhoarr( 82)=        6.36695582D0
	rhoarr( 83)=        5.98294889D0
	rhoarr( 84)=        5.59442509D0
	rhoarr( 85)=        5.20480928D0
	rhoarr( 86)=        4.81769049D0
	rhoarr( 87)=        4.43660857D0
	rhoarr( 88)=        4.06488916D0
	rhoarr( 89)=        3.70552326D0
	rhoarr( 90)=        3.36108672D0
	rhoarr( 91)=        3.03369416D0
	rhoarr( 92)=        2.72498181D0
	rhoarr( 93)=        2.43611355D0
	rhoarr( 94)=        2.16780494D0
	rhoarr( 95)=        1.92036005D0
	rhoarr( 96)=        1.69371697D0
	rhoarr( 97)=        1.48749792D0
	rhoarr( 98)=        1.30106087D0
	rhoarr( 99)=        1.13355038D0
	rhoarr(100)=        0.98394575D0
	rhoarr(101)=        0.85110568D0
	rhoarr(102)=        0.73380884D0
	rhoarr(103)=        0.63079019D0
	rhoarr(104)=        0.54077300D0
	rhoarr(105)=        0.46249651D0
	rhoarr(106)=        0.39473918D0
	rhoarr(107)=        0.33633724D0
	rhoarr(108)=        0.28619857D0
	rhoarr(109)=        0.24331197D0
	rhoarr(110)=        0.20675208D0
	rhoarr(111)=        0.17568071D0
	rhoarr(112)=        0.14934518D0
	rhoarr(113)=        0.12707472D0
	rhoarr(114)=        0.10827563D0
	rhoarr(115)=        0.09242595D0
	rhoarr(116)=        0.07906994D0
	rhoarr(117)=        0.06781268D0
	rhoarr(118)=        0.05831472D0
	rhoarr(119)=        0.05028677D0
	rhoarr(120)=        0.04348433D0
	rhoarr(121)=        0.03770234D0
	rhoarr(122)=        0.03276985D0
	rhoarr(123)=        0.02854501D0
	rhoarr(124)=        0.02491042D0
	rhoarr(125)=        0.02176906D0
	rhoarr(126)=        0.01904086D0
	rhoarr(127)=        0.01665987D0
	rhoarr(128)=        0.01457193D0
	rhoarr(129)=        0.01273283D0
	rhoarr(130)=        0.01110664D0
	rhoarr(131)=        0.00966431D0
	rhoarr(132)=        0.00838241D0
	rhoarr(133)=        0.00724200D0
	rhoarr(134)=        0.00622763D0
	rhoarr(135)=        0.00532653D0
	rhoarr(136)=        0.00452798D0
	rhoarr(137)=        0.00382275D0
	rhoarr(138)=        0.00320276D0
	rhoarr(139)=        0.00266080D0
	rhoarr(140)=        0.00219021D0
	rhoarr(141)=        0.00178480D0
	rhoarr(142)=        0.00143867D0
	rhoarr(143)=        0.00114609D0
	rhoarr(144)=        0.00090151D0
	rhoarr(145)=        0.00069952D0
	rhoarr(146)=        0.00053488D0
	rhoarr(147)=        0.00040258D0
	rhoarr(148)=        0.00029788D0
	rhoarr(149)=        0.00021638D0
	rhoarr(150)=        0.00015405D0
	rhoarr(151)=        0.00010731D0
	rhoarr(152)=        0.00007297D0
	rhoarr(153)=        0.00004832D0
	rhoarr(154)=        0.00003106D0
	rhoarr(155)=        0.00001933D0
	rhoarr(156)=        0.00001159D0
	rhoarr(157)=        0.00000666D0
	rhoarr(158)=        0.00000366D0
	rhoarr(159)=        0.00000190D0
	rhoarr(160)=        0.00000093D0
	rhoarr(161)=        0.00000042D0
	rhoarr(162)=        0.00000018D0
	rhoarr(163)=        0.00000007D0
	rhoarr(164)=        0.00000002D0
	
else if (iele==31) then  !Ga, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=  167
	rhoarr(  1)=    49487.73160530D0
	rhoarr(  2)=    43914.02354880D0
	rhoarr(  3)=    36224.85308095D0
	rhoarr(  4)=    31872.48381497D0
	rhoarr(  5)=    28240.87442314D0
	rhoarr(  6)=    25428.31792667D0
	rhoarr(  7)=    22924.39893975D0
	rhoarr(  8)=    20721.29974242D0
	rhoarr(  9)=    18737.82499180D0
	rhoarr( 10)=    16890.66309746D0
	rhoarr( 11)=    15180.61542638D0
	rhoarr( 12)=    13597.24899707D0
	rhoarr( 13)=    12119.07702307D0
	rhoarr( 14)=    10741.56962413D0
	rhoarr( 15)=     9468.66730812D0
	rhoarr( 16)=     8299.54790610D0
	rhoarr( 17)=     7230.09881612D0
	rhoarr( 18)=     6257.89810340D0
	rhoarr( 19)=     5382.09856137D0
	rhoarr( 20)=     4600.77085388D0
	rhoarr( 21)=     3909.83336695D0
	rhoarr( 22)=     3303.88320975D0
	rhoarr( 23)=     2777.20292307D0
	rhoarr( 24)=     2323.99601116D0
	rhoarr( 25)=     1938.14395937D0
	rhoarr( 26)=     1613.07673989D0
	rhoarr( 27)=     1341.96337022D0
	rhoarr( 28)=     1118.05364073D0
	rhoarr( 29)=      934.94416095D0
	rhoarr( 30)=      786.68884247D0
	rhoarr( 31)=      667.81004320D0
	rhoarr( 32)=      573.29617234D0
	rhoarr( 33)=      498.62632157D0
	rhoarr( 34)=      439.81081491D0
	rhoarr( 35)=      393.41718382D0
	rhoarr( 36)=      356.56234764D0
	rhoarr( 37)=      326.87276488D0
	rhoarr( 38)=      302.42746357D0
	rhoarr( 39)=      281.69935736D0
	rhoarr( 40)=      263.50300581D0
	rhoarr( 41)=      246.94922551D0
	rhoarr( 42)=      231.40308672D0
	rhoarr( 43)=      216.44220108D0
	rhoarr( 44)=      201.81473184D0
	rhoarr( 45)=      187.39887985D0
	rhoarr( 46)=      173.16644350D0
	rhoarr( 47)=      159.15241717D0
	rhoarr( 48)=      145.43122663D0
	rhoarr( 49)=      132.09892608D0
	rhoarr( 50)=      119.26000137D0
	rhoarr( 51)=      107.01740625D0
	rhoarr( 52)=       95.46487624D0
	rhoarr( 53)=       84.68108716D0
	rhoarr( 54)=       74.72559808D0
	rhoarr( 55)=       65.63663698D0
	rhoarr( 56)=       57.43069118D0
	rhoarr( 57)=       50.10366860D0
	rhoarr( 58)=       43.63322208D0
	rhoarr( 59)=       37.98175117D0
	rhoarr( 60)=       33.09963213D0
	rhoarr( 61)=       28.92834512D0
	rhoarr( 62)=       25.40331494D0
	rhoarr( 63)=       22.45641043D0
	rhoarr( 64)=       20.01812596D0
	rhoarr( 65)=       18.01949331D0
	rhoarr( 66)=       16.39375648D0
	rhoarr( 67)=       15.07780981D0
	rhoarr( 68)=       14.01337306D0
	rhoarr( 69)=       13.14786827D0
	rhoarr( 70)=       12.43497551D0
	rhoarr( 71)=       11.83487005D0
	rhoarr( 72)=       11.31417304D0
	rhoarr( 73)=       10.84567003D0
	rhoarr( 74)=       10.40786293D0
	rhoarr( 75)=        9.98441872D0
	rhoarr( 76)=        9.56356693D0
	rhoarr( 77)=        9.13748275D0
	rhoarr( 78)=        8.70167752D0
	rhoarr( 79)=        8.25440836D0
	rhoarr( 80)=        7.79611367D0
	rhoarr( 81)=        7.32888049D0
	rhoarr( 82)=        6.85595190D0
	rhoarr( 83)=        6.38128431D0
	rhoarr( 84)=        5.90916485D0
	rhoarr( 85)=        5.44389707D0
	rhoarr( 86)=        4.98955876D0
	rhoarr( 87)=        4.54983069D0
	rhoarr( 88)=        4.12788970D0
	rhoarr( 89)=        3.72635551D0
	rhoarr( 90)=        3.34727873D0
	rhoarr( 91)=        2.99215687D0
	rhoarr( 92)=        2.66196737D0
	rhoarr( 93)=        2.35720888D0
	rhoarr( 94)=        2.07794566D0
	rhoarr( 95)=        1.82385272D0
	rhoarr( 96)=        1.59426166D0
	rhoarr( 97)=        1.38820812D0
	rhoarr( 98)=        1.20448203D0
	rhoarr( 99)=        1.04168099D0
	rhoarr(100)=        0.89826579D0
	rhoarr(101)=        0.77261628D0
	rhoarr(102)=        0.66308471D0
	rhoarr(103)=        0.56804342D0
	rhoarr(104)=        0.48592448D0
	rhoarr(105)=        0.41524924D0
	rhoarr(106)=        0.35464738D0
	rhoarr(107)=        0.30286607D0
	rhoarr(108)=        0.25877095D0
	rhoarr(109)=        0.22134121D0
	rhoarr(110)=        0.18966155D0
	rhoarr(111)=        0.16291317D0
	rhoarr(112)=        0.14036549D0
	rhoarr(113)=        0.12136954D0
	rhoarr(114)=        0.10535303D0
	rhoarr(115)=        0.09181660D0
	rhoarr(116)=        0.08033048D0
	rhoarr(117)=        0.07053080D0
	rhoarr(118)=        0.06211487D0
	rhoarr(119)=        0.05483541D0
	rhoarr(120)=        0.04849363D0
	rhoarr(121)=        0.04293173D0
	rhoarr(122)=        0.03802521D0
	rhoarr(123)=        0.03367568D0
	rhoarr(124)=        0.02980463D0
	rhoarr(125)=        0.02634842D0
	rhoarr(126)=        0.02325459D0
	rhoarr(127)=        0.02047934D0
	rhoarr(128)=        0.01798595D0
	rhoarr(129)=        0.01574372D0
	rhoarr(130)=        0.01372709D0
	rhoarr(131)=        0.01191499D0
	rhoarr(132)=        0.01028996D0
	rhoarr(133)=        0.00883741D0
	rhoarr(134)=        0.00754475D0
	rhoarr(135)=        0.00640065D0
	rhoarr(136)=        0.00539446D0
	rhoarr(137)=        0.00451569D0
	rhoarr(138)=        0.00375383D0
	rhoarr(139)=        0.00309823D0
	rhoarr(140)=        0.00253824D0
	rhoarr(141)=        0.00206340D0
	rhoarr(142)=        0.00166368D0
	rhoarr(143)=        0.00132969D0
	rhoarr(144)=        0.00105278D0
	rhoarr(145)=        0.00082514D0
	rhoarr(146)=        0.00063974D0
	rhoarr(147)=        0.00049031D0
	rhoarr(148)=        0.00037125D0
	rhoarr(149)=        0.00027759D0
	rhoarr(150)=        0.00020490D0
	rhoarr(151)=        0.00014929D0
	rhoarr(152)=        0.00010735D0
	rhoarr(153)=        0.00007617D0
	rhoarr(154)=        0.00005328D0
	rhoarr(155)=        0.00003669D0
	rhoarr(156)=        0.00002481D0
	rhoarr(157)=        0.00001640D0
	rhoarr(158)=        0.00001053D0
	rhoarr(159)=        0.00000652D0
	rhoarr(160)=        0.00000385D0
	rhoarr(161)=        0.00000216D0
	rhoarr(162)=        0.00000113D0
	rhoarr(163)=        0.00000056D0
	rhoarr(164)=        0.00000025D0
	rhoarr(165)=        0.00000011D0
	rhoarr(166)=        0.00000004D0
	rhoarr(167)=        0.00000002D0
	
else if (iele==32) then  !Ge, 0 3, b3lyp/ANO-RCC int=dkh2
	npt=  165
	rhoarr(  1)=    56996.32847990D0
	rhoarr(  2)=    49743.08580487D0
	rhoarr(  3)=    40828.36087952D0
	rhoarr(  4)=    35693.49170797D0
	rhoarr(  5)=    31533.90519312D0
	rhoarr(  6)=    28277.93251587D0
	rhoarr(  7)=    25392.05193702D0
	rhoarr(  8)=    22885.40513642D0
	rhoarr(  9)=    20613.43836888D0
	rhoarr( 10)=    18511.53177971D0
	rhoarr( 11)=    16581.30468300D0
	rhoarr( 12)=    14795.03092360D0
	rhoarr( 13)=    13131.54489040D0
	rhoarr( 14)=    11591.55818202D0
	rhoarr( 15)=    10176.45997313D0
	rhoarr( 16)=     8881.08290359D0
	rhoarr( 17)=     7700.66784986D0
	rhoarr( 18)=     6633.66966074D0
	rhoarr( 19)=     5678.58115302D0
	rhoarr( 20)=     4831.40075288D0
	rhoarr( 21)=     4086.13230096D0
	rhoarr( 22)=     3436.22647653D0
	rhoarr( 23)=     2875.09769758D0
	rhoarr( 24)=     2395.80989919D0
	rhoarr( 25)=     1990.80248960D0
	rhoarr( 26)=     1652.06807187D0
	rhoarr( 27)=     1371.58918565D0
	rhoarr( 28)=     1141.69841650D0
	rhoarr( 29)=      955.22879032D0
	rhoarr( 30)=      805.52869860D0
	rhoarr( 31)=      686.46356622D0
	rhoarr( 32)=      592.45977764D0
	rhoarr( 33)=      518.57120200D0
	rhoarr( 34)=      460.52333668D0
	rhoarr( 35)=      414.70938834D0
	rhoarr( 36)=      378.14337847D0
	rhoarr( 37)=      348.39232622D0
	rhoarr( 38)=      323.50791374D0
	rhoarr( 39)=      301.96668328D0
	rhoarr( 40)=      282.61747337D0
	rhoarr( 41)=      264.63082862D0
	rhoarr( 42)=      247.44686643D0
	rhoarr( 43)=      230.72198285D0
	rhoarr( 44)=      214.27760861D0
	rhoarr( 45)=      198.05470463D0
	rhoarr( 46)=      182.07629614D0
	rhoarr( 47)=      166.41833543D0
	rhoarr( 48)=      151.18764409D0
	rhoarr( 49)=      136.50509867D0
	rhoarr( 50)=      122.49248097D0
	rhoarr( 51)=      109.26208368D0
	rhoarr( 52)=       96.90879611D0
	rhoarr( 53)=       85.50472618D0
	rhoarr( 54)=       75.09640521D0
	rhoarr( 55)=       65.70439507D0
	rhoarr( 56)=       57.32484872D0
	rhoarr( 57)=       49.93240315D0
	rhoarr( 58)=       43.48376548D0
	rhoarr( 59)=       37.92146936D0
	rhoarr( 60)=       33.17746623D0
	rhoarr( 61)=       29.17640040D0
	rhoarr( 62)=       25.83854738D0
	rhoarr( 63)=       23.08245227D0
	rhoarr( 64)=       20.82730055D0
	rhoarr( 65)=       18.99501788D0
	rhoarr( 66)=       17.51205851D0
	rhoarr( 67)=       16.31082618D0
	rhoarr( 68)=       15.33068363D0
	rhoarr( 69)=       14.51853892D0
	rhoarr( 70)=       13.82903767D0
	rhoarr( 71)=       13.22442347D0
	rhoarr( 72)=       12.67414736D0
	rhoarr( 73)=       12.15430828D0
	rhoarr( 74)=       11.64699417D0
	rhoarr( 75)=       11.13957388D0
	rhoarr( 76)=       10.62397188D0
	rhoarr( 77)=       10.09594401D0
	rhoarr( 78)=        9.55436634D0
	rhoarr( 79)=        9.00054858D0
	rhoarr( 80)=        8.43758629D0
	rhoarr( 81)=        7.86976864D0
	rhoarr( 82)=        7.30205808D0
	rhoarr( 83)=        6.73965558D0
	rhoarr( 84)=        6.18765792D0
	rhoarr( 85)=        5.65080663D0
	rhoarr( 86)=        5.13332027D0
	rhoarr( 87)=        4.63879650D0
	rhoarr( 88)=        4.17016775D0
	rhoarr( 89)=        3.72969441D0
	rhoarr( 90)=        3.31898195D0
	rhoarr( 91)=        2.93901237D0
	rhoarr( 92)=        2.59018432D0
	rhoarr( 93)=        2.27235996D0
	rhoarr( 94)=        1.98491856D0
	rhoarr( 95)=        1.72681756D0
	rhoarr( 96)=        1.49666121D0
	rhoarr( 97)=        1.29277568D0
	rhoarr( 98)=        1.11328751D0
	rhoarr( 99)=        0.95620174D0
	rhoarr(100)=        0.81947477D0
	rhoarr(101)=        0.70107805D0
	rhoarr(102)=        0.59904930D0
	rhoarr(103)=        0.51152963D0
	rhoarr(104)=        0.43678682D0
	rhoarr(105)=        0.37322648D0
	rhoarr(106)=        0.31939378D0
	rhoarr(107)=        0.27396920D0
	rhoarr(108)=        0.23576144D0
	rhoarr(109)=        0.20369984D0
	rhoarr(110)=        0.17682789D0
	rhoarr(111)=        0.15429810D0
	rhoarr(112)=        0.13536792D0
	rhoarr(113)=        0.11939583D0
	rhoarr(114)=        0.10583656D0
	rhoarr(115)=        0.09423490D0
	rhoarr(116)=        0.08421778D0
	rhoarr(117)=        0.07548473D0
	rhoarr(118)=        0.06779738D0
	rhoarr(119)=        0.06096877D0
	rhoarr(120)=        0.05485310D0
	rhoarr(121)=        0.04933675D0
	rhoarr(122)=        0.04433090D0
	rhoarr(123)=        0.03976582D0
	rhoarr(124)=        0.03558671D0
	rhoarr(125)=        0.03175070D0
	rhoarr(126)=        0.02822462D0
	rhoarr(127)=        0.02498319D0
	rhoarr(128)=        0.02200731D0
	rhoarr(129)=        0.01928255D0
	rhoarr(130)=        0.01679754D0
	rhoarr(131)=        0.01454270D0
	rhoarr(132)=        0.01250899D0
	rhoarr(133)=        0.01068705D0
	rhoarr(134)=        0.00906664D0
	rhoarr(135)=        0.00763630D0
	rhoarr(136)=        0.00638342D0
	rhoarr(137)=        0.00529443D0
	rhoarr(138)=        0.00435518D0
	rhoarr(139)=        0.00355138D0
	rhoarr(140)=        0.00286898D0
	rhoarr(141)=        0.00229451D0
	rhoarr(142)=        0.00181526D0
	rhoarr(143)=        0.00141943D0
	rhoarr(144)=        0.00109611D0
	rhoarr(145)=        0.00083528D0
	rhoarr(146)=        0.00062772D0
	rhoarr(147)=        0.00046502D0
	rhoarr(148)=        0.00033950D0
	rhoarr(149)=        0.00024426D0
	rhoarr(150)=        0.00017319D0
	rhoarr(151)=        0.00012099D0
	rhoarr(152)=        0.00008323D0
	rhoarr(153)=        0.00005628D0
	rhoarr(154)=        0.00003730D0
	rhoarr(155)=        0.00002412D0
	rhoarr(156)=        0.00001512D0
	rhoarr(157)=        0.00000911D0
	rhoarr(158)=        0.00000524D0
	rhoarr(159)=        0.00000284D0
	rhoarr(160)=        0.00000144D0
	rhoarr(161)=        0.00000068D0
	rhoarr(162)=        0.00000030D0
	rhoarr(163)=        0.00000012D0
	rhoarr(164)=        0.00000005D0
	rhoarr(165)=        0.00000002D0
	
else if (iele==33) then  !As, 0 4, b3lyp/ANO-RCC int=dkh2
	npt=  163
	rhoarr(  1)=    65410.32546681D0
	rhoarr(  2)=    56156.85724571D0
	rhoarr(  3)=    45908.88455192D0
	rhoarr(  4)=    39861.86289508D0
	rhoarr(  5)=    35123.41359006D0
	rhoarr(  6)=    31353.57843191D0
	rhoarr(  7)=    28055.26130807D0
	rhoarr(  8)=    25205.00310809D0
	rhoarr(  9)=    22611.71260182D0
	rhoarr( 10)=    20234.39300200D0
	rhoarr( 11)=    18061.49719355D0
	rhoarr( 12)=    16051.53091948D0
	rhoarr( 13)=    14188.44639930D0
	rhoarr( 14)=    12474.78131753D0
	rhoarr( 15)=    10906.63918287D0
	rhoarr( 16)=     9475.85458251D0
	rhoarr( 17)=     8178.31205357D0
	rhoarr( 18)=     7012.56845650D0
	rhoarr( 19)=     5975.18106564D0
	rhoarr( 20)=     5059.76097748D0
	rhoarr( 21)=     4258.74224651D0
	rhoarr( 22)=     3564.55173013D0
	rhoarr( 23)=     2969.38810085D0
	rhoarr( 24)=     2464.70448783D0
	rhoarr( 25)=     2041.24698873D0
	rhoarr( 26)=     1689.56352837D0
	rhoarr( 27)=     1400.50641514D0
	rhoarr( 28)=     1165.46816298D0
	rhoarr( 29)=      976.41281444D0
	rhoarr( 30)=      825.87439826D0
	rhoarr( 31)=      707.01423038D0
	rhoarr( 32)=      613.71727638D0
	rhoarr( 33)=      540.66423232D0
	rhoarr( 34)=      483.34026457D0
	rhoarr( 35)=      437.98528060D0
	rhoarr( 36)=      401.51543068D0
	rhoarr( 37)=      371.44342427D0
	rhoarr( 38)=      345.80930287D0
	rhoarr( 39)=      323.11922146D0
	rhoarr( 40)=      302.28495099D0
	rhoarr( 41)=      282.55980309D0
	rhoarr( 42)=      263.47216435D0
	rhoarr( 43)=      244.76140631D0
	rhoarr( 44)=      226.32115876D0
	rhoarr( 45)=      208.15276687D0
	rhoarr( 46)=      190.32902473D0
	rhoarr( 47)=      172.96640004D0
	rhoarr( 48)=      156.20342836D0
	rhoarr( 49)=      140.18346433D0
	rhoarr( 50)=      125.04088775D0
	rhoarr( 51)=      110.89060190D0
	rhoarr( 52)=       97.82095245D0
	rhoarr( 53)=       85.89006713D0
	rhoarr( 54)=       75.12527300D0
	rhoarr( 55)=       65.52491965D0
	rhoarr( 56)=       57.06177479D0
	rhoarr( 57)=       49.68719890D0
	rhoarr( 58)=       43.33549774D0
	rhoarr( 59)=       37.92809854D0
	rhoarr( 60)=       33.37741020D0
	rhoarr( 61)=       29.59035742D0
	rhoarr( 62)=       26.47161724D0
	rhoarr( 63)=       23.92656100D0
	rhoarr( 64)=       21.86385776D0
	rhoarr( 65)=       20.19766280D0
	rhoarr( 66)=       18.84931500D0
	rhoarr( 67)=       17.74850008D0
	rhoarr( 68)=       16.83388727D0
	rhoarr( 69)=       16.05329707D0
	rhoarr( 70)=       15.36349166D0
	rhoarr( 71)=       14.72969105D0
	rhoarr( 72)=       14.12490946D0
	rhoarr( 73)=       13.52918465D0
	rhoarr( 74)=       12.92874919D0
	rhoarr( 75)=       12.31517297D0
	rhoarr( 76)=       11.68449570D0
	rhoarr( 77)=       11.03636605D0
	rhoarr( 78)=       10.37320714D0
	rhoarr( 79)=        9.69943202D0
	rhoarr( 80)=        9.02073410D0
	rhoarr( 81)=        8.34347408D0
	rhoarr( 82)=        7.67417747D0
	rhoarr( 83)=        7.01914671D0
	rhoarr( 84)=        6.38418170D0
	rhoarr( 85)=        5.77439463D0
	rhoarr( 86)=        5.19410059D0
	rhoarr( 87)=        4.64676478D0
	rhoarr( 88)=        4.13498976D0
	rhoarr( 89)=        3.66053050D0
	rhoarr( 90)=        3.22432989D0
	rhoarr( 91)=        2.82657134D0
	rhoarr( 92)=        2.46674721D0
	rhoarr( 93)=        2.14374240D0
	rhoarr( 94)=        1.85593137D0
	rhoarr( 95)=        1.60128508D0
	rhoarr( 96)=        1.37748246D0
	rhoarr( 97)=        1.18202016D0
	rhoarr( 98)=        1.01231375D0
	rhoarr( 99)=        0.86578499D0
	rhoarr(100)=        0.73993119D0
	rhoarr(101)=        0.63237527D0
	rhoarr(102)=        0.54089714D0
	rhoarr(103)=        0.46344936D0
	rhoarr(104)=        0.39816085D0
	rhoarr(105)=        0.34333314D0
	rhoarr(106)=        0.29743309D0
	rhoarr(107)=        0.25908490D0
	rhoarr(108)=        0.22706309D0
	rhoarr(109)=        0.20028665D0
	rhoarr(110)=        0.17781386D0
	rhoarr(111)=        0.15883664D0
	rhoarr(112)=        0.14267350D0
	rhoarr(113)=        0.12876031D0
	rhoarr(114)=        0.11663907D0
	rhoarr(115)=        0.10594479D0
	rhoarr(116)=        0.09639157D0
	rhoarr(117)=        0.08775880D0
	rhoarr(118)=        0.07987830D0
	rhoarr(119)=        0.07262323D0
	rhoarr(120)=        0.06589898D0
	rhoarr(121)=        0.05963610D0
	rhoarr(122)=        0.05378481D0
	rhoarr(123)=        0.04831080D0
	rhoarr(124)=        0.04319176D0
	rhoarr(125)=        0.03841430D0
	rhoarr(126)=        0.03397125D0
	rhoarr(127)=        0.02985899D0
	rhoarr(128)=        0.02607530D0
	rhoarr(129)=        0.02261742D0
	rhoarr(130)=        0.01948068D0
	rhoarr(131)=        0.01665757D0
	rhoarr(132)=        0.01413733D0
	rhoarr(133)=        0.01190601D0
	rhoarr(134)=        0.00994680D0
	rhoarr(135)=        0.00824074D0
	rhoarr(136)=        0.00676743D0
	rhoarr(137)=        0.00550581D0
	rhoarr(138)=        0.00443485D0
	rhoarr(139)=        0.00353408D0
	rhoarr(140)=        0.00278395D0
	rhoarr(141)=        0.00216607D0
	rhoarr(142)=        0.00166325D0
	rhoarr(143)=        0.00125950D0
	rhoarr(144)=        0.00094005D0
	rhoarr(145)=        0.00069130D0
	rhoarr(146)=        0.00050083D0
	rhoarr(147)=        0.00035748D0
	rhoarr(148)=        0.00025142D0
	rhoarr(149)=        0.00017422D0
	rhoarr(150)=        0.00011887D0
	rhoarr(151)=        0.00007973D0
	rhoarr(152)=        0.00005243D0
	rhoarr(153)=        0.00003364D0
	rhoarr(154)=        0.00002093D0
	rhoarr(155)=        0.00001253D0
	rhoarr(156)=        0.00000716D0
	rhoarr(157)=        0.00000386D0
	rhoarr(158)=        0.00000195D0
	rhoarr(159)=        0.00000091D0
	rhoarr(160)=        0.00000040D0
	rhoarr(161)=        0.00000016D0
	rhoarr(162)=        0.00000006D0
	rhoarr(163)=        0.00000002D0

else if (iele==34) then  !Se, 0 3, b3lyp/ANO-RCC int=dkh2
	npt=  163
	rhoarr(  1)=    74844.28256552D0
	rhoarr(  2)=    63189.91512705D0
	rhoarr(  3)=    51488.56165139D0
	rhoarr(  4)=    44394.42873205D0
	rhoarr(  5)=    39016.94527192D0
	rhoarr(  6)=    34660.22232116D0
	rhoarr(  7)=    30916.57887994D0
	rhoarr(  8)=    27677.03774389D0
	rhoarr(  9)=    24730.38471951D0
	rhoarr( 10)=    22055.74913546D0
	rhoarr( 11)=    19615.29890804D0
	rhoarr( 12)=    17361.02506562D0
	rhoarr( 13)=    15284.70244446D0
	rhoarr( 14)=    13385.61354443D0
	rhoarr( 15)=    11653.21229212D0
	rhoarr( 16)=    10078.53501147D0
	rhoarr( 17)=     8658.66676294D0
	rhoarr( 18)=     7390.77889458D0
	rhoarr( 19)=     6268.39776713D0
	rhoarr( 20)=     5282.87258383D0
	rhoarr( 21)=     4425.44656944D0
	rhoarr( 22)=     3687.36747741D0
	rhoarr( 23)=     3059.08017219D0
	rhoarr( 24)=     2530.00633328D0
	rhoarr( 25)=     2089.09594493D0
	rhoarr( 26)=     1725.51101385D0
	rhoarr( 27)=     1428.98021711D0
	rhoarr( 28)=     1189.85129323D0
	rhoarr( 29)=      999.08122661D0
	rhoarr( 30)=      848.31078578D0
	rhoarr( 31)=      730.00400595D0
	rhoarr( 32)=      637.56154003D0
	rhoarr( 33)=      565.34883515D0
	rhoarr( 34)=      508.64404366D0
	rhoarr( 35)=      463.54685575D0
	rhoarr( 36)=      426.88609948D0
	rhoarr( 37)=      396.14099606D0
	rhoarr( 38)=      369.37151555D0
	rhoarr( 39)=      345.14745830D0
	rhoarr( 40)=      322.47081941D0
	rhoarr( 41)=      300.69372406D0
	rhoarr( 42)=      279.43877436D0
	rhoarr( 43)=      258.52849012D0
	rhoarr( 44)=      237.92735913D0
	rhoarr( 45)=      217.69641445D0
	rhoarr( 46)=      197.95799694D0
	rhoarr( 47)=      178.86788834D0
	rhoarr( 48)=      160.59277289D0
	rhoarr( 49)=      143.29212330D0
	rhoarr( 50)=      127.10442523D0
	rhoarr( 51)=      112.13788973D0
	rhoarr( 52)=       98.46555908D0
	rhoarr( 53)=       86.12426979D0
	rhoarr( 54)=       75.11656735D0
	rhoarr( 55)=       65.41452445D0
	rhoarr( 56)=       56.96451281D0
	rhoarr( 57)=       49.69223680D0
	rhoarr( 58)=       43.50763385D0
	rhoarr( 59)=       38.30948483D0
	rhoarr( 60)=       33.98970679D0
	rhoarr( 61)=       30.43732715D0
	rhoarr( 62)=       27.54210312D0
	rhoarr( 63)=       25.19770263D0
	rhoarr( 64)=       23.30434184D0
	rhoarr( 65)=       21.77079329D0
	rhoarr( 66)=       20.51573096D0
	rhoarr( 67)=       19.46844268D0
	rhoarr( 68)=       18.56899532D0
	rhoarr( 69)=       17.76796931D0
	rhoarr( 70)=       17.02588291D0
	rhoarr( 71)=       16.31240929D0
	rhoarr( 72)=       15.60546262D0
	rhoarr( 73)=       14.89020350D0
	rhoarr( 74)=       14.15799695D0
	rhoarr( 75)=       13.40534994D0
	rhoarr( 76)=       12.63285670D0
	rhoarr( 77)=       11.84418487D0
	rhoarr( 78)=       11.04513766D0
	rhoarr( 79)=       10.24282395D0
	rhoarr( 80)=        9.44495957D0
	rhoarr( 81)=        8.65930978D0
	rhoarr( 82)=        7.89326962D0
	rhoarr( 83)=        7.15356710D0
	rhoarr( 84)=        6.44606786D0
	rhoarr( 85)=        5.77565803D0
	rhoarr( 86)=        5.14618474D0
	rhoarr( 87)=        4.56043928D0
	rhoarr( 88)=        4.02017359D0
	rhoarr( 89)=        3.52614565D0
	rhoarr( 90)=        3.07819205D0
	rhoarr( 91)=        2.67532567D0
	rhoarr( 92)=        2.31585554D0
	rhoarr( 93)=        1.99752265D0
	rhoarr( 94)=        1.71764392D0
	rhoarr( 95)=        1.47325484D0
	rhoarr( 96)=        1.26124172D0
	rhoarr( 97)=        1.07845608D0
	rhoarr( 98)=        0.92180637D0
	rhoarr( 99)=        0.78832529D0
	rhoarr(100)=        0.67521419D0
	rhoarr(101)=        0.57986817D0
	rhoarr(102)=        0.49988696D0
	rhoarr(103)=        0.43307688D0
	rhoarr(104)=        0.37744828D0
	rhoarr(105)=        0.33121155D0
	rhoarr(106)=        0.29277314D0
	rhoarr(107)=        0.26073155D0
	rhoarr(108)=        0.23387247D0
	rhoarr(109)=        0.21116187D0
	rhoarr(110)=        0.19173604D0
	rhoarr(111)=        0.17488835D0
	rhoarr(112)=        0.16005295D0
	rhoarr(113)=        0.14678635D0
	rhoarr(114)=        0.13474824D0
	rhoarr(115)=        0.12368283D0
	rhoarr(116)=        0.11340185D0
	rhoarr(117)=        0.10377002D0
	rhoarr(118)=        0.09469309D0
	rhoarr(119)=        0.08610855D0
	rhoarr(120)=        0.07797816D0
	rhoarr(121)=        0.07028211D0
	rhoarr(122)=        0.06301399D0
	rhoarr(123)=        0.05617642D0
	rhoarr(124)=        0.04977709D0
	rhoarr(125)=        0.04382529D0
	rhoarr(126)=        0.03832897D0
	rhoarr(127)=        0.03329241D0
	rhoarr(128)=        0.02871470D0
	rhoarr(129)=        0.02458888D0
	rhoarr(130)=        0.02090184D0
	rhoarr(131)=        0.01763472D0
	rhoarr(132)=        0.01476387D0
	rhoarr(133)=        0.01226200D0
	rhoarr(134)=        0.01009949D0
	rhoarr(135)=        0.00824559D0
	rhoarr(136)=        0.00666952D0
	rhoarr(137)=        0.00534132D0
	rhoarr(138)=        0.00423241D0
	rhoarr(139)=        0.00331593D0
	rhoarr(140)=        0.00256689D0
	rhoarr(141)=        0.00196216D0
	rhoarr(142)=        0.00148044D0
	rhoarr(143)=        0.00110220D0
	rhoarr(144)=        0.00080967D0
	rhoarr(145)=        0.00058688D0
	rhoarr(146)=        0.00041976D0
	rhoarr(147)=        0.00029619D0
	rhoarr(148)=        0.00020604D0
	rhoarr(149)=        0.00014108D0
	rhoarr(150)=        0.00009484D0
	rhoarr(151)=        0.00006233D0
	rhoarr(152)=        0.00003985D0
	rhoarr(153)=        0.00002462D0
	rhoarr(154)=        0.00001460D0
	rhoarr(155)=        0.00000825D0
	rhoarr(156)=        0.00000441D0
	rhoarr(157)=        0.00000222D0
	rhoarr(158)=        0.00000106D0
	rhoarr(159)=        0.00000047D0
	rhoarr(160)=        0.00000020D0
	rhoarr(161)=        0.00000008D0
	rhoarr(162)=        0.00000003D0
	rhoarr(163)=        0.00000001D0

else if (iele==35) then  !Br, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=162
	rhoarr(  1)=  85304.13790793D0
	rhoarr(  2)=  70898.73573768D0
	rhoarr(  3)=  57569.28060582D0
	rhoarr(  4)=  49312.86007980D0
	rhoarr(  5)=  43207.34839842D0
	rhoarr(  6)=  38203.98183303D0
	rhoarr(  7)=  33971.61244729D0
	rhoarr(  8)=  30296.54478570D0
	rhoarr(  9)=  26968.59998493D0
	rhoarr( 10)=  23970.17399009D0
	rhoarr( 11)=  21236.63235740D0
	rhoarr( 12)=  18720.42839903D0
	rhoarr( 13)=  16417.38596341D0
	rhoarr( 14)=  14320.02886546D0
	rhoarr( 15)=  12412.94988701D0
	rhoarr( 16)=  10687.63361499D0
	rhoarr( 17)=   9141.01026710D0
	rhoarr( 18)=   7767.47859600D0
	rhoarr( 19)=   6557.54796180D0
	rhoarr( 20)=   5500.75408389D0
	rhoarr( 21)=   4587.00647027D0
	rhoarr( 22)=   3805.75659729D0
	rhoarr( 23)=   3145.20479733D0
	rhoarr( 24)=   2592.62614694D0
	rhoarr( 25)=   2135.24490793D0
	rhoarr( 26)=   1760.83915014D0
	rhoarr( 27)=   1457.88842230D0
	rhoarr( 28)=   1215.54275570D0
	rhoarr( 29)=   1023.67513451D0
	rhoarr( 30)=    873.05011764D0
	rhoarr( 31)=    755.49576565D0
	rhoarr( 32)=    663.97864485D0
	rhoarr( 33)=    592.56751421D0
	rhoarr( 34)=    536.33347205D0
	rhoarr( 35)=    491.24038145D0
	rhoarr( 36)=    454.05115897D0
	rhoarr( 37)=    422.24701775D0
	rhoarr( 38)=    393.94588945D0
	rhoarr( 39)=    367.81134875D0
	rhoarr( 40)=    342.95377186D0
	rhoarr( 41)=    318.83229150D0
	rhoarr( 42)=    295.16659243D0
	rhoarr( 43)=    271.86372690D0
	rhoarr( 44)=    248.96039295D0
	rhoarr( 45)=    226.57800068D0
	rhoarr( 46)=    204.88705883D0
	rhoarr( 47)=    184.07829024D0
	rhoarr( 48)=    164.33929236D0
	rhoarr( 49)=    145.83659892D0
	rhoarr( 50)=    128.70331926D0
	rhoarr( 51)=    113.03225149D0
	rhoarr( 52)=     98.87383028D0
	rhoarr( 53)=     86.23781568D0
	rhoarr( 54)=     75.09744649D0
	rhoarr( 55)=     65.39489257D0
	rhoarr( 56)=     57.04714629D0
	rhoarr( 57)=     49.95184832D0
	rhoarr( 58)=     43.99282915D0
	rhoarr( 59)=     39.04530456D0
	rhoarr( 60)=     34.98069965D0
	rhoarr( 61)=     31.67103988D0
	rhoarr( 62)=     28.99279909D0
	rhoarr( 63)=     26.83007678D0
	rhoarr( 64)=     25.07700650D0
	rhoarr( 65)=     23.63936245D0
	rhoarr( 66)=     22.43540817D0
	rhoarr( 67)=     21.39609432D0
	rhoarr( 68)=     20.46474522D0
	rhoarr( 69)=     19.59637555D0
	rhoarr( 70)=     18.75675606D0
	rhoarr( 71)=     17.92131615D0
	rhoarr( 72)=     17.07394265D0
	rhoarr( 73)=     16.20571728D0
	rhoarr( 74)=     15.31363004D0
	rhoarr( 75)=     14.39930859D0
	rhoarr( 76)=     13.46780758D0
	rhoarr( 77)=     12.52650221D0
	rhoarr( 78)=     11.58412294D0
	rhoarr( 79)=     10.64995471D0
	rhoarr( 80)=      9.73320729D0
	rhoarr( 81)=      8.84254705D0
	rhoarr( 82)=      7.98576888D0
	rhoarr( 83)=      7.16958102D0
	rhoarr( 84)=      6.39947655D0
	rhoarr( 85)=      5.67966992D0
	rhoarr( 86)=      5.01308396D0
	rhoarr( 87)=      4.40137929D0
	rhoarr( 88)=      3.84502220D0
	rhoarr( 89)=      3.34338820D0
	rhoarr( 90)=      2.89489745D0
	rhoarr( 91)=      2.49717494D0
	rhoarr( 92)=      2.14722606D0
	rhoarr( 93)=      1.84161562D0
	rhoarr( 94)=      1.57663857D0
	rhoarr( 95)=      1.34847220D0
	rhoarr( 96)=      1.15330258D0
	rhoarr( 97)=      0.98742181D0
	rhoarr( 98)=      0.84729672D0
	rhoarr( 99)=      0.72961263D0
	rhoarr(100)=      0.63129757D0
	rhoarr(101)=      0.54953336D0
	rhoarr(102)=      0.48175884D0
	rhoarr(103)=      0.42566930D0
	rhoarr(104)=      0.37921406D0
	rhoarr(105)=      0.34059288D0
	rhoarr(106)=      0.30825018D0
	rhoarr(107)=      0.28086628D0
	rhoarr(108)=      0.25734446D0
	rhoarr(109)=      0.23679370D0
	rhoarr(110)=      0.21850750D0
	rhoarr(111)=      0.20193997D0
	rhoarr(112)=      0.18668084D0
	rhoarr(113)=      0.17243095D0
	rhoarr(114)=      0.15897978D0
	rhoarr(115)=      0.14618591D0
	rhoarr(116)=      0.13396087D0
	rhoarr(117)=      0.12225606D0
	rhoarr(118)=      0.11105252D0
	rhoarr(119)=      0.10035254D0
	rhoarr(120)=      0.09017280D0
	rhoarr(121)=      0.08053844D0
	rhoarr(122)=      0.07147784D0
	rhoarr(123)=      0.06301816D0
	rhoarr(124)=      0.05518171D0
	rhoarr(125)=      0.04798312D0
	rhoarr(126)=      0.04142762D0
	rhoarr(127)=      0.03551020D0
	rhoarr(128)=      0.03021571D0
	rhoarr(129)=      0.02551981D0
	rhoarr(130)=      0.02139044D0
	rhoarr(131)=      0.01778964D0
	rhoarr(132)=      0.01467557D0
	rhoarr(133)=      0.01200437D0
	rhoarr(134)=      0.00973188D0
	rhoarr(135)=      0.00781493D0
	rhoarr(136)=      0.00621229D0
	rhoarr(137)=      0.00488526D0
	rhoarr(138)=      0.00379795D0
	rhoarr(139)=      0.00291727D0
	rhoarr(140)=      0.00221290D0
	rhoarr(141)=      0.00165718D0
	rhoarr(142)=      0.00122499D0
	rhoarr(143)=      0.00089380D0
	rhoarr(144)=      0.00064373D0
	rhoarr(145)=      0.00045757D0
	rhoarr(146)=      0.00032082D0
	rhoarr(147)=      0.00022160D0
	rhoarr(148)=      0.00015047D0
	rhoarr(149)=      0.00010009D0
	rhoarr(150)=      0.00006493D0
	rhoarr(151)=      0.00004084D0
	rhoarr(152)=      0.00002475D0
	rhoarr(153)=      0.00001436D0
	rhoarr(154)=      0.00000792D0
	rhoarr(155)=      0.00000413D0
	rhoarr(156)=      0.00000203D0
	rhoarr(157)=      0.00000094D0
	rhoarr(158)=      0.00000041D0
	rhoarr(159)=      0.00000017D0
	rhoarr(160)=      0.00000007D0
	rhoarr(161)=      0.00000003D0
	rhoarr(162)=      0.00000001D0

else if (iele==36) then  !Kr, 0 1, b3lyp/ANO-RCC int=dkh2
	npt=160
	rhoarr(  1)=  96877.74174883D0
	rhoarr(  2)=  79377.62495233D0
	rhoarr(  3)=  64206.49085025D0
	rhoarr(  4)=  54666.75893777D0
	rhoarr(  5)=  47734.09324461D0
	rhoarr(  6)=  42017.77681662D0
	rhoarr(  7)=  37244.84510358D0
	rhoarr(  8)=  33084.16468303D0
	rhoarr(  9)=  29342.84756680D0
	rhoarr( 10)=  25989.94053347D0
	rhoarr( 11)=  22935.60803346D0
	rhoarr( 12)=  20137.87299901D0
	rhoarr( 13)=  17592.18384569D0
	rhoarr( 14)=  15282.00533983D0
	rhoarr( 15)=  13188.95630539D0
	rhoarr( 16)=  11305.45885286D0
	rhoarr( 17)=   9626.74355138D0
	rhoarr( 18)=   8143.42247006D0
	rhoarr( 19)=   6843.15103517D0
	rhoarr( 20)=   5713.85820352D0
	rhoarr( 21)=   4743.73853211D0
	rhoarr( 22)=   3919.83793452D0
	rhoarr( 23)=   3227.76361787D0
	rhoarr( 24)=   2652.59814396D0
	rhoarr( 25)=   2179.85043565D0
	rhoarr( 26)=   1795.81491963D0
	rhoarr( 27)=   1487.54466357D0
	rhoarr( 28)=   1242.85159925D0
	rhoarr( 29)=   1050.48304985D0
	rhoarr( 30)=    900.36186148D0
	rhoarr( 31)=    783.73321832D0
	rhoarr( 32)=    693.16359597D0
	rhoarr( 33)=    622.43854059D0
	rhoarr( 34)=    566.43330750D0
	rhoarr( 35)=    520.99981644D0
	rhoarr( 36)=    482.87260831D0
	rhoarr( 37)=    449.57658003D0
	rhoarr( 38)=    419.32271670D0
	rhoarr( 39)=    390.89144044D0
	rhoarr( 40)=    363.51346056D0
	rhoarr( 41)=    336.76005454D0
	rhoarr( 42)=    310.45047016D0
	rhoarr( 43)=    284.57811475D0
	rhoarr( 44)=    259.25287386D0
	rhoarr( 45)=    234.65546384D0
	rhoarr( 46)=    211.00050707D0
	rhoarr( 47)=    188.50664261D0
	rhoarr( 48)=    167.37329832D0
	rhoarr( 49)=    147.76425143D0
	rhoarr( 50)=    129.79787391D0
	rhoarr( 51)=    113.54337513D0
	rhoarr( 52)=     99.02180904D0
	rhoarr( 53)=     86.21035303D0
	rhoarr( 54)=     75.04844238D0
	rhoarr( 55)=     65.44466571D0
	rhoarr( 56)=     57.28373200D0
	rhoarr( 57)=     50.43316707D0
	rhoarr( 58)=     44.74960840D0
	rhoarr( 59)=     40.08463853D0
	rhoarr( 60)=     36.29007764D0
	rhoarr( 61)=     33.22261221D0
	rhoarr( 62)=     30.74761902D0
	rhoarr( 63)=     28.74207570D0
	rhoarr( 64)=     27.09652133D0
	rhoarr( 65)=     25.71611611D0
	rhoarr( 66)=     24.52092164D0
	rhoarr( 67)=     23.44556181D0
	rhoarr( 68)=     22.43842811D0
	rhoarr( 69)=     21.46056965D0
	rhoarr( 70)=     20.48437458D0
	rhoarr( 71)=     19.49211895D0
	rhoarr( 72)=     18.47444042D0
	rhoarr( 73)=     17.42878832D0
	rhoarr( 74)=     16.35790324D0
	rhoarr( 75)=     15.26838125D0
	rhoarr( 76)=     14.16937506D0
	rhoarr( 77)=     13.07147248D0
	rhoarr( 78)=     11.98577514D0
	rhoarr( 79)=     10.92317990D0
	rhoarr( 80)=      9.89384722D0
	rhoarr( 81)=      8.90682939D0
	rhoarr( 82)=      7.96982674D0
	rhoarr( 83)=      7.08904293D0
	rhoarr( 84)=      6.26911697D0
	rhoarr( 85)=      5.51311764D0
	rhoarr( 86)=      4.82259225D0
	rhoarr( 87)=      4.19766503D0
	rhoarr( 88)=      3.63718012D0
	rhoarr( 89)=      3.13888167D0
	rhoarr( 90)=      2.69961997D0
	rhoarr( 91)=      2.31556975D0
	rhoarr( 92)=      1.98244591D0
	rhoarr( 93)=      1.69570275D0
	rhoarr( 94)=      1.45070619D0
	rhoarr( 95)=      1.24287299D0
	rhoarr( 96)=      1.06777536D0
	rhoarr( 97)=      0.92121389D0
	rhoarr( 98)=      0.79926426D0
	rhoarr( 99)=      0.69830465D0
	rhoarr(100)=      0.61503033D0
	rhoarr(101)=      0.54646041D0
	rhoarr(102)=      0.48993981D0
	rhoarr(103)=      0.44313766D0
	rhoarr(104)=      0.40404179D0
	rhoarr(105)=      0.37094843D0
	rhoarr(106)=      0.34244634D0
	rhoarr(107)=      0.31739507D0
	rhoarr(108)=      0.29489807D0
	rhoarr(109)=      0.27427199D0
	rhoarr(110)=      0.25501408D0
	rhoarr(111)=      0.23676995D0
	rhoarr(112)=      0.21930333D0
	rhoarr(113)=      0.20246936D0
	rhoarr(114)=      0.18619212D0
	rhoarr(115)=      0.17044620D0
	rhoarr(116)=      0.15524213D0
	rhoarr(117)=      0.14061468D0
	rhoarr(118)=      0.12661350D0
	rhoarr(119)=      0.11329526D0
	rhoarr(120)=      0.10071714D0
	rhoarr(121)=      0.08893131D0
	rhoarr(122)=      0.07798054D0
	rhoarr(123)=      0.06789486D0
	rhoarr(124)=      0.05868955D0
	rhoarr(125)=      0.05036423D0
	rhoarr(126)=      0.04290320D0
	rhoarr(127)=      0.03627676D0
	rhoarr(128)=      0.03044333D0
	rhoarr(129)=      0.02535209D0
	rhoarr(130)=      0.02094580D0
	rhoarr(131)=      0.01716367D0
	rhoarr(132)=      0.01394379D0
	rhoarr(133)=      0.01122524D0
	rhoarr(134)=      0.00894964D0
	rhoarr(135)=      0.00706212D0
	rhoarr(136)=      0.00551188D0
	rhoarr(137)=      0.00425235D0
	rhoarr(138)=      0.00324104D0
	rhoarr(139)=      0.00243944D0
	rhoarr(140)=      0.00181273D0
	rhoarr(141)=      0.00132975D0
	rhoarr(142)=      0.00096293D0
	rhoarr(143)=      0.00068829D0
	rhoarr(144)=      0.00048547D0
	rhoarr(145)=      0.00033761D0
	rhoarr(146)=      0.00023110D0
	rhoarr(147)=      0.00015531D0
	rhoarr(148)=      0.00010208D0
	rhoarr(149)=      0.00006529D0
	rhoarr(150)=      0.00004040D0
	rhoarr(151)=      0.00002403D0
	rhoarr(152)=      0.00001364D0
	rhoarr(153)=      0.00000735D0
	rhoarr(154)=      0.00000374D0
	rhoarr(155)=      0.00000179D0
	rhoarr(156)=      0.00000081D0
	rhoarr(157)=      0.00000034D0
	rhoarr(158)=      0.00000014D0
	rhoarr(159)=      0.00000006D0
	rhoarr(160)=      0.00000002D0
	
else if (iele==37) then  !Rb, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=170
	rhoarr(  1)=   108895.65556639D0
	rhoarr(  2)=    88882.90569113D0
	rhoarr(  3)=    71416.96595507D0
	rhoarr(  4)=    60525.97538308D0
	rhoarr(  5)=    52628.07744567D0
	rhoarr(  6)=    46148.25785164D0
	rhoarr(  7)=    40750.32842080D0
	rhoarr(  8)=    36068.94746858D0
	rhoarr(  9)=    31871.53957128D0
	rhoarr( 10)=    28124.15883192D0
	rhoarr( 11)=    24725.84330594D0
	rhoarr( 12)=    21624.74457282D0
	rhoarr( 13)=    18814.47071985D0
	rhoarr( 14)=    16276.20386473D0
	rhoarr( 15)=    13987.24189574D0
	rhoarr( 16)=    11936.80720694D0
	rhoarr( 17)=    10118.29656820D0
	rhoarr( 18)=     8520.21748209D0
	rhoarr( 19)=     7127.33613736D0
	rhoarr( 20)=     5924.54171366D0
	rhoarr( 21)=     4897.35145866D0
	rhoarr( 22)=     4030.46125608D0
	rhoarr( 23)=     3307.22448305D0
	rhoarr( 24)=     2710.48495775D0
	rhoarr( 25)=     2223.62407021D0
	rhoarr( 26)=     1831.05220518D0
	rhoarr( 27)=     1518.24775840D0
	rhoarr( 28)=     1271.74968271D0
	rhoarr( 29)=     1079.29222101D0
	rhoarr( 30)=      930.00232159D0
	rhoarr( 31)=      814.51456906D0
	rhoarr( 32)=      724.94806379D0
	rhoarr( 33)=      654.78755228D0
	rhoarr( 34)=      598.73823411D0
	rhoarr( 35)=      552.59367780D0
	rhoarr( 36)=      513.11753805D0
	rhoarr( 37)=      477.92317280D0
	rhoarr( 38)=      445.34158309D0
	rhoarr( 39)=      414.28219328D0
	rhoarr( 40)=      384.09938939D0
	rhoarr( 41)=      354.47656749D0
	rhoarr( 42)=      325.33253145D0
	rhoarr( 43)=      296.74821999D0
	rhoarr( 44)=      268.90847700D0
	rhoarr( 45)=      242.05412644D0
	rhoarr( 46)=      216.44209252D0
	rhoarr( 47)=      192.31356806D0
	rhoarr( 48)=      169.87108912D0
	rhoarr( 49)=      149.26482720D0
	rhoarr( 50)=      130.58720344D0
	rhoarr( 51)=      113.87388884D0
	rhoarr( 52)=       99.10885821D0
	rhoarr( 53)=       86.23144483D0
	rhoarr( 54)=       75.14401938D0
	rhoarr( 55)=       65.71963317D0
	rhoarr( 56)=       57.80946059D0
	rhoarr( 57)=       51.25006300D0
	rhoarr( 58)=       45.87044133D0
	rhoarr( 59)=       41.49868998D0
	rhoarr( 60)=       37.96794580D0
	rhoarr( 61)=       35.12131540D0
	rhoarr( 62)=       32.81556476D0
	rhoarr( 63)=       30.92351687D0
	rhoarr( 64)=       29.33526205D0
	rhoarr( 65)=       27.95839336D0
	rhoarr( 66)=       26.71751679D0
	rhoarr( 67)=       25.55326363D0
	rhoarr( 68)=       24.42097623D0
	rhoarr( 69)=       23.28917890D0
	rhoarr( 70)=       22.13790248D0
	rhoarr( 71)=       20.95691295D0
	rhoarr( 72)=       19.74389573D0
	rhoarr( 73)=       18.50265840D0
	rhoarr( 74)=       17.24142285D0
	rhoarr( 75)=       15.97127582D0
	rhoarr( 76)=       14.70483321D0
	rhoarr( 77)=       13.45515035D0
	rhoarr( 78)=       12.23488403D0
	rhoarr( 79)=       11.05568893D0
	rhoarr( 80)=        9.92781451D0
	rhoarr( 81)=        8.85986120D0
	rhoarr( 82)=        7.85865599D0
	rhoarr( 83)=        6.92921430D0
	rhoarr( 84)=        6.07476511D0
	rhoarr( 85)=        5.29682544D0
	rhoarr( 86)=        4.59531725D0
	rhoarr( 87)=        3.96872279D0
	rhoarr( 88)=        3.41427441D0
	rhoarr( 89)=        2.92817186D0
	rhoarr( 90)=        2.50581698D0
	rhoarr( 91)=        2.14205295D0
	rhoarr( 92)=        1.83139409D0
	rhoarr( 93)=        1.56823374D0
	rhoarr( 94)=        1.34702058D0
	rhoarr( 95)=        1.16239806D0
	rhoarr( 96)=        1.00930637D0
	rhoarr( 97)=        0.88305012D0
	rhoarr( 98)=        0.77933776D0
	rhoarr( 99)=        0.69429998D0
	rhoarr(100)=        0.62449370D0
	rhoarr(101)=        0.56689704D0
	rhoarr(102)=        0.51889853D0
	rhoarr(103)=        0.47828187D0
	rhoarr(104)=        0.44320643D0
	rhoarr(105)=        0.41218283D0
	rhoarr(106)=        0.38404348D0
	rhoarr(107)=        0.35790841D0
	rhoarr(108)=        0.33314727D0
	rhoarr(109)=        0.30933955D0
	rhoarr(110)=        0.28623458D0
	rhoarr(111)=        0.26371345D0
	rhoarr(112)=        0.24175431D0
	rhoarr(113)=        0.22040215D0
	rhoarr(114)=        0.19974356D0
	rhoarr(115)=        0.17988658D0
	rhoarr(116)=        0.16094516D0
	rhoarr(117)=        0.14302759D0
	rhoarr(118)=        0.12622829D0
	rhoarr(119)=        0.11062204D0
	rhoarr(120)=        0.09626044D0
	rhoarr(121)=        0.08317009D0
	rhoarr(122)=        0.07135238D0
	rhoarr(123)=        0.06078473D0
	rhoarr(124)=        0.05142318D0
	rhoarr(125)=        0.04320588D0
	rhoarr(126)=        0.03605734D0
	rhoarr(127)=        0.02989278D0
	rhoarr(128)=        0.02462238D0
	rhoarr(129)=        0.02015501D0
	rhoarr(130)=        0.01640120D0
	rhoarr(131)=        0.01327533D0
	rhoarr(132)=        0.01069697D0
	rhoarr(133)=        0.00859154D0
	rhoarr(134)=        0.00689051D0
	rhoarr(135)=        0.00553125D0
	rhoarr(136)=        0.00445685D0
	rhoarr(137)=        0.00361598D0
	rhoarr(138)=        0.00296288D0
	rhoarr(139)=        0.00245746D0
	rhoarr(140)=        0.00206540D0
	rhoarr(141)=        0.00175823D0
	rhoarr(142)=        0.00151314D0
	rhoarr(143)=        0.00131254D0
	rhoarr(144)=        0.00114352D0
	rhoarr(145)=        0.00099701D0
	rhoarr(146)=        0.00086700D0
	rhoarr(147)=        0.00074974D0
	rhoarr(148)=        0.00064307D0
	rhoarr(149)=        0.00054585D0
	rhoarr(150)=        0.00045760D0
	rhoarr(151)=        0.00037815D0
	rhoarr(152)=        0.00030748D0
	rhoarr(153)=        0.00024558D0
	rhoarr(154)=        0.00019232D0
	rhoarr(155)=        0.00014744D0
	rhoarr(156)=        0.00011046D0
	rhoarr(157)=        0.00008075D0
	rhoarr(158)=        0.00005749D0
	rhoarr(159)=        0.00003979D0
	rhoarr(160)=        0.00002670D0
	rhoarr(161)=        0.00001731D0
	rhoarr(162)=        0.00001080D0
	rhoarr(163)=        0.00000644D0
	rhoarr(164)=        0.00000365D0
	rhoarr(165)=        0.00000194D0
	rhoarr(166)=        0.00000096D0
	rhoarr(167)=        0.00000043D0
	rhoarr(168)=        0.00000018D0
	rhoarr(169)=        0.00000007D0
	rhoarr(170)=        0.00000002D0

else if (iele==38) then  !Sr, 0 1, b3lyp/ANO-RCC int=dkh2
	npt=169
	rhoarr(  1)=   123111.09299442D0
	rhoarr(  2)=    99102.15369640D0
	rhoarr(  3)=    79304.85928197D0
	rhoarr(  4)=    66824.44244688D0
	rhoarr(  5)=    57886.38734050D0
	rhoarr(  6)=    50539.59227574D0
	rhoarr(  7)=    44480.73506957D0
	rhoarr(  8)=    39212.24777558D0
	rhoarr(  9)=    34524.91926898D0
	rhoarr( 10)=    30356.25300454D0
	rhoarr( 11)=    26581.61619787D0
	rhoarr( 12)=    23156.29799230D0
	rhoarr( 13)=    20068.55709430D0
	rhoarr( 14)=    17288.78728775D0
	rhoarr( 15)=    14792.21047737D0
	rhoarr( 16)=    12568.28133602D0
	rhoarr( 17)=    10606.87625082D0
	rhoarr( 18)=     8891.66688980D0
	rhoarr( 19)=     7404.22993192D0
	rhoarr( 20)=     6127.34750298D0
	rhoarr( 21)=     5044.00922813D0
	rhoarr( 22)=     4135.77816943D0
	rhoarr( 23)=     3382.98401603D0
	rhoarr( 24)=     2766.01306276D0
	rhoarr( 25)=     2266.25780214D0
	rhoarr( 26)=     1866.35149375D0
	rhoarr( 27)=     1550.12737990D0
	rhoarr( 28)=     1302.70286086D0
	rhoarr( 29)=     1110.70959368D0
	rhoarr( 30)=      962.48961878D0
	rhoarr( 31)=      848.13542564D0
	rhoarr( 32)=      759.38951066D0
	rhoarr( 33)=      689.48607289D0
	rhoarr( 34)=      632.99672992D0
	rhoarr( 35)=      585.69203971D0
	rhoarr( 36)=      544.40197318D0
	rhoarr( 37)=      506.86143269D0
	rhoarr( 38)=      471.54414858D0
	rhoarr( 39)=      437.50045053D0
	rhoarr( 40)=      404.21423690D0
	rhoarr( 41)=      371.48605620D0
	rhoarr( 42)=      339.34034225D0
	rhoarr( 43)=      307.95054137D0
	rhoarr( 44)=      277.57657375D0
	rhoarr( 45)=      248.51225626D0
	rhoarr( 46)=      221.04309348D0
	rhoarr( 47)=      195.41569715D0
	rhoarr( 48)=      171.81915195D0
	rhoarr( 49)=      150.37697977D0
	rhoarr( 50)=      131.14706328D0
	rhoarr( 51)=      114.12652963D0
	rhoarr( 52)=       99.25910275D0
	rhoarr( 53)=       86.44337110D0
	rhoarr( 54)=       75.54130465D0
	rhoarr( 55)=       66.38688537D0
	rhoarr( 56)=       58.79484066D0
	rhoarr( 57)=       52.56932403D0
	rhoarr( 58)=       47.51217825D0
	rhoarr( 59)=       43.43030453D0
	rhoarr( 60)=       40.14171079D0
	rhoarr( 61)=       37.47999206D0
	rhoarr( 62)=       35.29722442D0
	rhoarr( 63)=       33.46544706D0
	rhoarr( 64)=       31.87701491D0
	rhoarr( 65)=       30.44412077D0
	rhoarr( 66)=       29.09773648D0
	rhoarr( 67)=       27.78614828D0
	rhoarr( 68)=       26.47319723D0
	rhoarr( 69)=       25.13629955D0
	rhoarr( 70)=       23.76431623D0
	rhoarr( 71)=       22.35535346D0
	rhoarr( 72)=       20.91458997D0
	rhoarr( 73)=       19.45223147D0
	rhoarr( 74)=       17.98167989D0
	rhoarr( 75)=       16.51797892D0
	rhoarr( 76)=       15.07656336D0
	rhoarr( 77)=       13.67230662D0
	rhoarr( 78)=       12.31883569D0
	rhoarr( 79)=       11.02806818D0
	rhoarr( 80)=        9.80992393D0
	rhoarr( 81)=        8.67216889D0
	rhoarr( 82)=        7.62036019D0
	rhoarr( 83)=        6.65787195D0
	rhoarr( 84)=        5.78599065D0
	rhoarr( 85)=        5.00407243D0
	rhoarr( 86)=        4.30975575D0
	rhoarr( 87)=        3.69921907D0
	rhoarr( 88)=        3.16746987D0
	rhoarr( 89)=        2.70864754D0
	rhoarr( 90)=        2.31632155D0
	rhoarr( 91)=        1.98376765D0
	rhoarr( 92)=        1.70420857D0
	rhoarr( 93)=        1.47101093D0
	rhoarr( 94)=        1.27783599D0
	rhoarr( 95)=        1.11874679D0
	rhoarr( 96)=        0.98827807D0
	rhoarr( 97)=        0.88147691D0
	rhoarr( 98)=        0.79392197D0
	rhoarr( 99)=        0.72172778D0
	rhoarr(100)=        0.66153827D0
	rhoarr(101)=        0.61051156D0
	rhoarr(102)=        0.56629682D0
	rhoarr(103)=        0.52700305D0
	rhoarr(104)=        0.49116016D0
	rhoarr(105)=        0.45767326D0
	rhoarr(106)=        0.42577192D0
	rhoarr(107)=        0.39495694D0
	rhoarr(108)=        0.36494718D0
	rhoarr(109)=        0.33562897D0
	rhoarr(110)=        0.30701022D0
	rhoarr(111)=        0.27918066D0
	rhoarr(112)=        0.25227871D0
	rhoarr(113)=        0.22646518D0
	rhoarr(114)=        0.20190321D0
	rhoarr(115)=        0.17874351D0
	rhoarr(116)=        0.15711402D0
	rhoarr(117)=        0.13711300D0
	rhoarr(118)=        0.11880504D0
	rhoarr(119)=        0.10221933D0
	rhoarr(120)=        0.08735004D0
	rhoarr(121)=        0.07415855D0
	rhoarr(122)=        0.06257725D0
	rhoarr(123)=        0.05251444D0
	rhoarr(124)=        0.04386010D0
	rhoarr(125)=        0.03649169D0
	rhoarr(126)=        0.03027985D0
	rhoarr(127)=        0.02509335D0
	rhoarr(128)=        0.02080324D0
	rhoarr(129)=        0.01728602D0
	rhoarr(130)=        0.01442591D0
	rhoarr(131)=        0.01211634D0
	rhoarr(132)=        0.01026077D0
	rhoarr(133)=        0.00877317D0
	rhoarr(134)=        0.00757814D0
	rhoarr(135)=        0.00661093D0
	rhoarr(136)=        0.00581721D0
	rhoarr(137)=        0.00515273D0
	rhoarr(138)=        0.00458273D0
	rhoarr(139)=        0.00408109D0
	rhoarr(140)=        0.00362926D0
	rhoarr(141)=        0.00321495D0
	rhoarr(142)=        0.00283076D0
	rhoarr(143)=        0.00247288D0
	rhoarr(144)=        0.00213986D0
	rhoarr(145)=        0.00183169D0
	rhoarr(146)=        0.00154897D0
	rhoarr(147)=        0.00129247D0
	rhoarr(148)=        0.00106277D0
	rhoarr(149)=        0.00086009D0
	rhoarr(150)=        0.00068413D0
	rhoarr(151)=        0.00053407D0
	rhoarr(152)=        0.00040858D0
	rhoarr(153)=        0.00030582D0
	rhoarr(154)=        0.00022357D0
	rhoarr(155)=        0.00015931D0
	rhoarr(156)=        0.00011040D0
	rhoarr(157)=        0.00007421D0
	rhoarr(158)=        0.00004824D0
	rhoarr(159)=        0.00003021D0
	rhoarr(160)=        0.00001814D0
	rhoarr(161)=        0.00001040D0
	rhoarr(162)=        0.00000567D0
	rhoarr(163)=        0.00000292D0
	rhoarr(164)=        0.00000142D0
	rhoarr(165)=        0.00000065D0
	rhoarr(166)=        0.00000028D0
	rhoarr(167)=        0.00000011D0
	rhoarr(168)=        0.00000005D0
	rhoarr(169)=        0.00000002D0

else if (iele==39) then  !Y, 4d1 5s2, 0 2, HF/UGBS int=dkh2
	npt=  168
	rhoarr(  1)=   121373.01578483D0
	rhoarr(  2)=   109681.15194164D0
	rhoarr(  3)=    87337.17343983D0
	rhoarr(  4)=    73904.28703810D0
	rhoarr(  5)=    63361.23007230D0
	rhoarr(  6)=    55308.32774119D0
	rhoarr(  7)=    48417.51020450D0
	rhoarr(  8)=    42538.73932630D0
	rhoarr(  9)=    37335.36852982D0
	rhoarr( 10)=    32684.24965701D0
	rhoarr( 11)=    28512.68304527D0
	rhoarr( 12)=    24750.61996083D0
	rhoarr( 13)=    21360.56146838D0
	rhoarr( 14)=    18320.19854959D0
	rhoarr( 15)=    15608.94011690D0
	rhoarr( 16)=    13207.07279358D0
	rhoarr( 17)=    11096.32319438D0
	rhoarr( 18)=     9258.65770550D0
	rhoarr( 19)=     7674.94432755D0
	rhoarr( 20)=     6324.64483028D0
	rhoarr( 21)=     5186.11876108D0
	rhoarr( 22)=     4237.15313527D0
	rhoarr( 23)=     3455.53914937D0
	rhoarr( 24)=     2819.55390979D0
	rhoarr( 25)=     2308.36173190D0
	rhoarr( 26)=     1902.38390502D0
	rhoarr( 27)=     1583.60799888D0
	rhoarr( 28)=     1335.80004631D0
	rhoarr( 29)=     1144.62469402D0
	rhoarr( 30)=      997.68876657D0
	rhoarr( 31)=      884.51249030D0
	rhoarr( 32)=      796.43420676D0
	rhoarr( 33)=      726.46546142D0
	rhoarr( 34)=      669.11694564D0
	rhoarr( 35)=      620.21036902D0
	rhoarr( 36)=      576.68547928D0
	rhoarr( 37)=      536.40946544D0
	rhoarr( 38)=      497.99589931D0
	rhoarr( 39)=      460.63936646D0
	rhoarr( 40)=      423.96960935D0
	rhoarr( 41)=      387.92653210D0
	rhoarr( 42)=      352.65575419D0
	rhoarr( 43)=      318.42362894D0
	rhoarr( 44)=      285.55035101D0
	rhoarr( 45)=      254.35957295D0
	rhoarr( 46)=      225.14268822D0
	rhoarr( 47)=      198.13566698D0
	rhoarr( 48)=      173.50617449D0
	rhoarr( 49)=      151.34874214D0
	rhoarr( 50)=      131.68598747D0
	rhoarr( 51)=      114.47420565D0
	rhoarr( 52)=       99.61197159D0
	rhoarr( 53)=       86.95063203D0
	rhoarr( 54)=       76.30572663D0
	rhoarr( 55)=       67.46850132D0
	rhoarr( 56)=       60.21681579D0
	rhoarr( 57)=       54.32492245D0
	rhoarr( 58)=       49.57179090D0
	rhoarr( 59)=       45.74783579D0
	rhoarr( 60)=       42.66004636D0
	rhoarr( 61)=       40.13560212D0
	rhoarr( 62)=       38.02410208D0
	rhoarr( 63)=       36.19855504D0
	rhoarr( 64)=       34.55529287D0
	rhoarr( 65)=       33.01298556D0
	rhoarr( 66)=       31.51095229D0
	rhoarr( 67)=       30.00697023D0
	rhoarr( 68)=       28.47477639D0
	rhoarr( 69)=       26.90143687D0
	rhoarr( 70)=       25.28472742D0
	rhoarr( 71)=       23.63063450D0
	rhoarr( 72)=       21.95105442D0
	rhoarr( 73)=       20.26174115D0
	rhoarr( 74)=       18.58053238D0
	rhoarr( 75)=       16.92586757D0
	rhoarr( 76)=       15.31559782D0
	rhoarr( 77)=       13.76607713D0
	rhoarr( 78)=       12.29151502D0
	rhoarr( 79)=       10.90356377D0
	rhoarr( 80)=        9.61110927D0
	rhoarr( 81)=        8.42023192D0
	rhoarr( 82)=        7.33430397D0
	rhoarr( 83)=        6.35419063D0
	rhoarr( 84)=        5.47852449D0
	rhoarr( 85)=        4.70402559D0
	rhoarr( 86)=        4.02584331D0
	rhoarr( 87)=        3.43790051D0
	rhoarr( 88)=        2.93322487D0
	rhoarr( 89)=        2.50425697D0
	rhoarr( 90)=        2.14312861D0
	rhoarr( 91)=        1.84190768D0
	rhoarr( 92)=        1.59280827D0
	rhoarr( 93)=        1.38836547D0
	rhoarr( 94)=        1.22157499D0
	rhoarr( 95)=        1.08599834D0
	rhoarr( 96)=        0.97583447D0
	rhoarr( 97)=        0.88596012D0
	rhoarr( 98)=        0.81194169D0
	rhoarr( 99)=        0.75002277D0
	rhoarr(100)=        0.69709208D0
	rhoarr(101)=        0.65063672D0
	rhoarr(102)=        0.60868554D0
	rhoarr(103)=        0.56974678D0
	rhoarr(104)=        0.53274329D0
	rhoarr(105)=        0.49694798D0
	rhoarr(106)=        0.46192122D0
	rhoarr(107)=        0.42745184D0
	rhoarr(108)=        0.39350266D0
	rhoarr(109)=        0.36016160D0
	rhoarr(110)=        0.32759887D0
	rhoarr(111)=        0.29603086D0
	rhoarr(112)=        0.26569063D0
	rhoarr(113)=        0.23680481D0
	rhoarr(114)=        0.20957643D0
	rhoarr(115)=        0.18417309D0
	rhoarr(116)=        0.16071955D0
	rhoarr(117)=        0.13929421D0
	rhoarr(118)=        0.11992867D0
	rhoarr(119)=        0.10260993D0
	rhoarr(120)=        0.08728449D0
	rhoarr(121)=        0.07386402D0
	rhoarr(122)=        0.06223198D0
	rhoarr(123)=        0.05225075D0
	rhoarr(124)=        0.04376874D0
	rhoarr(125)=        0.03662710D0
	rhoarr(126)=        0.03066565D0
	rhoarr(127)=        0.02572797D0
	rhoarr(128)=        0.02166531D0
	rhoarr(129)=        0.01833957D0
	rhoarr(130)=        0.01562528D0
	rhoarr(131)=        0.01341075D0
	rhoarr(132)=        0.01159855D0
	rhoarr(133)=        0.01010547D0
	rhoarr(134)=        0.00886193D0
	rhoarr(135)=        0.00781118D0
	rhoarr(136)=        0.00690813D0
	rhoarr(137)=        0.00611803D0
	rhoarr(138)=        0.00541501D0
	rhoarr(139)=        0.00478056D0
	rhoarr(140)=        0.00420208D0
	rhoarr(141)=        0.00367149D0
	rhoarr(142)=        0.00318397D0
	rhoarr(143)=        0.00273693D0
	rhoarr(144)=        0.00232912D0
	rhoarr(145)=        0.00196001D0
	rhoarr(146)=        0.00162922D0
	rhoarr(147)=        0.00133624D0
	rhoarr(148)=        0.00108016D0
	rhoarr(149)=        0.00085958D0
	rhoarr(150)=        0.00067259D0
	rhoarr(151)=        0.00051678D0
	rhoarr(152)=        0.00038935D0
	rhoarr(153)=        0.00028718D0
	rhoarr(154)=        0.00020701D0
	rhoarr(155)=        0.00014554D0
	rhoarr(156)=        0.00009957D0
	rhoarr(157)=        0.00006613D0
	rhoarr(158)=        0.00004251D0
	rhoarr(159)=        0.00002636D0
	rhoarr(160)=        0.00001571D0
	rhoarr(161)=        0.00000896D0
	rhoarr(162)=        0.00000486D0
	rhoarr(163)=        0.00000250D0
	rhoarr(164)=        0.00000121D0
	rhoarr(165)=        0.00000055D0
	rhoarr(166)=        0.00000023D0
	rhoarr(167)=        0.00000009D0
	rhoarr(168)=        0.00000003D0

else if (iele==40) then  !Zr, 4d2 5s2, 0 3, HF/UGBS int=dkh2
	npt=  168
	rhoarr(  1)=   135292.95710876D0
	rhoarr(  2)=   121949.85249053D0
	rhoarr(  3)=    96514.37855185D0
	rhoarr(  4)=    81291.23609944D0
	rhoarr(  5)=    69389.34997016D0
	rhoarr(  6)=    60335.69610037D0
	rhoarr(  7)=    52616.26831644D0
	rhoarr(  8)=    46056.26654177D0
	rhoarr(  9)=    40271.76120721D0
	rhoarr( 10)=    35121.42969803D0
	rhoarr( 11)=    30520.97256663D0
	rhoarr( 12)=    26389.30664969D0
	rhoarr( 13)=    22682.16192818D0
	rhoarr( 14)=    19372.36468014D0
	rhoarr( 15)=    16434.67699318D0
	rhoarr( 16)=    13844.91534999D0
	rhoarr( 17)=    11580.63609312D0
	rhoarr( 18)=     9619.83408122D0
	rhoarr( 19)=     7939.48647451D0
	rhoarr( 20)=     6515.24449546D0
	rhoarr( 21)=     5321.80251777D0
	rhoarr( 22)=     4333.50602562D0
	rhoarr( 23)=     3524.99558321D0
	rhoarr( 24)=     2871.73203418D0
	rhoarr( 25)=     2350.42142401D0
	rhoarr( 26)=     1939.39521013D0
	rhoarr( 27)=     1618.91692042D0
	rhoarr( 28)=     1371.37815484D0
	rhoarr( 29)=     1181.39166615D0
	rhoarr( 30)=     1035.80032094D0
	rhoarr( 31)=      923.60878650D0
	rhoarr( 32)=      835.84623896D0
	rhoarr( 33)=      765.37960308D0
	rhoarr( 34)=      706.70006005D0
	rhoarr( 35)=      655.69938832D0
	rhoarr( 36)=      609.44613950D0
	rhoarr( 37)=      565.96921548D0
	rhoarr( 38)=      524.05603937D0
	rhoarr( 39)=      483.07128499D0
	rhoarr( 40)=      442.79960747D0
	rhoarr( 41)=      403.31319062D0
	rhoarr( 42)=      364.86316661D0
	rhoarr( 43)=      327.79316636D0
	rhoarr( 44)=      292.47300567D0
	rhoarr( 45)=      259.25038295D0
	rhoarr( 46)=      228.41827899D0
	rhoarr( 47)=      200.19554303D0
	rhoarr( 48)=      174.71804921D0
	rhoarr( 49)=      152.03790704D0
	rhoarr( 50)=      132.12850452D0
	rhoarr( 51)=      114.89355642D0
	rhoarr( 52)=      100.17870567D0
	rhoarr( 53)=       87.78450778D0
	rhoarr( 54)=       77.47981549D0
	rhoarr( 55)=       69.01472649D0
	rhoarr( 56)=       62.13241561D0
	rhoarr( 57)=       56.57936874D0
	rhoarr( 58)=       52.11375125D0
	rhoarr( 59)=       48.51184012D0
	rhoarr( 60)=       45.57259497D0
	rhoarr( 61)=       43.12052821D0
	rhoarr( 62)=       41.00707201D0
	rhoarr( 63)=       39.11065208D0
	rhoarr( 64)=       37.33568403D0
	rhoarr( 65)=       35.61071560D0
	rhoarr( 66)=       33.88594361D0
	rhoarr( 67)=       32.13033143D0
	rhoarr( 68)=       30.32853630D0
	rhoarr( 69)=       28.47782558D0
	rhoarr( 70)=       26.58512299D0
	rhoarr( 71)=       24.66428603D0
	rhoarr( 72)=       22.73368011D0
	rhoarr( 73)=       20.81408600D0
	rhoarr( 74)=       18.92695531D0
	rhoarr( 75)=       17.09301231D0
	rhoarr( 76)=       15.33118750D0
	rhoarr( 77)=       13.65785905D0
	rhoarr( 78)=       12.08637044D0
	rhoarr( 79)=       10.62678807D0
	rhoarr( 80)=        9.28585999D0
	rhoarr( 81)=        8.06713676D0
	rhoarr( 82)=        6.97121639D0
	rhoarr( 83)=        5.99607774D0
	rhoarr( 84)=        5.13746974D0
	rhoarr( 85)=        4.38932750D0
	rhoarr( 86)=        3.74419113D0
	rhoarr( 87)=        3.19360787D0
	rhoarr( 88)=        2.72850361D0
	rhoarr( 89)=        2.33951509D0
	rhoarr( 90)=        2.01727796D0
	rhoarr( 91)=        1.75266968D0
	rhoarr( 92)=        1.53700756D0
	rhoarr( 93)=        1.36220380D0
	rhoarr( 94)=        1.22087937D0
	rhoarr( 95)=        1.10643909D0
	rhoarr( 96)=        1.01311073D0
	rhoarr( 97)=        0.93595155D0
	rhoarr( 98)=        0.87082673D0
	rhoarr( 99)=        0.81436494D0
	rhoarr(100)=        0.76389667D0
	rhoarr(101)=        0.71738105D0
	rhoarr(102)=        0.67332618D0
	rhoarr(103)=        0.63070754D0
	rhoarr(104)=        0.58888760D0
	rhoarr(105)=        0.54753928D0
	rhoarr(106)=        0.50657489D0
	rhoarr(107)=        0.46608181D0
	rhoarr(108)=        0.42626579D0
	rhoarr(109)=        0.38740242D0
	rhoarr(110)=        0.34979707D0
	rhoarr(111)=        0.31375319D0
	rhoarr(112)=        0.27954858D0
	rhoarr(113)=        0.24741894D0
	rhoarr(114)=        0.21754759D0
	rhoarr(115)=        0.19006053D0
	rhoarr(116)=        0.16502549D0
	rhoarr(117)=        0.14245432D0
	rhoarr(118)=        0.12230762D0
	rhoarr(119)=        0.10450115D0
	rhoarr(120)=        0.08891339D0
	rhoarr(121)=        0.07539369D0
	rhoarr(122)=        0.06377061D0
	rhoarr(123)=        0.05386015D0
	rhoarr(124)=        0.04547323D0
	rhoarr(125)=        0.03842233D0
	rhoarr(126)=        0.03252702D0
	rhoarr(127)=        0.02761814D0
	rhoarr(128)=        0.02354081D0
	rhoarr(129)=        0.02015620D0
	rhoarr(130)=        0.01734230D0
	rhoarr(131)=        0.01499384D0
	rhoarr(132)=        0.01302164D0
	rhoarr(133)=        0.01135147D0
	rhoarr(134)=        0.00992273D0
	rhoarr(135)=        0.00868687D0
	rhoarr(136)=        0.00760585D0
	rhoarr(137)=        0.00665053D0
	rhoarr(138)=        0.00579914D0
	rhoarr(139)=        0.00503579D0
	rhoarr(140)=        0.00434915D0
	rhoarr(141)=        0.00373120D0
	rhoarr(142)=        0.00317626D0
	rhoarr(143)=        0.00268007D0
	rhoarr(144)=        0.00223926D0
	rhoarr(145)=        0.00185078D0
	rhoarr(146)=        0.00151168D0
	rhoarr(147)=        0.00121891D0
	rhoarr(148)=        0.00096919D0
	rhoarr(149)=        0.00075906D0
	rhoarr(150)=        0.00058483D0
	rhoarr(151)=        0.00044268D0
	rhoarr(152)=        0.00032872D0
	rhoarr(153)=        0.00023908D0
	rhoarr(154)=        0.00017001D0
	rhoarr(155)=        0.00011796D0
	rhoarr(156)=        0.00007968D0
	rhoarr(157)=        0.00005227D0
	rhoarr(158)=        0.00003321D0
	rhoarr(159)=        0.00002036D0
	rhoarr(160)=        0.00001200D0
	rhoarr(161)=        0.00000678D0
	rhoarr(162)=        0.00000365D0
	rhoarr(163)=        0.00000186D0
	rhoarr(164)=        0.00000089D0
	rhoarr(165)=        0.00000040D0
	rhoarr(166)=        0.00000017D0
	rhoarr(167)=        0.00000006D0
	rhoarr(168)=        0.00000002D0

else if (iele==41) then  !Nb, 4d4 5s1, 0 6, HF/UGBS int=dkh2
	npt=  167
	rhoarr(  1)=   161012.02297953D0
	rhoarr(  2)=   136065.20337407D0
	rhoarr(  3)=   106559.69531536D0
	rhoarr(  4)=    88946.19503679D0
	rhoarr(  5)=    76000.66223759D0
	rhoarr(  6)=    65618.13385246D0
	rhoarr(  7)=    57095.27807190D0
	rhoarr(  8)=    49753.87981183D0
	rhoarr(  9)=    43344.17999001D0
	rhoarr( 10)=    37668.72098274D0
	rhoarr( 11)=    32601.12092919D0
	rhoarr( 12)=    28073.58232852D0
	rhoarr( 13)=    24034.32003717D0
	rhoarr( 14)=    20442.54746824D0
	rhoarr( 15)=    17267.30459668D0
	rhoarr( 16)=    14481.88941602D0
	rhoarr( 17)=    12059.97247328D0
	rhoarr( 18)=     9974.39901332D0
	rhoarr( 19)=     8197.08225752D0
	rhoarr( 20)=     6699.27169583D0
	rhoarr( 21)=     5451.80321336D0
	rhoarr( 22)=     4425.47493349D0
	rhoarr( 23)=     3591.61587952D0
	rhoarr( 24)=     2922.66457237D0
	rhoarr( 25)=     2392.67850691D0
	rhoarr( 26)=     1977.76934986D0
	rhoarr( 27)=     1656.41781612D0
	rhoarr( 28)=     1409.64061653D0
	rhoarr( 29)=     1221.03516289D0
	rhoarr( 30)=     1076.73461309D0
	rhoarr( 31)=      965.28679719D0
	rhoarr( 32)=      877.46769474D0
	rhoarr( 33)=      806.04976874D0
	rhoarr( 34)=      745.54819187D0
	rhoarr( 35)=      691.96163097D0
	rhoarr( 36)=      642.51766345D0
	rhoarr( 37)=      595.43050805D0
	rhoarr( 38)=      549.67836619D0
	rhoarr( 39)=      504.80631162D0
	rhoarr( 40)=      460.75792788D0
	rhoarr( 41)=      417.73603113D0
	rhoarr( 42)=      376.09087278D0
	rhoarr( 43)=      336.23333289D0
	rhoarr( 44)=      298.57037655D0
	rhoarr( 45)=      263.45999628D0
	rhoarr( 46)=      231.18277753D0
	rhoarr( 47)=      201.92711150D0
	rhoarr( 48)=      175.78506354D0
	rhoarr( 49)=      152.75608987D0
	rhoarr( 50)=      132.75617664D0
	rhoarr( 51)=      115.63044956D0
	rhoarr( 52)=      101.16774130D0
	rhoarr( 53)=       89.11592783D0
	rhoarr( 54)=       79.19705805D0
	rhoarr( 55)=       71.12146425D0
	rhoarr( 56)=       64.60021728D0
	rhoarr( 57)=       59.35550316D0
	rhoarr( 58)=       55.12872963D0
	rhoarr( 59)=       51.68637689D0
	rhoarr( 60)=       48.82375518D0
	rhoarr( 61)=       46.36691312D0
	rhoarr( 62)=       44.17296899D0
	rhoarr( 63)=       42.12913956D0
	rhoarr( 64)=       40.15073542D0
	rhoarr( 65)=       38.17838753D0
	rhoarr( 66)=       36.17476382D0
	rhoarr( 67)=       34.12101951D0
	rhoarr( 68)=       32.01319784D0
	rhoarr( 69)=       29.85875819D0
	rhoarr( 70)=       27.67336362D0
	rhoarr( 71)=       25.47801527D0
	rhoarr( 72)=       23.29658244D0
	rhoarr( 73)=       21.15374737D0
	rhoarr( 74)=       19.07336111D0
	rhoarr( 75)=       17.07719168D0
	rhoarr( 76)=       15.18403414D0
	rhoarr( 77)=       13.40914458D0
	rhoarr( 78)=       11.76395520D0
	rhoarr( 79)=       10.25602499D0
	rhoarr( 80)=        8.88918098D0
	rhoarr( 81)=        7.66380594D0
	rhoarr( 82)=        6.57723182D0
	rhoarr( 83)=        5.62420086D0
	rhoarr( 84)=        4.79736093D0
	rhoarr( 85)=        4.08776555D0
	rhoarr( 86)=        3.48535492D0
	rhoarr( 87)=        2.97939976D0
	rhoarr( 88)=        2.55889585D0
	rhoarr( 89)=        2.21290290D0
	rhoarr( 90)=        1.93082582D0
	rhoarr( 91)=        1.70263965D0
	rhoarr( 92)=        1.51906133D0
	rhoarr( 93)=        1.37167227D0
	rhoarr( 94)=        1.25299565D0
	rhoarr( 95)=        1.15653273D0
	rhoarr( 96)=        1.07676257D0
	rhoarr( 97)=        1.00911020D0
	rhoarr( 98)=        0.94988901D0
	rhoarr( 99)=        0.89622361D0
	rhoarr(100)=        0.84595968D0
	rhoarr(101)=        0.79756682D0
	rhoarr(102)=        0.75003979D0
	rhoarr(103)=        0.70280219D0
	rhoarr(104)=        0.65561577D0
	rhoarr(105)=        0.60849734D0
	rhoarr(106)=        0.56164460D0
	rhoarr(107)=        0.51537163D0
	rhoarr(108)=        0.47005451D0
	rhoarr(109)=        0.42608706D0
	rhoarr(110)=        0.38384666D0
	rhoarr(111)=        0.34366941D0
	rhoarr(112)=        0.30583387D0
	rhoarr(113)=        0.27055213D0
	rhoarr(114)=        0.23796679D0
	rhoarr(115)=        0.20815259D0
	rhoarr(116)=        0.18112115D0
	rhoarr(117)=        0.15682798D0
	rhoarr(118)=        0.13518072D0
	rhoarr(119)=        0.11604794D0
	rhoarr(120)=        0.09926815D0
	rhoarr(121)=        0.08465856D0
	rhoarr(122)=        0.07202341D0
	rhoarr(123)=        0.06116149D0
	rhoarr(124)=        0.05187280D0
	rhoarr(125)=        0.04396416D0
	rhoarr(126)=        0.03725355D0
	rhoarr(127)=        0.03157330D0
	rhoarr(128)=        0.02677198D0
	rhoarr(129)=        0.02271533D0
	rhoarr(130)=        0.01928618D0
	rhoarr(131)=        0.01638368D0
	rhoarr(132)=        0.01392206D0
	rhoarr(133)=        0.01182908D0
	rhoarr(134)=        0.01004443D0
	rhoarr(135)=        0.00851813D0
	rhoarr(136)=        0.00720904D0
	rhoarr(137)=        0.00608354D0
	rhoarr(138)=        0.00511425D0
	rhoarr(139)=        0.00427897D0
	rhoarr(140)=        0.00355967D0
	rhoarr(141)=        0.00294156D0
	rhoarr(142)=        0.00241231D0
	rhoarr(143)=        0.00196143D0
	rhoarr(144)=        0.00157974D0
	rhoarr(145)=        0.00125906D0
	rhoarr(146)=        0.00099197D0
	rhoarr(147)=        0.00077169D0
	rhoarr(148)=        0.00059203D0
	rhoarr(149)=        0.00044733D0
	rhoarr(150)=        0.00033242D0
	rhoarr(151)=        0.00024259D0
	rhoarr(152)=        0.00017358D0
	rhoarr(153)=        0.00012156D0
	rhoarr(154)=        0.00008316D0
	rhoarr(155)=        0.00005544D0
	rhoarr(156)=        0.00003594D0
	rhoarr(157)=        0.00002258D0
	rhoarr(158)=        0.00001371D0
	rhoarr(159)=        0.00000801D0
	rhoarr(160)=        0.00000449D0
	rhoarr(161)=        0.00000240D0
	rhoarr(162)=        0.00000122D0
	rhoarr(163)=        0.00000059D0
	rhoarr(164)=        0.00000026D0
	rhoarr(165)=        0.00000011D0
	rhoarr(166)=        0.00000004D0
	rhoarr(167)=        0.00000002D0

else if (iele==42) then  !Mo, 4d5 5s1, 0 7, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=   179054.33677951D0
	rhoarr(  2)=   150756.12166872D0
	rhoarr(  3)=   117346.65480216D0
	rhoarr(  4)=    97478.46920595D0
	rhoarr(  5)=    82935.79617250D0
	rhoarr(  6)=    71317.52807436D0
	rhoarr(  7)=    61817.10830563D0
	rhoarr(  8)=    53664.65952994D0
	rhoarr(  9)=    46574.71102964D0
	rhoarr( 10)=    40321.86565449D0
	rhoarr( 11)=    34761.37457335D0
	rhoarr( 12)=    29814.43972084D0
	rhoarr( 13)=    25420.32552199D0
	rhoarr( 14)=    21530.71142126D0
	rhoarr( 15)=    18108.37666208D0
	rhoarr( 16)=    15121.00981884D0
	rhoarr( 17)=    12536.91752174D0
	rhoarr( 18)=    10323.74050126D0
	rhoarr( 19)=     8448.38564549D0
	rhoarr( 20)=     6877.36220932D0
	rhoarr( 21)=     5577.08369970D0
	rhoarr( 22)=     4514.29115227D0
	rhoarr( 23)=     3656.67108376D0
	rhoarr( 24)=     2973.47069151D0
	rhoarr( 25)=     2436.02568192D0
	rhoarr( 26)=     2018.19646621D0
	rhoarr( 27)=     1696.66578805D0
	rhoarr( 28)=     1451.07162157D0
	rhoarr( 29)=     1264.00624890D0
	rhoarr( 30)=     1120.91943926D0
	rhoarr( 31)=     1009.94297658D0
	rhoarr( 32)=      921.65008744D0
	rhoarr( 33)=      848.77268280D0
	rhoarr( 34)=      785.90147874D0
	rhoarr( 35)=      729.18684269D0
	rhoarr( 36)=      676.05088900D0
	rhoarr( 37)=      624.91848667D0
	rhoarr( 38)=      574.97416968D0
	rhoarr( 39)=      525.95038457D0
	rhoarr( 40)=      477.94961388D0
	rhoarr( 41)=      431.29992930D0
	rhoarr( 42)=      386.44151865D0
	rhoarr( 43)=      343.84086067D0
	rhoarr( 44)=      303.92906656D0
	rhoarr( 45)=      267.06097707D0
	rhoarr( 46)=      233.49163012D0
	rhoarr( 47)=      203.36668933D0
	rhoarr( 48)=      176.72348218D0
	rhoarr( 49)=      153.49955693D0
	rhoarr( 50)=      133.54613071D0
	rhoarr( 51)=      116.64435695D0
	rhoarr( 52)=      102.52284527D0
	rhoarr( 53)=       90.87523787D0
	rhoarr( 54)=       81.37689005D0
	rhoarr( 55)=       73.69988765D0
	rhoarr( 56)=       67.52582998D0
	rhoarr( 57)=       62.55603841D0
	rhoarr( 58)=       58.51909525D0
	rhoarr( 59)=       55.17583044D0
	rhoarr( 60)=       52.32201913D0
	rhoarr( 61)=       49.78912520D0
	rhoarr( 62)=       47.44344200D0
	rhoarr( 63)=       45.18396888D0
	rhoarr( 64)=       42.93934280D0
	rhoarr( 65)=       40.66412640D0
	rhoarr( 66)=       38.33473420D0
	rhoarr( 67)=       35.94525188D0
	rhoarr( 68)=       33.50336503D0
	rhoarr( 69)=       31.02656592D0
	rhoarr( 70)=       28.53875541D0
	rhoarr( 71)=       26.06730898D0
	rhoarr( 72)=       23.64063555D0
	rhoarr( 73)=       21.28622730D0
	rhoarr( 74)=       19.02917730D0
	rhoarr( 75)=       16.89112720D0
	rhoarr( 76)=       14.88959842D0
	rhoarr( 77)=       13.03765480D0
	rhoarr( 78)=       11.34384249D0
	rhoarr( 79)=        9.81235366D0
	rhoarr( 80)=        8.44336269D0
	rhoarr( 81)=        7.23348727D0
	rhoarr( 82)=        6.17633103D0
	rhoarr( 83)=        5.26306885D0
	rhoarr( 84)=        4.48304050D0
	rhoarr( 85)=        3.82432403D0
	rhoarr( 86)=        3.27426598D0
	rhoarr( 87)=        2.81995238D0
	rhoarr( 88)=        2.44861106D0
	rhoarr( 89)=        2.14794169D0
	rhoarr( 90)=        1.90637494D0
	rhoarr( 91)=        1.71326517D0
	rhoarr( 92)=        1.55902260D0
	rhoarr( 93)=        1.43519150D0
	rhoarr( 94)=        1.33448078D0
	rhoarr( 95)=        1.25075303D0
	rhoarr( 96)=        1.17897837D0
	rhoarr( 97)=        1.11515969D0
	rhoarr( 98)=        1.05623628D0
	rhoarr( 99)=        0.99997310D0
	rhoarr(100)=        0.94484269D0
	rhoarr(101)=        0.88990598D0
	rhoarr(102)=        0.83469710D0
	rhoarr(103)=        0.77911591D0
	rhoarr(104)=        0.72333081D0
	rhoarr(105)=        0.66769308D0
	rhoarr(106)=        0.61266356D0
	rhoarr(107)=        0.55875157D0
	rhoarr(108)=        0.50646616D0
	rhoarr(109)=        0.45627901D0
	rhoarr(110)=        0.40859831D0
	rhoarr(111)=        0.36375265D0
	rhoarr(112)=        0.32198344D0
	rhoarr(113)=        0.28344429D0
	rhoarr(114)=        0.24820565D0
	rhoarr(115)=        0.21626309D0
	rhoarr(116)=        0.18754764D0
	rhoarr(117)=        0.16193715D0
	rhoarr(118)=        0.13926770D0
	rhoarr(119)=        0.11934447D0
	rhoarr(120)=        0.10195179D0
	rhoarr(121)=        0.08686217D0
	rhoarr(122)=        0.07384416D0
	rhoarr(123)=        0.06266908D0
	rhoarr(124)=        0.05311661D0
	rhoarr(125)=        0.04497916D0
	rhoarr(126)=        0.03806510D0
	rhoarr(127)=        0.03220081D0
	rhoarr(128)=        0.02723170D0
	rhoarr(129)=        0.02302228D0
	rhoarr(130)=        0.01945534D0
	rhoarr(131)=        0.01643067D0
	rhoarr(132)=        0.01386334D0
	rhoarr(133)=        0.01168177D0
	rhoarr(134)=        0.00982594D0
	rhoarr(135)=        0.00824562D0
	rhoarr(136)=        0.00689891D0
	rhoarr(137)=        0.00575093D0
	rhoarr(138)=        0.00477266D0
	rhoarr(139)=        0.00394004D0
	rhoarr(140)=        0.00323298D0
	rhoarr(141)=        0.00263465D0
	rhoarr(142)=        0.00213073D0
	rhoarr(143)=        0.00170880D0
	rhoarr(144)=        0.00135798D0
	rhoarr(145)=        0.00106854D0
	rhoarr(146)=        0.00083177D0
	rhoarr(147)=        0.00063986D0
	rhoarr(148)=        0.00048587D0
	rhoarr(149)=        0.00036366D0
	rhoarr(150)=        0.00026786D0
	rhoarr(151)=        0.00019377D0
	rhoarr(152)=        0.00013735D0
	rhoarr(153)=        0.00009513D0
	rhoarr(154)=        0.00006416D0
	rhoarr(155)=        0.00004196D0
	rhoarr(156)=        0.00002648D0
	rhoarr(157)=        0.00001603D0
	rhoarr(158)=        0.00000924D0
	rhoarr(159)=        0.00000503D0
	rhoarr(160)=        0.00000257D0
	rhoarr(161)=        0.00000121D0
	rhoarr(162)=        0.00000052D0
	rhoarr(163)=        0.00000020D0
	rhoarr(164)=        0.00000007D0
	rhoarr(165)=        0.00000002D0

else if (iele==43) then  !Tc, 4d5 5s2, 0 6, HF/UGBS int=dkh2
	npt=  168
	rhoarr(  1)=   209936.13423322D0
	rhoarr(  2)=   164841.63809869D0
	rhoarr(  3)=   129622.89103554D0
	rhoarr(  4)=   106766.11542489D0
	rhoarr(  5)=    90280.88537757D0
	rhoarr(  6)=    77429.38356968D0
	rhoarr(  7)=    66806.31691929D0
	rhoarr(  8)=    57794.81799986D0
	rhoarr(  9)=    49966.42440577D0
	rhoarr( 10)=    43085.50786471D0
	rhoarr( 11)=    37002.76658193D0
	rhoarr( 12)=    31611.22587038D0
	rhoarr( 13)=    26839.70718877D0
	rhoarr( 14)=    22636.32307268D0
	rhoarr( 15)=    18957.04591704D0
	rhoarr( 16)=    15761.40477526D0
	rhoarr( 17)=    13010.87162956D0
	rhoarr( 18)=    10667.58031268D0
	rhoarr( 19)=     8693.35958989D0
	rhoarr( 20)=     7049.65449438D0
	rhoarr( 21)=     5697.93459582D0
	rhoarr( 22)=     4600.38003028D0
	rhoarr( 23)=     3720.68216179D0
	rhoarr( 24)=     3024.70903729D0
	rhoarr( 25)=     2481.00115268D0
	rhoarr( 26)=     2061.15158526D0
	rhoarr( 27)=     1740.05003663D0
	rhoarr( 28)=     1495.96807298D0
	rhoarr( 29)=     1310.51243772D0
	rhoarr( 30)=     1168.47983362D0
	rhoarr( 31)=     1057.62826158D0
	rhoarr( 32)=      968.37976669D0
	rhoarr( 33)=      893.48121994D0
	rhoarr( 34)=      827.65224832D0
	rhoarr( 35)=      767.24106505D0
	rhoarr( 36)=      709.90009674D0
	rhoarr( 37)=      654.28917554D0
	rhoarr( 38)=      599.81257772D0
	rhoarr( 39)=      546.39422449D0
	rhoarr( 40)=      494.29233520D0
	rhoarr( 41)=      443.95186616D0
	rhoarr( 42)=      395.89117481D0
	rhoarr( 43)=      350.61864774D0
	rhoarr( 44)=      308.57506693D0
	rhoarr( 45)=      270.09772840D0
	rhoarr( 46)=      235.40247439D0
	rhoarr( 47)=      204.57984777D0
	rhoarr( 48)=      177.60168671D0
	rhoarr( 49)=      154.33479486D0
	rhoarr( 50)=      134.55885905D0
	rhoarr( 51)=      117.98642169D0
	rhoarr( 52)=      104.28329104D0
	rhoarr( 53)=       93.08819650D0
	rhoarr( 54)=       84.03077742D0
	rhoarr( 55)=       76.74720618D0
	rhoarr( 56)=       70.89296519D0
	rhoarr( 57)=       66.15254678D0
	rhoarr( 58)=       62.24610047D0
	rhoarr( 59)=       58.93326583D0
	rhoarr( 60)=       56.01456666D0
	rhoarr( 61)=       53.33079907D0
	rhoarr( 62)=       50.76084488D0
	rhoarr( 63)=       48.21831043D0
	rhoarr( 64)=       45.64735518D0
	rhoarr( 65)=       43.01804076D0
	rhoarr( 66)=       40.32149737D0
	rhoarr( 67)=       37.56516533D0
	rhoarr( 68)=       34.76832062D0
	rhoarr( 69)=       31.95803757D0
	rhoarr( 70)=       29.16568582D0
	rhoarr( 71)=       26.42400768D0
	rhoarr( 72)=       23.76478116D0
	rhoarr( 73)=       21.21704418D0
	rhoarr( 74)=       18.80583507D0
	rhoarr( 75)=       16.55139261D0
	rhoarr( 76)=       14.46875176D0
	rhoarr( 77)=       12.56766924D0
	rhoarr( 78)=       10.85281411D0
	rhoarr( 79)=        9.32416185D0
	rhoarr( 80)=        7.97753565D0
	rhoarr( 81)=        6.80524437D0
	rhoarr( 82)=        5.79677211D0
	rhoarr( 83)=        4.93948035D0
	rhoarr( 84)=        4.21928878D0
	rhoarr( 85)=        3.62130750D0
	rhoarr( 86)=        3.13039992D0
	rhoarr( 87)=        2.73166302D0
	rhoarr( 88)=        2.41081889D0
	rhoarr( 89)=        2.15451788D0
	rhoarr( 90)=        1.95055826D0
	rhoarr( 91)=        1.78803049D0
	rhoarr( 92)=        1.65739546D0
	rhoarr( 93)=        1.55050577D0
	rhoarr( 94)=        1.46057921D0
	rhoarr( 95)=        1.38213246D0
	rhoarr( 96)=        1.31088331D0
	rhoarr( 97)=        1.24362942D0
	rhoarr( 98)=        1.17811179D0
	rhoarr( 99)=        1.11287093D0
	rhoarr(100)=        1.04710282D0
	rhoarr(101)=        0.98052096D0
	rhoarr(102)=        0.91322883D0
	rhoarr(103)=        0.84560592D0
	rhoarr(104)=        0.77820884D0
	rhoarr(105)=        0.71168794D0
	rhoarr(106)=        0.64671937D0
	rhoarr(107)=        0.58395167D0
	rhoarr(108)=        0.52396625D0
	rhoarr(109)=        0.46725047D0
	rhoarr(110)=        0.41418218D0
	rhoarr(111)=        0.36502396D0
	rhoarr(112)=        0.31992554D0
	rhoarr(113)=        0.27893224D0
	rhoarr(114)=        0.24199752D0
	rhoarr(115)=        0.20899799D0
	rhoarr(116)=        0.17974908D0
	rhoarr(117)=        0.15402044D0
	rhoarr(118)=        0.13155016D0
	rhoarr(119)=        0.11205731D0
	rhoarr(120)=        0.09525268D0
	rhoarr(121)=        0.08084774D0
	rhoarr(122)=        0.06856188D0
	rhoarr(123)=        0.05812805D0
	rhoarr(124)=        0.04929709D0
	rhoarr(125)=        0.04184075D0
	rhoarr(126)=        0.03555354D0
	rhoarr(127)=        0.03025357D0
	rhoarr(128)=        0.02578238D0
	rhoarr(129)=        0.02200396D0
	rhoarr(130)=        0.01880312D0
	rhoarr(131)=        0.01608337D0
	rhoarr(132)=        0.01376461D0
	rhoarr(133)=        0.01178070D0
	rhoarr(134)=        0.01007730D0
	rhoarr(135)=        0.00860982D0
	rhoarr(136)=        0.00734176D0
	rhoarr(137)=        0.00624333D0
	rhoarr(138)=        0.00529023D0
	rhoarr(139)=        0.00446265D0
	rhoarr(140)=        0.00374442D0
	rhoarr(141)=        0.00312220D0
	rhoarr(142)=        0.00258484D0
	rhoarr(143)=        0.00212283D0
	rhoarr(144)=        0.00172782D0
	rhoarr(145)=        0.00139242D0
	rhoarr(146)=        0.00110990D0
	rhoarr(147)=        0.00087410D0
	rhoarr(148)=        0.00067935D0
	rhoarr(149)=        0.00052039D0
	rhoarr(150)=        0.00039236D0
	rhoarr(151)=        0.00029076D0
	rhoarr(152)=        0.00021144D0
	rhoarr(153)=        0.00015064D0
	rhoarr(154)=        0.00010494D0
	rhoarr(155)=        0.00007134D0
	rhoarr(156)=        0.00004722D0
	rhoarr(157)=        0.00003036D0
	rhoarr(158)=        0.00001890D0
	rhoarr(159)=        0.00001135D0
	rhoarr(160)=        0.00000656D0
	rhoarr(161)=        0.00000363D0
	rhoarr(162)=        0.00000191D0
	rhoarr(163)=        0.00000095D0
	rhoarr(164)=        0.00000045D0
	rhoarr(165)=        0.00000020D0
	rhoarr(166)=        0.00000008D0
	rhoarr(167)=        0.00000003D0
	rhoarr(168)=        0.00000001D0

else if (iele==44) then  !Ru, 4d7 5s1, 0 5, HF/UGBS int=dkh2
	npt=  166
	rhoarr(  1)=   220615.88056344D0
	rhoarr(  2)=   184281.64134256D0
	rhoarr(  3)=   141639.01842738D0
	rhoarr(  4)=   116513.55692230D0
	rhoarr(  5)=    98278.51824722D0
	rhoarr(  6)=    83823.27301485D0
	rhoarr(  7)=    72096.74477131D0
	rhoarr(  8)=    62110.66464445D0
	rhoarr(  9)=    53494.89655732D0
	rhoarr( 10)=    45957.32183042D0
	rhoarr( 11)=    39309.10328035D0
	rhoarr( 12)=    33444.76518033D0
	rhoarr( 13)=    28281.68836724D0
	rhoarr( 14)=    23753.05757788D0
	rhoarr( 15)=    19806.26571611D0
	rhoarr( 16)=    16395.28629948D0
	rhoarr( 17)=    13475.44891706D0
	rhoarr( 18)=    11001.96936184D0
	rhoarr( 19)=     8929.97741779D0
	rhoarr( 20)=     7215.00120178D0
	rhoarr( 21)=     5813.37065884D0
	rhoarr( 22)=     4682.72601647D0
	rhoarr( 23)=     3782.72018565D0
	rhoarr( 24)=     3075.68720300D0
	rhoarr( 25)=     2527.18098213D0
	rhoarr( 26)=     2106.38354030D0
	rhoarr( 27)=     1786.33601285D0
	rhoarr( 28)=     1543.97137577D0
	rhoarr( 29)=     1359.99219292D0
	rhoarr( 30)=     1218.64336676D0
	rhoarr( 31)=     1107.40534416D0
	rhoarr( 32)=     1016.62742001D0
	rhoarr( 33)=      939.12924649D0
	rhoarr( 34)=      869.79941535D0
	rhoarr( 35)=      805.21090082D0
	rhoarr( 36)=      743.26422817D0
	rhoarr( 37)=      682.86533016D0
	rhoarr( 38)=      623.64378748D0
	rhoarr( 39)=      565.71525419D0
	rhoarr( 40)=      509.48875172D0
	rhoarr( 41)=      455.51638041D0
	rhoarr( 42)=      404.38094861D0
	rhoarr( 43)=      356.61626812D0
	rhoarr( 44)=      312.65496808D0
	rhoarr( 45)=      272.79905926D0
	rhoarr( 46)=      237.20877851D0
	rhoarr( 47)=      205.90542451D0
	rhoarr( 48)=      178.78412213D0
	rhoarr( 49)=      155.63288455D0
	rhoarr( 50)=      136.15499087D0
	rhoarr( 51)=      119.99243203D0
	rhoarr( 52)=      106.74882864D0
	rhoarr( 53)=       96.01069545D0
	rhoarr( 54)=       87.36623367D0
	rhoarr( 55)=       80.42106033D0
	rhoarr( 56)=       74.81051337D0
	rhoarr( 57)=       70.20842945D0
	rhoarr( 58)=       66.33254998D0
	rhoarr( 59)=       62.94691965D0
	rhoarr( 60)=       59.86176660D0
	rhoarr( 61)=       56.93139229D0
	rhoarr( 62)=       54.05057719D0
	rhoarr( 63)=       51.14995762D0
	rhoarr( 64)=       48.19077454D0
	rhoarr( 65)=       45.15934496D0
	rhoarr( 66)=       42.06155846D0
	rhoarr( 67)=       38.91764984D0
	rhoarr( 68)=       35.75744009D0
	rhoarr( 69)=       32.61617657D0
	rhoarr( 70)=       29.53104281D0
	rhoarr( 71)=       26.53835685D0
	rhoarr( 72)=       23.67143658D0
	rhoarr( 73)=       20.95908233D0
	rhoarr( 74)=       18.42460898D0
	rhoarr( 75)=       16.08535079D0
	rhoarr( 76)=       13.95255859D0
	rhoarr( 77)=       12.03161054D0
	rhoarr( 78)=       10.32246226D0
	rhoarr( 79)=        8.82026927D0
	rhoarr( 80)=        7.51612210D0
	rhoarr( 81)=        6.39784274D0
	rhoarr( 82)=        5.45079761D0
	rhoarr( 83)=        4.65868918D0
	rhoarr( 84)=        4.00429457D0
	rhoarr( 85)=        3.47012626D0
	rhoarr( 86)=        3.03899767D0
	rhoarr( 87)=        2.69448435D0
	rhoarr( 88)=        2.42127900D0
	rhoarr( 89)=        2.20544510D0
	rhoarr( 90)=        2.03457865D0
	rhoarr( 91)=        1.89788973D0
	rhoarr( 92)=        1.78621655D0
	rhoarr( 93)=        1.69198383D0
	rhoarr( 94)=        1.60911672D0
	rhoarr( 95)=        1.53291999D0
	rhoarr( 96)=        1.45993211D0
	rhoarr( 97)=        1.38776331D0
	rhoarr( 98)=        1.31492628D0
	rhoarr( 99)=        1.24066775D0
	rhoarr(100)=        1.16480789D0
	rhoarr(101)=        1.08759290D0
	rhoarr(102)=        1.00956438D0
	rhoarr(103)=        0.93144739D0
	rhoarr(104)=        0.85405735D0
	rhoarr(105)=        0.77822526D0
	rhoarr(106)=        0.70473978D0
	rhoarr(107)=        0.63430481D0
	rhoarr(108)=        0.56751087D0
	rhoarr(109)=        0.50481872D0
	rhoarr(110)=        0.44655356D0
	rhoarr(111)=        0.39290809D0
	rhoarr(112)=        0.34395237D0
	rhoarr(113)=        0.29964856D0
	rhoarr(114)=        0.25986862D0
	rhoarr(115)=        0.22441307D0
	rhoarr(116)=        0.19302946D0
	rhoarr(117)=        0.16542929D0
	rhoarr(118)=        0.14130293D0
	rhoarr(119)=        0.12033192D0
	rhoarr(120)=        0.10219892D0
	rhoarr(121)=        0.08659528D0
	rhoarr(122)=        0.07322668D0
	rhoarr(123)=        0.06181709D0
	rhoarr(124)=        0.05211154D0
	rhoarr(125)=        0.04387777D0
	rhoarr(126)=        0.03690708D0
	rhoarr(127)=        0.03101442D0
	rhoarr(128)=        0.02603779D0
	rhoarr(129)=        0.02183712D0
	rhoarr(130)=        0.01829251D0
	rhoarr(131)=        0.01530218D0
	rhoarr(132)=        0.01278015D0
	rhoarr(133)=        0.01065399D0
	rhoarr(134)=        0.00886259D0
	rhoarr(135)=        0.00735433D0
	rhoarr(136)=        0.00608553D0
	rhoarr(137)=        0.00501917D0
	rhoarr(138)=        0.00412399D0
	rhoarr(139)=        0.00337362D0
	rhoarr(140)=        0.00274588D0
	rhoarr(141)=        0.00222210D0
	rhoarr(142)=        0.00178658D0
	rhoarr(143)=        0.00142598D0
	rhoarr(144)=        0.00112892D0
	rhoarr(145)=        0.00088563D0
	rhoarr(146)=        0.00068772D0
	rhoarr(147)=        0.00052796D0
	rhoarr(148)=        0.00040014D0
	rhoarr(149)=        0.00029894D0
	rhoarr(150)=        0.00021979D0
	rhoarr(151)=        0.00015876D0
	rhoarr(152)=        0.00011247D0
	rhoarr(153)=        0.00007799D0
	rhoarr(154)=        0.00005284D0
	rhoarr(155)=        0.00003489D0
	rhoarr(156)=        0.00002240D0
	rhoarr(157)=        0.00001395D0
	rhoarr(158)=        0.00000839D0
	rhoarr(159)=        0.00000487D0
	rhoarr(160)=        0.00000271D0
	rhoarr(161)=        0.00000144D0
	rhoarr(162)=        0.00000073D0
	rhoarr(163)=        0.00000035D0
	rhoarr(164)=        0.00000016D0
	rhoarr(165)=        0.00000006D0
	rhoarr(166)=        0.00000003D0

else if (iele==45) then  !Rh, 4d8 5s1, 0 4, HF/UGBS int=dkh2
	npt=  166
	rhoarr(  1)=   258484.76449475D0
	rhoarr(  2)=   200790.94929699D0
	rhoarr(  3)=   156008.72907658D0
	rhoarr(  4)=   127219.03186711D0
	rhoarr(  5)=   106631.18754680D0
	rhoarr(  6)=    90711.56230866D0
	rhoarr(  7)=    77654.44472836D0
	rhoarr(  8)=    66665.17549830D0
	rhoarr(  9)=    57193.75200836D0
	rhoarr( 10)=    48935.90972750D0
	rhoarr( 11)=    41696.67404579D0
	rhoarr( 12)=    35334.72884018D0
	rhoarr( 13)=    29754.01394624D0
	rhoarr( 14)=    24882.93617761D0
	rhoarr( 15)=    20660.06772804D0
	rhoarr( 16)=    17028.92432373D0
	rhoarr( 17)=    13936.15340227D0
	rhoarr( 18)=    11330.10059041D0
	rhoarr( 19)=     9159.70599624D0
	rhoarr( 20)=     7374.44157202D0
	rhoarr( 21)=     5924.82186997D0
	rhoarr( 22)=     4763.22081858D0
	rhoarr( 23)=     3844.78241195D0
	rhoarr( 24)=     3128.12974681D0
	rhoarr( 25)=     2575.83981379D0
	rhoarr( 26)=     2154.75847768D0
	rhoarr( 27)=     1836.14535718D0
	rhoarr( 28)=     1595.63365949D0
	rhoarr( 29)=     1413.04301372D0
	rhoarr( 30)=     1272.08859271D0
	rhoarr( 31)=     1160.00832796D0
	rhoarr( 32)=     1067.12866989D0
	rhoarr( 33)=      986.40087873D0
	rhoarr( 34)=      912.94110597D0
	rhoarr( 35)=      843.59714146D0
	rhoarr( 36)=      776.55392536D0
	rhoarr( 37)=      710.98445990D0
	rhoarr( 38)=      646.75052249D0
	rhoarr( 39)=      584.15527426D0
	rhoarr( 40)=      523.74670089D0
	rhoarr( 41)=      466.16783793D0
	rhoarr( 42)=      412.04791986D0
	rhoarr( 43)=      361.92811626D0
	rhoarr( 44)=      316.21589463D0
	rhoarr( 45)=      275.16265259D0
	rhoarr( 46)=      238.85970662D0
	rhoarr( 47)=      207.24798632D0
	rhoarr( 48)=      180.13706506D0
	rhoarr( 49)=      157.22965283D0
	rhoarr( 50)=      138.14841061D0
	rhoarr( 51)=      122.46277057D0
	rhoarr( 52)=      109.71417726D0
	rhoarr( 53)=       99.43869411D0
	rhoarr( 54)=       91.18626440D0
	rhoarr( 55)=       84.53616865D0
	rhoarr( 56)=       79.10846662D0
	rhoarr( 57)=       74.57147824D0
	rhoarr( 58)=       70.64561517D0
	rhoarr( 59)=       67.10407052D0
	rhoarr( 60)=       63.77097846D0
	rhoarr( 61)=       60.51766850D0
	rhoarr( 62)=       57.25759085D0
	rhoarr( 63)=       53.94041466D0
	rhoarr( 64)=       50.54572579D0
	rhoarr( 65)=       47.07668298D0
	rhoarr( 66)=       43.55392950D0
	rhoarr( 67)=       40.00999422D0
	rhoarr( 68)=       36.48435039D0
	rhoarr( 69)=       33.01923353D0
	rhoarr( 70)=       29.65625878D0
	rhoarr( 71)=       26.43382599D0
	rhoarr( 72)=       23.38526294D0
	rhoarr( 73)=       20.53763048D0
	rhoarr( 74)=       17.91109912D0
	rhoarr( 75)=       15.51880015D0
	rhoarr( 76)=       13.36705487D0
	rhoarr( 77)=       11.45589090D0
	rhoarr( 78)=        9.77976319D0
	rhoarr( 79)=        8.32840759D0
	rhoarr( 80)=        7.08776573D0
	rhoarr( 81)=        6.04092962D0
	rhoarr( 82)=        5.16906280D0
	rhoarr( 83)=        4.45226250D0
	rhoarr( 84)=        3.87033426D0
	rhoarr( 85)=        3.40345802D0
	rhoarr( 86)=        3.03273292D0
	rhoarr( 87)=        2.74059652D0
	rhoarr( 88)=        2.51112192D0
	rhoarr( 89)=        2.33020299D0
	rhoarr( 90)=        2.18564160D0
	rhoarr( 91)=        2.06715303D0
	rhoarr( 92)=        1.96630532D0
	rhoarr( 93)=        1.87640726D0
	rhoarr( 94)=        1.79235795D0
	rhoarr( 95)=        1.71046937D0
	rhoarr( 96)=        1.62827246D0
	rhoarr( 97)=        1.54431649D0
	rhoarr( 98)=        1.45797067D0
	rhoarr( 99)=        1.36923589D0
	rhoarr(100)=        1.27857280D0
	rhoarr(101)=        1.18675082D0
	rhoarr(102)=        1.09472002D0
	rhoarr(103)=        1.00350655D0
	rhoarr(104)=        0.91413016D0
	rhoarr(105)=        0.82754222D0
	rhoarr(106)=        0.74458137D0
	rhoarr(107)=        0.66594478D0
	rhoarr(108)=        0.59217253D0
	rhoarr(109)=        0.52364312D0
	rhoarr(110)=        0.46057826D0
	rhoarr(111)=        0.40305482D0
	rhoarr(112)=        0.35102224D0
	rhoarr(113)=        0.30432323D0
	rhoarr(114)=        0.26271603D0
	rhoarr(115)=        0.22589653D0
	rhoarr(116)=        0.19351887D0
	rhoarr(117)=        0.16521367D0
	rhoarr(118)=        0.14060319D0
	rhoarr(119)=        0.11931332D0
	rhoarr(120)=        0.10098257D0
	rhoarr(121)=        0.08526828D0
	rhoarr(122)=        0.07185068D0
	rhoarr(123)=        0.06043527D0
	rhoarr(124)=        0.05075389D0
	rhoarr(125)=        0.04256507D0
	rhoarr(126)=        0.03565370D0
	rhoarr(127)=        0.02983022D0
	rhoarr(128)=        0.02492941D0
	rhoarr(129)=        0.02080877D0
	rhoarr(130)=        0.01734655D0
	rhoarr(131)=        0.01443944D0
	rhoarr(132)=        0.01200021D0
	rhoarr(133)=        0.00995529D0
	rhoarr(134)=        0.00824260D0
	rhoarr(135)=        0.00680962D0
	rhoarr(136)=        0.00561189D0
	rhoarr(137)=        0.00461176D0
	rhoarr(138)=        0.00377745D0
	rhoarr(139)=        0.00308223D0
	rhoarr(140)=        0.00250377D0
	rhoarr(141)=        0.00202341D0
	rhoarr(142)=        0.00162558D0
	rhoarr(143)=        0.00129723D0
	rhoarr(144)=        0.00102738D0
	rhoarr(145)=        0.00080672D0
	rhoarr(146)=        0.00062734D0
	rhoarr(147)=        0.00048252D0
	rhoarr(148)=        0.00036657D0
	rhoarr(149)=        0.00027463D0
	rhoarr(150)=        0.00020257D0
	rhoarr(151)=        0.00014686D0
	rhoarr(152)=        0.00010445D0
	rhoarr(153)=        0.00007274D0
	rhoarr(154)=        0.00004950D0
	rhoarr(155)=        0.00003283D0
	rhoarr(156)=        0.00002118D0
	rhoarr(157)=        0.00001324D0
	rhoarr(158)=        0.00000800D0
	rhoarr(159)=        0.00000466D0
	rhoarr(160)=        0.00000260D0
	rhoarr(161)=        0.00000139D0
	rhoarr(162)=        0.00000070D0
	rhoarr(163)=        0.00000033D0
	rhoarr(164)=        0.00000015D0
	rhoarr(165)=        0.00000006D0
	rhoarr(166)=        0.00000002D0

else if (iele==46) then  !Pd, 4d10, 0 1, HF/UGBS int=dkh2
	npt=  161
	rhoarr(  1)=   286151.41042579D0
	rhoarr(  2)=   221134.90627135D0
	rhoarr(  3)=   170783.93094537D0
	rhoarr(  4)=   138567.60565015D0
	rhoarr(  5)=   115627.97526434D0
	rhoarr(  6)=    97960.91359304D0
	rhoarr(  7)=    83526.35968640D0
	rhoarr(  8)=    71427.67773289D0
	rhoarr(  9)=    61043.85376052D0
	rhoarr( 10)=    52026.59897804D0
	rhoarr( 11)=    44153.03020130D0
	rhoarr( 12)=    37263.91730998D0
	rhoarr( 13)=    31248.96218641D0
	rhoarr( 14)=    26023.24731532D0
	rhoarr( 15)=    21514.12368937D0
	rhoarr( 16)=    17656.08033654D0
	rhoarr( 17)=    14387.64635360D0
	rhoarr( 18)=    11649.16269470D0
	rhoarr( 19)=     9381.81681672D0
	rhoarr( 20)=     7528.02489817D0
	rhoarr( 21)=     6032.15818440D0
	rhoarr( 22)=     4841.32280838D0
	rhoarr( 23)=     3906.16001430D0
	rhoarr( 24)=     3181.48231070D0
	rhoarr( 25)=     2626.72748704D0
	rhoarr( 26)=     2206.26853216D0
	rhoarr( 27)=     1889.52968745D0
	rhoarr( 28)=     1650.87995978D0
	rhoarr( 29)=     1469.35255412D0
	rhoarr( 30)=     1328.25169214D0
	rhoarr( 31)=     1214.68299554D0
	rhoarr( 32)=     1119.03556565D0
	rhoarr( 33)=     1034.45002127D0
	rhoarr( 34)=      956.30480791D0
	rhoarr( 35)=      881.74142045D0
	rhoarr( 36)=      809.23840759D0
	rhoarr( 37)=      738.23911411D0
	rhoarr( 38)=      668.83644204D0
	rhoarr( 39)=      601.51591011D0
	rhoarr( 40)=      536.95515326D0
	rhoarr( 41)=      475.87486674D0
	rhoarr( 42)=      418.93422760D0
	rhoarr( 43)=      366.66331004D0
	rhoarr( 44)=      319.42548937D0
	rhoarr( 45)=      277.40361673D0
	rhoarr( 46)=      240.60438677D0
	rhoarr( 47)=      208.87575188D0
	rhoarr( 48)=      181.93266460D0
	rhoarr( 49)=      159.38706351D0
	rhoarr( 50)=      140.77887982D0
	rhoarr( 51)=      125.60577674D0
	rhoarr( 52)=      113.35014082D0
	rhoarr( 53)=      103.50241640D0
	rhoarr( 54)=       95.58023791D0
	rhoarr( 55)=       89.14307288D0
	rhoarr( 56)=       83.80233531D0
	rhoarr( 57)=       79.22719144D0
	rhoarr( 58)=       75.14652653D0
	rhoarr( 59)=       71.34772013D0
	rhoarr( 60)=       67.67295610D0
	rhoarr( 61)=       64.01377998D0
	rhoarr( 62)=       60.30454044D0
	rhoarr( 63)=       56.51525281D0
	rhoarr( 64)=       52.64432639D0
	rhoarr( 65)=       48.71151271D0
	rhoarr( 66)=       44.75135615D0
	rhoarr( 67)=       40.80735526D0
	rhoarr( 68)=       36.92697081D0
	rhoarr( 69)=       33.15754725D0
	rhoarr( 70)=       29.54315235D0
	rhoarr( 71)=       26.12229024D0
	rhoarr( 72)=       22.92640747D0
	rhoarr( 73)=       19.97908889D0
	rhoarr( 74)=       17.29582937D0
	rhoarr( 75)=       14.88426505D0
	rhoarr( 76)=       12.74475270D0
	rhoarr( 77)=       10.87119578D0
	rhoarr( 78)=        9.25202850D0
	rhoarr( 79)=        7.87128338D0
	rhoarr( 80)=        6.70968145D0
	rhoarr( 81)=        5.74569547D0
	rhoarr( 82)=        4.95654678D0
	rhoarr( 83)=        4.31910398D0
	rhoarr( 84)=        3.81065974D0
	rhoarr( 85)=        3.40956978D0
	rhoarr( 86)=        3.09574708D0
	rhoarr( 87)=        2.85101280D0
	rhoarr( 88)=        2.65931370D0
	rhoarr( 89)=        2.50682146D0
	rhoarr( 90)=        2.38193318D0
	rhoarr( 91)=        2.27519288D0
	rhoarr( 92)=        2.17915281D0
	rhoarr( 93)=        2.08819148D0
	rhoarr( 94)=        1.99830232D0
	rhoarr( 95)=        1.90686560D0
	rhoarr( 96)=        1.81241423D0
	rhoarr( 97)=        1.71440318D0
	rhoarr( 98)=        1.61299129D0
	rhoarr( 99)=        1.50884239D0
	rhoarr(100)=        1.40295114D0
	rhoarr(101)=        1.29649644D0
	rhoarr(102)=        1.19072306D0
	rhoarr(103)=        1.08685031D0
	rhoarr(104)=        0.98600509D0
	rhoarr(105)=        0.88917578D0
	rhoarr(106)=        0.79718377D0
	rhoarr(107)=        0.71066908D0
	rhoarr(108)=        0.63008750D0
	rhoarr(109)=        0.55571684D0
	rhoarr(110)=        0.48767036D0
	rhoarr(111)=        0.42591541D0
	rhoarr(112)=        0.37029578D0
	rhoarr(113)=        0.32055581D0
	rhoarr(114)=        0.27636491D0
	rhoarr(115)=        0.23734091D0
	rhoarr(116)=        0.20307123D0
	rhoarr(117)=        0.17313094D0
	rhoarr(118)=        0.14709742D0
	rhoarr(119)=        0.12456135D0
	rhoarr(120)=        0.10513441D0
	rhoarr(121)=        0.08845411D0
	rhoarr(122)=        0.07418625D0
	rhoarr(123)=        0.06202584D0
	rhoarr(124)=        0.05169681D0
	rhoarr(125)=        0.04295130D0
	rhoarr(126)=        0.03556845D0
	rhoarr(127)=        0.02935313D0
	rhoarr(128)=        0.02413444D0
	rhoarr(129)=        0.01976402D0
	rhoarr(130)=        0.01611409D0
	rhoarr(131)=        0.01307526D0
	rhoarr(132)=        0.01055418D0
	rhoarr(133)=        0.00847124D0
	rhoarr(134)=        0.00675838D0
	rhoarr(135)=        0.00535718D0
	rhoarr(136)=        0.00421745D0
	rhoarr(137)=        0.00329596D0
	rhoarr(138)=        0.00255565D0
	rhoarr(139)=        0.00196491D0
	rhoarr(140)=        0.00149695D0
	rhoarr(141)=        0.00112921D0
	rhoarr(142)=        0.00084277D0
	rhoarr(143)=        0.00062183D0
	rhoarr(144)=        0.00045323D0
	rhoarr(145)=        0.00032601D0
	rhoarr(146)=        0.00023114D0
	rhoarr(147)=        0.00016129D0
	rhoarr(148)=        0.00011052D0
	rhoarr(149)=        0.00007417D0
	rhoarr(150)=        0.00004859D0
	rhoarr(151)=        0.00003096D0
	rhoarr(152)=        0.00001910D0
	rhoarr(153)=        0.00001135D0
	rhoarr(154)=        0.00000646D0
	rhoarr(155)=        0.00000350D0
	rhoarr(156)=        0.00000179D0
	rhoarr(157)=        0.00000085D0
	rhoarr(158)=        0.00000037D0
	rhoarr(159)=        0.00000015D0
	rhoarr(160)=        0.00000005D0
	rhoarr(161)=        0.00000001D0

else if (iele==47) then  !Ag, 4d10 5s1, 0 2, HF/UGBS int=dkh2
	npt=  166
	rhoarr(  1)=   298686.30176964D0
	rhoarr(  2)=   246499.30430163D0
	rhoarr(  3)=   185831.75316012D0
	rhoarr(  4)=   150601.31042794D0
	rhoarr(  5)=   125365.90542575D0
	rhoarr(  6)=   105600.70206164D0
	rhoarr(  7)=    89763.36346171D0
	rhoarr(  8)=    76431.52420799D0
	rhoarr(  9)=    65065.71796048D0
	rhoarr( 10)=    55244.82568635D0
	rhoarr( 11)=    46692.42724952D0
	rhoarr( 12)=    39245.42378438D0
	rhoarr( 13)=    32775.29252529D0
	rhoarr( 14)=    27178.74707689D0
	rhoarr( 15)=    22372.33666154D0
	rhoarr( 16)=    18281.41150170D0
	rhoarr( 17)=    14834.52824782D0
	rhoarr( 18)=    11962.46326048D0
	rhoarr( 19)=     9598.14915056D0
	rhoarr( 20)=     7676.87100762D0
	rhoarr( 21)=     6136.59331953D0
	rhoarr( 22)=     4918.65269655D0
	rhoarr( 23)=     3968.69944459D0
	rhoarr( 24)=     3237.45655808D0
	rhoarr( 25)=     2681.17155228D0
	rhoarr( 26)=     2261.82734658D0
	rhoarr( 27)=     1947.12541707D0
	rhoarr( 28)=     1710.25535257D0
	rhoarr( 29)=     1529.51281130D0
	rhoarr( 30)=     1387.82213559D0
	rhoarr( 31)=     1272.19017795D0
	rhoarr( 32)=     1173.11446194D0
	rhoarr( 33)=     1083.98092776D0
	rhoarr( 34)=     1000.48757737D0
	rhoarr( 35)=      920.11840682D0
	rhoarr( 36)=      841.67928060D0
	rhoarr( 37)=      764.90036421D0
	rhoarr( 38)=      690.10660212D0
	rhoarr( 39)=      617.95511389D0
	rhoarr( 40)=      549.23524706D0
	rhoarr( 41)=      484.72420912D0
	rhoarr( 42)=      425.08966377D0
	rhoarr( 43)=      370.83060441D0
	rhoarr( 44)=      322.24868278D0
	rhoarr( 45)=      279.44323735D0
	rhoarr( 46)=      242.32406387D0
	rhoarr( 47)=      210.63647427D0
	rhoarr( 48)=      183.99366366D0
	rhoarr( 49)=      161.91210192D0
	rhoarr( 50)=      143.84662021D0
	rhoarr( 51)=      129.22289897D0
	rhoarr( 52)=      117.46595953D0
	rhoarr( 53)=      108.02389608D0
	rhoarr( 54)=      100.38648572D0
	rhoarr( 55)=       94.09859145D0
	rhoarr( 56)=       88.76852525D0
	rhoarr( 57)=       84.07179480D0
	rhoarr( 58)=       79.75088551D0
	rhoarr( 59)=       75.61187955D0
	rhoarr( 60)=       71.51875760D0
	rhoarr( 61)=       67.38617852D0
	rhoarr( 62)=       63.17142362D0
	rhoarr( 63)=       58.86606537D0
	rhoarr( 64)=       54.48780291D0
	rhoarr( 65)=       50.07280522D0
	rhoarr( 66)=       45.66881584D0
	rhoarr( 67)=       41.32919210D0
	rhoarr( 68)=       37.10797591D0
	rhoarr( 69)=       33.05602322D0
	rhoarr( 70)=       29.21815900D0
	rhoarr( 71)=       25.63127880D0
	rhoarr( 72)=       22.32328523D0
	rhoarr( 73)=       19.31272973D0
	rhoarr( 74)=       16.60902242D0
	rhoarr( 75)=       14.21307508D0
	rhoarr( 76)=       12.11825172D0
	rhoarr( 77)=       10.31151550D0
	rhoarr( 78)=        8.77467812D0
	rhoarr( 79)=        7.48567586D0
	rhoarr( 80)=        6.41981244D0
	rhoarr( 81)=        5.55092286D0
	rhoarr( 82)=        4.85242313D0
	rhoarr( 83)=        4.29821967D0
	rhoarr( 84)=        3.86346072D0
	rhoarr( 85)=        3.52512039D0
	rhoarr( 86)=        3.26241522D0
	rhoarr( 87)=        3.05706209D0
	rhoarr( 88)=        2.89339386D0
	rhoarr( 89)=        2.75835446D0
	rhoarr( 90)=        2.64139785D0
	rhoarr( 91)=        2.53431451D0
	rhoarr( 92)=        2.43100734D0
	rhoarr( 93)=        2.32723526D0
	rhoarr( 94)=        2.22033984D0
	rhoarr( 95)=        2.10896754D0
	rhoarr( 96)=        1.99279828D0
	rhoarr( 97)=        1.87228960D0
	rhoarr( 98)=        1.74844420D0
	rhoarr( 99)=        1.62260665D0
	rhoarr(100)=        1.49629313D0
	rhoarr(101)=        1.37105534D0
	rhoarr(102)=        1.24837737D0
	rhoarr(103)=        1.12960271D0
	rhoarr(104)=        1.01588685D0
	rhoarr(105)=        0.90817098D0
	rhoarr(106)=        0.80717218D0
	rhoarr(107)=        0.71338604D0
	rhoarr(108)=        0.62709851D0
	rhoarr(109)=        0.54840448D0
	rhoarr(110)=        0.47723101D0
	rhoarr(111)=        0.41336357D0
	rhoarr(112)=        0.35647378D0
	rhoarr(113)=        0.30614732D0
	rhoarr(114)=        0.26191067D0
	rhoarr(115)=        0.22325567D0
	rhoarr(116)=        0.18966094D0
	rhoarr(117)=        0.16060957D0
	rhoarr(118)=        0.13560283D0
	rhoarr(119)=        0.11416993D0
	rhoarr(120)=        0.09587415D0
	rhoarr(121)=        0.08031593D0
	rhoarr(122)=        0.06713363D0
	rhoarr(123)=        0.05600269D0
	rhoarr(124)=        0.04663385D0
	rhoarr(125)=        0.03877100D0
	rhoarr(126)=        0.03218884D0
	rhoarr(127)=        0.02669071D0
	rhoarr(128)=        0.02210629D0
	rhoarr(129)=        0.01828935D0
	rhoarr(130)=        0.01511537D0
	rhoarr(131)=        0.01247904D0
	rhoarr(132)=        0.01029168D0
	rhoarr(133)=        0.00847879D0
	rhoarr(134)=        0.00697779D0
	rhoarr(135)=        0.00573603D0
	rhoarr(136)=        0.00470929D0
	rhoarr(137)=        0.00386043D0
	rhoarr(138)=        0.00315850D0
	rhoarr(139)=        0.00257782D0
	rhoarr(140)=        0.00209727D0
	rhoarr(141)=        0.00169960D0
	rhoarr(142)=        0.00137071D0
	rhoarr(143)=        0.00109911D0
	rhoarr(144)=        0.00087533D0
	rhoarr(145)=        0.00069157D0
	rhoarr(146)=        0.00054135D0
	rhoarr(147)=        0.00041926D0
	rhoarr(148)=        0.00032076D0
	rhoarr(149)=        0.00024202D0
	rhoarr(150)=        0.00017977D0
	rhoarr(151)=        0.00013122D0
	rhoarr(152)=        0.00009395D0
	rhoarr(153)=        0.00006584D0
	rhoarr(154)=        0.00004506D0
	rhoarr(155)=        0.00003005D0
	rhoarr(156)=        0.00001948D0
	rhoarr(157)=        0.00001223D0
	rhoarr(158)=        0.00000742D0
	rhoarr(159)=        0.00000433D0
	rhoarr(160)=        0.00000242D0
	rhoarr(161)=        0.00000129D0
	rhoarr(162)=        0.00000066D0
	rhoarr(163)=        0.00000031D0
	rhoarr(164)=        0.00000014D0
	rhoarr(165)=        0.00000006D0
	rhoarr(166)=        0.00000002D0

else if (iele==48) then  !Cd, 4d10 5s2, 0 1, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=   349383.77432727D0
	rhoarr(  2)=   267329.07342394D0
	rhoarr(  3)=   203975.27280017D0
	rhoarr(  4)=   163819.63063297D0
	rhoarr(  5)=   135473.08030381D0
	rhoarr(  6)=   113824.53181492D0
	rhoarr(  7)=    96280.15552810D0
	rhoarr(  8)=    81690.98685891D0
	rhoarr(  9)=    69267.76945983D0
	rhoarr( 10)=    58569.61425478D0
	rhoarr( 11)=    49309.69757217D0
	rhoarr( 12)=    41277.34034956D0
	rhoarr( 13)=    34325.63456221D0
	rhoarr( 14)=    28342.53102082D0
	rhoarr( 15)=    23231.10755214D0
	rhoarr( 16)=    18902.61066388D0
	rhoarr( 17)=    15274.30109301D0
	rhoarr( 18)=    12267.75153957D0
	rhoarr( 19)=     9807.45663176D0
	rhoarr( 20)=     7820.72611216D0
	rhoarr( 21)=     6238.29803875D0
	rhoarr( 22)=     4995.30274351D0
	rhoarr( 23)=     4032.27382142D0
	rhoarr( 24)=     3295.83211878D0
	rhoarr( 25)=     2739.01932917D0
	rhoarr( 26)=     2321.39896553D0
	rhoarr( 27)=     2008.94021000D0
	rhoarr( 28)=     1773.68806296D0
	rhoarr( 29)=     1593.27801431D0
	rhoarr( 30)=     1450.35454801D0
	rhoarr( 31)=     1331.92536894D0
	rhoarr( 32)=     1228.67957080D0
	rhoarr( 33)=     1134.30867258D0
	rhoarr( 34)=     1044.86857409D0
	rhoarr( 35)=      958.20674148D0
	rhoarr( 36)=      873.46494689D0
	rhoarr( 37)=      790.66022353D0
	rhoarr( 38)=      710.34342812D0
	rhoarr( 39)=      633.33230816D0
	rhoarr( 40)=      560.51302109D0
	rhoarr( 41)=      492.70139851D0
	rhoarr( 42)=      430.55387961D0
	rhoarr( 43)=      374.51818624D0
	rhoarr( 44)=      324.81494328D0
	rhoarr( 45)=      281.44277102D0
	rhoarr( 46)=      244.20037258D0
	rhoarr( 47)=      212.71978302D0
	rhoarr( 48)=      186.50553339D0
	rhoarr( 49)=      164.97529629D0
	rhoarr( 50)=      147.49865500D0
	rhoarr( 51)=      133.43178601D0
	rhoarr( 52)=      122.14682192D0
	rhoarr( 53)=      113.05534406D0
	rhoarr( 54)=      105.62587392D0
	rhoarr( 55)=       99.39551243D0
	rhoarr( 56)=       93.97611918D0
	rhoarr( 57)=       89.05566306D0
	rhoarr( 58)=       84.39557752D0
	rhoarr( 59)=       79.82506923D0
	rhoarr( 60)=       75.23333457D0
	rhoarr( 61)=       70.56054990D0
	rhoarr( 62)=       65.78835962D0
	rhoarr( 63)=       60.93043180D0
	rhoarr( 64)=       56.02351252D0
	rhoarr( 65)=       51.11929339D0
	rhoarr( 66)=       46.27730865D0
	rhoarr( 67)=       41.55899176D0
	rhoarr( 68)=       37.02294273D0
	rhoarr( 69)=       32.72138874D0
	rhoarr( 70)=       28.69776388D0
	rhoarr( 71)=       24.98529194D0
	rhoarr( 72)=       21.60642889D0
	rhoarr( 73)=       18.57300801D0
	rhoarr( 74)=       15.88692771D0
	rhoarr( 75)=       13.54122964D0
	rhoarr( 76)=       11.52142846D0
	rhoarr( 77)=        9.80697452D0
	rhoarr( 78)=        8.37275248D0
	rhoarr( 79)=        7.19054082D0
	rhoarr( 80)=        6.23037612D0
	rhoarr( 81)=        5.46178183D0
	rhoarr( 82)=        4.85483291D0
	rhoarr( 83)=        4.38103761D0
	rhoarr( 84)=        4.01402614D0
	rhoarr( 85)=        3.73004514D0
	rhoarr( 86)=        3.50826584D0
	rhoarr( 87)=        3.33092270D0
	rhoarr( 88)=        3.18330645D0
	rhoarr( 89)=        3.05363944D0
	rhoarr( 90)=        2.93286290D0
	rhoarr( 91)=        2.81436330D0
	rhoarr( 92)=        2.69366190D0
	rhoarr( 93)=        2.56808692D0
	rhoarr( 94)=        2.43644384D0
	rhoarr( 95)=        2.29869602D0
	rhoarr( 96)=        2.15566553D0
	rhoarr( 97)=        2.00876223D0
	rhoarr( 98)=        1.85974737D0
	rhoarr( 99)=        1.71053585D0
	rhoarr(100)=        1.56303896D0
	rhoarr(101)=        1.41904676D0
	rhoarr(102)=        1.28014700D0
	rhoarr(103)=        1.14767562D0
	rhoarr(104)=        1.02269321D0
	rhoarr(105)=        0.90598125D0
	rhoarr(106)=        0.79805270D0
	rhoarr(107)=        0.69917255D0
	rhoarr(108)=        0.60938443D0
	rhoarr(109)=        0.52854108D0
	rhoarr(110)=        0.45633647D0
	rhoarr(111)=        0.39233838D0
	rhoarr(112)=        0.33602028D0
	rhoarr(113)=        0.28679154D0
	rhoarr(114)=        0.24402514D0
	rhoarr(115)=        0.20708205D0
	rhoarr(116)=        0.17533187D0
	rhoarr(117)=        0.14816912D0
	rhoarr(118)=        0.12502521D0
	rhoarr(119)=        0.10537624D0
	rhoarr(120)=        0.08874706D0
	rhoarr(121)=        0.07471223D0
	rhoarr(122)=        0.06289467D0
	rhoarr(123)=        0.05296285D0
	rhoarr(124)=        0.04462725D0
	rhoarr(125)=        0.03763658D0
	rhoarr(126)=        0.03177411D0
	rhoarr(127)=        0.02685430D0
	rhoarr(128)=        0.02271961D0
	rhoarr(129)=        0.01923749D0
	rhoarr(130)=        0.01629741D0
	rhoarr(131)=        0.01380794D0
	rhoarr(132)=        0.01169387D0
	rhoarr(133)=        0.00989359D0
	rhoarr(134)=        0.00835663D0
	rhoarr(135)=        0.00704164D0
	rhoarr(136)=        0.00591469D0
	rhoarr(137)=        0.00494795D0
	rhoarr(138)=        0.00411856D0
	rhoarr(139)=        0.00340770D0
	rhoarr(140)=        0.00279985D0
	rhoarr(141)=        0.00228206D0
	rhoarr(142)=        0.00184330D0
	rhoarr(143)=        0.00147405D0
	rhoarr(144)=        0.00116582D0
	rhoarr(145)=        0.00091097D0
	rhoarr(146)=        0.00070251D0
	rhoarr(147)=        0.00053402D0
	rhoarr(148)=        0.00039962D0
	rhoarr(149)=        0.00029395D0
	rhoarr(150)=        0.00021218D0
	rhoarr(151)=        0.00015000D0
	rhoarr(152)=        0.00010363D0
	rhoarr(153)=        0.00006977D0
	rhoarr(154)=        0.00004563D0
	rhoarr(155)=        0.00002889D0
	rhoarr(156)=        0.00001763D0
	rhoarr(157)=        0.00001032D0
	rhoarr(158)=        0.00000576D0
	rhoarr(159)=        0.00000304D0
	rhoarr(160)=        0.00000151D0
	rhoarr(161)=        0.00000069D0
	rhoarr(162)=        0.00000029D0
	rhoarr(163)=        0.00000011D0
	rhoarr(164)=        0.00000004D0
	rhoarr(165)=        0.00000001D0
	
else if (iele==49) then  !In, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=  168
	rhoarr(  1)=   414057.13308123D0
	rhoarr(  2)=   295963.18148631D0
	rhoarr(  3)=   222932.19256536D0
	rhoarr(  4)=   177883.78102964D0
	rhoarr(  5)=   146457.38613643D0
	rhoarr(  6)=   122448.60658505D0
	rhoarr(  7)=   103198.40622058D0
	rhoarr(  8)=    87153.30532718D0
	rhoarr(  9)=    73651.24433029D0
	rhoarr( 10)=    62009.17570552D0
	rhoarr( 11)=    51982.99430820D0
	rhoarr( 12)=    43348.48463225D0
	rhoarr( 13)=    35895.48161413D0
	rhoarr( 14)=    29506.77087878D0
	rhoarr( 15)=    24083.73750872D0
	rhoarr( 16)=    19515.70141432D0
	rhoarr( 17)=    15702.98360619D0
	rhoarr( 18)=    12560.99715401D0
	rhoarr( 19)=    10007.64460495D0
	rhoarr( 20)=     7959.57795517D0
	rhoarr( 21)=     6337.65117142D0
	rhoarr( 22)=     5070.88410500D0
	rhoarr( 23)=     4096.00997440D0
	rhoarr( 24)=     3356.04631687D0
	rhoarr( 25)=     2800.29706996D0
	rhoarr( 26)=     2385.24257878D0
	rhoarr( 27)=     2074.96984887D0
	rhoarr( 28)=     1840.70039077D0
	rhoarr( 29)=     1659.82154461D0
	rhoarr( 30)=     1514.92568401D0
	rhoarr( 31)=     1393.04374384D0
	rhoarr( 32)=     1284.99933798D0
	rhoarr( 33)=     1184.76713897D0
	rhoarr( 34)=     1088.80211325D0
	rhoarr( 35)=      995.38398098D0
	rhoarr( 36)=      904.03964458D0
	rhoarr( 37)=      815.08039371D0
	rhoarr( 38)=      729.25552788D0
	rhoarr( 39)=      647.50220150D0
	rhoarr( 40)=      570.76681264D0
	rhoarr( 41)=      499.87931962D0
	rhoarr( 42)=      435.47002410D0
	rhoarr( 43)=      377.92352009D0
	rhoarr( 44)=      327.36561221D0
	rhoarr( 45)=      283.67750129D0
	rhoarr( 46)=      246.52958080D0
	rhoarr( 47)=      215.42639649D0
	rhoarr( 48)=      189.75520157D0
	rhoarr( 49)=      168.83261250D0
	rhoarr( 50)=      151.94621138D0
	rhoarr( 51)=      138.38977610D0
	rhoarr( 52)=      127.49184498D0
	rhoarr( 53)=      118.63768672D0
	rhoarr( 54)=      111.28481148D0
	rhoarr( 55)=      104.97224571D0
	rhoarr( 56)=       99.32403354D0
	rhoarr( 57)=       94.04776305D0
	rhoarr( 58)=       88.92919961D0
	rhoarr( 59)=       83.82421931D0
	rhoarr( 60)=       78.64914565D0
	rhoarr( 61)=       73.37036667D0
	rhoarr( 62)=       67.99385132D0
	rhoarr( 63)=       62.55498189D0
	rhoarr( 64)=       57.10900841D0
	rhoarr( 65)=       51.72239338D0
	rhoarr( 66)=       46.46530240D0
	rhoarr( 67)=       41.40545977D0
	rhoarr( 68)=       36.60350576D0
	rhoarr( 69)=       32.10986897D0
	rhoarr( 70)=       27.96303488D0
	rhoarr( 71)=       24.18898428D0
	rhoarr( 72)=       20.80151798D0
	rhoarr( 73)=       17.80318382D0
	rhoarr( 74)=       15.18656649D0
	rhoarr( 75)=       12.93576760D0
	rhoarr( 76)=       11.02796945D0
	rhoarr( 77)=        9.43502401D0
	rhoarr( 78)=        8.12503139D0
	rhoarr( 79)=        7.06387476D0
	rhoarr( 80)=        6.21666907D0
	rhoarr( 81)=        5.54907176D0
	rhoarr( 82)=        5.02840216D0
	rhoarr( 83)=        4.62452638D0
	rhoarr( 84)=        4.31048345D0
	rhoarr( 85)=        4.06285294D0
	rhoarr( 86)=        3.86188685D0
	rhoarr( 87)=        3.69144600D0
	rhoarr( 88)=        3.53878987D0
	rhoarr( 89)=        3.39426948D0
	rhoarr( 90)=        3.25096637D0
	rhoarr( 91)=        3.10431071D0
	rhoarr( 92)=        2.95170051D0
	rhoarr( 93)=        2.79213456D0
	rhoarr( 94)=        2.62586582D0
	rhoarr( 95)=        2.45407870D0
	rhoarr( 96)=        2.27859377D0
	rhoarr( 97)=        2.10160373D0
	rhoarr( 98)=        1.92544540D0
	rhoarr( 99)=        1.75241202D0
	rhoarr(100)=        1.58460886D0
	rhoarr(101)=        1.42385263D0
	rhoarr(102)=        1.27161242D0
	rhoarr(103)=        1.12898735D0
	rhoarr(104)=        0.99671388D0
	rhoarr(105)=        0.87519488D0
	rhoarr(106)=        0.76454234D0
	rhoarr(107)=        0.66462616D0
	rhoarr(108)=        0.57512341D0
	rhoarr(109)=        0.49556373D0
	rhoarr(110)=        0.42536866D0
	rhoarr(111)=        0.36388427D0
	rhoarr(112)=        0.31040759D0
	rhoarr(113)=        0.26420820D0
	rhoarr(114)=        0.22454636D0
	rhoarr(115)=        0.19068906D0
	rhoarr(116)=        0.16192461D0
	rhoarr(117)=        0.13757623D0
	rhoarr(118)=        0.11701403D0
	rhoarr(119)=        0.09966486D0
	rhoarr(120)=        0.08501925D0
	rhoarr(121)=        0.07263484D0
	rhoarr(122)=        0.06213604D0
	rhoarr(123)=        0.05321021D0
	rhoarr(124)=        0.04560096D0
	rhoarr(125)=        0.03909971D0
	rhoarr(126)=        0.03353648D0
	rhoarr(127)=        0.02877131D0
	rhoarr(128)=        0.02468693D0
	rhoarr(129)=        0.02118329D0
	rhoarr(130)=        0.01817397D0
	rhoarr(131)=        0.01558411D0
	rhoarr(132)=        0.01334931D0
	rhoarr(133)=        0.01141500D0
	rhoarr(134)=        0.00973578D0
	rhoarr(135)=        0.00827460D0
	rhoarr(136)=        0.00700160D0
	rhoarr(137)=        0.00589292D0
	rhoarr(138)=        0.00492928D0
	rhoarr(139)=        0.00409481D0
	rhoarr(140)=        0.00337596D0
	rhoarr(141)=        0.00276070D0
	rhoarr(142)=        0.00223800D0
	rhoarr(143)=        0.00179753D0
	rhoarr(144)=        0.00142964D0
	rhoarr(145)=        0.00112530D0
	rhoarr(146)=        0.00087619D0
	rhoarr(147)=        0.00067464D0
	rhoarr(148)=        0.00051363D0
	rhoarr(149)=        0.00038672D0
	rhoarr(150)=        0.00028803D0
	rhoarr(151)=        0.00021225D0
	rhoarr(152)=        0.00015468D0
	rhoarr(153)=        0.00011131D0
	rhoarr(154)=        0.00007886D0
	rhoarr(155)=        0.00005474D0
	rhoarr(156)=        0.00003698D0
	rhoarr(157)=        0.00002414D0
	rhoarr(158)=        0.00001510D0
	rhoarr(159)=        0.00000899D0
	rhoarr(160)=        0.00000506D0
	rhoarr(161)=        0.00000269D0
	rhoarr(162)=        0.00000135D0
	rhoarr(163)=        0.00000065D0
	rhoarr(164)=        0.00000030D0
	rhoarr(165)=        0.00000014D0
	rhoarr(166)=        0.00000006D0
	rhoarr(167)=        0.00000003D0
	rhoarr(168)=        0.00000001D0
	
else if (iele==50) then  !Sn, 0 3, b3lyp/ANO-RCC int=dkh2
	npt=  166
	rhoarr(  1)=   459491.61079129D0
	rhoarr(  2)=   324383.12362090D0
	rhoarr(  3)=   242872.89867321D0
	rhoarr(  4)=   192908.96127545D0
	rhoarr(  5)=   158002.13433629D0
	rhoarr(  6)=   131596.63414492D0
	rhoarr(  7)=   110418.35037003D0
	rhoarr(  8)=    92901.92860991D0
	rhoarr(  9)=    78189.47639481D0
	rhoarr( 10)=    65559.80388785D0
	rhoarr( 11)=    54745.26297653D0
	rhoarr( 12)=    45461.39932991D0
	rhoarr( 13)=    37482.88908461D0
	rhoarr( 14)=    30682.82786473D0
	rhoarr( 15)=    24938.65566671D0
	rhoarr( 16)=    20121.78013665D0
	rhoarr( 17)=    16123.42288864D0
	rhoarr( 18)=    12849.04927460D0
	rhoarr( 19)=    10204.23437256D0
	rhoarr( 20)=     8095.06585585D0
	rhoarr( 21)=     6435.02069054D0
	rhoarr( 22)=     5147.33433463D0
	rhoarr( 23)=     4163.32924945D0
	rhoarr( 24)=     3421.21886302D0
	rhoarr( 25)=     2866.71366615D0
	rhoarr( 26)=     2453.98591235D0
	rhoarr( 27)=     2145.72492729D0
	rhoarr( 28)=     1912.28888428D0
	rhoarr( 29)=     1730.56909536D0
	rhoarr( 30)=     1582.99517884D0
	rhoarr( 31)=     1456.73125144D0
	rhoarr( 32)=     1342.94085633D0
	rhoarr( 33)=     1236.03571365D0
	rhoarr( 34)=     1132.91804627D0
	rhoarr( 35)=     1032.27578194D0
	rhoarr( 36)=      933.98333646D0
	rhoarr( 37)=      838.62941387D0
	rhoarr( 38)=      747.16533021D0
	rhoarr( 39)=      660.65323463D0
	rhoarr( 40)=      580.09147583D0
	rhoarr( 41)=      506.29863768D0
	rhoarr( 42)=      439.84363015D0
	rhoarr( 43)=      381.01373874D0
	rhoarr( 44)=      329.81451158D0
	rhoarr( 45)=      285.99510263D0
	rhoarr( 46)=      249.09150545D0
	rhoarr( 47)=      218.47946181D0
	rhoarr( 48)=      193.42949952D0
	rhoarr( 49)=      173.15840943D0
	rhoarr( 50)=      156.87378861D0
	rhoarr( 51)=      143.81028701D0
	rhoarr( 52)=      133.25748385D0
	rhoarr( 53)=      124.57989892D0
	rhoarr( 54)=      117.22979520D0
	rhoarr( 55)=      110.75346657D0
	rhoarr( 56)=      104.79180635D0
	rhoarr( 57)=       99.07612669D0
	rhoarr( 58)=       93.42035298D0
	rhoarr( 59)=       87.71075946D0
	rhoarr( 60)=       81.89431716D0
	rhoarr( 61)=       75.96653648D0
	rhoarr( 62)=       69.95947771D0
	rhoarr( 63)=       63.93043086D0
	rhoarr( 64)=       57.95164900D0
	rhoarr( 65)=       52.10143865D0
	rhoarr( 66)=       46.45683296D0
	rhoarr( 67)=       41.08797400D0
	rhoarr( 68)=       36.05420713D0
	rhoarr( 69)=       31.40176114D0
	rhoarr( 70)=       27.16278183D0
	rhoarr( 71)=       23.35542571D0
	rhoarr( 72)=       19.98471418D0
	rhoarr( 73)=       17.04388642D0
	rhoarr( 74)=       14.51605132D0
	rhoarr( 75)=       12.37600215D0
	rhoarr( 76)=       10.59210448D0
	rhoarr( 77)=        9.12819247D0
	rhoarr( 78)=        7.94541414D0
	rhoarr( 79)=        7.00396212D0
	rhoarr( 80)=        6.26462403D0
	rhoarr( 81)=        5.69009178D0
	rhoarr( 82)=        5.24598612D0
	rhoarr( 83)=        4.90157588D0
	rhoarr( 84)=        4.63019906D0
	rhoarr( 85)=        4.40941585D0
	rhoarr( 86)=        4.22094094D0
	rhoarr( 87)=        4.05040962D0
	rhoarr( 88)=        3.88703154D0
	rhoarr( 89)=        3.72317856D0
	rhoarr( 90)=        3.55394233D0
	rhoarr( 91)=        3.37668681D0
	rhoarr( 92)=        3.19061191D0
	rhoarr( 93)=        2.99633857D0
	rhoarr( 94)=        2.79552309D0
	rhoarr( 95)=        2.59050690D0
	rhoarr( 96)=        2.38400799D0
	rhoarr( 97)=        2.17885911D0
	rhoarr( 98)=        1.97779678D0
	rhoarr( 99)=        1.78330245D0
	rhoarr(100)=        1.59749471D0
	rhoarr(101)=        1.42206857D0
	rhoarr(102)=        1.25827531D0
	rhoarr(103)=        1.10693485D0
	rhoarr(104)=        0.96847156D0
	rhoarr(105)=        0.84296464D0
	rhoarr(106)=        0.73020536D0
	rhoarr(107)=        0.62975460D0
	rhoarr(108)=        0.54099665D0
	rhoarr(109)=        0.46318664D0
	rhoarr(110)=        0.39549107D0
	rhoarr(111)=        0.33702172D0
	rhoarr(112)=        0.28686421D0
	rhoarr(113)=        0.24410240D0
	rhoarr(114)=        0.20783970D0
	rhoarr(115)=        0.17721779D0
	rhoarr(116)=        0.15143279D0
	rhoarr(117)=        0.12974834D0
	rhoarr(118)=        0.11150524D0
	rhoarr(119)=        0.09612677D0
	rhoarr(120)=        0.08311966D0
	rhoarr(121)=        0.07207083D0
	rhoarr(122)=        0.06264041D0
	rhoarr(123)=        0.05455239D0
	rhoarr(124)=        0.04758383D0
	rhoarr(125)=        0.04155432D0
	rhoarr(126)=        0.03631652D0
	rhoarr(127)=        0.03174860D0
	rhoarr(128)=        0.02774873D0
	rhoarr(129)=        0.02423142D0
	rhoarr(130)=        0.02112517D0
	rhoarr(131)=        0.01837086D0
	rhoarr(132)=        0.01592051D0
	rhoarr(133)=        0.01373583D0
	rhoarr(134)=        0.01178681D0
	rhoarr(135)=        0.01005007D0
	rhoarr(136)=        0.00850724D0
	rhoarr(137)=        0.00714341D0
	rhoarr(138)=        0.00594580D0
	rhoarr(139)=        0.00490267D0
	rhoarr(140)=        0.00400257D0
	rhoarr(141)=        0.00323396D0
	rhoarr(142)=        0.00258498D0
	rhoarr(143)=        0.00204357D0
	rhoarr(144)=        0.00159757D0
	rhoarr(145)=        0.00123492D0
	rhoarr(146)=        0.00094394D0
	rhoarr(147)=        0.00071351D0
	rhoarr(148)=        0.00053326D0
	rhoarr(149)=        0.00039386D0
	rhoarr(150)=        0.00028710D0
	rhoarr(151)=        0.00020606D0
	rhoarr(152)=        0.00014506D0
	rhoarr(153)=        0.00009965D0
	rhoarr(154)=        0.00006638D0
	rhoarr(155)=        0.00004255D0
	rhoarr(156)=        0.00002605D0
	rhoarr(157)=        0.00001511D0
	rhoarr(158)=        0.00000825D0
	rhoarr(159)=        0.00000422D0
	rhoarr(160)=        0.00000202D0
	rhoarr(161)=        0.00000091D0
	rhoarr(162)=        0.00000040D0
	rhoarr(163)=        0.00000017D0
	rhoarr(164)=        0.00000007D0
	rhoarr(165)=        0.00000003D0
	rhoarr(166)=        0.00000001D0

else if (iele==51) then  !Sb, 0 4, b3lyp/ANO-RCC int=dkh2
	npt=  165
	rhoarr(  1)=   509787.01950405D0
	rhoarr(  2)=   355096.31515306D0
	rhoarr(  3)=   264308.75880774D0
	rhoarr(  4)=   208961.34788639D0
	rhoarr(  5)=   170266.15673218D0
	rhoarr(  6)=   141253.91296814D0
	rhoarr(  7)=   117999.99674656D0
	rhoarr(  8)=    98907.09910985D0
	rhoarr(  9)=    82896.94945708D0
	rhoarr( 10)=    69224.86852490D0
	rhoarr( 11)=    57578.55831553D0
	rhoarr( 12)=    47611.67657752D0
	rhoarr( 13)=    39087.36639637D0
	rhoarr( 14)=    31863.03234057D0
	rhoarr( 15)=    25788.91797258D0
	rhoarr( 16)=    20719.11853706D0
	rhoarr( 17)=    16534.66828361D0
	rhoarr( 18)=    13128.91620541D0
	rhoarr( 19)=    10394.29870292D0
	rhoarr( 20)=     8226.46183391D0
	rhoarr( 21)=     6531.17262787D0
	rhoarr( 22)=     5225.07650292D0
	rhoarr( 23)=     4233.60189893D0
	rhoarr( 24)=     3490.27985326D0
	rhoarr( 25)=     2937.56797679D0
	rhoarr( 26)=     2527.47618185D0
	rhoarr( 27)=     2221.20959731D0
	rhoarr( 28)=     1988.16112562D0
	rhoarr( 29)=     1804.78018403D0
	rhoarr( 30)=     1653.53163477D0
	rhoarr( 31)=     1521.92753911D0
	rhoarr( 32)=     1401.59516263D0
	rhoarr( 33)=     1287.39776086D0
	rhoarr( 34)=     1176.64183483D0
	rhoarr( 35)=     1068.38598400D0
	rhoarr( 36)=      962.85015548D0
	rhoarr( 37)=      860.92476154D0
	rhoarr( 38)=      763.78543601D0
	rhoarr( 39)=      672.61713251D0
	rhoarr( 40)=      588.43945571D0
	rhoarr( 41)=      512.01248687D0
	rhoarr( 42)=      443.79754181D0
	rhoarr( 43)=      383.95169076D0
	rhoarr( 44)=      332.34363024D0
	rhoarr( 45)=      288.58570046D0
	rhoarr( 46)=      252.07955401D0
	rhoarr( 47)=      222.07193585D0
	rhoarr( 48)=      197.71485486D0
	rhoarr( 49)=      178.12343973D0
	rhoarr( 50)=      162.42580529D0
	rhoarr( 51)=      149.80171529D0
	rhoarr( 52)=      139.50950218D0
	rhoarr( 53)=      130.90260060D0
	rhoarr( 54)=      123.43781552D0
	rhoarr( 55)=      116.67730763D0
	rhoarr( 56)=      110.28574269D0
	rhoarr( 57)=      104.02356419D0
	rhoarr( 58)=       97.73712823D0
	rhoarr( 59)=       91.34646754D0
	rhoarr( 60)=       84.83158536D0
	rhoarr( 61)=       78.21826836D0
	rhoarr( 62)=       71.56436883D0
	rhoarr( 63)=       64.94733702D0
	rhoarr( 64)=       58.45353364D0
	rhoarr( 65)=       52.16958518D0
	rhoarr( 66)=       46.17581219D0
	rhoarr( 67)=       40.54159252D0
	rhoarr( 68)=       35.32242236D0
	rhoarr( 69)=       30.55839837D0
	rhoarr( 70)=       26.27384670D0
	rhoarr( 71)=       22.47785128D0
	rhoarr( 72)=       19.16546866D0
	rhoarr( 73)=       16.31944966D0
	rhoarr( 74)=       13.91231202D0
	rhoarr( 75)=       11.90862234D0
	rhoarr( 76)=       10.26735275D0
	rhoarr( 77)=        8.94418353D0
	rhoarr( 78)=        7.89363469D0
	rhoarr( 79)=        7.07092937D0
	rhoarr( 80)=        6.43352169D0
	rhoarr( 81)=        5.94225608D0
	rhoarr( 82)=        5.56215967D0
	rhoarr( 83)=        5.26289726D0
	rhoarr( 84)=        5.01893780D0
	rhoarr( 85)=        4.80948922D0
	rhoarr( 86)=        4.61825823D0
	rhoarr( 87)=        4.43308526D0
	rhoarr( 88)=        4.24549531D0
	rhoarr( 89)=        4.05019742D0
	rhoarr( 90)=        3.84455871D0
	rhoarr( 91)=        3.62807492D0
	rhoarr( 92)=        3.40185780D0
	rhoarr( 93)=        3.16815713D0
	rhoarr( 94)=        2.92993340D0
	rhoarr( 95)=        2.69049259D0
	rhoarr( 96)=        2.45318990D0
	rhoarr( 97)=        2.22120350D0
	rhoarr( 98)=        1.99737449D0
	rhoarr( 99)=        1.78410565D0
	rhoarr(100)=        1.58330936D0
	rhoarr(101)=        1.39639433D0
	rhoarr(102)=        1.22428159D0
	rhoarr(103)=        1.06744080D0
	rhoarr(104)=        0.92594002D0
	rhoarr(105)=        0.79950275D0
	rhoarr(106)=        0.68756819D0
	rhoarr(107)=        0.58935112D0
	rhoarr(108)=        0.50389920D0
	rhoarr(109)=        0.43014607D0
	rhoarr(110)=        0.36695939D0
	rhoarr(111)=        0.31318324D0
	rhoarr(112)=        0.26767457D0
	rhoarr(113)=        0.22933368D0
	rhoarr(114)=        0.19712846D0
	rhoarr(115)=        0.17011251D0
	rhoarr(116)=        0.14743711D0
	rhoarr(117)=        0.12835734D0
	rhoarr(118)=        0.11223282D0
	rhoarr(119)=        0.09852392D0
	rhoarr(120)=        0.08678413D0
	rhoarr(121)=        0.07665006D0
	rhoarr(122)=        0.06782990D0
	rhoarr(123)=        0.06009171D0
	rhoarr(124)=        0.05325225D0
	rhoarr(125)=        0.04716725D0
	rhoarr(126)=        0.04172315D0
	rhoarr(127)=        0.03683060D0
	rhoarr(128)=        0.03241931D0
	rhoarr(129)=        0.02843392D0
	rhoarr(130)=        0.02483074D0
	rhoarr(131)=        0.02157501D0
	rhoarr(132)=        0.01863858D0
	rhoarr(133)=        0.01599805D0
	rhoarr(134)=        0.01363331D0
	rhoarr(135)=        0.01152636D0
	rhoarr(136)=        0.00966058D0
	rhoarr(137)=        0.00802008D0
	rhoarr(138)=        0.00658940D0
	rhoarr(139)=        0.00535327D0
	rhoarr(140)=        0.00429646D0
	rhoarr(141)=        0.00340368D0
	rhoarr(142)=        0.00265953D0
	rhoarr(143)=        0.00204845D0
	rhoarr(144)=        0.00155478D0
	rhoarr(145)=        0.00116283D0
	rhoarr(146)=        0.00085720D0
	rhoarr(147)=        0.00062313D0
	rhoarr(148)=        0.00044688D0
	rhoarr(149)=        0.00031622D0
	rhoarr(150)=        0.00022063D0
	rhoarr(151)=        0.00015147D0
	rhoarr(152)=        0.00010195D0
	rhoarr(153)=        0.00006690D0
	rhoarr(154)=        0.00004249D0
	rhoarr(155)=        0.00002590D0
	rhoarr(156)=        0.00001500D0
	rhoarr(157)=        0.00000819D0
	rhoarr(158)=        0.00000417D0
	rhoarr(159)=        0.00000197D0
	rhoarr(160)=        0.00000087D0
	rhoarr(161)=        0.00000036D0
	rhoarr(162)=        0.00000014D0
	rhoarr(163)=        0.00000006D0
	rhoarr(164)=        0.00000002D0
	rhoarr(165)=        0.00000001D0
	
else if (iele==52) then  !Te, 0 3, b3lyp/ANO-RCC int=dkh2
	npt=  164
	rhoarr(  1)=   563364.58297381D0
	rhoarr(  2)=   388614.19967033D0
	rhoarr(  3)=   287357.76602408D0
	rhoarr(  4)=   226086.65215909D0
	rhoarr(  5)=   183301.15988141D0
	rhoarr(  6)=   151441.53098199D0
	rhoarr(  7)=   125964.78462712D0
	rhoarr(  8)=   105175.51137469D0
	rhoarr(  9)=    87781.32411289D0
	rhoarr( 10)=    73008.83931107D0
	rhoarr( 11)=    60481.92731456D0
	rhoarr( 12)=    49798.94796314D0
	rhoarr( 13)=    40709.74561477D0
	rhoarr( 14)=    33047.36736062D0
	rhoarr( 15)=    26633.63051185D0
	rhoarr( 16)=    21306.90944058D0
	rhoarr( 17)=    16936.55558662D0
	rhoarr( 18)=    13401.12103304D0
	rhoarr( 19)=    10578.69069252D0
	rhoarr( 20)=     8354.40870434D0
	rhoarr( 21)=     6626.30046702D0
	rhoarr( 22)=     5304.13818202D0
	rhoarr( 23)=     4307.13094783D0
	rhoarr( 24)=     3563.90353782D0
	rhoarr( 25)=     3013.57225564D0
	rhoarr( 26)=     2606.05132037D0
	rhoarr( 27)=     2301.26506406D0
	rhoarr( 28)=     2067.88405006D0
	rhoarr( 29)=     1882.07876542D0
	rhoarr( 30)=     1726.38816741D0
	rhoarr( 31)=     1588.64379650D0
	rhoarr( 32)=     1460.93278447D0
	rhoarr( 33)=     1338.63596045D0
	rhoarr( 34)=     1219.57306803D0
	rhoarr( 35)=     1103.26201075D0
	rhoarr( 36)=      990.29055426D0
	rhoarr( 37)=      881.80595775D0
	rhoarr( 38)=      779.13119038D0
	rhoarr( 39)=      683.50607256D0
	rhoarr( 40)=      595.93484054D0
	rhoarr( 41)=      517.11082832D0
	rhoarr( 42)=      447.39007387D0
	rhoarr( 43)=      386.79510497D0
	rhoarr( 44)=      335.04026005D0
	rhoarr( 45)=      291.57523222D0
	rhoarr( 46)=      255.64347008D0
	rhoarr( 47)=      226.34940102D0
	rhoarr( 48)=      202.72645430D0
	rhoarr( 49)=      183.79828189D0
	rhoarr( 50)=      168.62815552D0
	rhoarr( 51)=      156.35485292D0
	rhoarr( 52)=      146.21602159D0
	rhoarr( 53)=      137.56132479D0
	rhoarr( 54)=      129.85774761D0
	rhoarr( 55)=      122.68885368D0
	rhoarr( 56)=      115.74914783D0
	rhoarr( 57)=      108.83436946D0
	rhoarr( 58)=      101.82855317D0
	rhoarr( 59)=       94.68888354D0
	rhoarr( 60)=       87.42953473D0
	rhoarr( 61)=       80.10569278D0
	rhoarr( 62)=       72.79878433D0
	rhoarr( 63)=       65.60363616D0
	rhoarr( 64)=       58.61795207D0
	rhoarr( 65)=       51.93419202D0
	rhoarr( 66)=       45.63371789D0
	rhoarr( 67)=       39.78294182D0
	rhoarr( 68)=       34.43116352D0
	rhoarr( 69)=       29.60978730D0
	rhoarr( 70)=       25.33264175D0
	rhoarr( 71)=       21.59716466D0
	rhoarr( 72)=       18.38624819D0
	rhoarr( 73)=       15.67056011D0
	rhoarr( 74)=       13.41116590D0
	rhoarr( 75)=       11.56227967D0
	rhoarr( 76)=       10.07397762D0
	rhoarr( 77)=        8.89472279D0
	rhoarr( 78)=        7.97357776D0
	rhoarr( 79)=        7.26202113D0
	rhoarr( 80)=        6.71532818D0
	rhoarr( 81)=        6.29351870D0
	rhoarr( 82)=        5.96190904D0
	rhoarr( 83)=        5.69132672D0
	rhoarr( 84)=        5.45805453D0
	rhoarr( 85)=        5.24356925D0
	rhoarr( 86)=        5.03413129D0
	rhoarr( 87)=        4.82027148D0
	rhoarr( 88)=        4.59621178D0
	rhoarr( 89)=        4.35925025D0
	rhoarr( 90)=        4.10913787D0
	rhoarr( 91)=        3.84747244D0
	rhoarr( 92)=        3.57713341D0
	rhoarr( 93)=        3.30177787D0
	rhoarr( 94)=        3.02541252D0
	rhoarr( 95)=        2.75204956D0
	rhoarr( 96)=        2.48544730D0
	rhoarr( 97)=        2.22893014D0
	rhoarr( 98)=        1.98527793D0
	rhoarr( 99)=        1.75667260D0
	rhoarr(100)=        1.54468932D0
	rhoarr(101)=        1.35032053D0
	rhoarr(102)=        1.17402269D0
	rhoarr(103)=        1.01577757D0
	rhoarr(104)=        0.87516177D0
	rhoarr(105)=        0.75141960D0
	rhoarr(106)=        0.64353576D0
	rhoarr(107)=        0.55030520D0
	rhoarr(108)=        0.47039832D0
	rhoarr(109)=        0.40242010D0
	rhoarr(110)=        0.34496231D0
	rhoarr(111)=        0.29664796D0
	rhoarr(112)=        0.25616780D0
	rhoarr(113)=        0.22230829D0
	rhoarr(114)=        0.19397139D0
	rhoarr(115)=        0.17018622D0
	rhoarr(116)=        0.15011330D0
	rhoarr(117)=        0.13304245D0
	rhoarr(118)=        0.11838541D0
	rhoarr(119)=        0.10566468D0
	rhoarr(120)=        0.09450005D0
	rhoarr(121)=        0.08459411D0
	rhoarr(122)=        0.07571799D0
	rhoarr(123)=        0.06769814D0
	rhoarr(124)=        0.06040475D0
	rhoarr(125)=        0.05374188D0
	rhoarr(126)=        0.04763933D0
	rhoarr(127)=        0.04204599D0
	rhoarr(128)=        0.03692438D0
	rhoarr(129)=        0.03224620D0
	rhoarr(130)=        0.02798886D0
	rhoarr(131)=        0.02413279D0
	rhoarr(132)=        0.02065954D0
	rhoarr(133)=        0.01755061D0
	rhoarr(134)=        0.01478680D0
	rhoarr(135)=        0.01234798D0
	rhoarr(136)=        0.01021317D0
	rhoarr(137)=        0.00836078D0
	rhoarr(138)=        0.00676879D0
	rhoarr(139)=        0.00541508D0
	rhoarr(140)=        0.00427750D0
	rhoarr(141)=        0.00333403D0
	rhoarr(142)=        0.00256281D0
	rhoarr(143)=        0.00194224D0
	rhoarr(144)=        0.00145116D0
	rhoarr(145)=        0.00106918D0
	rhoarr(146)=        0.00077709D0
	rhoarr(147)=        0.00055733D0
	rhoarr(148)=        0.00039441D0
	rhoarr(149)=        0.00027517D0
	rhoarr(150)=        0.00018889D0
	rhoarr(151)=        0.00012713D0
	rhoarr(152)=        0.00008347D0
	rhoarr(153)=        0.00005312D0
	rhoarr(154)=        0.00003253D0
	rhoarr(155)=        0.00001902D0
	rhoarr(156)=        0.00001054D0
	rhoarr(157)=        0.00000550D0
	rhoarr(158)=        0.00000270D0
	rhoarr(159)=        0.00000125D0
	rhoarr(160)=        0.00000055D0
	rhoarr(161)=        0.00000024D0
	rhoarr(162)=        0.00000010D0
	rhoarr(163)=        0.00000004D0
	rhoarr(164)=        0.00000002D0

else if (iele==53) then  !I, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=163
	rhoarr(  1)= 624439.74703561D0
	rhoarr(  2)= 424581.07151114D0
	rhoarr(  3)= 312103.48875776D0
	rhoarr(  4)= 244366.29089030D0
	rhoarr(  5)= 197119.23240539D0
	rhoarr(  6)= 162180.33144405D0
	rhoarr(  7)= 134311.66870601D0
	rhoarr(  8)= 111709.06511866D0
	rhoarr(  9)=  92838.20761454D0
	rhoarr( 10)=  76906.18415032D0
	rhoarr( 11)=  63451.66154098D0
	rhoarr( 12)=  52019.42571876D0
	rhoarr( 13)=  42346.07972375D0
	rhoarr( 14)=  34232.66387785D0
	rhoarr( 15)=  27470.97342448D0
	rhoarr( 16)=  21884.55255028D0
	rhoarr( 17)=  17329.09126575D0
	rhoarr( 18)=  13665.82046047D0
	rhoarr( 19)=  10757.73413907D0
	rhoarr( 20)=   8479.59804168D0
	rhoarr( 21)=   6721.44334477D0
	rhoarr( 22)=   5385.60106798D0
	rhoarr( 23)=   4384.70308382D0
	rhoarr( 24)=   3642.46100579D0
	rhoarr( 25)=   3094.80511685D0
	rhoarr( 26)=   2689.70431381D0
	rhoarr( 27)=   2385.91587152D0
	rhoarr( 28)=   2151.48727289D0
	rhoarr( 29)=   1962.40288095D0
	rhoarr( 30)=   1801.35813640D0
	rhoarr( 31)=   1656.57768934D0
	rhoarr( 32)=   1520.67771515D0
	rhoarr( 33)=   1389.61695309D0
	rhoarr( 34)=   1261.76688654D0
	rhoarr( 35)=   1137.11119495D0
	rhoarr( 36)=   1016.58230309D0
	rhoarr( 37)=    901.54561201D0
	rhoarr( 38)=    793.43352964D0
	rhoarr( 39)=    693.51295144D0
	rhoarr( 40)=    602.75462371D0
	rhoarr( 41)=    521.77054965D0
	rhoarr( 42)=    450.79481210D0
	rhoarr( 43)=    389.69532771D0
	rhoarr( 44)=    338.01155879D0
	rhoarr( 45)=    295.01407193D0
	rhoarr( 46)=    259.77881326D0
	rhoarr( 47)=    231.26619291D0
	rhoarr( 48)=    208.39508051D0
	rhoarr( 49)=    190.10465849D0
	rhoarr( 50)=    175.40114958D0
	rhoarr( 51)=    163.38990614D0
	rhoarr( 52)=    153.29521300D0
	rhoarr( 53)=    144.47044494D0
	rhoarr( 54)=    136.40061802D0
	rhoarr( 55)=    128.69865201D0
	rhoarr( 56)=    121.09628475D0
	rhoarr( 57)=    113.43061763D0
	rhoarr( 58)=    105.62752890D0
	rhoarr( 59)=     97.68341513D0
	rhoarr( 60)=     89.64674804D0
	rhoarr( 61)=     81.60073376D0
	rhoarr( 62)=     73.64800515D0
	rhoarr( 63)=     65.89787220D0
	rhoarr( 64)=     58.45629284D0
	rhoarr( 65)=     51.41845937D0
	rhoarr( 66)=     44.86373712D0
	rhoarr( 67)=     38.85262388D0
	rhoarr( 68)=     33.42539263D0
	rhoarr( 69)=     28.60210639D0
	rhoarr( 70)=     24.38372949D0
	rhoarr( 71)=     20.75408954D0
	rhoarr( 72)=     17.68246324D0
	rhoarr( 73)=     15.12656750D0
	rhoarr( 74)=     13.03574086D0
	rhoarr( 75)=     11.35410924D0
	rhoarr( 76)=     10.02354975D0
	rhoarr( 77)=      8.98630212D0
	rhoarr( 78)=      8.18712529D0
	rhoarr( 79)=      7.57495008D0
	rhoarr( 80)=      7.10402940D0
	rhoarr( 81)=      6.73462661D0
	rhoarr( 82)=      6.43330797D0
	rhoarr( 83)=      6.17291428D0
	rhoarr( 84)=      5.93228548D0
	rhoarr( 85)=      5.69580253D0
	rhoarr( 86)=      5.45280019D0
	rhoarr( 87)=      5.19689459D0
	rhoarr( 88)=      4.92526350D0
	rhoarr( 89)=      4.63791372D0
	rhoarr( 90)=      4.33696817D0
	rhoarr( 91)=      4.02600197D0
	rhoarr( 92)=      3.70945247D0
	rhoarr( 93)=      3.39212022D0
	rhoarr( 94)=      3.07876993D0
	rhoarr( 95)=      2.77383137D0
	rhoarr( 96)=      2.48119307D0
	rhoarr( 97)=      2.20407709D0
	rhoarr( 98)=      1.94498037D0
	rhoarr( 99)=      1.70566807D0
	rhoarr(100)=      1.48720544D0
	rhoarr(101)=      1.29001679D0
	rhoarr(102)=      1.11396182D0
	rhoarr(103)=      0.95842218D0
	rhoarr(104)=      0.82239204D0
	rhoarr(105)=      0.70456843D0
	rhoarr(106)=      0.60343788D0
	rhoarr(107)=      0.51735672D0
	rhoarr(108)=      0.44462331D0
	rhoarr(109)=      0.38354086D0
	rhoarr(110)=      0.33246996D0
	rhoarr(111)=      0.28987032D0
	rhoarr(112)=      0.25433176D0
	rhoarr(113)=      0.22459454D0
	rhoarr(114)=      0.19955998D0
	rhoarr(115)=      0.17829221D0
	rhoarr(116)=      0.16001274D0
	rhoarr(117)=      0.14408928D0
	rhoarr(118)=      0.13002066D0
	rhoarr(119)=      0.11741950D0
	rhoarr(120)=      0.10599419D0
	rhoarr(121)=      0.09553130D0
	rhoarr(122)=      0.08587939D0
	rhoarr(123)=      0.07693467D0
	rhoarr(124)=      0.06862873D0
	rhoarr(125)=      0.06091827D0
	rhoarr(126)=      0.05377668D0
	rhoarr(127)=      0.04718726D0
	rhoarr(128)=      0.04113802D0
	rhoarr(129)=      0.03561789D0
	rhoarr(130)=      0.03061411D0
	rhoarr(131)=      0.02611087D0
	rhoarr(132)=      0.02208871D0
	rhoarr(133)=      0.01852469D0
	rhoarr(134)=      0.01539287D0
	rhoarr(135)=      0.01266499D0
	rhoarr(136)=      0.01031124D0
	rhoarr(137)=      0.00830092D0
	rhoarr(138)=      0.00660295D0
	rhoarr(139)=      0.00518624D0
	rhoarr(140)=      0.00401996D0
	rhoarr(141)=      0.00307374D0
	rhoarr(142)=      0.00231793D0
	rhoarr(143)=      0.00172399D0
	rhoarr(144)=      0.00126490D0
	rhoarr(145)=      0.00091574D0
	rhoarr(146)=      0.00065421D0
	rhoarr(147)=      0.00046100D0
	rhoarr(148)=      0.00032003D0
	rhoarr(149)=      0.00021832D0
	rhoarr(150)=      0.00014581D0
	rhoarr(151)=      0.00009483D0
	rhoarr(152)=      0.00005968D0
	rhoarr(153)=      0.00003608D0
	rhoarr(154)=      0.00002080D0
	rhoarr(155)=      0.00001136D0
	rhoarr(156)=      0.00000584D0
	rhoarr(157)=      0.00000282D0
	rhoarr(158)=      0.00000129D0
	rhoarr(159)=      0.00000056D0
	rhoarr(160)=      0.00000023D0
	rhoarr(161)=      0.00000010D0
	rhoarr(162)=      0.00000004D0
	rhoarr(163)=      0.00000002D0
	
else if (iele==54) then  !Xe, 0 1, b3lyp/ANO-RCC int=dkh2
	npt=  162
	rhoarr(  1)=   689533.87019075D0
	rhoarr(  2)=   463765.52954931D0
	rhoarr(  3)=   338689.64473187D0
	rhoarr(  4)=   263843.75123196D0
	rhoarr(  5)=   211784.50310146D0
	rhoarr(  6)=   173492.49680148D0
	rhoarr(  7)=   143067.79389483D0
	rhoarr(  8)=   118516.02049718D0
	rhoarr(  9)=    98077.53826165D0
	rhoarr( 10)=    80921.23575333D0
	rhoarr( 11)=    66487.94133172D0
	rhoarr( 12)=    54274.53198998D0
	rhoarr( 13)=    43996.85596170D0
	rhoarr( 14)=    35417.85425404D0
	rhoarr( 15)=    28300.37797326D0
	rhoarr( 16)=    22452.34742665D0
	rhoarr( 17)=    17712.44886607D0
	rhoarr( 18)=    13922.80338937D0
	rhoarr( 19)=    10931.34047702D0
	rhoarr( 20)=     8602.36345039D0
	rhoarr( 21)=     6817.17871754D0
	rhoarr( 22)=     5469.99234326D0
	rhoarr( 23)=     4466.67505676D0
	rhoarr( 24)=     3726.18034281D0
	rhoarr( 25)=     3181.43973604D0
	rhoarr( 26)=     2778.58253675D0
	rhoarr( 27)=     2475.26377217D0
	rhoarr( 28)=     2238.98441489D0
	rhoarr( 29)=     2045.64271746D0
	rhoarr( 30)=     1878.20249132D0
	rhoarr( 31)=     1725.39009637D0
	rhoarr( 32)=     1580.44073667D0
	rhoarr( 33)=     1439.94839103D0
	rhoarr( 34)=     1302.85464498D0
	rhoarr( 35)=     1169.59467741D0
	rhoarr( 36)=     1041.41439842D0
	rhoarr( 37)=      919.86492466D0
	rhoarr( 38)=      806.46182885D0
	rhoarr( 39)=      702.47704818D0
	rhoarr( 40)=      608.82407665D0
	rhoarr( 41)=      526.00448596D0
	rhoarr( 42)=      454.09769582D0
	rhoarr( 43)=      392.78633932D0
	rhoarr( 44)=      341.41222696D0
	rhoarr( 45)=      299.05491487D0
	rhoarr( 46)=      264.62113261D0
	rhoarr( 47)=      236.93251421D0
	rhoarr( 48)=      214.80190060D0
	rhoarr( 49)=      197.09327436D0
	rhoarr( 50)=      182.76485246D0
	rhoarr( 51)=      170.89752649D0
	rhoarr( 52)=      160.71152729D0
	rhoarr( 53)=      151.57364551D0
	rhoarr( 54)=      142.99652160D0
	rhoarr( 55)=      134.63106199D0
	rhoarr( 56)=      126.25308355D0
	rhoarr( 57)=      117.74562064D0
	rhoarr( 58)=      109.07863872D0
	rhoarr( 59)=      100.28797273D0
	rhoarr( 60)=       91.45510074D0
	rhoarr( 61)=       82.68895537D0
	rhoarr( 62)=       74.11049585D0
	rhoarr( 63)=       65.84032744D0
	rhoarr( 64)=       57.98932728D0
	rhoarr( 65)=       50.65203226D0
	rhoarr( 66)=       43.90244733D0
	rhoarr( 67)=       37.79190775D0
	rhoarr( 68)=       32.34864366D0
	rhoarr( 69)=       27.57872437D0
	rhoarr( 70)=       23.46808712D0
	rhoarr( 71)=       19.98537282D0
	rhoarr( 72)=       17.08530006D0
	rhoarr( 73)=       14.71231431D0
	rhoarr( 74)=       12.80426035D0
	rhoarr( 75)=       11.29585163D0
	rhoarr( 76)=       10.12175241D0
	rhoarr( 77)=        9.21914613D0
	rhoarr( 78)=        8.52972601D0
	rhoarr( 79)=        8.00110349D0
	rhoarr( 80)=        7.58767697D0
	rhoarr( 81)=        7.25103260D0
	rhoarr( 82)=        6.95996199D0
	rhoarr( 83)=        6.69018032D0
	rhoarr( 84)=        6.42381944D0
	rhoarr( 85)=        6.14875914D0
	rhoarr( 86)=        5.85784985D0
	rhoarr( 87)=        5.54807352D0
	rhoarr( 88)=        5.21968587D0
	rhoarr( 89)=        4.87538020D0
	rhoarr( 90)=        4.51950915D0
	rhoarr( 91)=        4.15739394D0
	rhoarr( 92)=        3.79474158D0
	rhoarr( 93)=        3.43717988D0
	rhoarr( 94)=        3.08990999D0
	rhoarr( 95)=        2.75746772D0
	rhoarr( 96)=        2.44357980D0
	rhoarr( 97)=        2.15109824D0
	rhoarr( 98)=        1.88199604D0
	rhoarr( 99)=        1.63740859D0
	rhoarr(100)=        1.41770763D0
	rhoarr(101)=        1.22259621D0
	rhoarr(102)=        1.05121605D0
	rhoarr(103)=        0.90225976D0
	rhoarr(104)=        0.77408247D0
	rhoarr(105)=        0.66480830D0
	rhoarr(106)=        0.57242842D0
	rhoarr(107)=        0.49488825D0
	rhoarr(108)=        0.43016220D0
	rhoarr(109)=        0.37631490D0
	rhoarr(110)=        0.33154858D0
	rhoarr(111)=        0.29423680D0
	rhoarr(112)=        0.26294515D0
	rhoarr(113)=        0.23644016D0
	rhoarr(114)=        0.21368807D0
	rhoarr(115)=        0.19384532D0
	rhoarr(116)=        0.17624278D0
	rhoarr(117)=        0.16036597D0
	rhoarr(118)=        0.14583294D0
	rhoarr(119)=        0.13237168D0
	rhoarr(120)=        0.11979830D0
	rhoarr(121)=        0.10799683D0
	rhoarr(122)=        0.09690143D0
	rhoarr(123)=        0.08648103D0
	rhoarr(124)=        0.07672658D0
	rhoarr(125)=        0.06764079D0
	rhoarr(126)=        0.05923018D0
	rhoarr(127)=        0.05149942D0
	rhoarr(128)=        0.04444760D0
	rhoarr(129)=        0.03806627D0
	rhoarr(130)=        0.03233891D0
	rhoarr(131)=        0.02724141D0
	rhoarr(132)=        0.02274322D0
	rhoarr(133)=        0.01880882D0
	rhoarr(134)=        0.01539915D0
	rhoarr(135)=        0.01247300D0
	rhoarr(136)=        0.00998809D0
	rhoarr(137)=        0.00790186D0
	rhoarr(138)=        0.00617209D0
	rhoarr(139)=        0.00475724D0
	rhoarr(140)=        0.00361686D0
	rhoarr(141)=        0.00271190D0
	rhoarr(142)=        0.00200531D0
	rhoarr(143)=        0.00146252D0
	rhoarr(144)=        0.00105216D0
	rhoarr(145)=        0.00074654D0
	rhoarr(146)=        0.00052206D0
	rhoarr(147)=        0.00035925D0
	rhoarr(148)=        0.00024260D0
	rhoarr(149)=        0.00016011D0
	rhoarr(150)=        0.00010270D0
	rhoarr(151)=        0.00006361D0
	rhoarr(152)=        0.00003775D0
	rhoarr(153)=        0.00002131D0
	rhoarr(154)=        0.00001135D0
	rhoarr(155)=        0.00000567D0
	rhoarr(156)=        0.00000264D0
	rhoarr(157)=        0.00000115D0
	rhoarr(158)=        0.00000047D0
	rhoarr(159)=        0.00000019D0
	rhoarr(160)=        0.00000007D0
	rhoarr(161)=        0.00000003D0
	rhoarr(162)=        0.00000001D0

else if (iele==55) then  !Cs, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=  171
	rhoarr(  1)=   777569.48476138D0
	rhoarr(  2)=   504780.77001253D0
	rhoarr(  3)=   367042.05919850D0
	rhoarr(  4)=   284502.70745904D0
	rhoarr(  5)=   227495.84784171D0
	rhoarr(  6)=   185336.83820587D0
	rhoarr(  7)=   152320.45507257D0
	rhoarr(  8)=   125593.24039361D0
	rhoarr(  9)=   103501.10657997D0
	rhoarr( 10)=    85086.06160418D0
	rhoarr( 11)=    69582.31879996D0
	rhoarr( 12)=    56566.52960141D0
	rhoarr( 13)=    45674.63657203D0
	rhoarr( 14)=    36601.07787441D0
	rhoarr( 15)=    29117.59407168D0
	rhoarr( 16)=    23014.78515269D0
	rhoarr( 17)=    18091.92501645D0
	rhoarr( 18)=    14171.88716568D0
	rhoarr( 19)=    11097.59140386D0
	rhoarr( 20)=     8723.44859475D0
	rhoarr( 21)=     6916.16446164D0
	rhoarr( 22)=     5559.06530353D0
	rhoarr( 23)=     4552.94735050D0
	rhoarr( 24)=     3814.18135181D0
	rhoarr( 25)=     3273.04655290D0
	rhoarr( 26)=     2872.98698046D0
	rhoarr( 27)=     2569.87821899D0
	rhoarr( 28)=     2330.68216017D0
	rhoarr( 29)=     2131.64066790D0
	rhoarr( 30)=     1956.42724963D0
	rhoarr( 31)=     1794.51194163D0
	rhoarr( 32)=     1639.78294168D0
	rhoarr( 33)=     1489.38069182D0
	rhoarr( 34)=     1342.70382381D0
	rhoarr( 35)=     1200.57175202D0
	rhoarr( 36)=     1064.54429326D0
	rhoarr( 37)=      936.40161351D0
	rhoarr( 38)=      817.78147297D0
	rhoarr( 39)=      709.95892351D0
	rhoarr( 40)=      613.74173410D0
	rhoarr( 41)=      529.44868502D0
	rhoarr( 42)=      456.94003577D0
	rhoarr( 43)=      395.67763967D0
	rhoarr( 44)=      344.80130693D0
	rhoarr( 45)=      303.21401203D0
	rhoarr( 46)=      269.67045400D0
	rhoarr( 47)=      242.86303896D0
	rhoarr( 48)=      221.49897209D0
	rhoarr( 49)=      204.36319509D0
	rhoarr( 50)=      190.36428970D0
	rhoarr( 51)=      178.56320782D0
	rhoarr( 52)=      168.18679880D0
	rhoarr( 53)=      158.62913135D0
	rhoarr( 54)=      149.44368137D0
	rhoarr( 55)=      140.32901877D0
	rhoarr( 56)=      131.11010351D0
	rhoarr( 57)=      121.71692176D0
	rhoarr( 58)=      112.16197367D0
	rhoarr( 59)=      102.51797095D0
	rhoarr( 60)=       92.89691971D0
	rhoarr( 61)=       83.43151414D0
	rhoarr( 62)=       74.25946608D0
	rhoarr( 63)=       65.51108794D0
	rhoarr( 64)=       57.30016946D0
	rhoarr( 65)=       49.71796701D0
	rhoarr( 66)=       42.82996386D0
	rhoarr( 67)=       36.67496114D0
	rhoarr( 68)=       31.26601582D0
	rhoarr( 69)=       26.59274580D0
	rhoarr( 70)=       22.62456230D0
	rhoarr( 71)=       19.31445182D0
	rhoarr( 72)=       16.60299983D0
	rhoarr( 73)=       14.42241238D0
	rhoarr( 74)=       12.70034422D0
	rhoarr( 75)=       11.36338179D0
	rhoarr( 76)=       10.34006225D0
	rhoarr( 77)=        9.56334250D0
	rhoarr( 78)=        8.97246891D0
	rhoarr( 79)=        8.51423937D0
	rhoarr( 80)=        8.14368915D0
	rhoarr( 81)=        7.82426650D0
	rhoarr( 82)=        7.52758636D0
	rhoarr( 83)=        7.23286048D0
	rhoarr( 84)=        6.92610040D0
	rhoarr( 85)=        6.59917967D0
	rhoarr( 86)=        6.24882766D0
	rhoarr( 87)=        5.87561318D0
	rhoarr( 88)=        5.48296339D0
	rhoarr( 89)=        5.07625389D0
	rhoarr( 90)=        4.66199715D0
	rhoarr( 91)=        4.24714915D0
	rhoarr( 92)=        3.83854609D0
	rhoarr( 93)=        3.44247494D0
	rhoarr( 94)=        3.06437328D0
	rhoarr( 95)=        2.70864740D0
	rhoarr( 96)=        2.37859180D0
	rhoarr( 97)=        2.07639110D0
	rhoarr( 98)=        1.80318431D0
	rhoarr( 99)=        1.55917283D0
	rhoarr(100)=        1.34375561D0
	rhoarr(101)=        1.15567780D0
	rhoarr(102)=        0.99318191D0
	rhoarr(103)=        0.85415320D0
	rhoarr(104)=        0.73625336D0
	rhoarr(105)=        0.63703865D0
	rhoarr(106)=        0.55406035D0
	rhoarr(107)=        0.48494682D0
	rhoarr(108)=        0.42746743D0
	rhoarr(109)=        0.37957948D0
	rhoarr(110)=        0.33945931D0
	rhoarr(111)=        0.30551963D0
	rhoarr(112)=        0.27641449D0
	rhoarr(113)=        0.25103408D0
	rhoarr(114)=        0.22849111D0
	rhoarr(115)=        0.20810091D0
	rhoarr(116)=        0.18935700D0
	rhoarr(117)=        0.17190419D0
	rhoarr(118)=        0.15551082D0
	rhoarr(119)=        0.14004154D0
	rhoarr(120)=        0.12543199D0
	rhoarr(121)=        0.11166622D0
	rhoarr(122)=        0.09875733D0
	rhoarr(123)=        0.08673182D0
	rhoarr(124)=        0.07561752D0
	rhoarr(125)=        0.06543503D0
	rhoarr(126)=        0.05619238D0
	rhoarr(127)=        0.04788242D0
	rhoarr(128)=        0.04048255D0
	rhoarr(129)=        0.03395611D0
	rhoarr(130)=        0.02825484D0
	rhoarr(131)=        0.02332194D0
	rhoarr(132)=        0.01909515D0
	rhoarr(133)=        0.01550951D0
	rhoarr(134)=        0.01249961D0
	rhoarr(135)=        0.01000121D0
	rhoarr(136)=        0.00795231D0
	rhoarr(137)=        0.00629372D0
	rhoarr(138)=        0.00496943D0
	rhoarr(139)=        0.00392684D0
	rhoarr(140)=        0.00311706D0
	rhoarr(141)=        0.00249535D0
	rhoarr(142)=        0.00202166D0
	rhoarr(143)=        0.00166120D0
	rhoarr(144)=        0.00138481D0
	rhoarr(145)=        0.00116910D0
	rhoarr(146)=        0.00099617D0
	rhoarr(147)=        0.00085303D0
	rhoarr(148)=        0.00073081D0
	rhoarr(149)=        0.00062381D0
	rhoarr(150)=        0.00052863D0
	rhoarr(151)=        0.00044338D0
	rhoarr(152)=        0.00036709D0
	rhoarr(153)=        0.00029929D0
	rhoarr(154)=        0.00023973D0
	rhoarr(155)=        0.00018821D0
	rhoarr(156)=        0.00014447D0
	rhoarr(157)=        0.00010816D0
	rhoarr(158)=        0.00007877D0
	rhoarr(159)=        0.00005568D0
	rhoarr(160)=        0.00003810D0
	rhoarr(161)=        0.00002519D0
	rhoarr(162)=        0.00001605D0
	rhoarr(163)=        0.00000983D0
	rhoarr(164)=        0.00000577D0
	rhoarr(165)=        0.00000323D0
	rhoarr(166)=        0.00000172D0
	rhoarr(167)=        0.00000085D0
	rhoarr(168)=        0.00000039D0
	rhoarr(169)=        0.00000016D0
	rhoarr(170)=        0.00000006D0
	rhoarr(171)=        0.00000002D0

else if (iele==56) then  !Ba, 0 1, b3lyp/ANO-RCC int=dkh2
	npt=  170
	rhoarr(  1)=   857584.51502085D0
	rhoarr(  2)=   550653.62489272D0
	rhoarr(  3)=   397809.02358167D0
	rhoarr(  4)=   306599.62892567D0
	rhoarr(  5)=   244043.08935394D0
	rhoarr(  6)=   197896.31124493D0
	rhoarr(  7)=   161970.38935114D0
	rhoarr(  8)=   132972.50711675D0
	rhoarr(  9)=   109140.66429691D0
	rhoarr( 10)=    89344.29072560D0
	rhoarr( 11)=    72755.71168593D0
	rhoarr( 12)=    58899.22180288D0
	rhoarr( 13)=    47352.76085215D0
	rhoarr( 14)=    37782.92501971D0
	rhoarr( 15)=    29933.83365159D0
	rhoarr( 16)=    23565.50425685D0
	rhoarr( 17)=    18456.07328864D0
	rhoarr( 18)=    14412.78218275D0
	rhoarr( 19)=    11262.34269978D0
	rhoarr( 20)=     8844.28077345D0
	rhoarr( 21)=     7014.60324520D0
	rhoarr( 22)=     5649.34435724D0
	rhoarr( 23)=     4643.46239458D0
	rhoarr( 24)=     3908.38145340D0
	rhoarr( 25)=     3370.81066548D0
	rhoarr( 26)=     2972.25843805D0
	rhoarr( 27)=     2667.93659133D0
	rhoarr( 28)=     2424.82568699D0
	rhoarr( 29)=     2219.46196098D0
	rhoarr( 30)=     2035.94640533D0
	rhoarr( 31)=     1864.29967208D0
	rhoarr( 32)=     1699.06788922D0
	rhoarr( 33)=     1538.08484647D0
	rhoarr( 34)=     1381.37534971D0
	rhoarr( 35)=     1230.23382562D0
	rhoarr( 36)=     1086.51025390D0
	rhoarr( 37)=      952.10661363D0
	rhoarr( 38)=      828.65799333D0
	rhoarr( 39)=      717.35684765D0
	rhoarr( 40)=      618.87809796D0
	rhoarr( 41)=      533.37167733D0
	rhoarr( 42)=      460.50055381D0
	rhoarr( 43)=      399.51067750D0
	rhoarr( 44)=      349.32272822D0
	rhoarr( 45)=      308.63546172D0
	rhoarr( 46)=      276.02979571D0
	rhoarr( 47)=      250.06370963D0
	rhoarr( 48)=      229.35091746D0
	rhoarr( 49)=      212.62006417D0
	rhoarr( 50)=      198.75453051D0
	rhoarr( 51)=      186.81499365D0
	rhoarr( 52)=      176.04765582D0
	rhoarr( 53)=      165.88100300D0
	rhoarr( 54)=      155.91364901D0
	rhoarr( 55)=      145.89558846D0
	rhoarr( 56)=      135.70507224D0
	rhoarr( 57)=      125.32322148D0
	rhoarr( 58)=      114.80829425D0
	rhoarr( 59)=      104.27118848D0
	rhoarr( 60)=       93.85335412D0
	rhoarr( 61)=       83.70787737D0
	rhoarr( 62)=       73.98414231D0
	rhoarr( 63)=       64.81618711D0
	rhoarr( 64)=       56.31464428D0
	rhoarr( 65)=       48.56197214D0
	rhoarr( 66)=       41.61054583D0
	rhoarr( 67)=       35.48308449D0
	rhoarr( 68)=       30.17485644D0
	rhoarr( 69)=       25.65712340D0
	rhoarr( 70)=       21.88134814D0
	rhoarr( 71)=       18.78377313D0
	rhoarr( 72)=       16.29006161D0
	rhoarr( 73)=       14.31976160D0
	rhoarr( 74)=       12.79040484D0
	rhoarr( 75)=       11.62109384D0
	rhoarr( 76)=       10.73546868D0
	rhoarr( 77)=       10.06398813D0
	rhoarr( 78)=        9.54550709D0
	rhoarr( 79)=        9.12817941D0
	rhoarr( 80)=        8.76975577D0
	rhoarr( 81)=        8.43737419D0
	rhoarr( 82)=        8.10695468D0
	rhoarr( 83)=        7.76230972D0
	rhoarr( 84)=        7.39407309D0
	rhoarr( 85)=        6.99853516D0
	rhoarr( 86)=        6.57645688D0
	rhoarr( 87)=        6.13192058D0
	rhoarr( 88)=        5.67126261D0
	rhoarr( 89)=        5.20212220D0
	rhoarr( 90)=        4.73263018D0
	rhoarr( 91)=        4.27075114D0
	rhoarr( 92)=        3.82378238D0
	rhoarr( 93)=        3.39800388D0
	rhoarr( 94)=        2.99846601D0
	rhoarr( 95)=        2.62889629D0
	rhoarr( 96)=        2.29170363D0
	rhoarr( 97)=        1.98805772D0
	rhoarr( 98)=        1.71802198D0
	rhoarr( 99)=        1.48072034D0
	rhoarr(100)=        1.27452100D0
	rhoarr(101)=        1.09722279D0
	rhoarr(102)=        0.94623348D0
	rhoarr(103)=        0.81873212D0
	rhoarr(104)=        0.71181036D0
	rhoarr(105)=        0.62259067D0
	rhoarr(106)=        0.54832052D0
	rhoarr(107)=        0.48644388D0
	rhoarr(108)=        0.43465133D0
	rhoarr(109)=        0.39091135D0
	rhoarr(110)=        0.35348478D0
	rhoarr(111)=        0.32092514D0
	rhoarr(112)=        0.29206704D0
	rhoarr(113)=        0.26600519D0
	rhoarr(114)=        0.24206640D0
	rhoarr(115)=        0.21977698D0
	rhoarr(116)=        0.19882785D0
	rhoarr(117)=        0.17903944D0
	rhoarr(118)=        0.16032830D0
	rhoarr(119)=        0.14267689D0
	rhoarr(120)=        0.12610762D0
	rhoarr(121)=        0.11066163D0
	rhoarr(122)=        0.09638253D0
	rhoarr(123)=        0.08330496D0
	rhoarr(124)=        0.07144727D0
	rhoarr(125)=        0.06080785D0
	rhoarr(126)=        0.05136436D0
	rhoarr(127)=        0.04307490D0
	rhoarr(128)=        0.03588061D0
	rhoarr(129)=        0.02970895D0
	rhoarr(130)=        0.02447711D0
	rhoarr(131)=        0.02009541D0
	rhoarr(132)=        0.01647034D0
	rhoarr(133)=        0.01350733D0
	rhoarr(134)=        0.01111317D0
	rhoarr(135)=        0.00919819D0
	rhoarr(136)=        0.00767817D0
	rhoarr(137)=        0.00647609D0
	rhoarr(138)=        0.00552344D0
	rhoarr(139)=        0.00476128D0
	rhoarr(140)=        0.00414076D0
	rhoarr(141)=        0.00362309D0
	rhoarr(142)=        0.00317899D0
	rhoarr(143)=        0.00278763D0
	rhoarr(144)=        0.00243524D0
	rhoarr(145)=        0.00211352D0
	rhoarr(146)=        0.00181808D0
	rhoarr(147)=        0.00154706D0
	rhoarr(148)=        0.00130000D0
	rhoarr(149)=        0.00107704D0
	rhoarr(150)=        0.00087839D0
	rhoarr(151)=        0.00070406D0
	rhoarr(152)=        0.00055367D0
	rhoarr(153)=        0.00042641D0
	rhoarr(154)=        0.00032100D0
	rhoarr(155)=        0.00023575D0
	rhoarr(156)=        0.00016856D0
	rhoarr(157)=        0.00011709D0
	rhoarr(158)=        0.00007883D0
	rhoarr(159)=        0.00005130D0
	rhoarr(160)=        0.00003216D0
	rhoarr(161)=        0.00001935D0
	rhoarr(162)=        0.00001111D0
	rhoarr(163)=        0.00000605D0
	rhoarr(164)=        0.00000310D0
	rhoarr(165)=        0.00000149D0
	rhoarr(166)=        0.00000066D0
	rhoarr(167)=        0.00000027D0
	rhoarr(168)=        0.00000010D0
	rhoarr(169)=        0.00000004D0
	rhoarr(170)=        0.00000001D0

else if (iele==57) then  !La, 5d1 6s2, 0 2, B3LYP/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=   491088.20908739D0
	rhoarr(  2)=   477445.29124906D0
	rhoarr(  3)=   426900.61566363D0
	rhoarr(  4)=   338969.67580359D0
	rhoarr(  5)=   259057.83187029D0
	rhoarr(  6)=   210185.48480227D0
	rhoarr(  7)=   172788.14341896D0
	rhoarr(  8)=   140315.90773678D0
	rhoarr(  9)=   114609.16317018D0
	rhoarr( 10)=    93713.60633748D0
	rhoarr( 11)=    76049.32313223D0
	rhoarr( 12)=    61232.12796046D0
	rhoarr( 13)=    48992.80558224D0
	rhoarr( 14)=    38948.94466518D0
	rhoarr( 15)=    30742.47338126D0
	rhoarr( 16)=    24099.96854952D0
	rhoarr( 17)=    18799.82745908D0
	rhoarr( 18)=    14637.59938849D0
	rhoarr( 19)=    11419.65054579D0
	rhoarr( 20)=     8967.97249059D0
	rhoarr( 21)=     7125.08443804D0
	rhoarr( 22)=     5756.60590763D0
	rhoarr( 23)=     4750.70029615D0
	rhoarr( 24)=     4015.60326697D0
	rhoarr( 25)=     3477.09657015D0
	rhoarr( 26)=     3076.47018203D0
	rhoarr( 27)=     2768.61592766D0
	rhoarr( 28)=     2520.07569076D0
	rhoarr( 29)=     2307.16432472D0
	rhoarr( 30)=     2114.22681001D0
	rhoarr( 31)=     1931.95635525D0
	rhoarr( 32)=     1755.74453480D0
	rhoarr( 33)=     1584.16495353D0
	rhoarr( 34)=     1417.73222828D0
	rhoarr( 35)=     1257.99835737D0
	rhoarr( 36)=     1106.94099588D0
	rhoarr( 37)=      966.54783736D0
	rhoarr( 38)=      838.51977678D0
	rhoarr( 39)=      724.06226931D0
	rhoarr( 40)=      623.76705515D0
	rhoarr( 41)=      537.58999469D0
	rhoarr( 42)=      464.91487384D0
	rhoarr( 43)=      404.67557735D0
	rhoarr( 44)=      355.50199357D0
	rhoarr( 45)=      315.86016377D0
	rhoarr( 46)=      284.16925517D0
	rhoarr( 47)=      258.89017100D0
	rhoarr( 48)=      238.58864733D0
	rhoarr( 49)=      221.97855871D0
	rhoarr( 50)=      207.95032044D0
	rhoarr( 51)=      195.58704423D0
	rhoarr( 52)=      184.16936418D0
	rhoarr( 53)=      173.16944710D0
	rhoarr( 54)=      162.23543867D0
	rhoarr( 55)=      151.16870030D0
	rhoarr( 56)=      139.89688697D0
	rhoarr( 57)=      128.44584339D0
	rhoarr( 58)=      116.91257649D0
	rhoarr( 59)=      105.44060529D0
	rhoarr( 60)=       94.19819890D0
	rhoarr( 61)=       83.35960441D0
	rhoarr( 62)=       73.08931264D0
	rhoarr( 63)=       63.52953717D0
	rhoarr( 64)=       54.79118338D0
	rhoarr( 65)=       46.94852819D0
	rhoarr( 66)=       40.03759804D0
	rhoarr( 67)=       34.05789691D0
	rhoarr( 68)=       28.97681427D0
	rhoarr( 69)=       24.73583234D0
	rhoarr( 70)=       21.25759848D0
	rhoarr( 71)=       18.45302075D0
	rhoarr( 72)=       16.22773392D0
	rhoarr( 73)=       14.48751172D0
	rhoarr( 74)=       13.14242265D0
	rhoarr( 75)=       12.10971351D0
	rhoarr( 76)=       11.31554462D0
	rhoarr( 77)=       10.69579040D0
	rhoarr( 78)=       10.19615750D0
	rhoarr( 79)=        9.77186549D0
	rhoarr( 80)=        9.38708948D0
	rhoarr( 81)=        9.01429771D0
	rhoarr( 82)=        8.63354729D0
	rhoarr( 83)=        8.23174748D0
	rhoarr( 84)=        7.80187093D0
	rhoarr( 85)=        7.34209139D0
	rhoarr( 86)=        6.85484385D0
	rhoarr( 87)=        6.34582757D0
	rhoarr( 88)=        5.82299438D0
	rhoarr( 89)=        5.29557550D0
	rhoarr( 90)=        4.77319882D0
	rhoarr( 91)=        4.26513855D0
	rhoarr( 92)=        3.77972263D0
	rhoarr( 93)=        3.32390781D0
	rhoarr( 94)=        2.90301817D0
	rhoarr( 95)=        2.52063337D0
	rhoarr( 96)=        2.17860656D0
	rhoarr( 97)=        1.87718834D0
	rhoarr( 98)=        1.61523173D0
	rhoarr( 99)=        1.39045210D0
	rhoarr(100)=        1.19971718D0
	rhoarr(101)=        1.03934329D0
	rhoarr(102)=        0.90537703D0
	rhoarr(103)=        0.79384490D0
	rhoarr(104)=        0.70095835D0
	rhoarr(105)=        0.62326601D0
	rhoarr(106)=        0.55775086D0
	rhoarr(107)=        0.50187436D0
	rhoarr(108)=        0.45357476D0
	rhoarr(109)=        0.41122969D0
	rhoarr(110)=        0.37359556D0
	rhoarr(111)=        0.33973635D0
	rhoarr(112)=        0.30895303D0
	rhoarr(113)=        0.28072191D0
	rhoarr(114)=        0.25464648D0
	rhoarr(115)=        0.23042377D0
	rhoarr(116)=        0.20782319D0
	rhoarr(117)=        0.18667414D0
	rhoarr(118)=        0.16685833D0
	rhoarr(119)=        0.14830340D0
	rhoarr(120)=        0.13097552D0
	rhoarr(121)=        0.11487027D0
	rhoarr(122)=        0.10000211D0
	rhoarr(123)=        0.08639315D0
	rhoarr(124)=        0.07406267D0
	rhoarr(125)=        0.06301808D0
	rhoarr(126)=        0.05324823D0
	rhoarr(127)=        0.04471948D0
	rhoarr(128)=        0.03737446D0
	rhoarr(129)=        0.03113350D0
	rhoarr(130)=        0.02589829D0
	rhoarr(131)=        0.02155716D0
	rhoarr(132)=        0.01799138D0
	rhoarr(133)=        0.01508150D0
	rhoarr(134)=        0.01271335D0
	rhoarr(135)=        0.01078276D0
	rhoarr(136)=        0.00919888D0
	rhoarr(137)=        0.00788587D0
	rhoarr(138)=        0.00678303D0
	rhoarr(139)=        0.00584366D0
	rhoarr(140)=        0.00503312D0
	rhoarr(141)=        0.00432639D0
	rhoarr(142)=        0.00370565D0
	rhoarr(143)=        0.00315809D0
	rhoarr(144)=        0.00267427D0
	rhoarr(145)=        0.00224693D0
	rhoarr(146)=        0.00187029D0
	rhoarr(147)=        0.00153964D0
	rhoarr(148)=        0.00125115D0
	rhoarr(149)=        0.00100162D0
	rhoarr(150)=        0.00078834D0
	rhoarr(151)=        0.00060878D0
	rhoarr(152)=        0.00046038D0
	rhoarr(153)=        0.00034034D0
	rhoarr(154)=        0.00024557D0
	rhoarr(155)=        0.00017269D0
	rhoarr(156)=        0.00011817D0
	rhoarr(157)=        0.00007854D0
	rhoarr(158)=        0.00005059D0
	rhoarr(159)=        0.00003149D0
	rhoarr(160)=        0.00001886D0
	rhoarr(161)=        0.00001083D0
	rhoarr(162)=        0.00000593D0
	rhoarr(163)=        0.00000308D0
	rhoarr(164)=        0.00000151D0
	rhoarr(165)=        0.00000069D0
	rhoarr(166)=        0.00000030D0
	rhoarr(167)=        0.00000012D0
	rhoarr(168)=        0.00000004D0
	rhoarr(169)=        0.00000002D0

else if (iele==58) then  !Ce, 4f1 5d1 6s2, 0 3, B3LYP/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=   536286.08393832D0
	rhoarr(  2)=   520644.89788817D0
	rhoarr(  3)=   463048.49816835D0
	rhoarr(  4)=   364412.67286067D0
	rhoarr(  5)=   276989.76597548D0
	rhoarr(  6)=   224162.50338599D0
	rhoarr(  7)=   183296.32857455D0
	rhoarr(  8)=   148172.63713613D0
	rhoarr(  9)=   120593.40030655D0
	rhoarr( 10)=    98195.34847978D0
	rhoarr( 11)=    79328.44729387D0
	rhoarr( 12)=    63596.80541052D0
	rhoarr( 13)=    50672.79392454D0
	rhoarr( 14)=    40115.89668910D0
	rhoarr( 15)=    31531.10136071D0
	rhoarr( 16)=    24620.37244896D0
	rhoarr( 17)=    19139.39383254D0
	rhoarr( 18)=    14862.00179822D0
	rhoarr( 19)=    11575.73584877D0
	rhoarr( 20)=     9087.42146845D0
	rhoarr( 21)=     7228.13230663D0
	rhoarr( 22)=     5855.23061447D0
	rhoarr( 23)=     4850.97337527D0
	rhoarr( 24)=     4119.43309489D0
	rhoarr( 25)=     3583.65488653D0
	rhoarr( 26)=     3183.36123383D0
	rhoarr( 27)=     2872.76794527D0
	rhoarr( 28)=     2618.39407947D0
	rhoarr( 29)=     2397.00120939D0
	rhoarr( 30)=     2193.67682150D0
	rhoarr( 31)=     1999.97017734D0
	rhoarr( 32)=     1812.08540013D0
	rhoarr( 33)=     1629.27216550D0
	rhoarr( 34)=     1452.55836369D0
	rhoarr( 35)=     1283.85725173D0
	rhoarr( 36)=     1125.37169461D0
	rhoarr( 37)=      979.18651296D0
	rhoarr( 38)=      846.97684438D0
	rhoarr( 39)=      729.81274981D0
	rhoarr( 40)=      628.06726236D0
	rhoarr( 41)=      541.42984571D0
	rhoarr( 42)=      469.00641024D0
	rhoarr( 43)=      409.47031900D0
	rhoarr( 44)=      361.22603145D0
	rhoarr( 45)=      322.55666343D0
	rhoarr( 46)=      291.74138401D0
	rhoarr( 47)=      267.14109368D0
	rhoarr( 48)=      247.25768551D0
	rhoarr( 49)=      230.77352938D0
	rhoarr( 50)=      216.57590904D0
	rhoarr( 51)=      203.76858588D0
	rhoarr( 52)=      191.67120224D0
	rhoarr( 53)=      179.80732672D0
	rhoarr( 54)=      167.88301995D0
	rhoarr( 55)=      155.75890712D0
	rhoarr( 56)=      143.41917039D0
	rhoarr( 57)=      130.94045695D0
	rhoarr( 58)=      118.46275015D0
	rhoarr( 59)=      106.16325726D0
	rhoarr( 60)=       94.23369313D0
	rhoarr( 61)=       82.86108389D0
	rhoarr( 62)=       72.21225259D0
	rhoarr( 63)=       62.42225302D0
	rhoarr( 64)=       53.58700207D0
	rhoarr( 65)=       45.76015507D0
	rhoarr( 66)=       38.95392089D0
	rhoarr( 67)=       33.14314365D0
	rhoarr( 68)=       28.27170527D0
	rhoarr( 69)=       24.26019692D0
	rhoarr( 70)=       21.01387292D0
	rhoarr( 71)=       18.43009069D0
	rhoarr( 72)=       16.40469139D0
	rhoarr( 73)=       14.83702961D0
	rhoarr( 74)=       13.63358078D0
	rhoarr( 75)=       12.71022562D0
	rhoarr( 76)=       11.99342471D0
	rhoarr( 77)=       11.42055480D0
	rhoarr( 78)=       10.93968331D0
	rhoarr( 79)=       10.50901754D0
	rhoarr( 80)=       10.09619641D0
	rhoarr( 81)=        9.67751449D0
	rhoarr( 82)=        9.23710324D0
	rhoarr( 83)=        8.76605482D0
	rhoarr( 84)=        8.26146503D0
	rhoarr( 85)=        7.72538736D0
	rhoarr( 86)=        7.16371652D0
	rhoarr( 87)=        6.58504583D0
	rhoarr( 88)=        5.99955778D0
	rhoarr( 89)=        5.41800882D0
	rhoarr( 90)=        4.85085862D0
	rhoarr( 91)=        4.30757678D0
	rhoarr( 92)=        3.79614075D0
	rhoarr( 93)=        3.32272185D0
	rhoarr( 94)=        2.89154402D0
	rhoarr( 95)=        2.50489214D0
	rhoarr( 96)=        2.16324263D0
	rhoarr( 97)=        1.86548692D0
	rhoarr( 98)=        1.60921881D0
	rhoarr( 99)=        1.39105707D0
	rhoarr(100)=        1.20697687D0
	rhoarr(101)=        1.05262646D0
	rhoarr(102)=        0.92360949D0
	rhoarr(103)=        0.81571813D0
	rhoarr(104)=        0.72510782D0
	rhoarr(105)=        0.64840998D0
	rhoarr(106)=        0.58278511D0
	rhoarr(107)=        0.52592364D0
	rhoarr(108)=        0.47600590D0
	rhoarr(109)=        0.43163516D0
	rhoarr(110)=        0.39175790D0
	rhoarr(111)=        0.35558416D0
	rhoarr(112)=        0.32251748D0
	rhoarr(113)=        0.29209991D0
	rhoarr(114)=        0.26397362D0
	rhoarr(115)=        0.23785706D0
	rhoarr(116)=        0.21353172D0
	rhoarr(117)=        0.19083483D0
	rhoarr(118)=        0.16965418D0
	rhoarr(119)=        0.14992196D0
	rhoarr(120)=        0.13160672D0
	rhoarr(121)=        0.11470313D0
	rhoarr(122)=        0.09922047D0
	rhoarr(123)=        0.08517096D0
	rhoarr(124)=        0.07255914D0
	rhoarr(125)=        0.06137329D0
	rhoarr(126)=        0.05157959D0
	rhoarr(127)=        0.04311933D0
	rhoarr(128)=        0.03590933D0
	rhoarr(129)=        0.02984500D0
	rhoarr(130)=        0.02480560D0
	rhoarr(131)=        0.02066093D0
	rhoarr(132)=        0.01727828D0
	rhoarr(133)=        0.01452915D0
	rhoarr(134)=        0.01229481D0
	rhoarr(135)=        0.01047031D0
	rhoarr(136)=        0.00896681D0
	rhoarr(137)=        0.00771217D0
	rhoarr(138)=        0.00665016D0
	rhoarr(139)=        0.00573858D0
	rhoarr(140)=        0.00494670D0
	rhoarr(141)=        0.00425262D0
	rhoarr(142)=        0.00364074D0
	rhoarr(143)=        0.00309975D0
	rhoarr(144)=        0.00262109D0
	rhoarr(145)=        0.00219802D0
	rhoarr(146)=        0.00182513D0
	rhoarr(147)=        0.00149798D0
	rhoarr(148)=        0.00121296D0
	rhoarr(149)=        0.00096708D0
	rhoarr(150)=        0.00075769D0
	rhoarr(151)=        0.00058226D0
	rhoarr(152)=        0.00043810D0
	rhoarr(153)=        0.00032224D0
	rhoarr(154)=        0.00023137D0
	rhoarr(155)=        0.00016192D0
	rhoarr(156)=        0.00011029D0
	rhoarr(157)=        0.00007297D0
	rhoarr(158)=        0.00004677D0
	rhoarr(159)=        0.00002896D0
	rhoarr(160)=        0.00001724D0
	rhoarr(161)=        0.00000983D0
	rhoarr(162)=        0.00000534D0
	rhoarr(163)=        0.00000275D0
	rhoarr(164)=        0.00000133D0
	rhoarr(165)=        0.00000061D0
	rhoarr(166)=        0.00000026D0
	rhoarr(167)=        0.00000010D0
	rhoarr(168)=        0.00000004D0
	rhoarr(169)=        0.00000001D0

else if (iele==59) then  !Pr, 4f3 6s2, 0 4, B3LYP/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=   585269.39205276D0
	rhoarr(  2)=   567362.45202019D0
	rhoarr(  3)=   501831.60592073D0
	rhoarr(  4)=   391387.54823081D0
	rhoarr(  5)=   295925.41611549D0
	rhoarr(  6)=   238850.48133436D0
	rhoarr(  7)=   194241.25306236D0
	rhoarr(  8)=   156318.41176685D0
	rhoarr(  9)=   126763.69509518D0
	rhoarr( 10)=   102780.94629846D0
	rhoarr( 11)=    82658.32745650D0
	rhoarr( 12)=    65980.76745503D0
	rhoarr( 13)=    52352.99644764D0
	rhoarr( 14)=    41272.13073173D0
	rhoarr( 15)=    32304.60401388D0
	rhoarr( 16)=    25125.93599039D0
	rhoarr( 17)=    19467.00265471D0
	rhoarr( 18)=    15078.32898923D0
	rhoarr( 19)=    11727.60750379D0
	rhoarr( 20)=     9205.95504415D0
	rhoarr( 21)=     7332.79926744D0
	rhoarr( 22)=     5957.20133297D0
	rhoarr( 23)=     4955.53072690D0
	rhoarr( 24)=     4227.77682829D0
	rhoarr( 25)=     3694.38208852D0
	rhoarr( 26)=     3293.65791801D0
	rhoarr( 27)=     2979.30193845D0
	rhoarr( 28)=     2717.96444290D0
	rhoarr( 29)=     2486.99477913D0
	rhoarr( 30)=     2272.33251786D0
	rhoarr( 31)=     2066.44753606D0
	rhoarr( 32)=     1866.37857902D0
	rhoarr( 33)=     1672.04539334D0
	rhoarr( 34)=     1484.96935061D0
	rhoarr( 35)=     1307.39798857D0
	rhoarr( 36)=     1141.72529371D0
	rhoarr( 37)=      990.09119180D0
	rhoarr( 38)=      854.09758507D0
	rhoarr( 39)=      734.63215416D0
	rhoarr( 40)=      631.80946038D0
	rhoarr( 41)=      545.02461427D0
	rhoarr( 42)=      473.09062264D0
	rhoarr( 43)=      414.41641200D0
	rhoarr( 44)=      367.18499405D0
	rhoarr( 45)=      329.50530136D0
	rhoarr( 46)=      299.52776718D0
	rhoarr( 47)=      275.52580613D0
	rhoarr( 48)=      255.95058525D0
	rhoarr( 49)=      239.46619827D0
	rhoarr( 50)=      224.96954245D0
	rhoarr( 51)=      211.59656973D0
	rhoarr( 52)=      198.71557689D0
	rhoarr( 53)=      185.90880981D0
	rhoarr( 54)=      172.94497293D0
	rhoarr( 55)=      159.74621615D0
	rhoarr( 56)=      146.35325278D0
	rhoarr( 57)=      132.89151296D0
	rhoarr( 58)=      119.54013315D0
	rhoarr( 59)=      106.50463089D0
	rhoarr( 60)=       93.99358691D0
	rhoarr( 61)=       82.19952900D0
	rhoarr( 62)=       71.28427343D0
	rhoarr( 63)=       61.36899278D0
	rhoarr( 64)=       52.52911167D0
	rhoarr( 65)=       44.79378725D0
	rhoarr( 66)=       38.14932154D0
	rhoarr( 67)=       32.54551203D0
	rhoarr( 68)=       27.90377623D0
	rhoarr( 69)=       24.12590945D0
	rhoarr( 70)=       21.10251643D0
	rhoarr( 71)=       18.72042648D0
	rhoarr( 72)=       16.86868889D0
	rhoarr( 73)=       15.44300420D0
	rhoarr( 74)=       14.34865179D0
	rhoarr( 75)=       13.50211854D0
	rhoarr( 76)=       12.83171497D0
	rhoarr( 77)=       12.27748719D0
	rhoarr( 78)=       11.79070215D0
	rhoarr( 79)=       11.33311532D0
	rhoarr( 80)=       10.87614475D0
	rhoarr( 81)=       10.39999766D0
	rhoarr( 82)=        9.89274300D0
	rhoarr( 83)=        9.34930401D0
	rhoarr( 84)=        8.77035409D0
	rhoarr( 85)=        8.16112640D0
	rhoarr( 86)=        7.53017670D0
	rhoarr( 87)=        6.88816010D0
	rhoarr( 88)=        6.24668841D0
	rhoarr( 89)=        5.61732797D0
	rhoarr( 90)=        5.01078056D0
	rhoarr( 91)=        4.43626978D0
	rhoarr( 92)=        3.90113590D0
	rhoarr( 93)=        3.41062658D0
	rhoarr( 94)=        2.96786057D0
	rhoarr( 95)=        2.57393507D0
	rhoarr( 96)=        2.22814466D0
	rhoarr( 97)=        1.92827894D0
	rhoarr( 98)=        1.67096704D0
	rhoarr( 99)=        1.45203941D0
	rhoarr(100)=        1.26688017D0
	rhoarr(101)=        1.11074781D0
	rhoarr(102)=        0.97904631D0
	rhoarr(103)=        0.86753457D0
	rhoarr(104)=        0.77246802D0
	rhoarr(105)=        0.69067225D0
	rhoarr(106)=        0.61955524D0
	rhoarr(107)=        0.55706942D0
	rhoarr(108)=        0.50163907D0
	rhoarr(109)=        0.45206970D0
	rhoarr(110)=        0.40745519D0
	rhoarr(111)=        0.36709509D0
	rhoarr(112)=        0.33042980D0
	rhoarr(113)=        0.29699608D0
	rhoarr(114)=        0.26640124D0
	rhoarr(115)=        0.23831115D0
	rhoarr(116)=        0.21244649D0
	rhoarr(117)=        0.18858210D0
	rhoarr(118)=        0.16654556D0
	rhoarr(119)=        0.14621336D0
	rhoarr(120)=        0.12750389D0
	rhoarr(121)=        0.11036798D0
	rhoarr(122)=        0.09477797D0
	rhoarr(123)=        0.08071618D0
	rhoarr(124)=        0.06816408D0
	rhoarr(125)=        0.05709283D0
	rhoarr(126)=        0.04745621D0
	rhoarr(127)=        0.03918646D0
	rhoarr(128)=        0.03219331D0
	rhoarr(129)=        0.02636623D0
	rhoarr(130)=        0.02157916D0
	rhoarr(131)=        0.01769693D0
	rhoarr(132)=        0.01458232D0
	rhoarr(133)=        0.01210271D0
	rhoarr(134)=        0.01013558D0
	rhoarr(135)=        0.00857249D0
	rhoarr(136)=        0.00732126D0
	rhoarr(137)=        0.00630661D0
	rhoarr(138)=        0.00546935D0
	rhoarr(139)=        0.00476470D0
	rhoarr(140)=        0.00415992D0
	rhoarr(141)=        0.00363176D0
	rhoarr(142)=        0.00316402D0
	rhoarr(143)=        0.00274554D0
	rhoarr(144)=        0.00236859D0
	rhoarr(145)=        0.00202789D0
	rhoarr(146)=        0.00171988D0
	rhoarr(147)=        0.00144230D0
	rhoarr(148)=        0.00119378D0
	rhoarr(149)=        0.00097350D0
	rhoarr(150)=        0.00078082D0
	rhoarr(151)=        0.00061497D0
	rhoarr(152)=        0.00047480D0
	rhoarr(153)=        0.00035874D0
	rhoarr(154)=        0.00026475D0
	rhoarr(155)=        0.00019045D0
	rhoarr(156)=        0.00013323D0
	rhoarr(157)=        0.00009040D0
	rhoarr(158)=        0.00005931D0
	rhoarr(159)=        0.00003751D0
	rhoarr(160)=        0.00002279D0
	rhoarr(161)=        0.00001326D0
	rhoarr(162)=        0.00000736D0
	rhoarr(163)=        0.00000389D0
	rhoarr(164)=        0.00000195D0
	rhoarr(165)=        0.00000093D0
	rhoarr(166)=        0.00000042D0
	rhoarr(167)=        0.00000018D0
	rhoarr(168)=        0.00000007D0
	rhoarr(169)=        0.00000002D0

else if (iele==60) then  !Nd, 4f4 6s2, 0 5, B3LYP/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=   638389.05642068D0
	rhoarr(  2)=   617916.59921130D0
	rhoarr(  3)=   543470.20395914D0
	rhoarr(  4)=   420015.61571612D0
	rhoarr(  5)=   315947.37950754D0
	rhoarr(  6)=   254298.72925350D0
	rhoarr(  7)=   205654.39990811D0
	rhoarr(  8)=   164775.73344768D0
	rhoarr(  9)=   133133.83137785D0
	rhoarr( 10)=   107479.19634832D0
	rhoarr( 11)=    86045.39943791D0
	rhoarr( 12)=    68388.91320275D0
	rhoarr( 13)=    54037.24532352D0
	rhoarr( 14)=    42420.95834148D0
	rhoarr( 15)=    33066.19378352D0
	rhoarr( 16)=    25619.92404337D0
	rhoarr( 17)=    19785.97979678D0
	rhoarr( 18)=    15289.93071194D0
	rhoarr( 19)=    11878.59018683D0
	rhoarr( 20)=     9326.83488873D0
	rhoarr( 21)=     7442.25340088D0
	rhoarr( 22)=     6065.55831879D0
	rhoarr( 23)=     5067.25164413D0
	rhoarr( 24)=     4343.32961116D0
	rhoarr( 25)=     3811.77671595D0
	rhoarr( 26)=     3409.65824703D0
	rhoarr( 27)=     3090.32050076D0
	rhoarr( 28)=     2820.70831899D0
	rhoarr( 29)=     2578.90539384D0
	rhoarr( 30)=     2351.81283780D0
	rhoarr( 31)=     2132.88256917D0
	rhoarr( 32)=     1920.00787225D0
	rhoarr( 33)=     1713.77293397D0
	rhoarr( 34)=     1516.17423130D0
	rhoarr( 35)=     1329.76672929D0
	rhoarr( 36)=     1157.09927149D0
	rhoarr( 37)=     1000.32119853D0
	rhoarr( 38)=      860.91016816D0
	rhoarr( 39)=      739.52227786D0
	rhoarr( 40)=      635.97306516D0
	rhoarr( 41)=      549.33524405D0
	rhoarr( 42)=      478.11356700D0
	rhoarr( 43)=      420.44746076D0
	rhoarr( 44)=      374.30045424D0
	rhoarr( 45)=      337.61353198D0
	rhoarr( 46)=      308.41718043D0
	rhoarr( 47)=      284.90783490D0
	rhoarr( 48)=      265.49772238D0
	rhoarr( 49)=      248.84524932D0
	rhoarr( 50)=      233.86961832D0
	rhoarr( 51)=      219.75092234D0
	rhoarr( 52)=      205.91654641D0
	rhoarr( 53)=      192.01580740D0
	rhoarr( 54)=      177.88618554D0
	rhoarr( 55)=      163.51522849D0
	rhoarr( 56)=      149.00189863D0
	rhoarr( 57)=      134.52009600D0
	rhoarr( 58)=      120.28591300D0
	rhoarr( 59)=      106.52932763D0
	rhoarr( 60)=       93.47066377D0
	rhoarr( 61)=       81.30209444D0
	rhoarr( 62)=       70.17447610D0
	rhoarr( 63)=       60.18967268D0
	rhoarr( 64)=       51.39820146D0
	rhoarr( 65)=       43.80158925D0
	rhoarr( 66)=       37.35841663D0
	rhoarr( 67)=       31.99277648D0
	rhoarr( 68)=       27.60383857D0
	rhoarr( 69)=       24.07537106D0
	rhoarr( 70)=       21.28435132D0
	rhoarr( 71)=       19.10812092D0
	rhoarr( 72)=       17.42984130D0
	rhoarr( 73)=       16.14225326D0
	rhoarr( 74)=       15.14992329D0
	rhoarr( 75)=       14.37027003D0
	rhoarr( 76)=       13.73370786D0
	rhoarr( 77)=       13.18322712D0
	rhoarr( 78)=       12.67366559D0
	rhoarr( 79)=       12.17083569D0
	rhoarr( 80)=       11.65058098D0
	rhoarr( 81)=       11.09776864D0
	rhoarr( 82)=       10.50519235D0
	rhoarr( 83)=        9.87236318D0
	rhoarr( 84)=        9.20419244D0
	rhoarr( 85)=        8.50960494D0
	rhoarr( 86)=        7.80014806D0
	rhoarr( 87)=        7.08867455D0
	rhoarr( 88)=        6.38817203D0
	rhoarr( 89)=        5.71079470D0
	rhoarr( 90)=        5.06712900D0
	rhoarr( 91)=        4.46570066D0
	rhoarr( 92)=        3.91271077D0
	rhoarr( 93)=        3.41197437D0
	rhoarr( 94)=        2.96502712D0
	rhoarr( 95)=        2.57136186D0
	rhoarr( 96)=        2.22875676D0
	rhoarr( 97)=        1.93365832D0
	rhoarr( 98)=        1.68158546D0
	rhoarr( 99)=        1.46752461D0
	rhoarr(100)=        1.28629038D0
	rhoarr(101)=        1.13283148D0
	rhoarr(102)=        1.00246791D0
	rhoarr(103)=        0.89105202D0
	rhoarr(104)=        0.79505352D0
	rhoarr(105)=        0.71157544D0
	rhoarr(106)=        0.63831409D0
	rhoarr(107)=        0.57348033D0
	rhoarr(108)=        0.51570092D0
	rhoarr(109)=        0.46391731D0
	rhoarr(110)=        0.41729578D0
	rhoarr(111)=        0.37515715D0
	rhoarr(112)=        0.33692898D0
	rhoarr(113)=        0.30211816D0
	rhoarr(114)=        0.27029881D0
	rhoarr(115)=        0.24110940D0
	rhoarr(116)=        0.21425320D0
	rhoarr(117)=        0.18949803D0
	rhoarr(118)=        0.16667301D0
	rhoarr(119)=        0.14566159D0
	rhoarr(120)=        0.12639129D0
	rhoarr(121)=        0.10882107D0
	rhoarr(122)=        0.09292763D0
	rhoarr(123)=        0.07869192D0
	rhoarr(124)=        0.06608711D0
	rhoarr(125)=        0.05506919D0
	rhoarr(126)=        0.04557109D0
	rhoarr(127)=        0.03750064D0
	rhoarr(128)=        0.03074234D0
	rhoarr(129)=        0.02516222D0
	rhoarr(130)=        0.02061461D0
	rhoarr(131)=        0.01694989D0
	rhoarr(132)=        0.01402181D0
	rhoarr(133)=        0.01169379D0
	rhoarr(134)=        0.00984349D0
	rhoarr(135)=        0.00836568D0
	rhoarr(136)=        0.00717326D0
	rhoarr(137)=        0.00619685D0
	rhoarr(138)=        0.00538309D0
	rhoarr(139)=        0.00469233D0
	rhoarr(140)=        0.00409581D0
	rhoarr(141)=        0.00357303D0
	rhoarr(142)=        0.00310940D0
	rhoarr(143)=        0.00269452D0
	rhoarr(144)=        0.00232096D0
	rhoarr(145)=        0.00198350D0
	rhoarr(146)=        0.00167863D0
	rhoarr(147)=        0.00140418D0
	rhoarr(148)=        0.00115889D0
	rhoarr(149)=        0.00094201D0
	rhoarr(150)=        0.00075291D0
	rhoarr(151)=        0.00059076D0
	rhoarr(152)=        0.00045431D0
	rhoarr(153)=        0.00034185D0
	rhoarr(154)=        0.00025122D0
	rhoarr(155)=        0.00017994D0
	rhoarr(156)=        0.00012532D0
	rhoarr(157)=        0.00008465D0
	rhoarr(158)=        0.00005528D0
	rhoarr(159)=        0.00003480D0
	rhoarr(160)=        0.00002105D0
	rhoarr(161)=        0.00001219D0
	rhoarr(162)=        0.00000674D0
	rhoarr(163)=        0.00000355D0
	rhoarr(164)=        0.00000178D0
	rhoarr(165)=        0.00000084D0
	rhoarr(166)=        0.00000038D0
	rhoarr(167)=        0.00000016D0
	rhoarr(168)=        0.00000006D0
	rhoarr(169)=        0.00000002D0

else if (iele==61) then  !Pm, 4f5 6s2, 0 6, B3LYP/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=   695955.07097557D0
	rhoarr(  2)=   672579.76636753D0
	rhoarr(  3)=   588125.00862910D0
	rhoarr(  4)=   450356.81190471D0
	rhoarr(  5)=   337093.15036646D0
	rhoarr(  6)=   270521.74273176D0
	rhoarr(  7)=   217537.56352852D0
	rhoarr(  8)=   173543.19845239D0
	rhoarr(  9)=   139698.60275654D0
	rhoarr( 10)=   112283.42012612D0
	rhoarr( 11)=    89483.41606901D0
	rhoarr( 12)=    70815.82077260D0
	rhoarr( 13)=    55720.96038102D0
	rhoarr( 14)=    43558.75315597D0
	rhoarr( 15)=    33813.24553259D0
	rhoarr( 16)=    26100.56327598D0
	rhoarr( 17)=    20095.16677843D0
	rhoarr( 18)=    15496.02381379D0
	rhoarr( 19)=    12028.07475896D0
	rhoarr( 20)=     9449.48572869D0
	rhoarr( 21)=     7555.86296009D0
	rhoarr( 22)=     6179.55525137D0
	rhoarr( 23)=     5185.24648499D0
	rhoarr( 24)=     4465.05805152D0
	rhoarr( 25)=     3934.68196601D0
	rhoarr( 26)=     3530.11574970D0
	rhoarr( 27)=     3204.53114894D0
	rhoarr( 28)=     2925.33674120D0
	rhoarr( 29)=     2671.49546409D0
	rhoarr( 30)=     2430.96990789D0
	rhoarr( 31)=     2198.24225655D0
	rhoarr( 32)=     1972.06814399D0
	rhoarr( 33)=     1753.68139973D0
	rhoarr( 34)=     1545.52794411D0
	rhoarr( 35)=     1350.43629400D0
	rhoarr( 36)=     1171.06685476D0
	rhoarr( 37)=     1009.52684633D0
	rhoarr( 38)=      867.11555384D0
	rhoarr( 39)=      744.20864450D0
	rhoarr( 40)=      640.28549238D0
	rhoarr( 41)=      554.07363703D0
	rhoarr( 42)=      483.76003093D0
	rhoarr( 43)=      427.21496085D0
	rhoarr( 44)=      382.18908724D0
	rhoarr( 45)=      346.46555128D0
	rhoarr( 46)=      317.96690497D0
	rhoarr( 47)=      294.82577442D0
	rhoarr( 48)=      275.42930508D0
	rhoarr( 49)=      258.44417494D0
	rhoarr( 50)=      242.82514784D0
	rhoarr( 51)=      227.80814491D0
	rhoarr( 52)=      212.88906289D0
	rhoarr( 53)=      197.79107176D0
	rhoarr( 54)=      182.42450270D0
	rhoarr( 55)=      166.84380300D0
	rhoarr( 56)=      151.20532496D0
	rhoarr( 57)=      135.72845914D0
	rhoarr( 58)=      120.66145363D0
	rhoarr( 59)=      106.25254780D0
	rhoarr( 60)=       92.72678874D0
	rhoarr( 61)=       80.26885047D0
	rhoarr( 62)=       69.01207142D0
	rhoarr( 63)=       59.03362815D0
	rhoarr( 64)=       50.35530223D0
	rhoarr( 65)=       42.94881712D0
	rhoarr( 66)=       36.74437843D0
	rhoarr( 67)=       31.64093766D0
	rhoarr( 68)=       27.51681826D0
	rhoarr( 69)=       24.23962608D0
	rhoarr( 70)=       21.67472208D0
	rhoarr( 71)=       19.69188455D0
	rhoarr( 72)=       18.17008280D0
	rhoarr( 73)=       17.00050708D0
	rhoarr( 74)=       16.08814387D0
	rhoarr( 75)=       15.35225702D0
	rhoarr( 76)=       14.72613568D0
	rhoarr( 77)=       14.15641368D0
	rhoarr( 78)=       13.60217187D0
	rhoarr( 79)=       13.03393266D0
	rhoarr( 80)=       12.43257296D0
	rhoarr( 81)=       11.78813417D0
	rhoarr( 82)=       11.09850195D0
	rhoarr( 83)=       10.36795300D0
	rhoarr( 84)=        9.60560418D0
	rhoarr( 85)=        8.82383482D0
	rhoarr( 86)=        8.03677115D0
	rhoarr( 87)=        7.25892186D0
	rhoarr( 88)=        6.50403525D0
	rhoarr( 89)=        5.78422168D0
	rhoarr( 90)=        5.10935484D0
	rhoarr( 91)=        4.48674023D0
	rhoarr( 92)=        3.92102094D0
	rhoarr( 93)=        3.41427986D0
	rhoarr( 94)=        2.96629341D0
	rhoarr( 95)=        2.57489183D0
	rhoarr( 96)=        2.23638340D0
	rhoarr( 97)=        1.94600392D0
	rhoarr( 98)=        1.69835736D0
	rhoarr( 99)=        1.48781875D0
	rhoarr(100)=        1.30887639D0
	rhoarr(101)=        1.15639761D0
	rhoarr(102)=        1.02580994D0
	rhoarr(103)=        0.91319794D0
	rhoarr(104)=        0.81532403D0
	rhoarr(105)=        0.72958782D0
	rhoarr(106)=        0.65394340D0
	rhoarr(107)=        0.58679494D0
	rhoarr(108)=        0.52688945D0
	rhoarr(109)=        0.47322149D0
	rhoarr(110)=        0.42495866D0
	rhoarr(111)=        0.38139084D0
	rhoarr(112)=        0.34190118D0
	rhoarr(113)=        0.30595345D0
	rhoarr(114)=        0.27308929D0
	rhoarr(115)=        0.24292925D0
	rhoarr(116)=        0.21517310D0
	rhoarr(117)=        0.18959670D0
	rhoarr(118)=        0.16604457D0
	rhoarr(119)=        0.14441829D0
	rhoarr(120)=        0.12466182D0
	rhoarr(121)=        0.10674515D0
	rhoarr(122)=        0.09064790D0
	rhoarr(123)=        0.07634451D0
	rhoarr(124)=        0.06379251D0
	rhoarr(125)=        0.05292491D0
	rhoarr(126)=        0.04364720D0
	rhoarr(127)=        0.03583867D0
	rhoarr(128)=        0.02935729D0
	rhoarr(129)=        0.02404695D0
	rhoarr(130)=        0.01974562D0
	rhoarr(131)=        0.01629339D0
	rhoarr(132)=        0.01353930D0
	rhoarr(133)=        0.01134667D0
	rhoarr(134)=        0.00959649D0
	rhoarr(135)=        0.00818895D0
	rhoarr(136)=        0.00704340D0
	rhoarr(137)=        0.00609687D0
	rhoarr(138)=        0.00530168D0
	rhoarr(139)=        0.00462261D0
	rhoarr(140)=        0.00403397D0
	rhoarr(141)=        0.00351707D0
	rhoarr(142)=        0.00305822D0
	rhoarr(143)=        0.00264739D0
	rhoarr(144)=        0.00227729D0
	rhoarr(145)=        0.00194282D0
	rhoarr(146)=        0.00164069D0
	rhoarr(147)=        0.00136893D0
	rhoarr(148)=        0.00112647D0
	rhoarr(149)=        0.00091267D0
	rhoarr(150)=        0.00072689D0
	rhoarr(151)=        0.00056822D0
	rhoarr(152)=        0.00043528D0
	rhoarr(153)=        0.00032622D0
	rhoarr(154)=        0.00023876D0
	rhoarr(155)=        0.00017030D0
	rhoarr(156)=        0.00011810D0
	rhoarr(157)=        0.00007942D0
	rhoarr(158)=        0.00005163D0
	rhoarr(159)=        0.00003235D0
	rhoarr(160)=        0.00001948D0
	rhoarr(161)=        0.00001123D0
	rhoarr(162)=        0.00000619D0
	rhoarr(163)=        0.00000325D0
	rhoarr(164)=        0.00000162D0
	rhoarr(165)=        0.00000077D0
	rhoarr(166)=        0.00000034D0
	rhoarr(167)=        0.00000014D0
	rhoarr(168)=        0.00000005D0
	rhoarr(169)=        0.00000002D0

else if (iele==62) then  !Sm, 4f6 6s2, 0 7, B3LYP/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=   758319.49990112D0
	rhoarr(  2)=   731662.53109255D0
	rhoarr(  3)=   635984.46888510D0
	rhoarr(  4)=   482491.28142766D0
	rhoarr(  5)=   359415.34953179D0
	rhoarr(  6)=   287543.86340913D0
	rhoarr(  7)=   229901.17028670D0
	rhoarr(  8)=   182626.26328625D0
	rhoarr(  9)=   146458.10970859D0
	rhoarr( 10)=   117191.40877923D0
	rhoarr( 11)=    92969.90890830D0
	rhoarr( 12)=    73259.19557332D0
	rhoarr( 13)=    57402.15601884D0
	rhoarr( 14)=    44684.09172722D0
	rhoarr( 15)=    34545.03605165D0
	rhoarr( 16)=    26567.74445880D0
	rhoarr( 17)=    20394.88918780D0
	rhoarr( 18)=    15697.17972690D0
	rhoarr( 19)=    12176.72074218D0
	rhoarr( 20)=     9574.54833889D0
	rhoarr( 21)=     7674.17988536D0
	rhoarr( 22)=     6299.60766030D0
	rhoarr( 23)=     5309.77016876D0
	rhoarr( 24)=     4593.05551649D0
	rhoarr( 25)=     4063.04528012D0
	rhoarr( 26)=     3654.85881034D0
	rhoarr( 27)=     3321.67932088D0
	rhoarr( 28)=     3031.55367263D0
	rhoarr( 29)=     2764.46686101D0
	rhoarr( 30)=     2509.53406811D0
	rhoarr( 31)=     2262.30515425D0
	rhoarr( 32)=     2022.39726884D0
	rhoarr( 33)=     1791.67329145D0
	rhoarr( 34)=     1572.99817488D0
	rhoarr( 35)=     1369.43479913D0
	rhoarr( 36)=     1183.70609665D0
	rhoarr( 37)=     1017.82096009D0
	rhoarr( 38)=      872.84405600D0
	rhoarr( 39)=      748.82265280D0
	rhoarr( 40)=      644.86598249D0
	rhoarr( 41)=      559.33778524D0
	rhoarr( 42)=      490.10165184D0
	rhoarr( 43)=      434.76227798D0
	rhoarr( 44)=      390.86638462D0
	rhoarr( 45)=      356.05104592D0
	rhoarr( 46)=      328.14419584D0
	rhoarr( 47)=      305.22890599D0
	rhoarr( 48)=      285.68195250D0
	rhoarr( 49)=      268.19276380D0
	rhoarr( 50)=      251.76501345D0
	rhoarr( 51)=      235.70178701D0
	rhoarr( 52)=      219.57618661D0
	rhoarr( 53)=      203.19101201D0
	rhoarr( 54)=      186.53233246D0
	rhoarr( 55)=      169.72169143D0
	rhoarr( 56)=      152.97060636D0
	rhoarr( 57)=      136.53963324D0
	rhoarr( 58)=      120.70317012D0
	rhoarr( 59)=      105.72059806D0
	rhoarr( 60)=       91.81415884D0
	rhoarr( 61)=       79.15384934D0
	rhoarr( 62)=       67.84934541D0
	rhoarr( 63)=       57.94850661D0
	rhoarr( 64)=       49.44147307D0
	rhoarr( 65)=       42.26892133D0
	rhoarr( 66)=       36.33283272D0
	rhoarr( 67)=       31.50818238D0
	rhoarr( 68)=       27.65422590D0
	rhoarr( 69)=       24.62444399D0
	rhoarr( 70)=       22.27460526D0
	rhoarr( 71)=       20.46875886D0
	rhoarr( 72)=       19.08324097D0
	rhoarr( 73)=       18.00896627D0
	rhoarr( 74)=       17.15237949D0
	rhoarr( 75)=       16.43546688D0
	rhoarr( 76)=       15.79518484D0
	rhoarr( 77)=       15.18257117D0
	rhoarr( 78)=       14.56169274D0
	rhoarr( 79)=       13.90848293D0
	rhoarr( 80)=       13.20945795D0
	rhoarr( 81)=       12.46028179D0
	rhoarr( 82)=       11.66416975D0
	rhoarr( 83)=       10.83016206D0
	rhoarr( 84)=        9.97134156D0
	rhoarr( 85)=        9.10309682D0
	rhoarr( 86)=        8.24153637D0
	rhoarr( 87)=        7.40214288D0
	rhoarr( 88)=        6.59872539D0
	rhoarr( 89)=        5.84269188D0
	rhoarr( 90)=        5.14263264D0
	rhoarr( 91)=        4.50418119D0
	rhoarr( 92)=        3.93010548D0
	rhoarr( 93)=        3.42057639D0
	rhoarr( 94)=        2.97356063D0
	rhoarr( 95)=        2.58528861D0
	rhoarr( 96)=        2.25075260D0
	rhoarr( 97)=        1.96419626D0
	rhoarr( 98)=        1.71956265D0
	rhoarr( 99)=        1.51087513D0
	rhoarr(100)=        1.33253328D0
	rhoarr(101)=        1.17951558D0
	rhoarr(102)=        1.04748931D0
	rhoarr(103)=        0.93283764D0
	rhoarr(104)=        0.83262025D0
	rhoarr(105)=        0.74448868D0
	rhoarr(106)=        0.66657848D0
	rhoarr(107)=        0.59739800D0
	rhoarr(108)=        0.53572932D0
	rhoarr(109)=        0.48055057D0
	rhoarr(110)=        0.43098266D0
	rhoarr(111)=        0.38625860D0
	rhoarr(112)=        0.34570991D0
	rhoarr(113)=        0.30876354D0
	rhoarr(114)=        0.27494300D0
	rhoarr(115)=        0.24386871D0
	rhoarr(116)=        0.21525466D0
	rhoarr(117)=        0.18890007D0
	rhoarr(118)=        0.16467611D0
	rhoarr(119)=        0.14250869D0
	rhoarr(120)=        0.12235915D0
	rhoarr(121)=        0.10420451D0
	rhoarr(122)=        0.08801971D0
	rhoarr(123)=        0.07376332D0
	rhoarr(124)=        0.06136816D0
	rhoarr(125)=        0.05073717D0
	rhoarr(126)=        0.04174438D0
	rhoarr(127)=        0.03423978D0
	rhoarr(128)=        0.02805684D0
	rhoarr(129)=        0.02302118D0
	rhoarr(130)=        0.01895907D0
	rhoarr(131)=        0.01570498D0
	rhoarr(132)=        0.01310735D0
	rhoarr(133)=        0.01103264D0
	rhoarr(134)=        0.00936742D0
	rhoarr(135)=        0.00801864D0
	rhoarr(136)=        0.00691248D0
	rhoarr(137)=        0.00599209D0
	rhoarr(138)=        0.00521463D0
	rhoarr(139)=        0.00454825D0
	rhoarr(140)=        0.00396929D0
	rhoarr(141)=        0.00346010D0
	rhoarr(142)=        0.00300747D0
	rhoarr(143)=        0.00260158D0
	rhoarr(144)=        0.00223538D0
	rhoarr(145)=        0.00190407D0
	rhoarr(146)=        0.00160470D0
	rhoarr(147)=        0.00133560D0
	rhoarr(148)=        0.00109595D0
	rhoarr(149)=        0.00088518D0
	rhoarr(150)=        0.00070266D0
	rhoarr(151)=        0.00054738D0
	rhoarr(152)=        0.00041783D0
	rhoarr(153)=        0.00031201D0
	rhoarr(154)=        0.00022751D0
	rhoarr(155)=        0.00016166D0
	rhoarr(156)=        0.00011167D0
	rhoarr(157)=        0.00007478D0
	rhoarr(158)=        0.00004842D0
	rhoarr(159)=        0.00003021D0
	rhoarr(160)=        0.00001812D0
	rhoarr(161)=        0.00001041D0
	rhoarr(162)=        0.00000572D0
	rhoarr(163)=        0.00000299D0
	rhoarr(164)=        0.00000149D0
	rhoarr(165)=        0.00000070D0
	rhoarr(166)=        0.00000031D0
	rhoarr(167)=        0.00000013D0
	rhoarr(168)=        0.00000005D0
	rhoarr(169)=        0.00000002D0

else if (iele==63) then  !Eu, 4f7 6s2, 0 8, B3LYP/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=   825899.86771059D0
	rhoarr(  2)=   795537.98942530D0
	rhoarr(  3)=   687290.86950068D0
	rhoarr(  4)=   516540.52109902D0
	rhoarr(  5)=   382990.19541771D0
	rhoarr(  6)=   305402.22883507D0
	rhoarr(  7)=   242765.26523978D0
	rhoarr(  8)=   192035.53205197D0
	rhoarr(  9)=   153414.83466354D0
	rhoarr( 10)=   122202.27446471D0
	rhoarr( 11)=    96503.06722676D0
	rhoarr( 12)=    75716.96630125D0
	rhoarr( 13)=    59078.92175295D0
	rhoarr( 14)=    45795.66015272D0
	rhoarr( 15)=    35261.00263190D0
	rhoarr( 16)=    27021.52130889D0
	rhoarr( 17)=    20685.59690101D0
	rhoarr( 18)=    15894.03905477D0
	rhoarr( 19)=    12325.20999720D0
	rhoarr( 20)=     9702.65738511D0
	rhoarr( 21)=     7797.73651430D0
	rhoarr( 22)=     6426.10735509D0
	rhoarr( 23)=     5441.05538459D0
	rhoarr( 24)=     4727.39722317D0
	rhoarr( 25)=     4196.80089540D0
	rhoarr( 26)=     3783.70859842D0
	rhoarr( 27)=     3441.51086215D0
	rhoarr( 28)=     3139.07205297D0
	rhoarr( 29)=     2857.53821555D0
	rhoarr( 30)=     2587.25808754D0
	rhoarr( 31)=     2324.87567005D0
	rhoarr( 32)=     2070.86073748D0
	rhoarr( 33)=     1827.67923656D0
	rhoarr( 34)=     1598.57983731D0
	rhoarr( 35)=     1386.81489529D0
	rhoarr( 36)=     1195.11503884D0
	rhoarr( 37)=     1025.33049718D0
	rhoarr( 38)=      878.23392669D0
	rhoarr( 39)=      753.49810036D0
	rhoarr( 40)=      649.83195170D0
	rhoarr( 41)=      565.22115511D0
	rhoarr( 42)=      497.20420994D0
	rhoarr( 43)=      443.12664776D0
	rhoarr( 44)=      400.34219615D0
	rhoarr( 45)=      366.35511083D0
	rhoarr( 46)=      338.91322018D0
	rhoarr( 47)=      316.06530834D0
	rhoarr( 48)=      296.19325358D0
	rhoarr( 49)=      278.02408961D0
	rhoarr( 50)=      260.62365767D0
	rhoarr( 51)=      243.37300025D0
	rhoarr( 52)=      225.93021384D0
	rhoarr( 53)=      208.18235390D0
	rhoarr( 54)=      190.19281315D0
	rhoarr( 55)=      172.14904599D0
	rhoarr( 56)=      154.31412204D0
	rhoarr( 57)=      136.98414759D0
	rhoarr( 58)=      120.45260971D0
	rhoarr( 59)=      104.98222883D0
	rhoarr( 60)=       90.78469422D0
	rhoarr( 61)=       78.00840087D0
	rhoarr( 62)=       66.73385866D0
	rhoarr( 63)=       56.97585897D0
	rhoarr( 64)=       48.69093743D0
	rhoarr( 65)=       41.78833691D0
	rhoarr( 66)=       36.14263728D0
	rhoarr( 67)=       31.60644951D0
	rhoarr( 68)=       28.02197085D0
	rhoarr( 69)=       25.23064933D0
	rhoarr( 70)=       23.08062056D0
	rhoarr( 71)=       21.43191282D0
	rhoarr( 72)=       20.15965390D0
	rhoarr( 73)=       19.15565727D0
	rhoarr( 74)=       18.32882071D0
	rhoarr( 75)=       17.60474787D0
	rhoarr( 76)=       16.92491784D0
	rhoarr( 77)=       16.24561049D0
	rhoarr( 78)=       15.53667820D0
	rhoarr( 79)=       14.78017069D0
	rhoarr( 80)=       13.96878392D0
	rhoarr( 81)=       13.10411625D0
	rhoarr( 82)=       12.19475751D0
	rhoarr( 83)=       11.25428672D0
	rhoarr( 84)=       10.29929112D0
	rhoarr( 85)=        9.34753053D0
	rhoarr( 86)=        8.41635662D0
	rhoarr( 87)=        7.52146325D0
	rhoarr( 88)=        6.67600180D0
	rhoarr( 89)=        5.89005653D0
	rhoarr( 90)=        5.17044425D0
	rhoarr( 91)=        4.52078441D0
	rhoarr( 92)=        3.94177769D0
	rhoarr( 93)=        3.43163101D0
	rhoarr( 94)=        2.98657117D0
	rhoarr( 95)=        2.60139534D0
	rhoarr( 96)=        2.27001359D0
	rhoarr( 97)=        1.98594610D0
	rhoarr( 98)=        1.74274596D0
	rhoarr( 99)=        1.53432825D0
	rhoarr(100)=        1.35519609D0
	rhoarr(101)=        1.20056560D0
	rhoarr(102)=        1.06640079D0
	rhoarr(103)=        0.94937730D0
	rhoarr(104)=        0.84679768D0
	rhoarr(105)=        0.75648206D0
	rhoarr(106)=        0.67665482D0
	rhoarr(107)=        0.60584328D0
	rhoarr(108)=        0.54279776D0
	rhoarr(109)=        0.48643645D0
	rhoarr(110)=        0.43581303D0
	rhoarr(111)=        0.39010194D0
	rhoarr(112)=        0.34859459D0
	rhoarr(113)=        0.31070008D0
	rhoarr(114)=        0.27594532D0
	rhoarr(115)=        0.24397109D0
	rhoarr(116)=        0.21452255D0
	rhoarr(117)=        0.18743393D0
	rhoarr(118)=        0.16260853D0
	rhoarr(119)=        0.13999592D0
	rhoarr(120)=        0.11956866D0
	rhoarr(121)=        0.10130111D0
	rhoarr(122)=        0.08515235D0
	rhoarr(123)=        0.07105474D0
	rhoarr(124)=        0.05890866D0
	rhoarr(125)=        0.04858287D0
	rhoarr(126)=        0.03991938D0
	rhoarr(127)=        0.03274125D0
	rhoarr(128)=        0.02686169D0
	rhoarr(129)=        0.02209303D0
	rhoarr(130)=        0.01825479D0
	rhoarr(131)=        0.01518008D0
	rhoarr(132)=        0.01272011D0
	rhoarr(133)=        0.01074684D0
	rhoarr(134)=        0.00915378D0
	rhoarr(135)=        0.00785507D0
	rhoarr(136)=        0.00678345D0
	rhoarr(137)=        0.00588732D0
	rhoarr(138)=        0.00512761D0
	rhoarr(139)=        0.00447481D0
	rhoarr(140)=        0.00390652D0
	rhoarr(141)=        0.00340573D0
	rhoarr(142)=        0.00295956D0
	rhoarr(143)=        0.00255850D0
	rhoarr(144)=        0.00219591D0
	rhoarr(145)=        0.00186744D0
	rhoarr(146)=        0.00157055D0
	rhoarr(147)=        0.00130395D0
	rhoarr(148)=        0.00106700D0
	rhoarr(149)=        0.00085920D0
	rhoarr(150)=        0.00067988D0
	rhoarr(151)=        0.00052790D0
	rhoarr(152)=        0.00040162D0
	rhoarr(153)=        0.00029889D0
	rhoarr(154)=        0.00021718D0
	rhoarr(155)=        0.00015377D0
	rhoarr(156)=        0.00010582D0
	rhoarr(157)=        0.00007059D0
	rhoarr(158)=        0.00004552D0
	rhoarr(159)=        0.00002830D0
	rhoarr(160)=        0.00001690D0
	rhoarr(161)=        0.00000968D0
	rhoarr(162)=        0.00000530D0
	rhoarr(163)=        0.00000277D0
	rhoarr(164)=        0.00000137D0
	rhoarr(165)=        0.00000064D0
	rhoarr(166)=        0.00000028D0
	rhoarr(167)=        0.00000011D0
	rhoarr(168)=        0.00000004D0
	rhoarr(169)=        0.00000001D0

else if (iele==64) then  !Gd, 4f7 5d1 6s2, 0 9, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=   899132.78301823D0
	rhoarr(  2)=   864588.93435544D0
	rhoarr(  3)=   742271.71662154D0
	rhoarr(  4)=   552601.58148820D0
	rhoarr(  5)=   407884.52094936D0
	rhoarr(  6)=   324131.47408952D0
	rhoarr(  7)=   256148.86550798D0
	rhoarr(  8)=   201783.63236315D0
	rhoarr(  9)=   160575.12048977D0
	rhoarr( 10)=   127319.32713456D0
	rhoarr( 11)=   100085.14575869D0
	rhoarr( 12)=    78190.81571260D0
	rhoarr( 13)=    60752.61802202D0
	rhoarr( 14)=    46894.86303401D0
	rhoarr( 15)=    35962.81397388D0
	rhoarr( 16)=    27463.84051500D0
	rhoarr( 17)=    20969.43953029D0
	rhoarr( 18)=    16088.84761003D0
	rhoarr( 19)=    12475.78569680D0
	rhoarr( 20)=     9835.97933521D0
	rhoarr( 21)=     7928.56399615D0
	rhoarr( 22)=     6560.90541610D0
	rhoarr( 23)=     5580.74881355D0
	rhoarr( 24)=     4869.52048731D0
	rhoarr( 25)=     4337.18521090D0
	rhoarr( 26)=     3917.71985945D0
	rhoarr( 27)=     3564.92768122D0
	rhoarr( 28)=     3248.67434800D0
	rhoarr( 29)=     2951.40332182D0
	rhoarr( 30)=     2664.77108468D0
	rhoarr( 31)=     2386.53627497D0
	rhoarr( 32)=     2118.00938170D0
	rhoarr( 33)=     1862.23189405D0
	rhoarr( 34)=     1622.79836523D0
	rhoarr( 35)=     1403.10138615D0
	rhoarr( 36)=     1205.81942845D0
	rhoarr( 37)=     1032.57990260D0
	rhoarr( 38)=      883.80454317D0
	rhoarr( 39)=      758.74608416D0
	rhoarr( 40)=      655.68451588D0
	rhoarr( 41)=      572.21446690D0
	rhoarr( 42)=      505.54801558D0
	rhoarr( 43)=      452.77745806D0
	rhoarr( 44)=      411.07348421D0
	rhoarr( 45)=      377.81978655D0
	rhoarr( 46)=      350.69793084D0
	rhoarr( 47)=      327.73741787D0
	rhoarr( 48)=      307.34074227D0
	rhoarr( 49)=      288.28758895D0
	rhoarr( 50)=      269.71945586D0
	rhoarr( 51)=      251.10638441D0
	rhoarr( 52)=      232.19955619D0
	rhoarr( 53)=      212.97530084D0
	rhoarr( 54)=      193.57641702D0
	rhoarr( 55)=      174.25568484D0
	rhoarr( 56)=      155.32482462D0
	rhoarr( 57)=      137.11073347D0
	rhoarr( 58)=      119.91996701D0
	rhoarr( 59)=      104.01201757D0
	rhoarr( 60)=       89.58164504D0
	rhoarr( 61)=       76.75008400D0
	rhoarr( 62)=       65.56433996D0
	rhoarr( 63)=       56.00314239D0
	rhoarr( 64)=       47.98764770D0
	rhoarr( 65)=       41.39481994D0
	rhoarr( 66)=       36.07157464D0
	rhoarr( 67)=       31.84816413D0
	rhoarr( 68)=       28.54977855D0
	rhoarr( 69)=       26.00582008D0
	rhoarr( 70)=       24.05671208D0
	rhoarr( 71)=       22.55840219D0
	rhoarr( 72)=       21.38491103D0
	rhoarr( 73)=       20.42937102D0
	rhoarr( 74)=       19.60400395D0
	rhoarr( 75)=       18.83941687D0
	rhoarr( 76)=       18.08348148D0
	rhoarr( 77)=       17.29993960D0
	rhoarr( 78)=       16.46678111D0
	rhoarr( 79)=       15.57439433D0
	rhoarr( 80)=       14.62349349D0
	rhoarr( 81)=       13.62286861D0
	rhoarr( 82)=       12.58705317D0
	rhoarr( 83)=       11.53404173D0
	rhoarr( 84)=       10.48319841D0
	rhoarr( 85)=        9.45347682D0
	rhoarr( 86)=        8.46203109D0
	rhoarr( 87)=        7.52324887D0
	rhoarr( 88)=        6.64819287D0
	rhoarr( 89)=        5.84440440D0
	rhoarr( 90)=        5.11600297D0
	rhoarr( 91)=        4.46400889D0
	rhoarr( 92)=        3.88681610D0
	rhoarr( 93)=        3.38074803D0
	rhoarr( 94)=        2.94063739D0
	rhoarr( 95)=        2.56038068D0
	rhoarr( 96)=        2.23342988D0
	rhoarr( 97)=        1.95319683D0
	rhoarr( 98)=        1.71335897D0
	rhoarr( 99)=        1.50806730D0
	rhoarr(100)=        1.33206663D0
	rhoarr(101)=        1.18074429D0
	rhoarr(102)=        1.05012526D0
	rhoarr(103)=        0.93683125D0
	rhoarr(104)=        0.83801883D0
	rhoarr(105)=        0.75130871D0
	rhoarr(106)=        0.67471525D0
	rhoarr(107)=        0.60658270D0
	rhoarr(108)=        0.54553203D0
	rhoarr(109)=        0.49041981D0
	rhoarr(110)=        0.44030845D0
	rhoarr(111)=        0.39444498D0
	rhoarr(112)=        0.35224466D0
	rhoarr(113)=        0.31327519D0
	rhoarr(114)=        0.27723827D0
	rhoarr(115)=        0.24394678D0
	rhoarr(116)=        0.21329767D0
	rhoarr(117)=        0.18524240D0
	rhoarr(118)=        0.15975797D0
	rhoarr(119)=        0.13682156D0
	rhoarr(120)=        0.11639128D0
	rhoarr(121)=        0.09839421D0
	rhoarr(122)=        0.08272163D0
	rhoarr(123)=        0.06923027D0
	rhoarr(124)=        0.05774781D0
	rhoarr(125)=        0.04808082D0
	rhoarr(126)=        0.04002364D0
	rhoarr(127)=        0.03336701D0
	rhoarr(128)=        0.02790609D0
	rhoarr(129)=        0.02344711D0
	rhoarr(130)=        0.01981283D0
	rhoarr(131)=        0.01684630D0
	rhoarr(132)=        0.01441296D0
	rhoarr(133)=        0.01240105D0
	rhoarr(134)=        0.01072043D0
	rhoarr(135)=        0.00930027D0
	rhoarr(136)=        0.00808600D0
	rhoarr(137)=        0.00703616D0
	rhoarr(138)=        0.00611939D0
	rhoarr(139)=        0.00531195D0
	rhoarr(140)=        0.00459585D0
	rhoarr(141)=        0.00395740D0
	rhoarr(142)=        0.00338624D0
	rhoarr(143)=        0.00287471D0
	rhoarr(144)=        0.00241721D0
	rhoarr(145)=        0.00200979D0
	rhoarr(146)=        0.00164960D0
	rhoarr(147)=        0.00133447D0
	rhoarr(148)=        0.00106244D0
	rhoarr(149)=        0.00083134D0
	rhoarr(150)=        0.00063856D0
	rhoarr(151)=        0.00048092D0
	rhoarr(152)=        0.00035472D0
	rhoarr(153)=        0.00025591D0
	rhoarr(154)=        0.00018030D0
	rhoarr(155)=        0.00012382D0
	rhoarr(156)=        0.00008267D0
	rhoarr(157)=        0.00005352D0
	rhoarr(158)=        0.00003347D0
	rhoarr(159)=        0.00002015D0
	rhoarr(160)=        0.00001162D0
	rhoarr(161)=        0.00000640D0
	rhoarr(162)=        0.00000336D0
	rhoarr(163)=        0.00000167D0
	rhoarr(164)=        0.00000079D0
	rhoarr(165)=        0.00000035D0
	rhoarr(166)=        0.00000015D0
	rhoarr(167)=        0.00000006D0
	rhoarr(168)=        0.00000002D0

else if (iele==65) then  !Tb, 4f9 6s2, 0 6, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=   978385.45527399D0
	rhoarr(  2)=   939129.63696318D0
	rhoarr(  3)=   801092.34357102D0
	rhoarr(  4)=   590723.48175551D0
	rhoarr(  5)=   434120.64501430D0
	rhoarr(  6)=   343723.63674585D0
	rhoarr(  7)=   270035.73701641D0
	rhoarr(  8)=   211852.09040923D0
	rhoarr(  9)=   167918.22689416D0
	rhoarr( 10)=   132523.28937987D0
	rhoarr( 11)=   103699.77994111D0
	rhoarr( 12)=    80667.16392253D0
	rhoarr( 13)=    62412.23442363D0
	rhoarr( 14)=    47973.13325208D0
	rhoarr( 15)=    36643.97538104D0
	rhoarr( 16)=    27889.71090647D0
	rhoarr( 17)=    21242.37060321D0
	rhoarr( 18)=    16278.05290251D0
	rhoarr( 19)=    12625.08551149D0
	rhoarr( 20)=     9971.16657221D0
	rhoarr( 21)=     8063.23533323D0
	rhoarr( 22)=     6700.45741702D0
	rhoarr( 23)=     5725.19787322D0
	rhoarr( 24)=     5015.70873395D0
	rhoarr( 25)=     4480.48307537D0
	rhoarr( 26)=     4053.25712445D0
	rhoarr( 27)=     3688.45751674D0
	rhoarr( 28)=     3357.12867270D0
	rhoarr( 29)=     3043.12919551D0
	rhoarr( 30)=     2739.47227990D0
	rhoarr( 31)=     2445.02717395D0
	rhoarr( 32)=     2161.91299873D0
	rhoarr( 33)=     1893.70306555D0
	rhoarr( 34)=     1644.28629955D0
	rhoarr( 35)=     1417.13507711D0
	rhoarr( 36)=     1214.80862695D0
	rhoarr( 37)=     1038.64576309D0
	rhoarr( 38)=      888.66278401D0
	rhoarr( 39)=      763.65613447D0
	rhoarr( 40)=      661.46038338D0
	rhoarr( 41)=      579.27915331D0
	rhoarr( 42)=      514.00921981D0
	rhoarr( 43)=      462.50672398D0
	rhoarr( 44)=      421.77888533D0
	rhoarr( 45)=      389.10909773D0
	rhoarr( 46)=      362.13283106D0
	rhoarr( 47)=      338.87979120D0
	rhoarr( 48)=      317.79109128D0
	rhoarr( 49)=      297.71454670D0
	rhoarr( 50)=      277.87927967D0
	rhoarr( 51)=      257.85213329D0
	rhoarr( 52)=      237.48081240D0
	rhoarr( 53)=      216.83017831D0
	rhoarr( 54)=      196.11793489D0
	rhoarr( 55)=      175.65448998D0
	rhoarr( 56)=      155.79000976D0
	rhoarr( 57)=      136.87032758D0
	rhoarr( 58)=      119.20259254D0
	rhoarr( 59)=      103.03109802D0
	rhoarr( 60)=       88.52327634D0
	rhoarr( 61)=       75.76521893D0
	rhoarr( 62)=       64.76535390D0
	rhoarr( 63)=       55.46429463D0
	rhoarr( 64)=       47.74855527D0
	rhoarr( 65)=       41.46588400D0
	rhoarr( 66)=       36.44032998D0
	rhoarr( 67)=       32.48569533D0
	rhoarr( 68)=       29.41658541D0
	rhoarr( 69)=       27.05676087D0
	rhoarr( 70)=       25.24486958D0
	rhoarr( 71)=       23.83789072D0
	rhoarr( 72)=       22.71276439D0
	rhoarr( 73)=       21.76671888D0
	rhoarr( 74)=       20.91675802D0
	rhoarr( 75)=       20.09865585D0
	rhoarr( 76)=       19.26566317D0
	rhoarr( 77)=       18.38700018D0
	rhoarr( 78)=       17.44612640D0
	rhoarr( 79)=       16.43875725D0
	rhoarr( 80)=       15.37062789D0
	rhoarr( 81)=       14.25506505D0
	rhoarr( 82)=       13.11048764D0
	rhoarr( 83)=       11.95799275D0
	rhoarr( 84)=       10.81918535D0
	rhoarr( 85)=        9.71437996D0
	rhoarr( 86)=        8.66125157D0
	rhoarr( 87)=        7.67395754D0
	rhoarr( 88)=        6.76270298D0
	rhoarr( 89)=        5.93368818D0
	rhoarr( 90)=        5.18935831D0
	rhoarr( 91)=        4.52887146D0
	rhoarr( 92)=        3.94870492D0
	rhoarr( 93)=        3.44332871D0
	rhoarr( 94)=        3.00588524D0
	rhoarr( 95)=        2.62882461D0
	rhoarr( 96)=        2.30445605D0
	rhoarr( 97)=        2.02538795D0
	rhoarr( 98)=        1.78484184D0
	rhoarr( 99)=        1.57683932D0
	rhoarr(100)=        1.39627369D0
	rhoarr(101)=        1.23888789D0
	rhoarr(102)=        1.10118667D0
	rhoarr(103)=        0.98031243D0
	rhoarr(104)=        0.87391132D0
	rhoarr(105)=        0.78001025D0
	rhoarr(106)=        0.69691779D0
	rhoarr(107)=        0.62315417D0
	rhoarr(108)=        0.55740927D0
	rhoarr(109)=        0.49852303D0
	rhoarr(110)=        0.44548080D0
	rhoarr(111)=        0.39741572D0
	rhoarr(112)=        0.35361184D0
	rhoarr(113)=        0.31350326D0
	rhoarr(114)=        0.27666664D0
	rhoarr(115)=        0.24280628D0
	rhoarr(116)=        0.21173232D0
	rhoarr(117)=        0.18333396D0
	rhoarr(118)=        0.15755019D0
	rhoarr(119)=        0.13434141D0
	rhoarr(120)=        0.11366476D0
	rhoarr(121)=        0.09545562D0
	rhoarr(122)=        0.07961654D0
	rhoarr(123)=        0.06601359D0
	rhoarr(124)=        0.05447907D0
	rhoarr(125)=        0.04481870D0
	rhoarr(126)=        0.03682133D0
	rhoarr(127)=        0.03026931D0
	rhoarr(128)=        0.02494814D0
	rhoarr(129)=        0.02065468D0
	rhoarr(130)=        0.01720339D0
	rhoarr(131)=        0.01443051D0
	rhoarr(132)=        0.01219623D0
	rhoarr(133)=        0.01038487D0
	rhoarr(134)=        0.00890352D0
	rhoarr(135)=        0.00767929D0
	rhoarr(136)=        0.00665596D0
	rhoarr(137)=        0.00579046D0
	rhoarr(138)=        0.00504970D0
	rhoarr(139)=        0.00440805D0
	rhoarr(140)=        0.00384560D0
	rhoarr(141)=        0.00334692D0
	rhoarr(142)=        0.00290042D0
	rhoarr(143)=        0.00249773D0
	rhoarr(144)=        0.00213322D0
	rhoarr(145)=        0.00180344D0
	rhoarr(146)=        0.00150651D0
	rhoarr(147)=        0.00124146D0
	rhoarr(148)=        0.00100772D0
	rhoarr(149)=        0.00080463D0
	rhoarr(150)=        0.00063114D0
	rhoarr(151)=        0.00048569D0
	rhoarr(152)=        0.00036615D0
	rhoarr(153)=        0.00026998D0
	rhoarr(154)=        0.00019434D0
	rhoarr(155)=        0.00013627D0
	rhoarr(156)=        0.00009285D0
	rhoarr(157)=        0.00006131D0
	rhoarr(158)=        0.00003913D0
	rhoarr(159)=        0.00002407D0
	rhoarr(160)=        0.00001423D0
	rhoarr(161)=        0.00000807D0
	rhoarr(162)=        0.00000438D0
	rhoarr(163)=        0.00000226D0
	rhoarr(164)=        0.00000111D0
	rhoarr(165)=        0.00000051D0
	rhoarr(166)=        0.00000022D0
	rhoarr(167)=        0.00000009D0
	rhoarr(168)=        0.00000003D0

else if (iele==66) then  !Dy, 4f10 6s2, 0 5, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=  1064229.51443189D0
	rhoarr(  2)=  1019664.50049116D0
	rhoarr(  3)=   864066.02390417D0
	rhoarr(  4)=   631060.66019763D0
	rhoarr(  5)=   461805.28216775D0
	rhoarr(  6)=   364240.50458628D0
	rhoarr(  7)=   284466.98938375D0
	rhoarr(  8)=   222269.99511564D0
	rhoarr(  9)=   175463.09753398D0
	rhoarr( 10)=   137827.67106509D0
	rhoarr( 11)=   107357.40642936D0
	rhoarr( 12)=    83154.19894063D0
	rhoarr( 13)=    64064.38897836D0
	rhoarr( 14)=    49036.22784921D0
	rhoarr( 15)=    37309.81427942D0
	rhoarr( 16)=    28304.21676653D0
	rhoarr( 17)=    21509.30787610D0
	rhoarr( 18)=    16466.42435087D0
	rhoarr( 19)=    12777.72772031D0
	rhoarr( 20)=    10112.67239469D0
	rhoarr( 21)=     8206.01002981D0
	rhoarr( 22)=     6848.79587881D0
	rhoarr( 23)=     5878.18273823D0
	rhoarr( 24)=     5169.47371246D0
	rhoarr( 25)=     4629.92993779D0
	rhoarr( 26)=     4193.28166247D0
	rhoarr( 27)=     3814.79924457D0
	rhoarr( 28)=     3466.88785785D0
	rhoarr( 29)=     3134.93841089D0
	rhoarr( 30)=     2813.36887881D0
	rhoarr( 31)=     2502.15762328D0
	rhoarr( 32)=     2204.20555862D0
	rhoarr( 33)=     1923.57857465D0
	rhoarr( 34)=     1664.40961782D0
	rhoarr( 35)=     1430.18841880D0
	rhoarr( 36)=     1223.28473875D0
	rhoarr( 37)=     1044.68054443D0
	rhoarr( 38)=      893.93081105D0
	rhoarr( 39)=      769.33833129D0
	rhoarr( 40)=      668.27372030D0
	rhoarr( 41)=      587.54593799D0
	rhoarr( 42)=      523.74235647D0
	rhoarr( 43)=      473.49403438D0
	rhoarr( 44)=      433.65840404D0
	rhoarr( 45)=      401.43378191D0
	rhoarr( 46)=      374.42585755D0
	rhoarr( 47)=      350.68139149D0
	rhoarr( 48)=      328.69653409D0
	rhoarr( 49)=      307.40201188D0
	rhoarr( 50)=      286.12662786D0
	rhoarr( 51)=      264.54268108D0
	rhoarr( 52)=      242.59944976D0
	rhoarr( 53)=      220.45193862D0
	rhoarr( 54)=      198.39131353D0
	rhoarr( 55)=      176.78162802D0
	rhoarr( 56)=      156.00561428D0
	rhoarr( 57)=      136.42103828D0
	rhoarr( 58)=      118.32837928D0
	rhoarr( 59)=      101.95004724D0
	rhoarr( 60)=       87.42070431D0
	rhoarr( 61)=       74.78746513D0
	rhoarr( 62)=       64.01798700D0
	rhoarr( 63)=       55.01396003D0
	rhoarr( 64)=       47.62740900D0
	rhoarr( 65)=       41.67751020D0
	rhoarr( 66)=       36.96617489D0
	rhoarr( 67)=       33.29128648D0
	rhoarr( 68)=       30.45706520D0
	rhoarr( 69)=       28.28150082D0
	rhoarr( 70)=       26.60112282D0
	rhoarr( 71)=       25.27357621D0
	rhoarr( 72)=       24.17855419D0
	rhoarr( 73)=       23.21761785D0
	rhoarr( 74)=       22.31333208D0
	rhoarr( 75)=       21.40799715D0
	rhoarr( 76)=       20.46210499D0
	rhoarr( 77)=       19.45253720D0
	rhoarr( 78)=       18.37047501D0
	rhoarr( 79)=       17.21900876D0
	rhoarr( 80)=       16.01049491D0
	rhoarr( 81)=       14.76377900D0
	rhoarr( 82)=       13.50145471D0
	rhoarr( 83)=       12.24734326D0
	rhoarr( 84)=       11.02435331D0
	rhoarr( 85)=        9.85282907D0
	rhoarr( 86)=        8.74942937D0
	rhoarr( 87)=        7.72652106D0
	rhoarr( 88)=        6.79202448D0
	rhoarr( 89)=        5.94962309D0
	rhoarr( 90)=        5.19924034D0
	rhoarr( 91)=        4.53769005D0
	rhoarr( 92)=        3.95941639D0
	rhoarr( 93)=        3.45725158D0
	rhoarr( 94)=        3.02313193D0
	rhoarr( 95)=        2.64872584D0
	rhoarr( 96)=        2.32594087D0
	rhoarr( 97)=        2.04729163D0
	rhoarr( 98)=        1.80612582D0
	rhoarr( 99)=        1.59672010D0
	rhoarr(100)=        1.41426923D0
	rhoarr(101)=        1.25479926D0
	rhoarr(102)=        1.11503749D0
	rhoarr(103)=        0.99226918D0
	rhoarr(104)=        0.88420430D0
	rhoarr(105)=        0.78886910D0
	rhoarr(106)=        0.70452876D0
	rhoarr(107)=        0.62964050D0
	rhoarr(108)=        0.56283136D0
	rhoarr(109)=        0.50289271D0
	rhoarr(110)=        0.44878331D0
	rhoarr(111)=        0.39963366D0
	rhoarr(112)=        0.35474658D0
	rhoarr(113)=        0.31359078D0
	rhoarr(114)=        0.27578605D0
	rhoarr(115)=        0.24108056D0
	rhoarr(116)=        0.20932179D0
	rhoarr(117)=        0.18042404D0
	rhoarr(118)=        0.15433584D0
	rhoarr(119)=        0.13101087D0
	rhoarr(120)=        0.11038523D0
	rhoarr(121)=        0.09236280D0
	rhoarr(122)=        0.07680905D0
	rhoarr(123)=        0.06355221D0
	rhoarr(124)=        0.05238992D0
	rhoarr(125)=        0.04309906D0
	rhoarr(126)=        0.03544679D0
	rhoarr(127)=        0.02920102D0
	rhoarr(128)=        0.02413951D0
	rhoarr(129)=        0.02005695D0
	rhoarr(130)=        0.01676999D0
	rhoarr(131)=        0.01412015D0
	rhoarr(132)=        0.01197460D0
	rhoarr(133)=        0.01022525D0
	rhoarr(134)=        0.00878628D0
	rhoarr(135)=        0.00759076D0
	rhoarr(136)=        0.00658699D0
	rhoarr(137)=        0.00573494D0
	rhoarr(138)=        0.00500341D0
	rhoarr(139)=        0.00436789D0
	rhoarr(140)=        0.00380918D0
	rhoarr(141)=        0.00331243D0
	rhoarr(142)=        0.00286661D0
	rhoarr(143)=        0.00246392D0
	rhoarr(144)=        0.00209927D0
	rhoarr(145)=        0.00176965D0
	rhoarr(146)=        0.00147347D0
	rhoarr(147)=        0.00120993D0
	rhoarr(148)=        0.00097844D0
	rhoarr(149)=        0.00077821D0
	rhoarr(150)=        0.00060801D0
	rhoarr(151)=        0.00046602D0
	rhoarr(152)=        0.00034992D0
	rhoarr(153)=        0.00025696D0
	rhoarr(154)=        0.00018420D0
	rhoarr(155)=        0.00012860D0
	rhoarr(156)=        0.00008724D0
	rhoarr(157)=        0.00005735D0
	rhoarr(158)=        0.00003643D0
	rhoarr(159)=        0.00002231D0
	rhoarr(160)=        0.00001313D0
	rhoarr(161)=        0.00000742D0
	rhoarr(162)=        0.00000400D0
	rhoarr(163)=        0.00000206D0
	rhoarr(164)=        0.00000100D0
	rhoarr(165)=        0.00000046D0
	rhoarr(166)=        0.00000019D0
	rhoarr(167)=        0.00000007D0
	rhoarr(168)=        0.00000003D0

else if (iele==67) then  !Ho, 4f11 6s2, 0 4, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=  1157237.96011844D0
	rhoarr(  2)=  1106690.65738291D0
	rhoarr(  3)=   931477.49932523D0
	rhoarr(  4)=   673729.81887849D0
	rhoarr(  5)=   491009.71601503D0
	rhoarr(  6)=   385709.01620852D0
	rhoarr(  7)=   299452.20130234D0
	rhoarr(  8)=   233038.32427646D0
	rhoarr(  9)=   183204.09117680D0
	rhoarr( 10)=   143225.07457026D0
	rhoarr( 11)=   111051.06254193D0
	rhoarr( 12)=    85645.88504974D0
	rhoarr( 13)=    65704.23309147D0
	rhoarr( 14)=    50080.67988526D0
	rhoarr( 15)=    37958.10293764D0
	rhoarr( 16)=    28706.01453933D0
	rhoarr( 17)=    21769.42210024D0
	rhoarr( 18)=    16653.34994212D0
	rhoarr( 19)=    12933.12748714D0
	rhoarr( 20)=    10259.83241872D0
	rhoarr( 21)=     8356.08386611D0
	rhoarr( 22)=     7004.95116173D0
	rhoarr( 23)=     6038.57439002D0
	rhoarr( 24)=     5329.55616280D0
	rhoarr( 25)=     4784.18112379D0
	rhoarr( 26)=     4336.41997637D0
	rhoarr( 27)=     3942.61214664D0
	rhoarr( 28)=     3576.69955382D0
	rhoarr( 29)=     3225.70742857D0
	rhoarr( 30)=     2885.48912161D0
	rhoarr( 31)=     2557.11611688D0
	rhoarr( 32)=     2244.23336496D0
	rhoarr( 33)=     1951.35068487D0
	rhoarr( 34)=     1682.78556013D0
	rhoarr( 35)=     1441.97473161D0
	rhoarr( 36)=     1231.02360658D0
	rhoarr( 37)=     1050.48894312D0
	rhoarr( 38)=      899.41262189D0
	rhoarr( 39)=      775.57317746D0
	rhoarr( 40)=      675.86627540D0
	rhoarr( 41)=      596.70954359D0
	rhoarr( 42)=      534.39274696D0
	rhoarr( 43)=      485.33777933D0
	rhoarr( 44)=      446.27000494D0
	rhoarr( 45)=      414.32126381D0
	rhoarr( 46)=      387.08646210D0
	rhoarr( 47)=      362.64807162D0
	rhoarr( 48)=      339.57446415D0
	rhoarr( 49)=      316.89373507D0
	rhoarr( 50)=      294.04511424D0
	rhoarr( 51)=      270.81290764D0
	rhoarr( 52)=      247.25033629D0
	rhoarr( 53)=      223.60109862D0
	rhoarr( 54)=      200.22512172D0
	rhoarr( 55)=      177.53286658D0
	rhoarr( 56)=      155.93071454D0
	rhoarr( 57)=      135.77875626D0
	rhoarr( 58)=      117.36153043D0
	rhoarr( 59)=      100.87154811D0
	rhoarr( 60)=       86.40459251D0
	rhoarr( 61)=       73.96488922D0
	rhoarr( 62)=       63.47753835D0
	rhoarr( 63)=       54.80530141D0
	rhoarr( 64)=       47.76699962D0
	rhoarr( 65)=       42.15530331D0
	rhoarr( 66)=       37.75238835D0
	rhoarr( 67)=       34.34262757D0
	rhoarr( 68)=       31.72206219D0
	rhoarr( 69)=       29.70482067D0
	rhoarr( 70)=       28.12692315D0
	rhoarr( 71)=       26.84804659D0
	rhoarr( 72)=       25.75184428D0
	rhoarr( 73)=       24.74533342D0
	rhoarr( 74)=       23.75771810D0
	rhoarr( 75)=       22.73884604D0
	rhoarr( 76)=       21.65735702D0
	rhoarr( 77)=       20.49850310D0
	rhoarr( 78)=       19.26161761D0
	rhoarr( 79)=       17.95726483D0
	rhoarr( 80)=       16.60418148D0
	rhoarr( 81)=       15.22618916D0
	rhoarr( 82)=       13.84928761D0
	rhoarr( 83)=       12.49912434D0
	rhoarr( 84)=       11.19898426D0
	rhoarr( 85)=        9.96837110D0
	rhoarr( 86)=        8.82218005D0
	rhoarr( 87)=        7.77040309D0
	rhoarr( 88)=        6.81827221D0
	rhoarr( 89)=        5.96673005D0
	rhoarr( 90)=        5.21311887D0
	rhoarr( 91)=        4.55198853D0
	rhoarr( 92)=        3.97593843D0
	rhoarr( 93)=        3.47642346D0
	rhoarr( 94)=        3.04446861D0
	rhoarr( 95)=        2.67125310D0
	rhoarr( 96)=        2.34854109D0
	rhoarr( 97)=        2.06895403D0
	rhoarr( 98)=        1.82609593D0
	rhoarr( 99)=        1.61455704D0
	rhoarr(100)=        1.42982974D0
	rhoarr(101)=        1.26817334D0
	rhoarr(102)=        1.12646164D0
	rhoarr(103)=        1.00203929D0
	rhoarr(104)=        0.89260420D0
	rhoarr(105)=        0.79612304D0
	rhoarr(106)=        0.71077965D0
	rhoarr(107)=        0.63495038D0
	rhoarr(108)=        0.56719804D0
	rhoarr(109)=        0.50627554D0
	rhoarr(110)=        0.45113172D0
	rhoarr(111)=        0.40091335D0
	rhoarr(112)=        0.35495982D0
	rhoarr(113)=        0.31278866D0
	rhoarr(114)=        0.27407182D0
	rhoarr(115)=        0.23860439D0
	rhoarr(116)=        0.20626848D0
	rhoarr(117)=        0.17699614D0
	rhoarr(118)=        0.15073526D0
	rhoarr(119)=        0.12742193D0
	rhoarr(120)=        0.10696170D0
	rhoarr(121)=        0.08922018D0
	rhoarr(122)=        0.07402235D0
	rhoarr(123)=        0.06115837D0
	rhoarr(124)=        0.05039348D0
	rhoarr(125)=        0.04147962D0
	rhoarr(126)=        0.03416677D0
	rhoarr(127)=        0.02821295D0
	rhoarr(128)=        0.02339223D0
	rhoarr(129)=        0.01950056D0
	rhoarr(130)=        0.01635940D0
	rhoarr(131)=        0.01381723D0
	rhoarr(132)=        0.01174913D0
	rhoarr(133)=        0.01005465D0
	rhoarr(134)=        0.00865456D0
	rhoarr(135)=        0.00748701D0
	rhoarr(136)=        0.00650380D0
	rhoarr(137)=        0.00566708D0
	rhoarr(138)=        0.00494689D0
	rhoarr(139)=        0.00431949D0
	rhoarr(140)=        0.00376623D0
	rhoarr(141)=        0.00327285D0
	rhoarr(142)=        0.00282893D0
	rhoarr(143)=        0.00242732D0
	rhoarr(144)=        0.00206350D0
	rhoarr(145)=        0.00173492D0
	rhoarr(146)=        0.00144028D0
	rhoarr(147)=        0.00117890D0
	rhoarr(148)=        0.00095016D0
	rhoarr(149)=        0.00075315D0
	rhoarr(150)=        0.00058642D0
	rhoarr(151)=        0.00044793D0
	rhoarr(152)=        0.00033517D0
	rhoarr(153)=        0.00024526D0
	rhoarr(154)=        0.00017517D0
	rhoarr(155)=        0.00012184D0
	rhoarr(156)=        0.00008232D0
	rhoarr(157)=        0.00005390D0
	rhoarr(158)=        0.00003410D0
	rhoarr(159)=        0.00002080D0
	rhoarr(160)=        0.00001220D0
	rhoarr(161)=        0.00000686D0
	rhoarr(162)=        0.00000369D0
	rhoarr(163)=        0.00000189D0
	rhoarr(164)=        0.00000091D0
	rhoarr(165)=        0.00000041D0
	rhoarr(166)=        0.00000017D0
	rhoarr(167)=        0.00000006D0
	rhoarr(168)=        0.00000002D0

else if (iele==68) then  !Er, 4f12 6s2, 0 3, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=  1257928.53085641D0
	rhoarr(  2)=  1200655.01990702D0
	rhoarr(  3)=  1003580.63415249D0
	rhoarr(  4)=   718841.10452607D0
	rhoarr(  5)=   521799.20475435D0
	rhoarr(  6)=   408152.50098480D0
	rhoarr(  7)=   315003.18161669D0
	rhoarr(  8)=   244160.74838405D0
	rhoarr(  9)=   191139.02159050D0
	rhoarr( 10)=   148712.31534514D0
	rhoarr( 11)=   114777.85603266D0
	rhoarr( 12)=    88139.67877232D0
	rhoarr( 13)=    67329.83701879D0
	rhoarr( 14)=    51105.45822298D0
	rhoarr( 15)=    38588.64693184D0
	rhoarr( 16)=    29095.49563221D0
	rhoarr( 17)=    22023.42737493D0
	rhoarr( 18)=    16839.65382719D0
	rhoarr( 19)=    13092.08082523D0
	rhoarr( 20)=    10413.32826681D0
	rhoarr( 21)=     8513.96665685D0
	rhoarr( 22)=     7169.23364011D0
	rhoarr( 23)=     6206.48638084D0
	rhoarr( 24)=     5495.89687497D0
	rhoarr( 25)=     4943.04312307D0
	rhoarr( 26)=     4482.39340494D0
	rhoarr( 27)=     4071.58509300D0
	rhoarr( 28)=     3686.26593168D0
	rhoarr( 29)=     3315.18368700D0
	rhoarr( 30)=     2955.64406102D0
	rhoarr( 31)=     2609.78611635D0
	rhoarr( 32)=     2281.95452525D0
	rhoarr( 33)=     1977.04806732D0
	rhoarr( 34)=     1699.50226163D0
	rhoarr( 35)=     1452.62428965D0
	rhoarr( 36)=     1238.17705986D0
	rhoarr( 37)=     1056.22445971D0
	rhoarr( 38)=      905.24741247D0
	rhoarr( 39)=      782.47493685D0
	rhoarr( 40)=      684.32185174D0
	rhoarr( 41)=      606.82171874D0
	rhoarr( 42)=      545.98117853D0
	rhoarr( 43)=      498.03070288D0
	rhoarr( 44)=      459.58270352D0
	rhoarr( 45)=      427.72232808D0
	rhoarr( 46)=      400.05362129D0
	rhoarr( 47)=      374.71390807D0
	rhoarr( 48)=      350.36085651D0
	rhoarr( 49)=      326.13366359D0
	rhoarr( 50)=      301.59150209D0
	rhoarr( 51)=      276.63567640D0
	rhoarr( 52)=      251.42400392D0
	rhoarr( 53)=      226.28570270D0
	rhoarr( 54)=      201.64316569D0
	rhoarr( 55)=      177.94470537D0
	rhoarr( 56)=      155.61053969D0
	rhoarr( 57)=      134.99310607D0
	rhoarr( 58)=      116.35190682D0
	rhoarr( 59)=       99.84217481D0
	rhoarr( 60)=       85.51563737D0
	rhoarr( 61)=       73.33074773D0
	rhoarr( 62)=       63.16921123D0
	rhoarr( 63)=       54.85560576D0
	rhoarr( 64)=       48.17733775D0
	rhoarr( 65)=       42.90290297D0
	rhoarr( 66)=       38.79721938D0
	rhoarr( 67)=       35.63350529D0
	rhoarr( 68)=       33.20171487D0
	rhoarr( 69)=       31.31390518D0
	rhoarr( 70)=       29.80711306D0
	rhoarr( 71)=       28.54438856D0
	rhoarr( 72)=       27.41458389D0
	rhoarr( 73)=       26.33136161D0
	rhoarr( 74)=       25.23170673D0
	rhoarr( 75)=       24.07405823D0
	rhoarr( 76)=       22.83606321D0
	rhoarr( 77)=       21.51192568D0
	rhoarr( 78)=       20.10936395D0
	rhoarr( 79)=       18.64627466D0
	rhoarr( 80)=       17.14728592D0
	rhoarr( 81)=       15.64043240D0
	rhoarr( 82)=       14.15418536D0
	rhoarr( 83)=       12.71502361D0
	rhoarr( 84)=       11.34565374D0
	rhoarr( 85)=       10.06390340D0
	rhoarr( 86)=        8.88223807D0
	rhoarr( 87)=        7.80780254D0
	rhoarr( 88)=        6.84286367D0
	rhoarr( 89)=        5.98552778D0
	rhoarr( 90)=        5.23061581D0
	rhoarr( 91)=        4.57059531D0
	rhoarr( 92)=        3.99648585D0
	rhoarr( 93)=        3.49867221D0
	rhoarr( 94)=        3.06757762D0
	rhoarr( 95)=        2.69416852D0
	rhoarr( 96)=        2.37028244D0
	rhoarr( 97)=        2.08878963D0
	rhoarr( 98)=        1.84361541D0
	rhoarr( 99)=        1.62966098D0
	rhoarr(100)=        1.44266356D0
	rhoarr(101)=        1.27903439D0
	rhoarr(102)=        1.13570427D0
	rhoarr(103)=        1.00999627D0
	rhoarr(104)=        0.89953399D0
	rhoarr(105)=        0.80218539D0
	rhoarr(106)=        0.71603600D0
	rhoarr(107)=        0.63938244D0
	rhoarr(108)=        0.57073711D0
	rhoarr(109)=        0.50883544D0
	rhoarr(110)=        0.45263966D0
	rhoarr(111)=        0.40133482D0
	rhoarr(112)=        0.35431471D0
	rhoarr(113)=        0.31115749D0
	rhoarr(114)=        0.27159213D0
	rhoarr(115)=        0.23545864D0
	rhoarr(116)=        0.20266608D0
	rhoarr(117)=        0.17315291D0
	rhoarr(118)=        0.14685381D0
	rhoarr(119)=        0.12367591D0
	rhoarr(120)=        0.10348565D0
	rhoarr(121)=        0.08610560D0
	rhoarr(122)=        0.07131909D0
	rhoarr(123)=        0.05888001D0
	rhoarr(124)=        0.04852498D0
	rhoarr(125)=        0.03998560D0
	rhoarr(126)=        0.03299941D0
	rhoarr(127)=        0.02731889D0
	rhoarr(128)=        0.02271808D0
	rhoarr(129)=        0.01899703D0
	rhoarr(130)=        0.01598401D0
	rhoarr(131)=        0.01353561D0
	rhoarr(132)=        0.01153509D0
	rhoarr(133)=        0.00988930D0
	rhoarr(134)=        0.00852478D0
	rhoarr(135)=        0.00738384D0
	rhoarr(136)=        0.00642085D0
	rhoarr(137)=        0.00559950D0
	rhoarr(138)=        0.00489072D0
	rhoarr(139)=        0.00427137D0
	rhoarr(140)=        0.00372339D0
	rhoarr(141)=        0.00323319D0
	rhoarr(142)=        0.00279105D0
	rhoarr(143)=        0.00239050D0
	rhoarr(144)=        0.00202760D0
	rhoarr(145)=        0.00170024D0
	rhoarr(146)=        0.00140738D0
	rhoarr(147)=        0.00114840D0
	rhoarr(148)=        0.00092264D0
	rhoarr(149)=        0.00072899D0
	rhoarr(150)=        0.00056578D0
	rhoarr(151)=        0.00043079D0
	rhoarr(152)=        0.00032130D0
	rhoarr(153)=        0.00023433D0
	rhoarr(154)=        0.00016679D0
	rhoarr(155)=        0.00011559D0
	rhoarr(156)=        0.00007781D0
	rhoarr(157)=        0.00005074D0
	rhoarr(158)=        0.00003198D0
	rhoarr(159)=        0.00001943D0
	rhoarr(160)=        0.00001135D0
	rhoarr(161)=        0.00000636D0
	rhoarr(162)=        0.00000340D0
	rhoarr(163)=        0.00000173D0
	rhoarr(164)=        0.00000083D0
	rhoarr(165)=        0.00000037D0
	rhoarr(166)=        0.00000015D0
	rhoarr(167)=        0.00000006D0
	rhoarr(168)=        0.00000002D0

else if (iele==69) then  !Tm, 4f13 6s2, 0 2, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=  1366917.25855722D0
	rhoarr(  2)=  1302084.90896975D0
	rhoarr(  3)=  1080662.27085259D0
	rhoarr(  4)=   766507.87009880D0
	rhoarr(  5)=   554244.51567219D0
	rhoarr(  6)=   431597.50832866D0
	rhoarr(  7)=   331131.99060626D0
	rhoarr(  8)=   255641.32532728D0
	rhoarr(  9)=   199266.01535498D0
	rhoarr( 10)=   154286.13269194D0
	rhoarr( 11)=   118534.72770147D0
	rhoarr( 12)=    90632.95821953D0
	rhoarr( 13)=    68939.27519469D0
	rhoarr( 14)=    52109.56526704D0
	rhoarr( 15)=    39201.29016084D0
	rhoarr( 16)=    29473.08861338D0
	rhoarr( 17)=    22272.06377797D0
	rhoarr( 18)=    17026.16682907D0
	rhoarr( 19)=    13255.36758328D0
	rhoarr( 20)=    10573.80281308D0
	rhoarr( 21)=     8680.11253280D0
	rhoarr( 22)=     7341.88989125D0
	rhoarr( 23)=     6381.96793173D0
	rhoarr( 24)=     5668.37698256D0
	rhoarr( 25)=     5106.27146615D0
	rhoarr( 26)=     4630.88395759D0
	rhoarr( 27)=     4201.38014390D0
	rhoarr( 28)=     3795.27364321D0
	rhoarr( 29)=     3403.10819468D0
	rhoarr( 30)=     3023.64533756D0
	rhoarr( 31)=     2660.05689744D0
	rhoarr( 32)=     2317.33619611D0
	rhoarr( 33)=     2000.70920934D0
	rhoarr( 34)=     1714.65582258D0
	rhoarr( 35)=     1462.27138387D0
	rhoarr( 36)=     1244.89593697D0
	rhoarr( 37)=     1062.03463878D0
	rhoarr( 38)=      911.56427719D0
	rhoarr( 39)=      790.14476668D0
	rhoarr( 40)=      693.70926058D0
	rhoarr( 41)=      617.91829761D0
	rhoarr( 42)=      558.51242798D0
	rhoarr( 43)=      511.55020932D0
	rhoarr( 44)=      473.55159537D0
	rhoarr( 45)=      441.57596415D0
	rhoarr( 46)=      413.25722281D0
	rhoarr( 47)=      386.80696675D0
	rhoarr( 48)=      360.98886472D0
	rhoarr( 49)=      335.06595714D0
	rhoarr( 50)=      308.72541085D0
	rhoarr( 51)=      281.98877310D0
	rhoarr( 52)=      255.11726242D0
	rhoarr( 53)=      228.52065210D0
	rhoarr( 54)=      202.67593114D0
	rhoarr( 55)=      178.05950796D0
	rhoarr( 56)=      155.09493507D0
	rhoarr( 57)=      134.11690475D0
	rhoarr( 58)=      115.35121151D0
	rhoarr( 59)=       98.90925627D0
	rhoarr( 60)=       84.79456234D0
	rhoarr( 61)=       72.91795861D0
	rhoarr( 62)=       63.11779774D0
	rhoarr( 63)=       55.18186357D0
	rhoarr( 64)=       48.86833119D0
	rhoarr( 65)=       43.92403208D0
	rhoarr( 66)=       40.09912650D0
	rhoarr( 67)=       37.15796737D0
	rhoarr( 68)=       34.88641842D0
	rhoarr( 69)=       33.09617967D0
	rhoarr( 70)=       31.62680404D0
	rhoarr( 71)=       30.34608455D0
	rhoarr( 72)=       29.14937858D0
	rhoarr( 73)=       27.95825526D0
	rhoarr( 74)=       26.71865837D0
	rhoarr( 75)=       25.39862813D0
	rhoarr( 76)=       23.98555809D0
	rhoarr( 77)=       22.48298436D0
	rhoarr( 78)=       20.90698639D0
	rhoarr( 79)=       19.28237740D0
	rhoarr( 80)=       17.63893588D0
	rhoarr( 81)=       16.00794871D0
	rhoarr( 82)=       14.41929968D0
	rhoarr( 83)=       12.89925716D0
	rhoarr( 84)=       11.46901826D0
	rhoarr( 85)=       10.14397686D0
	rhoarr( 86)=        8.93361719D0
	rhoarr( 87)=        7.84189776D0
	rhoarr( 88)=        6.86798091D0
	rhoarr( 89)=        6.00717038D0
	rhoarr( 90)=        5.25193743D0
	rhoarr( 91)=        4.59293562D0
	rhoarr( 92)=        4.01992562D0
	rhoarr( 93)=        3.52255193D0
	rhoarr( 94)=        3.09093544D0
	rhoarr( 95)=        2.71606858D0
	rhoarr( 96)=        2.39002211D0
	rhoarr( 97)=        2.10599207D0
	rhoarr( 98)=        1.85822809D0
	rhoarr( 99)=        1.64188951D0
	rhoarr(100)=        1.45287294D0
	rhoarr(101)=        1.28764585D0
	rhoarr(102)=        1.14310852D0
	rhoarr(103)=        1.01649463D0
	rhoarr(104)=        0.90531051D0
	rhoarr(105)=        0.80730656D0
	rhoarr(106)=        0.72047103D0
	rhoarr(107)=        0.64303600D0
	rhoarr(108)=        0.57348670D0
	rhoarr(109)=        0.51056733D0
	rhoarr(110)=        0.45327863D0
	rhoarr(111)=        0.40086475D0
	rhoarr(112)=        0.35278832D0
	rhoarr(113)=        0.30869491D0
	rhoarr(114)=        0.26836955D0
	rhoarr(115)=        0.23168962D0
	rhoarr(116)=        0.19857904D0
	rhoarr(117)=        0.16896872D0
	rhoarr(118)=        0.14276700D0
	rhoarr(119)=        0.11984180D0
	rhoarr(120)=        0.10001424D0
	rhoarr(121)=        0.08306168D0
	rhoarr(122)=        0.06872709D0
	rhoarr(123)=        0.05673171D0
	rhoarr(124)=        0.04678829D0
	rhoarr(125)=        0.03861312D0
	rhoarr(126)=        0.03193600D0
	rhoarr(127)=        0.02650785D0
	rhoarr(128)=        0.02210590D0
	rhoarr(129)=        0.01853663D0
	rhoarr(130)=        0.01563648D0
	rhoarr(131)=        0.01327071D0
	rhoarr(132)=        0.01133053D0
	rhoarr(133)=        0.00972933D0
	rhoarr(134)=        0.00839850D0
	rhoarr(135)=        0.00728346D0
	rhoarr(136)=        0.00634050D0
	rhoarr(137)=        0.00553435D0
	rhoarr(138)=        0.00483665D0
	rhoarr(139)=        0.00422488D0
	rhoarr(140)=        0.00368168D0
	rhoarr(141)=        0.00319421D0
	rhoarr(142)=        0.00275353D0
	rhoarr(143)=        0.00235388D0
	rhoarr(144)=        0.00199189D0
	rhoarr(145)=        0.00166587D0
	rhoarr(146)=        0.00137495D0
	rhoarr(147)=        0.00111857D0
	rhoarr(148)=        0.00089593D0
	rhoarr(149)=        0.00070574D0
	rhoarr(150)=        0.00054608D0
	rhoarr(151)=        0.00041453D0
	rhoarr(152)=        0.00030822D0
	rhoarr(153)=        0.00022408D0
	rhoarr(154)=        0.00015896D0
	rhoarr(155)=        0.00010978D0
	rhoarr(156)=        0.00007363D0
	rhoarr(157)=        0.00004784D0
	rhoarr(158)=        0.00003004D0
	rhoarr(159)=        0.00001819D0
	rhoarr(160)=        0.00001059D0
	rhoarr(161)=        0.00000591D0
	rhoarr(162)=        0.00000315D0
	rhoarr(163)=        0.00000159D0
	rhoarr(164)=        0.00000076D0
	rhoarr(165)=        0.00000034D0
	rhoarr(166)=        0.00000014D0
	rhoarr(167)=        0.00000005D0
	rhoarr(168)=        0.00000002D0

else if (iele==70) then  !Yb, 4f14 6s2, 0 1, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=  1484861.80517605D0
	rhoarr(  2)=  1411544.15137640D0
	rhoarr(  3)=  1163034.68346235D0
	rhoarr(  4)=   816862.04519857D0
	rhoarr(  5)=   588423.93042452D0
	rhoarr(  6)=   456073.90671441D0
	rhoarr(  7)=   347853.56825328D0
	rhoarr(  8)=   267484.91402435D0
	rhoarr(  9)=   207583.42745227D0
	rhoarr( 10)=   159943.49766005D0
	rhoarr( 11)=   122318.73436273D0
	rhoarr( 12)=    93123.13527260D0
	rhoarr( 13)=    70530.69313439D0
	rhoarr( 14)=    53092.13189014D0
	rhoarr( 15)=    39796.01672338D0
	rhoarr( 16)=    29839.33747675D0
	rhoarr( 17)=    22516.14793604D0
	rhoarr( 18)=    17213.76261539D0
	rhoarr( 19)=    13423.78800538D0
	rhoarr( 20)=    10741.90445196D0
	rhoarr( 21)=     8854.97123034D0
	rhoarr( 22)=     7523.15651424D0
	rhoarr( 23)=     6565.05608989D0
	rhoarr( 24)=     5846.86630176D0
	rhoarr( 25)=     5273.61485983D0
	rhoarr( 26)=     4781.57459741D0
	rhoarr( 27)=     4331.66922705D0
	rhoarr( 28)=     3903.42678940D0
	rhoarr( 29)=     3489.24455715D0
	rhoarr( 30)=     3089.33020596D0
	rhoarr( 31)=     2707.84480036D0
	rhoarr( 32)=     2350.37247365D0
	rhoarr( 33)=     2022.39741546D0
	rhoarr( 34)=     1728.36289107D0
	rhoarr( 35)=     1471.06499720D0
	rhoarr( 36)=     1251.33944945D0
	rhoarr( 37)=     1068.06978906D0
	rhoarr( 38)=      918.49093266D0
	rhoarr( 39)=      798.67995823D0
	rhoarr( 40)=      704.09237285D0
	rhoarr( 41)=      630.03011565D0
	rhoarr( 42)=      571.98689493D0
	rhoarr( 43)=      525.87043835D0
	rhoarr( 44)=      488.13003638D0
	rhoarr( 45)=      455.82129618D0
	rhoarr( 46)=      426.62938886D0
	rhoarr( 47)=      398.85966801D0
	rhoarr( 48)=      371.39788512D0
	rhoarr( 49)=      343.64243290D0
	rhoarr( 50)=      315.41487047D0
	rhoarr( 51)=      286.85837282D0
	rhoarr( 52)=      258.33448742D0
	rhoarr( 53)=      230.32685031D0
	rhoarr( 54)=      203.35775760D0
	rhoarr( 55)=      177.92099736D0
	rhoarr( 56)=      154.43255382D0
	rhoarr( 57)=      133.19945490D0
	rhoarr( 58)=      114.40576817D0
	rhoarr( 59)=       98.11346299D0
	rhoarr( 60)=       84.27475753D0
	rhoarr( 61)=       72.75196108D0
	rhoarr( 62)=       63.34086395D0
	rhoarr( 63)=       55.79434129D0
	rhoarr( 64)=       49.84378009D0
	rhoarr( 65)=       45.21693458D0
	rhoarr( 66)=       41.65166827D0
	rhoarr( 67)=       38.90566844D0
	rhoarr( 68)=       36.76262032D0
	rhoarr( 69)=       35.03553892D0
	rhoarr( 70)=       33.56800791D0
	rhoarr( 71)=       32.23399685D0
	rhoarr( 72)=       30.93675662D0
	rhoarr( 73)=       29.60708293D0
	rhoarr( 74)=       28.20105177D0
	rhoarr( 75)=       26.69722210D0
	rhoarr( 76)=       25.09329043D0
	rhoarr( 77)=       23.40225340D0
	rhoarr( 78)=       21.64824422D0
	rhoarr( 79)=       19.86230470D0
	rhoarr( 80)=       18.07839934D0
	rhoarr( 81)=       16.32995682D0
	rhoarr( 82)=       14.64714703D0
	rhoarr( 83)=       13.05499552D0
	rhoarr( 84)=       11.57232944D0
	rhoarr( 85)=       10.21146403D0
	rhoarr( 86)=        8.97848601D0
	rhoarr( 87)=        7.87397024D0
	rhoarr( 88)=        6.89396973D0
	rhoarr( 89)=        6.03113696D0
	rhoarr( 90)=        5.27585726D0
	rhoarr( 91)=        4.61729941D0
	rhoarr( 92)=        4.04431227D0
	rhoarr( 93)=        3.54612171D0
	rhoarr( 94)=        3.11280781D0
	rhoarr( 95)=        2.73556863D0
	rhoarr( 96)=        2.40679948D0
	rhoarr( 97)=        2.12003284D0
	rhoarr( 98)=        1.86979132D0
	rhoarr( 99)=        1.65140378D0
	rhoarr(100)=        1.46082481D0
	rhoarr(101)=        1.29448424D0
	rhoarr(102)=        1.14917874D0
	rhoarr(103)=        1.02200620D0
	rhoarr(104)=        0.91033564D0
	rhoarr(105)=        0.81180175D0
	rhoarr(106)=        0.72431297D0
	rhoarr(107)=        0.64606348D0
	rhoarr(108)=        0.57554151D0
	rhoarr(109)=        0.51152913D0
	rhoarr(110)=        0.45309034D0
	rhoarr(111)=        0.39954615D0
	rhoarr(112)=        0.35043737D0
	rhoarr(113)=        0.30547768D0
	rhoarr(114)=        0.26450117D0
	rhoarr(115)=        0.22740996D0
	rhoarr(116)=        0.19412754D0
	rhoarr(117)=        0.16456234D0
	rhoarr(118)=        0.13858418D0
	rhoarr(119)=        0.11601383D0
	rhoarr(120)=        0.09662366D0
	rhoarr(121)=        0.08014631D0
	rhoarr(122)=        0.06628768D0
	rhoarr(123)=        0.05474111D0
	rhoarr(124)=        0.04520069D0
	rhoarr(125)=        0.03737235D0
	rhoarr(126)=        0.03098245D0
	rhoarr(127)=        0.02578384D0
	rhoarr(128)=        0.02155953D0
	rhoarr(129)=        0.01812408D0
	rhoarr(130)=        0.01532294D0
	rhoarr(131)=        0.01302998D0
	rhoarr(132)=        0.01114377D0
	rhoarr(133)=        0.00958333D0
	rhoarr(134)=        0.00828385D0
	rhoarr(135)=        0.00719312D0
	rhoarr(136)=        0.00626878D0
	rhoarr(137)=        0.00547640D0
	rhoarr(138)=        0.00478829D0
	rhoarr(139)=        0.00418264D0
	rhoarr(140)=        0.00364290D0
	rhoarr(141)=        0.00315709D0
	rhoarr(142)=        0.00271707D0
	rhoarr(143)=        0.00231781D0
	rhoarr(144)=        0.00195648D0
	rhoarr(145)=        0.00163170D0
	rhoarr(146)=        0.00134278D0
	rhoarr(147)=        0.00108910D0
	rhoarr(148)=        0.00086968D0
	rhoarr(149)=        0.00068300D0
	rhoarr(150)=        0.00052692D0
	rhoarr(151)=        0.00039879D0
	rhoarr(152)=        0.00029561D0
	rhoarr(153)=        0.00021423D0
	rhoarr(154)=        0.00015146D0
	rhoarr(155)=        0.00010424D0
	rhoarr(156)=        0.00006966D0
	rhoarr(157)=        0.00004510D0
	rhoarr(158)=        0.00002822D0
	rhoarr(159)=        0.00001702D0
	rhoarr(160)=        0.00000987D0
	rhoarr(161)=        0.00000548D0
	rhoarr(162)=        0.00000291D0
	rhoarr(163)=        0.00000146D0
	rhoarr(164)=        0.00000069D0
	rhoarr(165)=        0.00000030D0
	rhoarr(166)=        0.00000012D0
	rhoarr(167)=        0.00000004D0
	rhoarr(168)=        0.00000001D0

else if (iele==71) then  !Lu, 4f14 5d1 6s2, 0 2, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=  1612715.49432243D0
	rhoarr(  2)=  1529855.30483618D0
	rhoarr(  3)=  1251166.54551595D0
	rhoarr(  4)=   870110.89509784D0
	rhoarr(  5)=   624471.57352509D0
	rhoarr(  6)=   481648.36590252D0
	rhoarr(  7)=   365205.63189175D0
	rhoarr(  8)=   279712.63581122D0
	rhoarr(  9)=   216100.76616053D0
	rhoarr( 10)=   165688.81686296D0
	rhoarr( 11)=   126132.25199707D0
	rhoarr( 12)=    95611.71529760D0
	rhoarr( 13)=    72105.50068457D0
	rhoarr( 14)=    54054.94698933D0
	rhoarr( 15)=    40375.03972983D0
	rhoarr( 16)=    30196.72424711D0
	rhoarr( 17)=    22758.24322119D0
	rhoarr( 18)=    17404.94356883D0
	rhoarr( 19)=    13599.70173981D0
	rhoarr( 20)=    10919.79847358D0
	rhoarr( 21)=     9040.47663863D0
	rhoarr( 22)=     7714.71705167D0
	rhoarr( 23)=     6757.18301906D0
	rhoarr( 24)=     6032.55959283D0
	rhoarr( 25)=     5446.05948178D0
	rhoarr( 26)=     4935.28347765D0
	rhoarr( 27)=     4463.14539138D0
	rhoarr( 28)=     4011.32935694D0
	rhoarr( 29)=     3574.13439259D0
	rhoarr( 30)=     3153.19848128D0
	rhoarr( 31)=     2753.62553609D0
	rhoarr( 32)=     2381.52977879D0
	rhoarr( 33)=     2042.57966727D0
	rhoarr( 34)=     1741.09478470D0
	rhoarr( 35)=     1479.47986558D0
	rhoarr( 36)=     1257.98317193D0
	rhoarr( 37)=     1074.80483691D0
	rhoarr( 38)=      926.50238922D0
	rhoarr( 39)=      808.55797528D0
	rhoarr( 40)=      715.95365026D0
	rhoarr( 41)=      643.64598206D0
	rhoarr( 42)=      586.89917829D0
	rhoarr( 43)=      541.48929855D0
	rhoarr( 44)=      503.81522388D0
	rhoarr( 45)=      470.94966501D0
	rhoarr( 46)=      440.64957644D0
	rhoarr( 47)=      411.33275142D0
	rhoarr( 48)=      382.02235717D0
	rhoarr( 49)=      352.26309336D0
	rhoarr( 50)=      322.01716114D0
	rhoarr( 51)=      291.55119733D0
	rhoarr( 52)=      261.32517820D0
	rhoarr( 53)=      231.89185511D0
	rhoarr( 54)=      203.81223255D0
	rhoarr( 55)=      177.59006946D0
	rhoarr( 56)=      153.62655071D0
	rhoarr( 57)=      132.19477308D0
	rhoarr( 58)=      113.43222356D0
	rhoarr( 59)=       97.34805276D0
	rhoarr( 60)=       83.84096771D0
	rhoarr( 61)=       72.72325776D0
	rhoarr( 62)=       63.74686688D0
	rhoarr( 63)=       56.62833570D0
	rhoarr( 64)=       51.07054673D0
	rhoarr( 65)=       46.78024103D0
	rhoarr( 66)=       43.48108270D0
	rhoarr( 67)=       40.92259180D0
	rhoarr( 68)=       38.88557753D0
	rhoarr( 69)=       37.18482629D0
	rhoarr( 70)=       35.66977296D0
	rhoarr( 71)=       34.22374769D0
	rhoarr( 72)=       32.76219717D0
	rhoarr( 73)=       31.23009375D0
	rhoarr( 74)=       29.59862447D0
	rhoarr( 75)=       27.86122514D0
	rhoarr( 76)=       26.02908156D0
	rhoarr( 77)=       24.12631742D0
	rhoarr( 78)=       22.18517416D0
	rhoarr( 79)=       20.24152047D0
	rhoarr( 80)=       18.33099429D0
	rhoarr( 81)=       16.48598953D0
	rhoarr( 82)=       14.73358200D0
	rhoarr( 83)=       13.09437428D0
	rhoarr( 84)=       11.58215109D0
	rhoarr( 85)=       10.20418302D0
	rhoarr( 86)=        8.96199605D0
	rhoarr( 87)=        7.85242767D0
	rhoarr( 88)=        6.86880838D0
	rhoarr( 89)=        6.00213209D0
	rhoarr( 90)=        5.24210931D0
	rhoarr( 91)=        4.57802974D0
	rhoarr( 92)=        3.99939725D0
	rhoarr( 93)=        3.49633540D0
	rhoarr( 94)=        3.05979214D0
	rhoarr( 95)=        2.68159265D0
	rhoarr( 96)=        2.35439718D0
	rhoarr( 97)=        2.07161571D0
	rhoarr( 98)=        1.82731799D0
	rhoarr( 99)=        1.61616039D0
	rhoarr(100)=        1.43333622D0
	rhoarr(101)=        1.27454577D0
	rhoarr(102)=        1.13597862D0
	rhoarr(103)=        1.01430076D0
	rhoarr(104)=        0.90664187D0
	rhoarr(105)=        0.81058026D0
	rhoarr(106)=        0.72412423D0
	rhoarr(107)=        0.64568840D0
	rhoarr(108)=        0.57406279D0
	rhoarr(109)=        0.50837234D0
	rhoarr(110)=        0.44802566D0
	rhoarr(111)=        0.39265417D0
	rhoarr(112)=        0.34204550D0
	rhoarr(113)=        0.29607742D0
	rhoarr(114)=        0.25465907D0
	rhoarr(115)=        0.21768540D0
	rhoarr(116)=        0.18500790D0
	rhoarr(117)=        0.15642180D0
	rhoarr(118)=        0.13166691D0
	rhoarr(119)=        0.11043793D0
	rhoarr(120)=        0.09239937D0
	rhoarr(121)=        0.07720148D0
	rhoarr(122)=        0.06449445D0
	rhoarr(123)=        0.05393995D0
	rhoarr(124)=        0.04521974D0
	rhoarr(125)=        0.03804184D0
	rhoarr(126)=        0.03214461D0
	rhoarr(127)=        0.02729890D0
	rhoarr(128)=        0.02330856D0
	rhoarr(129)=        0.02000913D0
	rhoarr(130)=        0.01726526D0
	rhoarr(131)=        0.01496711D0
	rhoarr(132)=        0.01302637D0
	rhoarr(133)=        0.01137245D0
	rhoarr(134)=        0.00994907D0
	rhoarr(135)=        0.00871160D0
	rhoarr(136)=        0.00762487D0
	rhoarr(137)=        0.00666153D0
	rhoarr(138)=        0.00580064D0
	rhoarr(139)=        0.00502652D0
	rhoarr(140)=        0.00432784D0
	rhoarr(141)=        0.00369664D0
	rhoarr(142)=        0.00312763D0
	rhoarr(143)=        0.00261739D0
	rhoarr(144)=        0.00216367D0
	rhoarr(145)=        0.00176470D0
	rhoarr(146)=        0.00141864D0
	rhoarr(147)=        0.00112310D0
	rhoarr(148)=        0.00087494D0
	rhoarr(149)=        0.00067026D0
	rhoarr(150)=        0.00050450D0
	rhoarr(151)=        0.00037274D0
	rhoarr(152)=        0.00026998D0
	rhoarr(153)=        0.00019138D0
	rhoarr(154)=        0.00013248D0
	rhoarr(155)=        0.00008933D0
	rhoarr(156)=        0.00005848D0
	rhoarr(157)=        0.00003705D0
	rhoarr(158)=        0.00002263D0
	rhoarr(159)=        0.00001330D0
	rhoarr(160)=        0.00000750D0
	rhoarr(161)=        0.00000406D0
	rhoarr(162)=        0.00000211D0
	rhoarr(163)=        0.00000105D0
	rhoarr(164)=        0.00000051D0
	rhoarr(165)=        0.00000023D0
	rhoarr(166)=        0.00000010D0
	rhoarr(167)=        0.00000004D0
	rhoarr(168)=        0.00000002D0

else if (iele==72) then  !Hf, 4f14 5d2 6s2, 0 3, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=  3156231.84202744D0
	rhoarr(  2)=  2004621.18788357D0
	rhoarr(  3)=  1304608.82759614D0
	rhoarr(  4)=   917029.56948618D0
	rhoarr(  5)=   672778.44651017D0
	rhoarr(  6)=   505211.90905059D0
	rhoarr(  7)=   384234.85951288D0
	rhoarr(  8)=   293671.02636794D0
	rhoarr(  9)=   224610.94458927D0
	rhoarr( 10)=   171332.01459958D0
	rhoarr( 11)=   130040.92311665D0
	rhoarr( 12)=    98127.13314439D0
	rhoarr( 13)=    73623.11397344D0
	rhoarr( 14)=    54978.05965264D0
	rhoarr( 15)=    40959.59957284D0
	rhoarr( 16)=    30574.00986139D0
	rhoarr( 17)=    23005.57351157D0
	rhoarr( 18)=    17581.44729735D0
	rhoarr( 19)=    13752.30609965D0
	rhoarr( 20)=    11079.10229279D0
	rhoarr( 21)=     9219.02121935D0
	rhoarr( 22)=     7910.83437186D0
	rhoarr( 23)=     6961.26948040D0
	rhoarr( 24)=     6232.56603023D0
	rhoarr( 25)=     5631.26489689D0
	rhoarr( 26)=     5098.29189494D0
	rhoarr( 27)=     4600.21244249D0
	rhoarr( 28)=     4121.63195118D0
	rhoarr( 29)=     3658.87546437D0
	rhoarr( 30)=     3215.03336290D0
	rhoarr( 31)=     2796.30277817D0
	rhoarr( 32)=     2409.44936142D0
	rhoarr( 33)=     2060.19131906D0
	rhoarr( 34)=     1752.31860926D0
	rhoarr( 35)=     1487.36989272D0
	rhoarr( 36)=     1264.69953161D0
	rhoarr( 37)=     1081.78864469D0
	rhoarr( 38)=      934.68715583D0
	rhoarr( 39)=      818.50590063D0
	rhoarr( 40)=      727.90048787D0
	rhoarr( 41)=      657.50332821D0
	rhoarr( 42)=      602.27347675D0
	rhoarr( 43)=      557.74891334D0
	rhoarr( 44)=      520.20062337D0
	rhoarr( 45)=      486.69874995D0
	rhoarr( 46)=      455.10668646D0
	rhoarr( 47)=      424.02045881D0
	rhoarr( 48)=      392.67021379D0
	rhoarr( 49)=      360.79942143D0
	rhoarr( 50)=      328.53576105D0
	rhoarr( 51)=      296.26539679D0
	rhoarr( 52)=      264.51946775D0
	rhoarr( 53)=      233.87848185D0
	rhoarr( 54)=      204.89738726D0
	rhoarr( 55)=      178.05173673D0
	rhoarr( 56)=      153.70366173D0
	rhoarr( 57)=      132.08527491D0
	rhoarr( 58)=      113.29650067D0
	rhoarr( 59)=       97.31407939D0
	rhoarr( 60)=       84.00850933D0
	rhoarr( 61)=       73.16590282D0
	rhoarr( 62)=       64.51207487D0
	rhoarr( 63)=       57.73660412D0
	rhoarr( 64)=       52.51507981D0
	rhoarr( 65)=       48.52825274D0
	rhoarr( 66)=       45.47731689D0
	rhoarr( 67)=       43.09502435D0
	rhoarr( 68)=       41.15273688D0
	rhoarr( 69)=       39.46381180D0
	rhoarr( 70)=       37.88389821D0
	rhoarr( 71)=       36.30879460D0
	rhoarr( 72)=       34.67052002D0
	rhoarr( 73)=       32.93220695D0
	rhoarr( 74)=       31.08236040D0
	rhoarr( 75)=       29.12895343D0
	rhoarr( 76)=       27.09374827D0
	rhoarr( 77)=       25.00714290D0
	rhoarr( 78)=       22.90374787D0
	rhoarr( 79)=       20.81880261D0
	rhoarr( 80)=       18.78545529D0
	rhoarr( 81)=       16.83286173D0
	rhoarr( 82)=       14.98501293D0
	rhoarr( 83)=       13.26017547D0
	rhoarr( 84)=       11.67082122D0
	rhoarr( 85)=       10.22392605D0
	rhoarr( 86)=        8.92152743D0
	rhoarr( 87)=        7.76144397D0
	rhoarr( 88)=        6.73807470D0
	rhoarr( 89)=        5.84321160D0
	rhoarr( 90)=        5.06681473D0
	rhoarr( 91)=        4.39771509D0
	rhoarr( 92)=        3.82422436D0
	rhoarr( 93)=        3.33464243D0
	rhoarr( 94)=        2.91766216D0
	rhoarr( 95)=        2.56267588D0
	rhoarr( 96)=        2.25999129D0
	rhoarr( 97)=        2.00096550D0
	rhoarr( 98)=        1.77806716D0
	rhoarr( 99)=        1.58487713D0
	rhoarr(100)=        1.41603957D0
	rhoarr(101)=        1.26717597D0
	rhoarr(102)=        1.13477487D0
	rhoarr(103)=        1.01606962D0
	rhoarr(104)=        0.90891453D0
	rhoarr(105)=        0.81166769D0
	rhoarr(106)=        0.72308547D0
	rhoarr(107)=        0.64223145D0
	rhoarr(108)=        0.56840000D0
	rhoarr(109)=        0.50105350D0
	rhoarr(110)=        0.43977157D0
	rhoarr(111)=        0.38421041D0
	rhoarr(112)=        0.33407091D0
	rhoarr(113)=        0.28907432D0
	rhoarr(114)=        0.24894481D0
	rhoarr(115)=        0.21339815D0
	rhoarr(116)=        0.18213592D0
	rhoarr(117)=        0.15484431D0
	rhoarr(118)=        0.13119660D0
	rhoarr(119)=        0.11085797D0
	rhoarr(120)=        0.09349170D0
	rhoarr(121)=        0.07876569D0
	rhoarr(122)=        0.06635856D0
	rhoarr(123)=        0.05596502D0
	rhoarr(124)=        0.04730008D0
	rhoarr(125)=        0.04010222D0
	rhoarr(126)=        0.03413542D0
	rhoarr(127)=        0.02919025D0
	rhoarr(128)=        0.02508401D0
	rhoarr(129)=        0.02166013D0
	rhoarr(130)=        0.01878678D0
	rhoarr(131)=        0.01635499D0
	rhoarr(132)=        0.01427632D0
	rhoarr(133)=        0.01248035D0
	rhoarr(134)=        0.01091203D0
	rhoarr(135)=        0.00952920D0
	rhoarr(136)=        0.00830015D0
	rhoarr(137)=        0.00720155D0
	rhoarr(138)=        0.00621645D0
	rhoarr(139)=        0.00533268D0
	rhoarr(140)=        0.00454139D0
	rhoarr(141)=        0.00383590D0
	rhoarr(142)=        0.00321073D0
	rhoarr(143)=        0.00266100D0
	rhoarr(144)=        0.00218190D0
	rhoarr(145)=        0.00176847D0
	rhoarr(146)=        0.00141555D0
	rhoarr(147)=        0.00111774D0
	rhoarr(148)=        0.00086954D0
	rhoarr(149)=        0.00066547D0
	rhoarr(150)=        0.00050014D0
	rhoarr(151)=        0.00036836D0
	rhoarr(152)=        0.00026522D0
	rhoarr(153)=        0.00018614D0
	rhoarr(154)=        0.00012690D0
	rhoarr(155)=        0.00008371D0
	rhoarr(156)=        0.00005317D0
	rhoarr(157)=        0.00003234D0
	rhoarr(158)=        0.00001872D0
	rhoarr(159)=        0.00001023D0
	rhoarr(160)=        0.00000523D0
	rhoarr(161)=        0.00000247D0
	rhoarr(162)=        0.00000107D0
	rhoarr(163)=        0.00000041D0
	rhoarr(164)=        0.00000014D0
	rhoarr(165)=        0.00000004D0

else if (iele==73) then  !Ta, 4f14 5d3 6s2, 0 4, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=  3280364.97034237D0
	rhoarr(  2)=  2181657.38949567D0
	rhoarr(  3)=  1405280.14004362D0
	rhoarr(  4)=   978014.25256637D0
	rhoarr(  5)=   712652.25567709D0
	rhoarr(  6)=   532972.40372163D0
	rhoarr(  7)=   403041.07853583D0
	rhoarr(  8)=   306729.05210836D0
	rhoarr(  9)=   233469.13260215D0
	rhoarr( 10)=   177204.76988011D0
	rhoarr( 11)=   133910.04125839D0
	rhoarr( 12)=   100609.25931360D0
	rhoarr( 13)=    75148.97080468D0
	rhoarr( 14)=    55888.46105750D0
	rhoarr( 15)=    41505.19749591D0
	rhoarr( 16)=    30917.68018330D0
	rhoarr( 17)=    23245.98970727D0
	rhoarr( 18)=    17777.83620150D0
	rhoarr( 19)=    13939.27326315D0
	rhoarr( 20)=    11273.68255303D0
	rhoarr( 21)=     9425.14507200D0
	rhoarr( 22)=     8123.81719423D0
	rhoarr( 23)=     7172.30473158D0
	rhoarr( 24)=     6432.33903297D0
	rhoarr( 25)=     5812.17090974D0
	rhoarr( 26)=     5255.35368048D0
	rhoarr( 27)=     4731.12363425D0
	rhoarr( 28)=     4226.36588129D0
	rhoarr( 29)=     3739.15561059D0
	rhoarr( 30)=     3273.80790331D0
	rhoarr( 31)=     2837.26772035D0
	rhoarr( 32)=     2436.62566405D0
	rhoarr( 33)=     2077.55837701D0
	rhoarr( 34)=     1763.51453123D0
	rhoarr( 35)=     1495.47252054D0
	rhoarr( 36)=     1272.09693008D0
	rhoarr( 37)=     1090.13730551D0
	rhoarr( 38)=      944.94577294D0
	rhoarr( 39)=      831.02569331D0
	rhoarr( 40)=      742.55048490D0
	rhoarr( 41)=      673.81008304D0
	rhoarr( 42)=      619.55817893D0
	rhoarr( 43)=      575.24957929D0
	rhoarr( 44)=      537.17191191D0
	rhoarr( 45)=      502.48617737D0
	rhoarr( 46)=      469.19523420D0
	rhoarr( 47)=      436.05975132D0
	rhoarr( 48)=      402.47976616D0
	rhoarr( 49)=      368.35812823D0
	rhoarr( 50)=      333.95999324D0
	rhoarr( 51)=      299.77991822D0
	rhoarr( 52)=      266.42497627D0
	rhoarr( 53)=      234.51900742D0
	rhoarr( 54)=      204.63011170D0
	rhoarr( 55)=      177.22109401D0
	rhoarr( 56)=      152.62088068D0
	rhoarr( 57)=      131.01388017D0
	rhoarr( 58)=      112.44372869D0
	rhoarr( 59)=       96.82772361D0
	rhoarr( 60)=       83.97839476D0
	rhoarr( 61)=       73.62900434D0
	rhoarr( 62)=       65.46022070D0
	rhoarr( 63)=       59.12572674D0
	rhoarr( 64)=       54.27506926D0
	rhoarr( 65)=       50.57261097D0
	rhoarr( 66)=       47.71198805D0
	rhoarr( 67)=       45.42596382D0
	rhoarr( 68)=       43.49196503D0
	rhoarr( 69)=       41.73386119D0
	rhoarr( 70)=       40.02069602D0
	rhoarr( 71)=       38.26312112D0
	rhoarr( 72)=       36.40824964D0
	rhoarr( 73)=       34.43357431D0
	rhoarr( 74)=       32.34050558D0
	rhoarr( 75)=       30.14799219D0
	rhoarr( 76)=       27.88659023D0
	rhoarr( 77)=       25.59324768D0
	rhoarr( 78)=       23.30697013D0
	rhoarr( 79)=       21.06543640D0
	rhoarr( 80)=       18.90254958D0
	rhoarr( 81)=       16.84684505D0
	rhoarr( 82)=       14.92063718D0
	rhoarr( 83)=       13.13976781D0
	rhoarr( 84)=       11.51381758D0
	rhoarr( 85)=       10.04664969D0
	rhoarr( 86)=        8.73717019D0
	rhoarr( 87)=        7.58020555D0
	rhoarr( 88)=        6.56741619D0
	rhoarr( 89)=        5.68818273D0
	rhoarr( 90)=        4.93041964D0
	rhoarr( 91)=        4.28128767D0
	rhoarr( 92)=        3.72779131D0
	rhoarr( 93)=        3.25725855D0
	rhoarr( 94)=        2.85770811D0
	rhoarr( 95)=        2.51811345D0
	rhoarr( 96)=        2.22857457D0
	rhoarr( 97)=        1.98040884D0
	rhoarr( 98)=        1.76617260D0
	rhoarr( 99)=        1.57962511D0
	rhoarr(100)=        1.41564749D0
	rhoarr(101)=        1.27012954D0
	rhoarr(102)=        1.13983748D0
	rhoarr(103)=        1.02227458D0
	rhoarr(104)=        0.91554494D0
	rhoarr(105)=        0.81822787D0
	rhoarr(106)=        0.72926756D0
	rhoarr(107)=        0.64787989D0
	rhoarr(108)=        0.57347615D0
	rhoarr(109)=        0.50560219D0
	rhoarr(110)=        0.44389083D0
	rhoarr(111)=        0.38802540D0
	rhoarr(112)=        0.33771265D0
	rhoarr(113)=        0.29266352D0
	rhoarr(114)=        0.25258073D0
	rhoarr(115)=        0.21715218D0
	rhoarr(116)=        0.18604918D0
	rhoarr(117)=        0.15892853D0
	rhoarr(118)=        0.13543734D0
	rhoarr(119)=        0.11521933D0
	rhoarr(120)=        0.09792179D0
	rhoarr(121)=        0.08320224D0
	rhoarr(122)=        0.07073430D0
	rhoarr(123)=        0.06021244D0
	rhoarr(124)=        0.05135560D0
	rhoarr(125)=        0.04390946D0
	rhoarr(126)=        0.03764775D0
	rhoarr(127)=        0.03237247D0
	rhoarr(128)=        0.02791320D0
	rhoarr(129)=        0.02412572D0
	rhoarr(130)=        0.02088991D0
	rhoarr(131)=        0.01810729D0
	rhoarr(132)=        0.01569823D0
	rhoarr(133)=        0.01359915D0
	rhoarr(134)=        0.01175980D0
	rhoarr(135)=        0.01014078D0
	rhoarr(136)=        0.00871134D0
	rhoarr(137)=        0.00744751D0
	rhoarr(138)=        0.00633050D0
	rhoarr(139)=        0.00534536D0
	rhoarr(140)=        0.00447986D0
	rhoarr(141)=        0.00372361D0
	rhoarr(142)=        0.00306733D0
	rhoarr(143)=        0.00250237D0
	rhoarr(144)=        0.00202038D0
	rhoarr(145)=        0.00161320D0
	rhoarr(146)=        0.00127280D0
	rhoarr(147)=        0.00099137D0
	rhoarr(148)=        0.00076144D0
	rhoarr(149)=        0.00057595D0
	rhoarr(150)=        0.00042834D0
	rhoarr(151)=        0.00031262D0
	rhoarr(152)=        0.00022339D0
	rhoarr(153)=        0.00015585D0
	rhoarr(154)=        0.00010579D0
	rhoarr(155)=        0.00006959D0
	rhoarr(156)=        0.00004414D0
	rhoarr(157)=        0.00002684D0
	rhoarr(158)=        0.00001554D0
	rhoarr(159)=        0.00000850D0
	rhoarr(160)=        0.00000435D0
	rhoarr(161)=        0.00000206D0
	rhoarr(162)=        0.00000089D0
	rhoarr(163)=        0.00000034D0
	rhoarr(164)=        0.00000012D0
	rhoarr(165)=        0.00000003D0

else if (iele==74) then  !W, 4f14 5d4 6s2, 0 5, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=  3566131.36459404D0
	rhoarr(  2)=  2357562.36005984D0
	rhoarr(  3)=  1507108.73946556D0
	rhoarr(  4)=  1042120.04423121D0
	rhoarr(  5)=   755039.06622516D0
	rhoarr(  6)=   561726.27558958D0
	rhoarr(  7)=   422657.81114131D0
	rhoarr(  8)=   320105.78293225D0
	rhoarr(  9)=   242491.84972687D0
	rhoarr( 10)=   183186.82592568D0
	rhoarr( 11)=   137790.66847223D0
	rhoarr( 12)=   103058.84530280D0
	rhoarr( 13)=    76649.37206571D0
	rhoarr( 14)=    56784.50203468D0
	rhoarr( 15)=    42037.90492133D0
	rhoarr( 16)=    31249.40668826D0
	rhoarr( 17)=    23480.77221442D0
	rhoarr( 18)=    17977.61612007D0
	rhoarr( 19)=    14136.49099006D0
	rhoarr( 20)=    11481.02260086D0
	rhoarr( 21)=     9643.01710006D0
	rhoarr( 22)=     8345.96709094D0
	rhoarr( 23)=     7389.84607061D0
	rhoarr( 24)=     6636.44580999D0
	rhoarr( 25)=     5995.67621035D0
	rhoarr( 26)=     5413.50933229D0
	rhoarr( 27)=     4861.76098866D0
	rhoarr( 28)=     4329.66301467D0
	rhoarr( 29)=     3817.17645131D0
	rhoarr( 30)=     3329.94118371D0
	rhoarr( 31)=     2875.65890379D0
	rhoarr( 32)=     2461.66405083D0
	rhoarr( 33)=     2093.45650407D0
	rhoarr( 34)=     1773.99797018D0
	rhoarr( 35)=     1503.58349818D0
	rhoarr( 36)=     1280.10359450D0
	rhoarr( 37)=     1099.53217313D0
	rhoarr( 38)=      956.51240439D0
	rhoarr( 39)=      844.95157148D0
	rhoarr( 40)=      758.56535966D0
	rhoarr( 41)=      691.33175311D0
	rhoarr( 42)=      637.83123757D0
	rhoarr( 43)=      593.46666505D0
	rhoarr( 44)=      554.57105039D0
	rhoarr( 45)=      518.42144256D0
	rhoarr( 46)=      483.18090924D0
	rhoarr( 47)=      447.79033495D0
	rhoarr( 48)=      411.82960043D0
	rhoarr( 49)=      375.36521030D0
	rhoarr( 50)=      338.79878031D0
	rhoarr( 51)=      302.72774423D0
	rhoarr( 52)=      267.82618680D0
	rhoarr( 53)=      234.75020194D0
	rhoarr( 54)=      204.06906561D0
	rhoarr( 55)=      176.22109829D0
	rhoarr( 56)=      151.49144739D0
	rhoarr( 57)=      130.00806390D0
	rhoarr( 58)=      111.75174365D0
	rhoarr( 59)=       96.57611309D0
	rhoarr( 60)=       84.23373842D0
	rhoarr( 61)=       74.40501570D0
	rhoarr( 62)=       66.72707030D0
	rhoarr( 63)=       60.82049905D0
	rhoarr( 64)=       56.31239824D0
	rhoarr( 65)=       52.85471889D0
	rhoarr( 66)=       50.13755297D0
	rhoarr( 67)=       47.89744583D0
	rhoarr( 68)=       45.92121103D0
	rhoarr( 69)=       44.04597087D0
	rhoarr( 70)=       42.15625842D0
	rhoarr( 71)=       40.17902036D0
	rhoarr( 72)=       38.07729198D0
	rhoarr( 73)=       35.84321217D0
	rhoarr( 74)=       33.49093324D0
	rhoarr( 75)=       31.04986878D0
	rhoarr( 76)=       28.55861351D0
	rhoarr( 77)=       26.05976168D0
	rhoarr( 78)=       23.59574572D0
	rhoarr( 79)=       21.20572022D0
	rhoarr( 80)=       18.92343701D0
	rhoarr( 81)=       16.77599912D0
	rhoarr( 82)=       14.78334924D0
	rhoarr( 83)=       12.95833635D0
	rhoarr( 84)=       11.30720874D0
	rhoarr( 85)=        9.83039557D0
	rhoarr( 86)=        8.52345735D0
	rhoarr( 87)=        7.37810619D0
	rhoarr( 88)=        6.38321690D0
	rhoarr( 89)=        5.52577055D0
	rhoarr( 90)=        4.79169136D0
	rhoarr( 91)=        4.16655549D0
	rhoarr( 92)=        3.63616494D0
	rhoarr( 93)=        3.18699046D0
	rhoarr( 94)=        2.80649430D0
	rhoarr( 95)=        2.48334621D0
	rhoarr( 96)=        2.20754709D0
	rhoarr( 97)=        1.97047383D0
	rhoarr( 98)=        1.76485840D0
	rhoarr( 99)=        1.58471409D0
	rhoarr(100)=        1.42522195D0
	rhoarr(101)=        1.28259077D0
	rhoarr(102)=        1.15390357D0
	rhoarr(103)=        1.03696230D0
	rhoarr(104)=        0.93014054D0
	rhoarr(105)=        0.83225093D0
	rhoarr(106)=        0.74243142D0
	rhoarr(107)=        0.66005139D0
	rhoarr(108)=        0.58463685D0
	rhoarr(109)=        0.51581271D0
	rhoarr(110)=        0.45325952D0
	rhoarr(111)=        0.39668221D0
	rhoarr(112)=        0.34578857D0
	rhoarr(113)=        0.30027583D0
	rhoarr(114)=        0.25982367D0
	rhoarr(115)=        0.22409256D0
	rhoarr(116)=        0.19272598D0
	rhoarr(117)=        0.16535558D0
	rhoarr(118)=        0.14160790D0
	rhoarr(119)=        0.12111168D0
	rhoarr(120)=        0.10350505D0
	rhoarr(121)=        0.08844170D0
	rhoarr(122)=        0.07559604D0
	rhoarr(123)=        0.06466699D0
	rhoarr(124)=        0.05538056D0
	rhoarr(125)=        0.04749126D0
	rhoarr(126)=        0.04078247D0
	rhoarr(127)=        0.03506596D0
	rhoarr(128)=        0.03018060D0
	rhoarr(129)=        0.02599042D0
	rhoarr(130)=        0.02238221D0
	rhoarr(131)=        0.01926274D0
	rhoarr(132)=        0.01655587D0
	rhoarr(133)=        0.01419977D0
	rhoarr(134)=        0.01214427D0
	rhoarr(135)=        0.01034859D0
	rhoarr(136)=        0.00877943D0
	rhoarr(137)=        0.00740941D0
	rhoarr(138)=        0.00621573D0
	rhoarr(139)=        0.00517919D0
	rhoarr(140)=        0.00428329D0
	rhoarr(141)=        0.00351348D0
	rhoarr(142)=        0.00285667D0
	rhoarr(143)=        0.00230075D0
	rhoarr(144)=        0.00183438D0
	rhoarr(145)=        0.00144684D0
	rhoarr(146)=        0.00112807D0
	rhoarr(147)=        0.00086864D0
	rhoarr(148)=        0.00065990D0
	rhoarr(149)=        0.00049397D0
	rhoarr(150)=        0.00036377D0
	rhoarr(151)=        0.00026307D0
	rhoarr(152)=        0.00018639D0
	rhoarr(153)=        0.00012903D0
	rhoarr(154)=        0.00008698D0
	rhoarr(155)=        0.00005687D0
	rhoarr(156)=        0.00003588D0
	rhoarr(157)=        0.00002171D0
	rhoarr(158)=        0.00001252D0
	rhoarr(159)=        0.00000683D0
	rhoarr(160)=        0.00000348D0
	rhoarr(161)=        0.00000164D0
	rhoarr(162)=        0.00000071D0
	rhoarr(163)=        0.00000027D0
	rhoarr(164)=        0.00000009D0
	rhoarr(165)=        0.00000003D0

else if (iele==75) then  !Re, 4f14 5d5 6s2, 0 6, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=  3875906.43907679D0
	rhoarr(  2)=  2546956.80415370D0
	rhoarr(  3)=  1615752.13914237D0
	rhoarr(  4)=  1109963.73336883D0
	rhoarr(  5)=   799564.37866220D0
	rhoarr(  6)=   591716.94680150D0
	rhoarr(  7)=   442971.86400029D0
	rhoarr(  8)=   333857.05932287D0
	rhoarr(  9)=   251695.67024660D0
	rhoarr( 10)=   189238.27405808D0
	rhoarr( 11)=   141681.09487087D0
	rhoarr( 12)=   105490.75456399D0
	rhoarr( 13)=    78123.76084234D0
	rhoarr( 14)=    57656.83292773D0
	rhoarr( 15)=    42554.17758460D0
	rhoarr( 16)=    31573.30231661D0
	rhoarr( 17)=    23715.51650154D0
	rhoarr( 18)=    18183.27631134D0
	rhoarr( 19)=    14343.29159565D0
	rhoarr( 20)=    11699.54184551D0
	rhoarr( 21)=     9871.92424804D0
	rhoarr( 22)=     8577.75033027D0
	rhoarr( 23)=     7614.86220674D0
	rhoarr( 24)=     6845.56493721D0
	rhoarr( 25)=     6181.79284015D0
	rhoarr( 26)=     5572.19736246D0
	rhoarr( 27)=     4991.32992861D0
	rhoarr( 28)=     4430.83235114D0
	rhoarr( 29)=     3892.54009114D0
	rhoarr( 30)=     3383.35236887D0
	rhoarr( 31)=     2911.62846482D0
	rhoarr( 32)=     2484.83207768D0
	rhoarr( 33)=     2108.17138846D0
	rhoarr( 34)=     1784.01732248D0
	rhoarr( 35)=     1511.89667636D0
	rhoarr( 36)=     1288.86413552D0
	rhoarr( 37)=     1110.08050944D0
	rhoarr( 38)=      969.46534241D0
	rhoarr( 39)=      860.33463559D0
	rhoarr( 40)=      775.96612134D0
	rhoarr( 41)=      710.05564603D0
	rhoarr( 42)=      657.04549089D0
	rhoarr( 43)=      612.32244135D0
	rhoarr( 44)=      572.29820384D0
	rhoarr( 45)=      534.39409083D0
	rhoarr( 46)=      496.95497369D0
	rhoarr( 47)=      459.11629031D0
	rhoarr( 48)=      420.64496459D0
	rhoarr( 49)=      381.77192046D0
	rhoarr( 50)=      343.03066550D0
	rhoarr( 51)=      305.11293888D0
	rhoarr( 52)=      268.74866298D0
	rhoarr( 53)=      234.61375482D0
	rhoarr( 54)=      203.26617450D0
	rhoarr( 55)=      175.10818637D0
	rhoarr( 56)=      150.37123657D0
	rhoarr( 57)=      129.11901307D0
	rhoarr( 58)=      111.26399991D0
	rhoarr( 59)=       96.59301302D0
	rhoarr( 60)=       84.79766693D0
	rhoarr( 61)=       75.50634564D0
	rhoarr( 62)=       68.31493779D0
	rhoarr( 63)=       62.81428769D0
	rhoarr( 64)=       58.61298171D0
	rhoarr( 65)=       55.35472207D0
	rhoarr( 66)=       52.73011575D0
	rhoarr( 67)=       50.48319112D0
	rhoarr( 68)=       48.41331375D0
	rhoarr( 69)=       46.37338442D0
	rhoarr( 70)=       44.26527420D0
	rhoarr( 71)=       42.03341322D0
	rhoarr( 72)=       39.65734481D0
	rhoarr( 73)=       37.14392285D0
	rhoarr( 74)=       34.51969408D0
	rhoarr( 75)=       31.82387869D0
	rhoarr( 76)=       29.10224289D0
	rhoarr( 77)=       26.40204330D0
	rhoarr( 78)=       23.76811706D0
	rhoarr( 79)=       21.24009725D0
	rhoarr( 80)=       18.85065919D0
	rhoarr( 81)=       16.62465295D0
	rhoarr( 82)=       14.57895276D0
	rhoarr( 83)=       12.72285004D0
	rhoarr( 84)=       11.05882762D0
	rhoarr( 85)=        9.58357167D0
	rhoarr( 86)=        8.28910041D0
	rhoarr( 87)=        7.16391186D0
	rhoarr( 88)=        6.19407601D0
	rhoarr( 89)=        5.36421890D0
	rhoarr( 90)=        4.65836669D0
	rhoarr( 91)=        4.06063599D0
	rhoarr( 92)=        3.55577117D0
	rhoarr( 93)=        3.12953936D0
	rhoarr( 94)=        2.76899944D0
	rhoarr( 95)=        2.46266281D0
	rhoarr( 96)=        2.20056345D0
	rhoarr( 97)=        1.97425298D0
	rhoarr( 98)=        1.77673519D0
	rhoarr( 99)=        1.60235387D0
	rhoarr(100)=        1.44664739D0
	rhoarr(101)=        1.30618357D0
	rhoarr(102)=        1.17838735D0
	rhoarr(103)=        1.06137250D0
	rhoarr(104)=        0.95378635D0
	rhoarr(105)=        0.85467326D0
	rhoarr(106)=        0.76336003D0
	rhoarr(107)=        0.67936348D0
	rhoarr(108)=        0.60231881D0
	rhoarr(109)=        0.53192606D0
	rhoarr(110)=        0.46791183D0
	rhoarr(111)=        0.41000340D0
	rhoarr(112)=        0.35791281D0
	rhoarr(113)=        0.31132880D0
	rhoarr(114)=        0.26991481D0
	rhoarr(115)=        0.23331154D0
	rhoarr(116)=        0.20114262D0
	rhoarr(117)=        0.17302207D0
	rhoarr(118)=        0.14856250D0
	rhoarr(119)=        0.12738303D0
	rhoarr(120)=        0.10911628D0
	rhoarr(121)=        0.09341413D0
	rhoarr(122)=        0.07995195D0
	rhoarr(123)=        0.06843160D0
	rhoarr(124)=        0.05858318D0
	rhoarr(125)=        0.05016573D0
	rhoarr(126)=        0.04296704D0
	rhoarr(127)=        0.03680279D0
	rhoarr(128)=        0.03151492D0
	rhoarr(129)=        0.02696953D0
	rhoarr(130)=        0.02305430D0
	rhoarr(131)=        0.01967569D0
	rhoarr(132)=        0.01675608D0
	rhoarr(133)=        0.01423102D0
	rhoarr(134)=        0.01204679D0
	rhoarr(135)=        0.01015830D0
	rhoarr(136)=        0.00852748D0
	rhoarr(137)=        0.00712190D0
	rhoarr(138)=        0.00591383D0
	rhoarr(139)=        0.00487930D0
	rhoarr(140)=        0.00399750D0
	rhoarr(141)=        0.00325011D0
	rhoarr(142)=        0.00262078D0
	rhoarr(143)=        0.00209481D0
	rhoarr(144)=        0.00165878D0
	rhoarr(145)=        0.00130046D0
	rhoarr(146)=        0.00100870D0
	rhoarr(147)=        0.00077344D0
	rhoarr(148)=        0.00058566D0
	rhoarr(149)=        0.00043740D0
	rhoarr(150)=        0.00032172D0
	rhoarr(151)=        0.00023260D0
	rhoarr(152)=        0.00016493D0
	rhoarr(153)=        0.00011436D0
	rhoarr(154)=        0.00007727D0
	rhoarr(155)=        0.00005067D0
	rhoarr(156)=        0.00003207D0
	rhoarr(157)=        0.00001948D0
	rhoarr(158)=        0.00001128D0
	rhoarr(159)=        0.00000617D0
	rhoarr(160)=        0.00000316D0
	rhoarr(161)=        0.00000149D0
	rhoarr(162)=        0.00000064D0
	rhoarr(163)=        0.00000025D0
	rhoarr(164)=        0.00000008D0
	rhoarr(165)=        0.00000002D0

else if (iele==76) then  !Re, 4f14 5d6 6s2, 0 5, HF/UGBS int=dkh2
	npt=  166
	rhoarr(  1)=  4211727.60761208D0
	rhoarr(  2)=  2750879.44532650D0
	rhoarr(  3)=  1731659.45722238D0
	rhoarr(  4)=  1181753.10782986D0
	rhoarr(  5)=   846325.75314366D0
	rhoarr(  6)=   622988.23798151D0
	rhoarr(  7)=   463999.85031868D0
	rhoarr(  8)=   347986.48581024D0
	rhoarr(  9)=   261078.52525216D0
	rhoarr( 10)=   195355.26201843D0
	rhoarr( 11)=   145577.64788745D0
	rhoarr( 12)=   107902.32474062D0
	rhoarr( 13)=    79570.71330069D0
	rhoarr( 14)=    58505.18384522D0
	rhoarr( 15)=    43054.63595105D0
	rhoarr( 16)=    31890.51106057D0
	rhoarr( 17)=    23951.50028620D0
	rhoarr( 18)=    18395.91254996D0
	rhoarr( 19)=    14560.42404070D0
	rhoarr( 20)=    11929.63802371D0
	rhoarr( 21)=    10112.00766386D0
	rhoarr( 22)=     8819.15849265D0
	rhoarr( 23)=     7847.25736922D0
	rhoarr( 24)=     7059.52532120D0
	rhoarr( 25)=     6370.26668795D0
	rhoarr( 26)=     5731.08771620D0
	rhoarr( 27)=     5119.46178102D0
	rhoarr( 28)=     4529.52634578D0
	rhoarr( 29)=     3964.98098255D0
	rhoarr( 30)=     3433.89886231D0
	rhoarr( 31)=     2945.16654563D0
	rhoarr( 32)=     2506.23223335D0
	rhoarr( 33)=     2121.87732558D0
	rhoarr( 34)=     1793.77150103D0
	rhoarr( 35)=     1520.59366623D0
	rhoarr( 36)=     1298.51362359D0
	rhoarr( 37)=     1121.85659247D0
	rhoarr( 38)=      983.81708969D0
	rhoarr( 39)=      877.13395978D0
	rhoarr( 40)=      794.67166532D0
	rhoarr( 41)=      729.87492012D0
	rhoarr( 42)=      677.08154970D0
	rhoarr( 43)=      631.69574202D0
	rhoarr( 44)=      590.23857653D0
	rhoarr( 45)=      550.30155708D0
	rhoarr( 46)=      510.43116917D0
	rhoarr( 47)=      469.97038403D0
	rhoarr( 48)=      428.87925904D0
	rhoarr( 49)=      387.55287226D0
	rhoarr( 50)=      346.65101061D0
	rhoarr( 51)=      306.95008153D0
	rhoarr( 52)=      269.22364906D0
	rhoarr( 53)=      234.15414644D0
	rhoarr( 54)=      202.27509830D0
	rhoarr( 55)=      173.94083475D0
	rhoarr( 56)=      149.31922221D0
	rhoarr( 57)=      128.40225497D0
	rhoarr( 58)=      111.02928066D0
	rhoarr( 59)=       96.91799793D0
	rhoarr( 60)=       85.69900438D0
	rhoarr( 61)=       76.95044581D0
	rhoarr( 62)=       70.23011890D0
	rhoarr( 63)=       65.10314884D0
	rhoarr( 64)=       61.16407978D0
	rhoarr( 65)=       58.05287114D0
	rhoarr( 66)=       55.46487000D0
	rhoarr( 67)=       53.15529864D0
	rhoarr( 68)=       50.93912281D0
	rhoarr( 69)=       48.68733682D0
	rhoarr( 70)=       46.32072682D0
	rhoarr( 71)=       43.80209227D0
	rhoarr( 72)=       41.12776234D0
	rhoarr( 73)=       38.31908107D0
	rhoarr( 74)=       35.41437745D0
	rhoarr( 75)=       32.46179391D0
	rhoarr( 76)=       29.51321842D0
	rhoarr( 77)=       26.61944853D0
	rhoarr( 78)=       23.82660988D0
	rhoarr( 79)=       21.17376232D0
	rhoarr( 80)=       18.69155949D0
	rhoarr( 81)=       16.40178608D0
	rhoarr( 82)=       14.31758102D0
	rhoarr( 83)=       12.44415871D0
	rhoarr( 84)=       10.77985785D0
	rhoarr( 85)=        9.31737125D0
	rhoarr( 86)=        8.04503625D0
	rhoarr( 87)=        6.94809178D0
	rhoarr( 88)=        6.00983271D0
	rhoarr( 89)=        5.21261637D0
	rhoarr( 90)=        4.53869726D0
	rhoarr( 91)=        3.97088445D0
	rhoarr( 92)=        3.49303013D0
	rhoarr( 93)=        3.09036680D0
	rhoarr( 94)=        2.74971462D0
	rhoarr( 95)=        2.45958119D0
	rhoarr( 96)=        2.21017380D0
	rhoarr( 97)=        1.99334201D0
	rhoarr( 98)=        1.80246628D0
	rhoarr( 99)=        1.63230713D0
	rhoarr(100)=        1.47882867D0
	rhoarr(101)=        1.33900972D0
	rhoarr(102)=        1.21065467D0
	rhoarr(103)=        1.09221454D0
	rhoarr(104)=        0.98262587D0
	rhoarr(105)=        0.88117252D0
	rhoarr(106)=        0.78737214D0
	rhoarr(107)=        0.70088692D0
	rhoarr(108)=        0.62145638D0
	rhoarr(109)=        0.54884909D0
	rhoarr(110)=        0.48283017D0
	rhoarr(111)=        0.42314137D0
	rhoarr(112)=        0.36949103D0
	rhoarr(113)=        0.32155164D0
	rhoarr(114)=        0.27896290D0
	rhoarr(115)=        0.24133854D0
	rhoarr(116)=        0.20827535D0
	rhoarr(117)=        0.17936296D0
	rhoarr(118)=        0.15419345D0
	rhoarr(119)=        0.13236976D0
	rhoarr(120)=        0.11351266D0
	rhoarr(121)=        0.09726589D0
	rhoarr(122)=        0.08329978D0
	rhoarr(123)=        0.07131328D0
	rhoarr(124)=        0.06103509D0
	rhoarr(125)=        0.05222366D0
	rhoarr(126)=        0.04466662D0
	rhoarr(127)=        0.03817954D0
	rhoarr(128)=        0.03260411D0
	rhoarr(129)=        0.02780591D0
	rhoarr(130)=        0.02367177D0
	rhoarr(131)=        0.02010688D0
	rhoarr(132)=        0.01703195D0
	rhoarr(133)=        0.01438044D0
	rhoarr(134)=        0.01209613D0
	rhoarr(135)=        0.01013117D0
	rhoarr(136)=        0.00844443D0
	rhoarr(137)=        0.00700041D0
	rhoarr(138)=        0.00576826D0
	rhoarr(139)=        0.00472111D0
	rhoarr(140)=        0.00383548D0
	rhoarr(141)=        0.00309072D0
	rhoarr(142)=        0.00246856D0
	rhoarr(143)=        0.00195273D0
	rhoarr(144)=        0.00152865D0
	rhoarr(145)=        0.00118319D0
	rhoarr(146)=        0.00090460D0
	rhoarr(147)=        0.00068241D0
	rhoarr(148)=        0.00050732D0
	rhoarr(149)=        0.00037119D0
	rhoarr(150)=        0.00026689D0
	rhoarr(151)=        0.00018830D0
	rhoarr(152)=        0.00013013D0
	rhoarr(153)=        0.00008793D0
	rhoarr(154)=        0.00005798D0
	rhoarr(155)=        0.00003722D0
	rhoarr(156)=        0.00002321D0
	rhoarr(157)=        0.00001402D0
	rhoarr(158)=        0.00000818D0
	rhoarr(159)=        0.00000459D0
	rhoarr(160)=        0.00000247D0
	rhoarr(161)=        0.00000127D0
	rhoarr(162)=        0.00000062D0
	rhoarr(163)=        0.00000028D0
	rhoarr(164)=        0.00000012D0
	rhoarr(165)=        0.00000005D0
	rhoarr(166)=        0.00000002D0

else if (iele==77) then  !Ir, 4f14 5d7 6s2, 0 4, HF/UGBS int=dkh2
	npt=  165
	rhoarr(  1)=  4804166.48377915D0
	rhoarr(  2)=  2949544.02569181D0
	rhoarr(  3)=  1847286.82636518D0
	rhoarr(  4)=  1256950.52565906D0
	rhoarr(  5)=   895980.25860483D0
	rhoarr(  6)=   655206.51612961D0
	rhoarr(  7)=   485996.49224376D0
	rhoarr(  8)=   362476.48853390D0
	rhoarr(  9)=   270587.41590742D0
	rhoarr( 10)=   201539.30297458D0
	rhoarr( 11)=   149477.48938088D0
	rhoarr( 12)=   110292.71490147D0
	rhoarr( 13)=    80989.20329641D0
	rhoarr( 14)=    59322.76902727D0
	rhoarr( 15)=    43533.10595748D0
	rhoarr( 16)=    32200.90994676D0
	rhoarr( 17)=    24192.02816677D0
	rhoarr( 18)=    18617.37221083D0
	rhoarr( 19)=    14786.79627858D0
	rhoarr( 20)=    12168.97197220D0
	rhoarr( 21)=    10361.66877658D0
	rhoarr( 22)=     9069.90362269D0
	rhoarr( 23)=     8087.41266096D0
	rhoarr( 24)=     7278.51754754D0
	rhoarr( 25)=     6560.70742738D0
	rhoarr( 26)=     5889.36011514D0
	rhoarr( 27)=     5245.30384664D0
	rhoarr( 28)=     4625.18934502D0
	rhoarr( 29)=     4034.35394491D0
	rhoarr( 30)=     3481.76621618D0
	rhoarr( 31)=     2976.62310364D0
	rhoarr( 32)=     2526.22828744D0
	rhoarr( 33)=     2134.86980915D0
	rhoarr( 34)=     1803.47535193D0
	rhoarr( 35)=     1529.83729430D0
	rhoarr( 36)=     1309.19870417D0
	rhoarr( 37)=     1135.01124162D0
	rhoarr( 38)=      999.72073107D0
	rhoarr( 39)=      895.48643116D0
	rhoarr( 40)=      814.77903940D0
	rhoarr( 41)=      750.82872338D0
	rhoarr( 42)=      697.91459432D0
	rhoarr( 43)=      651.50485528D0
	rhoarr( 44)=      608.27078500D0
	rhoarr( 45)=      566.00502018D0
	rhoarr( 46)=      523.47519936D0
	rhoarr( 47)=      480.24048115D0
	rhoarr( 48)=      436.45361870D0
	rhoarr( 49)=      392.66666644D0
	rhoarr( 50)=      349.65414741D0
	rhoarr( 51)=      308.26330959D0
	rhoarr( 52)=      269.29690187D0
	rhoarr( 53)=      233.43001168D0
	rhoarr( 54)=      201.15930935D0
	rhoarr( 55)=      172.78076136D0
	rhoarr( 56)=      148.39052245D0
	rhoarr( 57)=      127.90317660D0
	rhoarr( 58)=      111.08159425D0
	rhoarr( 59)=       97.57322105D0
	rhoarr( 60)=       86.94842916D0
	rhoarr( 61)=       78.73748710D0
	rhoarr( 62)=       72.46362202D0
	rhoarr( 63)=       67.67049854D0
	rhoarr( 64)=       63.94320196D0
	rhoarr( 65)=       60.92248806D0
	rhoarr( 66)=       58.31263478D0
	rhoarr( 67)=       55.88367442D0
	rhoarr( 68)=       53.46907151D0
	rhoarr( 69)=       50.96003115D0
	rhoarr( 70)=       48.29759627D0
	rhoarr( 71)=       45.46356209D0
	rhoarr( 72)=       42.47105393D0
	rhoarr( 73)=       39.35542196D0
	rhoarr( 74)=       36.16592914D0
	rhoarr( 75)=       32.95855438D0
	rhoarr( 76)=       29.79009895D0
	rhoarr( 77)=       26.71366708D0
	rhoarr( 78)=       23.77548940D0
	rhoarr( 79)=       21.01297538D0
	rhoarr( 80)=       18.45382214D0
	rhoarr( 81)=       16.11597552D0
	rhoarr( 82)=       14.00823210D0
	rhoarr( 83)=       12.13128302D0
	rhoarr( 84)=       10.47902406D0
	rhoarr( 85)=        9.03998500D0
	rhoarr( 86)=        7.79876086D0
	rhoarr( 87)=        6.73735628D0
	rhoarr( 88)=        5.83638105D0
	rhoarr( 89)=        5.07605957D0
	rhoarr( 90)=        4.43703927D0
	rhoarr( 91)=        3.90100086D0
	rhoarr( 92)=        3.45108677D0
	rhoarr( 93)=        3.07217166D0
	rhoarr( 94)=        2.75100199D0
	rhoarr( 95)=        2.47623025D0
	rhoarr( 96)=        2.23836687D0
	rhoarr( 97)=        2.02966909D0
	rhoarr( 98)=        1.84398375D0
	rhoarr( 99)=        1.67655873D0
	rhoarr(100)=        1.52383713D0
	rhoarr(101)=        1.38324694D0
	rhoarr(102)=        1.25299761D0
	rhoarr(103)=        1.13189280D0
	rhoarr(104)=        1.01916604D0
	rhoarr(105)=        0.91434266D0
	rhoarr(106)=        0.81712916D0
	rhoarr(107)=        0.72732829D0
	rhoarr(108)=        0.64477727D0
	rhoarr(109)=        0.56930552D0
	rhoarr(110)=        0.50070839D0
	rhoarr(111)=        0.43873359D0
	rhoarr(112)=        0.38307743D0
	rhoarr(113)=        0.33338823D0
	rhoarr(114)=        0.28927470D0
	rhoarr(115)=        0.25031731D0
	rhoarr(116)=        0.21608078D0
	rhoarr(117)=        0.18612639D0
	rhoarr(118)=        0.16002296D0
	rhoarr(119)=        0.13735580D0
	rhoarr(120)=        0.11773340D0
	rhoarr(121)=        0.10079179D0
	rhoarr(122)=        0.08619705D0
	rhoarr(123)=        0.07364618D0
	rhoarr(124)=        0.06286705D0
	rhoarr(125)=        0.05361750D0
	rhoarr(126)=        0.04568403D0
	rhoarr(127)=        0.03888013D0
	rhoarr(128)=        0.03304429D0
	rhoarr(129)=        0.02803776D0
	rhoarr(130)=        0.02374207D0
	rhoarr(131)=        0.02005644D0
	rhoarr(132)=        0.01689526D0
	rhoarr(133)=        0.01418564D0
	rhoarr(134)=        0.01186537D0
	rhoarr(135)=        0.00988115D0
	rhoarr(136)=        0.00818727D0
	rhoarr(137)=        0.00674447D0
	rhoarr(138)=        0.00551914D0
	rhoarr(139)=        0.00448249D0
	rhoarr(140)=        0.00360982D0
	rhoarr(141)=        0.00287983D0
	rhoarr(142)=        0.00227392D0
	rhoarr(143)=        0.00177562D0
	rhoarr(144)=        0.00137012D0
	rhoarr(145)=        0.00104400D0
	rhoarr(146)=        0.00078503D0
	rhoarr(147)=        0.00058212D0
	rhoarr(148)=        0.00042536D0
	rhoarr(149)=        0.00030602D0
	rhoarr(150)=        0.00021651D0
	rhoarr(151)=        0.00015043D0
	rhoarr(152)=        0.00010243D0
	rhoarr(153)=        0.00006817D0
	rhoarr(154)=        0.00004421D0
	rhoarr(155)=        0.00002781D0
	rhoarr(156)=        0.00001690D0
	rhoarr(157)=        0.00000986D0
	rhoarr(158)=        0.00000549D0
	rhoarr(159)=        0.00000290D0
	rhoarr(160)=        0.00000144D0
	rhoarr(161)=        0.00000066D0
	rhoarr(162)=        0.00000028D0
	rhoarr(163)=        0.00000011D0
	rhoarr(164)=        0.00000004D0
	rhoarr(165)=        0.00000001D0

else if (iele==78) then  !Pt, 4f14 5d9 6s1, 0 3, HF/UGBS int=dkh2
	npt=  164
	rhoarr(  1)=  5223578.52031624D0
	rhoarr(  2)=  3184040.48024866D0
	rhoarr(  3)=  1978480.46301087D0
	rhoarr(  4)=  1337388.04276456D0
	rhoarr(  5)=   947743.16423424D0
	rhoarr(  6)=   689136.13731622D0
	rhoarr(  7)=   508399.20785362D0
	rhoarr(  8)=   377314.23441179D0
	rhoarr(  9)=   280333.51995525D0
	rhoarr( 10)=   207787.40016209D0
	rhoarr( 11)=   153358.88601933D0
	rhoarr( 12)=   112636.76623112D0
	rhoarr( 13)=    82375.83260298D0
	rhoarr( 14)=    60131.39814779D0
	rhoarr( 15)=    44008.36755153D0
	rhoarr( 16)=    32504.78877166D0
	rhoarr( 17)=    24428.96698963D0
	rhoarr( 18)=    18845.53593166D0
	rhoarr( 19)=    15029.24252222D0
	rhoarr( 20)=    12426.98109820D0
	rhoarr( 21)=    10626.41050379D0
	rhoarr( 22)=     9329.85968704D0
	rhoarr( 23)=     8331.91489798D0
	rhoarr( 24)=     7499.06170687D0
	rhoarr( 25)=     6751.40988551D0
	rhoarr( 26)=     6047.14606331D0
	rhoarr( 27)=     5369.88718702D0
	rhoarr( 28)=     4718.76667275D0
	rhoarr( 29)=     4101.01817166D0
	rhoarr( 30)=     3526.75541903D0
	rhoarr( 31)=     3005.56135591D0
	rhoarr( 32)=     2544.48591753D0
	rhoarr( 33)=     2147.10998004D0
	rhoarr( 34)=     1813.39735540D0
	rhoarr( 35)=     1540.09020430D0
	rhoarr( 36)=     1321.42278454D0
	rhoarr( 37)=     1149.96313708D0
	rhoarr( 38)=     1017.44513529D0
	rhoarr( 39)=      915.50593742D0
	rhoarr( 40)=      836.28188281D0
	rhoarr( 41)=      772.84015030D0
	rhoarr( 42)=      719.44213358D0
	rhoarr( 43)=      671.65158910D0
	rhoarr( 44)=      626.31421444D0
	rhoarr( 45)=      581.44225783D0
	rhoarr( 46)=      536.03780550D0
	rhoarr( 47)=      489.88413121D0
	rhoarr( 48)=      443.32888732D0
	rhoarr( 49)=      397.07755539D0
	rhoarr( 50)=      352.01066158D0
	rhoarr( 51)=      309.03354989D0
	rhoarr( 52)=      268.96298920D0
	rhoarr( 53)=      232.45087224D0
	rhoarr( 54)=      199.94209303D0
	rhoarr( 55)=      171.66153800D0
	rhoarr( 56)=      147.62397092D0
	rhoarr( 57)=      127.66028390D0
	rhoarr( 58)=      111.45392742D0
	rhoarr( 59)=       98.58210923D0
	rhoarr( 60)=       88.55736262D0
	rhoarr( 61)=       80.86615676D0
	rhoarr( 62)=       75.00223776D0
	rhoarr( 63)=       70.49329370D0
	rhoarr( 64)=       66.92032235D0
	rhoarr( 65)=       63.92975232D0
	rhoarr( 66)=       61.23891910D0
	rhoarr( 67)=       58.63590460D0
	rhoarr( 68)=       55.97498666D0
	rhoarr( 69)=       53.16901094D0
	rhoarr( 70)=       50.17991777D0
	rhoarr( 71)=       47.00847979D0
	rhoarr( 72)=       43.68408721D0
	rhoarr( 73)=       40.25519937D0
	rhoarr( 74)=       36.78088807D0
	rhoarr( 75)=       33.32373578D0
	rhoarr( 76)=       29.94421562D0
	rhoarr( 77)=       26.69656504D0
	rhoarr( 78)=       23.62606859D0
	rhoarr( 79)=       20.76759052D0
	rhoarr( 80)=       18.14514942D0
	rhoarr( 81)=       15.77230492D0
	rhoarr( 82)=       13.65312936D0
	rhoarr( 83)=       11.78355687D0
	rhoarr( 84)=       10.15293215D0
	rhoarr( 85)=        8.74561413D0
	rhoarr( 86)=        7.54252234D0
	rhoarr( 87)=        6.52254428D0
	rhoarr( 88)=        5.66375038D0
	rhoarr( 89)=        4.94438853D0
	rhoarr( 90)=        4.34365225D0
	rhoarr( 91)=        3.84223394D0
	rhoarr( 92)=        3.42268696D0
	rhoarr( 93)=        3.06962636D0
	rhoarr( 94)=        2.76979956D0
	rhoarr( 95)=        2.51205589D0
	rhoarr( 96)=        2.28723988D0
	rhoarr( 97)=        2.08802909D0
	rhoarr( 98)=        1.90873402D0
	rhoarr( 99)=        1.74507549D0
	rhoarr(100)=        1.59395322D0
	rhoarr(101)=        1.45321802D0
	rhoarr(102)=        1.32145790D0
	rhoarr(103)=        1.19780627D0
	rhoarr(104)=        1.08177723D0
	rhoarr(105)=        0.97313014D0
	rhoarr(106)=        0.87176315D0
	rhoarr(107)=        0.77763318D0
	rhoarr(108)=        0.69069914D0
	rhoarr(109)=        0.61088437D0
	rhoarr(110)=        0.53805485D0
	rhoarr(111)=        0.47200967D0
	rhoarr(112)=        0.41248111D0
	rhoarr(113)=        0.35914146D0
	rhoarr(114)=        0.31161447D0
	rhoarr(115)=        0.26948924D0
	rhoarr(116)=        0.23233465D0
	rhoarr(117)=        0.19971305D0
	rhoarr(118)=        0.17119204D0
	rhoarr(119)=        0.14635372D0
	rhoarr(120)=        0.12480141D0
	rhoarr(121)=        0.10616386D0
	rhoarr(122)=        0.09009762D0
	rhoarr(123)=        0.07628790D0
	rhoarr(124)=        0.06444866D0
	rhoarr(125)=        0.05432208D0
	rhoarr(126)=        0.04567780D0
	rhoarr(127)=        0.03831187D0
	rhoarr(128)=        0.03204537D0
	rhoarr(129)=        0.02672276D0
	rhoarr(130)=        0.02220982D0
	rhoarr(131)=        0.01839122D0
	rhoarr(132)=        0.01516811D0
	rhoarr(133)=        0.01245555D0
	rhoarr(134)=        0.01018031D0
	rhoarr(135)=        0.00827895D0
	rhoarr(136)=        0.00669640D0
	rhoarr(137)=        0.00538476D0
	rhoarr(138)=        0.00430257D0
	rhoarr(139)=        0.00341405D0
	rhoarr(140)=        0.00268850D0
	rhoarr(141)=        0.00209966D0
	rhoarr(142)=        0.00162509D0
	rhoarr(143)=        0.00124560D0
	rhoarr(144)=        0.00094477D0
	rhoarr(145)=        0.00070852D0
	rhoarr(146)=        0.00052485D0
	rhoarr(147)=        0.00038360D0
	rhoarr(148)=        0.00027623D0
	rhoarr(149)=        0.00019568D0
	rhoarr(150)=        0.00013612D0
	rhoarr(151)=        0.00009280D0
	rhoarr(152)=        0.00006186D0
	rhoarr(153)=        0.00004023D0
	rhoarr(154)=        0.00002545D0
	rhoarr(155)=        0.00001560D0
	rhoarr(156)=        0.00000924D0
	rhoarr(157)=        0.00000525D0
	rhoarr(158)=        0.00000286D0
	rhoarr(159)=        0.00000147D0
	rhoarr(160)=        0.00000071D0
	rhoarr(161)=        0.00000032D0
	rhoarr(162)=        0.00000013D0
	rhoarr(163)=        0.00000005D0
	rhoarr(164)=        0.00000002D0

else if (iele==79) then  !Au, 4f14 5d10 6s1, 0 2, HF/UGBS int=dkh2
	npt=  164
	rhoarr(  1)=  5679207.79329268D0
	rhoarr(  2)=  3436683.71122478D0
	rhoarr(  3)=  2118325.14106801D0
	rhoarr(  4)=  1422147.41673207D0
	rhoarr(  5)=  1001793.07288339D0
	rhoarr(  6)=   724522.53388670D0
	rhoarr(  7)=   531710.41481105D0
	rhoarr(  8)=   392534.08414804D0
	rhoarr(  9)=   290211.53910822D0
	rhoarr( 10)=   214102.40897005D0
	rhoarr( 11)=   157250.44076711D0
	rhoarr( 12)=   114949.28655245D0
	rhoarr( 13)=    83726.66192957D0
	rhoarr( 14)=    60916.57927180D0
	rhoarr( 15)=    44470.65316733D0
	rhoarr( 16)=    32802.86005172D0
	rhoarr( 17)=    24667.09968166D0
	rhoarr( 18)=    19081.72112817D0
	rhoarr( 19)=    15284.36595640D0
	rhoarr( 20)=    12698.97411568D0
	rhoarr( 21)=    10903.55871133D0
	rhoarr( 22)=     9599.10817596D0
	rhoarr( 23)=     8582.33054768D0
	rhoarr( 24)=     7722.61515638D0
	rhoarr( 25)=     6942.92344523D0
	rhoarr( 26)=     6204.19750999D0
	rhoarr( 27)=     5492.71243442D0
	rhoarr( 28)=     4809.98305417D0
	rhoarr( 29)=     4165.08465502D0
	rhoarr( 30)=     3569.24155526D0
	rhoarr( 31)=     3032.37741151D0
	rhoarr( 32)=     2561.21706482D0
	rhoarr( 33)=     2158.53950841D0
	rhoarr( 34)=     1823.24098812D0
	rhoarr( 35)=     1550.91844282D0
	rhoarr( 36)=     1334.72544839D0
	rhoarr( 37)=     1166.30559026D0
	rhoarr( 38)=     1036.67191444D0
	rhoarr( 39)=      936.95793067D0
	rhoarr( 40)=      859.00343868D0
	rhoarr( 41)=      795.76075827D0
	rhoarr( 42)=      741.52362904D0
	rhoarr( 43)=      691.99677604D0
	rhoarr( 44)=      644.23676763D0
	rhoarr( 45)=      596.50086373D0
	rhoarr( 46)=      548.03971783D0
	rhoarr( 47)=      498.86467154D0
	rhoarr( 48)=      449.51398638D0
	rhoarr( 49)=      400.83631074D0
	rhoarr( 50)=      353.80421257D0
	rhoarr( 51)=      309.36550275D0
	rhoarr( 52)=      268.33534308D0
	rhoarr( 53)=      231.32806780D0
	rhoarr( 54)=      198.72455630D0
	rhoarr( 55)=      170.66900614D0
	rhoarr( 56)=      147.08801150D0
	rhoarr( 57)=      127.72478096D0
	rhoarr( 58)=      112.18191057D0
	rhoarr( 59)=       99.96713162D0
	rhoarr( 60)=       90.53765342D0
	rhoarr( 61)=       83.33993523D0
	rhoarr( 62)=       77.84282877D0
	rhoarr( 63)=       73.56298517D0
	rhoarr( 64)=       70.08221998D0
	rhoarr( 65)=       67.05719118D0
	rhoarr( 66)=       64.22226728D0
	rhoarr( 67)=       61.38682443D0
	rhoarr( 68)=       58.42839544D0
	rhoarr( 69)=       55.28310007D0
	rhoarr( 70)=       51.93464971D0
	rhoarr( 71)=       48.40299541D0
	rhoarr( 72)=       44.73343252D0
	rhoarr( 73)=       40.98673314D0
	rhoarr( 74)=       37.23067061D0
	rhoarr( 75)=       33.53313138D0
	rhoarr( 76)=       29.95687448D0
	rhoarr( 77)=       26.55588706D0
	rhoarr( 78)=       23.37319637D0
	rhoarr( 79)=       20.43993381D0
	rhoarr( 80)=       17.77540874D0
	rhoarr( 81)=       15.38793914D0
	rhoarr( 82)=       13.27619851D0
	rhoarr( 83)=       11.43086598D0
	rhoarr( 84)=        9.83640230D0
	rhoarr( 85)=        8.47281119D0
	rhoarr( 86)=        7.31728109D0
	rhoarr( 87)=        6.34563421D0
	rhoarr( 88)=        5.53353938D0
	rhoarr( 89)=        4.85747068D0
	rhoarr( 90)=        4.29541596D0
	rhoarr( 91)=        3.82735565D0
	rhoarr( 92)=        3.43554330D0
	rhoarr( 93)=        3.10462373D0
	rhoarr( 94)=        2.82162464D0
	rhoarr( 95)=        2.57585336D0
	rhoarr( 96)=        2.35872586D0
	rhoarr( 97)=        2.16354974D0
	rhoarr( 98)=        1.98527933D0
	rhoarr( 99)=        1.82025844D0
	rhoarr(100)=        1.66596390D0
	rhoarr(101)=        1.52076169D0
	rhoarr(102)=        1.38368455D0
	rhoarr(103)=        1.25423775D0
	rhoarr(104)=        1.13223636D0
	rhoarr(105)=        1.01767488D0
	rhoarr(106)=        0.91062736D0
	rhoarr(107)=        0.81117481D0
	rhoarr(108)=        0.71935591D0
	rhoarr(109)=        0.63513690D0
	rhoarr(110)=        0.55839673D0
	rhoarr(111)=        0.48892434D0
	rhoarr(112)=        0.42642488D0
	rhoarr(113)=        0.37053231D0
	rhoarr(114)=        0.32082595D0
	rhoarr(115)=        0.27684852D0
	rhoarr(116)=        0.23812406D0
	rhoarr(117)=        0.20417393D0
	rhoarr(118)=        0.17453004D0
	rhoarr(119)=        0.14874466D0
	rhoarr(120)=        0.12639702D0
	rhoarr(121)=        0.10709682D0
	rhoarr(122)=        0.09048561D0
	rhoarr(123)=        0.07623650D0
	rhoarr(124)=        0.06405321D0
	rhoarr(125)=        0.05366855D0
	rhoarr(126)=        0.04484305D0
	rhoarr(127)=        0.03736348D0
	rhoarr(128)=        0.03104133D0
	rhoarr(129)=        0.02571121D0
	rhoarr(130)=        0.02122898D0
	rhoarr(131)=        0.01746968D0
	rhoarr(132)=        0.01432534D0
	rhoarr(133)=        0.01170282D0
	rhoarr(134)=        0.00952182D0
	rhoarr(135)=        0.00771319D0
	rhoarr(136)=        0.00621758D0
	rhoarr(137)=        0.00498429D0
	rhoarr(138)=        0.00397034D0
	rhoarr(139)=        0.00313962D0
	rhoarr(140)=        0.00246198D0
	rhoarr(141)=        0.00191233D0
	rhoarr(142)=        0.00146973D0
	rhoarr(143)=        0.00111654D0
	rhoarr(144)=        0.00083775D0
	rhoarr(145)=        0.00062039D0
	rhoarr(146)=        0.00045323D0
	rhoarr(147)=        0.00032654D0
	rhoarr(148)=        0.00023195D0
	rhoarr(149)=        0.00016240D0
	rhoarr(150)=        0.00011203D0
	rhoarr(151)=        0.00007609D0
	rhoarr(152)=        0.00005080D0
	rhoarr(153)=        0.00003326D0
	rhoarr(154)=        0.00002128D0
	rhoarr(155)=        0.00001324D0
	rhoarr(156)=        0.00000797D0
	rhoarr(157)=        0.00000461D0
	rhoarr(158)=        0.00000255D0
	rhoarr(159)=        0.00000133D0
	rhoarr(160)=        0.00000066D0
	rhoarr(161)=        0.00000030D0
	rhoarr(162)=        0.00000013D0
	rhoarr(163)=        0.00000005D0
	rhoarr(164)=        0.00000002D0

else if (iele==80) then  !Hg, 4f14 5d10 6s2, 0 1, HF/UGBS int=dkh2
	npt=  164
	rhoarr(  1)=  6164674.01936373D0
	rhoarr(  2)=  3708252.14188181D0
	rhoarr(  3)=  2267649.48555257D0
	rhoarr(  4)=  1512139.02499665D0
	rhoarr(  5)=  1058744.07001458D0
	rhoarr(  6)=   761311.39681430D0
	rhoarr(  7)=   555743.27854526D0
	rhoarr(  8)=   408257.00322227D0
	rhoarr(  9)=   300305.90826000D0
	rhoarr( 10)=   220417.58314646D0
	rhoarr( 11)=   161134.95313572D0
	rhoarr( 12)=   117276.90451231D0
	rhoarr( 13)=    85059.82443046D0
	rhoarr( 14)=    61659.40156678D0
	rhoarr( 15)=    44908.19629512D0
	rhoarr( 16)=    33107.56187928D0
	rhoarr( 17)=    24926.77495730D0
	rhoarr( 18)=    19336.14728349D0
	rhoarr( 19)=    15549.63429750D0
	rhoarr( 20)=    12977.77479191D0
	rhoarr( 21)=    11189.26444992D0
	rhoarr( 22)=     9879.46382637D0
	rhoarr( 23)=     8843.78621973D0
	rhoarr( 24)=     7954.03127995D0
	rhoarr( 25)=     7137.58395066D0
	rhoarr( 26)=     6360.08384734D0
	rhoarr( 27)=     5611.65569573D0
	rhoarr( 28)=     4896.40247583D0
	rhoarr( 29)=     4224.78866502D0
	rhoarr( 30)=     3608.49117994D0
	rhoarr( 31)=     3057.22904040D0
	rhoarr( 32)=     2577.08821964D0
	rhoarr( 33)=     2169.93847555D0
	rhoarr( 34)=     1833.62345416D0
	rhoarr( 35)=     1562.65232246D0
	rhoarr( 36)=     1349.14994136D0
	rhoarr( 37)=     1183.86628310D0
	rhoarr( 38)=     1057.10782530D0
	rhoarr( 39)=      959.51349919D0
	rhoarr( 40)=      882.63980770D0
	rhoarr( 41)=      819.34547428D0
	rhoarr( 42)=      763.98461374D0
	rhoarr( 43)=      712.43355324D0
	rhoarr( 44)=      661.98820888D0
	rhoarr( 45)=      611.17339973D0
	rhoarr( 46)=      559.50286732D0
	rhoarr( 47)=      507.22208573D0
	rhoarr( 48)=      455.05837535D0
	rhoarr( 49)=      403.99598298D0
	rhoarr( 50)=      355.08782518D0
	rhoarr( 51)=      309.31022501D0
	rhoarr( 52)=      267.46216298D0
	rhoarr( 53)=      230.10655329D0
	rhoarr( 54)=      197.54810779D0
	rhoarr( 55)=      169.84055782D0
	rhoarr( 56)=      146.81528817D0
	rhoarr( 57)=      128.12361281D0
	rhoarr( 58)=      113.28575408D0
	rhoarr( 59)=      101.74082254D0
	rhoarr( 60)=       92.89349000D0
	rhoarr( 61)=       86.15440576D0
	rhoarr( 62)=       80.97260247D0
	rhoarr( 63)=       76.85913253D0
	rhoarr( 64)=       73.40198107D0
	rhoarr( 65)=       70.27294008D0
	rhoarr( 66)=       67.22760866D0
	rhoarr( 67)=       64.09998998D0
	rhoarr( 68)=       60.79327493D0
	rhoarr( 69)=       57.26834402D0
	rhoarr( 70)=       53.53132324D0
	rhoarr( 71)=       49.62125684D0
	rhoarr( 72)=       45.59866984D0
	rhoarr( 73)=       41.53552902D0
	rhoarr( 74)=       37.50689311D0
	rhoarr( 75)=       33.58437171D0
	rhoarr( 76)=       29.83137931D0
	rhoarr( 77)=       26.30006706D0
	rhoarr( 78)=       23.02973608D0
	rhoarr( 79)=       20.04648348D0
	rhoarr( 80)=       17.36380676D0
	rhoarr( 81)=       14.98389339D0
	rhoarr( 82)=       12.89934454D0
	rhoarr( 83)=       11.09511790D0
	rhoarr( 84)=        9.55051513D0
	rhoarr( 85)=        8.24108038D0
	rhoarr( 86)=        7.14031370D0
	rhoarr( 87)=        6.22113675D0
	rhoarr( 88)=        5.45707793D0
	rhoarr( 89)=        4.82317041D0
	rhoarr( 90)=        4.29657729D0
	rhoarr( 91)=        3.85697418D0
	rhoarr( 92)=        3.48672865D0
	rhoarr( 93)=        3.17091876D0
	rhoarr( 94)=        2.89723124D0
	rhoarr( 95)=        2.65577422D0
	rhoarr( 96)=        2.43883360D0
	rhoarr( 97)=        2.24059586D0
	rhoarr( 98)=        2.05685594D0
	rhoarr( 99)=        1.88472530D0
	rhoarr(100)=        1.72235285D0
	rhoarr(101)=        1.56866889D0
	rhoarr(102)=        1.42315964D0
	rhoarr(103)=        1.28567670D0
	rhoarr(104)=        1.15628316D0
	rhoarr(105)=        1.03513485D0
	rhoarr(106)=        0.92239384D0
	rhoarr(107)=        0.81816936D0
	rhoarr(108)=        0.72248155D0
	rhoarr(109)=        0.63524321D0
	rhoarr(110)=        0.55625571D0
	rhoarr(111)=        0.48521536D0
	rhoarr(112)=        0.42172739D0
	rhoarr(113)=        0.36532485D0
	rhoarr(114)=        0.31548994D0
	rhoarr(115)=        0.27167571D0
	rhoarr(116)=        0.23332615D0
	rhoarr(117)=        0.19989351D0
	rhoarr(118)=        0.17085184D0
	rhoarr(119)=        0.14570646D0
	rhoarr(120)=        0.12399972D0
	rhoarr(121)=        0.10531351D0
	rhoarr(122)=        0.08926929D0
	rhoarr(123)=        0.07552676D0
	rhoarr(124)=        0.06378161D0
	rhoarr(125)=        0.05376317D0
	rhoarr(126)=        0.04523203D0
	rhoarr(127)=        0.03797783D0
	rhoarr(128)=        0.03181712D0
	rhoarr(129)=        0.02659110D0
	rhoarr(130)=        0.02216324D0
	rhoarr(131)=        0.01841672D0
	rhoarr(132)=        0.01525180D0
	rhoarr(133)=        0.01258334D0
	rhoarr(134)=        0.01033846D0
	rhoarr(135)=        0.00845469D0
	rhoarr(136)=        0.00687833D0
	rhoarr(137)=        0.00556333D0
	rhoarr(138)=        0.00447025D0
	rhoarr(139)=        0.00356545D0
	rhoarr(140)=        0.00282026D0
	rhoarr(141)=        0.00221027D0
	rhoarr(142)=        0.00171462D0
	rhoarr(143)=        0.00131535D0
	rhoarr(144)=        0.00099688D0
	rhoarr(145)=        0.00074568D0
	rhoarr(146)=        0.00054995D0
	rhoarr(147)=        0.00039946D0
	rhoarr(148)=        0.00028541D0
	rhoarr(149)=        0.00020031D0
	rhoarr(150)=        0.00013789D0
	rhoarr(151)=        0.00009293D0
	rhoarr(152)=        0.00006119D0
	rhoarr(153)=        0.00003926D0
	rhoarr(154)=        0.00002448D0
	rhoarr(155)=        0.00001478D0
	rhoarr(156)=        0.00000860D0
	rhoarr(157)=        0.00000481D0
	rhoarr(158)=        0.00000256D0
	rhoarr(159)=        0.00000130D0
	rhoarr(160)=        0.00000062D0
	rhoarr(161)=        0.00000028D0
	rhoarr(162)=        0.00000011D0
	rhoarr(163)=        0.00000004D0
	rhoarr(164)=        0.00000001D0

else if (iele==81) then  !Tl, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=  168
	rhoarr(  1)=  8447875.32294390D0
	rhoarr(  2)=  4103055.07053428D0
	rhoarr(  3)=  2462216.19954494D0
	rhoarr(  4)=  1614231.35272597D0
	rhoarr(  5)=  1122182.78744567D0
	rhoarr(  6)=   801851.93594502D0
	rhoarr(  7)=   581392.61341609D0
	rhoarr(  8)=   424883.09928454D0
	rhoarr(  9)=   310815.06295046D0
	rhoarr( 10)=   226969.72612090D0
	rhoarr( 11)=   165071.80688689D0
	rhoarr( 12)=   119552.30674586D0
	rhoarr( 13)=    86359.98199832D0
	rhoarr( 14)=    62385.34564373D0
	rhoarr( 15)=    45326.95759845D0
	rhoarr( 16)=    33395.86644480D0
	rhoarr( 17)=    25176.89010721D0
	rhoarr( 18)=    19590.16963114D0
	rhoarr( 19)=    15824.37281155D0
	rhoarr( 20)=    13271.69698451D0
	rhoarr( 21)=    11488.85265415D0
	rhoarr( 22)=    10168.05743823D0
	rhoarr( 23)=     9107.65814579D0
	rhoarr( 24)=     8184.40096169D0
	rhoarr( 25)=     7330.25251467D0
	rhoarr( 26)=     6514.29140766D0
	rhoarr( 27)=     5729.13170844D0
	rhoarr( 28)=     4980.90822710D0
	rhoarr( 29)=     4281.81184344D0
	rhoarr( 30)=     3644.63626209D0
	rhoarr( 31)=     3079.26704166D0
	rhoarr( 32)=     2591.03348221D0
	rhoarr( 33)=     2180.51181043D0
	rhoarr( 34)=     1844.15874245D0
	rhoarr( 35)=     1575.25595082D0
	rhoarr( 36)=     1364.90452991D0
	rhoarr( 37)=     1202.99856211D0
	rhoarr( 38)=     1079.15044200D0
	rhoarr( 39)=      983.50543004D0
	rhoarr( 40)=      907.36305035D0
	rhoarr( 41)=      843.55391899D0
	rhoarr( 42)=      786.57852216D0
	rhoarr( 43)=      732.56015121D0
	rhoarr( 44)=      679.07835056D0
	rhoarr( 45)=      624.93792071D0
	rhoarr( 46)=      569.90909381D0
	rhoarr( 47)=      514.46038461D0
	rhoarr( 48)=      459.50023307D0
	rhoarr( 49)=      406.14299342D0
	rhoarr( 50)=      355.51374296D0
	rhoarr( 51)=      308.60208298D0
	rhoarr( 52)=      266.16821241D0
	rhoarr( 53)=      228.69744855D0
	rhoarr( 54)=      196.39425902D0
	rhoarr( 55)=      169.20472199D0
	rhoarr( 56)=      146.85680544D0
	rhoarr( 57)=      128.90985734D0
	rhoarr( 58)=      114.80705584D0
	rhoarr( 59)=      103.92650660D0
	rhoarr( 60)=       95.62794810D0
	rhoarr( 61)=       89.29279894D0
	rhoarr( 62)=       84.35587700D0
	rhoarr( 63)=       80.32779503D0
	rhoarr( 64)=       76.80786681D0
	rhoarr( 65)=       73.48823905D0
	rhoarr( 66)=       70.15070977D0
	rhoarr( 67)=       66.65814382D0
	rhoarr( 68)=       62.94248932D0
	rhoarr( 69)=       58.99118878D0
	rhoarr( 70)=       54.83338871D0
	rhoarr( 71)=       50.52691937D0
	rhoarr( 72)=       46.14664391D0
	rhoarr( 73)=       41.77450812D0
	rhoarr( 74)=       37.49145183D0
	rhoarr( 75)=       33.37123575D0
	rhoarr( 76)=       29.47615328D0
	rhoarr( 77)=       25.85451268D0
	rhoarr( 78)=       22.53968754D0
	rhoarr( 79)=       19.55045690D0
	rhoarr( 80)=       16.89230806D0
	rhoarr( 81)=       14.55936598D0
	rhoarr( 82)=       12.53664257D0
	rhoarr( 83)=       10.80235606D0
	rhoarr( 84)=        9.33013907D0
	rhoarr( 85)=        8.09101879D0
	rhoarr( 86)=        7.05510653D0
	rhoarr( 87)=        6.19297209D0
	rhoarr( 88)=        5.47670430D0
	rhoarr( 89)=        4.88067482D0
	rhoarr( 90)=        4.38203264D0
	rhoarr( 91)=        3.96096271D0
	rhoarr( 92)=        3.60074634D0
	rhoarr( 93)=        3.28766271D0
	rhoarr( 94)=        3.01077145D0
	rhoarr( 95)=        2.76161433D0
	rhoarr( 96)=        2.53387076D0
	rhoarr( 97)=        2.32299704D0
	rhoarr( 98)=        2.12587359D0
	rhoarr( 99)=        1.94047787D0
	rhoarr(100)=        1.76559533D0
	rhoarr(101)=        1.60057485D0
	rhoarr(102)=        1.44513075D0
	rhoarr(103)=        1.29918964D0
	rhoarr(104)=        1.16277770D0
	rhoarr(105)=        1.03594196D0
	rhoarr(106)=        0.91869873D0
	rhoarr(107)=        0.81100229D0
	rhoarr(108)=        0.71272779D0
	rhoarr(109)=        0.62366381D0
	rhoarr(110)=        0.54351120D0
	rhoarr(111)=        0.47188636D0
	rhoarr(112)=        0.40832815D0
	rhoarr(113)=        0.35230803D0
	rhoarr(114)=        0.30324348D0
	rhoarr(115)=        0.26051441D0
	rhoarr(116)=        0.22348170D0
	rhoarr(117)=        0.19150682D0
	rhoarr(118)=        0.16397082D0
	rhoarr(119)=        0.14029124D0
	rhoarr(120)=        0.11993557D0
	rhoarr(121)=        0.10243014D0
	rhoarr(122)=        0.08736410D0
	rhoarr(123)=        0.07438871D0
	rhoarr(124)=        0.06321247D0
	rhoarr(125)=        0.05359333D0
	rhoarr(126)=        0.04532934D0
	rhoarr(127)=        0.03824923D0
	rhoarr(128)=        0.03220415D0
	rhoarr(129)=        0.02706148D0
	rhoarr(130)=        0.02270091D0
	rhoarr(131)=        0.01901281D0
	rhoarr(132)=        0.01589797D0
	rhoarr(133)=        0.01326819D0
	rhoarr(134)=        0.01104677D0
	rhoarr(135)=        0.00916863D0
	rhoarr(136)=        0.00757975D0
	rhoarr(137)=        0.00623602D0
	rhoarr(138)=        0.00510165D0
	rhoarr(139)=        0.00414746D0
	rhoarr(140)=        0.00334919D0
	rhoarr(141)=        0.00268607D0
	rhoarr(142)=        0.00213967D0
	rhoarr(143)=        0.00169332D0
	rhoarr(144)=        0.00133178D0
	rhoarr(145)=        0.00104122D0
	rhoarr(146)=        0.00080937D0
	rhoarr(147)=        0.00062555D0
	rhoarr(148)=        0.00048070D0
	rhoarr(149)=        0.00036721D0
	rhoarr(150)=        0.00027876D0
	rhoarr(151)=        0.00021012D0
	rhoarr(152)=        0.00015700D0
	rhoarr(153)=        0.00011597D0
	rhoarr(154)=        0.00008431D0
	rhoarr(155)=        0.00005998D0
	rhoarr(156)=        0.00004146D0
	rhoarr(157)=        0.00002763D0
	rhoarr(158)=        0.00001760D0
	rhoarr(159)=        0.00001064D0
	rhoarr(160)=        0.00000606D0
	rhoarr(161)=        0.00000324D0
	rhoarr(162)=        0.00000162D0
	rhoarr(163)=        0.00000076D0
	rhoarr(164)=        0.00000034D0
	rhoarr(165)=        0.00000014D0
	rhoarr(166)=        0.00000006D0
	rhoarr(167)=        0.00000003D0
	rhoarr(168)=        0.00000001D0
	
else if (iele==82) then  !Pb, 0 4, b3lyp/ANO-RCC int=dkh2
	npt=  166
	rhoarr(  1)=  9246841.14755795D0
	rhoarr(  2)=  4430617.00349360D0
	rhoarr(  3)=  2636391.70571376D0
	rhoarr(  4)=  1715507.19844058D0
	rhoarr(  5)=  1185159.81250141D0
	rhoarr(  6)=   841931.31544093D0
	rhoarr(  7)=   607128.67359737D0
	rhoarr(  8)=   441371.51368866D0
	rhoarr(  9)=   321219.10073774D0
	rhoarr( 10)=   233394.87462224D0
	rhoarr( 11)=   168914.53842452D0
	rhoarr( 12)=   121788.67211244D0
	rhoarr( 13)=    87617.51218759D0
	rhoarr( 14)=    63085.17020734D0
	rhoarr( 15)=    45746.75480365D0
	rhoarr( 16)=    33695.76759220D0
	rhoarr( 17)=    25443.22242016D0
	rhoarr( 18)=    19865.73966394D0
	rhoarr( 19)=    16121.64443237D0
	rhoarr( 20)=    13584.00850401D0
	rhoarr( 21)=    11801.54113383D0
	rhoarr( 22)=    10465.80890192D0
	rhoarr( 23)=     9377.91481564D0
	rhoarr( 24)=     8418.53473318D0
	rhoarr( 25)=     7523.72703267D0
	rhoarr( 26)=     6666.40696090D0
	rhoarr( 27)=     5842.54291178D0
	rhoarr( 28)=     5060.85543725D0
	rhoarr( 29)=     4335.06196736D0
	rhoarr( 30)=     3678.35633095D0
	rhoarr( 31)=     3100.13375140D0
	rhoarr( 32)=     2604.72332027D0
	rhoarr( 33)=     2191.50288703D0
	rhoarr( 34)=     1855.69338451D0
	rhoarr( 35)=     1589.37095571D0
	rhoarr( 36)=     1382.52251868D0
	rhoarr( 37)=     1224.10246503D0
	rhoarr( 38)=     1103.03367630D0
	rhoarr( 39)=     1009.05195442D0
	rhoarr( 40)=      933.30195739D0
	rhoarr( 41)=      868.65383308D0
	rhoarr( 42)=      809.77633888D0
	rhoarr( 43)=      753.03700920D0
	rhoarr( 44)=      696.29819609D0
	rhoarr( 45)=      638.65751364D0
	rhoarr( 46)=      580.16217898D0
	rhoarr( 47)=      521.51783803D0
	rhoarr( 48)=      463.81138232D0
	rhoarr( 49)=      408.26727676D0
	rhoarr( 50)=      356.05332051D0
	rhoarr( 51)=      308.14417493D0
	rhoarr( 52)=      265.24203003D0
	rhoarr( 53)=      227.74651276D0
	rhoarr( 54)=      195.76210406D0
	rhoarr( 55)=      169.13091319D0
	rhoarr( 56)=      147.48046621D0
	rhoarr( 57)=      130.27872013D0
	rhoarr( 58)=      116.89073610D0
	rhoarr( 59)=      106.63292168D0
	rhoarr( 60)=       98.82162584D0
	rhoarr( 61)=       92.81352908D0
	rhoarr( 62)=       88.03605097D0
	rhoarr( 63)=       84.00700940D0
	rhoarr( 64)=       80.34389286D0
	rhoarr( 65)=       76.76411064D0
	rhoarr( 66)=       73.07825148D0
	rhoarr( 67)=       69.17861390D0
	rhoarr( 68)=       65.02511677D0
	rhoarr( 69)=       60.63030188D0
	rhoarr( 70)=       56.04466479D0
	rhoarr( 71)=       51.34312678D0
	rhoarr( 72)=       46.61314795D0
	rhoarr( 73)=       41.94477813D0
	rhoarr( 74)=       37.42280700D0
	rhoarr( 75)=       33.12106296D0
	rhoarr( 76)=       29.09879446D0
	rhoarr( 77)=       25.39894556D0
	rhoarr( 78)=       22.04802899D0
	rhoarr( 79)=       19.05722659D0
	rhoarr( 80)=       16.42432378D0
	rhoarr( 81)=       14.13611159D0
	rhoarr( 82)=       12.17095172D0
	rhoarr( 83)=       10.50127892D0
	rhoarr( 84)=        9.09589150D0
	rhoarr( 85)=        7.92194436D0
	rhoarr( 86)=        6.94660490D0
	rhoarr( 87)=        6.13836349D0
	rhoarr( 88)=        5.46800903D0
	rhoarr( 89)=        4.90929326D0
	rhoarr( 90)=        4.43931523D0
	rhoarr( 91)=        4.03866416D0
	rhoarr( 92)=        3.69136276D0
	rhoarr( 93)=        3.38465609D0
	rhoarr( 94)=        3.10869094D0
	rhoarr( 95)=        2.85612861D0
	rhoarr( 96)=        2.62172920D0
	rhoarr( 97)=        2.40193888D0
	rhoarr( 98)=        2.19450421D0
	rhoarr( 99)=        1.99812955D0
	rhoarr(100)=        1.81218662D0
	rhoarr(101)=        1.63647904D0
	rhoarr(102)=        1.47105961D0
	rhoarr(103)=        1.31609496D0
	rhoarr(104)=        1.17176988D0
	rhoarr(105)=        1.03822305D0
	rhoarr(106)=        0.91550652D0
	rhoarr(107)=        0.80356228D0
	rhoarr(108)=        0.70221101D0
	rhoarr(109)=        0.61114979D0
	rhoarr(110)=        0.52995668D0
	rhoarr(111)=        0.45810137D0
	rhoarr(112)=        0.39496107D0
	rhoarr(113)=        0.33984114D0
	rhoarr(114)=        0.29199930D0
	rhoarr(115)=        0.25067186D0
	rhoarr(116)=        0.21509998D0
	rhoarr(117)=        0.18455393D0
	rhoarr(118)=        0.15835327D0
	rhoarr(119)=        0.13588167D0
	rhoarr(120)=        0.11659551D0
	rhoarr(121)=        0.10002631D0
	rhoarr(122)=        0.08577762D0
	rhoarr(123)=        0.07351768D0
	rhoarr(124)=        0.06296947D0
	rhoarr(125)=        0.05389991D0
	rhoarr(126)=        0.04610976D0
	rhoarr(127)=        0.03942551D0
	rhoarr(128)=        0.03369370D0
	rhoarr(129)=        0.02877774D0
	rhoarr(130)=        0.02455658D0
	rhoarr(131)=        0.02092446D0
	rhoarr(132)=        0.01779095D0
	rhoarr(133)=        0.01508054D0
	rhoarr(134)=        0.01273161D0
	rhoarr(135)=        0.01069475D0
	rhoarr(136)=        0.00893058D0
	rhoarr(137)=        0.00740749D0
	rhoarr(138)=        0.00609934D0
	rhoarr(139)=        0.00498358D0
	rhoarr(140)=        0.00403981D0
	rhoarr(141)=        0.00324882D0
	rhoarr(142)=        0.00259220D0
	rhoarr(143)=        0.00205231D0
	rhoarr(144)=        0.00161247D0
	rhoarr(145)=        0.00125725D0
	rhoarr(146)=        0.00097271D0
	rhoarr(147)=        0.00074646D0
	rhoarr(148)=        0.00056775D0
	rhoarr(149)=        0.00042740D0
	rhoarr(150)=        0.00031774D0
	rhoarr(151)=        0.00023251D0
	rhoarr(152)=        0.00016672D0
	rhoarr(153)=        0.00011648D0
	rhoarr(154)=        0.00007876D0
	rhoarr(155)=        0.00005116D0
	rhoarr(156)=        0.00003168D0
	rhoarr(157)=        0.00001855D0
	rhoarr(158)=        0.00001019D0
	rhoarr(159)=        0.00000523D0
	rhoarr(160)=        0.00000249D0
	rhoarr(161)=        0.00000110D0
	rhoarr(162)=        0.00000046D0
	rhoarr(163)=        0.00000018D0
	rhoarr(164)=        0.00000007D0
	rhoarr(165)=        0.00000003D0
	rhoarr(166)=        0.00000001D0

else if (iele==83) then  !Bi, 0 3, b3lyp/ANO-RCC int=dkh2
	npt=  164
	rhoarr(  1)= 10128034.03472375D0
	rhoarr(  2)=  4784022.97152475D0
	rhoarr(  3)=  2822310.74064577D0
	rhoarr(  4)=  1822658.50581458D0
	rhoarr(  5)=  1251232.92756788D0
	rhoarr(  6)=   883629.53193117D0
	rhoarr(  7)=   633703.71728415D0
	rhoarr(  8)=   458249.09484449D0
	rhoarr(  9)=   331777.88821240D0
	rhoarr( 10)=   239848.26481541D0
	rhoarr( 11)=   172736.36559724D0
	rhoarr( 12)=   123987.83952165D0
	rhoarr( 13)=    88839.43739119D0
	rhoarr( 14)=    63763.09435807D0
	rhoarr( 15)=    46158.26880510D0
	rhoarr( 16)=    33997.92601844D0
	rhoarr( 17)=    25720.32247914D0
	rhoarr( 18)=    20157.38449408D0
	rhoarr( 19)=    16436.35253164D0
	rhoarr( 20)=    13912.23421256D0
	rhoarr( 21)=    12127.17825859D0
	rhoarr( 22)=    10773.01382171D0
	rhoarr( 23)=     9654.08222701D0
	rhoarr( 24)=     8655.29449301D0
	rhoarr( 25)=     7717.06537409D0
	rhoarr( 26)=     6816.39082537D0
	rhoarr( 27)=     5952.73024584D0
	rhoarr( 28)=     5137.33091846D0
	rhoarr( 29)=     4385.21037006D0
	rhoarr( 30)=     3709.69491711D0
	rhoarr( 31)=     3119.48810974D0
	rhoarr( 32)=     2617.80004620D0
	rhoarr( 33)=     2202.72841631D0
	rhoarr( 34)=     1868.17650664D0
	rhoarr( 35)=     1604.93769252D0
	rhoarr( 36)=     1401.84007471D0
	rhoarr( 37)=     1246.90345929D0
	rhoarr( 38)=     1128.40776547D0
	rhoarr( 39)=     1035.74356649D0
	rhoarr( 40)=      959.96145554D0
	rhoarr( 41)=      894.01999136D0
	rhoarr( 42)=      832.79515919D0
	rhoarr( 43)=      772.93229206D0
	rhoarr( 44)=      712.60572679D0
	rhoarr( 45)=      651.22754693D0
	rhoarr( 46)=      589.13194706D0
	rhoarr( 47)=      527.25836720D0
	rhoarr( 48)=      466.85759640D0
	rhoarr( 49)=      409.24320214D0
	rhoarr( 50)=      355.60339450D0
	rhoarr( 51)=      306.87794334D0
	rhoarr( 52)=      263.69493543D0
	rhoarr( 53)=      226.35587008D0
	rhoarr( 54)=      194.85557378D0
	rhoarr( 55)=      168.92461159D0
	rhoarr( 56)=      148.08450958D0
	rhoarr( 57)=      131.70868192D0
	rhoarr( 58)=      119.08375025D0
	rhoarr( 59)=      109.46697970D0
	rhoarr( 60)=      102.13626575D0
	rhoarr( 61)=       96.42993512D0
	rhoarr( 62)=       91.77476896D0
	rhoarr( 63)=       87.70202159D0
	rhoarr( 64)=       83.85251241D0
	rhoarr( 65)=       79.97282599D0
	rhoarr( 66)=       75.90510881D0
	rhoarr( 67)=       71.57291695D0
	rhoarr( 68)=       66.96519804D0
	rhoarr( 69)=       62.11997951D0
	rhoarr( 70)=       57.10884812D0
	rhoarr( 71)=       52.02293220D0
	rhoarr( 72)=       46.96084653D0
	rhoarr( 73)=       42.01889026D0
	rhoarr( 74)=       37.28364759D0
	rhoarr( 75)=       32.82699322D0
	rhoarr( 76)=       28.70334801D0
	rhoarr( 77)=       24.94888430D0
	rhoarr( 78)=       21.58227511D0
	rhoarr( 79)=       18.60653656D0
	rhoarr( 80)=       16.01153004D0
	rhoarr( 81)=       13.77675538D0
	rhoarr( 82)=       11.87415463D0
	rhoarr( 83)=       10.27073561D0
	rhoarr( 84)=        8.93090048D0
	rhoarr( 85)=        7.81842026D0
	rhoarr( 86)=        6.89803395D0
	rhoarr( 87)=        6.13667449D0
	rhoarr( 88)=        5.50433941D0
	rhoarr( 89)=        4.97463477D0
	rhoarr( 90)=        4.52502997D0
	rhoarr( 91)=        4.13686796D0
	rhoarr( 92)=        3.79518063D0
	rhoarr( 93)=        3.48836124D0
	rhoarr( 94)=        3.20774490D0
	rhoarr( 95)=        2.94714347D0
	rhoarr( 96)=        2.70237410D0
	rhoarr( 97)=        2.47081205D0
	rhoarr( 98)=        2.25098870D0
	rhoarr( 99)=        2.04224728D0
	rhoarr(100)=        1.84446080D0
	rhoarr(101)=        1.65781076D0
	rhoarr(102)=        1.48262069D0
	rhoarr(103)=        1.31923617D0
	rhoarr(104)=        1.16794219D0
	rhoarr(105)=        1.02890909D0
	rhoarr(106)=        0.90216005D0
	rhoarr(107)=        0.78755480D0
	rhoarr(108)=        0.68478593D0
	rhoarr(109)=        0.59338560D0
	rhoarr(110)=        0.51274124D0
	rhoarr(111)=        0.44211874D0
	rhoarr(112)=        0.38069187D0
	rhoarr(113)=        0.32757562D0
	rhoarr(114)=        0.28186119D0
	rhoarr(115)=        0.24264971D0
	rhoarr(116)=        0.20908215D0
	rhoarr(117)=        0.18036317D0
	rhoarr(118)=        0.15577758D0
	rhoarr(119)=        0.13469888D0
	rhoarr(120)=        0.11659031D0
	rhoarr(121)=        0.10099969D0
	rhoarr(122)=        0.08754984D0
	rhoarr(123)=        0.07592664D0
	rhoarr(124)=        0.06586670D0
	rhoarr(125)=        0.05714650D0
	rhoarr(126)=        0.04957386D0
	rhoarr(127)=        0.04298216D0
	rhoarr(128)=        0.03722702D0
	rhoarr(129)=        0.03218468D0
	rhoarr(130)=        0.02775099D0
	rhoarr(131)=        0.02384045D0
	rhoarr(132)=        0.02038460D0
	rhoarr(133)=        0.01732978D0
	rhoarr(134)=        0.01463424D0
	rhoarr(135)=        0.01226513D0
	rhoarr(136)=        0.01019551D0
	rhoarr(137)=        0.00840179D0
	rhoarr(138)=        0.00686176D0
	rhoarr(139)=        0.00555331D0
	rhoarr(140)=        0.00445384D0
	rhoarr(141)=        0.00354029D0
	rhoarr(142)=        0.00278955D0
	rhoarr(143)=        0.00217905D0
	rhoarr(144)=        0.00168743D0
	rhoarr(145)=        0.00129506D0
	rhoarr(146)=        0.00098436D0
	rhoarr(147)=        0.00074005D0
	rhoarr(148)=        0.00054916D0
	rhoarr(149)=        0.00040100D0
	rhoarr(150)=        0.00028694D0
	rhoarr(151)=        0.00020013D0
	rhoarr(152)=        0.00013520D0
	rhoarr(153)=        0.00008784D0
	rhoarr(154)=        0.00005445D0
	rhoarr(155)=        0.00003193D0
	rhoarr(156)=        0.00001758D0
	rhoarr(157)=        0.00000900D0
	rhoarr(158)=        0.00000426D0
	rhoarr(159)=        0.00000186D0
	rhoarr(160)=        0.00000074D0
	rhoarr(161)=        0.00000028D0
	rhoarr(162)=        0.00000010D0
	rhoarr(163)=        0.00000004D0
	rhoarr(164)=        0.00000001D0

else if (iele==84) then  !Po, 0 3, b3lyp/ANO-RCC int=dkh2
	npt=  164
	rhoarr(  1)= 11097426.03334285D0
	rhoarr(  2)=  5165380.37003312D0
	rhoarr(  3)=  3020755.30617531D0
	rhoarr(  4)=  1935998.94135128D0
	rhoarr(  5)=  1320529.81939001D0
	rhoarr(  6)=   926992.10331332D0
	rhoarr(  7)=   661126.83522962D0
	rhoarr(  8)=   475511.80300466D0
	rhoarr(  9)=   342482.08627344D0
	rhoarr( 10)=   246321.72190614D0
	rhoarr( 11)=   176531.05291547D0
	rhoarr( 12)=   126145.24414573D0
	rhoarr( 13)=    90023.90444346D0
	rhoarr( 14)=    64418.48819268D0
	rhoarr( 15)=    46561.20318089D0
	rhoarr( 16)=    34302.53469226D0
	rhoarr( 17)=    26008.49353846D0
	rhoarr( 18)=    20464.96720893D0
	rhoarr( 19)=    16767.83448218D0
	rhoarr( 20)=    14255.36970359D0
	rhoarr( 21)=    12464.56450178D0
	rhoarr( 22)=    11088.34476469D0
	rhoarr( 23)=     9934.75391570D0
	rhoarr( 24)=     8893.27226554D0
	rhoarr( 25)=     7908.97230745D0
	rhoarr( 26)=     6963.17005495D0
	rhoarr( 27)=     6058.89228911D0
	rhoarr( 28)=     5209.78112514D0
	rhoarr( 29)=     4431.89342649D0
	rhoarr( 30)=     3738.43143411D0
	rhoarr( 31)=     3137.22929588D0
	rhoarr( 32)=     2630.26562279D0
	rhoarr( 33)=     2214.26480095D0
	rhoarr( 34)=     1881.72073154D0
	rhoarr( 35)=     1622.07254133D0
	rhoarr( 36)=     1422.96385350D0
	rhoarr( 37)=     1271.50487362D0
	rhoarr( 38)=     1155.39020065D0
	rhoarr( 39)=     1063.73078973D0
	rhoarr( 40)=      987.54081124D0
	rhoarr( 41)=      919.91355710D0
	rhoarr( 42)=      855.97061280D0
	rhoarr( 43)=      792.66808891D0
	rhoarr( 44)=      728.51838439D0
	rhoarr( 45)=      663.26331378D0
	rhoarr( 46)=      597.52575544D0
	rhoarr( 47)=      532.46783537D0
	rhoarr( 48)=      469.48433083D0
	rhoarr( 49)=      409.95453664D0
	rhoarr( 50)=      355.06475261D0
	rhoarr( 51)=      305.70111739D0
	rhoarr( 52)=      262.40303708D0
	rhoarr( 53)=      225.36293671D0
	rhoarr( 54)=      194.45798232D0
	rhoarr( 55)=      169.30185031D0
	rhoarr( 56)=      149.30755627D0
	rhoarr( 57)=      133.75458691D0
	rhoarr( 58)=      121.85487326D0
	rhoarr( 59)=      112.81291669D0
	rhoarr( 60)=      105.87620112D0
	rhoarr( 61)=      100.37323463D0
	rhoarr( 62)=       95.73813292D0
	rhoarr( 63)=       91.52228607D0
	rhoarr( 64)=       87.39497051D0
	rhoarr( 65)=       83.13553156D0
	rhoarr( 66)=       78.61992820D0
	rhoarr( 67)=       73.80413869D0
	rhoarr( 68)=       68.70639853D0
	rhoarr( 69)=       63.38969128D0
	rhoarr( 70)=       57.94546440D0
	rhoarr( 71)=       52.47923263D0
	rhoarr( 72)=       47.09852004D0
	rhoarr( 73)=       41.90342172D0
	rhoarr( 74)=       36.97988753D0
	rhoarr( 75)=       32.39563675D0
	rhoarr( 76)=       28.19842389D0
	rhoarr( 77)=       24.41622890D0
	rhoarr( 78)=       21.05886765D0
	rhoarr( 79)=       18.12051687D0
	rhoarr( 80)=       15.58270901D0
	rhoarr( 81)=       13.41744804D0
	rhoarr( 82)=       11.59020111D0
	rhoarr( 83)=       10.06261130D0
	rhoarr( 84)=        8.79484565D0
	rhoarr( 85)=        7.74753888D0
	rhoarr( 86)=        6.88332333D0
	rhoarr( 87)=        6.16795441D0
	rhoarr( 88)=        5.57105561D0
	rhoarr( 89)=        5.06651834D0
	rhoarr( 90)=        4.63260275D0
	rhoarr( 91)=        4.25179376D0
	rhoarr( 92)=        3.91047190D0
	rhoarr( 93)=        3.59845923D0
	rhoarr( 94)=        3.30849711D0
	rhoarr( 95)=        3.03570507D0
	rhoarr( 96)=        2.77705958D0
	rhoarr( 97)=        2.53092050D0
	rhoarr( 98)=        2.29662195D0
	rhoarr( 99)=        2.07413459D0
	rhoarr(100)=        1.86379854D0
	rhoarr(101)=        1.66612089D0
	rhoarr(102)=        1.48162824D0
	rhoarr(103)=        1.31076389D0
	rhoarr(104)=        1.15381997D0
	rhoarr(105)=        1.01089631D0
	rhoarr(106)=        0.88188015D0
	rhoarr(107)=        0.76644261D0
	rhoarr(108)=        0.66404898D0
	rhoarr(109)=        0.57398101D0
	rhoarr(110)=        0.49536880D0
	rhoarr(111)=        0.42723006D0
	rhoarr(112)=        0.36851366D0
	rhoarr(113)=        0.31814409D0
	rhoarr(114)=        0.27506314D0
	rhoarr(115)=        0.23826598D0
	rhoarr(116)=        0.20682880D0
	rhoarr(117)=        0.17992703D0
	rhoarr(118)=        0.15684374D0
	rhoarr(119)=        0.13696926D0
	rhoarr(120)=        0.11979373D0
	rhoarr(121)=        0.10489499D0
	rhoarr(122)=        0.09192433D0
	rhoarr(123)=        0.08059234D0
	rhoarr(124)=        0.07065661D0
	rhoarr(125)=        0.06191231D0
	rhoarr(126)=        0.05418574D0
	rhoarr(127)=        0.04733034D0
	rhoarr(128)=        0.04122425D0
	rhoarr(129)=        0.03576842D0
	rhoarr(130)=        0.03088444D0
	rhoarr(131)=        0.02651182D0
	rhoarr(132)=        0.02260456D0
	rhoarr(133)=        0.01912741D0
	rhoarr(134)=        0.01605210D0
	rhoarr(135)=        0.01335396D0
	rhoarr(136)=        0.01100926D0
	rhoarr(137)=        0.00899332D0
	rhoarr(138)=        0.00727965D0
	rhoarr(139)=        0.00583978D0
	rhoarr(140)=        0.00464380D0
	rhoarr(141)=        0.00366130D0
	rhoarr(142)=        0.00286242D0
	rhoarr(143)=        0.00221883D0
	rhoarr(144)=        0.00170458D0
	rhoarr(145)=        0.00129658D0
	rhoarr(146)=        0.00097491D0
	rhoarr(147)=        0.00072286D0
	rhoarr(148)=        0.00052675D0
	rhoarr(149)=        0.00037565D0
	rhoarr(150)=        0.00026083D0
	rhoarr(151)=        0.00017532D0
	rhoarr(152)=        0.00011338D0
	rhoarr(153)=        0.00007011D0
	rhoarr(154)=        0.00004121D0
	rhoarr(155)=        0.00002291D0
	rhoarr(156)=        0.00001201D0
	rhoarr(157)=        0.00000593D0
	rhoarr(158)=        0.00000277D0
	rhoarr(159)=        0.00000124D0
	rhoarr(160)=        0.00000054D0
	rhoarr(161)=        0.00000023D0
	rhoarr(162)=        0.00000010D0
	rhoarr(163)=        0.00000004D0
	rhoarr(164)=        0.00000002D0

else if (iele==85) then  !At, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=  163
	rhoarr(  1)= 12154352.24903457D0
	rhoarr(  2)=  5577042.14411557D0
	rhoarr(  3)=  3232586.60203711D0
	rhoarr(  4)=  2055854.59632825D0
	rhoarr(  5)=  1393191.56876696D0
	rhoarr(  6)=   972072.58438433D0
	rhoarr(  7)=   689409.15599834D0
	rhoarr(  8)=   493157.78248561D0
	rhoarr(  9)=   353324.18464332D0
	rhoarr( 10)=   252808.93031248D0
	rhoarr( 11)=   180294.15178751D0
	rhoarr( 12)=   128258.06672091D0
	rhoarr( 13)=    91170.98257154D0
	rhoarr( 14)=    65052.58354000D0
	rhoarr( 15)=    46957.13892417D0
	rhoarr( 16)=    34611.71188893D0
	rhoarr( 17)=    26309.89014462D0
	rhoarr( 18)=    20790.09259187D0
	rhoarr( 19)=    17117.10473032D0
	rhoarr( 20)=    14614.03616492D0
	rhoarr( 21)=    12814.03706175D0
	rhoarr( 22)=    11411.87828186D0
	rhoarr( 23)=    10219.78176477D0
	rhoarr( 24)=     9132.19057392D0
	rhoarr( 25)=     8099.17338980D0
	rhoarr( 26)=     7106.57960745D0
	rhoarr( 27)=     6161.00787413D0
	rhoarr( 28)=     5278.30189304D0
	rhoarr( 29)=     4475.28235870D0
	rhoarr( 30)=     3764.78910706D0
	rhoarr( 31)=     3153.62393039D0
	rhoarr( 32)=     2642.41481471D0
	rhoarr( 33)=     2226.40267618D0
	rhoarr( 34)=     1896.57278389D0
	rhoarr( 35)=     1640.94799773D0
	rhoarr( 36)=     1445.98029438D0
	rhoarr( 37)=     1297.91056365D0
	rhoarr( 38)=     1183.91202187D0
	rhoarr( 39)=     1092.88134669D0
	rhoarr( 40)=     1015.85272470D0
	rhoarr( 41)=      946.10171837D0
	rhoarr( 42)=      879.03689422D0
	rhoarr( 43)=      811.96020206D0
	rhoarr( 44)=      743.74731828D0
	rhoarr( 45)=      674.48134271D0
	rhoarr( 46)=      605.07074248D0
	rhoarr( 47)=      536.88530565D0
	rhoarr( 48)=      471.44190421D0
	rhoarr( 49)=      410.16196175D0
	rhoarr( 50)=      354.20816459D0
	rhoarr( 51)=      304.39478904D0
	rhoarr( 52)=      261.15790805D0
	rhoarr( 53)=      224.56937140D0
	rhoarr( 54)=      194.38009520D0
	rhoarr( 55)=      170.08135725D0
	rhoarr( 56)=      150.97558656D0
	rhoarr( 57)=      136.24984769D0
	rhoarr( 58)=      125.04612122D0
	rhoarr( 59)=      116.52325077D0
	rhoarr( 60)=      109.90660153D0
	rhoarr( 61)=      104.52317257D0
	rhoarr( 62)=       99.82184959D0
	rhoarr( 63)=       95.38022955D0
	rhoarr( 64)=       90.90062701D0
	rhoarr( 65)=       86.19834328D0
	rhoarr( 66)=       81.18514356D0
	rhoarr( 67)=       75.85038265D0
	rhoarr( 68)=       70.24160938D0
	rhoarr( 69)=       64.44594522D0
	rhoarr( 70)=       58.57314604D0
	rhoarr( 71)=       52.74099476D0
	rhoarr( 72)=       47.06346901D0
	rhoarr( 73)=       41.64192229D0
	rhoarr( 74)=       36.55928690D0
	rhoarr( 75)=       31.87707181D0
	rhoarr( 76)=       27.63473062D0
	rhoarr( 77)=       23.85085149D0
	rhoarr( 78)=       20.52558869D0
	rhoarr( 79)=       17.64380371D0
	rhoarr( 80)=       15.17848364D0
	rhoarr( 81)=       13.09412210D0
	rhoarr( 82)=       11.34985623D0
	rhoarr( 83)=        9.90223818D0
	rhoarr( 84)=        8.70757833D0
	rhoarr( 85)=        7.72383472D0
	rhoarr( 86)=        6.91204756D0
	rhoarr( 87)=        6.23733511D0
	rhoarr( 88)=        5.66948229D0
	rhoarr( 89)=        5.18316730D0
	rhoarr( 90)=        4.75788421D0
	rhoarr( 91)=        4.37762792D0
	rhoarr( 92)=        4.03041212D0
	rhoarr( 93)=        3.70768868D0
	rhoarr( 94)=        3.40372954D0
	rhoarr( 95)=        3.11502072D0
	rhoarr( 96)=        2.83970464D0
	rhoarr( 97)=        2.57709366D0
	rhoarr( 98)=        2.32726519D0
	rhoarr( 99)=        2.09073931D0
	rhoarr(100)=        1.86823260D0
	rhoarr(101)=        1.66047765D0
	rhoarr(102)=        1.46809650D0
	rhoarr(103)=        1.29151670D0
	rhoarr(104)=        1.13092065D0
	rhoarr(105)=        0.98622118D0
	rhoarr(106)=        0.85705870D0
	rhoarr(107)=        0.74281604D0
	rhoarr(108)=        0.64264851D0
	rhoarr(109)=        0.55552589D0
	rhoarr(110)=        0.48028299D0
	rhoarr(111)=        0.41567480D0
	rhoarr(112)=        0.36043172D0
	rhoarr(113)=        0.31331058D0
	rhoarr(114)=        0.27313767D0
	rhoarr(115)=        0.23884118D0
	rhoarr(116)=        0.20947158D0
	rhoarr(117)=        0.18421016D0
	rhoarr(118)=        0.16236718D0
	rhoarr(119)=        0.14337191D0
	rhoarr(120)=        0.12675756D0
	rhoarr(121)=        0.11214409D0
	rhoarr(122)=        0.09922147D0
	rhoarr(123)=        0.08773533D0
	rhoarr(124)=        0.07747580D0
	rhoarr(125)=        0.06826972D0
	rhoarr(126)=        0.05997554D0
	rhoarr(127)=        0.05247960D0
	rhoarr(128)=        0.04569314D0
	rhoarr(129)=        0.03954892D0
	rhoarr(130)=        0.03399730D0
	rhoarr(131)=        0.02900178D0
	rhoarr(132)=        0.02453440D0
	rhoarr(133)=        0.02057140D0
	rhoarr(134)=        0.01708953D0
	rhoarr(135)=        0.01406341D0
	rhoarr(136)=        0.01146393D0
	rhoarr(137)=        0.00925784D0
	rhoarr(138)=        0.00740823D0
	rhoarr(139)=        0.00587575D0
	rhoarr(140)=        0.00462014D0
	rhoarr(141)=        0.00360188D0
	rhoarr(142)=        0.00278362D0
	rhoarr(143)=        0.00213129D0
	rhoarr(144)=        0.00161485D0
	rhoarr(145)=        0.00120858D0
	rhoarr(146)=        0.00089108D0
	rhoarr(147)=        0.00064494D0
	rhoarr(148)=        0.00045623D0
	rhoarr(149)=        0.00031386D0
	rhoarr(150)=        0.00020879D0
	rhoarr(151)=        0.00013354D0
	rhoarr(152)=        0.00008163D0
	rhoarr(153)=        0.00004744D0
	rhoarr(154)=        0.00002610D0
	rhoarr(155)=        0.00001355D0
	rhoarr(156)=        0.00000664D0
	rhoarr(157)=        0.00000308D0
	rhoarr(158)=        0.00000137D0
	rhoarr(159)=        0.00000059D0
	rhoarr(160)=        0.00000025D0
	rhoarr(161)=        0.00000011D0
	rhoarr(162)=        0.00000005D0
	rhoarr(163)=        0.00000002D0

else if (iele==86) then  !Rn, 0 1, b3lyp/ANO-RCC int=dkh2
	npt=  162
	rhoarr(  1)= 13247416.19713481D0
	rhoarr(  2)=  6021931.40888992D0
	rhoarr(  3)=  3458860.78232330D0
	rhoarr(  4)=  2182478.61953138D0
	rhoarr(  5)=  1469377.53912302D0
	rhoarr(  6)=  1018940.12097554D0
	rhoarr(  7)=   718552.94689336D0
	rhoarr(  8)=   511186.59885158D0
	rhoarr(  9)=   364297.12826176D0
	rhoarr( 10)=   259304.68901470D0
	rhoarr( 11)=   184021.07226543D0
	rhoarr( 12)=   130322.99866453D0
	rhoarr( 13)=    92281.04931713D0
	rhoarr( 14)=    65666.43643731D0
	rhoarr( 15)=    47347.26703627D0
	rhoarr( 16)=    34927.30749760D0
	rhoarr( 17)=    26626.25003042D0
	rhoarr( 18)=    21133.75965126D0
	rhoarr( 19)=    17484.58606836D0
	rhoarr( 20)=    14988.37169547D0
	rhoarr( 21)=    13175.51307807D0
	rhoarr( 22)=    11743.28083379D0
	rhoarr( 23)=    10508.62469098D0
	rhoarr( 24)=     9371.44029512D0
	rhoarr( 25)=     8287.15016797D0
	rhoarr( 26)=     7246.28171089D0
	rhoarr( 27)=     6258.91692404D0
	rhoarr( 28)=     5342.86012042D0
	rhoarr( 29)=     4515.43024593D0
	rhoarr( 30)=     3788.89404695D0
	rhoarr( 31)=     3168.86426828D0
	rhoarr( 32)=     2654.48152519D0
	rhoarr( 33)=     2239.37523310D0
	rhoarr( 34)=     1912.92357039D0
	rhoarr( 35)=     1661.68912499D0
	rhoarr( 36)=     1470.94606225D0
	rhoarr( 37)=     1326.11862199D0
	rhoarr( 38)=     1213.92498420D0
	rhoarr( 39)=     1123.11109015D0
	rhoarr( 40)=     1044.78720986D0
	rhoarr( 41)=      972.46101831D0
	rhoarr( 42)=      901.87197716D0
	rhoarr( 43)=      830.70277962D0
	rhoarr( 44)=      758.21385760D0
	rhoarr( 45)=      684.83525233D0
	rhoarr( 46)=      611.75221962D0
	rhoarr( 47)=      540.52339455D0
	rhoarr( 48)=      472.76433688D0
	rhoarr( 49)=      409.91503146D0
	rhoarr( 50)=      353.09335659D0
	rhoarr( 51)=      303.02376100D0
	rhoarr( 52)=      260.02424842D0
	rhoarr( 53)=      224.03451595D0
	rhoarr( 54)=      194.67103203D0
	rhoarr( 55)=      171.29826669D0
	rhoarr( 56)=      153.10768918D0
	rhoarr( 57)=      139.19737600D0
	rhoarr( 58)=      128.64580689D0
	rhoarr( 59)=      120.57444406D0
	rhoarr( 60)=      114.19536179D0
	rhoarr( 61)=      108.84236762D0
	rhoarr( 62)=      103.98624585D0
	rhoarr( 63)=       99.23645312D0
	rhoarr( 64)=       94.33251383D0
	rhoarr( 65)=       89.12850482D0
	rhoarr( 66)=       83.57361166D0
	rhoarr( 67)=       77.69109053D0
	rhoarr( 68)=       71.55733578D0
	rhoarr( 69)=       65.28226535D0
	rhoarr( 70)=       58.99190456D0
	rhoarr( 71)=       52.81380685D0
	rhoarr( 72)=       46.86572039D0
	rhoarr( 73)=       41.24764991D0
	rhoarr( 74)=       36.03718372D0
	rhoarr( 75)=       31.28769852D0
	rhoarr( 76)=       27.02887187D0
	rhoarr( 77)=       23.26885194D0
	rhoarr( 78)=       19.99745569D0
	rhoarr( 79)=       17.18986166D0
	rhoarr( 80)=       14.81039348D0
	rhoarr( 81)=       12.81611920D0
	rhoarr( 82)=       11.16009741D0
	rhoarr( 83)=        9.79417692D0
	rhoarr( 84)=        8.67130515D0
	rhoarr( 85)=        7.74733083D0
	rhoarr( 86)=        6.98230789D0
	rhoarr( 87)=        6.34132526D0
	rhoarr( 88)=        5.79490457D0
	rhoarr( 89)=        5.31902465D0
	rhoarr( 90)=        4.89484497D0
	rhoarr( 91)=        4.50820830D0
	rhoarr( 92)=        4.14900393D0
	rhoarr( 93)=        3.81046647D0
	rhoarr( 94)=        3.48847324D0
	rhoarr( 95)=        3.18088773D0
	rhoarr( 96)=        2.88698038D0
	rhoarr( 97)=        2.60694237D0
	rhoarr( 98)=        2.34149596D0
	rhoarr( 99)=        2.09159531D0
	rhoarr(100)=        1.85820652D0
	rhoarr(101)=        1.64215308D0
	rhoarr(102)=        1.44401363D0
	rhoarr(103)=        1.26406077D0
	rhoarr(104)=        1.10223262D0
	rhoarr(105)=        0.95813098D0
	rhoarr(106)=        0.83104164D0
	rhoarr(107)=        0.71997327D0
	rhoarr(108)=        0.62371058D0
	rhoarr(109)=        0.54087764D0
	rhoarr(110)=        0.47000593D0
	rhoarr(111)=        0.40960192D0
	rhoarr(112)=        0.35820878D0
	rhoarr(113)=        0.31445791D0
	rhoarr(114)=        0.27710713D0
	rhoarr(115)=        0.24506421D0
	rhoarr(116)=        0.21739605D0
	rhoarr(117)=        0.19332532D0
	rhoarr(118)=        0.17221773D0
	rhoarr(119)=        0.15356335D0
	rhoarr(120)=        0.13695557D0
	rhoarr(121)=        0.12207083D0
	rhoarr(122)=        0.10865102D0
	rhoarr(123)=        0.09648983D0
	rhoarr(124)=        0.08542282D0
	rhoarr(125)=        0.07532054D0
	rhoarr(126)=        0.06608347D0
	rhoarr(127)=        0.05763766D0
	rhoarr(128)=        0.04993022D0
	rhoarr(129)=        0.04292438D0
	rhoarr(130)=        0.03659416D0
	rhoarr(131)=        0.03091905D0
	rhoarr(132)=        0.02587921D0
	rhoarr(133)=        0.02145165D0
	rhoarr(134)=        0.01760764D0
	rhoarr(135)=        0.01431157D0
	rhoarr(136)=        0.01152106D0
	rhoarr(137)=        0.00918820D0
	rhoarr(138)=        0.00726158D0
	rhoarr(139)=        0.00568854D0
	rhoarr(140)=        0.00441752D0
	rhoarr(141)=        0.00339998D0
	rhoarr(142)=        0.00259190D0
	rhoarr(143)=        0.00195466D0
	rhoarr(144)=        0.00145544D0
	rhoarr(145)=        0.00106706D0
	rhoarr(146)=        0.00076753D0
	rhoarr(147)=        0.00053928D0
	rhoarr(148)=        0.00036826D0
	rhoarr(149)=        0.00024306D0
	rhoarr(150)=        0.00015417D0
	rhoarr(151)=        0.00009344D0
	rhoarr(152)=        0.00005382D0
	rhoarr(153)=        0.00002934D0
	rhoarr(154)=        0.00001509D0
	rhoarr(155)=        0.00000732D0
	rhoarr(156)=        0.00000336D0
	rhoarr(157)=        0.00000147D0
	rhoarr(158)=        0.00000062D0
	rhoarr(159)=        0.00000026D0
	rhoarr(160)=        0.00000011D0
	rhoarr(161)=        0.00000005D0
	rhoarr(162)=        0.00000002D0

else if (iele==87) then  !Fr, 0 2, b3lyp/ANO-RCC int=dkh2
	npt=  171
	rhoarr(  1)= 11095492.25268421D0
	rhoarr(  2)=  6306908.99503986D0
	rhoarr(  3)=  3632283.62357379D0
	rhoarr(  4)=  2302076.01112353D0
	rhoarr(  5)=  1540884.92815559D0
	rhoarr(  6)=  1064139.98453936D0
	rhoarr(  7)=   747035.45201651D0
	rhoarr(  8)=   528647.16082803D0
	rhoarr(  9)=   374910.26096805D0
	rhoarr( 10)=   265610.60246435D0
	rhoarr( 11)=   187651.80740863D0
	rhoarr( 12)=   132331.17479824D0
	rhoarr( 13)=    93363.18064266D0
	rhoarr( 14)=    66282.82811606D0
	rhoarr( 15)=    47758.74771884D0
	rhoarr( 16)=    35272.49592107D0
	rhoarr( 17)=    26975.03364332D0
	rhoarr( 18)=    21508.03211689D0
	rhoarr( 19)=    17877.20446546D0
	rhoarr( 20)=    15381.07520161D0
	rhoarr( 21)=    13549.03133212D0
	rhoarr( 22)=    12081.39916600D0
	rhoarr( 23)=    10799.79946635D0
	rhoarr( 24)=     9609.50558175D0
	rhoarr( 25)=     8471.42939551D0
	rhoarr( 26)=     7380.96586330D0
	rhoarr( 27)=     6351.64490237D0
	rhoarr( 28)=     5402.90286283D0
	rhoarr( 29)=     4552.12608584D0
	rhoarr( 30)=     3810.69596506D0
	rhoarr( 31)=     3182.89870992D0
	rhoarr( 32)=     2666.33711378D0
	rhoarr( 33)=     2252.97291895D0
	rhoarr( 34)=     1930.50193645D0
	rhoarr( 35)=     1683.97556943D0
	rhoarr( 36)=     1497.49890625D0
	rhoarr( 37)=     1355.74137090D0
	rhoarr( 38)=     1245.04661111D0
	rhoarr( 39)=     1154.07837144D0
	rhoarr( 40)=     1074.07032131D0
	rhoarr( 41)=      998.79599678D0
	rhoarr( 42)=      924.35588036D0
	rhoarr( 43)=      848.84198736D0
	rhoarr( 44)=      771.92076296D0
	rhoarr( 45)=      694.37600087D0
	rhoarr( 46)=      617.65976080D0
	rhoarr( 47)=      543.49677908D0
	rhoarr( 48)=      473.57353492D0
	rhoarr( 49)=      409.32308062D0
	rhoarr( 50)=      351.79927503D0
	rhoarr( 51)=      301.62411736D0
	rhoarr( 52)=      258.98959568D0
	rhoarr( 53)=      223.69785481D0
	rhoarr( 54)=      195.22704832D0
	rhoarr( 55)=      172.81278701D0
	rhoarr( 56)=      155.53623430D0
	rhoarr( 57)=      142.41041751D0
	rhoarr( 58)=      132.45723918D0
	rhoarr( 59)=      124.76951698D0
	rhoarr( 60)=      118.55499672D0
	rhoarr( 61)=      113.16205885D0
	rhoarr( 62)=      108.08910216D0
	rhoarr( 63)=      102.98093218D0
	rhoarr( 64)=       97.61586950D0
	rhoarr( 65)=       91.88698142D0
	rhoarr( 66)=       85.78019668D0
	rhoarr( 67)=       79.35140086D0
	rhoarr( 68)=       72.70409555D0
	rhoarr( 69)=       65.96885046D0
	rhoarr( 70)=       59.28550803D0
	rhoarr( 71)=       52.78882314D0
	rhoarr( 72)=       46.59789142D0
	rhoarr( 73)=       40.80935632D0
	rhoarr( 74)=       35.49404630D0
	rhoarr( 75)=       30.69644513D0
	rhoarr( 76)=       26.43627702D0
	rhoarr( 77)=       22.71149222D0
	rhoarr( 78)=       19.50203450D0
	rhoarr( 79)=       16.77391100D0
	rhoarr( 80)=       14.48322544D0
	rhoarr( 81)=       12.57995089D0
	rhoarr( 82)=       11.01129969D0
	rhoarr( 83)=        9.72460134D0
	rhoarr( 84)=        8.66963395D0
	rhoarr( 85)=        7.80038357D0
	rhoarr( 86)=        7.07623345D0
	rhoarr( 87)=        6.46261491D0
	rhoarr( 88)=        5.93118015D0
	rhoarr( 89)=        5.45958150D0
	rhoarr( 90)=        5.03095639D0
	rhoarr( 91)=        4.63322128D0
	rhoarr( 92)=        4.25827074D0
	rhoarr( 93)=        3.90116235D0
	rhoarr( 94)=        3.55934779D0
	rhoarr( 95)=        3.23198929D0
	rhoarr( 96)=        2.91938160D0
	rhoarr( 97)=        2.62248363D0
	rhoarr( 98)=        2.34255382D0
	rhoarr( 99)=        2.08087655D0
	rhoarr(100)=        1.83856531D0
	rhoarr(101)=        1.61642887D0
	rhoarr(102)=        1.41488929D0
	rhoarr(103)=        1.23394312D0
	rhoarr(104)=        1.07315924D0
	rhoarr(105)=        0.93170755D0
	rhoarr(106)=        0.80841292D0
	rhoarr(107)=        0.70182790D0
	rhoarr(108)=        0.61031700D0
	rhoarr(109)=        0.53214501D0
	rhoarr(110)=        0.46556179D0
	rhoarr(111)=        0.40887700D0
	rhoarr(112)=        0.36051985D0
	rhoarr(113)=        0.31908092D0
	rhoarr(114)=        0.28333550D0
	rhoarr(115)=        0.25224988D0
	rhoarr(116)=        0.22497369D0
	rhoarr(117)=        0.20082241D0
	rhoarr(118)=        0.17925433D0
	rhoarr(119)=        0.15984611D0
	rhoarr(120)=        0.14226967D0
	rhoarr(121)=        0.12627257D0
	rhoarr(122)=        0.11166223D0
	rhoarr(123)=        0.09829377D0
	rhoarr(124)=        0.08606040D0
	rhoarr(125)=        0.07488530D0
	rhoarr(126)=        0.06471413D0
	rhoarr(127)=        0.05550772D0
	rhoarr(128)=        0.04723506D0
	rhoarr(129)=        0.03986691D0
	rhoarr(130)=        0.03337054D0
	rhoarr(131)=        0.02770601D0
	rhoarr(132)=        0.02282434D0
	rhoarr(133)=        0.01866741D0
	rhoarr(134)=        0.01516936D0
	rhoarr(135)=        0.01225918D0
	rhoarr(136)=        0.00986379D0
	rhoarr(137)=        0.00791110D0
	rhoarr(138)=        0.00633277D0
	rhoarr(139)=        0.00506617D0
	rhoarr(140)=        0.00405566D0
	rhoarr(141)=        0.00325308D0
	rhoarr(142)=        0.00261761D0
	rhoarr(143)=        0.00211531D0
	rhoarr(144)=        0.00171823D0
	rhoarr(145)=        0.00140364D0
	rhoarr(146)=        0.00115314D0
	rhoarr(147)=        0.00095196D0
	rhoarr(148)=        0.00078843D0
	rhoarr(149)=        0.00065352D0
	rhoarr(150)=        0.00054047D0
	rhoarr(151)=        0.00044444D0
	rhoarr(152)=        0.00036211D0
	rhoarr(153)=        0.00029132D0
	rhoarr(154)=        0.00023066D0
	rhoarr(155)=        0.00017921D0
	rhoarr(156)=        0.00013622D0
	rhoarr(157)=        0.00010103D0
	rhoarr(158)=        0.00007293D0
	rhoarr(159)=        0.00005110D0
	rhoarr(160)=        0.00003467D0
	rhoarr(161)=        0.00002274D0
	rhoarr(162)=        0.00001438D0
	rhoarr(163)=        0.00000876D0
	rhoarr(164)=        0.00000513D0
	rhoarr(165)=        0.00000288D0
	rhoarr(166)=        0.00000154D0
	rhoarr(167)=        0.00000078D0
	rhoarr(168)=        0.00000037D0
	rhoarr(169)=        0.00000016D0
	rhoarr(170)=        0.00000006D0
	rhoarr(171)=        0.00000002D0

else if (iele==88) then  !Ra, 0 1, b3lyp/ANO-RCC int=dkh2
	npt=  169
	rhoarr(  1)= 12053860.35375464D0
	rhoarr(  2)=  6801004.67907905D0
	rhoarr(  3)=  3882355.71706539D0
	rhoarr(  4)=  2442132.04074756D0
	rhoarr(  5)=  1623699.93560772D0
	rhoarr(  6)=  1114464.00386245D0
	rhoarr(  7)=   777866.08879034D0
	rhoarr(  8)=   547375.44651947D0
	rhoarr(  9)=   386113.80305669D0
	rhoarr( 10)=   272110.40651078D0
	rhoarr( 11)=   191303.02833431D0
	rhoarr( 12)=   134301.98985736D0
	rhoarr( 13)=    94402.71025306D0
	rhoarr( 14)=    66863.02358028D0
	rhoarr( 15)=    48144.40363942D0
	rhoarr( 16)=    35606.23722178D0
	rhoarr( 17)=    27325.02662402D0
	rhoarr( 18)=    21891.03210845D0
	rhoarr( 19)=    18281.65040321D0
	rhoarr( 20)=    15785.73984582D0
	rhoarr( 21)=    13932.63639462D0
	rhoarr( 22)=    12426.49208014D0
	rhoarr( 23)=    11094.37877906D0
	rhoarr( 24)=     9847.72556549D0
	rhoarr( 25)=     8653.53676830D0
	rhoarr( 26)=     7512.28605883D0
	rhoarr( 27)=     6440.77055303D0
	rhoarr( 28)=     5459.72870432D0
	rhoarr( 29)=     4586.36736950D0
	rhoarr( 30)=     3831.05291046D0
	rhoarr( 31)=     3196.63216230D0
	rhoarr( 32)=     2679.00662184D0
	rhoarr( 33)=     2268.28978544D0
	rhoarr( 34)=     1950.37379736D0
	rhoarr( 35)=     1708.77491864D0
	rhoarr( 36)=     1526.48054702D0
	rhoarr( 37)=     1387.48419977D0
	rhoarr( 38)=     1277.82845671D0
	rhoarr( 39)=     1186.15733806D0
	rhoarr( 40)=     1103.88780046D0
	rhoarr( 41)=     1025.12076152D0
	rhoarr( 42)=      946.37417563D0
	rhoarr( 43)=      866.18883152D0
	rhoarr( 44)=      784.65189470D0
	rhoarr( 45)=      702.89215112D0
	rhoarr( 46)=      622.60461923D0
	rhoarr( 47)=      545.65117461D0
	rhoarr( 48)=      473.76197576D0
	rhoarr( 49)=      408.33984393D0
	rhoarr( 50)=      350.35432116D0
	rhoarr( 51)=      300.30613505D0
	rhoarr( 52)=      258.24367240D0
	rhoarr( 53)=      223.81656360D0
	rhoarr( 54)=      196.35440295D0
	rhoarr( 55)=      174.95992264D0
	rhoarr( 56)=      158.60627185D0
	rhoarr( 57)=      146.22867992D0
	rhoarr( 58)=      136.80253418D0
	rhoarr( 59)=      129.40277340D0
	rhoarr( 60)=      123.24282703D0
	rhoarr( 61)=      117.69427308D0
	rhoarr( 62)=      112.29034698D0
	rhoarr( 63)=      106.71725317D0
	rhoarr( 64)=      100.79714110D0
	rhoarr( 65)=       94.46602388D0
	rhoarr( 66)=       87.74922857D0
	rhoarr( 67)=       80.73640236D0
	rhoarr( 68)=       73.55770238D0
	rhoarr( 69)=       66.36249278D0
	rhoarr( 70)=       59.30155424D0
	rhoarr( 71)=       52.51342123D0
	rhoarr( 72)=       46.11501648D0
	rhoarr( 73)=       40.19632249D0
	rhoarr( 74)=       34.81849686D0
	rhoarr( 75)=       30.01465466D0
	rhoarr( 76)=       25.79250929D0
	rhoarr( 77)=       22.13814898D0
	rhoarr( 78)=       19.02037148D0
	rhoarr( 79)=       16.39515463D0
	rhoarr( 80)=       14.20997080D0
	rhoarr( 81)=       12.40774685D0
	rhoarr( 82)=       10.93033338D0
	rhoarr( 83)=        9.72139004D0
	rhoarr( 84)=        8.72862960D0
	rhoarr( 85)=        7.90540100D0
	rhoarr( 86)=        7.21163169D0
	rhoarr( 87)=        6.61418895D0
	rhoarr( 88)=        6.08675337D0
	rhoarr( 89)=        5.60931934D0
	rhoarr( 90)=        5.16744486D0
	rhoarr( 91)=        4.75136622D0
	rhoarr( 92)=        4.35507576D0
	rhoarr( 93)=        3.97543726D0
	rhoarr( 94)=        3.61138847D0
	rhoarr( 95)=        3.26325753D0
	rhoarr( 96)=        2.93220152D0
	rhoarr( 97)=        2.61976279D0
	rhoarr( 98)=        2.32753115D0
	rhoarr( 99)=        2.05689737D0
	rhoarr(100)=        1.80888400D0
	rhoarr(101)=        1.58404150D0
	rhoarr(102)=        1.38240024D0
	rhoarr(103)=        1.20347009D0
	rhoarr(104)=        1.04628007D0
	rhoarr(105)=        0.90944960D0
	rhoarr(106)=        0.79128229D0
	rhoarr(107)=        0.68987228D0
	rhoarr(108)=        0.60321282D0
	rhoarr(109)=        0.52929801D0
	rhoarr(110)=        0.46620969D0
	rhoarr(111)=        0.41218433D0
	rhoarr(112)=        0.36565720D0
	rhoarr(113)=        0.32528432D0
	rhoarr(114)=        0.28994454D0
	rhoarr(115)=        0.25872638D0
	rhoarr(116)=        0.23090467D0
	rhoarr(117)=        0.20591218D0
	rhoarr(118)=        0.18331078D0
	rhoarr(119)=        0.16276504D0
	rhoarr(120)=        0.14402021D0
	rhoarr(121)=        0.12688467D0
	rhoarr(122)=        0.11121637D0
	rhoarr(123)=        0.09691192D0
	rhoarr(124)=        0.08389717D0
	rhoarr(125)=        0.07211858D0
	rhoarr(126)=        0.06153480D0
	rhoarr(127)=        0.05210887D0
	rhoarr(128)=        0.04380127D0
	rhoarr(129)=        0.03656454D0
	rhoarr(130)=        0.03033985D0
	rhoarr(131)=        0.02505575D0
	rhoarr(132)=        0.02062902D0
	rhoarr(133)=        0.01696727D0
	rhoarr(134)=        0.01397276D0
	rhoarr(135)=        0.01154680D0
	rhoarr(136)=        0.00959396D0
	rhoarr(137)=        0.00802581D0
	rhoarr(138)=        0.00676363D0
	rhoarr(139)=        0.00574005D0
	rhoarr(140)=        0.00489967D0
	rhoarr(141)=        0.00419876D0
	rhoarr(142)=        0.00360416D0
	rhoarr(143)=        0.00309177D0
	rhoarr(144)=        0.00264467D0
	rhoarr(145)=        0.00225134D0
	rhoarr(146)=        0.00190394D0
	rhoarr(147)=        0.00159702D0
	rhoarr(148)=        0.00132653D0
	rhoarr(149)=        0.00108926D0
	rhoarr(150)=        0.00088252D0
	rhoarr(151)=        0.00070402D0
	rhoarr(152)=        0.00055169D0
	rhoarr(153)=        0.00042362D0
	rhoarr(154)=        0.00031789D0
	rhoarr(155)=        0.00023249D0
	rhoarr(156)=        0.00016525D0
	rhoarr(157)=        0.00011382D0
	rhoarr(158)=        0.00007575D0
	rhoarr(159)=        0.00004857D0
	rhoarr(160)=        0.00002992D0
	rhoarr(161)=        0.00001768D0
	rhoarr(162)=        0.00000999D0
	rhoarr(163)=        0.00000539D0
	rhoarr(164)=        0.00000278D0
	rhoarr(165)=        0.00000135D0
	rhoarr(166)=        0.00000062D0
	rhoarr(167)=        0.00000026D0
	rhoarr(168)=        0.00000010D0
	rhoarr(169)=        0.00000003D0

else if (iele==89) then  !Ac, 6d1 7s2, 0 2, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      17275747.7007159740D0
	rhoarr(  2)=       7378386.7045513969D0
	rhoarr(  3)=       4111241.0029246993D0
	rhoarr(  4)=       2574127.2793260752D0
	rhoarr(  5)=       1702325.1907697332D0
	rhoarr(  6)=       1165028.1806492677D0
	rhoarr(  7)=        810098.3661302058D0
	rhoarr(  8)=        567709.3283182587D0
	rhoarr(  9)=        397832.6279512211D0
	rhoarr( 10)=        278400.3728645858D0
	rhoarr( 11)=        194643.7867343989D0
	rhoarr( 12)=        136089.8753758248D0
	rhoarr( 13)=         95420.5633848037D0
	rhoarr( 14)=         67474.1602296524D0
	rhoarr( 15)=         48558.3880467251D0
	rhoarr( 16)=         35972.2680348832D0
	rhoarr( 17)=         27708.8962177272D0
	rhoarr( 18)=         22302.3807118713D0
	rhoarr( 19)=         18708.8190925087D0
	rhoarr( 20)=         16208.0293221323D0
	rhoarr( 21)=         14327.3965185890D0
	rhoarr( 22)=         12775.8666641055D0
	rhoarr( 23)=         11388.0183527890D0
	rhoarr( 24)=         10082.3061230695D0
	rhoarr( 25)=          8831.3674108852D0
	rhoarr( 26)=          7639.7507763010D0
	rhoarr( 27)=          6526.7284991042D0
	rhoarr( 28)=          5514.0964390349D0
	rhoarr( 29)=          4619.0160957792D0
	rhoarr( 30)=          3850.9785719222D0
	rhoarr( 31)=          3211.3375167185D0
	rhoarr( 32)=          2694.0969216439D0
	rhoarr( 33)=          2287.3081192357D0
	rhoarr( 34)=          1974.8843779592D0
	rhoarr( 35)=          1738.6726060265D0
	rhoarr( 36)=          1560.4676060391D0
	rhoarr( 37)=          1423.6152437586D0
	rhoarr( 38)=          1314.0056979861D0
	rhoarr( 39)=          1220.4833494278D0
	rhoarr( 40)=          1134.8463445075D0
	rhoarr( 41)=          1051.6238128227D0
	rhoarr( 42)=           967.7478190378D0
	rhoarr( 43)=           882.1585004195D0
	rhoarr( 44)=           795.3450839596D0
	rhoarr( 45)=           708.8362041456D0
	rhoarr( 46)=           624.6828133257D0
	rhoarr( 47)=           544.9958290199D0
	rhoarr( 48)=           471.5944560262D0
	rhoarr( 49)=           405.7942982780D0
	rhoarr( 50)=           348.3311412979D0
	rhoarr( 51)=           299.3902697343D0
	rhoarr( 52)=           258.6994403192D0
	rhoarr( 53)=           225.6459016032D0
	rhoarr( 54)=           199.3891480102D0
	rhoarr( 55)=           178.9551342958D0
	rhoarr( 56)=           163.3094718794D0
	rhoarr( 57)=           151.4141095496D0
	rhoarr( 58)=           142.2739041301D0
	rhoarr( 59)=           134.9776286093D0
	rhoarr( 60)=           128.7343865639D0
	rhoarr( 61)=           122.9031087909D0
	rhoarr( 62)=           117.0111954038D0
	rhoarr( 63)=           110.7588994630D0
	rhoarr( 64)=           104.0082822500D0
	rhoarr( 65)=            96.7584879625D0
	rhoarr( 66)=            89.1115875927D0
	rhoarr( 67)=            81.2345694883D0
	rhoarr( 68)=            73.3229844860D0
	rhoarr( 69)=            65.5705443857D0
	rhoarr( 70)=            58.1471518350D0
	rhoarr( 71)=            51.1859664630D0
	rhoarr( 72)=            44.7786040730D0
	rhoarr( 73)=            38.9766284335D0
	rhoarr( 74)=            33.7971388068D0
	rhoarr( 75)=            29.2303617833D0
	rhoarr( 76)=            25.2475520113D0
	rhoarr( 77)=            21.8080299063D0
	rhoarr( 78)=            18.8647126461D0
	rhoarr( 79)=            16.3679516471D0
	rhoarr( 80)=            14.2678361851D0
	rhoarr( 81)=            12.5153432020D0
	rhoarr( 82)=            11.0628062919D0
	rhoarr( 83)=             9.8641534295D0
	rhoarr( 84)=             8.8752481894D0
	rhoarr( 85)=             8.0545018018D0
	rhoarr( 86)=             7.3637500179D0
	rhoarr( 87)=             6.7692530154D0
	rhoarr( 88)=             6.2426073554D0
	rhoarr( 89)=             5.7613635085D0
	rhoarr( 90)=             5.3092066358D0
	rhoarr( 91)=             4.8756542310D0
	rhoarr( 92)=             4.4553208248D0
	rhoarr( 93)=             4.0468726404D0
	rhoarr( 94)=             3.6518312619D0
	rhoarr( 95)=             3.2733848015D0
	rhoarr( 96)=             2.9153364451D0
	rhoarr( 97)=             2.5812762354D0
	rhoarr( 98)=             2.2740145927D0
	rhoarr( 99)=             1.9952742908D0
	rhoarr(100)=             1.7456064468D0
	rhoarr(101)=             1.5244772837D0
	rhoarr(102)=             1.3304654448D0
	rhoarr(103)=             1.1615124694D0
	rhoarr(104)=             1.0151788708D0
	rhoarr(105)=             0.8888719147D0
	rhoarr(106)=             0.7800256407D0
	rhoarr(107)=             0.6862264542D0
	rhoarr(108)=             0.6052872221D0
	rhoarr(109)=             0.5352787459D0
	rhoarr(110)=             0.4745301089D0
	rhoarr(111)=             0.4216095145D0
	rhoarr(112)=             0.3752957808D0
	rhoarr(113)=             0.3345483697D0
	rhoarr(114)=             0.2984812018D0
	rhoarr(115)=             0.2663428621D0
	rhoarr(116)=             0.2375033812D0
	rhoarr(117)=             0.2114458683D0
	rhoarr(118)=             0.1877601443D0
	rhoarr(119)=             0.1661353576D0
	rhoarr(120)=             0.1463493199D0
	rhoarr(121)=             0.1282536803D0
	rhoarr(122)=             0.1117556055D0
	rhoarr(123)=             0.0967978539D0
	rhoarr(124)=             0.0833396923D0
	rhoarr(125)=             0.0713409248D0
	rhoarr(126)=             0.0607505469D0
	rhoarr(127)=             0.0515005407D0
	rhoarr(128)=             0.0435043986D0
	rhoarr(129)=             0.0366593330D0
	rhoarr(130)=             0.0308508659D0
	rhoarr(131)=             0.0259585244D0
	rhoarr(132)=             0.0218615873D0
	rhoarr(133)=             0.0184441254D0
	rhoarr(134)=             0.0155988736D0
	rhoarr(135)=             0.0132297452D0
	rhoarr(136)=             0.0112530260D0
	rhoarr(137)=             0.0095974511D0
	rhoarr(138)=             0.0082034748D0
	rhoarr(139)=             0.0070220676D0
	rhoarr(140)=             0.0060133387D0
	rhoarr(141)=             0.0051451977D0
	rhoarr(142)=             0.0043921651D0
	rhoarr(143)=             0.0037343522D0
	rhoarr(144)=             0.0031565679D0
	rhoarr(145)=             0.0026474980D0
	rhoarr(146)=             0.0021989154D0
	rhoarr(147)=             0.0018049155D0
	rhoarr(148)=             0.0014611966D0
	rhoarr(149)=             0.0011644156D0
	rhoarr(150)=             0.0009116483D0
	rhoarr(151)=             0.0006999711D0
	rhoarr(152)=             0.0005261769D0
	rhoarr(153)=             0.0003866364D0
	rhoarr(154)=             0.0002773022D0
	rhoarr(155)=             0.0001938396D0
	rhoarr(156)=             0.0001318415D0
	rhoarr(157)=             0.0000870715D0
	rhoarr(158)=             0.0000556772D0
	rhoarr(159)=             0.0000343349D0
	rhoarr(160)=             0.0000203104D0
	rhoarr(161)=             0.0000114452D0
	rhoarr(162)=             0.0000060937D0
	rhoarr(163)=             0.0000030384D0
	rhoarr(164)=             0.0000014071D0
	rhoarr(165)=             0.0000006017D0
	rhoarr(166)=             0.0000002372D0
	rhoarr(167)=             0.0000000865D0
	rhoarr(168)=             0.0000000295D0

else if (iele==90) then  !Th, 6d2 7s2, 0 3, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      18945457.4634010457D0
	rhoarr(  2)=       7956830.6217889413D0
	rhoarr(  3)=       4388376.7331558224D0
	rhoarr(  4)=       2726829.7648716159D0
	rhoarr(  5)=       1791972.2888516530D0
	rhoarr(  6)=       1218894.4888122573D0
	rhoarr(  7)=        842753.6570670255D0
	rhoarr(  8)=        587247.3965894957D0
	rhoarr(  9)=        409203.0133479761D0
	rhoarr( 10)=        284821.0652840818D0
	rhoarr( 11)=        198153.1923368726D0
	rhoarr( 12)=        137947.6968745067D0
	rhoarr( 13)=         96395.0414270613D0
	rhoarr( 14)=         68023.1605242242D0
	rhoarr( 15)=         48945.4133329577D0
	rhoarr( 16)=         36332.9990247718D0
	rhoarr( 17)=         28097.5602998852D0
	rhoarr( 18)=         22726.0749704760D0
	rhoarr( 19)=         19150.6255590649D0
	rhoarr( 20)=         16642.7735148538D0
	rhoarr( 21)=         14731.3443960418D0
	rhoarr( 22)=         13131.2093079680D0
	rhoarr( 23)=         11684.2208282635D0
	rhoarr( 24)=         10316.0030401763D0
	rhoarr( 25)=          9005.4127821017D0
	rhoarr( 26)=          7761.6195972614D0
	rhoarr( 27)=          6606.5965436401D0
	rhoarr( 28)=          5563.0346250769D0
	rhoarr( 29)=          4647.6056151377D0
	rhoarr( 30)=          3868.4081273386D0
	rhoarr( 31)=          3224.8868995863D0
	rhoarr( 32)=          2708.9059774666D0
	rhoarr( 33)=          2306.3910671016D0
	rhoarr( 34)=          1999.3720393984D0
	rhoarr( 35)=          1768.2287633377D0
	rhoarr( 36)=          1593.7810727460D0
	rhoarr( 37)=          1458.8648836919D0
	rhoarr( 38)=          1349.2341496237D0
	rhoarr( 39)=          1253.8652948829D0
	rhoarr( 40)=          1164.8686479044D0
	rhoarr( 41)=          1077.1994886696D0
	rhoarr( 42)=           988.2747069543D0
	rhoarr( 43)=           897.5230105528D0
	rhoarr( 44)=           805.8708147083D0
	rhoarr( 45)=           715.1857027279D0
	rhoarr( 46)=           627.7311533525D0
	rhoarr( 47)=           545.7001189647D0
	rhoarr( 48)=           470.8811666253D0
	rhoarr( 49)=           404.4781294813D0
	rhoarr( 50)=           347.0690274953D0
	rhoarr( 51)=           298.6658185783D0
	rhoarr( 52)=           258.8286783401D0
	rhoarr( 53)=           226.7947604678D0
	rhoarr( 54)=           201.5954204974D0
	rhoarr( 55)=           182.1509543965D0
	rhoarr( 56)=           167.3432853217D0
	rhoarr( 57)=           156.0727721273D0
	rhoarr( 58)=           147.3058042433D0
	rhoarr( 59)=           140.1169190362D0
	rhoarr( 60)=           133.7251577440D0
	rhoarr( 61)=           127.5213059413D0
	rhoarr( 62)=           121.0817457126D0
	rhoarr( 63)=           114.1660129282D0
	rhoarr( 64)=           106.6980266712D0
	rhoarr( 65)=            98.7341129083D0
	rhoarr( 66)=            90.4232557578D0
	rhoarr( 67)=            81.9658479043D0
	rhoarr( 68)=            73.5765553464D0
	rhoarr( 69)=            65.4552039133D0
	rhoarr( 70)=            57.7674754253D0
	rhoarr( 71)=            50.6352524945D0
	rhoarr( 72)=            44.1350451588D0
	rhoarr( 73)=            38.3021968940D0
	rhoarr( 74)=            33.1384349248D0
	rhoarr( 75)=            28.6206272684D0
	rhoarr( 76)=            24.7091411431D0
	rhoarr( 77)=            21.3548001680D0
	rhoarr( 78)=            18.5039988808D0
	rhoarr( 79)=            16.1019878588D0
	rhoarr( 80)=            14.0946600138D0
	rhoarr( 81)=            12.4293384721D0
	rhoarr( 82)=            11.0550949991D0
	rhoarr( 83)=             9.9230378865D0
	rhoarr( 84)=             8.9868390419D0
	rhoarr( 85)=             8.2035729715D0
	rhoarr( 86)=             7.5347674789D0
	rhoarr( 87)=             6.9474568407D0
	rhoarr( 88)=             6.4150003420D0
	rhoarr( 89)=             5.9174752164D0
	rhoarr( 90)=             5.4415474214D0
	rhoarr( 91)=             4.9798325780D0
	rhoarr( 92)=             4.5298524046D0
	rhoarr( 93)=             4.0927497345D0
	rhoarr( 94)=             3.6719418667D0
	rhoarr( 95)=             3.2718730771D0
	rhoarr( 96)=             2.8969846784D0
	rhoarr( 97)=             2.5509686914D0
	rhoarr( 98)=             2.2363205076D0
	rhoarr( 99)=             1.9541646840D0
	rhoarr(100)=             1.7043001439D0
	rhoarr(101)=             1.4853973525D0
	rhoarr(102)=             1.2952790104D0
	rhoarr(103)=             1.1312244853D0
	rhoarr(104)=             0.9902528494D0
	rhoarr(105)=             0.8693561860D0
	rhoarr(106)=             0.7656705411D0
	rhoarr(107)=             0.6765843593D0
	rhoarr(108)=             0.5997925308D0
	rhoarr(109)=             0.5333084421D0
	rhoarr(110)=             0.4754475132D0
	rhoarr(111)=             0.4247946813D0
	rhoarr(112)=             0.3801660836D0
	rhoarr(113)=             0.3405724350D0
	rhoarr(114)=             0.3051886668D0
	rhoarr(115)=             0.2733315524D0
	rhoarr(116)=             0.2444445636D0
	rhoarr(117)=             0.2180874113D0
	rhoarr(118)=             0.1939269010D0
	rhoarr(119)=             0.1717259936D0
	rhoarr(120)=             0.1513291424D0
	rhoarr(121)=             0.1326436573D0
	rhoarr(122)=             0.1156184639D0
	rhoarr(123)=             0.1002226950D0
	rhoarr(124)=             0.0864267987D0
	rhoarr(125)=             0.0741883216D0
	rhoarr(126)=             0.0634434853D0
	rhoarr(127)=             0.0541045293D0
	rhoarr(128)=             0.0460618568D0
	rhoarr(129)=             0.0391894905D0
	rhoarr(130)=             0.0333522322D0
	rhoarr(131)=             0.0284131124D0
	rhoarr(132)=             0.0242400732D0
	rhoarr(133)=             0.0207112187D0
	rhoarr(134)=             0.0177183253D0
	rhoarr(135)=             0.0151685949D0
	rhoarr(136)=             0.0129848474D0
	rhoarr(137)=             0.0111044955D0
	rhoarr(138)=             0.0094777136D0
	rhoarr(139)=             0.0080652156D0
	rhoarr(140)=             0.0068360046D0
	rhoarr(141)=             0.0057653618D0
	rhoarr(142)=             0.0048332218D0
	rhoarr(143)=             0.0040229717D0
	rhoarr(144)=             0.0033206215D0
	rhoarr(145)=             0.0027142461D0
	rhoarr(146)=             0.0021935955D0
	rhoarr(147)=             0.0017497867D0
	rhoarr(148)=             0.0013750270D0
	rhoarr(149)=             0.0010623419D0
	rhoarr(150)=             0.0008053046D0
	rhoarr(151)=             0.0005977848D0
	rhoarr(152)=             0.0004337520D0
	rhoarr(153)=             0.0003071750D0
	rhoarr(154)=             0.0002120480D0
	rhoarr(155)=             0.0001425356D0
	rhoarr(156)=             0.0000931907D0
	rhoarr(157)=             0.0000591726D0
	rhoarr(158)=             0.0000364006D0
	rhoarr(159)=             0.0000216090D0
	rhoarr(160)=             0.0000123064D0
	rhoarr(161)=             0.0000066689D0
	rhoarr(162)=             0.0000034037D0
	rhoarr(163)=             0.0000016174D0
	rhoarr(164)=             0.0000007075D0
	rhoarr(165)=             0.0000002825D0
	rhoarr(166)=             0.0000001026D0
	rhoarr(167)=             0.0000000340D0
	rhoarr(168)=             0.0000000105D0
	
else if (iele==91) then  !Pa, 5f2 6d1 7s2, 0 4, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      20792258.4507628754D0
	rhoarr(  2)=       8584838.9872344974D0
	rhoarr(  3)=       4685229.7138542719D0
	rhoarr(  4)=       2888555.3601064668D0
	rhoarr(  5)=       1886020.5386408661D0
	rhoarr(  6)=       1274842.0778236892D0
	rhoarr(  7)=        876340.4223937137D0
	rhoarr(  8)=        607128.9940339767D0
	rhoarr(  9)=        420643.2767245174D0
	rhoarr( 10)=        291205.0118659366D0
	rhoarr( 11)=        201597.4190505588D0
	rhoarr( 12)=        139745.7185149262D0
	rhoarr( 13)=         97327.9007284535D0
	rhoarr( 14)=         68551.6868958524D0
	rhoarr( 15)=         49330.4832067666D0
	rhoarr( 16)=         36704.5335581358D0
	rhoarr( 17)=         28503.5568759102D0
	rhoarr( 18)=         23168.3740110598D0
	rhoarr( 19)=         19608.6210259403D0
	rhoarr( 20)=         17089.2803620871D0
	rhoarr( 21)=         15141.9728584405D0
	rhoarr( 22)=         13488.4093579175D0
	rhoarr( 23)=         11978.2969087275D0
	rhoarr( 24)=         10544.7600735968D0
	rhoarr( 25)=          9172.9740829302D0
	rhoarr( 26)=          7876.6191249998D0
	rhoarr( 27)=          6680.1164309061D0
	rhoarr( 28)=          5606.7457398399D0
	rhoarr( 29)=          4672.3963727222D0
	rhoarr( 30)=          3883.5251664430D0
	rhoarr( 31)=          3237.4693210747D0
	rhoarr( 32)=          2723.8108436141D0
	rhoarr( 33)=          2326.2734014715D0
	rhoarr( 34)=          2024.9952762910D0
	rhoarr( 35)=          1798.9371836642D0
	rhoarr( 36)=          1628.0245466429D0
	rhoarr( 37)=          1494.6727546982D0
	rhoarr( 38)=          1384.5822910737D0
	rhoarr( 39)=          1286.9317632135D0
	rhoarr( 40)=          1194.2005406276D0
	rhoarr( 41)=          1101.8132510578D0
	rhoarr( 42)=          1007.6989505348D0
	rhoarr( 43)=           911.7836132544D0
	rhoarr( 44)=           815.4201044003D0
	rhoarr( 45)=           720.7876818541D0
	rhoarr( 46)=           630.3248177981D0
	rhoarr( 47)=           546.2664530991D0
	rhoarr( 48)=           470.3348416029D0
	rhoarr( 49)=           403.5951146959D0
	rhoarr( 50)=           346.4507338661D0
	rhoarr( 51)=           298.7326693134D0
	rhoarr( 52)=           259.8327072633D0
	rhoarr( 53)=           228.8415205437D0
	rhoarr( 54)=           204.6685276390D0
	rhoarr( 55)=           186.1361707648D0
	rhoarr( 56)=           172.0517990485D0
	rhoarr( 57)=           161.2646120981D0
	rhoarr( 58)=           152.7141695267D0
	rhoarr( 59)=           145.4731089194D0
	rhoarr( 60)=           138.7824807791D0
	rhoarr( 61)=           132.0754889802D0
	rhoarr( 62)=           124.9853437133D0
	rhoarr( 63)=           117.3351469736D0
	rhoarr( 64)=           109.1111361932D0
	rhoarr( 65)=           100.4238292549D0
	rhoarr( 66)=            91.4635636696D0
	rhoarr( 67)=            82.4571606349D0
	rhoarr( 68)=            73.6311750115D0
	rhoarr( 69)=            65.1850337291D0
	rhoarr( 70)=            57.2750373633D0
	rhoarr( 71)=            50.0082715838D0
	rhoarr( 72)=            43.4442457877D0
	rhoarr( 73)=            37.6015818526D0
	rhoarr( 74)=            32.4671751313D0
	rhoarr( 75)=            28.0057274100D0
	rhoarr( 76)=            24.1682001927D0
	rhoarr( 77)=            20.8983989419D0
	rhoarr( 78)=            18.1374747495D0
	rhoarr( 79)=            15.8265648033D0
	rhoarr( 80)=            13.9080629182D0
	rhoarr( 81)=            12.3261141063D0
	rhoarr( 82)=            11.0268805762D0
	rhoarr( 83)=             9.9589690244D0
	rhoarr( 84)=             9.0741952923D0
	rhoarr( 85)=             8.3286527699D0
	rhoarr( 86)=             7.6838966272D0
	rhoarr( 87)=             7.1079866113D0
	rhoarr( 88)=             6.5761491161D0
	rhoarr( 89)=             6.0709032632D0
	rhoarr( 90)=             5.5816113048D0
	rhoarr( 91)=             5.1035253600D0
	rhoarr( 92)=             4.6364839528D0
	rhoarr( 93)=             4.1834504841D0
	rhoarr( 94)=             3.7490824157D0
	rhoarr( 95)=             3.3384846235D0
	rhoarr( 96)=             2.9562471458D0
	rhoarr( 97)=             2.6058100416D0
	rhoarr( 98)=             2.2891468554D0
	rhoarr( 99)=             2.0067198019D0
	rhoarr(100)=             1.7576370295D0
	rhoarr(101)=             1.5399348651D0
	rhoarr(102)=             1.3509131900D0
	rhoarr(103)=             1.1874660663D0
	rhoarr(104)=             1.0463679285D0
	rhoarr(105)=             0.9244940148D0
	rhoarr(106)=             0.8189692519D0
	rhoarr(107)=             0.7272509756D0
	rhoarr(108)=             0.6471574492D0
	rhoarr(109)=             0.5768568552D0
	rhoarr(110)=             0.5148314045D0
	rhoarr(111)=             0.4598295100D0
	rhoarr(112)=             0.4108163732D0
	rhoarr(113)=             0.3669302948D0
	rhoarr(114)=             0.3274488207D0
	rhoarr(115)=             0.2917657414D0
	rhoarr(116)=             0.2593773357D0
	rhoarr(117)=             0.2298744768D0
	rhoarr(118)=             0.2029365843D0
	rhoarr(119)=             0.1783239441D0
	rhoarr(120)=             0.1558663361D0
	rhoarr(121)=             0.1354477028D0
	rhoarr(122)=             0.1169881712D0
	rhoarr(123)=             0.1004256857D0
	rhoarr(124)=             0.0856996603D0
	rhoarr(125)=             0.0727385360D0
	rhoarr(126)=             0.0614522359D0
	rhoarr(127)=             0.0517295670D0
	rhoarr(128)=             0.0434398788D0
	rhoarr(129)=             0.0364378352D0
	rhoarr(130)=             0.0305699970D0
	rhoarr(131)=             0.0256819677D0
	rhoarr(132)=             0.0216250587D0
	rhoarr(133)=             0.0182617181D0
	rhoarr(134)=             0.0154692965D0
	rhoarr(135)=             0.0131420409D0
	rhoarr(136)=             0.0111914662D0
	rhoarr(137)=             0.0095454327D0
	rhoarr(138)=             0.0081463426D0
	rhoarr(139)=             0.0069488745D0
	rhoarr(140)=             0.0059176268D0
	rhoarr(141)=             0.0050249542D0
	rhoarr(142)=             0.0042491698D0
	rhoarr(143)=             0.0035731673D0
	rhoarr(144)=             0.0029834162D0
	rhoarr(145)=             0.0024692256D0
	rhoarr(146)=             0.0020221610D0
	rhoarr(147)=             0.0016355310D0
	rhoarr(148)=             0.0013039053D0
	rhoarr(149)=             0.0010226620D0
	rhoarr(150)=             0.0007875831D0
	rhoarr(151)=             0.0005945256D0
	rhoarr(152)=             0.0004391975D0
	rhoarr(153)=             0.0003170645D0
	rhoarr(154)=             0.0002233933D0
	rhoarr(155)=             0.0001534098D0
	rhoarr(156)=             0.0001025198D0
	rhoarr(157)=             0.0000665266D0
	rhoarr(158)=             0.0000417904D0
	rhoarr(159)=             0.0000253033D0
	rhoarr(160)=             0.0000146824D0
	rhoarr(161)=             0.0000081065D0
	rhoarr(162)=             0.0000042243D0
	rhoarr(163)=             0.0000020604D0
	rhoarr(164)=             0.0000009341D0
	rhoarr(165)=             0.0000003919D0
	rhoarr(166)=             0.0000001523D0
	rhoarr(167)=             0.0000000550D0
	rhoarr(168)=             0.0000000187D0

else if (iele==92) then  !U, 5f3 6d1 7s2, 0 5, ROHF/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=      22697106.8382204026D0
	rhoarr(  2)=       9219552.0323071163D0
	rhoarr(  3)=       4982478.7812475925D0
	rhoarr(  4)=       3050045.8652641596D0
	rhoarr(  5)=       1980193.6893494041D0
	rhoarr(  6)=       1331088.5586503276D0
	rhoarr(  7)=        910270.9177903907D0
	rhoarr(  8)=        627261.9673197014D0
	rhoarr(  9)=        432221.2096030193D0
	rhoarr( 10)=        297645.0830392523D0
	rhoarr( 11)=        205056.9512930299D0
	rhoarr( 12)=        141545.4815616812D0
	rhoarr( 13)=         98259.0434923169D0
	rhoarr( 14)=         69077.7199152990D0
	rhoarr( 15)=         49713.9703102265D0
	rhoarr( 16)=         37076.8978275842D0
	rhoarr( 17)=         28913.5347944748D0
	rhoarr( 18)=         23617.3310132646D0
	rhoarr( 19)=         20074.7014669309D0
	rhoarr( 20)=         17543.9902549173D0
	rhoarr( 21)=         15559.8975088016D0
	rhoarr( 22)=         13851.3349724041D0
	rhoarr( 23)=         12276.2445477679D0
	rhoarr( 24)=         10775.6014573215D0
	rhoarr( 25)=          9341.1456187514D0
	rhoarr( 26)=          7991.1782039162D0
	rhoarr( 27)=          6752.5730076886D0
	rhoarr( 28)=          5649.1504620859D0
	rhoarr( 29)=          4695.9503714651D0
	rhoarr( 30)=          3897.7068017160D0
	rhoarr( 31)=          3249.5527588913D0
	rhoarr( 32)=          2738.6866577583D0
	rhoarr( 33)=          2346.5448614852D0
	rhoarr( 34)=          2051.3212828201D0
	rhoarr( 35)=          1830.5383019796D0
	rhoarr( 36)=          1663.2306415377D0
	rhoarr( 37)=          1531.4075893745D0
	rhoarr( 38)=          1420.7349714195D0
	rhoarr( 39)=          1320.6163751254D0
	rhoarr( 40)=          1223.9279969833D0
	rhoarr( 41)=          1126.5948907589D0
	rhoarr( 42)=          1027.0875448027D0
	rhoarr( 43)=           925.8505448990D0
	rhoarr( 44)=           824.6727178166D0
	rhoarr( 45)=           726.0427286758D0
	rhoarr( 46)=           632.5635767924D0
	rhoarr( 47)=           546.4986555955D0
	rhoarr( 48)=           469.4917699646D0
	rhoarr( 49)=           402.4610281117D0
	rhoarr( 50)=           345.6309687383D0
	rhoarr( 51)=           298.6497505915D0
	rhoarr( 52)=           260.7395972911D0
	rhoarr( 53)=           230.8427515481D0
	rhoarr( 54)=           207.7434988795D0
	rhoarr( 55)=           190.1624744546D0
	rhoarr( 56)=           176.8288350474D0
	rhoarr( 57)=           166.5385150635D0
	rhoarr( 58)=           158.2044331091D0
	rhoarr( 59)=           150.8999089908D0
	rhoarr( 60)=           143.8923691629D0
	rhoarr( 61)=           136.6624946691D0
	rhoarr( 62)=           128.9048640831D0
	rhoarr( 63)=           120.5092043768D0
	rhoarr( 64)=           111.5251770428D0
	rhoarr( 65)=           102.1167231802D0
	rhoarr( 66)=            92.5134088022D0
	rhoarr( 67)=            82.9657470508D0
	rhoarr( 68)=            73.7095749427D0
	rhoarr( 69)=            64.9420068663D0
	rhoarr( 70)=            56.8090392522D0
	rhoarr( 71)=            49.4030592257D0
	rhoarr( 72)=            42.7675159398D0
	rhoarr( 73)=            36.9057856774D0
	rhoarr( 74)=            31.7915920670D0
	rhoarr( 75)=            27.3789859134D0
	rhoarr( 76)=            23.6106359746D0
	rhoarr( 77)=            20.4238859508D0
	rhoarr( 78)=            17.7546056816D0
	rhoarr( 79)=            15.5392603141D0
	rhoarr( 80)=            13.7158242579D0
	rhoarr( 81)=            12.2241868683D0
	rhoarr( 82)=            11.0065688231D0
	rhoarr( 83)=            10.0082487712D0
	rhoarr( 84)=             9.1786572471D0
	rhoarr( 85)=             8.4726928940D0
	rhoarr( 86)=             7.8519984059D0
	rhoarr( 87)=             7.2859146760D0
	rhoarr( 88)=             6.7518972576D0
	rhoarr( 89)=             6.2352959038D0
	rhoarr( 90)=             5.7285261093D0
	rhoarr( 91)=             5.2297677232D0
	rhoarr( 92)=             4.7413896786D0
	rhoarr( 93)=             4.2683164631D0
	rhoarr( 94)=             3.8165278886D0
	rhoarr( 95)=             3.3918325426D0
	rhoarr( 96)=             2.9989923051D0
	rhoarr( 97)=             2.6412138235D0
	rhoarr( 98)=             2.3199724237D0
	rhoarr( 99)=             2.0350999313D0
	rhoarr(100)=             1.7850516837D0
	rhoarr(101)=             1.5672678947D0
	rhoarr(102)=             1.3785564886D0
	rhoarr(103)=             1.2154434987D0
	rhoarr(104)=             1.0744581017D0
	rhoarr(105)=             0.9523383874D0
	rhoarr(106)=             0.8461586281D0
	rhoarr(107)=             0.7533883633D0
	rhoarr(108)=             0.6718985105D0
	rhoarr(109)=             0.5999310802D0
	rhoarr(110)=             0.5360481323D0
	rhoarr(111)=             0.4790733121D0
	rhoarr(112)=             0.4280362433D0
	rhoarr(113)=             0.3821265786D0
	rhoarr(114)=             0.3406608942D0
	rhoarr(115)=             0.3030622430D0
	rhoarr(116)=             0.2688495060D0
	rhoarr(117)=             0.2376321385D0
	rhoarr(118)=             0.2091057032D0
	rhoarr(119)=             0.1830446101D0
	rhoarr(120)=             0.1592902894D0
	rhoarr(121)=             0.1377349938D0
	rhoarr(122)=             0.1183029864D0
	rhoarr(123)=             0.1009316555D0
	rhoarr(124)=             0.0855550746D0
	rhoarr(125)=             0.0720918767D0
	rhoarr(126)=             0.0604383705D0
	rhoarr(127)=             0.0504668813D0
	rhoarr(128)=             0.0420285496D0
	rhoarr(129)=             0.0349593442D0
	rhoarr(130)=             0.0290878447D0
	rhoarr(131)=             0.0242433878D0
	rhoarr(132)=             0.0202634035D0
	rhoarr(133)=             0.0169991274D0
	rhoarr(134)=             0.0143192898D0
	rhoarr(135)=             0.0121117657D0
	rhoarr(136)=             0.0102834606D0
	rhoarr(137)=             0.0087588752D0
	rhoarr(138)=             0.0074778507D0
	rhoarr(139)=             0.0063929693D0
	rhoarr(140)=             0.0054670082D0
	rhoarr(141)=             0.0046707248D0
	rhoarr(142)=             0.0039811137D0
	rhoarr(143)=             0.0033801329D0
	rhoarr(144)=             0.0028537937D0
	rhoarr(145)=             0.0023914632D0
	rhoarr(146)=             0.0019852481D0
	rhoarr(147)=             0.0016293861D0
	rhoarr(148)=             0.0013196372D0
	rhoarr(149)=             0.0010527025D0
	rhoarr(150)=             0.0008257134D0
	rhoarr(151)=             0.0006358296D0
	rhoarr(152)=             0.0004799722D0
	rhoarr(153)=             0.0003547096D0
	rhoarr(154)=             0.0002562873D0
	rhoarr(155)=             0.0001807701D0
	rhoarr(156)=             0.0001242425D0
	rhoarr(157)=             0.0000830084D0
	rhoarr(158)=             0.0000537448D0
	rhoarr(159)=             0.0000335901D0
	rhoarr(160)=             0.0000201693D0
	rhoarr(161)=             0.0000115731D0
	rhoarr(162)=             0.0000063107D0
	rhoarr(163)=             0.0000032537D0
	rhoarr(164)=             0.0000015800D0
	rhoarr(165)=             0.0000007212D0
	rhoarr(166)=             0.0000003093D0
	rhoarr(167)=             0.0000001247D0
	rhoarr(168)=             0.0000000471D0
	rhoarr(169)=             0.0000000165D0

else if (iele==93) then  !Np, 5f4 6d1 7s2, 0 6, ROHF/SARC-DKH int=dkh2
	npt=  169
	rhoarr(  1)=      24918644.0640649460D0
	rhoarr(  2)=       9947737.3053524997D0
	rhoarr(  3)=       5318131.9983776864D0
	rhoarr(  4)=       3229307.7923887176D0
	rhoarr(  5)=       2082840.2277122976D0
	rhoarr(  6)=       1391162.2884898318D0
	rhoarr(  7)=        945744.6851355365D0
	rhoarr(  8)=        647849.3234441172D0
	rhoarr(  9)=        443801.4664188258D0
	rhoarr( 10)=        303946.8804254776D0
	rhoarr( 11)=        208366.2119617253D0
	rhoarr( 12)=        143228.9473267855D0
	rhoarr( 13)=         99121.1004243764D0
	rhoarr( 14)=         69580.7541842968D0
	rhoarr( 15)=         50110.4812342416D0
	rhoarr( 16)=         37484.0566399783D0
	rhoarr( 17)=         29366.6064369934D0
	rhoarr( 18)=         24107.5639415556D0
	rhoarr( 19)=         20574.1246378204D0
	rhoarr( 20)=         18021.5187370214D0
	rhoarr( 21)=         15990.0341643194D0
	rhoarr( 22)=         14217.3130092794D0
	rhoarr( 23)=         12570.3450813452D0
	rhoarr( 24)=         10998.2508035180D0
	rhoarr( 25)=          9499.2247999468D0
	rhoarr( 26)=          8095.7822484440D0
	rhoarr( 27)=          6816.6785195938D0
	rhoarr( 28)=          5685.6711299674D0
	rhoarr( 29)=          4716.4056414973D0
	rhoarr( 30)=          3911.4511287255D0
	rhoarr( 31)=          3263.4128898200D0
	rhoarr( 32)=          2756.9090211829D0
	rhoarr( 33)=          2371.0193749134D0
	rhoarr( 34)=          2082.0363871470D0
	rhoarr( 35)=          1866.1660128884D0
	rhoarr( 36)=          1701.7127996462D0
	rhoarr( 37)=          1570.4449721678D0
	rhoarr( 38)=          1458.1426180119D0
	rhoarr( 39)=          1354.5583427901D0
	rhoarr( 40)=          1253.0614114943D0
	rhoarr( 41)=          1150.1437840959D0
	rhoarr( 42)=          1044.8519850864D0
	rhoarr( 43)=           938.1514887082D0
	rhoarr( 44)=           832.2403967619D0
	rhoarr( 45)=           729.8687634012D0
	rhoarr( 46)=           633.7450640420D0
	rhoarr( 47)=           546.1013711132D0
	rhoarr( 48)=           468.4505122607D0
	rhoarr( 49)=           401.5227449855D0
	rhoarr( 50)=           345.3356514060D0
	rhoarr( 51)=           299.3381107960D0
	rhoarr( 52)=           262.5756371527D0
	rhoarr( 53)=           233.8420074497D0
	rhoarr( 54)=           211.8018244128D0
	rhoarr( 55)=           195.0838592113D0
	rhoarr( 56)=           182.3528630280D0
	rhoarr( 57)=           172.3684247954D0
	rhoarr( 58)=           164.0357851503D0
	rhoarr( 59)=           156.4483908576D0
	rhoarr( 60)=           148.9181033027D0
	rhoarr( 61)=           140.9879348229D0
	rhoarr( 62)=           132.4241103294D0
	rhoarr( 63)=           123.1880531153D0
	rhoarr( 64)=           113.3929130053D0
	rhoarr( 65)=           103.2520144607D0
	rhoarr( 66)=            93.0273372789D0
	rhoarr( 67)=            82.9849281524D0
	rhoarr( 68)=            73.3616618042D0
	rhoarr( 69)=            64.3449247843D0
	rhoarr( 70)=            56.0643443725D0
	rhoarr( 71)=            48.5930616119D0
	rhoarr( 72)=            41.9553396471D0
	rhoarr( 73)=            36.1373515017D0
	rhoarr( 74)=            31.0985428381D0
	rhoarr( 75)=            26.7817538367D0
	rhoarr( 76)=            23.1211068643D0
	rhoarr( 77)=            20.0473892570D0
	rhoarr( 78)=            17.4912063811D0
	rhoarr( 79)=            15.3845133493D0
	rhoarr( 80)=            13.6612511297D0
	rhoarr( 81)=            12.2577415644D0
	rhoarr( 82)=            11.1132911095D0
	rhoarr( 83)=            10.1711885966D0
	rhoarr( 84)=             9.3800336877D0
	rhoarr( 85)=             8.6951591983D0
	rhoarr( 86)=             8.0798416116D0
	rhoarr( 87)=             7.5060266156D0
	rhoarr( 88)=             6.9544014819D0
	rhoarr( 89)=             6.4137823655D0
	rhoarr( 90)=             5.8799125311D0
	rhoarr( 91)=             5.3538589256D0
	rhoarr( 92)=             4.8402367182D0
	rhoarr( 93)=             4.3454858627D0
	rhoarr( 94)=             3.8763815272D0
	rhoarr( 95)=             3.4388968520D0
	rhoarr( 96)=             3.0374673912D0
	rhoarr( 97)=             2.6746443455D0
	rhoarr( 98)=             2.3510767500D0
	rhoarr( 99)=             2.0657351479D0
	rhoarr(100)=             1.8162808828D0
	rhoarr(101)=             1.5994926882D0
	rhoarr(102)=             1.4116804463D0
	rhoarr(103)=             1.2490389456D0
	rhoarr(104)=             1.1079170605D0
	rhoarr(105)=             0.9849964883D0
	rhoarr(106)=             0.8773873917D0
	rhoarr(107)=             0.7826560190D0
	rhoarr(108)=             0.6988026150D0
	rhoarr(109)=             0.6242080334D0
	rhoarr(110)=             0.5575656027D0
	rhoarr(111)=             0.4978117828D0
	rhoarr(112)=             0.4440654441D0
	rhoarr(113)=             0.3955815427D0
	rhoarr(114)=             0.3517209107D0
	rhoarr(115)=             0.3119343376D0
	rhoarr(116)=             0.2757566001D0
	rhoarr(117)=             0.2428049898D0
	rhoarr(118)=             0.2127772734D0
	rhoarr(119)=             0.1854455741D0
	rhoarr(120)=             0.1606448151D0
	rhoarr(121)=             0.1382564358D0
	rhoarr(122)=             0.1181895539D0
	rhoarr(123)=             0.1003623540D0
	rhoarr(124)=             0.0846862890D0
	rhoarr(125)=             0.0710549313D0
	rhoarr(126)=             0.0593383191D0
	rhoarr(127)=             0.0493826794D0
	rhoarr(128)=             0.0410146239D0
	rhoarr(129)=             0.0340484148D0
	rhoarr(130)=             0.0282946891D0
	rhoarr(131)=             0.0235691091D0
	rhoarr(132)=             0.0196997273D0
	rhoarr(133)=             0.0165323052D0
	rhoarr(134)=             0.0139333151D0
	rhoarr(135)=             0.0117907605D0
	rhoarr(136)=             0.0100132250D0
	rhoarr(137)=             0.0085276901D0
	rhoarr(138)=             0.0072766810D0
	rhoarr(139)=             0.0062152479D0
	rhoarr(140)=             0.0053081852D0
	rhoarr(141)=             0.0045277485D0
	rhoarr(142)=             0.0038519629D0
	rhoarr(143)=             0.0032634629D0
	rhoarr(144)=             0.0027486990D0
	rhoarr(145)=             0.0022973262D0
	rhoarr(146)=             0.0019016339D0
	rhoarr(147)=             0.0015559549D0
	rhoarr(148)=             0.0012560625D0
	rhoarr(149)=             0.0009985973D0
	rhoarr(150)=             0.0007805719D0
	rhoarr(151)=             0.0005989931D0
	rhoarr(152)=             0.0004506269D0
	rhoarr(153)=             0.0003319168D0
	rhoarr(154)=             0.0002390395D0
	rhoarr(155)=             0.0001680595D0
	rhoarr(156)=             0.0001151252D0
	rhoarr(157)=             0.0000766502D0
	rhoarr(158)=             0.0000494441D0
	rhoarr(159)=             0.0000307798D0
	rhoarr(160)=             0.0000184054D0
	rhoarr(161)=             0.0000105174D0
	rhoarr(162)=             0.0000057130D0
	rhoarr(163)=             0.0000029359D0
	rhoarr(164)=             0.0000014223D0
	rhoarr(165)=             0.0000006482D0
	rhoarr(166)=             0.0000002778D0
	rhoarr(167)=             0.0000001119D0
	rhoarr(168)=             0.0000000421D0
	rhoarr(169)=             0.0000000147D0

else if (iele==94) then  !Pu, 5f6 7s2, 0 7, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      27474360.0036802478D0
	rhoarr(  2)=      10770948.6514862794D0
	rhoarr(  3)=       5691921.4125073133D0
	rhoarr(  4)=       3425948.0596612464D0
	rhoarr(  5)=       2193708.9979825900D0
	rhoarr(  6)=       1454916.6333136715D0
	rhoarr(  7)=        982672.6137180110D0
	rhoarr(  8)=        668820.5070508507D0
	rhoarr(  9)=        455322.2240817882D0
	rhoarr( 10)=        310062.3382260923D0
	rhoarr( 11)=        211497.4407324773D0
	rhoarr( 12)=        144788.3562423231D0
	rhoarr( 13)=         99919.1411336306D0
	rhoarr( 14)=         70070.3043649250D0
	rhoarr( 15)=         50528.5090106450D0
	rhoarr( 16)=         37931.4084486978D0
	rhoarr( 17)=         29864.9327773897D0
	rhoarr( 18)=         24638.5399775458D0
	rhoarr( 19)=         21104.3900264208D0
	rhoarr( 20)=         18518.1521948790D0
	rhoarr( 21)=         16428.1649376381D0
	rhoarr( 22)=         14582.2231804144D0
	rhoarr( 23)=         12857.0224009498D0
	rhoarr( 24)=         11209.9432922346D0
	rhoarr( 25)=          9645.3504469342D0
	rhoarr( 26)=          8189.4208691664D0
	rhoarr( 27)=          6872.1198627413D0
	rhoarr( 28)=          5716.4847778304D0
	rhoarr( 29)=          4734.2084733730D0
	rhoarr( 30)=          3925.2691547054D0
	rhoarr( 31)=          3279.4590661113D0
	rhoarr( 32)=          2778.6718025155D0
	rhoarr( 33)=          2399.6196087488D0
	rhoarr( 34)=          2116.7903409742D0
	rhoarr( 35)=          1905.2376900659D0
	rhoarr( 36)=          1742.7237231346D0
	rhoarr( 37)=          1610.9535214479D0
	rhoarr( 38)=          1495.9718349148D0
	rhoarr( 39)=          1387.9973564235D0
	rhoarr( 40)=          1280.9753964387D0
	rhoarr( 41)=          1172.0133998814D0
	rhoarr( 42)=          1060.7478305593D0
	rhoarr( 43)=           948.6461613494D0
	rhoarr( 44)=           838.2700016148D0
	rhoarr( 45)=           732.5679380480D0
	rhoarr( 46)=           634.2855070516D0
	rhoarr( 47)=           545.5599272136D0
	rhoarr( 48)=           467.7215928236D0
	rhoarr( 49)=           401.2767208744D0
	rhoarr( 50)=           346.0147721712D0
	rhoarr( 51)=           301.1768667371D0
	rhoarr( 52)=           265.6329865608D0
	rhoarr( 53)=           238.0365717912D0
	rhoarr( 54)=           216.9456675447D0
	rhoarr( 55)=           200.9140256812D0
	rhoarr( 56)=           188.5615956182D0
	rhoarr( 57)=           178.6329313161D0
	rhoarr( 58)=           170.0472111926D0
	rhoarr( 59)=           161.9381809460D0
	rhoarr( 60)=           153.6790198999D0
	rhoarr( 61)=           144.8871147340D0
	rhoarr( 62)=           135.4066495808D0
	rhoarr( 63)=           125.2712974825D0
	rhoarr( 64)=           114.6532904412D0
	rhoarr( 65)=           103.8073640863D0
	rhoarr( 66)=            93.0180172397D0
	rhoarr( 67)=            82.5565682947D0
	rhoarr( 68)=            72.6515234812D0
	rhoarr( 69)=            63.4727666370D0
	rhoarr( 70)=            55.1277460223D0
	rhoarr( 71)=            47.6664879034D0
	rhoarr( 72)=            41.0918788891D0
	rhoarr( 73)=            35.3719916489D0
	rhoarr( 74)=            30.4519816300D0
	rhoarr( 75)=            26.2639904750D0
	rhoarr( 76)=            22.7343632555D0
	rhoarr( 77)=            19.7882012327D0
	rhoarr( 78)=            17.3517646656D0
	rhoarr( 79)=            15.3534884406D0
	rhoarr( 80)=            13.7243914037D0
	rhoarr( 81)=            12.3984972038D0
	rhoarr( 82)=            11.3136157650D0
	rhoarr( 83)=            10.4125460768D0
	rhoarr( 84)=             9.6445281580D0
	rhoarr( 85)=             8.9666420478D0
	rhoarr( 86)=             8.3448359235D0
	rhoarr( 87)=             7.7543435619D0
	rhoarr( 88)=             7.1793837304D0
	rhoarr( 89)=             6.6121768886D0
	rhoarr( 90)=             6.0514321459D0
	rhoarr( 91)=             5.5005287883D0
	rhoarr( 92)=             4.9656363882D0
	rhoarr( 93)=             4.4539922233D0
	rhoarr( 94)=             3.9724982698D0
	rhoarr( 95)=             3.5267285835D0
	rhoarr( 96)=             3.1203664092D0
	rhoarr( 97)=             2.7550304970D0
	rhoarr( 98)=             2.4304090370D0
	rhoarr( 99)=             2.1445998922D0
	rhoarr(100)=             1.8945557043D0
	rhoarr(101)=             1.6765471626D0
	rhoarr(102)=             1.4865808996D0
	rhoarr(103)=             1.3207338546D0
	rhoarr(104)=             1.1753887165D0
	rhoarr(105)=             1.0473724546D0
	rhoarr(106)=             0.9340112200D0
	rhoarr(107)=             0.8331207169D0
	rhoarr(108)=             0.7429528587D0
	rhoarr(109)=             0.6621184936D0
	rhoarr(110)=             0.5895032715D0
	rhoarr(111)=             0.5241899542D0
	rhoarr(112)=             0.4653960689D0
	rhoarr(113)=             0.4124311609D0
	rhoarr(114)=             0.3646735043D0
	rhoarr(115)=             0.3215625817D0
	rhoarr(116)=             0.2826014577D0
	rhoarr(117)=             0.2473626118D0
	rhoarr(118)=             0.2154917510D0
	rhoarr(119)=             0.1867061111D0
	rhoarr(120)=             0.1607861122D0
	rhoarr(121)=             0.1375613225D0
	rhoarr(122)=             0.1168930718D0
	rhoarr(123)=             0.0986566076D0
	rhoarr(124)=             0.0827254998D0
	rhoarr(125)=             0.0689603055D0
	rhoarr(126)=             0.0572025540D0
	rhoarr(127)=             0.0472741166D0
	rhoarr(128)=             0.0389811551D0
	rhoarr(129)=             0.0321212263D0
	rhoarr(130)=             0.0264918449D0
	rhoarr(131)=             0.0218988793D0
	rhoarr(132)=             0.0181635275D0
	rhoarr(133)=             0.0151271366D0
	rhoarr(134)=             0.0126536586D0
	rhoarr(135)=             0.0106299365D0
	rhoarr(136)=             0.0089642741D0
	rhoarr(137)=             0.0075838436D0
	rhoarr(138)=             0.0064315094D0
	rhoarr(139)=             0.0054625921D0
	rhoarr(140)=             0.0046419916D0
	rhoarr(141)=             0.0039419198D0
	rhoarr(142)=             0.0033402999D0
	rhoarr(143)=             0.0028197133D0
	rhoarr(144)=             0.0023666797D0
	rhoarr(145)=             0.0019710612D0
	rhoarr(146)=             0.0016254567D0
	rhoarr(147)=             0.0013245531D0
	rhoarr(148)=             0.0010644661D0
	rhoarr(149)=             0.0008421299D0
	rhoarr(150)=             0.0006547932D0
	rhoarr(151)=             0.0004996576D0
	rhoarr(152)=             0.0003736799D0
	rhoarr(153)=             0.0002735323D0
	rhoarr(154)=             0.0001956910D0
	rhoarr(155)=             0.0001365972D0
	rhoarr(156)=             0.0000928333D0
	rhoarr(157)=             0.0000612661D0
	rhoarr(158)=             0.0000391390D0
	rhoarr(159)=             0.0000241117D0
	rhoarr(160)=             0.0000142620D0
	rhoarr(161)=             0.0000080603D0
	rhoarr(162)=             0.0000043304D0
	rhoarr(163)=             0.0000022008D0
	rhoarr(164)=             0.0000010537D0
	rhoarr(165)=             0.0000004740D0
	rhoarr(166)=             0.0000002000D0
	rhoarr(167)=             0.0000000791D0
	rhoarr(168)=             0.0000000292D0

else if (iele==95) then  !Am, 5f7 7s2, 0 8, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      30170916.1346854232D0
	rhoarr(  2)=      11620994.8795101028D0
	rhoarr(  3)=       6073240.6851823619D0
	rhoarr(  4)=       3625202.2027043886D0
	rhoarr(  5)=       2305845.8612051676D0
	rhoarr(  6)=       1519370.0698709697D0
	rhoarr(  7)=       1020039.9453940185D0
	rhoarr(  8)=        690037.6876259786D0
	rhoarr(  9)=        466962.7879197749D0
	rhoarr( 10)=        316226.3549232922D0
	rhoarr( 11)=        214642.9847158918D0
	rhoarr( 12)=        146349.2096656030D0
	rhoarr( 13)=        100715.0452299066D0
	rhoarr( 14)=         70558.5050129976D0
	rhoarr( 15)=         50947.9929167247D0
	rhoarr( 16)=         38383.4447909342D0
	rhoarr( 17)=         30370.6053915845D0
	rhoarr( 18)=         25178.2887092825D0
	rhoarr( 19)=         21643.5198089305D0
	rhoarr( 20)=         19022.7159171206D0
	rhoarr( 21)=         16872.6292540325D0
	rhoarr( 22)=         14951.5461528470D0
	rhoarr( 23)=         13146.2084184962D0
	rhoarr( 24)=         11422.5458839793D0
	rhoarr( 25)=          9791.2510902989D0
	rhoarr( 26)=          8282.1785347378D0
	rhoarr( 27)=          6926.4326265958D0
	rhoarr( 28)=          5746.2353697879D0
	rhoarr( 29)=          4751.2332717125D0
	rhoarr( 30)=          3938.7188693480D0
	rhoarr( 31)=          3295.5744663261D0
	rhoarr( 32)=          2800.8845954475D0
	rhoarr( 33)=          2428.9401086325D0
	rhoarr( 34)=          2152.4073271644D0
	rhoarr( 35)=          1945.1980084666D0
	rhoarr( 36)=          1784.5539880359D0
	rhoarr( 37)=          1652.1410694984D0
	rhoarr( 38)=          1534.2921176370D0
	rhoarr( 39)=          1421.7170721624D0
	rhoarr( 40)=          1308.9646911320D0
	rhoarr( 41)=          1193.7840151398D0
	rhoarr( 42)=          1076.4203813906D0
	rhoarr( 43)=           958.8504476740D0
	rhoarr( 44)=           843.9941845393D0
	rhoarr( 45)=           734.9847881389D0
	rhoarr( 46)=           634.5878857801D0
	rhoarr( 47)=           544.8311217913D0
	rhoarr( 48)=           466.8530062429D0
	rhoarr( 49)=           400.9318235937D0
	rhoarr( 50)=           346.6288792945D0
	rhoarr( 51)=           302.9789498491D0
	rhoarr( 52)=           268.6773944880D0
	rhoarr( 53)=           242.2368540221D0
	rhoarr( 54)=           222.1072530463D0
	rhoarr( 55)=           206.7656735853D0
	rhoarr( 56)=           194.7866882840D0
	rhoarr( 57)=           184.9010842662D0
	rhoarr( 58)=           176.0451410471D0
	rhoarr( 59)=           167.3972875251D0
	rhoarr( 60)=           158.3964931940D0
	rhoarr( 61)=           148.7379037743D0
	rhoarr( 62)=           138.3451350870D0
	rhoarr( 63)=           127.3234256774D0
	rhoarr( 64)=           115.9015927554D0
	rhoarr( 65)=           104.3722283824D0
	rhoarr( 66)=            93.0386361110D0
	rhoarr( 67)=            82.1743208092D0
	rhoarr( 68)=            71.9974778168D0
	rhoarr( 69)=            62.6598727580D0
	rhoarr( 70)=            54.2473772094D0
	rhoarr( 71)=            46.7884093491D0
	rhoarr( 72)=            40.2664753352D0
	rhoarr( 73)=            34.6336092629D0
	rhoarr( 74)=            29.8224433992D0
	rhoarr( 75)=            25.7556447550D0
	rhoarr( 76)=            22.3523504150D0
	rhoarr( 77)=            19.5319154897D0
	rhoarr( 78)=            17.2157026173D0
	rhoarr( 79)=            15.3277855882D0
	rhoarr( 80)=            13.7953496690D0
	rhoarr( 81)=            12.5493212780D0
	rhoarr( 82)=            11.5254439182D0
	rhoarr( 83)=            10.6657274061D0
	rhoarr( 84)=             9.9200006246D0
	rhoarr( 85)=             9.2472237449D0
	rhoarr( 86)=             8.6162557255D0
	rhoarr( 87)=             8.0058915566D0
	rhoarr( 88)=             7.4041348405D0
	rhoarr( 89)=             6.8068122845D0
	rhoarr( 90)=             6.2157380363D0
	rhoarr( 91)=             5.6366841995D0
	rhoarr( 92)=             5.0774103108D0
	rhoarr( 93)=             4.5459599059D0
	rhoarr( 94)=             4.0493623551D0
	rhoarr( 95)=             3.5927995816D0
	rhoarr( 96)=             3.1792246776D0
	rhoarr( 97)=             2.8093634487D0
	rhoarr( 98)=             2.4819962891D0
	rhoarr( 99)=             2.1944071486D0
	rhoarr(100)=             1.9428950706D0
	rhoarr(101)=             1.7232654386D0
	rhoarr(102)=             1.5312454779D0
	rhoarr(103)=             1.3627954612D0
	rhoarr(104)=             1.2143093015D0
	rhoarr(105)=             1.0827139482D0
	rhoarr(106)=             0.9654863044D0
	rhoarr(107)=             0.8606104305D0
	rhoarr(108)=             0.7664981057D0
	rhoarr(109)=             0.6818936619D0
	rhoarr(110)=             0.6057802972D0
	rhoarr(111)=             0.5373003753D0
	rhoarr(112)=             0.4756970058D0
	rhoarr(113)=             0.4202789976D0
	rhoarr(114)=             0.3704067309D0
	rhoarr(115)=             0.3254932302D0
	rhoarr(116)=             0.2850131677D0
	rhoarr(117)=             0.2485127548D0
	rhoarr(118)=             0.2156151426D0
	rhoarr(119)=             0.1860184198D0
	rhoarr(120)=             0.1594858473D0
	rhoarr(121)=             0.1358300232D0
	rhoarr(122)=             0.1148938996D0
	rhoarr(123)=             0.0965319308D0
	rhoarr(124)=             0.0805942639D0
	rhoarr(125)=             0.0669160125D0
	rhoarr(126)=             0.0553125360D0
	rhoarr(127)=             0.0455804990D0
	rhoarr(128)=             0.0375035342D0
	rhoarr(129)=             0.0308607192D0
	rhoarr(130)=             0.0254359178D0
	rhoarr(131)=             0.0210262807D0
	rhoarr(132)=             0.0174487369D0
	rhoarr(133)=             0.0145439341D0
	rhoarr(134)=             0.0121776362D0
	rhoarr(135)=             0.0102399630D0
	rhoarr(136)=             0.0086430490D0
	rhoarr(137)=             0.0073177616D0
	rhoarr(138)=             0.0062100914D0
	rhoarr(139)=             0.0052777437D0
	rhoarr(140)=             0.0044873055D0
	rhoarr(141)=             0.0038121581D0
	rhoarr(142)=             0.0032310929D0
	rhoarr(143)=             0.0027274291D0
	rhoarr(144)=             0.0022883784D0
	rhoarr(145)=             0.0019044548D0
	rhoarr(146)=             0.0015688316D0
	rhoarr(147)=             0.0012766484D0
	rhoarr(148)=             0.0010243292D0
	rhoarr(149)=             0.0008089764D0
	rhoarr(150)=             0.0006278959D0
	rhoarr(151)=             0.0004782806D0
	rhoarr(152)=             0.0003570588D0
	rhoarr(153)=             0.0002608939D0
	rhoarr(154)=             0.0001862913D0
	rhoarr(155)=             0.0001297598D0
	rhoarr(156)=             0.0000879734D0
	rhoarr(157)=             0.0000578982D0
	rhoarr(158)=             0.0000368712D0
	rhoarr(159)=             0.0000226349D0
	rhoarr(160)=             0.0000133370D0
	rhoarr(161)=             0.0000075068D0
	rhoarr(162)=             0.0000040163D0
	rhoarr(163)=             0.0000020332D0
	rhoarr(164)=             0.0000009702D0
	rhoarr(165)=             0.0000004354D0
	rhoarr(166)=             0.0000001835D0
	rhoarr(167)=             0.0000000725D0
	rhoarr(168)=             0.0000000267D0

else if (iele==96) then  !Cm, 5f7 6d1 7s2, 0 9, B3LYP/SARC-DKH int=dkh2
	npt=  167
	rhoarr(  1)=      33132226.7846993506D0
	rhoarr(  2)=      12536347.2841873430D0
	rhoarr(  3)=       6478429.7800826831D0
	rhoarr(  4)=       3834741.0928257206D0
	rhoarr(  5)=       2422840.4668417750D0
	rhoarr(  6)=       1586061.8454876707D0
	rhoarr(  7)=       1058372.3005473993D0
	rhoarr(  8)=        711568.2175473617D0
	rhoarr(  9)=        478624.8695377559D0
	rhoarr( 10)=        322314.3854063133D0
	rhoarr( 11)=        217704.5731697092D0
	rhoarr( 12)=        147851.1499144327D0
	rhoarr( 13)=        101482.7295900969D0
	rhoarr( 14)=         71044.9985848055D0
	rhoarr( 15)=         51384.5591542610D0
	rhoarr( 16)=         38862.9252422343D0
	rhoarr( 17)=         30906.7425869166D0
	rhoarr( 18)=         25746.0157700601D0
	rhoarr( 19)=         22204.8373888753D0
	rhoarr( 20)=         19542.4030960238D0
	rhoarr( 21)=         17325.3231213271D0
	rhoarr( 22)=         15323.2569728320D0
	rhoarr( 23)=         13433.4757003066D0
	rhoarr( 24)=         11630.6234918959D0
	rhoarr( 25)=          9931.6070553159D0
	rhoarr( 26)=          8369.6423004993D0
	rhoarr( 27)=          6976.5679608856D0
	rhoarr( 28)=          5773.3949320166D0
	rhoarr( 29)=          4767.3850929772D0
	rhoarr( 30)=          3952.8764324873D0
	rhoarr( 31)=          3313.6470787912D0
	rhoarr( 32)=          2825.8626819240D0
	rhoarr( 33)=          2461.3707508495D0
	rhoarr( 34)=          2191.0675555408D0
	rhoarr( 35)=          1987.8185764980D0
	rhoarr( 36)=          1828.4549176364D0
	rhoarr( 37)=          1694.7064759964D0
	rhoarr( 38)=          1573.2836162594D0
	rhoarr( 39)=          1455.4616004048D0
	rhoarr( 40)=          1336.4503239690D0
	rhoarr( 41)=          1214.6785386246D0
	rhoarr( 42)=          1091.0154957930D0
	rhoarr( 43)=           967.9384157204D0
	rhoarr( 44)=           848.6974124877D0
	rhoarr( 45)=           736.5703559792D0
	rhoarr( 46)=           634.3003614771D0
	rhoarr( 47)=           543.7676691154D0
	rhoarr( 48)=           465.8900369517D0
	rhoarr( 49)=           400.6987464466D0
	rhoarr( 50)=           347.5161922625D0
	rhoarr( 51)=           305.1659996444D0
	rhoarr( 52)=           272.1679697282D0
	rhoarr( 53)=           246.8956889227D0
	rhoarr( 54)=           227.6950750477D0
	rhoarr( 55)=           212.9731894855D0
	rhoarr( 56)=           201.2685181492D0
	rhoarr( 57)=           191.3096226193D0
	rhoarr( 58)=           182.0626270978D0
	rhoarr( 59)=           172.7630334782D0
	rhoarr( 60)=           162.9259641253D0
	rhoarr( 61)=           152.3313280747D0
	rhoarr( 62)=           140.9851750718D0
	rhoarr( 63)=           129.0634674806D0
	rhoarr( 64)=           116.8477515509D0
	rhoarr( 65)=           104.6628116936D0
	rhoarr( 66)=            92.8245330401D0
	rhoarr( 67)=            81.6028483662D0
	rhoarr( 68)=            71.2010031116D0
	rhoarr( 69)=            61.7493923160D0
	rhoarr( 70)=            53.3103925902D0
	rhoarr( 71)=            45.8899664740D0
	rhoarr( 72)=            39.4521010637D0
	rhoarr( 73)=            33.9329974582D0
	rhoarr( 74)=            29.2530176493D0
	rhoarr( 75)=            25.3254690986D0
	rhoarr( 76)=            22.0621999934D0
	rhoarr( 77)=            19.3765976529D0
	rhoarr( 78)=            17.1848951611D0
	rhoarr( 79)=            15.4067161201D0
	rhoarr( 80)=            13.9655901180D0
	rhoarr( 81)=            12.7898501249D0
	rhoarr( 82)=            11.8139841929D0
	rhoarr( 83)=            10.9802462822D0
	rhoarr( 84)=            10.2401861726D0
	rhoarr( 85)=             9.5557445505D0
	rhoarr( 86)=             8.8996496117D0
	rhoarr( 87)=             8.2549999181D0
	rhoarr( 88)=             7.6140766322D0
	rhoarr( 89)=             6.9765586581D0
	rhoarr( 90)=             6.3473945455D0
	rhoarr( 91)=             5.7346090701D0
	rhoarr( 92)=             5.1472963304D0
	rhoarr( 93)=             4.5939888639D0
	rhoarr( 94)=             4.0815108347D0
	rhoarr( 95)=             3.6143397796D0
	rhoarr( 96)=             3.1944298637D0
	rhoarr( 97)=             2.8213996278D0
	rhoarr( 98)=             2.4929627128D0
	rhoarr( 99)=             2.2054794774D0
	rhoarr(100)=             1.9545250751D0
	rhoarr(101)=             1.7353976060D0
	rhoarr(102)=             1.5435207280D0
	rhoarr(103)=             1.3747227221D0
	rhoarr(104)=             1.2253951771D0
	rhoarr(105)=             1.0925482773D0
	rhoarr(106)=             0.9737869385D0
	rhoarr(107)=             0.8672342517D0
	rhoarr(108)=             0.7714274187D0
	rhoarr(109)=             0.6852078191D0
	rhoarr(110)=             0.6076218545D0
	rhoarr(111)=             0.5378434111D0
	rhoarr(112)=             0.4751227554D0
	rhoarr(113)=             0.4187611351D0
	rhoarr(114)=             0.3681059972D0
	rhoarr(115)=             0.3225591390D0
	rhoarr(116)=             0.2815894992D0
	rhoarr(117)=             0.2447434927D0
	rhoarr(118)=             0.2116482195D0
	rhoarr(119)=             0.1820057723D0
	rhoarr(120)=             0.1555795023D0
	rhoarr(121)=             0.1321749743D0
	rhoarr(122)=             0.1116192362D0
	rhoarr(123)=             0.0937419963D0
	rhoarr(124)=             0.0783615481D0
	rhoarr(125)=             0.0652770823D0
	rhoarr(126)=             0.0542676759D0
	rhoarr(127)=             0.0450970064D0
	rhoarr(128)=             0.0375219595D0
	rhoarr(129)=             0.0313029099D0
	rhoarr(130)=             0.0262135828D0
	rhoarr(131)=             0.0220489389D0
	rhoarr(132)=             0.0186302453D0
	rhoarr(133)=             0.0158071917D0
	rhoarr(134)=             0.0134574146D0
	rhoarr(135)=             0.0114840764D0
	rhoarr(136)=             0.0098122237D0
	rhoarr(137)=             0.0083846187D0
	rhoarr(138)=             0.0071576406D0
	rhoarr(139)=             0.0060977073D0
	rhoarr(140)=             0.0051784849D0
	rhoarr(141)=             0.0043789386D0
	rhoarr(142)=             0.0036820961D0
	rhoarr(143)=             0.0030742830D0
	rhoarr(144)=             0.0025445835D0
	rhoarr(145)=             0.0020843545D0
	rhoarr(146)=             0.0016867203D0
	rhoarr(147)=             0.0013460557D0
	rhoarr(148)=             0.0010574997D0
	rhoarr(149)=             0.0008165422D0
	rhoarr(150)=             0.0006187165D0
	rhoarr(151)=             0.0004594177D0
	rhoarr(152)=             0.0003338554D0
	rhoarr(153)=             0.0002371279D0
	rhoarr(154)=             0.0001643855D0
	rhoarr(155)=             0.0001110297D0
	rhoarr(156)=             0.0000728938D0
	rhoarr(157)=             0.0000463691D0
	rhoarr(158)=             0.0000284572D0
	rhoarr(159)=             0.0000167577D0
	rhoarr(160)=             0.0000094076D0
	rhoarr(161)=             0.0000049996D0
	rhoarr(162)=             0.0000024985D0
	rhoarr(163)=             0.0000011680D0
	rhoarr(164)=             0.0000005096D0
	rhoarr(165)=             0.0000002078D0
	rhoarr(166)=             0.0000000796D0
	rhoarr(167)=             0.0000000287D0

else if (iele==97) then  !Bk, 5f9 7s2, 0 6, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      36402092.0029784739D0
	rhoarr(  2)=      13527104.6477529947D0
	rhoarr(  3)=       6910871.8587507103D0
	rhoarr(  4)=       4055808.3406452099D0
	rhoarr(  5)=       2545119.3995172763D0
	rhoarr(  6)=       1655086.5240339420D0
	rhoarr(  7)=       1097646.9324756521D0
	rhoarr(  8)=        733365.7196489187D0
	rhoarr(  9)=        490273.1482161356D0
	rhoarr( 10)=        328305.6673347441D0
	rhoarr( 11)=        220669.6135751525D0
	rhoarr( 12)=        149284.8406055007D0
	rhoarr( 13)=        102214.6833034615D0
	rhoarr( 14)=         71523.8982544334D0
	rhoarr( 15)=         51833.3199370967D0
	rhoarr( 16)=         39365.1186165549D0
	rhoarr( 17)=         31468.2066708142D0
	rhoarr( 18)=         26336.0663661355D0
	rhoarr( 19)=         22782.3907857336D0
	rhoarr( 20)=         20071.2940435144D0
	rhoarr( 21)=         17780.6586621796D0
	rhoarr( 22)=         15692.3259994623D0
	rhoarr( 23)=         13714.4981674087D0
	rhoarr( 24)=         11830.6129370394D0
	rhoarr( 25)=         10063.5925118885D0
	rhoarr( 26)=          8449.6281553938D0
	rhoarr( 27)=          7020.8439221093D0
	rhoarr( 28)=          5796.6263601057D0
	rhoarr( 29)=          4781.5183183784D0
	rhoarr( 30)=          3966.6544686417D0
	rhoarr( 31)=          3332.5477111948D0
	rhoarr( 32)=          2852.3771266951D0
	rhoarr( 33)=          2495.5690870174D0
	rhoarr( 34)=          2231.3396650539D0
	rhoarr( 35)=          2031.6310393327D0
	rhoarr( 36)=          1872.9881399340D0
	rhoarr( 37)=          1737.3128100460D0
	rhoarr( 38)=          1611.7785878497D0
	rhoarr( 39)=          1488.2899389398D0
	rhoarr( 40)=          1362.7599792625D0
	rhoarr( 41)=          1234.3155098227D0
	rhoarr( 42)=          1104.4428389741D0
	rhoarr( 43)=           976.0898782316D0
	rhoarr( 44)=           852.7908664331D0
	rhoarr( 45)=           737.9160785300D0
	rhoarr( 46)=           634.1374297055D0
	rhoarr( 47)=           543.1496664333D0
	rhoarr( 48)=           465.6252816031D0
	rhoarr( 49)=           401.3369752420D0
	rhoarr( 50)=           349.3667700989D0
	rhoarr( 51)=           308.3324227076D0
	rhoarr( 52)=           276.5874391491D0
	rhoarr( 53)=           252.3779150009D0
	rhoarr( 54)=           233.9588935136D0
	rhoarr( 55)=           219.6818466455D0
	rhoarr( 56)=           208.0645512249D0
	rhoarr( 57)=           197.8488658070D0
	rhoarr( 58)=           188.0451222103D0
	rhoarr( 59)=           177.9575467355D0
	rhoarr( 60)=           167.1849909133D0
	rhoarr( 61)=           155.5948732760D0
	rhoarr( 62)=           143.2736784626D0
	rhoarr( 63)=           130.4622377351D0
	rhoarr( 64)=           117.4865454293D0
	rhoarr( 65)=           104.6944679201D0
	rhoarr( 66)=            92.4059461085D0
	rhoarr( 67)=            80.8804002002D0
	rhoarr( 68)=            70.3012763471D0
	rhoarr( 69)=            60.7748942493D0
	rhoarr( 70)=            52.3392932015D0
	rhoarr( 71)=            44.9785224520D0
	rhoarr( 72)=            38.6384344507D0
	rhoarr( 73)=            33.2411207133D0
	rhoarr( 74)=            28.6963443980D0
	rhoarr( 75)=            24.9094324958D0
	rhoarr( 76)=            21.7859450251D0
	rhoarr( 77)=            19.2339644362D0
	rhoarr( 78)=            17.1650359345D0
	rhoarr( 79)=            15.4946876259D0
	rhoarr( 80)=            14.1431635671D0
	rhoarr( 81)=            13.0366312052D0
	rhoarr( 82)=            12.1087881362D0
	rhoarr( 83)=            11.3025686139D0
	rhoarr( 84)=            10.5715678677D0
	rhoarr( 85)=             9.8808483842D0
	rhoarr( 86)=             9.2069246515D0
	rhoarr( 87)=             8.5368895689D0
	rhoarr( 88)=             7.8668009641D0
	rhoarr( 89)=             7.1995593498D0
	rhoarr( 90)=             6.5425639880D0
	rhoarr( 91)=             5.9054337021D0
	rhoarr( 92)=             5.2980320087D0
	rhoarr( 93)=             4.7289590841D0
	rhoarr( 94)=             4.2045837988D0
	rhoarr( 95)=             3.7286044326D0
	rhoarr( 96)=             3.3020598916D0
	rhoarr( 97)=             2.9236720618D0
	rhoarr( 98)=             2.5903859434D0
	rhoarr( 99)=             2.2979835121D0
	rhoarr(100)=             2.0416723631D0
	rhoarr(101)=             1.8165824800D0
	rhoarr(102)=             1.6181364571D0
	rhoarr(103)=             1.4422851906D0
	rhoarr(104)=             1.2856202205D0
	rhoarr(105)=             1.1453855320D0
	rhoarr(106)=             1.0194169617D0
	rhoarr(107)=             0.9060380133D0
	rhoarr(108)=             0.8039383096D0
	rhoarr(109)=             0.7120561715D0
	rhoarr(110)=             0.6294807218D0
	rhoarr(111)=             0.5553821985D0
	rhoarr(112)=             0.4889726063D0
	rhoarr(113)=             0.4294932503D0
	rhoarr(114)=             0.3762217972D0
	rhoarr(115)=             0.3284897069D0
	rhoarr(116)=             0.2857011638D0
	rhoarr(117)=             0.2473465770D0
	rhoarr(118)=             0.2130066000D0
	rhoarr(119)=             0.1823456688D0
	rhoarr(120)=             0.1550966327D0
	rhoarr(121)=             0.1310397760D0
	rhoarr(122)=             0.1099802791D0
	rhoarr(123)=             0.0917280051D0
	rhoarr(124)=             0.0760826165D0
	rhoarr(125)=             0.0628256815D0
	rhoarr(126)=             0.0517199150D0
	rhoarr(127)=             0.0425143620D0
	rhoarr(128)=             0.0349534214D0
	rhoarr(129)=             0.0287873020D0
	rhoarr(130)=             0.0237817638D0
	rhoarr(131)=             0.0197256461D0
	rhoarr(132)=             0.0164354684D0
	rhoarr(133)=             0.0137570692D0
	rhoarr(134)=             0.0115647110D0
	rhoarr(135)=             0.0097583156D0
	rhoarr(136)=             0.0082595704D0
	rhoarr(137)=             0.0070076257D0
	rhoarr(138)=             0.0059550111D0
	rhoarr(139)=             0.0050642317D0
	rhoarr(140)=             0.0043052699D0
	rhoarr(141)=             0.0036539637D0
	rhoarr(142)=             0.0030910313D0
	rhoarr(143)=             0.0026014368D0
	rhoarr(144)=             0.0021738318D0
	rhoarr(145)=             0.0017999324D0
	rhoarr(146)=             0.0014738130D0
	rhoarr(147)=             0.0011911761D0
	rhoarr(148)=             0.0009486777D0
	rhoarr(149)=             0.0007433734D0
	rhoarr(150)=             0.0005723247D0
	rhoarr(151)=             0.0004323807D0
	rhoarr(152)=             0.0003201249D0
	rhoarr(153)=             0.0002319494D0
	rhoarr(154)=             0.0001642026D0
	rhoarr(155)=             0.0001133522D0
	rhoarr(156)=             0.0000761235D0
	rhoarr(157)=             0.0000495933D0
	rhoarr(158)=             0.0000312389D0
	rhoarr(159)=             0.0000189522D0
	rhoarr(160)=             0.0000110260D0
	rhoarr(161)=             0.0000061225D0
	rhoarr(162)=             0.0000032296D0
	rhoarr(163)=             0.0000016115D0
	rhoarr(164)=             0.0000007583D0
	rhoarr(165)=             0.0000003358D0
	rhoarr(166)=             0.0000001398D0
	rhoarr(167)=             0.0000000545D0
	rhoarr(168)=             0.0000000198D0

else if (iele==98) then  !Cf, 5f10 7s2, 0 5, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      39999684.7573347464D0
	rhoarr(  2)=      14595593.9495705906D0
	rhoarr(  3)=       7370894.8248943882D0
	rhoarr(  4)=       4288438.4712232975D0
	rhoarr(  5)=       2672705.1473679808D0
	rhoarr(  6)=       1726479.2531896222D0
	rhoarr(  7)=       1137893.0978991094D0
	rhoarr(  8)=        755444.9539222544D0
	rhoarr(  9)=        501911.8366739524D0
	rhoarr( 10)=        334201.6596592103D0
	rhoarr( 11)=        223542.4783306702D0
	rhoarr( 12)=        150658.5660526906D0
	rhoarr( 13)=        102921.3282605794D0
	rhoarr( 14)=         72005.8346347186D0
	rhoarr( 15)=         52304.0533338690D0
	rhoarr( 16)=         39898.6605083695D0
	rhoarr( 17)=         32062.4785115943D0
	rhoarr( 18)=         26954.8227004170D0
	rhoarr( 19)=         23381.5650386383D0
	rhoarr( 20)=         20613.9043276907D0
	rhoarr( 21)=         18242.4223217159D0
	rhoarr( 22)=         16061.9571263644D0
	rhoarr( 23)=         13992.0367886408D0
	rhoarr( 24)=         12024.9496580659D0
	rhoarr( 25)=         10189.4058916848D0
	rhoarr( 26)=          8524.1613994101D0
	rhoarr( 27)=          7061.1602768300D0
	rhoarr( 28)=          5817.7400216708D0
	rhoarr( 29)=          4795.3783915561D0
	rhoarr( 30)=          3981.7452358796D0
	rhoarr( 31)=          3353.9159917624D0
	rhoarr( 32)=          2882.0078035938D0
	rhoarr( 33)=          2533.0430860615D0
	rhoarr( 34)=          2274.6431499663D0
	rhoarr( 35)=          2077.9453092845D0
	rhoarr( 36)=          1919.3294486737D0
	rhoarr( 37)=          1780.9767252746D0
	rhoarr( 38)=          1650.6128275030D0
	rhoarr( 39)=          1520.8417312499D0
	rhoarr( 40)=          1388.3298592455D0
	rhoarr( 41)=          1252.9285609196D0
	rhoarr( 42)=          1116.7419575988D0
	rhoarr( 43)=           983.1657827825D0
	rhoarr( 44)=           855.9788721149D0
	rhoarr( 45)=           738.5974473522D0
	rhoarr( 46)=           633.5781143985D0
	rhoarr( 47)=           542.3946577963D0
	rhoarr( 48)=           465.4498915056D0
	rhoarr( 49)=           402.2437913381D0
	rhoarr( 50)=           351.6116698015D0
	rhoarr( 51)=           311.9642399542D0
	rhoarr( 52)=           281.4908435132D0
	rhoarr( 53)=           258.3147038838D0
	rhoarr( 54)=           240.6070261069D0
	rhoarr( 55)=           226.6732611829D0
	rhoarr( 56)=           215.0223356059D0
	rhoarr( 57)=           204.4226587197D0
	rhoarr( 58)=           193.9419191799D0
	rhoarr( 59)=           182.9643613801D0
	rhoarr( 60)=           171.1804955861D0
	rhoarr( 61)=           158.5489730878D0
	rhoarr( 62)=           145.2362476623D0
	rhoarr( 63)=           131.5441559311D0
	rhoarr( 64)=           117.8371487540D0
	rhoarr( 65)=           104.4794320640D0
	rhoarr( 66)=            91.7886776082D0
	rhoarr( 67)=            80.0086606313D0
	rhoarr( 68)=            69.2994282166D0
	rhoarr( 69)=            59.7411273183D0
	rhoarr( 70)=            51.3465828045D0
	rhoarr( 71)=            44.0778681973D0
	rhoarr( 72)=            37.8630364998D0
	rhoarr( 73)=            32.6104586426D0
	rhoarr( 74)=            28.2195238811D0
	rhoarr( 75)=            24.5875662625D0
	rhoarr( 76)=            21.6136634599D0
	rhoarr( 77)=            19.2003580749D0
	rhoarr( 78)=            17.2543985071D0
	rhoarr( 79)=            15.6873700997D0
	rhoarr( 80)=            14.4167110483D0
	rhoarr( 81)=            13.3672125668D0
	rhoarr( 82)=            12.4727941566D0
	rhoarr( 83)=            11.6781797813D0
	rhoarr( 84)=            10.9400849333D0
	rhoarr( 85)=            10.2276243672D0
	rhoarr( 86)=             9.5218129944D0
	rhoarr( 87)=             8.8142054906D0
	rhoarr( 88)=             8.1048633712D0
	rhoarr( 89)=             7.3999285574D0
	rhoarr( 90)=             6.7091127318D0
	rhoarr( 91)=             6.0433873581D0
	rhoarr( 92)=             5.4130934427D0
	rhoarr( 93)=             4.8266005834D0
	rhoarr( 94)=             4.2895501646D0
	rhoarr( 95)=             3.8046343241D0
	rhoarr( 96)=             3.3718024787D0
	rhoarr( 97)=             2.9887563731D0
	rhoarr( 98)=             2.6515918211D0
	rhoarr( 99)=             2.3554642781D0
	rhoarr(100)=             2.0951871477D0
	rhoarr(101)=             1.8657072882D0
	rhoarr(102)=             1.6624346228D0
	rhoarr(103)=             1.4814281131D0
	rhoarr(104)=             1.3194574276D0
	rhoarr(105)=             1.1739690829D0
	rhoarr(106)=             1.0429892043D0
	rhoarr(107)=             0.9249939477D0
	rhoarr(108)=             0.8187744197D0
	rhoarr(109)=             0.7233166767D0
	rhoarr(110)=             0.6377100039D0
	rhoarr(111)=             0.5610890938D0
	rhoarr(112)=             0.4926089017D0
	rhoarr(113)=             0.4314457111D0
	rhoarr(114)=             0.3768148776D0
	rhoarr(115)=             0.3279949932D0
	rhoarr(116)=             0.2843495326D0
	rhoarr(117)=             0.2453397488D0
	rhoarr(118)=             0.2105258762D0
	rhoarr(119)=             0.1795568305D0
	rhoarr(120)=             0.1521510321D0
	rhoarr(121)=             0.1280724483D0
	rhoarr(122)=             0.1071063948D0
	rhoarr(123)=             0.0890391496D0
	rhoarr(124)=             0.0736442296D0
	rhoarr(125)=             0.0606765546D0
	rhoarr(126)=             0.0498740515D0
	rhoarr(127)=             0.0409649104D0
	rhoarr(128)=             0.0336779548D0
	rhoarr(129)=             0.0277535402D0
	rhoarr(130)=             0.0229529093D0
	rhoarr(131)=             0.0190647544D0
	rhoarr(132)=             0.0159085675D0
	rhoarr(133)=             0.0133350023D0
	rhoarr(134)=             0.0112238481D0
	rhoarr(135)=             0.0094803797D0
	rhoarr(136)=             0.0080308749D0
	rhoarr(137)=             0.0068180310D0
	rhoarr(138)=             0.0057968809D0
	rhoarr(139)=             0.0049315931D0
	rhoarr(140)=             0.0041932690D0
	rhoarr(141)=             0.0035585954D0
	rhoarr(142)=             0.0030090492D0
	rhoarr(143)=             0.0025303270D0
	rhoarr(144)=             0.0021117678D0
	rhoarr(145)=             0.0017456754D0
	rhoarr(146)=             0.0014265662D0
	rhoarr(147)=             0.0011504207D0
	rhoarr(148)=             0.0009140203D0
	rhoarr(149)=             0.0007144279D0
	rhoarr(150)=             0.0005486413D0
	rhoarr(151)=             0.0004134231D0
	rhoarr(152)=             0.0003052877D0
	rhoarr(153)=             0.0002205977D0
	rhoarr(154)=             0.0001557157D0
	rhoarr(155)=             0.0001071581D0
	rhoarr(156)=             0.0000717182D0
	rhoarr(157)=             0.0000465481D0
	rhoarr(158)=             0.0000292001D0
	rhoarr(159)=             0.0000176357D0
	rhoarr(160)=             0.0000102103D0
	rhoarr(161)=             0.0000056404D0
	rhoarr(162)=             0.0000029596D0
	rhoarr(163)=             0.0000014693D0
	rhoarr(164)=             0.0000006880D0
	rhoarr(165)=             0.0000003034D0
	rhoarr(166)=             0.0000001258D0
	rhoarr(167)=             0.0000000489D0
	rhoarr(168)=             0.0000000177D0

else if (iele==99) then  !Es, 5f11 7s2, 0 4, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      43957710.1569682732D0
	rhoarr(  2)=      15747364.4284040201D0
	rhoarr(  3)=       7859922.9038350824D0
	rhoarr(  4)=       4533041.9251609445D0
	rhoarr(  5)=       2805719.6922818241D0
	rhoarr(  6)=       1800257.4970393209D0
	rhoarr(  7)=       1179091.6063368691D0
	rhoarr(  8)=        777776.1493312542D0
	rhoarr(  9)=        513515.6692211065D0
	rhoarr( 10)=        339986.4383541765D0
	rhoarr( 11)=        226315.5456805766D0
	rhoarr( 12)=        151969.9254481211D0
	rhoarr( 13)=        103602.8081033098D0
	rhoarr( 14)=         72491.8164499906D0
	rhoarr( 15)=         52797.6285249967D0
	rhoarr( 16)=         40463.7490430497D0
	rhoarr( 17)=         32688.8780040334D0
	rhoarr( 18)=         27600.7841720784D0
	rhoarr( 19)=         24000.2766668077D0
	rhoarr( 20)=         21167.8612646460D0
	rhoarr( 21)=         18708.2216867761D0
	rhoarr( 22)=         16429.9537182032D0
	rhoarr( 23)=         14264.2390849235D0
	rhoarr( 24)=         12212.1981459102D0
	rhoarr( 25)=         10308.0289939548D0
	rhoarr( 26)=          8592.5864444435D0
	rhoarr( 27)=          7097.1379707277D0
	rhoarr( 28)=          5836.5357673062D0
	rhoarr( 29)=          4808.8482352857D0
	rhoarr( 30)=          3998.0308942709D0
	rhoarr( 31)=          3377.5707518691D0
	rhoarr( 32)=          2914.4753186517D0
	rhoarr( 33)=          2573.4084775866D0
	rhoarr( 34)=          2320.5051356663D0
	rhoarr( 35)=          2126.2308956038D0
	rhoarr( 36)=          1966.9287754165D0
	rhoarr( 37)=          1825.1681153711D0
	rhoarr( 38)=          1689.3133871167D0
	rhoarr( 39)=          1552.7328175014D0
	rhoarr( 40)=          1412.8875759206D0
	rhoarr( 41)=          1270.3689264117D0
	rhoarr( 42)=          1127.8873950571D0
	rhoarr( 43)=           989.2524465966D0
	rhoarr( 44)=           858.4394641311D0
	rhoarr( 45)=           738.8592716434D0
	rhoarr( 46)=           632.9077538776D0
	rhoarr( 47)=           541.8037675166D0
	rhoarr( 48)=           465.6592908645D0
	rhoarr( 49)=           403.6915227841D0
	rhoarr( 50)=           354.4870589389D0
	rhoarr( 51)=           316.2527017226D0
	rhoarr( 52)=           287.0199710630D0
	rhoarr( 53)=           264.7979161473D0
	rhoarr( 54)=           247.6847675725D0
	rhoarr( 55)=           233.9528575242D0
	rhoarr( 56)=           222.1166372533D0
	rhoarr( 57)=           210.9857146137D0
	rhoarr( 58)=           199.6983862508D0
	rhoarr( 59)=           187.7290666430D0
	rhoarr( 60)=           174.8657449971D0
	rhoarr( 61)=           161.1593869177D0
	rhoarr( 62)=           146.8532537011D0
	rhoarr( 63)=           132.3039777561D0
	rhoarr( 64)=           117.9067321580D0
	rhoarr( 65)=           104.0342650062D0
	rhoarr( 66)=            90.9952325382D0
	rhoarr( 67)=            79.0127065669D0
	rhoarr( 68)=            68.2201368760D0
	rhoarr( 69)=            58.6699719319D0
	rhoarr( 70)=            50.3495617733D0
	rhoarr( 71)=            43.1995198229D0
	rhoarr( 72)=            37.1309325979D0
	rhoarr( 73)=            32.0392521203D0
	rhoarr( 74)=            27.8140677176D0
	rhoarr( 75)=            24.3450259018D0
	rhoarr( 76)=            21.5248414079D0
	rhoarr( 77)=            19.2505996557D0
	rhoarr( 78)=            17.4244501696D0
	rhoarr( 79)=            15.9544511459D0
	rhoarr( 80)=            14.7558937643D0
	rhoarr( 81)=            13.7530449442D0
	rhoarr( 82)=            12.8809885928D0
	rhoarr( 83)=            12.0871498281D0
	rhoarr( 84)=            11.3321353230D0
	rhoarr( 85)=            10.5896663463D0
	rhoarr( 86)=             9.8455616852D0
	rhoarr( 87)=             9.0958963959D0
	rhoarr( 88)=             8.3445867767D0
	rhoarr( 89)=             7.6007169053D0
	rhoarr( 90)=             6.8759265780D0
	rhoarr( 91)=             6.1821337082D0
	rhoarr( 92)=             5.5297817969D0
	rhoarr( 93)=             4.9267038712D0
	rhoarr( 94)=             4.3775972775D0
	rhoarr( 95)=             3.8840248847D0
	rhoarr( 96)=             3.4448077777D0
	rhoarr( 97)=             3.0566554221D0
	rhoarr( 98)=             2.7148877922D0
	rhoarr( 99)=             2.4141317268D0
	rhoarr(100)=             2.1489108152D0
	rhoarr(101)=             1.9140856121D0
	rhoarr(102)=             1.7051329037D0
	rhoarr(103)=             1.5182762740D0
	rhoarr(104)=             1.3504950131D0
	rhoarr(105)=             1.1994456419D0
	rhoarr(106)=             1.0633316303D0
	rhoarr(107)=             0.9407538642D0
	rhoarr(108)=             0.8305683874D0
	rhoarr(109)=             0.7317700819D0
	rhoarr(110)=             0.6434123717D0
	rhoarr(111)=             0.5645648679D0
	rhoarr(112)=             0.4943041502D0
	rhoarr(113)=             0.4317283827D0
	rhoarr(114)=             0.3759845134D0
	rhoarr(115)=             0.3262972754D0
	rhoarr(116)=             0.2819915046D0
	rhoarr(117)=             0.2425026150D0
	rhoarr(118)=             0.2073736089D0
	rhoarr(119)=             0.1762400797D0
	rhoarr(120)=             0.1488068860D0
	rhoarr(121)=             0.1248213306D0
	rhoarr(122)=             0.1040477656D0
	rhoarr(123)=             0.0862476804D0
	rhoarr(124)=             0.0711677689D0
	rhoarr(125)=             0.0585365915D0
	rhoarr(126)=             0.0480686844D0
	rhoarr(127)=             0.0394737301D0
	rhoarr(128)=             0.0324679101D0
	rhoarr(129)=             0.0267848099D0
	rhoarr(130)=             0.0221840075D0
	rhoarr(131)=             0.0184564089D0
	rhoarr(132)=             0.0154262267D0
	rhoarr(133)=             0.0129500541D0
	rhoarr(134)=             0.0109137750D0
	rhoarr(135)=             0.0092281475D0
	rhoarr(136)=             0.0078238800D0
	rhoarr(137)=             0.0066469230D0
	rhoarr(138)=             0.0056545188D0
	rhoarr(139)=             0.0048122910D0
	rhoarr(140)=             0.0040923657D0
	rhoarr(141)=             0.0034722762D0
	rhoarr(142)=             0.0029342998D0
	rhoarr(143)=             0.0024649072D0
	rhoarr(144)=             0.0020541392D0
	rhoarr(145)=             0.0016948702D0
	rhoarr(146)=             0.0013820183D0
	rhoarr(147)=             0.0011117911D0
	rhoarr(148)=             0.0008810465D0
	rhoarr(149)=             0.0006868149D0
	rhoarr(150)=             0.0005260033D0
	rhoarr(151)=             0.0003952732D0
	rhoarr(152)=             0.0002910632D0
	rhoarr(153)=             0.0002097032D0
	rhoarr(154)=             0.0001475659D0
	rhoarr(155)=             0.0001012104D0
	rhoarr(156)=             0.0000674919D0
	rhoarr(157)=             0.0000436318D0
	rhoarr(158)=             0.0000272525D0
	rhoarr(159)=             0.0000163821D0
	rhoarr(160)=             0.0000094366D0
	rhoarr(161)=             0.0000051853D0
	rhoarr(162)=             0.0000027061D0
	rhoarr(163)=             0.0000013363D0
	rhoarr(164)=             0.0000006228D0
	rhoarr(165)=             0.0000002735D0
	rhoarr(166)=             0.0000001130D0
	rhoarr(167)=             0.0000000437D0
	rhoarr(168)=             0.0000000157D0

else if (iele==100) then  !Fm, 5f12 7s2, 0 3, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      48344367.9923934042D0
	rhoarr(  2)=      16997847.1115022264D0
	rhoarr(  3)=       8383142.7810213473D0
	rhoarr(  4)=       4791577.7260453142D0
	rhoarr(  5)=       2944886.8759477092D0
	rhoarr(  6)=       1876640.3683792783D0
	rhoarr(  7)=       1221276.3558726627D0
	rhoarr(  8)=        800345.6944242826D0
	rhoarr(  9)=        525073.1297839415D0
	rhoarr( 10)=        345656.9911228532D0
	rhoarr( 11)=        228988.6695942015D0
	rhoarr( 12)=        153218.4857847227D0
	rhoarr( 13)=        104259.0036937643D0
	rhoarr( 14)=         72982.8933416191D0
	rhoarr( 15)=         53315.8816372888D0
	rhoarr( 16)=         41062.1380610355D0
	rhoarr( 17)=         33348.4869296175D0
	rhoarr( 18)=         28274.2470998937D0
	rhoarr( 19)=         24638.2183392924D0
	rhoarr( 20)=         21732.5028880992D0
	rhoarr( 21)=         19177.2545775730D0
	rhoarr( 22)=         16795.5404367330D0
	rhoarr( 23)=         14530.4780749361D0
	rhoarr( 24)=         12391.9505019703D0
	rhoarr( 25)=         10419.2911660965D0
	rhoarr( 26)=          8654.9451612788D0
	rhoarr( 27)=          7128.9801510959D0
	rhoarr( 28)=          5853.3148362261D0
	rhoarr( 29)=          4822.2623113331D0
	rhoarr( 30)=          4015.8210099866D0
	rhoarr( 31)=          3403.7532065933D0
	rhoarr( 32)=          2949.9289320177D0
	rhoarr( 33)=          2616.7187923269D0
	rhoarr( 34)=          2368.8947308771D0
	rhoarr( 35)=          2176.3924525956D0
	rhoarr( 36)=          2015.6497461683D0
	rhoarr( 37)=          1869.7333690194D0
	rhoarr( 38)=          1727.7317425069D0
	rhoarr( 39)=          1583.8388924300D0
	rhoarr( 40)=          1436.3470020993D0
	rhoarr( 41)=          1286.5957636907D0
	rhoarr( 42)=          1137.8833001644D0
	rhoarr( 43)=           994.3923052648D0
	rhoarr( 44)=           860.2424667873D0
	rhoarr( 45)=           738.7863308481D0
	rhoarr( 46)=           632.2143887075D0
	rhoarr( 47)=           541.4587438718D0
	rhoarr( 48)=           466.3220020074D0
	rhoarr( 49)=           405.7309870764D0
	rhoarr( 50)=           358.0236027075D0
	rhoarr( 51)=           321.2075291674D0
	rhoarr( 52)=           293.1642705037D0
	rhoarr( 53)=           271.7988223826D0
	rhoarr( 54)=           255.1487019997D0
	rhoarr( 55)=           241.4672542646D0
	rhoarr( 56)=           229.2896500347D0
	rhoarr( 57)=           217.4815208040D0
	rhoarr( 58)=           205.2644450909D0
	rhoarr( 59)=           192.2119004106D0
	rhoarr( 60)=           178.2134822398D0
	rhoarr( 61)=           163.4117701900D0
	rhoarr( 62)=           148.1221342088D0
	rhoarr( 63)=           132.7487311332D0
	rhoarr( 64)=           117.7092206968D0
	rhoarr( 65)=           103.3771047723D0
	rhoarr( 66)=            90.0456575159D0
	rhoarr( 67)=            77.9127667966D0
	rhoarr( 68)=            67.0827028152D0
	rhoarr( 69)=            57.5792229295D0
	rhoarr( 70)=            49.3643211294D0
	rhoarr( 71)=            42.3578697471D0
	rhoarr( 72)=            36.4548699206D0
	rhoarr( 73)=            31.5386006592D0
	rhoarr( 74)=            27.4893316379D0
	rhoarr( 75)=            24.1892578868D0
	rhoarr( 76)=            21.5248476707D0
	rhoarr( 77)=            19.3878877995D0
	rhoarr( 78)=            17.6762649487D0
	rhoarr( 79)=            16.2950899857D0
	rhoarr( 80)=            15.1583150053D0
	rhoarr( 81)=            14.1906354160D0
	rhoarr( 82)=            13.3292775136D0
	rhoarr( 83)=            12.5252492651D0
	rhoarr( 84)=            11.7437378784D0
	rhoarr( 85)=            10.9635124178D0
	rhoarr( 86)=            10.1753760337D0
	rhoarr( 87)=             9.3798680632D0
	rhoarr( 88)=             8.5845173046D0
	rhoarr( 89)=             7.8009860921D0
	rhoarr( 90)=             7.0424242637D0
	rhoarr( 91)=             6.3212848433D0
	rhoarr( 92)=             5.6477567122D0
	rhoarr( 93)=             5.0288636728D0
	rhoarr( 94)=             4.4681832019D0
	rhoarr( 95)=             3.9660666631D0
	rhoarr( 96)=             3.5202036516D0
	rhoarr( 97)=             3.1263665186D0
	rhoarr( 98)=             2.7791905110D0
	rhoarr( 99)=             2.4728802883D0
	rhoarr(100)=             2.2017744639D0
	rhoarr(101)=             1.9607380444D0
	rhoarr(102)=             1.7453833181D0
	rhoarr(103)=             1.5521410948D0
	rhoarr(104)=             1.3782166040D0
	rhoarr(105)=             1.2214692554D0
	rhoarr(106)=             1.0802545387D0
	rhoarr(107)=             0.9532611716D0
	rhoarr(108)=             0.8393686079D0
	rhoarr(109)=             0.7375405721D0
	rhoarr(110)=             0.6467607607D0
	rhoarr(111)=             0.5660085055D0
	rhoarr(112)=             0.4942660597D0
	rhoarr(113)=             0.4305457752D0
	rhoarr(114)=             0.3739248173D0
	rhoarr(115)=             0.3235767144D0
	rhoarr(116)=             0.2787921941D0
	rhoarr(117)=             0.2389855144D0
	rhoarr(118)=             0.2036861165D0
	rhoarr(119)=             0.1725183572D0
	rhoarr(120)=             0.1451739984D0
	rhoarr(121)=             0.1213829267D0
	rhoarr(122)=             0.1008872418D0
	rhoarr(123)=             0.0834225666D0
	rhoarr(124)=             0.0687085128D0
	rhoarr(125)=             0.0564481551D0
	rhoarr(126)=             0.0463346189D0
	rhoarr(127)=             0.0380618606D0
	rhoarr(128)=             0.0313365572D0
	rhoarr(129)=             0.0258885789D0
	rhoarr(130)=             0.0214784769D0
	rhoarr(131)=             0.0179014100D0
	rhoarr(132)=             0.0149876976D0
	rhoarr(133)=             0.0126006490D0
	rhoarr(134)=             0.0106325152D0
	rhoarr(135)=             0.0089994478D0
	rhoarr(136)=             0.0076362923D0
	rhoarr(137)=             0.0064919034D0
	rhoarr(138)=             0.0055254420D0
	rhoarr(139)=             0.0047038098D0
	rhoarr(140)=             0.0040000928D0
	rhoarr(141)=             0.0033926787D0
	rhoarr(142)=             0.0028646748D0
	rhoarr(143)=             0.0024033403D0
	rhoarr(144)=             0.0019994011D0
	rhoarr(145)=             0.0016462585D0
	rhoarr(146)=             0.0013391734D0
	rhoarr(147)=             0.0010745200D0
	rhoarr(148)=             0.0008491801D0
	rhoarr(149)=             0.0006601131D0
	rhoarr(150)=             0.0005041119D0
	rhoarr(151)=             0.0003777267D0
	rhoarr(152)=             0.0002773181D0
	rhoarr(153)=             0.0001991834D0
	rhoarr(154)=             0.0001397055D0
	rhoarr(155)=             0.0000954839D0
	rhoarr(156)=             0.0000634325D0
	rhoarr(157)=             0.0000408392D0
	rhoarr(158)=             0.0000253944D0
	rhoarr(159)=             0.0000151914D0
	rhoarr(160)=             0.0000087054D0
	rhoarr(161)=             0.0000047576D0
	rhoarr(162)=             0.0000024693D0
	rhoarr(163)=             0.0000012129D0
	rhoarr(164)=             0.0000005625D0
	rhoarr(165)=             0.0000002459D0
	rhoarr(166)=             0.0000001012D0
	rhoarr(167)=             0.0000000390D0
	rhoarr(168)=             0.0000000139D0

else if (iele==101) then  !Md, 5f13 7s2, 0 2, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      53156587.2411376387D0
	rhoarr(  2)=      18341207.0844229460D0
	rhoarr(  3)=       8937435.5581319351D0
	rhoarr(  4)=       5062570.2287425203D0
	rhoarr(  5)=       3089590.5913676894D0
	rhoarr(  6)=       1955416.2453665317D0
	rhoarr(  7)=       1264382.1234860141D0
	rhoarr(  8)=        823122.2805801803D0
	rhoarr(  9)=        536556.2547334491D0
	rhoarr( 10)=        351191.6061863821D0
	rhoarr( 11)=        231552.8628522470D0
	rhoarr( 12)=        154406.2750218818D0
	rhoarr( 13)=        104896.7207390852D0
	rhoarr( 14)=         73485.7700568102D0
	rhoarr( 15)=         53863.5832384537D0
	rhoarr( 16)=         41696.6611584991D0
	rhoarr( 17)=         34042.6258997969D0
	rhoarr( 18)=         28975.4072704517D0
	rhoarr( 19)=         25294.8068383544D0
	rhoarr( 20)=         22306.7949966934D0
	rhoarr( 21)=         19648.3365823581D0
	rhoarr( 22)=         17157.6281972372D0
	rhoarr( 23)=         14789.9232600705D0
	rhoarr( 24)=         12563.7065815242D0
	rhoarr( 25)=         10523.0159846146D0
	rhoarr( 26)=          8711.3271222556D0
	rhoarr( 27)=          7156.9613687713D0
	rhoarr( 28)=          5868.4514754211D0
	rhoarr( 29)=          4836.0156298736D0
	rhoarr( 30)=          4035.4661565653D0
	rhoarr( 31)=          3432.7245137655D0
	rhoarr( 32)=          2988.5191527918D0
	rhoarr( 33)=          2663.0146601485D0
	rhoarr( 34)=          2419.7593080499D0
	rhoarr( 35)=          2228.3092736669D0
	rhoarr( 36)=          2065.3316409799D0
	rhoarr( 37)=          1914.4992876819D0
	rhoarr( 38)=          1765.7070655571D0
	rhoarr( 39)=          1614.0316765735D0
	rhoarr( 40)=          1458.6259006366D0
	rhoarr( 41)=          1301.5782902960D0
	rhoarr( 42)=          1146.7476661214D0
	rhoarr( 43)=           998.6429527332D0
	rhoarr( 44)=           861.4721048276D0
	rhoarr( 45)=           738.4756204732D0
	rhoarr( 46)=           631.5953250033D0
	rhoarr( 47)=           541.4474128678D0
	rhoarr( 48)=           467.5095574777D0
	rhoarr( 49)=           408.4132878493D0
	rhoarr( 50)=           362.2500232269D0
	rhoarr( 51)=           326.8348929047D0
	rhoarr( 52)=           299.9087682665D0
	rhoarr( 53)=           279.2842132438D0
	rhoarr( 54)=           262.9516916302D0
	rhoarr( 55)=           249.1608111603D0
	rhoarr( 56)=           236.4832455229D0
	rhoarr( 57)=           223.8553322096D0
	rhoarr( 58)=           210.5936851926D0
	rhoarr( 59)=           196.3781911790D0
	rhoarr( 60)=           181.2023159314D0
	rhoarr( 61)=           165.2977428628D0
	rhoarr( 62)=           149.0458124842D0
	rhoarr( 63)=           132.8900511025D0
	rhoarr( 64)=           117.2620712153D0
	rhoarr( 65)=           102.5285298775D0
	rhoarr( 66)=            88.9614625635D0
	rhoarr( 67)=            76.7297407302D0
	rhoarr( 68)=            65.9065034864D0
	rhoarr( 69)=            56.4863306481D0
	rhoarr( 70)=            48.4063071955D0
	rhoarr( 71)=            41.5664307805D0
	rhoarr( 72)=            35.8465024665D0
	rhoarr( 73)=            31.1182982730D0
	rhoarr( 74)=            27.2531621520D0
	rhoarr( 75)=            24.1260336200D0
	rhoarr( 76)=            21.6172866861D0
	rhoarr( 77)=            19.6136773422D0
	rhoarr( 78)=            18.0093196891D0
	rhoarr( 79)=            16.7071150962D0
	rhoarr( 80)=            15.6206071852D0
	rhoarr( 81)=            14.6759342608D0
	rhoarr( 82)=            13.8134357288D0
	rhoarr( 83)=            12.9885161638D0
	rhoarr( 84)=            12.1715225849D0
	rhoarr( 85)=            11.3465831961D0
	rhoarr( 86)=            10.5095370190D0
	rhoarr( 87)=             9.6652198163D0
	rhoarr( 88)=             8.8244466127D0
	rhoarr( 89)=             8.0010427165D0
	rhoarr( 90)=             7.2092309318D0
	rhoarr( 91)=             6.4615971028D0
	rhoarr( 92)=             5.7677483146D0
	rhoarr( 93)=             5.1336688214D0
	rhoarr( 94)=             4.5616868248D0
	rhoarr( 95)=             4.0509036402D0
	rhoarr( 96)=             3.5979105323D0
	rhoarr( 97)=             3.1976244743D0
	rhoarr( 98)=             2.8441034086D0
	rhoarr( 99)=             2.5312430420D0
	rhoarr(100)=             2.2533005355D0
	rhoarr(101)=             2.0052284238D0
	rhoarr(102)=             1.7828309884D0
	rhoarr(103)=             1.5827742527D0
	rhoarr(104)=             1.4024906351D0
	rhoarr(105)=             1.2400216743D0
	rhoarr(106)=             1.0938388348D0
	rhoarr(107)=             0.9626748774D0
	rhoarr(108)=             0.8453882674D0
	rhoarr(109)=             0.7408722553D0
	rhoarr(110)=             0.6480101815D0
	rhoarr(111)=             0.5656705499D0
	rhoarr(112)=             0.4927303047D0
	rhoarr(113)=             0.4281127636D0
	rhoarr(114)=             0.3708274240D0
	rhoarr(115)=             0.3200016104D0
	rhoarr(116)=             0.2748977407D0
	rhoarr(117)=             0.2349139942D0
	rhoarr(118)=             0.1995697262D0
	rhoarr(119)=             0.1684796559D0
	rhoarr(120)=             0.1413224250D0
	rhoarr(121)=             0.1178094866D0
	rhoarr(122)=             0.0976594780D0
	rhoarr(123)=             0.0805814967D0
	rhoarr(124)=             0.0662684550D0
	rhoarr(125)=             0.0543995010D0
	rhoarr(126)=             0.0446488826D0
	rhoarr(127)=             0.0366979196D0
	rhoarr(128)=             0.0302469518D0
	rhoarr(129)=             0.0250249770D0
	rhoarr(130)=             0.0207957831D0
	rhoarr(131)=             0.0173603590D0
	rhoarr(132)=             0.0145560357D0
	rhoarr(133)=             0.0122531620D0
	rhoarr(134)=             0.0103502349D0
	rhoarr(135)=             0.0087683971D0
	rhoarr(136)=             0.0074461152D0
	rhoarr(137)=             0.0063346615D0
	rhoarr(138)=             0.0053947499D0
	rhoarr(139)=             0.0045943477D0
	rhoarr(140)=             0.0039074167D0
	rhoarr(141)=             0.0033131918D0
	rhoarr(142)=             0.0027956299D0
	rhoarr(143)=             0.0023427896D0
	rhoarr(144)=             0.0019460749D0
	rhoarr(145)=             0.0015993917D0
	rhoarr(146)=             0.0012983169D0
	rhoarr(147)=             0.0010393705D0
	rhoarr(148)=             0.0008194506D0
	rhoarr(149)=             0.0006354534D0
	rhoarr(150)=             0.0004840801D0
	rhoarr(151)=             0.0003618008D0
	rhoarr(152)=             0.0002649304D0
	rhoarr(153)=             0.0001897612D0
	rhoarr(154)=             0.0001327044D0
	rhoarr(155)=             0.0000904102D0
	rhoarr(156)=             0.0000598541D0
	rhoarr(157)=             0.0000383901D0
	rhoarr(158)=             0.0000237734D0
	rhoarr(159)=             0.0000141584D0
	rhoarr(160)=             0.0000080750D0
	rhoarr(161)=             0.0000043913D0
	rhoarr(162)=             0.0000022680D0
	rhoarr(163)=             0.0000011089D0
	rhoarr(164)=             0.0000005121D0
	rhoarr(165)=             0.0000002231D0
	rhoarr(166)=             0.0000000914D0
	rhoarr(167)=             0.0000000350D0
	rhoarr(168)=             0.0000000124D0

else if (iele==102) then  !No, 5f14 7s2, 0 1, B3LYP/SARC-DKH int=dkh2
	npt=  168
	rhoarr(  1)=      58453888.6040268838D0
	rhoarr(  2)=      19788623.5566331595D0
	rhoarr(  3)=       9526119.5541281719D0
	rhoarr(  4)=       5347167.0262260931D0
	rhoarr(  5)=       3240247.6861626245D0
	rhoarr(  6)=       2036705.9071201896D0
	rhoarr(  7)=       1308419.4964052110D0
	rhoarr(  8)=        846084.4050827031D0
	rhoarr(  9)=        547946.8870592709D0
	rhoarr( 10)=        356582.6284875763D0
	rhoarr( 11)=        234007.1063303525D0
	rhoarr( 12)=        155534.7156847853D0
	rhoarr( 13)=        105518.2220582886D0
	rhoarr( 14)=         74003.1257459271D0
	rhoarr( 15)=         54443.3265661668D0
	rhoarr( 16)=         42369.2693228210D0
	rhoarr( 17)=         34772.2944316382D0
	rhoarr( 18)=         29704.3572647133D0
	rhoarr( 19)=         25969.4923618675D0
	rhoarr( 20)=         22889.8487106646D0
	rhoarr( 21)=         20120.4937965123D0
	rhoarr( 22)=         17515.3468983769D0
	rhoarr( 23)=         15041.9303107251D0
	rhoarr( 24)=         12727.1010022237D0
	rhoarr( 25)=         10619.1093564969D0
	rhoarr( 26)=          8761.8606697706D0
	rhoarr( 27)=          7181.3633678285D0
	rhoarr( 28)=          5882.3060801063D0
	rhoarr( 29)=          4850.4760439396D0
	rhoarr( 30)=          4057.2824823359D0
	rhoarr( 31)=          3464.7097889146D0
	rhoarr( 32)=          3030.3641564312D0
	rhoarr( 33)=          2712.3121585072D0
	rhoarr( 34)=          2473.0315051835D0
	rhoarr( 35)=          2281.8557830124D0
	rhoarr( 36)=          2115.8174818360D0
	rhoarr( 37)=          1959.3032056140D0
	rhoarr( 38)=          1803.0938472349D0
	rhoarr( 39)=          1643.2008518524D0
	rhoarr( 40)=          1479.6603309399D0
	rhoarr( 41)=          1315.3020256436D0
	rhoarr( 42)=          1154.5107740838D0
	rhoarr( 43)=          1002.0689259114D0
	rhoarr( 44)=           862.2137930704D0
	rhoarr( 45)=           738.0200800341D0
	rhoarr( 46)=           631.1397589977D0
	rhoarr( 47)=           541.8469688671D0
	rhoarr( 48)=           469.2818658188D0
	rhoarr( 49)=           411.7781820831D0
	rhoarr( 50)=           367.1848450956D0
	rhoarr( 51)=           333.1323635737D0
	rhoarr( 52)=           307.2315730631D0
	rhoarr( 53)=           287.2154740392D0
	rhoarr( 54)=           271.0424049347D0
	rhoarr( 55)=           256.9745850670D0
	rhoarr( 56)=           243.6366252228D0
	rhoarr( 57)=           230.0502202518D0
	rhoarr( 58)=           215.6379813028D0
	rhoarr( 59)=           200.1921187334D0
	rhoarr( 60)=           183.8104439256D0
	rhoarr( 61)=           166.8094371181D0
	rhoarr( 62)=           149.6287748486D0
	rhoarr( 63)=           132.7421953595D0
	rhoarr( 64)=           116.5862772980D0
	rhoarr( 65)=           101.5132719402D0
	rhoarr( 66)=            87.7685173999D0
	rhoarr( 67)=            75.4886396358D0
	rhoarr( 68)=            64.7143585196D0
	rhoarr( 69)=            55.4111975259D0
	rhoarr( 70)=            47.4922558055D0
	rhoarr( 71)=            40.8388348348D0
	rhoarr( 72)=            35.3165767528D0
	rhoarr( 73)=            30.7864628780D0
	rhoarr( 74)=            27.1112802840D0
	rhoarr( 75)=            24.1588727593D0
	rhoarr( 76)=            21.8036608655D0
	rhoarr( 77)=            19.9276636508D0
	rhoarr( 78)=            18.4217681057D0
	rhoarr( 79)=            17.1874672992D0
	rhoarr( 80)=            16.1388755674D0
	rhoarr( 81)=            15.2046055859D0
	rhoarr( 82)=            14.3290595738D0
	rhoarr( 83)=            13.4727965656D0
	rhoarr( 84)=            12.6118218389D0
	rhoarr( 85)=            11.7358413401D0
	rhoarr( 86)=            10.8456896982D0
	rhoarr( 87)=             9.9502511205D0
	rhoarr( 88)=             9.0632394747D0
	rhoarr( 89)=             8.2001893347D0
	rhoarr( 90)=             7.3759437585D0
	rhoarr( 91)=             6.6028233777D0
	rhoarr( 92)=             5.8895455249D0
	rhoarr( 93)=             5.2408529755D0
	rhoarr( 94)=             4.6577273164D0
	rhoarr( 95)=             4.1380126058D0
	rhoarr( 96)=             3.6772625422D0
	rhoarr( 97)=             3.2696426201D0
	rhoarr( 98)=             2.9087568332D0
	rhoarr( 99)=             2.5883146172D0
	rhoarr(100)=             2.3025982872D0
	rhoarr(101)=             2.0467281417D0
	rhoarr(102)=             1.8167490651D0
	rhoarr(103)=             1.6095787328D0
	rhoarr(104)=             1.4228645652D0
	rhoarr(105)=             1.2547960855D0
	rhoarr(106)=             1.1039131094D0
	rhoarr(107)=             0.9689401282D0
	rhoarr(108)=             0.8486653061D0
	rhoarr(109)=             0.7418706571D0
	rhoarr(110)=             0.6473099021D0
	rhoarr(111)=             0.5637234171D0
	rhoarr(112)=             0.4898760619D0
	rhoarr(113)=             0.4246033000D0
	rhoarr(114)=             0.3668531509D0
	rhoarr(115)=             0.3157151792D0
	rhoarr(116)=             0.2704319650D0
	rhoarr(117)=             0.2303925706D0
	rhoarr(118)=             0.1951108983D0
	rhoarr(119)=             0.1641941983D0
	rhoarr(120)=             0.1373081325D0
	rhoarr(121)=             0.1141446546D0
	rhoarr(122)=             0.0943976239D0
	rhoarr(123)=             0.0777488747D0
	rhoarr(124)=             0.0638649584D0
	rhoarr(125)=             0.0524026067D0
	rhoarr(126)=             0.0430196206D0
	rhoarr(127)=             0.0353875910D0
	rhoarr(128)=             0.0292034360D0
	rhoarr(129)=             0.0241978361D0
	rhoarr(130)=             0.0201397928D0
	rhoarr(131)=             0.0168374476D0
	rhoarr(132)=             0.0141358401D0
	rhoarr(133)=             0.0119125255D0
	rhoarr(134)=             0.0100720251D0
	rhoarr(135)=             0.0085400266D0
	rhoarr(136)=             0.0072581080D0
	rhoarr(137)=             0.0061795179D0
	rhoarr(138)=             0.0052662227D0
	rhoarr(139)=             0.0044871054D0
	rhoarr(140)=             0.0038169674D0
	rhoarr(141)=             0.0032359133D0
	rhoarr(142)=             0.0027287805D0
	rhoarr(143)=             0.0022844424D0
	rhoarr(144)=             0.0018949742D0
	rhoarr(145)=             0.0015547647D0
	rhoarr(146)=             0.0012596818D0
	rhoarr(147)=             0.0010063719D0
	rhoarr(148)=             0.0007917402D0
	rhoarr(149)=             0.0006126248D0
	rhoarr(150)=             0.0004656507D0
	rhoarr(151)=             0.0003472291D0
	rhoarr(152)=             0.0002536505D0
	rhoarr(153)=             0.0001812184D0
	rhoarr(154)=             0.0001263821D0
	rhoarr(155)=             0.0000858460D0
	rhoarr(156)=             0.0000566476D0
	rhoarr(157)=             0.0000362044D0
	rhoarr(158)=             0.0000223331D0
	rhoarr(159)=             0.0000132449D0
	rhoarr(160)=             0.0000075205D0
	rhoarr(161)=             0.0000040711D0
	rhoarr(162)=             0.0000020932D0
	rhoarr(163)=             0.0000010192D0
	rhoarr(164)=             0.0000004690D0
	rhoarr(165)=             0.0000002036D0
	rhoarr(166)=             0.0000000832D0
	rhoarr(167)=             0.0000000317D0
	rhoarr(168)=             0.0000000111D0

else if (iele==103) then  !Lr, 5f14 6d1 7s2, 0 2, B3LYP/SARC-DKH int=dkh2
	npt=  166
	rhoarr(  1)=      64309505.3489567265D0
	rhoarr(  2)=      21354656.1100468449D0
	rhoarr(  3)=      10153710.0862072464D0
	rhoarr(  4)=       5646999.9445600351D0
	rhoarr(  5)=       3397448.7289351681D0
	rhoarr(  6)=       2120695.3171131290D0
	rhoarr(  7)=       1353423.9294505094D0
	rhoarr(  8)=        869227.2041488759D0
	rhoarr(  9)=        559239.8792785053D0
	rhoarr( 10)=        361831.1261154881D0
	rhoarr( 11)=        236355.4851193388D0
	rhoarr( 12)=        156608.5773240460D0
	rhoarr( 13)=        106128.9246567579D0
	rhoarr( 14)=         74541.0174570115D0
	rhoarr( 15)=         55061.1384265823D0
	rhoarr( 16)=         43085.2236123526D0
	rhoarr( 17)=         35541.6089088582D0
	rhoarr( 18)=         30464.0934193849D0
	rhoarr( 19)=         26664.3806446231D0
	rhoarr( 20)=         23483.1324884657D0
	rhoarr( 21)=         20594.7760276991D0
	rhoarr( 22)=         17869.5093004341D0
	rhoarr( 23)=         15287.2159629112D0
	rhoarr( 24)=         12882.8473211355D0
	rhoarr( 25)=         10708.3275549974D0
	rhoarr( 26)=          8807.3554355120D0
	rhoarr( 27)=          7203.0380590412D0
	rhoarr( 28)=          5895.7490072606D0
	rhoarr( 29)=          4866.5015394423D0
	rhoarr( 30)=          4082.0840629328D0
	rhoarr( 31)=          3500.4535560421D0
	rhoarr( 32)=          3076.1229550737D0
	rhoarr( 33)=          2765.1777891060D0
	rhoarr( 34)=          2529.1838301722D0
	rhoarr( 35)=          2337.4114612664D0
	rhoarr( 36)=          2167.3960928991D0
	rhoarr( 37)=          2004.3475048861D0
	rhoarr( 38)=          1840.0145372580D0
	rhoarr( 39)=          1671.3972858155D0
	rhoarr( 40)=          1499.4385890754D0
	rhoarr( 41)=          1327.7012831203D0
	rhoarr( 42)=          1161.0607972761D0
	rhoarr( 43)=          1004.5198188956D0
	rhoarr( 44)=           862.2865773384D0
	rhoarr( 45)=           737.2171380982D0
	rhoarr( 46)=           630.6331212331D0
	rhoarr( 47)=           542.4403884361D0
	rhoarr( 48)=           471.4279720054D0
	rhoarr( 49)=           415.6275551064D0
	rhoarr( 50)=           372.6475423653D0
	rhoarr( 51)=           339.9399189752D0
	rhoarr( 52)=           314.9947266123D0
	rhoarr( 53)=           295.4774295183D0
	rhoarr( 54)=           279.3286563291D0
	rhoarr( 55)=           264.8391121589D0
	rhoarr( 56)=           250.7020960274D0
	rhoarr( 57)=           236.0383411901D0
	rhoarr( 58)=           220.3862944203D0
	rhoarr( 59)=           203.6554206163D0
	rhoarr( 60)=           186.0478324410D0
	rhoarr( 61)=           167.9606614624D0
	rhoarr( 62)=           149.8851510064D0
	rhoarr( 63)=           132.3174856521D0
	rhoarr( 64)=           115.6918320127D0
	rhoarr( 65)=           100.3399567227D0
	rhoarr( 66)=            86.4761133774D0
	rhoarr( 67)=            74.2019447749D0
	rhoarr( 68)=            63.5243364620D0
	rhoarr( 69)=            54.3792111136D0
	rhoarr( 70)=            46.6555680098D0
	rhoarr( 71)=            40.2159981597D0
	rhoarr( 72)=            34.9119001997D0
	rhoarr( 73)=            30.5932983890D0
	rhoarr( 74)=            27.1142960466D0
	rhoarr( 75)=            24.3357143137D0
	rhoarr( 76)=            22.1264354362D0
	rhoarr( 77)=            20.3645643107D0
	rhoarr( 78)=            18.9389600608D0
	rhoarr( 79)=            17.7511688674D0
	rhoarr( 80)=            16.7174381993D0
	rhoarr( 81)=            15.7703524804D0
	rhoarr( 82)=            14.8596718816D0
	rhoarr( 83)=            13.9521129473D0
	rhoarr( 84)=            13.0300112089D0
	rhoarr( 85)=            12.0889964652D0
	rhoarr( 86)=            11.1349570211D0
	rhoarr( 87)=            10.1806539290D0
	rhoarr( 88)=             9.2423666459D0
	rhoarr( 89)=             8.3369125843D0
	rhoarr( 90)=             7.4792969965D0
	rhoarr( 91)=             6.6811348284D0
	rhoarr( 92)=             5.9498647367D0
	rhoarr( 93)=             5.2886691026D0
	rhoarr( 94)=             4.6969390218D0
	rhoarr( 95)=             4.1710875747D0
	rhoarr( 96)=             3.7055163670D0
	rhoarr( 97)=             3.2935703184D0
	rhoarr( 98)=             2.9283615804D0
	rhoarr( 99)=             2.6033934323D0
	rhoarr(100)=             2.3129602689D0
	rhoarr(101)=             2.0523354063D0
	rhoarr(102)=             1.8177827058D0
	rhoarr(103)=             1.6064413130D0
	rhoarr(104)=             1.4161365700D0
	rhoarr(105)=             1.2451662347D0
	rhoarr(106)=             1.0921016338D0
	rhoarr(107)=             0.9556305799D0
	rhoarr(108)=             0.8344551695D0
	rhoarr(109)=             0.7272451417D0
	rhoarr(110)=             0.6326379971D0
	rhoarr(111)=             0.5492714215D0
	rhoarr(112)=             0.4758317611D0
	rhoarr(113)=             0.4111036605D0
	rhoarr(114)=             0.3540094490D0
	rhoarr(115)=             0.3036313252D0
	rhoarr(116)=             0.2592139318D0
	rhoarr(117)=             0.2201488998D0
	rhoarr(118)=             0.1859459686D0
	rhoarr(119)=             0.1561971154D0
	rhoarr(120)=             0.1305406078D0
	rhoarr(121)=             0.1086310293D0
	rhoarr(122)=             0.0901193502D0
	rhoarr(123)=             0.0746445043D0
	rhoarr(124)=             0.0618353614D0
	rhoarr(125)=             0.0513200781D0
	rhoarr(126)=             0.0427389737D0
	rhoarr(127)=             0.0357573180D0
	rhoarr(128)=             0.0300754300D0
	rhoarr(129)=             0.0254347801D0
	rhoarr(130)=             0.0216199383D0
	rhoarr(131)=             0.0184569738D0
	rhoarr(132)=             0.0158092746D0
	rhoarr(133)=             0.0135718268D0
	rhoarr(134)=             0.0116649157D0
	rhoarr(135)=             0.0100280651D0
	rhoarr(136)=             0.0086148263D0
	rhoarr(137)=             0.0073887652D0
	rhoarr(138)=             0.0063207023D0
	rhoarr(139)=             0.0053870007D0
	rhoarr(140)=             0.0045685485D0
	rhoarr(141)=             0.0038500768D0
	rhoarr(142)=             0.0032195602D0
	rhoarr(143)=             0.0026675889D0
	rhoarr(144)=             0.0021867179D0
	rhoarr(145)=             0.0017708481D0
	rhoarr(146)=             0.0014146913D0
	rhoarr(147)=             0.0011133461D0
	rhoarr(148)=             0.0008619949D0
	rhoarr(149)=             0.0006557207D0
	rhoarr(150)=             0.0004894436D0
	rhoarr(151)=             0.0003579668D0
	rhoarr(152)=             0.0002561053D0
	rhoarr(153)=             0.0001788605D0
	rhoarr(154)=             0.0001215944D0
	rhoarr(155)=             0.0000801658D0
	rhoarr(156)=             0.0000510059D0
	rhoarr(157)=             0.0000311292D0
	rhoarr(158)=             0.0000180943D0
	rhoarr(159)=             0.0000099403D0
	rhoarr(160)=             0.0000051228D0
	rhoarr(161)=             0.0000024618D0
	rhoarr(162)=             0.0000010999D0
	rhoarr(163)=             0.0000004577D0
	rhoarr(164)=             0.0000001787D0
	rhoarr(165)=             0.0000000662D0
	rhoarr(166)=             0.0000000235D0

else
	write(*,"(' Error: The promolecular density for the element with index of',i4,' has not been supported yet!')") iele
	read(*,*)
end if

end subroutine





!!--------- Return parameters of crude STO fitting of radial atomic electron density
!iele (input): Index of element
!nSTO (output): Number of STO for fitting. 1 for first row, 2 for second row, 4 for third and fourth rows, 6 for others. But redundant STOs may be removed
!atomcoeff (output): Fitting coefficients of STOs
!atomexp (output): Exponents of STOs
!
!  The atomic wavefunction files are the same as those for generating subroutine genatmraddens
!  The electron density quality produced by parameters given by this subroutine is evidently not as good as genatmraddens &
!because the fitting is not pretty accurate, the advantage is that there is no upper limit of distance
!  The density produced by the STOs is non-negative everywhere, and the integral equals to actual number of electrons

!  Command of Multiwfn used for generating the codes in this subroutine (relative error minimization): 300-2-3-2-0-1-8
!  I have visually checked fitted density vs. actual density on radial direction
!  Relative error minimization was used by default, however F He Kr N Ne O Si Xe usde rdf error minimization to reach much better result. &
!For Ar Cl Zn, the two kinds minimizations were used interchangedly to reach better result. &
!Unfortunately, Ca K Sc Ti still have relatively larger error in inner-valence region but there is no space to further improve, may be increasing number of STOs is helpful
subroutine genatmraddens_STOfitparm(iele,nSTO,atomcoeff,atomexp)
integer iele,nSTO
real*8 atomcoeff(10),atomexp(10)

select case(iele)
case(  1)
    nSTO= 1
    atomcoeff( 1)=  3.24527029D-01
    atomexp( 1)=  2.01293729D+00
case(  2)
    nSTO= 1
    atomcoeff( 1)=  2.99950256D+00
    atomexp( 1)=  3.35289305D+00
case(  3)
    nSTO= 2
    atomcoeff( 1)=  3.02835250D-02
    atomcoeff( 2)=  1.51533029D+01
    atomexp( 1)=  8.73681191D-01
    atomexp( 2)=  5.89535640D+00
case(  4)
    nSTO= 2
    atomcoeff( 1)=  2.22991371D-01
    atomcoeff( 2)=  4.59371349D+01
    atomexp( 1)=  1.34349625D+00
    atomexp( 2)=  8.80913338D+00
case(  5)
    nSTO= 2
    atomcoeff( 1)=  5.75557543D-01
    atomcoeff( 2)=  8.88614570D+01
    atomexp( 1)=  1.62732155D+00
    atomexp( 2)=  1.10766744D+01
case(  6)
    nSTO= 2
    atomcoeff( 1)=  1.52509711D+00
    atomcoeff( 2)=  1.54546519D+02
    atomexp( 1)=  2.03463240D+00
    atomexp( 2)=  1.38904060D+01
case(  7)
    nSTO= 2
    atomcoeff( 1)=  2.23491055D+00
    atomcoeff( 2)=  2.25184864D+02
    atomexp( 1)=  2.19186307D+00
    atomexp( 2)=  1.50328690D+01
case(  8)
    nSTO= 2
    atomcoeff( 1)=  4.14950638D+00
    atomcoeff( 2)=  3.47928470D+02
    atomexp( 1)=  2.54173360D+00
    atomexp( 2)=  1.74384673D+01
case(  9)
    nSTO= 2
    atomcoeff( 1)=  7.14588143D+00
    atomcoeff( 2)=  5.09003943D+02
    atomexp( 1)=  2.89870829D+00
    atomexp( 2)=  1.98875707D+01
case( 10)
    nSTO= 1
    atomcoeff( 1)=  3.47447596D+01
    atomexp( 1)=  4.43652626D+00
case( 11)
    nSTO= 4
    atomcoeff( 1)=  4.25011991D-02
    atomcoeff( 2)=  7.84606895D+02
    atomcoeff( 3)= -7.96449268D+02
    atomcoeff( 4)=  8.31960572D+02
    atomexp( 1)=  9.10761646D-01
    atomexp( 2)=  5.44721570D+00
    atomexp( 3)=  5.59153465D+00
    atomexp( 4)=  2.15697893D+01
case( 12)
    nSTO= 4
    atomcoeff( 1)=  1.94285116D-01
    atomcoeff( 2)=  2.28757254D+03
    atomcoeff( 3)= -2.39624565D+03
    atomcoeff( 4)=  1.06842904D+03
    atomexp( 1)=  1.19847860D+00
    atomexp( 2)=  7.19230027D+00
    atomexp( 3)=  7.40255350D+00
    atomexp( 4)=  2.05375679D+01
case( 13)
    nSTO= 4
    atomcoeff( 1)=  3.13552180D-01
    atomcoeff( 2)=  4.38764010D+03
    atomcoeff( 3)= -4.58551094D+03
    atomcoeff( 4)=  1.43005519D+03
    atomexp( 1)=  1.26578321D+00
    atomexp( 2)=  8.31755780D+00
    atomexp( 3)=  8.52525372D+00
    atomexp( 4)=  2.17932251D+01
case( 14)
    nSTO= 4
    atomcoeff( 1)=  8.33117538D+00
    atomcoeff( 2)= -3.61993184D+02
    atomcoeff( 3)=  4.03055332D+02
    atomcoeff( 4)=  2.18274869D+03
    atomexp( 1)=  2.17628332D+00
    atomexp( 2)=  3.52668757D+00
    atomexp( 3)=  3.70260548D+00
    atomexp( 4)=  3.29292721D+01
case( 15)
    nSTO= 4
    atomcoeff( 1)= -2.80966000D+00
    atomcoeff( 2)=  3.90622061D+00
    atomcoeff( 3)=  1.34650608D+02
    atomcoeff( 4)=  2.74975644D+03
    atomexp( 1)=  1.47094492D+00
    atomexp( 2)=  1.50675522D+00
    atomexp( 3)=  7.70891888D+00
    atomexp( 4)=  3.97396749D+01
case( 16)
    nSTO= 4
    atomcoeff( 1)=  2.97740990D+00
    atomcoeff( 2)= -7.09689963D+02
    atomcoeff( 3)=  8.19673116D+02
    atomcoeff( 4)=  3.12059153D+03
    atomexp( 1)=  1.95155432D+00
    atomexp( 2)=  5.22316921D+00
    atomexp( 3)=  5.41367408D+00
    atomexp( 4)=  3.95771130D+01
case( 17)
    nSTO= 4
    atomcoeff( 1)=  5.30814547D+00
    atomcoeff( 2)= -9.99390894D+02
    atomcoeff( 3)=  1.13102402D+03
    atomcoeff( 4)=  3.69529175D+03
    atomexp( 1)=  2.18951892D+00
    atomexp( 2)=  5.43883857D+00
    atomexp( 3)=  5.63188987D+00
    atomexp( 4)=  4.17015497D+01
case( 18)
    nSTO= 4
    atomcoeff( 1)=  3.54085786D+02
    atomcoeff( 2)= -3.57841956D+02
    atomcoeff( 3)=  2.26530751D+02
    atomcoeff( 4)=  4.58584856D+03
    atomexp( 1)=  2.71749664D+00
    atomexp( 2)=  2.74331722D+00
    atomexp( 3)=  8.58369683D+00
    atomexp( 4)=  4.62297466D+01
case( 19)
    nSTO= 4
    atomcoeff( 1)=  2.21300951D-02
    atomcoeff( 2)=  7.57713775D+00
    atomcoeff( 3)=  4.17684964D+02
    atomcoeff( 4)=  6.24996545D+03
    atomexp( 1)=  7.08705922D-01
    atomexp( 2)=  2.66805888D+00
    atomexp( 3)=  1.17764477D+01
    atomexp( 4)=  5.42613369D+01
case( 20)
    nSTO= 4
    atomcoeff( 1)=  1.18804183D-01
    atomcoeff( 2)=  1.19829970D+01
    atomcoeff( 3)=  5.17589883D+02
    atomcoeff( 4)=  7.41474493D+03
    atomexp( 1)=  9.56052421D-01
    atomexp( 2)=  3.17809548D+00
    atomexp( 3)=  1.27851484D+01
    atomexp( 4)=  5.75753901D+01
case( 21)
    nSTO= 4
    atomcoeff( 1)=  1.39867952D-01
    atomcoeff( 2)=  1.46233017D+01
    atomcoeff( 3)=  6.21628726D+02
    atomcoeff( 4)=  8.63915477D+03
    atomexp( 1)=  9.89117728D-01
    atomexp( 2)=  3.30057803D+00
    atomexp( 3)=  1.36230131D+01
    atomexp( 4)=  6.07918377D+01
case( 22)
    nSTO= 4
    atomcoeff( 1)=  1.76005157D-01
    atomcoeff( 2)=  1.79641659D+01
    atomcoeff( 3)=  7.32152101D+02
    atomcoeff( 4)=  9.97932810D+03
    atomexp( 1)=  1.05429309D+00
    atomexp( 2)=  3.43248826D+00
    atomexp( 3)=  1.44447226D+01
    atomexp( 4)=  6.40186230D+01
case( 23)
    nSTO= 4
    atomcoeff( 1)=  2.09078797D-01
    atomcoeff( 2)=  2.20102054D+01
    atomcoeff( 3)=  8.55997914D+02
    atomcoeff( 4)=  1.14836044D+04
    atomexp( 1)=  1.10948988D+00
    atomexp( 2)=  3.56764219D+00
    atomexp( 3)=  1.52843308D+01
    atomexp( 4)=  6.73381730D+01
case( 24)
    nSTO= 4
    atomcoeff( 1)=  1.78265532D-01
    atomcoeff( 2)=  2.20631179D+01
    atomcoeff( 3)=  9.38191602D+02
    atomcoeff( 4)=  1.30583923D+04
    atomexp( 1)=  1.17806655D+00
    atomexp( 2)=  3.40334264D+00
    atomexp( 3)=  1.55767878D+01
    atomexp( 4)=  7.00610635D+01
case( 25)
    nSTO= 4
    atomcoeff( 1)=  2.50254554D-01
    atomcoeff( 2)=  3.25311250D+01
    atomcoeff( 3)=  1.12995081D+03
    atomcoeff( 4)=  1.49201774D+04
    atomexp( 1)=  1.18462397D+00
    atomexp( 2)=  3.84228582D+00
    atomexp( 3)=  1.69200584D+01
    atomexp( 4)=  7.36024486D+01
case( 26)
    nSTO= 4
    atomcoeff( 1)=  3.03168186D-01
    atomcoeff( 2)=  3.92099090D+01
    atomcoeff( 3)=  1.28530294D+03
    atomcoeff( 4)=  1.69201697D+04
    atomexp( 1)=  1.24720823D+00
    atomexp( 2)=  4.00431422D+00
    atomexp( 3)=  1.77393066D+01
    atomexp( 4)=  7.68252990D+01
case( 27)
    nSTO= 4
    atomcoeff( 1)= -4.30795187D-01
    atomcoeff( 2)=  6.95112680D-01
    atomcoeff( 3)=  4.61489161D+01
    atomcoeff( 4)=  2.06507342D+03
    atomexp( 1)=  1.07529103D+00
    atomexp( 2)=  1.12137872D+00
    atomexp( 3)=  4.07897989D+00
    atomexp( 4)=  2.02729919D+01
case( 28)
    nSTO= 4
    atomcoeff( 1)=  4.02997398D-01
    atomcoeff( 2)=  1.47323608D+02
    atomcoeff( 3)= -9.99546849D+02
    atomcoeff( 4)=  2.15970022D+03
    atomexp( 1)=  1.34937676D+00
    atomexp( 2)=  5.02748265D+00
    atomexp( 3)=  9.21620806D+00
    atomexp( 4)=  1.26473540D+01
case( 29)
    nSTO= 4
    atomcoeff( 1)=  2.04269268D-01
    atomcoeff( 2)=  6.15973166D+01
    atomcoeff( 3)= -4.72981042D+03
    atomcoeff( 4)=  6.42263069D+03
    atomexp( 1)=  1.27442972D+00
    atomexp( 2)=  4.16713783D+00
    atomexp( 3)=  1.34540043D+01
    atomexp( 4)=  1.44107121D+01
case( 30)
    nSTO= 3
    atomcoeff( 1)=  4.42381439D-01
    atomcoeff( 2)=  7.87427935D+01
    atomcoeff( 3)=  3.10588756D+03
    atomexp( 1)=  1.40687561D+00
    atomexp( 2)=  4.61385653D+00
    atomexp( 3)=  2.37077850D+01
case( 31)
    nSTO= 4
    atomcoeff( 1)=  8.71678259D-03
    atomcoeff( 2)=  6.17154886D-01
    atomcoeff( 3)=  9.59019197D+01
    atomcoeff( 4)=  3.51104939D+03
    atomexp( 1)=  8.44115733D-01
    atomexp( 2)=  1.48853199D+00
    atomexp( 3)=  4.92399181D+00
    atomexp( 4)=  2.48593510D+01
case( 32)
    nSTO= 4
    atomcoeff( 1)=  3.14556284D-04
    atomcoeff( 2)=  8.61670854D-01
    atomcoeff( 3)=  1.25850790D+02
    atomcoeff( 4)=  4.29632716D+03
    atomexp( 1)=  5.66350074D-01
    atomexp( 2)=  1.51175226D+00
    atomexp( 3)=  5.37966879D+00
    atomexp( 4)=  2.71881799D+01
case( 33)
    nSTO= 3
    atomcoeff( 1)=  1.35577235D+00
    atomcoeff( 2)=  1.62183552D+02
    atomcoeff( 3)=  5.28000758D+03
    atomexp( 1)=  1.63778843D+00
    atomexp( 2)=  5.86629438D+00
    atomexp( 3)=  2.97243689D+01
case( 34)
    nSTO= 4
    atomcoeff( 1)=  4.58047350D-03
    atomcoeff( 2)=  2.07905618D+00
    atomcoeff( 3)=  2.08994061D+02
    atomcoeff( 4)=  6.60288552D+03
    atomexp( 1)=  1.14075838D+00
    atomexp( 2)=  1.77580177D+00
    atomexp( 3)=  6.41466447D+00
    atomexp( 4)=  3.28259164D+01
case( 35)
    nSTO= 3
    atomcoeff( 1)=  2.94825465D+00
    atomcoeff( 2)=  2.59664481D+02
    atomcoeff( 3)=  8.20902131D+03
    atomexp( 1)=  1.89544392D+00
    atomexp( 2)=  6.91830766D+00
    atomexp( 3)=  3.60315239D+01
case( 36)
    nSTO= 4
    atomcoeff( 1)=  1.80006522D+03
    atomcoeff( 2)= -1.05980133D+04
    atomcoeff( 3)=  8.94293186D+03
    atomcoeff( 4)=  4.65534737D+03
    atomexp( 1)=  3.32063360D+00
    atomexp( 2)=  3.57974057D+00
    atomexp( 3)=  3.65569669D+00
    atomexp( 4)=  2.64443145D+01
case( 37)
    nSTO= 6
    atomcoeff( 1)=  2.13862294D-02
    atomcoeff( 2)=  7.72364090D+00
    atomcoeff( 3)=  3.66497860D+02
    atomcoeff( 4)=  4.52472076D+03
    atomcoeff( 5)=  1.27192085D+05
    atomcoeff( 6)= -8.06618129D+04
    atomexp( 1)=  6.89857752D-01
    atomexp( 2)=  2.45811466D+00
    atomexp( 3)=  8.10523021D+00
    atomexp( 4)=  3.03589187D+01
    atomexp( 5)=  1.31343345D+02
    atomexp( 6)=  1.61602718D+02
case( 38)
    nSTO= 5
    atomcoeff( 1)=  1.07183387D-01
    atomcoeff( 2)=  1.28782048D+01
    atomcoeff( 3)=  4.24886683D+02
    atomcoeff( 4)=  4.72059545D+03
    atomcoeff( 5)=  6.11081189D+04
    atomexp( 1)=  9.02921823D-01
    atomexp( 2)=  2.92096272D+00
    atomexp( 3)=  8.66301461D+00
    atomexp( 4)=  3.10681885D+01
    atomexp( 5)=  1.16473558D+02
case( 39)
    nSTO= 6
    atomcoeff( 1)=  1.61831671D-01
    atomcoeff( 2)=  1.40694247D+01
    atomcoeff( 3)=  4.89615167D+02
    atomcoeff( 4)=  5.33318614D+03
    atomcoeff( 5)=  1.37924546D+05
    atomcoeff( 6)= -8.04580317D+04
    atomexp( 1)=  9.75091888D-01
    atomexp( 2)=  3.00180324D+00
    atomexp( 3)=  9.03085424D+00
    atomexp( 4)=  3.25444062D+01
    atomexp( 5)=  1.37089566D+02
    atomexp( 6)=  1.71442746D+02
case( 40)
    nSTO= 6
    atomcoeff( 1)=  2.22390957D-01
    atomcoeff( 2)=  1.45835642D+01
    atomcoeff( 3)=  5.54921956D+02
    atomcoeff( 4)=  5.66429053D+03
    atomcoeff( 5)=  7.22983188D+04
    atomcoeff( 6)=  2.50050338D+04
    atomexp( 1)=  1.05226954D+00
    atomexp( 2)=  3.01134276D+00
    atomexp( 3)=  9.35158252D+00
    atomexp( 4)=  3.35940813D+01
    atomexp( 5)=  1.23199936D+02
    atomexp( 6)=  1.05123442D+03
case( 41)
    nSTO= 6
    atomcoeff( 1)=  3.21004677D-01
    atomcoeff( 2)=  1.27268092D+01
    atomcoeff( 3)=  6.22884372D+02
    atomcoeff( 4)=  6.25670941D+03
    atomcoeff( 5)=  8.09743316D+04
    atomcoeff( 6)= -3.04018667D+03
    atomexp( 1)=  1.21429850D+00
    atomexp( 2)=  2.83487928D+00
    atomexp( 3)=  9.57816594D+00
    atomexp( 4)=  3.49672157D+01
    atomexp( 5)=  1.28376097D+02
    atomexp( 6)=  4.41867347D+02
case( 42)
    nSTO= 6
    atomcoeff( 1)=  3.46052982D-01
    atomcoeff( 2)=  1.38078131D+01
    atomcoeff( 3)=  7.10926859D+02
    atomcoeff( 4)=  6.69785459D+03
    atomcoeff( 5)=  8.57524502D+04
    atomcoeff( 6)=  9.56333042D+04
    atomexp( 1)=  1.26535137D+00
    atomexp( 2)=  2.83435340D+00
    atomexp( 3)=  9.98857207D+00
    atomexp( 4)=  3.61501230D+01
    atomexp( 5)=  1.30325312D+02
    atomexp( 6)=  1.53700768D+03
case( 43)
    nSTO= 6
    atomcoeff( 1)=  2.83020951D-01
    atomcoeff( 2)=  1.80683680D+01
    atomcoeff( 3)=  8.28409139D+02
    atomcoeff( 4)=  7.47181073D+03
    atomcoeff( 5)=  2.07670543D+05
    atomcoeff( 6)= -1.23613197D+05
    atomexp( 1)=  1.16132707D+00
    atomexp( 2)=  3.01714447D+00
    atomexp( 3)=  1.05924040D+01
    atomexp( 4)=  3.78587659D+01
    atomexp( 5)=  1.53583972D+02
    atomexp( 6)=  1.84425544D+02
case( 44)
    nSTO= 6
    atomcoeff( 1)=  2.91381107D-01
    atomcoeff( 2)=  1.78601108D+01
    atomcoeff( 3)=  9.31414768D+02
    atomcoeff( 4)=  7.80794547D+03
    atomcoeff( 5)=  1.00979871D+05
    atomcoeff( 6)=  4.44675745D+04
    atomexp( 1)=  1.26819871D+00
    atomexp( 2)=  2.91043521D+00
    atomexp( 3)=  1.09364845D+01
    atomexp( 4)=  3.89390801D+01
    atomexp( 5)=  1.37253161D+02
    atomexp( 6)=  9.85311946D+02
case( 45)
    nSTO= 6
    atomcoeff( 1)=  2.55024486D-01
    atomcoeff( 2)=  2.04938683D+01
    atomcoeff( 3)=  1.06431459D+03
    atomcoeff( 4)=  8.51725295D+03
    atomcoeff( 5)=  1.12680477D+05
    atomcoeff( 6)=  2.61525543D+06
    atomexp( 1)=  1.25836060D+00
    atomexp( 2)=  2.96525714D+00
    atomexp( 3)=  1.14445430D+01
    atomexp( 4)=  4.05693157D+01
    atomexp( 5)=  1.42575141D+02
    atomexp( 6)=  5.39392985D+03
case( 46)
    nSTO= 6
    atomcoeff( 1)=  1.09645620D+00
    atomcoeff( 2)=  2.39195804D+01
    atomcoeff( 3)=  1.24535237D+03
    atomcoeff( 4)=  9.17534707D+03
    atomcoeff( 5)=  1.22428430D+05
    atomcoeff( 6)=  3.68513019D+06
    atomexp( 1)=  1.77747695D+00
    atomexp( 2)=  3.13732590D+00
    atomexp( 3)=  1.21119233D+01
    atomexp( 4)=  4.23975335D+01
    atomexp( 5)=  1.46229263D+02
    atomexp( 6)=  2.64053203D+04
case( 47)
    nSTO= 6
    atomcoeff( 1)=  2.01120743D-01
    atomcoeff( 2)=  2.75489959D+01
    atomcoeff( 3)=  1.38249100D+03
    atomcoeff( 4)=  9.70986619D+03
    atomcoeff( 5)=  1.28777708D+05
    atomcoeff( 6)=  1.79214930D+04
    atomexp( 1)=  1.23718834D+00
    atomexp( 2)=  3.12157020D+00
    atomexp( 3)=  1.25395229D+01
    atomexp( 4)=  4.35753887D+01
    atomexp( 5)=  1.48232305D+02
    atomexp( 6)=  5.50871083D+02
case( 48)
    nSTO= 6
    atomcoeff( 1)=  4.47634319D-01
    atomcoeff( 2)=  3.75796820D+01
    atomcoeff( 3)=  1.62189187D+03
    atomcoeff( 4)=  1.01553525D+04
    atomcoeff( 5)=  1.38364261D+05
    atomcoeff( 6)=  1.92207089D+05
    atomexp( 1)=  1.35244225D+00
    atomexp( 2)=  3.46310568D+00
    atomexp( 3)=  1.34020236D+01
    atomexp( 4)=  4.52154599D+01
    atomexp( 5)=  1.50731909D+02
    atomexp( 6)=  1.40555848D+03
case( 49)
    nSTO= 6
    atomcoeff( 1)=  3.39191203D-01
    atomcoeff( 2)=  3.76518750D+01
    atomcoeff( 3)=  1.62403121D+03
    atomcoeff( 4)=  1.07211122D+04
    atomcoeff( 5)=  1.49381488D+05
    atomcoeff( 6)=  1.01735402D+05
    atomexp( 1)=  1.23528265D+00
    atomexp( 2)=  3.44705322D+00
    atomexp( 3)=  1.32812076D+01
    atomexp( 4)=  4.51202760D+01
    atomexp( 5)=  1.54646423D+02
    atomexp( 6)=  1.04183060D+03
case( 50)
    nSTO= 6
    atomcoeff( 1)=  6.62236285D-01
    atomcoeff( 2)=  5.20533260D+01
    atomcoeff( 3)=  1.24655024D+03
    atomcoeff( 4)=  6.74259489D+02
    atomcoeff( 5)=  1.15229178D+04
    atomcoeff( 6)=  1.68146763D+05
    atomexp( 1)=  1.36014717D+00
    atomexp( 2)=  3.84354045D+00
    atomexp( 3)=  1.42717142D+01
    atomexp( 4)=  1.42761879D+01
    atomexp( 5)=  4.73391088D+01
    atomexp( 6)=  1.60961801D+02
case( 51)
    nSTO= 6
    atomcoeff( 1)=  1.28921881D+00
    atomcoeff( 2)=  7.04667168D+01
    atomcoeff( 3)=  2.19472079D+03
    atomcoeff( 4)=  1.23194296D+04
    atomcoeff( 5)=  4.39264871D+05
    atomcoeff( 6)= -2.68294916D+05
    atomexp( 1)=  1.52331696D+00
    atomexp( 2)=  4.29651065D+00
    atomexp( 3)=  1.51492591D+01
    atomexp( 4)=  4.89800056D+01
    atomexp( 5)=  1.82867294D+02
    atomexp( 6)=  2.03412085D+02
case( 52)
    nSTO= 6
    atomcoeff( 1)=  1.84213424D+00
    atomcoeff( 2)=  8.51090932D+01
    atomcoeff( 3)=  2.31829347D+03
    atomcoeff( 4)=  2.51456054D+05
    atomcoeff( 5)= -9.44542502D+05
    atomcoeff( 6)=  8.67610667D+05
    atomexp( 1)=  1.61668336D+00
    atomexp( 2)=  4.61268202D+00
    atomexp( 3)=  1.55776823D+01
    atomexp( 4)=  7.02834555D+01
    atomexp( 5)=  8.75975322D+01
    atomexp( 6)=  1.01344660D+02
case( 53)
    nSTO= 6
    atomcoeff( 1)=  2.83724597D+00
    atomcoeff( 2)=  1.09754505D+02
    atomcoeff( 3)=  2.63541195D+03
    atomcoeff( 4)=  1.33920764D+04
    atomcoeff( 5)=  2.73019364D+05
    atomcoeff( 6)= -6.82187885D+04
    atomexp( 1)=  1.74561281D+00
    atomexp( 2)=  5.07584671D+00
    atomexp( 3)=  1.64282539D+01
    atomexp( 4)=  5.10219232D+01
    atomexp( 5)=  1.79926970D+02
    atomexp( 6)=  2.25491885D+02
case( 54)
    nSTO= 6
    atomcoeff( 1)=  5.54921161D-01
    atomcoeff( 2)=  4.40314885D+01
    atomcoeff( 3)=  1.45660068D+03
    atomcoeff( 4)=  1.27385369D+04
    atomcoeff( 5)=  1.29245265D+05
    atomcoeff( 6)=  1.00439469D+05
    atomexp( 1)=  1.24652705D+00
    atomexp( 2)=  3.64020184D+00
    atomexp( 3)=  1.25208600D+01
    atomexp( 4)=  4.23594429D+01
    atomexp( 5)=  1.79268491D+02
    atomexp( 6)=  1.80158243D+02
case( 55)
    nSTO= 6
    atomcoeff( 1)=  1.52271424D-02
    atomcoeff( 2)=  6.60300074D+00
    atomcoeff( 3)=  1.47402861D+02
    atomcoeff( 4)=  2.94017321D+03
    atomcoeff( 5)=  1.48061890D+04
    atomcoeff( 6)=  2.46681022D+05
    atomexp( 1)=  6.11177876D-01
    atomexp( 2)=  2.16622235D+00
    atomexp( 3)=  5.81399256D+00
    atomexp( 4)=  1.72005062D+01
    atomexp( 5)=  5.24292743D+01
    atomexp( 6)=  1.81047572D+02
case( 56)
    nSTO= 6
    atomcoeff( 1)=  8.60201084D-02
    atomcoeff( 2)=  1.20214340D+01
    atomcoeff( 3)=  1.57879674D+02
    atomcoeff( 4)=  3.01082034D+03
    atomcoeff( 5)=  1.58168863D+04
    atomcoeff( 6)=  2.66413378D+05
    atomexp( 1)=  8.20327333D-01
    atomexp( 2)=  2.59574739D+00
    atomexp( 3)=  6.22508808D+00
    atomexp( 4)=  1.72912341D+01
    atomexp( 5)=  5.29222133D+01
    atomexp( 6)=  1.85932201D+02
case( 57)
    nSTO= 6
    atomcoeff( 1)=  1.93407454D-01
    atomcoeff( 2)=  1.25651975D+01
    atomcoeff( 3)=  1.69049307D+02
    atomcoeff( 4)=  3.26048069D+03
    atomcoeff( 5)=  1.65880208D+04
    atomcoeff( 6)=  2.84769084D+05
    atomexp( 1)=  9.80073620D-01
    atomexp( 2)=  2.67289042D+00
    atomexp( 3)=  6.30568472D+00
    atomexp( 4)=  1.77428847D+01
    atomexp( 5)=  5.40704391D+01
    atomexp( 6)=  1.89860062D+02
case( 58)
    nSTO= 6
    atomcoeff( 1)=  2.04754432D-01
    atomcoeff( 2)=  1.50853564D+01
    atomcoeff( 3)=  1.81801168D+02
    atomcoeff( 4)=  3.46966389D+03
    atomcoeff( 5)=  1.76405036D+04
    atomcoeff( 6)=  3.06068505D+05
    atomexp( 1)=  9.97146421D-01
    atomexp( 2)=  2.77501889D+00
    atomexp( 3)=  6.48469150D+00
    atomexp( 4)=  1.81320817D+01
    atomexp( 5)=  5.51837377D+01
    atomexp( 6)=  1.94484621D+02
case( 59)
    nSTO= 6
    atomcoeff( 1)=  1.17310249D-01
    atomcoeff( 2)=  1.89022733D+01
    atomcoeff( 3)=  1.95263581D+02
    atomcoeff( 4)=  3.67133277D+03
    atomcoeff( 5)=  1.86090920D+04
    atomcoeff( 6)=  3.28534601D+05
    atomexp( 1)=  8.94926117D-01
    atomexp( 2)=  2.85904754D+00
    atomexp( 3)=  6.69795154D+00
    atomexp( 4)=  1.85168973D+01
    atomexp( 5)=  5.61181262D+01
    atomexp( 6)=  1.99026606D+02
case( 60)
    nSTO= 6
    atomcoeff( 1)=  1.22761199D-01
    atomcoeff( 2)=  2.12170959D+01
    atomcoeff( 3)=  2.09567213D+02
    atomcoeff( 4)=  3.93407743D+03
    atomcoeff( 5)=  1.96741398D+04
    atomcoeff( 6)=  3.52906644D+05
    atomexp( 1)=  9.09415077D-01
    atomexp( 2)=  2.93230228D+00
    atomexp( 3)=  6.81909323D+00
    atomexp( 4)=  1.89799803D+01
    atomexp( 5)=  5.72942176D+01
    atomexp( 6)=  2.03798646D+02
case( 61)
    nSTO= 6
    atomcoeff( 1)=  1.28249281D-01
    atomcoeff( 2)=  2.35581151D+01
    atomcoeff( 3)=  2.24481869D+02
    atomcoeff( 4)=  4.21671975D+03
    atomcoeff( 5)=  2.09540739D+04
    atomcoeff( 6)=  3.79193080D+05
    atomexp( 1)=  9.23405306D-01
    atomexp( 2)=  3.00222099D+00
    atomexp( 3)=  6.92602076D+00
    atomexp( 4)=  1.94541642D+01
    atomexp( 5)=  5.86842599D+01
    atomexp( 6)=  2.08919543D+02
case( 62)
    nSTO= 6
    atomcoeff( 1)=  1.33115275D-01
    atomcoeff( 2)=  2.59665979D+01
    atomcoeff( 3)=  2.41437182D+02
    atomcoeff( 4)=  4.51328366D+03
    atomcoeff( 5)=  2.19043289D+04
    atomcoeff( 6)=  4.06419966D+05
    atomexp( 1)=  9.36039846D-01
    atomexp( 2)=  3.06978122D+00
    atomexp( 3)=  7.03334862D+00
    atomexp( 4)=  1.99529259D+01
    atomexp( 5)=  5.96759461D+01
    atomexp( 6)=  2.13426535D+02
case( 63)
    nSTO= 6
    atomcoeff( 1)=  1.37662769D-01
    atomcoeff( 2)=  2.84067184D+01
    atomcoeff( 3)=  2.59218884D+02
    atomcoeff( 4)=  4.82561245D+03
    atomcoeff( 5)=  2.30819617D+04
    atomcoeff( 6)=  4.35879372D+05
    atomexp( 1)=  9.47865206D-01
    atomexp( 2)=  3.13487066D+00
    atomexp( 3)=  7.13138994D+00
    atomexp( 4)=  2.04532164D+01
    atomexp( 5)=  6.08622549D+01
    atomexp( 6)=  2.18347216D+02
case( 64)
    nSTO= 6
    atomcoeff( 1)=  2.52460239D-01
    atomcoeff( 2)=  3.18866294D+01
    atomcoeff( 3)=  2.74292998D+02
    atomcoeff( 4)=  5.15167488D+03
    atomcoeff( 5)=  2.42815141D+04
    atomcoeff( 6)=  4.67150462D+05
    atomexp( 1)=  1.06455615D+00
    atomexp( 2)=  3.28446051D+00
    atomexp( 3)=  7.21242167D+00
    atomexp( 4)=  2.09230215D+01
    atomexp( 5)=  6.20308088D+01
    atomexp( 6)=  2.23200425D+02
case( 65)
    nSTO= 6
    atomcoeff( 1)=  1.54790145D-01
    atomcoeff( 2)=  3.39690678D+01
    atomcoeff( 3)=  2.99174801D+02
    atomcoeff( 4)=  5.46562892D+03
    atomcoeff( 5)=  2.54446982D+04
    atomcoeff( 6)=  5.00638671D+05
    atomexp( 1)=  9.81628667D-01
    atomexp( 2)=  3.27026784D+00
    atomexp( 3)=  7.35267031D+00
    atomexp( 4)=  2.14378959D+01
    atomexp( 5)=  6.29723985D+01
    atomexp( 6)=  2.28280092D+02
case( 66)
    nSTO= 6
    atomcoeff( 1)=  1.62672040D-01
    atomcoeff( 2)=  3.67826296D+01
    atomcoeff( 3)=  3.22110221D+02
    atomcoeff( 4)=  5.83315949D+03
    atomcoeff( 5)=  2.67897440D+04
    atomcoeff( 6)=  5.36299333D+05
    atomexp( 1)=  9.96903087D-01
    atomexp( 2)=  3.33344216D+00
    atomexp( 3)=  7.45986148D+00
    atomexp( 4)=  2.19760730D+01
    atomexp( 5)=  6.42151488D+01
    atomexp( 6)=  2.33475670D+02
case( 67)
    nSTO= 6
    atomcoeff( 1)=  1.69243154D-01
    atomcoeff( 2)=  3.95454837D+01
    atomcoeff( 3)=  3.45125028D+02
    atomcoeff( 4)=  6.18636001D+03
    atomcoeff( 5)=  2.79916581D+04
    atomcoeff( 6)=  5.73932337D+05
    atomexp( 1)=  1.01020585D+00
    atomexp( 2)=  3.39297575D+00
    atomexp( 3)=  7.55230169D+00
    atomexp( 4)=  2.24790351D+01
    atomexp( 5)=  6.51707581D+01
    atomexp( 6)=  2.38472098D+02
case( 68)
    nSTO= 6
    atomcoeff( 1)=  1.75500648D-01
    atomcoeff( 2)=  4.23433497D+01
    atomcoeff( 3)=  3.70840554D+02
    atomcoeff( 4)=  6.57155337D+03
    atomcoeff( 5)=  2.93518957D+04
    atomcoeff( 6)=  6.14582701D+05
    atomexp( 1)=  1.02285074D+00
    atomexp( 2)=  3.45072552D+00
    atomexp( 3)=  7.64884390D+00
    atomexp( 4)=  2.30153210D+01
    atomexp( 5)=  6.62438516D+01
    atomexp( 6)=  2.43803426D+02
case( 69)
    nSTO= 6
    atomcoeff( 1)=  1.81592518D-01
    atomcoeff( 2)=  4.51423923D+01
    atomcoeff( 3)=  3.97591918D+02
    atomcoeff( 4)=  6.97645370D+03
    atomcoeff( 5)=  3.08236633D+04
    atomcoeff( 6)=  6.57735348D+05
    atomexp( 1)=  1.03504297D+00
    atomexp( 2)=  3.50678174D+00
    atomexp( 3)=  7.73863506D+00
    atomexp( 4)=  2.35551030D+01
    atomexp( 5)=  6.74003076D+01
    atomexp( 6)=  2.49235419D+02
case( 70)
    nSTO= 6
    atomcoeff( 1)=  1.87999328D-01
    atomcoeff( 2)=  4.79811702D+01
    atomcoeff( 3)=  4.26570585D+02
    atomcoeff( 4)=  7.38599319D+03
    atomcoeff( 5)=  3.19871811D+04
    atomcoeff( 6)=  7.03484393D+05
    atomexp( 1)=  1.04735712D+00
    atomexp( 2)=  3.56174135D+00
    atomexp( 3)=  7.83071669D+00
    atomexp( 4)=  2.40986299D+01
    atomexp( 5)=  6.81954466D+01
    atomexp( 6)=  2.54431766D+02
case( 71)
    nSTO= 6
    atomcoeff( 1)=  3.16002514D-01
    atomcoeff( 2)=  5.68896988D+01
    atomcoeff( 3)=  4.46478378D+02
    atomcoeff( 4)=  7.74472571D+03
    atomcoeff( 5)=  3.39282923D+04
    atomcoeff( 6)=  7.52950041D+05
    atomexp( 1)=  1.14369000D+00
    atomexp( 2)=  3.76949232D+00
    atomexp( 3)=  7.97170617D+00
    atomexp( 4)=  2.45079419D+01
    atomexp( 5)=  6.94081739D+01
    atomexp( 6)=  2.60319712D+02
case( 72)
    nSTO= 6
    atomcoeff( 1)=  3.83352272D-01
    atomcoeff( 2)=  5.29055934D+01
    atomcoeff( 3)=  4.97794367D+02
    atomcoeff( 4)=  8.34366344D+03
    atomcoeff( 5)=  3.53349533D+04
    atomcoeff( 6)=  8.08847510D+05
    atomexp( 1)=  1.18023379D+00
    atomexp( 2)=  3.75632514D+00
    atomexp( 3)=  7.99359078D+00
    atomexp( 4)=  2.52941121D+01
    atomexp( 5)=  7.06233501D+01
    atomexp( 6)=  2.66096690D+02
case( 73)
    nSTO= 6
    atomcoeff( 1)=  4.69327201D-01
    atomcoeff( 2)=  4.08042291D+01
    atomcoeff( 3)=  5.27153523D+02
    atomcoeff( 4)=  8.99850512D+03
    atomcoeff( 5)=  3.71504931D+04
    atomcoeff( 6)=  8.63761605D+05
    atomexp( 1)=  1.23863701D+00
    atomexp( 2)=  3.58543935D+00
    atomexp( 3)=  7.78857787D+00
    atomexp( 4)=  2.59392310D+01
    atomexp( 5)=  7.23631945D+01
    atomexp( 6)=  2.71902195D+02
case( 74)
    nSTO= 6
    atomcoeff( 1)=  5.33153543D-01
    atomcoeff( 2)=  3.09989865D+01
    atomcoeff( 3)=  5.58978063D+02
    atomcoeff( 4)=  9.52542892D+03
    atomcoeff( 5)=  3.86950534D+04
    atomcoeff( 6)=  9.21973349D+05
    atomexp( 1)=  1.28753387D+00
    atomexp( 2)=  3.38006114D+00
    atomexp( 3)=  7.67575184D+00
    atomexp( 4)=  2.64494226D+01
    atomexp( 5)=  7.33990944D+01
    atomexp( 6)=  2.77494862D+02
case( 75)
    nSTO= 6
    atomcoeff( 1)=  4.99791899D-01
    atomcoeff( 2)=  2.37735656D+01
    atomcoeff( 3)=  5.92550104D+02
    atomcoeff( 4)=  1.00339577D+04
    atomcoeff( 5)=  4.07428175D+04
    atomcoeff( 6)=  9.84673300D+05
    atomexp( 1)=  1.29624987D+00
    atomexp( 2)=  3.14215381D+00
    atomexp( 3)=  7.63229956D+00
    atomexp( 4)=  2.69151583D+01
    atomexp( 5)=  7.46926464D+01
    atomexp( 6)=  2.83541637D+02
case( 76)
    nSTO= 6
    atomcoeff( 1)=  6.55289532D-01
    atomcoeff( 2)=  2.61678467D+01
    atomcoeff( 3)=  6.68681513D+02
    atomcoeff( 4)=  1.07553296D+04
    atomcoeff( 5)=  4.22367846D+04
    atomcoeff( 6)=  1.05133432D+06
    atomexp( 1)=  1.37764045D+00
    atomexp( 2)=  3.20183974D+00
    atomexp( 3)=  7.93932116D+00
    atomexp( 4)=  2.78114998D+01
    atomexp( 5)=  7.59200748D+01
    atomexp( 6)=  2.89293775D+02
case( 77)
    nSTO= 6
    atomcoeff( 1)=  7.87258377D-01
    atomcoeff( 2)=  2.77539225D+01
    atomcoeff( 3)=  7.46864579D+02
    atomcoeff( 4)=  1.14066384D+04
    atomcoeff( 5)=  4.31797921D+04
    atomcoeff( 6)=  1.11998880D+06
    atomexp( 1)=  1.44564448D+00
    atomexp( 2)=  3.22124914D+00
    atomexp( 3)=  8.21773367D+00
    atomexp( 4)=  2.86191827D+01
    atomexp( 5)=  7.64809547D+01
    atomexp( 6)=  2.94443384D+02
case( 78)
    nSTO= 6
    atomcoeff( 1)=  7.09739333D-01
    atomcoeff( 2)=  2.54930511D+01
    atomcoeff( 3)=  8.34935514D+02
    atomcoeff( 4)=  1.22702523D+04
    atomcoeff( 5)=  4.48907843D+04
    atomcoeff( 6)=  1.19706815D+06
    atomexp( 1)=  1.51180651D+00
    atomexp( 2)=  3.04772478D+00
    atomexp( 3)=  8.44880848D+00
    atomexp( 4)=  2.95798829D+01
    atomexp( 5)=  7.78753796D+01
    atomexp( 6)=  3.00684189D+02
case( 79)
    nSTO= 6
    atomcoeff( 1)=  6.44100853D-01
    atomcoeff( 2)=  2.64249507D+01
    atomcoeff( 3)=  9.06136306D+02
    atomcoeff( 4)=  1.28576622D+04
    atomcoeff( 5)=  4.67061796D+04
    atomcoeff( 6)=  1.27789280D+06
    atomexp( 1)=  1.52424912D+00
    atomexp( 2)=  3.02420959D+00
    atomexp( 3)=  8.65329470D+00
    atomexp( 4)=  3.01857333D+01
    atomexp( 5)=  7.86916769D+01
    atomexp( 6)=  3.06768083D+02
case( 80)
    nSTO= 6
    atomcoeff( 1)=  9.36193190D-01
    atomcoeff( 2)=  3.58909275D+01
    atomcoeff( 3)=  1.05347568D+03
    atomcoeff( 4)=  1.38294750D+04
    atomcoeff( 5)=  4.73841426D+04
    atomcoeff( 6)=  1.36096075D+06
    atomexp( 1)=  1.55818107D+00
    atomexp( 2)=  3.29565823D+00
    atomexp( 3)=  9.20698250D+00
    atomexp( 4)=  3.14687115D+01
    atomexp( 5)=  7.93918380D+01
    atomexp( 6)=  3.12295507D+02
case( 81)
    nSTO= 6
    atomcoeff( 1)=  1.87119299D-01
    atomcoeff( 2)=  1.90147149D+01
    atomcoeff( 3)=  7.41009154D+02
    atomcoeff( 4)=  1.07964518D+04
    atomcoeff( 5)=  5.53231483D+04
    atomcoeff( 6)=  1.47769667D+06
    atomexp( 1)=  1.13951387D+00
    atomexp( 2)=  2.76736356D+00
    atomexp( 3)=  7.91781799D+00
    atomexp( 4)=  2.71424817D+01
    atomexp( 5)=  7.67197754D+01
    atomexp( 6)=  3.22718169D+02
case( 82)
    nSTO= 6
    atomcoeff( 1)=  5.12342159D-01
    atomcoeff( 2)=  3.57090467D+01
    atomcoeff( 3)=  1.05613384D+03
    atomcoeff( 4)=  1.39155761D+04
    atomcoeff( 5)=  5.47201013D+04
    atomcoeff( 6)=  1.56128036D+06
    atomexp( 1)=  1.30101365D+00
    atomexp( 2)=  3.27298587D+00
    atomexp( 3)=  9.10170855D+00
    atomexp( 4)=  3.10731305D+01
    atomexp( 5)=  8.10812501D+01
    atomexp( 6)=  3.27698367D+02
case( 83)
    nSTO= 6
    atomcoeff( 1)=  1.19529881D+00
    atomcoeff( 2)=  6.46119695D+01
    atomcoeff( 3)=  1.34440634D+03
    atomcoeff( 4)=  1.54170365D+04
    atomcoeff( 5)=  5.39884460D+04
    atomcoeff( 6)=  1.65784068D+06
    atomexp( 1)=  1.48090388D+00
    atomexp( 2)=  3.87823063D+00
    atomexp( 3)=  1.02059830D+01
    atomexp( 4)=  3.32941987D+01
    atomexp( 5)=  8.16099300D+01
    atomexp( 6)=  3.32608092D+02
case( 84)
    nSTO= 6
    atomcoeff( 1)=  1.89957560D+00
    atomcoeff( 2)=  9.48767464D+01
    atomcoeff( 3)=  1.52003662D+03
    atomcoeff( 4)=  1.58061629D+04
    atomcoeff( 5)=  5.60378905D+04
    atomcoeff( 6)=  1.76922059D+06
    atomexp( 1)=  1.58833410D+00
    atomexp( 2)=  4.34940086D+00
    atomexp( 3)=  1.09137124D+01
    atomexp( 4)=  3.41136193D+01
    atomexp( 5)=  8.18050970D+01
    atomexp( 6)=  3.39415038D+02
case( 85)
    nSTO= 6
    atomcoeff( 1)=  3.16647246D+00
    atomcoeff( 2)=  1.53952661D+02
    atomcoeff( 3)=  1.66245853D+03
    atomcoeff( 4)=  1.54719787D+04
    atomcoeff( 5)=  5.78471766D+04
    atomcoeff( 6)=  1.88368196D+06
    atomexp( 1)=  1.72876096D+00
    atomexp( 2)=  5.02983793D+00
    atomexp( 3)=  1.17611790D+01
    atomexp( 4)=  3.43345804D+01
    atomexp( 5)=  8.08089589D+01
    atomexp( 6)=  3.45724945D+02
case( 86)
    nSTO= 6
    atomcoeff( 1)= -1.25953795D+00
    atomcoeff( 2)=  4.15980791D+00
    atomcoeff( 3)=  1.23478656D+02
    atomcoeff( 4)=  1.81470617D+03
    atomcoeff( 5)=  3.58834551D+04
    atomcoeff( 6)=  1.62455036D+06
    atomexp( 1)=  1.46956081D+00
    atomexp( 2)=  1.61203821D+00
    atomexp( 3)=  4.76635392D+00
    atomexp( 4)=  1.15181360D+01
    atomexp( 5)=  4.34938364D+01
    atomexp( 6)=  2.97540213D+02
case( 87)
    nSTO= 6
    atomcoeff( 1)=  2.40882089D-02
    atomcoeff( 2)=  7.09510942D+00
    atomcoeff( 3)=  2.09753552D+02
    atomcoeff( 4)=  1.93436178D+03
    atomcoeff( 5)=  3.79076858D+04
    atomcoeff( 6)=  1.72806912D+06
    atomexp( 1)=  6.88238527D-01
    atomexp( 2)=  2.12387928D+00
    atomexp( 3)=  5.70270924D+00
    atomexp( 4)=  1.23494196D+01
    atomexp( 5)=  4.45853114D+01
    atomexp( 6)=  3.04232706D+02
case( 88)
    nSTO= 6
    atomcoeff( 1)=  1.13596930D-01
    atomcoeff( 2)=  1.44101422D+01
    atomcoeff( 3)=  2.78801286D+02
    atomcoeff( 4)=  1.83917784D+03
    atomcoeff( 5)=  3.85563537D+04
    atomcoeff( 6)=  1.80920483D+06
    atomexp( 1)=  8.66683827D-01
    atomexp( 2)=  2.57893694D+00
    atomexp( 3)=  6.47109216D+00
    atomexp( 4)=  1.24324365D+01
    atomexp( 5)=  4.44643561D+01
    atomexp( 6)=  3.07498074D+02
case( 89)
    nSTO= 6
    atomcoeff( 1)=  2.63548925D-01
    atomcoeff( 2)=  1.93268406D+01
    atomcoeff( 3)=  2.95381765D+02
    atomcoeff( 4)=  1.84277057D+03
    atomcoeff( 5)=  3.99662551D+04
    atomcoeff( 6)=  1.90872070D+06
    atomexp( 1)=  1.01071583D+00
    atomexp( 2)=  2.82982389D+00
    atomexp( 3)=  6.75597853D+00
    atomexp( 4)=  1.23829283D+01
    atomexp( 5)=  4.48731306D+01
    atomexp( 6)=  3.12832808D+02
case( 90)
    nSTO= 6
    atomcoeff( 1)=  5.21545402D-01
    atomcoeff( 2)=  2.71077215D+01
    atomcoeff( 3)=  1.05653343D+03
    atomcoeff( 4)=  1.22055866D+04
    atomcoeff( 5)=  8.27282415D+04
    atomcoeff( 6)=  2.62113244D+06
    atomexp( 1)=  1.15136716D+00
    atomexp( 2)=  3.10686786D+00
    atomexp( 3)=  8.74400328D+00
    atomexp( 4)=  2.80066345D+01
    atomexp( 5)=  8.12628027D+01
    atomexp( 6)=  3.86931308D+02
case( 91)
    nSTO= 6
    atomcoeff( 1)=  3.32644570D-01
    atomcoeff( 2)=  2.53455810D+01
    atomcoeff( 3)=  3.55500494D+02
    atomcoeff( 4)=  2.01408214D+03
    atomcoeff( 5)=  4.46537316D+04
    atomcoeff( 6)=  2.17635376D+06
    atomexp( 1)=  1.07691692D+00
    atomexp( 2)=  2.96114233D+00
    atomexp( 3)=  7.30690436D+00
    atomexp( 4)=  1.27625603D+01
    atomexp( 5)=  4.67759825D+01
    atomexp( 6)=  3.27700491D+02
case( 92)
    nSTO= 6
    atomcoeff( 1)=  2.24214025D-01
    atomcoeff( 2)=  2.61600900D+01
    atomcoeff( 3)=  3.83617905D+02
    atomcoeff( 4)=  2.15485813D+03
    atomcoeff( 5)=  4.76387243D+04
    atomcoeff( 6)=  2.33464807D+06
    atomexp( 1)=  9.98202708D-01
    atomexp( 2)=  2.91474078D+00
    atomexp( 3)=  7.48544385D+00
    atomexp( 4)=  1.30369071D+01
    atomexp( 5)=  4.80225688D+01
    atomexp( 6)=  3.36244993D+02
case( 93)
    nSTO= 6
    atomcoeff( 1)=  2.29989417D-01
    atomcoeff( 2)=  2.95647192D+01
    atomcoeff( 3)=  3.85356771D+02
    atomcoeff( 4)=  2.29359607D+03
    atomcoeff( 5)=  5.05605766D+04
    atomcoeff( 6)=  2.49945618D+06
    atomexp( 1)=  1.01227042D+00
    atomexp( 2)=  2.97539684D+00
    atomexp( 3)=  7.64591137D+00
    atomexp( 4)=  1.31562666D+01
    atomexp( 5)=  4.91493077D+01
    atomexp( 6)=  3.44651866D+02
case( 94)
    nSTO= 6
    atomcoeff( 1)=  2.20737736D-01
    atomcoeff( 2)=  3.74482767D+01
    atomcoeff( 3)=  1.66889057D+03
    atomcoeff( 4)=  1.75356680D+04
    atomcoeff( 5)=  9.95314347D+04
    atomcoeff( 6)=  3.38705468D+06
    atomexp( 1)=  1.03617240D+00
    atomexp( 2)=  3.08199742D+00
    atomexp( 3)=  1.01319809D+01
    atomexp( 4)=  3.32227680D+01
    atomexp( 5)=  9.04714955D+01
    atomexp( 6)=  4.20970220D+02
case( 95)
    nSTO= 6
    atomcoeff( 1)=  2.20384424D-01
    atomcoeff( 2)=  4.20324534D+01
    atomcoeff( 3)=  1.84306664D+03
    atomcoeff( 4)=  1.87560475D+04
    atomcoeff( 5)=  1.03318208D+05
    atomcoeff( 6)=  3.60772550D+06
    atomexp( 1)=  1.04321697D+00
    atomexp( 2)=  3.14860997D+00
    atomexp( 3)=  1.04845520D+01
    atomexp( 4)=  3.43688016D+01
    atomexp( 5)=  9.20469861D+01
    atomexp( 6)=  4.29281159D+02
case( 96)
    nSTO= 6
    atomcoeff( 1)=  3.73250599D-01
    atomcoeff( 2)=  5.25460858D+01
    atomcoeff( 3)=  2.13155551D+03
    atomcoeff( 4)=  2.08660786D+04
    atomcoeff( 5)=  1.04713657D+05
    atomcoeff( 6)=  3.82637991D+06
    atomexp( 1)=  1.13927774D+00
    atomexp( 2)=  3.35897862D+00
    atomexp( 3)=  1.10600590D+01
    atomexp( 4)=  3.64277105D+01
    atomexp( 5)=  9.36282932D+01
    atomexp( 6)=  4.36383203D+02
case( 97)
    nSTO= 6
    atomcoeff( 1)=  2.38737728D-01
    atomcoeff( 2)=  4.89367573D+01
    atomcoeff( 3)=  2.69489215D+02
    atomcoeff( 4)=  3.04967103D+03
    atomcoeff( 5)=  6.43731995D+04
    atomcoeff( 6)=  3.29046682D+06
    atomexp( 1)=  1.07347589D+00
    atomexp( 2)=  3.25606044D+00
    atomexp( 3)=  7.94193011D+00
    atomexp( 4)=  1.34829532D+01
    atomexp( 5)=  5.40743652D+01
    atomexp( 6)=  3.80832807D+02
case( 98)
    nSTO= 6
    atomcoeff( 1)=  2.43276377D-01
    atomcoeff( 2)=  5.40599442D+01
    atomcoeff( 3)=  2.36360986D+02
    atomcoeff( 4)=  3.30958300D+03
    atomcoeff( 5)=  6.88102804D+04
    atomcoeff( 6)=  3.53917987D+06
    atomexp( 1)=  1.08410708D+00
    atomexp( 2)=  3.32172374D+00
    atomexp( 3)=  7.88622430D+00
    atomexp( 4)=  1.36827140D+01
    atomexp( 5)=  5.55971021D+01
    atomexp( 6)=  3.91261264D+02
case( 99)
    nSTO= 6
    atomcoeff( 1)=  2.48957242D-01
    atomcoeff( 2)=  5.94557206D+01
    atomcoeff( 3)=  2.06594809D+02
    atomcoeff( 4)=  3.58393111D+03
    atomcoeff( 5)=  7.34451542D+04
    atomcoeff( 6)=  3.80226148D+06
    atomexp( 1)=  1.09550040D+00
    atomexp( 2)=  3.38753057D+00
    atomexp( 3)=  7.79626411D+00
    atomexp( 4)=  1.39085002D+01
    atomexp( 5)=  5.71446883D+01
    atomexp( 6)=  4.01732726D+02
case(100)
    nSTO= 6
    atomcoeff( 1)=  2.55734721D-01
    atomcoeff( 2)=  6.50826390D+01
    atomcoeff( 3)=  1.80106305D+02
    atomcoeff( 4)=  3.87921759D+03
    atomcoeff( 5)=  7.85645583D+04
    atomcoeff( 6)=  4.09189727D+06
    atomexp( 1)=  1.10755517D+00
    atomexp( 2)=  3.45258834D+00
    atomexp( 3)=  7.67331913D+00
    atomexp( 4)=  1.41615467D+01
    atomexp( 5)=  5.87934417D+01
    atomexp( 6)=  4.12768352D+02
case(101)
    nSTO= 6
    atomcoeff( 1)=  2.60830545D-01
    atomcoeff( 2)=  7.07733464D+01
    atomcoeff( 3)=  1.58900733D+02
    atomcoeff( 4)=  4.19117753D+03
    atomcoeff( 5)=  8.38504562D+04
    atomcoeff( 6)=  4.39296515D+06
    atomexp( 1)=  1.11811106D+00
    atomexp( 2)=  3.51522215D+00
    atomexp( 3)=  7.51732456D+00
    atomexp( 4)=  1.44418372D+01
    atomexp( 5)=  6.04583815D+01
    atomexp( 6)=  4.23625512D+02
case(102)
    nSTO= 6
    atomcoeff( 1)=  2.64977045D-01
    atomcoeff( 2)=  7.66407933D+01
    atomcoeff( 3)=  1.44597642D+02
    atomcoeff( 4)=  4.52967052D+03
    atomcoeff( 5)=  8.99344391D+04
    atomcoeff( 6)=  4.73878159D+06
    atomexp( 1)=  1.12766161D+00
    atomexp( 2)=  3.57653547D+00
    atomexp( 3)=  7.37609237D+00
    atomexp( 4)=  1.47586178D+01
    atomexp( 5)=  6.23072911D+01
    atomexp( 6)=  4.35766749D+02
case(103)
    nSTO= 6
    atomcoeff( 1)=  4.23116844D-01
    atomcoeff( 2)=  1.04253103D+02
    atomcoeff( 3)=  5.42305500D+01
    atomcoeff( 4)=  4.64610890D+03
    atomcoeff( 5)=  9.32002185D+04
    atomcoeff( 6)=  5.01888816D+06
    atomexp( 1)=  1.20274494D+00
    atomexp( 2)=  3.86018027D+00
    atomexp( 3)=  7.90465316D+00
    atomexp( 4)=  1.45769846D+01
    atomexp( 5)=  6.28575818D+01
    atomexp( 6)=  4.43455955D+02
end select

end subroutine






!!--------- Return parameters of accurate GTF fitting of radial atomic electron density
!iele (input): Index of element
!nGTF (output): Number of GTF for fitting
!atomcoeff (output): Fitting coefficients of GTFs
!atomexp (output): Exponents of GTFs
!
!  The atomic wavefunction files are the same as those for generating subroutine genatmraddens
!  The electron density quality produced by parameters given by this subroutine is evidently not as good as genatmraddens &
!because the fitting is not fully accurate, the advantage is that there is no upper limit of distance
!  Fitting quality is better than genatmraddens_STOfit, but more expensive due to larger number of GTFs. Simply from Pearson coefficient,&
!this GTF fitting is seemingly no always better than STO fitting, because nuclear region and tail region is better represented by STO, while&
!for valence region, the present GTF fitting is always much better
!  The density produced by the GTFs is non-negative everywhere, and the integral equals to actual number of electrons
!
!  By default, relative error is minimized because I found fitting quality is best in this case. However, for Ar At Bi Bk Cf Cm Es Fe Gd Ir Kr Md Na Ne O Os Pb Po Pt Rn Xe &
!the fitting is failed (by visualizing fitted radial density) perhaps due to poor initial exponents and coefficients, and H He Mo N also has less satisfactory fitting. So only for them,
!rdf is minimized instead since the fitting is more robust (but for other elements, relative error minization is often better, though the nuclear cusp is less well represented).
!  For save cost, <=18 elements use 6 GTFs (even H and He, using 6 instead of 4 is important), heavier elements use 10 GTFs. Redundant GTF may be removed automatically during fitting
!  Command of Multiwfn used for generating the codes in this subroutine (relative error minimization): 300-2-3-7-0-1-8
subroutine genatmraddens_GTFfitparm(iele,nGTF,atomcoeff,atomexp)
integer iele,nGTF
real*8 atomcoeff(10),atomexp(10)

select case(iele)
case(  1)
    nGTF= 6
    atomcoeff( 1)=  2.45234007D-03
    atomcoeff( 2)=  2.16294690D-02
    atomcoeff( 3)=  6.58326719D-02
    atomcoeff( 4)=  9.05667077D-02
    atomcoeff( 5)=  7.33363536D-02
    atomcoeff( 6)=  4.36921724D-02
    atomexp( 1)=  1.96367316D-01
    atomexp( 2)=  4.36945909D-01
    atomexp( 3)=  1.08441287D+00
    atomexp( 4)=  3.15160046D+00
    atomexp( 5)=  1.13559544D+01
    atomexp( 6)=  5.18225323D+01
case(  2)
    nGTF= 6
    atomcoeff( 1)=  1.04897612D-02
    atomcoeff( 2)=  1.11363071D-01
    atomcoeff( 3)=  4.40876164D-01
    atomcoeff( 4)=  8.54118855D-01
    atomcoeff( 5)=  9.51293227D-01
    atomcoeff( 6)=  7.67040174D-01
    atomexp( 1)=  4.11586451D-01
    atomexp( 2)=  9.37345031D-01
    atomexp( 3)=  2.28431879D+00
    atomexp( 4)=  6.11336605D+00
    atomexp( 5)=  1.90314296D+01
    atomexp( 6)=  7.99337466D+01
case(  3)
    nGTF= 6
    atomcoeff( 1)=  1.55101027D-03
    atomcoeff( 2)=  8.39358098D-03
    atomcoeff( 3)= -3.48184223D-03
    atomcoeff( 4)=  5.52757609D-01
    atomcoeff( 5)=  3.24579808D+00
    atomcoeff( 6)=  7.04234733D+00
    atomexp( 1)=  6.91443744D-02
    atomexp( 2)=  1.52266244D-01
    atomexp( 3)=  2.17631938D-01
    atomexp( 4)=  2.33809621D+00
    atomexp( 5)=  7.24276363D+00
    atomexp( 6)=  4.25734249D+01
case(  4)
    nGTF= 6
    atomcoeff( 1)=  3.43318445D-03
    atomcoeff( 2)=  3.72041797D-02
    atomcoeff( 3)=  2.10292767D+00
    atomcoeff( 4)=  7.41056181D+00
    atomcoeff( 5)=  1.21929974D+01
    atomcoeff( 6)=  1.07375762D+01
    atomexp( 1)=  1.11117872D-01
    atomexp( 2)=  2.55127361D-01
    atomexp( 3)=  5.35994873D+00
    atomexp( 4)=  1.45311980D+01
    atomexp( 5)=  5.21784735D+01
    atomexp( 6)=  3.97267541D+02
case(  5)
    nGTF= 6
    atomcoeff( 1)=  2.02980712D-03
    atomcoeff( 2)=  2.99190433D-02
    atomcoeff( 3)=  1.13229647D-01
    atomcoeff( 4)=  6.04451334D+00
    atomcoeff( 5)=  2.20272702D+01
    atomcoeff( 6)=  3.25251257D+01
    atomexp( 1)=  1.18801512D-01
    atomexp( 2)=  2.53903537D-01
    atomexp( 3)=  5.42883629D-01
    atomexp( 4)=  9.79406092D+00
    atomexp( 5)=  3.17927864D+01
    atomexp( 6)=  2.01673699D+02
case(  6)
    nGTF= 6
    atomcoeff( 1)= -5.77087978D-04
    atomcoeff( 2)=  6.58618964D-03
    atomcoeff( 3)=  8.59499593D-02
    atomcoeff( 4)=  2.96849879D-01
    atomcoeff( 5)=  1.68210702D+01
    atomcoeff( 6)=  6.82336459D+01
    atomexp( 1)=  1.53246114D-01
    atomexp( 2)=  1.75734674D-01
    atomexp( 3)=  4.01661827D-01
    atomexp( 4)=  9.23292473D-01
    atomexp( 5)=  1.69315458D+01
    atomexp( 6)=  8.70186501D+01
case(  7)
    nGTF= 6
    atomcoeff( 1)=  1.71240438D-02
    atomcoeff( 2)=  1.96328147D-01
    atomcoeff( 3)=  6.15635896D-01
    atomcoeff( 4)=  1.74715324D+01
    atomcoeff( 5)=  5.31052121D+01
    atomcoeff( 6)=  7.05680220D+01
    atomexp( 1)=  2.64027977D-01
    atomexp( 2)=  6.00715990D-01
    atomexp( 3)=  1.37240650D+00
    atomexp( 4)=  2.03554334D+01
    atomexp( 5)=  5.93792737D+01
    atomexp( 6)=  2.31798742D+02
case(  8)
    nGTF= 6
    atomcoeff( 1)=  3.89024814D-02
    atomcoeff( 2)=  4.09414852D-01
    atomcoeff( 3)=  1.13734605D+00
    atomcoeff( 4)=  2.64873401D+01
    atomcoeff( 5)=  8.06944939D+01
    atomcoeff( 6)=  1.06631171D+02
    atomexp( 1)=  3.49500369D-01
    atomexp( 2)=  8.56853135D-01
    atomexp( 3)=  1.98126627D+00
    atomexp( 4)=  2.70491998D+01
    atomexp( 5)=  7.84202985D+01
    atomexp( 6)=  3.05966166D+02
case(  9)
    nGTF= 5
    atomcoeff( 1)=  5.05943240D-02
    atomcoeff( 2)=  8.78167776D-01
    atomcoeff( 3)=  2.08364721D+00
    atomcoeff( 4)=  7.27694691D+01
    atomcoeff( 5)=  2.41379608D+02
    atomexp( 1)=  3.99109035D-01
    atomexp( 2)=  1.14721551D+00
    atomexp( 3)=  3.06258572D+00
    atomexp( 4)=  4.43614874D+01
    atomexp( 5)=  2.37641187D+02
case( 10)
    nGTF= 6
    atomcoeff( 1)=  1.28174140D-01
    atomcoeff( 2)=  1.29545322D+00
    atomcoeff( 3)=  3.16973303D+00
    atomcoeff( 4)=  5.22179782D+01
    atomcoeff( 5)=  1.61216440D+02
    atomcoeff( 6)=  2.11732726D+02
    atomexp( 1)=  5.70530080D-01
    atomexp( 2)=  1.49731498D+00
    atomexp( 3)=  3.56486418D+00
    atomexp( 4)=  4.31922751D+01
    atomexp( 5)=  1.24104563D+02
    atomexp( 6)=  4.83831182D+02
case( 11)
    nGTF= 6
    atomcoeff( 1)=  7.62172706D-03
    atomcoeff( 2)=  1.19704322D+00
    atomcoeff( 3)=  5.54083704D+00
    atomcoeff( 4)=  6.27681914D+01
    atomcoeff( 5)=  2.11830528D+02
    atomcoeff( 6)=  2.91625478D+02
    atomexp( 1)=  1.10047729D-01
    atomexp( 2)=  1.41850138D+00
    atomexp( 3)=  3.84540110D+00
    atomexp( 4)=  5.05300649D+01
    atomexp( 5)=  1.41485995D+02
    atomexp( 6)=  5.47997174D+02
case( 12)
    nGTF= 6
    atomcoeff( 1)=  3.47221094D-03
    atomcoeff( 2)=  2.58533103D-02
    atomcoeff( 3)=  1.65031826D+00
    atomcoeff( 4)=  8.28442064D+00
    atomcoeff( 5)=  1.79761023D+02
    atomcoeff( 6)=  5.88189501D+02
    atomexp( 1)=  9.14586119D-02
    atomexp( 2)=  1.98390540D-01
    atomexp( 3)=  1.92048498D+00
    atomexp( 4)=  4.72995155D+00
    atomexp( 5)=  8.10650137D+01
    atomexp( 6)=  4.33244388D+02
case( 13)
    nGTF= 6
    atomcoeff( 1)=  4.13245685D-03
    atomcoeff( 2)= -7.65402046D-01
    atomcoeff( 3)=  8.21101978D-01
    atomcoeff( 4)=  3.52074695D+00
    atomcoeff( 5)=  1.28033616D+01
    atomcoeff( 6)=  5.41180349D+02
    atomexp( 1)=  9.26168520D-02
    atomexp( 2)=  2.43803076D-01
    atomexp( 3)=  2.43804185D-01
    atomexp( 4)=  2.78310366D+00
    atomexp( 5)=  7.06575980D+00
    atomexp( 6)=  1.53206365D+02
case( 14)
    nGTF= 6
    atomcoeff( 1)=  1.04312281D-01
    atomcoeff( 2)= -5.15091518D-01
    atomcoeff( 3)=  4.45036100D-01
    atomcoeff( 4)=  1.12468483D-01
    atomcoeff( 5)=  1.59593198D+01
    atomcoeff( 6)=  6.11895588D+02
    atomexp( 1)=  1.34820238D-01
    atomexp( 2)=  1.50749309D-01
    atomexp( 3)=  1.57323393D-01
    atomexp( 4)=  4.25289447D-01
    atomexp( 5)=  5.16323631D+00
    atomexp( 6)=  1.57451566D+02
case( 15)
    nGTF= 6
    atomcoeff( 1)=  5.88017650D-03
    atomcoeff( 2)=  6.65439575D-02
    atomcoeff( 3)=  1.73861353D-01
    atomcoeff( 4)=  2.12270786D+01
    atomcoeff( 5)=  2.63713040D+02
    atomcoeff( 6)=  1.18101550D+03
    atomexp( 1)=  1.36382004D-01
    atomexp( 2)=  2.77522973D-01
    atomexp( 3)=  5.16894508D-01
    atomexp( 4)=  6.36968554D+00
    atomexp( 5)=  1.06081178D+02
    atomexp( 6)=  5.47179624D+02
case( 16)
    nGTF= 6
    atomcoeff( 1)=  8.36954664D-03
    atomcoeff( 2)=  9.86981100D-02
    atomcoeff( 3)=  2.88050071D-01
    atomcoeff( 4)=  2.92829965D+01
    atomcoeff( 5)=  3.81770630D+02
    atomcoeff( 6)=  1.44210367D+03
    atomexp( 1)=  1.59821937D-01
    atomexp( 2)=  3.32797857D-01
    atomexp( 3)=  6.20449429D-01
    atomexp( 4)=  7.90755549D+00
    atomexp( 5)=  1.34470868D+02
    atomexp( 6)=  7.04086840D+02
case( 17)
    nGTF= 6
    atomcoeff( 1)=  1.17207348D-02
    atomcoeff( 2)=  1.47596210D-01
    atomcoeff( 3)=  4.46096082D-01
    atomcoeff( 4)=  3.91680066D+01
    atomcoeff( 5)=  5.13436675D+02
    atomcoeff( 6)=  1.73200868D+03
    atomexp( 1)=  1.89437042D-01
    atomexp( 2)=  3.98450508D-01
    atomexp( 3)=  7.40310400D-01
    atomexp( 4)=  9.63274379D+00
    atomexp( 5)=  1.63483701D+02
    atomexp( 6)=  8.66320738D+02
case( 18)
    nGTF= 6
    atomcoeff( 1)=  4.94726402D-02
    atomcoeff( 2)=  7.89808662D-01
    atomcoeff( 3)=  4.48017723D+01
    atomcoeff( 4)=  1.68110691D+01
    atomcoeff( 5)=  6.67162682D+02
    atomcoeff( 6)=  1.50860687D+03
    atomexp( 1)=  2.72946714D-01
    atomexp( 2)=  7.27948002D-01
    atomexp( 3)=  1.09955817D+01
    atomexp( 4)=  3.06572970D+01
    atomexp( 5)=  2.08231894D+02
    atomexp( 6)=  8.20882156D+02
case( 19)
    nGTF=10
    atomcoeff( 1)=  2.15527723D-01
    atomcoeff( 2)= -7.40360785D-01
    atomcoeff( 3)=  5.35591449D-01
    atomcoeff( 4)=  1.91047781D+00
    atomcoeff( 5)= -3.60286556D+00
    atomcoeff( 6)=  1.75573404D+00
    atomcoeff( 7)=  1.17578248D+00
    atomcoeff( 8)=  6.58932748D+01
    atomcoeff( 9)=  8.81600644D+02
    atomcoeff(10)=  2.71155273D+03
    atomexp( 1)=  8.92280608D-02
    atomexp( 2)=  9.59176374D-02
    atomexp( 3)=  9.91840782D-02
    atomexp( 4)=  2.73179316D-01
    atomexp( 5)=  2.78955889D-01
    atomexp( 6)=  2.89669055D-01
    atomexp( 7)=  9.28195303D-01
    atomexp( 8)=  1.37171083D+01
    atomexp( 9)=  2.32751218D+02
    atomexp(10)=  1.36668349D+03
case( 20)
    nGTF=10
    atomcoeff( 1)=  2.00921192D-01
    atomcoeff( 2)= -2.31645758D-01
    atomcoeff( 3)=  1.30390582D+00
    atomcoeff( 4)= -2.57426603D+00
    atomcoeff( 5)=  1.34377866D+00
    atomcoeff( 6)=  1.70018340D+00
    atomcoeff( 7)=  2.39653058D+02
    atomcoeff( 8)= -1.57199084D+02
    atomcoeff( 9)=  1.09015594D+03
    atomcoeff(10)=  3.22040538D+03
    atomexp( 1)=  1.03893088D-01
    atomexp( 2)=  1.08409604D-01
    atomexp( 3)=  1.93684367D-01
    atomexp( 4)=  2.10474546D-01
    atomexp( 5)=  2.27259340D-01
    atomexp( 6)=  1.10809710D+00
    atomexp( 7)=  1.65459652D+01
    atomexp( 8)=  1.68394993D+01
    atomexp( 9)=  2.68784845D+02
    atomexp(10)=  1.61130550D+03
case( 21)
    nGTF=10
    atomcoeff( 1)=  1.08821474D-01
    atomcoeff( 2)= -2.56220842D-01
    atomcoeff( 3)=  6.60628552D-01
    atomcoeff( 4)= -2.01340965D+00
    atomcoeff( 5)=  1.56357361D+00
    atomcoeff( 6)=  2.33649573D+00
    atomcoeff( 7)= -1.25723256D+00
    atomcoeff( 8)=  9.76316913D+01
    atomcoeff( 9)=  1.20989900D+03
    atomcoeff(10)=  3.72846621D+03
    atomexp( 1)=  1.10992399D-01
    atomexp( 2)=  1.30293646D-01
    atomexp( 3)=  1.79771463D-01
    atomexp( 4)=  2.27281844D-01
    atomexp( 5)=  2.43036736D-01
    atomexp( 6)=  1.28306760D+00
    atomexp( 7)=  5.36759444D+00
    atomexp( 8)=  1.74934952D+01
    atomexp( 9)=  2.89671324D+02
    atomexp(10)=  1.67168157D+03
case( 22)
    nGTF=10
    atomcoeff( 1)=  1.51353236D-01
    atomcoeff( 2)= -2.44613188D-01
    atomcoeff( 3)=  1.26857269D+00
    atomcoeff( 4)= -2.20359463D+00
    atomcoeff( 5)=  1.98974945D+00
    atomcoeff( 6)= -3.03291758D+00
    atomcoeff( 7)=  2.21278804D+00
    atomcoeff( 8)=  2.85187139D+00
    atomcoeff( 9)=  1.27603564D+02
    atomcoeff(10)=  3.14098860D+03
    atomexp( 1)=  1.08471764D-01
    atomexp( 2)=  1.18347283D-01
    atomexp( 3)=  1.80026984D-01
    atomexp( 4)=  2.04009597D-01
    atomexp( 5)=  2.55885611D-01
    atomexp( 6)=  3.40966103D-01
    atomexp( 7)=  3.73282790D-01
    atomexp( 8)=  1.45953270D+00
    atomexp( 9)=  2.12807163D+01
    atomexp(10)=  5.12574748D+02
case( 23)
    nGTF=10
    atomcoeff( 1)=  1.53859521D-01
    atomcoeff( 2)= -1.48268380D-01
    atomcoeff( 3)=  3.47974429D+00
    atomcoeff( 4)= -5.31312590D+00
    atomcoeff( 5)= -1.45955010D+00
    atomcoeff( 6)=  3.42509792D+00
    atomcoeff( 7)=  3.73883906D+00
    atomcoeff( 8)= -7.25742775D-01
    atomcoeff( 9)=  1.48584596D+02
    atomcoeff(10)=  3.61236666D+03
    atomexp( 1)=  9.07031680D-02
    atomexp( 2)=  9.08611678D-02
    atomexp( 3)=  2.98651760D-01
    atomexp( 4)=  3.12155242D-01
    atomexp( 5)=  3.44536432D-01
    atomexp( 6)=  3.44870724D-01
    atomexp( 7)=  1.61843964D+00
    atomexp( 8)=  6.48570415D+00
    atomexp( 9)=  2.33335384D+01
    atomexp(10)=  5.62529280D+02
case( 24)
    nGTF=10
    atomcoeff( 1)=  2.50516270D-02
    atomcoeff( 2)= -7.62544162D-01
    atomcoeff( 3)=  2.67432179D+00
    atomcoeff( 4)= -3.76606593D+00
    atomcoeff( 5)=  4.26104204D+00
    atomcoeff( 6)= -2.43937122D+00
    atomcoeff( 7)=  4.03314795D-01
    atomcoeff( 8)=  4.43859989D+00
    atomcoeff( 9)=  1.75784316D+02
    atomcoeff(10)=  4.18495830D+03
    atomexp( 1)=  1.10658716D-01
    atomexp( 2)=  1.63025966D-01
    atomexp( 3)=  1.86698924D-01
    atomexp( 4)=  2.14403285D-01
    atomexp( 5)=  2.58686548D-01
    atomexp( 6)=  2.80542005D-01
    atomexp( 7)=  6.91039547D-01
    atomexp( 8)=  1.84702836D+00
    atomexp( 9)=  2.64752339D+01
    atomexp(10)=  6.24997730D+02
case( 25)
    nGTF=10
    atomcoeff( 1)=  1.34296500D-01
    atomcoeff( 2)= -1.37435561D-01
    atomcoeff( 3)=  3.29260056D+00
    atomcoeff( 4)= -2.26021105D+00
    atomcoeff( 5)= -4.14924825D+00
    atomcoeff( 6)=  3.17320107D+00
    atomcoeff( 7)=  5.38858860D-01
    atomcoeff( 8)=  5.62887719D+00
    atomcoeff( 9)=  2.06166931D+02
    atomcoeff(10)=  4.81280062D+03
    atomexp( 1)=  1.03417045D-01
    atomexp( 2)=  1.05133315D-01
    atomexp( 3)=  2.15573849D-01
    atomexp( 4)=  2.20231965D-01
    atomexp( 5)=  2.24356378D-01
    atomexp( 6)=  2.31083674D-01
    atomexp( 7)=  9.50020467D-01
    atomexp( 8)=  2.13262989D+00
    atomexp( 9)=  2.96010150D+01
    atomexp(10)=  6.89688204D+02
case( 26)
    nGTF=10
    atomcoeff( 1)=  4.75217506D-03
    atomcoeff( 2)=  2.36002777D-02
    atomcoeff( 3)=  2.97341978D-01
    atomcoeff( 4)=  7.19435150D+00
    atomcoeff( 5)=  1.27715138D+02
    atomcoeff( 6)=  9.12954599D+01
    atomcoeff( 7)=  2.05568731D+03
    atomcoeff( 8)=  5.32030796D+03
    atomcoeff( 9)=  2.67936670D+03
    atomcoeff(10)= -1.94724626D+02
    atomexp( 1)=  1.00556886D-01
    atomexp( 2)=  1.88735520D-01
    atomexp( 3)=  6.87833464D-01
    atomexp( 4)=  2.22175973D+00
    atomexp( 5)=  3.13504011D+01
    atomexp( 6)=  3.13565023D+01
    atomexp( 7)=  4.41969018D+02
    atomexp( 8)=  1.79487272D+03
    atomexp( 9)=  3.67189159D+05
    atomexp(10)=  1.44277281D+06
case( 27)
    nGTF=10
    atomcoeff( 1)=  1.07333676D-01
    atomcoeff( 2)= -1.11714910D-01
    atomcoeff( 3)=  1.04922882D+00
    atomcoeff( 4)= -2.03643132D+00
    atomcoeff( 5)=  1.05400489D+00
    atomcoeff( 6)=  7.57386240D-01
    atomcoeff( 7)=  8.58644879D+00
    atomcoeff( 8)=  2.57280057D+02
    atomcoeff( 9)=  3.21886541D+03
    atomcoeff(10)=  8.81446107D+03
    atomexp( 1)=  1.09684589D-01
    atomexp( 2)=  1.11788733D-01
    atomexp( 3)=  2.13090166D-01
    atomexp( 4)=  2.25772004D-01
    atomexp( 5)=  2.40972213D-01
    atomexp( 6)=  1.05421229D+00
    atomexp( 7)=  2.59300651D+00
    atomexp( 8)=  3.48786095D+01
    atomexp( 9)=  5.58896149D+02
    atomexp(10)=  3.62395289D+03
case( 28)
    nGTF=10
    atomcoeff( 1)=  2.70078781D-03
    atomcoeff( 2)=  4.53027993D-01
    atomcoeff( 3)= -4.31960528D-01
    atomcoeff( 4)= -6.67339375D+00
    atomcoeff( 5)=  6.73985306D+00
    atomcoeff( 6)= -8.11945057D+00
    atomcoeff( 7)=  9.19187923D+00
    atomcoeff( 8)=  1.04202242D+01
    atomcoeff( 9)=  3.10538941D+02
    atomcoeff(10)=  7.01392207D+03
    atomexp( 1)=  9.32266552D-02
    atomexp( 2)=  1.86727520D-01
    atomexp( 3)=  1.86804291D-01
    atomexp( 4)=  3.96456542D-01
    atomexp( 5)=  3.96642399D-01
    atomexp( 6)=  1.21717364D+00
    atomexp( 7)=  1.21731580D+00
    atomexp( 8)=  2.90975542D+00
    atomexp( 9)=  3.92487639D+01
    atomexp(10)=  8.94500230D+02
case( 29)
    nGTF=10
    atomcoeff( 1)=  2.14668121D-03
    atomcoeff( 2)= -1.47306077D+00
    atomcoeff( 3)= -1.93456811D+00
    atomcoeff( 4)=  3.42095675D+00
    atomcoeff( 5)=  1.05138093D-01
    atomcoeff( 6)=  1.37644125D+00
    atomcoeff( 7)=  1.22346975D+01
    atomcoeff( 8)=  3.28939832D+02
    atomcoeff( 9)=  4.07028783D+03
    atomcoeff(10)=  1.12877323D+04
    atomexp( 1)=  8.99667859D-02
    atomexp( 2)=  1.75399728D-01
    atomexp( 3)=  1.75411233D-01
    atomexp( 4)=  1.75467276D-01
    atomexp( 5)=  4.91012643D-01
    atomexp( 6)=  1.27801657D+00
    atomexp( 7)=  3.14862015D+00
    atomexp( 8)=  4.12850247D+01
    atomexp( 9)=  6.54303878D+02
    atomexp(10)=  4.30119028D+03
case( 30)
    nGTF=10
    atomcoeff( 1)=  6.38621477D-02
    atomcoeff( 2)= -6.28978831D-02
    atomcoeff( 3)=  1.63141563D+00
    atomcoeff( 4)= -1.60804316D+00
    atomcoeff( 5)= -5.24423890D+00
    atomcoeff( 6)=  5.33619355D+00
    atomcoeff( 7)=  1.59754293D+00
    atomcoeff( 8)=  1.50453958D+01
    atomcoeff( 9)=  3.96044025D+02
    atomcoeff(10)=  8.82188497D+03
    atomexp( 1)=  1.11309713D-01
    atomexp( 2)=  1.12524099D-01
    atomexp( 3)=  1.93717594D-01
    atomexp( 4)=  1.93780311D-01
    atomexp( 5)=  4.67325319D-01
    atomexp( 6)=  4.67325668D-01
    atomexp( 7)=  1.41815179D+00
    atomexp( 8)=  3.49297530D+00
    atomexp( 9)=  4.64210377D+01
    atomexp(10)=  1.04704537D+03
case( 31)
    nGTF=10
    atomcoeff( 1)=  1.84570829D-01
    atomcoeff( 2)= -3.96874728D-01
    atomcoeff( 3)=  2.30563202D-01
    atomcoeff( 4)=  1.15836740D-01
    atomcoeff( 5)=  1.53427304D+00
    atomcoeff( 6)= -1.25561017D+01
    atomcoeff( 7)=  3.09461941D+01
    atomcoeff( 8)=  4.17276025D+02
    atomcoeff( 9)=  5.12004443D+03
    atomcoeff(10)=  1.42799788D+04
    atomexp( 1)=  1.09486856D-01
    atomexp( 2)=  1.16043135D-01
    atomexp( 3)=  1.24237229D-01
    atomexp( 4)=  4.07628691D-01
    atomexp( 5)=  1.48952264D+00
    atomexp( 6)=  3.82067760D+00
    atomexp( 7)=  3.82763350D+00
    atomexp( 8)=  4.87653942D+01
    atomexp( 9)=  7.64191897D+02
    atomexp(10)=  5.10687052D+03
case( 32)
    nGTF=10
    atomcoeff( 1)=  8.16354544D-02
    atomcoeff( 2)= -7.83754662D-02
    atomcoeff( 3)=  6.62009340D-02
    atomcoeff( 4)=  4.13881270D-01
    atomcoeff( 5)=  7.61822174D+02
    atomcoeff( 6)= -7.40891594D+02
    atomcoeff( 7)=  4.32293645D+02
    atomcoeff( 8)=  1.94272424D+03
    atomcoeff( 9)=  8.71814205D+03
    atomcoeff(10)=  1.55095994D+04
    atomexp( 1)=  9.80503399D-02
    atomexp( 2)=  9.80503593D-02
    atomexp( 3)=  2.44282482D-01
    atomexp( 4)=  7.97948026D-01
    atomexp( 5)=  3.67889164D+00
    atomexp( 6)=  3.67889415D+00
    atomexp( 7)=  4.95803057D+01
    atomexp( 8)=  5.07945527D+02
    atomexp( 9)=  1.67308372D+03
    atomexp(10)=  1.34522259D+04
case( 33)
    nGTF=10
    atomcoeff( 1)=  1.90063553D-03
    atomcoeff( 2)=  6.26307797D-02
    atomcoeff( 3)=  2.53314934D-01
    atomcoeff( 4)=  2.82175132D+00
    atomcoeff( 5)=  2.59154802D+01
    atomcoeff( 6)=  5.28879298D+02
    atomcoeff( 7)=  2.16923845D+03
    atomcoeff( 8)=  3.62598451D+03
    atomcoeff( 9)=  6.67306978D+03
    atomcoeff(10)= -3.09347471D+03
    atomexp( 1)=  1.00020979D-01
    atomexp( 2)=  2.34641107D-01
    atomexp( 3)=  5.58268739D-01
    atomexp( 4)=  2.32650048D+00
    atomexp( 5)=  4.77421474D+00
    atomexp( 6)=  5.78269967D+01
    atomexp( 7)=  5.14042109D+02
    atomexp( 8)=  2.03063047D+03
    atomexp( 9)=  7.21047653D+05
    atomexp(10)=  3.24764841D+06
case( 34)
    nGTF= 9
    atomcoeff( 1)=  4.25517143D-03
    atomcoeff( 2)=  7.70617702D-02
    atomcoeff( 3)=  3.04167517D-01
    atomcoeff( 4)=  1.98939689D+00
    atomcoeff( 5)=  3.10931878D+01
    atomcoeff( 6)=  5.80697800D+02
    atomcoeff( 7)=  5.05838289D+03
    atomcoeff( 8)=  1.24207326D+04
    atomcoeff( 9)=  1.84832576D+04
    atomexp( 1)=  1.24747461D-01
    atomexp( 2)=  2.70693925D-01
    atomexp( 3)=  5.59798515D-01
    atomexp( 4)=  2.32132983D+00
    atomexp( 5)=  5.10006634D+00
    atomexp( 6)=  6.20175965D+01
    atomexp( 7)=  8.22724627D+02
    atomexp( 8)=  3.25272246D+03
    atomexp( 9)=  2.97523713D+04
case( 35)
    nGTF=10
    atomcoeff( 1)= -1.56371612D-01
    atomcoeff( 2)=  2.64644126D-01
    atomcoeff( 3)= -3.21822829D+00
    atomcoeff( 4)=  4.86014886D+00
    atomcoeff( 5)= -4.43451696D+00
    atomcoeff( 6)=  2.78309547D+00
    atomcoeff( 7)=  4.81671787D-01
    atomcoeff( 8)=  5.32781534D+00
    atomcoeff( 9)=  3.68043389D+01
    atomcoeff(10)=  8.83592725D+02
    atomexp( 1)=  1.07084977D-01
    atomexp( 2)=  1.11991768D-01
    atomexp( 3)=  1.52386634D-01
    atomexp( 4)=  1.60678538D-01
    atomexp( 5)=  1.89228506D-01
    atomexp( 6)=  2.02167034D-01
    atomexp( 7)=  6.32359798D-01
    atomexp( 8)=  3.37240441D+00
    atomexp( 9)=  6.01780038D+00
    atomexp(10)=  7.84592530D+01
case( 36)
    nGTF=10
    atomcoeff( 1)=  2.03440577D-03
    atomcoeff( 2)=  1.67590210D-01
    atomcoeff( 3)=  6.60652895D-01
    atomcoeff( 4)=  4.36659012D+01
    atomcoeff( 5)=  5.53043356D+02
    atomcoeff( 6)=  1.57186801D+02
    atomcoeff( 7)=  6.49233761D+03
    atomcoeff( 8)=  1.62569619D+04
    atomcoeff( 9)=  5.93157475D+03
    atomcoeff(10)= -3.22833263D+03
    atomexp( 1)=  1.11795968D-01
    atomexp( 2)=  3.43935549D-01
    atomexp( 3)=  7.62231598D-01
    atomexp( 4)=  5.79589412D+00
    atomexp( 5)=  7.14147305D+01
    atomexp( 6)=  7.14790523D+01
    atomexp( 7)=  9.58180987D+02
    atomexp( 8)=  4.08388722D+03
    atomexp( 9)=  7.97258821D+05
    atomexp(10)=  3.18626332D+06
case( 37)
    nGTF=10
    atomcoeff( 1)=  3.60048741D-01
    atomcoeff( 2)= -3.88022496D-01
    atomcoeff( 3)=  1.76198096D+00
    atomcoeff( 4)= -4.89831787D+00
    atomcoeff( 5)=  3.25840765D+00
    atomcoeff( 6)=  6.45620114D+00
    atomcoeff( 7)= -1.00811890D+01
    atomcoeff( 8)=  4.67573107D+00
    atomcoeff( 9)=  5.41985306D+01
    atomcoeff(10)=  1.09001652D+03
    atomexp( 1)=  9.28558021D-02
    atomexp( 2)=  9.50716347D-02
    atomexp( 3)=  1.94131185D-01
    atomexp( 4)=  2.12533089D-01
    atomexp( 5)=  2.24752262D-01
    atomexp( 6)=  7.91432457D-01
    atomexp( 7)=  8.29697491D-01
    atomexp( 8)=  8.82373586D-01
    atomexp( 9)=  6.54663753D+00
    atomexp(10)=  9.07037899D+01
case( 38)
    nGTF=10
    atomcoeff( 1)=  2.30951337D-01
    atomcoeff( 2)= -2.23898007D-01
    atomcoeff( 3)=  5.73548091D+00
    atomcoeff( 4)= -1.37892108D+00
    atomcoeff( 5)= -7.73688062D+00
    atomcoeff( 6)=  1.16438401D+01
    atomcoeff( 7)= -8.41471386D+00
    atomcoeff( 8)=  1.54991864D+00
    atomcoeff( 9)=  6.31669158D+01
    atomcoeff(10)=  1.21440005D+03
    atomexp( 1)=  7.96972534D-02
    atomexp( 2)=  7.98631646D-02
    atomexp( 3)=  3.00851663D-01
    atomexp( 4)=  3.05756528D-01
    atomexp( 5)=  3.18700608D-01
    atomexp( 6)=  3.88637632D-01
    atomexp( 7)=  4.13225589D-01
    atomexp( 8)=  8.37082378D-01
    atomexp( 9)=  7.25397324D+00
    atomexp(10)=  9.84674869D+01
case( 39)
    nGTF=10
    atomcoeff( 1)=  3.57429205D-03
    atomcoeff( 2)=  1.70877676D-02
    atomcoeff( 3)=  3.57734362D+00
    atomcoeff( 4)= -3.86433277D+00
    atomcoeff( 5)=  4.54220196D-01
    atomcoeff( 6)=  1.54441285D+00
    atomcoeff( 7)= -9.82673382D+01
    atomcoeff( 8)=  1.64387992D+02
    atomcoeff( 9)=  1.05978831D+03
    atomcoeff(10)=  2.19690404D+04
    atomexp( 1)=  6.70523681D-02
    atomexp( 2)=  1.33035149D-01
    atomexp( 3)=  4.11618854D-01
    atomexp( 4)=  4.15056809D-01
    atomexp( 5)=  4.85418246D-01
    atomexp( 6)=  1.01098641D+00
    atomexp( 7)=  6.20681264D+00
    atomexp( 8)=  6.73068849D+00
    atomexp( 9)=  9.30589734D+01
    atomexp(10)=  1.98185335D+03
case( 40)
    nGTF=10
    atomcoeff( 1)=  1.23156127D-01
    atomcoeff( 2)= -5.24439783D-01
    atomcoeff( 3)=  1.04675798D+00
    atomcoeff( 4)= -1.66250536D+00
    atomcoeff( 5)=  1.10969678D+00
    atomcoeff( 6)=  1.90503537D+00
    atomcoeff( 7)=  1.87590297D+02
    atomcoeff( 8)=  6.94118621D+01
    atomcoeff( 9)= -1.79083695D+02
    atomcoeff(10)=  1.46546072D+03
    atomexp( 1)=  1.11315686D-01
    atomexp( 2)=  1.36700563D-01
    atomexp( 3)=  1.66702278D-01
    atomexp( 4)=  2.10796274D-01
    atomexp( 5)=  2.34942753D-01
    atomexp( 6)=  1.02010773D+00
    atomexp( 7)=  9.92480600D+00
    atomexp( 8)=  9.97987925D+00
    atomexp( 9)=  1.08774453D+01
    atomexp(10)=  1.11818533D+02
case( 41)
    nGTF=10
    atomcoeff( 1)=  2.94955410D-03
    atomcoeff( 2)=  2.52586712D-02
    atomcoeff( 3)=  1.62840523D-01
    atomcoeff( 4)=  2.06666806D+00
    atomcoeff( 5)=  1.54991014D+02
    atomcoeff( 6)= -9.07712557D+01
    atomcoeff( 7)=  1.12281302D+03
    atomcoeff( 8)=  8.94560473D+03
    atomcoeff( 9)=  2.35906088D+04
    atomcoeff(10)=  3.91722825D+04
    atomexp( 1)=  8.09326737D-02
    atomexp( 2)=  1.71874019D-01
    atomexp( 3)=  4.37397150D-01
    atomexp( 4)=  1.09135817D+00
    atomexp( 5)=  1.07223335D+01
    atomexp( 6)=  1.60349314D+01
    atomexp( 7)=  9.47176417D+01
    atomexp( 8)=  1.21778564D+03
    atomexp( 9)=  4.79460676D+03
    atomexp(10)=  4.20102198D+04
case( 42)
    nGTF= 9
    atomcoeff( 1)=  1.92353035D-03
    atomcoeff( 2)=  7.10342755D-02
    atomcoeff( 3)=  2.18747826D+00
    atomcoeff( 4)=  1.71464118D+01
    atomcoeff( 5)=  8.08039166D+01
    atomcoeff( 6)=  1.25491277D+03
    atomcoeff( 7)=  9.61989585D+03
    atomcoeff( 8)=  2.01937856D+04
    atomcoeff( 9)=  2.92321544D+04
    atomexp( 1)=  6.99521322D-02
    atomexp( 2)=  2.33079398D-01
    atomexp( 3)=  9.92585037D-01
    atomexp( 4)=  9.79192017D+00
    atomexp( 5)=  9.79367350D+00
    atomexp( 6)=  1.07790312D+02
    atomexp( 7)=  1.32411447D+03
    atomexp( 8)=  4.42337986D+03
    atomexp( 9)=  2.08242970D+04
case( 43)
    nGTF=10
    atomcoeff( 1)=  8.17175019D-02
    atomcoeff( 2)= -1.26782202D-01
    atomcoeff( 3)=  1.72939479D+00
    atomcoeff( 4)= -3.57819770D+00
    atomcoeff( 5)=  2.06115065D+00
    atomcoeff( 6)=  3.15150155D+00
    atomcoeff( 7)= -5.14585014D+01
    atomcoeff( 8)=  3.00265216D+01
    atomcoeff( 9)=  1.37043229D+02
    atomcoeff(10)=  1.94173449D+03
    atomexp( 1)=  1.13342730D-01
    atomexp( 2)=  1.27150440D-01
    atomexp( 3)=  2.22619924D-01
    atomexp( 4)=  2.46351061D-01
    atomexp( 5)=  2.72252883D-01
    atomexp( 6)=  1.23053838D+00
    atomexp( 7)=  7.77731991D+00
    atomexp( 8)=  9.66099684D+00
    atomexp( 9)=  9.70353830D+00
    atomexp(10)=  1.38054535D+02
case( 44)
    nGTF=10
    atomcoeff( 1)=  7.21663573D-02
    atomcoeff( 2)= -2.39273978D-01
    atomcoeff( 3)=  1.89062793D-01
    atomcoeff( 4)=  1.69708867D+00
    atomcoeff( 5)= -1.44754876D+00
    atomcoeff( 6)=  3.32779215D+00
    atomcoeff( 7)=  9.63701149D+02
    atomcoeff( 8)= -8.72629034D+02
    atomcoeff( 9)=  1.60793502D+03
    atomcoeff(10)=  3.31690434D+04
    atomexp( 1)=  1.14149326D-01
    atomexp( 2)=  1.27243029D-01
    atomexp( 3)=  1.36174278D-01
    atomexp( 4)=  4.68726181D-01
    atomexp( 5)=  4.68739088D-01
    atomexp( 6)=  1.28156226D+00
    atomexp( 7)=  1.56315401D+01
    atomexp( 8)=  1.68621554D+01
    atomexp( 9)=  1.19638505D+02
    atomexp(10)=  2.60973228D+03
case( 45)
    nGTF=10
    atomcoeff( 1)=  3.41848707D-02
    atomcoeff( 2)= -2.47961544D-01
    atomcoeff( 3)=  2.39268543D-01
    atomcoeff( 4)=  3.61050110D-01
    atomcoeff( 5)=  4.31652534D+00
    atomcoeff( 6)= -1.57019985D+01
    atomcoeff( 7)=  2.00808160D+02
    atomcoeff( 8)=  8.81830462D+01
    atomcoeff( 9)= -1.33092321D+02
    atomcoeff(10)=  2.28835120D+03
    atomexp( 1)=  1.14461545D-01
    atomexp( 2)=  1.39013500D-01
    atomexp( 3)=  1.46203195D-01
    atomexp( 4)=  5.32843203D-01
    atomexp( 5)=  1.43345048D+00
    atomexp( 6)=  6.96721594D+00
    atomexp( 7)=  1.27901213D+01
    atomexp( 8)=  1.30028655D+01
    atomexp( 9)=  1.47617938D+01
    atomexp(10)=  1.54728548D+02
case( 46)
    nGTF=10
    atomcoeff( 1)=  8.19721322D-04
    atomcoeff( 2)= -3.42920282D+00
    atomcoeff( 3)=  3.43638333D+00
    atomcoeff( 4)=  1.03558444D-01
    atomcoeff( 5)=  9.09255567D-01
    atomcoeff( 6)=  9.19735415D+00
    atomcoeff( 7)= -3.77610229D+00
    atomcoeff( 8)= -1.44323565D+01
    atomcoeff( 9)=  1.73501053D+02
    atomcoeff(10)=  2.49680682D+03
    atomexp( 1)=  1.13374923D-01
    atomexp( 2)=  1.57592567D-01
    atomexp( 3)=  1.57622149D-01
    atomexp( 4)=  3.52603493D-01
    atomexp( 5)=  7.91292450D-01
    atomexp( 6)=  1.78300114D+00
    atomexp( 7)=  1.81709143D+00
    atomexp( 8)=  5.78865383D+00
    atomexp( 9)=  1.25617505D+01
    atomexp(10)=  1.65595444D+02
case( 47)
    nGTF=10
    atomcoeff( 1)=  1.28973686D-02
    atomcoeff( 2)= -4.86042231D-01
    atomcoeff( 3)=  1.47171729D+00
    atomcoeff( 4)= -1.26455735D+00
    atomcoeff( 5)=  5.50638231D-01
    atomcoeff( 6)=  5.25721001D+00
    atomcoeff( 7)=  7.17323320D+01
    atomcoeff( 8)=  2.46025958D+02
    atomcoeff( 9)= -1.59845802D+02
    atomcoeff(10)=  2.68020146D+03
    atomexp( 1)=  1.15116854D-01
    atomexp( 2)=  1.99700672D-01
    atomexp( 3)=  2.29346784D-01
    atomexp( 4)=  2.61853421D-01
    atomexp( 5)=  3.92407988D-01
    atomexp( 6)=  1.45562796D+00
    atomexp( 7)=  1.65207733D+01
    atomexp( 8)=  1.73602979D+01
    atomexp( 9)=  2.46296923D+01
    atomexp(10)=  1.70932997D+02
case( 48)
    nGTF=10
    atomcoeff( 1)=  3.86345001D-03
    atomcoeff( 2)=  2.89429598D-01
    atomcoeff( 3)= -2.54037313D-01
    atomcoeff( 4)=  4.58728574D-01
    atomcoeff( 5)= -4.10623401D+01
    atomcoeff( 6)=  4.69031480D+01
    atomcoeff( 7)=  2.08510808D+02
    atomcoeff( 8)=  2.18461495D+03
    atomcoeff( 9)=  2.57038522D+04
    atomcoeff(10)=  7.49203541D+04
    atomexp( 1)=  9.80510759D-02
    atomexp( 2)=  2.12585408D-01
    atomexp( 3)=  2.12591646D-01
    atomexp( 4)=  6.33421126D-01
    atomexp( 5)=  1.40666945D+00
    atomexp( 6)=  1.43072595D+00
    atomexp( 7)=  1.64592862D+01
    atomexp( 8)=  1.63589791D+02
    atomexp( 9)=  2.33086887D+03
    atomexp(10)=  1.71876428D+04
case( 49)
    nGTF=10
    atomcoeff( 1)=  9.26578932D-02
    atomcoeff( 2)= -1.03945060D-01
    atomcoeff( 3)=  3.51373429D+00
    atomcoeff( 4)= -6.76886376D+00
    atomcoeff( 5)=  3.55417898D+00
    atomcoeff( 6)=  7.91689920D+00
    atomcoeff( 7)= -2.97814754D+02
    atomcoeff( 8)=  3.76398876D+01
    atomcoeff( 9)=  4.78545233D+02
    atomcoeff(10)=  3.18579120D+03
    atomexp( 1)=  1.13253623D-01
    atomexp( 2)=  1.19357533D-01
    atomexp( 3)=  2.83569883D-01
    atomexp( 4)=  3.05492712D-01
    atomexp( 5)=  3.37081231D-01
    atomexp( 6)=  1.77500208D+00
    atomexp( 7)=  1.22812464D+01
    atomexp( 8)=  1.32291073D+01
    atomexp( 9)=  1.39370974D+01
    atomexp(10)=  1.98440251D+02
case( 50)
    nGTF=10
    atomcoeff( 1)=  1.07589046D-01
    atomcoeff( 2)= -1.02819418D-01
    atomcoeff( 3)=  4.80701593D+00
    atomcoeff( 4)= -4.72811451D+00
    atomcoeff( 5)=  5.72775103D-01
    atomcoeff( 6)=  1.04469697D+01
    atomcoeff( 7)= -4.66586392D+01
    atomcoeff( 8)= -1.07095962D+03
    atomcoeff( 9)=  1.34862495D+03
    atomcoeff(10)=  3.40638874D+03
    atomexp( 1)=  1.06981254D-01
    atomexp( 2)=  1.07851186D-01
    atomexp( 3)=  2.39604183D-01
    atomexp( 4)=  2.39625321D-01
    atomexp( 5)=  7.68205671D-01
    atomexp( 6)=  2.15901475D+00
    atomexp( 7)=  1.25962206D+01
    atomexp( 8)=  1.26672100D+01
    atomexp( 9)=  1.33532795D+01
    atomexp(10)=  2.06727011D+02
case( 51)
    nGTF=10
    atomcoeff( 1)=  7.96828845D-03
    atomcoeff( 2)= -1.16206721D-02
    atomcoeff( 3)=  5.55665025D+00
    atomcoeff( 4)= -5.63975556D+00
    atomcoeff( 5)=  1.05226455D+01
    atomcoeff( 6)= -1.01153343D+01
    atomcoeff( 7)=  1.02753484D+01
    atomcoeff( 8)=  9.24503408D+01
    atomcoeff( 9)=  2.06309364D+02
    atomcoeff(10)=  3.75504649D+03
    atomexp( 1)=  1.13397420D-01
    atomexp( 2)=  1.91932210D-01
    atomexp( 3)=  3.08631345D-01
    atomexp( 4)=  3.12972785D-01
    atomexp( 5)=  5.82233551D-01
    atomexp( 6)=  5.87755432D-01
    atomexp( 7)=  2.08365398D+00
    atomexp( 8)=  2.04862124D+01
    atomexp( 9)=  2.08247701D+01
    atomexp(10)=  2.30947269D+02
case( 52)
    nGTF=10
    atomcoeff( 1)=  2.85419952D-02
    atomcoeff( 2)= -3.41620640D-01
    atomcoeff( 3)=  3.37544084D-01
    atomcoeff( 4)=  2.57828770D-01
    atomcoeff( 5)= -1.23314285D+01
    atomcoeff( 6)=  2.74377468D+01
    atomcoeff( 7)= -2.66037233D+00
    atomcoeff( 8)= -2.48856494D+01
    atomcoeff( 9)=  3.27763862D+02
    atomcoeff(10)=  4.07283534D+03
    atomexp( 1)=  1.13713910D-01
    atomexp( 2)=  1.31140622D-01
    atomexp( 3)=  1.34373634D-01
    atomexp( 4)=  3.67516900D-01
    atomexp( 5)=  2.25386965D+00
    atomexp( 6)=  2.26231808D+00
    atomexp( 7)=  2.35059375D+00
    atomexp( 8)=  1.02965788D+01
    atomexp( 9)=  1.96738333D+01
    atomexp(10)=  2.40188595D+02
case( 53)
    nGTF=10
    atomcoeff( 1)=  4.36673259D-03
    atomcoeff( 2)= -6.35475284D-01
    atomcoeff( 3)=  4.51095468D+00
    atomcoeff( 4)= -6.69671224D+00
    atomcoeff( 5)=  2.95880017D+00
    atomcoeff( 6)=  4.10213056D-01
    atomcoeff( 7)=  1.77340670D+01
    atomcoeff( 8)= -1.20866957D+02
    atomcoeff( 9)=  4.25485817D+02
    atomcoeff(10)=  4.27992946D+03
    atomexp( 1)=  1.13397705D-01
    atomexp( 2)=  1.66766542D-01
    atomexp( 3)=  1.83391753D-01
    atomexp( 4)=  1.93722746D-01
    atomexp( 5)=  2.06943356D-01
    atomexp( 6)=  6.11969712D-01
    atomexp( 7)=  2.78766016D+00
    atomexp( 8)=  1.19001517D+01
    atomexp( 9)=  1.80078667D+01
    atomexp(10)=  2.44908386D+02
case( 54)
    nGTF= 9
    atomcoeff( 1)=  2.15892763D-01
    atomcoeff( 2)=  6.58576587D-01
    atomcoeff( 3)=  2.42002254D+01
    atomcoeff( 4)= -3.36762358D+03
    atomcoeff( 5)=  3.65369568D+03
    atomcoeff( 6)=  3.09266865D+03
    atomcoeff( 7)=  2.31758961D+04
    atomcoeff( 8)=  5.26255801D+04
    atomcoeff( 9)=  9.01324755D+04
    atomexp( 1)=  2.92558709D-01
    atomexp( 2)=  8.07508432D-01
    atomexp( 3)=  3.34775339D+00
    atomexp( 4)=  1.42446912D+01
    atomexp( 5)=  1.47119470D+01
    atomexp( 6)=  2.00588158D+02
    atomexp( 7)=  2.40318270D+03
    atomexp( 8)=  8.30285916D+03
    atomexp( 9)=  4.10934632D+04
case( 55)
    nGTF=10
    atomcoeff( 1)=  3.03277068D-01
    atomcoeff( 2)= -6.00192997D-01
    atomcoeff( 3)=  3.07240603D-01
    atomcoeff( 4)=  3.64052487D-01
    atomcoeff( 5)=  5.32707146D-01
    atomcoeff( 6)=  2.70824180D+01
    atomcoeff( 7)= -1.85218639D+02
    atomcoeff( 8)=  2.35381131D+02
    atomcoeff( 9)=  2.99041323D+02
    atomcoeff(10)=  4.92011055D+03
    atomexp( 1)=  8.63775824D-02
    atomexp( 2)=  9.17228469D-02
    atomexp( 3)=  9.81296717D-02
    atomexp( 4)=  4.13184628D-01
    atomexp( 5)=  8.07021754D-01
    atomexp( 6)=  3.54527692D+00
    atomexp( 7)=  1.28245139D+01
    atomexp( 8)=  1.92008453D+01
    atomexp( 9)=  1.93876825D+01
    atomexp(10)=  2.69558708D+02
case( 56)
    nGTF=10
    atomcoeff( 1)=  2.86290163D-01
    atomcoeff( 2)= -2.78147781D-01
    atomcoeff( 3)=  6.74398540D+00
    atomcoeff( 4)= -6.03430283D-01
    atomcoeff( 5)= -6.19147680D+00
    atomcoeff( 6)= -1.19561414D+01
    atomcoeff( 7)=  1.28510138D+01
    atomcoeff( 8)=  2.09999970D+01
    atomcoeff( 9)=  4.82288658D+02
    atomcoeff(10)=  5.68852479D+03
    atomexp( 1)=  7.35299710D-02
    atomexp( 2)=  7.36388244D-02
    atomexp( 3)=  2.82280090D-01
    atomexp( 4)=  2.82554339D-01
    atomexp( 5)=  2.83384546D-01
    atomexp( 6)=  5.38496102D-01
    atomexp( 7)=  5.39628974D-01
    atomexp( 8)=  3.31439561D+00
    atomexp( 9)=  2.91661929D+01
    atomexp(10)=  3.17440025D+02
case( 57)
    nGTF=10
    atomcoeff( 1)=  2.26218066D-01
    atomcoeff( 2)= -2.16471433D-01
    atomcoeff( 3)=  1.23845142D+01
    atomcoeff( 4)= -7.44879948D+00
    atomcoeff( 5)= -4.96777125D+00
    atomcoeff( 6)= -6.97684770D+00
    atomcoeff( 7)=  8.00687196D+00
    atomcoeff( 8)=  2.37247056D+01
    atomcoeff( 9)=  5.26077990D+02
    atomcoeff(10)=  6.10661373D+03
    atomexp( 1)=  8.04557388D-02
    atomexp( 2)=  8.04803240D-02
    atomexp( 3)=  2.76547865D-01
    atomexp( 4)=  2.77200139D-01
    atomexp( 5)=  2.77312156D-01
    atomexp( 6)=  5.93699434D-01
    atomexp( 7)=  5.95213176D-01
    atomexp( 8)=  3.59453510D+00
    atomexp( 9)=  3.10354656D+01
    atomexp(10)=  3.35263545D+02
case( 58)
    nGTF=10
    atomcoeff( 1)=  2.53797185D-01
    atomcoeff( 2)= -2.87775481D-01
    atomcoeff( 3)=  1.77128233D+00
    atomcoeff( 4)= -3.81208608D+00
    atomcoeff( 5)=  6.72535309D+00
    atomcoeff( 6)= -9.02059634D+00
    atomcoeff( 7)=  5.47881299D+00
    atomcoeff( 8)=  2.58649368D+01
    atomcoeff( 9)=  5.64751075D+02
    atomcoeff(10)=  6.51105505D+03
    atomexp( 1)=  1.03267814D-01
    atomexp( 2)=  1.07925691D-01
    atomexp( 3)=  2.15399417D-01
    atomexp( 4)=  2.46708067D-01
    atomexp( 5)=  3.27030161D-01
    atomexp( 6)=  4.01977002D-01
    atomexp( 7)=  4.87622915D-01
    atomexp( 8)=  3.73321596D+00
    atomexp( 9)=  3.25468885D+01
    atomexp(10)=  3.50747405D+02
case( 59)
    nGTF=10
    atomcoeff( 1)=  2.85397903D-01
    atomcoeff( 2)= -2.84397100D-01
    atomcoeff( 3)=  3.94401090D+00
    atomcoeff( 4)= -3.25001190D+00
    atomcoeff( 5)= -4.35782553D+00
    atomcoeff( 6)=  3.74175765D+00
    atomcoeff( 7)=  1.27193921D+00
    atomcoeff( 8)=  2.77925834D+01
    atomcoeff( 9)=  6.00943730D+02
    atomcoeff(10)=  6.91460823D+03
    atomexp( 1)=  8.77489655D-02
    atomexp( 2)=  8.87869448D-02
    atomexp( 3)=  2.22997531D-01
    atomexp( 4)=  2.29321260D-01
    atomexp( 5)=  2.34348126D-01
    atomexp( 6)=  2.43439575D-01
    atomexp( 7)=  7.33096449D-01
    atomexp( 8)=  3.82954456D+00
    atomexp( 9)=  3.39154048D+01
    atomexp(10)=  3.65162244D+02
case( 60)
    nGTF=10
    atomcoeff( 1)=  2.47217296D-01
    atomcoeff( 2)= -8.37984395D-01
    atomcoeff( 3)=  6.14129704D-01
    atomcoeff( 4)=  2.59638285D+00
    atomcoeff( 5)= -1.44546643D+00
    atomcoeff( 6)=  2.50543745D+00
    atomcoeff( 7)=  5.53210797D+01
    atomcoeff( 8)= -1.78426964D+02
    atomcoeff( 9)=  6.75803107D+02
    atomcoeff(10)=  6.84759217D+03
    atomexp( 1)=  9.97090841D-02
    atomexp( 2)=  1.09136534D-01
    atomexp( 3)=  1.13840723D-01
    atomexp( 4)=  6.81446095D-01
    atomexp( 5)=  6.81660796D-01
    atomexp( 6)=  1.96582067D+00
    atomexp( 7)=  5.31244047D+00
    atomexp( 8)=  1.37775947D+01
    atomexp( 9)=  2.59591335D+01
    atomexp(10)=  3.42108007D+02
case( 61)
    nGTF=10
    atomcoeff( 1)=  2.45618059D-01
    atomcoeff( 2)= -7.67405447D-01
    atomcoeff( 3)=  5.45078108D-01
    atomcoeff( 4)=  1.12066741D+00
    atomcoeff( 5)=  1.95944037D+00
    atomcoeff( 6)= -3.19637724D+01
    atomcoeff( 7)=  8.68390969D+01
    atomcoeff( 8)= -1.75394056D+02
    atomcoeff( 9)=  7.19316605D+02
    atomcoeff(10)=  7.31035513D+03
    atomexp( 1)=  1.00247240D-01
    atomexp( 2)=  1.09352675D-01
    atomexp( 3)=  1.14480400D-01
    atomexp( 4)=  6.88146908D-01
    atomexp( 5)=  1.67657240D+00
    atomexp( 6)=  5.23028140D+00
    atomexp( 7)=  5.23401973D+00
    atomexp( 8)=  1.47292140D+01
    atomexp( 9)=  2.76416140D+01
    atomexp(10)=  3.59297365D+02
case( 62)
    nGTF=10
    atomcoeff( 1)=  2.38673621D-01
    atomcoeff( 2)= -7.54219033D-01
    atomcoeff( 3)=  5.34604238D-01
    atomcoeff( 4)=  3.54200742D+00
    atomcoeff( 5)= -3.13284777D+00
    atomcoeff( 6)=  1.73911274D+00
    atomcoeff( 7)=  4.82983362D+01
    atomcoeff( 8)= -5.62594132D+02
    atomcoeff( 9)=  1.15341063D+03
    atomcoeff(10)=  7.76449576D+03
    atomexp( 1)=  9.37947614D-02
    atomexp( 2)=  1.00552447D-01
    atomexp( 3)=  1.04220745D-01
    atomexp( 4)=  5.63469445D-01
    atomexp( 5)=  5.63594581D-01
    atomexp( 6)=  1.01825635D+00
    atomexp( 7)=  4.85208734D+00
    atomexp( 8)=  2.05328182D+01
    atomexp( 9)=  2.66483849D+01
    atomexp(10)=  3.74447940D+02
case( 63)
    nGTF=10
    atomcoeff( 1)=  8.40547475D-03
    atomcoeff( 2)= -1.07048983D+00
    atomcoeff( 3)= -1.84249072D-01
    atomcoeff( 4)=  1.28754496D+00
    atomcoeff( 5)= -2.61179232D+00
    atomcoeff( 6)=  4.43901555D+00
    atomcoeff( 7)=  4.57155285D+01
    atomcoeff( 8)= -5.21827465D+02
    atomcoeff( 9)=  1.17741964D+03
    atomcoeff(10)=  8.32651302D+03
    atomexp( 1)=  7.94895242D-02
    atomexp( 2)=  2.24815528D-01
    atomexp( 3)=  2.24863645D-01
    atomexp( 4)=  2.24954750D-01
    atomexp( 5)=  8.34442675D-01
    atomexp( 6)=  8.34452510D-01
    atomexp( 7)=  4.63615306D+00
    atomexp( 8)=  2.27787063D+01
    atomexp( 9)=  2.93389106D+01
    atomexp(10)=  3.96158273D+02
case( 64)
    nGTF=10
    atomcoeff( 1)=  3.49132305D-02
    atomcoeff( 2)= -6.50716632D+00
    atomcoeff( 3)=  7.97631861D+00
    atomcoeff( 4)=  3.92088938D+01
    atomcoeff( 5)=  7.01828992D+02
    atomcoeff( 6)=  5.94640580D+03
    atomcoeff( 7)=  4.89017124D+04
    atomcoeff( 8)=  1.14548495D+05
    atomcoeff( 9)=  2.08986833D+05
    atomcoeff(10)= -4.52266180D+03
    atomexp( 1)=  1.34013061D-01
    atomexp( 2)=  6.01903786D-01
    atomexp( 3)=  6.26936000D-01
    atomexp( 4)=  4.28650707D+00
    atomexp( 5)=  3.82373530D+01
    atomexp( 6)=  3.29890914D+02
    atomexp( 7)=  3.94955603D+03
    atomexp( 8)=  1.48849603D+04
    atomexp( 9)=  7.73110863D+04
    atomexp(10)=  3.88355343D+06
case( 65)
    nGTF=10
    atomcoeff( 1)=  1.93765419D-01
    atomcoeff( 2)= -5.72900929D-01
    atomcoeff( 3)=  3.98044099D-01
    atomcoeff( 4)=  2.80346565D+00
    atomcoeff( 5)= -2.49331665D+00
    atomcoeff( 6)=  2.41531989D+00
    atomcoeff( 7)=  5.85383363D+01
    atomcoeff( 8)= -4.90429450D+02
    atomcoeff( 9)=  1.21805718D+03
    atomcoeff(10)=  9.31118250D+03
    atomexp( 1)=  9.34042867D-02
    atomexp( 2)=  1.00053505D-01
    atomexp( 3)=  1.04195234D-01
    atomexp( 4)=  5.46437590D-01
    atomexp( 5)=  5.46506843D-01
    atomexp( 6)=  1.09926229D+00
    atomexp( 7)=  5.29140367D+00
    atomexp( 8)=  2.31351510D+01
    atomexp( 9)=  3.16817487D+01
    atomexp(10)=  4.26915284D+02
case( 66)
    nGTF=10
    atomcoeff( 1)=  2.57340547D-01
    atomcoeff( 2)= -2.52383603D-01
    atomcoeff( 3)=  1.36608955D+00
    atomcoeff( 4)= -2.16692363D+00
    atomcoeff( 5)=  9.41838154D-01
    atomcoeff( 6)=  2.62198200D+00
    atomcoeff( 7)=  6.06226771D+01
    atomcoeff( 8)= -5.54941745D+02
    atomcoeff( 9)=  1.33691274D+03
    atomcoeff(10)=  9.88646685D+03
    atomexp( 1)=  8.78273329D-02
    atomexp( 2)=  8.82745012D-02
    atomexp( 3)=  2.45042934D-01
    atomexp( 4)=  2.61350038D-01
    atomexp( 5)=  3.02808869D-01
    atomexp( 6)=  1.05385122D+00
    atomexp( 7)=  5.34326809D+00
    atomexp( 8)=  2.49957657D+01
    atomexp( 9)=  3.33158982D+01
    atomexp(10)=  4.46044733D+02
case( 67)
    nGTF=10
    atomcoeff( 1)=  2.42960870D-01
    atomcoeff( 2)= -2.38955538D-01
    atomcoeff( 3)=  1.10872374D+00
    atomcoeff( 4)= -1.09210863D+00
    atomcoeff( 5)=  3.48096339D-01
    atomcoeff( 6)=  2.87652535D+00
    atomcoeff( 7)=  6.67434983D+01
    atomcoeff( 8)= -1.32526175D+03
    atomcoeff( 9)=  2.14483867D+03
    atomcoeff(10)=  1.04241523D+04
    atomexp( 1)=  7.60585046D-02
    atomexp( 2)=  7.61421877D-02
    atomexp( 3)=  1.42092206D-01
    atomexp( 4)=  1.42093414D-01
    atomexp( 5)=  5.75812265D-01
    atomexp( 6)=  1.19673530D+00
    atomexp( 7)=  5.62614090D+00
    atomexp( 8)=  2.78423062D+01
    atomexp( 9)=  3.26699968D+01
    atomexp(10)=  4.61460169D+02
case( 68)
    nGTF=10
    atomcoeff( 1)=  1.54338051D-01
    atomcoeff( 2)= -7.80560018D-01
    atomcoeff( 3)=  6.46071283D-01
    atomcoeff( 4)= -2.08064751D+00
    atomcoeff( 5)=  2.41430933D+00
    atomcoeff( 6)=  3.12186782D+00
    atomcoeff( 7)=  7.11017482D+01
    atomcoeff( 8)= -1.17517460D+03
    atomcoeff( 9)=  2.04807426D+03
    atomcoeff(10)=  1.10342332D+04
    atomexp( 1)=  9.55877483D-02
    atomexp( 2)=  1.04081000D-01
    atomexp( 3)=  1.06719702D-01
    atomexp( 4)=  5.72060638D-01
    atomexp( 5)=  5.72064065D-01
    atomexp( 6)=  1.23115742D+00
    atomexp( 7)=  5.78385445D+00
    atomexp( 8)=  2.88366843D+01
    atomexp( 9)=  3.45671006D+01
    atomexp(10)=  4.80534775D+02
case( 69)
    nGTF=10
    atomcoeff( 1)=  1.45008589D-01
    atomcoeff( 2)= -2.48504043D-01
    atomcoeff( 3)=  1.22360200D-01
    atomcoeff( 4)=  2.03961552D-01
    atomcoeff( 5)=  2.87788871D+00
    atomcoeff( 6)=  3.15922086D+01
    atomcoeff( 7)=  2.10221178D+02
    atomcoeff( 8)= -4.59015966D+02
    atomcoeff( 9)=  1.19009962D+03
    atomcoeff(10)=  1.15246395D+04
    atomexp( 1)=  9.30151089D-02
    atomexp( 2)=  9.83306621D-02
    atomexp( 3)=  1.08189635D-01
    atomexp( 4)=  5.13379035D-01
    atomexp( 5)=  1.14980053D+00
    atomexp( 6)=  4.55643290D+00
    atomexp( 7)=  1.12322801D+01
    atomexp( 8)=  1.78661924D+01
    atomexp( 9)=  3.74281741D+01
    atomexp(10)=  4.90666443D+02
case( 70)
    nGTF=10
    atomcoeff( 1)=  1.23048512D-01
    atomcoeff( 2)= -7.49521036D-01
    atomcoeff( 3)=  6.47341536D-01
    atomcoeff( 4)= -2.08988191D+00
    atomcoeff( 5)=  2.46767578D+00
    atomcoeff( 6)=  3.65178817D+00
    atomcoeff( 7)=  8.12161227D+01
    atomcoeff( 8)= -1.04565896D+03
    atomcoeff( 9)=  2.02908885D+03
    atomcoeff(10)=  1.23246169D+04
    atomexp( 1)=  9.77591319D-02
    atomexp( 2)=  1.07990542D-01
    atomexp( 3)=  1.10604294D-01
    atomexp( 4)=  6.02654405D-01
    atomexp( 5)=  6.02665173D-01
    atomexp( 6)=  1.33406239D+00
    atomexp( 7)=  6.14257963D+00
    atomexp( 8)=  3.09613996D+01
    atomexp( 9)=  3.82302033D+01
    atomexp(10)=  5.19485118D+02
case( 71)
    nGTF=10
    atomcoeff( 1)=  1.65702054D-01
    atomcoeff( 2)= -1.96217411D-01
    atomcoeff( 3)=  6.34341947D-01
    atomcoeff( 4)= -5.73119770D-01
    atomcoeff( 5)=  2.18884342D+01
    atomcoeff( 6)= -2.16218829D+01
    atomcoeff( 7)=  3.77923958D+00
    atomcoeff( 8)=  7.55635285D+01
    atomcoeff( 9)=  1.22697049D+03
    atomcoeff(10)=  1.36803272D+04
    atomexp( 1)=  1.01677614D-01
    atomexp( 2)=  1.05476198D-01
    atomexp( 3)=  1.38915266D-01
    atomexp( 4)=  1.39361250D-01
    atomexp( 5)=  6.10336810D-01
    atomexp( 6)=  6.10838911D-01
    atomexp( 7)=  1.33028666D+00
    atomexp( 8)=  6.00878749D+00
    atomexp( 9)=  5.56369443D+01
    atomexp(10)=  5.84712126D+02
case( 72)
    nGTF=10
    atomcoeff( 1)=  7.70835102D-03
    atomcoeff( 2)=  2.03221027D-01
    atomcoeff( 3)= -1.61948866D-01
    atomcoeff( 4)=  1.85895658D+00
    atomcoeff( 5)= -1.20933635D+00
    atomcoeff( 6)=  4.82271766D+00
    atomcoeff( 7)= -2.04529305D+02
    atomcoeff( 8)=  2.85002375D+02
    atomcoeff( 9)=  1.29723415D+03
    atomcoeff(10)=  1.44426984D+04
    atomexp( 1)=  9.02078810D-02
    atomexp( 2)=  2.00480338D-01
    atomexp( 3)=  2.00488569D-01
    atomexp( 4)=  7.40896184D-01
    atomexp( 5)=  7.40916752D-01
    atomexp( 6)=  1.62331787D+00
    atomexp( 7)=  5.11339851D+00
    atomexp( 8)=  5.41711997D+00
    atomexp( 9)=  5.77821673D+01
    atomexp(10)=  6.06939976D+02
case( 73)
    nGTF=10
    atomcoeff( 1)=  1.04184037D-01
    atomcoeff( 2)= -1.36902761D-01
    atomcoeff( 3)=  7.98374679D-02
    atomcoeff( 4)= -1.79171703D+00
    atomcoeff( 5)=  2.12357020D+00
    atomcoeff( 6)=  4.63264386D+00
    atomcoeff( 7)=  1.13908102D+02
    atomcoeff( 8)= -5.63602431D+00
    atomcoeff( 9)= -4.35281741D+00
    atomcoeff(10)=  2.18428710D+03
    atomexp( 1)=  1.13065923D-01
    atomexp( 2)=  1.21547532D-01
    atomexp( 3)=  1.61927732D-01
    atomexp( 4)=  5.63723500D-01
    atomexp( 5)=  5.63844477D-01
    atomexp( 6)=  1.46278049D+00
    atomexp( 7)=  6.91171672D+00
    atomexp( 8)=  6.92106819D+00
    atomexp( 9)=  6.95797210D+00
    atomexp(10)=  7.66962203D+01
case( 74)
    nGTF=10
    atomcoeff( 1)=  4.22929399D-02
    atomcoeff( 2)= -1.04769251D+00
    atomcoeff( 3)=  1.04728900D+00
    atomcoeff( 4)=  2.04300991D-01
    atomcoeff( 5)=  2.93458339D+00
    atomcoeff( 6)=  4.76392747D+01
    atomcoeff( 7)= -1.59649690D+02
    atomcoeff( 8)= -1.85882019D+01
    atomcoeff( 9)=  2.42848201D+02
    atomcoeff(10)=  2.30916118D+03
    atomexp( 1)=  1.11649231D-01
    atomexp( 2)=  1.41200983D-01
    atomexp( 3)=  1.43489110D-01
    atomexp( 4)=  4.51139041D-01
    atomexp( 5)=  1.21804318D+00
    atomexp( 6)=  3.66541456D+00
    atomexp( 7)=  4.83691055D+00
    atomexp( 8)=  4.84593141D+00
    atomexp( 9)=  6.00818158D+00
    atomexp(10)=  7.96559559D+01
case( 75)
    nGTF=10
    atomcoeff( 1)=  4.63953738D-02
    atomcoeff( 2)= -1.27524105D-01
    atomcoeff( 3)=  2.53117669D-01
    atomcoeff( 4)= -1.65910185D+00
    atomcoeff( 5)=  1.63593863D+00
    atomcoeff( 6)=  3.00968628D+01
    atomcoeff( 7)= -4.70137246D+01
    atomcoeff( 8)=  2.27224450D+01
    atomcoeff( 9)=  1.24930550D+02
    atomcoeff(10)=  2.50050820D+03
    atomexp( 1)=  1.13661160D-01
    atomexp( 2)=  1.36568601D-01
    atomexp( 3)=  1.76189875D-01
    atomexp( 4)=  2.48790179D-01
    atomexp( 5)=  2.59636798D-01
    atomexp( 6)=  1.13932556D+00
    atomexp( 7)=  1.21557981D+00
    atomexp( 8)=  1.40188729D+00
    atomexp( 9)=  7.71981723D+00
    atomexp(10)=  8.51336639D+01
case( 76)
    nGTF=10
    atomcoeff( 1)=  4.67624541D-03
    atomcoeff( 2)=  1.38788782D-01
    atomcoeff( 3)=  3.78020332D+00
    atomcoeff( 4)=  1.09515719D+02
    atomcoeff( 5)=  1.40386036D+03
    atomcoeff( 6)=  2.91223795D+03
    atomcoeff( 7)=  9.18664142D+03
    atomcoeff( 8)=  2.01999336D+05
    atomcoeff( 9)=  1.22170014D+04
    atomcoeff(10)=  2.93711078D+03
    atomexp( 1)=  9.00872786D-02
    atomexp( 2)=  2.85202881D-01
    atomexp( 3)=  1.21759222D+00
    atomexp( 4)=  7.16808758D+00
    atomexp( 5)=  6.25147367D+01
    atomexp( 6)=  5.36005142D+02
    atomexp( 7)=  5.36373735D+02
    atomexp( 8)=  9.24733772D+03
    atomexp( 9)=  2.69443966D+04
    atomexp(10)=  3.93089607D+06
case( 77)
    nGTF=10
    atomcoeff( 1)=  4.53890998D-03
    atomcoeff( 2)=  1.55547205D-01
    atomcoeff( 3)=  4.05090844D+00
    atomcoeff( 4)=  1.18905108D+02
    atomcoeff( 5)=  1.48181255D+03
    atomcoeff( 6)=  3.22517399D+03
    atomcoeff( 7)=  9.47334234D+03
    atomcoeff( 8)=  2.09020254D+05
    atomcoeff( 9)=  1.15286882D+04
    atomcoeff(10)=  3.38295326D+03
    atomexp( 1)=  9.43231379D-02
    atomexp( 2)=  2.98179756D-01
    atomexp( 3)=  1.23893077D+00
    atomexp( 4)=  7.53038945D+00
    atomexp( 5)=  6.50623693D+01
    atomexp( 6)=  5.37133395D+02
    atomexp( 7)=  5.61276081D+02
    atomexp( 8)=  9.46935035D+03
    atomexp( 9)=  2.61809295D+04
    atomexp(10)=  4.06519471D+06
case( 78)
    nGTF=10
    atomcoeff( 1)=  2.37326439D-03
    atomcoeff( 2)=  1.76538971D-01
    atomcoeff( 3)=  4.26063766D+00
    atomcoeff( 4)=  1.29173296D+02
    atomcoeff( 5)=  1.56518326D+03
    atomcoeff( 6)=  1.07656271D+04
    atomcoeff( 7)=  2.58743584D+03
    atomcoeff( 8)=  2.16845614D+05
    atomcoeff( 9)=  1.34085962D+04
    atomcoeff(10)=  3.81164237D+03
    atomexp( 1)=  8.77796822D-02
    atomexp( 2)=  3.20643352D-01
    atomexp( 3)=  1.22660793D+00
    atomexp( 4)=  7.91147318D+00
    atomexp( 5)=  6.77607412D+01
    atomexp( 6)=  5.74440615D+02
    atomexp( 7)=  5.78670538D+02
    atomexp( 8)=  9.72732383D+03
    atomexp( 9)=  2.57856777D+04
    atomexp(10)=  4.21363099D+06
case( 79)
    nGTF=10
    atomcoeff( 1)=  6.38276401D-02
    atomcoeff( 2)= -1.98363883D+00
    atomcoeff( 3)=  1.93307418D+00
    atomcoeff( 4)=  8.75193826D-02
    atomcoeff( 5)=  6.02621594D-01
    atomcoeff( 6)=  1.32859018D+00
    atomcoeff( 7)=  5.80775352D+00
    atomcoeff( 8)=  7.75070666D+02
    atomcoeff( 9)= -6.18154712D+02
    atomcoeff(10)=  3.12698406D+03
    atomexp( 1)=  1.19011786D-01
    atomexp( 2)=  1.30799072D-01
    atomexp( 3)=  1.31372792D-01
    atomexp( 4)=  3.12052294D-01
    atomexp( 5)=  6.63852871D-01
    atomexp( 6)=  1.12672670D+00
    atomexp( 7)=  1.91056692D+00
    atomexp( 8)=  1.11405502D+01
    atomexp( 9)=  1.19528351D+01
    atomexp(10)=  9.93572681D+01
case( 80)
    nGTF=10
    atomcoeff( 1)=  2.08740016D-02
    atomcoeff( 2)= -1.80083839D+00
    atomcoeff( 3)=  3.43972241D+00
    atomcoeff( 4)= -1.67906132D+00
    atomcoeff( 5)=  7.59521562D+00
    atomcoeff( 6)= -1.95859497D+01
    atomcoeff( 7)=  1.26069023D+01
    atomcoeff( 8)=  6.76110531D+00
    atomcoeff( 9)=  1.88481985D+02
    atomcoeff(10)=  3.43896566D+03
    atomexp( 1)=  1.15607255D-01
    atomexp( 2)=  1.50059808D-01
    atomexp( 3)=  1.55216318D-01
    atomexp( 4)=  1.61548093D-01
    atomexp( 5)=  3.75481139D-01
    atomexp( 6)=  4.01631757D-01
    atomexp( 7)=  4.22950386D-01
    atomexp( 8)=  1.60579971D+00
    atomexp( 9)=  9.78143503D+00
    atomexp(10)=  1.08400129D+02
case( 81)
    nGTF=10
    atomcoeff( 1)=  2.55772396D-01
    atomcoeff( 2)= -2.53871397D-01
    atomcoeff( 3)=  5.83230186D-02
    atomcoeff( 4)= -7.65926192D+00
    atomcoeff( 5)= -1.89429648D+00
    atomcoeff( 6)=  1.02531998D+01
    atomcoeff( 7)=  8.06682664D+00
    atomcoeff( 8)= -3.07104352D+02
    atomcoeff( 9)=  5.07088985D+02
    atomcoeff(10)=  3.63583838D+03
    atomexp( 1)=  8.67342955D-02
    atomexp( 2)=  8.69670630D-02
    atomexp( 3)=  2.19854278D-01
    atomexp( 4)=  6.16892672D-01
    atomexp( 5)=  6.17874292D-01
    atomexp( 6)=  6.17948666D-01
    atomexp( 7)=  1.78429491D+00
    atomexp( 8)=  8.95824517D+00
    atomexp( 9)=  9.43223286D+00
    atomexp(10)=  1.12878828D+02
case( 82)
    nGTF=10
    atomcoeff( 1)=  7.73193527D-03
    atomcoeff( 2)=  2.09524589D-01
    atomcoeff( 3)=  6.64811248D+00
    atomcoeff( 4)=  1.74891531D+02
    atomcoeff( 5)=  1.14548588D+03
    atomcoeff( 6)=  7.77731044D+02
    atomcoeff( 7)=  1.60778491D+04
    atomcoeff( 8)=  2.31231055D+05
    atomcoeff( 9)=  1.19149997D+04
    atomcoeff(10)=  4.72047422D+03
    atomexp( 1)=  9.77468065D-02
    atomexp( 2)=  3.35318052D-01
    atomexp( 3)=  1.49568544D+00
    atomexp( 4)=  9.65163296D+00
    atomexp( 5)=  7.89057922D+01
    atomexp( 6)=  7.89149075D+01
    atomexp( 7)=  6.56125073D+02
    atomexp( 8)=  1.02882351D+04
    atomexp( 9)=  1.77418916D+04
    atomexp(10)=  5.09852727D+06
case( 83)
    nGTF=10
    atomcoeff( 1)=  7.94756471D-03
    atomcoeff( 2)=  2.19159804D-01
    atomcoeff( 3)=  7.43363849D+00
    atomcoeff( 4)=  1.87613751D+02
    atomcoeff( 5)=  4.36427159D+02
    atomcoeff( 6)=  1.58741159D+03
    atomcoeff( 7)=  1.68518774D+04
    atomcoeff( 8)=  2.37261630D+05
    atomcoeff( 9)=  1.22615245D+04
    atomcoeff(10)=  4.74086829D+03
    atomexp( 1)=  1.02046711D-01
    atomexp( 2)=  3.21282416D-01
    atomexp( 3)=  1.58804406D+00
    atomexp( 4)=  1.01093997D+01
    atomexp( 5)=  8.17327700D+01
    atomexp( 6)=  8.20246693D+01
    atomexp( 7)=  6.78410734D+02
    atomexp( 8)=  1.05076402D+04
    atomexp( 9)=  1.67846152D+04
    atomexp(10)=  5.38703627D+06
case( 84)
    nGTF=10
    atomcoeff( 1)=  7.45782921D-03
    atomcoeff( 2)=  2.50069825D-01
    atomcoeff( 3)=  8.29306281D+00
    atomcoeff( 4)=  2.00718733D+02
    atomcoeff( 5)=  1.81331190D+03
    atomcoeff( 6)=  3.01838134D+02
    atomcoeff( 7)=  1.72388714D+04
    atomcoeff( 8)=  1.74790371D+05
    atomcoeff( 9)=  5.61673686D+05
    atomcoeff(10)=  4.65800582D+03
    atomexp( 1)=  1.02329703D-01
    atomexp( 2)=  3.21936973D-01
    atomexp( 3)=  1.69581706D+00
    atomexp( 4)=  1.05957858D+01
    atomexp( 5)=  8.48948694D+01
    atomexp( 6)=  8.49085690D+01
    atomexp( 7)=  6.92406412D+02
    atomexp( 8)=  9.10806128D+03
    atomexp( 9)=  4.32706585D+04
    atomexp(10)=  5.70247116D+06
case( 85)
    nGTF=10
    atomcoeff( 1)=  6.65220964D-03
    atomcoeff( 2)=  3.01263921D-01
    atomcoeff( 3)=  9.28878198D+00
    atomcoeff( 4)=  2.15612491D+02
    atomcoeff( 5)=  1.94912860D+03
    atomcoeff( 6)=  2.87722954D+02
    atomcoeff( 7)=  1.85190662D+04
    atomcoeff( 8)=  2.49714699D+05
    atomcoeff( 9)=  1.59371802D+04
    atomcoeff(10)=  4.41443985D+03
    atomexp( 1)=  1.03168862D-01
    atomexp( 2)=  3.31071950D-01
    atomexp( 3)=  1.81861242D+00
    atomexp( 4)=  1.11066462D+01
    atomexp( 5)=  8.81233008D+01
    atomexp( 6)=  8.92424398D+01
    atomexp( 7)=  7.25319237D+02
    atomexp( 8)=  1.10039264D+04
    atomexp( 9)=  1.53787313D+04
    atomexp(10)=  6.06329804D+06
case( 86)
    nGTF=10
    atomcoeff( 1)=  5.64869521D-03
    atomcoeff( 2)=  3.70109823D-01
    atomcoeff( 3)=  1.03496739D+01
    atomcoeff( 4)=  2.30476916D+02
    atomcoeff( 5)=  1.88253301D+03
    atomcoeff( 6)=  4.65993635D+02
    atomcoeff( 7)=  1.94542696D+04
    atomcoeff( 8)=  2.59334969D+05
    atomcoeff( 9)=  2.42158552D+04
    atomcoeff(10)=  4.12115443D+03
    atomexp( 1)=  1.03274569D-01
    atomexp( 2)=  3.46741045D-01
    atomexp( 3)=  1.95285456D+00
    atomexp( 4)=  1.16253455D+01
    atomexp( 5)=  9.14784773D+01
    atomexp( 6)=  9.15354887D+01
    atomexp( 7)=  7.50607298D+02
    atomexp( 8)=  1.13904698D+04
    atomexp( 9)=  1.64278616D+04
    atomexp(10)=  6.43617821D+06
case( 87)
    nGTF=10
    atomcoeff( 1)=  3.63119038D-01
    atomcoeff( 2)= -4.38907872D-01
    atomcoeff( 3)=  1.22006480D+00
    atomcoeff( 4)= -1.11360303D+00
    atomcoeff( 5)=  7.03126508D-01
    atomcoeff( 6)=  1.67739867D+01
    atomcoeff( 7)= -8.34958856D+01
    atomcoeff( 8)=  6.33178332D+02
    atomcoeff( 9)= -2.59211558D+02
    atomcoeff(10)=  5.11965381D+03
    atomexp( 1)=  9.64665025D-02
    atomexp( 2)=  1.00743425D-01
    atomexp( 3)=  1.46748549D-01
    atomexp( 4)=  1.48255851D-01
    atomexp( 5)=  4.92946821D-01
    atomexp( 6)=  2.49785242D+00
    atomexp( 7)=  1.05329748D+01
    atomexp( 8)=  1.40923240D+01
    atomexp( 9)=  1.70120813D+01
    atomexp(10)=  1.45306468D+02
case( 88)
    nGTF=10
    atomcoeff( 1)=  2.89668846D-01
    atomcoeff( 2)= -2.81598689D-01
    atomcoeff( 3)=  6.17360075D+00
    atomcoeff( 4)= -6.14963144D+00
    atomcoeff( 5)=  9.63714534D-01
    atomcoeff( 6)=  2.08478336D+01
    atomcoeff( 7)= -9.18955961D+02
    atomcoeff( 8)=  1.29390269D+03
    atomcoeff( 9)= -6.41810852D+01
    atomcoeff(10)=  5.44239124D+03
    atomexp( 1)=  7.03357789D-02
    atomexp( 2)=  7.03525758D-02
    atomexp( 3)=  2.33164241D-01
    atomexp( 4)=  2.33462136D-01
    atomexp( 5)=  5.76832294D-01
    atomexp( 6)=  2.82577904D+00
    atomexp( 7)=  1.13426781D+01
    atomexp( 8)=  1.21668419D+01
    atomexp( 9)=  1.77139456D+01
    atomexp(10)=  1.52569987D+02
case( 89)
    nGTF=10
    atomcoeff( 1)=  2.59662308D-01
    atomcoeff( 2)= -2.48546133D-01
    atomcoeff( 3)=  5.00024952D+00
    atomcoeff( 4)= -4.95651114D+00
    atomcoeff( 5)= -4.97254328D+00
    atomcoeff( 6)=  6.10035211D+00
    atomcoeff( 7)=  2.06630121D+01
    atomcoeff( 8)=  2.01904242D+03
    atomcoeff( 9)= -1.67230328D+03
    atomcoeff(10)=  5.94104071D+03
    atomexp( 1)=  8.01101512D-02
    atomexp( 2)=  8.01215550D-02
    atomexp( 3)=  2.05234224D-01
    atomexp( 4)=  2.05286993D-01
    atomexp( 5)=  6.40727999D-01
    atomexp( 6)=  6.40840204D-01
    atomexp( 7)=  2.92965468D+00
    atomexp( 8)=  1.79711785D+01
    atomexp( 9)=  1.87261760D+01
    atomexp(10)=  1.64426714D+02
case( 90)
    nGTF=10
    atomcoeff( 1)=  2.03767366D-01
    atomcoeff( 2)= -1.91910640D-01
    atomcoeff( 3)=  4.58279886D+00
    atomcoeff( 4)= -4.51661517D+00
    atomcoeff( 5)=  1.30815042D+00
    atomcoeff( 6)=  2.75972979D+01
    atomcoeff( 7)= -1.21441762D+02
    atomcoeff( 8)=  9.92047003D+02
    atomcoeff( 9)= -5.11120864D+02
    atomcoeff(10)=  6.20301871D+03
    atomexp( 1)=  9.44582546D-02
    atomexp( 2)=  9.49924222D-02
    atomexp( 3)=  2.19025676D-01
    atomexp( 4)=  2.19243821D-01
    atomexp( 5)=  6.95786459D-01
    atomexp( 6)=  3.32772132D+00
    atomexp( 7)=  1.03566214D+01
    atomexp( 8)=  1.51880334D+01
    atomexp( 9)=  1.63338927D+01
    atomexp(10)=  1.69404246D+02
case( 91)
    nGTF=10
    atomcoeff( 1)=  2.25394302D-01
    atomcoeff( 2)= -2.14138043D-01
    atomcoeff( 3)=  5.47850044D+00
    atomcoeff( 4)= -5.42439307D+00
    atomcoeff( 5)=  1.51387434D+00
    atomcoeff( 6)=  2.66448209D+01
    atomcoeff( 7)= -1.16759825D+02
    atomcoeff( 8)=  1.02600224D+03
    atomcoeff( 9)= -5.19753873D+02
    atomcoeff(10)=  6.60285958D+03
    atomexp( 1)=  8.91793105D-02
    atomexp( 2)=  8.94415827D-02
    atomexp( 3)=  2.35980492D-01
    atomexp( 4)=  2.36286633D-01
    atomexp( 5)=  7.10338780D-01
    atomexp( 6)=  3.31036662D+00
    atomexp( 7)=  1.11139452D+01
    atomexp( 8)=  1.59994366D+01
    atomexp( 9)=  1.71909326D+01
    atomexp(10)=  1.78049872D+02
case( 92)
    nGTF=10
    atomcoeff( 1)=  2.73838506D-01
    atomcoeff( 2)= -2.69924296D-01
    atomcoeff( 3)=  1.88980412D+00
    atomcoeff( 4)= -7.15867136D+00
    atomcoeff( 5)=  5.40476168D+00
    atomcoeff( 6)=  1.74789829D+00
    atomcoeff( 7)=  2.55007975D+01
    atomcoeff( 8)=  2.84876283D+03
    atomcoeff( 9)= -2.42889217D+03
    atomcoeff(10)=  7.09625993D+03
    atomexp( 1)=  8.44403252D-02
    atomexp( 2)=  8.50828890D-02
    atomexp( 3)=  2.13748661D-01
    atomexp( 4)=  2.31478613D-01
    atomexp( 5)=  2.39449258D-01
    atomexp( 6)=  7.88288022D-01
    atomexp( 7)=  3.35038227D+00
    atomexp( 8)=  2.08851444D+01
    atomexp( 9)=  2.17319569D+01
    atomexp(10)=  1.88647645D+02
case( 93)
    nGTF=10
    atomcoeff( 1)=  2.71678371D-01
    atomcoeff( 2)= -2.69493216D-01
    atomcoeff( 3)=  5.11135293D+00
    atomcoeff( 4)= -3.54532924D+00
    atomcoeff( 5)= -7.12966172D+00
    atomcoeff( 6)=  5.71002455D+00
    atomcoeff( 7)=  1.96100402D+00
    atomcoeff( 8)=  2.63158138D+01
    atomcoeff( 9)=  4.93831906D+02
    atomcoeff(10)=  8.14615047D+03
    atomexp( 1)=  8.81549915D-02
    atomexp( 2)=  8.90478515D-02
    atomexp( 3)=  2.21753690D-01
    atomexp( 4)=  2.26950522D-01
    atomexp( 5)=  2.34962843D-01
    atomexp( 6)=  2.43689965D-01
    atomexp( 7)=  8.21783600D-01
    atomexp( 8)=  3.41914110D+00
    atomexp( 9)=  1.88344150D+01
    atomexp(10)=  2.13851513D+02
case( 94)
    nGTF=10
    atomcoeff( 1)=  2.62929029D-01
    atomcoeff( 2)= -6.84741379D-01
    atomcoeff( 3)=  4.44862955D-01
    atomcoeff( 4)= -6.24605428D+00
    atomcoeff( 5)=  6.54583249D+00
    atomcoeff( 6)=  2.40836625D+00
    atomcoeff( 7)=  3.50407923D+01
    atomcoeff( 8)= -3.27370430D+02
    atomcoeff( 9)=  7.89062069D+02
    atomcoeff(10)=  7.75894641D+03
    atomexp( 1)=  9.44358103D-02
    atomexp( 2)=  1.00414796D-01
    atomexp( 3)=  1.05086686D-01
    atomexp( 4)=  4.53407498D-01
    atomexp( 5)=  4.53433705D-01
    atomexp( 6)=  9.48697319D-01
    atomexp( 7)=  3.84351324D+00
    atomexp( 8)=  1.23643668D+01
    atomexp( 9)=  1.55573399D+01
    atomexp(10)=  2.01348733D+02
case( 95)
    nGTF=10
    atomcoeff( 1)=  2.84044038D-01
    atomcoeff( 2)= -7.16176698D-01
    atomcoeff( 3)=  4.54020557D-01
    atomcoeff( 4)=  1.94950533D-01
    atomcoeff( 5)=  2.19530915D+00
    atomcoeff( 6)=  9.35460338D+00
    atomcoeff( 7)=  1.72517698D+02
    atomcoeff( 8)= -3.60388984D+02
    atomcoeff( 9)=  6.91347035D+02
    atomcoeff(10)=  7.99155526D+03
    atomexp( 1)=  9.48173388D-02
    atomexp( 2)=  1.00318651D-01
    atomexp( 3)=  1.04795033D-01
    atomexp( 4)=  4.18695431D-01
    atomexp( 5)=  8.80605221D-01
    atomexp( 6)=  2.61143477D+00
    atomexp( 7)=  6.69303951D+00
    atomexp( 8)=  9.16868299D+00
    atomexp( 9)=  1.56338347D+01
    atomexp(10)=  2.04662266D+02
case( 96)
    nGTF=10
    atomcoeff( 1)=  2.97367337D-02
    atomcoeff( 2)=  1.66499637D+00
    atomcoeff( 3)=  2.14545587D+01
    atomcoeff( 4)=  4.35915115D+02
    atomcoeff( 5)=  3.79851162D+03
    atomcoeff( 6)=  6.11291910D+03
    atomcoeff( 7)=  3.99938020D+04
    atomcoeff( 8)=  2.68744413D+04
    atomcoeff( 9)=  2.13760392D+04
    atomcoeff(10)= -5.11418176D+03
    atomexp( 1)=  1.23221372D-01
    atomexp( 2)=  7.16057438D-01
    atomexp( 3)=  2.92713914D+00
    atomexp( 4)=  1.75803813D+01
    atomexp( 5)=  1.29845512D+02
    atomexp( 6)=  6.71772592D+02
    atomexp( 7)=  1.56882580D+03
    atomexp( 8)=  7.06142076D+03
    atomexp( 9)=  2.27217344D+06
    atomexp(10)=  1.13610380D+07
case( 97)
    nGTF=10
    atomcoeff( 1)=  2.35519471D-02
    atomcoeff( 2)=  1.79488401D+00
    atomcoeff( 3)=  2.20996906D+01
    atomcoeff( 4)=  4.55966826D+02
    atomcoeff( 5)=  3.88274172D+03
    atomcoeff( 6)=  2.75633481D+04
    atomcoeff( 7)=  6.45583338D+03
    atomcoeff( 8)=  7.13799267D+05
    atomcoeff( 9)=  3.07835700D+04
    atomcoeff(10)= -6.36678018D+03
    atomexp( 1)=  1.19201538D-01
    atomexp( 2)=  7.32353087D-01
    atomexp( 3)=  2.93875513D+00
    atomexp( 4)=  1.81720492D+01
    atomexp( 5)=  1.32344903D+02
    atomexp( 6)=  1.09736724D+03
    atomexp( 7)=  1.10445535D+03
    atomexp( 8)=  2.16175497D+04
    atomexp( 9)=  6.09679600D+04
    atomexp(10)=  1.18830969D+07
case( 98)
    nGTF=10
    atomcoeff( 1)=  2.53128292D-02
    atomcoeff( 2)=  1.96514587D+00
    atomcoeff( 3)=  2.37552517D+01
    atomcoeff( 4)=  4.92999160D+02
    atomcoeff( 5)=  4.30704138D+03
    atomcoeff( 6)=  3.08399364D+03
    atomcoeff( 7)=  4.41355685D+04
    atomcoeff( 8)=  1.80800390D+04
    atomcoeff( 9)=  2.49648751D+04
    atomcoeff(10)= -7.96117952D+03
    atomexp( 1)=  1.24180969D-01
    atomexp( 2)=  7.62216516D-01
    atomexp( 3)=  3.00825177D+00
    atomexp( 4)=  1.89885420D+01
    atomexp( 5)=  1.40980713D+02
    atomexp( 6)=  7.25726083D+02
    atomexp( 7)=  1.45708541D+03
    atomexp( 8)=  6.73461870D+03
    atomexp( 9)=  2.54206072D+06
    atomexp(10)=  1.24449931D+07
case( 99)
    nGTF=10
    atomcoeff( 1)=  2.59293372D-02
    atomcoeff( 2)=  2.09210783D+00
    atomcoeff( 3)=  2.51032683D+01
    atomcoeff( 4)=  5.20561661D+02
    atomcoeff( 5)=  2.91934219D+03
    atomcoeff( 6)=  1.57532002D+03
    atomcoeff( 7)=  4.67793601D+04
    atomcoeff( 8)=  1.90801884D+04
    atomcoeff( 9)=  2.68348513D+04
    atomcoeff(10)= -9.58984445D+03
    atomexp( 1)=  1.26645826D-01
    atomexp( 2)=  7.86542338D-01
    atomexp( 3)=  3.05765319D+00
    atomexp( 4)=  1.96738848D+01
    atomexp( 5)=  1.44910549D+02
    atomexp( 6)=  1.44994886D+02
    atomexp( 7)=  1.35937496D+03
    atomexp( 8)=  6.67660843D+03
    atomexp( 9)=  2.70356087D+06
    atomexp(10)=  1.30087233D+07
case(100)
    nGTF=10
    atomcoeff( 1)=  4.24235102D-01
    atomcoeff( 2)=  4.24235102D-01
    atomcoeff( 3)=  4.24235102D-01
    atomcoeff( 4)=  4.24235102D-01
    atomcoeff( 5)=  4.24235102D-01
    atomcoeff( 6)=  4.24235102D-01
    atomcoeff( 7)=  4.24235102D-01
    atomcoeff( 8)=  4.24235102D-01
    atomcoeff( 9)=  4.24235102D-01
    atomcoeff(10)=  4.24235102D-01
    atomexp( 1)=  1.00000000D-01
    atomexp( 2)=  2.50000000D-01
    atomexp( 3)=  6.25000000D-01
    atomexp( 4)=  1.56250000D+00
    atomexp( 5)=  3.90625000D+00
    atomexp( 6)=  9.76562500D+00
    atomexp( 7)=  2.44140625D+01
    atomexp( 8)=  6.10351562D+01
    atomexp( 9)=  1.52587891D+02
    atomexp(10)=  3.81469727D+02
case(101)
    nGTF=10
    atomcoeff( 1)=  2.78514449D-02
    atomcoeff( 2)=  2.34637927D+00
    atomcoeff( 3)=  2.81553418D+01
    atomcoeff( 4)=  3.02834606D+02
    atomcoeff( 5)=  2.79367571D+02
    atomcoeff( 6)=  4.87951103D+03
    atomcoeff( 7)=  5.10950228D+04
    atomcoeff( 8)=  2.32744568D+04
    atomcoeff( 9)=  3.06193891D+04
    atomcoeff(10)= -1.31016515D+04
    atomexp( 1)=  1.33452212D-01
    atomexp( 2)=  8.36129356D-01
    atomexp( 3)=  3.16419027D+00
    atomexp( 4)=  2.11685071D+01
    atomexp( 5)=  2.11686884D+01
    atomexp( 6)=  1.54128829D+02
    atomexp( 7)=  1.44518017D+03
    atomexp( 8)=  7.21394805D+03
    atomexp( 9)=  3.06061366D+06
    atomexp(10)=  1.41468509D+07
case(102)
    nGTF=10
    atomcoeff( 1)=  3.83810161D-03
    atomcoeff( 2)=  2.05436446D+00
    atomcoeff( 3)= -2.03295013D+00
    atomcoeff( 4)=  3.39724719D-01
    atomcoeff( 5)=  4.26033973D+00
    atomcoeff( 6)=  3.87407712D+01
    atomcoeff( 7)=  4.00331609D+03
    atomcoeff( 8)= -5.38258392D+03
    atomcoeff( 9)=  6.31192423D+03
    atomcoeff(10)=  5.64152889D+04
    atomexp( 1)=  7.73642089D-02
    atomexp( 2)=  1.67117583D-01
    atomexp( 3)=  1.67234597D-01
    atomexp( 4)=  5.27374517D-01
    atomexp( 5)=  1.20076529D+00
    atomexp( 6)=  4.03090547D+00
    atomexp( 7)=  3.59068334D+01
    atomexp( 8)=  4.79132628D+01
    atomexp( 9)=  1.09564575D+02
    atomexp(10)=  1.46827539D+03
case(103)
    nGTF=10
    atomcoeff( 1)=  1.55967897D-01
    atomcoeff( 2)= -4.51334231D-01
    atomcoeff( 3)=  3.27244114D-01
    atomcoeff( 4)=  8.31770720D+00
    atomcoeff( 5)= -8.14583001D+00
    atomcoeff( 6)=  3.24656847D+00
    atomcoeff( 7)=  3.91313332D+00
    atomcoeff( 8)=  4.01884784D+01
    atomcoeff( 9)=  9.58934932D+02
    atomcoeff(10)=  1.97047453D+04
    atomexp( 1)=  1.08488496D-01
    atomexp( 2)=  1.18233485D-01
    atomexp( 3)=  1.25382547D-01
    atomexp( 4)=  4.55123114D-01
    atomexp( 5)=  4.55350668D-01
    atomexp( 6)=  1.08748854D+00
    atomexp( 7)=  2.03787671D+00
    atomexp( 8)=  4.30587923D+00
    atomexp( 9)=  2.82754429D+01
    atomexp(10)=  4.31255717D+02
end select
end subroutine