module eanvrr
use boysfunc
implicit none
    type eanvrrargs
        real*8 :: pRPC2
        real*8 :: pRPC2_2
        real*8 :: rec_p2
        real*8 :: MABpi
        real*8 :: MexppRPC2
        real*8 :: PA(3)
        real*8 :: PC(3)
    endtype
contains
    subroutine eanvrr_0_0(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 1; Optimized integrals: 1
        theta(1) = args%MABpi*boys(args%pRPC2, 0) ! [(0,0,0)|(0,0,0)]^(0) 
    end subroutine
    subroutine eanvrr_1_0(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        ! ================================================
        ! Non-optimized integrals: 5; Optimized integrals: 5
        theta(1) = args%MABpi*boys(args%pRPC2, 1) ! [(0,0,0)|(0,0,0)]^(1) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
    end subroutine
    subroutine eanvrr_1_1(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(1)
        ! ================================================
        ! Non-optimized integrals: 15; Optimized integrals: 15
        theta(1) = args%MABpi*boys(args%pRPC2, 2) ! [(0,0,0)|(0,0,0)]^(2) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
    end subroutine
    subroutine eanvrr_2_0(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(1)
        ! ================================================
        ! Non-optimized integrals: 15; Optimized integrals: 15
        theta(1) = args%MABpi*boys(args%pRPC2, 2) ! [(0,0,0)|(0,0,0)]^(2) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
    end subroutine
    subroutine eanvrr_2_1(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(5)
        ! ================================================
        ! Non-optimized integrals: 35; Optimized integrals: 33
        theta(1) = args%MABpi*boys(args%pRPC2, 3) ! [(0,0,0)|(0,0,0)]^(3) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
    end subroutine
    subroutine eanvrr_2_2(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(12)
        ! ================================================
        ! Non-optimized integrals: 70; Optimized integrals: 63
        theta(1) = args%MABpi*boys(args%pRPC2, 4) ! [(0,0,0)|(0,0,0)]^(4) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+t(11)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+t(12)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
    end subroutine
    subroutine eanvrr_3_0(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(5)
        ! ================================================
        ! Non-optimized integrals: 35; Optimized integrals: 31
        theta(1) = args%MABpi*boys(args%pRPC2, 3) ! [(0,0,0)|(0,0,0)]^(3) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
    end subroutine
    subroutine eanvrr_3_1(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(12)
        ! ================================================
        ! Non-optimized integrals: 70; Optimized integrals: 61
        theta(1) = args%MABpi*boys(args%pRPC2, 4) ! [(0,0,0)|(0,0,0)]^(4) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+t(11)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+t(12)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
    end subroutine
    subroutine eanvrr_3_2(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(22)
        ! ================================================
        ! Non-optimized integrals: 126; Optimized integrals: 107
        theta(1) = args%MABpi*boys(args%pRPC2, 5) ! [(0,0,0)|(0,0,0)]^(5) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+t(11)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+t(12)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+t(18)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+t(19)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+t(20)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+t(20)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
    end subroutine
    subroutine eanvrr_3_3(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(39)
        ! ================================================
        ! Non-optimized integrals: 210; Optimized integrals: 172
        theta(1) = args%MABpi*boys(args%pRPC2, 6) ! [(0,0,0)|(0,0,0)]^(6) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+t(18)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+t(19)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+t(20)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+t(20)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+t(28)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+t(29)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+t(30)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+t(30)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+t(31)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+t(32)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+t(33)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+t(33)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(34) = (theta(153)-theta(97))*args%rec_p2
        theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+t(34)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(35) = (theta(156)-theta(100))*args%rec_p2
        theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+t(35)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(36) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(36)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(37) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(37)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(38) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(38)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(36)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(36)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(39) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(39)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(38)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(38)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
    end subroutine
    subroutine eanvrr_4_0(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(12)
        ! ================================================
        ! Non-optimized integrals: 70; Optimized integrals: 57
        theta(1) = args%MABpi*boys(args%pRPC2, 4) ! [(0,0,0)|(0,0,0)]^(4) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+t(11)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+t(12)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
    end subroutine
    subroutine eanvrr_4_1(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(22)
        ! ================================================
        ! Non-optimized integrals: 126; Optimized integrals: 103
        theta(1) = args%MABpi*boys(args%pRPC2, 5) ! [(0,0,0)|(0,0,0)]^(5) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+t(11)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+t(12)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+t(18)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+t(19)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+t(20)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+t(20)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
    end subroutine
    subroutine eanvrr_4_2(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(39)
        ! ================================================
        ! Non-optimized integrals: 210; Optimized integrals: 168
        theta(1) = args%MABpi*boys(args%pRPC2, 6) ! [(0,0,0)|(0,0,0)]^(6) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+t(18)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+t(19)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+t(20)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+t(20)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+t(28)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+t(29)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+t(30)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+t(30)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+t(31)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+t(32)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+t(33)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+t(33)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(34) = (theta(153)-theta(97))*args%rec_p2
        theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+t(34)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(35) = (theta(156)-theta(100))*args%rec_p2
        theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+t(35)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(36) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(36)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(37) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(37)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(38) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(38)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(36)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(36)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(39) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(39)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(38)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(38)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
    end subroutine
    subroutine eanvrr_4_3(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(68)
        ! ================================================
        ! Non-optimized integrals: 330; Optimized integrals: 258
        theta(1) = args%MABpi*boys(args%pRPC2, 7) ! [(0,0,0)|(0,0,0)]^(7) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/13 ! [(0,0,0)|(0,0,0)]^(6) = ([(0,0,0)|(0,0,0)]^(7)*2x+exp(-x))/13
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(211) = (theta(127)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(1)-([(0,0,0)|(0,0,0)]^(7)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(2)-([(0,0,0)|(0,0,0)]^(7)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(3)-([(0,0,0)|(0,0,0)]^(7)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(5) = [(1,0,0)|(0,0,0)]^(5)*args%PA(1)-([(1,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(1)-([(0,1,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(1)-([(0,0,1)|(0,0,0)]^(6)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(2)-([(0,1,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(2)-([(0,0,1)|(0,0,0)]^(6)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(3)-([(0,0,1)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(1)-([(2,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(4)-([(1,0,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(2)-([(2,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(3)-([(2,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(1)-([(0,2,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(4) = [(0,1,1)|(0,0,0)]^(4)*args%PA(1)-([(0,1,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(1)-([(0,0,2)|(0,0,0)]^(5)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(2)-([(0,2,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(4)-([(0,1,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(3)-([(0,2,0)|(0,0,0)]^(5)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(2)-([(0,0,2)|(0,0,0)]^(5)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(3)-([(0,0,2)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(4)-([(0,0,1)|(0,0,0)]^(5))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(1)-([(3,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(3)-([(2,0,0)|(0,0,0)]^(4))/3/(2p)
        ! theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(2)-([(3,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(3)-([(3,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(3) = [(1,2,0)|(0,0,0)]^(3)*args%PA(1)-([(1,2,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(3) = [(2,0,1)|(0,0,0)]^(3)*args%PA(2)-([(2,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(3) = [(1,0,2)|(0,0,0)]^(3)*args%PA(1)-([(1,0,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(1)-([(0,3,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(3) = [(0,2,1)|(0,0,0)]^(3)*args%PA(1)-([(0,2,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(1)-([(0,1,2)|(0,0,0)]^(4)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(1)-([(0,0,3)|(0,0,0)]^(4)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(2)-([(0,3,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(3)-([(0,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(2)-([(0,1,2)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(2)-([(0,0,3)|(0,0,0)]^(4)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(3)-([(0,0,3)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+(theta(78)-theta(43))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+(theta(80)-theta(45))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(1)-([(4,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(2)-([(4,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(3)-([(4,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(2) = [(3,1,0)|(0,0,0)]^(2)*args%PA(2)-([(3,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(2)-([(3,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(3)-([(3,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(2) = [(1,3,0)|(0,0,0)]^(2)*args%PA(1)-([(1,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(2) = [(2,2,0)|(0,0,0)]^(2)*args%PA(3)-([(2,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(2) = [(2,0,2)|(0,0,0)]^(2)*args%PA(2)-([(2,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(2) = [(1,0,3)|(0,0,0)]^(2)*args%PA(1)-([(1,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(1)-([(0,4,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(1)-([(0,3,1)|(0,0,0)]^(3)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(2) = [(0,2,2)|(0,0,0)]^(2)*args%PA(1)-([(0,2,2)|(0,0,0)]^(3)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(1)-([(0,1,3)|(0,0,0)]^(3)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(1)-([(0,0,4)|(0,0,0)]^(3)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(2)-([(0,4,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(3)-([(0,4,0)|(0,0,0)]^(3)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(3)-([(0,3,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(2)-([(0,1,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(2)-([(0,0,4)|(0,0,0)]^(3)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(3)-([(0,0,4)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+t(28)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+t(29)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+t(30)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+t(30)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+t(31)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+t(32)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(1)-([(5,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(2)-([(5,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(3)-([(5,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+t(33)*1 ! [(4,2,0)|(0,0,0)]^(1) = [(4,1,0)|(0,0,0)]^(1)*args%PA(2)-([(4,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(2)-([(4,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+t(33)*1 ! [(4,0,2)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(3)-([(4,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        t(34) = (theta(153)-theta(97))*args%rec_p2
        theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+t(34)*2 ! [(3,3,0)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(1)-([(2,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(1)-([(1,3,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(1) = [(3,2,0)|(0,0,0)]^(1)*args%PA(3)-([(3,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(1) = [(3,0,2)|(0,0,0)]^(1)*args%PA(2)-([(3,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(35) = (theta(156)-theta(100))*args%rec_p2
        theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+t(35)*2 ! [(3,0,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(1)-([(2,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(1)-([(1,0,3)|(0,0,0)]^(2))/2/(2p)
        t(36) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(36)*1 ! [(2,4,0)|(0,0,0)]^(1) = [(1,4,0)|(0,0,0)]^(1)*args%PA(1)-([(1,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(3)-([(2,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(37) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(37)*1 ! [(2,2,2)|(0,0,0)]^(1) = [(1,2,2)|(0,0,0)]^(1)*args%PA(1)-([(1,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(1)-([(0,2,2)|(0,0,0)]^(2))/1/(2p)
        ! theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(2)-([(2,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(38) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(38)*1 ! [(2,0,4)|(0,0,0)]^(1) = [(1,0,4)|(0,0,0)]^(1)*args%PA(1)-([(1,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(1)-([(0,5,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(1)-([(0,4,1)|(0,0,0)]^(2)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(1) = [(0,3,2)|(0,0,0)]^(1)*args%PA(1)-([(0,3,2)|(0,0,0)]^(2)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(1)-([(0,2,3)|(0,0,0)]^(2)*args%PC(1)
        ! theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(1)-([(0,1,4)|(0,0,0)]^(2)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(1)-([(0,0,5)|(0,0,0)]^(2)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(36)*5 ! [(0,6,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(2)-([(0,5,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(3)-([(0,5,0)|(0,0,0)]^(2)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(36)*1 ! [(0,4,2)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(3)-([(0,4,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        t(39) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(39)*2 ! [(0,3,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(2)-([(0,2,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(1)-([(0,1,3)|(0,0,0)]^(2))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(38)*1 ! [(0,2,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(2)-([(0,1,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(2)-([(0,0,5)|(0,0,0)]^(2)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(38)*5 ! [(0,0,6)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(3)-([(0,0,5)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/5/(2p)
        theta(212) = theta(211)*args%PA(1)-theta(127)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(213) = theta(211)*args%PA(2)-theta(127)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(214) = theta(211)*args%PA(3)-theta(127)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(40) = (theta(211)-theta(127))*args%rec_p2
        theta(215) = theta(212)*args%PA(1)-theta(128)*args%PC(1)+t(40)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(216) = theta(213)*args%PA(1)-theta(129)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(217) = theta(214)*args%PA(1)-theta(130)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(218) = theta(213)*args%PA(2)-theta(129)*args%PC(2)+t(40)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(219) = theta(214)*args%PA(2)-theta(130)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(220) = theta(214)*args%PA(3)-theta(130)*args%PC(3)+t(40)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(41) = (theta(212)-theta(128))*args%rec_p2
        theta(221) = theta(215)*args%PA(1)-theta(131)*args%PC(1)+t(41)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(222) = theta(215)*args%PA(2)-theta(131)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(223) = theta(215)*args%PA(3)-theta(131)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(224) = theta(218)*args%PA(1)-theta(134)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(225) = theta(219)*args%PA(1)-theta(135)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(226) = theta(220)*args%PA(1)-theta(136)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(42) = (theta(213)-theta(129))*args%rec_p2
        theta(227) = theta(218)*args%PA(2)-theta(134)*args%PC(2)+t(42)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(228) = theta(218)*args%PA(3)-theta(134)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(229) = theta(220)*args%PA(2)-theta(136)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(43) = (theta(214)-theta(130))*args%rec_p2
        theta(230) = theta(220)*args%PA(3)-theta(136)*args%PC(3)+t(43)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(44) = (theta(215)-theta(131))*args%rec_p2
        theta(231) = theta(221)*args%PA(1)-theta(137)*args%PC(1)+t(44)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(232) = theta(221)*args%PA(2)-theta(137)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(233) = theta(221)*args%PA(3)-theta(137)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(45) = (theta(218)-theta(134))*args%rec_p2
        theta(234) = theta(224)*args%PA(1)-theta(140)*args%PC(1)+t(45)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(235) = theta(223)*args%PA(2)-theta(139)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(46) = (theta(220)-theta(136))*args%rec_p2
        theta(236) = theta(226)*args%PA(1)-theta(142)*args%PC(1)+t(46)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(237) = theta(227)*args%PA(1)-theta(143)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(238) = theta(228)*args%PA(1)-theta(144)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(239) = theta(229)*args%PA(1)-theta(145)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(240) = theta(230)*args%PA(1)-theta(146)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(241) = theta(227)*args%PA(2)-theta(143)*args%PC(2)+t(45)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(242) = theta(227)*args%PA(3)-theta(143)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(243) = theta(229)*args%PA(2)-theta(145)*args%PC(2)+t(46)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(244) = theta(230)*args%PA(2)-theta(146)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(245) = theta(230)*args%PA(3)-theta(146)*args%PC(3)+t(46)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(47) = (theta(221)-theta(137))*args%rec_p2
        theta(246) = theta(231)*args%PA(1)-theta(147)*args%PC(1)+t(47)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(247) = theta(231)*args%PA(2)-theta(147)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(248) = theta(231)*args%PA(3)-theta(147)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(249) = theta(232)*args%PA(2)-theta(148)*args%PC(2)+t(47)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(250) = theta(233)*args%PA(2)-theta(149)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(251) = theta(233)*args%PA(3)-theta(149)*args%PC(3)+t(47)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(48) = (theta(227)-theta(143))*args%rec_p2
        theta(252) = theta(237)*args%PA(1)-theta(153)*args%PC(1)+t(48)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(253) = theta(234)*args%PA(3)-theta(150)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(254) = theta(236)*args%PA(2)-theta(152)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(49) = (theta(230)-theta(146))*args%rec_p2
        theta(255) = theta(240)*args%PA(1)-theta(156)*args%PC(1)+t(49)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(256) = theta(241)*args%PA(1)-theta(157)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(257) = theta(242)*args%PA(1)-theta(158)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(258) = theta(243)*args%PA(1)-theta(159)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(259) = theta(244)*args%PA(1)-theta(160)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(260) = theta(245)*args%PA(1)-theta(161)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(261) = theta(241)*args%PA(2)-theta(157)*args%PC(2)+t(48)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(262) = theta(241)*args%PA(3)-theta(157)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(263) = theta(242)*args%PA(3)-theta(158)*args%PC(3)+t(48)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(264) = theta(244)*args%PA(2)-theta(160)*args%PC(2)+t(49)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(265) = theta(245)*args%PA(2)-theta(161)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(266) = theta(245)*args%PA(3)-theta(161)*args%PC(3)+t(49)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(50) = (theta(231)-theta(147))*args%rec_p2
        theta(267) = theta(246)*args%PA(1)-theta(162)*args%PC(1)+t(50)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(268) = theta(246)*args%PA(2)-theta(162)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(269) = theta(246)*args%PA(3)-theta(162)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(270) = theta(247)*args%PA(2)-theta(163)*args%PC(2)+t(50)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(271) = theta(248)*args%PA(2)-theta(164)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(272) = theta(248)*args%PA(3)-theta(164)*args%PC(3)+t(50)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(51) = (theta(237)-theta(153))*args%rec_p2
        theta(273) = theta(252)*args%PA(1)-theta(168)*args%PC(1)+t(51)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(274) = theta(249)*args%PA(3)-theta(165)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(275) = theta(251)*args%PA(2)-theta(167)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(52) = (theta(240)-theta(156))*args%rec_p2
        theta(276) = theta(255)*args%PA(1)-theta(171)*args%PC(1)+t(52)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(53) = (theta(241)-theta(157))*args%rec_p2
        theta(277) = theta(256)*args%PA(1)-theta(172)*args%PC(1)+t(53)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(278) = theta(252)*args%PA(3)-theta(168)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(54) = (theta(243)-theta(159))*args%rec_p2
        theta(279) = theta(258)*args%PA(1)-theta(174)*args%PC(1)+t(54)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(280) = theta(255)*args%PA(2)-theta(171)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(55) = (theta(245)-theta(161))*args%rec_p2
        theta(281) = theta(260)*args%PA(1)-theta(176)*args%PC(1)+t(55)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(282) = theta(261)*args%PA(1)-theta(177)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(283) = theta(262)*args%PA(1)-theta(178)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(284) = theta(263)*args%PA(1)-theta(179)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(285) = theta(264)*args%PA(1)-theta(180)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(286) = theta(265)*args%PA(1)-theta(181)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(287) = theta(266)*args%PA(1)-theta(182)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(288) = theta(261)*args%PA(2)-theta(177)*args%PC(2)+t(53)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(289) = theta(261)*args%PA(3)-theta(177)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(290) = theta(262)*args%PA(3)-theta(178)*args%PC(3)+t(53)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(56) = (theta(244)-theta(160))*args%rec_p2
        theta(291) = theta(264)*args%PA(2)-theta(180)*args%PC(2)+t(56)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(292) = theta(265)*args%PA(2)-theta(181)*args%PC(2)+t(55)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(293) = theta(266)*args%PA(2)-theta(182)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(294) = theta(266)*args%PA(3)-theta(182)*args%PC(3)+t(55)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
        t(57) = (theta(246)-theta(162))*args%rec_p2
        theta(295) = theta(267)*args%PA(1)-theta(183)*args%PC(1)+t(57)*6 ! [(7,0,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(1)-([(6,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/6/(2p)
        theta(296) = theta(267)*args%PA(2)-theta(183)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(2)-([(6,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(297) = theta(267)*args%PA(3)-theta(183)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(3)-([(6,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(298) = theta(268)*args%PA(2)-theta(184)*args%PC(2)+t(57)*1 ! [(5,2,0)|(0,0,0)]^(0) = [(5,1,0)|(0,0,0)]^(0)*args%PA(2)-([(5,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(299) = theta(269)*args%PA(2)-theta(185)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(2)-([(5,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(300) = theta(269)*args%PA(3)-theta(185)*args%PC(3)+t(57)*1 ! [(5,0,2)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(3)-([(5,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        t(58) = (theta(247)-theta(163))*args%rec_p2
        theta(301) = theta(270)*args%PA(2)-theta(186)*args%PC(2)+t(58)*2 ! [(4,3,0)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(2)-([(4,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(0)-([(4,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(302) = theta(270)*args%PA(3)-theta(186)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(3)-([(4,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(303) = theta(272)*args%PA(2)-theta(188)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(2)-([(4,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(59) = (theta(248)-theta(164))*args%rec_p2
        theta(304) = theta(272)*args%PA(3)-theta(188)*args%PC(3)+t(59)*2 ! [(4,0,3)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(3)-([(4,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(0)-([(4,0,1)|(0,0,0)]^(1))/2/(2p)
        t(60) = (theta(256)-theta(172))*args%rec_p2
        theta(305) = theta(277)*args%PA(1)-theta(193)*args%PC(1)+t(60)*2 ! [(3,4,0)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(1)-([(2,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(0)-([(1,4,0)|(0,0,0)]^(1))/2/(2p)
        theta(306) = theta(273)*args%PA(3)-theta(189)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(0) = [(3,3,0)|(0,0,0)]^(0)*args%PA(3)-([(3,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(61) = (theta(258)-theta(174))*args%rec_p2
        theta(307) = theta(279)*args%PA(1)-theta(195)*args%PC(1)+t(61)*2 ! [(3,2,2)|(0,0,0)]^(0) = [(2,2,2)|(0,0,0)]^(0)*args%PA(1)-([(2,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(0)-([(1,2,2)|(0,0,0)]^(1))/2/(2p)
        theta(308) = theta(276)*args%PA(2)-theta(192)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(0) = [(3,0,3)|(0,0,0)]^(0)*args%PA(2)-([(3,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(62) = (theta(260)-theta(176))*args%rec_p2
        theta(309) = theta(281)*args%PA(1)-theta(197)*args%PC(1)+t(62)*2 ! [(3,0,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(1)-([(2,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(0)-([(1,0,4)|(0,0,0)]^(1))/2/(2p)
        t(63) = (theta(261)-theta(177))*args%rec_p2
        theta(310) = theta(282)*args%PA(1)-theta(198)*args%PC(1)+t(63)*1 ! [(2,5,0)|(0,0,0)]^(0) = [(1,5,0)|(0,0,0)]^(0)*args%PA(1)-([(1,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        theta(311) = theta(277)*args%PA(3)-theta(193)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(3)-([(2,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(64) = (theta(263)-theta(179))*args%rec_p2
        theta(312) = theta(284)*args%PA(1)-theta(200)*args%PC(1)+t(64)*1 ! [(2,3,2)|(0,0,0)]^(0) = [(1,3,2)|(0,0,0)]^(0)*args%PA(1)-([(1,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(0)-([(0,3,2)|(0,0,0)]^(1))/1/(2p)
        t(65) = (theta(264)-theta(180))*args%rec_p2
        theta(313) = theta(285)*args%PA(1)-theta(201)*args%PC(1)+t(65)*1 ! [(2,2,3)|(0,0,0)]^(0) = [(1,2,3)|(0,0,0)]^(0)*args%PA(1)-([(1,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(0)-([(0,2,3)|(0,0,0)]^(1))/1/(2p)
        theta(314) = theta(281)*args%PA(2)-theta(197)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(2)-([(2,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(66) = (theta(266)-theta(182))*args%rec_p2
        theta(315) = theta(287)*args%PA(1)-theta(203)*args%PC(1)+t(66)*1 ! [(2,0,5)|(0,0,0)]^(0) = [(1,0,5)|(0,0,0)]^(0)*args%PA(1)-([(1,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(316) = theta(288)*args%PA(1)-theta(204)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(1)-([(0,6,0)|(0,0,0)]^(1)*args%PC(1)
        theta(317) = theta(289)*args%PA(1)-theta(205)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(1)-([(0,5,1)|(0,0,0)]^(1)*args%PC(1)
        theta(318) = theta(290)*args%PA(1)-theta(206)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(1)-([(0,4,2)|(0,0,0)]^(1)*args%PC(1)
        theta(319) = theta(291)*args%PA(1)-theta(207)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(0) = [(0,3,3)|(0,0,0)]^(0)*args%PA(1)-([(0,3,3)|(0,0,0)]^(1)*args%PC(1)
        theta(320) = theta(292)*args%PA(1)-theta(208)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(1)-([(0,2,4)|(0,0,0)]^(1)*args%PC(1)
        theta(321) = theta(293)*args%PA(1)-theta(209)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(1)-([(0,1,5)|(0,0,0)]^(1)*args%PC(1)
        theta(322) = theta(294)*args%PA(1)-theta(210)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(1)-([(0,0,6)|(0,0,0)]^(1)*args%PC(1)
        theta(323) = theta(288)*args%PA(2)-theta(204)*args%PC(2)+t(63)*6 ! [(0,7,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(2)-([(0,6,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/6/(2p)
        theta(324) = theta(288)*args%PA(3)-theta(204)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(3)-([(0,6,0)|(0,0,0)]^(1)*args%PC(3)
        theta(325) = theta(289)*args%PA(3)-theta(205)*args%PC(3)+t(63)*1 ! [(0,5,2)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(3)-([(0,5,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        t(67) = (theta(262)-theta(178))*args%rec_p2
        theta(326) = theta(290)*args%PA(3)-theta(206)*args%PC(3)+t(67)*2 ! [(0,4,3)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(3)-([(0,4,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(0)-([(0,4,1)|(0,0,0)]^(1))/2/(2p)
        t(68) = (theta(265)-theta(181))*args%rec_p2
        theta(327) = theta(292)*args%PA(2)-theta(208)*args%PC(2)+t(68)*2 ! [(0,3,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(2)-([(0,2,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(0)-([(0,1,4)|(0,0,0)]^(1))/2/(2p)
        theta(328) = theta(293)*args%PA(2)-theta(209)*args%PC(2)+t(66)*1 ! [(0,2,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(2)-([(0,1,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(329) = theta(294)*args%PA(2)-theta(210)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(2)-([(0,0,6)|(0,0,0)]^(1)*args%PC(2)
        theta(330) = theta(294)*args%PA(3)-theta(210)*args%PC(3)+t(66)*6 ! [(0,0,7)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(3)-([(0,0,6)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/6/(2p)
    end subroutine
    subroutine eanvrr_4_4(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(112)
        ! ================================================
        ! Non-optimized integrals: 495; Optimized integrals: 378
        theta(1) = args%MABpi*boys(args%pRPC2, 8) ! [(0,0,0)|(0,0,0)]^(8) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/15 ! [(0,0,0)|(0,0,0)]^(7) = ([(0,0,0)|(0,0,0)]^(8)*2x+exp(-x))/15
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/13 ! [(0,0,0)|(0,0,0)]^(6) = ([(0,0,0)|(0,0,0)]^(7)*2x+exp(-x))/13
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(211) = (theta(127)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(331) = (theta(211)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(1)-([(0,0,0)|(0,0,0)]^(8)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(2)-([(0,0,0)|(0,0,0)]^(8)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(3)-([(0,0,0)|(0,0,0)]^(8)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(1)-([(0,0,0)|(0,0,0)]^(7)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(2)-([(0,0,0)|(0,0,0)]^(7)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(3)-([(0,0,0)|(0,0,0)]^(7)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(6) = [(1,0,0)|(0,0,0)]^(6)*args%PA(1)-([(1,0,0)|(0,0,0)]^(7)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(1)-([(0,1,0)|(0,0,0)]^(7)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(1)-([(0,0,1)|(0,0,0)]^(7)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(2)-([(0,1,0)|(0,0,0)]^(7)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(2)-([(0,0,1)|(0,0,0)]^(7)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(3)-([(0,0,1)|(0,0,0)]^(7)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(5) = [(1,0,0)|(0,0,0)]^(5)*args%PA(1)-([(1,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(1)-([(0,1,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(1)-([(0,0,1)|(0,0,0)]^(6)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(2)-([(0,1,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(2)-([(0,0,1)|(0,0,0)]^(6)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(3)-([(0,0,1)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(1)-([(2,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(5)-([(1,0,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(2)-([(2,0,0)|(0,0,0)]^(6)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(3)-([(2,0,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(1)-([(0,2,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(5) = [(0,1,1)|(0,0,0)]^(5)*args%PA(1)-([(0,1,1)|(0,0,0)]^(6)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(1)-([(0,0,2)|(0,0,0)]^(6)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(2)-([(0,2,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(5)-([(0,1,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(3)-([(0,2,0)|(0,0,0)]^(6)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(2)-([(0,0,2)|(0,0,0)]^(6)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(3)-([(0,0,2)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(5)-([(0,0,1)|(0,0,0)]^(6))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(1)-([(2,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(4)-([(1,0,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(2)-([(2,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(3)-([(2,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(1)-([(0,2,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(4) = [(0,1,1)|(0,0,0)]^(4)*args%PA(1)-([(0,1,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(1)-([(0,0,2)|(0,0,0)]^(5)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(2)-([(0,2,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(4)-([(0,1,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(3)-([(0,2,0)|(0,0,0)]^(5)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(2)-([(0,0,2)|(0,0,0)]^(5)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(3)-([(0,0,2)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(4)-([(0,0,1)|(0,0,0)]^(5))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(1)-([(3,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(4)-([(2,0,0)|(0,0,0)]^(5))/3/(2p)
        ! theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(2)-([(3,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(3)-([(3,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(4) = [(1,2,0)|(0,0,0)]^(4)*args%PA(1)-([(1,2,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(4) = [(2,0,1)|(0,0,0)]^(4)*args%PA(2)-([(2,0,1)|(0,0,0)]^(5)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(4) = [(1,0,2)|(0,0,0)]^(4)*args%PA(1)-([(1,0,2)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        ! theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(1)-([(0,3,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(4) = [(0,2,1)|(0,0,0)]^(4)*args%PA(1)-([(0,2,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(1)-([(0,1,2)|(0,0,0)]^(5)*args%PC(1)
        ! theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(1)-([(0,0,3)|(0,0,0)]^(5)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(2)-([(0,3,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(3)-([(0,3,0)|(0,0,0)]^(5)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(2)-([(0,1,2)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(2)-([(0,0,3)|(0,0,0)]^(5)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(3)-([(0,0,3)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(1)-([(3,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(3)-([(2,0,0)|(0,0,0)]^(4))/3/(2p)
        ! theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(2)-([(3,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(3)-([(3,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+(theta(78)-theta(43))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(3) = [(1,2,0)|(0,0,0)]^(3)*args%PA(1)-([(1,2,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(3) = [(2,0,1)|(0,0,0)]^(3)*args%PA(2)-([(2,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+(theta(80)-theta(45))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(3) = [(1,0,2)|(0,0,0)]^(3)*args%PA(1)-([(1,0,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(1)-([(0,3,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(3) = [(0,2,1)|(0,0,0)]^(3)*args%PA(1)-([(0,2,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(1)-([(0,1,2)|(0,0,0)]^(4)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(1)-([(0,0,3)|(0,0,0)]^(4)*args%PC(1)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(2)-([(0,3,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(3)-([(0,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(2)-([(0,1,2)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(2)-([(0,0,3)|(0,0,0)]^(4)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(3)-([(0,0,3)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(1)-([(4,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(2)-([(4,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(3)-([(4,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(3) = [(3,1,0)|(0,0,0)]^(3)*args%PA(2)-([(3,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(2)-([(3,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(3)-([(3,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+(theta(87)-theta(52))*args%rec_p2*1 ! [(2,3,0)|(0,0,0)]^(3) = [(1,3,0)|(0,0,0)]^(3)*args%PA(1)-([(1,3,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(3) = [(2,2,0)|(0,0,0)]^(3)*args%PA(3)-([(2,2,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(3) = [(2,0,2)|(0,0,0)]^(3)*args%PA(2)-([(2,0,2)|(0,0,0)]^(4)*args%PC(2)
        ! theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+(theta(90)-theta(55))*args%rec_p2*1 ! [(2,0,3)|(0,0,0)]^(3) = [(1,0,3)|(0,0,0)]^(3)*args%PA(1)-([(1,0,3)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(1)-([(0,4,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(1)-([(0,3,1)|(0,0,0)]^(4)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(3) = [(0,2,2)|(0,0,0)]^(3)*args%PA(1)-([(0,2,2)|(0,0,0)]^(4)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(1)-([(0,1,3)|(0,0,0)]^(4)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(1)-([(0,0,4)|(0,0,0)]^(4)*args%PC(1)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(2)-([(0,4,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(3)-([(0,4,0)|(0,0,0)]^(4)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(3)-([(0,3,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(2)-([(0,1,3)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(2)-([(0,0,4)|(0,0,0)]^(4)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(3)-([(0,0,4)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+(theta(134)-theta(78))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+(theta(136)-theta(80))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(1)-([(4,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(2)-([(4,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(3)-([(4,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(2) = [(3,1,0)|(0,0,0)]^(2)*args%PA(2)-([(3,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(2)-([(3,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(3)-([(3,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+t(31)*1 ! [(2,3,0)|(0,0,0)]^(2) = [(1,3,0)|(0,0,0)]^(2)*args%PA(1)-([(1,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(2) = [(2,2,0)|(0,0,0)]^(2)*args%PA(3)-([(2,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(2) = [(2,0,2)|(0,0,0)]^(2)*args%PA(2)-([(2,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+t(32)*1 ! [(2,0,3)|(0,0,0)]^(2) = [(1,0,3)|(0,0,0)]^(2)*args%PA(1)-([(1,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(1)-([(0,4,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(1)-([(0,3,1)|(0,0,0)]^(3)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(2) = [(0,2,2)|(0,0,0)]^(2)*args%PA(1)-([(0,2,2)|(0,0,0)]^(3)*args%PC(1)
        ! theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(1)-([(0,1,3)|(0,0,0)]^(3)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(1)-([(0,0,4)|(0,0,0)]^(3)*args%PC(1)
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(2)-([(0,4,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(3)-([(0,4,0)|(0,0,0)]^(3)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(3)-([(0,3,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(2)-([(0,1,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(2)-([(0,0,4)|(0,0,0)]^(3)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(3)-([(0,0,4)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(1)-([(5,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(2)-([(5,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(3)-([(5,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+t(33)*1 ! [(4,2,0)|(0,0,0)]^(2) = [(4,1,0)|(0,0,0)]^(2)*args%PA(2)-([(4,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(2)-([(4,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+t(33)*1 ! [(4,0,2)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(3)-([(4,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+(theta(153)-theta(97))*args%rec_p2*2 ! [(3,3,0)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(1)-([(2,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(2)-([(1,3,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(2) = [(3,2,0)|(0,0,0)]^(2)*args%PA(3)-([(3,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(2) = [(3,0,2)|(0,0,0)]^(2)*args%PA(2)-([(3,0,2)|(0,0,0)]^(3)*args%PC(2)
        ! theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+(theta(156)-theta(100))*args%rec_p2*2 ! [(3,0,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(1)-([(2,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(2)-([(1,0,3)|(0,0,0)]^(3))/2/(2p)
        t(34) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(34)*1 ! [(2,4,0)|(0,0,0)]^(2) = [(1,4,0)|(0,0,0)]^(2)*args%PA(1)-([(1,4,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(3)-([(2,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(35) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(35)*1 ! [(2,2,2)|(0,0,0)]^(2) = [(1,2,2)|(0,0,0)]^(2)*args%PA(1)-([(1,2,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(2)-([(0,2,2)|(0,0,0)]^(3))/1/(2p)
        ! theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(2)-([(2,0,3)|(0,0,0)]^(3)*args%PC(2)
        t(36) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(36)*1 ! [(2,0,4)|(0,0,0)]^(2) = [(1,0,4)|(0,0,0)]^(2)*args%PA(1)-([(1,0,4)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(1)-([(0,5,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(1)-([(0,4,1)|(0,0,0)]^(3)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(2) = [(0,3,2)|(0,0,0)]^(2)*args%PA(1)-([(0,3,2)|(0,0,0)]^(3)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(1)-([(0,2,3)|(0,0,0)]^(3)*args%PC(1)
        ! theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(1)-([(0,1,4)|(0,0,0)]^(3)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(1)-([(0,0,5)|(0,0,0)]^(3)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(34)*5 ! [(0,6,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(2)-([(0,5,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(3)-([(0,5,0)|(0,0,0)]^(3)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(34)*1 ! [(0,4,2)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(3)-([(0,4,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        t(37) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(37)*2 ! [(0,3,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(2)-([(0,2,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(2)-([(0,1,3)|(0,0,0)]^(3))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(36)*1 ! [(0,2,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(2)-([(0,1,4)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(2)-([(0,0,5)|(0,0,0)]^(3)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(36)*5 ! [(0,0,6)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(3)-([(0,0,5)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/5/(2p)
        theta(212) = theta(211)*args%PA(1)-theta(127)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(213) = theta(211)*args%PA(2)-theta(127)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(214) = theta(211)*args%PA(3)-theta(127)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(38) = (theta(211)-theta(127))*args%rec_p2
        theta(215) = theta(212)*args%PA(1)-theta(128)*args%PC(1)+t(38)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(216) = theta(213)*args%PA(1)-theta(129)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(217) = theta(214)*args%PA(1)-theta(130)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(218) = theta(213)*args%PA(2)-theta(129)*args%PC(2)+t(38)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(219) = theta(214)*args%PA(2)-theta(130)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(220) = theta(214)*args%PA(3)-theta(130)*args%PC(3)+t(38)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(39) = (theta(212)-theta(128))*args%rec_p2
        theta(221) = theta(215)*args%PA(1)-theta(131)*args%PC(1)+t(39)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(222) = theta(215)*args%PA(2)-theta(131)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(223) = theta(215)*args%PA(3)-theta(131)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(224) = theta(218)*args%PA(1)-theta(134)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(225) = theta(219)*args%PA(1)-theta(135)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(226) = theta(220)*args%PA(1)-theta(136)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(40) = (theta(213)-theta(129))*args%rec_p2
        theta(227) = theta(218)*args%PA(2)-theta(134)*args%PC(2)+t(40)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        theta(228) = theta(218)*args%PA(3)-theta(134)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(229) = theta(220)*args%PA(2)-theta(136)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(41) = (theta(214)-theta(130))*args%rec_p2
        theta(230) = theta(220)*args%PA(3)-theta(136)*args%PC(3)+t(41)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(42) = (theta(215)-theta(131))*args%rec_p2
        theta(231) = theta(221)*args%PA(1)-theta(137)*args%PC(1)+t(42)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(232) = theta(221)*args%PA(2)-theta(137)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(233) = theta(221)*args%PA(3)-theta(137)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(43) = (theta(218)-theta(134))*args%rec_p2
        theta(234) = theta(224)*args%PA(1)-theta(140)*args%PC(1)+t(43)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(235) = theta(223)*args%PA(2)-theta(139)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(44) = (theta(220)-theta(136))*args%rec_p2
        theta(236) = theta(226)*args%PA(1)-theta(142)*args%PC(1)+t(44)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(237) = theta(227)*args%PA(1)-theta(143)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(238) = theta(228)*args%PA(1)-theta(144)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(239) = theta(229)*args%PA(1)-theta(145)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(240) = theta(230)*args%PA(1)-theta(146)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(241) = theta(227)*args%PA(2)-theta(143)*args%PC(2)+t(43)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(242) = theta(227)*args%PA(3)-theta(143)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(243) = theta(229)*args%PA(2)-theta(145)*args%PC(2)+t(44)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(244) = theta(230)*args%PA(2)-theta(146)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(245) = theta(230)*args%PA(3)-theta(146)*args%PC(3)+t(44)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(45) = (theta(221)-theta(137))*args%rec_p2
        theta(246) = theta(231)*args%PA(1)-theta(147)*args%PC(1)+t(45)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(247) = theta(231)*args%PA(2)-theta(147)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(248) = theta(231)*args%PA(3)-theta(147)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(249) = theta(232)*args%PA(2)-theta(148)*args%PC(2)+t(45)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(250) = theta(233)*args%PA(2)-theta(149)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(251) = theta(233)*args%PA(3)-theta(149)*args%PC(3)+t(45)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(46) = (theta(227)-theta(143))*args%rec_p2
        theta(252) = theta(237)*args%PA(1)-theta(153)*args%PC(1)+t(46)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(253) = theta(234)*args%PA(3)-theta(150)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(254) = theta(236)*args%PA(2)-theta(152)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(47) = (theta(230)-theta(146))*args%rec_p2
        theta(255) = theta(240)*args%PA(1)-theta(156)*args%PC(1)+t(47)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(256) = theta(241)*args%PA(1)-theta(157)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(257) = theta(242)*args%PA(1)-theta(158)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(258) = theta(243)*args%PA(1)-theta(159)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(259) = theta(244)*args%PA(1)-theta(160)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(260) = theta(245)*args%PA(1)-theta(161)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(261) = theta(241)*args%PA(2)-theta(157)*args%PC(2)+t(46)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(262) = theta(241)*args%PA(3)-theta(157)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(263) = theta(242)*args%PA(3)-theta(158)*args%PC(3)+t(46)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(264) = theta(244)*args%PA(2)-theta(160)*args%PC(2)+t(47)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(265) = theta(245)*args%PA(2)-theta(161)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(266) = theta(245)*args%PA(3)-theta(161)*args%PC(3)+t(47)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        t(48) = (theta(231)-theta(147))*args%rec_p2
        theta(267) = theta(246)*args%PA(1)-theta(162)*args%PC(1)+t(48)*5 ! [(6,0,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(1)-([(5,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/5/(2p)
        theta(268) = theta(246)*args%PA(2)-theta(162)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(2)-([(5,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(269) = theta(246)*args%PA(3)-theta(162)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(3)-([(5,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(270) = theta(247)*args%PA(2)-theta(163)*args%PC(2)+t(48)*1 ! [(4,2,0)|(0,0,0)]^(1) = [(4,1,0)|(0,0,0)]^(1)*args%PA(2)-([(4,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(271) = theta(248)*args%PA(2)-theta(164)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(2)-([(4,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(272) = theta(248)*args%PA(3)-theta(164)*args%PC(3)+t(48)*1 ! [(4,0,2)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(3)-([(4,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        t(49) = (theta(237)-theta(153))*args%rec_p2
        theta(273) = theta(252)*args%PA(1)-theta(168)*args%PC(1)+t(49)*2 ! [(3,3,0)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(1)-([(2,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(1)-([(1,3,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(274) = theta(249)*args%PA(3)-theta(165)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(1) = [(3,2,0)|(0,0,0)]^(1)*args%PA(3)-([(3,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(275) = theta(251)*args%PA(2)-theta(167)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(1) = [(3,0,2)|(0,0,0)]^(1)*args%PA(2)-([(3,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(50) = (theta(240)-theta(156))*args%rec_p2
        theta(276) = theta(255)*args%PA(1)-theta(171)*args%PC(1)+t(50)*2 ! [(3,0,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(1)-([(2,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(1)-([(1,0,3)|(0,0,0)]^(2))/2/(2p)
        t(51) = (theta(241)-theta(157))*args%rec_p2
        theta(277) = theta(256)*args%PA(1)-theta(172)*args%PC(1)+t(51)*1 ! [(2,4,0)|(0,0,0)]^(1) = [(1,4,0)|(0,0,0)]^(1)*args%PA(1)-([(1,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(278) = theta(252)*args%PA(3)-theta(168)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(3)-([(2,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(52) = (theta(243)-theta(159))*args%rec_p2
        theta(279) = theta(258)*args%PA(1)-theta(174)*args%PC(1)+t(52)*1 ! [(2,2,2)|(0,0,0)]^(1) = [(1,2,2)|(0,0,0)]^(1)*args%PA(1)-([(1,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(1)-([(0,2,2)|(0,0,0)]^(2))/1/(2p)
        ! theta(280) = theta(255)*args%PA(2)-theta(171)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(2)-([(2,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(53) = (theta(245)-theta(161))*args%rec_p2
        theta(281) = theta(260)*args%PA(1)-theta(176)*args%PC(1)+t(53)*1 ! [(2,0,4)|(0,0,0)]^(1) = [(1,0,4)|(0,0,0)]^(1)*args%PA(1)-([(1,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(282) = theta(261)*args%PA(1)-theta(177)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(1)-([(0,5,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(283) = theta(262)*args%PA(1)-theta(178)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(1)-([(0,4,1)|(0,0,0)]^(2)*args%PC(1)
        theta(284) = theta(263)*args%PA(1)-theta(179)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(1) = [(0,3,2)|(0,0,0)]^(1)*args%PA(1)-([(0,3,2)|(0,0,0)]^(2)*args%PC(1)
        theta(285) = theta(264)*args%PA(1)-theta(180)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(1)-([(0,2,3)|(0,0,0)]^(2)*args%PC(1)
        ! theta(286) = theta(265)*args%PA(1)-theta(181)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(1)-([(0,1,4)|(0,0,0)]^(2)*args%PC(1)
        theta(287) = theta(266)*args%PA(1)-theta(182)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(1)-([(0,0,5)|(0,0,0)]^(2)*args%PC(1)
        theta(288) = theta(261)*args%PA(2)-theta(177)*args%PC(2)+t(51)*5 ! [(0,6,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(2)-([(0,5,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/5/(2p)
        theta(289) = theta(261)*args%PA(3)-theta(177)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(3)-([(0,5,0)|(0,0,0)]^(2)*args%PC(3)
        theta(290) = theta(262)*args%PA(3)-theta(178)*args%PC(3)+t(51)*1 ! [(0,4,2)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(3)-([(0,4,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        t(54) = (theta(244)-theta(160))*args%rec_p2
        theta(291) = theta(264)*args%PA(2)-theta(180)*args%PC(2)+t(54)*2 ! [(0,3,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(2)-([(0,2,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(1)-([(0,1,3)|(0,0,0)]^(2))/2/(2p)
        theta(292) = theta(265)*args%PA(2)-theta(181)*args%PC(2)+t(53)*1 ! [(0,2,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(2)-([(0,1,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(293) = theta(266)*args%PA(2)-theta(182)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(2)-([(0,0,5)|(0,0,0)]^(2)*args%PC(2)
        theta(294) = theta(266)*args%PA(3)-theta(182)*args%PC(3)+t(53)*5 ! [(0,0,6)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(3)-([(0,0,5)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/5/(2p)
        t(55) = (theta(246)-theta(162))*args%rec_p2
        theta(295) = theta(267)*args%PA(1)-theta(183)*args%PC(1)+t(55)*6 ! [(7,0,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(1)-([(6,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/6/(2p)
        theta(296) = theta(267)*args%PA(2)-theta(183)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(2)-([(6,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(297) = theta(267)*args%PA(3)-theta(183)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(3)-([(6,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(298) = theta(268)*args%PA(2)-theta(184)*args%PC(2)+t(55)*1 ! [(5,2,0)|(0,0,0)]^(1) = [(5,1,0)|(0,0,0)]^(1)*args%PA(2)-([(5,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(299) = theta(269)*args%PA(2)-theta(185)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(2)-([(5,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(300) = theta(269)*args%PA(3)-theta(185)*args%PC(3)+t(55)*1 ! [(5,0,2)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(3)-([(5,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        t(56) = (theta(247)-theta(163))*args%rec_p2
        theta(301) = theta(270)*args%PA(2)-theta(186)*args%PC(2)+t(56)*2 ! [(4,3,0)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(2)-([(4,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(1)-([(4,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(302) = theta(270)*args%PA(3)-theta(186)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(3)-([(4,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(303) = theta(272)*args%PA(2)-theta(188)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(2)-([(4,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(57) = (theta(248)-theta(164))*args%rec_p2
        theta(304) = theta(272)*args%PA(3)-theta(188)*args%PC(3)+t(57)*2 ! [(4,0,3)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(3)-([(4,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(1)-([(4,0,1)|(0,0,0)]^(2))/2/(2p)
        t(58) = (theta(256)-theta(172))*args%rec_p2
        theta(305) = theta(277)*args%PA(1)-theta(193)*args%PC(1)+t(58)*2 ! [(3,4,0)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(1)-([(2,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(1)-([(1,4,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(306) = theta(273)*args%PA(3)-theta(189)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(1) = [(3,3,0)|(0,0,0)]^(1)*args%PA(3)-([(3,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(59) = (theta(258)-theta(174))*args%rec_p2
        theta(307) = theta(279)*args%PA(1)-theta(195)*args%PC(1)+t(59)*2 ! [(3,2,2)|(0,0,0)]^(1) = [(2,2,2)|(0,0,0)]^(1)*args%PA(1)-([(2,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(1)-([(1,2,2)|(0,0,0)]^(2))/2/(2p)
        ! theta(308) = theta(276)*args%PA(2)-theta(192)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(1) = [(3,0,3)|(0,0,0)]^(1)*args%PA(2)-([(3,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(60) = (theta(260)-theta(176))*args%rec_p2
        theta(309) = theta(281)*args%PA(1)-theta(197)*args%PC(1)+t(60)*2 ! [(3,0,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(1)-([(2,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(1)-([(1,0,4)|(0,0,0)]^(2))/2/(2p)
        t(61) = (theta(261)-theta(177))*args%rec_p2
        theta(310) = theta(282)*args%PA(1)-theta(198)*args%PC(1)+t(61)*1 ! [(2,5,0)|(0,0,0)]^(1) = [(1,5,0)|(0,0,0)]^(1)*args%PA(1)-([(1,5,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(311) = theta(277)*args%PA(3)-theta(193)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(3)-([(2,4,0)|(0,0,0)]^(2)*args%PC(3)
        t(62) = (theta(263)-theta(179))*args%rec_p2
        theta(312) = theta(284)*args%PA(1)-theta(200)*args%PC(1)+t(62)*1 ! [(2,3,2)|(0,0,0)]^(1) = [(1,3,2)|(0,0,0)]^(1)*args%PA(1)-([(1,3,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(1)-([(0,3,2)|(0,0,0)]^(2))/1/(2p)
        t(63) = (theta(264)-theta(180))*args%rec_p2
        theta(313) = theta(285)*args%PA(1)-theta(201)*args%PC(1)+t(63)*1 ! [(2,2,3)|(0,0,0)]^(1) = [(1,2,3)|(0,0,0)]^(1)*args%PA(1)-([(1,2,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(1)-([(0,2,3)|(0,0,0)]^(2))/1/(2p)
        ! theta(314) = theta(281)*args%PA(2)-theta(197)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(2)-([(2,0,4)|(0,0,0)]^(2)*args%PC(2)
        t(64) = (theta(266)-theta(182))*args%rec_p2
        theta(315) = theta(287)*args%PA(1)-theta(203)*args%PC(1)+t(64)*1 ! [(2,0,5)|(0,0,0)]^(1) = [(1,0,5)|(0,0,0)]^(1)*args%PA(1)-([(1,0,5)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(316) = theta(288)*args%PA(1)-theta(204)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(1)-([(0,6,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(317) = theta(289)*args%PA(1)-theta(205)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(1)-([(0,5,1)|(0,0,0)]^(2)*args%PC(1)
        theta(318) = theta(290)*args%PA(1)-theta(206)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(1)-([(0,4,2)|(0,0,0)]^(2)*args%PC(1)
        theta(319) = theta(291)*args%PA(1)-theta(207)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(1) = [(0,3,3)|(0,0,0)]^(1)*args%PA(1)-([(0,3,3)|(0,0,0)]^(2)*args%PC(1)
        theta(320) = theta(292)*args%PA(1)-theta(208)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(1)-([(0,2,4)|(0,0,0)]^(2)*args%PC(1)
        ! theta(321) = theta(293)*args%PA(1)-theta(209)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(1)-([(0,1,5)|(0,0,0)]^(2)*args%PC(1)
        theta(322) = theta(294)*args%PA(1)-theta(210)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(1)-([(0,0,6)|(0,0,0)]^(2)*args%PC(1)
        theta(323) = theta(288)*args%PA(2)-theta(204)*args%PC(2)+t(61)*6 ! [(0,7,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(2)-([(0,6,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/6/(2p)
        theta(324) = theta(288)*args%PA(3)-theta(204)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(3)-([(0,6,0)|(0,0,0)]^(2)*args%PC(3)
        theta(325) = theta(289)*args%PA(3)-theta(205)*args%PC(3)+t(61)*1 ! [(0,5,2)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(3)-([(0,5,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        t(65) = (theta(262)-theta(178))*args%rec_p2
        theta(326) = theta(290)*args%PA(3)-theta(206)*args%PC(3)+t(65)*2 ! [(0,4,3)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(3)-([(0,4,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(1)-([(0,4,1)|(0,0,0)]^(2))/2/(2p)
        t(66) = (theta(265)-theta(181))*args%rec_p2
        theta(327) = theta(292)*args%PA(2)-theta(208)*args%PC(2)+t(66)*2 ! [(0,3,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(2)-([(0,2,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(1)-([(0,1,4)|(0,0,0)]^(2))/2/(2p)
        theta(328) = theta(293)*args%PA(2)-theta(209)*args%PC(2)+t(64)*1 ! [(0,2,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(2)-([(0,1,5)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(329) = theta(294)*args%PA(2)-theta(210)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(2)-([(0,0,6)|(0,0,0)]^(2)*args%PC(2)
        theta(330) = theta(294)*args%PA(3)-theta(210)*args%PC(3)+t(64)*6 ! [(0,0,7)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(3)-([(0,0,6)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/6/(2p)
        theta(332) = theta(331)*args%PA(1)-theta(211)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(333) = theta(331)*args%PA(2)-theta(211)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(334) = theta(331)*args%PA(3)-theta(211)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(67) = (theta(331)-theta(211))*args%rec_p2
        theta(335) = theta(332)*args%PA(1)-theta(212)*args%PC(1)+t(67)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(336) = theta(333)*args%PA(1)-theta(213)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(337) = theta(334)*args%PA(1)-theta(214)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(338) = theta(333)*args%PA(2)-theta(213)*args%PC(2)+t(67)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(339) = theta(334)*args%PA(2)-theta(214)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(340) = theta(334)*args%PA(3)-theta(214)*args%PC(3)+t(67)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(68) = (theta(332)-theta(212))*args%rec_p2
        theta(341) = theta(335)*args%PA(1)-theta(215)*args%PC(1)+t(68)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(342) = theta(335)*args%PA(2)-theta(215)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(343) = theta(335)*args%PA(3)-theta(215)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(344) = theta(338)*args%PA(1)-theta(218)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(345) = theta(339)*args%PA(1)-theta(219)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(346) = theta(340)*args%PA(1)-theta(220)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(69) = (theta(333)-theta(213))*args%rec_p2
        theta(347) = theta(338)*args%PA(2)-theta(218)*args%PC(2)+t(69)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(348) = theta(338)*args%PA(3)-theta(218)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(349) = theta(340)*args%PA(2)-theta(220)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(70) = (theta(334)-theta(214))*args%rec_p2
        theta(350) = theta(340)*args%PA(3)-theta(220)*args%PC(3)+t(70)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(71) = (theta(335)-theta(215))*args%rec_p2
        theta(351) = theta(341)*args%PA(1)-theta(221)*args%PC(1)+t(71)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(352) = theta(341)*args%PA(2)-theta(221)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(353) = theta(341)*args%PA(3)-theta(221)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(72) = (theta(338)-theta(218))*args%rec_p2
        theta(354) = theta(344)*args%PA(1)-theta(224)*args%PC(1)+t(72)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        theta(355) = theta(343)*args%PA(2)-theta(223)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(73) = (theta(340)-theta(220))*args%rec_p2
        theta(356) = theta(346)*args%PA(1)-theta(226)*args%PC(1)+t(73)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(357) = theta(347)*args%PA(1)-theta(227)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        theta(358) = theta(348)*args%PA(1)-theta(228)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        theta(359) = theta(349)*args%PA(1)-theta(229)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(360) = theta(350)*args%PA(1)-theta(230)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(361) = theta(347)*args%PA(2)-theta(227)*args%PC(2)+t(72)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(362) = theta(347)*args%PA(3)-theta(227)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(363) = theta(349)*args%PA(2)-theta(229)*args%PC(2)+t(73)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(364) = theta(350)*args%PA(2)-theta(230)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(365) = theta(350)*args%PA(3)-theta(230)*args%PC(3)+t(73)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(74) = (theta(341)-theta(221))*args%rec_p2
        theta(366) = theta(351)*args%PA(1)-theta(231)*args%PC(1)+t(74)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(367) = theta(351)*args%PA(2)-theta(231)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(368) = theta(351)*args%PA(3)-theta(231)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(369) = theta(352)*args%PA(2)-theta(232)*args%PC(2)+t(74)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(370) = theta(353)*args%PA(2)-theta(233)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(371) = theta(353)*args%PA(3)-theta(233)*args%PC(3)+t(74)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(75) = (theta(347)-theta(227))*args%rec_p2
        theta(372) = theta(357)*args%PA(1)-theta(237)*args%PC(1)+t(75)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(373) = theta(354)*args%PA(3)-theta(234)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(374) = theta(356)*args%PA(2)-theta(236)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(76) = (theta(350)-theta(230))*args%rec_p2
        theta(375) = theta(360)*args%PA(1)-theta(240)*args%PC(1)+t(76)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(376) = theta(361)*args%PA(1)-theta(241)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(377) = theta(362)*args%PA(1)-theta(242)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(378) = theta(363)*args%PA(1)-theta(243)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(379) = theta(364)*args%PA(1)-theta(244)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(380) = theta(365)*args%PA(1)-theta(245)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(381) = theta(361)*args%PA(2)-theta(241)*args%PC(2)+t(75)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(382) = theta(361)*args%PA(3)-theta(241)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(383) = theta(362)*args%PA(3)-theta(242)*args%PC(3)+t(75)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(384) = theta(364)*args%PA(2)-theta(244)*args%PC(2)+t(76)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(385) = theta(365)*args%PA(2)-theta(245)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(386) = theta(365)*args%PA(3)-theta(245)*args%PC(3)+t(76)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(77) = (theta(351)-theta(231))*args%rec_p2
        theta(387) = theta(366)*args%PA(1)-theta(246)*args%PC(1)+t(77)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(388) = theta(366)*args%PA(2)-theta(246)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(389) = theta(366)*args%PA(3)-theta(246)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(390) = theta(367)*args%PA(2)-theta(247)*args%PC(2)+t(77)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(391) = theta(368)*args%PA(2)-theta(248)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(392) = theta(368)*args%PA(3)-theta(248)*args%PC(3)+t(77)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(78) = (theta(357)-theta(237))*args%rec_p2
        theta(393) = theta(372)*args%PA(1)-theta(252)*args%PC(1)+t(78)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(394) = theta(369)*args%PA(3)-theta(249)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(395) = theta(371)*args%PA(2)-theta(251)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(79) = (theta(360)-theta(240))*args%rec_p2
        theta(396) = theta(375)*args%PA(1)-theta(255)*args%PC(1)+t(79)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(80) = (theta(361)-theta(241))*args%rec_p2
        theta(397) = theta(376)*args%PA(1)-theta(256)*args%PC(1)+t(80)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(398) = theta(372)*args%PA(3)-theta(252)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(81) = (theta(363)-theta(243))*args%rec_p2
        theta(399) = theta(378)*args%PA(1)-theta(258)*args%PC(1)+t(81)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(400) = theta(375)*args%PA(2)-theta(255)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(82) = (theta(365)-theta(245))*args%rec_p2
        theta(401) = theta(380)*args%PA(1)-theta(260)*args%PC(1)+t(82)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(402) = theta(381)*args%PA(1)-theta(261)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(403) = theta(382)*args%PA(1)-theta(262)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(404) = theta(383)*args%PA(1)-theta(263)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(405) = theta(384)*args%PA(1)-theta(264)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(406) = theta(385)*args%PA(1)-theta(265)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(407) = theta(386)*args%PA(1)-theta(266)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(408) = theta(381)*args%PA(2)-theta(261)*args%PC(2)+t(80)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(409) = theta(381)*args%PA(3)-theta(261)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(410) = theta(382)*args%PA(3)-theta(262)*args%PC(3)+t(80)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(83) = (theta(364)-theta(244))*args%rec_p2
        theta(411) = theta(384)*args%PA(2)-theta(264)*args%PC(2)+t(83)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(412) = theta(385)*args%PA(2)-theta(265)*args%PC(2)+t(82)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(413) = theta(386)*args%PA(2)-theta(266)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(414) = theta(386)*args%PA(3)-theta(266)*args%PC(3)+t(82)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
        t(84) = (theta(366)-theta(246))*args%rec_p2
        theta(415) = theta(387)*args%PA(1)-theta(267)*args%PC(1)+t(84)*6 ! [(7,0,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(1)-([(6,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/6/(2p)
        theta(416) = theta(387)*args%PA(2)-theta(267)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(2)-([(6,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(417) = theta(387)*args%PA(3)-theta(267)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(3)-([(6,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(418) = theta(388)*args%PA(2)-theta(268)*args%PC(2)+t(84)*1 ! [(5,2,0)|(0,0,0)]^(0) = [(5,1,0)|(0,0,0)]^(0)*args%PA(2)-([(5,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(419) = theta(389)*args%PA(2)-theta(269)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(2)-([(5,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(420) = theta(389)*args%PA(3)-theta(269)*args%PC(3)+t(84)*1 ! [(5,0,2)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(3)-([(5,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        t(85) = (theta(367)-theta(247))*args%rec_p2
        theta(421) = theta(390)*args%PA(2)-theta(270)*args%PC(2)+t(85)*2 ! [(4,3,0)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(2)-([(4,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(0)-([(4,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(422) = theta(390)*args%PA(3)-theta(270)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(3)-([(4,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(423) = theta(392)*args%PA(2)-theta(272)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(2)-([(4,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(86) = (theta(368)-theta(248))*args%rec_p2
        theta(424) = theta(392)*args%PA(3)-theta(272)*args%PC(3)+t(86)*2 ! [(4,0,3)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(3)-([(4,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(0)-([(4,0,1)|(0,0,0)]^(1))/2/(2p)
        t(87) = (theta(376)-theta(256))*args%rec_p2
        theta(425) = theta(397)*args%PA(1)-theta(277)*args%PC(1)+t(87)*2 ! [(3,4,0)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(1)-([(2,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(0)-([(1,4,0)|(0,0,0)]^(1))/2/(2p)
        theta(426) = theta(393)*args%PA(3)-theta(273)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(0) = [(3,3,0)|(0,0,0)]^(0)*args%PA(3)-([(3,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(88) = (theta(378)-theta(258))*args%rec_p2
        theta(427) = theta(399)*args%PA(1)-theta(279)*args%PC(1)+t(88)*2 ! [(3,2,2)|(0,0,0)]^(0) = [(2,2,2)|(0,0,0)]^(0)*args%PA(1)-([(2,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(0)-([(1,2,2)|(0,0,0)]^(1))/2/(2p)
        theta(428) = theta(396)*args%PA(2)-theta(276)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(0) = [(3,0,3)|(0,0,0)]^(0)*args%PA(2)-([(3,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(89) = (theta(380)-theta(260))*args%rec_p2
        theta(429) = theta(401)*args%PA(1)-theta(281)*args%PC(1)+t(89)*2 ! [(3,0,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(1)-([(2,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(0)-([(1,0,4)|(0,0,0)]^(1))/2/(2p)
        t(90) = (theta(381)-theta(261))*args%rec_p2
        theta(430) = theta(402)*args%PA(1)-theta(282)*args%PC(1)+t(90)*1 ! [(2,5,0)|(0,0,0)]^(0) = [(1,5,0)|(0,0,0)]^(0)*args%PA(1)-([(1,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        theta(431) = theta(397)*args%PA(3)-theta(277)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(3)-([(2,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(91) = (theta(383)-theta(263))*args%rec_p2
        theta(432) = theta(404)*args%PA(1)-theta(284)*args%PC(1)+t(91)*1 ! [(2,3,2)|(0,0,0)]^(0) = [(1,3,2)|(0,0,0)]^(0)*args%PA(1)-([(1,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(0)-([(0,3,2)|(0,0,0)]^(1))/1/(2p)
        t(92) = (theta(384)-theta(264))*args%rec_p2
        theta(433) = theta(405)*args%PA(1)-theta(285)*args%PC(1)+t(92)*1 ! [(2,2,3)|(0,0,0)]^(0) = [(1,2,3)|(0,0,0)]^(0)*args%PA(1)-([(1,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(0)-([(0,2,3)|(0,0,0)]^(1))/1/(2p)
        theta(434) = theta(401)*args%PA(2)-theta(281)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(2)-([(2,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(93) = (theta(386)-theta(266))*args%rec_p2
        theta(435) = theta(407)*args%PA(1)-theta(287)*args%PC(1)+t(93)*1 ! [(2,0,5)|(0,0,0)]^(0) = [(1,0,5)|(0,0,0)]^(0)*args%PA(1)-([(1,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(436) = theta(408)*args%PA(1)-theta(288)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(1)-([(0,6,0)|(0,0,0)]^(1)*args%PC(1)
        theta(437) = theta(409)*args%PA(1)-theta(289)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(1)-([(0,5,1)|(0,0,0)]^(1)*args%PC(1)
        theta(438) = theta(410)*args%PA(1)-theta(290)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(1)-([(0,4,2)|(0,0,0)]^(1)*args%PC(1)
        theta(439) = theta(411)*args%PA(1)-theta(291)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(0) = [(0,3,3)|(0,0,0)]^(0)*args%PA(1)-([(0,3,3)|(0,0,0)]^(1)*args%PC(1)
        theta(440) = theta(412)*args%PA(1)-theta(292)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(1)-([(0,2,4)|(0,0,0)]^(1)*args%PC(1)
        theta(441) = theta(413)*args%PA(1)-theta(293)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(1)-([(0,1,5)|(0,0,0)]^(1)*args%PC(1)
        theta(442) = theta(414)*args%PA(1)-theta(294)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(1)-([(0,0,6)|(0,0,0)]^(1)*args%PC(1)
        theta(443) = theta(408)*args%PA(2)-theta(288)*args%PC(2)+t(90)*6 ! [(0,7,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(2)-([(0,6,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/6/(2p)
        theta(444) = theta(408)*args%PA(3)-theta(288)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(3)-([(0,6,0)|(0,0,0)]^(1)*args%PC(3)
        theta(445) = theta(409)*args%PA(3)-theta(289)*args%PC(3)+t(90)*1 ! [(0,5,2)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(3)-([(0,5,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        t(94) = (theta(382)-theta(262))*args%rec_p2
        theta(446) = theta(410)*args%PA(3)-theta(290)*args%PC(3)+t(94)*2 ! [(0,4,3)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(3)-([(0,4,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(0)-([(0,4,1)|(0,0,0)]^(1))/2/(2p)
        t(95) = (theta(385)-theta(265))*args%rec_p2
        theta(447) = theta(412)*args%PA(2)-theta(292)*args%PC(2)+t(95)*2 ! [(0,3,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(2)-([(0,2,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(0)-([(0,1,4)|(0,0,0)]^(1))/2/(2p)
        theta(448) = theta(413)*args%PA(2)-theta(293)*args%PC(2)+t(93)*1 ! [(0,2,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(2)-([(0,1,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(449) = theta(414)*args%PA(2)-theta(294)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(2)-([(0,0,6)|(0,0,0)]^(1)*args%PC(2)
        theta(450) = theta(414)*args%PA(3)-theta(294)*args%PC(3)+t(93)*6 ! [(0,0,7)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(3)-([(0,0,6)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/6/(2p)
        t(96) = (theta(387)-theta(267))*args%rec_p2
        theta(451) = theta(415)*args%PA(1)-theta(295)*args%PC(1)+t(96)*7 ! [(8,0,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(1)-([(7,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/7/(2p)
        theta(452) = theta(415)*args%PA(2)-theta(295)*args%PC(2) ! [(7,1,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(2)-([(7,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(453) = theta(415)*args%PA(3)-theta(295)*args%PC(3) ! [(7,0,1)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(3)-([(7,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(454) = theta(416)*args%PA(2)-theta(296)*args%PC(2)+t(96)*1 ! [(6,2,0)|(0,0,0)]^(0) = [(6,1,0)|(0,0,0)]^(0)*args%PA(2)-([(6,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(455) = theta(417)*args%PA(2)-theta(297)*args%PC(2) ! [(6,1,1)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(2)-([(6,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(456) = theta(417)*args%PA(3)-theta(297)*args%PC(3)+t(96)*1 ! [(6,0,2)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(3)-([(6,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        t(97) = (theta(388)-theta(268))*args%rec_p2
        theta(457) = theta(418)*args%PA(2)-theta(298)*args%PC(2)+t(97)*2 ! [(5,3,0)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(2)-([(5,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,1,0)|(0,0,0)]^(0)-([(5,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(458) = theta(418)*args%PA(3)-theta(298)*args%PC(3) ! [(5,2,1)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(3)-([(5,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(459) = theta(420)*args%PA(2)-theta(300)*args%PC(2) ! [(5,1,2)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(2)-([(5,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(98) = (theta(389)-theta(269))*args%rec_p2
        theta(460) = theta(420)*args%PA(3)-theta(300)*args%PC(3)+t(98)*2 ! [(5,0,3)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(3)-([(5,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,1)|(0,0,0)]^(0)-([(5,0,1)|(0,0,0)]^(1))/2/(2p)
        t(99) = (theta(397)-theta(277))*args%rec_p2
        theta(461) = theta(425)*args%PA(1)-theta(305)*args%PC(1)+t(99)*3 ! [(4,4,0)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(1)-([(3,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,4,0)|(0,0,0)]^(0)-([(2,4,0)|(0,0,0)]^(1))/3/(2p)
        theta(462) = theta(421)*args%PA(3)-theta(301)*args%PC(3) ! [(4,3,1)|(0,0,0)]^(0) = [(4,3,0)|(0,0,0)]^(0)*args%PA(3)-([(4,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(100) = (theta(399)-theta(279))*args%rec_p2
        theta(463) = theta(427)*args%PA(1)-theta(307)*args%PC(1)+t(100)*3 ! [(4,2,2)|(0,0,0)]^(0) = [(3,2,2)|(0,0,0)]^(0)*args%PA(1)-([(3,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(2,2,2)|(0,0,0)]^(0)-([(2,2,2)|(0,0,0)]^(1))/3/(2p)
        theta(464) = theta(424)*args%PA(2)-theta(304)*args%PC(2) ! [(4,1,3)|(0,0,0)]^(0) = [(4,0,3)|(0,0,0)]^(0)*args%PA(2)-([(4,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(101) = (theta(401)-theta(281))*args%rec_p2
        theta(465) = theta(429)*args%PA(1)-theta(309)*args%PC(1)+t(101)*3 ! [(4,0,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(1)-([(3,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,4)|(0,0,0)]^(0)-([(2,0,4)|(0,0,0)]^(1))/3/(2p)
        t(102) = (theta(402)-theta(282))*args%rec_p2
        theta(466) = theta(430)*args%PA(1)-theta(310)*args%PC(1)+t(102)*2 ! [(3,5,0)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(1)-([(2,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,5,0)|(0,0,0)]^(0)-([(1,5,0)|(0,0,0)]^(1))/2/(2p)
        theta(467) = theta(425)*args%PA(3)-theta(305)*args%PC(3) ! [(3,4,1)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(3)-([(3,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(103) = (theta(404)-theta(284))*args%rec_p2
        theta(468) = theta(432)*args%PA(1)-theta(312)*args%PC(1)+t(103)*2 ! [(3,3,2)|(0,0,0)]^(0) = [(2,3,2)|(0,0,0)]^(0)*args%PA(1)-([(2,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,2)|(0,0,0)]^(0)-([(1,3,2)|(0,0,0)]^(1))/2/(2p)
        t(104) = (theta(405)-theta(285))*args%rec_p2
        theta(469) = theta(433)*args%PA(1)-theta(313)*args%PC(1)+t(104)*2 ! [(3,2,3)|(0,0,0)]^(0) = [(2,2,3)|(0,0,0)]^(0)*args%PA(1)-([(2,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,3)|(0,0,0)]^(0)-([(1,2,3)|(0,0,0)]^(1))/2/(2p)
        theta(470) = theta(429)*args%PA(2)-theta(309)*args%PC(2) ! [(3,1,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(2)-([(3,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(105) = (theta(407)-theta(287))*args%rec_p2
        theta(471) = theta(435)*args%PA(1)-theta(315)*args%PC(1)+t(105)*2 ! [(3,0,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(1)-([(2,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,5)|(0,0,0)]^(0)-([(1,0,5)|(0,0,0)]^(1))/2/(2p)
        t(106) = (theta(408)-theta(288))*args%rec_p2
        theta(472) = theta(436)*args%PA(1)-theta(316)*args%PC(1)+t(106)*1 ! [(2,6,0)|(0,0,0)]^(0) = [(1,6,0)|(0,0,0)]^(0)*args%PA(1)-([(1,6,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        theta(473) = theta(430)*args%PA(3)-theta(310)*args%PC(3) ! [(2,5,1)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(3)-([(2,5,0)|(0,0,0)]^(1)*args%PC(3)
        t(107) = (theta(410)-theta(290))*args%rec_p2
        theta(474) = theta(438)*args%PA(1)-theta(318)*args%PC(1)+t(107)*1 ! [(2,4,2)|(0,0,0)]^(0) = [(1,4,2)|(0,0,0)]^(0)*args%PA(1)-([(1,4,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,2)|(0,0,0)]^(0)-([(0,4,2)|(0,0,0)]^(1))/1/(2p)
        t(108) = (theta(411)-theta(291))*args%rec_p2
        theta(475) = theta(439)*args%PA(1)-theta(319)*args%PC(1)+t(108)*1 ! [(2,3,3)|(0,0,0)]^(0) = [(1,3,3)|(0,0,0)]^(0)*args%PA(1)-([(1,3,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,3)|(0,0,0)]^(0)-([(0,3,3)|(0,0,0)]^(1))/1/(2p)
        t(109) = (theta(412)-theta(292))*args%rec_p2
        theta(476) = theta(440)*args%PA(1)-theta(320)*args%PC(1)+t(109)*1 ! [(2,2,4)|(0,0,0)]^(0) = [(1,2,4)|(0,0,0)]^(0)*args%PA(1)-([(1,2,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/1/(2p)
        theta(477) = theta(435)*args%PA(2)-theta(315)*args%PC(2) ! [(2,1,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(2)-([(2,0,5)|(0,0,0)]^(1)*args%PC(2)
        t(110) = (theta(414)-theta(294))*args%rec_p2
        theta(478) = theta(442)*args%PA(1)-theta(322)*args%PC(1)+t(110)*1 ! [(2,0,6)|(0,0,0)]^(0) = [(1,0,6)|(0,0,0)]^(0)*args%PA(1)-([(1,0,6)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(479) = theta(443)*args%PA(1)-theta(323)*args%PC(1) ! [(1,7,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(1)-([(0,7,0)|(0,0,0)]^(1)*args%PC(1)
        theta(480) = theta(444)*args%PA(1)-theta(324)*args%PC(1) ! [(1,6,1)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(1)-([(0,6,1)|(0,0,0)]^(1)*args%PC(1)
        theta(481) = theta(445)*args%PA(1)-theta(325)*args%PC(1) ! [(1,5,2)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(1)-([(0,5,2)|(0,0,0)]^(1)*args%PC(1)
        theta(482) = theta(446)*args%PA(1)-theta(326)*args%PC(1) ! [(1,4,3)|(0,0,0)]^(0) = [(0,4,3)|(0,0,0)]^(0)*args%PA(1)-([(0,4,3)|(0,0,0)]^(1)*args%PC(1)
        theta(483) = theta(447)*args%PA(1)-theta(327)*args%PC(1) ! [(1,3,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(1)-([(0,3,4)|(0,0,0)]^(1)*args%PC(1)
        theta(484) = theta(448)*args%PA(1)-theta(328)*args%PC(1) ! [(1,2,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(1)-([(0,2,5)|(0,0,0)]^(1)*args%PC(1)
        theta(485) = theta(449)*args%PA(1)-theta(329)*args%PC(1) ! [(1,1,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(1)-([(0,1,6)|(0,0,0)]^(1)*args%PC(1)
        theta(486) = theta(450)*args%PA(1)-theta(330)*args%PC(1) ! [(1,0,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(1)-([(0,0,7)|(0,0,0)]^(1)*args%PC(1)
        theta(487) = theta(443)*args%PA(2)-theta(323)*args%PC(2)+t(106)*7 ! [(0,8,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(2)-([(0,7,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/7/(2p)
        theta(488) = theta(443)*args%PA(3)-theta(323)*args%PC(3) ! [(0,7,1)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(3)-([(0,7,0)|(0,0,0)]^(1)*args%PC(3)
        theta(489) = theta(444)*args%PA(3)-theta(324)*args%PC(3)+t(106)*1 ! [(0,6,2)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(3)-([(0,6,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        t(111) = (theta(409)-theta(289))*args%rec_p2
        theta(490) = theta(445)*args%PA(3)-theta(325)*args%PC(3)+t(111)*2 ! [(0,5,3)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(3)-([(0,5,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,1)|(0,0,0)]^(0)-([(0,5,1)|(0,0,0)]^(1))/2/(2p)
        theta(491) = theta(447)*args%PA(2)-theta(327)*args%PC(2)+t(109)*3 ! [(0,4,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(2)-([(0,3,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/3/(2p)
        t(112) = (theta(413)-theta(293))*args%rec_p2
        theta(492) = theta(448)*args%PA(2)-theta(328)*args%PC(2)+t(112)*2 ! [(0,3,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(2)-([(0,2,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,5)|(0,0,0)]^(0)-([(0,1,5)|(0,0,0)]^(1))/2/(2p)
        theta(493) = theta(449)*args%PA(2)-theta(329)*args%PC(2)+t(110)*1 ! [(0,2,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(2)-([(0,1,6)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(494) = theta(450)*args%PA(2)-theta(330)*args%PC(2) ! [(0,1,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(2)-([(0,0,7)|(0,0,0)]^(1)*args%PC(2)
        theta(495) = theta(450)*args%PA(3)-theta(330)*args%PC(3)+t(110)*7 ! [(0,0,8)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(3)-([(0,0,7)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/7/(2p)
    end subroutine
    subroutine eanvrr_5_0(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(22)
        ! ================================================
        ! Non-optimized integrals: 126; Optimized integrals: 96
        theta(1) = args%MABpi*boys(args%pRPC2, 5) ! [(0,0,0)|(0,0,0)]^(5) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+t(11)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+t(12)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+t(18)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+t(19)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+t(20)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+t(20)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
    end subroutine
    subroutine eanvrr_5_1(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(39)
        ! ================================================
        ! Non-optimized integrals: 210; Optimized integrals: 161
        theta(1) = args%MABpi*boys(args%pRPC2, 6) ! [(0,0,0)|(0,0,0)]^(6) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+t(18)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+t(19)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+t(20)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+t(20)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        ! theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+t(28)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+t(29)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        ! theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+t(30)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+t(30)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+t(31)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+t(32)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+t(33)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+t(33)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(34) = (theta(153)-theta(97))*args%rec_p2
        theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+t(34)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(35) = (theta(156)-theta(100))*args%rec_p2
        theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+t(35)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(36) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(36)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(37) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(37)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(38) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(38)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(36)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(36)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(39) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(39)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(38)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(38)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
    end subroutine
    subroutine eanvrr_5_2(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(68)
        ! ================================================
        ! Non-optimized integrals: 330; Optimized integrals: 251
        theta(1) = args%MABpi*boys(args%pRPC2, 7) ! [(0,0,0)|(0,0,0)]^(7) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/13 ! [(0,0,0)|(0,0,0)]^(6) = ([(0,0,0)|(0,0,0)]^(7)*2x+exp(-x))/13
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(211) = (theta(127)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(1)-([(0,0,0)|(0,0,0)]^(7)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(2)-([(0,0,0)|(0,0,0)]^(7)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(3)-([(0,0,0)|(0,0,0)]^(7)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(5) = [(1,0,0)|(0,0,0)]^(5)*args%PA(1)-([(1,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(1)-([(0,1,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(1)-([(0,0,1)|(0,0,0)]^(6)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(2)-([(0,1,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(2)-([(0,0,1)|(0,0,0)]^(6)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(3)-([(0,0,1)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(1)-([(2,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(4)-([(1,0,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(2)-([(2,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(3)-([(2,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(1)-([(0,2,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(4) = [(0,1,1)|(0,0,0)]^(4)*args%PA(1)-([(0,1,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(1)-([(0,0,2)|(0,0,0)]^(5)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(2)-([(0,2,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(4)-([(0,1,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(3)-([(0,2,0)|(0,0,0)]^(5)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(2)-([(0,0,2)|(0,0,0)]^(5)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(3)-([(0,0,2)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(4)-([(0,0,1)|(0,0,0)]^(5))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(1)-([(3,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(3)-([(2,0,0)|(0,0,0)]^(4))/3/(2p)
        ! theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(2)-([(3,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(3)-([(3,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(3) = [(1,2,0)|(0,0,0)]^(3)*args%PA(1)-([(1,2,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(3) = [(2,0,1)|(0,0,0)]^(3)*args%PA(2)-([(2,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(3) = [(1,0,2)|(0,0,0)]^(3)*args%PA(1)-([(1,0,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(1)-([(0,3,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(3) = [(0,2,1)|(0,0,0)]^(3)*args%PA(1)-([(0,2,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(1)-([(0,1,2)|(0,0,0)]^(4)*args%PC(1)
        theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(1)-([(0,0,3)|(0,0,0)]^(4)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(2)-([(0,3,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(3)-([(0,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(2)-([(0,1,2)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(2)-([(0,0,3)|(0,0,0)]^(4)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(3)-([(0,0,3)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+(theta(78)-theta(43))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+(theta(80)-theta(45))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(1)-([(4,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(2)-([(4,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(3)-([(4,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(2) = [(3,1,0)|(0,0,0)]^(2)*args%PA(2)-([(3,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(2)-([(3,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(3)-([(3,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+t(21)*1 ! [(2,3,0)|(0,0,0)]^(2) = [(1,3,0)|(0,0,0)]^(2)*args%PA(1)-([(1,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(2) = [(2,2,0)|(0,0,0)]^(2)*args%PA(3)-([(2,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(2) = [(2,0,2)|(0,0,0)]^(2)*args%PA(2)-([(2,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+t(22)*1 ! [(2,0,3)|(0,0,0)]^(2) = [(1,0,3)|(0,0,0)]^(2)*args%PA(1)-([(1,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(1)-([(0,4,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(1)-([(0,3,1)|(0,0,0)]^(3)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(2) = [(0,2,2)|(0,0,0)]^(2)*args%PA(1)-([(0,2,2)|(0,0,0)]^(3)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(1)-([(0,1,3)|(0,0,0)]^(3)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(1)-([(0,0,4)|(0,0,0)]^(3)*args%PC(1)
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(2)-([(0,4,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(3)-([(0,4,0)|(0,0,0)]^(3)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(3)-([(0,3,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(2)-([(0,1,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(2)-([(0,0,4)|(0,0,0)]^(3)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(3)-([(0,0,4)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        ! theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+t(28)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+t(29)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+t(30)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+t(30)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+t(31)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+t(32)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(1)-([(5,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(2)-([(5,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(3)-([(5,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+t(33)*1 ! [(4,2,0)|(0,0,0)]^(1) = [(4,1,0)|(0,0,0)]^(1)*args%PA(2)-([(4,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(2)-([(4,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+t(33)*1 ! [(4,0,2)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(3)-([(4,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        t(34) = (theta(153)-theta(97))*args%rec_p2
        theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+t(34)*2 ! [(3,3,0)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(1)-([(2,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(1)-([(1,3,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(1) = [(3,2,0)|(0,0,0)]^(1)*args%PA(3)-([(3,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(1) = [(3,0,2)|(0,0,0)]^(1)*args%PA(2)-([(3,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(35) = (theta(156)-theta(100))*args%rec_p2
        theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+t(35)*2 ! [(3,0,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(1)-([(2,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(1)-([(1,0,3)|(0,0,0)]^(2))/2/(2p)
        t(36) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(36)*1 ! [(2,4,0)|(0,0,0)]^(1) = [(1,4,0)|(0,0,0)]^(1)*args%PA(1)-([(1,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(3)-([(2,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(37) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(37)*1 ! [(2,2,2)|(0,0,0)]^(1) = [(1,2,2)|(0,0,0)]^(1)*args%PA(1)-([(1,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(1)-([(0,2,2)|(0,0,0)]^(2))/1/(2p)
        ! theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(2)-([(2,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(38) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(38)*1 ! [(2,0,4)|(0,0,0)]^(1) = [(1,0,4)|(0,0,0)]^(1)*args%PA(1)-([(1,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(1)-([(0,5,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(1)-([(0,4,1)|(0,0,0)]^(2)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(1) = [(0,3,2)|(0,0,0)]^(1)*args%PA(1)-([(0,3,2)|(0,0,0)]^(2)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(1)-([(0,2,3)|(0,0,0)]^(2)*args%PC(1)
        ! theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(1)-([(0,1,4)|(0,0,0)]^(2)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(1)-([(0,0,5)|(0,0,0)]^(2)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(36)*5 ! [(0,6,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(2)-([(0,5,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(3)-([(0,5,0)|(0,0,0)]^(2)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(36)*1 ! [(0,4,2)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(3)-([(0,4,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        t(39) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(39)*2 ! [(0,3,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(2)-([(0,2,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(1)-([(0,1,3)|(0,0,0)]^(2))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(38)*1 ! [(0,2,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(2)-([(0,1,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(2)-([(0,0,5)|(0,0,0)]^(2)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(38)*5 ! [(0,0,6)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(3)-([(0,0,5)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/5/(2p)
        theta(212) = theta(211)*args%PA(1)-theta(127)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(213) = theta(211)*args%PA(2)-theta(127)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(214) = theta(211)*args%PA(3)-theta(127)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(40) = (theta(211)-theta(127))*args%rec_p2
        theta(215) = theta(212)*args%PA(1)-theta(128)*args%PC(1)+t(40)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(216) = theta(213)*args%PA(1)-theta(129)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(217) = theta(214)*args%PA(1)-theta(130)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(218) = theta(213)*args%PA(2)-theta(129)*args%PC(2)+t(40)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(219) = theta(214)*args%PA(2)-theta(130)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(220) = theta(214)*args%PA(3)-theta(130)*args%PC(3)+t(40)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(41) = (theta(212)-theta(128))*args%rec_p2
        theta(221) = theta(215)*args%PA(1)-theta(131)*args%PC(1)+t(41)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(222) = theta(215)*args%PA(2)-theta(131)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        ! theta(223) = theta(215)*args%PA(3)-theta(131)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(224) = theta(218)*args%PA(1)-theta(134)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(225) = theta(219)*args%PA(1)-theta(135)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(226) = theta(220)*args%PA(1)-theta(136)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(42) = (theta(213)-theta(129))*args%rec_p2
        theta(227) = theta(218)*args%PA(2)-theta(134)*args%PC(2)+t(42)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(228) = theta(218)*args%PA(3)-theta(134)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(229) = theta(220)*args%PA(2)-theta(136)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(43) = (theta(214)-theta(130))*args%rec_p2
        theta(230) = theta(220)*args%PA(3)-theta(136)*args%PC(3)+t(43)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(44) = (theta(215)-theta(131))*args%rec_p2
        theta(231) = theta(221)*args%PA(1)-theta(137)*args%PC(1)+t(44)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(232) = theta(221)*args%PA(2)-theta(137)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(233) = theta(221)*args%PA(3)-theta(137)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(45) = (theta(218)-theta(134))*args%rec_p2
        theta(234) = theta(224)*args%PA(1)-theta(140)*args%PC(1)+t(45)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(235) = theta(223)*args%PA(2)-theta(139)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(46) = (theta(220)-theta(136))*args%rec_p2
        theta(236) = theta(226)*args%PA(1)-theta(142)*args%PC(1)+t(46)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(237) = theta(227)*args%PA(1)-theta(143)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(238) = theta(228)*args%PA(1)-theta(144)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        ! theta(239) = theta(229)*args%PA(1)-theta(145)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(240) = theta(230)*args%PA(1)-theta(146)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(241) = theta(227)*args%PA(2)-theta(143)*args%PC(2)+t(45)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(242) = theta(227)*args%PA(3)-theta(143)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(243) = theta(229)*args%PA(2)-theta(145)*args%PC(2)+t(46)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(244) = theta(230)*args%PA(2)-theta(146)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(245) = theta(230)*args%PA(3)-theta(146)*args%PC(3)+t(46)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(47) = (theta(221)-theta(137))*args%rec_p2
        theta(246) = theta(231)*args%PA(1)-theta(147)*args%PC(1)+t(47)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(247) = theta(231)*args%PA(2)-theta(147)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(248) = theta(231)*args%PA(3)-theta(147)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(249) = theta(232)*args%PA(2)-theta(148)*args%PC(2)+t(47)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(250) = theta(233)*args%PA(2)-theta(149)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(251) = theta(233)*args%PA(3)-theta(149)*args%PC(3)+t(47)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(48) = (theta(227)-theta(143))*args%rec_p2
        theta(252) = theta(237)*args%PA(1)-theta(153)*args%PC(1)+t(48)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(253) = theta(234)*args%PA(3)-theta(150)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(254) = theta(236)*args%PA(2)-theta(152)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(49) = (theta(230)-theta(146))*args%rec_p2
        theta(255) = theta(240)*args%PA(1)-theta(156)*args%PC(1)+t(49)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(256) = theta(241)*args%PA(1)-theta(157)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(257) = theta(242)*args%PA(1)-theta(158)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(258) = theta(243)*args%PA(1)-theta(159)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(259) = theta(244)*args%PA(1)-theta(160)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(260) = theta(245)*args%PA(1)-theta(161)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(261) = theta(241)*args%PA(2)-theta(157)*args%PC(2)+t(48)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(262) = theta(241)*args%PA(3)-theta(157)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(263) = theta(242)*args%PA(3)-theta(158)*args%PC(3)+t(48)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(264) = theta(244)*args%PA(2)-theta(160)*args%PC(2)+t(49)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(265) = theta(245)*args%PA(2)-theta(161)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(266) = theta(245)*args%PA(3)-theta(161)*args%PC(3)+t(49)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(50) = (theta(231)-theta(147))*args%rec_p2
        theta(267) = theta(246)*args%PA(1)-theta(162)*args%PC(1)+t(50)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(268) = theta(246)*args%PA(2)-theta(162)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(269) = theta(246)*args%PA(3)-theta(162)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(270) = theta(247)*args%PA(2)-theta(163)*args%PC(2)+t(50)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(271) = theta(248)*args%PA(2)-theta(164)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(272) = theta(248)*args%PA(3)-theta(164)*args%PC(3)+t(50)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(51) = (theta(237)-theta(153))*args%rec_p2
        theta(273) = theta(252)*args%PA(1)-theta(168)*args%PC(1)+t(51)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(274) = theta(249)*args%PA(3)-theta(165)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(275) = theta(251)*args%PA(2)-theta(167)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(52) = (theta(240)-theta(156))*args%rec_p2
        theta(276) = theta(255)*args%PA(1)-theta(171)*args%PC(1)+t(52)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(53) = (theta(241)-theta(157))*args%rec_p2
        theta(277) = theta(256)*args%PA(1)-theta(172)*args%PC(1)+t(53)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(278) = theta(252)*args%PA(3)-theta(168)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(54) = (theta(243)-theta(159))*args%rec_p2
        theta(279) = theta(258)*args%PA(1)-theta(174)*args%PC(1)+t(54)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(280) = theta(255)*args%PA(2)-theta(171)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(55) = (theta(245)-theta(161))*args%rec_p2
        theta(281) = theta(260)*args%PA(1)-theta(176)*args%PC(1)+t(55)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(282) = theta(261)*args%PA(1)-theta(177)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(283) = theta(262)*args%PA(1)-theta(178)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(284) = theta(263)*args%PA(1)-theta(179)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(285) = theta(264)*args%PA(1)-theta(180)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(286) = theta(265)*args%PA(1)-theta(181)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(287) = theta(266)*args%PA(1)-theta(182)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(288) = theta(261)*args%PA(2)-theta(177)*args%PC(2)+t(53)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(289) = theta(261)*args%PA(3)-theta(177)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(290) = theta(262)*args%PA(3)-theta(178)*args%PC(3)+t(53)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(56) = (theta(244)-theta(160))*args%rec_p2
        theta(291) = theta(264)*args%PA(2)-theta(180)*args%PC(2)+t(56)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(292) = theta(265)*args%PA(2)-theta(181)*args%PC(2)+t(55)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(293) = theta(266)*args%PA(2)-theta(182)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(294) = theta(266)*args%PA(3)-theta(182)*args%PC(3)+t(55)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
        t(57) = (theta(246)-theta(162))*args%rec_p2
        theta(295) = theta(267)*args%PA(1)-theta(183)*args%PC(1)+t(57)*6 ! [(7,0,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(1)-([(6,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/6/(2p)
        theta(296) = theta(267)*args%PA(2)-theta(183)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(2)-([(6,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(297) = theta(267)*args%PA(3)-theta(183)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(3)-([(6,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(298) = theta(268)*args%PA(2)-theta(184)*args%PC(2)+t(57)*1 ! [(5,2,0)|(0,0,0)]^(0) = [(5,1,0)|(0,0,0)]^(0)*args%PA(2)-([(5,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(299) = theta(269)*args%PA(2)-theta(185)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(2)-([(5,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(300) = theta(269)*args%PA(3)-theta(185)*args%PC(3)+t(57)*1 ! [(5,0,2)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(3)-([(5,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        t(58) = (theta(247)-theta(163))*args%rec_p2
        theta(301) = theta(270)*args%PA(2)-theta(186)*args%PC(2)+t(58)*2 ! [(4,3,0)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(2)-([(4,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(0)-([(4,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(302) = theta(270)*args%PA(3)-theta(186)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(3)-([(4,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(303) = theta(272)*args%PA(2)-theta(188)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(2)-([(4,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(59) = (theta(248)-theta(164))*args%rec_p2
        theta(304) = theta(272)*args%PA(3)-theta(188)*args%PC(3)+t(59)*2 ! [(4,0,3)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(3)-([(4,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(0)-([(4,0,1)|(0,0,0)]^(1))/2/(2p)
        t(60) = (theta(256)-theta(172))*args%rec_p2
        theta(305) = theta(277)*args%PA(1)-theta(193)*args%PC(1)+t(60)*2 ! [(3,4,0)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(1)-([(2,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(0)-([(1,4,0)|(0,0,0)]^(1))/2/(2p)
        theta(306) = theta(273)*args%PA(3)-theta(189)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(0) = [(3,3,0)|(0,0,0)]^(0)*args%PA(3)-([(3,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(61) = (theta(258)-theta(174))*args%rec_p2
        theta(307) = theta(279)*args%PA(1)-theta(195)*args%PC(1)+t(61)*2 ! [(3,2,2)|(0,0,0)]^(0) = [(2,2,2)|(0,0,0)]^(0)*args%PA(1)-([(2,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(0)-([(1,2,2)|(0,0,0)]^(1))/2/(2p)
        theta(308) = theta(276)*args%PA(2)-theta(192)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(0) = [(3,0,3)|(0,0,0)]^(0)*args%PA(2)-([(3,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(62) = (theta(260)-theta(176))*args%rec_p2
        theta(309) = theta(281)*args%PA(1)-theta(197)*args%PC(1)+t(62)*2 ! [(3,0,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(1)-([(2,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(0)-([(1,0,4)|(0,0,0)]^(1))/2/(2p)
        t(63) = (theta(261)-theta(177))*args%rec_p2
        theta(310) = theta(282)*args%PA(1)-theta(198)*args%PC(1)+t(63)*1 ! [(2,5,0)|(0,0,0)]^(0) = [(1,5,0)|(0,0,0)]^(0)*args%PA(1)-([(1,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        theta(311) = theta(277)*args%PA(3)-theta(193)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(3)-([(2,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(64) = (theta(263)-theta(179))*args%rec_p2
        theta(312) = theta(284)*args%PA(1)-theta(200)*args%PC(1)+t(64)*1 ! [(2,3,2)|(0,0,0)]^(0) = [(1,3,2)|(0,0,0)]^(0)*args%PA(1)-([(1,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(0)-([(0,3,2)|(0,0,0)]^(1))/1/(2p)
        t(65) = (theta(264)-theta(180))*args%rec_p2
        theta(313) = theta(285)*args%PA(1)-theta(201)*args%PC(1)+t(65)*1 ! [(2,2,3)|(0,0,0)]^(0) = [(1,2,3)|(0,0,0)]^(0)*args%PA(1)-([(1,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(0)-([(0,2,3)|(0,0,0)]^(1))/1/(2p)
        theta(314) = theta(281)*args%PA(2)-theta(197)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(2)-([(2,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(66) = (theta(266)-theta(182))*args%rec_p2
        theta(315) = theta(287)*args%PA(1)-theta(203)*args%PC(1)+t(66)*1 ! [(2,0,5)|(0,0,0)]^(0) = [(1,0,5)|(0,0,0)]^(0)*args%PA(1)-([(1,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(316) = theta(288)*args%PA(1)-theta(204)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(1)-([(0,6,0)|(0,0,0)]^(1)*args%PC(1)
        theta(317) = theta(289)*args%PA(1)-theta(205)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(1)-([(0,5,1)|(0,0,0)]^(1)*args%PC(1)
        theta(318) = theta(290)*args%PA(1)-theta(206)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(1)-([(0,4,2)|(0,0,0)]^(1)*args%PC(1)
        theta(319) = theta(291)*args%PA(1)-theta(207)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(0) = [(0,3,3)|(0,0,0)]^(0)*args%PA(1)-([(0,3,3)|(0,0,0)]^(1)*args%PC(1)
        theta(320) = theta(292)*args%PA(1)-theta(208)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(1)-([(0,2,4)|(0,0,0)]^(1)*args%PC(1)
        theta(321) = theta(293)*args%PA(1)-theta(209)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(1)-([(0,1,5)|(0,0,0)]^(1)*args%PC(1)
        theta(322) = theta(294)*args%PA(1)-theta(210)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(1)-([(0,0,6)|(0,0,0)]^(1)*args%PC(1)
        theta(323) = theta(288)*args%PA(2)-theta(204)*args%PC(2)+t(63)*6 ! [(0,7,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(2)-([(0,6,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/6/(2p)
        theta(324) = theta(288)*args%PA(3)-theta(204)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(3)-([(0,6,0)|(0,0,0)]^(1)*args%PC(3)
        theta(325) = theta(289)*args%PA(3)-theta(205)*args%PC(3)+t(63)*1 ! [(0,5,2)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(3)-([(0,5,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        t(67) = (theta(262)-theta(178))*args%rec_p2
        theta(326) = theta(290)*args%PA(3)-theta(206)*args%PC(3)+t(67)*2 ! [(0,4,3)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(3)-([(0,4,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(0)-([(0,4,1)|(0,0,0)]^(1))/2/(2p)
        t(68) = (theta(265)-theta(181))*args%rec_p2
        theta(327) = theta(292)*args%PA(2)-theta(208)*args%PC(2)+t(68)*2 ! [(0,3,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(2)-([(0,2,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(0)-([(0,1,4)|(0,0,0)]^(1))/2/(2p)
        theta(328) = theta(293)*args%PA(2)-theta(209)*args%PC(2)+t(66)*1 ! [(0,2,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(2)-([(0,1,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(329) = theta(294)*args%PA(2)-theta(210)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(2)-([(0,0,6)|(0,0,0)]^(1)*args%PC(2)
        theta(330) = theta(294)*args%PA(3)-theta(210)*args%PC(3)+t(66)*6 ! [(0,0,7)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(3)-([(0,0,6)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/6/(2p)
    end subroutine
    subroutine eanvrr_5_3(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(112)
        ! ================================================
        ! Non-optimized integrals: 495; Optimized integrals: 371
        theta(1) = args%MABpi*boys(args%pRPC2, 8) ! [(0,0,0)|(0,0,0)]^(8) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/15 ! [(0,0,0)|(0,0,0)]^(7) = ([(0,0,0)|(0,0,0)]^(8)*2x+exp(-x))/15
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/13 ! [(0,0,0)|(0,0,0)]^(6) = ([(0,0,0)|(0,0,0)]^(7)*2x+exp(-x))/13
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(211) = (theta(127)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(331) = (theta(211)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(1)-([(0,0,0)|(0,0,0)]^(8)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(2)-([(0,0,0)|(0,0,0)]^(8)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(3)-([(0,0,0)|(0,0,0)]^(8)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(1)-([(0,0,0)|(0,0,0)]^(7)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(2)-([(0,0,0)|(0,0,0)]^(7)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(3)-([(0,0,0)|(0,0,0)]^(7)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(6) = [(1,0,0)|(0,0,0)]^(6)*args%PA(1)-([(1,0,0)|(0,0,0)]^(7)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(1)-([(0,1,0)|(0,0,0)]^(7)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(1)-([(0,0,1)|(0,0,0)]^(7)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(2)-([(0,1,0)|(0,0,0)]^(7)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(2)-([(0,0,1)|(0,0,0)]^(7)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(3)-([(0,0,1)|(0,0,0)]^(7)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(5) = [(1,0,0)|(0,0,0)]^(5)*args%PA(1)-([(1,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(1)-([(0,1,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(1)-([(0,0,1)|(0,0,0)]^(6)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(2)-([(0,1,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(2)-([(0,0,1)|(0,0,0)]^(6)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(3)-([(0,0,1)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(1)-([(2,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(5)-([(1,0,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(2)-([(2,0,0)|(0,0,0)]^(6)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(3)-([(2,0,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(1)-([(0,2,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(5) = [(0,1,1)|(0,0,0)]^(5)*args%PA(1)-([(0,1,1)|(0,0,0)]^(6)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(1)-([(0,0,2)|(0,0,0)]^(6)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(2)-([(0,2,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(5)-([(0,1,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(3)-([(0,2,0)|(0,0,0)]^(6)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(2)-([(0,0,2)|(0,0,0)]^(6)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(3)-([(0,0,2)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(5)-([(0,0,1)|(0,0,0)]^(6))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(1)-([(2,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(4)-([(1,0,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(2)-([(2,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(3)-([(2,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(1)-([(0,2,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(4) = [(0,1,1)|(0,0,0)]^(4)*args%PA(1)-([(0,1,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(1)-([(0,0,2)|(0,0,0)]^(5)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(2)-([(0,2,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(4)-([(0,1,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(3)-([(0,2,0)|(0,0,0)]^(5)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(2)-([(0,0,2)|(0,0,0)]^(5)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(3)-([(0,0,2)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(4)-([(0,0,1)|(0,0,0)]^(5))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(1)-([(3,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(4)-([(2,0,0)|(0,0,0)]^(5))/3/(2p)
        ! theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(2)-([(3,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(3)-([(3,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(4) = [(1,2,0)|(0,0,0)]^(4)*args%PA(1)-([(1,2,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(4) = [(2,0,1)|(0,0,0)]^(4)*args%PA(2)-([(2,0,1)|(0,0,0)]^(5)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(4) = [(1,0,2)|(0,0,0)]^(4)*args%PA(1)-([(1,0,2)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        ! theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(1)-([(0,3,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(4) = [(0,2,1)|(0,0,0)]^(4)*args%PA(1)-([(0,2,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(1)-([(0,1,2)|(0,0,0)]^(5)*args%PC(1)
        ! theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(1)-([(0,0,3)|(0,0,0)]^(5)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(2)-([(0,3,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(3)-([(0,3,0)|(0,0,0)]^(5)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(2)-([(0,1,2)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(2)-([(0,0,3)|(0,0,0)]^(5)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(3)-([(0,0,3)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(1)-([(3,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(3)-([(2,0,0)|(0,0,0)]^(4))/3/(2p)
        ! theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(2)-([(3,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(3)-([(3,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+(theta(78)-theta(43))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(3) = [(1,2,0)|(0,0,0)]^(3)*args%PA(1)-([(1,2,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(3) = [(2,0,1)|(0,0,0)]^(3)*args%PA(2)-([(2,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+(theta(80)-theta(45))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(3) = [(1,0,2)|(0,0,0)]^(3)*args%PA(1)-([(1,0,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(1)-([(0,3,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(3) = [(0,2,1)|(0,0,0)]^(3)*args%PA(1)-([(0,2,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(1)-([(0,1,2)|(0,0,0)]^(4)*args%PC(1)
        theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(1)-([(0,0,3)|(0,0,0)]^(4)*args%PC(1)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(2)-([(0,3,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(3)-([(0,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(2)-([(0,1,2)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(2)-([(0,0,3)|(0,0,0)]^(4)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(3)-([(0,0,3)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(1)-([(4,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/4/(2p)
        theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(2)-([(4,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(3)-([(4,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(3) = [(3,1,0)|(0,0,0)]^(3)*args%PA(2)-([(3,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(2)-([(3,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(3)-([(3,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+(theta(87)-theta(52))*args%rec_p2*1 ! [(2,3,0)|(0,0,0)]^(3) = [(1,3,0)|(0,0,0)]^(3)*args%PA(1)-([(1,3,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(3) = [(2,2,0)|(0,0,0)]^(3)*args%PA(3)-([(2,2,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(3) = [(2,0,2)|(0,0,0)]^(3)*args%PA(2)-([(2,0,2)|(0,0,0)]^(4)*args%PC(2)
        ! theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+(theta(90)-theta(55))*args%rec_p2*1 ! [(2,0,3)|(0,0,0)]^(3) = [(1,0,3)|(0,0,0)]^(3)*args%PA(1)-([(1,0,3)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(1)-([(0,4,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(1)-([(0,3,1)|(0,0,0)]^(4)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(3) = [(0,2,2)|(0,0,0)]^(3)*args%PA(1)-([(0,2,2)|(0,0,0)]^(4)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(1)-([(0,1,3)|(0,0,0)]^(4)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(1)-([(0,0,4)|(0,0,0)]^(4)*args%PC(1)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(2)-([(0,4,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(3)-([(0,4,0)|(0,0,0)]^(4)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(3)-([(0,3,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(2)-([(0,1,3)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(2)-([(0,0,4)|(0,0,0)]^(4)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(3)-([(0,0,4)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+(theta(134)-theta(78))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+(theta(136)-theta(80))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(1)-([(4,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(2)-([(4,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(3)-([(4,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(2) = [(3,1,0)|(0,0,0)]^(2)*args%PA(2)-([(3,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(2)-([(3,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(3)-([(3,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+t(31)*1 ! [(2,3,0)|(0,0,0)]^(2) = [(1,3,0)|(0,0,0)]^(2)*args%PA(1)-([(1,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(2) = [(2,2,0)|(0,0,0)]^(2)*args%PA(3)-([(2,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(2) = [(2,0,2)|(0,0,0)]^(2)*args%PA(2)-([(2,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+t(32)*1 ! [(2,0,3)|(0,0,0)]^(2) = [(1,0,3)|(0,0,0)]^(2)*args%PA(1)-([(1,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(1)-([(0,4,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(1)-([(0,3,1)|(0,0,0)]^(3)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(2) = [(0,2,2)|(0,0,0)]^(2)*args%PA(1)-([(0,2,2)|(0,0,0)]^(3)*args%PC(1)
        ! theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(1)-([(0,1,3)|(0,0,0)]^(3)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(1)-([(0,0,4)|(0,0,0)]^(3)*args%PC(1)
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(2)-([(0,4,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(3)-([(0,4,0)|(0,0,0)]^(3)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(3)-([(0,3,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(2)-([(0,1,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(2)-([(0,0,4)|(0,0,0)]^(3)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(3)-([(0,0,4)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(1)-([(5,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(2)-([(5,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(3)-([(5,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+t(33)*1 ! [(4,2,0)|(0,0,0)]^(2) = [(4,1,0)|(0,0,0)]^(2)*args%PA(2)-([(4,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(2)-([(4,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+t(33)*1 ! [(4,0,2)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(3)-([(4,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+(theta(153)-theta(97))*args%rec_p2*2 ! [(3,3,0)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(1)-([(2,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(2)-([(1,3,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(2) = [(3,2,0)|(0,0,0)]^(2)*args%PA(3)-([(3,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(2) = [(3,0,2)|(0,0,0)]^(2)*args%PA(2)-([(3,0,2)|(0,0,0)]^(3)*args%PC(2)
        ! theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+(theta(156)-theta(100))*args%rec_p2*2 ! [(3,0,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(1)-([(2,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(2)-([(1,0,3)|(0,0,0)]^(3))/2/(2p)
        t(34) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(34)*1 ! [(2,4,0)|(0,0,0)]^(2) = [(1,4,0)|(0,0,0)]^(2)*args%PA(1)-([(1,4,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(3)-([(2,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(35) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(35)*1 ! [(2,2,2)|(0,0,0)]^(2) = [(1,2,2)|(0,0,0)]^(2)*args%PA(1)-([(1,2,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(2)-([(0,2,2)|(0,0,0)]^(3))/1/(2p)
        ! theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(2)-([(2,0,3)|(0,0,0)]^(3)*args%PC(2)
        t(36) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(36)*1 ! [(2,0,4)|(0,0,0)]^(2) = [(1,0,4)|(0,0,0)]^(2)*args%PA(1)-([(1,0,4)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(1)-([(0,5,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(1)-([(0,4,1)|(0,0,0)]^(3)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(2) = [(0,3,2)|(0,0,0)]^(2)*args%PA(1)-([(0,3,2)|(0,0,0)]^(3)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(1)-([(0,2,3)|(0,0,0)]^(3)*args%PC(1)
        ! theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(1)-([(0,1,4)|(0,0,0)]^(3)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(1)-([(0,0,5)|(0,0,0)]^(3)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(34)*5 ! [(0,6,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(2)-([(0,5,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(3)-([(0,5,0)|(0,0,0)]^(3)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(34)*1 ! [(0,4,2)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(3)-([(0,4,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        t(37) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(37)*2 ! [(0,3,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(2)-([(0,2,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(2)-([(0,1,3)|(0,0,0)]^(3))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(36)*1 ! [(0,2,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(2)-([(0,1,4)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(2)-([(0,0,5)|(0,0,0)]^(3)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(36)*5 ! [(0,0,6)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(3)-([(0,0,5)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/5/(2p)
        theta(212) = theta(211)*args%PA(1)-theta(127)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(213) = theta(211)*args%PA(2)-theta(127)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(214) = theta(211)*args%PA(3)-theta(127)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(38) = (theta(211)-theta(127))*args%rec_p2
        theta(215) = theta(212)*args%PA(1)-theta(128)*args%PC(1)+t(38)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(216) = theta(213)*args%PA(1)-theta(129)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(217) = theta(214)*args%PA(1)-theta(130)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(218) = theta(213)*args%PA(2)-theta(129)*args%PC(2)+t(38)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(219) = theta(214)*args%PA(2)-theta(130)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(220) = theta(214)*args%PA(3)-theta(130)*args%PC(3)+t(38)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(39) = (theta(212)-theta(128))*args%rec_p2
        theta(221) = theta(215)*args%PA(1)-theta(131)*args%PC(1)+t(39)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(222) = theta(215)*args%PA(2)-theta(131)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        ! theta(223) = theta(215)*args%PA(3)-theta(131)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(224) = theta(218)*args%PA(1)-theta(134)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(225) = theta(219)*args%PA(1)-theta(135)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(226) = theta(220)*args%PA(1)-theta(136)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(40) = (theta(213)-theta(129))*args%rec_p2
        theta(227) = theta(218)*args%PA(2)-theta(134)*args%PC(2)+t(40)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(228) = theta(218)*args%PA(3)-theta(134)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(229) = theta(220)*args%PA(2)-theta(136)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(41) = (theta(214)-theta(130))*args%rec_p2
        theta(230) = theta(220)*args%PA(3)-theta(136)*args%PC(3)+t(41)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(42) = (theta(215)-theta(131))*args%rec_p2
        theta(231) = theta(221)*args%PA(1)-theta(137)*args%PC(1)+t(42)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(232) = theta(221)*args%PA(2)-theta(137)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(233) = theta(221)*args%PA(3)-theta(137)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(43) = (theta(218)-theta(134))*args%rec_p2
        theta(234) = theta(224)*args%PA(1)-theta(140)*args%PC(1)+t(43)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(235) = theta(223)*args%PA(2)-theta(139)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(44) = (theta(220)-theta(136))*args%rec_p2
        theta(236) = theta(226)*args%PA(1)-theta(142)*args%PC(1)+t(44)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(237) = theta(227)*args%PA(1)-theta(143)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(238) = theta(228)*args%PA(1)-theta(144)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(239) = theta(229)*args%PA(1)-theta(145)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(240) = theta(230)*args%PA(1)-theta(146)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(241) = theta(227)*args%PA(2)-theta(143)*args%PC(2)+t(43)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(242) = theta(227)*args%PA(3)-theta(143)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(243) = theta(229)*args%PA(2)-theta(145)*args%PC(2)+t(44)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(244) = theta(230)*args%PA(2)-theta(146)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(245) = theta(230)*args%PA(3)-theta(146)*args%PC(3)+t(44)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(45) = (theta(221)-theta(137))*args%rec_p2
        theta(246) = theta(231)*args%PA(1)-theta(147)*args%PC(1)+t(45)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(247) = theta(231)*args%PA(2)-theta(147)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(248) = theta(231)*args%PA(3)-theta(147)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(249) = theta(232)*args%PA(2)-theta(148)*args%PC(2)+t(45)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(250) = theta(233)*args%PA(2)-theta(149)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(251) = theta(233)*args%PA(3)-theta(149)*args%PC(3)+t(45)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(46) = (theta(227)-theta(143))*args%rec_p2
        theta(252) = theta(237)*args%PA(1)-theta(153)*args%PC(1)+t(46)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(253) = theta(234)*args%PA(3)-theta(150)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(254) = theta(236)*args%PA(2)-theta(152)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(47) = (theta(230)-theta(146))*args%rec_p2
        theta(255) = theta(240)*args%PA(1)-theta(156)*args%PC(1)+t(47)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(256) = theta(241)*args%PA(1)-theta(157)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(257) = theta(242)*args%PA(1)-theta(158)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(258) = theta(243)*args%PA(1)-theta(159)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(259) = theta(244)*args%PA(1)-theta(160)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(260) = theta(245)*args%PA(1)-theta(161)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(261) = theta(241)*args%PA(2)-theta(157)*args%PC(2)+t(46)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(262) = theta(241)*args%PA(3)-theta(157)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(263) = theta(242)*args%PA(3)-theta(158)*args%PC(3)+t(46)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(264) = theta(244)*args%PA(2)-theta(160)*args%PC(2)+t(47)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(265) = theta(245)*args%PA(2)-theta(161)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(266) = theta(245)*args%PA(3)-theta(161)*args%PC(3)+t(47)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        t(48) = (theta(231)-theta(147))*args%rec_p2
        theta(267) = theta(246)*args%PA(1)-theta(162)*args%PC(1)+t(48)*5 ! [(6,0,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(1)-([(5,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/5/(2p)
        theta(268) = theta(246)*args%PA(2)-theta(162)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(2)-([(5,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(269) = theta(246)*args%PA(3)-theta(162)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(3)-([(5,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(270) = theta(247)*args%PA(2)-theta(163)*args%PC(2)+t(48)*1 ! [(4,2,0)|(0,0,0)]^(1) = [(4,1,0)|(0,0,0)]^(1)*args%PA(2)-([(4,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(271) = theta(248)*args%PA(2)-theta(164)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(2)-([(4,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(272) = theta(248)*args%PA(3)-theta(164)*args%PC(3)+t(48)*1 ! [(4,0,2)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(3)-([(4,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        t(49) = (theta(237)-theta(153))*args%rec_p2
        theta(273) = theta(252)*args%PA(1)-theta(168)*args%PC(1)+t(49)*2 ! [(3,3,0)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(1)-([(2,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(1)-([(1,3,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(274) = theta(249)*args%PA(3)-theta(165)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(1) = [(3,2,0)|(0,0,0)]^(1)*args%PA(3)-([(3,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(275) = theta(251)*args%PA(2)-theta(167)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(1) = [(3,0,2)|(0,0,0)]^(1)*args%PA(2)-([(3,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(50) = (theta(240)-theta(156))*args%rec_p2
        theta(276) = theta(255)*args%PA(1)-theta(171)*args%PC(1)+t(50)*2 ! [(3,0,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(1)-([(2,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(1)-([(1,0,3)|(0,0,0)]^(2))/2/(2p)
        t(51) = (theta(241)-theta(157))*args%rec_p2
        theta(277) = theta(256)*args%PA(1)-theta(172)*args%PC(1)+t(51)*1 ! [(2,4,0)|(0,0,0)]^(1) = [(1,4,0)|(0,0,0)]^(1)*args%PA(1)-([(1,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(278) = theta(252)*args%PA(3)-theta(168)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(3)-([(2,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(52) = (theta(243)-theta(159))*args%rec_p2
        theta(279) = theta(258)*args%PA(1)-theta(174)*args%PC(1)+t(52)*1 ! [(2,2,2)|(0,0,0)]^(1) = [(1,2,2)|(0,0,0)]^(1)*args%PA(1)-([(1,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(1)-([(0,2,2)|(0,0,0)]^(2))/1/(2p)
        ! theta(280) = theta(255)*args%PA(2)-theta(171)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(2)-([(2,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(53) = (theta(245)-theta(161))*args%rec_p2
        theta(281) = theta(260)*args%PA(1)-theta(176)*args%PC(1)+t(53)*1 ! [(2,0,4)|(0,0,0)]^(1) = [(1,0,4)|(0,0,0)]^(1)*args%PA(1)-([(1,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(282) = theta(261)*args%PA(1)-theta(177)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(1)-([(0,5,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(283) = theta(262)*args%PA(1)-theta(178)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(1)-([(0,4,1)|(0,0,0)]^(2)*args%PC(1)
        theta(284) = theta(263)*args%PA(1)-theta(179)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(1) = [(0,3,2)|(0,0,0)]^(1)*args%PA(1)-([(0,3,2)|(0,0,0)]^(2)*args%PC(1)
        theta(285) = theta(264)*args%PA(1)-theta(180)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(1)-([(0,2,3)|(0,0,0)]^(2)*args%PC(1)
        ! theta(286) = theta(265)*args%PA(1)-theta(181)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(1)-([(0,1,4)|(0,0,0)]^(2)*args%PC(1)
        theta(287) = theta(266)*args%PA(1)-theta(182)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(1)-([(0,0,5)|(0,0,0)]^(2)*args%PC(1)
        theta(288) = theta(261)*args%PA(2)-theta(177)*args%PC(2)+t(51)*5 ! [(0,6,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(2)-([(0,5,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/5/(2p)
        theta(289) = theta(261)*args%PA(3)-theta(177)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(3)-([(0,5,0)|(0,0,0)]^(2)*args%PC(3)
        theta(290) = theta(262)*args%PA(3)-theta(178)*args%PC(3)+t(51)*1 ! [(0,4,2)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(3)-([(0,4,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        t(54) = (theta(244)-theta(160))*args%rec_p2
        theta(291) = theta(264)*args%PA(2)-theta(180)*args%PC(2)+t(54)*2 ! [(0,3,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(2)-([(0,2,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(1)-([(0,1,3)|(0,0,0)]^(2))/2/(2p)
        theta(292) = theta(265)*args%PA(2)-theta(181)*args%PC(2)+t(53)*1 ! [(0,2,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(2)-([(0,1,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(293) = theta(266)*args%PA(2)-theta(182)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(2)-([(0,0,5)|(0,0,0)]^(2)*args%PC(2)
        theta(294) = theta(266)*args%PA(3)-theta(182)*args%PC(3)+t(53)*5 ! [(0,0,6)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(3)-([(0,0,5)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/5/(2p)
        t(55) = (theta(246)-theta(162))*args%rec_p2
        theta(295) = theta(267)*args%PA(1)-theta(183)*args%PC(1)+t(55)*6 ! [(7,0,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(1)-([(6,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/6/(2p)
        theta(296) = theta(267)*args%PA(2)-theta(183)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(2)-([(6,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(297) = theta(267)*args%PA(3)-theta(183)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(3)-([(6,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(298) = theta(268)*args%PA(2)-theta(184)*args%PC(2)+t(55)*1 ! [(5,2,0)|(0,0,0)]^(1) = [(5,1,0)|(0,0,0)]^(1)*args%PA(2)-([(5,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(299) = theta(269)*args%PA(2)-theta(185)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(2)-([(5,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(300) = theta(269)*args%PA(3)-theta(185)*args%PC(3)+t(55)*1 ! [(5,0,2)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(3)-([(5,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        t(56) = (theta(247)-theta(163))*args%rec_p2
        theta(301) = theta(270)*args%PA(2)-theta(186)*args%PC(2)+t(56)*2 ! [(4,3,0)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(2)-([(4,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(1)-([(4,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(302) = theta(270)*args%PA(3)-theta(186)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(3)-([(4,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(303) = theta(272)*args%PA(2)-theta(188)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(2)-([(4,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(57) = (theta(248)-theta(164))*args%rec_p2
        theta(304) = theta(272)*args%PA(3)-theta(188)*args%PC(3)+t(57)*2 ! [(4,0,3)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(3)-([(4,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(1)-([(4,0,1)|(0,0,0)]^(2))/2/(2p)
        t(58) = (theta(256)-theta(172))*args%rec_p2
        theta(305) = theta(277)*args%PA(1)-theta(193)*args%PC(1)+t(58)*2 ! [(3,4,0)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(1)-([(2,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(1)-([(1,4,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(306) = theta(273)*args%PA(3)-theta(189)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(1) = [(3,3,0)|(0,0,0)]^(1)*args%PA(3)-([(3,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(59) = (theta(258)-theta(174))*args%rec_p2
        theta(307) = theta(279)*args%PA(1)-theta(195)*args%PC(1)+t(59)*2 ! [(3,2,2)|(0,0,0)]^(1) = [(2,2,2)|(0,0,0)]^(1)*args%PA(1)-([(2,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(1)-([(1,2,2)|(0,0,0)]^(2))/2/(2p)
        ! theta(308) = theta(276)*args%PA(2)-theta(192)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(1) = [(3,0,3)|(0,0,0)]^(1)*args%PA(2)-([(3,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(60) = (theta(260)-theta(176))*args%rec_p2
        theta(309) = theta(281)*args%PA(1)-theta(197)*args%PC(1)+t(60)*2 ! [(3,0,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(1)-([(2,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(1)-([(1,0,4)|(0,0,0)]^(2))/2/(2p)
        t(61) = (theta(261)-theta(177))*args%rec_p2
        theta(310) = theta(282)*args%PA(1)-theta(198)*args%PC(1)+t(61)*1 ! [(2,5,0)|(0,0,0)]^(1) = [(1,5,0)|(0,0,0)]^(1)*args%PA(1)-([(1,5,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(311) = theta(277)*args%PA(3)-theta(193)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(3)-([(2,4,0)|(0,0,0)]^(2)*args%PC(3)
        t(62) = (theta(263)-theta(179))*args%rec_p2
        theta(312) = theta(284)*args%PA(1)-theta(200)*args%PC(1)+t(62)*1 ! [(2,3,2)|(0,0,0)]^(1) = [(1,3,2)|(0,0,0)]^(1)*args%PA(1)-([(1,3,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(1)-([(0,3,2)|(0,0,0)]^(2))/1/(2p)
        t(63) = (theta(264)-theta(180))*args%rec_p2
        theta(313) = theta(285)*args%PA(1)-theta(201)*args%PC(1)+t(63)*1 ! [(2,2,3)|(0,0,0)]^(1) = [(1,2,3)|(0,0,0)]^(1)*args%PA(1)-([(1,2,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(1)-([(0,2,3)|(0,0,0)]^(2))/1/(2p)
        ! theta(314) = theta(281)*args%PA(2)-theta(197)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(2)-([(2,0,4)|(0,0,0)]^(2)*args%PC(2)
        t(64) = (theta(266)-theta(182))*args%rec_p2
        theta(315) = theta(287)*args%PA(1)-theta(203)*args%PC(1)+t(64)*1 ! [(2,0,5)|(0,0,0)]^(1) = [(1,0,5)|(0,0,0)]^(1)*args%PA(1)-([(1,0,5)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(316) = theta(288)*args%PA(1)-theta(204)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(1)-([(0,6,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(317) = theta(289)*args%PA(1)-theta(205)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(1)-([(0,5,1)|(0,0,0)]^(2)*args%PC(1)
        theta(318) = theta(290)*args%PA(1)-theta(206)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(1)-([(0,4,2)|(0,0,0)]^(2)*args%PC(1)
        theta(319) = theta(291)*args%PA(1)-theta(207)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(1) = [(0,3,3)|(0,0,0)]^(1)*args%PA(1)-([(0,3,3)|(0,0,0)]^(2)*args%PC(1)
        theta(320) = theta(292)*args%PA(1)-theta(208)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(1)-([(0,2,4)|(0,0,0)]^(2)*args%PC(1)
        ! theta(321) = theta(293)*args%PA(1)-theta(209)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(1)-([(0,1,5)|(0,0,0)]^(2)*args%PC(1)
        theta(322) = theta(294)*args%PA(1)-theta(210)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(1)-([(0,0,6)|(0,0,0)]^(2)*args%PC(1)
        theta(323) = theta(288)*args%PA(2)-theta(204)*args%PC(2)+t(61)*6 ! [(0,7,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(2)-([(0,6,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/6/(2p)
        theta(324) = theta(288)*args%PA(3)-theta(204)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(3)-([(0,6,0)|(0,0,0)]^(2)*args%PC(3)
        theta(325) = theta(289)*args%PA(3)-theta(205)*args%PC(3)+t(61)*1 ! [(0,5,2)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(3)-([(0,5,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        t(65) = (theta(262)-theta(178))*args%rec_p2
        theta(326) = theta(290)*args%PA(3)-theta(206)*args%PC(3)+t(65)*2 ! [(0,4,3)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(3)-([(0,4,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(1)-([(0,4,1)|(0,0,0)]^(2))/2/(2p)
        t(66) = (theta(265)-theta(181))*args%rec_p2
        theta(327) = theta(292)*args%PA(2)-theta(208)*args%PC(2)+t(66)*2 ! [(0,3,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(2)-([(0,2,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(1)-([(0,1,4)|(0,0,0)]^(2))/2/(2p)
        theta(328) = theta(293)*args%PA(2)-theta(209)*args%PC(2)+t(64)*1 ! [(0,2,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(2)-([(0,1,5)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(329) = theta(294)*args%PA(2)-theta(210)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(2)-([(0,0,6)|(0,0,0)]^(2)*args%PC(2)
        theta(330) = theta(294)*args%PA(3)-theta(210)*args%PC(3)+t(64)*6 ! [(0,0,7)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(3)-([(0,0,6)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/6/(2p)
        theta(332) = theta(331)*args%PA(1)-theta(211)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(333) = theta(331)*args%PA(2)-theta(211)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(334) = theta(331)*args%PA(3)-theta(211)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(67) = (theta(331)-theta(211))*args%rec_p2
        theta(335) = theta(332)*args%PA(1)-theta(212)*args%PC(1)+t(67)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(336) = theta(333)*args%PA(1)-theta(213)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(337) = theta(334)*args%PA(1)-theta(214)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(338) = theta(333)*args%PA(2)-theta(213)*args%PC(2)+t(67)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(339) = theta(334)*args%PA(2)-theta(214)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(340) = theta(334)*args%PA(3)-theta(214)*args%PC(3)+t(67)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(68) = (theta(332)-theta(212))*args%rec_p2
        theta(341) = theta(335)*args%PA(1)-theta(215)*args%PC(1)+t(68)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(342) = theta(335)*args%PA(2)-theta(215)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        ! theta(343) = theta(335)*args%PA(3)-theta(215)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(344) = theta(338)*args%PA(1)-theta(218)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(345) = theta(339)*args%PA(1)-theta(219)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(346) = theta(340)*args%PA(1)-theta(220)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(69) = (theta(333)-theta(213))*args%rec_p2
        theta(347) = theta(338)*args%PA(2)-theta(218)*args%PC(2)+t(69)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(348) = theta(338)*args%PA(3)-theta(218)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(349) = theta(340)*args%PA(2)-theta(220)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(70) = (theta(334)-theta(214))*args%rec_p2
        theta(350) = theta(340)*args%PA(3)-theta(220)*args%PC(3)+t(70)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(71) = (theta(335)-theta(215))*args%rec_p2
        theta(351) = theta(341)*args%PA(1)-theta(221)*args%PC(1)+t(71)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(352) = theta(341)*args%PA(2)-theta(221)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(353) = theta(341)*args%PA(3)-theta(221)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(72) = (theta(338)-theta(218))*args%rec_p2
        theta(354) = theta(344)*args%PA(1)-theta(224)*args%PC(1)+t(72)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(355) = theta(343)*args%PA(2)-theta(223)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(73) = (theta(340)-theta(220))*args%rec_p2
        theta(356) = theta(346)*args%PA(1)-theta(226)*args%PC(1)+t(73)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(357) = theta(347)*args%PA(1)-theta(227)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(358) = theta(348)*args%PA(1)-theta(228)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        ! theta(359) = theta(349)*args%PA(1)-theta(229)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(360) = theta(350)*args%PA(1)-theta(230)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(361) = theta(347)*args%PA(2)-theta(227)*args%PC(2)+t(72)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(362) = theta(347)*args%PA(3)-theta(227)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(363) = theta(349)*args%PA(2)-theta(229)*args%PC(2)+t(73)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(364) = theta(350)*args%PA(2)-theta(230)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(365) = theta(350)*args%PA(3)-theta(230)*args%PC(3)+t(73)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(74) = (theta(341)-theta(221))*args%rec_p2
        theta(366) = theta(351)*args%PA(1)-theta(231)*args%PC(1)+t(74)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(367) = theta(351)*args%PA(2)-theta(231)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(368) = theta(351)*args%PA(3)-theta(231)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(369) = theta(352)*args%PA(2)-theta(232)*args%PC(2)+t(74)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(370) = theta(353)*args%PA(2)-theta(233)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(371) = theta(353)*args%PA(3)-theta(233)*args%PC(3)+t(74)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(75) = (theta(347)-theta(227))*args%rec_p2
        theta(372) = theta(357)*args%PA(1)-theta(237)*args%PC(1)+t(75)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(373) = theta(354)*args%PA(3)-theta(234)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(374) = theta(356)*args%PA(2)-theta(236)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(76) = (theta(350)-theta(230))*args%rec_p2
        theta(375) = theta(360)*args%PA(1)-theta(240)*args%PC(1)+t(76)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(376) = theta(361)*args%PA(1)-theta(241)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(377) = theta(362)*args%PA(1)-theta(242)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(378) = theta(363)*args%PA(1)-theta(243)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(379) = theta(364)*args%PA(1)-theta(244)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(380) = theta(365)*args%PA(1)-theta(245)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(381) = theta(361)*args%PA(2)-theta(241)*args%PC(2)+t(75)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(382) = theta(361)*args%PA(3)-theta(241)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(383) = theta(362)*args%PA(3)-theta(242)*args%PC(3)+t(75)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(384) = theta(364)*args%PA(2)-theta(244)*args%PC(2)+t(76)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(385) = theta(365)*args%PA(2)-theta(245)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(386) = theta(365)*args%PA(3)-theta(245)*args%PC(3)+t(76)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(77) = (theta(351)-theta(231))*args%rec_p2
        theta(387) = theta(366)*args%PA(1)-theta(246)*args%PC(1)+t(77)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(388) = theta(366)*args%PA(2)-theta(246)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(389) = theta(366)*args%PA(3)-theta(246)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(390) = theta(367)*args%PA(2)-theta(247)*args%PC(2)+t(77)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(391) = theta(368)*args%PA(2)-theta(248)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(392) = theta(368)*args%PA(3)-theta(248)*args%PC(3)+t(77)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(78) = (theta(357)-theta(237))*args%rec_p2
        theta(393) = theta(372)*args%PA(1)-theta(252)*args%PC(1)+t(78)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(394) = theta(369)*args%PA(3)-theta(249)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(395) = theta(371)*args%PA(2)-theta(251)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(79) = (theta(360)-theta(240))*args%rec_p2
        theta(396) = theta(375)*args%PA(1)-theta(255)*args%PC(1)+t(79)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(80) = (theta(361)-theta(241))*args%rec_p2
        theta(397) = theta(376)*args%PA(1)-theta(256)*args%PC(1)+t(80)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(398) = theta(372)*args%PA(3)-theta(252)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(81) = (theta(363)-theta(243))*args%rec_p2
        theta(399) = theta(378)*args%PA(1)-theta(258)*args%PC(1)+t(81)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(400) = theta(375)*args%PA(2)-theta(255)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(82) = (theta(365)-theta(245))*args%rec_p2
        theta(401) = theta(380)*args%PA(1)-theta(260)*args%PC(1)+t(82)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(402) = theta(381)*args%PA(1)-theta(261)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(403) = theta(382)*args%PA(1)-theta(262)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(404) = theta(383)*args%PA(1)-theta(263)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(405) = theta(384)*args%PA(1)-theta(264)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(406) = theta(385)*args%PA(1)-theta(265)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(407) = theta(386)*args%PA(1)-theta(266)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(408) = theta(381)*args%PA(2)-theta(261)*args%PC(2)+t(80)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(409) = theta(381)*args%PA(3)-theta(261)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(410) = theta(382)*args%PA(3)-theta(262)*args%PC(3)+t(80)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(83) = (theta(364)-theta(244))*args%rec_p2
        theta(411) = theta(384)*args%PA(2)-theta(264)*args%PC(2)+t(83)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(412) = theta(385)*args%PA(2)-theta(265)*args%PC(2)+t(82)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(413) = theta(386)*args%PA(2)-theta(266)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(414) = theta(386)*args%PA(3)-theta(266)*args%PC(3)+t(82)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
        t(84) = (theta(366)-theta(246))*args%rec_p2
        theta(415) = theta(387)*args%PA(1)-theta(267)*args%PC(1)+t(84)*6 ! [(7,0,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(1)-([(6,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/6/(2p)
        theta(416) = theta(387)*args%PA(2)-theta(267)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(2)-([(6,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(417) = theta(387)*args%PA(3)-theta(267)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(3)-([(6,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(418) = theta(388)*args%PA(2)-theta(268)*args%PC(2)+t(84)*1 ! [(5,2,0)|(0,0,0)]^(0) = [(5,1,0)|(0,0,0)]^(0)*args%PA(2)-([(5,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(419) = theta(389)*args%PA(2)-theta(269)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(2)-([(5,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(420) = theta(389)*args%PA(3)-theta(269)*args%PC(3)+t(84)*1 ! [(5,0,2)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(3)-([(5,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        t(85) = (theta(367)-theta(247))*args%rec_p2
        theta(421) = theta(390)*args%PA(2)-theta(270)*args%PC(2)+t(85)*2 ! [(4,3,0)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(2)-([(4,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(0)-([(4,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(422) = theta(390)*args%PA(3)-theta(270)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(3)-([(4,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(423) = theta(392)*args%PA(2)-theta(272)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(2)-([(4,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(86) = (theta(368)-theta(248))*args%rec_p2
        theta(424) = theta(392)*args%PA(3)-theta(272)*args%PC(3)+t(86)*2 ! [(4,0,3)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(3)-([(4,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(0)-([(4,0,1)|(0,0,0)]^(1))/2/(2p)
        t(87) = (theta(376)-theta(256))*args%rec_p2
        theta(425) = theta(397)*args%PA(1)-theta(277)*args%PC(1)+t(87)*2 ! [(3,4,0)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(1)-([(2,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(0)-([(1,4,0)|(0,0,0)]^(1))/2/(2p)
        theta(426) = theta(393)*args%PA(3)-theta(273)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(0) = [(3,3,0)|(0,0,0)]^(0)*args%PA(3)-([(3,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(88) = (theta(378)-theta(258))*args%rec_p2
        theta(427) = theta(399)*args%PA(1)-theta(279)*args%PC(1)+t(88)*2 ! [(3,2,2)|(0,0,0)]^(0) = [(2,2,2)|(0,0,0)]^(0)*args%PA(1)-([(2,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(0)-([(1,2,2)|(0,0,0)]^(1))/2/(2p)
        theta(428) = theta(396)*args%PA(2)-theta(276)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(0) = [(3,0,3)|(0,0,0)]^(0)*args%PA(2)-([(3,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(89) = (theta(380)-theta(260))*args%rec_p2
        theta(429) = theta(401)*args%PA(1)-theta(281)*args%PC(1)+t(89)*2 ! [(3,0,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(1)-([(2,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(0)-([(1,0,4)|(0,0,0)]^(1))/2/(2p)
        t(90) = (theta(381)-theta(261))*args%rec_p2
        theta(430) = theta(402)*args%PA(1)-theta(282)*args%PC(1)+t(90)*1 ! [(2,5,0)|(0,0,0)]^(0) = [(1,5,0)|(0,0,0)]^(0)*args%PA(1)-([(1,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        theta(431) = theta(397)*args%PA(3)-theta(277)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(3)-([(2,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(91) = (theta(383)-theta(263))*args%rec_p2
        theta(432) = theta(404)*args%PA(1)-theta(284)*args%PC(1)+t(91)*1 ! [(2,3,2)|(0,0,0)]^(0) = [(1,3,2)|(0,0,0)]^(0)*args%PA(1)-([(1,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(0)-([(0,3,2)|(0,0,0)]^(1))/1/(2p)
        t(92) = (theta(384)-theta(264))*args%rec_p2
        theta(433) = theta(405)*args%PA(1)-theta(285)*args%PC(1)+t(92)*1 ! [(2,2,3)|(0,0,0)]^(0) = [(1,2,3)|(0,0,0)]^(0)*args%PA(1)-([(1,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(0)-([(0,2,3)|(0,0,0)]^(1))/1/(2p)
        theta(434) = theta(401)*args%PA(2)-theta(281)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(2)-([(2,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(93) = (theta(386)-theta(266))*args%rec_p2
        theta(435) = theta(407)*args%PA(1)-theta(287)*args%PC(1)+t(93)*1 ! [(2,0,5)|(0,0,0)]^(0) = [(1,0,5)|(0,0,0)]^(0)*args%PA(1)-([(1,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(436) = theta(408)*args%PA(1)-theta(288)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(1)-([(0,6,0)|(0,0,0)]^(1)*args%PC(1)
        theta(437) = theta(409)*args%PA(1)-theta(289)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(1)-([(0,5,1)|(0,0,0)]^(1)*args%PC(1)
        theta(438) = theta(410)*args%PA(1)-theta(290)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(1)-([(0,4,2)|(0,0,0)]^(1)*args%PC(1)
        theta(439) = theta(411)*args%PA(1)-theta(291)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(0) = [(0,3,3)|(0,0,0)]^(0)*args%PA(1)-([(0,3,3)|(0,0,0)]^(1)*args%PC(1)
        theta(440) = theta(412)*args%PA(1)-theta(292)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(1)-([(0,2,4)|(0,0,0)]^(1)*args%PC(1)
        theta(441) = theta(413)*args%PA(1)-theta(293)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(1)-([(0,1,5)|(0,0,0)]^(1)*args%PC(1)
        theta(442) = theta(414)*args%PA(1)-theta(294)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(1)-([(0,0,6)|(0,0,0)]^(1)*args%PC(1)
        theta(443) = theta(408)*args%PA(2)-theta(288)*args%PC(2)+t(90)*6 ! [(0,7,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(2)-([(0,6,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/6/(2p)
        theta(444) = theta(408)*args%PA(3)-theta(288)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(3)-([(0,6,0)|(0,0,0)]^(1)*args%PC(3)
        theta(445) = theta(409)*args%PA(3)-theta(289)*args%PC(3)+t(90)*1 ! [(0,5,2)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(3)-([(0,5,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        t(94) = (theta(382)-theta(262))*args%rec_p2
        theta(446) = theta(410)*args%PA(3)-theta(290)*args%PC(3)+t(94)*2 ! [(0,4,3)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(3)-([(0,4,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(0)-([(0,4,1)|(0,0,0)]^(1))/2/(2p)
        t(95) = (theta(385)-theta(265))*args%rec_p2
        theta(447) = theta(412)*args%PA(2)-theta(292)*args%PC(2)+t(95)*2 ! [(0,3,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(2)-([(0,2,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(0)-([(0,1,4)|(0,0,0)]^(1))/2/(2p)
        theta(448) = theta(413)*args%PA(2)-theta(293)*args%PC(2)+t(93)*1 ! [(0,2,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(2)-([(0,1,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(449) = theta(414)*args%PA(2)-theta(294)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(2)-([(0,0,6)|(0,0,0)]^(1)*args%PC(2)
        theta(450) = theta(414)*args%PA(3)-theta(294)*args%PC(3)+t(93)*6 ! [(0,0,7)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(3)-([(0,0,6)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/6/(2p)
        t(96) = (theta(387)-theta(267))*args%rec_p2
        theta(451) = theta(415)*args%PA(1)-theta(295)*args%PC(1)+t(96)*7 ! [(8,0,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(1)-([(7,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/7/(2p)
        theta(452) = theta(415)*args%PA(2)-theta(295)*args%PC(2) ! [(7,1,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(2)-([(7,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(453) = theta(415)*args%PA(3)-theta(295)*args%PC(3) ! [(7,0,1)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(3)-([(7,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(454) = theta(416)*args%PA(2)-theta(296)*args%PC(2)+t(96)*1 ! [(6,2,0)|(0,0,0)]^(0) = [(6,1,0)|(0,0,0)]^(0)*args%PA(2)-([(6,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(455) = theta(417)*args%PA(2)-theta(297)*args%PC(2) ! [(6,1,1)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(2)-([(6,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(456) = theta(417)*args%PA(3)-theta(297)*args%PC(3)+t(96)*1 ! [(6,0,2)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(3)-([(6,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        t(97) = (theta(388)-theta(268))*args%rec_p2
        theta(457) = theta(418)*args%PA(2)-theta(298)*args%PC(2)+t(97)*2 ! [(5,3,0)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(2)-([(5,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,1,0)|(0,0,0)]^(0)-([(5,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(458) = theta(418)*args%PA(3)-theta(298)*args%PC(3) ! [(5,2,1)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(3)-([(5,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(459) = theta(420)*args%PA(2)-theta(300)*args%PC(2) ! [(5,1,2)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(2)-([(5,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(98) = (theta(389)-theta(269))*args%rec_p2
        theta(460) = theta(420)*args%PA(3)-theta(300)*args%PC(3)+t(98)*2 ! [(5,0,3)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(3)-([(5,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,1)|(0,0,0)]^(0)-([(5,0,1)|(0,0,0)]^(1))/2/(2p)
        t(99) = (theta(397)-theta(277))*args%rec_p2
        theta(461) = theta(425)*args%PA(1)-theta(305)*args%PC(1)+t(99)*3 ! [(4,4,0)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(1)-([(3,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,4,0)|(0,0,0)]^(0)-([(2,4,0)|(0,0,0)]^(1))/3/(2p)
        theta(462) = theta(421)*args%PA(3)-theta(301)*args%PC(3) ! [(4,3,1)|(0,0,0)]^(0) = [(4,3,0)|(0,0,0)]^(0)*args%PA(3)-([(4,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(100) = (theta(399)-theta(279))*args%rec_p2
        theta(463) = theta(427)*args%PA(1)-theta(307)*args%PC(1)+t(100)*3 ! [(4,2,2)|(0,0,0)]^(0) = [(3,2,2)|(0,0,0)]^(0)*args%PA(1)-([(3,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(2,2,2)|(0,0,0)]^(0)-([(2,2,2)|(0,0,0)]^(1))/3/(2p)
        theta(464) = theta(424)*args%PA(2)-theta(304)*args%PC(2) ! [(4,1,3)|(0,0,0)]^(0) = [(4,0,3)|(0,0,0)]^(0)*args%PA(2)-([(4,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(101) = (theta(401)-theta(281))*args%rec_p2
        theta(465) = theta(429)*args%PA(1)-theta(309)*args%PC(1)+t(101)*3 ! [(4,0,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(1)-([(3,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,4)|(0,0,0)]^(0)-([(2,0,4)|(0,0,0)]^(1))/3/(2p)
        t(102) = (theta(402)-theta(282))*args%rec_p2
        theta(466) = theta(430)*args%PA(1)-theta(310)*args%PC(1)+t(102)*2 ! [(3,5,0)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(1)-([(2,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,5,0)|(0,0,0)]^(0)-([(1,5,0)|(0,0,0)]^(1))/2/(2p)
        theta(467) = theta(425)*args%PA(3)-theta(305)*args%PC(3) ! [(3,4,1)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(3)-([(3,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(103) = (theta(404)-theta(284))*args%rec_p2
        theta(468) = theta(432)*args%PA(1)-theta(312)*args%PC(1)+t(103)*2 ! [(3,3,2)|(0,0,0)]^(0) = [(2,3,2)|(0,0,0)]^(0)*args%PA(1)-([(2,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,2)|(0,0,0)]^(0)-([(1,3,2)|(0,0,0)]^(1))/2/(2p)
        t(104) = (theta(405)-theta(285))*args%rec_p2
        theta(469) = theta(433)*args%PA(1)-theta(313)*args%PC(1)+t(104)*2 ! [(3,2,3)|(0,0,0)]^(0) = [(2,2,3)|(0,0,0)]^(0)*args%PA(1)-([(2,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,3)|(0,0,0)]^(0)-([(1,2,3)|(0,0,0)]^(1))/2/(2p)
        theta(470) = theta(429)*args%PA(2)-theta(309)*args%PC(2) ! [(3,1,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(2)-([(3,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(105) = (theta(407)-theta(287))*args%rec_p2
        theta(471) = theta(435)*args%PA(1)-theta(315)*args%PC(1)+t(105)*2 ! [(3,0,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(1)-([(2,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,5)|(0,0,0)]^(0)-([(1,0,5)|(0,0,0)]^(1))/2/(2p)
        t(106) = (theta(408)-theta(288))*args%rec_p2
        theta(472) = theta(436)*args%PA(1)-theta(316)*args%PC(1)+t(106)*1 ! [(2,6,0)|(0,0,0)]^(0) = [(1,6,0)|(0,0,0)]^(0)*args%PA(1)-([(1,6,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        theta(473) = theta(430)*args%PA(3)-theta(310)*args%PC(3) ! [(2,5,1)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(3)-([(2,5,0)|(0,0,0)]^(1)*args%PC(3)
        t(107) = (theta(410)-theta(290))*args%rec_p2
        theta(474) = theta(438)*args%PA(1)-theta(318)*args%PC(1)+t(107)*1 ! [(2,4,2)|(0,0,0)]^(0) = [(1,4,2)|(0,0,0)]^(0)*args%PA(1)-([(1,4,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,2)|(0,0,0)]^(0)-([(0,4,2)|(0,0,0)]^(1))/1/(2p)
        t(108) = (theta(411)-theta(291))*args%rec_p2
        theta(475) = theta(439)*args%PA(1)-theta(319)*args%PC(1)+t(108)*1 ! [(2,3,3)|(0,0,0)]^(0) = [(1,3,3)|(0,0,0)]^(0)*args%PA(1)-([(1,3,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,3)|(0,0,0)]^(0)-([(0,3,3)|(0,0,0)]^(1))/1/(2p)
        t(109) = (theta(412)-theta(292))*args%rec_p2
        theta(476) = theta(440)*args%PA(1)-theta(320)*args%PC(1)+t(109)*1 ! [(2,2,4)|(0,0,0)]^(0) = [(1,2,4)|(0,0,0)]^(0)*args%PA(1)-([(1,2,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/1/(2p)
        theta(477) = theta(435)*args%PA(2)-theta(315)*args%PC(2) ! [(2,1,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(2)-([(2,0,5)|(0,0,0)]^(1)*args%PC(2)
        t(110) = (theta(414)-theta(294))*args%rec_p2
        theta(478) = theta(442)*args%PA(1)-theta(322)*args%PC(1)+t(110)*1 ! [(2,0,6)|(0,0,0)]^(0) = [(1,0,6)|(0,0,0)]^(0)*args%PA(1)-([(1,0,6)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(479) = theta(443)*args%PA(1)-theta(323)*args%PC(1) ! [(1,7,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(1)-([(0,7,0)|(0,0,0)]^(1)*args%PC(1)
        theta(480) = theta(444)*args%PA(1)-theta(324)*args%PC(1) ! [(1,6,1)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(1)-([(0,6,1)|(0,0,0)]^(1)*args%PC(1)
        theta(481) = theta(445)*args%PA(1)-theta(325)*args%PC(1) ! [(1,5,2)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(1)-([(0,5,2)|(0,0,0)]^(1)*args%PC(1)
        theta(482) = theta(446)*args%PA(1)-theta(326)*args%PC(1) ! [(1,4,3)|(0,0,0)]^(0) = [(0,4,3)|(0,0,0)]^(0)*args%PA(1)-([(0,4,3)|(0,0,0)]^(1)*args%PC(1)
        theta(483) = theta(447)*args%PA(1)-theta(327)*args%PC(1) ! [(1,3,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(1)-([(0,3,4)|(0,0,0)]^(1)*args%PC(1)
        theta(484) = theta(448)*args%PA(1)-theta(328)*args%PC(1) ! [(1,2,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(1)-([(0,2,5)|(0,0,0)]^(1)*args%PC(1)
        theta(485) = theta(449)*args%PA(1)-theta(329)*args%PC(1) ! [(1,1,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(1)-([(0,1,6)|(0,0,0)]^(1)*args%PC(1)
        theta(486) = theta(450)*args%PA(1)-theta(330)*args%PC(1) ! [(1,0,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(1)-([(0,0,7)|(0,0,0)]^(1)*args%PC(1)
        theta(487) = theta(443)*args%PA(2)-theta(323)*args%PC(2)+t(106)*7 ! [(0,8,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(2)-([(0,7,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/7/(2p)
        theta(488) = theta(443)*args%PA(3)-theta(323)*args%PC(3) ! [(0,7,1)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(3)-([(0,7,0)|(0,0,0)]^(1)*args%PC(3)
        theta(489) = theta(444)*args%PA(3)-theta(324)*args%PC(3)+t(106)*1 ! [(0,6,2)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(3)-([(0,6,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        t(111) = (theta(409)-theta(289))*args%rec_p2
        theta(490) = theta(445)*args%PA(3)-theta(325)*args%PC(3)+t(111)*2 ! [(0,5,3)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(3)-([(0,5,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,1)|(0,0,0)]^(0)-([(0,5,1)|(0,0,0)]^(1))/2/(2p)
        theta(491) = theta(447)*args%PA(2)-theta(327)*args%PC(2)+t(109)*3 ! [(0,4,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(2)-([(0,3,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/3/(2p)
        t(112) = (theta(413)-theta(293))*args%rec_p2
        theta(492) = theta(448)*args%PA(2)-theta(328)*args%PC(2)+t(112)*2 ! [(0,3,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(2)-([(0,2,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,5)|(0,0,0)]^(0)-([(0,1,5)|(0,0,0)]^(1))/2/(2p)
        theta(493) = theta(449)*args%PA(2)-theta(329)*args%PC(2)+t(110)*1 ! [(0,2,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(2)-([(0,1,6)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(494) = theta(450)*args%PA(2)-theta(330)*args%PC(2) ! [(0,1,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(2)-([(0,0,7)|(0,0,0)]^(1)*args%PC(2)
        theta(495) = theta(450)*args%PA(3)-theta(330)*args%PC(3)+t(110)*7 ! [(0,0,8)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(3)-([(0,0,7)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/7/(2p)
    end subroutine
    subroutine eanvrr_5_4(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(177)
        ! ================================================
        ! Non-optimized integrals: 715; Optimized integrals: 529
        theta(1) = args%MABpi*boys(args%pRPC2, 9) ! [(0,0,0)|(0,0,0)]^(9) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/17 ! [(0,0,0)|(0,0,0)]^(8) = ([(0,0,0)|(0,0,0)]^(9)*2x+exp(-x))/17
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/15 ! [(0,0,0)|(0,0,0)]^(7) = ([(0,0,0)|(0,0,0)]^(8)*2x+exp(-x))/15
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/13 ! [(0,0,0)|(0,0,0)]^(6) = ([(0,0,0)|(0,0,0)]^(7)*2x+exp(-x))/13
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(211) = (theta(127)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(331) = (theta(211)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(496) = (theta(331)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(8) = [(0,0,0)|(0,0,0)]^(8)*args%PA(1)-([(0,0,0)|(0,0,0)]^(9)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(8) = [(0,0,0)|(0,0,0)]^(8)*args%PA(2)-([(0,0,0)|(0,0,0)]^(9)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(8) = [(0,0,0)|(0,0,0)]^(8)*args%PA(3)-([(0,0,0)|(0,0,0)]^(9)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(1)-([(0,0,0)|(0,0,0)]^(8)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(2)-([(0,0,0)|(0,0,0)]^(8)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(3)-([(0,0,0)|(0,0,0)]^(8)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(7) = [(1,0,0)|(0,0,0)]^(7)*args%PA(1)-([(1,0,0)|(0,0,0)]^(8)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(7)-([(0,0,0)|(0,0,0)]^(8))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(7) = [(0,1,0)|(0,0,0)]^(7)*args%PA(1)-([(0,1,0)|(0,0,0)]^(8)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(7) = [(0,0,1)|(0,0,0)]^(7)*args%PA(1)-([(0,0,1)|(0,0,0)]^(8)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(7) = [(0,1,0)|(0,0,0)]^(7)*args%PA(2)-([(0,1,0)|(0,0,0)]^(8)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(7)-([(0,0,0)|(0,0,0)]^(8))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(7) = [(0,0,1)|(0,0,0)]^(7)*args%PA(2)-([(0,0,1)|(0,0,0)]^(8)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(7) = [(0,0,1)|(0,0,0)]^(7)*args%PA(3)-([(0,0,1)|(0,0,0)]^(8)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(7)-([(0,0,0)|(0,0,0)]^(8))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(1)-([(0,0,0)|(0,0,0)]^(7)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(2)-([(0,0,0)|(0,0,0)]^(7)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(3)-([(0,0,0)|(0,0,0)]^(7)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(6) = [(1,0,0)|(0,0,0)]^(6)*args%PA(1)-([(1,0,0)|(0,0,0)]^(7)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(1)-([(0,1,0)|(0,0,0)]^(7)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(1)-([(0,0,1)|(0,0,0)]^(7)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(2)-([(0,1,0)|(0,0,0)]^(7)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(2)-([(0,0,1)|(0,0,0)]^(7)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(3)-([(0,0,1)|(0,0,0)]^(7)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(6) = [(2,0,0)|(0,0,0)]^(6)*args%PA(1)-([(2,0,0)|(0,0,0)]^(7)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(6)-([(1,0,0)|(0,0,0)]^(7))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(6) = [(2,0,0)|(0,0,0)]^(6)*args%PA(2)-([(2,0,0)|(0,0,0)]^(7)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(6) = [(2,0,0)|(0,0,0)]^(6)*args%PA(3)-([(2,0,0)|(0,0,0)]^(7)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(6) = [(0,2,0)|(0,0,0)]^(6)*args%PA(1)-([(0,2,0)|(0,0,0)]^(7)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(6) = [(0,1,1)|(0,0,0)]^(6)*args%PA(1)-([(0,1,1)|(0,0,0)]^(7)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(6) = [(0,0,2)|(0,0,0)]^(6)*args%PA(1)-([(0,0,2)|(0,0,0)]^(7)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(6) = [(0,2,0)|(0,0,0)]^(6)*args%PA(2)-([(0,2,0)|(0,0,0)]^(7)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(6)-([(0,1,0)|(0,0,0)]^(7))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(6) = [(0,2,0)|(0,0,0)]^(6)*args%PA(3)-([(0,2,0)|(0,0,0)]^(7)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(6) = [(0,0,2)|(0,0,0)]^(6)*args%PA(2)-([(0,0,2)|(0,0,0)]^(7)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(6) = [(0,0,2)|(0,0,0)]^(6)*args%PA(3)-([(0,0,2)|(0,0,0)]^(7)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(6)-([(0,0,1)|(0,0,0)]^(7))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(5) = [(1,0,0)|(0,0,0)]^(5)*args%PA(1)-([(1,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(1)-([(0,1,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(1)-([(0,0,1)|(0,0,0)]^(6)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(2)-([(0,1,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(2)-([(0,0,1)|(0,0,0)]^(6)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(3)-([(0,0,1)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(1)-([(2,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(5)-([(1,0,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(2)-([(2,0,0)|(0,0,0)]^(6)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(3)-([(2,0,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(1)-([(0,2,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(5) = [(0,1,1)|(0,0,0)]^(5)*args%PA(1)-([(0,1,1)|(0,0,0)]^(6)*args%PC(1)
        ! theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(1)-([(0,0,2)|(0,0,0)]^(6)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(2)-([(0,2,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(5)-([(0,1,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(3)-([(0,2,0)|(0,0,0)]^(6)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(2)-([(0,0,2)|(0,0,0)]^(6)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(3)-([(0,0,2)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(5)-([(0,0,1)|(0,0,0)]^(6))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(5) = [(3,0,0)|(0,0,0)]^(5)*args%PA(1)-([(3,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(5)-([(2,0,0)|(0,0,0)]^(6))/3/(2p)
        ! theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(5) = [(3,0,0)|(0,0,0)]^(5)*args%PA(2)-([(3,0,0)|(0,0,0)]^(6)*args%PC(2)
        ! theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(5) = [(3,0,0)|(0,0,0)]^(5)*args%PA(3)-([(3,0,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(5) = [(1,2,0)|(0,0,0)]^(5)*args%PA(1)-([(1,2,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(5)-([(0,2,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(5) = [(2,0,1)|(0,0,0)]^(5)*args%PA(2)-([(2,0,1)|(0,0,0)]^(6)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(5) = [(1,0,2)|(0,0,0)]^(5)*args%PA(1)-([(1,0,2)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(5)-([(0,0,2)|(0,0,0)]^(6))/1/(2p)
        ! theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(5) = [(0,3,0)|(0,0,0)]^(5)*args%PA(1)-([(0,3,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(5) = [(0,2,1)|(0,0,0)]^(5)*args%PA(1)-([(0,2,1)|(0,0,0)]^(6)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(5) = [(0,1,2)|(0,0,0)]^(5)*args%PA(1)-([(0,1,2)|(0,0,0)]^(6)*args%PC(1)
        ! theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(5) = [(0,0,3)|(0,0,0)]^(5)*args%PA(1)-([(0,0,3)|(0,0,0)]^(6)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(5) = [(0,3,0)|(0,0,0)]^(5)*args%PA(2)-([(0,3,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(5)-([(0,2,0)|(0,0,0)]^(6))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(5) = [(0,3,0)|(0,0,0)]^(5)*args%PA(3)-([(0,3,0)|(0,0,0)]^(6)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(5) = [(0,1,2)|(0,0,0)]^(5)*args%PA(2)-([(0,1,2)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(5)-([(0,0,2)|(0,0,0)]^(6))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(5) = [(0,0,3)|(0,0,0)]^(5)*args%PA(2)-([(0,0,3)|(0,0,0)]^(6)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(5) = [(0,0,3)|(0,0,0)]^(5)*args%PA(3)-([(0,0,3)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(5)-([(0,0,2)|(0,0,0)]^(6))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(1)-([(2,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(4)-([(1,0,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(2)-([(2,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(3)-([(2,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(1)-([(0,2,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(4) = [(0,1,1)|(0,0,0)]^(4)*args%PA(1)-([(0,1,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(1)-([(0,0,2)|(0,0,0)]^(5)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(2)-([(0,2,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(4)-([(0,1,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(3)-([(0,2,0)|(0,0,0)]^(5)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(2)-([(0,0,2)|(0,0,0)]^(5)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(3)-([(0,0,2)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(4)-([(0,0,1)|(0,0,0)]^(5))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(1)-([(3,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(4)-([(2,0,0)|(0,0,0)]^(5))/3/(2p)
        ! theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(2)-([(3,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(3)-([(3,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+(theta(78)-theta(43))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(4) = [(1,2,0)|(0,0,0)]^(4)*args%PA(1)-([(1,2,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(4) = [(2,0,1)|(0,0,0)]^(4)*args%PA(2)-([(2,0,1)|(0,0,0)]^(5)*args%PC(2)
        ! theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+(theta(80)-theta(45))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(4) = [(1,0,2)|(0,0,0)]^(4)*args%PA(1)-([(1,0,2)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        ! theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(1)-([(0,3,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(4) = [(0,2,1)|(0,0,0)]^(4)*args%PA(1)-([(0,2,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(1)-([(0,1,2)|(0,0,0)]^(5)*args%PC(1)
        ! theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(1)-([(0,0,3)|(0,0,0)]^(5)*args%PC(1)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(2)-([(0,3,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(3)-([(0,3,0)|(0,0,0)]^(5)*args%PC(3)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(2)-([(0,1,2)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(2)-([(0,0,3)|(0,0,0)]^(5)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(3)-([(0,0,3)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(4) = [(4,0,0)|(0,0,0)]^(4)*args%PA(1)-([(4,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(4)-([(3,0,0)|(0,0,0)]^(5))/4/(2p)
        ! theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(4) = [(4,0,0)|(0,0,0)]^(4)*args%PA(2)-([(4,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(4) = [(4,0,0)|(0,0,0)]^(4)*args%PA(3)-([(4,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(4) = [(3,1,0)|(0,0,0)]^(4)*args%PA(2)-([(3,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(4)-([(3,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(4) = [(3,0,1)|(0,0,0)]^(4)*args%PA(2)-([(3,0,1)|(0,0,0)]^(5)*args%PC(2)
        ! theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(4) = [(3,0,1)|(0,0,0)]^(4)*args%PA(3)-([(3,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(4)-([(3,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+(theta(87)-theta(52))*args%rec_p2*1 ! [(2,3,0)|(0,0,0)]^(4) = [(1,3,0)|(0,0,0)]^(4)*args%PA(1)-([(1,3,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(4)-([(0,3,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(4) = [(2,2,0)|(0,0,0)]^(4)*args%PA(3)-([(2,2,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(4) = [(2,0,2)|(0,0,0)]^(4)*args%PA(2)-([(2,0,2)|(0,0,0)]^(5)*args%PC(2)
        ! theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+(theta(90)-theta(55))*args%rec_p2*1 ! [(2,0,3)|(0,0,0)]^(4) = [(1,0,3)|(0,0,0)]^(4)*args%PA(1)-([(1,0,3)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(4)-([(0,0,3)|(0,0,0)]^(5))/1/(2p)
        theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(4) = [(0,4,0)|(0,0,0)]^(4)*args%PA(1)-([(0,4,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(4) = [(0,3,1)|(0,0,0)]^(4)*args%PA(1)-([(0,3,1)|(0,0,0)]^(5)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(4) = [(0,2,2)|(0,0,0)]^(4)*args%PA(1)-([(0,2,2)|(0,0,0)]^(5)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(4) = [(0,1,3)|(0,0,0)]^(4)*args%PA(1)-([(0,1,3)|(0,0,0)]^(5)*args%PC(1)
        theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(4) = [(0,0,4)|(0,0,0)]^(4)*args%PA(1)-([(0,0,4)|(0,0,0)]^(5)*args%PC(1)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(4) = [(0,4,0)|(0,0,0)]^(4)*args%PA(2)-([(0,4,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(4)-([(0,3,0)|(0,0,0)]^(5))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(4) = [(0,4,0)|(0,0,0)]^(4)*args%PA(3)-([(0,4,0)|(0,0,0)]^(5)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(4) = [(0,3,1)|(0,0,0)]^(4)*args%PA(3)-([(0,3,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(4)-([(0,3,0)|(0,0,0)]^(5))/1/(2p)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(4) = [(0,1,3)|(0,0,0)]^(4)*args%PA(2)-([(0,1,3)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(4)-([(0,0,3)|(0,0,0)]^(5))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(4) = [(0,0,4)|(0,0,0)]^(4)*args%PA(2)-([(0,0,4)|(0,0,0)]^(5)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(4) = [(0,0,4)|(0,0,0)]^(4)*args%PA(3)-([(0,0,4)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(4)-([(0,0,3)|(0,0,0)]^(5))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(1)-([(3,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(3)-([(2,0,0)|(0,0,0)]^(4))/3/(2p)
        ! theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(2)-([(3,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(3)-([(3,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+(theta(134)-theta(78))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(3) = [(1,2,0)|(0,0,0)]^(3)*args%PA(1)-([(1,2,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(3) = [(2,0,1)|(0,0,0)]^(3)*args%PA(2)-([(2,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+(theta(136)-theta(80))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(3) = [(1,0,2)|(0,0,0)]^(3)*args%PA(1)-([(1,0,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(1)-([(0,3,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(3) = [(0,2,1)|(0,0,0)]^(3)*args%PA(1)-([(0,2,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(1)-([(0,1,2)|(0,0,0)]^(4)*args%PC(1)
        theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(1)-([(0,0,3)|(0,0,0)]^(4)*args%PC(1)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(2)-([(0,3,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(3)-([(0,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(2)-([(0,1,2)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(2)-([(0,0,3)|(0,0,0)]^(4)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(3)-([(0,0,3)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(1)-([(4,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/4/(2p)
        theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(2)-([(4,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(3)-([(4,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(3) = [(3,1,0)|(0,0,0)]^(3)*args%PA(2)-([(3,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(2)-([(3,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(3)-([(3,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+(theta(143)-theta(87))*args%rec_p2*1 ! [(2,3,0)|(0,0,0)]^(3) = [(1,3,0)|(0,0,0)]^(3)*args%PA(1)-([(1,3,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(3) = [(2,2,0)|(0,0,0)]^(3)*args%PA(3)-([(2,2,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(3) = [(2,0,2)|(0,0,0)]^(3)*args%PA(2)-([(2,0,2)|(0,0,0)]^(4)*args%PC(2)
        ! theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+(theta(146)-theta(90))*args%rec_p2*1 ! [(2,0,3)|(0,0,0)]^(3) = [(1,0,3)|(0,0,0)]^(3)*args%PA(1)-([(1,0,3)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(1)-([(0,4,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(1)-([(0,3,1)|(0,0,0)]^(4)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(3) = [(0,2,2)|(0,0,0)]^(3)*args%PA(1)-([(0,2,2)|(0,0,0)]^(4)*args%PC(1)
        ! theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(1)-([(0,1,3)|(0,0,0)]^(4)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(1)-([(0,0,4)|(0,0,0)]^(4)*args%PC(1)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(2)-([(0,4,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(3)-([(0,4,0)|(0,0,0)]^(4)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(3)-([(0,3,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(2)-([(0,1,3)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(2)-([(0,0,4)|(0,0,0)]^(4)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(3)-([(0,0,4)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(3) = [(5,0,0)|(0,0,0)]^(3)*args%PA(1)-([(5,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(3)-([(4,0,0)|(0,0,0)]^(4))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(3) = [(5,0,0)|(0,0,0)]^(3)*args%PA(2)-([(5,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(3) = [(5,0,0)|(0,0,0)]^(3)*args%PA(3)-([(5,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+(theta(147)-theta(91))*args%rec_p2*1 ! [(4,2,0)|(0,0,0)]^(3) = [(4,1,0)|(0,0,0)]^(3)*args%PA(2)-([(4,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(3)-([(4,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(3) = [(4,0,1)|(0,0,0)]^(3)*args%PA(2)-([(4,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+(theta(147)-theta(91))*args%rec_p2*1 ! [(4,0,2)|(0,0,0)]^(3) = [(4,0,1)|(0,0,0)]^(3)*args%PA(3)-([(4,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(3)-([(4,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+(theta(153)-theta(97))*args%rec_p2*2 ! [(3,3,0)|(0,0,0)]^(3) = [(2,3,0)|(0,0,0)]^(3)*args%PA(1)-([(2,3,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(3)-([(1,3,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(3) = [(3,2,0)|(0,0,0)]^(3)*args%PA(3)-([(3,2,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(3) = [(3,0,2)|(0,0,0)]^(3)*args%PA(2)-([(3,0,2)|(0,0,0)]^(4)*args%PC(2)
        ! theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+(theta(156)-theta(100))*args%rec_p2*2 ! [(3,0,3)|(0,0,0)]^(3) = [(2,0,3)|(0,0,0)]^(3)*args%PA(1)-([(2,0,3)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(3)-([(1,0,3)|(0,0,0)]^(4))/2/(2p)
        t(34) = (theta(157)-theta(101))*args%rec_p2
        theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+t(34)*1 ! [(2,4,0)|(0,0,0)]^(3) = [(1,4,0)|(0,0,0)]^(3)*args%PA(1)-([(1,4,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(3)-([(0,4,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(3) = [(2,3,0)|(0,0,0)]^(3)*args%PA(3)-([(2,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(35) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(35)*1 ! [(2,2,2)|(0,0,0)]^(3) = [(1,2,2)|(0,0,0)]^(3)*args%PA(1)-([(1,2,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(3)-([(0,2,2)|(0,0,0)]^(4))/1/(2p)
        ! theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(3) = [(2,0,3)|(0,0,0)]^(3)*args%PA(2)-([(2,0,3)|(0,0,0)]^(4)*args%PC(2)
        t(36) = (theta(161)-theta(105))*args%rec_p2
        theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+t(36)*1 ! [(2,0,4)|(0,0,0)]^(3) = [(1,0,4)|(0,0,0)]^(3)*args%PA(1)-([(1,0,4)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(3)-([(0,0,4)|(0,0,0)]^(4))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(3) = [(0,5,0)|(0,0,0)]^(3)*args%PA(1)-([(0,5,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(3) = [(0,4,1)|(0,0,0)]^(3)*args%PA(1)-([(0,4,1)|(0,0,0)]^(4)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(3) = [(0,3,2)|(0,0,0)]^(3)*args%PA(1)-([(0,3,2)|(0,0,0)]^(4)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(3) = [(0,2,3)|(0,0,0)]^(3)*args%PA(1)-([(0,2,3)|(0,0,0)]^(4)*args%PC(1)
        ! theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(3) = [(0,1,4)|(0,0,0)]^(3)*args%PA(1)-([(0,1,4)|(0,0,0)]^(4)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(3) = [(0,0,5)|(0,0,0)]^(3)*args%PA(1)-([(0,0,5)|(0,0,0)]^(4)*args%PC(1)
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(34)*5 ! [(0,6,0)|(0,0,0)]^(3) = [(0,5,0)|(0,0,0)]^(3)*args%PA(2)-([(0,5,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(3)-([(0,4,0)|(0,0,0)]^(4))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(3) = [(0,5,0)|(0,0,0)]^(3)*args%PA(3)-([(0,5,0)|(0,0,0)]^(4)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(34)*1 ! [(0,4,2)|(0,0,0)]^(3) = [(0,4,1)|(0,0,0)]^(3)*args%PA(3)-([(0,4,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(3)-([(0,4,0)|(0,0,0)]^(4))/1/(2p)
        t(37) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(37)*2 ! [(0,3,3)|(0,0,0)]^(3) = [(0,2,3)|(0,0,0)]^(3)*args%PA(2)-([(0,2,3)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(3)-([(0,1,3)|(0,0,0)]^(4))/2/(2p)
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(36)*1 ! [(0,2,4)|(0,0,0)]^(3) = [(0,1,4)|(0,0,0)]^(3)*args%PA(2)-([(0,1,4)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(3)-([(0,0,4)|(0,0,0)]^(4))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(3) = [(0,0,5)|(0,0,0)]^(3)*args%PA(2)-([(0,0,5)|(0,0,0)]^(4)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(36)*5 ! [(0,0,6)|(0,0,0)]^(3) = [(0,0,5)|(0,0,0)]^(3)*args%PA(3)-([(0,0,5)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(3)-([(0,0,4)|(0,0,0)]^(4))/5/(2p)
        theta(212) = theta(211)*args%PA(1)-theta(127)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(213) = theta(211)*args%PA(2)-theta(127)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(214) = theta(211)*args%PA(3)-theta(127)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(38) = (theta(211)-theta(127))*args%rec_p2
        theta(215) = theta(212)*args%PA(1)-theta(128)*args%PC(1)+t(38)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(216) = theta(213)*args%PA(1)-theta(129)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(217) = theta(214)*args%PA(1)-theta(130)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(218) = theta(213)*args%PA(2)-theta(129)*args%PC(2)+t(38)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(219) = theta(214)*args%PA(2)-theta(130)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(220) = theta(214)*args%PA(3)-theta(130)*args%PC(3)+t(38)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(39) = (theta(212)-theta(128))*args%rec_p2
        theta(221) = theta(215)*args%PA(1)-theta(131)*args%PC(1)+t(39)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(222) = theta(215)*args%PA(2)-theta(131)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(223) = theta(215)*args%PA(3)-theta(131)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(224) = theta(218)*args%PA(1)-theta(134)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(225) = theta(219)*args%PA(1)-theta(135)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(226) = theta(220)*args%PA(1)-theta(136)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(40) = (theta(213)-theta(129))*args%rec_p2
        theta(227) = theta(218)*args%PA(2)-theta(134)*args%PC(2)+t(40)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(228) = theta(218)*args%PA(3)-theta(134)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(229) = theta(220)*args%PA(2)-theta(136)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(41) = (theta(214)-theta(130))*args%rec_p2
        theta(230) = theta(220)*args%PA(3)-theta(136)*args%PC(3)+t(41)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(42) = (theta(215)-theta(131))*args%rec_p2
        theta(231) = theta(221)*args%PA(1)-theta(137)*args%PC(1)+t(42)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(232) = theta(221)*args%PA(2)-theta(137)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(233) = theta(221)*args%PA(3)-theta(137)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(234) = theta(224)*args%PA(1)-theta(140)*args%PC(1)+(theta(218)-theta(134))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(235) = theta(223)*args%PA(2)-theta(139)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(236) = theta(226)*args%PA(1)-theta(142)*args%PC(1)+(theta(220)-theta(136))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(237) = theta(227)*args%PA(1)-theta(143)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(238) = theta(228)*args%PA(1)-theta(144)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(239) = theta(229)*args%PA(1)-theta(145)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(240) = theta(230)*args%PA(1)-theta(146)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(43) = (theta(218)-theta(134))*args%rec_p2
        theta(241) = theta(227)*args%PA(2)-theta(143)*args%PC(2)+t(43)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(242) = theta(227)*args%PA(3)-theta(143)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(44) = (theta(220)-theta(136))*args%rec_p2
        theta(243) = theta(229)*args%PA(2)-theta(145)*args%PC(2)+t(44)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(244) = theta(230)*args%PA(2)-theta(146)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(245) = theta(230)*args%PA(3)-theta(146)*args%PC(3)+t(44)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        t(45) = (theta(221)-theta(137))*args%rec_p2
        theta(246) = theta(231)*args%PA(1)-theta(147)*args%PC(1)+t(45)*4 ! [(5,0,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(1)-([(4,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/4/(2p)
        theta(247) = theta(231)*args%PA(2)-theta(147)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(2)-([(4,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(248) = theta(231)*args%PA(3)-theta(147)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(3)-([(4,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(249) = theta(232)*args%PA(2)-theta(148)*args%PC(2)+(theta(221)-theta(137))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(2) = [(3,1,0)|(0,0,0)]^(2)*args%PA(2)-([(3,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(250) = theta(233)*args%PA(2)-theta(149)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(2)-([(3,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(251) = theta(233)*args%PA(3)-theta(149)*args%PC(3)+(theta(221)-theta(137))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(3)-([(3,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        t(46) = (theta(227)-theta(143))*args%rec_p2
        theta(252) = theta(237)*args%PA(1)-theta(153)*args%PC(1)+t(46)*1 ! [(2,3,0)|(0,0,0)]^(2) = [(1,3,0)|(0,0,0)]^(2)*args%PA(1)-([(1,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(253) = theta(234)*args%PA(3)-theta(150)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(2) = [(2,2,0)|(0,0,0)]^(2)*args%PA(3)-([(2,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(254) = theta(236)*args%PA(2)-theta(152)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(2) = [(2,0,2)|(0,0,0)]^(2)*args%PA(2)-([(2,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(47) = (theta(230)-theta(146))*args%rec_p2
        theta(255) = theta(240)*args%PA(1)-theta(156)*args%PC(1)+t(47)*1 ! [(2,0,3)|(0,0,0)]^(2) = [(1,0,3)|(0,0,0)]^(2)*args%PA(1)-([(1,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(256) = theta(241)*args%PA(1)-theta(157)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(1)-([(0,4,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(257) = theta(242)*args%PA(1)-theta(158)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(1)-([(0,3,1)|(0,0,0)]^(3)*args%PC(1)
        theta(258) = theta(243)*args%PA(1)-theta(159)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(2) = [(0,2,2)|(0,0,0)]^(2)*args%PA(1)-([(0,2,2)|(0,0,0)]^(3)*args%PC(1)
        ! theta(259) = theta(244)*args%PA(1)-theta(160)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(1)-([(0,1,3)|(0,0,0)]^(3)*args%PC(1)
        theta(260) = theta(245)*args%PA(1)-theta(161)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(1)-([(0,0,4)|(0,0,0)]^(3)*args%PC(1)
        theta(261) = theta(241)*args%PA(2)-theta(157)*args%PC(2)+t(46)*4 ! [(0,5,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(2)-([(0,4,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/4/(2p)
        theta(262) = theta(241)*args%PA(3)-theta(157)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(3)-([(0,4,0)|(0,0,0)]^(3)*args%PC(3)
        theta(263) = theta(242)*args%PA(3)-theta(158)*args%PC(3)+t(46)*1 ! [(0,3,2)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(3)-([(0,3,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        theta(264) = theta(244)*args%PA(2)-theta(160)*args%PC(2)+t(47)*1 ! [(0,2,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(2)-([(0,1,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(265) = theta(245)*args%PA(2)-theta(161)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(2)-([(0,0,4)|(0,0,0)]^(3)*args%PC(2)
        theta(266) = theta(245)*args%PA(3)-theta(161)*args%PC(3)+t(47)*4 ! [(0,0,5)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(3)-([(0,0,4)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/4/(2p)
        t(48) = (theta(231)-theta(147))*args%rec_p2
        theta(267) = theta(246)*args%PA(1)-theta(162)*args%PC(1)+t(48)*5 ! [(6,0,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(1)-([(5,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/5/(2p)
        theta(268) = theta(246)*args%PA(2)-theta(162)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(2)-([(5,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(269) = theta(246)*args%PA(3)-theta(162)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(3)-([(5,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(270) = theta(247)*args%PA(2)-theta(163)*args%PC(2)+t(48)*1 ! [(4,2,0)|(0,0,0)]^(2) = [(4,1,0)|(0,0,0)]^(2)*args%PA(2)-([(4,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(271) = theta(248)*args%PA(2)-theta(164)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(2)-([(4,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(272) = theta(248)*args%PA(3)-theta(164)*args%PC(3)+t(48)*1 ! [(4,0,2)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(3)-([(4,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(273) = theta(252)*args%PA(1)-theta(168)*args%PC(1)+(theta(237)-theta(153))*args%rec_p2*2 ! [(3,3,0)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(1)-([(2,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(2)-([(1,3,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(274) = theta(249)*args%PA(3)-theta(165)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(2) = [(3,2,0)|(0,0,0)]^(2)*args%PA(3)-([(3,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(275) = theta(251)*args%PA(2)-theta(167)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(2) = [(3,0,2)|(0,0,0)]^(2)*args%PA(2)-([(3,0,2)|(0,0,0)]^(3)*args%PC(2)
        ! theta(276) = theta(255)*args%PA(1)-theta(171)*args%PC(1)+(theta(240)-theta(156))*args%rec_p2*2 ! [(3,0,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(1)-([(2,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(2)-([(1,0,3)|(0,0,0)]^(3))/2/(2p)
        t(49) = (theta(241)-theta(157))*args%rec_p2
        theta(277) = theta(256)*args%PA(1)-theta(172)*args%PC(1)+t(49)*1 ! [(2,4,0)|(0,0,0)]^(2) = [(1,4,0)|(0,0,0)]^(2)*args%PA(1)-([(1,4,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(278) = theta(252)*args%PA(3)-theta(168)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(3)-([(2,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(50) = (theta(243)-theta(159))*args%rec_p2
        theta(279) = theta(258)*args%PA(1)-theta(174)*args%PC(1)+t(50)*1 ! [(2,2,2)|(0,0,0)]^(2) = [(1,2,2)|(0,0,0)]^(2)*args%PA(1)-([(1,2,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(2)-([(0,2,2)|(0,0,0)]^(3))/1/(2p)
        ! theta(280) = theta(255)*args%PA(2)-theta(171)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(2)-([(2,0,3)|(0,0,0)]^(3)*args%PC(2)
        t(51) = (theta(245)-theta(161))*args%rec_p2
        theta(281) = theta(260)*args%PA(1)-theta(176)*args%PC(1)+t(51)*1 ! [(2,0,4)|(0,0,0)]^(2) = [(1,0,4)|(0,0,0)]^(2)*args%PA(1)-([(1,0,4)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(282) = theta(261)*args%PA(1)-theta(177)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(1)-([(0,5,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(283) = theta(262)*args%PA(1)-theta(178)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(1)-([(0,4,1)|(0,0,0)]^(3)*args%PC(1)
        theta(284) = theta(263)*args%PA(1)-theta(179)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(2) = [(0,3,2)|(0,0,0)]^(2)*args%PA(1)-([(0,3,2)|(0,0,0)]^(3)*args%PC(1)
        theta(285) = theta(264)*args%PA(1)-theta(180)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(1)-([(0,2,3)|(0,0,0)]^(3)*args%PC(1)
        ! theta(286) = theta(265)*args%PA(1)-theta(181)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(1)-([(0,1,4)|(0,0,0)]^(3)*args%PC(1)
        theta(287) = theta(266)*args%PA(1)-theta(182)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(1)-([(0,0,5)|(0,0,0)]^(3)*args%PC(1)
        theta(288) = theta(261)*args%PA(2)-theta(177)*args%PC(2)+t(49)*5 ! [(0,6,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(2)-([(0,5,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/5/(2p)
        theta(289) = theta(261)*args%PA(3)-theta(177)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(3)-([(0,5,0)|(0,0,0)]^(3)*args%PC(3)
        theta(290) = theta(262)*args%PA(3)-theta(178)*args%PC(3)+t(49)*1 ! [(0,4,2)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(3)-([(0,4,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        t(52) = (theta(244)-theta(160))*args%rec_p2
        theta(291) = theta(264)*args%PA(2)-theta(180)*args%PC(2)+t(52)*2 ! [(0,3,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(2)-([(0,2,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(2)-([(0,1,3)|(0,0,0)]^(3))/2/(2p)
        theta(292) = theta(265)*args%PA(2)-theta(181)*args%PC(2)+t(51)*1 ! [(0,2,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(2)-([(0,1,4)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(293) = theta(266)*args%PA(2)-theta(182)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(2)-([(0,0,5)|(0,0,0)]^(3)*args%PC(2)
        theta(294) = theta(266)*args%PA(3)-theta(182)*args%PC(3)+t(51)*5 ! [(0,0,6)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(3)-([(0,0,5)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/5/(2p)
        t(53) = (theta(246)-theta(162))*args%rec_p2
        theta(295) = theta(267)*args%PA(1)-theta(183)*args%PC(1)+t(53)*6 ! [(7,0,0)|(0,0,0)]^(2) = [(6,0,0)|(0,0,0)]^(2)*args%PA(1)-([(6,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(2)-([(5,0,0)|(0,0,0)]^(3))/6/(2p)
        theta(296) = theta(267)*args%PA(2)-theta(183)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(2) = [(6,0,0)|(0,0,0)]^(2)*args%PA(2)-([(6,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(297) = theta(267)*args%PA(3)-theta(183)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(2) = [(6,0,0)|(0,0,0)]^(2)*args%PA(3)-([(6,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(298) = theta(268)*args%PA(2)-theta(184)*args%PC(2)+t(53)*1 ! [(5,2,0)|(0,0,0)]^(2) = [(5,1,0)|(0,0,0)]^(2)*args%PA(2)-([(5,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(2)-([(5,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(299) = theta(269)*args%PA(2)-theta(185)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(2) = [(5,0,1)|(0,0,0)]^(2)*args%PA(2)-([(5,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(300) = theta(269)*args%PA(3)-theta(185)*args%PC(3)+t(53)*1 ! [(5,0,2)|(0,0,0)]^(2) = [(5,0,1)|(0,0,0)]^(2)*args%PA(3)-([(5,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(2)-([(5,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(301) = theta(270)*args%PA(2)-theta(186)*args%PC(2)+(theta(247)-theta(163))*args%rec_p2*2 ! [(4,3,0)|(0,0,0)]^(2) = [(4,2,0)|(0,0,0)]^(2)*args%PA(2)-([(4,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(2)-([(4,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(302) = theta(270)*args%PA(3)-theta(186)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(2) = [(4,2,0)|(0,0,0)]^(2)*args%PA(3)-([(4,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(303) = theta(272)*args%PA(2)-theta(188)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(2) = [(4,0,2)|(0,0,0)]^(2)*args%PA(2)-([(4,0,2)|(0,0,0)]^(3)*args%PC(2)
        ! theta(304) = theta(272)*args%PA(3)-theta(188)*args%PC(3)+(theta(248)-theta(164))*args%rec_p2*2 ! [(4,0,3)|(0,0,0)]^(2) = [(4,0,2)|(0,0,0)]^(2)*args%PA(3)-([(4,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(2)-([(4,0,1)|(0,0,0)]^(3))/2/(2p)
        t(54) = (theta(256)-theta(172))*args%rec_p2
        theta(305) = theta(277)*args%PA(1)-theta(193)*args%PC(1)+t(54)*2 ! [(3,4,0)|(0,0,0)]^(2) = [(2,4,0)|(0,0,0)]^(2)*args%PA(1)-([(2,4,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(2)-([(1,4,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(306) = theta(273)*args%PA(3)-theta(189)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(2) = [(3,3,0)|(0,0,0)]^(2)*args%PA(3)-([(3,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(55) = (theta(258)-theta(174))*args%rec_p2
        theta(307) = theta(279)*args%PA(1)-theta(195)*args%PC(1)+t(55)*2 ! [(3,2,2)|(0,0,0)]^(2) = [(2,2,2)|(0,0,0)]^(2)*args%PA(1)-([(2,2,2)|(0,0,0)]^(3)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(2)-([(1,2,2)|(0,0,0)]^(3))/2/(2p)
        ! theta(308) = theta(276)*args%PA(2)-theta(192)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(2) = [(3,0,3)|(0,0,0)]^(2)*args%PA(2)-([(3,0,3)|(0,0,0)]^(3)*args%PC(2)
        t(56) = (theta(260)-theta(176))*args%rec_p2
        theta(309) = theta(281)*args%PA(1)-theta(197)*args%PC(1)+t(56)*2 ! [(3,0,4)|(0,0,0)]^(2) = [(2,0,4)|(0,0,0)]^(2)*args%PA(1)-([(2,0,4)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(2)-([(1,0,4)|(0,0,0)]^(3))/2/(2p)
        t(57) = (theta(261)-theta(177))*args%rec_p2
        theta(310) = theta(282)*args%PA(1)-theta(198)*args%PC(1)+t(57)*1 ! [(2,5,0)|(0,0,0)]^(2) = [(1,5,0)|(0,0,0)]^(2)*args%PA(1)-([(1,5,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(2)-([(0,5,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(311) = theta(277)*args%PA(3)-theta(193)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(2) = [(2,4,0)|(0,0,0)]^(2)*args%PA(3)-([(2,4,0)|(0,0,0)]^(3)*args%PC(3)
        t(58) = (theta(263)-theta(179))*args%rec_p2
        theta(312) = theta(284)*args%PA(1)-theta(200)*args%PC(1)+t(58)*1 ! [(2,3,2)|(0,0,0)]^(2) = [(1,3,2)|(0,0,0)]^(2)*args%PA(1)-([(1,3,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(2)-([(0,3,2)|(0,0,0)]^(3))/1/(2p)
        t(59) = (theta(264)-theta(180))*args%rec_p2
        theta(313) = theta(285)*args%PA(1)-theta(201)*args%PC(1)+t(59)*1 ! [(2,2,3)|(0,0,0)]^(2) = [(1,2,3)|(0,0,0)]^(2)*args%PA(1)-([(1,2,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(2)-([(0,2,3)|(0,0,0)]^(3))/1/(2p)
        ! theta(314) = theta(281)*args%PA(2)-theta(197)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(2) = [(2,0,4)|(0,0,0)]^(2)*args%PA(2)-([(2,0,4)|(0,0,0)]^(3)*args%PC(2)
        t(60) = (theta(266)-theta(182))*args%rec_p2
        theta(315) = theta(287)*args%PA(1)-theta(203)*args%PC(1)+t(60)*1 ! [(2,0,5)|(0,0,0)]^(2) = [(1,0,5)|(0,0,0)]^(2)*args%PA(1)-([(1,0,5)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(2)-([(0,0,5)|(0,0,0)]^(3))/1/(2p)
        theta(316) = theta(288)*args%PA(1)-theta(204)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(2) = [(0,6,0)|(0,0,0)]^(2)*args%PA(1)-([(0,6,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(317) = theta(289)*args%PA(1)-theta(205)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(2) = [(0,5,1)|(0,0,0)]^(2)*args%PA(1)-([(0,5,1)|(0,0,0)]^(3)*args%PC(1)
        theta(318) = theta(290)*args%PA(1)-theta(206)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(2) = [(0,4,2)|(0,0,0)]^(2)*args%PA(1)-([(0,4,2)|(0,0,0)]^(3)*args%PC(1)
        theta(319) = theta(291)*args%PA(1)-theta(207)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(2) = [(0,3,3)|(0,0,0)]^(2)*args%PA(1)-([(0,3,3)|(0,0,0)]^(3)*args%PC(1)
        theta(320) = theta(292)*args%PA(1)-theta(208)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(2) = [(0,2,4)|(0,0,0)]^(2)*args%PA(1)-([(0,2,4)|(0,0,0)]^(3)*args%PC(1)
        ! theta(321) = theta(293)*args%PA(1)-theta(209)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(2) = [(0,1,5)|(0,0,0)]^(2)*args%PA(1)-([(0,1,5)|(0,0,0)]^(3)*args%PC(1)
        theta(322) = theta(294)*args%PA(1)-theta(210)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(2) = [(0,0,6)|(0,0,0)]^(2)*args%PA(1)-([(0,0,6)|(0,0,0)]^(3)*args%PC(1)
        theta(323) = theta(288)*args%PA(2)-theta(204)*args%PC(2)+t(57)*6 ! [(0,7,0)|(0,0,0)]^(2) = [(0,6,0)|(0,0,0)]^(2)*args%PA(2)-([(0,6,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(2)-([(0,5,0)|(0,0,0)]^(3))/6/(2p)
        theta(324) = theta(288)*args%PA(3)-theta(204)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(2) = [(0,6,0)|(0,0,0)]^(2)*args%PA(3)-([(0,6,0)|(0,0,0)]^(3)*args%PC(3)
        theta(325) = theta(289)*args%PA(3)-theta(205)*args%PC(3)+t(57)*1 ! [(0,5,2)|(0,0,0)]^(2) = [(0,5,1)|(0,0,0)]^(2)*args%PA(3)-([(0,5,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(2)-([(0,5,0)|(0,0,0)]^(3))/1/(2p)
        t(61) = (theta(262)-theta(178))*args%rec_p2
        theta(326) = theta(290)*args%PA(3)-theta(206)*args%PC(3)+t(61)*2 ! [(0,4,3)|(0,0,0)]^(2) = [(0,4,2)|(0,0,0)]^(2)*args%PA(3)-([(0,4,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(2)-([(0,4,1)|(0,0,0)]^(3))/2/(2p)
        t(62) = (theta(265)-theta(181))*args%rec_p2
        theta(327) = theta(292)*args%PA(2)-theta(208)*args%PC(2)+t(62)*2 ! [(0,3,4)|(0,0,0)]^(2) = [(0,2,4)|(0,0,0)]^(2)*args%PA(2)-([(0,2,4)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(2)-([(0,1,4)|(0,0,0)]^(3))/2/(2p)
        theta(328) = theta(293)*args%PA(2)-theta(209)*args%PC(2)+t(60)*1 ! [(0,2,5)|(0,0,0)]^(2) = [(0,1,5)|(0,0,0)]^(2)*args%PA(2)-([(0,1,5)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(2)-([(0,0,5)|(0,0,0)]^(3))/1/(2p)
        theta(329) = theta(294)*args%PA(2)-theta(210)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(2) = [(0,0,6)|(0,0,0)]^(2)*args%PA(2)-([(0,0,6)|(0,0,0)]^(3)*args%PC(2)
        theta(330) = theta(294)*args%PA(3)-theta(210)*args%PC(3)+t(60)*6 ! [(0,0,7)|(0,0,0)]^(2) = [(0,0,6)|(0,0,0)]^(2)*args%PA(3)-([(0,0,6)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(2)-([(0,0,5)|(0,0,0)]^(3))/6/(2p)
        theta(332) = theta(331)*args%PA(1)-theta(211)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(333) = theta(331)*args%PA(2)-theta(211)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(334) = theta(331)*args%PA(3)-theta(211)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(63) = (theta(331)-theta(211))*args%rec_p2
        theta(335) = theta(332)*args%PA(1)-theta(212)*args%PC(1)+t(63)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(336) = theta(333)*args%PA(1)-theta(213)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(337) = theta(334)*args%PA(1)-theta(214)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(338) = theta(333)*args%PA(2)-theta(213)*args%PC(2)+t(63)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(339) = theta(334)*args%PA(2)-theta(214)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(340) = theta(334)*args%PA(3)-theta(214)*args%PC(3)+t(63)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(64) = (theta(332)-theta(212))*args%rec_p2
        theta(341) = theta(335)*args%PA(1)-theta(215)*args%PC(1)+t(64)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(342) = theta(335)*args%PA(2)-theta(215)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        ! theta(343) = theta(335)*args%PA(3)-theta(215)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(344) = theta(338)*args%PA(1)-theta(218)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(345) = theta(339)*args%PA(1)-theta(219)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(346) = theta(340)*args%PA(1)-theta(220)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(65) = (theta(333)-theta(213))*args%rec_p2
        theta(347) = theta(338)*args%PA(2)-theta(218)*args%PC(2)+t(65)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(348) = theta(338)*args%PA(3)-theta(218)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(349) = theta(340)*args%PA(2)-theta(220)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(66) = (theta(334)-theta(214))*args%rec_p2
        theta(350) = theta(340)*args%PA(3)-theta(220)*args%PC(3)+t(66)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(67) = (theta(335)-theta(215))*args%rec_p2
        theta(351) = theta(341)*args%PA(1)-theta(221)*args%PC(1)+t(67)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(352) = theta(341)*args%PA(2)-theta(221)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(353) = theta(341)*args%PA(3)-theta(221)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(68) = (theta(338)-theta(218))*args%rec_p2
        theta(354) = theta(344)*args%PA(1)-theta(224)*args%PC(1)+t(68)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(355) = theta(343)*args%PA(2)-theta(223)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(69) = (theta(340)-theta(220))*args%rec_p2
        theta(356) = theta(346)*args%PA(1)-theta(226)*args%PC(1)+t(69)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(357) = theta(347)*args%PA(1)-theta(227)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(358) = theta(348)*args%PA(1)-theta(228)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(359) = theta(349)*args%PA(1)-theta(229)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(360) = theta(350)*args%PA(1)-theta(230)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(361) = theta(347)*args%PA(2)-theta(227)*args%PC(2)+t(68)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(362) = theta(347)*args%PA(3)-theta(227)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(363) = theta(349)*args%PA(2)-theta(229)*args%PC(2)+t(69)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(364) = theta(350)*args%PA(2)-theta(230)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(365) = theta(350)*args%PA(3)-theta(230)*args%PC(3)+t(69)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(70) = (theta(341)-theta(221))*args%rec_p2
        theta(366) = theta(351)*args%PA(1)-theta(231)*args%PC(1)+t(70)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(367) = theta(351)*args%PA(2)-theta(231)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(368) = theta(351)*args%PA(3)-theta(231)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(369) = theta(352)*args%PA(2)-theta(232)*args%PC(2)+t(70)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(370) = theta(353)*args%PA(2)-theta(233)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(371) = theta(353)*args%PA(3)-theta(233)*args%PC(3)+t(70)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(71) = (theta(347)-theta(227))*args%rec_p2
        theta(372) = theta(357)*args%PA(1)-theta(237)*args%PC(1)+t(71)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(373) = theta(354)*args%PA(3)-theta(234)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(374) = theta(356)*args%PA(2)-theta(236)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(72) = (theta(350)-theta(230))*args%rec_p2
        theta(375) = theta(360)*args%PA(1)-theta(240)*args%PC(1)+t(72)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(376) = theta(361)*args%PA(1)-theta(241)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(377) = theta(362)*args%PA(1)-theta(242)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(378) = theta(363)*args%PA(1)-theta(243)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(379) = theta(364)*args%PA(1)-theta(244)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(380) = theta(365)*args%PA(1)-theta(245)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(381) = theta(361)*args%PA(2)-theta(241)*args%PC(2)+t(71)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(382) = theta(361)*args%PA(3)-theta(241)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(383) = theta(362)*args%PA(3)-theta(242)*args%PC(3)+t(71)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(384) = theta(364)*args%PA(2)-theta(244)*args%PC(2)+t(72)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(385) = theta(365)*args%PA(2)-theta(245)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(386) = theta(365)*args%PA(3)-theta(245)*args%PC(3)+t(72)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        t(73) = (theta(351)-theta(231))*args%rec_p2
        theta(387) = theta(366)*args%PA(1)-theta(246)*args%PC(1)+t(73)*5 ! [(6,0,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(1)-([(5,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/5/(2p)
        theta(388) = theta(366)*args%PA(2)-theta(246)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(2)-([(5,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(389) = theta(366)*args%PA(3)-theta(246)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(3)-([(5,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(390) = theta(367)*args%PA(2)-theta(247)*args%PC(2)+t(73)*1 ! [(4,2,0)|(0,0,0)]^(1) = [(4,1,0)|(0,0,0)]^(1)*args%PA(2)-([(4,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(391) = theta(368)*args%PA(2)-theta(248)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(2)-([(4,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(392) = theta(368)*args%PA(3)-theta(248)*args%PC(3)+t(73)*1 ! [(4,0,2)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(3)-([(4,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        t(74) = (theta(357)-theta(237))*args%rec_p2
        theta(393) = theta(372)*args%PA(1)-theta(252)*args%PC(1)+t(74)*2 ! [(3,3,0)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(1)-([(2,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(1)-([(1,3,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(394) = theta(369)*args%PA(3)-theta(249)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(1) = [(3,2,0)|(0,0,0)]^(1)*args%PA(3)-([(3,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(395) = theta(371)*args%PA(2)-theta(251)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(1) = [(3,0,2)|(0,0,0)]^(1)*args%PA(2)-([(3,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(75) = (theta(360)-theta(240))*args%rec_p2
        theta(396) = theta(375)*args%PA(1)-theta(255)*args%PC(1)+t(75)*2 ! [(3,0,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(1)-([(2,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(1)-([(1,0,3)|(0,0,0)]^(2))/2/(2p)
        t(76) = (theta(361)-theta(241))*args%rec_p2
        theta(397) = theta(376)*args%PA(1)-theta(256)*args%PC(1)+t(76)*1 ! [(2,4,0)|(0,0,0)]^(1) = [(1,4,0)|(0,0,0)]^(1)*args%PA(1)-([(1,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(398) = theta(372)*args%PA(3)-theta(252)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(3)-([(2,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(77) = (theta(363)-theta(243))*args%rec_p2
        theta(399) = theta(378)*args%PA(1)-theta(258)*args%PC(1)+t(77)*1 ! [(2,2,2)|(0,0,0)]^(1) = [(1,2,2)|(0,0,0)]^(1)*args%PA(1)-([(1,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(1)-([(0,2,2)|(0,0,0)]^(2))/1/(2p)
        ! theta(400) = theta(375)*args%PA(2)-theta(255)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(2)-([(2,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(78) = (theta(365)-theta(245))*args%rec_p2
        theta(401) = theta(380)*args%PA(1)-theta(260)*args%PC(1)+t(78)*1 ! [(2,0,4)|(0,0,0)]^(1) = [(1,0,4)|(0,0,0)]^(1)*args%PA(1)-([(1,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(402) = theta(381)*args%PA(1)-theta(261)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(1)-([(0,5,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(403) = theta(382)*args%PA(1)-theta(262)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(1)-([(0,4,1)|(0,0,0)]^(2)*args%PC(1)
        theta(404) = theta(383)*args%PA(1)-theta(263)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(1) = [(0,3,2)|(0,0,0)]^(1)*args%PA(1)-([(0,3,2)|(0,0,0)]^(2)*args%PC(1)
        theta(405) = theta(384)*args%PA(1)-theta(264)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(1)-([(0,2,3)|(0,0,0)]^(2)*args%PC(1)
        ! theta(406) = theta(385)*args%PA(1)-theta(265)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(1)-([(0,1,4)|(0,0,0)]^(2)*args%PC(1)
        theta(407) = theta(386)*args%PA(1)-theta(266)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(1)-([(0,0,5)|(0,0,0)]^(2)*args%PC(1)
        theta(408) = theta(381)*args%PA(2)-theta(261)*args%PC(2)+t(76)*5 ! [(0,6,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(2)-([(0,5,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/5/(2p)
        theta(409) = theta(381)*args%PA(3)-theta(261)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(3)-([(0,5,0)|(0,0,0)]^(2)*args%PC(3)
        theta(410) = theta(382)*args%PA(3)-theta(262)*args%PC(3)+t(76)*1 ! [(0,4,2)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(3)-([(0,4,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        t(79) = (theta(364)-theta(244))*args%rec_p2
        theta(411) = theta(384)*args%PA(2)-theta(264)*args%PC(2)+t(79)*2 ! [(0,3,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(2)-([(0,2,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(1)-([(0,1,3)|(0,0,0)]^(2))/2/(2p)
        theta(412) = theta(385)*args%PA(2)-theta(265)*args%PC(2)+t(78)*1 ! [(0,2,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(2)-([(0,1,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(413) = theta(386)*args%PA(2)-theta(266)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(2)-([(0,0,5)|(0,0,0)]^(2)*args%PC(2)
        theta(414) = theta(386)*args%PA(3)-theta(266)*args%PC(3)+t(78)*5 ! [(0,0,6)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(3)-([(0,0,5)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/5/(2p)
        t(80) = (theta(366)-theta(246))*args%rec_p2
        theta(415) = theta(387)*args%PA(1)-theta(267)*args%PC(1)+t(80)*6 ! [(7,0,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(1)-([(6,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/6/(2p)
        theta(416) = theta(387)*args%PA(2)-theta(267)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(2)-([(6,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(417) = theta(387)*args%PA(3)-theta(267)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(3)-([(6,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(418) = theta(388)*args%PA(2)-theta(268)*args%PC(2)+t(80)*1 ! [(5,2,0)|(0,0,0)]^(1) = [(5,1,0)|(0,0,0)]^(1)*args%PA(2)-([(5,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(419) = theta(389)*args%PA(2)-theta(269)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(2)-([(5,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(420) = theta(389)*args%PA(3)-theta(269)*args%PC(3)+t(80)*1 ! [(5,0,2)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(3)-([(5,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        t(81) = (theta(367)-theta(247))*args%rec_p2
        theta(421) = theta(390)*args%PA(2)-theta(270)*args%PC(2)+t(81)*2 ! [(4,3,0)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(2)-([(4,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(1)-([(4,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(422) = theta(390)*args%PA(3)-theta(270)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(3)-([(4,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(423) = theta(392)*args%PA(2)-theta(272)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(2)-([(4,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(82) = (theta(368)-theta(248))*args%rec_p2
        theta(424) = theta(392)*args%PA(3)-theta(272)*args%PC(3)+t(82)*2 ! [(4,0,3)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(3)-([(4,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(1)-([(4,0,1)|(0,0,0)]^(2))/2/(2p)
        t(83) = (theta(376)-theta(256))*args%rec_p2
        theta(425) = theta(397)*args%PA(1)-theta(277)*args%PC(1)+t(83)*2 ! [(3,4,0)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(1)-([(2,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(1)-([(1,4,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(426) = theta(393)*args%PA(3)-theta(273)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(1) = [(3,3,0)|(0,0,0)]^(1)*args%PA(3)-([(3,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(84) = (theta(378)-theta(258))*args%rec_p2
        theta(427) = theta(399)*args%PA(1)-theta(279)*args%PC(1)+t(84)*2 ! [(3,2,2)|(0,0,0)]^(1) = [(2,2,2)|(0,0,0)]^(1)*args%PA(1)-([(2,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(1)-([(1,2,2)|(0,0,0)]^(2))/2/(2p)
        ! theta(428) = theta(396)*args%PA(2)-theta(276)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(1) = [(3,0,3)|(0,0,0)]^(1)*args%PA(2)-([(3,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(85) = (theta(380)-theta(260))*args%rec_p2
        theta(429) = theta(401)*args%PA(1)-theta(281)*args%PC(1)+t(85)*2 ! [(3,0,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(1)-([(2,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(1)-([(1,0,4)|(0,0,0)]^(2))/2/(2p)
        t(86) = (theta(381)-theta(261))*args%rec_p2
        theta(430) = theta(402)*args%PA(1)-theta(282)*args%PC(1)+t(86)*1 ! [(2,5,0)|(0,0,0)]^(1) = [(1,5,0)|(0,0,0)]^(1)*args%PA(1)-([(1,5,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(431) = theta(397)*args%PA(3)-theta(277)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(3)-([(2,4,0)|(0,0,0)]^(2)*args%PC(3)
        t(87) = (theta(383)-theta(263))*args%rec_p2
        theta(432) = theta(404)*args%PA(1)-theta(284)*args%PC(1)+t(87)*1 ! [(2,3,2)|(0,0,0)]^(1) = [(1,3,2)|(0,0,0)]^(1)*args%PA(1)-([(1,3,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(1)-([(0,3,2)|(0,0,0)]^(2))/1/(2p)
        t(88) = (theta(384)-theta(264))*args%rec_p2
        theta(433) = theta(405)*args%PA(1)-theta(285)*args%PC(1)+t(88)*1 ! [(2,2,3)|(0,0,0)]^(1) = [(1,2,3)|(0,0,0)]^(1)*args%PA(1)-([(1,2,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(1)-([(0,2,3)|(0,0,0)]^(2))/1/(2p)
        ! theta(434) = theta(401)*args%PA(2)-theta(281)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(2)-([(2,0,4)|(0,0,0)]^(2)*args%PC(2)
        t(89) = (theta(386)-theta(266))*args%rec_p2
        theta(435) = theta(407)*args%PA(1)-theta(287)*args%PC(1)+t(89)*1 ! [(2,0,5)|(0,0,0)]^(1) = [(1,0,5)|(0,0,0)]^(1)*args%PA(1)-([(1,0,5)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(436) = theta(408)*args%PA(1)-theta(288)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(1)-([(0,6,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(437) = theta(409)*args%PA(1)-theta(289)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(1)-([(0,5,1)|(0,0,0)]^(2)*args%PC(1)
        theta(438) = theta(410)*args%PA(1)-theta(290)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(1)-([(0,4,2)|(0,0,0)]^(2)*args%PC(1)
        theta(439) = theta(411)*args%PA(1)-theta(291)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(1) = [(0,3,3)|(0,0,0)]^(1)*args%PA(1)-([(0,3,3)|(0,0,0)]^(2)*args%PC(1)
        theta(440) = theta(412)*args%PA(1)-theta(292)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(1)-([(0,2,4)|(0,0,0)]^(2)*args%PC(1)
        ! theta(441) = theta(413)*args%PA(1)-theta(293)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(1)-([(0,1,5)|(0,0,0)]^(2)*args%PC(1)
        theta(442) = theta(414)*args%PA(1)-theta(294)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(1)-([(0,0,6)|(0,0,0)]^(2)*args%PC(1)
        theta(443) = theta(408)*args%PA(2)-theta(288)*args%PC(2)+t(86)*6 ! [(0,7,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(2)-([(0,6,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/6/(2p)
        theta(444) = theta(408)*args%PA(3)-theta(288)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(3)-([(0,6,0)|(0,0,0)]^(2)*args%PC(3)
        theta(445) = theta(409)*args%PA(3)-theta(289)*args%PC(3)+t(86)*1 ! [(0,5,2)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(3)-([(0,5,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        t(90) = (theta(382)-theta(262))*args%rec_p2
        theta(446) = theta(410)*args%PA(3)-theta(290)*args%PC(3)+t(90)*2 ! [(0,4,3)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(3)-([(0,4,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(1)-([(0,4,1)|(0,0,0)]^(2))/2/(2p)
        t(91) = (theta(385)-theta(265))*args%rec_p2
        theta(447) = theta(412)*args%PA(2)-theta(292)*args%PC(2)+t(91)*2 ! [(0,3,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(2)-([(0,2,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(1)-([(0,1,4)|(0,0,0)]^(2))/2/(2p)
        theta(448) = theta(413)*args%PA(2)-theta(293)*args%PC(2)+t(89)*1 ! [(0,2,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(2)-([(0,1,5)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(449) = theta(414)*args%PA(2)-theta(294)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(2)-([(0,0,6)|(0,0,0)]^(2)*args%PC(2)
        theta(450) = theta(414)*args%PA(3)-theta(294)*args%PC(3)+t(89)*6 ! [(0,0,7)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(3)-([(0,0,6)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/6/(2p)
        t(92) = (theta(387)-theta(267))*args%rec_p2
        theta(451) = theta(415)*args%PA(1)-theta(295)*args%PC(1)+t(92)*7 ! [(8,0,0)|(0,0,0)]^(1) = [(7,0,0)|(0,0,0)]^(1)*args%PA(1)-([(7,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(6,0,0)|(0,0,0)]^(1)-([(6,0,0)|(0,0,0)]^(2))/7/(2p)
        theta(452) = theta(415)*args%PA(2)-theta(295)*args%PC(2) ! [(7,1,0)|(0,0,0)]^(1) = [(7,0,0)|(0,0,0)]^(1)*args%PA(2)-([(7,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(453) = theta(415)*args%PA(3)-theta(295)*args%PC(3) ! [(7,0,1)|(0,0,0)]^(1) = [(7,0,0)|(0,0,0)]^(1)*args%PA(3)-([(7,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(454) = theta(416)*args%PA(2)-theta(296)*args%PC(2)+t(92)*1 ! [(6,2,0)|(0,0,0)]^(1) = [(6,1,0)|(0,0,0)]^(1)*args%PA(2)-([(6,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(6,0,0)|(0,0,0)]^(1)-([(6,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(455) = theta(417)*args%PA(2)-theta(297)*args%PC(2) ! [(6,1,1)|(0,0,0)]^(1) = [(6,0,1)|(0,0,0)]^(1)*args%PA(2)-([(6,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(456) = theta(417)*args%PA(3)-theta(297)*args%PC(3)+t(92)*1 ! [(6,0,2)|(0,0,0)]^(1) = [(6,0,1)|(0,0,0)]^(1)*args%PA(3)-([(6,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(6,0,0)|(0,0,0)]^(1)-([(6,0,0)|(0,0,0)]^(2))/1/(2p)
        t(93) = (theta(388)-theta(268))*args%rec_p2
        theta(457) = theta(418)*args%PA(2)-theta(298)*args%PC(2)+t(93)*2 ! [(5,3,0)|(0,0,0)]^(1) = [(5,2,0)|(0,0,0)]^(1)*args%PA(2)-([(5,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(5,1,0)|(0,0,0)]^(1)-([(5,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(458) = theta(418)*args%PA(3)-theta(298)*args%PC(3) ! [(5,2,1)|(0,0,0)]^(1) = [(5,2,0)|(0,0,0)]^(1)*args%PA(3)-([(5,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(459) = theta(420)*args%PA(2)-theta(300)*args%PC(2) ! [(5,1,2)|(0,0,0)]^(1) = [(5,0,2)|(0,0,0)]^(1)*args%PA(2)-([(5,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(94) = (theta(389)-theta(269))*args%rec_p2
        theta(460) = theta(420)*args%PA(3)-theta(300)*args%PC(3)+t(94)*2 ! [(5,0,3)|(0,0,0)]^(1) = [(5,0,2)|(0,0,0)]^(1)*args%PA(3)-([(5,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(5,0,1)|(0,0,0)]^(1)-([(5,0,1)|(0,0,0)]^(2))/2/(2p)
        t(95) = (theta(397)-theta(277))*args%rec_p2
        theta(461) = theta(425)*args%PA(1)-theta(305)*args%PC(1)+t(95)*3 ! [(4,4,0)|(0,0,0)]^(1) = [(3,4,0)|(0,0,0)]^(1)*args%PA(1)-([(3,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,4,0)|(0,0,0)]^(1)-([(2,4,0)|(0,0,0)]^(2))/3/(2p)
        ! theta(462) = theta(421)*args%PA(3)-theta(301)*args%PC(3) ! [(4,3,1)|(0,0,0)]^(1) = [(4,3,0)|(0,0,0)]^(1)*args%PA(3)-([(4,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(96) = (theta(399)-theta(279))*args%rec_p2
        theta(463) = theta(427)*args%PA(1)-theta(307)*args%PC(1)+t(96)*3 ! [(4,2,2)|(0,0,0)]^(1) = [(3,2,2)|(0,0,0)]^(1)*args%PA(1)-([(3,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(2,2,2)|(0,0,0)]^(1)-([(2,2,2)|(0,0,0)]^(2))/3/(2p)
        ! theta(464) = theta(424)*args%PA(2)-theta(304)*args%PC(2) ! [(4,1,3)|(0,0,0)]^(1) = [(4,0,3)|(0,0,0)]^(1)*args%PA(2)-([(4,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(97) = (theta(401)-theta(281))*args%rec_p2
        theta(465) = theta(429)*args%PA(1)-theta(309)*args%PC(1)+t(97)*3 ! [(4,0,4)|(0,0,0)]^(1) = [(3,0,4)|(0,0,0)]^(1)*args%PA(1)-([(3,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,4)|(0,0,0)]^(1)-([(2,0,4)|(0,0,0)]^(2))/3/(2p)
        t(98) = (theta(402)-theta(282))*args%rec_p2
        theta(466) = theta(430)*args%PA(1)-theta(310)*args%PC(1)+t(98)*2 ! [(3,5,0)|(0,0,0)]^(1) = [(2,5,0)|(0,0,0)]^(1)*args%PA(1)-([(2,5,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,5,0)|(0,0,0)]^(1)-([(1,5,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(467) = theta(425)*args%PA(3)-theta(305)*args%PC(3) ! [(3,4,1)|(0,0,0)]^(1) = [(3,4,0)|(0,0,0)]^(1)*args%PA(3)-([(3,4,0)|(0,0,0)]^(2)*args%PC(3)
        t(99) = (theta(404)-theta(284))*args%rec_p2
        theta(468) = theta(432)*args%PA(1)-theta(312)*args%PC(1)+t(99)*2 ! [(3,3,2)|(0,0,0)]^(1) = [(2,3,2)|(0,0,0)]^(1)*args%PA(1)-([(2,3,2)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,2)|(0,0,0)]^(1)-([(1,3,2)|(0,0,0)]^(2))/2/(2p)
        t(100) = (theta(405)-theta(285))*args%rec_p2
        theta(469) = theta(433)*args%PA(1)-theta(313)*args%PC(1)+t(100)*2 ! [(3,2,3)|(0,0,0)]^(1) = [(2,2,3)|(0,0,0)]^(1)*args%PA(1)-([(2,2,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,2,3)|(0,0,0)]^(1)-([(1,2,3)|(0,0,0)]^(2))/2/(2p)
        ! theta(470) = theta(429)*args%PA(2)-theta(309)*args%PC(2) ! [(3,1,4)|(0,0,0)]^(1) = [(3,0,4)|(0,0,0)]^(1)*args%PA(2)-([(3,0,4)|(0,0,0)]^(2)*args%PC(2)
        t(101) = (theta(407)-theta(287))*args%rec_p2
        theta(471) = theta(435)*args%PA(1)-theta(315)*args%PC(1)+t(101)*2 ! [(3,0,5)|(0,0,0)]^(1) = [(2,0,5)|(0,0,0)]^(1)*args%PA(1)-([(2,0,5)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,5)|(0,0,0)]^(1)-([(1,0,5)|(0,0,0)]^(2))/2/(2p)
        t(102) = (theta(408)-theta(288))*args%rec_p2
        theta(472) = theta(436)*args%PA(1)-theta(316)*args%PC(1)+t(102)*1 ! [(2,6,0)|(0,0,0)]^(1) = [(1,6,0)|(0,0,0)]^(1)*args%PA(1)-([(1,6,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,6,0)|(0,0,0)]^(1)-([(0,6,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(473) = theta(430)*args%PA(3)-theta(310)*args%PC(3) ! [(2,5,1)|(0,0,0)]^(1) = [(2,5,0)|(0,0,0)]^(1)*args%PA(3)-([(2,5,0)|(0,0,0)]^(2)*args%PC(3)
        t(103) = (theta(410)-theta(290))*args%rec_p2
        theta(474) = theta(438)*args%PA(1)-theta(318)*args%PC(1)+t(103)*1 ! [(2,4,2)|(0,0,0)]^(1) = [(1,4,2)|(0,0,0)]^(1)*args%PA(1)-([(1,4,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,2)|(0,0,0)]^(1)-([(0,4,2)|(0,0,0)]^(2))/1/(2p)
        t(104) = (theta(411)-theta(291))*args%rec_p2
        theta(475) = theta(439)*args%PA(1)-theta(319)*args%PC(1)+t(104)*1 ! [(2,3,3)|(0,0,0)]^(1) = [(1,3,3)|(0,0,0)]^(1)*args%PA(1)-([(1,3,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,3)|(0,0,0)]^(1)-([(0,3,3)|(0,0,0)]^(2))/1/(2p)
        t(105) = (theta(412)-theta(292))*args%rec_p2
        theta(476) = theta(440)*args%PA(1)-theta(320)*args%PC(1)+t(105)*1 ! [(2,2,4)|(0,0,0)]^(1) = [(1,2,4)|(0,0,0)]^(1)*args%PA(1)-([(1,2,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,4)|(0,0,0)]^(1)-([(0,2,4)|(0,0,0)]^(2))/1/(2p)
        ! theta(477) = theta(435)*args%PA(2)-theta(315)*args%PC(2) ! [(2,1,5)|(0,0,0)]^(1) = [(2,0,5)|(0,0,0)]^(1)*args%PA(2)-([(2,0,5)|(0,0,0)]^(2)*args%PC(2)
        t(106) = (theta(414)-theta(294))*args%rec_p2
        theta(478) = theta(442)*args%PA(1)-theta(322)*args%PC(1)+t(106)*1 ! [(2,0,6)|(0,0,0)]^(1) = [(1,0,6)|(0,0,0)]^(1)*args%PA(1)-([(1,0,6)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,6)|(0,0,0)]^(1)-([(0,0,6)|(0,0,0)]^(2))/1/(2p)
        theta(479) = theta(443)*args%PA(1)-theta(323)*args%PC(1) ! [(1,7,0)|(0,0,0)]^(1) = [(0,7,0)|(0,0,0)]^(1)*args%PA(1)-([(0,7,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(480) = theta(444)*args%PA(1)-theta(324)*args%PC(1) ! [(1,6,1)|(0,0,0)]^(1) = [(0,6,1)|(0,0,0)]^(1)*args%PA(1)-([(0,6,1)|(0,0,0)]^(2)*args%PC(1)
        theta(481) = theta(445)*args%PA(1)-theta(325)*args%PC(1) ! [(1,5,2)|(0,0,0)]^(1) = [(0,5,2)|(0,0,0)]^(1)*args%PA(1)-([(0,5,2)|(0,0,0)]^(2)*args%PC(1)
        theta(482) = theta(446)*args%PA(1)-theta(326)*args%PC(1) ! [(1,4,3)|(0,0,0)]^(1) = [(0,4,3)|(0,0,0)]^(1)*args%PA(1)-([(0,4,3)|(0,0,0)]^(2)*args%PC(1)
        theta(483) = theta(447)*args%PA(1)-theta(327)*args%PC(1) ! [(1,3,4)|(0,0,0)]^(1) = [(0,3,4)|(0,0,0)]^(1)*args%PA(1)-([(0,3,4)|(0,0,0)]^(2)*args%PC(1)
        theta(484) = theta(448)*args%PA(1)-theta(328)*args%PC(1) ! [(1,2,5)|(0,0,0)]^(1) = [(0,2,5)|(0,0,0)]^(1)*args%PA(1)-([(0,2,5)|(0,0,0)]^(2)*args%PC(1)
        ! theta(485) = theta(449)*args%PA(1)-theta(329)*args%PC(1) ! [(1,1,6)|(0,0,0)]^(1) = [(0,1,6)|(0,0,0)]^(1)*args%PA(1)-([(0,1,6)|(0,0,0)]^(2)*args%PC(1)
        theta(486) = theta(450)*args%PA(1)-theta(330)*args%PC(1) ! [(1,0,7)|(0,0,0)]^(1) = [(0,0,7)|(0,0,0)]^(1)*args%PA(1)-([(0,0,7)|(0,0,0)]^(2)*args%PC(1)
        theta(487) = theta(443)*args%PA(2)-theta(323)*args%PC(2)+t(102)*7 ! [(0,8,0)|(0,0,0)]^(1) = [(0,7,0)|(0,0,0)]^(1)*args%PA(2)-([(0,7,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,6,0)|(0,0,0)]^(1)-([(0,6,0)|(0,0,0)]^(2))/7/(2p)
        theta(488) = theta(443)*args%PA(3)-theta(323)*args%PC(3) ! [(0,7,1)|(0,0,0)]^(1) = [(0,7,0)|(0,0,0)]^(1)*args%PA(3)-([(0,7,0)|(0,0,0)]^(2)*args%PC(3)
        theta(489) = theta(444)*args%PA(3)-theta(324)*args%PC(3)+t(102)*1 ! [(0,6,2)|(0,0,0)]^(1) = [(0,6,1)|(0,0,0)]^(1)*args%PA(3)-([(0,6,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,6,0)|(0,0,0)]^(1)-([(0,6,0)|(0,0,0)]^(2))/1/(2p)
        t(107) = (theta(409)-theta(289))*args%rec_p2
        theta(490) = theta(445)*args%PA(3)-theta(325)*args%PC(3)+t(107)*2 ! [(0,5,3)|(0,0,0)]^(1) = [(0,5,2)|(0,0,0)]^(1)*args%PA(3)-([(0,5,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,5,1)|(0,0,0)]^(1)-([(0,5,1)|(0,0,0)]^(2))/2/(2p)
        theta(491) = theta(447)*args%PA(2)-theta(327)*args%PC(2)+t(105)*3 ! [(0,4,4)|(0,0,0)]^(1) = [(0,3,4)|(0,0,0)]^(1)*args%PA(2)-([(0,3,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,4)|(0,0,0)]^(1)-([(0,2,4)|(0,0,0)]^(2))/3/(2p)
        t(108) = (theta(413)-theta(293))*args%rec_p2
        theta(492) = theta(448)*args%PA(2)-theta(328)*args%PC(2)+t(108)*2 ! [(0,3,5)|(0,0,0)]^(1) = [(0,2,5)|(0,0,0)]^(1)*args%PA(2)-([(0,2,5)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,5)|(0,0,0)]^(1)-([(0,1,5)|(0,0,0)]^(2))/2/(2p)
        theta(493) = theta(449)*args%PA(2)-theta(329)*args%PC(2)+t(106)*1 ! [(0,2,6)|(0,0,0)]^(1) = [(0,1,6)|(0,0,0)]^(1)*args%PA(2)-([(0,1,6)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,6)|(0,0,0)]^(1)-([(0,0,6)|(0,0,0)]^(2))/1/(2p)
        theta(494) = theta(450)*args%PA(2)-theta(330)*args%PC(2) ! [(0,1,7)|(0,0,0)]^(1) = [(0,0,7)|(0,0,0)]^(1)*args%PA(2)-([(0,0,7)|(0,0,0)]^(2)*args%PC(2)
        theta(495) = theta(450)*args%PA(3)-theta(330)*args%PC(3)+t(106)*7 ! [(0,0,8)|(0,0,0)]^(1) = [(0,0,7)|(0,0,0)]^(1)*args%PA(3)-([(0,0,7)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,6)|(0,0,0)]^(1)-([(0,0,6)|(0,0,0)]^(2))/7/(2p)
        theta(497) = theta(496)*args%PA(1)-theta(331)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(498) = theta(496)*args%PA(2)-theta(331)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(499) = theta(496)*args%PA(3)-theta(331)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(109) = (theta(496)-theta(331))*args%rec_p2
        theta(500) = theta(497)*args%PA(1)-theta(332)*args%PC(1)+t(109)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(501) = theta(498)*args%PA(1)-theta(333)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(502) = theta(499)*args%PA(1)-theta(334)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(503) = theta(498)*args%PA(2)-theta(333)*args%PC(2)+t(109)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(504) = theta(499)*args%PA(2)-theta(334)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(505) = theta(499)*args%PA(3)-theta(334)*args%PC(3)+t(109)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(110) = (theta(497)-theta(332))*args%rec_p2
        theta(506) = theta(500)*args%PA(1)-theta(335)*args%PC(1)+t(110)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(507) = theta(500)*args%PA(2)-theta(335)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        ! theta(508) = theta(500)*args%PA(3)-theta(335)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(509) = theta(503)*args%PA(1)-theta(338)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(510) = theta(504)*args%PA(1)-theta(339)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(511) = theta(505)*args%PA(1)-theta(340)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(111) = (theta(498)-theta(333))*args%rec_p2
        theta(512) = theta(503)*args%PA(2)-theta(338)*args%PC(2)+t(111)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(513) = theta(503)*args%PA(3)-theta(338)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(514) = theta(505)*args%PA(2)-theta(340)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(112) = (theta(499)-theta(334))*args%rec_p2
        theta(515) = theta(505)*args%PA(3)-theta(340)*args%PC(3)+t(112)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(113) = (theta(500)-theta(335))*args%rec_p2
        theta(516) = theta(506)*args%PA(1)-theta(341)*args%PC(1)+t(113)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(517) = theta(506)*args%PA(2)-theta(341)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(518) = theta(506)*args%PA(3)-theta(341)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(114) = (theta(503)-theta(338))*args%rec_p2
        theta(519) = theta(509)*args%PA(1)-theta(344)*args%PC(1)+t(114)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(520) = theta(508)*args%PA(2)-theta(343)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(115) = (theta(505)-theta(340))*args%rec_p2
        theta(521) = theta(511)*args%PA(1)-theta(346)*args%PC(1)+t(115)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(522) = theta(512)*args%PA(1)-theta(347)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(523) = theta(513)*args%PA(1)-theta(348)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        ! theta(524) = theta(514)*args%PA(1)-theta(349)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(525) = theta(515)*args%PA(1)-theta(350)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(526) = theta(512)*args%PA(2)-theta(347)*args%PC(2)+t(114)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(527) = theta(512)*args%PA(3)-theta(347)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(528) = theta(514)*args%PA(2)-theta(349)*args%PC(2)+t(115)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(529) = theta(515)*args%PA(2)-theta(350)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(530) = theta(515)*args%PA(3)-theta(350)*args%PC(3)+t(115)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(116) = (theta(506)-theta(341))*args%rec_p2
        theta(531) = theta(516)*args%PA(1)-theta(351)*args%PC(1)+t(116)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(532) = theta(516)*args%PA(2)-theta(351)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(533) = theta(516)*args%PA(3)-theta(351)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(534) = theta(517)*args%PA(2)-theta(352)*args%PC(2)+t(116)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(535) = theta(518)*args%PA(2)-theta(353)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(536) = theta(518)*args%PA(3)-theta(353)*args%PC(3)+t(116)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(117) = (theta(512)-theta(347))*args%rec_p2
        theta(537) = theta(522)*args%PA(1)-theta(357)*args%PC(1)+t(117)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(538) = theta(519)*args%PA(3)-theta(354)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(539) = theta(521)*args%PA(2)-theta(356)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(118) = (theta(515)-theta(350))*args%rec_p2
        theta(540) = theta(525)*args%PA(1)-theta(360)*args%PC(1)+t(118)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(541) = theta(526)*args%PA(1)-theta(361)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(542) = theta(527)*args%PA(1)-theta(362)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(543) = theta(528)*args%PA(1)-theta(363)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(544) = theta(529)*args%PA(1)-theta(364)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(545) = theta(530)*args%PA(1)-theta(365)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(546) = theta(526)*args%PA(2)-theta(361)*args%PC(2)+t(117)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(547) = theta(526)*args%PA(3)-theta(361)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(548) = theta(527)*args%PA(3)-theta(362)*args%PC(3)+t(117)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(549) = theta(529)*args%PA(2)-theta(364)*args%PC(2)+t(118)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(550) = theta(530)*args%PA(2)-theta(365)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(551) = theta(530)*args%PA(3)-theta(365)*args%PC(3)+t(118)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(119) = (theta(516)-theta(351))*args%rec_p2
        theta(552) = theta(531)*args%PA(1)-theta(366)*args%PC(1)+t(119)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(553) = theta(531)*args%PA(2)-theta(366)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(554) = theta(531)*args%PA(3)-theta(366)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(555) = theta(532)*args%PA(2)-theta(367)*args%PC(2)+t(119)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(556) = theta(533)*args%PA(2)-theta(368)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(557) = theta(533)*args%PA(3)-theta(368)*args%PC(3)+t(119)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(120) = (theta(522)-theta(357))*args%rec_p2
        theta(558) = theta(537)*args%PA(1)-theta(372)*args%PC(1)+t(120)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(559) = theta(534)*args%PA(3)-theta(369)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(560) = theta(536)*args%PA(2)-theta(371)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(121) = (theta(525)-theta(360))*args%rec_p2
        theta(561) = theta(540)*args%PA(1)-theta(375)*args%PC(1)+t(121)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(122) = (theta(526)-theta(361))*args%rec_p2
        theta(562) = theta(541)*args%PA(1)-theta(376)*args%PC(1)+t(122)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(563) = theta(537)*args%PA(3)-theta(372)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(123) = (theta(528)-theta(363))*args%rec_p2
        theta(564) = theta(543)*args%PA(1)-theta(378)*args%PC(1)+t(123)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(565) = theta(540)*args%PA(2)-theta(375)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(124) = (theta(530)-theta(365))*args%rec_p2
        theta(566) = theta(545)*args%PA(1)-theta(380)*args%PC(1)+t(124)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(567) = theta(546)*args%PA(1)-theta(381)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(568) = theta(547)*args%PA(1)-theta(382)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(569) = theta(548)*args%PA(1)-theta(383)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(570) = theta(549)*args%PA(1)-theta(384)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(571) = theta(550)*args%PA(1)-theta(385)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(572) = theta(551)*args%PA(1)-theta(386)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(573) = theta(546)*args%PA(2)-theta(381)*args%PC(2)+t(122)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(574) = theta(546)*args%PA(3)-theta(381)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(575) = theta(547)*args%PA(3)-theta(382)*args%PC(3)+t(122)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(125) = (theta(529)-theta(364))*args%rec_p2
        theta(576) = theta(549)*args%PA(2)-theta(384)*args%PC(2)+t(125)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(577) = theta(550)*args%PA(2)-theta(385)*args%PC(2)+t(124)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(578) = theta(551)*args%PA(2)-theta(386)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(579) = theta(551)*args%PA(3)-theta(386)*args%PC(3)+t(124)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
        t(126) = (theta(531)-theta(366))*args%rec_p2
        theta(580) = theta(552)*args%PA(1)-theta(387)*args%PC(1)+t(126)*6 ! [(7,0,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(1)-([(6,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/6/(2p)
        theta(581) = theta(552)*args%PA(2)-theta(387)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(2)-([(6,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(582) = theta(552)*args%PA(3)-theta(387)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(3)-([(6,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(583) = theta(553)*args%PA(2)-theta(388)*args%PC(2)+t(126)*1 ! [(5,2,0)|(0,0,0)]^(0) = [(5,1,0)|(0,0,0)]^(0)*args%PA(2)-([(5,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(584) = theta(554)*args%PA(2)-theta(389)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(2)-([(5,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(585) = theta(554)*args%PA(3)-theta(389)*args%PC(3)+t(126)*1 ! [(5,0,2)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(3)-([(5,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        t(127) = (theta(532)-theta(367))*args%rec_p2
        theta(586) = theta(555)*args%PA(2)-theta(390)*args%PC(2)+t(127)*2 ! [(4,3,0)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(2)-([(4,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(0)-([(4,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(587) = theta(555)*args%PA(3)-theta(390)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(3)-([(4,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(588) = theta(557)*args%PA(2)-theta(392)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(2)-([(4,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(128) = (theta(533)-theta(368))*args%rec_p2
        theta(589) = theta(557)*args%PA(3)-theta(392)*args%PC(3)+t(128)*2 ! [(4,0,3)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(3)-([(4,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(0)-([(4,0,1)|(0,0,0)]^(1))/2/(2p)
        t(129) = (theta(541)-theta(376))*args%rec_p2
        theta(590) = theta(562)*args%PA(1)-theta(397)*args%PC(1)+t(129)*2 ! [(3,4,0)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(1)-([(2,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(0)-([(1,4,0)|(0,0,0)]^(1))/2/(2p)
        theta(591) = theta(558)*args%PA(3)-theta(393)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(0) = [(3,3,0)|(0,0,0)]^(0)*args%PA(3)-([(3,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(130) = (theta(543)-theta(378))*args%rec_p2
        theta(592) = theta(564)*args%PA(1)-theta(399)*args%PC(1)+t(130)*2 ! [(3,2,2)|(0,0,0)]^(0) = [(2,2,2)|(0,0,0)]^(0)*args%PA(1)-([(2,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(0)-([(1,2,2)|(0,0,0)]^(1))/2/(2p)
        theta(593) = theta(561)*args%PA(2)-theta(396)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(0) = [(3,0,3)|(0,0,0)]^(0)*args%PA(2)-([(3,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(131) = (theta(545)-theta(380))*args%rec_p2
        theta(594) = theta(566)*args%PA(1)-theta(401)*args%PC(1)+t(131)*2 ! [(3,0,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(1)-([(2,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(0)-([(1,0,4)|(0,0,0)]^(1))/2/(2p)
        t(132) = (theta(546)-theta(381))*args%rec_p2
        theta(595) = theta(567)*args%PA(1)-theta(402)*args%PC(1)+t(132)*1 ! [(2,5,0)|(0,0,0)]^(0) = [(1,5,0)|(0,0,0)]^(0)*args%PA(1)-([(1,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        theta(596) = theta(562)*args%PA(3)-theta(397)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(3)-([(2,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(133) = (theta(548)-theta(383))*args%rec_p2
        theta(597) = theta(569)*args%PA(1)-theta(404)*args%PC(1)+t(133)*1 ! [(2,3,2)|(0,0,0)]^(0) = [(1,3,2)|(0,0,0)]^(0)*args%PA(1)-([(1,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(0)-([(0,3,2)|(0,0,0)]^(1))/1/(2p)
        t(134) = (theta(549)-theta(384))*args%rec_p2
        theta(598) = theta(570)*args%PA(1)-theta(405)*args%PC(1)+t(134)*1 ! [(2,2,3)|(0,0,0)]^(0) = [(1,2,3)|(0,0,0)]^(0)*args%PA(1)-([(1,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(0)-([(0,2,3)|(0,0,0)]^(1))/1/(2p)
        theta(599) = theta(566)*args%PA(2)-theta(401)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(2)-([(2,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(135) = (theta(551)-theta(386))*args%rec_p2
        theta(600) = theta(572)*args%PA(1)-theta(407)*args%PC(1)+t(135)*1 ! [(2,0,5)|(0,0,0)]^(0) = [(1,0,5)|(0,0,0)]^(0)*args%PA(1)-([(1,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(601) = theta(573)*args%PA(1)-theta(408)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(1)-([(0,6,0)|(0,0,0)]^(1)*args%PC(1)
        theta(602) = theta(574)*args%PA(1)-theta(409)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(1)-([(0,5,1)|(0,0,0)]^(1)*args%PC(1)
        theta(603) = theta(575)*args%PA(1)-theta(410)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(1)-([(0,4,2)|(0,0,0)]^(1)*args%PC(1)
        theta(604) = theta(576)*args%PA(1)-theta(411)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(0) = [(0,3,3)|(0,0,0)]^(0)*args%PA(1)-([(0,3,3)|(0,0,0)]^(1)*args%PC(1)
        theta(605) = theta(577)*args%PA(1)-theta(412)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(1)-([(0,2,4)|(0,0,0)]^(1)*args%PC(1)
        theta(606) = theta(578)*args%PA(1)-theta(413)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(1)-([(0,1,5)|(0,0,0)]^(1)*args%PC(1)
        theta(607) = theta(579)*args%PA(1)-theta(414)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(1)-([(0,0,6)|(0,0,0)]^(1)*args%PC(1)
        theta(608) = theta(573)*args%PA(2)-theta(408)*args%PC(2)+t(132)*6 ! [(0,7,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(2)-([(0,6,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/6/(2p)
        theta(609) = theta(573)*args%PA(3)-theta(408)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(3)-([(0,6,0)|(0,0,0)]^(1)*args%PC(3)
        theta(610) = theta(574)*args%PA(3)-theta(409)*args%PC(3)+t(132)*1 ! [(0,5,2)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(3)-([(0,5,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        t(136) = (theta(547)-theta(382))*args%rec_p2
        theta(611) = theta(575)*args%PA(3)-theta(410)*args%PC(3)+t(136)*2 ! [(0,4,3)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(3)-([(0,4,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(0)-([(0,4,1)|(0,0,0)]^(1))/2/(2p)
        t(137) = (theta(550)-theta(385))*args%rec_p2
        theta(612) = theta(577)*args%PA(2)-theta(412)*args%PC(2)+t(137)*2 ! [(0,3,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(2)-([(0,2,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(0)-([(0,1,4)|(0,0,0)]^(1))/2/(2p)
        theta(613) = theta(578)*args%PA(2)-theta(413)*args%PC(2)+t(135)*1 ! [(0,2,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(2)-([(0,1,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(614) = theta(579)*args%PA(2)-theta(414)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(2)-([(0,0,6)|(0,0,0)]^(1)*args%PC(2)
        theta(615) = theta(579)*args%PA(3)-theta(414)*args%PC(3)+t(135)*6 ! [(0,0,7)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(3)-([(0,0,6)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/6/(2p)
        t(138) = (theta(552)-theta(387))*args%rec_p2
        theta(616) = theta(580)*args%PA(1)-theta(415)*args%PC(1)+t(138)*7 ! [(8,0,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(1)-([(7,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/7/(2p)
        theta(617) = theta(580)*args%PA(2)-theta(415)*args%PC(2) ! [(7,1,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(2)-([(7,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(618) = theta(580)*args%PA(3)-theta(415)*args%PC(3) ! [(7,0,1)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(3)-([(7,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(619) = theta(581)*args%PA(2)-theta(416)*args%PC(2)+t(138)*1 ! [(6,2,0)|(0,0,0)]^(0) = [(6,1,0)|(0,0,0)]^(0)*args%PA(2)-([(6,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(620) = theta(582)*args%PA(2)-theta(417)*args%PC(2) ! [(6,1,1)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(2)-([(6,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(621) = theta(582)*args%PA(3)-theta(417)*args%PC(3)+t(138)*1 ! [(6,0,2)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(3)-([(6,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        t(139) = (theta(553)-theta(388))*args%rec_p2
        theta(622) = theta(583)*args%PA(2)-theta(418)*args%PC(2)+t(139)*2 ! [(5,3,0)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(2)-([(5,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,1,0)|(0,0,0)]^(0)-([(5,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(623) = theta(583)*args%PA(3)-theta(418)*args%PC(3) ! [(5,2,1)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(3)-([(5,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(624) = theta(585)*args%PA(2)-theta(420)*args%PC(2) ! [(5,1,2)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(2)-([(5,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(140) = (theta(554)-theta(389))*args%rec_p2
        theta(625) = theta(585)*args%PA(3)-theta(420)*args%PC(3)+t(140)*2 ! [(5,0,3)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(3)-([(5,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,1)|(0,0,0)]^(0)-([(5,0,1)|(0,0,0)]^(1))/2/(2p)
        t(141) = (theta(562)-theta(397))*args%rec_p2
        theta(626) = theta(590)*args%PA(1)-theta(425)*args%PC(1)+t(141)*3 ! [(4,4,0)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(1)-([(3,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,4,0)|(0,0,0)]^(0)-([(2,4,0)|(0,0,0)]^(1))/3/(2p)
        theta(627) = theta(586)*args%PA(3)-theta(421)*args%PC(3) ! [(4,3,1)|(0,0,0)]^(0) = [(4,3,0)|(0,0,0)]^(0)*args%PA(3)-([(4,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(142) = (theta(564)-theta(399))*args%rec_p2
        theta(628) = theta(592)*args%PA(1)-theta(427)*args%PC(1)+t(142)*3 ! [(4,2,2)|(0,0,0)]^(0) = [(3,2,2)|(0,0,0)]^(0)*args%PA(1)-([(3,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(2,2,2)|(0,0,0)]^(0)-([(2,2,2)|(0,0,0)]^(1))/3/(2p)
        theta(629) = theta(589)*args%PA(2)-theta(424)*args%PC(2) ! [(4,1,3)|(0,0,0)]^(0) = [(4,0,3)|(0,0,0)]^(0)*args%PA(2)-([(4,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(143) = (theta(566)-theta(401))*args%rec_p2
        theta(630) = theta(594)*args%PA(1)-theta(429)*args%PC(1)+t(143)*3 ! [(4,0,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(1)-([(3,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,4)|(0,0,0)]^(0)-([(2,0,4)|(0,0,0)]^(1))/3/(2p)
        t(144) = (theta(567)-theta(402))*args%rec_p2
        theta(631) = theta(595)*args%PA(1)-theta(430)*args%PC(1)+t(144)*2 ! [(3,5,0)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(1)-([(2,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,5,0)|(0,0,0)]^(0)-([(1,5,0)|(0,0,0)]^(1))/2/(2p)
        theta(632) = theta(590)*args%PA(3)-theta(425)*args%PC(3) ! [(3,4,1)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(3)-([(3,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(145) = (theta(569)-theta(404))*args%rec_p2
        theta(633) = theta(597)*args%PA(1)-theta(432)*args%PC(1)+t(145)*2 ! [(3,3,2)|(0,0,0)]^(0) = [(2,3,2)|(0,0,0)]^(0)*args%PA(1)-([(2,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,2)|(0,0,0)]^(0)-([(1,3,2)|(0,0,0)]^(1))/2/(2p)
        t(146) = (theta(570)-theta(405))*args%rec_p2
        theta(634) = theta(598)*args%PA(1)-theta(433)*args%PC(1)+t(146)*2 ! [(3,2,3)|(0,0,0)]^(0) = [(2,2,3)|(0,0,0)]^(0)*args%PA(1)-([(2,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,3)|(0,0,0)]^(0)-([(1,2,3)|(0,0,0)]^(1))/2/(2p)
        theta(635) = theta(594)*args%PA(2)-theta(429)*args%PC(2) ! [(3,1,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(2)-([(3,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(147) = (theta(572)-theta(407))*args%rec_p2
        theta(636) = theta(600)*args%PA(1)-theta(435)*args%PC(1)+t(147)*2 ! [(3,0,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(1)-([(2,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,5)|(0,0,0)]^(0)-([(1,0,5)|(0,0,0)]^(1))/2/(2p)
        t(148) = (theta(573)-theta(408))*args%rec_p2
        theta(637) = theta(601)*args%PA(1)-theta(436)*args%PC(1)+t(148)*1 ! [(2,6,0)|(0,0,0)]^(0) = [(1,6,0)|(0,0,0)]^(0)*args%PA(1)-([(1,6,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        theta(638) = theta(595)*args%PA(3)-theta(430)*args%PC(3) ! [(2,5,1)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(3)-([(2,5,0)|(0,0,0)]^(1)*args%PC(3)
        t(149) = (theta(575)-theta(410))*args%rec_p2
        theta(639) = theta(603)*args%PA(1)-theta(438)*args%PC(1)+t(149)*1 ! [(2,4,2)|(0,0,0)]^(0) = [(1,4,2)|(0,0,0)]^(0)*args%PA(1)-([(1,4,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,2)|(0,0,0)]^(0)-([(0,4,2)|(0,0,0)]^(1))/1/(2p)
        t(150) = (theta(576)-theta(411))*args%rec_p2
        theta(640) = theta(604)*args%PA(1)-theta(439)*args%PC(1)+t(150)*1 ! [(2,3,3)|(0,0,0)]^(0) = [(1,3,3)|(0,0,0)]^(0)*args%PA(1)-([(1,3,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,3)|(0,0,0)]^(0)-([(0,3,3)|(0,0,0)]^(1))/1/(2p)
        t(151) = (theta(577)-theta(412))*args%rec_p2
        theta(641) = theta(605)*args%PA(1)-theta(440)*args%PC(1)+t(151)*1 ! [(2,2,4)|(0,0,0)]^(0) = [(1,2,4)|(0,0,0)]^(0)*args%PA(1)-([(1,2,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/1/(2p)
        theta(642) = theta(600)*args%PA(2)-theta(435)*args%PC(2) ! [(2,1,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(2)-([(2,0,5)|(0,0,0)]^(1)*args%PC(2)
        t(152) = (theta(579)-theta(414))*args%rec_p2
        theta(643) = theta(607)*args%PA(1)-theta(442)*args%PC(1)+t(152)*1 ! [(2,0,6)|(0,0,0)]^(0) = [(1,0,6)|(0,0,0)]^(0)*args%PA(1)-([(1,0,6)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(644) = theta(608)*args%PA(1)-theta(443)*args%PC(1) ! [(1,7,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(1)-([(0,7,0)|(0,0,0)]^(1)*args%PC(1)
        theta(645) = theta(609)*args%PA(1)-theta(444)*args%PC(1) ! [(1,6,1)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(1)-([(0,6,1)|(0,0,0)]^(1)*args%PC(1)
        theta(646) = theta(610)*args%PA(1)-theta(445)*args%PC(1) ! [(1,5,2)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(1)-([(0,5,2)|(0,0,0)]^(1)*args%PC(1)
        theta(647) = theta(611)*args%PA(1)-theta(446)*args%PC(1) ! [(1,4,3)|(0,0,0)]^(0) = [(0,4,3)|(0,0,0)]^(0)*args%PA(1)-([(0,4,3)|(0,0,0)]^(1)*args%PC(1)
        theta(648) = theta(612)*args%PA(1)-theta(447)*args%PC(1) ! [(1,3,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(1)-([(0,3,4)|(0,0,0)]^(1)*args%PC(1)
        theta(649) = theta(613)*args%PA(1)-theta(448)*args%PC(1) ! [(1,2,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(1)-([(0,2,5)|(0,0,0)]^(1)*args%PC(1)
        theta(650) = theta(614)*args%PA(1)-theta(449)*args%PC(1) ! [(1,1,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(1)-([(0,1,6)|(0,0,0)]^(1)*args%PC(1)
        theta(651) = theta(615)*args%PA(1)-theta(450)*args%PC(1) ! [(1,0,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(1)-([(0,0,7)|(0,0,0)]^(1)*args%PC(1)
        theta(652) = theta(608)*args%PA(2)-theta(443)*args%PC(2)+t(148)*7 ! [(0,8,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(2)-([(0,7,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/7/(2p)
        theta(653) = theta(608)*args%PA(3)-theta(443)*args%PC(3) ! [(0,7,1)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(3)-([(0,7,0)|(0,0,0)]^(1)*args%PC(3)
        theta(654) = theta(609)*args%PA(3)-theta(444)*args%PC(3)+t(148)*1 ! [(0,6,2)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(3)-([(0,6,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        t(153) = (theta(574)-theta(409))*args%rec_p2
        theta(655) = theta(610)*args%PA(3)-theta(445)*args%PC(3)+t(153)*2 ! [(0,5,3)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(3)-([(0,5,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,1)|(0,0,0)]^(0)-([(0,5,1)|(0,0,0)]^(1))/2/(2p)
        theta(656) = theta(612)*args%PA(2)-theta(447)*args%PC(2)+t(151)*3 ! [(0,4,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(2)-([(0,3,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/3/(2p)
        t(154) = (theta(578)-theta(413))*args%rec_p2
        theta(657) = theta(613)*args%PA(2)-theta(448)*args%PC(2)+t(154)*2 ! [(0,3,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(2)-([(0,2,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,5)|(0,0,0)]^(0)-([(0,1,5)|(0,0,0)]^(1))/2/(2p)
        theta(658) = theta(614)*args%PA(2)-theta(449)*args%PC(2)+t(152)*1 ! [(0,2,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(2)-([(0,1,6)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(659) = theta(615)*args%PA(2)-theta(450)*args%PC(2) ! [(0,1,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(2)-([(0,0,7)|(0,0,0)]^(1)*args%PC(2)
        theta(660) = theta(615)*args%PA(3)-theta(450)*args%PC(3)+t(152)*7 ! [(0,0,8)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(3)-([(0,0,7)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/7/(2p)
        t(155) = (theta(580)-theta(415))*args%rec_p2
        theta(661) = theta(616)*args%PA(1)-theta(451)*args%PC(1)+t(155)*8 ! [(9,0,0)|(0,0,0)]^(0) = [(8,0,0)|(0,0,0)]^(0)*args%PA(1)-([(8,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(7,0,0)|(0,0,0)]^(0)-([(7,0,0)|(0,0,0)]^(1))/8/(2p)
        theta(662) = theta(616)*args%PA(2)-theta(451)*args%PC(2) ! [(8,1,0)|(0,0,0)]^(0) = [(8,0,0)|(0,0,0)]^(0)*args%PA(2)-([(8,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(663) = theta(616)*args%PA(3)-theta(451)*args%PC(3) ! [(8,0,1)|(0,0,0)]^(0) = [(8,0,0)|(0,0,0)]^(0)*args%PA(3)-([(8,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(664) = theta(617)*args%PA(2)-theta(452)*args%PC(2)+t(155)*1 ! [(7,2,0)|(0,0,0)]^(0) = [(7,1,0)|(0,0,0)]^(0)*args%PA(2)-([(7,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(7,0,0)|(0,0,0)]^(0)-([(7,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(665) = theta(618)*args%PA(2)-theta(453)*args%PC(2) ! [(7,1,1)|(0,0,0)]^(0) = [(7,0,1)|(0,0,0)]^(0)*args%PA(2)-([(7,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(666) = theta(618)*args%PA(3)-theta(453)*args%PC(3)+t(155)*1 ! [(7,0,2)|(0,0,0)]^(0) = [(7,0,1)|(0,0,0)]^(0)*args%PA(3)-([(7,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(7,0,0)|(0,0,0)]^(0)-([(7,0,0)|(0,0,0)]^(1))/1/(2p)
        t(156) = (theta(581)-theta(416))*args%rec_p2
        theta(667) = theta(619)*args%PA(2)-theta(454)*args%PC(2)+t(156)*2 ! [(6,3,0)|(0,0,0)]^(0) = [(6,2,0)|(0,0,0)]^(0)*args%PA(2)-([(6,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(6,1,0)|(0,0,0)]^(0)-([(6,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(668) = theta(619)*args%PA(3)-theta(454)*args%PC(3) ! [(6,2,1)|(0,0,0)]^(0) = [(6,2,0)|(0,0,0)]^(0)*args%PA(3)-([(6,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(669) = theta(621)*args%PA(2)-theta(456)*args%PC(2) ! [(6,1,2)|(0,0,0)]^(0) = [(6,0,2)|(0,0,0)]^(0)*args%PA(2)-([(6,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(157) = (theta(582)-theta(417))*args%rec_p2
        theta(670) = theta(621)*args%PA(3)-theta(456)*args%PC(3)+t(157)*2 ! [(6,0,3)|(0,0,0)]^(0) = [(6,0,2)|(0,0,0)]^(0)*args%PA(3)-([(6,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(6,0,1)|(0,0,0)]^(0)-([(6,0,1)|(0,0,0)]^(1))/2/(2p)
        t(158) = (theta(583)-theta(418))*args%rec_p2
        theta(671) = theta(622)*args%PA(2)-theta(457)*args%PC(2)+t(158)*3 ! [(5,4,0)|(0,0,0)]^(0) = [(5,3,0)|(0,0,0)]^(0)*args%PA(2)-([(5,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,2,0)|(0,0,0)]^(0)-([(5,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(672) = theta(622)*args%PA(3)-theta(457)*args%PC(3) ! [(5,3,1)|(0,0,0)]^(0) = [(5,3,0)|(0,0,0)]^(0)*args%PA(3)-([(5,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(159) = (theta(592)-theta(427))*args%rec_p2
        theta(673) = theta(628)*args%PA(1)-theta(463)*args%PC(1)+t(159)*4 ! [(5,2,2)|(0,0,0)]^(0) = [(4,2,2)|(0,0,0)]^(0)*args%PA(1)-([(4,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(3,2,2)|(0,0,0)]^(0)-([(3,2,2)|(0,0,0)]^(1))/4/(2p)
        theta(674) = theta(625)*args%PA(2)-theta(460)*args%PC(2) ! [(5,1,3)|(0,0,0)]^(0) = [(5,0,3)|(0,0,0)]^(0)*args%PA(2)-([(5,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(160) = (theta(585)-theta(420))*args%rec_p2
        theta(675) = theta(625)*args%PA(3)-theta(460)*args%PC(3)+t(160)*3 ! [(5,0,4)|(0,0,0)]^(0) = [(5,0,3)|(0,0,0)]^(0)*args%PA(3)-([(5,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,2)|(0,0,0)]^(0)-([(5,0,2)|(0,0,0)]^(1))/3/(2p)
        t(161) = (theta(595)-theta(430))*args%rec_p2
        theta(676) = theta(631)*args%PA(1)-theta(466)*args%PC(1)+t(161)*3 ! [(4,5,0)|(0,0,0)]^(0) = [(3,5,0)|(0,0,0)]^(0)*args%PA(1)-([(3,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,5,0)|(0,0,0)]^(0)-([(2,5,0)|(0,0,0)]^(1))/3/(2p)
        theta(677) = theta(626)*args%PA(3)-theta(461)*args%PC(3) ! [(4,4,1)|(0,0,0)]^(0) = [(4,4,0)|(0,0,0)]^(0)*args%PA(3)-([(4,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(162) = (theta(597)-theta(432))*args%rec_p2
        theta(678) = theta(633)*args%PA(1)-theta(468)*args%PC(1)+t(162)*3 ! [(4,3,2)|(0,0,0)]^(0) = [(3,3,2)|(0,0,0)]^(0)*args%PA(1)-([(3,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(2,3,2)|(0,0,0)]^(0)-([(2,3,2)|(0,0,0)]^(1))/3/(2p)
        t(163) = (theta(598)-theta(433))*args%rec_p2
        theta(679) = theta(634)*args%PA(1)-theta(469)*args%PC(1)+t(163)*3 ! [(4,2,3)|(0,0,0)]^(0) = [(3,2,3)|(0,0,0)]^(0)*args%PA(1)-([(3,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(2,2,3)|(0,0,0)]^(0)-([(2,2,3)|(0,0,0)]^(1))/3/(2p)
        theta(680) = theta(630)*args%PA(2)-theta(465)*args%PC(2) ! [(4,1,4)|(0,0,0)]^(0) = [(4,0,4)|(0,0,0)]^(0)*args%PA(2)-([(4,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(164) = (theta(600)-theta(435))*args%rec_p2
        theta(681) = theta(636)*args%PA(1)-theta(471)*args%PC(1)+t(164)*3 ! [(4,0,5)|(0,0,0)]^(0) = [(3,0,5)|(0,0,0)]^(0)*args%PA(1)-([(3,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,5)|(0,0,0)]^(0)-([(2,0,5)|(0,0,0)]^(1))/3/(2p)
        t(165) = (theta(601)-theta(436))*args%rec_p2
        theta(682) = theta(637)*args%PA(1)-theta(472)*args%PC(1)+t(165)*2 ! [(3,6,0)|(0,0,0)]^(0) = [(2,6,0)|(0,0,0)]^(0)*args%PA(1)-([(2,6,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,6,0)|(0,0,0)]^(0)-([(1,6,0)|(0,0,0)]^(1))/2/(2p)
        theta(683) = theta(631)*args%PA(3)-theta(466)*args%PC(3) ! [(3,5,1)|(0,0,0)]^(0) = [(3,5,0)|(0,0,0)]^(0)*args%PA(3)-([(3,5,0)|(0,0,0)]^(1)*args%PC(3)
        t(166) = (theta(603)-theta(438))*args%rec_p2
        theta(684) = theta(639)*args%PA(1)-theta(474)*args%PC(1)+t(166)*2 ! [(3,4,2)|(0,0,0)]^(0) = [(2,4,2)|(0,0,0)]^(0)*args%PA(1)-([(2,4,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,2)|(0,0,0)]^(0)-([(1,4,2)|(0,0,0)]^(1))/2/(2p)
        t(167) = (theta(604)-theta(439))*args%rec_p2
        theta(685) = theta(640)*args%PA(1)-theta(475)*args%PC(1)+t(167)*2 ! [(3,3,3)|(0,0,0)]^(0) = [(2,3,3)|(0,0,0)]^(0)*args%PA(1)-([(2,3,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,3)|(0,0,0)]^(0)-([(1,3,3)|(0,0,0)]^(1))/2/(2p)
        t(168) = (theta(605)-theta(440))*args%rec_p2
        theta(686) = theta(641)*args%PA(1)-theta(476)*args%PC(1)+t(168)*2 ! [(3,2,4)|(0,0,0)]^(0) = [(2,2,4)|(0,0,0)]^(0)*args%PA(1)-([(2,2,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,4)|(0,0,0)]^(0)-([(1,2,4)|(0,0,0)]^(1))/2/(2p)
        theta(687) = theta(636)*args%PA(2)-theta(471)*args%PC(2) ! [(3,1,5)|(0,0,0)]^(0) = [(3,0,5)|(0,0,0)]^(0)*args%PA(2)-([(3,0,5)|(0,0,0)]^(1)*args%PC(2)
        t(169) = (theta(607)-theta(442))*args%rec_p2
        theta(688) = theta(643)*args%PA(1)-theta(478)*args%PC(1)+t(169)*2 ! [(3,0,6)|(0,0,0)]^(0) = [(2,0,6)|(0,0,0)]^(0)*args%PA(1)-([(2,0,6)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,6)|(0,0,0)]^(0)-([(1,0,6)|(0,0,0)]^(1))/2/(2p)
        t(170) = (theta(608)-theta(443))*args%rec_p2
        theta(689) = theta(644)*args%PA(1)-theta(479)*args%PC(1)+t(170)*1 ! [(2,7,0)|(0,0,0)]^(0) = [(1,7,0)|(0,0,0)]^(0)*args%PA(1)-([(1,7,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,7,0)|(0,0,0)]^(0)-([(0,7,0)|(0,0,0)]^(1))/1/(2p)
        theta(690) = theta(637)*args%PA(3)-theta(472)*args%PC(3) ! [(2,6,1)|(0,0,0)]^(0) = [(2,6,0)|(0,0,0)]^(0)*args%PA(3)-([(2,6,0)|(0,0,0)]^(1)*args%PC(3)
        t(171) = (theta(610)-theta(445))*args%rec_p2
        theta(691) = theta(646)*args%PA(1)-theta(481)*args%PC(1)+t(171)*1 ! [(2,5,2)|(0,0,0)]^(0) = [(1,5,2)|(0,0,0)]^(0)*args%PA(1)-([(1,5,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,2)|(0,0,0)]^(0)-([(0,5,2)|(0,0,0)]^(1))/1/(2p)
        t(172) = (theta(611)-theta(446))*args%rec_p2
        theta(692) = theta(647)*args%PA(1)-theta(482)*args%PC(1)+t(172)*1 ! [(2,4,3)|(0,0,0)]^(0) = [(1,4,3)|(0,0,0)]^(0)*args%PA(1)-([(1,4,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,3)|(0,0,0)]^(0)-([(0,4,3)|(0,0,0)]^(1))/1/(2p)
        t(173) = (theta(612)-theta(447))*args%rec_p2
        theta(693) = theta(648)*args%PA(1)-theta(483)*args%PC(1)+t(173)*1 ! [(2,3,4)|(0,0,0)]^(0) = [(1,3,4)|(0,0,0)]^(0)*args%PA(1)-([(1,3,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,4)|(0,0,0)]^(0)-([(0,3,4)|(0,0,0)]^(1))/1/(2p)
        t(174) = (theta(613)-theta(448))*args%rec_p2
        theta(694) = theta(649)*args%PA(1)-theta(484)*args%PC(1)+t(174)*1 ! [(2,2,5)|(0,0,0)]^(0) = [(1,2,5)|(0,0,0)]^(0)*args%PA(1)-([(1,2,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,5)|(0,0,0)]^(0)-([(0,2,5)|(0,0,0)]^(1))/1/(2p)
        theta(695) = theta(643)*args%PA(2)-theta(478)*args%PC(2) ! [(2,1,6)|(0,0,0)]^(0) = [(2,0,6)|(0,0,0)]^(0)*args%PA(2)-([(2,0,6)|(0,0,0)]^(1)*args%PC(2)
        t(175) = (theta(615)-theta(450))*args%rec_p2
        theta(696) = theta(651)*args%PA(1)-theta(486)*args%PC(1)+t(175)*1 ! [(2,0,7)|(0,0,0)]^(0) = [(1,0,7)|(0,0,0)]^(0)*args%PA(1)-([(1,0,7)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,7)|(0,0,0)]^(0)-([(0,0,7)|(0,0,0)]^(1))/1/(2p)
        theta(697) = theta(652)*args%PA(1)-theta(487)*args%PC(1) ! [(1,8,0)|(0,0,0)]^(0) = [(0,8,0)|(0,0,0)]^(0)*args%PA(1)-([(0,8,0)|(0,0,0)]^(1)*args%PC(1)
        theta(698) = theta(653)*args%PA(1)-theta(488)*args%PC(1) ! [(1,7,1)|(0,0,0)]^(0) = [(0,7,1)|(0,0,0)]^(0)*args%PA(1)-([(0,7,1)|(0,0,0)]^(1)*args%PC(1)
        theta(699) = theta(654)*args%PA(1)-theta(489)*args%PC(1) ! [(1,6,2)|(0,0,0)]^(0) = [(0,6,2)|(0,0,0)]^(0)*args%PA(1)-([(0,6,2)|(0,0,0)]^(1)*args%PC(1)
        theta(700) = theta(655)*args%PA(1)-theta(490)*args%PC(1) ! [(1,5,3)|(0,0,0)]^(0) = [(0,5,3)|(0,0,0)]^(0)*args%PA(1)-([(0,5,3)|(0,0,0)]^(1)*args%PC(1)
        theta(701) = theta(656)*args%PA(1)-theta(491)*args%PC(1) ! [(1,4,4)|(0,0,0)]^(0) = [(0,4,4)|(0,0,0)]^(0)*args%PA(1)-([(0,4,4)|(0,0,0)]^(1)*args%PC(1)
        theta(702) = theta(657)*args%PA(1)-theta(492)*args%PC(1) ! [(1,3,5)|(0,0,0)]^(0) = [(0,3,5)|(0,0,0)]^(0)*args%PA(1)-([(0,3,5)|(0,0,0)]^(1)*args%PC(1)
        theta(703) = theta(658)*args%PA(1)-theta(493)*args%PC(1) ! [(1,2,6)|(0,0,0)]^(0) = [(0,2,6)|(0,0,0)]^(0)*args%PA(1)-([(0,2,6)|(0,0,0)]^(1)*args%PC(1)
        theta(704) = theta(659)*args%PA(1)-theta(494)*args%PC(1) ! [(1,1,7)|(0,0,0)]^(0) = [(0,1,7)|(0,0,0)]^(0)*args%PA(1)-([(0,1,7)|(0,0,0)]^(1)*args%PC(1)
        theta(705) = theta(660)*args%PA(1)-theta(495)*args%PC(1) ! [(1,0,8)|(0,0,0)]^(0) = [(0,0,8)|(0,0,0)]^(0)*args%PA(1)-([(0,0,8)|(0,0,0)]^(1)*args%PC(1)
        theta(706) = theta(652)*args%PA(2)-theta(487)*args%PC(2)+t(170)*8 ! [(0,9,0)|(0,0,0)]^(0) = [(0,8,0)|(0,0,0)]^(0)*args%PA(2)-([(0,8,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,7,0)|(0,0,0)]^(0)-([(0,7,0)|(0,0,0)]^(1))/8/(2p)
        theta(707) = theta(652)*args%PA(3)-theta(487)*args%PC(3) ! [(0,8,1)|(0,0,0)]^(0) = [(0,8,0)|(0,0,0)]^(0)*args%PA(3)-([(0,8,0)|(0,0,0)]^(1)*args%PC(3)
        theta(708) = theta(653)*args%PA(3)-theta(488)*args%PC(3)+t(170)*1 ! [(0,7,2)|(0,0,0)]^(0) = [(0,7,1)|(0,0,0)]^(0)*args%PA(3)-([(0,7,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,7,0)|(0,0,0)]^(0)-([(0,7,0)|(0,0,0)]^(1))/1/(2p)
        t(176) = (theta(609)-theta(444))*args%rec_p2
        theta(709) = theta(654)*args%PA(3)-theta(489)*args%PC(3)+t(176)*2 ! [(0,6,3)|(0,0,0)]^(0) = [(0,6,2)|(0,0,0)]^(0)*args%PA(3)-([(0,6,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,6,1)|(0,0,0)]^(0)-([(0,6,1)|(0,0,0)]^(1))/2/(2p)
        theta(710) = theta(655)*args%PA(3)-theta(490)*args%PC(3)+t(171)*3 ! [(0,5,4)|(0,0,0)]^(0) = [(0,5,3)|(0,0,0)]^(0)*args%PA(3)-([(0,5,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,2)|(0,0,0)]^(0)-([(0,5,2)|(0,0,0)]^(1))/3/(2p)
        theta(711) = theta(657)*args%PA(2)-theta(492)*args%PC(2)+t(174)*3 ! [(0,4,5)|(0,0,0)]^(0) = [(0,3,5)|(0,0,0)]^(0)*args%PA(2)-([(0,3,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,5)|(0,0,0)]^(0)-([(0,2,5)|(0,0,0)]^(1))/3/(2p)
        t(177) = (theta(614)-theta(449))*args%rec_p2
        theta(712) = theta(658)*args%PA(2)-theta(493)*args%PC(2)+t(177)*2 ! [(0,3,6)|(0,0,0)]^(0) = [(0,2,6)|(0,0,0)]^(0)*args%PA(2)-([(0,2,6)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,6)|(0,0,0)]^(0)-([(0,1,6)|(0,0,0)]^(1))/2/(2p)
        theta(713) = theta(659)*args%PA(2)-theta(494)*args%PC(2)+t(175)*1 ! [(0,2,7)|(0,0,0)]^(0) = [(0,1,7)|(0,0,0)]^(0)*args%PA(2)-([(0,1,7)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,7)|(0,0,0)]^(0)-([(0,0,7)|(0,0,0)]^(1))/1/(2p)
        theta(714) = theta(660)*args%PA(2)-theta(495)*args%PC(2) ! [(0,1,8)|(0,0,0)]^(0) = [(0,0,8)|(0,0,0)]^(0)*args%PA(2)-([(0,0,8)|(0,0,0)]^(1)*args%PC(2)
        theta(715) = theta(660)*args%PA(3)-theta(495)*args%PC(3)+t(175)*8 ! [(0,0,9)|(0,0,0)]^(0) = [(0,0,8)|(0,0,0)]^(0)*args%PA(3)-([(0,0,8)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,7)|(0,0,0)]^(0)-([(0,0,7)|(0,0,0)]^(1))/8/(2p)
    end subroutine
    subroutine eanvrr_5_5(args, theta)
        type(eanvrrargs),intent(in) :: args
        real*8,intent(out) :: theta(:)
        real*8 :: t(268)
        ! ================================================
        ! Non-optimized integrals: 1001; Optimized integrals: 732
        theta(1) = args%MABpi*boys(args%pRPC2, 10) ! [(0,0,0)|(0,0,0)]^(10) 
        theta(2) = (theta(1)*args%pRPC2_2+args%MexppRPC2)/19 ! [(0,0,0)|(0,0,0)]^(9) = ([(0,0,0)|(0,0,0)]^(10)*2x+exp(-x))/19
        theta(6) = (theta(2)*args%pRPC2_2+args%MexppRPC2)/17 ! [(0,0,0)|(0,0,0)]^(8) = ([(0,0,0)|(0,0,0)]^(9)*2x+exp(-x))/17
        theta(16) = (theta(6)*args%pRPC2_2+args%MexppRPC2)/15 ! [(0,0,0)|(0,0,0)]^(7) = ([(0,0,0)|(0,0,0)]^(8)*2x+exp(-x))/15
        theta(36) = (theta(16)*args%pRPC2_2+args%MexppRPC2)/13 ! [(0,0,0)|(0,0,0)]^(6) = ([(0,0,0)|(0,0,0)]^(7)*2x+exp(-x))/13
        theta(71) = (theta(36)*args%pRPC2_2+args%MexppRPC2)/11 ! [(0,0,0)|(0,0,0)]^(5) = ([(0,0,0)|(0,0,0)]^(6)*2x+exp(-x))/11
        theta(127) = (theta(71)*args%pRPC2_2+args%MexppRPC2)/9 ! [(0,0,0)|(0,0,0)]^(4) = ([(0,0,0)|(0,0,0)]^(5)*2x+exp(-x))/9
        theta(211) = (theta(127)*args%pRPC2_2+args%MexppRPC2)/7 ! [(0,0,0)|(0,0,0)]^(3) = ([(0,0,0)|(0,0,0)]^(4)*2x+exp(-x))/7
        theta(331) = (theta(211)*args%pRPC2_2+args%MexppRPC2)/5 ! [(0,0,0)|(0,0,0)]^(2) = ([(0,0,0)|(0,0,0)]^(3)*2x+exp(-x))/5
        theta(496) = (theta(331)*args%pRPC2_2+args%MexppRPC2)/3 ! [(0,0,0)|(0,0,0)]^(1) = ([(0,0,0)|(0,0,0)]^(2)*2x+exp(-x))/3
        theta(716) = (theta(496)*args%pRPC2_2+args%MexppRPC2)/1 ! [(0,0,0)|(0,0,0)]^(0) = ([(0,0,0)|(0,0,0)]^(1)*2x+exp(-x))/1
        theta(3) = theta(2)*args%PA(1)-theta(1)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(9) = [(0,0,0)|(0,0,0)]^(9)*args%PA(1)-([(0,0,0)|(0,0,0)]^(10)*args%PC(1)
        theta(4) = theta(2)*args%PA(2)-theta(1)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(9) = [(0,0,0)|(0,0,0)]^(9)*args%PA(2)-([(0,0,0)|(0,0,0)]^(10)*args%PC(2)
        theta(5) = theta(2)*args%PA(3)-theta(1)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(9) = [(0,0,0)|(0,0,0)]^(9)*args%PA(3)-([(0,0,0)|(0,0,0)]^(10)*args%PC(3)
        theta(7) = theta(6)*args%PA(1)-theta(2)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(8) = [(0,0,0)|(0,0,0)]^(8)*args%PA(1)-([(0,0,0)|(0,0,0)]^(9)*args%PC(1)
        theta(8) = theta(6)*args%PA(2)-theta(2)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(8) = [(0,0,0)|(0,0,0)]^(8)*args%PA(2)-([(0,0,0)|(0,0,0)]^(9)*args%PC(2)
        theta(9) = theta(6)*args%PA(3)-theta(2)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(8) = [(0,0,0)|(0,0,0)]^(8)*args%PA(3)-([(0,0,0)|(0,0,0)]^(9)*args%PC(3)
        t(1) = (theta(6)-theta(2))*args%rec_p2
        theta(10) = theta(7)*args%PA(1)-theta(3)*args%PC(1)+t(1)*1 ! [(2,0,0)|(0,0,0)]^(8) = [(1,0,0)|(0,0,0)]^(8)*args%PA(1)-([(1,0,0)|(0,0,0)]^(9)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(8)-([(0,0,0)|(0,0,0)]^(9))/1/(2p)
        ! theta(11) = theta(8)*args%PA(1)-theta(4)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(8) = [(0,1,0)|(0,0,0)]^(8)*args%PA(1)-([(0,1,0)|(0,0,0)]^(9)*args%PC(1)
        ! theta(12) = theta(9)*args%PA(1)-theta(5)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(8) = [(0,0,1)|(0,0,0)]^(8)*args%PA(1)-([(0,0,1)|(0,0,0)]^(9)*args%PC(1)
        theta(13) = theta(8)*args%PA(2)-theta(4)*args%PC(2)+t(1)*1 ! [(0,2,0)|(0,0,0)]^(8) = [(0,1,0)|(0,0,0)]^(8)*args%PA(2)-([(0,1,0)|(0,0,0)]^(9)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(8)-([(0,0,0)|(0,0,0)]^(9))/1/(2p)
        ! theta(14) = theta(9)*args%PA(2)-theta(5)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(8) = [(0,0,1)|(0,0,0)]^(8)*args%PA(2)-([(0,0,1)|(0,0,0)]^(9)*args%PC(2)
        theta(15) = theta(9)*args%PA(3)-theta(5)*args%PC(3)+t(1)*1 ! [(0,0,2)|(0,0,0)]^(8) = [(0,0,1)|(0,0,0)]^(8)*args%PA(3)-([(0,0,1)|(0,0,0)]^(9)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(8)-([(0,0,0)|(0,0,0)]^(9))/1/(2p)
        theta(17) = theta(16)*args%PA(1)-theta(6)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(1)-([(0,0,0)|(0,0,0)]^(8)*args%PC(1)
        theta(18) = theta(16)*args%PA(2)-theta(6)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(2)-([(0,0,0)|(0,0,0)]^(8)*args%PC(2)
        theta(19) = theta(16)*args%PA(3)-theta(6)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(7) = [(0,0,0)|(0,0,0)]^(7)*args%PA(3)-([(0,0,0)|(0,0,0)]^(8)*args%PC(3)
        t(2) = (theta(16)-theta(6))*args%rec_p2
        theta(20) = theta(17)*args%PA(1)-theta(7)*args%PC(1)+t(2)*1 ! [(2,0,0)|(0,0,0)]^(7) = [(1,0,0)|(0,0,0)]^(7)*args%PA(1)-([(1,0,0)|(0,0,0)]^(8)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(7)-([(0,0,0)|(0,0,0)]^(8))/1/(2p)
        ! theta(21) = theta(18)*args%PA(1)-theta(8)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(7) = [(0,1,0)|(0,0,0)]^(7)*args%PA(1)-([(0,1,0)|(0,0,0)]^(8)*args%PC(1)
        ! theta(22) = theta(19)*args%PA(1)-theta(9)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(7) = [(0,0,1)|(0,0,0)]^(7)*args%PA(1)-([(0,0,1)|(0,0,0)]^(8)*args%PC(1)
        theta(23) = theta(18)*args%PA(2)-theta(8)*args%PC(2)+t(2)*1 ! [(0,2,0)|(0,0,0)]^(7) = [(0,1,0)|(0,0,0)]^(7)*args%PA(2)-([(0,1,0)|(0,0,0)]^(8)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(7)-([(0,0,0)|(0,0,0)]^(8))/1/(2p)
        ! theta(24) = theta(19)*args%PA(2)-theta(9)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(7) = [(0,0,1)|(0,0,0)]^(7)*args%PA(2)-([(0,0,1)|(0,0,0)]^(8)*args%PC(2)
        theta(25) = theta(19)*args%PA(3)-theta(9)*args%PC(3)+t(2)*1 ! [(0,0,2)|(0,0,0)]^(7) = [(0,0,1)|(0,0,0)]^(7)*args%PA(3)-([(0,0,1)|(0,0,0)]^(8)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(7)-([(0,0,0)|(0,0,0)]^(8))/1/(2p)
        t(3) = (theta(17)-theta(7))*args%rec_p2
        theta(26) = theta(20)*args%PA(1)-theta(10)*args%PC(1)+t(3)*2 ! [(3,0,0)|(0,0,0)]^(7) = [(2,0,0)|(0,0,0)]^(7)*args%PA(1)-([(2,0,0)|(0,0,0)]^(8)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(7)-([(1,0,0)|(0,0,0)]^(8))/2/(2p)
        ! theta(27) = theta(20)*args%PA(2)-theta(10)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(7) = [(2,0,0)|(0,0,0)]^(7)*args%PA(2)-([(2,0,0)|(0,0,0)]^(8)*args%PC(2)
        ! theta(28) = theta(20)*args%PA(3)-theta(10)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(7) = [(2,0,0)|(0,0,0)]^(7)*args%PA(3)-([(2,0,0)|(0,0,0)]^(8)*args%PC(3)
        ! theta(29) = theta(23)*args%PA(1)-theta(13)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(7) = [(0,2,0)|(0,0,0)]^(7)*args%PA(1)-([(0,2,0)|(0,0,0)]^(8)*args%PC(1)
        ! theta(30) = theta(24)*args%PA(1)-theta(14)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(7) = [(0,1,1)|(0,0,0)]^(7)*args%PA(1)-([(0,1,1)|(0,0,0)]^(8)*args%PC(1)
        ! theta(31) = theta(25)*args%PA(1)-theta(15)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(7) = [(0,0,2)|(0,0,0)]^(7)*args%PA(1)-([(0,0,2)|(0,0,0)]^(8)*args%PC(1)
        t(4) = (theta(18)-theta(8))*args%rec_p2
        theta(32) = theta(23)*args%PA(2)-theta(13)*args%PC(2)+t(4)*2 ! [(0,3,0)|(0,0,0)]^(7) = [(0,2,0)|(0,0,0)]^(7)*args%PA(2)-([(0,2,0)|(0,0,0)]^(8)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(7)-([(0,1,0)|(0,0,0)]^(8))/2/(2p)
        ! theta(33) = theta(23)*args%PA(3)-theta(13)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(7) = [(0,2,0)|(0,0,0)]^(7)*args%PA(3)-([(0,2,0)|(0,0,0)]^(8)*args%PC(3)
        theta(34) = theta(25)*args%PA(2)-theta(15)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(7) = [(0,0,2)|(0,0,0)]^(7)*args%PA(2)-([(0,0,2)|(0,0,0)]^(8)*args%PC(2)
        t(5) = (theta(19)-theta(9))*args%rec_p2
        theta(35) = theta(25)*args%PA(3)-theta(15)*args%PC(3)+t(5)*2 ! [(0,0,3)|(0,0,0)]^(7) = [(0,0,2)|(0,0,0)]^(7)*args%PA(3)-([(0,0,2)|(0,0,0)]^(8)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(7)-([(0,0,1)|(0,0,0)]^(8))/2/(2p)
        theta(37) = theta(36)*args%PA(1)-theta(16)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(1)-([(0,0,0)|(0,0,0)]^(7)*args%PC(1)
        theta(38) = theta(36)*args%PA(2)-theta(16)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(2)-([(0,0,0)|(0,0,0)]^(7)*args%PC(2)
        theta(39) = theta(36)*args%PA(3)-theta(16)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(6) = [(0,0,0)|(0,0,0)]^(6)*args%PA(3)-([(0,0,0)|(0,0,0)]^(7)*args%PC(3)
        t(6) = (theta(36)-theta(16))*args%rec_p2
        theta(40) = theta(37)*args%PA(1)-theta(17)*args%PC(1)+t(6)*1 ! [(2,0,0)|(0,0,0)]^(6) = [(1,0,0)|(0,0,0)]^(6)*args%PA(1)-([(1,0,0)|(0,0,0)]^(7)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(41) = theta(38)*args%PA(1)-theta(18)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(1)-([(0,1,0)|(0,0,0)]^(7)*args%PC(1)
        ! theta(42) = theta(39)*args%PA(1)-theta(19)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(1)-([(0,0,1)|(0,0,0)]^(7)*args%PC(1)
        theta(43) = theta(38)*args%PA(2)-theta(18)*args%PC(2)+t(6)*1 ! [(0,2,0)|(0,0,0)]^(6) = [(0,1,0)|(0,0,0)]^(6)*args%PA(2)-([(0,1,0)|(0,0,0)]^(7)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(44) = theta(39)*args%PA(2)-theta(19)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(2)-([(0,0,1)|(0,0,0)]^(7)*args%PC(2)
        theta(45) = theta(39)*args%PA(3)-theta(19)*args%PC(3)+t(6)*1 ! [(0,0,2)|(0,0,0)]^(6) = [(0,0,1)|(0,0,0)]^(6)*args%PA(3)-([(0,0,1)|(0,0,0)]^(7)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(6)-([(0,0,0)|(0,0,0)]^(7))/1/(2p)
        t(7) = (theta(37)-theta(17))*args%rec_p2
        theta(46) = theta(40)*args%PA(1)-theta(20)*args%PC(1)+t(7)*2 ! [(3,0,0)|(0,0,0)]^(6) = [(2,0,0)|(0,0,0)]^(6)*args%PA(1)-([(2,0,0)|(0,0,0)]^(7)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(6)-([(1,0,0)|(0,0,0)]^(7))/2/(2p)
        ! theta(47) = theta(40)*args%PA(2)-theta(20)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(6) = [(2,0,0)|(0,0,0)]^(6)*args%PA(2)-([(2,0,0)|(0,0,0)]^(7)*args%PC(2)
        ! theta(48) = theta(40)*args%PA(3)-theta(20)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(6) = [(2,0,0)|(0,0,0)]^(6)*args%PA(3)-([(2,0,0)|(0,0,0)]^(7)*args%PC(3)
        ! theta(49) = theta(43)*args%PA(1)-theta(23)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(6) = [(0,2,0)|(0,0,0)]^(6)*args%PA(1)-([(0,2,0)|(0,0,0)]^(7)*args%PC(1)
        ! theta(50) = theta(44)*args%PA(1)-theta(24)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(6) = [(0,1,1)|(0,0,0)]^(6)*args%PA(1)-([(0,1,1)|(0,0,0)]^(7)*args%PC(1)
        ! theta(51) = theta(45)*args%PA(1)-theta(25)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(6) = [(0,0,2)|(0,0,0)]^(6)*args%PA(1)-([(0,0,2)|(0,0,0)]^(7)*args%PC(1)
        t(8) = (theta(38)-theta(18))*args%rec_p2
        theta(52) = theta(43)*args%PA(2)-theta(23)*args%PC(2)+t(8)*2 ! [(0,3,0)|(0,0,0)]^(6) = [(0,2,0)|(0,0,0)]^(6)*args%PA(2)-([(0,2,0)|(0,0,0)]^(7)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(6)-([(0,1,0)|(0,0,0)]^(7))/2/(2p)
        ! theta(53) = theta(43)*args%PA(3)-theta(23)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(6) = [(0,2,0)|(0,0,0)]^(6)*args%PA(3)-([(0,2,0)|(0,0,0)]^(7)*args%PC(3)
        theta(54) = theta(45)*args%PA(2)-theta(25)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(6) = [(0,0,2)|(0,0,0)]^(6)*args%PA(2)-([(0,0,2)|(0,0,0)]^(7)*args%PC(2)
        t(9) = (theta(39)-theta(19))*args%rec_p2
        theta(55) = theta(45)*args%PA(3)-theta(25)*args%PC(3)+t(9)*2 ! [(0,0,3)|(0,0,0)]^(6) = [(0,0,2)|(0,0,0)]^(6)*args%PA(3)-([(0,0,2)|(0,0,0)]^(7)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(6)-([(0,0,1)|(0,0,0)]^(7))/2/(2p)
        t(10) = (theta(40)-theta(20))*args%rec_p2
        theta(56) = theta(46)*args%PA(1)-theta(26)*args%PC(1)+t(10)*3 ! [(4,0,0)|(0,0,0)]^(6) = [(3,0,0)|(0,0,0)]^(6)*args%PA(1)-([(3,0,0)|(0,0,0)]^(7)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(6)-([(2,0,0)|(0,0,0)]^(7))/3/(2p)
        ! theta(57) = theta(46)*args%PA(2)-theta(26)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(6) = [(3,0,0)|(0,0,0)]^(6)*args%PA(2)-([(3,0,0)|(0,0,0)]^(7)*args%PC(2)
        ! theta(58) = theta(46)*args%PA(3)-theta(26)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(6) = [(3,0,0)|(0,0,0)]^(6)*args%PA(3)-([(3,0,0)|(0,0,0)]^(7)*args%PC(3)
        ! theta(59) = theta(49)*args%PA(1)-theta(29)*args%PC(1)+(theta(43)-theta(23))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(6) = [(1,2,0)|(0,0,0)]^(6)*args%PA(1)-([(1,2,0)|(0,0,0)]^(7)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(6)-([(0,2,0)|(0,0,0)]^(7))/1/(2p)
        ! theta(60) = theta(48)*args%PA(2)-theta(28)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(6) = [(2,0,1)|(0,0,0)]^(6)*args%PA(2)-([(2,0,1)|(0,0,0)]^(7)*args%PC(2)
        ! theta(61) = theta(51)*args%PA(1)-theta(31)*args%PC(1)+(theta(45)-theta(25))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(6) = [(1,0,2)|(0,0,0)]^(6)*args%PA(1)-([(1,0,2)|(0,0,0)]^(7)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(6)-([(0,0,2)|(0,0,0)]^(7))/1/(2p)
        ! theta(62) = theta(52)*args%PA(1)-theta(32)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(6) = [(0,3,0)|(0,0,0)]^(6)*args%PA(1)-([(0,3,0)|(0,0,0)]^(7)*args%PC(1)
        ! theta(63) = theta(53)*args%PA(1)-theta(33)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(6) = [(0,2,1)|(0,0,0)]^(6)*args%PA(1)-([(0,2,1)|(0,0,0)]^(7)*args%PC(1)
        ! theta(64) = theta(54)*args%PA(1)-theta(34)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(6) = [(0,1,2)|(0,0,0)]^(6)*args%PA(1)-([(0,1,2)|(0,0,0)]^(7)*args%PC(1)
        ! theta(65) = theta(55)*args%PA(1)-theta(35)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(6) = [(0,0,3)|(0,0,0)]^(6)*args%PA(1)-([(0,0,3)|(0,0,0)]^(7)*args%PC(1)
        t(11) = (theta(43)-theta(23))*args%rec_p2
        theta(66) = theta(52)*args%PA(2)-theta(32)*args%PC(2)+t(11)*3 ! [(0,4,0)|(0,0,0)]^(6) = [(0,3,0)|(0,0,0)]^(6)*args%PA(2)-([(0,3,0)|(0,0,0)]^(7)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(6)-([(0,2,0)|(0,0,0)]^(7))/3/(2p)
        theta(67) = theta(52)*args%PA(3)-theta(32)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(6) = [(0,3,0)|(0,0,0)]^(6)*args%PA(3)-([(0,3,0)|(0,0,0)]^(7)*args%PC(3)
        t(12) = (theta(45)-theta(25))*args%rec_p2
        theta(68) = theta(54)*args%PA(2)-theta(34)*args%PC(2)+t(12)*1 ! [(0,2,2)|(0,0,0)]^(6) = [(0,1,2)|(0,0,0)]^(6)*args%PA(2)-([(0,1,2)|(0,0,0)]^(7)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(6)-([(0,0,2)|(0,0,0)]^(7))/1/(2p)
        theta(69) = theta(55)*args%PA(2)-theta(35)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(6) = [(0,0,3)|(0,0,0)]^(6)*args%PA(2)-([(0,0,3)|(0,0,0)]^(7)*args%PC(2)
        theta(70) = theta(55)*args%PA(3)-theta(35)*args%PC(3)+t(12)*3 ! [(0,0,4)|(0,0,0)]^(6) = [(0,0,3)|(0,0,0)]^(6)*args%PA(3)-([(0,0,3)|(0,0,0)]^(7)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(6)-([(0,0,2)|(0,0,0)]^(7))/3/(2p)
        theta(72) = theta(71)*args%PA(1)-theta(36)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(1)-([(0,0,0)|(0,0,0)]^(6)*args%PC(1)
        theta(73) = theta(71)*args%PA(2)-theta(36)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(2)-([(0,0,0)|(0,0,0)]^(6)*args%PC(2)
        theta(74) = theta(71)*args%PA(3)-theta(36)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(5) = [(0,0,0)|(0,0,0)]^(5)*args%PA(3)-([(0,0,0)|(0,0,0)]^(6)*args%PC(3)
        t(13) = (theta(71)-theta(36))*args%rec_p2
        theta(75) = theta(72)*args%PA(1)-theta(37)*args%PC(1)+t(13)*1 ! [(2,0,0)|(0,0,0)]^(5) = [(1,0,0)|(0,0,0)]^(5)*args%PA(1)-([(1,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(76) = theta(73)*args%PA(1)-theta(38)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(1)-([(0,1,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(77) = theta(74)*args%PA(1)-theta(39)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(1)-([(0,0,1)|(0,0,0)]^(6)*args%PC(1)
        theta(78) = theta(73)*args%PA(2)-theta(38)*args%PC(2)+t(13)*1 ! [(0,2,0)|(0,0,0)]^(5) = [(0,1,0)|(0,0,0)]^(5)*args%PA(2)-([(0,1,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(79) = theta(74)*args%PA(2)-theta(39)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(2)-([(0,0,1)|(0,0,0)]^(6)*args%PC(2)
        theta(80) = theta(74)*args%PA(3)-theta(39)*args%PC(3)+t(13)*1 ! [(0,0,2)|(0,0,0)]^(5) = [(0,0,1)|(0,0,0)]^(5)*args%PA(3)-([(0,0,1)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(5)-([(0,0,0)|(0,0,0)]^(6))/1/(2p)
        t(14) = (theta(72)-theta(37))*args%rec_p2
        theta(81) = theta(75)*args%PA(1)-theta(40)*args%PC(1)+t(14)*2 ! [(3,0,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(1)-([(2,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(5)-([(1,0,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(82) = theta(75)*args%PA(2)-theta(40)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(2)-([(2,0,0)|(0,0,0)]^(6)*args%PC(2)
        ! theta(83) = theta(75)*args%PA(3)-theta(40)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(5) = [(2,0,0)|(0,0,0)]^(5)*args%PA(3)-([(2,0,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(84) = theta(78)*args%PA(1)-theta(43)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(1)-([(0,2,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(85) = theta(79)*args%PA(1)-theta(44)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(5) = [(0,1,1)|(0,0,0)]^(5)*args%PA(1)-([(0,1,1)|(0,0,0)]^(6)*args%PC(1)
        ! theta(86) = theta(80)*args%PA(1)-theta(45)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(1)-([(0,0,2)|(0,0,0)]^(6)*args%PC(1)
        t(15) = (theta(73)-theta(38))*args%rec_p2
        theta(87) = theta(78)*args%PA(2)-theta(43)*args%PC(2)+t(15)*2 ! [(0,3,0)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(2)-([(0,2,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(5)-([(0,1,0)|(0,0,0)]^(6))/2/(2p)
        ! theta(88) = theta(78)*args%PA(3)-theta(43)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(5) = [(0,2,0)|(0,0,0)]^(5)*args%PA(3)-([(0,2,0)|(0,0,0)]^(6)*args%PC(3)
        theta(89) = theta(80)*args%PA(2)-theta(45)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(2)-([(0,0,2)|(0,0,0)]^(6)*args%PC(2)
        t(16) = (theta(74)-theta(39))*args%rec_p2
        theta(90) = theta(80)*args%PA(3)-theta(45)*args%PC(3)+t(16)*2 ! [(0,0,3)|(0,0,0)]^(5) = [(0,0,2)|(0,0,0)]^(5)*args%PA(3)-([(0,0,2)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(5)-([(0,0,1)|(0,0,0)]^(6))/2/(2p)
        t(17) = (theta(75)-theta(40))*args%rec_p2
        theta(91) = theta(81)*args%PA(1)-theta(46)*args%PC(1)+t(17)*3 ! [(4,0,0)|(0,0,0)]^(5) = [(3,0,0)|(0,0,0)]^(5)*args%PA(1)-([(3,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(5)-([(2,0,0)|(0,0,0)]^(6))/3/(2p)
        ! theta(92) = theta(81)*args%PA(2)-theta(46)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(5) = [(3,0,0)|(0,0,0)]^(5)*args%PA(2)-([(3,0,0)|(0,0,0)]^(6)*args%PC(2)
        ! theta(93) = theta(81)*args%PA(3)-theta(46)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(5) = [(3,0,0)|(0,0,0)]^(5)*args%PA(3)-([(3,0,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(94) = theta(84)*args%PA(1)-theta(49)*args%PC(1)+(theta(78)-theta(43))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(5) = [(1,2,0)|(0,0,0)]^(5)*args%PA(1)-([(1,2,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(5)-([(0,2,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(95) = theta(83)*args%PA(2)-theta(48)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(5) = [(2,0,1)|(0,0,0)]^(5)*args%PA(2)-([(2,0,1)|(0,0,0)]^(6)*args%PC(2)
        ! theta(96) = theta(86)*args%PA(1)-theta(51)*args%PC(1)+(theta(80)-theta(45))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(5) = [(1,0,2)|(0,0,0)]^(5)*args%PA(1)-([(1,0,2)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(5)-([(0,0,2)|(0,0,0)]^(6))/1/(2p)
        ! theta(97) = theta(87)*args%PA(1)-theta(52)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(5) = [(0,3,0)|(0,0,0)]^(5)*args%PA(1)-([(0,3,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(98) = theta(88)*args%PA(1)-theta(53)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(5) = [(0,2,1)|(0,0,0)]^(5)*args%PA(1)-([(0,2,1)|(0,0,0)]^(6)*args%PC(1)
        ! theta(99) = theta(89)*args%PA(1)-theta(54)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(5) = [(0,1,2)|(0,0,0)]^(5)*args%PA(1)-([(0,1,2)|(0,0,0)]^(6)*args%PC(1)
        ! theta(100) = theta(90)*args%PA(1)-theta(55)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(5) = [(0,0,3)|(0,0,0)]^(5)*args%PA(1)-([(0,0,3)|(0,0,0)]^(6)*args%PC(1)
        t(18) = (theta(78)-theta(43))*args%rec_p2
        theta(101) = theta(87)*args%PA(2)-theta(52)*args%PC(2)+t(18)*3 ! [(0,4,0)|(0,0,0)]^(5) = [(0,3,0)|(0,0,0)]^(5)*args%PA(2)-([(0,3,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(5)-([(0,2,0)|(0,0,0)]^(6))/3/(2p)
        theta(102) = theta(87)*args%PA(3)-theta(52)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(5) = [(0,3,0)|(0,0,0)]^(5)*args%PA(3)-([(0,3,0)|(0,0,0)]^(6)*args%PC(3)
        t(19) = (theta(80)-theta(45))*args%rec_p2
        theta(103) = theta(89)*args%PA(2)-theta(54)*args%PC(2)+t(19)*1 ! [(0,2,2)|(0,0,0)]^(5) = [(0,1,2)|(0,0,0)]^(5)*args%PA(2)-([(0,1,2)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(5)-([(0,0,2)|(0,0,0)]^(6))/1/(2p)
        theta(104) = theta(90)*args%PA(2)-theta(55)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(5) = [(0,0,3)|(0,0,0)]^(5)*args%PA(2)-([(0,0,3)|(0,0,0)]^(6)*args%PC(2)
        theta(105) = theta(90)*args%PA(3)-theta(55)*args%PC(3)+t(19)*3 ! [(0,0,4)|(0,0,0)]^(5) = [(0,0,3)|(0,0,0)]^(5)*args%PA(3)-([(0,0,3)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(5)-([(0,0,2)|(0,0,0)]^(6))/3/(2p)
        t(20) = (theta(81)-theta(46))*args%rec_p2
        theta(106) = theta(91)*args%PA(1)-theta(56)*args%PC(1)+t(20)*4 ! [(5,0,0)|(0,0,0)]^(5) = [(4,0,0)|(0,0,0)]^(5)*args%PA(1)-([(4,0,0)|(0,0,0)]^(6)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(5)-([(3,0,0)|(0,0,0)]^(6))/4/(2p)
        ! theta(107) = theta(91)*args%PA(2)-theta(56)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(5) = [(4,0,0)|(0,0,0)]^(5)*args%PA(2)-([(4,0,0)|(0,0,0)]^(6)*args%PC(2)
        ! theta(108) = theta(91)*args%PA(3)-theta(56)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(5) = [(4,0,0)|(0,0,0)]^(5)*args%PA(3)-([(4,0,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(109) = theta(92)*args%PA(2)-theta(57)*args%PC(2)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(5) = [(3,1,0)|(0,0,0)]^(5)*args%PA(2)-([(3,1,0)|(0,0,0)]^(6)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(5)-([(3,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(110) = theta(93)*args%PA(2)-theta(58)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(5) = [(3,0,1)|(0,0,0)]^(5)*args%PA(2)-([(3,0,1)|(0,0,0)]^(6)*args%PC(2)
        ! theta(111) = theta(93)*args%PA(3)-theta(58)*args%PC(3)+(theta(81)-theta(46))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(5) = [(3,0,1)|(0,0,0)]^(5)*args%PA(3)-([(3,0,1)|(0,0,0)]^(6)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(5)-([(3,0,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(112) = theta(97)*args%PA(1)-theta(62)*args%PC(1)+(theta(87)-theta(52))*args%rec_p2*1 ! [(2,3,0)|(0,0,0)]^(5) = [(1,3,0)|(0,0,0)]^(5)*args%PA(1)-([(1,3,0)|(0,0,0)]^(6)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(5)-([(0,3,0)|(0,0,0)]^(6))/1/(2p)
        ! theta(113) = theta(94)*args%PA(3)-theta(59)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(5) = [(2,2,0)|(0,0,0)]^(5)*args%PA(3)-([(2,2,0)|(0,0,0)]^(6)*args%PC(3)
        ! theta(114) = theta(96)*args%PA(2)-theta(61)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(5) = [(2,0,2)|(0,0,0)]^(5)*args%PA(2)-([(2,0,2)|(0,0,0)]^(6)*args%PC(2)
        ! theta(115) = theta(100)*args%PA(1)-theta(65)*args%PC(1)+(theta(90)-theta(55))*args%rec_p2*1 ! [(2,0,3)|(0,0,0)]^(5) = [(1,0,3)|(0,0,0)]^(5)*args%PA(1)-([(1,0,3)|(0,0,0)]^(6)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(5)-([(0,0,3)|(0,0,0)]^(6))/1/(2p)
        ! theta(116) = theta(101)*args%PA(1)-theta(66)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(5) = [(0,4,0)|(0,0,0)]^(5)*args%PA(1)-([(0,4,0)|(0,0,0)]^(6)*args%PC(1)
        ! theta(117) = theta(102)*args%PA(1)-theta(67)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(5) = [(0,3,1)|(0,0,0)]^(5)*args%PA(1)-([(0,3,1)|(0,0,0)]^(6)*args%PC(1)
        theta(118) = theta(103)*args%PA(1)-theta(68)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(5) = [(0,2,2)|(0,0,0)]^(5)*args%PA(1)-([(0,2,2)|(0,0,0)]^(6)*args%PC(1)
        ! theta(119) = theta(104)*args%PA(1)-theta(69)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(5) = [(0,1,3)|(0,0,0)]^(5)*args%PA(1)-([(0,1,3)|(0,0,0)]^(6)*args%PC(1)
        ! theta(120) = theta(105)*args%PA(1)-theta(70)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(5) = [(0,0,4)|(0,0,0)]^(5)*args%PA(1)-([(0,0,4)|(0,0,0)]^(6)*args%PC(1)
        t(21) = (theta(87)-theta(52))*args%rec_p2
        theta(121) = theta(101)*args%PA(2)-theta(66)*args%PC(2)+t(21)*4 ! [(0,5,0)|(0,0,0)]^(5) = [(0,4,0)|(0,0,0)]^(5)*args%PA(2)-([(0,4,0)|(0,0,0)]^(6)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(5)-([(0,3,0)|(0,0,0)]^(6))/4/(2p)
        theta(122) = theta(101)*args%PA(3)-theta(66)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(5) = [(0,4,0)|(0,0,0)]^(5)*args%PA(3)-([(0,4,0)|(0,0,0)]^(6)*args%PC(3)
        theta(123) = theta(102)*args%PA(3)-theta(67)*args%PC(3)+t(21)*1 ! [(0,3,2)|(0,0,0)]^(5) = [(0,3,1)|(0,0,0)]^(5)*args%PA(3)-([(0,3,1)|(0,0,0)]^(6)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(5)-([(0,3,0)|(0,0,0)]^(6))/1/(2p)
        t(22) = (theta(90)-theta(55))*args%rec_p2
        theta(124) = theta(104)*args%PA(2)-theta(69)*args%PC(2)+t(22)*1 ! [(0,2,3)|(0,0,0)]^(5) = [(0,1,3)|(0,0,0)]^(5)*args%PA(2)-([(0,1,3)|(0,0,0)]^(6)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(5)-([(0,0,3)|(0,0,0)]^(6))/1/(2p)
        theta(125) = theta(105)*args%PA(2)-theta(70)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(5) = [(0,0,4)|(0,0,0)]^(5)*args%PA(2)-([(0,0,4)|(0,0,0)]^(6)*args%PC(2)
        theta(126) = theta(105)*args%PA(3)-theta(70)*args%PC(3)+t(22)*4 ! [(0,0,5)|(0,0,0)]^(5) = [(0,0,4)|(0,0,0)]^(5)*args%PA(3)-([(0,0,4)|(0,0,0)]^(6)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(5)-([(0,0,3)|(0,0,0)]^(6))/4/(2p)
        theta(128) = theta(127)*args%PA(1)-theta(71)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(1)-([(0,0,0)|(0,0,0)]^(5)*args%PC(1)
        theta(129) = theta(127)*args%PA(2)-theta(71)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(2)-([(0,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(130) = theta(127)*args%PA(3)-theta(71)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(4) = [(0,0,0)|(0,0,0)]^(4)*args%PA(3)-([(0,0,0)|(0,0,0)]^(5)*args%PC(3)
        t(23) = (theta(127)-theta(71))*args%rec_p2
        theta(131) = theta(128)*args%PA(1)-theta(72)*args%PC(1)+t(23)*1 ! [(2,0,0)|(0,0,0)]^(4) = [(1,0,0)|(0,0,0)]^(4)*args%PA(1)-([(1,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(132) = theta(129)*args%PA(1)-theta(73)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(1)-([(0,1,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(133) = theta(130)*args%PA(1)-theta(74)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(1)-([(0,0,1)|(0,0,0)]^(5)*args%PC(1)
        theta(134) = theta(129)*args%PA(2)-theta(73)*args%PC(2)+t(23)*1 ! [(0,2,0)|(0,0,0)]^(4) = [(0,1,0)|(0,0,0)]^(4)*args%PA(2)-([(0,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(135) = theta(130)*args%PA(2)-theta(74)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(2)-([(0,0,1)|(0,0,0)]^(5)*args%PC(2)
        theta(136) = theta(130)*args%PA(3)-theta(74)*args%PC(3)+t(23)*1 ! [(0,0,2)|(0,0,0)]^(4) = [(0,0,1)|(0,0,0)]^(4)*args%PA(3)-([(0,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(4)-([(0,0,0)|(0,0,0)]^(5))/1/(2p)
        t(24) = (theta(128)-theta(72))*args%rec_p2
        theta(137) = theta(131)*args%PA(1)-theta(75)*args%PC(1)+t(24)*2 ! [(3,0,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(1)-([(2,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(4)-([(1,0,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(138) = theta(131)*args%PA(2)-theta(75)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(2)-([(2,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(139) = theta(131)*args%PA(3)-theta(75)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(4) = [(2,0,0)|(0,0,0)]^(4)*args%PA(3)-([(2,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(140) = theta(134)*args%PA(1)-theta(78)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(1)-([(0,2,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(141) = theta(135)*args%PA(1)-theta(79)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(4) = [(0,1,1)|(0,0,0)]^(4)*args%PA(1)-([(0,1,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(142) = theta(136)*args%PA(1)-theta(80)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(1)-([(0,0,2)|(0,0,0)]^(5)*args%PC(1)
        t(25) = (theta(129)-theta(73))*args%rec_p2
        theta(143) = theta(134)*args%PA(2)-theta(78)*args%PC(2)+t(25)*2 ! [(0,3,0)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(2)-([(0,2,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(4)-([(0,1,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(144) = theta(134)*args%PA(3)-theta(78)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(4) = [(0,2,0)|(0,0,0)]^(4)*args%PA(3)-([(0,2,0)|(0,0,0)]^(5)*args%PC(3)
        theta(145) = theta(136)*args%PA(2)-theta(80)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(2)-([(0,0,2)|(0,0,0)]^(5)*args%PC(2)
        t(26) = (theta(130)-theta(74))*args%rec_p2
        theta(146) = theta(136)*args%PA(3)-theta(80)*args%PC(3)+t(26)*2 ! [(0,0,3)|(0,0,0)]^(4) = [(0,0,2)|(0,0,0)]^(4)*args%PA(3)-([(0,0,2)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(4)-([(0,0,1)|(0,0,0)]^(5))/2/(2p)
        t(27) = (theta(131)-theta(75))*args%rec_p2
        theta(147) = theta(137)*args%PA(1)-theta(81)*args%PC(1)+t(27)*3 ! [(4,0,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(1)-([(3,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(4)-([(2,0,0)|(0,0,0)]^(5))/3/(2p)
        ! theta(148) = theta(137)*args%PA(2)-theta(81)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(2)-([(3,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(149) = theta(137)*args%PA(3)-theta(81)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(4) = [(3,0,0)|(0,0,0)]^(4)*args%PA(3)-([(3,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(150) = theta(140)*args%PA(1)-theta(84)*args%PC(1)+(theta(134)-theta(78))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(4) = [(1,2,0)|(0,0,0)]^(4)*args%PA(1)-([(1,2,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(151) = theta(139)*args%PA(2)-theta(83)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(4) = [(2,0,1)|(0,0,0)]^(4)*args%PA(2)-([(2,0,1)|(0,0,0)]^(5)*args%PC(2)
        ! theta(152) = theta(142)*args%PA(1)-theta(86)*args%PC(1)+(theta(136)-theta(80))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(4) = [(1,0,2)|(0,0,0)]^(4)*args%PA(1)-([(1,0,2)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        ! theta(153) = theta(143)*args%PA(1)-theta(87)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(1)-([(0,3,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(154) = theta(144)*args%PA(1)-theta(88)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(4) = [(0,2,1)|(0,0,0)]^(4)*args%PA(1)-([(0,2,1)|(0,0,0)]^(5)*args%PC(1)
        ! theta(155) = theta(145)*args%PA(1)-theta(89)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(1)-([(0,1,2)|(0,0,0)]^(5)*args%PC(1)
        ! theta(156) = theta(146)*args%PA(1)-theta(90)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(1)-([(0,0,3)|(0,0,0)]^(5)*args%PC(1)
        t(28) = (theta(134)-theta(78))*args%rec_p2
        theta(157) = theta(143)*args%PA(2)-theta(87)*args%PC(2)+t(28)*3 ! [(0,4,0)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(2)-([(0,3,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(4)-([(0,2,0)|(0,0,0)]^(5))/3/(2p)
        theta(158) = theta(143)*args%PA(3)-theta(87)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(4) = [(0,3,0)|(0,0,0)]^(4)*args%PA(3)-([(0,3,0)|(0,0,0)]^(5)*args%PC(3)
        t(29) = (theta(136)-theta(80))*args%rec_p2
        theta(159) = theta(145)*args%PA(2)-theta(89)*args%PC(2)+t(29)*1 ! [(0,2,2)|(0,0,0)]^(4) = [(0,1,2)|(0,0,0)]^(4)*args%PA(2)-([(0,1,2)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/1/(2p)
        theta(160) = theta(146)*args%PA(2)-theta(90)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(2)-([(0,0,3)|(0,0,0)]^(5)*args%PC(2)
        theta(161) = theta(146)*args%PA(3)-theta(90)*args%PC(3)+t(29)*3 ! [(0,0,4)|(0,0,0)]^(4) = [(0,0,3)|(0,0,0)]^(4)*args%PA(3)-([(0,0,3)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(4)-([(0,0,2)|(0,0,0)]^(5))/3/(2p)
        t(30) = (theta(137)-theta(81))*args%rec_p2
        theta(162) = theta(147)*args%PA(1)-theta(91)*args%PC(1)+t(30)*4 ! [(5,0,0)|(0,0,0)]^(4) = [(4,0,0)|(0,0,0)]^(4)*args%PA(1)-([(4,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(4)-([(3,0,0)|(0,0,0)]^(5))/4/(2p)
        ! theta(163) = theta(147)*args%PA(2)-theta(91)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(4) = [(4,0,0)|(0,0,0)]^(4)*args%PA(2)-([(4,0,0)|(0,0,0)]^(5)*args%PC(2)
        ! theta(164) = theta(147)*args%PA(3)-theta(91)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(4) = [(4,0,0)|(0,0,0)]^(4)*args%PA(3)-([(4,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(165) = theta(148)*args%PA(2)-theta(92)*args%PC(2)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(4) = [(3,1,0)|(0,0,0)]^(4)*args%PA(2)-([(3,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(4)-([(3,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(166) = theta(149)*args%PA(2)-theta(93)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(4) = [(3,0,1)|(0,0,0)]^(4)*args%PA(2)-([(3,0,1)|(0,0,0)]^(5)*args%PC(2)
        ! theta(167) = theta(149)*args%PA(3)-theta(93)*args%PC(3)+(theta(137)-theta(81))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(4) = [(3,0,1)|(0,0,0)]^(4)*args%PA(3)-([(3,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(4)-([(3,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(168) = theta(153)*args%PA(1)-theta(97)*args%PC(1)+(theta(143)-theta(87))*args%rec_p2*1 ! [(2,3,0)|(0,0,0)]^(4) = [(1,3,0)|(0,0,0)]^(4)*args%PA(1)-([(1,3,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(4)-([(0,3,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(169) = theta(150)*args%PA(3)-theta(94)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(4) = [(2,2,0)|(0,0,0)]^(4)*args%PA(3)-([(2,2,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(170) = theta(152)*args%PA(2)-theta(96)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(4) = [(2,0,2)|(0,0,0)]^(4)*args%PA(2)-([(2,0,2)|(0,0,0)]^(5)*args%PC(2)
        ! theta(171) = theta(156)*args%PA(1)-theta(100)*args%PC(1)+(theta(146)-theta(90))*args%rec_p2*1 ! [(2,0,3)|(0,0,0)]^(4) = [(1,0,3)|(0,0,0)]^(4)*args%PA(1)-([(1,0,3)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(4)-([(0,0,3)|(0,0,0)]^(5))/1/(2p)
        theta(172) = theta(157)*args%PA(1)-theta(101)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(4) = [(0,4,0)|(0,0,0)]^(4)*args%PA(1)-([(0,4,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(173) = theta(158)*args%PA(1)-theta(102)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(4) = [(0,3,1)|(0,0,0)]^(4)*args%PA(1)-([(0,3,1)|(0,0,0)]^(5)*args%PC(1)
        theta(174) = theta(159)*args%PA(1)-theta(103)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(4) = [(0,2,2)|(0,0,0)]^(4)*args%PA(1)-([(0,2,2)|(0,0,0)]^(5)*args%PC(1)
        ! theta(175) = theta(160)*args%PA(1)-theta(104)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(4) = [(0,1,3)|(0,0,0)]^(4)*args%PA(1)-([(0,1,3)|(0,0,0)]^(5)*args%PC(1)
        theta(176) = theta(161)*args%PA(1)-theta(105)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(4) = [(0,0,4)|(0,0,0)]^(4)*args%PA(1)-([(0,0,4)|(0,0,0)]^(5)*args%PC(1)
        t(31) = (theta(143)-theta(87))*args%rec_p2
        theta(177) = theta(157)*args%PA(2)-theta(101)*args%PC(2)+t(31)*4 ! [(0,5,0)|(0,0,0)]^(4) = [(0,4,0)|(0,0,0)]^(4)*args%PA(2)-([(0,4,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(4)-([(0,3,0)|(0,0,0)]^(5))/4/(2p)
        theta(178) = theta(157)*args%PA(3)-theta(101)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(4) = [(0,4,0)|(0,0,0)]^(4)*args%PA(3)-([(0,4,0)|(0,0,0)]^(5)*args%PC(3)
        theta(179) = theta(158)*args%PA(3)-theta(102)*args%PC(3)+t(31)*1 ! [(0,3,2)|(0,0,0)]^(4) = [(0,3,1)|(0,0,0)]^(4)*args%PA(3)-([(0,3,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(4)-([(0,3,0)|(0,0,0)]^(5))/1/(2p)
        t(32) = (theta(146)-theta(90))*args%rec_p2
        theta(180) = theta(160)*args%PA(2)-theta(104)*args%PC(2)+t(32)*1 ! [(0,2,3)|(0,0,0)]^(4) = [(0,1,3)|(0,0,0)]^(4)*args%PA(2)-([(0,1,3)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(4)-([(0,0,3)|(0,0,0)]^(5))/1/(2p)
        theta(181) = theta(161)*args%PA(2)-theta(105)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(4) = [(0,0,4)|(0,0,0)]^(4)*args%PA(2)-([(0,0,4)|(0,0,0)]^(5)*args%PC(2)
        theta(182) = theta(161)*args%PA(3)-theta(105)*args%PC(3)+t(32)*4 ! [(0,0,5)|(0,0,0)]^(4) = [(0,0,4)|(0,0,0)]^(4)*args%PA(3)-([(0,0,4)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(4)-([(0,0,3)|(0,0,0)]^(5))/4/(2p)
        t(33) = (theta(147)-theta(91))*args%rec_p2
        theta(183) = theta(162)*args%PA(1)-theta(106)*args%PC(1)+t(33)*5 ! [(6,0,0)|(0,0,0)]^(4) = [(5,0,0)|(0,0,0)]^(4)*args%PA(1)-([(5,0,0)|(0,0,0)]^(5)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(4)-([(4,0,0)|(0,0,0)]^(5))/5/(2p)
        theta(184) = theta(162)*args%PA(2)-theta(106)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(4) = [(5,0,0)|(0,0,0)]^(4)*args%PA(2)-([(5,0,0)|(0,0,0)]^(5)*args%PC(2)
        theta(185) = theta(162)*args%PA(3)-theta(106)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(4) = [(5,0,0)|(0,0,0)]^(4)*args%PA(3)-([(5,0,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(186) = theta(163)*args%PA(2)-theta(107)*args%PC(2)+(theta(147)-theta(91))*args%rec_p2*1 ! [(4,2,0)|(0,0,0)]^(4) = [(4,1,0)|(0,0,0)]^(4)*args%PA(2)-([(4,1,0)|(0,0,0)]^(5)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(4)-([(4,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(187) = theta(164)*args%PA(2)-theta(108)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(4) = [(4,0,1)|(0,0,0)]^(4)*args%PA(2)-([(4,0,1)|(0,0,0)]^(5)*args%PC(2)
        ! theta(188) = theta(164)*args%PA(3)-theta(108)*args%PC(3)+(theta(147)-theta(91))*args%rec_p2*1 ! [(4,0,2)|(0,0,0)]^(4) = [(4,0,1)|(0,0,0)]^(4)*args%PA(3)-([(4,0,1)|(0,0,0)]^(5)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(4)-([(4,0,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(189) = theta(168)*args%PA(1)-theta(112)*args%PC(1)+(theta(153)-theta(97))*args%rec_p2*2 ! [(3,3,0)|(0,0,0)]^(4) = [(2,3,0)|(0,0,0)]^(4)*args%PA(1)-([(2,3,0)|(0,0,0)]^(5)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(4)-([(1,3,0)|(0,0,0)]^(5))/2/(2p)
        ! theta(190) = theta(165)*args%PA(3)-theta(109)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(4) = [(3,2,0)|(0,0,0)]^(4)*args%PA(3)-([(3,2,0)|(0,0,0)]^(5)*args%PC(3)
        ! theta(191) = theta(167)*args%PA(2)-theta(111)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(4) = [(3,0,2)|(0,0,0)]^(4)*args%PA(2)-([(3,0,2)|(0,0,0)]^(5)*args%PC(2)
        ! theta(192) = theta(171)*args%PA(1)-theta(115)*args%PC(1)+(theta(156)-theta(100))*args%rec_p2*2 ! [(3,0,3)|(0,0,0)]^(4) = [(2,0,3)|(0,0,0)]^(4)*args%PA(1)-([(2,0,3)|(0,0,0)]^(5)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(4)-([(1,0,3)|(0,0,0)]^(5))/2/(2p)
        ! theta(193) = theta(172)*args%PA(1)-theta(116)*args%PC(1)+(theta(157)-theta(101))*args%rec_p2*1 ! [(2,4,0)|(0,0,0)]^(4) = [(1,4,0)|(0,0,0)]^(4)*args%PA(1)-([(1,4,0)|(0,0,0)]^(5)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(4)-([(0,4,0)|(0,0,0)]^(5))/1/(2p)
        ! theta(194) = theta(168)*args%PA(3)-theta(112)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(4) = [(2,3,0)|(0,0,0)]^(4)*args%PA(3)-([(2,3,0)|(0,0,0)]^(5)*args%PC(3)
        t(34) = (theta(159)-theta(103))*args%rec_p2
        theta(195) = theta(174)*args%PA(1)-theta(118)*args%PC(1)+t(34)*1 ! [(2,2,2)|(0,0,0)]^(4) = [(1,2,2)|(0,0,0)]^(4)*args%PA(1)-([(1,2,2)|(0,0,0)]^(5)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(4)-([(0,2,2)|(0,0,0)]^(5))/1/(2p)
        ! theta(196) = theta(171)*args%PA(2)-theta(115)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(4) = [(2,0,3)|(0,0,0)]^(4)*args%PA(2)-([(2,0,3)|(0,0,0)]^(5)*args%PC(2)
        ! theta(197) = theta(176)*args%PA(1)-theta(120)*args%PC(1)+(theta(161)-theta(105))*args%rec_p2*1 ! [(2,0,4)|(0,0,0)]^(4) = [(1,0,4)|(0,0,0)]^(4)*args%PA(1)-([(1,0,4)|(0,0,0)]^(5)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(4)-([(0,0,4)|(0,0,0)]^(5))/1/(2p)
        theta(198) = theta(177)*args%PA(1)-theta(121)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(4) = [(0,5,0)|(0,0,0)]^(4)*args%PA(1)-([(0,5,0)|(0,0,0)]^(5)*args%PC(1)
        ! theta(199) = theta(178)*args%PA(1)-theta(122)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(4) = [(0,4,1)|(0,0,0)]^(4)*args%PA(1)-([(0,4,1)|(0,0,0)]^(5)*args%PC(1)
        theta(200) = theta(179)*args%PA(1)-theta(123)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(4) = [(0,3,2)|(0,0,0)]^(4)*args%PA(1)-([(0,3,2)|(0,0,0)]^(5)*args%PC(1)
        theta(201) = theta(180)*args%PA(1)-theta(124)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(4) = [(0,2,3)|(0,0,0)]^(4)*args%PA(1)-([(0,2,3)|(0,0,0)]^(5)*args%PC(1)
        ! theta(202) = theta(181)*args%PA(1)-theta(125)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(4) = [(0,1,4)|(0,0,0)]^(4)*args%PA(1)-([(0,1,4)|(0,0,0)]^(5)*args%PC(1)
        theta(203) = theta(182)*args%PA(1)-theta(126)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(4) = [(0,0,5)|(0,0,0)]^(4)*args%PA(1)-([(0,0,5)|(0,0,0)]^(5)*args%PC(1)
        t(35) = (theta(157)-theta(101))*args%rec_p2
        theta(204) = theta(177)*args%PA(2)-theta(121)*args%PC(2)+t(35)*5 ! [(0,6,0)|(0,0,0)]^(4) = [(0,5,0)|(0,0,0)]^(4)*args%PA(2)-([(0,5,0)|(0,0,0)]^(5)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(4)-([(0,4,0)|(0,0,0)]^(5))/5/(2p)
        theta(205) = theta(177)*args%PA(3)-theta(121)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(4) = [(0,5,0)|(0,0,0)]^(4)*args%PA(3)-([(0,5,0)|(0,0,0)]^(5)*args%PC(3)
        theta(206) = theta(178)*args%PA(3)-theta(122)*args%PC(3)+t(35)*1 ! [(0,4,2)|(0,0,0)]^(4) = [(0,4,1)|(0,0,0)]^(4)*args%PA(3)-([(0,4,1)|(0,0,0)]^(5)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(4)-([(0,4,0)|(0,0,0)]^(5))/1/(2p)
        t(36) = (theta(160)-theta(104))*args%rec_p2
        theta(207) = theta(180)*args%PA(2)-theta(124)*args%PC(2)+t(36)*2 ! [(0,3,3)|(0,0,0)]^(4) = [(0,2,3)|(0,0,0)]^(4)*args%PA(2)-([(0,2,3)|(0,0,0)]^(5)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(4)-([(0,1,3)|(0,0,0)]^(5))/2/(2p)
        t(37) = (theta(161)-theta(105))*args%rec_p2
        theta(208) = theta(181)*args%PA(2)-theta(125)*args%PC(2)+t(37)*1 ! [(0,2,4)|(0,0,0)]^(4) = [(0,1,4)|(0,0,0)]^(4)*args%PA(2)-([(0,1,4)|(0,0,0)]^(5)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(4)-([(0,0,4)|(0,0,0)]^(5))/1/(2p)
        theta(209) = theta(182)*args%PA(2)-theta(126)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(4) = [(0,0,5)|(0,0,0)]^(4)*args%PA(2)-([(0,0,5)|(0,0,0)]^(5)*args%PC(2)
        theta(210) = theta(182)*args%PA(3)-theta(126)*args%PC(3)+t(37)*5 ! [(0,0,6)|(0,0,0)]^(4) = [(0,0,5)|(0,0,0)]^(4)*args%PA(3)-([(0,0,5)|(0,0,0)]^(5)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(4)-([(0,0,4)|(0,0,0)]^(5))/5/(2p)
        theta(212) = theta(211)*args%PA(1)-theta(127)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(1)-([(0,0,0)|(0,0,0)]^(4)*args%PC(1)
        theta(213) = theta(211)*args%PA(2)-theta(127)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(2)-([(0,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(214) = theta(211)*args%PA(3)-theta(127)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(3) = [(0,0,0)|(0,0,0)]^(3)*args%PA(3)-([(0,0,0)|(0,0,0)]^(4)*args%PC(3)
        t(38) = (theta(211)-theta(127))*args%rec_p2
        theta(215) = theta(212)*args%PA(1)-theta(128)*args%PC(1)+t(38)*1 ! [(2,0,0)|(0,0,0)]^(3) = [(1,0,0)|(0,0,0)]^(3)*args%PA(1)-([(1,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(216) = theta(213)*args%PA(1)-theta(129)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(1)-([(0,1,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(217) = theta(214)*args%PA(1)-theta(130)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(1)-([(0,0,1)|(0,0,0)]^(4)*args%PC(1)
        theta(218) = theta(213)*args%PA(2)-theta(129)*args%PC(2)+t(38)*1 ! [(0,2,0)|(0,0,0)]^(3) = [(0,1,0)|(0,0,0)]^(3)*args%PA(2)-([(0,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(219) = theta(214)*args%PA(2)-theta(130)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(2)-([(0,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(220) = theta(214)*args%PA(3)-theta(130)*args%PC(3)+t(38)*1 ! [(0,0,2)|(0,0,0)]^(3) = [(0,0,1)|(0,0,0)]^(3)*args%PA(3)-([(0,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(3)-([(0,0,0)|(0,0,0)]^(4))/1/(2p)
        t(39) = (theta(212)-theta(128))*args%rec_p2
        theta(221) = theta(215)*args%PA(1)-theta(131)*args%PC(1)+t(39)*2 ! [(3,0,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(1)-([(2,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(3)-([(1,0,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(222) = theta(215)*args%PA(2)-theta(131)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(2)-([(2,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(223) = theta(215)*args%PA(3)-theta(131)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(3) = [(2,0,0)|(0,0,0)]^(3)*args%PA(3)-([(2,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(224) = theta(218)*args%PA(1)-theta(134)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(1)-([(0,2,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(225) = theta(219)*args%PA(1)-theta(135)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(3) = [(0,1,1)|(0,0,0)]^(3)*args%PA(1)-([(0,1,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(226) = theta(220)*args%PA(1)-theta(136)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(1)-([(0,0,2)|(0,0,0)]^(4)*args%PC(1)
        t(40) = (theta(213)-theta(129))*args%rec_p2
        theta(227) = theta(218)*args%PA(2)-theta(134)*args%PC(2)+t(40)*2 ! [(0,3,0)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(2)-([(0,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(3)-([(0,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(228) = theta(218)*args%PA(3)-theta(134)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(3) = [(0,2,0)|(0,0,0)]^(3)*args%PA(3)-([(0,2,0)|(0,0,0)]^(4)*args%PC(3)
        theta(229) = theta(220)*args%PA(2)-theta(136)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(2)-([(0,0,2)|(0,0,0)]^(4)*args%PC(2)
        t(41) = (theta(214)-theta(130))*args%rec_p2
        theta(230) = theta(220)*args%PA(3)-theta(136)*args%PC(3)+t(41)*2 ! [(0,0,3)|(0,0,0)]^(3) = [(0,0,2)|(0,0,0)]^(3)*args%PA(3)-([(0,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(3)-([(0,0,1)|(0,0,0)]^(4))/2/(2p)
        t(42) = (theta(215)-theta(131))*args%rec_p2
        theta(231) = theta(221)*args%PA(1)-theta(137)*args%PC(1)+t(42)*3 ! [(4,0,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(1)-([(3,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(3)-([(2,0,0)|(0,0,0)]^(4))/3/(2p)
        ! theta(232) = theta(221)*args%PA(2)-theta(137)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(2)-([(3,0,0)|(0,0,0)]^(4)*args%PC(2)
        ! theta(233) = theta(221)*args%PA(3)-theta(137)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(3) = [(3,0,0)|(0,0,0)]^(3)*args%PA(3)-([(3,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(234) = theta(224)*args%PA(1)-theta(140)*args%PC(1)+(theta(218)-theta(134))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(3) = [(1,2,0)|(0,0,0)]^(3)*args%PA(1)-([(1,2,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(235) = theta(223)*args%PA(2)-theta(139)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(3) = [(2,0,1)|(0,0,0)]^(3)*args%PA(2)-([(2,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(236) = theta(226)*args%PA(1)-theta(142)*args%PC(1)+(theta(220)-theta(136))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(3) = [(1,0,2)|(0,0,0)]^(3)*args%PA(1)-([(1,0,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(237) = theta(227)*args%PA(1)-theta(143)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(1)-([(0,3,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(238) = theta(228)*args%PA(1)-theta(144)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(3) = [(0,2,1)|(0,0,0)]^(3)*args%PA(1)-([(0,2,1)|(0,0,0)]^(4)*args%PC(1)
        ! theta(239) = theta(229)*args%PA(1)-theta(145)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(1)-([(0,1,2)|(0,0,0)]^(4)*args%PC(1)
        theta(240) = theta(230)*args%PA(1)-theta(146)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(1)-([(0,0,3)|(0,0,0)]^(4)*args%PC(1)
        t(43) = (theta(218)-theta(134))*args%rec_p2
        theta(241) = theta(227)*args%PA(2)-theta(143)*args%PC(2)+t(43)*3 ! [(0,4,0)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(2)-([(0,3,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(3)-([(0,2,0)|(0,0,0)]^(4))/3/(2p)
        theta(242) = theta(227)*args%PA(3)-theta(143)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(3) = [(0,3,0)|(0,0,0)]^(3)*args%PA(3)-([(0,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(44) = (theta(220)-theta(136))*args%rec_p2
        theta(243) = theta(229)*args%PA(2)-theta(145)*args%PC(2)+t(44)*1 ! [(0,2,2)|(0,0,0)]^(3) = [(0,1,2)|(0,0,0)]^(3)*args%PA(2)-([(0,1,2)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/1/(2p)
        theta(244) = theta(230)*args%PA(2)-theta(146)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(2)-([(0,0,3)|(0,0,0)]^(4)*args%PC(2)
        theta(245) = theta(230)*args%PA(3)-theta(146)*args%PC(3)+t(44)*3 ! [(0,0,4)|(0,0,0)]^(3) = [(0,0,3)|(0,0,0)]^(3)*args%PA(3)-([(0,0,3)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(3)-([(0,0,2)|(0,0,0)]^(4))/3/(2p)
        t(45) = (theta(221)-theta(137))*args%rec_p2
        theta(246) = theta(231)*args%PA(1)-theta(147)*args%PC(1)+t(45)*4 ! [(5,0,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(1)-([(4,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/4/(2p)
        theta(247) = theta(231)*args%PA(2)-theta(147)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(2)-([(4,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(248) = theta(231)*args%PA(3)-theta(147)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(3) = [(4,0,0)|(0,0,0)]^(3)*args%PA(3)-([(4,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(249) = theta(232)*args%PA(2)-theta(148)*args%PC(2)+(theta(221)-theta(137))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(3) = [(3,1,0)|(0,0,0)]^(3)*args%PA(2)-([(3,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(250) = theta(233)*args%PA(2)-theta(149)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(2)-([(3,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(251) = theta(233)*args%PA(3)-theta(149)*args%PC(3)+(theta(221)-theta(137))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(3) = [(3,0,1)|(0,0,0)]^(3)*args%PA(3)-([(3,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(3)-([(3,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(252) = theta(237)*args%PA(1)-theta(153)*args%PC(1)+(theta(227)-theta(143))*args%rec_p2*1 ! [(2,3,0)|(0,0,0)]^(3) = [(1,3,0)|(0,0,0)]^(3)*args%PA(1)-([(1,3,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(253) = theta(234)*args%PA(3)-theta(150)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(3) = [(2,2,0)|(0,0,0)]^(3)*args%PA(3)-([(2,2,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(254) = theta(236)*args%PA(2)-theta(152)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(3) = [(2,0,2)|(0,0,0)]^(3)*args%PA(2)-([(2,0,2)|(0,0,0)]^(4)*args%PC(2)
        ! theta(255) = theta(240)*args%PA(1)-theta(156)*args%PC(1)+(theta(230)-theta(146))*args%rec_p2*1 ! [(2,0,3)|(0,0,0)]^(3) = [(1,0,3)|(0,0,0)]^(3)*args%PA(1)-([(1,0,3)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(256) = theta(241)*args%PA(1)-theta(157)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(1)-([(0,4,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(257) = theta(242)*args%PA(1)-theta(158)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(1)-([(0,3,1)|(0,0,0)]^(4)*args%PC(1)
        theta(258) = theta(243)*args%PA(1)-theta(159)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(3) = [(0,2,2)|(0,0,0)]^(3)*args%PA(1)-([(0,2,2)|(0,0,0)]^(4)*args%PC(1)
        ! theta(259) = theta(244)*args%PA(1)-theta(160)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(1)-([(0,1,3)|(0,0,0)]^(4)*args%PC(1)
        theta(260) = theta(245)*args%PA(1)-theta(161)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(1)-([(0,0,4)|(0,0,0)]^(4)*args%PC(1)
        t(46) = (theta(227)-theta(143))*args%rec_p2
        theta(261) = theta(241)*args%PA(2)-theta(157)*args%PC(2)+t(46)*4 ! [(0,5,0)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(2)-([(0,4,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/4/(2p)
        theta(262) = theta(241)*args%PA(3)-theta(157)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(3) = [(0,4,0)|(0,0,0)]^(3)*args%PA(3)-([(0,4,0)|(0,0,0)]^(4)*args%PC(3)
        theta(263) = theta(242)*args%PA(3)-theta(158)*args%PC(3)+t(46)*1 ! [(0,3,2)|(0,0,0)]^(3) = [(0,3,1)|(0,0,0)]^(3)*args%PA(3)-([(0,3,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(3)-([(0,3,0)|(0,0,0)]^(4))/1/(2p)
        t(47) = (theta(230)-theta(146))*args%rec_p2
        theta(264) = theta(244)*args%PA(2)-theta(160)*args%PC(2)+t(47)*1 ! [(0,2,3)|(0,0,0)]^(3) = [(0,1,3)|(0,0,0)]^(3)*args%PA(2)-([(0,1,3)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/1/(2p)
        theta(265) = theta(245)*args%PA(2)-theta(161)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(2)-([(0,0,4)|(0,0,0)]^(4)*args%PC(2)
        theta(266) = theta(245)*args%PA(3)-theta(161)*args%PC(3)+t(47)*4 ! [(0,0,5)|(0,0,0)]^(3) = [(0,0,4)|(0,0,0)]^(3)*args%PA(3)-([(0,0,4)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(3)-([(0,0,3)|(0,0,0)]^(4))/4/(2p)
        t(48) = (theta(231)-theta(147))*args%rec_p2
        theta(267) = theta(246)*args%PA(1)-theta(162)*args%PC(1)+t(48)*5 ! [(6,0,0)|(0,0,0)]^(3) = [(5,0,0)|(0,0,0)]^(3)*args%PA(1)-([(5,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(3)-([(4,0,0)|(0,0,0)]^(4))/5/(2p)
        theta(268) = theta(246)*args%PA(2)-theta(162)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(3) = [(5,0,0)|(0,0,0)]^(3)*args%PA(2)-([(5,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(269) = theta(246)*args%PA(3)-theta(162)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(3) = [(5,0,0)|(0,0,0)]^(3)*args%PA(3)-([(5,0,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(270) = theta(247)*args%PA(2)-theta(163)*args%PC(2)+(theta(231)-theta(147))*args%rec_p2*1 ! [(4,2,0)|(0,0,0)]^(3) = [(4,1,0)|(0,0,0)]^(3)*args%PA(2)-([(4,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(3)-([(4,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(271) = theta(248)*args%PA(2)-theta(164)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(3) = [(4,0,1)|(0,0,0)]^(3)*args%PA(2)-([(4,0,1)|(0,0,0)]^(4)*args%PC(2)
        ! theta(272) = theta(248)*args%PA(3)-theta(164)*args%PC(3)+(theta(231)-theta(147))*args%rec_p2*1 ! [(4,0,2)|(0,0,0)]^(3) = [(4,0,1)|(0,0,0)]^(3)*args%PA(3)-([(4,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(3)-([(4,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(273) = theta(252)*args%PA(1)-theta(168)*args%PC(1)+(theta(237)-theta(153))*args%rec_p2*2 ! [(3,3,0)|(0,0,0)]^(3) = [(2,3,0)|(0,0,0)]^(3)*args%PA(1)-([(2,3,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(3)-([(1,3,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(274) = theta(249)*args%PA(3)-theta(165)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(3) = [(3,2,0)|(0,0,0)]^(3)*args%PA(3)-([(3,2,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(275) = theta(251)*args%PA(2)-theta(167)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(3) = [(3,0,2)|(0,0,0)]^(3)*args%PA(2)-([(3,0,2)|(0,0,0)]^(4)*args%PC(2)
        ! theta(276) = theta(255)*args%PA(1)-theta(171)*args%PC(1)+(theta(240)-theta(156))*args%rec_p2*2 ! [(3,0,3)|(0,0,0)]^(3) = [(2,0,3)|(0,0,0)]^(3)*args%PA(1)-([(2,0,3)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(3)-([(1,0,3)|(0,0,0)]^(4))/2/(2p)
        t(49) = (theta(241)-theta(157))*args%rec_p2
        theta(277) = theta(256)*args%PA(1)-theta(172)*args%PC(1)+t(49)*1 ! [(2,4,0)|(0,0,0)]^(3) = [(1,4,0)|(0,0,0)]^(3)*args%PA(1)-([(1,4,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(3)-([(0,4,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(278) = theta(252)*args%PA(3)-theta(168)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(3) = [(2,3,0)|(0,0,0)]^(3)*args%PA(3)-([(2,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(50) = (theta(243)-theta(159))*args%rec_p2
        theta(279) = theta(258)*args%PA(1)-theta(174)*args%PC(1)+t(50)*1 ! [(2,2,2)|(0,0,0)]^(3) = [(1,2,2)|(0,0,0)]^(3)*args%PA(1)-([(1,2,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(3)-([(0,2,2)|(0,0,0)]^(4))/1/(2p)
        ! theta(280) = theta(255)*args%PA(2)-theta(171)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(3) = [(2,0,3)|(0,0,0)]^(3)*args%PA(2)-([(2,0,3)|(0,0,0)]^(4)*args%PC(2)
        t(51) = (theta(245)-theta(161))*args%rec_p2
        theta(281) = theta(260)*args%PA(1)-theta(176)*args%PC(1)+t(51)*1 ! [(2,0,4)|(0,0,0)]^(3) = [(1,0,4)|(0,0,0)]^(3)*args%PA(1)-([(1,0,4)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(3)-([(0,0,4)|(0,0,0)]^(4))/1/(2p)
        theta(282) = theta(261)*args%PA(1)-theta(177)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(3) = [(0,5,0)|(0,0,0)]^(3)*args%PA(1)-([(0,5,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(283) = theta(262)*args%PA(1)-theta(178)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(3) = [(0,4,1)|(0,0,0)]^(3)*args%PA(1)-([(0,4,1)|(0,0,0)]^(4)*args%PC(1)
        theta(284) = theta(263)*args%PA(1)-theta(179)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(3) = [(0,3,2)|(0,0,0)]^(3)*args%PA(1)-([(0,3,2)|(0,0,0)]^(4)*args%PC(1)
        theta(285) = theta(264)*args%PA(1)-theta(180)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(3) = [(0,2,3)|(0,0,0)]^(3)*args%PA(1)-([(0,2,3)|(0,0,0)]^(4)*args%PC(1)
        ! theta(286) = theta(265)*args%PA(1)-theta(181)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(3) = [(0,1,4)|(0,0,0)]^(3)*args%PA(1)-([(0,1,4)|(0,0,0)]^(4)*args%PC(1)
        theta(287) = theta(266)*args%PA(1)-theta(182)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(3) = [(0,0,5)|(0,0,0)]^(3)*args%PA(1)-([(0,0,5)|(0,0,0)]^(4)*args%PC(1)
        theta(288) = theta(261)*args%PA(2)-theta(177)*args%PC(2)+t(49)*5 ! [(0,6,0)|(0,0,0)]^(3) = [(0,5,0)|(0,0,0)]^(3)*args%PA(2)-([(0,5,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(3)-([(0,4,0)|(0,0,0)]^(4))/5/(2p)
        theta(289) = theta(261)*args%PA(3)-theta(177)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(3) = [(0,5,0)|(0,0,0)]^(3)*args%PA(3)-([(0,5,0)|(0,0,0)]^(4)*args%PC(3)
        theta(290) = theta(262)*args%PA(3)-theta(178)*args%PC(3)+t(49)*1 ! [(0,4,2)|(0,0,0)]^(3) = [(0,4,1)|(0,0,0)]^(3)*args%PA(3)-([(0,4,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(3)-([(0,4,0)|(0,0,0)]^(4))/1/(2p)
        t(52) = (theta(244)-theta(160))*args%rec_p2
        theta(291) = theta(264)*args%PA(2)-theta(180)*args%PC(2)+t(52)*2 ! [(0,3,3)|(0,0,0)]^(3) = [(0,2,3)|(0,0,0)]^(3)*args%PA(2)-([(0,2,3)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(3)-([(0,1,3)|(0,0,0)]^(4))/2/(2p)
        theta(292) = theta(265)*args%PA(2)-theta(181)*args%PC(2)+t(51)*1 ! [(0,2,4)|(0,0,0)]^(3) = [(0,1,4)|(0,0,0)]^(3)*args%PA(2)-([(0,1,4)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(3)-([(0,0,4)|(0,0,0)]^(4))/1/(2p)
        theta(293) = theta(266)*args%PA(2)-theta(182)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(3) = [(0,0,5)|(0,0,0)]^(3)*args%PA(2)-([(0,0,5)|(0,0,0)]^(4)*args%PC(2)
        theta(294) = theta(266)*args%PA(3)-theta(182)*args%PC(3)+t(51)*5 ! [(0,0,6)|(0,0,0)]^(3) = [(0,0,5)|(0,0,0)]^(3)*args%PA(3)-([(0,0,5)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(3)-([(0,0,4)|(0,0,0)]^(4))/5/(2p)
        t(53) = (theta(246)-theta(162))*args%rec_p2
        theta(295) = theta(267)*args%PA(1)-theta(183)*args%PC(1)+t(53)*6 ! [(7,0,0)|(0,0,0)]^(3) = [(6,0,0)|(0,0,0)]^(3)*args%PA(1)-([(6,0,0)|(0,0,0)]^(4)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(3)-([(5,0,0)|(0,0,0)]^(4))/6/(2p)
        theta(296) = theta(267)*args%PA(2)-theta(183)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(3) = [(6,0,0)|(0,0,0)]^(3)*args%PA(2)-([(6,0,0)|(0,0,0)]^(4)*args%PC(2)
        theta(297) = theta(267)*args%PA(3)-theta(183)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(3) = [(6,0,0)|(0,0,0)]^(3)*args%PA(3)-([(6,0,0)|(0,0,0)]^(4)*args%PC(3)
        theta(298) = theta(268)*args%PA(2)-theta(184)*args%PC(2)+t(53)*1 ! [(5,2,0)|(0,0,0)]^(3) = [(5,1,0)|(0,0,0)]^(3)*args%PA(2)-([(5,1,0)|(0,0,0)]^(4)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(3)-([(5,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(299) = theta(269)*args%PA(2)-theta(185)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(3) = [(5,0,1)|(0,0,0)]^(3)*args%PA(2)-([(5,0,1)|(0,0,0)]^(4)*args%PC(2)
        theta(300) = theta(269)*args%PA(3)-theta(185)*args%PC(3)+t(53)*1 ! [(5,0,2)|(0,0,0)]^(3) = [(5,0,1)|(0,0,0)]^(3)*args%PA(3)-([(5,0,1)|(0,0,0)]^(4)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(3)-([(5,0,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(301) = theta(270)*args%PA(2)-theta(186)*args%PC(2)+(theta(247)-theta(163))*args%rec_p2*2 ! [(4,3,0)|(0,0,0)]^(3) = [(4,2,0)|(0,0,0)]^(3)*args%PA(2)-([(4,2,0)|(0,0,0)]^(4)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(3)-([(4,1,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(302) = theta(270)*args%PA(3)-theta(186)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(3) = [(4,2,0)|(0,0,0)]^(3)*args%PA(3)-([(4,2,0)|(0,0,0)]^(4)*args%PC(3)
        ! theta(303) = theta(272)*args%PA(2)-theta(188)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(3) = [(4,0,2)|(0,0,0)]^(3)*args%PA(2)-([(4,0,2)|(0,0,0)]^(4)*args%PC(2)
        ! theta(304) = theta(272)*args%PA(3)-theta(188)*args%PC(3)+(theta(248)-theta(164))*args%rec_p2*2 ! [(4,0,3)|(0,0,0)]^(3) = [(4,0,2)|(0,0,0)]^(3)*args%PA(3)-([(4,0,2)|(0,0,0)]^(4)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(3)-([(4,0,1)|(0,0,0)]^(4))/2/(2p)
        ! theta(305) = theta(277)*args%PA(1)-theta(193)*args%PC(1)+(theta(256)-theta(172))*args%rec_p2*2 ! [(3,4,0)|(0,0,0)]^(3) = [(2,4,0)|(0,0,0)]^(3)*args%PA(1)-([(2,4,0)|(0,0,0)]^(4)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(3)-([(1,4,0)|(0,0,0)]^(4))/2/(2p)
        ! theta(306) = theta(273)*args%PA(3)-theta(189)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(3) = [(3,3,0)|(0,0,0)]^(3)*args%PA(3)-([(3,3,0)|(0,0,0)]^(4)*args%PC(3)
        t(54) = (theta(258)-theta(174))*args%rec_p2
        theta(307) = theta(279)*args%PA(1)-theta(195)*args%PC(1)+t(54)*2 ! [(3,2,2)|(0,0,0)]^(3) = [(2,2,2)|(0,0,0)]^(3)*args%PA(1)-([(2,2,2)|(0,0,0)]^(4)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(3)-([(1,2,2)|(0,0,0)]^(4))/2/(2p)
        ! theta(308) = theta(276)*args%PA(2)-theta(192)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(3) = [(3,0,3)|(0,0,0)]^(3)*args%PA(2)-([(3,0,3)|(0,0,0)]^(4)*args%PC(2)
        ! theta(309) = theta(281)*args%PA(1)-theta(197)*args%PC(1)+(theta(260)-theta(176))*args%rec_p2*2 ! [(3,0,4)|(0,0,0)]^(3) = [(2,0,4)|(0,0,0)]^(3)*args%PA(1)-([(2,0,4)|(0,0,0)]^(4)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(3)-([(1,0,4)|(0,0,0)]^(4))/2/(2p)
        t(55) = (theta(261)-theta(177))*args%rec_p2
        theta(310) = theta(282)*args%PA(1)-theta(198)*args%PC(1)+t(55)*1 ! [(2,5,0)|(0,0,0)]^(3) = [(1,5,0)|(0,0,0)]^(3)*args%PA(1)-([(1,5,0)|(0,0,0)]^(4)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(3)-([(0,5,0)|(0,0,0)]^(4))/1/(2p)
        ! theta(311) = theta(277)*args%PA(3)-theta(193)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(3) = [(2,4,0)|(0,0,0)]^(3)*args%PA(3)-([(2,4,0)|(0,0,0)]^(4)*args%PC(3)
        t(56) = (theta(263)-theta(179))*args%rec_p2
        theta(312) = theta(284)*args%PA(1)-theta(200)*args%PC(1)+t(56)*1 ! [(2,3,2)|(0,0,0)]^(3) = [(1,3,2)|(0,0,0)]^(3)*args%PA(1)-([(1,3,2)|(0,0,0)]^(4)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(3)-([(0,3,2)|(0,0,0)]^(4))/1/(2p)
        t(57) = (theta(264)-theta(180))*args%rec_p2
        theta(313) = theta(285)*args%PA(1)-theta(201)*args%PC(1)+t(57)*1 ! [(2,2,3)|(0,0,0)]^(3) = [(1,2,3)|(0,0,0)]^(3)*args%PA(1)-([(1,2,3)|(0,0,0)]^(4)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(3)-([(0,2,3)|(0,0,0)]^(4))/1/(2p)
        ! theta(314) = theta(281)*args%PA(2)-theta(197)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(3) = [(2,0,4)|(0,0,0)]^(3)*args%PA(2)-([(2,0,4)|(0,0,0)]^(4)*args%PC(2)
        t(58) = (theta(266)-theta(182))*args%rec_p2
        theta(315) = theta(287)*args%PA(1)-theta(203)*args%PC(1)+t(58)*1 ! [(2,0,5)|(0,0,0)]^(3) = [(1,0,5)|(0,0,0)]^(3)*args%PA(1)-([(1,0,5)|(0,0,0)]^(4)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(3)-([(0,0,5)|(0,0,0)]^(4))/1/(2p)
        theta(316) = theta(288)*args%PA(1)-theta(204)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(3) = [(0,6,0)|(0,0,0)]^(3)*args%PA(1)-([(0,6,0)|(0,0,0)]^(4)*args%PC(1)
        ! theta(317) = theta(289)*args%PA(1)-theta(205)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(3) = [(0,5,1)|(0,0,0)]^(3)*args%PA(1)-([(0,5,1)|(0,0,0)]^(4)*args%PC(1)
        theta(318) = theta(290)*args%PA(1)-theta(206)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(3) = [(0,4,2)|(0,0,0)]^(3)*args%PA(1)-([(0,4,2)|(0,0,0)]^(4)*args%PC(1)
        theta(319) = theta(291)*args%PA(1)-theta(207)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(3) = [(0,3,3)|(0,0,0)]^(3)*args%PA(1)-([(0,3,3)|(0,0,0)]^(4)*args%PC(1)
        theta(320) = theta(292)*args%PA(1)-theta(208)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(3) = [(0,2,4)|(0,0,0)]^(3)*args%PA(1)-([(0,2,4)|(0,0,0)]^(4)*args%PC(1)
        ! theta(321) = theta(293)*args%PA(1)-theta(209)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(3) = [(0,1,5)|(0,0,0)]^(3)*args%PA(1)-([(0,1,5)|(0,0,0)]^(4)*args%PC(1)
        theta(322) = theta(294)*args%PA(1)-theta(210)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(3) = [(0,0,6)|(0,0,0)]^(3)*args%PA(1)-([(0,0,6)|(0,0,0)]^(4)*args%PC(1)
        theta(323) = theta(288)*args%PA(2)-theta(204)*args%PC(2)+t(55)*6 ! [(0,7,0)|(0,0,0)]^(3) = [(0,6,0)|(0,0,0)]^(3)*args%PA(2)-([(0,6,0)|(0,0,0)]^(4)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(3)-([(0,5,0)|(0,0,0)]^(4))/6/(2p)
        theta(324) = theta(288)*args%PA(3)-theta(204)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(3) = [(0,6,0)|(0,0,0)]^(3)*args%PA(3)-([(0,6,0)|(0,0,0)]^(4)*args%PC(3)
        theta(325) = theta(289)*args%PA(3)-theta(205)*args%PC(3)+t(55)*1 ! [(0,5,2)|(0,0,0)]^(3) = [(0,5,1)|(0,0,0)]^(3)*args%PA(3)-([(0,5,1)|(0,0,0)]^(4)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(3)-([(0,5,0)|(0,0,0)]^(4))/1/(2p)
        t(59) = (theta(262)-theta(178))*args%rec_p2
        theta(326) = theta(290)*args%PA(3)-theta(206)*args%PC(3)+t(59)*2 ! [(0,4,3)|(0,0,0)]^(3) = [(0,4,2)|(0,0,0)]^(3)*args%PA(3)-([(0,4,2)|(0,0,0)]^(4)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(3)-([(0,4,1)|(0,0,0)]^(4))/2/(2p)
        t(60) = (theta(265)-theta(181))*args%rec_p2
        theta(327) = theta(292)*args%PA(2)-theta(208)*args%PC(2)+t(60)*2 ! [(0,3,4)|(0,0,0)]^(3) = [(0,2,4)|(0,0,0)]^(3)*args%PA(2)-([(0,2,4)|(0,0,0)]^(4)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(3)-([(0,1,4)|(0,0,0)]^(4))/2/(2p)
        theta(328) = theta(293)*args%PA(2)-theta(209)*args%PC(2)+t(58)*1 ! [(0,2,5)|(0,0,0)]^(3) = [(0,1,5)|(0,0,0)]^(3)*args%PA(2)-([(0,1,5)|(0,0,0)]^(4)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(3)-([(0,0,5)|(0,0,0)]^(4))/1/(2p)
        theta(329) = theta(294)*args%PA(2)-theta(210)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(3) = [(0,0,6)|(0,0,0)]^(3)*args%PA(2)-([(0,0,6)|(0,0,0)]^(4)*args%PC(2)
        theta(330) = theta(294)*args%PA(3)-theta(210)*args%PC(3)+t(58)*6 ! [(0,0,7)|(0,0,0)]^(3) = [(0,0,6)|(0,0,0)]^(3)*args%PA(3)-([(0,0,6)|(0,0,0)]^(4)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(3)-([(0,0,5)|(0,0,0)]^(4))/6/(2p)
        theta(332) = theta(331)*args%PA(1)-theta(211)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(1)-([(0,0,0)|(0,0,0)]^(3)*args%PC(1)
        theta(333) = theta(331)*args%PA(2)-theta(211)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(2)-([(0,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(334) = theta(331)*args%PA(3)-theta(211)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(2) = [(0,0,0)|(0,0,0)]^(2)*args%PA(3)-([(0,0,0)|(0,0,0)]^(3)*args%PC(3)
        t(61) = (theta(331)-theta(211))*args%rec_p2
        theta(335) = theta(332)*args%PA(1)-theta(212)*args%PC(1)+t(61)*1 ! [(2,0,0)|(0,0,0)]^(2) = [(1,0,0)|(0,0,0)]^(2)*args%PA(1)-([(1,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(336) = theta(333)*args%PA(1)-theta(213)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(1)-([(0,1,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(337) = theta(334)*args%PA(1)-theta(214)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(1)-([(0,0,1)|(0,0,0)]^(3)*args%PC(1)
        theta(338) = theta(333)*args%PA(2)-theta(213)*args%PC(2)+t(61)*1 ! [(0,2,0)|(0,0,0)]^(2) = [(0,1,0)|(0,0,0)]^(2)*args%PA(2)-([(0,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(339) = theta(334)*args%PA(2)-theta(214)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(2)-([(0,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(340) = theta(334)*args%PA(3)-theta(214)*args%PC(3)+t(61)*1 ! [(0,0,2)|(0,0,0)]^(2) = [(0,0,1)|(0,0,0)]^(2)*args%PA(3)-([(0,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(2)-([(0,0,0)|(0,0,0)]^(3))/1/(2p)
        t(62) = (theta(332)-theta(212))*args%rec_p2
        theta(341) = theta(335)*args%PA(1)-theta(215)*args%PC(1)+t(62)*2 ! [(3,0,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(1)-([(2,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(2)-([(1,0,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(342) = theta(335)*args%PA(2)-theta(215)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(2)-([(2,0,0)|(0,0,0)]^(3)*args%PC(2)
        ! theta(343) = theta(335)*args%PA(3)-theta(215)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(2) = [(2,0,0)|(0,0,0)]^(2)*args%PA(3)-([(2,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(344) = theta(338)*args%PA(1)-theta(218)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(1)-([(0,2,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(345) = theta(339)*args%PA(1)-theta(219)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(2) = [(0,1,1)|(0,0,0)]^(2)*args%PA(1)-([(0,1,1)|(0,0,0)]^(3)*args%PC(1)
        theta(346) = theta(340)*args%PA(1)-theta(220)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(1)-([(0,0,2)|(0,0,0)]^(3)*args%PC(1)
        t(63) = (theta(333)-theta(213))*args%rec_p2
        theta(347) = theta(338)*args%PA(2)-theta(218)*args%PC(2)+t(63)*2 ! [(0,3,0)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(2)-([(0,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(2)-([(0,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(348) = theta(338)*args%PA(3)-theta(218)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(2) = [(0,2,0)|(0,0,0)]^(2)*args%PA(3)-([(0,2,0)|(0,0,0)]^(3)*args%PC(3)
        theta(349) = theta(340)*args%PA(2)-theta(220)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(2)-([(0,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(64) = (theta(334)-theta(214))*args%rec_p2
        theta(350) = theta(340)*args%PA(3)-theta(220)*args%PC(3)+t(64)*2 ! [(0,0,3)|(0,0,0)]^(2) = [(0,0,2)|(0,0,0)]^(2)*args%PA(3)-([(0,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(2)-([(0,0,1)|(0,0,0)]^(3))/2/(2p)
        t(65) = (theta(335)-theta(215))*args%rec_p2
        theta(351) = theta(341)*args%PA(1)-theta(221)*args%PC(1)+t(65)*3 ! [(4,0,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(1)-([(3,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(2)-([(2,0,0)|(0,0,0)]^(3))/3/(2p)
        theta(352) = theta(341)*args%PA(2)-theta(221)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(2)-([(3,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(353) = theta(341)*args%PA(3)-theta(221)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(2) = [(3,0,0)|(0,0,0)]^(2)*args%PA(3)-([(3,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(354) = theta(344)*args%PA(1)-theta(224)*args%PC(1)+(theta(338)-theta(218))*args%rec_p2*1 ! [(2,2,0)|(0,0,0)]^(2) = [(1,2,0)|(0,0,0)]^(2)*args%PA(1)-([(1,2,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(355) = theta(343)*args%PA(2)-theta(223)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(2) = [(2,0,1)|(0,0,0)]^(2)*args%PA(2)-([(2,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(356) = theta(346)*args%PA(1)-theta(226)*args%PC(1)+(theta(340)-theta(220))*args%rec_p2*1 ! [(2,0,2)|(0,0,0)]^(2) = [(1,0,2)|(0,0,0)]^(2)*args%PA(1)-([(1,0,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(357) = theta(347)*args%PA(1)-theta(227)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(1)-([(0,3,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(358) = theta(348)*args%PA(1)-theta(228)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(2) = [(0,2,1)|(0,0,0)]^(2)*args%PA(1)-([(0,2,1)|(0,0,0)]^(3)*args%PC(1)
        ! theta(359) = theta(349)*args%PA(1)-theta(229)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(1)-([(0,1,2)|(0,0,0)]^(3)*args%PC(1)
        theta(360) = theta(350)*args%PA(1)-theta(230)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(1)-([(0,0,3)|(0,0,0)]^(3)*args%PC(1)
        t(66) = (theta(338)-theta(218))*args%rec_p2
        theta(361) = theta(347)*args%PA(2)-theta(227)*args%PC(2)+t(66)*3 ! [(0,4,0)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(2)-([(0,3,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(2)-([(0,2,0)|(0,0,0)]^(3))/3/(2p)
        theta(362) = theta(347)*args%PA(3)-theta(227)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(2) = [(0,3,0)|(0,0,0)]^(2)*args%PA(3)-([(0,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(67) = (theta(340)-theta(220))*args%rec_p2
        theta(363) = theta(349)*args%PA(2)-theta(229)*args%PC(2)+t(67)*1 ! [(0,2,2)|(0,0,0)]^(2) = [(0,1,2)|(0,0,0)]^(2)*args%PA(2)-([(0,1,2)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/1/(2p)
        theta(364) = theta(350)*args%PA(2)-theta(230)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(2)-([(0,0,3)|(0,0,0)]^(3)*args%PC(2)
        theta(365) = theta(350)*args%PA(3)-theta(230)*args%PC(3)+t(67)*3 ! [(0,0,4)|(0,0,0)]^(2) = [(0,0,3)|(0,0,0)]^(2)*args%PA(3)-([(0,0,3)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(2)-([(0,0,2)|(0,0,0)]^(3))/3/(2p)
        t(68) = (theta(341)-theta(221))*args%rec_p2
        theta(366) = theta(351)*args%PA(1)-theta(231)*args%PC(1)+t(68)*4 ! [(5,0,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(1)-([(4,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/4/(2p)
        theta(367) = theta(351)*args%PA(2)-theta(231)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(2)-([(4,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(368) = theta(351)*args%PA(3)-theta(231)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(2) = [(4,0,0)|(0,0,0)]^(2)*args%PA(3)-([(4,0,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(369) = theta(352)*args%PA(2)-theta(232)*args%PC(2)+(theta(341)-theta(221))*args%rec_p2*1 ! [(3,2,0)|(0,0,0)]^(2) = [(3,1,0)|(0,0,0)]^(2)*args%PA(2)-([(3,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(370) = theta(353)*args%PA(2)-theta(233)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(2)-([(3,0,1)|(0,0,0)]^(3)*args%PC(2)
        ! theta(371) = theta(353)*args%PA(3)-theta(233)*args%PC(3)+(theta(341)-theta(221))*args%rec_p2*1 ! [(3,0,2)|(0,0,0)]^(2) = [(3,0,1)|(0,0,0)]^(2)*args%PA(3)-([(3,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(2)-([(3,0,0)|(0,0,0)]^(3))/1/(2p)
        t(69) = (theta(347)-theta(227))*args%rec_p2
        theta(372) = theta(357)*args%PA(1)-theta(237)*args%PC(1)+t(69)*1 ! [(2,3,0)|(0,0,0)]^(2) = [(1,3,0)|(0,0,0)]^(2)*args%PA(1)-([(1,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(373) = theta(354)*args%PA(3)-theta(234)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(2) = [(2,2,0)|(0,0,0)]^(2)*args%PA(3)-([(2,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(374) = theta(356)*args%PA(2)-theta(236)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(2) = [(2,0,2)|(0,0,0)]^(2)*args%PA(2)-([(2,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(70) = (theta(350)-theta(230))*args%rec_p2
        theta(375) = theta(360)*args%PA(1)-theta(240)*args%PC(1)+t(70)*1 ! [(2,0,3)|(0,0,0)]^(2) = [(1,0,3)|(0,0,0)]^(2)*args%PA(1)-([(1,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(376) = theta(361)*args%PA(1)-theta(241)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(1)-([(0,4,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(377) = theta(362)*args%PA(1)-theta(242)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(1)-([(0,3,1)|(0,0,0)]^(3)*args%PC(1)
        theta(378) = theta(363)*args%PA(1)-theta(243)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(2) = [(0,2,2)|(0,0,0)]^(2)*args%PA(1)-([(0,2,2)|(0,0,0)]^(3)*args%PC(1)
        ! theta(379) = theta(364)*args%PA(1)-theta(244)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(1)-([(0,1,3)|(0,0,0)]^(3)*args%PC(1)
        theta(380) = theta(365)*args%PA(1)-theta(245)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(1)-([(0,0,4)|(0,0,0)]^(3)*args%PC(1)
        theta(381) = theta(361)*args%PA(2)-theta(241)*args%PC(2)+t(69)*4 ! [(0,5,0)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(2)-([(0,4,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/4/(2p)
        theta(382) = theta(361)*args%PA(3)-theta(241)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(2) = [(0,4,0)|(0,0,0)]^(2)*args%PA(3)-([(0,4,0)|(0,0,0)]^(3)*args%PC(3)
        theta(383) = theta(362)*args%PA(3)-theta(242)*args%PC(3)+t(69)*1 ! [(0,3,2)|(0,0,0)]^(2) = [(0,3,1)|(0,0,0)]^(2)*args%PA(3)-([(0,3,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(2)-([(0,3,0)|(0,0,0)]^(3))/1/(2p)
        theta(384) = theta(364)*args%PA(2)-theta(244)*args%PC(2)+t(70)*1 ! [(0,2,3)|(0,0,0)]^(2) = [(0,1,3)|(0,0,0)]^(2)*args%PA(2)-([(0,1,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/1/(2p)
        theta(385) = theta(365)*args%PA(2)-theta(245)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(2)-([(0,0,4)|(0,0,0)]^(3)*args%PC(2)
        theta(386) = theta(365)*args%PA(3)-theta(245)*args%PC(3)+t(70)*4 ! [(0,0,5)|(0,0,0)]^(2) = [(0,0,4)|(0,0,0)]^(2)*args%PA(3)-([(0,0,4)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(2)-([(0,0,3)|(0,0,0)]^(3))/4/(2p)
        t(71) = (theta(351)-theta(231))*args%rec_p2
        theta(387) = theta(366)*args%PA(1)-theta(246)*args%PC(1)+t(71)*5 ! [(6,0,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(1)-([(5,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/5/(2p)
        theta(388) = theta(366)*args%PA(2)-theta(246)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(2)-([(5,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(389) = theta(366)*args%PA(3)-theta(246)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(2) = [(5,0,0)|(0,0,0)]^(2)*args%PA(3)-([(5,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(390) = theta(367)*args%PA(2)-theta(247)*args%PC(2)+t(71)*1 ! [(4,2,0)|(0,0,0)]^(2) = [(4,1,0)|(0,0,0)]^(2)*args%PA(2)-([(4,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(391) = theta(368)*args%PA(2)-theta(248)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(2)-([(4,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(392) = theta(368)*args%PA(3)-theta(248)*args%PC(3)+t(71)*1 ! [(4,0,2)|(0,0,0)]^(2) = [(4,0,1)|(0,0,0)]^(2)*args%PA(3)-([(4,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(2)-([(4,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(393) = theta(372)*args%PA(1)-theta(252)*args%PC(1)+(theta(357)-theta(237))*args%rec_p2*2 ! [(3,3,0)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(1)-([(2,3,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(2)-([(1,3,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(394) = theta(369)*args%PA(3)-theta(249)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(2) = [(3,2,0)|(0,0,0)]^(2)*args%PA(3)-([(3,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(395) = theta(371)*args%PA(2)-theta(251)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(2) = [(3,0,2)|(0,0,0)]^(2)*args%PA(2)-([(3,0,2)|(0,0,0)]^(3)*args%PC(2)
        ! theta(396) = theta(375)*args%PA(1)-theta(255)*args%PC(1)+(theta(360)-theta(240))*args%rec_p2*2 ! [(3,0,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(1)-([(2,0,3)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(2)-([(1,0,3)|(0,0,0)]^(3))/2/(2p)
        t(72) = (theta(361)-theta(241))*args%rec_p2
        theta(397) = theta(376)*args%PA(1)-theta(256)*args%PC(1)+t(72)*1 ! [(2,4,0)|(0,0,0)]^(2) = [(1,4,0)|(0,0,0)]^(2)*args%PA(1)-([(1,4,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(398) = theta(372)*args%PA(3)-theta(252)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(2) = [(2,3,0)|(0,0,0)]^(2)*args%PA(3)-([(2,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(73) = (theta(363)-theta(243))*args%rec_p2
        theta(399) = theta(378)*args%PA(1)-theta(258)*args%PC(1)+t(73)*1 ! [(2,2,2)|(0,0,0)]^(2) = [(1,2,2)|(0,0,0)]^(2)*args%PA(1)-([(1,2,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(2)-([(0,2,2)|(0,0,0)]^(3))/1/(2p)
        ! theta(400) = theta(375)*args%PA(2)-theta(255)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(2) = [(2,0,3)|(0,0,0)]^(2)*args%PA(2)-([(2,0,3)|(0,0,0)]^(3)*args%PC(2)
        t(74) = (theta(365)-theta(245))*args%rec_p2
        theta(401) = theta(380)*args%PA(1)-theta(260)*args%PC(1)+t(74)*1 ! [(2,0,4)|(0,0,0)]^(2) = [(1,0,4)|(0,0,0)]^(2)*args%PA(1)-([(1,0,4)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(402) = theta(381)*args%PA(1)-theta(261)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(1)-([(0,5,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(403) = theta(382)*args%PA(1)-theta(262)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(1)-([(0,4,1)|(0,0,0)]^(3)*args%PC(1)
        theta(404) = theta(383)*args%PA(1)-theta(263)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(2) = [(0,3,2)|(0,0,0)]^(2)*args%PA(1)-([(0,3,2)|(0,0,0)]^(3)*args%PC(1)
        theta(405) = theta(384)*args%PA(1)-theta(264)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(1)-([(0,2,3)|(0,0,0)]^(3)*args%PC(1)
        ! theta(406) = theta(385)*args%PA(1)-theta(265)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(1)-([(0,1,4)|(0,0,0)]^(3)*args%PC(1)
        theta(407) = theta(386)*args%PA(1)-theta(266)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(1)-([(0,0,5)|(0,0,0)]^(3)*args%PC(1)
        theta(408) = theta(381)*args%PA(2)-theta(261)*args%PC(2)+t(72)*5 ! [(0,6,0)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(2)-([(0,5,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/5/(2p)
        theta(409) = theta(381)*args%PA(3)-theta(261)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(2) = [(0,5,0)|(0,0,0)]^(2)*args%PA(3)-([(0,5,0)|(0,0,0)]^(3)*args%PC(3)
        theta(410) = theta(382)*args%PA(3)-theta(262)*args%PC(3)+t(72)*1 ! [(0,4,2)|(0,0,0)]^(2) = [(0,4,1)|(0,0,0)]^(2)*args%PA(3)-([(0,4,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(2)-([(0,4,0)|(0,0,0)]^(3))/1/(2p)
        t(75) = (theta(364)-theta(244))*args%rec_p2
        theta(411) = theta(384)*args%PA(2)-theta(264)*args%PC(2)+t(75)*2 ! [(0,3,3)|(0,0,0)]^(2) = [(0,2,3)|(0,0,0)]^(2)*args%PA(2)-([(0,2,3)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(2)-([(0,1,3)|(0,0,0)]^(3))/2/(2p)
        theta(412) = theta(385)*args%PA(2)-theta(265)*args%PC(2)+t(74)*1 ! [(0,2,4)|(0,0,0)]^(2) = [(0,1,4)|(0,0,0)]^(2)*args%PA(2)-([(0,1,4)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/1/(2p)
        theta(413) = theta(386)*args%PA(2)-theta(266)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(2)-([(0,0,5)|(0,0,0)]^(3)*args%PC(2)
        theta(414) = theta(386)*args%PA(3)-theta(266)*args%PC(3)+t(74)*5 ! [(0,0,6)|(0,0,0)]^(2) = [(0,0,5)|(0,0,0)]^(2)*args%PA(3)-([(0,0,5)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(2)-([(0,0,4)|(0,0,0)]^(3))/5/(2p)
        t(76) = (theta(366)-theta(246))*args%rec_p2
        theta(415) = theta(387)*args%PA(1)-theta(267)*args%PC(1)+t(76)*6 ! [(7,0,0)|(0,0,0)]^(2) = [(6,0,0)|(0,0,0)]^(2)*args%PA(1)-([(6,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(2)-([(5,0,0)|(0,0,0)]^(3))/6/(2p)
        theta(416) = theta(387)*args%PA(2)-theta(267)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(2) = [(6,0,0)|(0,0,0)]^(2)*args%PA(2)-([(6,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(417) = theta(387)*args%PA(3)-theta(267)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(2) = [(6,0,0)|(0,0,0)]^(2)*args%PA(3)-([(6,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(418) = theta(388)*args%PA(2)-theta(268)*args%PC(2)+t(76)*1 ! [(5,2,0)|(0,0,0)]^(2) = [(5,1,0)|(0,0,0)]^(2)*args%PA(2)-([(5,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(2)-([(5,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(419) = theta(389)*args%PA(2)-theta(269)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(2) = [(5,0,1)|(0,0,0)]^(2)*args%PA(2)-([(5,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(420) = theta(389)*args%PA(3)-theta(269)*args%PC(3)+t(76)*1 ! [(5,0,2)|(0,0,0)]^(2) = [(5,0,1)|(0,0,0)]^(2)*args%PA(3)-([(5,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(2)-([(5,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(421) = theta(390)*args%PA(2)-theta(270)*args%PC(2)+(theta(367)-theta(247))*args%rec_p2*2 ! [(4,3,0)|(0,0,0)]^(2) = [(4,2,0)|(0,0,0)]^(2)*args%PA(2)-([(4,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(2)-([(4,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(422) = theta(390)*args%PA(3)-theta(270)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(2) = [(4,2,0)|(0,0,0)]^(2)*args%PA(3)-([(4,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(423) = theta(392)*args%PA(2)-theta(272)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(2) = [(4,0,2)|(0,0,0)]^(2)*args%PA(2)-([(4,0,2)|(0,0,0)]^(3)*args%PC(2)
        ! theta(424) = theta(392)*args%PA(3)-theta(272)*args%PC(3)+(theta(368)-theta(248))*args%rec_p2*2 ! [(4,0,3)|(0,0,0)]^(2) = [(4,0,2)|(0,0,0)]^(2)*args%PA(3)-([(4,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(2)-([(4,0,1)|(0,0,0)]^(3))/2/(2p)
        t(77) = (theta(376)-theta(256))*args%rec_p2
        theta(425) = theta(397)*args%PA(1)-theta(277)*args%PC(1)+t(77)*2 ! [(3,4,0)|(0,0,0)]^(2) = [(2,4,0)|(0,0,0)]^(2)*args%PA(1)-([(2,4,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(2)-([(1,4,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(426) = theta(393)*args%PA(3)-theta(273)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(2) = [(3,3,0)|(0,0,0)]^(2)*args%PA(3)-([(3,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(78) = (theta(378)-theta(258))*args%rec_p2
        theta(427) = theta(399)*args%PA(1)-theta(279)*args%PC(1)+t(78)*2 ! [(3,2,2)|(0,0,0)]^(2) = [(2,2,2)|(0,0,0)]^(2)*args%PA(1)-([(2,2,2)|(0,0,0)]^(3)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(2)-([(1,2,2)|(0,0,0)]^(3))/2/(2p)
        ! theta(428) = theta(396)*args%PA(2)-theta(276)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(2) = [(3,0,3)|(0,0,0)]^(2)*args%PA(2)-([(3,0,3)|(0,0,0)]^(3)*args%PC(2)
        t(79) = (theta(380)-theta(260))*args%rec_p2
        theta(429) = theta(401)*args%PA(1)-theta(281)*args%PC(1)+t(79)*2 ! [(3,0,4)|(0,0,0)]^(2) = [(2,0,4)|(0,0,0)]^(2)*args%PA(1)-([(2,0,4)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(2)-([(1,0,4)|(0,0,0)]^(3))/2/(2p)
        t(80) = (theta(381)-theta(261))*args%rec_p2
        theta(430) = theta(402)*args%PA(1)-theta(282)*args%PC(1)+t(80)*1 ! [(2,5,0)|(0,0,0)]^(2) = [(1,5,0)|(0,0,0)]^(2)*args%PA(1)-([(1,5,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(2)-([(0,5,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(431) = theta(397)*args%PA(3)-theta(277)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(2) = [(2,4,0)|(0,0,0)]^(2)*args%PA(3)-([(2,4,0)|(0,0,0)]^(3)*args%PC(3)
        t(81) = (theta(383)-theta(263))*args%rec_p2
        theta(432) = theta(404)*args%PA(1)-theta(284)*args%PC(1)+t(81)*1 ! [(2,3,2)|(0,0,0)]^(2) = [(1,3,2)|(0,0,0)]^(2)*args%PA(1)-([(1,3,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(2)-([(0,3,2)|(0,0,0)]^(3))/1/(2p)
        t(82) = (theta(384)-theta(264))*args%rec_p2
        theta(433) = theta(405)*args%PA(1)-theta(285)*args%PC(1)+t(82)*1 ! [(2,2,3)|(0,0,0)]^(2) = [(1,2,3)|(0,0,0)]^(2)*args%PA(1)-([(1,2,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(2)-([(0,2,3)|(0,0,0)]^(3))/1/(2p)
        ! theta(434) = theta(401)*args%PA(2)-theta(281)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(2) = [(2,0,4)|(0,0,0)]^(2)*args%PA(2)-([(2,0,4)|(0,0,0)]^(3)*args%PC(2)
        t(83) = (theta(386)-theta(266))*args%rec_p2
        theta(435) = theta(407)*args%PA(1)-theta(287)*args%PC(1)+t(83)*1 ! [(2,0,5)|(0,0,0)]^(2) = [(1,0,5)|(0,0,0)]^(2)*args%PA(1)-([(1,0,5)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(2)-([(0,0,5)|(0,0,0)]^(3))/1/(2p)
        theta(436) = theta(408)*args%PA(1)-theta(288)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(2) = [(0,6,0)|(0,0,0)]^(2)*args%PA(1)-([(0,6,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(437) = theta(409)*args%PA(1)-theta(289)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(2) = [(0,5,1)|(0,0,0)]^(2)*args%PA(1)-([(0,5,1)|(0,0,0)]^(3)*args%PC(1)
        theta(438) = theta(410)*args%PA(1)-theta(290)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(2) = [(0,4,2)|(0,0,0)]^(2)*args%PA(1)-([(0,4,2)|(0,0,0)]^(3)*args%PC(1)
        theta(439) = theta(411)*args%PA(1)-theta(291)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(2) = [(0,3,3)|(0,0,0)]^(2)*args%PA(1)-([(0,3,3)|(0,0,0)]^(3)*args%PC(1)
        theta(440) = theta(412)*args%PA(1)-theta(292)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(2) = [(0,2,4)|(0,0,0)]^(2)*args%PA(1)-([(0,2,4)|(0,0,0)]^(3)*args%PC(1)
        ! theta(441) = theta(413)*args%PA(1)-theta(293)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(2) = [(0,1,5)|(0,0,0)]^(2)*args%PA(1)-([(0,1,5)|(0,0,0)]^(3)*args%PC(1)
        theta(442) = theta(414)*args%PA(1)-theta(294)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(2) = [(0,0,6)|(0,0,0)]^(2)*args%PA(1)-([(0,0,6)|(0,0,0)]^(3)*args%PC(1)
        theta(443) = theta(408)*args%PA(2)-theta(288)*args%PC(2)+t(80)*6 ! [(0,7,0)|(0,0,0)]^(2) = [(0,6,0)|(0,0,0)]^(2)*args%PA(2)-([(0,6,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(2)-([(0,5,0)|(0,0,0)]^(3))/6/(2p)
        theta(444) = theta(408)*args%PA(3)-theta(288)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(2) = [(0,6,0)|(0,0,0)]^(2)*args%PA(3)-([(0,6,0)|(0,0,0)]^(3)*args%PC(3)
        theta(445) = theta(409)*args%PA(3)-theta(289)*args%PC(3)+t(80)*1 ! [(0,5,2)|(0,0,0)]^(2) = [(0,5,1)|(0,0,0)]^(2)*args%PA(3)-([(0,5,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(2)-([(0,5,0)|(0,0,0)]^(3))/1/(2p)
        t(84) = (theta(382)-theta(262))*args%rec_p2
        theta(446) = theta(410)*args%PA(3)-theta(290)*args%PC(3)+t(84)*2 ! [(0,4,3)|(0,0,0)]^(2) = [(0,4,2)|(0,0,0)]^(2)*args%PA(3)-([(0,4,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(2)-([(0,4,1)|(0,0,0)]^(3))/2/(2p)
        t(85) = (theta(385)-theta(265))*args%rec_p2
        theta(447) = theta(412)*args%PA(2)-theta(292)*args%PC(2)+t(85)*2 ! [(0,3,4)|(0,0,0)]^(2) = [(0,2,4)|(0,0,0)]^(2)*args%PA(2)-([(0,2,4)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(2)-([(0,1,4)|(0,0,0)]^(3))/2/(2p)
        theta(448) = theta(413)*args%PA(2)-theta(293)*args%PC(2)+t(83)*1 ! [(0,2,5)|(0,0,0)]^(2) = [(0,1,5)|(0,0,0)]^(2)*args%PA(2)-([(0,1,5)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(2)-([(0,0,5)|(0,0,0)]^(3))/1/(2p)
        theta(449) = theta(414)*args%PA(2)-theta(294)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(2) = [(0,0,6)|(0,0,0)]^(2)*args%PA(2)-([(0,0,6)|(0,0,0)]^(3)*args%PC(2)
        theta(450) = theta(414)*args%PA(3)-theta(294)*args%PC(3)+t(83)*6 ! [(0,0,7)|(0,0,0)]^(2) = [(0,0,6)|(0,0,0)]^(2)*args%PA(3)-([(0,0,6)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(2)-([(0,0,5)|(0,0,0)]^(3))/6/(2p)
        t(86) = (theta(387)-theta(267))*args%rec_p2
        theta(451) = theta(415)*args%PA(1)-theta(295)*args%PC(1)+t(86)*7 ! [(8,0,0)|(0,0,0)]^(2) = [(7,0,0)|(0,0,0)]^(2)*args%PA(1)-([(7,0,0)|(0,0,0)]^(3)*args%PC(1)+(([(6,0,0)|(0,0,0)]^(2)-([(6,0,0)|(0,0,0)]^(3))/7/(2p)
        theta(452) = theta(415)*args%PA(2)-theta(295)*args%PC(2) ! [(7,1,0)|(0,0,0)]^(2) = [(7,0,0)|(0,0,0)]^(2)*args%PA(2)-([(7,0,0)|(0,0,0)]^(3)*args%PC(2)
        theta(453) = theta(415)*args%PA(3)-theta(295)*args%PC(3) ! [(7,0,1)|(0,0,0)]^(2) = [(7,0,0)|(0,0,0)]^(2)*args%PA(3)-([(7,0,0)|(0,0,0)]^(3)*args%PC(3)
        theta(454) = theta(416)*args%PA(2)-theta(296)*args%PC(2)+t(86)*1 ! [(6,2,0)|(0,0,0)]^(2) = [(6,1,0)|(0,0,0)]^(2)*args%PA(2)-([(6,1,0)|(0,0,0)]^(3)*args%PC(2)+(([(6,0,0)|(0,0,0)]^(2)-([(6,0,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(455) = theta(417)*args%PA(2)-theta(297)*args%PC(2) ! [(6,1,1)|(0,0,0)]^(2) = [(6,0,1)|(0,0,0)]^(2)*args%PA(2)-([(6,0,1)|(0,0,0)]^(3)*args%PC(2)
        theta(456) = theta(417)*args%PA(3)-theta(297)*args%PC(3)+t(86)*1 ! [(6,0,2)|(0,0,0)]^(2) = [(6,0,1)|(0,0,0)]^(2)*args%PA(3)-([(6,0,1)|(0,0,0)]^(3)*args%PC(3)+(([(6,0,0)|(0,0,0)]^(2)-([(6,0,0)|(0,0,0)]^(3))/1/(2p)
        t(87) = (theta(388)-theta(268))*args%rec_p2
        theta(457) = theta(418)*args%PA(2)-theta(298)*args%PC(2)+t(87)*2 ! [(5,3,0)|(0,0,0)]^(2) = [(5,2,0)|(0,0,0)]^(2)*args%PA(2)-([(5,2,0)|(0,0,0)]^(3)*args%PC(2)+(([(5,1,0)|(0,0,0)]^(2)-([(5,1,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(458) = theta(418)*args%PA(3)-theta(298)*args%PC(3) ! [(5,2,1)|(0,0,0)]^(2) = [(5,2,0)|(0,0,0)]^(2)*args%PA(3)-([(5,2,0)|(0,0,0)]^(3)*args%PC(3)
        ! theta(459) = theta(420)*args%PA(2)-theta(300)*args%PC(2) ! [(5,1,2)|(0,0,0)]^(2) = [(5,0,2)|(0,0,0)]^(2)*args%PA(2)-([(5,0,2)|(0,0,0)]^(3)*args%PC(2)
        t(88) = (theta(389)-theta(269))*args%rec_p2
        theta(460) = theta(420)*args%PA(3)-theta(300)*args%PC(3)+t(88)*2 ! [(5,0,3)|(0,0,0)]^(2) = [(5,0,2)|(0,0,0)]^(2)*args%PA(3)-([(5,0,2)|(0,0,0)]^(3)*args%PC(3)+(([(5,0,1)|(0,0,0)]^(2)-([(5,0,1)|(0,0,0)]^(3))/2/(2p)
        ! theta(461) = theta(425)*args%PA(1)-theta(305)*args%PC(1)+(theta(397)-theta(277))*args%rec_p2*3 ! [(4,4,0)|(0,0,0)]^(2) = [(3,4,0)|(0,0,0)]^(2)*args%PA(1)-([(3,4,0)|(0,0,0)]^(3)*args%PC(1)+(([(2,4,0)|(0,0,0)]^(2)-([(2,4,0)|(0,0,0)]^(3))/3/(2p)
        ! theta(462) = theta(421)*args%PA(3)-theta(301)*args%PC(3) ! [(4,3,1)|(0,0,0)]^(2) = [(4,3,0)|(0,0,0)]^(2)*args%PA(3)-([(4,3,0)|(0,0,0)]^(3)*args%PC(3)
        t(89) = (theta(399)-theta(279))*args%rec_p2
        theta(463) = theta(427)*args%PA(1)-theta(307)*args%PC(1)+t(89)*3 ! [(4,2,2)|(0,0,0)]^(2) = [(3,2,2)|(0,0,0)]^(2)*args%PA(1)-([(3,2,2)|(0,0,0)]^(3)*args%PC(1)+(([(2,2,2)|(0,0,0)]^(2)-([(2,2,2)|(0,0,0)]^(3))/3/(2p)
        ! theta(464) = theta(424)*args%PA(2)-theta(304)*args%PC(2) ! [(4,1,3)|(0,0,0)]^(2) = [(4,0,3)|(0,0,0)]^(2)*args%PA(2)-([(4,0,3)|(0,0,0)]^(3)*args%PC(2)
        ! theta(465) = theta(429)*args%PA(1)-theta(309)*args%PC(1)+(theta(401)-theta(281))*args%rec_p2*3 ! [(4,0,4)|(0,0,0)]^(2) = [(3,0,4)|(0,0,0)]^(2)*args%PA(1)-([(3,0,4)|(0,0,0)]^(3)*args%PC(1)+(([(2,0,4)|(0,0,0)]^(2)-([(2,0,4)|(0,0,0)]^(3))/3/(2p)
        t(90) = (theta(402)-theta(282))*args%rec_p2
        theta(466) = theta(430)*args%PA(1)-theta(310)*args%PC(1)+t(90)*2 ! [(3,5,0)|(0,0,0)]^(2) = [(2,5,0)|(0,0,0)]^(2)*args%PA(1)-([(2,5,0)|(0,0,0)]^(3)*args%PC(1)+(([(1,5,0)|(0,0,0)]^(2)-([(1,5,0)|(0,0,0)]^(3))/2/(2p)
        ! theta(467) = theta(425)*args%PA(3)-theta(305)*args%PC(3) ! [(3,4,1)|(0,0,0)]^(2) = [(3,4,0)|(0,0,0)]^(2)*args%PA(3)-([(3,4,0)|(0,0,0)]^(3)*args%PC(3)
        t(91) = (theta(404)-theta(284))*args%rec_p2
        theta(468) = theta(432)*args%PA(1)-theta(312)*args%PC(1)+t(91)*2 ! [(3,3,2)|(0,0,0)]^(2) = [(2,3,2)|(0,0,0)]^(2)*args%PA(1)-([(2,3,2)|(0,0,0)]^(3)*args%PC(1)+(([(1,3,2)|(0,0,0)]^(2)-([(1,3,2)|(0,0,0)]^(3))/2/(2p)
        t(92) = (theta(405)-theta(285))*args%rec_p2
        theta(469) = theta(433)*args%PA(1)-theta(313)*args%PC(1)+t(92)*2 ! [(3,2,3)|(0,0,0)]^(2) = [(2,2,3)|(0,0,0)]^(2)*args%PA(1)-([(2,2,3)|(0,0,0)]^(3)*args%PC(1)+(([(1,2,3)|(0,0,0)]^(2)-([(1,2,3)|(0,0,0)]^(3))/2/(2p)
        ! theta(470) = theta(429)*args%PA(2)-theta(309)*args%PC(2) ! [(3,1,4)|(0,0,0)]^(2) = [(3,0,4)|(0,0,0)]^(2)*args%PA(2)-([(3,0,4)|(0,0,0)]^(3)*args%PC(2)
        t(93) = (theta(407)-theta(287))*args%rec_p2
        theta(471) = theta(435)*args%PA(1)-theta(315)*args%PC(1)+t(93)*2 ! [(3,0,5)|(0,0,0)]^(2) = [(2,0,5)|(0,0,0)]^(2)*args%PA(1)-([(2,0,5)|(0,0,0)]^(3)*args%PC(1)+(([(1,0,5)|(0,0,0)]^(2)-([(1,0,5)|(0,0,0)]^(3))/2/(2p)
        t(94) = (theta(408)-theta(288))*args%rec_p2
        theta(472) = theta(436)*args%PA(1)-theta(316)*args%PC(1)+t(94)*1 ! [(2,6,0)|(0,0,0)]^(2) = [(1,6,0)|(0,0,0)]^(2)*args%PA(1)-([(1,6,0)|(0,0,0)]^(3)*args%PC(1)+(([(0,6,0)|(0,0,0)]^(2)-([(0,6,0)|(0,0,0)]^(3))/1/(2p)
        ! theta(473) = theta(430)*args%PA(3)-theta(310)*args%PC(3) ! [(2,5,1)|(0,0,0)]^(2) = [(2,5,0)|(0,0,0)]^(2)*args%PA(3)-([(2,5,0)|(0,0,0)]^(3)*args%PC(3)
        t(95) = (theta(410)-theta(290))*args%rec_p2
        theta(474) = theta(438)*args%PA(1)-theta(318)*args%PC(1)+t(95)*1 ! [(2,4,2)|(0,0,0)]^(2) = [(1,4,2)|(0,0,0)]^(2)*args%PA(1)-([(1,4,2)|(0,0,0)]^(3)*args%PC(1)+(([(0,4,2)|(0,0,0)]^(2)-([(0,4,2)|(0,0,0)]^(3))/1/(2p)
        t(96) = (theta(411)-theta(291))*args%rec_p2
        theta(475) = theta(439)*args%PA(1)-theta(319)*args%PC(1)+t(96)*1 ! [(2,3,3)|(0,0,0)]^(2) = [(1,3,3)|(0,0,0)]^(2)*args%PA(1)-([(1,3,3)|(0,0,0)]^(3)*args%PC(1)+(([(0,3,3)|(0,0,0)]^(2)-([(0,3,3)|(0,0,0)]^(3))/1/(2p)
        t(97) = (theta(412)-theta(292))*args%rec_p2
        theta(476) = theta(440)*args%PA(1)-theta(320)*args%PC(1)+t(97)*1 ! [(2,2,4)|(0,0,0)]^(2) = [(1,2,4)|(0,0,0)]^(2)*args%PA(1)-([(1,2,4)|(0,0,0)]^(3)*args%PC(1)+(([(0,2,4)|(0,0,0)]^(2)-([(0,2,4)|(0,0,0)]^(3))/1/(2p)
        ! theta(477) = theta(435)*args%PA(2)-theta(315)*args%PC(2) ! [(2,1,5)|(0,0,0)]^(2) = [(2,0,5)|(0,0,0)]^(2)*args%PA(2)-([(2,0,5)|(0,0,0)]^(3)*args%PC(2)
        t(98) = (theta(414)-theta(294))*args%rec_p2
        theta(478) = theta(442)*args%PA(1)-theta(322)*args%PC(1)+t(98)*1 ! [(2,0,6)|(0,0,0)]^(2) = [(1,0,6)|(0,0,0)]^(2)*args%PA(1)-([(1,0,6)|(0,0,0)]^(3)*args%PC(1)+(([(0,0,6)|(0,0,0)]^(2)-([(0,0,6)|(0,0,0)]^(3))/1/(2p)
        theta(479) = theta(443)*args%PA(1)-theta(323)*args%PC(1) ! [(1,7,0)|(0,0,0)]^(2) = [(0,7,0)|(0,0,0)]^(2)*args%PA(1)-([(0,7,0)|(0,0,0)]^(3)*args%PC(1)
        ! theta(480) = theta(444)*args%PA(1)-theta(324)*args%PC(1) ! [(1,6,1)|(0,0,0)]^(2) = [(0,6,1)|(0,0,0)]^(2)*args%PA(1)-([(0,6,1)|(0,0,0)]^(3)*args%PC(1)
        theta(481) = theta(445)*args%PA(1)-theta(325)*args%PC(1) ! [(1,5,2)|(0,0,0)]^(2) = [(0,5,2)|(0,0,0)]^(2)*args%PA(1)-([(0,5,2)|(0,0,0)]^(3)*args%PC(1)
        theta(482) = theta(446)*args%PA(1)-theta(326)*args%PC(1) ! [(1,4,3)|(0,0,0)]^(2) = [(0,4,3)|(0,0,0)]^(2)*args%PA(1)-([(0,4,3)|(0,0,0)]^(3)*args%PC(1)
        theta(483) = theta(447)*args%PA(1)-theta(327)*args%PC(1) ! [(1,3,4)|(0,0,0)]^(2) = [(0,3,4)|(0,0,0)]^(2)*args%PA(1)-([(0,3,4)|(0,0,0)]^(3)*args%PC(1)
        theta(484) = theta(448)*args%PA(1)-theta(328)*args%PC(1) ! [(1,2,5)|(0,0,0)]^(2) = [(0,2,5)|(0,0,0)]^(2)*args%PA(1)-([(0,2,5)|(0,0,0)]^(3)*args%PC(1)
        ! theta(485) = theta(449)*args%PA(1)-theta(329)*args%PC(1) ! [(1,1,6)|(0,0,0)]^(2) = [(0,1,6)|(0,0,0)]^(2)*args%PA(1)-([(0,1,6)|(0,0,0)]^(3)*args%PC(1)
        theta(486) = theta(450)*args%PA(1)-theta(330)*args%PC(1) ! [(1,0,7)|(0,0,0)]^(2) = [(0,0,7)|(0,0,0)]^(2)*args%PA(1)-([(0,0,7)|(0,0,0)]^(3)*args%PC(1)
        theta(487) = theta(443)*args%PA(2)-theta(323)*args%PC(2)+t(94)*7 ! [(0,8,0)|(0,0,0)]^(2) = [(0,7,0)|(0,0,0)]^(2)*args%PA(2)-([(0,7,0)|(0,0,0)]^(3)*args%PC(2)+(([(0,6,0)|(0,0,0)]^(2)-([(0,6,0)|(0,0,0)]^(3))/7/(2p)
        theta(488) = theta(443)*args%PA(3)-theta(323)*args%PC(3) ! [(0,7,1)|(0,0,0)]^(2) = [(0,7,0)|(0,0,0)]^(2)*args%PA(3)-([(0,7,0)|(0,0,0)]^(3)*args%PC(3)
        theta(489) = theta(444)*args%PA(3)-theta(324)*args%PC(3)+t(94)*1 ! [(0,6,2)|(0,0,0)]^(2) = [(0,6,1)|(0,0,0)]^(2)*args%PA(3)-([(0,6,1)|(0,0,0)]^(3)*args%PC(3)+(([(0,6,0)|(0,0,0)]^(2)-([(0,6,0)|(0,0,0)]^(3))/1/(2p)
        t(99) = (theta(409)-theta(289))*args%rec_p2
        theta(490) = theta(445)*args%PA(3)-theta(325)*args%PC(3)+t(99)*2 ! [(0,5,3)|(0,0,0)]^(2) = [(0,5,2)|(0,0,0)]^(2)*args%PA(3)-([(0,5,2)|(0,0,0)]^(3)*args%PC(3)+(([(0,5,1)|(0,0,0)]^(2)-([(0,5,1)|(0,0,0)]^(3))/2/(2p)
        theta(491) = theta(447)*args%PA(2)-theta(327)*args%PC(2)+t(97)*3 ! [(0,4,4)|(0,0,0)]^(2) = [(0,3,4)|(0,0,0)]^(2)*args%PA(2)-([(0,3,4)|(0,0,0)]^(3)*args%PC(2)+(([(0,2,4)|(0,0,0)]^(2)-([(0,2,4)|(0,0,0)]^(3))/3/(2p)
        t(100) = (theta(413)-theta(293))*args%rec_p2
        theta(492) = theta(448)*args%PA(2)-theta(328)*args%PC(2)+t(100)*2 ! [(0,3,5)|(0,0,0)]^(2) = [(0,2,5)|(0,0,0)]^(2)*args%PA(2)-([(0,2,5)|(0,0,0)]^(3)*args%PC(2)+(([(0,1,5)|(0,0,0)]^(2)-([(0,1,5)|(0,0,0)]^(3))/2/(2p)
        theta(493) = theta(449)*args%PA(2)-theta(329)*args%PC(2)+t(98)*1 ! [(0,2,6)|(0,0,0)]^(2) = [(0,1,6)|(0,0,0)]^(2)*args%PA(2)-([(0,1,6)|(0,0,0)]^(3)*args%PC(2)+(([(0,0,6)|(0,0,0)]^(2)-([(0,0,6)|(0,0,0)]^(3))/1/(2p)
        theta(494) = theta(450)*args%PA(2)-theta(330)*args%PC(2) ! [(0,1,7)|(0,0,0)]^(2) = [(0,0,7)|(0,0,0)]^(2)*args%PA(2)-([(0,0,7)|(0,0,0)]^(3)*args%PC(2)
        theta(495) = theta(450)*args%PA(3)-theta(330)*args%PC(3)+t(98)*7 ! [(0,0,8)|(0,0,0)]^(2) = [(0,0,7)|(0,0,0)]^(2)*args%PA(3)-([(0,0,7)|(0,0,0)]^(3)*args%PC(3)+(([(0,0,6)|(0,0,0)]^(2)-([(0,0,6)|(0,0,0)]^(3))/7/(2p)
        theta(497) = theta(496)*args%PA(1)-theta(331)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(1)-([(0,0,0)|(0,0,0)]^(2)*args%PC(1)
        theta(498) = theta(496)*args%PA(2)-theta(331)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(2)-([(0,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(499) = theta(496)*args%PA(3)-theta(331)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(1) = [(0,0,0)|(0,0,0)]^(1)*args%PA(3)-([(0,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(101) = (theta(496)-theta(331))*args%rec_p2
        theta(500) = theta(497)*args%PA(1)-theta(332)*args%PC(1)+t(101)*1 ! [(2,0,0)|(0,0,0)]^(1) = [(1,0,0)|(0,0,0)]^(1)*args%PA(1)-([(1,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(501) = theta(498)*args%PA(1)-theta(333)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(1)-([(0,1,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(502) = theta(499)*args%PA(1)-theta(334)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(1)-([(0,0,1)|(0,0,0)]^(2)*args%PC(1)
        theta(503) = theta(498)*args%PA(2)-theta(333)*args%PC(2)+t(101)*1 ! [(0,2,0)|(0,0,0)]^(1) = [(0,1,0)|(0,0,0)]^(1)*args%PA(2)-([(0,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(504) = theta(499)*args%PA(2)-theta(334)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(2)-([(0,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(505) = theta(499)*args%PA(3)-theta(334)*args%PC(3)+t(101)*1 ! [(0,0,2)|(0,0,0)]^(1) = [(0,0,1)|(0,0,0)]^(1)*args%PA(3)-([(0,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(1)-([(0,0,0)|(0,0,0)]^(2))/1/(2p)
        t(102) = (theta(497)-theta(332))*args%rec_p2
        theta(506) = theta(500)*args%PA(1)-theta(335)*args%PC(1)+t(102)*2 ! [(3,0,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(1)-([(2,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(1)-([(1,0,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(507) = theta(500)*args%PA(2)-theta(335)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(2)-([(2,0,0)|(0,0,0)]^(2)*args%PC(2)
        ! theta(508) = theta(500)*args%PA(3)-theta(335)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(1) = [(2,0,0)|(0,0,0)]^(1)*args%PA(3)-([(2,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(509) = theta(503)*args%PA(1)-theta(338)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(1)-([(0,2,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(510) = theta(504)*args%PA(1)-theta(339)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(1) = [(0,1,1)|(0,0,0)]^(1)*args%PA(1)-([(0,1,1)|(0,0,0)]^(2)*args%PC(1)
        theta(511) = theta(505)*args%PA(1)-theta(340)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(1)-([(0,0,2)|(0,0,0)]^(2)*args%PC(1)
        t(103) = (theta(498)-theta(333))*args%rec_p2
        theta(512) = theta(503)*args%PA(2)-theta(338)*args%PC(2)+t(103)*2 ! [(0,3,0)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(2)-([(0,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(1)-([(0,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(513) = theta(503)*args%PA(3)-theta(338)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(1) = [(0,2,0)|(0,0,0)]^(1)*args%PA(3)-([(0,2,0)|(0,0,0)]^(2)*args%PC(3)
        theta(514) = theta(505)*args%PA(2)-theta(340)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(2)-([(0,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(104) = (theta(499)-theta(334))*args%rec_p2
        theta(515) = theta(505)*args%PA(3)-theta(340)*args%PC(3)+t(104)*2 ! [(0,0,3)|(0,0,0)]^(1) = [(0,0,2)|(0,0,0)]^(1)*args%PA(3)-([(0,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(1)-([(0,0,1)|(0,0,0)]^(2))/2/(2p)
        t(105) = (theta(500)-theta(335))*args%rec_p2
        theta(516) = theta(506)*args%PA(1)-theta(341)*args%PC(1)+t(105)*3 ! [(4,0,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(1)-([(3,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(1)-([(2,0,0)|(0,0,0)]^(2))/3/(2p)
        theta(517) = theta(506)*args%PA(2)-theta(341)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(2)-([(3,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(518) = theta(506)*args%PA(3)-theta(341)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(1) = [(3,0,0)|(0,0,0)]^(1)*args%PA(3)-([(3,0,0)|(0,0,0)]^(2)*args%PC(3)
        t(106) = (theta(503)-theta(338))*args%rec_p2
        theta(519) = theta(509)*args%PA(1)-theta(344)*args%PC(1)+t(106)*1 ! [(2,2,0)|(0,0,0)]^(1) = [(1,2,0)|(0,0,0)]^(1)*args%PA(1)-([(1,2,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(520) = theta(508)*args%PA(2)-theta(343)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(1) = [(2,0,1)|(0,0,0)]^(1)*args%PA(2)-([(2,0,1)|(0,0,0)]^(2)*args%PC(2)
        t(107) = (theta(505)-theta(340))*args%rec_p2
        theta(521) = theta(511)*args%PA(1)-theta(346)*args%PC(1)+t(107)*1 ! [(2,0,2)|(0,0,0)]^(1) = [(1,0,2)|(0,0,0)]^(1)*args%PA(1)-([(1,0,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(522) = theta(512)*args%PA(1)-theta(347)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(1)-([(0,3,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(523) = theta(513)*args%PA(1)-theta(348)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(1) = [(0,2,1)|(0,0,0)]^(1)*args%PA(1)-([(0,2,1)|(0,0,0)]^(2)*args%PC(1)
        ! theta(524) = theta(514)*args%PA(1)-theta(349)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(1)-([(0,1,2)|(0,0,0)]^(2)*args%PC(1)
        theta(525) = theta(515)*args%PA(1)-theta(350)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(1)-([(0,0,3)|(0,0,0)]^(2)*args%PC(1)
        theta(526) = theta(512)*args%PA(2)-theta(347)*args%PC(2)+t(106)*3 ! [(0,4,0)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(2)-([(0,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(1)-([(0,2,0)|(0,0,0)]^(2))/3/(2p)
        theta(527) = theta(512)*args%PA(3)-theta(347)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(1) = [(0,3,0)|(0,0,0)]^(1)*args%PA(3)-([(0,3,0)|(0,0,0)]^(2)*args%PC(3)
        theta(528) = theta(514)*args%PA(2)-theta(349)*args%PC(2)+t(107)*1 ! [(0,2,2)|(0,0,0)]^(1) = [(0,1,2)|(0,0,0)]^(1)*args%PA(2)-([(0,1,2)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/1/(2p)
        theta(529) = theta(515)*args%PA(2)-theta(350)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(2)-([(0,0,3)|(0,0,0)]^(2)*args%PC(2)
        theta(530) = theta(515)*args%PA(3)-theta(350)*args%PC(3)+t(107)*3 ! [(0,0,4)|(0,0,0)]^(1) = [(0,0,3)|(0,0,0)]^(1)*args%PA(3)-([(0,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(1)-([(0,0,2)|(0,0,0)]^(2))/3/(2p)
        t(108) = (theta(506)-theta(341))*args%rec_p2
        theta(531) = theta(516)*args%PA(1)-theta(351)*args%PC(1)+t(108)*4 ! [(5,0,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(1)-([(4,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/4/(2p)
        theta(532) = theta(516)*args%PA(2)-theta(351)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(2)-([(4,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(533) = theta(516)*args%PA(3)-theta(351)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(1) = [(4,0,0)|(0,0,0)]^(1)*args%PA(3)-([(4,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(534) = theta(517)*args%PA(2)-theta(352)*args%PC(2)+t(108)*1 ! [(3,2,0)|(0,0,0)]^(1) = [(3,1,0)|(0,0,0)]^(1)*args%PA(2)-([(3,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(535) = theta(518)*args%PA(2)-theta(353)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(2)-([(3,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(536) = theta(518)*args%PA(3)-theta(353)*args%PC(3)+t(108)*1 ! [(3,0,2)|(0,0,0)]^(1) = [(3,0,1)|(0,0,0)]^(1)*args%PA(3)-([(3,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(1)-([(3,0,0)|(0,0,0)]^(2))/1/(2p)
        t(109) = (theta(512)-theta(347))*args%rec_p2
        theta(537) = theta(522)*args%PA(1)-theta(357)*args%PC(1)+t(109)*1 ! [(2,3,0)|(0,0,0)]^(1) = [(1,3,0)|(0,0,0)]^(1)*args%PA(1)-([(1,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(538) = theta(519)*args%PA(3)-theta(354)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(1) = [(2,2,0)|(0,0,0)]^(1)*args%PA(3)-([(2,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(539) = theta(521)*args%PA(2)-theta(356)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(1) = [(2,0,2)|(0,0,0)]^(1)*args%PA(2)-([(2,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(110) = (theta(515)-theta(350))*args%rec_p2
        theta(540) = theta(525)*args%PA(1)-theta(360)*args%PC(1)+t(110)*1 ! [(2,0,3)|(0,0,0)]^(1) = [(1,0,3)|(0,0,0)]^(1)*args%PA(1)-([(1,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(541) = theta(526)*args%PA(1)-theta(361)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(1)-([(0,4,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(542) = theta(527)*args%PA(1)-theta(362)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(1)-([(0,3,1)|(0,0,0)]^(2)*args%PC(1)
        theta(543) = theta(528)*args%PA(1)-theta(363)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(1) = [(0,2,2)|(0,0,0)]^(1)*args%PA(1)-([(0,2,2)|(0,0,0)]^(2)*args%PC(1)
        ! theta(544) = theta(529)*args%PA(1)-theta(364)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(1)-([(0,1,3)|(0,0,0)]^(2)*args%PC(1)
        theta(545) = theta(530)*args%PA(1)-theta(365)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(1)-([(0,0,4)|(0,0,0)]^(2)*args%PC(1)
        theta(546) = theta(526)*args%PA(2)-theta(361)*args%PC(2)+t(109)*4 ! [(0,5,0)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(2)-([(0,4,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/4/(2p)
        theta(547) = theta(526)*args%PA(3)-theta(361)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(1) = [(0,4,0)|(0,0,0)]^(1)*args%PA(3)-([(0,4,0)|(0,0,0)]^(2)*args%PC(3)
        theta(548) = theta(527)*args%PA(3)-theta(362)*args%PC(3)+t(109)*1 ! [(0,3,2)|(0,0,0)]^(1) = [(0,3,1)|(0,0,0)]^(1)*args%PA(3)-([(0,3,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(1)-([(0,3,0)|(0,0,0)]^(2))/1/(2p)
        theta(549) = theta(529)*args%PA(2)-theta(364)*args%PC(2)+t(110)*1 ! [(0,2,3)|(0,0,0)]^(1) = [(0,1,3)|(0,0,0)]^(1)*args%PA(2)-([(0,1,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/1/(2p)
        theta(550) = theta(530)*args%PA(2)-theta(365)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(2)-([(0,0,4)|(0,0,0)]^(2)*args%PC(2)
        theta(551) = theta(530)*args%PA(3)-theta(365)*args%PC(3)+t(110)*4 ! [(0,0,5)|(0,0,0)]^(1) = [(0,0,4)|(0,0,0)]^(1)*args%PA(3)-([(0,0,4)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(1)-([(0,0,3)|(0,0,0)]^(2))/4/(2p)
        t(111) = (theta(516)-theta(351))*args%rec_p2
        theta(552) = theta(531)*args%PA(1)-theta(366)*args%PC(1)+t(111)*5 ! [(6,0,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(1)-([(5,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/5/(2p)
        theta(553) = theta(531)*args%PA(2)-theta(366)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(2)-([(5,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(554) = theta(531)*args%PA(3)-theta(366)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(1) = [(5,0,0)|(0,0,0)]^(1)*args%PA(3)-([(5,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(555) = theta(532)*args%PA(2)-theta(367)*args%PC(2)+t(111)*1 ! [(4,2,0)|(0,0,0)]^(1) = [(4,1,0)|(0,0,0)]^(1)*args%PA(2)-([(4,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(556) = theta(533)*args%PA(2)-theta(368)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(2)-([(4,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(557) = theta(533)*args%PA(3)-theta(368)*args%PC(3)+t(111)*1 ! [(4,0,2)|(0,0,0)]^(1) = [(4,0,1)|(0,0,0)]^(1)*args%PA(3)-([(4,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(1)-([(4,0,0)|(0,0,0)]^(2))/1/(2p)
        t(112) = (theta(522)-theta(357))*args%rec_p2
        theta(558) = theta(537)*args%PA(1)-theta(372)*args%PC(1)+t(112)*2 ! [(3,3,0)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(1)-([(2,3,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(1)-([(1,3,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(559) = theta(534)*args%PA(3)-theta(369)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(1) = [(3,2,0)|(0,0,0)]^(1)*args%PA(3)-([(3,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(560) = theta(536)*args%PA(2)-theta(371)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(1) = [(3,0,2)|(0,0,0)]^(1)*args%PA(2)-([(3,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(113) = (theta(525)-theta(360))*args%rec_p2
        theta(561) = theta(540)*args%PA(1)-theta(375)*args%PC(1)+t(113)*2 ! [(3,0,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(1)-([(2,0,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(1)-([(1,0,3)|(0,0,0)]^(2))/2/(2p)
        t(114) = (theta(526)-theta(361))*args%rec_p2
        theta(562) = theta(541)*args%PA(1)-theta(376)*args%PC(1)+t(114)*1 ! [(2,4,0)|(0,0,0)]^(1) = [(1,4,0)|(0,0,0)]^(1)*args%PA(1)-([(1,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(563) = theta(537)*args%PA(3)-theta(372)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(1) = [(2,3,0)|(0,0,0)]^(1)*args%PA(3)-([(2,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(115) = (theta(528)-theta(363))*args%rec_p2
        theta(564) = theta(543)*args%PA(1)-theta(378)*args%PC(1)+t(115)*1 ! [(2,2,2)|(0,0,0)]^(1) = [(1,2,2)|(0,0,0)]^(1)*args%PA(1)-([(1,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(1)-([(0,2,2)|(0,0,0)]^(2))/1/(2p)
        ! theta(565) = theta(540)*args%PA(2)-theta(375)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(1) = [(2,0,3)|(0,0,0)]^(1)*args%PA(2)-([(2,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(116) = (theta(530)-theta(365))*args%rec_p2
        theta(566) = theta(545)*args%PA(1)-theta(380)*args%PC(1)+t(116)*1 ! [(2,0,4)|(0,0,0)]^(1) = [(1,0,4)|(0,0,0)]^(1)*args%PA(1)-([(1,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(567) = theta(546)*args%PA(1)-theta(381)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(1)-([(0,5,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(568) = theta(547)*args%PA(1)-theta(382)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(1)-([(0,4,1)|(0,0,0)]^(2)*args%PC(1)
        theta(569) = theta(548)*args%PA(1)-theta(383)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(1) = [(0,3,2)|(0,0,0)]^(1)*args%PA(1)-([(0,3,2)|(0,0,0)]^(2)*args%PC(1)
        theta(570) = theta(549)*args%PA(1)-theta(384)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(1)-([(0,2,3)|(0,0,0)]^(2)*args%PC(1)
        ! theta(571) = theta(550)*args%PA(1)-theta(385)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(1)-([(0,1,4)|(0,0,0)]^(2)*args%PC(1)
        theta(572) = theta(551)*args%PA(1)-theta(386)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(1)-([(0,0,5)|(0,0,0)]^(2)*args%PC(1)
        theta(573) = theta(546)*args%PA(2)-theta(381)*args%PC(2)+t(114)*5 ! [(0,6,0)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(2)-([(0,5,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/5/(2p)
        theta(574) = theta(546)*args%PA(3)-theta(381)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(1) = [(0,5,0)|(0,0,0)]^(1)*args%PA(3)-([(0,5,0)|(0,0,0)]^(2)*args%PC(3)
        theta(575) = theta(547)*args%PA(3)-theta(382)*args%PC(3)+t(114)*1 ! [(0,4,2)|(0,0,0)]^(1) = [(0,4,1)|(0,0,0)]^(1)*args%PA(3)-([(0,4,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(1)-([(0,4,0)|(0,0,0)]^(2))/1/(2p)
        t(117) = (theta(529)-theta(364))*args%rec_p2
        theta(576) = theta(549)*args%PA(2)-theta(384)*args%PC(2)+t(117)*2 ! [(0,3,3)|(0,0,0)]^(1) = [(0,2,3)|(0,0,0)]^(1)*args%PA(2)-([(0,2,3)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(1)-([(0,1,3)|(0,0,0)]^(2))/2/(2p)
        theta(577) = theta(550)*args%PA(2)-theta(385)*args%PC(2)+t(116)*1 ! [(0,2,4)|(0,0,0)]^(1) = [(0,1,4)|(0,0,0)]^(1)*args%PA(2)-([(0,1,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/1/(2p)
        theta(578) = theta(551)*args%PA(2)-theta(386)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(2)-([(0,0,5)|(0,0,0)]^(2)*args%PC(2)
        theta(579) = theta(551)*args%PA(3)-theta(386)*args%PC(3)+t(116)*5 ! [(0,0,6)|(0,0,0)]^(1) = [(0,0,5)|(0,0,0)]^(1)*args%PA(3)-([(0,0,5)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(1)-([(0,0,4)|(0,0,0)]^(2))/5/(2p)
        t(118) = (theta(531)-theta(366))*args%rec_p2
        theta(580) = theta(552)*args%PA(1)-theta(387)*args%PC(1)+t(118)*6 ! [(7,0,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(1)-([(6,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/6/(2p)
        theta(581) = theta(552)*args%PA(2)-theta(387)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(2)-([(6,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(582) = theta(552)*args%PA(3)-theta(387)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(1) = [(6,0,0)|(0,0,0)]^(1)*args%PA(3)-([(6,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(583) = theta(553)*args%PA(2)-theta(388)*args%PC(2)+t(118)*1 ! [(5,2,0)|(0,0,0)]^(1) = [(5,1,0)|(0,0,0)]^(1)*args%PA(2)-([(5,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(584) = theta(554)*args%PA(2)-theta(389)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(2)-([(5,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(585) = theta(554)*args%PA(3)-theta(389)*args%PC(3)+t(118)*1 ! [(5,0,2)|(0,0,0)]^(1) = [(5,0,1)|(0,0,0)]^(1)*args%PA(3)-([(5,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(1)-([(5,0,0)|(0,0,0)]^(2))/1/(2p)
        t(119) = (theta(532)-theta(367))*args%rec_p2
        theta(586) = theta(555)*args%PA(2)-theta(390)*args%PC(2)+t(119)*2 ! [(4,3,0)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(2)-([(4,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(1)-([(4,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(587) = theta(555)*args%PA(3)-theta(390)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(1) = [(4,2,0)|(0,0,0)]^(1)*args%PA(3)-([(4,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(588) = theta(557)*args%PA(2)-theta(392)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(2)-([(4,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(120) = (theta(533)-theta(368))*args%rec_p2
        theta(589) = theta(557)*args%PA(3)-theta(392)*args%PC(3)+t(120)*2 ! [(4,0,3)|(0,0,0)]^(1) = [(4,0,2)|(0,0,0)]^(1)*args%PA(3)-([(4,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(1)-([(4,0,1)|(0,0,0)]^(2))/2/(2p)
        t(121) = (theta(541)-theta(376))*args%rec_p2
        theta(590) = theta(562)*args%PA(1)-theta(397)*args%PC(1)+t(121)*2 ! [(3,4,0)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(1)-([(2,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(1)-([(1,4,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(591) = theta(558)*args%PA(3)-theta(393)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(1) = [(3,3,0)|(0,0,0)]^(1)*args%PA(3)-([(3,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(122) = (theta(543)-theta(378))*args%rec_p2
        theta(592) = theta(564)*args%PA(1)-theta(399)*args%PC(1)+t(122)*2 ! [(3,2,2)|(0,0,0)]^(1) = [(2,2,2)|(0,0,0)]^(1)*args%PA(1)-([(2,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(1)-([(1,2,2)|(0,0,0)]^(2))/2/(2p)
        ! theta(593) = theta(561)*args%PA(2)-theta(396)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(1) = [(3,0,3)|(0,0,0)]^(1)*args%PA(2)-([(3,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(123) = (theta(545)-theta(380))*args%rec_p2
        theta(594) = theta(566)*args%PA(1)-theta(401)*args%PC(1)+t(123)*2 ! [(3,0,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(1)-([(2,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(1)-([(1,0,4)|(0,0,0)]^(2))/2/(2p)
        t(124) = (theta(546)-theta(381))*args%rec_p2
        theta(595) = theta(567)*args%PA(1)-theta(402)*args%PC(1)+t(124)*1 ! [(2,5,0)|(0,0,0)]^(1) = [(1,5,0)|(0,0,0)]^(1)*args%PA(1)-([(1,5,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(596) = theta(562)*args%PA(3)-theta(397)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(1) = [(2,4,0)|(0,0,0)]^(1)*args%PA(3)-([(2,4,0)|(0,0,0)]^(2)*args%PC(3)
        t(125) = (theta(548)-theta(383))*args%rec_p2
        theta(597) = theta(569)*args%PA(1)-theta(404)*args%PC(1)+t(125)*1 ! [(2,3,2)|(0,0,0)]^(1) = [(1,3,2)|(0,0,0)]^(1)*args%PA(1)-([(1,3,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(1)-([(0,3,2)|(0,0,0)]^(2))/1/(2p)
        t(126) = (theta(549)-theta(384))*args%rec_p2
        theta(598) = theta(570)*args%PA(1)-theta(405)*args%PC(1)+t(126)*1 ! [(2,2,3)|(0,0,0)]^(1) = [(1,2,3)|(0,0,0)]^(1)*args%PA(1)-([(1,2,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(1)-([(0,2,3)|(0,0,0)]^(2))/1/(2p)
        ! theta(599) = theta(566)*args%PA(2)-theta(401)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(1) = [(2,0,4)|(0,0,0)]^(1)*args%PA(2)-([(2,0,4)|(0,0,0)]^(2)*args%PC(2)
        t(127) = (theta(551)-theta(386))*args%rec_p2
        theta(600) = theta(572)*args%PA(1)-theta(407)*args%PC(1)+t(127)*1 ! [(2,0,5)|(0,0,0)]^(1) = [(1,0,5)|(0,0,0)]^(1)*args%PA(1)-([(1,0,5)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(601) = theta(573)*args%PA(1)-theta(408)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(1)-([(0,6,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(602) = theta(574)*args%PA(1)-theta(409)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(1)-([(0,5,1)|(0,0,0)]^(2)*args%PC(1)
        theta(603) = theta(575)*args%PA(1)-theta(410)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(1)-([(0,4,2)|(0,0,0)]^(2)*args%PC(1)
        theta(604) = theta(576)*args%PA(1)-theta(411)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(1) = [(0,3,3)|(0,0,0)]^(1)*args%PA(1)-([(0,3,3)|(0,0,0)]^(2)*args%PC(1)
        theta(605) = theta(577)*args%PA(1)-theta(412)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(1)-([(0,2,4)|(0,0,0)]^(2)*args%PC(1)
        ! theta(606) = theta(578)*args%PA(1)-theta(413)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(1)-([(0,1,5)|(0,0,0)]^(2)*args%PC(1)
        theta(607) = theta(579)*args%PA(1)-theta(414)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(1)-([(0,0,6)|(0,0,0)]^(2)*args%PC(1)
        theta(608) = theta(573)*args%PA(2)-theta(408)*args%PC(2)+t(124)*6 ! [(0,7,0)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(2)-([(0,6,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/6/(2p)
        theta(609) = theta(573)*args%PA(3)-theta(408)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(1) = [(0,6,0)|(0,0,0)]^(1)*args%PA(3)-([(0,6,0)|(0,0,0)]^(2)*args%PC(3)
        theta(610) = theta(574)*args%PA(3)-theta(409)*args%PC(3)+t(124)*1 ! [(0,5,2)|(0,0,0)]^(1) = [(0,5,1)|(0,0,0)]^(1)*args%PA(3)-([(0,5,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(1)-([(0,5,0)|(0,0,0)]^(2))/1/(2p)
        t(128) = (theta(547)-theta(382))*args%rec_p2
        theta(611) = theta(575)*args%PA(3)-theta(410)*args%PC(3)+t(128)*2 ! [(0,4,3)|(0,0,0)]^(1) = [(0,4,2)|(0,0,0)]^(1)*args%PA(3)-([(0,4,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(1)-([(0,4,1)|(0,0,0)]^(2))/2/(2p)
        t(129) = (theta(550)-theta(385))*args%rec_p2
        theta(612) = theta(577)*args%PA(2)-theta(412)*args%PC(2)+t(129)*2 ! [(0,3,4)|(0,0,0)]^(1) = [(0,2,4)|(0,0,0)]^(1)*args%PA(2)-([(0,2,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(1)-([(0,1,4)|(0,0,0)]^(2))/2/(2p)
        theta(613) = theta(578)*args%PA(2)-theta(413)*args%PC(2)+t(127)*1 ! [(0,2,5)|(0,0,0)]^(1) = [(0,1,5)|(0,0,0)]^(1)*args%PA(2)-([(0,1,5)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/1/(2p)
        theta(614) = theta(579)*args%PA(2)-theta(414)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(2)-([(0,0,6)|(0,0,0)]^(2)*args%PC(2)
        theta(615) = theta(579)*args%PA(3)-theta(414)*args%PC(3)+t(127)*6 ! [(0,0,7)|(0,0,0)]^(1) = [(0,0,6)|(0,0,0)]^(1)*args%PA(3)-([(0,0,6)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(1)-([(0,0,5)|(0,0,0)]^(2))/6/(2p)
        t(130) = (theta(552)-theta(387))*args%rec_p2
        theta(616) = theta(580)*args%PA(1)-theta(415)*args%PC(1)+t(130)*7 ! [(8,0,0)|(0,0,0)]^(1) = [(7,0,0)|(0,0,0)]^(1)*args%PA(1)-([(7,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(6,0,0)|(0,0,0)]^(1)-([(6,0,0)|(0,0,0)]^(2))/7/(2p)
        theta(617) = theta(580)*args%PA(2)-theta(415)*args%PC(2) ! [(7,1,0)|(0,0,0)]^(1) = [(7,0,0)|(0,0,0)]^(1)*args%PA(2)-([(7,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(618) = theta(580)*args%PA(3)-theta(415)*args%PC(3) ! [(7,0,1)|(0,0,0)]^(1) = [(7,0,0)|(0,0,0)]^(1)*args%PA(3)-([(7,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(619) = theta(581)*args%PA(2)-theta(416)*args%PC(2)+t(130)*1 ! [(6,2,0)|(0,0,0)]^(1) = [(6,1,0)|(0,0,0)]^(1)*args%PA(2)-([(6,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(6,0,0)|(0,0,0)]^(1)-([(6,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(620) = theta(582)*args%PA(2)-theta(417)*args%PC(2) ! [(6,1,1)|(0,0,0)]^(1) = [(6,0,1)|(0,0,0)]^(1)*args%PA(2)-([(6,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(621) = theta(582)*args%PA(3)-theta(417)*args%PC(3)+t(130)*1 ! [(6,0,2)|(0,0,0)]^(1) = [(6,0,1)|(0,0,0)]^(1)*args%PA(3)-([(6,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(6,0,0)|(0,0,0)]^(1)-([(6,0,0)|(0,0,0)]^(2))/1/(2p)
        t(131) = (theta(553)-theta(388))*args%rec_p2
        theta(622) = theta(583)*args%PA(2)-theta(418)*args%PC(2)+t(131)*2 ! [(5,3,0)|(0,0,0)]^(1) = [(5,2,0)|(0,0,0)]^(1)*args%PA(2)-([(5,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(5,1,0)|(0,0,0)]^(1)-([(5,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(623) = theta(583)*args%PA(3)-theta(418)*args%PC(3) ! [(5,2,1)|(0,0,0)]^(1) = [(5,2,0)|(0,0,0)]^(1)*args%PA(3)-([(5,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(624) = theta(585)*args%PA(2)-theta(420)*args%PC(2) ! [(5,1,2)|(0,0,0)]^(1) = [(5,0,2)|(0,0,0)]^(1)*args%PA(2)-([(5,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(132) = (theta(554)-theta(389))*args%rec_p2
        theta(625) = theta(585)*args%PA(3)-theta(420)*args%PC(3)+t(132)*2 ! [(5,0,3)|(0,0,0)]^(1) = [(5,0,2)|(0,0,0)]^(1)*args%PA(3)-([(5,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(5,0,1)|(0,0,0)]^(1)-([(5,0,1)|(0,0,0)]^(2))/2/(2p)
        t(133) = (theta(562)-theta(397))*args%rec_p2
        theta(626) = theta(590)*args%PA(1)-theta(425)*args%PC(1)+t(133)*3 ! [(4,4,0)|(0,0,0)]^(1) = [(3,4,0)|(0,0,0)]^(1)*args%PA(1)-([(3,4,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,4,0)|(0,0,0)]^(1)-([(2,4,0)|(0,0,0)]^(2))/3/(2p)
        ! theta(627) = theta(586)*args%PA(3)-theta(421)*args%PC(3) ! [(4,3,1)|(0,0,0)]^(1) = [(4,3,0)|(0,0,0)]^(1)*args%PA(3)-([(4,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(134) = (theta(564)-theta(399))*args%rec_p2
        theta(628) = theta(592)*args%PA(1)-theta(427)*args%PC(1)+t(134)*3 ! [(4,2,2)|(0,0,0)]^(1) = [(3,2,2)|(0,0,0)]^(1)*args%PA(1)-([(3,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(2,2,2)|(0,0,0)]^(1)-([(2,2,2)|(0,0,0)]^(2))/3/(2p)
        ! theta(629) = theta(589)*args%PA(2)-theta(424)*args%PC(2) ! [(4,1,3)|(0,0,0)]^(1) = [(4,0,3)|(0,0,0)]^(1)*args%PA(2)-([(4,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(135) = (theta(566)-theta(401))*args%rec_p2
        theta(630) = theta(594)*args%PA(1)-theta(429)*args%PC(1)+t(135)*3 ! [(4,0,4)|(0,0,0)]^(1) = [(3,0,4)|(0,0,0)]^(1)*args%PA(1)-([(3,0,4)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,4)|(0,0,0)]^(1)-([(2,0,4)|(0,0,0)]^(2))/3/(2p)
        t(136) = (theta(567)-theta(402))*args%rec_p2
        theta(631) = theta(595)*args%PA(1)-theta(430)*args%PC(1)+t(136)*2 ! [(3,5,0)|(0,0,0)]^(1) = [(2,5,0)|(0,0,0)]^(1)*args%PA(1)-([(2,5,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,5,0)|(0,0,0)]^(1)-([(1,5,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(632) = theta(590)*args%PA(3)-theta(425)*args%PC(3) ! [(3,4,1)|(0,0,0)]^(1) = [(3,4,0)|(0,0,0)]^(1)*args%PA(3)-([(3,4,0)|(0,0,0)]^(2)*args%PC(3)
        t(137) = (theta(569)-theta(404))*args%rec_p2
        theta(633) = theta(597)*args%PA(1)-theta(432)*args%PC(1)+t(137)*2 ! [(3,3,2)|(0,0,0)]^(1) = [(2,3,2)|(0,0,0)]^(1)*args%PA(1)-([(2,3,2)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,2)|(0,0,0)]^(1)-([(1,3,2)|(0,0,0)]^(2))/2/(2p)
        t(138) = (theta(570)-theta(405))*args%rec_p2
        theta(634) = theta(598)*args%PA(1)-theta(433)*args%PC(1)+t(138)*2 ! [(3,2,3)|(0,0,0)]^(1) = [(2,2,3)|(0,0,0)]^(1)*args%PA(1)-([(2,2,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,2,3)|(0,0,0)]^(1)-([(1,2,3)|(0,0,0)]^(2))/2/(2p)
        ! theta(635) = theta(594)*args%PA(2)-theta(429)*args%PC(2) ! [(3,1,4)|(0,0,0)]^(1) = [(3,0,4)|(0,0,0)]^(1)*args%PA(2)-([(3,0,4)|(0,0,0)]^(2)*args%PC(2)
        t(139) = (theta(572)-theta(407))*args%rec_p2
        theta(636) = theta(600)*args%PA(1)-theta(435)*args%PC(1)+t(139)*2 ! [(3,0,5)|(0,0,0)]^(1) = [(2,0,5)|(0,0,0)]^(1)*args%PA(1)-([(2,0,5)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,5)|(0,0,0)]^(1)-([(1,0,5)|(0,0,0)]^(2))/2/(2p)
        t(140) = (theta(573)-theta(408))*args%rec_p2
        theta(637) = theta(601)*args%PA(1)-theta(436)*args%PC(1)+t(140)*1 ! [(2,6,0)|(0,0,0)]^(1) = [(1,6,0)|(0,0,0)]^(1)*args%PA(1)-([(1,6,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,6,0)|(0,0,0)]^(1)-([(0,6,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(638) = theta(595)*args%PA(3)-theta(430)*args%PC(3) ! [(2,5,1)|(0,0,0)]^(1) = [(2,5,0)|(0,0,0)]^(1)*args%PA(3)-([(2,5,0)|(0,0,0)]^(2)*args%PC(3)
        t(141) = (theta(575)-theta(410))*args%rec_p2
        theta(639) = theta(603)*args%PA(1)-theta(438)*args%PC(1)+t(141)*1 ! [(2,4,2)|(0,0,0)]^(1) = [(1,4,2)|(0,0,0)]^(1)*args%PA(1)-([(1,4,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,2)|(0,0,0)]^(1)-([(0,4,2)|(0,0,0)]^(2))/1/(2p)
        t(142) = (theta(576)-theta(411))*args%rec_p2
        theta(640) = theta(604)*args%PA(1)-theta(439)*args%PC(1)+t(142)*1 ! [(2,3,3)|(0,0,0)]^(1) = [(1,3,3)|(0,0,0)]^(1)*args%PA(1)-([(1,3,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,3)|(0,0,0)]^(1)-([(0,3,3)|(0,0,0)]^(2))/1/(2p)
        t(143) = (theta(577)-theta(412))*args%rec_p2
        theta(641) = theta(605)*args%PA(1)-theta(440)*args%PC(1)+t(143)*1 ! [(2,2,4)|(0,0,0)]^(1) = [(1,2,4)|(0,0,0)]^(1)*args%PA(1)-([(1,2,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,4)|(0,0,0)]^(1)-([(0,2,4)|(0,0,0)]^(2))/1/(2p)
        ! theta(642) = theta(600)*args%PA(2)-theta(435)*args%PC(2) ! [(2,1,5)|(0,0,0)]^(1) = [(2,0,5)|(0,0,0)]^(1)*args%PA(2)-([(2,0,5)|(0,0,0)]^(2)*args%PC(2)
        t(144) = (theta(579)-theta(414))*args%rec_p2
        theta(643) = theta(607)*args%PA(1)-theta(442)*args%PC(1)+t(144)*1 ! [(2,0,6)|(0,0,0)]^(1) = [(1,0,6)|(0,0,0)]^(1)*args%PA(1)-([(1,0,6)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,6)|(0,0,0)]^(1)-([(0,0,6)|(0,0,0)]^(2))/1/(2p)
        theta(644) = theta(608)*args%PA(1)-theta(443)*args%PC(1) ! [(1,7,0)|(0,0,0)]^(1) = [(0,7,0)|(0,0,0)]^(1)*args%PA(1)-([(0,7,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(645) = theta(609)*args%PA(1)-theta(444)*args%PC(1) ! [(1,6,1)|(0,0,0)]^(1) = [(0,6,1)|(0,0,0)]^(1)*args%PA(1)-([(0,6,1)|(0,0,0)]^(2)*args%PC(1)
        theta(646) = theta(610)*args%PA(1)-theta(445)*args%PC(1) ! [(1,5,2)|(0,0,0)]^(1) = [(0,5,2)|(0,0,0)]^(1)*args%PA(1)-([(0,5,2)|(0,0,0)]^(2)*args%PC(1)
        theta(647) = theta(611)*args%PA(1)-theta(446)*args%PC(1) ! [(1,4,3)|(0,0,0)]^(1) = [(0,4,3)|(0,0,0)]^(1)*args%PA(1)-([(0,4,3)|(0,0,0)]^(2)*args%PC(1)
        theta(648) = theta(612)*args%PA(1)-theta(447)*args%PC(1) ! [(1,3,4)|(0,0,0)]^(1) = [(0,3,4)|(0,0,0)]^(1)*args%PA(1)-([(0,3,4)|(0,0,0)]^(2)*args%PC(1)
        theta(649) = theta(613)*args%PA(1)-theta(448)*args%PC(1) ! [(1,2,5)|(0,0,0)]^(1) = [(0,2,5)|(0,0,0)]^(1)*args%PA(1)-([(0,2,5)|(0,0,0)]^(2)*args%PC(1)
        ! theta(650) = theta(614)*args%PA(1)-theta(449)*args%PC(1) ! [(1,1,6)|(0,0,0)]^(1) = [(0,1,6)|(0,0,0)]^(1)*args%PA(1)-([(0,1,6)|(0,0,0)]^(2)*args%PC(1)
        theta(651) = theta(615)*args%PA(1)-theta(450)*args%PC(1) ! [(1,0,7)|(0,0,0)]^(1) = [(0,0,7)|(0,0,0)]^(1)*args%PA(1)-([(0,0,7)|(0,0,0)]^(2)*args%PC(1)
        theta(652) = theta(608)*args%PA(2)-theta(443)*args%PC(2)+t(140)*7 ! [(0,8,0)|(0,0,0)]^(1) = [(0,7,0)|(0,0,0)]^(1)*args%PA(2)-([(0,7,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,6,0)|(0,0,0)]^(1)-([(0,6,0)|(0,0,0)]^(2))/7/(2p)
        theta(653) = theta(608)*args%PA(3)-theta(443)*args%PC(3) ! [(0,7,1)|(0,0,0)]^(1) = [(0,7,0)|(0,0,0)]^(1)*args%PA(3)-([(0,7,0)|(0,0,0)]^(2)*args%PC(3)
        theta(654) = theta(609)*args%PA(3)-theta(444)*args%PC(3)+t(140)*1 ! [(0,6,2)|(0,0,0)]^(1) = [(0,6,1)|(0,0,0)]^(1)*args%PA(3)-([(0,6,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,6,0)|(0,0,0)]^(1)-([(0,6,0)|(0,0,0)]^(2))/1/(2p)
        t(145) = (theta(574)-theta(409))*args%rec_p2
        theta(655) = theta(610)*args%PA(3)-theta(445)*args%PC(3)+t(145)*2 ! [(0,5,3)|(0,0,0)]^(1) = [(0,5,2)|(0,0,0)]^(1)*args%PA(3)-([(0,5,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,5,1)|(0,0,0)]^(1)-([(0,5,1)|(0,0,0)]^(2))/2/(2p)
        theta(656) = theta(612)*args%PA(2)-theta(447)*args%PC(2)+t(143)*3 ! [(0,4,4)|(0,0,0)]^(1) = [(0,3,4)|(0,0,0)]^(1)*args%PA(2)-([(0,3,4)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,4)|(0,0,0)]^(1)-([(0,2,4)|(0,0,0)]^(2))/3/(2p)
        t(146) = (theta(578)-theta(413))*args%rec_p2
        theta(657) = theta(613)*args%PA(2)-theta(448)*args%PC(2)+t(146)*2 ! [(0,3,5)|(0,0,0)]^(1) = [(0,2,5)|(0,0,0)]^(1)*args%PA(2)-([(0,2,5)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,5)|(0,0,0)]^(1)-([(0,1,5)|(0,0,0)]^(2))/2/(2p)
        theta(658) = theta(614)*args%PA(2)-theta(449)*args%PC(2)+t(144)*1 ! [(0,2,6)|(0,0,0)]^(1) = [(0,1,6)|(0,0,0)]^(1)*args%PA(2)-([(0,1,6)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,6)|(0,0,0)]^(1)-([(0,0,6)|(0,0,0)]^(2))/1/(2p)
        theta(659) = theta(615)*args%PA(2)-theta(450)*args%PC(2) ! [(0,1,7)|(0,0,0)]^(1) = [(0,0,7)|(0,0,0)]^(1)*args%PA(2)-([(0,0,7)|(0,0,0)]^(2)*args%PC(2)
        theta(660) = theta(615)*args%PA(3)-theta(450)*args%PC(3)+t(144)*7 ! [(0,0,8)|(0,0,0)]^(1) = [(0,0,7)|(0,0,0)]^(1)*args%PA(3)-([(0,0,7)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,6)|(0,0,0)]^(1)-([(0,0,6)|(0,0,0)]^(2))/7/(2p)
        t(147) = (theta(580)-theta(415))*args%rec_p2
        theta(661) = theta(616)*args%PA(1)-theta(451)*args%PC(1)+t(147)*8 ! [(9,0,0)|(0,0,0)]^(1) = [(8,0,0)|(0,0,0)]^(1)*args%PA(1)-([(8,0,0)|(0,0,0)]^(2)*args%PC(1)+(([(7,0,0)|(0,0,0)]^(1)-([(7,0,0)|(0,0,0)]^(2))/8/(2p)
        theta(662) = theta(616)*args%PA(2)-theta(451)*args%PC(2) ! [(8,1,0)|(0,0,0)]^(1) = [(8,0,0)|(0,0,0)]^(1)*args%PA(2)-([(8,0,0)|(0,0,0)]^(2)*args%PC(2)
        theta(663) = theta(616)*args%PA(3)-theta(451)*args%PC(3) ! [(8,0,1)|(0,0,0)]^(1) = [(8,0,0)|(0,0,0)]^(1)*args%PA(3)-([(8,0,0)|(0,0,0)]^(2)*args%PC(3)
        theta(664) = theta(617)*args%PA(2)-theta(452)*args%PC(2)+t(147)*1 ! [(7,2,0)|(0,0,0)]^(1) = [(7,1,0)|(0,0,0)]^(1)*args%PA(2)-([(7,1,0)|(0,0,0)]^(2)*args%PC(2)+(([(7,0,0)|(0,0,0)]^(1)-([(7,0,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(665) = theta(618)*args%PA(2)-theta(453)*args%PC(2) ! [(7,1,1)|(0,0,0)]^(1) = [(7,0,1)|(0,0,0)]^(1)*args%PA(2)-([(7,0,1)|(0,0,0)]^(2)*args%PC(2)
        theta(666) = theta(618)*args%PA(3)-theta(453)*args%PC(3)+t(147)*1 ! [(7,0,2)|(0,0,0)]^(1) = [(7,0,1)|(0,0,0)]^(1)*args%PA(3)-([(7,0,1)|(0,0,0)]^(2)*args%PC(3)+(([(7,0,0)|(0,0,0)]^(1)-([(7,0,0)|(0,0,0)]^(2))/1/(2p)
        t(148) = (theta(581)-theta(416))*args%rec_p2
        theta(667) = theta(619)*args%PA(2)-theta(454)*args%PC(2)+t(148)*2 ! [(6,3,0)|(0,0,0)]^(1) = [(6,2,0)|(0,0,0)]^(1)*args%PA(2)-([(6,2,0)|(0,0,0)]^(2)*args%PC(2)+(([(6,1,0)|(0,0,0)]^(1)-([(6,1,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(668) = theta(619)*args%PA(3)-theta(454)*args%PC(3) ! [(6,2,1)|(0,0,0)]^(1) = [(6,2,0)|(0,0,0)]^(1)*args%PA(3)-([(6,2,0)|(0,0,0)]^(2)*args%PC(3)
        ! theta(669) = theta(621)*args%PA(2)-theta(456)*args%PC(2) ! [(6,1,2)|(0,0,0)]^(1) = [(6,0,2)|(0,0,0)]^(1)*args%PA(2)-([(6,0,2)|(0,0,0)]^(2)*args%PC(2)
        t(149) = (theta(582)-theta(417))*args%rec_p2
        theta(670) = theta(621)*args%PA(3)-theta(456)*args%PC(3)+t(149)*2 ! [(6,0,3)|(0,0,0)]^(1) = [(6,0,2)|(0,0,0)]^(1)*args%PA(3)-([(6,0,2)|(0,0,0)]^(2)*args%PC(3)+(([(6,0,1)|(0,0,0)]^(1)-([(6,0,1)|(0,0,0)]^(2))/2/(2p)
        t(150) = (theta(583)-theta(418))*args%rec_p2
        theta(671) = theta(622)*args%PA(2)-theta(457)*args%PC(2)+t(150)*3 ! [(5,4,0)|(0,0,0)]^(1) = [(5,3,0)|(0,0,0)]^(1)*args%PA(2)-([(5,3,0)|(0,0,0)]^(2)*args%PC(2)+(([(5,2,0)|(0,0,0)]^(1)-([(5,2,0)|(0,0,0)]^(2))/3/(2p)
        ! theta(672) = theta(622)*args%PA(3)-theta(457)*args%PC(3) ! [(5,3,1)|(0,0,0)]^(1) = [(5,3,0)|(0,0,0)]^(1)*args%PA(3)-([(5,3,0)|(0,0,0)]^(2)*args%PC(3)
        t(151) = (theta(592)-theta(427))*args%rec_p2
        theta(673) = theta(628)*args%PA(1)-theta(463)*args%PC(1)+t(151)*4 ! [(5,2,2)|(0,0,0)]^(1) = [(4,2,2)|(0,0,0)]^(1)*args%PA(1)-([(4,2,2)|(0,0,0)]^(2)*args%PC(1)+(([(3,2,2)|(0,0,0)]^(1)-([(3,2,2)|(0,0,0)]^(2))/4/(2p)
        ! theta(674) = theta(625)*args%PA(2)-theta(460)*args%PC(2) ! [(5,1,3)|(0,0,0)]^(1) = [(5,0,3)|(0,0,0)]^(1)*args%PA(2)-([(5,0,3)|(0,0,0)]^(2)*args%PC(2)
        t(152) = (theta(585)-theta(420))*args%rec_p2
        theta(675) = theta(625)*args%PA(3)-theta(460)*args%PC(3)+t(152)*3 ! [(5,0,4)|(0,0,0)]^(1) = [(5,0,3)|(0,0,0)]^(1)*args%PA(3)-([(5,0,3)|(0,0,0)]^(2)*args%PC(3)+(([(5,0,2)|(0,0,0)]^(1)-([(5,0,2)|(0,0,0)]^(2))/3/(2p)
        t(153) = (theta(595)-theta(430))*args%rec_p2
        theta(676) = theta(631)*args%PA(1)-theta(466)*args%PC(1)+t(153)*3 ! [(4,5,0)|(0,0,0)]^(1) = [(3,5,0)|(0,0,0)]^(1)*args%PA(1)-([(3,5,0)|(0,0,0)]^(2)*args%PC(1)+(([(2,5,0)|(0,0,0)]^(1)-([(2,5,0)|(0,0,0)]^(2))/3/(2p)
        ! theta(677) = theta(626)*args%PA(3)-theta(461)*args%PC(3) ! [(4,4,1)|(0,0,0)]^(1) = [(4,4,0)|(0,0,0)]^(1)*args%PA(3)-([(4,4,0)|(0,0,0)]^(2)*args%PC(3)
        t(154) = (theta(597)-theta(432))*args%rec_p2
        theta(678) = theta(633)*args%PA(1)-theta(468)*args%PC(1)+t(154)*3 ! [(4,3,2)|(0,0,0)]^(1) = [(3,3,2)|(0,0,0)]^(1)*args%PA(1)-([(3,3,2)|(0,0,0)]^(2)*args%PC(1)+(([(2,3,2)|(0,0,0)]^(1)-([(2,3,2)|(0,0,0)]^(2))/3/(2p)
        t(155) = (theta(598)-theta(433))*args%rec_p2
        theta(679) = theta(634)*args%PA(1)-theta(469)*args%PC(1)+t(155)*3 ! [(4,2,3)|(0,0,0)]^(1) = [(3,2,3)|(0,0,0)]^(1)*args%PA(1)-([(3,2,3)|(0,0,0)]^(2)*args%PC(1)+(([(2,2,3)|(0,0,0)]^(1)-([(2,2,3)|(0,0,0)]^(2))/3/(2p)
        ! theta(680) = theta(630)*args%PA(2)-theta(465)*args%PC(2) ! [(4,1,4)|(0,0,0)]^(1) = [(4,0,4)|(0,0,0)]^(1)*args%PA(2)-([(4,0,4)|(0,0,0)]^(2)*args%PC(2)
        t(156) = (theta(600)-theta(435))*args%rec_p2
        theta(681) = theta(636)*args%PA(1)-theta(471)*args%PC(1)+t(156)*3 ! [(4,0,5)|(0,0,0)]^(1) = [(3,0,5)|(0,0,0)]^(1)*args%PA(1)-([(3,0,5)|(0,0,0)]^(2)*args%PC(1)+(([(2,0,5)|(0,0,0)]^(1)-([(2,0,5)|(0,0,0)]^(2))/3/(2p)
        t(157) = (theta(601)-theta(436))*args%rec_p2
        theta(682) = theta(637)*args%PA(1)-theta(472)*args%PC(1)+t(157)*2 ! [(3,6,0)|(0,0,0)]^(1) = [(2,6,0)|(0,0,0)]^(1)*args%PA(1)-([(2,6,0)|(0,0,0)]^(2)*args%PC(1)+(([(1,6,0)|(0,0,0)]^(1)-([(1,6,0)|(0,0,0)]^(2))/2/(2p)
        ! theta(683) = theta(631)*args%PA(3)-theta(466)*args%PC(3) ! [(3,5,1)|(0,0,0)]^(1) = [(3,5,0)|(0,0,0)]^(1)*args%PA(3)-([(3,5,0)|(0,0,0)]^(2)*args%PC(3)
        t(158) = (theta(603)-theta(438))*args%rec_p2
        theta(684) = theta(639)*args%PA(1)-theta(474)*args%PC(1)+t(158)*2 ! [(3,4,2)|(0,0,0)]^(1) = [(2,4,2)|(0,0,0)]^(1)*args%PA(1)-([(2,4,2)|(0,0,0)]^(2)*args%PC(1)+(([(1,4,2)|(0,0,0)]^(1)-([(1,4,2)|(0,0,0)]^(2))/2/(2p)
        t(159) = (theta(604)-theta(439))*args%rec_p2
        theta(685) = theta(640)*args%PA(1)-theta(475)*args%PC(1)+t(159)*2 ! [(3,3,3)|(0,0,0)]^(1) = [(2,3,3)|(0,0,0)]^(1)*args%PA(1)-([(2,3,3)|(0,0,0)]^(2)*args%PC(1)+(([(1,3,3)|(0,0,0)]^(1)-([(1,3,3)|(0,0,0)]^(2))/2/(2p)
        t(160) = (theta(605)-theta(440))*args%rec_p2
        theta(686) = theta(641)*args%PA(1)-theta(476)*args%PC(1)+t(160)*2 ! [(3,2,4)|(0,0,0)]^(1) = [(2,2,4)|(0,0,0)]^(1)*args%PA(1)-([(2,2,4)|(0,0,0)]^(2)*args%PC(1)+(([(1,2,4)|(0,0,0)]^(1)-([(1,2,4)|(0,0,0)]^(2))/2/(2p)
        ! theta(687) = theta(636)*args%PA(2)-theta(471)*args%PC(2) ! [(3,1,5)|(0,0,0)]^(1) = [(3,0,5)|(0,0,0)]^(1)*args%PA(2)-([(3,0,5)|(0,0,0)]^(2)*args%PC(2)
        t(161) = (theta(607)-theta(442))*args%rec_p2
        theta(688) = theta(643)*args%PA(1)-theta(478)*args%PC(1)+t(161)*2 ! [(3,0,6)|(0,0,0)]^(1) = [(2,0,6)|(0,0,0)]^(1)*args%PA(1)-([(2,0,6)|(0,0,0)]^(2)*args%PC(1)+(([(1,0,6)|(0,0,0)]^(1)-([(1,0,6)|(0,0,0)]^(2))/2/(2p)
        t(162) = (theta(608)-theta(443))*args%rec_p2
        theta(689) = theta(644)*args%PA(1)-theta(479)*args%PC(1)+t(162)*1 ! [(2,7,0)|(0,0,0)]^(1) = [(1,7,0)|(0,0,0)]^(1)*args%PA(1)-([(1,7,0)|(0,0,0)]^(2)*args%PC(1)+(([(0,7,0)|(0,0,0)]^(1)-([(0,7,0)|(0,0,0)]^(2))/1/(2p)
        ! theta(690) = theta(637)*args%PA(3)-theta(472)*args%PC(3) ! [(2,6,1)|(0,0,0)]^(1) = [(2,6,0)|(0,0,0)]^(1)*args%PA(3)-([(2,6,0)|(0,0,0)]^(2)*args%PC(3)
        t(163) = (theta(610)-theta(445))*args%rec_p2
        theta(691) = theta(646)*args%PA(1)-theta(481)*args%PC(1)+t(163)*1 ! [(2,5,2)|(0,0,0)]^(1) = [(1,5,2)|(0,0,0)]^(1)*args%PA(1)-([(1,5,2)|(0,0,0)]^(2)*args%PC(1)+(([(0,5,2)|(0,0,0)]^(1)-([(0,5,2)|(0,0,0)]^(2))/1/(2p)
        t(164) = (theta(611)-theta(446))*args%rec_p2
        theta(692) = theta(647)*args%PA(1)-theta(482)*args%PC(1)+t(164)*1 ! [(2,4,3)|(0,0,0)]^(1) = [(1,4,3)|(0,0,0)]^(1)*args%PA(1)-([(1,4,3)|(0,0,0)]^(2)*args%PC(1)+(([(0,4,3)|(0,0,0)]^(1)-([(0,4,3)|(0,0,0)]^(2))/1/(2p)
        t(165) = (theta(612)-theta(447))*args%rec_p2
        theta(693) = theta(648)*args%PA(1)-theta(483)*args%PC(1)+t(165)*1 ! [(2,3,4)|(0,0,0)]^(1) = [(1,3,4)|(0,0,0)]^(1)*args%PA(1)-([(1,3,4)|(0,0,0)]^(2)*args%PC(1)+(([(0,3,4)|(0,0,0)]^(1)-([(0,3,4)|(0,0,0)]^(2))/1/(2p)
        t(166) = (theta(613)-theta(448))*args%rec_p2
        theta(694) = theta(649)*args%PA(1)-theta(484)*args%PC(1)+t(166)*1 ! [(2,2,5)|(0,0,0)]^(1) = [(1,2,5)|(0,0,0)]^(1)*args%PA(1)-([(1,2,5)|(0,0,0)]^(2)*args%PC(1)+(([(0,2,5)|(0,0,0)]^(1)-([(0,2,5)|(0,0,0)]^(2))/1/(2p)
        ! theta(695) = theta(643)*args%PA(2)-theta(478)*args%PC(2) ! [(2,1,6)|(0,0,0)]^(1) = [(2,0,6)|(0,0,0)]^(1)*args%PA(2)-([(2,0,6)|(0,0,0)]^(2)*args%PC(2)
        t(167) = (theta(615)-theta(450))*args%rec_p2
        theta(696) = theta(651)*args%PA(1)-theta(486)*args%PC(1)+t(167)*1 ! [(2,0,7)|(0,0,0)]^(1) = [(1,0,7)|(0,0,0)]^(1)*args%PA(1)-([(1,0,7)|(0,0,0)]^(2)*args%PC(1)+(([(0,0,7)|(0,0,0)]^(1)-([(0,0,7)|(0,0,0)]^(2))/1/(2p)
        theta(697) = theta(652)*args%PA(1)-theta(487)*args%PC(1) ! [(1,8,0)|(0,0,0)]^(1) = [(0,8,0)|(0,0,0)]^(1)*args%PA(1)-([(0,8,0)|(0,0,0)]^(2)*args%PC(1)
        ! theta(698) = theta(653)*args%PA(1)-theta(488)*args%PC(1) ! [(1,7,1)|(0,0,0)]^(1) = [(0,7,1)|(0,0,0)]^(1)*args%PA(1)-([(0,7,1)|(0,0,0)]^(2)*args%PC(1)
        theta(699) = theta(654)*args%PA(1)-theta(489)*args%PC(1) ! [(1,6,2)|(0,0,0)]^(1) = [(0,6,2)|(0,0,0)]^(1)*args%PA(1)-([(0,6,2)|(0,0,0)]^(2)*args%PC(1)
        theta(700) = theta(655)*args%PA(1)-theta(490)*args%PC(1) ! [(1,5,3)|(0,0,0)]^(1) = [(0,5,3)|(0,0,0)]^(1)*args%PA(1)-([(0,5,3)|(0,0,0)]^(2)*args%PC(1)
        theta(701) = theta(656)*args%PA(1)-theta(491)*args%PC(1) ! [(1,4,4)|(0,0,0)]^(1) = [(0,4,4)|(0,0,0)]^(1)*args%PA(1)-([(0,4,4)|(0,0,0)]^(2)*args%PC(1)
        theta(702) = theta(657)*args%PA(1)-theta(492)*args%PC(1) ! [(1,3,5)|(0,0,0)]^(1) = [(0,3,5)|(0,0,0)]^(1)*args%PA(1)-([(0,3,5)|(0,0,0)]^(2)*args%PC(1)
        theta(703) = theta(658)*args%PA(1)-theta(493)*args%PC(1) ! [(1,2,6)|(0,0,0)]^(1) = [(0,2,6)|(0,0,0)]^(1)*args%PA(1)-([(0,2,6)|(0,0,0)]^(2)*args%PC(1)
        ! theta(704) = theta(659)*args%PA(1)-theta(494)*args%PC(1) ! [(1,1,7)|(0,0,0)]^(1) = [(0,1,7)|(0,0,0)]^(1)*args%PA(1)-([(0,1,7)|(0,0,0)]^(2)*args%PC(1)
        theta(705) = theta(660)*args%PA(1)-theta(495)*args%PC(1) ! [(1,0,8)|(0,0,0)]^(1) = [(0,0,8)|(0,0,0)]^(1)*args%PA(1)-([(0,0,8)|(0,0,0)]^(2)*args%PC(1)
        theta(706) = theta(652)*args%PA(2)-theta(487)*args%PC(2)+t(162)*8 ! [(0,9,0)|(0,0,0)]^(1) = [(0,8,0)|(0,0,0)]^(1)*args%PA(2)-([(0,8,0)|(0,0,0)]^(2)*args%PC(2)+(([(0,7,0)|(0,0,0)]^(1)-([(0,7,0)|(0,0,0)]^(2))/8/(2p)
        theta(707) = theta(652)*args%PA(3)-theta(487)*args%PC(3) ! [(0,8,1)|(0,0,0)]^(1) = [(0,8,0)|(0,0,0)]^(1)*args%PA(3)-([(0,8,0)|(0,0,0)]^(2)*args%PC(3)
        theta(708) = theta(653)*args%PA(3)-theta(488)*args%PC(3)+t(162)*1 ! [(0,7,2)|(0,0,0)]^(1) = [(0,7,1)|(0,0,0)]^(1)*args%PA(3)-([(0,7,1)|(0,0,0)]^(2)*args%PC(3)+(([(0,7,0)|(0,0,0)]^(1)-([(0,7,0)|(0,0,0)]^(2))/1/(2p)
        t(168) = (theta(609)-theta(444))*args%rec_p2
        theta(709) = theta(654)*args%PA(3)-theta(489)*args%PC(3)+t(168)*2 ! [(0,6,3)|(0,0,0)]^(1) = [(0,6,2)|(0,0,0)]^(1)*args%PA(3)-([(0,6,2)|(0,0,0)]^(2)*args%PC(3)+(([(0,6,1)|(0,0,0)]^(1)-([(0,6,1)|(0,0,0)]^(2))/2/(2p)
        theta(710) = theta(655)*args%PA(3)-theta(490)*args%PC(3)+t(163)*3 ! [(0,5,4)|(0,0,0)]^(1) = [(0,5,3)|(0,0,0)]^(1)*args%PA(3)-([(0,5,3)|(0,0,0)]^(2)*args%PC(3)+(([(0,5,2)|(0,0,0)]^(1)-([(0,5,2)|(0,0,0)]^(2))/3/(2p)
        theta(711) = theta(657)*args%PA(2)-theta(492)*args%PC(2)+t(166)*3 ! [(0,4,5)|(0,0,0)]^(1) = [(0,3,5)|(0,0,0)]^(1)*args%PA(2)-([(0,3,5)|(0,0,0)]^(2)*args%PC(2)+(([(0,2,5)|(0,0,0)]^(1)-([(0,2,5)|(0,0,0)]^(2))/3/(2p)
        t(169) = (theta(614)-theta(449))*args%rec_p2
        theta(712) = theta(658)*args%PA(2)-theta(493)*args%PC(2)+t(169)*2 ! [(0,3,6)|(0,0,0)]^(1) = [(0,2,6)|(0,0,0)]^(1)*args%PA(2)-([(0,2,6)|(0,0,0)]^(2)*args%PC(2)+(([(0,1,6)|(0,0,0)]^(1)-([(0,1,6)|(0,0,0)]^(2))/2/(2p)
        theta(713) = theta(659)*args%PA(2)-theta(494)*args%PC(2)+t(167)*1 ! [(0,2,7)|(0,0,0)]^(1) = [(0,1,7)|(0,0,0)]^(1)*args%PA(2)-([(0,1,7)|(0,0,0)]^(2)*args%PC(2)+(([(0,0,7)|(0,0,0)]^(1)-([(0,0,7)|(0,0,0)]^(2))/1/(2p)
        theta(714) = theta(660)*args%PA(2)-theta(495)*args%PC(2) ! [(0,1,8)|(0,0,0)]^(1) = [(0,0,8)|(0,0,0)]^(1)*args%PA(2)-([(0,0,8)|(0,0,0)]^(2)*args%PC(2)
        theta(715) = theta(660)*args%PA(3)-theta(495)*args%PC(3)+t(167)*8 ! [(0,0,9)|(0,0,0)]^(1) = [(0,0,8)|(0,0,0)]^(1)*args%PA(3)-([(0,0,8)|(0,0,0)]^(2)*args%PC(3)+(([(0,0,7)|(0,0,0)]^(1)-([(0,0,7)|(0,0,0)]^(2))/8/(2p)
        theta(717) = theta(716)*args%PA(1)-theta(496)*args%PC(1) ! [(1,0,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(1)-([(0,0,0)|(0,0,0)]^(1)*args%PC(1)
        theta(718) = theta(716)*args%PA(2)-theta(496)*args%PC(2) ! [(0,1,0)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(2)-([(0,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(719) = theta(716)*args%PA(3)-theta(496)*args%PC(3) ! [(0,0,1)|(0,0,0)]^(0) = [(0,0,0)|(0,0,0)]^(0)*args%PA(3)-([(0,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(170) = (theta(716)-theta(496))*args%rec_p2
        theta(720) = theta(717)*args%PA(1)-theta(497)*args%PC(1)+t(170)*1 ! [(2,0,0)|(0,0,0)]^(0) = [(1,0,0)|(0,0,0)]^(0)*args%PA(1)-([(1,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(721) = theta(718)*args%PA(1)-theta(498)*args%PC(1) ! [(1,1,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(1)-([(0,1,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(722) = theta(719)*args%PA(1)-theta(499)*args%PC(1) ! [(1,0,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(1)-([(0,0,1)|(0,0,0)]^(1)*args%PC(1)
        theta(723) = theta(718)*args%PA(2)-theta(498)*args%PC(2)+t(170)*1 ! [(0,2,0)|(0,0,0)]^(0) = [(0,1,0)|(0,0,0)]^(0)*args%PA(2)-([(0,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(724) = theta(719)*args%PA(2)-theta(499)*args%PC(2) ! [(0,1,1)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(2)-([(0,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(725) = theta(719)*args%PA(3)-theta(499)*args%PC(3)+t(170)*1 ! [(0,0,2)|(0,0,0)]^(0) = [(0,0,1)|(0,0,0)]^(0)*args%PA(3)-([(0,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,0)|(0,0,0)]^(0)-([(0,0,0)|(0,0,0)]^(1))/1/(2p)
        t(171) = (theta(717)-theta(497))*args%rec_p2
        theta(726) = theta(720)*args%PA(1)-theta(500)*args%PC(1)+t(171)*2 ! [(3,0,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(1)-([(2,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,0)|(0,0,0)]^(0)-([(1,0,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(727) = theta(720)*args%PA(2)-theta(500)*args%PC(2) ! [(2,1,0)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(2)-([(2,0,0)|(0,0,0)]^(1)*args%PC(2)
        ! theta(728) = theta(720)*args%PA(3)-theta(500)*args%PC(3) ! [(2,0,1)|(0,0,0)]^(0) = [(2,0,0)|(0,0,0)]^(0)*args%PA(3)-([(2,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(729) = theta(723)*args%PA(1)-theta(503)*args%PC(1) ! [(1,2,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(1)-([(0,2,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(730) = theta(724)*args%PA(1)-theta(504)*args%PC(1) ! [(1,1,1)|(0,0,0)]^(0) = [(0,1,1)|(0,0,0)]^(0)*args%PA(1)-([(0,1,1)|(0,0,0)]^(1)*args%PC(1)
        theta(731) = theta(725)*args%PA(1)-theta(505)*args%PC(1) ! [(1,0,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(1)-([(0,0,2)|(0,0,0)]^(1)*args%PC(1)
        t(172) = (theta(718)-theta(498))*args%rec_p2
        theta(732) = theta(723)*args%PA(2)-theta(503)*args%PC(2)+t(172)*2 ! [(0,3,0)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(2)-([(0,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,0)|(0,0,0)]^(0)-([(0,1,0)|(0,0,0)]^(1))/2/(2p)
        ! theta(733) = theta(723)*args%PA(3)-theta(503)*args%PC(3) ! [(0,2,1)|(0,0,0)]^(0) = [(0,2,0)|(0,0,0)]^(0)*args%PA(3)-([(0,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(734) = theta(725)*args%PA(2)-theta(505)*args%PC(2) ! [(0,1,2)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(2)-([(0,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(173) = (theta(719)-theta(499))*args%rec_p2
        theta(735) = theta(725)*args%PA(3)-theta(505)*args%PC(3)+t(173)*2 ! [(0,0,3)|(0,0,0)]^(0) = [(0,0,2)|(0,0,0)]^(0)*args%PA(3)-([(0,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,1)|(0,0,0)]^(0)-([(0,0,1)|(0,0,0)]^(1))/2/(2p)
        t(174) = (theta(720)-theta(500))*args%rec_p2
        theta(736) = theta(726)*args%PA(1)-theta(506)*args%PC(1)+t(174)*3 ! [(4,0,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(1)-([(3,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,0)|(0,0,0)]^(0)-([(2,0,0)|(0,0,0)]^(1))/3/(2p)
        theta(737) = theta(726)*args%PA(2)-theta(506)*args%PC(2) ! [(3,1,0)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(2)-([(3,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(738) = theta(726)*args%PA(3)-theta(506)*args%PC(3) ! [(3,0,1)|(0,0,0)]^(0) = [(3,0,0)|(0,0,0)]^(0)*args%PA(3)-([(3,0,0)|(0,0,0)]^(1)*args%PC(3)
        t(175) = (theta(723)-theta(503))*args%rec_p2
        theta(739) = theta(729)*args%PA(1)-theta(509)*args%PC(1)+t(175)*1 ! [(2,2,0)|(0,0,0)]^(0) = [(1,2,0)|(0,0,0)]^(0)*args%PA(1)-([(1,2,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/1/(2p)
        ! theta(740) = theta(728)*args%PA(2)-theta(508)*args%PC(2) ! [(2,1,1)|(0,0,0)]^(0) = [(2,0,1)|(0,0,0)]^(0)*args%PA(2)-([(2,0,1)|(0,0,0)]^(1)*args%PC(2)
        t(176) = (theta(725)-theta(505))*args%rec_p2
        theta(741) = theta(731)*args%PA(1)-theta(511)*args%PC(1)+t(176)*1 ! [(2,0,2)|(0,0,0)]^(0) = [(1,0,2)|(0,0,0)]^(0)*args%PA(1)-([(1,0,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(742) = theta(732)*args%PA(1)-theta(512)*args%PC(1) ! [(1,3,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(1)-([(0,3,0)|(0,0,0)]^(1)*args%PC(1)
        ! theta(743) = theta(733)*args%PA(1)-theta(513)*args%PC(1) ! [(1,2,1)|(0,0,0)]^(0) = [(0,2,1)|(0,0,0)]^(0)*args%PA(1)-([(0,2,1)|(0,0,0)]^(1)*args%PC(1)
        ! theta(744) = theta(734)*args%PA(1)-theta(514)*args%PC(1) ! [(1,1,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(1)-([(0,1,2)|(0,0,0)]^(1)*args%PC(1)
        theta(745) = theta(735)*args%PA(1)-theta(515)*args%PC(1) ! [(1,0,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(1)-([(0,0,3)|(0,0,0)]^(1)*args%PC(1)
        theta(746) = theta(732)*args%PA(2)-theta(512)*args%PC(2)+t(175)*3 ! [(0,4,0)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(2)-([(0,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,0)|(0,0,0)]^(0)-([(0,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(747) = theta(732)*args%PA(3)-theta(512)*args%PC(3) ! [(0,3,1)|(0,0,0)]^(0) = [(0,3,0)|(0,0,0)]^(0)*args%PA(3)-([(0,3,0)|(0,0,0)]^(1)*args%PC(3)
        theta(748) = theta(734)*args%PA(2)-theta(514)*args%PC(2)+t(176)*1 ! [(0,2,2)|(0,0,0)]^(0) = [(0,1,2)|(0,0,0)]^(0)*args%PA(2)-([(0,1,2)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/1/(2p)
        theta(749) = theta(735)*args%PA(2)-theta(515)*args%PC(2) ! [(0,1,3)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(2)-([(0,0,3)|(0,0,0)]^(1)*args%PC(2)
        theta(750) = theta(735)*args%PA(3)-theta(515)*args%PC(3)+t(176)*3 ! [(0,0,4)|(0,0,0)]^(0) = [(0,0,3)|(0,0,0)]^(0)*args%PA(3)-([(0,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,2)|(0,0,0)]^(0)-([(0,0,2)|(0,0,0)]^(1))/3/(2p)
        t(177) = (theta(726)-theta(506))*args%rec_p2
        theta(751) = theta(736)*args%PA(1)-theta(516)*args%PC(1)+t(177)*4 ! [(5,0,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(1)-([(4,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/4/(2p)
        theta(752) = theta(736)*args%PA(2)-theta(516)*args%PC(2) ! [(4,1,0)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(2)-([(4,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(753) = theta(736)*args%PA(3)-theta(516)*args%PC(3) ! [(4,0,1)|(0,0,0)]^(0) = [(4,0,0)|(0,0,0)]^(0)*args%PA(3)-([(4,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(754) = theta(737)*args%PA(2)-theta(517)*args%PC(2)+t(177)*1 ! [(3,2,0)|(0,0,0)]^(0) = [(3,1,0)|(0,0,0)]^(0)*args%PA(2)-([(3,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(755) = theta(738)*args%PA(2)-theta(518)*args%PC(2) ! [(3,1,1)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(2)-([(3,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(756) = theta(738)*args%PA(3)-theta(518)*args%PC(3)+t(177)*1 ! [(3,0,2)|(0,0,0)]^(0) = [(3,0,1)|(0,0,0)]^(0)*args%PA(3)-([(3,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(3,0,0)|(0,0,0)]^(0)-([(3,0,0)|(0,0,0)]^(1))/1/(2p)
        t(178) = (theta(732)-theta(512))*args%rec_p2
        theta(757) = theta(742)*args%PA(1)-theta(522)*args%PC(1)+t(178)*1 ! [(2,3,0)|(0,0,0)]^(0) = [(1,3,0)|(0,0,0)]^(0)*args%PA(1)-([(1,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(758) = theta(739)*args%PA(3)-theta(519)*args%PC(3) ! [(2,2,1)|(0,0,0)]^(0) = [(2,2,0)|(0,0,0)]^(0)*args%PA(3)-([(2,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(759) = theta(741)*args%PA(2)-theta(521)*args%PC(2) ! [(2,1,2)|(0,0,0)]^(0) = [(2,0,2)|(0,0,0)]^(0)*args%PA(2)-([(2,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(179) = (theta(735)-theta(515))*args%rec_p2
        theta(760) = theta(745)*args%PA(1)-theta(525)*args%PC(1)+t(179)*1 ! [(2,0,3)|(0,0,0)]^(0) = [(1,0,3)|(0,0,0)]^(0)*args%PA(1)-([(1,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(761) = theta(746)*args%PA(1)-theta(526)*args%PC(1) ! [(1,4,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(1)-([(0,4,0)|(0,0,0)]^(1)*args%PC(1)
        theta(762) = theta(747)*args%PA(1)-theta(527)*args%PC(1) ! [(1,3,1)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(1)-([(0,3,1)|(0,0,0)]^(1)*args%PC(1)
        theta(763) = theta(748)*args%PA(1)-theta(528)*args%PC(1) ! [(1,2,2)|(0,0,0)]^(0) = [(0,2,2)|(0,0,0)]^(0)*args%PA(1)-([(0,2,2)|(0,0,0)]^(1)*args%PC(1)
        theta(764) = theta(749)*args%PA(1)-theta(529)*args%PC(1) ! [(1,1,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(1)-([(0,1,3)|(0,0,0)]^(1)*args%PC(1)
        theta(765) = theta(750)*args%PA(1)-theta(530)*args%PC(1) ! [(1,0,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(1)-([(0,0,4)|(0,0,0)]^(1)*args%PC(1)
        theta(766) = theta(746)*args%PA(2)-theta(526)*args%PC(2)+t(178)*4 ! [(0,5,0)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(2)-([(0,4,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/4/(2p)
        theta(767) = theta(746)*args%PA(3)-theta(526)*args%PC(3) ! [(0,4,1)|(0,0,0)]^(0) = [(0,4,0)|(0,0,0)]^(0)*args%PA(3)-([(0,4,0)|(0,0,0)]^(1)*args%PC(3)
        theta(768) = theta(747)*args%PA(3)-theta(527)*args%PC(3)+t(178)*1 ! [(0,3,2)|(0,0,0)]^(0) = [(0,3,1)|(0,0,0)]^(0)*args%PA(3)-([(0,3,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,3,0)|(0,0,0)]^(0)-([(0,3,0)|(0,0,0)]^(1))/1/(2p)
        theta(769) = theta(749)*args%PA(2)-theta(529)*args%PC(2)+t(179)*1 ! [(0,2,3)|(0,0,0)]^(0) = [(0,1,3)|(0,0,0)]^(0)*args%PA(2)-([(0,1,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/1/(2p)
        theta(770) = theta(750)*args%PA(2)-theta(530)*args%PC(2) ! [(0,1,4)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(2)-([(0,0,4)|(0,0,0)]^(1)*args%PC(2)
        theta(771) = theta(750)*args%PA(3)-theta(530)*args%PC(3)+t(179)*4 ! [(0,0,5)|(0,0,0)]^(0) = [(0,0,4)|(0,0,0)]^(0)*args%PA(3)-([(0,0,4)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,3)|(0,0,0)]^(0)-([(0,0,3)|(0,0,0)]^(1))/4/(2p)
        t(180) = (theta(736)-theta(516))*args%rec_p2
        theta(772) = theta(751)*args%PA(1)-theta(531)*args%PC(1)+t(180)*5 ! [(6,0,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(1)-([(5,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/5/(2p)
        theta(773) = theta(751)*args%PA(2)-theta(531)*args%PC(2) ! [(5,1,0)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(2)-([(5,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(774) = theta(751)*args%PA(3)-theta(531)*args%PC(3) ! [(5,0,1)|(0,0,0)]^(0) = [(5,0,0)|(0,0,0)]^(0)*args%PA(3)-([(5,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(775) = theta(752)*args%PA(2)-theta(532)*args%PC(2)+t(180)*1 ! [(4,2,0)|(0,0,0)]^(0) = [(4,1,0)|(0,0,0)]^(0)*args%PA(2)-([(4,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(776) = theta(753)*args%PA(2)-theta(533)*args%PC(2) ! [(4,1,1)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(2)-([(4,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(777) = theta(753)*args%PA(3)-theta(533)*args%PC(3)+t(180)*1 ! [(4,0,2)|(0,0,0)]^(0) = [(4,0,1)|(0,0,0)]^(0)*args%PA(3)-([(4,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,0)|(0,0,0)]^(0)-([(4,0,0)|(0,0,0)]^(1))/1/(2p)
        t(181) = (theta(742)-theta(522))*args%rec_p2
        theta(778) = theta(757)*args%PA(1)-theta(537)*args%PC(1)+t(181)*2 ! [(3,3,0)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(1)-([(2,3,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,0)|(0,0,0)]^(0)-([(1,3,0)|(0,0,0)]^(1))/2/(2p)
        theta(779) = theta(754)*args%PA(3)-theta(534)*args%PC(3) ! [(3,2,1)|(0,0,0)]^(0) = [(3,2,0)|(0,0,0)]^(0)*args%PA(3)-([(3,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(780) = theta(756)*args%PA(2)-theta(536)*args%PC(2) ! [(3,1,2)|(0,0,0)]^(0) = [(3,0,2)|(0,0,0)]^(0)*args%PA(2)-([(3,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(182) = (theta(745)-theta(525))*args%rec_p2
        theta(781) = theta(760)*args%PA(1)-theta(540)*args%PC(1)+t(182)*2 ! [(3,0,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(1)-([(2,0,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,3)|(0,0,0)]^(0)-([(1,0,3)|(0,0,0)]^(1))/2/(2p)
        t(183) = (theta(746)-theta(526))*args%rec_p2
        theta(782) = theta(761)*args%PA(1)-theta(541)*args%PC(1)+t(183)*1 ! [(2,4,0)|(0,0,0)]^(0) = [(1,4,0)|(0,0,0)]^(0)*args%PA(1)-([(1,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        theta(783) = theta(757)*args%PA(3)-theta(537)*args%PC(3) ! [(2,3,1)|(0,0,0)]^(0) = [(2,3,0)|(0,0,0)]^(0)*args%PA(3)-([(2,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(184) = (theta(748)-theta(528))*args%rec_p2
        theta(784) = theta(763)*args%PA(1)-theta(543)*args%PC(1)+t(184)*1 ! [(2,2,2)|(0,0,0)]^(0) = [(1,2,2)|(0,0,0)]^(0)*args%PA(1)-([(1,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,2)|(0,0,0)]^(0)-([(0,2,2)|(0,0,0)]^(1))/1/(2p)
        theta(785) = theta(760)*args%PA(2)-theta(540)*args%PC(2) ! [(2,1,3)|(0,0,0)]^(0) = [(2,0,3)|(0,0,0)]^(0)*args%PA(2)-([(2,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(185) = (theta(750)-theta(530))*args%rec_p2
        theta(786) = theta(765)*args%PA(1)-theta(545)*args%PC(1)+t(185)*1 ! [(2,0,4)|(0,0,0)]^(0) = [(1,0,4)|(0,0,0)]^(0)*args%PA(1)-([(1,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(787) = theta(766)*args%PA(1)-theta(546)*args%PC(1) ! [(1,5,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(1)-([(0,5,0)|(0,0,0)]^(1)*args%PC(1)
        theta(788) = theta(767)*args%PA(1)-theta(547)*args%PC(1) ! [(1,4,1)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(1)-([(0,4,1)|(0,0,0)]^(1)*args%PC(1)
        theta(789) = theta(768)*args%PA(1)-theta(548)*args%PC(1) ! [(1,3,2)|(0,0,0)]^(0) = [(0,3,2)|(0,0,0)]^(0)*args%PA(1)-([(0,3,2)|(0,0,0)]^(1)*args%PC(1)
        theta(790) = theta(769)*args%PA(1)-theta(549)*args%PC(1) ! [(1,2,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(1)-([(0,2,3)|(0,0,0)]^(1)*args%PC(1)
        theta(791) = theta(770)*args%PA(1)-theta(550)*args%PC(1) ! [(1,1,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(1)-([(0,1,4)|(0,0,0)]^(1)*args%PC(1)
        theta(792) = theta(771)*args%PA(1)-theta(551)*args%PC(1) ! [(1,0,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(1)-([(0,0,5)|(0,0,0)]^(1)*args%PC(1)
        theta(793) = theta(766)*args%PA(2)-theta(546)*args%PC(2)+t(183)*5 ! [(0,6,0)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(2)-([(0,5,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/5/(2p)
        theta(794) = theta(766)*args%PA(3)-theta(546)*args%PC(3) ! [(0,5,1)|(0,0,0)]^(0) = [(0,5,0)|(0,0,0)]^(0)*args%PA(3)-([(0,5,0)|(0,0,0)]^(1)*args%PC(3)
        theta(795) = theta(767)*args%PA(3)-theta(547)*args%PC(3)+t(183)*1 ! [(0,4,2)|(0,0,0)]^(0) = [(0,4,1)|(0,0,0)]^(0)*args%PA(3)-([(0,4,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,0)|(0,0,0)]^(0)-([(0,4,0)|(0,0,0)]^(1))/1/(2p)
        t(186) = (theta(749)-theta(529))*args%rec_p2
        theta(796) = theta(769)*args%PA(2)-theta(549)*args%PC(2)+t(186)*2 ! [(0,3,3)|(0,0,0)]^(0) = [(0,2,3)|(0,0,0)]^(0)*args%PA(2)-([(0,2,3)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,3)|(0,0,0)]^(0)-([(0,1,3)|(0,0,0)]^(1))/2/(2p)
        theta(797) = theta(770)*args%PA(2)-theta(550)*args%PC(2)+t(185)*1 ! [(0,2,4)|(0,0,0)]^(0) = [(0,1,4)|(0,0,0)]^(0)*args%PA(2)-([(0,1,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/1/(2p)
        theta(798) = theta(771)*args%PA(2)-theta(551)*args%PC(2) ! [(0,1,5)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(2)-([(0,0,5)|(0,0,0)]^(1)*args%PC(2)
        theta(799) = theta(771)*args%PA(3)-theta(551)*args%PC(3)+t(185)*5 ! [(0,0,6)|(0,0,0)]^(0) = [(0,0,5)|(0,0,0)]^(0)*args%PA(3)-([(0,0,5)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,4)|(0,0,0)]^(0)-([(0,0,4)|(0,0,0)]^(1))/5/(2p)
        t(187) = (theta(751)-theta(531))*args%rec_p2
        theta(800) = theta(772)*args%PA(1)-theta(552)*args%PC(1)+t(187)*6 ! [(7,0,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(1)-([(6,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/6/(2p)
        theta(801) = theta(772)*args%PA(2)-theta(552)*args%PC(2) ! [(6,1,0)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(2)-([(6,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(802) = theta(772)*args%PA(3)-theta(552)*args%PC(3) ! [(6,0,1)|(0,0,0)]^(0) = [(6,0,0)|(0,0,0)]^(0)*args%PA(3)-([(6,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(803) = theta(773)*args%PA(2)-theta(553)*args%PC(2)+t(187)*1 ! [(5,2,0)|(0,0,0)]^(0) = [(5,1,0)|(0,0,0)]^(0)*args%PA(2)-([(5,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(804) = theta(774)*args%PA(2)-theta(554)*args%PC(2) ! [(5,1,1)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(2)-([(5,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(805) = theta(774)*args%PA(3)-theta(554)*args%PC(3)+t(187)*1 ! [(5,0,2)|(0,0,0)]^(0) = [(5,0,1)|(0,0,0)]^(0)*args%PA(3)-([(5,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,0)|(0,0,0)]^(0)-([(5,0,0)|(0,0,0)]^(1))/1/(2p)
        t(188) = (theta(752)-theta(532))*args%rec_p2
        theta(806) = theta(775)*args%PA(2)-theta(555)*args%PC(2)+t(188)*2 ! [(4,3,0)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(2)-([(4,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(4,1,0)|(0,0,0)]^(0)-([(4,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(807) = theta(775)*args%PA(3)-theta(555)*args%PC(3) ! [(4,2,1)|(0,0,0)]^(0) = [(4,2,0)|(0,0,0)]^(0)*args%PA(3)-([(4,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(808) = theta(777)*args%PA(2)-theta(557)*args%PC(2) ! [(4,1,2)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(2)-([(4,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(189) = (theta(753)-theta(533))*args%rec_p2
        theta(809) = theta(777)*args%PA(3)-theta(557)*args%PC(3)+t(189)*2 ! [(4,0,3)|(0,0,0)]^(0) = [(4,0,2)|(0,0,0)]^(0)*args%PA(3)-([(4,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(4,0,1)|(0,0,0)]^(0)-([(4,0,1)|(0,0,0)]^(1))/2/(2p)
        t(190) = (theta(761)-theta(541))*args%rec_p2
        theta(810) = theta(782)*args%PA(1)-theta(562)*args%PC(1)+t(190)*2 ! [(3,4,0)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(1)-([(2,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,0)|(0,0,0)]^(0)-([(1,4,0)|(0,0,0)]^(1))/2/(2p)
        theta(811) = theta(778)*args%PA(3)-theta(558)*args%PC(3) ! [(3,3,1)|(0,0,0)]^(0) = [(3,3,0)|(0,0,0)]^(0)*args%PA(3)-([(3,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(191) = (theta(763)-theta(543))*args%rec_p2
        theta(812) = theta(784)*args%PA(1)-theta(564)*args%PC(1)+t(191)*2 ! [(3,2,2)|(0,0,0)]^(0) = [(2,2,2)|(0,0,0)]^(0)*args%PA(1)-([(2,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,2)|(0,0,0)]^(0)-([(1,2,2)|(0,0,0)]^(1))/2/(2p)
        theta(813) = theta(781)*args%PA(2)-theta(561)*args%PC(2) ! [(3,1,3)|(0,0,0)]^(0) = [(3,0,3)|(0,0,0)]^(0)*args%PA(2)-([(3,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(192) = (theta(765)-theta(545))*args%rec_p2
        theta(814) = theta(786)*args%PA(1)-theta(566)*args%PC(1)+t(192)*2 ! [(3,0,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(1)-([(2,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,4)|(0,0,0)]^(0)-([(1,0,4)|(0,0,0)]^(1))/2/(2p)
        t(193) = (theta(766)-theta(546))*args%rec_p2
        theta(815) = theta(787)*args%PA(1)-theta(567)*args%PC(1)+t(193)*1 ! [(2,5,0)|(0,0,0)]^(0) = [(1,5,0)|(0,0,0)]^(0)*args%PA(1)-([(1,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        theta(816) = theta(782)*args%PA(3)-theta(562)*args%PC(3) ! [(2,4,1)|(0,0,0)]^(0) = [(2,4,0)|(0,0,0)]^(0)*args%PA(3)-([(2,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(194) = (theta(768)-theta(548))*args%rec_p2
        theta(817) = theta(789)*args%PA(1)-theta(569)*args%PC(1)+t(194)*1 ! [(2,3,2)|(0,0,0)]^(0) = [(1,3,2)|(0,0,0)]^(0)*args%PA(1)-([(1,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,2)|(0,0,0)]^(0)-([(0,3,2)|(0,0,0)]^(1))/1/(2p)
        t(195) = (theta(769)-theta(549))*args%rec_p2
        theta(818) = theta(790)*args%PA(1)-theta(570)*args%PC(1)+t(195)*1 ! [(2,2,3)|(0,0,0)]^(0) = [(1,2,3)|(0,0,0)]^(0)*args%PA(1)-([(1,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,3)|(0,0,0)]^(0)-([(0,2,3)|(0,0,0)]^(1))/1/(2p)
        theta(819) = theta(786)*args%PA(2)-theta(566)*args%PC(2) ! [(2,1,4)|(0,0,0)]^(0) = [(2,0,4)|(0,0,0)]^(0)*args%PA(2)-([(2,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(196) = (theta(771)-theta(551))*args%rec_p2
        theta(820) = theta(792)*args%PA(1)-theta(572)*args%PC(1)+t(196)*1 ! [(2,0,5)|(0,0,0)]^(0) = [(1,0,5)|(0,0,0)]^(0)*args%PA(1)-([(1,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(821) = theta(793)*args%PA(1)-theta(573)*args%PC(1) ! [(1,6,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(1)-([(0,6,0)|(0,0,0)]^(1)*args%PC(1)
        theta(822) = theta(794)*args%PA(1)-theta(574)*args%PC(1) ! [(1,5,1)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(1)-([(0,5,1)|(0,0,0)]^(1)*args%PC(1)
        theta(823) = theta(795)*args%PA(1)-theta(575)*args%PC(1) ! [(1,4,2)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(1)-([(0,4,2)|(0,0,0)]^(1)*args%PC(1)
        theta(824) = theta(796)*args%PA(1)-theta(576)*args%PC(1) ! [(1,3,3)|(0,0,0)]^(0) = [(0,3,3)|(0,0,0)]^(0)*args%PA(1)-([(0,3,3)|(0,0,0)]^(1)*args%PC(1)
        theta(825) = theta(797)*args%PA(1)-theta(577)*args%PC(1) ! [(1,2,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(1)-([(0,2,4)|(0,0,0)]^(1)*args%PC(1)
        theta(826) = theta(798)*args%PA(1)-theta(578)*args%PC(1) ! [(1,1,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(1)-([(0,1,5)|(0,0,0)]^(1)*args%PC(1)
        theta(827) = theta(799)*args%PA(1)-theta(579)*args%PC(1) ! [(1,0,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(1)-([(0,0,6)|(0,0,0)]^(1)*args%PC(1)
        theta(828) = theta(793)*args%PA(2)-theta(573)*args%PC(2)+t(193)*6 ! [(0,7,0)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(2)-([(0,6,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/6/(2p)
        theta(829) = theta(793)*args%PA(3)-theta(573)*args%PC(3) ! [(0,6,1)|(0,0,0)]^(0) = [(0,6,0)|(0,0,0)]^(0)*args%PA(3)-([(0,6,0)|(0,0,0)]^(1)*args%PC(3)
        theta(830) = theta(794)*args%PA(3)-theta(574)*args%PC(3)+t(193)*1 ! [(0,5,2)|(0,0,0)]^(0) = [(0,5,1)|(0,0,0)]^(0)*args%PA(3)-([(0,5,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,0)|(0,0,0)]^(0)-([(0,5,0)|(0,0,0)]^(1))/1/(2p)
        t(197) = (theta(767)-theta(547))*args%rec_p2
        theta(831) = theta(795)*args%PA(3)-theta(575)*args%PC(3)+t(197)*2 ! [(0,4,3)|(0,0,0)]^(0) = [(0,4,2)|(0,0,0)]^(0)*args%PA(3)-([(0,4,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,4,1)|(0,0,0)]^(0)-([(0,4,1)|(0,0,0)]^(1))/2/(2p)
        t(198) = (theta(770)-theta(550))*args%rec_p2
        theta(832) = theta(797)*args%PA(2)-theta(577)*args%PC(2)+t(198)*2 ! [(0,3,4)|(0,0,0)]^(0) = [(0,2,4)|(0,0,0)]^(0)*args%PA(2)-([(0,2,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,4)|(0,0,0)]^(0)-([(0,1,4)|(0,0,0)]^(1))/2/(2p)
        theta(833) = theta(798)*args%PA(2)-theta(578)*args%PC(2)+t(196)*1 ! [(0,2,5)|(0,0,0)]^(0) = [(0,1,5)|(0,0,0)]^(0)*args%PA(2)-([(0,1,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/1/(2p)
        theta(834) = theta(799)*args%PA(2)-theta(579)*args%PC(2) ! [(0,1,6)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(2)-([(0,0,6)|(0,0,0)]^(1)*args%PC(2)
        theta(835) = theta(799)*args%PA(3)-theta(579)*args%PC(3)+t(196)*6 ! [(0,0,7)|(0,0,0)]^(0) = [(0,0,6)|(0,0,0)]^(0)*args%PA(3)-([(0,0,6)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,5)|(0,0,0)]^(0)-([(0,0,5)|(0,0,0)]^(1))/6/(2p)
        t(199) = (theta(772)-theta(552))*args%rec_p2
        theta(836) = theta(800)*args%PA(1)-theta(580)*args%PC(1)+t(199)*7 ! [(8,0,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(1)-([(7,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/7/(2p)
        theta(837) = theta(800)*args%PA(2)-theta(580)*args%PC(2) ! [(7,1,0)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(2)-([(7,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(838) = theta(800)*args%PA(3)-theta(580)*args%PC(3) ! [(7,0,1)|(0,0,0)]^(0) = [(7,0,0)|(0,0,0)]^(0)*args%PA(3)-([(7,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(839) = theta(801)*args%PA(2)-theta(581)*args%PC(2)+t(199)*1 ! [(6,2,0)|(0,0,0)]^(0) = [(6,1,0)|(0,0,0)]^(0)*args%PA(2)-([(6,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(840) = theta(802)*args%PA(2)-theta(582)*args%PC(2) ! [(6,1,1)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(2)-([(6,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(841) = theta(802)*args%PA(3)-theta(582)*args%PC(3)+t(199)*1 ! [(6,0,2)|(0,0,0)]^(0) = [(6,0,1)|(0,0,0)]^(0)*args%PA(3)-([(6,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(6,0,0)|(0,0,0)]^(0)-([(6,0,0)|(0,0,0)]^(1))/1/(2p)
        t(200) = (theta(773)-theta(553))*args%rec_p2
        theta(842) = theta(803)*args%PA(2)-theta(583)*args%PC(2)+t(200)*2 ! [(5,3,0)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(2)-([(5,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,1,0)|(0,0,0)]^(0)-([(5,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(843) = theta(803)*args%PA(3)-theta(583)*args%PC(3) ! [(5,2,1)|(0,0,0)]^(0) = [(5,2,0)|(0,0,0)]^(0)*args%PA(3)-([(5,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(844) = theta(805)*args%PA(2)-theta(585)*args%PC(2) ! [(5,1,2)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(2)-([(5,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(201) = (theta(774)-theta(554))*args%rec_p2
        theta(845) = theta(805)*args%PA(3)-theta(585)*args%PC(3)+t(201)*2 ! [(5,0,3)|(0,0,0)]^(0) = [(5,0,2)|(0,0,0)]^(0)*args%PA(3)-([(5,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,1)|(0,0,0)]^(0)-([(5,0,1)|(0,0,0)]^(1))/2/(2p)
        t(202) = (theta(782)-theta(562))*args%rec_p2
        theta(846) = theta(810)*args%PA(1)-theta(590)*args%PC(1)+t(202)*3 ! [(4,4,0)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(1)-([(3,4,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,4,0)|(0,0,0)]^(0)-([(2,4,0)|(0,0,0)]^(1))/3/(2p)
        theta(847) = theta(806)*args%PA(3)-theta(586)*args%PC(3) ! [(4,3,1)|(0,0,0)]^(0) = [(4,3,0)|(0,0,0)]^(0)*args%PA(3)-([(4,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(203) = (theta(784)-theta(564))*args%rec_p2
        theta(848) = theta(812)*args%PA(1)-theta(592)*args%PC(1)+t(203)*3 ! [(4,2,2)|(0,0,0)]^(0) = [(3,2,2)|(0,0,0)]^(0)*args%PA(1)-([(3,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(2,2,2)|(0,0,0)]^(0)-([(2,2,2)|(0,0,0)]^(1))/3/(2p)
        theta(849) = theta(809)*args%PA(2)-theta(589)*args%PC(2) ! [(4,1,3)|(0,0,0)]^(0) = [(4,0,3)|(0,0,0)]^(0)*args%PA(2)-([(4,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(204) = (theta(786)-theta(566))*args%rec_p2
        theta(850) = theta(814)*args%PA(1)-theta(594)*args%PC(1)+t(204)*3 ! [(4,0,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(1)-([(3,0,4)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,4)|(0,0,0)]^(0)-([(2,0,4)|(0,0,0)]^(1))/3/(2p)
        t(205) = (theta(787)-theta(567))*args%rec_p2
        theta(851) = theta(815)*args%PA(1)-theta(595)*args%PC(1)+t(205)*2 ! [(3,5,0)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(1)-([(2,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,5,0)|(0,0,0)]^(0)-([(1,5,0)|(0,0,0)]^(1))/2/(2p)
        theta(852) = theta(810)*args%PA(3)-theta(590)*args%PC(3) ! [(3,4,1)|(0,0,0)]^(0) = [(3,4,0)|(0,0,0)]^(0)*args%PA(3)-([(3,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(206) = (theta(789)-theta(569))*args%rec_p2
        theta(853) = theta(817)*args%PA(1)-theta(597)*args%PC(1)+t(206)*2 ! [(3,3,2)|(0,0,0)]^(0) = [(2,3,2)|(0,0,0)]^(0)*args%PA(1)-([(2,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,2)|(0,0,0)]^(0)-([(1,3,2)|(0,0,0)]^(1))/2/(2p)
        t(207) = (theta(790)-theta(570))*args%rec_p2
        theta(854) = theta(818)*args%PA(1)-theta(598)*args%PC(1)+t(207)*2 ! [(3,2,3)|(0,0,0)]^(0) = [(2,2,3)|(0,0,0)]^(0)*args%PA(1)-([(2,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,3)|(0,0,0)]^(0)-([(1,2,3)|(0,0,0)]^(1))/2/(2p)
        theta(855) = theta(814)*args%PA(2)-theta(594)*args%PC(2) ! [(3,1,4)|(0,0,0)]^(0) = [(3,0,4)|(0,0,0)]^(0)*args%PA(2)-([(3,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(208) = (theta(792)-theta(572))*args%rec_p2
        theta(856) = theta(820)*args%PA(1)-theta(600)*args%PC(1)+t(208)*2 ! [(3,0,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(1)-([(2,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,5)|(0,0,0)]^(0)-([(1,0,5)|(0,0,0)]^(1))/2/(2p)
        t(209) = (theta(793)-theta(573))*args%rec_p2
        theta(857) = theta(821)*args%PA(1)-theta(601)*args%PC(1)+t(209)*1 ! [(2,6,0)|(0,0,0)]^(0) = [(1,6,0)|(0,0,0)]^(0)*args%PA(1)-([(1,6,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        theta(858) = theta(815)*args%PA(3)-theta(595)*args%PC(3) ! [(2,5,1)|(0,0,0)]^(0) = [(2,5,0)|(0,0,0)]^(0)*args%PA(3)-([(2,5,0)|(0,0,0)]^(1)*args%PC(3)
        t(210) = (theta(795)-theta(575))*args%rec_p2
        theta(859) = theta(823)*args%PA(1)-theta(603)*args%PC(1)+t(210)*1 ! [(2,4,2)|(0,0,0)]^(0) = [(1,4,2)|(0,0,0)]^(0)*args%PA(1)-([(1,4,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,2)|(0,0,0)]^(0)-([(0,4,2)|(0,0,0)]^(1))/1/(2p)
        t(211) = (theta(796)-theta(576))*args%rec_p2
        theta(860) = theta(824)*args%PA(1)-theta(604)*args%PC(1)+t(211)*1 ! [(2,3,3)|(0,0,0)]^(0) = [(1,3,3)|(0,0,0)]^(0)*args%PA(1)-([(1,3,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,3)|(0,0,0)]^(0)-([(0,3,3)|(0,0,0)]^(1))/1/(2p)
        t(212) = (theta(797)-theta(577))*args%rec_p2
        theta(861) = theta(825)*args%PA(1)-theta(605)*args%PC(1)+t(212)*1 ! [(2,2,4)|(0,0,0)]^(0) = [(1,2,4)|(0,0,0)]^(0)*args%PA(1)-([(1,2,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/1/(2p)
        theta(862) = theta(820)*args%PA(2)-theta(600)*args%PC(2) ! [(2,1,5)|(0,0,0)]^(0) = [(2,0,5)|(0,0,0)]^(0)*args%PA(2)-([(2,0,5)|(0,0,0)]^(1)*args%PC(2)
        t(213) = (theta(799)-theta(579))*args%rec_p2
        theta(863) = theta(827)*args%PA(1)-theta(607)*args%PC(1)+t(213)*1 ! [(2,0,6)|(0,0,0)]^(0) = [(1,0,6)|(0,0,0)]^(0)*args%PA(1)-([(1,0,6)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(864) = theta(828)*args%PA(1)-theta(608)*args%PC(1) ! [(1,7,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(1)-([(0,7,0)|(0,0,0)]^(1)*args%PC(1)
        theta(865) = theta(829)*args%PA(1)-theta(609)*args%PC(1) ! [(1,6,1)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(1)-([(0,6,1)|(0,0,0)]^(1)*args%PC(1)
        theta(866) = theta(830)*args%PA(1)-theta(610)*args%PC(1) ! [(1,5,2)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(1)-([(0,5,2)|(0,0,0)]^(1)*args%PC(1)
        theta(867) = theta(831)*args%PA(1)-theta(611)*args%PC(1) ! [(1,4,3)|(0,0,0)]^(0) = [(0,4,3)|(0,0,0)]^(0)*args%PA(1)-([(0,4,3)|(0,0,0)]^(1)*args%PC(1)
        theta(868) = theta(832)*args%PA(1)-theta(612)*args%PC(1) ! [(1,3,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(1)-([(0,3,4)|(0,0,0)]^(1)*args%PC(1)
        theta(869) = theta(833)*args%PA(1)-theta(613)*args%PC(1) ! [(1,2,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(1)-([(0,2,5)|(0,0,0)]^(1)*args%PC(1)
        theta(870) = theta(834)*args%PA(1)-theta(614)*args%PC(1) ! [(1,1,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(1)-([(0,1,6)|(0,0,0)]^(1)*args%PC(1)
        theta(871) = theta(835)*args%PA(1)-theta(615)*args%PC(1) ! [(1,0,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(1)-([(0,0,7)|(0,0,0)]^(1)*args%PC(1)
        theta(872) = theta(828)*args%PA(2)-theta(608)*args%PC(2)+t(209)*7 ! [(0,8,0)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(2)-([(0,7,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/7/(2p)
        theta(873) = theta(828)*args%PA(3)-theta(608)*args%PC(3) ! [(0,7,1)|(0,0,0)]^(0) = [(0,7,0)|(0,0,0)]^(0)*args%PA(3)-([(0,7,0)|(0,0,0)]^(1)*args%PC(3)
        theta(874) = theta(829)*args%PA(3)-theta(609)*args%PC(3)+t(209)*1 ! [(0,6,2)|(0,0,0)]^(0) = [(0,6,1)|(0,0,0)]^(0)*args%PA(3)-([(0,6,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,6,0)|(0,0,0)]^(0)-([(0,6,0)|(0,0,0)]^(1))/1/(2p)
        t(214) = (theta(794)-theta(574))*args%rec_p2
        theta(875) = theta(830)*args%PA(3)-theta(610)*args%PC(3)+t(214)*2 ! [(0,5,3)|(0,0,0)]^(0) = [(0,5,2)|(0,0,0)]^(0)*args%PA(3)-([(0,5,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,1)|(0,0,0)]^(0)-([(0,5,1)|(0,0,0)]^(1))/2/(2p)
        theta(876) = theta(832)*args%PA(2)-theta(612)*args%PC(2)+t(212)*3 ! [(0,4,4)|(0,0,0)]^(0) = [(0,3,4)|(0,0,0)]^(0)*args%PA(2)-([(0,3,4)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,4)|(0,0,0)]^(0)-([(0,2,4)|(0,0,0)]^(1))/3/(2p)
        t(215) = (theta(798)-theta(578))*args%rec_p2
        theta(877) = theta(833)*args%PA(2)-theta(613)*args%PC(2)+t(215)*2 ! [(0,3,5)|(0,0,0)]^(0) = [(0,2,5)|(0,0,0)]^(0)*args%PA(2)-([(0,2,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,5)|(0,0,0)]^(0)-([(0,1,5)|(0,0,0)]^(1))/2/(2p)
        theta(878) = theta(834)*args%PA(2)-theta(614)*args%PC(2)+t(213)*1 ! [(0,2,6)|(0,0,0)]^(0) = [(0,1,6)|(0,0,0)]^(0)*args%PA(2)-([(0,1,6)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/1/(2p)
        theta(879) = theta(835)*args%PA(2)-theta(615)*args%PC(2) ! [(0,1,7)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(2)-([(0,0,7)|(0,0,0)]^(1)*args%PC(2)
        theta(880) = theta(835)*args%PA(3)-theta(615)*args%PC(3)+t(213)*7 ! [(0,0,8)|(0,0,0)]^(0) = [(0,0,7)|(0,0,0)]^(0)*args%PA(3)-([(0,0,7)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,6)|(0,0,0)]^(0)-([(0,0,6)|(0,0,0)]^(1))/7/(2p)
        t(216) = (theta(800)-theta(580))*args%rec_p2
        theta(881) = theta(836)*args%PA(1)-theta(616)*args%PC(1)+t(216)*8 ! [(9,0,0)|(0,0,0)]^(0) = [(8,0,0)|(0,0,0)]^(0)*args%PA(1)-([(8,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(7,0,0)|(0,0,0)]^(0)-([(7,0,0)|(0,0,0)]^(1))/8/(2p)
        theta(882) = theta(836)*args%PA(2)-theta(616)*args%PC(2) ! [(8,1,0)|(0,0,0)]^(0) = [(8,0,0)|(0,0,0)]^(0)*args%PA(2)-([(8,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(883) = theta(836)*args%PA(3)-theta(616)*args%PC(3) ! [(8,0,1)|(0,0,0)]^(0) = [(8,0,0)|(0,0,0)]^(0)*args%PA(3)-([(8,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(884) = theta(837)*args%PA(2)-theta(617)*args%PC(2)+t(216)*1 ! [(7,2,0)|(0,0,0)]^(0) = [(7,1,0)|(0,0,0)]^(0)*args%PA(2)-([(7,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(7,0,0)|(0,0,0)]^(0)-([(7,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(885) = theta(838)*args%PA(2)-theta(618)*args%PC(2) ! [(7,1,1)|(0,0,0)]^(0) = [(7,0,1)|(0,0,0)]^(0)*args%PA(2)-([(7,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(886) = theta(838)*args%PA(3)-theta(618)*args%PC(3)+t(216)*1 ! [(7,0,2)|(0,0,0)]^(0) = [(7,0,1)|(0,0,0)]^(0)*args%PA(3)-([(7,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(7,0,0)|(0,0,0)]^(0)-([(7,0,0)|(0,0,0)]^(1))/1/(2p)
        t(217) = (theta(801)-theta(581))*args%rec_p2
        theta(887) = theta(839)*args%PA(2)-theta(619)*args%PC(2)+t(217)*2 ! [(6,3,0)|(0,0,0)]^(0) = [(6,2,0)|(0,0,0)]^(0)*args%PA(2)-([(6,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(6,1,0)|(0,0,0)]^(0)-([(6,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(888) = theta(839)*args%PA(3)-theta(619)*args%PC(3) ! [(6,2,1)|(0,0,0)]^(0) = [(6,2,0)|(0,0,0)]^(0)*args%PA(3)-([(6,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(889) = theta(841)*args%PA(2)-theta(621)*args%PC(2) ! [(6,1,2)|(0,0,0)]^(0) = [(6,0,2)|(0,0,0)]^(0)*args%PA(2)-([(6,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(218) = (theta(802)-theta(582))*args%rec_p2
        theta(890) = theta(841)*args%PA(3)-theta(621)*args%PC(3)+t(218)*2 ! [(6,0,3)|(0,0,0)]^(0) = [(6,0,2)|(0,0,0)]^(0)*args%PA(3)-([(6,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(6,0,1)|(0,0,0)]^(0)-([(6,0,1)|(0,0,0)]^(1))/2/(2p)
        t(219) = (theta(803)-theta(583))*args%rec_p2
        theta(891) = theta(842)*args%PA(2)-theta(622)*args%PC(2)+t(219)*3 ! [(5,4,0)|(0,0,0)]^(0) = [(5,3,0)|(0,0,0)]^(0)*args%PA(2)-([(5,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(5,2,0)|(0,0,0)]^(0)-([(5,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(892) = theta(842)*args%PA(3)-theta(622)*args%PC(3) ! [(5,3,1)|(0,0,0)]^(0) = [(5,3,0)|(0,0,0)]^(0)*args%PA(3)-([(5,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(220) = (theta(812)-theta(592))*args%rec_p2
        theta(893) = theta(848)*args%PA(1)-theta(628)*args%PC(1)+t(220)*4 ! [(5,2,2)|(0,0,0)]^(0) = [(4,2,2)|(0,0,0)]^(0)*args%PA(1)-([(4,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(3,2,2)|(0,0,0)]^(0)-([(3,2,2)|(0,0,0)]^(1))/4/(2p)
        theta(894) = theta(845)*args%PA(2)-theta(625)*args%PC(2) ! [(5,1,3)|(0,0,0)]^(0) = [(5,0,3)|(0,0,0)]^(0)*args%PA(2)-([(5,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(221) = (theta(805)-theta(585))*args%rec_p2
        theta(895) = theta(845)*args%PA(3)-theta(625)*args%PC(3)+t(221)*3 ! [(5,0,4)|(0,0,0)]^(0) = [(5,0,3)|(0,0,0)]^(0)*args%PA(3)-([(5,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(5,0,2)|(0,0,0)]^(0)-([(5,0,2)|(0,0,0)]^(1))/3/(2p)
        t(222) = (theta(815)-theta(595))*args%rec_p2
        theta(896) = theta(851)*args%PA(1)-theta(631)*args%PC(1)+t(222)*3 ! [(4,5,0)|(0,0,0)]^(0) = [(3,5,0)|(0,0,0)]^(0)*args%PA(1)-([(3,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,5,0)|(0,0,0)]^(0)-([(2,5,0)|(0,0,0)]^(1))/3/(2p)
        theta(897) = theta(846)*args%PA(3)-theta(626)*args%PC(3) ! [(4,4,1)|(0,0,0)]^(0) = [(4,4,0)|(0,0,0)]^(0)*args%PA(3)-([(4,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(223) = (theta(817)-theta(597))*args%rec_p2
        theta(898) = theta(853)*args%PA(1)-theta(633)*args%PC(1)+t(223)*3 ! [(4,3,2)|(0,0,0)]^(0) = [(3,3,2)|(0,0,0)]^(0)*args%PA(1)-([(3,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(2,3,2)|(0,0,0)]^(0)-([(2,3,2)|(0,0,0)]^(1))/3/(2p)
        t(224) = (theta(818)-theta(598))*args%rec_p2
        theta(899) = theta(854)*args%PA(1)-theta(634)*args%PC(1)+t(224)*3 ! [(4,2,3)|(0,0,0)]^(0) = [(3,2,3)|(0,0,0)]^(0)*args%PA(1)-([(3,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(2,2,3)|(0,0,0)]^(0)-([(2,2,3)|(0,0,0)]^(1))/3/(2p)
        theta(900) = theta(850)*args%PA(2)-theta(630)*args%PC(2) ! [(4,1,4)|(0,0,0)]^(0) = [(4,0,4)|(0,0,0)]^(0)*args%PA(2)-([(4,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(225) = (theta(820)-theta(600))*args%rec_p2
        theta(901) = theta(856)*args%PA(1)-theta(636)*args%PC(1)+t(225)*3 ! [(4,0,5)|(0,0,0)]^(0) = [(3,0,5)|(0,0,0)]^(0)*args%PA(1)-([(3,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,5)|(0,0,0)]^(0)-([(2,0,5)|(0,0,0)]^(1))/3/(2p)
        t(226) = (theta(821)-theta(601))*args%rec_p2
        theta(902) = theta(857)*args%PA(1)-theta(637)*args%PC(1)+t(226)*2 ! [(3,6,0)|(0,0,0)]^(0) = [(2,6,0)|(0,0,0)]^(0)*args%PA(1)-([(2,6,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,6,0)|(0,0,0)]^(0)-([(1,6,0)|(0,0,0)]^(1))/2/(2p)
        theta(903) = theta(851)*args%PA(3)-theta(631)*args%PC(3) ! [(3,5,1)|(0,0,0)]^(0) = [(3,5,0)|(0,0,0)]^(0)*args%PA(3)-([(3,5,0)|(0,0,0)]^(1)*args%PC(3)
        t(227) = (theta(823)-theta(603))*args%rec_p2
        theta(904) = theta(859)*args%PA(1)-theta(639)*args%PC(1)+t(227)*2 ! [(3,4,2)|(0,0,0)]^(0) = [(2,4,2)|(0,0,0)]^(0)*args%PA(1)-([(2,4,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,2)|(0,0,0)]^(0)-([(1,4,2)|(0,0,0)]^(1))/2/(2p)
        t(228) = (theta(824)-theta(604))*args%rec_p2
        theta(905) = theta(860)*args%PA(1)-theta(640)*args%PC(1)+t(228)*2 ! [(3,3,3)|(0,0,0)]^(0) = [(2,3,3)|(0,0,0)]^(0)*args%PA(1)-([(2,3,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,3)|(0,0,0)]^(0)-([(1,3,3)|(0,0,0)]^(1))/2/(2p)
        t(229) = (theta(825)-theta(605))*args%rec_p2
        theta(906) = theta(861)*args%PA(1)-theta(641)*args%PC(1)+t(229)*2 ! [(3,2,4)|(0,0,0)]^(0) = [(2,2,4)|(0,0,0)]^(0)*args%PA(1)-([(2,2,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,4)|(0,0,0)]^(0)-([(1,2,4)|(0,0,0)]^(1))/2/(2p)
        theta(907) = theta(856)*args%PA(2)-theta(636)*args%PC(2) ! [(3,1,5)|(0,0,0)]^(0) = [(3,0,5)|(0,0,0)]^(0)*args%PA(2)-([(3,0,5)|(0,0,0)]^(1)*args%PC(2)
        t(230) = (theta(827)-theta(607))*args%rec_p2
        theta(908) = theta(863)*args%PA(1)-theta(643)*args%PC(1)+t(230)*2 ! [(3,0,6)|(0,0,0)]^(0) = [(2,0,6)|(0,0,0)]^(0)*args%PA(1)-([(2,0,6)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,6)|(0,0,0)]^(0)-([(1,0,6)|(0,0,0)]^(1))/2/(2p)
        t(231) = (theta(828)-theta(608))*args%rec_p2
        theta(909) = theta(864)*args%PA(1)-theta(644)*args%PC(1)+t(231)*1 ! [(2,7,0)|(0,0,0)]^(0) = [(1,7,0)|(0,0,0)]^(0)*args%PA(1)-([(1,7,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,7,0)|(0,0,0)]^(0)-([(0,7,0)|(0,0,0)]^(1))/1/(2p)
        theta(910) = theta(857)*args%PA(3)-theta(637)*args%PC(3) ! [(2,6,1)|(0,0,0)]^(0) = [(2,6,0)|(0,0,0)]^(0)*args%PA(3)-([(2,6,0)|(0,0,0)]^(1)*args%PC(3)
        t(232) = (theta(830)-theta(610))*args%rec_p2
        theta(911) = theta(866)*args%PA(1)-theta(646)*args%PC(1)+t(232)*1 ! [(2,5,2)|(0,0,0)]^(0) = [(1,5,2)|(0,0,0)]^(0)*args%PA(1)-([(1,5,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,2)|(0,0,0)]^(0)-([(0,5,2)|(0,0,0)]^(1))/1/(2p)
        t(233) = (theta(831)-theta(611))*args%rec_p2
        theta(912) = theta(867)*args%PA(1)-theta(647)*args%PC(1)+t(233)*1 ! [(2,4,3)|(0,0,0)]^(0) = [(1,4,3)|(0,0,0)]^(0)*args%PA(1)-([(1,4,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,3)|(0,0,0)]^(0)-([(0,4,3)|(0,0,0)]^(1))/1/(2p)
        t(234) = (theta(832)-theta(612))*args%rec_p2
        theta(913) = theta(868)*args%PA(1)-theta(648)*args%PC(1)+t(234)*1 ! [(2,3,4)|(0,0,0)]^(0) = [(1,3,4)|(0,0,0)]^(0)*args%PA(1)-([(1,3,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,4)|(0,0,0)]^(0)-([(0,3,4)|(0,0,0)]^(1))/1/(2p)
        t(235) = (theta(833)-theta(613))*args%rec_p2
        theta(914) = theta(869)*args%PA(1)-theta(649)*args%PC(1)+t(235)*1 ! [(2,2,5)|(0,0,0)]^(0) = [(1,2,5)|(0,0,0)]^(0)*args%PA(1)-([(1,2,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,5)|(0,0,0)]^(0)-([(0,2,5)|(0,0,0)]^(1))/1/(2p)
        theta(915) = theta(863)*args%PA(2)-theta(643)*args%PC(2) ! [(2,1,6)|(0,0,0)]^(0) = [(2,0,6)|(0,0,0)]^(0)*args%PA(2)-([(2,0,6)|(0,0,0)]^(1)*args%PC(2)
        t(236) = (theta(835)-theta(615))*args%rec_p2
        theta(916) = theta(871)*args%PA(1)-theta(651)*args%PC(1)+t(236)*1 ! [(2,0,7)|(0,0,0)]^(0) = [(1,0,7)|(0,0,0)]^(0)*args%PA(1)-([(1,0,7)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,7)|(0,0,0)]^(0)-([(0,0,7)|(0,0,0)]^(1))/1/(2p)
        theta(917) = theta(872)*args%PA(1)-theta(652)*args%PC(1) ! [(1,8,0)|(0,0,0)]^(0) = [(0,8,0)|(0,0,0)]^(0)*args%PA(1)-([(0,8,0)|(0,0,0)]^(1)*args%PC(1)
        theta(918) = theta(873)*args%PA(1)-theta(653)*args%PC(1) ! [(1,7,1)|(0,0,0)]^(0) = [(0,7,1)|(0,0,0)]^(0)*args%PA(1)-([(0,7,1)|(0,0,0)]^(1)*args%PC(1)
        theta(919) = theta(874)*args%PA(1)-theta(654)*args%PC(1) ! [(1,6,2)|(0,0,0)]^(0) = [(0,6,2)|(0,0,0)]^(0)*args%PA(1)-([(0,6,2)|(0,0,0)]^(1)*args%PC(1)
        theta(920) = theta(875)*args%PA(1)-theta(655)*args%PC(1) ! [(1,5,3)|(0,0,0)]^(0) = [(0,5,3)|(0,0,0)]^(0)*args%PA(1)-([(0,5,3)|(0,0,0)]^(1)*args%PC(1)
        theta(921) = theta(876)*args%PA(1)-theta(656)*args%PC(1) ! [(1,4,4)|(0,0,0)]^(0) = [(0,4,4)|(0,0,0)]^(0)*args%PA(1)-([(0,4,4)|(0,0,0)]^(1)*args%PC(1)
        theta(922) = theta(877)*args%PA(1)-theta(657)*args%PC(1) ! [(1,3,5)|(0,0,0)]^(0) = [(0,3,5)|(0,0,0)]^(0)*args%PA(1)-([(0,3,5)|(0,0,0)]^(1)*args%PC(1)
        theta(923) = theta(878)*args%PA(1)-theta(658)*args%PC(1) ! [(1,2,6)|(0,0,0)]^(0) = [(0,2,6)|(0,0,0)]^(0)*args%PA(1)-([(0,2,6)|(0,0,0)]^(1)*args%PC(1)
        theta(924) = theta(879)*args%PA(1)-theta(659)*args%PC(1) ! [(1,1,7)|(0,0,0)]^(0) = [(0,1,7)|(0,0,0)]^(0)*args%PA(1)-([(0,1,7)|(0,0,0)]^(1)*args%PC(1)
        theta(925) = theta(880)*args%PA(1)-theta(660)*args%PC(1) ! [(1,0,8)|(0,0,0)]^(0) = [(0,0,8)|(0,0,0)]^(0)*args%PA(1)-([(0,0,8)|(0,0,0)]^(1)*args%PC(1)
        theta(926) = theta(872)*args%PA(2)-theta(652)*args%PC(2)+t(231)*8 ! [(0,9,0)|(0,0,0)]^(0) = [(0,8,0)|(0,0,0)]^(0)*args%PA(2)-([(0,8,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,7,0)|(0,0,0)]^(0)-([(0,7,0)|(0,0,0)]^(1))/8/(2p)
        theta(927) = theta(872)*args%PA(3)-theta(652)*args%PC(3) ! [(0,8,1)|(0,0,0)]^(0) = [(0,8,0)|(0,0,0)]^(0)*args%PA(3)-([(0,8,0)|(0,0,0)]^(1)*args%PC(3)
        theta(928) = theta(873)*args%PA(3)-theta(653)*args%PC(3)+t(231)*1 ! [(0,7,2)|(0,0,0)]^(0) = [(0,7,1)|(0,0,0)]^(0)*args%PA(3)-([(0,7,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,7,0)|(0,0,0)]^(0)-([(0,7,0)|(0,0,0)]^(1))/1/(2p)
        t(237) = (theta(829)-theta(609))*args%rec_p2
        theta(929) = theta(874)*args%PA(3)-theta(654)*args%PC(3)+t(237)*2 ! [(0,6,3)|(0,0,0)]^(0) = [(0,6,2)|(0,0,0)]^(0)*args%PA(3)-([(0,6,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,6,1)|(0,0,0)]^(0)-([(0,6,1)|(0,0,0)]^(1))/2/(2p)
        theta(930) = theta(875)*args%PA(3)-theta(655)*args%PC(3)+t(232)*3 ! [(0,5,4)|(0,0,0)]^(0) = [(0,5,3)|(0,0,0)]^(0)*args%PA(3)-([(0,5,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,5,2)|(0,0,0)]^(0)-([(0,5,2)|(0,0,0)]^(1))/3/(2p)
        theta(931) = theta(877)*args%PA(2)-theta(657)*args%PC(2)+t(235)*3 ! [(0,4,5)|(0,0,0)]^(0) = [(0,3,5)|(0,0,0)]^(0)*args%PA(2)-([(0,3,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,5)|(0,0,0)]^(0)-([(0,2,5)|(0,0,0)]^(1))/3/(2p)
        t(238) = (theta(834)-theta(614))*args%rec_p2
        theta(932) = theta(878)*args%PA(2)-theta(658)*args%PC(2)+t(238)*2 ! [(0,3,6)|(0,0,0)]^(0) = [(0,2,6)|(0,0,0)]^(0)*args%PA(2)-([(0,2,6)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,6)|(0,0,0)]^(0)-([(0,1,6)|(0,0,0)]^(1))/2/(2p)
        theta(933) = theta(879)*args%PA(2)-theta(659)*args%PC(2)+t(236)*1 ! [(0,2,7)|(0,0,0)]^(0) = [(0,1,7)|(0,0,0)]^(0)*args%PA(2)-([(0,1,7)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,7)|(0,0,0)]^(0)-([(0,0,7)|(0,0,0)]^(1))/1/(2p)
        theta(934) = theta(880)*args%PA(2)-theta(660)*args%PC(2) ! [(0,1,8)|(0,0,0)]^(0) = [(0,0,8)|(0,0,0)]^(0)*args%PA(2)-([(0,0,8)|(0,0,0)]^(1)*args%PC(2)
        theta(935) = theta(880)*args%PA(3)-theta(660)*args%PC(3)+t(236)*8 ! [(0,0,9)|(0,0,0)]^(0) = [(0,0,8)|(0,0,0)]^(0)*args%PA(3)-([(0,0,8)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,7)|(0,0,0)]^(0)-([(0,0,7)|(0,0,0)]^(1))/8/(2p)
        t(239) = (theta(836)-theta(616))*args%rec_p2
        theta(936) = theta(881)*args%PA(1)-theta(661)*args%PC(1)+t(239)*9 ! [(10,0,0)|(0,0,0)]^(0) = [(9,0,0)|(0,0,0)]^(0)*args%PA(1)-([(9,0,0)|(0,0,0)]^(1)*args%PC(1)+(([(8,0,0)|(0,0,0)]^(0)-([(8,0,0)|(0,0,0)]^(1))/9/(2p)
        theta(937) = theta(881)*args%PA(2)-theta(661)*args%PC(2) ! [(9,1,0)|(0,0,0)]^(0) = [(9,0,0)|(0,0,0)]^(0)*args%PA(2)-([(9,0,0)|(0,0,0)]^(1)*args%PC(2)
        theta(938) = theta(881)*args%PA(3)-theta(661)*args%PC(3) ! [(9,0,1)|(0,0,0)]^(0) = [(9,0,0)|(0,0,0)]^(0)*args%PA(3)-([(9,0,0)|(0,0,0)]^(1)*args%PC(3)
        theta(939) = theta(882)*args%PA(2)-theta(662)*args%PC(2)+t(239)*1 ! [(8,2,0)|(0,0,0)]^(0) = [(8,1,0)|(0,0,0)]^(0)*args%PA(2)-([(8,1,0)|(0,0,0)]^(1)*args%PC(2)+(([(8,0,0)|(0,0,0)]^(0)-([(8,0,0)|(0,0,0)]^(1))/1/(2p)
        theta(940) = theta(883)*args%PA(2)-theta(663)*args%PC(2) ! [(8,1,1)|(0,0,0)]^(0) = [(8,0,1)|(0,0,0)]^(0)*args%PA(2)-([(8,0,1)|(0,0,0)]^(1)*args%PC(2)
        theta(941) = theta(883)*args%PA(3)-theta(663)*args%PC(3)+t(239)*1 ! [(8,0,2)|(0,0,0)]^(0) = [(8,0,1)|(0,0,0)]^(0)*args%PA(3)-([(8,0,1)|(0,0,0)]^(1)*args%PC(3)+(([(8,0,0)|(0,0,0)]^(0)-([(8,0,0)|(0,0,0)]^(1))/1/(2p)
        t(240) = (theta(837)-theta(617))*args%rec_p2
        theta(942) = theta(884)*args%PA(2)-theta(664)*args%PC(2)+t(240)*2 ! [(7,3,0)|(0,0,0)]^(0) = [(7,2,0)|(0,0,0)]^(0)*args%PA(2)-([(7,2,0)|(0,0,0)]^(1)*args%PC(2)+(([(7,1,0)|(0,0,0)]^(0)-([(7,1,0)|(0,0,0)]^(1))/2/(2p)
        theta(943) = theta(884)*args%PA(3)-theta(664)*args%PC(3) ! [(7,2,1)|(0,0,0)]^(0) = [(7,2,0)|(0,0,0)]^(0)*args%PA(3)-([(7,2,0)|(0,0,0)]^(1)*args%PC(3)
        theta(944) = theta(886)*args%PA(2)-theta(666)*args%PC(2) ! [(7,1,2)|(0,0,0)]^(0) = [(7,0,2)|(0,0,0)]^(0)*args%PA(2)-([(7,0,2)|(0,0,0)]^(1)*args%PC(2)
        t(241) = (theta(838)-theta(618))*args%rec_p2
        theta(945) = theta(886)*args%PA(3)-theta(666)*args%PC(3)+t(241)*2 ! [(7,0,3)|(0,0,0)]^(0) = [(7,0,2)|(0,0,0)]^(0)*args%PA(3)-([(7,0,2)|(0,0,0)]^(1)*args%PC(3)+(([(7,0,1)|(0,0,0)]^(0)-([(7,0,1)|(0,0,0)]^(1))/2/(2p)
        t(242) = (theta(839)-theta(619))*args%rec_p2
        theta(946) = theta(887)*args%PA(2)-theta(667)*args%PC(2)+t(242)*3 ! [(6,4,0)|(0,0,0)]^(0) = [(6,3,0)|(0,0,0)]^(0)*args%PA(2)-([(6,3,0)|(0,0,0)]^(1)*args%PC(2)+(([(6,2,0)|(0,0,0)]^(0)-([(6,2,0)|(0,0,0)]^(1))/3/(2p)
        theta(947) = theta(887)*args%PA(3)-theta(667)*args%PC(3) ! [(6,3,1)|(0,0,0)]^(0) = [(6,3,0)|(0,0,0)]^(0)*args%PA(3)-([(6,3,0)|(0,0,0)]^(1)*args%PC(3)
        t(243) = (theta(848)-theta(628))*args%rec_p2
        theta(948) = theta(893)*args%PA(1)-theta(673)*args%PC(1)+t(243)*5 ! [(6,2,2)|(0,0,0)]^(0) = [(5,2,2)|(0,0,0)]^(0)*args%PA(1)-([(5,2,2)|(0,0,0)]^(1)*args%PC(1)+(([(4,2,2)|(0,0,0)]^(0)-([(4,2,2)|(0,0,0)]^(1))/5/(2p)
        theta(949) = theta(890)*args%PA(2)-theta(670)*args%PC(2) ! [(6,1,3)|(0,0,0)]^(0) = [(6,0,3)|(0,0,0)]^(0)*args%PA(2)-([(6,0,3)|(0,0,0)]^(1)*args%PC(2)
        t(244) = (theta(841)-theta(621))*args%rec_p2
        theta(950) = theta(890)*args%PA(3)-theta(670)*args%PC(3)+t(244)*3 ! [(6,0,4)|(0,0,0)]^(0) = [(6,0,3)|(0,0,0)]^(0)*args%PA(3)-([(6,0,3)|(0,0,0)]^(1)*args%PC(3)+(([(6,0,2)|(0,0,0)]^(0)-([(6,0,2)|(0,0,0)]^(1))/3/(2p)
        t(245) = (theta(851)-theta(631))*args%rec_p2
        theta(951) = theta(896)*args%PA(1)-theta(676)*args%PC(1)+t(245)*4 ! [(5,5,0)|(0,0,0)]^(0) = [(4,5,0)|(0,0,0)]^(0)*args%PA(1)-([(4,5,0)|(0,0,0)]^(1)*args%PC(1)+(([(3,5,0)|(0,0,0)]^(0)-([(3,5,0)|(0,0,0)]^(1))/4/(2p)
        theta(952) = theta(891)*args%PA(3)-theta(671)*args%PC(3) ! [(5,4,1)|(0,0,0)]^(0) = [(5,4,0)|(0,0,0)]^(0)*args%PA(3)-([(5,4,0)|(0,0,0)]^(1)*args%PC(3)
        t(246) = (theta(853)-theta(633))*args%rec_p2
        theta(953) = theta(898)*args%PA(1)-theta(678)*args%PC(1)+t(246)*4 ! [(5,3,2)|(0,0,0)]^(0) = [(4,3,2)|(0,0,0)]^(0)*args%PA(1)-([(4,3,2)|(0,0,0)]^(1)*args%PC(1)+(([(3,3,2)|(0,0,0)]^(0)-([(3,3,2)|(0,0,0)]^(1))/4/(2p)
        t(247) = (theta(854)-theta(634))*args%rec_p2
        theta(954) = theta(899)*args%PA(1)-theta(679)*args%PC(1)+t(247)*4 ! [(5,2,3)|(0,0,0)]^(0) = [(4,2,3)|(0,0,0)]^(0)*args%PA(1)-([(4,2,3)|(0,0,0)]^(1)*args%PC(1)+(([(3,2,3)|(0,0,0)]^(0)-([(3,2,3)|(0,0,0)]^(1))/4/(2p)
        theta(955) = theta(895)*args%PA(2)-theta(675)*args%PC(2) ! [(5,1,4)|(0,0,0)]^(0) = [(5,0,4)|(0,0,0)]^(0)*args%PA(2)-([(5,0,4)|(0,0,0)]^(1)*args%PC(2)
        t(248) = (theta(856)-theta(636))*args%rec_p2
        theta(956) = theta(901)*args%PA(1)-theta(681)*args%PC(1)+t(248)*4 ! [(5,0,5)|(0,0,0)]^(0) = [(4,0,5)|(0,0,0)]^(0)*args%PA(1)-([(4,0,5)|(0,0,0)]^(1)*args%PC(1)+(([(3,0,5)|(0,0,0)]^(0)-([(3,0,5)|(0,0,0)]^(1))/4/(2p)
        t(249) = (theta(857)-theta(637))*args%rec_p2
        theta(957) = theta(902)*args%PA(1)-theta(682)*args%PC(1)+t(249)*3 ! [(4,6,0)|(0,0,0)]^(0) = [(3,6,0)|(0,0,0)]^(0)*args%PA(1)-([(3,6,0)|(0,0,0)]^(1)*args%PC(1)+(([(2,6,0)|(0,0,0)]^(0)-([(2,6,0)|(0,0,0)]^(1))/3/(2p)
        theta(958) = theta(896)*args%PA(3)-theta(676)*args%PC(3) ! [(4,5,1)|(0,0,0)]^(0) = [(4,5,0)|(0,0,0)]^(0)*args%PA(3)-([(4,5,0)|(0,0,0)]^(1)*args%PC(3)
        t(250) = (theta(859)-theta(639))*args%rec_p2
        theta(959) = theta(904)*args%PA(1)-theta(684)*args%PC(1)+t(250)*3 ! [(4,4,2)|(0,0,0)]^(0) = [(3,4,2)|(0,0,0)]^(0)*args%PA(1)-([(3,4,2)|(0,0,0)]^(1)*args%PC(1)+(([(2,4,2)|(0,0,0)]^(0)-([(2,4,2)|(0,0,0)]^(1))/3/(2p)
        t(251) = (theta(860)-theta(640))*args%rec_p2
        theta(960) = theta(905)*args%PA(1)-theta(685)*args%PC(1)+t(251)*3 ! [(4,3,3)|(0,0,0)]^(0) = [(3,3,3)|(0,0,0)]^(0)*args%PA(1)-([(3,3,3)|(0,0,0)]^(1)*args%PC(1)+(([(2,3,3)|(0,0,0)]^(0)-([(2,3,3)|(0,0,0)]^(1))/3/(2p)
        t(252) = (theta(861)-theta(641))*args%rec_p2
        theta(961) = theta(906)*args%PA(1)-theta(686)*args%PC(1)+t(252)*3 ! [(4,2,4)|(0,0,0)]^(0) = [(3,2,4)|(0,0,0)]^(0)*args%PA(1)-([(3,2,4)|(0,0,0)]^(1)*args%PC(1)+(([(2,2,4)|(0,0,0)]^(0)-([(2,2,4)|(0,0,0)]^(1))/3/(2p)
        theta(962) = theta(901)*args%PA(2)-theta(681)*args%PC(2) ! [(4,1,5)|(0,0,0)]^(0) = [(4,0,5)|(0,0,0)]^(0)*args%PA(2)-([(4,0,5)|(0,0,0)]^(1)*args%PC(2)
        t(253) = (theta(863)-theta(643))*args%rec_p2
        theta(963) = theta(908)*args%PA(1)-theta(688)*args%PC(1)+t(253)*3 ! [(4,0,6)|(0,0,0)]^(0) = [(3,0,6)|(0,0,0)]^(0)*args%PA(1)-([(3,0,6)|(0,0,0)]^(1)*args%PC(1)+(([(2,0,6)|(0,0,0)]^(0)-([(2,0,6)|(0,0,0)]^(1))/3/(2p)
        t(254) = (theta(864)-theta(644))*args%rec_p2
        theta(964) = theta(909)*args%PA(1)-theta(689)*args%PC(1)+t(254)*2 ! [(3,7,0)|(0,0,0)]^(0) = [(2,7,0)|(0,0,0)]^(0)*args%PA(1)-([(2,7,0)|(0,0,0)]^(1)*args%PC(1)+(([(1,7,0)|(0,0,0)]^(0)-([(1,7,0)|(0,0,0)]^(1))/2/(2p)
        theta(965) = theta(902)*args%PA(3)-theta(682)*args%PC(3) ! [(3,6,1)|(0,0,0)]^(0) = [(3,6,0)|(0,0,0)]^(0)*args%PA(3)-([(3,6,0)|(0,0,0)]^(1)*args%PC(3)
        t(255) = (theta(866)-theta(646))*args%rec_p2
        theta(966) = theta(911)*args%PA(1)-theta(691)*args%PC(1)+t(255)*2 ! [(3,5,2)|(0,0,0)]^(0) = [(2,5,2)|(0,0,0)]^(0)*args%PA(1)-([(2,5,2)|(0,0,0)]^(1)*args%PC(1)+(([(1,5,2)|(0,0,0)]^(0)-([(1,5,2)|(0,0,0)]^(1))/2/(2p)
        t(256) = (theta(867)-theta(647))*args%rec_p2
        theta(967) = theta(912)*args%PA(1)-theta(692)*args%PC(1)+t(256)*2 ! [(3,4,3)|(0,0,0)]^(0) = [(2,4,3)|(0,0,0)]^(0)*args%PA(1)-([(2,4,3)|(0,0,0)]^(1)*args%PC(1)+(([(1,4,3)|(0,0,0)]^(0)-([(1,4,3)|(0,0,0)]^(1))/2/(2p)
        t(257) = (theta(868)-theta(648))*args%rec_p2
        theta(968) = theta(913)*args%PA(1)-theta(693)*args%PC(1)+t(257)*2 ! [(3,3,4)|(0,0,0)]^(0) = [(2,3,4)|(0,0,0)]^(0)*args%PA(1)-([(2,3,4)|(0,0,0)]^(1)*args%PC(1)+(([(1,3,4)|(0,0,0)]^(0)-([(1,3,4)|(0,0,0)]^(1))/2/(2p)
        t(258) = (theta(869)-theta(649))*args%rec_p2
        theta(969) = theta(914)*args%PA(1)-theta(694)*args%PC(1)+t(258)*2 ! [(3,2,5)|(0,0,0)]^(0) = [(2,2,5)|(0,0,0)]^(0)*args%PA(1)-([(2,2,5)|(0,0,0)]^(1)*args%PC(1)+(([(1,2,5)|(0,0,0)]^(0)-([(1,2,5)|(0,0,0)]^(1))/2/(2p)
        theta(970) = theta(908)*args%PA(2)-theta(688)*args%PC(2) ! [(3,1,6)|(0,0,0)]^(0) = [(3,0,6)|(0,0,0)]^(0)*args%PA(2)-([(3,0,6)|(0,0,0)]^(1)*args%PC(2)
        t(259) = (theta(871)-theta(651))*args%rec_p2
        theta(971) = theta(916)*args%PA(1)-theta(696)*args%PC(1)+t(259)*2 ! [(3,0,7)|(0,0,0)]^(0) = [(2,0,7)|(0,0,0)]^(0)*args%PA(1)-([(2,0,7)|(0,0,0)]^(1)*args%PC(1)+(([(1,0,7)|(0,0,0)]^(0)-([(1,0,7)|(0,0,0)]^(1))/2/(2p)
        t(260) = (theta(872)-theta(652))*args%rec_p2
        theta(972) = theta(917)*args%PA(1)-theta(697)*args%PC(1)+t(260)*1 ! [(2,8,0)|(0,0,0)]^(0) = [(1,8,0)|(0,0,0)]^(0)*args%PA(1)-([(1,8,0)|(0,0,0)]^(1)*args%PC(1)+(([(0,8,0)|(0,0,0)]^(0)-([(0,8,0)|(0,0,0)]^(1))/1/(2p)
        theta(973) = theta(909)*args%PA(3)-theta(689)*args%PC(3) ! [(2,7,1)|(0,0,0)]^(0) = [(2,7,0)|(0,0,0)]^(0)*args%PA(3)-([(2,7,0)|(0,0,0)]^(1)*args%PC(3)
        t(261) = (theta(874)-theta(654))*args%rec_p2
        theta(974) = theta(919)*args%PA(1)-theta(699)*args%PC(1)+t(261)*1 ! [(2,6,2)|(0,0,0)]^(0) = [(1,6,2)|(0,0,0)]^(0)*args%PA(1)-([(1,6,2)|(0,0,0)]^(1)*args%PC(1)+(([(0,6,2)|(0,0,0)]^(0)-([(0,6,2)|(0,0,0)]^(1))/1/(2p)
        t(262) = (theta(875)-theta(655))*args%rec_p2
        theta(975) = theta(920)*args%PA(1)-theta(700)*args%PC(1)+t(262)*1 ! [(2,5,3)|(0,0,0)]^(0) = [(1,5,3)|(0,0,0)]^(0)*args%PA(1)-([(1,5,3)|(0,0,0)]^(1)*args%PC(1)+(([(0,5,3)|(0,0,0)]^(0)-([(0,5,3)|(0,0,0)]^(1))/1/(2p)
        t(263) = (theta(876)-theta(656))*args%rec_p2
        theta(976) = theta(921)*args%PA(1)-theta(701)*args%PC(1)+t(263)*1 ! [(2,4,4)|(0,0,0)]^(0) = [(1,4,4)|(0,0,0)]^(0)*args%PA(1)-([(1,4,4)|(0,0,0)]^(1)*args%PC(1)+(([(0,4,4)|(0,0,0)]^(0)-([(0,4,4)|(0,0,0)]^(1))/1/(2p)
        t(264) = (theta(877)-theta(657))*args%rec_p2
        theta(977) = theta(922)*args%PA(1)-theta(702)*args%PC(1)+t(264)*1 ! [(2,3,5)|(0,0,0)]^(0) = [(1,3,5)|(0,0,0)]^(0)*args%PA(1)-([(1,3,5)|(0,0,0)]^(1)*args%PC(1)+(([(0,3,5)|(0,0,0)]^(0)-([(0,3,5)|(0,0,0)]^(1))/1/(2p)
        t(265) = (theta(878)-theta(658))*args%rec_p2
        theta(978) = theta(923)*args%PA(1)-theta(703)*args%PC(1)+t(265)*1 ! [(2,2,6)|(0,0,0)]^(0) = [(1,2,6)|(0,0,0)]^(0)*args%PA(1)-([(1,2,6)|(0,0,0)]^(1)*args%PC(1)+(([(0,2,6)|(0,0,0)]^(0)-([(0,2,6)|(0,0,0)]^(1))/1/(2p)
        theta(979) = theta(916)*args%PA(2)-theta(696)*args%PC(2) ! [(2,1,7)|(0,0,0)]^(0) = [(2,0,7)|(0,0,0)]^(0)*args%PA(2)-([(2,0,7)|(0,0,0)]^(1)*args%PC(2)
        t(266) = (theta(880)-theta(660))*args%rec_p2
        theta(980) = theta(925)*args%PA(1)-theta(705)*args%PC(1)+t(266)*1 ! [(2,0,8)|(0,0,0)]^(0) = [(1,0,8)|(0,0,0)]^(0)*args%PA(1)-([(1,0,8)|(0,0,0)]^(1)*args%PC(1)+(([(0,0,8)|(0,0,0)]^(0)-([(0,0,8)|(0,0,0)]^(1))/1/(2p)
        theta(981) = theta(926)*args%PA(1)-theta(706)*args%PC(1) ! [(1,9,0)|(0,0,0)]^(0) = [(0,9,0)|(0,0,0)]^(0)*args%PA(1)-([(0,9,0)|(0,0,0)]^(1)*args%PC(1)
        theta(982) = theta(927)*args%PA(1)-theta(707)*args%PC(1) ! [(1,8,1)|(0,0,0)]^(0) = [(0,8,1)|(0,0,0)]^(0)*args%PA(1)-([(0,8,1)|(0,0,0)]^(1)*args%PC(1)
        theta(983) = theta(928)*args%PA(1)-theta(708)*args%PC(1) ! [(1,7,2)|(0,0,0)]^(0) = [(0,7,2)|(0,0,0)]^(0)*args%PA(1)-([(0,7,2)|(0,0,0)]^(1)*args%PC(1)
        theta(984) = theta(929)*args%PA(1)-theta(709)*args%PC(1) ! [(1,6,3)|(0,0,0)]^(0) = [(0,6,3)|(0,0,0)]^(0)*args%PA(1)-([(0,6,3)|(0,0,0)]^(1)*args%PC(1)
        theta(985) = theta(930)*args%PA(1)-theta(710)*args%PC(1) ! [(1,5,4)|(0,0,0)]^(0) = [(0,5,4)|(0,0,0)]^(0)*args%PA(1)-([(0,5,4)|(0,0,0)]^(1)*args%PC(1)
        theta(986) = theta(931)*args%PA(1)-theta(711)*args%PC(1) ! [(1,4,5)|(0,0,0)]^(0) = [(0,4,5)|(0,0,0)]^(0)*args%PA(1)-([(0,4,5)|(0,0,0)]^(1)*args%PC(1)
        theta(987) = theta(932)*args%PA(1)-theta(712)*args%PC(1) ! [(1,3,6)|(0,0,0)]^(0) = [(0,3,6)|(0,0,0)]^(0)*args%PA(1)-([(0,3,6)|(0,0,0)]^(1)*args%PC(1)
        theta(988) = theta(933)*args%PA(1)-theta(713)*args%PC(1) ! [(1,2,7)|(0,0,0)]^(0) = [(0,2,7)|(0,0,0)]^(0)*args%PA(1)-([(0,2,7)|(0,0,0)]^(1)*args%PC(1)
        theta(989) = theta(934)*args%PA(1)-theta(714)*args%PC(1) ! [(1,1,8)|(0,0,0)]^(0) = [(0,1,8)|(0,0,0)]^(0)*args%PA(1)-([(0,1,8)|(0,0,0)]^(1)*args%PC(1)
        theta(990) = theta(935)*args%PA(1)-theta(715)*args%PC(1) ! [(1,0,9)|(0,0,0)]^(0) = [(0,0,9)|(0,0,0)]^(0)*args%PA(1)-([(0,0,9)|(0,0,0)]^(1)*args%PC(1)
        theta(991) = theta(926)*args%PA(2)-theta(706)*args%PC(2)+t(260)*9 ! [(0,10,0)|(0,0,0)]^(0) = [(0,9,0)|(0,0,0)]^(0)*args%PA(2)-([(0,9,0)|(0,0,0)]^(1)*args%PC(2)+(([(0,8,0)|(0,0,0)]^(0)-([(0,8,0)|(0,0,0)]^(1))/9/(2p)
        theta(992) = theta(926)*args%PA(3)-theta(706)*args%PC(3) ! [(0,9,1)|(0,0,0)]^(0) = [(0,9,0)|(0,0,0)]^(0)*args%PA(3)-([(0,9,0)|(0,0,0)]^(1)*args%PC(3)
        theta(993) = theta(927)*args%PA(3)-theta(707)*args%PC(3)+t(260)*1 ! [(0,8,2)|(0,0,0)]^(0) = [(0,8,1)|(0,0,0)]^(0)*args%PA(3)-([(0,8,1)|(0,0,0)]^(1)*args%PC(3)+(([(0,8,0)|(0,0,0)]^(0)-([(0,8,0)|(0,0,0)]^(1))/1/(2p)
        t(267) = (theta(873)-theta(653))*args%rec_p2
        theta(994) = theta(928)*args%PA(3)-theta(708)*args%PC(3)+t(267)*2 ! [(0,7,3)|(0,0,0)]^(0) = [(0,7,2)|(0,0,0)]^(0)*args%PA(3)-([(0,7,2)|(0,0,0)]^(1)*args%PC(3)+(([(0,7,1)|(0,0,0)]^(0)-([(0,7,1)|(0,0,0)]^(1))/2/(2p)
        theta(995) = theta(929)*args%PA(3)-theta(709)*args%PC(3)+t(261)*3 ! [(0,6,4)|(0,0,0)]^(0) = [(0,6,3)|(0,0,0)]^(0)*args%PA(3)-([(0,6,3)|(0,0,0)]^(1)*args%PC(3)+(([(0,6,2)|(0,0,0)]^(0)-([(0,6,2)|(0,0,0)]^(1))/3/(2p)
        theta(996) = theta(931)*args%PA(2)-theta(711)*args%PC(2)+t(264)*4 ! [(0,5,5)|(0,0,0)]^(0) = [(0,4,5)|(0,0,0)]^(0)*args%PA(2)-([(0,4,5)|(0,0,0)]^(1)*args%PC(2)+(([(0,3,5)|(0,0,0)]^(0)-([(0,3,5)|(0,0,0)]^(1))/4/(2p)
        theta(997) = theta(932)*args%PA(2)-theta(712)*args%PC(2)+t(265)*3 ! [(0,4,6)|(0,0,0)]^(0) = [(0,3,6)|(0,0,0)]^(0)*args%PA(2)-([(0,3,6)|(0,0,0)]^(1)*args%PC(2)+(([(0,2,6)|(0,0,0)]^(0)-([(0,2,6)|(0,0,0)]^(1))/3/(2p)
        t(268) = (theta(879)-theta(659))*args%rec_p2
        theta(998) = theta(933)*args%PA(2)-theta(713)*args%PC(2)+t(268)*2 ! [(0,3,7)|(0,0,0)]^(0) = [(0,2,7)|(0,0,0)]^(0)*args%PA(2)-([(0,2,7)|(0,0,0)]^(1)*args%PC(2)+(([(0,1,7)|(0,0,0)]^(0)-([(0,1,7)|(0,0,0)]^(1))/2/(2p)
        theta(999) = theta(934)*args%PA(2)-theta(714)*args%PC(2)+t(266)*1 ! [(0,2,8)|(0,0,0)]^(0) = [(0,1,8)|(0,0,0)]^(0)*args%PA(2)-([(0,1,8)|(0,0,0)]^(1)*args%PC(2)+(([(0,0,8)|(0,0,0)]^(0)-([(0,0,8)|(0,0,0)]^(1))/1/(2p)
        theta(1000) = theta(935)*args%PA(2)-theta(715)*args%PC(2) ! [(0,1,9)|(0,0,0)]^(0) = [(0,0,9)|(0,0,0)]^(0)*args%PA(2)-([(0,0,9)|(0,0,0)]^(1)*args%PC(2)
        theta(1001) = theta(935)*args%PA(3)-theta(715)*args%PC(3)+t(266)*9 ! [(0,0,10)|(0,0,0)]^(0) = [(0,0,9)|(0,0,0)]^(0)*args%PA(3)-([(0,0,9)|(0,0,0)]^(1)*args%PC(3)+(([(0,0,8)|(0,0,0)]^(0)-([(0,0,8)|(0,0,0)]^(1))/9/(2p)
    end subroutine
end module
